/* Generated by JTB 1.4.7 */
package EDU.purdue.jtb.visitor;

import EDU.purdue.jtb.syntaxtree.*;

/**
 * All "Ret" visitors must implement this interface.
 * @param <R> - The user return information type
 */
public interface IRetVisitor<R> {

  /*
   * Base "Ret" visit methods
   */

  /**
   * Visits a {@link NodeChoice} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final NodeChoice n);

  /**
   * Visits a {@link NodeList} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final NodeList n);

  /**
   * Visits a {@link NodeListOptional} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final NodeListOptional n);

  /**
   * Visits a {@link NodeOptional} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final NodeOptional n);

  /**
   * Visits a {@link NodeSequence} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final NodeSequence n);

  /**
   * Visits a {@link NodeTCF} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final NodeTCF n);

  /**
   * Visits a {@link NodeToken} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final NodeToken n);

  /*
   * User grammar generated visit methods
   */

  /**
   * Visits a {@link JavaCCInput} node, whose children are the following :
   * <p>
   * f0 -> JavaCCOptions()<br>
   * f1 -> "PARSER_BEGIN"<br>
   * f2 -> "("<br>
   * f3 -> IdentifierAsString()<br>
   * f4 -> ")"<br>
   * f5 -> CompilationUnit()<br>
   * f6 -> "PARSER_END"<br>
   * f7 -> "("<br>
   * f8 -> IdentifierAsString()<br>
   * f9 -> ")"<br>
   * f10 -> ( Production() )+<br>
   * f11 -> <EOF><br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final JavaCCInput n);

  /**
   * Visits a {@link JavaCCOptions} node, whose children are the following :
   * <p>
   * f0 -> [ #0 "options" #1 "{"<br>
   * .. .. . #2 ( OptionBinding() )*<br>
   * .. .. . #3 "}" ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final JavaCCOptions n);

  /**
   * Visits a {@link OptionBinding} node, whose children are the following :
   * <p>
   * f0 -> ( %0 <IDENTIFIER><br>
   * .. .. | %1 "LOOKAHEAD"<br>
   * .. .. | %2 "IGNORE_CASE"<br>
   * .. .. | %3 "static" )<br>
   * f1 -> "="<br>
   * f2 -> ( %0 IntegerLiteral()<br>
   * .. .. | %1 BooleanLiteral()<br>
   * .. .. | %2 StringLiteral() )<br>
   * f3 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final OptionBinding n);

  /**
   * Visits a {@link Production} node, whose children are the following :
   * <p>
   * f0 -> . %0 JavaCodeProduction()<br>
   * .. .. | %1 RegularExprProduction()<br>
   * .. .. | %2 TokenManagerDecls()<br>
   * .. .. | %3 BNFProduction()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final Production n);

  /**
   * Visits a {@link JavaCodeProduction} node, whose children are the following :
   * <p>
   * f0 -> "JAVACODE"<br>
   * f1 -> AccessModifier()<br>
   * f2 -> ResultType()<br>
   * f3 -> IdentifierAsString()<br>
   * f4 -> FormalParameters()<br>
   * f5 -> [ #0 "throws" #1 Name()<br>
   * .. .. . #2 ( $0 "," $1 Name() )* ]<br>
   * f6 -> Block()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final JavaCodeProduction n);

  /**
   * Visits a {@link BNFProduction} node, whose children are the following :
   * <p>
   * f0 -> AccessModifier()<br>
   * f1 -> ResultType()<br>
   * f2 -> IdentifierAsString()<br>
   * f3 -> FormalParameters()<br>
   * f4 -> [ #0 "throws" #1 Name()<br>
   * .. .. . #2 ( $0 "," $1 Name() )* ]<br>
   * f5 -> [ "!" ]<br>
   * f6 -> ":"<br>
   * f7 -> Block()<br>
   * f8 -> "{"<br>
   * f9 -> ExpansionChoices()<br>
   * f10 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final BNFProduction n);

  /**
   * Visits a {@link AccessModifier} node, whose children are the following :
   * <p>
   * f0 -> ( %0 "public"<br>
   * .. .. | %1 "protected"<br>
   * .. .. | %2 "private"<br>
   * .. .. | %3 "final" )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final AccessModifier n);

  /**
   * Visits a {@link RegularExprProduction} node, whose children are the following :
   * <p>
   * f0 -> [ %0 #0 "<" #1 "*" #2 ">"<br>
   * .. .. | %1 #0 "<" #1 <IDENTIFIER><br>
   * .. .. . .. #2 ( $0 "," $1 <IDENTIFIER> )*<br>
   * .. .. . .. #3 ">" ]<br>
   * f1 -> RegExprKind()<br>
   * f2 -> [ #0 "[" #1 "IGNORE_CASE" #2 "]" ]<br>
   * f3 -> ":"<br>
   * f4 -> "{"<br>
   * f5 -> RegExprSpec()<br>
   * f6 -> ( #0 "|" #1 RegExprSpec() )*<br>
   * f7 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final RegularExprProduction n);

  /**
   * Visits a {@link TokenManagerDecls} node, whose children are the following :
   * <p>
   * f0 -> "TOKEN_MGR_DECLS"<br>
   * f1 -> ":"<br>
   * f2 -> ClassOrInterfaceBody()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final TokenManagerDecls n);

  /**
   * Visits a {@link RegExprKind} node, whose children are the following :
   * <p>
   * f0 -> . %0 "TOKEN"<br>
   * .. .. | %1 "SPECIAL_TOKEN"<br>
   * .. .. | %2 "SKIP"<br>
   * .. .. | %3 "MORE"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final RegExprKind n);

  /**
   * Visits a {@link RegExprSpec} node, whose children are the following :
   * <p>
   * f0 -> RegularExpression()<br>
   * f1 -> [ "!" ]<br>
   * f2 -> [ Block() ]<br>
   * f3 -> [ #0 ":" #1 <IDENTIFIER> ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final RegExprSpec n);

  /**
   * Visits a {@link ExpansionChoices} node, whose children are the following :
   * <p>
   * f0 -> Expansion()<br>
   * f1 -> ( #0 "|" #1 Expansion() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ExpansionChoices n);

  /**
   * Visits a {@link Expansion} node, whose children are the following :
   * <p>
   * f0 -> ( #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")" )?<br>
   * f1 -> ( ExpansionUnit() )+<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final Expansion n);

  /**
   * Visits a {@link LocalLookahead} node, whose children are the following :
   * <p>
   * f0 -> [ IntegerLiteral() ]<br>
   * f1 -> [ "," ]<br>
   * f2 -> [ ExpansionChoices() ]<br>
   * f3 -> [ "," ]<br>
   * f4 -> [ #0 "{" #1 Expression() #2 "}" ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final LocalLookahead n);

  /**
   * Visits a {@link ExpansionUnit} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"<br>
   * .. .. | %1 Block()<br>
   * .. .. | %2 #0 "[" #1 ExpansionChoices() #2 "]"<br>
   * .. .. | %3 ExpansionUnitTCF()<br>
   * .. .. | %4 #0 [ $0 PrimaryExpression() $1 "=" ]<br>
   * .. .. . .. #1 ( &0 $0 IdentifierAsString() $1 Arguments()<br>
   * .. .. . .. .. . .. $2 [ "!" ]<br>
   * .. .. . .. .. | &1 $0 RegularExpression()<br>
   * .. .. . .. .. . .. $1 [ ?0 "." ?1 <IDENTIFIER> ]<br>
   * .. .. . .. .. . .. $2 [ "!" ] )<br>
   * .. .. | %5 #0 "(" #1 ExpansionChoices() #2 ")"<br>
   * .. .. . .. #3 ( &0 "+"<br>
   * .. .. . .. .. | &1 "*"<br>
   * .. .. . .. .. | &2 "?" )?<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ExpansionUnit n);

  /**
   * Visits a {@link ExpansionUnitTCF} node, whose children are the following :
   * <p>
   * f0 -> "try"<br>
   * f1 -> "{"<br>
   * f2 -> ExpansionChoices()<br>
   * f3 -> "}"<br>
   * f4 -> ( #0 "catch" #1 "(" #2 Name() #3 <IDENTIFIER> #4 ")" #5 Block() )*<br>
   * f5 -> [ #0 "finally" #1 Block() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ExpansionUnitTCF n);

  /**
   * Visits a {@link RegularExpression} node, whose children are the following :
   * <p>
   * f0 -> . %0 StringLiteral()<br>
   * .. .. | %1 #0 "<"<br>
   * .. .. . .. #1 [ $0 [ "#" ]<br>
   * .. .. . .. .. . $1 IdentifierAsString() $2 ":" ]<br>
   * .. .. . .. #2 ComplexRegularExpressionChoices() #3 ">"<br>
   * .. .. | %2 #0 "<" #1 IdentifierAsString() #2 ">"<br>
   * .. .. | %3 #0 "<" #1 "EOF" #2 ">"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final RegularExpression n);

  /**
   * Visits a {@link ComplexRegularExpressionChoices} node, whose children are the following :
   * <p>
   * f0 -> ComplexRegularExpression()<br>
   * f1 -> ( #0 "|" #1 ComplexRegularExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ComplexRegularExpressionChoices n);

  /**
   * Visits a {@link ComplexRegularExpression} node, whose children are the following :
   * <p>
   * f0 -> ( ComplexRegularExpressionUnit() )+<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ComplexRegularExpression n);

  /**
   * Visits a {@link ComplexRegularExpressionUnit} node, whose children are the following :
   * <p>
   * f0 -> . %0 StringLiteral()<br>
   * .. .. | %1 #0 "<" #1 IdentifierAsString() #2 ">"<br>
   * .. .. | %2 CharacterList()<br>
   * .. .. | %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"<br>
   * .. .. . .. #3 ( &0 "+"<br>
   * .. .. . .. .. | &1 "*"<br>
   * .. .. . .. .. | &2 "?"<br>
   * .. .. . .. .. | &3 $0 "{" $1 IntegerLiteral()<br>
   * .. .. . .. .. . .. $2 [ ?0 ","<br>
   * .. .. . .. .. . .. .. . ?1 [ IntegerLiteral() ] ]<br>
   * .. .. . .. .. . .. $3 "}" )?<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ComplexRegularExpressionUnit n);

  /**
   * Visits a {@link CharacterList} node, whose children are the following :
   * <p>
   * f0 -> [ "~" ]<br>
   * f1 -> "["<br>
   * f2 -> [ #0 CharacterDescriptor()<br>
   * .. .. . #1 ( $0 "," $1 CharacterDescriptor() )* ]<br>
   * f3 -> "]"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final CharacterList n);

  /**
   * Visits a {@link CharacterDescriptor} node, whose children are the following :
   * <p>
   * f0 -> StringLiteral()<br>
   * f1 -> [ #0 "-" #1 StringLiteral() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final CharacterDescriptor n);

  /**
   * Visits a {@link IdentifierAsString} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final IdentifierAsString n);

  /**
   * Visits a {@link JavaIdentifier} node, whose children are the following :
   * <p>
   * f0 -> ( %00 <IDENTIFIER><br>
   * .. .. | %01 "LOOKAHEAD"<br>
   * .. .. | %02 "IGNORE_CASE"<br>
   * .. .. | %03 "PARSER_BEGIN"<br>
   * .. .. | %04 "PARSER_END"<br>
   * .. .. | %05 "JAVACODE"<br>
   * .. .. | %06 "TOKEN"<br>
   * .. .. | %07 "SPECIAL_TOKEN"<br>
   * .. .. | %08 "MORE"<br>
   * .. .. | %09 "SKIP"<br>
   * .. .. | %10 "TOKEN_MGR_DECLS"<br>
   * .. .. | %11 "EOF" )<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final JavaIdentifier n);

  /**
   * Visits a {@link CompilationUnit} node, whose children are the following :
   * <p>
   * f0 -> [ PackageDeclaration() ]<br>
   * f1 -> ( ImportDeclaration() )*<br>
   * f2 -> ( TypeDeclaration() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final CompilationUnit n);

  /**
   * Visits a {@link PackageDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "package"<br>
   * f1 -> Name()<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final PackageDeclaration n);

  /**
   * Visits a {@link ImportDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "import"<br>
   * f1 -> [ "static" ]<br>
   * f2 -> Name()<br>
   * f3 -> [ #0 "." #1 "*" ]<br>
   * f4 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ImportDeclaration n);

  /**
   * Visits a {@link Modifiers} node, whose children are the following :
   * <p>
   * f0 -> ( ( %00 "public"<br>
   * .. .. . | %01 "static"<br>
   * .. .. . | %02 "protected"<br>
   * .. .. . | %03 "private"<br>
   * .. .. . | %04 "final"<br>
   * .. .. . | %05 "abstract"<br>
   * .. .. . | %06 "synchronized"<br>
   * .. .. . | %07 "native"<br>
   * .. .. . | %08 "transient"<br>
   * .. .. . | %09 "volatile"<br>
   * .. .. . | %10 "strictfp"<br>
   * .. .. . | %11 Annotation() ) )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final Modifiers n);

  /**
   * Visits a {@link TypeDeclaration} node, whose children are the following :
   * <p>
   * f0 -> . %0 ";"<br>
   * .. .. | %1 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &1 EnumDeclaration()<br>
   * .. .. . .. .. | &2 AnnotationTypeDeclaration() )<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final TypeDeclaration n);

  /**
   * Visits a {@link ClassOrInterfaceDeclaration} node, whose children are the following :
   * <p>
   * f0 -> ( %0 "class"<br>
   * .. .. | %1 "interface" )<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> [ TypeParameters() ]<br>
   * f3 -> [ ExtendsList() ]<br>
   * f4 -> [ ImplementsList() ]<br>
   * f5 -> ClassOrInterfaceBody()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ClassOrInterfaceDeclaration n);

  /**
   * Visits a {@link ExtendsList} node, whose children are the following :
   * <p>
   * f0 -> "extends"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "," #1 ClassOrInterfaceType() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ExtendsList n);

  /**
   * Visits a {@link ImplementsList} node, whose children are the following :
   * <p>
   * f0 -> "implements"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "," #1 ClassOrInterfaceType() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ImplementsList n);

  /**
   * Visits a {@link EnumDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "enum"<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> [ ImplementsList() ]<br>
   * f3 -> EnumBody()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final EnumDeclaration n);

  /**
   * Visits a {@link EnumBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> [ #0 EnumConstant()<br>
   * .. .. . #1 ( $0 "," $1 EnumConstant() )* ]<br>
   * f2 -> [ "," ]<br>
   * f3 -> [ #0 ";"<br>
   * .. .. . #1 ( ClassOrInterfaceBodyDeclaration() )* ]<br>
   * f4 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final EnumBody n);

  /**
   * Visits a {@link EnumConstant} node, whose children are the following :
   * <p>
   * f0 -> Modifiers()<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> [ Arguments() ]<br>
   * f3 -> [ ClassOrInterfaceBody() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final EnumConstant n);

  /**
   * Visits a {@link TypeParameters} node, whose children are the following :
   * <p>
   * f0 -> "<"<br>
   * f1 -> TypeParameter()<br>
   * f2 -> ( #0 "," #1 TypeParameter() )*<br>
   * f3 -> ">"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final TypeParameters n);

  /**
   * Visits a {@link TypeParameter} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> [ TypeBound() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final TypeParameter n);

  /**
   * Visits a {@link TypeBound} node, whose children are the following :
   * <p>
   * f0 -> "extends"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "&" #1 ClassOrInterfaceType() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final TypeBound n);

  /**
   * Visits a {@link ClassOrInterfaceBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( ClassOrInterfaceBodyDeclaration() )*<br>
   * f2 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ClassOrInterfaceBody n);

  /**
   * Visits a {@link ClassOrInterfaceBodyDeclaration} node, whose children are the following :
   * <p>
   * f0 -> . %0 Initializer()<br>
   * .. .. | %1 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &1 EnumDeclaration()<br>
   * .. .. . .. .. | &2 ConstructorDeclaration()<br>
   * .. .. . .. .. | &3 FieldDeclaration()<br>
   * .. .. . .. .. | &4 MethodDeclaration() )<br>
   * .. .. | %2 ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ClassOrInterfaceBodyDeclaration n);

  /**
   * Visits a {@link FieldDeclaration} node, whose children are the following :
   * <p>
   * f0 -> Type()<br>
   * f1 -> VariableDeclarator()<br>
   * f2 -> ( #0 "," #1 VariableDeclarator() )*<br>
   * f3 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final FieldDeclaration n);

  /**
   * Visits a {@link VariableDeclarator} node, whose children are the following :
   * <p>
   * f0 -> VariableDeclaratorId()<br>
   * f1 -> [ #0 "=" #1 VariableInitializer() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final VariableDeclarator n);

  /**
   * Visits a {@link VariableDeclaratorId} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> ( #0 "[" #1 "]" )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final VariableDeclaratorId n);

  /**
   * Visits a {@link VariableInitializer} node, whose children are the following :
   * <p>
   * f0 -> . %0 ArrayInitializer()<br>
   * .. .. | %1 Expression()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final VariableInitializer n);

  /**
   * Visits a {@link ArrayInitializer} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> [ #0 VariableInitializer()<br>
   * .. .. . #1 ( $0 "," $1 VariableInitializer() )* ]<br>
   * f2 -> [ "," ]<br>
   * f3 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ArrayInitializer n);

  /**
   * Visits a {@link MethodDeclaration} node, whose children are the following :
   * <p>
   * f0 -> [ TypeParameters() ]<br>
   * f1 -> ResultType()<br>
   * f2 -> MethodDeclarator()<br>
   * f3 -> [ #0 "throws" #1 NameList() ]<br>
   * f4 -> ( %0 Block()<br>
   * .. .. | %1 ";" )<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final MethodDeclaration n);

  /**
   * Visits a {@link MethodDeclarator} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> FormalParameters()<br>
   * f2 -> ( #0 "[" #1 "]" )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final MethodDeclarator n);

  /**
   * Visits a {@link FormalParameters} node, whose children are the following :
   * <p>
   * f0 -> "("<br>
   * f1 -> [ #0 FormalParameter()<br>
   * .. .. . #1 ( $0 "," $1 FormalParameter() )* ]<br>
   * f2 -> ")"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final FormalParameters n);

  /**
   * Visits a {@link FormalParameter} node, whose children are the following :
   * <p>
   * f0 -> Modifiers()<br>
   * f1 -> Type()<br>
   * f2 -> [ "..." ]<br>
   * f3 -> VariableDeclaratorId()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final FormalParameter n);

  /**
   * Visits a {@link ConstructorDeclaration} node, whose children are the following :
   * <p>
   * f0 -> [ TypeParameters() ]<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> FormalParameters()<br>
   * f3 -> [ #0 "throws" #1 NameList() ]<br>
   * f4 -> "{"<br>
   * f5 -> [ ExplicitConstructorInvocation() ]<br>
   * f6 -> ( BlockStatement() )*<br>
   * f7 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ConstructorDeclaration n);

  /**
   * Visits a {@link ExplicitConstructorInvocation} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "this" #1 Arguments() #2 ";"<br>
   * .. .. | %1 #0 [ $0 PrimaryExpression() $1 "." ]<br>
   * .. .. . .. #1 "super" #2 Arguments() #3 ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ExplicitConstructorInvocation n);

  /**
   * Visits a {@link Initializer} node, whose children are the following :
   * <p>
   * f0 -> [ "static" ]<br>
   * f1 -> Block()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final Initializer n);

  /**
   * Visits a {@link Type} node, whose children are the following :
   * <p>
   * f0 -> . %0 ReferenceType()<br>
   * .. .. | %1 PrimitiveType()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final Type n);

  /**
   * Visits a {@link ReferenceType} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 PrimitiveType()<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )+<br>
   * .. .. | %1 #0 ClassOrInterfaceType()<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ReferenceType n);

  /**
   * Visits a {@link ClassOrInterfaceType} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> [ TypeArguments() ]<br>
   * f2 -> ( #0 "." #1 <IDENTIFIER><br>
   * .. .. . #2 [ TypeArguments() ] )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ClassOrInterfaceType n);

  /**
   * Visits a {@link TypeArguments} node, whose children are the following :
   * <p>
   * f0 -> "<"<br>
   * f1 -> TypeArgument()<br>
   * f2 -> ( #0 "," #1 TypeArgument() )*<br>
   * f3 -> ">"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final TypeArguments n);

  /**
   * Visits a {@link TypeArgument} node, whose children are the following :
   * <p>
   * f0 -> . %0 ReferenceType()<br>
   * .. .. | %1 #0 "?"<br>
   * .. .. . .. #1 [ WildcardBounds() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final TypeArgument n);

  /**
   * Visits a {@link WildcardBounds} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "extends" #1 ReferenceType()<br>
   * .. .. | %1 #0 "super" #1 ReferenceType()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final WildcardBounds n);

  /**
   * Visits a {@link PrimitiveType} node, whose children are the following :
   * <p>
   * f0 -> . %0 "boolean"<br>
   * .. .. | %1 "char"<br>
   * .. .. | %2 "byte"<br>
   * .. .. | %3 "short"<br>
   * .. .. | %4 "int"<br>
   * .. .. | %5 "long"<br>
   * .. .. | %6 "float"<br>
   * .. .. | %7 "double"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final PrimitiveType n);

  /**
   * Visits a {@link ResultType} node, whose children are the following :
   * <p>
   * f0 -> ( %0 "void"<br>
   * .. .. | %1 Type() )<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ResultType n);

  /**
   * Visits a {@link Name} node, whose children are the following :
   * <p>
   * f0 -> JavaIdentifier()<br>
   * f1 -> ( #0 "." #1 JavaIdentifier() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final Name n);

  /**
   * Visits a {@link NameList} node, whose children are the following :
   * <p>
   * f0 -> Name()<br>
   * f1 -> ( #0 "," #1 Name() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final NameList n);

  /**
   * Visits a {@link Expression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalExpression()<br>
   * f1 -> [ #0 AssignmentOperator() #1 Expression() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final Expression n);

  /**
   * Visits a {@link AssignmentOperator} node, whose children are the following :
   * <p>
   * f0 -> . %00 "="<br>
   * .. .. | %01 "*="<br>
   * .. .. | %02 "/="<br>
   * .. .. | %03 "%="<br>
   * .. .. | %04 "+="<br>
   * .. .. | %05 "-="<br>
   * .. .. | %06 "<<="<br>
   * .. .. | %07 ">>="<br>
   * .. .. | %08 ">>>="<br>
   * .. .. | %09 "&="<br>
   * .. .. | %10 "^="<br>
   * .. .. | %11 "|="<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final AssignmentOperator n);

  /**
   * Visits a {@link ConditionalExpression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalOrExpression()<br>
   * f1 -> [ #0 "?" #1 Expression() #2 ":" #3 Expression() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ConditionalExpression n);

  /**
   * Visits a {@link ConditionalOrExpression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalAndExpression()<br>
   * f1 -> ( #0 "||" #1 ConditionalAndExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ConditionalOrExpression n);

  /**
   * Visits a {@link ConditionalAndExpression} node, whose children are the following :
   * <p>
   * f0 -> InclusiveOrExpression()<br>
   * f1 -> ( #0 "&&" #1 InclusiveOrExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ConditionalAndExpression n);

  /**
   * Visits a {@link InclusiveOrExpression} node, whose children are the following :
   * <p>
   * f0 -> ExclusiveOrExpression()<br>
   * f1 -> ( #0 "|" #1 ExclusiveOrExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final InclusiveOrExpression n);

  /**
   * Visits a {@link ExclusiveOrExpression} node, whose children are the following :
   * <p>
   * f0 -> AndExpression()<br>
   * f1 -> ( #0 "^" #1 AndExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ExclusiveOrExpression n);

  /**
   * Visits a {@link AndExpression} node, whose children are the following :
   * <p>
   * f0 -> EqualityExpression()<br>
   * f1 -> ( #0 "&" #1 EqualityExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final AndExpression n);

  /**
   * Visits a {@link EqualityExpression} node, whose children are the following :
   * <p>
   * f0 -> InstanceOfExpression()<br>
   * f1 -> ( #0 ( %0 "=="<br>
   * .. .. . .. | %1 "!=" )<br>
   * .. .. . #1 InstanceOfExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final EqualityExpression n);

  /**
   * Visits a {@link InstanceOfExpression} node, whose children are the following :
   * <p>
   * f0 -> RelationalExpression()<br>
   * f1 -> [ #0 "instanceof" #1 Type() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final InstanceOfExpression n);

  /**
   * Visits a {@link RelationalExpression} node, whose children are the following :
   * <p>
   * f0 -> ShiftExpression()<br>
   * f1 -> ( #0 ( %0 "<"<br>
   * .. .. . .. | %1 ">"<br>
   * .. .. . .. | %2 "<="<br>
   * .. .. . .. | %3 ">=" )<br>
   * .. .. . #1 ShiftExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final RelationalExpression n);

  /**
   * Visits a {@link ShiftExpression} node, whose children are the following :
   * <p>
   * f0 -> AdditiveExpression()<br>
   * f1 -> ( #0 ( %0 "<<"<br>
   * .. .. . .. | %1 RUnsignedShift()<br>
   * .. .. . .. | %2 RSignedShift() )<br>
   * .. .. . #1 AdditiveExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ShiftExpression n);

  /**
   * Visits a {@link RSignedShift} node, whose children are the following :
   * <p>
   * f0 -> ">>"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final RSignedShift n);

  /**
   * Visits a {@link RUnsignedShift} node, whose children are the following :
   * <p>
   * f0 -> ">>>"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final RUnsignedShift n);

  /**
   * Visits a {@link AdditiveExpression} node, whose children are the following :
   * <p>
   * f0 -> MultiplicativeExpression()<br>
   * f1 -> ( #0 ( %0 "+"<br>
   * .. .. . .. | %1 "-" )<br>
   * .. .. . #1 MultiplicativeExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final AdditiveExpression n);

  /**
   * Visits a {@link MultiplicativeExpression} node, whose children are the following :
   * <p>
   * f0 -> UnaryExpression()<br>
   * f1 -> ( #0 ( %0 "*"<br>
   * .. .. . .. | %1 "/"<br>
   * .. .. . .. | %2 "%" )<br>
   * .. .. . #1 UnaryExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final MultiplicativeExpression n);

  /**
   * Visits a {@link UnaryExpression} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 ( &0 "+"<br>
   * .. .. . .. .. | &1 "-" )<br>
   * .. .. . .. #1 UnaryExpression()<br>
   * .. .. | %1 PreIncrementExpression()<br>
   * .. .. | %2 PreDecrementExpression()<br>
   * .. .. | %3 UnaryExpressionNotPlusMinus()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final UnaryExpression n);

  /**
   * Visits a {@link PreIncrementExpression} node, whose children are the following :
   * <p>
   * f0 -> "++"<br>
   * f1 -> PrimaryExpression()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final PreIncrementExpression n);

  /**
   * Visits a {@link PreDecrementExpression} node, whose children are the following :
   * <p>
   * f0 -> "--"<br>
   * f1 -> PrimaryExpression()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final PreDecrementExpression n);

  /**
   * Visits a {@link UnaryExpressionNotPlusMinus} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 ( &0 "~"<br>
   * .. .. . .. .. | &1 "!" )<br>
   * .. .. . .. #1 UnaryExpression()<br>
   * .. .. | %1 CastExpression()<br>
   * .. .. | %2 PostfixExpression()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final UnaryExpressionNotPlusMinus n);

  /**
   * Visits a {@link CastLookahead} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "(" #1 PrimitiveType()<br>
   * .. .. | %1 #0 "(" #1 Type() #2 "[" #3 "]"<br>
   * .. .. | %2 #0 "(" #1 Type() #2 ")"<br>
   * .. .. . .. #3 ( &0 "~"<br>
   * .. .. . .. .. | &1 "!"<br>
   * .. .. . .. .. | &2 "("<br>
   * .. .. . .. .. | &3 <IDENTIFIER><br>
   * .. .. . .. .. | &4 "this"<br>
   * .. .. . .. .. | &5 "super"<br>
   * .. .. . .. .. | &6 "new"<br>
   * .. .. . .. .. | &7 Literal() )<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final CastLookahead n);

  /**
   * Visits a {@link PostfixExpression} node, whose children are the following :
   * <p>
   * f0 -> PrimaryExpression()<br>
   * f1 -> [ %0 "++"<br>
   * .. .. | %1 "--" ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final PostfixExpression n);

  /**
   * Visits a {@link CastExpression} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()<br>
   * .. .. | %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final CastExpression n);

  /**
   * Visits a {@link PrimaryExpression} node, whose children are the following :
   * <p>
   * f0 -> PrimaryPrefix()<br>
   * f1 -> ( PrimarySuffix() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final PrimaryExpression n);

  /**
   * Visits a {@link MemberSelector} node, whose children are the following :
   * <p>
   * f0 -> "."<br>
   * f1 -> TypeArguments()<br>
   * f2 -> <IDENTIFIER><br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final MemberSelector n);

  /**
   * Visits a {@link PrimaryPrefix} node, whose children are the following :
   * <p>
   * f0 -> . %0 Literal()<br>
   * .. .. | %1 "this"<br>
   * .. .. | %2 #0 "super" #1 "." #2 <IDENTIFIER><br>
   * .. .. | %3 #0 "(" #1 Expression() #2 ")"<br>
   * .. .. | %4 AllocationExpression()<br>
   * .. .. | %5 #0 ResultType() #1 "." #2 "class"<br>
   * .. .. | %6 Name()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final PrimaryPrefix n);

  /**
   * Visits a {@link PrimarySuffix} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "." #1 "this"<br>
   * .. .. | %1 #0 "." #1 AllocationExpression()<br>
   * .. .. | %2 MemberSelector()<br>
   * .. .. | %3 #0 "[" #1 Expression() #2 "]"<br>
   * .. .. | %4 #0 "." #1 <IDENTIFIER><br>
   * .. .. | %5 Arguments()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final PrimarySuffix n);

  /**
   * Visits a {@link Literal} node, whose children are the following :
   * <p>
   * f0 -> . %0 <INTEGER_LITERAL><br>
   * .. .. | %1 <FLOATING_POINT_LITERAL><br>
   * .. .. | %2 <CHARACTER_LITERAL><br>
   * .. .. | %3 <STRING_LITERAL><br>
   * .. .. | %4 BooleanLiteral()<br>
   * .. .. | %5 NullLiteral()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final Literal n);

  /**
   * Visits a {@link IntegerLiteral} node, whose children are the following :
   * <p>
   * f0 -> <INTEGER_LITERAL><br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final IntegerLiteral n);

  /**
   * Visits a {@link BooleanLiteral} node, whose children are the following :
   * <p>
   * f0 -> . %0 "true"<br>
   * .. .. | %1 "false"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final BooleanLiteral n);

  /**
   * Visits a {@link StringLiteral} node, whose children are the following :
   * <p>
   * f0 -> <STRING_LITERAL><br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final StringLiteral n);

  /**
   * Visits a {@link NullLiteral} node, whose children are the following :
   * <p>
   * f0 -> "null"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final NullLiteral n);

  /**
   * Visits a {@link Arguments} node, whose children are the following :
   * <p>
   * f0 -> "("<br>
   * f1 -> [ ArgumentList() ]<br>
   * f2 -> ")"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final Arguments n);

  /**
   * Visits a {@link ArgumentList} node, whose children are the following :
   * <p>
   * f0 -> Expression()<br>
   * f1 -> ( #0 "," #1 Expression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ArgumentList n);

  /**
   * Visits a {@link AllocationExpression} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()<br>
   * .. .. | %1 #0 "new" #1 ClassOrInterfaceType()<br>
   * .. .. . .. #2 [ TypeArguments() ]<br>
   * .. .. . .. #3 ( &0 ArrayDimsAndInits()<br>
   * .. .. . .. .. | &1 $0 Arguments()<br>
   * .. .. . .. .. . .. $1 [ ClassOrInterfaceBody() ] )<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final AllocationExpression n);

  /**
   * Visits a {@link ArrayDimsAndInits} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 ( $0 "[" $1 Expression() $2 "]" )+<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )*<br>
   * .. .. | %1 #0 ( $0 "[" $1 "]" )+<br>
   * .. .. . .. #1 ArrayInitializer()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ArrayDimsAndInits n);

  /**
   * Visits a {@link Statement} node, whose children are the following :
   * <p>
   * f0 -> . %00 LabeledStatement()<br>
   * .. .. | %01 AssertStatement()<br>
   * .. .. | %02 Block()<br>
   * .. .. | %03 EmptyStatement()<br>
   * .. .. | %04 #0 StatementExpression() #1 ";"<br>
   * .. .. | %05 SwitchStatement()<br>
   * .. .. | %06 IfStatement()<br>
   * .. .. | %07 WhileStatement()<br>
   * .. .. | %08 DoStatement()<br>
   * .. .. | %09 ForStatement()<br>
   * .. .. | %10 BreakStatement()<br>
   * .. .. | %11 ContinueStatement()<br>
   * .. .. | %12 ReturnStatement()<br>
   * .. .. | %13 ThrowStatement()<br>
   * .. .. | %14 SynchronizedStatement()<br>
   * .. .. | %15 TryStatement()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final Statement n);

  /**
   * Visits a {@link AssertStatement} node, whose children are the following :
   * <p>
   * f0 -> "assert"<br>
   * f1 -> Expression()<br>
   * f2 -> [ #0 ":" #1 Expression() ]<br>
   * f3 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final AssertStatement n);

  /**
   * Visits a {@link LabeledStatement} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> ":"<br>
   * f2 -> Statement()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final LabeledStatement n);

  /**
   * Visits a {@link Block} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( BlockStatement() )*<br>
   * f2 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final Block n);

  /**
   * Visits a {@link BlockStatement} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 LocalVariableDeclaration() #1 ";"<br>
   * .. .. | %1 Statement()<br>
   * .. .. | %2 ClassOrInterfaceDeclaration()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final BlockStatement n);

  /**
   * Visits a {@link LocalVariableDeclaration} node, whose children are the following :
   * <p>
   * f0 -> VariableModifiers()<br>
   * f1 -> Type()<br>
   * f2 -> VariableDeclarator()<br>
   * f3 -> ( #0 "," #1 VariableDeclarator() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final LocalVariableDeclaration n);

  /**
   * Visits a {@link VariableModifiers} node, whose children are the following :
   * <p>
   * f0 -> ( ( %0 "final"<br>
   * .. .. . | %1 Annotation() ) )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final VariableModifiers n);

  /**
   * Visits a {@link EmptyStatement} node, whose children are the following :
   * <p>
   * f0 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final EmptyStatement n);

  /**
   * Visits a {@link StatementExpression} node, whose children are the following :
   * <p>
   * f0 -> . %0 PreIncrementExpression()<br>
   * .. .. | %1 PreDecrementExpression()<br>
   * .. .. | %2 #0 PrimaryExpression()<br>
   * .. .. . .. #1 [ &0 "++"<br>
   * .. .. . .. .. | &1 "--"<br>
   * .. .. . .. .. | &2 $0 AssignmentOperator() $1 Expression() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final StatementExpression n);

  /**
   * Visits a {@link SwitchStatement} node, whose children are the following :
   * <p>
   * f0 -> "switch"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> "{"<br>
   * f5 -> ( #0 SwitchLabel()<br>
   * .. .. . #1 ( BlockStatement() )* )*<br>
   * f6 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final SwitchStatement n);

  /**
   * Visits a {@link SwitchLabel} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "case" #1 Expression() #2 ":"<br>
   * .. .. | %1 #0 "default" #1 ":"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final SwitchLabel n);

  /**
   * Visits a {@link IfStatement} node, whose children are the following :
   * <p>
   * f0 -> "if"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   * f5 -> [ #0 "else" #1 Statement() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final IfStatement n);

  /**
   * Visits a {@link WhileStatement} node, whose children are the following :
   * <p>
   * f0 -> "while"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final WhileStatement n);

  /**
   * Visits a {@link DoStatement} node, whose children are the following :
   * <p>
   * f0 -> "do"<br>
   * f1 -> Statement()<br>
   * f2 -> "while"<br>
   * f3 -> "("<br>
   * f4 -> Expression()<br>
   * f5 -> ")"<br>
   * f6 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final DoStatement n);

  /**
   * Visits a {@link ForStatement} node, whose children are the following :
   * <p>
   * f0 -> "for"<br>
   * f1 -> "("<br>
   * f2 -> ( %0 #0 VariableModifiers() #1 Type() #2 <IDENTIFIER> #3 ":" #4 Expression()<br>
   * .. .. | %1 #0 [ ForInit() ]<br>
   * .. .. . .. #1 ";"<br>
   * .. .. . .. #2 [ Expression() ]<br>
   * .. .. . .. #3 ";"<br>
   * .. .. . .. #4 [ ForUpdate() ] )<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ForStatement n);

  /**
   * Visits a {@link ForInit} node, whose children are the following :
   * <p>
   * f0 -> . %0 LocalVariableDeclaration()<br>
   * .. .. | %1 StatementExpressionList()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ForInit n);

  /**
   * Visits a {@link StatementExpressionList} node, whose children are the following :
   * <p>
   * f0 -> StatementExpression()<br>
   * f1 -> ( #0 "," #1 StatementExpression() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final StatementExpressionList n);

  /**
   * Visits a {@link ForUpdate} node, whose children are the following :
   * <p>
   * f0 -> StatementExpressionList()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ForUpdate n);

  /**
   * Visits a {@link BreakStatement} node, whose children are the following :
   * <p>
   * f0 -> "break"<br>
   * f1 -> [ <IDENTIFIER> ]<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final BreakStatement n);

  /**
   * Visits a {@link ContinueStatement} node, whose children are the following :
   * <p>
   * f0 -> "continue"<br>
   * f1 -> [ <IDENTIFIER> ]<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ContinueStatement n);

  /**
   * Visits a {@link ReturnStatement} node, whose children are the following :
   * <p>
   * f0 -> "return"<br>
   * f1 -> [ Expression() ]<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ReturnStatement n);

  /**
   * Visits a {@link ThrowStatement} node, whose children are the following :
   * <p>
   * f0 -> "throw"<br>
   * f1 -> Expression()<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final ThrowStatement n);

  /**
   * Visits a {@link SynchronizedStatement} node, whose children are the following :
   * <p>
   * f0 -> "synchronized"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Block()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final SynchronizedStatement n);

  /**
   * Visits a {@link TryStatement} node, whose children are the following :
   * <p>
   * f0 -> "try"<br>
   * f1 -> Block()<br>
   * f2 -> ( #0 "catch" #1 "(" #2 FormalParameter() #3 ")" #4 Block() )*<br>
   * f3 -> [ #0 "finally" #1 Block() ]<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final TryStatement n);

  /**
   * Visits a {@link Annotation} node, whose children are the following :
   * <p>
   * f0 -> . %0 NormalAnnotation()<br>
   * .. .. | %1 SingleMemberAnnotation()<br>
   * .. .. | %2 MarkerAnnotation()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final Annotation n);

  /**
   * Visits a {@link NormalAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   * f2 -> "("<br>
   * f3 -> [ MemberValuePairs() ]<br>
   * f4 -> ")"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final NormalAnnotation n);

  /**
   * Visits a {@link MarkerAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final MarkerAnnotation n);

  /**
   * Visits a {@link SingleMemberAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   * f2 -> "("<br>
   * f3 -> MemberValue()<br>
   * f4 -> ")"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final SingleMemberAnnotation n);

  /**
   * Visits a {@link MemberValuePairs} node, whose children are the following :
   * <p>
   * f0 -> MemberValuePair()<br>
   * f1 -> ( #0 "," #1 MemberValuePair() )*<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final MemberValuePairs n);

  /**
   * Visits a {@link MemberValuePair} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> "="<br>
   * f2 -> MemberValue()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final MemberValuePair n);

  /**
   * Visits a {@link MemberValue} node, whose children are the following :
   * <p>
   * f0 -> . %0 Annotation()<br>
   * .. .. | %1 MemberValueArrayInitializer()<br>
   * .. .. | %2 ConditionalExpression()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final MemberValue n);

  /**
   * Visits a {@link MemberValueArrayInitializer} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> MemberValue()<br>
   * f2 -> ( #0 "," #1 MemberValue() )*<br>
   * f3 -> [ "," ]<br>
   * f4 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final MemberValueArrayInitializer n);

  /**
   * Visits a {@link AnnotationTypeDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> "interface"<br>
   * f2 -> <IDENTIFIER><br>
   * f3 -> AnnotationTypeBody()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final AnnotationTypeDeclaration n);

  /**
   * Visits a {@link AnnotationTypeBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( AnnotationTypeMemberDeclaration() )*<br>
   * f2 -> "}"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final AnnotationTypeBody n);

  /**
   * Visits a {@link AnnotationTypeMemberDeclaration} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"<br>
   * .. .. . .. .. . .. $4 [ DefaultValue() ]<br>
   * .. .. . .. .. . .. $5 ";"<br>
   * .. .. . .. .. | &1 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &2 EnumDeclaration()<br>
   * .. .. . .. .. | &3 AnnotationTypeDeclaration()<br>
   * .. .. . .. .. | &4 FieldDeclaration() )<br>
   * .. .. | %1 ";"<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final AnnotationTypeMemberDeclaration n);

  /**
   * Visits a {@link DefaultValue} node, whose children are the following :
   * <p>
   * f0 -> "default"<br>
   * f1 -> MemberValue()<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  public R visit(final DefaultValue n);

}
