// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(adc)                       \
  M(adcs)                      \
  M(add)                       \
  M(adds)                      \
  M(and_)                      \
  M(ands)                      \
  M(bic)                       \
  M(bics)                      \
  M(eor)                       \
  M(eors)                      \
  M(orr)                       \
  M(orrs)                      \
  M(rsb)                       \
  M(rsbs)                      \
  M(rsc)                       \
  M(rscs)                      \
  M(sbc)                       \
  M(sbcs)                      \
  M(sub)                       \
  M(subs)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anonymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_A32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  Register rm;
  ShiftType shift;
  uint32_t amount;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] = {{{eq, r13, r13, r0, LSL, 5},
                            false,
                            al,
                            "eq r13 r13 r0 LSL 5",
                            "eq_r13_r13_r0_LSL_5"},
                           {{mi, r10, r14, r13, LSL, 10},
                            false,
                            al,
                            "mi r10 r14 r13 LSL 10",
                            "mi_r10_r14_r13_LSL_10"},
                           {{hi, r6, r2, r13, LSL, 4},
                            false,
                            al,
                            "hi r6 r2 r13 LSL 4",
                            "hi_r6_r2_r13_LSL_4"},
                           {{ge, r3, r5, r13, LSL, 2},
                            false,
                            al,
                            "ge r3 r5 r13 LSL 2",
                            "ge_r3_r5_r13_LSL_2"},
                           {{cc, r10, r5, r1, ROR, 10},
                            false,
                            al,
                            "cc r10 r5 r1 ROR 10",
                            "cc_r10_r5_r1_ROR_10"},
                           {{ge, r3, r14, r7, ROR, 7},
                            false,
                            al,
                            "ge r3 r14 r7 ROR 7",
                            "ge_r3_r14_r7_ROR_7"},
                           {{pl, r11, r1, r7, LSL, 23},
                            false,
                            al,
                            "pl r11 r1 r7 LSL 23",
                            "pl_r11_r1_r7_LSL_23"},
                           {{le, r8, r6, r4, LSL, 21},
                            false,
                            al,
                            "le r8 r6 r4 LSL 21",
                            "le_r8_r6_r4_LSL_21"},
                           {{ne, r2, r9, r2, LSL, 3},
                            false,
                            al,
                            "ne r2 r9 r2 LSL 3",
                            "ne_r2_r9_r2_LSL_3"},
                           {{ge, r14, r14, r8, LSL, 4},
                            false,
                            al,
                            "ge r14 r14 r8 LSL 4",
                            "ge_r14_r14_r8_LSL_4"},
                           {{vs, r1, r5, r14, LSL, 15},
                            false,
                            al,
                            "vs r1 r5 r14 LSL 15",
                            "vs_r1_r5_r14_LSL_15"},
                           {{cs, r12, r3, r0, ROR, 20},
                            false,
                            al,
                            "cs r12 r3 r0 ROR 20",
                            "cs_r12_r3_r0_ROR_20"},
                           {{vs, r1, r6, r9, ROR, 14},
                            false,
                            al,
                            "vs r1 r6 r9 ROR 14",
                            "vs_r1_r6_r9_ROR_14"},
                           {{cs, r9, r10, r12, LSL, 27},
                            false,
                            al,
                            "cs r9 r10 r12 LSL 27",
                            "cs_r9_r10_r12_LSL_27"},
                           {{vc, r14, r13, r10, ROR, 7},
                            false,
                            al,
                            "vc r14 r13 r10 ROR 7",
                            "vc_r14_r13_r10_ROR_7"},
                           {{ge, r12, r0, r6, ROR, 4},
                            false,
                            al,
                            "ge r12 r0 r6 ROR 4",
                            "ge_r12_r0_r6_ROR_4"},
                           {{cc, r13, r0, r3, LSL, 14},
                            false,
                            al,
                            "cc r13 r0 r3 LSL 14",
                            "cc_r13_r0_r3_LSL_14"},
                           {{gt, r1, r4, r7, ROR, 10},
                            false,
                            al,
                            "gt r1 r4 r7 ROR 10",
                            "gt_r1_r4_r7_ROR_10"},
                           {{ne, r8, r11, r14, ROR, 19},
                            false,
                            al,
                            "ne r8 r11 r14 ROR 19",
                            "ne_r8_r11_r14_ROR_19"},
                           {{vc, r4, r11, r5, ROR, 15},
                            false,
                            al,
                            "vc r4 r11 r5 ROR 15",
                            "vc_r4_r11_r5_ROR_15"},
                           {{pl, r5, r5, r2, LSL, 28},
                            false,
                            al,
                            "pl r5 r5 r2 LSL 28",
                            "pl_r5_r5_r2_LSL_28"},
                           {{pl, r13, r12, r9, ROR, 25},
                            false,
                            al,
                            "pl r13 r12 r9 ROR 25",
                            "pl_r13_r12_r9_ROR_25"},
                           {{gt, r11, r11, r8, LSL, 16},
                            false,
                            al,
                            "gt r11 r11 r8 LSL 16",
                            "gt_r11_r11_r8_LSL_16"},
                           {{eq, r8, r14, r0, LSL, 26},
                            false,
                            al,
                            "eq r8 r14 r0 LSL 26",
                            "eq_r8_r14_r0_LSL_26"},
                           {{cs, r11, r14, r7, ROR, 3},
                            false,
                            al,
                            "cs r11 r14 r7 ROR 3",
                            "cs_r11_r14_r7_ROR_3"},
                           {{lt, r13, r4, r11, ROR, 8},
                            false,
                            al,
                            "lt r13 r4 r11 ROR 8",
                            "lt_r13_r4_r11_ROR_8"},
                           {{eq, r14, r10, r9, ROR, 5},
                            false,
                            al,
                            "eq r14 r10 r9 ROR 5",
                            "eq_r14_r10_r9_ROR_5"},
                           {{vs, r7, r12, r3, LSL, 23},
                            false,
                            al,
                            "vs r7 r12 r3 LSL 23",
                            "vs_r7_r12_r3_LSL_23"},
                           {{le, r14, r8, r0, ROR, 22},
                            false,
                            al,
                            "le r14 r8 r0 ROR 22",
                            "le_r14_r8_r0_ROR_22"},
                           {{ne, r7, r14, r12, LSL, 25},
                            false,
                            al,
                            "ne r7 r14 r12 LSL 25",
                            "ne_r7_r14_r12_LSL_25"},
                           {{hi, r9, r12, r1, LSL, 16},
                            false,
                            al,
                            "hi r9 r12 r1 LSL 16",
                            "hi_r9_r12_r1_LSL_16"},
                           {{cs, r9, r11, r3, ROR, 23},
                            false,
                            al,
                            "cs r9 r11 r3 ROR 23",
                            "cs_r9_r11_r3_ROR_23"},
                           {{vc, r7, r2, r6, ROR, 16},
                            false,
                            al,
                            "vc r7 r2 r6 ROR 16",
                            "vc_r7_r2_r6_ROR_16"},
                           {{lt, r12, r7, r6, LSL, 2},
                            false,
                            al,
                            "lt r12 r7 r6 LSL 2",
                            "lt_r12_r7_r6_LSL_2"},
                           {{gt, r1, r9, r4, LSL, 29},
                            false,
                            al,
                            "gt r1 r9 r4 LSL 29",
                            "gt_r1_r9_r4_LSL_29"},
                           {{mi, r11, r0, r5, LSL, 22},
                            false,
                            al,
                            "mi r11 r0 r5 LSL 22",
                            "mi_r11_r0_r5_LSL_22"},
                           {{ls, r13, r10, r0, ROR, 14},
                            false,
                            al,
                            "ls r13 r10 r0 ROR 14",
                            "ls_r13_r10_r0_ROR_14"},
                           {{ge, r0, r7, r14, LSL, 15},
                            false,
                            al,
                            "ge r0 r7 r14 LSL 15",
                            "ge_r0_r7_r14_LSL_15"},
                           {{vs, r12, r13, r3, ROR, 1},
                            false,
                            al,
                            "vs r12 r13 r3 ROR 1",
                            "vs_r12_r13_r3_ROR_1"},
                           {{pl, r1, r0, r3, ROR, 31},
                            false,
                            al,
                            "pl r1 r0 r3 ROR 31",
                            "pl_r1_r0_r3_ROR_31"},
                           {{mi, r13, r3, r9, ROR, 4},
                            false,
                            al,
                            "mi r13 r3 r9 ROR 4",
                            "mi_r13_r3_r9_ROR_4"},
                           {{ge, r1, r14, r0, LSL, 25},
                            false,
                            al,
                            "ge r1 r14 r0 LSL 25",
                            "ge_r1_r14_r0_LSL_25"},
                           {{ne, r6, r0, r9, LSL, 16},
                            false,
                            al,
                            "ne r6 r0 r9 LSL 16",
                            "ne_r6_r0_r9_LSL_16"},
                           {{vc, r8, r11, r3, ROR, 2},
                            false,
                            al,
                            "vc r8 r11 r3 ROR 2",
                            "vc_r8_r11_r3_ROR_2"},
                           {{cc, r10, r9, r0, ROR, 31},
                            false,
                            al,
                            "cc r10 r9 r0 ROR 31",
                            "cc_r10_r9_r0_ROR_31"},
                           {{hi, r9, r6, r7, LSL, 13},
                            false,
                            al,
                            "hi r9 r6 r7 LSL 13",
                            "hi_r9_r6_r7_LSL_13"},
                           {{cs, r10, r14, r9, LSL, 3},
                            false,
                            al,
                            "cs r10 r14 r9 LSL 3",
                            "cs_r10_r14_r9_LSL_3"},
                           {{al, r5, r12, r5, LSL, 10},
                            false,
                            al,
                            "al r5 r12 r5 LSL 10",
                            "al_r5_r12_r5_LSL_10"},
                           {{mi, r3, r11, r3, ROR, 6},
                            false,
                            al,
                            "mi r3 r11 r3 ROR 6",
                            "mi_r3_r11_r3_ROR_6"},
                           {{vc, r6, r8, r1, LSL, 25},
                            false,
                            al,
                            "vc r6 r8 r1 LSL 25",
                            "vc_r6_r8_r1_LSL_25"},
                           {{cs, r3, r5, r5, ROR, 17},
                            false,
                            al,
                            "cs r3 r5 r5 ROR 17",
                            "cs_r3_r5_r5_ROR_17"},
                           {{gt, r14, r14, r8, ROR, 22},
                            false,
                            al,
                            "gt r14 r14 r8 ROR 22",
                            "gt_r14_r14_r8_ROR_22"},
                           {{vc, r5, r0, r7, LSL, 19},
                            false,
                            al,
                            "vc r5 r0 r7 LSL 19",
                            "vc_r5_r0_r7_LSL_19"},
                           {{vs, r6, r10, r11, LSL, 31},
                            false,
                            al,
                            "vs r6 r10 r11 LSL 31",
                            "vs_r6_r10_r11_LSL_31"},
                           {{ge, r6, r1, r8, ROR, 13},
                            false,
                            al,
                            "ge r6 r1 r8 ROR 13",
                            "ge_r6_r1_r8_ROR_13"},
                           {{cs, r6, r3, r9, LSL, 24},
                            false,
                            al,
                            "cs r6 r3 r9 LSL 24",
                            "cs_r6_r3_r9_LSL_24"},
                           {{le, r9, r13, r0, LSL, 20},
                            false,
                            al,
                            "le r9 r13 r0 LSL 20",
                            "le_r9_r13_r0_LSL_20"},
                           {{le, r10, r11, r0, ROR, 20},
                            false,
                            al,
                            "le r10 r11 r0 ROR 20",
                            "le_r10_r11_r0_ROR_20"},
                           {{al, r4, r13, r12, ROR, 4},
                            false,
                            al,
                            "al r4 r13 r12 ROR 4",
                            "al_r4_r13_r12_ROR_4"},
                           {{cc, r10, r10, r10, LSL, 19},
                            false,
                            al,
                            "cc r10 r10 r10 LSL 19",
                            "cc_r10_r10_r10_LSL_19"},
                           {{ge, r11, r12, r13, ROR, 19},
                            false,
                            al,
                            "ge r11 r12 r13 ROR 19",
                            "ge_r11_r12_r13_ROR_19"},
                           {{gt, r9, r5, r6, ROR, 12},
                            false,
                            al,
                            "gt r9 r5 r6 ROR 12",
                            "gt_r9_r5_r6_ROR_12"},
                           {{cs, r1, r5, r1, ROR, 20},
                            false,
                            al,
                            "cs r1 r5 r1 ROR 20",
                            "cs_r1_r5_r1_ROR_20"},
                           {{pl, r8, r13, r8, LSL, 9},
                            false,
                            al,
                            "pl r8 r13 r8 LSL 9",
                            "pl_r8_r13_r8_LSL_9"},
                           {{pl, r11, r7, r14, LSL, 31},
                            false,
                            al,
                            "pl r11 r7 r14 LSL 31",
                            "pl_r11_r7_r14_LSL_31"},
                           {{hi, r2, r4, r5, LSL, 8},
                            false,
                            al,
                            "hi r2 r4 r5 LSL 8",
                            "hi_r2_r4_r5_LSL_8"},
                           {{ne, r1, r5, r3, LSL, 29},
                            false,
                            al,
                            "ne r1 r5 r3 LSL 29",
                            "ne_r1_r5_r3_LSL_29"},
                           {{ls, r12, r11, r14, ROR, 27},
                            false,
                            al,
                            "ls r12 r11 r14 ROR 27",
                            "ls_r12_r11_r14_ROR_27"},
                           {{al, r12, r2, r11, ROR, 17},
                            false,
                            al,
                            "al r12 r2 r11 ROR 17",
                            "al_r12_r2_r11_ROR_17"},
                           {{vc, r5, r6, r9, ROR, 7},
                            false,
                            al,
                            "vc r5 r6 r9 ROR 7",
                            "vc_r5_r6_r9_ROR_7"},
                           {{vc, r4, r1, r6, ROR, 3},
                            false,
                            al,
                            "vc r4 r1 r6 ROR 3",
                            "vc_r4_r1_r6_ROR_3"},
                           {{al, r9, r13, r13, LSL, 4},
                            false,
                            al,
                            "al r9 r13 r13 LSL 4",
                            "al_r9_r13_r13_LSL_4"},
                           {{vs, r6, r12, r1, ROR, 2},
                            false,
                            al,
                            "vs r6 r12 r1 ROR 2",
                            "vs_r6_r12_r1_ROR_2"},
                           {{ls, r4, r14, r9, ROR, 21},
                            false,
                            al,
                            "ls r4 r14 r9 ROR 21",
                            "ls_r4_r14_r9_ROR_21"},
                           {{le, r8, r14, r4, LSL, 7},
                            false,
                            al,
                            "le r8 r14 r4 LSL 7",
                            "le_r8_r14_r4_LSL_7"},
                           {{cs, r1, r4, r10, ROR, 10},
                            false,
                            al,
                            "cs r1 r4 r10 ROR 10",
                            "cs_r1_r4_r10_ROR_10"},
                           {{cc, r3, r3, r7, ROR, 4},
                            false,
                            al,
                            "cc r3 r3 r7 ROR 4",
                            "cc_r3_r3_r7_ROR_4"},
                           {{lt, r2, r2, r3, LSL, 1},
                            false,
                            al,
                            "lt r2 r2 r3 LSL 1",
                            "lt_r2_r2_r3_LSL_1"},
                           {{eq, r2, r10, r8, LSL, 12},
                            false,
                            al,
                            "eq r2 r10 r8 LSL 12",
                            "eq_r2_r10_r8_LSL_12"},
                           {{ge, r9, r14, r0, LSL, 15},
                            false,
                            al,
                            "ge r9 r14 r0 LSL 15",
                            "ge_r9_r14_r0_LSL_15"},
                           {{vc, r4, r12, r8, LSL, 2},
                            false,
                            al,
                            "vc r4 r12 r8 LSL 2",
                            "vc_r4_r12_r8_LSL_2"},
                           {{hi, r11, r11, r8, ROR, 12},
                            false,
                            al,
                            "hi r11 r11 r8 ROR 12",
                            "hi_r11_r11_r8_ROR_12"},
                           {{ne, r0, r3, r14, ROR, 18},
                            false,
                            al,
                            "ne r0 r3 r14 ROR 18",
                            "ne_r0_r3_r14_ROR_18"},
                           {{lt, r5, r3, r1, ROR, 8},
                            false,
                            al,
                            "lt r5 r3 r1 ROR 8",
                            "lt_r5_r3_r1_ROR_8"},
                           {{pl, r10, r11, r2, ROR, 18},
                            false,
                            al,
                            "pl r10 r11 r2 ROR 18",
                            "pl_r10_r11_r2_ROR_18"},
                           {{ne, r8, r9, r13, ROR, 5},
                            false,
                            al,
                            "ne r8 r9 r13 ROR 5",
                            "ne_r8_r9_r13_ROR_5"},
                           {{vc, r1, r9, r7, LSL, 26},
                            false,
                            al,
                            "vc r1 r9 r7 LSL 26",
                            "vc_r1_r9_r7_LSL_26"},
                           {{mi, r6, r0, r9, LSL, 5},
                            false,
                            al,
                            "mi r6 r0 r9 LSL 5",
                            "mi_r6_r0_r9_LSL_5"},
                           {{cc, r1, r1, r9, LSL, 5},
                            false,
                            al,
                            "cc r1 r1 r9 LSL 5",
                            "cc_r1_r1_r9_LSL_5"},
                           {{cc, r13, r4, r9, LSL, 2},
                            false,
                            al,
                            "cc r13 r4 r9 LSL 2",
                            "cc_r13_r4_r9_LSL_2"},
                           {{cc, r13, r4, r7, LSL, 27},
                            false,
                            al,
                            "cc r13 r4 r7 LSL 27",
                            "cc_r13_r4_r7_LSL_27"},
                           {{al, r7, r2, r1, ROR, 28},
                            false,
                            al,
                            "al r7 r2 r1 ROR 28",
                            "al_r7_r2_r1_ROR_28"},
                           {{eq, r3, r7, r7, ROR, 10},
                            false,
                            al,
                            "eq r3 r7 r7 ROR 10",
                            "eq_r3_r7_r7_ROR_10"},
                           {{lt, r1, r4, r0, ROR, 29},
                            false,
                            al,
                            "lt r1 r4 r0 ROR 29",
                            "lt_r1_r4_r0_ROR_29"},
                           {{gt, r4, r9, r5, LSL, 17},
                            false,
                            al,
                            "gt r4 r9 r5 LSL 17",
                            "gt_r4_r9_r5_LSL_17"},
                           {{cs, r14, r7, r12, LSL, 28},
                            false,
                            al,
                            "cs r14 r7 r12 LSL 28",
                            "cs_r14_r7_r12_LSL_28"},
                           {{lt, r0, r6, r12, ROR, 22},
                            false,
                            al,
                            "lt r0 r6 r12 ROR 22",
                            "lt_r0_r6_r12_ROR_22"},
                           {{pl, r10, r2, r4, LSL, 19},
                            false,
                            al,
                            "pl r10 r2 r4 LSL 19",
                            "pl_r10_r2_r4_LSL_19"},
                           {{eq, r3, r0, r2, LSL, 4},
                            false,
                            al,
                            "eq r3 r0 r2 LSL 4",
                            "eq_r3_r0_r2_LSL_4"},
                           {{ne, r6, r3, r12, ROR, 20},
                            false,
                            al,
                            "ne r6 r3 r12 ROR 20",
                            "ne_r6_r3_r12_ROR_20"},
                           {{al, r7, r2, r9, LSL, 1},
                            false,
                            al,
                            "al r7 r2 r9 LSL 1",
                            "al_r7_r2_r9_LSL_1"},
                           {{al, r7, r8, r9, ROR, 22},
                            false,
                            al,
                            "al r7 r8 r9 ROR 22",
                            "al_r7_r8_r9_ROR_22"},
                           {{eq, r9, r13, r12, LSL, 2},
                            false,
                            al,
                            "eq r9 r13 r12 LSL 2",
                            "eq_r9_r13_r12_LSL_2"},
                           {{mi, r4, r9, r13, ROR, 2},
                            false,
                            al,
                            "mi r4 r9 r13 ROR 2",
                            "mi_r4_r9_r13_ROR_2"},
                           {{vc, r10, r1, r0, LSL, 7},
                            false,
                            al,
                            "vc r10 r1 r0 LSL 7",
                            "vc_r10_r1_r0_LSL_7"},
                           {{pl, r9, r4, r8, ROR, 14},
                            false,
                            al,
                            "pl r9 r4 r8 ROR 14",
                            "pl_r9_r4_r8_ROR_14"},
                           {{le, r0, r7, r0, LSL, 2},
                            false,
                            al,
                            "le r0 r7 r0 LSL 2",
                            "le_r0_r7_r0_LSL_2"},
                           {{mi, r2, r14, r11, LSL, 18},
                            false,
                            al,
                            "mi r2 r14 r11 LSL 18",
                            "mi_r2_r14_r11_LSL_18"},
                           {{ne, r11, r9, r1, LSL, 12},
                            false,
                            al,
                            "ne r11 r9 r1 LSL 12",
                            "ne_r11_r9_r1_LSL_12"},
                           {{ls, r6, r0, r5, ROR, 2},
                            false,
                            al,
                            "ls r6 r0 r5 ROR 2",
                            "ls_r6_r0_r5_ROR_2"},
                           {{eq, r14, r2, r7, ROR, 16},
                            false,
                            al,
                            "eq r14 r2 r7 ROR 16",
                            "eq_r14_r2_r7_ROR_16"},
                           {{pl, r0, r5, r8, ROR, 17},
                            false,
                            al,
                            "pl r0 r5 r8 ROR 17",
                            "pl_r0_r5_r8_ROR_17"},
                           {{ne, r0, r6, r1, LSL, 6},
                            false,
                            al,
                            "ne r0 r6 r1 LSL 6",
                            "ne_r0_r6_r1_LSL_6"},
                           {{mi, r12, r11, r8, LSL, 12},
                            false,
                            al,
                            "mi r12 r11 r8 LSL 12",
                            "mi_r12_r11_r8_LSL_12"},
                           {{hi, r3, r14, r4, LSL, 2},
                            false,
                            al,
                            "hi r3 r14 r4 LSL 2",
                            "hi_r3_r14_r4_LSL_2"},
                           {{pl, r12, r13, r11, LSL, 24},
                            false,
                            al,
                            "pl r12 r13 r11 LSL 24",
                            "pl_r12_r13_r11_LSL_24"},
                           {{al, r4, r1, r8, LSL, 2},
                            false,
                            al,
                            "al r4 r1 r8 LSL 2",
                            "al_r4_r1_r8_LSL_2"},
                           {{gt, r9, r14, r5, LSL, 20},
                            false,
                            al,
                            "gt r9 r14 r5 LSL 20",
                            "gt_r9_r14_r5_LSL_20"},
                           {{eq, r9, r5, r0, ROR, 24},
                            false,
                            al,
                            "eq r9 r5 r0 ROR 24",
                            "eq_r9_r5_r0_ROR_24"},
                           {{ge, r12, r2, r8, ROR, 25},
                            false,
                            al,
                            "ge r12 r2 r8 ROR 25",
                            "ge_r12_r2_r8_ROR_25"},
                           {{al, r7, r13, r14, ROR, 28},
                            false,
                            al,
                            "al r7 r13 r14 ROR 28",
                            "al_r7_r13_r14_ROR_28"},
                           {{gt, r3, r12, r4, ROR, 10},
                            false,
                            al,
                            "gt r3 r12 r4 ROR 10",
                            "gt_r3_r12_r4_ROR_10"},
                           {{cc, r3, r13, r2, LSL, 13},
                            false,
                            al,
                            "cc r3 r13 r2 LSL 13",
                            "cc_r3_r13_r2_LSL_13"},
                           {{ne, r8, r13, r12, LSL, 26},
                            false,
                            al,
                            "ne r8 r13 r12 LSL 26",
                            "ne_r8_r13_r12_LSL_26"},
                           {{eq, r11, r13, r9, ROR, 18},
                            false,
                            al,
                            "eq r11 r13 r9 ROR 18",
                            "eq_r11_r13_r9_ROR_18"},
                           {{al, r10, r13, r4, LSL, 20},
                            false,
                            al,
                            "al r10 r13 r4 LSL 20",
                            "al_r10_r13_r4_LSL_20"},
                           {{pl, r3, r9, r5, LSL, 19},
                            false,
                            al,
                            "pl r3 r9 r5 LSL 19",
                            "pl_r3_r9_r5_LSL_19"},
                           {{eq, r14, r9, r3, LSL, 4},
                            false,
                            al,
                            "eq r14 r9 r3 LSL 4",
                            "eq_r14_r9_r3_LSL_4"},
                           {{hi, r12, r0, r1, LSL, 31},
                            false,
                            al,
                            "hi r12 r0 r1 LSL 31",
                            "hi_r12_r0_r1_LSL_31"},
                           {{le, r5, r11, r13, LSL, 4},
                            false,
                            al,
                            "le r5 r11 r13 LSL 4",
                            "le_r5_r11_r13_LSL_4"},
                           {{ls, r4, r11, r7, ROR, 8},
                            false,
                            al,
                            "ls r4 r11 r7 ROR 8",
                            "ls_r4_r11_r7_ROR_8"},
                           {{cc, r1, r14, r8, LSL, 20},
                            false,
                            al,
                            "cc r1 r14 r8 LSL 20",
                            "cc_r1_r14_r8_LSL_20"},
                           {{hi, r7, r5, r5, LSL, 7},
                            false,
                            al,
                            "hi r7 r5 r5 LSL 7",
                            "hi_r7_r5_r5_LSL_7"},
                           {{hi, r14, r8, r6, ROR, 24},
                            false,
                            al,
                            "hi r14 r8 r6 ROR 24",
                            "hi_r14_r8_r6_ROR_24"},
                           {{le, r14, r7, r3, LSL, 13},
                            false,
                            al,
                            "le r14 r7 r3 LSL 13",
                            "le_r14_r7_r3_LSL_13"},
                           {{le, r1, r3, r1, ROR, 21},
                            false,
                            al,
                            "le r1 r3 r1 ROR 21",
                            "le_r1_r3_r1_ROR_21"},
                           {{ls, r9, r7, r6, LSL, 19},
                            false,
                            al,
                            "ls r9 r7 r6 LSL 19",
                            "ls_r9_r7_r6_LSL_19"},
                           {{pl, r0, r4, r7, ROR, 8},
                            false,
                            al,
                            "pl r0 r4 r7 ROR 8",
                            "pl_r0_r4_r7_ROR_8"},
                           {{al, r14, r9, r8, ROR, 11},
                            false,
                            al,
                            "al r14 r9 r8 ROR 11",
                            "al_r14_r9_r8_ROR_11"},
                           {{cc, r2, r2, r3, LSL, 20},
                            false,
                            al,
                            "cc r2 r2 r3 LSL 20",
                            "cc_r2_r2_r3_LSL_20"},
                           {{mi, r2, r1, r13, LSL, 19},
                            false,
                            al,
                            "mi r2 r1 r13 LSL 19",
                            "mi_r2_r1_r13_LSL_19"},
                           {{cs, r8, r12, r9, ROR, 29},
                            false,
                            al,
                            "cs r8 r12 r9 ROR 29",
                            "cs_r8_r12_r9_ROR_29"},
                           {{le, r0, r8, r8, LSL, 31},
                            false,
                            al,
                            "le r0 r8 r8 LSL 31",
                            "le_r0_r8_r8_LSL_31"},
                           {{cc, r2, r9, r13, ROR, 23},
                            false,
                            al,
                            "cc r2 r9 r13 ROR 23",
                            "cc_r2_r9_r13_ROR_23"},
                           {{ne, r7, r0, r4, ROR, 1},
                            false,
                            al,
                            "ne r7 r0 r4 ROR 1",
                            "ne_r7_r0_r4_ROR_1"},
                           {{al, r14, r3, r1, LSL, 7},
                            false,
                            al,
                            "al r14 r3 r1 LSL 7",
                            "al_r14_r3_r1_LSL_7"},
                           {{le, r2, r2, r4, ROR, 5},
                            false,
                            al,
                            "le r2 r2 r4 ROR 5",
                            "le_r2_r2_r4_ROR_5"},
                           {{lt, r5, r13, r8, LSL, 3},
                            false,
                            al,
                            "lt r5 r13 r8 LSL 3",
                            "lt_r5_r13_r8_LSL_3"},
                           {{ne, r13, r3, r10, LSL, 26},
                            false,
                            al,
                            "ne r13 r3 r10 LSL 26",
                            "ne_r13_r3_r10_LSL_26"},
                           {{vs, r0, r3, r12, ROR, 2},
                            false,
                            al,
                            "vs r0 r3 r12 ROR 2",
                            "vs_r0_r3_r12_ROR_2"},
                           {{gt, r11, r8, r4, ROR, 10},
                            false,
                            al,
                            "gt r11 r8 r4 ROR 10",
                            "gt_r11_r8_r4_ROR_10"},
                           {{al, r3, r11, r7, LSL, 24},
                            false,
                            al,
                            "al r3 r11 r7 LSL 24",
                            "al_r3_r11_r7_LSL_24"},
                           {{al, r1, r2, r11, LSL, 9},
                            false,
                            al,
                            "al r1 r2 r11 LSL 9",
                            "al_r1_r2_r11_LSL_9"},
                           {{gt, r11, r1, r12, ROR, 19},
                            false,
                            al,
                            "gt r11 r1 r12 ROR 19",
                            "gt_r11_r1_r12_ROR_19"},
                           {{ge, r13, r9, r3, LSL, 25},
                            false,
                            al,
                            "ge r13 r9 r3 LSL 25",
                            "ge_r13_r9_r3_LSL_25"},
                           {{gt, r5, r5, r10, LSL, 19},
                            false,
                            al,
                            "gt r5 r5 r10 LSL 19",
                            "gt_r5_r5_r10_LSL_19"},
                           {{cc, r2, r3, r8, LSL, 9},
                            false,
                            al,
                            "cc r2 r3 r8 LSL 9",
                            "cc_r2_r3_r8_LSL_9"},
                           {{pl, r2, r13, r6, ROR, 15},
                            false,
                            al,
                            "pl r2 r13 r6 ROR 15",
                            "pl_r2_r13_r6_ROR_15"},
                           {{lt, r9, r8, r14, LSL, 24},
                            false,
                            al,
                            "lt r9 r8 r14 LSL 24",
                            "lt_r9_r8_r14_LSL_24"},
                           {{vs, r2, r1, r2, LSL, 13},
                            false,
                            al,
                            "vs r2 r1 r2 LSL 13",
                            "vs_r2_r1_r2_LSL_13"},
                           {{cs, r14, r11, r9, LSL, 20},
                            false,
                            al,
                            "cs r14 r11 r9 LSL 20",
                            "cs_r14_r11_r9_LSL_20"},
                           {{mi, r0, r6, r5, ROR, 24},
                            false,
                            al,
                            "mi r0 r6 r5 ROR 24",
                            "mi_r0_r6_r5_ROR_24"},
                           {{cs, r8, r12, r13, LSL, 31},
                            false,
                            al,
                            "cs r8 r12 r13 LSL 31",
                            "cs_r8_r12_r13_LSL_31"},
                           {{vc, r5, r8, r4, ROR, 18},
                            false,
                            al,
                            "vc r5 r8 r4 ROR 18",
                            "vc_r5_r8_r4_ROR_18"},
                           {{hi, r13, r4, r9, LSL, 5},
                            false,
                            al,
                            "hi r13 r4 r9 LSL 5",
                            "hi_r13_r4_r9_LSL_5"},
                           {{mi, r1, r13, r8, LSL, 1},
                            false,
                            al,
                            "mi r1 r13 r8 LSL 1",
                            "mi_r1_r13_r8_LSL_1"},
                           {{vs, r7, r8, r12, LSL, 27},
                            false,
                            al,
                            "vs r7 r8 r12 LSL 27",
                            "vs_r7_r8_r12_LSL_27"},
                           {{vs, r11, r2, r12, ROR, 7},
                            false,
                            al,
                            "vs r11 r2 r12 ROR 7",
                            "vs_r11_r2_r12_ROR_7"},
                           {{vs, r11, r3, r5, ROR, 27},
                            false,
                            al,
                            "vs r11 r3 r5 ROR 27",
                            "vs_r11_r3_r5_ROR_27"},
                           {{vc, r9, r1, r8, ROR, 29},
                            false,
                            al,
                            "vc r9 r1 r8 ROR 29",
                            "vc_r9_r1_r8_ROR_29"},
                           {{eq, r2, r1, r5, LSL, 24},
                            false,
                            al,
                            "eq r2 r1 r5 LSL 24",
                            "eq_r2_r1_r5_LSL_24"},
                           {{hi, r1, r14, r14, LSL, 13},
                            false,
                            al,
                            "hi r1 r14 r14 LSL 13",
                            "hi_r1_r14_r14_LSL_13"},
                           {{vc, r12, r13, r5, LSL, 9},
                            false,
                            al,
                            "vc r12 r13 r5 LSL 9",
                            "vc_r12_r13_r5_LSL_9"},
                           {{gt, r9, r10, r9, ROR, 12},
                            false,
                            al,
                            "gt r9 r10 r9 ROR 12",
                            "gt_r9_r10_r9_ROR_12"},
                           {{pl, r3, r7, r3, ROR, 12},
                            false,
                            al,
                            "pl r3 r7 r3 ROR 12",
                            "pl_r3_r7_r3_ROR_12"},
                           {{ls, r7, r14, r8, LSL, 24},
                            false,
                            al,
                            "ls r7 r14 r8 LSL 24",
                            "ls_r7_r14_r8_LSL_24"},
                           {{ge, r2, r11, r5, LSL, 26},
                            false,
                            al,
                            "ge r2 r11 r5 LSL 26",
                            "ge_r2_r11_r5_LSL_26"},
                           {{vc, r8, r11, r13, ROR, 13},
                            false,
                            al,
                            "vc r8 r11 r13 ROR 13",
                            "vc_r8_r11_r13_ROR_13"},
                           {{le, r11, r5, r10, LSL, 16},
                            false,
                            al,
                            "le r11 r5 r10 LSL 16",
                            "le_r11_r5_r10_LSL_16"},
                           {{vc, r10, r14, r4, ROR, 27},
                            false,
                            al,
                            "vc r10 r14 r4 ROR 27",
                            "vc_r10_r14_r4_ROR_27"},
                           {{ge, r8, r6, r12, LSL, 11},
                            false,
                            al,
                            "ge r8 r6 r12 LSL 11",
                            "ge_r8_r6_r12_LSL_11"},
                           {{gt, r13, r0, r14, LSL, 19},
                            false,
                            al,
                            "gt r13 r0 r14 LSL 19",
                            "gt_r13_r0_r14_LSL_19"},
                           {{al, r10, r10, r5, LSL, 13},
                            false,
                            al,
                            "al r10 r10 r5 LSL 13",
                            "al_r10_r10_r5_LSL_13"},
                           {{le, r11, r7, r8, ROR, 5},
                            false,
                            al,
                            "le r11 r7 r8 ROR 5",
                            "le_r11_r7_r8_ROR_5"},
                           {{cc, r12, r14, r7, ROR, 31},
                            false,
                            al,
                            "cc r12 r14 r7 ROR 31",
                            "cc_r12_r14_r7_ROR_31"},
                           {{eq, r11, r4, r12, LSL, 14},
                            false,
                            al,
                            "eq r11 r4 r12 LSL 14",
                            "eq_r11_r4_r12_LSL_14"},
                           {{ne, r0, r7, r9, LSL, 5},
                            false,
                            al,
                            "ne r0 r7 r9 LSL 5",
                            "ne_r0_r7_r9_LSL_5"},
                           {{mi, r11, r4, r8, ROR, 29},
                            false,
                            al,
                            "mi r11 r4 r8 ROR 29",
                            "mi_r11_r4_r8_ROR_29"},
                           {{eq, r6, r14, r2, ROR, 6},
                            false,
                            al,
                            "eq r6 r14 r2 ROR 6",
                            "eq_r6_r14_r2_ROR_6"},
                           {{hi, r6, r6, r4, ROR, 25},
                            false,
                            al,
                            "hi r6 r6 r4 ROR 25",
                            "hi_r6_r6_r4_ROR_25"},
                           {{lt, r4, r8, r3, LSL, 25},
                            false,
                            al,
                            "lt r4 r8 r3 LSL 25",
                            "lt_r4_r8_r3_LSL_25"},
                           {{cc, r7, r14, r2, LSL, 20},
                            false,
                            al,
                            "cc r7 r14 r2 LSL 20",
                            "cc_r7_r14_r2_LSL_20"},
                           {{hi, r3, r12, r7, LSL, 3},
                            false,
                            al,
                            "hi r3 r12 r7 LSL 3",
                            "hi_r3_r12_r7_LSL_3"},
                           {{le, r7, r14, r9, ROR, 17},
                            false,
                            al,
                            "le r7 r14 r9 ROR 17",
                            "le_r7_r14_r9_ROR_17"},
                           {{mi, r4, r11, r13, LSL, 9},
                            false,
                            al,
                            "mi r4 r11 r13 LSL 9",
                            "mi_r4_r11_r13_LSL_9"},
                           {{le, r10, r5, r13, ROR, 4},
                            false,
                            al,
                            "le r10 r5 r13 ROR 4",
                            "le_r10_r5_r13_ROR_4"},
                           {{mi, r12, r12, r13, LSL, 11},
                            false,
                            al,
                            "mi r12 r12 r13 LSL 11",
                            "mi_r12_r12_r13_LSL_11"},
                           {{eq, r5, r12, r1, LSL, 12},
                            false,
                            al,
                            "eq r5 r12 r1 LSL 12",
                            "eq_r5_r12_r1_LSL_12"},
                           {{al, r9, r1, r9, LSL, 30},
                            false,
                            al,
                            "al r9 r1 r9 LSL 30",
                            "al_r9_r1_r9_LSL_30"},
                           {{cc, r7, r13, r4, ROR, 14},
                            false,
                            al,
                            "cc r7 r13 r4 ROR 14",
                            "cc_r7_r13_r4_ROR_14"},
                           {{lt, r2, r0, r2, LSL, 25},
                            false,
                            al,
                            "lt r2 r0 r2 LSL 25",
                            "lt_r2_r0_r2_LSL_25"},
                           {{hi, r2, r13, r13, LSL, 5},
                            false,
                            al,
                            "hi r2 r13 r13 LSL 5",
                            "hi_r2_r13_r13_LSL_5"},
                           {{ls, r9, r9, r11, ROR, 8},
                            false,
                            al,
                            "ls r9 r9 r11 ROR 8",
                            "ls_r9_r9_r11_ROR_8"},
                           {{lt, r3, r9, r4, ROR, 25},
                            false,
                            al,
                            "lt r3 r9 r4 ROR 25",
                            "lt_r3_r9_r4_ROR_25"},
                           {{gt, r12, r6, r1, ROR, 29},
                            false,
                            al,
                            "gt r12 r6 r1 ROR 29",
                            "gt_r12_r6_r1_ROR_29"},
                           {{eq, r9, r11, r0, ROR, 8},
                            false,
                            al,
                            "eq r9 r11 r0 ROR 8",
                            "eq_r9_r11_r0_ROR_8"},
                           {{eq, r14, r13, r12, ROR, 22},
                            false,
                            al,
                            "eq r14 r13 r12 ROR 22",
                            "eq_r14_r13_r12_ROR_22"},
                           {{vs, r2, r13, r2, ROR, 22},
                            false,
                            al,
                            "vs r2 r13 r2 ROR 22",
                            "vs_r2_r13_r2_ROR_22"},
                           {{al, r6, r9, r1, LSL, 13},
                            false,
                            al,
                            "al r6 r9 r1 LSL 13",
                            "al_r6_r9_r1_LSL_13"},
                           {{cc, r9, r0, r10, LSL, 13},
                            false,
                            al,
                            "cc r9 r0 r10 LSL 13",
                            "cc_r9_r0_r10_LSL_13"},
                           {{eq, r2, r14, r10, ROR, 16},
                            false,
                            al,
                            "eq r2 r14 r10 ROR 16",
                            "eq_r2_r14_r10_ROR_16"},
                           {{vc, r0, r0, r14, LSL, 16},
                            false,
                            al,
                            "vc r0 r0 r14 LSL 16",
                            "vc_r0_r0_r14_LSL_16"},
                           {{cc, r12, r5, r6, ROR, 12},
                            false,
                            al,
                            "cc r12 r5 r6 ROR 12",
                            "cc_r12_r5_r6_ROR_12"},
                           {{ge, r4, r9, r14, LSL, 28},
                            false,
                            al,
                            "ge r4 r9 r14 LSL 28",
                            "ge_r4_r9_r14_LSL_28"},
                           {{hi, r12, r10, r9, ROR, 26},
                            false,
                            al,
                            "hi r12 r10 r9 ROR 26",
                            "hi_r12_r10_r9_ROR_26"},
                           {{cs, r6, r14, r8, ROR, 3},
                            false,
                            al,
                            "cs r6 r14 r8 ROR 3",
                            "cs_r6_r14_r8_ROR_3"},
                           {{vs, r3, r8, r12, ROR, 8},
                            false,
                            al,
                            "vs r3 r8 r12 ROR 8",
                            "vs_r3_r8_r12_ROR_8"},
                           {{gt, r0, r1, r5, ROR, 24},
                            false,
                            al,
                            "gt r0 r1 r5 ROR 24",
                            "gt_r0_r1_r5_ROR_24"},
                           {{lt, r10, r9, r1, LSL, 17},
                            false,
                            al,
                            "lt r10 r9 r1 LSL 17",
                            "lt_r10_r9_r1_LSL_17"},
                           {{al, r11, r10, r1, ROR, 23},
                            false,
                            al,
                            "al r11 r10 r1 ROR 23",
                            "al_r11_r10_r1_ROR_23"},
                           {{cs, r8, r4, r2, LSL, 18},
                            false,
                            al,
                            "cs r8 r4 r2 LSL 18",
                            "cs_r8_r4_r2_LSL_18"},
                           {{cc, r4, r4, r6, ROR, 4},
                            false,
                            al,
                            "cc r4 r4 r6 ROR 4",
                            "cc_r4_r4_r6_ROR_4"},
                           {{eq, r7, r4, r10, ROR, 26},
                            false,
                            al,
                            "eq r7 r4 r10 ROR 26",
                            "eq_r7_r4_r10_ROR_26"},
                           {{hi, r6, r12, r14, ROR, 18},
                            false,
                            al,
                            "hi r6 r12 r14 ROR 18",
                            "hi_r6_r12_r14_ROR_18"},
                           {{cs, r14, r1, r4, ROR, 3},
                            false,
                            al,
                            "cs r14 r1 r4 ROR 3",
                            "cs_r14_r1_r4_ROR_3"},
                           {{le, r1, r4, r2, ROR, 1},
                            false,
                            al,
                            "le r1 r4 r2 ROR 1",
                            "le_r1_r4_r2_ROR_1"},
                           {{le, r5, r0, r12, LSL, 10},
                            false,
                            al,
                            "le r5 r0 r12 LSL 10",
                            "le_r5_r0_r12_LSL_10"},
                           {{vs, r2, r6, r12, LSL, 5},
                            false,
                            al,
                            "vs r2 r6 r12 LSL 5",
                            "vs_r2_r6_r12_LSL_5"},
                           {{hi, r6, r12, r10, ROR, 13},
                            false,
                            al,
                            "hi r6 r12 r10 ROR 13",
                            "hi_r6_r12_r10_ROR_13"},
                           {{lt, r7, r9, r1, ROR, 22},
                            false,
                            al,
                            "lt r7 r9 r1 ROR 22",
                            "lt_r7_r9_r1_ROR_22"},
                           {{mi, r13, r6, r4, LSL, 6},
                            false,
                            al,
                            "mi r13 r6 r4 LSL 6",
                            "mi_r13_r6_r4_LSL_6"},
                           {{vs, r11, r11, r3, LSL, 27},
                            false,
                            al,
                            "vs r11 r11 r3 LSL 27",
                            "vs_r11_r11_r3_LSL_27"},
                           {{ne, r3, r7, r14, LSL, 17},
                            false,
                            al,
                            "ne r3 r7 r14 LSL 17",
                            "ne_r3_r7_r14_LSL_17"},
                           {{lt, r13, r13, r14, LSL, 17},
                            false,
                            al,
                            "lt r13 r13 r14 LSL 17",
                            "lt_r13_r13_r14_LSL_17"},
                           {{pl, r7, r3, r2, LSL, 1},
                            false,
                            al,
                            "pl r7 r3 r2 LSL 1",
                            "pl_r7_r3_r2_LSL_1"},
                           {{ls, r12, r11, r2, LSL, 24},
                            false,
                            al,
                            "ls r12 r11 r2 LSL 24",
                            "ls_r12_r11_r2_LSL_24"},
                           {{al, r9, r7, r12, ROR, 17},
                            false,
                            al,
                            "al r9 r7 r12 ROR 17",
                            "al_r9_r7_r12_ROR_17"},
                           {{cs, r4, r7, r13, LSL, 21},
                            false,
                            al,
                            "cs r4 r7 r13 LSL 21",
                            "cs_r4_r7_r13_LSL_21"},
                           {{eq, r4, r14, r11, ROR, 12},
                            false,
                            al,
                            "eq r4 r14 r11 ROR 12",
                            "eq_r4_r14_r11_ROR_12"},
                           {{pl, r3, r13, r11, LSL, 11},
                            false,
                            al,
                            "pl r3 r13 r11 LSL 11",
                            "pl_r3_r13_r11_LSL_11"},
                           {{pl, r10, r12, r4, ROR, 8},
                            false,
                            al,
                            "pl r10 r12 r4 ROR 8",
                            "pl_r10_r12_r4_ROR_8"},
                           {{gt, r8, r9, r8, ROR, 14},
                            false,
                            al,
                            "gt r8 r9 r8 ROR 14",
                            "gt_r8_r9_r8_ROR_14"},
                           {{ne, r0, r0, r7, ROR, 12},
                            false,
                            al,
                            "ne r0 r0 r7 ROR 12",
                            "ne_r0_r0_r7_ROR_12"},
                           {{cc, r8, r0, r5, ROR, 20},
                            false,
                            al,
                            "cc r8 r0 r5 ROR 20",
                            "cc_r8_r0_r5_ROR_20"},
                           {{cc, r1, r2, r6, ROR, 1},
                            false,
                            al,
                            "cc r1 r2 r6 ROR 1",
                            "cc_r1_r2_r6_ROR_1"},
                           {{al, r1, r3, r4, LSL, 30},
                            false,
                            al,
                            "al r1 r3 r4 LSL 30",
                            "al_r1_r3_r4_LSL_30"},
                           {{cs, r5, r3, r7, LSL, 25},
                            false,
                            al,
                            "cs r5 r3 r7 LSL 25",
                            "cs_r5_r3_r7_LSL_25"},
                           {{ne, r6, r10, r12, LSL, 12},
                            false,
                            al,
                            "ne r6 r10 r12 LSL 12",
                            "ne_r6_r10_r12_LSL_12"},
                           {{gt, r14, r7, r9, LSL, 24},
                            false,
                            al,
                            "gt r14 r7 r9 LSL 24",
                            "gt_r14_r7_r9_LSL_24"},
                           {{pl, r14, r0, r1, LSL, 24},
                            false,
                            al,
                            "pl r14 r0 r1 LSL 24",
                            "pl_r14_r0_r1_LSL_24"},
                           {{cs, r7, r5, r13, LSL, 14},
                            false,
                            al,
                            "cs r7 r5 r13 LSL 14",
                            "cs_r7_r5_r13_LSL_14"},
                           {{cc, r3, r2, r7, LSL, 4},
                            false,
                            al,
                            "cc r3 r2 r7 LSL 4",
                            "cc_r3_r2_r7_LSL_4"},
                           {{vc, r9, r4, r11, ROR, 1},
                            false,
                            al,
                            "vc r9 r4 r11 ROR 1",
                            "vc_r9_r4_r11_ROR_1"},
                           {{vc, r14, r11, r2, ROR, 9},
                            false,
                            al,
                            "vc r14 r11 r2 ROR 9",
                            "vc_r14_r11_r2_ROR_9"},
                           {{mi, r5, r8, r13, LSL, 19},
                            false,
                            al,
                            "mi r5 r8 r13 LSL 19",
                            "mi_r5_r8_r13_LSL_19"},
                           {{eq, r11, r8, r3, LSL, 12},
                            false,
                            al,
                            "eq r11 r8 r3 LSL 12",
                            "eq_r11_r8_r3_LSL_12"},
                           {{vc, r9, r9, r5, LSL, 1},
                            false,
                            al,
                            "vc r9 r9 r5 LSL 1",
                            "vc_r9_r9_r5_LSL_1"},
                           {{gt, r10, r10, r3, ROR, 30},
                            false,
                            al,
                            "gt r10 r10 r3 ROR 30",
                            "gt_r10_r10_r3_ROR_30"},
                           {{mi, r8, r0, r12, ROR, 31},
                            false,
                            al,
                            "mi r8 r0 r12 ROR 31",
                            "mi_r8_r0_r12_ROR_31"},
                           {{ge, r7, r12, r12, LSL, 6},
                            false,
                            al,
                            "ge r7 r12 r12 LSL 6",
                            "ge_r7_r12_r12_LSL_6"},
                           {{ge, r5, r0, r12, LSL, 16},
                            false,
                            al,
                            "ge r5 r0 r12 LSL 16",
                            "ge_r5_r0_r12_LSL_16"},
                           {{gt, r3, r5, r14, ROR, 8},
                            false,
                            al,
                            "gt r3 r5 r14 ROR 8",
                            "gt_r3_r5_r14_ROR_8"},
                           {{ls, r0, r11, r9, ROR, 26},
                            false,
                            al,
                            "ls r0 r11 r9 ROR 26",
                            "ls_r0_r11_r9_ROR_26"},
                           {{al, r1, r4, r6, LSL, 9},
                            false,
                            al,
                            "al r1 r4 r6 LSL 9",
                            "al_r1_r4_r6_LSL_9"},
                           {{cs, r6, r5, r3, ROR, 10},
                            false,
                            al,
                            "cs r6 r5 r3 ROR 10",
                            "cs_r6_r5_r3_ROR_10"},
                           {{mi, r10, r3, r3, LSL, 13},
                            false,
                            al,
                            "mi r10 r3 r3 LSL 13",
                            "mi_r10_r3_r3_LSL_13"},
                           {{lt, r7, r12, r11, LSL, 12},
                            false,
                            al,
                            "lt r7 r12 r11 LSL 12",
                            "lt_r7_r12_r11_LSL_12"},
                           {{cc, r10, r0, r9, ROR, 23},
                            false,
                            al,
                            "cc r10 r0 r9 ROR 23",
                            "cc_r10_r0_r9_ROR_23"},
                           {{vc, r13, r11, r7, ROR, 26},
                            false,
                            al,
                            "vc r13 r11 r7 ROR 26",
                            "vc_r13_r11_r7_ROR_26"},
                           {{pl, r1, r14, r11, LSL, 12},
                            false,
                            al,
                            "pl r1 r14 r11 LSL 12",
                            "pl_r1_r14_r11_LSL_12"},
                           {{al, r9, r2, r5, LSL, 19},
                            false,
                            al,
                            "al r9 r2 r5 LSL 19",
                            "al_r9_r2_r5_LSL_19"},
                           {{mi, r5, r0, r8, LSL, 8},
                            false,
                            al,
                            "mi r5 r0 r8 LSL 8",
                            "mi_r5_r0_r8_LSL_8"},
                           {{ge, r11, r1, r0, LSL, 8},
                            false,
                            al,
                            "ge r11 r1 r0 LSL 8",
                            "ge_r11_r1_r0_LSL_8"},
                           {{ls, r12, r8, r11, ROR, 4},
                            false,
                            al,
                            "ls r12 r8 r11 ROR 4",
                            "ls_r12_r8_r11_ROR_4"},
                           {{ne, r7, r1, r2, ROR, 13},
                            false,
                            al,
                            "ne r7 r1 r2 ROR 13",
                            "ne_r7_r1_r2_ROR_13"},
                           {{ge, r10, r1, r4, ROR, 4},
                            false,
                            al,
                            "ge r10 r1 r4 ROR 4",
                            "ge_r10_r1_r4_ROR_4"},
                           {{cc, r4, r3, r3, ROR, 20},
                            false,
                            al,
                            "cc r4 r3 r3 ROR 20",
                            "cc_r4_r3_r3_ROR_20"},
                           {{ne, r6, r14, r7, LSL, 30},
                            false,
                            al,
                            "ne r6 r14 r7 LSL 30",
                            "ne_r6_r14_r7_LSL_30"},
                           {{vs, r14, r2, r8, ROR, 16},
                            false,
                            al,
                            "vs r14 r2 r8 ROR 16",
                            "vs_r14_r2_r8_ROR_16"},
                           {{hi, r3, r13, r9, ROR, 10},
                            false,
                            al,
                            "hi r3 r13 r9 ROR 10",
                            "hi_r3_r13_r9_ROR_10"},
                           {{gt, r10, r2, r11, LSL, 30},
                            false,
                            al,
                            "gt r10 r2 r11 LSL 30",
                            "gt_r10_r2_r11_LSL_30"},
                           {{gt, r4, r7, r8, ROR, 8},
                            false,
                            al,
                            "gt r4 r7 r8 ROR 8",
                            "gt_r4_r7_r8_ROR_8"},
                           {{pl, r1, r0, r12, LSL, 14},
                            false,
                            al,
                            "pl r1 r0 r12 LSL 14",
                            "pl_r1_r0_r12_LSL_14"},
                           {{mi, r6, r14, r8, LSL, 11},
                            false,
                            al,
                            "mi r6 r14 r8 LSL 11",
                            "mi_r6_r14_r8_LSL_11"},
                           {{vs, r9, r4, r13, ROR, 1},
                            false,
                            al,
                            "vs r9 r4 r13 ROR 1",
                            "vs_r9_r4_r13_ROR_1"},
                           {{ls, r14, r7, r11, LSL, 14},
                            false,
                            al,
                            "ls r14 r7 r11 LSL 14",
                            "ls_r14_r7_r11_LSL_14"},
                           {{al, r7, r14, r5, LSL, 3},
                            false,
                            al,
                            "al r7 r14 r5 LSL 3",
                            "al_r7_r14_r5_LSL_3"},
                           {{ge, r1, r7, r3, LSL, 8},
                            false,
                            al,
                            "ge r1 r7 r3 LSL 8",
                            "ge_r1_r7_r3_LSL_8"},
                           {{eq, r1, r11, r13, ROR, 21},
                            false,
                            al,
                            "eq r1 r11 r13 ROR 21",
                            "eq_r1_r11_r13_ROR_21"},
                           {{mi, r2, r0, r5, ROR, 19},
                            false,
                            al,
                            "mi r2 r0 r5 ROR 19",
                            "mi_r2_r0_r5_ROR_19"},
                           {{pl, r2, r9, r5, ROR, 24},
                            false,
                            al,
                            "pl r2 r9 r5 ROR 24",
                            "pl_r2_r9_r5_ROR_24"},
                           {{mi, r4, r2, r9, ROR, 10},
                            false,
                            al,
                            "mi r4 r2 r9 ROR 10",
                            "mi_r4_r2_r9_ROR_10"},
                           {{ge, r2, r13, r8, LSL, 26},
                            false,
                            al,
                            "ge r2 r13 r8 LSL 26",
                            "ge_r2_r13_r8_LSL_26"},
                           {{cs, r2, r4, r3, ROR, 4},
                            false,
                            al,
                            "cs r2 r4 r3 ROR 4",
                            "cs_r2_r4_r3_ROR_4"},
                           {{ge, r10, r9, r5, ROR, 31},
                            false,
                            al,
                            "ge r10 r9 r5 ROR 31",
                            "ge_r10_r9_r5_ROR_31"},
                           {{cc, r9, r4, r3, LSL, 8},
                            false,
                            al,
                            "cc r9 r4 r3 LSL 8",
                            "cc_r9_r4_r3_LSL_8"},
                           {{le, r8, r0, r10, ROR, 23},
                            false,
                            al,
                            "le r8 r0 r10 ROR 23",
                            "le_r8_r0_r10_ROR_23"},
                           {{gt, r11, r5, r4, ROR, 3},
                            false,
                            al,
                            "gt r11 r5 r4 ROR 3",
                            "gt_r11_r5_r4_ROR_3"},
                           {{ne, r0, r4, r0, ROR, 12},
                            false,
                            al,
                            "ne r0 r4 r0 ROR 12",
                            "ne_r0_r4_r0_ROR_12"},
                           {{hi, r8, r10, r13, LSL, 3},
                            false,
                            al,
                            "hi r8 r10 r13 LSL 3",
                            "hi_r8_r10_r13_LSL_3"},
                           {{ge, r2, r3, r3, ROR, 15},
                            false,
                            al,
                            "ge r2 r3 r3 ROR 15",
                            "ge_r2_r3_r3_ROR_15"},
                           {{cc, r2, r10, r4, LSL, 17},
                            false,
                            al,
                            "cc r2 r10 r4 LSL 17",
                            "cc_r2_r10_r4_LSL_17"},
                           {{cs, r5, r14, r10, ROR, 30},
                            false,
                            al,
                            "cs r5 r14 r10 ROR 30",
                            "cs_r5_r14_r10_ROR_30"},
                           {{cs, r11, r13, r2, ROR, 22},
                            false,
                            al,
                            "cs r11 r13 r2 ROR 22",
                            "cs_r11_r13_r2_ROR_22"},
                           {{eq, r12, r5, r9, ROR, 10},
                            false,
                            al,
                            "eq r12 r5 r9 ROR 10",
                            "eq_r12_r5_r9_ROR_10"},
                           {{pl, r11, r2, r12, LSL, 29},
                            false,
                            al,
                            "pl r11 r2 r12 LSL 29",
                            "pl_r11_r2_r12_LSL_29"},
                           {{vs, r5, r3, r7, LSL, 21},
                            false,
                            al,
                            "vs r5 r3 r7 LSL 21",
                            "vs_r5_r3_r7_LSL_21"},
                           {{vs, r14, r0, r6, LSL, 27},
                            false,
                            al,
                            "vs r14 r0 r6 LSL 27",
                            "vs_r14_r0_r6_LSL_27"},
                           {{mi, r4, r5, r0, ROR, 25},
                            false,
                            al,
                            "mi r4 r5 r0 ROR 25",
                            "mi_r4_r5_r0_ROR_25"},
                           {{ls, r7, r6, r13, LSL, 3},
                            false,
                            al,
                            "ls r7 r6 r13 LSL 3",
                            "ls_r7_r6_r13_LSL_3"},
                           {{pl, r9, r12, r8, ROR, 17},
                            false,
                            al,
                            "pl r9 r12 r8 ROR 17",
                            "pl_r9_r12_r8_ROR_17"},
                           {{ge, r12, r0, r9, LSL, 20},
                            false,
                            al,
                            "ge r12 r0 r9 LSL 20",
                            "ge_r12_r0_r9_LSL_20"},
                           {{pl, r4, r12, r11, LSL, 7},
                            false,
                            al,
                            "pl r4 r12 r11 LSL 7",
                            "pl_r4_r12_r11_LSL_7"},
                           {{al, r12, r10, r2, ROR, 4},
                            false,
                            al,
                            "al r12 r10 r2 ROR 4",
                            "al_r12_r10_r2_ROR_4"},
                           {{le, r10, r7, r14, ROR, 5},
                            false,
                            al,
                            "le r10 r7 r14 ROR 5",
                            "le_r10_r7_r14_ROR_5"},
                           {{mi, r0, r2, r5, ROR, 24},
                            false,
                            al,
                            "mi r0 r2 r5 ROR 24",
                            "mi_r0_r2_r5_ROR_24"},
                           {{pl, r10, r2, r6, ROR, 28},
                            false,
                            al,
                            "pl r10 r2 r6 ROR 28",
                            "pl_r10_r2_r6_ROR_28"},
                           {{al, r0, r4, r9, LSL, 27},
                            false,
                            al,
                            "al r0 r4 r9 LSL 27",
                            "al_r0_r4_r9_LSL_27"},
                           {{eq, r12, r0, r7, ROR, 7},
                            false,
                            al,
                            "eq r12 r0 r7 ROR 7",
                            "eq_r12_r0_r7_ROR_7"},
                           {{ls, r8, r8, r0, LSL, 13},
                            false,
                            al,
                            "ls r8 r8 r0 LSL 13",
                            "ls_r8_r8_r0_LSL_13"},
                           {{le, r1, r10, r7, LSL, 24},
                            false,
                            al,
                            "le r1 r10 r7 LSL 24",
                            "le_r1_r10_r7_LSL_24"},
                           {{ne, r10, r4, r13, ROR, 26},
                            false,
                            al,
                            "ne r10 r4 r13 ROR 26",
                            "ne_r10_r4_r13_ROR_26"},
                           {{gt, r2, r5, r2, LSL, 1},
                            false,
                            al,
                            "gt r2 r5 r2 LSL 1",
                            "gt_r2_r5_r2_LSL_1"},
                           {{hi, r3, r4, r11, LSL, 26},
                            false,
                            al,
                            "hi r3 r4 r11 LSL 26",
                            "hi_r3_r4_r11_LSL_26"},
                           {{vc, r0, r9, r6, ROR, 25},
                            false,
                            al,
                            "vc r0 r9 r6 ROR 25",
                            "vc_r0_r9_r6_ROR_25"},
                           {{lt, r13, r5, r0, ROR, 4},
                            false,
                            al,
                            "lt r13 r5 r0 ROR 4",
                            "lt_r13_r5_r0_ROR_4"},
                           {{lt, r9, r5, r0, ROR, 27},
                            false,
                            al,
                            "lt r9 r5 r0 ROR 27",
                            "lt_r9_r5_r0_ROR_27"},
                           {{le, r8, r13, r0, LSL, 7},
                            false,
                            al,
                            "le r8 r13 r0 LSL 7",
                            "le_r8_r13_r0_LSL_7"},
                           {{vc, r5, r7, r1, ROR, 10},
                            false,
                            al,
                            "vc r5 r7 r1 ROR 10",
                            "vc_r5_r7_r1_ROR_10"},
                           {{lt, r8, r2, r12, ROR, 25},
                            false,
                            al,
                            "lt r8 r2 r12 ROR 25",
                            "lt_r8_r2_r12_ROR_25"},
                           {{al, r14, r10, r2, LSL, 29},
                            false,
                            al,
                            "al r14 r10 r2 LSL 29",
                            "al_r14_r10_r2_LSL_29"},
                           {{cs, r14, r5, r14, LSL, 12},
                            false,
                            al,
                            "cs r14 r5 r14 LSL 12",
                            "cs_r14_r5_r14_LSL_12"},
                           {{cc, r1, r12, r14, ROR, 24},
                            false,
                            al,
                            "cc r1 r12 r14 ROR 24",
                            "cc_r1_r12_r14_ROR_24"},
                           {{vc, r13, r13, r8, LSL, 23},
                            false,
                            al,
                            "vc r13 r13 r8 LSL 23",
                            "vc_r13_r13_r8_LSL_23"},
                           {{mi, r2, r0, r8, LSL, 8},
                            false,
                            al,
                            "mi r2 r0 r8 LSL 8",
                            "mi_r2_r0_r8_LSL_8"},
                           {{hi, r4, r10, r8, LSL, 11},
                            false,
                            al,
                            "hi r4 r10 r8 LSL 11",
                            "hi_r4_r10_r8_LSL_11"},
                           {{eq, r10, r12, r4, ROR, 11},
                            false,
                            al,
                            "eq r10 r12 r4 ROR 11",
                            "eq_r10_r12_r4_ROR_11"},
                           {{hi, r14, r1, r7, ROR, 2},
                            false,
                            al,
                            "hi r14 r1 r7 ROR 2",
                            "hi_r14_r1_r7_ROR_2"},
                           {{le, r11, r5, r12, LSL, 23},
                            false,
                            al,
                            "le r11 r5 r12 LSL 23",
                            "le_r11_r5_r12_LSL_23"},
                           {{vs, r13, r1, r1, ROR, 17},
                            false,
                            al,
                            "vs r13 r1 r1 ROR 17",
                            "vs_r13_r1_r1_ROR_17"},
                           {{vc, r14, r14, r8, LSL, 9},
                            false,
                            al,
                            "vc r14 r14 r8 LSL 9",
                            "vc_r14_r14_r8_LSL_9"},
                           {{pl, r0, r13, r11, ROR, 27},
                            false,
                            al,
                            "pl r0 r13 r11 ROR 27",
                            "pl_r0_r13_r11_ROR_27"},
                           {{eq, r7, r0, r5, ROR, 5},
                            false,
                            al,
                            "eq r7 r0 r5 ROR 5",
                            "eq_r7_r0_r5_ROR_5"},
                           {{al, r2, r5, r12, ROR, 18},
                            false,
                            al,
                            "al r2 r5 r12 ROR 18",
                            "al_r2_r5_r12_ROR_18"},
                           {{le, r13, r7, r12, ROR, 26},
                            false,
                            al,
                            "le r13 r7 r12 ROR 26",
                            "le_r13_r7_r12_ROR_26"},
                           {{ne, r12, r13, r12, LSL, 1},
                            false,
                            al,
                            "ne r12 r13 r12 LSL 1",
                            "ne_r12_r13_r12_LSL_1"},
                           {{hi, r5, r10, r11, LSL, 29},
                            false,
                            al,
                            "hi r5 r10 r11 LSL 29",
                            "hi_r5_r10_r11_LSL_29"},
                           {{cs, r3, r13, r9, LSL, 22},
                            false,
                            al,
                            "cs r3 r13 r9 LSL 22",
                            "cs_r3_r13_r9_LSL_22"},
                           {{vc, r3, r13, r14, ROR, 31},
                            false,
                            al,
                            "vc r3 r13 r14 ROR 31",
                            "vc_r3_r13_r14_ROR_31"},
                           {{le, r0, r10, r1, ROR, 27},
                            false,
                            al,
                            "le r0 r10 r1 ROR 27",
                            "le_r0_r10_r1_ROR_27"},
                           {{cc, r11, r5, r2, ROR, 16},
                            false,
                            al,
                            "cc r11 r5 r2 ROR 16",
                            "cc_r11_r5_r2_ROR_16"},
                           {{le, r7, r2, r1, LSL, 8},
                            false,
                            al,
                            "le r7 r2 r1 LSL 8",
                            "le_r7_r2_r1_LSL_8"},
                           {{vs, r9, r6, r8, ROR, 13},
                            false,
                            al,
                            "vs r9 r6 r8 ROR 13",
                            "vs_r9_r6_r8_ROR_13"},
                           {{le, r8, r4, r1, ROR, 31},
                            false,
                            al,
                            "le r8 r4 r1 ROR 31",
                            "le_r8_r4_r1_ROR_31"},
                           {{le, r6, r7, r9, ROR, 29},
                            false,
                            al,
                            "le r6 r7 r9 ROR 29",
                            "le_r6_r7_r9_ROR_29"},
                           {{ls, r6, r13, r11, ROR, 14},
                            false,
                            al,
                            "ls r6 r13 r11 ROR 14",
                            "ls_r6_r13_r11_ROR_14"},
                           {{lt, r2, r7, r3, ROR, 20},
                            false,
                            al,
                            "lt r2 r7 r3 ROR 20",
                            "lt_r2_r7_r3_ROR_20"},
                           {{ne, r3, r9, r5, LSL, 12},
                            false,
                            al,
                            "ne r3 r9 r5 LSL 12",
                            "ne_r3_r9_r5_LSL_12"},
                           {{ge, r11, r0, r2, ROR, 31},
                            false,
                            al,
                            "ge r11 r0 r2 ROR 31",
                            "ge_r11_r0_r2_ROR_31"},
                           {{eq, r14, r11, r0, LSL, 22},
                            false,
                            al,
                            "eq r14 r11 r0 LSL 22",
                            "eq_r14_r11_r0_LSL_22"},
                           {{cs, r6, r3, r9, ROR, 6},
                            false,
                            al,
                            "cs r6 r3 r9 ROR 6",
                            "cs_r6_r3_r9_ROR_6"},
                           {{mi, r6, r8, r5, LSL, 15},
                            false,
                            al,
                            "mi r6 r8 r5 LSL 15",
                            "mi_r6_r8_r5_LSL_15"},
                           {{ne, r9, r12, r1, ROR, 13},
                            false,
                            al,
                            "ne r9 r12 r1 ROR 13",
                            "ne_r9_r12_r1_ROR_13"},
                           {{al, r12, r2, r0, LSL, 4},
                            false,
                            al,
                            "al r12 r2 r0 LSL 4",
                            "al_r12_r2_r0_LSL_4"},
                           {{vs, r0, r10, r9, LSL, 14},
                            false,
                            al,
                            "vs r0 r10 r9 LSL 14",
                            "vs_r0_r10_r9_LSL_14"},
                           {{vc, r13, r2, r10, ROR, 4},
                            false,
                            al,
                            "vc r13 r2 r10 ROR 4",
                            "vc_r13_r2_r10_ROR_4"},
                           {{le, r11, r3, r4, ROR, 4},
                            false,
                            al,
                            "le r11 r3 r4 ROR 4",
                            "le_r11_r3_r4_ROR_4"},
                           {{cc, r3, r6, r14, ROR, 11},
                            false,
                            al,
                            "cc r3 r6 r14 ROR 11",
                            "cc_r3_r6_r14_ROR_11"},
                           {{le, r7, r7, r0, LSL, 1},
                            false,
                            al,
                            "le r7 r7 r0 LSL 1",
                            "le_r7_r7_r0_LSL_1"},
                           {{lt, r4, r4, r10, ROR, 10},
                            false,
                            al,
                            "lt r4 r4 r10 ROR 10",
                            "lt_r4_r4_r10_ROR_10"},
                           {{cc, r6, r14, r6, LSL, 9},
                            false,
                            al,
                            "cc r6 r14 r6 LSL 9",
                            "cc_r6_r14_r6_LSL_9"},
                           {{ne, r12, r9, r5, LSL, 18},
                            false,
                            al,
                            "ne r12 r9 r5 LSL 18",
                            "ne_r12_r9_r5_LSL_18"},
                           {{hi, r2, r8, r0, ROR, 23},
                            false,
                            al,
                            "hi r2 r8 r0 ROR 23",
                            "hi_r2_r8_r0_ROR_23"},
                           {{hi, r14, r13, r11, ROR, 3},
                            false,
                            al,
                            "hi r14 r13 r11 ROR 3",
                            "hi_r14_r13_r11_ROR_3"},
                           {{al, r9, r6, r10, ROR, 20},
                            false,
                            al,
                            "al r9 r6 r10 ROR 20",
                            "al_r9_r6_r10_ROR_20"},
                           {{vc, r8, r12, r11, ROR, 6},
                            false,
                            al,
                            "vc r8 r12 r11 ROR 6",
                            "vc_r8_r12_r11_ROR_6"},
                           {{cc, r2, r1, r8, ROR, 5},
                            false,
                            al,
                            "cc r2 r1 r8 ROR 5",
                            "cc_r2_r1_r8_ROR_5"},
                           {{ge, r0, r4, r10, LSL, 24},
                            false,
                            al,
                            "ge r0 r4 r10 LSL 24",
                            "ge_r0_r4_r10_LSL_24"},
                           {{vc, r12, r7, r8, ROR, 27},
                            false,
                            al,
                            "vc r12 r7 r8 ROR 27",
                            "vc_r12_r7_r8_ROR_27"},
                           {{le, r13, r6, r4, LSL, 11},
                            false,
                            al,
                            "le r13 r6 r4 LSL 11",
                            "le_r13_r6_r4_LSL_11"},
                           {{le, r6, r5, r4, LSL, 25},
                            false,
                            al,
                            "le r6 r5 r4 LSL 25",
                            "le_r6_r5_r4_LSL_25"},
                           {{eq, r9, r7, r7, LSL, 23},
                            false,
                            al,
                            "eq r9 r7 r7 LSL 23",
                            "eq_r9_r7_r7_LSL_23"},
                           {{mi, r2, r6, r9, LSL, 23},
                            false,
                            al,
                            "mi r2 r6 r9 LSL 23",
                            "mi_r2_r6_r9_LSL_23"},
                           {{pl, r0, r6, r13, ROR, 24},
                            false,
                            al,
                            "pl r0 r6 r13 ROR 24",
                            "pl_r0_r6_r13_ROR_24"},
                           {{le, r13, r8, r4, LSL, 18},
                            false,
                            al,
                            "le r13 r8 r4 LSL 18",
                            "le_r13_r8_r4_LSL_18"},
                           {{mi, r9, r6, r12, LSL, 10},
                            false,
                            al,
                            "mi r9 r6 r12 LSL 10",
                            "mi_r9_r6_r12_LSL_10"},
                           {{al, r10, r3, r12, ROR, 2},
                            false,
                            al,
                            "al r10 r3 r12 ROR 2",
                            "al_r10_r3_r12_ROR_2"},
                           {{ge, r9, r12, r4, LSL, 10},
                            false,
                            al,
                            "ge r9 r12 r4 LSL 10",
                            "ge_r9_r12_r4_LSL_10"},
                           {{vs, r11, r1, r4, LSL, 17},
                            false,
                            al,
                            "vs r11 r1 r4 LSL 17",
                            "vs_r11_r1_r4_LSL_17"},
                           {{gt, r14, r10, r0, LSL, 7},
                            false,
                            al,
                            "gt r14 r10 r0 LSL 7",
                            "gt_r14_r10_r0_LSL_7"},
                           {{eq, r13, r14, r12, ROR, 30},
                            false,
                            al,
                            "eq r13 r14 r12 ROR 30",
                            "eq_r13_r14_r12_ROR_30"},
                           {{eq, r14, r10, r11, ROR, 11},
                            false,
                            al,
                            "eq r14 r10 r11 ROR 11",
                            "eq_r14_r10_r11_ROR_11"},
                           {{vs, r9, r0, r1, ROR, 30},
                            false,
                            al,
                            "vs r9 r0 r1 ROR 30",
                            "vs_r9_r0_r1_ROR_30"},
                           {{vc, r7, r10, r6, LSL, 23},
                            false,
                            al,
                            "vc r7 r10 r6 LSL 23",
                            "vc_r7_r10_r6_LSL_23"},
                           {{vc, r6, r1, r14, LSL, 10},
                            false,
                            al,
                            "vc r6 r1 r14 LSL 10",
                            "vc_r6_r1_r14_LSL_10"},
                           {{pl, r7, r2, r4, LSL, 11},
                            false,
                            al,
                            "pl r7 r2 r4 LSL 11",
                            "pl_r7_r2_r4_LSL_11"},
                           {{cc, r13, r5, r7, LSL, 5},
                            false,
                            al,
                            "cc r13 r5 r7 LSL 5",
                            "cc_r13_r5_r7_LSL_5"},
                           {{pl, r14, r10, r3, LSL, 15},
                            false,
                            al,
                            "pl r14 r10 r3 LSL 15",
                            "pl_r14_r10_r3_LSL_15"},
                           {{ge, r13, r6, r14, LSL, 31},
                            false,
                            al,
                            "ge r13 r6 r14 LSL 31",
                            "ge_r13_r6_r14_LSL_31"},
                           {{mi, r4, r6, r10, LSL, 30},
                            false,
                            al,
                            "mi r4 r6 r10 LSL 30",
                            "mi_r4_r6_r10_LSL_30"},
                           {{cs, r1, r0, r9, ROR, 12},
                            false,
                            al,
                            "cs r1 r0 r9 ROR 12",
                            "cs_r1_r0_r9_ROR_12"},
                           {{vs, r4, r14, r13, ROR, 17},
                            false,
                            al,
                            "vs r4 r14 r13 ROR 17",
                            "vs_r4_r14_r13_ROR_17"},
                           {{cs, r14, r7, r1, LSL, 22},
                            false,
                            al,
                            "cs r14 r7 r1 LSL 22",
                            "cs_r14_r7_r1_LSL_22"},
                           {{vs, r8, r7, r11, LSL, 4},
                            false,
                            al,
                            "vs r8 r7 r11 LSL 4",
                            "vs_r8_r7_r11_LSL_4"},
                           {{ge, r10, r2, r11, ROR, 2},
                            false,
                            al,
                            "ge r10 r2 r11 ROR 2",
                            "ge_r10_r2_r11_ROR_2"},
                           {{hi, r12, r13, r0, LSL, 8},
                            false,
                            al,
                            "hi r12 r13 r0 LSL 8",
                            "hi_r12_r13_r0_LSL_8"},
                           {{vc, r11, r1, r2, LSL, 29},
                            false,
                            al,
                            "vc r11 r1 r2 LSL 29",
                            "vc_r11_r1_r2_LSL_29"},
                           {{ls, r11, r13, r13, LSL, 5},
                            false,
                            al,
                            "ls r11 r13 r13 LSL 5",
                            "ls_r11_r13_r13_LSL_5"},
                           {{vs, r5, r1, r14, ROR, 12},
                            false,
                            al,
                            "vs r5 r1 r14 ROR 12",
                            "vs_r5_r1_r14_ROR_12"},
                           {{mi, r12, r1, r8, LSL, 24},
                            false,
                            al,
                            "mi r12 r1 r8 LSL 24",
                            "mi_r12_r1_r8_LSL_24"},
                           {{ne, r14, r6, r4, ROR, 29},
                            false,
                            al,
                            "ne r14 r6 r4 ROR 29",
                            "ne_r14_r6_r4_ROR_29"},
                           {{eq, r5, r7, r13, LSL, 31},
                            false,
                            al,
                            "eq r5 r7 r13 LSL 31",
                            "eq_r5_r7_r13_LSL_31"},
                           {{le, r14, r4, r12, ROR, 3},
                            false,
                            al,
                            "le r14 r4 r12 ROR 3",
                            "le_r14_r4_r12_ROR_3"},
                           {{gt, r5, r11, r14, LSL, 27},
                            false,
                            al,
                            "gt r5 r11 r14 LSL 27",
                            "gt_r5_r11_r14_LSL_27"},
                           {{pl, r8, r3, r2, ROR, 12},
                            false,
                            al,
                            "pl r8 r3 r2 ROR 12",
                            "pl_r8_r3_r2_ROR_12"},
                           {{cc, r4, r7, r2, LSL, 5},
                            false,
                            al,
                            "cc r4 r7 r2 LSL 5",
                            "cc_r4_r7_r2_LSL_5"},
                           {{gt, r8, r7, r1, ROR, 24},
                            false,
                            al,
                            "gt r8 r7 r1 ROR 24",
                            "gt_r8_r7_r1_ROR_24"},
                           {{hi, r12, r14, r13, ROR, 8},
                            false,
                            al,
                            "hi r12 r14 r13 ROR 8",
                            "hi_r12_r14_r13_ROR_8"},
                           {{cc, r13, r10, r5, LSL, 4},
                            false,
                            al,
                            "cc r13 r10 r5 LSL 4",
                            "cc_r13_r10_r5_LSL_4"},
                           {{eq, r6, r7, r2, LSL, 29},
                            false,
                            al,
                            "eq r6 r7 r2 LSL 29",
                            "eq_r6_r7_r2_LSL_29"},
                           {{eq, r7, r10, r1, ROR, 14},
                            false,
                            al,
                            "eq r7 r10 r1 ROR 14",
                            "eq_r7_r10_r1_ROR_14"},
                           {{mi, r13, r1, r3, ROR, 26},
                            false,
                            al,
                            "mi r13 r1 r3 ROR 26",
                            "mi_r13_r1_r3_ROR_26"},
                           {{ge, r6, r14, r14, ROR, 13},
                            false,
                            al,
                            "ge r6 r14 r14 ROR 13",
                            "ge_r6_r14_r14_ROR_13"},
                           {{gt, r3, r8, r4, LSL, 31},
                            false,
                            al,
                            "gt r3 r8 r4 LSL 31",
                            "gt_r3_r8_r4_LSL_31"},
                           {{mi, r13, r12, r2, ROR, 12},
                            false,
                            al,
                            "mi r13 r12 r2 ROR 12",
                            "mi_r13_r12_r2_ROR_12"},
                           {{al, r12, r5, r1, ROR, 25},
                            false,
                            al,
                            "al r12 r5 r1 ROR 25",
                            "al_r12_r5_r1_ROR_25"},
                           {{eq, r8, r13, r6, ROR, 8},
                            false,
                            al,
                            "eq r8 r13 r6 ROR 8",
                            "eq_r8_r13_r6_ROR_8"},
                           {{ne, r10, r1, r11, ROR, 12},
                            false,
                            al,
                            "ne r10 r1 r11 ROR 12",
                            "ne_r10_r1_r11_ROR_12"},
                           {{hi, r8, r7, r11, LSL, 30},
                            false,
                            al,
                            "hi r8 r7 r11 LSL 30",
                            "hi_r8_r7_r11_LSL_30"},
                           {{gt, r2, r1, r7, LSL, 3},
                            false,
                            al,
                            "gt r2 r1 r7 LSL 3",
                            "gt_r2_r1_r7_LSL_3"},
                           {{cs, r5, r4, r4, ROR, 2},
                            false,
                            al,
                            "cs r5 r4 r4 ROR 2",
                            "cs_r5_r4_r4_ROR_2"},
                           {{cc, r5, r14, r10, ROR, 19},
                            false,
                            al,
                            "cc r5 r14 r10 ROR 19",
                            "cc_r5_r14_r10_ROR_19"},
                           {{mi, r8, r3, r0, ROR, 26},
                            false,
                            al,
                            "mi r8 r3 r0 ROR 26",
                            "mi_r8_r3_r0_ROR_26"},
                           {{eq, r7, r4, r8, ROR, 21},
                            false,
                            al,
                            "eq r7 r4 r8 ROR 21",
                            "eq_r7_r4_r8_ROR_21"},
                           {{al, r9, r11, r12, ROR, 31},
                            false,
                            al,
                            "al r9 r11 r12 ROR 31",
                            "al_r9_r11_r12_ROR_31"},
                           {{lt, r0, r1, r1, LSL, 29},
                            false,
                            al,
                            "lt r0 r1 r1 LSL 29",
                            "lt_r0_r1_r1_LSL_29"},
                           {{le, r8, r0, r11, ROR, 16},
                            false,
                            al,
                            "le r8 r0 r11 ROR 16",
                            "le_r8_r0_r11_ROR_16"},
                           {{le, r10, r2, r11, ROR, 31},
                            false,
                            al,
                            "le r10 r2 r11 ROR 31",
                            "le_r10_r2_r11_ROR_31"},
                           {{vs, r4, r7, r2, ROR, 10},
                            false,
                            al,
                            "vs r4 r7 r2 ROR 10",
                            "vs_r4_r7_r2_ROR_10"},
                           {{mi, r1, r8, r2, LSL, 16},
                            false,
                            al,
                            "mi r1 r8 r2 LSL 16",
                            "mi_r1_r8_r2_LSL_16"},
                           {{mi, r3, r14, r2, LSL, 21},
                            false,
                            al,
                            "mi r3 r14 r2 LSL 21",
                            "mi_r3_r14_r2_LSL_21"},
                           {{ne, r8, r13, r2, ROR, 25},
                            false,
                            al,
                            "ne r8 r13 r2 ROR 25",
                            "ne_r8_r13_r2_ROR_25"},
                           {{ls, r4, r3, r3, LSL, 11},
                            false,
                            al,
                            "ls r4 r3 r3 LSL 11",
                            "ls_r4_r3_r3_LSL_11"},
                           {{lt, r11, r9, r12, LSL, 7},
                            false,
                            al,
                            "lt r11 r9 r12 LSL 7",
                            "lt_r11_r9_r12_LSL_7"},
                           {{ls, r10, r5, r6, ROR, 9},
                            false,
                            al,
                            "ls r10 r5 r6 ROR 9",
                            "ls_r10_r5_r6_ROR_9"},
                           {{vs, r6, r12, r14, ROR, 30},
                            false,
                            al,
                            "vs r6 r12 r14 ROR 30",
                            "vs_r6_r12_r14_ROR_30"},
                           {{ls, r0, r10, r5, LSL, 15},
                            false,
                            al,
                            "ls r0 r10 r5 LSL 15",
                            "ls_r0_r10_r5_LSL_15"},
                           {{vc, r9, r1, r3, LSL, 21},
                            false,
                            al,
                            "vc r9 r1 r3 LSL 21",
                            "vc_r9_r1_r3_LSL_21"},
                           {{mi, r0, r7, r14, ROR, 28},
                            false,
                            al,
                            "mi r0 r7 r14 ROR 28",
                            "mi_r0_r7_r14_ROR_28"},
                           {{al, r10, r13, r8, LSL, 13},
                            false,
                            al,
                            "al r10 r13 r8 LSL 13",
                            "al_r10_r13_r8_LSL_13"},
                           {{ge, r3, r0, r5, LSL, 24},
                            false,
                            al,
                            "ge r3 r0 r5 LSL 24",
                            "ge_r3_r0_r5_LSL_24"},
                           {{pl, r14, r2, r8, ROR, 25},
                            false,
                            al,
                            "pl r14 r2 r8 ROR 25",
                            "pl_r14_r2_r8_ROR_25"},
                           {{cc, r4, r2, r9, ROR, 10},
                            false,
                            al,
                            "cc r4 r2 r9 ROR 10",
                            "cc_r4_r2_r9_ROR_10"},
                           {{hi, r1, r6, r1, LSL, 23},
                            false,
                            al,
                            "hi r1 r6 r1 LSL 23",
                            "hi_r1_r6_r1_LSL_23"},
                           {{vs, r10, r11, r11, ROR, 22},
                            false,
                            al,
                            "vs r10 r11 r11 ROR 22",
                            "vs_r10_r11_r11_ROR_22"},
                           {{vs, r0, r3, r12, LSL, 27},
                            false,
                            al,
                            "vs r0 r3 r12 LSL 27",
                            "vs_r0_r3_r12_LSL_27"},
                           {{eq, r0, r0, r12, LSL, 2},
                            false,
                            al,
                            "eq r0 r0 r12 LSL 2",
                            "eq_r0_r0_r12_LSL_2"},
                           {{lt, r7, r3, r5, LSL, 4},
                            false,
                            al,
                            "lt r7 r3 r5 LSL 4",
                            "lt_r7_r3_r5_LSL_4"},
                           {{ls, r4, r4, r12, ROR, 11},
                            false,
                            al,
                            "ls r4 r4 r12 ROR 11",
                            "ls_r4_r4_r12_ROR_11"},
                           {{vs, r14, r1, r11, LSL, 18},
                            false,
                            al,
                            "vs r14 r1 r11 LSL 18",
                            "vs_r14_r1_r11_LSL_18"},
                           {{gt, r1, r14, r13, LSL, 12},
                            false,
                            al,
                            "gt r1 r14 r13 LSL 12",
                            "gt_r1_r14_r13_LSL_12"},
                           {{ls, r3, r4, r11, ROR, 11},
                            false,
                            al,
                            "ls r3 r4 r11 ROR 11",
                            "ls_r3_r4_r11_ROR_11"},
                           {{al, r7, r4, r6, LSL, 30},
                            false,
                            al,
                            "al r7 r4 r6 LSL 30",
                            "al_r7_r4_r6_LSL_30"},
                           {{cc, r14, r12, r2, LSL, 27},
                            false,
                            al,
                            "cc r14 r12 r2 LSL 27",
                            "cc_r14_r12_r2_LSL_27"},
                           {{pl, r14, r12, r3, ROR, 5},
                            false,
                            al,
                            "pl r14 r12 r3 ROR 5",
                            "pl_r14_r12_r3_ROR_5"},
                           {{pl, r14, r14, r4, ROR, 14},
                            false,
                            al,
                            "pl r14 r14 r4 ROR 14",
                            "pl_r14_r14_r4_ROR_14"},
                           {{le, r3, r0, r0, LSL, 25},
                            false,
                            al,
                            "le r3 r0 r0 LSL 25",
                            "le_r3_r0_r0_LSL_25"},
                           {{al, r9, r5, r4, LSL, 7},
                            false,
                            al,
                            "al r9 r5 r4 LSL 7",
                            "al_r9_r5_r4_LSL_7"},
                           {{eq, r0, r3, r6, ROR, 18},
                            false,
                            al,
                            "eq r0 r3 r6 ROR 18",
                            "eq_r0_r3_r6_ROR_18"},
                           {{mi, r3, r11, r14, ROR, 30},
                            false,
                            al,
                            "mi r3 r11 r14 ROR 30",
                            "mi_r3_r11_r14_ROR_30"},
                           {{hi, r6, r6, r6, LSL, 16},
                            false,
                            al,
                            "hi r6 r6 r6 LSL 16",
                            "hi_r6_r6_r6_LSL_16"},
                           {{le, r6, r1, r5, ROR, 29},
                            false,
                            al,
                            "le r6 r1 r5 ROR 29",
                            "le_r6_r1_r5_ROR_29"},
                           {{gt, r7, r11, r4, LSL, 23},
                            false,
                            al,
                            "gt r7 r11 r4 LSL 23",
                            "gt_r7_r11_r4_LSL_23"},
                           {{gt, r2, r0, r2, LSL, 27},
                            false,
                            al,
                            "gt r2 r0 r2 LSL 27",
                            "gt_r2_r0_r2_LSL_27"},
                           {{cs, r1, r0, r7, ROR, 7},
                            false,
                            al,
                            "cs r1 r0 r7 ROR 7",
                            "cs_r1_r0_r7_ROR_7"},
                           {{gt, r3, r1, r12, ROR, 27},
                            false,
                            al,
                            "gt r3 r1 r12 ROR 27",
                            "gt_r3_r1_r12_ROR_27"},
                           {{ls, r13, r4, r11, ROR, 8},
                            false,
                            al,
                            "ls r13 r4 r11 ROR 8",
                            "ls_r13_r4_r11_ROR_8"},
                           {{hi, r11, r4, r7, LSL, 25},
                            false,
                            al,
                            "hi r11 r4 r7 LSL 25",
                            "hi_r11_r4_r7_LSL_25"},
                           {{ls, r3, r0, r8, ROR, 4},
                            false,
                            al,
                            "ls r3 r0 r8 ROR 4",
                            "ls_r3_r0_r8_ROR_4"},
                           {{cs, r2, r5, r13, ROR, 14},
                            false,
                            al,
                            "cs r2 r5 r13 ROR 14",
                            "cs_r2_r5_r13_ROR_14"},
                           {{gt, r2, r7, r2, LSL, 20},
                            false,
                            al,
                            "gt r2 r7 r2 LSL 20",
                            "gt_r2_r7_r2_LSL_20"},
                           {{gt, r9, r2, r14, LSL, 19},
                            false,
                            al,
                            "gt r9 r2 r14 LSL 19",
                            "gt_r9_r2_r14_LSL_19"},
                           {{lt, r1, r0, r1, LSL, 26},
                            false,
                            al,
                            "lt r1 r0 r1 LSL 26",
                            "lt_r1_r0_r1_LSL_26"},
                           {{hi, r8, r14, r3, ROR, 4},
                            false,
                            al,
                            "hi r8 r14 r3 ROR 4",
                            "hi_r8_r14_r3_ROR_4"},
                           {{le, r6, r12, r13, ROR, 25},
                            false,
                            al,
                            "le r6 r12 r13 ROR 25",
                            "le_r6_r12_r13_ROR_25"},
                           {{pl, r2, r5, r7, LSL, 29},
                            false,
                            al,
                            "pl r2 r5 r7 LSL 29",
                            "pl_r2_r5_r7_LSL_29"},
                           {{gt, r13, r5, r3, LSL, 13},
                            false,
                            al,
                            "gt r13 r5 r3 LSL 13",
                            "gt_r13_r5_r3_LSL_13"},
                           {{eq, r4, r8, r8, ROR, 10},
                            false,
                            al,
                            "eq r4 r8 r8 ROR 10",
                            "eq_r4_r8_r8_ROR_10"},
                           {{vc, r1, r7, r5, ROR, 15},
                            false,
                            al,
                            "vc r1 r7 r5 ROR 15",
                            "vc_r1_r7_r5_ROR_15"},
                           {{ge, r8, r2, r8, ROR, 9},
                            false,
                            al,
                            "ge r8 r2 r8 ROR 9",
                            "ge_r8_r2_r8_ROR_9"},
                           {{vs, r9, r12, r6, ROR, 19},
                            false,
                            al,
                            "vs r9 r12 r6 ROR 19",
                            "vs_r9_r12_r6_ROR_19"},
                           {{ne, r5, r1, r8, ROR, 29},
                            false,
                            al,
                            "ne r5 r1 r8 ROR 29",
                            "ne_r5_r1_r8_ROR_29"},
                           {{cc, r10, r13, r3, ROR, 3},
                            false,
                            al,
                            "cc r10 r13 r3 ROR 3",
                            "cc_r10_r13_r3_ROR_3"},
                           {{gt, r1, r6, r10, ROR, 22},
                            false,
                            al,
                            "gt r1 r6 r10 ROR 22",
                            "gt_r1_r6_r10_ROR_22"},
                           {{al, r5, r2, r5, ROR, 19},
                            false,
                            al,
                            "al r5 r2 r5 ROR 19",
                            "al_r5_r2_r5_ROR_19"},
                           {{cc, r13, r4, r4, LSL, 6},
                            false,
                            al,
                            "cc r13 r4 r4 LSL 6",
                            "cc_r13_r4_r4_LSL_6"},
                           {{hi, r6, r7, r3, ROR, 6},
                            false,
                            al,
                            "hi r6 r7 r3 ROR 6",
                            "hi_r6_r7_r3_ROR_6"},
                           {{ge, r4, r14, r9, LSL, 9},
                            false,
                            al,
                            "ge r4 r14 r9 LSL 9",
                            "ge_r4_r14_r9_LSL_9"},
                           {{cs, r3, r13, r0, LSL, 26},
                            false,
                            al,
                            "cs r3 r13 r0 LSL 26",
                            "cs_r3_r13_r0_LSL_26"},
                           {{lt, r9, r3, r4, ROR, 21},
                            false,
                            al,
                            "lt r9 r3 r4 ROR 21",
                            "lt_r9_r3_r4_ROR_21"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-adc-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-adcs-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-add-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-adds-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-and-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-ands-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-bic-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-bics-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-eor-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-eors-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-orr-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-orrs-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-rsb-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-rsbs-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-rsc-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-rscs-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-sbc-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-sbcs-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-sub-a32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-subs-a32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   Register rn,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseA32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    Register rm = kTests[i].operands.rm;
    ShiftType shift = kTests[i].operands.shift;
    uint32_t amount = kTests[i].operands.amount;
    Operand op(rm, shift, amount);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, rn, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                        \
  void Test_##mnemonic() {                                                    \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic);   \
  }                                                                           \
  Test test_##mnemonic(                                                       \
      "AARCH32_ASSEMBLER_COND_RD_RN_OPERAND_RM_SHIFT_AMOUNT_1TO31_" #mnemonic \
      "_A32",                                                                 \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
