/*
 * (llc_s_st.c)- Defines SAP component state machine transitions.
 * 
 * The followed transitions are SAP component state machine transitions
 * which are described in 802.2 LLC protocol standard document.
 *
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 

#define LLC_S_ST_C


#include <net/cm_types.h>
#include <net/cm_mm.h>
#include <net/cm_dll.h>
#include <net/cm_frame.h>
#include <net/llc_if.h>
#include <net/llc_sap.h>
#include <net/llc_conn.h>
#include <net/llc_main.h>
#include <net/llc_glob.h>
#include <net/llc_s_ev.h>
#include <net/llc_s_ac.h>
#include <net/llc_s_st.h>
#include <net/llc_dbg.h>

#ifdef LLC_S_ST_DBG
  #define  DBG_MSG(body) { printk body; }
#else
  #define  DBG_MSG(body)  ;
#endif

/* dummy last-transition indicator; common to all state transition groups */
static sap_state_transition_t		sap_state_transition_n =
{
	NULL, 0, NULL	/* last entry for this state */
};


/* state SAP_STATE_INACTIVE transition for SAP_EV_ACTIVATION_REQUEST event */
static sap_action_t			sap_inactive_state_actions_1 [] =
{
	sap_action_report_status,
	NULL
};

static sap_state_transition_t sap_inactive_state_transition_1 =
{
	sap_ev_activation_request,	SAP_STATE_ACTIVE,   
					sap_inactive_state_actions_1
};


/* array of pointers; one to each transition */
static sap_state_transition_t *		sap_inactive_state_transitions [] =
{  
	&sap_inactive_state_transition_1,
	&sap_state_transition_n
};



/* state SAP_STATE_ACTIVE transition for SAP_EV_RX_UI event */
static sap_action_t			sap_active_state_actions_1 [] =
{
	sap_action_unitdata_indication,
	NULL
};

static sap_state_transition_t		sap_active_state_transition_1 =
{
	sap_ev_rx_ui,			SAP_STATE_ACTIVE,   
					sap_active_state_actions_1
};


/* state SAP_STATE_ACTIVE transition for SAP_EV_UNITDATA_REQUEST event */
static sap_action_t			sap_active_state_actions_2 [] =
{
	sap_action_send_ui,
	NULL
};

static sap_state_transition_t		sap_active_state_transition_2 =
{
	sap_ev_unitdata_request,	SAP_STATE_ACTIVE,   
					sap_active_state_actions_2
};


/* state SAP_STATE_ACTIVE transition for SAP_EV_XID_REQUEST event */
static sap_action_t			sap_active_state_actions_3 [] =
{
	sap_action_send_xid_c,
	NULL
};

static sap_state_transition_t		sap_active_state_transition_3 =
{
	sap_ev_xid_request,		SAP_STATE_ACTIVE,
					sap_active_state_actions_3
};


/* state SAP_STATE_ACTIVE transition for SAP_EV_RX_XID_C event */
static sap_action_t			sap_active_state_actions_4 [] =
{
	sap_action_send_xid_r,
	NULL
};

static sap_state_transition_t		sap_active_state_transition_4 =
{
	sap_ev_rx_xid_c,		SAP_STATE_ACTIVE,
					sap_active_state_actions_4
};


/* state SAP_STATE_ACTIVE transition for SAP_EV_RX_XID_R event */
static sap_action_t			sap_active_state_actions_5 [] =
{
	sap_action_xid_indication,
	NULL
};

static sap_state_transition_t		sap_active_state_transition_5 =
{
	sap_ev_rx_xid_r,		SAP_STATE_ACTIVE,
					sap_active_state_actions_5
};


/* state SAP_STATE_ACTIVE transition for SAP_EV_TEST_REQUEST event */
static sap_action_t			sap_active_state_actions_6 [] =
{
	sap_action_send_test_c,
	NULL
};

static sap_state_transition_t		sap_active_state_transition_6 =
{
	sap_ev_test_request,		SAP_STATE_ACTIVE,
					sap_active_state_actions_6
};


/* state SAP_STATE_ACTIVE transition for SAP_EV_RX_TEST_C event */
static sap_action_t			sap_active_state_actions_7 [] =
{
	sap_action_send_test_r,
	NULL
};

static sap_state_transition_t		sap_active_state_transition_7 =
{
	sap_ev_rx_test_c,		SAP_STATE_ACTIVE,
					sap_active_state_actions_7
};


/* state SAP_STATE_ACTIVE transition for SAP_EV_RX_TEST_R event */
static sap_action_t			sap_active_state_actions_8 [] =
{
	sap_action_test_indication,
	NULL
};

static sap_state_transition_t sap_active_state_transition_8 =
{
	sap_ev_rx_test_r,		SAP_STATE_ACTIVE,
					sap_active_state_actions_8
};


/* state SAP_STATE_ACTIVE transition for SAP_EV_DEACTIVATION_REQUEST event */
static sap_action_t			sap_active_state_actions_9 [] =
{
	sap_action_report_status,
	NULL
};

static sap_state_transition_t		sap_active_state_transition_9 =
{
	sap_ev_deactivation_request,	SAP_STATE_INACTIVE,
					sap_active_state_actions_9
};


/* array of pointers; one to each transition */
static sap_state_transition_t *		sap_active_state_transitions [] =
{
	&sap_active_state_transition_2,
	&sap_active_state_transition_1,
	&sap_active_state_transition_3,
	&sap_active_state_transition_4,
	&sap_active_state_transition_5,
	&sap_active_state_transition_6,
	&sap_active_state_transition_7,
	&sap_active_state_transition_8,
	&sap_active_state_transition_9,
	&sap_state_transition_n
};


/* SAP state transition table */
sap_state_t				Sap_state_table [] =
{
	{ SAP_STATE_INACTIVE,		sap_inactive_state_transitions  },
	{ SAP_STATE_ACTIVE,		sap_active_state_transitions    }
};
