{$IFDEF WINDOWS}
{$N-,V-,W-,G+}
{$ELSE}
{$N-,E-,V-,O+,F+}
{$ENDIF}

Unit bibWritO;

Interface

Uses
{$IFDEF WINDOWS}
  wbibdisp,WObjects,
{$ELSE}
  bibdisp,objects,
{$ENDIF} 
  bibstrg, bibvars, bibfile, bibutil, bib8bit, rc_strng;

procedure DumpEntry(var dump: text; OutStrm: PStream; Entry: EntryRecPtr;
                    var fields: FieldArr; ExportFormat: byte;
                    Unix: boolean);

Implementation


procedure DeMacro(Var Sin; var slen: word; MaxBig: Word; TibMacro: boolean);
var
  S: BigType ABSOLUTE Sin;
  nbr: integer;
  i,j,ind,Del: Word;
  quote,brace: boolean;
begin
  if (Slen<2) or (S[1]<>'@') then Exit;
  ind:=2; while (ind<Slen) and (S[ind]=' ') do inc(ind);
  for i:=ind to Slen do S[i-ind+1]:=S[i]; Slen:=Slen-ind+1;
  nbr:=0; brace:=false; quote:=false; ind:=1;
  while ind<=Slen do
  begin
    Del:=0;
    if nbr=0 then
    begin
      brace:=false; quote:=false;
      if S[ind]=lbrace then
      begin
        brace:=true; inc(nbr); del:=1;
      end else if S[ind]='"' then
      begin
        quote:=true; inc(nbr); del:=1;
      end else if S[ind]='#' then
      begin
        Del:=1;
        j:=Ind+1; while (j<=Slen) and (S[j]=' ') do
        begin
          inc(Del); Inc(j);
        end;
      end else if (S[ind]<>' ') and (TibMacro) then
      begin
        j:=ind;
        while (j<=Slen) and not (S[j] in [' ','#','"',lbrace]) do inc(j);
        if j+1<=MaxBig then
        begin
          for i:=imin(Slen,MaxBig-2) downto j do S[i+2]:=S[i];
          S[j+1]:='|';
          for i:=j-1 downto ind do S[i+1]:=S[i];
          S[ind]:='|';
          Slen:=Slen+2;
        end;
        ind:=j+2;
      end else inc(ind);
    end else if nbr=1 then
    begin
      if (quote and (S[ind]='"')) or (brace and (S[ind]=rbrace))  then
      begin
        dec(nbr); Del:=1;
      end else inc(ind);
    end else
    begin
      if S[ind]=lbrace then inc(nbr)
      else if S[ind]=rbrace then dec(nbr);
      inc(ind);
    end;
    if Del>0 then
    begin
      for i:=Slen downto ind+Del do S[i-Del]:=S[i];
      Slen:=Slen-Del;
    end;
  end;      
end;                           { DeMacro }

procedure DumpEntry(var dump: text; OutStrm: PStream; Entry: EntryRecPtr;
                    var fields: FieldArr; ExportFormat: byte;
                    Unix: boolean);

procedure Wrt(S: string);
begin
  if OutStrm=Nil then write(dump,S)
  else if S<>'' then OutStrm^.write(S[1],length(S));
end;

procedure WrtLine(S: string; Unix: boolean);
var
  EOL: string[2];
begin
  if OutStrm=Nil then WriteLine(dump,S,Unix)
  else begin
    if S<>'' then OutStrm^.write(S[1],length(S));
    if Unix then EOL:=#10 else EOL:=#13#10;
    OutStrm^.write(EOL[1],length(EOL));
  end;
end;                { WrtLine }

procedure DumpCommaFormat;
var
  ifld : byte;
  i : longint;
  Numb,BareQuote : boolean;
  data: BigTypePtr;
  CurMaxBig,Slen: Word;
  tmp2: string;
begin                         { DumpCommaFormat }
  if Entry^.name='' then Exit;
  with Entry^ do
  begin
    wrt('"'+Entry^.name+'"'+CommaSeparator+'"'+Entry^.entrytype+'"');
    for ifld:=1 to fieldlast do
    begin
      WinYield;
      if fields[ifld] then
      begin
        wrt(CommaSeparator);
        if index[ifld]>0 then
        begin
          if BigIndex[ifld]>0 then
          begin
            data:=Big[BigIndex[ifld]]; Slen:=Blen[BigIndex[ifld]];
            CurMaxBig:=MaxBig;
          end else
          begin
            data:=@content[index[ifld]][1]; Slen:=length(content[index[ifld]]);
            CurMaxBig:=255;
          end;
          if (Slen=1) and (data^[1]=#0) then Slen:=0;
          Numb:=true;
          i:=0;
          while (i<Slen) and Numb do
          begin
            inc(i); if not (data^[i] in ['0'..'9']) then Numb:=false;
          end;
          if Numb then
            for i:=1 to slen do wrt(data^[i])
          else begin
            wrt('"');
            if not OkField(Data^,Slen,3,'','',BareQuote) then
            begin
              if Slen>252 then tmp2:=Scopy(Data,1,252)+'...'
              else tmp2:=Scopy(Data,1,Slen);
              BareQuote:=AskIf(tmp2,StringRC(Str_UnbalancedSuppressed,''),'OK','');
              Slen:=0;
            end;
            for i:=1 to slen do
            begin
              if data^[i]<>'"' then wrt(data^[i])
              else wrt('""');
            end;
            wrt('"');
          end;
        end;
      end;
    end;
    if Unix then Wrt(#10) else wrt(#13#10);
  end;
end;                         { DumpCommaFormat }

procedure DumpReferFormat;
var
  W: string;
  tmp: string;
  i: byte;
  fld: char;
  year,month,title,booktitle,chapter,edition: Byte;
  publisher,organization,journal,author,editor: Byte;
  volume,pages,number,ttype,institution,school: Byte;
  howpublished,keywords,abstract,note,series: Byte;
  ntis,belllabsnum,mathrevnum,address: Byte;

procedure WriteBuff(fld: char; var Sin; slen: word);
var
  S: BigType ABSOLUTE Sin;
  tmp,line: string;
  i: Word;
begin
  WinYield;
  if slen<1 then Exit;
  if (slen=1) and (S[1]=#0) then exit;
  i:=1; tmp:=''; line:='%'+fld;
  while (i<=Slen) do
  begin
    TeXWordGet(tmp,S,Slen,i);
    if tmp<>'' then
    begin
      if length(line)+1+length(tmp)<=LineWidth[ExportFormat] then
        line:=line+' '+tmp
      else if line='' then
      begin
        WrtLine(tmp,Unix); line:='';
      end else
      begin
        WrtLine(line,Unix); line:=tmp;
      end;
    end;
  end;
  if line<>'' then WrtLine(line,Unix);
  if Pos(fld,W)=0 then W:=W+fld;
end;                           { WriteBuff }

procedure WriteField(fld: char; Ind: byte);
var
  B: BigTypePtr;
  Slen,Mx,f_ind,i: Word;
  SBuffer: array[1..400] of char;
begin
  if Pos(fld,W)>0 then Exit;
  with Entry^ do
  begin
    f_ind:=0; for i:=1 to FieldLast do if Index[i]=ind then f_ind:=i;
    if BigIndex[f_ind]=0 then
    begin
      B:=@SBuffer; Slen:=length(content[ind]);
      Move(content[ind][1],B^,Slen);  Mx:=SizeOf(SBuffer);
    end else
    begin
      B:=Big[BigIndex[f_ind]]; Slen:=Blen[BigIndex[f_ind]]; Mx:=MaxBig;
    end;
    if File8bit then Conv28BitFile(B^,Slen,FieldParams^[ind].AuthorLike,false)
    else if File7bit then Conv27bit(B^,Slen,false,Mx);
    DeMacro(B^,Slen,Mx,(ExportFormat=TibFormat) and
      ((TibMacros=ExpOnly) or (TibMacros=ImpAndExp)));
    WriteBuff(fld,B^,Slen);
  end;
end;                         { WriteField }

procedure WriteAuthor(fld: char; Ind: byte);
var
  tmp,tmp1,author: string;
  i: Word;
  B: BigTypePtr;
  Slen: Word;
  ch: char;
begin
  if Ind=0 then Exit;
  with Entry^ do
  begin
    if BigIndex[ind]=0 then
    begin
      B:=@content[ind][1]; Slen:=length(content[ind]);
    end else
    begin
      B:=Big[BigIndex[ind]]; Slen:=Blen[BigIndex[ind]];
    end;
  end;
  if Slen<1 then Exit;
  if (slen=1) and (B^[1]=#0) then exit;
  tmp:=''; i:=1; author:='';
  while (i<=Slen+1) do
  begin
    if i<=Slen then ch:=B^[i] else ch:=' ';
    if ch<>' ' then tmp:=tmp+ch
    else begin
      tmp1:=tmp; StrLwr(tmp1);
      if (tmp1='and') and (author<>'') then
      begin
        if File8bit then SConv28BitFile(author,FieldParams^[ind].Authorlike,false)
        else if File7bit then SConv27bit(author,false);
        WriteBuff(fld,author[1],length(author));
        author:='';
      end else if author='' then author:=tmp
      else author:=author+' '+tmp;
      while (i<Slen) and (B^[i+1]=' ') do inc(i);
      tmp:='';
    end;
    inc(i);
  end;
  if Author<>'' then
  begin
    if File8bit then SConv28BitFile(author,FieldParams^[ind].Authorlike,False)
    else if File7bit then SConv27bit(author,false);
    WriteBuff(fld,author[1],length(author));
  end;
end;                     { WriteAuthor }

procedure AppendField(Entry: EntryRecPtr; var fld: byte; fname: string;
                     s: string);
var
  i,j: byte;
  rfld: byte;
  n: integer;
begin
  if (s='') or (s=#0) then Exit;
  with Entry^ do
  begin
    i:=1; rfld:=0;
    while (i<=FieldLast) and (rfld=0) do
    begin
      if StrCmpI(typefield^[i],fname,1,1,255)=0 then rfld:=i;
      inc(i);
    end;           
    if (fld=0) and (nentry<MaxField) then
    begin
      fld:=nentry+1;
      content[fld]:=''; Field[fld]:=fname;
      if rfld>0 then
      begin
        index[rfld]:=fld; BigIndex[rfld]:=0;
      end else fld:=0;
    end;
    if fld=0 then Exit;
    if (length(content[fld])=0) and (s[1]=',') then Delete(s,1,1);
    ChrDelL(s,' '); ChrDelR(s,' ');
    if content[fld]='' then
    begin
      content[fld]:=s; Exit;
    end;
    if not (s[1] in [' ',',','.','-',';',':','!','?','+']) then s:=' '+s;
    j:=length(content[fld]);
    content[fld]:=content[fld]+s;
    if (j+length(s)>255) and (BigIndex[rfld]=0) then
    begin
      BigIndex[rfld]:=FindBigFree(Entry,true);
      if BigIndex[rfld]>0 then Blen[BigIndex[rfld]]:=0;
    end;
    if BigIndex[rfld]>0 then
    begin
      n:=imin(length(s),MaxBig-Blen[BigIndex[rfld]]);
      if n>0 then
      begin
        s:=Copy(s,1,n);
        Move(s[1],Big[BigIndex[rfld]]^[Blen[BigIndex[rfld]]+1],n);
        Blen[BigIndex[rfld]]:=Blen[BigIndex[rfld]]+n;
      end;
    end;
  end;
end;                       { AppendField }

begin                      { DumpReferFormat }
  with Entry^ do
  begin
    if ExportFormat=TibFormat then WriteBuff('F',name[1],length(name))
    else if ExportFormat=ReferFormat then WriteBuff('L',name[1],length(name));
    W:='';
    year:=0; month:=0; title:=0; booktitle:=0; chapter:=0; edition:=0;
    publisher:=0; organization:=0; journal:=0; author:=0; editor:=0;
    volume:=0; pages:=0; number:=0; ttype:=0; institution:=0; school:=0;
    howpublished:=0; keywords:=0; abstract:=0; note:=0; series:=0;
    ntis:=0; belllabsnum:=0; mathrevnum:=0;
    for i:=1 to nentry do
    begin
      if field[i]='year' then year:=i
      else if field[i]='month' then month:=i
      else if field[i]='title' then title:=i
      else if field[i]='booktitle' then booktitle:=i
      else if field[i]='chapter' then chapter:=i
      else if field[i]='edition' then edition:=i
      else if field[i]='journal' then journal:=i
      else if field[i]='author' then author:=i
      else if field[i]='editor' then editor:=i
      else if field[i]='publisher' then publisher:=i
      else if field[i]='organization' then organization:=i
      else if field[i]='institution' then institution:=i
      else if field[i]='howpublished' then howpublished:=i
      else if field[i]='school' then school:=i
      else if field[i]='volume' then volume:=i
      else if field[i]='pages' then pages:=i
      else if field[i]='number' then number:=i
      else if field[i]='type' then ttype:=i
      else if field[i]='keywords' then keywords:=i
      else if field[i]='abstract' then abstract:=i
      else if field[i]='note' then note:=i
      else if field[i]='address' then address:=i
      else if field[i]='ntis' then ntis:=i
      else if field[i]='belllabsnum' then belllabsnum:=i
      else if field[i]='mathrevnum' then mathrevnum:=i
      else if field[i]='series' then series:=i;
    end;

    if month>0 then
    begin
      if year>0 then content[year]:=content[month]+', '+content[year]
      else begin
        year:=month; field[year]:='year';
      end;
    end;
    if ExportFormat=ReferFormat then
    begin
      i:=title; tmp:='title';
      if EntryType='incollection' then
      begin
        i:=booktitle; tmp:='booktitle';
      end;
      if (Edition>0) and (i>0) then
      begin
        if content[edition][length(content[edition])]='.' then
          content[edition][0]:=Chr(length(content[edition])-1);
        AppendField(entry,i,tmp,', '+content[edition]+' edition');
      end;
      if (chapter>0) and (i>0) then
        AppendField(entry,i,tmp,', chap. '+content[chapter]);
    end else
    begin
      if Edition>0 then AppendField(entry,edition,'edition',' edition');
      if chapter>0 then
        AppendField(entry,edition,'edition',', chap. '+content[chapter]);
    end;
    if entrytype<>'article' then journal:=0;
    if (publisher>0) and (organization>0) then organization:=0;
    if (entrytype<>'mastersthesis') and (entrytype<>'phdthesis') then
      school:=0;
    if (entrytype<>'inbook') and (entrytype<>'incollection') and
       (entrytype<>'techreport') and (entrytype<>'mastersthesis') and
       (entrytype<>'phdthesis') then ttype:=0;
    if (ExportFormat=TibFormat) and
       ((entrytype='incollection') or (entrytype='conference')) and
       (editor=0) then
    begin
      journal:=booktitle; booktitle:=0;
    end;

    for i:=1 to LastField do
    if index[i]>0 then
    begin
      fld:=#0;
           if index[i]=author    then fld:='A'
      else if index[i]=booktitle then fld:='B'
      else if index[i]=address   then fld:='C'
      else if index[i]=year      then fld:='D'
      else if index[i]=editor    then fld:='E'
      else if index[i]=ntis      then fld:='G'
      else if ((index[i]=publisher) or (index[i]=institution) or
               (index[i]=organization) or (index[i]=school)) then fld:='I'
      else if index[i]=journal   then fld:='J'
      else if index[i]=keywords  then fld:='K'
      else if ((index[i]=belllabsnum) and (ExportFormat=ReferFormat))
           or ((index[i]=mathrevnum) and (ExportFormat=TibFormat)) then
        fld:='M'
      else if index[i]=number    then fld:='N'
      else if index[i]=note      then fld:='O'
      else if index[i]=pages     then fld:='P'
      else if index[i]=ttype     then fld:='R'
      else if index[i]=series    then fld:='S'
      else if index[i]=title     then fld:='T'
      else if index[i]=volume    then fld:='V'
      else if (index[i]=abstract) and (ExportFormat=ReferFormat) then
        fld:='X'
      else if (index[i]=edition) and (ExportFormat=TibFormat) then
        fld:='o';
        
      if (fld='A') or (fld='E') then WriteAuthor(fld,index[i])
      else if fld<>#0 then WriteField(fld,index[i]);
    end;
    if Pos('R',W)=0 then
    begin
      if entrytype='mastersthesis' then WrtLine('%R Masters thesis.',Unix)
      else if entrytype='phdthesis' then WrtLine('%R Ph.D. thesis.',Unix);
    end;
    tmp:='';
    if ExportFormat=TibFormat then
    begin
      if (entrytype='article') and ((journal=0) or (volume=0)) then
        tmp:='journalarticle'
      else if (entrytype='techreport') and (Pos('R',W)=0) then
        tmp:='technicalreport'
      else if (entrytype='book') and (Pos('I',W)=0) then
        tmp:='book'
      else if ((entrytype='incollection') or (entrytype='inproceedings')
        or (entrytype='conference')) and ((Pos('T',W)=0) or (Pos('B',W)=0)) then
        tmp:='bookarticle'
      else if entrytype='misc' then tmp:='other';
      if tmp<>'' then
        WrtLine('%\def\Refformat'+lbrace+'\'+tmp+'format'+lbrace,Unix);
    end;    
  end;
  WrtLine('',Unix);
end;                          { DumpReferFormat }

begin                                  { DumpEntry }
  TimeOutOn:=false;
  MaxMemAvail;
  if ExportFormat=CommaDelimited then DumpCommaFormat
  else if ExportFormat=TibFormat then DumpReferFormat
  else if ExportFormat=ReferFormat then DumpReferFormat;
end;                              { DumpEntry }

end.
