	.MODEL LARGE

	.CODE

com_int DB      0ch             ; Interruptvektor fr COM1:
com_adr DW      03f8h           ; Adresse des Ports fr COM1:
int_msk DB      10h             ; Interruptmaske fr COM1:
int_seg DW      0               ; Platz fr den alten Interruptvektor (Segment)
int_off DW      0               ; Platz fr den alten Interruptvektor (Offset)
asc_in  DW      0
asc_out DW      0
asc_buf DB      8192 DUP (0)

pic_eoi EQU     20h
pic_msk EQU     21h
asc_len EQU     8192
com_dat EQU     0               ; Datenregister
com_ier EQU     1
com_iid EQU     2
com_mcr EQU     4
com_sta EQU     5


	    PUBLIC  _Cauxinit,_Cauxexit,_Cauxin,_Cauxout,_Cauxis

_Cauxinit	proc    far
		push    bp
		mov     bp,sp
		cli
		mov     dx,[bp+6]       ; Nummer der Schnittstelle
		cmp     dx,0            ; Ist es COM1: ?
		je      cini1           ; Ja, weiter
		mov     [com_int],0bh
		mov     [com_adr],02f8h
		mov     [int_msk],08h   ; frueher stand dort 10h statt 08h
cini1:		mov     ax,[bp+8]
		mov     ah,0
		int     14h
    
		mov     ah,35h          ; MSDOS: Interruptvektor aus der Tabelle lesen
		mov     al,[com_int]    ; Nummer des Interruptvektors
		int     21h             ; MSDOS Aufruf
		mov     [int_seg],es    ; Segmentadresse des alten Vektors speichern
		mov     [int_off],bx    ; Offset Adresse des alten Vektors speichern
    
		push    ds
		mov     ah,25h          ; MSDOS: Interruptvektor in der Tabelle setzen
		mov     al,[com_int]    ; Nummer des Interruptvektors
		mov     dx,offset asc_int;Adresse der neuen Interruptroutine
		mov     bx,cs           ; Codesegmentadresse holen
		mov     ds,bx           ; und nach ds bringen
		int     21h             ; MSDOS Aufruf
		pop     ds
    
		mov     dx,[com_adr]
		in      al,dx           ; Daten Register auslesen, d.h. loeschen
    
		mov     dx,[com_adr]    ; Basisadresse des Controllers
		add     dx,com_mcr
		mov     al,0bh          ; DTR, RTS und OUT2 setzen
		out     dx,al
    
		inc     dx              ; Zeiger auf Status Register
		jmp $+2
		in      al,dx           ; Status lesen und zuruecksetzen
		jmp $+2
		in      al,dx           ; nochmal Status lesen
		jmp $+2
		inc     dx              ; Zeiger auf Modemstatus
		in      al,dx           ; Modemstatus lesen und zuruecksetzen
		jmp $+2
		in      al,dx           ; nochmal
		jmp $+2
    
		mov     dx,[com_adr]
		add     dx,com_ier
		mov     al,1
		out     dx,al
    
		in      al,pic_msk
		mov     bl,[int_msk]
		not     bl
		and     al,bl
		out     pic_msk,al
    
		sti
		pop     bp
		ret

_Cauxinit	endp

_Cauxexit	proc    far
		mov     dx,[com_adr]    ; Basisadresse des Controllers
		add     dx,com_mcr
		mov     al,00h
		out     dx,al
    
		mov     dx,[com_adr]
		add     dx,com_ier
		mov     al,0
		out     dx,al
    
		in      al,pic_msk
		or      al,[int_msk]
		out     pic_msk,al
    
		push    ds              ; Datensegmentregister retten
		mov     dx,[int_off]    ; Offsetadresse des alten Interruptvektors
		mov     ds,[int_seg]    ; Segmentadresse des alten Interruptvektors
		mov     ah,25h          ; MSDOS-Funktionsnummer: Interruptvektor setzen
		mov     al,[com_int]    ; Nummer des Interruptvektors
		int     21h             ; MSDOS Aufruf
		pop     ds              ; Datensegmentregister wieder herstellen
    
		ret
_Cauxexit	endp

_Cauxin		proc    far
cin2:		mov     bx,asc_out
		cmp     bx,asc_in
		je      cin2
		mov     al,[bx+asc_buf]
		inc     bx
		cmp     bx,asc_len
		jne     cin1
		xor     bx,bx
cin1:		mov     asc_out,bx
		mov     ah,0
		ret
_Cauxin		endp

_Cauxout	proc    far
		push    bp
		mov     bp,sp
		mov     ax,[bp+6]
		push    ax
		mov     dx,[com_adr]
		add     dx,com_sta
cout1:		in      al,dx
		and     al,20h
		jz      cout1
		pop     ax
		mov     dx,[com_adr]
		out     dx,al
		pop     bp
		ret
_Cauxout	endp

_Cauxis		proc far
		mov     ax,0
		mov     dx,asc_in
		cmp     dx,asc_out
		je      cis1
		mov     ax,1
cis1:		ret
_Cauxis		endp


asc_int		proc far
		sti
		push    ax
		push    bx
		push    dx
		push    ds
		mov     ax,@data
		mov     ds,ax
		mov     dx,[com_adr]
		add     dx,com_iid
		in      al,dx
		jmp     $+2
		test    al,01
		jnz     asc_en
    
		mov     dx,[com_adr]
		in      al,dx
    
		cli
		mov     bx,asc_in
		mov     [asc_buf+bx],al
		inc     bx
		cmp     bx,asc_len
		jne     asc_i1
		xor     bx,bx
asc_i1:		mov     asc_in,bx
		sti

asc_en:		mov     al,20h
		out     pic_eoi,al
		pop     ds
		pop     dx
		pop     bx
		pop     ax
		iret

asc_int		endp

		end

