/*  stritem.c 2.9.0 92/07/06 -- like strtok except different */

/*
 *  This is a replacement for the SysV strtok(3C) function.
 *  (It has a different signature.)  See stritem(3).
 */

/* - Damian Cugley <pdc@prg.ox.ac.uk> Thur. 20 June 1991
-----------------------------------------------------------------------
    This software module copyright (c) 1991 Damian Cugley.  
    It is provided for free on an "as-is" basis.
    See the file COPYING for more information.
-----------------------------------------------------------------------
*/

#include "strmisc.h"

char *
stritem(s, c, state)
     char *s;
     int c;
     char **state;
{
  char *result;
  register char *p;
  
  result = (s ? s : *state);
  if (!result || !*result) return (char *)NULL;
  
  for (p = result; *p && *p != c; p++)
    ;
  if (*p)
    *state = p + 1, *p = '\0';
  else
    *state = (char *)NULL;		/* next call will return NULL */
  return result;
}
