// 这是由程序自动生成的文件，请不要直接编辑此文件
// 部首来源：CJKRadicals.txt
// 部首笔画数来源：Unihan_IRGSources.txt
// Unicode version: 10.0.0

package CJK

// Radical 是康熙字典部首类型。
// 此类型未包括 U+2F00 至 U+2FD5 等部首专用符号。
type Radical struct {
	Origin     rune // 原部首的对应汉字
	Simplified rune // 简化部首
}

const MAX_RADICAL = 214

// Radicals 是所有部首。
var Radicals [MAX_RADICAL + 1]Radical = radicals

var radicals = [MAX_RADICAL + 1]Radical{
	1: {0x4e00, 0x0}, // 一
	2: {0x4e28, 0x0}, // 丨
	3: {0x4e36, 0x0}, // 丶
	4: {0x4e3f, 0x0}, // 丿
	5: {0x4e59, 0x0}, // 乙
	6: {0x4e85, 0x0}, // 亅
	7: {0x4e8c, 0x0}, // 二
	8: {0x4ea0, 0x0}, // 亠
	9: {0x4eba, 0x0}, // 人
	10: {0x513f, 0x0}, // 儿
	11: {0x5165, 0x0}, // 入
	12: {0x516b, 0x0}, // 八
	13: {0x5182, 0x0}, // 冂
	14: {0x5196, 0x0}, // 冖
	15: {0x51ab, 0x0}, // 冫
	16: {0x51e0, 0x0}, // 几
	17: {0x51f5, 0x0}, // 凵
	18: {0x5200, 0x0}, // 刀
	19: {0x529b, 0x0}, // 力
	20: {0x52f9, 0x0}, // 勹
	21: {0x5315, 0x0}, // 匕
	22: {0x531a, 0x0}, // 匚
	23: {0x5338, 0x0}, // 匸
	24: {0x5341, 0x0}, // 十
	25: {0x535c, 0x0}, // 卜
	26: {0x5369, 0x0}, // 卩
	27: {0x5382, 0x0}, // 厂
	28: {0x53b6, 0x0}, // 厶
	29: {0x53c8, 0x0}, // 又
	30: {0x53e3, 0x0}, // 口
	31: {0x56d7, 0x0}, // 囗
	32: {0x571f, 0x0}, // 土
	33: {0x58eb, 0x0}, // 士
	34: {0x5902, 0x0}, // 夂
	35: {0x590a, 0x0}, // 夊
	36: {0x5915, 0x0}, // 夕
	37: {0x5927, 0x0}, // 大
	38: {0x5973, 0x0}, // 女
	39: {0x5b50, 0x0}, // 子
	40: {0x5b80, 0x0}, // 宀
	41: {0x5bf8, 0x0}, // 寸
	42: {0x5c0f, 0x0}, // 小
	43: {0x5c22, 0x0}, // 尢
	44: {0x5c38, 0x0}, // 尸
	45: {0x5c6e, 0x0}, // 屮
	46: {0x5c71, 0x0}, // 山
	47: {0x5ddb, 0x0}, // 巛
	48: {0x5de5, 0x0}, // 工
	49: {0x5df1, 0x0}, // 己
	50: {0x5dfe, 0x0}, // 巾
	51: {0x5e72, 0x0}, // 干
	52: {0x5e7a, 0x0}, // 幺
	53: {0x5e7f, 0x0}, // 广
	54: {0x5ef4, 0x0}, // 廴
	55: {0x5efe, 0x0}, // 廾
	56: {0x5f0b, 0x0}, // 弋
	57: {0x5f13, 0x0}, // 弓
	58: {0x5f50, 0x0}, // 彐
	59: {0x5f61, 0x0}, // 彡
	60: {0x5f73, 0x0}, // 彳
	61: {0x5fc3, 0x0}, // 心
	62: {0x6208, 0x0}, // 戈
	63: {0x6236, 0x0}, // 戶
	64: {0x624b, 0x0}, // 手
	65: {0x652f, 0x0}, // 支
	66: {0x6534, 0x0}, // 攴
	67: {0x6587, 0x0}, // 文
	68: {0x6597, 0x0}, // 斗
	69: {0x65a4, 0x0}, // 斤
	70: {0x65b9, 0x0}, // 方
	71: {0x65e0, 0x0}, // 无
	72: {0x65e5, 0x0}, // 日
	73: {0x66f0, 0x0}, // 曰
	74: {0x6708, 0x0}, // 月
	75: {0x6728, 0x0}, // 木
	76: {0x6b20, 0x0}, // 欠
	77: {0x6b62, 0x0}, // 止
	78: {0x6b79, 0x0}, // 歹
	79: {0x6bb3, 0x0}, // 殳
	80: {0x6bcb, 0x0}, // 毋
	81: {0x6bd4, 0x0}, // 比
	82: {0x6bdb, 0x0}, // 毛
	83: {0x6c0f, 0x0}, // 氏
	84: {0x6c14, 0x0}, // 气
	85: {0x6c34, 0x0}, // 水
	86: {0x706b, 0x0}, // 火
	87: {0x722a, 0x0}, // 爪
	88: {0x7236, 0x0}, // 父
	89: {0x723b, 0x0}, // 爻
	90: {0x723f, 0x4e2c}, // 爿 (丬)
	91: {0x7247, 0x0}, // 片
	92: {0x7259, 0x0}, // 牙
	93: {0x725b, 0x0}, // 牛
	94: {0x72ac, 0x0}, // 犬
	95: {0x7384, 0x0}, // 玄
	96: {0x7389, 0x0}, // 玉
	97: {0x74dc, 0x0}, // 瓜
	98: {0x74e6, 0x0}, // 瓦
	99: {0x7518, 0x0}, // 甘
	100: {0x751f, 0x0}, // 生
	101: {0x7528, 0x0}, // 用
	102: {0x7530, 0x0}, // 田
	103: {0x758b, 0x0}, // 疋
	104: {0x7592, 0x0}, // 疒
	105: {0x7676, 0x0}, // 癶
	106: {0x767d, 0x0}, // 白
	107: {0x76ae, 0x0}, // 皮
	108: {0x76bf, 0x0}, // 皿
	109: {0x76ee, 0x0}, // 目
	110: {0x77db, 0x0}, // 矛
	111: {0x77e2, 0x0}, // 矢
	112: {0x77f3, 0x0}, // 石
	113: {0x793a, 0x0}, // 示
	114: {0x79b8, 0x0}, // 禸
	115: {0x79be, 0x0}, // 禾
	116: {0x7a74, 0x0}, // 穴
	117: {0x7acb, 0x0}, // 立
	118: {0x7af9, 0x0}, // 竹
	119: {0x7c73, 0x0}, // 米
	120: {0x7cf8, 0x7e9f}, // 糸 (纟)
	121: {0x7f36, 0x0}, // 缶
	122: {0x7f51, 0x0}, // 网
	123: {0x7f8a, 0x0}, // 羊
	124: {0x7fbd, 0x0}, // 羽
	125: {0x8001, 0x0}, // 老
	126: {0x800c, 0x0}, // 而
	127: {0x8012, 0x0}, // 耒
	128: {0x8033, 0x0}, // 耳
	129: {0x807f, 0x0}, // 聿
	130: {0x8089, 0x0}, // 肉
	131: {0x81e3, 0x0}, // 臣
	132: {0x81ea, 0x0}, // 自
	133: {0x81f3, 0x0}, // 至
	134: {0x81fc, 0x0}, // 臼
	135: {0x820c, 0x0}, // 舌
	136: {0x821b, 0x0}, // 舛
	137: {0x821f, 0x0}, // 舟
	138: {0x826e, 0x0}, // 艮
	139: {0x8272, 0x0}, // 色
	140: {0x8278, 0x0}, // 艸
	141: {0x864d, 0x0}, // 虍
	142: {0x866b, 0x0}, // 虫
	143: {0x8840, 0x0}, // 血
	144: {0x884c, 0x0}, // 行
	145: {0x8863, 0x0}, // 衣
	146: {0x897e, 0x0}, // 襾
	147: {0x898b, 0x89c1}, // 見 (见)
	148: {0x89d2, 0x0}, // 角
	149: {0x8a00, 0x8ba0}, // 言 (讠)
	150: {0x8c37, 0x0}, // 谷
	151: {0x8c46, 0x0}, // 豆
	152: {0x8c55, 0x0}, // 豕
	153: {0x8c78, 0x0}, // 豸
	154: {0x8c9d, 0x8d1d}, // 貝 (贝)
	155: {0x8d64, 0x0}, // 赤
	156: {0x8d70, 0x0}, // 走
	157: {0x8db3, 0x0}, // 足
	158: {0x8eab, 0x0}, // 身
	159: {0x8eca, 0x8f66}, // 車 (车)
	160: {0x8f9b, 0x0}, // 辛
	161: {0x8fb0, 0x0}, // 辰
	162: {0x8fb5, 0x8fb6}, // 辵 (辶)
	163: {0x9091, 0x0}, // 邑
	164: {0x9149, 0x0}, // 酉
	165: {0x91c6, 0x0}, // 釆
	166: {0x91cc, 0x0}, // 里
	167: {0x91d1, 0x9485}, // 金 (钅)
	168: {0x9577, 0x957f}, // 長 (长)
	169: {0x9580, 0x95e8}, // 門 (门)
	170: {0x961c, 0x0}, // 阜
	171: {0x96b6, 0x0}, // 隶
	172: {0x96b9, 0x0}, // 隹
	173: {0x96e8, 0x0}, // 雨
	174: {0x9751, 0x0}, // 靑
	175: {0x975e, 0x0}, // 非
	176: {0x9762, 0x0}, // 面
	177: {0x9769, 0x0}, // 革
	178: {0x97cb, 0x97e6}, // 韋 (韦)
	179: {0x97ed, 0x0}, // 韭
	180: {0x97f3, 0x0}, // 音
	181: {0x9801, 0x9875}, // 頁 (页)
	182: {0x98a8, 0x98ce}, // 風 (风)
	183: {0x98db, 0x98de}, // 飛 (飞)
	184: {0x98df, 0x9963}, // 食 (饣)
	185: {0x9996, 0x0}, // 首
	186: {0x9999, 0x0}, // 香
	187: {0x99ac, 0x9a6c}, // 馬 (马)
	188: {0x9aa8, 0x0}, // 骨
	189: {0x9ad8, 0x0}, // 高
	190: {0x9adf, 0x0}, // 髟
	191: {0x9b25, 0x0}, // 鬥
	192: {0x9b2f, 0x0}, // 鬯
	193: {0x9b32, 0x0}, // 鬲
	194: {0x9b3c, 0x0}, // 鬼
	195: {0x9b5a, 0x9c7c}, // 魚 (鱼)
	196: {0x9ce5, 0x9e1f}, // 鳥 (鸟)
	197: {0x9e75, 0x5364}, // 鹵 (卤)
	198: {0x9e7f, 0x0}, // 鹿
	199: {0x9ea5, 0x9ea6}, // 麥 (麦)
	200: {0x9ebb, 0x0}, // 麻
	201: {0x9ec3, 0x9ec4}, // 黃 (黄)
	202: {0x9ecd, 0x0}, // 黍
	203: {0x9ed1, 0x0}, // 黑
	204: {0x9ef9, 0x0}, // 黹
	205: {0x9efd, 0x9efe}, // 黽 (黾)
	206: {0x9f0e, 0x0}, // 鼎
	207: {0x9f13, 0x0}, // 鼓
	208: {0x9f20, 0x0}, // 鼠
	209: {0x9f3b, 0x0}, // 鼻
	210: {0x9f4a, 0x9f50}, // 齊 (齐)
	211: {0x9f52, 0x9f7f}, // 齒 (齿)
	212: {0x9f8d, 0x9f99}, // 龍 (龙)
	213: {0x9f9c, 0x9f9f}, // 龜 (龟)
	214: {0x9fa0, 0x0}, // 龠
}

// RadicalStroke 为部首与除部首笔画数。
// 前两个字节分别放部首和除部首笔画数，后面放字符本身的 UTF-8 编码，可直接排序。
type RadicalStroke string

// Radical 取得部首编号。
func (rs RadicalStroke) Radical() int {
	return int(rs[0])
}

// Stroke 取得除部首笔画数。
func (rs RadicalStroke) Stroke() int {
	return int(rs[1])
}

// RadicalStrokes 从字符取得部首与除部首笔画数信息。
var RadicalStrokes map[rune]RadicalStroke = radicalStrokes

var radicalStrokes = map[rune]RadicalStroke{
	0x3007: "\x05\x00\u3007", // 〇
	0x3400: "\x01\x04\u3400", // 㐀
	0x3401: "\x01\x05\u3401", // 㐁
	0x3402: "\x01\x05\u3402", // 㐂
	0x3403: "\x02\x02\u3403", // 㐃
	0x3404: "\x02\x02\u3404", // 㐄
	0x3405: "\x04\x01\u3405", // 㐅
	0x3406: "\x04\x05\u3406", // 㐆
	0x3407: "\x05\x02\u3407", // 㐇
	0x3408: "\x05\x02\u3408", // 㐈
	0x3409: "\x05\x02\u3409", // 㐉
	0x340a: "\x05\x03\u340a", // 㐊
	0x340b: "\x05\x03\u340b", // 㐋
	0x340c: "\x05\x04\u340c", // 㐌
	0x340d: "\x05\x04\u340d", // 㐍
	0x340e: "\x05\x04\u340e", // 㐎
	0x340f: "\x05\x04\u340f", // 㐏
	0x3410: "\x05\x05\u3410", // 㐐
	0x3411: "\x05\x05\u3411", // 㐑
	0x3412: "\x05\x05\u3412", // 㐒
	0x3413: "\x05\x05\u3413", // 㐓
	0x3414: "\x05\x05\u3414", // 㐔
	0x3415: "\x05\x05\u3415", // 㐕
	0x3416: "\x05\x06\u3416", // 㐖
	0x3417: "\x05\x06\u3417", // 㐗
	0x3418: "\x05\x06\u3418", // 㐘
	0x3419: "\x05\a\u3419", // 㐙
	0x341a: "\x05\a\u341a", // 㐚
	0x341b: "\x05\a\u341b", // 㐛
	0x341c: "\x05\b\u341c", // 㐜
	0x341d: "\x05\b\u341d", // 㐝
	0x341e: "\x05\b\u341e", // 㐞
	0x341f: "\x05\b\u341f", // 㐟
	0x3420: "\x05\b\u3420", // 㐠
	0x3421: "\x05\n\u3421", // 㐡
	0x3422: "\x05\n\u3422", // 㐢
	0x3423: "\x05\n\u3423", // 㐣
	0x3424: "\x05\v\u3424", // 㐤
	0x3425: "\x05\x0f\u3425", // 㐥
	0x3426: "\x05\x12\u3426", // 㐦
	0x3427: "\x06\x03\u3427", // 㐧
	0x3428: "\x06\a\u3428", // 㐨
	0x3429: "\a\x06\u3429", // 㐩
	0x342a: "\b\x04\u342a", // 㐪
	0x342b: "\b\x04\u342b", // 㐫
	0x342c: "\b\x05\u342c", // 㐬
	0x342d: "\b\x06\u342d", // 㐭
	0x342e: "\b\v\u342e", // 㐮
	0x342f: "\b\x0f\u342f", // 㐯
	0x3430: "\t\x03\u3430", // 㐰
	0x3431: "\t\x03\u3431", // 㐱
	0x3432: "\t\x03\u3432", // 㐲
	0x3433: "\t\x03\u3433", // 㐳
	0x3434: "\t\x03\u3434", // 㐴
	0x3435: "\t\x03\u3435", // 㐵
	0x3436: "\t\x03\u3436", // 㐶
	0x3437: "\t\x03\u3437", // 㐷
	0x3438: "\t\x04\u3438", // 㐸
	0x3439: "\t\x04\u3439", // 㐹
	0x343a: "\t\x04\u343a", // 㐺
	0x343b: "\t\x04\u343b", // 㐻
	0x343c: "\t\x04\u343c", // 㐼
	0x343d: "\t\x04\u343d", // 㐽
	0x343e: "\t\x04\u343e", // 㐾
	0x343f: "\t\x04\u343f", // 㐿
	0x3440: "\t\x04\u3440", // 㑀
	0x3441: "\t\x05\u3441", // 㑁
	0x3442: "\t\x05\u3442", // 㑂
	0x3443: "\t\x05\u3443", // 㑃
	0x3444: "\t\x05\u3444", // 㑄
	0x3445: "\t\x05\u3445", // 㑅
	0x3446: "\t\x05\u3446", // 㑆
	0x3447: "\t\x05\u3447", // 㑇
	0x3448: "\t\x05\u3448", // 㑈
	0x3449: "\t\x06\u3449", // 㑉
	0x344a: "\t\x06\u344a", // 㑊
	0x344b: "\t\x06\u344b", // 㑋
	0x344c: "\t\x06\u344c", // 㑌
	0x344d: "\t\x06\u344d", // 㑍
	0x344e: "\t\x06\u344e", // 㑎
	0x344f: "\t\x06\u344f", // 㑏
	0x3450: "\t\x06\u3450", // 㑐
	0x3451: "\t\x06\u3451", // 㑑
	0x3452: "\t\x06\u3452", // 㑒
	0x3453: "\t\x06\u3453", // 㑓
	0x3454: "\t\x06\u3454", // 㑔
	0x3455: "\t\x06\u3455", // 㑕
	0x3456: "\t\x06\u3456", // 㑖
	0x3457: "\t\a\u3457", // 㑗
	0x3458: "\t\a\u3458", // 㑘
	0x3459: "\t\a\u3459", // 㑙
	0x345a: "\t\a\u345a", // 㑚
	0x345b: "\t\a\u345b", // 㑛
	0x345c: "\t\a\u345c", // 㑜
	0x345d: "\t\a\u345d", // 㑝
	0x345e: "\t\a\u345e", // 㑞
	0x345f: "\t\a\u345f", // 㑟
	0x3460: "\t\a\u3460", // 㑠
	0x3461: "\t\a\u3461", // 㑡
	0x3462: "\t\a\u3462", // 㑢
	0x3463: "\t\b\u3463", // 㑣
	0x3464: "\t\t\u3464", // 㑤
	0x3465: "\t\b\u3465", // 㑥
	0x3466: "\t\b\u3466", // 㑦
	0x3467: "\t\b\u3467", // 㑧
	0x3468: "\t\b\u3468", // 㑨
	0x3469: "\t\b\u3469", // 㑩
	0x346a: "\t\b\u346a", // 㑪
	0x346b: "\t\b\u346b", // 㑫
	0x346c: "\t\b\u346c", // 㑬
	0x346d: "\t\b\u346d", // 㑭
	0x346e: "\t\t\u346e", // 㑮
	0x346f: "\t\t\u346f", // 㑯
	0x3470: "\t\t\u3470", // 㑰
	0x3471: "\t\t\u3471", // 㑱
	0x3472: "\t\t\u3472", // 㑲
	0x3473: "\t\n\u3473", // 㑳
	0x3474: "\t\n\u3474", // 㑴
	0x3475: "\t\n\u3475", // 㑵
	0x3476: "\t\n\u3476", // 㑶
	0x3477: "\t\n\u3477", // 㑷
	0x3478: "\t\n\u3478", // 㑸
	0x3479: "\t\n\u3479", // 㑹
	0x347a: "\t\n\u347a", // 㑺
	0x347b: "\t\v\u347b", // 㑻
	0x347c: "\t\v\u347c", // 㑼
	0x347d: "\t\v\u347d", // 㑽
	0x347e: "\t\v\u347e", // 㑾
	0x347f: "\t\v\u347f", // 㑿
	0x3480: "\t\v\u3480", // 㒀
	0x3481: "\t\v\u3481", // 㒁
	0x3482: "\t\f\u3482", // 㒂
	0x3483: "\t\f\u3483", // 㒃
	0x3484: "\t\f\u3484", // 㒄
	0x3485: "\t\f\u3485", // 㒅
	0x3486: "\t\f\u3486", // 㒆
	0x3487: "\t\f\u3487", // 㒇
	0x3488: "\t\f\u3488", // 㒈
	0x3489: "\t\f\u3489", // 㒉
	0x348a: "\t\f\u348a", // 㒊
	0x348b: "\t\f\u348b", // 㒋
	0x348c: "\t\f\u348c", // 㒌
	0x348d: "\t\f\u348d", // 㒍
	0x348e: "\t\f\u348e", // 㒎
	0x348f: "\t\f\u348f", // 㒏
	0x3490: "\t\f\u3490", // 㒐
	0x3491: "\t\r\u3491", // 㒑
	0x3492: "\t\r\u3492", // 㒒
	0x3493: "\t\r\u3493", // 㒓
	0x3494: "\t\r\u3494", // 㒔
	0x3495: "\t\r\u3495", // 㒕
	0x3496: "\t\r\u3496", // 㒖
	0x3497: "\t\r\u3497", // 㒗
	0x3498: "\t\r\u3498", // 㒘
	0x3499: "\t\x0e\u3499", // 㒙
	0x349a: "\t\x0e\u349a", // 㒚
	0x349b: "\t\x0e\u349b", // 㒛
	0x349c: "\t\x0e\u349c", // 㒜
	0x349d: "\t\x0f\u349d", // 㒝
	0x349e: "\t\x0f\u349e", // 㒞
	0x349f: "\t\x10\u349f", // 㒟
	0x34a0: "\t\x10\u34a0", // 㒠
	0x34a1: "\t\x11\u34a1", // 㒡
	0x34a2: "\t\x11\u34a2", // 㒢
	0x34a3: "\t\x11\u34a3", // 㒣
	0x34a4: "\t\x12\u34a4", // 㒤
	0x34a5: "\t\x12\u34a5", // 㒥
	0x34a6: "\t\x12\u34a6", // 㒦
	0x34a7: "\t\x13\u34a7", // 㒧
	0x34a8: "\t\x13\u34a8", // 㒨
	0x34a9: "\t\x15\u34a9", // 㒩
	0x34aa: "\t\x18\u34aa", // 㒪
	0x34ab: "\n\x04\u34ab", // 㒫
	0x34ac: "\n\x06\u34ac", // 㒬
	0x34ad: "\n\b\u34ad", // 㒭
	0x34ae: "\n\t\u34ae", // 㒮
	0x34af: "\n\x10\u34af", // 㒯
	0x34b0: "\v\x03\u34b0", // 㒰
	0x34b1: "\v\x03\u34b1", // 㒱
	0x34b2: "\v\x04\u34b2", // 㒲
	0x34b3: "\v\x05\u34b3", // 㒳
	0x34b4: "\v\x05\u34b4", // 㒴
	0x34b5: "\f\x05\u34b5", // 㒵
	0x34b6: "\f\x05\u34b6", // 㒶
	0x34b7: "\f\x05\u34b7", // 㒷
	0x34b8: "\f\a\u34b8", // 㒸
	0x34b9: "\f\x12\u34b9", // 㒹
	0x34ba: "\r\x06\u34ba", // 㒺
	0x34bb: "\r\t\u34bb", // 㒻
	0x34bc: "\r\t\u34bc", // 㒼
	0x34bd: "\r\n\u34bd", // 㒽
	0x34be: "\r\v\u34be", // 㒾
	0x34bf: "\r\x14\u34bf", // 㒿
	0x34c0: "\x0e\x02\u34c0", // 㓀
	0x34c1: "\x0e\x02\u34c1", // 㓁
	0x34c2: "\x0e\a\u34c2", // 㓂
	0x34c3: "\x0e\n\u34c3", // 㓃
	0x34c4: "\x0e\r\u34c4", // 㓄
	0x34c5: "\x0f\x02\u34c5", // 㓅
	0x34c6: "\x0f\x04\u34c6", // 㓆
	0x34c7: "\x0f\x04\u34c7", // 㓇
	0x34c8: "\x0f\x05\u34c8", // 㓈
	0x34c9: "\x0f\x06\u34c9", // 㓉
	0x34ca: "\x0f\x06\u34ca", // 㓊
	0x34cb: "\x0f\x06\u34cb", // 㓋
	0x34cc: "\x0f\x06\u34cc", // 㓌
	0x34cd: "\x0f\x06\u34cd", // 㓍
	0x34ce: "\x0f\a\u34ce", // 㓎
	0x34cf: "\x0f\a\u34cf", // 㓏
	0x34d0: "\x0f\b\u34d0", // 㓐
	0x34d1: "\x0f\b\u34d1", // 㓑
	0x34d2: "\x0f\b\u34d2", // 㓒
	0x34d3: "\x0f\t\u34d3", // 㓓
	0x34d4: "\x0f\n\u34d4", // 㓔
	0x34d5: "\x0f\n\u34d5", // 㓕
	0x34d6: "\x0f\v\u34d6", // 㓖
	0x34d7: "\x0f\f\u34d7", // 㓗
	0x34d8: "\x10\t\u34d8", // 㓘
	0x34d9: "\x11\x04\u34d9", // 㓙
	0x34da: "\x12\x03\u34da", // 㓚
	0x34db: "\x12\x03\u34db", // 㓛
	0x34dc: "\x12\x03\u34dc", // 㓜
	0x34dd: "\x12\x04\u34dd", // 㓝
	0x34de: "\x12\x04\u34de", // 㓞
	0x34df: "\x12\x05\u34df", // 㓟
	0x34e0: "\x12\x05\u34e0", // 㓠
	0x34e1: "\x12\x06\u34e1", // 㓡
	0x34e2: "\x12\x06\u34e2", // 㓢
	0x34e3: "\x12\x06\u34e3", // 㓣
	0x34e4: "\x12\x06\u34e4", // 㓤
	0x34e5: "\x12\x06\u34e5", // 㓥
	0x34e6: "\x12\x06\u34e6", // 㓦
	0x34e7: "\x12\a\u34e7", // 㓧
	0x34e8: "\x12\a\u34e8", // 㓨
	0x34e9: "\x12\a\u34e9", // 㓩
	0x34ea: "\x12\a\u34ea", // 㓪
	0x34eb: "\x12\a\u34eb", // 㓫
	0x34ec: "\x12\b\u34ec", // 㓬
	0x34ed: "\x12\b\u34ed", // 㓭
	0x34ee: "\x12\b\u34ee", // 㓮
	0x34ef: "\x12\b\u34ef", // 㓯
	0x34f0: "\x12\b\u34f0", // 㓰
	0x34f1: "\x12\t\u34f1", // 㓱
	0x34f2: "\x12\t\u34f2", // 㓲
	0x34f3: "\x12\t\u34f3", // 㓳
	0x34f4: "\x12\t\u34f4", // 㓴
	0x34f5: "\x12\t\u34f5", // 㓵
	0x34f6: "\x12\t\u34f6", // 㓶
	0x34f7: "\x12\n\u34f7", // 㓷
	0x34f8: "\x12\n\u34f8", // 㓸
	0x34f9: "\x12\n\u34f9", // 㓹
	0x34fa: "\x12\n\u34fa", // 㓺
	0x34fb: "\x12\n\u34fb", // 㓻
	0x34fc: "\x12\v\u34fc", // 㓼
	0x34fd: "\x12\v\u34fd", // 㓽
	0x34fe: "\x12\f\u34fe", // 㓾
	0x34ff: "\x12\f\u34ff", // 㓿
	0x3500: "\x12\f\u3500", // 㔀
	0x3501: "\x12\f\u3501", // 㔁
	0x3502: "\x12\f\u3502", // 㔂
	0x3503: "\x12\f\u3503", // 㔃
	0x3504: "\x12\f\u3504", // 㔄
	0x3505: "\x12\f\u3505", // 㔅
	0x3506: "\x12\f\u3506", // 㔆
	0x3507: "\x12\f\u3507", // 㔇
	0x3508: "\x12\f\u3508", // 㔈
	0x3509: "\x12\f\u3509", // 㔉
	0x350a: "\x12\r\u350a", // 㔊
	0x350b: "\x12\x0e\u350b", // 㔋
	0x350c: "\x12\x0e\u350c", // 㔌
	0x350d: "\x12\x0e\u350d", // 㔍
	0x350e: "\x12\x0f\u350e", // 㔎
	0x350f: "\x12\x0f\u350f", // 㔏
	0x3510: "\x12\x10\u3510", // 㔐
	0x3511: "\x12\x11\u3511", // 㔑
	0x3512: "\x12\x12\u3512", // 㔒
	0x3513: "\x13\x03\u3513", // 㔓
	0x3514: "\x13\x04\u3514", // 㔔
	0x3515: "\x13\x04\u3515", // 㔕
	0x3516: "\x13\x04\u3516", // 㔖
	0x3517: "\x13\x05\u3517", // 㔗
	0x3518: "\x13\x05\u3518", // 㔘
	0x3519: "\x13\x06\u3519", // 㔙
	0x351a: "\x13\x06\u351a", // 㔚
	0x351b: "\x13\x06\u351b", // 㔛
	0x351c: "\x13\a\u351c", // 㔜
	0x351d: "\x13\b\u351d", // 㔝
	0x351e: "\x13\b\u351e", // 㔞
	0x351f: "\x13\b\u351f", // 㔟
	0x3520: "\x13\t\u3520", // 㔠
	0x3521: "\x13\n\u3521", // 㔡
	0x3522: "\x13\f\u3522", // 㔢
	0x3523: "\x13\x0f\u3523", // 㔣
	0x3524: "\x13\x0f\u3524", // 㔤
	0x3525: "\x13\x0f\u3525", // 㔥
	0x3526: "\x13\x0f\u3526", // 㔦
	0x3527: "\x13\x10\u3527", // 㔧
	0x3528: "\x14\t\u3528", // 㔨
	0x3529: "\x14\n\u3529", // 㔩
	0x352a: "\x14\v\u352a", // 㔪
	0x352b: "\x15\x02\u352b", // 㔫
	0x352c: "\x15\x06\u352c", // 㔬
	0x352d: "\x15\t\u352d", // 㔭
	0x352e: "\x82\x11\u352e", // 㔮
	0x352f: "\x16\x05\u352f", // 㔯
	0x3530: "\x16\x05\u3530", // 㔰
	0x3531: "\x16\t\u3531", // 㔱
	0x3532: "\x16\v\u3532", // 㔲
	0x3533: "\x16\v\u3533", // 㔳
	0x3534: "\x16\v\u3534", // 㔴
	0x3535: "\x16\f\u3535", // 㔵
	0x3536: "\x16\x18\u3536", // 㔶
	0x3537: "\x17\x05\u3537", // 㔷
	0x3538: "\x17\n\u3538", // 㔸
	0x3539: "\x18\x02\u3539", // 㔹
	0x353a: "\x18\x04\u353a", // 㔺
	0x353b: "\x18\x04\u353b", // 㔻
	0x353c: "\x18\v\u353c", // 㔼
	0x353d: "\x19\x06\u353d", // 㔽
	0x353e: "\x1a\x01\u353e", // 㔾
	0x353f: "\x1a\x01\u353f", // 㔿
	0x3540: "\x1a\x05\u3540", // 㕀
	0x3541: "\x1a\x06\u3541", // 㕁
	0x3542: "\x1b\x04\u3542", // 㕂
	0x3543: "\x1b\x04\u3543", // 㕃
	0x3544: "\x1b\x04\u3544", // 㕄
	0x3545: "\x1b\x05\u3545", // 㕅
	0x3546: "\x1b\x05\u3546", // 㕆
	0x3547: "\x1b\x05\u3547", // 㕇
	0x3548: "\x1b\x06\u3548", // 㕈
	0x3549: "\x1b\x06\u3549", // 㕉
	0x354a: "\x1b\a\u354a", // 㕊
	0x354b: "\x1b\b\u354b", // 㕋
	0x354c: "\x1b\b\u354c", // 㕌
	0x354d: "\x1b\b\u354d", // 㕍
	0x354e: "\x1b\n\u354e", // 㕎
	0x354f: "\x1b\v\u354f", // 㕏
	0x3550: "\x1b\f\u3550", // 㕐
	0x3551: "\x1b\f\u3551", // 㕑
	0x3552: "\x1b\r\u3552", // 㕒
	0x3553: "\x1b\x0f\u3553", // 㕓
	0x3554: "\x1b\x16\u3554", // 㕔
	0x3555: "\x1c\x02\u3555", // 㕕
	0x3556: "\x1c\b\u3556", // 㕖
	0x3557: "\x1c\t\u3557", // 㕗
	0x3558: "\x1c\t\u3558", // 㕘
	0x3559: "\x1c\r\u3559", // 㕙
	0x355a: "\x1d\x02\u355a", // 㕚
	0x355b: "\x1d\x02\u355b", // 㕛
	0x355c: "\x1d\x04\u355c", // 㕜
	0x355d: "\x1d\x05\u355d", // 㕝
	0x355e: "\x1d\x06\u355e", // 㕞
	0x355f: "\x1d\a\u355f", // 㕟
	0x3560: "\x1d\n\u3560", // 㕠
	0x3561: "\x1d\f\u3561", // 㕡
	0x3562: "\x9a\a\u3562", // 㕢
	0x3563: "\x1e\x02\u3563", // 㕣
	0x3564: "\x1e\x02\u3564", // 㕤
	0x3565: "\x1e\x02\u3565", // 㕥
	0x3566: "\x1e\x03\u3566", // 㕦
	0x3567: "\x1e\x03\u3567", // 㕧
	0x3568: "\x1e\x03\u3568", // 㕨
	0x3569: "\x1e\x04\u3569", // 㕩
	0x356a: "\x1e\x04\u356a", // 㕪
	0x356b: "\x1e\x04\u356b", // 㕫
	0x356c: "\x1e\x04\u356c", // 㕬
	0x356d: "\x1e\x04\u356d", // 㕭
	0x356e: "\x1e\x04\u356e", // 㕮
	0x356f: "\x1e\x04\u356f", // 㕯
	0x3570: "\x1e\x04\u3570", // 㕰
	0x3571: "\x1e\x04\u3571", // 㕱
	0x3572: "\x1e\x04\u3572", // 㕲
	0x3573: "\x1e\x04\u3573", // 㕳
	0x3574: "\x1e\x04\u3574", // 㕴
	0x3575: "\x1e\x04\u3575", // 㕵
	0x3576: "\x1e\x04\u3576", // 㕶
	0x3577: "\x1e\x05\u3577", // 㕷
	0x3578: "\x1e\x05\u3578", // 㕸
	0x3579: "\x1e\x05\u3579", // 㕹
	0x357a: "\x1e\x05\u357a", // 㕺
	0x357b: "\x1e\x05\u357b", // 㕻
	0x357c: "\x1e\x05\u357c", // 㕼
	0x357d: "\x1e\x05\u357d", // 㕽
	0x357e: "\x1e\x05\u357e", // 㕾
	0x357f: "\x1e\x05\u357f", // 㕿
	0x3580: "\x1e\x06\u3580", // 㖀
	0x3581: "\x1e\x06\u3581", // 㖁
	0x3582: "\x1e\x06\u3582", // 㖂
	0x3583: "\x1e\x06\u3583", // 㖃
	0x3584: "\x1e\x06\u3584", // 㖄
	0x3585: "\x1e\x06\u3585", // 㖅
	0x3586: "\x1e\x06\u3586", // 㖆
	0x3587: "\x1e\x06\u3587", // 㖇
	0x3588: "\x1e\x06\u3588", // 㖈
	0x3589: "\x1e\x06\u3589", // 㖉
	0x358a: "\x1e\x06\u358a", // 㖊
	0x358b: "\x1e\x06\u358b", // 㖋
	0x358c: "\x1e\x06\u358c", // 㖌
	0x358d: "\x1e\x06\u358d", // 㖍
	0x358e: "\x1e\x06\u358e", // 㖎
	0x358f: "\x1e\a\u358f", // 㖏
	0x3590: "\x1e\a\u3590", // 㖐
	0x3591: "\x1e\a\u3591", // 㖑
	0x3592: "\x1e\a\u3592", // 㖒
	0x3593: "\x1e\a\u3593", // 㖓
	0x3594: "\x1e\a\u3594", // 㖔
	0x3595: "\x1e\a\u3595", // 㖕
	0x3596: "\x1e\a\u3596", // 㖖
	0x3597: "\x1e\a\u3597", // 㖗
	0x3598: "\x1e\a\u3598", // 㖘
	0x3599: "\x1e\a\u3599", // 㖙
	0x359a: "\x1e\a\u359a", // 㖚
	0x359b: "\x1e\a\u359b", // 㖛
	0x359c: "\x1e\a\u359c", // 㖜
	0x359d: "\x1e\a\u359d", // 㖝
	0x359e: "\x1e\a\u359e", // 㖞
	0x359f: "\x1e\b\u359f", // 㖟
	0x35a0: "\x1e\b\u35a0", // 㖠
	0x35a1: "\x1e\b\u35a1", // 㖡
	0x35a2: "\x1e\b\u35a2", // 㖢
	0x35a3: "\x1e\b\u35a3", // 㖣
	0x35a4: "\x1e\b\u35a4", // 㖤
	0x35a5: "\x1e\b\u35a5", // 㖥
	0x35a6: "\x1e\b\u35a6", // 㖦
	0x35a7: "\x1e\b\u35a7", // 㖧
	0x35a8: "\x1e\b\u35a8", // 㖨
	0x35a9: "\x1e\b\u35a9", // 㖩
	0x35aa: "\x1e\b\u35aa", // 㖪
	0x35ab: "\x1e\b\u35ab", // 㖫
	0x35ac: "\x1e\b\u35ac", // 㖬
	0x35ad: "\x1e\b\u35ad", // 㖭
	0x35ae: "\x1e\b\u35ae", // 㖮
	0x35af: "\x1e\b\u35af", // 㖯
	0x35b0: "\x1e\b\u35b0", // 㖰
	0x35b1: "\x1e\b\u35b1", // 㖱
	0x35b2: "\x1e\b\u35b2", // 㖲
	0x35b3: "\x1e\b\u35b3", // 㖳
	0x35b4: "\x1e\b\u35b4", // 㖴
	0x35b5: "\x1e\b\u35b5", // 㖵
	0x35b6: "\x1e\t\u35b6", // 㖶
	0x35b7: "\x1e\t\u35b7", // 㖷
	0x35b8: "\x1e\t\u35b8", // 㖸
	0x35b9: "\x1e\t\u35b9", // 㖹
	0x35ba: "\x1e\t\u35ba", // 㖺
	0x35bb: "\x1e\t\u35bb", // 㖻
	0x35bc: "\x1e\t\u35bc", // 㖼
	0x35bd: "\x1e\t\u35bd", // 㖽
	0x35be: "\x1e\t\u35be", // 㖾
	0x35bf: "\x1e\t\u35bf", // 㖿
	0x35c0: "\x1e\t\u35c0", // 㗀
	0x35c1: "\x1e\t\u35c1", // 㗁
	0x35c2: "\x1e\t\u35c2", // 㗂
	0x35c3: "\x1e\t\u35c3", // 㗃
	0x35c4: "\x1e\t\u35c4", // 㗄
	0x35c5: "\x1e\t\u35c5", // 㗅
	0x35c6: "\x1e\t\u35c6", // 㗆
	0x35c7: "\x1e\t\u35c7", // 㗇
	0x35c8: "\x1e\t\u35c8", // 㗈
	0x35c9: "\x1e\t\u35c9", // 㗉
	0x35ca: "\x1e\t\u35ca", // 㗊
	0x35cb: "\x1e\t\u35cb", // 㗋
	0x35cc: "\x1e\t\u35cc", // 㗌
	0x35cd: "\x1e\t\u35cd", // 㗍
	0x35ce: "\x1e\t\u35ce", // 㗎
	0x35cf: "\x1e\t\u35cf", // 㗏
	0x35d0: "\x1e\t\u35d0", // 㗐
	0x35d1: "\x1e\t\u35d1", // 㗑
	0x35d2: "\x1e\n\u35d2", // 㗒
	0x35d3: "\x1e\n\u35d3", // 㗓
	0x35d4: "\x1e\n\u35d4", // 㗔
	0x35d5: "\x1e\n\u35d5", // 㗕
	0x35d6: "\x1e\n\u35d6", // 㗖
	0x35d7: "\x1e\n\u35d7", // 㗗
	0x35d8: "\x1e\n\u35d8", // 㗘
	0x35d9: "\x1e\n\u35d9", // 㗙
	0x35da: "\x1e\n\u35da", // 㗚
	0x35db: "\x1e\n\u35db", // 㗛
	0x35dc: "\x1e\n\u35dc", // 㗜
	0x35dd: "\x1e\n\u35dd", // 㗝
	0x35de: "\x1e\n\u35de", // 㗞
	0x35df: "\x1e\n\u35df", // 㗟
	0x35e0: "\x1e\n\u35e0", // 㗠
	0x35e1: "\x1e\n\u35e1", // 㗡
	0x35e2: "\x1e\v\u35e2", // 㗢
	0x35e3: "\x1e\v\u35e3", // 㗣
	0x35e4: "\x1e\v\u35e4", // 㗤
	0x35e5: "\x1e\v\u35e5", // 㗥
	0x35e6: "\x1e\v\u35e6", // 㗦
	0x35e7: "\x1e\v\u35e7", // 㗧
	0x35e8: "\x1e\v\u35e8", // 㗨
	0x35e9: "\x1e\v\u35e9", // 㗩
	0x35ea: "\x1e\v\u35ea", // 㗪
	0x35eb: "\x1e\v\u35eb", // 㗫
	0x35ec: "\x1e\v\u35ec", // 㗬
	0x35ed: "\x1e\v\u35ed", // 㗭
	0x35ee: "\x1e\v\u35ee", // 㗮
	0x35ef: "\x1e\v\u35ef", // 㗯
	0x35f0: "\x1e\v\u35f0", // 㗰
	0x35f1: "\x1e\f\u35f1", // 㗱
	0x35f2: "\x1e\f\u35f2", // 㗲
	0x35f3: "\x1e\f\u35f3", // 㗳
	0x35f4: "\x1e\f\u35f4", // 㗴
	0x35f5: "\x1e\f\u35f5", // 㗵
	0x35f6: "\x1e\f\u35f6", // 㗶
	0x35f7: "\x1e\f\u35f7", // 㗷
	0x35f8: "\x1e\f\u35f8", // 㗸
	0x35f9: "\x1e\f\u35f9", // 㗹
	0x35fa: "\x1e\f\u35fa", // 㗺
	0x35fb: "\x1e\r\u35fb", // 㗻
	0x35fc: "\x1e\r\u35fc", // 㗼
	0x35fd: "\x1e\r\u35fd", // 㗽
	0x35fe: "\x1e\r\u35fe", // 㗾
	0x35ff: "\x1e\r\u35ff", // 㗿
	0x3600: "\x1e\r\u3600", // 㘀
	0x3601: "\x1e\r\u3601", // 㘁
	0x3602: "\x1e\r\u3602", // 㘂
	0x3603: "\x1e\r\u3603", // 㘃
	0x3604: "\x1e\r\u3604", // 㘄
	0x3605: "\x1e\x0e\u3605", // 㘅
	0x3606: "\x1e\x0e\u3606", // 㘆
	0x3607: "\x1e\x0e\u3607", // 㘇
	0x3608: "\x1e\x0e\u3608", // 㘈
	0x3609: "\x1e\x0f\u3609", // 㘉
	0x360a: "\x1e\x0f\u360a", // 㘊
	0x360b: "\x1e\x0f\u360b", // 㘋
	0x360c: "\x1e\x0f\u360c", // 㘌
	0x360d: "\x1e\x0f\u360d", // 㘍
	0x360e: "\x1e\x0f\u360e", // 㘎
	0x360f: "\x1e\x0f\u360f", // 㘏
	0x3610: "\x1e\x10\u3610", // 㘐
	0x3611: "\x1e\x10\u3611", // 㘑
	0x3612: "\x1e\x10\u3612", // 㘒
	0x3613: "\x1e\x11\u3613", // 㘓
	0x3614: "\x1e\x11\u3614", // 㘔
	0x3615: "\x1e\x12\u3615", // 㘕
	0x3616: "\x1e\x12\u3616", // 㘖
	0x3617: "\x1e\x12\u3617", // 㘗
	0x3618: "\x1e\x13\u3618", // 㘘
	0x3619: "\x1e\x14\u3619", // 㘙
	0x361a: "\x1e\x14\u361a", // 㘚
	0x361b: "\x1e\x16\u361b", // 㘛
	0x361c: "\x1e\x17\u361c", // 㘜
	0x361d: "\x1f\x02\u361d", // 㘝
	0x361e: "\x13\x03\u361e", // 㘞
	0x361f: "\x1f\x03\u361f", // 㘟
	0x3620: "\x1f\x05\u3620", // 㘠
	0x3621: "\x1f\x05\u3621", // 㘡
	0x3622: "\x1f\x06\u3622", // 㘢
	0x3623: "\x1f\a\u3623", // 㘣
	0x3624: "\x1f\v\u3624", // 㘤
	0x3625: "\x1f\x11\u3625", // 㘥
	0x3626: " \x02\u3626", // 㘦
	0x3627: " \x04\u3627", // 㘧
	0x3628: " \x04\u3628", // 㘨
	0x3629: " \x04\u3629", // 㘩
	0x362a: " \x04\u362a", // 㘪
	0x362b: " \x04\u362b", // 㘫
	0x362c: " \x04\u362c", // 㘬
	0x362d: " \x04\u362d", // 㘭
	0x362e: " \x04\u362e", // 㘮
	0x362f: " \x04\u362f", // 㘯
	0x3630: " \x04\u3630", // 㘰
	0x3631: " \x05\u3631", // 㘱
	0x3632: " \x05\u3632", // 㘲
	0x3633: " \x05\u3633", // 㘳
	0x3634: " \x05\u3634", // 㘴
	0x3635: " \x05\u3635", // 㘵
	0x3636: " \x06\u3636", // 㘶
	0x3637: " \x06\u3637", // 㘷
	0x3638: " \x06\u3638", // 㘸
	0x3639: " \x06\u3639", // 㘹
	0x363a: " \x06\u363a", // 㘺
	0x363b: " \x06\u363b", // 㘻
	0x363c: " \x06\u363c", // 㘼
	0x363d: " \x06\u363d", // 㘽
	0x363e: " \x06\u363e", // 㘾
	0x363f: " \a\u363f", // 㘿
	0x3640: " \a\u3640", // 㙀
	0x3641: " \a\u3641", // 㙁
	0x3642: " \a\u3642", // 㙂
	0x3643: " \a\u3643", // 㙃
	0x3644: " \a\u3644", // 㙄
	0x3645: " \a\u3645", // 㙅
	0x3646: " \a\u3646", // 㙆
	0x3647: " \b\u3647", // 㙇
	0x3648: " \b\u3648", // 㙈
	0x3649: " \b\u3649", // 㙉
	0x364a: " \b\u364a", // 㙊
	0x364b: " \b\u364b", // 㙋
	0x364c: " \b\u364c", // 㙌
	0x364d: " \b\u364d", // 㙍
	0x364e: " \t\u364e", // 㙎
	0x364f: " \t\u364f", // 㙏
	0x3650: " \t\u3650", // 㙐
	0x3651: " \t\u3651", // 㙑
	0x3652: " \t\u3652", // 㙒
	0x3653: " \t\u3653", // 㙓
	0x3654: " \t\u3654", // 㙔
	0x3655: " \t\u3655", // 㙕
	0x3656: " \t\u3656", // 㙖
	0x3657: " \t\u3657", // 㙗
	0x3658: " \t\u3658", // 㙘
	0x3659: " \n\u3659", // 㙙
	0x365a: " \n\u365a", // 㙚
	0x365b: " \n\u365b", // 㙛
	0x365c: " \n\u365c", // 㙜
	0x365d: " \n\u365d", // 㙝
	0x365e: " \n\u365e", // 㙞
	0x365f: " \n\u365f", // 㙟
	0x3660: " \v\u3660", // 㙠
	0x3661: " \v\u3661", // 㙡
	0x3662: " \v\u3662", // 㙢
	0x3663: " \v\u3663", // 㙣
	0x3664: " \v\u3664", // 㙤
	0x3665: " \v\u3665", // 㙥
	0x3666: " \v\u3666", // 㙦
	0x3667: " \f\u3667", // 㙧
	0x3668: " \f\u3668", // 㙨
	0x3669: " \f\u3669", // 㙩
	0x366a: " \f\u366a", // 㙪
	0x366b: " \f\u366b", // 㙫
	0x366c: " \f\u366c", // 㙬
	0x366d: " \f\u366d", // 㙭
	0x366e: " \f\u366e", // 㙮
	0x366f: " \f\u366f", // 㙯
	0x3670: " \r\u3670", // 㙰
	0x3671: " \r\u3671", // 㙱
	0x3672: " \r\u3672", // 㙲
	0x3673: " \r\u3673", // 㙳
	0x3674: " \r\u3674", // 㙴
	0x3675: " \r\u3675", // 㙵
	0x3676: " \r\u3676", // 㙶
	0x3677: " \x0e\u3677", // 㙷
	0x3678: " \x0e\u3678", // 㙸
	0x3679: " \x0e\u3679", // 㙹
	0x367a: " \x0e\u367a", // 㙺
	0x367b: " \x0f\u367b", // 㙻
	0x367c: " \x0f\u367c", // 㙼
	0x367d: " \x0f\u367d", // 㙽
	0x367e: " \x10\u367e", // 㙾
	0x367f: " \x10\u367f", // 㙿
	0x3680: " \x11\u3680", // 㚀
	0x3681: " \x15\u3681", // 㚁
	0x3682: " \x16\u3682", // 㚂
	0x3683: "!\t\u3683", // 㚃
	0x3684: "!\f\u3684", // 㚄
	0x3685: "\"\x06\u3685", // 㚅
	0x3686: "#\x06\u3686", // 㚆
	0x3687: "#\x06\u3687", // 㚇
	0x3688: "$\x02\u3688", // 㚈
	0x3689: "$\x05\u3689", // 㚉
	0x368a: "$\t\u368a", // 㚊
	0x368b: "$\v\u368b", // 㚋
	0x368c: "$\v\u368c", // 㚌
	0x368d: "$\x0f\u368d", // 㚍
	0x368e: "%\x02\u368e", // 㚎
	0x368f: "%\x03\u368f", // 㚏
	0x3690: "%\x03\u3690", // 㚐
	0x3691: "%\x03\u3691", // 㚑
	0x3692: "%\x04\u3692", // 㚒
	0x3693: "%\x04\u3693", // 㚓
	0x3694: "%\x05\u3694", // 㚔
	0x3695: "%\x05\u3695", // 㚕
	0x3696: "%\x05\u3696", // 㚖
	0x3697: "%\x05\u3697", // 㚗
	0x3698: "%\x05\u3698", // 㚘
	0x3699: "%\x05\u3699", // 㚙
	0x369a: "%\x06\u369a", // 㚚
	0x369b: "%\x06\u369b", // 㚛
	0x369c: "%\b\u369c", // 㚜
	0x369d: "%\b\u369d", // 㚝
	0x369e: "%\b\u369e", // 㚞
	0x369f: "%\t\u369f", // 㚟
	0x36a0: "%\n\u36a0", // 㚠
	0x36a1: "%\r\u36a1", // 㚡
	0x36a2: "&\x02\u36a2", // 㚢
	0x36a3: "&\x03\u36a3", // 㚣
	0x36a4: "&\x03\u36a4", // 㚤
	0x36a5: "&\x03\u36a5", // 㚥
	0x36a6: "&\x03\u36a6", // 㚦
	0x36a7: "&\x03\u36a7", // 㚧
	0x36a8: "&\x03\u36a8", // 㚨
	0x36a9: "&\x04\u36a9", // 㚩
	0x36aa: "&\x04\u36aa", // 㚪
	0x36ab: "&\x04\u36ab", // 㚫
	0x36ac: "&\x04\u36ac", // 㚬
	0x36ad: "&\x04\u36ad", // 㚭
	0x36ae: "&\x04\u36ae", // 㚮
	0x36af: "&\x04\u36af", // 㚯
	0x36b0: "&\x05\u36b0", // 㚰
	0x36b1: "&\x05\u36b1", // 㚱
	0x36b2: "&\x05\u36b2", // 㚲
	0x36b3: "&\x05\u36b3", // 㚳
	0x36b4: "&\x05\u36b4", // 㚴
	0x36b5: "&\x05\u36b5", // 㚵
	0x36b6: "&\x05\u36b6", // 㚶
	0x36b7: "&\x05\u36b7", // 㚷
	0x36b8: "&\x05\u36b8", // 㚸
	0x36b9: "&\x05\u36b9", // 㚹
	0x36ba: "&\x05\u36ba", // 㚺
	0x36bb: "&\x05\u36bb", // 㚻
	0x36bc: "&\x05\u36bc", // 㚼
	0x36bd: "&\x05\u36bd", // 㚽
	0x36be: "&\x05\u36be", // 㚾
	0x36bf: "&\x05\u36bf", // 㚿
	0x36c0: "&\x05\u36c0", // 㛀
	0x36c1: "&\x05\u36c1", // 㛁
	0x36c2: "&\x06\u36c2", // 㛂
	0x36c3: "&\x06\u36c3", // 㛃
	0x36c4: "&\x06\u36c4", // 㛄
	0x36c5: "&\x06\u36c5", // 㛅
	0x36c6: "&\x06\u36c6", // 㛆
	0x36c7: "&\x06\u36c7", // 㛇
	0x36c8: "&\x06\u36c8", // 㛈
	0x36c9: "&\x06\u36c9", // 㛉
	0x36ca: "&\x06\u36ca", // 㛊
	0x36cb: "&\x06\u36cb", // 㛋
	0x36cc: "&\x06\u36cc", // 㛌
	0x36cd: "&\a\u36cd", // 㛍
	0x36ce: "&\a\u36ce", // 㛎
	0x36cf: "&\a\u36cf", // 㛏
	0x36d0: "&\a\u36d0", // 㛐
	0x36d1: "&\a\u36d1", // 㛑
	0x36d2: "&\a\u36d2", // 㛒
	0x36d3: "&\a\u36d3", // 㛓
	0x36d4: "&\a\u36d4", // 㛔
	0x36d5: "&\a\u36d5", // 㛕
	0x36d6: "&\a\u36d6", // 㛖
	0x36d7: "&\a\u36d7", // 㛗
	0x36d8: "&\a\u36d8", // 㛘
	0x36d9: "&\a\u36d9", // 㛙
	0x36da: "&\a\u36da", // 㛚
	0x36db: "&\a\u36db", // 㛛
	0x36dc: "&\a\u36dc", // 㛜
	0x36dd: "&\a\u36dd", // 㛝
	0x36de: "&\a\u36de", // 㛞
	0x36df: "&\a\u36df", // 㛟
	0x36e0: "&\x04\u36e0", // 㛠
	0x36e1: "&\a\u36e1", // 㛡
	0x36e2: "&\a\u36e2", // 㛢
	0x36e3: "&\a\u36e3", // 㛣
	0x36e4: "&\a\u36e4", // 㛤
	0x36e5: "&\b\u36e5", // 㛥
	0x36e6: "&\b\u36e6", // 㛦
	0x36e7: "&\b\u36e7", // 㛧
	0x36e8: "&\b\u36e8", // 㛨
	0x36e9: "&\b\u36e9", // 㛩
	0x36ea: "&\b\u36ea", // 㛪
	0x36eb: "&\b\u36eb", // 㛫
	0x36ec: "&\b\u36ec", // 㛬
	0x36ed: "&\b\u36ed", // 㛭
	0x36ee: "&\t\u36ee", // 㛮
	0x36ef: "&\t\u36ef", // 㛯
	0x36f0: "&\t\u36f0", // 㛰
	0x36f1: "&\t\u36f1", // 㛱
	0x36f2: "&\t\u36f2", // 㛲
	0x36f3: "&\t\u36f3", // 㛳
	0x36f4: "&\t\u36f4", // 㛴
	0x36f5: "&\t\u36f5", // 㛵
	0x36f6: "&\t\u36f6", // 㛶
	0x36f7: "&\t\u36f7", // 㛷
	0x36f8: "&\t\u36f8", // 㛸
	0x36f9: "&\t\u36f9", // 㛹
	0x36fa: "&\t\u36fa", // 㛺
	0x36fb: "&\t\u36fb", // 㛻
	0x36fc: "&\t\u36fc", // 㛼
	0x36fd: "&\t\u36fd", // 㛽
	0x36fe: "&\t\u36fe", // 㛾
	0x36ff: "&\t\u36ff", // 㛿
	0x3700: "&\t\u3700", // 㜀
	0x3701: "&\t\u3701", // 㜁
	0x3702: "&\t\u3702", // 㜂
	0x3703: "&\t\u3703", // 㜃
	0x3704: "&\t\u3704", // 㜄
	0x3705: "&\n\u3705", // 㜅
	0x3706: "&\n\u3706", // 㜆
	0x3707: "&\n\u3707", // 㜇
	0x3708: "&\n\u3708", // 㜈
	0x3709: "&\n\u3709", // 㜉
	0x370a: "&\n\u370a", // 㜊
	0x370b: "&\n\u370b", // 㜋
	0x370c: "&\n\u370c", // 㜌
	0x370d: "&\n\u370d", // 㜍
	0x370e: "&\n\u370e", // 㜎
	0x370f: "&\n\u370f", // 㜏
	0x3710: "&\n\u3710", // 㜐
	0x3711: "&\n\u3711", // 㜑
	0x3712: "&\n\u3712", // 㜒
	0x3713: "&\n\u3713", // 㜓
	0x3714: "&\n\u3714", // 㜔
	0x3715: "&\v\u3715", // 㜕
	0x3716: "&\v\u3716", // 㜖
	0x3717: "&\v\u3717", // 㜗
	0x3718: "&\v\u3718", // 㜘
	0x3719: "&\v\u3719", // 㜙
	0x371a: "&\v\u371a", // 㜚
	0x371b: "&\v\u371b", // 㜛
	0x371c: "&\v\u371c", // 㜜
	0x371d: "&\v\u371d", // 㜝
	0x371e: "&\v\u371e", // 㜞
	0x371f: "&\v\u371f", // 㜟
	0x3720: "&\v\u3720", // 㜠
	0x3721: "&\v\u3721", // 㜡
	0x3722: "&\v\u3722", // 㜢
	0x3723: "&\f\u3723", // 㜣
	0x3724: "&\f\u3724", // 㜤
	0x3725: "&\f\u3725", // 㜥
	0x3726: "&\f\u3726", // 㜦
	0x3727: "&\f\u3727", // 㜧
	0x3728: "&\f\u3728", // 㜨
	0x3729: "&\r\u3729", // 㜩
	0x372a: "&\r\u372a", // 㜪
	0x372b: "&\r\u372b", // 㜫
	0x372c: "&\r\u372c", // 㜬
	0x372d: "&\r\u372d", // 㜭
	0x372e: "&\x0e\u372e", // 㜮
	0x372f: "&\x0e\u372f", // 㜯
	0x3730: "&\x0f\u3730", // 㜰
	0x3731: "&\x0f\u3731", // 㜱
	0x3732: "&\x10\u3732", // 㜲
	0x3733: "&\x10\u3733", // 㜳
	0x3734: "&\x10\u3734", // 㜴
	0x3735: "&\x10\u3735", // 㜵
	0x3736: "&\x11\u3736", // 㜶
	0x3737: "&\x11\u3737", // 㜷
	0x3738: "&\x11\u3738", // 㜸
	0x3739: "&\x12\u3739", // 㜹
	0x373a: "&\x13\u373a", // 㜺
	0x373b: "&\x17\u373b", // 㜻
	0x373c: "&\x17\u373c", // 㜼
	0x373d: "'\x03\u373d", // 㜽
	0x373e: "'\x04\u373e", // 㜾
	0x373f: "'\x04\u373f", // 㜿
	0x3740: "'\x05\u3740", // 㝀
	0x3741: "'\x06\u3741", // 㝁
	0x3742: "'\a\u3742", // 㝂
	0x3743: "'\a\u3743", // 㝃
	0x3744: "'\t\u3744", // 㝄
	0x3745: "'\n\u3745", // 㝅
	0x3746: "'\f\u3746", // 㝆
	0x3747: "'\r\u3747", // 㝇
	0x3748: "'\x16\u3748", // 㝈
	0x3749: "(\x01\u3749", // 㝉
	0x374a: "(\x02\u374a", // 㝊
	0x374b: "(\x02\u374b", // 㝋
	0x374c: "(\x03\u374c", // 㝌
	0x374d: "(\x03\u374d", // 㝍
	0x374e: "(\x04\u374e", // 㝎
	0x374f: "(\x04\u374f", // 㝏
	0x3750: "(\x04\u3750", // 㝐
	0x3751: "(\x04\u3751", // 㝑
	0x3752: "(\x05\u3752", // 㝒
	0x3753: "(\x06\u3753", // 㝓
	0x3754: "(\x06\u3754", // 㝔
	0x3755: "(\x06\u3755", // 㝕
	0x3756: "(\x06\u3756", // 㝖
	0x3757: "(\a\u3757", // 㝗
	0x3758: "(\a\u3758", // 㝘
	0x3759: "(\a\u3759", // 㝙
	0x375a: "(\a\u375a", // 㝚
	0x375b: "(\b\u375b", // 㝛
	0x375c: "(\b\u375c", // 㝜
	0x375d: "(\b\u375d", // 㝝
	0x375e: "(\b\u375e", // 㝞
	0x375f: "(\b\u375f", // 㝟
	0x3760: "(\b\u3760", // 㝠
	0x3761: "(\b\u3761", // 㝡
	0x3762: "(\t\u3762", // 㝢
	0x3763: "(\t\u3763", // 㝣
	0x3764: "(\n\u3764", // 㝤
	0x3765: "(\n\u3765", // 㝥
	0x3766: "(\n\u3766", // 㝦
	0x3767: "(\n\u3767", // 㝧
	0x3768: "(\n\u3768", // 㝨
	0x3769: "(\v\u3769", // 㝩
	0x376a: "(\v\u376a", // 㝪
	0x376b: "(\v\u376b", // 㝫
	0x376c: "(\v\u376c", // 㝬
	0x376d: "(\f\u376d", // 㝭
	0x376e: "(\f\u376e", // 㝮
	0x376f: "(\f\u376f", // 㝯
	0x3770: "(\x0f\u3770", // 㝰
	0x3771: "(\x12\u3771", // 㝱
	0x3772: "(\x17\u3772", // 㝲
	0x3773: ")\x02\u3773", // 㝳
	0x3774: ")\x04\u3774", // 㝴
	0x3775: ")\x05\u3775", // 㝵
	0x3776: ")\a\u3776", // 㝶
	0x3777: ")\t\u3777", // 㝷
	0x3778: "*\a\u3778", // 㝸
	0x3779: "*\t\u3779", // 㝹
	0x377a: "*\v\u377a", // 㝺
	0x377b: "*\f\u377b", // 㝻
	0x377c: "+\x03\u377c", // 㝼
	0x377d: "+\x04\u377d", // 㝽
	0x377e: "+\x05\u377e", // 㝾
	0x377f: "+\x05\u377f", // 㝿
	0x3780: "+\x06\u3780", // 㞀
	0x3781: "+\x06\u3781", // 㞁
	0x3782: "+\a\u3782", // 㞂
	0x3783: "+\b\u3783", // 㞃
	0x3784: "+\b\u3784", // 㞄
	0x3785: "+\b\u3785", // 㞅
	0x3786: "+\b\u3786", // 㞆
	0x3787: "+\t\u3787", // 㞇
	0x3788: "+\t\u3788", // 㞈
	0x3789: "+\n\u3789", // 㞉
	0x378a: "+\n\u378a", // 㞊
	0x378b: ",\x02\u378b", // 㞋
	0x378c: ",\x03\u378c", // 㞌
	0x378d: ",\x03\u378d", // 㞍
	0x378e: ",\x04\u378e", // 㞎
	0x378f: ",\x05\u378f", // 㞏
	0x3790: ",\x05\u3790", // 㞐
	0x3791: ",\x05\u3791", // 㞑
	0x3792: ",\x06\u3792", // 㞒
	0x3793: ",\x06\u3793", // 㞓
	0x3794: ",\x06\u3794", // 㞔
	0x3795: ",\x06\u3795", // 㞕
	0x3796: ",\x06\u3796", // 㞖
	0x3797: ",\a\u3797", // 㞗
	0x3798: ",\b\u3798", // 㞘
	0x3799: ",\b\u3799", // 㞙
	0x379a: ",\t\u379a", // 㞚
	0x379b: ",\t\u379b", // 㞛
	0x379c: ",\v\u379c", // 㞜
	0x379d: ",\v\u379d", // 㞝
	0x379e: ",\v\u379e", // 㞞
	0x379f: ",\f\u379f", // 㞟
	0x37a0: ",\f\u37a0", // 㞠
	0x37a1: ",\x10\u37a1", // 㞡
	0x37a2: "-\x01\u37a2", // 㞢
	0x37a3: "-\x04\u37a3", // 㞣
	0x37a4: ".\x02\u37a4", // 㞤
	0x37a5: ".\x02\u37a5", // 㞥
	0x37a6: ".\x02\u37a6", // 㞦
	0x37a7: ".\x02\u37a7", // 㞧
	0x37a8: ".\x03\u37a8", // 㞨
	0x37a9: ".\x03\u37a9", // 㞩
	0x37aa: ".\x03\u37aa", // 㞪
	0x37ab: ".\x03\u37ab", // 㞫
	0x37ac: ".\x03\u37ac", // 㞬
	0x37ad: ".\x03\u37ad", // 㞭
	0x37ae: ".\x03\u37ae", // 㞮
	0x37af: ".\x03\u37af", // 㞯
	0x37b0: ".\x04\u37b0", // 㞰
	0x37b1: ".\x04\u37b1", // 㞱
	0x37b2: ".\x04\u37b2", // 㞲
	0x37b3: ".\x04\u37b3", // 㞳
	0x37b4: ".\x04\u37b4", // 㞴
	0x37b5: ".\x04\u37b5", // 㞵
	0x37b6: ".\x04\u37b6", // 㞶
	0x37b7: "-\x04\u37b7", // 㞷
	0x37b8: ".\x04\u37b8", // 㞸
	0x37b9: ".\x05\u37b9", // 㞹
	0x37ba: ".\x05\u37ba", // 㞺
	0x37bb: ".\x05\u37bb", // 㞻
	0x37bc: ".\x05\u37bc", // 㞼
	0x37bd: ".\x05\u37bd", // 㞽
	0x37be: ".\x05\u37be", // 㞾
	0x37bf: ".\x05\u37bf", // 㞿
	0x37c0: ".\x05\u37c0", // 㟀
	0x37c1: ".\x05\u37c1", // 㟁
	0x37c2: ".\x05\u37c2", // 㟂
	0x37c3: ".\x05\u37c3", // 㟃
	0x37c4: ".\x06\u37c4", // 㟄
	0x37c5: ".\x06\u37c5", // 㟅
	0x37c6: ".\x06\u37c6", // 㟆
	0x37c7: ".\a\u37c7", // 㟇
	0x37c8: ".\a\u37c8", // 㟈
	0x37c9: ".\a\u37c9", // 㟉
	0x37ca: ".\a\u37ca", // 㟊
	0x37cb: ".\a\u37cb", // 㟋
	0x37cc: ".\a\u37cc", // 㟌
	0x37cd: ".\a\u37cd", // 㟍
	0x37ce: ".\a\u37ce", // 㟎
	0x37cf: ".\a\u37cf", // 㟏
	0x37d0: ".\a\u37d0", // 㟐
	0x37d1: ".\a\u37d1", // 㟑
	0x37d2: ".\a\u37d2", // 㟒
	0x37d3: ".\a\u37d3", // 㟓
	0x37d4: ".\a\u37d4", // 㟔
	0x37d5: ".\a\u37d5", // 㟕
	0x37d6: ".\a\u37d6", // 㟖
	0x37d7: ".\b\u37d7", // 㟗
	0x37d8: ".\b\u37d8", // 㟘
	0x37d9: ".\b\u37d9", // 㟙
	0x37da: ".\b\u37da", // 㟚
	0x37db: ".\b\u37db", // 㟛
	0x37dc: ".\b\u37dc", // 㟜
	0x37dd: ".\b\u37dd", // 㟝
	0x37de: ".\b\u37de", // 㟞
	0x37df: ".\b\u37df", // 㟟
	0x37e0: ".\b\u37e0", // 㟠
	0x37e1: ".\b\u37e1", // 㟡
	0x37e2: ".\b\u37e2", // 㟢
	0x37e3: ".\b\u37e3", // 㟣
	0x37e4: ".\b\u37e4", // 㟤
	0x37e5: ".\b\u37e5", // 㟥
	0x37e6: ".\t\u37e6", // 㟦
	0x37e7: ".\t\u37e7", // 㟧
	0x37e8: ".\t\u37e8", // 㟨
	0x37e9: ".\t\u37e9", // 㟩
	0x37ea: ".\t\u37ea", // 㟪
	0x37eb: ".\t\u37eb", // 㟫
	0x37ec: ".\t\u37ec", // 㟬
	0x37ed: ".\t\u37ed", // 㟭
	0x37ee: ".\t\u37ee", // 㟮
	0x37ef: ".\t\u37ef", // 㟯
	0x37f0: ".\n\u37f0", // 㟰
	0x37f1: ".\n\u37f1", // 㟱
	0x37f2: ".\n\u37f2", // 㟲
	0x37f3: ".\n\u37f3", // 㟳
	0x37f4: ".\n\u37f4", // 㟴
	0x37f5: ".\n\u37f5", // 㟵
	0x37f6: ".\n\u37f6", // 㟶
	0x37f7: ".\n\u37f7", // 㟷
	0x37f8: ".\n\u37f8", // 㟸
	0x37f9: ".\v\u37f9", // 㟹
	0x37fa: ".\v\u37fa", // 㟺
	0x37fb: ".\v\u37fb", // 㟻
	0x37fc: ".\v\u37fc", // 㟼
	0x37fd: ".\v\u37fd", // 㟽
	0x37fe: ".\v\u37fe", // 㟾
	0x37ff: ".\v\u37ff", // 㟿
	0x3800: ".\v\u3800", // 㠀
	0x3801: ".\v\u3801", // 㠁
	0x3802: ".\v\u3802", // 㠂
	0x3803: ".\v\u3803", // 㠃
	0x3804: ".\v\u3804", // 㠄
	0x3805: ".\f\u3805", // 㠅
	0x3806: ".\f\u3806", // 㠆
	0x3807: ".\f\u3807", // 㠇
	0x3808: ".\f\u3808", // 㠈
	0x3809: ".\f\u3809", // 㠉
	0x380a: ".\f\u380a", // 㠊
	0x380b: ".\f\u380b", // 㠋
	0x380c: ".\f\u380c", // 㠌
	0x380d: ".\f\u380d", // 㠍
	0x380e: ".\f\u380e", // 㠎
	0x380f: ".\f\u380f", // 㠏
	0x3810: ".\f\u3810", // 㠐
	0x3811: ".\r\u3811", // 㠑
	0x3812: ".\r\u3812", // 㠒
	0x3813: ".\r\u3813", // 㠓
	0x3814: ".\r\u3814", // 㠔
	0x3815: ".\r\u3815", // 㠕
	0x3816: ".\r\u3816", // 㠖
	0x3817: ".\r\u3817", // 㠗
	0x3818: ".\x0e\u3818", // 㠘
	0x3819: ".\x0e\u3819", // 㠙
	0x381a: ".\x0e\u381a", // 㠚
	0x381b: ".\x0e\u381b", // 㠛
	0x381c: ".\x0e\u381c", // 㠜
	0x381d: ".\x0f\u381d", // 㠝
	0x381e: ".\x0f\u381e", // 㠞
	0x381f: ".\x0f\u381f", // 㠟
	0x3820: ".\x10\u3820", // 㠠
	0x3821: ".\x10\u3821", // 㠡
	0x3822: ".\x10\u3822", // 㠢
	0x3823: ".\x10\u3823", // 㠣
	0x3824: ".\x11\u3824", // 㠤
	0x3825: ".\x12\u3825", // 㠥
	0x3826: ".\x12\u3826", // 㠦
	0x3827: ".\x13\u3827", // 㠧
	0x3828: ".\x19\u3828", // 㠨
	0x3829: "/\x03\u3829", // 㠩
	0x382a: "0\x01\u382a", // 㠪
	0x382b: "0\a\u382b", // 㠫
	0x382c: "0\a\u382c", // 㠬
	0x382d: "0\t\u382d", // 㠭
	0x382e: "0\f\u382e", // 㠮
	0x382f: "1\x02\u382f", // 㠯
	0x3830: "1\x05\u3830", // 㠰
	0x3831: "1\b\u3831", // 㠱
	0x3832: "2\x02\u3832", // 㠲
	0x3833: "2\x02\u3833", // 㠳
	0x3834: "2\x03\u3834", // 㠴
	0x3835: "2\x03\u3835", // 㠵
	0x3836: "2\x03\u3836", // 㠶
	0x3837: "2\x04\u3837", // 㠷
	0x3838: "2\x04\u3838", // 㠸
	0x3839: "2\x04\u3839", // 㠹
	0x383a: "2\x04\u383a", // 㠺
	0x383b: "2\x04\u383b", // 㠻
	0x383c: "2\x04\u383c", // 㠼
	0x383d: "2\x05\u383d", // 㠽
	0x383e: "2\x05\u383e", // 㠾
	0x383f: "2\x05\u383f", // 㠿
	0x3840: "2\x05\u3840", // 㡀
	0x3841: "2\x06\u3841", // 㡁
	0x3842: "2\x06\u3842", // 㡂
	0x3843: "2\x06\u3843", // 㡃
	0x3844: "2\x06\u3844", // 㡄
	0x3845: "2\x06\u3845", // 㡅
	0x3846: "2\x06\u3846", // 㡆
	0x3847: "2\a\u3847", // 㡇
	0x3848: "2\a\u3848", // 㡈
	0x3849: "2\b\u3849", // 㡉
	0x384a: "2\b\u384a", // 㡊
	0x384b: "2\b\u384b", // 㡋
	0x384c: "2\b\u384c", // 㡌
	0x384d: "2\b\u384d", // 㡍
	0x384e: "2\b\u384e", // 㡎
	0x384f: "2\t\u384f", // 㡏
	0x3850: "2\t\u3850", // 㡐
	0x3851: "2\t\u3851", // 㡑
	0x3852: "2\t\u3852", // 㡒
	0x3853: "2\t\u3853", // 㡓
	0x3854: "2\t\u3854", // 㡔
	0x3855: "2\t\u3855", // 㡕
	0x3856: "2\t\u3856", // 㡖
	0x3857: "2\n\u3857", // 㡗
	0x3858: "2\n\u3858", // 㡘
	0x3859: "2\n\u3859", // 㡙
	0x385a: "2\n\u385a", // 㡚
	0x385b: "2\n\u385b", // 㡛
	0x385c: "2\v\u385c", // 㡜
	0x385d: "2\v\u385d", // 㡝
	0x385e: "2\v\u385e", // 㡞
	0x385f: "2\v\u385f", // 㡟
	0x3860: "2\f\u3860", // 㡠
	0x3861: "2\f\u3861", // 㡡
	0x3862: "2\r\u3862", // 㡢
	0x3863: "2\r\u3863", // 㡣
	0x3864: "2\r\u3864", // 㡤
	0x3865: "2\x0e\u3865", // 㡥
	0x3866: "2\x0e\u3866", // 㡦
	0x3867: "2\x11\u3867", // 㡧
	0x3868: "2\x11\u3868", // 㡨
	0x3869: "2\x13\u3869", // 㡩
	0x386a: "2\x13\u386a", // 㡪
	0x386b: "4\t\u386b", // 㡫
	0x386c: "4\t\u386c", // 㡬
	0x386d: "4\v\u386d", // 㡭
	0x386e: "4\r\u386e", // 㡮
	0x386f: "5\x03\u386f", // 㡯
	0x3870: "5\x03\u3870", // 㡰
	0x3871: "5\x03\u3871", // 㡱
	0x3872: "5\x04\u3872", // 㡲
	0x3873: "5\x04\u3873", // 㡳
	0x3874: "5\x05\u3874", // 㡴
	0x3875: "5\x05\u3875", // 㡵
	0x3876: "5\x05\u3876", // 㡶
	0x3877: "5\x05\u3877", // 㡷
	0x3878: "5\x05\u3878", // 㡸
	0x3879: "5\x05\u3879", // 㡹
	0x387a: "5\x05\u387a", // 㡺
	0x387b: "5\x05\u387b", // 㡻
	0x387c: "5\x06\u387c", // 㡼
	0x387d: "5\x06\u387d", // 㡽
	0x387e: "5\x06\u387e", // 㡾
	0x387f: "5\x06\u387f", // 㡿
	0x3880: "5\x06\u3880", // 㢀
	0x3881: "5\x06\u3881", // 㢁
	0x3882: "5\x06\u3882", // 㢂
	0x3883: "5\a\u3883", // 㢃
	0x3884: "5\a\u3884", // 㢄
	0x3885: "5\a\u3885", // 㢅
	0x3886: "5\a\u3886", // 㢆
	0x3887: "5\a\u3887", // 㢇
	0x3888: "5\b\u3888", // 㢈
	0x3889: "5\b\u3889", // 㢉
	0x388a: "5\b\u388a", // 㢊
	0x388b: "5\b\u388b", // 㢋
	0x388c: "5\b\u388c", // 㢌
	0x388d: "5\t\u388d", // 㢍
	0x388e: "5\t\u388e", // 㢎
	0x388f: "5\t\u388f", // 㢏
	0x3890: "5\t\u3890", // 㢐
	0x3891: "5\n\u3891", // 㢑
	0x3892: "5\v\u3892", // 㢒
	0x3893: "5\v\u3893", // 㢓
	0x3894: "5\v\u3894", // 㢔
	0x3895: "5\v\u3895", // 㢕
	0x3896: "5\f\u3896", // 㢖
	0x3897: "5\f\u3897", // 㢗
	0x3898: "5\f\u3898", // 㢘
	0x3899: "5\r\u3899", // 㢙
	0x389a: "5\r\u389a", // 㢚
	0x389b: "5\r\u389b", // 㢛
	0x389c: "5\r\u389c", // 㢜
	0x389d: "5\x10\u389d", // 㢝
	0x389e: "5\x11\u389e", // 㢞
	0x389f: "6\x03\u389f", // 㢟
	0x38a0: "6\x05\u38a0", // 㢠
	0x38a1: "7\v\u38a1", // 㢡
	0x38a2: "7\f\u38a2", // 㢢
	0x38a3: "7\r\u38a3", // 㢣
	0x38a4: "8\x04\u38a4", // 㢤
	0x38a5: "8\x06\u38a5", // 㢥
	0x38a6: "8\n\u38a6", // 㢦
	0x38a7: "9\x01\u38a7", // 㢧
	0x38a8: "9\x03\u38a8", // 㢨
	0x38a9: "9\x03\u38a9", // 㢩
	0x38aa: "9\x03\u38aa", // 㢪
	0x38ab: "9\x03\u38ab", // 㢫
	0x38ac: "9\x04\u38ac", // 㢬
	0x38ad: "9\x04\u38ad", // 㢭
	0x38ae: "9\x05\u38ae", // 㢮
	0x38af: "9\x05\u38af", // 㢯
	0x38b0: "9\x05\u38b0", // 㢰
	0x38b1: "9\x05\u38b1", // 㢱
	0x38b2: "9\x06\u38b2", // 㢲
	0x38b3: "9\x06\u38b3", // 㢳
	0x38b4: "9\x06\u38b4", // 㢴
	0x38b5: "9\x06\u38b5", // 㢵
	0x38b6: "9\x06\u38b6", // 㢶
	0x38b7: "9\x06\u38b7", // 㢷
	0x38b8: "9\a\u38b8", // 㢸
	0x38b9: "9\a\u38b9", // 㢹
	0x38ba: "9\b\u38ba", // 㢺
	0x38bb: "9\b\u38bb", // 㢻
	0x38bc: "9\b\u38bc", // 㢼
	0x38bd: "9\t\u38bd", // 㢽
	0x38be: "9\t\u38be", // 㢾
	0x38bf: "9\t\u38bf", // 㢿
	0x38c0: "9\n\u38c0", // 㣀
	0x38c1: "9\n\u38c1", // 㣁
	0x38c2: "9\n\u38c2", // 㣂
	0x38c3: "9\v\u38c3", // 㣃
	0x38c4: "9\f\u38c4", // 㣄
	0x38c5: "9\f\u38c5", // 㣅
	0x38c6: "9\x12\u38c6", // 㣆
	0x38c7: ":\x05\u38c7", // 㣇
	0x38c8: ":\r\u38c8", // 㣈
	0x38c9: ";\x03\u38c9", // 㣉
	0x38ca: ";\x04\u38ca", // 㣊
	0x38cb: ";\x05\u38cb", // 㣋
	0x38cc: ";\x05\u38cc", // 㣌
	0x38cd: ";\x05\u38cd", // 㣍
	0x38ce: ";\b\u38ce", // 㣎
	0x38cf: ";\t\u38cf", // 㣏
	0x38d0: ";\t\u38d0", // 㣐
	0x38d1: ";\v\u38d1", // 㣑
	0x38d2: ";\f\u38d2", // 㣒
	0x38d3: ";\r\u38d3", // 㣓
	0x38d4: "<\x02\u38d4", // 㣔
	0x38d5: "<\x03\u38d5", // 㣕
	0x38d6: "<\x04\u38d6", // 㣖
	0x38d7: "<\x04\u38d7", // 㣗
	0x38d8: "<\x05\u38d8", // 㣘
	0x38d9: "<\x05\u38d9", // 㣙
	0x38da: "<\x06\u38da", // 㣚
	0x38db: "<\x06\u38db", // 㣛
	0x38dc: "<\x06\u38dc", // 㣜
	0x38dd: "<\x06\u38dd", // 㣝
	0x38de: "<\x06\u38de", // 㣞
	0x38df: "<\x06\u38df", // 㣟
	0x38e0: "<\x06\u38e0", // 㣠
	0x38e1: "<\x06\u38e1", // 㣡
	0x38e2: "<\a\u38e2", // 㣢
	0x38e3: "<\a\u38e3", // 㣣
	0x38e4: "<\b\u38e4", // 㣤
	0x38e5: "<\b\u38e5", // 㣥
	0x38e6: "<\b\u38e6", // 㣦
	0x38e7: "<\b\u38e7", // 㣧
	0x38e8: "<\b\u38e8", // 㣨
	0x38e9: "<\b\u38e9", // 㣩
	0x38ea: "<\t\u38ea", // 㣪
	0x38eb: "<\t\u38eb", // 㣫
	0x38ec: "<\t\u38ec", // 㣬
	0x38ed: "<\t\u38ed", // 㣭
	0x38ee: "<\t\u38ee", // 㣮
	0x38ef: "<\n\u38ef", // 㣯
	0x38f0: "<\v\u38f0", // 㣰
	0x38f1: "<\v\u38f1", // 㣱
	0x38f2: "<\v\u38f2", // 㣲
	0x38f3: "<\f\u38f3", // 㣳
	0x38f4: "<\f\u38f4", // 㣴
	0x38f5: "<\r\u38f5", // 㣵
	0x38f6: "<\r\u38f6", // 㣶
	0x38f7: "<\x0e\u38f7", // 㣷
	0x38f8: "<\x10\u38f8", // 㣸
	0x38f9: "<\x11\u38f9", // 㣹
	0x38fa: "=\x01\u38fa", // 㣺
	0x38fb: "=\x02\u38fb", // 㣻
	0x38fc: "=\x03\u38fc", // 㣼
	0x38fd: "=\x03\u38fd", // 㣽
	0x38fe: "=\x03\u38fe", // 㣾
	0x38ff: "=\x03\u38ff", // 㣿
	0x3900: "=\x03\u3900", // 㤀
	0x3901: "=\x04\u3901", // 㤁
	0x3902: "=\x04\u3902", // 㤂
	0x3903: "=\x04\u3903", // 㤃
	0x3904: "=\x04\u3904", // 㤄
	0x3905: "=\x04\u3905", // 㤅
	0x3906: "=\x04\u3906", // 㤆
	0x3907: "=\x04\u3907", // 㤇
	0x3908: "=\x04\u3908", // 㤈
	0x3909: "=\x04\u3909", // 㤉
	0x390a: "=\x04\u390a", // 㤊
	0x390b: "=\x04\u390b", // 㤋
	0x390c: "=\x05\u390c", // 㤌
	0x390d: "=\x05\u390d", // 㤍
	0x390e: "=\x05\u390e", // 㤎
	0x390f: "=\x05\u390f", // 㤏
	0x3910: "=\x05\u3910", // 㤐
	0x3911: "=\x05\u3911", // 㤑
	0x3912: "=\x05\u3912", // 㤒
	0x3913: "=\x05\u3913", // 㤓
	0x3914: "=\x05\u3914", // 㤔
	0x3915: "=\x05\u3915", // 㤕
	0x3916: "=\x05\u3916", // 㤖
	0x3917: "=\x05\u3917", // 㤗
	0x3918: "=\x05\u3918", // 㤘
	0x3919: "=\x05\u3919", // 㤙
	0x391a: "=\x06\u391a", // 㤚
	0x391b: "=\x06\u391b", // 㤛
	0x391c: "=\x06\u391c", // 㤜
	0x391d: "=\x06\u391d", // 㤝
	0x391e: "=\x06\u391e", // 㤞
	0x391f: "=\x06\u391f", // 㤟
	0x3920: "=\x06\u3920", // 㤠
	0x3921: "=\x06\u3921", // 㤡
	0x3922: "=\x06\u3922", // 㤢
	0x3923: "=\x06\u3923", // 㤣
	0x3924: "=\x06\u3924", // 㤤
	0x3925: "=\x06\u3925", // 㤥
	0x3926: "=\x06\u3926", // 㤦
	0x3927: "=\x06\u3927", // 㤧
	0x3928: "=\x06\u3928", // 㤨
	0x3929: "=\x06\u3929", // 㤩
	0x392a: "=\x06\u392a", // 㤪
	0x392b: "=\x06\u392b", // 㤫
	0x392c: "=\x06\u392c", // 㤬
	0x392d: "=\x06\u392d", // 㤭
	0x392e: "=\a\u392e", // 㤮
	0x392f: "=\a\u392f", // 㤯
	0x3930: "=\a\u3930", // 㤰
	0x3931: "=\a\u3931", // 㤱
	0x3932: "=\a\u3932", // 㤲
	0x3933: "=\a\u3933", // 㤳
	0x3934: "=\a\u3934", // 㤴
	0x3935: "=\a\u3935", // 㤵
	0x3936: "=\a\u3936", // 㤶
	0x3937: "=\a\u3937", // 㤷
	0x3938: "=\a\u3938", // 㤸
	0x3939: "=\a\u3939", // 㤹
	0x393a: "=\x06\u393a", // 㤺
	0x393b: "=\a\u393b", // 㤻
	0x393c: "=\a\u393c", // 㤼
	0x393d: "=\a\u393d", // 㤽
	0x393e: "=\b\u393e", // 㤾
	0x393f: "=\b\u393f", // 㤿
	0x3940: "=\b\u3940", // 㥀
	0x3941: "=\b\u3941", // 㥁
	0x3942: "=\b\u3942", // 㥂
	0x3943: "=\b\u3943", // 㥃
	0x3944: "=\b\u3944", // 㥄
	0x3945: "=\b\u3945", // 㥅
	0x3946: "=\b\u3946", // 㥆
	0x3947: "=\b\u3947", // 㥇
	0x3948: "=\b\u3948", // 㥈
	0x3949: "=\b\u3949", // 㥉
	0x394a: "=\b\u394a", // 㥊
	0x394b: "=\b\u394b", // 㥋
	0x394c: "=\b\u394c", // 㥌
	0x394d: "=\b\u394d", // 㥍
	0x394e: "=\b\u394e", // 㥎
	0x394f: "=\b\u394f", // 㥏
	0x3950: "=\b\u3950", // 㥐
	0x3951: "=\b\u3951", // 㥑
	0x3952: "=\b\u3952", // 㥒
	0x3953: "=\b\u3953", // 㥓
	0x3954: "=\b\u3954", // 㥔
	0x3955: "=\b\u3955", // 㥕
	0x3956: "=\b\u3956", // 㥖
	0x3957: "=\b\u3957", // 㥗
	0x3958: "=\b\u3958", // 㥘
	0x3959: "=\b\u3959", // 㥙
	0x395a: "=\t\u395a", // 㥚
	0x395b: "=\t\u395b", // 㥛
	0x395c: "=\t\u395c", // 㥜
	0x395d: "=\t\u395d", // 㥝
	0x395e: "=\t\u395e", // 㥞
	0x395f: "=\t\u395f", // 㥟
	0x3960: "=\t\u3960", // 㥠
	0x3961: "=\t\u3961", // 㥡
	0x3962: "=\t\u3962", // 㥢
	0x3963: "=\t\u3963", // 㥣
	0x3964: "=\t\u3964", // 㥤
	0x3965: "=\t\u3965", // 㥥
	0x3966: "=\t\u3966", // 㥦
	0x3967: "=\t\u3967", // 㥧
	0x3968: "=\t\u3968", // 㥨
	0x3969: "=\t\u3969", // 㥩
	0x396a: "=\t\u396a", // 㥪
	0x396b: "=\t\u396b", // 㥫
	0x396c: "=\n\u396c", // 㥬
	0x396d: "=\n\u396d", // 㥭
	0x396e: "=\n\u396e", // 㥮
	0x396f: "=\n\u396f", // 㥯
	0x3970: "=\n\u3970", // 㥰
	0x3971: "=\n\u3971", // 㥱
	0x3972: "=\n\u3972", // 㥲
	0x3973: "=\n\u3973", // 㥳
	0x3974: "=\n\u3974", // 㥴
	0x3975: "=\n\u3975", // 㥵
	0x3976: "=\n\u3976", // 㥶
	0x3977: "=\n\u3977", // 㥷
	0x3978: "=\n\u3978", // 㥸
	0x3979: "=\n\u3979", // 㥹
	0x397a: "=\n\u397a", // 㥺
	0x397b: "=\n\u397b", // 㥻
	0x397c: "=\v\u397c", // 㥼
	0x397d: "=\v\u397d", // 㥽
	0x397e: "=\v\u397e", // 㥾
	0x397f: "=\v\u397f", // 㥿
	0x3980: "=\v\u3980", // 㦀
	0x3981: "=\v\u3981", // 㦁
	0x3982: "=\v\u3982", // 㦂
	0x3983: "=\v\u3983", // 㦃
	0x3984: "=\v\u3984", // 㦄
	0x3985: "=\v\u3985", // 㦅
	0x3986: "=\v\u3986", // 㦆
	0x3987: "=\v\u3987", // 㦇
	0x3988: "=\v\u3988", // 㦈
	0x3989: "=\f\u3989", // 㦉
	0x398a: "=\f\u398a", // 㦊
	0x398b: "=\f\u398b", // 㦋
	0x398c: "=\f\u398c", // 㦌
	0x398d: "=\f\u398d", // 㦍
	0x398e: "=\f\u398e", // 㦎
	0x398f: "=\f\u398f", // 㦏
	0x3990: "=\f\u3990", // 㦐
	0x3991: "=\f\u3991", // 㦑
	0x3992: "=\f\u3992", // 㦒
	0x3993: "=\f\u3993", // 㦓
	0x3994: "=\f\u3994", // 㦔
	0x3995: "=\f\u3995", // 㦕
	0x3996: "=\f\u3996", // 㦖
	0x3997: "=\r\u3997", // 㦗
	0x3998: "=\r\u3998", // 㦘
	0x3999: "=\r\u3999", // 㦙
	0x399a: "=\x0e\u399a", // 㦚
	0x399b: "=\x0e\u399b", // 㦛
	0x399c: "=\x0e\u399c", // 㦜
	0x399d: "=\x0e\u399d", // 㦝
	0x399e: "=\x0e\u399e", // 㦞
	0x399f: "=\x0e\u399f", // 㦟
	0x39a0: "=\x0e\u39a0", // 㦠
	0x39a1: "=\x0f\u39a1", // 㦡
	0x39a2: "=\x0f\u39a2", // 㦢
	0x39a3: "=\x10\u39a3", // 㦣
	0x39a4: "=\x10\u39a4", // 㦤
	0x39a5: "=\x10\u39a5", // 㦥
	0x39a6: "=\x10\u39a6", // 㦦
	0x39a7: "=\x10\u39a7", // 㦧
	0x39a8: "=\x11\u39a8", // 㦨
	0x39a9: "=\x11\u39a9", // 㦩
	0x39aa: "=\x11\u39aa", // 㦪
	0x39ab: "=\x13\u39ab", // 㦫
	0x39ac: "=\x13\u39ac", // 㦬
	0x39ad: "=\x18\u39ad", // 㦭
	0x39ae: ">\x03\u39ae", // 㦮
	0x39af: ">\x03\u39af", // 㦯
	0x39b0: ">\x04\u39b0", // 㦰
	0x39b1: ">\x04\u39b1", // 㦱
	0x39b2: ">\x04\u39b2", // 㦲
	0x39b3: ">\x05\u39b3", // 㦳
	0x39b4: ">\x06\u39b4", // 㦴
	0x39b5: ">\x06\u39b5", // 㦵
	0x39b6: ">\x06\u39b6", // 㦶
	0x39b7: ">\a\u39b7", // 㦷
	0x39b8: ">\b\u39b8", // 㦸
	0x39b9: ">\t\u39b9", // 㦹
	0x39ba: ">\n\u39ba", // 㦺
	0x39bb: ">\v\u39bb", // 㦻
	0x39bc: ">\v\u39bc", // 㦼
	0x39bd: ">\r\u39bd", // 㦽
	0x39be: "?\x03\u39be", // 㦾
	0x39bf: "?\x04\u39bf", // 㦿
	0x39c0: "?\x04\u39c0", // 㧀
	0x39c1: "?\x05\u39c1", // 㧁
	0x39c2: "?\x05\u39c2", // 㧂
	0x39c3: "@\x02\u39c3", // 㧃
	0x39c4: "@\x02\u39c4", // 㧄
	0x39c5: "@\x02\u39c5", // 㧅
	0x39c6: "@\x03\u39c6", // 㧆
	0x39c7: "@\x03\u39c7", // 㧇
	0x39c8: "@\x03\u39c8", // 㧈
	0x39c9: "@\x04\u39c9", // 㧉
	0x39ca: "@\x04\u39ca", // 㧊
	0x39cb: "@\x04\u39cb", // 㧋
	0x39cc: "@\x04\u39cc", // 㧌
	0x39cd: "@\x04\u39cd", // 㧍
	0x39ce: "@\x04\u39ce", // 㧎
	0x39cf: "@\x04\u39cf", // 㧏
	0x39d0: "@\x04\u39d0", // 㧐
	0x39d1: "@\x04\u39d1", // 㧑
	0x39d2: "@\x05\u39d2", // 㧒
	0x39d3: "@\x05\u39d3", // 㧓
	0x39d4: "@\x05\u39d4", // 㧔
	0x39d5: "@\x05\u39d5", // 㧕
	0x39d6: "@\x05\u39d6", // 㧖
	0x39d7: "@\x05\u39d7", // 㧗
	0x39d8: "@\x05\u39d8", // 㧘
	0x39d9: "@\x05\u39d9", // 㧙
	0x39da: "@\x05\u39da", // 㧚
	0x39db: "@\x05\u39db", // 㧛
	0x39dc: "@\x05\u39dc", // 㧜
	0x39dd: "@\x05\u39dd", // 㧝
	0x39de: "@\x05\u39de", // 㧞
	0x39df: "@\x05\u39df", // 㧟
	0x39e0: "@\x05\u39e0", // 㧠
	0x39e1: "@\x06\u39e1", // 㧡
	0x39e2: "@\x06\u39e2", // 㧢
	0x39e3: "@\x06\u39e3", // 㧣
	0x39e4: "@\x06\u39e4", // 㧤
	0x39e5: "@\x06\u39e5", // 㧥
	0x39e6: "@\x06\u39e6", // 㧦
	0x39e7: "@\x06\u39e7", // 㧧
	0x39e8: "@\x06\u39e8", // 㧨
	0x39e9: "@\x06\u39e9", // 㧩
	0x39ea: "@\x06\u39ea", // 㧪
	0x39eb: "@\x06\u39eb", // 㧫
	0x39ec: "@\x06\u39ec", // 㧬
	0x39ed: "@\x06\u39ed", // 㧭
	0x39ee: "@\x06\u39ee", // 㧮
	0x39ef: "@\x06\u39ef", // 㧯
	0x39f0: "@\x06\u39f0", // 㧰
	0x39f1: "@\x06\u39f1", // 㧱
	0x39f2: "@\a\u39f2", // 㧲
	0x39f3: "@\a\u39f3", // 㧳
	0x39f4: "@\a\u39f4", // 㧴
	0x39f5: "@\a\u39f5", // 㧵
	0x39f6: "@\a\u39f6", // 㧶
	0x39f7: "@\a\u39f7", // 㧷
	0x39f8: "@\a\u39f8", // 㧸
	0x39f9: "@\b\u39f9", // 㧹
	0x39fa: "@\b\u39fa", // 㧺
	0x39fb: "@\b\u39fb", // 㧻
	0x39fc: "@\b\u39fc", // 㧼
	0x39fd: "@\b\u39fd", // 㧽
	0x39fe: "@\b\u39fe", // 㧾
	0x39ff: "@\b\u39ff", // 㧿
	0x3a00: "@\b\u3a00", // 㨀
	0x3a01: "@\b\u3a01", // 㨁
	0x3a02: "@\b\u3a02", // 㨂
	0x3a03: "@\b\u3a03", // 㨃
	0x3a04: "@\b\u3a04", // 㨄
	0x3a05: "@\b\u3a05", // 㨅
	0x3a06: "@\b\u3a06", // 㨆
	0x3a07: "@\b\u3a07", // 㨇
	0x3a08: "@\b\u3a08", // 㨈
	0x3a09: "@\t\u3a09", // 㨉
	0x3a0a: "@\t\u3a0a", // 㨊
	0x3a0b: "@\t\u3a0b", // 㨋
	0x3a0c: "@\t\u3a0c", // 㨌
	0x3a0d: "@\t\u3a0d", // 㨍
	0x3a0e: "@\t\u3a0e", // 㨎
	0x3a0f: "@\t\u3a0f", // 㨏
	0x3a10: "@\t\u3a10", // 㨐
	0x3a11: "@\t\u3a11", // 㨑
	0x3a12: "@\t\u3a12", // 㨒
	0x3a13: "@\t\u3a13", // 㨓
	0x3a14: "@\t\u3a14", // 㨔
	0x3a15: "@\t\u3a15", // 㨕
	0x3a16: "@\n\u3a16", // 㨖
	0x3a17: "@\t\u3a17", // 㨗
	0x3a18: "@\t\u3a18", // 㨘
	0x3a19: "@\n\u3a19", // 㨙
	0x3a1a: "@\n\u3a1a", // 㨚
	0x3a1b: "@\n\u3a1b", // 㨛
	0x3a1c: "@\n\u3a1c", // 㨜
	0x3a1d: "@\n\u3a1d", // 㨝
	0x3a1e: "@\n\u3a1e", // 㨞
	0x3a1f: "@\n\u3a1f", // 㨟
	0x3a20: "@\n\u3a20", // 㨠
	0x3a21: "@\n\u3a21", // 㨡
	0x3a22: "@\n\u3a22", // 㨢
	0x3a23: "@\n\u3a23", // 㨣
	0x3a24: "@\n\u3a24", // 㨤
	0x3a25: "@\n\u3a25", // 㨥
	0x3a26: "@\n\u3a26", // 㨦
	0x3a27: "@\n\u3a27", // 㨧
	0x3a28: "@\n\u3a28", // 㨨
	0x3a29: "@\n\u3a29", // 㨩
	0x3a2a: "@\n\u3a2a", // 㨪
	0x3a2b: "@\n\u3a2b", // 㨫
	0x3a2c: "@\n\u3a2c", // 㨬
	0x3a2d: "@\v\u3a2d", // 㨭
	0x3a2e: "@\v\u3a2e", // 㨮
	0x3a2f: "@\v\u3a2f", // 㨯
	0x3a30: "@\v\u3a30", // 㨰
	0x3a31: "@\v\u3a31", // 㨱
	0x3a32: "@\v\u3a32", // 㨲
	0x3a33: "@\v\u3a33", // 㨳
	0x3a34: "@\v\u3a34", // 㨴
	0x3a35: "@\v\u3a35", // 㨵
	0x3a36: "@\v\u3a36", // 㨶
	0x3a37: "@\v\u3a37", // 㨷
	0x3a38: "@\v\u3a38", // 㨸
	0x3a39: "@\v\u3a39", // 㨹
	0x3a3a: "@\v\u3a3a", // 㨺
	0x3a3b: "@\v\u3a3b", // 㨻
	0x3a3c: "@\v\u3a3c", // 㨼
	0x3a3d: "@\v\u3a3d", // 㨽
	0x3a3e: "@\v\u3a3e", // 㨾
	0x3a3f: "@\v\u3a3f", // 㨿
	0x3a40: "@\v\u3a40", // 㩀
	0x3a41: "@\v\u3a41", // 㩁
	0x3a42: "@\v\u3a42", // 㩂
	0x3a43: "@\f\u3a43", // 㩃
	0x3a44: "@\f\u3a44", // 㩄
	0x3a45: "@\f\u3a45", // 㩅
	0x3a46: "@\f\u3a46", // 㩆
	0x3a47: "@\f\u3a47", // 㩇
	0x3a48: "@\f\u3a48", // 㩈
	0x3a49: "@\f\u3a49", // 㩉
	0x3a4a: "@\f\u3a4a", // 㩊
	0x3a4b: "@\f\u3a4b", // 㩋
	0x3a4c: "@\f\u3a4c", // 㩌
	0x3a4d: "@\f\u3a4d", // 㩍
	0x3a4e: "@\f\u3a4e", // 㩎
	0x3a4f: "@\f\u3a4f", // 㩏
	0x3a50: "@\f\u3a50", // 㩐
	0x3a51: "@\f\u3a51", // 㩑
	0x3a52: "@\r\u3a52", // 㩒
	0x3a53: "@\r\u3a53", // 㩓
	0x3a54: "@\r\u3a54", // 㩔
	0x3a55: "@\r\u3a55", // 㩕
	0x3a56: "@\r\u3a56", // 㩖
	0x3a57: "@\r\u3a57", // 㩗
	0x3a58: "@\r\u3a58", // 㩘
	0x3a59: "@\r\u3a59", // 㩙
	0x3a5a: "@\x0e\u3a5a", // 㩚
	0x3a5b: "@\x0e\u3a5b", // 㩛
	0x3a5c: "@\x0e\u3a5c", // 㩜
	0x3a5d: "@\x0e\u3a5d", // 㩝
	0x3a5e: "@\x0e\u3a5e", // 㩞
	0x3a5f: "@\x0e\u3a5f", // 㩟
	0x3a60: "@\x0f\u3a60", // 㩠
	0x3a61: "@\x0f\u3a61", // 㩡
	0x3a62: "@\x0f\u3a62", // 㩢
	0x3a63: "@\x0f\u3a63", // 㩣
	0x3a64: "@\x0f\u3a64", // 㩤
	0x3a65: "@\x0f\u3a65", // 㩥
	0x3a66: "@\x0f\u3a66", // 㩦
	0x3a67: "@\x0f\u3a67", // 㩧
	0x3a68: "@\x0f\u3a68", // 㩨
	0x3a69: "@\x0f\u3a69", // 㩩
	0x3a6a: "@\x0f\u3a6a", // 㩪
	0x3a6b: "@\x0f\u3a6b", // 㩫
	0x3a6c: "@\x10\u3a6c", // 㩬
	0x3a6d: "@\x10\u3a6d", // 㩭
	0x3a6e: "@\x11\u3a6e", // 㩮
	0x3a6f: "@\x11\u3a6f", // 㩯
	0x3a70: "@\x11\u3a70", // 㩰
	0x3a71: "@\x12\u3a71", // 㩱
	0x3a72: "@\x12\u3a72", // 㩲
	0x3a73: "@\x12\u3a73", // 㩳
	0x3a74: "@\x12\u3a74", // 㩴
	0x3a75: "@\x14\u3a75", // 㩵
	0x3a76: "@\x14\u3a76", // 㩶
	0x3a77: "@\x14\u3a77", // 㩷
	0x3a78: "@\x16\u3a78", // 㩸
	0x3a79: "@\x16\u3a79", // 㩹
	0x3a7a: "A\x04\u3a7a", // 㩺
	0x3a7b: "A\x06\u3a7b", // 㩻
	0x3a7c: "A\x06\u3a7c", // 㩼
	0x3a7d: "A\a\u3a7d", // 㩽
	0x3a7e: "A\b\u3a7e", // 㩾
	0x3a7f: "B\x03\u3a7f", // 㩿
	0x3a80: "B\x03\u3a80", // 㪀
	0x3a81: "B\x04\u3a81", // 㪁
	0x3a82: "B\x04\u3a82", // 㪂
	0x3a83: "B\x05\u3a83", // 㪃
	0x3a84: "B\x05\u3a84", // 㪄
	0x3a85: "B\x05\u3a85", // 㪅
	0x3a86: "B\x05\u3a86", // 㪆
	0x3a87: "B\x06\u3a87", // 㪇
	0x3a88: "B\x06\u3a88", // 㪈
	0x3a89: "B\x06\u3a89", // 㪉
	0x3a8a: "B\a\u3a8a", // 㪊
	0x3a8b: "B\a\u3a8b", // 㪋
	0x3a8c: "B\a\u3a8c", // 㪌
	0x3a8d: "B\a\u3a8d", // 㪍
	0x3a8e: "B\a\u3a8e", // 㪎
	0x3a8f: "B\b\u3a8f", // 㪏
	0x3a90: "B\b\u3a90", // 㪐
	0x3a91: "B\b\u3a91", // 㪑
	0x3a92: "B\b\u3a92", // 㪒
	0x3a93: "B\b\u3a93", // 㪓
	0x3a94: "B\b\u3a94", // 㪔
	0x3a95: "B\b\u3a95", // 㪕
	0x3a96: "B\b\u3a96", // 㪖
	0x3a97: "B\b\u3a97", // 㪗
	0x3a98: "B\b\u3a98", // 㪘
	0x3a99: "B\b\u3a99", // 㪙
	0x3a9a: "B\b\u3a9a", // 㪚
	0x3a9b: "B\t\u3a9b", // 㪛
	0x3a9c: "B\t\u3a9c", // 㪜
	0x3a9d: "B\t\u3a9d", // 㪝
	0x3a9e: "B\t\u3a9e", // 㪞
	0x3a9f: "B\t\u3a9f", // 㪟
	0x3aa0: "B\n\u3aa0", // 㪠
	0x3aa1: "B\n\u3aa1", // 㪡
	0x3aa2: "B\n\u3aa2", // 㪢
	0x3aa3: "B\n\u3aa3", // 㪣
	0x3aa4: "B\v\u3aa4", // 㪤
	0x3aa5: "B\v\u3aa5", // 㪥
	0x3aa6: "B\v\u3aa6", // 㪦
	0x3aa7: "B\f\u3aa7", // 㪧
	0x3aa8: "B\f\u3aa8", // 㪨
	0x3aa9: "B\f\u3aa9", // 㪩
	0x3aaa: "B\f\u3aaa", // 㪪
	0x3aab: "B\x0e\u3aab", // 㪫
	0x3aac: "B\x0e\u3aac", // 㪬
	0x3aad: "B\x10\u3aad", // 㪭
	0x3aae: "B\x11\u3aae", // 㪮
	0x3aaf: "C\x03\u3aaf", // 㪯
	0x3ab0: "C\x06\u3ab0", // 㪰
	0x3ab1: "C\t\u3ab1", // 㪱
	0x3ab2: "D\x02\u3ab2", // 㪲
	0x3ab3: "D\x02\u3ab3", // 㪳
	0x3ab4: "D\x04\u3ab4", // 㪴
	0x3ab5: "D\x05\u3ab5", // 㪵
	0x3ab6: "D\x06\u3ab6", // 㪶
	0x3ab7: "D\a\u3ab7", // 㪷
	0x3ab8: "D\b\u3ab8", // 㪸
	0x3ab9: "D\v\u3ab9", // 㪹
	0x3aba: "D\r\u3aba", // 㪺
	0x3abb: "D\x13\u3abb", // 㪻
	0x3abc: "E\x05\u3abc", // 㪼
	0x3abd: "E\x05\u3abd", // 㪽
	0x3abe: "E\x06\u3abe", // 㪾
	0x3abf: "E\x06\u3abf", // 㪿
	0x3ac0: "E\b\u3ac0", // 㫀
	0x3ac1: "E\n\u3ac1", // 㫁
	0x3ac2: "E\v\u3ac2", // 㫂
	0x3ac3: "F\x02\u3ac3", // 㫃
	0x3ac4: "F\x04\u3ac4", // 㫄
	0x3ac5: "F\x06\u3ac5", // 㫅
	0x3ac6: "F\x05\u3ac6", // 㫆
	0x3ac7: "F\x06\u3ac7", // 㫇
	0x3ac8: "F\x06\u3ac8", // 㫈
	0x3ac9: "F\x06\u3ac9", // 㫉
	0x3aca: "F\a\u3aca", // 㫊
	0x3acb: "F\a\u3acb", // 㫋
	0x3acc: "F\a\u3acc", // 㫌
	0x3acd: "F\b\u3acd", // 㫍
	0x3ace: "F\v\u3ace", // 㫎
	0x3acf: "F\v\u3acf", // 㫏
	0x3ad0: "H\x02\u3ad0", // 㫐
	0x3ad1: "H\x02\u3ad1", // 㫑
	0x3ad2: "H\x03\u3ad2", // 㫒
	0x3ad3: "H\x03\u3ad3", // 㫓
	0x3ad4: "H\x03\u3ad4", // 㫔
	0x3ad5: "H\x03\u3ad5", // 㫕
	0x3ad6: "H\x03\u3ad6", // 㫖
	0x3ad7: "H\x03\u3ad7", // 㫗
	0x3ad8: "H\x04\u3ad8", // 㫘
	0x3ad9: "H\x04\u3ad9", // 㫙
	0x3ada: "H\x04\u3ada", // 㫚
	0x3adb: "H\x05\u3adb", // 㫛
	0x3adc: "H\x05\u3adc", // 㫜
	0x3add: "H\x05\u3add", // 㫝
	0x3ade: "H\x05\u3ade", // 㫞
	0x3adf: "H\x05\u3adf", // 㫟
	0x3ae0: "H\x05\u3ae0", // 㫠
	0x3ae1: "H\x05\u3ae1", // 㫡
	0x3ae2: "H\x05\u3ae2", // 㫢
	0x3ae3: "H\x05\u3ae3", // 㫣
	0x3ae4: "H\x05\u3ae4", // 㫤
	0x3ae5: "H\x06\u3ae5", // 㫥
	0x3ae6: "H\x06\u3ae6", // 㫦
	0x3ae7: "H\x06\u3ae7", // 㫧
	0x3ae8: "H\x06\u3ae8", // 㫨
	0x3ae9: "H\x06\u3ae9", // 㫩
	0x3aea: "H\x06\u3aea", // 㫪
	0x3aeb: "H\x06\u3aeb", // 㫫
	0x3aec: "H\x06\u3aec", // 㫬
	0x3aed: "H\x06\u3aed", // 㫭
	0x3aee: "H\x06\u3aee", // 㫮
	0x3aef: "H\a\u3aef", // 㫯
	0x3af0: "H\a\u3af0", // 㫰
	0x3af1: "H\a\u3af1", // 㫱
	0x3af2: "H\a\u3af2", // 㫲
	0x3af3: "H\a\u3af3", // 㫳
	0x3af4: "H\a\u3af4", // 㫴
	0x3af5: "H\b\u3af5", // 㫵
	0x3af6: "H\b\u3af6", // 㫶
	0x3af7: "H\b\u3af7", // 㫷
	0x3af8: "H\b\u3af8", // 㫸
	0x3af9: "H\b\u3af9", // 㫹
	0x3afa: "H\b\u3afa", // 㫺
	0x3afb: "H\b\u3afb", // 㫻
	0x3afc: "H\b\u3afc", // 㫼
	0x3afd: "H\b\u3afd", // 㫽
	0x3afe: "H\b\u3afe", // 㫾
	0x3aff: "H\b\u3aff", // 㫿
	0x3b00: "H\b\u3b00", // 㬀
	0x3b01: "H\t\u3b01", // 㬁
	0x3b02: "H\t\u3b02", // 㬂
	0x3b03: "H\t\u3b03", // 㬃
	0x3b04: "H\t\u3b04", // 㬄
	0x3b05: "H\t\u3b05", // 㬅
	0x3b06: "H\t\u3b06", // 㬆
	0x3b07: "H\t\u3b07", // 㬇
	0x3b08: "H\t\u3b08", // 㬈
	0x3b09: "H\t\u3b09", // 㬉
	0x3b0a: "H\t\u3b0a", // 㬊
	0x3b0b: "H\t\u3b0b", // 㬋
	0x3b0c: "H\t\u3b0c", // 㬌
	0x3b0d: "H\n\u3b0d", // 㬍
	0x3b0e: "H\n\u3b0e", // 㬎
	0x3b0f: "H\n\u3b0f", // 㬏
	0x3b10: "H\n\u3b10", // 㬐
	0x3b11: "H\v\u3b11", // 㬑
	0x3b12: "H\v\u3b12", // 㬒
	0x3b13: "H\v\u3b13", // 㬓
	0x3b14: "H\v\u3b14", // 㬔
	0x3b15: "H\v\u3b15", // 㬕
	0x3b16: "H\v\u3b16", // 㬖
	0x3b17: "H\f\u3b17", // 㬗
	0x3b18: "H\f\u3b18", // 㬘
	0x3b19: "H\f\u3b19", // 㬙
	0x3b1a: "H\f\u3b1a", // 㬚
	0x3b1b: "H\f\u3b1b", // 㬛
	0x3b1c: "H\f\u3b1c", // 㬜
	0x3b1d: "H\f\u3b1d", // 㬝
	0x3b1e: "H\f\u3b1e", // 㬞
	0x3b1f: "H\f\u3b1f", // 㬟
	0x3b20: "H\r\u3b20", // 㬠
	0x3b21: "H\r\u3b21", // 㬡
	0x3b22: "H\r\u3b22", // 㬢
	0x3b23: "H\x0e\u3b23", // 㬣
	0x3b24: "H\x0e\u3b24", // 㬤
	0x3b25: "H\x0e\u3b25", // 㬥
	0x3b26: "H\x0e\u3b26", // 㬦
	0x3b27: "H\x0e\u3b27", // 㬧
	0x3b28: "H\x0e\u3b28", // 㬨
	0x3b29: "H\x0f\u3b29", // 㬩
	0x3b2a: "H\x0f\u3b2a", // 㬪
	0x3b2b: "H\x10\u3b2b", // 㬫
	0x3b2c: "H\x12\u3b2c", // 㬬
	0x3b2d: "H\x12\u3b2d", // 㬭
	0x3b2e: "H\x13\u3b2e", // 㬮
	0x3b2f: "H\x15\u3b2f", // 㬯
	0x3b30: "I\x02\u3b30", // 㬰
	0x3b31: "I\f\u3b31", // 㬱
	0x3b32: "I\r\u3b32", // 㬲
	0x3b33: "J\x04\u3b33", // 㬳
	0x3b34: "J\x06\u3b34", // 㬴
	0x3b35: "J\x06\u3b35", // 㬵
	0x3b36: "J\a\u3b36", // 㬶
	0x3b37: "J\a\u3b37", // 㬷
	0x3b38: "J\b\u3b38", // 㬸
	0x3b39: "\x82\b\u3b39", // 㬹
	0x3b3a: "J\n\u3b3a", // 㬺
	0x3b3b: "J\n\u3b3b", // 㬻
	0x3b3c: "J\v\u3b3c", // 㬼
	0x3b3d: "J\v\u3b3d", // 㬽
	0x3b3e: "J\v\u3b3e", // 㬾
	0x3b3f: "J\f\u3b3f", // 㬿
	0x3b40: "J\r\u3b40", // 㭀
	0x3b41: "K\x02\u3b41", // 㭁
	0x3b42: "K\x03\u3b42", // 㭂
	0x3b43: "K\x03\u3b43", // 㭃
	0x3b44: "K\x03\u3b44", // 㭄
	0x3b45: "K\x03\u3b45", // 㭅
	0x3b46: "K\x03\u3b46", // 㭆
	0x3b47: "K\x04\u3b47", // 㭇
	0x3b48: "K\x04\u3b48", // 㭈
	0x3b49: "K\x04\u3b49", // 㭉
	0x3b4a: "K\x04\u3b4a", // 㭊
	0x3b4b: "K\x04\u3b4b", // 㭋
	0x3b4c: "K\x04\u3b4c", // 㭌
	0x3b4d: "K\x04\u3b4d", // 㭍
	0x3b4e: "K\x04\u3b4e", // 㭎
	0x3b4f: "K\x04\u3b4f", // 㭏
	0x3b50: "K\x04\u3b50", // 㭐
	0x3b51: "K\x05\u3b51", // 㭑
	0x3b52: "K\x05\u3b52", // 㭒
	0x3b53: "K\x05\u3b53", // 㭓
	0x3b54: "K\x05\u3b54", // 㭔
	0x3b55: "K\x05\u3b55", // 㭕
	0x3b56: "K\x05\u3b56", // 㭖
	0x3b57: "K\x05\u3b57", // 㭗
	0x3b58: "K\x06\u3b58", // 㭘
	0x3b59: "K\x06\u3b59", // 㭙
	0x3b5a: "K\x06\u3b5a", // 㭚
	0x3b5b: "K\x06\u3b5b", // 㭛
	0x3b5c: "K\x06\u3b5c", // 㭜
	0x3b5d: "K\x06\u3b5d", // 㭝
	0x3b5e: "K\x06\u3b5e", // 㭞
	0x3b5f: "K\x06\u3b5f", // 㭟
	0x3b60: "K\x06\u3b60", // 㭠
	0x3b61: "K\x06\u3b61", // 㭡
	0x3b62: "K\x06\u3b62", // 㭢
	0x3b63: "K\x06\u3b63", // 㭣
	0x3b64: "K\x06\u3b64", // 㭤
	0x3b65: "K\x06\u3b65", // 㭥
	0x3b66: "K\x06\u3b66", // 㭦
	0x3b67: "K\x06\u3b67", // 㭧
	0x3b68: "K\a\u3b68", // 㭨
	0x3b69: "K\a\u3b69", // 㭩
	0x3b6a: "K\a\u3b6a", // 㭪
	0x3b6b: "K\a\u3b6b", // 㭫
	0x3b6c: "K\a\u3b6c", // 㭬
	0x3b6d: "K\a\u3b6d", // 㭭
	0x3b6e: "K\a\u3b6e", // 㭮
	0x3b6f: "K\a\u3b6f", // 㭯
	0x3b70: "K\a\u3b70", // 㭰
	0x3b71: "K\a\u3b71", // 㭱
	0x3b72: "K\a\u3b72", // 㭲
	0x3b73: "K\a\u3b73", // 㭳
	0x3b74: "K\a\u3b74", // 㭴
	0x3b75: "K\a\u3b75", // 㭵
	0x3b76: "K\b\u3b76", // 㭶
	0x3b77: "K\a\u3b77", // 㭷
	0x3b78: "K\b\u3b78", // 㭸
	0x3b79: "K\b\u3b79", // 㭹
	0x3b7a: "K\b\u3b7a", // 㭺
	0x3b7b: "K\b\u3b7b", // 㭻
	0x3b7c: "K\b\u3b7c", // 㭼
	0x3b7d: "K\b\u3b7d", // 㭽
	0x3b7e: "K\b\u3b7e", // 㭾
	0x3b7f: "K\b\u3b7f", // 㭿
	0x3b80: "K\b\u3b80", // 㮀
	0x3b81: "K\b\u3b81", // 㮁
	0x3b82: "K\b\u3b82", // 㮂
	0x3b83: "K\b\u3b83", // 㮃
	0x3b84: "K\b\u3b84", // 㮄
	0x3b85: "K\b\u3b85", // 㮅
	0x3b86: "K\b\u3b86", // 㮆
	0x3b87: "K\b\u3b87", // 㮇
	0x3b88: "K\b\u3b88", // 㮈
	0x3b89: "K\b\u3b89", // 㮉
	0x3b8a: "K\b\u3b8a", // 㮊
	0x3b8b: "K\t\u3b8b", // 㮋
	0x3b8c: "K\t\u3b8c", // 㮌
	0x3b8d: "K\t\u3b8d", // 㮍
	0x3b8e: "K\t\u3b8e", // 㮎
	0x3b8f: "K\t\u3b8f", // 㮏
	0x3b90: "K\t\u3b90", // 㮐
	0x3b91: "K\t\u3b91", // 㮑
	0x3b92: "K\t\u3b92", // 㮒
	0x3b93: "K\t\u3b93", // 㮓
	0x3b94: "K\t\u3b94", // 㮔
	0x3b95: "K\t\u3b95", // 㮕
	0x3b96: "K\t\u3b96", // 㮖
	0x3b97: "K\t\u3b97", // 㮗
	0x3b98: "K\t\u3b98", // 㮘
	0x3b99: "K\t\u3b99", // 㮙
	0x3b9a: "K\t\u3b9a", // 㮚
	0x3b9b: "K\t\u3b9b", // 㮛
	0x3b9c: "K\t\u3b9c", // 㮜
	0x3b9d: "K\t\u3b9d", // 㮝
	0x3b9e: "K\t\u3b9e", // 㮞
	0x3b9f: "K\t\u3b9f", // 㮟
	0x3ba0: "K\t\u3ba0", // 㮠
	0x3ba1: "V\t\u3ba1", // 㮡
	0x3ba2: "K\t\u3ba2", // 㮢
	0x3ba3: "K\t\u3ba3", // 㮣
	0x3ba4: "K\n\u3ba4", // 㮤
	0x3ba5: "K\n\u3ba5", // 㮥
	0x3ba6: "K\n\u3ba6", // 㮦
	0x3ba7: "K\n\u3ba7", // 㮧
	0x3ba8: "K\n\u3ba8", // 㮨
	0x3ba9: "K\n\u3ba9", // 㮩
	0x3baa: "K\n\u3baa", // 㮪
	0x3bab: "K\n\u3bab", // 㮫
	0x3bac: "K\n\u3bac", // 㮬
	0x3bad: "K\n\u3bad", // 㮭
	0x3bae: "K\n\u3bae", // 㮮
	0x3baf: "K\n\u3baf", // 㮯
	0x3bb0: "K\n\u3bb0", // 㮰
	0x3bb1: "K\n\u3bb1", // 㮱
	0x3bb2: "K\n\u3bb2", // 㮲
	0x3bb3: "K\n\u3bb3", // 㮳
	0x3bb4: "K\n\u3bb4", // 㮴
	0x3bb5: "K\n\u3bb5", // 㮵
	0x3bb6: "K\n\u3bb6", // 㮶
	0x3bb7: "K\n\u3bb7", // 㮷
	0x3bb8: "K\n\u3bb8", // 㮸
	0x3bb9: "K\n\u3bb9", // 㮹
	0x3bba: "K\n\u3bba", // 㮺
	0x3bbb: "K\n\u3bbb", // 㮻
	0x3bbc: "K\n\u3bbc", // 㮼
	0x3bbd: "K\n\u3bbd", // 㮽
	0x3bbe: "K\v\u3bbe", // 㮾
	0x3bbf: "K\v\u3bbf", // 㮿
	0x3bc0: "K\v\u3bc0", // 㯀
	0x3bc1: "K\v\u3bc1", // 㯁
	0x3bc2: "K\v\u3bc2", // 㯂
	0x3bc3: "K\v\u3bc3", // 㯃
	0x3bc4: "K\v\u3bc4", // 㯄
	0x3bc5: "K\v\u3bc5", // 㯅
	0x3bc6: "K\v\u3bc6", // 㯆
	0x3bc7: "K\v\u3bc7", // 㯇
	0x3bc8: "K\v\u3bc8", // 㯈
	0x3bc9: "K\v\u3bc9", // 㯉
	0x3bca: "K\v\u3bca", // 㯊
	0x3bcb: "K\v\u3bcb", // 㯋
	0x3bcc: "K\v\u3bcc", // 㯌
	0x3bcd: "K\v\u3bcd", // 㯍
	0x3bce: "K\v\u3bce", // 㯎
	0x3bcf: "K\v\u3bcf", // 㯏
	0x3bd0: "K\f\u3bd0", // 㯐
	0x3bd1: "K\v\u3bd1", // 㯑
	0x3bd2: "K\v\u3bd2", // 㯒
	0x3bd3: "K\f\u3bd3", // 㯓
	0x3bd4: "K\f\u3bd4", // 㯔
	0x3bd5: "K\f\u3bd5", // 㯕
	0x3bd6: "K\f\u3bd6", // 㯖
	0x3bd7: "K\f\u3bd7", // 㯗
	0x3bd8: "K\f\u3bd8", // 㯘
	0x3bd9: "K\f\u3bd9", // 㯙
	0x3bda: "K\f\u3bda", // 㯚
	0x3bdb: "K\f\u3bdb", // 㯛
	0x3bdc: "K\f\u3bdc", // 㯜
	0x3bdd: "K\f\u3bdd", // 㯝
	0x3bde: "K\f\u3bde", // 㯞
	0x3bdf: "K\f\u3bdf", // 㯟
	0x3be0: "K\v\u3be0", // 㯠
	0x3be1: "K\f\u3be1", // 㯡
	0x3be2: "K\f\u3be2", // 㯢
	0x3be3: "K\f\u3be3", // 㯣
	0x3be4: "K\f\u3be4", // 㯤
	0x3be5: "K\f\u3be5", // 㯥
	0x3be6: "K\f\u3be6", // 㯦
	0x3be7: "K\f\u3be7", // 㯧
	0x3be8: "K\f\u3be8", // 㯨
	0x3be9: "K\f\u3be9", // 㯩
	0x3bea: "K\r\u3bea", // 㯪
	0x3beb: "K\r\u3beb", // 㯫
	0x3bec: "K\r\u3bec", // 㯬
	0x3bed: "K\r\u3bed", // 㯭
	0x3bee: "K\r\u3bee", // 㯮
	0x3bef: "K\r\u3bef", // 㯯
	0x3bf0: "K\r\u3bf0", // 㯰
	0x3bf1: "K\r\u3bf1", // 㯱
	0x3bf2: "K\r\u3bf2", // 㯲
	0x3bf3: "K\r\u3bf3", // 㯳
	0x3bf4: "K\r\u3bf4", // 㯴
	0x3bf5: "K\r\u3bf5", // 㯵
	0x3bf6: "K\r\u3bf6", // 㯶
	0x3bf7: "K\x0e\u3bf7", // 㯷
	0x3bf8: "K\x0e\u3bf8", // 㯸
	0x3bf9: "K\x0e\u3bf9", // 㯹
	0x3bfa: "K\x0e\u3bfa", // 㯺
	0x3bfb: "K\x0e\u3bfb", // 㯻
	0x3bfc: "K\x0e\u3bfc", // 㯼
	0x3bfd: "K\x0e\u3bfd", // 㯽
	0x3bfe: "K\x0f\u3bfe", // 㯾
	0x3bff: "K\x0f\u3bff", // 㯿
	0x3c00: "K\x0f\u3c00", // 㰀
	0x3c01: "K\x0f\u3c01", // 㰁
	0x3c02: "K\x0f\u3c02", // 㰂
	0x3c03: "K\x0f\u3c03", // 㰃
	0x3c04: "K\x0f\u3c04", // 㰄
	0x3c05: "K\x0f\u3c05", // 㰅
	0x3c06: "K\x0f\u3c06", // 㰆
	0x3c07: "K\x0f\u3c07", // 㰇
	0x3c08: "K\x0f\u3c08", // 㰈
	0x3c09: "K\x10\u3c09", // 㰉
	0x3c0a: "K\x10\u3c0a", // 㰊
	0x3c0b: "K\x10\u3c0b", // 㰋
	0x3c0c: "K\x10\u3c0c", // 㰌
	0x3c0d: "K\x10\u3c0d", // 㰍
	0x3c0e: "K\x10\u3c0e", // 㰎
	0x3c0f: "K\x10\u3c0f", // 㰏
	0x3c10: "K\x10\u3c10", // 㰐
	0x3c11: "K\x10\u3c11", // 㰑
	0x3c12: "K\x10\u3c12", // 㰒
	0x3c13: "K\x10\u3c13", // 㰓
	0x3c14: "K\x11\u3c14", // 㰔
	0x3c15: "K\x11\u3c15", // 㰕
	0x3c16: "K\x10\u3c16", // 㰖
	0x3c17: "K\x12\u3c17", // 㰗
	0x3c18: "K\x12\u3c18", // 㰘
	0x3c19: "K\x13\u3c19", // 㰙
	0x3c1a: "K\x13\u3c1a", // 㰚
	0x3c1b: "K\x13\u3c1b", // 㰛
	0x3c1c: "K\x13\u3c1c", // 㰜
	0x3c1d: "L\x03\u3c1d", // 㰝
	0x3c1e: "L\x03\u3c1e", // 㰞
	0x3c1f: "L\x04\u3c1f", // 㰟
	0x3c20: "L\x04\u3c20", // 㰠
	0x3c21: "L\x04\u3c21", // 㰡
	0x3c22: "L\x04\u3c22", // 㰢
	0x3c23: "L\x05\u3c23", // 㰣
	0x3c24: "L\x05\u3c24", // 㰤
	0x3c25: "L\x05\u3c25", // 㰥
	0x3c26: "L\x05\u3c26", // 㰦
	0x3c27: "L\x05\u3c27", // 㰧
	0x3c28: "L\x05\u3c28", // 㰨
	0x3c29: "L\x06\u3c29", // 㰩
	0x3c2a: "L\x06\u3c2a", // 㰪
	0x3c2b: "L\x06\u3c2b", // 㰫
	0x3c2c: "L\x06\u3c2c", // 㰬
	0x3c2d: "L\x06\u3c2d", // 㰭
	0x3c2e: "L\a\u3c2e", // 㰮
	0x3c2f: "L\a\u3c2f", // 㰯
	0x3c30: "L\a\u3c30", // 㰰
	0x3c31: "L\a\u3c31", // 㰱
	0x3c32: "L\b\u3c32", // 㰲
	0x3c33: "L\b\u3c33", // 㰳
	0x3c34: "L\b\u3c34", // 㰴
	0x3c35: "L\b\u3c35", // 㰵
	0x3c36: "L\b\u3c36", // 㰶
	0x3c37: "N\x06\u3c37", // 㰷
	0x3c38: "L\b\u3c38", // 㰸
	0x3c39: "L\t\u3c39", // 㰹
	0x3c3a: "L\t\u3c3a", // 㰺
	0x3c3b: "L\t\u3c3b", // 㰻
	0x3c3c: "L\t\u3c3c", // 㰼
	0x3c3d: "L\t\u3c3d", // 㰽
	0x3c3e: "L\t\u3c3e", // 㰾
	0x3c3f: "L\n\u3c3f", // 㰿
	0x3c40: "L\n\u3c40", // 㱀
	0x3c41: "L\n\u3c41", // 㱁
	0x3c42: "L\v\u3c42", // 㱂
	0x3c43: "L\v\u3c43", // 㱃
	0x3c44: "L\f\u3c44", // 㱄
	0x3c45: "L\f\u3c45", // 㱅
	0x3c46: "L\r\u3c46", // 㱆
	0x3c47: "L\r\u3c47", // 㱇
	0x3c48: "L\r\u3c48", // 㱈
	0x3c49: "L\r\u3c49", // 㱉
	0x3c4a: "L\x0f\u3c4a", // 㱊
	0x3c4b: "L\x10\u3c4b", // 㱋
	0x3c4c: "L\x12\u3c4c", // 㱌
	0x3c4d: "L\x13\u3c4d", // 㱍
	0x3c4e: "L\x15\u3c4e", // 㱎
	0x3c4f: "M\x02\u3c4f", // 㱏
	0x3c50: "M\x03\u3c50", // 㱐
	0x3c51: "M\x03\u3c51", // 㱑
	0x3c52: "M\x05\u3c52", // 㱒
	0x3c53: "M\x05\u3c53", // 㱓
	0x3c54: "M\x05\u3c54", // 㱔
	0x3c55: "M\b\u3c55", // 㱕
	0x3c56: "M\b\u3c56", // 㱖
	0x3c57: "M\n\u3c57", // 㱗
	0x3c58: "M\x0e\u3c58", // 㱘
	0x3c59: "N\x02\u3c59", // 㱙
	0x3c5a: "N\x04\u3c5a", // 㱚
	0x3c5b: "N\x04\u3c5b", // 㱛
	0x3c5c: "N\x04\u3c5c", // 㱜
	0x3c5d: "N\x04\u3c5d", // 㱝
	0x3c5e: "N\x05\u3c5e", // 㱞
	0x3c5f: "N\x05\u3c5f", // 㱟
	0x3c60: "N\x05\u3c60", // 㱠
	0x3c61: "N\x06\u3c61", // 㱡
	0x3c62: "N\a\u3c62", // 㱢
	0x3c63: "N\a\u3c63", // 㱣
	0x3c64: "N\b\u3c64", // 㱤
	0x3c65: "N\b\u3c65", // 㱥
	0x3c66: "N\b\u3c66", // 㱦
	0x3c67: "N\b\u3c67", // 㱧
	0x3c68: "N\b\u3c68", // 㱨
	0x3c69: "N\b\u3c69", // 㱩
	0x3c6a: "N\t\u3c6a", // 㱪
	0x3c6b: "N\t\u3c6b", // 㱫
	0x3c6c: "N\t\u3c6c", // 㱬
	0x3c6d: "N\t\u3c6d", // 㱭
	0x3c6e: "N\t\u3c6e", // 㱮
	0x3c6f: "N\n\u3c6f", // 㱯
	0x3c70: "N\n\u3c70", // 㱰
	0x3c71: "N\n\u3c71", // 㱱
	0x3c72: "N\n\u3c72", // 㱲
	0x3c73: "N\v\u3c73", // 㱳
	0x3c74: "N\v\u3c74", // 㱴
	0x3c75: "N\f\u3c75", // 㱵
	0x3c76: "N\f\u3c76", // 㱶
	0x3c77: "N\f\u3c77", // 㱷
	0x3c78: "N\r\u3c78", // 㱸
	0x3c79: "N\x10\u3c79", // 㱹
	0x3c7a: "N\x10\u3c7a", // 㱺
	0x3c7b: "N\x13\u3c7b", // 㱻
	0x3c7c: "O\x03\u3c7c", // 㱼
	0x3c7d: "O\x04\u3c7d", // 㱽
	0x3c7e: "O\x06\u3c7e", // 㱾
	0x3c7f: "O\x06\u3c7f", // 㱿
	0x3c80: "O\a\u3c80", // 㲀
	0x3c81: "O\b\u3c81", // 㲁
	0x3c82: "O\b\u3c82", // 㲂
	0x3c83: "O\b\u3c83", // 㲃
	0x3c84: "O\t\u3c84", // 㲄
	0x3c85: "O\n\u3c85", // 㲅
	0x3c86: "O\f\u3c86", // 㲆
	0x3c87: "O\f\u3c87", // 㲇
	0x3c88: "O\f\u3c88", // 㲈
	0x3c89: "O\r\u3c89", // 㲉
	0x3c8a: "O\x0e\u3c8a", // 㲊
	0x3c8b: "Q\x05\u3c8b", // 㲋
	0x3c8c: "R\x02\u3c8c", // 㲌
	0x3c8d: "R\x04\u3c8d", // 㲍
	0x3c8e: "R\x04\u3c8e", // 㲎
	0x3c8f: "R\x04\u3c8f", // 㲏
	0x3c90: "R\x04\u3c90", // 㲐
	0x3c91: "R\x04\u3c91", // 㲑
	0x3c92: "R\x05\u3c92", // 㲒
	0x3c93: "R\x06\u3c93", // 㲓
	0x3c94: "R\a\u3c94", // 㲔
	0x3c95: "R\a\u3c95", // 㲕
	0x3c96: "R\a\u3c96", // 㲖
	0x3c97: "R\a\u3c97", // 㲗
	0x3c98: "R\a\u3c98", // 㲘
	0x3c99: "R\a\u3c99", // 㲙
	0x3c9a: "R\a\u3c9a", // 㲚
	0x3c9b: "R\b\u3c9b", // 㲛
	0x3c9c: "R\b\u3c9c", // 㲜
	0x3c9d: "R\b\u3c9d", // 㲝
	0x3c9e: "R\b\u3c9e", // 㲞
	0x3c9f: "R\t\u3c9f", // 㲟
	0x3ca0: "R\t\u3ca0", // 㲠
	0x3ca1: "R\t\u3ca1", // 㲡
	0x3ca2: "R\t\u3ca2", // 㲢
	0x3ca3: "R\t\u3ca3", // 㲣
	0x3ca4: "R\n\u3ca4", // 㲤
	0x3ca5: "R\n\u3ca5", // 㲥
	0x3ca6: "R\n\u3ca6", // 㲦
	0x3ca7: "R\n\u3ca7", // 㲧
	0x3ca8: "R\n\u3ca8", // 㲨
	0x3ca9: "R\n\u3ca9", // 㲩
	0x3caa: "R\f\u3caa", // 㲪
	0x3cab: "R\f\u3cab", // 㲫
	0x3cac: "R\f\u3cac", // 㲬
	0x3cad: "R\f\u3cad", // 㲭
	0x3cae: "R\f\u3cae", // 㲮
	0x3caf: "R\x0e\u3caf", // 㲯
	0x3cb0: "R\x0e\u3cb0", // 㲰
	0x3cb1: "R\x0f\u3cb1", // 㲱
	0x3cb2: "R\x16\u3cb2", // 㲲
	0x3cb3: "S\x06\u3cb3", // 㲳
	0x3cb4: "T\x04\u3cb4", // 㲴
	0x3cb5: "T\a\u3cb5", // 㲵
	0x3cb6: "T\v\u3cb6", // 㲶
	0x3cb7: "T\f\u3cb7", // 㲷
	0x3cb8: "U\x01\u3cb8", // 㲸
	0x3cb9: "U\x02\u3cb9", // 㲹
	0x3cba: "U\x02\u3cba", // 㲺
	0x3cbb: "U\x02\u3cbb", // 㲻
	0x3cbc: "U\x02\u3cbc", // 㲼
	0x3cbd: "U\x03\u3cbd", // 㲽
	0x3cbe: "U\x03\u3cbe", // 㲾
	0x3cbf: "U\x03\u3cbf", // 㲿
	0x3cc0: "U\x04\u3cc0", // 㳀
	0x3cc1: "U\x04\u3cc1", // 㳁
	0x3cc2: "U\x04\u3cc2", // 㳂
	0x3cc3: "U\x04\u3cc3", // 㳃
	0x3cc4: "U\x04\u3cc4", // 㳄
	0x3cc5: "U\x04\u3cc5", // 㳅
	0x3cc6: "U\x04\u3cc6", // 㳆
	0x3cc7: "U\x04\u3cc7", // 㳇
	0x3cc8: "U\x04\u3cc8", // 㳈
	0x3cc9: "U\x04\u3cc9", // 㳉
	0x3cca: "U\x04\u3cca", // 㳊
	0x3ccb: "U\x05\u3ccb", // 㳋
	0x3ccc: "U\x05\u3ccc", // 㳌
	0x3ccd: "U\x05\u3ccd", // 㳍
	0x3cce: "U\x05\u3cce", // 㳎
	0x3ccf: "U\x05\u3ccf", // 㳏
	0x3cd0: "U\x05\u3cd0", // 㳐
	0x3cd1: "U\x05\u3cd1", // 㳑
	0x3cd2: "U\x05\u3cd2", // 㳒
	0x3cd3: "U\x05\u3cd3", // 㳓
	0x3cd4: "U\x05\u3cd4", // 㳔
	0x3cd5: "U\x05\u3cd5", // 㳕
	0x3cd6: "U\x06\u3cd6", // 㳖
	0x3cd7: "U\x06\u3cd7", // 㳗
	0x3cd8: "U\x06\u3cd8", // 㳘
	0x3cd9: "U\x06\u3cd9", // 㳙
	0x3cda: "U\x06\u3cda", // 㳚
	0x3cdb: "U\x06\u3cdb", // 㳛
	0x3cdc: "U\x06\u3cdc", // 㳜
	0x3cdd: "U\x06\u3cdd", // 㳝
	0x3cde: "U\x06\u3cde", // 㳞
	0x3cdf: "U\x06\u3cdf", // 㳟
	0x3ce0: "U\x06\u3ce0", // 㳠
	0x3ce1: "U\x06\u3ce1", // 㳡
	0x3ce2: "U\x06\u3ce2", // 㳢
	0x3ce3: "U\x06\u3ce3", // 㳣
	0x3ce4: "U\a\u3ce4", // 㳤
	0x3ce5: "U\a\u3ce5", // 㳥
	0x3ce6: "U\a\u3ce6", // 㳦
	0x3ce7: "U\a\u3ce7", // 㳧
	0x3ce8: "U\a\u3ce8", // 㳨
	0x3ce9: "U\a\u3ce9", // 㳩
	0x3cea: "U\a\u3cea", // 㳪
	0x3ceb: "U\a\u3ceb", // 㳫
	0x3cec: "U\a\u3cec", // 㳬
	0x3ced: "U\a\u3ced", // 㳭
	0x3cee: "U\a\u3cee", // 㳮
	0x3cef: "U\a\u3cef", // 㳯
	0x3cf0: "U\a\u3cf0", // 㳰
	0x3cf1: "U\a\u3cf1", // 㳱
	0x3cf2: "U\a\u3cf2", // 㳲
	0x3cf3: "U\a\u3cf3", // 㳳
	0x3cf4: "U\b\u3cf4", // 㳴
	0x3cf5: "U\b\u3cf5", // 㳵
	0x3cf6: "U\b\u3cf6", // 㳶
	0x3cf7: "U\b\u3cf7", // 㳷
	0x3cf8: "U\b\u3cf8", // 㳸
	0x3cf9: "U\b\u3cf9", // 㳹
	0x3cfa: "U\b\u3cfa", // 㳺
	0x3cfb: "U\b\u3cfb", // 㳻
	0x3cfc: "U\b\u3cfc", // 㳼
	0x3cfd: "U\b\u3cfd", // 㳽
	0x3cfe: "U\b\u3cfe", // 㳾
	0x3cff: "U\b\u3cff", // 㳿
	0x3d00: "U\b\u3d00", // 㴀
	0x3d01: "U\b\u3d01", // 㴁
	0x3d02: "U\b\u3d02", // 㴂
	0x3d03: "U\b\u3d03", // 㴃
	0x3d04: "U\b\u3d04", // 㴄
	0x3d05: "U\b\u3d05", // 㴅
	0x3d06: "U\b\u3d06", // 㴆
	0x3d07: "U\b\u3d07", // 㴇
	0x3d08: "U\b\u3d08", // 㴈
	0x3d09: "U\b\u3d09", // 㴉
	0x3d0a: "U\b\u3d0a", // 㴊
	0x3d0b: "U\b\u3d0b", // 㴋
	0x3d0c: "U\b\u3d0c", // 㴌
	0x3d0d: "U\b\u3d0d", // 㴍
	0x3d0e: "U\b\u3d0e", // 㴎
	0x3d0f: "U\t\u3d0f", // 㴏
	0x3d10: "U\t\u3d10", // 㴐
	0x3d11: "U\t\u3d11", // 㴑
	0x3d12: "U\t\u3d12", // 㴒
	0x3d13: "U\t\u3d13", // 㴓
	0x3d14: "U\t\u3d14", // 㴔
	0x3d15: "U\t\u3d15", // 㴕
	0x3d16: "U\t\u3d16", // 㴖
	0x3d17: "U\t\u3d17", // 㴗
	0x3d18: "U\t\u3d18", // 㴘
	0x3d19: "U\t\u3d19", // 㴙
	0x3d1a: "U\t\u3d1a", // 㴚
	0x3d1b: "U\t\u3d1b", // 㴛
	0x3d1c: "U\t\u3d1c", // 㴜
	0x3d1d: "U\t\u3d1d", // 㴝
	0x3d1e: "U\t\u3d1e", // 㴞
	0x3d1f: "U\t\u3d1f", // 㴟
	0x3d20: "U\t\u3d20", // 㴠
	0x3d21: "U\t\u3d21", // 㴡
	0x3d22: "U\t\u3d22", // 㴢
	0x3d23: "U\t\u3d23", // 㴣
	0x3d24: "U\t\u3d24", // 㴤
	0x3d25: "U\n\u3d25", // 㴥
	0x3d26: "U\n\u3d26", // 㴦
	0x3d27: "U\n\u3d27", // 㴧
	0x3d28: "U\n\u3d28", // 㴨
	0x3d29: "U\n\u3d29", // 㴩
	0x3d2a: "U\n\u3d2a", // 㴪
	0x3d2b: "U\n\u3d2b", // 㴫
	0x3d2c: "U\n\u3d2c", // 㴬
	0x3d2d: "U\n\u3d2d", // 㴭
	0x3d2e: "U\n\u3d2e", // 㴮
	0x3d2f: "U\n\u3d2f", // 㴯
	0x3d30: "U\n\u3d30", // 㴰
	0x3d31: "U\n\u3d31", // 㴱
	0x3d32: "U\n\u3d32", // 㴲
	0x3d33: "U\n\u3d33", // 㴳
	0x3d34: "U\n\u3d34", // 㴴
	0x3d35: "U\n\u3d35", // 㴵
	0x3d36: "U\n\u3d36", // 㴶
	0x3d37: "U\n\u3d37", // 㴷
	0x3d38: "U\n\u3d38", // 㴸
	0x3d39: "U\n\u3d39", // 㴹
	0x3d3a: "U\n\u3d3a", // 㴺
	0x3d3b: "U\n\u3d3b", // 㴻
	0x3d3c: "U\v\u3d3c", // 㴼
	0x3d3d: "U\v\u3d3d", // 㴽
	0x3d3e: "U\v\u3d3e", // 㴾
	0x3d3f: "U\v\u3d3f", // 㴿
	0x3d40: "U\v\u3d40", // 㵀
	0x3d41: "U\v\u3d41", // 㵁
	0x3d42: "U\v\u3d42", // 㵂
	0x3d43: "U\v\u3d43", // 㵃
	0x3d44: "U\v\u3d44", // 㵄
	0x3d45: "U\v\u3d45", // 㵅
	0x3d46: "U\v\u3d46", // 㵆
	0x3d47: "U\v\u3d47", // 㵇
	0x3d48: "U\v\u3d48", // 㵈
	0x3d49: "U\v\u3d49", // 㵉
	0x3d4a: "U\f\u3d4a", // 㵊
	0x3d4b: "U\f\u3d4b", // 㵋
	0x3d4c: "U\f\u3d4c", // 㵌
	0x3d4d: "U\f\u3d4d", // 㵍
	0x3d4e: "U\f\u3d4e", // 㵎
	0x3d4f: "U\f\u3d4f", // 㵏
	0x3d50: "U\f\u3d50", // 㵐
	0x3d51: "U\f\u3d51", // 㵑
	0x3d52: "U\f\u3d52", // 㵒
	0x3d53: "U\f\u3d53", // 㵓
	0x3d54: "U\f\u3d54", // 㵔
	0x3d55: "U\f\u3d55", // 㵕
	0x3d56: "U\f\u3d56", // 㵖
	0x3d57: "U\f\u3d57", // 㵗
	0x3d58: "U\f\u3d58", // 㵘
	0x3d59: "U\f\u3d59", // 㵙
	0x3d5a: "U\f\u3d5a", // 㵚
	0x3d5b: "U\f\u3d5b", // 㵛
	0x3d5c: "U\f\u3d5c", // 㵜
	0x3d5d: "U\r\u3d5d", // 㵝
	0x3d5e: "U\r\u3d5e", // 㵞
	0x3d5f: "U\r\u3d5f", // 㵟
	0x3d60: "U\r\u3d60", // 㵠
	0x3d61: "U\r\u3d61", // 㵡
	0x3d62: "U\r\u3d62", // 㵢
	0x3d63: "U\r\u3d63", // 㵣
	0x3d64: "U\r\u3d64", // 㵤
	0x3d65: "U\r\u3d65", // 㵥
	0x3d66: "U\r\u3d66", // 㵦
	0x3d67: "U\r\u3d67", // 㵧
	0x3d68: "U\r\u3d68", // 㵨
	0x3d69: "U\r\u3d69", // 㵩
	0x3d6a: "U\r\u3d6a", // 㵪
	0x3d6b: "U\r\u3d6b", // 㵫
	0x3d6c: "U\r\u3d6c", // 㵬
	0x3d6d: "U\r\u3d6d", // 㵭
	0x3d6e: "U\r\u3d6e", // 㵮
	0x3d6f: "U\x0e\u3d6f", // 㵯
	0x3d70: "U\x0e\u3d70", // 㵰
	0x3d71: "U\x0e\u3d71", // 㵱
	0x3d72: "U\x0e\u3d72", // 㵲
	0x3d73: "U\x0e\u3d73", // 㵳
	0x3d74: "U\x0e\u3d74", // 㵴
	0x3d75: "U\x0e\u3d75", // 㵵
	0x3d76: "U\x0e\u3d76", // 㵶
	0x3d77: "U\x0e\u3d77", // 㵷
	0x3d78: "U\x0e\u3d78", // 㵸
	0x3d79: "U\x0e\u3d79", // 㵹
	0x3d7a: "U\x0e\u3d7a", // 㵺
	0x3d7b: "U\x0e\u3d7b", // 㵻
	0x3d7c: "U\x0e\u3d7c", // 㵼
	0x3d7d: "U\x0f\u3d7d", // 㵽
	0x3d7e: "U\x0f\u3d7e", // 㵾
	0x3d7f: "U\x0f\u3d7f", // 㵿
	0x3d80: "U\x0f\u3d80", // 㶀
	0x3d81: "U\x0f\u3d81", // 㶁
	0x3d82: "U\x0f\u3d82", // 㶂
	0x3d83: "U\x0f\u3d83", // 㶃
	0x3d84: "U\x10\u3d84", // 㶄
	0x3d85: "U\x10\u3d85", // 㶅
	0x3d86: "U\x10\u3d86", // 㶆
	0x3d87: "U\x10\u3d87", // 㶇
	0x3d88: "U\x10\u3d88", // 㶈
	0x3d89: "U\x10\u3d89", // 㶉
	0x3d8a: "U\x10\u3d8a", // 㶊
	0x3d8b: "U\x10\u3d8b", // 㶋
	0x3d8c: "U\x11\u3d8c", // 㶌
	0x3d8d: "U\x11\u3d8d", // 㶍
	0x3d8e: "U\x11\u3d8e", // 㶎
	0x3d8f: "U\x11\u3d8f", // 㶏
	0x3d90: "U\x11\u3d90", // 㶐
	0x3d91: "U\x11\u3d91", // 㶑
	0x3d92: "U\x12\u3d92", // 㶒
	0x3d93: "U\x12\u3d93", // 㶓
	0x3d94: "U\x12\u3d94", // 㶔
	0x3d95: "U\x12\u3d95", // 㶕
	0x3d96: "U\x12\u3d96", // 㶖
	0x3d97: "U\x12\u3d97", // 㶗
	0x3d98: "U\x12\u3d98", // 㶘
	0x3d99: "U\x13\u3d99", // 㶙
	0x3d9a: "U\x13\u3d9a", // 㶚
	0x3d9b: "U\x14\u3d9b", // 㶛
	0x3d9c: "U\x14\u3d9c", // 㶜
	0x3d9d: "U\x14\u3d9d", // 㶝
	0x3d9e: "U\x15\u3d9e", // 㶞
	0x3d9f: "U\x15\u3d9f", // 㶟
	0x3da0: "U\x17\u3da0", // 㶠
	0x3da1: "V\x02\u3da1", // 㶡
	0x3da2: "V\x02\u3da2", // 㶢
	0x3da3: "V\x03\u3da3", // 㶣
	0x3da4: "V\x03\u3da4", // 㶤
	0x3da5: "V\x03\u3da5", // 㶥
	0x3da6: "V\x04\u3da6", // 㶦
	0x3da7: "V\x04\u3da7", // 㶧
	0x3da8: "V\x04\u3da8", // 㶨
	0x3da9: "V\x04\u3da9", // 㶩
	0x3daa: "V\x04\u3daa", // 㶪
	0x3dab: "V\x05\u3dab", // 㶫
	0x3dac: "V\x05\u3dac", // 㶬
	0x3dad: "V\x05\u3dad", // 㶭
	0x3dae: "V\x05\u3dae", // 㶮
	0x3daf: "V\x05\u3daf", // 㶯
	0x3db0: "V\x05\u3db0", // 㶰
	0x3db1: "V\x05\u3db1", // 㶱
	0x3db2: "V\x05\u3db2", // 㶲
	0x3db3: "V\x06\u3db3", // 㶳
	0x3db4: "V\x06\u3db4", // 㶴
	0x3db5: "V\x06\u3db5", // 㶵
	0x3db6: "V\x06\u3db6", // 㶶
	0x3db7: "V\x06\u3db7", // 㶷
	0x3db8: "V\x06\u3db8", // 㶸
	0x3db9: "V\a\u3db9", // 㶹
	0x3dba: "V\a\u3dba", // 㶺
	0x3dbb: "V\a\u3dbb", // 㶻
	0x3dbc: "V\a\u3dbc", // 㶼
	0x3dbd: "V\a\u3dbd", // 㶽
	0x3dbe: "V\a\u3dbe", // 㶾
	0x3dbf: "V\a\u3dbf", // 㶿
	0x3dc0: "V\a\u3dc0", // 㷀
	0x3dc1: "V\a\u3dc1", // 㷁
	0x3dc2: "V\b\u3dc2", // 㷂
	0x3dc3: "V\b\u3dc3", // 㷃
	0x3dc4: "V\b\u3dc4", // 㷄
	0x3dc5: "V\b\u3dc5", // 㷅
	0x3dc6: "V\b\u3dc6", // 㷆
	0x3dc7: "V\b\u3dc7", // 㷇
	0x3dc8: "V\b\u3dc8", // 㷈
	0x3dc9: "V\b\u3dc9", // 㷉
	0x3dca: "V\b\u3dca", // 㷊
	0x3dcb: "V\b\u3dcb", // 㷋
	0x3dcc: "V\b\u3dcc", // 㷌
	0x3dcd: "V\b\u3dcd", // 㷍
	0x3dce: "V\t\u3dce", // 㷎
	0x3dcf: "V\t\u3dcf", // 㷏
	0x3dd0: "V\t\u3dd0", // 㷐
	0x3dd1: "V\t\u3dd1", // 㷑
	0x3dd2: "V\t\u3dd2", // 㷒
	0x3dd3: "V\t\u3dd3", // 㷓
	0x3dd4: "V\t\u3dd4", // 㷔
	0x3dd5: "V\t\u3dd5", // 㷕
	0x3dd6: "V\t\u3dd6", // 㷖
	0x3dd7: "V\t\u3dd7", // 㷗
	0x3dd8: "V\t\u3dd8", // 㷘
	0x3dd9: "V\t\u3dd9", // 㷙
	0x3dda: "V\t\u3dda", // 㷚
	0x3ddb: "V\t\u3ddb", // 㷛
	0x3ddc: "V\t\u3ddc", // 㷜
	0x3ddd: "V\t\u3ddd", // 㷝
	0x3dde: "V\t\u3dde", // 㷞
	0x3ddf: "V\n\u3ddf", // 㷟
	0x3de0: "V\n\u3de0", // 㷠
	0x3de1: "V\n\u3de1", // 㷡
	0x3de2: "V\n\u3de2", // 㷢
	0x3de3: "V\n\u3de3", // 㷣
	0x3de4: "V\n\u3de4", // 㷤
	0x3de5: "V\n\u3de5", // 㷥
	0x3de6: "V\n\u3de6", // 㷦
	0x3de7: "V\n\u3de7", // 㷧
	0x3de8: "V\n\u3de8", // 㷨
	0x3de9: "V\n\u3de9", // 㷩
	0x3dea: "V\n\u3dea", // 㷪
	0x3deb: "V\v\u3deb", // 㷫
	0x3dec: "V\v\u3dec", // 㷬
	0x3ded: "V\v\u3ded", // 㷭
	0x3dee: "V\v\u3dee", // 㷮
	0x3def: "V\v\u3def", // 㷯
	0x3df0: "V\v\u3df0", // 㷰
	0x3df1: "V\v\u3df1", // 㷱
	0x3df2: "V\v\u3df2", // 㷲
	0x3df3: "V\f\u3df3", // 㷳
	0x3df4: "V\f\u3df4", // 㷴
	0x3df5: "V\f\u3df5", // 㷵
	0x3df6: "V\f\u3df6", // 㷶
	0x3df7: "V\f\u3df7", // 㷷
	0x3df8: "V\f\u3df8", // 㷸
	0x3df9: "V\f\u3df9", // 㷹
	0x3dfa: "V\f\u3dfa", // 㷺
	0x3dfb: "V\f\u3dfb", // 㷻
	0x3dfc: "V\f\u3dfc", // 㷼
	0x3dfd: "V\f\u3dfd", // 㷽
	0x3dfe: "V\r\u3dfe", // 㷾
	0x3dff: "V\r\u3dff", // 㷿
	0x3e00: "V\r\u3e00", // 㸀
	0x3e01: "V\r\u3e01", // 㸁
	0x3e02: "V\r\u3e02", // 㸂
	0x3e03: "V\r\u3e03", // 㸃
	0x3e04: "V\x0e\u3e04", // 㸄
	0x3e05: "V\x0e\u3e05", // 㸅
	0x3e06: "V\x0f\u3e06", // 㸆
	0x3e07: "V\x0f\u3e07", // 㸇
	0x3e08: "V\x10\u3e08", // 㸈
	0x3e09: "V\x0f\u3e09", // 㸉
	0x3e0a: "V\x10\u3e0a", // 㸊
	0x3e0b: "V\x10\u3e0b", // 㸋
	0x3e0c: "V\x10\u3e0c", // 㸌
	0x3e0d: "V\x11\u3e0d", // 㸍
	0x3e0e: "V\x12\u3e0e", // 㸎
	0x3e0f: "V\x13\u3e0f", // 㸏
	0x3e10: "V\x13\u3e10", // 㸐
	0x3e11: "V\x16\u3e11", // 㸑
	0x3e12: "W\x04\u3e12", // 㸒
	0x3e13: "W\x04\u3e13", // 㸓
	0x3e14: "W\a\u3e14", // 㸔
	0x3e15: "W\n\u3e15", // 㸕
	0x3e16: "X\x05\u3e16", // 㸖
	0x3e17: "X\x06\u3e17", // 㸗
	0x3e18: "X\a\u3e18", // 㸘
	0x3e19: "X\t\u3e19", // 㸙
	0x3e1a: "Y\x04\u3e1a", // 㸚
	0x3e1b: "Z\x05\u3e1b", // 㸛
	0x3e1c: "Z\b\u3e1c", // 㸜
	0x3e1d: "[\x04\u3e1d", // 㸝
	0x3e1e: "[\x04\u3e1e", // 㸞
	0x3e1f: "[\x06\u3e1f", // 㸟
	0x3e20: "[\x06\u3e20", // 㸠
	0x3e21: "[\x06\u3e21", // 㸡
	0x3e22: "[\n\u3e22", // 㸢
	0x3e23: "[\r\u3e23", // 㸣
	0x3e24: "[\x0e\u3e24", // 㸤
	0x3e25: "[\x11\u3e25", // 㸥
	0x3e26: "\\\x00\u3e26", // 㸦
	0x3e27: "\\\x06\u3e27", // 㸧
	0x3e28: "]\x02\u3e28", // 㸨
	0x3e29: "]\x03\u3e29", // 㸩
	0x3e2a: "]\x03\u3e2a", // 㸪
	0x3e2b: "]\x04\u3e2b", // 㸫
	0x3e2c: "]\x04\u3e2c", // 㸬
	0x3e2d: "]\x04\u3e2d", // 㸭
	0x3e2e: "]\x04\u3e2e", // 㸮
	0x3e2f: "]\x04\u3e2f", // 㸯
	0x3e30: "]\x05\u3e30", // 㸰
	0x3e31: "]\x05\u3e31", // 㸱
	0x3e32: "]\x05\u3e32", // 㸲
	0x3e33: "]\x05\u3e33", // 㸳
	0x3e34: "]\x05\u3e34", // 㸴
	0x3e35: "]\x06\u3e35", // 㸵
	0x3e36: "]\x06\u3e36", // 㸶
	0x3e37: "]\x06\u3e37", // 㸷
	0x3e38: "]\x06\u3e38", // 㸸
	0x3e39: "]\a\u3e39", // 㸹
	0x3e3a: "]\a\u3e3a", // 㸺
	0x3e3b: "]\a\u3e3b", // 㸻
	0x3e3c: "]\a\u3e3c", // 㸼
	0x3e3d: "]\a\u3e3d", // 㸽
	0x3e3e: "]\a\u3e3e", // 㸾
	0x3e3f: "]\a\u3e3f", // 㸿
	0x3e40: "]\a\u3e40", // 㹀
	0x3e41: "]\b\u3e41", // 㹁
	0x3e42: "]\b\u3e42", // 㹂
	0x3e43: "]\b\u3e43", // 㹃
	0x3e44: "]\n\u3e44", // 㹄
	0x3e45: "]\t\u3e45", // 㹅
	0x3e46: "]\t\u3e46", // 㹆
	0x3e47: "]\t\u3e47", // 㹇
	0x3e48: "]\t\u3e48", // 㹈
	0x3e49: "]\n\u3e49", // 㹉
	0x3e4a: "]\n\u3e4a", // 㹊
	0x3e4b: "]\n\u3e4b", // 㹋
	0x3e4c: "]\v\u3e4c", // 㹌
	0x3e4d: "]\v\u3e4d", // 㹍
	0x3e4e: "]\v\u3e4e", // 㹎
	0x3e4f: "]\v\u3e4f", // 㹏
	0x3e50: "]\v\u3e50", // 㹐
	0x3e51: "]\f\u3e51", // 㹑
	0x3e52: "]\f\u3e52", // 㹒
	0x3e53: "]\f\u3e53", // 㹓
	0x3e54: "]\r\u3e54", // 㹔
	0x3e55: "]\r\u3e55", // 㹕
	0x3e56: "]\r\u3e56", // 㹖
	0x3e57: "]\x0e\u3e57", // 㹗
	0x3e58: "]\x0e\u3e58", // 㹘
	0x3e59: "]\x0f\u3e59", // 㹙
	0x3e5a: "]\x11\u3e5a", // 㹚
	0x3e5b: "]\x12\u3e5b", // 㹛
	0x3e5c: "^\x04\u3e5c", // 㹜
	0x3e5d: "^\x04\u3e5d", // 㹝
	0x3e5e: "^\x04\u3e5e", // 㹞
	0x3e5f: "^\x04\u3e5f", // 㹟
	0x3e60: "^\x04\u3e60", // 㹠
	0x3e61: "^\x05\u3e61", // 㹡
	0x3e62: "^\x05\u3e62", // 㹢
	0x3e63: "^\x05\u3e63", // 㹣
	0x3e64: "^\x05\u3e64", // 㹤
	0x3e65: "^\x05\u3e65", // 㹥
	0x3e66: "^\x05\u3e66", // 㹦
	0x3e67: "^\x05\u3e67", // 㹧
	0x3e68: "^\x05\u3e68", // 㹨
	0x3e69: "^\x05\u3e69", // 㹩
	0x3e6a: "^\x05\u3e6a", // 㹪
	0x3e6b: "^\x06\u3e6b", // 㹫
	0x3e6c: "^\x06\u3e6c", // 㹬
	0x3e6d: "^\x06\u3e6d", // 㹭
	0x3e6e: "^\x06\u3e6e", // 㹮
	0x3e6f: "^\x06\u3e6f", // 㹯
	0x3e70: "^\x06\u3e70", // 㹰
	0x3e71: "^\a\u3e71", // 㹱
	0x3e72: "^\a\u3e72", // 㹲
	0x3e73: "^\a\u3e73", // 㹳
	0x3e74: "^\a\u3e74", // 㹴
	0x3e75: "^\a\u3e75", // 㹵
	0x3e76: "^\a\u3e76", // 㹶
	0x3e77: "^\a\u3e77", // 㹷
	0x3e78: "^\a\u3e78", // 㹸
	0x3e79: "^\b\u3e79", // 㹹
	0x3e7a: "^\b\u3e7a", // 㹺
	0x3e7b: "^\b\u3e7b", // 㹻
	0x3e7c: "^\b\u3e7c", // 㹼
	0x3e7d: "^\b\u3e7d", // 㹽
	0x3e7e: "^\b\u3e7e", // 㹾
	0x3e7f: "^\b\u3e7f", // 㹿
	0x3e80: "^\b\u3e80", // 㺀
	0x3e81: "^\t\u3e81", // 㺁
	0x3e82: "^\t\u3e82", // 㺂
	0x3e83: "^\t\u3e83", // 㺃
	0x3e84: "^\t\u3e84", // 㺄
	0x3e85: "^\t\u3e85", // 㺅
	0x3e86: "^\t\u3e86", // 㺆
	0x3e87: "^\n\u3e87", // 㺇
	0x3e88: "^\n\u3e88", // 㺈
	0x3e89: "^\n\u3e89", // 㺉
	0x3e8a: "^\n\u3e8a", // 㺊
	0x3e8b: "^\n\u3e8b", // 㺋
	0x3e8c: "^\n\u3e8c", // 㺌
	0x3e8d: "^\n\u3e8d", // 㺍
	0x3e8e: "^\v\u3e8e", // 㺎
	0x3e8f: "^\v\u3e8f", // 㺏
	0x3e90: "^\v\u3e90", // 㺐
	0x3e91: "^\v\u3e91", // 㺑
	0x3e92: "^\v\u3e92", // 㺒
	0x3e93: "^\v\u3e93", // 㺓
	0x3e94: "^\f\u3e94", // 㺔
	0x3e95: "^\f\u3e95", // 㺕
	0x3e96: "^\f\u3e96", // 㺖
	0x3e97: "^\f\u3e97", // 㺗
	0x3e98: "^\f\u3e98", // 㺘
	0x3e99: "^\f\u3e99", // 㺙
	0x3e9a: "^\r\u3e9a", // 㺚
	0x3e9b: "^\r\u3e9b", // 㺛
	0x3e9c: "^\r\u3e9c", // 㺜
	0x3e9d: "^\x0e\u3e9d", // 㺝
	0x3e9e: "^\x0e\u3e9e", // 㺞
	0x3e9f: "^\x0e\u3e9f", // 㺟
	0x3ea0: "^\x0f\u3ea0", // 㺠
	0x3ea1: "^\x10\u3ea1", // 㺡
	0x3ea2: "^\x10\u3ea2", // 㺢
	0x3ea3: "^\x11\u3ea3", // 㺣
	0x3ea4: "^\x11\u3ea4", // 㺤
	0x3ea5: "^\x11\u3ea5", // 㺥
	0x3ea6: "^\x11\u3ea6", // 㺦
	0x3ea7: "^\x15\u3ea7", // 㺧
	0x3ea8: "`\x02\u3ea8", // 㺨
	0x3ea9: "`\x02\u3ea9", // 㺩
	0x3eaa: "`\x02\u3eaa", // 㺪
	0x3eab: "`\x02\u3eab", // 㺫
	0x3eac: "`\x03\u3eac", // 㺬
	0x3ead: "`\x03\u3ead", // 㺭
	0x3eae: "`\x03\u3eae", // 㺮
	0x3eaf: "`\x03\u3eaf", // 㺯
	0x3eb0: "`\x04\u3eb0", // 㺰
	0x3eb1: "`\x04\u3eb1", // 㺱
	0x3eb2: "`\x04\u3eb2", // 㺲
	0x3eb3: "`\x04\u3eb3", // 㺳
	0x3eb4: "`\x04\u3eb4", // 㺴
	0x3eb5: "`\x04\u3eb5", // 㺵
	0x3eb6: "`\x04\u3eb6", // 㺶
	0x3eb7: "`\x05\u3eb7", // 㺷
	0x3eb8: "`\x05\u3eb8", // 㺸
	0x3eb9: "`\x05\u3eb9", // 㺹
	0x3eba: "`\x05\u3eba", // 㺺
	0x3ebb: "`\x05\u3ebb", // 㺻
	0x3ebc: "`\x05\u3ebc", // 㺼
	0x3ebd: "`\x05\u3ebd", // 㺽
	0x3ebe: "`\x05\u3ebe", // 㺾
	0x3ebf: "`\x06\u3ebf", // 㺿
	0x3ec0: "`\x06\u3ec0", // 㻀
	0x3ec1: "`\x06\u3ec1", // 㻁
	0x3ec2: "`\x06\u3ec2", // 㻂
	0x3ec3: "`\x06\u3ec3", // 㻃
	0x3ec4: "`\x06\u3ec4", // 㻄
	0x3ec5: "`\x06\u3ec5", // 㻅
	0x3ec6: "`\x06\u3ec6", // 㻆
	0x3ec7: "`\x06\u3ec7", // 㻇
	0x3ec8: "`\x06\u3ec8", // 㻈
	0x3ec9: "`\a\u3ec9", // 㻉
	0x3eca: "`\a\u3eca", // 㻊
	0x3ecb: "`\a\u3ecb", // 㻋
	0x3ecc: "`\a\u3ecc", // 㻌
	0x3ecd: "`\a\u3ecd", // 㻍
	0x3ece: "`\a\u3ece", // 㻎
	0x3ecf: "`\a\u3ecf", // 㻏
	0x3ed0: "`\a\u3ed0", // 㻐
	0x3ed1: "`\b\u3ed1", // 㻑
	0x3ed2: "`\b\u3ed2", // 㻒
	0x3ed3: "`\b\u3ed3", // 㻓
	0x3ed4: "`\b\u3ed4", // 㻔
	0x3ed5: "`\b\u3ed5", // 㻕
	0x3ed6: "`\b\u3ed6", // 㻖
	0x3ed7: "`\b\u3ed7", // 㻗
	0x3ed8: "`\b\u3ed8", // 㻘
	0x3ed9: "`\b\u3ed9", // 㻙
	0x3eda: "`\b\u3eda", // 㻚
	0x3edb: "`\b\u3edb", // 㻛
	0x3edc: "`\b\u3edc", // 㻜
	0x3edd: "`\t\u3edd", // 㻝
	0x3ede: "`\t\u3ede", // 㻞
	0x3edf: "`\t\u3edf", // 㻟
	0x3ee0: "`\t\u3ee0", // 㻠
	0x3ee1: "`\t\u3ee1", // 㻡
	0x3ee2: "`\t\u3ee2", // 㻢
	0x3ee3: "`\t\u3ee3", // 㻣
	0x3ee4: "`\t\u3ee4", // 㻤
	0x3ee5: "`\t\u3ee5", // 㻥
	0x3ee6: "`\t\u3ee6", // 㻦
	0x3ee7: "`\n\u3ee7", // 㻧
	0x3ee8: "`\n\u3ee8", // 㻨
	0x3ee9: "`\n\u3ee9", // 㻩
	0x3eea: "`\n\u3eea", // 㻪
	0x3eeb: "`\v\u3eeb", // 㻫
	0x3eec: "`\v\u3eec", // 㻬
	0x3eed: "`\v\u3eed", // 㻭
	0x3eee: "`\v\u3eee", // 㻮
	0x3eef: "`\v\u3eef", // 㻯
	0x3ef0: "`\v\u3ef0", // 㻰
	0x3ef1: "`\v\u3ef1", // 㻱
	0x3ef2: "`\v\u3ef2", // 㻲
	0x3ef3: "`\v\u3ef3", // 㻳
	0x3ef4: "`\v\u3ef4", // 㻴
	0x3ef5: "`\f\u3ef5", // 㻵
	0x3ef6: "`\f\u3ef6", // 㻶
	0x3ef7: "`\f\u3ef7", // 㻷
	0x3ef8: "`\f\u3ef8", // 㻸
	0x3ef9: "`\f\u3ef9", // 㻹
	0x3efa: "`\f\u3efa", // 㻺
	0x3efb: "`\f\u3efb", // 㻻
	0x3efc: "`\f\u3efc", // 㻼
	0x3efd: "`\r\u3efd", // 㻽
	0x3efe: "`\r\u3efe", // 㻾
	0x3eff: "`\r\u3eff", // 㻿
	0x3f00: "`\r\u3f00", // 㼀
	0x3f01: "`\r\u3f01", // 㼁
	0x3f02: "`\r\u3f02", // 㼂
	0x3f03: "`\x0f\u3f03", // 㼃
	0x3f04: "`\x0f\u3f04", // 㼄
	0x3f05: "`\x0f\u3f05", // 㼅
	0x3f06: "`\x0f\u3f06", // 㼆
	0x3f07: "`\x10\u3f07", // 㼇
	0x3f08: "`\x13\u3f08", // 㼈
	0x3f09: "a\x04\u3f09", // 㼉
	0x3f0a: "a\x04\u3f0a", // 㼊
	0x3f0b: "a\x05\u3f0b", // 㼋
	0x3f0c: "a\x05\u3f0c", // 㼌
	0x3f0d: "a\x06\u3f0d", // 㼍
	0x3f0e: "a\x06\u3f0e", // 㼎
	0x3f0f: "a\a\u3f0f", // 㼏
	0x3f10: "a\t\u3f10", // 㼐
	0x3f11: "a\t\u3f11", // 㼑
	0x3f12: "a\t\u3f12", // 㼒
	0x3f13: "a\n\u3f13", // 㼓
	0x3f14: "a\n\u3f14", // 㼔
	0x3f15: "a\r\u3f15", // 㼕
	0x3f16: "a\x15\u3f16", // 㼖
	0x3f17: "b\x02\u3f17", // 㼗
	0x3f18: "b\x03\u3f18", // 㼘
	0x3f19: "b\x03\u3f19", // 㼙
	0x3f1a: "b\x04\u3f1a", // 㼚
	0x3f1b: "b\x04\u3f1b", // 㼛
	0x3f1c: "b\x05\u3f1c", // 㼜
	0x3f1d: "b\x05\u3f1d", // 㼝
	0x3f1e: "b\x05\u3f1e", // 㼞
	0x3f1f: "b\x05\u3f1f", // 㼟
	0x3f20: "b\x05\u3f20", // 㼠
	0x3f21: "b\x06\u3f21", // 㼡
	0x3f22: "b\x06\u3f22", // 㼢
	0x3f23: "b\x06\u3f23", // 㼣
	0x3f24: "b\x06\u3f24", // 㼤
	0x3f25: "b\x06\u3f25", // 㼥
	0x3f26: "b\x06\u3f26", // 㼦
	0x3f27: "b\a\u3f27", // 㼧
	0x3f28: "b\a\u3f28", // 㼨
	0x3f29: "b\a\u3f29", // 㼩
	0x3f2a: "b\a\u3f2a", // 㼪
	0x3f2b: "b\b\u3f2b", // 㼫
	0x3f2c: "b\b\u3f2c", // 㼬
	0x3f2d: "b\b\u3f2d", // 㼭
	0x3f2e: "b\b\u3f2e", // 㼮
	0x3f2f: "b\b\u3f2f", // 㼯
	0x3f30: "b\b\u3f30", // 㼰
	0x3f31: "b\b\u3f31", // 㼱
	0x3f32: "b\t\u3f32", // 㼲
	0x3f33: "b\t\u3f33", // 㼳
	0x3f34: "b\t\u3f34", // 㼴
	0x3f35: "b\t\u3f35", // 㼵
	0x3f36: "b\t\u3f36", // 㼶
	0x3f37: "b\t\u3f37", // 㼷
	0x3f38: "b\n\u3f38", // 㼸
	0x3f39: "b\n\u3f39", // 㼹
	0x3f3a: "b\n\u3f3a", // 㼺
	0x3f3b: "b\v\u3f3b", // 㼻
	0x3f3c: "b\v\u3f3c", // 㼼
	0x3f3d: "b\v\u3f3d", // 㼽
	0x3f3e: "b\v\u3f3e", // 㼾
	0x3f3f: "b\f\u3f3f", // 㼿
	0x3f40: "b\f\u3f40", // 㽀
	0x3f41: "b\f\u3f41", // 㽁
	0x3f42: "b\f\u3f42", // 㽂
	0x3f43: "b\f\u3f43", // 㽃
	0x3f44: "b\f\u3f44", // 㽄
	0x3f45: "b\f\u3f45", // 㽅
	0x3f46: "b\r\u3f46", // 㽆
	0x3f47: "b\r\u3f47", // 㽇
	0x3f48: "b\x0e\u3f48", // 㽈
	0x3f49: "b\x0e\u3f49", // 㽉
	0x3f4a: "b\x11\u3f4a", // 㽊
	0x3f4b: "b\x13\u3f4b", // 㽋
	0x3f4c: "b\x14\u3f4c", // 㽌
	0x3f4d: "c\x05\u3f4d", // 㽍
	0x3f4e: "c\b\u3f4e", // 㽎
	0x3f4f: "c\t\u3f4f", // 㽏
	0x3f50: "c\n\u3f50", // 㽐
	0x3f51: "c\f\u3f51", // 㽑
	0x3f52: "d\a\u3f52", // 㽒
	0x3f53: "d\n\u3f53", // 㽓
	0x3f54: "d\v\u3f54", // 㽔
	0x3f55: "f\x02\u3f55", // 㽕
	0x3f56: "f\x02\u3f56", // 㽖
	0x3f57: "f\x02\u3f57", // 㽗
	0x3f58: "f\x04\u3f58", // 㽘
	0x3f59: "f\x04\u3f59", // 㽙
	0x3f5a: "f\x04\u3f5a", // 㽚
	0x3f5b: "f\x05\u3f5b", // 㽛
	0x3f5c: "f\x05\u3f5c", // 㽜
	0x3f5d: "f\x06\u3f5d", // 㽝
	0x3f5e: "f\x06\u3f5e", // 㽞
	0x3f5f: "f\a\u3f5f", // 㽟
	0x3f60: "f\a\u3f60", // 㽠
	0x3f61: "f\b\u3f61", // 㽡
	0x3f62: "f\b\u3f62", // 㽢
	0x3f63: "f\b\u3f63", // 㽣
	0x3f64: "f\b\u3f64", // 㽤
	0x3f65: "f\t\u3f65", // 㽥
	0x3f66: "f\n\u3f66", // 㽦
	0x3f67: "f\n\u3f67", // 㽧
	0x3f68: "f\n\u3f68", // 㽨
	0x3f69: "f\v\u3f69", // 㽩
	0x3f6a: "f\f\u3f6a", // 㽪
	0x3f6b: "f\r\u3f6b", // 㽫
	0x3f6c: "f\r\u3f6c", // 㽬
	0x3f6d: "f\x0e\u3f6d", // 㽭
	0x3f6e: "f\x0f\u3f6e", // 㽮
	0x3f6f: "f\x12\u3f6f", // 㽯
	0x3f70: "g\b\u3f70", // 㽰
	0x3f71: "h\x02\u3f71", // 㽱
	0x3f72: "h\x02\u3f72", // 㽲
	0x3f73: "h\x03\u3f73", // 㽳
	0x3f74: "h\x03\u3f74", // 㽴
	0x3f75: "h\x03\u3f75", // 㽵
	0x3f76: "h\x03\u3f76", // 㽶
	0x3f77: "h\x04\u3f77", // 㽷
	0x3f78: "h\x04\u3f78", // 㽸
	0x3f79: "h\x04\u3f79", // 㽹
	0x3f7a: "h\x04\u3f7a", // 㽺
	0x3f7b: "h\x04\u3f7b", // 㽻
	0x3f7c: "h\x04\u3f7c", // 㽼
	0x3f7d: "h\x05\u3f7d", // 㽽
	0x3f7e: "h\x05\u3f7e", // 㽾
	0x3f7f: "h\x05\u3f7f", // 㽿
	0x3f80: "h\x05\u3f80", // 㾀
	0x3f81: "h\x05\u3f81", // 㾁
	0x3f82: "h\x05\u3f82", // 㾂
	0x3f83: "h\x05\u3f83", // 㾃
	0x3f84: "h\x05\u3f84", // 㾄
	0x3f85: "h\x05\u3f85", // 㾅
	0x3f86: "h\x05\u3f86", // 㾆
	0x3f87: "h\x05\u3f87", // 㾇
	0x3f88: "h\x05\u3f88", // 㾈
	0x3f89: "h\x05\u3f89", // 㾉
	0x3f8a: "h\x06\u3f8a", // 㾊
	0x3f8b: "h\x06\u3f8b", // 㾋
	0x3f8c: "h\x06\u3f8c", // 㾌
	0x3f8d: "h\x06\u3f8d", // 㾍
	0x3f8e: "h\x06\u3f8e", // 㾎
	0x3f8f: "h\x06\u3f8f", // 㾏
	0x3f90: "h\x06\u3f90", // 㾐
	0x3f91: "h\x06\u3f91", // 㾑
	0x3f92: "h\x06\u3f92", // 㾒
	0x3f93: "h\a\u3f93", // 㾓
	0x3f94: "h\a\u3f94", // 㾔
	0x3f95: "h\a\u3f95", // 㾕
	0x3f96: "h\a\u3f96", // 㾖
	0x3f97: "h\a\u3f97", // 㾗
	0x3f98: "h\a\u3f98", // 㾘
	0x3f99: "h\a\u3f99", // 㾙
	0x3f9a: "h\a\u3f9a", // 㾚
	0x3f9b: "h\a\u3f9b", // 㾛
	0x3f9c: "h\a\u3f9c", // 㾜
	0x3f9d: "h\a\u3f9d", // 㾝
	0x3f9e: "h\a\u3f9e", // 㾞
	0x3f9f: "h\a\u3f9f", // 㾟
	0x3fa0: "h\a\u3fa0", // 㾠
	0x3fa1: "h\a\u3fa1", // 㾡
	0x3fa2: "h\b\u3fa2", // 㾢
	0x3fa3: "h\b\u3fa3", // 㾣
	0x3fa4: "h\b\u3fa4", // 㾤
	0x3fa5: "h\b\u3fa5", // 㾥
	0x3fa6: "h\b\u3fa6", // 㾦
	0x3fa7: "h\b\u3fa7", // 㾧
	0x3fa8: "h\b\u3fa8", // 㾨
	0x3fa9: "h\b\u3fa9", // 㾩
	0x3faa: "h\t\u3faa", // 㾪
	0x3fab: "h\t\u3fab", // 㾫
	0x3fac: "h\t\u3fac", // 㾬
	0x3fad: "h\t\u3fad", // 㾭
	0x3fae: "h\t\u3fae", // 㾮
	0x3faf: "h\t\u3faf", // 㾯
	0x3fb0: "h\t\u3fb0", // 㾰
	0x3fb1: "h\t\u3fb1", // 㾱
	0x3fb2: "h\t\u3fb2", // 㾲
	0x3fb3: "h\t\u3fb3", // 㾳
	0x3fb4: "h\t\u3fb4", // 㾴
	0x3fb5: "h\t\u3fb5", // 㾵
	0x3fb6: "h\n\u3fb6", // 㾶
	0x3fb7: "h\n\u3fb7", // 㾷
	0x3fb8: "h\n\u3fb8", // 㾸
	0x3fb9: "h\n\u3fb9", // 㾹
	0x3fba: "h\n\u3fba", // 㾺
	0x3fbb: "h\n\u3fbb", // 㾻
	0x3fbc: "h\n\u3fbc", // 㾼
	0x3fbd: "h\n\u3fbd", // 㾽
	0x3fbe: "h\n\u3fbe", // 㾾
	0x3fbf: "h\n\u3fbf", // 㾿
	0x3fc0: "h\n\u3fc0", // 㿀
	0x3fc1: "h\n\u3fc1", // 㿁
	0x3fc2: "h\v\u3fc2", // 㿂
	0x3fc3: "h\v\u3fc3", // 㿃
	0x3fc4: "h\v\u3fc4", // 㿄
	0x3fc5: "h\v\u3fc5", // 㿅
	0x3fc6: "h\v\u3fc6", // 㿆
	0x3fc7: "h\v\u3fc7", // 㿇
	0x3fc8: "h\v\u3fc8", // 㿈
	0x3fc9: "h\f\u3fc9", // 㿉
	0x3fca: "h\f\u3fca", // 㿊
	0x3fcb: "h\r\u3fcb", // 㿋
	0x3fcc: "h\r\u3fcc", // 㿌
	0x3fcd: "h\r\u3fcd", // 㿍
	0x3fce: "h\r\u3fce", // 㿎
	0x3fcf: "h\r\u3fcf", // 㿏
	0x3fd0: "h\r\u3fd0", // 㿐
	0x3fd1: "h\x0e\u3fd1", // 㿑
	0x3fd2: "h\x0e\u3fd2", // 㿒
	0x3fd3: "h\x0e\u3fd3", // 㿓
	0x3fd4: "h\x0f\u3fd4", // 㿔
	0x3fd5: "h\x10\u3fd5", // 㿕
	0x3fd6: "h\x10\u3fd6", // 㿖
	0x3fd7: "h\x10\u3fd7", // 㿗
	0x3fd8: "h\x11\u3fd8", // 㿘
	0x3fd9: "h\x12\u3fd9", // 㿙
	0x3fda: "h\x13\u3fda", // 㿚
	0x3fdb: "h\x13\u3fdb", // 㿛
	0x3fdc: "h\x17\u3fdc", // 㿜
	0x3fdd: "j\x02\u3fdd", // 㿝
	0x3fde: "j\x04\u3fde", // 㿞
	0x3fdf: "j\x05\u3fdf", // 㿟
	0x3fe0: "j\x06\u3fe0", // 㿠
	0x3fe1: "j\x06\u3fe1", // 㿡
	0x3fe2: "j\b\u3fe2", // 㿢
	0x3fe3: "j\t\u3fe3", // 㿣
	0x3fe4: "j\t\u3fe4", // 㿤
	0x3fe5: "j\n\u3fe5", // 㿥
	0x3fe6: "j\v\u3fe6", // 㿦
	0x3fe7: "j\x0e\u3fe7", // 㿧
	0x3fe8: "j\x10\u3fe8", // 㿨
	0x3fe9: "j\x14\u3fe9", // 㿩
	0x3fea: "k\x03\u3fea", // 㿪
	0x3feb: "k\x04\u3feb", // 㿫
	0x3fec: "k\x04\u3fec", // 㿬
	0x3fed: "k\x05\u3fed", // 㿭
	0x3fee: "k\x05\u3fee", // 㿮
	0x3fef: "k\x06\u3fef", // 㿯
	0x3ff0: "k\x06\u3ff0", // 㿰
	0x3ff1: "k\a\u3ff1", // 㿱
	0x3ff2: "k\b\u3ff2", // 㿲
	0x3ff3: "k\b\u3ff3", // 㿳
	0x3ff4: "k\t\u3ff4", // 㿴
	0x3ff5: "k\t\u3ff5", // 㿵
	0x3ff6: "k\n\u3ff6", // 㿶
	0x3ff7: "k\n\u3ff7", // 㿷
	0x3ff8: "k\v\u3ff8", // 㿸
	0x3ff9: "k\r\u3ff9", // 㿹
	0x3ffa: "k\x0f\u3ffa", // 㿺
	0x3ffb: "l\x03\u3ffb", // 㿻
	0x3ffc: "l\x04\u3ffc", // 㿼
	0x3ffd: "l\x04\u3ffd", // 㿽
	0x3ffe: "l\x05\u3ffe", // 㿾
	0x3fff: "l\x05\u3fff", // 㿿
	0x4000: "l\x05\u4000", // 䀀
	0x4001: "l\x06\u4001", // 䀁
	0x4002: "l\x06\u4002", // 䀂
	0x4003: "l\a\u4003", // 䀃
	0x4004: "l\b\u4004", // 䀄
	0x4005: "l\b\u4005", // 䀅
	0x4006: "l\t\u4006", // 䀆
	0x4007: "l\v\u4007", // 䀇
	0x4008: "l\v\u4008", // 䀈
	0x4009: "l\f\u4009", // 䀉
	0x400a: "l\x0e\u400a", // 䀊
	0x400b: "l\x10\u400b", // 䀋
	0x400c: "l\x11\u400c", // 䀌
	0x400d: "l\x18\u400d", // 䀍
	0x400e: "m\x02\u400e", // 䀎
	0x400f: "m\x02\u400f", // 䀏
	0x4010: "m\x03\u4010", // 䀐
	0x4011: "m\x03\u4011", // 䀑
	0x4012: "m\x03\u4012", // 䀒
	0x4013: "m\x03\u4013", // 䀓
	0x4014: "m\x03\u4014", // 䀔
	0x4015: "m\x04\u4015", // 䀕
	0x4016: "m\x04\u4016", // 䀖
	0x4017: "m\x04\u4017", // 䀗
	0x4018: "m\x04\u4018", // 䀘
	0x4019: "m\x04\u4019", // 䀙
	0x401a: "m\x04\u401a", // 䀚
	0x401b: "m\x04\u401b", // 䀛
	0x401c: "m\x04\u401c", // 䀜
	0x401d: "m\x04\u401d", // 䀝
	0x401e: "m\x04\u401e", // 䀞
	0x401f: "m\x05\u401f", // 䀟
	0x4020: "m\x05\u4020", // 䀠
	0x4021: "m\x05\u4021", // 䀡
	0x4022: "m\x05\u4022", // 䀢
	0x4023: "m\x05\u4023", // 䀣
	0x4024: "m\x05\u4024", // 䀤
	0x4025: "m\x05\u4025", // 䀥
	0x4026: "m\x05\u4026", // 䀦
	0x4027: "m\x06\u4027", // 䀧
	0x4028: "m\x06\u4028", // 䀨
	0x4029: "m\x06\u4029", // 䀩
	0x402a: "m\x06\u402a", // 䀪
	0x402b: "m\x06\u402b", // 䀫
	0x402c: "m\x06\u402c", // 䀬
	0x402d: "m\x06\u402d", // 䀭
	0x402e: "m\x06\u402e", // 䀮
	0x402f: "m\a\u402f", // 䀯
	0x4030: "m\a\u4030", // 䀰
	0x4031: "m\a\u4031", // 䀱
	0x4032: "m\a\u4032", // 䀲
	0x4033: "m\a\u4033", // 䀳
	0x4034: "m\a\u4034", // 䀴
	0x4035: "m\a\u4035", // 䀵
	0x4036: "m\a\u4036", // 䀶
	0x4037: "m\a\u4037", // 䀷
	0x4038: "m\a\u4038", // 䀸
	0x4039: "m\a\u4039", // 䀹
	0x403a: "m\a\u403a", // 䀺
	0x403b: "m\a\u403b", // 䀻
	0x403c: "m\a\u403c", // 䀼
	0x403d: "m\a\u403d", // 䀽
	0x403e: "m\a\u403e", // 䀾
	0x403f: "m\a\u403f", // 䀿
	0x4040: "m\a\u4040", // 䁀
	0x4041: "m\b\u4041", // 䁁
	0x4042: "m\b\u4042", // 䁂
	0x4043: "m\b\u4043", // 䁃
	0x4044: "m\b\u4044", // 䁄
	0x4045: "m\b\u4045", // 䁅
	0x4046: "m\b\u4046", // 䁆
	0x4047: "m\b\u4047", // 䁇
	0x4048: "m\b\u4048", // 䁈
	0x4049: "m\b\u4049", // 䁉
	0x404a: "m\t\u404a", // 䁊
	0x404b: "m\t\u404b", // 䁋
	0x404c: "m\t\u404c", // 䁌
	0x404d: "m\t\u404d", // 䁍
	0x404e: "m\t\u404e", // 䁎
	0x404f: "m\t\u404f", // 䁏
	0x4050: "m\t\u4050", // 䁐
	0x4051: "m\t\u4051", // 䁑
	0x4052: "m\t\u4052", // 䁒
	0x4053: "m\t\u4053", // 䁓
	0x4054: "m\t\u4054", // 䁔
	0x4055: "m\t\u4055", // 䁕
	0x4056: "m\t\u4056", // 䁖
	0x4057: "m\n\u4057", // 䁗
	0x4058: "m\n\u4058", // 䁘
	0x4059: "m\n\u4059", // 䁙
	0x405a: "m\n\u405a", // 䁚
	0x405b: "m\n\u405b", // 䁛
	0x405c: "m\n\u405c", // 䁜
	0x405d: "m\n\u405d", // 䁝
	0x405e: "m\n\u405e", // 䁞
	0x405f: "m\n\u405f", // 䁟
	0x4060: "m\n\u4060", // 䁠
	0x4061: "m\n\u4061", // 䁡
	0x4062: "m\v\u4062", // 䁢
	0x4063: "m\v\u4063", // 䁣
	0x4064: "m\v\u4064", // 䁤
	0x4065: "m\v\u4065", // 䁥
	0x4066: "m\v\u4066", // 䁦
	0x4067: "m\v\u4067", // 䁧
	0x4068: "m\v\u4068", // 䁨
	0x4069: "m\v\u4069", // 䁩
	0x406a: "m\v\u406a", // 䁪
	0x406b: "m\f\u406b", // 䁫
	0x406c: "m\f\u406c", // 䁬
	0x406d: "m\f\u406d", // 䁭
	0x406e: "m\f\u406e", // 䁮
	0x406f: "m\f\u406f", // 䁯
	0x4070: "m\f\u4070", // 䁰
	0x4071: "m\f\u4071", // 䁱
	0x4072: "m\f\u4072", // 䁲
	0x4073: "m\f\u4073", // 䁳
	0x4074: "m\r\u4074", // 䁴
	0x4075: "m\r\u4075", // 䁵
	0x4076: "m\r\u4076", // 䁶
	0x4077: "m\r\u4077", // 䁷
	0x4078: "m\r\u4078", // 䁸
	0x4079: "m\r\u4079", // 䁹
	0x407a: "m\r\u407a", // 䁺
	0x407b: "m\x0f\u407b", // 䁻
	0x407c: "m\x0f\u407c", // 䁼
	0x407d: "m\x0f\u407d", // 䁽
	0x407e: "m\x0f\u407e", // 䁾
	0x407f: "m\x10\u407f", // 䁿
	0x4080: "m\x10\u4080", // 䂀
	0x4081: "m\x11\u4081", // 䂁
	0x4082: "m\x12\u4082", // 䂂
	0x4083: "m\x12\u4083", // 䂃
	0x4084: "m\x14\u4084", // 䂄
	0x4085: "m\x19\u4085", // 䂅
	0x4086: "n\x03\u4086", // 䂆
	0x4087: "n\x04\u4087", // 䂇
	0x4088: "n\x06\u4088", // 䂈
	0x4089: "n\t\u4089", // 䂉
	0x408a: "n\f\u408a", // 䂊
	0x408b: "n\f\u408b", // 䂋
	0x408c: "n\f\u408c", // 䂌
	0x408d: "n\x0f\u408d", // 䂍
	0x408e: "n\x13\u408e", // 䂎
	0x408f: "o\x05\u408f", // 䂏
	0x4090: "o\x05\u4090", // 䂐
	0x4091: "o\x06\u4091", // 䂑
	0x4092: "o\x06\u4092", // 䂒
	0x4093: "o\a\u4093", // 䂓
	0x4094: "o\b\u4094", // 䂔
	0x4095: "o\t\u4095", // 䂕
	0x4096: "p\x01\u4096", // 䂖
	0x4097: "p\x02\u4097", // 䂗
	0x4098: "p\x03\u4098", // 䂘
	0x4099: "p\x03\u4099", // 䂙
	0x409a: "p\x04\u409a", // 䂚
	0x409b: "p\x04\u409b", // 䂛
	0x409c: "p\x04\u409c", // 䂜
	0x409d: "p\x04\u409d", // 䂝
	0x409e: "p\x04\u409e", // 䂞
	0x409f: "p\x05\u409f", // 䂟
	0x40a0: "p\x05\u40a0", // 䂠
	0x40a1: "p\x05\u40a1", // 䂡
	0x40a2: "p\x05\u40a2", // 䂢
	0x40a3: "p\x05\u40a3", // 䂣
	0x40a4: "p\x05\u40a4", // 䂤
	0x40a5: "p\x05\u40a5", // 䂥
	0x40a6: "p\x05\u40a6", // 䂦
	0x40a7: "p\x05\u40a7", // 䂧
	0x40a8: "p\x05\u40a8", // 䂨
	0x40a9: "p\x06\u40a9", // 䂩
	0x40aa: "p\x06\u40aa", // 䂪
	0x40ab: "p\x06\u40ab", // 䂫
	0x40ac: "p\x06\u40ac", // 䂬
	0x40ad: "p\x06\u40ad", // 䂭
	0x40ae: "p\x06\u40ae", // 䂮
	0x40af: "p\x06\u40af", // 䂯
	0x40b0: "p\a\u40b0", // 䂰
	0x40b1: "p\a\u40b1", // 䂱
	0x40b2: "p\a\u40b2", // 䂲
	0x40b3: "p\a\u40b3", // 䂳
	0x40b4: "p\a\u40b4", // 䂴
	0x40b5: "p\a\u40b5", // 䂵
	0x40b6: "p\a\u40b6", // 䂶
	0x40b7: "p\b\u40b7", // 䂷
	0x40b8: "p\b\u40b8", // 䂸
	0x40b9: "p\b\u40b9", // 䂹
	0x40ba: "p\b\u40ba", // 䂺
	0x40bb: "p\b\u40bb", // 䂻
	0x40bc: "p\b\u40bc", // 䂼
	0x40bd: "p\b\u40bd", // 䂽
	0x40be: "p\b\u40be", // 䂾
	0x40bf: "p\b\u40bf", // 䂿
	0x40c0: "p\b\u40c0", // 䃀
	0x40c1: "p\b\u40c1", // 䃁
	0x40c2: "p\b\u40c2", // 䃂
	0x40c3: "p\b\u40c3", // 䃃
	0x40c4: "p\b\u40c4", // 䃄
	0x40c5: "p\b\u40c5", // 䃅
	0x40c6: "p\b\u40c6", // 䃆
	0x40c7: "p\b\u40c7", // 䃇
	0x40c8: "p\t\u40c8", // 䃈
	0x40c9: "p\t\u40c9", // 䃉
	0x40ca: "p\t\u40ca", // 䃊
	0x40cb: "p\t\u40cb", // 䃋
	0x40cc: "p\t\u40cc", // 䃌
	0x40cd: "p\t\u40cd", // 䃍
	0x40ce: "p\t\u40ce", // 䃎
	0x40cf: "p\t\u40cf", // 䃏
	0x40d0: "p\t\u40d0", // 䃐
	0x40d1: "p\n\u40d1", // 䃑
	0x40d2: "p\n\u40d2", // 䃒
	0x40d3: "p\n\u40d3", // 䃓
	0x40d4: "p\n\u40d4", // 䃔
	0x40d5: "p\n\u40d5", // 䃕
	0x40d6: "p\n\u40d6", // 䃖
	0x40d7: "p\n\u40d7", // 䃗
	0x40d8: "p\v\u40d8", // 䃘
	0x40d9: "p\v\u40d9", // 䃙
	0x40da: "p\v\u40da", // 䃚
	0x40db: "p\v\u40db", // 䃛
	0x40dc: "p\v\u40dc", // 䃜
	0x40dd: "p\v\u40dd", // 䃝
	0x40de: "p\v\u40de", // 䃞
	0x40df: "p\f\u40df", // 䃟
	0x40e0: "p\v\u40e0", // 䃠
	0x40e1: "p\f\u40e1", // 䃡
	0x40e2: "p\f\u40e2", // 䃢
	0x40e3: "p\f\u40e3", // 䃣
	0x40e4: "p\f\u40e4", // 䃤
	0x40e5: "p\f\u40e5", // 䃥
	0x40e6: "p\f\u40e6", // 䃦
	0x40e7: "p\f\u40e7", // 䃧
	0x40e8: "p\f\u40e8", // 䃨
	0x40e9: "p\r\u40e9", // 䃩
	0x40ea: "p\r\u40ea", // 䃪
	0x40eb: "p\r\u40eb", // 䃫
	0x40ec: "p\r\u40ec", // 䃬
	0x40ed: "p\r\u40ed", // 䃭
	0x40ee: "p\r\u40ee", // 䃮
	0x40ef: "p\r\u40ef", // 䃯
	0x40f0: "p\x0e\u40f0", // 䃰
	0x40f1: "p\x0f\u40f1", // 䃱
	0x40f2: "p\x0f\u40f2", // 䃲
	0x40f3: "p\x0f\u40f3", // 䃳
	0x40f4: "p\x10\u40f4", // 䃴
	0x40f5: "p\x10\u40f5", // 䃵
	0x40f6: "p\x10\u40f6", // 䃶
	0x40f7: "p\x10\u40f7", // 䃷
	0x40f8: "p\x11\u40f8", // 䃸
	0x40f9: "p\x11\u40f9", // 䃹
	0x40fa: "p\x13\u40fa", // 䃺
	0x40fb: "p\x15\u40fb", // 䃻
	0x40fc: "q\x02\u40fc", // 䃼
	0x40fd: "q\x04\u40fd", // 䃽
	0x40fe: "q\x04\u40fe", // 䃾
	0x40ff: "q\x04\u40ff", // 䃿
	0x4100: "q\x04\u4100", // 䄀
	0x4101: "q\x05\u4101", // 䄁
	0x4102: "q\x05\u4102", // 䄂
	0x4103: "q\x05\u4103", // 䄃
	0x4104: "q\x06\u4104", // 䄄
	0x4105: "q\x06\u4105", // 䄅
	0x4106: "q\x06\u4106", // 䄆
	0x4107: "q\a\u4107", // 䄇
	0x4108: "q\a\u4108", // 䄈
	0x4109: "q\a\u4109", // 䄉
	0x410a: "q\a\u410a", // 䄊
	0x410b: "q\b\u410b", // 䄋
	0x410c: "q\b\u410c", // 䄌
	0x410d: "q\b\u410d", // 䄍
	0x410e: "q\b\u410e", // 䄎
	0x410f: "q\b\u410f", // 䄏
	0x4110: "q\b\u4110", // 䄐
	0x4111: "q\b\u4111", // 䄑
	0x4112: "q\b\u4112", // 䄒
	0x4113: "q\t\u4113", // 䄓
	0x4114: "q\t\u4114", // 䄔
	0x4115: "q\t\u4115", // 䄕
	0x4116: "q\t\u4116", // 䄖
	0x4117: "q\t\u4117", // 䄗
	0x4118: "q\n\u4118", // 䄘
	0x4119: "q\n\u4119", // 䄙
	0x411a: "q\v\u411a", // 䄚
	0x411b: "q\v\u411b", // 䄛
	0x411c: "q\v\u411c", // 䄜
	0x411d: "q\v\u411d", // 䄝
	0x411e: "q\v\u411e", // 䄞
	0x411f: "q\f\u411f", // 䄟
	0x4120: "q\r\u4120", // 䄠
	0x4121: "q\r\u4121", // 䄡
	0x4122: "q\x0e\u4122", // 䄢
	0x4123: "q\x0f\u4123", // 䄣
	0x4124: "q\x10\u4124", // 䄤
	0x4125: "q\x18\u4125", // 䄥
	0x4126: "s\x02\u4126", // 䄦
	0x4127: "s\x02\u4127", // 䄧
	0x4128: "s\x03\u4128", // 䄨
	0x4129: "s\x03\u4129", // 䄩
	0x412a: "s\x03\u412a", // 䄪
	0x412b: "s\x03\u412b", // 䄫
	0x412c: "s\x03\u412c", // 䄬
	0x412d: "s\x03\u412d", // 䄭
	0x412e: "s\x04\u412e", // 䄮
	0x412f: "s\x04\u412f", // 䄯
	0x4130: "s\x04\u4130", // 䄰
	0x4131: "s\x04\u4131", // 䄱
	0x4132: "s\x04\u4132", // 䄲
	0x4133: "s\x04\u4133", // 䄳
	0x4134: "s\x04\u4134", // 䄴
	0x4135: "s\x04\u4135", // 䄵
	0x4136: "s\x05\u4136", // 䄶
	0x4137: "s\x05\u4137", // 䄷
	0x4138: "s\x05\u4138", // 䄸
	0x4139: "s\x05\u4139", // 䄹
	0x413a: "s\x06\u413a", // 䄺
	0x413b: "s\x06\u413b", // 䄻
	0x413c: "s\x06\u413c", // 䄼
	0x413d: "s\x06\u413d", // 䄽
	0x413e: "s\x06\u413e", // 䄾
	0x413f: "s\x06\u413f", // 䄿
	0x4140: "s\x06\u4140", // 䅀
	0x4141: "s\x06\u4141", // 䅁
	0x4142: "s\x06\u4142", // 䅂
	0x4143: "s\x06\u4143", // 䅃
	0x4144: "s\x06\u4144", // 䅄
	0x4145: "s\x06\u4145", // 䅅
	0x4146: "s\x06\u4146", // 䅆
	0x4147: "s\x06\u4147", // 䅇
	0x4148: "s\x06\u4148", // 䅈
	0x4149: "s\x06\u4149", // 䅉
	0x414a: "s\x06\u414a", // 䅊
	0x414b: "s\a\u414b", // 䅋
	0x414c: "s\a\u414c", // 䅌
	0x414d: "s\a\u414d", // 䅍
	0x414e: "s\a\u414e", // 䅎
	0x414f: "s\a\u414f", // 䅏
	0x4150: "s\a\u4150", // 䅐
	0x4151: "s\a\u4151", // 䅑
	0x4152: "s\a\u4152", // 䅒
	0x4153: "s\a\u4153", // 䅓
	0x4154: "s\b\u4154", // 䅔
	0x4155: "s\b\u4155", // 䅕
	0x4156: "s\b\u4156", // 䅖
	0x4157: "s\b\u4157", // 䅗
	0x4158: "s\b\u4158", // 䅘
	0x4159: "s\b\u4159", // 䅙
	0x415a: "s\b\u415a", // 䅚
	0x415b: "s\b\u415b", // 䅛
	0x415c: "s\b\u415c", // 䅜
	0x415d: "s\b\u415d", // 䅝
	0x415e: "s\b\u415e", // 䅞
	0x415f: "s\b\u415f", // 䅟
	0x4160: "s\t\u4160", // 䅠
	0x4161: "s\t\u4161", // 䅡
	0x4162: "s\t\u4162", // 䅢
	0x4163: "s\t\u4163", // 䅣
	0x4164: "s\t\u4164", // 䅤
	0x4165: "s\t\u4165", // 䅥
	0x4166: "s\t\u4166", // 䅦
	0x4167: "s\t\u4167", // 䅧
	0x4168: "s\t\u4168", // 䅨
	0x4169: "s\t\u4169", // 䅩
	0x416a: "s\t\u416a", // 䅪
	0x416b: "s\t\u416b", // 䅫
	0x416c: "s\n\u416c", // 䅬
	0x416d: "s\n\u416d", // 䅭
	0x416e: "s\n\u416e", // 䅮
	0x416f: "s\n\u416f", // 䅯
	0x4170: "s\n\u4170", // 䅰
	0x4171: "s\n\u4171", // 䅱
	0x4172: "s\n\u4172", // 䅲
	0x4173: "s\n\u4173", // 䅳
	0x4174: "s\n\u4174", // 䅴
	0x4175: "s\n\u4175", // 䅵
	0x4176: "s\n\u4176", // 䅶
	0x4177: "s\v\u4177", // 䅷
	0x4178: "s\v\u4178", // 䅸
	0x4179: "s\v\u4179", // 䅹
	0x417a: "s\v\u417a", // 䅺
	0x417b: "s\v\u417b", // 䅻
	0x417c: "s\v\u417c", // 䅼
	0x417d: "s\v\u417d", // 䅽
	0x417e: "s\f\u417e", // 䅾
	0x417f: "s\f\u417f", // 䅿
	0x4180: "s\f\u4180", // 䆀
	0x4181: "s\r\u4181", // 䆁
	0x4182: "s\r\u4182", // 䆂
	0x4183: "s\r\u4183", // 䆃
	0x4184: "s\r\u4184", // 䆄
	0x4185: "s\r\u4185", // 䆅
	0x4186: "s\r\u4186", // 䆆
	0x4187: "s\r\u4187", // 䆇
	0x4188: "s\x0f\u4188", // 䆈
	0x4189: "s\x0f\u4189", // 䆉
	0x418a: "s\x10\u418a", // 䆊
	0x418b: "s\x10\u418b", // 䆋
	0x418c: "s\x10\u418c", // 䆌
	0x418d: "s\x10\u418d", // 䆍
	0x418e: "s\x11\u418e", // 䆎
	0x418f: "s\x11\u418f", // 䆏
	0x4190: "s\x19\u4190", // 䆐
	0x4191: "t\x02\u4191", // 䆑
	0x4192: "t\x03\u4192", // 䆒
	0x4193: "t\x04\u4193", // 䆓
	0x4194: "t\x04\u4194", // 䆔
	0x4195: "t\x04\u4195", // 䆕
	0x4196: "t\x04\u4196", // 䆖
	0x4197: "t\x05\u4197", // 䆗
	0x4198: "t\x05\u4198", // 䆘
	0x4199: "t\x05\u4199", // 䆙
	0x419a: "t\x06\u419a", // 䆚
	0x419b: "t\x06\u419b", // 䆛
	0x419c: "t\x06\u419c", // 䆜
	0x419d: "t\x06\u419d", // 䆝
	0x419e: "t\x06\u419e", // 䆞
	0x419f: "t\x06\u419f", // 䆟
	0x41a0: "t\x06\u41a0", // 䆠
	0x41a1: "t\a\u41a1", // 䆡
	0x41a2: "t\a\u41a2", // 䆢
	0x41a3: "t\a\u41a3", // 䆣
	0x41a4: "t\a\u41a4", // 䆤
	0x41a5: "t\a\u41a5", // 䆥
	0x41a6: "t\b\u41a6", // 䆦
	0x41a7: "t\b\u41a7", // 䆧
	0x41a8: "t\b\u41a8", // 䆨
	0x41a9: "t\b\u41a9", // 䆩
	0x41aa: "t\t\u41aa", // 䆪
	0x41ab: "t\t\u41ab", // 䆫
	0x41ac: "t\n\u41ac", // 䆬
	0x41ad: "t\n\u41ad", // 䆭
	0x41ae: "t\n\u41ae", // 䆮
	0x41af: "t\v\u41af", // 䆯
	0x41b0: "t\v\u41b0", // 䆰
	0x41b1: "t\v\u41b1", // 䆱
	0x41b2: "t\v\u41b2", // 䆲
	0x41b3: "t\v\u41b3", // 䆳
	0x41b4: "t\v\u41b4", // 䆴
	0x41b5: "t\f\u41b5", // 䆵
	0x41b6: "t\f\u41b6", // 䆶
	0x41b7: "t\f\u41b7", // 䆷
	0x41b8: "t\f\u41b8", // 䆸
	0x41b9: "t\f\u41b9", // 䆹
	0x41ba: "t\f\u41ba", // 䆺
	0x41bb: "t\f\u41bb", // 䆻
	0x41bc: "t\r\u41bc", // 䆼
	0x41bd: "t\r\u41bd", // 䆽
	0x41be: "t\x0e\u41be", // 䆾
	0x41bf: "t\x0e\u41bf", // 䆿
	0x41c0: "t\x0f\u41c0", // 䇀
	0x41c1: "t\x11\u41c1", // 䇁
	0x41c2: "u\x01\u41c2", // 䇂
	0x41c3: "u\x03\u41c3", // 䇃
	0x41c4: "u\x03\u41c4", // 䇄
	0x41c5: "u\x04\u41c5", // 䇅
	0x41c6: "u\x04\u41c6", // 䇆
	0x41c7: "u\x05\u41c7", // 䇇
	0x41c8: "u\x05\u41c8", // 䇈
	0x41c9: "u\x05\u41c9", // 䇉
	0x41ca: "u\x05\u41ca", // 䇊
	0x41cb: "u\x06\u41cb", // 䇋
	0x41cc: "u\a\u41cc", // 䇌
	0x41cd: "u\a\u41cd", // 䇍
	0x41ce: "u\b\u41ce", // 䇎
	0x41cf: "u\b\u41cf", // 䇏
	0x41d0: "u\b\u41d0", // 䇐
	0x41d1: "u\b\u41d1", // 䇑
	0x41d2: "u\v\u41d2", // 䇒
	0x41d3: "u\f\u41d3", // 䇓
	0x41d4: "u\r\u41d4", // 䇔
	0x41d5: "u\x0e\u41d5", // 䇕
	0x41d6: "v\x03\u41d6", // 䇖
	0x41d7: "v\x04\u41d7", // 䇗
	0x41d8: "v\x04\u41d8", // 䇘
	0x41d9: "v\x04\u41d9", // 䇙
	0x41da: "v\x04\u41da", // 䇚
	0x41db: "v\x04\u41db", // 䇛
	0x41dc: "v\x04\u41dc", // 䇜
	0x41dd: "v\x04\u41dd", // 䇝
	0x41de: "v\x05\u41de", // 䇞
	0x41df: "v\x05\u41df", // 䇟
	0x41e0: "v\x05\u41e0", // 䇠
	0x41e1: "v\x05\u41e1", // 䇡
	0x41e2: "v\x05\u41e2", // 䇢
	0x41e3: "v\x05\u41e3", // 䇣
	0x41e4: "v\x05\u41e4", // 䇤
	0x41e5: "v\x05\u41e5", // 䇥
	0x41e6: "v\x05\u41e6", // 䇦
	0x41e7: "v\x06\u41e7", // 䇧
	0x41e8: "v\x06\u41e8", // 䇨
	0x41e9: "v\x06\u41e9", // 䇩
	0x41ea: "v\x06\u41ea", // 䇪
	0x41eb: "v\x06\u41eb", // 䇫
	0x41ec: "v\x06\u41ec", // 䇬
	0x41ed: "v\x06\u41ed", // 䇭
	0x41ee: "v\x06\u41ee", // 䇮
	0x41ef: "v\x06\u41ef", // 䇯
	0x41f0: "v\x06\u41f0", // 䇰
	0x41f1: "v\x06\u41f1", // 䇱
	0x41f2: "v\x06\u41f2", // 䇲
	0x41f3: "v\x06\u41f3", // 䇳
	0x41f4: "v\x06\u41f4", // 䇴
	0x41f5: "v\a\u41f5", // 䇵
	0x41f6: "v\a\u41f6", // 䇶
	0x41f7: "v\a\u41f7", // 䇷
	0x41f8: "v\a\u41f8", // 䇸
	0x41f9: "v\a\u41f9", // 䇹
	0x41fa: "v\a\u41fa", // 䇺
	0x41fb: "v\a\u41fb", // 䇻
	0x41fc: "v\a\u41fc", // 䇼
	0x41fd: "v\a\u41fd", // 䇽
	0x41fe: "v\a\u41fe", // 䇾
	0x41ff: "v\a\u41ff", // 䇿
	0x4200: "v\a\u4200", // 䈀
	0x4201: "v\b\u4201", // 䈁
	0x4202: "v\b\u4202", // 䈂
	0x4203: "v\b\u4203", // 䈃
	0x4204: "v\b\u4204", // 䈄
	0x4205: "v\b\u4205", // 䈅
	0x4206: "v\b\u4206", // 䈆
	0x4207: "v\b\u4207", // 䈇
	0x4208: "v\b\u4208", // 䈈
	0x4209: "v\b\u4209", // 䈉
	0x420a: "v\b\u420a", // 䈊
	0x420b: "v\b\u420b", // 䈋
	0x420c: "v\b\u420c", // 䈌
	0x420d: "v\b\u420d", // 䈍
	0x420e: "v\t\u420e", // 䈎
	0x420f: "v\t\u420f", // 䈏
	0x4210: "v\t\u4210", // 䈐
	0x4211: "v\t\u4211", // 䈑
	0x4212: "v\t\u4212", // 䈒
	0x4213: "v\t\u4213", // 䈓
	0x4214: "v\t\u4214", // 䈔
	0x4215: "v\t\u4215", // 䈕
	0x4216: "v\t\u4216", // 䈖
	0x4217: "v\t\u4217", // 䈗
	0x4218: "v\t\u4218", // 䈘
	0x4219: "v\t\u4219", // 䈙
	0x421a: "v\t\u421a", // 䈚
	0x421b: "v\t\u421b", // 䈛
	0x421c: "v\t\u421c", // 䈜
	0x421d: "v\t\u421d", // 䈝
	0x421e: "v\t\u421e", // 䈞
	0x421f: "v\t\u421f", // 䈟
	0x4220: "v\t\u4220", // 䈠
	0x4221: "v\t\u4221", // 䈡
	0x4222: "v\t\u4222", // 䈢
	0x4223: "v\t\u4223", // 䈣
	0x4224: "v\t\u4224", // 䈤
	0x4225: "v\t\u4225", // 䈥
	0x4226: "v\t\u4226", // 䈦
	0x4227: "v\t\u4227", // 䈧
	0x4228: "v\t\u4228", // 䈨
	0x4229: "v\t\u4229", // 䈩
	0x422a: "v\n\u422a", // 䈪
	0x422b: "v\n\u422b", // 䈫
	0x422c: "v\n\u422c", // 䈬
	0x422d: "v\n\u422d", // 䈭
	0x422e: "v\n\u422e", // 䈮
	0x422f: "v\n\u422f", // 䈯
	0x4230: "v\n\u4230", // 䈰
	0x4231: "v\n\u4231", // 䈱
	0x4232: "v\n\u4232", // 䈲
	0x4233: "v\n\u4233", // 䈳
	0x4234: "v\n\u4234", // 䈴
	0x4235: "v\n\u4235", // 䈵
	0x4236: "v\n\u4236", // 䈶
	0x4237: "v\n\u4237", // 䈷
	0x4238: "v\v\u4238", // 䈸
	0x4239: "v\v\u4239", // 䈹
	0x423a: "v\v\u423a", // 䈺
	0x423b: "v\v\u423b", // 䈻
	0x423c: "v\v\u423c", // 䈼
	0x423d: "v\v\u423d", // 䈽
	0x423e: "v\v\u423e", // 䈾
	0x423f: "v\v\u423f", // 䈿
	0x4240: "v\v\u4240", // 䉀
	0x4241: "v\v\u4241", // 䉁
	0x4242: "v\v\u4242", // 䉂
	0x4243: "v\v\u4243", // 䉃
	0x4244: "v\v\u4244", // 䉄
	0x4245: "v\v\u4245", // 䉅
	0x4246: "v\v\u4246", // 䉆
	0x4247: "v\v\u4247", // 䉇
	0x4248: "v\f\u4248", // 䉈
	0x4249: "v\f\u4249", // 䉉
	0x424a: "v\f\u424a", // 䉊
	0x424b: "v\f\u424b", // 䉋
	0x424c: "v\f\u424c", // 䉌
	0x424d: "v\f\u424d", // 䉍
	0x424e: "v\f\u424e", // 䉎
	0x424f: "v\r\u424f", // 䉏
	0x4250: "v\f\u4250", // 䉐
	0x4251: "v\f\u4251", // 䉑
	0x4252: "v\f\u4252", // 䉒
	0x4253: "v\f\u4253", // 䉓
	0x4254: "v\f\u4254", // 䉔
	0x4255: "v\f\u4255", // 䉕
	0x4256: "v\f\u4256", // 䉖
	0x4257: "v\f\u4257", // 䉗
	0x4258: "v\f\u4258", // 䉘
	0x4259: "v\f\u4259", // 䉙
	0x425a: "v\f\u425a", // 䉚
	0x425b: "v\r\u425b", // 䉛
	0x425c: "v\r\u425c", // 䉜
	0x425d: "v\r\u425d", // 䉝
	0x425e: "v\r\u425e", // 䉞
	0x425f: "v\r\u425f", // 䉟
	0x4260: "v\r\u4260", // 䉠
	0x4261: "v\r\u4261", // 䉡
	0x4262: "v\r\u4262", // 䉢
	0x4263: "v\f\u4263", // 䉣
	0x4264: "v\r\u4264", // 䉤
	0x4265: "v\x0e\u4265", // 䉥
	0x4266: "v\x0f\u4266", // 䉦
	0x4267: "v\x0f\u4267", // 䉧
	0x4268: "v\x0f\u4268", // 䉨
	0x4269: "v\x0f\u4269", // 䉩
	0x426a: "v\x0f\u426a", // 䉪
	0x426b: "v\x0f\u426b", // 䉫
	0x426c: "v\x0f\u426c", // 䉬
	0x426d: "v\x0f\u426d", // 䉭
	0x426e: "v\x10\u426e", // 䉮
	0x426f: "v\x10\u426f", // 䉯
	0x4270: "v\x10\u4270", // 䉰
	0x4271: "v\x10\u4271", // 䉱
	0x4272: "v\x11\u4272", // 䉲
	0x4273: "v\x11\u4273", // 䉳
	0x4274: "v\x11\u4274", // 䉴
	0x4275: "\xb8\x0e\u4275", // 䉵
	0x4276: "v\x12\u4276", // 䉶
	0x4277: "v\x14\u4277", // 䉷
	0x4278: "v\x15\u4278", // 䉸
	0x4279: "v\x18\u4279", // 䉹
	0x427a: "w\x03\u427a", // 䉺
	0x427b: "w\x04\u427b", // 䉻
	0x427c: "w\x04\u427c", // 䉼
	0x427d: "w\x05\u427d", // 䉽
	0x427e: "w\x05\u427e", // 䉾
	0x427f: "w\x05\u427f", // 䉿
	0x4280: "w\x05\u4280", // 䊀
	0x4281: "w\x06\u4281", // 䊁
	0x4282: "w\x06\u4282", // 䊂
	0x4283: "w\x06\u4283", // 䊃
	0x4284: "w\x06\u4284", // 䊄
	0x4285: "w\x06\u4285", // 䊅
	0x4286: "w\x06\u4286", // 䊆
	0x4287: "w\a\u4287", // 䊇
	0x4288: "w\a\u4288", // 䊈
	0x4289: "w\a\u4289", // 䊉
	0x428a: "w\a\u428a", // 䊊
	0x428b: "w\a\u428b", // 䊋
	0x428c: "w\a\u428c", // 䊌
	0x428d: "w\b\u428d", // 䊍
	0x428e: "w\b\u428e", // 䊎
	0x428f: "w\b\u428f", // 䊏
	0x4290: "w\b\u4290", // 䊐
	0x4291: "w\b\u4291", // 䊑
	0x4292: "w\b\u4292", // 䊒
	0x4293: "w\t\u4293", // 䊓
	0x4294: "w\t\u4294", // 䊔
	0x4295: "w\t\u4295", // 䊕
	0x4296: "w\t\u4296", // 䊖
	0x4297: "w\t\u4297", // 䊗
	0x4298: "w\t\u4298", // 䊘
	0x4299: "w\t\u4299", // 䊙
	0x429a: "w\n\u429a", // 䊚
	0x429b: "w\n\u429b", // 䊛
	0x429c: "w\v\u429c", // 䊜
	0x429d: "w\v\u429d", // 䊝
	0x429e: "w\v\u429e", // 䊞
	0x429f: "w\v\u429f", // 䊟
	0x42a0: "w\v\u42a0", // 䊠
	0x42a1: "w\v\u42a1", // 䊡
	0x42a2: "w\v\u42a2", // 䊢
	0x42a3: "w\f\u42a3", // 䊣
	0x42a4: "w\f\u42a4", // 䊤
	0x42a5: "w\f\u42a5", // 䊥
	0x42a6: "w\f\u42a6", // 䊦
	0x42a7: "w\f\u42a7", // 䊧
	0x42a8: "w\f\u42a8", // 䊨
	0x42a9: "w\f\u42a9", // 䊩
	0x42aa: "w\r\u42aa", // 䊪
	0x42ab: "w\r\u42ab", // 䊫
	0x42ac: "w\r\u42ac", // 䊬
	0x42ad: "w\x0e\u42ad", // 䊭
	0x42ae: "w\x0e\u42ae", // 䊮
	0x42af: "w\x0f\u42af", // 䊯
	0x42b0: "w\x10\u42b0", // 䊰
	0x42b1: "w\x11\u42b1", // 䊱
	0x42b2: "w\x11\u42b2", // 䊲
	0x42b3: "w\x13\u42b3", // 䊳
	0x42b4: "w\x13\u42b4", // 䊴
	0x42b5: "x\x02\u42b5", // 䊵
	0x42b6: "x\x03\u42b6", // 䊶
	0x42b7: "x\x03\u42b7", // 䊷
	0x42b8: "x\x03\u42b8", // 䊸
	0x42b9: "x\x03\u42b9", // 䊹
	0x42ba: "x\x04\u42ba", // 䊺
	0x42bb: "x\x04\u42bb", // 䊻
	0x42bc: "x\x04\u42bc", // 䊼
	0x42bd: "x\x04\u42bd", // 䊽
	0x42be: "x\x04\u42be", // 䊾
	0x42bf: "x\x04\u42bf", // 䊿
	0x42c0: "x\x04\u42c0", // 䋀
	0x42c1: "x\x04\u42c1", // 䋁
	0x42c2: "x\x04\u42c2", // 䋂
	0x42c3: "x\x04\u42c3", // 䋃
	0x42c4: "x\x04\u42c4", // 䋄
	0x42c5: "x\x04\u42c5", // 䋅
	0x42c6: "x\x04\u42c6", // 䋆
	0x42c7: "x\x04\u42c7", // 䋇
	0x42c8: "x\x05\u42c8", // 䋈
	0x42c9: "x\x05\u42c9", // 䋉
	0x42ca: "x\x05\u42ca", // 䋊
	0x42cb: "x\x05\u42cb", // 䋋
	0x42cc: "x\x05\u42cc", // 䋌
	0x42cd: "x\x05\u42cd", // 䋍
	0x42ce: "x\x05\u42ce", // 䋎
	0x42cf: "x\x05\u42cf", // 䋏
	0x42d0: "x\x05\u42d0", // 䋐
	0x42d1: "x\x05\u42d1", // 䋑
	0x42d2: "x\x05\u42d2", // 䋒
	0x42d3: "x\x05\u42d3", // 䋓
	0x42d4: "x\x05\u42d4", // 䋔
	0x42d5: "x\x06\u42d5", // 䋕
	0x42d6: "x\x06\u42d6", // 䋖
	0x42d7: "x\x06\u42d7", // 䋗
	0x42d8: "x\x06\u42d8", // 䋘
	0x42d9: "x\x06\u42d9", // 䋙
	0x42da: "x\x06\u42da", // 䋚
	0x42db: "x\x06\u42db", // 䋛
	0x42dc: "x\x06\u42dc", // 䋜
	0x42dd: "x\x06\u42dd", // 䋝
	0x42de: "x\x06\u42de", // 䋞
	0x42df: "x\a\u42df", // 䋟
	0x42e0: "x\a\u42e0", // 䋠
	0x42e1: "x\a\u42e1", // 䋡
	0x42e2: "x\a\u42e2", // 䋢
	0x42e3: "x\a\u42e3", // 䋣
	0x42e4: "x\a\u42e4", // 䋤
	0x42e5: "x\a\u42e5", // 䋥
	0x42e6: "x\a\u42e6", // 䋦
	0x42e7: "x\b\u42e7", // 䋧
	0x42e8: "x\b\u42e8", // 䋨
	0x42e9: "x\b\u42e9", // 䋩
	0x42ea: "x\b\u42ea", // 䋪
	0x42eb: "x\b\u42eb", // 䋫
	0x42ec: "x\b\u42ec", // 䋬
	0x42ed: "x\b\u42ed", // 䋭
	0x42ee: "x\b\u42ee", // 䋮
	0x42ef: "x\b\u42ef", // 䋯
	0x42f0: "x\b\u42f0", // 䋰
	0x42f1: "x\b\u42f1", // 䋱
	0x42f2: "x\b\u42f2", // 䋲
	0x42f3: "x\t\u42f3", // 䋳
	0x42f4: "x\t\u42f4", // 䋴
	0x42f5: "x\t\u42f5", // 䋵
	0x42f6: "x\t\u42f6", // 䋶
	0x42f7: "x\t\u42f7", // 䋷
	0x42f8: "x\t\u42f8", // 䋸
	0x42f9: "x\t\u42f9", // 䋹
	0x42fa: "x\t\u42fa", // 䋺
	0x42fb: "x\t\u42fb", // 䋻
	0x42fc: "x\t\u42fc", // 䋼
	0x42fd: "x\t\u42fd", // 䋽
	0x42fe: "x\t\u42fe", // 䋾
	0x42ff: "x\t\u42ff", // 䋿
	0x4300: "x\t\u4300", // 䌀
	0x4301: "x\t\u4301", // 䌁
	0x4302: "x\t\u4302", // 䌂
	0x4303: "x\t\u4303", // 䌃
	0x4304: "x\t\u4304", // 䌄
	0x4305: "x\n\u4305", // 䌅
	0x4306: "x\n\u4306", // 䌆
	0x4307: "x\n\u4307", // 䌇
	0x4308: "x\n\u4308", // 䌈
	0x4309: "x\n\u4309", // 䌉
	0x430a: "x\n\u430a", // 䌊
	0x430b: "x\n\u430b", // 䌋
	0x430c: "x\v\u430c", // 䌌
	0x430d: "x\v\u430d", // 䌍
	0x430e: "x\v\u430e", // 䌎
	0x430f: "x\v\u430f", // 䌏
	0x4310: "x\v\u4310", // 䌐
	0x4311: "x\v\u4311", // 䌑
	0x4312: "x\v\u4312", // 䌒
	0x4313: "x\v\u4313", // 䌓
	0x4314: "x\v\u4314", // 䌔
	0x4315: "x\v\u4315", // 䌕
	0x4316: "x\f\u4316", // 䌖
	0x4317: "x\f\u4317", // 䌗
	0x4318: "x\f\u4318", // 䌘
	0x4319: "x\f\u4319", // 䌙
	0x431a: "x\f\u431a", // 䌚
	0x431b: "x\f\u431b", // 䌛
	0x431c: "x\r\u431c", // 䌜
	0x431d: "x\r\u431d", // 䌝
	0x431e: "x\r\u431e", // 䌞
	0x431f: "x\r\u431f", // 䌟
	0x4320: "x\r\u4320", // 䌠
	0x4321: "x\r\u4321", // 䌡
	0x4322: "x\r\u4322", // 䌢
	0x4323: "x\x0e\u4323", // 䌣
	0x4324: "x\x0e\u4324", // 䌤
	0x4325: "x\x0e\u4325", // 䌥
	0x4326: "x\x0e\u4326", // 䌦
	0x4327: "x\x0e\u4327", // 䌧
	0x4328: "x\x0f\u4328", // 䌨
	0x4329: "x\x0f\u4329", // 䌩
	0x432a: "x\x10\u432a", // 䌪
	0x432b: "x\x10\u432b", // 䌫
	0x432c: "x\x10\u432c", // 䌬
	0x432d: "x\x10\u432d", // 䌭
	0x432e: "x\x11\u432e", // 䌮
	0x432f: "x\x12\u432f", // 䌯
	0x4330: "x\x12\u4330", // 䌰
	0x4331: "x\x12\u4331", // 䌱
	0x4332: "x\x12\u4332", // 䌲
	0x4333: "x\x13\u4333", // 䌳
	0x4334: "x\x13\u4334", // 䌴
	0x4335: "x\x15\u4335", // 䌵
	0x4336: "x\x03\u4336", // 䌶
	0x4337: "x\x05\u4337", // 䌷
	0x4338: "x\x04\u4338", // 䌸
	0x4339: "x\x05\u4339", // 䌹
	0x433a: "x\x06\u433a", // 䌺
	0x433b: "x\x06\u433b", // 䌻
	0x433c: "x\a\u433c", // 䌼
	0x433d: "x\b\u433d", // 䌽
	0x433e: "x\t\u433e", // 䌾
	0x433f: "x\t\u433f", // 䌿
	0x4340: "x\n\u4340", // 䍀
	0x4341: "x\r\u4341", // 䍁
	0x4342: "y\x03\u4342", // 䍂
	0x4343: "y\x04\u4343", // 䍃
	0x4344: "y\x05\u4344", // 䍄
	0x4345: "y\x05\u4345", // 䍅
	0x4346: "y\x05\u4346", // 䍆
	0x4347: "y\x05\u4347", // 䍇
	0x4348: "y\x05\u4348", // 䍈
	0x4349: "y\x05\u4349", // 䍉
	0x434a: "y\x06\u434a", // 䍊
	0x434b: "y\b\u434b", // 䍋
	0x434c: "y\b\u434c", // 䍌
	0x434d: "y\n\u434d", // 䍍
	0x434e: "y\x11\u434e", // 䍎
	0x434f: "z\x00\u434f", // 䍏
	0x4350: "z\x03\u4350", // 䍐
	0x4351: "z\x03\u4351", // 䍑
	0x4352: "z\x04\u4352", // 䍒
	0x4353: "z\x04\u4353", // 䍓
	0x4354: "z\x04\u4354", // 䍔
	0x4355: "z\x05\u4355", // 䍕
	0x4356: "z\x05\u4356", // 䍖
	0x4357: "z\x05\u4357", // 䍗
	0x4358: "z\x06\u4358", // 䍘
	0x4359: "z\a\u4359", // 䍙
	0x435a: "z\a\u435a", // 䍚
	0x435b: "z\b\u435b", // 䍛
	0x435c: "z\b\u435c", // 䍜
	0x435d: "z\b\u435d", // 䍝
	0x435e: "z\b\u435e", // 䍞
	0x435f: "z\t\u435f", // 䍟
	0x4360: "z\v\u4360", // 䍠
	0x4361: "z\v\u4361", // 䍡
	0x4362: "z\f\u4362", // 䍢
	0x4363: "z\r\u4363", // 䍣
	0x4364: "z\x0e\u4364", // 䍤
	0x4365: "z\x10\u4365", // 䍥
	0x4366: "z\x13\u4366", // 䍦
	0x4367: "{\x04\u4367", // 䍧
	0x4368: "{\x04\u4368", // 䍨
	0x4369: "{\x04\u4369", // 䍩
	0x436a: "{\x05\u436a", // 䍪
	0x436b: "{\x05\u436b", // 䍫
	0x436c: "{\x05\u436c", // 䍬
	0x436d: "{\x05\u436d", // 䍭
	0x436e: "{\x06\u436e", // 䍮
	0x436f: "{\x06\u436f", // 䍯
	0x4370: "{\x06\u4370", // 䍰
	0x4371: "{\a\u4371", // 䍱
	0x4372: "{\b\u4372", // 䍲
	0x4373: "{\b\u4373", // 䍳
	0x4374: "{\b\u4374", // 䍴
	0x4375: "{\b\u4375", // 䍵
	0x4376: "{\b\u4376", // 䍶
	0x4377: "{\t\u4377", // 䍷
	0x4378: "{\n\u4378", // 䍸
	0x4379: "{\n\u4379", // 䍹
	0x437a: "{\v\u437a", // 䍺
	0x437b: "{\f\u437b", // 䍻
	0x437c: "{\f\u437c", // 䍼
	0x437d: "{\x10\u437d", // 䍽
	0x437e: "|\x04\u437e", // 䍾
	0x437f: "|\x04\u437f", // 䍿
	0x4380: "|\x05\u4380", // 䎀
	0x4381: "|\x05\u4381", // 䎁
	0x4382: "|\x05\u4382", // 䎂
	0x4383: "|\x05\u4383", // 䎃
	0x4384: "|\x05\u4384", // 䎄
	0x4385: "|\x05\u4385", // 䎅
	0x4386: "|\x05\u4386", // 䎆
	0x4387: "|\x06\u4387", // 䎇
	0x4388: "|\x06\u4388", // 䎈
	0x4389: "|\x06\u4389", // 䎉
	0x438a: "|\x06\u438a", // 䎊
	0x438b: "|\a\u438b", // 䎋
	0x438c: "|\a\u438c", // 䎌
	0x438d: "|\a\u438d", // 䎍
	0x438e: "|\a\u438e", // 䎎
	0x438f: "|\b\u438f", // 䎏
	0x4390: "|\b\u4390", // 䎐
	0x4391: "|\b\u4391", // 䎑
	0x4392: "|\b\u4392", // 䎒
	0x4393: "|\b\u4393", // 䎓
	0x4394: "|\n\u4394", // 䎔
	0x4395: "|\n\u4395", // 䎕
	0x4396: "|\f\u4396", // 䎖
	0x4397: "|\f\u4397", // 䎗
	0x4398: "|\f\u4398", // 䎘
	0x4399: "|\x0e\u4399", // 䎙
	0x439a: "|\x0f\u439a", // 䎚
	0x439b: "}\x03\u439b", // 䎛
	0x439c: "}\x06\u439c", // 䎜
	0x439d: "}\x06\u439d", // 䎝
	0x439e: "}\x06\u439e", // 䎞
	0x439f: "~\x03\u439f", // 䎟
	0x43a0: "~\x03\u43a0", // 䎠
	0x43a1: "~\x04\u43a1", // 䎡
	0x43a2: "\u007f\x03\u43a2", // 䎢
	0x43a3: "\u007f\x05\u43a3", // 䎣
	0x43a4: "\u007f\a\u43a4", // 䎤
	0x43a5: "\u007f\a\u43a5", // 䎥
	0x43a6: "\u007f\b\u43a6", // 䎦
	0x43a7: "\u007f\b\u43a7", // 䎧
	0x43a8: "\u007f\b\u43a8", // 䎨
	0x43a9: "\u007f\b\u43a9", // 䎩
	0x43aa: "\u007f\b\u43aa", // 䎪
	0x43ab: "\u007f\t\u43ab", // 䎫
	0x43ac: "\u007f\t\u43ac", // 䎬
	0x43ad: "\u007f\v\u43ad", // 䎭
	0x43ae: "\u007f\v\u43ae", // 䎮
	0x43af: "\u007f\v\u43af", // 䎯
	0x43b0: "\u007f\f\u43b0", // 䎰
	0x43b1: "\u007f\x0f\u43b1", // 䎱
	0x43b2: "\x80\x01\u43b2", // 䎲
	0x43b3: "\x80\x04\u43b3", // 䎳
	0x43b4: "\x80\x04\u43b4", // 䎴
	0x43b5: "\x80\x05\u43b5", // 䎵
	0x43b6: "\x80\x05\u43b6", // 䎶
	0x43b7: "\x80\x06\u43b7", // 䎷
	0x43b8: "\x80\a\u43b8", // 䎸
	0x43b9: "\x80\a\u43b9", // 䎹
	0x43ba: "\x80\b\u43ba", // 䎺
	0x43bb: "\x80\b\u43bb", // 䎻
	0x43bc: "\x80\b\u43bc", // 䎼
	0x43bd: "\x80\b\u43bd", // 䎽
	0x43be: "\x80\b\u43be", // 䎾
	0x43bf: "\x80\t\u43bf", // 䎿
	0x43c0: "\x80\t\u43c0", // 䏀
	0x43c1: "\x80\n\u43c1", // 䏁
	0x43c2: "\x80\n\u43c2", // 䏂
	0x43c3: "\x80\n\u43c3", // 䏃
	0x43c4: "\x80\v\u43c4", // 䏄
	0x43c5: "\x80\v\u43c5", // 䏅
	0x43c6: "\x80\v\u43c6", // 䏆
	0x43c7: "\x80\v\u43c7", // 䏇
	0x43c8: "\x80\f\u43c8", // 䏈
	0x43c9: "\x80\x0e\u43c9", // 䏉
	0x43ca: "\x80\x10\u43ca", // 䏊
	0x43cb: "\x81\a\u43cb", // 䏋
	0x43cc: "\x82\x02\u43cc", // 䏌
	0x43cd: "\x82\x02\u43cd", // 䏍
	0x43ce: "\x82\x03\u43ce", // 䏎
	0x43cf: "\x82\x03\u43cf", // 䏏
	0x43d0: "\x82\x04\u43d0", // 䏐
	0x43d1: "\x82\x04\u43d1", // 䏑
	0x43d2: "\x82\x04\u43d2", // 䏒
	0x43d3: "\x82\x04\u43d3", // 䏓
	0x43d4: "\x82\x04\u43d4", // 䏔
	0x43d5: "\x82\x04\u43d5", // 䏕
	0x43d6: "\x82\x04\u43d6", // 䏖
	0x43d7: "\x82\x04\u43d7", // 䏗
	0x43d8: "\x82\x04\u43d8", // 䏘
	0x43d9: "\x82\x04\u43d9", // 䏙
	0x43da: "\x82\x04\u43da", // 䏚
	0x43db: "\x82\x04\u43db", // 䏛
	0x43dc: "\x82\x04\u43dc", // 䏜
	0x43dd: "\x82\x04\u43dd", // 䏝
	0x43de: "\x82\x05\u43de", // 䏞
	0x43df: "\x82\x05\u43df", // 䏟
	0x43e0: "\x82\x05\u43e0", // 䏠
	0x43e1: "\x82\x05\u43e1", // 䏡
	0x43e2: "\x82\x05\u43e2", // 䏢
	0x43e3: "\x82\x05\u43e3", // 䏣
	0x43e4: "\x82\x05\u43e4", // 䏤
	0x43e5: "\x82\x05\u43e5", // 䏥
	0x43e6: "\x82\x06\u43e6", // 䏦
	0x43e7: "\x82\x06\u43e7", // 䏧
	0x43e8: "\x82\x06\u43e8", // 䏨
	0x43e9: "\x82\x06\u43e9", // 䏩
	0x43ea: "\x82\x06\u43ea", // 䏪
	0x43eb: "\x82\x06\u43eb", // 䏫
	0x43ec: "\x82\x06\u43ec", // 䏬
	0x43ed: "\x82\x06\u43ed", // 䏭
	0x43ee: "\x82\x06\u43ee", // 䏮
	0x43ef: "\x82\a\u43ef", // 䏯
	0x43f0: "\x82\a\u43f0", // 䏰
	0x43f1: "\x82\a\u43f1", // 䏱
	0x43f2: "\x82\a\u43f2", // 䏲
	0x43f3: "\x82\a\u43f3", // 䏳
	0x43f4: "\x82\a\u43f4", // 䏴
	0x43f5: "\x82\a\u43f5", // 䏵
	0x43f6: "\x82\a\u43f6", // 䏶
	0x43f7: "\x82\a\u43f7", // 䏷
	0x43f8: "\x82\a\u43f8", // 䏸
	0x43f9: "\x82\a\u43f9", // 䏹
	0x43fa: "\x82\a\u43fa", // 䏺
	0x43fb: "\x82\a\u43fb", // 䏻
	0x43fc: "\x82\b\u43fc", // 䏼
	0x43fd: "\x82\b\u43fd", // 䏽
	0x43fe: "\x82\b\u43fe", // 䏾
	0x43ff: "\x82\b\u43ff", // 䏿
	0x4400: "\x82\b\u4400", // 䐀
	0x4401: "\x82\b\u4401", // 䐁
	0x4402: "\x82\b\u4402", // 䐂
	0x4403: "\x82\b\u4403", // 䐃
	0x4404: "\x82\b\u4404", // 䐄
	0x4405: "\x82\b\u4405", // 䐅
	0x4406: "\x82\b\u4406", // 䐆
	0x4407: "\x82\b\u4407", // 䐇
	0x4408: "\x82\b\u4408", // 䐈
	0x4409: "\x82\b\u4409", // 䐉
	0x440a: "\x82\b\u440a", // 䐊
	0x440b: "\x82\b\u440b", // 䐋
	0x440c: "\x82\b\u440c", // 䐌
	0x440d: "\x82\t\u440d", // 䐍
	0x440e: "\x82\t\u440e", // 䐎
	0x440f: "\x82\t\u440f", // 䐏
	0x4410: "\x82\t\u4410", // 䐐
	0x4411: "\x82\t\u4411", // 䐑
	0x4412: "\x82\t\u4412", // 䐒
	0x4413: "\x82\t\u4413", // 䐓
	0x4414: "\x82\t\u4414", // 䐔
	0x4415: "\x82\t\u4415", // 䐕
	0x4416: "\x82\t\u4416", // 䐖
	0x4417: "\x82\t\u4417", // 䐗
	0x4418: "\x82\t\u4418", // 䐘
	0x4419: "\x82\t\u4419", // 䐙
	0x441a: "\x82\t\u441a", // 䐚
	0x441b: "\x82\t\u441b", // 䐛
	0x441c: "\x82\n\u441c", // 䐜
	0x441d: "\x82\n\u441d", // 䐝
	0x441e: "\x82\n\u441e", // 䐞
	0x441f: "\x82\n\u441f", // 䐟
	0x4420: "\x82\n\u4420", // 䐠
	0x4421: "\x82\n\u4421", // 䐡
	0x4422: "\x82\n\u4422", // 䐢
	0x4423: "\x82\n\u4423", // 䐣
	0x4424: "\x82\n\u4424", // 䐤
	0x4425: "\x82\n\u4425", // 䐥
	0x4426: "\x82\n\u4426", // 䐦
	0x4427: "\x82\n\u4427", // 䐧
	0x4428: "\x82\n\u4428", // 䐨
	0x4429: "\x82\n\u4429", // 䐩
	0x442a: "\x82\n\u442a", // 䐪
	0x442b: "\x82\v\u442b", // 䐫
	0x442c: "\x82\v\u442c", // 䐬
	0x442d: "\x82\v\u442d", // 䐭
	0x442e: "\x82\v\u442e", // 䐮
	0x442f: "\x82\v\u442f", // 䐯
	0x4430: "\x82\v\u4430", // 䐰
	0x4431: "\x82\v\u4431", // 䐱
	0x4432: "\x82\v\u4432", // 䐲
	0x4433: "\x82\v\u4433", // 䐳
	0x4434: "\x82\v\u4434", // 䐴
	0x4435: "\x82\f\u4435", // 䐵
	0x4436: "\x82\f\u4436", // 䐶
	0x4437: "\x82\f\u4437", // 䐷
	0x4438: "\x82\f\u4438", // 䐸
	0x4439: "\x82\f\u4439", // 䐹
	0x443a: "\x82\f\u443a", // 䐺
	0x443b: "\x82\f\u443b", // 䐻
	0x443c: "\x82\f\u443c", // 䐼
	0x443d: "\x82\f\u443d", // 䐽
	0x443e: "\x82\r\u443e", // 䐾
	0x443f: "\x82\r\u443f", // 䐿
	0x4440: "\x82\r\u4440", // 䑀
	0x4441: "\x82\r\u4441", // 䑁
	0x4442: "\x82\x0e\u4442", // 䑂
	0x4443: "\x82\x0e\u4443", // 䑃
	0x4444: "\x82\x0e\u4444", // 䑄
	0x4445: "\x82\x0e\u4445", // 䑅
	0x4446: "\x82\x0f\u4446", // 䑆
	0x4447: "\x82\x0f\u4447", // 䑇
	0x4448: "\x82\x0f\u4448", // 䑈
	0x4449: "\x82\x10\u4449", // 䑉
	0x444a: "\x82\x10\u444a", // 䑊
	0x444b: "\x82\x11\u444b", // 䑋
	0x444c: "\x82\x11\u444c", // 䑌
	0x444d: "\x82\x11\u444d", // 䑍
	0x444e: "\x82\x11\u444e", // 䑎
	0x444f: "\x82\x12\u444f", // 䑏
	0x4450: "\x83\x05\u4450", // 䑐
	0x4451: "\x83\f\u4451", // 䑑
	0x4452: "\x85\x03\u4452", // 䑒
	0x4453: "\x85\a\u4453", // 䑓
	0x4454: "\x86\x04\u4454", // 䑔
	0x4455: "\x86\x05\u4455", // 䑕
	0x4456: "\x86\b\u4456", // 䑖
	0x4457: "\x86\t\u4457", // 䑗
	0x4458: "\x86\n\u4458", // 䑘
	0x4459: "\x87\x04\u4459", // 䑙
	0x445a: "\x87\x04\u445a", // 䑚
	0x445b: "\x87\x05\u445b", // 䑛
	0x445c: "\x87\t\u445c", // 䑜
	0x445d: "\x88\b\u445d", // 䑝
	0x445e: "\x88\n\u445e", // 䑞
	0x445f: "\x88\x0f\u445f", // 䑟
	0x4460: "\x89\x02\u4460", // 䑠
	0x4461: "\x89\x03\u4461", // 䑡
	0x4462: "\x89\x03\u4462", // 䑢
	0x4463: "\x89\x03\u4463", // 䑣
	0x4464: "\x89\x04\u4464", // 䑤
	0x4465: "\x89\x04\u4465", // 䑥
	0x4466: "\x89\x05\u4466", // 䑦
	0x4467: "\x89\x05\u4467", // 䑧
	0x4468: "\x89\x05\u4468", // 䑨
	0x4469: "\x89\x05\u4469", // 䑩
	0x446a: "\x89\x06\u446a", // 䑪
	0x446b: "\x89\x06\u446b", // 䑫
	0x446c: "\x89\x06\u446c", // 䑬
	0x446d: "\x89\x06\u446d", // 䑭
	0x446e: "\x89\x06\u446e", // 䑮
	0x446f: "\x89\a\u446f", // 䑯
	0x4470: "\x89\a\u4470", // 䑰
	0x4471: "\x89\b\u4471", // 䑱
	0x4472: "\x89\b\u4472", // 䑲
	0x4473: "\x89\b\u4473", // 䑳
	0x4474: "\x89\b\u4474", // 䑴
	0x4475: "\x89\b\u4475", // 䑵
	0x4476: "\x89\b\u4476", // 䑶
	0x4477: "\x89\b\u4477", // 䑷
	0x4478: "\x89\b\u4478", // 䑸
	0x4479: "\x89\t\u4479", // 䑹
	0x447a: "\x89\t\u447a", // 䑺
	0x447b: "\x89\t\u447b", // 䑻
	0x447c: "\x89\n\u447c", // 䑼
	0x447d: "\x89\n\u447d", // 䑽
	0x447e: "\x89\n\u447e", // 䑾
	0x447f: "\x89\v\u447f", // 䑿
	0x4480: "\x89\v\u4480", // 䒀
	0x4481: "\x89\v\u4481", // 䒁
	0x4482: "\x89\v\u4482", // 䒂
	0x4483: "\x89\v\u4483", // 䒃
	0x4484: "\x89\v\u4484", // 䒄
	0x4485: "\x89\v\u4485", // 䒅
	0x4486: "\x89\f\u4486", // 䒆
	0x4487: "\x89\f\u4487", // 䒇
	0x4488: "\x89\f\u4488", // 䒈
	0x4489: "\x89\x0e\u4489", // 䒉
	0x448a: "\x8b\x03\u448a", // 䒊
	0x448b: "\x8b\x05\u448b", // 䒋
	0x448c: "\x8b\n\u448c", // 䒌
	0x448d: "\x8b\n\u448d", // 䒍
	0x448e: "\x8b\f\u448e", // 䒎
	0x448f: "\x8b\f\u448f", // 䒏
	0x4490: "\x8b\x10\u4490", // 䒐
	0x4491: "\x8c\x00\u4491", // 䒑
	0x4492: "\x8c\x02\u4492", // 䒒
	0x4493: "\x8c\x02\u4493", // 䒓
	0x4494: "\x8c\x02\u4494", // 䒔
	0x4495: "\x8c\x03\u4495", // 䒕
	0x4496: "\x8c\x03\u4496", // 䒖
	0x4497: "\x8c\x03\u4497", // 䒗
	0x4498: "\x8c\x03\u4498", // 䒘
	0x4499: "\x8c\x03\u4499", // 䒙
	0x449a: "\x8c\x04\u449a", // 䒚
	0x449b: "\x8c\x04\u449b", // 䒛
	0x449c: "\x8c\x04\u449c", // 䒜
	0x449d: "\x8c\x04\u449d", // 䒝
	0x449e: "\x8c\x04\u449e", // 䒞
	0x449f: "\x8c\x04\u449f", // 䒟
	0x44a0: "\x8c\x04\u44a0", // 䒠
	0x44a1: "\x8c\x04\u44a1", // 䒡
	0x44a2: "\x8c\x04\u44a2", // 䒢
	0x44a3: "\x8c\x04\u44a3", // 䒣
	0x44a4: "\x8c\x04\u44a4", // 䒤
	0x44a5: "\x8c\x04\u44a5", // 䒥
	0x44a6: "\x8c\x05\u44a6", // 䒦
	0x44a7: "\x8c\x05\u44a7", // 䒧
	0x44a8: "\x8c\x05\u44a8", // 䒨
	0x44a9: "\x8c\x05\u44a9", // 䒩
	0x44aa: "\x8c\x05\u44aa", // 䒪
	0x44ab: "\x8c\x05\u44ab", // 䒫
	0x44ac: "\x8c\x05\u44ac", // 䒬
	0x44ad: "\x8c\x05\u44ad", // 䒭
	0x44ae: "\x8c\x05\u44ae", // 䒮
	0x44af: "\x8c\x05\u44af", // 䒯
	0x44b0: "\x8c\x06\u44b0", // 䒰
	0x44b1: "\x8c\x06\u44b1", // 䒱
	0x44b2: "\x8c\x06\u44b2", // 䒲
	0x44b3: "\x8c\x06\u44b3", // 䒳
	0x44b4: "\x8c\x06\u44b4", // 䒴
	0x44b5: "\x8c\x06\u44b5", // 䒵
	0x44b6: "\x8c\x06\u44b6", // 䒶
	0x44b7: "\x8c\x06\u44b7", // 䒷
	0x44b8: "\x8c\x06\u44b8", // 䒸
	0x44b9: "\x8c\x06\u44b9", // 䒹
	0x44ba: "\x8c\x06\u44ba", // 䒺
	0x44bb: "\x8c\x06\u44bb", // 䒻
	0x44bc: "\x8c\x06\u44bc", // 䒼
	0x44bd: "\x8c\x06\u44bd", // 䒽
	0x44be: "\x8c\x06\u44be", // 䒾
	0x44bf: "\x8c\x06\u44bf", // 䒿
	0x44c0: "\x8c\x06\u44c0", // 䓀
	0x44c1: "\x8c\x06\u44c1", // 䓁
	0x44c2: "\x8c\a\u44c2", // 䓂
	0x44c3: "\x8c\a\u44c3", // 䓃
	0x44c4: "\x8c\a\u44c4", // 䓄
	0x44c5: "\x8c\a\u44c5", // 䓅
	0x44c6: "\x8c\a\u44c6", // 䓆
	0x44c7: "\x8c\a\u44c7", // 䓇
	0x44c8: "\x8c\a\u44c8", // 䓈
	0x44c9: "\x8c\a\u44c9", // 䓉
	0x44ca: "\x8c\a\u44ca", // 䓊
	0x44cb: "\x8c\a\u44cb", // 䓋
	0x44cc: "\x8c\a\u44cc", // 䓌
	0x44cd: "\x8c\a\u44cd", // 䓍
	0x44ce: "\x8c\a\u44ce", // 䓎
	0x44cf: "\x8c\a\u44cf", // 䓏
	0x44d0: "\x8c\a\u44d0", // 䓐
	0x44d1: "\x8c\a\u44d1", // 䓑
	0x44d2: "\x8c\a\u44d2", // 䓒
	0x44d3: "\x8c\a\u44d3", // 䓓
	0x44d4: "\x8c\a\u44d4", // 䓔
	0x44d5: "\x8c\b\u44d5", // 䓕
	0x44d6: "\x8c\a\u44d6", // 䓖
	0x44d7: "\x8c\b\u44d7", // 䓗
	0x44d8: "\x8c\b\u44d8", // 䓘
	0x44d9: "\x8c\b\u44d9", // 䓙
	0x44da: "\x8c\b\u44da", // 䓚
	0x44db: "\x8c\b\u44db", // 䓛
	0x44dc: "\x8c\b\u44dc", // 䓜
	0x44dd: "\x8c\b\u44dd", // 䓝
	0x44de: "\x8c\b\u44de", // 䓞
	0x44df: "\x8c\b\u44df", // 䓟
	0x44e0: "\x8c\b\u44e0", // 䓠
	0x44e1: "\x8c\b\u44e1", // 䓡
	0x44e2: "\x8c\b\u44e2", // 䓢
	0x44e3: "\x8c\b\u44e3", // 䓣
	0x44e4: "\x8c\b\u44e4", // 䓤
	0x44e5: "\x8c\b\u44e5", // 䓥
	0x44e6: "\x8c\b\u44e6", // 䓦
	0x44e7: "\x8c\b\u44e7", // 䓧
	0x44e8: "\x8c\b\u44e8", // 䓨
	0x44e9: "\x8c\b\u44e9", // 䓩
	0x44ea: "\x8c\b\u44ea", // 䓪
	0x44eb: "\x8c\b\u44eb", // 䓫
	0x44ec: "\x8c\b\u44ec", // 䓬
	0x44ed: "\x8c\b\u44ed", // 䓭
	0x44ee: "\x8c\t\u44ee", // 䓮
	0x44ef: "\x8c\t\u44ef", // 䓯
	0x44f0: "\x8c\t\u44f0", // 䓰
	0x44f1: "\x8c\t\u44f1", // 䓱
	0x44f2: "\x8c\t\u44f2", // 䓲
	0x44f3: "\x8c\t\u44f3", // 䓳
	0x44f4: "\x8c\t\u44f4", // 䓴
	0x44f5: "\x8c\t\u44f5", // 䓵
	0x44f6: "\x8c\t\u44f6", // 䓶
	0x44f7: "\x8c\t\u44f7", // 䓷
	0x44f8: "\x8c\t\u44f8", // 䓸
	0x44f9: "\x8c\t\u44f9", // 䓹
	0x44fa: "\x8c\t\u44fa", // 䓺
	0x44fb: "\x8c\t\u44fb", // 䓻
	0x44fc: "\x8c\n\u44fc", // 䓼
	0x44fd: "\x8c\n\u44fd", // 䓽
	0x44fe: "\x8c\n\u44fe", // 䓾
	0x44ff: "\x8c\n\u44ff", // 䓿
	0x4500: "\x8c\n\u4500", // 䔀
	0x4501: "\x8c\n\u4501", // 䔁
	0x4502: "\x8c\n\u4502", // 䔂
	0x4503: "\x8c\n\u4503", // 䔃
	0x4504: "\x8c\n\u4504", // 䔄
	0x4505: "\x8c\n\u4505", // 䔅
	0x4506: "\x8c\n\u4506", // 䔆
	0x4507: "\x8c\n\u4507", // 䔇
	0x4508: "\x8c\n\u4508", // 䔈
	0x4509: "\x8c\n\u4509", // 䔉
	0x450a: "\x8c\n\u450a", // 䔊
	0x450b: "\x8c\n\u450b", // 䔋
	0x450c: "\x8c\n\u450c", // 䔌
	0x450d: "\x8c\n\u450d", // 䔍
	0x450e: "\x8c\v\u450e", // 䔎
	0x450f: "\x8c\v\u450f", // 䔏
	0x4510: "\x8c\v\u4510", // 䔐
	0x4511: "\x8c\v\u4511", // 䔑
	0x4512: "\x8c\v\u4512", // 䔒
	0x4513: "\x8c\v\u4513", // 䔓
	0x4514: "\x8c\v\u4514", // 䔔
	0x4515: "\x8c\v\u4515", // 䔕
	0x4516: "\x8c\v\u4516", // 䔖
	0x4517: "\x8c\v\u4517", // 䔗
	0x4518: "\x8c\v\u4518", // 䔘
	0x4519: "\x8c\v\u4519", // 䔙
	0x451a: "\x8c\v\u451a", // 䔚
	0x451b: "\x8c\v\u451b", // 䔛
	0x451c: "\x8c\v\u451c", // 䔜
	0x451d: "\x8c\v\u451d", // 䔝
	0x451e: "\x8c\v\u451e", // 䔞
	0x451f: "\x8c\v\u451f", // 䔟
	0x4520: "\x8c\v\u4520", // 䔠
	0x4521: "\x8c\v\u4521", // 䔡
	0x4522: "\x8c\v\u4522", // 䔢
	0x4523: "\x8c\v\u4523", // 䔣
	0x4524: "\x8c\v\u4524", // 䔤
	0x4525: "\x8c\v\u4525", // 䔥
	0x4526: "\x8c\v\u4526", // 䔦
	0x4527: "\x8c\v\u4527", // 䔧
	0x4528: "\x8c\v\u4528", // 䔨
	0x4529: "\x8c\v\u4529", // 䔩
	0x452a: "\x8c\v\u452a", // 䔪
	0x452b: "\x8c\v\u452b", // 䔫
	0x452c: "\x8c\v\u452c", // 䔬
	0x452d: "\x8c\f\u452d", // 䔭
	0x452e: "\x8c\f\u452e", // 䔮
	0x452f: "\x8c\f\u452f", // 䔯
	0x4530: "\x8c\f\u4530", // 䔰
	0x4531: "\x8c\f\u4531", // 䔱
	0x4532: "\x8c\f\u4532", // 䔲
	0x4533: "\x8c\f\u4533", // 䔳
	0x4534: "\x8c\f\u4534", // 䔴
	0x4535: "\x8c\f\u4535", // 䔵
	0x4536: "\x8c\f\u4536", // 䔶
	0x4537: "\x8c\f\u4537", // 䔷
	0x4538: "\x8c\f\u4538", // 䔸
	0x4539: "\x8c\f\u4539", // 䔹
	0x453a: "\x8c\f\u453a", // 䔺
	0x453b: "\x8c\f\u453b", // 䔻
	0x453c: "\x8c\f\u453c", // 䔼
	0x453d: "\x8c\f\u453d", // 䔽
	0x453e: "\x8c\f\u453e", // 䔾
	0x453f: "\x8c\f\u453f", // 䔿
	0x4540: "\x8c\f\u4540", // 䕀
	0x4541: "\x8c\f\u4541", // 䕁
	0x4542: "\x8c\f\u4542", // 䕂
	0x4543: "\x8c\f\u4543", // 䕃
	0x4544: "\x8c\f\u4544", // 䕄
	0x4545: "\x8c\r\u4545", // 䕅
	0x4546: "\x8c\r\u4546", // 䕆
	0x4547: "\x8c\r\u4547", // 䕇
	0x4548: "\x8c\r\u4548", // 䕈
	0x4549: "\x8c\r\u4549", // 䕉
	0x454a: "\x8c\r\u454a", // 䕊
	0x454b: "\x8c\r\u454b", // 䕋
	0x454c: "\x8c\r\u454c", // 䕌
	0x454d: "\x8c\r\u454d", // 䕍
	0x454e: "\x8c\r\u454e", // 䕎
	0x454f: "\x8c\r\u454f", // 䕏
	0x4550: "\x8c\r\u4550", // 䕐
	0x4551: "\x8c\r\u4551", // 䕑
	0x4552: "\x8c\x0e\u4552", // 䕒
	0x4553: "\x8c\x0e\u4553", // 䕓
	0x4554: "\x8c\x0e\u4554", // 䕔
	0x4555: "\x8c\x0e\u4555", // 䕕
	0x4556: "\x8c\x0e\u4556", // 䕖
	0x4557: "\x8c\x0e\u4557", // 䕗
	0x4558: "\x8c\x0e\u4558", // 䕘
	0x4559: "\x8c\x0e\u4559", // 䕙
	0x455a: "\x8c\x0e\u455a", // 䕚
	0x455b: "\x8c\x0e\u455b", // 䕛
	0x455c: "\x8c\x0e\u455c", // 䕜
	0x455d: "\x8c\x0e\u455d", // 䕝
	0x455e: "\x8c\x0f\u455e", // 䕞
	0x455f: "\x8c\x0f\u455f", // 䕟
	0x4560: "\x8c\x0f\u4560", // 䕠
	0x4561: "\x8c\x0f\u4561", // 䕡
	0x4562: "\x8c\x0f\u4562", // 䕢
	0x4563: "\x8c\x0f\u4563", // 䕣
	0x4564: "\x8c\x0f\u4564", // 䕤
	0x4565: "\x8c\x0f\u4565", // 䕥
	0x4566: "\x8c\x10\u4566", // 䕦
	0x4567: "\x8c\x10\u4567", // 䕧
	0x4568: "\x8c\x10\u4568", // 䕨
	0x4569: "\x8c\x10\u4569", // 䕩
	0x456a: "\x8c\x10\u456a", // 䕪
	0x456b: "\x8c\x10\u456b", // 䕫
	0x456c: "\x8c\x10\u456c", // 䕬
	0x456d: "\x8c\x10\u456d", // 䕭
	0x456e: "\x8c\x10\u456e", // 䕮
	0x456f: "\x8c\x10\u456f", // 䕯
	0x4570: "\x8c\x10\u4570", // 䕰
	0x4571: "\x8c\x10\u4571", // 䕱
	0x4572: "\x8c\x10\u4572", // 䕲
	0x4573: "\x8c\x11\u4573", // 䕳
	0x4574: "\x8c\x11\u4574", // 䕴
	0x4575: "\x8c\x11\u4575", // 䕵
	0x4576: "\x8c\x11\u4576", // 䕶
	0x4577: "\x8c\x11\u4577", // 䕷
	0x4578: "\x8c\x12\u4578", // 䕸
	0x4579: "\x8c\x12\u4579", // 䕹
	0x457a: "\x8c\x12\u457a", // 䕺
	0x457b: "\x8c\x13\u457b", // 䕻
	0x457c: "\x8c\x13\u457c", // 䕼
	0x457d: "\x8c\x13\u457d", // 䕽
	0x457e: "\x8c\x14\u457e", // 䕾
	0x457f: "\x8c\x15\u457f", // 䕿
	0x4580: "\x8c\x15\u4580", // 䖀
	0x4581: "\x8c\x16\u4581", // 䖁
	0x4582: "\x8c\x17\u4582", // 䖂
	0x4583: "\x8c\x17\u4583", // 䖃
	0x4584: "\x8c\x17\u4584", // 䖄
	0x4585: "\x8c\x18\u4585", // 䖅
	0x4586: "\x8c\x18\u4586", // 䖆
	0x4587: "\x8c\x1d\u4587", // 䖇
	0x4588: "\x8d\x02\u4588", // 䖈
	0x4589: "\x8d\x03\u4589", // 䖉
	0x458a: "\x8d\x04\u458a", // 䖊
	0x458b: "\x8d\x04\u458b", // 䖋
	0x458c: "\x8d\x04\u458c", // 䖌
	0x458d: "\x8d\x04\u458d", // 䖍
	0x458e: "\x8d\x05\u458e", // 䖎
	0x458f: "\x8d\x05\u458f", // 䖏
	0x4590: "\x8d\x06\u4590", // 䖐
	0x4591: "\x8d\x06\u4591", // 䖑
	0x4592: "\x8d\a\u4592", // 䖒
	0x4593: "\x8d\a\u4593", // 䖓
	0x4594: "\x8d\a\u4594", // 䖔
	0x4595: "\x8d\a\u4595", // 䖕
	0x4596: "\x8d\a\u4596", // 䖖
	0x4597: "\x8d\t\u4597", // 䖗
	0x4598: "\x8d\n\u4598", // 䖘
	0x4599: "\x8d\v\u4599", // 䖙
	0x459a: "\x8d\f\u459a", // 䖚
	0x459b: "\x8d\f\u459b", // 䖛
	0x459c: "\x8d\r\u459c", // 䖜
	0x459d: "\x8e\x01\u459d", // 䖝
	0x459e: "\x8e\x03\u459e", // 䖞
	0x459f: "\x8e\x03\u459f", // 䖟
	0x45a0: "\x8e\x03\u45a0", // 䖠
	0x45a1: "\x8e\x04\u45a1", // 䖡
	0x45a2: "\x8e\x04\u45a2", // 䖢
	0x45a3: "\x8e\x04\u45a3", // 䖣
	0x45a4: "\x8e\x05\u45a4", // 䖤
	0x45a5: "\x8e\x05\u45a5", // 䖥
	0x45a6: "\x8e\x05\u45a6", // 䖦
	0x45a7: "\x8e\x05\u45a7", // 䖧
	0x45a8: "\x8e\x05\u45a8", // 䖨
	0x45a9: "\x8e\x05\u45a9", // 䖩
	0x45aa: "\x8e\x05\u45aa", // 䖪
	0x45ab: "\x8e\x05\u45ab", // 䖫
	0x45ac: "\x8e\x05\u45ac", // 䖬
	0x45ad: "\x8e\x06\u45ad", // 䖭
	0x45ae: "\x8e\x06\u45ae", // 䖮
	0x45af: "\x8e\x06\u45af", // 䖯
	0x45b0: "\x8e\x06\u45b0", // 䖰
	0x45b1: "\x8e\x06\u45b1", // 䖱
	0x45b2: "\x8e\x06\u45b2", // 䖲
	0x45b3: "\x8e\x06\u45b3", // 䖳
	0x45b4: "\x8e\x06\u45b4", // 䖴
	0x45b5: "\x8e\x06\u45b5", // 䖵
	0x45b6: "\x8e\a\u45b6", // 䖶
	0x45b7: "\x8e\a\u45b7", // 䖷
	0x45b8: "\x8e\a\u45b8", // 䖸
	0x45b9: "\x8e\a\u45b9", // 䖹
	0x45ba: "\x8e\a\u45ba", // 䖺
	0x45bb: "\x8e\a\u45bb", // 䖻
	0x45bc: "\x8e\a\u45bc", // 䖼
	0x45bd: "\x8e\a\u45bd", // 䖽
	0x45be: "\x8e\a\u45be", // 䖾
	0x45bf: "\x8e\b\u45bf", // 䖿
	0x45c0: "\x8e\b\u45c0", // 䗀
	0x45c1: "\x8e\b\u45c1", // 䗁
	0x45c2: "\x8e\b\u45c2", // 䗂
	0x45c3: "\x8e\b\u45c3", // 䗃
	0x45c4: "\x8e\b\u45c4", // 䗄
	0x45c5: "\x8e\b\u45c5", // 䗅
	0x45c6: "\x8e\b\u45c6", // 䗆
	0x45c7: "\x8e\b\u45c7", // 䗇
	0x45c8: "\x8e\b\u45c8", // 䗈
	0x45c9: "\x8e\b\u45c9", // 䗉
	0x45ca: "\x8e\b\u45ca", // 䗊
	0x45cb: "\x8e\t\u45cb", // 䗋
	0x45cc: "\x8e\t\u45cc", // 䗌
	0x45cd: "\x8e\t\u45cd", // 䗍
	0x45ce: "\x8e\t\u45ce", // 䗎
	0x45cf: "\x8e\t\u45cf", // 䗏
	0x45d0: "\x8e\t\u45d0", // 䗐
	0x45d1: "\x8e\t\u45d1", // 䗑
	0x45d2: "\x8e\t\u45d2", // 䗒
	0x45d3: "\x8e\t\u45d3", // 䗓
	0x45d4: "\x8e\t\u45d4", // 䗔
	0x45d5: "\x8e\b\u45d5", // 䗕
	0x45d6: "\x8e\t\u45d6", // 䗖
	0x45d7: "\x8e\n\u45d7", // 䗗
	0x45d8: "\x8e\n\u45d8", // 䗘
	0x45d9: "\x8e\n\u45d9", // 䗙
	0x45da: "\x8e\n\u45da", // 䗚
	0x45db: "\x8e\n\u45db", // 䗛
	0x45dc: "\x8e\n\u45dc", // 䗜
	0x45dd: "\x8e\n\u45dd", // 䗝
	0x45de: "\x8e\n\u45de", // 䗞
	0x45df: "\x8e\v\u45df", // 䗟
	0x45e0: "\x8e\v\u45e0", // 䗠
	0x45e1: "\x8e\v\u45e1", // 䗡
	0x45e2: "\x8e\v\u45e2", // 䗢
	0x45e3: "\x8e\v\u45e3", // 䗣
	0x45e4: "\x8e\v\u45e4", // 䗤
	0x45e5: "\x8e\v\u45e5", // 䗥
	0x45e6: "\x8e\v\u45e6", // 䗦
	0x45e7: "\x8e\v\u45e7", // 䗧
	0x45e8: "\x8e\v\u45e8", // 䗨
	0x45e9: "\x8e\v\u45e9", // 䗩
	0x45ea: "\x8e\v\u45ea", // 䗪
	0x45eb: "\x8e\v\u45eb", // 䗫
	0x45ec: "\x8e\v\u45ec", // 䗬
	0x45ed: "\x8e\v\u45ed", // 䗭
	0x45ee: "\x8e\v\u45ee", // 䗮
	0x45ef: "\x8e\f\u45ef", // 䗯
	0x45f0: "\x8e\f\u45f0", // 䗰
	0x45f1: "\x8e\f\u45f1", // 䗱
	0x45f2: "\x8e\f\u45f2", // 䗲
	0x45f3: "\x8e\f\u45f3", // 䗳
	0x45f4: "\x8e\r\u45f4", // 䗴
	0x45f5: "\x8e\r\u45f5", // 䗵
	0x45f6: "\x8e\r\u45f6", // 䗶
	0x45f7: "\x8e\r\u45f7", // 䗷
	0x45f8: "\x8e\r\u45f8", // 䗸
	0x45f9: "\x8e\r\u45f9", // 䗹
	0x45fa: "\x8e\r\u45fa", // 䗺
	0x45fb: "\x8e\r\u45fb", // 䗻
	0x45fc: "\x8e\x0e\u45fc", // 䗼
	0x45fd: "\x8e\x0e\u45fd", // 䗽
	0x45fe: "\x8e\x0e\u45fe", // 䗾
	0x45ff: "\x8e\x0e\u45ff", // 䗿
	0x4600: "\x8e\x0e\u4600", // 䘀
	0x4601: "\x8e\x0e\u4601", // 䘁
	0x4602: "\x8e\x0f\u4602", // 䘂
	0x4603: "\x8e\x0f\u4603", // 䘃
	0x4604: "\x8e\x0f\u4604", // 䘄
	0x4605: "\x8e\x10\u4605", // 䘅
	0x4606: "\x8e\x10\u4606", // 䘆
	0x4607: "\x8e\x10\u4607", // 䘇
	0x4608: "\x8e\x10\u4608", // 䘈
	0x4609: "\x8e\x10\u4609", // 䘉
	0x460a: "\x8e\x11\u460a", // 䘊
	0x460b: "\x8e\x11\u460b", // 䘋
	0x460c: "\x8e\x11\u460c", // 䘌
	0x460d: "\x8e\x13\u460d", // 䘍
	0x460e: "\x8e\x16\u460e", // 䘎
	0x460f: "\x8f\x03\u460f", // 䘏
	0x4610: "\x8f\x04\u4610", // 䘐
	0x4611: "\x8f\x05\u4611", // 䘑
	0x4612: "\x8f\a\u4612", // 䘒
	0x4613: "\x8f\b\u4613", // 䘓
	0x4614: "\x8f\t\u4614", // 䘔
	0x4615: "\x90\x04\u4615", // 䘕
	0x4616: "\x90\x06\u4616", // 䘖
	0x4617: "\x90\n\u4617", // 䘗
	0x4618: "\x90\n\u4618", // 䘘
	0x4619: "\x90\x0e\u4619", // 䘙
	0x461a: "\x91\x02\u461a", // 䘚
	0x461b: "\x91\x02\u461b", // 䘛
	0x461c: "\x91\x03\u461c", // 䘜
	0x461d: "\x91\x03\u461d", // 䘝
	0x461e: "\x91\x03\u461e", // 䘞
	0x461f: "\x91\x04\u461f", // 䘟
	0x4620: "\x91\x04\u4620", // 䘠
	0x4621: "\x91\x04\u4621", // 䘡
	0x4622: "\x91\x05\u4622", // 䘢
	0x4623: "\x91\x05\u4623", // 䘣
	0x4624: "\x91\x05\u4624", // 䘤
	0x4625: "\x91\x05\u4625", // 䘥
	0x4626: "\x91\x05\u4626", // 䘦
	0x4627: "\x91\x05\u4627", // 䘧
	0x4628: "\x91\x06\u4628", // 䘨
	0x4629: "\x91\x06\u4629", // 䘩
	0x462a: "\x91\x06\u462a", // 䘪
	0x462b: "\x91\x06\u462b", // 䘫
	0x462c: "\x91\x06\u462c", // 䘬
	0x462d: "\x91\x06\u462d", // 䘭
	0x462e: "\x91\x06\u462e", // 䘮
	0x462f: "\x91\a\u462f", // 䘯
	0x4630: "\x91\a\u4630", // 䘰
	0x4631: "\x91\a\u4631", // 䘱
	0x4632: "\x91\a\u4632", // 䘲
	0x4633: "\x91\b\u4633", // 䘳
	0x4634: "\x91\b\u4634", // 䘴
	0x4635: "\x91\b\u4635", // 䘵
	0x4636: "\x91\b\u4636", // 䘶
	0x4637: "\x91\b\u4637", // 䘷
	0x4638: "\x91\b\u4638", // 䘸
	0x4639: "\x91\b\u4639", // 䘹
	0x463a: "\x91\b\u463a", // 䘺
	0x463b: "\x91\b\u463b", // 䘻
	0x463c: "\x91\b\u463c", // 䘼
	0x463d: "\x91\b\u463d", // 䘽
	0x463e: "\x91\b\u463e", // 䘾
	0x463f: "\x91\b\u463f", // 䘿
	0x4640: "\x91\b\u4640", // 䙀
	0x4641: "\x91\b\u4641", // 䙁
	0x4642: "\x91\b\u4642", // 䙂
	0x4643: "\x91\t\u4643", // 䙃
	0x4644: "\x91\t\u4644", // 䙄
	0x4645: "\x91\t\u4645", // 䙅
	0x4646: "\x91\t\u4646", // 䙆
	0x4647: "\x91\t\u4647", // 䙇
	0x4648: "\x91\t\u4648", // 䙈
	0x4649: "\x91\t\u4649", // 䙉
	0x464a: "\x91\t\u464a", // 䙊
	0x464b: "\x91\t\u464b", // 䙋
	0x464c: "\x91\t\u464c", // 䙌
	0x464d: "\x91\t\u464d", // 䙍
	0x464e: "\x91\n\u464e", // 䙎
	0x464f: "\x91\n\u464f", // 䙏
	0x4650: "\x91\n\u4650", // 䙐
	0x4651: "\x91\n\u4651", // 䙑
	0x4652: "\x91\n\u4652", // 䙒
	0x4653: "\x91\n\u4653", // 䙓
	0x4654: "\x91\v\u4654", // 䙔
	0x4655: "\x91\v\u4655", // 䙕
	0x4656: "\x91\v\u4656", // 䙖
	0x4657: "\x91\v\u4657", // 䙗
	0x4658: "\x91\v\u4658", // 䙘
	0x4659: "\x91\v\u4659", // 䙙
	0x465a: "\x91\v\u465a", // 䙚
	0x465b: "\x91\v\u465b", // 䙛
	0x465c: "\x91\v\u465c", // 䙜
	0x465d: "\x91\v\u465d", // 䙝
	0x465e: "\x91\f\u465e", // 䙞
	0x465f: "\x91\f\u465f", // 䙟
	0x4660: "\x91\f\u4660", // 䙠
	0x4661: "\x91\f\u4661", // 䙡
	0x4662: "\x91\f\u4662", // 䙢
	0x4663: "\x91\f\u4663", // 䙣
	0x4664: "\x91\r\u4664", // 䙤
	0x4665: "\x91\r\u4665", // 䙥
	0x4666: "\x91\x0e\u4666", // 䙦
	0x4667: "\x91\x0e\u4667", // 䙧
	0x4668: "\x91\x0e\u4668", // 䙨
	0x4669: "\x91\x0e\u4669", // 䙩
	0x466a: "\x91\x0f\u466a", // 䙪
	0x466b: "\x91\x10\u466b", // 䙫
	0x466c: "\x91\x11\u466c", // 䙬
	0x466d: "\x91\x11\u466d", // 䙭
	0x466e: "\x91\x12\u466e", // 䙮
	0x466f: "\x91\x12\u466f", // 䙯
	0x4670: "\x91\x13\u4670", // 䙰
	0x4671: "\x91\x15\u4671", // 䙱
	0x4672: "\x92\x03\u4672", // 䙲
	0x4673: "\x92\x04\u4673", // 䙳
	0x4674: "\x92\x05\u4674", // 䙴
	0x4675: "\x92\x06\u4675", // 䙵
	0x4676: "\x92\x06\u4676", // 䙶
	0x4677: "\x93\x03\u4677", // 䙷
	0x4678: "\x93\x03\u4678", // 䙸
	0x4679: "\x93\x04\u4679", // 䙹
	0x467a: "\x93\x04\u467a", // 䙺
	0x467b: "\x93\x04\u467b", // 䙻
	0x467c: "\x93\x05\u467c", // 䙼
	0x467d: "\x93\x05\u467d", // 䙽
	0x467e: "\x93\x05\u467e", // 䙾
	0x467f: "\x93\x05\u467f", // 䙿
	0x4680: "\x93\x06\u4680", // 䚀
	0x4681: "\x93\x06\u4681", // 䚁
	0x4682: "\x93\a\u4682", // 䚂
	0x4683: "\x93\a\u4683", // 䚃
	0x4684: "\x93\b\u4684", // 䚄
	0x4685: "\x93\b\u4685", // 䚅
	0x4686: "\x93\t\u4686", // 䚆
	0x4687: "\x93\t\u4687", // 䚇
	0x4688: "\x93\t\u4688", // 䚈
	0x4689: "\x93\t\u4689", // 䚉
	0x468a: "\x93\n\u468a", // 䚊
	0x468b: "\x93\n\u468b", // 䚋
	0x468c: "\x93\n\u468c", // 䚌
	0x468d: "\x93\v\u468d", // 䚍
	0x468e: "\x93\v\u468e", // 䚎
	0x468f: "\x93\f\u468f", // 䚏
	0x4690: "\x93\f\u4690", // 䚐
	0x4691: "\x93\f\u4691", // 䚑
	0x4692: "\x93\f\u4692", // 䚒
	0x4693: "\x93\f\u4693", // 䚓
	0x4694: "\x93\x0e\u4694", // 䚔
	0x4695: "\x93\x13\u4695", // 䚕
	0x4696: "\x93\x18\u4696", // 䚖
	0x4697: "\x94\x04\u4697", // 䚗
	0x4698: "\x94\x06\u4698", // 䚘
	0x4699: "\x94\x06\u4699", // 䚙
	0x469a: "\x94\x06\u469a", // 䚚
	0x469b: "\x94\a\u469b", // 䚛
	0x469c: "\x94\b\u469c", // 䚜
	0x469d: "\x94\b\u469d", // 䚝
	0x469e: "\x94\b\u469e", // 䚞
	0x469f: "\x94\b\u469f", // 䚟
	0x46a0: "\x94\b\u46a0", // 䚠
	0x46a1: "\x94\t\u46a1", // 䚡
	0x46a2: "\x94\t\u46a2", // 䚢
	0x46a3: "\x94\t\u46a3", // 䚣
	0x46a4: "\x94\t\u46a4", // 䚤
	0x46a5: "\x94\n\u46a5", // 䚥
	0x46a6: "\x94\n\u46a6", // 䚦
	0x46a7: "\x94\v\u46a7", // 䚧
	0x46a8: "\x94\f\u46a8", // 䚨
	0x46a9: "\x94\f\u46a9", // 䚩
	0x46aa: "\x94\r\u46aa", // 䚪
	0x46ab: "\x94\r\u46ab", // 䚫
	0x46ac: "\x94\f\u46ac", // 䚬
	0x46ad: "\x94\x12\u46ad", // 䚭
	0x46ae: "\x95\x02\u46ae", // 䚮
	0x46af: "\x95\x02\u46af", // 䚯
	0x46b0: "\x95\x02\u46b0", // 䚰
	0x46b1: "\x95\x03\u46b1", // 䚱
	0x46b2: "\x95\x03\u46b2", // 䚲
	0x46b3: "\x95\x04\u46b3", // 䚳
	0x46b4: "\x95\x04\u46b4", // 䚴
	0x46b5: "\x95\x04\u46b5", // 䚵
	0x46b6: "\x95\x04\u46b6", // 䚶
	0x46b7: "\x95\x04\u46b7", // 䚷
	0x46b8: "\x95\x04\u46b8", // 䚸
	0x46b9: "\x95\x04\u46b9", // 䚹
	0x46ba: "\x95\x04\u46ba", // 䚺
	0x46bb: "\x95\x04\u46bb", // 䚻
	0x46bc: "\x95\x04\u46bc", // 䚼
	0x46bd: "\x95\x04\u46bd", // 䚽
	0x46be: "\x95\x04\u46be", // 䚾
	0x46bf: "\x95\x04\u46bf", // 䚿
	0x46c0: "\x95\x04\u46c0", // 䛀
	0x46c1: "\x95\x04\u46c1", // 䛁
	0x46c2: "\x95\x04\u46c2", // 䛂
	0x46c3: "\x95\x04\u46c3", // 䛃
	0x46c4: "\x95\x05\u46c4", // 䛄
	0x46c5: "\x95\x05\u46c5", // 䛅
	0x46c6: "\x95\x05\u46c6", // 䛆
	0x46c7: "\x95\x05\u46c7", // 䛇
	0x46c8: "\x95\x05\u46c8", // 䛈
	0x46c9: "\x95\x05\u46c9", // 䛉
	0x46ca: "\x95\x05\u46ca", // 䛊
	0x46cb: "\x95\x05\u46cb", // 䛋
	0x46cc: "\x95\x05\u46cc", // 䛌
	0x46cd: "\x95\x05\u46cd", // 䛍
	0x46ce: "\x95\x05\u46ce", // 䛎
	0x46cf: "\x95\x05\u46cf", // 䛏
	0x46d0: "\x95\x05\u46d0", // 䛐
	0x46d1: "\x95\x05\u46d1", // 䛑
	0x46d2: "\x95\x05\u46d2", // 䛒
	0x46d3: "\x95\x05\u46d3", // 䛓
	0x46d4: "\x95\x06\u46d4", // 䛔
	0x46d5: "\x95\x06\u46d5", // 䛕
	0x46d6: "\x95\x06\u46d6", // 䛖
	0x46d7: "\x95\x06\u46d7", // 䛗
	0x46d8: "\x95\x06\u46d8", // 䛘
	0x46d9: "\x95\x06\u46d9", // 䛙
	0x46da: "\x95\x06\u46da", // 䛚
	0x46db: "\x95\x06\u46db", // 䛛
	0x46dc: "\x95\x06\u46dc", // 䛜
	0x46dd: "\x95\a\u46dd", // 䛝
	0x46de: "\x95\a\u46de", // 䛞
	0x46df: "\x95\a\u46df", // 䛟
	0x46e0: "\x95\a\u46e0", // 䛠
	0x46e1: "\x95\a\u46e1", // 䛡
	0x46e2: "\x95\a\u46e2", // 䛢
	0x46e3: "\x95\a\u46e3", // 䛣
	0x46e4: "\x95\a\u46e4", // 䛤
	0x46e5: "\x95\a\u46e5", // 䛥
	0x46e6: "\x95\a\u46e6", // 䛦
	0x46e7: "\x95\a\u46e7", // 䛧
	0x46e8: "\x95\a\u46e8", // 䛨
	0x46e9: "\x95\b\u46e9", // 䛩
	0x46ea: "\x95\b\u46ea", // 䛪
	0x46eb: "\x95\b\u46eb", // 䛫
	0x46ec: "\x95\b\u46ec", // 䛬
	0x46ed: "\x95\b\u46ed", // 䛭
	0x46ee: "\x95\b\u46ee", // 䛮
	0x46ef: "\x95\b\u46ef", // 䛯
	0x46f0: "\x95\b\u46f0", // 䛰
	0x46f1: "\x95\b\u46f1", // 䛱
	0x46f2: "\x95\b\u46f2", // 䛲
	0x46f3: "\x95\b\u46f3", // 䛳
	0x46f4: "\x95\b\u46f4", // 䛴
	0x46f5: "\x95\b\u46f5", // 䛵
	0x46f6: "\x95\b\u46f6", // 䛶
	0x46f7: "\x95\b\u46f7", // 䛷
	0x46f8: "\x95\b\u46f8", // 䛸
	0x46f9: "\x95\t\u46f9", // 䛹
	0x46fa: "\x95\t\u46fa", // 䛺
	0x46fb: "\x95\t\u46fb", // 䛻
	0x46fc: "\x95\t\u46fc", // 䛼
	0x46fd: "\x95\t\u46fd", // 䛽
	0x46fe: "\x95\n\u46fe", // 䛾
	0x46ff: "\x95\n\u46ff", // 䛿
	0x4700: "\x95\n\u4700", // 䜀
	0x4701: "\x95\n\u4701", // 䜁
	0x4702: "\x95\n\u4702", // 䜂
	0x4703: "\x95\v\u4703", // 䜃
	0x4704: "\x95\v\u4704", // 䜄
	0x4705: "\x95\v\u4705", // 䜅
	0x4706: "\x95\v\u4706", // 䜆
	0x4707: "\x95\v\u4707", // 䜇
	0x4708: "\x95\v\u4708", // 䜈
	0x4709: "\x95\v\u4709", // 䜉
	0x470a: "\x95\v\u470a", // 䜊
	0x470b: "\x95\f\u470b", // 䜋
	0x470c: "\x95\f\u470c", // 䜌
	0x470d: "\x95\f\u470d", // 䜍
	0x470e: "\x95\f\u470e", // 䜎
	0x470f: "\x95\f\u470f", // 䜏
	0x4710: "\x95\f\u4710", // 䜐
	0x4711: "\x95\f\u4711", // 䜑
	0x4712: "\x95\r\u4712", // 䜒
	0x4713: "\x95\r\u4713", // 䜓
	0x4714: "\x95\r\u4714", // 䜔
	0x4715: "\x95\r\u4715", // 䜕
	0x4716: "\x95\r\u4716", // 䜖
	0x4717: "\x95\r\u4717", // 䜗
	0x4718: "\x95\r\u4718", // 䜘
	0x4719: "\x95\x0e\u4719", // 䜙
	0x471a: "\x95\x0e\u471a", // 䜚
	0x471b: "\x95\x0e\u471b", // 䜛
	0x471c: "\x95\x0e\u471c", // 䜜
	0x471d: "\x95\x0e\u471d", // 䜝
	0x471e: "\x95\x0e\u471e", // 䜞
	0x471f: "\x95\x0f\u471f", // 䜟
	0x4720: "\x95\x0f\u4720", // 䜠
	0x4721: "\x95\x0f\u4721", // 䜡
	0x4722: "\x95\x10\u4722", // 䜢
	0x4723: "\x95\x04\u4723", // 䜣
	0x4724: "\x95\x06\u4724", // 䜤
	0x4725: "\x95\b\u4725", // 䜥
	0x4726: "\x95\n\u4726", // 䜦
	0x4727: "\x95\n\u4727", // 䜧
	0x4728: "\x95\v\u4728", // 䜨
	0x4729: "\x95\x10\u4729", // 䜩
	0x472a: "\x96\x02\u472a", // 䜪
	0x472b: "\x96\x03\u472b", // 䜫
	0x472c: "\x96\x05\u472c", // 䜬
	0x472d: "\x96\x05\u472d", // 䜭
	0x472e: "\x96\a\u472e", // 䜮
	0x472f: "\x96\b\u472f", // 䜯
	0x4730: "\x96\n\u4730", // 䜰
	0x4731: "\x96\v\u4731", // 䜱
	0x4732: "\x96\x0f\u4732", // 䜲
	0x4733: "\x97\x01\u4733", // 䜳
	0x4734: "\x97\x04\u4734", // 䜴
	0x4735: "\x97\x05\u4735", // 䜵
	0x4736: "\x97\x06\u4736", // 䜶
	0x4737: "\x97\a\u4737", // 䜷
	0x4738: "\x97\a\u4738", // 䜸
	0x4739: "\x97\a\u4739", // 䜹
	0x473a: "\x97\b\u473a", // 䜺
	0x473b: "\x97\t\u473b", // 䜻
	0x473c: "\x97\t\u473c", // 䜼
	0x473d: "\x97\t\u473d", // 䜽
	0x473e: "\x97\t\u473e", // 䜾
	0x473f: "\x97\t\u473f", // 䜿
	0x4740: "\x97\n\u4740", // 䝀
	0x4741: "\x97\n\u4741", // 䝁
	0x4742: "\x97\n\u4742", // 䝂
	0x4743: "\x97\x0e\u4743", // 䝃
	0x4744: "\x97\x12\u4744", // 䝄
	0x4745: "\x98\x03\u4745", // 䝅
	0x4746: "\x98\x04\u4746", // 䝆
	0x4747: "\x98\x04\u4747", // 䝇
	0x4748: "\x98\x05\u4748", // 䝈
	0x4749: "\x98\x06\u4749", // 䝉
	0x474a: "\x98\b\u474a", // 䝊
	0x474b: "\x98\b\u474b", // 䝋
	0x474c: "\x98\b\u474c", // 䝌
	0x474d: "\x98\t\u474d", // 䝍
	0x474e: "\x98\t\u474e", // 䝎
	0x474f: "\x98\v\u474f", // 䝏
	0x4750: "\x98\f\u4750", // 䝐
	0x4751: "\x98\f\u4751", // 䝑
	0x4752: "\x98\x0e\u4752", // 䝒
	0x4753: "\x98\x0f\u4753", // 䝓
	0x4754: "\x98\x12\u4754", // 䝔
	0x4755: "\x98\x12\u4755", // 䝕
	0x4756: "\x99\x04\u4756", // 䝖
	0x4757: "\x99\x04\u4757", // 䝗
	0x4758: "\x99\x04\u4758", // 䝘
	0x4759: "\x99\x04\u4759", // 䝙
	0x475a: "\x99\x05\u475a", // 䝚
	0x475b: "\x99\x05\u475b", // 䝛
	0x475c: "\x99\a\u475c", // 䝜
	0x475d: "\x99\b\u475d", // 䝝
	0x475e: "\x99\b\u475e", // 䝞
	0x475f: "\x99\t\u475f", // 䝟
	0x4760: "\x99\n\u4760", // 䝠
	0x4761: "\x99\v\u4761", // 䝡
	0x4762: "\x99\v\u4762", // 䝢
	0x4763: "\x99\f\u4763", // 䝣
	0x4764: "\x99\f\u4764", // 䝤
	0x4765: "\x99\f\u4765", // 䝥
	0x4766: "\x99\f\u4766", // 䝦
	0x4767: "\x9a\x04\u4767", // 䝧
	0x4768: "\x9a\x04\u4768", // 䝨
	0x4769: "\x9a\x05\u4769", // 䝩
	0x476a: "\x9a\x05\u476a", // 䝪
	0x476b: "\x9a\x05\u476b", // 䝫
	0x476c: "\x9a\x05\u476c", // 䝬
	0x476d: "\x9a\x05\u476d", // 䝭
	0x476e: "\x9a\x05\u476e", // 䝮
	0x476f: "\x9a\x05\u476f", // 䝯
	0x4770: "\x9a\x06\u4770", // 䝰
	0x4771: "\x9a\x06\u4771", // 䝱
	0x4772: "\x9a\x06\u4772", // 䝲
	0x4773: "\x9a\a\u4773", // 䝳
	0x4774: "\x9a\a\u4774", // 䝴
	0x4775: "\x9a\a\u4775", // 䝵
	0x4776: "\x9a\b\u4776", // 䝶
	0x4777: "\x9a\b\u4777", // 䝷
	0x4778: "\x9a\b\u4778", // 䝸
	0x4779: "\x9a\b\u4779", // 䝹
	0x477a: "\x9a\b\u477a", // 䝺
	0x477b: "\x9a\b\u477b", // 䝻
	0x477c: "\x9a\b\u477c", // 䝼
	0x477d: "\x9a\b\u477d", // 䝽
	0x477e: "\x9a\b\u477e", // 䝾
	0x477f: "\x9a\b\u477f", // 䝿
	0x4780: "\x9a\t\u4780", // 䞀
	0x4781: "\x9a\t\u4781", // 䞁
	0x4782: "\x9a\t\u4782", // 䞂
	0x4783: "\x9a\t\u4783", // 䞃
	0x4784: "\x9a\t\u4784", // 䞄
	0x4785: "\x9a\n\u4785", // 䞅
	0x4786: "\x9a\n\u4786", // 䞆
	0x4787: "\x9a\v\u4787", // 䞇
	0x4788: "\x9a\f\u4788", // 䞈
	0x4789: "\x9a\r\u4789", // 䞉
	0x478a: "\x9a\x0f\u478a", // 䞊
	0x478b: "\x9a\x10\u478b", // 䞋
	0x478c: "\x9a\x06\u478c", // 䞌
	0x478d: "\x9a\b\u478d", // 䞍
	0x478e: "\x9a\b\u478e", // 䞎
	0x478f: "\x9a\t\u478f", // 䞏
	0x4790: "\x9a\t\u4790", // 䞐
	0x4791: "\x9b\x03\u4791", // 䞑
	0x4792: "\x9b\x06\u4792", // 䞒
	0x4793: "\x9b\a\u4793", // 䞓
	0x4794: "\x9b\a\u4794", // 䞔
	0x4795: "\x9b\x0e\u4795", // 䞕
	0x4796: "\x9c\x03\u4796", // 䞖
	0x4797: "\x9c\x03\u4797", // 䞗
	0x4798: "\x9c\x03\u4798", // 䞘
	0x4799: "\x9c\x04\u4799", // 䞙
	0x479a: "\x9c\x04\u479a", // 䞚
	0x479b: "\x9c\x04\u479b", // 䞛
	0x479c: "\x9c\x04\u479c", // 䞜
	0x479d: "\x9c\x05\u479d", // 䞝
	0x479e: "\x9c\x05\u479e", // 䞞
	0x479f: "\x9c\x05\u479f", // 䞟
	0x47a0: "\x9c\x05\u47a0", // 䞠
	0x47a1: "\x9c\x05\u47a1", // 䞡
	0x47a2: "\x9c\x05\u47a2", // 䞢
	0x47a3: "\x9c\x05\u47a3", // 䞣
	0x47a4: "\x9c\x05\u47a4", // 䞤
	0x47a5: "\x9c\x06\u47a5", // 䞥
	0x47a6: "\x9c\x06\u47a6", // 䞦
	0x47a7: "\x9c\x06\u47a7", // 䞧
	0x47a8: "\x9c\x06\u47a8", // 䞨
	0x47a9: "\x9c\x06\u47a9", // 䞩
	0x47aa: "\x9c\x06\u47aa", // 䞪
	0x47ab: "\x9c\a\u47ab", // 䞫
	0x47ac: "\x9c\a\u47ac", // 䞬
	0x47ad: "\x9c\a\u47ad", // 䞭
	0x47ae: "\x9c\a\u47ae", // 䞮
	0x47af: "\x9c\a\u47af", // 䞯
	0x47b0: "\x9c\a\u47b0", // 䞰
	0x47b1: "\x9c\a\u47b1", // 䞱
	0x47b2: "\x9c\a\u47b2", // 䞲
	0x47b3: "\x9c\b\u47b3", // 䞳
	0x47b4: "\x9c\b\u47b4", // 䞴
	0x47b5: "\x9c\b\u47b5", // 䞵
	0x47b6: "\x9c\b\u47b6", // 䞶
	0x47b7: "\x9c\b\u47b7", // 䞷
	0x47b8: "\x9c\b\u47b8", // 䞸
	0x47b9: "\x9c\t\u47b9", // 䞹
	0x47ba: "\x9c\t\u47ba", // 䞺
	0x47bb: "\x9c\t\u47bb", // 䞻
	0x47bc: "\x9c\t\u47bc", // 䞼
	0x47bd: "\x9c\n\u47bd", // 䞽
	0x47be: "\x9c\n\u47be", // 䞾
	0x47bf: "\x9c\n\u47bf", // 䞿
	0x47c0: "\x9c\n\u47c0", // 䟀
	0x47c1: "\x9c\v\u47c1", // 䟁
	0x47c2: "\x9c\v\u47c2", // 䟂
	0x47c3: "\x9c\v\u47c3", // 䟃
	0x47c4: "\x9c\v\u47c4", // 䟄
	0x47c5: "\x9c\v\u47c5", // 䟅
	0x47c6: "\x9c\v\u47c6", // 䟆
	0x47c7: "\x9c\f\u47c7", // 䟇
	0x47c8: "\x9c\r\u47c8", // 䟈
	0x47c9: "\x9c\r\u47c9", // 䟉
	0x47ca: "\x9c\r\u47ca", // 䟊
	0x47cb: "\x9c\r\u47cb", // 䟋
	0x47cc: "\x9c\x0e\u47cc", // 䟌
	0x47cd: "\x9c\x0f\u47cd", // 䟍
	0x47ce: "\x9c\x0f\u47ce", // 䟎
	0x47cf: "\x9c\x0f\u47cf", // 䟏
	0x47d0: "\x9c\x10\u47d0", // 䟐
	0x47d1: "\x9c\x11\u47d1", // 䟑
	0x47d2: "\x9c\x12\u47d2", // 䟒
	0x47d3: "\x9d\x02\u47d3", // 䟓
	0x47d4: "\x9d\x02\u47d4", // 䟔
	0x47d5: "\x9d\x03\u47d5", // 䟕
	0x47d6: "\x9d\x03\u47d6", // 䟖
	0x47d7: "\x9d\x04\u47d7", // 䟗
	0x47d8: "\x9d\x04\u47d8", // 䟘
	0x47d9: "\x9d\x04\u47d9", // 䟙
	0x47da: "\x9d\x04\u47da", // 䟚
	0x47db: "\x9d\x04\u47db", // 䟛
	0x47dc: "\x9d\x04\u47dc", // 䟜
	0x47dd: "\x9d\x04\u47dd", // 䟝
	0x47de: "\x9d\x04\u47de", // 䟞
	0x47df: "\x9d\x05\u47df", // 䟟
	0x47e0: "\x9d\x05\u47e0", // 䟠
	0x47e1: "\x9d\x05\u47e1", // 䟡
	0x47e2: "\x9d\x05\u47e2", // 䟢
	0x47e3: "\x9d\x05\u47e3", // 䟣
	0x47e4: "\x9d\x05\u47e4", // 䟤
	0x47e5: "\x9d\x05\u47e5", // 䟥
	0x47e6: "\x9d\x05\u47e6", // 䟦
	0x47e7: "\x9d\x05\u47e7", // 䟧
	0x47e8: "\x9d\x05\u47e8", // 䟨
	0x47e9: "\x9d\x05\u47e9", // 䟩
	0x47ea: "\x9d\x05\u47ea", // 䟪
	0x47eb: "\x9d\x05\u47eb", // 䟫
	0x47ec: "\x9d\x05\u47ec", // 䟬
	0x47ed: "\x9d\x05\u47ed", // 䟭
	0x47ee: "\x9d\x06\u47ee", // 䟮
	0x47ef: "\x9d\x06\u47ef", // 䟯
	0x47f0: "\x9d\x06\u47f0", // 䟰
	0x47f1: "\x9d\x06\u47f1", // 䟱
	0x47f2: "\x9d\x06\u47f2", // 䟲
	0x47f3: "\x9d\x06\u47f3", // 䟳
	0x47f4: "\x9d\a\u47f4", // 䟴
	0x47f5: "\x9d\a\u47f5", // 䟵
	0x47f6: "\x9d\a\u47f6", // 䟶
	0x47f7: "\x9d\a\u47f7", // 䟷
	0x47f8: "\x9d\a\u47f8", // 䟸
	0x47f9: "\x9d\a\u47f9", // 䟹
	0x47fa: "\x9d\a\u47fa", // 䟺
	0x47fb: "\x9d\a\u47fb", // 䟻
	0x47fc: "\x9d\b\u47fc", // 䟼
	0x47fd: "\x9d\a\u47fd", // 䟽
	0x47fe: "\x9d\b\u47fe", // 䟾
	0x47ff: "\x9d\b\u47ff", // 䟿
	0x4800: "\x9d\b\u4800", // 䠀
	0x4801: "\x9d\b\u4801", // 䠁
	0x4802: "\x9d\b\u4802", // 䠂
	0x4803: "\x9d\b\u4803", // 䠃
	0x4804: "\x9d\b\u4804", // 䠄
	0x4805: "\x9d\b\u4805", // 䠅
	0x4806: "\x9d\b\u4806", // 䠆
	0x4807: "\x9d\b\u4807", // 䠇
	0x4808: "\x9d\b\u4808", // 䠈
	0x4809: "\x9d\b\u4809", // 䠉
	0x480a: "\x9d\b\u480a", // 䠊
	0x480b: "\x9d\b\u480b", // 䠋
	0x480c: "\x9d\b\u480c", // 䠌
	0x480d: "\x9d\t\u480d", // 䠍
	0x480e: "\x9d\t\u480e", // 䠎
	0x480f: "\x9d\t\u480f", // 䠏
	0x4810: "\x9d\t\u4810", // 䠐
	0x4811: "\x9d\t\u4811", // 䠑
	0x4812: "\x9d\t\u4812", // 䠒
	0x4813: "\x9d\t\u4813", // 䠓
	0x4814: "\x9d\t\u4814", // 䠔
	0x4815: "\x9d\t\u4815", // 䠕
	0x4816: "\x9d\t\u4816", // 䠖
	0x4817: "\x9d\n\u4817", // 䠗
	0x4818: "\x9d\n\u4818", // 䠘
	0x4819: "\x9d\n\u4819", // 䠙
	0x481a: "\x9d\n\u481a", // 䠚
	0x481b: "\x9d\n\u481b", // 䠛
	0x481c: "\x9d\n\u481c", // 䠜
	0x481d: "\x9d\n\u481d", // 䠝
	0x481e: "\x9d\v\u481e", // 䠞
	0x481f: "\x9d\v\u481f", // 䠟
	0x4820: "\x9d\v\u4820", // 䠠
	0x4821: "\x9d\v\u4821", // 䠡
	0x4822: "\x9d\v\u4822", // 䠢
	0x4823: "\x9d\f\u4823", // 䠣
	0x4824: "\x9d\f\u4824", // 䠤
	0x4825: "\x9d\f\u4825", // 䠥
	0x4826: "\x9d\f\u4826", // 䠦
	0x4827: "\x9d\f\u4827", // 䠧
	0x4828: "\x9d\r\u4828", // 䠨
	0x4829: "\x9d\r\u4829", // 䠩
	0x482a: "\x9d\x0e\u482a", // 䠪
	0x482b: "\x9d\x0e\u482b", // 䠫
	0x482c: "\x9d\x0f\u482c", // 䠬
	0x482d: "\x9d\x10\u482d", // 䠭
	0x482e: "\x9d\x10\u482e", // 䠮
	0x482f: "\x9d\x11\u482f", // 䠯
	0x4830: "\x9d\x12\u4830", // 䠰
	0x4831: "\x9d\x15\u4831", // 䠱
	0x4832: "\x9e\x05\u4832", // 䠲
	0x4833: "\x9e\x05\u4833", // 䠳
	0x4834: "\x9e\x05\u4834", // 䠴
	0x4835: "\x9e\x05\u4835", // 䠵
	0x4836: "\x9e\x05\u4836", // 䠶
	0x4837: "\x9e\x06\u4837", // 䠷
	0x4838: "\x9e\x06\u4838", // 䠸
	0x4839: "\x9e\x06\u4839", // 䠹
	0x483a: "\x9e\x06\u483a", // 䠺
	0x483b: "\x9e\b\u483b", // 䠻
	0x483c: "\x9e\t\u483c", // 䠼
	0x483d: "\x9e\n\u483d", // 䠽
	0x483e: "\x9e\n\u483e", // 䠾
	0x483f: "\x9e\f\u483f", // 䠿
	0x4840: "\x9e\r\u4840", // 䡀
	0x4841: "\x9e\x10\u4841", // 䡁
	0x4842: "\x9f\x02\u4842", // 䡂
	0x4843: "\x9f\x02\u4843", // 䡃
	0x4844: "\x9f\x02\u4844", // 䡄
	0x4845: "\x9f\x03\u4845", // 䡅
	0x4846: "\x9f\x04\u4846", // 䡆
	0x4847: "\x9f\x04\u4847", // 䡇
	0x4848: "\x9f\x04\u4848", // 䡈
	0x4849: "\x9f\x04\u4849", // 䡉
	0x484a: "\x9f\x04\u484a", // 䡊
	0x484b: "\x9f\x04\u484b", // 䡋
	0x484c: "\x9f\x04\u484c", // 䡌
	0x484d: "\x9f\x04\u484d", // 䡍
	0x484e: "\x9f\x04\u484e", // 䡎
	0x484f: "\x9f\x05\u484f", // 䡏
	0x4850: "\x9f\x05\u4850", // 䡐
	0x4851: "\x9f\x05\u4851", // 䡑
	0x4852: "\x9f\x05\u4852", // 䡒
	0x4853: "\x9f\x06\u4853", // 䡓
	0x4854: "\x9f\x06\u4854", // 䡔
	0x4855: "\x9f\x06\u4855", // 䡕
	0x4856: "\x9f\x06\u4856", // 䡖
	0x4857: "\x9f\x06\u4857", // 䡗
	0x4858: "\x9f\a\u4858", // 䡘
	0x4859: "\x9f\a\u4859", // 䡙
	0x485a: "\x9f\a\u485a", // 䡚
	0x485b: "\x9f\a\u485b", // 䡛
	0x485c: "\x9f\b\u485c", // 䡜
	0x485d: "\x9f\b\u485d", // 䡝
	0x485e: "\x9f\b\u485e", // 䡞
	0x485f: "\x9f\b\u485f", // 䡟
	0x4860: "\x9f\t\u4860", // 䡠
	0x4861: "\x9f\t\u4861", // 䡡
	0x4862: "\x9f\t\u4862", // 䡢
	0x4863: "\x9f\t\u4863", // 䡣
	0x4864: "\x9f\t\u4864", // 䡤
	0x4865: "\x9f\n\u4865", // 䡥
	0x4866: "\x9f\n\u4866", // 䡦
	0x4867: "\x9f\n\u4867", // 䡧
	0x4868: "\x9f\n\u4868", // 䡨
	0x4869: "\x9f\n\u4869", // 䡩
	0x486a: "\x9f\n\u486a", // 䡪
	0x486b: "\x9f\v\u486b", // 䡫
	0x486c: "\x9f\v\u486c", // 䡬
	0x486d: "\x9f\v\u486d", // 䡭
	0x486e: "\x9f\v\u486e", // 䡮
	0x486f: "\x9f\v\u486f", // 䡯
	0x4870: "\x9f\v\u4870", // 䡰
	0x4871: "\x9f\v\u4871", // 䡱
	0x4872: "\x9f\f\u4872", // 䡲
	0x4873: "\x9f\f\u4873", // 䡳
	0x4874: "\x9f\f\u4874", // 䡴
	0x4875: "\x9f\f\u4875", // 䡵
	0x4876: "\x9f\r\u4876", // 䡶
	0x4877: "\x9f\x0e\u4877", // 䡷
	0x4878: "\x9f\x0e\u4878", // 䡸
	0x4879: "\x9f\x0e\u4879", // 䡹
	0x487a: "\x9f\x0f\u487a", // 䡺
	0x487b: "\x9f\x0f\u487b", // 䡻
	0x487c: "\x9f\x11\u487c", // 䡼
	0x487d: "\x9f\x13\u487d", // 䡽
	0x487e: "\x9f\x14\u487e", // 䡾
	0x487f: "\x9f\x18\u487f", // 䡿
	0x4880: "\x9f\x03\u4880", // 䢀
	0x4881: "\x9f\x04\u4881", // 䢁
	0x4882: "\x9f\x05\u4882", // 䢂
	0x4883: "\xa0\b\u4883", // 䢃
	0x4884: "\xa0\r\u4884", // 䢄
	0x4885: "\xa1\x06\u4885", // 䢅
	0x4886: "\xa1\a\u4886", // 䢆
	0x4887: "\xa1\b\u4887", // 䢇
	0x4888: "\xa1\r\u4888", // 䢈
	0x4889: "\xa1\r\u4889", // 䢉
	0x488a: "\xa2\x03\u488a", // 䢊
	0x488b: "\xa2\x03\u488b", // 䢋
	0x488c: "\xa2\x04\u488c", // 䢌
	0x488d: "\xa2\x04\u488d", // 䢍
	0x488e: "\xa2\x04\u488e", // 䢎
	0x488f: "\xa2\x04\u488f", // 䢏
	0x4890: "\xa2\x05\u4890", // 䢐
	0x4891: "\xa2\x05\u4891", // 䢑
	0x4892: "\xa2\x06\u4892", // 䢒
	0x4893: "\xa2\x06\u4893", // 䢓
	0x4894: "\xa2\x06\u4894", // 䢔
	0x4895: "\xa2\x06\u4895", // 䢕
	0x4896: "\xa2\x06\u4896", // 䢖
	0x4897: "\xa2\x06\u4897", // 䢗
	0x4898: "\xa2\x06\u4898", // 䢘
	0x4899: "\xa2\a\u4899", // 䢙
	0x489a: "\xa2\a\u489a", // 䢚
	0x489b: "\xa2\a\u489b", // 䢛
	0x489c: "\xa2\b\u489c", // 䢜
	0x489d: "\xa2\b\u489d", // 䢝
	0x489e: "\xa2\b\u489e", // 䢞
	0x489f: "\xa2\b\u489f", // 䢟
	0x48a0: "\xa2\b\u48a0", // 䢠
	0x48a1: "\xa2\t\u48a1", // 䢡
	0x48a2: "\xa2\n\u48a2", // 䢢
	0x48a3: "\xa2\n\u48a3", // 䢣
	0x48a4: "\xa2\n\u48a4", // 䢤
	0x48a5: "\xa2\n\u48a5", // 䢥
	0x48a6: "\xa2\v\u48a6", // 䢦
	0x48a7: "\xa2\v\u48a7", // 䢧
	0x48a8: "\xa2\v\u48a8", // 䢨
	0x48a9: "\xa2\v\u48a9", // 䢩
	0x48aa: "\xa2\f\u48aa", // 䢪
	0x48ab: "\xa2\f\u48ab", // 䢫
	0x48ac: "\xa2\f\u48ac", // 䢬
	0x48ad: "\xa2\f\u48ad", // 䢭
	0x48ae: "\xa2\r\u48ae", // 䢮
	0x48af: "\xa2\x0e\u48af", // 䢯
	0x48b0: "\xa2\x0e\u48b0", // 䢰
	0x48b1: "\xa2\x0f\u48b1", // 䢱
	0x48b2: "\xa2\x14\u48b2", // 䢲
	0x48b3: "\xa3\x02\u48b3", // 䢳
	0x48b4: "\xa3\x03\u48b4", // 䢴
	0x48b5: "\xa3\x04\u48b5", // 䢵
	0x48b6: "\xa3\x04\u48b6", // 䢶
	0x48b7: "\xa3\x04\u48b7", // 䢷
	0x48b8: "\xa3\x05\u48b8", // 䢸
	0x48b9: "\xa3\x05\u48b9", // 䢹
	0x48ba: "\xa3\x05\u48ba", // 䢺
	0x48bb: "\xa3\x06\u48bb", // 䢻
	0x48bc: "\xa3\x06\u48bc", // 䢼
	0x48bd: "\xa3\x06\u48bd", // 䢽
	0x48be: "\xa3\x06\u48be", // 䢾
	0x48bf: "\xa3\x06\u48bf", // 䢿
	0x48c0: "\xa3\x06\u48c0", // 䣀
	0x48c1: "\xa3\x06\u48c1", // 䣁
	0x48c2: "\xa3\x06\u48c2", // 䣂
	0x48c3: "\xa3\a\u48c3", // 䣃
	0x48c4: "\xa3\a\u48c4", // 䣄
	0x48c5: "\xa3\a\u48c5", // 䣅
	0x48c6: "\xa3\a\u48c6", // 䣆
	0x48c7: "\xa3\a\u48c7", // 䣇
	0x48c8: "\xa3\a\u48c8", // 䣈
	0x48c9: "\xa3\a\u48c9", // 䣉
	0x48ca: "\xa3\b\u48ca", // 䣊
	0x48cb: "\xa3\b\u48cb", // 䣋
	0x48cc: "\xa3\b\u48cc", // 䣌
	0x48cd: "\xa3\b\u48cd", // 䣍
	0x48ce: "\xa3\b\u48ce", // 䣎
	0x48cf: "\xa3\b\u48cf", // 䣏
	0x48d0: "\xa3\t\u48d0", // 䣐
	0x48d1: "\xa3\t\u48d1", // 䣑
	0x48d2: "\xa3\t\u48d2", // 䣒
	0x48d3: "\xa3\n\u48d3", // 䣓
	0x48d4: "\xa3\n\u48d4", // 䣔
	0x48d5: "\xa3\n\u48d5", // 䣕
	0x48d6: "\xa3\n\u48d6", // 䣖
	0x48d7: "\xa3\n\u48d7", // 䣗
	0x48d8: "\xa3\v\u48d8", // 䣘
	0x48d9: "\xa3\v\u48d9", // 䣙
	0x48da: "\xa3\v\u48da", // 䣚
	0x48db: "\xa3\v\u48db", // 䣛
	0x48dc: "\xa3\v\u48dc", // 䣜
	0x48dd: "\xa3\f\u48dd", // 䣝
	0x48de: "\xa3\f\u48de", // 䣞
	0x48df: "\xa3\f\u48df", // 䣟
	0x48e0: "\xa3\f\u48e0", // 䣠
	0x48e1: "\xa3\r\u48e1", // 䣡
	0x48e2: "\xa3\x0e\u48e2", // 䣢
	0x48e3: "\xa3\x14\u48e3", // 䣣
	0x48e4: "\xa3\x14\u48e4", // 䣤
	0x48e5: "\xa4\x02\u48e5", // 䣥
	0x48e6: "\xa4\x02\u48e6", // 䣦
	0x48e7: "\xa4\x03\u48e7", // 䣧
	0x48e8: "\xa4\x03\u48e8", // 䣨
	0x48e9: "\xa4\x04\u48e9", // 䣩
	0x48ea: "\xa4\x04\u48ea", // 䣪
	0x48eb: "\xa4\x04\u48eb", // 䣫
	0x48ec: "\xa4\x04\u48ec", // 䣬
	0x48ed: "\xa4\x04\u48ed", // 䣭
	0x48ee: "\xa4\x05\u48ee", // 䣮
	0x48ef: "\xa4\x05\u48ef", // 䣯
	0x48f0: "\xa4\x05\u48f0", // 䣰
	0x48f1: "\xa4\x05\u48f1", // 䣱
	0x48f2: "\xa4\x05\u48f2", // 䣲
	0x48f3: "\xa4\x05\u48f3", // 䣳
	0x48f4: "\xa4\x06\u48f4", // 䣴
	0x48f5: "\xa4\x06\u48f5", // 䣵
	0x48f6: "\xa4\x06\u48f6", // 䣶
	0x48f7: "\xa4\x06\u48f7", // 䣷
	0x48f8: "\xa4\x06\u48f8", // 䣸
	0x48f9: "\xa4\x06\u48f9", // 䣹
	0x48fa: "\xa4\a\u48fa", // 䣺
	0x48fb: "\xa4\a\u48fb", // 䣻
	0x48fc: "\xa4\b\u48fc", // 䣼
	0x48fd: "\xa4\b\u48fd", // 䣽
	0x48fe: "\xa4\b\u48fe", // 䣾
	0x48ff: "\xa4\b\u48ff", // 䣿
	0x4900: "\xa4\t\u4900", // 䤀
	0x4901: "\xa4\t\u4901", // 䤁
	0x4902: "\xa4\t\u4902", // 䤂
	0x4903: "\xa4\t\u4903", // 䤃
	0x4904: "\xa4\t\u4904", // 䤄
	0x4905: "\xa4\t\u4905", // 䤅
	0x4906: "\xa4\t\u4906", // 䤆
	0x4907: "\xa4\t\u4907", // 䤇
	0x4908: "\xa4\t\u4908", // 䤈
	0x4909: "\xa4\n\u4909", // 䤉
	0x490a: "\xa4\n\u490a", // 䤊
	0x490b: "\xa4\n\u490b", // 䤋
	0x490c: "\xa4\n\u490c", // 䤌
	0x490d: "\xa4\v\u490d", // 䤍
	0x490e: "\xa4\f\u490e", // 䤎
	0x490f: "\xa4\f\u490f", // 䤏
	0x4910: "\xa4\f\u4910", // 䤐
	0x4911: "\xa4\f\u4911", // 䤑
	0x4912: "\xa4\f\u4912", // 䤒
	0x4913: "\xa4\x0e\u4913", // 䤓
	0x4914: "\xa4\x0e\u4914", // 䤔
	0x4915: "\xa4\x0f\u4915", // 䤕
	0x4916: "\xa4\x0f\u4916", // 䤖
	0x4917: "\xa4\x11\u4917", // 䤗
	0x4918: "\xa4\x11\u4918", // 䤘
	0x4919: "\xa4\x15\u4919", // 䤙
	0x491a: "\xa6\x04\u491a", // 䤚
	0x491b: "\xa7\x02\u491b", // 䤛
	0x491c: "\xa7\x03\u491c", // 䤜
	0x491d: "\xa7\x04\u491d", // 䤝
	0x491e: "\xa7\x04\u491e", // 䤞
	0x491f: "\xa7\x04\u491f", // 䤟
	0x4920: "\xa7\x04\u4920", // 䤠
	0x4921: "\xa7\x05\u4921", // 䤡
	0x4922: "\xa7\x05\u4922", // 䤢
	0x4923: "\xa7\x05\u4923", // 䤣
	0x4924: "\xa7\x06\u4924", // 䤤
	0x4925: "\xa7\x06\u4925", // 䤥
	0x4926: "\xa7\x06\u4926", // 䤦
	0x4927: "\xa7\x06\u4927", // 䤧
	0x4928: "\xa7\x06\u4928", // 䤨
	0x4929: "\xa7\x06\u4929", // 䤩
	0x492a: "\xa7\x06\u492a", // 䤪
	0x492b: "\xa7\a\u492b", // 䤫
	0x492c: "\xa7\a\u492c", // 䤬
	0x492d: "\xa7\a\u492d", // 䤭
	0x492e: "\xa7\a\u492e", // 䤮
	0x492f: "\xa7\a\u492f", // 䤯
	0x4930: "\xa7\a\u4930", // 䤰
	0x4931: "\xa7\a\u4931", // 䤱
	0x4932: "\xa7\a\u4932", // 䤲
	0x4933: "\xa7\b\u4933", // 䤳
	0x4934: "\xa7\b\u4934", // 䤴
	0x4935: "\xa7\b\u4935", // 䤵
	0x4936: "\xa7\b\u4936", // 䤶
	0x4937: "\xa7\t\u4937", // 䤷
	0x4938: "\xa7\t\u4938", // 䤸
	0x4939: "\xa7\t\u4939", // 䤹
	0x493a: "\xa7\t\u493a", // 䤺
	0x493b: "\xa7\t\u493b", // 䤻
	0x493c: "\xa7\t\u493c", // 䤼
	0x493d: "\xa7\n\u493d", // 䤽
	0x493e: "\xa7\n\u493e", // 䤾
	0x493f: "\xa7\n\u493f", // 䤿
	0x4940: "\xa7\n\u4940", // 䥀
	0x4941: "\xa7\n\u4941", // 䥁
	0x4942: "\xa7\n\u4942", // 䥂
	0x4943: "\xa7\n\u4943", // 䥃
	0x4944: "\xa7\n\u4944", // 䥄
	0x4945: "\xa7\n\u4945", // 䥅
	0x4946: "\xa7\n\u4946", // 䥆
	0x4947: "\xa7\n\u4947", // 䥇
	0x4948: "\xa7\v\u4948", // 䥈
	0x4949: "\xa7\v\u4949", // 䥉
	0x494a: "\xa7\v\u494a", // 䥊
	0x494b: "\xa7\v\u494b", // 䥋
	0x494c: "\xa7\v\u494c", // 䥌
	0x494d: "\xa7\v\u494d", // 䥍
	0x494e: "\xa7\v\u494e", // 䥎
	0x494f: "\xa7\v\u494f", // 䥏
	0x4950: "\xa7\v\u4950", // 䥐
	0x4951: "\xa7\v\u4951", // 䥑
	0x4952: "\xa7\v\u4952", // 䥒
	0x4953: "\xa7\v\u4953", // 䥓
	0x4954: "\xa7\f\u4954", // 䥔
	0x4955: "\xa7\f\u4955", // 䥕
	0x4956: "\xa7\f\u4956", // 䥖
	0x4957: "\xa7\f\u4957", // 䥗
	0x4958: "\xa7\f\u4958", // 䥘
	0x4959: "\xa7\f\u4959", // 䥙
	0x495a: "\xa7\f\u495a", // 䥚
	0x495b: "\xa7\f\u495b", // 䥛
	0x495c: "\xa7\f\u495c", // 䥜
	0x495d: "\xa7\r\u495d", // 䥝
	0x495e: "\xa7\r\u495e", // 䥞
	0x495f: "\xa7\r\u495f", // 䥟
	0x4960: "\xa7\r\u4960", // 䥠
	0x4961: "\xa7\r\u4961", // 䥡
	0x4962: "\xa7\r\u4962", // 䥢
	0x4963: "\xa7\r\u4963", // 䥣
	0x4964: "\xa7\r\u4964", // 䥤
	0x4965: "\xa7\r\u4965", // 䥥
	0x4966: "\xa7\r\u4966", // 䥦
	0x4967: "\xa7\x0e\u4967", // 䥧
	0x4968: "\xa7\x0e\u4968", // 䥨
	0x4969: "\xa7\x0e\u4969", // 䥩
	0x496a: "\xa7\x0e\u496a", // 䥪
	0x496b: "\xa7\x0e\u496b", // 䥫
	0x496c: "\xa7\x0e\u496c", // 䥬
	0x496d: "\xa7\x0e\u496d", // 䥭
	0x496e: "\xa7\x0e\u496e", // 䥮
	0x496f: "\xa7\x0f\u496f", // 䥯
	0x4970: "\xa7\x0f\u4970", // 䥰
	0x4971: "\xa7\x0f\u4971", // 䥱
	0x4972: "\xa7\x0f\u4972", // 䥲
	0x4973: "\xa7\x0f\u4973", // 䥳
	0x4974: "\xa7\x0f\u4974", // 䥴
	0x4975: "\xa7\x10\u4975", // 䥵
	0x4976: "\xa7\x10\u4976", // 䥶
	0x4977: "\xa7\x10\u4977", // 䥷
	0x4978: "\xa7\x11\u4978", // 䥸
	0x4979: "\xa7\x15\u4979", // 䥹
	0x497a: "\xa7\x04\u497a", // 䥺
	0x497b: "\xa7\x04\u497b", // 䥻
	0x497c: "\xa7\x04\u497c", // 䥼
	0x497d: "\xa7\x05\u497d", // 䥽
	0x497e: "\xa7\x05\u497e", // 䥾
	0x497f: "\xa7\x05\u497f", // 䥿
	0x4980: "\xa7\x06\u4980", // 䦀
	0x4981: "\xa7\a\u4981", // 䦁
	0x4982: "\xa7\n\u4982", // 䦂
	0x4983: "\xa7\f\u4983", // 䦃
	0x4984: "\xa7\f\u4984", // 䦄
	0x4985: "\xa7\f\u4985", // 䦅
	0x4986: "\xa7\x14\u4986", // 䦆
	0x4987: "\xa8\x03\u4987", // 䦇
	0x4988: "\xa8\x05\u4988", // 䦈
	0x4989: "\xa8\x05\u4989", // 䦉
	0x498a: "\xa8\x06\u498a", // 䦊
	0x498b: "\xa8\v\u498b", // 䦋
	0x498c: "\xa9\x03\u498c", // 䦌
	0x498d: "\xa9\x03\u498d", // 䦍
	0x498e: "\xa9\x04\u498e", // 䦎
	0x498f: "\xa9\x04\u498f", // 䦏
	0x4990: "\xa9\x04\u4990", // 䦐
	0x4991: "\xa9\x04\u4991", // 䦑
	0x4992: "\xa9\x05\u4992", // 䦒
	0x4993: "\xa9\x05\u4993", // 䦓
	0x4994: "\xa9\x05\u4994", // 䦔
	0x4995: "\xa9\x06\u4995", // 䦕
	0x4996: "\xa9\x06\u4996", // 䦖
	0x4997: "\xa9\x06\u4997", // 䦗
	0x4998: "\xa9\x06\u4998", // 䦘
	0x4999: "\xa9\x06\u4999", // 䦙
	0x499a: "\xa9\x06\u499a", // 䦚
	0x499b: "\xa9\x06\u499b", // 䦛
	0x499c: "\xa9\a\u499c", // 䦜
	0x499d: "\xa9\a\u499d", // 䦝
	0x499e: "\xa9\a\u499e", // 䦞
	0x499f: "\xa9\a\u499f", // 䦟
	0x49a0: "\xa9\b\u49a0", // 䦠
	0x49a1: "\xa9\b\u49a1", // 䦡
	0x49a2: "\xa9\b\u49a2", // 䦢
	0x49a3: "\xa9\b\u49a3", // 䦣
	0x49a4: "\xa9\b\u49a4", // 䦤
	0x49a5: "\xa9\b\u49a5", // 䦥
	0x49a6: "\xa9\b\u49a6", // 䦦
	0x49a7: "\xa9\b\u49a7", // 䦧
	0x49a8: "\xa9\b\u49a8", // 䦨
	0x49a9: "\xa9\t\u49a9", // 䦩
	0x49aa: "\xa9\t\u49aa", // 䦪
	0x49ab: "\xa9\t\u49ab", // 䦫
	0x49ac: "\xa9\t\u49ac", // 䦬
	0x49ad: "\xa9\t\u49ad", // 䦭
	0x49ae: "\xa9\t\u49ae", // 䦮
	0x49af: "\xa9\t\u49af", // 䦯
	0x49b0: "\xa9\v\u49b0", // 䦰
	0x49b1: "\xa9\f\u49b1", // 䦱
	0x49b2: "\xa9\r\u49b2", // 䦲
	0x49b3: "\xa9\r\u49b3", // 䦳
	0x49b4: "\xa9\r\u49b4", // 䦴
	0x49b5: "\xa9\x0e\u49b5", // 䦵
	0x49b6: "\xa9\x06\u49b6", // 䦶
	0x49b7: "\xa9\a\u49b7", // 䦷
	0x49b8: "\xa9\t\u49b8", // 䦸
	0x49b9: "\xaa\x02\u49b9", // 䦹
	0x49ba: "\xaa\x02\u49ba", // 䦺
	0x49bb: "\xaa\x03\u49bb", // 䦻
	0x49bc: "\xaa\x04\u49bc", // 䦼
	0x49bd: "\xaa\x04\u49bd", // 䦽
	0x49be: "\xaa\x04\u49be", // 䦾
	0x49bf: "\xaa\x04\u49bf", // 䦿
	0x49c0: "\xaa\x04\u49c0", // 䧀
	0x49c1: "\xaa\x05\u49c1", // 䧁
	0x49c2: "\xaa\x05\u49c2", // 䧂
	0x49c3: "\xaa\x05\u49c3", // 䧃
	0x49c4: "\xaa\x06\u49c4", // 䧄
	0x49c5: "\xaa\x06\u49c5", // 䧅
	0x49c6: "\xaa\x06\u49c6", // 䧆
	0x49c7: "\xaa\x06\u49c7", // 䧇
	0x49c8: "\xaa\x06\u49c8", // 䧈
	0x49c9: "\xaa\a\u49c9", // 䧉
	0x49ca: "\xaa\a\u49ca", // 䧊
	0x49cb: "\xaa\a\u49cb", // 䧋
	0x49cc: "\xaa\a\u49cc", // 䧌
	0x49cd: "\xaa\a\u49cd", // 䧍
	0x49ce: "\xaa\a\u49ce", // 䧎
	0x49cf: "\xaa\a\u49cf", // 䧏
	0x49d0: "\xaa\b\u49d0", // 䧐
	0x49d1: "\xaa\b\u49d1", // 䧑
	0x49d2: "\xaa\b\u49d2", // 䧒
	0x49d3: "\xaa\b\u49d3", // 䧓
	0x49d4: "\xaa\b\u49d4", // 䧔
	0x49d5: "\xaa\b\u49d5", // 䧕
	0x49d6: "\xaa\b\u49d6", // 䧖
	0x49d7: "\xaa\t\u49d7", // 䧗
	0x49d8: "\xaa\t\u49d8", // 䧘
	0x49d9: "\xaa\t\u49d9", // 䧙
	0x49da: "\xaa\n\u49da", // 䧚
	0x49db: "\xaa\n\u49db", // 䧛
	0x49dc: "\xaa\n\u49dc", // 䧜
	0x49dd: "\xaa\n\u49dd", // 䧝
	0x49de: "\xaa\n\u49de", // 䧞
	0x49df: "\xaa\n\u49df", // 䧟
	0x49e0: "\xaa\v\u49e0", // 䧠
	0x49e1: "\xaa\v\u49e1", // 䧡
	0x49e2: "\xaa\v\u49e2", // 䧢
	0x49e3: "\xaa\v\u49e3", // 䧣
	0x49e4: "\xaa\f\u49e4", // 䧤
	0x49e5: "\xaa\f\u49e5", // 䧥
	0x49e6: "\xaa\f\u49e6", // 䧦
	0x49e7: "\xaa\r\u49e7", // 䧧
	0x49e8: "\xaa\r\u49e8", // 䧨
	0x49e9: "\xaa\f\u49e9", // 䧩
	0x49ea: "\xaa\r\u49ea", // 䧪
	0x49eb: "\xaa\x0e\u49eb", // 䧫
	0x49ec: "\xaa\x0e\u49ec", // 䧬
	0x49ed: "\xaa\x0e\u49ed", // 䧭
	0x49ee: "\xaa\x10\u49ee", // 䧮
	0x49ef: "\xaa\x11\u49ef", // 䧯
	0x49f0: "\xaa\x12\u49f0", // 䧰
	0x49f1: "\xac\x02\u49f1", // 䧱
	0x49f2: "\xac\x03\u49f2", // 䧲
	0x49f3: "\xac\x03\u49f3", // 䧳
	0x49f4: "\xac\x04\u49f4", // 䧴
	0x49f5: "\xac\x04\u49f5", // 䧵
	0x49f6: "\xac\x04\u49f6", // 䧶
	0x49f7: "\xac\x05\u49f7", // 䧷
	0x49f8: "\xac\x05\u49f8", // 䧸
	0x49f9: "\xac\x05\u49f9", // 䧹
	0x49fa: "\xac\x05\u49fa", // 䧺
	0x49fb: "\xac\x06\u49fb", // 䧻
	0x49fc: "\xac\a\u49fc", // 䧼
	0x49fd: "\xac\a\u49fd", // 䧽
	0x49fe: "\xac\b\u49fe", // 䧾
	0x49ff: "\xac\b\u49ff", // 䧿
	0x4a00: "w\n\u4a00", // 䨀
	0x4a01: "\xac\t\u4a01", // 䨁
	0x4a02: "\xac\t\u4a02", // 䨂
	0x4a03: "\xac\n\u4a03", // 䨃
	0x4a04: "\xac\v\u4a04", // 䨄
	0x4a05: "\xac\f\u4a05", // 䨅
	0x4a06: "\xac\f\u4a06", // 䨆
	0x4a07: "\xac\f\u4a07", // 䨇
	0x4a08: "\xac\x0e\u4a08", // 䨈
	0x4a09: "\xac\x11\u4a09", // 䨉
	0x4a0a: "\xac\x18\u4a0a", // 䨊
	0x4a0b: "\xad\x03\u4a0b", // 䨋
	0x4a0c: "\xad\x04\u4a0c", // 䨌
	0x4a0d: "\xad\x04\u4a0d", // 䨍
	0x4a0e: "\xad\x05\u4a0e", // 䨎
	0x4a0f: "\xad\x06\u4a0f", // 䨏
	0x4a10: "\xad\x06\u4a10", // 䨐
	0x4a11: "\xad\x06\u4a11", // 䨑
	0x4a12: "\xad\x06\u4a12", // 䨒
	0x4a13: "\xad\x06\u4a13", // 䨓
	0x4a14: "\xad\x06\u4a14", // 䨔
	0x4a15: "\xad\x06\u4a15", // 䨕
	0x4a16: "\xad\x06\u4a16", // 䨖
	0x4a17: "\xad\a\u4a17", // 䨗
	0x4a18: "\xad\a\u4a18", // 䨘
	0x4a19: "\xad\a\u4a19", // 䨙
	0x4a1a: "\xad\b\u4a1a", // 䨚
	0x4a1b: "\xad\b\u4a1b", // 䨛
	0x4a1c: "\xad\b\u4a1c", // 䨜
	0x4a1d: "\xad\b\u4a1d", // 䨝
	0x4a1e: "\xad\t\u4a1e", // 䨞
	0x4a1f: "\xad\t\u4a1f", // 䨟
	0x4a20: "\xad\t\u4a20", // 䨠
	0x4a21: "\xad\t\u4a21", // 䨡
	0x4a22: "\xad\t\u4a22", // 䨢
	0x4a23: "\xad\t\u4a23", // 䨣
	0x4a24: "\xad\t\u4a24", // 䨤
	0x4a25: "\xad\n\u4a25", // 䨥
	0x4a26: "\xad\n\u4a26", // 䨦
	0x4a27: "\xad\n\u4a27", // 䨧
	0x4a28: "\xad\n\u4a28", // 䨨
	0x4a29: "\xad\n\u4a29", // 䨩
	0x4a2a: "\xad\n\u4a2a", // 䨪
	0x4a2b: "\xad\v\u4a2b", // 䨫
	0x4a2c: "\xad\v\u4a2c", // 䨬
	0x4a2d: "\xad\v\u4a2d", // 䨭
	0x4a2e: "\xad\v\u4a2e", // 䨮
	0x4a2f: "\xad\v\u4a2f", // 䨯
	0x4a30: "\xad\f\u4a30", // 䨰
	0x4a31: "\xad\f\u4a31", // 䨱
	0x4a32: "\xad\x0e\u4a32", // 䨲
	0x4a33: "\xad\x0e\u4a33", // 䨳
	0x4a34: "\xad\x0e\u4a34", // 䨴
	0x4a35: "\xad\x0f\u4a35", // 䨵
	0x4a36: "\xad\x0f\u4a36", // 䨶
	0x4a37: "\xad\x10\u4a37", // 䨷
	0x4a38: "\xad\x11\u4a38", // 䨸
	0x4a39: "\xad\x13\u4a39", // 䨹
	0x4a3a: "\xad\x1c\u4a3a", // 䨺
	0x4a3b: "\xad,\u4a3b", // 䨻
	0x4a3c: "\xae\x0e\u4a3c", // 䨼
	0x4a3d: "\xaf\x03\u4a3d", // 䨽
	0x4a3e: "\xaf\x03\u4a3e", // 䨾
	0x4a3f: "\xaf\x04\u4a3f", // 䨿
	0x4a40: "\xaf\a\u4a40", // 䩀
	0x4a41: "\xaf\f\u4a41", // 䩁
	0x4a42: "\xb0\x04\u4a42", // 䩂
	0x4a43: "\xb0\x04\u4a43", // 䩃
	0x4a44: "\xb0\x04\u4a44", // 䩄
	0x4a45: "\xb0\x05\u4a45", // 䩅
	0x4a46: "\xb0\x05\u4a46", // 䩆
	0x4a47: "\xb0\x05\u4a47", // 䩇
	0x4a48: "\xb0\a\u4a48", // 䩈
	0x4a49: "\xb0\a\u4a49", // 䩉
	0x4a4a: "\xb0\b\u4a4a", // 䩊
	0x4a4b: "\xb0\v\u4a4b", // 䩋
	0x4a4c: "\xb0\f\u4a4c", // 䩌
	0x4a4d: "\xb0\f\u4a4d", // 䩍
	0x4a4e: "\xb0\r\u4a4e", // 䩎
	0x4a4f: "\xb0\x0f\u4a4f", // 䩏
	0x4a50: "\xb1\x03\u4a50", // 䩐
	0x4a51: "\xb1\x03\u4a51", // 䩑
	0x4a52: "\xb1\x03\u4a52", // 䩒
	0x4a53: "\xb1\x04\u4a53", // 䩓
	0x4a54: "\xb1\x04\u4a54", // 䩔
	0x4a55: "\xb1\x04\u4a55", // 䩕
	0x4a56: "\xb1\x04\u4a56", // 䩖
	0x4a57: "\xb1\x04\u4a57", // 䩗
	0x4a58: "\xb1\x04\u4a58", // 䩘
	0x4a59: "\xb1\x05\u4a59", // 䩙
	0x4a5a: "\xb1\x05\u4a5a", // 䩚
	0x4a5b: "\xb1\x05\u4a5b", // 䩛
	0x4a5c: "\xb1\x05\u4a5c", // 䩜
	0x4a5d: "\xb1\x05\u4a5d", // 䩝
	0x4a5e: "\xb1\x05\u4a5e", // 䩞
	0x4a5f: "\xb1\x06\u4a5f", // 䩟
	0x4a60: "\xb1\a\u4a60", // 䩠
	0x4a61: "\xb1\a\u4a61", // 䩡
	0x4a62: "\xb1\a\u4a62", // 䩢
	0x4a63: "\xb1\a\u4a63", // 䩣
	0x4a64: "\xb1\a\u4a64", // 䩤
	0x4a65: "\xb1\a\u4a65", // 䩥
	0x4a66: "\xb1\a\u4a66", // 䩦
	0x4a67: "\xb1\a\u4a67", // 䩧
	0x4a68: "\xb1\b\u4a68", // 䩨
	0x4a69: "\xb1\b\u4a69", // 䩩
	0x4a6a: "\xb1\b\u4a6a", // 䩪
	0x4a6b: "\xb1\b\u4a6b", // 䩫
	0x4a6c: "\xb1\b\u4a6c", // 䩬
	0x4a6d: "\xb1\b\u4a6d", // 䩭
	0x4a6e: "\xb1\b\u4a6e", // 䩮
	0x4a6f: "\xb1\t\u4a6f", // 䩯
	0x4a70: "\xb1\t\u4a70", // 䩰
	0x4a71: "\xb1\t\u4a71", // 䩱
	0x4a72: "\xb1\t\u4a72", // 䩲
	0x4a73: "\xb1\t\u4a73", // 䩳
	0x4a74: "\xb1\t\u4a74", // 䩴
	0x4a75: "\xb1\t\u4a75", // 䩵
	0x4a76: "\xb1\n\u4a76", // 䩶
	0x4a77: "\xb1\n\u4a77", // 䩷
	0x4a78: "\xb1\n\u4a78", // 䩸
	0x4a79: "\xb1\n\u4a79", // 䩹
	0x4a7a: "\xb1\n\u4a7a", // 䩺
	0x4a7b: "\xb1\n\u4a7b", // 䩻
	0x4a7c: "\xb1\v\u4a7c", // 䩼
	0x4a7d: "\xb1\v\u4a7d", // 䩽
	0x4a7e: "\xb1\v\u4a7e", // 䩾
	0x4a7f: "\xb1\f\u4a7f", // 䩿
	0x4a80: "\xb1\f\u4a80", // 䪀
	0x4a81: "\xb1\f\u4a81", // 䪁
	0x4a82: "\xb1\f\u4a82", // 䪂
	0x4a83: "\xb1\f\u4a83", // 䪃
	0x4a84: "\xb1\f\u4a84", // 䪄
	0x4a85: "\xb1\r\u4a85", // 䪅
	0x4a86: "\xb1\r\u4a86", // 䪆
	0x4a87: "\xb1\x0e\u4a87", // 䪇
	0x4a88: "\xb1\x0e\u4a88", // 䪈
	0x4a89: "\xb1\x0f\u4a89", // 䪉
	0x4a8a: "\xb1\x10\u4a8a", // 䪊
	0x4a8b: "\xb1\x10\u4a8b", // 䪋
	0x4a8c: "\xb1\x11\u4a8c", // 䪌
	0x4a8d: "\xb1\x11\u4a8d", // 䪍
	0x4a8e: "\xb1\x12\u4a8e", // 䪎
	0x4a8f: "\xb2\x04\u4a8f", // 䪏
	0x4a90: "\xb2\x05\u4a90", // 䪐
	0x4a91: "\xb2\x05\u4a91", // 䪑
	0x4a92: "\xb2\x05\u4a92", // 䪒
	0x4a93: "\xb2\x05\u4a93", // 䪓
	0x4a94: "\xb2\a\u4a94", // 䪔
	0x4a95: "\xb2\b\u4a95", // 䪕
	0x4a96: "\xb2\t\u4a96", // 䪖
	0x4a97: "\xb2\t\u4a97", // 䪗
	0x4a98: "\xb2\t\u4a98", // 䪘
	0x4a99: "\xb2\n\u4a99", // 䪙
	0x4a9a: "\xb2\n\u4a9a", // 䪚
	0x4a9b: "\xb2\f\u4a9b", // 䪛
	0x4a9c: "\xb2\r\u4a9c", // 䪜
	0x4a9d: "\xb2\x0e\u4a9d", // 䪝
	0x4a9e: "\xb3\x04\u4a9e", // 䪞
	0x4a9f: "\xb3\x06\u4a9f", // 䪟
	0x4aa0: "\xb3\b\u4aa0", // 䪠
	0x4aa1: "\xb3\n\u4aa1", // 䪡
	0x4aa2: "\xb3\n\u4aa2", // 䪢
	0x4aa3: "\xb3\v\u4aa3", // 䪣
	0x4aa4: "\xb3\f\u4aa4", // 䪤
	0x4aa5: "\xb3\x0e\u4aa5", // 䪥
	0x4aa6: "\xb4\x03\u4aa6", // 䪦
	0x4aa7: "\xb4\x03\u4aa7", // 䪧
	0x4aa8: "\xb4\x03\u4aa8", // 䪨
	0x4aa9: "\xb4\x04\u4aa9", // 䪩
	0x4aaa: "\xb4\x05\u4aaa", // 䪪
	0x4aab: "\xb4\a\u4aab", // 䪫
	0x4aac: "\xb4\a\u4aac", // 䪬
	0x4aad: "\xb4\t\u4aad", // 䪭
	0x4aae: "\xb4\n\u4aae", // 䪮
	0x4aaf: "\xb4\n\u4aaf", // 䪯
	0x4ab0: "\xb4\r\u4ab0", // 䪰
	0x4ab1: "\xb5\x03\u4ab1", // 䪱
	0x4ab2: "\xb5\x03\u4ab2", // 䪲
	0x4ab3: "\xb5\x04\u4ab3", // 䪳
	0x4ab4: "\xb5\x04\u4ab4", // 䪴
	0x4ab5: "\xb5\x04\u4ab5", // 䪵
	0x4ab6: "\xb5\x05\u4ab6", // 䪶
	0x4ab7: "\xb5\x05\u4ab7", // 䪷
	0x4ab8: "\xb5\x05\u4ab8", // 䪸
	0x4ab9: "\xb5\x05\u4ab9", // 䪹
	0x4aba: "\xb5\x05\u4aba", // 䪺
	0x4abb: "\xb5\x05\u4abb", // 䪻
	0x4abc: "\xb5\x05\u4abc", // 䪼
	0x4abd: "\xb5\x05\u4abd", // 䪽
	0x4abe: "\xb5\x05\u4abe", // 䪾
	0x4abf: "\xb5\x06\u4abf", // 䪿
	0x4ac0: "\xb5\x06\u4ac0", // 䫀
	0x4ac1: "\xb5\x06\u4ac1", // 䫁
	0x4ac2: "\xb5\x06\u4ac2", // 䫂
	0x4ac3: "\xb5\a\u4ac3", // 䫃
	0x4ac4: "\xb5\a\u4ac4", // 䫄
	0x4ac5: "\xb5\a\u4ac5", // 䫅
	0x4ac6: "\xb5\a\u4ac6", // 䫆
	0x4ac7: "\xb5\a\u4ac7", // 䫇
	0x4ac8: "\xb5\a\u4ac8", // 䫈
	0x4ac9: "\xb5\a\u4ac9", // 䫉
	0x4aca: "\xb5\a\u4aca", // 䫊
	0x4acb: "\xb5\b\u4acb", // 䫋
	0x4acc: "\xb5\b\u4acc", // 䫌
	0x4acd: "\xb5\b\u4acd", // 䫍
	0x4ace: "\xb5\b\u4ace", // 䫎
	0x4acf: "\xb5\b\u4acf", // 䫏
	0x4ad0: "\xb5\b\u4ad0", // 䫐
	0x4ad1: "\xb5\b\u4ad1", // 䫑
	0x4ad2: "\xb5\b\u4ad2", // 䫒
	0x4ad3: "\xb5\b\u4ad3", // 䫓
	0x4ad4: "\xb5\t\u4ad4", // 䫔
	0x4ad5: "\xb5\t\u4ad5", // 䫕
	0x4ad6: "\xb5\t\u4ad6", // 䫖
	0x4ad7: "\xb5\t\u4ad7", // 䫗
	0x4ad8: "\xb5\t\u4ad8", // 䫘
	0x4ad9: "\xb5\t\u4ad9", // 䫙
	0x4ada: "\xb5\t\u4ada", // 䫚
	0x4adb: "\xb5\t\u4adb", // 䫛
	0x4adc: "\xb5\t\u4adc", // 䫜
	0x4add: "\xb5\t\u4add", // 䫝
	0x4ade: "\xb5\n\u4ade", // 䫞
	0x4adf: "\xb5\n\u4adf", // 䫟
	0x4ae0: "\xb5\n\u4ae0", // 䫠
	0x4ae1: "\xb5\n\u4ae1", // 䫡
	0x4ae2: "\xb5\n\u4ae2", // 䫢
	0x4ae3: "\xb5\n\u4ae3", // 䫣
	0x4ae4: "\xb5\n\u4ae4", // 䫤
	0x4ae5: "\xb5\n\u4ae5", // 䫥
	0x4ae6: "\xb5\n\u4ae6", // 䫦
	0x4ae7: "\xb5\n\u4ae7", // 䫧
	0x4ae8: "\xb5\v\u4ae8", // 䫨
	0x4ae9: "\xb5\v\u4ae9", // 䫩
	0x4aea: "\xb5\v\u4aea", // 䫪
	0x4aeb: "\xb5\v\u4aeb", // 䫫
	0x4aec: "\xb5\f\u4aec", // 䫬
	0x4aed: "\xb5\f\u4aed", // 䫭
	0x4aee: "\xb5\f\u4aee", // 䫮
	0x4aef: "\xb5\f\u4aef", // 䫯
	0x4af0: "\xb5\f\u4af0", // 䫰
	0x4af1: "\xb5\f\u4af1", // 䫱
	0x4af2: "\xb5\r\u4af2", // 䫲
	0x4af3: "\xb5\r\u4af3", // 䫳
	0x4af4: "\xb5\r\u4af4", // 䫴
	0x4af5: "\xb5\x0f\u4af5", // 䫵
	0x4af6: "\xb5\x0f\u4af6", // 䫶
	0x4af7: "\xb5\x10\u4af7", // 䫷
	0x4af8: "\xb6\x02\u4af8", // 䫸
	0x4af9: "\xb6\x03\u4af9", // 䫹
	0x4afa: "\xb6\x04\u4afa", // 䫺
	0x4afb: "\xb6\x04\u4afb", // 䫻
	0x4afc: "\xb6\x04\u4afc", // 䫼
	0x4afd: "\xb6\x04\u4afd", // 䫽
	0x4afe: "\xb6\x05\u4afe", // 䫾
	0x4aff: "\xb6\x05\u4aff", // 䫿
	0x4b00: "\xb6\x05\u4b00", // 䬀
	0x4b01: "\xb6\x05\u4b01", // 䬁
	0x4b02: "\xb6\x05\u4b02", // 䬂
	0x4b03: "\xb6\x05\u4b03", // 䬃
	0x4b04: "\xb6\x06\u4b04", // 䬄
	0x4b05: "\xb6\x06\u4b05", // 䬅
	0x4b06: "\xb6\a\u4b06", // 䬆
	0x4b07: "\xb6\a\u4b07", // 䬇
	0x4b08: "\xb6\a\u4b08", // 䬈
	0x4b09: "\xb6\a\u4b09", // 䬉
	0x4b0a: "\xb6\a\u4b0a", // 䬊
	0x4b0b: "\xb6\b\u4b0b", // 䬋
	0x4b0c: "\xb6\b\u4b0c", // 䬌
	0x4b0d: "\xb6\b\u4b0d", // 䬍
	0x4b0e: "\xb6\b\u4b0e", // 䬎
	0x4b0f: "\xb6\b\u4b0f", // 䬏
	0x4b10: "\xb6\b\u4b10", // 䬐
	0x4b11: "\xb6\t\u4b11", // 䬑
	0x4b12: "\xb6\t\u4b12", // 䬒
	0x4b13: "\xb6\t\u4b13", // 䬓
	0x4b14: "\xb6\t\u4b14", // 䬔
	0x4b15: "\xb6\t\u4b15", // 䬕
	0x4b16: "\xb6\t\u4b16", // 䬖
	0x4b17: "\xb6\t\u4b17", // 䬗
	0x4b18: "\xb6\n\u4b18", // 䬘
	0x4b19: "\xb6\n\u4b19", // 䬙
	0x4b1a: "\xb6\n\u4b1a", // 䬚
	0x4b1b: "\xb6\v\u4b1b", // 䬛
	0x4b1c: "\xb6\v\u4b1c", // 䬜
	0x4b1d: "\xb6\f\u4b1d", // 䬝
	0x4b1e: "\xb6\x0e\u4b1e", // 䬞
	0x4b1f: "\xb6\x0f\u4b1f", // 䬟
	0x4b20: "\xb7\b\u4b20", // 䬠
	0x4b21: "\xb7\t\u4b21", // 䬡
	0x4b22: "\xb8\x02\u4b22", // 䬢
	0x4b23: "\xb8\x03\u4b23", // 䬣
	0x4b24: "\xb8\x03\u4b24", // 䬤
	0x4b25: "\xb8\x03\u4b25", // 䬥
	0x4b26: "\xb8\x04\u4b26", // 䬦
	0x4b27: "\xb8\x04\u4b27", // 䬧
	0x4b28: "\xb8\x04\u4b28", // 䬨
	0x4b29: "\xb8\x04\u4b29", // 䬩
	0x4b2a: "\xb8\x04\u4b2a", // 䬪
	0x4b2b: "\xb8\x05\u4b2b", // 䬫
	0x4b2c: "\xb8\x05\u4b2c", // 䬬
	0x4b2d: "\xb8\x05\u4b2d", // 䬭
	0x4b2e: "\xb8\x05\u4b2e", // 䬮
	0x4b2f: "\xb8\x05\u4b2f", // 䬯
	0x4b30: "\xb8\x05\u4b30", // 䬰
	0x4b31: "\xb8\x05\u4b31", // 䬱
	0x4b32: "\xb8\x05\u4b32", // 䬲
	0x4b33: "\xb8\x05\u4b33", // 䬳
	0x4b34: "\xb8\x05\u4b34", // 䬴
	0x4b35: "\xb8\x06\u4b35", // 䬵
	0x4b36: "\xb8\x06\u4b36", // 䬶
	0x4b37: "\xb8\x06\u4b37", // 䬷
	0x4b38: "\xb8\x06\u4b38", // 䬸
	0x4b39: "\xb8\x06\u4b39", // 䬹
	0x4b3a: "\xb8\x06\u4b3a", // 䬺
	0x4b3b: "\xb8\x06\u4b3b", // 䬻
	0x4b3c: "\xb8\a\u4b3c", // 䬼
	0x4b3d: "\xb8\a\u4b3d", // 䬽
	0x4b3e: "\xb8\a\u4b3e", // 䬾
	0x4b3f: "\xb8\a\u4b3f", // 䬿
	0x4b40: "\xb8\a\u4b40", // 䭀
	0x4b41: "\xb8\a\u4b41", // 䭁
	0x4b42: "\xb8\a\u4b42", // 䭂
	0x4b43: "\xb8\b\u4b43", // 䭃
	0x4b44: "\xb8\b\u4b44", // 䭄
	0x4b45: "\xb8\b\u4b45", // 䭅
	0x4b46: "\xb8\b\u4b46", // 䭆
	0x4b47: "\xb8\b\u4b47", // 䭇
	0x4b48: "\xb8\t\u4b48", // 䭈
	0x4b49: "\xb8\t\u4b49", // 䭉
	0x4b4a: "\xb8\t\u4b4a", // 䭊
	0x4b4b: "\xb8\t\u4b4b", // 䭋
	0x4b4c: "\xb8\t\u4b4c", // 䭌
	0x4b4d: "\xb8\t\u4b4d", // 䭍
	0x4b4e: "\xb8\t\u4b4e", // 䭎
	0x4b4f: "\xb8\t\u4b4f", // 䭏
	0x4b50: "\xb8\n\u4b50", // 䭐
	0x4b51: "\xb8\n\u4b51", // 䭑
	0x4b52: "\xb8\n\u4b52", // 䭒
	0x4b53: "\xb8\n\u4b53", // 䭓
	0x4b54: "\xb8\n\u4b54", // 䭔
	0x4b55: "\xb8\v\u4b55", // 䭕
	0x4b56: "\xb8\v\u4b56", // 䭖
	0x4b57: "\xb8\v\u4b57", // 䭗
	0x4b58: "\xb8\f\u4b58", // 䭘
	0x4b59: "\xb8\f\u4b59", // 䭙
	0x4b5a: "\xb8\f\u4b5a", // 䭚
	0x4b5b: "\xb8\f\u4b5b", // 䭛
	0x4b5c: "\xb8\f\u4b5c", // 䭜
	0x4b5d: "\xb8\r\u4b5d", // 䭝
	0x4b5e: "\xb8\r\u4b5e", // 䭞
	0x4b5f: "\xb8\r\u4b5f", // 䭟
	0x4b60: "\xb8\r\u4b60", // 䭠
	0x4b61: "\xb8\x0e\u4b61", // 䭡
	0x4b62: "\xb8\x0e\u4b62", // 䭢
	0x4b63: "\xb8\x0e\u4b63", // 䭣
	0x4b64: "\xb8\x0e\u4b64", // 䭤
	0x4b65: "\xb8\x0f\u4b65", // 䭥
	0x4b66: "\xb8\x11\u4b66", // 䭦
	0x4b67: "\xb8\x11\u4b67", // 䭧
	0x4b68: "\xb8\x12\u4b68", // 䭨
	0x4b69: "\xb8\x13\u4b69", // 䭩
	0x4b6a: "\xb8\f\u4b6a", // 䭪
	0x4b6b: "\xb9\x06\u4b6b", // 䭫
	0x4b6c: "\xb9\x06\u4b6c", // 䭬
	0x4b6d: "\xb9\t\u4b6d", // 䭭
	0x4b6e: "\xb9\n\u4b6e", // 䭮
	0x4b6f: "\xba\x05\u4b6f", // 䭯
	0x4b70: "\xba\b\u4b70", // 䭰
	0x4b71: "\xba\b\u4b71", // 䭱
	0x4b72: "\xba\b\u4b72", // 䭲
	0x4b73: "\xba\x12\u4b73", // 䭳
	0x4b74: "\xbb\x02\u4b74", // 䭴
	0x4b75: "\xbb\x03\u4b75", // 䭵
	0x4b76: "\xbb\x03\u4b76", // 䭶
	0x4b77: "\xbb\x04\u4b77", // 䭷
	0x4b78: "\xbb\x04\u4b78", // 䭸
	0x4b79: "\xbb\x04\u4b79", // 䭹
	0x4b7a: "\xbb\x04\u4b7a", // 䭺
	0x4b7b: "\xbb\x04\u4b7b", // 䭻
	0x4b7c: "\xbb\x04\u4b7c", // 䭼
	0x4b7d: "\xbb\x04\u4b7d", // 䭽
	0x4b7e: "\xbb\x04\u4b7e", // 䭾
	0x4b7f: "\xbb\x05\u4b7f", // 䭿
	0x4b80: "\xbb\x05\u4b80", // 䮀
	0x4b81: "\xbb\x05\u4b81", // 䮁
	0x4b82: "\xbb\x05\u4b82", // 䮂
	0x4b83: "\xbb\x05\u4b83", // 䮃
	0x4b84: "\xbb\x05\u4b84", // 䮄
	0x4b85: "\xbb\x05\u4b85", // 䮅
	0x4b86: "\xbb\x06\u4b86", // 䮆
	0x4b87: "\xbb\x06\u4b87", // 䮇
	0x4b88: "\xbb\x06\u4b88", // 䮈
	0x4b89: "\xbb\x06\u4b89", // 䮉
	0x4b8a: "\xbb\x06\u4b8a", // 䮊
	0x4b8b: "\xbb\x06\u4b8b", // 䮋
	0x4b8c: "\xbb\x06\u4b8c", // 䮌
	0x4b8d: "\xbb\x06\u4b8d", // 䮍
	0x4b8e: "\xbb\a\u4b8e", // 䮎
	0x4b8f: "\xbb\a\u4b8f", // 䮏
	0x4b90: "\xbb\a\u4b90", // 䮐
	0x4b91: "\xbb\a\u4b91", // 䮑
	0x4b92: "\xbb\a\u4b92", // 䮒
	0x4b93: "\xbb\b\u4b93", // 䮓
	0x4b94: "\xbb\b\u4b94", // 䮔
	0x4b95: "\xbb\b\u4b95", // 䮕
	0x4b96: "\xbb\b\u4b96", // 䮖
	0x4b97: "\xbb\b\u4b97", // 䮗
	0x4b98: "\xbb\b\u4b98", // 䮘
	0x4b99: "\xbb\b\u4b99", // 䮙
	0x4b9a: "\xbb\b\u4b9a", // 䮚
	0x4b9b: "\xbb\b\u4b9b", // 䮛
	0x4b9c: "\xbb\t\u4b9c", // 䮜
	0x4b9d: "\xbb\t\u4b9d", // 䮝
	0x4b9e: "\xbb\t\u4b9e", // 䮞
	0x4b9f: "\xbb\t\u4b9f", // 䮟
	0x4ba0: "\xbb\t\u4ba0", // 䮠
	0x4ba1: "\xbb\t\u4ba1", // 䮡
	0x4ba2: "\xbb\t\u4ba2", // 䮢
	0x4ba3: "\xbb\n\u4ba3", // 䮣
	0x4ba4: "\xbb\n\u4ba4", // 䮤
	0x4ba5: "\xbb\n\u4ba5", // 䮥
	0x4ba6: "\xbb\n\u4ba6", // 䮦
	0x4ba7: "\xbb\n\u4ba7", // 䮧
	0x4ba8: "\xbb\n\u4ba8", // 䮨
	0x4ba9: "\xbb\n\u4ba9", // 䮩
	0x4baa: "\xbb\v\u4baa", // 䮪
	0x4bab: "\xbb\v\u4bab", // 䮫
	0x4bac: "\xbb\v\u4bac", // 䮬
	0x4bad: "\xbb\v\u4bad", // 䮭
	0x4bae: "\xbb\v\u4bae", // 䮮
	0x4baf: "\xbb\v\u4baf", // 䮯
	0x4bb0: "\xbb\v\u4bb0", // 䮰
	0x4bb1: "\xbb\v\u4bb1", // 䮱
	0x4bb2: "\xbb\f\u4bb2", // 䮲
	0x4bb3: "\xbb\f\u4bb3", // 䮳
	0x4bb4: "\xbb\f\u4bb4", // 䮴
	0x4bb5: "\xbb\f\u4bb5", // 䮵
	0x4bb6: "\xbb\f\u4bb6", // 䮶
	0x4bb7: "\xbb\r\u4bb7", // 䮷
	0x4bb8: "\xbb\r\u4bb8", // 䮸
	0x4bb9: "\xbb\r\u4bb9", // 䮹
	0x4bba: "\xbb\x0e\u4bba", // 䮺
	0x4bbb: "\xbb\x0e\u4bbb", // 䮻
	0x4bbc: "\xbb\x0e\u4bbc", // 䮼
	0x4bbd: "\xbb\x0f\u4bbd", // 䮽
	0x4bbe: "\xbb\x10\u4bbe", // 䮾
	0x4bbf: "\xbb\x11\u4bbf", // 䮿
	0x4bc0: "\xbb\x12\u4bc0", // 䯀
	0x4bc1: "\xbb\x13\u4bc1", // 䯁
	0x4bc2: "\xbb\x18\u4bc2", // 䯂
	0x4bc3: "\xbb\x06\u4bc3", // 䯃
	0x4bc4: "\xbb\a\u4bc4", // 䯄
	0x4bc5: "\xbb\n\u4bc5", // 䯅
	0x4bc6: "\xbc\x01\u4bc6", // 䯆
	0x4bc7: "\xbc\x02\u4bc7", // 䯇
	0x4bc8: "\xbc\x04\u4bc8", // 䯈
	0x4bc9: "\xbc\x04\u4bc9", // 䯉
	0x4bca: "\xbc\x05\u4bca", // 䯊
	0x4bcb: "\xbc\x05\u4bcb", // 䯋
	0x4bcc: "\xbc\x05\u4bcc", // 䯌
	0x4bcd: "\xbc\x05\u4bcd", // 䯍
	0x4bce: "\xbc\x05\u4bce", // 䯎
	0x4bcf: "\xbc\x06\u4bcf", // 䯏
	0x4bd0: "\xbc\x06\u4bd0", // 䯐
	0x4bd1: "\xbc\x06\u4bd1", // 䯑
	0x4bd2: "\xbc\x06\u4bd2", // 䯒
	0x4bd3: "\xbc\x06\u4bd3", // 䯓
	0x4bd4: "\xbc\x06\u4bd4", // 䯔
	0x4bd5: "\xbc\a\u4bd5", // 䯕
	0x4bd6: "\xbc\a\u4bd6", // 䯖
	0x4bd7: "\xbc\a\u4bd7", // 䯗
	0x4bd8: "\xbc\a\u4bd8", // 䯘
	0x4bd9: "\xbc\a\u4bd9", // 䯙
	0x4bda: "\xbc\a\u4bda", // 䯚
	0x4bdb: "\xbc\b\u4bdb", // 䯛
	0x4bdc: "\xbc\b\u4bdc", // 䯜
	0x4bdd: "\xbc\t\u4bdd", // 䯝
	0x4bde: "\xbc\t\u4bde", // 䯞
	0x4bdf: "\xbc\t\u4bdf", // 䯟
	0x4be0: "\xbc\t\u4be0", // 䯠
	0x4be1: "\xbc\n\u4be1", // 䯡
	0x4be2: "\xbc\v\u4be2", // 䯢
	0x4be3: "\xbc\f\u4be3", // 䯣
	0x4be4: "\xbc\r\u4be4", // 䯤
	0x4be5: "\xbc\x0e\u4be5", // 䯥
	0x4be6: "\xbc\x0f\u4be6", // 䯦
	0x4be7: "\xbd\x02\u4be7", // 䯧
	0x4be8: "\xbd\x03\u4be8", // 䯨
	0x4be9: "\xbd\x04\u4be9", // 䯩
	0x4bea: "\xbd\t\u4bea", // 䯪
	0x4beb: "\xbd\f\u4beb", // 䯫
	0x4bec: "\xbd\x0f\u4bec", // 䯬
	0x4bed: "\xbe\x02\u4bed", // 䯭
	0x4bee: "\xbe\x02\u4bee", // 䯮
	0x4bef: "\xbe\x04\u4bef", // 䯯
	0x4bf0: "\xbe\x04\u4bf0", // 䯰
	0x4bf1: "\xbe\x04\u4bf1", // 䯱
	0x4bf2: "\xbe\x04\u4bf2", // 䯲
	0x4bf3: "\xbe\x04\u4bf3", // 䯳
	0x4bf4: "\xbe\x04\u4bf4", // 䯴
	0x4bf5: "\xbe\x05\u4bf5", // 䯵
	0x4bf6: "\xbe\x05\u4bf6", // 䯶
	0x4bf7: "\xbe\x06\u4bf7", // 䯷
	0x4bf8: "\xbe\x06\u4bf8", // 䯸
	0x4bf9: "\xbe\a\u4bf9", // 䯹
	0x4bfa: "\xbe\a\u4bfa", // 䯺
	0x4bfb: "\xbe\a\u4bfb", // 䯻
	0x4bfc: "\xbe\a\u4bfc", // 䯼
	0x4bfd: "\xbe\b\u4bfd", // 䯽
	0x4bfe: "\xbe\b\u4bfe", // 䯾
	0x4bff: "\xbe\b\u4bff", // 䯿
	0x4c00: "\xbe\b\u4c00", // 䰀
	0x4c01: "\xbe\b\u4c01", // 䰁
	0x4c02: "\xbe\b\u4c02", // 䰂
	0x4c03: "\xbe\b\u4c03", // 䰃
	0x4c04: "\xbe\t\u4c04", // 䰄
	0x4c05: "\xbe\t\u4c05", // 䰅
	0x4c06: "\xbe\t\u4c06", // 䰆
	0x4c07: "\xbe\t\u4c07", // 䰇
	0x4c08: "\xbe\n\u4c08", // 䰈
	0x4c09: "\xbe\n\u4c09", // 䰉
	0x4c0a: "\xbe\n\u4c0a", // 䰊
	0x4c0b: "\xbe\n\u4c0b", // 䰋
	0x4c0c: "\xbe\v\u4c0c", // 䰌
	0x4c0d: "\xbe\v\u4c0d", // 䰍
	0x4c0e: "\xbe\f\u4c0e", // 䰎
	0x4c0f: "\xbe\x0e\u4c0f", // 䰏
	0x4c10: "\xbe\x0e\u4c10", // 䰐
	0x4c11: "\xbe\x0e\u4c11", // 䰑
	0x4c12: "\xbe\x0e\u4c12", // 䰒
	0x4c13: "\xbe\x0f\u4c13", // 䰓
	0x4c14: "\xbe\x0f\u4c14", // 䰔
	0x4c15: "\xbe\x10\u4c15", // 䰕
	0x4c16: "\xbe\x13\u4c16", // 䰖
	0x4c17: "\xbf\n\u4c17", // 䰗
	0x4c18: "\xbf\v\u4c18", // 䰘
	0x4c19: "\xc1\x04\u4c19", // 䰙
	0x4c1a: "\xc1\x04\u4c1a", // 䰚
	0x4c1b: "\xc1\x05\u4c1b", // 䰛
	0x4c1c: "\xc1\x06\u4c1c", // 䰜
	0x4c1d: "\xc1\f\u4c1d", // 䰝
	0x4c1e: "\xc1\x0f\u4c1e", // 䰞
	0x4c1f: "\xc2\x04\u4c1f", // 䰟
	0x4c20: "\xc2\x05\u4c20", // 䰠
	0x4c21: "\xc2\x05\u4c21", // 䰡
	0x4c22: "\xc2\x06\u4c22", // 䰢
	0x4c23: "\xc2\x06\u4c23", // 䰣
	0x4c24: "\xc2\b\u4c24", // 䰤
	0x4c25: "\xc2\b\u4c25", // 䰥
	0x4c26: "\xc2\b\u4c26", // 䰦
	0x4c27: "\xc2\b\u4c27", // 䰧
	0x4c28: "\xc2\t\u4c28", // 䰨
	0x4c29: "\xc2\t\u4c29", // 䰩
	0x4c2a: "\xc2\n\u4c2a", // 䰪
	0x4c2b: "\xc2\f\u4c2b", // 䰫
	0x4c2c: "\xc2\f\u4c2c", // 䰬
	0x4c2d: "\xc2\f\u4c2d", // 䰭
	0x4c2e: "\xc2\r\u4c2e", // 䰮
	0x4c2f: "\xc2\x0e\u4c2f", // 䰯
	0x4c30: "\xc2\x0e\u4c30", // 䰰
	0x4c31: "\xc2\x18\u4c31", // 䰱
	0x4c32: "\xc3\x01\u4c32", // 䰲
	0x4c33: "\xc3\x02\u4c33", // 䰳
	0x4c34: "\xc3\x03\u4c34", // 䰴
	0x4c35: "\xc3\x03\u4c35", // 䰵
	0x4c36: "\xc3\x03\u4c36", // 䰶
	0x4c37: "\xc3\x04\u4c37", // 䰷
	0x4c38: "\xc3\x04\u4c38", // 䰸
	0x4c39: "\xc3\x04\u4c39", // 䰹
	0x4c3a: "\xc3\x04\u4c3a", // 䰺
	0x4c3b: "\xc3\x04\u4c3b", // 䰻
	0x4c3c: "\xc3\x04\u4c3c", // 䰼
	0x4c3d: "\xc3\x04\u4c3d", // 䰽
	0x4c3e: "\xc3\x04\u4c3e", // 䰾
	0x4c3f: "\xc3\x05\u4c3f", // 䰿
	0x4c40: "\xc3\x05\u4c40", // 䱀
	0x4c41: "\xc3\x05\u4c41", // 䱁
	0x4c42: "\xc3\x05\u4c42", // 䱂
	0x4c43: "\xc3\x05\u4c43", // 䱃
	0x4c44: "\xc3\x05\u4c44", // 䱄
	0x4c45: "\xc3\x05\u4c45", // 䱅
	0x4c46: "\xc3\x05\u4c46", // 䱆
	0x4c47: "\xc3\x05\u4c47", // 䱇
	0x4c48: "\xc3\x05\u4c48", // 䱈
	0x4c49: "\xc3\x05\u4c49", // 䱉
	0x4c4a: "\xc3\x06\u4c4a", // 䱊
	0x4c4b: "\xc3\x06\u4c4b", // 䱋
	0x4c4c: "\xc3\x06\u4c4c", // 䱌
	0x4c4d: "\xc3\x06\u4c4d", // 䱍
	0x4c4e: "\xc3\x06\u4c4e", // 䱎
	0x4c4f: "\xc3\a\u4c4f", // 䱏
	0x4c50: "\xc3\a\u4c50", // 䱐
	0x4c51: "\xc3\a\u4c51", // 䱑
	0x4c52: "\xc3\a\u4c52", // 䱒
	0x4c53: "\xc3\a\u4c53", // 䱓
	0x4c54: "\xc3\a\u4c54", // 䱔
	0x4c55: "\xc3\a\u4c55", // 䱕
	0x4c56: "\xc3\a\u4c56", // 䱖
	0x4c57: "\xc3\a\u4c57", // 䱗
	0x4c58: "\xc3\a\u4c58", // 䱘
	0x4c59: "\xc3\b\u4c59", // 䱙
	0x4c5a: "\xc3\b\u4c5a", // 䱚
	0x4c5b: "\xc3\b\u4c5b", // 䱛
	0x4c5c: "\xc3\b\u4c5c", // 䱜
	0x4c5d: "\xc3\b\u4c5d", // 䱝
	0x4c5e: "\xc3\b\u4c5e", // 䱞
	0x4c5f: "\xc3\b\u4c5f", // 䱟
	0x4c60: "\xc3\b\u4c60", // 䱠
	0x4c61: "\xc3\b\u4c61", // 䱡
	0x4c62: "\xc3\b\u4c62", // 䱢
	0x4c63: "\xc3\b\u4c63", // 䱣
	0x4c64: "\xc3\b\u4c64", // 䱤
	0x4c65: "\xc3\b\u4c65", // 䱥
	0x4c66: "\xc3\b\u4c66", // 䱦
	0x4c67: "\xc3\b\u4c67", // 䱧
	0x4c68: "\xc3\b\u4c68", // 䱨
	0x4c69: "\xc3\b\u4c69", // 䱩
	0x4c6a: "\xc3\b\u4c6a", // 䱪
	0x4c6b: "\xc3\t\u4c6b", // 䱫
	0x4c6c: "\xc3\t\u4c6c", // 䱬
	0x4c6d: "\xc3\t\u4c6d", // 䱭
	0x4c6e: "\xc3\t\u4c6e", // 䱮
	0x4c6f: "\xc3\t\u4c6f", // 䱯
	0x4c70: "\xc3\t\u4c70", // 䱰
	0x4c71: "\xc3\t\u4c71", // 䱱
	0x4c72: "\xc3\t\u4c72", // 䱲
	0x4c73: "\xc3\t\u4c73", // 䱳
	0x4c74: "\xc3\t\u4c74", // 䱴
	0x4c75: "\xc3\n\u4c75", // 䱵
	0x4c76: "\xc3\n\u4c76", // 䱶
	0x4c77: "\xc3\n\u4c77", // 䱷
	0x4c78: "\xc3\n\u4c78", // 䱸
	0x4c79: "\xc3\n\u4c79", // 䱹
	0x4c7a: "\xc3\n\u4c7a", // 䱺
	0x4c7b: "\xc3\n\u4c7b", // 䱻
	0x4c7c: "\xc3\n\u4c7c", // 䱼
	0x4c7d: "\xc3\n\u4c7d", // 䱽
	0x4c7e: "\xc3\v\u4c7e", // 䱾
	0x4c7f: "\xc3\v\u4c7f", // 䱿
	0x4c80: "\xc3\v\u4c80", // 䲀
	0x4c81: "\xc3\v\u4c81", // 䲁
	0x4c82: "\xc3\v\u4c82", // 䲂
	0x4c83: "\xc3\v\u4c83", // 䲃
	0x4c84: "\xc3\v\u4c84", // 䲄
	0x4c85: "\xc3\v\u4c85", // 䲅
	0x4c86: "\xc3\v\u4c86", // 䲆
	0x4c87: "\xc3\v\u4c87", // 䲇
	0x4c88: "\xc3\v\u4c88", // 䲈
	0x4c89: "\xc3\f\u4c89", // 䲉
	0x4c8a: "\xc3\f\u4c8a", // 䲊
	0x4c8b: "\xc3\f\u4c8b", // 䲋
	0x4c8c: "\xc3\f\u4c8c", // 䲌
	0x4c8d: "\xc3\f\u4c8d", // 䲍
	0x4c8e: "\xc3\f\u4c8e", // 䲎
	0x4c8f: "\xc3\f\u4c8f", // 䲏
	0x4c90: "\xc3\r\u4c90", // 䲐
	0x4c91: "\xc3\r\u4c91", // 䲑
	0x4c92: "\xc3\r\u4c92", // 䲒
	0x4c93: "\xc3\r\u4c93", // 䲓
	0x4c94: "\xc3\r\u4c94", // 䲔
	0x4c95: "\xc3\r\u4c95", // 䲕
	0x4c96: "\xc3\x0e\u4c96", // 䲖
	0x4c97: "\xc3\x0e\u4c97", // 䲗
	0x4c98: "\xc3\x0e\u4c98", // 䲘
	0x4c99: "\xc3\x0f\u4c99", // 䲙
	0x4c9a: "\xc3\x10\u4c9a", // 䲚
	0x4c9b: "\xc3\x10\u4c9b", // 䲛
	0x4c9c: "\xc3!\u4c9c", // 䲜
	0x4c9d: "\xc3\x04\u4c9d", // 䲝
	0x4c9e: "\xc3\x05\u4c9e", // 䲞
	0x4c9f: "\xc3\x05\u4c9f", // 䲟
	0x4ca0: "\xc3\t\u4ca0", // 䲠
	0x4ca1: "\xc3\t\u4ca1", // 䲡
	0x4ca2: "\xc3\n\u4ca2", // 䲢
	0x4ca3: "\xc3\n\u4ca3", // 䲣
	0x4ca4: "\xc3\n\u4ca4", // 䲤
	0x4ca5: "\xc4\x02\u4ca5", // 䲥
	0x4ca6: "\xc4\x03\u4ca6", // 䲦
	0x4ca7: "\xc4\x03\u4ca7", // 䲧
	0x4ca8: "\xc4\x03\u4ca8", // 䲨
	0x4ca9: "\xc4\x03\u4ca9", // 䲩
	0x4caa: "\xc4\x03\u4caa", // 䲪
	0x4cab: "\xc4\x03\u4cab", // 䲫
	0x4cac: "\xc4\x04\u4cac", // 䲬
	0x4cad: "\xc4\x04\u4cad", // 䲭
	0x4cae: "\xc4\x04\u4cae", // 䲮
	0x4caf: "\xc4\x04\u4caf", // 䲯
	0x4cb0: "\xc4\x04\u4cb0", // 䲰
	0x4cb1: "\xc4\x04\u4cb1", // 䲱
	0x4cb2: "\xc4\x04\u4cb2", // 䲲
	0x4cb3: "\xc4\x04\u4cb3", // 䲳
	0x4cb4: "\xc4\x04\u4cb4", // 䲴
	0x4cb5: "\xc4\x04\u4cb5", // 䲵
	0x4cb6: "\xc4\x04\u4cb6", // 䲶
	0x4cb7: "\xc4\x04\u4cb7", // 䲷
	0x4cb8: "\xc4\x04\u4cb8", // 䲸
	0x4cb9: "\xc4\x05\u4cb9", // 䲹
	0x4cba: "\xc4\x05\u4cba", // 䲺
	0x4cbb: "\xc4\x05\u4cbb", // 䲻
	0x4cbc: "\xc4\x05\u4cbc", // 䲼
	0x4cbd: "\xc4\x05\u4cbd", // 䲽
	0x4cbe: "\xc4\x05\u4cbe", // 䲾
	0x4cbf: "\xc4\x05\u4cbf", // 䲿
	0x4cc0: "\xc4\x05\u4cc0", // 䳀
	0x4cc1: "\xc4\x05\u4cc1", // 䳁
	0x4cc2: "\xc4\x05\u4cc2", // 䳂
	0x4cc3: "\xc4\x05\u4cc3", // 䳃
	0x4cc4: "\xc4\x05\u4cc4", // 䳄
	0x4cc5: "\xc4\x05\u4cc5", // 䳅
	0x4cc6: "\xc4\x05\u4cc6", // 䳆
	0x4cc7: "\xc4\x05\u4cc7", // 䳇
	0x4cc8: "\xc4\x05\u4cc8", // 䳈
	0x4cc9: "\xc4\x05\u4cc9", // 䳉
	0x4cca: "\xc4\x05\u4cca", // 䳊
	0x4ccb: "\xc4\x06\u4ccb", // 䳋
	0x4ccc: "\xc4\x06\u4ccc", // 䳌
	0x4ccd: "\xc4\x06\u4ccd", // 䳍
	0x4cce: "\xc4\x06\u4cce", // 䳎
	0x4ccf: "\xc4\x06\u4ccf", // 䳏
	0x4cd0: "\xc4\x06\u4cd0", // 䳐
	0x4cd1: "\xc4\x06\u4cd1", // 䳑
	0x4cd2: "\xc4\x06\u4cd2", // 䳒
	0x4cd3: "\xc4\x06\u4cd3", // 䳓
	0x4cd4: "\xc4\x06\u4cd4", // 䳔
	0x4cd5: "\xc4\a\u4cd5", // 䳕
	0x4cd6: "\xc4\a\u4cd6", // 䳖
	0x4cd7: "\xc4\a\u4cd7", // 䳗
	0x4cd8: "\xc4\a\u4cd8", // 䳘
	0x4cd9: "\xc4\a\u4cd9", // 䳙
	0x4cda: "\xc4\a\u4cda", // 䳚
	0x4cdb: "\xc4\a\u4cdb", // 䳛
	0x4cdc: "\xc4\a\u4cdc", // 䳜
	0x4cdd: "\xc4\b\u4cdd", // 䳝
	0x4cde: "\xc4\b\u4cde", // 䳞
	0x4cdf: "\xc4\b\u4cdf", // 䳟
	0x4ce0: "\xc4\b\u4ce0", // 䳠
	0x4ce1: "\xc4\b\u4ce1", // 䳡
	0x4ce2: "\xc4\b\u4ce2", // 䳢
	0x4ce3: "\xc4\b\u4ce3", // 䳣
	0x4ce4: "\xc4\b\u4ce4", // 䳤
	0x4ce5: "\xc4\b\u4ce5", // 䳥
	0x4ce6: "\xc4\t\u4ce6", // 䳦
	0x4ce7: "\xc4\t\u4ce7", // 䳧
	0x4ce8: "\xc4\t\u4ce8", // 䳨
	0x4ce9: "\xc4\t\u4ce9", // 䳩
	0x4cea: "\xc4\t\u4cea", // 䳪
	0x4ceb: "\xc4\t\u4ceb", // 䳫
	0x4cec: "\xc4\t\u4cec", // 䳬
	0x4ced: "\xc4\t\u4ced", // 䳭
	0x4cee: "\xc4\t\u4cee", // 䳮
	0x4cef: "\xc4\t\u4cef", // 䳯
	0x4cf0: "\xc4\t\u4cf0", // 䳰
	0x4cf1: "\xc4\n\u4cf1", // 䳱
	0x4cf2: "\xc4\n\u4cf2", // 䳲
	0x4cf3: "\xc4\n\u4cf3", // 䳳
	0x4cf4: "\xc4\n\u4cf4", // 䳴
	0x4cf5: "\xc4\n\u4cf5", // 䳵
	0x4cf6: "\xc4\n\u4cf6", // 䳶
	0x4cf7: "\xc4\v\u4cf7", // 䳷
	0x4cf8: "\xc4\v\u4cf8", // 䳸
	0x4cf9: "\xc4\v\u4cf9", // 䳹
	0x4cfa: "\xc4\v\u4cfa", // 䳺
	0x4cfb: "\xc4\v\u4cfb", // 䳻
	0x4cfc: "\xc4\v\u4cfc", // 䳼
	0x4cfd: "\xc4\v\u4cfd", // 䳽
	0x4cfe: "\xc4\f\u4cfe", // 䳾
	0x4cff: "\xc4\f\u4cff", // 䳿
	0x4d00: "\xc4\f\u4d00", // 䴀
	0x4d01: "\xc4\f\u4d01", // 䴁
	0x4d02: "\xc4\f\u4d02", // 䴂
	0x4d03: "\xc4\f\u4d03", // 䴃
	0x4d04: "\xc4\f\u4d04", // 䴄
	0x4d05: "\xc4\f\u4d05", // 䴅
	0x4d06: "\xc4\f\u4d06", // 䴆
	0x4d07: "\xc4\r\u4d07", // 䴇
	0x4d08: "\xc4\r\u4d08", // 䴈
	0x4d09: "\xc4\r\u4d09", // 䴉
	0x4d0a: "\xc4\r\u4d0a", // 䴊
	0x4d0b: "\xc4\r\u4d0b", // 䴋
	0x4d0c: "\xc4\x0e\u4d0c", // 䴌
	0x4d0d: "\xc4\x0e\u4d0d", // 䴍
	0x4d0e: "\xc4\x0f\u4d0e", // 䴎
	0x4d0f: "\xc4\x10\u4d0f", // 䴏
	0x4d10: "\xc4\x14\u4d10", // 䴐
	0x4d11: "\xc4\x17\u4d11", // 䴑
	0x4d12: "\xc4\x18\u4d12", // 䴒
	0x4d13: "\xc4\x04\u4d13", // 䴓
	0x4d14: "\xc4\x06\u4d14", // 䴔
	0x4d15: "\xc4\x06\u4d15", // 䴕
	0x4d16: "\xc4\b\u4d16", // 䴖
	0x4d17: "\xc4\t\u4d17", // 䴗
	0x4d18: "\xc4\n\u4d18", // 䴘
	0x4d19: "\xc4\r\u4d19", // 䴙
	0x4d1a: "\xc5\x04\u4d1a", // 䴚
	0x4d1b: "\xc5\a\u4d1b", // 䴛
	0x4d1c: "\xc5\n\u4d1c", // 䴜
	0x4d1d: "\xc5\f\u4d1d", // 䴝
	0x4d1e: "\xc5\x0e\u4d1e", // 䴞
	0x4d1f: "\xc6\x03\u4d1f", // 䴟
	0x4d20: "\xc6\x04\u4d20", // 䴠
	0x4d21: "\xc6\x04\u4d21", // 䴡
	0x4d22: "\xc6\x04\u4d22", // 䴢
	0x4d23: "\xc6\x05\u4d23", // 䴣
	0x4d24: "\xc6\x05\u4d24", // 䴤
	0x4d25: "\xc6\x05\u4d25", // 䴥
	0x4d26: "\xc6\a\u4d26", // 䴦
	0x4d27: "\xc6\b\u4d27", // 䴧
	0x4d28: "\xc6\n\u4d28", // 䴨
	0x4d29: "\xc6\v\u4d29", // 䴩
	0x4d2a: "\xc6\r\u4d2a", // 䴪
	0x4d2b: "\xc6\r\u4d2b", // 䴫
	0x4d2c: "\xc7\x03\u4d2c", // 䴬
	0x4d2d: "\xc7\x03\u4d2d", // 䴭
	0x4d2e: "\xc7\x03\u4d2e", // 䴮
	0x4d2f: "\xc7\x04\u4d2f", // 䴯
	0x4d30: "\xc7\x04\u4d30", // 䴰
	0x4d31: "\xc7\x05\u4d31", // 䴱
	0x4d32: "\xc7\x05\u4d32", // 䴲
	0x4d33: "\xc7\x05\u4d33", // 䴳
	0x4d34: "\xc7\x05\u4d34", // 䴴
	0x4d35: "\xc7\x06\u4d35", // 䴵
	0x4d36: "\xc7\a\u4d36", // 䴶
	0x4d37: "\xc7\a\u4d37", // 䴷
	0x4d38: "\xc7\a\u4d38", // 䴸
	0x4d39: "\xc7\b\u4d39", // 䴹
	0x4d3a: "\xc7\b\u4d3a", // 䴺
	0x4d3b: "\xc7\b\u4d3b", // 䴻
	0x4d3c: "\xc7\b\u4d3c", // 䴼
	0x4d3d: "\xc7\b\u4d3d", // 䴽
	0x4d3e: "\xc7\n\u4d3e", // 䴾
	0x4d3f: "\xc7\n\u4d3f", // 䴿
	0x4d40: "\xc7\n\u4d40", // 䵀
	0x4d41: "\xc7\v\u4d41", // 䵁
	0x4d42: "\xc7\v\u4d42", // 䵂
	0x4d43: "\xc7\f\u4d43", // 䵃
	0x4d44: "\xc7\r\u4d44", // 䵄
	0x4d45: "\xc7\v\u4d45", // 䵅
	0x4d46: "\xc7\x0e\u4d46", // 䵆
	0x4d47: "\xc8\x04\u4d47", // 䵇
	0x4d48: "\xc8\t\u4d48", // 䵈
	0x4d49: "\xc8\t\u4d49", // 䵉
	0x4d4a: "\xc9\x04\u4d4a", // 䵊
	0x4d4b: "\xc9\x06\u4d4b", // 䵋
	0x4d4c: "\xc9\a\u4d4c", // 䵌
	0x4d4d: "\xc9\b\u4d4d", // 䵍
	0x4d4e: "\xc9\t\u4d4e", // 䵎
	0x4d4f: "\xc9\v\u4d4f", // 䵏
	0x4d50: "\xc9\f\u4d50", // 䵐
	0x4d51: "\xca\x03\u4d51", // 䵑
	0x4d52: "\xca\x04\u4d52", // 䵒
	0x4d53: "\xca\x04\u4d53", // 䵓
	0x4d54: "\xca\b\u4d54", // 䵔
	0x4d55: "\xca\b\u4d55", // 䵕
	0x4d56: "\xca\b\u4d56", // 䵖
	0x4d57: "\xca\t\u4d57", // 䵗
	0x4d58: "\xca\t\u4d58", // 䵘
	0x4d59: "\xca\t\u4d59", // 䵙
	0x4d5a: "\xca\n\u4d5a", // 䵚
	0x4d5b: "\xca\v\u4d5b", // 䵛
	0x4d5c: "\xca\r\u4d5c", // 䵜
	0x4d5d: "\xcb\x01\u4d5d", // 䵝
	0x4d5e: "\xcb\x02\u4d5e", // 䵞
	0x4d5f: "\xcb\x03\u4d5f", // 䵟
	0x4d60: "\xcb\x03\u4d60", // 䵠
	0x4d61: "\xcb\x04\u4d61", // 䵡
	0x4d62: "\xcb\x05\u4d62", // 䵢
	0x4d63: "\xcb\x05\u4d63", // 䵣
	0x4d64: "\xcb\x06\u4d64", // 䵤
	0x4d65: "\xcb\x06\u4d65", // 䵥
	0x4d66: "\xcb\x06\u4d66", // 䵦
	0x4d67: "\xcb\x06\u4d67", // 䵧
	0x4d68: "\xcb\a\u4d68", // 䵨
	0x4d69: "\xcb\a\u4d69", // 䵩
	0x4d6a: "\xcb\b\u4d6a", // 䵪
	0x4d6b: "\xcb\b\u4d6b", // 䵫
	0x4d6c: "\xcb\b\u4d6c", // 䵬
	0x4d6d: "\xcb\t\u4d6d", // 䵭
	0x4d6e: "\xcb\t\u4d6e", // 䵮
	0x4d6f: "\xcb\t\u4d6f", // 䵯
	0x4d70: "\xcb\v\u4d70", // 䵰
	0x4d71: "\xcb\f\u4d71", // 䵱
	0x4d72: "\xcb\r\u4d72", // 䵲
	0x4d73: "\xcb\r\u4d73", // 䵳
	0x4d74: "\xcb\r\u4d74", // 䵴
	0x4d75: "\xcb\x0e\u4d75", // 䵵
	0x4d76: "\xcd\x05\u4d76", // 䵶
	0x4d77: "\xcd\x06\u4d77", // 䵷
	0x4d78: "\xcd\t\u4d78", // 䵸
	0x4d79: "\xcd\v\u4d79", // 䵹
	0x4d7a: "\xce\x03\u4d7a", // 䵺
	0x4d7b: "\xce\v\u4d7b", // 䵻
	0x4d7c: "\xce\v\u4d7c", // 䵼
	0x4d7d: "\xcf\x05\u4d7d", // 䵽
	0x4d7e: "\xcf\x05\u4d7e", // 䵾
	0x4d7f: "\xcf\x05\u4d7f", // 䵿
	0x4d80: "\xcf\x06\u4d80", // 䶀
	0x4d81: "\xcf\b\u4d81", // 䶁
	0x4d82: "\xd0\x03\u4d82", // 䶂
	0x4d83: "\xd0\x04\u4d83", // 䶃
	0x4d84: "\xd0\x05\u4d84", // 䶄
	0x4d85: "\xd0\x06\u4d85", // 䶅
	0x4d86: "\xd0\b\u4d86", // 䶆
	0x4d87: "\xd0\t\u4d87", // 䶇
	0x4d88: "\xd0\n\u4d88", // 䶈
	0x4d89: "\xd0\n\u4d89", // 䶉
	0x4d8a: "\xd1\x04\u4d8a", // 䶊
	0x4d8b: "\xd1\x04\u4d8b", // 䶋
	0x4d8c: "\xd1\x05\u4d8c", // 䶌
	0x4d8d: "\xd1\x06\u4d8d", // 䶍
	0x4d8e: "\xd1\x06\u4d8e", // 䶎
	0x4d8f: "\xd1\a\u4d8f", // 䶏
	0x4d90: "\xd1\r\u4d90", // 䶐
	0x4d91: "\xd1\x10\u4d91", // 䶑
	0x4d92: "\xd2\x03\u4d92", // 䶒
	0x4d93: "\xd2\x03\u4d93", // 䶓
	0x4d94: "\xd3\x03\u4d94", // 䶔
	0x4d95: "\xd3\x04\u4d95", // 䶕
	0x4d96: "\xd3\x04\u4d96", // 䶖
	0x4d97: "\xd3\x05\u4d97", // 䶗
	0x4d98: "\xd3\x05\u4d98", // 䶘
	0x4d99: "\xd3\x05\u4d99", // 䶙
	0x4d9a: "\xd3\x06\u4d9a", // 䶚
	0x4d9b: "\xd3\x06\u4d9b", // 䶛
	0x4d9c: "\xd3\a\u4d9c", // 䶜
	0x4d9d: "\xd3\a\u4d9d", // 䶝
	0x4d9e: "\xd3\b\u4d9e", // 䶞
	0x4d9f: "\xd3\b\u4d9f", // 䶟
	0x4da0: "\xd3\t\u4da0", // 䶠
	0x4da1: "\xd3\t\u4da1", // 䶡
	0x4da2: "\xd3\t\u4da2", // 䶢
	0x4da3: "\xd3\n\u4da3", // 䶣
	0x4da4: "\xd3\n\u4da4", // 䶤
	0x4da5: "\xd3\v\u4da5", // 䶥
	0x4da6: "\xd3\v\u4da6", // 䶦
	0x4da7: "\xd3\f\u4da7", // 䶧
	0x4da8: "\xd3\r\u4da8", // 䶨
	0x4da9: "\xd3\x0e\u4da9", // 䶩
	0x4daa: "\xd3\x0e\u4daa", // 䶪
	0x4dab: "\xd3\x14\u4dab", // 䶫
	0x4dac: "\xd4\x06\u4dac", // 䶬
	0x4dad: "\xd4\x04\u4dad", // 䶭
	0x4dae: "\xd4\x04\u4dae", // 䶮
	0x4daf: "\xd5\x03\u4daf", // 䶯
	0x4db0: "\xd5\x04\u4db0", // 䶰
	0x4db1: "\xd5\x05\u4db1", // 䶱
	0x4db2: "\xd5\x05\u4db2", // 䶲
	0x4db3: "\xd6\x04\u4db3", // 䶳
	0x4db4: "\xd6\b\u4db4", // 䶴
	0x4db5: "\xd6\n\u4db5", // 䶵
	0x4e00: "\x01\x00\u4e00", // 一
	0x4e01: "\x01\x01\u4e01", // 丁
	0x4e02: "\x01\x01\u4e02", // 丂
	0x4e03: "\x01\x01\u4e03", // 七
	0x4e04: "\x01\x01\u4e04", // 丄
	0x4e05: "\x01\x01\u4e05", // 丅
	0x4e06: "\x01\x01\u4e06", // 丆
	0x4e07: "\x01\x02\u4e07", // 万
	0x4e08: "\x01\x02\u4e08", // 丈
	0x4e09: "\x01\x02\u4e09", // 三
	0x4e0a: "\x01\x02\u4e0a", // 上
	0x4e0b: "\x01\x02\u4e0b", // 下
	0x4e0c: "\x01\x02\u4e0c", // 丌
	0x4e0d: "\x01\x03\u4e0d", // 不
	0x4e0e: "\x01\x03\u4e0e", // 与
	0x4e0f: "\x01\x03\u4e0f", // 丏
	0x4e10: "\x01\x03\u4e10", // 丐
	0x4e11: "\x01\x03\u4e11", // 丑
	0x4e12: "\x01\x03\u4e12", // 丒
	0x4e13: "\x01\x03\u4e13", // 专
	0x4e14: "\x01\x04\u4e14", // 且
	0x4e15: "\x01\x04\u4e15", // 丕
	0x4e16: "\x01\x04\u4e16", // 世
	0x4e17: "\x01\x03\u4e17", // 丗
	0x4e18: "\x01\x04\u4e18", // 丘
	0x4e19: "\x01\x04\u4e19", // 丙
	0x4e1a: "\x01\x04\u4e1a", // 业
	0x4e1b: "\x01\x04\u4e1b", // 丛
	0x4e1c: "\x01\x04\u4e1c", // 东
	0x4e1d: "\x01\x04\u4e1d", // 丝
	0x4e1e: "\x01\x05\u4e1e", // 丞
	0x4e1f: "\x01\x05\u4e1f", // 丟
	0x4e20: "\x01\x05\u4e20", // 丠
	0x4e21: "\x01\x05\u4e21", // 両
	0x4e22: "\x01\x05\u4e22", // 丢
	0x4e23: "\x01\x06\u4e23", // 丣
	0x4e24: "\x01\x06\u4e24", // 两
	0x4e25: "\x01\x06\u4e25", // 严
	0x4e26: "\x01\a\u4e26", // 並
	0x4e27: "\x01\a\u4e27", // 丧
	0x4e28: "\x02\x00\u4e28", // 丨
	0x4e29: "\x02\x01\u4e29", // 丩
	0x4e2a: "\x02\x02\u4e2a", // 个
	0x4e2b: "\x02\x02\u4e2b", // 丫
	0x4e2c: "Z\x00\u4e2c", // 丬
	0x4e2d: "\x02\x03\u4e2d", // 中
	0x4e2e: "\x02\x03\u4e2e", // 丮
	0x4e2f: "\x02\x03\u4e2f", // 丯
	0x4e30: "\x02\x03\u4e30", // 丰
	0x4e31: "\x02\x04\u4e31", // 丱
	0x4e32: "\x02\x06\u4e32", // 串
	0x4e33: "\x02\a\u4e33", // 丳
	0x4e34: "\x02\b\u4e34", // 临
	0x4e35: "\x02\t\u4e35", // 丵
	0x4e36: "\x03\x00\u4e36", // 丶
	0x4e37: "\x03\x01\u4e37", // 丷
	0x4e38: "\x03\x02\u4e38", // 丸
	0x4e39: "\x03\x03\u4e39", // 丹
	0x4e3a: "\x03\x03\u4e3a", // 为
	0x4e3b: "\x03\x04\u4e3b", // 主
	0x4e3c: "\x03\x04\u4e3c", // 丼
	0x4e3d: "\x01\x06\u4e3d", // 丽
	0x4e3e: "\x03\b\u4e3e", // 举
	0x4e3f: "\x04\x00\u4e3f", // 丿
	0x4e40: "\x04\x00\u4e40", // 乀
	0x4e41: "\x04\x00\u4e41", // 乁
	0x4e42: "\x04\x01\u4e42", // 乂
	0x4e43: "\x04\x01\u4e43", // 乃
	0x4e44: "\x04\x01\u4e44", // 乄
	0x4e45: "\x04\x02\u4e45", // 久
	0x4e46: "\x04\x02\u4e46", // 乆
	0x4e47: "\x04\x02\u4e47", // 乇
	0x4e48: "\x04\x02\u4e48", // 么
	0x4e49: "\x03\x02\u4e49", // 义
	0x4e4a: "\x04\x02\u4e4a", // 乊
	0x4e4b: "\x04\x03\u4e4b", // 之
	0x4e4c: "\x04\x03\u4e4c", // 乌
	0x4e4d: "\x04\x04\u4e4d", // 乍
	0x4e4e: "\x04\x04\u4e4e", // 乎
	0x4e4f: "\x04\x04\u4e4f", // 乏
	0x4e50: "\x04\x04\u4e50", // 乐
	0x4e51: "\x04\x05\u4e51", // 乑
	0x4e52: "\x04\x05\u4e52", // 乒
	0x4e53: "\x04\x05\u4e53", // 乓
	0x4e54: "\x04\x05\u4e54", // 乔
	0x4e55: "\x04\x06\u4e55", // 乕
	0x4e56: "\x04\a\u4e56", // 乖
	0x4e57: "\x04\b\u4e57", // 乗
	0x4e58: "\x04\t\u4e58", // 乘
	0x4e59: "\x05\x00\u4e59", // 乙
	0x4e5a: "\x05\x00\u4e5a", // 乚
	0x4e5b: "\x05\x00\u4e5b", // 乛
	0x4e5c: "\x05\x01\u4e5c", // 乜
	0x4e5d: "\x05\x01\u4e5d", // 九
	0x4e5e: "\x05\x02\u4e5e", // 乞
	0x4e5f: "\x05\x02\u4e5f", // 也
	0x4e60: "\x05\x02\u4e60", // 习
	0x4e61: "4\x00\u4e61", // 乡
	0x4e62: ".\x01\u4e62", // 乢
	0x4e63: "\x05\x03\u4e63", // 乣
	0x4e64: "\x05\x03\u4e64", // 乤
	0x4e65: "\x05\x03\u4e65", // 乥
	0x4e66: "\x05\x03\u4e66", // 书
	0x4e67: "\x05\x04\u4e67", // 乧
	0x4e68: "\x05\x05\u4e68", // 乨
	0x4e69: "\x05\x05\u4e69", // 乩
	0x4e6a: "\x05\x05\u4e6a", // 乪
	0x4e6b: "\x05\x05\u4e6b", // 乫
	0x4e6c: "\x05\x05\u4e6c", // 乬
	0x4e6d: "\x05\x05\u4e6d", // 乭
	0x4e6e: "\x05\x05\u4e6e", // 乮
	0x4e6f: "\x05\x05\u4e6f", // 乯
	0x4e70: "\x05\x05\u4e70", // 买
	0x4e71: "\x05\x06\u4e71", // 乱
	0x4e72: "\x05\x06\u4e72", // 乲
	0x4e73: "\x05\a\u4e73", // 乳
	0x4e74: "\x05\a\u4e74", // 乴
	0x4e75: "\x05\a\u4e75", // 乵
	0x4e76: "\x05\a\u4e76", // 乶
	0x4e77: "\x05\a\u4e77", // 乷
	0x4e78: "\x05\a\u4e78", // 乸
	0x4e79: "\x05\b\u4e79", // 乹
	0x4e7a: "\x05\b\u4e7a", // 乺
	0x4e7b: "\x05\b\u4e7b", // 乻
	0x4e7c: "\x05\b\u4e7c", // 乼
	0x4e7d: "\x05\t\u4e7d", // 乽
	0x4e7e: "\x05\n\u4e7e", // 乾
	0x4e7f: "\x05\n\u4e7f", // 乿
	0x4e80: "\x05\n\u4e80", // 亀
	0x4e81: "\x05\v\u4e81", // 亁
	0x4e82: "\x05\f\u4e82", // 亂
	0x4e83: "\x05\f\u4e83", // 亃
	0x4e84: "\x05\f\u4e84", // 亄
	0x4e85: "\x06\x00\u4e85", // 亅
	0x4e86: "\x06\x01\u4e86", // 了
	0x4e87: "\x06\x02\u4e87", // 亇
	0x4e88: "\x06\x03\u4e88", // 予
	0x4e89: "\x06\x05\u4e89", // 争
	0x4e8a: "\x06\x06\u4e8a", // 亊
	0x4e8b: "\x06\a\u4e8b", // 事
	0x4e8c: "\a\x00\u4e8c", // 二
	0x4e8d: "\a\x01\u4e8d", // 亍
	0x4e8e: "\a\x01\u4e8e", // 于
	0x4e8f: "\a\x01\u4e8f", // 亏
	0x4e90: "\x01\x02\u4e90", // 亐
	0x4e91: "\a\x02\u4e91", // 云
	0x4e92: "\a\x02\u4e92", // 互
	0x4e93: "\a\x02\u4e93", // 亓
	0x4e94: "\a\x02\u4e94", // 五
	0x4e95: "\a\x02\u4e95", // 井
	0x4e96: "\a\x02\u4e96", // 亖
	0x4e97: "\a\x03\u4e97", // 亗
	0x4e98: "\a\x04\u4e98", // 亘
	0x4e99: "\a\x04\u4e99", // 亙
	0x4e9a: "\a\x04\u4e9a", // 亚
	0x4e9b: "\a\x05\u4e9b", // 些
	0x4e9c: "\a\x05\u4e9c", // 亜
	0x4e9d: "\a\x06\u4e9d", // 亝
	0x4e9e: "\a\x06\u4e9e", // 亞
	0x4e9f: "\a\x06\u4e9f", // 亟
	0x4ea0: "\b\x00\u4ea0", // 亠
	0x4ea1: "\b\x01\u4ea1", // 亡
	0x4ea2: "\b\x02\u4ea2", // 亢
	0x4ea3: "\b\x02\u4ea3", // 亣
	0x4ea4: "\b\x04\u4ea4", // 交
	0x4ea5: "\b\x04\u4ea5", // 亥
	0x4ea6: "\b\x04\u4ea6", // 亦
	0x4ea7: "\b\x04\u4ea7", // 产
	0x4ea8: "\b\x05\u4ea8", // 亨
	0x4ea9: "\b\x05\u4ea9", // 亩
	0x4eaa: "\b\x05\u4eaa", // 亪
	0x4eab: "\b\x06\u4eab", // 享
	0x4eac: "\b\x06\u4eac", // 京
	0x4ead: "\b\a\u4ead", // 亭
	0x4eae: "\b\a\u4eae", // 亮
	0x4eaf: "\b\a\u4eaf", // 亯
	0x4eb0: "\b\a\u4eb0", // 亰
	0x4eb1: "\b\a\u4eb1", // 亱
	0x4eb2: "\b\a\u4eb2", // 亲
	0x4eb3: "\b\b\u4eb3", // 亳
	0x4eb4: "\b\n\u4eb4", // 亴
	0x4eb5: "\b\n\u4eb5", // 亵
	0x4eb6: "\b\v\u4eb6", // 亶
	0x4eb7: "\b\v\u4eb7", // 亷
	0x4eb8: "\b\x0e\u4eb8", // 亸
	0x4eb9: "\b\x13\u4eb9", // 亹
	0x4eba: "\t\x00\u4eba", // 人
	0x4ebb: "\t\x00\u4ebb", // 亻
	0x4ebc: "\t\x01\u4ebc", // 亼
	0x4ebd: "\t\x01\u4ebd", // 亽
	0x4ebe: "\t\x01\u4ebe", // 亾
	0x4ebf: "\t\x01\u4ebf", // 亿
	0x4ec0: "\t\x02\u4ec0", // 什
	0x4ec1: "\t\x02\u4ec1", // 仁
	0x4ec2: "\t\x02\u4ec2", // 仂
	0x4ec3: "\t\x02\u4ec3", // 仃
	0x4ec4: "\t\x02\u4ec4", // 仄
	0x4ec5: "\t\x02\u4ec5", // 仅
	0x4ec6: "\t\x02\u4ec6", // 仆
	0x4ec7: "\t\x02\u4ec7", // 仇
	0x4ec8: "\t\x02\u4ec8", // 仈
	0x4ec9: "\t\x02\u4ec9", // 仉
	0x4eca: "\t\x02\u4eca", // 今
	0x4ecb: "\t\x02\u4ecb", // 介
	0x4ecc: "\t\x02\u4ecc", // 仌
	0x4ecd: "\t\x02\u4ecd", // 仍
	0x4ece: "\t\x02\u4ece", // 从
	0x4ecf: "\t\x02\u4ecf", // 仏
	0x4ed0: "\t\x02\u4ed0", // 仐
	0x4ed1: "\t\x02\u4ed1", // 仑
	0x4ed2: "\t\x02\u4ed2", // 仒
	0x4ed3: "\t\x02\u4ed3", // 仓
	0x4ed4: "\t\x03\u4ed4", // 仔
	0x4ed5: "\t\x03\u4ed5", // 仕
	0x4ed6: "\t\x03\u4ed6", // 他
	0x4ed7: "\t\x03\u4ed7", // 仗
	0x4ed8: "\t\x03\u4ed8", // 付
	0x4ed9: "\t\x03\u4ed9", // 仙
	0x4eda: "\t\x03\u4eda", // 仚
	0x4edb: "\t\x03\u4edb", // 仛
	0x4edc: "\t\x03\u4edc", // 仜
	0x4edd: "\t\x03\u4edd", // 仝
	0x4ede: "\t\x03\u4ede", // 仞
	0x4edf: "\t\x03\u4edf", // 仟
	0x4ee0: "\t\x03\u4ee0", // 仠
	0x4ee1: "\t\x03\u4ee1", // 仡
	0x4ee2: "\t\x03\u4ee2", // 仢
	0x4ee3: "\t\x03\u4ee3", // 代
	0x4ee4: "\t\x03\u4ee4", // 令
	0x4ee5: "\t\x03\u4ee5", // 以
	0x4ee6: "\t\x03\u4ee6", // 仦
	0x4ee7: "\t\x03\u4ee7", // 仧
	0x4ee8: "\t\x03\u4ee8", // 仨
	0x4ee9: "\t\x03\u4ee9", // 仩
	0x4eea: "\t\x03\u4eea", // 仪
	0x4eeb: "\t\x03\u4eeb", // 仫
	0x4eec: "\t\x03\u4eec", // 们
	0x4eed: "\t\x03\u4eed", // 仭
	0x4eee: "\t\x04\u4eee", // 仮
	0x4eef: "\t\x04\u4eef", // 仯
	0x4ef0: "\t\x04\u4ef0", // 仰
	0x4ef1: "\t\x04\u4ef1", // 仱
	0x4ef2: "\t\x04\u4ef2", // 仲
	0x4ef3: "\t\x04\u4ef3", // 仳
	0x4ef4: "\t\x04\u4ef4", // 仴
	0x4ef5: "\t\x04\u4ef5", // 仵
	0x4ef6: "\t\x04\u4ef6", // 件
	0x4ef7: "\t\x04\u4ef7", // 价
	0x4ef8: "\t\x04\u4ef8", // 仸
	0x4ef9: "\t\x04\u4ef9", // 仹
	0x4efa: "\t\x04\u4efa", // 仺
	0x4efb: "\t\x04\u4efb", // 任
	0x4efc: "\t\x04\u4efc", // 仼
	0x4efd: "\t\x04\u4efd", // 份
	0x4efe: "\t\x04\u4efe", // 仾
	0x4eff: "\t\x04\u4eff", // 仿
	0x4f00: "\t\x04\u4f00", // 伀
	0x4f01: "\t\x04\u4f01", // 企
	0x4f02: "\t\x04\u4f02", // 伂
	0x4f03: "\t\x04\u4f03", // 伃
	0x4f04: "\t\x04\u4f04", // 伄
	0x4f05: "\t\x04\u4f05", // 伅
	0x4f06: "\t\x04\u4f06", // 伆
	0x4f07: "\t\x04\u4f07", // 伇
	0x4f08: "\t\x04\u4f08", // 伈
	0x4f09: "\t\x04\u4f09", // 伉
	0x4f0a: "\t\x04\u4f0a", // 伊
	0x4f0b: "\t\x04\u4f0b", // 伋
	0x4f0c: "\t\x04\u4f0c", // 伌
	0x4f0d: "\t\x04\u4f0d", // 伍
	0x4f0e: "\t\x04\u4f0e", // 伎
	0x4f0f: "\t\x04\u4f0f", // 伏
	0x4f10: "\t\x04\u4f10", // 伐
	0x4f11: "\t\x04\u4f11", // 休
	0x4f12: "\t\x04\u4f12", // 伒
	0x4f13: "\t\x04\u4f13", // 伓
	0x4f14: "\t\x04\u4f14", // 伔
	0x4f15: "\t\x04\u4f15", // 伕
	0x4f16: "\t\x04\u4f16", // 伖
	0x4f17: "\t\x04\u4f17", // 众
	0x4f18: "\t\x04\u4f18", // 优
	0x4f19: "\t\x04\u4f19", // 伙
	0x4f1a: "\t\x04\u4f1a", // 会
	0x4f1b: "\t\x04\u4f1b", // 伛
	0x4f1c: "\t\x04\u4f1c", // 伜
	0x4f1d: "\t\x04\u4f1d", // 伝
	0x4f1e: "\t\x04\u4f1e", // 伞
	0x4f1f: "\t\x04\u4f1f", // 伟
	0x4f20: "\t\x04\u4f20", // 传
	0x4f21: "\t\x04\u4f21", // 伡
	0x4f22: "\t\x04\u4f22", // 伢
	0x4f23: "\t\x04\u4f23", // 伣
	0x4f24: "\t\x04\u4f24", // 伤
	0x4f25: "\t\x04\u4f25", // 伥
	0x4f26: "\t\x04\u4f26", // 伦
	0x4f27: "\t\x04\u4f27", // 伧
	0x4f28: "\t\x04\u4f28", // 伨
	0x4f29: "\t\x04\u4f29", // 伩
	0x4f2a: "\t\x04\u4f2a", // 伪
	0x4f2b: "\t\x04\u4f2b", // 伫
	0x4f2c: "\t\x04\u4f2c", // 伬
	0x4f2d: "\t\x05\u4f2d", // 伭
	0x4f2e: "\t\x05\u4f2e", // 伮
	0x4f2f: "\t\x05\u4f2f", // 伯
	0x4f30: "\t\x05\u4f30", // 估
	0x4f31: "\t\x05\u4f31", // 伱
	0x4f32: "\t\x05\u4f32", // 伲
	0x4f33: "\t\x05\u4f33", // 伳
	0x4f34: "\t\x05\u4f34", // 伴
	0x4f35: "\t\x05\u4f35", // 伵
	0x4f36: "\t\x05\u4f36", // 伶
	0x4f37: "\t\x05\u4f37", // 伷
	0x4f38: "\t\x05\u4f38", // 伸
	0x4f39: "\t\x05\u4f39", // 伹
	0x4f3a: "\t\x05\u4f3a", // 伺
	0x4f3b: "\t\x05\u4f3b", // 伻
	0x4f3c: "\t\x05\u4f3c", // 似
	0x4f3d: "\t\x05\u4f3d", // 伽
	0x4f3e: "\t\x05\u4f3e", // 伾
	0x4f3f: "\t\x05\u4f3f", // 伿
	0x4f40: "\t\x05\u4f40", // 佀
	0x4f41: "\t\x05\u4f41", // 佁
	0x4f42: "\t\x05\u4f42", // 佂
	0x4f43: "\t\x05\u4f43", // 佃
	0x4f44: "\t\x05\u4f44", // 佄
	0x4f45: "\t\x05\u4f45", // 佅
	0x4f46: "\t\x05\u4f46", // 但
	0x4f47: "\t\x05\u4f47", // 佇
	0x4f48: "\t\x05\u4f48", // 佈
	0x4f49: "\t\x05\u4f49", // 佉
	0x4f4a: "\t\x05\u4f4a", // 佊
	0x4f4b: "\t\x05\u4f4b", // 佋
	0x4f4c: "\t\x05\u4f4c", // 佌
	0x4f4d: "\t\x05\u4f4d", // 位
	0x4f4e: "\t\x05\u4f4e", // 低
	0x4f4f: "\t\x05\u4f4f", // 住
	0x4f50: "\t\x05\u4f50", // 佐
	0x4f51: "\t\x05\u4f51", // 佑
	0x4f52: "\t\x05\u4f52", // 佒
	0x4f53: "\t\x05\u4f53", // 体
	0x4f54: "\t\x05\u4f54", // 佔
	0x4f55: "\t\x05\u4f55", // 何
	0x4f56: "\t\x05\u4f56", // 佖
	0x4f57: "\t\x05\u4f57", // 佗
	0x4f58: "\t\x05\u4f58", // 佘
	0x4f59: "\t\x05\u4f59", // 余
	0x4f5a: "\t\x05\u4f5a", // 佚
	0x4f5b: "\t\x05\u4f5b", // 佛
	0x4f5c: "\t\x05\u4f5c", // 作
	0x4f5d: "\t\x05\u4f5d", // 佝
	0x4f5e: "\t\x05\u4f5e", // 佞
	0x4f5f: "\t\x05\u4f5f", // 佟
	0x4f60: "\t\x05\u4f60", // 你
	0x4f61: "\t\x05\u4f61", // 佡
	0x4f62: "\t\x05\u4f62", // 佢
	0x4f63: "\t\x05\u4f63", // 佣
	0x4f64: "\t\x04\u4f64", // 佤
	0x4f65: "\t\x05\u4f65", // 佥
	0x4f66: "\t\x05\u4f66", // 佦
	0x4f67: "\t\x05\u4f67", // 佧
	0x4f68: "\t\x05\u4f68", // 佨
	0x4f69: "\t\x06\u4f69", // 佩
	0x4f6a: "\t\x06\u4f6a", // 佪
	0x4f6b: "\t\x06\u4f6b", // 佫
	0x4f6c: "\t\x06\u4f6c", // 佬
	0x4f6d: "\t\x06\u4f6d", // 佭
	0x4f6e: "\t\x06\u4f6e", // 佮
	0x4f6f: "\t\x06\u4f6f", // 佯
	0x4f70: "\t\x06\u4f70", // 佰
	0x4f71: "\t\x06\u4f71", // 佱
	0x4f72: "\t\x06\u4f72", // 佲
	0x4f73: "\t\x06\u4f73", // 佳
	0x4f74: "\t\x06\u4f74", // 佴
	0x4f75: "\t\x06\u4f75", // 併
	0x4f76: "\t\x06\u4f76", // 佶
	0x4f77: "\t\x06\u4f77", // 佷
	0x4f78: "\t\x06\u4f78", // 佸
	0x4f79: "\t\x06\u4f79", // 佹
	0x4f7a: "\t\x06\u4f7a", // 佺
	0x4f7b: "\t\x06\u4f7b", // 佻
	0x4f7c: "\t\x06\u4f7c", // 佼
	0x4f7d: "\t\x06\u4f7d", // 佽
	0x4f7e: "\t\x06\u4f7e", // 佾
	0x4f7f: "\t\x06\u4f7f", // 使
	0x4f80: "\t\x06\u4f80", // 侀
	0x4f81: "\t\x06\u4f81", // 侁
	0x4f82: "\t\x06\u4f82", // 侂
	0x4f83: "\t\x06\u4f83", // 侃
	0x4f84: "\t\x06\u4f84", // 侄
	0x4f85: "\t\x06\u4f85", // 侅
	0x4f86: "\t\x06\u4f86", // 來
	0x4f87: "\t\x06\u4f87", // 侇
	0x4f88: "\t\x06\u4f88", // 侈
	0x4f89: "\t\x06\u4f89", // 侉
	0x4f8a: "\t\x06\u4f8a", // 侊
	0x4f8b: "\t\x06\u4f8b", // 例
	0x4f8c: "\t\x06\u4f8c", // 侌
	0x4f8d: "\t\x06\u4f8d", // 侍
	0x4f8e: "\t\x06\u4f8e", // 侎
	0x4f8f: "\t\x06\u4f8f", // 侏
	0x4f90: "\t\x06\u4f90", // 侐
	0x4f91: "\t\x06\u4f91", // 侑
	0x4f92: "\t\x06\u4f92", // 侒
	0x4f93: "\t\x06\u4f93", // 侓
	0x4f94: "\t\x06\u4f94", // 侔
	0x4f95: "\t\x06\u4f95", // 侕
	0x4f96: "\t\x06\u4f96", // 侖
	0x4f97: "\t\x06\u4f97", // 侗
	0x4f98: "\t\x06\u4f98", // 侘
	0x4f99: "\t\x06\u4f99", // 侙
	0x4f9a: "\t\x06\u4f9a", // 侚
	0x4f9b: "\t\x06\u4f9b", // 供
	0x4f9c: "\t\x06\u4f9c", // 侜
	0x4f9d: "\t\x06\u4f9d", // 依
	0x4f9e: "\t\x06\u4f9e", // 侞
	0x4f9f: "\t\x06\u4f9f", // 侟
	0x4fa0: "\t\x06\u4fa0", // 侠
	0x4fa1: "\t\x06\u4fa1", // 価
	0x4fa2: "\t\x06\u4fa2", // 侢
	0x4fa3: "\t\x06\u4fa3", // 侣
	0x4fa4: "\t\x06\u4fa4", // 侤
	0x4fa5: "\t\x06\u4fa5", // 侥
	0x4fa6: "\t\x06\u4fa6", // 侦
	0x4fa7: "\t\x06\u4fa7", // 侧
	0x4fa8: "\t\x06\u4fa8", // 侨
	0x4fa9: "\t\x06\u4fa9", // 侩
	0x4faa: "\t\x06\u4faa", // 侪
	0x4fab: "\t\x06\u4fab", // 侫
	0x4fac: "\t\x06\u4fac", // 侬
	0x4fad: "\t\x06\u4fad", // 侭
	0x4fae: "\t\a\u4fae", // 侮
	0x4faf: "\t\a\u4faf", // 侯
	0x4fb0: "\t\a\u4fb0", // 侰
	0x4fb1: "\t\a\u4fb1", // 侱
	0x4fb2: "\t\a\u4fb2", // 侲
	0x4fb3: "\t\a\u4fb3", // 侳
	0x4fb4: "\t\a\u4fb4", // 侴
	0x4fb5: "\t\a\u4fb5", // 侵
	0x4fb6: "\t\a\u4fb6", // 侶
	0x4fb7: "\t\a\u4fb7", // 侷
	0x4fb8: "\t\a\u4fb8", // 侸
	0x4fb9: "\t\a\u4fb9", // 侹
	0x4fba: "\t\a\u4fba", // 侺
	0x4fbb: "\t\a\u4fbb", // 侻
	0x4fbc: "\t\a\u4fbc", // 侼
	0x4fbd: "\t\a\u4fbd", // 侽
	0x4fbe: "\t\a\u4fbe", // 侾
	0x4fbf: "\t\a\u4fbf", // 便
	0x4fc0: "\t\a\u4fc0", // 俀
	0x4fc1: "\t\a\u4fc1", // 俁
	0x4fc2: "\t\a\u4fc2", // 係
	0x4fc3: "\t\a\u4fc3", // 促
	0x4fc4: "\t\a\u4fc4", // 俄
	0x4fc5: "\t\a\u4fc5", // 俅
	0x4fc6: "\t\a\u4fc6", // 俆
	0x4fc7: "\t\a\u4fc7", // 俇
	0x4fc8: "\t\a\u4fc8", // 俈
	0x4fc9: "\t\a\u4fc9", // 俉
	0x4fca: "\t\a\u4fca", // 俊
	0x4fcb: "\t\a\u4fcb", // 俋
	0x4fcc: "\t\a\u4fcc", // 俌
	0x4fcd: "\t\a\u4fcd", // 俍
	0x4fce: "\t\a\u4fce", // 俎
	0x4fcf: "\t\a\u4fcf", // 俏
	0x4fd0: "\t\a\u4fd0", // 俐
	0x4fd1: "\t\a\u4fd1", // 俑
	0x4fd2: "\t\a\u4fd2", // 俒
	0x4fd3: "\t\a\u4fd3", // 俓
	0x4fd4: "\t\a\u4fd4", // 俔
	0x4fd5: "\t\a\u4fd5", // 俕
	0x4fd6: "\t\a\u4fd6", // 俖
	0x4fd7: "\t\a\u4fd7", // 俗
	0x4fd8: "\t\a\u4fd8", // 俘
	0x4fd9: "\t\a\u4fd9", // 俙
	0x4fda: "\t\a\u4fda", // 俚
	0x4fdb: "\t\a\u4fdb", // 俛
	0x4fdc: "\t\a\u4fdc", // 俜
	0x4fdd: "\t\a\u4fdd", // 保
	0x4fde: "\t\a\u4fde", // 俞
	0x4fdf: "\t\a\u4fdf", // 俟
	0x4fe0: "\t\a\u4fe0", // 俠
	0x4fe1: "\t\a\u4fe1", // 信
	0x4fe2: "\t\a\u4fe2", // 俢
	0x4fe3: "\t\a\u4fe3", // 俣
	0x4fe4: "\t\a\u4fe4", // 俤
	0x4fe5: "\t\a\u4fe5", // 俥
	0x4fe6: "\t\a\u4fe6", // 俦
	0x4fe7: "\t\a\u4fe7", // 俧
	0x4fe8: "\t\a\u4fe8", // 俨
	0x4fe9: "\t\a\u4fe9", // 俩
	0x4fea: "\t\a\u4fea", // 俪
	0x4feb: "\t\a\u4feb", // 俫
	0x4fec: "\t\a\u4fec", // 俬
	0x4fed: "\t\a\u4fed", // 俭
	0x4fee: "\t\b\u4fee", // 修
	0x4fef: "\t\b\u4fef", // 俯
	0x4ff0: "\t\b\u4ff0", // 俰
	0x4ff1: "\t\b\u4ff1", // 俱
	0x4ff2: "\t\b\u4ff2", // 俲
	0x4ff3: "\t\b\u4ff3", // 俳
	0x4ff4: "\t\b\u4ff4", // 俴
	0x4ff5: "\t\b\u4ff5", // 俵
	0x4ff6: "\t\b\u4ff6", // 俶
	0x4ff7: "\t\b\u4ff7", // 俷
	0x4ff8: "\t\b\u4ff8", // 俸
	0x4ff9: "\t\b\u4ff9", // 俹
	0x4ffa: "\t\b\u4ffa", // 俺
	0x4ffb: "\t\b\u4ffb", // 俻
	0x4ffc: "\t\b\u4ffc", // 俼
	0x4ffd: "\t\b\u4ffd", // 俽
	0x4ffe: "\t\b\u4ffe", // 俾
	0x4fff: "\t\b\u4fff", // 俿
	0x5000: "\t\b\u5000", // 倀
	0x5001: "\t\b\u5001", // 倁
	0x5002: "\t\b\u5002", // 倂
	0x5003: "\t\b\u5003", // 倃
	0x5004: "\t\b\u5004", // 倄
	0x5005: "\t\b\u5005", // 倅
	0x5006: "\t\b\u5006", // 倆
	0x5007: "\t\b\u5007", // 倇
	0x5008: "\t\b\u5008", // 倈
	0x5009: "\t\b\u5009", // 倉
	0x500a: "\t\b\u500a", // 倊
	0x500b: "\t\b\u500b", // 個
	0x500c: "\t\b\u500c", // 倌
	0x500d: "\t\b\u500d", // 倍
	0x500e: "\t\b\u500e", // 倎
	0x500f: "\t\b\u500f", // 倏
	0x5010: "\t\b\u5010", // 倐
	0x5011: "\t\b\u5011", // 們
	0x5012: "\t\b\u5012", // 倒
	0x5013: "\t\b\u5013", // 倓
	0x5014: "\t\b\u5014", // 倔
	0x5015: "\t\b\u5015", // 倕
	0x5016: "\t\b\u5016", // 倖
	0x5017: "\t\b\u5017", // 倗
	0x5018: "\t\b\u5018", // 倘
	0x5019: "\t\b\u5019", // 候
	0x501a: "\t\b\u501a", // 倚
	0x501b: "\t\b\u501b", // 倛
	0x501c: "\t\b\u501c", // 倜
	0x501d: "\t\b\u501d", // 倝
	0x501e: "\t\b\u501e", // 倞
	0x501f: "\t\b\u501f", // 借
	0x5020: "\t\b\u5020", // 倠
	0x5021: "\t\b\u5021", // 倡
	0x5022: "\t\b\u5022", // 倢
	0x5023: "\t\b\u5023", // 倣
	0x5024: "\t\b\u5024", // 値
	0x5025: "\t\b\u5025", // 倥
	0x5026: "\t\b\u5026", // 倦
	0x5027: "\t\b\u5027", // 倧
	0x5028: "\t\b\u5028", // 倨
	0x5029: "\t\b\u5029", // 倩
	0x502a: "\t\b\u502a", // 倪
	0x502b: "\t\b\u502b", // 倫
	0x502c: "\t\b\u502c", // 倬
	0x502d: "\t\b\u502d", // 倭
	0x502e: "\t\b\u502e", // 倮
	0x502f: "\t\b\u502f", // 倯
	0x5030: "\t\b\u5030", // 倰
	0x5031: "\t\b\u5031", // 倱
	0x5032: "\t\b\u5032", // 倲
	0x5033: "\t\b\u5033", // 倳
	0x5034: "\t\b\u5034", // 倴
	0x5035: "\t\b\u5035", // 倵
	0x5036: "\t\b\u5036", // 倶
	0x5037: "\t\b\u5037", // 倷
	0x5038: "\t\b\u5038", // 倸
	0x5039: "\t\b\u5039", // 倹
	0x503a: "\t\b\u503a", // 债
	0x503b: "\t\b\u503b", // 倻
	0x503c: "\t\b\u503c", // 值
	0x503d: "\t\b\u503d", // 倽
	0x503e: "\t\b\u503e", // 倾
	0x503f: "\t\b\u503f", // 倿
	0x5040: "\t\t\u5040", // 偀
	0x5041: "\t\t\u5041", // 偁
	0x5042: "\t\t\u5042", // 偂
	0x5043: "\t\t\u5043", // 偃
	0x5044: "\t\t\u5044", // 偄
	0x5045: "\t\t\u5045", // 偅
	0x5046: "\t\t\u5046", // 偆
	0x5047: "\t\t\u5047", // 假
	0x5048: "\t\t\u5048", // 偈
	0x5049: "\t\t\u5049", // 偉
	0x504a: "\t\t\u504a", // 偊
	0x504b: "\t\t\u504b", // 偋
	0x504c: "\t\t\u504c", // 偌
	0x504d: "\t\t\u504d", // 偍
	0x504e: "\t\t\u504e", // 偎
	0x504f: "\t\t\u504f", // 偏
	0x5050: "\t\t\u5050", // 偐
	0x5051: "\t\t\u5051", // 偑
	0x5052: "\t\t\u5052", // 偒
	0x5053: "\t\t\u5053", // 偓
	0x5054: "\t\t\u5054", // 偔
	0x5055: "\t\t\u5055", // 偕
	0x5056: "\t\t\u5056", // 偖
	0x5057: "\t\t\u5057", // 偗
	0x5058: "\t\t\u5058", // 偘
	0x5059: "\t\t\u5059", // 偙
	0x505a: "\t\t\u505a", // 做
	0x505b: "\t\t\u505b", // 偛
	0x505c: "\t\t\u505c", // 停
	0x505d: "\t\t\u505d", // 偝
	0x505e: "\t\t\u505e", // 偞
	0x505f: "\t\t\u505f", // 偟
	0x5060: "\t\t\u5060", // 偠
	0x5061: "\t\t\u5061", // 偡
	0x5062: "\t\t\u5062", // 偢
	0x5063: "\t\t\u5063", // 偣
	0x5064: "\t\t\u5064", // 偤
	0x5065: "\t\t\u5065", // 健
	0x5066: "\t\t\u5066", // 偦
	0x5067: "\t\t\u5067", // 偧
	0x5068: "\t\t\u5068", // 偨
	0x5069: "\t\t\u5069", // 偩
	0x506a: "\t\t\u506a", // 偪
	0x506b: "\t\t\u506b", // 偫
	0x506c: "\t\t\u506c", // 偬
	0x506d: "\t\t\u506d", // 偭
	0x506e: "\t\t\u506e", // 偮
	0x506f: "\t\t\u506f", // 偯
	0x5070: "\t\t\u5070", // 偰
	0x5071: "\t\t\u5071", // 偱
	0x5072: "\t\t\u5072", // 偲
	0x5073: "\t\t\u5073", // 偳
	0x5074: "\t\t\u5074", // 側
	0x5075: "\t\t\u5075", // 偵
	0x5076: "\t\t\u5076", // 偶
	0x5077: "\t\t\u5077", // 偷
	0x5078: "\t\t\u5078", // 偸
	0x5079: "\t\t\u5079", // 偹
	0x507a: "\t\t\u507a", // 偺
	0x507b: "\t\t\u507b", // 偻
	0x507c: "\t\t\u507c", // 偼
	0x507d: "\t\t\u507d", // 偽
	0x507e: "\t\t\u507e", // 偾
	0x507f: "\t\t\u507f", // 偿
	0x5080: "\t\n\u5080", // 傀
	0x5081: "\t\n\u5081", // 傁
	0x5082: "\t\n\u5082", // 傂
	0x5083: "\t\n\u5083", // 傃
	0x5084: "\t\n\u5084", // 傄
	0x5085: "\t\n\u5085", // 傅
	0x5086: "\t\n\u5086", // 傆
	0x5087: "\t\n\u5087", // 傇
	0x5088: "\t\n\u5088", // 傈
	0x5089: "\t\n\u5089", // 傉
	0x508a: "\t\n\u508a", // 傊
	0x508b: "\t\n\u508b", // 傋
	0x508c: "\t\n\u508c", // 傌
	0x508d: "\t\n\u508d", // 傍
	0x508e: "\t\n\u508e", // 傎
	0x508f: "\t\n\u508f", // 傏
	0x5090: "\t\n\u5090", // 傐
	0x5091: "\t\n\u5091", // 傑
	0x5092: "\t\n\u5092", // 傒
	0x5093: "\t\n\u5093", // 傓
	0x5094: "\t\n\u5094", // 傔
	0x5095: "\t\n\u5095", // 傕
	0x5096: "\t\n\u5096", // 傖
	0x5097: "\t\n\u5097", // 傗
	0x5098: "\t\n\u5098", // 傘
	0x5099: "\t\n\u5099", // 備
	0x509a: "\t\n\u509a", // 傚
	0x509b: "\t\n\u509b", // 傛
	0x509c: "\t\n\u509c", // 傜
	0x509d: "\t\n\u509d", // 傝
	0x509e: "\t\n\u509e", // 傞
	0x509f: "\t\n\u509f", // 傟
	0x50a0: "\t\n\u50a0", // 傠
	0x50a1: "\t\n\u50a1", // 傡
	0x50a2: "\t\n\u50a2", // 傢
	0x50a3: "\t\n\u50a3", // 傣
	0x50a4: "\t\n\u50a4", // 傤
	0x50a5: "\t\n\u50a5", // 傥
	0x50a6: "\t\n\u50a6", // 傦
	0x50a7: "\t\n\u50a7", // 傧
	0x50a8: "\t\n\u50a8", // 储
	0x50a9: "\t\n\u50a9", // 傩
	0x50aa: "\t\v\u50aa", // 傪
	0x50ab: "\t\v\u50ab", // 傫
	0x50ac: "\t\v\u50ac", // 催
	0x50ad: "\t\v\u50ad", // 傭
	0x50ae: "\t\v\u50ae", // 傮
	0x50af: "\t\v\u50af", // 傯
	0x50b0: "\t\v\u50b0", // 傰
	0x50b1: "\t\v\u50b1", // 傱
	0x50b2: "\t\v\u50b2", // 傲
	0x50b3: "\t\v\u50b3", // 傳
	0x50b4: "\t\v\u50b4", // 傴
	0x50b5: "\t\v\u50b5", // 債
	0x50b6: "\t\v\u50b6", // 傶
	0x50b7: "\t\v\u50b7", // 傷
	0x50b8: "\t\v\u50b8", // 傸
	0x50b9: "\t\v\u50b9", // 傹
	0x50ba: "\t\v\u50ba", // 傺
	0x50bb: "\t\v\u50bb", // 傻
	0x50bc: "\t\v\u50bc", // 傼
	0x50bd: "\t\v\u50bd", // 傽
	0x50be: "\t\v\u50be", // 傾
	0x50bf: "\t\v\u50bf", // 傿
	0x50c0: "\t\v\u50c0", // 僀
	0x50c1: "\t\v\u50c1", // 僁
	0x50c2: "\t\v\u50c2", // 僂
	0x50c3: "\t\v\u50c3", // 僃
	0x50c4: "\t\v\u50c4", // 僄
	0x50c5: "\t\v\u50c5", // 僅
	0x50c6: "\t\v\u50c6", // 僆
	0x50c7: "\t\v\u50c7", // 僇
	0x50c8: "\t\v\u50c8", // 僈
	0x50c9: "\t\v\u50c9", // 僉
	0x50ca: "\t\v\u50ca", // 僊
	0x50cb: "\t\v\u50cb", // 僋
	0x50cc: "\t\v\u50cc", // 僌
	0x50cd: "\t\v\u50cd", // 働
	0x50ce: "\t\f\u50ce", // 僎
	0x50cf: "\t\f\u50cf", // 像
	0x50d0: "\t\f\u50d0", // 僐
	0x50d1: "\t\f\u50d1", // 僑
	0x50d2: "\t\f\u50d2", // 僒
	0x50d3: "\t\f\u50d3", // 僓
	0x50d4: "\t\f\u50d4", // 僔
	0x50d5: "\t\f\u50d5", // 僕
	0x50d6: "\t\f\u50d6", // 僖
	0x50d7: "\t\f\u50d7", // 僗
	0x50d8: "\t\f\u50d8", // 僘
	0x50d9: "\t\f\u50d9", // 僙
	0x50da: "\t\f\u50da", // 僚
	0x50db: "\t\f\u50db", // 僛
	0x50dc: "\t\f\u50dc", // 僜
	0x50dd: "\t\f\u50dd", // 僝
	0x50de: "\t\f\u50de", // 僞
	0x50df: "\t\f\u50df", // 僟
	0x50e0: "\t\f\u50e0", // 僠
	0x50e1: "\t\f\u50e1", // 僡
	0x50e2: "\t\f\u50e2", // 僢
	0x50e3: "\t\f\u50e3", // 僣
	0x50e4: "\t\f\u50e4", // 僤
	0x50e5: "\t\f\u50e5", // 僥
	0x50e6: "\t\f\u50e6", // 僦
	0x50e7: "\t\f\u50e7", // 僧
	0x50e8: "\t\f\u50e8", // 僨
	0x50e9: "\t\f\u50e9", // 僩
	0x50ea: "\t\f\u50ea", // 僪
	0x50eb: "\t\f\u50eb", // 僫
	0x50ec: "\t\f\u50ec", // 僬
	0x50ed: "\t\f\u50ed", // 僭
	0x50ee: "\t\f\u50ee", // 僮
	0x50ef: "\t\f\u50ef", // 僯
	0x50f0: "\t\f\u50f0", // 僰
	0x50f1: "\t\f\u50f1", // 僱
	0x50f2: "\t\r\u50f2", // 僲
	0x50f3: "\t\f\u50f3", // 僳
	0x50f4: "\t\f\u50f4", // 僴
	0x50f5: "\t\r\u50f5", // 僵
	0x50f6: "\t\r\u50f6", // 僶
	0x50f7: "\t\f\u50f7", // 僷
	0x50f8: "\t\r\u50f8", // 僸
	0x50f9: "\t\r\u50f9", // 價
	0x50fa: "\t\r\u50fa", // 僺
	0x50fb: "\t\r\u50fb", // 僻
	0x50fc: "\t\r\u50fc", // 僼
	0x50fd: "\t\r\u50fd", // 僽
	0x50fe: "\t\r\u50fe", // 僾
	0x50ff: "\t\r\u50ff", // 僿
	0x5100: "\t\r\u5100", // 儀
	0x5101: "\t\r\u5101", // 儁
	0x5102: "\t\r\u5102", // 儂
	0x5103: "\t\r\u5103", // 儃
	0x5104: "\t\r\u5104", // 億
	0x5105: "\t\r\u5105", // 儅
	0x5106: "\t\r\u5106", // 儆
	0x5107: "\t\r\u5107", // 儇
	0x5108: "\t\r\u5108", // 儈
	0x5109: "\t\r\u5109", // 儉
	0x510a: "\t\r\u510a", // 儊
	0x510b: "\t\r\u510b", // 儋
	0x510c: "\t\r\u510c", // 儌
	0x510d: "\t\r\u510d", // 儍
	0x510e: "\t\r\u510e", // 儎
	0x510f: "\t\r\u510f", // 儏
	0x5110: "\t\x0e\u5110", // 儐
	0x5111: "\t\x0e\u5111", // 儑
	0x5112: "\t\x0e\u5112", // 儒
	0x5113: "\t\x0e\u5113", // 儓
	0x5114: "\t\x0e\u5114", // 儔
	0x5115: "\t\x0e\u5115", // 儕
	0x5116: "\t\x0e\u5116", // 儖
	0x5117: "\t\x0e\u5117", // 儗
	0x5118: "\t\x0e\u5118", // 儘
	0x5119: "\t\x0e\u5119", // 儙
	0x511a: "\t\x0e\u511a", // 儚
	0x511b: "\t\x0e\u511b", // 儛
	0x511c: "\t\x0e\u511c", // 儜
	0x511d: "\t\x0e\u511d", // 儝
	0x511e: "\t\x0e\u511e", // 儞
	0x511f: "\t\x0f\u511f", // 償
	0x5120: "\t\x0f\u5120", // 儠
	0x5121: "\t\x0f\u5121", // 儡
	0x5122: "\t\x0f\u5122", // 儢
	0x5123: "\t\x0f\u5123", // 儣
	0x5124: "\t\x0f\u5124", // 儤
	0x5125: "\t\x0f\u5125", // 儥
	0x5126: "\t\x0f\u5126", // 儦
	0x5127: "\t\x0f\u5127", // 儧
	0x5128: "\t\x0f\u5128", // 儨
	0x5129: "\t\x0f\u5129", // 儩
	0x512a: "\t\x0f\u512a", // 優
	0x512b: "\t\x0e\u512b", // 儫
	0x512c: "\t\x0f\u512c", // 儬
	0x512d: "\t\x10\u512d", // 儭
	0x512e: "\t\x10\u512e", // 儮
	0x512f: "\t\x10\u512f", // 儯
	0x5130: "\t\x10\u5130", // 儰
	0x5131: "\t\x10\u5131", // 儱
	0x5132: "\t\x10\u5132", // 儲
	0x5133: "\t\x11\u5133", // 儳
	0x5134: "\t\x11\u5134", // 儴
	0x5135: "\t\x11\u5135", // 儵
	0x5136: "\t\x12\u5136", // 儶
	0x5137: "\t\x13\u5137", // 儷
	0x5138: "\t\x13\u5138", // 儸
	0x5139: "\t\x13\u5139", // 儹
	0x513a: "\t\x13\u513a", // 儺
	0x513b: "\t\x14\u513b", // 儻
	0x513c: "\t\x14\u513c", // 儼
	0x513d: "\t\x15\u513d", // 儽
	0x513e: "\t\x16\u513e", // 儾
	0x513f: "\n\x00\u513f", // 儿
	0x5140: "\n\x01\u5140", // 兀
	0x5141: "\n\x02\u5141", // 允
	0x5142: "\n\x02\u5142", // 兂
	0x5143: "\n\x02\u5143", // 元
	0x5144: "\n\x03\u5144", // 兄
	0x5145: "\n\x04\u5145", // 充
	0x5146: "\n\x04\u5146", // 兆
	0x5147: "\n\x04\u5147", // 兇
	0x5148: "\n\x04\u5148", // 先
	0x5149: "\n\x04\u5149", // 光
	0x514a: "\n\x04\u514a", // 兊
	0x514b: "\n\x05\u514b", // 克
	0x514c: "\n\x05\u514c", // 兌
	0x514d: "\n\x05\u514d", // 免
	0x514e: "\n\x05\u514e", // 兎
	0x514f: "\n\x05\u514f", // 兏
	0x5150: "\n\x05\u5150", // 児
	0x5151: "\n\x05\u5151", // 兑
	0x5152: "\n\x06\u5152", // 兒
	0x5153: "\n\x06\u5153", // 兓
	0x5154: "\n\x06\u5154", // 兔
	0x5155: "\n\x06\u5155", // 兕
	0x5156: "\n\x06\u5156", // 兖
	0x5157: "\n\a\u5157", // 兗
	0x5158: "\n\a\u5158", // 兘
	0x5159: "\n\a\u5159", // 兙
	0x515a: "\n\b\u515a", // 党
	0x515b: "\n\b\u515b", // 兛
	0x515c: "\n\t\u515c", // 兜
	0x515d: "\n\t\u515d", // 兝
	0x515e: "\n\t\u515e", // 兞
	0x515f: "\n\n\u515f", // 兟
	0x5160: "\n\n\u5160", // 兠
	0x5161: "\n\v\u5161", // 兡
	0x5162: "\n\f\u5162", // 兢
	0x5163: "\n\x0e\u5163", // 兣
	0x5164: "\n\x13\u5164", // 兤
	0x5165: "\v\x00\u5165", // 入
	0x5166: "\v\x01\u5166", // 兦
	0x5167: "\v\x02\u5167", // 內
	0x5168: "\v\x04\u5168", // 全
	0x5169: "\v\x06\u5169", // 兩
	0x516a: "\v\a\u516a", // 兪
	0x516b: "\f\x00\u516b", // 八
	0x516c: "\f\x02\u516c", // 公
	0x516d: "\f\x02\u516d", // 六
	0x516e: "\f\x02\u516e", // 兮
	0x516f: "\f\x02\u516f", // 兯
	0x5170: "\f\x03\u5170", // 兰
	0x5171: "\f\x04\u5171", // 共
	0x5172: "\f\x04\u5172", // 兲
	0x5173: "\f\x04\u5173", // 关
	0x5174: "\f\x04\u5174", // 兴
	0x5175: "\f\x05\u5175", // 兵
	0x5176: "\f\x06\u5176", // 其
	0x5177: "\f\x06\u5177", // 具
	0x5178: "\f\x06\u5178", // 典
	0x5179: "\f\a\u5179", // 兹
	0x517a: "\f\b\u517a", // 兺
	0x517b: "\f\a\u517b", // 养
	0x517c: "\f\b\u517c", // 兼
	0x517d: "\f\t\u517d", // 兽
	0x517e: "\f\v\u517e", // 兾
	0x517f: "\f\v\u517f", // 兿
	0x5180: "\f\x0e\u5180", // 冀
	0x5181: "\f\x10\u5181", // 冁
	0x5182: "\r\x00\u5182", // 冂
	0x5183: "\r\x02\u5183", // 冃
	0x5184: "\r\x02\u5184", // 冄
	0x5185: "\r\x02\u5185", // 内
	0x5186: "\r\x02\u5186", // 円
	0x5187: "\r\x02\u5187", // 冇
	0x5188: "\r\x02\u5188", // 冈
	0x5189: "\r\x03\u5189", // 冉
	0x518a: "\r\x03\u518a", // 冊
	0x518b: "\r\x03\u518b", // 冋
	0x518c: "\r\x03\u518c", // 册
	0x518d: "\r\x04\u518d", // 再
	0x518e: "\r\x04\u518e", // 冎
	0x518f: "\r\x05\u518f", // 冏
	0x5190: "\r\x06\u5190", // 冐
	0x5191: "\r\a\u5191", // 冑
	0x5192: "\r\a\u5192", // 冒
	0x5193: "\r\b\u5193", // 冓
	0x5194: "\r\b\u5194", // 冔
	0x5195: "\r\t\u5195", // 冕
	0x5196: "\x0e\x00\u5196", // 冖
	0x5197: "\x0e\x02\u5197", // 冗
	0x5198: "\x0e\x02\u5198", // 冘
	0x5199: "\x0e\x03\u5199", // 写
	0x519a: "\x0e\x03\u519a", // 冚
	0x519b: "\x0e\x04\u519b", // 军
	0x519c: "\x0e\x04\u519c", // 农
	0x519d: "\x0e\x05\u519d", // 冝
	0x519e: "\x0e\x06\u519e", // 冞
	0x519f: "\x0e\a\u519f", // 冟
	0x51a0: "\x0e\a\u51a0", // 冠
	0x51a1: "\x0e\b\u51a1", // 冡
	0x51a2: "\x0e\b\u51a2", // 冢
	0x51a3: "\x0e\b\u51a3", // 冣
	0x51a4: "\x0e\b\u51a4", // 冤
	0x51a5: "\x0e\b\u51a5", // 冥
	0x51a6: "\x0e\b\u51a6", // 冦
	0x51a7: "\x0e\b\u51a7", // 冧
	0x51a8: "\x0e\t\u51a8", // 冨
	0x51a9: "\x0e\f\u51a9", // 冩
	0x51aa: "\x0e\x0e\u51aa", // 冪
	0x51ab: "\x0f\x00\u51ab", // 冫
	0x51ac: "\x0f\x03\u51ac", // 冬
	0x51ad: "\x0f\x03\u51ad", // 冭
	0x51ae: "\x0f\x03\u51ae", // 冮
	0x51af: "\x0f\x03\u51af", // 冯
	0x51b0: "\x0f\x04\u51b0", // 冰
	0x51b1: "\x0f\x04\u51b1", // 冱
	0x51b2: "\x0f\x04\u51b2", // 冲
	0x51b3: "\x0f\x04\u51b3", // 决
	0x51b4: "\x0f\x04\u51b4", // 冴
	0x51b5: "\x0f\x05\u51b5", // 况
	0x51b6: "\x0f\x05\u51b6", // 冶
	0x51b7: "\x0f\x05\u51b7", // 冷
	0x51b8: "\x0f\x05\u51b8", // 冸
	0x51b9: "\x0f\x05\u51b9", // 冹
	0x51ba: "\x0f\x05\u51ba", // 冺
	0x51bb: "\x0f\x05\u51bb", // 冻
	0x51bc: "\x0f\x06\u51bc", // 冼
	0x51bd: "\x0f\x06\u51bd", // 冽
	0x51be: "\x0f\x06\u51be", // 冾
	0x51bf: "\x0f\x06\u51bf", // 冿
	0x51c0: "\x0f\x06\u51c0", // 净
	0x51c1: "\x0f\a\u51c1", // 凁
	0x51c2: "\x0f\a\u51c2", // 凂
	0x51c3: "\x0f\a\u51c3", // 凃
	0x51c4: "\x0f\b\u51c4", // 凄
	0x51c5: "\x0f\b\u51c5", // 凅
	0x51c6: "\x0f\b\u51c6", // 准
	0x51c7: "\x0f\b\u51c7", // 凇
	0x51c8: "\x0f\b\u51c8", // 凈
	0x51c9: "\x0f\b\u51c9", // 凉
	0x51ca: "\x0f\b\u51ca", // 凊
	0x51cb: "\x0f\b\u51cb", // 凋
	0x51cc: "\x0f\b\u51cc", // 凌
	0x51cd: "\x0f\b\u51cd", // 凍
	0x51ce: "\x0f\b\u51ce", // 凎
	0x51cf: "\x0f\t\u51cf", // 减
	0x51d0: "\x0f\t\u51d0", // 凐
	0x51d1: "\x0f\t\u51d1", // 凑
	0x51d2: "\x0f\n\u51d2", // 凒
	0x51d3: "\x0f\n\u51d3", // 凓
	0x51d4: "\x0f\n\u51d4", // 凔
	0x51d5: "\x0f\n\u51d5", // 凕
	0x51d6: "\x0f\n\u51d6", // 凖
	0x51d7: "\x0f\v\u51d7", // 凗
	0x51d8: "\x0f\f\u51d8", // 凘
	0x51d9: "\x0f\r\u51d9", // 凙
	0x51da: "\x0f\r\u51da", // 凚
	0x51db: "\x0f\r\u51db", // 凛
	0x51dc: "\x0f\r\u51dc", // 凜
	0x51dd: "\x0f\x0e\u51dd", // 凝
	0x51de: "\x0f\x0e\u51de", // 凞
	0x51df: "\x0f\x0f\u51df", // 凟
	0x51e0: "\x10\x00\u51e0", // 几
	0x51e1: "\x10\x01\u51e1", // 凡
	0x51e2: "\x10\x01\u51e2", // 凢
	0x51e3: "\x10\x01\u51e3", // 凣
	0x51e4: "\x10\x02\u51e4", // 凤
	0x51e5: "\x10\x03\u51e5", // 凥
	0x51e6: "\x10\x03\u51e6", // 処
	0x51e7: "\x10\x03\u51e7", // 凧
	0x51e8: "\x10\x04\u51e8", // 凨
	0x51e9: "\x10\x04\u51e9", // 凩
	0x51ea: "\x10\x04\u51ea", // 凪
	0x51eb: "\x10\x04\u51eb", // 凫
	0x51ec: "\x10\x05\u51ec", // 凬
	0x51ed: "\x10\x06\u51ed", // 凭
	0x51ee: "\x10\x06\u51ee", // 凮
	0x51ef: "\x10\x06\u51ef", // 凯
	0x51f0: "\x10\t\u51f0", // 凰
	0x51f1: "\x10\n\u51f1", // 凱
	0x51f2: "\x10\n\u51f2", // 凲
	0x51f3: "\x10\f\u51f3", // 凳
	0x51f4: "\x10\f\u51f4", // 凴
	0x51f5: "\x11\x00\u51f5", // 凵
	0x51f6: "\x11\x02\u51f6", // 凶
	0x51f7: "\x11\x03\u51f7", // 凷
	0x51f8: "\x11\x03\u51f8", // 凸
	0x51f9: "\x11\x03\u51f9", // 凹
	0x51fa: "\x11\x03\u51fa", // 出
	0x51fb: "\x11\x03\u51fb", // 击
	0x51fc: "\x11\x04\u51fc", // 凼
	0x51fd: "\x11\x06\u51fd", // 函
	0x51fe: "\x11\a\u51fe", // 凾
	0x51ff: "\x11\n\u51ff", // 凿
	0x5200: "\x12\x00\u5200", // 刀
	0x5201: "\x12\x00\u5201", // 刁
	0x5202: "\x12\x00\u5202", // 刂
	0x5203: "\x12\x01\u5203", // 刃
	0x5204: "\x12\x01\u5204", // 刄
	0x5205: "\x12\x02\u5205", // 刅
	0x5206: "\x12\x02\u5206", // 分
	0x5207: "\x12\x02\u5207", // 切
	0x5208: "\x12\x02\u5208", // 刈
	0x5209: "\x12\x03\u5209", // 刉
	0x520a: "\x12\x03\u520a", // 刊
	0x520b: "\x12\x03\u520b", // 刋
	0x520c: "\x12\x03\u520c", // 刌
	0x520d: "\x12\x03\u520d", // 刍
	0x520e: "\x12\x04\u520e", // 刎
	0x520f: "\x12\x04\u520f", // 刏
	0x5210: "\x12\x04\u5210", // 刐
	0x5211: "\x12\x04\u5211", // 刑
	0x5212: "\x12\x04\u5212", // 划
	0x5213: "\x12\x04\u5213", // 刓
	0x5214: "\x12\x04\u5214", // 刔
	0x5215: "\x12\x04\u5215", // 刕
	0x5216: "\x12\x04\u5216", // 刖
	0x5217: "\x12\x04\u5217", // 列
	0x5218: "\x12\x04\u5218", // 刘
	0x5219: "\x12\x04\u5219", // 则
	0x521a: "\x12\x04\u521a", // 刚
	0x521b: "\x12\x04\u521b", // 创
	0x521c: "\x12\x05\u521c", // 刜
	0x521d: "\x12\x05\u521d", // 初
	0x521e: "\x12\x05\u521e", // 刞
	0x521f: "\x12\x05\u521f", // 刟
	0x5220: "\x12\x05\u5220", // 删
	0x5221: "\x12\x05\u5221", // 刡
	0x5222: "\x12\x05\u5222", // 刢
	0x5223: "\x12\x05\u5223", // 刣
	0x5224: "\x12\x05\u5224", // 判
	0x5225: "\x12\x05\u5225", // 別
	0x5226: "\x12\x05\u5226", // 刦
	0x5227: "\x12\x05\u5227", // 刧
	0x5228: "\x12\x05\u5228", // 刨
	0x5229: "\x12\x05\u5229", // 利
	0x522a: "\x12\x05\u522a", // 刪
	0x522b: "\x12\x05\u522b", // 别
	0x522c: "\x12\x05\u522c", // 刬
	0x522d: "\x12\x05\u522d", // 刭
	0x522e: "\x12\x06\u522e", // 刮
	0x522f: "\x12\x06\u522f", // 刯
	0x5230: "\x12\x06\u5230", // 到
	0x5231: "\x12\x06\u5231", // 刱
	0x5232: "\x12\x06\u5232", // 刲
	0x5233: "\x12\x06\u5233", // 刳
	0x5234: "\x12\x06\u5234", // 刴
	0x5235: "\x12\x06\u5235", // 刵
	0x5236: "\x12\x06\u5236", // 制
	0x5237: "\x12\x06\u5237", // 刷
	0x5238: "\x12\x06\u5238", // 券
	0x5239: "\x12\x06\u5239", // 刹
	0x523a: "\x12\x06\u523a", // 刺
	0x523b: "\x12\x06\u523b", // 刻
	0x523c: "\x12\x06\u523c", // 刼
	0x523d: "\x12\x06\u523d", // 刽
	0x523e: "\x12\x06\u523e", // 刾
	0x523f: "\x12\x06\u523f", // 刿
	0x5240: "\x12\x06\u5240", // 剀
	0x5241: "\x12\x06\u5241", // 剁
	0x5242: "\x12\x06\u5242", // 剂
	0x5243: "\x12\a\u5243", // 剃
	0x5244: "\x12\a\u5244", // 剄
	0x5245: "\x12\a\u5245", // 剅
	0x5246: "\x12\a\u5246", // 剆
	0x5247: "\x12\a\u5247", // 則
	0x5248: "\x12\a\u5248", // 剈
	0x5249: "\x12\a\u5249", // 剉
	0x524a: "\x12\a\u524a", // 削
	0x524b: "\x12\a\u524b", // 剋
	0x524c: "\x12\a\u524c", // 剌
	0x524d: "\x12\a\u524d", // 前
	0x524e: "\x12\a\u524e", // 剎
	0x524f: "\x12\a\u524f", // 剏
	0x5250: "\x12\a\u5250", // 剐
	0x5251: "\x12\a\u5251", // 剑
	0x5252: "\x12\b\u5252", // 剒
	0x5253: "\x12\b\u5253", // 剓
	0x5254: "\x12\b\u5254", // 剔
	0x5255: "\x12\b\u5255", // 剕
	0x5256: "\x12\b\u5256", // 剖
	0x5257: "\x12\b\u5257", // 剗
	0x5258: "\x12\b\u5258", // 剘
	0x5259: "\x12\b\u5259", // 剙
	0x525a: "\x12\b\u525a", // 剚
	0x525b: "\x12\b\u525b", // 剛
	0x525c: "\x12\b\u525c", // 剜
	0x525d: "\x12\b\u525d", // 剝
	0x525e: "\x12\b\u525e", // 剞
	0x525f: "\x12\b\u525f", // 剟
	0x5260: "\x12\b\u5260", // 剠
	0x5261: "\x12\b\u5261", // 剡
	0x5262: "\x12\b\u5262", // 剢
	0x5263: "\x12\b\u5263", // 剣
	0x5264: "\x12\b\u5264", // 剤
	0x5265: "\x12\b\u5265", // 剥
	0x5266: "\x12\b\u5266", // 剦
	0x5267: "\x12\b\u5267", // 剧
	0x5268: "\x12\t\u5268", // 剨
	0x5269: "\x12\n\u5269", // 剩
	0x526a: "\x12\t\u526a", // 剪
	0x526b: "\x12\t\u526b", // 剫
	0x526c: "\x12\t\u526c", // 剬
	0x526d: "\x12\t\u526d", // 剭
	0x526e: "\x12\t\u526e", // 剮
	0x526f: "\x12\t\u526f", // 副
	0x5270: "\x12\t\u5270", // 剰
	0x5271: "\x12\t\u5271", // 剱
	0x5272: "\x12\n\u5272", // 割
	0x5273: "\x12\n\u5273", // 剳
	0x5274: "\x12\n\u5274", // 剴
	0x5275: "\x12\n\u5275", // 創
	0x5276: "\x12\t\u5276", // 剶
	0x5277: "\x12\v\u5277", // 剷
	0x5278: "\x12\v\u5278", // 剸
	0x5279: "\x12\v\u5279", // 剹
	0x527a: "\x12\v\u527a", // 剺
	0x527b: "\x12\v\u527b", // 剻
	0x527c: "\x12\v\u527c", // 剼
	0x527d: "\x12\v\u527d", // 剽
	0x527e: "\x12\v\u527e", // 剾
	0x527f: "\x12\v\u527f", // 剿
	0x5280: "\x12\f\u5280", // 劀
	0x5281: "\x12\f\u5281", // 劁
	0x5282: "\x12\f\u5282", // 劂
	0x5283: "\x12\f\u5283", // 劃
	0x5284: "\x12\f\u5284", // 劄
	0x5285: "\x12\r\u5285", // 劅
	0x5286: "\x12\r\u5286", // 劆
	0x5287: "\x12\r\u5287", // 劇
	0x5288: "\x12\r\u5288", // 劈
	0x5289: "\x12\r\u5289", // 劉
	0x528a: "\x12\r\u528a", // 劊
	0x528b: "\x12\r\u528b", // 劋
	0x528c: "\x12\r\u528c", // 劌
	0x528d: "\x12\r\u528d", // 劍
	0x528e: "\x12\r\u528e", // 劎
	0x528f: "\x12\r\u528f", // 劏
	0x5290: "\x12\x0e\u5290", // 劐
	0x5291: "\x12\x0e\u5291", // 劑
	0x5292: "\x12\x0e\u5292", // 劒
	0x5293: "\x12\x0e\u5293", // 劓
	0x5294: "\x12\x0e\u5294", // 劔
	0x5295: "\x12\x0f\u5295", // 劕
	0x5296: "\x12\x11\u5296", // 劖
	0x5297: "\x12\x13\u5297", // 劗
	0x5298: "\x12\x13\u5298", // 劘
	0x5299: "\x12\x15\u5299", // 劙
	0x529a: "\x12\x15\u529a", // 劚
	0x529b: "\x13\x00\u529b", // 力
	0x529c: "\x13\x01\u529c", // 劜
	0x529d: "\x13\x02\u529d", // 劝
	0x529e: "\x13\x02\u529e", // 办
	0x529f: "\x13\x03\u529f", // 功
	0x52a0: "\x13\x03\u52a0", // 加
	0x52a1: "\x13\x03\u52a1", // 务
	0x52a2: "\x13\x03\u52a2", // 劢
	0x52a3: "\x13\x04\u52a3", // 劣
	0x52a4: "\x13\x04\u52a4", // 劤
	0x52a5: "\x13\x04\u52a5", // 劥
	0x52a6: "\x13\x04\u52a6", // 劦
	0x52a7: "\x13\x04\u52a7", // 劧
	0x52a8: "\x13\x04\u52a8", // 动
	0x52a9: "\x13\x05\u52a9", // 助
	0x52aa: "\x13\x05\u52aa", // 努
	0x52ab: "\x13\x05\u52ab", // 劫
	0x52ac: "\x13\x05\u52ac", // 劬
	0x52ad: "\x13\x05\u52ad", // 劭
	0x52ae: "\x13\x05\u52ae", // 劮
	0x52af: "\x13\x05\u52af", // 劯
	0x52b0: "\x13\x05\u52b0", // 劰
	0x52b1: "\x13\x05\u52b1", // 励
	0x52b2: "\x13\x05\u52b2", // 劲
	0x52b3: "\x13\x05\u52b3", // 劳
	0x52b4: "\x13\x05\u52b4", // 労
	0x52b5: "\x13\x06\u52b5", // 劵
	0x52b6: "\x13\x06\u52b6", // 劶
	0x52b7: "\x13\x06\u52b7", // 劷
	0x52b8: "\x13\x06\u52b8", // 劸
	0x52b9: "\x13\x06\u52b9", // 効
	0x52ba: "\x13\x06\u52ba", // 劺
	0x52bb: "\x13\x06\u52bb", // 劻
	0x52bc: "\x13\x06\u52bc", // 劼
	0x52bd: "\x13\x06\u52bd", // 劽
	0x52be: "\x13\x06\u52be", // 劾
	0x52bf: "\x13\x06\u52bf", // 势
	0x52c0: "\x13\a\u52c0", // 勀
	0x52c1: "\x13\a\u52c1", // 勁
	0x52c2: "\x13\a\u52c2", // 勂
	0x52c3: "\x13\a\u52c3", // 勃
	0x52c4: "\x13\a\u52c4", // 勄
	0x52c5: "\x13\a\u52c5", // 勅
	0x52c6: "\x13\a\u52c6", // 勆
	0x52c7: "\x13\a\u52c7", // 勇
	0x52c8: "\x13\a\u52c8", // 勈
	0x52c9: "\x13\a\u52c9", // 勉
	0x52ca: "\x13\a\u52ca", // 勊
	0x52cb: "\x13\a\u52cb", // 勋
	0x52cc: "\x13\b\u52cc", // 勌
	0x52cd: "\x13\b\u52cd", // 勍
	0x52ce: "\x13\b\u52ce", // 勎
	0x52cf: "\x13\b\u52cf", // 勏
	0x52d0: "\x13\b\u52d0", // 勐
	0x52d1: "\x13\b\u52d1", // 勑
	0x52d2: "\x13\t\u52d2", // 勒
	0x52d3: "\x13\t\u52d3", // 勓
	0x52d4: "\x13\t\u52d4", // 勔
	0x52d5: "\x13\t\u52d5", // 動
	0x52d6: "\x13\t\u52d6", // 勖
	0x52d7: "H\a\u52d7", // 勗
	0x52d8: "\x13\t\u52d8", // 勘
	0x52d9: "\x13\t\u52d9", // 務
	0x52da: "\x13\t\u52da", // 勚
	0x52db: "\x13\n\u52db", // 勛
	0x52dc: "\x13\n\u52dc", // 勜
	0x52dd: "\x13\n\u52dd", // 勝
	0x52de: "\x13\n\u52de", // 勞
	0x52df: "\x13\v\u52df", // 募
	0x52e0: "\x13\v\u52e0", // 勠
	0x52e1: "\x13\v\u52e1", // 勡
	0x52e2: "\x13\v\u52e2", // 勢
	0x52e3: "\x13\v\u52e3", // 勣
	0x52e4: "\x13\v\u52e4", // 勤
	0x52e5: "\x13\v\u52e5", // 勥
	0x52e6: "\x13\v\u52e6", // 勦
	0x52e7: "\x13\v\u52e7", // 勧
	0x52e8: "\x13\f\u52e8", // 勨
	0x52e9: "\x13\f\u52e9", // 勩
	0x52ea: "\x13\f\u52ea", // 勪
	0x52eb: "\x13\f\u52eb", // 勫
	0x52ec: "\x13\f\u52ec", // 勬
	0x52ed: "\x13\f\u52ed", // 勭
	0x52ee: "\x13\r\u52ee", // 勮
	0x52ef: "\x13\r\u52ef", // 勯
	0x52f0: "\x13\r\u52f0", // 勰
	0x52f1: "\x13\r\u52f1", // 勱
	0x52f2: "\x13\r\u52f2", // 勲
	0x52f3: "\x13\x0e\u52f3", // 勳
	0x52f4: "\x13\x0f\u52f4", // 勴
	0x52f5: "\x13\x0f\u52f5", // 勵
	0x52f6: "\x13\x0f\u52f6", // 勶
	0x52f7: "\x13\x11\u52f7", // 勷
	0x52f8: "\x13\x12\u52f8", // 勸
	0x52f9: "\x14\x00\u52f9", // 勹
	0x52fa: "\x14\x01\u52fa", // 勺
	0x52fb: "\x14\x02\u52fb", // 勻
	0x52fc: "\x14\x02\u52fc", // 勼
	0x52fd: "\x14\x02\u52fd", // 勽
	0x52fe: "\x14\x02\u52fe", // 勾
	0x52ff: "\x14\x02\u52ff", // 勿
	0x5300: "\x14\x02\u5300", // 匀
	0x5301: "\x14\x02\u5301", // 匁
	0x5302: "\x14\x02\u5302", // 匂
	0x5303: "\x14\x03\u5303", // 匃
	0x5304: "\x14\x03\u5304", // 匄
	0x5305: "\x14\x03\u5305", // 包
	0x5306: "\x14\x03\u5306", // 匆
	0x5307: "\x14\x03\u5307", // 匇
	0x5308: "\x14\x04\u5308", // 匈
	0x5309: "\x14\x05\u5309", // 匉
	0x530a: "\x14\x06\u530a", // 匊
	0x530b: "\x14\x06\u530b", // 匋
	0x530c: "\x14\x06\u530c", // 匌
	0x530d: "\x14\a\u530d", // 匍
	0x530e: "\x14\b\u530e", // 匎
	0x530f: "\x14\t\u530f", // 匏
	0x5310: "\x14\t\u5310", // 匐
	0x5311: "\x14\n\u5311", // 匑
	0x5312: "\x14\n\u5312", // 匒
	0x5313: "\x14\v\u5313", // 匓
	0x5314: "\x14\r\u5314", // 匔
	0x5315: "\x15\x00\u5315", // 匕
	0x5316: "\x15\x02\u5316", // 化
	0x5317: "\x15\x03\u5317", // 北
	0x5318: "\x15\t\u5318", // 匘
	0x5319: "\x15\t\u5319", // 匙
	0x531a: "\x16\x00\u531a", // 匚
	0x531b: "\x16\x03\u531b", // 匛
	0x531c: "\x16\x03\u531c", // 匜
	0x531d: "\x16\x03\u531d", // 匝
	0x531e: "\x16\x03\u531e", // 匞
	0x531f: "\x16\x04\u531f", // 匟
	0x5320: "\x16\x04\u5320", // 匠
	0x5321: "\x16\x04\u5321", // 匡
	0x5322: "\x16\x04\u5322", // 匢
	0x5323: "\x16\x05\u5323", // 匣
	0x5324: "\x16\x05\u5324", // 匤
	0x5325: "\x16\x05\u5325", // 匥
	0x5326: "\x16\x06\u5326", // 匦
	0x5327: "\x16\a\u5327", // 匧
	0x5328: "\x16\a\u5328", // 匨
	0x5329: "\x16\a\u5329", // 匩
	0x532a: "\x16\b\u532a", // 匪
	0x532b: "\x16\b\u532b", // 匫
	0x532c: "\x16\t\u532c", // 匬
	0x532d: "\x16\t\u532d", // 匭
	0x532e: "\x16\t\u532e", // 匮
	0x532f: "\x16\v\u532f", // 匯
	0x5330: "\x16\f\u5330", // 匰
	0x5331: "\x16\f\u5331", // 匱
	0x5332: "\x16\f\u5332", // 匲
	0x5333: "\x16\r\u5333", // 匳
	0x5334: "\x16\x0e\u5334", // 匴
	0x5335: "\x16\x0f\u5335", // 匵
	0x5336: "\x16\x11\u5336", // 匶
	0x5337: "\x16\x12\u5337", // 匷
	0x5338: "\x17\x00\u5338", // 匸
	0x5339: "\x17\x02\u5339", // 匹
	0x533a: "\x17\x02\u533a", // 区
	0x533b: "\x17\x05\u533b", // 医
	0x533c: "\x17\x06\u533c", // 匼
	0x533d: "\x17\a\u533d", // 匽
	0x533e: "\x17\t\u533e", // 匾
	0x533f: "\x17\t\u533f", // 匿
	0x5340: "\x17\t\u5340", // 區
	0x5341: "\x18\x00\u5341", // 十
	0x5342: "\x18\x01\u5342", // 卂
	0x5343: "\x18\x01\u5343", // 千
	0x5344: "\x01\x02\u5344", // 卄
	0x5345: "\x18\x02\u5345", // 卅
	0x5346: "\x18\x02\u5346", // 卆
	0x5347: "\x18\x02\u5347", // 升
	0x5348: "\x18\x02\u5348", // 午
	0x5349: "\x18\x03\u5349", // 卉
	0x534a: "\x18\x03\u534a", // 半
	0x534b: "\x18\x04\u534b", // 卋
	0x534c: "\x18\x03\u534c", // 卌
	0x534d: "\x18\x04\u534d", // 卍
	0x534e: "\x18\x04\u534e", // 华
	0x534f: "\x18\x04\u534f", // 协
	0x5350: "\x18\x04\u5350", // 卐
	0x5351: "\x18\x06\u5351", // 卑
	0x5352: "\x18\x06\u5352", // 卒
	0x5353: "\x18\x06\u5353", // 卓
	0x5354: "\x18\x06\u5354", // 協
	0x5355: "\x18\x06\u5355", // 单
	0x5356: "\x18\x06\u5356", // 卖
	0x5357: "\x18\a\u5357", // 南
	0x5358: "\x18\a\u5358", // 単
	0x5359: "\x18\t\u5359", // 卙
	0x535a: "\x18\n\u535a", // 博
	0x535b: "\x18\x13\u535b", // 卛
	0x535c: "\x19\x00\u535c", // 卜
	0x535d: "\x19\x02\u535d", // 卝
	0x535e: "\x19\x02\u535e", // 卞
	0x535f: "\x19\x03\u535f", // 卟
	0x5360: "\x19\x03\u5360", // 占
	0x5361: "\x19\x03\u5361", // 卡
	0x5362: "\x19\x03\u5362", // 卢
	0x5363: "\x19\x05\u5363", // 卣
	0x5364: "\x19\x00\u5364", // 卤
	0x5365: "\x19\x06\u5365", // 卥
	0x5366: "\x19\x06\u5366", // 卦
	0x5367: "\x19\x06\u5367", // 卧
	0x5368: "\x19\t\u5368", // 卨
	0x5369: "\x1a\x00\u5369", // 卩
	0x536a: "\x1a\x01\u536a", // 卪
	0x536b: "\x1a\x01\u536b", // 卫
	0x536c: "\x1a\x02\u536c", // 卬
	0x536d: "\x1a\x03\u536d", // 卭
	0x536e: "\x1a\x03\u536e", // 卮
	0x536f: "\x1a\x03\u536f", // 卯
	0x5370: "\x1a\x04\u5370", // 印
	0x5371: "\x1a\x04\u5371", // 危
	0x5372: "\x1a\x05\u5372", // 卲
	0x5373: "\x1a\x05\u5373", // 即
	0x5374: "\x1a\x05\u5374", // 却
	0x5375: "\x1a\x05\u5375", // 卵
	0x5376: "\x1a\x06\u5376", // 卶
	0x5377: "\x1a\x06\u5377", // 卷
	0x5378: "\x1a\x06\u5378", // 卸
	0x5379: "\x1a\x06\u5379", // 卹
	0x537a: "\x1a\x06\u537a", // 卺
	0x537b: "\x1a\a\u537b", // 卻
	0x537c: "\x1a\a\u537c", // 卼
	0x537d: "\x1a\a\u537d", // 卽
	0x537e: "\x1a\t\u537e", // 卾
	0x537f: "\x1a\t\u537f", // 卿
	0x5380: "\x1a\v\u5380", // 厀
	0x5381: "\x1a\v\u5381", // 厁
	0x5382: "\x1b\x00\u5382", // 厂
	0x5383: "\x1b\x02\u5383", // 厃
	0x5384: "\x1b\x02\u5384", // 厄
	0x5385: "\x1b\x02\u5385", // 厅
	0x5386: "\x1b\x02\u5386", // 历
	0x5387: "\x1b\x03\u5387", // 厇
	0x5388: "\x1b\x03\u5388", // 厈
	0x5389: "\x1b\x03\u5389", // 厉
	0x538a: "\x1b\x04\u538a", // 厊
	0x538b: "\x1b\x04\u538b", // 压
	0x538c: "\x1b\x04\u538c", // 厌
	0x538d: "\x1b\x04\u538d", // 厍
	0x538e: "\x1b\x05\u538e", // 厎
	0x538f: "\x1b\x05\u538f", // 厏
	0x5390: "\x1b\x05\u5390", // 厐
	0x5391: "\x1b\x05\u5391", // 厑
	0x5392: "\x1b\x06\u5392", // 厒
	0x5393: "\x1b\x06\u5393", // 厓
	0x5394: "\x1b\x06\u5394", // 厔
	0x5395: "\x1b\x06\u5395", // 厕
	0x5396: "\x1b\a\u5396", // 厖
	0x5397: "\x1b\a\u5397", // 厗
	0x5398: "\x1b\a\u5398", // 厘
	0x5399: "\x1b\a\u5399", // 厙
	0x539a: "\x1b\a\u539a", // 厚
	0x539b: "\x1b\a\u539b", // 厛
	0x539c: "\x1b\b\u539c", // 厜
	0x539d: "\x1b\b\u539d", // 厝
	0x539e: "\x1b\b\u539e", // 厞
	0x539f: "\x1b\b\u539f", // 原
	0x53a0: "\x1b\t\u53a0", // 厠
	0x53a1: "\x1b\t\u53a1", // 厡
	0x53a2: "\x1b\t\u53a2", // 厢
	0x53a3: "\x1b\t\u53a3", // 厣
	0x53a4: "\x1b\n\u53a4", // 厤
	0x53a5: "\x1b\n\u53a5", // 厥
	0x53a6: "\x1b\n\u53a6", // 厦
	0x53a7: "\x1b\n\u53a7", // 厧
	0x53a8: "\x1b\n\u53a8", // 厨
	0x53a9: "\x1b\t\u53a9", // 厩
	0x53aa: "\x1b\v\u53aa", // 厪
	0x53ab: "\x1b\v\u53ab", // 厫
	0x53ac: "\x1b\f\u53ac", // 厬
	0x53ad: "\x1b\f\u53ad", // 厭
	0x53ae: "\x1b\f\u53ae", // 厮
	0x53af: "\x1b\f\u53af", // 厯
	0x53b0: "\x1b\f\u53b0", // 厰
	0x53b1: "\x1b\r\u53b1", // 厱
	0x53b2: "\x1b\r\u53b2", // 厲
	0x53b3: "\x1b\x0f\u53b3", // 厳
	0x53b4: "\x1b\x11\u53b4", // 厴
	0x53b5: "\x1b\x1c\u53b5", // 厵
	0x53b6: "\x1c\x00\u53b6", // 厶
	0x53b7: "\x1c\x02\u53b7", // 厷
	0x53b8: "\x1c\x02\u53b8", // 厸
	0x53b9: "\x1c\x02\u53b9", // 厹
	0x53ba: "\x1c\x03\u53ba", // 厺
	0x53bb: "\x1c\x03\u53bb", // 去
	0x53bc: "\x1c\x03\u53bc", // 厼
	0x53bd: "\x1c\x04\u53bd", // 厽
	0x53be: "\x1c\x04\u53be", // 厾
	0x53bf: "\x1c\x05\u53bf", // 县
	0x53c0: "\x1c\x06\u53c0", // 叀
	0x53c1: "\x1c\x06\u53c1", // 叁
	0x53c2: "\x1c\x06\u53c2", // 参
	0x53c3: "\x1c\t\u53c3", // 參
	0x53c4: "\x1c\t\u53c4", // 叄
	0x53c5: "\x1c\n\u53c5", // 叅
	0x53c6: "\x1c\f\u53c6", // 叆
	0x53c7: "\x1c\r\u53c7", // 叇
	0x53c8: "\x1d\x00\u53c8", // 又
	0x53c9: "\x1d\x01\u53c9", // 叉
	0x53ca: "\x1d\x02\u53ca", // 及
	0x53cb: "\x1d\x02\u53cb", // 友
	0x53cc: "\x1d\x02\u53cc", // 双
	0x53cd: "\x1d\x02\u53cd", // 反
	0x53ce: "\x1d\x02\u53ce", // 収
	0x53cf: "\x1d\x03\u53cf", // 叏
	0x53d0: "\x1d\x03\u53d0", // 叐
	0x53d1: "\x1d\x03\u53d1", // 发
	0x53d2: "\x1d\x04\u53d2", // 叒
	0x53d3: "\x1d\x05\u53d3", // 叓
	0x53d4: "\x1d\x06\u53d4", // 叔
	0x53d5: "\x1d\x06\u53d5", // 叕
	0x53d6: "\x1d\x06\u53d6", // 取
	0x53d7: "\x1d\x06\u53d7", // 受
	0x53d8: "\x1d\x06\u53d8", // 变
	0x53d9: "\x1d\a\u53d9", // 叙
	0x53da: "\x1d\a\u53da", // 叚
	0x53db: "\x1d\a\u53db", // 叛
	0x53dc: "\x1d\a\u53dc", // 叜
	0x53dd: "\x1d\a\u53dd", // 叝
	0x53de: "\x1d\b\u53de", // 叞
	0x53df: "\x1d\b\u53df", // 叟
	0x53e0: "\x1d\v\u53e0", // 叠
	0x53e1: "\x1d\x0e\u53e1", // 叡
	0x53e2: "\x1d\x10\u53e2", // 叢
	0x53e3: "\x1e\x00\u53e3", // 口
	0x53e4: "\x1e\x02\u53e4", // 古
	0x53e5: "\x1e\x02\u53e5", // 句
	0x53e6: "\x1e\x02\u53e6", // 另
	0x53e7: "\x1e\x02\u53e7", // 叧
	0x53e8: "\x1e\x02\u53e8", // 叨
	0x53e9: "\x1e\x02\u53e9", // 叩
	0x53ea: "\x1e\x02\u53ea", // 只
	0x53eb: "\x1e\x02\u53eb", // 叫
	0x53ec: "\x1e\x02\u53ec", // 召
	0x53ed: "\x1e\x02\u53ed", // 叭
	0x53ee: "\x1e\x02\u53ee", // 叮
	0x53ef: "\x1e\x02\u53ef", // 可
	0x53f0: "\x1e\x02\u53f0", // 台
	0x53f1: "\x1e\x02\u53f1", // 叱
	0x53f2: "\x1e\x02\u53f2", // 史
	0x53f3: "\x1e\x02\u53f3", // 右
	0x53f4: "\x1e\x02\u53f4", // 叴
	0x53f5: "\x1e\x02\u53f5", // 叵
	0x53f6: "\x1e\x02\u53f6", // 叶
	0x53f7: "\x1e\x02\u53f7", // 号
	0x53f8: "\x1e\x02\u53f8", // 司
	0x53f9: "\x1e\x02\u53f9", // 叹
	0x53fa: "\x1e\x02\u53fa", // 叺
	0x53fb: "\x1e\x02\u53fb", // 叻
	0x53fc: "\x1e\x02\u53fc", // 叼
	0x53fd: "\x1e\x02\u53fd", // 叽
	0x53fe: "\x1e\x02\u53fe", // 叾
	0x53ff: "\x1e\x03\u53ff", // 叿
	0x5400: "\x1e\x03\u5400", // 吀
	0x5401: "\x1e\x03\u5401", // 吁
	0x5402: "\x1e\x03\u5402", // 吂
	0x5403: "\x1e\x03\u5403", // 吃
	0x5404: "\x1e\x03\u5404", // 各
	0x5405: "\x1e\x03\u5405", // 吅
	0x5406: "\x1e\x03\u5406", // 吆
	0x5407: "\x1e\x03\u5407", // 吇
	0x5408: "\x1e\x03\u5408", // 合
	0x5409: "\x1e\x03\u5409", // 吉
	0x540a: "\x1e\x03\u540a", // 吊
	0x540b: "\x1e\x03\u540b", // 吋
	0x540c: "\x1e\x03\u540c", // 同
	0x540d: "\x1e\x03\u540d", // 名
	0x540e: "\x1e\x03\u540e", // 后
	0x540f: "\x1e\x03\u540f", // 吏
	0x5410: "\x1e\x03\u5410", // 吐
	0x5411: "\x1e\x03\u5411", // 向
	0x5412: "\x1e\x03\u5412", // 吒
	0x5413: "\x1e\x03\u5413", // 吓
	0x5414: "\x1e\x03\u5414", // 吔
	0x5415: "\x1e\x03\u5415", // 吕
	0x5416: "\x1e\x03\u5416", // 吖
	0x5417: "\x1e\x03\u5417", // 吗
	0x5418: "\x1e\x04\u5418", // 吘
	0x5419: "\x1e\x04\u5419", // 吙
	0x541a: "\x1e\x04\u541a", // 吚
	0x541b: "\x1e\x04\u541b", // 君
	0x541c: "\x1e\x04\u541c", // 吜
	0x541d: "\x1e\x04\u541d", // 吝
	0x541e: "\x1e\x04\u541e", // 吞
	0x541f: "\x1e\x04\u541f", // 吟
	0x5420: "\x1e\x04\u5420", // 吠
	0x5421: "\x1e\x04\u5421", // 吡
	0x5422: "\x1e\x04\u5422", // 吢
	0x5423: "\x1e\x04\u5423", // 吣
	0x5424: "\x1e\x04\u5424", // 吤
	0x5425: "\x1e\x04\u5425", // 吥
	0x5426: "\x1e\x04\u5426", // 否
	0x5427: "\x1e\x04\u5427", // 吧
	0x5428: "\x1e\x04\u5428", // 吨
	0x5429: "\x1e\x04\u5429", // 吩
	0x542a: "\x1e\x04\u542a", // 吪
	0x542b: "\x1e\x04\u542b", // 含
	0x542c: "\x1e\x04\u542c", // 听
	0x542d: "\x1e\x04\u542d", // 吭
	0x542e: "\x1e\x04\u542e", // 吮
	0x542f: "\x1e\x04\u542f", // 启
	0x5430: "\x1e\x04\u5430", // 吰
	0x5431: "\x1e\x04\u5431", // 吱
	0x5432: "\x1e\x04\u5432", // 吲
	0x5433: "\x1e\x04\u5433", // 吳
	0x5434: "\x1e\x04\u5434", // 吴
	0x5435: "\x1e\x04\u5435", // 吵
	0x5436: "\x1e\x04\u5436", // 吶
	0x5437: "\x1e\x04\u5437", // 吷
	0x5438: "\x1e\x04\u5438", // 吸
	0x5439: "\x1e\x04\u5439", // 吹
	0x543a: "\x1e\x04\u543a", // 吺
	0x543b: "\x1e\x04\u543b", // 吻
	0x543c: "\x1e\x04\u543c", // 吼
	0x543d: "\x1e\x04\u543d", // 吽
	0x543e: "\x1e\x04\u543e", // 吾
	0x543f: "\x1e\x04\u543f", // 吿
	0x5440: "\x1e\x04\u5440", // 呀
	0x5441: "\x1e\x04\u5441", // 呁
	0x5442: "\x1e\x04\u5442", // 呂
	0x5443: "\x1e\x04\u5443", // 呃
	0x5444: "\x1e\x04\u5444", // 呄
	0x5445: "\x1e\x04\u5445", // 呅
	0x5446: "\x1e\x04\u5446", // 呆
	0x5447: "\x1e\x04\u5447", // 呇
	0x5448: "\x1e\x04\u5448", // 呈
	0x5449: "\x1e\x04\u5449", // 呉
	0x544a: "\x1e\x04\u544a", // 告
	0x544b: "\x1e\x04\u544b", // 呋
	0x544c: "\x1e\x04\u544c", // 呌
	0x544d: "\x1e\x04\u544d", // 呍
	0x544e: "\x1e\x04\u544e", // 呎
	0x544f: "\x1e\x04\u544f", // 呏
	0x5450: "\x1e\x04\u5450", // 呐
	0x5451: "\x1e\x04\u5451", // 呑
	0x5452: "\x1e\x04\u5452", // 呒
	0x5453: "\x1e\x04\u5453", // 呓
	0x5454: "\x1e\x04\u5454", // 呔
	0x5455: "\x1e\x04\u5455", // 呕
	0x5456: "\x1e\x04\u5456", // 呖
	0x5457: "\x1e\x04\u5457", // 呗
	0x5458: "\x1e\x04\u5458", // 员
	0x5459: "\x1e\x04\u5459", // 呙
	0x545a: "\x1e\x04\u545a", // 呚
	0x545b: "\x1e\x04\u545b", // 呛
	0x545c: "\x1e\x04\u545c", // 呜
	0x545d: "\x1e\x05\u545d", // 呝
	0x545e: "\x1e\x05\u545e", // 呞
	0x545f: "\x1e\x05\u545f", // 呟
	0x5460: "\x1e\x05\u5460", // 呠
	0x5461: "\x1e\x05\u5461", // 呡
	0x5462: "\x1e\x05\u5462", // 呢
	0x5463: "\x1e\x05\u5463", // 呣
	0x5464: "\x1e\x05\u5464", // 呤
	0x5465: "\x1e\x05\u5465", // 呥
	0x5466: "\x1e\x05\u5466", // 呦
	0x5467: "\x1e\x05\u5467", // 呧
	0x5468: "\x1e\x05\u5468", // 周
	0x5469: "\x1e\x05\u5469", // 呩
	0x546a: "\x1e\x05\u546a", // 呪
	0x546b: "\x1e\x05\u546b", // 呫
	0x546c: "\x1e\x05\u546c", // 呬
	0x546d: "\x1e\x05\u546d", // 呭
	0x546e: "\x1e\x05\u546e", // 呮
	0x546f: "\x1e\x05\u546f", // 呯
	0x5470: "\x1e\x05\u5470", // 呰
	0x5471: "\x1e\x05\u5471", // 呱
	0x5472: "\x1e\x05\u5472", // 呲
	0x5473: "\x1e\x05\u5473", // 味
	0x5474: "\x1e\x05\u5474", // 呴
	0x5475: "\x1e\x05\u5475", // 呵
	0x5476: "\x1e\x05\u5476", // 呶
	0x5477: "\x1e\x05\u5477", // 呷
	0x5478: "\x1e\x05\u5478", // 呸
	0x5479: "\x1e\x05\u5479", // 呹
	0x547a: "\x1e\x05\u547a", // 呺
	0x547b: "\x1e\x05\u547b", // 呻
	0x547c: "\x1e\x05\u547c", // 呼
	0x547d: "\x1e\x05\u547d", // 命
	0x547e: "\x1e\x05\u547e", // 呾
	0x547f: "\x1e\x05\u547f", // 呿
	0x5480: "\x1e\x05\u5480", // 咀
	0x5481: "\x1e\x05\u5481", // 咁
	0x5482: "\x1e\x05\u5482", // 咂
	0x5483: "\x1e\x05\u5483", // 咃
	0x5484: "\x1e\x05\u5484", // 咄
	0x5485: "\x1e\x05\u5485", // 咅
	0x5486: "\x1e\x05\u5486", // 咆
	0x5487: "\x1e\x05\u5487", // 咇
	0x5488: "\x1e\x05\u5488", // 咈
	0x5489: "\x1e\x05\u5489", // 咉
	0x548a: "\x1e\x05\u548a", // 咊
	0x548b: "\x1e\x05\u548b", // 咋
	0x548c: "\x1e\x05\u548c", // 和
	0x548d: "\x1e\x05\u548d", // 咍
	0x548e: "\x1e\x05\u548e", // 咎
	0x548f: "\x1e\x05\u548f", // 咏
	0x5490: "\x1e\x05\u5490", // 咐
	0x5491: "\x1e\x05\u5491", // 咑
	0x5492: "\x1e\x05\u5492", // 咒
	0x5493: "\x1e\x05\u5493", // 咓
	0x5494: "\x1e\x05\u5494", // 咔
	0x5495: "\x1e\x05\u5495", // 咕
	0x5496: "\x1e\x05\u5496", // 咖
	0x5497: "\x1e\x05\u5497", // 咗
	0x5498: "\x1e\x05\u5498", // 咘
	0x5499: "\x1e\x05\u5499", // 咙
	0x549a: "\x1e\x05\u549a", // 咚
	0x549b: "\x1e\x05\u549b", // 咛
	0x549c: "\x1e\x05\u549c", // 咜
	0x549d: "\x1e\x05\u549d", // 咝
	0x549e: "\x1e\x06\u549e", // 咞
	0x549f: "\x1e\x06\u549f", // 咟
	0x54a0: "\x1e\x06\u54a0", // 咠
	0x54a1: "\x1e\x06\u54a1", // 咡
	0x54a2: "\x1e\x06\u54a2", // 咢
	0x54a3: "\x1e\x06\u54a3", // 咣
	0x54a4: "\x1e\x06\u54a4", // 咤
	0x54a5: "\x1e\x06\u54a5", // 咥
	0x54a6: "\x1e\x06\u54a6", // 咦
	0x54a7: "\x1e\x06\u54a7", // 咧
	0x54a8: "\x1e\x06\u54a8", // 咨
	0x54a9: "\x1e\x06\u54a9", // 咩
	0x54aa: "\x1e\x06\u54aa", // 咪
	0x54ab: "\x1e\x06\u54ab", // 咫
	0x54ac: "\x1e\x06\u54ac", // 咬
	0x54ad: "\x1e\x06\u54ad", // 咭
	0x54ae: "\x1e\x06\u54ae", // 咮
	0x54af: "\x1e\x06\u54af", // 咯
	0x54b0: "\x1e\x06\u54b0", // 咰
	0x54b1: "\x1e\x06\u54b1", // 咱
	0x54b2: "\x1e\x06\u54b2", // 咲
	0x54b3: "\x1e\x06\u54b3", // 咳
	0x54b4: "\x1e\x06\u54b4", // 咴
	0x54b5: "\x1e\x06\u54b5", // 咵
	0x54b6: "\x1e\x06\u54b6", // 咶
	0x54b7: "\x1e\x06\u54b7", // 咷
	0x54b8: "\x1e\x06\u54b8", // 咸
	0x54b9: "\x1e\x06\u54b9", // 咹
	0x54ba: "\x1e\x06\u54ba", // 咺
	0x54bb: "\x1e\x06\u54bb", // 咻
	0x54bc: "\x1e\x06\u54bc", // 咼
	0x54bd: "\x1e\x06\u54bd", // 咽
	0x54be: "\x1e\x06\u54be", // 咾
	0x54bf: "\x1e\x06\u54bf", // 咿
	0x54c0: "\x1e\x06\u54c0", // 哀
	0x54c1: "\x1e\x06\u54c1", // 品
	0x54c2: "\x1e\x06\u54c2", // 哂
	0x54c3: "\x1e\x06\u54c3", // 哃
	0x54c4: "\x1e\x06\u54c4", // 哄
	0x54c5: "\x1e\x06\u54c5", // 哅
	0x54c6: "\x1e\x06\u54c6", // 哆
	0x54c7: "\x1e\x06\u54c7", // 哇
	0x54c8: "\x1e\x06\u54c8", // 哈
	0x54c9: "\x1e\x06\u54c9", // 哉
	0x54ca: "\x1e\x06\u54ca", // 哊
	0x54cb: "\x1e\x06\u54cb", // 哋
	0x54cc: "\x1e\x06\u54cc", // 哌
	0x54cd: "\x1e\x06\u54cd", // 响
	0x54ce: "\x1e\x06\u54ce", // 哎
	0x54cf: "\x1e\x06\u54cf", // 哏
	0x54d0: "\x1e\x06\u54d0", // 哐
	0x54d1: "\x1e\x06\u54d1", // 哑
	0x54d2: "\x1e\x06\u54d2", // 哒
	0x54d3: "\x1e\x06\u54d3", // 哓
	0x54d4: "\x1e\x06\u54d4", // 哔
	0x54d5: "\x1e\x06\u54d5", // 哕
	0x54d6: "\x1e\x06\u54d6", // 哖
	0x54d7: "\x1e\x06\u54d7", // 哗
	0x54d8: "\x1e\x06\u54d8", // 哘
	0x54d9: "\x1e\x06\u54d9", // 哙
	0x54da: "\x1e\x06\u54da", // 哚
	0x54db: "\x1e\x06\u54db", // 哛
	0x54dc: "\x1e\x06\u54dc", // 哜
	0x54dd: "\x1e\x06\u54dd", // 哝
	0x54de: "\x1e\x06\u54de", // 哞
	0x54df: "\x1e\x06\u54df", // 哟
	0x54e0: "\x1e\a\u54e0", // 哠
	0x54e1: "\x1e\a\u54e1", // 員
	0x54e2: "\x1e\a\u54e2", // 哢
	0x54e3: "\x1e\a\u54e3", // 哣
	0x54e4: "\x1e\a\u54e4", // 哤
	0x54e5: "\x1e\a\u54e5", // 哥
	0x54e6: "\x1e\a\u54e6", // 哦
	0x54e7: "\x1e\a\u54e7", // 哧
	0x54e8: "\x1e\a\u54e8", // 哨
	0x54e9: "\x1e\a\u54e9", // 哩
	0x54ea: "\x1e\a\u54ea", // 哪
	0x54eb: "\x1e\a\u54eb", // 哫
	0x54ec: "\x1e\a\u54ec", // 哬
	0x54ed: "\x1e\a\u54ed", // 哭
	0x54ee: "\x1e\a\u54ee", // 哮
	0x54ef: "\x1e\a\u54ef", // 哯
	0x54f0: "\x1e\a\u54f0", // 哰
	0x54f1: "\x1e\a\u54f1", // 哱
	0x54f2: "\x1e\a\u54f2", // 哲
	0x54f3: "\x1e\a\u54f3", // 哳
	0x54f4: "\x1e\a\u54f4", // 哴
	0x54f5: "\x1e\a\u54f5", // 哵
	0x54f6: "\x1e\a\u54f6", // 哶
	0x54f7: "\x1e\a\u54f7", // 哷
	0x54f8: "\x1e\a\u54f8", // 哸
	0x54f9: "\x1e\a\u54f9", // 哹
	0x54fa: "\x1e\a\u54fa", // 哺
	0x54fb: "\x1e\a\u54fb", // 哻
	0x54fc: "\x1e\a\u54fc", // 哼
	0x54fd: "\x1e\a\u54fd", // 哽
	0x54fe: "\x1e\a\u54fe", // 哾
	0x54ff: "\x1e\a\u54ff", // 哿
	0x5500: "\x1e\a\u5500", // 唀
	0x5501: "\x1e\a\u5501", // 唁
	0x5502: "\x1e\a\u5502", // 唂
	0x5503: "\x1e\a\u5503", // 唃
	0x5504: "\x1e\a\u5504", // 唄
	0x5505: "\x1e\a\u5505", // 唅
	0x5506: "\x1e\a\u5506", // 唆
	0x5507: "\x1e\a\u5507", // 唇
	0x5508: "\x1e\a\u5508", // 唈
	0x5509: "\x1e\a\u5509", // 唉
	0x550a: "\x1e\a\u550a", // 唊
	0x550b: "\x1e\a\u550b", // 唋
	0x550c: "\x1e\a\u550c", // 唌
	0x550d: "\x1e\a\u550d", // 唍
	0x550e: "\x1e\a\u550e", // 唎
	0x550f: "\x1e\a\u550f", // 唏
	0x5510: "\x1e\a\u5510", // 唐
	0x5511: "\x1e\a\u5511", // 唑
	0x5512: "\x1e\a\u5512", // 唒
	0x5513: "\x1e\a\u5513", // 唓
	0x5514: "\x1e\a\u5514", // 唔
	0x5515: "\x1e\a\u5515", // 唕
	0x5516: "\x1e\a\u5516", // 唖
	0x5517: "\x1e\a\u5517", // 唗
	0x5518: "\x1e\a\u5518", // 唘
	0x5519: "\x1e\a\u5519", // 唙
	0x551a: "\x1e\a\u551a", // 唚
	0x551b: "\x1e\a\u551b", // 唛
	0x551c: "\x1e\a\u551c", // 唜
	0x551d: "\x1e\a\u551d", // 唝
	0x551e: "\x1e\a\u551e", // 唞
	0x551f: "\x1e\a\u551f", // 唟
	0x5520: "\x1e\a\u5520", // 唠
	0x5521: "\x1e\a\u5521", // 唡
	0x5522: "\x1e\a\u5522", // 唢
	0x5523: "\x1e\a\u5523", // 唣
	0x5524: "\x1e\a\u5524", // 唤
	0x5525: "\x1e\a\u5525", // 唥
	0x5526: "\x1e\a\u5526", // 唦
	0x5527: "\x1e\a\u5527", // 唧
	0x5528: "\x1e\b\u5528", // 唨
	0x5529: "\x1e\b\u5529", // 唩
	0x552a: "\x1e\b\u552a", // 唪
	0x552b: "\x1e\b\u552b", // 唫
	0x552c: "\x1e\b\u552c", // 唬
	0x552d: "\x1e\b\u552d", // 唭
	0x552e: "\x1e\b\u552e", // 售
	0x552f: "\x1e\b\u552f", // 唯
	0x5530: "\x1e\b\u5530", // 唰
	0x5531: "\x1e\b\u5531", // 唱
	0x5532: "\x1e\b\u5532", // 唲
	0x5533: "\x1e\b\u5533", // 唳
	0x5534: "\x1e\b\u5534", // 唴
	0x5535: "\x1e\b\u5535", // 唵
	0x5536: "\x1e\b\u5536", // 唶
	0x5537: "\x1e\b\u5537", // 唷
	0x5538: "\x1e\b\u5538", // 唸
	0x5539: "\x1e\b\u5539", // 唹
	0x553a: "\x1e\b\u553a", // 唺
	0x553b: "\x1e\b\u553b", // 唻
	0x553c: "\x1e\b\u553c", // 唼
	0x553d: "\x1e\b\u553d", // 唽
	0x553e: "\x1e\b\u553e", // 唾
	0x553f: "\x1e\b\u553f", // 唿
	0x5540: "\x1e\b\u5540", // 啀
	0x5541: "\x1e\b\u5541", // 啁
	0x5542: "\x1e\b\u5542", // 啂
	0x5543: "\x1e\b\u5543", // 啃
	0x5544: "\x1e\b\u5544", // 啄
	0x5545: "\x1e\b\u5545", // 啅
	0x5546: "\x1e\b\u5546", // 商
	0x5547: "\x1e\b\u5547", // 啇
	0x5548: "\x1e\b\u5548", // 啈
	0x5549: "\x1e\b\u5549", // 啉
	0x554a: "\x1e\b\u554a", // 啊
	0x554b: "\x1e\b\u554b", // 啋
	0x554c: "\x1e\b\u554c", // 啌
	0x554d: "\x1e\b\u554d", // 啍
	0x554e: "\x1e\b\u554e", // 啎
	0x554f: "\x1e\b\u554f", // 問
	0x5550: "\x1e\b\u5550", // 啐
	0x5551: "\x1e\b\u5551", // 啑
	0x5552: "\x1e\b\u5552", // 啒
	0x5553: "\x1e\b\u5553", // 啓
	0x5554: "\x1e\b\u5554", // 啔
	0x5555: "\x1e\b\u5555", // 啕
	0x5556: "\x1e\b\u5556", // 啖
	0x5557: "\x1e\b\u5557", // 啗
	0x5558: "\x1e\b\u5558", // 啘
	0x5559: "\x1e\t\u5559", // 啙
	0x555a: "\x1e\b\u555a", // 啚
	0x555b: "\x1e\b\u555b", // 啛
	0x555c: "\x1e\b\u555c", // 啜
	0x555d: "\x1e\b\u555d", // 啝
	0x555e: "\x1e\b\u555e", // 啞
	0x555f: "B\a\u555f", // 啟
	0x5560: "\x1e\b\u5560", // 啠
	0x5561: "\x1e\b\u5561", // 啡
	0x5562: "\x1e\b\u5562", // 啢
	0x5563: "\x1e\b\u5563", // 啣
	0x5564: "\x1e\b\u5564", // 啤
	0x5565: "\x1e\b\u5565", // 啥
	0x5566: "\x1e\b\u5566", // 啦
	0x5567: "\x1e\b\u5567", // 啧
	0x5568: "\x1e\b\u5568", // 啨
	0x5569: "\x1e\b\u5569", // 啩
	0x556a: "\x1e\b\u556a", // 啪
	0x556b: "\x1e\t\u556b", // 啫
	0x556c: "\x1e\b\u556c", // 啬
	0x556d: "\x1e\b\u556d", // 啭
	0x556e: "\x1e\b\u556e", // 啮
	0x556f: "\x1e\b\u556f", // 啯
	0x5570: "\x1e\b\u5570", // 啰
	0x5571: "\x1e\b\u5571", // 啱
	0x5572: "\x1e\b\u5572", // 啲
	0x5573: "\x1e\b\u5573", // 啳
	0x5574: "\x1e\b\u5574", // 啴
	0x5575: "\x1e\b\u5575", // 啵
	0x5576: "\x1e\b\u5576", // 啶
	0x5577: "\x1e\b\u5577", // 啷
	0x5578: "\x1e\b\u5578", // 啸
	0x5579: "\x1e\b\u5579", // 啹
	0x557a: "\x1e\t\u557a", // 啺
	0x557b: "\x1e\t\u557b", // 啻
	0x557c: "\x1e\t\u557c", // 啼
	0x557d: "\x1e\t\u557d", // 啽
	0x557e: "\x1e\t\u557e", // 啾
	0x557f: "\x1e\t\u557f", // 啿
	0x5580: "\x1e\t\u5580", // 喀
	0x5581: "\x1e\t\u5581", // 喁
	0x5582: "\x1e\t\u5582", // 喂
	0x5583: "\x1e\t\u5583", // 喃
	0x5584: "\x1e\t\u5584", // 善
	0x5585: "\x1e\t\u5585", // 喅
	0x5586: "\x1e\t\u5586", // 喆
	0x5587: "\x1e\t\u5587", // 喇
	0x5588: "\x1e\t\u5588", // 喈
	0x5589: "\x1e\t\u5589", // 喉
	0x558a: "\x1e\t\u558a", // 喊
	0x558b: "\x1e\t\u558b", // 喋
	0x558c: "\x1e\t\u558c", // 喌
	0x558d: "\x1e\n\u558d", // 喍
	0x558e: "\x1e\t\u558e", // 喎
	0x558f: "\x1e\t\u558f", // 喏
	0x5590: "\x1e\t\u5590", // 喐
	0x5591: "\x1e\t\u5591", // 喑
	0x5592: "\x1e\t\u5592", // 喒
	0x5593: "\x1e\t\u5593", // 喓
	0x5594: "\x1e\t\u5594", // 喔
	0x5595: "\x1e\t\u5595", // 喕
	0x5596: "\x1e\t\u5596", // 喖
	0x5597: "\x1e\t\u5597", // 喗
	0x5598: "\x1e\t\u5598", // 喘
	0x5599: "\x1e\t\u5599", // 喙
	0x559a: "\x1e\t\u559a", // 喚
	0x559b: "\x1e\t\u559b", // 喛
	0x559c: "\x1e\t\u559c", // 喜
	0x559d: "\x1e\t\u559d", // 喝
	0x559e: "\x1e\t\u559e", // 喞
	0x559f: "\x1e\t\u559f", // 喟
	0x55a0: "\x1e\t\u55a0", // 喠
	0x55a1: "\x1e\t\u55a1", // 喡
	0x55a2: "\x1e\t\u55a2", // 喢
	0x55a3: "\x1e\t\u55a3", // 喣
	0x55a4: "\x1e\t\u55a4", // 喤
	0x55a5: "\x1e\t\u55a5", // 喥
	0x55a6: "\x1e\t\u55a6", // 喦
	0x55a7: "\x1e\t\u55a7", // 喧
	0x55a8: "\x1e\t\u55a8", // 喨
	0x55a9: "\x1e\t\u55a9", // 喩
	0x55aa: "\x1e\t\u55aa", // 喪
	0x55ab: "\x1e\t\u55ab", // 喫
	0x55ac: "\x1e\t\u55ac", // 喬
	0x55ad: "\x1e\t\u55ad", // 喭
	0x55ae: "\x1e\t\u55ae", // 單
	0x55af: "\x1e\t\u55af", // 喯
	0x55b0: "\x1e\t\u55b0", // 喰
	0x55b1: "\x1e\t\u55b1", // 喱
	0x55b2: "\x1e\t\u55b2", // 喲
	0x55b3: "\x1e\t\u55b3", // 喳
	0x55b4: "\x1e\t\u55b4", // 喴
	0x55b5: "\x1e\t\u55b5", // 喵
	0x55b6: "\x1e\t\u55b6", // 営
	0x55b7: "\x1e\t\u55b7", // 喷
	0x55b8: "\x1e\t\u55b8", // 喸
	0x55b9: "\x1e\t\u55b9", // 喹
	0x55ba: "\x1e\t\u55ba", // 喺
	0x55bb: "\x1e\t\u55bb", // 喻
	0x55bc: "\x1e\t\u55bc", // 喼
	0x55bd: "\x1e\t\u55bd", // 喽
	0x55be: "\x1e\t\u55be", // 喾
	0x55bf: "\x1e\n\u55bf", // 喿
	0x55c0: "\x1e\n\u55c0", // 嗀
	0x55c1: "\x1e\n\u55c1", // 嗁
	0x55c2: "\x1e\n\u55c2", // 嗂
	0x55c3: "\x1e\n\u55c3", // 嗃
	0x55c4: "\x1e\n\u55c4", // 嗄
	0x55c5: "\x1e\n\u55c5", // 嗅
	0x55c6: "\x1e\n\u55c6", // 嗆
	0x55c7: "\x1e\n\u55c7", // 嗇
	0x55c8: "\x1e\n\u55c8", // 嗈
	0x55c9: "\x1e\n\u55c9", // 嗉
	0x55ca: "\x1e\n\u55ca", // 嗊
	0x55cb: "\x1e\n\u55cb", // 嗋
	0x55cc: "\x1e\n\u55cc", // 嗌
	0x55cd: "\x1e\n\u55cd", // 嗍
	0x55ce: "\x1e\n\u55ce", // 嗎
	0x55cf: "\x1e\n\u55cf", // 嗏
	0x55d0: "\x1e\n\u55d0", // 嗐
	0x55d1: "\x1e\n\u55d1", // 嗑
	0x55d2: "\x1e\n\u55d2", // 嗒
	0x55d3: "\x1e\n\u55d3", // 嗓
	0x55d4: "\x1e\n\u55d4", // 嗔
	0x55d5: "\x1e\n\u55d5", // 嗕
	0x55d6: "\x1e\n\u55d6", // 嗖
	0x55d7: "\x1e\n\u55d7", // 嗗
	0x55d8: "\x1e\n\u55d8", // 嗘
	0x55d9: "\x1e\n\u55d9", // 嗙
	0x55da: "\x1e\n\u55da", // 嗚
	0x55db: "\x1e\n\u55db", // 嗛
	0x55dc: "\x1e\n\u55dc", // 嗜
	0x55dd: "\x1e\n\u55dd", // 嗝
	0x55de: "\x1e\n\u55de", // 嗞
	0x55df: "\x1e\n\u55df", // 嗟
	0x55e0: "\x1e\n\u55e0", // 嗠
	0x55e1: "\x1e\n\u55e1", // 嗡
	0x55e2: "\x1e\n\u55e2", // 嗢
	0x55e3: "\x1e\n\u55e3", // 嗣
	0x55e4: "\x1e\n\u55e4", // 嗤
	0x55e5: "\x1e\n\u55e5", // 嗥
	0x55e6: "\x1e\n\u55e6", // 嗦
	0x55e7: "\x1e\n\u55e7", // 嗧
	0x55e8: "\x1e\n\u55e8", // 嗨
	0x55e9: "\x1e\n\u55e9", // 嗩
	0x55ea: "\x1e\n\u55ea", // 嗪
	0x55eb: "\x1e\n\u55eb", // 嗫
	0x55ec: "\x1e\n\u55ec", // 嗬
	0x55ed: "\x1e\n\u55ed", // 嗭
	0x55ee: "\x1e\n\u55ee", // 嗮
	0x55ef: "\x1e\n\u55ef", // 嗯
	0x55f0: "\x1e\n\u55f0", // 嗰
	0x55f1: "\x1e\n\u55f1", // 嗱
	0x55f2: "\x1e\n\u55f2", // 嗲
	0x55f3: "\x1e\n\u55f3", // 嗳
	0x55f4: "\x1e\n\u55f4", // 嗴
	0x55f5: "\x1e\n\u55f5", // 嗵
	0x55f6: "\x1e\v\u55f6", // 嗶
	0x55f7: "\x1e\v\u55f7", // 嗷
	0x55f8: "\x1e\v\u55f8", // 嗸
	0x55f9: "\x1e\v\u55f9", // 嗹
	0x55fa: "\x1e\v\u55fa", // 嗺
	0x55fb: "\x1e\v\u55fb", // 嗻
	0x55fc: "\x1e\v\u55fc", // 嗼
	0x55fd: "\x1e\v\u55fd", // 嗽
	0x55fe: "\x1e\v\u55fe", // 嗾
	0x55ff: "\x1e\v\u55ff", // 嗿
	0x5600: "\x1e\v\u5600", // 嘀
	0x5601: "\x1e\v\u5601", // 嘁
	0x5602: "\x1e\v\u5602", // 嘂
	0x5603: "\x1e\v\u5603", // 嘃
	0x5604: "\x1e\v\u5604", // 嘄
	0x5605: "\x1e\v\u5605", // 嘅
	0x5606: "\x1e\v\u5606", // 嘆
	0x5607: "\x1e\v\u5607", // 嘇
	0x5608: "\x1e\v\u5608", // 嘈
	0x5609: "\x1e\v\u5609", // 嘉
	0x560a: "\x1e\v\u560a", // 嘊
	0x560b: "\x1e\v\u560b", // 嘋
	0x560c: "\x1e\v\u560c", // 嘌
	0x560d: "\x1e\v\u560d", // 嘍
	0x560e: "\x1e\v\u560e", // 嘎
	0x560f: "\x1e\v\u560f", // 嘏
	0x5610: "\x1e\v\u5610", // 嘐
	0x5611: "\x1e\v\u5611", // 嘑
	0x5612: "\x1e\v\u5612", // 嘒
	0x5613: "\x1e\v\u5613", // 嘓
	0x5614: "\x1e\v\u5614", // 嘔
	0x5615: "\x1e\v\u5615", // 嘕
	0x5616: "\x1e\v\u5616", // 嘖
	0x5617: "\x1e\v\u5617", // 嘗
	0x5618: "\x1e\v\u5618", // 嘘
	0x5619: "\x1e\v\u5619", // 嘙
	0x561a: "\x1e\v\u561a", // 嘚
	0x561b: "\x1e\v\u561b", // 嘛
	0x561c: "\x1e\v\u561c", // 嘜
	0x561d: "\x1e\v\u561d", // 嘝
	0x561e: "\x1e\v\u561e", // 嘞
	0x561f: "\x1e\f\u561f", // 嘟
	0x5620: "\x1e\f\u5620", // 嘠
	0x5621: "\x1e\v\u5621", // 嘡
	0x5622: "\x1e\v\u5622", // 嘢
	0x5623: "\x1e\v\u5623", // 嘣
	0x5624: "\x1e\v\u5624", // 嘤
	0x5625: "\x1e\v\u5625", // 嘥
	0x5626: "\x1e\v\u5626", // 嘦
	0x5627: "\x1e\v\u5627", // 嘧
	0x5628: "\x1e\f\u5628", // 嘨
	0x5629: "\x1e\f\u5629", // 嘩
	0x562a: "\x1e\f\u562a", // 嘪
	0x562b: "\x1e\f\u562b", // 嘫
	0x562c: "\x1e\f\u562c", // 嘬
	0x562d: "\x1e\f\u562d", // 嘭
	0x562e: "\x1e\f\u562e", // 嘮
	0x562f: "\x1e\f\u562f", // 嘯
	0x5630: "\x1e\f\u5630", // 嘰
	0x5631: "\x1e\f\u5631", // 嘱
	0x5632: "\x1e\f\u5632", // 嘲
	0x5633: "\x1e\f\u5633", // 嘳
	0x5634: "\x1e\f\u5634", // 嘴
	0x5635: "\x1e\f\u5635", // 嘵
	0x5636: "\x1e\f\u5636", // 嘶
	0x5637: "\x1e\f\u5637", // 嘷
	0x5638: "\x1e\f\u5638", // 嘸
	0x5639: "\x1e\f\u5639", // 嘹
	0x563a: "\x1e\f\u563a", // 嘺
	0x563b: "\x1e\f\u563b", // 嘻
	0x563c: "\x1e\f\u563c", // 嘼
	0x563d: "\x1e\f\u563d", // 嘽
	0x563e: "\x1e\f\u563e", // 嘾
	0x563f: "\x1e\f\u563f", // 嘿
	0x5640: "\x1e\f\u5640", // 噀
	0x5641: "\x1e\f\u5641", // 噁
	0x5642: "\x1e\f\u5642", // 噂
	0x5643: "\x1e\f\u5643", // 噃
	0x5644: "\x1e\f\u5644", // 噄
	0x5645: "\x1e\t\u5645", // 噅
	0x5646: "\x1e\f\u5646", // 噆
	0x5647: "\x1e\f\u5647", // 噇
	0x5648: "\x1e\f\u5648", // 噈
	0x5649: "\x1e\f\u5649", // 噉
	0x564a: "\x1e\f\u564a", // 噊
	0x564b: "\x1e\f\u564b", // 噋
	0x564c: "\x1e\f\u564c", // 噌
	0x564d: "\x1e\f\u564d", // 噍
	0x564e: "\x1e\f\u564e", // 噎
	0x564f: "\x1e\f\u564f", // 噏
	0x5650: "\x1e\f\u5650", // 噐
	0x5651: "\x1e\v\u5651", // 噑
	0x5652: "\x1e\f\u5652", // 噒
	0x5653: "\x1e\v\u5653", // 噓
	0x5654: "\x1e\f\u5654", // 噔
	0x5655: "W\v\u5655", // 噕
	0x5656: "\x1e\f\u5656", // 噖
	0x5657: "\x1e\f\u5657", // 噗
	0x5658: "\x1e\f\u5658", // 噘
	0x5659: "\x1e\f\u5659", // 噙
	0x565a: "\x1e\f\u565a", // 噚
	0x565b: "\x1e\f\u565b", // 噛
	0x565c: "\x1e\f\u565c", // 噜
	0x565d: "\x1e\f\u565d", // 噝
	0x565e: "\x1e\r\u565e", // 噞
	0x565f: "\x1e\r\u565f", // 噟
	0x5660: "\x1e\r\u5660", // 噠
	0x5661: "\x1e\r\u5661", // 噡
	0x5662: "\x1e\r\u5662", // 噢
	0x5663: "\x1e\r\u5663", // 噣
	0x5664: "\x1e\r\u5664", // 噤
	0x5665: "\x1e\r\u5665", // 噥
	0x5666: "\x1e\r\u5666", // 噦
	0x5667: "\x1e\r\u5667", // 噧
	0x5668: "\x1e\r\u5668", // 器
	0x5669: "\x1e\r\u5669", // 噩
	0x566a: "\x1e\r\u566a", // 噪
	0x566b: "\x1e\r\u566b", // 噫
	0x566c: "\x1e\r\u566c", // 噬
	0x566d: "\x1e\r\u566d", // 噭
	0x566e: "\x1e\r\u566e", // 噮
	0x566f: "\x1e\r\u566f", // 噯
	0x5670: "\x1e\r\u5670", // 噰
	0x5671: "\x1e\r\u5671", // 噱
	0x5672: "\x1e\r\u5672", // 噲
	0x5673: "\x1e\r\u5673", // 噳
	0x5674: "\x1e\f\u5674", // 噴
	0x5675: "\x1e\r\u5675", // 噵
	0x5676: "\x1e\r\u5676", // 噶
	0x5677: "\x1e\r\u5677", // 噷
	0x5678: "\x1e\r\u5678", // 噸
	0x5679: "\x1e\r\u5679", // 噹
	0x567a: "\x1e\r\u567a", // 噺
	0x567b: "\x1e\r\u567b", // 噻
	0x567c: "\x1e\r\u567c", // 噼
	0x567d: "\x1e\x0e\u567d", // 噽
	0x567e: "\x1e\x0e\u567e", // 噾
	0x567f: "\x1e\x0e\u567f", // 噿
	0x5680: "\x1e\x0e\u5680", // 嚀
	0x5681: "\x1e\x0e\u5681", // 嚁
	0x5682: "\x1e\x0e\u5682", // 嚂
	0x5683: "\x1e\x0e\u5683", // 嚃
	0x5684: "\x1e\x0e\u5684", // 嚄
	0x5685: "\x1e\x0e\u5685", // 嚅
	0x5686: "\x1e\x0e\u5686", // 嚆
	0x5687: "\x1e\x0e\u5687", // 嚇
	0x5688: "\x1e\x0e\u5688", // 嚈
	0x5689: "\x1e\x0e\u5689", // 嚉
	0x568a: "\x1e\x0e\u568a", // 嚊
	0x568b: "\x1e\x0e\u568b", // 嚋
	0x568c: "\x1e\x0e\u568c", // 嚌
	0x568d: "\x1e\x0e\u568d", // 嚍
	0x568e: "\x1e\x0e\u568e", // 嚎
	0x568f: "\x1e\x0e\u568f", // 嚏
	0x5690: "\x1e\x0e\u5690", // 嚐
	0x5691: "\x1e\x0e\u5691", // 嚑
	0x5692: "\x1e\x0e\u5692", // 嚒
	0x5693: "\x1e\x0e\u5693", // 嚓
	0x5694: "\x1e\x0f\u5694", // 嚔
	0x5695: "\x1e\x0f\u5695", // 嚕
	0x5696: "\x1e\x0f\u5696", // 嚖
	0x5697: "\x1e\x0f\u5697", // 嚗
	0x5698: "\x1e\x0f\u5698", // 嚘
	0x5699: "\x1e\x0f\u5699", // 嚙
	0x569a: "\x1e\x0f\u569a", // 嚚
	0x569b: "\x1e\x0f\u569b", // 嚛
	0x569c: "\x1e\x0f\u569c", // 嚜
	0x569d: "\x1e\x0f\u569d", // 嚝
	0x569e: "\x1e\x0f\u569e", // 嚞
	0x569f: "\x1e\x0f\u569f", // 嚟
	0x56a0: "\x1e\x0f\u56a0", // 嚠
	0x56a1: "\x1e\x0f\u56a1", // 嚡
	0x56a2: "\x1e\x0f\u56a2", // 嚢
	0x56a3: "\x1e\x0f\u56a3", // 嚣
	0x56a4: "\x1e\x0f\u56a4", // 嚤
	0x56a5: "\x1e\x10\u56a5", // 嚥
	0x56a6: "\x1e\x10\u56a6", // 嚦
	0x56a7: "\x1e\x10\u56a7", // 嚧
	0x56a8: "\x1e\x10\u56a8", // 嚨
	0x56a9: "\x1e\x10\u56a9", // 嚩
	0x56aa: "\x1e\x10\u56aa", // 嚪
	0x56ab: "\x1e\x10\u56ab", // 嚫
	0x56ac: "\x1e\x10\u56ac", // 嚬
	0x56ad: "\x1e\x10\u56ad", // 嚭
	0x56ae: "\x1e\x10\u56ae", // 嚮
	0x56af: "\x1e\x10\u56af", // 嚯
	0x56b0: "\x1e\x10\u56b0", // 嚰
	0x56b1: "\x1e\x11\u56b1", // 嚱
	0x56b2: "\x1e\x11\u56b2", // 嚲
	0x56b3: "\x1e\x11\u56b3", // 嚳
	0x56b4: "\x1e\x11\u56b4", // 嚴
	0x56b5: "\x1e\x11\u56b5", // 嚵
	0x56b6: "\x1e\x11\u56b6", // 嚶
	0x56b7: "\x1e\x11\u56b7", // 嚷
	0x56b8: "\x1e\x11\u56b8", // 嚸
	0x56b9: "\x1e\x11\u56b9", // 嚹
	0x56ba: "\x1e\x0e\u56ba", // 嚺
	0x56bb: "\x1e\x12\u56bb", // 嚻
	0x56bc: "\x1e\x12\u56bc", // 嚼
	0x56bd: "\x1e\x12\u56bd", // 嚽
	0x56be: "\x1e\x12\u56be", // 嚾
	0x56bf: "\x1e\x12\u56bf", // 嚿
	0x56c0: "\x1e\x12\u56c0", // 囀
	0x56c1: "\x1e\x12\u56c1", // 囁
	0x56c2: "\x1e\x12\u56c2", // 囂
	0x56c3: "\x1e\x12\u56c3", // 囃
	0x56c4: "\x1e\x12\u56c4", // 囄
	0x56c5: "\x1e\x13\u56c5", // 囅
	0x56c6: "\x1e\x13\u56c6", // 囆
	0x56c7: "\x1e\x13\u56c7", // 囇
	0x56c8: "\x1e\x13\u56c8", // 囈
	0x56c9: "\x1e\x13\u56c9", // 囉
	0x56ca: "\x1e\x13\u56ca", // 囊
	0x56cb: "\x1e\x13\u56cb", // 囋
	0x56cc: "\x1e\x14\u56cc", // 囌
	0x56cd: "\x1e\x12\u56cd", // 囍
	0x56ce: "\x1e\x13\u56ce", // 囎
	0x56cf: "\x1e\x14\u56cf", // 囏
	0x56d0: "\x1e\x14\u56d0", // 囐
	0x56d1: "\x1e\x15\u56d1", // 囑
	0x56d2: "\x1e\x15\u56d2", // 囒
	0x56d3: "\x1e\x15\u56d3", // 囓
	0x56d4: "\x1e\x16\u56d4", // 囔
	0x56d5: "\x1e\x16\u56d5", // 囕
	0x56d6: "\x1e\x19\u56d6", // 囖
	0x56d7: "\x1f\x00\u56d7", // 囗
	0x56d8: "\x1f\x02\u56d8", // 囘
	0x56d9: "\x1f\x02\u56d9", // 囙
	0x56da: "\x1f\x02\u56da", // 囚
	0x56db: "\x1f\x02\u56db", // 四
	0x56dc: "\x1f\x02\u56dc", // 囜
	0x56dd: "\x1f\x03\u56dd", // 囝
	0x56de: "\x1f\x03\u56de", // 回
	0x56df: "\x1f\x03\u56df", // 囟
	0x56e0: "\x1f\x03\u56e0", // 因
	0x56e1: "\x1f\x03\u56e1", // 囡
	0x56e2: "\x1f\x03\u56e2", // 团
	0x56e3: "\x1f\x03\u56e3", // 団
	0x56e4: "\x1f\x04\u56e4", // 囤
	0x56e5: "\x1f\x04\u56e5", // 囥
	0x56e6: "\x1f\x04\u56e6", // 囦
	0x56e7: "\x1f\x04\u56e7", // 囧
	0x56e8: "\x1f\x04\u56e8", // 囨
	0x56e9: "\x1f\x04\u56e9", // 囩
	0x56ea: "\x1f\x04\u56ea", // 囪
	0x56eb: "\x1f\x04\u56eb", // 囫
	0x56ec: "\x1f\x04\u56ec", // 囬
	0x56ed: "\x1f\x04\u56ed", // 园
	0x56ee: "\x1f\x04\u56ee", // 囮
	0x56ef: "\x1f\x04\u56ef", // 囯
	0x56f0: "\x1f\x04\u56f0", // 困
	0x56f1: "\x1f\x04\u56f1", // 囱
	0x56f2: "\x1f\x04\u56f2", // 囲
	0x56f3: "\x1f\x04\u56f3", // 図
	0x56f4: "\x1f\x04\u56f4", // 围
	0x56f5: "\x1f\x04\u56f5", // 囵
	0x56f6: "\x1f\x05\u56f6", // 囶
	0x56f7: "\x1f\x05\u56f7", // 囷
	0x56f8: "\x1f\x05\u56f8", // 囸
	0x56f9: "\x1f\x05\u56f9", // 囹
	0x56fa: "\x1f\x05\u56fa", // 固
	0x56fb: "\x1f\x05\u56fb", // 囻
	0x56fc: "\x1f\x05\u56fc", // 囼
	0x56fd: "\x1f\x05\u56fd", // 国
	0x56fe: "\x1f\x05\u56fe", // 图
	0x56ff: "\x1f\x06\u56ff", // 囿
	0x5700: "\x1f\x06\u5700", // 圀
	0x5701: "\x1f\a\u5701", // 圁
	0x5702: "\x1f\a\u5702", // 圂
	0x5703: "\x1f\a\u5703", // 圃
	0x5704: "\x1f\a\u5704", // 圄
	0x5705: "\x1f\a\u5705", // 圅
	0x5706: "\x1f\a\u5706", // 圆
	0x5707: "\x1f\b\u5707", // 圇
	0x5708: "\x1f\b\u5708", // 圈
	0x5709: "\x1f\b\u5709", // 圉
	0x570a: "\x1f\b\u570a", // 圊
	0x570b: "\x1f\b\u570b", // 國
	0x570c: "\x1f\t\u570c", // 圌
	0x570d: "\x1f\t\u570d", // 圍
	0x570e: "\x1f\t\u570e", // 圎
	0x570f: "\x1f\b\u570f", // 圏
	0x5710: "\x1f\t\u5710", // 圐
	0x5711: "\x1f\n\u5711", // 圑
	0x5712: "\x1f\n\u5712", // 園
	0x5713: "\x1f\n\u5713", // 圓
	0x5714: "\x1f\n\u5714", // 圔
	0x5715: "\x1f\n\u5715", // 圕
	0x5716: "\x1f\v\u5716", // 圖
	0x5717: "\x1f\v\u5717", // 圗
	0x5718: "\x1f\v\u5718", // 團
	0x5719: "\x1f\v\u5719", // 圙
	0x571a: "\x1f\f\u571a", // 圚
	0x571b: "\x1f\r\u571b", // 圛
	0x571c: "\x1f\r\u571c", // 圜
	0x571d: "\x1f\x13\u571d", // 圝
	0x571e: "\x1f\x17\u571e", // 圞
	0x571f: " \x00\u571f", // 土
	0x5720: " \x01\u5720", // 圠
	0x5721: " \x01\u5721", // 圡
	0x5722: " \x02\u5722", // 圢
	0x5723: " \x02\u5723", // 圣
	0x5724: " \x02\u5724", // 圤
	0x5725: " \x02\u5725", // 圥
	0x5726: " \x02\u5726", // 圦
	0x5727: " \x02\u5727", // 圧
	0x5728: " \x03\u5728", // 在
	0x5729: " \x03\u5729", // 圩
	0x572a: " \x03\u572a", // 圪
	0x572b: " \x03\u572b", // 圫
	0x572c: " \x03\u572c", // 圬
	0x572d: " \x03\u572d", // 圭
	0x572e: " \x03\u572e", // 圮
	0x572f: " \x03\u572f", // 圯
	0x5730: " \x03\u5730", // 地
	0x5731: " \x03\u5731", // 圱
	0x5732: " \x03\u5732", // 圲
	0x5733: " \x03\u5733", // 圳
	0x5734: " \x03\u5734", // 圴
	0x5735: " \x03\u5735", // 圵
	0x5736: " \x03\u5736", // 圶
	0x5737: " \x03\u5737", // 圷
	0x5738: " \x03\u5738", // 圸
	0x5739: " \x03\u5739", // 圹
	0x573a: " \x03\u573a", // 场
	0x573b: " \x04\u573b", // 圻
	0x573c: " \x04\u573c", // 圼
	0x573d: " \x04\u573d", // 圽
	0x573e: " \x04\u573e", // 圾
	0x573f: " \x04\u573f", // 圿
	0x5740: " \x04\u5740", // 址
	0x5741: " \x04\u5741", // 坁
	0x5742: " \x04\u5742", // 坂
	0x5743: " \x04\u5743", // 坃
	0x5744: " \x04\u5744", // 坄
	0x5745: " \x04\u5745", // 坅
	0x5746: " \x04\u5746", // 坆
	0x5747: " \x04\u5747", // 均
	0x5748: " \x04\u5748", // 坈
	0x5749: " \x04\u5749", // 坉
	0x574a: " \x04\u574a", // 坊
	0x574b: " \x04\u574b", // 坋
	0x574c: " \x04\u574c", // 坌
	0x574d: " \x04\u574d", // 坍
	0x574e: " \x04\u574e", // 坎
	0x574f: " \x04\u574f", // 坏
	0x5750: " \x04\u5750", // 坐
	0x5751: " \x04\u5751", // 坑
	0x5752: " \x04\u5752", // 坒
	0x5753: " \x04\u5753", // 坓
	0x5754: " \x04\u5754", // 坔
	0x5755: " \x04\u5755", // 坕
	0x5756: " \x04\u5756", // 坖
	0x5757: " \x04\u5757", // 块
	0x5758: " \x04\u5758", // 坘
	0x5759: " \x04\u5759", // 坙
	0x575a: " \x04\u575a", // 坚
	0x575b: " \x04\u575b", // 坛
	0x575c: " \x04\u575c", // 坜
	0x575d: " \x04\u575d", // 坝
	0x575e: " \x04\u575e", // 坞
	0x575f: " \x04\u575f", // 坟
	0x5760: " \x04\u5760", // 坠
	0x5761: " \x05\u5761", // 坡
	0x5762: " \x05\u5762", // 坢
	0x5763: " \x05\u5763", // 坣
	0x5764: " \x05\u5764", // 坤
	0x5765: " \x05\u5765", // 坥
	0x5766: " \x05\u5766", // 坦
	0x5767: " \x05\u5767", // 坧
	0x5768: " \x05\u5768", // 坨
	0x5769: " \x05\u5769", // 坩
	0x576a: " \x05\u576a", // 坪
	0x576b: " \x05\u576b", // 坫
	0x576c: " \x05\u576c", // 坬
	0x576d: " \x05\u576d", // 坭
	0x576e: " \x05\u576e", // 坮
	0x576f: " \x05\u576f", // 坯
	0x5770: " \x05\u5770", // 坰
	0x5771: " \x05\u5771", // 坱
	0x5772: " \x05\u5772", // 坲
	0x5773: " \x05\u5773", // 坳
	0x5774: " \x05\u5774", // 坴
	0x5775: " \x05\u5775", // 坵
	0x5776: " \x05\u5776", // 坶
	0x5777: " \x05\u5777", // 坷
	0x5778: " \x05\u5778", // 坸
	0x5779: " \x05\u5779", // 坹
	0x577a: " \x05\u577a", // 坺
	0x577b: " \x05\u577b", // 坻
	0x577c: " \x05\u577c", // 坼
	0x577d: " \x05\u577d", // 坽
	0x577e: " \x05\u577e", // 坾
	0x577f: " \x05\u577f", // 坿
	0x5780: " \x05\u5780", // 垀
	0x5781: " \x05\u5781", // 垁
	0x5782: " \x05\u5782", // 垂
	0x5783: " \x05\u5783", // 垃
	0x5784: " \x05\u5784", // 垄
	0x5785: " \x05\u5785", // 垅
	0x5786: " \x05\u5786", // 垆
	0x5787: " \x05\u5787", // 垇
	0x5788: " \x05\u5788", // 垈
	0x5789: " \x05\u5789", // 垉
	0x578a: " \x05\u578a", // 垊
	0x578b: " \x06\u578b", // 型
	0x578c: " \x06\u578c", // 垌
	0x578d: " \x06\u578d", // 垍
	0x578e: " \x06\u578e", // 垎
	0x578f: " \x06\u578f", // 垏
	0x5790: " \x06\u5790", // 垐
	0x5791: " \x06\u5791", // 垑
	0x5792: " \x06\u5792", // 垒
	0x5793: " \x06\u5793", // 垓
	0x5794: " \x06\u5794", // 垔
	0x5795: " \x06\u5795", // 垕
	0x5796: " \x06\u5796", // 垖
	0x5797: " \x06\u5797", // 垗
	0x5798: " \x06\u5798", // 垘
	0x5799: " \x06\u5799", // 垙
	0x579a: " \x06\u579a", // 垚
	0x579b: " \x06\u579b", // 垛
	0x579c: " \x06\u579c", // 垜
	0x579d: " \x06\u579d", // 垝
	0x579e: " \x06\u579e", // 垞
	0x579f: " \x06\u579f", // 垟
	0x57a0: " \x06\u57a0", // 垠
	0x57a1: " \x06\u57a1", // 垡
	0x57a2: " \x06\u57a2", // 垢
	0x57a3: " \x06\u57a3", // 垣
	0x57a4: " \x06\u57a4", // 垤
	0x57a5: " \x06\u57a5", // 垥
	0x57a6: " \x06\u57a6", // 垦
	0x57a7: " \x06\u57a7", // 垧
	0x57a8: " \x06\u57a8", // 垨
	0x57a9: " \x06\u57a9", // 垩
	0x57aa: " \x06\u57aa", // 垪
	0x57ab: " \x06\u57ab", // 垫
	0x57ac: " \x06\u57ac", // 垬
	0x57ad: " \x06\u57ad", // 垭
	0x57ae: " \x06\u57ae", // 垮
	0x57af: " \x06\u57af", // 垯
	0x57b0: " \x06\u57b0", // 垰
	0x57b1: " \x06\u57b1", // 垱
	0x57b2: " \x06\u57b2", // 垲
	0x57b3: " \x06\u57b3", // 垳
	0x57b4: " \x06\u57b4", // 垴
	0x57b5: " \x06\u57b5", // 垵
	0x57b6: " \a\u57b6", // 垶
	0x57b7: " \a\u57b7", // 垷
	0x57b8: " \a\u57b8", // 垸
	0x57b9: " \a\u57b9", // 垹
	0x57ba: " \a\u57ba", // 垺
	0x57bb: " \a\u57bb", // 垻
	0x57bc: " \a\u57bc", // 垼
	0x57bd: " \a\u57bd", // 垽
	0x57be: " \a\u57be", // 垾
	0x57bf: " \a\u57bf", // 垿
	0x57c0: " \a\u57c0", // 埀
	0x57c1: " \a\u57c1", // 埁
	0x57c2: " \a\u57c2", // 埂
	0x57c3: " \a\u57c3", // 埃
	0x57c4: " \a\u57c4", // 埄
	0x57c5: " \a\u57c5", // 埅
	0x57c6: " \a\u57c6", // 埆
	0x57c7: " \a\u57c7", // 埇
	0x57c8: " \a\u57c8", // 埈
	0x57c9: " \a\u57c9", // 埉
	0x57ca: " \a\u57ca", // 埊
	0x57cb: " \a\u57cb", // 埋
	0x57cc: " \a\u57cc", // 埌
	0x57cd: " \a\u57cd", // 埍
	0x57ce: " \x06\u57ce", // 城
	0x57cf: " \a\u57cf", // 埏
	0x57d0: " \a\u57d0", // 埐
	0x57d1: " \a\u57d1", // 埑
	0x57d2: " \a\u57d2", // 埒
	0x57d3: " \a\u57d3", // 埓
	0x57d4: " \a\u57d4", // 埔
	0x57d5: " \a\u57d5", // 埕
	0x57d6: " \a\u57d6", // 埖
	0x57d7: " \a\u57d7", // 埗
	0x57d8: " \a\u57d8", // 埘
	0x57d9: " \a\u57d9", // 埙
	0x57da: " \a\u57da", // 埚
	0x57db: " \a\u57db", // 埛
	0x57dc: " \b\u57dc", // 埜
	0x57dd: " \b\u57dd", // 埝
	0x57de: " \b\u57de", // 埞
	0x57df: " \b\u57df", // 域
	0x57e0: " \b\u57e0", // 埠
	0x57e1: " \b\u57e1", // 埡
	0x57e2: " \b\u57e2", // 埢
	0x57e3: " \b\u57e3", // 埣
	0x57e4: " \b\u57e4", // 埤
	0x57e5: " \b\u57e5", // 埥
	0x57e6: " \b\u57e6", // 埦
	0x57e7: " \b\u57e7", // 埧
	0x57e8: " \b\u57e8", // 埨
	0x57e9: " \b\u57e9", // 埩
	0x57ea: " \t\u57ea", // 埪
	0x57eb: " \b\u57eb", // 埫
	0x57ec: " \b\u57ec", // 埬
	0x57ed: " \b\u57ed", // 埭
	0x57ee: " \b\u57ee", // 埮
	0x57ef: " \b\u57ef", // 埯
	0x57f0: " \b\u57f0", // 埰
	0x57f1: " \b\u57f1", // 埱
	0x57f2: " \b\u57f2", // 埲
	0x57f3: " \b\u57f3", // 埳
	0x57f4: " \b\u57f4", // 埴
	0x57f5: " \b\u57f5", // 埵
	0x57f6: " \b\u57f6", // 埶
	0x57f7: " \b\u57f7", // 執
	0x57f8: " \b\u57f8", // 埸
	0x57f9: " \b\u57f9", // 培
	0x57fa: " \b\u57fa", // 基
	0x57fb: " \b\u57fb", // 埻
	0x57fc: " \b\u57fc", // 埼
	0x57fd: " \b\u57fd", // 埽
	0x57fe: " \b\u57fe", // 埾
	0x57ff: " \b\u57ff", // 埿
	0x5800: " \b\u5800", // 堀
	0x5801: " \b\u5801", // 堁
	0x5802: " \b\u5802", // 堂
	0x5803: " \b\u5803", // 堃
	0x5804: " \b\u5804", // 堄
	0x5805: " \b\u5805", // 堅
	0x5806: " \b\u5806", // 堆
	0x5807: " \b\u5807", // 堇
	0x5808: " \b\u5808", // 堈
	0x5809: " \b\u5809", // 堉
	0x580a: " \b\u580a", // 堊
	0x580b: " \b\u580b", // 堋
	0x580c: " \b\u580c", // 堌
	0x580d: " \b\u580d", // 堍
	0x580e: " \b\u580e", // 堎
	0x580f: " \b\u580f", // 堏
	0x5810: " \b\u5810", // 堐
	0x5811: " \b\u5811", // 堑
	0x5812: " \b\u5812", // 堒
	0x5813: " \b\u5813", // 堓
	0x5814: " \b\u5814", // 堔
	0x5815: " \b\u5815", // 堕
	0x5816: " \t\u5816", // 堖
	0x5817: " \t\u5817", // 堗
	0x5818: " \t\u5818", // 堘
	0x5819: " \t\u5819", // 堙
	0x581a: " \t\u581a", // 堚
	0x581b: " \t\u581b", // 堛
	0x581c: " \t\u581c", // 堜
	0x581d: " \t\u581d", // 堝
	0x581e: " \t\u581e", // 堞
	0x581f: " \t\u581f", // 堟
	0x5820: " \t\u5820", // 堠
	0x5821: " \t\u5821", // 堡
	0x5822: " \t\u5822", // 堢
	0x5823: " \t\u5823", // 堣
	0x5824: " \t\u5824", // 堤
	0x5825: " \t\u5825", // 堥
	0x5826: " \t\u5826", // 堦
	0x5827: " \t\u5827", // 堧
	0x5828: " \t\u5828", // 堨
	0x5829: " \t\u5829", // 堩
	0x582a: " \t\u582a", // 堪
	0x582b: " \t\u582b", // 堫
	0x582c: " \t\u582c", // 堬
	0x582d: " \t\u582d", // 堭
	0x582e: " \t\u582e", // 堮
	0x582f: " \t\u582f", // 堯
	0x5830: " \t\u5830", // 堰
	0x5831: " \t\u5831", // 報
	0x5832: " \t\u5832", // 堲
	0x5833: " \t\u5833", // 堳
	0x5834: " \t\u5834", // 場
	0x5835: " \t\u5835", // 堵
	0x5836: " \t\u5836", // 堶
	0x5837: " \t\u5837", // 堷
	0x5838: " \t\u5838", // 堸
	0x5839: " \t\u5839", // 堹
	0x583a: " \t\u583a", // 堺
	0x583b: " \t\u583b", // 堻
	0x583c: " \t\u583c", // 堼
	0x583d: " \n\u583d", // 堽
	0x583e: " \t\u583e", // 堾
	0x583f: " \t\u583f", // 堿
	0x5840: " \t\u5840", // 塀
	0x5841: " \t\u5841", // 塁
	0x5842: " \t\u5842", // 塂
	0x5843: " \n\u5843", // 塃
	0x5844: " \t\u5844", // 塄
	0x5845: " \t\u5845", // 塅
	0x5846: " \t\u5846", // 塆
	0x5847: " \t\u5847", // 塇
	0x5848: " \t\u5848", // 塈
	0x5849: " \n\u5849", // 塉
	0x584a: " \n\u584a", // 塊
	0x584b: " \n\u584b", // 塋
	0x584c: " \n\u584c", // 塌
	0x584d: " \n\u584d", // 塍
	0x584e: " \n\u584e", // 塎
	0x584f: " \n\u584f", // 塏
	0x5850: " \n\u5850", // 塐
	0x5851: " \n\u5851", // 塑
	0x5852: " \n\u5852", // 塒
	0x5853: " \n\u5853", // 塓
	0x5854: " \n\u5854", // 塔
	0x5855: " \n\u5855", // 塕
	0x5856: " \n\u5856", // 塖
	0x5857: " \n\u5857", // 塗
	0x5858: " \n\u5858", // 塘
	0x5859: " \n\u5859", // 塙
	0x585a: " \n\u585a", // 塚
	0x585b: " \n\u585b", // 塛
	0x585c: " \n\u585c", // 塜
	0x585d: " \n\u585d", // 塝
	0x585e: " \n\u585e", // 塞
	0x585f: " \n\u585f", // 塟
	0x5860: " \n\u5860", // 塠
	0x5861: " \n\u5861", // 塡
	0x5862: " \n\u5862", // 塢
	0x5863: " \n\u5863", // 塣
	0x5864: " \n\u5864", // 塤
	0x5865: " \n\u5865", // 塥
	0x5866: " \n\u5866", // 塦
	0x5867: " \n\u5867", // 塧
	0x5868: " \n\u5868", // 塨
	0x5869: " \n\u5869", // 塩
	0x586a: " \n\u586a", // 塪
	0x586b: " \n\u586b", // 填
	0x586c: " \n\u586c", // 塬
	0x586d: " \n\u586d", // 塭
	0x586e: " \n\u586e", // 塮
	0x586f: " \n\u586f", // 塯
	0x5870: " \n\u5870", // 塰
	0x5871: " \n\u5871", // 塱
	0x5872: " \v\u5872", // 塲
	0x5873: " \v\u5873", // 塳
	0x5874: " \v\u5874", // 塴
	0x5875: " \v\u5875", // 塵
	0x5876: " \v\u5876", // 塶
	0x5877: " \v\u5877", // 塷
	0x5878: " \v\u5878", // 塸
	0x5879: " \v\u5879", // 塹
	0x587a: " \v\u587a", // 塺
	0x587b: " \v\u587b", // 塻
	0x587c: " \v\u587c", // 塼
	0x587d: " \v\u587d", // 塽
	0x587e: " \v\u587e", // 塾
	0x587f: " \v\u587f", // 塿
	0x5880: " \v\u5880", // 墀
	0x5881: " \v\u5881", // 墁
	0x5882: " \v\u5882", // 墂
	0x5883: " \v\u5883", // 境
	0x5884: " \v\u5884", // 墄
	0x5885: " \v\u5885", // 墅
	0x5886: " \v\u5886", // 墆
	0x5887: " \v\u5887", // 墇
	0x5888: " \v\u5888", // 墈
	0x5889: " \v\u5889", // 墉
	0x588a: " \v\u588a", // 墊
	0x588b: " \v\u588b", // 墋
	0x588c: " \v\u588c", // 墌
	0x588d: " \v\u588d", // 墍
	0x588e: " \v\u588e", // 墎
	0x588f: " \v\u588f", // 墏
	0x5890: " \v\u5890", // 墐
	0x5891: " \v\u5891", // 墑
	0x5892: " \v\u5892", // 墒
	0x5893: " \v\u5893", // 墓
	0x5894: " \v\u5894", // 墔
	0x5895: " \v\u5895", // 墕
	0x5896: " \v\u5896", // 墖
	0x5897: " \v\u5897", // 増
	0x5898: " \v\u5898", // 墘
	0x5899: " \v\u5899", // 墙
	0x589a: " \v\u589a", // 墚
	0x589b: " \v\u589b", // 墛
	0x589c: " \f\u589c", // 墜
	0x589d: " \f\u589d", // 墝
	0x589e: " \f\u589e", // 增
	0x589f: " \f\u589f", // 墟
	0x58a0: " \f\u58a0", // 墠
	0x58a1: " \f\u58a1", // 墡
	0x58a2: " \f\u58a2", // 墢
	0x58a3: " \f\u58a3", // 墣
	0x58a4: " \f\u58a4", // 墤
	0x58a5: " \f\u58a5", // 墥
	0x58a6: " \f\u58a6", // 墦
	0x58a7: " \f\u58a7", // 墧
	0x58a8: "\xcb\x03\u58a8", // 墨
	0x58a9: " \f\u58a9", // 墩
	0x58aa: " \f\u58aa", // 墪
	0x58ab: " \f\u58ab", // 墫
	0x58ac: " \f\u58ac", // 墬
	0x58ad: " \f\u58ad", // 墭
	0x58ae: " \f\u58ae", // 墮
	0x58af: " \f\u58af", // 墯
	0x58b0: " \f\u58b0", // 墰
	0x58b1: " \f\u58b1", // 墱
	0x58b2: " \f\u58b2", // 墲
	0x58b3: " \f\u58b3", // 墳
	0x58b4: " \f\u58b4", // 墴
	0x58b5: " \f\u58b5", // 墵
	0x58b6: " \f\u58b6", // 墶
	0x58b7: " \f\u58b7", // 墷
	0x58b8: " \f\u58b8", // 墸
	0x58b9: " \f\u58b9", // 墹
	0x58ba: " \r\u58ba", // 墺
	0x58bb: " \r\u58bb", // 墻
	0x58bc: " \r\u58bc", // 墼
	0x58bd: " \r\u58bd", // 墽
	0x58be: " \r\u58be", // 墾
	0x58bf: " \r\u58bf", // 墿
	0x58c0: " \r\u58c0", // 壀
	0x58c1: " \r\u58c1", // 壁
	0x58c2: " \r\u58c2", // 壂
	0x58c3: " \r\u58c3", // 壃
	0x58c4: " \r\u58c4", // 壄
	0x58c5: " \r\u58c5", // 壅
	0x58c6: " \r\u58c6", // 壆
	0x58c7: " \r\u58c7", // 壇
	0x58c8: " \r\u58c8", // 壈
	0x58c9: " \r\u58c9", // 壉
	0x58ca: " \r\u58ca", // 壊
	0x58cb: " \r\u58cb", // 壋
	0x58cc: " \r\u58cc", // 壌
	0x58cd: " \x0e\u58cd", // 壍
	0x58ce: " \x0e\u58ce", // 壎
	0x58cf: " \x0e\u58cf", // 壏
	0x58d0: " \x0e\u58d0", // 壐
	0x58d1: " \x0e\u58d1", // 壑
	0x58d2: " \x0e\u58d2", // 壒
	0x58d3: " \x0e\u58d3", // 壓
	0x58d4: " \x0e\u58d4", // 壔
	0x58d5: " \x0e\u58d5", // 壕
	0x58d6: " \x0e\u58d6", // 壖
	0x58d7: " \x0e\u58d7", // 壗
	0x58d8: " \x0f\u58d8", // 壘
	0x58d9: " \x0f\u58d9", // 壙
	0x58da: " \x10\u58da", // 壚
	0x58db: " \x10\u58db", // 壛
	0x58dc: " \x10\u58dc", // 壜
	0x58dd: " \x10\u58dd", // 壝
	0x58de: " \x10\u58de", // 壞
	0x58df: " \x10\u58df", // 壟
	0x58e0: " \x10\u58e0", // 壠
	0x58e1: "\x1d\x11\u58e1", // 壡
	0x58e2: " \x10\u58e2", // 壢
	0x58e3: " \x11\u58e3", // 壣
	0x58e4: " \x11\u58e4", // 壤
	0x58e5: " \x11\u58e5", // 壥
	0x58e6: " \x12\u58e6", // 壦
	0x58e7: " \x14\u58e7", // 壧
	0x58e8: " \x14\u58e8", // 壨
	0x58e9: " \x15\u58e9", // 壩
	0x58ea: " \x16\u58ea", // 壪
	0x58eb: "!\x00\u58eb", // 士
	0x58ec: "!\x01\u58ec", // 壬
	0x58ed: "!\x02\u58ed", // 壭
	0x58ee: "!\x03\u58ee", // 壮
	0x58ef: "!\x04\u58ef", // 壯
	0x58f0: "!\x04\u58f0", // 声
	0x58f1: "!\x04\u58f1", // 壱
	0x58f2: "!\x04\u58f2", // 売
	0x58f3: "!\x04\u58f3", // 壳
	0x58f4: "!\x06\u58f4", // 壴
	0x58f5: "!\x06\u58f5", // 壵
	0x58f6: "!\a\u58f6", // 壶
	0x58f7: "!\b\u58f7", // 壷
	0x58f8: "!\b\u58f8", // 壸
	0x58f9: "!\t\u58f9", // 壹
	0x58fa: "!\t\u58fa", // 壺
	0x58fb: "!\t\u58fb", // 壻
	0x58fc: "!\n\u58fc", // 壼
	0x58fd: "!\v\u58fd", // 壽
	0x58fe: "!\v\u58fe", // 壾
	0x58ff: "!\f\u58ff", // 壿
	0x5900: "!\f\u5900", // 夀
	0x5901: "!\r\u5901", // 夁
	0x5902: "\"\x00\u5902", // 夂
	0x5903: "\"\x01\u5903", // 夃
	0x5904: "\"\x02\u5904", // 处
	0x5905: "\"\x03\u5905", // 夅
	0x5906: "\"\x04\u5906", // 夆
	0x5907: "\"\x05\u5907", // 备
	0x5908: "\"\x06\u5908", // 夈
	0x5909: "#\x06\u5909", // 変
	0x590a: "#\x00\u590a", // 夊
	0x590b: "#\x04\u590b", // 夋
	0x590c: "#\x05\u590c", // 夌
	0x590d: "#\x06\u590d", // 复
	0x590e: "#\a\u590e", // 夎
	0x590f: "#\a\u590f", // 夏
	0x5910: "#\v\u5910", // 夐
	0x5911: "#\x0f\u5911", // 夑
	0x5912: "#\x10\u5912", // 夒
	0x5913: "#\x0f\u5913", // 夓
	0x5914: "#\x13\u5914", // 夔
	0x5915: "$\x00\u5915", // 夕
	0x5916: "$\x02\u5916", // 外
	0x5917: "$\x02\u5917", // 夗
	0x5918: "$\x02\u5918", // 夘
	0x5919: "$\x03\u5919", // 夙
	0x591a: "$\x03\u591a", // 多
	0x591b: "$\x03\u591b", // 夛
	0x591c: "$\x05\u591c", // 夜
	0x591d: "$\x05\u591d", // 夝
	0x591e: "$\a\u591e", // 夞
	0x591f: "$\b\u591f", // 够
	0x5920: "$\b\u5920", // 夠
	0x5921: "$\t\u5921", // 夡
	0x5922: "$\v\u5922", // 夢
	0x5923: "$\v\u5923", // 夣
	0x5924: "$\v\u5924", // 夤
	0x5925: "$\v\u5925", // 夥
	0x5926: "$\f\u5926", // 夦
	0x5927: "%\x00\u5927", // 大
	0x5928: "%\x00\u5928", // 夨
	0x5929: "%\x01\u5929", // 天
	0x592a: "%\x01\u592a", // 太
	0x592b: "%\x01\u592b", // 夫
	0x592c: "%\x01\u592c", // 夬
	0x592d: "%\x01\u592d", // 夭
	0x592e: "%\x02\u592e", // 央
	0x592f: "%\x02\u592f", // 夯
	0x5930: "%\x02\u5930", // 夰
	0x5931: "%\x02\u5931", // 失
	0x5932: "%\x02\u5932", // 夲
	0x5933: "%\x02\u5933", // 夳
	0x5934: "%\x02\u5934", // 头
	0x5935: "%\x03\u5935", // 夵
	0x5936: "%\x03\u5936", // 夶
	0x5937: "%\x03\u5937", // 夷
	0x5938: "%\x03\u5938", // 夸
	0x5939: "%\x03\u5939", // 夹
	0x593a: "%\x03\u593a", // 夺
	0x593b: "%\x03\u593b", // 夻
	0x593c: "%\x03\u593c", // 夼
	0x593d: "%\x04\u593d", // 夽
	0x593e: "%\x04\u593e", // 夾
	0x593f: "%\x04\u593f", // 夿
	0x5940: "%\x04\u5940", // 奀
	0x5941: "%\x04\u5941", // 奁
	0x5942: "%\x04\u5942", // 奂
	0x5943: "%\x05\u5943", // 奃
	0x5944: "%\x05\u5944", // 奄
	0x5945: "%\x05\u5945", // 奅
	0x5946: "%\x05\u5946", // 奆
	0x5947: "%\x05\u5947", // 奇
	0x5948: "%\x05\u5948", // 奈
	0x5949: "%\x05\u5949", // 奉
	0x594a: "%\a\u594a", // 奊
	0x594b: "%\x05\u594b", // 奋
	0x594c: "%\x05\u594c", // 奌
	0x594d: "%\x05\u594d", // 奍
	0x594e: "%\x06\u594e", // 奎
	0x594f: "%\x06\u594f", // 奏
	0x5950: "%\x06\u5950", // 奐
	0x5951: "%\x06\u5951", // 契
	0x5952: "%\x06\u5952", // 奒
	0x5953: "%\x06\u5953", // 奓
	0x5954: "%\x06\u5954", // 奔
	0x5955: "%\x06\u5955", // 奕
	0x5956: "%\x06\u5956", // 奖
	0x5957: "%\a\u5957", // 套
	0x5958: "%\a\u5958", // 奘
	0x5959: "%\a\u5959", // 奙
	0x595a: "%\a\u595a", // 奚
	0x595b: "%\b\u595b", // 奛
	0x595c: "%\b\u595c", // 奜
	0x595d: "%\b\u595d", // 奝
	0x595e: "%\b\u595e", // 奞
	0x595f: "%\t\u595f", // 奟
	0x5960: "%\t\u5960", // 奠
	0x5961: "%\t\u5961", // 奡
	0x5962: "%\t\u5962", // 奢
	0x5963: "%\t\u5963", // 奣
	0x5964: "%\t\u5964", // 奤
	0x5965: "%\t\u5965", // 奥
	0x5966: "%\n\u5966", // 奦
	0x5967: "%\n\u5967", // 奧
	0x5968: "%\n\u5968", // 奨
	0x5969: "%\v\u5969", // 奩
	0x596a: "%\v\u596a", // 奪
	0x596b: "%\v\u596b", // 奫
	0x596c: "%\v\u596c", // 奬
	0x596d: "%\f\u596d", // 奭
	0x596e: "%\r\u596e", // 奮
	0x596f: "%\r\u596f", // 奯
	0x5970: "%\x0f\u5970", // 奰
	0x5971: "%\x13\u5971", // 奱
	0x5972: "%\x15\u5972", // 奲
	0x5973: "&\x00\u5973", // 女
	0x5974: "&\x02\u5974", // 奴
	0x5975: "&\x02\u5975", // 奵
	0x5976: "&\x02\u5976", // 奶
	0x5977: "&\x03\u5977", // 奷
	0x5978: "&\x03\u5978", // 奸
	0x5979: "&\x03\u5979", // 她
	0x597a: "&\x03\u597a", // 奺
	0x597b: "&\x03\u597b", // 奻
	0x597c: "&\x03\u597c", // 奼
	0x597d: "&\x03\u597d", // 好
	0x597e: "&\x03\u597e", // 奾
	0x597f: "&\x03\u597f", // 奿
	0x5980: "&\x03\u5980", // 妀
	0x5981: "&\x03\u5981", // 妁
	0x5982: "&\x03\u5982", // 如
	0x5983: "&\x03\u5983", // 妃
	0x5984: "&\x03\u5984", // 妄
	0x5985: "&\x03\u5985", // 妅
	0x5986: "&\x03\u5986", // 妆
	0x5987: "&\x03\u5987", // 妇
	0x5988: "&\x03\u5988", // 妈
	0x5989: "&\x04\u5989", // 妉
	0x598a: "&\x04\u598a", // 妊
	0x598b: "&\x04\u598b", // 妋
	0x598c: "&\x04\u598c", // 妌
	0x598d: "&\x06\u598d", // 妍
	0x598e: "&\x04\u598e", // 妎
	0x598f: "&\x04\u598f", // 妏
	0x5990: "&\x04\u5990", // 妐
	0x5991: "&\x04\u5991", // 妑
	0x5992: "&\x04\u5992", // 妒
	0x5993: "&\x04\u5993", // 妓
	0x5994: "&\x04\u5994", // 妔
	0x5995: "&\x04\u5995", // 妕
	0x5996: "&\x04\u5996", // 妖
	0x5997: "&\x04\u5997", // 妗
	0x5998: "&\x04\u5998", // 妘
	0x5999: "&\x04\u5999", // 妙
	0x599a: "&\x04\u599a", // 妚
	0x599b: "&\x04\u599b", // 妛
	0x599c: "&\x04\u599c", // 妜
	0x599d: "&\x04\u599d", // 妝
	0x599e: "&\x04\u599e", // 妞
	0x599f: "&\x04\u599f", // 妟
	0x59a0: "&\x04\u59a0", // 妠
	0x59a1: "&\x04\u59a1", // 妡
	0x59a2: "&\x04\u59a2", // 妢
	0x59a3: "&\x04\u59a3", // 妣
	0x59a4: "&\x04\u59a4", // 妤
	0x59a5: "&\x04\u59a5", // 妥
	0x59a6: "&\x04\u59a6", // 妦
	0x59a7: "&\x04\u59a7", // 妧
	0x59a8: "&\x04\u59a8", // 妨
	0x59a9: "&\x04\u59a9", // 妩
	0x59aa: "&\x04\u59aa", // 妪
	0x59ab: "&\x04\u59ab", // 妫
	0x59ac: "&\x05\u59ac", // 妬
	0x59ad: "&\x05\u59ad", // 妭
	0x59ae: "&\x05\u59ae", // 妮
	0x59af: "&\x05\u59af", // 妯
	0x59b0: "&\x05\u59b0", // 妰
	0x59b1: "&\x05\u59b1", // 妱
	0x59b2: "&\x05\u59b2", // 妲
	0x59b3: "&\x05\u59b3", // 妳
	0x59b4: "&\x05\u59b4", // 妴
	0x59b5: "&\x05\u59b5", // 妵
	0x59b6: "&\x05\u59b6", // 妶
	0x59b7: "&\x05\u59b7", // 妷
	0x59b8: "&\x05\u59b8", // 妸
	0x59b9: "&\x05\u59b9", // 妹
	0x59ba: "&\x05\u59ba", // 妺
	0x59bb: "&\x05\u59bb", // 妻
	0x59bc: "&\x05\u59bc", // 妼
	0x59bd: "&\x05\u59bd", // 妽
	0x59be: "&\x05\u59be", // 妾
	0x59bf: "&\x05\u59bf", // 妿
	0x59c0: "&\x05\u59c0", // 姀
	0x59c1: "&\x05\u59c1", // 姁
	0x59c2: "&\x05\u59c2", // 姂
	0x59c3: "&\x05\u59c3", // 姃
	0x59c4: "&\x05\u59c4", // 姄
	0x59c5: "&\x05\u59c5", // 姅
	0x59c6: "&\x05\u59c6", // 姆
	0x59c7: "&\x05\u59c7", // 姇
	0x59c8: "&\x05\u59c8", // 姈
	0x59c9: "&\x05\u59c9", // 姉
	0x59ca: "&\x05\u59ca", // 姊
	0x59cb: "&\x05\u59cb", // 始
	0x59cc: "&\x05\u59cc", // 姌
	0x59cd: "&\x05\u59cd", // 姍
	0x59ce: "&\x05\u59ce", // 姎
	0x59cf: "&\x05\u59cf", // 姏
	0x59d0: "&\x05\u59d0", // 姐
	0x59d1: "&\x05\u59d1", // 姑
	0x59d2: "&\x05\u59d2", // 姒
	0x59d3: "&\x05\u59d3", // 姓
	0x59d4: "&\x05\u59d4", // 委
	0x59d5: "&\x05\u59d5", // 姕
	0x59d6: "&\x05\u59d6", // 姖
	0x59d7: "&\x05\u59d7", // 姗
	0x59d8: "&\x06\u59d8", // 姘
	0x59d9: "&\x06\u59d9", // 姙
	0x59da: "&\x06\u59da", // 姚
	0x59db: "&\x06\u59db", // 姛
	0x59dc: "&\x06\u59dc", // 姜
	0x59dd: "&\x06\u59dd", // 姝
	0x59de: "&\x06\u59de", // 姞
	0x59df: "&\x06\u59df", // 姟
	0x59e0: "&\x06\u59e0", // 姠
	0x59e1: "&\x06\u59e1", // 姡
	0x59e2: "&\x06\u59e2", // 姢
	0x59e3: "&\x06\u59e3", // 姣
	0x59e4: "&\x06\u59e4", // 姤
	0x59e5: "&\x06\u59e5", // 姥
	0x59e6: "&\x06\u59e6", // 姦
	0x59e7: "&\x06\u59e7", // 姧
	0x59e8: "&\x06\u59e8", // 姨
	0x59e9: "&\x06\u59e9", // 姩
	0x59ea: "&\x06\u59ea", // 姪
	0x59eb: "&\x06\u59eb", // 姫
	0x59ec: "&\a\u59ec", // 姬
	0x59ed: "&\x06\u59ed", // 姭
	0x59ee: "&\x06\u59ee", // 姮
	0x59ef: "&\x06\u59ef", // 姯
	0x59f0: "&\x06\u59f0", // 姰
	0x59f1: "&\x06\u59f1", // 姱
	0x59f2: "&\x06\u59f2", // 姲
	0x59f3: "&\x06\u59f3", // 姳
	0x59f4: "&\x06\u59f4", // 姴
	0x59f5: "&\x06\u59f5", // 姵
	0x59f6: "&\x06\u59f6", // 姶
	0x59f7: "&\x06\u59f7", // 姷
	0x59f8: "&\x06\u59f8", // 姸
	0x59f9: "&\x06\u59f9", // 姹
	0x59fa: "&\x06\u59fa", // 姺
	0x59fb: "&\x06\u59fb", // 姻
	0x59fc: "&\x06\u59fc", // 姼
	0x59fd: "&\x06\u59fd", // 姽
	0x59fe: "&\x06\u59fe", // 姾
	0x59ff: "&\x06\u59ff", // 姿
	0x5a00: "&\x06\u5a00", // 娀
	0x5a01: "&\x06\u5a01", // 威
	0x5a02: "&\x06\u5a02", // 娂
	0x5a03: "&\x06\u5a03", // 娃
	0x5a04: "w\x03\u5a04", // 娄
	0x5a05: "&\x06\u5a05", // 娅
	0x5a06: "&\x06\u5a06", // 娆
	0x5a07: "&\x06\u5a07", // 娇
	0x5a08: "&\x06\u5a08", // 娈
	0x5a09: "&\a\u5a09", // 娉
	0x5a0a: "&\a\u5a0a", // 娊
	0x5a0b: "&\a\u5a0b", // 娋
	0x5a0c: "&\a\u5a0c", // 娌
	0x5a0d: "&\a\u5a0d", // 娍
	0x5a0e: "&\a\u5a0e", // 娎
	0x5a0f: "&\a\u5a0f", // 娏
	0x5a10: "&\a\u5a10", // 娐
	0x5a11: "&\a\u5a11", // 娑
	0x5a12: "&\a\u5a12", // 娒
	0x5a13: "&\a\u5a13", // 娓
	0x5a14: "&\a\u5a14", // 娔
	0x5a15: "&\a\u5a15", // 娕
	0x5a16: "&\a\u5a16", // 娖
	0x5a17: "&\a\u5a17", // 娗
	0x5a18: "&\a\u5a18", // 娘
	0x5a19: "&\a\u5a19", // 娙
	0x5a1a: "&\a\u5a1a", // 娚
	0x5a1b: "&\a\u5a1b", // 娛
	0x5a1c: "&\a\u5a1c", // 娜
	0x5a1d: "&\a\u5a1d", // 娝
	0x5a1e: "&\a\u5a1e", // 娞
	0x5a1f: "&\a\u5a1f", // 娟
	0x5a20: "&\a\u5a20", // 娠
	0x5a21: "&\a\u5a21", // 娡
	0x5a22: "&\a\u5a22", // 娢
	0x5a23: "&\a\u5a23", // 娣
	0x5a24: "&\a\u5a24", // 娤
	0x5a25: "&\a\u5a25", // 娥
	0x5a26: "&\a\u5a26", // 娦
	0x5a27: "&\a\u5a27", // 娧
	0x5a28: "&\a\u5a28", // 娨
	0x5a29: "&\a\u5a29", // 娩
	0x5a2a: "&\a\u5a2a", // 娪
	0x5a2b: "&\a\u5a2b", // 娫
	0x5a2c: "&\b\u5a2c", // 娬
	0x5a2d: "&\a\u5a2d", // 娭
	0x5a2e: "&\a\u5a2e", // 娮
	0x5a2f: "&\a\u5a2f", // 娯
	0x5a30: "&\a\u5a30", // 娰
	0x5a31: "&\a\u5a31", // 娱
	0x5a32: "&\a\u5a32", // 娲
	0x5a33: "&\a\u5a33", // 娳
	0x5a34: "&\a\u5a34", // 娴
	0x5a35: "&\b\u5a35", // 娵
	0x5a36: "&\b\u5a36", // 娶
	0x5a37: "&\b\u5a37", // 娷
	0x5a38: "&\b\u5a38", // 娸
	0x5a39: "&\b\u5a39", // 娹
	0x5a3a: "&\b\u5a3a", // 娺
	0x5a3b: "&\b\u5a3b", // 娻
	0x5a3c: "&\b\u5a3c", // 娼
	0x5a3d: "&\a\u5a3d", // 娽
	0x5a3e: "&\b\u5a3e", // 娾
	0x5a3f: "&\b\u5a3f", // 娿
	0x5a40: "&\b\u5a40", // 婀
	0x5a41: "&\b\u5a41", // 婁
	0x5a42: "&\b\u5a42", // 婂
	0x5a43: "&\b\u5a43", // 婃
	0x5a44: "&\b\u5a44", // 婄
	0x5a45: "&\b\u5a45", // 婅
	0x5a46: "&\b\u5a46", // 婆
	0x5a47: "&\b\u5a47", // 婇
	0x5a48: "&\b\u5a48", // 婈
	0x5a49: "&\b\u5a49", // 婉
	0x5a4a: "&\b\u5a4a", // 婊
	0x5a4b: "&\b\u5a4b", // 婋
	0x5a4c: "&\b\u5a4c", // 婌
	0x5a4d: "&\b\u5a4d", // 婍
	0x5a4e: "&\b\u5a4e", // 婎
	0x5a4f: "&\b\u5a4f", // 婏
	0x5a50: "&\b\u5a50", // 婐
	0x5a51: "&\b\u5a51", // 婑
	0x5a52: "&\b\u5a52", // 婒
	0x5a53: "&\b\u5a53", // 婓
	0x5a54: "&\b\u5a54", // 婔
	0x5a55: "&\b\u5a55", // 婕
	0x5a56: "&\b\u5a56", // 婖
	0x5a57: "&\b\u5a57", // 婗
	0x5a58: "&\b\u5a58", // 婘
	0x5a59: "&\b\u5a59", // 婙
	0x5a5a: "&\b\u5a5a", // 婚
	0x5a5b: "&\b\u5a5b", // 婛
	0x5a5c: "&\b\u5a5c", // 婜
	0x5a5d: "&\b\u5a5d", // 婝
	0x5a5e: "&\b\u5a5e", // 婞
	0x5a5f: "&\b\u5a5f", // 婟
	0x5a60: "&\b\u5a60", // 婠
	0x5a61: "&\b\u5a61", // 婡
	0x5a62: "&\b\u5a62", // 婢
	0x5a63: "&\b\u5a63", // 婣
	0x5a64: "&\b\u5a64", // 婤
	0x5a65: "&\b\u5a65", // 婥
	0x5a66: "&\b\u5a66", // 婦
	0x5a67: "&\b\u5a67", // 婧
	0x5a68: "&\b\u5a68", // 婨
	0x5a69: "&\b\u5a69", // 婩
	0x5a6a: "&\b\u5a6a", // 婪
	0x5a6b: "&\b\u5a6b", // 婫
	0x5a6c: "&\b\u5a6c", // 婬
	0x5a6d: "&\b\u5a6d", // 婭
	0x5a6e: "&\b\u5a6e", // 婮
	0x5a6f: "&\b\u5a6f", // 婯
	0x5a70: "&\b\u5a70", // 婰
	0x5a71: "&\b\u5a71", // 婱
	0x5a72: "&\b\u5a72", // 婲
	0x5a73: "&\b\u5a73", // 婳
	0x5a74: "&\b\u5a74", // 婴
	0x5a75: "&\b\u5a75", // 婵
	0x5a76: "&\b\u5a76", // 婶
	0x5a77: "&\t\u5a77", // 婷
	0x5a78: "&\t\u5a78", // 婸
	0x5a79: "&\t\u5a79", // 婹
	0x5a7a: "&\t\u5a7a", // 婺
	0x5a7b: "&\t\u5a7b", // 婻
	0x5a7c: "&\t\u5a7c", // 婼
	0x5a7d: "&\t\u5a7d", // 婽
	0x5a7e: "&\t\u5a7e", // 婾
	0x5a7f: "&\t\u5a7f", // 婿
	0x5a80: "&\t\u5a80", // 媀
	0x5a81: "&\t\u5a81", // 媁
	0x5a82: "&\t\u5a82", // 媂
	0x5a83: "&\t\u5a83", // 媃
	0x5a84: "&\t\u5a84", // 媄
	0x5a85: "&\t\u5a85", // 媅
	0x5a86: "&\t\u5a86", // 媆
	0x5a87: "&\t\u5a87", // 媇
	0x5a88: "&\t\u5a88", // 媈
	0x5a89: "&\t\u5a89", // 媉
	0x5a8a: "&\t\u5a8a", // 媊
	0x5a8b: "&\t\u5a8b", // 媋
	0x5a8c: "&\t\u5a8c", // 媌
	0x5a8d: "&\t\u5a8d", // 媍
	0x5a8e: "&\t\u5a8e", // 媎
	0x5a8f: "&\t\u5a8f", // 媏
	0x5a90: "&\n\u5a90", // 媐
	0x5a91: "&\t\u5a91", // 媑
	0x5a92: "&\t\u5a92", // 媒
	0x5a93: "&\t\u5a93", // 媓
	0x5a94: "&\t\u5a94", // 媔
	0x5a95: "&\t\u5a95", // 媕
	0x5a96: "&\t\u5a96", // 媖
	0x5a97: "&\t\u5a97", // 媗
	0x5a98: "&\t\u5a98", // 媘
	0x5a99: "&\t\u5a99", // 媙
	0x5a9a: "&\t\u5a9a", // 媚
	0x5a9b: "&\t\u5a9b", // 媛
	0x5a9c: "&\t\u5a9c", // 媜
	0x5a9d: "&\t\u5a9d", // 媝
	0x5a9e: "&\t\u5a9e", // 媞
	0x5a9f: "&\t\u5a9f", // 媟
	0x5aa0: "&\t\u5aa0", // 媠
	0x5aa1: "&\t\u5aa1", // 媡
	0x5aa2: "&\t\u5aa2", // 媢
	0x5aa3: "&\t\u5aa3", // 媣
	0x5aa4: "&\t\u5aa4", // 媤
	0x5aa5: "&\t\u5aa5", // 媥
	0x5aa6: "&\t\u5aa6", // 媦
	0x5aa7: "&\t\u5aa7", // 媧
	0x5aa8: "&\t\u5aa8", // 媨
	0x5aa9: "&\t\u5aa9", // 媩
	0x5aaa: "&\t\u5aaa", // 媪
	0x5aab: "&\t\u5aab", // 媫
	0x5aac: "&\t\u5aac", // 媬
	0x5aad: "&\t\u5aad", // 媭
	0x5aae: "&\t\u5aae", // 媮
	0x5aaf: "&\t\u5aaf", // 媯
	0x5ab0: "&\n\u5ab0", // 媰
	0x5ab1: "&\n\u5ab1", // 媱
	0x5ab2: "&\n\u5ab2", // 媲
	0x5ab3: "&\n\u5ab3", // 媳
	0x5ab4: "&\n\u5ab4", // 媴
	0x5ab5: "&\n\u5ab5", // 媵
	0x5ab6: "&\n\u5ab6", // 媶
	0x5ab7: "&\n\u5ab7", // 媷
	0x5ab8: "&\n\u5ab8", // 媸
	0x5ab9: "&\n\u5ab9", // 媹
	0x5aba: "&\n\u5aba", // 媺
	0x5abb: "&\n\u5abb", // 媻
	0x5abc: "&\n\u5abc", // 媼
	0x5abd: "&\n\u5abd", // 媽
	0x5abe: "&\n\u5abe", // 媾
	0x5abf: "&\n\u5abf", // 媿
	0x5ac0: "&\n\u5ac0", // 嫀
	0x5ac1: "&\n\u5ac1", // 嫁
	0x5ac2: "&\n\u5ac2", // 嫂
	0x5ac3: "&\n\u5ac3", // 嫃
	0x5ac4: "&\n\u5ac4", // 嫄
	0x5ac5: "&\n\u5ac5", // 嫅
	0x5ac6: "&\n\u5ac6", // 嫆
	0x5ac7: "&\n\u5ac7", // 嫇
	0x5ac8: "&\n\u5ac8", // 嫈
	0x5ac9: "&\n\u5ac9", // 嫉
	0x5aca: "&\n\u5aca", // 嫊
	0x5acb: "&\n\u5acb", // 嫋
	0x5acc: "&\n\u5acc", // 嫌
	0x5acd: "&\n\u5acd", // 嫍
	0x5ace: "&\n\u5ace", // 嫎
	0x5acf: "&\t\u5acf", // 嫏
	0x5ad0: "&\n\u5ad0", // 嫐
	0x5ad1: "&\n\u5ad1", // 嫑
	0x5ad2: "&\n\u5ad2", // 嫒
	0x5ad3: "&\n\u5ad3", // 嫓
	0x5ad4: "&\n\u5ad4", // 嫔
	0x5ad5: "&\v\u5ad5", // 嫕
	0x5ad6: "&\v\u5ad6", // 嫖
	0x5ad7: "&\v\u5ad7", // 嫗
	0x5ad8: "&\v\u5ad8", // 嫘
	0x5ad9: "&\v\u5ad9", // 嫙
	0x5ada: "&\v\u5ada", // 嫚
	0x5adb: "&\v\u5adb", // 嫛
	0x5adc: "&\v\u5adc", // 嫜
	0x5add: "&\v\u5add", // 嫝
	0x5ade: "&\v\u5ade", // 嫞
	0x5adf: "&\v\u5adf", // 嫟
	0x5ae0: "&\v\u5ae0", // 嫠
	0x5ae1: "&\v\u5ae1", // 嫡
	0x5ae2: "&\v\u5ae2", // 嫢
	0x5ae3: "&\v\u5ae3", // 嫣
	0x5ae4: "&\v\u5ae4", // 嫤
	0x5ae5: "&\v\u5ae5", // 嫥
	0x5ae6: "&\v\u5ae6", // 嫦
	0x5ae7: "&\v\u5ae7", // 嫧
	0x5ae8: "&\v\u5ae8", // 嫨
	0x5ae9: "&\v\u5ae9", // 嫩
	0x5aea: "&\v\u5aea", // 嫪
	0x5aeb: "&\v\u5aeb", // 嫫
	0x5aec: "&\v\u5aec", // 嫬
	0x5aed: "&\v\u5aed", // 嫭
	0x5aee: "&\v\u5aee", // 嫮
	0x5aef: "&\v\u5aef", // 嫯
	0x5af0: "&\v\u5af0", // 嫰
	0x5af1: "&\v\u5af1", // 嫱
	0x5af2: "&\v\u5af2", // 嫲
	0x5af3: "&\f\u5af3", // 嫳
	0x5af4: "&\f\u5af4", // 嫴
	0x5af5: "&\f\u5af5", // 嫵
	0x5af6: "&\f\u5af6", // 嫶
	0x5af7: "&\f\u5af7", // 嫷
	0x5af8: "&\f\u5af8", // 嫸
	0x5af9: "&\f\u5af9", // 嫹
	0x5afa: "&\f\u5afa", // 嫺
	0x5afb: "&\f\u5afb", // 嫻
	0x5afc: "&\f\u5afc", // 嫼
	0x5afd: "&\f\u5afd", // 嫽
	0x5afe: "&\f\u5afe", // 嫾
	0x5aff: "&\f\u5aff", // 嫿
	0x5b00: "&\f\u5b00", // 嬀
	0x5b01: "&\f\u5b01", // 嬁
	0x5b02: "&\f\u5b02", // 嬂
	0x5b03: "&\f\u5b03", // 嬃
	0x5b04: "&\f\u5b04", // 嬄
	0x5b05: "&\f\u5b05", // 嬅
	0x5b06: "&\f\u5b06", // 嬆
	0x5b07: "&\f\u5b07", // 嬇
	0x5b08: "&\f\u5b08", // 嬈
	0x5b09: "&\f\u5b09", // 嬉
	0x5b0a: "&\f\u5b0a", // 嬊
	0x5b0b: "&\f\u5b0b", // 嬋
	0x5b0c: "&\f\u5b0c", // 嬌
	0x5b0d: "&\f\u5b0d", // 嬍
	0x5b0e: "&\f\u5b0e", // 嬎
	0x5b0f: "&\f\u5b0f", // 嬏
	0x5b10: "&\r\u5b10", // 嬐
	0x5b11: "&\r\u5b11", // 嬑
	0x5b12: "&\r\u5b12", // 嬒
	0x5b13: "&\r\u5b13", // 嬓
	0x5b14: "&\r\u5b14", // 嬔
	0x5b15: "&\r\u5b15", // 嬕
	0x5b16: "&\r\u5b16", // 嬖
	0x5b17: "&\r\u5b17", // 嬗
	0x5b18: "&\r\u5b18", // 嬘
	0x5b19: "&\r\u5b19", // 嬙
	0x5b1a: "&\r\u5b1a", // 嬚
	0x5b1b: "&\r\u5b1b", // 嬛
	0x5b1c: "&\r\u5b1c", // 嬜
	0x5b1d: "&\r\u5b1d", // 嬝
	0x5b1e: "&\r\u5b1e", // 嬞
	0x5b1f: "&\r\u5b1f", // 嬟
	0x5b20: "&\r\u5b20", // 嬠
	0x5b21: "&\r\u5b21", // 嬡
	0x5b22: "&\r\u5b22", // 嬢
	0x5b23: "&\x0e\u5b23", // 嬣
	0x5b24: "&\x0e\u5b24", // 嬤
	0x5b25: "&\x0e\u5b25", // 嬥
	0x5b26: "&\x0e\u5b26", // 嬦
	0x5b27: "&\x0e\u5b27", // 嬧
	0x5b28: "&\x0e\u5b28", // 嬨
	0x5b29: "&\x0e\u5b29", // 嬩
	0x5b2a: "&\x0e\u5b2a", // 嬪
	0x5b2b: "&\x0e\u5b2b", // 嬫
	0x5b2c: "&\x0e\u5b2c", // 嬬
	0x5b2d: "&\x0e\u5b2d", // 嬭
	0x5b2e: "&\x0e\u5b2e", // 嬮
	0x5b2f: "&\x0e\u5b2f", // 嬯
	0x5b30: "&\x0e\u5b30", // 嬰
	0x5b31: "&\x0e\u5b31", // 嬱
	0x5b32: "&\x0e\u5b32", // 嬲
	0x5b33: "&\x0e\u5b33", // 嬳
	0x5b34: "&\r\u5b34", // 嬴
	0x5b35: "&\x0e\u5b35", // 嬵
	0x5b36: "&\x0e\u5b36", // 嬶
	0x5b37: "&\x0e\u5b37", // 嬷
	0x5b38: "&\x0f\u5b38", // 嬸
	0x5b39: "&\x10\u5b39", // 嬹
	0x5b3a: "&\x0f\u5b3a", // 嬺
	0x5b3b: "&\x0f\u5b3b", // 嬻
	0x5b3c: "&\x0f\u5b3c", // 嬼
	0x5b3d: "&\x0f\u5b3d", // 嬽
	0x5b3e: "&\x10\u5b3e", // 嬾
	0x5b3f: "&\x10\u5b3f", // 嬿
	0x5b40: "&\x11\u5b40", // 孀
	0x5b41: "&\x11\u5b41", // 孁
	0x5b42: "&\x11\u5b42", // 孂
	0x5b43: "&\x11\u5b43", // 孃
	0x5b44: "&\x11\u5b44", // 孄
	0x5b45: "&\x11\u5b45", // 孅
	0x5b46: "&\x11\u5b46", // 孆
	0x5b47: "&\x12\u5b47", // 孇
	0x5b48: "&\x12\u5b48", // 孈
	0x5b49: "&\x12\u5b49", // 孉
	0x5b4a: "&\x13\u5b4a", // 孊
	0x5b4b: "&\x13\u5b4b", // 孋
	0x5b4c: "&\x13\u5b4c", // 孌
	0x5b4d: "&\x14\u5b4d", // 孍
	0x5b4e: "&\x15\u5b4e", // 孎
	0x5b4f: "&\x15\u5b4f", // 孏
	0x5b50: "'\x00\u5b50", // 子
	0x5b51: "'\x00\u5b51", // 孑
	0x5b52: "'\x00\u5b52", // 孒
	0x5b53: "'\x00\u5b53", // 孓
	0x5b54: "'\x01\u5b54", // 孔
	0x5b55: "'\x02\u5b55", // 孕
	0x5b56: "'\x03\u5b56", // 孖
	0x5b57: "'\x03\u5b57", // 字
	0x5b58: "'\x03\u5b58", // 存
	0x5b59: "'\x03\u5b59", // 孙
	0x5b5a: "'\x04\u5b5a", // 孚
	0x5b5b: "'\x04\u5b5b", // 孛
	0x5b5c: "'\x04\u5b5c", // 孜
	0x5b5d: "'\x04\u5b5d", // 孝
	0x5b5e: "'\x04\u5b5e", // 孞
	0x5b5f: "'\x05\u5b5f", // 孟
	0x5b60: "'\x05\u5b60", // 孠
	0x5b61: "'\x05\u5b61", // 孡
	0x5b62: "'\x05\u5b62", // 孢
	0x5b63: "'\x05\u5b63", // 季
	0x5b64: "'\x05\u5b64", // 孤
	0x5b65: "'\x05\u5b65", // 孥
	0x5b66: "'\x05\u5b66", // 学
	0x5b67: "'\x05\u5b67", // 孧
	0x5b68: "'\x06\u5b68", // 孨
	0x5b69: "'\x06\u5b69", // 孩
	0x5b6a: "'\x06\u5b6a", // 孪
	0x5b6b: "'\a\u5b6b", // 孫
	0x5b6c: "'\a\u5b6c", // 孬
	0x5b6d: "'\a\u5b6d", // 孭
	0x5b6e: "'\b\u5b6e", // 孮
	0x5b6f: "'\b\u5b6f", // 孯
	0x5b70: "'\b\u5b70", // 孰
	0x5b71: "'\t\u5b71", // 孱
	0x5b72: "'\b\u5b72", // 孲
	0x5b73: "'\n\u5b73", // 孳
	0x5b74: "'\n\u5b74", // 孴
	0x5b75: "'\v\u5b75", // 孵
	0x5b76: "'\v\u5b76", // 孶
	0x5b77: "'\v\u5b77", // 孷
	0x5b78: "'\r\u5b78", // 學
	0x5b79: "'\r\u5b79", // 孹
	0x5b7a: "'\x0e\u5b7a", // 孺
	0x5b7b: "'\x0e\u5b7b", // 孻
	0x5b7c: "'\x10\u5b7c", // 孼
	0x5b7d: "'\x11\u5b7d", // 孽
	0x5b7e: "'\x11\u5b7e", // 孾
	0x5b7f: "'\x13\u5b7f", // 孿
	0x5b80: "(\x00\u5b80", // 宀
	0x5b81: "(\x02\u5b81", // 宁
	0x5b82: "(\x02\u5b82", // 宂
	0x5b83: "(\x02\u5b83", // 它
	0x5b84: "(\x02\u5b84", // 宄
	0x5b85: "(\x03\u5b85", // 宅
	0x5b86: "(\x03\u5b86", // 宆
	0x5b87: "(\x03\u5b87", // 宇
	0x5b88: "(\x03\u5b88", // 守
	0x5b89: "(\x03\u5b89", // 安
	0x5b8a: "(\x04\u5b8a", // 宊
	0x5b8b: "(\x04\u5b8b", // 宋
	0x5b8c: "(\x04\u5b8c", // 完
	0x5b8d: "(\x04\u5b8d", // 宍
	0x5b8e: "(\x04\u5b8e", // 宎
	0x5b8f: "(\x04\u5b8f", // 宏
	0x5b90: "(\x04\u5b90", // 宐
	0x5b91: "(\x04\u5b91", // 宑
	0x5b92: "(\x04\u5b92", // 宒
	0x5b93: "(\x05\u5b93", // 宓
	0x5b94: "(\x05\u5b94", // 宔
	0x5b95: "(\x05\u5b95", // 宕
	0x5b96: "(\x05\u5b96", // 宖
	0x5b97: "(\x05\u5b97", // 宗
	0x5b98: "(\x05\u5b98", // 官
	0x5b99: "(\x05\u5b99", // 宙
	0x5b9a: "(\x05\u5b9a", // 定
	0x5b9b: "(\x05\u5b9b", // 宛
	0x5b9c: "(\x05\u5b9c", // 宜
	0x5b9d: "(\x05\u5b9d", // 宝
	0x5b9e: "(\x05\u5b9e", // 实
	0x5b9f: "(\x05\u5b9f", // 実
	0x5ba0: "(\x05\u5ba0", // 宠
	0x5ba1: "(\x05\u5ba1", // 审
	0x5ba2: "(\x06\u5ba2", // 客
	0x5ba3: "(\x06\u5ba3", // 宣
	0x5ba4: "(\x06\u5ba4", // 室
	0x5ba5: "(\x06\u5ba5", // 宥
	0x5ba6: "(\x06\u5ba6", // 宦
	0x5ba7: "(\a\u5ba7", // 宧
	0x5ba8: "(\x06\u5ba8", // 宨
	0x5ba9: "(\x06\u5ba9", // 宩
	0x5baa: "(\x06\u5baa", // 宪
	0x5bab: "(\x06\u5bab", // 宫
	0x5bac: "(\a\u5bac", // 宬
	0x5bad: "(\a\u5bad", // 宭
	0x5bae: "(\a\u5bae", // 宮
	0x5baf: "(\a\u5baf", // 宯
	0x5bb0: "(\a\u5bb0", // 宰
	0x5bb1: "(\a\u5bb1", // 宱
	0x5bb2: "(\a\u5bb2", // 宲
	0x5bb3: "(\a\u5bb3", // 害
	0x5bb4: "(\a\u5bb4", // 宴
	0x5bb5: "(\a\u5bb5", // 宵
	0x5bb6: "(\a\u5bb6", // 家
	0x5bb7: "(\a\u5bb7", // 宷
	0x5bb8: "(\a\u5bb8", // 宸
	0x5bb9: "(\a\u5bb9", // 容
	0x5bba: "(\a\u5bba", // 宺
	0x5bbb: "(\a\u5bbb", // 宻
	0x5bbc: "(\a\u5bbc", // 宼
	0x5bbd: "(\a\u5bbd", // 宽
	0x5bbe: "(\a\u5bbe", // 宾
	0x5bbf: "(\b\u5bbf", // 宿
	0x5bc0: "(\b\u5bc0", // 寀
	0x5bc1: "(\b\u5bc1", // 寁
	0x5bc2: "(\b\u5bc2", // 寂
	0x5bc3: "(\b\u5bc3", // 寃
	0x5bc4: "(\b\u5bc4", // 寄
	0x5bc5: "(\b\u5bc5", // 寅
	0x5bc6: "(\b\u5bc6", // 密
	0x5bc7: "(\b\u5bc7", // 寇
	0x5bc8: "(\b\u5bc8", // 寈
	0x5bc9: "(\b\u5bc9", // 寉
	0x5bca: "(\t\u5bca", // 寊
	0x5bcb: "(\t\u5bcb", // 寋
	0x5bcc: "(\t\u5bcc", // 富
	0x5bcd: "(\t\u5bcd", // 寍
	0x5bce: "(\t\u5bce", // 寎
	0x5bcf: "(\t\u5bcf", // 寏
	0x5bd0: "(\t\u5bd0", // 寐
	0x5bd1: "(\t\u5bd1", // 寑
	0x5bd2: "(\t\u5bd2", // 寒
	0x5bd3: "(\t\u5bd3", // 寓
	0x5bd4: "(\t\u5bd4", // 寔
	0x5bd5: "(\t\u5bd5", // 寕
	0x5bd6: "(\n\u5bd6", // 寖
	0x5bd7: "(\n\u5bd7", // 寗
	0x5bd8: "(\n\u5bd8", // 寘
	0x5bd9: "(\n\u5bd9", // 寙
	0x5bda: "(\n\u5bda", // 寚
	0x5bdb: "(\n\u5bdb", // 寛
	0x5bdc: "(\n\u5bdc", // 寜
	0x5bdd: "(\n\u5bdd", // 寝
	0x5bde: "(\v\u5bde", // 寞
	0x5bdf: "(\v\u5bdf", // 察
	0x5be0: "(\v\u5be0", // 寠
	0x5be1: "(\v\u5be1", // 寡
	0x5be2: "(\v\u5be2", // 寢
	0x5be3: "(\v\u5be3", // 寣
	0x5be4: "(\v\u5be4", // 寤
	0x5be5: "(\v\u5be5", // 寥
	0x5be6: "(\v\u5be6", // 實
	0x5be7: "(\v\u5be7", // 寧
	0x5be8: "(\v\u5be8", // 寨
	0x5be9: "(\f\u5be9", // 審
	0x5bea: "(\t\u5bea", // 寪
	0x5beb: "(\f\u5beb", // 寫
	0x5bec: "(\f\u5bec", // 寬
	0x5bed: "(\f\u5bed", // 寭
	0x5bee: "(\f\u5bee", // 寮
	0x5bef: "(\r\u5bef", // 寯
	0x5bf0: "(\r\u5bf0", // 寰
	0x5bf1: "(\x0e\u5bf1", // 寱
	0x5bf2: "(\x0e\u5bf2", // 寲
	0x5bf3: "(\x10\u5bf3", // 寳
	0x5bf4: "(\x10\u5bf4", // 寴
	0x5bf5: "(\x10\u5bf5", // 寵
	0x5bf6: "(\x11\u5bf6", // 寶
	0x5bf7: "(\x12\u5bf7", // 寷
	0x5bf8: ")\x00\u5bf8", // 寸
	0x5bf9: ")\x02\u5bf9", // 对
	0x5bfa: ")\x03\u5bfa", // 寺
	0x5bfb: ")\x03\u5bfb", // 寻
	0x5bfc: ")\x03\u5bfc", // 导
	0x5bfd: ")\x04\u5bfd", // 寽
	0x5bfe: ")\x04\u5bfe", // 対
	0x5bff: ")\x04\u5bff", // 寿
	0x5c00: ")\x05\u5c00", // 尀
	0x5c01: ")\x06\u5c01", // 封
	0x5c02: ")\x06\u5c02", // 専
	0x5c03: ")\a\u5c03", // 尃
	0x5c04: ")\a\u5c04", // 射
	0x5c05: ")\a\u5c05", // 尅
	0x5c06: ")\x06\u5c06", // 将
	0x5c07: ")\b\u5c07", // 將
	0x5c08: ")\b\u5c08", // 專
	0x5c09: ")\b\u5c09", // 尉
	0x5c0a: ")\t\u5c0a", // 尊
	0x5c0b: ")\t\u5c0b", // 尋
	0x5c0c: ")\t\u5c0c", // 尌
	0x5c0d: ")\v\u5c0d", // 對
	0x5c0e: ")\f\u5c0e", // 導
	0x5c0f: "*\x00\u5c0f", // 小
	0x5c10: "*\x01\u5c10", // 尐
	0x5c11: "*\x01\u5c11", // 少
	0x5c12: "*\x02\u5c12", // 尒
	0x5c13: "*\x02\u5c13", // 尓
	0x5c14: "*\x02\u5c14", // 尔
	0x5c15: "*\x02\u5c15", // 尕
	0x5c16: "*\x03\u5c16", // 尖
	0x5c17: "*\x03\u5c17", // 尗
	0x5c18: "*\x03\u5c18", // 尘
	0x5c19: "*\x05\u5c19", // 尙
	0x5c1a: "*\x05\u5c1a", // 尚
	0x5c1b: "*\x06\u5c1b", // 尛
	0x5c1c: "*\x06\u5c1c", // 尜
	0x5c1d: "*\x06\u5c1d", // 尝
	0x5c1e: "*\t\u5c1e", // 尞
	0x5c1f: "*\n\u5c1f", // 尟
	0x5c20: "*\n\u5c20", // 尠
	0x5c21: "*\v\u5c21", // 尡
	0x5c22: "+\x00\u5c22", // 尢
	0x5c23: "+\x00\u5c23", // 尣
	0x5c24: "+\x01\u5c24", // 尤
	0x5c25: "+\x03\u5c25", // 尥
	0x5c26: "+\x03\u5c26", // 尦
	0x5c27: "+\x03\u5c27", // 尧
	0x5c28: "+\x04\u5c28", // 尨
	0x5c29: "+\x04\u5c29", // 尩
	0x5c2a: "+\x04\u5c2a", // 尪
	0x5c2b: "+\x04\u5c2b", // 尫
	0x5c2c: "+\x04\u5c2c", // 尬
	0x5c2d: "+\x05\u5c2d", // 尭
	0x5c2e: "+\x06\u5c2e", // 尮
	0x5c2f: "+\x06\u5c2f", // 尯
	0x5c30: "+\t\u5c30", // 尰
	0x5c31: "+\t\u5c31", // 就
	0x5c32: "+\n\u5c32", // 尲
	0x5c33: "+\n\u5c33", // 尳
	0x5c34: "+\n\u5c34", // 尴
	0x5c35: "+\f\u5c35", // 尵
	0x5c36: "+\x0e\u5c36", // 尶
	0x5c37: "+\x0e\u5c37", // 尷
	0x5c38: ",\x00\u5c38", // 尸
	0x5c39: "\x04\x03\u5c39", // 尹
	0x5c3a: ",\x01\u5c3a", // 尺
	0x5c3b: ",\x02\u5c3b", // 尻
	0x5c3c: ",\x02\u5c3c", // 尼
	0x5c3d: ",\x03\u5c3d", // 尽
	0x5c3e: ",\x04\u5c3e", // 尾
	0x5c3f: ",\x04\u5c3f", // 尿
	0x5c40: ",\x04\u5c40", // 局
	0x5c41: ",\x04\u5c41", // 屁
	0x5c42: ",\x04\u5c42", // 层
	0x5c43: ",\x04\u5c43", // 屃
	0x5c44: ",\x05\u5c44", // 屄
	0x5c45: ",\x05\u5c45", // 居
	0x5c46: ",\x05\u5c46", // 屆
	0x5c47: ",\x05\u5c47", // 屇
	0x5c48: ",\x05\u5c48", // 屈
	0x5c49: ",\x05\u5c49", // 屉
	0x5c4a: ",\x05\u5c4a", // 届
	0x5c4b: ",\x06\u5c4b", // 屋
	0x5c4c: ",\x06\u5c4c", // 屌
	0x5c4d: ",\x06\u5c4d", // 屍
	0x5c4e: ",\x06\u5c4e", // 屎
	0x5c4f: ",\x06\u5c4f", // 屏
	0x5c50: ",\a\u5c50", // 屐
	0x5c51: ",\a\u5c51", // 屑
	0x5c52: ",\a\u5c52", // 屒
	0x5c53: ",\a\u5c53", // 屓
	0x5c54: ",\a\u5c54", // 屔
	0x5c55: ",\a\u5c55", // 展
	0x5c56: ",\a\u5c56", // 屖
	0x5c57: ",\a\u5c57", // 屗
	0x5c58: ",\a\u5c58", // 屘
	0x5c59: ",\b\u5c59", // 屙
	0x5c5a: ",\b\u5c5a", // 屚
	0x5c5b: ",\b\u5c5b", // 屛
	0x5c5c: ",\b\u5c5c", // 屜
	0x5c5d: ",\b\u5c5d", // 屝
	0x5c5e: ",\t\u5c5e", // 属
	0x5c5f: ",\t\u5c5f", // 屟
	0x5c60: ",\t\u5c60", // 屠
	0x5c61: ",\t\u5c61", // 屡
	0x5c62: ",\v\u5c62", // 屢
	0x5c63: ",\v\u5c63", // 屣
	0x5c64: ",\f\u5c64", // 層
	0x5c65: ",\f\u5c65", // 履
	0x5c66: ",\f\u5c66", // 屦
	0x5c67: ",\f\u5c67", // 屧
	0x5c68: ",\x0e\u5c68", // 屨
	0x5c69: ",\x0f\u5c69", // 屩
	0x5c6a: ",\x0f\u5c6a", // 屪
	0x5c6b: ",\x10\u5c6b", // 屫
	0x5c6c: ",\x12\u5c6c", // 屬
	0x5c6d: ",\x15\u5c6d", // 屭
	0x5c6e: "-\x00\u5c6e", // 屮
	0x5c6f: "-\x01\u5c6f", // 屯
	0x5c70: "-\x03\u5c70", // 屰
	0x5c71: ".\x00\u5c71", // 山
	0x5c72: ".\x01\u5c72", // 屲
	0x5c73: ".\x02\u5c73", // 屳
	0x5c74: ".\x02\u5c74", // 屴
	0x5c75: ".\x02\u5c75", // 屵
	0x5c76: ".\x02\u5c76", // 屶
	0x5c77: ".\x02\u5c77", // 屷
	0x5c78: ".\x03\u5c78", // 屸
	0x5c79: ".\x03\u5c79", // 屹
	0x5c7a: ".\x03\u5c7a", // 屺
	0x5c7b: ".\x03\u5c7b", // 屻
	0x5c7c: ".\x03\u5c7c", // 屼
	0x5c7d: ".\x03\u5c7d", // 屽
	0x5c7e: ".\x03\u5c7e", // 屾
	0x5c7f: ".\x03\u5c7f", // 屿
	0x5c80: ".\x03\u5c80", // 岀
	0x5c81: ".\x03\u5c81", // 岁
	0x5c82: ".\x03\u5c82", // 岂
	0x5c83: ".\x03\u5c83", // 岃
	0x5c84: ".\x04\u5c84", // 岄
	0x5c85: ".\x04\u5c85", // 岅
	0x5c86: ".\x04\u5c86", // 岆
	0x5c87: ".\x04\u5c87", // 岇
	0x5c88: ".\x04\u5c88", // 岈
	0x5c89: ".\x04\u5c89", // 岉
	0x5c8a: ".\x04\u5c8a", // 岊
	0x5c8b: ".\x04\u5c8b", // 岋
	0x5c8c: ".\x04\u5c8c", // 岌
	0x5c8d: ".\x06\u5c8d", // 岍
	0x5c8e: ".\x04\u5c8e", // 岎
	0x5c8f: ".\x04\u5c8f", // 岏
	0x5c90: ".\x04\u5c90", // 岐
	0x5c91: ".\x04\u5c91", // 岑
	0x5c92: ".\x04\u5c92", // 岒
	0x5c93: ".\x04\u5c93", // 岓
	0x5c94: ".\x04\u5c94", // 岔
	0x5c95: ".\x04\u5c95", // 岕
	0x5c96: ".\x04\u5c96", // 岖
	0x5c97: ".\x04\u5c97", // 岗
	0x5c98: ".\x04\u5c98", // 岘
	0x5c99: ".\x04\u5c99", // 岙
	0x5c9a: ".\x04\u5c9a", // 岚
	0x5c9b: ".\x04\u5c9b", // 岛
	0x5c9c: ".\x04\u5c9c", // 岜
	0x5c9d: ".\x05\u5c9d", // 岝
	0x5c9e: ".\x05\u5c9e", // 岞
	0x5c9f: ".\x05\u5c9f", // 岟
	0x5ca0: ".\x05\u5ca0", // 岠
	0x5ca1: ".\x05\u5ca1", // 岡
	0x5ca2: ".\x05\u5ca2", // 岢
	0x5ca3: ".\x05\u5ca3", // 岣
	0x5ca4: ".\x05\u5ca4", // 岤
	0x5ca5: ".\x05\u5ca5", // 岥
	0x5ca6: ".\x05\u5ca6", // 岦
	0x5ca7: ".\x05\u5ca7", // 岧
	0x5ca8: ".\x05\u5ca8", // 岨
	0x5ca9: ".\x05\u5ca9", // 岩
	0x5caa: ".\x05\u5caa", // 岪
	0x5cab: ".\x05\u5cab", // 岫
	0x5cac: ".\x05\u5cac", // 岬
	0x5cad: ".\x05\u5cad", // 岭
	0x5cae: ".\x05\u5cae", // 岮
	0x5caf: ".\x05\u5caf", // 岯
	0x5cb0: ".\x05\u5cb0", // 岰
	0x5cb1: ".\x05\u5cb1", // 岱
	0x5cb2: ".\x05\u5cb2", // 岲
	0x5cb3: ".\x05\u5cb3", // 岳
	0x5cb4: ".\x05\u5cb4", // 岴
	0x5cb5: ".\x05\u5cb5", // 岵
	0x5cb6: ".\x05\u5cb6", // 岶
	0x5cb7: ".\x05\u5cb7", // 岷
	0x5cb8: ".\x05\u5cb8", // 岸
	0x5cb9: ".\x05\u5cb9", // 岹
	0x5cba: ".\x05\u5cba", // 岺
	0x5cbb: ".\x05\u5cbb", // 岻
	0x5cbc: ".\x05\u5cbc", // 岼
	0x5cbd: ".\x05\u5cbd", // 岽
	0x5cbe: ".\x05\u5cbe", // 岾
	0x5cbf: ".\x05\u5cbf", // 岿
	0x5cc0: ".\x05\u5cc0", // 峀
	0x5cc1: ".\x05\u5cc1", // 峁
	0x5cc2: ".\x05\u5cc2", // 峂
	0x5cc3: ".\x05\u5cc3", // 峃
	0x5cc4: ".\x05\u5cc4", // 峄
	0x5cc5: ".\x05\u5cc5", // 峅
	0x5cc6: ".\x06\u5cc6", // 峆
	0x5cc7: ".\x06\u5cc7", // 峇
	0x5cc8: ".\x06\u5cc8", // 峈
	0x5cc9: ".\x06\u5cc9", // 峉
	0x5cca: ".\x06\u5cca", // 峊
	0x5ccb: ".\x06\u5ccb", // 峋
	0x5ccc: ".\x06\u5ccc", // 峌
	0x5ccd: ".\x06\u5ccd", // 峍
	0x5cce: ".\x06\u5cce", // 峎
	0x5ccf: ".\x06\u5ccf", // 峏
	0x5cd0: ".\x06\u5cd0", // 峐
	0x5cd1: ".\x06\u5cd1", // 峑
	0x5cd2: ".\x06\u5cd2", // 峒
	0x5cd3: ".\x06\u5cd3", // 峓
	0x5cd4: ".\x06\u5cd4", // 峔
	0x5cd5: ".\x06\u5cd5", // 峕
	0x5cd6: ".\x06\u5cd6", // 峖
	0x5cd7: ".\x06\u5cd7", // 峗
	0x5cd8: ".\x06\u5cd8", // 峘
	0x5cd9: ".\x06\u5cd9", // 峙
	0x5cda: ".\x06\u5cda", // 峚
	0x5cdb: ".\x06\u5cdb", // 峛
	0x5cdc: ".\x06\u5cdc", // 峜
	0x5cdd: ".\x06\u5cdd", // 峝
	0x5cde: ".\x06\u5cde", // 峞
	0x5cdf: ".\x06\u5cdf", // 峟
	0x5ce0: ".\x06\u5ce0", // 峠
	0x5ce1: ".\x06\u5ce1", // 峡
	0x5ce2: ".\x06\u5ce2", // 峢
	0x5ce3: ".\x06\u5ce3", // 峣
	0x5ce4: ".\x06\u5ce4", // 峤
	0x5ce5: ".\x06\u5ce5", // 峥
	0x5ce6: ".\x06\u5ce6", // 峦
	0x5ce7: ".\x06\u5ce7", // 峧
	0x5ce8: ".\a\u5ce8", // 峨
	0x5ce9: ".\a\u5ce9", // 峩
	0x5cea: ".\a\u5cea", // 峪
	0x5ceb: ".\a\u5ceb", // 峫
	0x5cec: ".\a\u5cec", // 峬
	0x5ced: ".\a\u5ced", // 峭
	0x5cee: ".\a\u5cee", // 峮
	0x5cef: ".\a\u5cef", // 峯
	0x5cf0: ".\a\u5cf0", // 峰
	0x5cf1: ".\a\u5cf1", // 峱
	0x5cf2: ".\a\u5cf2", // 峲
	0x5cf3: ".\a\u5cf3", // 峳
	0x5cf4: ".\a\u5cf4", // 峴
	0x5cf5: ".\a\u5cf5", // 峵
	0x5cf6: ".\a\u5cf6", // 島
	0x5cf7: ".\a\u5cf7", // 峷
	0x5cf8: ".\a\u5cf8", // 峸
	0x5cf9: ".\a\u5cf9", // 峹
	0x5cfa: ".\a\u5cfa", // 峺
	0x5cfb: ".\a\u5cfb", // 峻
	0x5cfc: ".\a\u5cfc", // 峼
	0x5cfd: ".\a\u5cfd", // 峽
	0x5cfe: ".\a\u5cfe", // 峾
	0x5cff: ".\a\u5cff", // 峿
	0x5d00: ".\a\u5d00", // 崀
	0x5d01: ".\a\u5d01", // 崁
	0x5d02: ".\a\u5d02", // 崂
	0x5d03: ".\a\u5d03", // 崃
	0x5d04: ".\a\u5d04", // 崄
	0x5d05: ".\a\u5d05", // 崅
	0x5d06: ".\b\u5d06", // 崆
	0x5d07: ".\b\u5d07", // 崇
	0x5d08: ".\b\u5d08", // 崈
	0x5d09: ".\b\u5d09", // 崉
	0x5d0a: ".\b\u5d0a", // 崊
	0x5d0b: ".\b\u5d0b", // 崋
	0x5d0c: ".\b\u5d0c", // 崌
	0x5d0d: ".\b\u5d0d", // 崍
	0x5d0e: ".\b\u5d0e", // 崎
	0x5d0f: ".\b\u5d0f", // 崏
	0x5d10: ".\b\u5d10", // 崐
	0x5d11: ".\b\u5d11", // 崑
	0x5d12: ".\b\u5d12", // 崒
	0x5d13: ".\b\u5d13", // 崓
	0x5d14: ".\b\u5d14", // 崔
	0x5d15: ".\b\u5d15", // 崕
	0x5d16: ".\b\u5d16", // 崖
	0x5d17: ".\b\u5d17", // 崗
	0x5d18: ".\b\u5d18", // 崘
	0x5d19: ".\b\u5d19", // 崙
	0x5d1a: ".\b\u5d1a", // 崚
	0x5d1b: ".\b\u5d1b", // 崛
	0x5d1c: ".\b\u5d1c", // 崜
	0x5d1d: ".\b\u5d1d", // 崝
	0x5d1e: ".\b\u5d1e", // 崞
	0x5d1f: ".\b\u5d1f", // 崟
	0x5d20: ".\b\u5d20", // 崠
	0x5d21: ".\b\u5d21", // 崡
	0x5d22: ".\b\u5d22", // 崢
	0x5d23: ".\b\u5d23", // 崣
	0x5d24: ".\b\u5d24", // 崤
	0x5d25: ".\b\u5d25", // 崥
	0x5d26: ".\b\u5d26", // 崦
	0x5d27: ".\b\u5d27", // 崧
	0x5d28: ".\b\u5d28", // 崨
	0x5d29: ".\b\u5d29", // 崩
	0x5d2a: ".\b\u5d2a", // 崪
	0x5d2b: ".\b\u5d2b", // 崫
	0x5d2c: ".\b\u5d2c", // 崬
	0x5d2d: ".\b\u5d2d", // 崭
	0x5d2e: ".\b\u5d2e", // 崮
	0x5d2f: ".\b\u5d2f", // 崯
	0x5d30: ".\b\u5d30", // 崰
	0x5d31: ".\t\u5d31", // 崱
	0x5d32: ".\t\u5d32", // 崲
	0x5d33: ".\t\u5d33", // 崳
	0x5d34: ".\t\u5d34", // 崴
	0x5d35: ".\t\u5d35", // 崵
	0x5d36: ".\t\u5d36", // 崶
	0x5d37: ".\t\u5d37", // 崷
	0x5d38: ".\t\u5d38", // 崸
	0x5d39: ".\t\u5d39", // 崹
	0x5d3a: ".\t\u5d3a", // 崺
	0x5d3b: ".\t\u5d3b", // 崻
	0x5d3c: ".\t\u5d3c", // 崼
	0x5d3d: ".\t\u5d3d", // 崽
	0x5d3e: ".\t\u5d3e", // 崾
	0x5d3f: ".\t\u5d3f", // 崿
	0x5d40: ".\t\u5d40", // 嵀
	0x5d41: ".\t\u5d41", // 嵁
	0x5d42: ".\t\u5d42", // 嵂
	0x5d43: ".\t\u5d43", // 嵃
	0x5d44: ".\t\u5d44", // 嵄
	0x5d45: ".\t\u5d45", // 嵅
	0x5d46: ".\t\u5d46", // 嵆
	0x5d47: ".\t\u5d47", // 嵇
	0x5d48: ".\t\u5d48", // 嵈
	0x5d49: ".\t\u5d49", // 嵉
	0x5d4a: ".\n\u5d4a", // 嵊
	0x5d4b: ".\t\u5d4b", // 嵋
	0x5d4c: ".\t\u5d4c", // 嵌
	0x5d4d: ".\t\u5d4d", // 嵍
	0x5d4e: ".\t\u5d4e", // 嵎
	0x5d4f: ".\t\u5d4f", // 嵏
	0x5d50: ".\t\u5d50", // 嵐
	0x5d51: ".\t\u5d51", // 嵑
	0x5d52: ".\t\u5d52", // 嵒
	0x5d53: ".\t\u5d53", // 嵓
	0x5d54: ".\t\u5d54", // 嵔
	0x5d55: ".\t\u5d55", // 嵕
	0x5d56: ".\t\u5d56", // 嵖
	0x5d57: ".\t\u5d57", // 嵗
	0x5d58: ".\t\u5d58", // 嵘
	0x5d59: ".\t\u5d59", // 嵙
	0x5d5a: ".\t\u5d5a", // 嵚
	0x5d5b: ".\t\u5d5b", // 嵛
	0x5d5c: ".\t\u5d5c", // 嵜
	0x5d5d: ".\t\u5d5d", // 嵝
	0x5d5e: ".\n\u5d5e", // 嵞
	0x5d5f: ".\n\u5d5f", // 嵟
	0x5d60: ".\n\u5d60", // 嵠
	0x5d61: ".\n\u5d61", // 嵡
	0x5d62: ".\n\u5d62", // 嵢
	0x5d63: ".\n\u5d63", // 嵣
	0x5d64: ".\n\u5d64", // 嵤
	0x5d65: ".\n\u5d65", // 嵥
	0x5d66: ".\n\u5d66", // 嵦
	0x5d67: ".\n\u5d67", // 嵧
	0x5d68: ".\n\u5d68", // 嵨
	0x5d69: ".\n\u5d69", // 嵩
	0x5d6a: ".\n\u5d6a", // 嵪
	0x5d6b: ".\n\u5d6b", // 嵫
	0x5d6c: ".\n\u5d6c", // 嵬
	0x5d6d: ".\n\u5d6d", // 嵭
	0x5d6e: ".\n\u5d6e", // 嵮
	0x5d6f: ".\n\u5d6f", // 嵯
	0x5d70: ".\n\u5d70", // 嵰
	0x5d71: ".\n\u5d71", // 嵱
	0x5d72: ".\n\u5d72", // 嵲
	0x5d73: ".\n\u5d73", // 嵳
	0x5d74: ".\n\u5d74", // 嵴
	0x5d75: ".\n\u5d75", // 嵵
	0x5d76: ".\n\u5d76", // 嵶
	0x5d77: ".\v\u5d77", // 嵷
	0x5d78: ".\v\u5d78", // 嵸
	0x5d79: ".\v\u5d79", // 嵹
	0x5d7a: ".\v\u5d7a", // 嵺
	0x5d7b: ".\v\u5d7b", // 嵻
	0x5d7c: ".\v\u5d7c", // 嵼
	0x5d7d: ".\v\u5d7d", // 嵽
	0x5d7e: ".\v\u5d7e", // 嵾
	0x5d7f: ".\v\u5d7f", // 嵿
	0x5d80: ".\v\u5d80", // 嶀
	0x5d81: ".\v\u5d81", // 嶁
	0x5d82: ".\v\u5d82", // 嶂
	0x5d83: ".\v\u5d83", // 嶃
	0x5d84: ".\v\u5d84", // 嶄
	0x5d85: ".\v\u5d85", // 嶅
	0x5d86: ".\v\u5d86", // 嶆
	0x5d87: ".\v\u5d87", // 嶇
	0x5d88: ".\v\u5d88", // 嶈
	0x5d89: ".\v\u5d89", // 嶉
	0x5d8a: ".\v\u5d8a", // 嶊
	0x5d8b: ".\v\u5d8b", // 嶋
	0x5d8c: ".\v\u5d8c", // 嶌
	0x5d8d: ".\v\u5d8d", // 嶍
	0x5d8e: ".\v\u5d8e", // 嶎
	0x5d8f: ".\f\u5d8f", // 嶏
	0x5d90: ".\f\u5d90", // 嶐
	0x5d91: ".\f\u5d91", // 嶑
	0x5d92: ".\f\u5d92", // 嶒
	0x5d93: ".\f\u5d93", // 嶓
	0x5d94: ".\f\u5d94", // 嶔
	0x5d95: ".\f\u5d95", // 嶕
	0x5d96: ".\f\u5d96", // 嶖
	0x5d97: ".\f\u5d97", // 嶗
	0x5d98: ".\f\u5d98", // 嶘
	0x5d99: ".\f\u5d99", // 嶙
	0x5d9a: ".\f\u5d9a", // 嶚
	0x5d9b: ".\f\u5d9b", // 嶛
	0x5d9c: ".\f\u5d9c", // 嶜
	0x5d9d: ".\f\u5d9d", // 嶝
	0x5d9e: ".\f\u5d9e", // 嶞
	0x5d9f: ".\f\u5d9f", // 嶟
	0x5da0: ".\f\u5da0", // 嶠
	0x5da1: ".\f\u5da1", // 嶡
	0x5da2: ".\f\u5da2", // 嶢
	0x5da3: ".\f\u5da3", // 嶣
	0x5da4: ".\f\u5da4", // 嶤
	0x5da5: ".\f\u5da5", // 嶥
	0x5da6: ".\r\u5da6", // 嶦
	0x5da7: ".\r\u5da7", // 嶧
	0x5da8: ".\r\u5da8", // 嶨
	0x5da9: ".\r\u5da9", // 嶩
	0x5daa: ".\r\u5daa", // 嶪
	0x5dab: ".\r\u5dab", // 嶫
	0x5dac: ".\r\u5dac", // 嶬
	0x5dad: ".\r\u5dad", // 嶭
	0x5dae: ".\r\u5dae", // 嶮
	0x5daf: ".\r\u5daf", // 嶯
	0x5db0: ".\r\u5db0", // 嶰
	0x5db1: ".\r\u5db1", // 嶱
	0x5db2: ".\r\u5db2", // 嶲
	0x5db3: ".\r\u5db3", // 嶳
	0x5db4: ".\r\u5db4", // 嶴
	0x5db5: ".\r\u5db5", // 嶵
	0x5db6: ".\r\u5db6", // 嶶
	0x5db7: ".\x0e\u5db7", // 嶷
	0x5db8: ".\x0e\u5db8", // 嶸
	0x5db9: ".\x0e\u5db9", // 嶹
	0x5dba: ".\x0e\u5dba", // 嶺
	0x5dbb: ".\x10\u5dbb", // 嶻
	0x5dbc: ".\x0e\u5dbc", // 嶼
	0x5dbd: ".\x0e\u5dbd", // 嶽
	0x5dbe: ".\x0e\u5dbe", // 嶾
	0x5dbf: ".\x0e\u5dbf", // 嶿
	0x5dc0: ".\x0f\u5dc0", // 巀
	0x5dc1: ".\x0f\u5dc1", // 巁
	0x5dc2: ".\x0f\u5dc2", // 巂
	0x5dc3: ".\x10\u5dc3", // 巃
	0x5dc4: ".\x10\u5dc4", // 巄
	0x5dc5: ".\x10\u5dc5", // 巅
	0x5dc6: ".\x11\u5dc6", // 巆
	0x5dc7: ".\x11\u5dc7", // 巇
	0x5dc8: ".\x11\u5dc8", // 巈
	0x5dc9: ".\x11\u5dc9", // 巉
	0x5dca: ".\x11\u5dca", // 巊
	0x5dcb: ".\x11\u5dcb", // 巋
	0x5dcc: ".\x11\u5dcc", // 巌
	0x5dcd: ".\x12\u5dcd", // 巍
	0x5dce: ".\x13\u5dce", // 巎
	0x5dcf: ".\x12\u5dcf", // 巏
	0x5dd0: ".\x12\u5dd0", // 巐
	0x5dd1: ".\x13\u5dd1", // 巑
	0x5dd2: ".\x13\u5dd2", // 巒
	0x5dd3: ".\x13\u5dd3", // 巓
	0x5dd4: ".\x13\u5dd4", // 巔
	0x5dd5: ".\x13\u5dd5", // 巕
	0x5dd6: ".\x14\u5dd6", // 巖
	0x5dd7: ".\x13\u5dd7", // 巗
	0x5dd8: ".\x14\u5dd8", // 巘
	0x5dd9: ".\x14\u5dd9", // 巙
	0x5dda: ".\x14\u5dda", // 巚
	0x5ddb: "/\x00\u5ddb", // 巛
	0x5ddc: "/\x00\u5ddc", // 巜
	0x5ddd: "/\x00\u5ddd", // 川
	0x5dde: "/\x03\u5dde", // 州
	0x5ddf: "/\x03\u5ddf", // 巟
	0x5de0: "/\x04\u5de0", // 巠
	0x5de1: "\xa2\x03\u5de1", // 巡
	0x5de2: "/\b\u5de2", // 巢
	0x5de3: "/\b\u5de3", // 巣
	0x5de4: "/\f\u5de4", // 巤
	0x5de5: "0\x00\u5de5", // 工
	0x5de6: "0\x02\u5de6", // 左
	0x5de7: "0\x02\u5de7", // 巧
	0x5de8: "0\x02\u5de8", // 巨
	0x5de9: "0\x03\u5de9", // 巩
	0x5dea: "0\x03\u5dea", // 巪
	0x5deb: "0\x04\u5deb", // 巫
	0x5dec: "0\x06\u5dec", // 巬
	0x5ded: "0\x06\u5ded", // 巭
	0x5dee: "0\a\u5dee", // 差
	0x5def: "0\t\u5def", // 巯
	0x5df0: "0\n\u5df0", // 巰
	0x5df1: "1\x00\u5df1", // 己
	0x5df2: "1\x00\u5df2", // 已
	0x5df3: "1\x00\u5df3", // 巳
	0x5df4: "1\x01\u5df4", // 巴
	0x5df5: "1\x04\u5df5", // 巵
	0x5df6: "1\x05\u5df6", // 巶
	0x5df7: "1\x06\u5df7", // 巷
	0x5df8: "1\x06\u5df8", // 巸
	0x5df9: "1\x06\u5df9", // 巹
	0x5dfa: "1\x06\u5dfa", // 巺
	0x5dfb: "1\x06\u5dfb", // 巻
	0x5dfc: "1\a\u5dfc", // 巼
	0x5dfd: "1\t\u5dfd", // 巽
	0x5dfe: "2\x00\u5dfe", // 巾
	0x5dff: "2\x01\u5dff", // 巿
	0x5e00: "2\x01\u5e00", // 帀
	0x5e01: "2\x01\u5e01", // 币
	0x5e02: "2\x02\u5e02", // 市
	0x5e03: "2\x02\u5e03", // 布
	0x5e04: "2\x02\u5e04", // 帄
	0x5e05: "2\x02\u5e05", // 帅
	0x5e06: "2\x03\u5e06", // 帆
	0x5e07: "2\x03\u5e07", // 帇
	0x5e08: "2\x03\u5e08", // 师
	0x5e09: "2\x04\u5e09", // 帉
	0x5e0a: "2\x04\u5e0a", // 帊
	0x5e0b: "2\x04\u5e0b", // 帋
	0x5e0c: "2\x04\u5e0c", // 希
	0x5e0d: "2\x04\u5e0d", // 帍
	0x5e0e: "2\x04\u5e0e", // 帎
	0x5e0f: "2\x04\u5e0f", // 帏
	0x5e10: "2\x04\u5e10", // 帐
	0x5e11: "2\x05\u5e11", // 帑
	0x5e12: "2\x05\u5e12", // 帒
	0x5e13: "2\x05\u5e13", // 帓
	0x5e14: "2\x05\u5e14", // 帔
	0x5e15: "2\x05\u5e15", // 帕
	0x5e16: "2\x05\u5e16", // 帖
	0x5e17: "2\x05\u5e17", // 帗
	0x5e18: "2\x05\u5e18", // 帘
	0x5e19: "2\x05\u5e19", // 帙
	0x5e1a: "2\x05\u5e1a", // 帚
	0x5e1b: "2\x05\u5e1b", // 帛
	0x5e1c: "2\x05\u5e1c", // 帜
	0x5e1d: "2\x06\u5e1d", // 帝
	0x5e1e: "2\x06\u5e1e", // 帞
	0x5e1f: "2\x06\u5e1f", // 帟
	0x5e20: "2\x06\u5e20", // 帠
	0x5e21: "2\x06\u5e21", // 帡
	0x5e22: "2\x06\u5e22", // 帢
	0x5e23: "2\x06\u5e23", // 帣
	0x5e24: "2\x06\u5e24", // 帤
	0x5e25: "2\x06\u5e25", // 帥
	0x5e26: "2\x06\u5e26", // 带
	0x5e27: "2\x06\u5e27", // 帧
	0x5e28: "2\a\u5e28", // 帨
	0x5e29: "2\a\u5e29", // 帩
	0x5e2a: "2\a\u5e2a", // 帪
	0x5e2b: "2\a\u5e2b", // 師
	0x5e2c: "2\a\u5e2c", // 帬
	0x5e2d: "2\a\u5e2d", // 席
	0x5e2e: "2\a\u5e2e", // 帮
	0x5e2f: "2\a\u5e2f", // 帯
	0x5e30: "2\a\u5e30", // 帰
	0x5e31: "2\a\u5e31", // 帱
	0x5e32: "2\b\u5e32", // 帲
	0x5e33: "2\b\u5e33", // 帳
	0x5e34: "2\b\u5e34", // 帴
	0x5e35: "2\b\u5e35", // 帵
	0x5e36: "2\b\u5e36", // 帶
	0x5e37: "2\b\u5e37", // 帷
	0x5e38: "2\b\u5e38", // 常
	0x5e39: "2\b\u5e39", // 帹
	0x5e3a: "2\b\u5e3a", // 帺
	0x5e3b: "2\b\u5e3b", // 帻
	0x5e3c: "2\b\u5e3c", // 帼
	0x5e3d: "2\t\u5e3d", // 帽
	0x5e3e: "2\t\u5e3e", // 帾
	0x5e3f: "2\t\u5e3f", // 帿
	0x5e40: "2\t\u5e40", // 幀
	0x5e41: "2\t\u5e41", // 幁
	0x5e42: "2\t\u5e42", // 幂
	0x5e43: "2\t\u5e43", // 幃
	0x5e44: "2\t\u5e44", // 幄
	0x5e45: "2\t\u5e45", // 幅
	0x5e46: "2\t\u5e46", // 幆
	0x5e47: "2\t\u5e47", // 幇
	0x5e48: "2\v\u5e48", // 幈
	0x5e49: "2\t\u5e49", // 幉
	0x5e4a: "2\n\u5e4a", // 幊
	0x5e4b: "2\n\u5e4b", // 幋
	0x5e4c: "2\n\u5e4c", // 幌
	0x5e4d: "2\n\u5e4d", // 幍
	0x5e4e: "2\n\u5e4e", // 幎
	0x5e4f: "2\n\u5e4f", // 幏
	0x5e50: "\x82\t\u5e50", // 幐
	0x5e51: "2\v\u5e51", // 幑
	0x5e52: "2\v\u5e52", // 幒
	0x5e53: "2\v\u5e53", // 幓
	0x5e54: "2\v\u5e54", // 幔
	0x5e55: "2\v\u5e55", // 幕
	0x5e56: "2\v\u5e56", // 幖
	0x5e57: "2\v\u5e57", // 幗
	0x5e58: "2\v\u5e58", // 幘
	0x5e59: "2\v\u5e59", // 幙
	0x5e5a: "2\f\u5e5a", // 幚
	0x5e5b: "2\v\u5e5b", // 幛
	0x5e5c: "2\f\u5e5c", // 幜
	0x5e5d: "2\f\u5e5d", // 幝
	0x5e5e: "2\f\u5e5e", // 幞
	0x5e5f: "2\f\u5e5f", // 幟
	0x5e60: "2\f\u5e60", // 幠
	0x5e61: "2\f\u5e61", // 幡
	0x5e62: "2\f\u5e62", // 幢
	0x5e63: "2\f\u5e63", // 幣
	0x5e64: "2\f\u5e64", // 幤
	0x5e65: "2\f\u5e65", // 幥
	0x5e66: "2\r\u5e66", // 幦
	0x5e67: "2\r\u5e67", // 幧
	0x5e68: "2\r\u5e68", // 幨
	0x5e69: "2\r\u5e69", // 幩
	0x5e6a: "2\x0e\u5e6a", // 幪
	0x5e6b: "2\x0e\u5e6b", // 幫
	0x5e6c: "2\x0e\u5e6c", // 幬
	0x5e6d: "2\x0f\u5e6d", // 幭
	0x5e6e: "2\x0f\u5e6e", // 幮
	0x5e6f: "2\x0f\u5e6f", // 幯
	0x5e70: "2\x10\u5e70", // 幰
	0x5e71: "2\x11\u5e71", // 幱
	0x5e72: "3\x00\u5e72", // 干
	0x5e73: "3\x02\u5e73", // 平
	0x5e74: "3\x03\u5e74", // 年
	0x5e75: "3\x03\u5e75", // 幵
	0x5e76: "3\x05\u5e76", // 并
	0x5e77: "3\x05\u5e77", // 幷
	0x5e78: "3\x05\u5e78", // 幸
	0x5e79: "3\n\u5e79", // 幹
	0x5e7a: "4\x00\u5e7a", // 幺
	0x5e7b: "4\x01\u5e7b", // 幻
	0x5e7c: "4\x02\u5e7c", // 幼
	0x5e7d: "4\x06\u5e7d", // 幽
	0x5e7e: "4\t\u5e7e", // 幾
	0x5e7f: "5\x00\u5e7f", // 广
	0x5e80: "5\x02\u5e80", // 庀
	0x5e81: "5\x02\u5e81", // 庁
	0x5e82: "5\x02\u5e82", // 庂
	0x5e83: "5\x02\u5e83", // 広
	0x5e84: "5\x03\u5e84", // 庄
	0x5e85: "5\x03\u5e85", // 庅
	0x5e86: "5\x03\u5e86", // 庆
	0x5e87: "5\x04\u5e87", // 庇
	0x5e88: "5\x04\u5e88", // 庈
	0x5e89: "5\x04\u5e89", // 庉
	0x5e8a: "5\x04\u5e8a", // 床
	0x5e8b: "5\x04\u5e8b", // 庋
	0x5e8c: "5\x04\u5e8c", // 庌
	0x5e8d: "5\x04\u5e8d", // 庍
	0x5e8e: "5\x04\u5e8e", // 庎
	0x5e8f: "5\x04\u5e8f", // 序
	0x5e90: "5\x04\u5e90", // 庐
	0x5e91: "5\x04\u5e91", // 庑
	0x5e92: "5\x04\u5e92", // 庒
	0x5e93: "5\x04\u5e93", // 库
	0x5e94: "5\x04\u5e94", // 应
	0x5e95: "5\x05\u5e95", // 底
	0x5e96: "5\x05\u5e96", // 庖
	0x5e97: "5\x05\u5e97", // 店
	0x5e98: "5\x04\u5e98", // 庘
	0x5e99: "5\x05\u5e99", // 庙
	0x5e9a: "5\x05\u5e9a", // 庚
	0x5e9b: "5\x05\u5e9b", // 庛
	0x5e9c: "5\x05\u5e9c", // 府
	0x5e9d: "5\x05\u5e9d", // 庝
	0x5e9e: "5\x05\u5e9e", // 庞
	0x5e9f: "5\x05\u5e9f", // 废
	0x5ea0: "5\x06\u5ea0", // 庠
	0x5ea1: "5\x06\u5ea1", // 庡
	0x5ea2: "5\x06\u5ea2", // 庢
	0x5ea3: "5\x06\u5ea3", // 庣
	0x5ea4: "5\x06\u5ea4", // 庤
	0x5ea5: "5\x06\u5ea5", // 庥
	0x5ea6: "5\x06\u5ea6", // 度
	0x5ea7: "5\a\u5ea7", // 座
	0x5ea8: "5\a\u5ea8", // 庨
	0x5ea9: "5\a\u5ea9", // 庩
	0x5eaa: "5\a\u5eaa", // 庪
	0x5eab: "5\a\u5eab", // 庫
	0x5eac: "5\a\u5eac", // 庬
	0x5ead: "5\a\u5ead", // 庭
	0x5eae: "5\a\u5eae", // 庮
	0x5eaf: "5\a\u5eaf", // 庯
	0x5eb0: "5\b\u5eb0", // 庰
	0x5eb1: "5\b\u5eb1", // 庱
	0x5eb2: "5\b\u5eb2", // 庲
	0x5eb3: "5\b\u5eb3", // 庳
	0x5eb4: "5\b\u5eb4", // 庴
	0x5eb5: "5\b\u5eb5", // 庵
	0x5eb6: "5\b\u5eb6", // 庶
	0x5eb7: "5\b\u5eb7", // 康
	0x5eb8: "5\b\u5eb8", // 庸
	0x5eb9: "5\b\u5eb9", // 庹
	0x5eba: "5\b\u5eba", // 庺
	0x5ebb: "5\b\u5ebb", // 庻
	0x5ebc: "5\b\u5ebc", // 庼
	0x5ebd: "5\t\u5ebd", // 庽
	0x5ebe: "5\t\u5ebe", // 庾
	0x5ebf: "5\t\u5ebf", // 庿
	0x5ec0: "5\t\u5ec0", // 廀
	0x5ec1: "5\t\u5ec1", // 廁
	0x5ec2: "5\t\u5ec2", // 廂
	0x5ec3: "5\t\u5ec3", // 廃
	0x5ec4: "5\v\u5ec4", // 廄
	0x5ec5: "5\n\u5ec5", // 廅
	0x5ec6: "5\n\u5ec6", // 廆
	0x5ec7: "5\n\u5ec7", // 廇
	0x5ec8: "5\n\u5ec8", // 廈
	0x5ec9: "5\n\u5ec9", // 廉
	0x5eca: "5\t\u5eca", // 廊
	0x5ecb: "5\n\u5ecb", // 廋
	0x5ecc: "5\n\u5ecc", // 廌
	0x5ecd: "5\v\u5ecd", // 廍
	0x5ece: "5\v\u5ece", // 廎
	0x5ecf: "5\v\u5ecf", // 廏
	0x5ed0: "5\v\u5ed0", // 廐
	0x5ed1: "5\v\u5ed1", // 廑
	0x5ed2: "5\v\u5ed2", // 廒
	0x5ed3: "5\v\u5ed3", // 廓
	0x5ed4: "5\v\u5ed4", // 廔
	0x5ed5: "5\v\u5ed5", // 廕
	0x5ed6: "5\v\u5ed6", // 廖
	0x5ed7: "5\v\u5ed7", // 廗
	0x5ed8: "5\v\u5ed8", // 廘
	0x5ed9: "5\f\u5ed9", // 廙
	0x5eda: "5\f\u5eda", // 廚
	0x5edb: "5\f\u5edb", // 廛
	0x5edc: "5\f\u5edc", // 廜
	0x5edd: "5\f\u5edd", // 廝
	0x5ede: "5\f\u5ede", // 廞
	0x5edf: "5\f\u5edf", // 廟
	0x5ee0: "5\f\u5ee0", // 廠
	0x5ee1: "5\f\u5ee1", // 廡
	0x5ee2: "5\f\u5ee2", // 廢
	0x5ee3: "5\f\u5ee3", // 廣
	0x5ee4: "5\f\u5ee4", // 廤
	0x5ee5: "5\r\u5ee5", // 廥
	0x5ee6: "5\r\u5ee6", // 廦
	0x5ee7: "5\r\u5ee7", // 廧
	0x5ee8: "5\r\u5ee8", // 廨
	0x5ee9: "5\r\u5ee9", // 廩
	0x5eea: "5\r\u5eea", // 廪
	0x5eeb: "5\x0f\u5eeb", // 廫
	0x5eec: "5\x10\u5eec", // 廬
	0x5eed: "5\x10\u5eed", // 廭
	0x5eee: "5\x11\u5eee", // 廮
	0x5eef: "5\x11\u5eef", // 廯
	0x5ef0: "5\x11\u5ef0", // 廰
	0x5ef1: "5\x12\u5ef1", // 廱
	0x5ef2: "5\x13\u5ef2", // 廲
	0x5ef3: "5\x16\u5ef3", // 廳
	0x5ef4: "6\x00\u5ef4", // 廴
	0x5ef5: "6\x03\u5ef5", // 廵
	0x5ef6: "6\x04\u5ef6", // 延
	0x5ef7: "6\x04\u5ef7", // 廷
	0x5ef8: "6\x05\u5ef8", // 廸
	0x5ef9: "6\x05\u5ef9", // 廹
	0x5efa: "6\x06\u5efa", // 建
	0x5efb: "6\x06\u5efb", // 廻
	0x5efc: "6\x06\u5efc", // 廼
	0x5efd: "6\a\u5efd", // 廽
	0x5efe: "7\x00\u5efe", // 廾
	0x5eff: "7\x01\u5eff", // 廿
	0x5f00: "7\x01\u5f00", // 开
	0x5f01: "7\x02\u5f01", // 弁
	0x5f02: "7\x03\u5f02", // 异
	0x5f03: "7\x04\u5f03", // 弃
	0x5f04: "7\x04\u5f04", // 弄
	0x5f05: "7\x04\u5f05", // 弅
	0x5f06: "7\x05\u5f06", // 弆
	0x5f07: "7\x06\u5f07", // 弇
	0x5f08: "7\x06\u5f08", // 弈
	0x5f09: "7\a\u5f09", // 弉
	0x5f0a: "7\f\u5f0a", // 弊
	0x5f0b: "8\x00\u5f0b", // 弋
	0x5f0c: "8\x01\u5f0c", // 弌
	0x5f0d: "8\x02\u5f0d", // 弍
	0x5f0e: "8\x03\u5f0e", // 弎
	0x5f0f: "8\x03\u5f0f", // 式
	0x5f10: "8\x03\u5f10", // 弐
	0x5f11: "8\t\u5f11", // 弑
	0x5f12: "8\n\u5f12", // 弒
	0x5f13: "9\x00\u5f13", // 弓
	0x5f14: "9\x01\u5f14", // 弔
	0x5f15: "9\x01\u5f15", // 引
	0x5f16: "9\x01\u5f16", // 弖
	0x5f17: "9\x02\u5f17", // 弗
	0x5f18: "9\x02\u5f18", // 弘
	0x5f19: "9\x03\u5f19", // 弙
	0x5f1a: "9\x03\u5f1a", // 弚
	0x5f1b: "9\x03\u5f1b", // 弛
	0x5f1c: "9\x03\u5f1c", // 弜
	0x5f1d: "9\x04\u5f1d", // 弝
	0x5f1e: "9\x04\u5f1e", // 弞
	0x5f1f: "9\x04\u5f1f", // 弟
	0x5f20: "9\x04\u5f20", // 张
	0x5f21: "9\x05\u5f21", // 弡
	0x5f22: "9\x05\u5f22", // 弢
	0x5f23: "9\x05\u5f23", // 弣
	0x5f24: "9\x05\u5f24", // 弤
	0x5f25: "9\x05\u5f25", // 弥
	0x5f26: "9\x05\u5f26", // 弦
	0x5f27: "9\x05\u5f27", // 弧
	0x5f28: "9\x05\u5f28", // 弨
	0x5f29: "9\x05\u5f29", // 弩
	0x5f2a: "9\x05\u5f2a", // 弪
	0x5f2b: "9\x06\u5f2b", // 弫
	0x5f2c: "9\x06\u5f2c", // 弬
	0x5f2d: "9\x06\u5f2d", // 弭
	0x5f2e: "9\x06\u5f2e", // 弮
	0x5f2f: "9\x06\u5f2f", // 弯
	0x5f30: "9\a\u5f30", // 弰
	0x5f31: "9\a\u5f31", // 弱
	0x5f32: "9\a\u5f32", // 弲
	0x5f33: "9\a\u5f33", // 弳
	0x5f34: "9\b\u5f34", // 弴
	0x5f35: "9\b\u5f35", // 張
	0x5f36: "9\b\u5f36", // 弶
	0x5f37: "9\b\u5f37", // 強
	0x5f38: "9\b\u5f38", // 弸
	0x5f39: "9\b\u5f39", // 弹
	0x5f3a: "9\t\u5f3a", // 强
	0x5f3b: "9\t\u5f3b", // 弻
	0x5f3c: "9\t\u5f3c", // 弼
	0x5f3d: "9\t\u5f3d", // 弽
	0x5f3e: "9\t\u5f3e", // 弾
	0x5f3f: "9\n\u5f3f", // 弿
	0x5f40: "9\n\u5f40", // 彀
	0x5f41: "9\n\u5f41", // 彁
	0x5f42: "9\n\u5f42", // 彂
	0x5f43: "9\v\u5f43", // 彃
	0x5f44: "9\v\u5f44", // 彄
	0x5f45: "9\v\u5f45", // 彅
	0x5f46: "9\f\u5f46", // 彆
	0x5f47: "9\f\u5f47", // 彇
	0x5f48: "9\f\u5f48", // 彈
	0x5f49: "9\f\u5f49", // 彉
	0x5f4a: "9\r\u5f4a", // 彊
	0x5f4b: "9\r\u5f4b", // 彋
	0x5f4c: "9\x0e\u5f4c", // 彌
	0x5f4d: "9\x0f\u5f4d", // 彍
	0x5f4e: "9\x13\u5f4e", // 彎
	0x5f4f: "9\x14\u5f4f", // 彏
	0x5f50: ":\x00\u5f50", // 彐
	0x5f51: ":\x00\u5f51", // 彑
	0x5f52: ":\x02\u5f52", // 归
	0x5f53: ":\x03\u5f53", // 当
	0x5f54: ":\x05\u5f54", // 彔
	0x5f55: ":\x05\u5f55", // 录
	0x5f56: ":\x06\u5f56", // 彖
	0x5f57: ":\b\u5f57", // 彗
	0x5f58: ":\t\u5f58", // 彘
	0x5f59: ":\n\u5f59", // 彙
	0x5f5a: ":\n\u5f5a", // 彚
	0x5f5b: ":\r\u5f5b", // 彛
	0x5f5c: ":\r\u5f5c", // 彜
	0x5f5d: ":\x0f\u5f5d", // 彝
	0x5f5e: ":\x0f\u5f5e", // 彞
	0x5f5f: ":\x10\u5f5f", // 彟
	0x5f60: ":\x17\u5f60", // 彠
	0x5f61: ";\x00\u5f61", // 彡
	0x5f62: ";\x04\u5f62", // 形
	0x5f63: ";\x04\u5f63", // 彣
	0x5f64: ";\x04\u5f64", // 彤
	0x5f65: ";\x06\u5f65", // 彥
	0x5f66: ";\x06\u5f66", // 彦
	0x5f67: ";\a\u5f67", // 彧
	0x5f68: ";\a\u5f68", // 彨
	0x5f69: ";\b\u5f69", // 彩
	0x5f6a: "\x8d\x03\u5f6a", // 彪
	0x5f6b: ";\b\u5f6b", // 彫
	0x5f6c: ";\b\u5f6c", // 彬
	0x5f6d: ";\t\u5f6d", // 彭
	0x5f6e: ";\n\u5f6e", // 彮
	0x5f6f: ";\v\u5f6f", // 彯
	0x5f70: ";\v\u5f70", // 彰
	0x5f71: ";\f\u5f71", // 影
	0x5f72: ";\x13\u5f72", // 彲
	0x5f73: "<\x00\u5f73", // 彳
	0x5f74: "<\x03\u5f74", // 彴
	0x5f75: "<\x03\u5f75", // 彵
	0x5f76: "<\x04\u5f76", // 彶
	0x5f77: "<\x04\u5f77", // 彷
	0x5f78: "<\x04\u5f78", // 彸
	0x5f79: "<\x04\u5f79", // 役
	0x5f7a: "<\x04\u5f7a", // 彺
	0x5f7b: "<\x04\u5f7b", // 彻
	0x5f7c: "<\x05\u5f7c", // 彼
	0x5f7d: "<\x05\u5f7d", // 彽
	0x5f7e: "<\x05\u5f7e", // 彾
	0x5f7f: "<\x05\u5f7f", // 彿
	0x5f80: "<\x05\u5f80", // 往
	0x5f81: "<\x05\u5f81", // 征
	0x5f82: "<\x05\u5f82", // 徂
	0x5f83: "<\x05\u5f83", // 徃
	0x5f84: "<\x05\u5f84", // 径
	0x5f85: "<\x06\u5f85", // 待
	0x5f86: "<\x06\u5f86", // 徆
	0x5f87: "<\x06\u5f87", // 徇
	0x5f88: "<\x06\u5f88", // 很
	0x5f89: "<\x06\u5f89", // 徉
	0x5f8a: "<\x06\u5f8a", // 徊
	0x5f8b: "<\x06\u5f8b", // 律
	0x5f8c: "<\x06\u5f8c", // 後
	0x5f8d: "<\x06\u5f8d", // 徍
	0x5f8e: "<\a\u5f8e", // 徎
	0x5f8f: "<\a\u5f8f", // 徏
	0x5f90: "<\a\u5f90", // 徐
	0x5f91: "<\a\u5f91", // 徑
	0x5f92: "<\a\u5f92", // 徒
	0x5f93: "<\a\u5f93", // 従
	0x5f94: "<\x06\u5f94", // 徔
	0x5f95: "<\a\u5f95", // 徕
	0x5f96: "<\b\u5f96", // 徖
	0x5f97: "<\b\u5f97", // 得
	0x5f98: "<\b\u5f98", // 徘
	0x5f99: "<\b\u5f99", // 徙
	0x5f9a: "<\t\u5f9a", // 徚
	0x5f9b: "<\b\u5f9b", // 徛
	0x5f9c: "<\b\u5f9c", // 徜
	0x5f9d: "<\b\u5f9d", // 徝
	0x5f9e: "<\b\u5f9e", // 從
	0x5f9f: "<\b\u5f9f", // 徟
	0x5fa0: "<\b\u5fa0", // 徠
	0x5fa1: "<\b\u5fa1", // 御
	0x5fa2: "<\b\u5fa2", // 徢
	0x5fa3: "<\b\u5fa3", // 徣
	0x5fa4: "<\b\u5fa4", // 徤
	0x5fa5: "<\t\u5fa5", // 徥
	0x5fa6: "<\t\u5fa6", // 徦
	0x5fa7: "<\t\u5fa7", // 徧
	0x5fa8: "<\t\u5fa8", // 徨
	0x5fa9: "<\t\u5fa9", // 復
	0x5faa: "<\t\u5faa", // 循
	0x5fab: "<\t\u5fab", // 徫
	0x5fac: "<\n\u5fac", // 徬
	0x5fad: "<\n\u5fad", // 徭
	0x5fae: "<\n\u5fae", // 微
	0x5faf: "<\n\u5faf", // 徯
	0x5fb0: "<\n\u5fb0", // 徰
	0x5fb1: "<\v\u5fb1", // 徱
	0x5fb2: "<\f\u5fb2", // 徲
	0x5fb3: "<\v\u5fb3", // 徳
	0x5fb4: "<\v\u5fb4", // 徴
	0x5fb5: "<\f\u5fb5", // 徵
	0x5fb6: "<\f\u5fb6", // 徶
	0x5fb7: "<\f\u5fb7", // 德
	0x5fb8: "<\f\u5fb8", // 徸
	0x5fb9: "<\f\u5fb9", // 徹
	0x5fba: "<\f\u5fba", // 徺
	0x5fbb: "<\r\u5fbb", // 徻
	0x5fbc: "<\r\u5fbc", // 徼
	0x5fbd: "<\x0e\u5fbd", // 徽
	0x5fbe: "<\x0e\u5fbe", // 徾
	0x5fbf: "<\x10\u5fbf", // 徿
	0x5fc0: "<\x11\u5fc0", // 忀
	0x5fc1: "<\x11\u5fc1", // 忁
	0x5fc2: "<\x12\u5fc2", // 忂
	0x5fc3: "=\x00\u5fc3", // 心
	0x5fc4: "=\x00\u5fc4", // 忄
	0x5fc5: "=\x01\u5fc5", // 必
	0x5fc6: "=\x01\u5fc6", // 忆
	0x5fc7: "=\x02\u5fc7", // 忇
	0x5fc8: "=\x02\u5fc8", // 忈
	0x5fc9: "=\x02\u5fc9", // 忉
	0x5fca: "=\x02\u5fca", // 忊
	0x5fcb: "=\x03\u5fcb", // 忋
	0x5fcc: "=\x03\u5fcc", // 忌
	0x5fcd: "=\x03\u5fcd", // 忍
	0x5fce: "=\x03\u5fce", // 忎
	0x5fcf: "=\x03\u5fcf", // 忏
	0x5fd0: "=\x03\u5fd0", // 忐
	0x5fd1: "=\x03\u5fd1", // 忑
	0x5fd2: "=\x03\u5fd2", // 忒
	0x5fd3: "=\x03\u5fd3", // 忓
	0x5fd4: "=\x03\u5fd4", // 忔
	0x5fd5: "=\x03\u5fd5", // 忕
	0x5fd6: "=\x03\u5fd6", // 忖
	0x5fd7: "=\x03\u5fd7", // 志
	0x5fd8: "=\x03\u5fd8", // 忘
	0x5fd9: "=\x03\u5fd9", // 忙
	0x5fda: "=\x03\u5fda", // 忚
	0x5fdb: "=\x03\u5fdb", // 忛
	0x5fdc: "=\x03\u5fdc", // 応
	0x5fdd: "=\x04\u5fdd", // 忝
	0x5fde: "=\x04\u5fde", // 忞
	0x5fdf: "=\x04\u5fdf", // 忟
	0x5fe0: "=\x04\u5fe0", // 忠
	0x5fe1: "=\x04\u5fe1", // 忡
	0x5fe2: "=\x04\u5fe2", // 忢
	0x5fe3: "=\x04\u5fe3", // 忣
	0x5fe4: "=\x04\u5fe4", // 忤
	0x5fe5: "=\x04\u5fe5", // 忥
	0x5fe6: "=\x04\u5fe6", // 忦
	0x5fe7: "=\x04\u5fe7", // 忧
	0x5fe8: "=\x04\u5fe8", // 忨
	0x5fe9: "=\x04\u5fe9", // 忩
	0x5fea: "=\x04\u5fea", // 忪
	0x5feb: "=\x04\u5feb", // 快
	0x5fec: "=\x04\u5fec", // 忬
	0x5fed: "=\x04\u5fed", // 忭
	0x5fee: "=\x04\u5fee", // 忮
	0x5fef: "=\x04\u5fef", // 忯
	0x5ff0: "=\x04\u5ff0", // 忰
	0x5ff1: "=\x04\u5ff1", // 忱
	0x5ff2: "=\x04\u5ff2", // 忲
	0x5ff3: "=\x04\u5ff3", // 忳
	0x5ff4: "=\x04\u5ff4", // 忴
	0x5ff5: "=\x04\u5ff5", // 念
	0x5ff6: "=\x04\u5ff6", // 忶
	0x5ff7: "=\x04\u5ff7", // 忷
	0x5ff8: "=\x04\u5ff8", // 忸
	0x5ff9: "=\x04\u5ff9", // 忹
	0x5ffa: "=\x04\u5ffa", // 忺
	0x5ffb: "=\x04\u5ffb", // 忻
	0x5ffc: "=\x04\u5ffc", // 忼
	0x5ffd: "=\x04\u5ffd", // 忽
	0x5ffe: "=\x04\u5ffe", // 忾
	0x5fff: "=\x04\u5fff", // 忿
	0x6000: "=\x04\u6000", // 怀
	0x6001: "=\x04\u6001", // 态
	0x6002: "=\x04\u6002", // 怂
	0x6003: "=\x04\u6003", // 怃
	0x6004: "=\x04\u6004", // 怄
	0x6005: "=\x04\u6005", // 怅
	0x6006: "=\x04\u6006", // 怆
	0x6007: "=\x05\u6007", // 怇
	0x6008: "=\x05\u6008", // 怈
	0x6009: "=\x05\u6009", // 怉
	0x600a: "=\x05\u600a", // 怊
	0x600b: "=\x05\u600b", // 怋
	0x600c: "=\x05\u600c", // 怌
	0x600d: "=\x05\u600d", // 怍
	0x600e: "=\x05\u600e", // 怎
	0x600f: "=\x05\u600f", // 怏
	0x6010: "=\x05\u6010", // 怐
	0x6011: "=\x05\u6011", // 怑
	0x6012: "=\x05\u6012", // 怒
	0x6013: "=\x05\u6013", // 怓
	0x6014: "=\x05\u6014", // 怔
	0x6015: "=\x05\u6015", // 怕
	0x6016: "=\x05\u6016", // 怖
	0x6017: "=\x05\u6017", // 怗
	0x6018: "=\x05\u6018", // 怘
	0x6019: "=\x05\u6019", // 怙
	0x601a: "=\x05\u601a", // 怚
	0x601b: "=\x05\u601b", // 怛
	0x601c: "=\x05\u601c", // 怜
	0x601d: "=\x05\u601d", // 思
	0x601e: "=\x05\u601e", // 怞
	0x601f: "=\x05\u601f", // 怟
	0x6020: "=\x05\u6020", // 怠
	0x6021: "=\x05\u6021", // 怡
	0x6022: "=\x05\u6022", // 怢
	0x6023: "=\x05\u6023", // 怣
	0x6024: "=\x05\u6024", // 怤
	0x6025: "=\x05\u6025", // 急
	0x6026: "=\x05\u6026", // 怦
	0x6027: "=\x05\u6027", // 性
	0x6028: "=\x05\u6028", // 怨
	0x6029: "=\x05\u6029", // 怩
	0x602a: "=\x05\u602a", // 怪
	0x602b: "=\x05\u602b", // 怫
	0x602c: "=\x05\u602c", // 怬
	0x602d: "=\x05\u602d", // 怭
	0x602e: "=\x05\u602e", // 怮
	0x602f: "=\x05\u602f", // 怯
	0x6030: "=\x05\u6030", // 怰
	0x6031: "=\x05\u6031", // 怱
	0x6032: "=\x05\u6032", // 怲
	0x6033: "=\x05\u6033", // 怳
	0x6034: "=\x05\u6034", // 怴
	0x6035: "=\x05\u6035", // 怵
	0x6036: "=\x05\u6036", // 怶
	0x6037: "=\x05\u6037", // 怷
	0x6038: "=\x05\u6038", // 怸
	0x6039: "=\x05\u6039", // 怹
	0x603a: "=\x05\u603a", // 怺
	0x603b: "=\x05\u603b", // 总
	0x603c: "=\x05\u603c", // 怼
	0x603d: "=\x05\u603d", // 怽
	0x603e: "=\x05\u603e", // 怾
	0x603f: "=\x05\u603f", // 怿
	0x6040: "=\x06\u6040", // 恀
	0x6041: "=\x06\u6041", // 恁
	0x6042: "=\x06\u6042", // 恂
	0x6043: "=\x06\u6043", // 恃
	0x6044: "=\x06\u6044", // 恄
	0x6045: "=\x06\u6045", // 恅
	0x6046: "=\x06\u6046", // 恆
	0x6047: "=\x06\u6047", // 恇
	0x6048: "=\x06\u6048", // 恈
	0x6049: "=\x06\u6049", // 恉
	0x604a: "=\x06\u604a", // 恊
	0x604b: "=\x06\u604b", // 恋
	0x604c: "=\x06\u604c", // 恌
	0x604d: "=\x06\u604d", // 恍
	0x604e: "=\x06\u604e", // 恎
	0x604f: "=\x06\u604f", // 恏
	0x6050: "=\x06\u6050", // 恐
	0x6051: "=\x06\u6051", // 恑
	0x6052: "=\x06\u6052", // 恒
	0x6053: "=\x06\u6053", // 恓
	0x6054: "=\x06\u6054", // 恔
	0x6055: "=\x06\u6055", // 恕
	0x6056: "=\x06\u6056", // 恖
	0x6057: "=\x06\u6057", // 恗
	0x6058: "=\x06\u6058", // 恘
	0x6059: "=\x06\u6059", // 恙
	0x605a: "=\x06\u605a", // 恚
	0x605b: "=\x06\u605b", // 恛
	0x605c: "=\x06\u605c", // 恜
	0x605d: "=\x06\u605d", // 恝
	0x605e: "=\x06\u605e", // 恞
	0x605f: "=\x06\u605f", // 恟
	0x6060: "=\x06\u6060", // 恠
	0x6061: "=\x06\u6061", // 恡
	0x6062: "=\x06\u6062", // 恢
	0x6063: "=\x06\u6063", // 恣
	0x6064: "=\x06\u6064", // 恤
	0x6065: "=\x06\u6065", // 恥
	0x6066: "=\x06\u6066", // 恦
	0x6067: "=\x06\u6067", // 恧
	0x6068: "=\x06\u6068", // 恨
	0x6069: "=\x06\u6069", // 恩
	0x606a: "=\x06\u606a", // 恪
	0x606b: "=\x06\u606b", // 恫
	0x606c: "=\x06\u606c", // 恬
	0x606d: "=\x06\u606d", // 恭
	0x606e: "=\x06\u606e", // 恮
	0x606f: "=\x06\u606f", // 息
	0x6070: "=\x06\u6070", // 恰
	0x6071: "=\x06\u6071", // 恱
	0x6072: "=\x06\u6072", // 恲
	0x6073: "=\x06\u6073", // 恳
	0x6074: "=\x06\u6074", // 恴
	0x6075: "=\x06\u6075", // 恵
	0x6076: "=\x06\u6076", // 恶
	0x6077: "=\x06\u6077", // 恷
	0x6078: "=\x06\u6078", // 恸
	0x6079: "=\x06\u6079", // 恹
	0x607a: "=\x06\u607a", // 恺
	0x607b: "=\x06\u607b", // 恻
	0x607c: "=\x06\u607c", // 恼
	0x607d: "=\x06\u607d", // 恽
	0x607e: "=\a\u607e", // 恾
	0x607f: "=\a\u607f", // 恿
	0x6080: "=\a\u6080", // 悀
	0x6081: "=\a\u6081", // 悁
	0x6082: "=\a\u6082", // 悂
	0x6083: "=\a\u6083", // 悃
	0x6084: "=\a\u6084", // 悄
	0x6085: "=\a\u6085", // 悅
	0x6086: "=\a\u6086", // 悆
	0x6087: "=\a\u6087", // 悇
	0x6088: "=\a\u6088", // 悈
	0x6089: "=\a\u6089", // 悉
	0x608a: "=\a\u608a", // 悊
	0x608b: "=\a\u608b", // 悋
	0x608c: "=\a\u608c", // 悌
	0x608d: "=\a\u608d", // 悍
	0x608e: "=\a\u608e", // 悎
	0x608f: "=\a\u608f", // 悏
	0x6090: "=\a\u6090", // 悐
	0x6091: "=\a\u6091", // 悑
	0x6092: "=\a\u6092", // 悒
	0x6093: "=\a\u6093", // 悓
	0x6094: "=\a\u6094", // 悔
	0x6095: "=\a\u6095", // 悕
	0x6096: "=\a\u6096", // 悖
	0x6097: "=\a\u6097", // 悗
	0x6098: "=\a\u6098", // 悘
	0x6099: "=\a\u6099", // 悙
	0x609a: "=\a\u609a", // 悚
	0x609b: "=\a\u609b", // 悛
	0x609c: "=\a\u609c", // 悜
	0x609d: "=\a\u609d", // 悝
	0x609e: "=\a\u609e", // 悞
	0x609f: "=\a\u609f", // 悟
	0x60a0: "=\a\u60a0", // 悠
	0x60a1: "=\a\u60a1", // 悡
	0x60a2: "=\a\u60a2", // 悢
	0x60a3: "=\a\u60a3", // 患
	0x60a4: "=\a\u60a4", // 悤
	0x60a5: "=\a\u60a5", // 悥
	0x60a6: "=\a\u60a6", // 悦
	0x60a7: "=\a\u60a7", // 悧
	0x60a8: "=\a\u60a8", // 您
	0x60a9: "=\a\u60a9", // 悩
	0x60aa: "=\a\u60aa", // 悪
	0x60ab: "=\a\u60ab", // 悫
	0x60ac: "=\a\u60ac", // 悬
	0x60ad: "=\a\u60ad", // 悭
	0x60ae: "=\a\u60ae", // 悮
	0x60af: "=\a\u60af", // 悯
	0x60b0: "=\b\u60b0", // 悰
	0x60b1: "=\b\u60b1", // 悱
	0x60b2: "=\b\u60b2", // 悲
	0x60b3: "=\b\u60b3", // 悳
	0x60b4: "=\b\u60b4", // 悴
	0x60b5: "=\b\u60b5", // 悵
	0x60b6: "=\b\u60b6", // 悶
	0x60b7: "=\b\u60b7", // 悷
	0x60b8: "=\b\u60b8", // 悸
	0x60b9: "=\b\u60b9", // 悹
	0x60ba: "=\b\u60ba", // 悺
	0x60bb: "=\b\u60bb", // 悻
	0x60bc: "=\b\u60bc", // 悼
	0x60bd: "=\b\u60bd", // 悽
	0x60be: "=\b\u60be", // 悾
	0x60bf: "=\b\u60bf", // 悿
	0x60c0: "=\b\u60c0", // 惀
	0x60c1: "=\b\u60c1", // 惁
	0x60c2: "=\b\u60c2", // 惂
	0x60c3: "=\b\u60c3", // 惃
	0x60c4: "=\b\u60c4", // 惄
	0x60c5: "=\b\u60c5", // 情
	0x60c6: "=\b\u60c6", // 惆
	0x60c7: "=\b\u60c7", // 惇
	0x60c8: "=\b\u60c8", // 惈
	0x60c9: "=\b\u60c9", // 惉
	0x60ca: "=\b\u60ca", // 惊
	0x60cb: "=\b\u60cb", // 惋
	0x60cc: "=\b\u60cc", // 惌
	0x60cd: "=\b\u60cd", // 惍
	0x60ce: "=\b\u60ce", // 惎
	0x60cf: "=\b\u60cf", // 惏
	0x60d0: "=\b\u60d0", // 惐
	0x60d1: "=\b\u60d1", // 惑
	0x60d2: "=\b\u60d2", // 惒
	0x60d3: "=\b\u60d3", // 惓
	0x60d4: "=\b\u60d4", // 惔
	0x60d5: "=\b\u60d5", // 惕
	0x60d6: "=\b\u60d6", // 惖
	0x60d7: "=\b\u60d7", // 惗
	0x60d8: "=\b\u60d8", // 惘
	0x60d9: "=\b\u60d9", // 惙
	0x60da: "=\b\u60da", // 惚
	0x60db: "=\b\u60db", // 惛
	0x60dc: "=\b\u60dc", // 惜
	0x60dd: "=\b\u60dd", // 惝
	0x60de: "=\b\u60de", // 惞
	0x60df: "=\b\u60df", // 惟
	0x60e0: "=\b\u60e0", // 惠
	0x60e1: "=\b\u60e1", // 惡
	0x60e2: "=\b\u60e2", // 惢
	0x60e3: "=\b\u60e3", // 惣
	0x60e4: "=\b\u60e4", // 惤
	0x60e5: "=\b\u60e5", // 惥
	0x60e6: "=\b\u60e6", // 惦
	0x60e7: "=\b\u60e7", // 惧
	0x60e8: "=\b\u60e8", // 惨
	0x60e9: "=\b\u60e9", // 惩
	0x60ea: "=\b\u60ea", // 惪
	0x60eb: "=\b\u60eb", // 惫
	0x60ec: "=\b\u60ec", // 惬
	0x60ed: "=\b\u60ed", // 惭
	0x60ee: "=\b\u60ee", // 惮
	0x60ef: "=\b\u60ef", // 惯
	0x60f0: "=\t\u60f0", // 惰
	0x60f1: "=\t\u60f1", // 惱
	0x60f2: "=\t\u60f2", // 惲
	0x60f3: "=\t\u60f3", // 想
	0x60f4: "=\t\u60f4", // 惴
	0x60f5: "=\t\u60f5", // 惵
	0x60f6: "=\t\u60f6", // 惶
	0x60f7: "=\t\u60f7", // 惷
	0x60f8: "=\t\u60f8", // 惸
	0x60f9: "=\t\u60f9", // 惹
	0x60fa: "=\t\u60fa", // 惺
	0x60fb: "=\t\u60fb", // 惻
	0x60fc: "=\t\u60fc", // 惼
	0x60fd: "=\t\u60fd", // 惽
	0x60fe: "=\t\u60fe", // 惾
	0x60ff: "=\t\u60ff", // 惿
	0x6100: "=\t\u6100", // 愀
	0x6101: "=\t\u6101", // 愁
	0x6102: "=\t\u6102", // 愂
	0x6103: "=\t\u6103", // 愃
	0x6104: "=\t\u6104", // 愄
	0x6105: "=\t\u6105", // 愅
	0x6106: "=\t\u6106", // 愆
	0x6107: "=\t\u6107", // 愇
	0x6108: "=\t\u6108", // 愈
	0x6109: "=\t\u6109", // 愉
	0x610a: "=\t\u610a", // 愊
	0x610b: "=\t\u610b", // 愋
	0x610c: "=\t\u610c", // 愌
	0x610d: "=\t\u610d", // 愍
	0x610e: "=\t\u610e", // 愎
	0x610f: "=\t\u610f", // 意
	0x6110: "=\t\u6110", // 愐
	0x6111: "=\t\u6111", // 愑
	0x6112: "=\t\u6112", // 愒
	0x6113: "=\t\u6113", // 愓
	0x6114: "=\t\u6114", // 愔
	0x6115: "=\t\u6115", // 愕
	0x6116: "=\t\u6116", // 愖
	0x6117: "=\t\u6117", // 愗
	0x6118: "=\t\u6118", // 愘
	0x6119: "=\t\u6119", // 愙
	0x611a: "=\t\u611a", // 愚
	0x611b: "=\t\u611b", // 愛
	0x611c: "=\t\u611c", // 愜
	0x611d: "=\t\u611d", // 愝
	0x611e: "=\t\u611e", // 愞
	0x611f: "=\t\u611f", // 感
	0x6120: "=\t\u6120", // 愠
	0x6121: "=\t\u6121", // 愡
	0x6122: "=\t\u6122", // 愢
	0x6123: "=\t\u6123", // 愣
	0x6124: "=\t\u6124", // 愤
	0x6125: "=\t\u6125", // 愥
	0x6126: "=\t\u6126", // 愦
	0x6127: "=\n\u6127", // 愧
	0x6128: "=\n\u6128", // 愨
	0x6129: "=\n\u6129", // 愩
	0x612a: "=\n\u612a", // 愪
	0x612b: "=\n\u612b", // 愫
	0x612c: "=\n\u612c", // 愬
	0x612d: "=\n\u612d", // 愭
	0x612e: "=\n\u612e", // 愮
	0x612f: "=\n\u612f", // 愯
	0x6130: "=\n\u6130", // 愰
	0x6131: "=\n\u6131", // 愱
	0x6132: "=\n\u6132", // 愲
	0x6133: "=\n\u6133", // 愳
	0x6134: "=\n\u6134", // 愴
	0x6135: "=\n\u6135", // 愵
	0x6136: "=\n\u6136", // 愶
	0x6137: "=\n\u6137", // 愷
	0x6138: "=\n\u6138", // 愸
	0x6139: "=\n\u6139", // 愹
	0x613a: "=\n\u613a", // 愺
	0x613b: "=\n\u613b", // 愻
	0x613c: "=\n\u613c", // 愼
	0x613d: "=\n\u613d", // 愽
	0x613e: "=\n\u613e", // 愾
	0x613f: "=\n\u613f", // 愿
	0x6140: "=\n\u6140", // 慀
	0x6141: "=\n\u6141", // 慁
	0x6142: "=\n\u6142", // 慂
	0x6143: "=\n\u6143", // 慃
	0x6144: "=\n\u6144", // 慄
	0x6145: "=\n\u6145", // 慅
	0x6146: "=\n\u6146", // 慆
	0x6147: "=\n\u6147", // 慇
	0x6148: "=\n\u6148", // 慈
	0x6149: "=\n\u6149", // 慉
	0x614a: "=\n\u614a", // 慊
	0x614b: "=\n\u614b", // 態
	0x614c: "=\n\u614c", // 慌
	0x614d: "=\n\u614d", // 慍
	0x614e: "=\n\u614e", // 慎
	0x614f: "=\n\u614f", // 慏
	0x6150: "=\n\u6150", // 慐
	0x6151: "=\n\u6151", // 慑
	0x6152: "=\v\u6152", // 慒
	0x6153: "=\v\u6153", // 慓
	0x6154: "=\v\u6154", // 慔
	0x6155: "=\v\u6155", // 慕
	0x6156: "=\v\u6156", // 慖
	0x6157: "=\v\u6157", // 慗
	0x6158: "=\v\u6158", // 慘
	0x6159: "=\v\u6159", // 慙
	0x615a: "=\v\u615a", // 慚
	0x615b: "=\v\u615b", // 慛
	0x615c: "=\v\u615c", // 慜
	0x615d: "=\v\u615d", // 慝
	0x615e: "=\v\u615e", // 慞
	0x615f: "=\v\u615f", // 慟
	0x6160: "=\v\u6160", // 慠
	0x6161: "=\v\u6161", // 慡
	0x6162: "=\v\u6162", // 慢
	0x6163: "=\v\u6163", // 慣
	0x6164: "=\v\u6164", // 慤
	0x6165: "=\v\u6165", // 慥
	0x6166: "=\v\u6166", // 慦
	0x6167: "=\v\u6167", // 慧
	0x6168: "=\t\u6168", // 慨
	0x6169: "=\v\u6169", // 慩
	0x616a: "=\v\u616a", // 慪
	0x616b: "=\v\u616b", // 慫
	0x616c: "=\v\u616c", // 慬
	0x616d: "=\f\u616d", // 慭
	0x616e: "=\v\u616e", // 慮
	0x616f: "=\v\u616f", // 慯
	0x6170: "=\v\u6170", // 慰
	0x6171: "=\v\u6171", // 慱
	0x6172: "=\v\u6172", // 慲
	0x6173: "=\v\u6173", // 慳
	0x6174: "=\v\u6174", // 慴
	0x6175: "=\v\u6175", // 慵
	0x6176: "=\v\u6176", // 慶
	0x6177: "=\v\u6177", // 慷
	0x6178: "=\v\u6178", // 慸
	0x6179: "=\v\u6179", // 慹
	0x617a: "=\v\u617a", // 慺
	0x617b: "=\v\u617b", // 慻
	0x617c: "=\v\u617c", // 慼
	0x617d: "=\v\u617d", // 慽
	0x617e: "=\v\u617e", // 慾
	0x617f: "=\v\u617f", // 慿
	0x6180: "=\v\u6180", // 憀
	0x6181: "=\v\u6181", // 憁
	0x6182: "=\v\u6182", // 憂
	0x6183: "=\v\u6183", // 憃
	0x6184: "=\v\u6184", // 憄
	0x6185: "=\v\u6185", // 憅
	0x6186: "=\v\u6186", // 憆
	0x6187: "=\v\u6187", // 憇
	0x6188: "=\v\u6188", // 憈
	0x6189: "=\f\u6189", // 憉
	0x618a: "=\f\u618a", // 憊
	0x618b: "=\f\u618b", // 憋
	0x618c: "=\f\u618c", // 憌
	0x618d: "=\f\u618d", // 憍
	0x618e: "=\f\u618e", // 憎
	0x618f: "=\f\u618f", // 憏
	0x6190: "=\f\u6190", // 憐
	0x6191: "=\f\u6191", // 憑
	0x6192: "=\f\u6192", // 憒
	0x6193: "=\f\u6193", // 憓
	0x6194: "=\f\u6194", // 憔
	0x6195: "=\f\u6195", // 憕
	0x6196: "=\f\u6196", // 憖
	0x6197: "=\f\u6197", // 憗
	0x6198: "=\f\u6198", // 憘
	0x6199: "=\f\u6199", // 憙
	0x619a: "=\f\u619a", // 憚
	0x619b: "=\f\u619b", // 憛
	0x619c: "=\f\u619c", // 憜
	0x619d: "=\f\u619d", // 憝
	0x619e: "=\f\u619e", // 憞
	0x619f: "=\f\u619f", // 憟
	0x61a0: "=\f\u61a0", // 憠
	0x61a1: "=\f\u61a1", // 憡
	0x61a2: "=\f\u61a2", // 憢
	0x61a3: "=\f\u61a3", // 憣
	0x61a4: "=\f\u61a4", // 憤
	0x61a5: "=\f\u61a5", // 憥
	0x61a6: "=\f\u61a6", // 憦
	0x61a7: "=\f\u61a7", // 憧
	0x61a8: "=\f\u61a8", // 憨
	0x61a9: "=\f\u61a9", // 憩
	0x61aa: "=\f\u61aa", // 憪
	0x61ab: "=\f\u61ab", // 憫
	0x61ac: "=\f\u61ac", // 憬
	0x61ad: "=\f\u61ad", // 憭
	0x61ae: "=\f\u61ae", // 憮
	0x61af: "=\f\u61af", // 憯
	0x61b0: "=\f\u61b0", // 憰
	0x61b1: "=\f\u61b1", // 憱
	0x61b2: "=\f\u61b2", // 憲
	0x61b3: "=\f\u61b3", // 憳
	0x61b4: "=\r\u61b4", // 憴
	0x61b5: "=\r\u61b5", // 憵
	0x61b6: "=\r\u61b6", // 憶
	0x61b7: "=\r\u61b7", // 憷
	0x61b8: "=\r\u61b8", // 憸
	0x61b9: "=\r\u61b9", // 憹
	0x61ba: "=\r\u61ba", // 憺
	0x61bb: "=\x0e\u61bb", // 憻
	0x61bc: "=\r\u61bc", // 憼
	0x61bd: "=\r\u61bd", // 憽
	0x61be: "=\r\u61be", // 憾
	0x61bf: "=\r\u61bf", // 憿
	0x61c0: "=\r\u61c0", // 懀
	0x61c1: "=\r\u61c1", // 懁
	0x61c2: "=\r\u61c2", // 懂
	0x61c3: "=\r\u61c3", // 懃
	0x61c4: "=\r\u61c4", // 懄
	0x61c5: "=\r\u61c5", // 懅
	0x61c6: "=\r\u61c6", // 懆
	0x61c7: "=\r\u61c7", // 懇
	0x61c8: "=\r\u61c8", // 懈
	0x61c9: "=\r\u61c9", // 應
	0x61ca: "=\r\u61ca", // 懊
	0x61cb: "=\r\u61cb", // 懋
	0x61cc: "=\r\u61cc", // 懌
	0x61cd: "=\r\u61cd", // 懍
	0x61ce: "=\r\u61ce", // 懎
	0x61cf: "=\r\u61cf", // 懏
	0x61d0: "=\r\u61d0", // 懐
	0x61d1: "=\r\u61d1", // 懑
	0x61d2: "=\r\u61d2", // 懒
	0x61d3: "=\r\u61d3", // 懓
	0x61d4: "=\r\u61d4", // 懔
	0x61d5: "=\x0e\u61d5", // 懕
	0x61d6: "=\x0e\u61d6", // 懖
	0x61d7: "=\x0e\u61d7", // 懗
	0x61d8: "=\x0e\u61d8", // 懘
	0x61d9: "=\x0e\u61d9", // 懙
	0x61da: "=\x0e\u61da", // 懚
	0x61db: "=\x0e\u61db", // 懛
	0x61dc: "=\x0e\u61dc", // 懜
	0x61dd: "=\x0e\u61dd", // 懝
	0x61de: "=\x0e\u61de", // 懞
	0x61df: "=\x0e\u61df", // 懟
	0x61e0: "=\x0e\u61e0", // 懠
	0x61e1: "=\x0e\u61e1", // 懡
	0x61e2: "=\x0e\u61e2", // 懢
	0x61e3: "=\x0e\u61e3", // 懣
	0x61e4: "=\x0e\u61e4", // 懤
	0x61e5: "=\x0e\u61e5", // 懥
	0x61e6: "=\x0e\u61e6", // 懦
	0x61e7: "=\x0e\u61e7", // 懧
	0x61e8: "=\x0e\u61e8", // 懨
	0x61e9: "=\x0f\u61e9", // 懩
	0x61ea: "=\x0f\u61ea", // 懪
	0x61eb: "=\x0f\u61eb", // 懫
	0x61ec: "=\x0f\u61ec", // 懬
	0x61ed: "=\x0f\u61ed", // 懭
	0x61ee: "=\x0f\u61ee", // 懮
	0x61ef: "=\x0f\u61ef", // 懯
	0x61f0: "=\x0f\u61f0", // 懰
	0x61f1: "=\x0f\u61f1", // 懱
	0x61f2: "=\x0f\u61f2", // 懲
	0x61f3: "=\x0f\u61f3", // 懳
	0x61f4: "=\x0f\u61f4", // 懴
	0x61f5: "=\x10\u61f5", // 懵
	0x61f6: "=\x10\u61f6", // 懶
	0x61f7: "=\x10\u61f7", // 懷
	0x61f8: "=\x10\u61f8", // 懸
	0x61f9: "=\x11\u61f9", // 懹
	0x61fa: "=\x11\u61fa", // 懺
	0x61fb: "=\x11\u61fb", // 懻
	0x61fc: "=\x12\u61fc", // 懼
	0x61fd: "=\x12\u61fd", // 懽
	0x61fe: "=\x12\u61fe", // 懾
	0x61ff: "=\x12\u61ff", // 懿
	0x6200: "=\x13\u6200", // 戀
	0x6201: "=\x13\u6201", // 戁
	0x6202: "=\x13\u6202", // 戂
	0x6203: "=\x14\u6203", // 戃
	0x6204: "=\x14\u6204", // 戄
	0x6205: "=\x15\u6205", // 戅
	0x6206: "=\x15\u6206", // 戆
	0x6207: "=\x18\u6207", // 戇
	0x6208: ">\x00\u6208", // 戈
	0x6209: ">\x01\u6209", // 戉
	0x620a: ">\x01\u620a", // 戊
	0x620b: ">\x01\u620b", // 戋
	0x620c: ">\x02\u620c", // 戌
	0x620d: ">\x02\u620d", // 戍
	0x620e: ">\x02\u620e", // 戎
	0x620f: ">\x02\u620f", // 戏
	0x6210: ">\x02\u6210", // 成
	0x6211: ">\x03\u6211", // 我
	0x6212: ">\x03\u6212", // 戒
	0x6213: ">\x03\u6213", // 戓
	0x6214: ">\x04\u6214", // 戔
	0x6215: ">\x04\u6215", // 戕
	0x6216: ">\x04\u6216", // 或
	0x6217: ">\x04\u6217", // 戗
	0x6218: ">\x05\u6218", // 战
	0x6219: ">\x06\u6219", // 戙
	0x621a: ">\a\u621a", // 戚
	0x621b: ">\a\u621b", // 戛
	0x621c: ">\a\u621c", // 戜
	0x621d: ">\a\u621d", // 戝
	0x621e: ">\b\u621e", // 戞
	0x621f: ">\b\u621f", // 戟
	0x6220: ">\t\u6220", // 戠
	0x6221: ">\t\u6221", // 戡
	0x6222: ">\t\u6222", // 戢
	0x6223: ">\t\u6223", // 戣
	0x6224: ">\t\u6224", // 戤
	0x6225: ">\t\u6225", // 戥
	0x6226: ">\b\u6226", // 戦
	0x6227: ">\n\u6227", // 戧
	0x6228: ">\n\u6228", // 戨
	0x6229: ">\n\u6229", // 戩
	0x622a: ">\n\u622a", // 截
	0x622b: ">\n\u622b", // 戫
	0x622c: ">\n\u622c", // 戬
	0x622d: ">\v\u622d", // 戭
	0x622e: ">\v\u622e", // 戮
	0x622f: ">\v\u622f", // 戯
	0x6230: ">\f\u6230", // 戰
	0x6231: ">\v\u6231", // 戱
	0x6232: ">\r\u6232", // 戲
	0x6233: ">\x0e\u6233", // 戳
	0x6234: ">\r\u6234", // 戴
	0x6235: ">\x12\u6235", // 戵
	0x6236: "?\x00\u6236", // 戶
	0x6237: "?\x00\u6237", // 户
	0x6238: "?\x00\u6238", // 戸
	0x6239: "?\x01\u6239", // 戹
	0x623a: "?\x03\u623a", // 戺
	0x623b: "?\x03\u623b", // 戻
	0x623c: "?\x03\u623c", // 戼
	0x623d: "?\x04\u623d", // 戽
	0x623e: "?\x04\u623e", // 戾
	0x623f: "?\x04\u623f", // 房
	0x6240: "?\x04\u6240", // 所
	0x6241: "?\x05\u6241", // 扁
	0x6242: "?\x05\u6242", // 扂
	0x6243: "?\x05\u6243", // 扃
	0x6244: "?\x06\u6244", // 扄
	0x6245: "?\x06\u6245", // 扅
	0x6246: "?\x06\u6246", // 扆
	0x6247: "?\x06\u6247", // 扇
	0x6248: "?\a\u6248", // 扈
	0x6249: "?\b\u6249", // 扉
	0x624a: "?\b\u624a", // 扊
	0x624b: "@\x00\u624b", // 手
	0x624c: "@\x00\u624c", // 扌
	0x624d: "@\x00\u624d", // 才
	0x624e: "@\x01\u624e", // 扎
	0x624f: "@\x03\u624f", // 扏
	0x6250: "@\x02\u6250", // 扐
	0x6251: "@\x02\u6251", // 扑
	0x6252: "@\x02\u6252", // 扒
	0x6253: "@\x02\u6253", // 打
	0x6254: "@\x02\u6254", // 扔
	0x6255: "@\x02\u6255", // 払
	0x6256: "@\x02\u6256", // 扖
	0x6257: "@\x03\u6257", // 扗
	0x6258: "@\x03\u6258", // 托
	0x6259: "@\x03\u6259", // 扙
	0x625a: "@\x03\u625a", // 扚
	0x625b: "@\x03\u625b", // 扛
	0x625c: "@\x03\u625c", // 扜
	0x625d: "@\x03\u625d", // 扝
	0x625e: "@\x03\u625e", // 扞
	0x625f: "@\x04\u625f", // 扟
	0x6260: "@\x03\u6260", // 扠
	0x6261: "@\x03\u6261", // 扡
	0x6262: "@\x03\u6262", // 扢
	0x6263: "@\x03\u6263", // 扣
	0x6264: "@\x03\u6264", // 扤
	0x6265: "@\x03\u6265", // 扥
	0x6266: "@\x03\u6266", // 扦
	0x6267: "@\x03\u6267", // 执
	0x6268: "@\x03\u6268", // 扨
	0x6269: "@\x03\u6269", // 扩
	0x626a: "@\x03\u626a", // 扪
	0x626b: "@\x03\u626b", // 扫
	0x626c: "@\x03\u626c", // 扬
	0x626d: "@\x04\u626d", // 扭
	0x626e: "@\x04\u626e", // 扮
	0x626f: "@\x04\u626f", // 扯
	0x6270: "@\x04\u6270", // 扰
	0x6271: "@\x04\u6271", // 扱
	0x6272: "@\x04\u6272", // 扲
	0x6273: "@\x04\u6273", // 扳
	0x6274: "@\x04\u6274", // 扴
	0x6275: "@\x04\u6275", // 扵
	0x6276: "@\x04\u6276", // 扶
	0x6277: "@\x04\u6277", // 扷
	0x6278: "@\x05\u6278", // 扸
	0x6279: "@\x04\u6279", // 批
	0x627a: "@\x04\u627a", // 扺
	0x627b: "@\x04\u627b", // 扻
	0x627c: "@\x04\u627c", // 扼
	0x627d: "@\x04\u627d", // 扽
	0x627e: "@\x04\u627e", // 找
	0x627f: "@\x04\u627f", // 承
	0x6280: "@\x04\u6280", // 技
	0x6281: "@\x04\u6281", // 抁
	0x6282: "@\x04\u6282", // 抂
	0x6283: "@\x04\u6283", // 抃
	0x6284: "@\x04\u6284", // 抄
	0x6285: "@\x04\u6285", // 抅
	0x6286: "@\x04\u6286", // 抆
	0x6287: "@\x04\u6287", // 抇
	0x6288: "@\x04\u6288", // 抈
	0x6289: "@\x04\u6289", // 抉
	0x628a: "@\x04\u628a", // 把
	0x628b: "@\x04\u628b", // 抋
	0x628c: "@\x04\u628c", // 抌
	0x628d: "@\x04\u628d", // 抍
	0x628e: "@\x04\u628e", // 抎
	0x628f: "@\x04\u628f", // 抏
	0x6290: "@\x04\u6290", // 抐
	0x6291: "@\x04\u6291", // 抑
	0x6292: "@\x04\u6292", // 抒
	0x6293: "@\x04\u6293", // 抓
	0x6294: "@\x04\u6294", // 抔
	0x6295: "@\x04\u6295", // 投
	0x6296: "@\x04\u6296", // 抖
	0x6297: "@\x04\u6297", // 抗
	0x6298: "@\x04\u6298", // 折
	0x6299: "@\x04\u6299", // 抙
	0x629a: "@\x04\u629a", // 抚
	0x629b: "@\x04\u629b", // 抛
	0x629c: "@\x04\u629c", // 抜
	0x629d: "@\x04\u629d", // 抝
	0x629e: "@\x04\u629e", // 択
	0x629f: "@\x04\u629f", // 抟
	0x62a0: "@\x04\u62a0", // 抠
	0x62a1: "@\x04\u62a1", // 抡
	0x62a2: "@\x04\u62a2", // 抢
	0x62a3: "@\x04\u62a3", // 抣
	0x62a4: "@\x04\u62a4", // 护
	0x62a5: "@\x04\u62a5", // 报
	0x62a6: "@\x05\u62a6", // 抦
	0x62a7: "@\x05\u62a7", // 抧
	0x62a8: "@\x05\u62a8", // 抨
	0x62a9: "@\x05\u62a9", // 抩
	0x62aa: "@\x05\u62aa", // 抪
	0x62ab: "@\x05\u62ab", // 披
	0x62ac: "@\x05\u62ac", // 抬
	0x62ad: "@\x05\u62ad", // 抭
	0x62ae: "@\x05\u62ae", // 抮
	0x62af: "@\x05\u62af", // 抯
	0x62b0: "@\x05\u62b0", // 抰
	0x62b1: "@\x05\u62b1", // 抱
	0x62b2: "@\x05\u62b2", // 抲
	0x62b3: "@\x05\u62b3", // 抳
	0x62b4: "@\x05\u62b4", // 抴
	0x62b5: "@\x05\u62b5", // 抵
	0x62b6: "@\x05\u62b6", // 抶
	0x62b7: "@\x05\u62b7", // 抷
	0x62b8: "@\x05\u62b8", // 抸
	0x62b9: "@\x05\u62b9", // 抹
	0x62ba: "@\x05\u62ba", // 抺
	0x62bb: "@\x05\u62bb", // 抻
	0x62bc: "@\x05\u62bc", // 押
	0x62bd: "@\x05\u62bd", // 抽
	0x62be: "@\x05\u62be", // 抾
	0x62bf: "@\x05\u62bf", // 抿
	0x62c0: "@\x05\u62c0", // 拀
	0x62c1: "@\x05\u62c1", // 拁
	0x62c2: "@\x05\u62c2", // 拂
	0x62c3: "@\x05\u62c3", // 拃
	0x62c4: "@\x05\u62c4", // 拄
	0x62c5: "@\x05\u62c5", // 担
	0x62c6: "@\x05\u62c6", // 拆
	0x62c7: "@\x05\u62c7", // 拇
	0x62c8: "@\x05\u62c8", // 拈
	0x62c9: "@\x05\u62c9", // 拉
	0x62ca: "@\x05\u62ca", // 拊
	0x62cb: "@\x05\u62cb", // 拋
	0x62cc: "@\x05\u62cc", // 拌
	0x62cd: "@\x05\u62cd", // 拍
	0x62ce: "@\x05\u62ce", // 拎
	0x62cf: "@\x05\u62cf", // 拏
	0x62d0: "@\x05\u62d0", // 拐
	0x62d1: "@\x05\u62d1", // 拑
	0x62d2: "@\x05\u62d2", // 拒
	0x62d3: "@\x05\u62d3", // 拓
	0x62d4: "@\x05\u62d4", // 拔
	0x62d5: "@\x05\u62d5", // 拕
	0x62d6: "@\x05\u62d6", // 拖
	0x62d7: "@\x05\u62d7", // 拗
	0x62d8: "@\x05\u62d8", // 拘
	0x62d9: "@\x05\u62d9", // 拙
	0x62da: "@\x05\u62da", // 拚
	0x62db: "@\x05\u62db", // 招
	0x62dc: "@\x05\u62dc", // 拜
	0x62dd: "@\x05\u62dd", // 拝
	0x62de: "@\x05\u62de", // 拞
	0x62df: "@\x05\u62df", // 拟
	0x62e0: "@\x05\u62e0", // 拠
	0x62e1: "@\x05\u62e1", // 拡
	0x62e2: "@\x05\u62e2", // 拢
	0x62e3: "@\x05\u62e3", // 拣
	0x62e4: "@\x05\u62e4", // 拤
	0x62e5: "@\x05\u62e5", // 拥
	0x62e6: "@\x05\u62e6", // 拦
	0x62e7: "@\x05\u62e7", // 拧
	0x62e8: "@\x05\u62e8", // 拨
	0x62e9: "@\x05\u62e9", // 择
	0x62ea: "@\x06\u62ea", // 拪
	0x62eb: "@\x06\u62eb", // 拫
	0x62ec: "@\x06\u62ec", // 括
	0x62ed: "@\x06\u62ed", // 拭
	0x62ee: "@\x06\u62ee", // 拮
	0x62ef: "@\x06\u62ef", // 拯
	0x62f0: "@\x06\u62f0", // 拰
	0x62f1: "@\x06\u62f1", // 拱
	0x62f2: "@\x06\u62f2", // 拲
	0x62f3: "@\x06\u62f3", // 拳
	0x62f4: "@\x06\u62f4", // 拴
	0x62f5: "@\x06\u62f5", // 拵
	0x62f6: "@\x06\u62f6", // 拶
	0x62f7: "@\x06\u62f7", // 拷
	0x62f8: "@\x06\u62f8", // 拸
	0x62f9: "@\x06\u62f9", // 拹
	0x62fa: "@\x06\u62fa", // 拺
	0x62fb: "@\x06\u62fb", // 拻
	0x62fc: "@\x06\u62fc", // 拼
	0x62fd: "@\x06\u62fd", // 拽
	0x62fe: "@\x06\u62fe", // 拾
	0x62ff: "@\x06\u62ff", // 拿
	0x6300: "@\x06\u6300", // 挀
	0x6301: "@\x06\u6301", // 持
	0x6302: "@\x06\u6302", // 挂
	0x6303: "@\x06\u6303", // 挃
	0x6304: "@\x06\u6304", // 挄
	0x6305: "@\x06\u6305", // 挅
	0x6306: "@\x06\u6306", // 挆
	0x6307: "@\x06\u6307", // 指
	0x6308: "@\x06\u6308", // 挈
	0x6309: "@\x06\u6309", // 按
	0x630a: "@\x06\u630a", // 挊
	0x630b: "@\x06\u630b", // 挋
	0x630c: "@\x06\u630c", // 挌
	0x630d: "@\x06\u630d", // 挍
	0x630e: "@\x06\u630e", // 挎
	0x630f: "@\x06\u630f", // 挏
	0x6310: "@\x06\u6310", // 挐
	0x6311: "@\x06\u6311", // 挑
	0x6312: "@\x06\u6312", // 挒
	0x6313: "@\x06\u6313", // 挓
	0x6314: "@\x06\u6314", // 挔
	0x6315: "@\x06\u6315", // 挕
	0x6316: "@\x06\u6316", // 挖
	0x6317: "@\x06\u6317", // 挗
	0x6318: "@\x06\u6318", // 挘
	0x6319: "@\x06\u6319", // 挙
	0x631a: "@\x06\u631a", // 挚
	0x631b: "@\x06\u631b", // 挛
	0x631c: "@\x06\u631c", // 挜
	0x631d: "@\x06\u631d", // 挝
	0x631e: "@\x06\u631e", // 挞
	0x631f: "@\x06\u631f", // 挟
	0x6320: "@\x06\u6320", // 挠
	0x6321: "@\x06\u6321", // 挡
	0x6322: "@\x06\u6322", // 挢
	0x6323: "@\x06\u6323", // 挣
	0x6324: "@\x06\u6324", // 挤
	0x6325: "@\x06\u6325", // 挥
	0x6326: "@\x06\u6326", // 挦
	0x6327: "@\x06\u6327", // 挧
	0x6328: "@\a\u6328", // 挨
	0x6329: "@\a\u6329", // 挩
	0x632a: "@\a\u632a", // 挪
	0x632b: "@\a\u632b", // 挫
	0x632c: "@\a\u632c", // 挬
	0x632d: "@\a\u632d", // 挭
	0x632e: "@\a\u632e", // 挮
	0x632f: "@\a\u632f", // 振
	0x6330: "@\a\u6330", // 挰
	0x6331: "@\a\u6331", // 挱
	0x6332: "@\a\u6332", // 挲
	0x6333: "@\a\u6333", // 挳
	0x6334: "@\a\u6334", // 挴
	0x6335: "@\a\u6335", // 挵
	0x6336: "@\a\u6336", // 挶
	0x6337: "@\a\u6337", // 挷
	0x6338: "@\a\u6338", // 挸
	0x6339: "@\a\u6339", // 挹
	0x633a: "@\a\u633a", // 挺
	0x633b: "@\a\u633b", // 挻
	0x633c: "@\a\u633c", // 挼
	0x633d: "@\a\u633d", // 挽
	0x633e: "@\a\u633e", // 挾
	0x633f: "@\a\u633f", // 挿
	0x6340: "@\a\u6340", // 捀
	0x6341: "@\a\u6341", // 捁
	0x6342: "@\a\u6342", // 捂
	0x6343: "@\a\u6343", // 捃
	0x6344: "@\a\u6344", // 捄
	0x6345: "@\a\u6345", // 捅
	0x6346: "@\a\u6346", // 捆
	0x6347: "@\a\u6347", // 捇
	0x6348: "@\a\u6348", // 捈
	0x6349: "@\a\u6349", // 捉
	0x634a: "@\a\u634a", // 捊
	0x634b: "@\a\u634b", // 捋
	0x634c: "@\a\u634c", // 捌
	0x634d: "@\a\u634d", // 捍
	0x634e: "@\a\u634e", // 捎
	0x634f: "@\a\u634f", // 捏
	0x6350: "@\a\u6350", // 捐
	0x6351: "@\a\u6351", // 捑
	0x6352: "@\a\u6352", // 捒
	0x6353: "@\a\u6353", // 捓
	0x6354: "@\a\u6354", // 捔
	0x6355: "@\a\u6355", // 捕
	0x6356: "@\a\u6356", // 捖
	0x6357: "@\a\u6357", // 捗
	0x6358: "@\a\u6358", // 捘
	0x6359: "@\a\u6359", // 捙
	0x635a: "@\a\u635a", // 捚
	0x635b: "@\a\u635b", // 捛
	0x635c: "@\a\u635c", // 捜
	0x635d: "@\a\u635d", // 捝
	0x635e: "@\a\u635e", // 捞
	0x635f: "@\a\u635f", // 损
	0x6360: "@\a\u6360", // 捠
	0x6361: "@\a\u6361", // 捡
	0x6362: "@\a\u6362", // 换
	0x6363: "@\a\u6363", // 捣
	0x6364: "@\a\u6364", // 捤
	0x6365: "@\b\u6365", // 捥
	0x6366: "@\b\u6366", // 捦
	0x6367: "@\b\u6367", // 捧
	0x6368: "@\b\u6368", // 捨
	0x6369: "@\b\u6369", // 捩
	0x636a: "@\b\u636a", // 捪
	0x636b: "@\b\u636b", // 捫
	0x636c: "@\b\u636c", // 捬
	0x636d: "@\b\u636d", // 捭
	0x636e: "@\b\u636e", // 据
	0x636f: "@\b\u636f", // 捯
	0x6370: "@\b\u6370", // 捰
	0x6371: "@\b\u6371", // 捱
	0x6372: "@\b\u6372", // 捲
	0x6373: "@\b\u6373", // 捳
	0x6374: "@\b\u6374", // 捴
	0x6375: "@\b\u6375", // 捵
	0x6376: "@\b\u6376", // 捶
	0x6377: "@\b\u6377", // 捷
	0x6378: "@\b\u6378", // 捸
	0x6379: "@\b\u6379", // 捹
	0x637a: "@\b\u637a", // 捺
	0x637b: "@\b\u637b", // 捻
	0x637c: "@\b\u637c", // 捼
	0x637d: "@\b\u637d", // 捽
	0x637e: "@\b\u637e", // 捾
	0x637f: "@\b\u637f", // 捿
	0x6380: "@\b\u6380", // 掀
	0x6381: "@\b\u6381", // 掁
	0x6382: "@\b\u6382", // 掂
	0x6383: "@\b\u6383", // 掃
	0x6384: "@\b\u6384", // 掄
	0x6385: "@\b\u6385", // 掅
	0x6386: "@\b\u6386", // 掆
	0x6387: "@\b\u6387", // 掇
	0x6388: "@\b\u6388", // 授
	0x6389: "@\b\u6389", // 掉
	0x638a: "@\b\u638a", // 掊
	0x638b: "@\b\u638b", // 掋
	0x638c: "@\b\u638c", // 掌
	0x638d: "@\b\u638d", // 掍
	0x638e: "@\b\u638e", // 掎
	0x638f: "@\b\u638f", // 掏
	0x6390: "@\b\u6390", // 掐
	0x6391: "@\b\u6391", // 掑
	0x6392: "@\b\u6392", // 排
	0x6393: "@\b\u6393", // 掓
	0x6394: "@\b\u6394", // 掔
	0x6395: "@\b\u6395", // 掕
	0x6396: "@\b\u6396", // 掖
	0x6397: "@\b\u6397", // 掗
	0x6398: "@\b\u6398", // 掘
	0x6399: "@\b\u6399", // 掙
	0x639a: "@\b\u639a", // 掚
	0x639b: "@\b\u639b", // 掛
	0x639c: "@\b\u639c", // 掜
	0x639d: "@\b\u639d", // 掝
	0x639e: "@\b\u639e", // 掞
	0x639f: "@\b\u639f", // 掟
	0x63a0: "@\b\u63a0", // 掠
	0x63a1: "@\b\u63a1", // 採
	0x63a2: "@\b\u63a2", // 探
	0x63a3: "@\b\u63a3", // 掣
	0x63a4: "@\b\u63a4", // 掤
	0x63a5: "@\b\u63a5", // 接
	0x63a6: "@\b\u63a6", // 掦
	0x63a7: "@\b\u63a7", // 控
	0x63a8: "@\b\u63a8", // 推
	0x63a9: "@\b\u63a9", // 掩
	0x63aa: "@\b\u63aa", // 措
	0x63ab: "@\b\u63ab", // 掫
	0x63ac: "@\b\u63ac", // 掬
	0x63ad: "@\b\u63ad", // 掭
	0x63ae: "@\b\u63ae", // 掮
	0x63af: "@\b\u63af", // 掯
	0x63b0: "@\b\u63b0", // 掰
	0x63b1: "@\b\u63b1", // 掱
	0x63b2: "@\t\u63b2", // 掲
	0x63b3: "@\b\u63b3", // 掳
	0x63b4: "@\b\u63b4", // 掴
	0x63b5: "@\b\u63b5", // 掵
	0x63b6: "@\b\u63b6", // 掶
	0x63b7: "@\b\u63b7", // 掷
	0x63b8: "@\b\u63b8", // 掸
	0x63b9: "@\b\u63b9", // 掹
	0x63ba: "@\b\u63ba", // 掺
	0x63bb: "@\b\u63bb", // 掻
	0x63bc: "@\b\u63bc", // 掼
	0x63bd: "@\b\u63bd", // 掽
	0x63be: "@\t\u63be", // 掾
	0x63bf: "@\t\u63bf", // 掿
	0x63c0: "@\t\u63c0", // 揀
	0x63c1: "@\t\u63c1", // 揁
	0x63c2: "@\t\u63c2", // 揂
	0x63c3: "@\t\u63c3", // 揃
	0x63c4: "@\t\u63c4", // 揄
	0x63c5: "@\v\u63c5", // 揅
	0x63c6: "@\t\u63c6", // 揆
	0x63c7: "@\t\u63c7", // 揇
	0x63c8: "@\t\u63c8", // 揈
	0x63c9: "@\t\u63c9", // 揉
	0x63ca: "@\t\u63ca", // 揊
	0x63cb: "@\t\u63cb", // 揋
	0x63cc: "@\t\u63cc", // 揌
	0x63cd: "@\t\u63cd", // 揍
	0x63ce: "@\t\u63ce", // 揎
	0x63cf: "@\t\u63cf", // 描
	0x63d0: "@\t\u63d0", // 提
	0x63d1: "@\t\u63d1", // 揑
	0x63d2: "@\t\u63d2", // 插
	0x63d3: "@\t\u63d3", // 揓
	0x63d4: "@\t\u63d4", // 揔
	0x63d5: "@\t\u63d5", // 揕
	0x63d6: "@\t\u63d6", // 揖
	0x63d7: "@\t\u63d7", // 揗
	0x63d8: "@\t\u63d8", // 揘
	0x63d9: "@\t\u63d9", // 揙
	0x63da: "@\t\u63da", // 揚
	0x63db: "@\t\u63db", // 換
	0x63dc: "@\t\u63dc", // 揜
	0x63dd: "@\t\u63dd", // 揝
	0x63de: "@\t\u63de", // 揞
	0x63df: "@\t\u63df", // 揟
	0x63e0: "@\t\u63e0", // 揠
	0x63e1: "@\t\u63e1", // 握
	0x63e2: "@\t\u63e2", // 揢
	0x63e3: "@\t\u63e3", // 揣
	0x63e4: "@\t\u63e4", // 揤
	0x63e5: "@\t\u63e5", // 揥
	0x63e6: "@\t\u63e6", // 揦
	0x63e7: "@\t\u63e7", // 揧
	0x63e8: "@\t\u63e8", // 揨
	0x63e9: "@\t\u63e9", // 揩
	0x63ea: "@\t\u63ea", // 揪
	0x63eb: "@\t\u63eb", // 揫
	0x63ec: "@\t\u63ec", // 揬
	0x63ed: "@\t\u63ed", // 揭
	0x63ee: "@\t\u63ee", // 揮
	0x63ef: "@\t\u63ef", // 揯
	0x63f0: "@\t\u63f0", // 揰
	0x63f1: "@\t\u63f1", // 揱
	0x63f2: "@\t\u63f2", // 揲
	0x63f3: "@\t\u63f3", // 揳
	0x63f4: "@\t\u63f4", // 援
	0x63f5: "@\t\u63f5", // 揵
	0x63f6: "@\t\u63f6", // 揶
	0x63f7: "@\t\u63f7", // 揷
	0x63f8: "@\t\u63f8", // 揸
	0x63f9: "@\t\u63f9", // 揹
	0x63fa: "@\t\u63fa", // 揺
	0x63fb: "@\t\u63fb", // 揻
	0x63fc: "@\t\u63fc", // 揼
	0x63fd: "@\t\u63fd", // 揽
	0x63fe: "@\t\u63fe", // 揾
	0x63ff: "@\t\u63ff", // 揿
	0x6400: "@\t\u6400", // 搀
	0x6401: "@\t\u6401", // 搁
	0x6402: "@\t\u6402", // 搂
	0x6403: "@\t\u6403", // 搃
	0x6404: "@\t\u6404", // 搄
	0x6405: "@\t\u6405", // 搅
	0x6406: "@\n\u6406", // 搆
	0x6407: "@\n\u6407", // 搇
	0x6408: "@\n\u6408", // 搈
	0x6409: "@\n\u6409", // 搉
	0x640a: "@\n\u640a", // 搊
	0x640b: "@\n\u640b", // 搋
	0x640c: "@\n\u640c", // 搌
	0x640d: "@\n\u640d", // 損
	0x640e: "@\n\u640e", // 搎
	0x640f: "@\n\u640f", // 搏
	0x6410: "@\n\u6410", // 搐
	0x6411: "@\n\u6411", // 搑
	0x6412: "@\n\u6412", // 搒
	0x6413: "@\n\u6413", // 搓
	0x6414: "@\n\u6414", // 搔
	0x6415: "@\n\u6415", // 搕
	0x6416: "@\n\u6416", // 搖
	0x6417: "@\n\u6417", // 搗
	0x6418: "@\n\u6418", // 搘
	0x6419: "@\n\u6419", // 搙
	0x641a: "@\n\u641a", // 搚
	0x641b: "@\n\u641b", // 搛
	0x641c: "@\n\u641c", // 搜
	0x641d: "@\n\u641d", // 搝
	0x641e: "@\n\u641e", // 搞
	0x641f: "@\n\u641f", // 搟
	0x6420: "@\n\u6420", // 搠
	0x6421: "@\n\u6421", // 搡
	0x6422: "@\n\u6422", // 搢
	0x6423: "@\n\u6423", // 搣
	0x6424: "@\n\u6424", // 搤
	0x6425: "@\n\u6425", // 搥
	0x6426: "@\n\u6426", // 搦
	0x6427: "@\n\u6427", // 搧
	0x6428: "@\n\u6428", // 搨
	0x6429: "@\n\u6429", // 搩
	0x642a: "@\n\u642a", // 搪
	0x642b: "@\n\u642b", // 搫
	0x642c: "@\n\u642c", // 搬
	0x642d: "@\n\u642d", // 搭
	0x642e: "@\n\u642e", // 搮
	0x642f: "@\n\u642f", // 搯
	0x6430: "@\n\u6430", // 搰
	0x6431: "@\f\u6431", // 搱
	0x6432: "@\n\u6432", // 搲
	0x6433: "@\n\u6433", // 搳
	0x6434: "@\n\u6434", // 搴
	0x6435: "@\n\u6435", // 搵
	0x6436: "@\n\u6436", // 搶
	0x6437: "@\n\u6437", // 搷
	0x6438: "@\n\u6438", // 搸
	0x6439: "@\n\u6439", // 搹
	0x643a: "@\n\u643a", // 携
	0x643b: "@\n\u643b", // 搻
	0x643c: "@\n\u643c", // 搼
	0x643d: "@\n\u643d", // 搽
	0x643e: "@\n\u643e", // 搾
	0x643f: "@\n\u643f", // 搿
	0x6440: "@\n\u6440", // 摀
	0x6441: "@\n\u6441", // 摁
	0x6442: "@\n\u6442", // 摂
	0x6443: "@\n\u6443", // 摃
	0x6444: "@\n\u6444", // 摄
	0x6445: "@\n\u6445", // 摅
	0x6446: "@\n\u6446", // 摆
	0x6447: "@\n\u6447", // 摇
	0x6448: "@\n\u6448", // 摈
	0x6449: "@\n\u6449", // 摉
	0x644a: "@\n\u644a", // 摊
	0x644b: "@\v\u644b", // 摋
	0x644c: "@\v\u644c", // 摌
	0x644d: "@\v\u644d", // 摍
	0x644e: "@\v\u644e", // 摎
	0x644f: "@\v\u644f", // 摏
	0x6450: "@\v\u6450", // 摐
	0x6451: "@\v\u6451", // 摑
	0x6452: "@\t\u6452", // 摒
	0x6453: "@\v\u6453", // 摓
	0x6454: "@\v\u6454", // 摔
	0x6455: "@\v\u6455", // 摕
	0x6456: "@\f\u6456", // 摖
	0x6457: "@\v\u6457", // 摗
	0x6458: "@\v\u6458", // 摘
	0x6459: "@\v\u6459", // 摙
	0x645a: "@\v\u645a", // 摚
	0x645b: "@\v\u645b", // 摛
	0x645c: "@\v\u645c", // 摜
	0x645d: "@\v\u645d", // 摝
	0x645e: "@\v\u645e", // 摞
	0x645f: "@\v\u645f", // 摟
	0x6460: "@\v\u6460", // 摠
	0x6461: "@\v\u6461", // 摡
	0x6462: "@\v\u6462", // 摢
	0x6463: "@\v\u6463", // 摣
	0x6464: "@\v\u6464", // 摤
	0x6465: "@\v\u6465", // 摥
	0x6466: "@\v\u6466", // 摦
	0x6467: "@\v\u6467", // 摧
	0x6468: "@\v\u6468", // 摨
	0x6469: "@\v\u6469", // 摩
	0x646a: "@\v\u646a", // 摪
	0x646b: "@\v\u646b", // 摫
	0x646c: "@\v\u646c", // 摬
	0x646d: "@\v\u646d", // 摭
	0x646e: "@\v\u646e", // 摮
	0x646f: "@\v\u646f", // 摯
	0x6470: "@\v\u6470", // 摰
	0x6471: "@\v\u6471", // 摱
	0x6472: "@\v\u6472", // 摲
	0x6473: "@\v\u6473", // 摳
	0x6474: "@\v\u6474", // 摴
	0x6475: "@\v\u6475", // 摵
	0x6476: "@\v\u6476", // 摶
	0x6477: "@\v\u6477", // 摷
	0x6478: "@\v\u6478", // 摸
	0x6479: "@\v\u6479", // 摹
	0x647a: "@\v\u647a", // 摺
	0x647b: "@\v\u647b", // 摻
	0x647c: "@\v\u647c", // 摼
	0x647d: "@\v\u647d", // 摽
	0x647e: "@\v\u647e", // 摾
	0x647f: "@\v\u647f", // 摿
	0x6480: "@\v\u6480", // 撀
	0x6481: "@\v\u6481", // 撁
	0x6482: "@\v\u6482", // 撂
	0x6483: "@\v\u6483", // 撃
	0x6484: "@\v\u6484", // 撄
	0x6485: "@\f\u6485", // 撅
	0x6486: "@\f\u6486", // 撆
	0x6487: "@\v\u6487", // 撇
	0x6488: "@\f\u6488", // 撈
	0x6489: "@\f\u6489", // 撉
	0x648a: "@\f\u648a", // 撊
	0x648b: "@\f\u648b", // 撋
	0x648c: "@\f\u648c", // 撌
	0x648d: "@\f\u648d", // 撍
	0x648e: "@\f\u648e", // 撎
	0x648f: "@\f\u648f", // 撏
	0x6490: "@\f\u6490", // 撐
	0x6491: "@\f\u6491", // 撑
	0x6492: "@\f\u6492", // 撒
	0x6493: "@\f\u6493", // 撓
	0x6494: "@\f\u6494", // 撔
	0x6495: "@\f\u6495", // 撕
	0x6496: "@\f\u6496", // 撖
	0x6497: "@\f\u6497", // 撗
	0x6498: "@\f\u6498", // 撘
	0x6499: "@\f\u6499", // 撙
	0x649a: "@\f\u649a", // 撚
	0x649b: "@\f\u649b", // 撛
	0x649c: "@\f\u649c", // 撜
	0x649d: "@\f\u649d", // 撝
	0x649e: "@\f\u649e", // 撞
	0x649f: "@\f\u649f", // 撟
	0x64a0: "@\f\u64a0", // 撠
	0x64a1: "@\f\u64a1", // 撡
	0x64a2: "@\f\u64a2", // 撢
	0x64a3: "@\f\u64a3", // 撣
	0x64a4: "@\f\u64a4", // 撤
	0x64a5: "@\f\u64a5", // 撥
	0x64a6: "@\f\u64a6", // 撦
	0x64a7: "@\f\u64a7", // 撧
	0x64a8: "@\f\u64a8", // 撨
	0x64a9: "@\f\u64a9", // 撩
	0x64aa: "@\f\u64aa", // 撪
	0x64ab: "@\f\u64ab", // 撫
	0x64ac: "@\f\u64ac", // 撬
	0x64ad: "@\f\u64ad", // 播
	0x64ae: "@\f\u64ae", // 撮
	0x64af: "@\f\u64af", // 撯
	0x64b0: "@\f\u64b0", // 撰
	0x64b1: "@\f\u64b1", // 撱
	0x64b2: "@\f\u64b2", // 撲
	0x64b3: "@\f\u64b3", // 撳
	0x64b4: "@\f\u64b4", // 撴
	0x64b5: "@\f\u64b5", // 撵
	0x64b6: "@\f\u64b6", // 撶
	0x64b7: "@\f\u64b7", // 撷
	0x64b8: "@\f\u64b8", // 撸
	0x64b9: "@\f\u64b9", // 撹
	0x64ba: "@\f\u64ba", // 撺
	0x64bb: "@\r\u64bb", // 撻
	0x64bc: "@\r\u64bc", // 撼
	0x64bd: "@\r\u64bd", // 撽
	0x64be: "@\r\u64be", // 撾
	0x64bf: "@\r\u64bf", // 撿
	0x64c0: "@\r\u64c0", // 擀
	0x64c1: "@\r\u64c1", // 擁
	0x64c2: "@\r\u64c2", // 擂
	0x64c3: "@\r\u64c3", // 擃
	0x64c4: "@\r\u64c4", // 擄
	0x64c5: "@\r\u64c5", // 擅
	0x64c6: "@\f\u64c6", // 擆
	0x64c7: "@\r\u64c7", // 擇
	0x64c8: "@\r\u64c8", // 擈
	0x64c9: "@\r\u64c9", // 擉
	0x64ca: "@\r\u64ca", // 擊
	0x64cb: "@\r\u64cb", // 擋
	0x64cc: "@\r\u64cc", // 擌
	0x64cd: "@\r\u64cd", // 操
	0x64ce: "@\r\u64ce", // 擎
	0x64cf: "@\r\u64cf", // 擏
	0x64d0: "@\r\u64d0", // 擐
	0x64d1: "@\r\u64d1", // 擑
	0x64d2: "@\r\u64d2", // 擒
	0x64d3: "@\r\u64d3", // 擓
	0x64d4: "@\r\u64d4", // 擔
	0x64d5: "@\r\u64d5", // 擕
	0x64d6: "@\r\u64d6", // 擖
	0x64d7: "@\r\u64d7", // 擗
	0x64d8: "@\r\u64d8", // 擘
	0x64d9: "@\r\u64d9", // 擙
	0x64da: "@\r\u64da", // 據
	0x64db: "@\r\u64db", // 擛
	0x64dc: "@\r\u64dc", // 擜
	0x64dd: "@\r\u64dd", // 擝
	0x64de: "@\r\u64de", // 擞
	0x64df: "@\x0e\u64df", // 擟
	0x64e0: "@\x0e\u64e0", // 擠
	0x64e1: "@\x0e\u64e1", // 擡
	0x64e2: "@\x0e\u64e2", // 擢
	0x64e3: "@\x0e\u64e3", // 擣
	0x64e4: "@\x0e\u64e4", // 擤
	0x64e5: "@\x0f\u64e5", // 擥
	0x64e6: "@\x0e\u64e6", // 擦
	0x64e7: "@\x0e\u64e7", // 擧
	0x64e8: "@\x0e\u64e8", // 擨
	0x64e9: "@\x0e\u64e9", // 擩
	0x64ea: "@\x0e\u64ea", // 擪
	0x64eb: "@\x0e\u64eb", // 擫
	0x64ec: "@\x0e\u64ec", // 擬
	0x64ed: "@\x0e\u64ed", // 擭
	0x64ee: "@\x0e\u64ee", // 擮
	0x64ef: "@\x0e\u64ef", // 擯
	0x64f0: "@\x0e\u64f0", // 擰
	0x64f1: "@\x0e\u64f1", // 擱
	0x64f2: "@\x0f\u64f2", // 擲
	0x64f3: "@\x0f\u64f3", // 擳
	0x64f4: "@\x0f\u64f4", // 擴
	0x64f5: "@\x0f\u64f5", // 擵
	0x64f6: "@\x0f\u64f6", // 擶
	0x64f7: "@\x0f\u64f7", // 擷
	0x64f8: "@\x0f\u64f8", // 擸
	0x64f9: "@\x0f\u64f9", // 擹
	0x64fa: "@\x0f\u64fa", // 擺
	0x64fb: "@\x0f\u64fb", // 擻
	0x64fc: "@\x0f\u64fc", // 擼
	0x64fd: "@\x0f\u64fd", // 擽
	0x64fe: "@\x0f\u64fe", // 擾
	0x64ff: "@\x0f\u64ff", // 擿
	0x6500: "@\x0f\u6500", // 攀
	0x6501: "@\x0f\u6501", // 攁
	0x6502: "@\x0f\u6502", // 攂
	0x6503: "@\x0f\u6503", // 攃
	0x6504: "@\x0f\u6504", // 攄
	0x6505: "@\x0f\u6505", // 攅
	0x6506: "@\x0f\u6506", // 攆
	0x6507: "@\x10\u6507", // 攇
	0x6508: "@\x10\u6508", // 攈
	0x6509: "@\x10\u6509", // 攉
	0x650a: "@\x10\u650a", // 攊
	0x650b: "@\x10\u650b", // 攋
	0x650c: "@\x10\u650c", // 攌
	0x650d: "@\x10\u650d", // 攍
	0x650e: "@\x10\u650e", // 攎
	0x650f: "@\x10\u650f", // 攏
	0x6510: "@\x10\u6510", // 攐
	0x6511: "@\x11\u6511", // 攑
	0x6512: "@\x10\u6512", // 攒
	0x6513: "@\x11\u6513", // 攓
	0x6514: "@\x11\u6514", // 攔
	0x6515: "@\x11\u6515", // 攕
	0x6516: "@\x11\u6516", // 攖
	0x6517: "@\x11\u6517", // 攗
	0x6518: "@\x11\u6518", // 攘
	0x6519: "@\x11\u6519", // 攙
	0x651a: "@\x11\u651a", // 攚
	0x651b: "@\x12\u651b", // 攛
	0x651c: "@\x12\u651c", // 攜
	0x651d: "@\x12\u651d", // 攝
	0x651e: "@\x13\u651e", // 攞
	0x651f: "@\x13\u651f", // 攟
	0x6520: "@\x13\u6520", // 攠
	0x6521: "@\x13\u6521", // 攡
	0x6522: "@\x13\u6522", // 攢
	0x6523: "@\x13\u6523", // 攣
	0x6524: "@\x13\u6524", // 攤
	0x6525: "@\x14\u6525", // 攥
	0x6526: "@\x13\u6526", // 攦
	0x6527: "@\x13\u6527", // 攧
	0x6528: "@\x14\u6528", // 攨
	0x6529: "@\x14\u6529", // 攩
	0x652a: "@\x14\u652a", // 攪
	0x652b: "@\x14\u652b", // 攫
	0x652c: "@\x15\u652c", // 攬
	0x652d: "@\x15\u652d", // 攭
	0x652e: "@\x16\u652e", // 攮
	0x652f: "A\x00\u652f", // 支
	0x6530: "A\x02\u6530", // 攰
	0x6531: "A\x05\u6531", // 攱
	0x6532: "A\b\u6532", // 攲
	0x6533: "A\f\u6533", // 攳
	0x6534: "B\x00\u6534", // 攴
	0x6535: "B\x00\u6535", // 攵
	0x6536: "B\x02\u6536", // 收
	0x6537: "B\x02\u6537", // 攷
	0x6538: "B\x03\u6538", // 攸
	0x6539: "B\x03\u6539", // 改
	0x653a: "B\x03\u653a", // 攺
	0x653b: "B\x03\u653b", // 攻
	0x653c: "B\x03\u653c", // 攼
	0x653d: "B\x04\u653d", // 攽
	0x653e: "B\x04\u653e", // 放
	0x653f: "B\x04\u653f", // 政
	0x6540: "B\x05\u6540", // 敀
	0x6541: "B\x05\u6541", // 敁
	0x6542: "B\x05\u6542", // 敂
	0x6543: "B\x05\u6543", // 敃
	0x6544: "B\x05\u6544", // 敄
	0x6545: "B\x05\u6545", // 故
	0x6546: "B\x06\u6546", // 敆
	0x6547: "B\x06\u6547", // 敇
	0x6548: "B\x06\u6548", // 效
	0x6549: "B\x06\u6549", // 敉
	0x654a: "B\x06\u654a", // 敊
	0x654b: "B\x06\u654b", // 敋
	0x654c: "B\x06\u654c", // 敌
	0x654d: "B\a\u654d", // 敍
	0x654e: "B\a\u654e", // 敎
	0x654f: "B\a\u654f", // 敏
	0x6550: "B\a\u6550", // 敐
	0x6551: "B\a\u6551", // 救
	0x6552: "B\a\u6552", // 敒
	0x6553: "B\a\u6553", // 敓
	0x6554: "B\a\u6554", // 敔
	0x6555: "B\a\u6555", // 敕
	0x6556: "B\a\u6556", // 敖
	0x6557: "B\a\u6557", // 敗
	0x6558: "B\a\u6558", // 敘
	0x6559: "B\a\u6559", // 教
	0x655a: "B\a\u655a", // 敚
	0x655b: "B\a\u655b", // 敛
	0x655c: "B\b\u655c", // 敜
	0x655d: "B\b\u655d", // 敝
	0x655e: "B\b\u655e", // 敞
	0x655f: "B\b\u655f", // 敟
	0x6560: "B\b\u6560", // 敠
	0x6561: "B\b\u6561", // 敡
	0x6562: "B\b\u6562", // 敢
	0x6563: "B\b\u6563", // 散
	0x6564: "B\b\u6564", // 敤
	0x6565: "B\b\u6565", // 敥
	0x6566: "B\b\u6566", // 敦
	0x6567: "B\b\u6567", // 敧
	0x6568: "B\b\u6568", // 敨
	0x6569: "B\b\u6569", // 敩
	0x656a: "B\b\u656a", // 敪
	0x656b: "B\t\u656b", // 敫
	0x656c: "B\t\u656c", // 敬
	0x656d: "B\b\u656d", // 敭
	0x656e: "B\t\u656e", // 敮
	0x656f: "B\t\u656f", // 敯
	0x6570: "B\t\u6570", // 数
	0x6571: "B\n\u6571", // 敱
	0x6572: "B\n\u6572", // 敲
	0x6573: "B\n\u6573", // 敳
	0x6574: "B\v\u6574", // 整
	0x6575: "B\v\u6575", // 敵
	0x6576: "B\v\u6576", // 敶
	0x6577: "B\v\u6577", // 敷
	0x6578: "B\v\u6578", // 數
	0x6579: "B\v\u6579", // 敹
	0x657a: "B\v\u657a", // 敺
	0x657b: "B\v\u657b", // 敻
	0x657c: "B\f\u657c", // 敼
	0x657d: "B\f\u657d", // 敽
	0x657e: "B\f\u657e", // 敾
	0x657f: "B\f\u657f", // 敿
	0x6580: "B\r\u6580", // 斀
	0x6581: "B\r\u6581", // 斁
	0x6582: "B\r\u6582", // 斂
	0x6583: "B\x0e\u6583", // 斃
	0x6584: "B\x0f\u6584", // 斄
	0x6585: "B\x10\u6585", // 斅
	0x6586: "B\x10\u6586", // 斆
	0x6587: "C\x00\u6587", // 文
	0x6588: "C\x03\u6588", // 斈
	0x6589: "C\x04\u6589", // 斉
	0x658a: "C\x06\u658a", // 斊
	0x658b: "C\x06\u658b", // 斋
	0x658c: "C\a\u658c", // 斌
	0x658d: "C\a\u658d", // 斍
	0x658e: "C\a\u658e", // 斎
	0x658f: "C\a\u658f", // 斏
	0x6590: "C\b\u6590", // 斐
	0x6591: "C\b\u6591", // 斑
	0x6592: "C\t\u6592", // 斒
	0x6593: "C\f\u6593", // 斓
	0x6594: "C\x0f\u6594", // 斔
	0x6595: "C\x11\u6595", // 斕
	0x6596: "C\x13\u6596", // 斖
	0x6597: "D\x00\u6597", // 斗
	0x6598: "D\x03\u6598", // 斘
	0x6599: "D\x06\u6599", // 料
	0x659a: "D\x06\u659a", // 斚
	0x659b: "D\a\u659b", // 斛
	0x659c: "D\a\u659c", // 斜
	0x659d: "D\b\u659d", // 斝
	0x659e: "D\t\u659e", // 斞
	0x659f: "D\t\u659f", // 斟
	0x65a0: "D\n\u65a0", // 斠
	0x65a1: "D\n\u65a1", // 斡
	0x65a2: "D\f\u65a2", // 斢
	0x65a3: "D\r\u65a3", // 斣
	0x65a4: "E\x00\u65a4", // 斤
	0x65a5: "E\x01\u65a5", // 斥
	0x65a6: "E\x04\u65a6", // 斦
	0x65a7: "E\x04\u65a7", // 斧
	0x65a8: "E\x04\u65a8", // 斨
	0x65a9: "E\x04\u65a9", // 斩
	0x65aa: "E\x05\u65aa", // 斪
	0x65ab: "E\x05\u65ab", // 斫
	0x65ac: "E\a\u65ac", // 斬
	0x65ad: "E\a\u65ad", // 断
	0x65ae: "E\b\u65ae", // 斮
	0x65af: "E\b\u65af", // 斯
	0x65b0: "E\t\u65b0", // 新
	0x65b1: "E\t\u65b1", // 斱
	0x65b2: "E\n\u65b2", // 斲
	0x65b3: "E\v\u65b3", // 斳
	0x65b4: "E\f\u65b4", // 斴
	0x65b5: "E\r\u65b5", // 斵
	0x65b6: "E\r\u65b6", // 斶
	0x65b7: "E\x0e\u65b7", // 斷
	0x65b8: "E\x15\u65b8", // 斸
	0x65b9: "F\x00\u65b9", // 方
	0x65ba: "F\x04\u65ba", // 斺
	0x65bb: "F\x04\u65bb", // 斻
	0x65bc: "F\x04\u65bc", // 於
	0x65bd: "F\x05\u65bd", // 施
	0x65be: "F\x05\u65be", // 斾
	0x65bf: "F\x05\u65bf", // 斿
	0x65c0: "F\x05\u65c0", // 旀
	0x65c1: "F\x06\u65c1", // 旁
	0x65c2: "F\x06\u65c2", // 旂
	0x65c3: "F\x06\u65c3", // 旃
	0x65c4: "F\x06\u65c4", // 旄
	0x65c5: "F\x06\u65c5", // 旅
	0x65c6: "F\x06\u65c6", // 旆
	0x65c7: "F\a\u65c7", // 旇
	0x65c8: "F\a\u65c8", // 旈
	0x65c9: "F\a\u65c9", // 旉
	0x65ca: "F\x06\u65ca", // 旊
	0x65cb: "F\a\u65cb", // 旋
	0x65cc: "F\a\u65cc", // 旌
	0x65cd: "F\a\u65cd", // 旍
	0x65ce: "F\a\u65ce", // 旎
	0x65cf: "F\a\u65cf", // 族
	0x65d0: "F\b\u65d0", // 旐
	0x65d1: "F\b\u65d1", // 旑
	0x65d2: "F\t\u65d2", // 旒
	0x65d3: "F\t\u65d3", // 旓
	0x65d4: "F\t\u65d4", // 旔
	0x65d5: "F\t\u65d5", // 旕
	0x65d6: "F\n\u65d6", // 旖
	0x65d7: "F\n\u65d7", // 旗
	0x65d8: "F\f\u65d8", // 旘
	0x65d9: "F\f\u65d9", // 旙
	0x65da: "F\r\u65da", // 旚
	0x65db: "F\x0e\u65db", // 旛
	0x65dc: "F\x0f\u65dc", // 旜
	0x65dd: "F\x0f\u65dd", // 旝
	0x65de: "F\x0f\u65de", // 旞
	0x65df: "F\x10\u65df", // 旟
	0x65e0: "G\x00\u65e0", // 无
	0x65e1: "G\x01\u65e1", // 旡
	0x65e2: "G\x05\u65e2", // 既
	0x65e3: "G\a\u65e3", // 旣
	0x65e4: "G\t\u65e4", // 旤
	0x65e5: "H\x00\u65e5", // 日
	0x65e6: "H\x01\u65e6", // 旦
	0x65e7: "H\x01\u65e7", // 旧
	0x65e8: "H\x02\u65e8", // 旨
	0x65e9: "H\x02\u65e9", // 早
	0x65ea: "H\x02\u65ea", // 旪
	0x65eb: "H\x02\u65eb", // 旫
	0x65ec: "H\x02\u65ec", // 旬
	0x65ed: "H\x02\u65ed", // 旭
	0x65ee: "H\x02\u65ee", // 旮
	0x65ef: "H\x02\u65ef", // 旯
	0x65f0: "H\x03\u65f0", // 旰
	0x65f1: "H\x03\u65f1", // 旱
	0x65f2: "H\x03\u65f2", // 旲
	0x65f3: "H\x03\u65f3", // 旳
	0x65f4: "H\x03\u65f4", // 旴
	0x65f5: "H\x03\u65f5", // 旵
	0x65f6: "H\x03\u65f6", // 时
	0x65f7: "H\x03\u65f7", // 旷
	0x65f8: "H\x03\u65f8", // 旸
	0x65f9: "H\x04\u65f9", // 旹
	0x65fa: "H\x04\u65fa", // 旺
	0x65fb: "H\x04\u65fb", // 旻
	0x65fc: "H\x04\u65fc", // 旼
	0x65fd: "H\x04\u65fd", // 旽
	0x65fe: "H\x04\u65fe", // 旾
	0x65ff: "H\x04\u65ff", // 旿
	0x6600: "H\x04\u6600", // 昀
	0x6601: "H\x04\u6601", // 昁
	0x6602: "H\x04\u6602", // 昂
	0x6603: "H\x04\u6603", // 昃
	0x6604: "H\x04\u6604", // 昄
	0x6605: "H\x04\u6605", // 昅
	0x6606: "H\x04\u6606", // 昆
	0x6607: "H\x04\u6607", // 昇
	0x6608: "H\x04\u6608", // 昈
	0x6609: "H\x04\u6609", // 昉
	0x660a: "H\x04\u660a", // 昊
	0x660b: "H\x04\u660b", // 昋
	0x660c: "H\x04\u660c", // 昌
	0x660d: "H\x04\u660d", // 昍
	0x660e: "H\x04\u660e", // 明
	0x660f: "H\x04\u660f", // 昏
	0x6610: "H\x04\u6610", // 昐
	0x6611: "H\x04\u6611", // 昑
	0x6612: "H\x04\u6612", // 昒
	0x6613: "H\x04\u6613", // 易
	0x6614: "H\x04\u6614", // 昔
	0x6615: "H\x04\u6615", // 昕
	0x6616: "H\x04\u6616", // 昖
	0x6617: "H\x04\u6617", // 昗
	0x6618: "H\x04\u6618", // 昘
	0x6619: "H\x04\u6619", // 昙
	0x661a: "H\x05\u661a", // 昚
	0x661b: "H\x05\u661b", // 昛
	0x661c: "H\x05\u661c", // 昜
	0x661d: "H\x05\u661d", // 昝
	0x661e: "H\x05\u661e", // 昞
	0x661f: "H\x05\u661f", // 星
	0x6620: "H\x05\u6620", // 映
	0x6621: "H\x05\u6621", // 昡
	0x6622: "H\x05\u6622", // 昢
	0x6623: "H\x05\u6623", // 昣
	0x6624: "H\x05\u6624", // 昤
	0x6625: "H\x05\u6625", // 春
	0x6626: "H\x05\u6626", // 昦
	0x6627: "H\x05\u6627", // 昧
	0x6628: "H\x05\u6628", // 昨
	0x6629: "H\x05\u6629", // 昩
	0x662a: "H\x05\u662a", // 昪
	0x662b: "H\x05\u662b", // 昫
	0x662c: "H\x05\u662c", // 昬
	0x662d: "H\x05\u662d", // 昭
	0x662e: "H\x05\u662e", // 昮
	0x662f: "H\x05\u662f", // 是
	0x6630: "H\x05\u6630", // 昰
	0x6631: "H\x05\u6631", // 昱
	0x6632: "H\x05\u6632", // 昲
	0x6633: "H\x05\u6633", // 昳
	0x6634: "H\x05\u6634", // 昴
	0x6635: "H\x05\u6635", // 昵
	0x6636: "H\x05\u6636", // 昶
	0x6637: "H\x05\u6637", // 昷
	0x6638: "H\x05\u6638", // 昸
	0x6639: "H\x05\u6639", // 昹
	0x663a: "H\x05\u663a", // 昺
	0x663b: "H\x05\u663b", // 昻
	0x663c: "H\x05\u663c", // 昼
	0x663d: "H\x05\u663d", // 昽
	0x663e: "H\x05\u663e", // 显
	0x663f: "H\x05\u663f", // 昿
	0x6640: "H\x06\u6640", // 晀
	0x6641: "H\x06\u6641", // 晁
	0x6642: "H\x06\u6642", // 時
	0x6643: "H\x06\u6643", // 晃
	0x6644: "H\x06\u6644", // 晄
	0x6645: "H\x06\u6645", // 晅
	0x6646: "H\x06\u6646", // 晆
	0x6647: "H\x06\u6647", // 晇
	0x6648: "H\x06\u6648", // 晈
	0x6649: "H\x06\u6649", // 晉
	0x664a: "H\x06\u664a", // 晊
	0x664b: "H\x06\u664b", // 晋
	0x664c: "H\x06\u664c", // 晌
	0x664d: "H\x06\u664d", // 晍
	0x664e: "H\x06\u664e", // 晎
	0x664f: "H\x06\u664f", // 晏
	0x6650: "H\x06\u6650", // 晐
	0x6651: "H\x06\u6651", // 晑
	0x6652: "H\x06\u6652", // 晒
	0x6653: "H\x06\u6653", // 晓
	0x6654: "H\x06\u6654", // 晔
	0x6655: "H\x06\u6655", // 晕
	0x6656: "H\x06\u6656", // 晖
	0x6657: "H\a\u6657", // 晗
	0x6658: "H\a\u6658", // 晘
	0x6659: "H\a\u6659", // 晙
	0x665a: "H\a\u665a", // 晚
	0x665b: "H\a\u665b", // 晛
	0x665c: "H\a\u665c", // 晜
	0x665d: "H\a\u665d", // 晝
	0x665e: "H\a\u665e", // 晞
	0x665f: "H\a\u665f", // 晟
	0x6660: "H\a\u6660", // 晠
	0x6661: "H\a\u6661", // 晡
	0x6662: "H\a\u6662", // 晢
	0x6663: "H\a\u6663", // 晣
	0x6664: "H\a\u6664", // 晤
	0x6665: "H\a\u6665", // 晥
	0x6666: "H\a\u6666", // 晦
	0x6667: "H\a\u6667", // 晧
	0x6668: "H\a\u6668", // 晨
	0x6669: "H\a\u6669", // 晩
	0x666a: "H\b\u666a", // 晪
	0x666b: "H\b\u666b", // 晫
	0x666c: "H\b\u666c", // 晬
	0x666d: "H\b\u666d", // 晭
	0x666e: "H\b\u666e", // 普
	0x666f: "H\b\u666f", // 景
	0x6670: "H\b\u6670", // 晰
	0x6671: "H\b\u6671", // 晱
	0x6672: "H\b\u6672", // 晲
	0x6673: "H\b\u6673", // 晳
	0x6674: "H\b\u6674", // 晴
	0x6675: "H\b\u6675", // 晵
	0x6676: "H\b\u6676", // 晶
	0x6677: "H\b\u6677", // 晷
	0x6678: "H\b\u6678", // 晸
	0x6679: "H\b\u6679", // 晹
	0x667a: "H\b\u667a", // 智
	0x667b: "H\b\u667b", // 晻
	0x667c: "H\b\u667c", // 晼
	0x667d: "H\b\u667d", // 晽
	0x667e: "H\b\u667e", // 晾
	0x667f: "H\b\u667f", // 晿
	0x6680: "H\b\u6680", // 暀
	0x6681: "H\b\u6681", // 暁
	0x6682: "H\b\u6682", // 暂
	0x6683: "H\b\u6683", // 暃
	0x6684: "H\t\u6684", // 暄
	0x6685: "H\t\u6685", // 暅
	0x6686: "H\t\u6686", // 暆
	0x6687: "H\t\u6687", // 暇
	0x6688: "H\t\u6688", // 暈
	0x6689: "H\t\u6689", // 暉
	0x668a: "H\t\u668a", // 暊
	0x668b: "H\t\u668b", // 暋
	0x668c: "H\t\u668c", // 暌
	0x668d: "H\t\u668d", // 暍
	0x668e: "H\t\u668e", // 暎
	0x668f: "H\t\u668f", // 暏
	0x6690: "H\t\u6690", // 暐
	0x6691: "H\b\u6691", // 暑
	0x6692: "H\t\u6692", // 暒
	0x6693: "H\t\u6693", // 暓
	0x6694: "H\t\u6694", // 暔
	0x6695: "H\t\u6695", // 暕
	0x6696: "H\t\u6696", // 暖
	0x6697: "H\t\u6697", // 暗
	0x6698: "H\t\u6698", // 暘
	0x6699: "H\t\u6699", // 暙
	0x669a: "H\n\u669a", // 暚
	0x669b: "H\n\u669b", // 暛
	0x669c: "H\n\u669c", // 暜
	0x669d: "H\n\u669d", // 暝
	0x669e: "H\n\u669e", // 暞
	0x669f: "H\n\u669f", // 暟
	0x66a0: "H\n\u66a0", // 暠
	0x66a1: "H\n\u66a1", // 暡
	0x66a2: "H\n\u66a2", // 暢
	0x66a3: "H\n\u66a3", // 暣
	0x66a4: "H\n\u66a4", // 暤
	0x66a5: "H\n\u66a5", // 暥
	0x66a6: "H\n\u66a6", // 暦
	0x66a7: "H\n\u66a7", // 暧
	0x66a8: "H\n\u66a8", // 暨
	0x66a9: "H\v\u66a9", // 暩
	0x66aa: "H\v\u66aa", // 暪
	0x66ab: "H\v\u66ab", // 暫
	0x66ac: "H\v\u66ac", // 暬
	0x66ad: "H\v\u66ad", // 暭
	0x66ae: "H\v\u66ae", // 暮
	0x66af: "H\v\u66af", // 暯
	0x66b0: "H\v\u66b0", // 暰
	0x66b1: "H\v\u66b1", // 暱
	0x66b2: "H\v\u66b2", // 暲
	0x66b3: "H\v\u66b3", // 暳
	0x66b4: "H\v\u66b4", // 暴
	0x66b5: "H\v\u66b5", // 暵
	0x66b6: "H\v\u66b6", // 暶
	0x66b7: "H\v\u66b7", // 暷
	0x66b8: "H\f\u66b8", // 暸
	0x66b9: "H\f\u66b9", // 暹
	0x66ba: "H\f\u66ba", // 暺
	0x66bb: "H\f\u66bb", // 暻
	0x66bc: "H\f\u66bc", // 暼
	0x66bd: "H\f\u66bd", // 暽
	0x66be: "H\f\u66be", // 暾
	0x66bf: "H\f\u66bf", // 暿
	0x66c0: "H\f\u66c0", // 曀
	0x66c1: "H\f\u66c1", // 曁
	0x66c2: "H\f\u66c2", // 曂
	0x66c3: "H\f\u66c3", // 曃
	0x66c4: "H\f\u66c4", // 曄
	0x66c5: "H\f\u66c5", // 曅
	0x66c6: "H\f\u66c6", // 曆
	0x66c7: "H\f\u66c7", // 曇
	0x66c8: "H\f\u66c8", // 曈
	0x66c9: "H\f\u66c9", // 曉
	0x66ca: "H\f\u66ca", // 曊
	0x66cb: "H\f\u66cb", // 曋
	0x66cc: "H\f\u66cc", // 曌
	0x66cd: "H\f\u66cd", // 曍
	0x66ce: "H\r\u66ce", // 曎
	0x66cf: "H\r\u66cf", // 曏
	0x66d0: "H\r\u66d0", // 曐
	0x66d1: "H\r\u66d1", // 曑
	0x66d2: "H\r\u66d2", // 曒
	0x66d3: "H\r\u66d3", // 曓
	0x66d4: "H\r\u66d4", // 曔
	0x66d5: "H\r\u66d5", // 曕
	0x66d6: "H\r\u66d6", // 曖
	0x66d7: "H\r\u66d7", // 曗
	0x66d8: "H\x0e\u66d8", // 曘
	0x66d9: "H\x0e\u66d9", // 曙
	0x66da: "H\r\u66da", // 曚
	0x66db: "H\x0e\u66db", // 曛
	0x66dc: "H\x0e\u66dc", // 曜
	0x66dd: "H\x0f\u66dd", // 曝
	0x66de: "H\x0f\u66de", // 曞
	0x66df: "H\x0f\u66df", // 曟
	0x66e0: "H\x0f\u66e0", // 曠
	0x66e1: "H\x0f\u66e1", // 曡
	0x66e2: "H\x0f\u66e2", // 曢
	0x66e3: "H\x10\u66e3", // 曣
	0x66e4: "H\x10\u66e4", // 曤
	0x66e5: "H\x10\u66e5", // 曥
	0x66e6: "H\x10\u66e6", // 曦
	0x66e7: "H\x10\u66e7", // 曧
	0x66e8: "H\x10\u66e8", // 曨
	0x66e9: "H\x11\u66e9", // 曩
	0x66ea: "H\x13\u66ea", // 曪
	0x66eb: "H\x13\u66eb", // 曫
	0x66ec: "H\x13\u66ec", // 曬
	0x66ed: "H\x14\u66ed", // 曭
	0x66ee: "H\x14\u66ee", // 曮
	0x66ef: "H\x15\u66ef", // 曯
	0x66f0: "I\x00\u66f0", // 曰
	0x66f1: "I\x01\u66f1", // 曱
	0x66f2: "I\x02\u66f2", // 曲
	0x66f3: "I\x02\u66f3", // 曳
	0x66f4: "I\x03\u66f4", // 更
	0x66f5: "I\x03\u66f5", // 曵
	0x66f6: "I\x04\u66f6", // 曶
	0x66f7: "I\x05\u66f7", // 曷
	0x66f8: "I\x06\u66f8", // 書
	0x66f9: "I\a\u66f9", // 曹
	0x66fa: "I\x06\u66fa", // 曺
	0x66fb: "I\a\u66fb", // 曻
	0x66fc: "I\a\u66fc", // 曼
	0x66fd: "H\a\u66fd", // 曽
	0x66fe: "I\b\u66fe", // 曾
	0x66ff: "I\b\u66ff", // 替
	0x6700: "\r\n\u6700", // 最
	0x6701: "I\b\u6701", // 朁
	0x6702: "I\b\u6702", // 朂
	0x6703: "I\t\u6703", // 會
	0x6704: "I\n\u6704", // 朄
	0x6705: "I\n\u6705", // 朅
	0x6706: "I\f\u6706", // 朆
	0x6707: "I\x11\u6707", // 朇
	0x6708: "J\x00\u6708", // 月
	0x6709: "J\x02\u6709", // 有
	0x670a: "J\x04\u670a", // 朊
	0x670b: "J\x04\u670b", // 朋
	0x670c: "J\x04\u670c", // 朌
	0x670d: "J\x04\u670d", // 服
	0x670e: "J\x05\u670e", // 朎
	0x670f: "J\x05\u670f", // 朏
	0x6710: "J\x05\u6710", // 朐
	0x6711: "J\x05\u6711", // 朑
	0x6712: "J\x06\u6712", // 朒
	0x6713: "J\x06\u6713", // 朓
	0x6714: "J\x06\u6714", // 朔
	0x6715: "J\x06\u6715", // 朕
	0x6716: "J\a\u6716", // 朖
	0x6717: "J\a\u6717", // 朗
	0x6718: "J\a\u6718", // 朘
	0x6719: "J\a\u6719", // 朙
	0x671a: "J\a\u671a", // 朚
	0x671b: "J\a\u671b", // 望
	0x671c: "J\b\u671c", // 朜
	0x671d: "J\b\u671d", // 朝
	0x671e: "J\b\u671e", // 朞
	0x671f: "J\b\u671f", // 期
	0x6720: "J\t\u6720", // 朠
	0x6721: "J\t\u6721", // 朡
	0x6722: "J\n\u6722", // 朢
	0x6723: "J\f\u6723", // 朣
	0x6724: "J\f\u6724", // 朤
	0x6725: "J\f\u6725", // 朥
	0x6726: "J\x0e\u6726", // 朦
	0x6727: "J\x10\u6727", // 朧
	0x6728: "K\x00\u6728", // 木
	0x6729: "K\x00\u6729", // 朩
	0x672a: "K\x01\u672a", // 未
	0x672b: "K\x01\u672b", // 末
	0x672c: "K\x01\u672c", // 本
	0x672d: "K\x01\u672d", // 札
	0x672e: "K\x01\u672e", // 朮
	0x672f: "K\x01\u672f", // 术
	0x6730: "K\x01\u6730", // 朰
	0x6731: "K\x02\u6731", // 朱
	0x6732: "K\x02\u6732", // 朲
	0x6733: "K\x02\u6733", // 朳
	0x6734: "K\x02\u6734", // 朴
	0x6735: "K\x02\u6735", // 朵
	0x6736: "K\x02\u6736", // 朶
	0x6737: "K\x02\u6737", // 朷
	0x6738: "K\x02\u6738", // 朸
	0x6739: "K\x02\u6739", // 朹
	0x673a: "K\x02\u673a", // 机
	0x673b: "K\x02\u673b", // 朻
	0x673c: "K\x02\u673c", // 朼
	0x673d: "K\x02\u673d", // 朽
	0x673e: "K\x02\u673e", // 朾
	0x673f: "K\x02\u673f", // 朿
	0x6740: "K\x02\u6740", // 杀
	0x6741: "K\x02\u6741", // 杁
	0x6742: "K\x02\u6742", // 杂
	0x6743: "K\x02\u6743", // 权
	0x6744: "K\x03\u6744", // 杄
	0x6745: "K\x03\u6745", // 杅
	0x6746: "K\x03\u6746", // 杆
	0x6747: "K\x03\u6747", // 杇
	0x6748: "K\x03\u6748", // 杈
	0x6749: "K\x03\u6749", // 杉
	0x674a: "K\x03\u674a", // 杊
	0x674b: "K\x03\u674b", // 杋
	0x674c: "K\x03\u674c", // 杌
	0x674d: "K\x03\u674d", // 杍
	0x674e: "K\x03\u674e", // 李
	0x674f: "K\x03\u674f", // 杏
	0x6750: "K\x03\u6750", // 材
	0x6751: "K\x03\u6751", // 村
	0x6752: "K\x03\u6752", // 杒
	0x6753: "K\x03\u6753", // 杓
	0x6754: "K\x03\u6754", // 杔
	0x6755: "K\x03\u6755", // 杕
	0x6756: "K\x03\u6756", // 杖
	0x6757: "K\x03\u6757", // 杗
	0x6758: "K\x03\u6758", // 杘
	0x6759: "K\x03\u6759", // 杙
	0x675a: "K\x03\u675a", // 杚
	0x675b: "K\x03\u675b", // 杛
	0x675c: "K\x03\u675c", // 杜
	0x675d: "K\x03\u675d", // 杝
	0x675e: "K\x03\u675e", // 杞
	0x675f: "K\x03\u675f", // 束
	0x6760: "K\x03\u6760", // 杠
	0x6761: "K\x03\u6761", // 条
	0x6762: "K\x03\u6762", // 杢
	0x6763: "K\x03\u6763", // 杣
	0x6764: "K\x03\u6764", // 杤
	0x6765: "K\x03\u6765", // 来
	0x6766: "K\x03\u6766", // 杦
	0x6767: "K\x03\u6767", // 杧
	0x6768: "K\x03\u6768", // 杨
	0x6769: "K\x03\u6769", // 杩
	0x676a: "K\x04\u676a", // 杪
	0x676b: "K\x04\u676b", // 杫
	0x676c: "K\x04\u676c", // 杬
	0x676d: "K\x04\u676d", // 杭
	0x676e: "K\x04\u676e", // 杮
	0x676f: "K\x04\u676f", // 杯
	0x6770: "K\x04\u6770", // 杰
	0x6771: "K\x04\u6771", // 東
	0x6772: "K\x04\u6772", // 杲
	0x6773: "K\x04\u6773", // 杳
	0x6774: "K\x04\u6774", // 杴
	0x6775: "K\x04\u6775", // 杵
	0x6776: "K\x04\u6776", // 杶
	0x6777: "K\x04\u6777", // 杷
	0x6778: "K\x04\u6778", // 杸
	0x6779: "K\x04\u6779", // 杹
	0x677a: "K\x04\u677a", // 杺
	0x677b: "K\x04\u677b", // 杻
	0x677c: "K\x04\u677c", // 杼
	0x677d: "K\x04\u677d", // 杽
	0x677e: "K\x04\u677e", // 松
	0x677f: "K\x04\u677f", // 板
	0x6780: "K\x04\u6780", // 枀
	0x6781: "K\x03\u6781", // 极
	0x6782: "K\x04\u6782", // 枂
	0x6783: "K\x04\u6783", // 枃
	0x6784: "K\x04\u6784", // 构
	0x6785: "K\x04\u6785", // 枅
	0x6786: "K\x04\u6786", // 枆
	0x6787: "K\x04\u6787", // 枇
	0x6788: "K\x04\u6788", // 枈
	0x6789: "K\x04\u6789", // 枉
	0x678a: "K\x04\u678a", // 枊
	0x678b: "K\x04\u678b", // 枋
	0x678c: "K\x04\u678c", // 枌
	0x678d: "K\x04\u678d", // 枍
	0x678e: "K\x04\u678e", // 枎
	0x678f: "K\x04\u678f", // 枏
	0x6790: "K\x04\u6790", // 析
	0x6791: "K\x04\u6791", // 枑
	0x6792: "K\x04\u6792", // 枒
	0x6793: "K\x04\u6793", // 枓
	0x6794: "K\x04\u6794", // 枔
	0x6795: "K\x04\u6795", // 枕
	0x6796: "K\x04\u6796", // 枖
	0x6797: "K\x04\u6797", // 林
	0x6798: "K\x04\u6798", // 枘
	0x6799: "K\x04\u6799", // 枙
	0x679a: "K\x04\u679a", // 枚
	0x679b: "K\x04\u679b", // 枛
	0x679c: "K\x04\u679c", // 果
	0x679d: "K\x04\u679d", // 枝
	0x679e: "K\x04\u679e", // 枞
	0x679f: "K\x04\u679f", // 枟
	0x67a0: "K\x04\u67a0", // 枠
	0x67a1: "K\x04\u67a1", // 枡
	0x67a2: "K\x04\u67a2", // 枢
	0x67a3: "K\x04\u67a3", // 枣
	0x67a4: "K\x04\u67a4", // 枤
	0x67a5: "K\x04\u67a5", // 枥
	0x67a6: "K\x04\u67a6", // 枦
	0x67a7: "K\x04\u67a7", // 枧
	0x67a8: "K\x04\u67a8", // 枨
	0x67a9: "K\x04\u67a9", // 枩
	0x67aa: "K\x04\u67aa", // 枪
	0x67ab: "K\x04\u67ab", // 枫
	0x67ac: "K\x04\u67ac", // 枬
	0x67ad: "K\x04\u67ad", // 枭
	0x67ae: "K\x05\u67ae", // 枮
	0x67af: "K\x05\u67af", // 枯
	0x67b0: "K\x05\u67b0", // 枰
	0x67b1: "K\x05\u67b1", // 枱
	0x67b2: "K\x05\u67b2", // 枲
	0x67b3: "K\x05\u67b3", // 枳
	0x67b4: "K\x05\u67b4", // 枴
	0x67b5: "K\x05\u67b5", // 枵
	0x67b6: "K\x05\u67b6", // 架
	0x67b7: "K\x05\u67b7", // 枷
	0x67b8: "K\x05\u67b8", // 枸
	0x67b9: "K\x05\u67b9", // 枹
	0x67ba: "K\x05\u67ba", // 枺
	0x67bb: "K\x05\u67bb", // 枻
	0x67bc: "K\x05\u67bc", // 枼
	0x67bd: "K\x05\u67bd", // 枽
	0x67be: "K\x05\u67be", // 枾
	0x67bf: "K\x05\u67bf", // 枿
	0x67c0: "K\x05\u67c0", // 柀
	0x67c1: "K\x05\u67c1", // 柁
	0x67c2: "K\x05\u67c2", // 柂
	0x67c3: "K\x05\u67c3", // 柃
	0x67c4: "K\x05\u67c4", // 柄
	0x67c5: "K\x05\u67c5", // 柅
	0x67c6: "K\x05\u67c6", // 柆
	0x67c7: "K\x05\u67c7", // 柇
	0x67c8: "K\x05\u67c8", // 柈
	0x67c9: "K\x05\u67c9", // 柉
	0x67ca: "K\x05\u67ca", // 柊
	0x67cb: "K\x05\u67cb", // 柋
	0x67cc: "K\x05\u67cc", // 柌
	0x67cd: "K\x05\u67cd", // 柍
	0x67ce: "K\x05\u67ce", // 柎
	0x67cf: "K\x05\u67cf", // 柏
	0x67d0: "K\x05\u67d0", // 某
	0x67d1: "K\x05\u67d1", // 柑
	0x67d2: "K\x05\u67d2", // 柒
	0x67d3: "K\x05\u67d3", // 染
	0x67d4: "K\x05\u67d4", // 柔
	0x67d5: "K\x05\u67d5", // 柕
	0x67d6: "K\x05\u67d6", // 柖
	0x67d7: "K\x05\u67d7", // 柗
	0x67d8: "K\x05\u67d8", // 柘
	0x67d9: "K\x05\u67d9", // 柙
	0x67da: "K\x05\u67da", // 柚
	0x67db: "K\x05\u67db", // 柛
	0x67dc: "K\x05\u67dc", // 柜
	0x67dd: "K\x05\u67dd", // 柝
	0x67de: "K\x05\u67de", // 柞
	0x67df: "K\x05\u67df", // 柟
	0x67e0: "K\x05\u67e0", // 柠
	0x67e1: "K\x05\u67e1", // 柡
	0x67e2: "K\x05\u67e2", // 柢
	0x67e3: "K\x05\u67e3", // 柣
	0x67e4: "K\x05\u67e4", // 柤
	0x67e5: "K\x05\u67e5", // 查
	0x67e6: "K\x05\u67e6", // 柦
	0x67e7: "K\x05\u67e7", // 柧
	0x67e8: "K\x05\u67e8", // 柨
	0x67e9: "K\x05\u67e9", // 柩
	0x67ea: "K\x05\u67ea", // 柪
	0x67eb: "K\x05\u67eb", // 柫
	0x67ec: "K\x05\u67ec", // 柬
	0x67ed: "K\x05\u67ed", // 柭
	0x67ee: "K\x05\u67ee", // 柮
	0x67ef: "K\x05\u67ef", // 柯
	0x67f0: "K\x05\u67f0", // 柰
	0x67f1: "K\x05\u67f1", // 柱
	0x67f2: "K\x05\u67f2", // 柲
	0x67f3: "K\x05\u67f3", // 柳
	0x67f4: "K\x05\u67f4", // 柴
	0x67f5: "K\x05\u67f5", // 柵
	0x67f6: "K\x05\u67f6", // 柶
	0x67f7: "K\x05\u67f7", // 柷
	0x67f8: "K\x05\u67f8", // 柸
	0x67f9: "K\x05\u67f9", // 柹
	0x67fa: "K\x05\u67fa", // 柺
	0x67fb: "K\x05\u67fb", // 査
	0x67fc: "K\x05\u67fc", // 柼
	0x67fd: "K\x05\u67fd", // 柽
	0x67fe: "K\x05\u67fe", // 柾
	0x67ff: "K\x05\u67ff", // 柿
	0x6800: "K\x05\u6800", // 栀
	0x6801: "K\x05\u6801", // 栁
	0x6802: "K\x05\u6802", // 栂
	0x6803: "K\x05\u6803", // 栃
	0x6804: "K\x05\u6804", // 栄
	0x6805: "K\x05\u6805", // 栅
	0x6806: "K\x05\u6806", // 栆
	0x6807: "K\x05\u6807", // 标
	0x6808: "K\x05\u6808", // 栈
	0x6809: "K\x05\u6809", // 栉
	0x680a: "K\x05\u680a", // 栊
	0x680b: "K\x05\u680b", // 栋
	0x680c: "K\x05\u680c", // 栌
	0x680d: "K\x05\u680d", // 栍
	0x680e: "K\x05\u680e", // 栎
	0x680f: "K\x05\u680f", // 栏
	0x6810: "K\x05\u6810", // 栐
	0x6811: "K\x05\u6811", // 树
	0x6812: "K\x06\u6812", // 栒
	0x6813: "K\x06\u6813", // 栓
	0x6814: "K\x06\u6814", // 栔
	0x6815: "K\x06\u6815", // 栕
	0x6816: "K\x06\u6816", // 栖
	0x6817: "K\x06\u6817", // 栗
	0x6818: "K\x06\u6818", // 栘
	0x6819: "K\x06\u6819", // 栙
	0x681a: "K\x06\u681a", // 栚
	0x681b: "K\x06\u681b", // 栛
	0x681c: "K\x06\u681c", // 栜
	0x681d: "K\x06\u681d", // 栝
	0x681e: "K\x06\u681e", // 栞
	0x681f: "K\x06\u681f", // 栟
	0x6820: "K\x06\u6820", // 栠
	0x6821: "K\x06\u6821", // 校
	0x6822: "K\x06\u6822", // 栢
	0x6823: "K\x06\u6823", // 栣
	0x6824: "K\x06\u6824", // 栤
	0x6825: "K\x06\u6825", // 栥
	0x6826: "K\x06\u6826", // 栦
	0x6827: "K\x06\u6827", // 栧
	0x6828: "K\x06\u6828", // 栨
	0x6829: "K\x06\u6829", // 栩
	0x682a: "K\x06\u682a", // 株
	0x682b: "K\x06\u682b", // 栫
	0x682c: "K\x06\u682c", // 栬
	0x682d: "K\x06\u682d", // 栭
	0x682e: "K\x06\u682e", // 栮
	0x682f: "K\x06\u682f", // 栯
	0x6830: "K\x06\u6830", // 栰
	0x6831: "K\x06\u6831", // 栱
	0x6832: "K\x06\u6832", // 栲
	0x6833: "K\x06\u6833", // 栳
	0x6834: "K\x06\u6834", // 栴
	0x6835: "K\x06\u6835", // 栵
	0x6836: "K\x06\u6836", // 栶
	0x6837: "K\x06\u6837", // 样
	0x6838: "K\x06\u6838", // 核
	0x6839: "K\x06\u6839", // 根
	0x683a: "K\x06\u683a", // 栺
	0x683b: "K\x06\u683b", // 栻
	0x683c: "K\x06\u683c", // 格
	0x683d: "K\x06\u683d", // 栽
	0x683e: "K\x06\u683e", // 栾
	0x683f: "K\x06\u683f", // 栿
	0x6840: "K\x06\u6840", // 桀
	0x6841: "K\x06\u6841", // 桁
	0x6842: "K\x06\u6842", // 桂
	0x6843: "K\x06\u6843", // 桃
	0x6844: "K\x06\u6844", // 桄
	0x6845: "K\x06\u6845", // 桅
	0x6846: "K\x06\u6846", // 框
	0x6847: "K\x06\u6847", // 桇
	0x6848: "K\x06\u6848", // 案
	0x6849: "K\x06\u6849", // 桉
	0x684a: "K\x06\u684a", // 桊
	0x684b: "K\x06\u684b", // 桋
	0x684c: "K\x06\u684c", // 桌
	0x684d: "K\x06\u684d", // 桍
	0x684e: "K\x06\u684e", // 桎
	0x684f: "K\x06\u684f", // 桏
	0x6850: "K\x06\u6850", // 桐
	0x6851: "K\x06\u6851", // 桑
	0x6852: "K\x06\u6852", // 桒
	0x6853: "K\x06\u6853", // 桓
	0x6854: "K\x06\u6854", // 桔
	0x6855: "K\x06\u6855", // 桕
	0x6856: "K\x06\u6856", // 桖
	0x6857: "K\x06\u6857", // 桗
	0x6858: "K\x06\u6858", // 桘
	0x6859: "K\x06\u6859", // 桙
	0x685a: "K\x06\u685a", // 桚
	0x685b: "K\x06\u685b", // 桛
	0x685c: "K\x06\u685c", // 桜
	0x685d: "K\x06\u685d", // 桝
	0x685e: "K\x06\u685e", // 桞
	0x685f: "K\x06\u685f", // 桟
	0x6860: "K\x06\u6860", // 桠
	0x6861: "K\x06\u6861", // 桡
	0x6862: "K\x06\u6862", // 桢
	0x6863: "K\x06\u6863", // 档
	0x6864: "K\x06\u6864", // 桤
	0x6865: "K\x06\u6865", // 桥
	0x6866: "K\x06\u6866", // 桦
	0x6867: "K\x06\u6867", // 桧
	0x6868: "K\x06\u6868", // 桨
	0x6869: "K\x06\u6869", // 桩
	0x686a: "K\x06\u686a", // 桪
	0x686b: "K\a\u686b", // 桫
	0x686c: "K\a\u686c", // 桬
	0x686d: "K\a\u686d", // 桭
	0x686e: "K\a\u686e", // 桮
	0x686f: "K\a\u686f", // 桯
	0x6870: "K\a\u6870", // 桰
	0x6871: "K\a\u6871", // 桱
	0x6872: "K\a\u6872", // 桲
	0x6873: "K\a\u6873", // 桳
	0x6874: "K\a\u6874", // 桴
	0x6875: "K\a\u6875", // 桵
	0x6876: "K\a\u6876", // 桶
	0x6877: "K\a\u6877", // 桷
	0x6878: "K\a\u6878", // 桸
	0x6879: "K\a\u6879", // 桹
	0x687a: "K\a\u687a", // 桺
	0x687b: "K\a\u687b", // 桻
	0x687c: "K\a\u687c", // 桼
	0x687d: "K\a\u687d", // 桽
	0x687e: "K\a\u687e", // 桾
	0x687f: "K\a\u687f", // 桿
	0x6880: "K\a\u6880", // 梀
	0x6881: "K\a\u6881", // 梁
	0x6882: "K\a\u6882", // 梂
	0x6883: "K\a\u6883", // 梃
	0x6884: "K\a\u6884", // 梄
	0x6885: "K\a\u6885", // 梅
	0x6886: "K\a\u6886", // 梆
	0x6887: "K\a\u6887", // 梇
	0x6888: "K\a\u6888", // 梈
	0x6889: "K\a\u6889", // 梉
	0x688a: "K\a\u688a", // 梊
	0x688b: "K\a\u688b", // 梋
	0x688c: "K\a\u688c", // 梌
	0x688d: "K\a\u688d", // 梍
	0x688e: "K\a\u688e", // 梎
	0x688f: "K\a\u688f", // 梏
	0x6890: "K\a\u6890", // 梐
	0x6891: "K\a\u6891", // 梑
	0x6892: "K\a\u6892", // 梒
	0x6893: "K\a\u6893", // 梓
	0x6894: "K\a\u6894", // 梔
	0x6895: "K\a\u6895", // 梕
	0x6896: "K\a\u6896", // 梖
	0x6897: "K\a\u6897", // 梗
	0x6898: "K\a\u6898", // 梘
	0x6899: "K\a\u6899", // 梙
	0x689a: "K\a\u689a", // 梚
	0x689b: "K\a\u689b", // 梛
	0x689c: "K\a\u689c", // 梜
	0x689d: "K\a\u689d", // 條
	0x689e: "K\a\u689e", // 梞
	0x689f: "K\a\u689f", // 梟
	0x68a0: "K\a\u68a0", // 梠
	0x68a1: "K\a\u68a1", // 梡
	0x68a2: "K\a\u68a2", // 梢
	0x68a3: "K\a\u68a3", // 梣
	0x68a4: "K\a\u68a4", // 梤
	0x68a5: "K\a\u68a5", // 梥
	0x68a6: "K\a\u68a6", // 梦
	0x68a7: "K\a\u68a7", // 梧
	0x68a8: "K\a\u68a8", // 梨
	0x68a9: "K\a\u68a9", // 梩
	0x68aa: "K\a\u68aa", // 梪
	0x68ab: "K\a\u68ab", // 梫
	0x68ac: "K\a\u68ac", // 梬
	0x68ad: "K\a\u68ad", // 梭
	0x68ae: "K\a\u68ae", // 梮
	0x68af: "K\a\u68af", // 梯
	0x68b0: "K\a\u68b0", // 械
	0x68b1: "K\a\u68b1", // 梱
	0x68b2: "K\a\u68b2", // 梲
	0x68b3: "K\a\u68b3", // 梳
	0x68b4: "K\a\u68b4", // 梴
	0x68b5: "K\a\u68b5", // 梵
	0x68b6: "K\a\u68b6", // 梶
	0x68b7: "K\a\u68b7", // 梷
	0x68b8: "K\a\u68b8", // 梸
	0x68b9: "K\a\u68b9", // 梹
	0x68ba: "K\a\u68ba", // 梺
	0x68bb: "K\a\u68bb", // 梻
	0x68bc: "K\a\u68bc", // 梼
	0x68bd: "K\a\u68bd", // 梽
	0x68be: "K\a\u68be", // 梾
	0x68bf: "K\a\u68bf", // 梿
	0x68c0: "K\a\u68c0", // 检
	0x68c1: "K\a\u68c1", // 棁
	0x68c2: "K\a\u68c2", // 棂
	0x68c3: "K\b\u68c3", // 棃
	0x68c4: "K\b\u68c4", // 棄
	0x68c5: "K\b\u68c5", // 棅
	0x68c6: "K\b\u68c6", // 棆
	0x68c7: "K\b\u68c7", // 棇
	0x68c8: "K\b\u68c8", // 棈
	0x68c9: "K\b\u68c9", // 棉
	0x68ca: "K\b\u68ca", // 棊
	0x68cb: "K\b\u68cb", // 棋
	0x68cc: "K\b\u68cc", // 棌
	0x68cd: "K\b\u68cd", // 棍
	0x68ce: "K\b\u68ce", // 棎
	0x68cf: "K\b\u68cf", // 棏
	0x68d0: "K\b\u68d0", // 棐
	0x68d1: "K\b\u68d1", // 棑
	0x68d2: "K\b\u68d2", // 棒
	0x68d3: "K\b\u68d3", // 棓
	0x68d4: "K\b\u68d4", // 棔
	0x68d5: "K\b\u68d5", // 棕
	0x68d6: "K\b\u68d6", // 棖
	0x68d7: "K\b\u68d7", // 棗
	0x68d8: "K\b\u68d8", // 棘
	0x68d9: "K\b\u68d9", // 棙
	0x68da: "K\b\u68da", // 棚
	0x68db: "K\b\u68db", // 棛
	0x68dc: "K\b\u68dc", // 棜
	0x68dd: "K\b\u68dd", // 棝
	0x68de: "K\b\u68de", // 棞
	0x68df: "K\b\u68df", // 棟
	0x68e0: "K\b\u68e0", // 棠
	0x68e1: "K\b\u68e1", // 棡
	0x68e2: "K\b\u68e2", // 棢
	0x68e3: "K\b\u68e3", // 棣
	0x68e4: "K\b\u68e4", // 棤
	0x68e5: "K\b\u68e5", // 棥
	0x68e6: "K\b\u68e6", // 棦
	0x68e7: "K\b\u68e7", // 棧
	0x68e8: "K\b\u68e8", // 棨
	0x68e9: "K\b\u68e9", // 棩
	0x68ea: "K\b\u68ea", // 棪
	0x68eb: "K\b\u68eb", // 棫
	0x68ec: "K\b\u68ec", // 棬
	0x68ed: "K\b\u68ed", // 棭
	0x68ee: "K\b\u68ee", // 森
	0x68ef: "K\b\u68ef", // 棯
	0x68f0: "K\b\u68f0", // 棰
	0x68f1: "K\b\u68f1", // 棱
	0x68f2: "K\b\u68f2", // 棲
	0x68f3: "K\b\u68f3", // 棳
	0x68f4: "K\b\u68f4", // 棴
	0x68f5: "K\b\u68f5", // 棵
	0x68f6: "K\b\u68f6", // 棶
	0x68f7: "K\b\u68f7", // 棷
	0x68f8: "K\b\u68f8", // 棸
	0x68f9: "K\b\u68f9", // 棹
	0x68fa: "K\b\u68fa", // 棺
	0x68fb: "K\b\u68fb", // 棻
	0x68fc: "K\b\u68fc", // 棼
	0x68fd: "K\b\u68fd", // 棽
	0x68fe: "K\b\u68fe", // 棾
	0x68ff: "K\b\u68ff", // 棿
	0x6900: "K\b\u6900", // 椀
	0x6901: "K\b\u6901", // 椁
	0x6902: "K\b\u6902", // 椂
	0x6903: "K\b\u6903", // 椃
	0x6904: "K\b\u6904", // 椄
	0x6905: "K\b\u6905", // 椅
	0x6906: "K\b\u6906", // 椆
	0x6907: "K\b\u6907", // 椇
	0x6908: "K\b\u6908", // 椈
	0x6909: "K\b\u6909", // 椉
	0x690a: "K\b\u690a", // 椊
	0x690b: "K\b\u690b", // 椋
	0x690c: "K\b\u690c", // 椌
	0x690d: "K\b\u690d", // 植
	0x690e: "K\b\u690e", // 椎
	0x690f: "K\b\u690f", // 椏
	0x6910: "K\b\u6910", // 椐
	0x6911: "K\b\u6911", // 椑
	0x6912: "K\b\u6912", // 椒
	0x6913: "K\b\u6913", // 椓
	0x6914: "K\b\u6914", // 椔
	0x6915: "K\b\u6915", // 椕
	0x6916: "K\b\u6916", // 椖
	0x6917: "K\b\u6917", // 椗
	0x6918: "K\b\u6918", // 椘
	0x6919: "K\b\u6919", // 椙
	0x691a: "K\b\u691a", // 椚
	0x691b: "K\b\u691b", // 椛
	0x691c: "K\b\u691c", // 検
	0x691d: "K\b\u691d", // 椝
	0x691e: "K\b\u691e", // 椞
	0x691f: "K\b\u691f", // 椟
	0x6920: "K\b\u6920", // 椠
	0x6921: "K\b\u6921", // 椡
	0x6922: "K\b\u6922", // 椢
	0x6923: "K\b\u6923", // 椣
	0x6924: "K\b\u6924", // 椤
	0x6925: "K\b\u6925", // 椥
	0x6926: "K\b\u6926", // 椦
	0x6927: "K\b\u6927", // 椧
	0x6928: "K\b\u6928", // 椨
	0x6929: "K\b\u6929", // 椩
	0x692a: "K\b\u692a", // 椪
	0x692b: "K\b\u692b", // 椫
	0x692c: "K\b\u692c", // 椬
	0x692d: "K\b\u692d", // 椭
	0x692e: "K\b\u692e", // 椮
	0x692f: "K\t\u692f", // 椯
	0x6930: "K\t\u6930", // 椰
	0x6931: "K\t\u6931", // 椱
	0x6932: "K\t\u6932", // 椲
	0x6933: "K\t\u6933", // 椳
	0x6934: "K\t\u6934", // 椴
	0x6935: "K\t\u6935", // 椵
	0x6936: "K\t\u6936", // 椶
	0x6937: "K\t\u6937", // 椷
	0x6938: "K\t\u6938", // 椸
	0x6939: "K\t\u6939", // 椹
	0x693a: "K\t\u693a", // 椺
	0x693b: "K\t\u693b", // 椻
	0x693c: "K\t\u693c", // 椼
	0x693d: "K\t\u693d", // 椽
	0x693e: "K\t\u693e", // 椾
	0x693f: "K\t\u693f", // 椿
	0x6940: "K\t\u6940", // 楀
	0x6941: "K\t\u6941", // 楁
	0x6942: "K\t\u6942", // 楂
	0x6943: "K\t\u6943", // 楃
	0x6944: "K\t\u6944", // 楄
	0x6945: "K\t\u6945", // 楅
	0x6946: "K\t\u6946", // 楆
	0x6947: "K\t\u6947", // 楇
	0x6948: "K\t\u6948", // 楈
	0x6949: "K\t\u6949", // 楉
	0x694a: "K\t\u694a", // 楊
	0x694b: "K\t\u694b", // 楋
	0x694c: "K\t\u694c", // 楌
	0x694d: "K\t\u694d", // 楍
	0x694e: "K\t\u694e", // 楎
	0x694f: "K\t\u694f", // 楏
	0x6950: "K\t\u6950", // 楐
	0x6951: "K\t\u6951", // 楑
	0x6952: "K\t\u6952", // 楒
	0x6953: "K\t\u6953", // 楓
	0x6954: "K\t\u6954", // 楔
	0x6955: "K\t\u6955", // 楕
	0x6956: "K\t\u6956", // 楖
	0x6957: "K\t\u6957", // 楗
	0x6958: "K\t\u6958", // 楘
	0x6959: "K\t\u6959", // 楙
	0x695a: "K\t\u695a", // 楚
	0x695b: "K\t\u695b", // 楛
	0x695c: "K\t\u695c", // 楜
	0x695d: "K\t\u695d", // 楝
	0x695e: "K\t\u695e", // 楞
	0x695f: "K\t\u695f", // 楟
	0x6960: "K\t\u6960", // 楠
	0x6961: "K\t\u6961", // 楡
	0x6962: "K\t\u6962", // 楢
	0x6963: "K\t\u6963", // 楣
	0x6964: "K\t\u6964", // 楤
	0x6965: "K\t\u6965", // 楥
	0x6966: "K\t\u6966", // 楦
	0x6967: "K\t\u6967", // 楧
	0x6968: "K\t\u6968", // 楨
	0x6969: "K\t\u6969", // 楩
	0x696a: "K\t\u696a", // 楪
	0x696b: "K\t\u696b", // 楫
	0x696c: "K\t\u696c", // 楬
	0x696d: "K\t\u696d", // 業
	0x696e: "K\t\u696e", // 楮
	0x696f: "K\t\u696f", // 楯
	0x6970: "K\t\u6970", // 楰
	0x6971: "K\t\u6971", // 楱
	0x6972: "K\t\u6972", // 楲
	0x6973: "K\t\u6973", // 楳
	0x6974: "K\t\u6974", // 楴
	0x6975: "K\t\u6975", // 極
	0x6976: "K\t\u6976", // 楶
	0x6977: "K\t\u6977", // 楷
	0x6978: "K\t\u6978", // 楸
	0x6979: "K\t\u6979", // 楹
	0x697a: "K\t\u697a", // 楺
	0x697b: "K\t\u697b", // 楻
	0x697c: "K\t\u697c", // 楼
	0x697d: "K\t\u697d", // 楽
	0x697e: "K\t\u697e", // 楾
	0x697f: "K\t\u697f", // 楿
	0x6980: "K\t\u6980", // 榀
	0x6981: "K\t\u6981", // 榁
	0x6982: "K\t\u6982", // 概
	0x6983: "K\t\u6983", // 榃
	0x6984: "K\t\u6984", // 榄
	0x6985: "K\t\u6985", // 榅
	0x6986: "K\t\u6986", // 榆
	0x6987: "K\t\u6987", // 榇
	0x6988: "K\t\u6988", // 榈
	0x6989: "K\t\u6989", // 榉
	0x698a: "K\n\u698a", // 榊
	0x698b: "K\t\u698b", // 榋
	0x698c: "K\t\u698c", // 榌
	0x698d: "K\n\u698d", // 榍
	0x698e: "K\n\u698e", // 榎
	0x698f: "K\n\u698f", // 榏
	0x6990: "K\n\u6990", // 榐
	0x6991: "K\n\u6991", // 榑
	0x6992: "K\n\u6992", // 榒
	0x6993: "K\n\u6993", // 榓
	0x6994: "K\t\u6994", // 榔
	0x6995: "K\n\u6995", // 榕
	0x6996: "K\n\u6996", // 榖
	0x6997: "K\n\u6997", // 榗
	0x6998: "K\t\u6998", // 榘
	0x6999: "K\n\u6999", // 榙
	0x699a: "K\n\u699a", // 榚
	0x699b: "K\n\u699b", // 榛
	0x699c: "K\n\u699c", // 榜
	0x699d: "K\n\u699d", // 榝
	0x699e: "K\n\u699e", // 榞
	0x699f: "K\n\u699f", // 榟
	0x69a0: "K\n\u69a0", // 榠
	0x69a1: "K\n\u69a1", // 榡
	0x69a2: "K\n\u69a2", // 榢
	0x69a3: "K\n\u69a3", // 榣
	0x69a4: "K\n\u69a4", // 榤
	0x69a5: "K\n\u69a5", // 榥
	0x69a6: "K\n\u69a6", // 榦
	0x69a7: "K\n\u69a7", // 榧
	0x69a8: "K\n\u69a8", // 榨
	0x69a9: "K\n\u69a9", // 榩
	0x69aa: "K\n\u69aa", // 榪
	0x69ab: "K\n\u69ab", // 榫
	0x69ac: "K\n\u69ac", // 榬
	0x69ad: "K\n\u69ad", // 榭
	0x69ae: "K\n\u69ae", // 榮
	0x69af: "K\n\u69af", // 榯
	0x69b0: "K\n\u69b0", // 榰
	0x69b1: "K\n\u69b1", // 榱
	0x69b2: "K\n\u69b2", // 榲
	0x69b3: "K\n\u69b3", // 榳
	0x69b4: "K\n\u69b4", // 榴
	0x69b5: "K\n\u69b5", // 榵
	0x69b6: "K\n\u69b6", // 榶
	0x69b7: "K\n\u69b7", // 榷
	0x69b8: "K\n\u69b8", // 榸
	0x69b9: "K\n\u69b9", // 榹
	0x69ba: "K\n\u69ba", // 榺
	0x69bb: "K\n\u69bb", // 榻
	0x69bc: "K\n\u69bc", // 榼
	0x69bd: "K\n\u69bd", // 榽
	0x69be: "K\n\u69be", // 榾
	0x69bf: "K\n\u69bf", // 榿
	0x69c0: "K\n\u69c0", // 槀
	0x69c1: "K\n\u69c1", // 槁
	0x69c2: "K\n\u69c2", // 槂
	0x69c3: "K\n\u69c3", // 槃
	0x69c4: "K\n\u69c4", // 槄
	0x69c5: "K\n\u69c5", // 槅
	0x69c6: "K\n\u69c6", // 槆
	0x69c7: "K\n\u69c7", // 槇
	0x69c8: "K\n\u69c8", // 槈
	0x69c9: "K\n\u69c9", // 槉
	0x69ca: "K\n\u69ca", // 槊
	0x69cb: "K\n\u69cb", // 構
	0x69cc: "K\n\u69cc", // 槌
	0x69cd: "K\n\u69cd", // 槍
	0x69ce: "K\n\u69ce", // 槎
	0x69cf: "K\n\u69cf", // 槏
	0x69d0: "K\n\u69d0", // 槐
	0x69d1: "K\n\u69d1", // 槑
	0x69d2: "K\n\u69d2", // 槒
	0x69d3: "K\n\u69d3", // 槓
	0x69d4: "K\n\u69d4", // 槔
	0x69d5: "K\n\u69d5", // 槕
	0x69d6: "K\n\u69d6", // 槖
	0x69d7: "K\n\u69d7", // 槗
	0x69d8: "K\n\u69d8", // 様
	0x69d9: "K\n\u69d9", // 槙
	0x69da: "K\n\u69da", // 槚
	0x69db: "K\n\u69db", // 槛
	0x69dc: "K\n\u69dc", // 槜
	0x69dd: "K\n\u69dd", // 槝
	0x69de: "K\n\u69de", // 槞
	0x69df: "K\n\u69df", // 槟
	0x69e0: "K\n\u69e0", // 槠
	0x69e1: "K\n\u69e1", // 槡
	0x69e2: "K\v\u69e2", // 槢
	0x69e3: "K\v\u69e3", // 槣
	0x69e4: "K\v\u69e4", // 槤
	0x69e5: "K\v\u69e5", // 槥
	0x69e6: "K\v\u69e6", // 槦
	0x69e7: "K\v\u69e7", // 槧
	0x69e8: "K\v\u69e8", // 槨
	0x69e9: "K\n\u69e9", // 槩
	0x69ea: "K\v\u69ea", // 槪
	0x69eb: "K\v\u69eb", // 槫
	0x69ec: "K\v\u69ec", // 槬
	0x69ed: "K\v\u69ed", // 槭
	0x69ee: "K\v\u69ee", // 槮
	0x69ef: "K\v\u69ef", // 槯
	0x69f0: "K\v\u69f0", // 槰
	0x69f1: "K\v\u69f1", // 槱
	0x69f2: "K\v\u69f2", // 槲
	0x69f3: "K\v\u69f3", // 槳
	0x69f4: "K\v\u69f4", // 槴
	0x69f5: "K\v\u69f5", // 槵
	0x69f6: "K\v\u69f6", // 槶
	0x69f7: "K\v\u69f7", // 槷
	0x69f8: "K\v\u69f8", // 槸
	0x69f9: "K\v\u69f9", // 槹
	0x69fa: "K\v\u69fa", // 槺
	0x69fb: "K\v\u69fb", // 槻
	0x69fc: "K\v\u69fc", // 槼
	0x69fd: "K\v\u69fd", // 槽
	0x69fe: "K\v\u69fe", // 槾
	0x69ff: "K\v\u69ff", // 槿
	0x6a00: "K\v\u6a00", // 樀
	0x6a01: "K\v\u6a01", // 樁
	0x6a02: "K\v\u6a02", // 樂
	0x6a03: "K\v\u6a03", // 樃
	0x6a04: "K\v\u6a04", // 樄
	0x6a05: "K\v\u6a05", // 樅
	0x6a06: "K\v\u6a06", // 樆
	0x6a07: "K\v\u6a07", // 樇
	0x6a08: "K\v\u6a08", // 樈
	0x6a09: "K\v\u6a09", // 樉
	0x6a0a: "K\v\u6a0a", // 樊
	0x6a0b: "K\v\u6a0b", // 樋
	0x6a0c: "K\v\u6a0c", // 樌
	0x6a0d: "K\v\u6a0d", // 樍
	0x6a0e: "K\v\u6a0e", // 樎
	0x6a0f: "K\v\u6a0f", // 樏
	0x6a10: "K\v\u6a10", // 樐
	0x6a11: "K\v\u6a11", // 樑
	0x6a12: "K\v\u6a12", // 樒
	0x6a13: "K\v\u6a13", // 樓
	0x6a14: "K\v\u6a14", // 樔
	0x6a15: "K\v\u6a15", // 樕
	0x6a16: "K\v\u6a16", // 樖
	0x6a17: "K\v\u6a17", // 樗
	0x6a18: "K\v\u6a18", // 樘
	0x6a19: "K\v\u6a19", // 標
	0x6a1a: "K\v\u6a1a", // 樚
	0x6a1b: "K\v\u6a1b", // 樛
	0x6a1c: "K\v\u6a1c", // 樜
	0x6a1d: "K\v\u6a1d", // 樝
	0x6a1e: "K\v\u6a1e", // 樞
	0x6a1f: "K\v\u6a1f", // 樟
	0x6a20: "K\v\u6a20", // 樠
	0x6a21: "K\v\u6a21", // 模
	0x6a22: "K\v\u6a22", // 樢
	0x6a23: "K\v\u6a23", // 樣
	0x6a24: "K\v\u6a24", // 樤
	0x6a25: "K\v\u6a25", // 樥
	0x6a26: "K\v\u6a26", // 樦
	0x6a27: "K\v\u6a27", // 樧
	0x6a28: "K\v\u6a28", // 樨
	0x6a29: "K\v\u6a29", // 権
	0x6a2a: "K\v\u6a2a", // 横
	0x6a2b: "K\v\u6a2b", // 樫
	0x6a2c: "K\v\u6a2c", // 樬
	0x6a2d: "K\v\u6a2d", // 樭
	0x6a2e: "K\n\u6a2e", // 樮
	0x6a2f: "K\v\u6a2f", // 樯
	0x6a30: "K\v\u6a30", // 樰
	0x6a31: "K\v\u6a31", // 樱
	0x6a32: "K\f\u6a32", // 樲
	0x6a33: "K\f\u6a33", // 樳
	0x6a34: "K\f\u6a34", // 樴
	0x6a35: "K\f\u6a35", // 樵
	0x6a36: "K\f\u6a36", // 樶
	0x6a37: "K\f\u6a37", // 樷
	0x6a38: "K\f\u6a38", // 樸
	0x6a39: "K\f\u6a39", // 樹
	0x6a3a: "K\f\u6a3a", // 樺
	0x6a3b: "K\f\u6a3b", // 樻
	0x6a3c: "K\f\u6a3c", // 樼
	0x6a3d: "K\f\u6a3d", // 樽
	0x6a3e: "K\f\u6a3e", // 樾
	0x6a3f: "K\f\u6a3f", // 樿
	0x6a40: "K\f\u6a40", // 橀
	0x6a41: "K\f\u6a41", // 橁
	0x6a42: "K\f\u6a42", // 橂
	0x6a43: "K\f\u6a43", // 橃
	0x6a44: "K\f\u6a44", // 橄
	0x6a45: "K\f\u6a45", // 橅
	0x6a46: "K\f\u6a46", // 橆
	0x6a47: "K\f\u6a47", // 橇
	0x6a48: "K\f\u6a48", // 橈
	0x6a49: "K\f\u6a49", // 橉
	0x6a4a: "K\f\u6a4a", // 橊
	0x6a4b: "K\f\u6a4b", // 橋
	0x6a4c: "K\f\u6a4c", // 橌
	0x6a4d: "K\f\u6a4d", // 橍
	0x6a4e: "K\f\u6a4e", // 橎
	0x6a4f: "K\f\u6a4f", // 橏
	0x6a50: "K\f\u6a50", // 橐
	0x6a51: "K\f\u6a51", // 橑
	0x6a52: "K\f\u6a52", // 橒
	0x6a53: "K\f\u6a53", // 橓
	0x6a54: "K\f\u6a54", // 橔
	0x6a55: "K\f\u6a55", // 橕
	0x6a56: "K\f\u6a56", // 橖
	0x6a57: "K\f\u6a57", // 橗
	0x6a58: "K\f\u6a58", // 橘
	0x6a59: "K\f\u6a59", // 橙
	0x6a5a: "K\f\u6a5a", // 橚
	0x6a5b: "K\f\u6a5b", // 橛
	0x6a5c: "K\f\u6a5c", // 橜
	0x6a5d: "K\f\u6a5d", // 橝
	0x6a5e: "K\f\u6a5e", // 橞
	0x6a5f: "K\f\u6a5f", // 機
	0x6a60: "K\f\u6a60", // 橠
	0x6a61: "K\f\u6a61", // 橡
	0x6a62: "K\f\u6a62", // 橢
	0x6a63: "K\f\u6a63", // 橣
	0x6a64: "K\f\u6a64", // 橤
	0x6a65: "K\v\u6a65", // 橥
	0x6a66: "K\f\u6a66", // 橦
	0x6a67: "K\f\u6a67", // 橧
	0x6a68: "K\f\u6a68", // 橨
	0x6a69: "K\f\u6a69", // 橩
	0x6a6a: "K\f\u6a6a", // 橪
	0x6a6b: "K\f\u6a6b", // 橫
	0x6a6c: "K\f\u6a6c", // 橬
	0x6a6d: "K\f\u6a6d", // 橭
	0x6a6e: "K\f\u6a6e", // 橮
	0x6a6f: "K\f\u6a6f", // 橯
	0x6a70: "K\f\u6a70", // 橰
	0x6a71: "K\f\u6a71", // 橱
	0x6a72: "K\f\u6a72", // 橲
	0x6a73: "K\f\u6a73", // 橳
	0x6a74: "K\v\u6a74", // 橴
	0x6a75: "K\f\u6a75", // 橵
	0x6a76: "K\f\u6a76", // 橶
	0x6a77: "K\f\u6a77", // 橷
	0x6a78: "K\f\u6a78", // 橸
	0x6a79: "K\f\u6a79", // 橹
	0x6a7a: "K\f\u6a7a", // 橺
	0x6a7b: "K\f\u6a7b", // 橻
	0x6a7c: "K\f\u6a7c", // 橼
	0x6a7d: "K\r\u6a7d", // 橽
	0x6a7e: "K\r\u6a7e", // 橾
	0x6a7f: "K\r\u6a7f", // 橿
	0x6a80: "K\r\u6a80", // 檀
	0x6a81: "K\r\u6a81", // 檁
	0x6a82: "K\r\u6a82", // 檂
	0x6a83: "K\r\u6a83", // 檃
	0x6a84: "K\r\u6a84", // 檄
	0x6a85: "K\r\u6a85", // 檅
	0x6a86: "K\r\u6a86", // 檆
	0x6a87: "K\r\u6a87", // 檇
	0x6a88: "K\r\u6a88", // 檈
	0x6a89: "K\r\u6a89", // 檉
	0x6a8a: "K\r\u6a8a", // 檊
	0x6a8b: "K\r\u6a8b", // 檋
	0x6a8c: "K\r\u6a8c", // 檌
	0x6a8d: "K\r\u6a8d", // 檍
	0x6a8e: "K\r\u6a8e", // 檎
	0x6a8f: "K\r\u6a8f", // 檏
	0x6a90: "K\r\u6a90", // 檐
	0x6a91: "K\r\u6a91", // 檑
	0x6a92: "K\r\u6a92", // 檒
	0x6a93: "K\r\u6a93", // 檓
	0x6a94: "K\r\u6a94", // 檔
	0x6a95: "K\r\u6a95", // 檕
	0x6a96: "K\r\u6a96", // 檖
	0x6a97: "K\r\u6a97", // 檗
	0x6a98: "K\r\u6a98", // 檘
	0x6a99: "K\r\u6a99", // 檙
	0x6a9a: "K\r\u6a9a", // 檚
	0x6a9b: "K\r\u6a9b", // 檛
	0x6a9c: "K\r\u6a9c", // 檜
	0x6a9d: "K\r\u6a9d", // 檝
	0x6a9e: "K\r\u6a9e", // 檞
	0x6a9f: "K\r\u6a9f", // 檟
	0x6aa0: "K\r\u6aa0", // 檠
	0x6aa1: "K\r\u6aa1", // 檡
	0x6aa2: "K\r\u6aa2", // 檢
	0x6aa3: "K\r\u6aa3", // 檣
	0x6aa4: "K\r\u6aa4", // 檤
	0x6aa5: "K\r\u6aa5", // 檥
	0x6aa6: "K\r\u6aa6", // 檦
	0x6aa7: "K\r\u6aa7", // 檧
	0x6aa8: "K\r\u6aa8", // 檨
	0x6aa9: "K\r\u6aa9", // 檩
	0x6aaa: "K\r\u6aaa", // 檪
	0x6aab: "K\x0e\u6aab", // 檫
	0x6aac: "K\x0e\u6aac", // 檬
	0x6aad: "K\x0e\u6aad", // 檭
	0x6aae: "K\x0e\u6aae", // 檮
	0x6aaf: "K\x0e\u6aaf", // 檯
	0x6ab0: "K\x0e\u6ab0", // 檰
	0x6ab1: "K\x0e\u6ab1", // 檱
	0x6ab2: "K\x0e\u6ab2", // 檲
	0x6ab3: "K\x0e\u6ab3", // 檳
	0x6ab4: "K\x0e\u6ab4", // 檴
	0x6ab5: "K\x0e\u6ab5", // 檵
	0x6ab6: "K\x0e\u6ab6", // 檶
	0x6ab7: "K\x0e\u6ab7", // 檷
	0x6ab8: "K\x0e\u6ab8", // 檸
	0x6ab9: "K\x0e\u6ab9", // 檹
	0x6aba: "K\x0e\u6aba", // 檺
	0x6abb: "K\x0e\u6abb", // 檻
	0x6abc: "K\x0e\u6abc", // 檼
	0x6abd: "K\x0e\u6abd", // 檽
	0x6abe: "K\x0e\u6abe", // 檾
	0x6abf: "K\x0e\u6abf", // 檿
	0x6ac0: "K\x0e\u6ac0", // 櫀
	0x6ac1: "K\x0e\u6ac1", // 櫁
	0x6ac2: "K\x0e\u6ac2", // 櫂
	0x6ac3: "K\x0e\u6ac3", // 櫃
	0x6ac4: "K\x0e\u6ac4", // 櫄
	0x6ac5: "K\x0e\u6ac5", // 櫅
	0x6ac6: "K\x0e\u6ac6", // 櫆
	0x6ac7: "K\x0e\u6ac7", // 櫇
	0x6ac8: "K\x0e\u6ac8", // 櫈
	0x6ac9: "K\x0e\u6ac9", // 櫉
	0x6aca: "K\x0e\u6aca", // 櫊
	0x6acb: "K\x0f\u6acb", // 櫋
	0x6acc: "K\x0f\u6acc", // 櫌
	0x6acd: "K\x0f\u6acd", // 櫍
	0x6ace: "K\x0f\u6ace", // 櫎
	0x6acf: "K\x0f\u6acf", // 櫏
	0x6ad0: "K\x0f\u6ad0", // 櫐
	0x6ad1: "K\x0f\u6ad1", // 櫑
	0x6ad2: "K\x0f\u6ad2", // 櫒
	0x6ad3: "K\x0f\u6ad3", // 櫓
	0x6ad4: "K\x0f\u6ad4", // 櫔
	0x6ad5: "K\x0f\u6ad5", // 櫕
	0x6ad6: "K\x0f\u6ad6", // 櫖
	0x6ad7: "K\x0f\u6ad7", // 櫗
	0x6ad8: "K\x0f\u6ad8", // 櫘
	0x6ad9: "K\x0f\u6ad9", // 櫙
	0x6ada: "K\x0f\u6ada", // 櫚
	0x6adb: "K\x0f\u6adb", // 櫛
	0x6adc: "K\x0f\u6adc", // 櫜
	0x6add: "K\x0f\u6add", // 櫝
	0x6ade: "K\x0f\u6ade", // 櫞
	0x6adf: "K\x0f\u6adf", // 櫟
	0x6ae0: "K\x0f\u6ae0", // 櫠
	0x6ae1: "K\x0f\u6ae1", // 櫡
	0x6ae2: "K\x0f\u6ae2", // 櫢
	0x6ae3: "K\x0f\u6ae3", // 櫣
	0x6ae4: "K\x0f\u6ae4", // 櫤
	0x6ae5: "K\x0f\u6ae5", // 櫥
	0x6ae6: "K\x0f\u6ae6", // 櫦
	0x6ae7: "K\x10\u6ae7", // 櫧
	0x6ae8: "K\x10\u6ae8", // 櫨
	0x6ae9: "K\x10\u6ae9", // 櫩
	0x6aea: "K\x10\u6aea", // 櫪
	0x6aeb: "K\x0f\u6aeb", // 櫫
	0x6aec: "K\x10\u6aec", // 櫬
	0x6aed: "K\x0f\u6aed", // 櫭
	0x6aee: "K\x10\u6aee", // 櫮
	0x6aef: "K\x10\u6aef", // 櫯
	0x6af0: "K\x10\u6af0", // 櫰
	0x6af1: "K\x10\u6af1", // 櫱
	0x6af2: "K\x10\u6af2", // 櫲
	0x6af3: "K\x10\u6af3", // 櫳
	0x6af4: "K\x10\u6af4", // 櫴
	0x6af5: "K\x10\u6af5", // 櫵
	0x6af6: "K\x10\u6af6", // 櫶
	0x6af7: "K\x12\u6af7", // 櫷
	0x6af8: "K\x11\u6af8", // 櫸
	0x6af9: "K\x11\u6af9", // 櫹
	0x6afa: "K\x11\u6afa", // 櫺
	0x6afb: "K\x11\u6afb", // 櫻
	0x6afc: "K\x11\u6afc", // 櫼
	0x6afd: "K\x11\u6afd", // 櫽
	0x6afe: "K\x11\u6afe", // 櫾
	0x6aff: "K\x11\u6aff", // 櫿
	0x6b00: "K\x11\u6b00", // 欀
	0x6b01: "K\x11\u6b01", // 欁
	0x6b02: "K\x11\u6b02", // 欂
	0x6b03: "K\x11\u6b03", // 欃
	0x6b04: "K\x11\u6b04", // 欄
	0x6b05: "K\x11\u6b05", // 欅
	0x6b06: "K\x12\u6b06", // 欆
	0x6b07: "K\x12\u6b07", // 欇
	0x6b08: "K\x12\u6b08", // 欈
	0x6b09: "K\x12\u6b09", // 欉
	0x6b0a: "K\x12\u6b0a", // 權
	0x6b0b: "K\x12\u6b0b", // 欋
	0x6b0c: "K\x11\u6b0c", // 欌
	0x6b0d: "K\x12\u6b0d", // 欍
	0x6b0e: "K\x12\u6b0e", // 欎
	0x6b0f: "K\x13\u6b0f", // 欏
	0x6b10: "K\x13\u6b10", // 欐
	0x6b11: "K\x13\u6b11", // 欑
	0x6b12: "K\x13\u6b12", // 欒
	0x6b13: "K\x14\u6b13", // 欓
	0x6b14: "K\x14\u6b14", // 欔
	0x6b15: "K\x14\u6b15", // 欕
	0x6b16: "K\x15\u6b16", // 欖
	0x6b17: "K\x15\u6b17", // 欗
	0x6b18: "K\x15\u6b18", // 欘
	0x6b19: "K\x15\u6b19", // 欙
	0x6b1a: "K\x15\u6b1a", // 欚
	0x6b1b: "K\x15\u6b1b", // 欛
	0x6b1c: "K\x16\u6b1c", // 欜
	0x6b1d: "K\x16\u6b1d", // 欝
	0x6b1e: "K\x18\u6b1e", // 欞
	0x6b1f: "K\x18\u6b1f", // 欟
	0x6b20: "L\x00\u6b20", // 欠
	0x6b21: "L\x02\u6b21", // 次
	0x6b22: "L\x02\u6b22", // 欢
	0x6b23: "L\x04\u6b23", // 欣
	0x6b24: "L\x03\u6b24", // 欤
	0x6b25: "L\x04\u6b25", // 欥
	0x6b26: "L\x04\u6b26", // 欦
	0x6b27: "L\x04\u6b27", // 欧
	0x6b28: "L\x05\u6b28", // 欨
	0x6b29: "L\x05\u6b29", // 欩
	0x6b2a: "L\x05\u6b2a", // 欪
	0x6b2b: "L\x06\u6b2b", // 欫
	0x6b2c: "L\x06\u6b2c", // 欬
	0x6b2d: "L\x06\u6b2d", // 欭
	0x6b2e: "L\x06\u6b2e", // 欮
	0x6b2f: "L\x06\u6b2f", // 欯
	0x6b30: "L\x06\u6b30", // 欰
	0x6b31: "L\x06\u6b31", // 欱
	0x6b32: "L\a\u6b32", // 欲
	0x6b33: "L\a\u6b33", // 欳
	0x6b34: "L\a\u6b34", // 欴
	0x6b35: "L\a\u6b35", // 欵
	0x6b36: "L\a\u6b36", // 欶
	0x6b37: "L\a\u6b37", // 欷
	0x6b38: "L\a\u6b38", // 欸
	0x6b39: "L\b\u6b39", // 欹
	0x6b3a: "L\b\u6b3a", // 欺
	0x6b3b: "L\b\u6b3b", // 欻
	0x6b3c: "L\b\u6b3c", // 欼
	0x6b3d: "L\b\u6b3d", // 欽
	0x6b3e: "L\b\u6b3e", // 款
	0x6b3f: "L\b\u6b3f", // 欿
	0x6b40: "L\t\u6b40", // 歀
	0x6b41: "L\t\u6b41", // 歁
	0x6b42: "L\t\u6b42", // 歂
	0x6b43: "L\t\u6b43", // 歃
	0x6b44: "L\t\u6b44", // 歄
	0x6b45: "L\t\u6b45", // 歅
	0x6b46: "L\t\u6b46", // 歆
	0x6b47: "L\t\u6b47", // 歇
	0x6b48: "L\t\u6b48", // 歈
	0x6b49: "L\n\u6b49", // 歉
	0x6b4a: "L\n\u6b4a", // 歊
	0x6b4b: "L\n\u6b4b", // 歋
	0x6b4c: "L\n\u6b4c", // 歌
	0x6b4d: "L\n\u6b4d", // 歍
	0x6b4e: "L\v\u6b4e", // 歎
	0x6b4f: "L\v\u6b4f", // 歏
	0x6b50: "L\v\u6b50", // 歐
	0x6b51: "L\v\u6b51", // 歑
	0x6b52: "L\v\u6b52", // 歒
	0x6b53: "L\v\u6b53", // 歓
	0x6b54: "L\f\u6b54", // 歔
	0x6b55: "L\f\u6b55", // 歕
	0x6b56: "L\f\u6b56", // 歖
	0x6b57: "L\f\u6b57", // 歗
	0x6b58: "L\f\u6b58", // 歘
	0x6b59: "L\f\u6b59", // 歙
	0x6b5a: "L\f\u6b5a", // 歚
	0x6b5b: "L\r\u6b5b", // 歛
	0x6b5c: "L\r\u6b5c", // 歜
	0x6b5d: "L\r\u6b5d", // 歝
	0x6b5e: "L\x0e\u6b5e", // 歞
	0x6b5f: "L\x0e\u6b5f", // 歟
	0x6b60: "L\x0f\u6b60", // 歠
	0x6b61: "L\x12\u6b61", // 歡
	0x6b62: "M\x00\u6b62", // 止
	0x6b63: "M\x01\u6b63", // 正
	0x6b64: "M\x02\u6b64", // 此
	0x6b65: "M\x03\u6b65", // 步
	0x6b66: "M\x04\u6b66", // 武
	0x6b67: "M\x04\u6b67", // 歧
	0x6b68: "M\x04\u6b68", // 歨
	0x6b69: "M\x04\u6b69", // 歩
	0x6b6a: "M\x05\u6b6a", // 歪
	0x6b6b: "M\x05\u6b6b", // 歫
	0x6b6c: "M\x06\u6b6c", // 歬
	0x6b6d: "M\x06\u6b6d", // 歭
	0x6b6e: "M\b\u6b6e", // 歮
	0x6b6f: "M\b\u6b6f", // 歯
	0x6b70: "M\t\u6b70", // 歰
	0x6b71: "M\t\u6b71", // 歱
	0x6b72: "M\t\u6b72", // 歲
	0x6b73: "M\t\u6b73", // 歳
	0x6b74: "M\n\u6b74", // 歴
	0x6b75: "M\v\u6b75", // 歵
	0x6b76: "M\v\u6b76", // 歶
	0x6b77: "M\f\u6b77", // 歷
	0x6b78: "M\x0e\u6b78", // 歸
	0x6b79: "N\x00\u6b79", // 歹
	0x6b7a: "N\x01\u6b7a", // 歺
	0x6b7b: "N\x02\u6b7b", // 死
	0x6b7c: "N\x03\u6b7c", // 歼
	0x6b7d: "N\x04\u6b7d", // 歽
	0x6b7e: "N\x04\u6b7e", // 歾
	0x6b7f: "N\x04\u6b7f", // 歿
	0x6b80: "N\x04\u6b80", // 殀
	0x6b81: "N\x04\u6b81", // 殁
	0x6b82: "N\x05\u6b82", // 殂
	0x6b83: "N\x05\u6b83", // 殃
	0x6b84: "N\x05\u6b84", // 殄
	0x6b85: "N\x05\u6b85", // 殅
	0x6b86: "N\x05\u6b86", // 殆
	0x6b87: "N\x05\u6b87", // 殇
	0x6b88: "N\x06\u6b88", // 殈
	0x6b89: "N\x06\u6b89", // 殉
	0x6b8a: "N\x06\u6b8a", // 殊
	0x6b8b: "N\x06\u6b8b", // 残
	0x6b8c: "N\a\u6b8c", // 殌
	0x6b8d: "N\a\u6b8d", // 殍
	0x6b8e: "N\a\u6b8e", // 殎
	0x6b8f: "N\a\u6b8f", // 殏
	0x6b90: "N\a\u6b90", // 殐
	0x6b91: "N\a\u6b91", // 殑
	0x6b92: "N\a\u6b92", // 殒
	0x6b93: "N\a\u6b93", // 殓
	0x6b94: "N\b\u6b94", // 殔
	0x6b95: "N\b\u6b95", // 殕
	0x6b96: "N\b\u6b96", // 殖
	0x6b97: "N\b\u6b97", // 殗
	0x6b98: "N\b\u6b98", // 殘
	0x6b99: "N\b\u6b99", // 殙
	0x6b9a: "N\b\u6b9a", // 殚
	0x6b9b: "N\t\u6b9b", // 殛
	0x6b9c: "N\t\u6b9c", // 殜
	0x6b9d: "N\n\u6b9d", // 殝
	0x6b9e: "N\n\u6b9e", // 殞
	0x6b9f: "N\n\u6b9f", // 殟
	0x6ba0: "N\n\u6ba0", // 殠
	0x6ba1: "N\n\u6ba1", // 殡
	0x6ba2: "N\v\u6ba2", // 殢
	0x6ba3: "N\v\u6ba3", // 殣
	0x6ba4: "N\v\u6ba4", // 殤
	0x6ba5: "N\v\u6ba5", // 殥
	0x6ba6: "N\v\u6ba6", // 殦
	0x6ba7: "N\f\u6ba7", // 殧
	0x6ba8: "N\f\u6ba8", // 殨
	0x6ba9: "N\f\u6ba9", // 殩
	0x6baa: "N\f\u6baa", // 殪
	0x6bab: "N\f\u6bab", // 殫
	0x6bac: "N\r\u6bac", // 殬
	0x6bad: "N\r\u6bad", // 殭
	0x6bae: "N\r\u6bae", // 殮
	0x6baf: "N\x0e\u6baf", // 殯
	0x6bb0: "N\x0f\u6bb0", // 殰
	0x6bb1: "N\x0f\u6bb1", // 殱
	0x6bb2: "N\x11\u6bb2", // 殲
	0x6bb3: "O\x00\u6bb3", // 殳
	0x6bb4: "O\x04\u6bb4", // 殴
	0x6bb5: "O\x05\u6bb5", // 段
	0x6bb6: "O\x05\u6bb6", // 殶
	0x6bb7: "O\x06\u6bb7", // 殷
	0x6bb8: "O\a\u6bb8", // 殸
	0x6bb9: "O\a\u6bb9", // 殹
	0x6bba: "O\a\u6bba", // 殺
	0x6bbb: "O\a\u6bbb", // 殻
	0x6bbc: "O\b\u6bbc", // 殼
	0x6bbd: "O\b\u6bbd", // 殽
	0x6bbe: "O\t\u6bbe", // 殾
	0x6bbf: "O\t\u6bbf", // 殿
	0x6bc0: "O\t\u6bc0", // 毀
	0x6bc1: "O\t\u6bc1", // 毁
	0x6bc2: "O\t\u6bc2", // 毂
	0x6bc3: "O\n\u6bc3", // 毃
	0x6bc4: "O\n\u6bc4", // 毄
	0x6bc5: "O\v\u6bc5", // 毅
	0x6bc6: "O\v\u6bc6", // 毆
	0x6bc7: "O\f\u6bc7", // 毇
	0x6bc8: "O\f\u6bc8", // 毈
	0x6bc9: "O\x0f\u6bc9", // 毉
	0x6bca: "O\x13\u6bca", // 毊
	0x6bcb: "P\x00\u6bcb", // 毋
	0x6bcc: "P\x00\u6bcc", // 毌
	0x6bcd: "P\x01\u6bcd", // 母
	0x6bce: "P\x02\u6bce", // 毎
	0x6bcf: "P\x03\u6bcf", // 每
	0x6bd0: "P\x03\u6bd0", // 毐
	0x6bd1: "P\x04\u6bd1", // 毑
	0x6bd2: "P\x04\u6bd2", // 毒
	0x6bd3: "P\t\u6bd3", // 毓
	0x6bd4: "Q\x00\u6bd4", // 比
	0x6bd5: "Q\x02\u6bd5", // 毕
	0x6bd6: "Q\x05\u6bd6", // 毖
	0x6bd7: "Q\x05\u6bd7", // 毗
	0x6bd8: "Q\x05\u6bd8", // 毘
	0x6bd9: "Q\x06\u6bd9", // 毙
	0x6bda: "Q\r\u6bda", // 毚
	0x6bdb: "R\x00\u6bdb", // 毛
	0x6bdc: "R\x03\u6bdc", // 毜
	0x6bdd: "R\x03\u6bdd", // 毝
	0x6bde: "R\x04\u6bde", // 毞
	0x6bdf: "R\x04\u6bdf", // 毟
	0x6be0: "R\x05\u6be0", // 毠
	0x6be1: "R\x05\u6be1", // 毡
	0x6be2: "R\x06\u6be2", // 毢
	0x6be3: "R\x06\u6be3", // 毣
	0x6be4: "R\x06\u6be4", // 毤
	0x6be5: "R\x06\u6be5", // 毥
	0x6be6: "R\x06\u6be6", // 毦
	0x6be7: "R\x06\u6be7", // 毧
	0x6be8: "R\x06\u6be8", // 毨
	0x6be9: "R\x06\u6be9", // 毩
	0x6bea: "R\x06\u6bea", // 毪
	0x6beb: "R\a\u6beb", // 毫
	0x6bec: "R\a\u6bec", // 毬
	0x6bed: "R\a\u6bed", // 毭
	0x6bee: "R\a\u6bee", // 毮
	0x6bef: "R\b\u6bef", // 毯
	0x6bf0: "R\b\u6bf0", // 毰
	0x6bf1: "R\b\u6bf1", // 毱
	0x6bf2: "R\b\u6bf2", // 毲
	0x6bf3: "R\b\u6bf3", // 毳
	0x6bf4: "R\b\u6bf4", // 毴
	0x6bf5: "R\b\u6bf5", // 毵
	0x6bf6: "R\b\u6bf6", // 毶
	0x6bf7: "R\t\u6bf7", // 毷
	0x6bf8: "R\t\u6bf8", // 毸
	0x6bf9: "R\t\u6bf9", // 毹
	0x6bfa: "R\t\u6bfa", // 毺
	0x6bfb: "R\t\u6bfb", // 毻
	0x6bfc: "R\t\u6bfc", // 毼
	0x6bfd: "R\t\u6bfd", // 毽
	0x6bfe: "R\n\u6bfe", // 毾
	0x6bff: "R\v\u6bff", // 毿
	0x6c00: "R\v\u6c00", // 氀
	0x6c01: "R\v\u6c01", // 氁
	0x6c02: "R\v\u6c02", // 氂
	0x6c03: "R\f\u6c03", // 氃
	0x6c04: "R\f\u6c04", // 氄
	0x6c05: "R\f\u6c05", // 氅
	0x6c06: "R\f\u6c06", // 氆
	0x6c07: "R\f\u6c07", // 氇
	0x6c08: "R\r\u6c08", // 氈
	0x6c09: "R\r\u6c09", // 氉
	0x6c0a: "R\r\u6c0a", // 氊
	0x6c0b: "R\x0e\u6c0b", // 氋
	0x6c0c: "R\x0f\u6c0c", // 氌
	0x6c0d: "R\x12\u6c0d", // 氍
	0x6c0e: "R\x16\u6c0e", // 氎
	0x6c0f: "S\x00\u6c0f", // 氏
	0x6c10: "S\x01\u6c10", // 氐
	0x6c11: "S\x01\u6c11", // 民
	0x6c12: "S\x02\u6c12", // 氒
	0x6c13: "S\x04\u6c13", // 氓
	0x6c14: "T\x00\u6c14", // 气
	0x6c15: "T\x01\u6c15", // 氕
	0x6c16: "T\x02\u6c16", // 氖
	0x6c17: "T\x02\u6c17", // 気
	0x6c18: "T\x02\u6c18", // 氘
	0x6c19: "T\x03\u6c19", // 氙
	0x6c1a: "T\x03\u6c1a", // 氚
	0x6c1b: "T\x04\u6c1b", // 氛
	0x6c1c: "T\x04\u6c1c", // 氜
	0x6c1d: "T\x04\u6c1d", // 氝
	0x6c1e: "T\x05\u6c1e", // 氞
	0x6c1f: "T\x05\u6c1f", // 氟
	0x6c20: "T\x05\u6c20", // 氠
	0x6c21: "T\x05\u6c21", // 氡
	0x6c22: "T\x05\u6c22", // 氢
	0x6c23: "T\x06\u6c23", // 氣
	0x6c24: "T\x06\u6c24", // 氤
	0x6c25: "T\x06\u6c25", // 氥
	0x6c26: "T\x06\u6c26", // 氦
	0x6c27: "T\x06\u6c27", // 氧
	0x6c28: "T\x06\u6c28", // 氨
	0x6c29: "T\x06\u6c29", // 氩
	0x6c2a: "T\a\u6c2a", // 氪
	0x6c2b: "T\a\u6c2b", // 氫
	0x6c2c: "T\b\u6c2c", // 氬
	0x6c2d: "T\b\u6c2d", // 氭
	0x6c2e: "T\b\u6c2e", // 氮
	0x6c2f: "T\b\u6c2f", // 氯
	0x6c30: "T\b\u6c30", // 氰
	0x6c31: "T\t\u6c31", // 氱
	0x6c32: "T\n\u6c32", // 氲
	0x6c33: "T\n\u6c33", // 氳
	0x6c34: "U\x00\u6c34", // 水
	0x6c35: "U\x00\u6c35", // 氵
	0x6c36: "U\x01\u6c36", // 氶
	0x6c37: "U\x01\u6c37", // 氷
	0x6c38: "U\x01\u6c38", // 永
	0x6c39: "U\x01\u6c39", // 氹
	0x6c3a: "U\x00\u6c3a", // 氺
	0x6c3b: "U\x02\u6c3b", // 氻
	0x6c3c: "U\x02\u6c3c", // 氼
	0x6c3d: "\v\x04\u6c3d", // 氽
	0x6c3e: "U\x02\u6c3e", // 氾
	0x6c3f: "U\x02\u6c3f", // 氿
	0x6c40: "U\x02\u6c40", // 汀
	0x6c41: "U\x02\u6c41", // 汁
	0x6c42: "U\x02\u6c42", // 求
	0x6c43: "U\x02\u6c43", // 汃
	0x6c44: "U\x02\u6c44", // 汄
	0x6c45: "U\x02\u6c45", // 汅
	0x6c46: "U\x02\u6c46", // 汆
	0x6c47: "U\x02\u6c47", // 汇
	0x6c48: "U\x02\u6c48", // 汈
	0x6c49: "U\x02\u6c49", // 汉
	0x6c4a: "U\x03\u6c4a", // 汊
	0x6c4b: "U\x03\u6c4b", // 汋
	0x6c4c: "U\x03\u6c4c", // 汌
	0x6c4d: "U\x03\u6c4d", // 汍
	0x6c4e: "U\x03\u6c4e", // 汎
	0x6c4f: "U\x03\u6c4f", // 汏
	0x6c50: "U\x03\u6c50", // 汐
	0x6c51: "U\x03\u6c51", // 汑
	0x6c52: "U\x03\u6c52", // 汒
	0x6c53: "U\x03\u6c53", // 汓
	0x6c54: "U\x03\u6c54", // 汔
	0x6c55: "U\x03\u6c55", // 汕
	0x6c56: "U\x03\u6c56", // 汖
	0x6c57: "U\x03\u6c57", // 汗
	0x6c58: "U\x03\u6c58", // 汘
	0x6c59: "U\x03\u6c59", // 汙
	0x6c5a: "U\x03\u6c5a", // 汚
	0x6c5b: "U\x03\u6c5b", // 汛
	0x6c5c: "U\x03\u6c5c", // 汜
	0x6c5d: "U\x03\u6c5d", // 汝
	0x6c5e: "U\x03\u6c5e", // 汞
	0x6c5f: "U\x03\u6c5f", // 江
	0x6c60: "U\x03\u6c60", // 池
	0x6c61: "U\x03\u6c61", // 污
	0x6c62: "U\x03\u6c62", // 汢
	0x6c63: "U\x03\u6c63", // 汣
	0x6c64: "U\x03\u6c64", // 汤
	0x6c65: "U\x04\u6c65", // 汥
	0x6c66: "U\x04\u6c66", // 汦
	0x6c67: "U\x04\u6c67", // 汧
	0x6c68: "U\x04\u6c68", // 汨
	0x6c69: "U\x04\u6c69", // 汩
	0x6c6a: "U\x04\u6c6a", // 汪
	0x6c6b: "U\x04\u6c6b", // 汫
	0x6c6c: "U\x04\u6c6c", // 汬
	0x6c6d: "U\x04\u6c6d", // 汭
	0x6c6e: "U\x04\u6c6e", // 汮
	0x6c6f: "U\x04\u6c6f", // 汯
	0x6c70: "U\x04\u6c70", // 汰
	0x6c71: "U\x04\u6c71", // 汱
	0x6c72: "U\x04\u6c72", // 汲
	0x6c73: "U\x04\u6c73", // 汳
	0x6c74: "U\x04\u6c74", // 汴
	0x6c75: "U\x04\u6c75", // 汵
	0x6c76: "U\x04\u6c76", // 汶
	0x6c77: "U\x04\u6c77", // 汷
	0x6c78: "U\x04\u6c78", // 汸
	0x6c79: "U\x04\u6c79", // 汹
	0x6c7a: "U\x04\u6c7a", // 決
	0x6c7b: "U\x04\u6c7b", // 汻
	0x6c7c: "U\x04\u6c7c", // 汼
	0x6c7d: "U\x04\u6c7d", // 汽
	0x6c7e: "U\x04\u6c7e", // 汾
	0x6c7f: "U\x04\u6c7f", // 汿
	0x6c80: "U\x04\u6c80", // 沀
	0x6c81: "U\x04\u6c81", // 沁
	0x6c82: "U\x04\u6c82", // 沂
	0x6c83: "U\x04\u6c83", // 沃
	0x6c84: "U\x04\u6c84", // 沄
	0x6c85: "U\x04\u6c85", // 沅
	0x6c86: "U\x04\u6c86", // 沆
	0x6c87: "U\x04\u6c87", // 沇
	0x6c88: "U\x04\u6c88", // 沈
	0x6c89: "U\x04\u6c89", // 沉
	0x6c8a: "U\x04\u6c8a", // 沊
	0x6c8b: "U\x04\u6c8b", // 沋
	0x6c8c: "U\x04\u6c8c", // 沌
	0x6c8d: "U\x04\u6c8d", // 沍
	0x6c8e: "U\x04\u6c8e", // 沎
	0x6c8f: "U\x04\u6c8f", // 沏
	0x6c90: "U\x04\u6c90", // 沐
	0x6c91: "U\x04\u6c91", // 沑
	0x6c92: "U\x04\u6c92", // 沒
	0x6c93: "U\x04\u6c93", // 沓
	0x6c94: "U\x04\u6c94", // 沔
	0x6c95: "U\x04\u6c95", // 沕
	0x6c96: "U\x04\u6c96", // 沖
	0x6c97: "U\x04\u6c97", // 沗
	0x6c98: "U\x04\u6c98", // 沘
	0x6c99: "U\x04\u6c99", // 沙
	0x6c9a: "U\x04\u6c9a", // 沚
	0x6c9b: "U\x04\u6c9b", // 沛
	0x6c9c: "U\x04\u6c9c", // 沜
	0x6c9d: "U\x04\u6c9d", // 沝
	0x6c9e: "U\x04\u6c9e", // 沞
	0x6c9f: "U\x04\u6c9f", // 沟
	0x6ca0: "U\x04\u6ca0", // 沠
	0x6ca1: "U\x04\u6ca1", // 没
	0x6ca2: "U\x04\u6ca2", // 沢
	0x6ca3: "U\x04\u6ca3", // 沣
	0x6ca4: "U\x04\u6ca4", // 沤
	0x6ca5: "U\x04\u6ca5", // 沥
	0x6ca6: "U\x04\u6ca6", // 沦
	0x6ca7: "U\x04\u6ca7", // 沧
	0x6ca8: "U\x04\u6ca8", // 沨
	0x6ca9: "U\x04\u6ca9", // 沩
	0x6caa: "U\x04\u6caa", // 沪
	0x6cab: "U\x05\u6cab", // 沫
	0x6cac: "U\x05\u6cac", // 沬
	0x6cad: "U\x05\u6cad", // 沭
	0x6cae: "U\x05\u6cae", // 沮
	0x6caf: "U\x05\u6caf", // 沯
	0x6cb0: "U\x05\u6cb0", // 沰
	0x6cb1: "U\x05\u6cb1", // 沱
	0x6cb2: "U\x05\u6cb2", // 沲
	0x6cb3: "U\x05\u6cb3", // 河
	0x6cb4: "U\x05\u6cb4", // 沴
	0x6cb5: "U\x05\u6cb5", // 沵
	0x6cb6: "U\x05\u6cb6", // 沶
	0x6cb7: "U\x05\u6cb7", // 沷
	0x6cb8: "U\x05\u6cb8", // 沸
	0x6cb9: "U\x05\u6cb9", // 油
	0x6cba: "U\x05\u6cba", // 沺
	0x6cbb: "U\x05\u6cbb", // 治
	0x6cbc: "U\x05\u6cbc", // 沼
	0x6cbd: "U\x05\u6cbd", // 沽
	0x6cbe: "U\x05\u6cbe", // 沾
	0x6cbf: "U\x05\u6cbf", // 沿
	0x6cc0: "U\x05\u6cc0", // 泀
	0x6cc1: "U\x05\u6cc1", // 況
	0x6cc2: "U\x05\u6cc2", // 泂
	0x6cc3: "U\x05\u6cc3", // 泃
	0x6cc4: "U\x05\u6cc4", // 泄
	0x6cc5: "U\x05\u6cc5", // 泅
	0x6cc6: "U\x05\u6cc6", // 泆
	0x6cc7: "U\x05\u6cc7", // 泇
	0x6cc8: "U\x05\u6cc8", // 泈
	0x6cc9: "U\x05\u6cc9", // 泉
	0x6cca: "U\x05\u6cca", // 泊
	0x6ccb: "U\x05\u6ccb", // 泋
	0x6ccc: "U\x05\u6ccc", // 泌
	0x6ccd: "U\x05\u6ccd", // 泍
	0x6cce: "U\x05\u6cce", // 泎
	0x6ccf: "U\x05\u6ccf", // 泏
	0x6cd0: "U\x05\u6cd0", // 泐
	0x6cd1: "U\x05\u6cd1", // 泑
	0x6cd2: "U\x05\u6cd2", // 泒
	0x6cd3: "U\x05\u6cd3", // 泓
	0x6cd4: "U\x05\u6cd4", // 泔
	0x6cd5: "U\x05\u6cd5", // 法
	0x6cd6: "U\x05\u6cd6", // 泖
	0x6cd7: "U\x05\u6cd7", // 泗
	0x6cd8: "U\x05\u6cd8", // 泘
	0x6cd9: "U\x05\u6cd9", // 泙
	0x6cda: "U\x06\u6cda", // 泚
	0x6cdb: "U\x05\u6cdb", // 泛
	0x6cdc: "U\x05\u6cdc", // 泜
	0x6cdd: "U\x05\u6cdd", // 泝
	0x6cde: "U\x05\u6cde", // 泞
	0x6cdf: "U\x05\u6cdf", // 泟
	0x6ce0: "U\x05\u6ce0", // 泠
	0x6ce1: "U\x05\u6ce1", // 泡
	0x6ce2: "U\x05\u6ce2", // 波
	0x6ce3: "U\x05\u6ce3", // 泣
	0x6ce4: "U\x05\u6ce4", // 泤
	0x6ce5: "U\x05\u6ce5", // 泥
	0x6ce6: "U\x05\u6ce6", // 泦
	0x6ce7: "U\x05\u6ce7", // 泧
	0x6ce8: "U\x05\u6ce8", // 注
	0x6ce9: "U\x05\u6ce9", // 泩
	0x6cea: "U\x05\u6cea", // 泪
	0x6ceb: "U\x05\u6ceb", // 泫
	0x6cec: "U\x05\u6cec", // 泬
	0x6ced: "U\x05\u6ced", // 泭
	0x6cee: "U\x05\u6cee", // 泮
	0x6cef: "U\x05\u6cef", // 泯
	0x6cf0: "U\x05\u6cf0", // 泰
	0x6cf1: "U\x05\u6cf1", // 泱
	0x6cf2: "U\x05\u6cf2", // 泲
	0x6cf3: "U\x05\u6cf3", // 泳
	0x6cf4: "U\x05\u6cf4", // 泴
	0x6cf5: "p\x04\u6cf5", // 泵
	0x6cf6: "U\x05\u6cf6", // 泶
	0x6cf7: "U\x05\u6cf7", // 泷
	0x6cf8: "U\x05\u6cf8", // 泸
	0x6cf9: "U\x05\u6cf9", // 泹
	0x6cfa: "U\x05\u6cfa", // 泺
	0x6cfb: "U\x05\u6cfb", // 泻
	0x6cfc: "U\x05\u6cfc", // 泼
	0x6cfd: "U\x05\u6cfd", // 泽
	0x6cfe: "U\x05\u6cfe", // 泾
	0x6cff: "U\x06\u6cff", // 泿
	0x6d00: "U\x06\u6d00", // 洀
	0x6d01: "U\x06\u6d01", // 洁
	0x6d02: "U\x06\u6d02", // 洂
	0x6d03: "U\x06\u6d03", // 洃
	0x6d04: "U\x06\u6d04", // 洄
	0x6d05: "U\x06\u6d05", // 洅
	0x6d06: "U\x06\u6d06", // 洆
	0x6d07: "U\x06\u6d07", // 洇
	0x6d08: "U\x06\u6d08", // 洈
	0x6d09: "U\x06\u6d09", // 洉
	0x6d0a: "U\x06\u6d0a", // 洊
	0x6d0b: "U\x06\u6d0b", // 洋
	0x6d0c: "U\x06\u6d0c", // 洌
	0x6d0d: "U\a\u6d0d", // 洍
	0x6d0e: "U\x06\u6d0e", // 洎
	0x6d0f: "U\x06\u6d0f", // 洏
	0x6d10: "U\x06\u6d10", // 洐
	0x6d11: "U\x06\u6d11", // 洑
	0x6d12: "U\x06\u6d12", // 洒
	0x6d13: "U\x06\u6d13", // 洓
	0x6d14: "U\x06\u6d14", // 洔
	0x6d15: "U\x06\u6d15", // 洕
	0x6d16: "U\a\u6d16", // 洖
	0x6d17: "U\x06\u6d17", // 洗
	0x6d18: "U\x06\u6d18", // 洘
	0x6d19: "U\x06\u6d19", // 洙
	0x6d1a: "U\x06\u6d1a", // 洚
	0x6d1b: "U\x06\u6d1b", // 洛
	0x6d1c: "U\x06\u6d1c", // 洜
	0x6d1d: "U\x06\u6d1d", // 洝
	0x6d1e: "U\x06\u6d1e", // 洞
	0x6d1f: "U\x06\u6d1f", // 洟
	0x6d20: "U\x06\u6d20", // 洠
	0x6d21: "U\x06\u6d21", // 洡
	0x6d22: "U\x06\u6d22", // 洢
	0x6d23: "U\x06\u6d23", // 洣
	0x6d24: "U\x06\u6d24", // 洤
	0x6d25: "U\x06\u6d25", // 津
	0x6d26: "U\x06\u6d26", // 洦
	0x6d27: "U\x06\u6d27", // 洧
	0x6d28: "U\x06\u6d28", // 洨
	0x6d29: "U\x06\u6d29", // 洩
	0x6d2a: "U\x06\u6d2a", // 洪
	0x6d2b: "U\x06\u6d2b", // 洫
	0x6d2c: "U\x06\u6d2c", // 洬
	0x6d2d: "U\x06\u6d2d", // 洭
	0x6d2e: "U\x06\u6d2e", // 洮
	0x6d2f: "U\x06\u6d2f", // 洯
	0x6d30: "U\x06\u6d30", // 洰
	0x6d31: "U\x06\u6d31", // 洱
	0x6d32: "U\x06\u6d32", // 洲
	0x6d33: "U\x06\u6d33", // 洳
	0x6d34: "U\x06\u6d34", // 洴
	0x6d35: "U\x06\u6d35", // 洵
	0x6d36: "U\x06\u6d36", // 洶
	0x6d37: "U\x06\u6d37", // 洷
	0x6d38: "U\x06\u6d38", // 洸
	0x6d39: "U\x06\u6d39", // 洹
	0x6d3a: "U\x06\u6d3a", // 洺
	0x6d3b: "U\x06\u6d3b", // 活
	0x6d3c: "U\x06\u6d3c", // 洼
	0x6d3d: "U\x06\u6d3d", // 洽
	0x6d3e: "U\x06\u6d3e", // 派
	0x6d3f: "U\x06\u6d3f", // 洿
	0x6d40: "U\x06\u6d40", // 浀
	0x6d41: "U\x06\u6d41", // 流
	0x6d42: "U\x06\u6d42", // 浂
	0x6d43: "U\x06\u6d43", // 浃
	0x6d44: "U\x06\u6d44", // 浄
	0x6d45: "U\x06\u6d45", // 浅
	0x6d46: "U\x06\u6d46", // 浆
	0x6d47: "U\x06\u6d47", // 浇
	0x6d48: "U\x06\u6d48", // 浈
	0x6d49: "U\x06\u6d49", // 浉
	0x6d4a: "U\x06\u6d4a", // 浊
	0x6d4b: "U\x06\u6d4b", // 测
	0x6d4c: "U\x06\u6d4c", // 浌
	0x6d4d: "U\x06\u6d4d", // 浍
	0x6d4e: "U\x06\u6d4e", // 济
	0x6d4f: "U\x06\u6d4f", // 浏
	0x6d50: "U\x06\u6d50", // 浐
	0x6d51: "U\x06\u6d51", // 浑
	0x6d52: "U\x06\u6d52", // 浒
	0x6d53: "U\x06\u6d53", // 浓
	0x6d54: "U\x06\u6d54", // 浔
	0x6d55: "U\x06\u6d55", // 浕
	0x6d56: "U\a\u6d56", // 浖
	0x6d57: "U\a\u6d57", // 浗
	0x6d58: "U\a\u6d58", // 浘
	0x6d59: "U\a\u6d59", // 浙
	0x6d5a: "U\a\u6d5a", // 浚
	0x6d5b: "U\a\u6d5b", // 浛
	0x6d5c: "U\a\u6d5c", // 浜
	0x6d5d: "U\a\u6d5d", // 浝
	0x6d5e: "U\a\u6d5e", // 浞
	0x6d5f: "U\a\u6d5f", // 浟
	0x6d60: "U\a\u6d60", // 浠
	0x6d61: "U\a\u6d61", // 浡
	0x6d62: "U\a\u6d62", // 浢
	0x6d63: "U\a\u6d63", // 浣
	0x6d64: "U\a\u6d64", // 浤
	0x6d65: "U\a\u6d65", // 浥
	0x6d66: "U\a\u6d66", // 浦
	0x6d67: "U\a\u6d67", // 浧
	0x6d68: "U\a\u6d68", // 浨
	0x6d69: "U\a\u6d69", // 浩
	0x6d6a: "U\a\u6d6a", // 浪
	0x6d6b: "U\a\u6d6b", // 浫
	0x6d6c: "U\a\u6d6c", // 浬
	0x6d6d: "U\a\u6d6d", // 浭
	0x6d6e: "U\a\u6d6e", // 浮
	0x6d6f: "U\a\u6d6f", // 浯
	0x6d70: "U\a\u6d70", // 浰
	0x6d71: "U\a\u6d71", // 浱
	0x6d72: "U\a\u6d72", // 浲
	0x6d73: "U\a\u6d73", // 浳
	0x6d74: "U\a\u6d74", // 浴
	0x6d75: "U\a\u6d75", // 浵
	0x6d76: "U\a\u6d76", // 浶
	0x6d77: "U\a\u6d77", // 海
	0x6d78: "U\a\u6d78", // 浸
	0x6d79: "U\a\u6d79", // 浹
	0x6d7a: "U\a\u6d7a", // 浺
	0x6d7b: "U\a\u6d7b", // 浻
	0x6d7c: "U\a\u6d7c", // 浼
	0x6d7d: "U\a\u6d7d", // 浽
	0x6d7e: "U\a\u6d7e", // 浾
	0x6d7f: "U\a\u6d7f", // 浿
	0x6d80: "U\a\u6d80", // 涀
	0x6d81: "U\a\u6d81", // 涁
	0x6d82: "U\a\u6d82", // 涂
	0x6d83: "U\a\u6d83", // 涃
	0x6d84: "U\a\u6d84", // 涄
	0x6d85: "U\a\u6d85", // 涅
	0x6d86: "U\a\u6d86", // 涆
	0x6d87: "U\a\u6d87", // 涇
	0x6d88: "U\a\u6d88", // 消
	0x6d89: "U\a\u6d89", // 涉
	0x6d8a: "U\a\u6d8a", // 涊
	0x6d8b: "U\a\u6d8b", // 涋
	0x6d8c: "U\a\u6d8c", // 涌
	0x6d8d: "U\a\u6d8d", // 涍
	0x6d8e: "U\a\u6d8e", // 涎
	0x6d8f: "U\a\u6d8f", // 涏
	0x6d90: "U\a\u6d90", // 涐
	0x6d91: "U\a\u6d91", // 涑
	0x6d92: "U\a\u6d92", // 涒
	0x6d93: "U\a\u6d93", // 涓
	0x6d94: "U\a\u6d94", // 涔
	0x6d95: "U\a\u6d95", // 涕
	0x6d96: "U\a\u6d96", // 涖
	0x6d97: "U\a\u6d97", // 涗
	0x6d98: "U\a\u6d98", // 涘
	0x6d99: "U\b\u6d99", // 涙
	0x6d9a: "U\a\u6d9a", // 涚
	0x6d9b: "U\a\u6d9b", // 涛
	0x6d9c: "U\a\u6d9c", // 涜
	0x6d9d: "U\a\u6d9d", // 涝
	0x6d9e: "U\a\u6d9e", // 涞
	0x6d9f: "U\a\u6d9f", // 涟
	0x6da0: "U\a\u6da0", // 涠
	0x6da1: "U\a\u6da1", // 涡
	0x6da2: "U\a\u6da2", // 涢
	0x6da3: "U\a\u6da3", // 涣
	0x6da4: "U\a\u6da4", // 涤
	0x6da5: "U\a\u6da5", // 涥
	0x6da6: "U\a\u6da6", // 润
	0x6da7: "U\a\u6da7", // 涧
	0x6da8: "U\a\u6da8", // 涨
	0x6da9: "U\a\u6da9", // 涩
	0x6daa: "U\b\u6daa", // 涪
	0x6dab: "U\b\u6dab", // 涫
	0x6dac: "U\b\u6dac", // 涬
	0x6dad: "U\b\u6dad", // 涭
	0x6dae: "U\b\u6dae", // 涮
	0x6daf: "U\b\u6daf", // 涯
	0x6db0: "U\b\u6db0", // 涰
	0x6db1: "U\b\u6db1", // 涱
	0x6db2: "U\b\u6db2", // 液
	0x6db3: "U\b\u6db3", // 涳
	0x6db4: "U\b\u6db4", // 涴
	0x6db5: "U\b\u6db5", // 涵
	0x6db6: "U\b\u6db6", // 涶
	0x6db7: "U\b\u6db7", // 涷
	0x6db8: "U\b\u6db8", // 涸
	0x6db9: "U\b\u6db9", // 涹
	0x6dba: "U\b\u6dba", // 涺
	0x6dbb: "U\b\u6dbb", // 涻
	0x6dbc: "U\b\u6dbc", // 涼
	0x6dbd: "U\b\u6dbd", // 涽
	0x6dbe: "U\b\u6dbe", // 涾
	0x6dbf: "U\b\u6dbf", // 涿
	0x6dc0: "U\b\u6dc0", // 淀
	0x6dc1: "U\b\u6dc1", // 淁
	0x6dc2: "U\b\u6dc2", // 淂
	0x6dc3: "U\b\u6dc3", // 淃
	0x6dc4: "U\b\u6dc4", // 淄
	0x6dc5: "U\b\u6dc5", // 淅
	0x6dc6: "U\b\u6dc6", // 淆
	0x6dc7: "U\b\u6dc7", // 淇
	0x6dc8: "U\b\u6dc8", // 淈
	0x6dc9: "U\b\u6dc9", // 淉
	0x6dca: "U\b\u6dca", // 淊
	0x6dcb: "U\b\u6dcb", // 淋
	0x6dcc: "U\b\u6dcc", // 淌
	0x6dcd: "U\b\u6dcd", // 淍
	0x6dce: "U\b\u6dce", // 淎
	0x6dcf: "U\b\u6dcf", // 淏
	0x6dd0: "U\b\u6dd0", // 淐
	0x6dd1: "U\b\u6dd1", // 淑
	0x6dd2: "U\b\u6dd2", // 淒
	0x6dd3: "U\b\u6dd3", // 淓
	0x6dd4: "U\b\u6dd4", // 淔
	0x6dd5: "U\b\u6dd5", // 淕
	0x6dd6: "U\b\u6dd6", // 淖
	0x6dd7: "U\b\u6dd7", // 淗
	0x6dd8: "U\b\u6dd8", // 淘
	0x6dd9: "U\b\u6dd9", // 淙
	0x6dda: "U\b\u6dda", // 淚
	0x6ddb: "U\b\u6ddb", // 淛
	0x6ddc: "U\b\u6ddc", // 淜
	0x6ddd: "U\b\u6ddd", // 淝
	0x6dde: "U\b\u6dde", // 淞
	0x6ddf: "U\b\u6ddf", // 淟
	0x6de0: "U\b\u6de0", // 淠
	0x6de1: "U\b\u6de1", // 淡
	0x6de2: "U\b\u6de2", // 淢
	0x6de3: "U\b\u6de3", // 淣
	0x6de4: "U\b\u6de4", // 淤
	0x6de5: "U\b\u6de5", // 淥
	0x6de6: "U\b\u6de6", // 淦
	0x6de7: "U\b\u6de7", // 淧
	0x6de8: "U\b\u6de8", // 淨
	0x6de9: "U\b\u6de9", // 淩
	0x6dea: "U\b\u6dea", // 淪
	0x6deb: "U\b\u6deb", // 淫
	0x6dec: "U\b\u6dec", // 淬
	0x6ded: "U\b\u6ded", // 淭
	0x6dee: "U\b\u6dee", // 淮
	0x6def: "U\b\u6def", // 淯
	0x6df0: "U\b\u6df0", // 淰
	0x6df1: "U\b\u6df1", // 深
	0x6df2: "U\b\u6df2", // 淲
	0x6df3: "U\b\u6df3", // 淳
	0x6df4: "U\b\u6df4", // 淴
	0x6df5: "U\b\u6df5", // 淵
	0x6df6: "U\b\u6df6", // 淶
	0x6df7: "U\b\u6df7", // 混
	0x6df8: "U\b\u6df8", // 淸
	0x6df9: "U\b\u6df9", // 淹
	0x6dfa: "U\b\u6dfa", // 淺
	0x6dfb: "U\b\u6dfb", // 添
	0x6dfc: "U\b\u6dfc", // 淼
	0x6dfd: "U\b\u6dfd", // 淽
	0x6dfe: "U\b\u6dfe", // 淾
	0x6dff: "U\b\u6dff", // 淿
	0x6e00: "U\b\u6e00", // 渀
	0x6e01: "U\b\u6e01", // 渁
	0x6e02: "U\b\u6e02", // 渂
	0x6e03: "U\t\u6e03", // 渃
	0x6e04: "U\b\u6e04", // 渄
	0x6e05: "U\b\u6e05", // 清
	0x6e06: "U\b\u6e06", // 渆
	0x6e07: "U\b\u6e07", // 渇
	0x6e08: "U\b\u6e08", // 済
	0x6e09: "U\b\u6e09", // 渉
	0x6e0a: "U\b\u6e0a", // 渊
	0x6e0b: "U\b\u6e0b", // 渋
	0x6e0c: "U\b\u6e0c", // 渌
	0x6e0d: "U\b\u6e0d", // 渍
	0x6e0e: "U\b\u6e0e", // 渎
	0x6e0f: "U\b\u6e0f", // 渏
	0x6e10: "U\b\u6e10", // 渐
	0x6e11: "U\b\u6e11", // 渑
	0x6e12: "U\b\u6e12", // 渒
	0x6e13: "U\b\u6e13", // 渓
	0x6e14: "U\b\u6e14", // 渔
	0x6e15: "U\b\u6e15", // 渕
	0x6e16: "U\b\u6e16", // 渖
	0x6e17: "U\b\u6e17", // 渗
	0x6e18: "U\t\u6e18", // 渘
	0x6e19: "U\t\u6e19", // 渙
	0x6e1a: "U\b\u6e1a", // 渚
	0x6e1b: "U\t\u6e1b", // 減
	0x6e1c: "U\t\u6e1c", // 渜
	0x6e1d: "U\t\u6e1d", // 渝
	0x6e1e: "U\t\u6e1e", // 渞
	0x6e1f: "U\t\u6e1f", // 渟
	0x6e20: "U\t\u6e20", // 渠
	0x6e21: "U\t\u6e21", // 渡
	0x6e22: "U\t\u6e22", // 渢
	0x6e23: "U\t\u6e23", // 渣
	0x6e24: "U\t\u6e24", // 渤
	0x6e25: "U\t\u6e25", // 渥
	0x6e26: "U\t\u6e26", // 渦
	0x6e27: "U\t\u6e27", // 渧
	0x6e28: "U\t\u6e28", // 渨
	0x6e29: "U\t\u6e29", // 温
	0x6e2a: "U\t\u6e2a", // 渪
	0x6e2b: "U\t\u6e2b", // 渫
	0x6e2c: "U\t\u6e2c", // 測
	0x6e2d: "U\t\u6e2d", // 渭
	0x6e2e: "U\t\u6e2e", // 渮
	0x6e2f: "U\t\u6e2f", // 港
	0x6e30: "U\t\u6e30", // 渰
	0x6e31: "U\t\u6e31", // 渱
	0x6e32: "U\t\u6e32", // 渲
	0x6e33: "U\t\u6e33", // 渳
	0x6e34: "U\t\u6e34", // 渴
	0x6e35: "U\t\u6e35", // 渵
	0x6e36: "U\t\u6e36", // 渶
	0x6e37: "U\t\u6e37", // 渷
	0x6e38: "U\t\u6e38", // 游
	0x6e39: "U\t\u6e39", // 渹
	0x6e3a: "U\t\u6e3a", // 渺
	0x6e3b: "U\t\u6e3b", // 渻
	0x6e3c: "U\t\u6e3c", // 渼
	0x6e3d: "U\t\u6e3d", // 渽
	0x6e3e: "U\t\u6e3e", // 渾
	0x6e3f: "U\t\u6e3f", // 渿
	0x6e40: "U\t\u6e40", // 湀
	0x6e41: "U\t\u6e41", // 湁
	0x6e42: "U\t\u6e42", // 湂
	0x6e43: "U\t\u6e43", // 湃
	0x6e44: "U\t\u6e44", // 湄
	0x6e45: "U\t\u6e45", // 湅
	0x6e46: "U\t\u6e46", // 湆
	0x6e47: "U\t\u6e47", // 湇
	0x6e48: "U\t\u6e48", // 湈
	0x6e49: "U\t\u6e49", // 湉
	0x6e4a: "U\t\u6e4a", // 湊
	0x6e4b: "U\t\u6e4b", // 湋
	0x6e4c: "U\t\u6e4c", // 湌
	0x6e4d: "U\t\u6e4d", // 湍
	0x6e4e: "U\t\u6e4e", // 湎
	0x6e4f: "U\t\u6e4f", // 湏
	0x6e50: "U\t\u6e50", // 湐
	0x6e51: "U\t\u6e51", // 湑
	0x6e52: "U\t\u6e52", // 湒
	0x6e53: "U\t\u6e53", // 湓
	0x6e54: "U\t\u6e54", // 湔
	0x6e55: "U\t\u6e55", // 湕
	0x6e56: "U\t\u6e56", // 湖
	0x6e57: "U\t\u6e57", // 湗
	0x6e58: "U\t\u6e58", // 湘
	0x6e59: "U\t\u6e59", // 湙
	0x6e5a: "U\t\u6e5a", // 湚
	0x6e5b: "U\t\u6e5b", // 湛
	0x6e5c: "U\t\u6e5c", // 湜
	0x6e5d: "U\t\u6e5d", // 湝
	0x6e5e: "U\t\u6e5e", // 湞
	0x6e5f: "U\t\u6e5f", // 湟
	0x6e60: "U\t\u6e60", // 湠
	0x6e61: "U\t\u6e61", // 湡
	0x6e62: "U\t\u6e62", // 湢
	0x6e63: "U\t\u6e63", // 湣
	0x6e64: "U\t\u6e64", // 湤
	0x6e65: "U\t\u6e65", // 湥
	0x6e66: "U\t\u6e66", // 湦
	0x6e67: "U\t\u6e67", // 湧
	0x6e68: "U\t\u6e68", // 湨
	0x6e69: "U\t\u6e69", // 湩
	0x6e6a: "U\t\u6e6a", // 湪
	0x6e6b: "U\t\u6e6b", // 湫
	0x6e6c: "U\t\u6e6c", // 湬
	0x6e6d: "U\t\u6e6d", // 湭
	0x6e6e: "U\t\u6e6e", // 湮
	0x6e6f: "U\t\u6e6f", // 湯
	0x6e70: "U\t\u6e70", // 湰
	0x6e71: "U\t\u6e71", // 湱
	0x6e72: "U\t\u6e72", // 湲
	0x6e73: "U\t\u6e73", // 湳
	0x6e74: "U\b\u6e74", // 湴
	0x6e75: "U\t\u6e75", // 湵
	0x6e76: "U\t\u6e76", // 湶
	0x6e77: "U\t\u6e77", // 湷
	0x6e78: "U\t\u6e78", // 湸
	0x6e79: "U\t\u6e79", // 湹
	0x6e7a: "U\t\u6e7a", // 湺
	0x6e7b: "U\t\u6e7b", // 湻
	0x6e7c: "U\t\u6e7c", // 湼
	0x6e7d: "U\t\u6e7d", // 湽
	0x6e7e: "U\t\u6e7e", // 湾
	0x6e7f: "U\t\u6e7f", // 湿
	0x6e80: "U\t\u6e80", // 満
	0x6e81: "U\t\u6e81", // 溁
	0x6e82: "U\t\u6e82", // 溂
	0x6e83: "U\t\u6e83", // 溃
	0x6e84: "U\t\u6e84", // 溄
	0x6e85: "U\t\u6e85", // 溅
	0x6e86: "U\t\u6e86", // 溆
	0x6e87: "U\t\u6e87", // 溇
	0x6e88: "U\t\u6e88", // 溈
	0x6e89: "U\t\u6e89", // 溉
	0x6e8a: "U\t\u6e8a", // 溊
	0x6e8b: "U\t\u6e8b", // 溋
	0x6e8c: "U\t\u6e8c", // 溌
	0x6e8d: "U\n\u6e8d", // 溍
	0x6e8e: "U\n\u6e8e", // 溎
	0x6e8f: "U\n\u6e8f", // 溏
	0x6e90: "U\n\u6e90", // 源
	0x6e91: "U\n\u6e91", // 溑
	0x6e92: "U\n\u6e92", // 溒
	0x6e93: "U\n\u6e93", // 溓
	0x6e94: "U\n\u6e94", // 溔
	0x6e95: "U\n\u6e95", // 溕
	0x6e96: "U\n\u6e96", // 準
	0x6e97: "U\n\u6e97", // 溗
	0x6e98: "U\n\u6e98", // 溘
	0x6e99: "U\n\u6e99", // 溙
	0x6e9a: "U\n\u6e9a", // 溚
	0x6e9b: "U\n\u6e9b", // 溛
	0x6e9c: "U\n\u6e9c", // 溜
	0x6e9d: "U\n\u6e9d", // 溝
	0x6e9e: "U\n\u6e9e", // 溞
	0x6e9f: "U\n\u6e9f", // 溟
	0x6ea0: "U\n\u6ea0", // 溠
	0x6ea1: "U\n\u6ea1", // 溡
	0x6ea2: "U\n\u6ea2", // 溢
	0x6ea3: "U\n\u6ea3", // 溣
	0x6ea4: "U\n\u6ea4", // 溤
	0x6ea5: "U\n\u6ea5", // 溥
	0x6ea6: "U\n\u6ea6", // 溦
	0x6ea7: "U\n\u6ea7", // 溧
	0x6ea8: "U\n\u6ea8", // 溨
	0x6ea9: "U\n\u6ea9", // 溩
	0x6eaa: "U\n\u6eaa", // 溪
	0x6eab: "U\n\u6eab", // 溫
	0x6eac: "U\n\u6eac", // 溬
	0x6ead: "U\n\u6ead", // 溭
	0x6eae: "U\n\u6eae", // 溮
	0x6eaf: "U\n\u6eaf", // 溯
	0x6eb0: "U\n\u6eb0", // 溰
	0x6eb1: "U\n\u6eb1", // 溱
	0x6eb2: "U\n\u6eb2", // 溲
	0x6eb3: "U\n\u6eb3", // 溳
	0x6eb4: "U\n\u6eb4", // 溴
	0x6eb5: "U\n\u6eb5", // 溵
	0x6eb6: "U\n\u6eb6", // 溶
	0x6eb7: "U\n\u6eb7", // 溷
	0x6eb8: "U\n\u6eb8", // 溸
	0x6eb9: "U\n\u6eb9", // 溹
	0x6eba: "U\n\u6eba", // 溺
	0x6ebb: "U\n\u6ebb", // 溻
	0x6ebc: "U\n\u6ebc", // 溼
	0x6ebd: "U\n\u6ebd", // 溽
	0x6ebe: "U\n\u6ebe", // 溾
	0x6ebf: "U\n\u6ebf", // 溿
	0x6ec0: "U\n\u6ec0", // 滀
	0x6ec1: "U\n\u6ec1", // 滁
	0x6ec2: "U\n\u6ec2", // 滂
	0x6ec3: "U\n\u6ec3", // 滃
	0x6ec4: "U\n\u6ec4", // 滄
	0x6ec5: "U\n\u6ec5", // 滅
	0x6ec6: "U\n\u6ec6", // 滆
	0x6ec7: "U\n\u6ec7", // 滇
	0x6ec8: "U\n\u6ec8", // 滈
	0x6ec9: "U\n\u6ec9", // 滉
	0x6eca: "U\n\u6eca", // 滊
	0x6ecb: "U\t\u6ecb", // 滋
	0x6ecc: "U\v\u6ecc", // 滌
	0x6ecd: "U\n\u6ecd", // 滍
	0x6ece: "U\n\u6ece", // 滎
	0x6ecf: "U\n\u6ecf", // 滏
	0x6ed0: "U\n\u6ed0", // 滐
	0x6ed1: "U\n\u6ed1", // 滑
	0x6ed2: "U\n\u6ed2", // 滒
	0x6ed3: "U\n\u6ed3", // 滓
	0x6ed4: "U\n\u6ed4", // 滔
	0x6ed5: "U\n\u6ed5", // 滕
	0x6ed6: "U\n\u6ed6", // 滖
	0x6ed7: "U\n\u6ed7", // 滗
	0x6ed8: "U\n\u6ed8", // 滘
	0x6ed9: "U\n\u6ed9", // 滙
	0x6eda: "U\v\u6eda", // 滚
	0x6edb: "U\n\u6edb", // 滛
	0x6edc: "U\n\u6edc", // 滜
	0x6edd: "U\n\u6edd", // 滝
	0x6ede: "U\t\u6ede", // 滞
	0x6edf: "U\n\u6edf", // 滟
	0x6ee0: "U\n\u6ee0", // 滠
	0x6ee1: "U\n\u6ee1", // 满
	0x6ee2: "U\n\u6ee2", // 滢
	0x6ee3: "U\n\u6ee3", // 滣
	0x6ee4: "U\n\u6ee4", // 滤
	0x6ee5: "U\n\u6ee5", // 滥
	0x6ee6: "U\n\u6ee6", // 滦
	0x6ee7: "U\n\u6ee7", // 滧
	0x6ee8: "U\n\u6ee8", // 滨
	0x6ee9: "U\n\u6ee9", // 滩
	0x6eea: "U\n\u6eea", // 滪
	0x6eeb: "U\v\u6eeb", // 滫
	0x6eec: "U\v\u6eec", // 滬
	0x6eed: "U\v\u6eed", // 滭
	0x6eee: "U\v\u6eee", // 滮
	0x6eef: "U\v\u6eef", // 滯
	0x6ef0: "U\v\u6ef0", // 滰
	0x6ef1: "U\v\u6ef1", // 滱
	0x6ef2: "U\v\u6ef2", // 滲
	0x6ef3: "U\v\u6ef3", // 滳
	0x6ef4: "U\v\u6ef4", // 滴
	0x6ef5: "U\v\u6ef5", // 滵
	0x6ef6: "U\v\u6ef6", // 滶
	0x6ef7: "U\v\u6ef7", // 滷
	0x6ef8: "U\v\u6ef8", // 滸
	0x6ef9: "U\v\u6ef9", // 滹
	0x6efa: "U\v\u6efa", // 滺
	0x6efb: "U\v\u6efb", // 滻
	0x6efc: "U\v\u6efc", // 滼
	0x6efd: "U\v\u6efd", // 滽
	0x6efe: "U\v\u6efe", // 滾
	0x6eff: "U\v\u6eff", // 滿
	0x6f00: "U\v\u6f00", // 漀
	0x6f01: "U\v\u6f01", // 漁
	0x6f02: "U\v\u6f02", // 漂
	0x6f03: "U\v\u6f03", // 漃
	0x6f04: "U\v\u6f04", // 漄
	0x6f05: "U\v\u6f05", // 漅
	0x6f06: "U\v\u6f06", // 漆
	0x6f07: "U\v\u6f07", // 漇
	0x6f08: "U\v\u6f08", // 漈
	0x6f09: "U\v\u6f09", // 漉
	0x6f0a: "U\v\u6f0a", // 漊
	0x6f0b: "U\f\u6f0b", // 漋
	0x6f0c: "U\v\u6f0c", // 漌
	0x6f0d: "U\v\u6f0d", // 漍
	0x6f0e: "U\v\u6f0e", // 漎
	0x6f0f: "U\v\u6f0f", // 漏
	0x6f10: "U\v\u6f10", // 漐
	0x6f11: "U\v\u6f11", // 漑
	0x6f12: "U\v\u6f12", // 漒
	0x6f13: "U\n\u6f13", // 漓
	0x6f14: "U\v\u6f14", // 演
	0x6f15: "U\v\u6f15", // 漕
	0x6f16: "U\v\u6f16", // 漖
	0x6f17: "U\v\u6f17", // 漗
	0x6f18: "U\v\u6f18", // 漘
	0x6f19: "U\v\u6f19", // 漙
	0x6f1a: "U\v\u6f1a", // 漚
	0x6f1b: "U\v\u6f1b", // 漛
	0x6f1c: "U\v\u6f1c", // 漜
	0x6f1d: "U\v\u6f1d", // 漝
	0x6f1e: "U\v\u6f1e", // 漞
	0x6f1f: "U\v\u6f1f", // 漟
	0x6f20: "U\v\u6f20", // 漠
	0x6f21: "U\v\u6f21", // 漡
	0x6f22: "U\v\u6f22", // 漢
	0x6f23: "U\v\u6f23", // 漣
	0x6f24: "U\v\u6f24", // 漤
	0x6f25: "U\v\u6f25", // 漥
	0x6f26: "U\v\u6f26", // 漦
	0x6f27: "U\v\u6f27", // 漧
	0x6f28: "U\v\u6f28", // 漨
	0x6f29: "U\v\u6f29", // 漩
	0x6f2a: "U\v\u6f2a", // 漪
	0x6f2b: "U\v\u6f2b", // 漫
	0x6f2c: "U\v\u6f2c", // 漬
	0x6f2d: "U\v\u6f2d", // 漭
	0x6f2e: "U\v\u6f2e", // 漮
	0x6f2f: "U\v\u6f2f", // 漯
	0x6f30: "U\v\u6f30", // 漰
	0x6f31: "U\v\u6f31", // 漱
	0x6f32: "U\v\u6f32", // 漲
	0x6f33: "U\v\u6f33", // 漳
	0x6f34: "U\v\u6f34", // 漴
	0x6f35: "U\v\u6f35", // 漵
	0x6f36: "U\v\u6f36", // 漶
	0x6f37: "U\v\u6f37", // 漷
	0x6f38: "U\v\u6f38", // 漸
	0x6f39: "U\v\u6f39", // 漹
	0x6f3a: "U\v\u6f3a", // 漺
	0x6f3b: "U\v\u6f3b", // 漻
	0x6f3c: "U\v\u6f3c", // 漼
	0x6f3d: "U\f\u6f3d", // 漽
	0x6f3e: "U\v\u6f3e", // 漾
	0x6f3f: "U\v\u6f3f", // 漿
	0x6f40: "U\v\u6f40", // 潀
	0x6f41: "U\v\u6f41", // 潁
	0x6f42: "U\v\u6f42", // 潂
	0x6f43: "U\v\u6f43", // 潃
	0x6f44: "U\v\u6f44", // 潄
	0x6f45: "U\v\u6f45", // 潅
	0x6f46: "U\v\u6f46", // 潆
	0x6f47: "U\v\u6f47", // 潇
	0x6f48: "U\v\u6f48", // 潈
	0x6f49: "U\v\u6f49", // 潉
	0x6f4a: "U\v\u6f4a", // 潊
	0x6f4b: "U\v\u6f4b", // 潋
	0x6f4c: "U\v\u6f4c", // 潌
	0x6f4d: "U\v\u6f4d", // 潍
	0x6f4e: "U\f\u6f4e", // 潎
	0x6f4f: "U\f\u6f4f", // 潏
	0x6f50: "U\f\u6f50", // 潐
	0x6f51: "U\f\u6f51", // 潑
	0x6f52: "U\f\u6f52", // 潒
	0x6f53: "U\f\u6f53", // 潓
	0x6f54: "U\f\u6f54", // 潔
	0x6f55: "U\f\u6f55", // 潕
	0x6f56: "U\f\u6f56", // 潖
	0x6f57: "U\f\u6f57", // 潗
	0x6f58: "U\f\u6f58", // 潘
	0x6f59: "U\f\u6f59", // 潙
	0x6f5a: "U\f\u6f5a", // 潚
	0x6f5b: "U\f\u6f5b", // 潛
	0x6f5c: "U\f\u6f5c", // 潜
	0x6f5d: "U\f\u6f5d", // 潝
	0x6f5e: "U\f\u6f5e", // 潞
	0x6f5f: "U\f\u6f5f", // 潟
	0x6f60: "U\f\u6f60", // 潠
	0x6f61: "U\f\u6f61", // 潡
	0x6f62: "U\f\u6f62", // 潢
	0x6f63: "U\f\u6f63", // 潣
	0x6f64: "U\f\u6f64", // 潤
	0x6f65: "U\f\u6f65", // 潥
	0x6f66: "U\f\u6f66", // 潦
	0x6f67: "U\f\u6f67", // 潧
	0x6f68: "U\f\u6f68", // 潨
	0x6f69: "U\f\u6f69", // 潩
	0x6f6a: "U\f\u6f6a", // 潪
	0x6f6b: "U\f\u6f6b", // 潫
	0x6f6c: "U\f\u6f6c", // 潬
	0x6f6d: "U\f\u6f6d", // 潭
	0x6f6e: "U\f\u6f6e", // 潮
	0x6f6f: "U\f\u6f6f", // 潯
	0x6f70: "U\f\u6f70", // 潰
	0x6f71: "U\f\u6f71", // 潱
	0x6f72: "U\f\u6f72", // 潲
	0x6f73: "U\f\u6f73", // 潳
	0x6f74: "U\f\u6f74", // 潴
	0x6f75: "U\f\u6f75", // 潵
	0x6f76: "U\f\u6f76", // 潶
	0x6f77: "U\f\u6f77", // 潷
	0x6f78: "U\f\u6f78", // 潸
	0x6f79: "U\f\u6f79", // 潹
	0x6f7a: "U\f\u6f7a", // 潺
	0x6f7b: "U\f\u6f7b", // 潻
	0x6f7c: "U\f\u6f7c", // 潼
	0x6f7d: "U\f\u6f7d", // 潽
	0x6f7e: "U\f\u6f7e", // 潾
	0x6f7f: "U\f\u6f7f", // 潿
	0x6f80: "U\x0e\u6f80", // 澀
	0x6f81: "U\f\u6f81", // 澁
	0x6f82: "U\f\u6f82", // 澂
	0x6f83: "U\f\u6f83", // 澃
	0x6f84: "U\f\u6f84", // 澄
	0x6f85: "U\f\u6f85", // 澅
	0x6f86: "U\f\u6f86", // 澆
	0x6f87: "U\f\u6f87", // 澇
	0x6f88: "U\f\u6f88", // 澈
	0x6f89: "U\f\u6f89", // 澉
	0x6f8a: "U\f\u6f8a", // 澊
	0x6f8b: "U\f\u6f8b", // 澋
	0x6f8c: "U\f\u6f8c", // 澌
	0x6f8d: "U\f\u6f8d", // 澍
	0x6f8e: "U\f\u6f8e", // 澎
	0x6f8f: "U\f\u6f8f", // 澏
	0x6f90: "U\f\u6f90", // 澐
	0x6f91: "U\f\u6f91", // 澑
	0x6f92: "U\f\u6f92", // 澒
	0x6f93: "U\f\u6f93", // 澓
	0x6f94: "U\f\u6f94", // 澔
	0x6f95: "U\f\u6f95", // 澕
	0x6f96: "U\f\u6f96", // 澖
	0x6f97: "U\f\u6f97", // 澗
	0x6f98: "U\f\u6f98", // 澘
	0x6f99: "U\r\u6f99", // 澙
	0x6f9a: "U\f\u6f9a", // 澚
	0x6f9b: "U\f\u6f9b", // 澛
	0x6f9c: "U\f\u6f9c", // 澜
	0x6f9d: "U\f\u6f9d", // 澝
	0x6f9e: "U\r\u6f9e", // 澞
	0x6f9f: "U\r\u6f9f", // 澟
	0x6fa0: "U\r\u6fa0", // 澠
	0x6fa1: "U\r\u6fa1", // 澡
	0x6fa2: "U\r\u6fa2", // 澢
	0x6fa3: "U\r\u6fa3", // 澣
	0x6fa4: "U\r\u6fa4", // 澤
	0x6fa5: "U\r\u6fa5", // 澥
	0x6fa6: "U\r\u6fa6", // 澦
	0x6fa7: "U\r\u6fa7", // 澧
	0x6fa8: "U\r\u6fa8", // 澨
	0x6fa9: "U\r\u6fa9", // 澩
	0x6faa: "U\r\u6faa", // 澪
	0x6fab: "U\r\u6fab", // 澫
	0x6fac: "U\r\u6fac", // 澬
	0x6fad: "U\r\u6fad", // 澭
	0x6fae: "U\r\u6fae", // 澮
	0x6faf: "U\r\u6faf", // 澯
	0x6fb0: "U\r\u6fb0", // 澰
	0x6fb1: "U\r\u6fb1", // 澱
	0x6fb2: "U\r\u6fb2", // 澲
	0x6fb3: "U\r\u6fb3", // 澳
	0x6fb4: "U\r\u6fb4", // 澴
	0x6fb5: "U\r\u6fb5", // 澵
	0x6fb6: "U\r\u6fb6", // 澶
	0x6fb7: "U\r\u6fb7", // 澷
	0x6fb8: "U\r\u6fb8", // 澸
	0x6fb9: "U\r\u6fb9", // 澹
	0x6fba: "U\r\u6fba", // 澺
	0x6fbb: "U\r\u6fbb", // 澻
	0x6fbc: "U\r\u6fbc", // 澼
	0x6fbd: "U\r\u6fbd", // 澽
	0x6fbe: "U\r\u6fbe", // 澾
	0x6fbf: "U\r\u6fbf", // 澿
	0x6fc0: "U\r\u6fc0", // 激
	0x6fc1: "U\r\u6fc1", // 濁
	0x6fc2: "U\r\u6fc2", // 濂
	0x6fc3: "U\r\u6fc3", // 濃
	0x6fc4: "U\r\u6fc4", // 濄
	0x6fc5: "U\r\u6fc5", // 濅
	0x6fc6: "U\r\u6fc6", // 濆
	0x6fc7: "U\r\u6fc7", // 濇
	0x6fc8: "U\r\u6fc8", // 濈
	0x6fc9: "U\r\u6fc9", // 濉
	0x6fca: "U\r\u6fca", // 濊
	0x6fcb: "U\r\u6fcb", // 濋
	0x6fcc: "U\r\u6fcc", // 濌
	0x6fcd: "U\r\u6fcd", // 濍
	0x6fce: "U\r\u6fce", // 濎
	0x6fcf: "U\r\u6fcf", // 濏
	0x6fd0: "U\f\u6fd0", // 濐
	0x6fd1: "U\r\u6fd1", // 濑
	0x6fd2: "U\r\u6fd2", // 濒
	0x6fd3: "U\r\u6fd3", // 濓
	0x6fd4: "U\x0e\u6fd4", // 濔
	0x6fd5: "U\x0e\u6fd5", // 濕
	0x6fd6: "U\r\u6fd6", // 濖
	0x6fd7: "U\x0e\u6fd7", // 濗
	0x6fd8: "U\x0e\u6fd8", // 濘
	0x6fd9: "U\x0e\u6fd9", // 濙
	0x6fda: "U\x0e\u6fda", // 濚
	0x6fdb: "U\x0e\u6fdb", // 濛
	0x6fdc: "U\x0e\u6fdc", // 濜
	0x6fdd: "U\x0e\u6fdd", // 濝
	0x6fde: "U\x0e\u6fde", // 濞
	0x6fdf: "U\x0e\u6fdf", // 濟
	0x6fe0: "U\x0e\u6fe0", // 濠
	0x6fe1: "U\x0e\u6fe1", // 濡
	0x6fe2: "U\x0e\u6fe2", // 濢
	0x6fe3: "U\x0e\u6fe3", // 濣
	0x6fe4: "U\x0e\u6fe4", // 濤
	0x6fe5: "U\x0e\u6fe5", // 濥
	0x6fe6: "U\x0e\u6fe6", // 濦
	0x6fe7: "U\x0e\u6fe7", // 濧
	0x6fe8: "U\x0e\u6fe8", // 濨
	0x6fe9: "U\x0e\u6fe9", // 濩
	0x6fea: "U\x0e\u6fea", // 濪
	0x6feb: "U\x0e\u6feb", // 濫
	0x6fec: "U\x0e\u6fec", // 濬
	0x6fed: "U\x0e\u6fed", // 濭
	0x6fee: "U\x0e\u6fee", // 濮
	0x6fef: "U\x0e\u6fef", // 濯
	0x6ff0: "U\x0e\u6ff0", // 濰
	0x6ff1: "U\x0e\u6ff1", // 濱
	0x6ff2: "U\x0e\u6ff2", // 濲
	0x6ff3: "U\x10\u6ff3", // 濳
	0x6ff4: "U\x0e\u6ff4", // 濴
	0x6ff5: "U\x0e\u6ff5", // 濵
	0x6ff6: "U\x0e\u6ff6", // 濶
	0x6ff7: "U\x0e\u6ff7", // 濷
	0x6ff8: "U\x0e\u6ff8", // 濸
	0x6ff9: "U\x0f\u6ff9", // 濹
	0x6ffa: "U\x0f\u6ffa", // 濺
	0x6ffb: "U\x0f\u6ffb", // 濻
	0x6ffc: "U\x0f\u6ffc", // 濼
	0x6ffd: "U\x0f\u6ffd", // 濽
	0x6ffe: "U\x0f\u6ffe", // 濾
	0x6fff: "U\x0f\u6fff", // 濿
	0x7000: "U\x0f\u7000", // 瀀
	0x7001: "U\x0f\u7001", // 瀁
	0x7002: "U\x0f\u7002", // 瀂
	0x7003: "U\x0f\u7003", // 瀃
	0x7004: "U\x0f\u7004", // 瀄
	0x7005: "U\x0f\u7005", // 瀅
	0x7006: "U\x0f\u7006", // 瀆
	0x7007: "U\x0f\u7007", // 瀇
	0x7008: "U\x0f\u7008", // 瀈
	0x7009: "U\x0f\u7009", // 瀉
	0x700a: "U\x0f\u700a", // 瀊
	0x700b: "U\x0f\u700b", // 瀋
	0x700c: "U\x0f\u700c", // 瀌
	0x700d: "U\x0f\u700d", // 瀍
	0x700e: "U\x0f\u700e", // 瀎
	0x700f: "U\x0f\u700f", // 瀏
	0x7010: "U\x0f\u7010", // 瀐
	0x7011: "U\x0f\u7011", // 瀑
	0x7012: "U\x0f\u7012", // 瀒
	0x7013: "U\x0f\u7013", // 瀓
	0x7014: "U\x0f\u7014", // 瀔
	0x7015: "U\x10\u7015", // 瀕
	0x7016: "U\x10\u7016", // 瀖
	0x7017: "U\x10\u7017", // 瀗
	0x7018: "U\x10\u7018", // 瀘
	0x7019: "U\x10\u7019", // 瀙
	0x701a: "U\x10\u701a", // 瀚
	0x701b: "U\x10\u701b", // 瀛
	0x701c: "U\x10\u701c", // 瀜
	0x701d: "U\x10\u701d", // 瀝
	0x701e: "U\x10\u701e", // 瀞
	0x701f: "U\x10\u701f", // 瀟
	0x7020: "U\x10\u7020", // 瀠
	0x7021: "U\x10\u7021", // 瀡
	0x7022: "U\x10\u7022", // 瀢
	0x7023: "U\x10\u7023", // 瀣
	0x7024: "U\x10\u7024", // 瀤
	0x7025: "U\x10\u7025", // 瀥
	0x7026: "U\x10\u7026", // 瀦
	0x7027: "U\x10\u7027", // 瀧
	0x7028: "U\x10\u7028", // 瀨
	0x7029: "U\x10\u7029", // 瀩
	0x702a: "U\x10\u702a", // 瀪
	0x702b: "U\x10\u702b", // 瀫
	0x702c: "U\x10\u702c", // 瀬
	0x702d: "U\x10\u702d", // 瀭
	0x702e: "U\x10\u702e", // 瀮
	0x702f: "U\x11\u702f", // 瀯
	0x7030: "U\x11\u7030", // 瀰
	0x7031: "U\x11\u7031", // 瀱
	0x7032: "U\x11\u7032", // 瀲
	0x7033: "U\x11\u7033", // 瀳
	0x7034: "U\x11\u7034", // 瀴
	0x7035: "U\x11\u7035", // 瀵
	0x7036: "U\x11\u7036", // 瀶
	0x7037: "U\x11\u7037", // 瀷
	0x7038: "U\x11\u7038", // 瀸
	0x7039: "U\x11\u7039", // 瀹
	0x703a: "U\x11\u703a", // 瀺
	0x703b: "U\x11\u703b", // 瀻
	0x703c: "U\x11\u703c", // 瀼
	0x703d: "U\x11\u703d", // 瀽
	0x703e: "U\x11\u703e", // 瀾
	0x703f: "U\x11\u703f", // 瀿
	0x7040: "U\x11\u7040", // 灀
	0x7041: "U\x11\u7041", // 灁
	0x7042: "U\x12\u7042", // 灂
	0x7043: "U\x12\u7043", // 灃
	0x7044: "U\x12\u7044", // 灄
	0x7045: "U\x12\u7045", // 灅
	0x7046: "U\x12\u7046", // 灆
	0x7047: "U\x12\u7047", // 灇
	0x7048: "U\x12\u7048", // 灈
	0x7049: "U\x12\u7049", // 灉
	0x704a: "U\x12\u704a", // 灊
	0x704b: "U\x12\u704b", // 灋
	0x704c: "U\x12\u704c", // 灌
	0x704d: "U\x12\u704d", // 灍
	0x704e: "U\x17\u704e", // 灎
	0x704f: "U\x12\u704f", // 灏
	0x7050: "U\x12\u7050", // 灐
	0x7051: "U\x13\u7051", // 灑
	0x7052: "U\x13\u7052", // 灒
	0x7053: "U\x13\u7053", // 灓
	0x7054: "U\x13\u7054", // 灔
	0x7055: "U\x13\u7055", // 灕
	0x7056: "U\x13\u7056", // 灖
	0x7057: "U\x13\u7057", // 灗
	0x7058: "U\x13\u7058", // 灘
	0x7059: "U\x14\u7059", // 灙
	0x705a: "U\x14\u705a", // 灚
	0x705b: "U\x14\u705b", // 灛
	0x705c: "U\x14\u705c", // 灜
	0x705d: "U\x15\u705d", // 灝
	0x705e: "U\x15\u705e", // 灞
	0x705f: "U\x15\u705f", // 灟
	0x7060: "U\x15\u7060", // 灠
	0x7061: "U\x15\u7061", // 灡
	0x7062: "U\x16\u7062", // 灢
	0x7063: "U\x16\u7063", // 灣
	0x7064: "U\x17\u7064", // 灤
	0x7065: "U\x17\u7065", // 灥
	0x7066: "U\x17\u7066", // 灦
	0x7067: "U\x18\u7067", // 灧
	0x7068: "U\x18\u7068", // 灨
	0x7069: "U\x1c\u7069", // 灩
	0x706a: "U\x1d\u706a", // 灪
	0x706b: "V\x00\u706b", // 火
	0x706c: "V\x00\u706c", // 灬
	0x706d: "V\x01\u706d", // 灭
	0x706e: "V\x02\u706e", // 灮
	0x706f: "V\x02\u706f", // 灯
	0x7070: "V\x02\u7070", // 灰
	0x7071: "V\x02\u7071", // 灱
	0x7072: "V\x02\u7072", // 灲
	0x7073: "V\x02\u7073", // 灳
	0x7074: "V\x03\u7074", // 灴
	0x7075: "V\x03\u7075", // 灵
	0x7076: "V\x03\u7076", // 灶
	0x7077: "V\x03\u7077", // 灷
	0x7078: "V\x03\u7078", // 灸
	0x7079: "V\x03\u7079", // 灹
	0x707a: "V\x03\u707a", // 灺
	0x707b: "V\x03\u707b", // 灻
	0x707c: "V\x03\u707c", // 灼
	0x707d: "V\x03\u707d", // 災
	0x707e: "V\x03\u707e", // 灾
	0x707f: "V\x03\u707f", // 灿
	0x7080: "V\x03\u7080", // 炀
	0x7081: "V\x04\u7081", // 炁
	0x7082: "V\x04\u7082", // 炂
	0x7083: "V\x04\u7083", // 炃
	0x7084: "V\x04\u7084", // 炄
	0x7085: "V\x04\u7085", // 炅
	0x7086: "V\x04\u7086", // 炆
	0x7087: "V\x02\u7087", // 炇
	0x7088: "V\x04\u7088", // 炈
	0x7089: "V\x04\u7089", // 炉
	0x708a: "V\x04\u708a", // 炊
	0x708b: "V\x04\u708b", // 炋
	0x708c: "V\x04\u708c", // 炌
	0x708d: "V\x04\u708d", // 炍
	0x708e: "V\x04\u708e", // 炎
	0x708f: "V\x04\u708f", // 炏
	0x7090: "V\x04\u7090", // 炐
	0x7091: "V\x04\u7091", // 炑
	0x7092: "V\x04\u7092", // 炒
	0x7093: "V\x04\u7093", // 炓
	0x7094: "V\x04\u7094", // 炔
	0x7095: "V\x04\u7095", // 炕
	0x7096: "V\x04\u7096", // 炖
	0x7097: "V\x04\u7097", // 炗
	0x7098: "V\x04\u7098", // 炘
	0x7099: "V\x04\u7099", // 炙
	0x709a: "V\x04\u709a", // 炚
	0x709b: "V\x04\u709b", // 炛
	0x709c: "V\x04\u709c", // 炜
	0x709d: "V\x04\u709d", // 炝
	0x709e: "V\x04\u709e", // 炞
	0x709f: "V\x05\u709f", // 炟
	0x70a0: "V\x05\u70a0", // 炠
	0x70a1: "V\x05\u70a1", // 炡
	0x70a2: "V\x05\u70a2", // 炢
	0x70a3: "V\x05\u70a3", // 炣
	0x70a4: "V\x05\u70a4", // 炤
	0x70a5: "V\x05\u70a5", // 炥
	0x70a6: "V\x05\u70a6", // 炦
	0x70a7: "V\x05\u70a7", // 炧
	0x70a8: "V\x05\u70a8", // 炨
	0x70a9: "V\x05\u70a9", // 炩
	0x70aa: "V\x05\u70aa", // 炪
	0x70ab: "V\x05\u70ab", // 炫
	0x70ac: "V\x05\u70ac", // 炬
	0x70ad: "V\x05\u70ad", // 炭
	0x70ae: "V\x05\u70ae", // 炮
	0x70af: "V\x05\u70af", // 炯
	0x70b0: "V\x05\u70b0", // 炰
	0x70b1: "V\x05\u70b1", // 炱
	0x70b2: "V\x05\u70b2", // 炲
	0x70b3: "V\x05\u70b3", // 炳
	0x70b4: "V\x05\u70b4", // 炴
	0x70b5: "V\x05\u70b5", // 炵
	0x70b6: "V\x05\u70b6", // 炶
	0x70b7: "V\x05\u70b7", // 炷
	0x70b8: "V\x05\u70b8", // 炸
	0x70b9: "V\x05\u70b9", // 点
	0x70ba: "V\x05\u70ba", // 為
	0x70bb: "V\x05\u70bb", // 炻
	0x70bc: "V\x05\u70bc", // 炼
	0x70bd: "V\x05\u70bd", // 炽
	0x70be: "V\x05\u70be", // 炾
	0x70bf: "V\x05\u70bf", // 炿
	0x70c0: "V\x05\u70c0", // 烀
	0x70c1: "V\x05\u70c1", // 烁
	0x70c2: "V\x05\u70c2", // 烂
	0x70c3: "V\x05\u70c3", // 烃
	0x70c4: "V\x06\u70c4", // 烄
	0x70c5: "V\x06\u70c5", // 烅
	0x70c6: "V\x06\u70c6", // 烆
	0x70c7: "V\x06\u70c7", // 烇
	0x70c8: "V\x06\u70c8", // 烈
	0x70c9: "V\x06\u70c9", // 烉
	0x70ca: "V\x06\u70ca", // 烊
	0x70cb: "V\x06\u70cb", // 烋
	0x70cc: "V\x06\u70cc", // 烌
	0x70cd: "V\x06\u70cd", // 烍
	0x70ce: "V\x06\u70ce", // 烎
	0x70cf: "V\x06\u70cf", // 烏
	0x70d0: "V\x06\u70d0", // 烐
	0x70d1: "V\x06\u70d1", // 烑
	0x70d2: "V\x06\u70d2", // 烒
	0x70d3: "V\x06\u70d3", // 烓
	0x70d4: "V\x06\u70d4", // 烔
	0x70d5: "V\x06\u70d5", // 烕
	0x70d6: "V\x06\u70d6", // 烖
	0x70d7: "V\x06\u70d7", // 烗
	0x70d8: "V\x06\u70d8", // 烘
	0x70d9: "V\x06\u70d9", // 烙
	0x70da: "V\x06\u70da", // 烚
	0x70db: "V\x06\u70db", // 烛
	0x70dc: "V\x06\u70dc", // 烜
	0x70dd: "V\x06\u70dd", // 烝
	0x70de: "V\x06\u70de", // 烞
	0x70df: "V\x06\u70df", // 烟
	0x70e0: "V\x06\u70e0", // 烠
	0x70e1: "V\x06\u70e1", // 烡
	0x70e2: "V\x06\u70e2", // 烢
	0x70e3: "V\x06\u70e3", // 烣
	0x70e4: "V\x06\u70e4", // 烤
	0x70e5: "V\x06\u70e5", // 烥
	0x70e6: "V\x06\u70e6", // 烦
	0x70e7: "V\x06\u70e7", // 烧
	0x70e8: "V\x06\u70e8", // 烨
	0x70e9: "V\x06\u70e9", // 烩
	0x70ea: "V\x06\u70ea", // 烪
	0x70eb: "V\x06\u70eb", // 烫
	0x70ec: "V\x06\u70ec", // 烬
	0x70ed: "V\x06\u70ed", // 热
	0x70ee: "V\x06\u70ee", // 烮
	0x70ef: "V\a\u70ef", // 烯
	0x70f0: "V\a\u70f0", // 烰
	0x70f1: "V\a\u70f1", // 烱
	0x70f2: "V\a\u70f2", // 烲
	0x70f3: "V\a\u70f3", // 烳
	0x70f4: "V\a\u70f4", // 烴
	0x70f5: "V\a\u70f5", // 烵
	0x70f6: "V\a\u70f6", // 烶
	0x70f7: "V\a\u70f7", // 烷
	0x70f8: "V\a\u70f8", // 烸
	0x70f9: "V\a\u70f9", // 烹
	0x70fa: "V\a\u70fa", // 烺
	0x70fb: "V\a\u70fb", // 烻
	0x70fc: "V\a\u70fc", // 烼
	0x70fd: "V\a\u70fd", // 烽
	0x70fe: "V\a\u70fe", // 烾
	0x70ff: "V\a\u70ff", // 烿
	0x7100: "V\a\u7100", // 焀
	0x7101: "V\a\u7101", // 焁
	0x7102: "V\a\u7102", // 焂
	0x7103: "V\a\u7103", // 焃
	0x7104: "V\a\u7104", // 焄
	0x7105: "V\a\u7105", // 焅
	0x7106: "V\a\u7106", // 焆
	0x7107: "V\a\u7107", // 焇
	0x7108: "V\a\u7108", // 焈
	0x7109: "V\a\u7109", // 焉
	0x710a: "V\a\u710a", // 焊
	0x710b: "V\a\u710b", // 焋
	0x710c: "V\a\u710c", // 焌
	0x710d: "V\a\u710d", // 焍
	0x710e: "V\a\u710e", // 焎
	0x710f: "V\a\u710f", // 焏
	0x7110: "V\a\u7110", // 焐
	0x7111: "V\a\u7111", // 焑
	0x7112: "V\a\u7112", // 焒
	0x7113: "V\a\u7113", // 焓
	0x7114: "V\b\u7114", // 焔
	0x7115: "V\a\u7115", // 焕
	0x7116: "V\a\u7116", // 焖
	0x7117: "V\a\u7117", // 焗
	0x7118: "V\a\u7118", // 焘
	0x7119: "V\b\u7119", // 焙
	0x711a: "V\b\u711a", // 焚
	0x711b: "V\b\u711b", // 焛
	0x711c: "V\b\u711c", // 焜
	0x711d: "V\b\u711d", // 焝
	0x711e: "V\b\u711e", // 焞
	0x711f: "V\b\u711f", // 焟
	0x7120: "V\b\u7120", // 焠
	0x7121: "V\b\u7121", // 無
	0x7122: "V\b\u7122", // 焢
	0x7123: "V\b\u7123", // 焣
	0x7124: "V\b\u7124", // 焤
	0x7125: "V\b\u7125", // 焥
	0x7126: "V\b\u7126", // 焦
	0x7127: "V\b\u7127", // 焧
	0x7128: "V\b\u7128", // 焨
	0x7129: "V\b\u7129", // 焩
	0x712a: "V\b\u712a", // 焪
	0x712b: "V\b\u712b", // 焫
	0x712c: "V\b\u712c", // 焬
	0x712d: "V\b\u712d", // 焭
	0x712e: "V\b\u712e", // 焮
	0x712f: "V\b\u712f", // 焯
	0x7130: "V\b\u7130", // 焰
	0x7131: "V\b\u7131", // 焱
	0x7132: "V\b\u7132", // 焲
	0x7133: "V\b\u7133", // 焳
	0x7134: "V\b\u7134", // 焴
	0x7135: "V\b\u7135", // 焵
	0x7136: "V\b\u7136", // 然
	0x7137: "V\b\u7137", // 焷
	0x7138: "V\b\u7138", // 焸
	0x7139: "V\b\u7139", // 焹
	0x713a: "V\b\u713a", // 焺
	0x713b: "V\b\u713b", // 焻
	0x713c: "V\b\u713c", // 焼
	0x713d: "V\b\u713d", // 焽
	0x713e: "V\b\u713e", // 焾
	0x713f: "V\b\u713f", // 焿
	0x7140: "V\b\u7140", // 煀
	0x7141: "V\t\u7141", // 煁
	0x7142: "V\t\u7142", // 煂
	0x7143: "V\t\u7143", // 煃
	0x7144: "V\t\u7144", // 煄
	0x7145: "V\t\u7145", // 煅
	0x7146: "V\t\u7146", // 煆
	0x7147: "V\t\u7147", // 煇
	0x7148: "V\t\u7148", // 煈
	0x7149: "V\t\u7149", // 煉
	0x714a: "V\t\u714a", // 煊
	0x714b: "V\t\u714b", // 煋
	0x714c: "V\t\u714c", // 煌
	0x714d: "V\t\u714d", // 煍
	0x714e: "V\t\u714e", // 煎
	0x714f: "V\t\u714f", // 煏
	0x7150: "V\t\u7150", // 煐
	0x7151: "V\t\u7151", // 煑
	0x7152: "V\t\u7152", // 煒
	0x7153: "V\t\u7153", // 煓
	0x7154: "V\t\u7154", // 煔
	0x7155: "V\t\u7155", // 煕
	0x7156: "V\t\u7156", // 煖
	0x7157: "V\t\u7157", // 煗
	0x7158: "V\t\u7158", // 煘
	0x7159: "V\t\u7159", // 煙
	0x715a: "V\t\u715a", // 煚
	0x715b: "V\t\u715b", // 煛
	0x715c: "V\t\u715c", // 煜
	0x715d: "V\t\u715d", // 煝
	0x715e: "V\t\u715e", // 煞
	0x715f: "V\t\u715f", // 煟
	0x7160: "V\t\u7160", // 煠
	0x7161: "V\t\u7161", // 煡
	0x7162: "V\t\u7162", // 煢
	0x7163: "V\t\u7163", // 煣
	0x7164: "V\t\u7164", // 煤
	0x7165: "V\t\u7165", // 煥
	0x7166: "V\t\u7166", // 煦
	0x7167: "V\t\u7167", // 照
	0x7168: "V\t\u7168", // 煨
	0x7169: "V\t\u7169", // 煩
	0x716a: "V\t\u716a", // 煪
	0x716b: "V\t\u716b", // 煫
	0x716c: "V\t\u716c", // 煬
	0x716d: "V\t\u716d", // 煭
	0x716e: "V\b\u716e", // 煮
	0x716f: "V\t\u716f", // 煯
	0x7170: "V\t\u7170", // 煰
	0x7171: "V\t\u7171", // 煱
	0x7172: "V\t\u7172", // 煲
	0x7173: "V\t\u7173", // 煳
	0x7174: "V\t\u7174", // 煴
	0x7175: "V\t\u7175", // 煵
	0x7176: "V\t\u7176", // 煶
	0x7177: "V\t\u7177", // 煷
	0x7178: "V\t\u7178", // 煸
	0x7179: "V\n\u7179", // 煹
	0x717a: "V\t\u717a", // 煺
	0x717b: "V\n\u717b", // 煻
	0x717c: "V\n\u717c", // 煼
	0x717d: "V\n\u717d", // 煽
	0x717e: "V\n\u717e", // 煾
	0x717f: "V\n\u717f", // 煿
	0x7180: "V\n\u7180", // 熀
	0x7181: "V\n\u7181", // 熁
	0x7182: "V\n\u7182", // 熂
	0x7183: "V\n\u7183", // 熃
	0x7184: "V\n\u7184", // 熄
	0x7185: "V\n\u7185", // 熅
	0x7186: "V\n\u7186", // 熆
	0x7187: "V\n\u7187", // 熇
	0x7188: "V\n\u7188", // 熈
	0x7189: "V\n\u7189", // 熉
	0x718a: "V\n\u718a", // 熊
	0x718b: "V\n\u718b", // 熋
	0x718c: "V\n\u718c", // 熌
	0x718d: "V\n\u718d", // 熍
	0x718e: "V\n\u718e", // 熎
	0x718f: "V\n\u718f", // 熏
	0x7190: "V\n\u7190", // 熐
	0x7191: "V\n\u7191", // 熑
	0x7192: "V\n\u7192", // 熒
	0x7193: "V\n\u7193", // 熓
	0x7194: "V\n\u7194", // 熔
	0x7195: "V\n\u7195", // 熕
	0x7196: "V\n\u7196", // 熖
	0x7197: "V\n\u7197", // 熗
	0x7198: "V\n\u7198", // 熘
	0x7199: "V\n\u7199", // 熙
	0x719a: "V\v\u719a", // 熚
	0x719b: "V\v\u719b", // 熛
	0x719c: "V\v\u719c", // 熜
	0x719d: "V\v\u719d", // 熝
	0x719e: "V\v\u719e", // 熞
	0x719f: "V\v\u719f", // 熟
	0x71a0: "V\v\u71a0", // 熠
	0x71a1: "V\v\u71a1", // 熡
	0x71a2: "V\v\u71a2", // 熢
	0x71a3: "V\v\u71a3", // 熣
	0x71a4: "V\v\u71a4", // 熤
	0x71a5: "V\v\u71a5", // 熥
	0x71a6: "V\n\u71a6", // 熦
	0x71a7: "V\v\u71a7", // 熧
	0x71a8: "V\v\u71a8", // 熨
	0x71a9: "V\v\u71a9", // 熩
	0x71aa: "V\v\u71aa", // 熪
	0x71ab: "V\v\u71ab", // 熫
	0x71ac: "V\v\u71ac", // 熬
	0x71ad: "V\v\u71ad", // 熭
	0x71ae: "V\v\u71ae", // 熮
	0x71af: "V\v\u71af", // 熯
	0x71b0: "V\v\u71b0", // 熰
	0x71b1: "V\v\u71b1", // 熱
	0x71b2: "V\v\u71b2", // 熲
	0x71b3: "V\v\u71b3", // 熳
	0x71b4: "V\v\u71b4", // 熴
	0x71b5: "V\v\u71b5", // 熵
	0x71b6: "V\f\u71b6", // 熶
	0x71b7: "V\f\u71b7", // 熷
	0x71b8: "V\f\u71b8", // 熸
	0x71b9: "V\f\u71b9", // 熹
	0x71ba: "V\f\u71ba", // 熺
	0x71bb: "V\f\u71bb", // 熻
	0x71bc: "V\f\u71bc", // 熼
	0x71bd: "V\f\u71bd", // 熽
	0x71be: "V\f\u71be", // 熾
	0x71bf: "V\f\u71bf", // 熿
	0x71c0: "V\f\u71c0", // 燀
	0x71c1: "V\f\u71c1", // 燁
	0x71c2: "V\f\u71c2", // 燂
	0x71c3: "V\f\u71c3", // 燃
	0x71c4: "V\f\u71c4", // 燄
	0x71c5: "V\f\u71c5", // 燅
	0x71c6: "V\f\u71c6", // 燆
	0x71c7: "V\f\u71c7", // 燇
	0x71c8: "V\f\u71c8", // 燈
	0x71c9: "V\f\u71c9", // 燉
	0x71ca: "V\f\u71ca", // 燊
	0x71cb: "V\f\u71cb", // 燋
	0x71cc: "V\f\u71cc", // 燌
	0x71cd: "V\f\u71cd", // 燍
	0x71ce: "V\f\u71ce", // 燎
	0x71cf: "V\f\u71cf", // 燏
	0x71d0: "V\f\u71d0", // 燐
	0x71d1: "V\f\u71d1", // 燑
	0x71d2: "V\f\u71d2", // 燒
	0x71d3: "V\f\u71d3", // 燓
	0x71d4: "V\f\u71d4", // 燔
	0x71d5: "V\f\u71d5", // 燕
	0x71d6: "V\f\u71d6", // 燖
	0x71d7: "V\f\u71d7", // 燗
	0x71d8: "V\f\u71d8", // 燘
	0x71d9: "V\f\u71d9", // 燙
	0x71da: "V\f\u71da", // 燚
	0x71db: "V\f\u71db", // 燛
	0x71dc: "V\f\u71dc", // 燜
	0x71dd: "V\f\u71dd", // 燝
	0x71de: "V\f\u71de", // 燞
	0x71df: "V\r\u71df", // 營
	0x71e0: "V\r\u71e0", // 燠
	0x71e1: "V\r\u71e1", // 燡
	0x71e2: "V\r\u71e2", // 燢
	0x71e3: "V\r\u71e3", // 燣
	0x71e4: "V\r\u71e4", // 燤
	0x71e5: "V\r\u71e5", // 燥
	0x71e6: "V\r\u71e6", // 燦
	0x71e7: "V\r\u71e7", // 燧
	0x71e8: "V\r\u71e8", // 燨
	0x71e9: "V\r\u71e9", // 燩
	0x71ea: "V\r\u71ea", // 燪
	0x71eb: "V\r\u71eb", // 燫
	0x71ec: "V\r\u71ec", // 燬
	0x71ed: "V\r\u71ed", // 燭
	0x71ee: "V\r\u71ee", // 燮
	0x71ef: "V\r\u71ef", // 燯
	0x71f0: "V\r\u71f0", // 燰
	0x71f1: "V\r\u71f1", // 燱
	0x71f2: "V\r\u71f2", // 燲
	0x71f3: "V\r\u71f3", // 燳
	0x71f4: "V\r\u71f4", // 燴
	0x71f5: "V\r\u71f5", // 燵
	0x71f6: "V\r\u71f6", // 燶
	0x71f7: "V\r\u71f7", // 燷
	0x71f8: "V\x0e\u71f8", // 燸
	0x71f9: "V\x0e\u71f9", // 燹
	0x71fa: "V\x0e\u71fa", // 燺
	0x71fb: "V\x0e\u71fb", // 燻
	0x71fc: "V\x0e\u71fc", // 燼
	0x71fd: "V\x0e\u71fd", // 燽
	0x71fe: "V\x0e\u71fe", // 燾
	0x71ff: "V\x0e\u71ff", // 燿
	0x7200: "V\x0e\u7200", // 爀
	0x7201: "V\x0e\u7201", // 爁
	0x7202: "V\x0e\u7202", // 爂
	0x7203: "V\x0e\u7203", // 爃
	0x7204: "V\x0f\u7204", // 爄
	0x7205: "V\x0f\u7205", // 爅
	0x7206: "V\x0f\u7206", // 爆
	0x7207: "V\x0f\u7207", // 爇
	0x7208: "V\x0f\u7208", // 爈
	0x7209: "V\x0f\u7209", // 爉
	0x720a: "V\x0f\u720a", // 爊
	0x720b: "V\x10\u720b", // 爋
	0x720c: "V\x0f\u720c", // 爌
	0x720d: "V\x0f\u720d", // 爍
	0x720e: "V\x0f\u720e", // 爎
	0x720f: "V\x10\u720f", // 爏
	0x7210: "V\x10\u7210", // 爐
	0x7211: "V\x10\u7211", // 爑
	0x7212: "V\x10\u7212", // 爒
	0x7213: "V\x10\u7213", // 爓
	0x7214: "V\x10\u7214", // 爔
	0x7215: "V\x0f\u7215", // 爕
	0x7216: "V\x10\u7216", // 爖
	0x7217: "V\x10\u7217", // 爗
	0x7218: "V\x10\u7218", // 爘
	0x7219: "V\x11\u7219", // 爙
	0x721a: "V\x11\u721a", // 爚
	0x721b: "V\x11\u721b", // 爛
	0x721c: "V\x12\u721c", // 爜
	0x721d: "V\x12\u721d", // 爝
	0x721e: "V\x12\u721e", // 爞
	0x721f: "V\x12\u721f", // 爟
	0x7220: "V\x12\u7220", // 爠
	0x7221: "V\x13\u7221", // 爡
	0x7222: "V\x13\u7222", // 爢
	0x7223: "V\x14\u7223", // 爣
	0x7224: "V\x15\u7224", // 爤
	0x7225: "V\x15\u7225", // 爥
	0x7226: "V\x15\u7226", // 爦
	0x7227: "V\x18\u7227", // 爧
	0x7228: "V\x19\u7228", // 爨
	0x7229: "V\x1d\u7229", // 爩
	0x722a: "W\x00\u722a", // 爪
	0x722b: "W\x00\u722b", // 爫
	0x722c: "W\x04\u722c", // 爬
	0x722d: "W\x04\u722d", // 爭
	0x722e: "W\x05\u722e", // 爮
	0x722f: "W\x05\u722f", // 爯
	0x7230: "W\x05\u7230", // 爰
	0x7231: "W\x06\u7231", // 爱
	0x7232: "W\b\u7232", // 爲
	0x7233: "W\n\u7233", // 爳
	0x7234: "W\v\u7234", // 爴
	0x7235: "W\x0e\u7235", // 爵
	0x7236: "X\x00\u7236", // 父
	0x7237: "X\x02\u7237", // 爷
	0x7238: "X\x04\u7238", // 爸
	0x7239: "X\x06\u7239", // 爹
	0x723a: "X\t\u723a", // 爺
	0x723b: "Y\x00\u723b", // 爻
	0x723c: "Y\x05\u723c", // 爼
	0x723d: "Y\a\u723d", // 爽
	0x723e: "Y\n\u723e", // 爾
	0x723f: "Z\x00\u723f", // 爿
	0x7240: "Z\x04\u7240", // 牀
	0x7241: "Z\x05\u7241", // 牁
	0x7242: "Z\x06\u7242", // 牂
	0x7243: "Z\t\u7243", // 牃
	0x7244: "Z\n\u7244", // 牄
	0x7245: "Z\v\u7245", // 牅
	0x7246: "Z\r\u7246", // 牆
	0x7247: "[\x00\u7247", // 片
	0x7248: "[\x04\u7248", // 版
	0x7249: "[\x05\u7249", // 牉
	0x724a: "[\x05\u724a", // 牊
	0x724b: "[\b\u724b", // 牋
	0x724c: "[\b\u724c", // 牌
	0x724d: "[\b\u724d", // 牍
	0x724e: "[\t\u724e", // 牎
	0x724f: "[\t\u724f", // 牏
	0x7250: "[\t\u7250", // 牐
	0x7251: "[\t\u7251", // 牑
	0x7252: "[\t\u7252", // 牒
	0x7253: "[\n\u7253", // 牓
	0x7254: "[\n\u7254", // 牔
	0x7255: "[\v\u7255", // 牕
	0x7256: "[\v\u7256", // 牖
	0x7257: "[\v\u7257", // 牗
	0x7258: "[\x0f\u7258", // 牘
	0x7259: "\\\x00\u7259", // 牙
	0x725a: "\\\b\u725a", // 牚
	0x725b: "]\x00\u725b", // 牛
	0x725c: "]\x00\u725c", // 牜
	0x725d: "]\x02\u725d", // 牝
	0x725e: "]\x02\u725e", // 牞
	0x725f: "]\x02\u725f", // 牟
	0x7260: "]\x03\u7260", // 牠
	0x7261: "]\x03\u7261", // 牡
	0x7262: "]\x03\u7262", // 牢
	0x7263: "]\x03\u7263", // 牣
	0x7264: "]\x03\u7264", // 牤
	0x7265: "]\x04\u7265", // 牥
	0x7266: "]\x04\u7266", // 牦
	0x7267: "]\x04\u7267", // 牧
	0x7268: "]\x04\u7268", // 牨
	0x7269: "]\x04\u7269", // 物
	0x726a: "]\x04\u726a", // 牪
	0x726b: "]\x04\u726b", // 牫
	0x726c: "]\x04\u726c", // 牬
	0x726d: "]\x05\u726d", // 牭
	0x726e: "]\x05\u726e", // 牮
	0x726f: "]\x05\u726f", // 牯
	0x7270: "]\x05\u7270", // 牰
	0x7271: "]\x05\u7271", // 牱
	0x7272: "]\x05\u7272", // 牲
	0x7273: "]\x05\u7273", // 牳
	0x7274: "]\x05\u7274", // 牴
	0x7275: "]\x05\u7275", // 牵
	0x7276: "]\x06\u7276", // 牶
	0x7277: "]\x06\u7277", // 牷
	0x7278: "]\x06\u7278", // 牸
	0x7279: "]\x06\u7279", // 特
	0x727a: "]\x06\u727a", // 牺
	0x727b: "]\a\u727b", // 牻
	0x727c: "]\a\u727c", // 牼
	0x727d: "]\a\u727d", // 牽
	0x727e: "]\a\u727e", // 牾
	0x727f: "]\a\u727f", // 牿
	0x7280: "]\b\u7280", // 犀
	0x7281: "]\a\u7281", // 犁
	0x7282: "]\b\u7282", // 犂
	0x7283: "]\b\u7283", // 犃
	0x7284: "]\b\u7284", // 犄
	0x7285: "]\b\u7285", // 犅
	0x7286: "]\b\u7286", // 犆
	0x7287: "]\b\u7287", // 犇
	0x7288: "]\b\u7288", // 犈
	0x7289: "]\b\u7289", // 犉
	0x728a: "]\b\u728a", // 犊
	0x728b: "]\b\u728b", // 犋
	0x728c: "]\t\u728c", // 犌
	0x728d: "]\t\u728d", // 犍
	0x728e: "]\t\u728e", // 犎
	0x728f: "]\t\u728f", // 犏
	0x7290: "]\t\u7290", // 犐
	0x7291: "]\t\u7291", // 犑
	0x7292: "]\n\u7292", // 犒
	0x7293: "]\n\u7293", // 犓
	0x7294: "]\n\u7294", // 犔
	0x7295: "]\n\u7295", // 犕
	0x7296: "]\n\u7296", // 犖
	0x7297: "]\n\u7297", // 犗
	0x7298: "]\v\u7298", // 犘
	0x7299: "]\v\u7299", // 犙
	0x729a: "]\v\u729a", // 犚
	0x729b: "]\v\u729b", // 犛
	0x729c: "]\f\u729c", // 犜
	0x729d: "]\f\u729d", // 犝
	0x729e: "]\f\u729e", // 犞
	0x729f: "]\f\u729f", // 犟
	0x72a0: "]\r\u72a0", // 犠
	0x72a1: "]\x0f\u72a1", // 犡
	0x72a2: "]\x0f\u72a2", // 犢
	0x72a3: "]\x0f\u72a3", // 犣
	0x72a4: "]\x0f\u72a4", // 犤
	0x72a5: "]\x0f\u72a5", // 犥
	0x72a6: "]\x0f\u72a6", // 犦
	0x72a7: "]\x10\u72a7", // 犧
	0x72a8: "]\x10\u72a8", // 犨
	0x72a9: "]\x12\u72a9", // 犩
	0x72aa: "]\x14\u72aa", // 犪
	0x72ab: "]\x17\u72ab", // 犫
	0x72ac: "^\x00\u72ac", // 犬
	0x72ad: "^\x00\u72ad", // 犭
	0x72ae: "^\x01\u72ae", // 犮
	0x72af: "^\x02\u72af", // 犯
	0x72b0: "^\x02\u72b0", // 犰
	0x72b1: "^\x03\u72b1", // 犱
	0x72b2: "^\x03\u72b2", // 犲
	0x72b3: "^\x03\u72b3", // 犳
	0x72b4: "^\x03\u72b4", // 犴
	0x72b5: "^\x03\u72b5", // 犵
	0x72b6: "^\x03\u72b6", // 状
	0x72b7: "^\x03\u72b7", // 犷
	0x72b8: "^\x03\u72b8", // 犸
	0x72b9: "^\x04\u72b9", // 犹
	0x72ba: "^\x04\u72ba", // 犺
	0x72bb: "^\x04\u72bb", // 犻
	0x72bc: "^\x04\u72bc", // 犼
	0x72bd: "^\x04\u72bd", // 犽
	0x72be: "^\x04\u72be", // 犾
	0x72bf: "^\x04\u72bf", // 犿
	0x72c0: "^\x04\u72c0", // 狀
	0x72c1: "^\x04\u72c1", // 狁
	0x72c2: "^\x04\u72c2", // 狂
	0x72c3: "^\x04\u72c3", // 狃
	0x72c4: "^\x04\u72c4", // 狄
	0x72c5: "^\x04\u72c5", // 狅
	0x72c6: "^\x04\u72c6", // 狆
	0x72c7: "^\x04\u72c7", // 狇
	0x72c8: "^\x04\u72c8", // 狈
	0x72c9: "^\x05\u72c9", // 狉
	0x72ca: "^\x05\u72ca", // 狊
	0x72cb: "^\x05\u72cb", // 狋
	0x72cc: "^\x05\u72cc", // 狌
	0x72cd: "^\x05\u72cd", // 狍
	0x72ce: "^\x05\u72ce", // 狎
	0x72cf: "^\x05\u72cf", // 狏
	0x72d0: "^\x05\u72d0", // 狐
	0x72d1: "^\x05\u72d1", // 狑
	0x72d2: "^\x05\u72d2", // 狒
	0x72d3: "^\x05\u72d3", // 狓
	0x72d4: "^\x05\u72d4", // 狔
	0x72d5: "^\x05\u72d5", // 狕
	0x72d6: "^\x05\u72d6", // 狖
	0x72d7: "^\x05\u72d7", // 狗
	0x72d8: "^\x05\u72d8", // 狘
	0x72d9: "^\x05\u72d9", // 狙
	0x72da: "^\x05\u72da", // 狚
	0x72db: "^\x05\u72db", // 狛
	0x72dc: "^\x05\u72dc", // 狜
	0x72dd: "^\x05\u72dd", // 狝
	0x72de: "^\x05\u72de", // 狞
	0x72df: "^\x06\u72df", // 狟
	0x72e0: "^\x06\u72e0", // 狠
	0x72e1: "^\x06\u72e1", // 狡
	0x72e2: "^\x06\u72e2", // 狢
	0x72e3: "^\x06\u72e3", // 狣
	0x72e4: "^\x06\u72e4", // 狤
	0x72e5: "^\x06\u72e5", // 狥
	0x72e6: "^\x06\u72e6", // 狦
	0x72e7: "^\x06\u72e7", // 狧
	0x72e8: "^\x06\u72e8", // 狨
	0x72e9: "^\x06\u72e9", // 狩
	0x72ea: "^\x06\u72ea", // 狪
	0x72eb: "^\x06\u72eb", // 狫
	0x72ec: "^\x06\u72ec", // 独
	0x72ed: "^\x06\u72ed", // 狭
	0x72ee: "^\x06\u72ee", // 狮
	0x72ef: "^\x06\u72ef", // 狯
	0x72f0: "^\x06\u72f0", // 狰
	0x72f1: "^\x06\u72f1", // 狱
	0x72f2: "^\x06\u72f2", // 狲
	0x72f3: "^\a\u72f3", // 狳
	0x72f4: "^\a\u72f4", // 狴
	0x72f5: "^\a\u72f5", // 狵
	0x72f6: "^\a\u72f6", // 狶
	0x72f7: "^\a\u72f7", // 狷
	0x72f8: "^\a\u72f8", // 狸
	0x72f9: "^\a\u72f9", // 狹
	0x72fa: "^\a\u72fa", // 狺
	0x72fb: "^\a\u72fb", // 狻
	0x72fc: "^\a\u72fc", // 狼
	0x72fd: "^\a\u72fd", // 狽
	0x72fe: "^\a\u72fe", // 狾
	0x72ff: "^\a\u72ff", // 狿
	0x7300: "^\a\u7300", // 猀
	0x7301: "^\a\u7301", // 猁
	0x7302: "^\a\u7302", // 猂
	0x7303: "^\a\u7303", // 猃
	0x7304: "^\b\u7304", // 猄
	0x7305: "^\b\u7305", // 猅
	0x7306: "^\b\u7306", // 猆
	0x7307: "^\b\u7307", // 猇
	0x7308: "^\b\u7308", // 猈
	0x7309: "^\b\u7309", // 猉
	0x730a: "^\b\u730a", // 猊
	0x730b: "^\b\u730b", // 猋
	0x730c: "^\b\u730c", // 猌
	0x730d: "^\b\u730d", // 猍
	0x730e: "^\b\u730e", // 猎
	0x730f: "^\b\u730f", // 猏
	0x7310: "^\b\u7310", // 猐
	0x7311: "^\b\u7311", // 猑
	0x7312: "^\b\u7312", // 猒
	0x7313: "^\b\u7313", // 猓
	0x7314: "^\b\u7314", // 猔
	0x7315: "^\b\u7315", // 猕
	0x7316: "^\b\u7316", // 猖
	0x7317: "^\b\u7317", // 猗
	0x7318: "^\b\u7318", // 猘
	0x7319: "^\b\u7319", // 猙
	0x731a: "^\b\u731a", // 猚
	0x731b: "^\b\u731b", // 猛
	0x731c: "^\b\u731c", // 猜
	0x731d: "^\b\u731d", // 猝
	0x731e: "^\b\u731e", // 猞
	0x731f: "^\b\u731f", // 猟
	0x7320: "^\b\u7320", // 猠
	0x7321: "^\b\u7321", // 猡
	0x7322: "^\t\u7322", // 猢
	0x7323: "^\t\u7323", // 猣
	0x7324: "^\t\u7324", // 猤
	0x7325: "^\t\u7325", // 猥
	0x7326: "^\t\u7326", // 猦
	0x7327: "^\t\u7327", // 猧
	0x7328: "^\t\u7328", // 猨
	0x7329: "^\t\u7329", // 猩
	0x732a: "^\b\u732a", // 猪
	0x732b: "^\b\u732b", // 猫
	0x732c: "^\t\u732c", // 猬
	0x732d: "^\t\u732d", // 猭
	0x732e: "^\t\u732e", // 献
	0x732f: "^\t\u732f", // 猯
	0x7330: "^\t\u7330", // 猰
	0x7331: "^\t\u7331", // 猱
	0x7332: "^\t\u7332", // 猲
	0x7333: "^\t\u7333", // 猳
	0x7334: "^\t\u7334", // 猴
	0x7335: "^\t\u7335", // 猵
	0x7336: "^\t\u7336", // 猶
	0x7337: "^\t\u7337", // 猷
	0x7338: "^\t\u7338", // 猸
	0x7339: "^\t\u7339", // 猹
	0x733a: "^\n\u733a", // 猺
	0x733b: "^\n\u733b", // 猻
	0x733c: "^\n\u733c", // 猼
	0x733d: "^\n\u733d", // 猽
	0x733e: "^\n\u733e", // 猾
	0x733f: "^\n\u733f", // 猿
	0x7340: "^\n\u7340", // 獀
	0x7341: "^\t\u7341", // 獁
	0x7342: "^\n\u7342", // 獂
	0x7343: "^\n\u7343", // 獃
	0x7344: "^\v\u7344", // 獄
	0x7345: "^\n\u7345", // 獅
	0x7346: "^\n\u7346", // 獆
	0x7347: "^\n\u7347", // 獇
	0x7348: "^\n\u7348", // 獈
	0x7349: "^\n\u7349", // 獉
	0x734a: "^\n\u734a", // 獊
	0x734b: "^\f\u734b", // 獋
	0x734c: "^\v\u734c", // 獌
	0x734d: "^\v\u734d", // 獍
	0x734e: "^\v\u734e", // 獎
	0x734f: "^\v\u734f", // 獏
	0x7350: "^\v\u7350", // 獐
	0x7351: "^\v\u7351", // 獑
	0x7352: "^\v\u7352", // 獒
	0x7353: "^\v\u7353", // 獓
	0x7354: "^\v\u7354", // 獔
	0x7355: "^\v\u7355", // 獕
	0x7356: "^\f\u7356", // 獖
	0x7357: "^\f\u7357", // 獗
	0x7358: "^\f\u7358", // 獘
	0x7359: "^\f\u7359", // 獙
	0x735a: "^\f\u735a", // 獚
	0x735b: "^\f\u735b", // 獛
	0x735c: "^\f\u735c", // 獜
	0x735d: "^\f\u735d", // 獝
	0x735e: "^\f\u735e", // 獞
	0x735f: "^\f\u735f", // 獟
	0x7360: "^\f\u7360", // 獠
	0x7361: "^\f\u7361", // 獡
	0x7362: "^\f\u7362", // 獢
	0x7363: "^\f\u7363", // 獣
	0x7364: "^\f\u7364", // 獤
	0x7365: "^\r\u7365", // 獥
	0x7366: "^\r\u7366", // 獦
	0x7367: "^\r\u7367", // 獧
	0x7368: "^\r\u7368", // 獨
	0x7369: "^\r\u7369", // 獩
	0x736a: "^\r\u736a", // 獪
	0x736b: "^\r\u736b", // 獫
	0x736c: "^\r\u736c", // 獬
	0x736d: "^\r\u736d", // 獭
	0x736e: "^\x0e\u736e", // 獮
	0x736f: "^\x0e\u736f", // 獯
	0x7370: "^\x0e\u7370", // 獰
	0x7371: "^\x0e\u7371", // 獱
	0x7372: "^\x0e\u7372", // 獲
	0x7373: "^\x0e\u7373", // 獳
	0x7374: "^\x0e\u7374", // 獴
	0x7375: "^\x0f\u7375", // 獵
	0x7376: "^\x0f\u7376", // 獶
	0x7377: "^\x0f\u7377", // 獷
	0x7378: "^\x0f\u7378", // 獸
	0x7379: "^\x10\u7379", // 獹
	0x737a: "^\x10\u737a", // 獺
	0x737b: "^\x10\u737b", // 獻
	0x737c: "^\x11\u737c", // 獼
	0x737d: "^\x11\u737d", // 獽
	0x737e: "^\x12\u737e", // 獾
	0x737f: "^\x12\u737f", // 獿
	0x7380: "^\x13\u7380", // 玀
	0x7381: "^\x14\u7381", // 玁
	0x7382: "^\x14\u7382", // 玂
	0x7383: "^\x14\u7383", // 玃
	0x7384: "_\x00\u7384", // 玄
	0x7385: "_\x04\u7385", // 玅
	0x7386: "_\x05\u7386", // 玆
	0x7387: "_\x06\u7387", // 率
	0x7388: "_\x06\u7388", // 玈
	0x7389: "`\x00\u7389", // 玉
	0x738a: "`\x01\u738a", // 玊
	0x738b: "`\x00\u738b", // 王
	0x738c: "`\x01\u738c", // 玌
	0x738d: "`\x01\u738d", // 玍
	0x738e: "`\x02\u738e", // 玎
	0x738f: "`\x02\u738f", // 玏
	0x7390: "`\x02\u7390", // 玐
	0x7391: "`\x02\u7391", // 玑
	0x7392: "`\x03\u7392", // 玒
	0x7393: "`\x03\u7393", // 玓
	0x7394: "`\x03\u7394", // 玔
	0x7395: "`\x03\u7395", // 玕
	0x7396: "`\x03\u7396", // 玖
	0x7397: "`\x03\u7397", // 玗
	0x7398: "`\x03\u7398", // 玘
	0x7399: "`\x03\u7399", // 玙
	0x739a: "`\x03\u739a", // 玚
	0x739b: "`\x03\u739b", // 玛
	0x739c: "`\x04\u739c", // 玜
	0x739d: "`\x04\u739d", // 玝
	0x739e: "`\x04\u739e", // 玞
	0x739f: "`\x04\u739f", // 玟
	0x73a0: "`\x04\u73a0", // 玠
	0x73a1: "`\x04\u73a1", // 玡
	0x73a2: "`\x04\u73a2", // 玢
	0x73a3: "`\x04\u73a3", // 玣
	0x73a4: "`\x04\u73a4", // 玤
	0x73a5: "`\x04\u73a5", // 玥
	0x73a6: "`\x04\u73a6", // 玦
	0x73a7: "`\x04\u73a7", // 玧
	0x73a8: "`\x04\u73a8", // 玨
	0x73a9: "`\x04\u73a9", // 玩
	0x73aa: "`\x04\u73aa", // 玪
	0x73ab: "`\x04\u73ab", // 玫
	0x73ac: "`\x04\u73ac", // 玬
	0x73ad: "`\x04\u73ad", // 玭
	0x73ae: "`\x04\u73ae", // 玮
	0x73af: "`\x04\u73af", // 环
	0x73b0: "`\x04\u73b0", // 现
	0x73b1: "`\x04\u73b1", // 玱
	0x73b2: "`\x05\u73b2", // 玲
	0x73b3: "`\x05\u73b3", // 玳
	0x73b4: "`\x05\u73b4", // 玴
	0x73b5: "`\x05\u73b5", // 玵
	0x73b6: "`\x05\u73b6", // 玶
	0x73b7: "`\x05\u73b7", // 玷
	0x73b8: "`\x05\u73b8", // 玸
	0x73b9: "`\x05\u73b9", // 玹
	0x73ba: "`\x05\u73ba", // 玺
	0x73bb: "`\x05\u73bb", // 玻
	0x73bc: "`\x05\u73bc", // 玼
	0x73bd: "`\x05\u73bd", // 玽
	0x73be: "`\x05\u73be", // 玾
	0x73bf: "`\x05\u73bf", // 玿
	0x73c0: "`\x05\u73c0", // 珀
	0x73c1: "`\x05\u73c1", // 珁
	0x73c2: "`\x05\u73c2", // 珂
	0x73c3: "`\x05\u73c3", // 珃
	0x73c4: "`\x05\u73c4", // 珄
	0x73c5: "`\x05\u73c5", // 珅
	0x73c6: "`\x05\u73c6", // 珆
	0x73c7: "`\x05\u73c7", // 珇
	0x73c8: "`\x05\u73c8", // 珈
	0x73c9: "`\x05\u73c9", // 珉
	0x73ca: "`\x05\u73ca", // 珊
	0x73cb: "`\x05\u73cb", // 珋
	0x73cc: "`\x05\u73cc", // 珌
	0x73cd: "`\x05\u73cd", // 珍
	0x73ce: "`\x05\u73ce", // 珎
	0x73cf: "`\x05\u73cf", // 珏
	0x73d0: "`\x05\u73d0", // 珐
	0x73d1: "`\x05\u73d1", // 珑
	0x73d2: "`\x06\u73d2", // 珒
	0x73d3: "`\x06\u73d3", // 珓
	0x73d4: "`\x06\u73d4", // 珔
	0x73d5: "`\x06\u73d5", // 珕
	0x73d6: "`\x06\u73d6", // 珖
	0x73d7: "`\x06\u73d7", // 珗
	0x73d8: "`\x06\u73d8", // 珘
	0x73d9: "`\x06\u73d9", // 珙
	0x73da: "`\x06\u73da", // 珚
	0x73db: "`\x06\u73db", // 珛
	0x73dc: "`\x06\u73dc", // 珜
	0x73dd: "`\x06\u73dd", // 珝
	0x73de: "`\x06\u73de", // 珞
	0x73df: "`\x06\u73df", // 珟
	0x73e0: "`\x06\u73e0", // 珠
	0x73e1: "`\x06\u73e1", // 珡
	0x73e2: "`\x06\u73e2", // 珢
	0x73e3: "`\x06\u73e3", // 珣
	0x73e4: "`\x06\u73e4", // 珤
	0x73e5: "`\x06\u73e5", // 珥
	0x73e6: "`\x06\u73e6", // 珦
	0x73e7: "`\x06\u73e7", // 珧
	0x73e8: "`\x06\u73e8", // 珨
	0x73e9: "`\x06\u73e9", // 珩
	0x73ea: "`\x06\u73ea", // 珪
	0x73eb: "`\x06\u73eb", // 珫
	0x73ec: "`\x06\u73ec", // 珬
	0x73ed: "`\x06\u73ed", // 班
	0x73ee: "`\x06\u73ee", // 珮
	0x73ef: "`\x06\u73ef", // 珯
	0x73f0: "`\x06\u73f0", // 珰
	0x73f1: "`\x06\u73f1", // 珱
	0x73f2: "`\x06\u73f2", // 珲
	0x73f3: "`\a\u73f3", // 珳
	0x73f4: "`\a\u73f4", // 珴
	0x73f5: "`\a\u73f5", // 珵
	0x73f6: "`\a\u73f6", // 珶
	0x73f7: "`\b\u73f7", // 珷
	0x73f8: "`\a\u73f8", // 珸
	0x73f9: "`\a\u73f9", // 珹
	0x73fa: "`\a\u73fa", // 珺
	0x73fb: "`\a\u73fb", // 珻
	0x73fc: "`\a\u73fc", // 珼
	0x73fd: "`\a\u73fd", // 珽
	0x73fe: "`\a\u73fe", // 現
	0x73ff: "`\a\u73ff", // 珿
	0x7400: "`\a\u7400", // 琀
	0x7401: "`\a\u7401", // 琁
	0x7402: "`\a\u7402", // 琂
	0x7403: "`\a\u7403", // 球
	0x7404: "`\a\u7404", // 琄
	0x7405: "`\a\u7405", // 琅
	0x7406: "`\a\u7406", // 理
	0x7407: "`\a\u7407", // 琇
	0x7408: "`\a\u7408", // 琈
	0x7409: "`\x06\u7409", // 琉
	0x740a: "`\a\u740a", // 琊
	0x740b: "`\a\u740b", // 琋
	0x740c: "`\a\u740c", // 琌
	0x740d: "`\a\u740d", // 琍
	0x740e: "`\a\u740e", // 琎
	0x740f: "`\a\u740f", // 琏
	0x7410: "`\a\u7410", // 琐
	0x7411: "`\a\u7411", // 琑
	0x7412: "`\a\u7412", // 琒
	0x7413: "`\a\u7413", // 琓
	0x7414: "`\b\u7414", // 琔
	0x7415: "`\b\u7415", // 琕
	0x7416: "`\b\u7416", // 琖
	0x7417: "`\b\u7417", // 琗
	0x7418: "`\b\u7418", // 琘
	0x7419: "`\b\u7419", // 琙
	0x741a: "`\b\u741a", // 琚
	0x741b: "`\b\u741b", // 琛
	0x741c: "`\b\u741c", // 琜
	0x741d: "`\b\u741d", // 琝
	0x741e: "`\t\u741e", // 琞
	0x741f: "`\b\u741f", // 琟
	0x7420: "`\b\u7420", // 琠
	0x7421: "`\b\u7421", // 琡
	0x7422: "`\b\u7422", // 琢
	0x7423: "`\b\u7423", // 琣
	0x7424: "`\b\u7424", // 琤
	0x7425: "`\b\u7425", // 琥
	0x7426: "`\b\u7426", // 琦
	0x7427: "`\b\u7427", // 琧
	0x7428: "`\b\u7428", // 琨
	0x7429: "`\b\u7429", // 琩
	0x742a: "`\b\u742a", // 琪
	0x742b: "`\b\u742b", // 琫
	0x742c: "`\b\u742c", // 琬
	0x742d: "`\b\u742d", // 琭
	0x742e: "`\b\u742e", // 琮
	0x742f: "`\b\u742f", // 琯
	0x7430: "`\b\u7430", // 琰
	0x7431: "`\b\u7431", // 琱
	0x7432: "`\b\u7432", // 琲
	0x7433: "`\b\u7433", // 琳
	0x7434: "`\b\u7434", // 琴
	0x7435: "`\b\u7435", // 琵
	0x7436: "`\b\u7436", // 琶
	0x7437: "`\b\u7437", // 琷
	0x7438: "`\b\u7438", // 琸
	0x7439: "`\b\u7439", // 琹
	0x743a: "`\b\u743a", // 琺
	0x743b: "`\b\u743b", // 琻
	0x743c: "`\b\u743c", // 琼
	0x743d: "`\t\u743d", // 琽
	0x743e: "`\t\u743e", // 琾
	0x743f: "`\t\u743f", // 琿
	0x7440: "`\t\u7440", // 瑀
	0x7441: "`\t\u7441", // 瑁
	0x7442: "`\t\u7442", // 瑂
	0x7443: "`\t\u7443", // 瑃
	0x7444: "`\t\u7444", // 瑄
	0x7445: "`\t\u7445", // 瑅
	0x7446: "`\t\u7446", // 瑆
	0x7447: "`\t\u7447", // 瑇
	0x7448: "`\t\u7448", // 瑈
	0x7449: "`\t\u7449", // 瑉
	0x744a: "`\t\u744a", // 瑊
	0x744b: "`\t\u744b", // 瑋
	0x744c: "`\t\u744c", // 瑌
	0x744d: "`\t\u744d", // 瑍
	0x744e: "`\t\u744e", // 瑎
	0x744f: "`\t\u744f", // 瑏
	0x7450: "`\t\u7450", // 瑐
	0x7451: "`\t\u7451", // 瑑
	0x7452: "`\t\u7452", // 瑒
	0x7453: "`\t\u7453", // 瑓
	0x7454: "`\t\u7454", // 瑔
	0x7455: "`\t\u7455", // 瑕
	0x7456: "`\t\u7456", // 瑖
	0x7457: "`\t\u7457", // 瑗
	0x7458: "`\t\u7458", // 瑘
	0x7459: "`\t\u7459", // 瑙
	0x745a: "`\t\u745a", // 瑚
	0x745b: "`\t\u745b", // 瑛
	0x745c: "`\t\u745c", // 瑜
	0x745d: "`\t\u745d", // 瑝
	0x745e: "`\t\u745e", // 瑞
	0x745f: "`\t\u745f", // 瑟
	0x7460: "`\n\u7460", // 瑠
	0x7461: "`\n\u7461", // 瑡
	0x7462: "`\n\u7462", // 瑢
	0x7463: "`\n\u7463", // 瑣
	0x7464: "`\n\u7464", // 瑤
	0x7465: "`\n\u7465", // 瑥
	0x7466: "`\n\u7466", // 瑦
	0x7467: "`\n\u7467", // 瑧
	0x7468: "`\n\u7468", // 瑨
	0x7469: "`\n\u7469", // 瑩
	0x746a: "`\n\u746a", // 瑪
	0x746b: "`\n\u746b", // 瑫
	0x746c: "`\n\u746c", // 瑬
	0x746d: "`\n\u746d", // 瑭
	0x746e: "`\n\u746e", // 瑮
	0x746f: "`\n\u746f", // 瑯
	0x7470: "`\n\u7470", // 瑰
	0x7471: "`\n\u7471", // 瑱
	0x7472: "`\n\u7472", // 瑲
	0x7473: "`\n\u7473", // 瑳
	0x7474: "`\n\u7474", // 瑴
	0x7475: "`\n\u7475", // 瑵
	0x7476: "`\n\u7476", // 瑶
	0x7477: "`\n\u7477", // 瑷
	0x7478: "`\n\u7478", // 瑸
	0x7479: "`\v\u7479", // 瑹
	0x747a: "`\v\u747a", // 瑺
	0x747b: "`\v\u747b", // 瑻
	0x747c: "`\v\u747c", // 瑼
	0x747d: "`\v\u747d", // 瑽
	0x747e: "`\v\u747e", // 瑾
	0x747f: "`\v\u747f", // 瑿
	0x7480: "`\v\u7480", // 璀
	0x7481: "`\v\u7481", // 璁
	0x7482: "`\v\u7482", // 璂
	0x7483: "`\v\u7483", // 璃
	0x7484: "`\v\u7484", // 璄
	0x7485: "`\v\u7485", // 璅
	0x7486: "`\v\u7486", // 璆
	0x7487: "`\v\u7487", // 璇
	0x7488: "`\v\u7488", // 璈
	0x7489: "`\v\u7489", // 璉
	0x748a: "`\v\u748a", // 璊
	0x748b: "`\v\u748b", // 璋
	0x748c: "`\v\u748c", // 璌
	0x748d: "`\f\u748d", // 璍
	0x748e: "`\v\u748e", // 璎
	0x748f: "`\f\u748f", // 璏
	0x7490: "`\f\u7490", // 璐
	0x7491: "`\f\u7491", // 璑
	0x7492: "`\f\u7492", // 璒
	0x7493: "`\v\u7493", // 璓
	0x7494: "`\f\u7494", // 璔
	0x7495: "`\f\u7495", // 璕
	0x7496: "`\f\u7496", // 璖
	0x7497: "`\f\u7497", // 璗
	0x7498: "`\f\u7498", // 璘
	0x7499: "`\f\u7499", // 璙
	0x749a: "`\f\u749a", // 璚
	0x749b: "`\f\u749b", // 璛
	0x749c: "`\f\u749c", // 璜
	0x749d: "`\f\u749d", // 璝
	0x749e: "`\f\u749e", // 璞
	0x749f: "`\f\u749f", // 璟
	0x74a0: "`\f\u74a0", // 璠
	0x74a1: "`\f\u74a1", // 璡
	0x74a2: "`\r\u74a2", // 璢
	0x74a3: "`\f\u74a3", // 璣
	0x74a4: "`\f\u74a4", // 璤
	0x74a5: "`\r\u74a5", // 璥
	0x74a6: "`\r\u74a6", // 璦
	0x74a7: "`\r\u74a7", // 璧
	0x74a8: "`\r\u74a8", // 璨
	0x74a9: "`\r\u74a9", // 璩
	0x74aa: "`\r\u74aa", // 璪
	0x74ab: "`\r\u74ab", // 璫
	0x74ac: "`\r\u74ac", // 璬
	0x74ad: "`\r\u74ad", // 璭
	0x74ae: "`\r\u74ae", // 璮
	0x74af: "`\r\u74af", // 璯
	0x74b0: "`\r\u74b0", // 環
	0x74b1: "`\r\u74b1", // 璱
	0x74b2: "`\r\u74b2", // 璲
	0x74b3: "`\r\u74b3", // 璳
	0x74b4: "`\r\u74b4", // 璴
	0x74b5: "`\x0e\u74b5", // 璵
	0x74b6: "`\x0e\u74b6", // 璶
	0x74b7: "`\x0e\u74b7", // 璷
	0x74b8: "`\x0e\u74b8", // 璸
	0x74b9: "`\x0e\u74b9", // 璹
	0x74ba: "`\x0e\u74ba", // 璺
	0x74bb: "`\x0e\u74bb", // 璻
	0x74bc: "`\x0e\u74bc", // 璼
	0x74bd: "`\x0e\u74bd", // 璽
	0x74be: "`\x0e\u74be", // 璾
	0x74bf: "`\x0e\u74bf", // 璿
	0x74c0: "`\x0e\u74c0", // 瓀
	0x74c1: "`\x0e\u74c1", // 瓁
	0x74c2: "`\x0e\u74c2", // 瓂
	0x74c3: "`\x0f\u74c3", // 瓃
	0x74c4: "`\x0f\u74c4", // 瓄
	0x74c5: "`\x0f\u74c5", // 瓅
	0x74c6: "`\x0f\u74c6", // 瓆
	0x74c7: "`\x0f\u74c7", // 瓇
	0x74c8: "`\x0f\u74c8", // 瓈
	0x74c9: "`\x0f\u74c9", // 瓉
	0x74ca: "`\x0f\u74ca", // 瓊
	0x74cb: "`\x0f\u74cb", // 瓋
	0x74cc: "`\x10\u74cc", // 瓌
	0x74cd: "`\x10\u74cd", // 瓍
	0x74ce: "`\x10\u74ce", // 瓎
	0x74cf: "`\x10\u74cf", // 瓏
	0x74d0: "`\x10\u74d0", // 瓐
	0x74d1: "`\x10\u74d1", // 瓑
	0x74d2: "`\x10\u74d2", // 瓒
	0x74d3: "`\x11\u74d3", // 瓓
	0x74d4: "`\x11\u74d4", // 瓔
	0x74d5: "`\x11\u74d5", // 瓕
	0x74d6: "`\x11\u74d6", // 瓖
	0x74d7: "`\x12\u74d7", // 瓗
	0x74d8: "`\x12\u74d8", // 瓘
	0x74d9: "`\x12\u74d9", // 瓙
	0x74da: "`\x13\u74da", // 瓚
	0x74db: "`\x14\u74db", // 瓛
	0x74dc: "a\x00\u74dc", // 瓜
	0x74dd: "a\x03\u74dd", // 瓝
	0x74de: "a\x05\u74de", // 瓞
	0x74df: "a\x05\u74df", // 瓟
	0x74e0: "a\x06\u74e0", // 瓠
	0x74e1: "a\b\u74e1", // 瓡
	0x74e2: "a\v\u74e2", // 瓢
	0x74e3: "a\x0e\u74e3", // 瓣
	0x74e4: "a\x11\u74e4", // 瓤
	0x74e5: "a\x13\u74e5", // 瓥
	0x74e6: "b\x00\u74e6", // 瓦
	0x74e7: "b\x02\u74e7", // 瓧
	0x74e8: "b\x03\u74e8", // 瓨
	0x74e9: "b\x03\u74e9", // 瓩
	0x74ea: "b\x04\u74ea", // 瓪
	0x74eb: "b\x04\u74eb", // 瓫
	0x74ec: "b\x04\u74ec", // 瓬
	0x74ed: "b\x04\u74ed", // 瓭
	0x74ee: "b\x04\u74ee", // 瓮
	0x74ef: "b\x04\u74ef", // 瓯
	0x74f0: "b\x04\u74f0", // 瓰
	0x74f1: "b\x04\u74f1", // 瓱
	0x74f2: "b\x04\u74f2", // 瓲
	0x74f3: "b\x05\u74f3", // 瓳
	0x74f4: "b\x05\u74f4", // 瓴
	0x74f5: "b\x05\u74f5", // 瓵
	0x74f6: "b\x06\u74f6", // 瓶
	0x74f7: "b\x06\u74f7", // 瓷
	0x74f8: "b\x06\u74f8", // 瓸
	0x74f9: "b\a\u74f9", // 瓹
	0x74fa: "b\a\u74fa", // 瓺
	0x74fb: "b\a\u74fb", // 瓻
	0x74fc: "b\a\u74fc", // 瓼
	0x74fd: "b\b\u74fd", // 瓽
	0x74fe: "b\b\u74fe", // 瓾
	0x74ff: "b\b\u74ff", // 瓿
	0x7500: "b\b\u7500", // 甀
	0x7501: "b\b\u7501", // 甁
	0x7502: "b\t\u7502", // 甂
	0x7503: "b\t\u7503", // 甃
	0x7504: "b\t\u7504", // 甄
	0x7505: "b\t\u7505", // 甅
	0x7506: "b\t\u7506", // 甆
	0x7507: "b\n\u7507", // 甇
	0x7508: "b\n\u7508", // 甈
	0x7509: "b\n\u7509", // 甉
	0x750a: "b\v\u750a", // 甊
	0x750b: "b\v\u750b", // 甋
	0x750c: "b\v\u750c", // 甌
	0x750d: "b\v\u750d", // 甍
	0x750e: "b\v\u750e", // 甎
	0x750f: "b\f\u750f", // 甏
	0x7510: "b\f\u7510", // 甐
	0x7511: "b\f\u7511", // 甑
	0x7512: "b\f\u7512", // 甒
	0x7513: "b\r\u7513", // 甓
	0x7514: "b\r\u7514", // 甔
	0x7515: "b\r\u7515", // 甕
	0x7516: "b\x0e\u7516", // 甖
	0x7517: "b\x10\u7517", // 甗
	0x7518: "c\x00\u7518", // 甘
	0x7519: "c\x03\u7519", // 甙
	0x751a: "c\x04\u751a", // 甚
	0x751b: "c\x06\u751b", // 甛
	0x751c: "c\x06\u751c", // 甜
	0x751d: "c\b\u751d", // 甝
	0x751e: "c\b\u751e", // 甞
	0x751f: "d\x00\u751f", // 生
	0x7520: "d\x04\u7520", // 甠
	0x7521: "d\x05\u7521", // 甡
	0x7522: "d\x06\u7522", // 產
	0x7523: "d\x06\u7523", // 産
	0x7524: "d\a\u7524", // 甤
	0x7525: "d\a\u7525", // 甥
	0x7526: "d\a\u7526", // 甦
	0x7527: "d\t\u7527", // 甧
	0x7528: "e\x00\u7528", // 用
	0x7529: "e\x00\u7529", // 甩
	0x752a: "e\x01\u752a", // 甪
	0x752b: "e\x02\u752b", // 甫
	0x752c: "e\x02\u752c", // 甬
	0x752d: "e\x04\u752d", // 甭
	0x752e: "e\x04\u752e", // 甮
	0x752f: "e\a\u752f", // 甯
	0x7530: "f\x00\u7530", // 田
	0x7531: "f\x00\u7531", // 由
	0x7532: "f\x00\u7532", // 甲
	0x7533: "f\x00\u7533", // 申
	0x7534: "f\x00\u7534", // 甴
	0x7535: "f\x00\u7535", // 电
	0x7536: "f\x01\u7536", // 甶
	0x7537: "f\x02\u7537", // 男
	0x7538: "f\x02\u7538", // 甸
	0x7539: "f\x02\u7539", // 甹
	0x753a: "f\x02\u753a", // 町
	0x753b: "f\x03\u753b", // 画
	0x753c: "f\x02\u753c", // 甼
	0x753d: "f\x03\u753d", // 甽
	0x753e: "f\x03\u753e", // 甾
	0x753f: "f\x03\u753f", // 甿
	0x7540: "f\x03\u7540", // 畀
	0x7541: "f\x03\u7541", // 畁
	0x7542: "f\x03\u7542", // 畂
	0x7543: "f\x03\u7543", // 畃
	0x7544: "f\x03\u7544", // 畄
	0x7545: "f\x03\u7545", // 畅
	0x7546: "f\x04\u7546", // 畆
	0x7547: "f\x04\u7547", // 畇
	0x7548: "f\x04\u7548", // 畈
	0x7549: "f\x04\u7549", // 畉
	0x754a: "f\x04\u754a", // 畊
	0x754b: "f\x04\u754b", // 畋
	0x754c: "f\x04\u754c", // 界
	0x754d: "f\x04\u754d", // 畍
	0x754e: "f\x04\u754e", // 畎
	0x754f: "f\x04\u754f", // 畏
	0x7550: "f\x04\u7550", // 畐
	0x7551: "f\x04\u7551", // 畑
	0x7552: "f\x04\u7552", // 畒
	0x7553: "f\x04\u7553", // 畓
	0x7554: "f\x05\u7554", // 畔
	0x7555: "f\x05\u7555", // 畕
	0x7556: "f\x05\u7556", // 畖
	0x7557: "f\x05\u7557", // 畗
	0x7558: "f\x05\u7558", // 畘
	0x7559: "f\x05\u7559", // 留
	0x755a: "f\x05\u755a", // 畚
	0x755b: "f\x05\u755b", // 畛
	0x755c: "f\x05\u755c", // 畜
	0x755d: "f\x05\u755d", // 畝
	0x755e: "f\x05\u755e", // 畞
	0x755f: "f\x05\u755f", // 畟
	0x7560: "j\x05\u7560", // 畠
	0x7561: "f\x06\u7561", // 畡
	0x7562: "f\x06\u7562", // 畢
	0x7563: "f\x06\u7563", // 畣
	0x7564: "f\x06\u7564", // 畤
	0x7565: "f\x06\u7565", // 略
	0x7566: "f\x06\u7566", // 畦
	0x7567: "f\x06\u7567", // 畧
	0x7568: "w\x05\u7568", // 畨
	0x7569: "f\x06\u7569", // 畩
	0x756a: "f\a\u756a", // 番
	0x756b: "f\a\u756b", // 畫
	0x756c: "f\a\u756c", // 畬
	0x756d: "f\a\u756d", // 畭
	0x756e: "f\a\u756e", // 畮
	0x756f: "f\a\u756f", // 畯
	0x7570: "f\x06\u7570", // 異
	0x7571: "f\t\u7571", // 畱
	0x7572: "f\a\u7572", // 畲
	0x7573: "f\a\u7573", // 畳
	0x7574: "f\a\u7574", // 畴
	0x7575: "f\b\u7575", // 畵
	0x7576: "f\b\u7576", // 當
	0x7577: "f\b\u7577", // 畷
	0x7578: "f\b\u7578", // 畸
	0x7579: "f\b\u7579", // 畹
	0x757a: "f\b\u757a", // 畺
	0x757b: "f\t\u757b", // 畻
	0x757c: "f\t\u757c", // 畼
	0x757d: "f\t\u757d", // 畽
	0x757e: "f\n\u757e", // 畾
	0x757f: "f\n\u757f", // 畿
	0x7580: "f\v\u7580", // 疀
	0x7581: "f\v\u7581", // 疁
	0x7582: "f\v\u7582", // 疂
	0x7583: "f\f\u7583", // 疃
	0x7584: "f\f\u7584", // 疄
	0x7585: "f\r\u7585", // 疅
	0x7586: "f\x0e\u7586", // 疆
	0x7587: "f\x0e\u7587", // 疇
	0x7588: "f\x0f\u7588", // 疈
	0x7589: "f\x11\u7589", // 疉
	0x758a: "f\x11\u758a", // 疊
	0x758b: "g\x00\u758b", // 疋
	0x758c: "g\x03\u758c", // 疌
	0x758d: "g\x05\u758d", // 疍
	0x758e: "g\a\u758e", // 疎
	0x758f: "g\a\u758f", // 疏
	0x7590: "g\t\u7590", // 疐
	0x7591: "g\t\u7591", // 疑
	0x7592: "h\x00\u7592", // 疒
	0x7593: "h\x02\u7593", // 疓
	0x7594: "h\x02\u7594", // 疔
	0x7595: "h\x02\u7595", // 疕
	0x7596: "h\x02\u7596", // 疖
	0x7597: "h\x02\u7597", // 疗
	0x7598: "h\x03\u7598", // 疘
	0x7599: "h\x03\u7599", // 疙
	0x759a: "h\x03\u759a", // 疚
	0x759b: "h\x03\u759b", // 疛
	0x759c: "h\x03\u759c", // 疜
	0x759d: "h\x03\u759d", // 疝
	0x759e: "h\x03\u759e", // 疞
	0x759f: "h\x03\u759f", // 疟
	0x75a0: "h\x03\u75a0", // 疠
	0x75a1: "h\x04\u75a1", // 疡
	0x75a2: "h\x04\u75a2", // 疢
	0x75a3: "h\x04\u75a3", // 疣
	0x75a4: "h\x04\u75a4", // 疤
	0x75a5: "h\x04\u75a5", // 疥
	0x75a6: "h\x04\u75a6", // 疦
	0x75a7: "h\x04\u75a7", // 疧
	0x75a8: "h\x04\u75a8", // 疨
	0x75a9: "h\x04\u75a9", // 疩
	0x75aa: "h\x04\u75aa", // 疪
	0x75ab: "h\x04\u75ab", // 疫
	0x75ac: "h\x04\u75ac", // 疬
	0x75ad: "h\x04\u75ad", // 疭
	0x75ae: "h\x04\u75ae", // 疮
	0x75af: "h\x04\u75af", // 疯
	0x75b0: "h\x05\u75b0", // 疰
	0x75b1: "h\x05\u75b1", // 疱
	0x75b2: "h\x05\u75b2", // 疲
	0x75b3: "h\x05\u75b3", // 疳
	0x75b4: "h\x05\u75b4", // 疴
	0x75b5: "h\x05\u75b5", // 疵
	0x75b6: "h\x05\u75b6", // 疶
	0x75b7: "h\x05\u75b7", // 疷
	0x75b8: "h\x05\u75b8", // 疸
	0x75b9: "h\x05\u75b9", // 疹
	0x75ba: "h\x04\u75ba", // 疺
	0x75bb: "h\x05\u75bb", // 疻
	0x75bc: "h\x05\u75bc", // 疼
	0x75bd: "h\x05\u75bd", // 疽
	0x75be: "h\x05\u75be", // 疾
	0x75bf: "h\x05\u75bf", // 疿
	0x75c0: "h\x05\u75c0", // 痀
	0x75c1: "h\x05\u75c1", // 痁
	0x75c2: "h\x05\u75c2", // 痂
	0x75c3: "h\x05\u75c3", // 痃
	0x75c4: "h\x05\u75c4", // 痄
	0x75c5: "h\x05\u75c5", // 病
	0x75c6: "h\x05\u75c6", // 痆
	0x75c7: "h\x05\u75c7", // 症
	0x75c8: "h\x05\u75c8", // 痈
	0x75c9: "h\x05\u75c9", // 痉
	0x75ca: "h\x06\u75ca", // 痊
	0x75cb: "h\x06\u75cb", // 痋
	0x75cc: "h\x06\u75cc", // 痌
	0x75cd: "h\x06\u75cd", // 痍
	0x75ce: "h\x06\u75ce", // 痎
	0x75cf: "h\x06\u75cf", // 痏
	0x75d0: "h\x06\u75d0", // 痐
	0x75d1: "h\x06\u75d1", // 痑
	0x75d2: "h\x06\u75d2", // 痒
	0x75d3: "h\x06\u75d3", // 痓
	0x75d4: "h\x06\u75d4", // 痔
	0x75d5: "h\x06\u75d5", // 痕
	0x75d6: "h\x06\u75d6", // 痖
	0x75d7: "h\a\u75d7", // 痗
	0x75d8: "h\a\u75d8", // 痘
	0x75d9: "h\a\u75d9", // 痙
	0x75da: "h\a\u75da", // 痚
	0x75db: "h\a\u75db", // 痛
	0x75dc: "h\a\u75dc", // 痜
	0x75dd: "h\a\u75dd", // 痝
	0x75de: "h\a\u75de", // 痞
	0x75df: "h\a\u75df", // 痟
	0x75e0: "h\a\u75e0", // 痠
	0x75e1: "h\a\u75e1", // 痡
	0x75e2: "h\a\u75e2", // 痢
	0x75e3: "h\a\u75e3", // 痣
	0x75e4: "h\a\u75e4", // 痤
	0x75e5: "h\a\u75e5", // 痥
	0x75e6: "h\a\u75e6", // 痦
	0x75e7: "h\a\u75e7", // 痧
	0x75e8: "h\a\u75e8", // 痨
	0x75e9: "h\a\u75e9", // 痩
	0x75ea: "h\a\u75ea", // 痪
	0x75eb: "h\a\u75eb", // 痫
	0x75ec: "h\b\u75ec", // 痬
	0x75ed: "h\b\u75ed", // 痭
	0x75ee: "h\b\u75ee", // 痮
	0x75ef: "h\b\u75ef", // 痯
	0x75f0: "h\b\u75f0", // 痰
	0x75f1: "h\b\u75f1", // 痱
	0x75f2: "h\b\u75f2", // 痲
	0x75f3: "h\b\u75f3", // 痳
	0x75f4: "h\b\u75f4", // 痴
	0x75f5: "h\b\u75f5", // 痵
	0x75f6: "h\b\u75f6", // 痶
	0x75f7: "h\b\u75f7", // 痷
	0x75f8: "h\b\u75f8", // 痸
	0x75f9: "h\b\u75f9", // 痹
	0x75fa: "h\b\u75fa", // 痺
	0x75fb: "h\b\u75fb", // 痻
	0x75fc: "h\b\u75fc", // 痼
	0x75fd: "h\b\u75fd", // 痽
	0x75fe: "h\b\u75fe", // 痾
	0x75ff: "h\b\u75ff", // 痿
	0x7600: "h\b\u7600", // 瘀
	0x7601: "h\b\u7601", // 瘁
	0x7602: "h\b\u7602", // 瘂
	0x7603: "h\b\u7603", // 瘃
	0x7604: "h\b\u7604", // 瘄
	0x7605: "h\b\u7605", // 瘅
	0x7606: "h\b\u7606", // 瘆
	0x7607: "h\t\u7607", // 瘇
	0x7608: "h\t\u7608", // 瘈
	0x7609: "h\t\u7609", // 瘉
	0x760a: "h\t\u760a", // 瘊
	0x760b: "h\t\u760b", // 瘋
	0x760c: "h\t\u760c", // 瘌
	0x760d: "h\t\u760d", // 瘍
	0x760e: "h\t\u760e", // 瘎
	0x760f: "h\t\u760f", // 瘏
	0x7610: "h\t\u7610", // 瘐
	0x7611: "h\t\u7611", // 瘑
	0x7612: "h\t\u7612", // 瘒
	0x7613: "h\t\u7613", // 瘓
	0x7614: "h\t\u7614", // 瘔
	0x7615: "h\t\u7615", // 瘕
	0x7616: "h\t\u7616", // 瘖
	0x7617: "h\t\u7617", // 瘗
	0x7618: "h\t\u7618", // 瘘
	0x7619: "h\n\u7619", // 瘙
	0x761a: "h\n\u761a", // 瘚
	0x761b: "h\n\u761b", // 瘛
	0x761c: "h\n\u761c", // 瘜
	0x761d: "h\n\u761d", // 瘝
	0x761e: "h\n\u761e", // 瘞
	0x761f: "h\t\u761f", // 瘟
	0x7620: "h\n\u7620", // 瘠
	0x7621: "h\n\u7621", // 瘡
	0x7622: "h\n\u7622", // 瘢
	0x7623: "h\n\u7623", // 瘣
	0x7624: "h\n\u7624", // 瘤
	0x7625: "h\n\u7625", // 瘥
	0x7626: "h\n\u7626", // 瘦
	0x7627: "h\t\u7627", // 瘧
	0x7628: "h\n\u7628", // 瘨
	0x7629: "h\n\u7629", // 瘩
	0x762a: "h\n\u762a", // 瘪
	0x762b: "h\n\u762b", // 瘫
	0x762c: "h\v\u762c", // 瘬
	0x762d: "h\v\u762d", // 瘭
	0x762e: "h\v\u762e", // 瘮
	0x762f: "h\v\u762f", // 瘯
	0x7630: "h\v\u7630", // 瘰
	0x7631: "h\v\u7631", // 瘱
	0x7632: "h\v\u7632", // 瘲
	0x7633: "h\v\u7633", // 瘳
	0x7634: "h\v\u7634", // 瘴
	0x7635: "h\v\u7635", // 瘵
	0x7636: "h\v\u7636", // 瘶
	0x7637: "h\v\u7637", // 瘷
	0x7638: "h\v\u7638", // 瘸
	0x7639: "h\v\u7639", // 瘹
	0x763a: "h\v\u763a", // 瘺
	0x763b: "h\v\u763b", // 瘻
	0x763c: "h\v\u763c", // 瘼
	0x763d: "h\v\u763d", // 瘽
	0x763e: "h\v\u763e", // 瘾
	0x763f: "h\v\u763f", // 瘿
	0x7640: "h\f\u7640", // 癀
	0x7641: "h\f\u7641", // 癁
	0x7642: "h\f\u7642", // 療
	0x7643: "h\f\u7643", // 癃
	0x7644: "h\f\u7644", // 癄
	0x7645: "h\f\u7645", // 癅
	0x7646: "h\f\u7646", // 癆
	0x7647: "h\f\u7647", // 癇
	0x7648: "h\f\u7648", // 癈
	0x7649: "h\f\u7649", // 癉
	0x764a: "h\v\u764a", // 癊
	0x764b: "h\f\u764b", // 癋
	0x764c: "h\f\u764c", // 癌
	0x764d: "h\f\u764d", // 癍
	0x764e: "h\f\u764e", // 癎
	0x764f: "h\r\u764f", // 癏
	0x7650: "h\r\u7650", // 癐
	0x7651: "h\r\u7651", // 癑
	0x7652: "h\r\u7652", // 癒
	0x7653: "h\r\u7653", // 癓
	0x7654: "h\r\u7654", // 癔
	0x7655: "h\r\u7655", // 癕
	0x7656: "h\r\u7656", // 癖
	0x7657: "h\r\u7657", // 癗
	0x7658: "h\r\u7658", // 癘
	0x7659: "h\r\u7659", // 癙
	0x765a: "h\r\u765a", // 癚
	0x765b: "h\r\u765b", // 癛
	0x765c: "h\r\u765c", // 癜
	0x765d: "h\r\u765d", // 癝
	0x765e: "h\r\u765e", // 癞
	0x765f: "h\x0e\u765f", // 癟
	0x7660: "h\x0e\u7660", // 癠
	0x7661: "h\x0e\u7661", // 癡
	0x7662: "h\x0f\u7662", // 癢
	0x7663: "h\x0e\u7663", // 癣
	0x7664: "h\x0f\u7664", // 癤
	0x7665: "h\x0f\u7665", // 癥
	0x7666: "h\x0f\u7666", // 癦
	0x7667: "h\x10\u7667", // 癧
	0x7668: "h\x10\u7668", // 癨
	0x7669: "h\x10\u7669", // 癩
	0x766a: "h\x10\u766a", // 癪
	0x766b: "h\x10\u766b", // 癫
	0x766c: "h\x11\u766c", // 癬
	0x766d: "h\x11\u766d", // 癭
	0x766e: "h\x11\u766e", // 癮
	0x766f: "h\x12\u766f", // 癯
	0x7670: "h\x12\u7670", // 癰
	0x7671: "h\x13\u7671", // 癱
	0x7672: "h\x13\u7672", // 癲
	0x7673: "h\x15\u7673", // 癳
	0x7674: "h\x17\u7674", // 癴
	0x7675: "h\x19\u7675", // 癵
	0x7676: "i\x00\u7676", // 癶
	0x7677: "i\x03\u7677", // 癷
	0x7678: "i\x04\u7678", // 癸
	0x7679: "i\x04\u7679", // 癹
	0x767a: "i\x04\u767a", // 発
	0x767b: "i\a\u767b", // 登
	0x767c: "i\a\u767c", // 發
	0x767d: "j\x00\u767d", // 白
	0x767e: "j\x01\u767e", // 百
	0x767f: "j\x01\u767f", // 癿
	0x7680: "j\x02\u7680", // 皀
	0x7681: "j\x02\u7681", // 皁
	0x7682: "j\x02\u7682", // 皂
	0x7683: "j\x02\u7683", // 皃
	0x7684: "j\x03\u7684", // 的
	0x7685: "j\x04\u7685", // 皅
	0x7686: "j\x04\u7686", // 皆
	0x7687: "j\x04\u7687", // 皇
	0x7688: "j\x04\u7688", // 皈
	0x7689: "j\x05\u7689", // 皉
	0x768a: "j\x05\u768a", // 皊
	0x768b: "j\x05\u768b", // 皋
	0x768c: "j\x05\u768c", // 皌
	0x768d: "j\x05\u768d", // 皍
	0x768e: "j\x06\u768e", // 皎
	0x768f: "j\x06\u768f", // 皏
	0x7690: "j\x06\u7690", // 皐
	0x7691: "j\x06\u7691", // 皑
	0x7692: "j\a\u7692", // 皒
	0x7693: "j\a\u7693", // 皓
	0x7694: "j\a\u7694", // 皔
	0x7695: "j\a\u7695", // 皕
	0x7696: "j\a\u7696", // 皖
	0x7697: "j\b\u7697", // 皗
	0x7698: "j\b\u7698", // 皘
	0x7699: "j\b\u7699", // 皙
	0x769a: "j\n\u769a", // 皚
	0x769b: "j\n\u769b", // 皛
	0x769c: "j\n\u769c", // 皜
	0x769d: "j\n\u769d", // 皝
	0x769e: "j\n\u769e", // 皞
	0x769f: "j\v\u769f", // 皟
	0x76a0: "j\v\u76a0", // 皠
	0x76a1: "j\v\u76a1", // 皡
	0x76a2: "j\f\u76a2", // 皢
	0x76a3: "j\f\u76a3", // 皣
	0x76a4: "j\f\u76a4", // 皤
	0x76a5: "j\f\u76a5", // 皥
	0x76a6: "j\r\u76a6", // 皦
	0x76a7: "j\r\u76a7", // 皧
	0x76a8: "j\r\u76a8", // 皨
	0x76a9: "j\x0e\u76a9", // 皩
	0x76aa: "j\x0f\u76aa", // 皪
	0x76ab: "j\x0f\u76ab", // 皫
	0x76ac: "j\x10\u76ac", // 皬
	0x76ad: "j\x12\u76ad", // 皭
	0x76ae: "k\x00\u76ae", // 皮
	0x76af: "k\x03\u76af", // 皯
	0x76b0: "k\x05\u76b0", // 皰
	0x76b1: "k\x05\u76b1", // 皱
	0x76b2: "k\x06\u76b2", // 皲
	0x76b3: "k\a\u76b3", // 皳
	0x76b4: "k\a\u76b4", // 皴
	0x76b5: "k\b\u76b5", // 皵
	0x76b6: "k\t\u76b6", // 皶
	0x76b7: "k\t\u76b7", // 皷
	0x76b8: "k\t\u76b8", // 皸
	0x76b9: "k\t\u76b9", // 皹
	0x76ba: "k\n\u76ba", // 皺
	0x76bb: "k\v\u76bb", // 皻
	0x76bc: "k\f\u76bc", // 皼
	0x76bd: "k\r\u76bd", // 皽
	0x76be: "k\x0f\u76be", // 皾
	0x76bf: "l\x00\u76bf", // 皿
	0x76c0: "l\x02\u76c0", // 盀
	0x76c1: "l\x02\u76c1", // 盁
	0x76c2: "l\x03\u76c2", // 盂
	0x76c3: "l\x04\u76c3", // 盃
	0x76c4: "l\x04\u76c4", // 盄
	0x76c5: "l\x04\u76c5", // 盅
	0x76c6: "l\x04\u76c6", // 盆
	0x76c7: "l\x04\u76c7", // 盇
	0x76c8: "l\x04\u76c8", // 盈
	0x76c9: "l\x05\u76c9", // 盉
	0x76ca: "l\x05\u76ca", // 益
	0x76cb: "l\x05\u76cb", // 盋
	0x76cc: "l\x05\u76cc", // 盌
	0x76cd: "l\x05\u76cd", // 盍
	0x76ce: "l\x05\u76ce", // 盎
	0x76cf: "l\x05\u76cf", // 盏
	0x76d0: "l\x05\u76d0", // 盐
	0x76d1: "l\x05\u76d1", // 监
	0x76d2: "l\x06\u76d2", // 盒
	0x76d3: "l\x06\u76d3", // 盓
	0x76d4: "l\x06\u76d4", // 盔
	0x76d5: "l\x06\u76d5", // 盕
	0x76d6: "l\x06\u76d6", // 盖
	0x76d7: "l\x06\u76d7", // 盗
	0x76d8: "l\x06\u76d8", // 盘
	0x76d9: "l\a\u76d9", // 盙
	0x76da: "l\a\u76da", // 盚
	0x76db: "l\x06\u76db", // 盛
	0x76dc: "l\a\u76dc", // 盜
	0x76dd: "l\b\u76dd", // 盝
	0x76de: "l\b\u76de", // 盞
	0x76df: "l\b\u76df", // 盟
	0x76e0: "l\t\u76e0", // 盠
	0x76e1: "l\t\u76e1", // 盡
	0x76e2: "l\t\u76e2", // 盢
	0x76e3: "l\t\u76e3", // 監
	0x76e4: "l\n\u76e4", // 盤
	0x76e5: "l\v\u76e5", // 盥
	0x76e6: "l\v\u76e6", // 盦
	0x76e7: "l\v\u76e7", // 盧
	0x76e8: "l\f\u76e8", // 盨
	0x76e9: "l\f\u76e9", // 盩
	0x76ea: "l\f\u76ea", // 盪
	0x76eb: "l\r\u76eb", // 盫
	0x76ec: "l\r\u76ec", // 盬
	0x76ed: "l\x0f\u76ed", // 盭
	0x76ee: "m\x00\u76ee", // 目
	0x76ef: "m\x02\u76ef", // 盯
	0x76f0: "m\x03\u76f0", // 盰
	0x76f1: "m\x03\u76f1", // 盱
	0x76f2: "m\x03\u76f2", // 盲
	0x76f3: "m\x03\u76f3", // 盳
	0x76f4: "m\x03\u76f4", // 直
	0x76f5: "m\x03\u76f5", // 盵
	0x76f6: "m\x04\u76f6", // 盶
	0x76f7: "m\x04\u76f7", // 盷
	0x76f8: "m\x04\u76f8", // 相
	0x76f9: "m\x04\u76f9", // 盹
	0x76fa: "m\x04\u76fa", // 盺
	0x76fb: "m\x04\u76fb", // 盻
	0x76fc: "m\x04\u76fc", // 盼
	0x76fd: "m\x04\u76fd", // 盽
	0x76fe: "m\x04\u76fe", // 盾
	0x76ff: "m\x04\u76ff", // 盿
	0x7700: "m\x04\u7700", // 眀
	0x7701: "m\x04\u7701", // 省
	0x7702: "m\x04\u7702", // 眂
	0x7703: "m\x04\u7703", // 眃
	0x7704: "m\x04\u7704", // 眄
	0x7705: "m\x04\u7705", // 眅
	0x7706: "m\x04\u7706", // 眆
	0x7707: "m\x04\u7707", // 眇
	0x7708: "m\x04\u7708", // 眈
	0x7709: "m\x04\u7709", // 眉
	0x770a: "m\x04\u770a", // 眊
	0x770b: "m\x04\u770b", // 看
	0x770c: "m\x04\u770c", // 県
	0x770d: "m\x04\u770d", // 眍
	0x770e: "m\x05\u770e", // 眎
	0x770f: "m\x05\u770f", // 眏
	0x7710: "m\x05\u7710", // 眐
	0x7711: "m\x05\u7711", // 眑
	0x7712: "m\x05\u7712", // 眒
	0x7713: "m\x05\u7713", // 眓
	0x7714: "m\x05\u7714", // 眔
	0x7715: "m\x05\u7715", // 眕
	0x7716: "m\x05\u7716", // 眖
	0x7717: "m\x05\u7717", // 眗
	0x7718: "m\x05\u7718", // 眘
	0x7719: "m\x05\u7719", // 眙
	0x771a: "m\x05\u771a", // 眚
	0x771b: "m\x05\u771b", // 眛
	0x771c: "m\x05\u771c", // 眜
	0x771d: "m\x05\u771d", // 眝
	0x771e: "m\x05\u771e", // 眞
	0x771f: "m\x05\u771f", // 真
	0x7720: "m\x05\u7720", // 眠
	0x7721: "m\x05\u7721", // 眡
	0x7722: "m\x05\u7722", // 眢
	0x7723: "m\x05\u7723", // 眣
	0x7724: "m\x05\u7724", // 眤
	0x7725: "m\x05\u7725", // 眥
	0x7726: "m\x05\u7726", // 眦
	0x7727: "m\x05\u7727", // 眧
	0x7728: "m\x05\u7728", // 眨
	0x7729: "m\x05\u7729", // 眩
	0x772a: "m\x05\u772a", // 眪
	0x772b: "m\x05\u772b", // 眫
	0x772c: "m\x05\u772c", // 眬
	0x772d: "m\x06\u772d", // 眭
	0x772e: "m\x06\u772e", // 眮
	0x772f: "m\x06\u772f", // 眯
	0x7730: "m\x06\u7730", // 眰
	0x7731: "m\x06\u7731", // 眱
	0x7732: "m\x06\u7732", // 眲
	0x7733: "m\x06\u7733", // 眳
	0x7734: "m\x06\u7734", // 眴
	0x7735: "m\x06\u7735", // 眵
	0x7736: "m\x06\u7736", // 眶
	0x7737: "m\x06\u7737", // 眷
	0x7738: "m\x06\u7738", // 眸
	0x7739: "m\x06\u7739", // 眹
	0x773a: "m\x06\u773a", // 眺
	0x773b: "m\x06\u773b", // 眻
	0x773c: "m\x06\u773c", // 眼
	0x773d: "m\x06\u773d", // 眽
	0x773e: "m\x06\u773e", // 眾
	0x773f: "m\x05\u773f", // 眿
	0x7740: "m\a\u7740", // 着
	0x7741: "m\x06\u7741", // 睁
	0x7742: "m\a\u7742", // 睂
	0x7743: "m\a\u7743", // 睃
	0x7744: "m\a\u7744", // 睄
	0x7745: "m\a\u7745", // 睅
	0x7746: "m\a\u7746", // 睆
	0x7747: "m\a\u7747", // 睇
	0x7748: "m\a\u7748", // 睈
	0x7749: "m\a\u7749", // 睉
	0x774a: "m\a\u774a", // 睊
	0x774b: "m\a\u774b", // 睋
	0x774c: "m\a\u774c", // 睌
	0x774d: "m\a\u774d", // 睍
	0x774e: "m\a\u774e", // 睎
	0x774f: "m\a\u774f", // 睏
	0x7750: "m\a\u7750", // 睐
	0x7751: "m\a\u7751", // 睑
	0x7752: "m\b\u7752", // 睒
	0x7753: "m\b\u7753", // 睓
	0x7754: "m\b\u7754", // 睔
	0x7755: "m\b\u7755", // 睕
	0x7756: "m\b\u7756", // 睖
	0x7757: "m\b\u7757", // 睗
	0x7758: "m\b\u7758", // 睘
	0x7759: "m\b\u7759", // 睙
	0x775a: "m\b\u775a", // 睚
	0x775b: "m\b\u775b", // 睛
	0x775c: "m\b\u775c", // 睜
	0x775d: "m\b\u775d", // 睝
	0x775e: "m\b\u775e", // 睞
	0x775f: "m\b\u775f", // 睟
	0x7760: "m\b\u7760", // 睠
	0x7761: "m\t\u7761", // 睡
	0x7762: "m\b\u7762", // 睢
	0x7763: "m\b\u7763", // 督
	0x7764: "m\b\u7764", // 睤
	0x7765: "m\b\u7765", // 睥
	0x7766: "m\b\u7766", // 睦
	0x7767: "m\b\u7767", // 睧
	0x7768: "m\b\u7768", // 睨
	0x7769: "m\b\u7769", // 睩
	0x776a: "m\b\u776a", // 睪
	0x776b: "m\b\u776b", // 睫
	0x776c: "m\b\u776c", // 睬
	0x776d: "m\b\u776d", // 睭
	0x776e: "m\t\u776e", // 睮
	0x776f: "m\t\u776f", // 睯
	0x7770: "m\t\u7770", // 睰
	0x7771: "m\t\u7771", // 睱
	0x7772: "m\t\u7772", // 睲
	0x7773: "m\t\u7773", // 睳
	0x7774: "m\t\u7774", // 睴
	0x7775: "m\t\u7775", // 睵
	0x7776: "m\t\u7776", // 睶
	0x7777: "m\t\u7777", // 睷
	0x7778: "m\t\u7778", // 睸
	0x7779: "m\t\u7779", // 睹
	0x777a: "m\t\u777a", // 睺
	0x777b: "m\t\u777b", // 睻
	0x777c: "m\t\u777c", // 睼
	0x777d: "m\t\u777d", // 睽
	0x777e: "m\t\u777e", // 睾
	0x777f: "m\t\u777f", // 睿
	0x7780: "m\t\u7780", // 瞀
	0x7781: "m\t\u7781", // 瞁
	0x7782: "m\t\u7782", // 瞂
	0x7783: "m\t\u7783", // 瞃
	0x7784: "m\t\u7784", // 瞄
	0x7785: "m\t\u7785", // 瞅
	0x7786: "m\t\u7786", // 瞆
	0x7787: "m\n\u7787", // 瞇
	0x7788: "m\n\u7788", // 瞈
	0x7789: "m\n\u7789", // 瞉
	0x778a: "m\n\u778a", // 瞊
	0x778b: "m\n\u778b", // 瞋
	0x778c: "m\n\u778c", // 瞌
	0x778d: "m\n\u778d", // 瞍
	0x778e: "m\n\u778e", // 瞎
	0x778f: "m\n\u778f", // 瞏
	0x7790: "m\n\u7790", // 瞐
	0x7791: "m\n\u7791", // 瞑
	0x7792: "m\n\u7792", // 瞒
	0x7793: "m\n\u7793", // 瞓
	0x7794: "m\v\u7794", // 瞔
	0x7795: "m\v\u7795", // 瞕
	0x7796: "m\v\u7796", // 瞖
	0x7797: "m\v\u7797", // 瞗
	0x7798: "m\v\u7798", // 瞘
	0x7799: "m\v\u7799", // 瞙
	0x779a: "m\v\u779a", // 瞚
	0x779b: "m\v\u779b", // 瞛
	0x779c: "m\v\u779c", // 瞜
	0x779d: "m\v\u779d", // 瞝
	0x779e: "m\v\u779e", // 瞞
	0x779f: "m\v\u779f", // 瞟
	0x77a0: "m\v\u77a0", // 瞠
	0x77a1: "m\v\u77a1", // 瞡
	0x77a2: "m\v\u77a2", // 瞢
	0x77a3: "m\v\u77a3", // 瞣
	0x77a4: "m\f\u77a4", // 瞤
	0x77a5: "m\f\u77a5", // 瞥
	0x77a6: "m\f\u77a6", // 瞦
	0x77a7: "m\f\u77a7", // 瞧
	0x77a8: "m\f\u77a8", // 瞨
	0x77a9: "m\f\u77a9", // 瞩
	0x77aa: "m\f\u77aa", // 瞪
	0x77ab: "m\f\u77ab", // 瞫
	0x77ac: "m\f\u77ac", // 瞬
	0x77ad: "m\f\u77ad", // 瞭
	0x77ae: "m\f\u77ae", // 瞮
	0x77af: "m\f\u77af", // 瞯
	0x77b0: "m\f\u77b0", // 瞰
	0x77b1: "m\f\u77b1", // 瞱
	0x77b2: "m\f\u77b2", // 瞲
	0x77b3: "m\f\u77b3", // 瞳
	0x77b4: "m\f\u77b4", // 瞴
	0x77b5: "m\f\u77b5", // 瞵
	0x77b6: "m\f\u77b6", // 瞶
	0x77b7: "m\f\u77b7", // 瞷
	0x77b8: "m\r\u77b8", // 瞸
	0x77b9: "m\r\u77b9", // 瞹
	0x77ba: "m\r\u77ba", // 瞺
	0x77bb: "m\r\u77bb", // 瞻
	0x77bc: "m\r\u77bc", // 瞼
	0x77bd: "m\r\u77bd", // 瞽
	0x77be: "m\r\u77be", // 瞾
	0x77bf: "m\r\u77bf", // 瞿
	0x77c0: "m\r\u77c0", // 矀
	0x77c1: "m\r\u77c1", // 矁
	0x77c2: "m\r\u77c2", // 矂
	0x77c3: "m\x0e\u77c3", // 矃
	0x77c4: "m\x0e\u77c4", // 矄
	0x77c5: "m\x0e\u77c5", // 矅
	0x77c6: "m\x0e\u77c6", // 矆
	0x77c7: "m\x0e\u77c7", // 矇
	0x77c8: "m\x0e\u77c8", // 矈
	0x77c9: "m\x0e\u77c9", // 矉
	0x77ca: "m\x0e\u77ca", // 矊
	0x77cb: "m\x0f\u77cb", // 矋
	0x77cc: "m\x0f\u77cc", // 矌
	0x77cd: "m\x0f\u77cd", // 矍
	0x77ce: "m\x0f\u77ce", // 矎
	0x77cf: "m\x0f\u77cf", // 矏
	0x77d0: "m\x10\u77d0", // 矐
	0x77d1: "m\x10\u77d1", // 矑
	0x77d2: "m\x10\u77d2", // 矒
	0x77d3: "m\x10\u77d3", // 矓
	0x77d4: "m\x12\u77d4", // 矔
	0x77d5: "m\x13\u77d5", // 矕
	0x77d6: "m\x15\u77d6", // 矖
	0x77d7: "m\x13\u77d7", // 矗
	0x77d8: "m\x14\u77d8", // 矘
	0x77d9: "m\x14\u77d9", // 矙
	0x77da: "m\x15\u77da", // 矚
	0x77db: "n\x00\u77db", // 矛
	0x77dc: "n\x04\u77dc", // 矜
	0x77dd: "n\x05\u77dd", // 矝
	0x77de: "n\a\u77de", // 矞
	0x77df: "n\a\u77df", // 矟
	0x77e0: "n\b\u77e0", // 矠
	0x77e1: "n\x14\u77e1", // 矡
	0x77e2: "o\x00\u77e2", // 矢
	0x77e3: "o\x02\u77e3", // 矣
	0x77e4: "o\x03\u77e4", // 矤
	0x77e5: "o\x03\u77e5", // 知
	0x77e6: "o\x04\u77e6", // 矦
	0x77e7: "o\x04\u77e7", // 矧
	0x77e8: "o\x04\u77e8", // 矨
	0x77e9: "o\x05\u77e9", // 矩
	0x77ea: "o\x06\u77ea", // 矪
	0x77eb: "o\x06\u77eb", // 矫
	0x77ec: "o\a\u77ec", // 矬
	0x77ed: "o\a\u77ed", // 短
	0x77ee: "o\b\u77ee", // 矮
	0x77ef: "o\f\u77ef", // 矯
	0x77f0: "o\f\u77f0", // 矰
	0x77f1: "o\x0e\u77f1", // 矱
	0x77f2: "o\x0f\u77f2", // 矲
	0x77f3: "p\x00\u77f3", // 石
	0x77f4: "p\x02\u77f4", // 矴
	0x77f5: "p\x02\u77f5", // 矵
	0x77f6: "p\x02\u77f6", // 矶
	0x77f7: "p\x03\u77f7", // 矷
	0x77f8: "p\x03\u77f8", // 矸
	0x77f9: "p\x03\u77f9", // 矹
	0x77fa: "p\x03\u77fa", // 矺
	0x77fb: "p\x03\u77fb", // 矻
	0x77fc: "p\x03\u77fc", // 矼
	0x77fd: "p\x03\u77fd", // 矽
	0x77fe: "p\x03\u77fe", // 矾
	0x77ff: "p\x03\u77ff", // 矿
	0x7800: "p\x03\u7800", // 砀
	0x7801: "p\x03\u7801", // 码
	0x7802: "p\x04\u7802", // 砂
	0x7803: "p\x04\u7803", // 砃
	0x7804: "p\x04\u7804", // 砄
	0x7805: "p\x04\u7805", // 砅
	0x7806: "p\x04\u7806", // 砆
	0x7807: "p\x04\u7807", // 砇
	0x7808: "p\x04\u7808", // 砈
	0x7809: "p\x04\u7809", // 砉
	0x780a: "p\x04\u780a", // 砊
	0x780b: "p\x04\u780b", // 砋
	0x780c: "p\x04\u780c", // 砌
	0x780d: "p\x04\u780d", // 砍
	0x780e: "p\x04\u780e", // 砎
	0x780f: "p\x04\u780f", // 砏
	0x7810: "p\x04\u7810", // 砐
	0x7811: "p\x04\u7811", // 砑
	0x7812: "p\x04\u7812", // 砒
	0x7813: "p\x04\u7813", // 砓
	0x7814: "p\x04\u7814", // 研
	0x7815: "p\x04\u7815", // 砕
	0x7816: "p\x04\u7816", // 砖
	0x7817: "p\x04\u7817", // 砗
	0x7818: "p\x04\u7818", // 砘
	0x7819: "p\x04\u7819", // 砙
	0x781a: "p\x04\u781a", // 砚
	0x781b: "p\x04\u781b", // 砛
	0x781c: "p\x04\u781c", // 砜
	0x781d: "p\x05\u781d", // 砝
	0x781e: "p\x05\u781e", // 砞
	0x781f: "p\x05\u781f", // 砟
	0x7820: "p\x05\u7820", // 砠
	0x7821: "p\x05\u7821", // 砡
	0x7822: "p\x05\u7822", // 砢
	0x7823: "p\x05\u7823", // 砣
	0x7824: "p\x05\u7824", // 砤
	0x7825: "p\x05\u7825", // 砥
	0x7826: "p\x05\u7826", // 砦
	0x7827: "p\x05\u7827", // 砧
	0x7828: "p\x05\u7828", // 砨
	0x7829: "p\x05\u7829", // 砩
	0x782a: "p\x05\u782a", // 砪
	0x782b: "p\x05\u782b", // 砫
	0x782c: "p\x05\u782c", // 砬
	0x782d: "p\x05\u782d", // 砭
	0x782e: "p\x05\u782e", // 砮
	0x782f: "p\x05\u782f", // 砯
	0x7830: "p\x05\u7830", // 砰
	0x7831: "p\x05\u7831", // 砱
	0x7832: "p\x05\u7832", // 砲
	0x7833: "p\x05\u7833", // 砳
	0x7834: "p\x05\u7834", // 破
	0x7835: "p\x05\u7835", // 砵
	0x7836: "p\x05\u7836", // 砶
	0x7837: "p\x05\u7837", // 砷
	0x7838: "p\x05\u7838", // 砸
	0x7839: "p\x05\u7839", // 砹
	0x783a: "p\x05\u783a", // 砺
	0x783b: "p\x05\u783b", // 砻
	0x783c: "p\x05\u783c", // 砼
	0x783d: "p\x05\u783d", // 砽
	0x783e: "p\x05\u783e", // 砾
	0x783f: "p\x05\u783f", // 砿
	0x7840: "p\x05\u7840", // 础
	0x7841: "p\x05\u7841", // 硁
	0x7842: "p\x06\u7842", // 硂
	0x7843: "p\x06\u7843", // 硃
	0x7844: "p\x06\u7844", // 硄
	0x7845: "p\x06\u7845", // 硅
	0x7846: "p\x06\u7846", // 硆
	0x7847: "p\x06\u7847", // 硇
	0x7848: "p\x06\u7848", // 硈
	0x7849: "p\x06\u7849", // 硉
	0x784a: "p\x06\u784a", // 硊
	0x784b: "p\x06\u784b", // 硋
	0x784c: "p\x06\u784c", // 硌
	0x784d: "p\x06\u784d", // 硍
	0x784e: "p\x06\u784e", // 硎
	0x784f: "p\x06\u784f", // 硏
	0x7850: "p\x06\u7850", // 硐
	0x7851: "p\x06\u7851", // 硑
	0x7852: "p\x06\u7852", // 硒
	0x7853: "p\x06\u7853", // 硓
	0x7854: "p\x06\u7854", // 硔
	0x7855: "p\x06\u7855", // 硕
	0x7856: "p\x06\u7856", // 硖
	0x7857: "p\x06\u7857", // 硗
	0x7858: "p\x06\u7858", // 硘
	0x7859: "p\x06\u7859", // 硙
	0x785a: "p\x06\u785a", // 硚
	0x785b: "p\x06\u785b", // 硛
	0x785c: "p\a\u785c", // 硜
	0x785d: "p\a\u785d", // 硝
	0x785e: "p\a\u785e", // 硞
	0x785f: "p\a\u785f", // 硟
	0x7860: "p\a\u7860", // 硠
	0x7861: "p\a\u7861", // 硡
	0x7862: "p\a\u7862", // 硢
	0x7863: "p\a\u7863", // 硣
	0x7864: "p\a\u7864", // 硤
	0x7865: "p\a\u7865", // 硥
	0x7866: "p\a\u7866", // 硦
	0x7867: "p\a\u7867", // 硧
	0x7868: "p\a\u7868", // 硨
	0x7869: "p\a\u7869", // 硩
	0x786a: "p\a\u786a", // 硪
	0x786b: "p\a\u786b", // 硫
	0x786c: "p\a\u786c", // 硬
	0x786d: "p\a\u786d", // 硭
	0x786e: "p\a\u786e", // 确
	0x786f: "p\a\u786f", // 硯
	0x7870: "p\a\u7870", // 硰
	0x7871: "p\a\u7871", // 硱
	0x7872: "p\a\u7872", // 硲
	0x7873: "p\a\u7873", // 硳
	0x7874: "p\a\u7874", // 硴
	0x7875: "p\a\u7875", // 硵
	0x7876: "p\a\u7876", // 硶
	0x7877: "p\a\u7877", // 硷
	0x7878: "p\b\u7878", // 硸
	0x7879: "p\b\u7879", // 硹
	0x787a: "p\b\u787a", // 硺
	0x787b: "p\b\u787b", // 硻
	0x787c: "p\b\u787c", // 硼
	0x787d: "p\b\u787d", // 硽
	0x787e: "p\t\u787e", // 硾
	0x787f: "p\b\u787f", // 硿
	0x7880: "p\b\u7880", // 碀
	0x7881: "p\b\u7881", // 碁
	0x7882: "p\b\u7882", // 碂
	0x7883: "p\b\u7883", // 碃
	0x7884: "p\b\u7884", // 碄
	0x7885: "p\b\u7885", // 碅
	0x7886: "p\b\u7886", // 碆
	0x7887: "p\b\u7887", // 碇
	0x7888: "p\b\u7888", // 碈
	0x7889: "p\b\u7889", // 碉
	0x788a: "p\b\u788a", // 碊
	0x788b: "p\b\u788b", // 碋
	0x788c: "p\b\u788c", // 碌
	0x788d: "p\b\u788d", // 碍
	0x788e: "p\b\u788e", // 碎
	0x788f: "p\b\u788f", // 碏
	0x7890: "p\b\u7890", // 碐
	0x7891: "p\b\u7891", // 碑
	0x7892: "p\b\u7892", // 碒
	0x7893: "p\b\u7893", // 碓
	0x7894: "p\b\u7894", // 碔
	0x7895: "p\b\u7895", // 碕
	0x7896: "p\b\u7896", // 碖
	0x7897: "p\b\u7897", // 碗
	0x7898: "p\b\u7898", // 碘
	0x7899: "p\b\u7899", // 碙
	0x789a: "p\b\u789a", // 碚
	0x789b: "p\b\u789b", // 碛
	0x789c: "p\b\u789c", // 碜
	0x789d: "p\t\u789d", // 碝
	0x789e: "p\t\u789e", // 碞
	0x789f: "p\t\u789f", // 碟
	0x78a0: "p\t\u78a0", // 碠
	0x78a1: "p\t\u78a1", // 碡
	0x78a2: "p\t\u78a2", // 碢
	0x78a3: "p\t\u78a3", // 碣
	0x78a4: "p\t\u78a4", // 碤
	0x78a5: "p\t\u78a5", // 碥
	0x78a6: "p\t\u78a6", // 碦
	0x78a7: "p\t\u78a7", // 碧
	0x78a8: "p\t\u78a8", // 碨
	0x78a9: "p\t\u78a9", // 碩
	0x78aa: "p\t\u78aa", // 碪
	0x78ab: "p\t\u78ab", // 碫
	0x78ac: "p\t\u78ac", // 碬
	0x78ad: "p\t\u78ad", // 碭
	0x78ae: "p\t\u78ae", // 碮
	0x78af: "p\t\u78af", // 碯
	0x78b0: "p\b\u78b0", // 碰
	0x78b1: "p\t\u78b1", // 碱
	0x78b2: "p\t\u78b2", // 碲
	0x78b3: "p\t\u78b3", // 碳
	0x78b4: "p\t\u78b4", // 碴
	0x78b5: "p\t\u78b5", // 碵
	0x78b6: "p\t\u78b6", // 碶
	0x78b7: "p\t\u78b7", // 碷
	0x78b8: "p\t\u78b8", // 碸
	0x78b9: "p\t\u78b9", // 碹
	0x78ba: "p\n\u78ba", // 確
	0x78bb: "p\n\u78bb", // 碻
	0x78bc: "p\n\u78bc", // 碼
	0x78bd: "p\n\u78bd", // 碽
	0x78be: "p\n\u78be", // 碾
	0x78bf: "p\n\u78bf", // 碿
	0x78c0: "p\n\u78c0", // 磀
	0x78c1: "p\t\u78c1", // 磁
	0x78c2: "p\n\u78c2", // 磂
	0x78c3: "p\n\u78c3", // 磃
	0x78c4: "p\n\u78c4", // 磄
	0x78c5: "p\n\u78c5", // 磅
	0x78c6: "p\n\u78c6", // 磆
	0x78c7: "p\n\u78c7", // 磇
	0x78c8: "p\n\u78c8", // 磈
	0x78c9: "p\n\u78c9", // 磉
	0x78ca: "p\n\u78ca", // 磊
	0x78cb: "p\n\u78cb", // 磋
	0x78cc: "p\n\u78cc", // 磌
	0x78cd: "p\n\u78cd", // 磍
	0x78ce: "p\n\u78ce", // 磎
	0x78cf: "p\n\u78cf", // 磏
	0x78d0: "p\n\u78d0", // 磐
	0x78d1: "p\n\u78d1", // 磑
	0x78d2: "p\n\u78d2", // 磒
	0x78d3: "p\n\u78d3", // 磓
	0x78d4: "p\n\u78d4", // 磔
	0x78d5: "p\n\u78d5", // 磕
	0x78d6: "p\n\u78d6", // 磖
	0x78d7: "p\n\u78d7", // 磗
	0x78d8: "p\n\u78d8", // 磘
	0x78d9: "p\n\u78d9", // 磙
	0x78da: "p\v\u78da", // 磚
	0x78db: "p\v\u78db", // 磛
	0x78dc: "p\n\u78dc", // 磜
	0x78dd: "p\v\u78dd", // 磝
	0x78de: "p\v\u78de", // 磞
	0x78df: "p\v\u78df", // 磟
	0x78e0: "p\v\u78e0", // 磠
	0x78e1: "p\v\u78e1", // 磡
	0x78e2: "p\v\u78e2", // 磢
	0x78e3: "p\v\u78e3", // 磣
	0x78e4: "p\n\u78e4", // 磤
	0x78e5: "p\v\u78e5", // 磥
	0x78e6: "p\v\u78e6", // 磦
	0x78e7: "p\v\u78e7", // 磧
	0x78e8: "p\v\u78e8", // 磨
	0x78e9: "p\v\u78e9", // 磩
	0x78ea: "p\v\u78ea", // 磪
	0x78eb: "p\v\u78eb", // 磫
	0x78ec: "p\v\u78ec", // 磬
	0x78ed: "p\v\u78ed", // 磭
	0x78ee: "p\v\u78ee", // 磮
	0x78ef: "p\f\u78ef", // 磯
	0x78f0: "p\f\u78f0", // 磰
	0x78f1: "p\f\u78f1", // 磱
	0x78f2: "p\f\u78f2", // 磲
	0x78f3: "p\f\u78f3", // 磳
	0x78f4: "p\f\u78f4", // 磴
	0x78f5: "p\f\u78f5", // 磵
	0x78f6: "p\f\u78f6", // 磶
	0x78f7: "p\f\u78f7", // 磷
	0x78f8: "p\f\u78f8", // 磸
	0x78f9: "p\f\u78f9", // 磹
	0x78fa: "p\f\u78fa", // 磺
	0x78fb: "p\f\u78fb", // 磻
	0x78fc: "p\f\u78fc", // 磼
	0x78fd: "p\f\u78fd", // 磽
	0x78fe: "p\f\u78fe", // 磾
	0x78ff: "p\f\u78ff", // 磿
	0x7900: "p\f\u7900", // 礀
	0x7901: "p\f\u7901", // 礁
	0x7902: "p\f\u7902", // 礂
	0x7903: "p\f\u7903", // 礃
	0x7904: "p\f\u7904", // 礄
	0x7905: "p\f\u7905", // 礅
	0x7906: "p\r\u7906", // 礆
	0x7907: "p\r\u7907", // 礇
	0x7908: "p\r\u7908", // 礈
	0x7909: "p\r\u7909", // 礉
	0x790a: "p\r\u790a", // 礊
	0x790b: "p\r\u790b", // 礋
	0x790c: "p\r\u790c", // 礌
	0x790d: "p\r\u790d", // 礍
	0x790e: "p\r\u790e", // 礎
	0x790f: "p\r\u790f", // 礏
	0x7910: "p\r\u7910", // 礐
	0x7911: "p\r\u7911", // 礑
	0x7912: "p\r\u7912", // 礒
	0x7913: "p\r\u7913", // 礓
	0x7914: "p\r\u7914", // 礔
	0x7915: "p\r\u7915", // 礕
	0x7916: "p\r\u7916", // 礖
	0x7917: "p\x0e\u7917", // 礗
	0x7918: "p\x0e\u7918", // 礘
	0x7919: "p\x0e\u7919", // 礙
	0x791a: "p\x0e\u791a", // 礚
	0x791b: "p\x0e\u791b", // 礛
	0x791c: "p\x0e\u791c", // 礜
	0x791d: "p\x0e\u791d", // 礝
	0x791e: "p\x0e\u791e", // 礞
	0x791f: "p\x0e\u791f", // 礟
	0x7920: "p\x0e\u7920", // 礠
	0x7921: "p\x0e\u7921", // 礡
	0x7922: "p\x0f\u7922", // 礢
	0x7923: "p\x0f\u7923", // 礣
	0x7924: "p\x0f\u7924", // 礤
	0x7925: "p\x0f\u7925", // 礥
	0x7926: "p\x0f\u7926", // 礦
	0x7927: "p\x0f\u7927", // 礧
	0x7928: "p\x0f\u7928", // 礨
	0x7929: "p\x0f\u7929", // 礩
	0x792a: "p\x0f\u792a", // 礪
	0x792b: "p\x0f\u792b", // 礫
	0x792c: "p\x0f\u792c", // 礬
	0x792d: "p\x10\u792d", // 礭
	0x792e: "p\x10\u792e", // 礮
	0x792f: "p\x10\u792f", // 礯
	0x7930: "p\x10\u7930", // 礰
	0x7931: "p\x10\u7931", // 礱
	0x7932: "p\x10\u7932", // 礲
	0x7933: "p\x10\u7933", // 礳
	0x7934: "p\x10\u7934", // 礴
	0x7935: "p\x11\u7935", // 礵
	0x7936: "p\x12\u7936", // 礶
	0x7937: "p\x12\u7937", // 礷
	0x7938: "p\x13\u7938", // 礸
	0x7939: "p\x14\u7939", // 礹
	0x793a: "q\x00\u793a", // 示
	0x793b: "q\x00\u793b", // 礻
	0x793c: "q\x01\u793c", // 礼
	0x793d: "q\x02\u793d", // 礽
	0x793e: "q\x03\u793e", // 社
	0x793f: "q\x03\u793f", // 礿
	0x7940: "q\x03\u7940", // 祀
	0x7941: "q\x03\u7941", // 祁
	0x7942: "q\x03\u7942", // 祂
	0x7943: "q\x03\u7943", // 祃
	0x7944: "q\x04\u7944", // 祄
	0x7945: "q\x04\u7945", // 祅
	0x7946: "q\x04\u7946", // 祆
	0x7947: "q\x04\u7947", // 祇
	0x7948: "q\x04\u7948", // 祈
	0x7949: "q\x04\u7949", // 祉
	0x794a: "q\x04\u794a", // 祊
	0x794b: "q\x04\u794b", // 祋
	0x794c: "q\x04\u794c", // 祌
	0x794d: "q\x04\u794d", // 祍
	0x794e: "q\x04\u794e", // 祎
	0x794f: "q\x05\u794f", // 祏
	0x7950: "q\x05\u7950", // 祐
	0x7951: "q\x05\u7951", // 祑
	0x7952: "q\x05\u7952", // 祒
	0x7953: "q\x05\u7953", // 祓
	0x7954: "q\x05\u7954", // 祔
	0x7955: "q\x05\u7955", // 祕
	0x7956: "q\x05\u7956", // 祖
	0x7957: "q\x05\u7957", // 祗
	0x7958: "q\x05\u7958", // 祘
	0x7959: "q\x05\u7959", // 祙
	0x795a: "q\x05\u795a", // 祚
	0x795b: "q\x05\u795b", // 祛
	0x795c: "q\x05\u795c", // 祜
	0x795d: "q\x05\u795d", // 祝
	0x795e: "q\x05\u795e", // 神
	0x795f: "q\x05\u795f", // 祟
	0x7960: "q\x05\u7960", // 祠
	0x7961: "q\x05\u7961", // 祡
	0x7962: "q\x05\u7962", // 祢
	0x7963: "q\x06\u7963", // 祣
	0x7964: "q\x06\u7964", // 祤
	0x7965: "q\x06\u7965", // 祥
	0x7966: "q\a\u7966", // 祦
	0x7967: "q\x06\u7967", // 祧
	0x7968: "q\x06\u7968", // 票
	0x7969: "q\x06\u7969", // 祩
	0x796a: "q\x06\u796a", // 祪
	0x796b: "q\x06\u796b", // 祫
	0x796c: "q\x06\u796c", // 祬
	0x796d: "q\x06\u796d", // 祭
	0x796e: "q\x06\u796e", // 祮
	0x796f: "q\x06\u796f", // 祯
	0x7970: "q\a\u7970", // 祰
	0x7971: "q\a\u7971", // 祱
	0x7972: "q\a\u7972", // 祲
	0x7973: "q\a\u7973", // 祳
	0x7974: "q\a\u7974", // 祴
	0x7975: "q\a\u7975", // 祵
	0x7976: "q\a\u7976", // 祶
	0x7977: "q\a\u7977", // 祷
	0x7978: "q\a\u7978", // 祸
	0x7979: "q\b\u7979", // 祹
	0x797a: "q\b\u797a", // 祺
	0x797b: "q\b\u797b", // 祻
	0x797c: "q\b\u797c", // 祼
	0x797d: "q\b\u797d", // 祽
	0x797e: "q\b\u797e", // 祾
	0x797f: "q\b\u797f", // 祿
	0x7980: "q\b\u7980", // 禀
	0x7981: "q\b\u7981", // 禁
	0x7982: "q\b\u7982", // 禂
	0x7983: "q\b\u7983", // 禃
	0x7984: "q\a\u7984", // 禄
	0x7985: "q\b\u7985", // 禅
	0x7986: "q\b\u7986", // 禆
	0x7987: "q\t\u7987", // 禇
	0x7988: "q\t\u7988", // 禈
	0x7989: "q\t\u7989", // 禉
	0x798a: "q\t\u798a", // 禊
	0x798b: "q\t\u798b", // 禋
	0x798c: "q\t\u798c", // 禌
	0x798d: "q\t\u798d", // 禍
	0x798e: "q\t\u798e", // 禎
	0x798f: "q\t\u798f", // 福
	0x7990: "q\t\u7990", // 禐
	0x7991: "q\t\u7991", // 禑
	0x7992: "q\t\u7992", // 禒
	0x7993: "q\t\u7993", // 禓
	0x7994: "q\t\u7994", // 禔
	0x7995: "q\t\u7995", // 禕
	0x7996: "q\t\u7996", // 禖
	0x7997: "q\t\u7997", // 禗
	0x7998: "q\t\u7998", // 禘
	0x7999: "q\t\u7999", // 禙
	0x799a: "q\n\u799a", // 禚
	0x799b: "q\n\u799b", // 禛
	0x799c: "q\n\u799c", // 禜
	0x799d: "q\n\u799d", // 禝
	0x799e: "q\n\u799e", // 禞
	0x799f: "q\n\u799f", // 禟
	0x79a0: "q\n\u79a0", // 禠
	0x79a1: "q\n\u79a1", // 禡
	0x79a2: "q\n\u79a2", // 禢
	0x79a3: "q\n\u79a3", // 禣
	0x79a4: "q\v\u79a4", // 禤
	0x79a5: "q\v\u79a5", // 禥
	0x79a6: "q\v\u79a6", // 禦
	0x79a7: "q\f\u79a7", // 禧
	0x79a8: "q\f\u79a8", // 禨
	0x79a9: "q\f\u79a9", // 禩
	0x79aa: "q\f\u79aa", // 禪
	0x79ab: "q\f\u79ab", // 禫
	0x79ac: "q\r\u79ac", // 禬
	0x79ad: "q\r\u79ad", // 禭
	0x79ae: "q\r\u79ae", // 禮
	0x79af: "q\r\u79af", // 禯
	0x79b0: "q\x0e\u79b0", // 禰
	0x79b1: "q\x0e\u79b1", // 禱
	0x79b2: "q\x0f\u79b2", // 禲
	0x79b3: "q\x11\u79b3", // 禳
	0x79b4: "q\x11\u79b4", // 禴
	0x79b5: "q\x12\u79b5", // 禵
	0x79b6: "q\x13\u79b6", // 禶
	0x79b7: "q\x13\u79b7", // 禷
	0x79b8: "r\x00\u79b8", // 禸
	0x79b9: "r\x04\u79b9", // 禹
	0x79ba: "r\x04\u79ba", // 禺
	0x79bb: "r\x06\u79bb", // 离
	0x79bc: "r\a\u79bc", // 禼
	0x79bd: "r\b\u79bd", // 禽
	0x79be: "s\x00\u79be", // 禾
	0x79bf: "s\x02\u79bf", // 禿
	0x79c0: "s\x02\u79c0", // 秀
	0x79c1: "s\x02\u79c1", // 私
	0x79c2: "s\x02\u79c2", // 秂
	0x79c3: "s\x02\u79c3", // 秃
	0x79c4: "s\x03\u79c4", // 秄
	0x79c5: "s\x03\u79c5", // 秅
	0x79c6: "s\x03\u79c6", // 秆
	0x79c7: "s\x03\u79c7", // 秇
	0x79c8: "s\x03\u79c8", // 秈
	0x79c9: "s\x03\u79c9", // 秉
	0x79ca: "s\x03\u79ca", // 秊
	0x79cb: "s\x04\u79cb", // 秋
	0x79cc: "s\x04\u79cc", // 秌
	0x79cd: "s\x04\u79cd", // 种
	0x79ce: "s\x04\u79ce", // 秎
	0x79cf: "s\x04\u79cf", // 秏
	0x79d0: "s\x04\u79d0", // 秐
	0x79d1: "s\x04\u79d1", // 科
	0x79d2: "s\x04\u79d2", // 秒
	0x79d3: "s\x04\u79d3", // 秓
	0x79d4: "s\x04\u79d4", // 秔
	0x79d5: "s\x04\u79d5", // 秕
	0x79d6: "s\x04\u79d6", // 秖
	0x79d7: "s\x04\u79d7", // 秗
	0x79d8: "s\x05\u79d8", // 秘
	0x79d9: "s\x05\u79d9", // 秙
	0x79da: "s\x05\u79da", // 秚
	0x79db: "s\x05\u79db", // 秛
	0x79dc: "s\x05\u79dc", // 秜
	0x79dd: "s\x05\u79dd", // 秝
	0x79de: "s\x05\u79de", // 秞
	0x79df: "s\x05\u79df", // 租
	0x79e0: "s\x05\u79e0", // 秠
	0x79e1: "s\x05\u79e1", // 秡
	0x79e2: "s\x05\u79e2", // 秢
	0x79e3: "s\x05\u79e3", // 秣
	0x79e4: "s\x05\u79e4", // 秤
	0x79e5: "s\x05\u79e5", // 秥
	0x79e6: "s\x05\u79e6", // 秦
	0x79e7: "s\x05\u79e7", // 秧
	0x79e8: "s\x05\u79e8", // 秨
	0x79e9: "s\x05\u79e9", // 秩
	0x79ea: "s\x05\u79ea", // 秪
	0x79eb: "s\x05\u79eb", // 秫
	0x79ec: "s\x05\u79ec", // 秬
	0x79ed: "s\x05\u79ed", // 秭
	0x79ee: "s\x05\u79ee", // 秮
	0x79ef: "s\x05\u79ef", // 积
	0x79f0: "s\x05\u79f0", // 称
	0x79f1: "s\x06\u79f1", // 秱
	0x79f2: "s\x06\u79f2", // 秲
	0x79f3: "s\x06\u79f3", // 秳
	0x79f4: "s\x06\u79f4", // 秴
	0x79f5: "s\x06\u79f5", // 秵
	0x79f6: "s\x06\u79f6", // 秶
	0x79f7: "s\x06\u79f7", // 秷
	0x79f8: "s\x06\u79f8", // 秸
	0x79f9: "s\x06\u79f9", // 秹
	0x79fa: "s\x06\u79fa", // 秺
	0x79fb: "s\x06\u79fb", // 移
	0x79fc: "s\x06\u79fc", // 秼
	0x79fd: "s\x06\u79fd", // 秽
	0x79fe: "s\x06\u79fe", // 秾
	0x79ff: "s\a\u79ff", // 秿
	0x7a00: "s\a\u7a00", // 稀
	0x7a01: "s\a\u7a01", // 稁
	0x7a02: "s\a\u7a02", // 稂
	0x7a03: "s\a\u7a03", // 稃
	0x7a04: "s\a\u7a04", // 稄
	0x7a05: "s\a\u7a05", // 稅
	0x7a06: "s\x06\u7a06", // 稆
	0x7a07: "s\a\u7a07", // 稇
	0x7a08: "s\a\u7a08", // 稈
	0x7a09: "s\a\u7a09", // 稉
	0x7a0a: "s\a\u7a0a", // 稊
	0x7a0b: "s\a\u7a0b", // 程
	0x7a0c: "s\a\u7a0c", // 稌
	0x7a0d: "s\a\u7a0d", // 稍
	0x7a0e: "s\a\u7a0e", // 税
	0x7a0f: "s\b\u7a0f", // 稏
	0x7a10: "s\b\u7a10", // 稐
	0x7a11: "s\b\u7a11", // 稑
	0x7a12: "s\b\u7a12", // 稒
	0x7a13: "s\b\u7a13", // 稓
	0x7a14: "s\b\u7a14", // 稔
	0x7a15: "s\b\u7a15", // 稕
	0x7a16: "s\b\u7a16", // 稖
	0x7a17: "s\b\u7a17", // 稗
	0x7a18: "s\b\u7a18", // 稘
	0x7a19: "s\b\u7a19", // 稙
	0x7a1a: "s\b\u7a1a", // 稚
	0x7a1b: "s\b\u7a1b", // 稛
	0x7a1c: "s\b\u7a1c", // 稜
	0x7a1d: "s\b\u7a1d", // 稝
	0x7a1e: "s\b\u7a1e", // 稞
	0x7a1f: "s\b\u7a1f", // 稟
	0x7a20: "s\b\u7a20", // 稠
	0x7a21: "s\b\u7a21", // 稡
	0x7a22: "s\b\u7a22", // 稢
	0x7a23: "s\b\u7a23", // 稣
	0x7a24: "s\b\u7a24", // 稤
	0x7a25: "s\b\u7a25", // 稥
	0x7a26: "s\t\u7a26", // 稦
	0x7a27: "s\t\u7a27", // 稧
	0x7a28: "s\t\u7a28", // 稨
	0x7a29: "s\t\u7a29", // 稩
	0x7a2a: "s\t\u7a2a", // 稪
	0x7a2b: "s\t\u7a2b", // 稫
	0x7a2c: "s\t\u7a2c", // 稬
	0x7a2d: "s\t\u7a2d", // 稭
	0x7a2e: "s\t\u7a2e", // 種
	0x7a2f: "s\t\u7a2f", // 稯
	0x7a30: "s\t\u7a30", // 稰
	0x7a31: "s\t\u7a31", // 稱
	0x7a32: "s\t\u7a32", // 稲
	0x7a33: "s\t\u7a33", // 稳
	0x7a34: "s\n\u7a34", // 稴
	0x7a35: "s\n\u7a35", // 稵
	0x7a36: "s\n\u7a36", // 稶
	0x7a37: "s\n\u7a37", // 稷
	0x7a38: "s\n\u7a38", // 稸
	0x7a39: "s\n\u7a39", // 稹
	0x7a3a: "s\n\u7a3a", // 稺
	0x7a3b: "s\n\u7a3b", // 稻
	0x7a3c: "s\n\u7a3c", // 稼
	0x7a3d: "s\n\u7a3d", // 稽
	0x7a3e: "s\n\u7a3e", // 稾
	0x7a3f: "s\n\u7a3f", // 稿
	0x7a40: "s\n\u7a40", // 穀
	0x7a41: "s\n\u7a41", // 穁
	0x7a42: "s\n\u7a42", // 穂
	0x7a43: "s\n\u7a43", // 穃
	0x7a44: "s\v\u7a44", // 穄
	0x7a45: "s\v\u7a45", // 穅
	0x7a46: "s\v\u7a46", // 穆
	0x7a47: "s\v\u7a47", // 穇
	0x7a48: "s\v\u7a48", // 穈
	0x7a49: "s\f\u7a49", // 穉
	0x7a4a: "s\t\u7a4a", // 穊
	0x7a4b: "s\v\u7a4b", // 穋
	0x7a4c: "s\v\u7a4c", // 穌
	0x7a4d: "s\v\u7a4d", // 積
	0x7a4e: "s\v\u7a4e", // 穎
	0x7a4f: "s\v\u7a4f", // 穏
	0x7a50: "s\v\u7a50", // 穐
	0x7a51: "s\v\u7a51", // 穑
	0x7a52: "s\v\u7a52", // 穒
	0x7a53: "s\f\u7a53", // 穓
	0x7a54: "s\f\u7a54", // 穔
	0x7a55: "s\f\u7a55", // 穕
	0x7a56: "s\f\u7a56", // 穖
	0x7a57: "s\f\u7a57", // 穗
	0x7a58: "s\f\u7a58", // 穘
	0x7a59: "s\f\u7a59", // 穙
	0x7a5a: "s\f\u7a5a", // 穚
	0x7a5b: "s\f\u7a5b", // 穛
	0x7a5c: "s\f\u7a5c", // 穜
	0x7a5d: "s\f\u7a5d", // 穝
	0x7a5e: "s\f\u7a5e", // 穞
	0x7a5f: "s\r\u7a5f", // 穟
	0x7a60: "s\r\u7a60", // 穠
	0x7a61: "s\r\u7a61", // 穡
	0x7a62: "s\r\u7a62", // 穢
	0x7a63: "s\r\u7a63", // 穣
	0x7a64: "s\x0e\u7a64", // 穤
	0x7a65: "s\x0e\u7a65", // 穥
	0x7a66: "s\x0e\u7a66", // 穦
	0x7a67: "s\x0e\u7a67", // 穧
	0x7a68: "s\x0e\u7a68", // 穨
	0x7a69: "s\x0e\u7a69", // 穩
	0x7a6a: "s\x0e\u7a6a", // 穪
	0x7a6b: "s\x0e\u7a6b", // 穫
	0x7a6c: "s\x0f\u7a6c", // 穬
	0x7a6d: "s\x0f\u7a6d", // 穭
	0x7a6e: "s\x0f\u7a6e", // 穮
	0x7a6f: "s\x0f\u7a6f", // 穯
	0x7a70: "s\x11\u7a70", // 穰
	0x7a71: "s\x12\u7a71", // 穱
	0x7a72: "s\x13\u7a72", // 穲
	0x7a73: "s\x11\u7a73", // 穳
	0x7a74: "t\x00\u7a74", // 穴
	0x7a75: "t\x01\u7a75", // 穵
	0x7a76: "t\x02\u7a76", // 究
	0x7a77: "t\x02\u7a77", // 穷
	0x7a78: "t\x03\u7a78", // 穸
	0x7a79: "t\x03\u7a79", // 穹
	0x7a7a: "t\x03\u7a7a", // 空
	0x7a7b: "t\x03\u7a7b", // 穻
	0x7a7c: "t\x04\u7a7c", // 穼
	0x7a7d: "t\x04\u7a7d", // 穽
	0x7a7e: "t\x04\u7a7e", // 穾
	0x7a7f: "t\x04\u7a7f", // 穿
	0x7a80: "t\x04\u7a80", // 窀
	0x7a81: "t\x04\u7a81", // 突
	0x7a82: "t\x04\u7a82", // 窂
	0x7a83: "t\x04\u7a83", // 窃
	0x7a84: "t\x05\u7a84", // 窄
	0x7a85: "t\x05\u7a85", // 窅
	0x7a86: "t\x05\u7a86", // 窆
	0x7a87: "t\x05\u7a87", // 窇
	0x7a88: "t\x05\u7a88", // 窈
	0x7a89: "t\x05\u7a89", // 窉
	0x7a8a: "t\x05\u7a8a", // 窊
	0x7a8b: "t\x05\u7a8b", // 窋
	0x7a8c: "t\x05\u7a8c", // 窌
	0x7a8d: "t\x05\u7a8d", // 窍
	0x7a8e: "t\x05\u7a8e", // 窎
	0x7a8f: "t\x06\u7a8f", // 窏
	0x7a90: "t\x06\u7a90", // 窐
	0x7a91: "t\x06\u7a91", // 窑
	0x7a92: "t\x06\u7a92", // 窒
	0x7a93: "t\x06\u7a93", // 窓
	0x7a94: "t\x06\u7a94", // 窔
	0x7a95: "t\x06\u7a95", // 窕
	0x7a96: "t\a\u7a96", // 窖
	0x7a97: "t\a\u7a97", // 窗
	0x7a98: "t\a\u7a98", // 窘
	0x7a99: "t\a\u7a99", // 窙
	0x7a9a: "t\a\u7a9a", // 窚
	0x7a9b: "t\a\u7a9b", // 窛
	0x7a9c: "t\a\u7a9c", // 窜
	0x7a9d: "t\a\u7a9d", // 窝
	0x7a9e: "t\b\u7a9e", // 窞
	0x7a9f: "t\b\u7a9f", // 窟
	0x7aa0: "t\b\u7aa0", // 窠
	0x7aa1: "t\b\u7aa1", // 窡
	0x7aa2: "t\b\u7aa2", // 窢
	0x7aa3: "t\b\u7aa3", // 窣
	0x7aa4: "t\b\u7aa4", // 窤
	0x7aa5: "t\b\u7aa5", // 窥
	0x7aa6: "t\b\u7aa6", // 窦
	0x7aa7: "t\b\u7aa7", // 窧
	0x7aa8: "t\t\u7aa8", // 窨
	0x7aa9: "t\t\u7aa9", // 窩
	0x7aaa: "t\t\u7aaa", // 窪
	0x7aab: "t\t\u7aab", // 窫
	0x7aac: "t\t\u7aac", // 窬
	0x7aad: "t\t\u7aad", // 窭
	0x7aae: "t\n\u7aae", // 窮
	0x7aaf: "t\n\u7aaf", // 窯
	0x7ab0: "t\n\u7ab0", // 窰
	0x7ab1: "t\n\u7ab1", // 窱
	0x7ab2: "t\n\u7ab2", // 窲
	0x7ab3: "t\n\u7ab3", // 窳
	0x7ab4: "t\n\u7ab4", // 窴
	0x7ab5: "t\v\u7ab5", // 窵
	0x7ab6: "t\v\u7ab6", // 窶
	0x7ab7: "t\v\u7ab7", // 窷
	0x7ab8: "t\v\u7ab8", // 窸
	0x7ab9: "t\v\u7ab9", // 窹
	0x7aba: "t\v\u7aba", // 窺
	0x7abb: "t\v\u7abb", // 窻
	0x7abc: "t\v\u7abc", // 窼
	0x7abd: "t\v\u7abd", // 窽
	0x7abe: "t\f\u7abe", // 窾
	0x7abf: "t\f\u7abf", // 窿
	0x7ac0: "t\f\u7ac0", // 竀
	0x7ac1: "t\f\u7ac1", // 竁
	0x7ac2: "t\f\u7ac2", // 竂
	0x7ac3: "t\f\u7ac3", // 竃
	0x7ac4: "t\r\u7ac4", // 竄
	0x7ac5: "t\r\u7ac5", // 竅
	0x7ac6: "t\x0e\u7ac6", // 竆
	0x7ac7: "t\x0f\u7ac7", // 竇
	0x7ac8: "t\x10\u7ac8", // 竈
	0x7ac9: "t\x10\u7ac9", // 竉
	0x7aca: "t\x11\u7aca", // 竊
	0x7acb: "u\x00\u7acb", // 立
	0x7acc: "u\x02\u7acc", // 竌
	0x7acd: "u\x02\u7acd", // 竍
	0x7ace: "u\x03\u7ace", // 竎
	0x7acf: "u\x03\u7acf", // 竏
	0x7ad0: "u\x04\u7ad0", // 竐
	0x7ad1: "u\x04\u7ad1", // 竑
	0x7ad2: "u\x04\u7ad2", // 竒
	0x7ad3: "u\x04\u7ad3", // 竓
	0x7ad4: "u\x04\u7ad4", // 竔
	0x7ad5: "u\x04\u7ad5", // 竕
	0x7ad6: "u\x04\u7ad6", // 竖
	0x7ad7: "u\x04\u7ad7", // 竗
	0x7ad8: "u\x05\u7ad8", // 竘
	0x7ad9: "u\x05\u7ad9", // 站
	0x7ada: "u\x05\u7ada", // 竚
	0x7adb: "u\x05\u7adb", // 竛
	0x7adc: "u\x05\u7adc", // 竜
	0x7add: "u\x05\u7add", // 竝
	0x7ade: "u\x05\u7ade", // 竞
	0x7adf: "\xb4\x02\u7adf", // 竟
	0x7ae0: "\xb4\x02\u7ae0", // 章
	0x7ae1: "u\x06\u7ae1", // 竡
	0x7ae2: "u\a\u7ae2", // 竢
	0x7ae3: "u\a\u7ae3", // 竣
	0x7ae4: "u\a\u7ae4", // 竤
	0x7ae5: "u\a\u7ae5", // 童
	0x7ae6: "u\a\u7ae6", // 竦
	0x7ae7: "u\a\u7ae7", // 竧
	0x7ae8: "u\b\u7ae8", // 竨
	0x7ae9: "u\b\u7ae9", // 竩
	0x7aea: "u\b\u7aea", // 竪
	0x7aeb: "u\b\u7aeb", // 竫
	0x7aec: "u\t\u7aec", // 竬
	0x7aed: "u\t\u7aed", // 竭
	0x7aee: "u\v\u7aee", // 竮
	0x7aef: "u\t\u7aef", // 端
	0x7af0: "u\t\u7af0", // 竰
	0x7af1: "u\v\u7af1", // 竱
	0x7af2: "u\f\u7af2", // 竲
	0x7af3: "u\f\u7af3", // 竳
	0x7af4: "u\f\u7af4", // 竴
	0x7af5: "u\r\u7af5", // 竵
	0x7af6: "u\x0f\u7af6", // 競
	0x7af7: "u\x0f\u7af7", // 竷
	0x7af8: "u\x11\u7af8", // 竸
	0x7af9: "v\x00\u7af9", // 竹
	0x7afa: "v\x02\u7afa", // 竺
	0x7afb: "v\x02\u7afb", // 竻
	0x7afc: "v\x03\u7afc", // 竼
	0x7afd: "v\x03\u7afd", // 竽
	0x7afe: "v\x03\u7afe", // 竾
	0x7aff: "v\x03\u7aff", // 竿
	0x7b00: "v\x03\u7b00", // 笀
	0x7b01: "v\x03\u7b01", // 笁
	0x7b02: "v\x03\u7b02", // 笂
	0x7b03: "v\x03\u7b03", // 笃
	0x7b04: "v\x06\u7b04", // 笄
	0x7b05: "v\x04\u7b05", // 笅
	0x7b06: "v\x04\u7b06", // 笆
	0x7b07: "v\x04\u7b07", // 笇
	0x7b08: "v\x04\u7b08", // 笈
	0x7b09: "v\x04\u7b09", // 笉
	0x7b0a: "v\x04\u7b0a", // 笊
	0x7b0b: "v\x04\u7b0b", // 笋
	0x7b0c: "v\x04\u7b0c", // 笌
	0x7b0d: "v\x04\u7b0d", // 笍
	0x7b0e: "v\x04\u7b0e", // 笎
	0x7b0f: "v\x04\u7b0f", // 笏
	0x7b10: "v\x04\u7b10", // 笐
	0x7b11: "v\x04\u7b11", // 笑
	0x7b12: "v\x04\u7b12", // 笒
	0x7b13: "v\x04\u7b13", // 笓
	0x7b14: "v\x04\u7b14", // 笔
	0x7b15: "v\x04\u7b15", // 笕
	0x7b16: "v\x05\u7b16", // 笖
	0x7b17: "v\x05\u7b17", // 笗
	0x7b18: "v\x05\u7b18", // 笘
	0x7b19: "v\x05\u7b19", // 笙
	0x7b1a: "v\x05\u7b1a", // 笚
	0x7b1b: "v\x05\u7b1b", // 笛
	0x7b1c: "v\x05\u7b1c", // 笜
	0x7b1d: "v\x05\u7b1d", // 笝
	0x7b1e: "v\x05\u7b1e", // 笞
	0x7b1f: "v\x05\u7b1f", // 笟
	0x7b20: "v\x05\u7b20", // 笠
	0x7b21: "v\x05\u7b21", // 笡
	0x7b22: "v\x05\u7b22", // 笢
	0x7b23: "v\x05\u7b23", // 笣
	0x7b24: "v\x05\u7b24", // 笤
	0x7b25: "v\x05\u7b25", // 笥
	0x7b26: "v\x05\u7b26", // 符
	0x7b27: "v\x05\u7b27", // 笧
	0x7b28: "v\x05\u7b28", // 笨
	0x7b29: "v\x05\u7b29", // 笩
	0x7b2a: "v\x05\u7b2a", // 笪
	0x7b2b: "v\x05\u7b2b", // 笫
	0x7b2c: "v\x05\u7b2c", // 第
	0x7b2d: "v\x05\u7b2d", // 笭
	0x7b2e: "v\x05\u7b2e", // 笮
	0x7b2f: "v\x05\u7b2f", // 笯
	0x7b30: "v\x05\u7b30", // 笰
	0x7b31: "v\x05\u7b31", // 笱
	0x7b32: "v\x05\u7b32", // 笲
	0x7b33: "v\x05\u7b33", // 笳
	0x7b34: "v\x05\u7b34", // 笴
	0x7b35: "v\x05\u7b35", // 笵
	0x7b36: "v\x05\u7b36", // 笶
	0x7b37: "v\x05\u7b37", // 笷
	0x7b38: "v\x05\u7b38", // 笸
	0x7b39: "v\x05\u7b39", // 笹
	0x7b3a: "v\x05\u7b3a", // 笺
	0x7b3b: "v\x05\u7b3b", // 笻
	0x7b3c: "v\x05\u7b3c", // 笼
	0x7b3d: "v\x05\u7b3d", // 笽
	0x7b3e: "v\x05\u7b3e", // 笾
	0x7b3f: "v\x06\u7b3f", // 笿
	0x7b40: "v\x06\u7b40", // 筀
	0x7b41: "v\x06\u7b41", // 筁
	0x7b42: "v\x06\u7b42", // 筂
	0x7b43: "v\x06\u7b43", // 筃
	0x7b44: "v\x06\u7b44", // 筄
	0x7b45: "v\x06\u7b45", // 筅
	0x7b46: "v\x06\u7b46", // 筆
	0x7b47: "v\x06\u7b47", // 筇
	0x7b48: "v\x06\u7b48", // 筈
	0x7b49: "v\x06\u7b49", // 等
	0x7b4a: "v\x06\u7b4a", // 筊
	0x7b4b: "v\x06\u7b4b", // 筋
	0x7b4c: "v\x06\u7b4c", // 筌
	0x7b4d: "v\x06\u7b4d", // 筍
	0x7b4e: "v\x06\u7b4e", // 筎
	0x7b4f: "v\x06\u7b4f", // 筏
	0x7b50: "v\x06\u7b50", // 筐
	0x7b51: "v\x06\u7b51", // 筑
	0x7b52: "v\x06\u7b52", // 筒
	0x7b53: "v\x06\u7b53", // 筓
	0x7b54: "v\x06\u7b54", // 答
	0x7b55: "v\x06\u7b55", // 筕
	0x7b56: "v\x06\u7b56", // 策
	0x7b57: "v\x06\u7b57", // 筗
	0x7b58: "v\x06\u7b58", // 筘
	0x7b59: "v\x06\u7b59", // 筙
	0x7b5a: "v\x06\u7b5a", // 筚
	0x7b5b: "v\x06\u7b5b", // 筛
	0x7b5c: "v\x06\u7b5c", // 筜
	0x7b5d: "v\x06\u7b5d", // 筝
	0x7b5e: "v\a\u7b5e", // 筞
	0x7b5f: "v\a\u7b5f", // 筟
	0x7b60: "v\a\u7b60", // 筠
	0x7b61: "v\a\u7b61", // 筡
	0x7b62: "v\a\u7b62", // 筢
	0x7b63: "v\a\u7b63", // 筣
	0x7b64: "v\a\u7b64", // 筤
	0x7b65: "v\a\u7b65", // 筥
	0x7b66: "v\a\u7b66", // 筦
	0x7b67: "v\a\u7b67", // 筧
	0x7b68: "v\a\u7b68", // 筨
	0x7b69: "v\a\u7b69", // 筩
	0x7b6a: "v\a\u7b6a", // 筪
	0x7b6b: "v\a\u7b6b", // 筫
	0x7b6c: "v\a\u7b6c", // 筬
	0x7b6d: "v\a\u7b6d", // 筭
	0x7b6e: "v\a\u7b6e", // 筮
	0x7b6f: "v\a\u7b6f", // 筯
	0x7b70: "v\a\u7b70", // 筰
	0x7b71: "v\a\u7b71", // 筱
	0x7b72: "v\a\u7b72", // 筲
	0x7b73: "v\a\u7b73", // 筳
	0x7b74: "v\a\u7b74", // 筴
	0x7b75: "v\a\u7b75", // 筵
	0x7b76: "v\a\u7b76", // 筶
	0x7b77: "v\a\u7b77", // 筷
	0x7b78: "v\a\u7b78", // 筸
	0x7b79: "v\a\u7b79", // 筹
	0x7b7a: "v\a\u7b7a", // 筺
	0x7b7b: "v\a\u7b7b", // 筻
	0x7b7c: "v\a\u7b7c", // 筼
	0x7b7d: "v\a\u7b7d", // 筽
	0x7b7e: "v\a\u7b7e", // 签
	0x7b7f: "v\a\u7b7f", // 筿
	0x7b80: "v\a\u7b80", // 简
	0x7b81: "v\b\u7b81", // 箁
	0x7b82: "v\b\u7b82", // 箂
	0x7b83: "v\b\u7b83", // 箃
	0x7b84: "v\b\u7b84", // 箄
	0x7b85: "v\b\u7b85", // 箅
	0x7b86: "v\b\u7b86", // 箆
	0x7b87: "v\b\u7b87", // 箇
	0x7b88: "v\b\u7b88", // 箈
	0x7b89: "v\b\u7b89", // 箉
	0x7b8a: "v\b\u7b8a", // 箊
	0x7b8b: "v\b\u7b8b", // 箋
	0x7b8c: "v\b\u7b8c", // 箌
	0x7b8d: "v\b\u7b8d", // 箍
	0x7b8e: "v\b\u7b8e", // 箎
	0x7b8f: "v\b\u7b8f", // 箏
	0x7b90: "v\b\u7b90", // 箐
	0x7b91: "v\b\u7b91", // 箑
	0x7b92: "v\b\u7b92", // 箒
	0x7b93: "v\b\u7b93", // 箓
	0x7b94: "v\b\u7b94", // 箔
	0x7b95: "v\b\u7b95", // 箕
	0x7b96: "v\b\u7b96", // 箖
	0x7b97: "v\b\u7b97", // 算
	0x7b98: "v\b\u7b98", // 箘
	0x7b99: "v\b\u7b99", // 箙
	0x7b9a: "v\b\u7b9a", // 箚
	0x7b9b: "v\b\u7b9b", // 箛
	0x7b9c: "v\b\u7b9c", // 箜
	0x7b9d: "v\b\u7b9d", // 箝
	0x7b9e: "v\b\u7b9e", // 箞
	0x7b9f: "v\b\u7b9f", // 箟
	0x7ba0: "v\b\u7ba0", // 箠
	0x7ba1: "v\b\u7ba1", // 管
	0x7ba2: "v\b\u7ba2", // 箢
	0x7ba3: "v\b\u7ba3", // 箣
	0x7ba4: "v\b\u7ba4", // 箤
	0x7ba5: "v\b\u7ba5", // 箥
	0x7ba6: "v\b\u7ba6", // 箦
	0x7ba7: "v\b\u7ba7", // 箧
	0x7ba8: "v\b\u7ba8", // 箨
	0x7ba9: "v\b\u7ba9", // 箩
	0x7baa: "v\b\u7baa", // 箪
	0x7bab: "v\b\u7bab", // 箫
	0x7bac: "v\t\u7bac", // 箬
	0x7bad: "v\t\u7bad", // 箭
	0x7bae: "v\t\u7bae", // 箮
	0x7baf: "v\t\u7baf", // 箯
	0x7bb0: "v\t\u7bb0", // 箰
	0x7bb1: "v\t\u7bb1", // 箱
	0x7bb2: "v\t\u7bb2", // 箲
	0x7bb3: "v\t\u7bb3", // 箳
	0x7bb4: "v\t\u7bb4", // 箴
	0x7bb5: "v\t\u7bb5", // 箵
	0x7bb6: "v\t\u7bb6", // 箶
	0x7bb7: "v\t\u7bb7", // 箷
	0x7bb8: "v\t\u7bb8", // 箸
	0x7bb9: "v\t\u7bb9", // 箹
	0x7bba: "v\t\u7bba", // 箺
	0x7bbb: "v\t\u7bbb", // 箻
	0x7bbc: "v\t\u7bbc", // 箼
	0x7bbd: "v\t\u7bbd", // 箽
	0x7bbe: "v\t\u7bbe", // 箾
	0x7bbf: "v\t\u7bbf", // 箿
	0x7bc0: "v\a\u7bc0", // 節
	0x7bc1: "v\t\u7bc1", // 篁
	0x7bc2: "v\t\u7bc2", // 篂
	0x7bc3: "v\t\u7bc3", // 篃
	0x7bc4: "v\t\u7bc4", // 範
	0x7bc5: "v\t\u7bc5", // 篅
	0x7bc6: "v\t\u7bc6", // 篆
	0x7bc7: "v\t\u7bc7", // 篇
	0x7bc8: "v\t\u7bc8", // 篈
	0x7bc9: "v\n\u7bc9", // 築
	0x7bca: "v\t\u7bca", // 篊
	0x7bcb: "v\t\u7bcb", // 篋
	0x7bcc: "v\t\u7bcc", // 篌
	0x7bcd: "v\t\u7bcd", // 篍
	0x7bce: "v\t\u7bce", // 篎
	0x7bcf: "v\t\u7bcf", // 篏
	0x7bd0: "v\t\u7bd0", // 篐
	0x7bd1: "v\t\u7bd1", // 篑
	0x7bd2: "v\t\u7bd2", // 篒
	0x7bd3: "v\t\u7bd3", // 篓
	0x7bd4: "v\n\u7bd4", // 篔
	0x7bd5: "v\n\u7bd5", // 篕
	0x7bd6: "v\n\u7bd6", // 篖
	0x7bd7: "v\n\u7bd7", // 篗
	0x7bd8: "v\n\u7bd8", // 篘
	0x7bd9: "v\n\u7bd9", // 篙
	0x7bda: "v\n\u7bda", // 篚
	0x7bdb: "v\n\u7bdb", // 篛
	0x7bdc: "v\n\u7bdc", // 篜
	0x7bdd: "v\n\u7bdd", // 篝
	0x7bde: "v\n\u7bde", // 篞
	0x7bdf: "v\n\u7bdf", // 篟
	0x7be0: "v\n\u7be0", // 篠
	0x7be1: "v\n\u7be1", // 篡
	0x7be2: "v\n\u7be2", // 篢
	0x7be3: "v\n\u7be3", // 篣
	0x7be4: "v\n\u7be4", // 篤
	0x7be5: "v\n\u7be5", // 篥
	0x7be6: "v\n\u7be6", // 篦
	0x7be7: "v\n\u7be7", // 篧
	0x7be8: "v\n\u7be8", // 篨
	0x7be9: "v\n\u7be9", // 篩
	0x7bea: "v\n\u7bea", // 篪
	0x7beb: "v\n\u7beb", // 篫
	0x7bec: "v\n\u7bec", // 篬
	0x7bed: "v\n\u7bed", // 篭
	0x7bee: "v\n\u7bee", // 篮
	0x7bef: "v\n\u7bef", // 篯
	0x7bf0: "v\v\u7bf0", // 篰
	0x7bf1: "v\v\u7bf1", // 篱
	0x7bf2: "v\v\u7bf2", // 篲
	0x7bf3: "v\v\u7bf3", // 篳
	0x7bf4: "v\v\u7bf4", // 篴
	0x7bf5: "v\v\u7bf5", // 篵
	0x7bf6: "v\v\u7bf6", // 篶
	0x7bf7: "v\v\u7bf7", // 篷
	0x7bf8: "v\v\u7bf8", // 篸
	0x7bf9: "v\v\u7bf9", // 篹
	0x7bfa: "v\v\u7bfa", // 篺
	0x7bfb: "v\v\u7bfb", // 篻
	0x7bfc: "v\v\u7bfc", // 篼
	0x7bfd: "v\v\u7bfd", // 篽
	0x7bfe: "v\v\u7bfe", // 篾
	0x7bff: "v\v\u7bff", // 篿
	0x7c00: "v\v\u7c00", // 簀
	0x7c01: "v\v\u7c01", // 簁
	0x7c02: "v\v\u7c02", // 簂
	0x7c03: "v\v\u7c03", // 簃
	0x7c04: "v\v\u7c04", // 簄
	0x7c05: "v\v\u7c05", // 簅
	0x7c06: "v\v\u7c06", // 簆
	0x7c07: "v\v\u7c07", // 簇
	0x7c08: "v\v\u7c08", // 簈
	0x7c09: "v\v\u7c09", // 簉
	0x7c0a: "v\v\u7c0a", // 簊
	0x7c0b: "v\v\u7c0b", // 簋
	0x7c0c: "v\v\u7c0c", // 簌
	0x7c0d: "v\v\u7c0d", // 簍
	0x7c0e: "v\v\u7c0e", // 簎
	0x7c0f: "v\v\u7c0f", // 簏
	0x7c10: "v\v\u7c10", // 簐
	0x7c11: "v\n\u7c11", // 簑
	0x7c12: "v\v\u7c12", // 簒
	0x7c13: "v\v\u7c13", // 簓
	0x7c14: "v\v\u7c14", // 簔
	0x7c15: "v\n\u7c15", // 簕
	0x7c16: "v\v\u7c16", // 簖
	0x7c17: "v\v\u7c17", // 簗
	0x7c18: "v\f\u7c18", // 簘
	0x7c19: "v\f\u7c19", // 簙
	0x7c1a: "v\f\u7c1a", // 簚
	0x7c1b: "v\f\u7c1b", // 簛
	0x7c1c: "v\f\u7c1c", // 簜
	0x7c1d: "v\f\u7c1d", // 簝
	0x7c1e: "v\f\u7c1e", // 簞
	0x7c1f: "v\f\u7c1f", // 簟
	0x7c20: "v\f\u7c20", // 簠
	0x7c21: "v\f\u7c21", // 簡
	0x7c22: "v\f\u7c22", // 簢
	0x7c23: "v\f\u7c23", // 簣
	0x7c24: "v\f\u7c24", // 簤
	0x7c25: "v\f\u7c25", // 簥
	0x7c26: "v\f\u7c26", // 簦
	0x7c27: "v\f\u7c27", // 簧
	0x7c28: "v\f\u7c28", // 簨
	0x7c29: "v\f\u7c29", // 簩
	0x7c2a: "v\f\u7c2a", // 簪
	0x7c2b: "v\f\u7c2b", // 簫
	0x7c2c: "v\f\u7c2c", // 簬
	0x7c2d: "v\f\u7c2d", // 簭
	0x7c2e: "v\f\u7c2e", // 簮
	0x7c2f: "v\f\u7c2f", // 簯
	0x7c30: "v\f\u7c30", // 簰
	0x7c31: "v\f\u7c31", // 簱
	0x7c32: "v\f\u7c32", // 簲
	0x7c33: "v\r\u7c33", // 簳
	0x7c34: "v\r\u7c34", // 簴
	0x7c35: "v\r\u7c35", // 簵
	0x7c36: "v\r\u7c36", // 簶
	0x7c37: "v\r\u7c37", // 簷
	0x7c38: "v\r\u7c38", // 簸
	0x7c39: "v\r\u7c39", // 簹
	0x7c3a: "v\r\u7c3a", // 簺
	0x7c3b: "v\r\u7c3b", // 簻
	0x7c3c: "v\r\u7c3c", // 簼
	0x7c3d: "v\r\u7c3d", // 簽
	0x7c3e: "v\r\u7c3e", // 簾
	0x7c3f: "v\r\u7c3f", // 簿
	0x7c40: "v\r\u7c40", // 籀
	0x7c41: "v\r\u7c41", // 籁
	0x7c42: "v\r\u7c42", // 籂
	0x7c43: "v\x0e\u7c43", // 籃
	0x7c44: "v\x0e\u7c44", // 籄
	0x7c45: "v\x0e\u7c45", // 籅
	0x7c46: "v\x0e\u7c46", // 籆
	0x7c47: "v\x0e\u7c47", // 籇
	0x7c48: "v\x0e\u7c48", // 籈
	0x7c49: "v\x0e\u7c49", // 籉
	0x7c4a: "v\x0e\u7c4a", // 籊
	0x7c4b: "v\x0e\u7c4b", // 籋
	0x7c4c: "v\x0e\u7c4c", // 籌
	0x7c4d: "v\x0e\u7c4d", // 籍
	0x7c4e: "v\x0e\u7c4e", // 籎
	0x7c4f: "v\x0e\u7c4f", // 籏
	0x7c50: "v\x0f\u7c50", // 籐
	0x7c51: "v\x0f\u7c51", // 籑
	0x7c52: "v\x0f\u7c52", // 籒
	0x7c53: "v\x0f\u7c53", // 籓
	0x7c54: "v\x0f\u7c54", // 籔
	0x7c55: "v\x0e\u7c55", // 籕
	0x7c56: "v\x0e\u7c56", // 籖
	0x7c57: "v\x10\u7c57", // 籗
	0x7c58: "v\x10\u7c58", // 籘
	0x7c59: "v\x10\u7c59", // 籙
	0x7c5a: "v\x10\u7c5a", // 籚
	0x7c5b: "v\x10\u7c5b", // 籛
	0x7c5c: "v\x10\u7c5c", // 籜
	0x7c5d: "v\x10\u7c5d", // 籝
	0x7c5e: "v\x10\u7c5e", // 籞
	0x7c5f: "v\x10\u7c5f", // 籟
	0x7c60: "v\x10\u7c60", // 籠
	0x7c61: "v\x10\u7c61", // 籡
	0x7c62: "v\x11\u7c62", // 籢
	0x7c63: "v\x11\u7c63", // 籣
	0x7c64: "v\x11\u7c64", // 籤
	0x7c65: "v\x11\u7c65", // 籥
	0x7c66: "v\x11\u7c66", // 籦
	0x7c67: "v\x11\u7c67", // 籧
	0x7c68: "v\x11\u7c68", // 籨
	0x7c69: "v\x13\u7c69", // 籩
	0x7c6a: "v\x12\u7c6a", // 籪
	0x7c6b: "v\x13\u7c6b", // 籫
	0x7c6c: "v\x13\u7c6c", // 籬
	0x7c6d: "v\x13\u7c6d", // 籭
	0x7c6e: "v\x13\u7c6e", // 籮
	0x7c6f: "v\x14\u7c6f", // 籯
	0x7c70: "v\x14\u7c70", // 籰
	0x7c71: "v\x18\u7c71", // 籱
	0x7c72: "v\x1a\u7c72", // 籲
	0x7c73: "w\x00\u7c73", // 米
	0x7c74: "w\x02\u7c74", // 籴
	0x7c75: "w\x02\u7c75", // 籵
	0x7c76: "w\x02\u7c76", // 籶
	0x7c77: "w\x03\u7c77", // 籷
	0x7c78: "w\x03\u7c78", // 籸
	0x7c79: "w\x03\u7c79", // 籹
	0x7c7a: "w\x03\u7c7a", // 籺
	0x7c7b: "w\x03\u7c7b", // 类
	0x7c7c: "w\x03\u7c7c", // 籼
	0x7c7d: "w\x03\u7c7d", // 籽
	0x7c7e: "w\x03\u7c7e", // 籾
	0x7c7f: "w\x03\u7c7f", // 籿
	0x7c80: "w\x03\u7c80", // 粀
	0x7c81: "w\x03\u7c81", // 粁
	0x7c82: "w\x03\u7c82", // 粂
	0x7c83: "w\x04\u7c83", // 粃
	0x7c84: "w\x04\u7c84", // 粄
	0x7c85: "w\x04\u7c85", // 粅
	0x7c86: "w\x04\u7c86", // 粆
	0x7c87: "w\x04\u7c87", // 粇
	0x7c88: "w\x04\u7c88", // 粈
	0x7c89: "w\x04\u7c89", // 粉
	0x7c8a: "w\x04\u7c8a", // 粊
	0x7c8b: "w\x04\u7c8b", // 粋
	0x7c8c: "w\x04\u7c8c", // 粌
	0x7c8d: "w\x04\u7c8d", // 粍
	0x7c8e: "w\x04\u7c8e", // 粎
	0x7c8f: "w\x04\u7c8f", // 粏
	0x7c90: "w\x04\u7c90", // 粐
	0x7c91: "w\x04\u7c91", // 粑
	0x7c92: "w\x05\u7c92", // 粒
	0x7c93: "w\x05\u7c93", // 粓
	0x7c94: "w\x05\u7c94", // 粔
	0x7c95: "w\x05\u7c95", // 粕
	0x7c96: "w\x05\u7c96", // 粖
	0x7c97: "w\x05\u7c97", // 粗
	0x7c98: "w\x05\u7c98", // 粘
	0x7c99: "w\x05\u7c99", // 粙
	0x7c9a: "w\x05\u7c9a", // 粚
	0x7c9b: "w\x05\u7c9b", // 粛
	0x7c9c: "w\x05\u7c9c", // 粜
	0x7c9d: "w\x05\u7c9d", // 粝
	0x7c9e: "w\x06\u7c9e", // 粞
	0x7c9f: "w\x06\u7c9f", // 粟
	0x7ca0: "w\x06\u7ca0", // 粠
	0x7ca1: "w\x06\u7ca1", // 粡
	0x7ca2: "w\x06\u7ca2", // 粢
	0x7ca3: "w\x05\u7ca3", // 粣
	0x7ca4: "w\x06\u7ca4", // 粤
	0x7ca5: "w\x06\u7ca5", // 粥
	0x7ca6: "w\x06\u7ca6", // 粦
	0x7ca7: "w\x06\u7ca7", // 粧
	0x7ca8: "w\x06\u7ca8", // 粨
	0x7ca9: "w\x06\u7ca9", // 粩
	0x7caa: "w\x06\u7caa", // 粪
	0x7cab: "w\x06\u7cab", // 粫
	0x7cac: "w\x06\u7cac", // 粬
	0x7cad: "w\x06\u7cad", // 粭
	0x7cae: "w\a\u7cae", // 粮
	0x7caf: "w\a\u7caf", // 粯
	0x7cb0: "w\a\u7cb0", // 粰
	0x7cb1: "w\a\u7cb1", // 粱
	0x7cb2: "w\a\u7cb2", // 粲
	0x7cb3: "w\a\u7cb3", // 粳
	0x7cb4: "w\a\u7cb4", // 粴
	0x7cb5: "w\a\u7cb5", // 粵
	0x7cb6: "w\b\u7cb6", // 粶
	0x7cb7: "w\b\u7cb7", // 粷
	0x7cb8: "w\b\u7cb8", // 粸
	0x7cb9: "w\b\u7cb9", // 粹
	0x7cba: "w\b\u7cba", // 粺
	0x7cbb: "w\b\u7cbb", // 粻
	0x7cbc: "w\b\u7cbc", // 粼
	0x7cbd: "w\b\u7cbd", // 粽
	0x7cbe: "w\b\u7cbe", // 精
	0x7cbf: "w\b\u7cbf", // 粿
	0x7cc0: "w\a\u7cc0", // 糀
	0x7cc1: "w\b\u7cc1", // 糁
	0x7cc2: "w\t\u7cc2", // 糂
	0x7cc3: "w\t\u7cc3", // 糃
	0x7cc4: "w\t\u7cc4", // 糄
	0x7cc5: "w\t\u7cc5", // 糅
	0x7cc6: "w\t\u7cc6", // 糆
	0x7cc7: "w\t\u7cc7", // 糇
	0x7cc8: "w\t\u7cc8", // 糈
	0x7cc9: "w\t\u7cc9", // 糉
	0x7cca: "w\t\u7cca", // 糊
	0x7ccb: "w\t\u7ccb", // 糋
	0x7ccc: "w\t\u7ccc", // 糌
	0x7ccd: "w\t\u7ccd", // 糍
	0x7cce: "w\t\u7cce", // 糎
	0x7ccf: "w\n\u7ccf", // 糏
	0x7cd0: "w\n\u7cd0", // 糐
	0x7cd1: "w\n\u7cd1", // 糑
	0x7cd2: "w\n\u7cd2", // 糒
	0x7cd3: "w\n\u7cd3", // 糓
	0x7cd4: "w\n\u7cd4", // 糔
	0x7cd5: "w\n\u7cd5", // 糕
	0x7cd6: "w\n\u7cd6", // 糖
	0x7cd7: "w\n\u7cd7", // 糗
	0x7cd8: "w\n\u7cd8", // 糘
	0x7cd9: "w\v\u7cd9", // 糙
	0x7cda: "w\v\u7cda", // 糚
	0x7cdb: "w\v\u7cdb", // 糛
	0x7cdc: "w\v\u7cdc", // 糜
	0x7cdd: "w\v\u7cdd", // 糝
	0x7cde: "w\v\u7cde", // 糞
	0x7cdf: "w\v\u7cdf", // 糟
	0x7ce0: "w\v\u7ce0", // 糠
	0x7ce1: "w\v\u7ce1", // 糡
	0x7ce2: "w\v\u7ce2", // 糢
	0x7ce3: "w\f\u7ce3", // 糣
	0x7ce4: "w\f\u7ce4", // 糤
	0x7ce5: "w\f\u7ce5", // 糥
	0x7ce6: "w\f\u7ce6", // 糦
	0x7ce7: "w\f\u7ce7", // 糧
	0x7ce8: "w\v\u7ce8", // 糨
	0x7ce9: "w\r\u7ce9", // 糩
	0x7cea: "w\r\u7cea", // 糪
	0x7ceb: "w\r\u7ceb", // 糫
	0x7cec: "w\r\u7cec", // 糬
	0x7ced: "w\r\u7ced", // 糭
	0x7cee: "w\x0e\u7cee", // 糮
	0x7cef: "w\x0e\u7cef", // 糯
	0x7cf0: "w\x0e\u7cf0", // 糰
	0x7cf1: "w\x10\u7cf1", // 糱
	0x7cf2: "w\x0f\u7cf2", // 糲
	0x7cf3: "w\x10\u7cf3", // 糳
	0x7cf4: "w\x10\u7cf4", // 糴
	0x7cf5: "w\x11\u7cf5", // 糵
	0x7cf6: "w\x13\u7cf6", // 糶
	0x7cf7: "w\x15\u7cf7", // 糷
	0x7cf8: "x\x00\u7cf8", // 糸
	0x7cf9: "x\x00\u7cf9", // 糹
	0x7cfa: "x\x01\u7cfa", // 糺
	0x7cfb: "x\x01\u7cfb", // 系
	0x7cfc: "x\x02\u7cfc", // 糼
	0x7cfd: "x\x02\u7cfd", // 糽
	0x7cfe: "x\x02\u7cfe", // 糾
	0x7cff: "x\x02\u7cff", // 糿
	0x7d00: "x\x03\u7d00", // 紀
	0x7d01: "x\x03\u7d01", // 紁
	0x7d02: "x\x03\u7d02", // 紂
	0x7d03: "x\x03\u7d03", // 紃
	0x7d04: "x\x03\u7d04", // 約
	0x7d05: "x\x03\u7d05", // 紅
	0x7d06: "x\x03\u7d06", // 紆
	0x7d07: "x\x03\u7d07", // 紇
	0x7d08: "x\x03\u7d08", // 紈
	0x7d09: "x\x03\u7d09", // 紉
	0x7d0a: "x\x04\u7d0a", // 紊
	0x7d0b: "x\x04\u7d0b", // 紋
	0x7d0c: "x\x04\u7d0c", // 紌
	0x7d0d: "x\x04\u7d0d", // 納
	0x7d0e: "x\x04\u7d0e", // 紎
	0x7d0f: "x\x04\u7d0f", // 紏
	0x7d10: "x\x04\u7d10", // 紐
	0x7d11: "x\x04\u7d11", // 紑
	0x7d12: "x\x04\u7d12", // 紒
	0x7d13: "x\x04\u7d13", // 紓
	0x7d14: "x\x04\u7d14", // 純
	0x7d15: "x\x04\u7d15", // 紕
	0x7d16: "x\x04\u7d16", // 紖
	0x7d17: "x\x04\u7d17", // 紗
	0x7d18: "x\x04\u7d18", // 紘
	0x7d19: "x\x04\u7d19", // 紙
	0x7d1a: "x\x04\u7d1a", // 級
	0x7d1b: "x\x04\u7d1b", // 紛
	0x7d1c: "x\x04\u7d1c", // 紜
	0x7d1d: "x\x04\u7d1d", // 紝
	0x7d1e: "x\x04\u7d1e", // 紞
	0x7d1f: "x\x04\u7d1f", // 紟
	0x7d20: "x\x04\u7d20", // 素
	0x7d21: "x\x04\u7d21", // 紡
	0x7d22: "x\x04\u7d22", // 索
	0x7d23: "x\x04\u7d23", // 紣
	0x7d24: "x\x04\u7d24", // 紤
	0x7d25: "x\x04\u7d25", // 紥
	0x7d26: "x\x04\u7d26", // 紦
	0x7d27: "x\x04\u7d27", // 紧
	0x7d28: "x\x05\u7d28", // 紨
	0x7d29: "x\x05\u7d29", // 紩
	0x7d2a: "x\x05\u7d2a", // 紪
	0x7d2b: "x\x05\u7d2b", // 紫
	0x7d2c: "x\x05\u7d2c", // 紬
	0x7d2d: "x\x05\u7d2d", // 紭
	0x7d2e: "x\x05\u7d2e", // 紮
	0x7d2f: "x\x05\u7d2f", // 累
	0x7d30: "x\x05\u7d30", // 細
	0x7d31: "x\x05\u7d31", // 紱
	0x7d32: "x\x05\u7d32", // 紲
	0x7d33: "x\x05\u7d33", // 紳
	0x7d34: "x\x05\u7d34", // 紴
	0x7d35: "x\x05\u7d35", // 紵
	0x7d36: "x\x05\u7d36", // 紶
	0x7d37: "x\x05\u7d37", // 紷
	0x7d38: "x\x05\u7d38", // 紸
	0x7d39: "x\x05\u7d39", // 紹
	0x7d3a: "x\x05\u7d3a", // 紺
	0x7d3b: "x\x05\u7d3b", // 紻
	0x7d3c: "x\x05\u7d3c", // 紼
	0x7d3d: "x\x05\u7d3d", // 紽
	0x7d3e: "x\x05\u7d3e", // 紾
	0x7d3f: "x\x05\u7d3f", // 紿
	0x7d40: "x\x05\u7d40", // 絀
	0x7d41: "x\x05\u7d41", // 絁
	0x7d42: "x\x05\u7d42", // 終
	0x7d43: "x\x05\u7d43", // 絃
	0x7d44: "x\x05\u7d44", // 組
	0x7d45: "x\x05\u7d45", // 絅
	0x7d46: "x\x05\u7d46", // 絆
	0x7d47: "x\x05\u7d47", // 絇
	0x7d48: "x\x05\u7d48", // 絈
	0x7d49: "x\x05\u7d49", // 絉
	0x7d4a: "x\x05\u7d4a", // 絊
	0x7d4b: "x\x05\u7d4b", // 絋
	0x7d4c: "x\x05\u7d4c", // 経
	0x7d4d: "x\x06\u7d4d", // 絍
	0x7d4e: "x\x06\u7d4e", // 絎
	0x7d4f: "x\x06\u7d4f", // 絏
	0x7d50: "x\x06\u7d50", // 結
	0x7d51: "x\x06\u7d51", // 絑
	0x7d52: "x\x06\u7d52", // 絒
	0x7d53: "x\x06\u7d53", // 絓
	0x7d54: "x\x06\u7d54", // 絔
	0x7d55: "x\x06\u7d55", // 絕
	0x7d56: "x\x06\u7d56", // 絖
	0x7d57: "x\x06\u7d57", // 絗
	0x7d58: "x\x06\u7d58", // 絘
	0x7d59: "x\x06\u7d59", // 絙
	0x7d5a: "x\x06\u7d5a", // 絚
	0x7d5b: "x\a\u7d5b", // 絛
	0x7d5c: "x\x06\u7d5c", // 絜
	0x7d5d: "x\x06\u7d5d", // 絝
	0x7d5e: "x\x06\u7d5e", // 絞
	0x7d5f: "x\x06\u7d5f", // 絟
	0x7d60: "x\x06\u7d60", // 絠
	0x7d61: "x\x06\u7d61", // 絡
	0x7d62: "x\x06\u7d62", // 絢
	0x7d63: "x\x06\u7d63", // 絣
	0x7d64: "x\x06\u7d64", // 絤
	0x7d65: "x\x06\u7d65", // 絥
	0x7d66: "x\x06\u7d66", // 給
	0x7d67: "x\x06\u7d67", // 絧
	0x7d68: "x\x06\u7d68", // 絨
	0x7d69: "x\x06\u7d69", // 絩
	0x7d6a: "x\x06\u7d6a", // 絪
	0x7d6b: "x\x06\u7d6b", // 絫
	0x7d6c: "x\x06\u7d6c", // 絬
	0x7d6d: "x\x06\u7d6d", // 絭
	0x7d6e: "x\x06\u7d6e", // 絮
	0x7d6f: "x\x06\u7d6f", // 絯
	0x7d70: "x\x06\u7d70", // 絰
	0x7d71: "x\x06\u7d71", // 統
	0x7d72: "x\x06\u7d72", // 絲
	0x7d73: "x\x06\u7d73", // 絳
	0x7d74: "x\x06\u7d74", // 絴
	0x7d75: "x\x06\u7d75", // 絵
	0x7d76: "x\x06\u7d76", // 絶
	0x7d77: "x\x06\u7d77", // 絷
	0x7d78: "x\a\u7d78", // 絸
	0x7d79: "x\a\u7d79", // 絹
	0x7d7a: "x\a\u7d7a", // 絺
	0x7d7b: "x\a\u7d7b", // 絻
	0x7d7c: "x\a\u7d7c", // 絼
	0x7d7d: "x\a\u7d7d", // 絽
	0x7d7e: "x\a\u7d7e", // 絾
	0x7d7f: "x\a\u7d7f", // 絿
	0x7d80: "x\a\u7d80", // 綀
	0x7d81: "x\a\u7d81", // 綁
	0x7d82: "x\a\u7d82", // 綂
	0x7d83: "x\a\u7d83", // 綃
	0x7d84: "x\a\u7d84", // 綄
	0x7d85: "x\a\u7d85", // 綅
	0x7d86: "x\a\u7d86", // 綆
	0x7d87: "x\a\u7d87", // 綇
	0x7d88: "x\a\u7d88", // 綈
	0x7d89: "x\a\u7d89", // 綉
	0x7d8a: "x\a\u7d8a", // 綊
	0x7d8b: "x\a\u7d8b", // 綋
	0x7d8c: "x\a\u7d8c", // 綌
	0x7d8d: "x\a\u7d8d", // 綍
	0x7d8e: "x\a\u7d8e", // 綎
	0x7d8f: "x\a\u7d8f", // 綏
	0x7d90: "x\a\u7d90", // 綐
	0x7d91: "x\a\u7d91", // 綑
	0x7d92: "x\a\u7d92", // 綒
	0x7d93: "x\a\u7d93", // 經
	0x7d94: "x\a\u7d94", // 綔
	0x7d95: "x\a\u7d95", // 綕
	0x7d96: "x\a\u7d96", // 綖
	0x7d97: "x\a\u7d97", // 綗
	0x7d98: "x\a\u7d98", // 綘
	0x7d99: "x\a\u7d99", // 継
	0x7d9a: "x\a\u7d9a", // 続
	0x7d9b: "x\a\u7d9b", // 綛
	0x7d9c: "x\b\u7d9c", // 綜
	0x7d9d: "x\b\u7d9d", // 綝
	0x7d9e: "x\b\u7d9e", // 綞
	0x7d9f: "x\b\u7d9f", // 綟
	0x7da0: "x\b\u7da0", // 綠
	0x7da1: "x\b\u7da1", // 綡
	0x7da2: "x\b\u7da2", // 綢
	0x7da3: "x\b\u7da3", // 綣
	0x7da4: "x\b\u7da4", // 綤
	0x7da5: "x\b\u7da5", // 綥
	0x7da6: "x\b\u7da6", // 綦
	0x7da7: "x\b\u7da7", // 綧
	0x7da8: "x\b\u7da8", // 綨
	0x7da9: "x\b\u7da9", // 綩
	0x7daa: "x\b\u7daa", // 綪
	0x7dab: "x\b\u7dab", // 綫
	0x7dac: "x\b\u7dac", // 綬
	0x7dad: "x\b\u7dad", // 維
	0x7dae: "x\b\u7dae", // 綮
	0x7daf: "x\b\u7daf", // 綯
	0x7db0: "x\b\u7db0", // 綰
	0x7db1: "x\b\u7db1", // 綱
	0x7db2: "x\b\u7db2", // 網
	0x7db3: "x\b\u7db3", // 綳
	0x7db4: "x\b\u7db4", // 綴
	0x7db5: "x\b\u7db5", // 綵
	0x7db6: "x\b\u7db6", // 綶
	0x7db7: "x\b\u7db7", // 綷
	0x7db8: "x\b\u7db8", // 綸
	0x7db9: "x\b\u7db9", // 綹
	0x7dba: "x\b\u7dba", // 綺
	0x7dbb: "x\b\u7dbb", // 綻
	0x7dbc: "x\b\u7dbc", // 綼
	0x7dbd: "x\b\u7dbd", // 綽
	0x7dbe: "x\b\u7dbe", // 綾
	0x7dbf: "x\b\u7dbf", // 綿
	0x7dc0: "x\b\u7dc0", // 緀
	0x7dc1: "x\b\u7dc1", // 緁
	0x7dc2: "x\b\u7dc2", // 緂
	0x7dc3: "x\b\u7dc3", // 緃
	0x7dc4: "x\b\u7dc4", // 緄
	0x7dc5: "x\b\u7dc5", // 緅
	0x7dc6: "x\b\u7dc6", // 緆
	0x7dc7: "x\b\u7dc7", // 緇
	0x7dc8: "x\b\u7dc8", // 緈
	0x7dc9: "x\b\u7dc9", // 緉
	0x7dca: "x\b\u7dca", // 緊
	0x7dcb: "x\b\u7dcb", // 緋
	0x7dcc: "x\b\u7dcc", // 緌
	0x7dcd: "x\b\u7dcd", // 緍
	0x7dce: "x\b\u7dce", // 緎
	0x7dcf: "x\b\u7dcf", // 総
	0x7dd0: "x\a\u7dd0", // 緐
	0x7dd1: "x\b\u7dd1", // 緑
	0x7dd2: "x\b\u7dd2", // 緒
	0x7dd3: "x\t\u7dd3", // 緓
	0x7dd4: "x\b\u7dd4", // 緔
	0x7dd5: "x\b\u7dd5", // 緕
	0x7dd6: "x\t\u7dd6", // 緖
	0x7dd7: "x\t\u7dd7", // 緗
	0x7dd8: "x\t\u7dd8", // 緘
	0x7dd9: "x\t\u7dd9", // 緙
	0x7dda: "x\t\u7dda", // 線
	0x7ddb: "x\t\u7ddb", // 緛
	0x7ddc: "x\t\u7ddc", // 緜
	0x7ddd: "x\t\u7ddd", // 緝
	0x7dde: "x\t\u7dde", // 緞
	0x7ddf: "x\t\u7ddf", // 緟
	0x7de0: "x\t\u7de0", // 締
	0x7de1: "x\t\u7de1", // 緡
	0x7de2: "x\t\u7de2", // 緢
	0x7de3: "x\t\u7de3", // 緣
	0x7de4: "x\t\u7de4", // 緤
	0x7de5: "x\t\u7de5", // 緥
	0x7de6: "x\t\u7de6", // 緦
	0x7de7: "x\t\u7de7", // 緧
	0x7de8: "x\t\u7de8", // 編
	0x7de9: "x\t\u7de9", // 緩
	0x7dea: "x\t\u7dea", // 緪
	0x7deb: "x\t\u7deb", // 緫
	0x7dec: "x\t\u7dec", // 緬
	0x7ded: "x\t\u7ded", // 緭
	0x7dee: "x\t\u7dee", // 緮
	0x7def: "x\t\u7def", // 緯
	0x7df0: "x\t\u7df0", // 緰
	0x7df1: "x\t\u7df1", // 緱
	0x7df2: "x\t\u7df2", // 緲
	0x7df3: "x\t\u7df3", // 緳
	0x7df4: "x\t\u7df4", // 練
	0x7df5: "x\t\u7df5", // 緵
	0x7df6: "x\t\u7df6", // 緶
	0x7df7: "x\t\u7df7", // 緷
	0x7df8: "x\t\u7df8", // 緸
	0x7df9: "x\t\u7df9", // 緹
	0x7dfa: "x\t\u7dfa", // 緺
	0x7dfb: "x\t\u7dfb", // 緻
	0x7dfc: "x\t\u7dfc", // 緼
	0x7dfd: "x\t\u7dfd", // 緽
	0x7dfe: "x\t\u7dfe", // 緾
	0x7dff: "x\t\u7dff", // 緿
	0x7e00: "x\t\u7e00", // 縀
	0x7e01: "x\t\u7e01", // 縁
	0x7e02: "x\t\u7e02", // 縂
	0x7e03: "x\t\u7e03", // 縃
	0x7e04: "x\t\u7e04", // 縄
	0x7e05: "x\t\u7e05", // 縅
	0x7e06: "x\t\u7e06", // 縆
	0x7e07: "x\t\u7e07", // 縇
	0x7e08: "x\n\u7e08", // 縈
	0x7e09: "x\n\u7e09", // 縉
	0x7e0a: "x\n\u7e0a", // 縊
	0x7e0b: "x\n\u7e0b", // 縋
	0x7e0c: "x\n\u7e0c", // 縌
	0x7e0d: "x\n\u7e0d", // 縍
	0x7e0e: "x\n\u7e0e", // 縎
	0x7e0f: "x\n\u7e0f", // 縏
	0x7e10: "x\n\u7e10", // 縐
	0x7e11: "x\n\u7e11", // 縑
	0x7e12: "x\n\u7e12", // 縒
	0x7e13: "x\n\u7e13", // 縓
	0x7e14: "x\n\u7e14", // 縔
	0x7e15: "x\n\u7e15", // 縕
	0x7e16: "x\n\u7e16", // 縖
	0x7e17: "x\n\u7e17", // 縗
	0x7e18: "x\n\u7e18", // 縘
	0x7e19: "x\n\u7e19", // 縙
	0x7e1a: "x\n\u7e1a", // 縚
	0x7e1b: "x\n\u7e1b", // 縛
	0x7e1c: "x\n\u7e1c", // 縜
	0x7e1d: "x\n\u7e1d", // 縝
	0x7e1e: "x\n\u7e1e", // 縞
	0x7e1f: "x\n\u7e1f", // 縟
	0x7e20: "x\n\u7e20", // 縠
	0x7e21: "x\n\u7e21", // 縡
	0x7e22: "x\n\u7e22", // 縢
	0x7e23: "x\n\u7e23", // 縣
	0x7e24: "x\n\u7e24", // 縤
	0x7e25: "x\n\u7e25", // 縥
	0x7e26: "x\n\u7e26", // 縦
	0x7e27: "x\n\u7e27", // 縧
	0x7e28: "x\n\u7e28", // 縨
	0x7e29: "x\v\u7e29", // 縩
	0x7e2a: "x\v\u7e2a", // 縪
	0x7e2b: "x\v\u7e2b", // 縫
	0x7e2c: "x\v\u7e2c", // 縬
	0x7e2d: "x\v\u7e2d", // 縭
	0x7e2e: "x\v\u7e2e", // 縮
	0x7e2f: "x\v\u7e2f", // 縯
	0x7e30: "x\v\u7e30", // 縰
	0x7e31: "x\v\u7e31", // 縱
	0x7e32: "x\v\u7e32", // 縲
	0x7e33: "x\v\u7e33", // 縳
	0x7e34: "x\v\u7e34", // 縴
	0x7e35: "x\v\u7e35", // 縵
	0x7e36: "x\v\u7e36", // 縶
	0x7e37: "x\v\u7e37", // 縷
	0x7e38: "x\v\u7e38", // 縸
	0x7e39: "x\v\u7e39", // 縹
	0x7e3a: "x\v\u7e3a", // 縺
	0x7e3b: "x\v\u7e3b", // 縻
	0x7e3c: "x\v\u7e3c", // 縼
	0x7e3d: "x\v\u7e3d", // 總
	0x7e3e: "x\v\u7e3e", // 績
	0x7e3f: "x\v\u7e3f", // 縿
	0x7e40: "x\v\u7e40", // 繀
	0x7e41: "x\v\u7e41", // 繁
	0x7e42: "x\v\u7e42", // 繂
	0x7e43: "x\v\u7e43", // 繃
	0x7e44: "x\v\u7e44", // 繄
	0x7e45: "x\v\u7e45", // 繅
	0x7e46: "x\v\u7e46", // 繆
	0x7e47: "x\v\u7e47", // 繇
	0x7e48: "x\f\u7e48", // 繈
	0x7e49: "x\v\u7e49", // 繉
	0x7e4a: "x\v\u7e4a", // 繊
	0x7e4b: "x\r\u7e4b", // 繋
	0x7e4c: "x\v\u7e4c", // 繌
	0x7e4d: "x\v\u7e4d", // 繍
	0x7e4e: "x\f\u7e4e", // 繎
	0x7e4f: "x\f\u7e4f", // 繏
	0x7e50: "x\f\u7e50", // 繐
	0x7e51: "x\f\u7e51", // 繑
	0x7e52: "x\f\u7e52", // 繒
	0x7e53: "x\f\u7e53", // 繓
	0x7e54: "x\f\u7e54", // 織
	0x7e55: "x\f\u7e55", // 繕
	0x7e56: "x\f\u7e56", // 繖
	0x7e57: "x\f\u7e57", // 繗
	0x7e58: "x\f\u7e58", // 繘
	0x7e59: "x\f\u7e59", // 繙
	0x7e5a: "x\f\u7e5a", // 繚
	0x7e5b: "x\f\u7e5b", // 繛
	0x7e5c: "x\f\u7e5c", // 繜
	0x7e5d: "x\f\u7e5d", // 繝
	0x7e5e: "x\f\u7e5e", // 繞
	0x7e5f: "x\f\u7e5f", // 繟
	0x7e60: "x\f\u7e60", // 繠
	0x7e61: "x\f\u7e61", // 繡
	0x7e62: "x\f\u7e62", // 繢
	0x7e63: "x\f\u7e63", // 繣
	0x7e64: "x\f\u7e64", // 繤
	0x7e65: "x\f\u7e65", // 繥
	0x7e66: "x\r\u7e66", // 繦
	0x7e67: "x\f\u7e67", // 繧
	0x7e68: "x\r\u7e68", // 繨
	0x7e69: "x\r\u7e69", // 繩
	0x7e6a: "x\r\u7e6a", // 繪
	0x7e6b: "x\r\u7e6b", // 繫
	0x7e6c: "x\r\u7e6c", // 繬
	0x7e6d: "x\r\u7e6d", // 繭
	0x7e6e: "x\r\u7e6e", // 繮
	0x7e6f: "x\r\u7e6f", // 繯
	0x7e70: "x\r\u7e70", // 繰
	0x7e71: "x\f\u7e71", // 繱
	0x7e72: "x\r\u7e72", // 繲
	0x7e73: "x\r\u7e73", // 繳
	0x7e74: "x\r\u7e74", // 繴
	0x7e75: "x\r\u7e75", // 繵
	0x7e76: "x\r\u7e76", // 繶
	0x7e77: "x\r\u7e77", // 繷
	0x7e78: "x\r\u7e78", // 繸
	0x7e79: "x\r\u7e79", // 繹
	0x7e7a: "x\r\u7e7a", // 繺
	0x7e7b: "x\x0e\u7e7b", // 繻
	0x7e7c: "x\x0e\u7e7c", // 繼
	0x7e7d: "x\x0e\u7e7d", // 繽
	0x7e7e: "x\x0e\u7e7e", // 繾
	0x7e7f: "x\x0e\u7e7f", // 繿
	0x7e80: "x\x0e\u7e80", // 纀
	0x7e81: "x\x0e\u7e81", // 纁
	0x7e82: "x\x0e\u7e82", // 纂
	0x7e83: "x\x0e\u7e83", // 纃
	0x7e84: "x\x0f\u7e84", // 纄
	0x7e85: "x\x0f\u7e85", // 纅
	0x7e86: "x\x0f\u7e86", // 纆
	0x7e87: "x\x0f\u7e87", // 纇
	0x7e88: "x\x0f\u7e88", // 纈
	0x7e89: "x\x0f\u7e89", // 纉
	0x7e8a: "x\x0f\u7e8a", // 纊
	0x7e8b: "x\x0f\u7e8b", // 纋
	0x7e8c: "x\x0f\u7e8c", // 續
	0x7e8d: "x\x0f\u7e8d", // 纍
	0x7e8e: "x\x0f\u7e8e", // 纎
	0x7e8f: "x\x0f\u7e8f", // 纏
	0x7e90: "x\x0f\u7e90", // 纐
	0x7e91: "x\x10\u7e91", // 纑
	0x7e92: "x\x10\u7e92", // 纒
	0x7e93: "x\x11\u7e93", // 纓
	0x7e94: "x\x11\u7e94", // 纔
	0x7e95: "x\x11\u7e95", // 纕
	0x7e96: "x\x11\u7e96", // 纖
	0x7e97: "x\x12\u7e97", // 纗
	0x7e98: "x\x13\u7e98", // 纘
	0x7e99: "x\x13\u7e99", // 纙
	0x7e9a: "x\x13\u7e9a", // 纚
	0x7e9b: "x\x13\u7e9b", // 纛
	0x7e9c: "x\x15\u7e9c", // 纜
	0x7e9d: "x\x15\u7e9d", // 纝
	0x7e9e: "x\x17\u7e9e", // 纞
	0x7e9f: "x\x00\u7e9f", // 纟
	0x7ea0: "x\x02\u7ea0", // 纠
	0x7ea1: "x\x03\u7ea1", // 纡
	0x7ea2: "x\x03\u7ea2", // 红
	0x7ea3: "x\x03\u7ea3", // 纣
	0x7ea4: "x\x03\u7ea4", // 纤
	0x7ea5: "x\x03\u7ea5", // 纥
	0x7ea6: "x\x03\u7ea6", // 约
	0x7ea7: "x\x03\u7ea7", // 级
	0x7ea8: "x\x03\u7ea8", // 纨
	0x7ea9: "x\x03\u7ea9", // 纩
	0x7eaa: "x\x03\u7eaa", // 纪
	0x7eab: "x\x03\u7eab", // 纫
	0x7eac: "x\x04\u7eac", // 纬
	0x7ead: "x\x04\u7ead", // 纭
	0x7eae: "x\x04\u7eae", // 纮
	0x7eaf: "x\x04\u7eaf", // 纯
	0x7eb0: "x\x04\u7eb0", // 纰
	0x7eb1: "x\x04\u7eb1", // 纱
	0x7eb2: "x\x04\u7eb2", // 纲
	0x7eb3: "x\x04\u7eb3", // 纳
	0x7eb4: "x\x04\u7eb4", // 纴
	0x7eb5: "x\x04\u7eb5", // 纵
	0x7eb6: "x\x03\u7eb6", // 纶
	0x7eb7: "x\x04\u7eb7", // 纷
	0x7eb8: "x\x04\u7eb8", // 纸
	0x7eb9: "x\x04\u7eb9", // 纹
	0x7eba: "x\x04\u7eba", // 纺
	0x7ebb: "x\x04\u7ebb", // 纻
	0x7ebc: "x\x04\u7ebc", // 纼
	0x7ebd: "x\x04\u7ebd", // 纽
	0x7ebe: "x\x04\u7ebe", // 纾
	0x7ebf: "x\x05\u7ebf", // 线
	0x7ec0: "x\x05\u7ec0", // 绀
	0x7ec1: "x\x05\u7ec1", // 绁
	0x7ec2: "x\x05\u7ec2", // 绂
	0x7ec3: "x\x05\u7ec3", // 练
	0x7ec4: "x\x05\u7ec4", // 组
	0x7ec5: "x\x05\u7ec5", // 绅
	0x7ec6: "x\x05\u7ec6", // 细
	0x7ec7: "x\x05\u7ec7", // 织
	0x7ec8: "x\x05\u7ec8", // 终
	0x7ec9: "x\x05\u7ec9", // 绉
	0x7eca: "x\x05\u7eca", // 绊
	0x7ecb: "x\x05\u7ecb", // 绋
	0x7ecc: "x\x05\u7ecc", // 绌
	0x7ecd: "x\x05\u7ecd", // 绍
	0x7ece: "x\x05\u7ece", // 绎
	0x7ecf: "x\x05\u7ecf", // 经
	0x7ed0: "x\x05\u7ed0", // 绐
	0x7ed1: "x\x06\u7ed1", // 绑
	0x7ed2: "x\x06\u7ed2", // 绒
	0x7ed3: "x\x06\u7ed3", // 结
	0x7ed4: "x\x06\u7ed4", // 绔
	0x7ed5: "x\x06\u7ed5", // 绕
	0x7ed6: "x\x06\u7ed6", // 绖
	0x7ed7: "x\x06\u7ed7", // 绗
	0x7ed8: "x\x06\u7ed8", // 绘
	0x7ed9: "x\x06\u7ed9", // 给
	0x7eda: "x\x06\u7eda", // 绚
	0x7edb: "x\x06\u7edb", // 绛
	0x7edc: "x\x06\u7edc", // 络
	0x7edd: "x\x06\u7edd", // 绝
	0x7ede: "x\x06\u7ede", // 绞
	0x7edf: "x\x06\u7edf", // 统
	0x7ee0: "x\a\u7ee0", // 绠
	0x7ee1: "x\a\u7ee1", // 绡
	0x7ee2: "x\a\u7ee2", // 绢
	0x7ee3: "x\a\u7ee3", // 绣
	0x7ee4: "x\a\u7ee4", // 绤
	0x7ee5: "x\a\u7ee5", // 绥
	0x7ee6: "x\a\u7ee6", // 绦
	0x7ee7: "x\a\u7ee7", // 继
	0x7ee8: "x\a\u7ee8", // 绨
	0x7ee9: "x\b\u7ee9", // 绩
	0x7eea: "x\b\u7eea", // 绪
	0x7eeb: "x\b\u7eeb", // 绫
	0x7eec: "x\b\u7eec", // 绬
	0x7eed: "x\b\u7eed", // 续
	0x7eee: "x\b\u7eee", // 绮
	0x7eef: "x\b\u7eef", // 绯
	0x7ef0: "x\b\u7ef0", // 绰
	0x7ef1: "x\b\u7ef1", // 绱
	0x7ef2: "x\b\u7ef2", // 绲
	0x7ef3: "x\b\u7ef3", // 绳
	0x7ef4: "x\b\u7ef4", // 维
	0x7ef5: "x\b\u7ef5", // 绵
	0x7ef6: "x\b\u7ef6", // 绶
	0x7ef7: "x\b\u7ef7", // 绷
	0x7ef8: "x\b\u7ef8", // 绸
	0x7ef9: "x\b\u7ef9", // 绹
	0x7efa: "x\b\u7efa", // 绺
	0x7efb: "x\b\u7efb", // 绻
	0x7efc: "x\b\u7efc", // 综
	0x7efd: "x\b\u7efd", // 绽
	0x7efe: "x\b\u7efe", // 绾
	0x7eff: "x\b\u7eff", // 绿
	0x7f00: "x\b\u7f00", // 缀
	0x7f01: "x\b\u7f01", // 缁
	0x7f02: "x\t\u7f02", // 缂
	0x7f03: "x\t\u7f03", // 缃
	0x7f04: "x\t\u7f04", // 缄
	0x7f05: "x\t\u7f05", // 缅
	0x7f06: "x\t\u7f06", // 缆
	0x7f07: "x\t\u7f07", // 缇
	0x7f08: "x\t\u7f08", // 缈
	0x7f09: "x\t\u7f09", // 缉
	0x7f0a: "x\t\u7f0a", // 缊
	0x7f0b: "x\t\u7f0b", // 缋
	0x7f0c: "x\t\u7f0c", // 缌
	0x7f0d: "x\t\u7f0d", // 缍
	0x7f0e: "x\t\u7f0e", // 缎
	0x7f0f: "x\t\u7f0f", // 缏
	0x7f10: "x\t\u7f10", // 缐
	0x7f11: "x\t\u7f11", // 缑
	0x7f12: "x\t\u7f12", // 缒
	0x7f13: "x\t\u7f13", // 缓
	0x7f14: "x\t\u7f14", // 缔
	0x7f15: "x\t\u7f15", // 缕
	0x7f16: "x\t\u7f16", // 编
	0x7f17: "x\t\u7f17", // 缗
	0x7f18: "x\t\u7f18", // 缘
	0x7f19: "x\n\u7f19", // 缙
	0x7f1a: "x\n\u7f1a", // 缚
	0x7f1b: "x\n\u7f1b", // 缛
	0x7f1c: "x\n\u7f1c", // 缜
	0x7f1d: "x\n\u7f1d", // 缝
	0x7f1e: "x\n\u7f1e", // 缞
	0x7f1f: "x\n\u7f1f", // 缟
	0x7f20: "x\n\u7f20", // 缠
	0x7f21: "x\n\u7f21", // 缡
	0x7f22: "x\n\u7f22", // 缢
	0x7f23: "x\n\u7f23", // 缣
	0x7f24: "x\n\u7f24", // 缤
	0x7f25: "x\v\u7f25", // 缥
	0x7f26: "x\v\u7f26", // 缦
	0x7f27: "x\v\u7f27", // 缧
	0x7f28: "x\v\u7f28", // 缨
	0x7f29: "x\v\u7f29", // 缩
	0x7f2a: "x\v\u7f2a", // 缪
	0x7f2b: "x\v\u7f2b", // 缫
	0x7f2c: "x\f\u7f2c", // 缬
	0x7f2d: "x\f\u7f2d", // 缭
	0x7f2e: "x\f\u7f2e", // 缮
	0x7f2f: "x\f\u7f2f", // 缯
	0x7f30: "x\r\u7f30", // 缰
	0x7f31: "x\r\u7f31", // 缱
	0x7f32: "x\r\u7f32", // 缲
	0x7f33: "x\r\u7f33", // 缳
	0x7f34: "x\r\u7f34", // 缴
	0x7f35: "x\x10\u7f35", // 缵
	0x7f36: "y\x00\u7f36", // 缶
	0x7f37: "y\x02\u7f37", // 缷
	0x7f38: "y\x03\u7f38", // 缸
	0x7f39: "y\x04\u7f39", // 缹
	0x7f3a: "y\x04\u7f3a", // 缺
	0x7f3b: "y\x05\u7f3b", // 缻
	0x7f3c: "y\x04\u7f3c", // 缼
	0x7f3d: "y\x05\u7f3d", // 缽
	0x7f3e: "y\x06\u7f3e", // 缾
	0x7f3f: "y\x06\u7f3f", // 缿
	0x7f40: "y\x06\u7f40", // 罀
	0x7f41: "y\b\u7f41", // 罁
	0x7f42: "y\b\u7f42", // 罂
	0x7f43: "y\n\u7f43", // 罃
	0x7f44: "y\v\u7f44", // 罄
	0x7f45: "y\v\u7f45", // 罅
	0x7f46: "y\v\u7f46", // 罆
	0x7f47: "y\f\u7f47", // 罇
	0x7f48: "y\f\u7f48", // 罈
	0x7f49: "y\f\u7f49", // 罉
	0x7f4a: "y\r\u7f4a", // 罊
	0x7f4b: "y\r\u7f4b", // 罋
	0x7f4c: "y\x0e\u7f4c", // 罌
	0x7f4d: "y\x0f\u7f4d", // 罍
	0x7f4e: "y\x10\u7f4e", // 罎
	0x7f4f: "y\x10\u7f4f", // 罏
	0x7f50: "y\x12\u7f50", // 罐
	0x7f51: "z\x00\u7f51", // 网
	0x7f52: "z\x00\u7f52", // 罒
	0x7f53: "z\x00\u7f53", // 罓
	0x7f54: "z\x03\u7f54", // 罔
	0x7f55: "z\x03\u7f55", // 罕
	0x7f56: "z\x03\u7f56", // 罖
	0x7f57: "z\x03\u7f57", // 罗
	0x7f58: "z\x04\u7f58", // 罘
	0x7f59: "z\x04\u7f59", // 罙
	0x7f5a: "z\x04\u7f5a", // 罚
	0x7f5b: "z\x05\u7f5b", // 罛
	0x7f5c: "z\x05\u7f5c", // 罜
	0x7f5d: "z\x05\u7f5d", // 罝
	0x7f5e: "z\x05\u7f5e", // 罞
	0x7f5f: "z\x05\u7f5f", // 罟
	0x7f60: "z\x05\u7f60", // 罠
	0x7f61: "z\x05\u7f61", // 罡
	0x7f62: "z\x05\u7f62", // 罢
	0x7f63: "z\x06\u7f63", // 罣
	0x7f64: "z\a\u7f64", // 罤
	0x7f65: "z\a\u7f65", // 罥
	0x7f66: "z\a\u7f66", // 罦
	0x7f67: "z\b\u7f67", // 罧
	0x7f68: "z\b\u7f68", // 罨
	0x7f69: "z\b\u7f69", // 罩
	0x7f6a: "z\b\u7f6a", // 罪
	0x7f6b: "z\b\u7f6b", // 罫
	0x7f6c: "z\b\u7f6c", // 罬
	0x7f6d: "z\b\u7f6d", // 罭
	0x7f6e: "z\b\u7f6e", // 置
	0x7f6f: "z\t\u7f6f", // 罯
	0x7f70: "z\t\u7f70", // 罰
	0x7f71: "z\t\u7f71", // 罱
	0x7f72: "z\b\u7f72", // 署
	0x7f73: "z\t\u7f73", // 罳
	0x7f74: "z\t\u7f74", // 罴
	0x7f75: "z\n\u7f75", // 罵
	0x7f76: "z\n\u7f76", // 罶
	0x7f77: "z\n\u7f77", // 罷
	0x7f78: "z\n\u7f78", // 罸
	0x7f79: "z\v\u7f79", // 罹
	0x7f7a: "z\v\u7f7a", // 罺
	0x7f7b: "z\v\u7f7b", // 罻
	0x7f7c: "z\v\u7f7c", // 罼
	0x7f7d: "z\f\u7f7d", // 罽
	0x7f7e: "z\f\u7f7e", // 罾
	0x7f7f: "z\f\u7f7f", // 罿
	0x7f80: "z\f\u7f80", // 羀
	0x7f81: "z\f\u7f81", // 羁
	0x7f82: "z\r\u7f82", // 羂
	0x7f83: "z\x0e\u7f83", // 羃
	0x7f84: "z\x0e\u7f84", // 羄
	0x7f85: "z\x0e\u7f85", // 羅
	0x7f86: "z\x0e\u7f86", // 羆
	0x7f87: "z\x11\u7f87", // 羇
	0x7f88: "z\x13\u7f88", // 羈
	0x7f89: "z\x13\u7f89", // 羉
	0x7f8a: "{\x00\u7f8a", // 羊
	0x7f8b: "{\x01\u7f8b", // 羋
	0x7f8c: "{\x02\u7f8c", // 羌
	0x7f8d: "{\x03\u7f8d", // 羍
	0x7f8e: "{\x03\u7f8e", // 美
	0x7f8f: "{\x03\u7f8f", // 羏
	0x7f90: "{\x03\u7f90", // 羐
	0x7f91: "{\x03\u7f91", // 羑
	0x7f92: "{\x04\u7f92", // 羒
	0x7f93: "{\x04\u7f93", // 羓
	0x7f94: "{\x04\u7f94", // 羔
	0x7f95: "{\x05\u7f95", // 羕
	0x7f96: "{\x04\u7f96", // 羖
	0x7f97: "{\x04\u7f97", // 羗
	0x7f98: "{\x04\u7f98", // 羘
	0x7f99: "{\x04\u7f99", // 羙
	0x7f9a: "{\x05\u7f9a", // 羚
	0x7f9b: "{\x05\u7f9b", // 羛
	0x7f9c: "{\x05\u7f9c", // 羜
	0x7f9d: "{\x05\u7f9d", // 羝
	0x7f9e: "{\x05\u7f9e", // 羞
	0x7f9f: "{\x05\u7f9f", // 羟
	0x7fa0: "{\x06\u7fa0", // 羠
	0x7fa1: "{\x06\u7fa1", // 羡
	0x7fa2: "{\x06\u7fa2", // 羢
	0x7fa3: "{\a\u7fa3", // 羣
	0x7fa4: "{\a\u7fa4", // 群
	0x7fa5: "{\a\u7fa5", // 羥
	0x7fa6: "{\a\u7fa6", // 羦
	0x7fa7: "{\a\u7fa7", // 羧
	0x7fa8: "{\a\u7fa8", // 羨
	0x7fa9: "{\a\u7fa9", // 義
	0x7faa: "{\a\u7faa", // 羪
	0x7fab: "{\b\u7fab", // 羫
	0x7fac: "{\t\u7fac", // 羬
	0x7fad: "{\t\u7fad", // 羭
	0x7fae: "{\t\u7fae", // 羮
	0x7faf: "{\t\u7faf", // 羯
	0x7fb0: "{\t\u7fb0", // 羰
	0x7fb1: "{\n\u7fb1", // 羱
	0x7fb2: "{\n\u7fb2", // 羲
	0x7fb3: "{\f\u7fb3", // 羳
	0x7fb4: "{\f\u7fb4", // 羴
	0x7fb5: "{\f\u7fb5", // 羵
	0x7fb6: "{\r\u7fb6", // 羶
	0x7fb7: "{\r\u7fb7", // 羷
	0x7fb8: "{\r\u7fb8", // 羸
	0x7fb9: "{\r\u7fb9", // 羹
	0x7fba: "{\x0e\u7fba", // 羺
	0x7fbb: "{\x0f\u7fbb", // 羻
	0x7fbc: "{\x0f\u7fbc", // 羼
	0x7fbd: "|\x00\u7fbd", // 羽
	0x7fbe: "|\x03\u7fbe", // 羾
	0x7fbf: "|\x03\u7fbf", // 羿
	0x7fc0: "|\x04\u7fc0", // 翀
	0x7fc1: "|\x04\u7fc1", // 翁
	0x7fc2: "|\x04\u7fc2", // 翂
	0x7fc3: "|\x04\u7fc3", // 翃
	0x7fc4: "|\x04\u7fc4", // 翄
	0x7fc5: "|\x04\u7fc5", // 翅
	0x7fc6: "|\x04\u7fc6", // 翆
	0x7fc7: "|\x05\u7fc7", // 翇
	0x7fc8: "|\x05\u7fc8", // 翈
	0x7fc9: "|\x05\u7fc9", // 翉
	0x7fca: "|\x05\u7fca", // 翊
	0x7fcb: "|\x05\u7fcb", // 翋
	0x7fcc: "|\x05\u7fcc", // 翌
	0x7fcd: "|\x05\u7fcd", // 翍
	0x7fce: "|\x05\u7fce", // 翎
	0x7fcf: "|\x05\u7fcf", // 翏
	0x7fd0: "|\x05\u7fd0", // 翐
	0x7fd1: "|\x05\u7fd1", // 翑
	0x7fd2: "|\x05\u7fd2", // 習
	0x7fd3: "|\x06\u7fd3", // 翓
	0x7fd4: "|\x06\u7fd4", // 翔
	0x7fd5: "|\x06\u7fd5", // 翕
	0x7fd6: "|\x06\u7fd6", // 翖
	0x7fd7: "|\x06\u7fd7", // 翗
	0x7fd8: "|\x06\u7fd8", // 翘
	0x7fd9: "|\x06\u7fd9", // 翙
	0x7fda: "|\x06\u7fda", // 翚
	0x7fdb: "|\a\u7fdb", // 翛
	0x7fdc: "|\a\u7fdc", // 翜
	0x7fdd: "|\a\u7fdd", // 翝
	0x7fde: "|\b\u7fde", // 翞
	0x7fdf: "|\b\u7fdf", // 翟
	0x7fe0: "|\b\u7fe0", // 翠
	0x7fe1: "|\b\u7fe1", // 翡
	0x7fe2: "|\b\u7fe2", // 翢
	0x7fe3: "|\b\u7fe3", // 翣
	0x7fe4: "|\b\u7fe4", // 翤
	0x7fe5: "|\t\u7fe5", // 翥
	0x7fe6: "|\t\u7fe6", // 翦
	0x7fe7: "|\t\u7fe7", // 翧
	0x7fe8: "|\t\u7fe8", // 翨
	0x7fe9: "|\t\u7fe9", // 翩
	0x7fea: "|\t\u7fea", // 翪
	0x7feb: "|\t\u7feb", // 翫
	0x7fec: "|\t\u7fec", // 翬
	0x7fed: "|\t\u7fed", // 翭
	0x7fee: "|\n\u7fee", // 翮
	0x7fef: "|\n\u7fef", // 翯
	0x7ff0: "|\n\u7ff0", // 翰
	0x7ff1: "|\n\u7ff1", // 翱
	0x7ff2: "|\v\u7ff2", // 翲
	0x7ff3: "|\v\u7ff3", // 翳
	0x7ff4: "|\v\u7ff4", // 翴
	0x7ff5: "|\v\u7ff5", // 翵
	0x7ff6: "|\v\u7ff6", // 翶
	0x7ff7: "|\f\u7ff7", // 翷
	0x7ff8: "|\f\u7ff8", // 翸
	0x7ff9: "|\f\u7ff9", // 翹
	0x7ffa: "|\f\u7ffa", // 翺
	0x7ffb: "|\f\u7ffb", // 翻
	0x7ffc: "|\v\u7ffc", // 翼
	0x7ffd: "|\r\u7ffd", // 翽
	0x7ffe: "|\r\u7ffe", // 翾
	0x7fff: "|\x0e\u7fff", // 翿
	0x8000: "|\x0e\u8000", // 耀
	0x8001: "}\x00\u8001", // 老
	0x8002: "}\x00\u8002", // 耂
	0x8003: "}\x00\u8003", // 考
	0x8004: "}\x04\u8004", // 耄
	0x8005: "}\x04\u8005", // 者
	0x8006: "}\x04\u8006", // 耆
	0x8007: "}\x05\u8007", // 耇
	0x8008: "}\x05\u8008", // 耈
	0x8009: "}\x05\u8009", // 耉
	0x800a: "}\x06\u800a", // 耊
	0x800b: "}\x06\u800b", // 耋
	0x800c: "~\x00\u800c", // 而
	0x800d: "~\x03\u800d", // 耍
	0x800e: "~\x03\u800e", // 耎
	0x800f: "~\x03\u800f", // 耏
	0x8010: "~\x03\u8010", // 耐
	0x8011: "~\x03\u8011", // 耑
	0x8012: "\u007f\x00\u8012", // 耒
	0x8013: "\u007f\x02\u8013", // 耓
	0x8014: "\u007f\x03\u8014", // 耔
	0x8015: "\u007f\x04\u8015", // 耕
	0x8016: "\u007f\x04\u8016", // 耖
	0x8017: "\u007f\x04\u8017", // 耗
	0x8018: "\u007f\x04\u8018", // 耘
	0x8019: "\u007f\x04\u8019", // 耙
	0x801a: "\u007f\x05\u801a", // 耚
	0x801b: "\u007f\x05\u801b", // 耛
	0x801c: "\u007f\x05\u801c", // 耜
	0x801d: "\u007f\x05\u801d", // 耝
	0x801e: "\u007f\x05\u801e", // 耞
	0x801f: "\u007f\x05\u801f", // 耟
	0x8020: "\u007f\x06\u8020", // 耠
	0x8021: "\u007f\a\u8021", // 耡
	0x8022: "\u007f\a\u8022", // 耢
	0x8023: "\u007f\b\u8023", // 耣
	0x8024: "\u007f\b\u8024", // 耤
	0x8025: "\u007f\b\u8025", // 耥
	0x8026: "\u007f\t\u8026", // 耦
	0x8027: "\u007f\t\u8027", // 耧
	0x8028: "\u007f\n\u8028", // 耨
	0x8029: "\u007f\n\u8029", // 耩
	0x802a: "\u007f\n\u802a", // 耪
	0x802b: "\u007f\v\u802b", // 耫
	0x802c: "\u007f\v\u802c", // 耬
	0x802d: "\u007f\f\u802d", // 耭
	0x802e: "\u007f\f\u802e", // 耮
	0x802f: "\u007f\x0e\u802f", // 耯
	0x8030: "\u007f\x0f\u8030", // 耰
	0x8031: "\u007f\x10\u8031", // 耱
	0x8032: "\u007f\x10\u8032", // 耲
	0x8033: "\x80\x00\u8033", // 耳
	0x8034: "\x80\x01\u8034", // 耴
	0x8035: "\x80\x02\u8035", // 耵
	0x8036: "\x80\x03\u8036", // 耶
	0x8037: "\x80\x03\u8037", // 耷
	0x8038: "\x80\x04\u8038", // 耸
	0x8039: "\x80\x04\u8039", // 耹
	0x803a: "\x80\x04\u803a", // 耺
	0x803b: "\x80\x04\u803b", // 耻
	0x803c: "\x80\x04\u803c", // 耼
	0x803d: "\x80\x04\u803d", // 耽
	0x803e: "\x80\x04\u803e", // 耾
	0x803f: "\x80\x04\u803f", // 耿
	0x8040: "\x80\x04\u8040", // 聀
	0x8041: "\x80\x04\u8041", // 聁
	0x8042: "\x80\x04\u8042", // 聂
	0x8043: "\x80\x05\u8043", // 聃
	0x8044: "\x80\x05\u8044", // 聄
	0x8045: "\x80\x05\u8045", // 聅
	0x8046: "\x80\x05\u8046", // 聆
	0x8047: "\x80\x05\u8047", // 聇
	0x8048: "\x80\x05\u8048", // 聈
	0x8049: "\x80\x05\u8049", // 聉
	0x804a: "\x80\x05\u804a", // 聊
	0x804b: "\x80\x05\u804b", // 聋
	0x804c: "\x80\x05\u804c", // 职
	0x804d: "\x80\x05\u804d", // 聍
	0x804e: "\x80\x06\u804e", // 聎
	0x804f: "\x80\x06\u804f", // 聏
	0x8050: "\x80\x06\u8050", // 聐
	0x8051: "\x80\x06\u8051", // 聑
	0x8052: "\x80\x06\u8052", // 聒
	0x8053: "\x80\x06\u8053", // 聓
	0x8054: "\x80\x06\u8054", // 联
	0x8055: "\x80\a\u8055", // 聕
	0x8056: "\x80\a\u8056", // 聖
	0x8057: "\x80\a\u8057", // 聗
	0x8058: "\x80\a\u8058", // 聘
	0x8059: "\x80\b\u8059", // 聙
	0x805a: "\x80\b\u805a", // 聚
	0x805b: "\x80\b\u805b", // 聛
	0x805c: "\x80\b\u805c", // 聜
	0x805d: "\x80\b\u805d", // 聝
	0x805e: "\x80\b\u805e", // 聞
	0x805f: "\x80\b\u805f", // 聟
	0x8060: "\x80\x06\u8060", // 聠
	0x8061: "\x80\b\u8061", // 聡
	0x8062: "\x80\b\u8062", // 聢
	0x8063: "\x80\b\u8063", // 聣
	0x8064: "\x80\t\u8064", // 聤
	0x8065: "\x80\t\u8065", // 聥
	0x8066: "\x80\t\u8066", // 聦
	0x8067: "\x80\t\u8067", // 聧
	0x8068: "\x80\t\u8068", // 聨
	0x8069: "\x80\t\u8069", // 聩
	0x806a: "\x80\t\u806a", // 聪
	0x806b: "\x80\t\u806b", // 聫
	0x806c: "\x80\n\u806c", // 聬
	0x806d: "\x80\n\u806d", // 聭
	0x806e: "\x80\f\u806e", // 聮
	0x806f: "\x80\v\u806f", // 聯
	0x8070: "\x80\v\u8070", // 聰
	0x8071: "\x80\v\u8071", // 聱
	0x8072: "\x80\v\u8072", // 聲
	0x8073: "\x80\v\u8073", // 聳
	0x8074: "\x80\f\u8074", // 聴
	0x8075: "\x80\f\u8075", // 聵
	0x8076: "\x80\f\u8076", // 聶
	0x8077: "\x80\f\u8077", // 職
	0x8078: "\x80\r\u8078", // 聸
	0x8079: "\x80\x0e\u8079", // 聹
	0x807a: "\x80\x0e\u807a", // 聺
	0x807b: "\x80\x0e\u807b", // 聻
	0x807c: "\x80\x0e\u807c", // 聼
	0x807d: "\x80\x10\u807d", // 聽
	0x807e: "\x80\x10\u807e", // 聾
	0x807f: "\x81\x00\u807f", // 聿
	0x8080: "\x81\x00\u8080", // 肀
	0x8081: "\x81\x04\u8081", // 肁
	0x8082: "\x81\x04\u8082", // 肂
	0x8083: "\x81\x04\u8083", // 肃
	0x8084: "\x81\a\u8084", // 肄
	0x8085: "\x81\a\u8085", // 肅
	0x8086: "\x81\a\u8086", // 肆
	0x8087: "\x81\b\u8087", // 肇
	0x8088: "\x81\b\u8088", // 肈
	0x8089: "\x82\x00\u8089", // 肉
	0x808a: "\x82\x01\u808a", // 肊
	0x808b: "\x82\x02\u808b", // 肋
	0x808c: "\x82\x02\u808c", // 肌
	0x808d: "\x82\x02\u808d", // 肍
	0x808e: "\x82\x02\u808e", // 肎
	0x808f: "\x82\x02\u808f", // 肏
	0x8090: "\x82\x03\u8090", // 肐
	0x8091: "\x82\x03\u8091", // 肑
	0x8092: "\x82\x03\u8092", // 肒
	0x8093: "\x82\x03\u8093", // 肓
	0x8094: "\x82\x03\u8094", // 肔
	0x8095: "\x82\x03\u8095", // 肕
	0x8096: "\x82\x03\u8096", // 肖
	0x8097: "\x82\x03\u8097", // 肗
	0x8098: "\x82\x03\u8098", // 肘
	0x8099: "\x82\x03\u8099", // 肙
	0x809a: "\x82\x03\u809a", // 肚
	0x809b: "\x82\x03\u809b", // 肛
	0x809c: "\x82\x03\u809c", // 肜
	0x809d: "\x82\x03\u809d", // 肝
	0x809e: "\x82\x03\u809e", // 肞
	0x809f: "\x82\x03\u809f", // 肟
	0x80a0: "\x82\x03\u80a0", // 肠
	0x80a1: "\x82\x04\u80a1", // 股
	0x80a2: "\x82\x04\u80a2", // 肢
	0x80a3: "\x82\x04\u80a3", // 肣
	0x80a4: "\x82\x04\u80a4", // 肤
	0x80a5: "\x82\x04\u80a5", // 肥
	0x80a6: "\x82\x04\u80a6", // 肦
	0x80a7: "\x82\x04\u80a7", // 肧
	0x80a8: "\x82\x04\u80a8", // 肨
	0x80a9: "\x82\x04\u80a9", // 肩
	0x80aa: "\x82\x04\u80aa", // 肪
	0x80ab: "\x82\x04\u80ab", // 肫
	0x80ac: "\x82\x04\u80ac", // 肬
	0x80ad: "\x82\x04\u80ad", // 肭
	0x80ae: "\x82\x04\u80ae", // 肮
	0x80af: "\x82\x04\u80af", // 肯
	0x80b0: "\x82\x04\u80b0", // 肰
	0x80b1: "\x82\x04\u80b1", // 肱
	0x80b2: "\x82\x04\u80b2", // 育
	0x80b3: "\x82\x04\u80b3", // 肳
	0x80b4: "\x82\x04\u80b4", // 肴
	0x80b5: "\x82\x04\u80b5", // 肵
	0x80b6: "\x82\x04\u80b6", // 肶
	0x80b7: "\x82\x04\u80b7", // 肷
	0x80b8: "\x82\x04\u80b8", // 肸
	0x80b9: "\x82\x04\u80b9", // 肹
	0x80ba: "\x82\x04\u80ba", // 肺
	0x80bb: "\x82\x04\u80bb", // 肻
	0x80bc: "\x82\x04\u80bc", // 肼
	0x80bd: "\x82\x04\u80bd", // 肽
	0x80be: "\x82\x04\u80be", // 肾
	0x80bf: "\x82\x04\u80bf", // 肿
	0x80c0: "\x82\x04\u80c0", // 胀
	0x80c1: "\x82\x04\u80c1", // 胁
	0x80c2: "\x82\x05\u80c2", // 胂
	0x80c3: "\x82\x05\u80c3", // 胃
	0x80c4: "\x82\x05\u80c4", // 胄
	0x80c5: "\x82\x05\u80c5", // 胅
	0x80c6: "\x82\x05\u80c6", // 胆
	0x80c7: "\x82\x05\u80c7", // 胇
	0x80c8: "\x82\x05\u80c8", // 胈
	0x80c9: "\x82\x05\u80c9", // 胉
	0x80ca: "\x82\x05\u80ca", // 胊
	0x80cb: "\x82\x05\u80cb", // 胋
	0x80cc: "\x82\x05\u80cc", // 背
	0x80cd: "\x82\x05\u80cd", // 胍
	0x80ce: "\x82\x05\u80ce", // 胎
	0x80cf: "\x82\x05\u80cf", // 胏
	0x80d0: "\x82\x05\u80d0", // 胐
	0x80d1: "\x82\x05\u80d1", // 胑
	0x80d2: "\x82\x05\u80d2", // 胒
	0x80d3: "\x82\x05\u80d3", // 胓
	0x80d4: "\x82\x05\u80d4", // 胔
	0x80d5: "\x82\x05\u80d5", // 胕
	0x80d6: "\x82\x05\u80d6", // 胖
	0x80d7: "\x82\x05\u80d7", // 胗
	0x80d8: "\x82\x05\u80d8", // 胘
	0x80d9: "\x82\x05\u80d9", // 胙
	0x80da: "\x82\x05\u80da", // 胚
	0x80db: "\x82\x05\u80db", // 胛
	0x80dc: "\x82\x05\u80dc", // 胜
	0x80dd: "\x82\x05\u80dd", // 胝
	0x80de: "\x82\x05\u80de", // 胞
	0x80df: "\x82\x05\u80df", // 胟
	0x80e0: "\x82\x05\u80e0", // 胠
	0x80e1: "\x82\x05\u80e1", // 胡
	0x80e2: "\x82\x05\u80e2", // 胢
	0x80e3: "\x82\x05\u80e3", // 胣
	0x80e4: "\x82\x05\u80e4", // 胤
	0x80e5: "\x82\x05\u80e5", // 胥
	0x80e6: "\x82\x05\u80e6", // 胦
	0x80e7: "\x82\x05\u80e7", // 胧
	0x80e8: "\x82\x05\u80e8", // 胨
	0x80e9: "\x82\x05\u80e9", // 胩
	0x80ea: "\x82\x05\u80ea", // 胪
	0x80eb: "\x82\x05\u80eb", // 胫
	0x80ec: "\x82\x05\u80ec", // 胬
	0x80ed: "\x82\x06\u80ed", // 胭
	0x80ee: "\x82\x06\u80ee", // 胮
	0x80ef: "\x82\x06\u80ef", // 胯
	0x80f0: "\x82\x06\u80f0", // 胰
	0x80f1: "\x82\x06\u80f1", // 胱
	0x80f2: "\x82\x06\u80f2", // 胲
	0x80f3: "\x82\x06\u80f3", // 胳
	0x80f4: "\x82\x06\u80f4", // 胴
	0x80f5: "\x82\x06\u80f5", // 胵
	0x80f6: "\x82\x06\u80f6", // 胶
	0x80f7: "\x82\x06\u80f7", // 胷
	0x80f8: "\x82\x06\u80f8", // 胸
	0x80f9: "\x82\x06\u80f9", // 胹
	0x80fa: "\x82\x06\u80fa", // 胺
	0x80fb: "\x82\x06\u80fb", // 胻
	0x80fc: "\x82\x06\u80fc", // 胼
	0x80fd: "\x82\x06\u80fd", // 能
	0x80fe: "\x82\x06\u80fe", // 胾
	0x80ff: "\x82\x06\u80ff", // 胿
	0x8100: "\x82\x06\u8100", // 脀
	0x8101: "\x82\x06\u8101", // 脁
	0x8102: "\x82\x06\u8102", // 脂
	0x8103: "\x82\x06\u8103", // 脃
	0x8104: "\x82\x06\u8104", // 脄
	0x8105: "\x82\x06\u8105", // 脅
	0x8106: "\x82\x06\u8106", // 脆
	0x8107: "\x82\x06\u8107", // 脇
	0x8108: "\x82\x06\u8108", // 脈
	0x8109: "\x82\x05\u8109", // 脉
	0x810a: "\x82\x06\u810a", // 脊
	0x810b: "\x82\x06\u810b", // 脋
	0x810c: "\x82\x06\u810c", // 脌
	0x810d: "\x82\x06\u810d", // 脍
	0x810e: "\x82\x06\u810e", // 脎
	0x810f: "\x82\x06\u810f", // 脏
	0x8110: "\x82\x06\u8110", // 脐
	0x8111: "\x82\x06\u8111", // 脑
	0x8112: "\x82\x06\u8112", // 脒
	0x8113: "\x82\x06\u8113", // 脓
	0x8114: "\x82\x06\u8114", // 脔
	0x8115: "\x82\a\u8115", // 脕
	0x8116: "\x82\a\u8116", // 脖
	0x8117: "\x82\a\u8117", // 脗
	0x8118: "\x82\a\u8118", // 脘
	0x8119: "\x82\a\u8119", // 脙
	0x811a: "\x82\a\u811a", // 脚
	0x811b: "\x82\a\u811b", // 脛
	0x811c: "\x82\a\u811c", // 脜
	0x811d: "\x82\a\u811d", // 脝
	0x811e: "\x82\a\u811e", // 脞
	0x811f: "\x82\a\u811f", // 脟
	0x8120: "\x82\a\u8120", // 脠
	0x8121: "\x82\a\u8121", // 脡
	0x8122: "\x82\a\u8122", // 脢
	0x8123: "\x82\a\u8123", // 脣
	0x8124: "\x82\a\u8124", // 脤
	0x8125: "\x82\a\u8125", // 脥
	0x8126: "\x82\a\u8126", // 脦
	0x8127: "\x82\a\u8127", // 脧
	0x8128: "\x82\a\u8128", // 脨
	0x8129: "\x82\a\u8129", // 脩
	0x812a: "\x82\a\u812a", // 脪
	0x812b: "\x82\a\u812b", // 脫
	0x812c: "\x82\a\u812c", // 脬
	0x812d: "\x82\a\u812d", // 脭
	0x812e: "\x82\a\u812e", // 脮
	0x812f: "\x82\a\u812f", // 脯
	0x8130: "\x82\a\u8130", // 脰
	0x8131: "\x82\a\u8131", // 脱
	0x8132: "\x82\a\u8132", // 脲
	0x8133: "\x82\a\u8133", // 脳
	0x8134: "\x82\a\u8134", // 脴
	0x8135: "\x82\a\u8135", // 脵
	0x8136: "\x82\a\u8136", // 脶
	0x8137: "\x82\a\u8137", // 脷
	0x8138: "\x82\a\u8138", // 脸
	0x8139: "\x82\b\u8139", // 脹
	0x813a: "\x82\b\u813a", // 脺
	0x813b: "\x82\b\u813b", // 脻
	0x813c: "\x82\b\u813c", // 脼
	0x813d: "\x82\b\u813d", // 脽
	0x813e: "\x82\b\u813e", // 脾
	0x813f: "\x82\b\u813f", // 脿
	0x8140: "\x82\b\u8140", // 腀
	0x8141: "\x82\b\u8141", // 腁
	0x8142: "\x82\b\u8142", // 腂
	0x8143: "\x82\b\u8143", // 腃
	0x8144: "\x82\b\u8144", // 腄
	0x8145: "\x82\b\u8145", // 腅
	0x8146: "\x82\b\u8146", // 腆
	0x8147: "\x82\b\u8147", // 腇
	0x8148: "\x82\b\u8148", // 腈
	0x8149: "\x82\b\u8149", // 腉
	0x814a: "\x82\b\u814a", // 腊
	0x814b: "\x82\b\u814b", // 腋
	0x814c: "\x82\b\u814c", // 腌
	0x814d: "\x82\b\u814d", // 腍
	0x814e: "\x82\b\u814e", // 腎
	0x814f: "\x82\b\u814f", // 腏
	0x8150: "\x82\b\u8150", // 腐
	0x8151: "\x82\b\u8151", // 腑
	0x8152: "\x82\b\u8152", // 腒
	0x8153: "\x82\b\u8153", // 腓
	0x8154: "\x82\b\u8154", // 腔
	0x8155: "\x82\b\u8155", // 腕
	0x8156: "\x82\b\u8156", // 腖
	0x8157: "\x82\b\u8157", // 腗
	0x8158: "\x82\b\u8158", // 腘
	0x8159: "\x82\b\u8159", // 腙
	0x815a: "\x82\b\u815a", // 腚
	0x815b: "\x82\t\u815b", // 腛
	0x815c: "\x82\t\u815c", // 腜
	0x815d: "\x82\t\u815d", // 腝
	0x815e: "\x82\t\u815e", // 腞
	0x815f: "\x82\t\u815f", // 腟
	0x8160: "\x82\t\u8160", // 腠
	0x8161: "\x82\t\u8161", // 腡
	0x8162: "\x82\t\u8162", // 腢
	0x8163: "\x82\t\u8163", // 腣
	0x8164: "\x82\t\u8164", // 腤
	0x8165: "\x82\t\u8165", // 腥
	0x8166: "\x82\t\u8166", // 腦
	0x8167: "\x82\t\u8167", // 腧
	0x8168: "\x82\t\u8168", // 腨
	0x8169: "\x82\t\u8169", // 腩
	0x816a: "\x82\t\u816a", // 腪
	0x816b: "\x82\t\u816b", // 腫
	0x816c: "\x82\t\u816c", // 腬
	0x816d: "\x82\t\u816d", // 腭
	0x816e: "\x82\t\u816e", // 腮
	0x816f: "\x82\t\u816f", // 腯
	0x8170: "\x82\t\u8170", // 腰
	0x8171: "\x82\t\u8171", // 腱
	0x8172: "\x82\t\u8172", // 腲
	0x8173: "\x82\t\u8173", // 腳
	0x8174: "\x82\t\u8174", // 腴
	0x8175: "\x82\t\u8175", // 腵
	0x8176: "\x82\t\u8176", // 腶
	0x8177: "\x82\t\u8177", // 腷
	0x8178: "\x82\t\u8178", // 腸
	0x8179: "\x82\t\u8179", // 腹
	0x817a: "\x82\t\u817a", // 腺
	0x817b: "\x82\t\u817b", // 腻
	0x817c: "\x82\t\u817c", // 腼
	0x817d: "\x82\t\u817d", // 腽
	0x817e: "\x82\t\u817e", // 腾
	0x817f: "\x82\n\u817f", // 腿
	0x8180: "\x82\n\u8180", // 膀
	0x8181: "\x82\n\u8181", // 膁
	0x8182: "\x82\n\u8182", // 膂
	0x8183: "\x82\n\u8183", // 膃
	0x8184: "\x82\n\u8184", // 膄
	0x8185: "\x82\n\u8185", // 膅
	0x8186: "\x82\n\u8186", // 膆
	0x8187: "\x82\n\u8187", // 膇
	0x8188: "\x82\n\u8188", // 膈
	0x8189: "\x82\n\u8189", // 膉
	0x818a: "\x82\n\u818a", // 膊
	0x818b: "\x82\n\u818b", // 膋
	0x818c: "\x82\n\u818c", // 膌
	0x818d: "\x82\n\u818d", // 膍
	0x818e: "\x82\n\u818e", // 膎
	0x818f: "\x82\n\u818f", // 膏
	0x8190: "\x82\n\u8190", // 膐
	0x8191: "\x82\n\u8191", // 膑
	0x8192: "\x82\v\u8192", // 膒
	0x8193: "\x82\v\u8193", // 膓
	0x8194: "\x82\v\u8194", // 膔
	0x8195: "\x82\v\u8195", // 膕
	0x8196: "\x82\v\u8196", // 膖
	0x8197: "\x82\v\u8197", // 膗
	0x8198: "\x82\v\u8198", // 膘
	0x8199: "\x82\v\u8199", // 膙
	0x819a: "\x82\v\u819a", // 膚
	0x819b: "\x82\v\u819b", // 膛
	0x819c: "\x82\v\u819c", // 膜
	0x819d: "\x82\v\u819d", // 膝
	0x819e: "\x82\v\u819e", // 膞
	0x819f: "\x82\v\u819f", // 膟
	0x81a0: "\x82\v\u81a0", // 膠
	0x81a1: "\x82\v\u81a1", // 膡
	0x81a2: "\x82\v\u81a2", // 膢
	0x81a3: "\x82\v\u81a3", // 膣
	0x81a4: "J\v\u81a4", // 膤
	0x81a5: "\x82\f\u81a5", // 膥
	0x81a6: "\x82\f\u81a6", // 膦
	0x81a7: "\x82\f\u81a7", // 膧
	0x81a8: "\x82\f\u81a8", // 膨
	0x81a9: "\x82\f\u81a9", // 膩
	0x81aa: "\x82\f\u81aa", // 膪
	0x81ab: "\x82\f\u81ab", // 膫
	0x81ac: "\x82\f\u81ac", // 膬
	0x81ad: "\x82\f\u81ad", // 膭
	0x81ae: "\x82\f\u81ae", // 膮
	0x81af: "\x82\f\u81af", // 膯
	0x81b0: "\x82\f\u81b0", // 膰
	0x81b1: "\x82\f\u81b1", // 膱
	0x81b2: "\x82\f\u81b2", // 膲
	0x81b3: "\x82\f\u81b3", // 膳
	0x81b4: "\x82\f\u81b4", // 膴
	0x81b5: "\x82\f\u81b5", // 膵
	0x81b6: "\x82\f\u81b6", // 膶
	0x81b7: "\x82\r\u81b7", // 膷
	0x81b8: "\x82\r\u81b8", // 膸
	0x81b9: "\x82\r\u81b9", // 膹
	0x81ba: "\x82\r\u81ba", // 膺
	0x81bb: "\x82\r\u81bb", // 膻
	0x81bc: "\x82\r\u81bc", // 膼
	0x81bd: "\x82\r\u81bd", // 膽
	0x81be: "\x82\r\u81be", // 膾
	0x81bf: "\x82\r\u81bf", // 膿
	0x81c0: "\x82\r\u81c0", // 臀
	0x81c1: "\x82\r\u81c1", // 臁
	0x81c2: "\x82\r\u81c2", // 臂
	0x81c3: "\x82\r\u81c3", // 臃
	0x81c4: "\x82\r\u81c4", // 臄
	0x81c5: "\x82\r\u81c5", // 臅
	0x81c6: "\x82\r\u81c6", // 臆
	0x81c7: "\x82\r\u81c7", // 臇
	0x81c8: "\x82\r\u81c8", // 臈
	0x81c9: "\x82\r\u81c9", // 臉
	0x81ca: "\x82\r\u81ca", // 臊
	0x81cb: "\x82\r\u81cb", // 臋
	0x81cc: "\x82\r\u81cc", // 臌
	0x81cd: "\x82\x0e\u81cd", // 臍
	0x81ce: "\x82\x0e\u81ce", // 臎
	0x81cf: "\x82\x0e\u81cf", // 臏
	0x81d0: "\x82\x0e\u81d0", // 臐
	0x81d1: "\x82\x0e\u81d1", // 臑
	0x81d2: "\x82\x0e\u81d2", // 臒
	0x81d3: "\x82\x0e\u81d3", // 臓
	0x81d4: "\x82\x0f\u81d4", // 臔
	0x81d5: "\x82\x0f\u81d5", // 臕
	0x81d6: "\x82\x10\u81d6", // 臖
	0x81d7: "\x82\x0f\u81d7", // 臗
	0x81d8: "\x82\x0f\u81d8", // 臘
	0x81d9: "\x82\x10\u81d9", // 臙
	0x81da: "\x82\x10\u81da", // 臚
	0x81db: "\x82\x10\u81db", // 臛
	0x81dc: "\x82\x10\u81dc", // 臜
	0x81dd: "\x82\x11\u81dd", // 臝
	0x81de: "\x82\x12\u81de", // 臞
	0x81df: "\x82\x12\u81df", // 臟
	0x81e0: "\x82\x13\u81e0", // 臠
	0x81e1: "\x82\x13\u81e1", // 臡
	0x81e2: "\x82\x13\u81e2", // 臢
	0x81e3: "\x83\x00\u81e3", // 臣
	0x81e4: "\x83\x02\u81e4", // 臤
	0x81e5: "\x83\x02\u81e5", // 臥
	0x81e6: "\x83\x06\u81e6", // 臦
	0x81e7: "\x83\b\u81e7", // 臧
	0x81e8: "\x83\v\u81e8", // 臨
	0x81e9: "\x83\v\u81e9", // 臩
	0x81ea: "\x84\x00\u81ea", // 自
	0x81eb: "\x84\x01\u81eb", // 臫
	0x81ec: "\x84\x04\u81ec", // 臬
	0x81ed: "\x84\x04\u81ed", // 臭
	0x81ee: "\x84\x06\u81ee", // 臮
	0x81ef: "\x84\x06\u81ef", // 臯
	0x81f0: "\x84\x06\u81f0", // 臰
	0x81f1: "\x84\t\u81f1", // 臱
	0x81f2: "\x84\n\u81f2", // 臲
	0x81f3: "\x85\x00\u81f3", // 至
	0x81f4: "\x85\x03\u81f4", // 致
	0x81f5: "\x85\x06\u81f5", // 臵
	0x81f6: "\x85\x06\u81f6", // 臶
	0x81f7: "\x85\x06\u81f7", // 臷
	0x81f8: "\x85\x06\u81f8", // 臸
	0x81f9: "\x85\a\u81f9", // 臹
	0x81fa: "\x85\b\u81fa", // 臺
	0x81fb: "\x85\n\u81fb", // 臻
	0x81fc: "\x86\x00\u81fc", // 臼
	0x81fd: "\x86\x02\u81fd", // 臽
	0x81fe: "\x86\x02\u81fe", // 臾
	0x81ff: "\x86\x03\u81ff", // 臿
	0x8200: "\x86\x04\u8200", // 舀
	0x8201: "\x86\x04\u8201", // 舁
	0x8202: "\x86\x05\u8202", // 舂
	0x8203: "\x86\x06\u8203", // 舃
	0x8204: "\x86\x06\u8204", // 舄
	0x8205: "\x86\a\u8205", // 舅
	0x8206: "\x86\n\u8206", // 舆
	0x8207: "\x86\b\u8207", // 與
	0x8208: "\x86\t\u8208", // 興
	0x8209: "\x86\n\u8209", // 舉
	0x820a: "\x86\f\u820a", // 舊
	0x820b: "\x86\r\u820b", // 舋
	0x820c: "\x87\x00\u820c", // 舌
	0x820d: "\x87\x02\u820d", // 舍
	0x820e: "\x87\x02\u820e", // 舎
	0x820f: "\x87\x02\u820f", // 舏
	0x8210: "\x87\x04\u8210", // 舐
	0x8211: "\x87\x05\u8211", // 舑
	0x8212: "\x87\x06\u8212", // 舒
	0x8213: "\x87\b\u8213", // 舓
	0x8214: "\x87\b\u8214", // 舔
	0x8215: "\x87\b\u8215", // 舕
	0x8216: "\x87\t\u8216", // 舖
	0x8217: "\x87\t\u8217", // 舗
	0x8218: "\x87\n\u8218", // 舘
	0x8219: "\x87\f\u8219", // 舙
	0x821a: "\x87\r\u821a", // 舚
	0x821b: "\x88\x00\u821b", // 舛
	0x821c: "\x88\x06\u821c", // 舜
	0x821d: "\x88\a\u821d", // 舝
	0x821e: "\x88\b\u821e", // 舞
	0x821f: "\x89\x00\u821f", // 舟
	0x8220: "\x89\x02\u8220", // 舠
	0x8221: "\x89\x03\u8221", // 舡
	0x8222: "\x89\x03\u8222", // 舢
	0x8223: "\x89\x03\u8223", // 舣
	0x8224: "\x89\x03\u8224", // 舤
	0x8225: "\x89\x04\u8225", // 舥
	0x8226: "\x89\x04\u8226", // 舦
	0x8227: "\x89\x04\u8227", // 舧
	0x8228: "\x89\x04\u8228", // 舨
	0x8229: "\x89\x04\u8229", // 舩
	0x822a: "\x89\x04\u822a", // 航
	0x822b: "\x89\x04\u822b", // 舫
	0x822c: "\x89\x04\u822c", // 般
	0x822d: "\x89\x04\u822d", // 舭
	0x822e: "\x89\x04\u822e", // 舮
	0x822f: "\x89\x04\u822f", // 舯
	0x8230: "\x89\x04\u8230", // 舰
	0x8231: "\x89\x04\u8231", // 舱
	0x8232: "\x89\x05\u8232", // 舲
	0x8233: "\x89\x05\u8233", // 舳
	0x8234: "\x89\x05\u8234", // 舴
	0x8235: "\x89\x05\u8235", // 舵
	0x8236: "\x89\x05\u8236", // 舶
	0x8237: "\x89\x05\u8237", // 舷
	0x8238: "\x89\x05\u8238", // 舸
	0x8239: "\x89\x05\u8239", // 船
	0x823a: "\x89\x05\u823a", // 舺
	0x823b: "\x89\x05\u823b", // 舻
	0x823c: "\x89\x06\u823c", // 舼
	0x823d: "\x89\x06\u823d", // 舽
	0x823e: "\x89\x06\u823e", // 舾
	0x823f: "\x89\x06\u823f", // 舿
	0x8240: "\x89\a\u8240", // 艀
	0x8241: "\x89\a\u8241", // 艁
	0x8242: "\x89\a\u8242", // 艂
	0x8243: "\x89\a\u8243", // 艃
	0x8244: "\x89\a\u8244", // 艄
	0x8245: "\x89\a\u8245", // 艅
	0x8246: "\x89\a\u8246", // 艆
	0x8247: "\x89\a\u8247", // 艇
	0x8248: "\x89\a\u8248", // 艈
	0x8249: "\x89\a\u8249", // 艉
	0x824a: "\x89\b\u824a", // 艊
	0x824b: "\x89\b\u824b", // 艋
	0x824c: "\x89\b\u824c", // 艌
	0x824d: "\x89\b\u824d", // 艍
	0x824e: "\x89\t\u824e", // 艎
	0x824f: "\x89\t\u824f", // 艏
	0x8250: "\x89\t\u8250", // 艐
	0x8251: "\x89\t\u8251", // 艑
	0x8252: "\x89\t\u8252", // 艒
	0x8253: "\x89\t\u8253", // 艓
	0x8254: "\x89\t\u8254", // 艔
	0x8255: "\x89\n\u8255", // 艕
	0x8256: "\x89\n\u8256", // 艖
	0x8257: "\x89\n\u8257", // 艗
	0x8258: "\x89\n\u8258", // 艘
	0x8259: "\x89\n\u8259", // 艙
	0x825a: "\x89\v\u825a", // 艚
	0x825b: "\x89\v\u825b", // 艛
	0x825c: "\x89\v\u825c", // 艜
	0x825d: "\x89\v\u825d", // 艝
	0x825e: "\x89\f\u825e", // 艞
	0x825f: "\x89\f\u825f", // 艟
	0x8260: "\x89\f\u8260", // 艠
	0x8261: "\x89\r\u8261", // 艡
	0x8262: "\x89\r\u8262", // 艢
	0x8263: "\x89\r\u8263", // 艣
	0x8264: "\x89\r\u8264", // 艤
	0x8265: "\x89\r\u8265", // 艥
	0x8266: "\x89\x0e\u8266", // 艦
	0x8267: "\x89\x0e\u8267", // 艧
	0x8268: "\x89\x0e\u8268", // 艨
	0x8269: "\x89\x0e\u8269", // 艩
	0x826a: "\x89\x0f\u826a", // 艪
	0x826b: "\x89\x10\u826b", // 艫
	0x826c: "\x89\x11\u826c", // 艬
	0x826d: "\x89\x12\u826d", // 艭
	0x826e: "\x8a\x00\u826e", // 艮
	0x826f: "\x8a\x01\u826f", // 良
	0x8270: "\x8a\x02\u8270", // 艰
	0x8271: "\x8a\v\u8271", // 艱
	0x8272: "\x8b\x00\u8272", // 色
	0x8273: "\x8b\x04\u8273", // 艳
	0x8274: "\x8b\x05\u8274", // 艴
	0x8275: "\x8b\b\u8275", // 艵
	0x8276: "\x8b\r\u8276", // 艶
	0x8277: "\x8b\x12\u8277", // 艷
	0x8278: "\x8c\x00\u8278", // 艸
	0x8279: "\x8c\x00\u8279", // 艹
	0x827a: "\x8c\x01\u827a", // 艺
	0x827b: "\x8c\x02\u827b", // 艻
	0x827c: "\x8c\x02\u827c", // 艼
	0x827d: "\x8c\x02\u827d", // 艽
	0x827e: "\x8c\x02\u827e", // 艾
	0x827f: "\x8c\x02\u827f", // 艿
	0x8280: "\x8c\x02\u8280", // 芀
	0x8281: "\x8c\x02\u8281", // 芁
	0x8282: "\x8c\x02\u8282", // 节
	0x8283: "\x8c\x03\u8283", // 芃
	0x8284: "\x8c\x03\u8284", // 芄
	0x8285: "\x8c\x03\u8285", // 芅
	0x8286: "\x8c\x03\u8286", // 芆
	0x8287: "\x8c\x03\u8287", // 芇
	0x8288: "\x8c\x03\u8288", // 芈
	0x8289: "\x8c\x03\u8289", // 芉
	0x828a: "\x8c\x03\u828a", // 芊
	0x828b: "\x8c\x03\u828b", // 芋
	0x828c: "\x8c\x03\u828c", // 芌
	0x828d: "\x8c\x03\u828d", // 芍
	0x828e: "\x8c\x03\u828e", // 芎
	0x828f: "\x8c\x03\u828f", // 芏
	0x8290: "\x8c\x03\u8290", // 芐
	0x8291: "\x8c\x03\u8291", // 芑
	0x8292: "\x8c\x03\u8292", // 芒
	0x8293: "\x8c\x03\u8293", // 芓
	0x8294: "\x8c\x03\u8294", // 芔
	0x8295: "\x8c\x03\u8295", // 芕
	0x8296: "\x8c\x03\u8296", // 芖
	0x8297: "\x8c\x03\u8297", // 芗
	0x8298: "\x8c\x04\u8298", // 芘
	0x8299: "\x8c\x04\u8299", // 芙
	0x829a: "\x8c\x04\u829a", // 芚
	0x829b: "\x8c\x04\u829b", // 芛
	0x829c: "\x8c\x04\u829c", // 芜
	0x829d: "\x8c\x04\u829d", // 芝
	0x829e: "\x8c\x04\u829e", // 芞
	0x829f: "\x8c\x04\u829f", // 芟
	0x82a0: "\x8c\x04\u82a0", // 芠
	0x82a1: "\x8c\x04\u82a1", // 芡
	0x82a2: "\x8c\x04\u82a2", // 芢
	0x82a3: "\x8c\x04\u82a3", // 芣
	0x82a4: "\x8c\x04\u82a4", // 芤
	0x82a5: "\x8c\x04\u82a5", // 芥
	0x82a6: "\x8c\x04\u82a6", // 芦
	0x82a7: "\x8c\x04\u82a7", // 芧
	0x82a8: "\x8c\x04\u82a8", // 芨
	0x82a9: "\x8c\x04\u82a9", // 芩
	0x82aa: "\x8c\x04\u82aa", // 芪
	0x82ab: "\x8c\x04\u82ab", // 芫
	0x82ac: "\x8c\x04\u82ac", // 芬
	0x82ad: "\x8c\x04\u82ad", // 芭
	0x82ae: "\x8c\x04\u82ae", // 芮
	0x82af: "\x8c\x04\u82af", // 芯
	0x82b0: "\x8c\x04\u82b0", // 芰
	0x82b1: "\x8c\x04\u82b1", // 花
	0x82b2: "\x8c\x04\u82b2", // 芲
	0x82b3: "\x8c\x04\u82b3", // 芳
	0x82b4: "\x8c\x04\u82b4", // 芴
	0x82b5: "\x8c\x04\u82b5", // 芵
	0x82b6: "\x8c\x04\u82b6", // 芶
	0x82b7: "\x8c\x04\u82b7", // 芷
	0x82b8: "\x8c\x04\u82b8", // 芸
	0x82b9: "\x8c\x04\u82b9", // 芹
	0x82ba: "\x8c\x04\u82ba", // 芺
	0x82bb: "\x8c\x04\u82bb", // 芻
	0x82bc: "\x8c\x04\u82bc", // 芼
	0x82bd: "\x8c\x04\u82bd", // 芽
	0x82be: "\x8c\x04\u82be", // 芾
	0x82bf: "\x8c\x05\u82bf", // 芿
	0x82c0: "\x8c\x04\u82c0", // 苀
	0x82c1: "\x8c\x04\u82c1", // 苁
	0x82c2: "\x8c\x04\u82c2", // 苂
	0x82c3: "\x8c\x04\u82c3", // 苃
	0x82c4: "\x8c\x04\u82c4", // 苄
	0x82c5: "\x8c\x04\u82c5", // 苅
	0x82c6: "\x8c\x04\u82c6", // 苆
	0x82c7: "\x8c\x04\u82c7", // 苇
	0x82c8: "\x8c\x04\u82c8", // 苈
	0x82c9: "\x8c\x04\u82c9", // 苉
	0x82ca: "\x8c\x04\u82ca", // 苊
	0x82cb: "\x8c\x04\u82cb", // 苋
	0x82cc: "\x8c\x04\u82cc", // 苌
	0x82cd: "\x8c\x04\u82cd", // 苍
	0x82ce: "\x8c\x04\u82ce", // 苎
	0x82cf: "\x8c\x04\u82cf", // 苏
	0x82d0: "\x8c\x05\u82d0", // 苐
	0x82d1: "\x8c\x05\u82d1", // 苑
	0x82d2: "\x8c\x05\u82d2", // 苒
	0x82d3: "\x8c\x05\u82d3", // 苓
	0x82d4: "\x8c\x05\u82d4", // 苔
	0x82d5: "\x8c\x05\u82d5", // 苕
	0x82d6: "\x8c\x05\u82d6", // 苖
	0x82d7: "\x8c\x05\u82d7", // 苗
	0x82d8: "\x8c\x05\u82d8", // 苘
	0x82d9: "\x8c\x05\u82d9", // 苙
	0x82da: "\x8c\x05\u82da", // 苚
	0x82db: "\x8c\x05\u82db", // 苛
	0x82dc: "\x8c\x05\u82dc", // 苜
	0x82dd: "\x8c\x05\u82dd", // 苝
	0x82de: "\x8c\x05\u82de", // 苞
	0x82df: "\x8c\x05\u82df", // 苟
	0x82e0: "\x8c\x05\u82e0", // 苠
	0x82e1: "\x8c\x05\u82e1", // 苡
	0x82e2: "\x8c\x05\u82e2", // 苢
	0x82e3: "\x8c\x05\u82e3", // 苣
	0x82e4: "\x8c\x05\u82e4", // 苤
	0x82e5: "\x8c\x05\u82e5", // 若
	0x82e6: "\x8c\x05\u82e6", // 苦
	0x82e7: "\x8c\x05\u82e7", // 苧
	0x82e8: "\x8c\x05\u82e8", // 苨
	0x82e9: "\x8c\x05\u82e9", // 苩
	0x82ea: "\x8c\x05\u82ea", // 苪
	0x82eb: "\x8c\x05\u82eb", // 苫
	0x82ec: "\x8c\x05\u82ec", // 苬
	0x82ed: "\x8c\x05\u82ed", // 苭
	0x82ee: "\x8c\x05\u82ee", // 苮
	0x82ef: "\x8c\x05\u82ef", // 苯
	0x82f0: "\x8c\x05\u82f0", // 苰
	0x82f1: "\x8c\x05\u82f1", // 英
	0x82f2: "\x8c\x05\u82f2", // 苲
	0x82f3: "\x8c\x05\u82f3", // 苳
	0x82f4: "\x8c\x05\u82f4", // 苴
	0x82f5: "\x8c\x05\u82f5", // 苵
	0x82f6: "\x8c\x05\u82f6", // 苶
	0x82f7: "\x8c\x05\u82f7", // 苷
	0x82f8: "\x8c\x05\u82f8", // 苸
	0x82f9: "\x8c\x05\u82f9", // 苹
	0x82fa: "\x8c\x05\u82fa", // 苺
	0x82fb: "\x8c\x05\u82fb", // 苻
	0x82fc: "\x8c\x05\u82fc", // 苼
	0x82fd: "\x8c\x05\u82fd", // 苽
	0x82fe: "\x8c\x05\u82fe", // 苾
	0x82ff: "\x8c\x05\u82ff", // 苿
	0x8300: "\x8c\x05\u8300", // 茀
	0x8301: "\x8c\x05\u8301", // 茁
	0x8302: "\x8c\x05\u8302", // 茂
	0x8303: "\x8c\x05\u8303", // 范
	0x8304: "\x8c\x05\u8304", // 茄
	0x8305: "\x8c\x05\u8305", // 茅
	0x8306: "\x8c\x05\u8306", // 茆
	0x8307: "\x8c\x05\u8307", // 茇
	0x8308: "\x8c\x05\u8308", // 茈
	0x8309: "\x8c\x05\u8309", // 茉
	0x830a: "\x8c\x05\u830a", // 茊
	0x830b: "\x8c\x05\u830b", // 茋
	0x830c: "\x8c\x05\u830c", // 茌
	0x830d: "\x8c\x05\u830d", // 茍
	0x830e: "\x8c\x05\u830e", // 茎
	0x830f: "\x8c\x05\u830f", // 茏
	0x8310: "\x8c\x05\u8310", // 茐
	0x8311: "\x8c\x05\u8311", // 茑
	0x8312: "\x8c\x06\u8312", // 茒
	0x8313: "\x8c\x05\u8313", // 茓
	0x8314: "\x8c\x05\u8314", // 茔
	0x8315: "\x8c\x05\u8315", // 茕
	0x8316: "\x8c\x06\u8316", // 茖
	0x8317: "\x8c\x06\u8317", // 茗
	0x8318: "\x8c\x06\u8318", // 茘
	0x8319: "\x8c\x06\u8319", // 茙
	0x831a: "\x8c\x06\u831a", // 茚
	0x831b: "\x8c\x06\u831b", // 茛
	0x831c: "\x8c\x06\u831c", // 茜
	0x831d: "\x8c\a\u831d", // 茝
	0x831e: "\x8c\x06\u831e", // 茞
	0x831f: "\x8c\x06\u831f", // 茟
	0x8320: "\x8c\x06\u8320", // 茠
	0x8321: "\x8c\x06\u8321", // 茡
	0x8322: "\x8c\x06\u8322", // 茢
	0x8323: "\x8c\a\u8323", // 茣
	0x8324: "\x8c\x06\u8324", // 茤
	0x8325: "\x8c\x06\u8325", // 茥
	0x8326: "\x8c\x06\u8326", // 茦
	0x8327: "\x8c\x06\u8327", // 茧
	0x8328: "\x8c\x06\u8328", // 茨
	0x8329: "\x8c\x06\u8329", // 茩
	0x832a: "\x8c\x06\u832a", // 茪
	0x832b: "\x8c\x06\u832b", // 茫
	0x832c: "\x8c\x06\u832c", // 茬
	0x832d: "\x8c\x06\u832d", // 茭
	0x832e: "\x8c\x06\u832e", // 茮
	0x832f: "\x8c\x06\u832f", // 茯
	0x8330: "\x8c\x06\u8330", // 茰
	0x8331: "\x8c\x06\u8331", // 茱
	0x8332: "\x8c\x06\u8332", // 茲
	0x8333: "\x8c\x06\u8333", // 茳
	0x8334: "\x8c\x06\u8334", // 茴
	0x8335: "\x8c\x06\u8335", // 茵
	0x8336: "\x8c\x06\u8336", // 茶
	0x8337: "\x8c\x06\u8337", // 茷
	0x8338: "\x8c\x06\u8338", // 茸
	0x8339: "\x8c\x06\u8339", // 茹
	0x833a: "\x8c\x06\u833a", // 茺
	0x833b: "\x8c\x06\u833b", // 茻
	0x833c: "\x8c\x06\u833c", // 茼
	0x833d: "\x8c\x06\u833d", // 茽
	0x833e: "\x8c\x04\u833e", // 茾
	0x833f: "\x8c\x06\u833f", // 茿
	0x8340: "\x8c\x06\u8340", // 荀
	0x8341: "\x8c\x06\u8341", // 荁
	0x8342: "\x8c\x06\u8342", // 荂
	0x8343: "\x8c\x06\u8343", // 荃
	0x8344: "\x8c\x06\u8344", // 荄
	0x8345: "\x8c\x06\u8345", // 荅
	0x8346: "\x8c\x06\u8346", // 荆
	0x8347: "\x8c\x06\u8347", // 荇
	0x8348: "\x8c\x06\u8348", // 荈
	0x8349: "\x8c\x06\u8349", // 草
	0x834a: "\x8c\x06\u834a", // 荊
	0x834b: "\x8c\x06\u834b", // 荋
	0x834c: "\x8c\x06\u834c", // 荌
	0x834d: "\x8c\x06\u834d", // 荍
	0x834e: "\x8c\x06\u834e", // 荎
	0x834f: "\x8c\x06\u834f", // 荏
	0x8350: "\x8c\x06\u8350", // 荐
	0x8351: "\x8c\x06\u8351", // 荑
	0x8352: "\x8c\x06\u8352", // 荒
	0x8353: "\x8c\b\u8353", // 荓
	0x8354: "\x8c\x06\u8354", // 荔
	0x8355: "\x8c\x06\u8355", // 荕
	0x8356: "\x8c\x06\u8356", // 荖
	0x8357: "\x8c\x06\u8357", // 荗
	0x8358: "\x8c\x06\u8358", // 荘
	0x8359: "\x8c\x06\u8359", // 荙
	0x835a: "\x8c\x06\u835a", // 荚
	0x835b: "\x8c\x06\u835b", // 荛
	0x835c: "\x8c\x06\u835c", // 荜
	0x835d: "\x8c\x06\u835d", // 荝
	0x835e: "\x8c\x06\u835e", // 荞
	0x835f: "\x8c\x06\u835f", // 荟
	0x8360: "\x8c\x06\u8360", // 荠
	0x8361: "\x8c\x06\u8361", // 荡
	0x8362: "\x8c\x06\u8362", // 荢
	0x8363: "\x8c\x06\u8363", // 荣
	0x8364: "\x8c\x06\u8364", // 荤
	0x8365: "\x8c\x06\u8365", // 荥
	0x8366: "\x8c\x06\u8366", // 荦
	0x8367: "\x8c\x06\u8367", // 荧
	0x8368: "\x8c\x06\u8368", // 荨
	0x8369: "\x8c\x06\u8369", // 荩
	0x836a: "\x8c\x06\u836a", // 荪
	0x836b: "\x8c\x06\u836b", // 荫
	0x836c: "\x8c\x06\u836c", // 荬
	0x836d: "\x8c\x06\u836d", // 荭
	0x836e: "\x8c\x06\u836e", // 荮
	0x836f: "\x8c\x06\u836f", // 药
	0x8370: "\x8c\a\u8370", // 荰
	0x8371: "\x8c\a\u8371", // 荱
	0x8372: "\x8c\a\u8372", // 荲
	0x8373: "\x8c\a\u8373", // 荳
	0x8374: "\x8c\a\u8374", // 荴
	0x8375: "\x8c\a\u8375", // 荵
	0x8376: "\x8c\a\u8376", // 荶
	0x8377: "\x8c\a\u8377", // 荷
	0x8378: "\x8c\a\u8378", // 荸
	0x8379: "\x8c\a\u8379", // 荹
	0x837a: "\x8c\a\u837a", // 荺
	0x837b: "\x8c\a\u837b", // 荻
	0x837c: "\x8c\a\u837c", // 荼
	0x837d: "\x8c\a\u837d", // 荽
	0x837e: "\x8c\a\u837e", // 荾
	0x837f: "\x8c\a\u837f", // 荿
	0x8380: "\x8c\a\u8380", // 莀
	0x8381: "\x8c\a\u8381", // 莁
	0x8382: "\x8c\a\u8382", // 莂
	0x8383: "\x8c\a\u8383", // 莃
	0x8384: "\x8c\a\u8384", // 莄
	0x8385: "\x8c\a\u8385", // 莅
	0x8386: "\x8c\a\u8386", // 莆
	0x8387: "\x8c\a\u8387", // 莇
	0x8388: "\x8c\a\u8388", // 莈
	0x8389: "\x8c\a\u8389", // 莉
	0x838a: "\x8c\a\u838a", // 莊
	0x838b: "\x8c\a\u838b", // 莋
	0x838c: "\x8c\a\u838c", // 莌
	0x838d: "\x8c\a\u838d", // 莍
	0x838e: "\x8c\a\u838e", // 莎
	0x838f: "\x8c\a\u838f", // 莏
	0x8390: "\x8c\a\u8390", // 莐
	0x8391: "\x8c\a\u8391", // 莑
	0x8392: "\x8c\a\u8392", // 莒
	0x8393: "\x8c\a\u8393", // 莓
	0x8394: "\x8c\a\u8394", // 莔
	0x8395: "\x8c\a\u8395", // 莕
	0x8396: "\x8c\a\u8396", // 莖
	0x8397: "\x8c\a\u8397", // 莗
	0x8398: "\x8c\a\u8398", // 莘
	0x8399: "\x8c\a\u8399", // 莙
	0x839a: "\x8c\a\u839a", // 莚
	0x839b: "\x8c\a\u839b", // 莛
	0x839c: "\x8c\a\u839c", // 莜
	0x839d: "\x8c\a\u839d", // 莝
	0x839e: "\x8c\a\u839e", // 莞
	0x839f: "\x8c\a\u839f", // 莟
	0x83a0: "\x8c\a\u83a0", // 莠
	0x83a1: "\x8c\a\u83a1", // 莡
	0x83a2: "\x8c\a\u83a2", // 莢
	0x83a3: "\x8c\a\u83a3", // 莣
	0x83a4: "\x8c\a\u83a4", // 莤
	0x83a5: "\x8c\a\u83a5", // 莥
	0x83a6: "\x8c\a\u83a6", // 莦
	0x83a7: "\x8c\a\u83a7", // 莧
	0x83a8: "\x8c\a\u83a8", // 莨
	0x83a9: "\x8c\a\u83a9", // 莩
	0x83aa: "\x8c\a\u83aa", // 莪
	0x83ab: "\x8c\a\u83ab", // 莫
	0x83ac: "\x8c\a\u83ac", // 莬
	0x83ad: "\x8c\t\u83ad", // 莭
	0x83ae: "\x8c\a\u83ae", // 莮
	0x83af: "\x8c\a\u83af", // 莯
	0x83b0: "\x8c\a\u83b0", // 莰
	0x83b1: "\x8c\a\u83b1", // 莱
	0x83b2: "\x8c\a\u83b2", // 莲
	0x83b3: "\x8c\a\u83b3", // 莳
	0x83b4: "\x8c\a\u83b4", // 莴
	0x83b5: "\x8c\a\u83b5", // 莵
	0x83b6: "\x8c\a\u83b6", // 莶
	0x83b7: "\x8c\a\u83b7", // 获
	0x83b8: "\x8c\a\u83b8", // 莸
	0x83b9: "\x8c\a\u83b9", // 莹
	0x83ba: "\x8c\a\u83ba", // 莺
	0x83bb: "\x8c\a\u83bb", // 莻
	0x83bc: "\x8c\a\u83bc", // 莼
	0x83bd: "\x8c\a\u83bd", // 莽
	0x83be: "\x8c\b\u83be", // 莾
	0x83bf: "\x8c\b\u83bf", // 莿
	0x83c0: "\x8c\b\u83c0", // 菀
	0x83c1: "\x8c\b\u83c1", // 菁
	0x83c2: "\x8c\b\u83c2", // 菂
	0x83c3: "\x8c\b\u83c3", // 菃
	0x83c4: "\x8c\b\u83c4", // 菄
	0x83c5: "\x8c\b\u83c5", // 菅
	0x83c6: "\x8c\b\u83c6", // 菆
	0x83c7: "\x8c\b\u83c7", // 菇
	0x83c8: "\x8c\b\u83c8", // 菈
	0x83c9: "\x8c\b\u83c9", // 菉
	0x83ca: "\x8c\b\u83ca", // 菊
	0x83cb: "\x8c\b\u83cb", // 菋
	0x83cc: "\x8c\b\u83cc", // 菌
	0x83cd: "\x8c\b\u83cd", // 菍
	0x83ce: "\x8c\b\u83ce", // 菎
	0x83cf: "\x8c\b\u83cf", // 菏
	0x83d0: "\x8c\b\u83d0", // 菐
	0x83d1: "\x8c\b\u83d1", // 菑
	0x83d2: "\x8c\b\u83d2", // 菒
	0x83d3: "\x8c\b\u83d3", // 菓
	0x83d4: "\x8c\b\u83d4", // 菔
	0x83d5: "\x8c\b\u83d5", // 菕
	0x83d6: "\x8c\b\u83d6", // 菖
	0x83d7: "\x8c\b\u83d7", // 菗
	0x83d8: "\x8c\b\u83d8", // 菘
	0x83d9: "\x8c\b\u83d9", // 菙
	0x83da: "\x8c\b\u83da", // 菚
	0x83db: "\x8c\b\u83db", // 菛
	0x83dc: "\x8c\b\u83dc", // 菜
	0x83dd: "\x8c\b\u83dd", // 菝
	0x83de: "\x8c\b\u83de", // 菞
	0x83df: "\x8c\b\u83df", // 菟
	0x83e0: "\x8c\b\u83e0", // 菠
	0x83e1: "\x8c\b\u83e1", // 菡
	0x83e2: "\x8c\b\u83e2", // 菢
	0x83e3: "\x8c\b\u83e3", // 菣
	0x83e4: "\x8c\b\u83e4", // 菤
	0x83e5: "\x8c\b\u83e5", // 菥
	0x83e6: "\x8c\b\u83e6", // 菦
	0x83e7: "\x8c\b\u83e7", // 菧
	0x83e8: "\x8c\b\u83e8", // 菨
	0x83e9: "\x8c\b\u83e9", // 菩
	0x83ea: "\x8c\b\u83ea", // 菪
	0x83eb: "\x8c\b\u83eb", // 菫
	0x83ec: "\x8c\b\u83ec", // 菬
	0x83ed: "\x8c\b\u83ed", // 菭
	0x83ee: "\x8c\b\u83ee", // 菮
	0x83ef: "\x8c\b\u83ef", // 華
	0x83f0: "\x8c\b\u83f0", // 菰
	0x83f1: "\x8c\b\u83f1", // 菱
	0x83f2: "\x8c\b\u83f2", // 菲
	0x83f3: "\x8c\b\u83f3", // 菳
	0x83f4: "\x8c\b\u83f4", // 菴
	0x83f5: "\x8c\b\u83f5", // 菵
	0x83f6: "\x8c\b\u83f6", // 菶
	0x83f7: "\x8c\b\u83f7", // 菷
	0x83f8: "\x8c\b\u83f8", // 菸
	0x83f9: "\x8c\b\u83f9", // 菹
	0x83fa: "\x8c\b\u83fa", // 菺
	0x83fb: "\x8c\b\u83fb", // 菻
	0x83fc: "\x8c\b\u83fc", // 菼
	0x83fd: "\x8c\b\u83fd", // 菽
	0x83fe: "\x8c\b\u83fe", // 菾
	0x83ff: "\x8c\b\u83ff", // 菿
	0x8400: "\x8c\b\u8400", // 萀
	0x8401: "\x8c\b\u8401", // 萁
	0x8402: "\x8c\b\u8402", // 萂
	0x8403: "\x8c\b\u8403", // 萃
	0x8404: "\x8c\b\u8404", // 萄
	0x8405: "\x8c\b\u8405", // 萅
	0x8406: "\x8c\b\u8406", // 萆
	0x8407: "\x8c\b\u8407", // 萇
	0x8408: "\x8c\b\u8408", // 萈
	0x8409: "\x8c\b\u8409", // 萉
	0x840a: "\x8c\b\u840a", // 萊
	0x840b: "\x8c\b\u840b", // 萋
	0x840c: "\x8c\b\u840c", // 萌
	0x840d: "\x8c\b\u840d", // 萍
	0x840e: "\x8c\b\u840e", // 萎
	0x840f: "\x8c\b\u840f", // 萏
	0x8410: "\x8c\b\u8410", // 萐
	0x8411: "\x8c\b\u8411", // 萑
	0x8412: "\x8c\b\u8412", // 萒
	0x8413: "\x8c\b\u8413", // 萓
	0x8414: "\x8c\b\u8414", // 萔
	0x8415: "\x8c\b\u8415", // 萕
	0x8416: "\x8c\b\u8416", // 萖
	0x8417: "\x8c\b\u8417", // 萗
	0x8418: "\x8c\b\u8418", // 萘
	0x8419: "\x8c\b\u8419", // 萙
	0x841a: "\x8c\b\u841a", // 萚
	0x841b: "\x8c\b\u841b", // 萛
	0x841c: "\x8c\b\u841c", // 萜
	0x841d: "\x8c\b\u841d", // 萝
	0x841e: "\x8c\b\u841e", // 萞
	0x841f: "\x8c\b\u841f", // 萟
	0x8420: "\x8c\b\u8420", // 萠
	0x8421: "\x8c\b\u8421", // 萡
	0x8422: "\x8c\b\u8422", // 萢
	0x8423: "\x8c\b\u8423", // 萣
	0x8424: "\x8c\b\u8424", // 萤
	0x8425: "\x8c\b\u8425", // 营
	0x8426: "\x8c\b\u8426", // 萦
	0x8427: "\x8c\b\u8427", // 萧
	0x8428: "\x8c\b\u8428", // 萨
	0x8429: "\x8c\t\u8429", // 萩
	0x842a: "\x8c\t\u842a", // 萪
	0x842b: "\x8c\t\u842b", // 萫
	0x842c: "r\b\u842c", // 萬
	0x842d: "\x8c\t\u842d", // 萭
	0x842e: "\x8c\t\u842e", // 萮
	0x842f: "\x8c\t\u842f", // 萯
	0x8430: "\x8c\t\u8430", // 萰
	0x8431: "\x8c\t\u8431", // 萱
	0x8432: "\x8c\t\u8432", // 萲
	0x8433: "\x8c\t\u8433", // 萳
	0x8434: "\x8c\t\u8434", // 萴
	0x8435: "\x8c\t\u8435", // 萵
	0x8436: "\x8c\t\u8436", // 萶
	0x8437: "\x8c\t\u8437", // 萷
	0x8438: "\x8c\t\u8438", // 萸
	0x8439: "\x8c\t\u8439", // 萹
	0x843a: "\x8c\t\u843a", // 萺
	0x843b: "\x8c\t\u843b", // 萻
	0x843c: "\x8c\t\u843c", // 萼
	0x843d: "\x8c\t\u843d", // 落
	0x843e: "\x8c\t\u843e", // 萾
	0x843f: "\x8c\t\u843f", // 萿
	0x8440: "\x8c\t\u8440", // 葀
	0x8441: "\x8c\t\u8441", // 葁
	0x8442: "\x8c\t\u8442", // 葂
	0x8443: "\x8c\t\u8443", // 葃
	0x8444: "\x8c\t\u8444", // 葄
	0x8445: "\x8c\t\u8445", // 葅
	0x8446: "\x8c\t\u8446", // 葆
	0x8447: "\x8c\t\u8447", // 葇
	0x8448: "\x8c\t\u8448", // 葈
	0x8449: "\x8c\t\u8449", // 葉
	0x844a: "\x8c\t\u844a", // 葊
	0x844b: "\x8c\t\u844b", // 葋
	0x844c: "\x8c\t\u844c", // 葌
	0x844d: "\x8c\t\u844d", // 葍
	0x844e: "\x8c\t\u844e", // 葎
	0x844f: "\x8c\t\u844f", // 葏
	0x8450: "\x8c\t\u8450", // 葐
	0x8451: "\x8c\t\u8451", // 葑
	0x8452: "\x8c\t\u8452", // 葒
	0x8453: "\x8c\t\u8453", // 葓
	0x8454: "\x8c\t\u8454", // 葔
	0x8455: "\x8c\t\u8455", // 葕
	0x8456: "\x8c\t\u8456", // 葖
	0x8457: "\x8c\b\u8457", // 著
	0x8458: "\x8c\t\u8458", // 葘
	0x8459: "\x8c\t\u8459", // 葙
	0x845a: "\x8c\t\u845a", // 葚
	0x845b: "\x8c\t\u845b", // 葛
	0x845c: "\x8c\t\u845c", // 葜
	0x845d: "\x8c\t\u845d", // 葝
	0x845e: "\x8c\t\u845e", // 葞
	0x845f: "\x8c\t\u845f", // 葟
	0x8460: "\x8c\t\u8460", // 葠
	0x8461: "\x8c\t\u8461", // 葡
	0x8462: "\x8c\t\u8462", // 葢
	0x8463: "\x8c\t\u8463", // 董
	0x8464: "\x8c\t\u8464", // 葤
	0x8465: "\x8c\t\u8465", // 葥
	0x8466: "\x8c\t\u8466", // 葦
	0x8467: "\x8c\t\u8467", // 葧
	0x8468: "\x8c\t\u8468", // 葨
	0x8469: "\x8c\t\u8469", // 葩
	0x846a: "\x8c\t\u846a", // 葪
	0x846b: "\x8c\t\u846b", // 葫
	0x846c: "\x8c\t\u846c", // 葬
	0x846d: "\x8c\t\u846d", // 葭
	0x846e: "\x8c\t\u846e", // 葮
	0x846f: "\x8c\t\u846f", // 葯
	0x8470: "\x8c\t\u8470", // 葰
	0x8471: "\x8c\t\u8471", // 葱
	0x8472: "\x8c\t\u8472", // 葲
	0x8473: "\x8c\t\u8473", // 葳
	0x8474: "\x8c\t\u8474", // 葴
	0x8475: "\x8c\t\u8475", // 葵
	0x8476: "\x8c\t\u8476", // 葶
	0x8477: "\x8c\t\u8477", // 葷
	0x8478: "\x8c\t\u8478", // 葸
	0x8479: "\x8c\t\u8479", // 葹
	0x847a: "\x8c\t\u847a", // 葺
	0x847b: "\x8c\t\u847b", // 葻
	0x847c: "\x8c\t\u847c", // 葼
	0x847d: "\x8c\t\u847d", // 葽
	0x847e: "\x8c\t\u847e", // 葾
	0x847f: "\x8c\t\u847f", // 葿
	0x8480: "\x8c\t\u8480", // 蒀
	0x8481: "\x8c\t\u8481", // 蒁
	0x8482: "\x8c\t\u8482", // 蒂
	0x8483: "\x8c\t\u8483", // 蒃
	0x8484: "\x8c\t\u8484", // 蒄
	0x8485: "\x8c\t\u8485", // 蒅
	0x8486: "\x8c\t\u8486", // 蒆
	0x8487: "\x8c\t\u8487", // 蒇
	0x8488: "\x8c\t\u8488", // 蒈
	0x8489: "\x8c\t\u8489", // 蒉
	0x848a: "\x8c\t\u848a", // 蒊
	0x848b: "\x8c\t\u848b", // 蒋
	0x848c: "\x8c\t\u848c", // 蒌
	0x848d: "\x8c\t\u848d", // 蒍
	0x848e: "\x8c\t\u848e", // 蒎
	0x848f: "\x8c\t\u848f", // 蒏
	0x8490: "\x8c\n\u8490", // 蒐
	0x8491: "\x8c\n\u8491", // 蒑
	0x8492: "\x8c\n\u8492", // 蒒
	0x8493: "\x8c\n\u8493", // 蒓
	0x8494: "\x8c\n\u8494", // 蒔
	0x8495: "\x8c\n\u8495", // 蒕
	0x8496: "\x8c\n\u8496", // 蒖
	0x8497: "\x8c\n\u8497", // 蒗
	0x8498: "\x8c\n\u8498", // 蒘
	0x8499: "\x8c\n\u8499", // 蒙
	0x849a: "\x8c\n\u849a", // 蒚
	0x849b: "\x8c\n\u849b", // 蒛
	0x849c: "\x8c\n\u849c", // 蒜
	0x849d: "\x8c\n\u849d", // 蒝
	0x849e: "\x8c\n\u849e", // 蒞
	0x849f: "\x8c\n\u849f", // 蒟
	0x84a0: "\x8c\n\u84a0", // 蒠
	0x84a1: "\x8c\n\u84a1", // 蒡
	0x84a2: "\x8c\n\u84a2", // 蒢
	0x84a3: "\x8c\n\u84a3", // 蒣
	0x84a4: "\x8c\n\u84a4", // 蒤
	0x84a5: "\x8c\n\u84a5", // 蒥
	0x84a6: "\x8c\n\u84a6", // 蒦
	0x84a7: "\x8c\n\u84a7", // 蒧
	0x84a8: "\x8c\n\u84a8", // 蒨
	0x84a9: "\x8c\n\u84a9", // 蒩
	0x84aa: "\x8c\n\u84aa", // 蒪
	0x84ab: "\x8c\n\u84ab", // 蒫
	0x84ac: "\x8c\n\u84ac", // 蒬
	0x84ad: "\x8c\n\u84ad", // 蒭
	0x84ae: "\x8c\n\u84ae", // 蒮
	0x84af: "\x8c\n\u84af", // 蒯
	0x84b0: "\x8c\n\u84b0", // 蒰
	0x84b1: "\x8c\n\u84b1", // 蒱
	0x84b2: "\x8c\n\u84b2", // 蒲
	0x84b3: "\x8c\n\u84b3", // 蒳
	0x84b4: "\x8c\n\u84b4", // 蒴
	0x84b5: "\x8c\n\u84b5", // 蒵
	0x84b6: "\x8c\n\u84b6", // 蒶
	0x84b7: "\x8c\n\u84b7", // 蒷
	0x84b8: "V\n\u84b8", // 蒸
	0x84b9: "\x8c\n\u84b9", // 蒹
	0x84ba: "\x8c\n\u84ba", // 蒺
	0x84bb: "\x8c\n\u84bb", // 蒻
	0x84bc: "\x8c\n\u84bc", // 蒼
	0x84bd: "\x8c\n\u84bd", // 蒽
	0x84be: "\x8c\n\u84be", // 蒾
	0x84bf: "\x8c\n\u84bf", // 蒿
	0x84c0: "\x8c\n\u84c0", // 蓀
	0x84c1: "\x8c\n\u84c1", // 蓁
	0x84c2: "\x8c\n\u84c2", // 蓂
	0x84c3: "\x8c\n\u84c3", // 蓃
	0x84c4: "\x8c\n\u84c4", // 蓄
	0x84c5: "\x8c\n\u84c5", // 蓅
	0x84c6: "\x8c\n\u84c6", // 蓆
	0x84c7: "\x8c\n\u84c7", // 蓇
	0x84c8: "\x8c\n\u84c8", // 蓈
	0x84c9: "\x8c\n\u84c9", // 蓉
	0x84ca: "\x8c\n\u84ca", // 蓊
	0x84cb: "\x8c\n\u84cb", // 蓋
	0x84cc: "\x8c\n\u84cc", // 蓌
	0x84cd: "\x8c\n\u84cd", // 蓍
	0x84ce: "\x8c\n\u84ce", // 蓎
	0x84cf: "\x8c\n\u84cf", // 蓏
	0x84d0: "\x8c\n\u84d0", // 蓐
	0x84d1: "\x8c\n\u84d1", // 蓑
	0x84d2: "\x8c\n\u84d2", // 蓒
	0x84d3: "\x8c\n\u84d3", // 蓓
	0x84d4: "\x8c\n\u84d4", // 蓔
	0x84d5: "\x8c\n\u84d5", // 蓕
	0x84d6: "\x8c\n\u84d6", // 蓖
	0x84d7: "\x8c\n\u84d7", // 蓗
	0x84d8: "\x8c\n\u84d8", // 蓘
	0x84d9: "\x8c\n\u84d9", // 蓙
	0x84da: "\x8c\n\u84da", // 蓚
	0x84db: "\x8c\n\u84db", // 蓛
	0x84dc: "\x8c\n\u84dc", // 蓜
	0x84dd: "\x8c\n\u84dd", // 蓝
	0x84de: "\x8c\n\u84de", // 蓞
	0x84df: "\x8c\n\u84df", // 蓟
	0x84e0: "\x8c\n\u84e0", // 蓠
	0x84e1: "\x8c\n\u84e1", // 蓡
	0x84e2: "\x8c\n\u84e2", // 蓢
	0x84e3: "\x8c\n\u84e3", // 蓣
	0x84e4: "\x8c\n\u84e4", // 蓤
	0x84e5: "\x8c\v\u84e5", // 蓥
	0x84e6: "\x8c\n\u84e6", // 蓦
	0x84e7: "\x8c\v\u84e7", // 蓧
	0x84e8: "\x8c\v\u84e8", // 蓨
	0x84e9: "\x8c\v\u84e9", // 蓩
	0x84ea: "\x8c\v\u84ea", // 蓪
	0x84eb: "\x8c\v\u84eb", // 蓫
	0x84ec: "\x8c\v\u84ec", // 蓬
	0x84ed: "\x8c\v\u84ed", // 蓭
	0x84ee: "\x8c\v\u84ee", // 蓮
	0x84ef: "\x8c\v\u84ef", // 蓯
	0x84f0: "\x8c\v\u84f0", // 蓰
	0x84f1: "\x8c\v\u84f1", // 蓱
	0x84f2: "\x8c\v\u84f2", // 蓲
	0x84f3: "\x8c\v\u84f3", // 蓳
	0x84f4: "\x8c\v\u84f4", // 蓴
	0x84f5: "\x8c\v\u84f5", // 蓵
	0x84f6: "\x8c\v\u84f6", // 蓶
	0x84f7: "\x8c\v\u84f7", // 蓷
	0x84f8: "\x8c\v\u84f8", // 蓸
	0x84f9: "\x8c\v\u84f9", // 蓹
	0x84fa: "\x8c\v\u84fa", // 蓺
	0x84fb: "\x8c\v\u84fb", // 蓻
	0x84fc: "\x8c\v\u84fc", // 蓼
	0x84fd: "\x8c\v\u84fd", // 蓽
	0x84fe: "\x8c\v\u84fe", // 蓾
	0x84ff: "\x8c\v\u84ff", // 蓿
	0x8500: "\x8c\v\u8500", // 蔀
	0x8501: "\x8c\v\u8501", // 蔁
	0x8502: "\x8c\v\u8502", // 蔂
	0x8503: "\x8c\v\u8503", // 蔃
	0x8504: "\x8c\v\u8504", // 蔄
	0x8505: "\x8c\v\u8505", // 蔅
	0x8506: "\x8c\v\u8506", // 蔆
	0x8507: "\x8c\v\u8507", // 蔇
	0x8508: "\x8c\v\u8508", // 蔈
	0x8509: "\x8c\v\u8509", // 蔉
	0x850a: "\x8c\v\u850a", // 蔊
	0x850b: "\x8c\v\u850b", // 蔋
	0x850c: "\x8c\v\u850c", // 蔌
	0x850d: "\x8c\v\u850d", // 蔍
	0x850e: "\x8c\v\u850e", // 蔎
	0x850f: "\x8c\v\u850f", // 蔏
	0x8510: "\x8c\v\u8510", // 蔐
	0x8511: "\x8c\v\u8511", // 蔑
	0x8512: "\x8c\v\u8512", // 蔒
	0x8513: "\x8c\v\u8513", // 蔓
	0x8514: "\x8c\v\u8514", // 蔔
	0x8515: "\x8c\v\u8515", // 蔕
	0x8516: "\x8c\v\u8516", // 蔖
	0x8517: "\x8c\v\u8517", // 蔗
	0x8518: "\x8c\v\u8518", // 蔘
	0x8519: "\x8c\v\u8519", // 蔙
	0x851a: "\x8c\v\u851a", // 蔚
	0x851b: "\x8c\v\u851b", // 蔛
	0x851c: "\x8c\v\u851c", // 蔜
	0x851d: "\x8c\v\u851d", // 蔝
	0x851e: "\x8c\v\u851e", // 蔞
	0x851f: "\x8c\v\u851f", // 蔟
	0x8520: "\x8c\v\u8520", // 蔠
	0x8521: "\x8c\v\u8521", // 蔡
	0x8522: "\x8c\v\u8522", // 蔢
	0x8523: "\x8c\v\u8523", // 蔣
	0x8524: "\x8c\v\u8524", // 蔤
	0x8525: "\x8c\v\u8525", // 蔥
	0x8526: "\x8c\v\u8526", // 蔦
	0x8527: "\x8c\v\u8527", // 蔧
	0x8528: "\x8c\v\u8528", // 蔨
	0x8529: "\x8c\v\u8529", // 蔩
	0x852a: "\x8c\v\u852a", // 蔪
	0x852b: "\x8c\v\u852b", // 蔫
	0x852c: "\x8c\v\u852c", // 蔬
	0x852d: "\x8c\v\u852d", // 蔭
	0x852e: "\x8c\v\u852e", // 蔮
	0x852f: "\x8c\v\u852f", // 蔯
	0x8530: "\x8c\v\u8530", // 蔰
	0x8531: "\x8c\v\u8531", // 蔱
	0x8532: "\x8c\v\u8532", // 蔲
	0x8533: "\x8c\v\u8533", // 蔳
	0x8534: "\x8c\v\u8534", // 蔴
	0x8535: "\x8c\v\u8535", // 蔵
	0x8536: "\x8c\v\u8536", // 蔶
	0x8537: "\x8c\v\u8537", // 蔷
	0x8538: "\x8c\v\u8538", // 蔸
	0x8539: "\x8c\v\u8539", // 蔹
	0x853a: "\x8c\v\u853a", // 蔺
	0x853b: "\x8c\v\u853b", // 蔻
	0x853c: "\x8c\v\u853c", // 蔼
	0x853d: "\x8c\f\u853d", // 蔽
	0x853e: "\x8c\f\u853e", // 蔾
	0x853f: "\x8c\f\u853f", // 蔿
	0x8540: "\x8c\f\u8540", // 蕀
	0x8541: "\x8c\f\u8541", // 蕁
	0x8542: "\x8c\f\u8542", // 蕂
	0x8543: "\x8c\f\u8543", // 蕃
	0x8544: "\x8c\f\u8544", // 蕄
	0x8545: "\x8c\f\u8545", // 蕅
	0x8546: "\x8c\f\u8546", // 蕆
	0x8547: "\x8c\f\u8547", // 蕇
	0x8548: "\x8c\f\u8548", // 蕈
	0x8549: "\x8c\f\u8549", // 蕉
	0x854a: "\x8c\f\u854a", // 蕊
	0x854b: "\x8c\f\u854b", // 蕋
	0x854c: "\x8c\f\u854c", // 蕌
	0x854d: "\x8c\f\u854d", // 蕍
	0x854e: "\x8c\f\u854e", // 蕎
	0x854f: "\x8c\f\u854f", // 蕏
	0x8550: "\x8c\f\u8550", // 蕐
	0x8551: "\x8c\f\u8551", // 蕑
	0x8552: "\x8c\f\u8552", // 蕒
	0x8553: "\x8c\f\u8553", // 蕓
	0x8554: "\x8c\f\u8554", // 蕔
	0x8555: "\x8c\f\u8555", // 蕕
	0x8556: "\x8c\f\u8556", // 蕖
	0x8557: "\x8c\f\u8557", // 蕗
	0x8558: "\x8c\f\u8558", // 蕘
	0x8559: "\x8c\f\u8559", // 蕙
	0x855a: "\x8c\f\u855a", // 蕚
	0x855b: "\x8c\f\u855b", // 蕛
	0x855c: "\x8c\f\u855c", // 蕜
	0x855d: "\x8c\f\u855d", // 蕝
	0x855e: "\x8c\f\u855e", // 蕞
	0x855f: "\x8c\f\u855f", // 蕟
	0x8560: "\x8c\f\u8560", // 蕠
	0x8561: "\x8c\f\u8561", // 蕡
	0x8562: "\x8c\f\u8562", // 蕢
	0x8563: "\x8c\f\u8563", // 蕣
	0x8564: "\x8c\f\u8564", // 蕤
	0x8565: "\x8c\f\u8565", // 蕥
	0x8566: "\x8c\f\u8566", // 蕦
	0x8567: "\x8c\f\u8567", // 蕧
	0x8568: "\x8c\f\u8568", // 蕨
	0x8569: "\x8c\f\u8569", // 蕩
	0x856a: "\x8c\f\u856a", // 蕪
	0x856b: "\x8c\f\u856b", // 蕫
	0x856c: "\x8c\f\u856c", // 蕬
	0x856d: "\x8c\f\u856d", // 蕭
	0x856e: "\x8c\f\u856e", // 蕮
	0x856f: "\x8c\f\u856f", // 蕯
	0x8570: "\x8c\f\u8570", // 蕰
	0x8571: "\x8c\f\u8571", // 蕱
	0x8572: "\x8c\f\u8572", // 蕲
	0x8573: "\x8c\f\u8573", // 蕳
	0x8574: "\x8c\f\u8574", // 蕴
	0x8575: "\x8c\f\u8575", // 蕵
	0x8576: "\x8c\r\u8576", // 蕶
	0x8577: "\x8c\r\u8577", // 蕷
	0x8578: "\x8c\r\u8578", // 蕸
	0x8579: "\x8c\r\u8579", // 蕹
	0x857a: "\x8c\r\u857a", // 蕺
	0x857b: "\x8c\r\u857b", // 蕻
	0x857c: "\x8c\r\u857c", // 蕼
	0x857d: "\x8c\r\u857d", // 蕽
	0x857e: "\x8c\r\u857e", // 蕾
	0x857f: "\x8c\r\u857f", // 蕿
	0x8580: "\x8c\r\u8580", // 薀
	0x8581: "\x8c\r\u8581", // 薁
	0x8582: "\x8c\r\u8582", // 薂
	0x8583: "\x8c\r\u8583", // 薃
	0x8584: "\x8c\r\u8584", // 薄
	0x8585: "\x8c\r\u8585", // 薅
	0x8586: "\x8c\r\u8586", // 薆
	0x8587: "\x8c\r\u8587", // 薇
	0x8588: "\x8c\r\u8588", // 薈
	0x8589: "\x8c\r\u8589", // 薉
	0x858a: "\x8c\r\u858a", // 薊
	0x858b: "\x8c\r\u858b", // 薋
	0x858c: "\x8c\r\u858c", // 薌
	0x858d: "\x8c\r\u858d", // 薍
	0x858e: "\x8c\r\u858e", // 薎
	0x858f: "\x8c\r\u858f", // 薏
	0x8590: "\x8c\r\u8590", // 薐
	0x8591: "\x8c\r\u8591", // 薑
	0x8592: "\x8c\r\u8592", // 薒
	0x8593: "\x8c\r\u8593", // 薓
	0x8594: "\x8c\r\u8594", // 薔
	0x8595: "\x8c\r\u8595", // 薕
	0x8596: "\x8c\r\u8596", // 薖
	0x8597: "\x8c\r\u8597", // 薗
	0x8598: "\x8c\r\u8598", // 薘
	0x8599: "\x8c\r\u8599", // 薙
	0x859a: "\x8c\r\u859a", // 薚
	0x859b: "\x8c\r\u859b", // 薛
	0x859c: "\x8c\r\u859c", // 薜
	0x859d: "\x8c\r\u859d", // 薝
	0x859e: "\x8c\r\u859e", // 薞
	0x859f: "\x8c\r\u859f", // 薟
	0x85a0: "\x8c\r\u85a0", // 薠
	0x85a1: "\x8c\r\u85a1", // 薡
	0x85a2: "\x8c\r\u85a2", // 薢
	0x85a3: "\x8c\r\u85a3", // 薣
	0x85a4: "\x8c\r\u85a4", // 薤
	0x85a5: "\x8c\r\u85a5", // 薥
	0x85a6: "\x8c\r\u85a6", // 薦
	0x85a7: "\x8c\r\u85a7", // 薧
	0x85a8: "\x8c\r\u85a8", // 薨
	0x85a9: "\x8c\x0e\u85a9", // 薩
	0x85aa: "\x8c\r\u85aa", // 薪
	0x85ab: "\x8c\r\u85ab", // 薫
	0x85ac: "\x8c\r\u85ac", // 薬
	0x85ad: "\x8c\x0e\u85ad", // 薭
	0x85ae: "\x8c\r\u85ae", // 薮
	0x85af: "\x8c\x0e\u85af", // 薯
	0x85b0: "\x8c\x0e\u85b0", // 薰
	0x85b1: "\x8c\x0e\u85b1", // 薱
	0x85b2: "\x8c\x0e\u85b2", // 薲
	0x85b3: "\x8c\x0e\u85b3", // 薳
	0x85b4: "\x8c\x0e\u85b4", // 薴
	0x85b5: "\x8c\x0e\u85b5", // 薵
	0x85b6: "\x8c\x0e\u85b6", // 薶
	0x85b7: "\x8c\x0e\u85b7", // 薷
	0x85b8: "\x8c\x0e\u85b8", // 薸
	0x85b9: "\x8c\x0e\u85b9", // 薹
	0x85ba: "\x8c\x0e\u85ba", // 薺
	0x85bb: "\x8c\x0e\u85bb", // 薻
	0x85bc: "\x8c\x0e\u85bc", // 薼
	0x85bd: "\x8c\x0e\u85bd", // 薽
	0x85be: "\x8c\x0e\u85be", // 薾
	0x85bf: "\x8c\x0e\u85bf", // 薿
	0x85c0: "\x8c\x0e\u85c0", // 藀
	0x85c1: "\x8c\x0e\u85c1", // 藁
	0x85c2: "\x8c\x0e\u85c2", // 藂
	0x85c3: "\x8c\x0e\u85c3", // 藃
	0x85c4: "\x8c\x0e\u85c4", // 藄
	0x85c5: "\x8c\x0e\u85c5", // 藅
	0x85c6: "\x8c\x0e\u85c6", // 藆
	0x85c7: "\x8c\x0e\u85c7", // 藇
	0x85c8: "\x8c\x0e\u85c8", // 藈
	0x85c9: "\x8c\x0e\u85c9", // 藉
	0x85ca: "\x8c\x0e\u85ca", // 藊
	0x85cb: "\x8c\x0e\u85cb", // 藋
	0x85cc: "\x8c\x0e\u85cc", // 藌
	0x85cd: "\x8c\x0e\u85cd", // 藍
	0x85ce: "\x8c\x0e\u85ce", // 藎
	0x85cf: "\x8c\x0e\u85cf", // 藏
	0x85d0: "\x8c\x0e\u85d0", // 藐
	0x85d1: "\x8c\x0e\u85d1", // 藑
	0x85d2: "\x8c\x0e\u85d2", // 藒
	0x85d3: "\x8c\x0e\u85d3", // 藓
	0x85d4: "\x8c\x0f\u85d4", // 藔
	0x85d5: "\x8c\x0f\u85d5", // 藕
	0x85d6: "\x8c\x0f\u85d6", // 藖
	0x85d7: "\x8c\x0f\u85d7", // 藗
	0x85d8: "\x8c\x0f\u85d8", // 藘
	0x85d9: "\x8c\x0f\u85d9", // 藙
	0x85da: "\x8c\x0f\u85da", // 藚
	0x85db: "\x8c\x0f\u85db", // 藛
	0x85dc: "\x8c\x0f\u85dc", // 藜
	0x85dd: "\x8c\x0f\u85dd", // 藝
	0x85de: "\x8c\x0f\u85de", // 藞
	0x85df: "\x8c\x0f\u85df", // 藟
	0x85e0: "\x8c\x0f\u85e0", // 藠
	0x85e1: "\x8c\x0f\u85e1", // 藡
	0x85e2: "\x8c\x0f\u85e2", // 藢
	0x85e3: "\x8c\x0f\u85e3", // 藣
	0x85e4: "\x8c\x0f\u85e4", // 藤
	0x85e5: "\x8c\x0f\u85e5", // 藥
	0x85e6: "\x8c\x0f\u85e6", // 藦
	0x85e7: "\x8c\x0f\u85e7", // 藧
	0x85e8: "\x8c\x0f\u85e8", // 藨
	0x85e9: "\x8c\x0f\u85e9", // 藩
	0x85ea: "\x8c\x0f\u85ea", // 藪
	0x85eb: "\x8c\x0f\u85eb", // 藫
	0x85ec: "\x8c\x0f\u85ec", // 藬
	0x85ed: "\x8c\x0f\u85ed", // 藭
	0x85ee: "\x8c\x10\u85ee", // 藮
	0x85ef: "\x8c\x0f\u85ef", // 藯
	0x85f0: "\x8c\x0f\u85f0", // 藰
	0x85f1: "\x8c\x0f\u85f1", // 藱
	0x85f2: "\x8c\x0f\u85f2", // 藲
	0x85f3: "\x8c\x0f\u85f3", // 藳
	0x85f4: "\x8c\x0f\u85f4", // 藴
	0x85f5: "\x8c\x0f\u85f5", // 藵
	0x85f6: "\x8c\x10\u85f6", // 藶
	0x85f7: "\x8c\x10\u85f7", // 藷
	0x85f8: "\x8c\x10\u85f8", // 藸
	0x85f9: "\x8c\x10\u85f9", // 藹
	0x85fa: "\x8c\x10\u85fa", // 藺
	0x85fb: "\x8c\x10\u85fb", // 藻
	0x85fc: "\x8c\x10\u85fc", // 藼
	0x85fd: "\x8c\x10\u85fd", // 藽
	0x85fe: "\x8c\x10\u85fe", // 藾
	0x85ff: "\x8c\x10\u85ff", // 藿
	0x8600: "\x8c\x10\u8600", // 蘀
	0x8601: "\x8c\x10\u8601", // 蘁
	0x8602: "\x8c\x10\u8602", // 蘂
	0x8603: "\x8c\x10\u8603", // 蘃
	0x8604: "\x8c\x10\u8604", // 蘄
	0x8605: "\x8c\x10\u8605", // 蘅
	0x8606: "\x8c\x10\u8606", // 蘆
	0x8607: "\x8c\x10\u8607", // 蘇
	0x8608: "\x8c\x10\u8608", // 蘈
	0x8609: "\x8c\x10\u8609", // 蘉
	0x860a: "\x8c\x10\u860a", // 蘊
	0x860b: "\x8c\x10\u860b", // 蘋
	0x860c: "\x8c\x10\u860c", // 蘌
	0x860d: "\x8c\x10\u860d", // 蘍
	0x860e: "\x8c\x10\u860e", // 蘎
	0x860f: "\x8c\x10\u860f", // 蘏
	0x8610: "\x8c\x10\u8610", // 蘐
	0x8611: "\x8c\x10\u8611", // 蘑
	0x8612: "\x8c\x11\u8612", // 蘒
	0x8613: "\x8c\x10\u8613", // 蘓
	0x8614: "\x8c\x10\u8614", // 蘔
	0x8615: "\x8c\x11\u8615", // 蘕
	0x8616: "\x8c\x11\u8616", // 蘖
	0x8617: "\x8c\x11\u8617", // 蘗
	0x8618: "\x8c\x11\u8618", // 蘘
	0x8619: "\x8c\x11\u8619", // 蘙
	0x861a: "\x8c\x11\u861a", // 蘚
	0x861b: "\x8c\x11\u861b", // 蘛
	0x861c: "\x8c\x11\u861c", // 蘜
	0x861d: "\x8c\x11\u861d", // 蘝
	0x861e: "\x8c\x11\u861e", // 蘞
	0x861f: "\x8c\x11\u861f", // 蘟
	0x8620: "\x8c\x11\u8620", // 蘠
	0x8621: "\x8c\x11\u8621", // 蘡
	0x8622: "\x8c\x10\u8622", // 蘢
	0x8623: "\x8c\x11\u8623", // 蘣
	0x8624: "\x8c\x0e\u8624", // 蘤
	0x8625: "\x8c\x11\u8625", // 蘥
	0x8626: "\x8c\x11\u8626", // 蘦
	0x8627: "\x8c\x11\u8627", // 蘧
	0x8628: "\x8c\x11\u8628", // 蘨
	0x8629: "\x8c\x11\u8629", // 蘩
	0x862a: "\x8c\x11\u862a", // 蘪
	0x862b: "\x8c\x11\u862b", // 蘫
	0x862c: "\x8c\x11\u862c", // 蘬
	0x862d: "\x8c\x11\u862d", // 蘭
	0x862e: "\x8c\x11\u862e", // 蘮
	0x862f: "\x8c\x11\u862f", // 蘯
	0x8630: "\x8c\x11\u8630", // 蘰
	0x8631: "\x8c\x13\u8631", // 蘱
	0x8632: "\x8c\x12\u8632", // 蘲
	0x8633: "\x8c\x12\u8633", // 蘳
	0x8634: "\x8c\x12\u8634", // 蘴
	0x8635: "\x8c\x12\u8635", // 蘵
	0x8636: "\x8c\x12\u8636", // 蘶
	0x8637: "\x8c\x12\u8637", // 蘷
	0x8638: "\x8c\x13\u8638", // 蘸
	0x8639: "\x8c\x13\u8639", // 蘹
	0x863a: "\x8c\x13\u863a", // 蘺
	0x863b: "\x8c\x13\u863b", // 蘻
	0x863c: "\x8c\x13\u863c", // 蘼
	0x863d: "\x8c\x13\u863d", // 蘽
	0x863e: "\x8c\x13\u863e", // 蘾
	0x863f: "\x8c\x13\u863f", // 蘿
	0x8640: "\x8c\x13\u8640", // 虀
	0x8641: "\x8c\x13\u8641", // 虁
	0x8642: "\x8c\x14\u8642", // 虂
	0x8643: "\x8c\x14\u8643", // 虃
	0x8644: "\x8c\x14\u8644", // 虄
	0x8645: "\x8c\x14\u8645", // 虅
	0x8646: "\x8c\x15\u8646", // 虆
	0x8647: "\x8c\x15\u8647", // 虇
	0x8648: "\x8c\x15\u8648", // 虈
	0x8649: "\x8c\x15\u8649", // 虉
	0x864a: "\x8c\x17\u864a", // 虊
	0x864b: "\x8c\x19\u864b", // 虋
	0x864c: "\x8c\x19\u864c", // 虌
	0x864d: "\x8d\x00\u864d", // 虍
	0x864e: "\x8d\x02\u864e", // 虎
	0x864f: "\x8d\x02\u864f", // 虏
	0x8650: "\x8d\x03\u8650", // 虐
	0x8651: "\x8d\x04\u8651", // 虑
	0x8652: "\x1b\b\u8652", // 虒
	0x8653: "\x8d\x04\u8653", // 虓
	0x8654: "\x8d\x04\u8654", // 虔
	0x8655: "\x8d\x05\u8655", // 處
	0x8656: "\x8d\x05\u8656", // 虖
	0x8657: "\x8d\x05\u8657", // 虗
	0x8658: "\x8d\x05\u8658", // 虘
	0x8659: "\x8d\x05\u8659", // 虙
	0x865a: "\x8d\x05\u865a", // 虚
	0x865b: "\x8d\x06\u865b", // 虛
	0x865c: "\x8d\x06\u865c", // 虜
	0x865d: "\x8d\x06\u865d", // 虝
	0x865e: "\x8d\a\u865e", // 虞
	0x865f: "\x8d\a\u865f", // 號
	0x8660: "\x8d\b\u8660", // 虠
	0x8661: "\x8d\b\u8661", // 虡
	0x8662: "\x8d\t\u8662", // 虢
	0x8663: "\x8d\t\u8663", // 虣
	0x8664: "\x8d\n\u8664", // 虤
	0x8665: "\x8d\n\u8665", // 虥
	0x8666: "\x8d\n\u8666", // 虦
	0x8667: "\x8d\v\u8667", // 虧
	0x8668: "\x8d\v\u8668", // 虨
	0x8669: "\x8d\f\u8669", // 虩
	0x866a: "\x8d\x14\u866a", // 虪
	0x866b: "\x8e\x00\u866b", // 虫
	0x866c: "\x8e\x01\u866c", // 虬
	0x866d: "\x8e\x02\u866d", // 虭
	0x866e: "\x8e\x02\u866e", // 虮
	0x866f: "\x8e\x02\u866f", // 虯
	0x8670: "\x8e\x02\u8670", // 虰
	0x8671: "\x8e\x02\u8671", // 虱
	0x8672: "\x8e\x02\u8672", // 虲
	0x8673: "\x8e\x03\u8673", // 虳
	0x8674: "\x8e\x03\u8674", // 虴
	0x8675: "\x8e\x03\u8675", // 虵
	0x8676: "\x8e\x03\u8676", // 虶
	0x8677: "\x8e\x03\u8677", // 虷
	0x8678: "\x8e\x03\u8678", // 虸
	0x8679: "\x8e\x03\u8679", // 虹
	0x867a: "\x8e\x03\u867a", // 虺
	0x867b: "\x8e\x03\u867b", // 虻
	0x867c: "\x8e\x03\u867c", // 虼
	0x867d: "\x8e\x03\u867d", // 虽
	0x867e: "\x8e\x03\u867e", // 虾
	0x867f: "\x8e\x03\u867f", // 虿
	0x8680: "\x8e\x03\u8680", // 蚀
	0x8681: "\x8e\x03\u8681", // 蚁
	0x8682: "\x8e\x03\u8682", // 蚂
	0x8683: "\x8e\x03\u8683", // 蚃
	0x8684: "\x8e\x04\u8684", // 蚄
	0x8685: "\x8e\x04\u8685", // 蚅
	0x8686: "\x8e\x04\u8686", // 蚆
	0x8687: "\x8e\x04\u8687", // 蚇
	0x8688: "\x8e\x06\u8688", // 蚈
	0x8689: "\x8e\x04\u8689", // 蚉
	0x868a: "\x8e\x04\u868a", // 蚊
	0x868b: "\x8e\x04\u868b", // 蚋
	0x868c: "\x8e\x04\u868c", // 蚌
	0x868d: "\x8e\x04\u868d", // 蚍
	0x868e: "\x8e\x04\u868e", // 蚎
	0x868f: "\x8e\x04\u868f", // 蚏
	0x8690: "\x8e\x04\u8690", // 蚐
	0x8691: "\x8e\x04\u8691", // 蚑
	0x8692: "\x8e\x04\u8692", // 蚒
	0x8693: "\x8e\x04\u8693", // 蚓
	0x8694: "\x8e\x04\u8694", // 蚔
	0x8695: "\x8e\x04\u8695", // 蚕
	0x8696: "\x8e\x04\u8696", // 蚖
	0x8697: "\x8e\x04\u8697", // 蚗
	0x8698: "\x8e\x04\u8698", // 蚘
	0x8699: "\x8e\x04\u8699", // 蚙
	0x869a: "\x8e\x04\u869a", // 蚚
	0x869b: "\x8e\x04\u869b", // 蚛
	0x869c: "\x8e\x04\u869c", // 蚜
	0x869d: "\x8e\x04\u869d", // 蚝
	0x869e: "\x8e\x04\u869e", // 蚞
	0x869f: "\x8e\x04\u869f", // 蚟
	0x86a0: "\x8e\x04\u86a0", // 蚠
	0x86a1: "\x8e\x04\u86a1", // 蚡
	0x86a2: "\x8e\x04\u86a2", // 蚢
	0x86a3: "\x8e\x04\u86a3", // 蚣
	0x86a4: "\x8e\x04\u86a4", // 蚤
	0x86a5: "\x8e\x04\u86a5", // 蚥
	0x86a6: "\x8e\x04\u86a6", // 蚦
	0x86a7: "\x8e\x04\u86a7", // 蚧
	0x86a8: "\x8e\x04\u86a8", // 蚨
	0x86a9: "\x8e\x04\u86a9", // 蚩
	0x86aa: "\x8e\x04\u86aa", // 蚪
	0x86ab: "\x8e\x05\u86ab", // 蚫
	0x86ac: "\x8e\x04\u86ac", // 蚬
	0x86ad: "\x8e\x05\u86ad", // 蚭
	0x86ae: "\x8e\x05\u86ae", // 蚮
	0x86af: "\x8e\x05\u86af", // 蚯
	0x86b0: "\x8e\x05\u86b0", // 蚰
	0x86b1: "\x8e\x05\u86b1", // 蚱
	0x86b2: "\x8e\x05\u86b2", // 蚲
	0x86b3: "\x8e\x05\u86b3", // 蚳
	0x86b4: "\x8e\x05\u86b4", // 蚴
	0x86b5: "\x8e\x05\u86b5", // 蚵
	0x86b6: "\x8e\x05\u86b6", // 蚶
	0x86b7: "\x8e\x05\u86b7", // 蚷
	0x86b8: "\x8e\x05\u86b8", // 蚸
	0x86b9: "\x8e\x05\u86b9", // 蚹
	0x86ba: "\x8e\x05\u86ba", // 蚺
	0x86bb: "\x8e\x05\u86bb", // 蚻
	0x86bc: "\x8e\x05\u86bc", // 蚼
	0x86bd: "\x8e\x05\u86bd", // 蚽
	0x86be: "\x8e\x05\u86be", // 蚾
	0x86bf: "\x8e\x05\u86bf", // 蚿
	0x86c0: "\x8e\x05\u86c0", // 蛀
	0x86c1: "\x8e\x05\u86c1", // 蛁
	0x86c2: "\x8e\x05\u86c2", // 蛂
	0x86c3: "\x8e\x05\u86c3", // 蛃
	0x86c4: "\x8e\x05\u86c4", // 蛄
	0x86c5: "\x8e\x05\u86c5", // 蛅
	0x86c6: "\x8e\x05\u86c6", // 蛆
	0x86c7: "\x8e\x05\u86c7", // 蛇
	0x86c8: "\x8e\x05\u86c8", // 蛈
	0x86c9: "\x8e\x05\u86c9", // 蛉
	0x86ca: "\x8e\x05\u86ca", // 蛊
	0x86cb: "\x8e\x05\u86cb", // 蛋
	0x86cc: "\x8e\x05\u86cc", // 蛌
	0x86cd: "\x8e\x05\u86cd", // 蛍
	0x86ce: "\x8e\x05\u86ce", // 蛎
	0x86cf: "\x8e\x05\u86cf", // 蛏
	0x86d0: "\x8e\x06\u86d0", // 蛐
	0x86d1: "\x8e\x06\u86d1", // 蛑
	0x86d2: "\x8e\x06\u86d2", // 蛒
	0x86d3: "\x8e\x06\u86d3", // 蛓
	0x86d4: "\x8e\x06\u86d4", // 蛔
	0x86d5: "\x8e\x06\u86d5", // 蛕
	0x86d6: "\x8e\a\u86d6", // 蛖
	0x86d7: "\x8e\x06\u86d7", // 蛗
	0x86d8: "\x8e\x06\u86d8", // 蛘
	0x86d9: "\x8e\x06\u86d9", // 蛙
	0x86da: "\x8e\x06\u86da", // 蛚
	0x86db: "\x8e\x06\u86db", // 蛛
	0x86dc: "\x8e\x06\u86dc", // 蛜
	0x86dd: "\x8e\x06\u86dd", // 蛝
	0x86de: "\x8e\x06\u86de", // 蛞
	0x86df: "\x8e\x06\u86df", // 蛟
	0x86e0: "\x8e\x06\u86e0", // 蛠
	0x86e1: "\x8e\x06\u86e1", // 蛡
	0x86e2: "\x8e\x06\u86e2", // 蛢
	0x86e3: "\x8e\x06\u86e3", // 蛣
	0x86e4: "\x8e\x06\u86e4", // 蛤
	0x86e5: "\x8e\x06\u86e5", // 蛥
	0x86e6: "\x8e\x06\u86e6", // 蛦
	0x86e7: "\x8e\x06\u86e7", // 蛧
	0x86e8: "\x8e\x06\u86e8", // 蛨
	0x86e9: "\x8e\x06\u86e9", // 蛩
	0x86ea: "\x8e\x06\u86ea", // 蛪
	0x86eb: "\x8e\x06\u86eb", // 蛫
	0x86ec: "\x8e\x06\u86ec", // 蛬
	0x86ed: "\x8e\x06\u86ed", // 蛭
	0x86ee: "\x8e\x06\u86ee", // 蛮
	0x86ef: "\x8e\x06\u86ef", // 蛯
	0x86f0: "\x8e\x06\u86f0", // 蛰
	0x86f1: "\x8e\x06\u86f1", // 蛱
	0x86f2: "\x8e\x06\u86f2", // 蛲
	0x86f3: "\x8e\x06\u86f3", // 蛳
	0x86f4: "\x8e\x06\u86f4", // 蛴
	0x86f5: "\x8e\a\u86f5", // 蛵
	0x86f6: "\x8e\a\u86f6", // 蛶
	0x86f7: "\x8e\a\u86f7", // 蛷
	0x86f8: "\x8e\a\u86f8", // 蛸
	0x86f9: "\x8e\a\u86f9", // 蛹
	0x86fa: "\x8e\a\u86fa", // 蛺
	0x86fb: "\x8e\a\u86fb", // 蛻
	0x86fc: "\x8e\a\u86fc", // 蛼
	0x86fd: "\x8e\a\u86fd", // 蛽
	0x86fe: "\x8e\a\u86fe", // 蛾
	0x86ff: "\x8e\a\u86ff", // 蛿
	0x8700: "\x8e\a\u8700", // 蜀
	0x8701: "\x8e\a\u8701", // 蜁
	0x8702: "\x8e\a\u8702", // 蜂
	0x8703: "\x8e\a\u8703", // 蜃
	0x8704: "\x8e\a\u8704", // 蜄
	0x8705: "\x8e\a\u8705", // 蜅
	0x8706: "\x8e\a\u8706", // 蜆
	0x8707: "\x8e\a\u8707", // 蜇
	0x8708: "\x8e\a\u8708", // 蜈
	0x8709: "\x8e\a\u8709", // 蜉
	0x870a: "\x8e\a\u870a", // 蜊
	0x870b: "\x8e\a\u870b", // 蜋
	0x870c: "\x8e\a\u870c", // 蜌
	0x870d: "\x8e\a\u870d", // 蜍
	0x870e: "\x8e\a\u870e", // 蜎
	0x870f: "\x8e\a\u870f", // 蜏
	0x8710: "\x8e\a\u8710", // 蜐
	0x8711: "\x8e\a\u8711", // 蜑
	0x8712: "\x8e\a\u8712", // 蜒
	0x8713: "\x8e\a\u8713", // 蜓
	0x8714: "\x8e\a\u8714", // 蜔
	0x8715: "\x8e\a\u8715", // 蜕
	0x8716: "\x8e\a\u8716", // 蜖
	0x8717: "\x8e\a\u8717", // 蜗
	0x8718: "\x8e\b\u8718", // 蜘
	0x8719: "\x8e\b\u8719", // 蜙
	0x871a: "\x8e\b\u871a", // 蜚
	0x871b: "\x8e\b\u871b", // 蜛
	0x871c: "\x8e\b\u871c", // 蜜
	0x871d: "\x8e\b\u871d", // 蜝
	0x871e: "\x8e\b\u871e", // 蜞
	0x871f: "\x8e\b\u871f", // 蜟
	0x8720: "\x8e\b\u8720", // 蜠
	0x8721: "\x8e\b\u8721", // 蜡
	0x8722: "\x8e\b\u8722", // 蜢
	0x8723: "\x8e\b\u8723", // 蜣
	0x8724: "\x8e\b\u8724", // 蜤
	0x8725: "\x8e\b\u8725", // 蜥
	0x8726: "\x8e\b\u8726", // 蜦
	0x8727: "\x8e\b\u8727", // 蜧
	0x8728: "\x8e\b\u8728", // 蜨
	0x8729: "\x8e\b\u8729", // 蜩
	0x872a: "\x8e\b\u872a", // 蜪
	0x872b: "\x8e\a\u872b", // 蜫
	0x872c: "\x8e\b\u872c", // 蜬
	0x872d: "\x8e\b\u872d", // 蜭
	0x872e: "\x8e\b\u872e", // 蜮
	0x872f: "\x8e\b\u872f", // 蜯
	0x8730: "\x8e\b\u8730", // 蜰
	0x8731: "\x8e\b\u8731", // 蜱
	0x8732: "\x8e\b\u8732", // 蜲
	0x8733: "\x8e\b\u8733", // 蜳
	0x8734: "\x8e\b\u8734", // 蜴
	0x8735: "\x8e\b\u8735", // 蜵
	0x8736: "\x8e\b\u8736", // 蜶
	0x8737: "\x8e\b\u8737", // 蜷
	0x8738: "\x8e\b\u8738", // 蜸
	0x8739: "\x8e\b\u8739", // 蜹
	0x873a: "\x8e\b\u873a", // 蜺
	0x873b: "\x8e\b\u873b", // 蜻
	0x873c: "\x8e\b\u873c", // 蜼
	0x873d: "\x8e\b\u873d", // 蜽
	0x873e: "\x8e\b\u873e", // 蜾
	0x873f: "\x8e\b\u873f", // 蜿
	0x8740: "\x8e\b\u8740", // 蝀
	0x8741: "\x8e\b\u8741", // 蝁
	0x8742: "\x8e\b\u8742", // 蝂
	0x8743: "\x8e\b\u8743", // 蝃
	0x8744: "\x8e\b\u8744", // 蝄
	0x8745: "\x8e\b\u8745", // 蝅
	0x8746: "\x8e\a\u8746", // 蝆
	0x8747: "\x8e\b\u8747", // 蝇
	0x8748: "\x8e\b\u8748", // 蝈
	0x8749: "\x8e\b\u8749", // 蝉
	0x874a: "\x8e\b\u874a", // 蝊
	0x874b: "\x8e\b\u874b", // 蝋
	0x874c: "\x8e\t\u874c", // 蝌
	0x874d: "\x8e\t\u874d", // 蝍
	0x874e: "\x8e\t\u874e", // 蝎
	0x874f: "\x8e\t\u874f", // 蝏
	0x8750: "\x8e\t\u8750", // 蝐
	0x8751: "\x8e\t\u8751", // 蝑
	0x8752: "\x8e\t\u8752", // 蝒
	0x8753: "\x8e\t\u8753", // 蝓
	0x8754: "\x8e\t\u8754", // 蝔
	0x8755: "\x8e\t\u8755", // 蝕
	0x8756: "\x8e\t\u8756", // 蝖
	0x8757: "\x8e\t\u8757", // 蝗
	0x8758: "\x8e\t\u8758", // 蝘
	0x8759: "\x8e\t\u8759", // 蝙
	0x875a: "\x8e\t\u875a", // 蝚
	0x875b: "\x8e\t\u875b", // 蝛
	0x875c: "\x8e\t\u875c", // 蝜
	0x875d: "\x8e\t\u875d", // 蝝
	0x875e: "\x8e\t\u875e", // 蝞
	0x875f: "\x8e\t\u875f", // 蝟
	0x8760: "\x8e\t\u8760", // 蝠
	0x8761: "\x8e\t\u8761", // 蝡
	0x8762: "\x8e\t\u8762", // 蝢
	0x8763: "\x8e\t\u8763", // 蝣
	0x8764: "\x8e\t\u8764", // 蝤
	0x8765: "\x8e\t\u8765", // 蝥
	0x8766: "\x8e\t\u8766", // 蝦
	0x8767: "\x8e\t\u8767", // 蝧
	0x8768: "\x8e\t\u8768", // 蝨
	0x8769: "\x8e\t\u8769", // 蝩
	0x876a: "\x8e\t\u876a", // 蝪
	0x876b: "\x8e\t\u876b", // 蝫
	0x876c: "\x8e\t\u876c", // 蝬
	0x876d: "\x8e\t\u876d", // 蝭
	0x876e: "\x8e\t\u876e", // 蝮
	0x876f: "\x8e\t\u876f", // 蝯
	0x8770: "\x8e\t\u8770", // 蝰
	0x8771: "\x8e\t\u8771", // 蝱
	0x8772: "\x8e\t\u8772", // 蝲
	0x8773: "\x8e\t\u8773", // 蝳
	0x8774: "\x8e\t\u8774", // 蝴
	0x8775: "\x8e\t\u8775", // 蝵
	0x8776: "\x8e\t\u8776", // 蝶
	0x8777: "\x8e\t\u8777", // 蝷
	0x8778: "\x8e\t\u8778", // 蝸
	0x8779: "\x8e\n\u8779", // 蝹
	0x877a: "\x8e\t\u877a", // 蝺
	0x877b: "\x8e\t\u877b", // 蝻
	0x877c: "\x8e\t\u877c", // 蝼
	0x877d: "\x8e\t\u877d", // 蝽
	0x877e: "\x8e\t\u877e", // 蝾
	0x877f: "\x8e\t\u877f", // 蝿
	0x8780: "\x8e\t\u8780", // 螀
	0x8781: "\x8e\n\u8781", // 螁
	0x8782: "\x8e\n\u8782", // 螂
	0x8783: "\x8e\n\u8783", // 螃
	0x8784: "\x8e\n\u8784", // 螄
	0x8785: "\x8e\n\u8785", // 螅
	0x8786: "\x8e\n\u8786", // 螆
	0x8787: "\x8e\n\u8787", // 螇
	0x8788: "\x8e\n\u8788", // 螈
	0x8789: "\x8e\n\u8789", // 螉
	0x878a: "\x8e\n\u878a", // 螊
	0x878b: "\x8e\n\u878b", // 螋
	0x878c: "\x8e\n\u878c", // 螌
	0x878d: "\x8e\n\u878d", // 融
	0x878e: "\x8e\n\u878e", // 螎
	0x878f: "\x8e\n\u878f", // 螏
	0x8790: "\x8e\n\u8790", // 螐
	0x8791: "\x8e\n\u8791", // 螑
	0x8792: "\x8e\n\u8792", // 螒
	0x8793: "\x8e\n\u8793", // 螓
	0x8794: "\x8e\n\u8794", // 螔
	0x8795: "\x8e\n\u8795", // 螕
	0x8796: "\x8e\n\u8796", // 螖
	0x8797: "\x8e\n\u8797", // 螗
	0x8798: "\x8e\n\u8798", // 螘
	0x8799: "\x8e\n\u8799", // 螙
	0x879a: "\x8e\n\u879a", // 螚
	0x879b: "\x8e\n\u879b", // 螛
	0x879c: "\x8e\n\u879c", // 螜
	0x879d: "\x8e\n\u879d", // 螝
	0x879e: "\x8e\n\u879e", // 螞
	0x879f: "\x8e\n\u879f", // 螟
	0x87a0: "\x8e\n\u87a0", // 螠
	0x87a1: "\x8e\n\u87a1", // 螡
	0x87a2: "\x8e\n\u87a2", // 螢
	0x87a3: "\x8e\n\u87a3", // 螣
	0x87a4: "\x8e\n\u87a4", // 螤
	0x87a5: "\x8e\n\u87a5", // 螥
	0x87a6: "\x8e\n\u87a6", // 螦
	0x87a7: "\x8e\n\u87a7", // 螧
	0x87a8: "\x8e\n\u87a8", // 螨
	0x87a9: "\x8e\n\u87a9", // 螩
	0x87aa: "\x8e\v\u87aa", // 螪
	0x87ab: "\x8e\v\u87ab", // 螫
	0x87ac: "\x8e\v\u87ac", // 螬
	0x87ad: "\x8e\v\u87ad", // 螭
	0x87ae: "\x8e\v\u87ae", // 螮
	0x87af: "\x8e\v\u87af", // 螯
	0x87b0: "\x8e\v\u87b0", // 螰
	0x87b1: "\x8e\v\u87b1", // 螱
	0x87b2: "\x8e\v\u87b2", // 螲
	0x87b3: "\x8e\v\u87b3", // 螳
	0x87b4: "\x8e\v\u87b4", // 螴
	0x87b5: "\x8e\v\u87b5", // 螵
	0x87b6: "\x8e\v\u87b6", // 螶
	0x87b7: "\x8e\v\u87b7", // 螷
	0x87b8: "\x8e\v\u87b8", // 螸
	0x87b9: "\x8e\v\u87b9", // 螹
	0x87ba: "\x8e\v\u87ba", // 螺
	0x87bb: "\x8e\v\u87bb", // 螻
	0x87bc: "\x8e\v\u87bc", // 螼
	0x87bd: "\x8e\v\u87bd", // 螽
	0x87be: "\x8e\v\u87be", // 螾
	0x87bf: "\x8e\v\u87bf", // 螿
	0x87c0: "\x8e\v\u87c0", // 蟀
	0x87c1: "\x8e\v\u87c1", // 蟁
	0x87c2: "\x8e\v\u87c2", // 蟂
	0x87c3: "\x8e\v\u87c3", // 蟃
	0x87c4: "\x8e\v\u87c4", // 蟄
	0x87c5: "\x8e\v\u87c5", // 蟅
	0x87c6: "\x8e\v\u87c6", // 蟆
	0x87c7: "\x8e\v\u87c7", // 蟇
	0x87c8: "\x8e\v\u87c8", // 蟈
	0x87c9: "\x8e\v\u87c9", // 蟉
	0x87ca: "\x8e\v\u87ca", // 蟊
	0x87cb: "\x8e\v\u87cb", // 蟋
	0x87cc: "\x8e\v\u87cc", // 蟌
	0x87cd: "\x8e\v\u87cd", // 蟍
	0x87ce: "\x8e\v\u87ce", // 蟎
	0x87cf: "\x8e\v\u87cf", // 蟏
	0x87d0: "\x8e\v\u87d0", // 蟐
	0x87d1: "\x8e\v\u87d1", // 蟑
	0x87d2: "\x8e\v\u87d2", // 蟒
	0x87d3: "\x8e\f\u87d3", // 蟓
	0x87d4: "\x8e\f\u87d4", // 蟔
	0x87d5: "\x8e\f\u87d5", // 蟕
	0x87d6: "\x8e\f\u87d6", // 蟖
	0x87d7: "\x8e\n\u87d7", // 蟗
	0x87d8: "\x8e\f\u87d8", // 蟘
	0x87d9: "\x8e\f\u87d9", // 蟙
	0x87da: "\x8e\f\u87da", // 蟚
	0x87db: "\x8e\f\u87db", // 蟛
	0x87dc: "\x8e\f\u87dc", // 蟜
	0x87dd: "\x8e\f\u87dd", // 蟝
	0x87de: "\x8e\f\u87de", // 蟞
	0x87df: "\x8e\f\u87df", // 蟟
	0x87e0: "\x8e\f\u87e0", // 蟠
	0x87e1: "\x8e\t\u87e1", // 蟡
	0x87e2: "\x8e\f\u87e2", // 蟢
	0x87e3: "\x8e\f\u87e3", // 蟣
	0x87e4: "\x8e\f\u87e4", // 蟤
	0x87e5: "\x8e\f\u87e5", // 蟥
	0x87e6: "\x8e\f\u87e6", // 蟦
	0x87e7: "\x8e\f\u87e7", // 蟧
	0x87e8: "\x8e\f\u87e8", // 蟨
	0x87e9: "\x8e\f\u87e9", // 蟩
	0x87ea: "\x8e\f\u87ea", // 蟪
	0x87eb: "\x8e\f\u87eb", // 蟫
	0x87ec: "\x8e\f\u87ec", // 蟬
	0x87ed: "\x8e\f\u87ed", // 蟭
	0x87ee: "\x8e\f\u87ee", // 蟮
	0x87ef: "\x8e\f\u87ef", // 蟯
	0x87f0: "\x8e\f\u87f0", // 蟰
	0x87f1: "\x8e\f\u87f1", // 蟱
	0x87f2: "\x8e\f\u87f2", // 蟲
	0x87f3: "\x8e\f\u87f3", // 蟳
	0x87f4: "\x8e\f\u87f4", // 蟴
	0x87f5: "\x8e\f\u87f5", // 蟵
	0x87f6: "\x8e\r\u87f6", // 蟶
	0x87f7: "\x8e\r\u87f7", // 蟷
	0x87f8: "\x8e\r\u87f8", // 蟸
	0x87f9: "\x8e\r\u87f9", // 蟹
	0x87fa: "\x8e\r\u87fa", // 蟺
	0x87fb: "\x8e\r\u87fb", // 蟻
	0x87fc: "\x8e\r\u87fc", // 蟼
	0x87fd: "\x8e\r\u87fd", // 蟽
	0x87fe: "\x8e\r\u87fe", // 蟾
	0x87ff: "\x8e\r\u87ff", // 蟿
	0x8800: "\x8e\r\u8800", // 蠀
	0x8801: "\x8e\v\u8801", // 蠁
	0x8802: "\x8e\r\u8802", // 蠂
	0x8803: "\x8e\r\u8803", // 蠃
	0x8804: "\x8e\r\u8804", // 蠄
	0x8805: "\x8e\r\u8805", // 蠅
	0x8806: "\x8e\r\u8806", // 蠆
	0x8807: "\x8e\r\u8807", // 蠇
	0x8808: "\x8e\r\u8808", // 蠈
	0x8809: "\x8e\r\u8809", // 蠉
	0x880a: "\x8e\r\u880a", // 蠊
	0x880b: "\x8e\r\u880b", // 蠋
	0x880c: "\x8e\r\u880c", // 蠌
	0x880d: "\x8e\r\u880d", // 蠍
	0x880e: "\x8e\f\u880e", // 蠎
	0x880f: "\x8e\r\u880f", // 蠏
	0x8810: "\x8e\x0e\u8810", // 蠐
	0x8811: "\x8e\x0e\u8811", // 蠑
	0x8812: "\x8e\x0e\u8812", // 蠒
	0x8813: "\x8e\x0e\u8813", // 蠓
	0x8814: "\x8e\x0e\u8814", // 蠔
	0x8815: "\x8e\x0e\u8815", // 蠕
	0x8816: "\x8e\x0e\u8816", // 蠖
	0x8817: "\x8e\x0e\u8817", // 蠗
	0x8818: "\x8e\x0e\u8818", // 蠘
	0x8819: "\x8e\x0e\u8819", // 蠙
	0x881a: "\x8e\x0f\u881a", // 蠚
	0x881b: "\x8e\x0f\u881b", // 蠛
	0x881c: "\x8e\x0f\u881c", // 蠜
	0x881d: "\x8e\x0f\u881d", // 蠝
	0x881e: "\x8e\x0f\u881e", // 蠞
	0x881f: "\x8e\x0f\u881f", // 蠟
	0x8820: "\x8e\x0f\u8820", // 蠠
	0x8821: "\x8e\x0f\u8821", // 蠡
	0x8822: "\x8e\x0f\u8822", // 蠢
	0x8823: "\x8e\x0f\u8823", // 蠣
	0x8824: "\x8e\x0f\u8824", // 蠤
	0x8825: "\x8e\x10\u8825", // 蠥
	0x8826: "\x8e\x10\u8826", // 蠦
	0x8827: "\x8e\x10\u8827", // 蠧
	0x8828: "\x8e\x10\u8828", // 蠨
	0x8829: "\x8e\x10\u8829", // 蠩
	0x882a: "\x8e\x10\u882a", // 蠪
	0x882b: "\x8e\x10\u882b", // 蠫
	0x882c: "\x8e\x10\u882c", // 蠬
	0x882d: "\x8e\x11\u882d", // 蠭
	0x882e: "\x8e\x11\u882e", // 蠮
	0x882f: "\x8e\x11\u882f", // 蠯
	0x8830: "\x8e\x11\u8830", // 蠰
	0x8831: "\x8e\x11\u8831", // 蠱
	0x8832: "\x8e\x11\u8832", // 蠲
	0x8833: "\x8e\x11\u8833", // 蠳
	0x8834: "\x8e\x0f\u8834", // 蠴
	0x8835: "\x8e\x12\u8835", // 蠵
	0x8836: "\x8e\x12\u8836", // 蠶
	0x8837: "\x8e\x12\u8837", // 蠷
	0x8838: "\x8e\x12\u8838", // 蠸
	0x8839: "\x8e\x12\u8839", // 蠹
	0x883a: "\x8e\x12\u883a", // 蠺
	0x883b: "\x8e\x13\u883b", // 蠻
	0x883c: "\x8e\x14\u883c", // 蠼
	0x883d: "\x8e\x15\u883d", // 蠽
	0x883e: "\x8e\x15\u883e", // 蠾
	0x883f: "\x8e\x16\u883f", // 蠿
	0x8840: "\x8f\x00\u8840", // 血
	0x8841: "\x8f\x03\u8841", // 衁
	0x8842: "\x8f\x03\u8842", // 衂
	0x8843: "\x8f\x04\u8843", // 衃
	0x8844: "\x8f\x04\u8844", // 衄
	0x8845: "\x8f\x05\u8845", // 衅
	0x8846: "\x8f\x06\u8846", // 衆
	0x8847: "\x8f\x06\u8847", // 衇
	0x8848: "\x8f\x06\u8848", // 衈
	0x8849: "\x8f\x06\u8849", // 衉
	0x884a: "\x8f\x0f\u884a", // 衊
	0x884b: "\x8f\x12\u884b", // 衋
	0x884c: "\x90\x00\u884c", // 行
	0x884d: "\x90\x03\u884d", // 衍
	0x884e: "\x90\x03\u884e", // 衎
	0x884f: "\x90\x04\u884f", // 衏
	0x8850: "\x90\x05\u8850", // 衐
	0x8851: "\x90\x05\u8851", // 衑
	0x8852: "\x90\x05\u8852", // 衒
	0x8853: "\x90\x05\u8853", // 術
	0x8854: "\x90\x05\u8854", // 衔
	0x8855: "\x90\x06\u8855", // 衕
	0x8856: "\x90\x06\u8856", // 衖
	0x8857: "\x90\x06\u8857", // 街
	0x8858: "\x90\x06\u8858", // 衘
	0x8859: "\x90\a\u8859", // 衙
	0x885a: "\x90\t\u885a", // 衚
	0x885b: "\x90\t\u885b", // 衛
	0x885c: "\x90\t\u885c", // 衜
	0x885d: "\x90\t\u885d", // 衝
	0x885e: "\x90\n\u885e", // 衞
	0x885f: "\x90\n\u885f", // 衟
	0x8860: "\x90\n\u8860", // 衠
	0x8861: "\x90\n\u8861", // 衡
	0x8862: "\x90\x12\u8862", // 衢
	0x8863: "\x91\x00\u8863", // 衣
	0x8864: "\x91\x00\u8864", // 衤
	0x8865: "\x91\x02\u8865", // 补
	0x8866: "\x91\x03\u8866", // 衦
	0x8867: "\x91\x03\u8867", // 衧
	0x8868: "\x91\x03\u8868", // 表
	0x8869: "\x91\x03\u8869", // 衩
	0x886a: "\x91\x03\u886a", // 衪
	0x886b: "\x91\x03\u886b", // 衫
	0x886c: "\x91\x03\u886c", // 衬
	0x886d: "\x91\x04\u886d", // 衭
	0x886e: "\x91\x04\u886e", // 衮
	0x886f: "\x91\x04\u886f", // 衯
	0x8870: "\x91\x04\u8870", // 衰
	0x8871: "\x91\x04\u8871", // 衱
	0x8872: "\x91\x04\u8872", // 衲
	0x8873: "\x91\x04\u8873", // 衳
	0x8874: "\x91\x04\u8874", // 衴
	0x8875: "\x91\x04\u8875", // 衵
	0x8876: "\x91\x04\u8876", // 衶
	0x8877: "\x91\x04\u8877", // 衷
	0x8878: "\x91\x04\u8878", // 衸
	0x8879: "\x91\x04\u8879", // 衹
	0x887a: "\x91\x04\u887a", // 衺
	0x887b: "\x91\x04\u887b", // 衻
	0x887c: "\x91\x04\u887c", // 衼
	0x887d: "\x91\x04\u887d", // 衽
	0x887e: "\x91\x04\u887e", // 衾
	0x887f: "\x91\x04\u887f", // 衿
	0x8880: "\x91\x04\u8880", // 袀
	0x8881: "\x91\x04\u8881", // 袁
	0x8882: "\x91\x04\u8882", // 袂
	0x8883: "\x91\x04\u8883", // 袃
	0x8884: "\x91\x04\u8884", // 袄
	0x8885: "\x91\x04\u8885", // 袅
	0x8886: "\x91\x04\u8886", // 袆
	0x8887: "\x91\x04\u8887", // 袇
	0x8888: "\x91\x05\u8888", // 袈
	0x8889: "\x91\x05\u8889", // 袉
	0x888a: "\x91\x05\u888a", // 袊
	0x888b: "\x91\x05\u888b", // 袋
	0x888c: "\x91\x05\u888c", // 袌
	0x888d: "\x91\x05\u888d", // 袍
	0x888e: "\x91\x05\u888e", // 袎
	0x888f: "\x91\x05\u888f", // 袏
	0x8890: "\x91\x05\u8890", // 袐
	0x8891: "\x91\x05\u8891", // 袑
	0x8892: "\x91\x05\u8892", // 袒
	0x8893: "\x91\x05\u8893", // 袓
	0x8894: "\x91\x05\u8894", // 袔
	0x8895: "\x91\x05\u8895", // 袕
	0x8896: "\x91\x05\u8896", // 袖
	0x8897: "\x91\x05\u8897", // 袗
	0x8898: "\x91\x05\u8898", // 袘
	0x8899: "\x91\x05\u8899", // 袙
	0x889a: "\x91\x05\u889a", // 袚
	0x889b: "\x91\x05\u889b", // 袛
	0x889c: "\x91\x05\u889c", // 袜
	0x889d: "\x91\x05\u889d", // 袝
	0x889e: "\x91\x05\u889e", // 袞
	0x889f: "\x91\x05\u889f", // 袟
	0x88a0: "\x91\x05\u88a0", // 袠
	0x88a1: "\x91\x05\u88a1", // 袡
	0x88a2: "\x91\x05\u88a2", // 袢
	0x88a3: "\x91\x05\u88a3", // 袣
	0x88a4: "\x91\x05\u88a4", // 袤
	0x88a5: "\x91\x05\u88a5", // 袥
	0x88a6: "\x91\x05\u88a6", // 袦
	0x88a7: "\x91\x05\u88a7", // 袧
	0x88a8: "\x91\x05\u88a8", // 袨
	0x88a9: "\x91\x05\u88a9", // 袩
	0x88aa: "\x91\x05\u88aa", // 袪
	0x88ab: "\x91\x05\u88ab", // 被
	0x88ac: "\x91\x05\u88ac", // 袬
	0x88ad: "\x91\x05\u88ad", // 袭
	0x88ae: "\x91\x05\u88ae", // 袮
	0x88af: "\x91\x06\u88af", // 袯
	0x88b0: "\x91\x05\u88b0", // 袰
	0x88b1: "\x91\x06\u88b1", // 袱
	0x88b2: "\x91\x06\u88b2", // 袲
	0x88b3: "\x91\x06\u88b3", // 袳
	0x88b4: "\x91\x06\u88b4", // 袴
	0x88b5: "\x91\x06\u88b5", // 袵
	0x88b6: "\x91\x06\u88b6", // 袶
	0x88b7: "\x91\x06\u88b7", // 袷
	0x88b8: "\x91\x06\u88b8", // 袸
	0x88b9: "\x91\x06\u88b9", // 袹
	0x88ba: "\x91\x06\u88ba", // 袺
	0x88bb: "\x91\x06\u88bb", // 袻
	0x88bc: "\x91\x06\u88bc", // 袼
	0x88bd: "\x91\x06\u88bd", // 袽
	0x88be: "\x91\x06\u88be", // 袾
	0x88bf: "\x91\x06\u88bf", // 袿
	0x88c0: "\x91\x06\u88c0", // 裀
	0x88c1: "\x91\x06\u88c1", // 裁
	0x88c2: "\x91\x06\u88c2", // 裂
	0x88c3: "\x91\x06\u88c3", // 裃
	0x88c4: "\x91\x06\u88c4", // 裄
	0x88c5: "\x91\x06\u88c5", // 装
	0x88c6: "\x91\x06\u88c6", // 裆
	0x88c7: "\x91\x06\u88c7", // 裇
	0x88c8: "\x91\x06\u88c8", // 裈
	0x88c9: "\x91\x06\u88c9", // 裉
	0x88ca: "\x91\a\u88ca", // 裊
	0x88cb: "\x91\a\u88cb", // 裋
	0x88cc: "\x91\a\u88cc", // 裌
	0x88cd: "\x91\a\u88cd", // 裍
	0x88ce: "\x91\a\u88ce", // 裎
	0x88cf: "\x91\a\u88cf", // 裏
	0x88d0: "\x91\a\u88d0", // 裐
	0x88d1: "\x91\a\u88d1", // 裑
	0x88d2: "\x91\a\u88d2", // 裒
	0x88d3: "\x91\a\u88d3", // 裓
	0x88d4: "\x91\a\u88d4", // 裔
	0x88d5: "\x91\a\u88d5", // 裕
	0x88d6: "\x91\a\u88d6", // 裖
	0x88d7: "\x91\a\u88d7", // 裗
	0x88d8: "\x91\a\u88d8", // 裘
	0x88d9: "\x91\a\u88d9", // 裙
	0x88da: "\x91\a\u88da", // 裚
	0x88db: "\x91\a\u88db", // 裛
	0x88dc: "\x91\a\u88dc", // 補
	0x88dd: "\x91\a\u88dd", // 裝
	0x88de: "\x91\a\u88de", // 裞
	0x88df: "\x91\a\u88df", // 裟
	0x88e0: "\x91\a\u88e0", // 裠
	0x88e1: "\x91\a\u88e1", // 裡
	0x88e2: "\x91\a\u88e2", // 裢
	0x88e3: "\x91\a\u88e3", // 裣
	0x88e4: "\x91\a\u88e4", // 裤
	0x88e5: "\x91\a\u88e5", // 裥
	0x88e6: "\x91\t\u88e6", // 裦
	0x88e7: "\x91\b\u88e7", // 裧
	0x88e8: "\x91\b\u88e8", // 裨
	0x88e9: "\x91\b\u88e9", // 裩
	0x88ea: "\x91\b\u88ea", // 裪
	0x88eb: "\x91\b\u88eb", // 裫
	0x88ec: "\x91\b\u88ec", // 裬
	0x88ed: "\x91\b\u88ed", // 裭
	0x88ee: "\x91\b\u88ee", // 裮
	0x88ef: "\x91\b\u88ef", // 裯
	0x88f0: "\x91\b\u88f0", // 裰
	0x88f1: "\x91\b\u88f1", // 裱
	0x88f2: "\x91\b\u88f2", // 裲
	0x88f3: "\x91\b\u88f3", // 裳
	0x88f4: "\x91\b\u88f4", // 裴
	0x88f5: "\x91\b\u88f5", // 裵
	0x88f6: "\x91\b\u88f6", // 裶
	0x88f7: "\x91\b\u88f7", // 裷
	0x88f8: "\x91\b\u88f8", // 裸
	0x88f9: "\x91\b\u88f9", // 裹
	0x88fa: "\x91\b\u88fa", // 裺
	0x88fb: "\x91\b\u88fb", // 裻
	0x88fc: "\x91\b\u88fc", // 裼
	0x88fd: "\x91\b\u88fd", // 製
	0x88fe: "\x91\b\u88fe", // 裾
	0x88ff: "\x91\b\u88ff", // 裿
	0x8900: "\x91\b\u8900", // 褀
	0x8901: "\x91\b\u8901", // 褁
	0x8902: "\x91\b\u8902", // 褂
	0x8903: "\x91\b\u8903", // 褃
	0x8904: "\x91\b\u8904", // 褄
	0x8905: "\x91\t\u8905", // 褅
	0x8906: "\x91\t\u8906", // 褆
	0x8907: "\x91\t\u8907", // 複
	0x8908: "\x91\t\u8908", // 褈
	0x8909: "\x91\t\u8909", // 褉
	0x890a: "\x91\t\u890a", // 褊
	0x890b: "\x91\t\u890b", // 褋
	0x890c: "\x91\t\u890c", // 褌
	0x890d: "\x91\t\u890d", // 褍
	0x890e: "\x91\t\u890e", // 褎
	0x890f: "\x91\t\u890f", // 褏
	0x8910: "\x91\t\u8910", // 褐
	0x8911: "\x91\t\u8911", // 褑
	0x8912: "\x91\t\u8912", // 褒
	0x8913: "\x91\t\u8913", // 褓
	0x8914: "\x91\t\u8914", // 褔
	0x8915: "\x91\t\u8915", // 褕
	0x8916: "\x91\t\u8916", // 褖
	0x8917: "\x91\t\u8917", // 褗
	0x8918: "\x91\t\u8918", // 褘
	0x8919: "\x91\t\u8919", // 褙
	0x891a: "\x91\t\u891a", // 褚
	0x891b: "\x91\t\u891b", // 褛
	0x891c: "\x91\t\u891c", // 褜
	0x891d: "\x91\t\u891d", // 褝
	0x891e: "\x91\n\u891e", // 褞
	0x891f: "\x91\n\u891f", // 褟
	0x8920: "\x91\n\u8920", // 褠
	0x8921: "\x91\n\u8921", // 褡
	0x8922: "\x91\n\u8922", // 褢
	0x8923: "\x91\n\u8923", // 褣
	0x8924: "\x91\n\u8924", // 褤
	0x8925: "\x91\n\u8925", // 褥
	0x8926: "\x91\n\u8926", // 褦
	0x8927: "\x91\n\u8927", // 褧
	0x8928: "\x91\n\u8928", // 褨
	0x8929: "\x91\n\u8929", // 褩
	0x892a: "\x91\n\u892a", // 褪
	0x892b: "\x91\n\u892b", // 褫
	0x892c: "\x91\n\u892c", // 褬
	0x892d: "\x91\n\u892d", // 褭
	0x892e: "\x91\n\u892e", // 褮
	0x892f: "\x91\n\u892f", // 褯
	0x8930: "\x91\n\u8930", // 褰
	0x8931: "\x91\n\u8931", // 褱
	0x8932: "\x91\n\u8932", // 褲
	0x8933: "\x91\v\u8933", // 褳
	0x8934: "\x91\n\u8934", // 褴
	0x8935: "\x91\v\u8935", // 褵
	0x8936: "\x91\v\u8936", // 褶
	0x8937: "\x91\v\u8937", // 褷
	0x8938: "\x91\v\u8938", // 褸
	0x8939: "\x91\v\u8939", // 褹
	0x893a: "\x91\v\u893a", // 褺
	0x893b: "\x91\v\u893b", // 褻
	0x893c: "\x91\v\u893c", // 褼
	0x893d: "\x91\v\u893d", // 褽
	0x893e: "\x91\v\u893e", // 褾
	0x893f: "\x91\v\u893f", // 褿
	0x8940: "\x91\v\u8940", // 襀
	0x8941: "\x91\v\u8941", // 襁
	0x8942: "\x91\v\u8942", // 襂
	0x8943: "\x91\v\u8943", // 襃
	0x8944: "\x91\v\u8944", // 襄
	0x8945: "\x91\v\u8945", // 襅
	0x8946: "\x91\f\u8946", // 襆
	0x8947: "\x91\f\u8947", // 襇
	0x8948: "\x91\f\u8948", // 襈
	0x8949: "\x91\f\u8949", // 襉
	0x894a: "\x91\f\u894a", // 襊
	0x894b: "\x91\f\u894b", // 襋
	0x894c: "\x91\f\u894c", // 襌
	0x894d: "\x91\f\u894d", // 襍
	0x894e: "\x91\f\u894e", // 襎
	0x894f: "\x91\f\u894f", // 襏
	0x8950: "\x91\f\u8950", // 襐
	0x8951: "\x91\f\u8951", // 襑
	0x8952: "\x91\f\u8952", // 襒
	0x8953: "\x91\f\u8953", // 襓
	0x8954: "\x91\v\u8954", // 襔
	0x8955: "\x91\f\u8955", // 襕
	0x8956: "\x91\r\u8956", // 襖
	0x8957: "\x91\r\u8957", // 襗
	0x8958: "\x91\r\u8958", // 襘
	0x8959: "\x91\r\u8959", // 襙
	0x895a: "\x91\r\u895a", // 襚
	0x895b: "\x91\r\u895b", // 襛
	0x895c: "\x91\r\u895c", // 襜
	0x895d: "\x91\r\u895d", // 襝
	0x895e: "\x91\r\u895e", // 襞
	0x895f: "\x91\r\u895f", // 襟
	0x8960: "\x91\r\u8960", // 襠
	0x8961: "\x91\r\u8961", // 襡
	0x8962: "\x91\r\u8962", // 襢
	0x8963: "\x91\x0e\u8963", // 襣
	0x8964: "\x91\x0e\u8964", // 襤
	0x8965: "\x91\x0e\u8965", // 襥
	0x8966: "\x91\x0e\u8966", // 襦
	0x8967: "\x91\x0e\u8967", // 襧
	0x8968: "\x91\x0e\u8968", // 襨
	0x8969: "\x91\x0f\u8969", // 襩
	0x896a: "\x91\x0f\u896a", // 襪
	0x896b: "\x91\x0f\u896b", // 襫
	0x896c: "\x91\x0f\u896c", // 襬
	0x896d: "\x91\x0f\u896d", // 襭
	0x896e: "\x91\x0f\u896e", // 襮
	0x896f: "\x91\x10\u896f", // 襯
	0x8970: "\x91\x10\u8970", // 襰
	0x8971: "\x91\x10\u8971", // 襱
	0x8972: "\x91\x10\u8972", // 襲
	0x8973: "\x91\x11\u8973", // 襳
	0x8974: "\x91\x11\u8974", // 襴
	0x8975: "\x91\x12\u8975", // 襵
	0x8976: "\x91\x12\u8976", // 襶
	0x8977: "\x91\x12\u8977", // 襷
	0x8978: "\x91\x13\u8978", // 襸
	0x8979: "\x91\x13\u8979", // 襹
	0x897a: "\x91\x13\u897a", // 襺
	0x897b: "\x91\x13\u897b", // 襻
	0x897c: "\x91\x13\u897c", // 襼
	0x897d: "\x91\x11\u897d", // 襽
	0x897e: "\x92\x00\u897e", // 襾
	0x897f: "\x92\x00\u897f", // 西
	0x8980: "\x92\x00\u8980", // 覀
	0x8981: "\x92\x03\u8981", // 要
	0x8982: "\x92\x05\u8982", // 覂
	0x8983: "\x92\x06\u8983", // 覃
	0x8984: "\x92\x06\u8984", // 覄
	0x8985: "\x92\a\u8985", // 覅
	0x8986: "\x92\f\u8986", // 覆
	0x8987: "\x92\r\u8987", // 覇
	0x8988: "\x92\r\u8988", // 覈
	0x8989: "\x92\x11\u8989", // 覉
	0x898a: "\x92\x13\u898a", // 覊
	0x898b: "\x93\x00\u898b", // 見
	0x898c: "\x93\x02\u898c", // 覌
	0x898d: "\x93\x03\u898d", // 覍
	0x898e: "\x93\x03\u898e", // 覎
	0x898f: "\x93\x04\u898f", // 規
	0x8990: "\x93\x04\u8990", // 覐
	0x8991: "\x93\x04\u8991", // 覑
	0x8992: "\x93\x04\u8992", // 覒
	0x8993: "\x93\x04\u8993", // 覓
	0x8994: "\x93\x04\u8994", // 覔
	0x8995: "\x93\x05\u8995", // 覕
	0x8996: "q\a\u8996", // 視
	0x8997: "\x93\x05\u8997", // 覗
	0x8998: "\x93\x05\u8998", // 覘
	0x8999: "\x93\x02\u8999", // 覙
	0x899a: "\x93\x05\u899a", // 覚
	0x899b: "\x93\x06\u899b", // 覛
	0x899c: "\x93\x06\u899c", // 覜
	0x899d: "\x93\a\u899d", // 覝
	0x899e: "\x93\a\u899e", // 覞
	0x899f: "\x93\a\u899f", // 覟
	0x89a0: "\x93\a\u89a0", // 覠
	0x89a1: "\x93\a\u89a1", // 覡
	0x89a2: "\x93\b\u89a2", // 覢
	0x89a3: "\x93\b\u89a3", // 覣
	0x89a4: "\x93\b\u89a4", // 覤
	0x89a5: "\x93\b\u89a5", // 覥
	0x89a6: "\x93\t\u89a6", // 覦
	0x89a7: "\x93\t\u89a7", // 覧
	0x89a8: "\x93\t\u89a8", // 覨
	0x89a9: "\x93\t\u89a9", // 覩
	0x89aa: "\x93\t\u89aa", // 親
	0x89ab: "\x93\n\u89ab", // 覫
	0x89ac: "\x93\n\u89ac", // 覬
	0x89ad: "\x93\n\u89ad", // 覭
	0x89ae: "\x93\n\u89ae", // 覮
	0x89af: "\x93\n\u89af", // 覯
	0x89b0: "\x93\v\u89b0", // 覰
	0x89b1: "\x93\v\u89b1", // 覱
	0x89b2: "\x93\v\u89b2", // 覲
	0x89b3: "\x93\v\u89b3", // 観
	0x89b4: "\x93\f\u89b4", // 覴
	0x89b5: "\x93\f\u89b5", // 覵
	0x89b6: "\x93\f\u89b6", // 覶
	0x89b7: "\x93\f\u89b7", // 覷
	0x89b8: "\x93\f\u89b8", // 覸
	0x89b9: "\x93\r\u89b9", // 覹
	0x89ba: "\x93\r\u89ba", // 覺
	0x89bb: "\x93\r\u89bb", // 覻
	0x89bc: "\x93\x0e\u89bc", // 覼
	0x89bd: "\x93\x0e\u89bd", // 覽
	0x89be: "\x93\x0f\u89be", // 覾
	0x89bf: "\x93\x0f\u89bf", // 覿
	0x89c0: "\x93\x12\u89c0", // 觀
	0x89c1: "\x93\x00\u89c1", // 见
	0x89c2: "\x93\x02\u89c2", // 观
	0x89c3: "\x93\x03\u89c3", // 觃
	0x89c4: "\x93\x04\u89c4", // 规
	0x89c5: "\x93\x04\u89c5", // 觅
	0x89c6: "q\x04\u89c6", // 视
	0x89c7: "\x93\x05\u89c7", // 觇
	0x89c8: "\x93\x05\u89c8", // 览
	0x89c9: "\x93\x05\u89c9", // 觉
	0x89ca: "\x93\x06\u89ca", // 觊
	0x89cb: "\x93\a\u89cb", // 觋
	0x89cc: "\x93\b\u89cc", // 觌
	0x89cd: "\x93\b\u89cd", // 觍
	0x89ce: "\x93\t\u89ce", // 觎
	0x89cf: "\x93\n\u89cf", // 觏
	0x89d0: "\x93\v\u89d0", // 觐
	0x89d1: "\x93\v\u89d1", // 觑
	0x89d2: "\x94\x00\u89d2", // 角
	0x89d3: "\x94\x02\u89d3", // 觓
	0x89d4: "\x94\x02\u89d4", // 觔
	0x89d5: "\x94\x04\u89d5", // 觕
	0x89d6: "\x94\x04\u89d6", // 觖
	0x89d7: "\x94\x04\u89d7", // 觗
	0x89d8: "\x94\x04\u89d8", // 觘
	0x89d9: "\x94\x04\u89d9", // 觙
	0x89da: "\x94\x05\u89da", // 觚
	0x89db: "\x94\x05\u89db", // 觛
	0x89dc: "\x94\x06\u89dc", // 觜
	0x89dd: "\x94\x05\u89dd", // 觝
	0x89de: "\x94\x05\u89de", // 觞
	0x89df: "\x94\x06\u89df", // 觟
	0x89e0: "\x94\x06\u89e0", // 觠
	0x89e1: "\x94\x06\u89e1", // 觡
	0x89e2: "\x94\x06\u89e2", // 觢
	0x89e3: "\x94\x06\u89e3", // 解
	0x89e4: "\x94\x06\u89e4", // 觤
	0x89e5: "\x94\x06\u89e5", // 觥
	0x89e6: "\x94\x06\u89e6", // 触
	0x89e7: "\x94\x06\u89e7", // 觧
	0x89e8: "\x94\a\u89e8", // 觨
	0x89e9: "\x94\a\u89e9", // 觩
	0x89ea: "\x94\a\u89ea", // 觪
	0x89eb: "\x94\a\u89eb", // 觫
	0x89ec: "\x94\b\u89ec", // 觬
	0x89ed: "\x94\b\u89ed", // 觭
	0x89ee: "\x94\b\u89ee", // 觮
	0x89ef: "\x94\b\u89ef", // 觯
	0x89f0: "\x94\t\u89f0", // 觰
	0x89f1: "\x94\t\u89f1", // 觱
	0x89f2: "\x94\n\u89f2", // 觲
	0x89f3: "\x94\n\u89f3", // 觳
	0x89f4: "\x94\v\u89f4", // 觴
	0x89f5: "\x94\f\u89f5", // 觵
	0x89f6: "\x94\f\u89f6", // 觶
	0x89f7: "\x94\r\u89f7", // 觷
	0x89f8: "\x94\r\u89f8", // 觸
	0x89f9: "\x94\r\u89f9", // 觹
	0x89fa: "\x94\x0e\u89fa", // 觺
	0x89fb: "\x94\x0f\u89fb", // 觻
	0x89fc: "\x94\x0f\u89fc", // 觼
	0x89fd: "\x94\x10\u89fd", // 觽
	0x89fe: "\x94\x10\u89fe", // 觾
	0x89ff: "\x94\x12\u89ff", // 觿
	0x8a00: "\x95\x00\u8a00", // 言
	0x8a01: "\x95\x00\u8a01", // 訁
	0x8a02: "\x95\x02\u8a02", // 訂
	0x8a03: "\x95\x02\u8a03", // 訃
	0x8a04: "\x95\x02\u8a04", // 訄
	0x8a05: "\x95\x02\u8a05", // 訅
	0x8a06: "\x95\x02\u8a06", // 訆
	0x8a07: "\x95\x02\u8a07", // 訇
	0x8a08: "\x95\x02\u8a08", // 計
	0x8a09: "\x95\x03\u8a09", // 訉
	0x8a0a: "\x95\x03\u8a0a", // 訊
	0x8a0b: "\x95\x03\u8a0b", // 訋
	0x8a0c: "\x95\x03\u8a0c", // 訌
	0x8a0d: "\x95\x03\u8a0d", // 訍
	0x8a0e: "\x95\x03\u8a0e", // 討
	0x8a0f: "\x95\x03\u8a0f", // 訏
	0x8a10: "\x95\x03\u8a10", // 訐
	0x8a11: "\x95\x03\u8a11", // 訑
	0x8a12: "\x95\x03\u8a12", // 訒
	0x8a13: "\x95\x03\u8a13", // 訓
	0x8a14: "\x95\x03\u8a14", // 訔
	0x8a15: "\x95\x03\u8a15", // 訕
	0x8a16: "\x95\x03\u8a16", // 訖
	0x8a17: "\x95\x03\u8a17", // 託
	0x8a18: "\x95\x03\u8a18", // 記
	0x8a19: "\x95\x03\u8a19", // 訙
	0x8a1a: "\x95\x03\u8a1a", // 訚
	0x8a1b: "\x95\x04\u8a1b", // 訛
	0x8a1c: "\x95\x04\u8a1c", // 訜
	0x8a1d: "\x95\x04\u8a1d", // 訝
	0x8a1e: "\x95\x04\u8a1e", // 訞
	0x8a1f: "\x95\x04\u8a1f", // 訟
	0x8a20: "\x95\x04\u8a20", // 訠
	0x8a21: "\x95\x04\u8a21", // 訡
	0x8a22: "\x95\x04\u8a22", // 訢
	0x8a23: "\x95\x04\u8a23", // 訣
	0x8a24: "\x95\x04\u8a24", // 訤
	0x8a25: "\x95\x04\u8a25", // 訥
	0x8a26: "\x95\x04\u8a26", // 訦
	0x8a27: "\x95\x04\u8a27", // 訧
	0x8a28: "\x95\x04\u8a28", // 訨
	0x8a29: "\x95\x04\u8a29", // 訩
	0x8a2a: "\x95\x04\u8a2a", // 訪
	0x8a2b: "\x95\x04\u8a2b", // 訫
	0x8a2c: "\x95\x04\u8a2c", // 訬
	0x8a2d: "\x95\x04\u8a2d", // 設
	0x8a2e: "\x95\x04\u8a2e", // 訮
	0x8a2f: "\x95\x04\u8a2f", // 訯
	0x8a30: "\x95\x04\u8a30", // 訰
	0x8a31: "\x95\x04\u8a31", // 許
	0x8a32: "\x95\x04\u8a32", // 訲
	0x8a33: "\x95\x04\u8a33", // 訳
	0x8a34: "\x95\x05\u8a34", // 訴
	0x8a35: "\x95\x05\u8a35", // 訵
	0x8a36: "\x95\x05\u8a36", // 訶
	0x8a37: "\x95\x05\u8a37", // 訷
	0x8a38: "\x95\x05\u8a38", // 訸
	0x8a39: "\x95\x05\u8a39", // 訹
	0x8a3a: "\x95\x05\u8a3a", // 診
	0x8a3b: "\x95\x05\u8a3b", // 註
	0x8a3c: "\x95\x05\u8a3c", // 証
	0x8a3d: "\x95\x05\u8a3d", // 訽
	0x8a3e: "\x95\x05\u8a3e", // 訾
	0x8a3f: "\x95\x05\u8a3f", // 訿
	0x8a40: "\x95\x05\u8a40", // 詀
	0x8a41: "\x95\x05\u8a41", // 詁
	0x8a42: "\x95\x05\u8a42", // 詂
	0x8a43: "\x95\x05\u8a43", // 詃
	0x8a44: "\x95\x05\u8a44", // 詄
	0x8a45: "\x95\x05\u8a45", // 詅
	0x8a46: "\x95\x05\u8a46", // 詆
	0x8a47: "\x95\x05\u8a47", // 詇
	0x8a48: "\x95\x05\u8a48", // 詈
	0x8a49: "\x95\x05\u8a49", // 詉
	0x8a4a: "\x95\x05\u8a4a", // 詊
	0x8a4b: "\x95\x05\u8a4b", // 詋
	0x8a4c: "\x95\x05\u8a4c", // 詌
	0x8a4d: "\x95\x05\u8a4d", // 詍
	0x8a4e: "\x95\x05\u8a4e", // 詎
	0x8a4f: "\x95\x05\u8a4f", // 詏
	0x8a50: "\x95\x05\u8a50", // 詐
	0x8a51: "\x95\x05\u8a51", // 詑
	0x8a52: "\x95\x05\u8a52", // 詒
	0x8a53: "\x95\x05\u8a53", // 詓
	0x8a54: "\x95\x05\u8a54", // 詔
	0x8a55: "\x95\x05\u8a55", // 評
	0x8a56: "\x95\x05\u8a56", // 詖
	0x8a57: "\x95\x05\u8a57", // 詗
	0x8a58: "\x95\x05\u8a58", // 詘
	0x8a59: "\x95\x05\u8a59", // 詙
	0x8a5a: "\x95\x05\u8a5a", // 詚
	0x8a5b: "\x95\x05\u8a5b", // 詛
	0x8a5c: "\x95\x05\u8a5c", // 詜
	0x8a5d: "\x95\x05\u8a5d", // 詝
	0x8a5e: "\x95\x05\u8a5e", // 詞
	0x8a5f: "\x95\x05\u8a5f", // 詟
	0x8a60: "\x95\x05\u8a60", // 詠
	0x8a61: "\x95\x06\u8a61", // 詡
	0x8a62: "\x95\x06\u8a62", // 詢
	0x8a63: "\x95\x06\u8a63", // 詣
	0x8a64: "\x95\x06\u8a64", // 詤
	0x8a65: "\x95\x06\u8a65", // 詥
	0x8a66: "\x95\x06\u8a66", // 試
	0x8a67: "\x95\x06\u8a67", // 詧
	0x8a68: "\x95\x06\u8a68", // 詨
	0x8a69: "\x95\x06\u8a69", // 詩
	0x8a6a: "\x95\x06\u8a6a", // 詪
	0x8a6b: "\x95\x06\u8a6b", // 詫
	0x8a6c: "\x95\x06\u8a6c", // 詬
	0x8a6d: "\x95\x06\u8a6d", // 詭
	0x8a6e: "\x95\x06\u8a6e", // 詮
	0x8a6f: "\x95\x06\u8a6f", // 詯
	0x8a70: "\x95\x06\u8a70", // 詰
	0x8a71: "\x95\x06\u8a71", // 話
	0x8a72: "\x95\x06\u8a72", // 該
	0x8a73: "\x95\x06\u8a73", // 詳
	0x8a74: "\x95\x06\u8a74", // 詴
	0x8a75: "\x95\x06\u8a75", // 詵
	0x8a76: "\x95\x06\u8a76", // 詶
	0x8a77: "\x95\x06\u8a77", // 詷
	0x8a78: "\x95\x06\u8a78", // 詸
	0x8a79: "\x95\x06\u8a79", // 詹
	0x8a7a: "\x95\x06\u8a7a", // 詺
	0x8a7b: "\x95\x06\u8a7b", // 詻
	0x8a7c: "\x95\x06\u8a7c", // 詼
	0x8a7d: "\x95\x06\u8a7d", // 詽
	0x8a7e: "\x95\x06\u8a7e", // 詾
	0x8a7f: "\x95\x06\u8a7f", // 詿
	0x8a80: "\x95\x06\u8a80", // 誀
	0x8a81: "\x95\x06\u8a81", // 誁
	0x8a82: "\x95\x06\u8a82", // 誂
	0x8a83: "\x95\x06\u8a83", // 誃
	0x8a84: "\x95\x06\u8a84", // 誄
	0x8a85: "\x95\x06\u8a85", // 誅
	0x8a86: "\x95\x06\u8a86", // 誆
	0x8a87: "\x95\x06\u8a87", // 誇
	0x8a88: "\x95\x06\u8a88", // 誈
	0x8a89: "\x95\x06\u8a89", // 誉
	0x8a8a: "\x95\x06\u8a8a", // 誊
	0x8a8b: "\x95\a\u8a8b", // 誋
	0x8a8c: "\x95\a\u8a8c", // 誌
	0x8a8d: "\x95\a\u8a8d", // 認
	0x8a8e: "\x95\a\u8a8e", // 誎
	0x8a8f: "\x95\a\u8a8f", // 誏
	0x8a90: "\x95\a\u8a90", // 誐
	0x8a91: "\x95\a\u8a91", // 誑
	0x8a92: "\x95\a\u8a92", // 誒
	0x8a93: "\x95\a\u8a93", // 誓
	0x8a94: "\x95\a\u8a94", // 誔
	0x8a95: "\x95\a\u8a95", // 誕
	0x8a96: "\x95\a\u8a96", // 誖
	0x8a97: "\x95\a\u8a97", // 誗
	0x8a98: "\x95\a\u8a98", // 誘
	0x8a99: "\x95\a\u8a99", // 誙
	0x8a9a: "\x95\a\u8a9a", // 誚
	0x8a9b: "\x95\a\u8a9b", // 誛
	0x8a9c: "\x95\a\u8a9c", // 誜
	0x8a9d: "\x95\a\u8a9d", // 誝
	0x8a9e: "\x95\a\u8a9e", // 語
	0x8a9f: "\x95\a\u8a9f", // 誟
	0x8aa0: "\x95\x06\u8aa0", // 誠
	0x8aa1: "\x95\a\u8aa1", // 誡
	0x8aa2: "\x95\a\u8aa2", // 誢
	0x8aa3: "\x95\a\u8aa3", // 誣
	0x8aa4: "\x95\a\u8aa4", // 誤
	0x8aa5: "\x95\a\u8aa5", // 誥
	0x8aa6: "\x95\a\u8aa6", // 誦
	0x8aa7: "\x95\a\u8aa7", // 誧
	0x8aa8: "\x95\a\u8aa8", // 誨
	0x8aa9: "\x95\a\u8aa9", // 誩
	0x8aaa: "\x95\a\u8aaa", // 說
	0x8aab: "\x95\a\u8aab", // 誫
	0x8aac: "\x95\a\u8aac", // 説
	0x8aad: "\x95\a\u8aad", // 読
	0x8aae: "\x95\a\u8aae", // 誮
	0x8aaf: "\x95\b\u8aaf", // 誯
	0x8ab0: "\x95\b\u8ab0", // 誰
	0x8ab1: "\x95\b\u8ab1", // 誱
	0x8ab2: "\x95\b\u8ab2", // 課
	0x8ab3: "\x95\b\u8ab3", // 誳
	0x8ab4: "\x95\b\u8ab4", // 誴
	0x8ab5: "\x95\b\u8ab5", // 誵
	0x8ab6: "\x95\b\u8ab6", // 誶
	0x8ab7: "\x95\b\u8ab7", // 誷
	0x8ab8: "\x95\b\u8ab8", // 誸
	0x8ab9: "\x95\b\u8ab9", // 誹
	0x8aba: "\x95\b\u8aba", // 誺
	0x8abb: "\x95\b\u8abb", // 誻
	0x8abc: "\x95\b\u8abc", // 誼
	0x8abd: "\x95\b\u8abd", // 誽
	0x8abe: "\x95\b\u8abe", // 誾
	0x8abf: "\x95\b\u8abf", // 調
	0x8ac0: "\x95\b\u8ac0", // 諀
	0x8ac1: "\x95\b\u8ac1", // 諁
	0x8ac2: "\x95\b\u8ac2", // 諂
	0x8ac3: "\x95\b\u8ac3", // 諃
	0x8ac4: "\x95\b\u8ac4", // 諄
	0x8ac5: "\x95\b\u8ac5", // 諅
	0x8ac6: "\x95\b\u8ac6", // 諆
	0x8ac7: "\x95\b\u8ac7", // 談
	0x8ac8: "\x95\b\u8ac8", // 諈
	0x8ac9: "\x95\b\u8ac9", // 諉
	0x8aca: "\x95\b\u8aca", // 諊
	0x8acb: "\x95\b\u8acb", // 請
	0x8acc: "\x95\b\u8acc", // 諌
	0x8acd: "\x95\b\u8acd", // 諍
	0x8ace: "\x95\b\u8ace", // 諎
	0x8acf: "\x95\b\u8acf", // 諏
	0x8ad0: "\x95\b\u8ad0", // 諐
	0x8ad1: "\x95\b\u8ad1", // 諑
	0x8ad2: "\x95\b\u8ad2", // 諒
	0x8ad3: "\x95\b\u8ad3", // 諓
	0x8ad4: "\x95\b\u8ad4", // 諔
	0x8ad5: "\x95\b\u8ad5", // 諕
	0x8ad6: "\x95\b\u8ad6", // 論
	0x8ad7: "\x95\b\u8ad7", // 諗
	0x8ad8: "\x95\b\u8ad8", // 諘
	0x8ad9: "\x95\b\u8ad9", // 諙
	0x8ada: "\x95\b\u8ada", // 諚
	0x8adb: "\x95\t\u8adb", // 諛
	0x8adc: "\x95\t\u8adc", // 諜
	0x8add: "\x95\t\u8add", // 諝
	0x8ade: "\x95\t\u8ade", // 諞
	0x8adf: "\x95\t\u8adf", // 諟
	0x8ae0: "\x95\t\u8ae0", // 諠
	0x8ae1: "\x95\t\u8ae1", // 諡
	0x8ae2: "\x95\t\u8ae2", // 諢
	0x8ae3: "\x95\t\u8ae3", // 諣
	0x8ae4: "\x95\t\u8ae4", // 諤
	0x8ae5: "\x95\t\u8ae5", // 諥
	0x8ae6: "\x95\t\u8ae6", // 諦
	0x8ae7: "\x95\t\u8ae7", // 諧
	0x8ae8: "\x95\t\u8ae8", // 諨
	0x8ae9: "\x95\b\u8ae9", // 諩
	0x8aea: "\x95\t\u8aea", // 諪
	0x8aeb: "\x95\t\u8aeb", // 諫
	0x8aec: "\x95\t\u8aec", // 諬
	0x8aed: "\x95\t\u8aed", // 諭
	0x8aee: "\x95\t\u8aee", // 諮
	0x8aef: "\x95\t\u8aef", // 諯
	0x8af0: "\x95\t\u8af0", // 諰
	0x8af1: "\x95\t\u8af1", // 諱
	0x8af2: "\x95\t\u8af2", // 諲
	0x8af3: "\x95\t\u8af3", // 諳
	0x8af4: "\x95\t\u8af4", // 諴
	0x8af5: "\x95\t\u8af5", // 諵
	0x8af6: "\x95\t\u8af6", // 諶
	0x8af7: "\x95\t\u8af7", // 諷
	0x8af8: "\x95\t\u8af8", // 諸
	0x8af9: "\x95\t\u8af9", // 諹
	0x8afa: "\x95\t\u8afa", // 諺
	0x8afb: "\x95\t\u8afb", // 諻
	0x8afc: "\x95\t\u8afc", // 諼
	0x8afd: "\x95\t\u8afd", // 諽
	0x8afe: "\x95\t\u8afe", // 諾
	0x8aff: "\x95\t\u8aff", // 諿
	0x8b00: "\x95\t\u8b00", // 謀
	0x8b01: "\x95\t\u8b01", // 謁
	0x8b02: "\x95\t\u8b02", // 謂
	0x8b03: "\x95\t\u8b03", // 謃
	0x8b04: "\x95\n\u8b04", // 謄
	0x8b05: "\x95\n\u8b05", // 謅
	0x8b06: "\x95\n\u8b06", // 謆
	0x8b07: "\x95\n\u8b07", // 謇
	0x8b08: "\x95\n\u8b08", // 謈
	0x8b09: "\x95\n\u8b09", // 謉
	0x8b0a: "\x95\n\u8b0a", // 謊
	0x8b0b: "\x95\n\u8b0b", // 謋
	0x8b0c: "\x95\n\u8b0c", // 謌
	0x8b0d: "\x95\n\u8b0d", // 謍
	0x8b0e: "\x95\n\u8b0e", // 謎
	0x8b0f: "\x95\n\u8b0f", // 謏
	0x8b10: "\x95\n\u8b10", // 謐
	0x8b11: "\x95\n\u8b11", // 謑
	0x8b12: "\x95\n\u8b12", // 謒
	0x8b13: "\x95\n\u8b13", // 謓
	0x8b14: "\x95\n\u8b14", // 謔
	0x8b15: "\x95\n\u8b15", // 謕
	0x8b16: "\x95\n\u8b16", // 謖
	0x8b17: "\x95\n\u8b17", // 謗
	0x8b18: "\x95\n\u8b18", // 謘
	0x8b19: "\x95\n\u8b19", // 謙
	0x8b1a: "\x95\n\u8b1a", // 謚
	0x8b1b: "\x95\n\u8b1b", // 講
	0x8b1c: "\x95\n\u8b1c", // 謜
	0x8b1d: "\x95\n\u8b1d", // 謝
	0x8b1e: "\x95\n\u8b1e", // 謞
	0x8b1f: "\x95\n\u8b1f", // 謟
	0x8b20: "\x95\n\u8b20", // 謠
	0x8b21: "\x95\n\u8b21", // 謡
	0x8b22: "\x95\n\u8b22", // 謢
	0x8b23: "\x95\v\u8b23", // 謣
	0x8b24: "\x95\v\u8b24", // 謤
	0x8b25: "\x95\v\u8b25", // 謥
	0x8b26: "\x95\v\u8b26", // 謦
	0x8b27: "\x95\v\u8b27", // 謧
	0x8b28: "\x95\v\u8b28", // 謨
	0x8b29: "\x95\v\u8b29", // 謩
	0x8b2a: "\x95\v\u8b2a", // 謪
	0x8b2b: "\x95\v\u8b2b", // 謫
	0x8b2c: "\x95\v\u8b2c", // 謬
	0x8b2d: "\x95\v\u8b2d", // 謭
	0x8b2e: "\x95\v\u8b2e", // 謮
	0x8b2f: "\x95\v\u8b2f", // 謯
	0x8b30: "\x95\v\u8b30", // 謰
	0x8b31: "\x95\v\u8b31", // 謱
	0x8b32: "\x95\v\u8b32", // 謲
	0x8b33: "\x95\v\u8b33", // 謳
	0x8b34: "\x95\v\u8b34", // 謴
	0x8b35: "\x95\v\u8b35", // 謵
	0x8b36: "\x95\v\u8b36", // 謶
	0x8b37: "\x95\v\u8b37", // 謷
	0x8b38: "\x95\v\u8b38", // 謸
	0x8b39: "\x95\v\u8b39", // 謹
	0x8b3a: "\x95\v\u8b3a", // 謺
	0x8b3b: "\x95\v\u8b3b", // 謻
	0x8b3c: "\x95\v\u8b3c", // 謼
	0x8b3d: "\x95\v\u8b3d", // 謽
	0x8b3e: "\x95\v\u8b3e", // 謾
	0x8b3f: "\x95\f\u8b3f", // 謿
	0x8b40: "\x95\f\u8b40", // 譀
	0x8b41: "\x95\f\u8b41", // 譁
	0x8b42: "\x95\f\u8b42", // 譂
	0x8b43: "\x95\f\u8b43", // 譃
	0x8b44: "\x95\f\u8b44", // 譄
	0x8b45: "\x95\f\u8b45", // 譅
	0x8b46: "\x95\f\u8b46", // 譆
	0x8b47: "\x95\f\u8b47", // 譇
	0x8b48: "\x95\f\u8b48", // 譈
	0x8b49: "\x95\f\u8b49", // 證
	0x8b4a: "\x95\f\u8b4a", // 譊
	0x8b4b: "\x95\f\u8b4b", // 譋
	0x8b4c: "\x95\f\u8b4c", // 譌
	0x8b4d: "\x95\r\u8b4d", // 譍
	0x8b4e: "\x95\f\u8b4e", // 譎
	0x8b4f: "\x95\f\u8b4f", // 譏
	0x8b50: "\x95\f\u8b50", // 譐
	0x8b51: "\x95\f\u8b51", // 譑
	0x8b52: "\x95\f\u8b52", // 譒
	0x8b53: "\x95\f\u8b53", // 譓
	0x8b54: "\x95\f\u8b54", // 譔
	0x8b55: "\x95\f\u8b55", // 譕
	0x8b56: "\x95\f\u8b56", // 譖
	0x8b57: "\x95\f\u8b57", // 譗
	0x8b58: "\x95\f\u8b58", // 識
	0x8b59: "\x95\f\u8b59", // 譙
	0x8b5a: "\x95\f\u8b5a", // 譚
	0x8b5b: "\x95\f\u8b5b", // 譛
	0x8b5c: "\x95\f\u8b5c", // 譜
	0x8b5d: "\x95\r\u8b5d", // 譝
	0x8b5e: "\x95\r\u8b5e", // 譞
	0x8b5f: "\x95\r\u8b5f", // 譟
	0x8b60: "\x95\r\u8b60", // 譠
	0x8b61: "\x95\r\u8b61", // 譡
	0x8b62: "\x95\r\u8b62", // 譢
	0x8b63: "\x95\r\u8b63", // 譣
	0x8b64: "\x95\r\u8b64", // 譤
	0x8b65: "\x95\r\u8b65", // 譥
	0x8b66: "\x95\r\u8b66", // 警
	0x8b67: "\x95\r\u8b67", // 譧
	0x8b68: "\x95\r\u8b68", // 譨
	0x8b69: "\x95\r\u8b69", // 譩
	0x8b6a: "\x95\r\u8b6a", // 譪
	0x8b6b: "\x95\r\u8b6b", // 譫
	0x8b6c: "\x95\r\u8b6c", // 譬
	0x8b6d: "\x95\r\u8b6d", // 譭
	0x8b6e: "\x95\r\u8b6e", // 譮
	0x8b6f: "\x95\r\u8b6f", // 譯
	0x8b70: "\x95\r\u8b70", // 議
	0x8b71: "\x95\r\u8b71", // 譱
	0x8b72: "\x95\r\u8b72", // 譲
	0x8b73: "\x95\x0e\u8b73", // 譳
	0x8b74: "\x95\x0e\u8b74", // 譴
	0x8b75: "\x95\x0e\u8b75", // 譵
	0x8b76: "\x95\x0e\u8b76", // 譶
	0x8b77: "\x95\x0e\u8b77", // 護
	0x8b78: "\x95\x0e\u8b78", // 譸
	0x8b79: "\x95\x0e\u8b79", // 譹
	0x8b7a: "\x95\x0e\u8b7a", // 譺
	0x8b7b: "\x95\x0e\u8b7b", // 譻
	0x8b7c: "\x95\x0e\u8b7c", // 譼
	0x8b7d: "\x95\x0e\u8b7d", // 譽
	0x8b7e: "\x95\x0f\u8b7e", // 譾
	0x8b7f: "\x95\x0f\u8b7f", // 譿
	0x8b80: "\x95\x0f\u8b80", // 讀
	0x8b81: "\x95\x0f\u8b81", // 讁
	0x8b82: "\x95\x0f\u8b82", // 讂
	0x8b83: "\x95\x0f\u8b83", // 讃
	0x8b84: "\x95\x0f\u8b84", // 讄
	0x8b85: "\x95\x0f\u8b85", // 讅
	0x8b86: "\x95\x10\u8b86", // 讆
	0x8b87: "\x95\x10\u8b87", // 讇
	0x8b88: "\x95\x10\u8b88", // 讈
	0x8b89: "\x95\x10\u8b89", // 讉
	0x8b8a: "\x95\x10\u8b8a", // 變
	0x8b8b: "\x95\x10\u8b8b", // 讋
	0x8b8c: "\x95\x10\u8b8c", // 讌
	0x8b8d: "\x95\x10\u8b8d", // 讍
	0x8b8e: "\x95\x10\u8b8e", // 讎
	0x8b8f: "\x95\x10\u8b8f", // 讏
	0x8b90: "\x95\x10\u8b90", // 讐
	0x8b91: "\x95\x11\u8b91", // 讑
	0x8b92: "\x95\x11\u8b92", // 讒
	0x8b93: "\x95\x11\u8b93", // 讓
	0x8b94: "\x95\x11\u8b94", // 讔
	0x8b95: "\x95\x11\u8b95", // 讕
	0x8b96: "\x95\x11\u8b96", // 讖
	0x8b97: "\x95\x12\u8b97", // 讗
	0x8b98: "\x95\x12\u8b98", // 讘
	0x8b99: "\x95\x12\u8b99", // 讙
	0x8b9a: "\x95\x13\u8b9a", // 讚
	0x8b9b: "\x95\x13\u8b9b", // 讛
	0x8b9c: "\x95\x14\u8b9c", // 讜
	0x8b9d: "\x95\x14\u8b9d", // 讝
	0x8b9e: "\x95\x14\u8b9e", // 讞
	0x8b9f: "\x95\x16\u8b9f", // 讟
	0x8ba0: "\x95\x00\u8ba0", // 讠
	0x8ba1: "\x95\x02\u8ba1", // 计
	0x8ba2: "\x95\x02\u8ba2", // 订
	0x8ba3: "\x95\x02\u8ba3", // 讣
	0x8ba4: "\x95\x02\u8ba4", // 认
	0x8ba5: "\x95\x02\u8ba5", // 讥
	0x8ba6: "\x95\x03\u8ba6", // 讦
	0x8ba7: "\x95\x03\u8ba7", // 讧
	0x8ba8: "\x95\x03\u8ba8", // 讨
	0x8ba9: "\x95\x03\u8ba9", // 让
	0x8baa: "\x95\x03\u8baa", // 讪
	0x8bab: "\x95\x03\u8bab", // 讫
	0x8bac: "\x95\x03\u8bac", // 讬
	0x8bad: "\x95\x03\u8bad", // 训
	0x8bae: "\x95\x03\u8bae", // 议
	0x8baf: "\x95\x03\u8baf", // 讯
	0x8bb0: "\x95\x03\u8bb0", // 记
	0x8bb1: "\x95\x03\u8bb1", // 讱
	0x8bb2: "\x95\x04\u8bb2", // 讲
	0x8bb3: "\x95\x04\u8bb3", // 讳
	0x8bb4: "\x95\x04\u8bb4", // 讴
	0x8bb5: "\x95\x04\u8bb5", // 讵
	0x8bb6: "\x95\x04\u8bb6", // 讶
	0x8bb7: "\x95\x04\u8bb7", // 讷
	0x8bb8: "\x95\x04\u8bb8", // 许
	0x8bb9: "\x95\x04\u8bb9", // 讹
	0x8bba: "\x95\x04\u8bba", // 论
	0x8bbb: "\x95\x04\u8bbb", // 讻
	0x8bbc: "\x95\x04\u8bbc", // 讼
	0x8bbd: "\x95\x04\u8bbd", // 讽
	0x8bbe: "\x95\x04\u8bbe", // 设
	0x8bbf: "\x95\x04\u8bbf", // 访
	0x8bc0: "\x95\x04\u8bc0", // 诀
	0x8bc1: "\x95\x05\u8bc1", // 证
	0x8bc2: "\x95\x05\u8bc2", // 诂
	0x8bc3: "\x95\x05\u8bc3", // 诃
	0x8bc4: "\x95\x05\u8bc4", // 评
	0x8bc5: "\x95\x05\u8bc5", // 诅
	0x8bc6: "\x95\x05\u8bc6", // 识
	0x8bc7: "\x95\x05\u8bc7", // 诇
	0x8bc8: "\x95\x05\u8bc8", // 诈
	0x8bc9: "\x95\x05\u8bc9", // 诉
	0x8bca: "\x95\x05\u8bca", // 诊
	0x8bcb: "\x95\x05\u8bcb", // 诋
	0x8bcc: "\x95\x05\u8bcc", // 诌
	0x8bcd: "\x95\x05\u8bcd", // 词
	0x8bce: "\x95\x05\u8bce", // 诎
	0x8bcf: "\x95\x05\u8bcf", // 诏
	0x8bd0: "\x95\x05\u8bd0", // 诐
	0x8bd1: "\x95\x05\u8bd1", // 译
	0x8bd2: "\x95\x05\u8bd2", // 诒
	0x8bd3: "\x95\x06\u8bd3", // 诓
	0x8bd4: "\x95\x06\u8bd4", // 诔
	0x8bd5: "\x95\x06\u8bd5", // 试
	0x8bd6: "\x95\x06\u8bd6", // 诖
	0x8bd7: "\x95\x06\u8bd7", // 诗
	0x8bd8: "\x95\x06\u8bd8", // 诘
	0x8bd9: "\x95\x06\u8bd9", // 诙
	0x8bda: "\x95\x06\u8bda", // 诚
	0x8bdb: "\x95\x06\u8bdb", // 诛
	0x8bdc: "\x95\x06\u8bdc", // 诜
	0x8bdd: "\x95\x06\u8bdd", // 话
	0x8bde: "\x95\x06\u8bde", // 诞
	0x8bdf: "\x95\x06\u8bdf", // 诟
	0x8be0: "\x95\x06\u8be0", // 诠
	0x8be1: "\x95\x06\u8be1", // 诡
	0x8be2: "\x95\x06\u8be2", // 询
	0x8be3: "\x95\x06\u8be3", // 诣
	0x8be4: "\x95\x06\u8be4", // 诤
	0x8be5: "\x95\x06\u8be5", // 该
	0x8be6: "\x95\x06\u8be6", // 详
	0x8be7: "\x95\x06\u8be7", // 诧
	0x8be8: "\x95\x06\u8be8", // 诨
	0x8be9: "\x95\x06\u8be9", // 诩
	0x8bea: "\x95\a\u8bea", // 诪
	0x8beb: "\x95\a\u8beb", // 诫
	0x8bec: "\x95\a\u8bec", // 诬
	0x8bed: "\x95\a\u8bed", // 语
	0x8bee: "\x95\a\u8bee", // 诮
	0x8bef: "\x95\a\u8bef", // 误
	0x8bf0: "\x95\a\u8bf0", // 诰
	0x8bf1: "\x95\a\u8bf1", // 诱
	0x8bf2: "\x95\a\u8bf2", // 诲
	0x8bf3: "\x95\a\u8bf3", // 诳
	0x8bf4: "\x95\a\u8bf4", // 说
	0x8bf5: "\x95\a\u8bf5", // 诵
	0x8bf6: "\x95\a\u8bf6", // 诶
	0x8bf7: "\x95\b\u8bf7", // 请
	0x8bf8: "\x95\b\u8bf8", // 诸
	0x8bf9: "\x95\b\u8bf9", // 诹
	0x8bfa: "\x95\b\u8bfa", // 诺
	0x8bfb: "\x95\b\u8bfb", // 读
	0x8bfc: "\x95\b\u8bfc", // 诼
	0x8bfd: "\x95\b\u8bfd", // 诽
	0x8bfe: "\x95\b\u8bfe", // 课
	0x8bff: "\x95\b\u8bff", // 诿
	0x8c00: "\x95\b\u8c00", // 谀
	0x8c01: "\x95\b\u8c01", // 谁
	0x8c02: "\x95\b\u8c02", // 谂
	0x8c03: "\x95\b\u8c03", // 调
	0x8c04: "\x95\b\u8c04", // 谄
	0x8c05: "\x95\b\u8c05", // 谅
	0x8c06: "\x95\b\u8c06", // 谆
	0x8c07: "\x95\b\u8c07", // 谇
	0x8c08: "\x95\b\u8c08", // 谈
	0x8c09: "\x95\b\u8c09", // 谉
	0x8c0a: "\x95\b\u8c0a", // 谊
	0x8c0b: "\x95\t\u8c0b", // 谋
	0x8c0c: "\x95\t\u8c0c", // 谌
	0x8c0d: "\x95\t\u8c0d", // 谍
	0x8c0e: "\x95\t\u8c0e", // 谎
	0x8c0f: "\x95\t\u8c0f", // 谏
	0x8c10: "\x95\t\u8c10", // 谐
	0x8c11: "\x95\t\u8c11", // 谑
	0x8c12: "\x95\t\u8c12", // 谒
	0x8c13: "\x95\t\u8c13", // 谓
	0x8c14: "\x95\t\u8c14", // 谔
	0x8c15: "\x95\t\u8c15", // 谕
	0x8c16: "\x95\t\u8c16", // 谖
	0x8c17: "\x95\t\u8c17", // 谗
	0x8c18: "\x95\t\u8c18", // 谘
	0x8c19: "\x95\t\u8c19", // 谙
	0x8c1a: "\x95\t\u8c1a", // 谚
	0x8c1b: "\x95\t\u8c1b", // 谛
	0x8c1c: "\x95\t\u8c1c", // 谜
	0x8c1d: "\x95\t\u8c1d", // 谝
	0x8c1e: "\x95\t\u8c1e", // 谞
	0x8c1f: "\x95\n\u8c1f", // 谟
	0x8c20: "\x95\n\u8c20", // 谠
	0x8c21: "\x95\n\u8c21", // 谡
	0x8c22: "\x95\n\u8c22", // 谢
	0x8c23: "\x95\n\u8c23", // 谣
	0x8c24: "\x95\n\u8c24", // 谤
	0x8c25: "\x95\n\u8c25", // 谥
	0x8c26: "\x95\n\u8c26", // 谦
	0x8c27: "\x95\n\u8c27", // 谧
	0x8c28: "\x95\v\u8c28", // 谨
	0x8c29: "\x95\v\u8c29", // 谩
	0x8c2a: "\x95\v\u8c2a", // 谪
	0x8c2b: "\x95\v\u8c2b", // 谫
	0x8c2c: "\x95\v\u8c2c", // 谬
	0x8c2d: "\x95\f\u8c2d", // 谭
	0x8c2e: "\x95\f\u8c2e", // 谮
	0x8c2f: "\x95\f\u8c2f", // 谯
	0x8c30: "\x95\f\u8c30", // 谰
	0x8c31: "\x95\f\u8c31", // 谱
	0x8c32: "\x95\f\u8c32", // 谲
	0x8c33: "\x95\r\u8c33", // 谳
	0x8c34: "\x95\r\u8c34", // 谴
	0x8c35: "\x95\r\u8c35", // 谵
	0x8c36: "\x95\x11\u8c36", // 谶
	0x8c37: "\x96\x00\u8c37", // 谷
	0x8c38: "\x96\x03\u8c38", // 谸
	0x8c39: "\x96\x04\u8c39", // 谹
	0x8c3a: "\x96\x04\u8c3a", // 谺
	0x8c3b: "\x96\x04\u8c3b", // 谻
	0x8c3c: "\x96\x06\u8c3c", // 谼
	0x8c3d: "\x96\a\u8c3d", // 谽
	0x8c3e: "\x96\b\u8c3e", // 谾
	0x8c3f: "\x96\n\u8c3f", // 谿
	0x8c40: "\x96\n\u8c40", // 豀
	0x8c41: "\x96\n\u8c41", // 豁
	0x8c42: "\x96\v\u8c42", // 豂
	0x8c43: "\x96\f\u8c43", // 豃
	0x8c44: "\x96\x0f\u8c44", // 豄
	0x8c45: "\x96\x10\u8c45", // 豅
	0x8c46: "\x97\x00\u8c46", // 豆
	0x8c47: "\x97\x03\u8c47", // 豇
	0x8c48: "\x97\x03\u8c48", // 豈
	0x8c49: "\x97\x04\u8c49", // 豉
	0x8c4a: "\x97\x06\u8c4a", // 豊
	0x8c4b: "\x97\x06\u8c4b", // 豋
	0x8c4c: "\x97\b\u8c4c", // 豌
	0x8c4d: "\x97\b\u8c4d", // 豍
	0x8c4e: "\x97\b\u8c4e", // 豎
	0x8c4f: "\x97\n\u8c4f", // 豏
	0x8c50: "\x97\v\u8c50", // 豐
	0x8c51: "\x97\r\u8c51", // 豑
	0x8c52: "\x97\x12\u8c52", // 豒
	0x8c53: "\x97\x14\u8c53", // 豓
	0x8c54: "\x97\x15\u8c54", // 豔
	0x8c55: "\x98\x00\u8c55", // 豕
	0x8c56: "\x98\x01\u8c56", // 豖
	0x8c57: "\x98\x03\u8c57", // 豗
	0x8c58: "\x98\x04\u8c58", // 豘
	0x8c59: "\x98\x04\u8c59", // 豙
	0x8c5a: "\x98\x04\u8c5a", // 豚
	0x8c5b: "\x98\x04\u8c5b", // 豛
	0x8c5c: "\x98\x04\u8c5c", // 豜
	0x8c5d: "\x98\x04\u8c5d", // 豝
	0x8c5e: "\x98\x05\u8c5e", // 豞
	0x8c5f: "\x98\x05\u8c5f", // 豟
	0x8c60: "\x98\x05\u8c60", // 豠
	0x8c61: "\x98\x05\u8c61", // 象
	0x8c62: "\x98\x06\u8c62", // 豢
	0x8c63: "\x98\x06\u8c63", // 豣
	0x8c64: "\x98\x06\u8c64", // 豤
	0x8c65: "\x98\x06\u8c65", // 豥
	0x8c66: "\x98\x06\u8c66", // 豦
	0x8c67: "\x98\a\u8c67", // 豧
	0x8c68: "\x98\a\u8c68", // 豨
	0x8c69: "\x98\a\u8c69", // 豩
	0x8c6a: "\x98\a\u8c6a", // 豪
	0x8c6b: "\x98\t\u8c6b", // 豫
	0x8c6c: "\x98\t\u8c6c", // 豬
	0x8c6d: "\x98\t\u8c6d", // 豭
	0x8c6e: "\x98\t\u8c6e", // 豮
	0x8c6f: "\x98\n\u8c6f", // 豯
	0x8c70: "\x98\n\u8c70", // 豰
	0x8c71: "\x98\n\u8c71", // 豱
	0x8c72: "\x98\n\u8c72", // 豲
	0x8c73: "\x98\n\u8c73", // 豳
	0x8c74: "\x98\v\u8c74", // 豴
	0x8c75: "\x98\v\u8c75", // 豵
	0x8c76: "\x98\r\u8c76", // 豶
	0x8c77: "\x98\f\u8c77", // 豷
	0x8c78: "\x99\x00\u8c78", // 豸
	0x8c79: "\x99\x03\u8c79", // 豹
	0x8c7a: "\x99\x03\u8c7a", // 豺
	0x8c7b: "\x99\x03\u8c7b", // 豻
	0x8c7c: "\x99\x04\u8c7c", // 豼
	0x8c7d: "\x99\x04\u8c7d", // 豽
	0x8c7e: "\x99\x05\u8c7e", // 豾
	0x8c7f: "\x99\x05\u8c7f", // 豿
	0x8c80: "\x99\x05\u8c80", // 貀
	0x8c81: "\x99\x05\u8c81", // 貁
	0x8c82: "\x99\x05\u8c82", // 貂
	0x8c83: "\x99\x05\u8c83", // 貃
	0x8c84: "\x99\x06\u8c84", // 貄
	0x8c85: "\x99\x06\u8c85", // 貅
	0x8c86: "\x99\x06\u8c86", // 貆
	0x8c87: "\x99\x06\u8c87", // 貇
	0x8c88: "\x99\x06\u8c88", // 貈
	0x8c89: "\x99\x06\u8c89", // 貉
	0x8c8a: "\x99\x06\u8c8a", // 貊
	0x8c8b: "\x99\a\u8c8b", // 貋
	0x8c8c: "\x99\a\u8c8c", // 貌
	0x8c8d: "\x99\a\u8c8d", // 貍
	0x8c8e: "\x99\b\u8c8e", // 貎
	0x8c8f: "\x99\b\u8c8f", // 貏
	0x8c90: "\x99\t\u8c90", // 貐
	0x8c91: "\x99\t\u8c91", // 貑
	0x8c92: "\x99\t\u8c92", // 貒
	0x8c93: "\x99\t\u8c93", // 貓
	0x8c94: "\x99\n\u8c94", // 貔
	0x8c95: "\x99\n\u8c95", // 貕
	0x8c96: "\x99\n\u8c96", // 貖
	0x8c97: "\x99\v\u8c97", // 貗
	0x8c98: "\x99\v\u8c98", // 貘
	0x8c99: "\x99\v\u8c99", // 貙
	0x8c9a: "\x99\f\u8c9a", // 貚
	0x8c9b: "\x99\x12\u8c9b", // 貛
	0x8c9c: "\x99\x14\u8c9c", // 貜
	0x8c9d: "\x9a\x00\u8c9d", // 貝
	0x8c9e: "\x9a\x02\u8c9e", // 貞
	0x8c9f: "\x9a\x02\u8c9f", // 貟
	0x8ca0: "\x9a\x02\u8ca0", // 負
	0x8ca1: "\x9a\x03\u8ca1", // 財
	0x8ca2: "\x9a\x03\u8ca2", // 貢
	0x8ca3: "\x9a\x03\u8ca3", // 貣
	0x8ca4: "\x9a\x03\u8ca4", // 貤
	0x8ca5: "\x9a\x04\u8ca5", // 貥
	0x8ca6: "\x9a\x04\u8ca6", // 貦
	0x8ca7: "\x9a\x04\u8ca7", // 貧
	0x8ca8: "\x9a\x04\u8ca8", // 貨
	0x8ca9: "\x9a\x04\u8ca9", // 販
	0x8caa: "\x9a\x04\u8caa", // 貪
	0x8cab: "\x9a\x04\u8cab", // 貫
	0x8cac: "\x9a\x04\u8cac", // 責
	0x8cad: "\x9a\x04\u8cad", // 貭
	0x8cae: "\x9a\x04\u8cae", // 貮
	0x8caf: "\x9a\x05\u8caf", // 貯
	0x8cb0: "\x9a\x05\u8cb0", // 貰
	0x8cb1: "\x9a\x05\u8cb1", // 貱
	0x8cb2: "\x9a\x05\u8cb2", // 貲
	0x8cb3: "\x9a\x05\u8cb3", // 貳
	0x8cb4: "\x9a\x05\u8cb4", // 貴
	0x8cb5: "\x9a\x05\u8cb5", // 貵
	0x8cb6: "\x9a\x05\u8cb6", // 貶
	0x8cb7: "\x9a\x05\u8cb7", // 買
	0x8cb8: "\x9a\x05\u8cb8", // 貸
	0x8cb9: "\x9a\x05\u8cb9", // 貹
	0x8cba: "\x9a\x05\u8cba", // 貺
	0x8cbb: "\x9a\x05\u8cbb", // 費
	0x8cbc: "\x9a\x05\u8cbc", // 貼
	0x8cbd: "\x9a\x05\u8cbd", // 貽
	0x8cbe: "\x9a\x05\u8cbe", // 貾
	0x8cbf: "\x9a\x05\u8cbf", // 貿
	0x8cc0: "\x9a\x05\u8cc0", // 賀
	0x8cc1: "\x9a\x05\u8cc1", // 賁
	0x8cc2: "\x9a\x06\u8cc2", // 賂
	0x8cc3: "\x9a\x06\u8cc3", // 賃
	0x8cc4: "\x9a\x06\u8cc4", // 賄
	0x8cc5: "\x9a\x06\u8cc5", // 賅
	0x8cc6: "\x9a\x06\u8cc6", // 賆
	0x8cc7: "\x9a\x06\u8cc7", // 資
	0x8cc8: "\x9a\x06\u8cc8", // 賈
	0x8cc9: "\x9a\x06\u8cc9", // 賉
	0x8cca: "\x9a\x06\u8cca", // 賊
	0x8ccb: "\x9a\x06\u8ccb", // 賋
	0x8ccc: "\x9a\x06\u8ccc", // 賌
	0x8ccd: "\x9a\x06\u8ccd", // 賍
	0x8cce: "\x9a\x06\u8cce", // 賎
	0x8ccf: "\x9a\a\u8ccf", // 賏
	0x8cd0: "\x9a\a\u8cd0", // 賐
	0x8cd1: "\x9a\a\u8cd1", // 賑
	0x8cd2: "\x9a\a\u8cd2", // 賒
	0x8cd3: "\x9a\a\u8cd3", // 賓
	0x8cd4: "\x9a\a\u8cd4", // 賔
	0x8cd5: "\x9a\a\u8cd5", // 賕
	0x8cd6: "\x9a\a\u8cd6", // 賖
	0x8cd7: "\x9a\a\u8cd7", // 賗
	0x8cd8: "\x9a\a\u8cd8", // 賘
	0x8cd9: "\x9a\b\u8cd9", // 賙
	0x8cda: "\x9a\b\u8cda", // 賚
	0x8cdb: "\x9a\b\u8cdb", // 賛
	0x8cdc: "\x9a\b\u8cdc", // 賜
	0x8cdd: "\x9a\b\u8cdd", // 賝
	0x8cde: "\x9a\b\u8cde", // 賞
	0x8cdf: "\x9a\b\u8cdf", // 賟
	0x8ce0: "\x9a\b\u8ce0", // 賠
	0x8ce1: "\x9a\b\u8ce1", // 賡
	0x8ce2: "\x9a\b\u8ce2", // 賢
	0x8ce3: "\x9a\b\u8ce3", // 賣
	0x8ce4: "\x9a\b\u8ce4", // 賤
	0x8ce5: "\x9a\b\u8ce5", // 賥
	0x8ce6: "\x9a\b\u8ce6", // 賦
	0x8ce7: "\x9a\b\u8ce7", // 賧
	0x8ce8: "\x9a\b\u8ce8", // 賨
	0x8ce9: "\x9a\b\u8ce9", // 賩
	0x8cea: "\x9a\b\u8cea", // 質
	0x8ceb: "\x9a\b\u8ceb", // 賫
	0x8cec: "\x9a\b\u8cec", // 賬
	0x8ced: "\x9a\t\u8ced", // 賭
	0x8cee: "\x9a\t\u8cee", // 賮
	0x8cef: "\x9a\t\u8cef", // 賯
	0x8cf0: "\x9a\t\u8cf0", // 賰
	0x8cf1: "\x9a\t\u8cf1", // 賱
	0x8cf2: "\x9a\t\u8cf2", // 賲
	0x8cf3: "\x9a\t\u8cf3", // 賳
	0x8cf4: "\x9a\t\u8cf4", // 賴
	0x8cf5: "\x9a\t\u8cf5", // 賵
	0x8cf6: "\x9a\n\u8cf6", // 賶
	0x8cf7: "\x9a\n\u8cf7", // 賷
	0x8cf8: "\x9a\n\u8cf8", // 賸
	0x8cf9: "\x9a\n\u8cf9", // 賹
	0x8cfa: "\x9a\n\u8cfa", // 賺
	0x8cfb: "\x9a\n\u8cfb", // 賻
	0x8cfc: "\x9a\n\u8cfc", // 購
	0x8cfd: "\x9a\n\u8cfd", // 賽
	0x8cfe: "\x9a\v\u8cfe", // 賾
	0x8cff: "\x9a\v\u8cff", // 賿
	0x8d00: "\x9a\v\u8d00", // 贀
	0x8d01: "B\x0e\u8d01", // 贁
	0x8d02: "\x9a\v\u8d02", // 贂
	0x8d03: "\x9a\v\u8d03", // 贃
	0x8d04: "\x9a\v\u8d04", // 贄
	0x8d05: "\x9a\v\u8d05", // 贅
	0x8d06: "\x9a\f\u8d06", // 贆
	0x8d07: "\x9a\f\u8d07", // 贇
	0x8d08: "\x9a\f\u8d08", // 贈
	0x8d09: "\x9a\f\u8d09", // 贉
	0x8d0a: "\x9a\f\u8d0a", // 贊
	0x8d0b: "\x9a\f\u8d0b", // 贋
	0x8d0c: "\x9a\f\u8d0c", // 贌
	0x8d0d: "\x9a\r\u8d0d", // 贍
	0x8d0e: "\x9a\r\u8d0e", // 贎
	0x8d0f: "\x9a\r\u8d0f", // 贏
	0x8d10: "\x9a\x0e\u8d10", // 贐
	0x8d11: "\x9a\x0e\u8d11", // 贑
	0x8d12: "\x9a\x0e\u8d12", // 贒
	0x8d13: "\x9a\x0e\u8d13", // 贓
	0x8d14: "\x9a\x0e\u8d14", // 贔
	0x8d15: "\x9a\x0f\u8d15", // 贕
	0x8d16: "\x9a\x0f\u8d16", // 贖
	0x8d17: "\x9a\x0f\u8d17", // 贗
	0x8d18: "\x9a\x0f\u8d18", // 贘
	0x8d19: "\x9a\x10\u8d19", // 贙
	0x8d1a: "\x9a\x10\u8d1a", // 贚
	0x8d1b: "\x9a\x11\u8d1b", // 贛
	0x8d1c: "\x9a\x12\u8d1c", // 贜
	0x8d1d: "\x9a\x00\u8d1d", // 贝
	0x8d1e: "\x9a\x02\u8d1e", // 贞
	0x8d1f: "\x9a\x02\u8d1f", // 负
	0x8d20: "\x9a\x02\u8d20", // 贠
	0x8d21: "\x9a\x03\u8d21", // 贡
	0x8d22: "\x9a\x03\u8d22", // 财
	0x8d23: "\x9a\x04\u8d23", // 责
	0x8d24: "\x9a\x04\u8d24", // 贤
	0x8d25: "\x9a\x04\u8d25", // 败
	0x8d26: "\x9a\x04\u8d26", // 账
	0x8d27: "\x9a\x04\u8d27", // 货
	0x8d28: "\x9a\x04\u8d28", // 质
	0x8d29: "\x9a\x04\u8d29", // 贩
	0x8d2a: "\x9a\x04\u8d2a", // 贪
	0x8d2b: "\x9a\x04\u8d2b", // 贫
	0x8d2c: "\x9a\x04\u8d2c", // 贬
	0x8d2d: "\x9a\x04\u8d2d", // 购
	0x8d2e: "\x9a\x04\u8d2e", // 贮
	0x8d2f: "\x9a\x04\u8d2f", // 贯
	0x8d30: "\x9a\x05\u8d30", // 贰
	0x8d31: "\x9a\x05\u8d31", // 贱
	0x8d32: "\x9a\x05\u8d32", // 贲
	0x8d33: "\x9a\x05\u8d33", // 贳
	0x8d34: "\x9a\x05\u8d34", // 贴
	0x8d35: "\x9a\x05\u8d35", // 贵
	0x8d36: "\x9a\x05\u8d36", // 贶
	0x8d37: "\x9a\x05\u8d37", // 贷
	0x8d38: "\x9a\x05\u8d38", // 贸
	0x8d39: "\x9a\x05\u8d39", // 费
	0x8d3a: "\x9a\x05\u8d3a", // 贺
	0x8d3b: "\x9a\x05\u8d3b", // 贻
	0x8d3c: "\x9a\x06\u8d3c", // 贼
	0x8d3d: "\x9a\x06\u8d3d", // 贽
	0x8d3e: "\x9a\x06\u8d3e", // 贾
	0x8d3f: "\x9a\x06\u8d3f", // 贿
	0x8d40: "\x9a\x06\u8d40", // 赀
	0x8d41: "\x9a\x06\u8d41", // 赁
	0x8d42: "\x9a\x06\u8d42", // 赂
	0x8d43: "\x9a\x06\u8d43", // 赃
	0x8d44: "\x9a\x06\u8d44", // 资
	0x8d45: "\x9a\x06\u8d45", // 赅
	0x8d46: "\x9a\x06\u8d46", // 赆
	0x8d47: "\x9a\a\u8d47", // 赇
	0x8d48: "\x9a\a\u8d48", // 赈
	0x8d49: "\x9a\a\u8d49", // 赉
	0x8d4a: "\x9a\a\u8d4a", // 赊
	0x8d4b: "\x9a\b\u8d4b", // 赋
	0x8d4c: "\x9a\b\u8d4c", // 赌
	0x8d4d: "\x9a\b\u8d4d", // 赍
	0x8d4e: "\x9a\b\u8d4e", // 赎
	0x8d4f: "\x9a\b\u8d4f", // 赏
	0x8d50: "\x9a\b\u8d50", // 赐
	0x8d51: "\x9a\b\u8d51", // 赑
	0x8d52: "\x9a\b\u8d52", // 赒
	0x8d53: "\x9a\b\u8d53", // 赓
	0x8d54: "\x9a\b\u8d54", // 赔
	0x8d55: "\x9a\b\u8d55", // 赕
	0x8d56: "\x9a\t\u8d56", // 赖
	0x8d57: "\x9a\t\u8d57", // 赗
	0x8d58: "\x9a\n\u8d58", // 赘
	0x8d59: "\x9a\n\u8d59", // 赙
	0x8d5a: "\x9a\n\u8d5a", // 赚
	0x8d5b: "\x9a\n\u8d5b", // 赛
	0x8d5c: "\x9a\v\u8d5c", // 赜
	0x8d5d: "\x9a\f\u8d5d", // 赝
	0x8d5e: "\x9a\f\u8d5e", // 赞
	0x8d5f: "\x9a\f\u8d5f", // 赟
	0x8d60: "\x9a\f\u8d60", // 赠
	0x8d61: "\x9a\r\u8d61", // 赡
	0x8d62: "\x9a\r\u8d62", // 赢
	0x8d63: "\x9a\x11\u8d63", // 赣
	0x8d64: "\x9b\x00\u8d64", // 赤
	0x8d65: "\x9b\x04\u8d65", // 赥
	0x8d66: "\x9b\x04\u8d66", // 赦
	0x8d67: "\x9b\x04\u8d67", // 赧
	0x8d68: "\x9b\x06\u8d68", // 赨
	0x8d69: "\x9b\x06\u8d69", // 赩
	0x8d6a: "\x9b\x06\u8d6a", // 赪
	0x8d6b: "\x9b\a\u8d6b", // 赫
	0x8d6c: "\x9b\t\u8d6c", // 赬
	0x8d6d: "\x9b\t\u8d6d", // 赭
	0x8d6e: "\x9b\t\u8d6e", // 赮
	0x8d6f: "\x9b\n\u8d6f", // 赯
	0x8d70: "\x9c\x00\u8d70", // 走
	0x8d71: "\x9c\x00\u8d71", // 赱
	0x8d72: "\x9c\x02\u8d72", // 赲
	0x8d73: "\x9c\x02\u8d73", // 赳
	0x8d74: "\x9c\x02\u8d74", // 赴
	0x8d75: "\x9c\x02\u8d75", // 赵
	0x8d76: "\x9c\x03\u8d76", // 赶
	0x8d77: "\x9c\x03\u8d77", // 起
	0x8d78: "\x9c\x03\u8d78", // 赸
	0x8d79: "\x9c\x04\u8d79", // 赹
	0x8d7a: "\x9c\x04\u8d7a", // 赺
	0x8d7b: "\x9c\x04\u8d7b", // 赻
	0x8d7c: "\x9c\x04\u8d7c", // 赼
	0x8d7d: "\x9c\x04\u8d7d", // 赽
	0x8d7e: "\x9c\x04\u8d7e", // 赾
	0x8d7f: "\x9c\x04\u8d7f", // 赿
	0x8d80: "\x9c\x05\u8d80", // 趀
	0x8d81: "\x9c\x05\u8d81", // 趁
	0x8d82: "\x9c\x05\u8d82", // 趂
	0x8d83: "\x9c\x05\u8d83", // 趃
	0x8d84: "\x9c\x05\u8d84", // 趄
	0x8d85: "\x9c\x05\u8d85", // 超
	0x8d86: "\x9c\x05\u8d86", // 趆
	0x8d87: "\x9c\x05\u8d87", // 趇
	0x8d88: "\x9c\x05\u8d88", // 趈
	0x8d89: "\x9c\x05\u8d89", // 趉
	0x8d8a: "\x9c\x05\u8d8a", // 越
	0x8d8b: "\x9c\x05\u8d8b", // 趋
	0x8d8c: "\x9c\x06\u8d8c", // 趌
	0x8d8d: "\x9c\x06\u8d8d", // 趍
	0x8d8e: "\x9c\x06\u8d8e", // 趎
	0x8d8f: "\x9c\x06\u8d8f", // 趏
	0x8d90: "\x9c\x06\u8d90", // 趐
	0x8d91: "\x9c\x06\u8d91", // 趑
	0x8d92: "\x9c\x06\u8d92", // 趒
	0x8d93: "\x9c\x06\u8d93", // 趓
	0x8d94: "\x9c\x06\u8d94", // 趔
	0x8d95: "\x9c\a\u8d95", // 趕
	0x8d96: "\x9c\a\u8d96", // 趖
	0x8d97: "\x9c\a\u8d97", // 趗
	0x8d98: "\x9c\a\u8d98", // 趘
	0x8d99: "\x9c\a\u8d99", // 趙
	0x8d9a: "\x9c\a\u8d9a", // 趚
	0x8d9b: "\x9c\b\u8d9b", // 趛
	0x8d9c: "\x9c\b\u8d9c", // 趜
	0x8d9d: "\x9c\b\u8d9d", // 趝
	0x8d9e: "\x9c\b\u8d9e", // 趞
	0x8d9f: "\x9c\b\u8d9f", // 趟
	0x8da0: "\x9c\b\u8da0", // 趠
	0x8da1: "\x9c\b\u8da1", // 趡
	0x8da2: "\x9c\b\u8da2", // 趢
	0x8da3: "\x9c\b\u8da3", // 趣
	0x8da4: "\x9c\b\u8da4", // 趤
	0x8da5: "\x9c\t\u8da5", // 趥
	0x8da6: "\x9c\t\u8da6", // 趦
	0x8da7: "\x9c\t\u8da7", // 趧
	0x8da8: "\x9c\n\u8da8", // 趨
	0x8da9: "\x9c\f\u8da9", // 趩
	0x8daa: "\x9c\f\u8daa", // 趪
	0x8dab: "\x9c\f\u8dab", // 趫
	0x8dac: "\x9c\f\u8dac", // 趬
	0x8dad: "\x9c\f\u8dad", // 趭
	0x8dae: "\x9c\r\u8dae", // 趮
	0x8daf: "\x9c\x0e\u8daf", // 趯
	0x8db0: "\x9c\x0e\u8db0", // 趰
	0x8db1: "\x9c\x10\u8db1", // 趱
	0x8db2: "\x9c\x13\u8db2", // 趲
	0x8db3: "\x9d\x00\u8db3", // 足
	0x8db4: "\x9d\x02\u8db4", // 趴
	0x8db5: "\x9d\x03\u8db5", // 趵
	0x8db6: "\x9d\x03\u8db6", // 趶
	0x8db7: "\x9d\x03\u8db7", // 趷
	0x8db8: "\x9d\x03\u8db8", // 趸
	0x8db9: "\x9d\x04\u8db9", // 趹
	0x8dba: "\x9d\x04\u8dba", // 趺
	0x8dbb: "\x9d\x04\u8dbb", // 趻
	0x8dbc: "\x9d\x06\u8dbc", // 趼
	0x8dbd: "\x9d\x04\u8dbd", // 趽
	0x8dbe: "\x9d\x04\u8dbe", // 趾
	0x8dbf: "\x9d\x04\u8dbf", // 趿
	0x8dc0: "\x9d\x04\u8dc0", // 跀
	0x8dc1: "\x9d\x04\u8dc1", // 跁
	0x8dc2: "\x9d\x04\u8dc2", // 跂
	0x8dc3: "\x9d\x04\u8dc3", // 跃
	0x8dc4: "\x9d\x04\u8dc4", // 跄
	0x8dc5: "\x9d\x05\u8dc5", // 跅
	0x8dc6: "\x9d\x05\u8dc6", // 跆
	0x8dc7: "\x9d\x05\u8dc7", // 跇
	0x8dc8: "\x9d\x05\u8dc8", // 跈
	0x8dc9: "\x9d\x05\u8dc9", // 跉
	0x8dca: "\x9d\x05\u8dca", // 跊
	0x8dcb: "\x9d\x05\u8dcb", // 跋
	0x8dcc: "\x9d\x05\u8dcc", // 跌
	0x8dcd: "\x9d\x05\u8dcd", // 跍
	0x8dce: "\x9d\x05\u8dce", // 跎
	0x8dcf: "\x9d\x05\u8dcf", // 跏
	0x8dd0: "\x9d\x05\u8dd0", // 跐
	0x8dd1: "\x9d\x05\u8dd1", // 跑
	0x8dd2: "\x9d\x05\u8dd2", // 跒
	0x8dd3: "\x9d\x05\u8dd3", // 跓
	0x8dd4: "\x9d\x05\u8dd4", // 跔
	0x8dd5: "\x9d\x05\u8dd5", // 跕
	0x8dd6: "\x9d\x05\u8dd6", // 跖
	0x8dd7: "\x9d\x05\u8dd7", // 跗
	0x8dd8: "\x9d\x05\u8dd8", // 跘
	0x8dd9: "\x9d\x05\u8dd9", // 跙
	0x8dda: "\x9d\x05\u8dda", // 跚
	0x8ddb: "\x9d\x05\u8ddb", // 跛
	0x8ddc: "\x9d\x05\u8ddc", // 跜
	0x8ddd: "\x9d\x05\u8ddd", // 距
	0x8dde: "\x9d\x05\u8dde", // 跞
	0x8ddf: "\x9d\x06\u8ddf", // 跟
	0x8de0: "\x9d\x06\u8de0", // 跠
	0x8de1: "\x9d\x06\u8de1", // 跡
	0x8de2: "\x9d\x06\u8de2", // 跢
	0x8de3: "\x9d\x06\u8de3", // 跣
	0x8de4: "\x9d\x06\u8de4", // 跤
	0x8de5: "\x9d\x06\u8de5", // 跥
	0x8de6: "\x9d\x06\u8de6", // 跦
	0x8de7: "\x9d\x06\u8de7", // 跧
	0x8de8: "\x9d\x06\u8de8", // 跨
	0x8de9: "\x9d\x06\u8de9", // 跩
	0x8dea: "\x9d\x06\u8dea", // 跪
	0x8deb: "\x9d\x06\u8deb", // 跫
	0x8dec: "\x9d\x06\u8dec", // 跬
	0x8ded: "\x9d\x06\u8ded", // 跭
	0x8dee: "\x9d\x06\u8dee", // 跮
	0x8def: "\x9d\x06\u8def", // 路
	0x8df0: "\x9d\x06\u8df0", // 跰
	0x8df1: "\x9d\x06\u8df1", // 跱
	0x8df2: "\x9d\x06\u8df2", // 跲
	0x8df3: "\x9d\x06\u8df3", // 跳
	0x8df4: "\x9d\x06\u8df4", // 跴
	0x8df5: "\x9d\x05\u8df5", // 践
	0x8df6: "\x9d\x06\u8df6", // 跶
	0x8df7: "\x9d\x06\u8df7", // 跷
	0x8df8: "\x9d\x06\u8df8", // 跸
	0x8df9: "\x9d\x06\u8df9", // 跹
	0x8dfa: "\x9d\x06\u8dfa", // 跺
	0x8dfb: "\x9d\x06\u8dfb", // 跻
	0x8dfc: "\x9d\a\u8dfc", // 跼
	0x8dfd: "\x9d\a\u8dfd", // 跽
	0x8dfe: "\x9d\a\u8dfe", // 跾
	0x8dff: "\x9d\a\u8dff", // 跿
	0x8e00: "\x9d\a\u8e00", // 踀
	0x8e01: "\x9d\a\u8e01", // 踁
	0x8e02: "\x9d\a\u8e02", // 踂
	0x8e03: "\x9d\a\u8e03", // 踃
	0x8e04: "\x9d\a\u8e04", // 踄
	0x8e05: "\x9d\a\u8e05", // 踅
	0x8e06: "\x9d\a\u8e06", // 踆
	0x8e07: "\x9d\a\u8e07", // 踇
	0x8e08: "\x9d\a\u8e08", // 踈
	0x8e09: "\x9d\a\u8e09", // 踉
	0x8e0a: "\x9d\a\u8e0a", // 踊
	0x8e0b: "\x9d\a\u8e0b", // 踋
	0x8e0c: "\x9d\a\u8e0c", // 踌
	0x8e0d: "\x9d\a\u8e0d", // 踍
	0x8e0e: "\x9d\a\u8e0e", // 踎
	0x8e0f: "\x9d\b\u8e0f", // 踏
	0x8e10: "\x9d\b\u8e10", // 踐
	0x8e11: "\x9d\b\u8e11", // 踑
	0x8e12: "\x9d\b\u8e12", // 踒
	0x8e13: "\x9d\b\u8e13", // 踓
	0x8e14: "\x9d\b\u8e14", // 踔
	0x8e15: "\x9d\b\u8e15", // 踕
	0x8e16: "\x9d\b\u8e16", // 踖
	0x8e17: "\x9d\b\u8e17", // 踗
	0x8e18: "\x9d\b\u8e18", // 踘
	0x8e19: "\x9d\b\u8e19", // 踙
	0x8e1a: "\x9d\b\u8e1a", // 踚
	0x8e1b: "\x9d\b\u8e1b", // 踛
	0x8e1c: "\x9d\b\u8e1c", // 踜
	0x8e1d: "\x9d\b\u8e1d", // 踝
	0x8e1e: "\x9d\b\u8e1e", // 踞
	0x8e1f: "\x9d\b\u8e1f", // 踟
	0x8e20: "\x9d\b\u8e20", // 踠
	0x8e21: "\x9d\b\u8e21", // 踡
	0x8e22: "\x9d\b\u8e22", // 踢
	0x8e23: "\x9d\b\u8e23", // 踣
	0x8e24: "\x9d\b\u8e24", // 踤
	0x8e25: "\x9d\b\u8e25", // 踥
	0x8e26: "\x9d\b\u8e26", // 踦
	0x8e27: "\x9d\b\u8e27", // 踧
	0x8e28: "\x9d\b\u8e28", // 踨
	0x8e29: "\x9d\b\u8e29", // 踩
	0x8e2a: "\x9d\b\u8e2a", // 踪
	0x8e2b: "\x9d\t\u8e2b", // 踫
	0x8e2c: "\x9d\b\u8e2c", // 踬
	0x8e2d: "\x9d\b\u8e2d", // 踭
	0x8e2e: "\x9d\b\u8e2e", // 踮
	0x8e2f: "\x9d\b\u8e2f", // 踯
	0x8e30: "\x9d\t\u8e30", // 踰
	0x8e31: "\x9d\t\u8e31", // 踱
	0x8e32: "\x9d\t\u8e32", // 踲
	0x8e33: "\x9d\t\u8e33", // 踳
	0x8e34: "\x9d\t\u8e34", // 踴
	0x8e35: "\x9d\t\u8e35", // 踵
	0x8e36: "\x9d\t\u8e36", // 踶
	0x8e37: "\x9d\t\u8e37", // 踷
	0x8e38: "\x9d\t\u8e38", // 踸
	0x8e39: "\x9d\t\u8e39", // 踹
	0x8e3a: "\x9d\b\u8e3a", // 踺
	0x8e3b: "\x9d\t\u8e3b", // 踻
	0x8e3c: "\x9d\t\u8e3c", // 踼
	0x8e3d: "\x9d\t\u8e3d", // 踽
	0x8e3e: "\x9d\t\u8e3e", // 踾
	0x8e3f: "\x9d\t\u8e3f", // 踿
	0x8e40: "\x9d\t\u8e40", // 蹀
	0x8e41: "\x9d\t\u8e41", // 蹁
	0x8e42: "\x9d\t\u8e42", // 蹂
	0x8e43: "\x9d\t\u8e43", // 蹃
	0x8e44: "\x9d\t\u8e44", // 蹄
	0x8e45: "\x9d\t\u8e45", // 蹅
	0x8e46: "\x9d\n\u8e46", // 蹆
	0x8e47: "\x9d\n\u8e47", // 蹇
	0x8e48: "\x9d\n\u8e48", // 蹈
	0x8e49: "\x9d\n\u8e49", // 蹉
	0x8e4a: "\x9d\n\u8e4a", // 蹊
	0x8e4b: "\x9d\n\u8e4b", // 蹋
	0x8e4c: "\x9d\n\u8e4c", // 蹌
	0x8e4d: "\x9d\n\u8e4d", // 蹍
	0x8e4e: "\x9d\n\u8e4e", // 蹎
	0x8e4f: "\x9d\n\u8e4f", // 蹏
	0x8e50: "\x9d\n\u8e50", // 蹐
	0x8e51: "\x9d\n\u8e51", // 蹑
	0x8e52: "\x9d\n\u8e52", // 蹒
	0x8e53: "\x9d\n\u8e53", // 蹓
	0x8e54: "\x9d\v\u8e54", // 蹔
	0x8e55: "\x9d\v\u8e55", // 蹕
	0x8e56: "\x9d\v\u8e56", // 蹖
	0x8e57: "\x9d\v\u8e57", // 蹗
	0x8e58: "\x9d\v\u8e58", // 蹘
	0x8e59: "\x9d\v\u8e59", // 蹙
	0x8e5a: "\x9d\v\u8e5a", // 蹚
	0x8e5b: "\x9d\v\u8e5b", // 蹛
	0x8e5c: "\x9d\v\u8e5c", // 蹜
	0x8e5d: "\x9d\v\u8e5d", // 蹝
	0x8e5e: "\x9d\v\u8e5e", // 蹞
	0x8e5f: "\x9d\v\u8e5f", // 蹟
	0x8e60: "\x9d\v\u8e60", // 蹠
	0x8e61: "\x9d\v\u8e61", // 蹡
	0x8e62: "\x9d\v\u8e62", // 蹢
	0x8e63: "\x9d\v\u8e63", // 蹣
	0x8e64: "\x9d\v\u8e64", // 蹤
	0x8e65: "\x9d\v\u8e65", // 蹥
	0x8e66: "\x9d\v\u8e66", // 蹦
	0x8e67: "\x9d\v\u8e67", // 蹧
	0x8e68: "\x9d\f\u8e68", // 蹨
	0x8e69: "\x9d\f\u8e69", // 蹩
	0x8e6a: "\x9d\f\u8e6a", // 蹪
	0x8e6b: "\x9d\f\u8e6b", // 蹫
	0x8e6c: "\x9d\f\u8e6c", // 蹬
	0x8e6d: "\x9d\f\u8e6d", // 蹭
	0x8e6e: "\x9d\v\u8e6e", // 蹮
	0x8e6f: "\x9d\f\u8e6f", // 蹯
	0x8e70: "\x9d\f\u8e70", // 蹰
	0x8e71: "\x9d\f\u8e71", // 蹱
	0x8e72: "\x9d\f\u8e72", // 蹲
	0x8e73: "\x9d\f\u8e73", // 蹳
	0x8e74: "\x9d\f\u8e74", // 蹴
	0x8e75: "\x9d\f\u8e75", // 蹵
	0x8e76: "\x9d\f\u8e76", // 蹶
	0x8e77: "\x9d\f\u8e77", // 蹷
	0x8e78: "\x9d\f\u8e78", // 蹸
	0x8e79: "\x9d\f\u8e79", // 蹹
	0x8e7a: "\x9d\f\u8e7a", // 蹺
	0x8e7b: "\x9d\f\u8e7b", // 蹻
	0x8e7c: "\x9d\f\u8e7c", // 蹼
	0x8e7d: "\x9d\f\u8e7d", // 蹽
	0x8e7e: "\x9d\f\u8e7e", // 蹾
	0x8e7f: "\x9d\f\u8e7f", // 蹿
	0x8e80: "\x9d\v\u8e80", // 躀
	0x8e81: "\x9d\r\u8e81", // 躁
	0x8e82: "\x9d\r\u8e82", // 躂
	0x8e83: "\x9d\r\u8e83", // 躃
	0x8e84: "\x9d\r\u8e84", // 躄
	0x8e85: "\x9d\r\u8e85", // 躅
	0x8e86: "\x9d\r\u8e86", // 躆
	0x8e87: "\x9d\r\u8e87", // 躇
	0x8e88: "\x9d\r\u8e88", // 躈
	0x8e89: "\x9d\r\u8e89", // 躉
	0x8e8a: "\x9d\x0e\u8e8a", // 躊
	0x8e8b: "\x9d\x0e\u8e8b", // 躋
	0x8e8c: "\x9d\x0e\u8e8c", // 躌
	0x8e8d: "\x9d\x0e\u8e8d", // 躍
	0x8e8e: "\x9d\x0e\u8e8e", // 躎
	0x8e8f: "\x9d\x0e\u8e8f", // 躏
	0x8e90: "\x9d\x0f\u8e90", // 躐
	0x8e91: "\x9d\x0f\u8e91", // 躑
	0x8e92: "\x9d\x0f\u8e92", // 躒
	0x8e93: "\x9d\x0f\u8e93", // 躓
	0x8e94: "\x9d\x0f\u8e94", // 躔
	0x8e95: "\x9d\x0f\u8e95", // 躕
	0x8e96: "\x9d\x0f\u8e96", // 躖
	0x8e97: "\x9d\x10\u8e97", // 躗
	0x8e98: "\x9d\x10\u8e98", // 躘
	0x8e99: "\x9d\x10\u8e99", // 躙
	0x8e9a: "\x9d\x10\u8e9a", // 躚
	0x8e9b: "\x9d\x10\u8e9b", // 躛
	0x8e9c: "\x9d\x10\u8e9c", // 躜
	0x8e9d: "\x9d\x11\u8e9d", // 躝
	0x8e9e: "\x9d\x11\u8e9e", // 躞
	0x8e9f: "\x9d\x11\u8e9f", // 躟
	0x8ea0: "\x9d\x11\u8ea0", // 躠
	0x8ea1: "\x9d\x12\u8ea1", // 躡
	0x8ea2: "\x9d\x12\u8ea2", // 躢
	0x8ea3: "\x9d\x12\u8ea3", // 躣
	0x8ea4: "\x9d\x12\u8ea4", // 躤
	0x8ea5: "\x9d\x12\u8ea5", // 躥
	0x8ea6: "\x9d\x13\u8ea6", // 躦
	0x8ea7: "\x9d\x13\u8ea7", // 躧
	0x8ea8: "\x9d\x15\u8ea8", // 躨
	0x8ea9: "\x9d\x14\u8ea9", // 躩
	0x8eaa: "\x9d\x14\u8eaa", // 躪
	0x8eab: "\x9e\x00\u8eab", // 身
	0x8eac: "\x9e\x03\u8eac", // 躬
	0x8ead: "\x9e\x04\u8ead", // 躭
	0x8eae: "\x9e\x04\u8eae", // 躮
	0x8eaf: "\x9e\x04\u8eaf", // 躯
	0x8eb0: "\x9e\x05\u8eb0", // 躰
	0x8eb1: "\x9e\x06\u8eb1", // 躱
	0x8eb2: "\x9e\x06\u8eb2", // 躲
	0x8eb3: "\x9e\a\u8eb3", // 躳
	0x8eb4: "\x9e\a\u8eb4", // 躴
	0x8eb5: "\x9e\a\u8eb5", // 躵
	0x8eb6: "\x9e\b\u8eb6", // 躶
	0x8eb7: "\x9e\b\u8eb7", // 躷
	0x8eb8: "\x9e\b\u8eb8", // 躸
	0x8eb9: "\x9e\b\u8eb9", // 躹
	0x8eba: "\x9e\b\u8eba", // 躺
	0x8ebb: "\x9e\b\u8ebb", // 躻
	0x8ebc: "\x9e\b\u8ebc", // 躼
	0x8ebd: "\x9e\t\u8ebd", // 躽
	0x8ebe: "\x9e\t\u8ebe", // 躾
	0x8ebf: "\x9e\n\u8ebf", // 躿
	0x8ec0: "\x9e\v\u8ec0", // 軀
	0x8ec1: "\x9e\v\u8ec1", // 軁
	0x8ec2: "\x9e\f\u8ec2", // 軂
	0x8ec3: "\x9e\f\u8ec3", // 軃
	0x8ec4: "\x9e\f\u8ec4", // 軄
	0x8ec5: "\x9e\f\u8ec5", // 軅
	0x8ec6: "\x9e\r\u8ec6", // 軆
	0x8ec7: "\x9e\x0e\u8ec7", // 軇
	0x8ec8: "\x9e\x11\u8ec8", // 軈
	0x8ec9: "\x9e\x14\u8ec9", // 軉
	0x8eca: "\x9f\x00\u8eca", // 車
	0x8ecb: "\x9f\x01\u8ecb", // 軋
	0x8ecc: "\x9f\x02\u8ecc", // 軌
	0x8ecd: "\x9f\x02\u8ecd", // 軍
	0x8ece: "\x9f\x03\u8ece", // 軎
	0x8ecf: "\x9f\x03\u8ecf", // 軏
	0x8ed0: "\x9f\x03\u8ed0", // 軐
	0x8ed1: "\x9f\x03\u8ed1", // 軑
	0x8ed2: "\x9f\x03\u8ed2", // 軒
	0x8ed3: "\x9f\x03\u8ed3", // 軓
	0x8ed4: "\x9f\x03\u8ed4", // 軔
	0x8ed5: "\x9f\x03\u8ed5", // 軕
	0x8ed6: "\x9f\x04\u8ed6", // 軖
	0x8ed7: "\x9f\x04\u8ed7", // 軗
	0x8ed8: "\x9f\x04\u8ed8", // 軘
	0x8ed9: "\x9f\x04\u8ed9", // 軙
	0x8eda: "\x9f\x04\u8eda", // 軚
	0x8edb: "\x9f\x04\u8edb", // 軛
	0x8edc: "\x9f\x04\u8edc", // 軜
	0x8edd: "\x9f\x04\u8edd", // 軝
	0x8ede: "\x9f\x04\u8ede", // 軞
	0x8edf: "\x9f\x04\u8edf", // 軟
	0x8ee0: "\x9f\x04\u8ee0", // 軠
	0x8ee1: "\x9f\x04\u8ee1", // 軡
	0x8ee2: "\x9f\x04\u8ee2", // 転
	0x8ee3: "\x9f\x04\u8ee3", // 軣
	0x8ee4: "\x9f\x05\u8ee4", // 軤
	0x8ee5: "\x9f\x05\u8ee5", // 軥
	0x8ee6: "\x9f\x05\u8ee6", // 軦
	0x8ee7: "\x9f\x05\u8ee7", // 軧
	0x8ee8: "\x9f\x05\u8ee8", // 軨
	0x8ee9: "\x9f\x05\u8ee9", // 軩
	0x8eea: "\x9f\x05\u8eea", // 軪
	0x8eeb: "\x9f\x05\u8eeb", // 軫
	0x8eec: "\x9f\x05\u8eec", // 軬
	0x8eed: "\x9f\x06\u8eed", // 軭
	0x8eee: "\x9f\x05\u8eee", // 軮
	0x8eef: "\x9f\x05\u8eef", // 軯
	0x8ef0: "\x9f\x05\u8ef0", // 軰
	0x8ef1: "\x9f\x05\u8ef1", // 軱
	0x8ef2: "\x9f\x05\u8ef2", // 軲
	0x8ef3: "\x9f\x05\u8ef3", // 軳
	0x8ef4: "\x9f\x05\u8ef4", // 軴
	0x8ef5: "\x9f\x05\u8ef5", // 軵
	0x8ef6: "\x9f\x05\u8ef6", // 軶
	0x8ef7: "\x9f\x05\u8ef7", // 軷
	0x8ef8: "\x9f\x05\u8ef8", // 軸
	0x8ef9: "\x9f\x05\u8ef9", // 軹
	0x8efa: "\x9f\x05\u8efa", // 軺
	0x8efb: "\x9f\x05\u8efb", // 軻
	0x8efc: "\x9f\x05\u8efc", // 軼
	0x8efd: "\x9f\x05\u8efd", // 軽
	0x8efe: "\x9f\x06\u8efe", // 軾
	0x8eff: "\x9f\x06\u8eff", // 軿
	0x8f00: "\x9f\x06\u8f00", // 輀
	0x8f01: "\x9f\x06\u8f01", // 輁
	0x8f02: "\x9f\x06\u8f02", // 輂
	0x8f03: "\x9f\x06\u8f03", // 較
	0x8f04: "\x9f\x06\u8f04", // 輄
	0x8f05: "\x9f\x06\u8f05", // 輅
	0x8f06: "\x9f\x06\u8f06", // 輆
	0x8f07: "\x9f\x06\u8f07", // 輇
	0x8f08: "\x9f\x06\u8f08", // 輈
	0x8f09: "\x9f\x06\u8f09", // 載
	0x8f0a: "\x9f\x06\u8f0a", // 輊
	0x8f0b: "\x9f\x06\u8f0b", // 輋
	0x8f0c: "\x9f\x06\u8f0c", // 輌
	0x8f0d: "\x9f\a\u8f0d", // 輍
	0x8f0e: "\x9f\a\u8f0e", // 輎
	0x8f0f: "\x9f\a\u8f0f", // 輏
	0x8f10: "\x9f\a\u8f10", // 輐
	0x8f11: "\x9f\a\u8f11", // 輑
	0x8f12: "\x9f\a\u8f12", // 輒
	0x8f13: "\x9f\a\u8f13", // 輓
	0x8f14: "\x9f\a\u8f14", // 輔
	0x8f15: "\x9f\a\u8f15", // 輕
	0x8f16: "\x9f\b\u8f16", // 輖
	0x8f17: "\x9f\b\u8f17", // 輗
	0x8f18: "\x9f\b\u8f18", // 輘
	0x8f19: "\x9f\b\u8f19", // 輙
	0x8f1a: "\x9f\b\u8f1a", // 輚
	0x8f1b: "\x9f\b\u8f1b", // 輛
	0x8f1c: "\x9f\b\u8f1c", // 輜
	0x8f1d: "\x9f\b\u8f1d", // 輝
	0x8f1e: "\x9f\b\u8f1e", // 輞
	0x8f1f: "\x9f\b\u8f1f", // 輟
	0x8f20: "\x9f\b\u8f20", // 輠
	0x8f21: "\x9f\b\u8f21", // 輡
	0x8f22: "\x9f\b\u8f22", // 輢
	0x8f23: "\x9f\b\u8f23", // 輣
	0x8f24: "\x9f\b\u8f24", // 輤
	0x8f25: "\x9f\b\u8f25", // 輥
	0x8f26: "\x9f\b\u8f26", // 輦
	0x8f27: "\x9f\b\u8f27", // 輧
	0x8f28: "\x9f\b\u8f28", // 輨
	0x8f29: "\x9f\b\u8f29", // 輩
	0x8f2a: "\x9f\b\u8f2a", // 輪
	0x8f2b: "\x9f\b\u8f2b", // 輫
	0x8f2c: "\x9f\b\u8f2c", // 輬
	0x8f2d: "\x9f\t\u8f2d", // 輭
	0x8f2e: "\x9f\t\u8f2e", // 輮
	0x8f2f: "\x9f\t\u8f2f", // 輯
	0x8f30: "\x9f\t\u8f30", // 輰
	0x8f31: "\x9f\t\u8f31", // 輱
	0x8f32: "\x9f\t\u8f32", // 輲
	0x8f33: "\x9f\t\u8f33", // 輳
	0x8f34: "\x9f\t\u8f34", // 輴
	0x8f35: "\x9f\t\u8f35", // 輵
	0x8f36: "\x9f\t\u8f36", // 輶
	0x8f37: "\x9f\t\u8f37", // 輷
	0x8f38: "\x9f\t\u8f38", // 輸
	0x8f39: "\x9f\t\u8f39", // 輹
	0x8f3a: "\x9f\t\u8f3a", // 輺
	0x8f3b: "\x9f\t\u8f3b", // 輻
	0x8f3c: "\x9f\t\u8f3c", // 輼
	0x8f3d: "\x9f\n\u8f3d", // 輽
	0x8f3e: "\x9f\n\u8f3e", // 輾
	0x8f3f: "\x9f\n\u8f3f", // 輿
	0x8f40: "\x9f\n\u8f40", // 轀
	0x8f41: "\x9f\n\u8f41", // 轁
	0x8f42: "\x9f\n\u8f42", // 轂
	0x8f43: "\x9f\n\u8f43", // 轃
	0x8f44: "\x9f\n\u8f44", // 轄
	0x8f45: "\x9f\n\u8f45", // 轅
	0x8f46: "\x9f\v\u8f46", // 轆
	0x8f47: "\x9f\v\u8f47", // 轇
	0x8f48: "\x9f\v\u8f48", // 轈
	0x8f49: "\x9f\v\u8f49", // 轉
	0x8f4a: "\x9f\v\u8f4a", // 轊
	0x8f4b: "\x9f\v\u8f4b", // 轋
	0x8f4c: "\x9f\v\u8f4c", // 轌
	0x8f4d: "\x9f\f\u8f4d", // 轍
	0x8f4e: "\x9f\f\u8f4e", // 轎
	0x8f4f: "\x9f\f\u8f4f", // 轏
	0x8f50: "\x9f\f\u8f50", // 轐
	0x8f51: "\x9f\f\u8f51", // 轑
	0x8f52: "\x9f\f\u8f52", // 轒
	0x8f53: "\x9f\f\u8f53", // 轓
	0x8f54: "\x9f\f\u8f54", // 轔
	0x8f55: "\x9f\r\u8f55", // 轕
	0x8f56: "\x9f\r\u8f56", // 轖
	0x8f57: "\x9f\r\u8f57", // 轗
	0x8f58: "\x9f\r\u8f58", // 轘
	0x8f59: "\x9f\r\u8f59", // 轙
	0x8f5a: "\x9f\r\u8f5a", // 轚
	0x8f5b: "\x9f\x0e\u8f5b", // 轛
	0x8f5c: "\x9f\x0e\u8f5c", // 轜
	0x8f5d: "\x9f\x0e\u8f5d", // 轝
	0x8f5e: "\x9f\x0e\u8f5e", // 轞
	0x8f5f: "\x9f\x0e\u8f5f", // 轟
	0x8f60: "\x9f\x0f\u8f60", // 轠
	0x8f61: "\x9f\x0f\u8f61", // 轡
	0x8f62: "\x9f\x0f\u8f62", // 轢
	0x8f63: "\x9f\x10\u8f63", // 轣
	0x8f64: "\x9f\x10\u8f64", // 轤
	0x8f65: "\x9f\x14\u8f65", // 轥
	0x8f66: "\x9f\x00\u8f66", // 车
	0x8f67: "\x9f\x01\u8f67", // 轧
	0x8f68: "\x9f\x02\u8f68", // 轨
	0x8f69: "\x9f\x03\u8f69", // 轩
	0x8f6a: "\x9f\x03\u8f6a", // 轪
	0x8f6b: "\x9f\x03\u8f6b", // 轫
	0x8f6c: "\x9f\x04\u8f6c", // 转
	0x8f6d: "\x9f\x04\u8f6d", // 轭
	0x8f6e: "\x9f\x04\u8f6e", // 轮
	0x8f6f: "\x9f\x04\u8f6f", // 软
	0x8f70: "\x9f\x04\u8f70", // 轰
	0x8f71: "\x9f\x05\u8f71", // 轱
	0x8f72: "\x9f\x05\u8f72", // 轲
	0x8f73: "\x9f\x05\u8f73", // 轳
	0x8f74: "\x9f\x05\u8f74", // 轴
	0x8f75: "\x9f\x05\u8f75", // 轵
	0x8f76: "\x9f\x05\u8f76", // 轶
	0x8f77: "\x9f\x05\u8f77", // 轷
	0x8f78: "\x9f\x05\u8f78", // 轸
	0x8f79: "\x9f\x05\u8f79", // 轹
	0x8f7a: "\x9f\x05\u8f7a", // 轺
	0x8f7b: "\x9f\x05\u8f7b", // 轻
	0x8f7c: "\x9f\x06\u8f7c", // 轼
	0x8f7d: "\x9f\x06\u8f7d", // 载
	0x8f7e: "\x9f\x06\u8f7e", // 轾
	0x8f7f: "\x9f\x06\u8f7f", // 轿
	0x8f80: "\x9f\x06\u8f80", // 辀
	0x8f81: "\x9f\x06\u8f81", // 辁
	0x8f82: "\x9f\x06\u8f82", // 辂
	0x8f83: "\x9f\x06\u8f83", // 较
	0x8f84: "\x9f\a\u8f84", // 辄
	0x8f85: "\x9f\a\u8f85", // 辅
	0x8f86: "\x9f\a\u8f86", // 辆
	0x8f87: "\x9f\b\u8f87", // 辇
	0x8f88: "\x9f\b\u8f88", // 辈
	0x8f89: "\x9f\b\u8f89", // 辉
	0x8f8a: "\x9f\b\u8f8a", // 辊
	0x8f8b: "\x9f\b\u8f8b", // 辋
	0x8f8c: "\x9f\b\u8f8c", // 辌
	0x8f8d: "\x9f\b\u8f8d", // 辍
	0x8f8e: "\x9f\b\u8f8e", // 辎
	0x8f8f: "\x9f\t\u8f8f", // 辏
	0x8f90: "\x9f\t\u8f90", // 辐
	0x8f91: "\x9f\t\u8f91", // 辑
	0x8f92: "\x9f\t\u8f92", // 辒
	0x8f93: "\x9f\t\u8f93", // 输
	0x8f94: "\x9f\t\u8f94", // 辔
	0x8f95: "\x9f\n\u8f95", // 辕
	0x8f96: "\x9f\n\u8f96", // 辖
	0x8f97: "\x9f\n\u8f97", // 辗
	0x8f98: "\x9f\v\u8f98", // 辘
	0x8f99: "\x9f\f\u8f99", // 辙
	0x8f9a: "\x9f\f\u8f9a", // 辚
	0x8f9b: "\xa0\x00\u8f9b", // 辛
	0x8f9c: "\xa0\x05\u8f9c", // 辜
	0x8f9d: "\xa0\x05\u8f9d", // 辝
	0x8f9e: "\xa0\x06\u8f9e", // 辞
	0x8f9f: "\xa0\x06\u8f9f", // 辟
	0x8fa0: "\xa0\x06\u8fa0", // 辠
	0x8fa1: "\xa0\a\u8fa1", // 辡
	0x8fa2: "\xa0\a\u8fa2", // 辢
	0x8fa3: "\xa0\a\u8fa3", // 辣
	0x8fa4: "\xa0\b\u8fa4", // 辤
	0x8fa5: "\xa0\t\u8fa5", // 辥
	0x8fa6: "\xa0\t\u8fa6", // 辦
	0x8fa7: "\xa0\t\u8fa7", // 辧
	0x8fa8: "\xa0\t\u8fa8", // 辨
	0x8fa9: "\xa0\t\u8fa9", // 辩
	0x8faa: "\xa0\t\u8faa", // 辪
	0x8fab: "\xa0\n\u8fab", // 辫
	0x8fac: "\xa0\v\u8fac", // 辬
	0x8fad: "\xa0\f\u8fad", // 辭
	0x8fae: "\xa0\r\u8fae", // 辮
	0x8faf: "\xa0\x0e\u8faf", // 辯
	0x8fb0: "\xa1\x00\u8fb0", // 辰
	0x8fb1: "\xa1\x03\u8fb1", // 辱
	0x8fb2: "\xa1\x06\u8fb2", // 農
	0x8fb3: "\xa1\b\u8fb3", // 辳
	0x8fb4: "\xa1\f\u8fb4", // 辴
	0x8fb5: "\xa2\x00\u8fb5", // 辵
	0x8fb6: "\xa2\x00\u8fb6", // 辶
	0x8fb7: "\xa2\x01\u8fb7", // 辷
	0x8fb8: "\xa2\x02\u8fb8", // 辸
	0x8fb9: "\xa2\x02\u8fb9", // 边
	0x8fba: "\xa2\x02\u8fba", // 辺
	0x8fbb: "\xa2\x02\u8fbb", // 辻
	0x8fbc: "\xa2\x02\u8fbc", // 込
	0x8fbd: "\xa2\x02\u8fbd", // 辽
	0x8fbe: "\xa2\x03\u8fbe", // 达
	0x8fbf: "\xa2\x03\u8fbf", // 辿
	0x8fc0: "\xa2\x03\u8fc0", // 迀
	0x8fc1: "\xa2\x03\u8fc1", // 迁
	0x8fc2: "\xa2\x03\u8fc2", // 迂
	0x8fc3: "\xa2\x03\u8fc3", // 迃
	0x8fc4: "\xa2\x03\u8fc4", // 迄
	0x8fc5: "\xa2\x03\u8fc5", // 迅
	0x8fc6: "\xa2\x03\u8fc6", // 迆
	0x8fc7: "\xa2\x03\u8fc7", // 过
	0x8fc8: "\xa2\x03\u8fc8", // 迈
	0x8fc9: "\xa2\x03\u8fc9", // 迉
	0x8fca: "\xa2\x04\u8fca", // 迊
	0x8fcb: "\xa2\x04\u8fcb", // 迋
	0x8fcc: "\xa2\x04\u8fcc", // 迌
	0x8fcd: "\xa2\x04\u8fcd", // 迍
	0x8fce: "\xa2\x04\u8fce", // 迎
	0x8fcf: "\xa2\x04\u8fcf", // 迏
	0x8fd0: "\xa2\x04\u8fd0", // 运
	0x8fd1: "\xa2\x04\u8fd1", // 近
	0x8fd2: "\xa2\x04\u8fd2", // 迒
	0x8fd3: "\xa2\x04\u8fd3", // 迓
	0x8fd4: "\xa2\x04\u8fd4", // 返
	0x8fd5: "\xa2\x04\u8fd5", // 迕
	0x8fd6: "\xa2\x04\u8fd6", // 迖
	0x8fd7: "\xa2\x04\u8fd7", // 迗
	0x8fd8: "\xa2\x04\u8fd8", // 还
	0x8fd9: "\xa2\x04\u8fd9", // 这
	0x8fda: "\xa2\x04\u8fda", // 迚
	0x8fdb: "\xa2\x04\u8fdb", // 进
	0x8fdc: "\xa2\x04\u8fdc", // 远
	0x8fdd: "\xa2\x04\u8fdd", // 违
	0x8fde: "\xa2\x04\u8fde", // 连
	0x8fdf: "\xa2\x04\u8fdf", // 迟
	0x8fe0: "\xa2\x05\u8fe0", // 迠
	0x8fe1: "\xa2\x05\u8fe1", // 迡
	0x8fe2: "\xa2\x05\u8fe2", // 迢
	0x8fe3: "\xa2\x05\u8fe3", // 迣
	0x8fe4: "\xa2\x05\u8fe4", // 迤
	0x8fe5: "\xa2\x05\u8fe5", // 迥
	0x8fe6: "\xa2\x05\u8fe6", // 迦
	0x8fe7: "\xa2\x05\u8fe7", // 迧
	0x8fe8: "\xa2\x05\u8fe8", // 迨
	0x8fe9: "\xa2\x05\u8fe9", // 迩
	0x8fea: "\xa2\x05\u8fea", // 迪
	0x8feb: "\xa2\x05\u8feb", // 迫
	0x8fec: "\xa2\x04\u8fec", // 迬
	0x8fed: "\xa2\x05\u8fed", // 迭
	0x8fee: "\xa2\x05\u8fee", // 迮
	0x8fef: "\xa2\x05\u8fef", // 迯
	0x8ff0: "\xa2\x05\u8ff0", // 述
	0x8ff1: "\xa2\x05\u8ff1", // 迱
	0x8ff2: "\xa2\x05\u8ff2", // 迲
	0x8ff3: "\xa2\x05\u8ff3", // 迳
	0x8ff4: "\xa2\x06\u8ff4", // 迴
	0x8ff5: "\xa2\x06\u8ff5", // 迵
	0x8ff6: "\xa2\x06\u8ff6", // 迶
	0x8ff7: "\xa2\x06\u8ff7", // 迷
	0x8ff8: "\xa2\x06\u8ff8", // 迸
	0x8ff9: "\xa2\x06\u8ff9", // 迹
	0x8ffa: "\xa2\x06\u8ffa", // 迺
	0x8ffb: "\xa2\x06\u8ffb", // 迻
	0x8ffc: "\xa2\x06\u8ffc", // 迼
	0x8ffd: "\xa2\x06\u8ffd", // 追
	0x8ffe: "\xa2\x06\u8ffe", // 迾
	0x8fff: "\xa2\x06\u8fff", // 迿
	0x9000: "\xa2\x06\u9000", // 退
	0x9001: "\xa2\x06\u9001", // 送
	0x9002: "\xa2\x06\u9002", // 适
	0x9003: "\xa2\x06\u9003", // 逃
	0x9004: "\xa2\x06\u9004", // 逄
	0x9005: "\xa2\x06\u9005", // 逅
	0x9006: "\xa2\x06\u9006", // 逆
	0x9007: "\xa2\x06\u9007", // 逇
	0x9008: "\xa2\x06\u9008", // 逈
	0x9009: "\xa2\x06\u9009", // 选
	0x900a: "\xa2\x06\u900a", // 逊
	0x900b: "\xa2\a\u900b", // 逋
	0x900c: "\xa2\a\u900c", // 逌
	0x900d: "\xa2\a\u900d", // 逍
	0x900e: "\xa2\a\u900e", // 逎
	0x900f: "\xa2\a\u900f", // 透
	0x9010: "\xa2\a\u9010", // 逐
	0x9011: "\xa2\a\u9011", // 逑
	0x9012: "\xa2\a\u9012", // 递
	0x9013: "\xa2\a\u9013", // 逓
	0x9014: "\xa2\a\u9014", // 途
	0x9015: "\xa2\a\u9015", // 逕
	0x9016: "\xa2\a\u9016", // 逖
	0x9017: "\xa2\a\u9017", // 逗
	0x9018: "\xa2\a\u9018", // 逘
	0x9019: "\xa2\a\u9019", // 這
	0x901a: "\xa2\a\u901a", // 通
	0x901b: "\xa2\a\u901b", // 逛
	0x901c: "\xa2\a\u901c", // 逜
	0x901d: "\xa2\a\u901d", // 逝
	0x901e: "\xa2\a\u901e", // 逞
	0x901f: "\xa2\a\u901f", // 速
	0x9020: "\xa2\a\u9020", // 造
	0x9021: "\xa2\a\u9021", // 逡
	0x9022: "\xa2\a\u9022", // 逢
	0x9023: "\xa2\a\u9023", // 連
	0x9024: "\xa2\a\u9024", // 逤
	0x9025: "\xa2\a\u9025", // 逥
	0x9026: "\xa2\a\u9026", // 逦
	0x9027: "\xa2\a\u9027", // 逧
	0x9028: "\xa2\b\u9028", // 逨
	0x9029: "\xa2\b\u9029", // 逩
	0x902a: "\xa2\b\u902a", // 逪
	0x902b: "\xa2\b\u902b", // 逫
	0x902c: "\xa2\b\u902c", // 逬
	0x902d: "\xa2\b\u902d", // 逭
	0x902e: "\xa2\b\u902e", // 逮
	0x902f: "\xa2\b\u902f", // 逯
	0x9030: "\xa2\b\u9030", // 逰
	0x9031: "\xa2\b\u9031", // 週
	0x9032: "\xa2\b\u9032", // 進
	0x9033: "\xa2\b\u9033", // 逳
	0x9034: "\xa2\b\u9034", // 逴
	0x9035: "\xa2\b\u9035", // 逵
	0x9036: "\xa2\b\u9036", // 逶
	0x9037: "\xa2\b\u9037", // 逷
	0x9038: "\xa2\b\u9038", // 逸
	0x9039: "\xa2\b\u9039", // 逹
	0x903a: "\xa2\b\u903a", // 逺
	0x903b: "\xa2\b\u903b", // 逻
	0x903c: "\xa2\t\u903c", // 逼
	0x903d: "\xa2\t\u903d", // 逽
	0x903e: "\xa2\t\u903e", // 逾
	0x903f: "\xa2\t\u903f", // 逿
	0x9040: "\xa2\t\u9040", // 遀
	0x9041: "\xa2\t\u9041", // 遁
	0x9042: "\xa2\t\u9042", // 遂
	0x9043: "\xa2\t\u9043", // 遃
	0x9044: "\xa2\t\u9044", // 遄
	0x9045: "\xa2\t\u9045", // 遅
	0x9046: "\xa2\t\u9046", // 遆
	0x9047: "\xa2\t\u9047", // 遇
	0x9048: "\xa2\t\u9048", // 遈
	0x9049: "\xa2\t\u9049", // 遉
	0x904a: "\xa2\t\u904a", // 遊
	0x904b: "\xa2\t\u904b", // 運
	0x904c: "\xa2\t\u904c", // 遌
	0x904d: "\xa2\t\u904d", // 遍
	0x904e: "\xa2\t\u904e", // 過
	0x904f: "\xa2\t\u904f", // 遏
	0x9050: "\xa2\t\u9050", // 遐
	0x9051: "\xa2\t\u9051", // 遑
	0x9052: "\xa2\t\u9052", // 遒
	0x9053: "\xa2\t\u9053", // 道
	0x9054: "\xa2\t\u9054", // 達
	0x9055: "\xa2\t\u9055", // 違
	0x9056: "\xa2\t\u9056", // 遖
	0x9057: "\xa2\t\u9057", // 遗
	0x9058: "\xa2\n\u9058", // 遘
	0x9059: "\xa2\n\u9059", // 遙
	0x905a: "\xa2\n\u905a", // 遚
	0x905b: "\xa2\n\u905b", // 遛
	0x905c: "\xa2\n\u905c", // 遜
	0x905d: "\xa2\n\u905d", // 遝
	0x905e: "\xa2\n\u905e", // 遞
	0x905f: "\xa2\n\u905f", // 遟
	0x9060: "\xa2\n\u9060", // 遠
	0x9061: "\xa2\n\u9061", // 遡
	0x9062: "\xa2\n\u9062", // 遢
	0x9063: "\xa2\n\u9063", // 遣
	0x9064: "\xa2\n\u9064", // 遤
	0x9065: "\xa2\n\u9065", // 遥
	0x9066: "\xa2\v\u9066", // 遦
	0x9067: "\xa2\v\u9067", // 遧
	0x9068: "\xa2\v\u9068", // 遨
	0x9069: "\xa2\v\u9069", // 適
	0x906a: "\xa2\v\u906a", // 遪
	0x906b: "\xa2\v\u906b", // 遫
	0x906c: "\xa2\v\u906c", // 遬
	0x906d: "\xa2\v\u906d", // 遭
	0x906e: "\xa2\v\u906e", // 遮
	0x906f: "\xa2\v\u906f", // 遯
	0x9070: "\xa2\v\u9070", // 遰
	0x9071: "\xa2\v\u9071", // 遱
	0x9072: "\xa2\f\u9072", // 遲
	0x9073: "\xa2\v\u9073", // 遳
	0x9074: "\xa2\f\u9074", // 遴
	0x9075: "\xa2\f\u9075", // 遵
	0x9076: "\xa2\f\u9076", // 遶
	0x9077: "\xa2\f\u9077", // 遷
	0x9078: "\xa2\f\u9078", // 選
	0x9079: "\xa2\f\u9079", // 遹
	0x907a: "\xa2\f\u907a", // 遺
	0x907b: "\xa2\f\u907b", // 遻
	0x907c: "\xa2\f\u907c", // 遼
	0x907d: "\xa2\r\u907d", // 遽
	0x907e: "\xa2\r\u907e", // 遾
	0x907f: "\xa2\r\u907f", // 避
	0x9080: "\xa2\r\u9080", // 邀
	0x9081: "\xa2\r\u9081", // 邁
	0x9082: "\xa2\r\u9082", // 邂
	0x9083: "\xa2\r\u9083", // 邃
	0x9084: "\xa2\r\u9084", // 還
	0x9085: "\xa2\r\u9085", // 邅
	0x9086: "\xa2\f\u9086", // 邆
	0x9087: "\xa2\x0e\u9087", // 邇
	0x9088: "\xa2\x0e\u9088", // 邈
	0x9089: "\xa2\r\u9089", // 邉
	0x908a: "\xa2\x0f\u908a", // 邊
	0x908b: "\xa2\x0f\u908b", // 邋
	0x908c: "\xa2\x0f\u908c", // 邌
	0x908d: "\xa2\x10\u908d", // 邍
	0x908e: "\xa2\x11\u908e", // 邎
	0x908f: "\xa2\x13\u908f", // 邏
	0x9090: "\xa2\x13\u9090", // 邐
	0x9091: "\xa3\x00\u9091", // 邑
	0x9092: "\xa3\x02\u9092", // 邒
	0x9093: "\xa3\x02\u9093", // 邓
	0x9094: "\xa3\x03\u9094", // 邔
	0x9095: "\xa3\x03\u9095", // 邕
	0x9096: "\xa3\x03\u9096", // 邖
	0x9097: "\xa3\x03\u9097", // 邗
	0x9098: "\xa3\x03\u9098", // 邘
	0x9099: "\xa3\x03\u9099", // 邙
	0x909a: "\xa3\x03\u909a", // 邚
	0x909b: "\xa3\x03\u909b", // 邛
	0x909c: "\xa3\x03\u909c", // 邜
	0x909d: "\xa3\x03\u909d", // 邝
	0x909e: "\xa3\x04\u909e", // 邞
	0x909f: "\xa3\x04\u909f", // 邟
	0x90a0: "\xa3\x04\u90a0", // 邠
	0x90a1: "\xa3\x04\u90a1", // 邡
	0x90a2: "\xa3\x04\u90a2", // 邢
	0x90a3: "\xa3\x04\u90a3", // 那
	0x90a4: "\xa3\x04\u90a4", // 邤
	0x90a5: "\xa3\x04\u90a5", // 邥
	0x90a6: "\xa3\x04\u90a6", // 邦
	0x90a7: "\xa3\x04\u90a7", // 邧
	0x90a8: "\xa3\x04\u90a8", // 邨
	0x90a9: "\xa3\x04\u90a9", // 邩
	0x90aa: "\xa3\x04\u90aa", // 邪
	0x90ab: "\xa3\x04\u90ab", // 邫
	0x90ac: "\xa3\x04\u90ac", // 邬
	0x90ad: "\xa3\x05\u90ad", // 邭
	0x90ae: "\xa3\x05\u90ae", // 邮
	0x90af: "\xa3\x05\u90af", // 邯
	0x90b0: "\xa3\x05\u90b0", // 邰
	0x90b1: "\xa3\x05\u90b1", // 邱
	0x90b2: "\xa3\x05\u90b2", // 邲
	0x90b3: "\xa3\x05\u90b3", // 邳
	0x90b4: "\xa3\x05\u90b4", // 邴
	0x90b5: "\xa3\x05\u90b5", // 邵
	0x90b6: "\xa3\x05\u90b6", // 邶
	0x90b7: "\xa3\x05\u90b7", // 邷
	0x90b8: "\xa3\x05\u90b8", // 邸
	0x90b9: "\xa3\x05\u90b9", // 邹
	0x90ba: "\xa3\x05\u90ba", // 邺
	0x90bb: "\xa3\x05\u90bb", // 邻
	0x90bc: "\xa3\x06\u90bc", // 邼
	0x90bd: "\xa3\x06\u90bd", // 邽
	0x90be: "\xa3\x06\u90be", // 邾
	0x90bf: "\xa3\x06\u90bf", // 邿
	0x90c0: "\xa3\x06\u90c0", // 郀
	0x90c1: "\xa3\x06\u90c1", // 郁
	0x90c2: "\xa3\x06\u90c2", // 郂
	0x90c3: "\xa3\x06\u90c3", // 郃
	0x90c4: "\xa3\x06\u90c4", // 郄
	0x90c5: "\xa3\x06\u90c5", // 郅
	0x90c6: "\xa3\x06\u90c6", // 郆
	0x90c7: "\xa3\x06\u90c7", // 郇
	0x90c8: "\xa3\x06\u90c8", // 郈
	0x90c9: "\xa3\x06\u90c9", // 郉
	0x90ca: "\xa3\x06\u90ca", // 郊
	0x90cb: "\xa3\x06\u90cb", // 郋
	0x90cc: "\xa3\x06\u90cc", // 郌
	0x90cd: "\xa3\x06\u90cd", // 郍
	0x90ce: "\xa3\x06\u90ce", // 郎
	0x90cf: "\xa3\x06\u90cf", // 郏
	0x90d0: "\xa3\x06\u90d0", // 郐
	0x90d1: "\xa3\x06\u90d1", // 郑
	0x90d2: "\xa3\a\u90d2", // 郒
	0x90d3: "\xa3\x06\u90d3", // 郓
	0x90d4: "\xa3\a\u90d4", // 郔
	0x90d5: "\xa3\a\u90d5", // 郕
	0x90d6: "\xa3\a\u90d6", // 郖
	0x90d7: "\xa3\a\u90d7", // 郗
	0x90d8: "\xa3\a\u90d8", // 郘
	0x90d9: "\xa3\a\u90d9", // 郙
	0x90da: "\xa3\a\u90da", // 郚
	0x90db: "\xa3\a\u90db", // 郛
	0x90dc: "\xa3\a\u90dc", // 郜
	0x90dd: "\xa3\a\u90dd", // 郝
	0x90de: "\xa3\a\u90de", // 郞
	0x90df: "\xa3\a\u90df", // 郟
	0x90e0: "\xa3\a\u90e0", // 郠
	0x90e1: "\xa3\a\u90e1", // 郡
	0x90e2: "\xa3\a\u90e2", // 郢
	0x90e3: "\xa3\a\u90e3", // 郣
	0x90e4: "\xa3\a\u90e4", // 郤
	0x90e5: "\xa3\a\u90e5", // 郥
	0x90e6: "\xa3\a\u90e6", // 郦
	0x90e7: "\xa3\a\u90e7", // 郧
	0x90e8: "\xa3\b\u90e8", // 部
	0x90e9: "\xa3\b\u90e9", // 郩
	0x90ea: "\xa3\b\u90ea", // 郪
	0x90eb: "\xa3\b\u90eb", // 郫
	0x90ec: "\xa3\b\u90ec", // 郬
	0x90ed: "\xa3\b\u90ed", // 郭
	0x90ee: "\xa3\b\u90ee", // 郮
	0x90ef: "\xa3\b\u90ef", // 郯
	0x90f0: "\xa3\b\u90f0", // 郰
	0x90f1: "\xa3\b\u90f1", // 郱
	0x90f2: "\xa3\b\u90f2", // 郲
	0x90f3: "\xa3\b\u90f3", // 郳
	0x90f4: "\xa3\b\u90f4", // 郴
	0x90f5: "\xa3\b\u90f5", // 郵
	0x90f6: "\xa3\b\u90f6", // 郶
	0x90f7: "\xa3\b\u90f7", // 郷
	0x90f8: "\xa3\b\u90f8", // 郸
	0x90f9: "\xa3\t\u90f9", // 郹
	0x90fa: "\xa3\t\u90fa", // 郺
	0x90fb: "\xa3\t\u90fb", // 郻
	0x90fc: "\xa3\t\u90fc", // 郼
	0x90fd: "\xa3\t\u90fd", // 都
	0x90fe: "\xa3\t\u90fe", // 郾
	0x90ff: "\xa3\t\u90ff", // 郿
	0x9100: "\xa3\t\u9100", // 鄀
	0x9101: "\xa3\t\u9101", // 鄁
	0x9102: "\xa3\t\u9102", // 鄂
	0x9103: "\xa3\t\u9103", // 鄃
	0x9104: "\xa3\t\u9104", // 鄄
	0x9105: "\xa3\t\u9105", // 鄅
	0x9106: "\xa3\t\u9106", // 鄆
	0x9107: "\xa3\t\u9107", // 鄇
	0x9108: "\xa3\t\u9108", // 鄈
	0x9109: "\xa3\t\u9109", // 鄉
	0x910a: "\xa3\t\u910a", // 鄊
	0x910b: "\xa3\n\u910b", // 鄋
	0x910c: "\xa3\n\u910c", // 鄌
	0x910d: "\xa3\n\u910d", // 鄍
	0x910e: "\xa3\n\u910e", // 鄎
	0x910f: "\xa3\n\u910f", // 鄏
	0x9110: "\xa3\n\u9110", // 鄐
	0x9111: "\xa3\n\u9111", // 鄑
	0x9112: "\xa3\n\u9112", // 鄒
	0x9113: "\xa3\n\u9113", // 鄓
	0x9114: "\xa3\n\u9114", // 鄔
	0x9115: "\xa3\n\u9115", // 鄕
	0x9116: "\xa3\n\u9116", // 鄖
	0x9117: "\xa3\n\u9117", // 鄗
	0x9118: "\xa3\v\u9118", // 鄘
	0x9119: "\xa3\v\u9119", // 鄙
	0x911a: "\xa3\v\u911a", // 鄚
	0x911b: "\xa3\v\u911b", // 鄛
	0x911c: "\xa3\v\u911c", // 鄜
	0x911d: "\xa3\v\u911d", // 鄝
	0x911e: "\xa3\v\u911e", // 鄞
	0x911f: "\xa3\v\u911f", // 鄟
	0x9120: "\xa3\v\u9120", // 鄠
	0x9121: "\xa3\v\u9121", // 鄡
	0x9122: "\xa3\v\u9122", // 鄢
	0x9123: "\xa3\v\u9123", // 鄣
	0x9124: "\xa3\v\u9124", // 鄤
	0x9125: "\xa3\v\u9125", // 鄥
	0x9126: "\xa3\f\u9126", // 鄦
	0x9127: "\xa3\f\u9127", // 鄧
	0x9128: "\xa3\f\u9128", // 鄨
	0x9129: "\xa3\f\u9129", // 鄩
	0x912a: "\xa3\f\u912a", // 鄪
	0x912b: "\xa3\f\u912b", // 鄫
	0x912c: "\xa3\f\u912c", // 鄬
	0x912d: "\xa3\f\u912d", // 鄭
	0x912e: "\xa3\f\u912e", // 鄮
	0x912f: "\xa3\f\u912f", // 鄯
	0x9130: "\xa3\f\u9130", // 鄰
	0x9131: "\xa3\f\u9131", // 鄱
	0x9132: "\xa3\f\u9132", // 鄲
	0x9133: "\xa3\r\u9133", // 鄳
	0x9134: "\xa3\r\u9134", // 鄴
	0x9135: "\xa3\r\u9135", // 鄵
	0x9136: "\xa3\r\u9136", // 鄶
	0x9137: "\xa3\r\u9137", // 鄷
	0x9138: "\xa3\x0e\u9138", // 鄸
	0x9139: "\xa3\x0e\u9139", // 鄹
	0x913a: "\xa3\x0f\u913a", // 鄺
	0x913b: "\xa3\x0f\u913b", // 鄻
	0x913c: "\xa3\x0f\u913c", // 鄼
	0x913d: "\xa3\x0f\u913d", // 鄽
	0x913e: "\xa3\x0f\u913e", // 鄾
	0x913f: "\xa3\x10\u913f", // 鄿
	0x9140: "\xa3\x10\u9140", // 酀
	0x9141: "\xa3\x11\u9141", // 酁
	0x9142: "\xa3\x10\u9142", // 酂
	0x9143: "\xa3\x11\u9143", // 酃
	0x9144: "\xa3\x12\u9144", // 酄
	0x9145: "\xa3\x12\u9145", // 酅
	0x9146: "\xa3\x12\u9146", // 酆
	0x9147: "\xa3\x13\u9147", // 酇
	0x9148: "\xa3\x13\u9148", // 酈
	0x9149: "\xa4\x00\u9149", // 酉
	0x914a: "\xa4\x02\u914a", // 酊
	0x914b: "\xa4\x02\u914b", // 酋
	0x914c: "\xa4\x03\u914c", // 酌
	0x914d: "\xa4\x03\u914d", // 配
	0x914e: "\xa4\x03\u914e", // 酎
	0x914f: "\xa4\x03\u914f", // 酏
	0x9150: "\xa4\x03\u9150", // 酐
	0x9151: "\xa4\x03\u9151", // 酑
	0x9152: "\xa4\x03\u9152", // 酒
	0x9153: "\xa4\x04\u9153", // 酓
	0x9154: "\xa4\x04\u9154", // 酔
	0x9155: "\xa4\x04\u9155", // 酕
	0x9156: "\xa4\x04\u9156", // 酖
	0x9157: "\xa4\x04\u9157", // 酗
	0x9158: "\xa4\x04\u9158", // 酘
	0x9159: "\xa4\x04\u9159", // 酙
	0x915a: "\xa4\x04\u915a", // 酚
	0x915b: "\xa4\x04\u915b", // 酛
	0x915c: "\xa4\x04\u915c", // 酜
	0x915d: "\xa4\x04\u915d", // 酝
	0x915e: "\xa4\x04\u915e", // 酞
	0x915f: "\xa4\x05\u915f", // 酟
	0x9160: "\xa4\x05\u9160", // 酠
	0x9161: "\xa4\x05\u9161", // 酡
	0x9162: "\xa4\x05\u9162", // 酢
	0x9163: "\xa4\x05\u9163", // 酣
	0x9164: "\xa4\x05\u9164", // 酤
	0x9165: "\xa4\x05\u9165", // 酥
	0x9166: "\xa4\x06\u9166", // 酦
	0x9167: "\xa4\x06\u9167", // 酧
	0x9168: "\xa4\x06\u9168", // 酨
	0x9169: "\xa4\x06\u9169", // 酩
	0x916a: "\xa4\x06\u916a", // 酪
	0x916b: "\xa4\x06\u916b", // 酫
	0x916c: "\xa4\x06\u916c", // 酬
	0x916d: "\xa4\x06\u916d", // 酭
	0x916e: "\xa4\x06\u916e", // 酮
	0x916f: "\xa4\x06\u916f", // 酯
	0x9170: "\xa4\x06\u9170", // 酰
	0x9171: "\xa4\x06\u9171", // 酱
	0x9172: "\xa4\a\u9172", // 酲
	0x9173: "\xa4\a\u9173", // 酳
	0x9174: "\xa4\a\u9174", // 酴
	0x9175: "\xa4\a\u9175", // 酵
	0x9176: "\xa4\a\u9176", // 酶
	0x9177: "\xa4\a\u9177", // 酷
	0x9178: "\xa4\a\u9178", // 酸
	0x9179: "\xa4\a\u9179", // 酹
	0x917a: "\xa4\a\u917a", // 酺
	0x917b: "\xa4\a\u917b", // 酻
	0x917c: "\xa4\a\u917c", // 酼
	0x917d: "\xa4\a\u917d", // 酽
	0x917e: "\xa4\a\u917e", // 酾
	0x917f: "\xa4\a\u917f", // 酿
	0x9180: "\xa4\b\u9180", // 醀
	0x9181: "\xa4\b\u9181", // 醁
	0x9182: "\xa4\b\u9182", // 醂
	0x9183: "\xa4\b\u9183", // 醃
	0x9184: "\xa4\b\u9184", // 醄
	0x9185: "\xa4\b\u9185", // 醅
	0x9186: "\xa4\b\u9186", // 醆
	0x9187: "\xa4\b\u9187", // 醇
	0x9188: "\xa4\b\u9188", // 醈
	0x9189: "\xa4\b\u9189", // 醉
	0x918a: "\xa4\b\u918a", // 醊
	0x918b: "\xa4\b\u918b", // 醋
	0x918c: "\xa4\b\u918c", // 醌
	0x918d: "\xa4\t\u918d", // 醍
	0x918e: "\xa4\t\u918e", // 醎
	0x918f: "\xa4\t\u918f", // 醏
	0x9190: "\xa4\t\u9190", // 醐
	0x9191: "\xa4\t\u9191", // 醑
	0x9192: "\xa4\t\u9192", // 醒
	0x9193: "\xa4\t\u9193", // 醓
	0x9194: "\xa4\t\u9194", // 醔
	0x9195: "\xa4\t\u9195", // 醕
	0x9196: "\xa4\t\u9196", // 醖
	0x9197: "\xa4\t\u9197", // 醗
	0x9198: "\xa4\n\u9198", // 醘
	0x9199: "\xa4\n\u9199", // 醙
	0x919a: "\xa4\n\u919a", // 醚
	0x919b: "\xa4\n\u919b", // 醛
	0x919c: "\xa4\n\u919c", // 醜
	0x919d: "\xa4\n\u919d", // 醝
	0x919e: "\xa4\n\u919e", // 醞
	0x919f: "\xa4\n\u919f", // 醟
	0x91a0: "\xa4\n\u91a0", // 醠
	0x91a1: "\xa4\n\u91a1", // 醡
	0x91a2: "\xa4\n\u91a2", // 醢
	0x91a3: "\xa4\n\u91a3", // 醣
	0x91a4: "\xa4\n\u91a4", // 醤
	0x91a5: "\xa4\v\u91a5", // 醥
	0x91a6: "\xa4\v\u91a6", // 醦
	0x91a7: "\xa4\v\u91a7", // 醧
	0x91a8: "\xa4\v\u91a8", // 醨
	0x91a9: "\xa4\v\u91a9", // 醩
	0x91aa: "\xa4\v\u91aa", // 醪
	0x91ab: "\xa4\v\u91ab", // 醫
	0x91ac: "\xa4\v\u91ac", // 醬
	0x91ad: "\xa4\f\u91ad", // 醭
	0x91ae: "\xa4\f\u91ae", // 醮
	0x91af: "\xa4\f\u91af", // 醯
	0x91b0: "\xa4\f\u91b0", // 醰
	0x91b1: "\xa4\f\u91b1", // 醱
	0x91b2: "\xa4\r\u91b2", // 醲
	0x91b3: "\xa4\r\u91b3", // 醳
	0x91b4: "\xa4\r\u91b4", // 醴
	0x91b5: "\xa4\r\u91b5", // 醵
	0x91b6: "\xa4\r\u91b6", // 醶
	0x91b7: "\xa4\r\u91b7", // 醷
	0x91b8: "\xa4\r\u91b8", // 醸
	0x91b9: "\xa4\x0e\u91b9", // 醹
	0x91ba: "\xa4\x0e\u91ba", // 醺
	0x91bb: "\xa4\x0e\u91bb", // 醻
	0x91bc: "\xa4\x10\u91bc", // 醼
	0x91bd: "\xa4\x11\u91bd", // 醽
	0x91be: "\xa4\x11\u91be", // 醾
	0x91bf: "\xa4\x11\u91bf", // 醿
	0x91c0: "\xa4\x11\u91c0", // 釀
	0x91c1: "\xa4\x12\u91c1", // 釁
	0x91c2: "\xa4\x12\u91c2", // 釂
	0x91c3: "\xa4\x13\u91c3", // 釃
	0x91c4: "\xa4\x13\u91c4", // 釄
	0x91c5: "\xa4\x14\u91c5", // 釅
	0x91c6: "\xa5\x00\u91c6", // 釆
	0x91c7: "\xa5\x01\u91c7", // 采
	0x91c8: "\xa5\x04\u91c8", // 釈
	0x91c9: "\xa5\x05\u91c9", // 釉
	0x91ca: "\xa5\x05\u91ca", // 释
	0x91cb: "\xa5\r\u91cb", // 釋
	0x91cc: "\xa6\x00\u91cc", // 里
	0x91cd: "\xa6\x02\u91cd", // 重
	0x91ce: "\xa6\x04\u91ce", // 野
	0x91cf: "\xa6\x05\u91cf", // 量
	0x91d0: "\xa6\v\u91d0", // 釐
	0x91d1: "\xa7\x00\u91d1", // 金
	0x91d2: "\xa7\x00\u91d2", // 釒
	0x91d3: "\xa7\x01\u91d3", // 釓
	0x91d4: "\xa7\x01\u91d4", // 釔
	0x91d5: "\xa7\x02\u91d5", // 釕
	0x91d6: "\xa7\x02\u91d6", // 釖
	0x91d7: "\xa7\x02\u91d7", // 釗
	0x91d8: "\xa7\x02\u91d8", // 釘
	0x91d9: "\xa7\x02\u91d9", // 釙
	0x91da: "\xa7\x02\u91da", // 釚
	0x91db: "\xa7\x02\u91db", // 釛
	0x91dc: "\xa7\x02\u91dc", // 釜
	0x91dd: "\xa7\x02\u91dd", // 針
	0x91de: "\xa7\x02\u91de", // 釞
	0x91df: "\xa7\x02\u91df", // 釟
	0x91e0: "\xa7\x02\u91e0", // 釠
	0x91e1: "\xa7\x02\u91e1", // 釡
	0x91e2: "\xa7\x02\u91e2", // 釢
	0x91e3: "\xa7\x03\u91e3", // 釣
	0x91e4: "\xa7\x03\u91e4", // 釤
	0x91e5: "\xa7\x03\u91e5", // 釥
	0x91e6: "\xa7\x03\u91e6", // 釦
	0x91e7: "\xa7\x03\u91e7", // 釧
	0x91e8: "\xa7\x03\u91e8", // 釨
	0x91e9: "\xa7\x03\u91e9", // 釩
	0x91ea: "\xa7\x03\u91ea", // 釪
	0x91eb: "\xa7\x03\u91eb", // 釫
	0x91ec: "\xa7\x03\u91ec", // 釬
	0x91ed: "\xa7\x03\u91ed", // 釭
	0x91ee: "\xa7\x03\u91ee", // 釮
	0x91ef: "\xa7\x03\u91ef", // 釯
	0x91f0: "\xa7\x03\u91f0", // 釰
	0x91f1: "\xa7\x03\u91f1", // 釱
	0x91f2: "\xa7\x03\u91f2", // 釲
	0x91f3: "\xa7\x03\u91f3", // 釳
	0x91f4: "\xa7\x03\u91f4", // 釴
	0x91f5: "\xa7\x03\u91f5", // 釵
	0x91f6: "\xa7\x03\u91f6", // 釶
	0x91f7: "\xa7\x03\u91f7", // 釷
	0x91f8: "\xa7\x03\u91f8", // 釸
	0x91f9: "\xa7\x03\u91f9", // 釹
	0x91fa: "\xa7\x03\u91fa", // 釺
	0x91fb: "\xa7\x03\u91fb", // 釻
	0x91fc: "\xa7\x03\u91fc", // 釼
	0x91fd: "\xa7\x04\u91fd", // 釽
	0x91fe: "\xa7\x04\u91fe", // 釾
	0x91ff: "\xa7\x04\u91ff", // 釿
	0x9200: "\xa7\x04\u9200", // 鈀
	0x9201: "\xa7\x04\u9201", // 鈁
	0x9202: "\xa7\x04\u9202", // 鈂
	0x9203: "\xa7\x04\u9203", // 鈃
	0x9204: "\xa7\x04\u9204", // 鈄
	0x9205: "\xa7\x04\u9205", // 鈅
	0x9206: "\xa7\x04\u9206", // 鈆
	0x9207: "\xa7\x04\u9207", // 鈇
	0x9208: "\xa7\x04\u9208", // 鈈
	0x9209: "\xa7\x04\u9209", // 鈉
	0x920a: "\xa7\x04\u920a", // 鈊
	0x920b: "\xa7\x04\u920b", // 鈋
	0x920c: "\xa7\x04\u920c", // 鈌
	0x920d: "\xa7\x04\u920d", // 鈍
	0x920e: "\xa7\x04\u920e", // 鈎
	0x920f: "\xa7\x04\u920f", // 鈏
	0x9210: "\xa7\x04\u9210", // 鈐
	0x9211: "\xa7\x04\u9211", // 鈑
	0x9212: "\xa7\x04\u9212", // 鈒
	0x9213: "\xa7\x04\u9213", // 鈓
	0x9214: "\xa7\x04\u9214", // 鈔
	0x9215: "\xa7\x04\u9215", // 鈕
	0x9216: "\xa7\x04\u9216", // 鈖
	0x9217: "\xa7\x04\u9217", // 鈗
	0x9218: "\xa7\x04\u9218", // 鈘
	0x9219: "\xa7\x04\u9219", // 鈙
	0x921a: "\xa7\x04\u921a", // 鈚
	0x921b: "\xa7\x04\u921b", // 鈛
	0x921c: "\xa7\x04\u921c", // 鈜
	0x921d: "\xa7\x04\u921d", // 鈝
	0x921e: "\xa7\x04\u921e", // 鈞
	0x921f: "\xa7\x04\u921f", // 鈟
	0x9220: "\xa7\x04\u9220", // 鈠
	0x9221: "\xa7\x04\u9221", // 鈡
	0x9222: "\xa7\x04\u9222", // 鈢
	0x9223: "\xa7\x04\u9223", // 鈣
	0x9224: "\xa7\x04\u9224", // 鈤
	0x9225: "\xa7\x04\u9225", // 鈥
	0x9226: "\xa7\x04\u9226", // 鈦
	0x9227: "\xa7\x04\u9227", // 鈧
	0x9228: "\xa7\x04\u9228", // 鈨
	0x9229: "\xa7\x04\u9229", // 鈩
	0x922a: "\xa7\x04\u922a", // 鈪
	0x922b: "\xa7\x04\u922b", // 鈫
	0x922c: "\xa7\x04\u922c", // 鈬
	0x922d: "\xa7\x05\u922d", // 鈭
	0x922e: "\xa7\x05\u922e", // 鈮
	0x922f: "\xa7\x05\u922f", // 鈯
	0x9230: "\xa7\x05\u9230", // 鈰
	0x9231: "\xa7\x05\u9231", // 鈱
	0x9232: "\xa7\x05\u9232", // 鈲
	0x9233: "\xa7\x05\u9233", // 鈳
	0x9234: "\xa7\x05\u9234", // 鈴
	0x9235: "\xa7\x05\u9235", // 鈵
	0x9236: "\xa7\x05\u9236", // 鈶
	0x9237: "\xa7\x05\u9237", // 鈷
	0x9238: "\xa7\x05\u9238", // 鈸
	0x9239: "\xa7\x05\u9239", // 鈹
	0x923a: "\xa7\x05\u923a", // 鈺
	0x923b: "\xa7\x05\u923b", // 鈻
	0x923c: "\xa7\x05\u923c", // 鈼
	0x923d: "\xa7\x05\u923d", // 鈽
	0x923e: "\xa7\x05\u923e", // 鈾
	0x923f: "\xa7\x05\u923f", // 鈿
	0x9240: "\xa7\x05\u9240", // 鉀
	0x9241: "\xa7\x05\u9241", // 鉁
	0x9242: "\xa7\x05\u9242", // 鉂
	0x9243: "\xa7\x05\u9243", // 鉃
	0x9244: "\xa7\x05\u9244", // 鉄
	0x9245: "\xa7\x05\u9245", // 鉅
	0x9246: "\xa7\x05\u9246", // 鉆
	0x9247: "\xa7\x05\u9247", // 鉇
	0x9248: "\xa7\x05\u9248", // 鉈
	0x9249: "\xa7\x05\u9249", // 鉉
	0x924a: "\xa7\x05\u924a", // 鉊
	0x924b: "\xa7\x05\u924b", // 鉋
	0x924c: "\xa7\x05\u924c", // 鉌
	0x924d: "\xa7\x05\u924d", // 鉍
	0x924e: "\xa7\x05\u924e", // 鉎
	0x924f: "\xa7\x05\u924f", // 鉏
	0x9250: "\xa7\x05\u9250", // 鉐
	0x9251: "\xa7\x05\u9251", // 鉑
	0x9252: "\xa7\x05\u9252", // 鉒
	0x9253: "\xa7\x05\u9253", // 鉓
	0x9254: "\xa7\x05\u9254", // 鉔
	0x9255: "\xa7\x05\u9255", // 鉕
	0x9256: "\xa7\x05\u9256", // 鉖
	0x9257: "\xa7\x05\u9257", // 鉗
	0x9258: "\xa7\x05\u9258", // 鉘
	0x9259: "\xa7\x05\u9259", // 鉙
	0x925a: "\xa7\x05\u925a", // 鉚
	0x925b: "\xa7\x05\u925b", // 鉛
	0x925c: "\xa7\x05\u925c", // 鉜
	0x925d: "\xa7\x05\u925d", // 鉝
	0x925e: "\xa7\x05\u925e", // 鉞
	0x925f: "\xa7\x05\u925f", // 鉟
	0x9260: "\xa7\x05\u9260", // 鉠
	0x9261: "\xa7\x05\u9261", // 鉡
	0x9262: "\xa7\x05\u9262", // 鉢
	0x9263: "\xa7\x05\u9263", // 鉣
	0x9264: "\xa7\x05\u9264", // 鉤
	0x9265: "\xa7\x05\u9265", // 鉥
	0x9266: "\xa7\x05\u9266", // 鉦
	0x9267: "\xa7\x05\u9267", // 鉧
	0x9268: "\xa7\x05\u9268", // 鉨
	0x9269: "\xa7\x05\u9269", // 鉩
	0x926a: "\xa7\x05\u926a", // 鉪
	0x926b: "\xa7\x05\u926b", // 鉫
	0x926c: "\xa7\x05\u926c", // 鉬
	0x926d: "\xa7\x05\u926d", // 鉭
	0x926e: "\xa7\x05\u926e", // 鉮
	0x926f: "\xa7\x05\u926f", // 鉯
	0x9270: "\xa7\x05\u9270", // 鉰
	0x9271: "\xa7\x05\u9271", // 鉱
	0x9272: "\xa7\x05\u9272", // 鉲
	0x9273: "\xa7\x05\u9273", // 鉳
	0x9274: "\xa7\x05\u9274", // 鉴
	0x9275: "\xa7\x06\u9275", // 鉵
	0x9276: "\xa7\x06\u9276", // 鉶
	0x9277: "\xa7\x06\u9277", // 鉷
	0x9278: "\xa7\x06\u9278", // 鉸
	0x9279: "\xa7\x06\u9279", // 鉹
	0x927a: "\xa7\x06\u927a", // 鉺
	0x927b: "\xa7\x06\u927b", // 鉻
	0x927c: "\xa7\b\u927c", // 鉼
	0x927d: "\xa7\x06\u927d", // 鉽
	0x927e: "\xa7\x06\u927e", // 鉾
	0x927f: "\xa7\x06\u927f", // 鉿
	0x9280: "\xa7\x06\u9280", // 銀
	0x9281: "\xa7\x06\u9281", // 銁
	0x9282: "\xa7\x06\u9282", // 銂
	0x9283: "\xa7\x06\u9283", // 銃
	0x9284: "\xa7\x06\u9284", // 銄
	0x9285: "\xa7\x06\u9285", // 銅
	0x9286: "\xa7\x06\u9286", // 銆
	0x9287: "\xa7\x06\u9287", // 銇
	0x9288: "\xa7\x06\u9288", // 銈
	0x9289: "\xa7\x06\u9289", // 銉
	0x928a: "\xa7\x06\u928a", // 銊
	0x928b: "\xa7\x06\u928b", // 銋
	0x928c: "\xa7\x06\u928c", // 銌
	0x928d: "\xa7\x06\u928d", // 銍
	0x928e: "\xa7\x06\u928e", // 銎
	0x928f: "\xa7\x05\u928f", // 銏
	0x9290: "\xa7\x06\u9290", // 銐
	0x9291: "\xa7\x06\u9291", // 銑
	0x9292: "\xa7\x06\u9292", // 銒
	0x9293: "\xa7\x06\u9293", // 銓
	0x9294: "\xa7\x06\u9294", // 銔
	0x9295: "\xa7\x06\u9295", // 銕
	0x9296: "\xa7\x06\u9296", // 銖
	0x9297: "\xa7\x06\u9297", // 銗
	0x9298: "\xa7\x06\u9298", // 銘
	0x9299: "\xa7\x06\u9299", // 銙
	0x929a: "\xa7\x06\u929a", // 銚
	0x929b: "\xa7\x06\u929b", // 銛
	0x929c: "\xa7\x06\u929c", // 銜
	0x929d: "\xa7\x06\u929d", // 銝
	0x929e: "\xa7\x06\u929e", // 銞
	0x929f: "\xa7\x06\u929f", // 銟
	0x92a0: "\xa7\x06\u92a0", // 銠
	0x92a1: "\xa7\x06\u92a1", // 銡
	0x92a2: "\xa7\x06\u92a2", // 銢
	0x92a3: "\xa7\x06\u92a3", // 銣
	0x92a4: "\xa7\x06\u92a4", // 銤
	0x92a5: "\xa7\x06\u92a5", // 銥
	0x92a6: "\xa7\x06\u92a6", // 銦
	0x92a7: "\xa7\x06\u92a7", // 銧
	0x92a8: "\xa7\x06\u92a8", // 銨
	0x92a9: "\xa7\x06\u92a9", // 銩
	0x92aa: "\xa7\x06\u92aa", // 銪
	0x92ab: "\xa7\x06\u92ab", // 銫
	0x92ac: "\xa7\x06\u92ac", // 銬
	0x92ad: "\xa7\x06\u92ad", // 銭
	0x92ae: "\xa7\x06\u92ae", // 銮
	0x92af: "\xa7\x06\u92af", // 銯
	0x92b0: "\xa7\x06\u92b0", // 銰
	0x92b1: "\xa7\x06\u92b1", // 銱
	0x92b2: "\xa7\a\u92b2", // 銲
	0x92b3: "\xa7\a\u92b3", // 銳
	0x92b4: "\xa7\a\u92b4", // 銴
	0x92b5: "\xa7\a\u92b5", // 銵
	0x92b6: "\xa7\a\u92b6", // 銶
	0x92b7: "\xa7\a\u92b7", // 銷
	0x92b8: "\xa7\a\u92b8", // 銸
	0x92b9: "\xa7\a\u92b9", // 銹
	0x92ba: "\xa7\a\u92ba", // 銺
	0x92bb: "\xa7\a\u92bb", // 銻
	0x92bc: "\xa7\a\u92bc", // 銼
	0x92bd: "\xa7\a\u92bd", // 銽
	0x92be: "\xa7\a\u92be", // 銾
	0x92bf: "\xa7\a\u92bf", // 銿
	0x92c0: "\xa7\a\u92c0", // 鋀
	0x92c1: "\xa7\a\u92c1", // 鋁
	0x92c2: "\xa7\a\u92c2", // 鋂
	0x92c3: "\xa7\a\u92c3", // 鋃
	0x92c4: "\xa7\a\u92c4", // 鋄
	0x92c5: "\xa7\a\u92c5", // 鋅
	0x92c6: "\xa7\a\u92c6", // 鋆
	0x92c7: "\xa7\a\u92c7", // 鋇
	0x92c8: "\xa7\a\u92c8", // 鋈
	0x92c9: "\xa7\a\u92c9", // 鋉
	0x92ca: "\xa7\a\u92ca", // 鋊
	0x92cb: "\xa7\a\u92cb", // 鋋
	0x92cc: "\xa7\a\u92cc", // 鋌
	0x92cd: "\xa7\a\u92cd", // 鋍
	0x92ce: "\xa7\a\u92ce", // 鋎
	0x92cf: "\xa7\a\u92cf", // 鋏
	0x92d0: "\xa7\a\u92d0", // 鋐
	0x92d1: "\xa7\a\u92d1", // 鋑
	0x92d2: "\xa7\a\u92d2", // 鋒
	0x92d3: "\xa7\a\u92d3", // 鋓
	0x92d4: "\xa7\a\u92d4", // 鋔
	0x92d5: "\xa7\a\u92d5", // 鋕
	0x92d6: "\xa7\a\u92d6", // 鋖
	0x92d7: "\xa7\a\u92d7", // 鋗
	0x92d8: "\xa7\a\u92d8", // 鋘
	0x92d9: "\xa7\a\u92d9", // 鋙
	0x92da: "\xa7\a\u92da", // 鋚
	0x92db: "\xa7\a\u92db", // 鋛
	0x92dc: "\xa7\a\u92dc", // 鋜
	0x92dd: "\xa7\a\u92dd", // 鋝
	0x92de: "\xa7\a\u92de", // 鋞
	0x92df: "\xa7\a\u92df", // 鋟
	0x92e0: "\xa7\a\u92e0", // 鋠
	0x92e1: "\xa7\a\u92e1", // 鋡
	0x92e2: "\xa7\a\u92e2", // 鋢
	0x92e3: "\xa7\a\u92e3", // 鋣
	0x92e4: "\xa7\a\u92e4", // 鋤
	0x92e5: "\xa7\a\u92e5", // 鋥
	0x92e6: "\xa7\a\u92e6", // 鋦
	0x92e7: "\xa7\a\u92e7", // 鋧
	0x92e8: "\xa7\a\u92e8", // 鋨
	0x92e9: "\xa7\a\u92e9", // 鋩
	0x92ea: "\xa7\a\u92ea", // 鋪
	0x92eb: "\xa7\a\u92eb", // 鋫
	0x92ec: "\xa7\a\u92ec", // 鋬
	0x92ed: "\xa7\a\u92ed", // 鋭
	0x92ee: "\xa7\a\u92ee", // 鋮
	0x92ef: "\xa7\a\u92ef", // 鋯
	0x92f0: "\xa7\a\u92f0", // 鋰
	0x92f1: "\xa7\a\u92f1", // 鋱
	0x92f2: "\xa7\a\u92f2", // 鋲
	0x92f3: "\xa7\a\u92f3", // 鋳
	0x92f4: "\xa7\a\u92f4", // 鋴
	0x92f5: "\xa7\a\u92f5", // 鋵
	0x92f6: "\xa7\a\u92f6", // 鋶
	0x92f7: "\xa7\b\u92f7", // 鋷
	0x92f8: "\xa7\b\u92f8", // 鋸
	0x92f9: "\xa7\b\u92f9", // 鋹
	0x92fa: "\xa7\b\u92fa", // 鋺
	0x92fb: "\xa7\b\u92fb", // 鋻
	0x92fc: "\xa7\b\u92fc", // 鋼
	0x92fd: "\xa7\b\u92fd", // 鋽
	0x92fe: "\xa7\b\u92fe", // 鋾
	0x92ff: "\xa7\b\u92ff", // 鋿
	0x9300: "\xa7\b\u9300", // 錀
	0x9301: "\xa7\b\u9301", // 錁
	0x9302: "\xa7\b\u9302", // 錂
	0x9303: "\xa7\b\u9303", // 錃
	0x9304: "\xa7\b\u9304", // 錄
	0x9305: "\xa7\b\u9305", // 錅
	0x9306: "\xa7\b\u9306", // 錆
	0x9307: "\xa7\b\u9307", // 錇
	0x9308: "\xa7\b\u9308", // 錈
	0x9309: "\xa7\b\u9309", // 錉
	0x930a: "\xa7\b\u930a", // 錊
	0x930b: "\xa7\b\u930b", // 錋
	0x930c: "\xa7\b\u930c", // 錌
	0x930d: "\xa7\b\u930d", // 錍
	0x930e: "\xa7\b\u930e", // 錎
	0x930f: "\xa7\b\u930f", // 錏
	0x9310: "\xa7\b\u9310", // 錐
	0x9311: "\xa7\b\u9311", // 錑
	0x9312: "\xa7\b\u9312", // 錒
	0x9313: "\xa7\b\u9313", // 錓
	0x9314: "\xa7\b\u9314", // 錔
	0x9315: "\xa7\b\u9315", // 錕
	0x9316: "\xa7\b\u9316", // 錖
	0x9317: "\xa7\b\u9317", // 錗
	0x9318: "\xa7\b\u9318", // 錘
	0x9319: "\xa7\b\u9319", // 錙
	0x931a: "\xa7\b\u931a", // 錚
	0x931b: "\xa7\b\u931b", // 錛
	0x931c: "\xa7\b\u931c", // 錜
	0x931d: "\xa7\b\u931d", // 錝
	0x931e: "\xa7\b\u931e", // 錞
	0x931f: "\xa7\b\u931f", // 錟
	0x9320: "\xa7\b\u9320", // 錠
	0x9321: "\xa7\b\u9321", // 錡
	0x9322: "\xa7\b\u9322", // 錢
	0x9323: "\xa7\b\u9323", // 錣
	0x9324: "\xa7\b\u9324", // 錤
	0x9325: "\xa7\b\u9325", // 錥
	0x9326: "\xa7\b\u9326", // 錦
	0x9327: "\xa7\b\u9327", // 錧
	0x9328: "\xa7\t\u9328", // 錨
	0x9329: "\xa7\b\u9329", // 錩
	0x932a: "\xa7\b\u932a", // 錪
	0x932b: "\xa7\b\u932b", // 錫
	0x932c: "\xa7\b\u932c", // 錬
	0x932d: "\xa7\b\u932d", // 錭
	0x932e: "\xa7\b\u932e", // 錮
	0x932f: "\xa7\b\u932f", // 錯
	0x9330: "\xa7\b\u9330", // 錰
	0x9331: "\xa7\b\u9331", // 錱
	0x9332: "\xa7\b\u9332", // 録
	0x9333: "\xa7\b\u9333", // 錳
	0x9334: "\xa7\b\u9334", // 錴
	0x9335: "\xa7\b\u9335", // 錵
	0x9336: "\xa7\b\u9336", // 錶
	0x9337: "\xa7\b\u9337", // 錷
	0x9338: "\xa7\b\u9338", // 錸
	0x9339: "\xa7\b\u9339", // 錹
	0x933a: "\xa7\b\u933a", // 錺
	0x933b: "\xa7\b\u933b", // 錻
	0x933c: "\xa7\b\u933c", // 錼
	0x933d: "\xa7\b\u933d", // 錽
	0x933e: "\xa7\b\u933e", // 錾
	0x933f: "\xa7\b\u933f", // 錿
	0x9340: "\xa7\b\u9340", // 鍀
	0x9341: "\xa7\b\u9341", // 鍁
	0x9342: "\xa7\b\u9342", // 鍂
	0x9343: "\xa7\b\u9343", // 鍃
	0x9344: "\xa7\b\u9344", // 鍄
	0x9345: "\xa7\b\u9345", // 鍅
	0x9346: "\xa7\b\u9346", // 鍆
	0x9347: "\xa7\t\u9347", // 鍇
	0x9348: "\xa7\b\u9348", // 鍈
	0x9349: "\xa7\t\u9349", // 鍉
	0x934a: "\xa7\t\u934a", // 鍊
	0x934b: "\xa7\t\u934b", // 鍋
	0x934c: "\xa7\t\u934c", // 鍌
	0x934d: "\xa7\t\u934d", // 鍍
	0x934e: "\xa7\t\u934e", // 鍎
	0x934f: "\xa7\t\u934f", // 鍏
	0x9350: "\xa7\t\u9350", // 鍐
	0x9351: "\xa7\t\u9351", // 鍑
	0x9352: "\xa7\t\u9352", // 鍒
	0x9353: "\xa7\t\u9353", // 鍓
	0x9354: "\xa7\t\u9354", // 鍔
	0x9355: "\xa7\t\u9355", // 鍕
	0x9356: "\xa7\t\u9356", // 鍖
	0x9357: "\xa7\t\u9357", // 鍗
	0x9358: "\xa7\t\u9358", // 鍘
	0x9359: "\xa7\t\u9359", // 鍙
	0x935a: "\xa7\t\u935a", // 鍚
	0x935b: "\xa7\t\u935b", // 鍛
	0x935c: "\xa7\t\u935c", // 鍜
	0x935d: "\xa7\t\u935d", // 鍝
	0x935e: "\xa7\t\u935e", // 鍞
	0x935f: "\xa7\t\u935f", // 鍟
	0x9360: "\xa7\t\u9360", // 鍠
	0x9361: "\xa7\t\u9361", // 鍡
	0x9362: "\xa7\t\u9362", // 鍢
	0x9363: "\xa7\t\u9363", // 鍣
	0x9364: "\xa7\t\u9364", // 鍤
	0x9365: "\xa7\t\u9365", // 鍥
	0x9366: "\xa7\t\u9366", // 鍦
	0x9367: "\xa7\t\u9367", // 鍧
	0x9368: "\xa7\t\u9368", // 鍨
	0x9369: "\xa7\t\u9369", // 鍩
	0x936a: "\xa7\t\u936a", // 鍪
	0x936b: "\xa7\t\u936b", // 鍫
	0x936c: "\xa7\t\u936c", // 鍬
	0x936d: "\xa7\t\u936d", // 鍭
	0x936e: "\xa7\t\u936e", // 鍮
	0x936f: "\xa7\t\u936f", // 鍯
	0x9370: "\xa7\t\u9370", // 鍰
	0x9371: "\xa7\t\u9371", // 鍱
	0x9372: "\xa7\t\u9372", // 鍲
	0x9373: "\xa7\t\u9373", // 鍳
	0x9374: "\xa7\t\u9374", // 鍴
	0x9375: "\xa7\t\u9375", // 鍵
	0x9376: "\xa7\t\u9376", // 鍶
	0x9377: "\xa7\t\u9377", // 鍷
	0x9378: "\xa7\t\u9378", // 鍸
	0x9379: "\xa7\t\u9379", // 鍹
	0x937a: "\xa7\t\u937a", // 鍺
	0x937b: "\xa7\t\u937b", // 鍻
	0x937c: "\xa7\t\u937c", // 鍼
	0x937d: "\xa7\t\u937d", // 鍽
	0x937e: "\xa7\t\u937e", // 鍾
	0x937f: "\xa7\t\u937f", // 鍿
	0x9380: "\xa7\t\u9380", // 鎀
	0x9381: "\xa7\t\u9381", // 鎁
	0x9382: "\xa7\t\u9382", // 鎂
	0x9383: "\xa7\t\u9383", // 鎃
	0x9384: "\xa7\t\u9384", // 鎄
	0x9385: "\xa7\t\u9385", // 鎅
	0x9386: "\xa7\t\u9386", // 鎆
	0x9387: "\xa7\t\u9387", // 鎇
	0x9388: "\xa7\n\u9388", // 鎈
	0x9389: "\xa7\n\u9389", // 鎉
	0x938a: "\xa7\n\u938a", // 鎊
	0x938b: "\xa7\n\u938b", // 鎋
	0x938c: "\xa7\n\u938c", // 鎌
	0x938d: "\xa7\n\u938d", // 鎍
	0x938e: "\xa7\n\u938e", // 鎎
	0x938f: "\xa7\n\u938f", // 鎏
	0x9390: "\xa7\n\u9390", // 鎐
	0x9391: "\xa7\n\u9391", // 鎑
	0x9392: "\xa7\n\u9392", // 鎒
	0x9393: "\xa7\n\u9393", // 鎓
	0x9394: "\xa7\n\u9394", // 鎔
	0x9395: "\xa7\n\u9395", // 鎕
	0x9396: "\xa7\n\u9396", // 鎖
	0x9397: "\xa7\n\u9397", // 鎗
	0x9398: "\xa7\n\u9398", // 鎘
	0x9399: "\xa7\n\u9399", // 鎙
	0x939a: "\xa7\n\u939a", // 鎚
	0x939b: "\xa7\n\u939b", // 鎛
	0x939c: "\xa7\n\u939c", // 鎜
	0x939d: "\xa7\n\u939d", // 鎝
	0x939e: "\xa7\n\u939e", // 鎞
	0x939f: "\xa7\n\u939f", // 鎟
	0x93a0: "\xa7\n\u93a0", // 鎠
	0x93a1: "\xa7\n\u93a1", // 鎡
	0x93a2: "\xa7\n\u93a2", // 鎢
	0x93a3: "\xa7\n\u93a3", // 鎣
	0x93a4: "\xa7\n\u93a4", // 鎤
	0x93a5: "\xa7\n\u93a5", // 鎥
	0x93a6: "\xa7\n\u93a6", // 鎦
	0x93a7: "\xa7\n\u93a7", // 鎧
	0x93a8: "\xa7\n\u93a8", // 鎨
	0x93a9: "\xa7\v\u93a9", // 鎩
	0x93aa: "\xa7\n\u93aa", // 鎪
	0x93ab: "\xa7\n\u93ab", // 鎫
	0x93ac: "\xa7\n\u93ac", // 鎬
	0x93ad: "\xa7\n\u93ad", // 鎭
	0x93ae: "\xa7\n\u93ae", // 鎮
	0x93af: "\xa7\n\u93af", // 鎯
	0x93b0: "\xa7\n\u93b0", // 鎰
	0x93b1: "\xa7\n\u93b1", // 鎱
	0x93b2: "\xa7\n\u93b2", // 鎲
	0x93b3: "\xa7\n\u93b3", // 鎳
	0x93b4: "\xa7\n\u93b4", // 鎴
	0x93b5: "\xa7\n\u93b5", // 鎵
	0x93b6: "\xa7\n\u93b6", // 鎶
	0x93b7: "\xa7\n\u93b7", // 鎷
	0x93b8: "\xa7\n\u93b8", // 鎸
	0x93b9: "\xa7\n\u93b9", // 鎹
	0x93ba: "\xa7\n\u93ba", // 鎺
	0x93bb: "\xa7\n\u93bb", // 鎻
	0x93bc: "\xa7\n\u93bc", // 鎼
	0x93bd: "\xa7\n\u93bd", // 鎽
	0x93be: "\xa7\n\u93be", // 鎾
	0x93bf: "\xa7\n\u93bf", // 鎿
	0x93c0: "\xa7\v\u93c0", // 鏀
	0x93c1: "\xa7\v\u93c1", // 鏁
	0x93c2: "\xa7\v\u93c2", // 鏂
	0x93c3: "\xa7\v\u93c3", // 鏃
	0x93c4: "\xa7\v\u93c4", // 鏄
	0x93c5: "\xa7\v\u93c5", // 鏅
	0x93c6: "\xa7\v\u93c6", // 鏆
	0x93c7: "\xa7\v\u93c7", // 鏇
	0x93c8: "\xa7\v\u93c8", // 鏈
	0x93c9: "\xa7\v\u93c9", // 鏉
	0x93ca: "\xa7\v\u93ca", // 鏊
	0x93cb: "\xa7\v\u93cb", // 鏋
	0x93cc: "\xa7\v\u93cc", // 鏌
	0x93cd: "\xa7\v\u93cd", // 鏍
	0x93ce: "\xa7\v\u93ce", // 鏎
	0x93cf: "\xa7\v\u93cf", // 鏏
	0x93d0: "\xa7\v\u93d0", // 鏐
	0x93d1: "\xa7\v\u93d1", // 鏑
	0x93d2: "\xa7\v\u93d2", // 鏒
	0x93d3: "\xa7\v\u93d3", // 鏓
	0x93d4: "\xa7\v\u93d4", // 鏔
	0x93d5: "\xa7\v\u93d5", // 鏕
	0x93d6: "\xa7\v\u93d6", // 鏖
	0x93d7: "\xa7\v\u93d7", // 鏗
	0x93d8: "\xa7\v\u93d8", // 鏘
	0x93d9: "\xa7\v\u93d9", // 鏙
	0x93da: "\xa7\v\u93da", // 鏚
	0x93db: "\xa7\v\u93db", // 鏛
	0x93dc: "\xa7\v\u93dc", // 鏜
	0x93dd: "\xa7\v\u93dd", // 鏝
	0x93de: "\xa7\v\u93de", // 鏞
	0x93df: "\xa7\v\u93df", // 鏟
	0x93e0: "\xa7\v\u93e0", // 鏠
	0x93e1: "\xa7\v\u93e1", // 鏡
	0x93e2: "\xa7\v\u93e2", // 鏢
	0x93e3: "\xa7\v\u93e3", // 鏣
	0x93e4: "\xa7\v\u93e4", // 鏤
	0x93e5: "\xa7\v\u93e5", // 鏥
	0x93e6: "\xa7\v\u93e6", // 鏦
	0x93e7: "\xa7\v\u93e7", // 鏧
	0x93e8: "\xa7\v\u93e8", // 鏨
	0x93e9: "\xa7\v\u93e9", // 鏩
	0x93ea: "\xa7\v\u93ea", // 鏪
	0x93eb: "\xa7\v\u93eb", // 鏫
	0x93ec: "\xa7\v\u93ec", // 鏬
	0x93ed: "\xa7\v\u93ed", // 鏭
	0x93ee: "\xa7\v\u93ee", // 鏮
	0x93ef: "\xa7\v\u93ef", // 鏯
	0x93f0: "\xa7\v\u93f0", // 鏰
	0x93f1: "\xa7\v\u93f1", // 鏱
	0x93f2: "\xa7\v\u93f2", // 鏲
	0x93f3: "\xa7\f\u93f3", // 鏳
	0x93f4: "\xa7\r\u93f4", // 鏴
	0x93f5: "\xa7\f\u93f5", // 鏵
	0x93f6: "\xa7\f\u93f6", // 鏶
	0x93f7: "\xa7\f\u93f7", // 鏷
	0x93f8: "\xa7\f\u93f8", // 鏸
	0x93f9: "\xa7\v\u93f9", // 鏹
	0x93fa: "\xa7\f\u93fa", // 鏺
	0x93fb: "\xa7\f\u93fb", // 鏻
	0x93fc: "\xa7\f\u93fc", // 鏼
	0x93fd: "\xa7\f\u93fd", // 鏽
	0x93fe: "\xa7\f\u93fe", // 鏾
	0x93ff: "\xa7\f\u93ff", // 鏿
	0x9400: "\xa7\f\u9400", // 鐀
	0x9401: "\xa7\f\u9401", // 鐁
	0x9402: "\xa7\f\u9402", // 鐂
	0x9403: "\xa7\f\u9403", // 鐃
	0x9404: "\xa7\f\u9404", // 鐄
	0x9405: "\xa7\f\u9405", // 鐅
	0x9406: "\xa7\f\u9406", // 鐆
	0x9407: "\xa7\f\u9407", // 鐇
	0x9408: "\xa7\f\u9408", // 鐈
	0x9409: "\xa7\f\u9409", // 鐉
	0x940a: "\xa7\f\u940a", // 鐊
	0x940b: "\xa7\f\u940b", // 鐋
	0x940c: "\xa7\f\u940c", // 鐌
	0x940d: "\xa7\f\u940d", // 鐍
	0x940e: "\xa7\f\u940e", // 鐎
	0x940f: "\xa7\f\u940f", // 鐏
	0x9410: "\xa7\f\u9410", // 鐐
	0x9411: "\xa7\f\u9411", // 鐑
	0x9412: "\xa7\f\u9412", // 鐒
	0x9413: "\xa7\f\u9413", // 鐓
	0x9414: "\xa7\f\u9414", // 鐔
	0x9415: "\xa7\f\u9415", // 鐕
	0x9416: "\xa7\f\u9416", // 鐖
	0x9417: "\xa7\f\u9417", // 鐗
	0x9418: "\xa7\f\u9418", // 鐘
	0x9419: "\xa7\f\u9419", // 鐙
	0x941a: "\xa7\f\u941a", // 鐚
	0x941b: "\xa7\f\u941b", // 鐛
	0x941c: "\xa7\f\u941c", // 鐜
	0x941d: "\xa7\f\u941d", // 鐝
	0x941e: "\xa7\f\u941e", // 鐞
	0x941f: "\xa7\f\u941f", // 鐟
	0x9420: "\xa7\f\u9420", // 鐠
	0x9421: "\xa7\f\u9421", // 鐡
	0x9422: "\xa7\f\u9422", // 鐢
	0x9423: "\xa7\f\u9423", // 鐣
	0x9424: "\xa7\f\u9424", // 鐤
	0x9425: "\xa7\f\u9425", // 鐥
	0x9426: "\xa7\f\u9426", // 鐦
	0x9427: "\xa7\f\u9427", // 鐧
	0x9428: "\xa7\f\u9428", // 鐨
	0x9429: "\xa7\r\u9429", // 鐩
	0x942a: "\xa7\r\u942a", // 鐪
	0x942b: "\xa7\r\u942b", // 鐫
	0x942c: "\xa7\r\u942c", // 鐬
	0x942d: "\xa7\r\u942d", // 鐭
	0x942e: "\xa7\r\u942e", // 鐮
	0x942f: "\xa7\r\u942f", // 鐯
	0x9430: "\xa7\r\u9430", // 鐰
	0x9431: "\xa7\r\u9431", // 鐱
	0x9432: "\xa7\r\u9432", // 鐲
	0x9433: "\xa7\r\u9433", // 鐳
	0x9434: "\xa7\r\u9434", // 鐴
	0x9435: "\xa7\r\u9435", // 鐵
	0x9436: "\xa7\r\u9436", // 鐶
	0x9437: "\xa7\r\u9437", // 鐷
	0x9438: "\xa7\r\u9438", // 鐸
	0x9439: "\xa7\r\u9439", // 鐹
	0x943a: "\xa7\r\u943a", // 鐺
	0x943b: "\xa7\r\u943b", // 鐻
	0x943c: "\xa7\r\u943c", // 鐼
	0x943d: "\xa7\r\u943d", // 鐽
	0x943e: "\xa7\r\u943e", // 鐾
	0x943f: "\xa7\r\u943f", // 鐿
	0x9440: "\xa7\r\u9440", // 鑀
	0x9441: "\xa7\r\u9441", // 鑁
	0x9442: "\xa7\x0e\u9442", // 鑂
	0x9443: "\xa7\x0e\u9443", // 鑃
	0x9444: "\xa7\x0e\u9444", // 鑄
	0x9445: "\xa7\x0e\u9445", // 鑅
	0x9446: "\xa7\x0e\u9446", // 鑆
	0x9447: "\xa7\x0e\u9447", // 鑇
	0x9448: "\xa7\x0e\u9448", // 鑈
	0x9449: "\xa7\x0e\u9449", // 鑉
	0x944a: "\xa7\x0e\u944a", // 鑊
	0x944b: "\xa7\x0e\u944b", // 鑋
	0x944c: "\xa7\x0e\u944c", // 鑌
	0x944d: "\xa7\x0e\u944d", // 鑍
	0x944e: "\xa7\x0e\u944e", // 鑎
	0x944f: "\xa7\x0e\u944f", // 鑏
	0x9450: "\xa7\x0e\u9450", // 鑐
	0x9451: "\xa7\x0e\u9451", // 鑑
	0x9452: "\xa7\x0e\u9452", // 鑒
	0x9453: "\xa7\x0e\u9453", // 鑓
	0x9454: "\xa7\x0e\u9454", // 鑔
	0x9455: "\xa7\x0f\u9455", // 鑕
	0x9456: "\xa7\x0f\u9456", // 鑖
	0x9457: "\xa7\x0f\u9457", // 鑗
	0x9458: "\xa7\x0f\u9458", // 鑘
	0x9459: "\xa7\x0f\u9459", // 鑙
	0x945a: "\xa7\x0f\u945a", // 鑚
	0x945b: "\xa7\x0f\u945b", // 鑛
	0x945c: "\xa7\x0f\u945c", // 鑜
	0x945d: "\xa7\x0f\u945d", // 鑝
	0x945e: "\xa7\x0f\u945e", // 鑞
	0x945f: "\xa7\x0f\u945f", // 鑟
	0x9460: "\xa7\x0f\u9460", // 鑠
	0x9461: "\xa7\x0f\u9461", // 鑡
	0x9462: "\xa7\x0f\u9462", // 鑢
	0x9463: "\xa7\x0f\u9463", // 鑣
	0x9464: "\xa7\x0f\u9464", // 鑤
	0x9465: "\xa7\x0f\u9465", // 鑥
	0x9466: "\xa7\x0f\u9466", // 鑦
	0x9467: "\xa7\x0e\u9467", // 鑧
	0x9468: "\xa7\x10\u9468", // 鑨
	0x9469: "\xa7\x10\u9469", // 鑩
	0x946a: "\xa7\x10\u946a", // 鑪
	0x946b: "\xa7\x10\u946b", // 鑫
	0x946c: "\xa7\x10\u946c", // 鑬
	0x946d: "\xa7\x11\u946d", // 鑭
	0x946e: "\xa7\x11\u946e", // 鑮
	0x946f: "\xa7\x11\u946f", // 鑯
	0x9470: "\xa7\x11\u9470", // 鑰
	0x9471: "\xa7\x11\u9471", // 鑱
	0x9472: "\xa7\x11\u9472", // 鑲
	0x9473: "\xa7\x11\u9473", // 鑳
	0x9474: "\xa7\x12\u9474", // 鑴
	0x9475: "\xa7\x12\u9475", // 鑵
	0x9476: "\xa7\x12\u9476", // 鑶
	0x9477: "\xa7\x12\u9477", // 鑷
	0x9478: "\xa7\x12\u9478", // 鑸
	0x9479: "\xa7\x12\u9479", // 鑹
	0x947a: "\xa7\x12\u947a", // 鑺
	0x947b: "\xa7\x13\u947b", // 鑻
	0x947c: "\xa7\x13\u947c", // 鑼
	0x947d: "\xa7\x13\u947d", // 鑽
	0x947e: "\xa7\x13\u947e", // 鑾
	0x947f: "\xa7\x13\u947f", // 鑿
	0x9480: "\xa7\x14\u9480", // 钀
	0x9481: "\xa7\x14\u9481", // 钁
	0x9482: "\xa7\x14\u9482", // 钂
	0x9483: "\xa7\x15\u9483", // 钃
	0x9484: "\xa7\x15\u9484", // 钄
	0x9485: "\xa7\x00\u9485", // 钅
	0x9486: "\xa7\x01\u9486", // 钆
	0x9487: "\xa7\x01\u9487", // 钇
	0x9488: "\xa7\x02\u9488", // 针
	0x9489: "\xa7\x02\u9489", // 钉
	0x948a: "\xa7\x02\u948a", // 钊
	0x948b: "\xa7\x02\u948b", // 钋
	0x948c: "\xa7\x02\u948c", // 钌
	0x948d: "\xa7\x03\u948d", // 钍
	0x948e: "\xa7\x03\u948e", // 钎
	0x948f: "\xa7\x03\u948f", // 钏
	0x9490: "\xa7\x03\u9490", // 钐
	0x9491: "\xa7\x03\u9491", // 钑
	0x9492: "\xa7\x03\u9492", // 钒
	0x9493: "\xa7\x03\u9493", // 钓
	0x9494: "\xa7\x03\u9494", // 钔
	0x9495: "\xa7\x03\u9495", // 钕
	0x9496: "\xa7\x03\u9496", // 钖
	0x9497: "\xa7\x03\u9497", // 钗
	0x9498: "\xa7\x04\u9498", // 钘
	0x9499: "\xa7\x04\u9499", // 钙
	0x949a: "\xa7\x04\u949a", // 钚
	0x949b: "\xa7\x04\u949b", // 钛
	0x949c: "\xa7\x04\u949c", // 钜
	0x949d: "\xa7\x04\u949d", // 钝
	0x949e: "\xa7\x04\u949e", // 钞
	0x949f: "\xa7\x04\u949f", // 钟
	0x94a0: "\xa7\x04\u94a0", // 钠
	0x94a1: "\xa7\x04\u94a1", // 钡
	0x94a2: "\xa7\x04\u94a2", // 钢
	0x94a3: "\xa7\x04\u94a3", // 钣
	0x94a4: "\xa7\x04\u94a4", // 钤
	0x94a5: "\xa7\x04\u94a5", // 钥
	0x94a6: "\xa7\x04\u94a6", // 钦
	0x94a7: "\xa7\x04\u94a7", // 钧
	0x94a8: "\xa7\x04\u94a8", // 钨
	0x94a9: "\xa7\x04\u94a9", // 钩
	0x94aa: "\xa7\x04\u94aa", // 钪
	0x94ab: "\xa7\x04\u94ab", // 钫
	0x94ac: "\xa7\x04\u94ac", // 钬
	0x94ad: "\xa7\x04\u94ad", // 钭
	0x94ae: "\xa7\x04\u94ae", // 钮
	0x94af: "\xa7\x04\u94af", // 钯
	0x94b0: "\xa7\x05\u94b0", // 钰
	0x94b1: "\xa7\x05\u94b1", // 钱
	0x94b2: "\xa7\x05\u94b2", // 钲
	0x94b3: "\xa7\x05\u94b3", // 钳
	0x94b4: "\xa7\x05\u94b4", // 钴
	0x94b5: "\xa7\x05\u94b5", // 钵
	0x94b6: "\xa7\x05\u94b6", // 钶
	0x94b7: "\xa7\x05\u94b7", // 钷
	0x94b8: "\xa7\x05\u94b8", // 钸
	0x94b9: "\xa7\x05\u94b9", // 钹
	0x94ba: "\xa7\x05\u94ba", // 钺
	0x94bb: "\xa7\x05\u94bb", // 钻
	0x94bc: "\xa7\x05\u94bc", // 钼
	0x94bd: "\xa7\x05\u94bd", // 钽
	0x94be: "\xa7\x05\u94be", // 钾
	0x94bf: "\xa7\x05\u94bf", // 钿
	0x94c0: "\xa7\x05\u94c0", // 铀
	0x94c1: "\xa7\x05\u94c1", // 铁
	0x94c2: "\xa7\x05\u94c2", // 铂
	0x94c3: "\xa7\x05\u94c3", // 铃
	0x94c4: "\xa7\x05\u94c4", // 铄
	0x94c5: "\xa7\x05\u94c5", // 铅
	0x94c6: "\xa7\x05\u94c6", // 铆
	0x94c7: "\xa7\x05\u94c7", // 铇
	0x94c8: "\xa7\x05\u94c8", // 铈
	0x94c9: "\xa7\x05\u94c9", // 铉
	0x94ca: "\xa7\x05\u94ca", // 铊
	0x94cb: "\xa7\x05\u94cb", // 铋
	0x94cc: "\xa7\x05\u94cc", // 铌
	0x94cd: "\xa7\x05\u94cd", // 铍
	0x94ce: "\xa7\x05\u94ce", // 铎
	0x94cf: "\xa7\x06\u94cf", // 铏
	0x94d0: "\xa7\x06\u94d0", // 铐
	0x94d1: "\xa7\x06\u94d1", // 铑
	0x94d2: "\xa7\x06\u94d2", // 铒
	0x94d3: "\xa7\x06\u94d3", // 铓
	0x94d4: "\xa7\x06\u94d4", // 铔
	0x94d5: "\xa7\x06\u94d5", // 铕
	0x94d6: "\xa7\x06\u94d6", // 铖
	0x94d7: "\xa7\x06\u94d7", // 铗
	0x94d8: "\xa7\x06\u94d8", // 铘
	0x94d9: "\xa7\x06\u94d9", // 铙
	0x94da: "\xa7\x06\u94da", // 铚
	0x94db: "\xa7\x06\u94db", // 铛
	0x94dc: "\xa7\x06\u94dc", // 铜
	0x94dd: "\xa7\x06\u94dd", // 铝
	0x94de: "\xa7\x06\u94de", // 铞
	0x94df: "\xa7\x06\u94df", // 铟
	0x94e0: "\xa7\x06\u94e0", // 铠
	0x94e1: "\xa7\x06\u94e1", // 铡
	0x94e2: "\xa7\x06\u94e2", // 铢
	0x94e3: "\xa7\x06\u94e3", // 铣
	0x94e4: "\xa7\x06\u94e4", // 铤
	0x94e5: "\xa7\x06\u94e5", // 铥
	0x94e6: "\xa7\x06\u94e6", // 铦
	0x94e7: "\xa7\x06\u94e7", // 铧
	0x94e8: "\xa7\x06\u94e8", // 铨
	0x94e9: "\xa7\x06\u94e9", // 铩
	0x94ea: "\xa7\x06\u94ea", // 铪
	0x94eb: "\xa7\x06\u94eb", // 铫
	0x94ec: "\xa7\x06\u94ec", // 铬
	0x94ed: "\xa7\x06\u94ed", // 铭
	0x94ee: "\xa7\x06\u94ee", // 铮
	0x94ef: "\xa7\x06\u94ef", // 铯
	0x94f0: "\xa7\x06\u94f0", // 铰
	0x94f1: "\xa7\x06\u94f1", // 铱
	0x94f2: "\xa7\x06\u94f2", // 铲
	0x94f3: "\xa7\x06\u94f3", // 铳
	0x94f4: "\xa7\x06\u94f4", // 铴
	0x94f5: "\xa7\x06\u94f5", // 铵
	0x94f6: "\xa7\x06\u94f6", // 银
	0x94f7: "\xa7\x06\u94f7", // 铷
	0x94f8: "\xa7\a\u94f8", // 铸
	0x94f9: "\xa7\a\u94f9", // 铹
	0x94fa: "\xa7\a\u94fa", // 铺
	0x94fb: "\xa7\a\u94fb", // 铻
	0x94fc: "\xa7\a\u94fc", // 铼
	0x94fd: "\xa7\a\u94fd", // 铽
	0x94fe: "\xa7\a\u94fe", // 链
	0x94ff: "\xa7\a\u94ff", // 铿
	0x9500: "\xa7\a\u9500", // 销
	0x9501: "\xa7\a\u9501", // 锁
	0x9502: "\xa7\a\u9502", // 锂
	0x9503: "\xa7\a\u9503", // 锃
	0x9504: "\xa7\a\u9504", // 锄
	0x9505: "\xa7\a\u9505", // 锅
	0x9506: "\xa7\a\u9506", // 锆
	0x9507: "\xa7\a\u9507", // 锇
	0x9508: "\xa7\a\u9508", // 锈
	0x9509: "\xa7\a\u9509", // 锉
	0x950a: "\xa7\a\u950a", // 锊
	0x950b: "\xa7\a\u950b", // 锋
	0x950c: "\xa7\a\u950c", // 锌
	0x950d: "\xa7\a\u950d", // 锍
	0x950e: "\xa7\a\u950e", // 锎
	0x950f: "\xa7\a\u950f", // 锏
	0x9510: "\xa7\a\u9510", // 锐
	0x9511: "\xa7\a\u9511", // 锑
	0x9512: "\xa7\a\u9512", // 锒
	0x9513: "\xa7\a\u9513", // 锓
	0x9514: "\xa7\a\u9514", // 锔
	0x9515: "\xa7\a\u9515", // 锕
	0x9516: "\xa7\b\u9516", // 锖
	0x9517: "\xa7\b\u9517", // 锗
	0x9518: "\xa7\b\u9518", // 锘
	0x9519: "\xa7\b\u9519", // 错
	0x951a: "\xa7\b\u951a", // 锚
	0x951b: "\xa7\b\u951b", // 锛
	0x951c: "\xa7\b\u951c", // 锜
	0x951d: "\xa7\b\u951d", // 锝
	0x951e: "\xa7\b\u951e", // 锞
	0x951f: "\xa7\b\u951f", // 锟
	0x9520: "\xa7\b\u9520", // 锠
	0x9521: "\xa7\b\u9521", // 锡
	0x9522: "\xa7\b\u9522", // 锢
	0x9523: "\xa7\b\u9523", // 锣
	0x9524: "\xa7\b\u9524", // 锤
	0x9525: "\xa7\b\u9525", // 锥
	0x9526: "\xa7\b\u9526", // 锦
	0x9527: "\xa7\b\u9527", // 锧
	0x9528: "\xa7\b\u9528", // 锨
	0x9529: "\xa7\b\u9529", // 锩
	0x952a: "\xa7\b\u952a", // 锪
	0x952b: "\xa7\b\u952b", // 锫
	0x952c: "\xa7\b\u952c", // 锬
	0x952d: "\xa7\b\u952d", // 锭
	0x952e: "\xa7\b\u952e", // 键
	0x952f: "\xa7\b\u952f", // 锯
	0x9530: "\xa7\b\u9530", // 锰
	0x9531: "\xa7\b\u9531", // 锱
	0x9532: "\xa7\t\u9532", // 锲
	0x9533: "\xa7\t\u9533", // 锳
	0x9534: "\xa7\t\u9534", // 锴
	0x9535: "\xa7\t\u9535", // 锵
	0x9536: "\xa7\t\u9536", // 锶
	0x9537: "\xa7\t\u9537", // 锷
	0x9538: "\xa7\t\u9538", // 锸
	0x9539: "\xa7\t\u9539", // 锹
	0x953a: "\xa7\t\u953a", // 锺
	0x953b: "\xa7\t\u953b", // 锻
	0x953c: "\xa7\t\u953c", // 锼
	0x953d: "\xa7\t\u953d", // 锽
	0x953e: "\xa7\t\u953e", // 锾
	0x953f: "\xa7\t\u953f", // 锿
	0x9540: "\xa7\t\u9540", // 镀
	0x9541: "\xa7\t\u9541", // 镁
	0x9542: "\xa7\t\u9542", // 镂
	0x9543: "\xa7\t\u9543", // 镃
	0x9544: "\xa7\t\u9544", // 镄
	0x9545: "\xa7\t\u9545", // 镅
	0x9546: "\xa7\n\u9546", // 镆
	0x9547: "\xa7\n\u9547", // 镇
	0x9548: "\xa7\n\u9548", // 镈
	0x9549: "\xa7\n\u9549", // 镉
	0x954a: "\xa7\n\u954a", // 镊
	0x954b: "\xa7\n\u954b", // 镋
	0x954c: "\xa7\n\u954c", // 镌
	0x954d: "\xa7\n\u954d", // 镍
	0x954e: "\xa7\n\u954e", // 镎
	0x954f: "\xa7\n\u954f", // 镏
	0x9550: "\xa7\n\u9550", // 镐
	0x9551: "\xa7\n\u9551", // 镑
	0x9552: "\xa7\n\u9552", // 镒
	0x9553: "\xa7\n\u9553", // 镓
	0x9554: "\xa7\n\u9554", // 镔
	0x9555: "\xa7\n\u9555", // 镕
	0x9556: "\xa7\v\u9556", // 镖
	0x9557: "\xa7\v\u9557", // 镗
	0x9558: "\xa7\v\u9558", // 镘
	0x9559: "\xa7\v\u9559", // 镙
	0x955a: "\xa7\v\u955a", // 镚
	0x955b: "\xa7\v\u955b", // 镛
	0x955c: "\xa7\v\u955c", // 镜
	0x955d: "\xa7\v\u955d", // 镝
	0x955e: "\xa7\v\u955e", // 镞
	0x955f: "\xa7\v\u955f", // 镟
	0x9560: "\xa7\v\u9560", // 镠
	0x9561: "\xa7\f\u9561", // 镡
	0x9562: "\xa7\f\u9562", // 镢
	0x9563: "\xa7\f\u9563", // 镣
	0x9564: "\xa7\f\u9564", // 镤
	0x9565: "\xa7\f\u9565", // 镥
	0x9566: "\xa7\f\u9566", // 镦
	0x9567: "\xa7\f\u9567", // 镧
	0x9568: "\xa7\f\u9568", // 镨
	0x9569: "\xa7\f\u9569", // 镩
	0x956a: "\xa7\f\u956a", // 镪
	0x956b: "\xa7\f\u956b", // 镫
	0x956c: "\xa7\r\u956c", // 镬
	0x956d: "\xa7\r\u956d", // 镭
	0x956e: "\xa7\r\u956e", // 镮
	0x956f: "\xa7\r\u956f", // 镯
	0x9570: "\xa7\r\u9570", // 镰
	0x9571: "\xa7\r\u9571", // 镱
	0x9572: "\xa7\x0e\u9572", // 镲
	0x9573: "\xa7\x0f\u9573", // 镳
	0x9574: "\xa7\x0f\u9574", // 镴
	0x9575: "\xa7\x11\u9575", // 镵
	0x9576: "\xa7\x11\u9576", // 镶
	0x9577: "\xa8\x00\u9577", // 長
	0x9578: "\xa8\x00\u9578", // 镸
	0x9579: "\xa8\x03\u9579", // 镹
	0x957a: "\xa8\x04\u957a", // 镺
	0x957b: "\xa8\x05\u957b", // 镻
	0x957c: "\xa8\b\u957c", // 镼
	0x957d: "\xa8\f\u957d", // 镽
	0x957e: "\xa8\x0e\u957e", // 镾
	0x957f: "\xa8\x00\u957f", // 长
	0x9580: "\xa9\x00\u9580", // 門
	0x9581: "\xa9\x01\u9581", // 閁
	0x9582: "\xa9\x01\u9582", // 閂
	0x9583: "\xa9\x02\u9583", // 閃
	0x9584: "\xa9\x02\u9584", // 閄
	0x9585: "\xa9\x02\u9585", // 閅
	0x9586: "\xa9\x03\u9586", // 閆
	0x9587: "\xa9\x03\u9587", // 閇
	0x9588: "\xa9\x03\u9588", // 閈
	0x9589: "\xa9\x03\u9589", // 閉
	0x958a: "\xa9\x03\u958a", // 閊
	0x958b: "\xa9\x04\u958b", // 開
	0x958c: "\xa9\x04\u958c", // 閌
	0x958d: "\xa9\x04\u958d", // 閍
	0x958e: "\xa9\x04\u958e", // 閎
	0x958f: "\xa9\x04\u958f", // 閏
	0x9590: "\xa9\x04\u9590", // 閐
	0x9591: "\xa9\x04\u9591", // 閑
	0x9592: "\xa9\x04\u9592", // 閒
	0x9593: "\xa9\x04\u9593", // 間
	0x9594: "\xa9\x04\u9594", // 閔
	0x9595: "\xa9\x04\u9595", // 閕
	0x9596: "\xa9\x04\u9596", // 閖
	0x9597: "\xa9\x04\u9597", // 閗
	0x9598: "\xa9\x05\u9598", // 閘
	0x9599: "\xa9\x05\u9599", // 閙
	0x959a: "\xa9\x05\u959a", // 閚
	0x959b: "\xa9\x05\u959b", // 閛
	0x959c: "\xa9\x05\u959c", // 閜
	0x959d: "\xa9\x05\u959d", // 閝
	0x959e: "\xa9\x05\u959e", // 閞
	0x959f: "\xa9\x05\u959f", // 閟
	0x95a0: "\xa9\x05\u95a0", // 閠
	0x95a1: "\xa9\x06\u95a1", // 閡
	0x95a2: "\xa9\x06\u95a2", // 関
	0x95a3: "\xa9\x06\u95a3", // 閣
	0x95a4: "\xa9\x06\u95a4", // 閤
	0x95a5: "\xa9\x06\u95a5", // 閥
	0x95a6: "\xa9\x06\u95a6", // 閦
	0x95a7: "\xa9\x06\u95a7", // 閧
	0x95a8: "\xa9\x06\u95a8", // 閨
	0x95a9: "\xa9\x06\u95a9", // 閩
	0x95aa: "\xa9\x06\u95aa", // 閪
	0x95ab: "\xa9\a\u95ab", // 閫
	0x95ac: "\xa9\a\u95ac", // 閬
	0x95ad: "\xa9\a\u95ad", // 閭
	0x95ae: "\xa9\a\u95ae", // 閮
	0x95af: "\xa9\a\u95af", // 閯
	0x95b0: "\xa9\a\u95b0", // 閰
	0x95b1: "\xa9\a\u95b1", // 閱
	0x95b2: "\xa9\a\u95b2", // 閲
	0x95b3: "\xa9\a\u95b3", // 閳
	0x95b4: "\xa9\a\u95b4", // 閴
	0x95b5: "\xa9\b\u95b5", // 閵
	0x95b6: "\xa9\b\u95b6", // 閶
	0x95b7: "\xa9\t\u95b7", // 閷
	0x95b8: "\xa9\b\u95b8", // 閸
	0x95b9: "\xa9\b\u95b9", // 閹
	0x95ba: "\xa9\b\u95ba", // 閺
	0x95bb: "\xa9\b\u95bb", // 閻
	0x95bc: "\xa9\b\u95bc", // 閼
	0x95bd: "\xa9\b\u95bd", // 閽
	0x95be: "\xa9\b\u95be", // 閾
	0x95bf: "\xa9\b\u95bf", // 閿
	0x95c0: "\xa9\b\u95c0", // 闀
	0x95c1: "\xa9\b\u95c1", // 闁
	0x95c2: "\xa9\b\u95c2", // 闂
	0x95c3: "\xa9\t\u95c3", // 闃
	0x95c4: "\xa9\t\u95c4", // 闄
	0x95c5: "\xa9\t\u95c5", // 闅
	0x95c6: "\xa9\t\u95c6", // 闆
	0x95c7: "\xa9\t\u95c7", // 闇
	0x95c8: "\xa9\t\u95c8", // 闈
	0x95c9: "\xa9\t\u95c9", // 闉
	0x95ca: "\xa9\t\u95ca", // 闊
	0x95cb: "\xa9\t\u95cb", // 闋
	0x95cc: "\xa9\t\u95cc", // 闌
	0x95cd: "\xa9\t\u95cd", // 闍
	0x95ce: "\xa9\t\u95ce", // 闎
	0x95cf: "\xa9\t\u95cf", // 闏
	0x95d0: "\xa9\n\u95d0", // 闐
	0x95d1: "\xa9\n\u95d1", // 闑
	0x95d2: "\xa9\n\u95d2", // 闒
	0x95d3: "\xa9\n\u95d3", // 闓
	0x95d4: "\xa9\n\u95d4", // 闔
	0x95d5: "\xa9\n\u95d5", // 闕
	0x95d6: "\xa9\n\u95d6", // 闖
	0x95d7: "\xa9\n\u95d7", // 闗
	0x95d8: "\xa9\n\u95d8", // 闘
	0x95d9: "\xa9\v\u95d9", // 闙
	0x95da: "\xa9\v\u95da", // 闚
	0x95db: "\xa9\v\u95db", // 闛
	0x95dc: "\xa9\v\u95dc", // 關
	0x95dd: "\xa9\v\u95dd", // 闝
	0x95de: "\xa9\f\u95de", // 闞
	0x95df: "\xa9\f\u95df", // 闟
	0x95e0: "\xa9\f\u95e0", // 闠
	0x95e1: "\xa9\f\u95e1", // 闡
	0x95e2: "\xa9\r\u95e2", // 闢
	0x95e3: "\xa9\r\u95e3", // 闣
	0x95e4: "\xa9\r\u95e4", // 闤
	0x95e5: "\xa9\r\u95e5", // 闥
	0x95e6: "\xa9\r\u95e6", // 闦
	0x95e7: "\xa9\x0e\u95e7", // 闧
	0x95e8: "\xa9\x00\u95e8", // 门
	0x95e9: "\xa9\x01\u95e9", // 闩
	0x95ea: "\xa9\x02\u95ea", // 闪
	0x95eb: "\xa9\x03\u95eb", // 闫
	0x95ec: "\xa9\x03\u95ec", // 闬
	0x95ed: "\xa9\x03\u95ed", // 闭
	0x95ee: "\xa9\x03\u95ee", // 问
	0x95ef: "\xa9\x03\u95ef", // 闯
	0x95f0: "\xa9\x04\u95f0", // 闰
	0x95f1: "\xa9\x04\u95f1", // 闱
	0x95f2: "\xa9\x04\u95f2", // 闲
	0x95f3: "\xa9\x04\u95f3", // 闳
	0x95f4: "\xa9\x04\u95f4", // 间
	0x95f5: "\xa9\x04\u95f5", // 闵
	0x95f6: "\xa9\x04\u95f6", // 闶
	0x95f7: "\xa9\x04\u95f7", // 闷
	0x95f8: "\xa9\x05\u95f8", // 闸
	0x95f9: "\xa9\x05\u95f9", // 闹
	0x95fa: "\xa9\x06\u95fa", // 闺
	0x95fb: "\xa9\x06\u95fb", // 闻
	0x95fc: "\xa9\x06\u95fc", // 闼
	0x95fd: "\xa9\x06\u95fd", // 闽
	0x95fe: "\xa9\x06\u95fe", // 闾
	0x95ff: "\xa9\x06\u95ff", // 闿
	0x9600: "\xa9\x06\u9600", // 阀
	0x9601: "\xa9\x06\u9601", // 阁
	0x9602: "\xa9\x06\u9602", // 阂
	0x9603: "\xa9\a\u9603", // 阃
	0x9604: "\xa9\a\u9604", // 阄
	0x9605: "\xa9\a\u9605", // 阅
	0x9606: "\xa9\a\u9606", // 阆
	0x9607: "\xa9\b\u9607", // 阇
	0x9608: "\xa9\b\u9608", // 阈
	0x9609: "\xa9\b\u9609", // 阉
	0x960a: "\xa9\b\u960a", // 阊
	0x960b: "\xa9\b\u960b", // 阋
	0x960c: "\xa9\b\u960c", // 阌
	0x960d: "\xa9\b\u960d", // 阍
	0x960e: "\xa9\b\u960e", // 阎
	0x960f: "\xa9\b\u960f", // 阏
	0x9610: "\xa9\b\u9610", // 阐
	0x9611: "\xa9\t\u9611", // 阑
	0x9612: "\xa9\t\u9612", // 阒
	0x9613: "\xa9\t\u9613", // 阓
	0x9614: "\xa9\t\u9614", // 阔
	0x9615: "\xa9\t\u9615", // 阕
	0x9616: "\xa9\n\u9616", // 阖
	0x9617: "\xa9\n\u9617", // 阗
	0x9618: "\xa9\n\u9618", // 阘
	0x9619: "\xa9\n\u9619", // 阙
	0x961a: "\xa9\v\u961a", // 阚
	0x961b: "\xa9\r\u961b", // 阛
	0x961c: "\xaa\x00\u961c", // 阜
	0x961d: "\xaa\x00\u961d", // 阝
	0x961e: "\xaa\x02\u961e", // 阞
	0x961f: "\xaa\x02\u961f", // 队
	0x9620: "\xaa\x03\u9620", // 阠
	0x9621: "\xaa\x03\u9621", // 阡
	0x9622: "\xaa\x03\u9622", // 阢
	0x9623: "\xaa\x03\u9623", // 阣
	0x9624: "\xaa\x03\u9624", // 阤
	0x9625: "\xaa\x04\u9625", // 阥
	0x9626: "\xaa\x04\u9626", // 阦
	0x9627: "\xaa\x04\u9627", // 阧
	0x9628: "\xaa\x04\u9628", // 阨
	0x9629: "\xaa\x04\u9629", // 阩
	0x962a: "\xaa\x04\u962a", // 阪
	0x962b: "\xaa\x04\u962b", // 阫
	0x962c: "\xaa\x04\u962c", // 阬
	0x962d: "\xaa\x04\u962d", // 阭
	0x962e: "\xaa\x04\u962e", // 阮
	0x962f: "\xaa\x04\u962f", // 阯
	0x9630: "\xaa\x04\u9630", // 阰
	0x9631: "\xaa\x04\u9631", // 阱
	0x9632: "\xaa\x04\u9632", // 防
	0x9633: "\xaa\x04\u9633", // 阳
	0x9634: "\xaa\x04\u9634", // 阴
	0x9635: "\xaa\x04\u9635", // 阵
	0x9636: "\xaa\x04\u9636", // 阶
	0x9637: "\xaa\x05\u9637", // 阷
	0x9638: "\xaa\x05\u9638", // 阸
	0x9639: "\xaa\x05\u9639", // 阹
	0x963a: "\xaa\x05\u963a", // 阺
	0x963b: "\xaa\x05\u963b", // 阻
	0x963c: "\xaa\x05\u963c", // 阼
	0x963d: "\xaa\x05\u963d", // 阽
	0x963e: "\xaa\x05\u963e", // 阾
	0x963f: "\xaa\x05\u963f", // 阿
	0x9640: "\xaa\x05\u9640", // 陀
	0x9641: "\xaa\x05\u9641", // 陁
	0x9642: "\xaa\x05\u9642", // 陂
	0x9643: "\xaa\x05\u9643", // 陃
	0x9644: "\xaa\x05\u9644", // 附
	0x9645: "\xaa\x05\u9645", // 际
	0x9646: "\xaa\x05\u9646", // 陆
	0x9647: "\xaa\x05\u9647", // 陇
	0x9648: "\xaa\x05\u9648", // 陈
	0x9649: "\xaa\x05\u9649", // 陉
	0x964a: "\xaa\x06\u964a", // 陊
	0x964b: "\xaa\x06\u964b", // 陋
	0x964c: "\xaa\x06\u964c", // 陌
	0x964d: "\xaa\x06\u964d", // 降
	0x964e: "\xaa\x06\u964e", // 陎
	0x964f: "\xaa\x06\u964f", // 陏
	0x9650: "\xaa\x06\u9650", // 限
	0x9651: "\xaa\x06\u9651", // 陑
	0x9652: "\xaa\x06\u9652", // 陒
	0x9653: "\xaa\x06\u9653", // 陓
	0x9654: "\xaa\x06\u9654", // 陔
	0x9655: "\xaa\x06\u9655", // 陕
	0x9656: "\xaa\a\u9656", // 陖
	0x9657: "\xaa\a\u9657", // 陗
	0x9658: "\xaa\a\u9658", // 陘
	0x9659: "\xaa\a\u9659", // 陙
	0x965a: "\xaa\b\u965a", // 陚
	0x965b: "\xaa\a\u965b", // 陛
	0x965c: "\xaa\a\u965c", // 陜
	0x965d: "\xaa\a\u965d", // 陝
	0x965e: "\xaa\a\u965e", // 陞
	0x965f: "\xaa\a\u965f", // 陟
	0x9660: "\xaa\a\u9660", // 陠
	0x9661: "\xaa\a\u9661", // 陡
	0x9662: "\xaa\a\u9662", // 院
	0x9663: "\xaa\a\u9663", // 陣
	0x9664: "\xaa\a\u9664", // 除
	0x9665: "\xaa\a\u9665", // 陥
	0x9666: "\xaa\a\u9666", // 陦
	0x9667: "\xaa\a\u9667", // 陧
	0x9668: "\xaa\a\u9668", // 陨
	0x9669: "\xaa\a\u9669", // 险
	0x966a: "\xaa\b\u966a", // 陪
	0x966b: "\xaa\b\u966b", // 陫
	0x966c: "\xaa\b\u966c", // 陬
	0x966d: "\xaa\b\u966d", // 陭
	0x966e: "\xaa\b\u966e", // 陮
	0x966f: "\xaa\b\u966f", // 陯
	0x9670: "\xaa\b\u9670", // 陰
	0x9671: "\xaa\b\u9671", // 陱
	0x9672: "\xaa\b\u9672", // 陲
	0x9673: "\xaa\b\u9673", // 陳
	0x9674: "\xaa\b\u9674", // 陴
	0x9675: "\xaa\b\u9675", // 陵
	0x9676: "\xaa\b\u9676", // 陶
	0x9677: "\xaa\b\u9677", // 陷
	0x9678: "\xaa\b\u9678", // 陸
	0x9679: "\xaa\b\u9679", // 陹
	0x967a: "\xaa\b\u967a", // 険
	0x967b: "\xaa\t\u967b", // 陻
	0x967c: "\xaa\t\u967c", // 陼
	0x967d: "\xaa\t\u967d", // 陽
	0x967e: "\xaa\t\u967e", // 陾
	0x967f: "\xaa\t\u967f", // 陿
	0x9680: "\xaa\t\u9680", // 隀
	0x9681: "\xaa\t\u9681", // 隁
	0x9682: "\xaa\t\u9682", // 隂
	0x9683: "\xaa\t\u9683", // 隃
	0x9684: "\xaa\t\u9684", // 隄
	0x9685: "\xaa\t\u9685", // 隅
	0x9686: "\xaa\t\u9686", // 隆
	0x9687: "\xaa\t\u9687", // 隇
	0x9688: "\xaa\t\u9688", // 隈
	0x9689: "\xaa\t\u9689", // 隉
	0x968a: "\xaa\t\u968a", // 隊
	0x968b: "\xaa\t\u968b", // 隋
	0x968c: "\xaa\t\u968c", // 隌
	0x968d: "\xaa\t\u968d", // 隍
	0x968e: "\xaa\t\u968e", // 階
	0x968f: "\xaa\t\u968f", // 随
	0x9690: "\xaa\t\u9690", // 隐
	0x9691: "\xaa\n\u9691", // 隑
	0x9692: "\xaa\n\u9692", // 隒
	0x9693: "\xaa\n\u9693", // 隓
	0x9694: "\xaa\n\u9694", // 隔
	0x9695: "\xaa\n\u9695", // 隕
	0x9696: "\xaa\n\u9696", // 隖
	0x9697: "\xaa\n\u9697", // 隗
	0x9698: "\xaa\n\u9698", // 隘
	0x9699: "\xaa\n\u9699", // 隙
	0x969a: "\xaa\v\u969a", // 隚
	0x969b: "\xaa\v\u969b", // 際
	0x969c: "\xaa\v\u969c", // 障
	0x969d: "\xaa\v\u969d", // 隝
	0x969e: "\xaa\v\u969e", // 隞
	0x969f: "\xaa\v\u969f", // 隟
	0x96a0: "\xaa\v\u96a0", // 隠
	0x96a1: "\xaa\v\u96a1", // 隡
	0x96a2: "\xaa\f\u96a2", // 隢
	0x96a3: "\xaa\f\u96a3", // 隣
	0x96a4: "\xaa\f\u96a4", // 隤
	0x96a5: "\xaa\f\u96a5", // 隥
	0x96a6: "\xaa\r\u96a6", // 隦
	0x96a7: "\xaa\r\u96a7", // 隧
	0x96a8: "\xaa\r\u96a8", // 隨
	0x96a9: "\xaa\r\u96a9", // 隩
	0x96aa: "\xaa\r\u96aa", // 險
	0x96ab: "\xaa\r\u96ab", // 隫
	0x96ac: "\xaa\x0e\u96ac", // 隬
	0x96ad: "\xaa\x0e\u96ad", // 隭
	0x96ae: "\xaa\x0e\u96ae", // 隮
	0x96af: "\xaa\x0e\u96af", // 隯
	0x96b0: "\xaa\x0e\u96b0", // 隰
	0x96b1: "\xaa\x0e\u96b1", // 隱
	0x96b2: "\xaa\x0e\u96b2", // 隲
	0x96b3: "\xaa\x0f\u96b3", // 隳
	0x96b4: "\xaa\x10\u96b4", // 隴
	0x96b5: "\xaa\x11\u96b5", // 隵
	0x96b6: "\xab\x00\u96b6", // 隶
	0x96b7: "\xab\b\u96b7", // 隷
	0x96b8: "\xab\t\u96b8", // 隸
	0x96b9: "\xac\x00\u96b9", // 隹
	0x96ba: "\xac\x02\u96ba", // 隺
	0x96bb: "\xac\x02\u96bb", // 隻
	0x96bc: "\xac\x02\u96bc", // 隼
	0x96bd: "\xac\x02\u96bd", // 隽
	0x96be: "\xac\x02\u96be", // 难
	0x96bf: "\xac\x03\u96bf", // 隿
	0x96c0: "\xac\x03\u96c0", // 雀
	0x96c1: "\xac\x04\u96c1", // 雁
	0x96c2: "\xac\x04\u96c2", // 雂
	0x96c3: "\xac\x04\u96c3", // 雃
	0x96c4: "\xac\x04\u96c4", // 雄
	0x96c5: "\xac\x04\u96c5", // 雅
	0x96c6: "\xac\x04\u96c6", // 集
	0x96c7: "\xac\x04\u96c7", // 雇
	0x96c8: "\xac\x04\u96c8", // 雈
	0x96c9: "\xac\x05\u96c9", // 雉
	0x96ca: "\xac\x05\u96ca", // 雊
	0x96cb: "\xac\x05\u96cb", // 雋
	0x96cc: "\xac\x05\u96cc", // 雌
	0x96cd: "\xac\x05\u96cd", // 雍
	0x96ce: "\xac\x05\u96ce", // 雎
	0x96cf: "\xac\x05\u96cf", // 雏
	0x96d0: "\xac\x06\u96d0", // 雐
	0x96d1: "\xac\x06\u96d1", // 雑
	0x96d2: "\xac\x06\u96d2", // 雒
	0x96d3: "\xac\a\u96d3", // 雓
	0x96d4: "\xac\b\u96d4", // 雔
	0x96d5: "\xac\b\u96d5", // 雕
	0x96d6: "\xac\t\u96d6", // 雖
	0x96d7: "\xac\n\u96d7", // 雗
	0x96d8: "\xac\n\u96d8", // 雘
	0x96d9: "\xac\n\u96d9", // 雙
	0x96da: "\xac\n\u96da", // 雚
	0x96db: "\xac\n\u96db", // 雛
	0x96dc: "\xac\n\u96dc", // 雜
	0x96dd: "\xac\n\u96dd", // 雝
	0x96de: "\xac\n\u96de", // 雞
	0x96df: "\xac\n\u96df", // 雟
	0x96e0: "\xac\n\u96e0", // 雠
	0x96e1: "\xac\v\u96e1", // 雡
	0x96e2: "\xac\v\u96e2", // 離
	0x96e3: "\xac\v\u96e3", // 難
	0x96e4: "\xac\r\u96e4", // 雤
	0x96e5: "\xac\x10\u96e5", // 雥
	0x96e6: "\xac\x10\u96e6", // 雦
	0x96e7: "\xac\x14\u96e7", // 雧
	0x96e8: "\xad\x00\u96e8", // 雨
	0x96e9: "\xad\x03\u96e9", // 雩
	0x96ea: "\xad\x03\u96ea", // 雪
	0x96eb: "\xad\x03\u96eb", // 雫
	0x96ec: "\xad\x04\u96ec", // 雬
	0x96ed: "\xad\x04\u96ed", // 雭
	0x96ee: "\xad\x04\u96ee", // 雮
	0x96ef: "\xad\x04\u96ef", // 雯
	0x96f0: "\xad\x04\u96f0", // 雰
	0x96f1: "\xad\x04\u96f1", // 雱
	0x96f2: "\xad\x04\u96f2", // 雲
	0x96f3: "\xad\x04\u96f3", // 雳
	0x96f4: "\xad\x05\u96f4", // 雴
	0x96f5: "\xad\x05\u96f5", // 雵
	0x96f6: "\xad\x05\u96f6", // 零
	0x96f7: "\xad\x05\u96f7", // 雷
	0x96f8: "\xad\x05\u96f8", // 雸
	0x96f9: "\xad\x05\u96f9", // 雹
	0x96fa: "\xad\x05\u96fa", // 雺
	0x96fb: "\xad\x05\u96fb", // 電
	0x96fc: "\xad\x05\u96fc", // 雼
	0x96fd: "\xad\x05\u96fd", // 雽
	0x96fe: "\xad\x05\u96fe", // 雾
	0x96ff: "\xad\x06\u96ff", // 雿
	0x9700: "\xad\x06\u9700", // 需
	0x9701: "\xad\x06\u9701", // 霁
	0x9702: "\xad\a\u9702", // 霂
	0x9703: "\xad\a\u9703", // 霃
	0x9704: "\xad\a\u9704", // 霄
	0x9705: "\xad\a\u9705", // 霅
	0x9706: "\xad\a\u9706", // 霆
	0x9707: "\xad\a\u9707", // 震
	0x9708: "\xad\a\u9708", // 霈
	0x9709: "\xad\a\u9709", // 霉
	0x970a: "\xad\a\u970a", // 霊
	0x970b: "\xad\b\u970b", // 霋
	0x970c: "\xad\b\u970c", // 霌
	0x970d: "\xad\b\u970d", // 霍
	0x970e: "\xad\b\u970e", // 霎
	0x970f: "\xad\b\u970f", // 霏
	0x9710: "\xad\b\u9710", // 霐
	0x9711: "\xad\b\u9711", // 霑
	0x9712: "\xad\b\u9712", // 霒
	0x9713: "\xad\b\u9713", // 霓
	0x9714: "\xad\b\u9714", // 霔
	0x9715: "\xad\b\u9715", // 霕
	0x9716: "\xad\b\u9716", // 霖
	0x9717: "\xad\b\u9717", // 霗
	0x9718: "\xad\t\u9718", // 霘
	0x9719: "\xad\t\u9719", // 霙
	0x971a: "\xad\t\u971a", // 霚
	0x971b: "\xad\t\u971b", // 霛
	0x971c: "\xad\t\u971c", // 霜
	0x971d: "\xad\t\u971d", // 霝
	0x971e: "\xad\t\u971e", // 霞
	0x971f: "\xad\t\u971f", // 霟
	0x9720: "\xad\t\u9720", // 霠
	0x9721: "\xad\n\u9721", // 霡
	0x9722: "\xad\n\u9722", // 霢
	0x9723: "\xad\n\u9723", // 霣
	0x9724: "\xad\n\u9724", // 霤
	0x9725: "\xad\n\u9725", // 霥
	0x9726: "\xad\v\u9726", // 霦
	0x9727: "\xad\v\u9727", // 霧
	0x9728: "\xad\v\u9728", // 霨
	0x9729: "\xad\v\u9729", // 霩
	0x972a: "\xad\v\u972a", // 霪
	0x972b: "\xad\v\u972b", // 霫
	0x972c: "\xad\v\u972c", // 霬
	0x972d: "\xad\v\u972d", // 霭
	0x972e: "\xad\f\u972e", // 霮
	0x972f: "\xad\f\u972f", // 霯
	0x9730: "\xad\f\u9730", // 霰
	0x9731: "\xad\f\u9731", // 霱
	0x9732: "\xad\f\u9732", // 露
	0x9733: "\xad\f\u9733", // 霳
	0x9734: "\xad\f\u9734", // 霴
	0x9735: "\xad\r\u9735", // 霵
	0x9736: "\xad\r\u9736", // 霶
	0x9737: "\xad\r\u9737", // 霷
	0x9738: "\xad\r\u9738", // 霸
	0x9739: "\xad\r\u9739", // 霹
	0x973a: "\xad\r\u973a", // 霺
	0x973b: "\xad\r\u973b", // 霻
	0x973c: "\xad\x0e\u973c", // 霼
	0x973d: "\xad\x0e\u973d", // 霽
	0x973e: "\xad\x0e\u973e", // 霾
	0x973f: "\xad\x0e\u973f", // 霿
	0x9740: "\xad\x0e\u9740", // 靀
	0x9741: "\xad\x0f\u9741", // 靁
	0x9742: "\xad\x10\u9742", // 靂
	0x9743: "\xad\x10\u9743", // 靃
	0x9744: "\xad\x10\u9744", // 靄
	0x9745: "\xad\x10\u9745", // 靅
	0x9746: "\xad\x10\u9746", // 靆
	0x9747: "\xad\x10\u9747", // 靇
	0x9748: "\xad\x10\u9748", // 靈
	0x9749: "\xad\x11\u9749", // 靉
	0x974a: "\xad\x12\u974a", // 靊
	0x974b: "\xad\x13\u974b", // 靋
	0x974c: "\xad\x13\u974c", // 靌
	0x974d: "\xad\x13\u974d", // 靍
	0x974e: "\xad\x13\u974e", // 靎
	0x974f: "\xad\x15\u974f", // 靏
	0x9750: "\xad\x1f\u9750", // 靐
	0x9751: "\xae\x00\u9751", // 靑
	0x9752: "\xae\x00\u9752", // 青
	0x9753: "\xae\x04\u9753", // 靓
	0x9754: "\xae\x04\u9754", // 靔
	0x9755: "\xae\x05\u9755", // 靕
	0x9756: "\xae\x05\u9756", // 靖
	0x9757: "\xae\x06\u9757", // 靗
	0x9758: "\xae\x06\u9758", // 靘
	0x9759: "\xae\x06\u9759", // 静
	0x975a: "\xae\a\u975a", // 靚
	0x975b: "\xae\b\u975b", // 靛
	0x975c: "\xae\b\u975c", // 靜
	0x975d: "\xae\n\u975d", // 靝
	0x975e: "\xaf\x00\u975e", // 非
	0x975f: "\xaf\x04\u975f", // 靟
	0x9760: "\xaf\a\u9760", // 靠
	0x9761: "\xaf\v\u9761", // 靡
	0x9762: "\xb0\x00\u9762", // 面
	0x9763: "\xb0\x00\u9763", // 靣
	0x9764: "\xb0\x05\u9764", // 靤
	0x9765: "\xb0\x06\u9765", // 靥
	0x9766: "\xb0\a\u9766", // 靦
	0x9767: "\xb0\f\u9767", // 靧
	0x9768: "\xb0\x0e\u9768", // 靨
	0x9769: "\xb1\x00\u9769", // 革
	0x976a: "\xb1\x02\u976a", // 靪
	0x976b: "\xb1\x03\u976b", // 靫
	0x976c: "\xb1\x03\u976c", // 靬
	0x976d: "\xb1\x03\u976d", // 靭
	0x976e: "\xb1\x03\u976e", // 靮
	0x976f: "\xb1\x03\u976f", // 靯
	0x9770: "\xb1\x03\u9770", // 靰
	0x9771: "\xb1\x03\u9771", // 靱
	0x9772: "\xb1\x04\u9772", // 靲
	0x9773: "\xb1\x04\u9773", // 靳
	0x9774: "\xb1\x04\u9774", // 靴
	0x9775: "\xb1\x04\u9775", // 靵
	0x9776: "\xb1\x04\u9776", // 靶
	0x9777: "\xb1\x04\u9777", // 靷
	0x9778: "\xb1\x04\u9778", // 靸
	0x9779: "\xb1\x04\u9779", // 靹
	0x977a: "\xb1\x05\u977a", // 靺
	0x977b: "\xb1\x05\u977b", // 靻
	0x977c: "\xb1\x05\u977c", // 靼
	0x977d: "\xb1\x05\u977d", // 靽
	0x977e: "\xb1\x05\u977e", // 靾
	0x977f: "\xb1\x05\u977f", // 靿
	0x9780: "\xb1\x05\u9780", // 鞀
	0x9781: "\xb1\x05\u9781", // 鞁
	0x9782: "\xb1\x05\u9782", // 鞂
	0x9783: "\xb1\x05\u9783", // 鞃
	0x9784: "\xb1\x05\u9784", // 鞄
	0x9785: "\xb1\x05\u9785", // 鞅
	0x9786: "\xb1\x05\u9786", // 鞆
	0x9787: "\xb1\x06\u9787", // 鞇
	0x9788: "\xb1\x06\u9788", // 鞈
	0x9789: "\xb1\x06\u9789", // 鞉
	0x978a: "\xb1\x06\u978a", // 鞊
	0x978b: "\xb1\x06\u978b", // 鞋
	0x978c: "\xb1\x06\u978c", // 鞌
	0x978d: "\xb1\x06\u978d", // 鞍
	0x978e: "\xb1\x06\u978e", // 鞎
	0x978f: "\xb1\x06\u978f", // 鞏
	0x9790: "\xb1\x06\u9790", // 鞐
	0x9791: "\xb1\x06\u9791", // 鞑
	0x9792: "\xb1\x06\u9792", // 鞒
	0x9793: "\xb1\a\u9793", // 鞓
	0x9794: "\xb1\a\u9794", // 鞔
	0x9795: "\xb1\a\u9795", // 鞕
	0x9796: "\xb1\a\u9796", // 鞖
	0x9797: "\xb1\a\u9797", // 鞗
	0x9798: "\xb1\a\u9798", // 鞘
	0x9799: "\xb1\a\u9799", // 鞙
	0x979a: "\xb1\b\u979a", // 鞚
	0x979b: "\xb1\b\u979b", // 鞛
	0x979c: "\xb1\b\u979c", // 鞜
	0x979d: "\xb1\b\u979d", // 鞝
	0x979e: "\xb1\b\u979e", // 鞞
	0x979f: "\xb1\b\u979f", // 鞟
	0x97a0: "\xb1\b\u97a0", // 鞠
	0x97a1: "\xb1\b\u97a1", // 鞡
	0x97a2: "\xb1\t\u97a2", // 鞢
	0x97a3: "\xb1\t\u97a3", // 鞣
	0x97a4: "\xb1\t\u97a4", // 鞤
	0x97a5: "\xb1\t\u97a5", // 鞥
	0x97a6: "\xb1\t\u97a6", // 鞦
	0x97a7: "\xb1\t\u97a7", // 鞧
	0x97a8: "\xb1\t\u97a8", // 鞨
	0x97a9: "\xb1\t\u97a9", // 鞩
	0x97aa: "\xb1\t\u97aa", // 鞪
	0x97ab: "\xb1\t\u97ab", // 鞫
	0x97ac: "\xb1\t\u97ac", // 鞬
	0x97ad: "\xb1\t\u97ad", // 鞭
	0x97ae: "\xb1\t\u97ae", // 鞮
	0x97af: "\xb1\t\u97af", // 鞯
	0x97b0: "\xb1\t\u97b0", // 鞰
	0x97b1: "\xb1\n\u97b1", // 鞱
	0x97b2: "\xb1\n\u97b2", // 鞲
	0x97b3: "\xb1\n\u97b3", // 鞳
	0x97b4: "\xb1\n\u97b4", // 鞴
	0x97b5: "\xb1\n\u97b5", // 鞵
	0x97b6: "\xb1\n\u97b6", // 鞶
	0x97b7: "\xb1\n\u97b7", // 鞷
	0x97b8: "\xb1\v\u97b8", // 鞸
	0x97b9: "\xb1\v\u97b9", // 鞹
	0x97ba: "\xb1\v\u97ba", // 鞺
	0x97bb: "\xb1\v\u97bb", // 鞻
	0x97bc: "\xb1\f\u97bc", // 鞼
	0x97bd: "\xb1\f\u97bd", // 鞽
	0x97be: "\xb1\f\u97be", // 鞾
	0x97bf: "\xb1\f\u97bf", // 鞿
	0x97c0: "\xb1\r\u97c0", // 韀
	0x97c1: "\xb1\r\u97c1", // 韁
	0x97c2: "\xb1\r\u97c2", // 韂
	0x97c3: "\xb1\r\u97c3", // 韃
	0x97c4: "\xb1\x0e\u97c4", // 韄
	0x97c5: "\xb1\x0e\u97c5", // 韅
	0x97c6: "\xb1\x0f\u97c6", // 韆
	0x97c7: "\xb1\x0f\u97c7", // 韇
	0x97c8: "\xb1\x0f\u97c8", // 韈
	0x97c9: "\xb1\x11\u97c9", // 韉
	0x97ca: "\xb1\x15\u97ca", // 韊
	0x97cb: "\xb2\x00\u97cb", // 韋
	0x97cc: "\xb2\x03\u97cc", // 韌
	0x97cd: "\xb2\x05\u97cd", // 韍
	0x97ce: "\xb2\x05\u97ce", // 韎
	0x97cf: "\xb2\x06\u97cf", // 韏
	0x97d0: "\xb2\x06\u97d0", // 韐
	0x97d1: "\xb2\x06\u97d1", // 韑
	0x97d2: "\xb2\a\u97d2", // 韒
	0x97d3: "\xb2\b\u97d3", // 韓
	0x97d4: "\xb2\b\u97d4", // 韔
	0x97d5: "\xb2\b\u97d5", // 韕
	0x97d6: "\xb2\t\u97d6", // 韖
	0x97d7: "\xb2\t\u97d7", // 韗
	0x97d8: "\xb2\t\u97d8", // 韘
	0x97d9: "\xb2\t\u97d9", // 韙
	0x97da: "\xb2\t\u97da", // 韚
	0x97db: "\xb2\v\u97db", // 韛
	0x97dc: "\xb2\n\u97dc", // 韜
	0x97dd: "\xb2\n\u97dd", // 韝
	0x97de: "\xb2\n\u97de", // 韞
	0x97df: "\xb2\n\u97df", // 韟
	0x97e0: "\xb2\v\u97e0", // 韠
	0x97e1: "\xb2\f\u97e1", // 韡
	0x97e2: "\xb2\f\u97e2", // 韢
	0x97e3: "\xb2\r\u97e3", // 韣
	0x97e4: "\xb2\x0f\u97e4", // 韤
	0x97e5: "\xb2\x0f\u97e5", // 韥
	0x97e6: "\xb2\x00\u97e6", // 韦
	0x97e7: "\xb2\x03\u97e7", // 韧
	0x97e8: "\xb2\x05\u97e8", // 韨
	0x97e9: "\xb2\b\u97e9", // 韩
	0x97ea: "\xb2\t\u97ea", // 韪
	0x97eb: "\xb2\t\u97eb", // 韫
	0x97ec: "\xb2\n\u97ec", // 韬
	0x97ed: "\xb3\x00\u97ed", // 韭
	0x97ee: "\xb3\x04\u97ee", // 韮
	0x97ef: "\xb3\x06\u97ef", // 韯
	0x97f0: "\xb3\a\u97f0", // 韰
	0x97f1: "\xb3\b\u97f1", // 韱
	0x97f2: "\xb3\n\u97f2", // 韲
	0x97f3: "\xb4\x00\u97f3", // 音
	0x97f4: "\xb4\x04\u97f4", // 韴
	0x97f5: "\xb4\x04\u97f5", // 韵
	0x97f6: "\xb4\x05\u97f6", // 韶
	0x97f7: "\xb4\x05\u97f7", // 韷
	0x97f8: "\xb4\a\u97f8", // 韸
	0x97f9: "\xb4\t\u97f9", // 韹
	0x97fa: "\xb4\t\u97fa", // 韺
	0x97fb: "\xb4\n\u97fb", // 韻
	0x97fc: "\xb4\n\u97fc", // 韼
	0x97fd: "\xb4\v\u97fd", // 韽
	0x97fe: "\xb4\v\u97fe", // 韾
	0x97ff: "\xb4\v\u97ff", // 響
	0x9800: "\xb4\x0e\u9800", // 頀
	0x9801: "\xb5\x00\u9801", // 頁
	0x9802: "\xb5\x02\u9802", // 頂
	0x9803: "\xb5\x02\u9803", // 頃
	0x9804: "\xb5\x02\u9804", // 頄
	0x9805: "\xb5\x03\u9805", // 項
	0x9806: "\xb5\x03\u9806", // 順
	0x9807: "\xb5\x03\u9807", // 頇
	0x9808: "\xb5\x03\u9808", // 須
	0x9809: "\xb5\x03\u9809", // 頉
	0x980a: "\xb5\x04\u980a", // 頊
	0x980b: "\xb5\x04\u980b", // 頋
	0x980c: "\xb5\x04\u980c", // 頌
	0x980d: "\xb5\x04\u980d", // 頍
	0x980e: "\xb5\x04\u980e", // 頎
	0x980f: "\xb5\x04\u980f", // 頏
	0x9810: "\xb5\x04\u9810", // 預
	0x9811: "\xb5\x04\u9811", // 頑
	0x9812: "\xb5\x04\u9812", // 頒
	0x9813: "\xb5\x04\u9813", // 頓
	0x9814: "\xb5\x05\u9814", // 頔
	0x9815: "\xb5\x05\u9815", // 頕
	0x9816: "\xb5\x05\u9816", // 頖
	0x9817: "\xb5\x05\u9817", // 頗
	0x9818: "\xb5\x05\u9818", // 領
	0x9819: "\xb5\x04\u9819", // 頙
	0x981a: "\xb5\x05\u981a", // 頚
	0x981b: "\xb5\x06\u981b", // 頛
	0x981c: "\xb5\x06\u981c", // 頜
	0x981d: "\xb5\x06\u981d", // 頝
	0x981e: "\xb5\x06\u981e", // 頞
	0x981f: "\xb5\x06\u981f", // 頟
	0x9820: "\xb5\x06\u9820", // 頠
	0x9821: "\xb5\x06\u9821", // 頡
	0x9822: "\xb5\x06\u9822", // 頢
	0x9823: "\xb5\x06\u9823", // 頣
	0x9824: "\xb5\a\u9824", // 頤
	0x9825: "\xb5\a\u9825", // 頥
	0x9826: "\xb5\x06\u9826", // 頦
	0x9827: "\xb5\x06\u9827", // 頧
	0x9828: "\xb5\x06\u9828", // 頨
	0x9829: "\xb5\x06\u9829", // 頩
	0x982a: "\xb5\x06\u982a", // 頪
	0x982b: "\xb5\x06\u982b", // 頫
	0x982c: "\xb5\x06\u982c", // 頬
	0x982d: "\xb5\a\u982d", // 頭
	0x982e: "\xb5\a\u982e", // 頮
	0x982f: "\xb5\a\u982f", // 頯
	0x9830: "\xb5\a\u9830", // 頰
	0x9831: "\xb5\a\u9831", // 頱
	0x9832: "\xb5\a\u9832", // 頲
	0x9833: "\xb5\a\u9833", // 頳
	0x9834: "\xb5\a\u9834", // 頴
	0x9835: "\xb5\a\u9835", // 頵
	0x9836: "\xb5\a\u9836", // 頶
	0x9837: "\xb5\a\u9837", // 頷
	0x9838: "\xb5\a\u9838", // 頸
	0x9839: "\xb5\a\u9839", // 頹
	0x983a: "\xb5\a\u983a", // 頺
	0x983b: "\xb5\a\u983b", // 頻
	0x983c: "\xb5\a\u983c", // 頼
	0x983d: "\xb5\a\u983d", // 頽
	0x983e: "\xb5\t\u983e", // 頾
	0x983f: "\xb5\b\u983f", // 頿
	0x9840: "\xb5\b\u9840", // 顀
	0x9841: "\xb5\b\u9841", // 顁
	0x9842: "\xb5\b\u9842", // 顂
	0x9843: "\xb5\b\u9843", // 顃
	0x9844: "\xb5\b\u9844", // 顄
	0x9845: "\xb5\b\u9845", // 顅
	0x9846: "\xb5\b\u9846", // 顆
	0x9847: "\xb5\b\u9847", // 顇
	0x9848: "\xb5\b\u9848", // 顈
	0x9849: "\xb5\b\u9849", // 顉
	0x984a: "\xb5\b\u984a", // 顊
	0x984b: "\xb5\t\u984b", // 顋
	0x984c: "\xb5\t\u984c", // 題
	0x984d: "\xb5\t\u984d", // 額
	0x984e: "\xb5\t\u984e", // 顎
	0x984f: "\xb5\t\u984f", // 顏
	0x9850: "\xb5\t\u9850", // 顐
	0x9851: "\xb5\t\u9851", // 顑
	0x9852: "\xb5\t\u9852", // 顒
	0x9853: "\xb5\t\u9853", // 顓
	0x9854: "\xb5\t\u9854", // 顔
	0x9855: "\xb5\t\u9855", // 顕
	0x9856: "\xb5\n\u9856", // 顖
	0x9857: "\xb5\n\u9857", // 顗
	0x9858: "\xb5\n\u9858", // 願
	0x9859: "\xb5\n\u9859", // 顙
	0x985a: "\xb5\n\u985a", // 顚
	0x985b: "\xb5\n\u985b", // 顛
	0x985c: "\xb5\n\u985c", // 顜
	0x985d: "\xb5\n\u985d", // 顝
	0x985e: "\xb5\n\u985e", // 類
	0x985f: "\xb5\v\u985f", // 顟
	0x9860: "\xb5\v\u9860", // 顠
	0x9861: "\xb5\v\u9861", // 顡
	0x9862: "\xb5\v\u9862", // 顢
	0x9863: "\xb5\v\u9863", // 顣
	0x9864: "\xb5\f\u9864", // 顤
	0x9865: "\xb5\f\u9865", // 顥
	0x9866: "\xb5\f\u9866", // 顦
	0x9867: "\xb5\f\u9867", // 顧
	0x9868: "\xb5\f\u9868", // 顨
	0x9869: "\xb5\r\u9869", // 顩
	0x986a: "\xb5\r\u986a", // 顪
	0x986b: "\xb5\r\u986b", // 顫
	0x986c: "\xb5\x0e\u986c", // 顬
	0x986d: "\xb5\x0e\u986d", // 顭
	0x986e: "\xb5\x0e\u986e", // 顮
	0x986f: "\xb5\x0e\u986f", // 顯
	0x9870: "\xb5\x0f\u9870", // 顰
	0x9871: "\xb5\x10\u9871", // 顱
	0x9872: "\xb5\x10\u9872", // 顲
	0x9873: "\xb5\x12\u9873", // 顳
	0x9874: "\xb5\x12\u9874", // 顴
	0x9875: "\xb5\x00\u9875", // 页
	0x9876: "\xb5\x02\u9876", // 顶
	0x9877: "\xb5\x02\u9877", // 顷
	0x9878: "\xb5\x03\u9878", // 顸
	0x9879: "\xb5\x03\u9879", // 项
	0x987a: "\xb5\x03\u987a", // 顺
	0x987b: "\xb5\x03\u987b", // 须
	0x987c: "\xb5\x04\u987c", // 顼
	0x987d: "\xb5\x04\u987d", // 顽
	0x987e: "\xb5\x04\u987e", // 顾
	0x987f: "\xb5\x04\u987f", // 顿
	0x9880: "\xb5\x04\u9880", // 颀
	0x9881: "\xb5\x04\u9881", // 颁
	0x9882: "\xb5\x04\u9882", // 颂
	0x9883: "\xb5\x04\u9883", // 颃
	0x9884: "\xb5\x04\u9884", // 预
	0x9885: "\xb5\x05\u9885", // 颅
	0x9886: "\xb5\x05\u9886", // 领
	0x9887: "\xb5\x05\u9887", // 颇
	0x9888: "\xb5\x05\u9888", // 颈
	0x9889: "\xb5\x06\u9889", // 颉
	0x988a: "\xb5\x06\u988a", // 颊
	0x988b: "\xb5\x06\u988b", // 颋
	0x988c: "\xb5\x06\u988c", // 颌
	0x988d: "\xb5\x06\u988d", // 颍
	0x988e: "\xb5\x06\u988e", // 颎
	0x988f: "\xb5\x06\u988f", // 颏
	0x9890: "\xb5\a\u9890", // 颐
	0x9891: "\xb5\a\u9891", // 频
	0x9892: "\xb5\a\u9892", // 颒
	0x9893: "\xb5\a\u9893", // 颓
	0x9894: "\xb5\a\u9894", // 颔
	0x9895: "\xb5\a\u9895", // 颕
	0x9896: "\xb5\a\u9896", // 颖
	0x9897: "\xb5\b\u9897", // 颗
	0x9898: "\xb5\t\u9898", // 题
	0x9899: "\xb5\t\u9899", // 颙
	0x989a: "\xb5\t\u989a", // 颚
	0x989b: "\xb5\t\u989b", // 颛
	0x989c: "\xb5\t\u989c", // 颜
	0x989d: "\xb5\t\u989d", // 额
	0x989e: "\xb5\n\u989e", // 颞
	0x989f: "\xb5\n\u989f", // 颟
	0x98a0: "\xb5\n\u98a0", // 颠
	0x98a1: "\xb5\n\u98a1", // 颡
	0x98a2: "\xb5\f\u98a2", // 颢
	0x98a3: "\xb5\f\u98a3", // 颣
	0x98a4: "\xb5\r\u98a4", // 颤
	0x98a5: "\xb5\x0e\u98a5", // 颥
	0x98a6: "\xb5\x0f\u98a6", // 颦
	0x98a7: "\xb5\x11\u98a7", // 颧
	0x98a8: "\xb6\x00\u98a8", // 風
	0x98a9: "\xb6\x03\u98a9", // 颩
	0x98aa: "\xb6\x03\u98aa", // 颪
	0x98ab: "\xb6\x04\u98ab", // 颫
	0x98ac: "\xb6\x04\u98ac", // 颬
	0x98ad: "\xb6\x05\u98ad", // 颭
	0x98ae: "\xb6\x05\u98ae", // 颮
	0x98af: "\xb6\x05\u98af", // 颯
	0x98b0: "\xb6\x05\u98b0", // 颰
	0x98b1: "\xb6\x05\u98b1", // 颱
	0x98b2: "\xb6\x06\u98b2", // 颲
	0x98b3: "\xb6\x06\u98b3", // 颳
	0x98b4: "\xb6\a\u98b4", // 颴
	0x98b5: "\xb6\a\u98b5", // 颵
	0x98b6: "\xb6\b\u98b6", // 颶
	0x98b7: "\xb6\b\u98b7", // 颷
	0x98b8: "\xb6\t\u98b8", // 颸
	0x98b9: "\xb6\t\u98b9", // 颹
	0x98ba: "\xb6\t\u98ba", // 颺
	0x98bb: "\xb6\n\u98bb", // 颻
	0x98bc: "\xb6\n\u98bc", // 颼
	0x98bd: "\xb6\n\u98bd", // 颽
	0x98be: "\xb6\n\u98be", // 颾
	0x98bf: "\xb6\n\u98bf", // 颿
	0x98c0: "\xb6\n\u98c0", // 飀
	0x98c1: "\xb6\v\u98c1", // 飁
	0x98c2: "\xb6\v\u98c2", // 飂
	0x98c3: "\xb6\v\u98c3", // 飃
	0x98c4: "\xb6\v\u98c4", // 飄
	0x98c5: "\xb6\f\u98c5", // 飅
	0x98c6: "\xb6\f\u98c6", // 飆
	0x98c7: "\xb6\f\u98c7", // 飇
	0x98c8: "\xb6\f\u98c8", // 飈
	0x98c9: "\xb6\f\u98c9", // 飉
	0x98ca: "\xb6\f\u98ca", // 飊
	0x98cb: "\xb6\r\u98cb", // 飋
	0x98cc: "\xb6\x12\u98cc", // 飌
	0x98cd: "\xb6\x12\u98cd", // 飍
	0x98ce: "\xb6\x00\u98ce", // 风
	0x98cf: "\xb6\x03\u98cf", // 飏
	0x98d0: "\xb6\x05\u98d0", // 飐
	0x98d1: "\xb6\x05\u98d1", // 飑
	0x98d2: "\xb6\x05\u98d2", // 飒
	0x98d3: "\xb6\b\u98d3", // 飓
	0x98d4: "\xb6\t\u98d4", // 飔
	0x98d5: "\xb6\n\u98d5", // 飕
	0x98d6: "\xb6\t\u98d6", // 飖
	0x98d7: "\xb6\n\u98d7", // 飗
	0x98d8: "\xb6\v\u98d8", // 飘
	0x98d9: "\xb6\f\u98d9", // 飙
	0x98da: "\xb6\f\u98da", // 飚
	0x98db: "\xb7\x00\u98db", // 飛
	0x98dc: "\xb7\f\u98dc", // 飜
	0x98dd: "\xb7\x12\u98dd", // 飝
	0x98de: "\xb7\x00\u98de", // 飞
	0x98df: "\xb8\x00\u98df", // 食
	0x98e0: "\xb8\x00\u98e0", // 飠
	0x98e1: "\xb8\x02\u98e1", // 飡
	0x98e2: "\xb8\x02\u98e2", // 飢
	0x98e3: "\xb8\x02\u98e3", // 飣
	0x98e4: "\xb8\x02\u98e4", // 飤
	0x98e5: "\xb8\x03\u98e5", // 飥
	0x98e6: "\xb8\x03\u98e6", // 飦
	0x98e7: "\xb8\x03\u98e7", // 飧
	0x98e8: "\xb8\x03\u98e8", // 飨
	0x98e9: "\xb8\x04\u98e9", // 飩
	0x98ea: "\xb8\x04\u98ea", // 飪
	0x98eb: "\xb8\x04\u98eb", // 飫
	0x98ec: "\xb8\x04\u98ec", // 飬
	0x98ed: "\xb8\x04\u98ed", // 飭
	0x98ee: "\xb8\x04\u98ee", // 飮
	0x98ef: "\xb8\x04\u98ef", // 飯
	0x98f0: "\xb8\x04\u98f0", // 飰
	0x98f1: "\xb8\x04\u98f1", // 飱
	0x98f2: "\xb8\x04\u98f2", // 飲
	0x98f3: "\xb8\x05\u98f3", // 飳
	0x98f4: "\xb8\x05\u98f4", // 飴
	0x98f5: "\xb8\x05\u98f5", // 飵
	0x98f6: "\xb8\x05\u98f6", // 飶
	0x98f7: "\xb8\x05\u98f7", // 飷
	0x98f8: "\xb8\x05\u98f8", // 飸
	0x98f9: "\xb8\x05\u98f9", // 飹
	0x98fa: "\xb8\x06\u98fa", // 飺
	0x98fb: "\xb8\x05\u98fb", // 飻
	0x98fc: "\xb8\x05\u98fc", // 飼
	0x98fd: "\xb8\x05\u98fd", // 飽
	0x98fe: "\xb8\x05\u98fe", // 飾
	0x98ff: "\xb8\x05\u98ff", // 飿
	0x9900: "\xb8\x06\u9900", // 餀
	0x9901: "\xb8\x06\u9901", // 餁
	0x9902: "\xb8\x06\u9902", // 餂
	0x9903: "\xb8\x06\u9903", // 餃
	0x9904: "\xb8\x06\u9904", // 餄
	0x9905: "\xb8\x06\u9905", // 餅
	0x9906: "\xb8\x06\u9906", // 餆
	0x9907: "\xb8\x06\u9907", // 餇
	0x9908: "\xb8\x06\u9908", // 餈
	0x9909: "\xb8\x06\u9909", // 餉
	0x990a: "\xb8\x06\u990a", // 養
	0x990b: "\xb8\x06\u990b", // 餋
	0x990c: "\xb8\x06\u990c", // 餌
	0x990d: "\xb8\x06\u990d", // 餍
	0x990e: "\xb8\x06\u990e", // 餎
	0x990f: "\xb8\x06\u990f", // 餏
	0x9910: "\xb8\a\u9910", // 餐
	0x9911: "\xb8\a\u9911", // 餑
	0x9912: "\xb8\a\u9912", // 餒
	0x9913: "\xb8\a\u9913", // 餓
	0x9914: "\xb8\a\u9914", // 餔
	0x9915: "\xb8\a\u9915", // 餕
	0x9916: "\xb8\a\u9916", // 餖
	0x9917: "\xb8\a\u9917", // 餗
	0x9918: "\xb8\a\u9918", // 餘
	0x9919: "\xb8\a\u9919", // 餙
	0x991a: "\xb8\b\u991a", // 餚
	0x991b: "\xb8\b\u991b", // 餛
	0x991c: "\xb8\b\u991c", // 餜
	0x991d: "\xb8\a\u991d", // 餝
	0x991e: "\xb8\b\u991e", // 餞
	0x991f: "\xb8\b\u991f", // 餟
	0x9920: "\xb8\b\u9920", // 餠
	0x9921: "\xb8\b\u9921", // 餡
	0x9922: "\xb8\b\u9922", // 餢
	0x9923: "\xb8\b\u9923", // 餣
	0x9924: "\xb8\b\u9924", // 餤
	0x9925: "\xb8\b\u9925", // 餥
	0x9926: "\xb8\b\u9926", // 餦
	0x9927: "\xb8\b\u9927", // 餧
	0x9928: "\xb8\b\u9928", // 館
	0x9929: "\xb8\b\u9929", // 餩
	0x992a: "\xb8\t\u992a", // 餪
	0x992b: "\xb8\t\u992b", // 餫
	0x992c: "\xb8\t\u992c", // 餬
	0x992d: "\xb8\t\u992d", // 餭
	0x992e: "\xb8\t\u992e", // 餮
	0x992f: "\xb8\t\u992f", // 餯
	0x9930: "\xb8\t\u9930", // 餰
	0x9931: "\xb8\t\u9931", // 餱
	0x9932: "\xb8\t\u9932", // 餲
	0x9933: "\xb8\t\u9933", // 餳
	0x9934: "\xb8\t\u9934", // 餴
	0x9935: "\xb8\t\u9935", // 餵
	0x9936: "\xb8\n\u9936", // 餶
	0x9937: "\xb8\t\u9937", // 餷
	0x9938: "\xb8\n\u9938", // 餸
	0x9939: "\xb8\n\u9939", // 餹
	0x993a: "\xb8\n\u993a", // 餺
	0x993b: "\xb8\n\u993b", // 餻
	0x993c: "\xb8\n\u993c", // 餼
	0x993d: "\xb8\n\u993d", // 餽
	0x993e: "\xb8\n\u993e", // 餾
	0x993f: "\xb8\n\u993f", // 餿
	0x9940: "\xb8\n\u9940", // 饀
	0x9941: "\xb8\n\u9941", // 饁
	0x9942: "\xb8\n\u9942", // 饂
	0x9943: "\xb8\n\u9943", // 饃
	0x9944: "\xb8\v\u9944", // 饄
	0x9945: "\xb8\v\u9945", // 饅
	0x9946: "\xb8\v\u9946", // 饆
	0x9947: "\xb8\v\u9947", // 饇
	0x9948: "\xb8\v\u9948", // 饈
	0x9949: "\xb8\v\u9949", // 饉
	0x994a: "\xb8\f\u994a", // 饊
	0x994b: "\xb8\f\u994b", // 饋
	0x994c: "\xb8\f\u994c", // 饌
	0x994d: "\xb8\f\u994d", // 饍
	0x994e: "\xb8\f\u994e", // 饎
	0x994f: "\xb8\f\u994f", // 饏
	0x9950: "\xb8\f\u9950", // 饐
	0x9951: "\xb8\f\u9951", // 饑
	0x9952: "\xb8\f\u9952", // 饒
	0x9953: "\xb8\f\u9953", // 饓
	0x9954: "\xb8\r\u9954", // 饔
	0x9955: "\xb8\r\u9955", // 饕
	0x9956: "\xb8\r\u9956", // 饖
	0x9957: "\xb8\r\u9957", // 饗
	0x9958: "\xb8\r\u9958", // 饘
	0x9959: "\xb8\r\u9959", // 饙
	0x995a: "\xb8\x0e\u995a", // 饚
	0x995b: "\xb8\x0e\u995b", // 饛
	0x995c: "\xb8\x0e\u995c", // 饜
	0x995d: "\xb8\x10\u995d", // 饝
	0x995e: "\xb8\x11\u995e", // 饞
	0x995f: "\xb8\x11\u995f", // 饟
	0x9960: "\xb8\x13\u9960", // 饠
	0x9961: "\xb8\x13\u9961", // 饡
	0x9962: "\xb8\x16\u9962", // 饢
	0x9963: "\xb8\x00\u9963", // 饣
	0x9964: "\xb8\x02\u9964", // 饤
	0x9965: "\xb8\x02\u9965", // 饥
	0x9966: "\xb8\x03\u9966", // 饦
	0x9967: "\xb8\x03\u9967", // 饧
	0x9968: "\xb8\x04\u9968", // 饨
	0x9969: "\xb8\x04\u9969", // 饩
	0x996a: "\xb8\x04\u996a", // 饪
	0x996b: "\xb8\x04\u996b", // 饫
	0x996c: "\xb8\x04\u996c", // 饬
	0x996d: "\xb8\x04\u996d", // 饭
	0x996e: "\xb8\x04\u996e", // 饮
	0x996f: "\xb8\x05\u996f", // 饯
	0x9970: "\xb8\x05\u9970", // 饰
	0x9971: "\xb8\x05\u9971", // 饱
	0x9972: "\xb8\x05\u9972", // 饲
	0x9973: "\xb8\x05\u9973", // 饳
	0x9974: "\xb8\x05\u9974", // 饴
	0x9975: "\xb8\x06\u9975", // 饵
	0x9976: "\xb8\x06\u9976", // 饶
	0x9977: "\xb8\x06\u9977", // 饷
	0x9978: "\xb8\x06\u9978", // 饸
	0x9979: "\xb8\x06\u9979", // 饹
	0x997a: "\xb8\x06\u997a", // 饺
	0x997b: "\xb8\x06\u997b", // 饻
	0x997c: "\xb8\x06\u997c", // 饼
	0x997d: "\xb8\a\u997d", // 饽
	0x997e: "\xb8\a\u997e", // 饾
	0x997f: "\xb8\a\u997f", // 饿
	0x9980: "\xb8\a\u9980", // 馀
	0x9981: "\xb8\a\u9981", // 馁
	0x9982: "\xb8\a\u9982", // 馂
	0x9983: "\xb8\b\u9983", // 馃
	0x9984: "\xb8\b\u9984", // 馄
	0x9985: "\xb8\b\u9985", // 馅
	0x9986: "\xb8\b\u9986", // 馆
	0x9987: "\xb8\t\u9987", // 馇
	0x9988: "\xb8\t\u9988", // 馈
	0x9989: "\xb8\n\u9989", // 馉
	0x998a: "\xb8\t\u998a", // 馊
	0x998b: "\xb8\t\u998b", // 馋
	0x998c: "\xb8\n\u998c", // 馌
	0x998d: "\xb8\n\u998d", // 馍
	0x998e: "\xb8\n\u998e", // 馎
	0x998f: "\xb8\n\u998f", // 馏
	0x9990: "\xb8\n\u9990", // 馐
	0x9991: "\xb8\v\u9991", // 馑
	0x9992: "\xb8\v\u9992", // 馒
	0x9993: "\xb8\f\u9993", // 馓
	0x9994: "\xb8\f\u9994", // 馔
	0x9995: "\xb8\x16\u9995", // 馕
	0x9996: "\xb9\x00\u9996", // 首
	0x9997: "\xb9\x02\u9997", // 馗
	0x9998: "\xb9\b\u9998", // 馘
	0x9999: "\xba\x00\u9999", // 香
	0x999a: "\xba\x04\u999a", // 馚
	0x999b: "\xba\x05\u999b", // 馛
	0x999c: "\xba\x05\u999c", // 馜
	0x999d: "\xba\x05\u999d", // 馝
	0x999e: "\xba\a\u999e", // 馞
	0x999f: "\xba\a\u999f", // 馟
	0x99a0: "\xba\a\u99a0", // 馠
	0x99a1: "\xba\b\u99a1", // 馡
	0x99a2: "\xba\b\u99a2", // 馢
	0x99a3: "\xba\b\u99a3", // 馣
	0x99a4: "\xba\t\u99a4", // 馤
	0x99a5: "\xba\t\u99a5", // 馥
	0x99a6: "\xba\n\u99a6", // 馦
	0x99a7: "\xba\n\u99a7", // 馧
	0x99a8: "\xba\v\u99a8", // 馨
	0x99a9: "\xba\f\u99a9", // 馩
	0x99aa: "\xba\x0e\u99aa", // 馪
	0x99ab: "\xba\x12\u99ab", // 馫
	0x99ac: "\xbb\x00\u99ac", // 馬
	0x99ad: "\xbb\x02\u99ad", // 馭
	0x99ae: "\xbb\x02\u99ae", // 馮
	0x99af: "\xbb\x03\u99af", // 馯
	0x99b0: "\xbb\x03\u99b0", // 馰
	0x99b1: "\xbb\x03\u99b1", // 馱
	0x99b2: "\xbb\x03\u99b2", // 馲
	0x99b3: "\xbb\x03\u99b3", // 馳
	0x99b4: "\xbb\x03\u99b4", // 馴
	0x99b5: "\xbb\x03\u99b5", // 馵
	0x99b6: "\xbb\x04\u99b6", // 馶
	0x99b7: "\xbb\x04\u99b7", // 馷
	0x99b8: "\xbb\x04\u99b8", // 馸
	0x99b9: "\xbb\x04\u99b9", // 馹
	0x99ba: "\xbb\x04\u99ba", // 馺
	0x99bb: "\xbb\x04\u99bb", // 馻
	0x99bc: "\xbb\x04\u99bc", // 馼
	0x99bd: "\xbb\x04\u99bd", // 馽
	0x99be: "\xbb\x04\u99be", // 馾
	0x99bf: "\xbb\x04\u99bf", // 馿
	0x99c0: "\xbb\x04\u99c0", // 駀
	0x99c1: "\xbb\x04\u99c1", // 駁
	0x99c2: "\xbb\x04\u99c2", // 駂
	0x99c3: "\xbb\x04\u99c3", // 駃
	0x99c4: "\xbb\x04\u99c4", // 駄
	0x99c5: "\xbb\x04\u99c5", // 駅
	0x99c6: "\xbb\x04\u99c6", // 駆
	0x99c7: "\xbb\x04\u99c7", // 駇
	0x99c8: "\xbb\x05\u99c8", // 駈
	0x99c9: "\xbb\x05\u99c9", // 駉
	0x99ca: "\xbb\x05\u99ca", // 駊
	0x99cb: "\xbb\x05\u99cb", // 駋
	0x99cc: "\xbb\x05\u99cc", // 駌
	0x99cd: "\xbb\x05\u99cd", // 駍
	0x99ce: "\xbb\x05\u99ce", // 駎
	0x99cf: "\xbb\x05\u99cf", // 駏
	0x99d0: "\xbb\x05\u99d0", // 駐
	0x99d1: "\xbb\x05\u99d1", // 駑
	0x99d2: "\xbb\x05\u99d2", // 駒
	0x99d3: "\xbb\x05\u99d3", // 駓
	0x99d4: "\xbb\x05\u99d4", // 駔
	0x99d5: "\xbb\x05\u99d5", // 駕
	0x99d6: "\xbb\x05\u99d6", // 駖
	0x99d7: "\xbb\x05\u99d7", // 駗
	0x99d8: "\xbb\x05\u99d8", // 駘
	0x99d9: "\xbb\x05\u99d9", // 駙
	0x99da: "\xbb\x05\u99da", // 駚
	0x99db: "\xbb\x05\u99db", // 駛
	0x99dc: "\xbb\x05\u99dc", // 駜
	0x99dd: "\xbb\x05\u99dd", // 駝
	0x99de: "\xbb\x05\u99de", // 駞
	0x99df: "\xbb\x05\u99df", // 駟
	0x99e0: "\xbb\x05\u99e0", // 駠
	0x99e1: "\xbb\x06\u99e1", // 駡
	0x99e2: "\xbb\x06\u99e2", // 駢
	0x99e3: "\xbb\x06\u99e3", // 駣
	0x99e4: "\xbb\x06\u99e4", // 駤
	0x99e5: "\xbb\x06\u99e5", // 駥
	0x99e6: "\xbb\x06\u99e6", // 駦
	0x99e7: "\xbb\x06\u99e7", // 駧
	0x99e8: "\xbb\x06\u99e8", // 駨
	0x99e9: "\xbb\x06\u99e9", // 駩
	0x99ea: "\xbb\x06\u99ea", // 駪
	0x99eb: "\xbb\x06\u99eb", // 駫
	0x99ec: "\xbb\x06\u99ec", // 駬
	0x99ed: "\xbb\x06\u99ed", // 駭
	0x99ee: "\xbb\x06\u99ee", // 駮
	0x99ef: "\xbb\x06\u99ef", // 駯
	0x99f0: "\xbb\x06\u99f0", // 駰
	0x99f1: "\xbb\x06\u99f1", // 駱
	0x99f2: "\xbb\x06\u99f2", // 駲
	0x99f3: "\xbb\b\u99f3", // 駳
	0x99f4: "\xbb\a\u99f4", // 駴
	0x99f5: "\xbb\a\u99f5", // 駵
	0x99f6: "\xbb\a\u99f6", // 駶
	0x99f7: "\xbb\a\u99f7", // 駷
	0x99f8: "\xbb\a\u99f8", // 駸
	0x99f9: "\xbb\a\u99f9", // 駹
	0x99fa: "\xbb\a\u99fa", // 駺
	0x99fb: "\xbb\a\u99fb", // 駻
	0x99fc: "\xbb\a\u99fc", // 駼
	0x99fd: "\xbb\a\u99fd", // 駽
	0x99fe: "\xbb\a\u99fe", // 駾
	0x99ff: "\xbb\a\u99ff", // 駿
	0x9a00: "\xbb\a\u9a00", // 騀
	0x9a01: "\xbb\a\u9a01", // 騁
	0x9a02: "\xbb\a\u9a02", // 騂
	0x9a03: "\xbb\a\u9a03", // 騃
	0x9a04: "\xbb\b\u9a04", // 騄
	0x9a05: "\xbb\b\u9a05", // 騅
	0x9a06: "\xbb\b\u9a06", // 騆
	0x9a07: "\xbb\b\u9a07", // 騇
	0x9a08: "\xbb\b\u9a08", // 騈
	0x9a09: "\xbb\b\u9a09", // 騉
	0x9a0a: "\xbb\b\u9a0a", // 騊
	0x9a0b: "\xbb\b\u9a0b", // 騋
	0x9a0c: "\xbb\b\u9a0c", // 騌
	0x9a0d: "\xbb\b\u9a0d", // 騍
	0x9a0e: "\xbb\b\u9a0e", // 騎
	0x9a0f: "\xbb\b\u9a0f", // 騏
	0x9a10: "\xbb\b\u9a10", // 騐
	0x9a11: "\xbb\b\u9a11", // 騑
	0x9a12: "\xbb\b\u9a12", // 騒
	0x9a13: "\xbb\b\u9a13", // 験
	0x9a14: "\xbb\t\u9a14", // 騔
	0x9a15: "\xbb\t\u9a15", // 騕
	0x9a16: "\xbb\t\u9a16", // 騖
	0x9a17: "\xbb\t\u9a17", // 騗
	0x9a18: "\xbb\t\u9a18", // 騘
	0x9a19: "\xbb\t\u9a19", // 騙
	0x9a1a: "\xbb\t\u9a1a", // 騚
	0x9a1b: "\xbb\t\u9a1b", // 騛
	0x9a1c: "\xbb\t\u9a1c", // 騜
	0x9a1d: "\xbb\t\u9a1d", // 騝
	0x9a1e: "\xbb\t\u9a1e", // 騞
	0x9a1f: "\xbb\t\u9a1f", // 騟
	0x9a20: "\xbb\t\u9a20", // 騠
	0x9a21: "\xbb\t\u9a21", // 騡
	0x9a22: "\xbb\t\u9a22", // 騢
	0x9a23: "\xbb\t\u9a23", // 騣
	0x9a24: "\xbb\t\u9a24", // 騤
	0x9a25: "\xbb\t\u9a25", // 騥
	0x9a26: "\xbb\t\u9a26", // 騦
	0x9a27: "\xbb\t\u9a27", // 騧
	0x9a28: "\xbb\t\u9a28", // 騨
	0x9a29: "\xbb\n\u9a29", // 騩
	0x9a2a: "\xbb\n\u9a2a", // 騪
	0x9a2b: "\xbb\n\u9a2b", // 騫
	0x9a2c: "\xbb\n\u9a2c", // 騬
	0x9a2d: "\xbb\n\u9a2d", // 騭
	0x9a2e: "\xbb\n\u9a2e", // 騮
	0x9a2f: "\xbb\n\u9a2f", // 騯
	0x9a30: "\xbb\n\u9a30", // 騰
	0x9a31: "\xbb\n\u9a31", // 騱
	0x9a32: "\xbb\n\u9a32", // 騲
	0x9a33: "\xbb\n\u9a33", // 騳
	0x9a34: "\xbb\n\u9a34", // 騴
	0x9a35: "\xbb\n\u9a35", // 騵
	0x9a36: "\xbb\n\u9a36", // 騶
	0x9a37: "\xbb\n\u9a37", // 騷
	0x9a38: "\xbb\n\u9a38", // 騸
	0x9a39: "\xbb\v\u9a39", // 騹
	0x9a3a: "\xbb\v\u9a3a", // 騺
	0x9a3b: "\xbb\v\u9a3b", // 騻
	0x9a3c: "\xbb\v\u9a3c", // 騼
	0x9a3d: "\xbb\v\u9a3d", // 騽
	0x9a3e: "\xbb\v\u9a3e", // 騾
	0x9a3f: "\xbb\v\u9a3f", // 騿
	0x9a40: "\xbb\v\u9a40", // 驀
	0x9a41: "\xbb\v\u9a41", // 驁
	0x9a42: "\xbb\v\u9a42", // 驂
	0x9a43: "\xbb\v\u9a43", // 驃
	0x9a44: "\xbb\v\u9a44", // 驄
	0x9a45: "\xbb\v\u9a45", // 驅
	0x9a46: "\xbb\v\u9a46", // 驆
	0x9a47: "\xbb\v\u9a47", // 驇
	0x9a48: "\xbb\f\u9a48", // 驈
	0x9a49: "\xbb\f\u9a49", // 驉
	0x9a4a: "\xbb\f\u9a4a", // 驊
	0x9a4b: "\xbb\f\u9a4b", // 驋
	0x9a4c: "\xbb\f\u9a4c", // 驌
	0x9a4d: "\xbb\f\u9a4d", // 驍
	0x9a4e: "\xbb\f\u9a4e", // 驎
	0x9a4f: "\xbb\f\u9a4f", // 驏
	0x9a50: "\xbb\f\u9a50", // 驐
	0x9a51: "\xbb\f\u9a51", // 驑
	0x9a52: "\xbb\f\u9a52", // 驒
	0x9a53: "\xbb\f\u9a53", // 驓
	0x9a54: "\xbb\f\u9a54", // 驔
	0x9a55: "\xbb\f\u9a55", // 驕
	0x9a56: "\xbb\r\u9a56", // 驖
	0x9a57: "\xbb\r\u9a57", // 驗
	0x9a58: "\xbb\r\u9a58", // 驘
	0x9a59: "\xbb\r\u9a59", // 驙
	0x9a5a: "\xbb\r\u9a5a", // 驚
	0x9a5b: "\xbb\r\u9a5b", // 驛
	0x9a5c: "\xbb\r\u9a5c", // 驜
	0x9a5d: "\xbb\x0e\u9a5d", // 驝
	0x9a5e: "\xbb\x0e\u9a5e", // 驞
	0x9a5f: "\xbb\x0e\u9a5f", // 驟
	0x9a60: "\xbb\x10\u9a60", // 驠
	0x9a61: "\xbb\x10\u9a61", // 驡
	0x9a62: "\xbb\x10\u9a62", // 驢
	0x9a63: "\xbb\x10\u9a63", // 驣
	0x9a64: "\xbb\x11\u9a64", // 驤
	0x9a65: "\xbb\x11\u9a65", // 驥
	0x9a66: "\xbb\x11\u9a66", // 驦
	0x9a67: "\xbb\x11\u9a67", // 驧
	0x9a68: "\xbb\x12\u9a68", // 驨
	0x9a69: "\xbb\x12\u9a69", // 驩
	0x9a6a: "\xbb\x13\u9a6a", // 驪
	0x9a6b: "\xbb\x14\u9a6b", // 驫
	0x9a6c: "\xbb\x00\u9a6c", // 马
	0x9a6d: "\xbb\x02\u9a6d", // 驭
	0x9a6e: "\xbb\x03\u9a6e", // 驮
	0x9a6f: "\xbb\x03\u9a6f", // 驯
	0x9a70: "\xbb\x03\u9a70", // 驰
	0x9a71: "\xbb\x04\u9a71", // 驱
	0x9a72: "\xbb\x04\u9a72", // 驲
	0x9a73: "\xbb\x04\u9a73", // 驳
	0x9a74: "\xbb\x04\u9a74", // 驴
	0x9a75: "\xbb\x05\u9a75", // 驵
	0x9a76: "\xbb\x05\u9a76", // 驶
	0x9a77: "\xbb\x05\u9a77", // 驷
	0x9a78: "\xbb\x05\u9a78", // 驸
	0x9a79: "\xbb\x05\u9a79", // 驹
	0x9a7a: "\xbb\x05\u9a7a", // 驺
	0x9a7b: "\xbb\x05\u9a7b", // 驻
	0x9a7c: "\xbb\x05\u9a7c", // 驼
	0x9a7d: "\xbb\x05\u9a7d", // 驽
	0x9a7e: "\xbb\x05\u9a7e", // 驾
	0x9a7f: "\xbb\x05\u9a7f", // 驿
	0x9a80: "\xbb\x05\u9a80", // 骀
	0x9a81: "\xbb\x06\u9a81", // 骁
	0x9a82: "\xbb\x06\u9a82", // 骂
	0x9a83: "\xbb\x06\u9a83", // 骃
	0x9a84: "\xbb\x06\u9a84", // 骄
	0x9a85: "\xbb\x06\u9a85", // 骅
	0x9a86: "\xbb\x06\u9a86", // 骆
	0x9a87: "\xbb\x06\u9a87", // 骇
	0x9a88: "\xbb\x06\u9a88", // 骈
	0x9a89: "\xbb\x06\u9a89", // 骉
	0x9a8a: "\xbb\a\u9a8a", // 骊
	0x9a8b: "\xbb\a\u9a8b", // 骋
	0x9a8c: "\xbb\a\u9a8c", // 验
	0x9a8d: "\xbb\a\u9a8d", // 骍
	0x9a8e: "\xbb\a\u9a8e", // 骎
	0x9a8f: "\xbb\a\u9a8f", // 骏
	0x9a90: "\xbb\b\u9a90", // 骐
	0x9a91: "\xbb\b\u9a91", // 骑
	0x9a92: "\xbb\b\u9a92", // 骒
	0x9a93: "\xbb\b\u9a93", // 骓
	0x9a94: "\xbb\b\u9a94", // 骔
	0x9a95: "\xbb\b\u9a95", // 骕
	0x9a96: "\xbb\b\u9a96", // 骖
	0x9a97: "\xbb\t\u9a97", // 骗
	0x9a98: "\xbb\t\u9a98", // 骘
	0x9a99: "\xbb\t\u9a99", // 骙
	0x9a9a: "\xbb\t\u9a9a", // 骚
	0x9a9b: "\xbb\t\u9a9b", // 骛
	0x9a9c: "\xbb\n\u9a9c", // 骜
	0x9a9d: "\xbb\n\u9a9d", // 骝
	0x9a9e: "\xbb\n\u9a9e", // 骞
	0x9a9f: "\xbb\n\u9a9f", // 骟
	0x9aa0: "\xbb\v\u9aa0", // 骠
	0x9aa1: "\xbb\v\u9aa1", // 骡
	0x9aa2: "\xbb\v\u9aa2", // 骢
	0x9aa3: "\xbb\f\u9aa3", // 骣
	0x9aa4: "\xbb\x0e\u9aa4", // 骤
	0x9aa5: "\xbb\x10\u9aa5", // 骥
	0x9aa6: "\xbb\x11\u9aa6", // 骦
	0x9aa7: "\xbb\x11\u9aa7", // 骧
	0x9aa8: "\xbc\x00\u9aa8", // 骨
	0x9aa9: "\xbc\x02\u9aa9", // 骩
	0x9aaa: "\xbc\x03\u9aaa", // 骪
	0x9aab: "\xbc\x03\u9aab", // 骫
	0x9aac: "\xbc\x03\u9aac", // 骬
	0x9aad: "\xbc\x03\u9aad", // 骭
	0x9aae: "\xbc\x03\u9aae", // 骮
	0x9aaf: "\xbc\x04\u9aaf", // 骯
	0x9ab0: "\xbc\x04\u9ab0", // 骰
	0x9ab1: "\xbc\x04\u9ab1", // 骱
	0x9ab2: "\xbc\x05\u9ab2", // 骲
	0x9ab3: "\xbc\x05\u9ab3", // 骳
	0x9ab4: "\xbc\x05\u9ab4", // 骴
	0x9ab5: "\xbc\x05\u9ab5", // 骵
	0x9ab6: "\xbc\x05\u9ab6", // 骶
	0x9ab7: "\xbc\x05\u9ab7", // 骷
	0x9ab8: "\xbc\x06\u9ab8", // 骸
	0x9ab9: "\xbc\x06\u9ab9", // 骹
	0x9aba: "\xbc\x06\u9aba", // 骺
	0x9abb: "\xbc\x06\u9abb", // 骻
	0x9abc: "\xbc\x06\u9abc", // 骼
	0x9abd: "\xbc\a\u9abd", // 骽
	0x9abe: "\xbc\a\u9abe", // 骾
	0x9abf: "\xbc\b\u9abf", // 骿
	0x9ac0: "\xbc\b\u9ac0", // 髀
	0x9ac1: "\xbc\b\u9ac1", // 髁
	0x9ac2: "\xbc\t\u9ac2", // 髂
	0x9ac3: "\xbc\t\u9ac3", // 髃
	0x9ac4: "\xbc\t\u9ac4", // 髄
	0x9ac5: "\xbc\t\u9ac5", // 髅
	0x9ac6: "\xbc\n\u9ac6", // 髆
	0x9ac7: "\xbc\n\u9ac7", // 髇
	0x9ac8: "\xbc\n\u9ac8", // 髈
	0x9ac9: "\xbc\n\u9ac9", // 髉
	0x9aca: "\xbc\n\u9aca", // 髊
	0x9acb: "\xbc\n\u9acb", // 髋
	0x9acc: "\xbc\n\u9acc", // 髌
	0x9acd: "\xbc\v\u9acd", // 髍
	0x9ace: "\xbc\v\u9ace", // 髎
	0x9acf: "\xbc\v\u9acf", // 髏
	0x9ad0: "\xbc\f\u9ad0", // 髐
	0x9ad1: "\xbc\r\u9ad1", // 髑
	0x9ad2: "\xbc\r\u9ad2", // 髒
	0x9ad3: "\xbc\r\u9ad3", // 髓
	0x9ad4: "\xbc\r\u9ad4", // 體
	0x9ad5: "\xbc\x0e\u9ad5", // 髕
	0x9ad6: "\xbc\x0f\u9ad6", // 髖
	0x9ad7: "\xbc\x10\u9ad7", // 髗
	0x9ad8: "\xbd\x00\u9ad8", // 高
	0x9ad9: "\xbd\x00\u9ad9", // 髙
	0x9ada: "\xbd\x04\u9ada", // 髚
	0x9adb: "\xbd\x05\u9adb", // 髛
	0x9adc: "\xbd\b\u9adc", // 髜
	0x9add: "\xbd\f\u9add", // 髝
	0x9ade: "\xbd\r\u9ade", // 髞
	0x9adf: "\xbe\x00\u9adf", // 髟
	0x9ae0: "\xbe\x02\u9ae0", // 髠
	0x9ae1: "\xbe\x03\u9ae1", // 髡
	0x9ae2: "\xbe\x03\u9ae2", // 髢
	0x9ae3: "\xbe\x04\u9ae3", // 髣
	0x9ae4: "\xbe\x04\u9ae4", // 髤
	0x9ae5: "\xbe\x04\u9ae5", // 髥
	0x9ae6: "\xbe\x04\u9ae6", // 髦
	0x9ae7: "\xbe\x04\u9ae7", // 髧
	0x9ae8: "\xbe\x04\u9ae8", // 髨
	0x9ae9: "\xbe\x04\u9ae9", // 髩
	0x9aea: "\xbe\x04\u9aea", // 髪
	0x9aeb: "\xbe\x05\u9aeb", // 髫
	0x9aec: "\xbe\x05\u9aec", // 髬
	0x9aed: "\xbe\x05\u9aed", // 髭
	0x9aee: "\xbe\x05\u9aee", // 髮
	0x9aef: "\xbe\x05\u9aef", // 髯
	0x9af0: "\xbe\x05\u9af0", // 髰
	0x9af1: "\xbe\x05\u9af1", // 髱
	0x9af2: "\xbe\x05\u9af2", // 髲
	0x9af3: "\xbe\x05\u9af3", // 髳
	0x9af4: "\xbe\x05\u9af4", // 髴
	0x9af5: "\xbe\x06\u9af5", // 髵
	0x9af6: "\xbe\x06\u9af6", // 髶
	0x9af7: "\xbe\x06\u9af7", // 髷
	0x9af8: "\xbe\x06\u9af8", // 髸
	0x9af9: "\xbe\x06\u9af9", // 髹
	0x9afa: "\xbe\x06\u9afa", // 髺
	0x9afb: "\xbe\x06\u9afb", // 髻
	0x9afc: "\xbe\a\u9afc", // 髼
	0x9afd: "\xbe\a\u9afd", // 髽
	0x9afe: "\xbe\a\u9afe", // 髾
	0x9aff: "\xbe\a\u9aff", // 髿
	0x9b00: "\xbe\a\u9b00", // 鬀
	0x9b01: "\xbe\a\u9b01", // 鬁
	0x9b02: "\xbe\a\u9b02", // 鬂
	0x9b03: "\xbe\b\u9b03", // 鬃
	0x9b04: "\xbe\b\u9b04", // 鬄
	0x9b05: "\xbe\b\u9b05", // 鬅
	0x9b06: "\xbe\b\u9b06", // 鬆
	0x9b07: "\xbe\x06\u9b07", // 鬇
	0x9b08: "\xbe\b\u9b08", // 鬈
	0x9b09: "\xbe\t\u9b09", // 鬉
	0x9b0a: "\xbe\t\u9b0a", // 鬊
	0x9b0b: "\xbe\t\u9b0b", // 鬋
	0x9b0c: "\xbe\t\u9b0c", // 鬌
	0x9b0d: "\xbe\t\u9b0d", // 鬍
	0x9b0e: "\xbe\t\u9b0e", // 鬎
	0x9b0f: "\xbe\t\u9b0f", // 鬏
	0x9b10: "\xbe\n\u9b10", // 鬐
	0x9b11: "\xbe\n\u9b11", // 鬑
	0x9b12: "\xbe\n\u9b12", // 鬒
	0x9b13: "\xbe\n\u9b13", // 鬓
	0x9b14: "\xbe\v\u9b14", // 鬔
	0x9b15: "\xbe\v\u9b15", // 鬕
	0x9b16: "\xbe\v\u9b16", // 鬖
	0x9b17: "\xbe\v\u9b17", // 鬗
	0x9b18: "\xbe\v\u9b18", // 鬘
	0x9b19: "\xbe\f\u9b19", // 鬙
	0x9b1a: "\xbe\f\u9b1a", // 鬚
	0x9b1b: "\xbe\f\u9b1b", // 鬛
	0x9b1c: "\xbe\f\u9b1c", // 鬜
	0x9b1d: "\xbe\v\u9b1d", // 鬝
	0x9b1e: "\xbe\r\u9b1e", // 鬞
	0x9b1f: "\xbe\r\u9b1f", // 鬟
	0x9b20: "\xbe\r\u9b20", // 鬠
	0x9b21: "\xbe\x0e\u9b21", // 鬡
	0x9b22: "\xbe\x0e\u9b22", // 鬢
	0x9b23: "\xbe\x0f\u9b23", // 鬣
	0x9b24: "\xbe\x11\u9b24", // 鬤
	0x9b25: "\xbf\x00\u9b25", // 鬥
	0x9b26: "\xbf\x04\u9b26", // 鬦
	0x9b27: "\xbf\x05\u9b27", // 鬧
	0x9b28: "\xbf\x06\u9b28", // 鬨
	0x9b29: "\xbf\b\u9b29", // 鬩
	0x9b2a: "\xbf\n\u9b2a", // 鬪
	0x9b2b: "\xbf\f\u9b2b", // 鬫
	0x9b2c: "\xbf\x0e\u9b2c", // 鬬
	0x9b2d: "\xbf\x0e\u9b2d", // 鬭
	0x9b2e: "\xbf\x11\u9b2e", // 鬮
	0x9b2f: "\xc0\x00\u9b2f", // 鬯
	0x9b30: "\xc0\x11\u9b30", // 鬰
	0x9b31: "\xc0\x13\u9b31", // 鬱
	0x9b32: "\xc1\x00\u9b32", // 鬲
	0x9b33: "\xc1\x06\u9b33", // 鬳
	0x9b34: "\xc1\a\u9b34", // 鬴
	0x9b35: "\xc1\b\u9b35", // 鬵
	0x9b36: "\xc1\b\u9b36", // 鬶
	0x9b37: "\xc1\t\u9b37", // 鬷
	0x9b38: "\xc1\n\u9b38", // 鬸
	0x9b39: "\xc1\v\u9b39", // 鬹
	0x9b3a: "\xc1\v\u9b3a", // 鬺
	0x9b3b: "\xc1\f\u9b3b", // 鬻
	0x9b3c: "\xc2\x00\u9b3c", // 鬼
	0x9b3d: "\xc2\x03\u9b3d", // 鬽
	0x9b3e: "\xc2\x04\u9b3e", // 鬾
	0x9b3f: "\xc2\x04\u9b3f", // 鬿
	0x9b40: "\xc2\x04\u9b40", // 魀
	0x9b41: "\xc2\x04\u9b41", // 魁
	0x9b42: "\xc2\x04\u9b42", // 魂
	0x9b43: "\xc2\x05\u9b43", // 魃
	0x9b44: "\xc2\x05\u9b44", // 魄
	0x9b45: "\xc2\x05\u9b45", // 魅
	0x9b46: "\xc2\x05\u9b46", // 魆
	0x9b47: "\xc2\x06\u9b47", // 魇
	0x9b48: "\xc2\a\u9b48", // 魈
	0x9b49: "\xc2\a\u9b49", // 魉
	0x9b4a: "\xc2\b\u9b4a", // 魊
	0x9b4b: "\xc2\b\u9b4b", // 魋
	0x9b4c: "\xc2\b\u9b4c", // 魌
	0x9b4d: "\xc2\b\u9b4d", // 魍
	0x9b4e: "\xc2\b\u9b4e", // 魎
	0x9b4f: "\xc2\b\u9b4f", // 魏
	0x9b50: "\xc2\n\u9b50", // 魐
	0x9b51: "\xc2\v\u9b51", // 魑
	0x9b52: "\xc2\v\u9b52", // 魒
	0x9b53: "\xc2\v\u9b53", // 魓
	0x9b54: "\xc2\v\u9b54", // 魔
	0x9b55: "\xc2\f\u9b55", // 魕
	0x9b56: "\xc2\f\u9b56", // 魖
	0x9b57: "\xc2\x0e\u9b57", // 魗
	0x9b58: "\xc2\x0e\u9b58", // 魘
	0x9b59: "\xc2\x0e\u9b59", // 魙
	0x9b5a: "\xc3\x00\u9b5a", // 魚
	0x9b5b: "\xc3\x02\u9b5b", // 魛
	0x9b5c: "\xc3\x02\u9b5c", // 魜
	0x9b5d: "\xc3\x02\u9b5d", // 魝
	0x9b5e: "\xc3\x02\u9b5e", // 魞
	0x9b5f: "\xc3\x03\u9b5f", // 魟
	0x9b60: "\xc3\x03\u9b60", // 魠
	0x9b61: "\xc3\x03\u9b61", // 魡
	0x9b62: "\xc3\x03\u9b62", // 魢
	0x9b63: "\xc3\x04\u9b63", // 魣
	0x9b64: "\xc3\x04\u9b64", // 魤
	0x9b65: "\xc3\x04\u9b65", // 魥
	0x9b66: "\xc3\x04\u9b66", // 魦
	0x9b67: "\xc3\x04\u9b67", // 魧
	0x9b68: "\xc3\x04\u9b68", // 魨
	0x9b69: "\xc3\x04\u9b69", // 魩
	0x9b6a: "\xc3\x04\u9b6a", // 魪
	0x9b6b: "\xc3\x04\u9b6b", // 魫
	0x9b6c: "\xc3\x04\u9b6c", // 魬
	0x9b6d: "\xc3\x04\u9b6d", // 魭
	0x9b6e: "\xc3\x04\u9b6e", // 魮
	0x9b6f: "\xc3\x04\u9b6f", // 魯
	0x9b70: "\xc3\x04\u9b70", // 魰
	0x9b71: "\xc3\x04\u9b71", // 魱
	0x9b72: "\xc3\x04\u9b72", // 魲
	0x9b73: "\xc3\x04\u9b73", // 魳
	0x9b74: "\xc3\x04\u9b74", // 魴
	0x9b75: "\xc3\x04\u9b75", // 魵
	0x9b76: "\xc3\x04\u9b76", // 魶
	0x9b77: "\xc3\x04\u9b77", // 魷
	0x9b78: "\xc3\x04\u9b78", // 魸
	0x9b79: "\xc3\x04\u9b79", // 魹
	0x9b7a: "\xc3\x05\u9b7a", // 魺
	0x9b7b: "\xc3\x05\u9b7b", // 魻
	0x9b7c: "\xc3\x05\u9b7c", // 魼
	0x9b7d: "\xc3\x05\u9b7d", // 魽
	0x9b7e: "\xc3\x05\u9b7e", // 魾
	0x9b7f: "\xc3\x05\u9b7f", // 魿
	0x9b80: "\xc3\x05\u9b80", // 鮀
	0x9b81: "\xc3\x05\u9b81", // 鮁
	0x9b82: "\xc3\x05\u9b82", // 鮂
	0x9b83: "\xc3\x05\u9b83", // 鮃
	0x9b84: "\xc3\x05\u9b84", // 鮄
	0x9b85: "\xc3\x05\u9b85", // 鮅
	0x9b86: "\xc3\x05\u9b86", // 鮆
	0x9b87: "\xc3\x05\u9b87", // 鮇
	0x9b88: "\xc3\x05\u9b88", // 鮈
	0x9b89: "\xc3\x05\u9b89", // 鮉
	0x9b8a: "\xc3\x05\u9b8a", // 鮊
	0x9b8b: "\xc3\x05\u9b8b", // 鮋
	0x9b8c: "\xc3\x05\u9b8c", // 鮌
	0x9b8d: "\xc3\x05\u9b8d", // 鮍
	0x9b8e: "\xc3\x05\u9b8e", // 鮎
	0x9b8f: "\xc3\x05\u9b8f", // 鮏
	0x9b90: "\xc3\x05\u9b90", // 鮐
	0x9b91: "\xc3\x05\u9b91", // 鮑
	0x9b92: "\xc3\x05\u9b92", // 鮒
	0x9b93: "\xc3\x05\u9b93", // 鮓
	0x9b94: "\xc3\x05\u9b94", // 鮔
	0x9b95: "\xc3\x05\u9b95", // 鮕
	0x9b96: "\xc3\x05\u9b96", // 鮖
	0x9b97: "\xc3\x05\u9b97", // 鮗
	0x9b98: "\xc3\x05\u9b98", // 鮘
	0x9b99: "\xc3\x06\u9b99", // 鮙
	0x9b9a: "\xc3\x06\u9b9a", // 鮚
	0x9b9b: "\xc3\x06\u9b9b", // 鮛
	0x9b9c: "\xc3\x06\u9b9c", // 鮜
	0x9b9d: "\xc3\x06\u9b9d", // 鮝
	0x9b9e: "\xc3\x06\u9b9e", // 鮞
	0x9b9f: "\xc3\x06\u9b9f", // 鮟
	0x9ba0: "\xc3\x06\u9ba0", // 鮠
	0x9ba1: "\xc3\x06\u9ba1", // 鮡
	0x9ba2: "\xc3\x06\u9ba2", // 鮢
	0x9ba3: "\xc3\x05\u9ba3", // 鮣
	0x9ba4: "\xc3\x06\u9ba4", // 鮤
	0x9ba5: "\xc3\x06\u9ba5", // 鮥
	0x9ba6: "\xc3\x06\u9ba6", // 鮦
	0x9ba7: "\xc3\x06\u9ba7", // 鮧
	0x9ba8: "\xc3\x06\u9ba8", // 鮨
	0x9ba9: "\xc3\x06\u9ba9", // 鮩
	0x9baa: "\xc3\x06\u9baa", // 鮪
	0x9bab: "\xc3\x06\u9bab", // 鮫
	0x9bac: "\xc3\x06\u9bac", // 鮬
	0x9bad: "\xc3\x06\u9bad", // 鮭
	0x9bae: "\xc3\x06\u9bae", // 鮮
	0x9baf: "\xc3\x06\u9baf", // 鮯
	0x9bb0: "\xc3\x06\u9bb0", // 鮰
	0x9bb1: "\xc3\x06\u9bb1", // 鮱
	0x9bb2: "\xc3\x06\u9bb2", // 鮲
	0x9bb3: "\xc3\x06\u9bb3", // 鮳
	0x9bb4: "\xc3\x06\u9bb4", // 鮴
	0x9bb5: "\xc3\a\u9bb5", // 鮵
	0x9bb6: "\xc3\a\u9bb6", // 鮶
	0x9bb7: "\xc3\a\u9bb7", // 鮷
	0x9bb8: "\xc3\a\u9bb8", // 鮸
	0x9bb9: "\xc3\a\u9bb9", // 鮹
	0x9bba: "\xc3\x06\u9bba", // 鮺
	0x9bbb: "\xc3\a\u9bbb", // 鮻
	0x9bbc: "\xc3\a\u9bbc", // 鮼
	0x9bbd: "\xc3\a\u9bbd", // 鮽
	0x9bbe: "\xc3\a\u9bbe", // 鮾
	0x9bbf: "\xc3\a\u9bbf", // 鮿
	0x9bc0: "\xc3\a\u9bc0", // 鯀
	0x9bc1: "\xc3\a\u9bc1", // 鯁
	0x9bc2: "\xc3\a\u9bc2", // 鯂
	0x9bc3: "\xc3\a\u9bc3", // 鯃
	0x9bc4: "\xc3\a\u9bc4", // 鯄
	0x9bc5: "\xc3\a\u9bc5", // 鯅
	0x9bc6: "\xc3\a\u9bc6", // 鯆
	0x9bc7: "\xc3\a\u9bc7", // 鯇
	0x9bc8: "\xc3\a\u9bc8", // 鯈
	0x9bc9: "\xc3\a\u9bc9", // 鯉
	0x9bca: "\xc3\a\u9bca", // 鯊
	0x9bcb: "\xc3\a\u9bcb", // 鯋
	0x9bcc: "\xc3\a\u9bcc", // 鯌
	0x9bcd: "\xc3\a\u9bcd", // 鯍
	0x9bce: "\xc3\a\u9bce", // 鯎
	0x9bcf: "\xc3\a\u9bcf", // 鯏
	0x9bd0: "\xc3\a\u9bd0", // 鯐
	0x9bd1: "\xc3\a\u9bd1", // 鯑
	0x9bd2: "\xc3\a\u9bd2", // 鯒
	0x9bd3: "\xc3\a\u9bd3", // 鯓
	0x9bd4: "\xc3\b\u9bd4", // 鯔
	0x9bd5: "\xc3\b\u9bd5", // 鯕
	0x9bd6: "\xc3\b\u9bd6", // 鯖
	0x9bd7: "\xc3\b\u9bd7", // 鯗
	0x9bd8: "\xc3\b\u9bd8", // 鯘
	0x9bd9: "\xc3\b\u9bd9", // 鯙
	0x9bda: "\xc3\b\u9bda", // 鯚
	0x9bdb: "\xc3\b\u9bdb", // 鯛
	0x9bdc: "\xc3\b\u9bdc", // 鯜
	0x9bdd: "\xc3\b\u9bdd", // 鯝
	0x9bde: "\xc3\b\u9bde", // 鯞
	0x9bdf: "\xc3\b\u9bdf", // 鯟
	0x9be0: "\xc3\b\u9be0", // 鯠
	0x9be1: "\xc3\b\u9be1", // 鯡
	0x9be2: "\xc3\b\u9be2", // 鯢
	0x9be3: "\xc3\b\u9be3", // 鯣
	0x9be4: "\xc3\b\u9be4", // 鯤
	0x9be5: "\xc3\b\u9be5", // 鯥
	0x9be6: "\xc3\b\u9be6", // 鯦
	0x9be7: "\xc3\b\u9be7", // 鯧
	0x9be8: "\xc3\b\u9be8", // 鯨
	0x9be9: "\xc3\b\u9be9", // 鯩
	0x9bea: "\xc3\b\u9bea", // 鯪
	0x9beb: "\xc3\b\u9beb", // 鯫
	0x9bec: "\xc3\b\u9bec", // 鯬
	0x9bed: "\xc3\b\u9bed", // 鯭
	0x9bee: "\xc3\b\u9bee", // 鯮
	0x9bef: "\xc3\b\u9bef", // 鯯
	0x9bf0: "\xc3\b\u9bf0", // 鯰
	0x9bf1: "\xc3\b\u9bf1", // 鯱
	0x9bf2: "\xc3\b\u9bf2", // 鯲
	0x9bf3: "\xc3\b\u9bf3", // 鯳
	0x9bf4: "\xc3\b\u9bf4", // 鯴
	0x9bf5: "\xc3\b\u9bf5", // 鯵
	0x9bf6: "\xc3\t\u9bf6", // 鯶
	0x9bf7: "\xc3\t\u9bf7", // 鯷
	0x9bf8: "\xc3\t\u9bf8", // 鯸
	0x9bf9: "\xc3\t\u9bf9", // 鯹
	0x9bfa: "\xc3\t\u9bfa", // 鯺
	0x9bfb: "\xc3\b\u9bfb", // 鯻
	0x9bfc: "\xc3\t\u9bfc", // 鯼
	0x9bfd: "\xc3\a\u9bfd", // 鯽
	0x9bfe: "\xc3\t\u9bfe", // 鯾
	0x9bff: "\xc3\t\u9bff", // 鯿
	0x9c00: "\xc3\t\u9c00", // 鰀
	0x9c01: "\xc3\t\u9c01", // 鰁
	0x9c02: "\xc3\t\u9c02", // 鰂
	0x9c03: "\xc3\t\u9c03", // 鰃
	0x9c04: "\xc3\t\u9c04", // 鰄
	0x9c05: "\xc3\t\u9c05", // 鰅
	0x9c06: "\xc3\t\u9c06", // 鰆
	0x9c07: "\xc3\t\u9c07", // 鰇
	0x9c08: "\xc3\t\u9c08", // 鰈
	0x9c09: "\xc3\t\u9c09", // 鰉
	0x9c0a: "\xc3\t\u9c0a", // 鰊
	0x9c0b: "\xc3\t\u9c0b", // 鰋
	0x9c0c: "\xc3\t\u9c0c", // 鰌
	0x9c0d: "\xc3\t\u9c0d", // 鰍
	0x9c0e: "\xc3\t\u9c0e", // 鰎
	0x9c0f: "\xc3\t\u9c0f", // 鰏
	0x9c10: "\xc3\t\u9c10", // 鰐
	0x9c11: "\xc3\t\u9c11", // 鰑
	0x9c12: "\xc3\t\u9c12", // 鰒
	0x9c13: "\xc3\t\u9c13", // 鰓
	0x9c14: "\xc3\t\u9c14", // 鰔
	0x9c15: "\xc3\t\u9c15", // 鰕
	0x9c16: "\xc3\t\u9c16", // 鰖
	0x9c17: "\xc3\t\u9c17", // 鰗
	0x9c18: "\xc3\t\u9c18", // 鰘
	0x9c19: "\xc3\t\u9c19", // 鰙
	0x9c1a: "\xc3\t\u9c1a", // 鰚
	0x9c1b: "\xc3\t\u9c1b", // 鰛
	0x9c1c: "\xc3\n\u9c1c", // 鰜
	0x9c1d: "\xc3\n\u9c1d", // 鰝
	0x9c1e: "\xc3\n\u9c1e", // 鰞
	0x9c1f: "\xc3\n\u9c1f", // 鰟
	0x9c20: "\xc3\t\u9c20", // 鰠
	0x9c21: "\xc3\n\u9c21", // 鰡
	0x9c22: "\xc3\n\u9c22", // 鰢
	0x9c23: "\xc3\n\u9c23", // 鰣
	0x9c24: "\xc3\n\u9c24", // 鰤
	0x9c25: "\xc3\n\u9c25", // 鰥
	0x9c26: "\xc3\n\u9c26", // 鰦
	0x9c27: "\xc3\n\u9c27", // 鰧
	0x9c28: "\xc3\n\u9c28", // 鰨
	0x9c29: "\xc3\n\u9c29", // 鰩
	0x9c2a: "\xc3\n\u9c2a", // 鰪
	0x9c2b: "\xc3\n\u9c2b", // 鰫
	0x9c2c: "\xc3\n\u9c2c", // 鰬
	0x9c2d: "\xc3\n\u9c2d", // 鰭
	0x9c2e: "\xc3\n\u9c2e", // 鰮
	0x9c2f: "\xc3\n\u9c2f", // 鰯
	0x9c30: "\xc3\n\u9c30", // 鰰
	0x9c31: "\xc3\v\u9c31", // 鰱
	0x9c32: "\xc3\v\u9c32", // 鰲
	0x9c33: "\xc3\v\u9c33", // 鰳
	0x9c34: "\xc3\v\u9c34", // 鰴
	0x9c35: "\xc3\v\u9c35", // 鰵
	0x9c36: "\xc3\v\u9c36", // 鰶
	0x9c37: "\xc3\v\u9c37", // 鰷
	0x9c38: "\xc3\v\u9c38", // 鰸
	0x9c39: "\xc3\v\u9c39", // 鰹
	0x9c3a: "\xc3\v\u9c3a", // 鰺
	0x9c3b: "\xc3\v\u9c3b", // 鰻
	0x9c3c: "\xc3\v\u9c3c", // 鰼
	0x9c3d: "\xc3\v\u9c3d", // 鰽
	0x9c3e: "\xc3\v\u9c3e", // 鰾
	0x9c3f: "\xc3\v\u9c3f", // 鰿
	0x9c40: "\xc3\v\u9c40", // 鱀
	0x9c41: "\xc3\v\u9c41", // 鱁
	0x9c42: "\xc3\v\u9c42", // 鱂
	0x9c43: "\xc3\v\u9c43", // 鱃
	0x9c44: "\xc3\v\u9c44", // 鱄
	0x9c45: "\xc3\v\u9c45", // 鱅
	0x9c46: "\xc3\v\u9c46", // 鱆
	0x9c47: "\xc3\v\u9c47", // 鱇
	0x9c48: "\xc3\v\u9c48", // 鱈
	0x9c49: "\xc3\f\u9c49", // 鱉
	0x9c4a: "\xc3\f\u9c4a", // 鱊
	0x9c4b: "\xc3\f\u9c4b", // 鱋
	0x9c4c: "\xc3\f\u9c4c", // 鱌
	0x9c4d: "\xc3\f\u9c4d", // 鱍
	0x9c4e: "\xc3\f\u9c4e", // 鱎
	0x9c4f: "\xc3\f\u9c4f", // 鱏
	0x9c50: "\xc3\f\u9c50", // 鱐
	0x9c51: "\xc3\f\u9c51", // 鱑
	0x9c52: "\xc3\f\u9c52", // 鱒
	0x9c53: "\xc3\f\u9c53", // 鱓
	0x9c54: "\xc3\f\u9c54", // 鱔
	0x9c55: "\xc3\f\u9c55", // 鱕
	0x9c56: "\xc3\f\u9c56", // 鱖
	0x9c57: "\xc3\f\u9c57", // 鱗
	0x9c58: "\xc3\f\u9c58", // 鱘
	0x9c59: "\xc3\f\u9c59", // 鱙
	0x9c5a: "\xc3\f\u9c5a", // 鱚
	0x9c5b: "\xc3\f\u9c5b", // 鱛
	0x9c5c: "\xc3\r\u9c5c", // 鱜
	0x9c5d: "\xc3\r\u9c5d", // 鱝
	0x9c5e: "\xc3\r\u9c5e", // 鱞
	0x9c5f: "\xc3\r\u9c5f", // 鱟
	0x9c60: "\xc3\r\u9c60", // 鱠
	0x9c61: "\xc3\r\u9c61", // 鱡
	0x9c62: "\xc3\r\u9c62", // 鱢
	0x9c63: "\xc3\r\u9c63", // 鱣
	0x9c64: "\xc3\r\u9c64", // 鱤
	0x9c65: "\xc3\r\u9c65", // 鱥
	0x9c66: "\xc3\r\u9c66", // 鱦
	0x9c67: "\xc3\r\u9c67", // 鱧
	0x9c68: "\xc3\x0e\u9c68", // 鱨
	0x9c69: "\xc3\r\u9c69", // 鱩
	0x9c6a: "\xc3\r\u9c6a", // 鱪
	0x9c6b: "\xc3\r\u9c6b", // 鱫
	0x9c6c: "\xc3\x0e\u9c6c", // 鱬
	0x9c6d: "\xc3\x0e\u9c6d", // 鱭
	0x9c6e: "\xc3\x0e\u9c6e", // 鱮
	0x9c6f: "\xc3\x0e\u9c6f", // 鱯
	0x9c70: "\xc3\x0e\u9c70", // 鱰
	0x9c71: "\xc3\x0f\u9c71", // 鱱
	0x9c72: "\xc3\x0f\u9c72", // 鱲
	0x9c73: "\xc3\x0f\u9c73", // 鱳
	0x9c74: "\xc3\x0f\u9c74", // 鱴
	0x9c75: "\xc3\x0f\u9c75", // 鱵
	0x9c76: "\xc3\x0f\u9c76", // 鱶
	0x9c77: "\xc3\x10\u9c77", // 鱷
	0x9c78: "\xc3\x10\u9c78", // 鱸
	0x9c79: "\xc3\x12\u9c79", // 鱹
	0x9c7a: "\xc3\x13\u9c7a", // 鱺
	0x9c7b: "\xc3\x16\u9c7b", // 鱻
	0x9c7c: "\xc3\x00\u9c7c", // 鱼
	0x9c7d: "\xc3\x02\u9c7d", // 鱽
	0x9c7e: "\xc3\x03\u9c7e", // 鱾
	0x9c7f: "\xc3\x04\u9c7f", // 鱿
	0x9c80: "\xc3\x04\u9c80", // 鲀
	0x9c81: "\xc3\x04\u9c81", // 鲁
	0x9c82: "\xc3\x04\u9c82", // 鲂
	0x9c83: "\xc3\x04\u9c83", // 鲃
	0x9c84: "\xc3\x05\u9c84", // 鲄
	0x9c85: "\xc3\x05\u9c85", // 鲅
	0x9c86: "\xc3\x05\u9c86", // 鲆
	0x9c87: "\xc3\x05\u9c87", // 鲇
	0x9c88: "\xc3\x05\u9c88", // 鲈
	0x9c89: "\xc3\x05\u9c89", // 鲉
	0x9c8a: "\xc3\x05\u9c8a", // 鲊
	0x9c8b: "\xc3\x05\u9c8b", // 鲋
	0x9c8c: "\xc3\x05\u9c8c", // 鲌
	0x9c8d: "\xc3\x05\u9c8d", // 鲍
	0x9c8e: "\xc3\x05\u9c8e", // 鲎
	0x9c8f: "\xc3\x05\u9c8f", // 鲏
	0x9c90: "\xc3\x05\u9c90", // 鲐
	0x9c91: "\xc3\x06\u9c91", // 鲑
	0x9c92: "\xc3\x06\u9c92", // 鲒
	0x9c93: "\xc3\x06\u9c93", // 鲓
	0x9c94: "\xc3\x06\u9c94", // 鲔
	0x9c95: "\xc3\x06\u9c95", // 鲕
	0x9c96: "\xc3\x06\u9c96", // 鲖
	0x9c97: "\xc3\x06\u9c97", // 鲗
	0x9c98: "\xc3\x06\u9c98", // 鲘
	0x9c99: "\xc3\x06\u9c99", // 鲙
	0x9c9a: "\xc3\x06\u9c9a", // 鲚
	0x9c9b: "\xc3\x06\u9c9b", // 鲛
	0x9c9c: "\xc3\x06\u9c9c", // 鲜
	0x9c9d: "\xc3\x06\u9c9d", // 鲝
	0x9c9e: "\xc3\x06\u9c9e", // 鲞
	0x9c9f: "\xc3\x06\u9c9f", // 鲟
	0x9ca0: "\xc3\a\u9ca0", // 鲠
	0x9ca1: "\xc3\a\u9ca1", // 鲡
	0x9ca2: "\xc3\a\u9ca2", // 鲢
	0x9ca3: "\xc3\a\u9ca3", // 鲣
	0x9ca4: "\xc3\a\u9ca4", // 鲤
	0x9ca5: "\xc3\a\u9ca5", // 鲥
	0x9ca6: "\xc3\a\u9ca6", // 鲦
	0x9ca7: "\xc3\a\u9ca7", // 鲧
	0x9ca8: "\xc3\a\u9ca8", // 鲨
	0x9ca9: "\xc3\a\u9ca9", // 鲩
	0x9caa: "\xc3\a\u9caa", // 鲪
	0x9cab: "\xc3\a\u9cab", // 鲫
	0x9cac: "\xc3\a\u9cac", // 鲬
	0x9cad: "\xc3\b\u9cad", // 鲭
	0x9cae: "\xc3\b\u9cae", // 鲮
	0x9caf: "\xc3\b\u9caf", // 鲯
	0x9cb0: "\xc3\b\u9cb0", // 鲰
	0x9cb1: "\xc3\b\u9cb1", // 鲱
	0x9cb2: "\xc3\b\u9cb2", // 鲲
	0x9cb3: "\xc3\b\u9cb3", // 鲳
	0x9cb4: "\xc3\b\u9cb4", // 鲴
	0x9cb5: "\xc3\b\u9cb5", // 鲵
	0x9cb6: "\xc3\b\u9cb6", // 鲶
	0x9cb7: "\xc3\b\u9cb7", // 鲷
	0x9cb8: "\xc3\b\u9cb8", // 鲸
	0x9cb9: "\xc3\b\u9cb9", // 鲹
	0x9cba: "\xc3\b\u9cba", // 鲺
	0x9cbb: "\xc3\b\u9cbb", // 鲻
	0x9cbc: "\xc3\t\u9cbc", // 鲼
	0x9cbd: "\xc3\t\u9cbd", // 鲽
	0x9cbe: "\xc3\n\u9cbe", // 鲾
	0x9cbf: "\xc3\t\u9cbf", // 鲿
	0x9cc0: "\xc3\t\u9cc0", // 鳀
	0x9cc1: "\xc3\t\u9cc1", // 鳁
	0x9cc2: "\xc3\t\u9cc2", // 鳂
	0x9cc3: "\xc3\t\u9cc3", // 鳃
	0x9cc4: "\xc3\t\u9cc4", // 鳄
	0x9cc5: "\xc3\t\u9cc5", // 鳅
	0x9cc6: "\xc3\t\u9cc6", // 鳆
	0x9cc7: "\xc3\t\u9cc7", // 鳇
	0x9cc8: "\xc3\t\u9cc8", // 鳈
	0x9cc9: "\xc3\t\u9cc9", // 鳉
	0x9cca: "\xc3\t\u9cca", // 鳊
	0x9ccb: "\xc3\t\u9ccb", // 鳋
	0x9ccc: "\xc3\n\u9ccc", // 鳌
	0x9ccd: "\xc3\n\u9ccd", // 鳍
	0x9cce: "\xc3\n\u9cce", // 鳎
	0x9ccf: "\xc3\n\u9ccf", // 鳏
	0x9cd0: "\xc3\n\u9cd0", // 鳐
	0x9cd1: "\xc3\n\u9cd1", // 鳑
	0x9cd2: "\xc3\n\u9cd2", // 鳒
	0x9cd3: "\xc3\v\u9cd3", // 鳓
	0x9cd4: "\xc3\v\u9cd4", // 鳔
	0x9cd5: "\xc3\v\u9cd5", // 鳕
	0x9cd6: "\xc3\v\u9cd6", // 鳖
	0x9cd7: "\xc3\v\u9cd7", // 鳗
	0x9cd8: "\xc3\v\u9cd8", // 鳘
	0x9cd9: "\xc3\v\u9cd9", // 鳙
	0x9cda: "\xc3\v\u9cda", // 鳚
	0x9cdb: "\xc3\v\u9cdb", // 鳛
	0x9cdc: "\xc3\f\u9cdc", // 鳜
	0x9cdd: "\xc3\f\u9cdd", // 鳝
	0x9cde: "\xc3\f\u9cde", // 鳞
	0x9cdf: "\xc3\f\u9cdf", // 鳟
	0x9ce0: "\xc3\r\u9ce0", // 鳠
	0x9ce1: "\xc3\r\u9ce1", // 鳡
	0x9ce2: "\xc3\r\u9ce2", // 鳢
	0x9ce3: "\xc3\r\u9ce3", // 鳣
	0x9ce4: "\xc3\x0e\u9ce4", // 鳤
	0x9ce5: "\xc4\x00\u9ce5", // 鳥
	0x9ce6: "\xc4\x01\u9ce6", // 鳦
	0x9ce7: "\xc4\x02\u9ce7", // 鳧
	0x9ce8: "\xc4\x02\u9ce8", // 鳨
	0x9ce9: "\xc4\x02\u9ce9", // 鳩
	0x9cea: "\xc4\x02\u9cea", // 鳪
	0x9ceb: "\xc4\x02\u9ceb", // 鳫
	0x9cec: "\xc4\x02\u9cec", // 鳬
	0x9ced: "\xc4\x02\u9ced", // 鳭
	0x9cee: "\xc4\x02\u9cee", // 鳮
	0x9cef: "\xc4\x02\u9cef", // 鳯
	0x9cf0: "\xc4\x02\u9cf0", // 鳰
	0x9cf1: "\xc4\x03\u9cf1", // 鳱
	0x9cf2: "\xc4\x03\u9cf2", // 鳲
	0x9cf3: "\xc4\x03\u9cf3", // 鳳
	0x9cf4: "\xc4\x03\u9cf4", // 鳴
	0x9cf5: "\xc4\x03\u9cf5", // 鳵
	0x9cf6: "\xc4\x03\u9cf6", // 鳶
	0x9cf7: "\xc4\x04\u9cf7", // 鳷
	0x9cf8: "\xc4\x04\u9cf8", // 鳸
	0x9cf9: "\xc4\x04\u9cf9", // 鳹
	0x9cfa: "\xc4\x04\u9cfa", // 鳺
	0x9cfb: "\xc4\x04\u9cfb", // 鳻
	0x9cfc: "\xc4\x04\u9cfc", // 鳼
	0x9cfd: "\xc4\x04\u9cfd", // 鳽
	0x9cfe: "\xc4\x04\u9cfe", // 鳾
	0x9cff: "\xc4\x04\u9cff", // 鳿
	0x9d00: "\xc4\x04\u9d00", // 鴀
	0x9d01: "\xc4\x04\u9d01", // 鴁
	0x9d02: "\xc4\x04\u9d02", // 鴂
	0x9d03: "\xc4\x04\u9d03", // 鴃
	0x9d04: "\xc4\x04\u9d04", // 鴄
	0x9d05: "\xc4\x04\u9d05", // 鴅
	0x9d06: "\xc4\x04\u9d06", // 鴆
	0x9d07: "\xc4\x04\u9d07", // 鴇
	0x9d08: "\xc4\x04\u9d08", // 鴈
	0x9d09: "\xc4\x04\u9d09", // 鴉
	0x9d0a: "\xc4\x05\u9d0a", // 鴊
	0x9d0b: "\xc4\x04\u9d0b", // 鴋
	0x9d0c: "\xc4\x04\u9d0c", // 鴌
	0x9d0d: "\xc4\x04\u9d0d", // 鴍
	0x9d0e: "\xc4\x04\u9d0e", // 鴎
	0x9d0f: "\xc4\x05\u9d0f", // 鴏
	0x9d10: "\xc4\x05\u9d10", // 鴐
	0x9d11: "\xc4\x05\u9d11", // 鴑
	0x9d12: "\xc4\x05\u9d12", // 鴒
	0x9d13: "\xc4\x05\u9d13", // 鴓
	0x9d14: "\xc4\x05\u9d14", // 鴔
	0x9d15: "\xc4\x05\u9d15", // 鴕
	0x9d16: "\xc4\x05\u9d16", // 鴖
	0x9d17: "\xc4\x05\u9d17", // 鴗
	0x9d18: "\xc4\x05\u9d18", // 鴘
	0x9d19: "\xc4\x05\u9d19", // 鴙
	0x9d1a: "\xc4\x05\u9d1a", // 鴚
	0x9d1b: "\xc4\x05\u9d1b", // 鴛
	0x9d1c: "\xc4\x05\u9d1c", // 鴜
	0x9d1d: "\xc4\x05\u9d1d", // 鴝
	0x9d1e: "\xc4\x05\u9d1e", // 鴞
	0x9d1f: "\xc4\x05\u9d1f", // 鴟
	0x9d20: "\xc4\x05\u9d20", // 鴠
	0x9d21: "\xc4\x05\u9d21", // 鴡
	0x9d22: "\xc4\x05\u9d22", // 鴢
	0x9d23: "\xc4\x05\u9d23", // 鴣
	0x9d24: "\xc4\x05\u9d24", // 鴤
	0x9d25: "\xc4\x05\u9d25", // 鴥
	0x9d26: "\xc4\x05\u9d26", // 鴦
	0x9d27: "\xc4\x05\u9d27", // 鴧
	0x9d28: "\xc4\x05\u9d28", // 鴨
	0x9d29: "\xc4\x05\u9d29", // 鴩
	0x9d2a: "\xc4\x05\u9d2a", // 鴪
	0x9d2b: "\xc4\x05\u9d2b", // 鴫
	0x9d2c: "\xc4\x05\u9d2c", // 鴬
	0x9d2d: "\xc4\x06\u9d2d", // 鴭
	0x9d2e: "\xc4\x06\u9d2e", // 鴮
	0x9d2f: "\xc4\x06\u9d2f", // 鴯
	0x9d30: "\xc4\x06\u9d30", // 鴰
	0x9d31: "\xc4\x06\u9d31", // 鴱
	0x9d32: "\xc4\x06\u9d32", // 鴲
	0x9d33: "\xc4\x06\u9d33", // 鴳
	0x9d34: "\xc4\x06\u9d34", // 鴴
	0x9d35: "\xc4\x06\u9d35", // 鴵
	0x9d36: "\xc4\x06\u9d36", // 鴶
	0x9d37: "\xc4\x06\u9d37", // 鴷
	0x9d38: "\xc4\x06\u9d38", // 鴸
	0x9d39: "\xc4\x06\u9d39", // 鴹
	0x9d3a: "\xc4\x06\u9d3a", // 鴺
	0x9d3b: "\xc4\x06\u9d3b", // 鴻
	0x9d3c: "\xc4\x06\u9d3c", // 鴼
	0x9d3d: "\xc4\x06\u9d3d", // 鴽
	0x9d3e: "\xc4\x06\u9d3e", // 鴾
	0x9d3f: "\xc4\x06\u9d3f", // 鴿
	0x9d40: "\xc4\x06\u9d40", // 鵀
	0x9d41: "\xc4\x06\u9d41", // 鵁
	0x9d42: "\xc4\x06\u9d42", // 鵂
	0x9d43: "\xc4\x06\u9d43", // 鵃
	0x9d44: "\xc4\x06\u9d44", // 鵄
	0x9d45: "\xc4\x06\u9d45", // 鵅
	0x9d46: "\xc4\x06\u9d46", // 鵆
	0x9d47: "\xc4\x06\u9d47", // 鵇
	0x9d48: "\xc4\x06\u9d48", // 鵈
	0x9d49: "\xc4\x06\u9d49", // 鵉
	0x9d4a: "\xc4\a\u9d4a", // 鵊
	0x9d4b: "\xc4\a\u9d4b", // 鵋
	0x9d4c: "\xc4\a\u9d4c", // 鵌
	0x9d4d: "\xc4\a\u9d4d", // 鵍
	0x9d4e: "\xc4\a\u9d4e", // 鵎
	0x9d4f: "\xc4\a\u9d4f", // 鵏
	0x9d50: "\xc4\a\u9d50", // 鵐
	0x9d51: "\xc4\a\u9d51", // 鵑
	0x9d52: "\xc4\a\u9d52", // 鵒
	0x9d53: "\xc4\a\u9d53", // 鵓
	0x9d54: "\xc4\a\u9d54", // 鵔
	0x9d55: "\xc4\a\u9d55", // 鵕
	0x9d56: "\xc4\a\u9d56", // 鵖
	0x9d57: "\xc4\a\u9d57", // 鵗
	0x9d58: "\xc4\a\u9d58", // 鵘
	0x9d59: "\xc4\a\u9d59", // 鵙
	0x9d5a: "\xc4\a\u9d5a", // 鵚
	0x9d5b: "\xc4\a\u9d5b", // 鵛
	0x9d5c: "\xc4\a\u9d5c", // 鵜
	0x9d5d: "\xc4\a\u9d5d", // 鵝
	0x9d5e: "\xc4\a\u9d5e", // 鵞
	0x9d5f: "\xc4\a\u9d5f", // 鵟
	0x9d60: "\xc4\a\u9d60", // 鵠
	0x9d61: "\xc4\a\u9d61", // 鵡
	0x9d62: "\xc4\a\u9d62", // 鵢
	0x9d63: "\xc4\a\u9d63", // 鵣
	0x9d64: "\x94\v\u9d64", // 鵤
	0x9d65: "\xc4\a\u9d65", // 鵥
	0x9d66: "\xc4\b\u9d66", // 鵦
	0x9d67: "\xc4\b\u9d67", // 鵧
	0x9d68: "\xc4\b\u9d68", // 鵨
	0x9d69: "\xc4\b\u9d69", // 鵩
	0x9d6a: "\xc4\b\u9d6a", // 鵪
	0x9d6b: "\xc4\b\u9d6b", // 鵫
	0x9d6c: "\xc4\b\u9d6c", // 鵬
	0x9d6d: "\xc4\b\u9d6d", // 鵭
	0x9d6e: "\xc4\b\u9d6e", // 鵮
	0x9d6f: "\xc4\b\u9d6f", // 鵯
	0x9d70: "\xc4\b\u9d70", // 鵰
	0x9d71: "\xc4\b\u9d71", // 鵱
	0x9d72: "\xc4\b\u9d72", // 鵲
	0x9d73: "\xc4\b\u9d73", // 鵳
	0x9d74: "\xc4\b\u9d74", // 鵴
	0x9d75: "\xc4\b\u9d75", // 鵵
	0x9d76: "\xc4\b\u9d76", // 鵶
	0x9d77: "\xc4\b\u9d77", // 鵷
	0x9d78: "\xc4\b\u9d78", // 鵸
	0x9d79: "\xc4\b\u9d79", // 鵹
	0x9d7a: "\xc4\b\u9d7a", // 鵺
	0x9d7b: "\xc4\b\u9d7b", // 鵻
	0x9d7c: "\xc4\b\u9d7c", // 鵼
	0x9d7d: "\xc4\b\u9d7d", // 鵽
	0x9d7e: "\xc4\b\u9d7e", // 鵾
	0x9d7f: "\xc4\b\u9d7f", // 鵿
	0x9d80: "\xc4\b\u9d80", // 鶀
	0x9d81: "\xc4\b\u9d81", // 鶁
	0x9d82: "\xc4\b\u9d82", // 鶂
	0x9d83: "\xc4\b\u9d83", // 鶃
	0x9d84: "\xc4\b\u9d84", // 鶄
	0x9d85: "\xc4\b\u9d85", // 鶅
	0x9d86: "\xc4\b\u9d86", // 鶆
	0x9d87: "\xc4\b\u9d87", // 鶇
	0x9d88: "\xc4\b\u9d88", // 鶈
	0x9d89: "\xc4\b\u9d89", // 鶉
	0x9d8a: "\xc4\b\u9d8a", // 鶊
	0x9d8b: "\xc4\b\u9d8b", // 鶋
	0x9d8c: "\xc4\b\u9d8c", // 鶌
	0x9d8d: "\xc4\b\u9d8d", // 鶍
	0x9d8e: "\xc4\b\u9d8e", // 鶎
	0x9d8f: "\xc4\b\u9d8f", // 鶏
	0x9d90: "\xc4\t\u9d90", // 鶐
	0x9d91: "\xc4\b\u9d91", // 鶑
	0x9d92: "\xc4\t\u9d92", // 鶒
	0x9d93: "\xc4\t\u9d93", // 鶓
	0x9d94: "\xc4\t\u9d94", // 鶔
	0x9d95: "\xc4\t\u9d95", // 鶕
	0x9d96: "\xc4\t\u9d96", // 鶖
	0x9d97: "\xc4\t\u9d97", // 鶗
	0x9d98: "\xc4\t\u9d98", // 鶘
	0x9d99: "\xc4\t\u9d99", // 鶙
	0x9d9a: "\xc4\t\u9d9a", // 鶚
	0x9d9b: "\xc4\t\u9d9b", // 鶛
	0x9d9c: "\xc4\t\u9d9c", // 鶜
	0x9d9d: "\xc4\t\u9d9d", // 鶝
	0x9d9e: "\xc4\t\u9d9e", // 鶞
	0x9d9f: "\xc4\t\u9d9f", // 鶟
	0x9da0: "\xc4\t\u9da0", // 鶠
	0x9da1: "\xc4\t\u9da1", // 鶡
	0x9da2: "\xc4\t\u9da2", // 鶢
	0x9da3: "\xc4\t\u9da3", // 鶣
	0x9da4: "\xc4\t\u9da4", // 鶤
	0x9da5: "\xc4\t\u9da5", // 鶥
	0x9da6: "\xc4\t\u9da6", // 鶦
	0x9da7: "\xc4\t\u9da7", // 鶧
	0x9da8: "\xc4\t\u9da8", // 鶨
	0x9da9: "\xc4\t\u9da9", // 鶩
	0x9daa: "\xc4\t\u9daa", // 鶪
	0x9dab: "\xc4\t\u9dab", // 鶫
	0x9dac: "\xc4\n\u9dac", // 鶬
	0x9dad: "\xc4\n\u9dad", // 鶭
	0x9dae: "\xc4\n\u9dae", // 鶮
	0x9daf: "\xc4\n\u9daf", // 鶯
	0x9db0: "\xc4\n\u9db0", // 鶰
	0x9db1: "\xc4\n\u9db1", // 鶱
	0x9db2: "\xc4\n\u9db2", // 鶲
	0x9db3: "\xc4\n\u9db3", // 鶳
	0x9db4: "\xc4\n\u9db4", // 鶴
	0x9db5: "\xc4\n\u9db5", // 鶵
	0x9db6: "\xc4\n\u9db6", // 鶶
	0x9db7: "\xc4\n\u9db7", // 鶷
	0x9db8: "\xc4\n\u9db8", // 鶸
	0x9db9: "\xc4\n\u9db9", // 鶹
	0x9dba: "\xc4\n\u9dba", // 鶺
	0x9dbb: "\xc4\n\u9dbb", // 鶻
	0x9dbc: "\xc4\n\u9dbc", // 鶼
	0x9dbd: "\xc4\n\u9dbd", // 鶽
	0x9dbe: "\xc4\n\u9dbe", // 鶾
	0x9dbf: "\xc4\n\u9dbf", // 鶿
	0x9dc0: "\xc4\n\u9dc0", // 鷀
	0x9dc1: "\xc4\n\u9dc1", // 鷁
	0x9dc2: "\xc4\n\u9dc2", // 鷂
	0x9dc3: "\xc4\n\u9dc3", // 鷃
	0x9dc4: "\xc4\n\u9dc4", // 鷄
	0x9dc5: "\xc4\n\u9dc5", // 鷅
	0x9dc6: "\xc4\n\u9dc6", // 鷆
	0x9dc7: "\xc4\n\u9dc7", // 鷇
	0x9dc8: "\xc4\n\u9dc8", // 鷈
	0x9dc9: "\xc4\n\u9dc9", // 鷉
	0x9dca: "\xc4\n\u9dca", // 鷊
	0x9dcb: "\xc4\v\u9dcb", // 鷋
	0x9dcc: "\xc4\n\u9dcc", // 鷌
	0x9dcd: "\xc4\n\u9dcd", // 鷍
	0x9dce: "\xc4\n\u9dce", // 鷎
	0x9dcf: "\xc4\n\u9dcf", // 鷏
	0x9dd0: "\xc4\v\u9dd0", // 鷐
	0x9dd1: "\xc4\v\u9dd1", // 鷑
	0x9dd2: "\xc4\v\u9dd2", // 鷒
	0x9dd3: "\xc4\v\u9dd3", // 鷓
	0x9dd4: "\xc4\v\u9dd4", // 鷔
	0x9dd5: "\xc4\v\u9dd5", // 鷕
	0x9dd6: "\xc4\v\u9dd6", // 鷖
	0x9dd7: "\xc4\v\u9dd7", // 鷗
	0x9dd8: "\xc4\v\u9dd8", // 鷘
	0x9dd9: "\xc4\v\u9dd9", // 鷙
	0x9dda: "\xc4\v\u9dda", // 鷚
	0x9ddb: "\xc4\v\u9ddb", // 鷛
	0x9ddc: "\xc4\v\u9ddc", // 鷜
	0x9ddd: "\xc4\v\u9ddd", // 鷝
	0x9dde: "\xc4\v\u9dde", // 鷞
	0x9ddf: "\xc4\v\u9ddf", // 鷟
	0x9de0: "\xc3\v\u9de0", // 鷠
	0x9de1: "\xc4\f\u9de1", // 鷡
	0x9de2: "\xc4\f\u9de2", // 鷢
	0x9de3: "\xc4\f\u9de3", // 鷣
	0x9de4: "\xc4\f\u9de4", // 鷤
	0x9de5: "\xc4\f\u9de5", // 鷥
	0x9de6: "\xc4\f\u9de6", // 鷦
	0x9de7: "\xc4\f\u9de7", // 鷧
	0x9de8: "\xc4\f\u9de8", // 鷨
	0x9de9: "\xc4\f\u9de9", // 鷩
	0x9dea: "\xc4\f\u9dea", // 鷪
	0x9deb: "\xc4\f\u9deb", // 鷫
	0x9dec: "\xc4\f\u9dec", // 鷬
	0x9ded: "\xc4\f\u9ded", // 鷭
	0x9dee: "\xc4\f\u9dee", // 鷮
	0x9def: "\xc4\f\u9def", // 鷯
	0x9df0: "\xc4\f\u9df0", // 鷰
	0x9df1: "\xc4\f\u9df1", // 鷱
	0x9df2: "\xc4\f\u9df2", // 鷲
	0x9df3: "\xc4\f\u9df3", // 鷳
	0x9df4: "\xc4\f\u9df4", // 鷴
	0x9df5: "\xc4\f\u9df5", // 鷵
	0x9df6: "\xc4\f\u9df6", // 鷶
	0x9df7: "\xc4\f\u9df7", // 鷷
	0x9df8: "\xc4\f\u9df8", // 鷸
	0x9df9: "\xc4\r\u9df9", // 鷹
	0x9dfa: "\xc4\f\u9dfa", // 鷺
	0x9dfb: "\xc4\f\u9dfb", // 鷻
	0x9dfc: "\xc4\f\u9dfc", // 鷼
	0x9dfd: "\xc4\r\u9dfd", // 鷽
	0x9dfe: "\xc4\r\u9dfe", // 鷾
	0x9dff: "\xc4\r\u9dff", // 鷿
	0x9e00: "\xc4\r\u9e00", // 鸀
	0x9e01: "\xc4\r\u9e01", // 鸁
	0x9e02: "\xc4\r\u9e02", // 鸂
	0x9e03: "\xc4\r\u9e03", // 鸃
	0x9e04: "\xc4\r\u9e04", // 鸄
	0x9e05: "\xc4\r\u9e05", // 鸅
	0x9e06: "\xc4\r\u9e06", // 鸆
	0x9e07: "\xc4\r\u9e07", // 鸇
	0x9e08: "\xc4\r\u9e08", // 鸈
	0x9e09: "\xc4\r\u9e09", // 鸉
	0x9e0a: "\xc4\r\u9e0a", // 鸊
	0x9e0b: "\xc4\x0e\u9e0b", // 鸋
	0x9e0c: "\xc4\x0e\u9e0c", // 鸌
	0x9e0d: "\xc4\x0e\u9e0d", // 鸍
	0x9e0e: "\xc4\x0e\u9e0e", // 鸎
	0x9e0f: "\xc4\x0e\u9e0f", // 鸏
	0x9e10: "\xc4\x0e\u9e10", // 鸐
	0x9e11: "\xc4\x0e\u9e11", // 鸑
	0x9e12: "\xc4\x0e\u9e12", // 鸒
	0x9e13: "\xc4\x0f\u9e13", // 鸓
	0x9e14: "\xc4\x0f\u9e14", // 鸔
	0x9e15: "\xc4\x10\u9e15", // 鸕
	0x9e16: "\xc4\x10\u9e16", // 鸖
	0x9e17: "\xc4\x10\u9e17", // 鸗
	0x9e18: "\xc4\x11\u9e18", // 鸘
	0x9e19: "\xc4\x11\u9e19", // 鸙
	0x9e1a: "\xc4\x11\u9e1a", // 鸚
	0x9e1b: "\xc4\x12\u9e1b", // 鸛
	0x9e1c: "\xc4\x12\u9e1c", // 鸜
	0x9e1d: "\xc4\x13\u9e1d", // 鸝
	0x9e1e: "\xc4\x13\u9e1e", // 鸞
	0x9e1f: "\xc4\x00\u9e1f", // 鸟
	0x9e20: "\xc4\x02\u9e20", // 鸠
	0x9e21: "\xc4\x02\u9e21", // 鸡
	0x9e22: "\xc4\x03\u9e22", // 鸢
	0x9e23: "\xc4\x03\u9e23", // 鸣
	0x9e24: "\xc4\x03\u9e24", // 鸤
	0x9e25: "\xc4\x04\u9e25", // 鸥
	0x9e26: "\xc4\x04\u9e26", // 鸦
	0x9e27: "\xc4\x04\u9e27", // 鸧
	0x9e28: "\xc4\x04\u9e28", // 鸨
	0x9e29: "\xc4\x04\u9e29", // 鸩
	0x9e2a: "\xc4\x05\u9e2a", // 鸪
	0x9e2b: "\xc4\x05\u9e2b", // 鸫
	0x9e2c: "\xc4\x05\u9e2c", // 鸬
	0x9e2d: "\xc4\x05\u9e2d", // 鸭
	0x9e2e: "\xc4\x05\u9e2e", // 鸮
	0x9e2f: "\xc4\x05\u9e2f", // 鸯
	0x9e30: "\xc4\x05\u9e30", // 鸰
	0x9e31: "\xc4\x05\u9e31", // 鸱
	0x9e32: "\xc4\x05\u9e32", // 鸲
	0x9e33: "\xc4\x05\u9e33", // 鸳
	0x9e34: "\xc4\x05\u9e34", // 鸴
	0x9e35: "\xc4\x05\u9e35", // 鸵
	0x9e36: "\xc4\x05\u9e36", // 鸶
	0x9e37: "\xc4\x06\u9e37", // 鸷
	0x9e38: "\xc4\x06\u9e38", // 鸸
	0x9e39: "\xc4\x06\u9e39", // 鸹
	0x9e3a: "\xc4\x06\u9e3a", // 鸺
	0x9e3b: "\xc4\x06\u9e3b", // 鸻
	0x9e3c: "\xc4\x06\u9e3c", // 鸼
	0x9e3d: "\xc4\x06\u9e3d", // 鸽
	0x9e3e: "\xc4\x06\u9e3e", // 鸾
	0x9e3f: "\xc4\x06\u9e3f", // 鸿
	0x9e40: "\xc4\a\u9e40", // 鹀
	0x9e41: "\xc4\a\u9e41", // 鹁
	0x9e42: "\xc4\a\u9e42", // 鹂
	0x9e43: "\xc4\a\u9e43", // 鹃
	0x9e44: "\xc4\a\u9e44", // 鹄
	0x9e45: "\xc4\a\u9e45", // 鹅
	0x9e46: "\xc4\a\u9e46", // 鹆
	0x9e47: "\xc4\a\u9e47", // 鹇
	0x9e48: "\xc4\a\u9e48", // 鹈
	0x9e49: "\xc4\b\u9e49", // 鹉
	0x9e4a: "\xc4\b\u9e4a", // 鹊
	0x9e4b: "\xc4\b\u9e4b", // 鹋
	0x9e4c: "\xc4\b\u9e4c", // 鹌
	0x9e4d: "\xc4\b\u9e4d", // 鹍
	0x9e4e: "\xc4\b\u9e4e", // 鹎
	0x9e4f: "\xc4\b\u9e4f", // 鹏
	0x9e50: "\xc4\b\u9e50", // 鹐
	0x9e51: "\xc4\b\u9e51", // 鹑
	0x9e52: "\xc4\b\u9e52", // 鹒
	0x9e53: "\xc4\b\u9e53", // 鹓
	0x9e54: "\xc4\b\u9e54", // 鹔
	0x9e55: "\xc4\t\u9e55", // 鹕
	0x9e56: "\xc4\t\u9e56", // 鹖
	0x9e57: "\xc4\t\u9e57", // 鹗
	0x9e58: "\xc4\n\u9e58", // 鹘
	0x9e59: "\xc4\t\u9e59", // 鹙
	0x9e5a: "\xc4\t\u9e5a", // 鹚
	0x9e5b: "\xc4\t\u9e5b", // 鹛
	0x9e5c: "\xc4\t\u9e5c", // 鹜
	0x9e5d: "\xc4\n\u9e5d", // 鹝
	0x9e5e: "\xc4\n\u9e5e", // 鹞
	0x9e5f: "\xc4\n\u9e5f", // 鹟
	0x9e60: "\xc4\n\u9e60", // 鹠
	0x9e61: "\xc4\n\u9e61", // 鹡
	0x9e62: "\xc4\n\u9e62", // 鹢
	0x9e63: "\xc4\n\u9e63", // 鹣
	0x9e64: "\xc4\n\u9e64", // 鹤
	0x9e65: "\xc4\v\u9e65", // 鹥
	0x9e66: "\xc4\v\u9e66", // 鹦
	0x9e67: "\xc4\v\u9e67", // 鹧
	0x9e68: "\xc4\v\u9e68", // 鹨
	0x9e69: "\xc4\f\u9e69", // 鹩
	0x9e6a: "\xc4\f\u9e6a", // 鹪
	0x9e6b: "\xc4\f\u9e6b", // 鹫
	0x9e6c: "\xc4\f\u9e6c", // 鹬
	0x9e6d: "\xc4\r\u9e6d", // 鹭
	0x9e6e: "\xc4\r\u9e6e", // 鹮
	0x9e6f: "\xc4\r\u9e6f", // 鹯
	0x9e70: "\xc4\r\u9e70", // 鹰
	0x9e71: "\xc4\x0e\u9e71", // 鹱
	0x9e72: "\xc4\x0e\u9e72", // 鹲
	0x9e73: "\xc4\x11\u9e73", // 鹳
	0x9e74: "\xc4\x11\u9e74", // 鹴
	0x9e75: "\xc5\x00\u9e75", // 鹵
	0x9e76: "\xc5\x04\u9e76", // 鹶
	0x9e77: "\xc5\x05\u9e77", // 鹷
	0x9e78: "\xc5\b\u9e78", // 鹸
	0x9e79: "\xc5\t\u9e79", // 鹹
	0x9e7a: "\xc5\n\u9e7a", // 鹺
	0x9e7b: "\xc5\n\u9e7b", // 鹻
	0x9e7c: "\xc5\r\u9e7c", // 鹼
	0x9e7d: "\xc5\r\u9e7d", // 鹽
	0x9e7e: "\xc5\t\u9e7e", // 鹾
	0x9e7f: "\xc6\x00\u9e7f", // 鹿
	0x9e80: "\xc6\x02\u9e80", // 麀
	0x9e81: "\xc6\x02\u9e81", // 麁
	0x9e82: "\xc6\x02\u9e82", // 麂
	0x9e83: "\xc6\x04\u9e83", // 麃
	0x9e84: "\xc6\x04\u9e84", // 麄
	0x9e85: "\xc6\x05\u9e85", // 麅
	0x9e86: "\xc6\x05\u9e86", // 麆
	0x9e87: "\xc6\x05\u9e87", // 麇
	0x9e88: "\xc6\x05\u9e88", // 麈
	0x9e89: "\xc6\x06\u9e89", // 麉
	0x9e8a: "\xc6\x06\u9e8a", // 麊
	0x9e8b: "\xc6\x06\u9e8b", // 麋
	0x9e8c: "\xc6\a\u9e8c", // 麌
	0x9e8d: "\xc6\a\u9e8d", // 麍
	0x9e8e: "\xc6\a\u9e8e", // 麎
	0x9e8f: "\xc6\a\u9e8f", // 麏
	0x9e90: "\xc6\a\u9e90", // 麐
	0x9e91: "\xc6\b\u9e91", // 麑
	0x9e92: "\xc6\b\u9e92", // 麒
	0x9e93: "\xc6\b\u9e93", // 麓
	0x9e94: "\xc6\b\u9e94", // 麔
	0x9e95: "\xc6\b\u9e95", // 麕
	0x9e96: "\xc6\b\u9e96", // 麖
	0x9e97: "\xc6\b\u9e97", // 麗
	0x9e98: "\xc6\t\u9e98", // 麘
	0x9e99: "\xc6\t\u9e99", // 麙
	0x9e9a: "\xc6\t\u9e9a", // 麚
	0x9e9b: "\xc6\t\u9e9b", // 麛
	0x9e9c: "\xc6\n\u9e9c", // 麜
	0x9e9d: "\xc6\n\u9e9d", // 麝
	0x9e9e: "\xc6\v\u9e9e", // 麞
	0x9e9f: "\xc6\f\u9e9f", // 麟
	0x9ea0: "\xc6\r\u9ea0", // 麠
	0x9ea1: "\xc6\x0e\u9ea1", // 麡
	0x9ea2: "\xc6\x11\u9ea2", // 麢
	0x9ea3: "\xc6\x14\u9ea3", // 麣
	0x9ea4: "\xc6\x16\u9ea4", // 麤
	0x9ea5: "\xc7\x00\u9ea5", // 麥
	0x9ea6: "\xc7\x00\u9ea6", // 麦
	0x9ea7: "\xc7\x03\u9ea7", // 麧
	0x9ea8: "\xc7\x04\u9ea8", // 麨
	0x9ea9: "\xc7\x04\u9ea9", // 麩
	0x9eaa: "\xc7\x04\u9eaa", // 麪
	0x9eab: "\xc7\x04\u9eab", // 麫
	0x9eac: "\xc7\x05\u9eac", // 麬
	0x9ead: "\xc7\x05\u9ead", // 麭
	0x9eae: "\xc7\x05\u9eae", // 麮
	0x9eaf: "\xc7\x06\u9eaf", // 麯
	0x9eb0: "\xc7\x06\u9eb0", // 麰
	0x9eb1: "\xc7\a\u9eb1", // 麱
	0x9eb2: "\xc7\a\u9eb2", // 麲
	0x9eb3: "\xc7\b\u9eb3", // 麳
	0x9eb4: "\xc7\b\u9eb4", // 麴
	0x9eb5: "\xc7\t\u9eb5", // 麵
	0x9eb6: "\xc7\v\u9eb6", // 麶
	0x9eb7: "\xc7\x12\u9eb7", // 麷
	0x9eb8: "\xc7\x04\u9eb8", // 麸
	0x9eb9: "\xc7\b\u9eb9", // 麹
	0x9eba: "\xc7\t\u9eba", // 麺
	0x9ebb: "\xc8\x00\u9ebb", // 麻
	0x9ebc: "\xc8\x03\u9ebc", // 麼
	0x9ebd: "\xc8\x03\u9ebd", // 麽
	0x9ebe: "\xc8\x04\u9ebe", // 麾
	0x9ebf: "\xc8\a\u9ebf", // 麿
	0x9ec0: "\xc8\b\u9ec0", // 黀
	0x9ec1: "\xc8\t\u9ec1", // 黁
	0x9ec2: "\xc8\r\u9ec2", // 黂
	0x9ec3: "\xc9\x00\u9ec3", // 黃
	0x9ec4: "\xc9\x00\u9ec4", // 黄
	0x9ec5: "\xc9\x04\u9ec5", // 黅
	0x9ec6: "\xc9\x04\u9ec6", // 黆
	0x9ec7: "\xc9\x05\u9ec7", // 黇
	0x9ec8: "\xc9\x05\u9ec8", // 黈
	0x9ec9: "\xc9\x05\u9ec9", // 黉
	0x9eca: "\xc9\x06\u9eca", // 黊
	0x9ecb: "\xc9\x06\u9ecb", // 黋
	0x9ecc: "\xc9\r\u9ecc", // 黌
	0x9ecd: "\xca\x00\u9ecd", // 黍
	0x9ece: "\xca\x03\u9ece", // 黎
	0x9ecf: "\xca\x05\u9ecf", // 黏
	0x9ed0: "\xca\n\u9ed0", // 黐
	0x9ed1: "\xcb\x00\u9ed1", // 黑
	0x9ed2: "\xcb\x00\u9ed2", // 黒
	0x9ed3: "\xcb\x03\u9ed3", // 黓
	0x9ed4: "\xcb\x04\u9ed4", // 黔
	0x9ed5: "\xcb\x04\u9ed5", // 黕
	0x9ed6: "\xcb\x04\u9ed6", // 黖
	0x9ed7: "\xcb\x04\u9ed7", // 黗
	0x9ed8: "\xcb\x04\u9ed8", // 默
	0x9ed9: "V\v\u9ed9", // 黙
	0x9eda: "\xcb\x05\u9eda", // 黚
	0x9edb: "\xcb\x05\u9edb", // 黛
	0x9edc: "\xcb\x05\u9edc", // 黜
	0x9edd: "\xcb\x05\u9edd", // 黝
	0x9ede: "\xcb\x05\u9ede", // 點
	0x9edf: "\xcb\x06\u9edf", // 黟
	0x9ee0: "\xcb\x06\u9ee0", // 黠
	0x9ee1: "\xcb\x06\u9ee1", // 黡
	0x9ee2: "\xcb\a\u9ee2", // 黢
	0x9ee3: "\xcb\a\u9ee3", // 黣
	0x9ee4: "\xcb\b\u9ee4", // 黤
	0x9ee5: "\xcb\b\u9ee5", // 黥
	0x9ee6: "\xcb\b\u9ee6", // 黦
	0x9ee7: "\xcb\b\u9ee7", // 黧
	0x9ee8: "\xcb\b\u9ee8", // 黨
	0x9ee9: "\xcb\b\u9ee9", // 黩
	0x9eea: "\xcb\b\u9eea", // 黪
	0x9eeb: "\xcb\t\u9eeb", // 黫
	0x9eec: "\xcb\t\u9eec", // 黬
	0x9eed: "\xcb\t\u9eed", // 黭
	0x9eee: "\xcb\t\u9eee", // 黮
	0x9eef: "\xcb\t\u9eef", // 黯
	0x9ef0: "\xcb\n\u9ef0", // 黰
	0x9ef1: "\xcb\n\u9ef1", // 黱
	0x9ef2: "\xcb\v\u9ef2", // 黲
	0x9ef3: "\xcb\v\u9ef3", // 黳
	0x9ef4: "\xcb\v\u9ef4", // 黴
	0x9ef5: "\xcb\r\u9ef5", // 黵
	0x9ef6: "\xcb\x0e\u9ef6", // 黶
	0x9ef7: "\xcb\x0f\u9ef7", // 黷
	0x9ef8: "\xcb\x10\u9ef8", // 黸
	0x9ef9: "\xcc\x00\u9ef9", // 黹
	0x9efa: "\xcc\x04\u9efa", // 黺
	0x9efb: "\xcc\x05\u9efb", // 黻
	0x9efc: "\xcc\a\u9efc", // 黼
	0x9efd: "\xcd\x00\u9efd", // 黽
	0x9efe: "\xcd\x00\u9efe", // 黾
	0x9eff: "\xcd\x04\u9eff", // 黿
	0x9f00: "\xcd\x05\u9f00", // 鼀
	0x9f01: "\xcd\x05\u9f01", // 鼁
	0x9f02: "\xcd\x05\u9f02", // 鼂
	0x9f03: "\xcd\x06\u9f03", // 鼃
	0x9f04: "\xcd\x06\u9f04", // 鼄
	0x9f05: "\xcd\b\u9f05", // 鼅
	0x9f06: "\xcd\n\u9f06", // 鼆
	0x9f07: "\xcd\n\u9f07", // 鼇
	0x9f08: "\xcd\f\u9f08", // 鼈
	0x9f09: "\xcd\f\u9f09", // 鼉
	0x9f0a: "\xcd\r\u9f0a", // 鼊
	0x9f0b: "\xcd\x04\u9f0b", // 鼋
	0x9f0c: "\xcd\x05\u9f0c", // 鼌
	0x9f0d: "\xcd\f\u9f0d", // 鼍
	0x9f0e: "\xce\x00\u9f0e", // 鼎
	0x9f0f: "\xce\x02\u9f0f", // 鼏
	0x9f10: "\xce\x02\u9f10", // 鼐
	0x9f11: "\xce\x02\u9f11", // 鼑
	0x9f12: "\xce\x03\u9f12", // 鼒
	0x9f13: "\xcf\x00\u9f13", // 鼓
	0x9f14: "\xcf\x00\u9f14", // 鼔
	0x9f15: "\xcf\x05\u9f15", // 鼕
	0x9f16: "\xcf\x05\u9f16", // 鼖
	0x9f17: "\xcf\x06\u9f17", // 鼗
	0x9f18: "\xcf\b\u9f18", // 鼘
	0x9f19: "\xcf\b\u9f19", // 鼙
	0x9f1a: "\xcf\b\u9f1a", // 鼚
	0x9f1b: "\xcf\b\u9f1b", // 鼛
	0x9f1c: "\xcf\n\u9f1c", // 鼜
	0x9f1d: "\xcf\v\u9f1d", // 鼝
	0x9f1e: "\xcf\v\u9f1e", // 鼞
	0x9f1f: "\xcf\f\u9f1f", // 鼟
	0x9f20: "\xd0\x00\u9f20", // 鼠
	0x9f21: "\xd0\x00\u9f21", // 鼡
	0x9f22: "\xd0\x04\u9f22", // 鼢
	0x9f23: "\xd0\x04\u9f23", // 鼣
	0x9f24: "\xd0\x04\u9f24", // 鼤
	0x9f25: "\xd0\x05\u9f25", // 鼥
	0x9f26: "\xd0\x05\u9f26", // 鼦
	0x9f27: "\xd0\x05\u9f27", // 鼧
	0x9f28: "\xd0\x05\u9f28", // 鼨
	0x9f29: "\xd0\x05\u9f29", // 鼩
	0x9f2a: "\xd0\x05\u9f2a", // 鼪
	0x9f2b: "\xd0\x05\u9f2b", // 鼫
	0x9f2c: "\xd0\x05\u9f2c", // 鼬
	0x9f2d: "\xd0\x06\u9f2d", // 鼭
	0x9f2e: "\xd0\a\u9f2e", // 鼮
	0x9f2f: "\xd0\a\u9f2f", // 鼯
	0x9f30: "\xd0\a\u9f30", // 鼰
	0x9f31: "\xd0\b\u9f31", // 鼱
	0x9f32: "\xd0\t\u9f32", // 鼲
	0x9f33: "\xd0\t\u9f33", // 鼳
	0x9f34: "\xd0\t\u9f34", // 鼴
	0x9f35: "\xd0\t\u9f35", // 鼵
	0x9f36: "\xd0\n\u9f36", // 鼶
	0x9f37: "\xd0\n\u9f37", // 鼷
	0x9f38: "\xd0\n\u9f38", // 鼸
	0x9f39: "\xd0\n\u9f39", // 鼹
	0x9f3a: "\xd0\x0f\u9f3a", // 鼺
	0x9f3b: "\xd1\x00\u9f3b", // 鼻
	0x9f3c: "\xd1\x02\u9f3c", // 鼼
	0x9f3d: "\xd1\x02\u9f3d", // 鼽
	0x9f3e: "\xd1\x03\u9f3e", // 鼾
	0x9f3f: "\xd1\x03\u9f3f", // 鼿
	0x9f40: "\xd1\x05\u9f40", // 齀
	0x9f41: "\xd1\x05\u9f41", // 齁
	0x9f42: "\xd1\b\u9f42", // 齂
	0x9f43: "\xd1\t\u9f43", // 齃
	0x9f44: "\xd1\t\u9f44", // 齄
	0x9f45: "\xd1\n\u9f45", // 齅
	0x9f46: "\xd1\n\u9f46", // 齆
	0x9f47: "\xd1\v\u9f47", // 齇
	0x9f48: "\xd1\r\u9f48", // 齈
	0x9f49: "\xd1\x16\u9f49", // 齉
	0x9f4a: "\xd2\x00\u9f4a", // 齊
	0x9f4b: "\xd2\x03\u9f4b", // 齋
	0x9f4c: "\xd2\x04\u9f4c", // 齌
	0x9f4d: "\xd2\x05\u9f4d", // 齍
	0x9f4e: "\xd2\a\u9f4e", // 齎
	0x9f4f: "\xd2\t\u9f4f", // 齏
	0x9f50: "\xd2\x00\u9f50", // 齐
	0x9f51: "\xd2\t\u9f51", // 齑
	0x9f52: "\xd3\x00\u9f52", // 齒
	0x9f53: "\xd3\x01\u9f53", // 齓
	0x9f54: "\xd3\x02\u9f54", // 齔
	0x9f55: "\xd3\x03\u9f55", // 齕
	0x9f56: "\xd3\x04\u9f56", // 齖
	0x9f57: "\xd3\x04\u9f57", // 齗
	0x9f58: "\xd3\x04\u9f58", // 齘
	0x9f59: "\xd3\x05\u9f59", // 齙
	0x9f5a: "\xd3\x05\u9f5a", // 齚
	0x9f5b: "\xd3\x05\u9f5b", // 齛
	0x9f5c: "\xd3\x05\u9f5c", // 齜
	0x9f5d: "\xd3\x05\u9f5d", // 齝
	0x9f5e: "\xd3\x05\u9f5e", // 齞
	0x9f5f: "\xd3\x05\u9f5f", // 齟
	0x9f60: "\xd3\x05\u9f60", // 齠
	0x9f61: "\xd3\x05\u9f61", // 齡
	0x9f62: "\xd3\x05\u9f62", // 齢
	0x9f63: "\xd3\x05\u9f63", // 齣
	0x9f64: "\xd3\x06\u9f64", // 齤
	0x9f65: "\xd3\x06\u9f65", // 齥
	0x9f66: "\xd3\x06\u9f66", // 齦
	0x9f67: "\xd3\x06\u9f67", // 齧
	0x9f68: "\xd3\x06\u9f68", // 齨
	0x9f69: "\xd3\x06\u9f69", // 齩
	0x9f6a: "\xd3\a\u9f6a", // 齪
	0x9f6b: "\xd3\a\u9f6b", // 齫
	0x9f6c: "\xd3\a\u9f6c", // 齬
	0x9f6d: "\xd3\b\u9f6d", // 齭
	0x9f6e: "\xd3\b\u9f6e", // 齮
	0x9f6f: "\xd3\b\u9f6f", // 齯
	0x9f70: "\xd3\b\u9f70", // 齰
	0x9f71: "\xd3\b\u9f71", // 齱
	0x9f72: "\xd3\t\u9f72", // 齲
	0x9f73: "\xd3\t\u9f73", // 齳
	0x9f74: "\xd3\t\u9f74", // 齴
	0x9f75: "\xd3\t\u9f75", // 齵
	0x9f76: "\xd3\t\u9f76", // 齶
	0x9f77: "\xd3\t\u9f77", // 齷
	0x9f78: "\xd3\n\u9f78", // 齸
	0x9f79: "\xd3\n\u9f79", // 齹
	0x9f7a: "\xd3\n\u9f7a", // 齺
	0x9f7b: "\xd3\n\u9f7b", // 齻
	0x9f7c: "\xd3\r\u9f7c", // 齼
	0x9f7d: "\xd3\r\u9f7d", // 齽
	0x9f7e: "\xd3\x14\u9f7e", // 齾
	0x9f7f: "\xd3\x00\u9f7f", // 齿
	0x9f80: "\xd3\x02\u9f80", // 龀
	0x9f81: "\xd3\x03\u9f81", // 龁
	0x9f82: "\xd3\x04\u9f82", // 龂
	0x9f83: "\xd3\x05\u9f83", // 龃
	0x9f84: "\xd3\x05\u9f84", // 龄
	0x9f85: "\xd3\x05\u9f85", // 龅
	0x9f86: "\xd3\x05\u9f86", // 龆
	0x9f87: "\xd3\x06\u9f87", // 龇
	0x9f88: "\xd3\x06\u9f88", // 龈
	0x9f89: "\xd3\a\u9f89", // 龉
	0x9f8a: "\xd3\a\u9f8a", // 龊
	0x9f8b: "\xd3\t\u9f8b", // 龋
	0x9f8c: "\xd3\t\u9f8c", // 龌
	0x9f8d: "\xd4\x00\u9f8d", // 龍
	0x9f8e: "\xd4\x02\u9f8e", // 龎
	0x9f8f: "\xd4\x03\u9f8f", // 龏
	0x9f90: "5\x10\u9f90", // 龐
	0x9f91: "\xd4\x04\u9f91", // 龑
	0x9f92: "\xd4\x05\u9f92", // 龒
	0x9f93: "\xd4\x06\u9f93", // 龓
	0x9f94: "\xd4\x06\u9f94", // 龔
	0x9f95: "\xd4\x06\u9f95", // 龕
	0x9f96: "\xd4\x10\u9f96", // 龖
	0x9f97: "\xd4\x11\u9f97", // 龗
	0x9f98: "\xd4 \u9f98", // 龘
	0x9f99: "\xd4\x00\u9f99", // 龙
	0x9f9a: "\xd4\x06\u9f9a", // 龚
	0x9f9b: "\xd4\x06\u9f9b", // 龛
	0x9f9c: "\xd5\x00\u9f9c", // 龜
	0x9f9d: "\xd5\x05\u9f9d", // 龝
	0x9f9e: "\xd5\f\u9f9e", // 龞
	0x9f9f: "\xd5\x00\u9f9f", // 龟
	0x9fa0: "\xd6\x00\u9fa0", // 龠
	0x9fa1: "\xd6\x04\u9fa1", // 龡
	0x9fa2: "\xd6\x05\u9fa2", // 龢
	0x9fa3: "\xd6\b\u9fa3", // 龣
	0x9fa4: "\xd6\t\u9fa4", // 龤
	0x9fa5: "\xd6\t\u9fa5", // 龥
	0x9fa6: "V\v\u9fa6", // 龦
	0x9fa7: "H\f\u9fa7", // 龧
	0x9fa8: "\x16\b\u9fa8", // 龨
	0x9fa9: "\x8c\r\u9fa9", // 龩
	0x9faa: "\x9c\x02\u9faa", // 龪
	0x9fab: "\x9f\x05\u9fab", // 龫
	0x9fac: "\xa7\b\u9fac", // 龬
	0x9fad: "\xbb\v\u9fad", // 龭
	0x9fae: "\xbb\x11\u9fae", // 龮
	0x9faf: "\xa7\x05\u9faf", // 龯
	0x9fb0: "M\x00\u9fb0", // 龰
	0x9fb1: "\x1f\x02\u9fb1", // 龱
	0x9fb2: "\xa7\n\u9fb2", // 龲
	0x9fb3: " \r\u9fb3", // 龳
	0x9fb4: "\x05\x01\u9fb4", // 龴
	0x9fb5: "@\x00\u9fb5", // 龵
	0x9fb6: " \x01\u9fb6", // 龶
	0x9fb7: "\x8c\x01\u9fb7", // 龷
	0x9fb8: "*\x02\u9fb8", // 龸
	0x9fb9: "\f\x04\u9fb9", // 龹
	0x9fba: "\x18\x06\u9fba", // 龺
	0x9fbb: "\x95\f\u9fbb", // 龻
	0x9fbc: " \x0e\u9fbc", // 龼
	0x9fbd: "V\v\u9fbd", // 龽
	0x9fbe: "k\b\u9fbe", // 龾
	0x9fbf: "\x8c\b\u9fbf", // 龿
	0x9fc0: "\x8c\x12\u9fc0", // 鿀
	0x9fc1: "\x95\x06\u9fc1", // 鿁
	0x9fc2: "\x9f\v\u9fc2", // 鿂
	0x9fc3: "m\a\u9fc3", // 鿃
	0x9fc4: "K\x06\u9fc4", // 鿄
	0x9fc5: "q\r\u9fc5", // 鿅
	0x9fc6: "q\x04\u9fc6", // 鿆
	0x9fc7: "\t\x06\u9fc7", // 鿇
	0x9fc8: "<\x04\u9fc8", // 鿈
	0x9fc9: "<\x04\u9fc9", // 鿉
	0x9fca: "\x8c\a\u9fca", // 鿊
	0x9fcb: "\x91\f\u9fcb", // 鿋
	0x9fcc: "U\t\u9fcc", // 鿌
	0x9fcd: " \x06\u9fcd", // 鿍
	0x9fce: "p\x06\u9fce", // 鿎
	0x9fcf: "\xa7\a\u9fcf", // 鿏
	0x9fd0: "\xc3\n\u9fd0", // 鿐
	0x9fd1: "\x0f\x05\u9fd1", // 鿑
	0x9fd2: "\x8c\x06\u9fd2", // 鿒
	0x9fd3: "\x8c\t\u9fd3", // 鿓
	0x9fd4: "\xa7\n\u9fd4", // 鿔
	0x9fd5: "\xc3\x04\u9fd5", // 鿕
	0x9fd6: "\x01\x06\u9fd6", // 鿖
	0x9fd7: "\x01\b\u9fd7", // 鿗
	0x9fd8: "\t\n\u9fd8", // 鿘
	0x9fd9: "\t\v\u9fd9", // 鿙
	0x9fda: "\t\x0e\u9fda", // 鿚
	0x9fdb: "\x0f\x16\u9fdb", // 鿛
	0x9fdc: "@\x13\u9fdc", // 鿜
	0x9fdd: "K\x17\u9fdd", // 鿝
	0x9fde: "N\x10\u9fde", // 鿞
	0x9fdf: "s\a\u9fdf", // 鿟
	0x9fe0: "s\x10\u9fe0", // 鿠
	0x9fe1: "z\x1c\u9fe1", // 鿡
	0x9fe2: "\x80\b\u9fe2", // 鿢
	0x9fe3: "\x80\t\u9fe3", // 鿣
	0x9fe4: "\x80\f\u9fe4", // 鿤
	0x9fe5: "\x8a\x11\u9fe5", // 鿥
	0x9fe6: "\x8c\x12\u9fe6", // 鿦
	0x9fe7: "\xaa\x17\u9fe7", // 鿧
	0x9fe8: "\xad\x13\u9fe8", // 鿨
	0x9fe9: "\xc3\x12\u9fe9", // 鿩
	0x9fea: "V\r\u9fea", // 鿪
	0xf900: "\x97\x03\uf900", // 豈
	0xf901: "I\x03\uf901", // 更
	0xf902: "\x9f\x00\uf902", // 車
	0xf903: "\x9a\x06\uf903", // 賈
	0xf904: "U\n\uf904", // 滑
	0xf905: "\x02\x06\uf905", // 串
	0xf906: "\x1e\x02\uf906", // 句
	0xf907: "\xd5\x00\uf907", // 龜
	0xf908: "\xd5\x00\uf908", // 龜
	0xf909: "%\x06\uf909", // 契
	0xf90a: "\xa7\x00\uf90a", // 金
	0xf90b: "\x1e\t\uf90b", // 喇
	0xf90c: "%\x05\uf90c", // 奈
	0xf90d: "=\x10\uf90d", // 懶
	0xf90e: "h\x10\uf90e", // 癩
	0xf90f: "z\x0e\uf90f", // 羅
	0xf910: "\x8c\x13\uf910", // 蘿
	0xf911: "\x8e\v\uf911", // 螺
	0xf912: "\x91\b\uf912", // 裸
	0xf913: "\xa2\x13\uf913", // 邏
	0xf914: "K\v\uf914", // 樂
	0xf915: "U\x06\uf915", // 洛
	0xf916: "V\x06\uf916", // 烙
	0xf917: "`\x06\uf917", // 珞
	0xf918: "\x8c\t\uf918", // 落
	0xf919: "\xa4\x06\uf919", // 酪
	0xf91a: "\xbb\x06\uf91a", // 駱
	0xf91b: "\x05\f\uf91b", // 亂
	0xf91c: "\x1a\x05\uf91c", // 卵
	0xf91d: "K\x11\uf91d", // 欄
	0xf91e: "V\x11\uf91e", // 爛
	0xf91f: "\x8c\x11\uf91f", // 蘭
	0xf920: "\xc4\x13\uf920", // 鸞
	0xf921: ".\t\uf921", // 嵐
	0xf922: "U\x0e\uf922", // 濫
	0xf923: "\x8c\x0e\uf923", // 藍
	0xf924: "\x91\x0e\uf924", // 襤
	0xf925: "@\x05\uf925", // 拉
	0xf926: "\x82\x0f\uf926", // 臘
	0xf927: "\x8e\x0f\uf927", // 蠟
	0xf928: "5\t\uf928", // 廊
	0xf929: "J\a\uf929", // 朗
	0xf92a: "U\a\uf92a", // 浪
	0xf92b: "^\a\uf92b", // 狼
	0xf92c: "\xa3\x06\uf92c", // 郎
	0xf92d: "\t\x06\uf92d", // 來
	0xf92e: "\x0f\x05\uf92e", // 冷
	0xf92f: "\x13\n\uf92f", // 勞
	0xf930: "@\r\uf930", // 擄
	0xf931: "K\x0f\uf931", // 櫓
	0xf932: "V\x10\uf932", // 爐
	0xf933: "l\v\uf933", // 盧
	0xf934: "}\x00\uf934", // 老
	0xf935: "\x8c\x10\uf935", // 蘆
	0xf936: "\x8d\x06\uf936", // 虜
	0xf937: "\x9d\x06\uf937", // 路
	0xf938: "\xad\f\uf938", // 露
	0xf939: "\xc3\x04\uf939", // 魯
	0xf93a: "\xc4\f\uf93a", // 鷺
	0xf93b: "p\b\uf93b", // 碌
	0xf93c: "q\b\uf93c", // 祿
	0xf93d: "x\b\uf93d", // 綠
	0xf93e: "\x8c\b\uf93e", // 菉
	0xf93f: "\xa7\b\uf93f", // 錄
	0xf940: "\xc6\x00\uf940", // 鹿
	0xf941: "\x95\b\uf941", // 論
	0xf942: " \x10\uf942", // 壟
	0xf943: "7\x04\uf943", // 弄
	0xf944: "v\x10\uf944", // 籠
	0xf945: "\x80\x10\uf945", // 聾
	0xf946: "]\x03\uf946", // 牢
	0xf947: "p\n\uf947", // 磊
	0xf948: "\x9a\x06\uf948", // 賂
	0xf949: "\xad\x05\uf949", // 雷
	0xf94a: " \x0f\uf94a", // 壘
	0xf94b: ",\v\uf94b", // 屢
	0xf94c: "K\v\uf94c", // 樓
	0xf94d: "U\b\uf94d", // 淚
	0xf94e: "U\v\uf94e", // 漏
	0xf94f: "x\x05\uf94f", // 累
	0xf950: "x\v\uf950", // 縷
	0xf951: "\xaa\x06\uf951", // 陋
	0xf952: "\x13\t\uf952", // 勒
	0xf953: "\x82\x02\uf953", // 肋
	0xf954: "\x0f\r\uf954", // 凜
	0xf955: "\x0f\b\uf955", // 凌
	0xf956: "s\b\uf956", // 稜
	0xf957: "x\b\uf957", // 綾
	0xf958: "\x8c\b\uf958", // 菱
	0xf959: "\xaa\b\uf959", // 陵
	0xf95a: "\x95\x0f\uf95a", // 讀
	0xf95b: "@\x05\uf95b", // 拏
	0xf95c: "K\v\uf95c", // 樂
	0xf95d: "\x95\t\uf95d", // 諾
	0xf95e: "\x03\x03\uf95e", // 丹
	0xf95f: "(\v\uf95f", // 寧
	0xf960: "=\x05\uf960", // 怒
	0xf961: "_\x06\uf961", // 率
	0xf962: "f\a\uf962", // 異
	0xf963: "\x15\x03\uf963", // 北
	0xf964: "p\f\uf964", // 磻
	0xf965: "\t\a\uf965", // 便
	0xf966: "<\t\uf966", // 復
	0xf967: "\x01\x03\uf967", // 不
	0xf968: "U\x05\uf968", // 泌
	0xf969: "B\v\uf969", // 數
	0xf96a: "x\x04\uf96a", // 索
	0xf96b: "\x1c\t\uf96b", // 參
	0xf96c: " \n\uf96c", // 塞
	0xf96d: "m\x04\uf96d", // 省
	0xf96e: "\x8c\t\uf96e", // 葉
	0xf96f: "\x95\a\uf96f", // 說
	0xf970: "O\a\uf970", // 殺
	0xf971: "\xa1\x00\uf971", // 辰
	0xf972: "U\x04\uf972", // 沈
	0xf973: "@\x06\uf973", // 拾
	0xf974: "\x8c\x05\uf974", // 若
	0xf975: "@\b\uf975", // 掠
	0xf976: "f\x06\uf976", // 略
	0xf977: "\b\a\uf977", // 亮
	0xf978: "\v\x06\uf978", // 兩
	0xf979: "\x0f\b\uf979", // 凉
	0xf97a: "K\a\uf97a", // 梁
	0xf97b: "w\f\uf97b", // 糧
	0xf97c: "\x8a\x01\uf97c", // 良
	0xf97d: "\x95\b\uf97d", // 諒
	0xf97e: "\xa6\x05\uf97e", // 量
	0xf97f: "\x13\x0f\uf97f", // 勵
	0xf980: "\x1e\x04\uf980", // 呂
	0xf981: "&\x00\uf981", // 女
	0xf982: "5\x10\uf982", // 廬
	0xf983: "F\x06\uf983", // 旅
	0xf984: "U\x0f\uf984", // 濾
	0xf985: "p\x0f\uf985", // 礪
	0xf986: "\xa9\a\uf986", // 閭
	0xf987: "\xbb\x13\uf987", // 驪
	0xf988: "\xc6\b\uf988", // 麗
	0xf989: "\xca\x03\uf989", // 黎
	0xf98a: "\x13\x00\uf98a", // 力
	0xf98b: "H\f\uf98b", // 曆
	0xf98c: "M\f\uf98c", // 歷
	0xf98d: "\x9f\x0f\uf98d", // 轢
	0xf98e: "3\x03\uf98e", // 年
	0xf98f: "=\f\uf98f", // 憐
	0xf990: "=\x13\uf990", // 戀
	0xf991: "@\f\uf991", // 撚
	0xf992: "U\v\uf992", // 漣
	0xf993: "V\t\uf993", // 煉
	0xf994: "`\v\uf994", // 璉
	0xf995: "s\x03\uf995", // 秊
	0xf996: "x\t\uf996", // 練
	0xf997: "\x80\v\uf997", // 聯
	0xf998: "\x9f\b\uf998", // 輦
	0xf999: "\x8c\v\uf999", // 蓮
	0xf99a: "\xa2\a\uf99a", // 連
	0xf99b: "\xa7\t\uf99b", // 鍊
	0xf99c: "\x12\x04\uf99c", // 列
	0xf99d: "\x13\x04\uf99d", // 劣
	0xf99e: "\x1e\x06\uf99e", // 咽
	0xf99f: "V\x06\uf99f", // 烈
	0xf9a0: "\x91\x06\uf9a0", // 裂
	0xf9a1: "\x95\a\uf9a1", // 說
	0xf9a2: "5\n\uf9a2", // 廉
	0xf9a3: "=\x04\uf9a3", // 念
	0xf9a4: "@\b\uf9a4", // 捻
	0xf9a5: "N\r\uf9a5", // 殮
	0xf9a6: "v\r\uf9a6", // 簾
	0xf9a7: "^\x0f\uf9a7", // 獵
	0xf9a8: "\t\x03\uf9a8", // 令
	0xf9a9: "\x1f\x05\uf9a9", // 囹
	0xf9aa: "(\v\uf9aa", // 寧
	0xf9ab: ".\x0e\uf9ab", // 嶺
	0xf9ac: "=\x05\uf9ac", // 怜
	0xf9ad: "`\x05\uf9ad", // 玲
	0xf9ae: "`\n\uf9ae", // 瑩
	0xf9af: "{\x05\uf9af", // 羚
	0xf9b0: "\x80\x05\uf9b0", // 聆
	0xf9b1: "\xa7\x05\uf9b1", // 鈴
	0xf9b2: "\xad\x05\uf9b2", // 零
	0xf9b3: "\xad\x10\uf9b3", // 靈
	0xf9b4: "\xb5\x05\uf9b4", // 領
	0xf9b5: "\t\x06\uf9b5", // 例
	0xf9b6: "q\r\uf9b6", // 禮
	0xf9b7: "\xa4\r\uf9b7", // 醴
	0xf9b8: "\xab\t\uf9b8", // 隸
	0xf9b9: "=\b\uf9b9", // 惡
	0xf9ba: "\x06\x01\uf9ba", // 了
	0xf9bb: "\t\f\uf9bb", // 僚
	0xf9bc: "(\f\uf9bc", // 寮
	0xf9bd: ",\x04\uf9bd", // 尿
	0xf9be: "D\x06\uf9be", // 料
	0xf9bf: "K\v\uf9bf", // 樂
	0xf9c0: "V\f\uf9c0", // 燎
	0xf9c1: "h\f\uf9c1", // 療
	0xf9c2: "\x8c\v\uf9c2", // 蓼
	0xf9c3: "\xa2\f\uf9c3", // 遼
	0xf9c4: "\xd4\x00\uf9c4", // 龍
	0xf9c5: "H\t\uf9c5", // 暈
	0xf9c6: "\xaa\x04\uf9c6", // 阮
	0xf9c7: "\x12\r\uf9c7", // 劉
	0xf9c8: "K\x04\uf9c8", // 杻
	0xf9c9: "K\x05\uf9c9", // 柳
	0xf9ca: "U\x06\uf9ca", // 流
	0xf9cb: "U\n\uf9cb", // 溜
	0xf9cc: "`\x06\uf9cc", // 琉
	0xf9cd: "f\x05\uf9cd", // 留
	0xf9ce: "p\a\uf9ce", // 硫
	0xf9cf: "x\x04\uf9cf", // 紐
	0xf9d0: "\xb5\n\uf9d0", // 類
	0xf9d1: "\f\x02\uf9d1", // 六
	0xf9d2: ">\v\uf9d2", // 戮
	0xf9d3: "\xaa\b\uf9d3", // 陸
	0xf9d4: "\t\b\uf9d4", // 倫
	0xf9d5: ".\b\uf9d5", // 崙
	0xf9d6: "U\b\uf9d6", // 淪
	0xf9d7: "\x9f\b\uf9d7", // 輪
	0xf9d8: "<\x06\uf9d8", // 律
	0xf9d9: "=\n\uf9d9", // 慄
	0xf9da: "K\x06\uf9da", // 栗
	0xf9db: "_\x06\uf9db", // 率
	0xf9dc: "\xaa\t\uf9dc", // 隆
	0xf9dd: "\x12\x05\uf9dd", // 利
	0xf9de: "\x1e\x03\uf9de", // 吏
	0xf9df: ",\f\uf9df", // 履
	0xf9e0: "H\x04\uf9e0", // 易
	0xf9e1: "K\x03\uf9e1", // 李
	0xf9e2: "K\a\uf9e2", // 梨
	0xf9e3: "U\x05\uf9e3", // 泥
	0xf9e4: "`\a\uf9e4", // 理
	0xf9e5: "h\a\uf9e5", // 痢
	0xf9e6: "z\v\uf9e6", // 罹
	0xf9e7: "\x91\a\uf9e7", // 裏
	0xf9e8: "\x91\a\uf9e8", // 裡
	0xf9e9: "\xa6\x00\uf9e9", // 里
	0xf9ea: "\xac\v\uf9ea", // 離
	0xf9eb: "\x17\t\uf9eb", // 匿
	0xf9ec: "U\n\uf9ec", // 溺
	0xf9ed: "\x1e\x04\uf9ed", // 吝
	0xf9ee: "V\f\uf9ee", // 燐
	0xf9ef: "`\f\uf9ef", // 璘
	0xf9f0: "\x8c\x10\uf9f0", // 藺
	0xf9f1: "\xaa\f\uf9f1", // 隣
	0xf9f2: "\xc3\f\uf9f2", // 鱗
	0xf9f3: "\xc6\f\uf9f3", // 麟
	0xf9f4: "K\x04\uf9f4", // 林
	0xf9f5: "U\b\uf9f5", // 淋
	0xf9f6: "\x83\v\uf9f6", // 臨
	0xf9f7: "u\x00\uf9f7", // 立
	0xf9f8: "v\x05\uf9f8", // 笠
	0xf9f9: "w\x05\uf9f9", // 粒
	0xf9fa: "^\x04\uf9fa", // 狀
	0xf9fb: "V\x04\uf9fb", // 炙
	0xf9fc: "\x95\f\uf9fc", // 識
	0xf9fd: "\t\x02\uf9fd", // 什
	0xf9fe: "\x8c\x06\uf9fe", // 茶
	0xf9ff: "\x12\x06\uf9ff", // 刺
	0xfa00: "\x12\x02\ufa00", // 切
	0xfa01: "5\x06\ufa01", // 度
	0xfa02: "@\x05\ufa02", // 拓
	0xfa03: "w\n\ufa03", // 糖
	0xfa04: "(\x03\ufa04", // 宅
	0xfa05: "U\x06\ufa05", // 洞
	0xfa06: "H\v\ufa06", // 暴
	0xfa07: "\x9f\t\ufa07", // 輻
	0xfa08: "\x90\x00\ufa08", // 行
	0xfa09: "\xaa\x06\ufa09", // 降
	0xfa0a: "\x93\x00\ufa0a", // 見
	0xfa0b: "5\v\ufa0b", // 廓
	0xfa0c: "\n\x01\ufa0c", // 兀
	0xfa0d: "\x1e\n\ufa0d", // 嗀
	0xfa0e: "\x1d\v\ufa0e", // 﨎
	0xfa0f: " \a\ufa0f", // 﨏
	0xfa10: " \n\ufa10", // 塚
	0xfa11: ".\t\ufa11", // 﨑
	0xfa12: "H\b\ufa12", // 晴
	0xfa13: "K\t\ufa13", // 﨓
	0xfa14: "K\n\ufa14", // 﨔
	0xfa15: "\x0f\x0e\ufa15", // 凞
	0xfa16: "^\b\ufa16", // 猪
	0xfa17: "l\x05\ufa17", // 益
	0xfa18: "q\x01\ufa18", // 礼
	0xfa19: "q\x05\ufa19", // 神
	0xfa1a: "q\x06\ufa1a", // 祥
	0xfa1b: "q\t\ufa1b", // 福
	0xfa1c: "\xae\x05\ufa1c", // 靖
	0xfa1d: "w\b\ufa1d", // 精
	0xfa1e: "|\x00\ufa1e", // 羽
	0xfa1f: "\x8c\r\ufa1f", // 﨟
	0xfa20: "\x8c\x11\ufa20", // 蘒
	0xfa21: "\x8e\x05\ufa21", // 﨡
	0xfa22: "\x95\t\ufa22", // 諸
	0xfa23: "\x9c\x04\ufa23", // 﨣
	0xfa24: "\xa2\x04\ufa24", // 﨤
	0xfa25: "\xa2\b\ufa25", // 逸
	0xfa26: "\xa3\t\ufa26", // 都
	0xfa27: "\xa7\a\ufa27", // 﨧
	0xfa28: "\xa7\b\ufa28", // 﨨
	0xfa29: "\xaa\n\ufa29", // 﨩
	0xfa2a: "\xb8\x04\ufa2a", // 飯
	0xfa2b: "\xb8\x05\ufa2b", // 飼
	0xfa2c: "\xb8\b\ufa2c", // 館
	0xfa2d: "\xc4\n\ufa2d", // 鶴
	0xfa2e: "\xa3\a\ufa2e", // 郞
	0xfa2f: "\xab\b\ufa2f", // 隷
	0xfa30: "\t\a\ufa30", // 侮
	0xfa31: "\t\f\ufa31", // 僧
	0xfa32: "\n\x06\ufa32", // 免
	0xfa33: "\x13\a\ufa33", // 勉
	0xfa34: "\x13\v\ufa34", // 勤
	0xfa35: "\x18\x06\ufa35", // 卑
	0xfa36: "\x1e\t\ufa36", // 喝
	0xfa37: "\x1e\v\ufa37", // 嘆
	0xfa38: "\x1e\r\ufa38", // 器
	0xfa39: " \t\ufa39", // 塀
	0xfa3a: " \f\ufa3a", // 墨
	0xfa3b: ",\f\ufa3b", // 層
	0xfa3c: "-\x00\ufa3c", // 屮
	0xfa3d: "=\a\ufa3d", // 悔
	0xfa3e: "=\t\ufa3e", // 慨
	0xfa3f: "=\f\ufa3f", // 憎
	0xfa40: "=\x0f\ufa40", // 懲
	0xfa41: "B\a\ufa41", // 敏
	0xfa42: "G\x05\ufa42", // 既
	0xfa43: "H\b\ufa43", // 暑
	0xfa44: "K\a\ufa44", // 梅
	0xfa45: "U\a\ufa45", // 海
	0xfa46: "U\b\ufa46", // 渚
	0xfa47: "U\v\ufa47", // 漢
	0xfa48: "V\b\ufa48", // 煮
	0xfa49: "W\x00\ufa49", // 爫
	0xfa4a: "`\b\ufa4a", // 琢
	0xfa4b: "p\b\ufa4b", // 碑
	0xfa4c: "q\x03\ufa4c", // 社
	0xfa4d: "q\x04\ufa4d", // 祉
	0xfa4e: "q\x04\ufa4e", // 祈
	0xfa4f: "q\x05\ufa4f", // 祐
	0xfa50: "q\x05\ufa50", // 祖
	0xfa51: "q\x05\ufa51", // 祝
	0xfa52: "q\t\ufa52", // 禍
	0xfa53: "q\t\ufa53", // 禎
	0xfa54: "s\n\ufa54", // 穀
	0xfa55: "t\x04\ufa55", // 突
	0xfa56: "v\a\ufa56", // 節
	0xfa57: "x\t\ufa57", // 練
	0xfa58: "x\n\ufa58", // 縉
	0xfa59: "x\v\ufa59", // 繁
	0xfa5a: "z\b\ufa5a", // 署
	0xfa5b: "}\x04\ufa5b", // 者
	0xfa5c: "\x84\x04\ufa5c", // 臭
	0xfa5d: "\x8c\x00\ufa5d", // 艹
	0xfa5e: "\x8c\x00\ufa5e", // 艹
	0xfa5f: "\x8c\b\ufa5f", // 著
	0xfa60: "\x91\t\ufa60", // 褐
	0xfa61: "\x93\x04\ufa61", // 視
	0xfa62: "\x95\t\ufa62", // 謁
	0xfa63: "\x95\v\ufa63", // 謹
	0xfa64: "\x9a\a\ufa64", // 賓
	0xfa65: "\x9a\f\ufa65", // 贈
	0xfa66: "\xa2\x00\ufa66", // 辶
	0xfa67: "\xa2\b\ufa67", // 逸
	0xfa68: "\xac\v\ufa68", // 難
	0xfa69: "\xb4\v\ufa69", // 響
	0xfa6a: "\xb5\a\ufa6a", // 頻
	0xfa6b: "=\a\ufa6b", // 恵
	0xfa6c: "V\n\ufa6c", // 𤋮
	0xfa6d: "\x1e\r\ufa6d", // 舘
	0xfa70: "\x01\a\ufa70", // 並
	0xfa71: "\x0f\x05\ufa71", // 况
	0xfa72: "\v\x04\ufa72", // 全
	0xfa73: "\t\x06\ufa73", // 侀
	0xfa74: "\n\x04\ufa74", // 充
	0xfa75: "\f\x0e\ufa75", // 冀
	0xfa76: "\x13\a\ufa76", // 勇
	0xfa77: "\x14\x01\ufa77", // 勺
	0xfa78: "\x1e\t\ufa78", // 喝
	0xfa79: "\x1e\b\ufa79", // 啕
	0xfa7a: "\x1e\t\ufa7a", // 喙
	0xfa7b: "\x1e\n\ufa7b", // 嗢
	0xfa7c: " \n\ufa7c", // 塚
	0xfa7d: " \f\ufa7d", // 墳
	0xfa7e: "%\x05\ufa7e", // 奄
	0xfa7f: "%\x06\ufa7f", // 奔
	0xfa80: "&\b\ufa80", // 婢
	0xfa81: "&\x0e\ufa81", // 嬨
	0xfa82: "5\v\ufa82", // 廒
	0xfa83: "5\f\ufa83", // 廙
	0xfa84: ";\b\ufa84", // 彩
	0xfa85: "<\n\ufa85", // 徭
	0xfa86: "=\b\ufa86", // 惘
	0xfa87: "=\n\ufa87", // 慎
	0xfa88: "=\t\ufa88", // 愈
	0xfa89: "=\f\ufa89", // 憎
	0xfa8a: "=\v\ufa8a", // 慠
	0xfa8b: "=\x0f\ufa8b", // 懲
	0xfa8c: ">\r\ufa8c", // 戴
	0xfa8d: "@\t\ufa8d", // 揄
	0xfa8e: "@\n\ufa8e", // 搜
	0xfa8f: "@\t\ufa8f", // 摒
	0xfa90: "B\a\ufa90", // 敖
	0xfa91: "H\b\ufa91", // 晴
	0xfa92: "J\a\ufa92", // 朗
	0xfa93: "J\a\ufa93", // 望
	0xfa94: "K\x03\ufa94", // 杖
	0xfa95: "N\x00\ufa95", // 歹
	0xfa96: "O\a\ufa96", // 殺
	0xfa97: "U\x06\ufa97", // 流
	0xfa98: "U\n\ufa98", // 滛
	0xfa99: "U\t\ufa99", // 滋
	0xfa9a: "U\v\ufa9a", // 漢
	0xfa9b: "U\x10\ufa9b", // 瀞
	0xfa9c: "V\b\ufa9c", // 煮
	0xfa9d: "m\f\ufa9d", // 瞧
	0xfa9e: "W\x0e\ufa9e", // 爵
	0xfa9f: "^\x02\ufa9f", // 犯
	0xfaa0: "^\b\ufaa0", // 猪
	0xfaa1: "`\n\ufaa1", // 瑱
	0xfaa2: "b\t\ufaa2", // 甆
	0xfaa3: "f\x03\ufaa3", // 画
	0xfaa4: "h\n\ufaa4", // 瘝
	0xfaa5: "h\t\ufaa5", // 瘟
	0xfaa6: "l\x05\ufaa6", // 益
	0xfaa7: "l\x06\ufaa7", // 盛
	0xfaa8: "m\x03\ufaa8", // 直
	0xfaa9: "m\a\ufaa9", // 睊
	0xfaaa: "m\a\ufaaa", // 着
	0xfaab: "p\n\ufaab", // 磌
	0xfaac: "t\n\ufaac", // 窱
	0xfaad: "v\a\ufaad", // 節
	0xfaae: "w\x03\ufaae", // 类
	0xfaaf: "x\a\ufaaf", // 絛
	0xfab0: "x\t\ufab0", // 練
	0xfab1: "y\x06\ufab1", // 缾
	0xfab2: "}\x04\ufab2", // 者
	0xfab3: "\x8c\x06\ufab3", // 荒
	0xfab4: "\x8c\b\ufab4", // 華
	0xfab5: "\x8e\n\ufab5", // 蝹
	0xfab6: "\x91\v\ufab6", // 襁
	0xfab7: "\x92\f\ufab7", // 覆
	0xfab8: "q\a\ufab8", // 視
	0xfab9: "\x95\b\ufab9", // 調
	0xfaba: "\x95\t\ufaba", // 諸
	0xfabb: "\x95\b\ufabb", // 請
	0xfabc: "\x95\t\ufabc", // 謁
	0xfabd: "\x95\t\ufabd", // 諾
	0xfabe: "\x95\t\ufabe", // 諭
	0xfabf: "\x95\v\ufabf", // 謹
	0xfac0: "\x95\x10\ufac0", // 變
	0xfac1: "\x9a\f\ufac1", // 贈
	0xfac2: "\x9f\t\ufac2", // 輸
	0xfac3: "\xa2\f\ufac3", // 遲
	0xfac4: "\xa4\n\ufac4", // 醙
	0xfac5: "\xa7\x06\ufac5", // 鉶
	0xfac6: "\xaa\t\ufac6", // 陼
	0xfac7: "\xac\v\ufac7", // 難
	0xfac8: "\xae\x05\ufac8", // 靖
	0xfac9: "\xb2\v\ufac9", // 韛
	0xfaca: "\xb4\v\ufaca", // 響
	0xfacb: "\xb5\x04\ufacb", // 頋
	0xfacc: "\xb5\a\ufacc", // 頻
	0xfacd: "\xbe\n\ufacd", // 鬒
	0xface: "\xd5\x00\uface", // 龜
	0xfacf: "=\f\ufacf", // 𢡊
	0xfad0: "=\f\ufad0", // 𢡄
	0xfad1: "K\x04\ufad1", // 𣏕
	0xfad2: "K\t\ufad2", // 㮝
	0xfad3: "m\x04\ufad3", // 䀘
	0xfad4: "m\a\ufad4", // 䀹
	0xfad5: "m\n\ufad5", // 𥉉
	0xfad6: "v\f\ufad6", // 𥳐
	0xfad7: "\x9c\x06\ufad7", // 𧻓
	0xfad8: "\xd1\t\ufad8", // 齃
	0xfad9: "\xd4\x02\ufad9", // 龎
	0x20000: "\x01\x01\U00020000", // 𠀀
	0x20001: "\x01\x01\U00020001", // 𠀁
	0x20002: "\x01\x01\U00020002", // 𠀂
	0x20003: "\x01\x02\U00020003", // 𠀃
	0x20004: "\x01\x02\U00020004", // 𠀄
	0x20005: "\x01\x02\U00020005", // 𠀅
	0x20006: "\x01\x02\U00020006", // 𠀆
	0x20007: "\x01\x03\U00020007", // 𠀇
	0x20008: "\x01\x03\U00020008", // 𠀈
	0x20009: "\x01\x03\U00020009", // 𠀉
	0x2000a: "\x01\x03\U0002000a", // 𠀊
	0x2000b: "\x01\x03\U0002000b", // 𠀋
	0x2000c: "\x01\x03\U0002000c", // 𠀌
	0x2000d: "\x01\x04\U0002000d", // 𠀍
	0x2000e: "\x01\x04\U0002000e", // 𠀎
	0x2000f: "\x01\x04\U0002000f", // 𠀏
	0x20010: "\x01\x04\U00020010", // 𠀐
	0x20011: "\x01\x04\U00020011", // 𠀑
	0x20012: "\x01\x04\U00020012", // 𠀒
	0x20013: "\x01\x04\U00020013", // 𠀓
	0x20014: "\x01\x04\U00020014", // 𠀔
	0x20015: "\x01\x04\U00020015", // 𠀕
	0x20016: "\x01\x04\U00020016", // 𠀖
	0x20017: "\x01\x04\U00020017", // 𠀗
	0x20018: "\x01\x05\U00020018", // 𠀘
	0x20019: "\x01\x05\U00020019", // 𠀙
	0x2001a: "\x01\x05\U0002001a", // 𠀚
	0x2001b: "%\x03\U0002001b", // 𠀛
	0x2001c: "\x01\x05\U0002001c", // 𠀜
	0x2001d: "\x19\x04\U0002001d", // 𠀝
	0x2001e: "\x01\x05\U0002001e", // 𠀞
	0x2001f: "\x01\x05\U0002001f", // 𠀟
	0x20020: "\x01\x05\U00020020", // 𠀠
	0x20021: "\x01\x06\U00020021", // 𠀡
	0x20022: "\x01\x06\U00020022", // 𠀢
	0x20023: "\x01\x06\U00020023", // 𠀣
	0x20024: "\x01\x06\U00020024", // 𠀤
	0x20025: "\a\x05\U00020025", // 𠀥
	0x20026: "\x01\x06\U00020026", // 𠀦
	0x20027: "\x01\x06\U00020027", // 𠀧
	0x20028: "\x01\x06\U00020028", // 𠀨
	0x20029: "\x06\x05\U00020029", // 𠀩
	0x2002a: "\x01\x06\U0002002a", // 𠀪
	0x2002b: "\x01\x06\U0002002b", // 𠀫
	0x2002c: "\x01\a\U0002002c", // 𠀬
	0x2002d: "\x01\a\U0002002d", // 𠀭
	0x2002e: "\x01\a\U0002002e", // 𠀮
	0x2002f: "\x1f\x05\U0002002f", // 𠀯
	0x20030: "\x01\a\U00020030", // 𠀰
	0x20031: "\x01\a\U00020031", // 𠀱
	0x20032: "\x01\a\U00020032", // 𠀲
	0x20033: "\x01\a\U00020033", // 𠀳
	0x20034: "\x01\a\U00020034", // 𠀴
	0x20035: "\x01\b\U00020035", // 𠀵
	0x20036: "\x01\b\U00020036", // 𠀶
	0x20037: "\x1e\x06\U00020037", // 𠀷
	0x20038: "\x01\b\U00020038", // 𠀸
	0x20039: "\x1e\x06\U00020039", // 𠀹
	0x2003a: "\x01\b\U0002003a", // 𠀺
	0x2003b: "\x01\b\U0002003b", // 𠀻
	0x2003c: "#\a\U0002003c", // 𠀼
	0x2003d: "\x01\t\U0002003d", // 𠀽
	0x2003e: "\x01\t\U0002003e", // 𠀾
	0x2003f: "\x01\t\U0002003f", // 𠀿
	0x20040: "\x01\t\U00020040", // 𠁀
	0x20041: "\x01\n\U00020041", // 𠁁
	0x20042: "\x01\n\U00020042", // 𠁂
	0x20043: "\x01\n\U00020043", // 𠁃
	0x20044: "\x01\n\U00020044", // 𠁄
	0x20045: "\x01\n\U00020045", // 𠁅
	0x20046: "\x01\v\U00020046", // 𠁆
	0x20047: "\x01\v\U00020047", // 𠁇
	0x20048: "\x01\v\U00020048", // 𠁈
	0x20049: "\x10\n\U00020049", // 𠁉
	0x2004a: "\x01\v\U0002004a", // 𠁊
	0x2004b: "\x01\v\U0002004b", // 𠁋
	0x2004c: "\x01\f\U0002004c", // 𠁌
	0x2004d: "\x01\f\U0002004d", // 𠁍
	0x2004e: "\x01\r\U0002004e", // 𠁎
	0x2004f: "\x01\r\U0002004f", // 𠁏
	0x20050: "\x01\r\U00020050", // 𠁐
	0x20051: "\x01\r\U00020051", // 𠁑
	0x20052: "\x01\r\U00020052", // 𠁒
	0x20053: "\x01\x0e\U00020053", // 𠁓
	0x20054: "\x01\x0e\U00020054", // 𠁔
	0x20055: "\x01\x0f\U00020055", // 𠁕
	0x20056: "\x01\x10\U00020056", // 𠁖
	0x20057: "\x01\x0f\U00020057", // 𠁗
	0x20058: "\x01\x0f\U00020058", // 𠁘
	0x20059: "\x01\x0f\U00020059", // 𠁙
	0x2005a: "\x01\x0f\U0002005a", // 𠁚
	0x2005b: "\x01\x0f\U0002005b", // 𠁛
	0x2005c: "\f\x0f\U0002005c", // 𠁜
	0x2005d: "\x01\x0f\U0002005d", // 𠁝
	0x2005e: "H\r\U0002005e", // 𠁞
	0x2005f: "\x01\x11\U0002005f", // 𠁟
	0x20060: "\x01\x13\U00020060", // 𠁠
	0x20061: "\x02\x01\U00020061", // 𠁡
	0x20062: "\x02\x01\U00020062", // 𠁢
	0x20063: "\x02\x03\U00020063", // 𠁣
	0x20064: "\x1f\x02\U00020064", // 𠁤
	0x20065: "\x02\x04\U00020065", // 𠁥
	0x20066: "\x02\x05\U00020066", // 𠁦
	0x20067: "\x02\x06\U00020067", // 𠁧
	0x20068: "\x02\x06\U00020068", // 𠁨
	0x20069: "\x02\a\U00020069", // 𠁩
	0x2006a: "\x02\a\U0002006a", // 𠁪
	0x2006b: "\x02\a\U0002006b", // 𠁫
	0x2006c: "\x02\a\U0002006c", // 𠁬
	0x2006d: "\x02\b\U0002006d", // 𠁭
	0x2006e: "\x02\b\U0002006e", // 𠁮
	0x2006f: "\x02\b\U0002006f", // 𠁯
	0x20070: "\x02\t\U00020070", // 𠁰
	0x20071: "\x02\t\U00020071", // 𠁱
	0x20072: "\xaa\x04\U00020072", // 𠁲
	0x20073: "\x02\n\U00020073", // 𠁳
	0x20074: "\x02\v\U00020074", // 𠁴
	0x20075: "\x02\v\U00020075", // 𠁵
	0x20076: "\x02\r\U00020076", // 𠁶
	0x20077: "\x1e\v\U00020077", // 𠁷
	0x20078: "\x02\x0e\U00020078", // 𠁸
	0x20079: "\x02\x11\U00020079", // 𠁹
	0x2007a: "\x02\x12\U0002007a", // 𠁺
	0x2007b: "\x02\x15\U0002007b", // 𠁻
	0x2007c: "\x03\x02\U0002007c", // 𠁼
	0x2007d: "\x03\x02\U0002007d", // 𠁽
	0x2007e: "\x05\x03\U0002007e", // 𠁾
	0x2007f: "\x03\x03\U0002007f", // 𠁿
	0x20080: "\x03\x04\U00020080", // 𠂀
	0x20081: "\x03\x04\U00020081", // 𠂁
	0x20082: "\x03\x05\U00020082", // 𠂂
	0x20083: "\x03\t\U00020083", // 𠂃
	0x20084: "\x03\f\U00020084", // 𠂄
	0x20085: "\x03\x0f\U00020085", // 𠂅
	0x20086: "\x04\x01\U00020086", // 𠂆
	0x20087: "\x04\x01\U00020087", // 𠂇
	0x20088: "\x04\x01\U00020088", // 𠂈
	0x20089: "\x04\x01\U00020089", // 𠂉
	0x2008a: "\x04\x01\U0002008a", // 𠂊
	0x2008b: "\x04\x02\U0002008b", // 𠂋
	0x2008c: "\x04\x02\U0002008c", // 𠂌
	0x2008d: "\x04\x02\U0002008d", // 𠂍
	0x2008e: "\x04\x02\U0002008e", // 𠂎
	0x2008f: "\x04\x03\U0002008f", // 𠂏
	0x20090: "\x04\x03\U00020090", // 𠂐
	0x20091: "\x04\x03\U00020091", // 𠂑
	0x20092: "\x04\x03\U00020092", // 𠂒
	0x20093: "\x04\x03\U00020093", // 𠂓
	0x20094: "\x04\x04\U00020094", // 𠂔
	0x20095: "\x04\x04\U00020095", // 𠂕
	0x20096: "\x04\x04\U00020096", // 𠂖
	0x20097: "\x04\x04\U00020097", // 𠂗
	0x20098: "\x04\x04\U00020098", // 𠂘
	0x20099: "\x04\x04\U00020099", // 𠂙
	0x2009a: "\x04\x04\U0002009a", // 𠂚
	0x2009b: "\x04\x04\U0002009b", // 𠂛
	0x2009c: "\x04\x04\U0002009c", // 𠂜
	0x2009d: "\x04\x04\U0002009d", // 𠂝
	0x2009e: "\x04\x04\U0002009e", // 𠂞
	0x2009f: "\x04\x04\U0002009f", // 𠂟
	0x200a0: "\x04\x04\U000200a0", // 𠂠
	0x200a1: "\x04\x04\U000200a1", // 𠂡
	0x200a2: "\x04\x05\U000200a2", // 𠂢
	0x200a3: "\x04\x05\U000200a3", // 𠂣
	0x200a4: "\x04\x05\U000200a4", // 𠂤
	0x200a5: "\x04\x05\U000200a5", // 𠂥
	0x200a6: "\x04\x05\U000200a6", // 𠂦
	0x200a7: "\x04\x05\U000200a7", // 𠂧
	0x200a8: "\x89\x00\U000200a8", // 𠂨
	0x200a9: "\x04\x05\U000200a9", // 𠂩
	0x200aa: "\x04\x05\U000200aa", // 𠂪
	0x200ab: "\x04\x05\U000200ab", // 𠂫
	0x200ac: "\x1b\x04\U000200ac", // 𠂬
	0x200ad: "\x04\x05\U000200ad", // 𠂭
	0x200ae: "\x1b\x04\U000200ae", // 𠂮
	0x200af: "\x04\x06\U000200af", // 𠂯
	0x200b0: "\x1b\x05\U000200b0", // 𠂰
	0x200b1: "Q\x03\U000200b1", // 𠂱
	0x200b2: "\x04\a\U000200b2", // 𠂲
	0x200b3: "\x04\a\U000200b3", // 𠂳
	0x200b4: "\x04\b\U000200b4", // 𠂴
	0x200b5: "e\x03\U000200b5", // 𠂵
	0x200b6: "\x04\a\U000200b6", // 𠂶
	0x200b7: "\x04\b\U000200b7", // 𠂷
	0x200b8: "\x05\b\U000200b8", // 𠂸
	0x200b9: "\x04\t\U000200b9", // 𠂹
	0x200ba: "\x04\t\U000200ba", // 𠂺
	0x200bb: "\x04\t\U000200bb", // 𠂻
	0x200bc: "\x04\t\U000200bc", // 𠂼
	0x200bd: "\x04\t\U000200bd", // 𠂽
	0x200be: "\x04\t\U000200be", // 𠂾
	0x200bf: "\x04\n\U000200bf", // 𠂿
	0x200c0: "\x04\n\U000200c0", // 𠃀
	0x200c1: "\x04\n\U000200c1", // 𠃁
	0x200c2: "\x04\n\U000200c2", // 𠃂
	0x200c3: "\x04\v\U000200c3", // 𠃃
	0x200c4: "\x04\v\U000200c4", // 𠃄
	0x200c5: "\x04\r\U000200c5", // 𠃅
	0x200c6: "\x04\f\U000200c6", // 𠃆
	0x200c7: "\x04\x0e\U000200c7", // 𠃇
	0x200c8: "\x04\x16\U000200c8", // 𠃈
	0x200c9: "\x05\x00\U000200c9", // 𠃉
	0x200ca: "\x05\x00\U000200ca", // 𠃊
	0x200cb: "\x05\x00\U000200cb", // 𠃋
	0x200cc: "\x05\x00\U000200cc", // 𠃌
	0x200cd: "\x05\x00\U000200cd", // 𠃍
	0x200ce: "\x05\x00\U000200ce", // 𠃎
	0x200cf: "\x05\x01\U000200cf", // 𠃏
	0x200d0: "\x05\x01\U000200d0", // 𠃐
	0x200d1: "\x05\x00\U000200d1", // 𠃑
	0x200d2: "\x05\x02\U000200d2", // 𠃒
	0x200d3: "\x05\x02\U000200d3", // 𠃓
	0x200d4: "\x05\x02\U000200d4", // 𠃔
	0x200d5: "\x05\x03\U000200d5", // 𠃕
	0x200d6: "\x05\x03\U000200d6", // 𠃖
	0x200d7: "\x05\x03\U000200d7", // 𠃗
	0x200d8: "\x05\x03\U000200d8", // 𠃘
	0x200d9: "\x05\x03\U000200d9", // 𠃙
	0x200da: "\x05\x03\U000200da", // 𠃚
	0x200db: "\x05\x03\U000200db", // 𠃛
	0x200dc: "\x05\x03\U000200dc", // 𠃜
	0x200dd: "\x05\x03\U000200dd", // 𠃝
	0x200de: "\x05\x04\U000200de", // 𠃞
	0x200df: "\x05\x04\U000200df", // 𠃟
	0x200e0: "\x05\x04\U000200e0", // 𠃠
	0x200e1: "\x05\x04\U000200e1", // 𠃡
	0x200e2: "\x05\x04\U000200e2", // 𠃢
	0x200e3: "\x05\x04\U000200e3", // 𠃣
	0x200e4: "\x05\x05\U000200e4", // 𠃤
	0x200e5: "\x05\x05\U000200e5", // 𠃥
	0x200e6: "\x05\x05\U000200e6", // 𠃦
	0x200e7: "\x05\x05\U000200e7", // 𠃧
	0x200e8: "\x05\x05\U000200e8", // 𠃨
	0x200e9: "\x05\x06\U000200e9", // 𠃩
	0x200ea: "\x05\x06\U000200ea", // 𠃪
	0x200eb: "f\x02\U000200eb", // 𠃫
	0x200ec: "\x05\x06\U000200ec", // 𠃬
	0x200ed: "\x05\a\U000200ed", // 𠃭
	0x200ee: "\x05\a\U000200ee", // 𠃮
	0x200ef: "\x05\a\U000200ef", // 𠃯
	0x200f0: "e\x03\U000200f0", // 𠃰
	0x200f1: "'\x05\U000200f1", // 𠃱
	0x200f2: "\x05\b\U000200f2", // 𠃲
	0x200f3: "\x05\b\U000200f3", // 𠃳
	0x200f4: "\x05\b\U000200f4", // 𠃴
	0x200f5: "\x05\b\U000200f5", // 𠃵
	0x200f6: "\x05\b\U000200f6", // 𠃶
	0x200f7: "\x05\b\U000200f7", // 𠃷
	0x200f8: "\x05\t\U000200f8", // 𠃸
	0x200f9: "\x05\t\U000200f9", // 𠃹
	0x200fa: "\x05\t\U000200fa", // 𠃺
	0x200fb: "\x05\t\U000200fb", // 𠃻
	0x200fc: "\x05\n\U000200fc", // 𠃼
	0x200fd: "\x05\n\U000200fd", // 𠃽
	0x200fe: "\x05\n\U000200fe", // 𠃾
	0x200ff: "\x05\n\U000200ff", // 𠃿
	0x20100: "\x05\n\U00020100", // 𠄀
	0x20101: "\x05\n\U00020101", // 𠄁
	0x20102: "\x05\n\U00020102", // 𠄂
	0x20103: "\x05\f\U00020103", // 𠄃
	0x20104: "\x05\f\U00020104", // 𠄄
	0x20105: "\x05\r\U00020105", // 𠄅
	0x20106: "\x05\r\U00020106", // 𠄆
	0x20107: "\x05\r\U00020107", // 𠄇
	0x20108: "\x05\r\U00020108", // 𠄈
	0x20109: "\x05\x10\U00020109", // 𠄉
	0x2010a: "\x05\x12\U0002010a", // 𠄊
	0x2010b: "\x05\x13\U0002010b", // 𠄋
	0x2010c: "\x06\x00\U0002010c", // 𠄌
	0x2010d: "\x06\x01\U0002010d", // 𠄍
	0x2010e: "\x06\x01\U0002010e", // 𠄎
	0x2010f: "\x06\x01\U0002010f", // 𠄏
	0x20110: "\x06\x01\U00020110", // 𠄐
	0x20111: "\x06\x02\U00020111", // 𠄑
	0x20112: "\x06\x03\U00020112", // 𠄒
	0x20113: "\x06\x03\U00020113", // 𠄓
	0x20114: "\x06\x03\U00020114", // 𠄔
	0x20115: "\x06\x05\U00020115", // 𠄕
	0x20116: "\x06\x06\U00020116", // 𠄖
	0x20117: "\x06\x06\U00020117", // 𠄗
	0x20118: "\x06\x06\U00020118", // 𠄘
	0x20119: "\x06\a\U00020119", // 𠄙
	0x2011a: "\x06\n\U0002011a", // 𠄚
	0x2011b: "\x06\v\U0002011b", // 𠄛
	0x2011c: "\x06\x0e\U0002011c", // 𠄜
	0x2011d: "\x06\x0f\U0002011d", // 𠄝
	0x2011e: "\a\x00\U0002011e", // 𠄞
	0x2011f: "\a\x00\U0002011f", // 𠄟
	0x20120: "\a\x00\U00020120", // 𠄠
	0x20121: "\a\x02\U00020121", // 𠄡
	0x20122: "\a\x04\U00020122", // 𠄢
	0x20123: "\a\x04\U00020123", // 𠄣
	0x20124: "\a\x04\U00020124", // 𠄤
	0x20125: "\a\x04\U00020125", // 𠄥
	0x20126: "\a\x04\U00020126", // 𠄦
	0x20127: "\a\x04\U00020127", // 𠄧
	0x20128: "\a\x05\U00020128", // 𠄨
	0x20129: "\a\x05\U00020129", // 𠄩
	0x2012a: "\a\x05\U0002012a", // 𠄪
	0x2012b: "\a\x06\U0002012b", // 𠄫
	0x2012c: "\a\x06\U0002012c", // 𠄬
	0x2012d: "\a\x06\U0002012d", // 𠄭
	0x2012e: "\a\x06\U0002012e", // 𠄮
	0x2012f: "\a\x06\U0002012f", // 𠄯
	0x20130: "\a\a\U00020130", // 𠄰
	0x20131: "\a\a\U00020131", // 𠄱
	0x20132: "\a\a\U00020132", // 𠄲
	0x20133: "\a\a\U00020133", // 𠄳
	0x20134: "9\x06\U00020134", // 𠄴
	0x20135: "\a\b\U00020135", // 𠄵
	0x20136: "\a\b\U00020136", // 𠄶
	0x20137: "\a\b\U00020137", // 𠄷
	0x20138: "\a\b\U00020138", // 𠄸
	0x20139: "\a\t\U00020139", // 𠄹
	0x2013a: "\a\t\U0002013a", // 𠄺
	0x2013b: "\a\n\U0002013b", // 𠄻
	0x2013c: "\a\v\U0002013c", // 𠄼
	0x2013d: "\a\v\U0002013d", // 𠄽
	0x2013e: "\a\v\U0002013e", // 𠄾
	0x2013f: "\a\f\U0002013f", // 𠄿
	0x20140: "\a\r\U00020140", // 𠅀
	0x20141: "\b\x02\U00020141", // 𠅁
	0x20142: "\b\x03\U00020142", // 𠅂
	0x20143: "\b\x04\U00020143", // 𠅃
	0x20144: "\b\x04\U00020144", // 𠅄
	0x20145: "\b\x04\U00020145", // 𠅅
	0x20146: "\b\x04\U00020146", // 𠅆
	0x20147: "\b\x04\U00020147", // 𠅇
	0x20148: "\b\x05\U00020148", // 𠅈
	0x20149: "\b\x05\U00020149", // 𠅉
	0x2014a: "\b\x05\U0002014a", // 𠅊
	0x2014b: "\b\x05\U0002014b", // 𠅋
	0x2014c: "\b\x06\U0002014c", // 𠅌
	0x2014d: "\b\x06\U0002014d", // 𠅍
	0x2014e: "\b\x06\U0002014e", // 𠅎
	0x2014f: "\b\x06\U0002014f", // 𠅏
	0x20150: "\b\x06\U00020150", // 𠅐
	0x20151: "\b\x06\U00020151", // 𠅑
	0x20152: "\b\x06\U00020152", // 𠅒
	0x20153: "\b\a\U00020153", // 𠅓
	0x20154: "\b\a\U00020154", // 𠅔
	0x20155: "\b\a\U00020155", // 𠅕
	0x20156: "\b\b\U00020156", // 𠅖
	0x20157: "$\a\U00020157", // 𠅗
	0x20158: "\b\b\U00020158", // 𠅘
	0x20159: "\b\b\U00020159", // 𠅙
	0x2015a: "\b\b\U0002015a", // 𠅚
	0x2015b: "\b\b\U0002015b", // 𠅛
	0x2015c: "\b\b\U0002015c", // 𠅜
	0x2015d: "\b\b\U0002015d", // 𠅝
	0x2015e: "\b\t\U0002015e", // 𠅞
	0x2015f: "\b\t\U0002015f", // 𠅟
	0x20160: "\b\t\U00020160", // 𠅠
	0x20161: "\b\t\U00020161", // 𠅡
	0x20162: "\b\t\U00020162", // 𠅢
	0x20163: "\b\t\U00020163", // 𠅣
	0x20164: "\b\t\U00020164", // 𠅤
	0x20165: "\b\t\U00020165", // 𠅥
	0x20166: "\b\t\U00020166", // 𠅦
	0x20167: "\b\t\U00020167", // 𠅧
	0x20168: "\b\n\U00020168", // 𠅨
	0x20169: "\b\n\U00020169", // 𠅩
	0x2016a: "\b\n\U0002016a", // 𠅪
	0x2016b: "\b\n\U0002016b", // 𠅫
	0x2016c: "\b\n\U0002016c", // 𠅬
	0x2016d: "\b\n\U0002016d", // 𠅭
	0x2016e: "\b\n\U0002016e", // 𠅮
	0x2016f: "\b\n\U0002016f", // 𠅯
	0x20170: "o\a\U00020170", // 𠅰
	0x20171: "$\t\U00020171", // 𠅱
	0x20172: "\b\n\U00020172", // 𠅲
	0x20173: "\b\v\U00020173", // 𠅳
	0x20174: "\b\v\U00020174", // 𠅴
	0x20175: "\b\v\U00020175", // 𠅵
	0x20176: "\b\v\U00020176", // 𠅶
	0x20177: "\b\v\U00020177", // 𠅷
	0x20178: "\b\v\U00020178", // 𠅸
	0x20179: "4\n\U00020179", // 𠅹
	0x2017a: "\b\v\U0002017a", // 𠅺
	0x2017b: "\b\v\U0002017b", // 𠅻
	0x2017c: "\b\v\U0002017c", // 𠅼
	0x2017d: "*\n\U0002017d", // 𠅽
	0x2017e: "\b\f\U0002017e", // 𠅾
	0x2017f: "\b\f\U0002017f", // 𠅿
	0x20180: "\b\v\U00020180", // 𠆀
	0x20181: "\b\r\U00020181", // 𠆁
	0x20182: "\b\r\U00020182", // 𠆂
	0x20183: "\b\r\U00020183", // 𠆃
	0x20184: "\b\r\U00020184", // 𠆄
	0x20185: "\b\r\U00020185", // 𠆅
	0x20186: "\b\r\U00020186", // 𠆆
	0x20187: "\b\r\U00020187", // 𠆇
	0x20188: "\b\r\U00020188", // 𠆈
	0x20189: "\b\r\U00020189", // 𠆉
	0x2018a: "\x1e\f\U0002018a", // 𠆊
	0x2018b: "\b\x0e\U0002018b", // 𠆋
	0x2018c: "\b\x0e\U0002018c", // 𠆌
	0x2018d: "\b\x0e\U0002018d", // 𠆍
	0x2018e: "\b\x0e\U0002018e", // 𠆎
	0x2018f: "\b\x0e\U0002018f", // 𠆏
	0x20190: "\b\x0e\U00020190", // 𠆐
	0x20191: "\b\x0e\U00020191", // 𠆑
	0x20192: "\b\x0e\U00020192", // 𠆒
	0x20193: "$\r\U00020193", // 𠆓
	0x20194: "\b\x0e\U00020194", // 𠆔
	0x20195: "$\r\U00020195", // 𠆕
	0x20196: "\b\x0e\U00020196", // 𠆖
	0x20197: "\b\x0e\U00020197", // 𠆗
	0x20198: "\b\x0e\U00020198", // 𠆘
	0x20199: "$\x0e\U00020199", // 𠆙
	0x2019a: "\b\x10\U0002019a", // 𠆚
	0x2019b: "H\x0e\U0002019b", // 𠆛
	0x2019c: "\xd2\x04\U0002019c", // 𠆜
	0x2019d: "\b\x11\U0002019d", // 𠆝
	0x2019e: "\b\x13\U0002019e", // 𠆞
	0x2019f: "\b\x16\U0002019f", // 𠆟
	0x201a0: "\b\x1a\U000201a0", // 𠆠
	0x201a1: "\b\x1b\U000201a1", // 𠆡
	0x201a2: "\t\x00\U000201a2", // 𠆢
	0x201a3: "\t\x01\U000201a3", // 𠆣
	0x201a4: "\t\x01\U000201a4", // 𠆤
	0x201a5: "\t\x01\U000201a5", // 𠆥
	0x201a6: "\t\x02\U000201a6", // 𠆦
	0x201a7: "\t\x02\U000201a7", // 𠆧
	0x201a8: "\t\x02\U000201a8", // 𠆨
	0x201a9: "\t\x03\U000201a9", // 𠆩
	0x201aa: "\t\x03\U000201aa", // 𠆪
	0x201ab: "\t\x03\U000201ab", // 𠆫
	0x201ac: "\t\x03\U000201ac", // 𠆬
	0x201ad: "\t\x03\U000201ad", // 𠆭
	0x201ae: "\x13\x03\U000201ae", // 𠆮
	0x201af: "\t\x03\U000201af", // 𠆯
	0x201b0: "\t\x03\U000201b0", // 𠆰
	0x201b1: "\x18\x03\U000201b1", // 𠆱
	0x201b2: "5\x02\U000201b2", // 𠆲
	0x201b3: "\t\x03\U000201b3", // 𠆳
	0x201b4: "\t\x04\U000201b4", // 𠆴
	0x201b5: "\t\x04\U000201b5", // 𠆵
	0x201b6: "\t\x04\U000201b6", // 𠆶
	0x201b7: "\t\x04\U000201b7", // 𠆷
	0x201b8: "\t\x04\U000201b8", // 𠆸
	0x201b9: "\t\x04\U000201b9", // 𠆹
	0x201ba: "\t\x04\U000201ba", // 𠆺
	0x201bb: "\t\x04\U000201bb", // 𠆻
	0x201bc: "\t\x04\U000201bc", // 𠆼
	0x201bd: "\t\x04\U000201bd", // 𠆽
	0x201be: "\t\x04\U000201be", // 𠆾
	0x201bf: "\t\x04\U000201bf", // 𠆿
	0x201c0: "\t\x04\U000201c0", // 𠇀
	0x201c1: "\t\x04\U000201c1", // 𠇁
	0x201c2: "\t\x04\U000201c2", // 𠇂
	0x201c3: "\t\x04\U000201c3", // 𠇃
	0x201c4: "\t\x04\U000201c4", // 𠇄
	0x201c5: "\t\x04\U000201c5", // 𠇅
	0x201c6: "\t\x04\U000201c6", // 𠇆
	0x201c7: "\t\x04\U000201c7", // 𠇇
	0x201c8: "\t\x04\U000201c8", // 𠇈
	0x201c9: "\t\x04\U000201c9", // 𠇉
	0x201ca: "\t\x04\U000201ca", // 𠇊
	0x201cb: "\t\x04\U000201cb", // 𠇋
	0x201cc: "\t\x04\U000201cc", // 𠇌
	0x201cd: "\t\x04\U000201cd", // 𠇍
	0x201ce: "\t\x04\U000201ce", // 𠇎
	0x201cf: "\t\x04\U000201cf", // 𠇏
	0x201d0: "\t\x04\U000201d0", // 𠇐
	0x201d1: "\t\x04\U000201d1", // 𠇑
	0x201d2: "\v\x04\U000201d2", // 𠇒
	0x201d3: "\t\x04\U000201d3", // 𠇓
	0x201d4: "\t\x04\U000201d4", // 𠇔
	0x201d5: "\t\x04\U000201d5", // 𠇕
	0x201d6: "\t\x05\U000201d6", // 𠇖
	0x201d7: "\t\x05\U000201d7", // 𠇗
	0x201d8: "\t\x05\U000201d8", // 𠇘
	0x201d9: "\t\x05\U000201d9", // 𠇙
	0x201da: "\t\x05\U000201da", // 𠇚
	0x201db: "\t\x05\U000201db", // 𠇛
	0x201dc: "\t\x05\U000201dc", // 𠇜
	0x201dd: "\t\x05\U000201dd", // 𠇝
	0x201de: "\t\x05\U000201de", // 𠇞
	0x201df: "\t\x05\U000201df", // 𠇟
	0x201e0: "\t\x05\U000201e0", // 𠇠
	0x201e1: "\t\x05\U000201e1", // 𠇡
	0x201e2: "\t\x05\U000201e2", // 𠇢
	0x201e3: "\t\x05\U000201e3", // 𠇣
	0x201e4: "\t\x05\U000201e4", // 𠇤
	0x201e5: "\t\x05\U000201e5", // 𠇥
	0x201e6: "\t\x05\U000201e6", // 𠇦
	0x201e7: "\t\x05\U000201e7", // 𠇧
	0x201e8: "\t\x05\U000201e8", // 𠇨
	0x201e9: "\t\x05\U000201e9", // 𠇩
	0x201ea: "\t\x05\U000201ea", // 𠇪
	0x201eb: "\t\x05\U000201eb", // 𠇫
	0x201ec: "\t\x05\U000201ec", // 𠇬
	0x201ed: "\t\x05\U000201ed", // 𠇭
	0x201ee: "\t\x05\U000201ee", // 𠇮
	0x201ef: "\t\x05\U000201ef", // 𠇯
	0x201f0: "\t\x05\U000201f0", // 𠇰
	0x201f1: "\t\x05\U000201f1", // 𠇱
	0x201f2: "\t\x05\U000201f2", // 𠇲
	0x201f3: "\t\x05\U000201f3", // 𠇳
	0x201f4: "\t\x05\U000201f4", // 𠇴
	0x201f5: "\t\x05\U000201f5", // 𠇵
	0x201f6: "\t\x05\U000201f6", // 𠇶
	0x201f7: "\t\x05\U000201f7", // 𠇷
	0x201f8: "\t\x05\U000201f8", // 𠇸
	0x201f9: "\t\x05\U000201f9", // 𠇹
	0x201fa: "\t\x05\U000201fa", // 𠇺
	0x201fb: "\t\x05\U000201fb", // 𠇻
	0x201fc: "\t\x05\U000201fc", // 𠇼
	0x201fd: "\t\x05\U000201fd", // 𠇽
	0x201fe: "\t\x05\U000201fe", // 𠇾
	0x201ff: "\t\x05\U000201ff", // 𠇿
	0x20200: "\t\x05\U00020200", // 𠈀
	0x20201: "\t\x05\U00020201", // 𠈁
	0x20202: "\x1e\x04\U00020202", // 𠈂
	0x20203: "\t\x06\U00020203", // 𠈃
	0x20204: "\t\x06\U00020204", // 𠈄
	0x20205: "\t\x06\U00020205", // 𠈅
	0x20206: "\t\x06\U00020206", // 𠈆
	0x20207: "\t\x06\U00020207", // 𠈇
	0x20208: "\t\x06\U00020208", // 𠈈
	0x20209: "\t\x06\U00020209", // 𠈉
	0x2020a: "\t\x06\U0002020a", // 𠈊
	0x2020b: "\t\x06\U0002020b", // 𠈋
	0x2020c: "\t\x06\U0002020c", // 𠈌
	0x2020d: "\t\x06\U0002020d", // 𠈍
	0x2020e: "\t\x06\U0002020e", // 𠈎
	0x2020f: "\t\x06\U0002020f", // 𠈏
	0x20210: "\t\x06\U00020210", // 𠈐
	0x20211: "\t\x06\U00020211", // 𠈑
	0x20212: "\t\x06\U00020212", // 𠈒
	0x20213: "\t\x06\U00020213", // 𠈓
	0x20214: "\t\x06\U00020214", // 𠈔
	0x20215: "\t\x06\U00020215", // 𠈕
	0x20216: "\t\x06\U00020216", // 𠈖
	0x20217: "\t\x06\U00020217", // 𠈗
	0x20218: "\t\x06\U00020218", // 𠈘
	0x20219: "\t\x06\U00020219", // 𠈙
	0x2021a: "\t\x06\U0002021a", // 𠈚
	0x2021b: "\t\x06\U0002021b", // 𠈛
	0x2021c: "\t\x06\U0002021c", // 𠈜
	0x2021d: "\t\x06\U0002021d", // 𠈝
	0x2021e: "\t\x06\U0002021e", // 𠈞
	0x2021f: "\t\x06\U0002021f", // 𠈟
	0x20220: "\t\x06\U00020220", // 𠈠
	0x20221: "\t\x06\U00020221", // 𠈡
	0x20222: "\t\x06\U00020222", // 𠈢
	0x20223: "\t\x06\U00020223", // 𠈣
	0x20224: "*\x05\U00020224", // 𠈤
	0x20225: "\t\x06\U00020225", // 𠈥
	0x20226: "\t\x06\U00020226", // 𠈦
	0x20227: "\t\x06\U00020227", // 𠈧
	0x20228: "\t\x06\U00020228", // 𠈨
	0x20229: "\t\x06\U00020229", // 𠈩
	0x2022a: "\t\x06\U0002022a", // 𠈪
	0x2022b: "\t\x06\U0002022b", // 𠈫
	0x2022c: "\t\x06\U0002022c", // 𠈬
	0x2022d: "\t\a\U0002022d", // 𠈭
	0x2022e: "\t\a\U0002022e", // 𠈮
	0x2022f: "\t\a\U0002022f", // 𠈯
	0x20230: "\t\a\U00020230", // 𠈰
	0x20231: "\t\a\U00020231", // 𠈱
	0x20232: "\t\a\U00020232", // 𠈲
	0x20233: "\t\a\U00020233", // 𠈳
	0x20234: "\t\a\U00020234", // 𠈴
	0x20235: "\t\a\U00020235", // 𠈵
	0x20236: "\t\a\U00020236", // 𠈶
	0x20237: "\t\a\U00020237", // 𠈷
	0x20238: "\t\a\U00020238", // 𠈸
	0x20239: "\t\a\U00020239", // 𠈹
	0x2023a: "\t\a\U0002023a", // 𠈺
	0x2023b: "\t\a\U0002023b", // 𠈻
	0x2023c: "\t\a\U0002023c", // 𠈼
	0x2023d: "\t\a\U0002023d", // 𠈽
	0x2023e: "\t\a\U0002023e", // 𠈾
	0x2023f: "\t\a\U0002023f", // 𠈿
	0x20240: "\t\a\U00020240", // 𠉀
	0x20241: "\t\a\U00020241", // 𠉁
	0x20242: "\t\a\U00020242", // 𠉂
	0x20243: "\t\a\U00020243", // 𠉃
	0x20244: "\t\a\U00020244", // 𠉄
	0x20245: "\t\a\U00020245", // 𠉅
	0x20246: "\t\a\U00020246", // 𠉆
	0x20247: "\t\a\U00020247", // 𠉇
	0x20248: "\t\a\U00020248", // 𠉈
	0x20249: "\t\a\U00020249", // 𠉉
	0x2024a: "\t\a\U0002024a", // 𠉊
	0x2024b: "\t\a\U0002024b", // 𠉋
	0x2024c: "\t\a\U0002024c", // 𠉌
	0x2024d: "\t\a\U0002024d", // 𠉍
	0x2024e: "\t\a\U0002024e", // 𠉎
	0x2024f: "\t\a\U0002024f", // 𠉏
	0x20250: "\t\a\U00020250", // 𠉐
	0x20251: "\t\a\U00020251", // 𠉑
	0x20252: "\t\a\U00020252", // 𠉒
	0x20253: "\t\a\U00020253", // 𠉓
	0x20254: "\t\a\U00020254", // 𠉔
	0x20255: "\t\a\U00020255", // 𠉕
	0x20256: "\t\a\U00020256", // 𠉖
	0x20257: "\t\a\U00020257", // 𠉗
	0x20258: "\t\a\U00020258", // 𠉘
	0x20259: "\t\a\U00020259", // 𠉙
	0x2025a: "\t\a\U0002025a", // 𠉚
	0x2025b: "\t\a\U0002025b", // 𠉛
	0x2025c: "\t\a\U0002025c", // 𠉜
	0x2025d: "\t\a\U0002025d", // 𠉝
	0x2025e: "\t\a\U0002025e", // 𠉞
	0x2025f: "\t\a\U0002025f", // 𠉟
	0x20260: "\t\a\U00020260", // 𠉠
	0x20261: "\t\a\U00020261", // 𠉡
	0x20262: "\t\a\U00020262", // 𠉢
	0x20263: "\t\b\U00020263", // 𠉣
	0x20264: "\t\b\U00020264", // 𠉤
	0x20265: "\t\b\U00020265", // 𠉥
	0x20266: "\t\b\U00020266", // 𠉦
	0x20267: "\t\b\U00020267", // 𠉧
	0x20268: "\t\b\U00020268", // 𠉨
	0x20269: "\t\b\U00020269", // 𠉩
	0x2026a: "\t\b\U0002026a", // 𠉪
	0x2026b: "\t\b\U0002026b", // 𠉫
	0x2026c: "\t\b\U0002026c", // 𠉬
	0x2026d: "\t\b\U0002026d", // 𠉭
	0x2026e: "\t\b\U0002026e", // 𠉮
	0x2026f: "\t\b\U0002026f", // 𠉯
	0x20270: "\t\b\U00020270", // 𠉰
	0x20271: "\t\b\U00020271", // 𠉱
	0x20272: "\t\b\U00020272", // 𠉲
	0x20273: "\t\b\U00020273", // 𠉳
	0x20274: "\t\b\U00020274", // 𠉴
	0x20275: "\t\b\U00020275", // 𠉵
	0x20276: "\t\b\U00020276", // 𠉶
	0x20277: "\t\b\U00020277", // 𠉷
	0x20278: "\t\b\U00020278", // 𠉸
	0x20279: "\t\b\U00020279", // 𠉹
	0x2027a: "\t\b\U0002027a", // 𠉺
	0x2027b: "\t\b\U0002027b", // 𠉻
	0x2027c: "\t\b\U0002027c", // 𠉼
	0x2027d: "\t\b\U0002027d", // 𠉽
	0x2027e: "\t\b\U0002027e", // 𠉾
	0x2027f: "\t\b\U0002027f", // 𠉿
	0x20280: "\t\b\U00020280", // 𠊀
	0x20281: "\t\b\U00020281", // 𠊁
	0x20282: "\t\b\U00020282", // 𠊂
	0x20283: "\t\b\U00020283", // 𠊃
	0x20284: "\t\b\U00020284", // 𠊄
	0x20285: "\t\b\U00020285", // 𠊅
	0x20286: "\t\b\U00020286", // 𠊆
	0x20287: "\t\b\U00020287", // 𠊇
	0x20288: "\t\b\U00020288", // 𠊈
	0x20289: "\t\b\U00020289", // 𠊉
	0x2028a: "\t\b\U0002028a", // 𠊊
	0x2028b: "\t\b\U0002028b", // 𠊋
	0x2028c: "\t\b\U0002028c", // 𠊌
	0x2028d: "\t\b\U0002028d", // 𠊍
	0x2028e: "\t\b\U0002028e", // 𠊎
	0x2028f: "\t\b\U0002028f", // 𠊏
	0x20290: "\t\b\U00020290", // 𠊐
	0x20291: "\t\b\U00020291", // 𠊑
	0x20292: "\t\b\U00020292", // 𠊒
	0x20293: "\t\b\U00020293", // 𠊓
	0x20294: "\t\b\U00020294", // 𠊔
	0x20295: "\t\b\U00020295", // 𠊕
	0x20296: "\t\b\U00020296", // 𠊖
	0x20297: "\t\b\U00020297", // 𠊗
	0x20298: "\t\b\U00020298", // 𠊘
	0x20299: "\t\b\U00020299", // 𠊙
	0x2029a: "\t\b\U0002029a", // 𠊚
	0x2029b: "\t\b\U0002029b", // 𠊛
	0x2029c: "\t\b\U0002029c", // 𠊜
	0x2029d: "\t\b\U0002029d", // 𠊝
	0x2029e: "\t\b\U0002029e", // 𠊞
	0x2029f: "\t\b\U0002029f", // 𠊟
	0x202a0: "\t\b\U000202a0", // 𠊠
	0x202a1: "\t\b\U000202a1", // 𠊡
	0x202a2: "\t\b\U000202a2", // 𠊢
	0x202a3: "\t\b\U000202a3", // 𠊣
	0x202a4: "\t\b\U000202a4", // 𠊤
	0x202a5: "\t\b\U000202a5", // 𠊥
	0x202a6: "\t\b\U000202a6", // 𠊦
	0x202a7: "\t\t\U000202a7", // 𠊧
	0x202a8: "\t\t\U000202a8", // 𠊨
	0x202a9: "\t\t\U000202a9", // 𠊩
	0x202aa: "\t\t\U000202aa", // 𠊪
	0x202ab: "\t\t\U000202ab", // 𠊫
	0x202ac: "\t\t\U000202ac", // 𠊬
	0x202ad: "\t\t\U000202ad", // 𠊭
	0x202ae: "\t\t\U000202ae", // 𠊮
	0x202af: "\t\t\U000202af", // 𠊯
	0x202b0: "\t\t\U000202b0", // 𠊰
	0x202b1: "\t\t\U000202b1", // 𠊱
	0x202b2: "\t\t\U000202b2", // 𠊲
	0x202b3: "\t\t\U000202b3", // 𠊳
	0x202b4: "\t\t\U000202b4", // 𠊴
	0x202b5: "\t\t\U000202b5", // 𠊵
	0x202b6: "\t\t\U000202b6", // 𠊶
	0x202b7: "\t\t\U000202b7", // 𠊷
	0x202b8: "\t\t\U000202b8", // 𠊸
	0x202b9: "\t\t\U000202b9", // 𠊹
	0x202ba: "\t\t\U000202ba", // 𠊺
	0x202bb: "\t\t\U000202bb", // 𠊻
	0x202bc: "\t\t\U000202bc", // 𠊼
	0x202bd: "\t\t\U000202bd", // 𠊽
	0x202be: "\t\t\U000202be", // 𠊾
	0x202bf: "\t\t\U000202bf", // 𠊿
	0x202c0: "\t\t\U000202c0", // 𠋀
	0x202c1: "\t\t\U000202c1", // 𠋁
	0x202c2: "\t\t\U000202c2", // 𠋂
	0x202c3: "\t\t\U000202c3", // 𠋃
	0x202c4: "\t\t\U000202c4", // 𠋄
	0x202c5: "\t\t\U000202c5", // 𠋅
	0x202c6: "\t\t\U000202c6", // 𠋆
	0x202c7: "\t\t\U000202c7", // 𠋇
	0x202c8: "\t\t\U000202c8", // 𠋈
	0x202c9: "\t\t\U000202c9", // 𠋉
	0x202ca: "\t\t\U000202ca", // 𠋊
	0x202cb: "\t\t\U000202cb", // 𠋋
	0x202cc: "\t\t\U000202cc", // 𠋌
	0x202cd: "\t\t\U000202cd", // 𠋍
	0x202ce: "\t\t\U000202ce", // 𠋎
	0x202cf: "\t\t\U000202cf", // 𠋏
	0x202d0: "\t\t\U000202d0", // 𠋐
	0x202d1: "\xb8\x00\U000202d1", // 𠋑
	0x202d2: "\t\t\U000202d2", // 𠋒
	0x202d3: "\t\t\U000202d3", // 𠋓
	0x202d4: "\t\t\U000202d4", // 𠋔
	0x202d5: "\t\t\U000202d5", // 𠋕
	0x202d6: "\t\t\U000202d6", // 𠋖
	0x202d7: "\t\t\U000202d7", // 𠋗
	0x202d8: "\t\t\U000202d8", // 𠋘
	0x202d9: "\t\t\U000202d9", // 𠋙
	0x202da: "\t\t\U000202da", // 𠋚
	0x202db: "\t\t\U000202db", // 𠋛
	0x202dc: "\t\t\U000202dc", // 𠋜
	0x202dd: "\t\t\U000202dd", // 𠋝
	0x202de: "\t\t\U000202de", // 𠋞
	0x202df: "\t\b\U000202df", // 𠋟
	0x202e0: "\t\t\U000202e0", // 𠋠
	0x202e1: "\t\t\U000202e1", // 𠋡
	0x202e2: "\t\t\U000202e2", // 𠋢
	0x202e3: "\t\t\U000202e3", // 𠋣
	0x202e4: "\t\t\U000202e4", // 𠋤
	0x202e5: "\t\t\U000202e5", // 𠋥
	0x202e6: "\t\t\U000202e6", // 𠋦
	0x202e7: "\t\t\U000202e7", // 𠋧
	0x202e8: "\t\t\U000202e8", // 𠋨
	0x202e9: "\t\t\U000202e9", // 𠋩
	0x202ea: "\t\t\U000202ea", // 𠋪
	0x202eb: "\t\t\U000202eb", // 𠋫
	0x202ec: "\t\t\U000202ec", // 𠋬
	0x202ed: "\t\n\U000202ed", // 𠋭
	0x202ee: "\t\n\U000202ee", // 𠋮
	0x202ef: "\t\n\U000202ef", // 𠋯
	0x202f0: "\t\n\U000202f0", // 𠋰
	0x202f1: "\t\n\U000202f1", // 𠋱
	0x202f2: "\t\n\U000202f2", // 𠋲
	0x202f3: "\t\n\U000202f3", // 𠋳
	0x202f4: "\t\n\U000202f4", // 𠋴
	0x202f5: "\t\n\U000202f5", // 𠋵
	0x202f6: "\t\n\U000202f6", // 𠋶
	0x202f7: "\t\n\U000202f7", // 𠋷
	0x202f8: "\t\n\U000202f8", // 𠋸
	0x202f9: "\t\n\U000202f9", // 𠋹
	0x202fa: "\t\n\U000202fa", // 𠋺
	0x202fb: "\t\n\U000202fb", // 𠋻
	0x202fc: "\t\n\U000202fc", // 𠋼
	0x202fd: "\t\n\U000202fd", // 𠋽
	0x202fe: "\t\n\U000202fe", // 𠋾
	0x202ff: "\t\n\U000202ff", // 𠋿
	0x20300: "\t\n\U00020300", // 𠌀
	0x20301: "\t\n\U00020301", // 𠌁
	0x20302: "\t\n\U00020302", // 𠌂
	0x20303: "\t\n\U00020303", // 𠌃
	0x20304: "\t\n\U00020304", // 𠌄
	0x20305: "\t\n\U00020305", // 𠌅
	0x20306: "\v\n\U00020306", // 𠌆
	0x20307: "\t\n\U00020307", // 𠌇
	0x20308: "\t\n\U00020308", // 𠌈
	0x20309: "\t\n\U00020309", // 𠌉
	0x2030a: "\t\n\U0002030a", // 𠌊
	0x2030b: "\t\n\U0002030b", // 𠌋
	0x2030c: "\t\n\U0002030c", // 𠌌
	0x2030d: "\t\n\U0002030d", // 𠌍
	0x2030e: "\t\n\U0002030e", // 𠌎
	0x2030f: "\t\n\U0002030f", // 𠌏
	0x20310: "\t\n\U00020310", // 𠌐
	0x20311: "\t\n\U00020311", // 𠌑
	0x20312: "\t\n\U00020312", // 𠌒
	0x20313: "\t\n\U00020313", // 𠌓
	0x20314: "\t\n\U00020314", // 𠌔
	0x20315: "\t\n\U00020315", // 𠌕
	0x20316: "\t\n\U00020316", // 𠌖
	0x20317: "\t\n\U00020317", // 𠌗
	0x20318: "\t\n\U00020318", // 𠌘
	0x20319: "\t\n\U00020319", // 𠌙
	0x2031a: "\t\n\U0002031a", // 𠌚
	0x2031b: "\t\n\U0002031b", // 𠌛
	0x2031c: "\t\n\U0002031c", // 𠌜
	0x2031d: "\t\n\U0002031d", // 𠌝
	0x2031e: "#\t\U0002031e", // 𠌞
	0x2031f: "j\a\U0002031f", // 𠌟
	0x20320: "\t\n\U00020320", // 𠌠
	0x20321: "\t\n\U00020321", // 𠌡
	0x20322: "\t\n\U00020322", // 𠌢
	0x20323: "\t\n\U00020323", // 𠌣
	0x20324: "\t\n\U00020324", // 𠌤
	0x20325: "\t\n\U00020325", // 𠌥
	0x20326: "\t\n\U00020326", // 𠌦
	0x20327: "\t\n\U00020327", // 𠌧
	0x20328: "\t\n\U00020328", // 𠌨
	0x20329: "\t\n\U00020329", // 𠌩
	0x2032a: "m\x06\U0002032a", // 𠌪
	0x2032b: "\t\v\U0002032b", // 𠌫
	0x2032c: "\t\v\U0002032c", // 𠌬
	0x2032d: "\t\v\U0002032d", // 𠌭
	0x2032e: "\t\v\U0002032e", // 𠌮
	0x2032f: "\t\v\U0002032f", // 𠌯
	0x20330: "\t\v\U00020330", // 𠌰
	0x20331: "\t\v\U00020331", // 𠌱
	0x20332: "\t\v\U00020332", // 𠌲
	0x20333: "\t\v\U00020333", // 𠌳
	0x20334: "\t\v\U00020334", // 𠌴
	0x20335: "\t\v\U00020335", // 𠌵
	0x20336: "\t\v\U00020336", // 𠌶
	0x20337: "\t\v\U00020337", // 𠌷
	0x20338: "\t\v\U00020338", // 𠌸
	0x20339: "\t\v\U00020339", // 𠌹
	0x2033a: "\t\v\U0002033a", // 𠌺
	0x2033b: "\t\v\U0002033b", // 𠌻
	0x2033c: "\t\v\U0002033c", // 𠌼
	0x2033d: "\t\v\U0002033d", // 𠌽
	0x2033e: "\t\v\U0002033e", // 𠌾
	0x2033f: "\t\v\U0002033f", // 𠌿
	0x20340: "\t\v\U00020340", // 𠍀
	0x20341: "\t\v\U00020341", // 𠍁
	0x20342: "\t\v\U00020342", // 𠍂
	0x20343: "\t\v\U00020343", // 𠍃
	0x20344: "\t\v\U00020344", // 𠍄
	0x20345: "\t\v\U00020345", // 𠍅
	0x20346: "\t\v\U00020346", // 𠍆
	0x20347: "\t\v\U00020347", // 𠍇
	0x20348: "\t\v\U00020348", // 𠍈
	0x20349: "\t\v\U00020349", // 𠍉
	0x2034a: "\t\v\U0002034a", // 𠍊
	0x2034b: "\t\v\U0002034b", // 𠍋
	0x2034c: "\t\v\U0002034c", // 𠍌
	0x2034d: "\t\v\U0002034d", // 𠍍
	0x2034e: "\t\v\U0002034e", // 𠍎
	0x2034f: "\t\v\U0002034f", // 𠍏
	0x20350: "\t\v\U00020350", // 𠍐
	0x20351: "\t\v\U00020351", // 𠍑
	0x20352: "\t\v\U00020352", // 𠍒
	0x20353: "\t\v\U00020353", // 𠍓
	0x20354: "\t\v\U00020354", // 𠍔
	0x20355: "\t\v\U00020355", // 𠍕
	0x20356: "\t\v\U00020356", // 𠍖
	0x20357: "\t\v\U00020357", // 𠍗
	0x20358: "\t\v\U00020358", // 𠍘
	0x20359: "\t\v\U00020359", // 𠍙
	0x2035a: "\t\v\U0002035a", // 𠍚
	0x2035b: "\t\v\U0002035b", // 𠍛
	0x2035c: "\t\v\U0002035c", // 𠍜
	0x2035d: "\t\v\U0002035d", // 𠍝
	0x2035e: "\t\v\U0002035e", // 𠍞
	0x2035f: "\t\v\U0002035f", // 𠍟
	0x20360: "\t\v\U00020360", // 𠍠
	0x20361: "\t\v\U00020361", // 𠍡
	0x20362: "n\b\U00020362", // 𠍢
	0x20363: "\t\v\U00020363", // 𠍣
	0x20364: "\t\v\U00020364", // 𠍤
	0x20365: "\t\f\U00020365", // 𠍥
	0x20366: "\t\v\U00020366", // 𠍦
	0x20367: "\t\v\U00020367", // 𠍧
	0x20368: "\t\v\U00020368", // 𠍨
	0x20369: "\t\v\U00020369", // 𠍩
	0x2036a: "\t\v\U0002036a", // 𠍪
	0x2036b: "\t\v\U0002036b", // 𠍫
	0x2036c: "\t\v\U0002036c", // 𠍬
	0x2036d: "\t\f\U0002036d", // 𠍭
	0x2036e: "\t\f\U0002036e", // 𠍮
	0x2036f: "\t\f\U0002036f", // 𠍯
	0x20370: "\t\f\U00020370", // 𠍰
	0x20371: "\t\f\U00020371", // 𠍱
	0x20372: "\t\f\U00020372", // 𠍲
	0x20373: "\t\f\U00020373", // 𠍳
	0x20374: "\t\f\U00020374", // 𠍴
	0x20375: "\t\f\U00020375", // 𠍵
	0x20376: "\t\f\U00020376", // 𠍶
	0x20377: "\t\f\U00020377", // 𠍷
	0x20378: "\t\f\U00020378", // 𠍸
	0x20379: "\t\f\U00020379", // 𠍹
	0x2037a: "\t\f\U0002037a", // 𠍺
	0x2037b: "\t\f\U0002037b", // 𠍻
	0x2037c: "\t\f\U0002037c", // 𠍼
	0x2037d: "\t\f\U0002037d", // 𠍽
	0x2037e: "\t\f\U0002037e", // 𠍾
	0x2037f: "\t\f\U0002037f", // 𠍿
	0x20380: "\t\f\U00020380", // 𠎀
	0x20381: "\t\f\U00020381", // 𠎁
	0x20382: "\t\f\U00020382", // 𠎂
	0x20383: "\t\f\U00020383", // 𠎃
	0x20384: "\t\f\U00020384", // 𠎄
	0x20385: "\t\f\U00020385", // 𠎅
	0x20386: "\t\f\U00020386", // 𠎆
	0x20387: "\t\f\U00020387", // 𠎇
	0x20388: "\t\f\U00020388", // 𠎈
	0x20389: "\t\f\U00020389", // 𠎉
	0x2038a: "\t\f\U0002038a", // 𠎊
	0x2038b: "\t\f\U0002038b", // 𠎋
	0x2038c: "\t\f\U0002038c", // 𠎌
	0x2038d: "\t\f\U0002038d", // 𠎍
	0x2038e: "\t\f\U0002038e", // 𠎎
	0x2038f: "\t\f\U0002038f", // 𠎏
	0x20390: "\t\f\U00020390", // 𠎐
	0x20391: "\t\f\U00020391", // 𠎑
	0x20392: "\t\f\U00020392", // 𠎒
	0x20393: "\t\f\U00020393", // 𠎓
	0x20394: "\t\f\U00020394", // 𠎔
	0x20395: "\t\f\U00020395", // 𠎕
	0x20396: "\t\f\U00020396", // 𠎖
	0x20397: "\t\f\U00020397", // 𠎗
	0x20398: "r\n\U00020398", // 𠎘
	0x20399: "\t\f\U00020399", // 𠎙
	0x2039a: "\t\f\U0002039a", // 𠎚
	0x2039b: "Y\n\U0002039b", // 𠎛
	0x2039c: "\xd3\x05\U0002039c", // 𠎜
	0x2039d: "\t\f\U0002039d", // 𠎝
	0x2039e: "\t\f\U0002039e", // 𠎞
	0x2039f: "\t\f\U0002039f", // 𠎟
	0x203a0: "\t\f\U000203a0", // 𠎠
	0x203a1: "\t\f\U000203a1", // 𠎡
	0x203a2: "\t\f\U000203a2", // 𠎢
	0x203a3: "\t\f\U000203a3", // 𠎣
	0x203a4: "\t\f\U000203a4", // 𠎤
	0x203a5: "\t\f\U000203a5", // 𠎥
	0x203a6: "\t\f\U000203a6", // 𠎦
	0x203a7: "\t\f\U000203a7", // 𠎧
	0x203a8: "\t\f\U000203a8", // 𠎨
	0x203a9: "\t\f\U000203a9", // 𠎩
	0x203aa: "\t\f\U000203aa", // 𠎪
	0x203ab: "\t\f\U000203ab", // 𠎫
	0x203ac: "\t\f\U000203ac", // 𠎬
	0x203ad: "\t\f\U000203ad", // 𠎭
	0x203ae: "\t\f\U000203ae", // 𠎮
	0x203af: "\t\f\U000203af", // 𠎯
	0x203b0: "\t\f\U000203b0", // 𠎰
	0x203b1: "\t\f\U000203b1", // 𠎱
	0x203b2: "\t\f\U000203b2", // 𠎲
	0x203b3: "\t\f\U000203b3", // 𠎳
	0x203b4: "\t\f\U000203b4", // 𠎴
	0x203b5: "\t\v\U000203b5", // 𠎵
	0x203b6: ">\n\U000203b6", // 𠎶
	0x203b7: "\t\r\U000203b7", // 𠎷
	0x203b8: "\t\r\U000203b8", // 𠎸
	0x203b9: "\t\r\U000203b9", // 𠎹
	0x203ba: "\t\r\U000203ba", // 𠎺
	0x203bb: "\t\r\U000203bb", // 𠎻
	0x203bc: "\t\r\U000203bc", // 𠎼
	0x203bd: "\t\r\U000203bd", // 𠎽
	0x203be: "\t\r\U000203be", // 𠎾
	0x203bf: "\t\r\U000203bf", // 𠎿
	0x203c0: "\t\r\U000203c0", // 𠏀
	0x203c1: "\t\r\U000203c1", // 𠏁
	0x203c2: "\t\r\U000203c2", // 𠏂
	0x203c3: "\t\r\U000203c3", // 𠏃
	0x203c4: "\t\r\U000203c4", // 𠏄
	0x203c5: "\t\r\U000203c5", // 𠏅
	0x203c6: "\t\r\U000203c6", // 𠏆
	0x203c7: "\t\r\U000203c7", // 𠏇
	0x203c8: "\t\r\U000203c8", // 𠏈
	0x203c9: "\t\r\U000203c9", // 𠏉
	0x203ca: "\t\r\U000203ca", // 𠏊
	0x203cb: "\t\r\U000203cb", // 𠏋
	0x203cc: "\t\r\U000203cc", // 𠏌
	0x203cd: "\t\r\U000203cd", // 𠏍
	0x203ce: "\t\r\U000203ce", // 𠏎
	0x203cf: "\t\r\U000203cf", // 𠏏
	0x203d0: "\t\f\U000203d0", // 𠏐
	0x203d1: "\t\r\U000203d1", // 𠏑
	0x203d2: "\t\x0e\U000203d2", // 𠏒
	0x203d3: "\x1e\f\U000203d3", // 𠏓
	0x203d4: "\t\r\U000203d4", // 𠏔
	0x203d5: "\t\r\U000203d5", // 𠏕
	0x203d6: "\t\r\U000203d6", // 𠏖
	0x203d7: "\t\r\U000203d7", // 𠏗
	0x203d8: "\t\r\U000203d8", // 𠏘
	0x203d9: "\t\r\U000203d9", // 𠏙
	0x203da: "\t\r\U000203da", // 𠏚
	0x203db: "\t\r\U000203db", // 𠏛
	0x203dc: "\t\r\U000203dc", // 𠏜
	0x203dd: "\t\r\U000203dd", // 𠏝
	0x203de: "\t\r\U000203de", // 𠏞
	0x203df: "\t\r\U000203df", // 𠏟
	0x203e0: "\t\r\U000203e0", // 𠏠
	0x203e1: "\t\r\U000203e1", // 𠏡
	0x203e2: "\t\r\U000203e2", // 𠏢
	0x203e3: "\t\r\U000203e3", // 𠏣
	0x203e4: "\t\r\U000203e4", // 𠏤
	0x203e5: "\t\r\U000203e5", // 𠏥
	0x203e6: "\t\r\U000203e6", // 𠏦
	0x203e7: "\x1e\f\U000203e7", // 𠏧
	0x203e8: "\t\x0e\U000203e8", // 𠏨
	0x203e9: "\t\x0e\U000203e9", // 𠏩
	0x203ea: "\t\x0e\U000203ea", // 𠏪
	0x203eb: "\t\x0e\U000203eb", // 𠏫
	0x203ec: "\t\x0e\U000203ec", // 𠏬
	0x203ed: "\t\x0e\U000203ed", // 𠏭
	0x203ee: "\t\x0e\U000203ee", // 𠏮
	0x203ef: "\t\x0e\U000203ef", // 𠏯
	0x203f0: "\t\x0e\U000203f0", // 𠏰
	0x203f1: "\t\x0e\U000203f1", // 𠏱
	0x203f2: "\t\x0e\U000203f2", // 𠏲
	0x203f3: "\t\x0e\U000203f3", // 𠏳
	0x203f4: "\t\x0e\U000203f4", // 𠏴
	0x203f5: "\t\x0e\U000203f5", // 𠏵
	0x203f6: "\t\x0e\U000203f6", // 𠏶
	0x203f7: "\t\x0e\U000203f7", // 𠏷
	0x203f8: "\t\x0e\U000203f8", // 𠏸
	0x203f9: "\t\x0e\U000203f9", // 𠏹
	0x203fa: "\t\x0e\U000203fa", // 𠏺
	0x203fb: "\t\x0e\U000203fb", // 𠏻
	0x203fc: "\t\x0e\U000203fc", // 𠏼
	0x203fd: "\t\x0e\U000203fd", // 𠏽
	0x203fe: "\t\x0e\U000203fe", // 𠏾
	0x203ff: "\t\x0e\U000203ff", // 𠏿
	0x20400: "\t\x0e\U00020400", // 𠐀
	0x20401: "\t\x0e\U00020401", // 𠐁
	0x20402: "\t\x0e\U00020402", // 𠐂
	0x20403: "\t\x0e\U00020403", // 𠐃
	0x20404: "\t\x0e\U00020404", // 𠐄
	0x20405: "\t\x0e\U00020405", // 𠐅
	0x20406: "\t\x0e\U00020406", // 𠐆
	0x20407: "\t\x0e\U00020407", // 𠐇
	0x20408: "\t\x0f\U00020408", // 𠐈
	0x20409: "\t\x0f\U00020409", // 𠐉
	0x2040a: "\t\x0f\U0002040a", // 𠐊
	0x2040b: "\t\x0f\U0002040b", // 𠐋
	0x2040c: "\t\x0f\U0002040c", // 𠐌
	0x2040d: "\t\x0f\U0002040d", // 𠐍
	0x2040e: "\t\x0f\U0002040e", // 𠐎
	0x2040f: "\t\x0f\U0002040f", // 𠐏
	0x20410: "\t\x0f\U00020410", // 𠐐
	0x20411: "\t\x0f\U00020411", // 𠐑
	0x20412: "\t\x0f\U00020412", // 𠐒
	0x20413: "\t\x0f\U00020413", // 𠐓
	0x20414: "\t\x0f\U00020414", // 𠐔
	0x20415: "\t\x0f\U00020415", // 𠐕
	0x20416: "\t\x0f\U00020416", // 𠐖
	0x20417: "\t\x0f\U00020417", // 𠐗
	0x20418: "\t\x0f\U00020418", // 𠐘
	0x20419: "\t\x0f\U00020419", // 𠐙
	0x2041a: "\t\x0f\U0002041a", // 𠐚
	0x2041b: "\t\x0f\U0002041b", // 𠐛
	0x2041c: "\x95\n\U0002041c", // 𠐜
	0x2041d: "\t\x0f\U0002041d", // 𠐝
	0x2041e: "\t\x0f\U0002041e", // 𠐞
	0x2041f: "\t\x0f\U0002041f", // 𠐟
	0x20420: "\t\x0f\U00020420", // 𠐠
	0x20421: "\t\x0f\U00020421", // 𠐡
	0x20422: "\t\x0f\U00020422", // 𠐢
	0x20423: "\t\x10\U00020423", // 𠐣
	0x20424: "\t\x10\U00020424", // 𠐤
	0x20425: "\t\x10\U00020425", // 𠐥
	0x20426: "\t\x10\U00020426", // 𠐦
	0x20427: "\t\x10\U00020427", // 𠐧
	0x20428: "\t\x10\U00020428", // 𠐨
	0x20429: "\t\x10\U00020429", // 𠐩
	0x2042a: "\t\x10\U0002042a", // 𠐪
	0x2042b: "\t\x10\U0002042b", // 𠐫
	0x2042c: "\t\x10\U0002042c", // 𠐬
	0x2042d: "\t\x10\U0002042d", // 𠐭
	0x2042e: "\t\x10\U0002042e", // 𠐮
	0x2042f: "\t\x10\U0002042f", // 𠐯
	0x20430: "\t\x10\U00020430", // 𠐰
	0x20431: "\t\x10\U00020431", // 𠐱
	0x20432: "\t\x10\U00020432", // 𠐲
	0x20433: "\t\x10\U00020433", // 𠐳
	0x20434: "\t\x10\U00020434", // 𠐴
	0x20435: "\t\x10\U00020435", // 𠐵
	0x20436: "\t\x10\U00020436", // 𠐶
	0x20437: "\t\x10\U00020437", // 𠐷
	0x20438: "\t\x10\U00020438", // 𠐸
	0x20439: "\t\x10\U00020439", // 𠐹
	0x2043a: "\t\x10\U0002043a", // 𠐺
	0x2043b: "\t\x11\U0002043b", // 𠐻
	0x2043c: "\t\x11\U0002043c", // 𠐼
	0x2043d: "\t\x11\U0002043d", // 𠐽
	0x2043e: "\t\x11\U0002043e", // 𠐾
	0x2043f: "\t\x11\U0002043f", // 𠐿
	0x20440: "\t\x11\U00020440", // 𠑀
	0x20441: "\t\x11\U00020441", // 𠑁
	0x20442: "Y\x0f\U00020442", // 𠑂
	0x20443: "\t\x11\U00020443", // 𠑃
	0x20444: "\t\x11\U00020444", // 𠑄
	0x20445: "\t\x11\U00020445", // 𠑅
	0x20446: "\t\x11\U00020446", // 𠑆
	0x20447: "\t\x11\U00020447", // 𠑇
	0x20448: "\t\x11\U00020448", // 𠑈
	0x20449: "\t\x11\U00020449", // 𠑉
	0x2044a: "\t\x11\U0002044a", // 𠑊
	0x2044b: "\t\x11\U0002044b", // 𠑋
	0x2044c: "\t\x11\U0002044c", // 𠑌
	0x2044d: "\t\x12\U0002044d", // 𠑍
	0x2044e: "\t\x12\U0002044e", // 𠑎
	0x2044f: "\t\x12\U0002044f", // 𠑏
	0x20450: "\t\x12\U00020450", // 𠑐
	0x20451: "\t\x12\U00020451", // 𠑑
	0x20452: "\t\x12\U00020452", // 𠑒
	0x20453: "\t\x12\U00020453", // 𠑓
	0x20454: "\t\x12\U00020454", // 𠑔
	0x20455: "\t\x12\U00020455", // 𠑕
	0x20456: "\t\x12\U00020456", // 𠑖
	0x20457: "\t\x13\U00020457", // 𠑗
	0x20458: "\t\x13\U00020458", // 𠑘
	0x20459: "\t\x13\U00020459", // 𠑙
	0x2045a: "\t\x13\U0002045a", // 𠑚
	0x2045b: "\t\x13\U0002045b", // 𠑛
	0x2045c: "\t\x13\U0002045c", // 𠑜
	0x2045d: "\t\x13\U0002045d", // 𠑝
	0x2045e: "\t\x12\U0002045e", // 𠑞
	0x2045f: "\t\x13\U0002045f", // 𠑟
	0x20460: "\t\x13\U00020460", // 𠑠
	0x20461: "\t\x13\U00020461", // 𠑡
	0x20462: "\t\x13\U00020462", // 𠑢
	0x20463: "\t\x13\U00020463", // 𠑣
	0x20464: "\t\x14\U00020464", // 𠑤
	0x20465: "\t\x14\U00020465", // 𠑥
	0x20466: "\t\x14\U00020466", // 𠑦
	0x20467: "\t\x14\U00020467", // 𠑧
	0x20468: "\t\x14\U00020468", // 𠑨
	0x20469: "\t\x14\U00020469", // 𠑩
	0x2046a: "\t\x15\U0002046a", // 𠑪
	0x2046b: "\t\x15\U0002046b", // 𠑫
	0x2046c: "\t\x15\U0002046c", // 𠑬
	0x2046d: "\t\x15\U0002046d", // 𠑭
	0x2046e: "\t\x15\U0002046e", // 𠑮
	0x2046f: "\t\x15\U0002046f", // 𠑯
	0x20470: "\t\x16\U00020470", // 𠑰
	0x20471: "I\x15\U00020471", // 𠑱
	0x20472: "\t\x18\U00020472", // 𠑲
	0x20473: "\t\x18\U00020473", // 𠑳
	0x20474: "\x8e\x17\U00020474", // 𠑴
	0x20475: "\t\x1b\U00020475", // 𠑵
	0x20476: "\n\x02\U00020476", // 𠑶
	0x20477: "\n\x03\U00020477", // 𠑷
	0x20478: "\n\x03\U00020478", // 𠑸
	0x20479: "\n\x04\U00020479", // 𠑹
	0x2047a: "\n\x04\U0002047a", // 𠑺
	0x2047b: "\n\x04\U0002047b", // 𠑻
	0x2047c: "\n\x04\U0002047c", // 𠑼
	0x2047d: "\n\x05\U0002047d", // 𠑽
	0x2047e: "\n\x05\U0002047e", // 𠑾
	0x2047f: "\n\x05\U0002047f", // 𠑿
	0x20480: "\n\x05\U00020480", // 𠒀
	0x20481: "\n\x05\U00020481", // 𠒁
	0x20482: "\n\x05\U00020482", // 𠒂
	0x20483: "\n\x06\U00020483", // 𠒃
	0x20484: "\n\x06\U00020484", // 𠒄
	0x20485: "\n\x06\U00020485", // 𠒅
	0x20486: "\n\x06\U00020486", // 𠒆
	0x20487: "\n\x06\U00020487", // 𠒇
	0x20488: "\n\x06\U00020488", // 𠒈
	0x20489: "\n\x06\U00020489", // 𠒉
	0x2048a: "\n\x06\U0002048a", // 𠒊
	0x2048b: "\n\x06\U0002048b", // 𠒋
	0x2048c: "\n\a\U0002048c", // 𠒌
	0x2048d: "\n\a\U0002048d", // 𠒍
	0x2048e: "\n\a\U0002048e", // 𠒎
	0x2048f: "\n\a\U0002048f", // 𠒏
	0x20490: "\n\b\U00020490", // 𠒐
	0x20491: "\n\b\U00020491", // 𠒑
	0x20492: "\n\b\U00020492", // 𠒒
	0x20493: "\n\b\U00020493", // 𠒓
	0x20494: "\n\b\U00020494", // 𠒔
	0x20495: "\n\b\U00020495", // 𠒕
	0x20496: "\n\b\U00020496", // 𠒖
	0x20497: "\n\t\U00020497", // 𠒗
	0x20498: "\n\t\U00020498", // 𠒘
	0x20499: "\n\t\U00020499", // 𠒙
	0x2049a: "\n\t\U0002049a", // 𠒚
	0x2049b: "\n\t\U0002049b", // 𠒛
	0x2049c: "\n\t\U0002049c", // 𠒜
	0x2049d: "\n\t\U0002049d", // 𠒝
	0x2049e: "\n\n\U0002049e", // 𠒞
	0x2049f: "\n\n\U0002049f", // 𠒟
	0x204a0: "\n\n\U000204a0", // 𠒠
	0x204a1: "\n\n\U000204a1", // 𠒡
	0x204a2: "\n\n\U000204a2", // 𠒢
	0x204a3: "\n\n\U000204a3", // 𠒣
	0x204a4: "\n\v\U000204a4", // 𠒤
	0x204a5: "\n\v\U000204a5", // 𠒥
	0x204a6: "\n\v\U000204a6", // 𠒦
	0x204a7: "\n\f\U000204a7", // 𠒧
	0x204a8: "\n\f\U000204a8", // 𠒨
	0x204a9: "\n\f\U000204a9", // 𠒩
	0x204aa: "\n\f\U000204aa", // 𠒪
	0x204ab: "\n\f\U000204ab", // 𠒫
	0x204ac: "\n\f\U000204ac", // 𠒬
	0x204ad: "\n\f\U000204ad", // 𠒭
	0x204ae: "\n\f\U000204ae", // 𠒮
	0x204af: "\n\f\U000204af", // 𠒯
	0x204b0: "\n\r\U000204b0", // 𠒰
	0x204b1: "\n\r\U000204b1", // 𠒱
	0x204b2: "\n\r\U000204b2", // 𠒲
	0x204b3: "\n\x0e\U000204b3", // 𠒳
	0x204b4: "\n\r\U000204b4", // 𠒴
	0x204b5: "\n\r\U000204b5", // 𠒵
	0x204b6: "\n\r\U000204b6", // 𠒶
	0x204b7: "\n\r\U000204b7", // 𠒷
	0x204b8: "\n\x0e\U000204b8", // 𠒸
	0x204b9: "\n\x0e\U000204b9", // 𠒹
	0x204ba: "\n\x0e\U000204ba", // 𠒺
	0x204bb: "\n\x0e\U000204bb", // 𠒻
	0x204bc: "\n\x0e\U000204bc", // 𠒼
	0x204bd: "\n\x0e\U000204bd", // 𠒽
	0x204be: "\n\x0e\U000204be", // 𠒾
	0x204bf: "\n\x0f\U000204bf", // 𠒿
	0x204c0: "\n\x0f\U000204c0", // 𠓀
	0x204c1: "\n\x0f\U000204c1", // 𠓁
	0x204c2: "\n\x0f\U000204c2", // 𠓂
	0x204c3: "\n\x0f\U000204c3", // 𠓃
	0x204c4: "\n\x0f\U000204c4", // 𠓄
	0x204c5: "\n\x0f\U000204c5", // 𠓅
	0x204c6: "\n\x10\U000204c6", // 𠓆
	0x204c7: "\n\x0f\U000204c7", // 𠓇
	0x204c8: "\n\x10\U000204c8", // 𠓈
	0x204c9: "\n\x10\U000204c9", // 𠓉
	0x204ca: "\n\x10\U000204ca", // 𠓊
	0x204cb: "\n\x11\U000204cb", // 𠓋
	0x204cc: "5\x10\U000204cc", // 𠓌
	0x204cd: "\n\x12\U000204cd", // 𠓍
	0x204ce: "\n\x11\U000204ce", // 𠓎
	0x204cf: "\n\x12\U000204cf", // 𠓏
	0x204d0: "\n\x12\U000204d0", // 𠓐
	0x204d1: "\n\x13\U000204d1", // 𠓑
	0x204d2: "\n\x13\U000204d2", // 𠓒
	0x204d3: "\n\x14\U000204d3", // 𠓓
	0x204d4: "\n\x14\U000204d4", // 𠓔
	0x204d5: "\n\x15\U000204d5", // 𠓕
	0x204d6: "\n\x15\U000204d6", // 𠓖
	0x204d7: "\n\x16\U000204d7", // 𠓗
	0x204d8: "\n\x16\U000204d8", // 𠓘
	0x204d9: "\n\x16\U000204d9", // 𠓙
	0x204da: "\n\x18\U000204da", // 𠓚
	0x204db: "\v\x01\U000204db", // 𠓛
	0x204dc: "\v\x02\U000204dc", // 𠓜
	0x204dd: "\v\x02\U000204dd", // 𠓝
	0x204de: "\v\x02\U000204de", // 𠓞
	0x204df: "\v\x03\U000204df", // 𠓟
	0x204e0: "\v\x04\U000204e0", // 𠓠
	0x204e1: "\v\x04\U000204e1", // 𠓡
	0x204e2: "\v\x04\U000204e2", // 𠓢
	0x204e3: "\v\x04\U000204e3", // 𠓣
	0x204e4: "\v\x05\U000204e4", // 𠓤
	0x204e5: "\v\x05\U000204e5", // 𠓥
	0x204e6: "\v\x05\U000204e6", // 𠓦
	0x204e7: "\v\x05\U000204e7", // 𠓧
	0x204e8: "\v\x05\U000204e8", // 𠓨
	0x204e9: "\v\x06\U000204e9", // 𠓩
	0x204ea: "\v\a\U000204ea", // 𠓪
	0x204eb: "\v\a\U000204eb", // 𠓫
	0x204ec: "\v\a\U000204ec", // 𠓬
	0x204ed: "\v\b\U000204ed", // 𠓭
	0x204ee: "\v\b\U000204ee", // 𠓮
	0x204ef: "\v\b\U000204ef", // 𠓯
	0x204f0: "\v\b\U000204f0", // 𠓰
	0x204f1: "\v\t\U000204f1", // 𠓱
	0x204f2: "\v\n\U000204f2", // 𠓲
	0x204f3: "\v\n\U000204f3", // 𠓳
	0x204f4: "\v\v\U000204f4", // 𠓴
	0x204f5: "\v\v\U000204f5", // 𠓵
	0x204f6: "\v\v\U000204f6", // 𠓶
	0x204f7: "\v\v\U000204f7", // 𠓷
	0x204f8: "\v\f\U000204f8", // 𠓸
	0x204f9: "\v\f\U000204f9", // 𠓹
	0x204fa: "\v\f\U000204fa", // 𠓺
	0x204fb: "\v\f\U000204fb", // 𠓻
	0x204fc: "\v\x0e\U000204fc", // 𠓼
	0x204fd: "\v\x0f\U000204fd", // 𠓽
	0x204fe: "\v\x10\U000204fe", // 𠓾
	0x204ff: "\v\x12\U000204ff", // 𠓿
	0x20500: "\f\x01\U00020500", // 𠔀
	0x20501: "\f\x02\U00020501", // 𠔁
	0x20502: "\f\x02\U00020502", // 𠔂
	0x20503: "\f\x02\U00020503", // 𠔃
	0x20504: "\f\x02\U00020504", // 𠔄
	0x20505: "\f\x03\U00020505", // 𠔅
	0x20506: "\f\x03\U00020506", // 𠔆
	0x20507: "\xa2\x00\U00020507", // 𠔇
	0x20508: "\f\x04\U00020508", // 𠔈
	0x20509: "\f\x04\U00020509", // 𠔉
	0x2050a: "\f\x05\U0002050a", // 𠔊
	0x2050b: "\f\x05\U0002050b", // 𠔋
	0x2050c: "\f\x05\U0002050c", // 𠔌
	0x2050d: "\f\x05\U0002050d", // 𠔍
	0x2050e: "\f\x05\U0002050e", // 𠔎
	0x2050f: "\f\x05\U0002050f", // 𠔏
	0x20510: "\f\x06\U00020510", // 𠔐
	0x20511: "\f\x06\U00020511", // 𠔑
	0x20512: "\f\a\U00020512", // 𠔒
	0x20513: "\f\a\U00020513", // 𠔓
	0x20514: "\f\a\U00020514", // 𠔔
	0x20515: "\f\a\U00020515", // 𠔕
	0x20516: "\f\a\U00020516", // 𠔖
	0x20517: "\f\a\U00020517", // 𠔗
	0x20518: "9\x06\U00020518", // 𠔘
	0x20519: "\f\b\U00020519", // 𠔙
	0x2051a: "\f\b\U0002051a", // 𠔚
	0x2051b: "\f\b\U0002051b", // 𠔛
	0x2051c: "\f\t\U0002051c", // 𠔜
	0x2051d: "\f\t\U0002051d", // 𠔝
	0x2051e: "\f\n\U0002051e", // 𠔞
	0x2051f: "\f\n\U0002051f", // 𠔟
	0x20520: "\f\n\U00020520", // 𠔠
	0x20521: "\f\n\U00020521", // 𠔡
	0x20522: "\f\n\U00020522", // 𠔢
	0x20523: "\f\n\U00020523", // 𠔣
	0x20524: "\f\n\U00020524", // 𠔤
	0x20525: "\f\n\U00020525", // 𠔥
	0x20526: "\f\n\U00020526", // 𠔦
	0x20527: "\f\n\U00020527", // 𠔧
	0x20528: "\f\v\U00020528", // 𠔨
	0x20529: "\f\v\U00020529", // 𠔩
	0x2052a: "\f\v\U0002052a", // 𠔪
	0x2052b: "\f\v\U0002052b", // 𠔫
	0x2052c: "\f\v\U0002052c", // 𠔬
	0x2052d: "\f\v\U0002052d", // 𠔭
	0x2052e: "\f\v\U0002052e", // 𠔮
	0x2052f: "\f\f\U0002052f", // 𠔯
	0x20530: "\f\f\U00020530", // 𠔰
	0x20531: "\f\f\U00020531", // 𠔱
	0x20532: "\x1c\f\U00020532", // 𠔲
	0x20533: "\f\x0e\U00020533", // 𠔳
	0x20534: "\f\x0e\U00020534", // 𠔴
	0x20535: "\f\x0e\U00020535", // 𠔵
	0x20536: "\f\x10\U00020536", // 𠔶
	0x20537: "\f\x10\U00020537", // 𠔷
	0x20538: "\f\x11\U00020538", // 𠔸
	0x20539: "\f\x11\U00020539", // 𠔹
	0x2053a: "\f\x11\U0002053a", // 𠔺
	0x2053b: "\x86:\U0002053b", // 𠔻
	0x2053c: "\r\x01\U0002053c", // 𠔼
	0x2053d: "\r\x02\U0002053d", // 𠔽
	0x2053e: "\r\x02\U0002053e", // 𠔾
	0x2053f: "\r\x02\U0002053f", // 𠔿
	0x20540: "\r\x02\U00020540", // 𠕀
	0x20541: "\r\x03\U00020541", // 𠕁
	0x20542: "\r\x03\U00020542", // 𠕂
	0x20543: "\r\x03\U00020543", // 𠕃
	0x20544: "\r\x03\U00020544", // 𠕄
	0x20545: "\r\x03\U00020545", // 𠕅
	0x20546: "\r\x03\U00020546", // 𠕆
	0x20547: "\r\x03\U00020547", // 𠕇
	0x20548: "\r\x03\U00020548", // 𠕈
	0x20549: "\r\x03\U00020549", // 𠕉
	0x2054a: "\r\x03\U0002054a", // 𠕊
	0x2054b: "\r\x04\U0002054b", // 𠕋
	0x2054c: "\r\x04\U0002054c", // 𠕌
	0x2054d: "\r\x04\U0002054d", // 𠕍
	0x2054e: "\r\x04\U0002054e", // 𠕎
	0x2054f: "\r\x04\U0002054f", // 𠕏
	0x20550: "\r\x05\U00020550", // 𠕐
	0x20551: "\r\x05\U00020551", // 𠕑
	0x20552: "\r\x05\U00020552", // 𠕒
	0x20553: "\r\x05\U00020553", // 𠕓
	0x20554: "\r\x05\U00020554", // 𠕔
	0x20555: "\r\x05\U00020555", // 𠕕
	0x20556: "\r\x06\U00020556", // 𠕖
	0x20557: "\r\x06\U00020557", // 𠕗
	0x20558: "\r\x06\U00020558", // 𠕘
	0x20559: "\r\x06\U00020559", // 𠕙
	0x2055a: "\r\x06\U0002055a", // 𠕚
	0x2055b: "\r\a\U0002055b", // 𠕛
	0x2055c: "\r\a\U0002055c", // 𠕜
	0x2055d: "\r\b\U0002055d", // 𠕝
	0x2055e: "\r\b\U0002055e", // 𠕞
	0x2055f: "\r\b\U0002055f", // 𠕟
	0x20560: "\r\t\U00020560", // 𠕠
	0x20561: "\r\t\U00020561", // 𠕡
	0x20562: "\r\t\U00020562", // 𠕢
	0x20563: "\r\n\U00020563", // 𠕣
	0x20564: "\r\n\U00020564", // 𠕤
	0x20565: "\r\n\U00020565", // 𠕥
	0x20566: "\r\v\U00020566", // 𠕦
	0x20567: "\r\v\U00020567", // 𠕧
	0x20568: "\r\f\U00020568", // 𠕨
	0x20569: "\r\f\U00020569", // 𠕩
	0x2056a: "\r\r\U0002056a", // 𠕪
	0x2056b: "=\v\U0002056b", // 𠕫
	0x2056c: "\r\r\U0002056c", // 𠕬
	0x2056d: "\r\x0e\U0002056d", // 𠕭
	0x2056e: "\r\x0e\U0002056e", // 𠕮
	0x2056f: "\r\x10\U0002056f", // 𠕯
	0x20570: "\r\x10\U00020570", // 𠕰
	0x20571: "\r\x12\U00020571", // 𠕱
	0x20572: "\r\x14\U00020572", // 𠕲
	0x20573: "\x0e\x02\U00020573", // 𠕳
	0x20574: "\x0e\x02\U00020574", // 𠕴
	0x20575: "\x0e\x03\U00020575", // 𠕵
	0x20576: "\x0e\x03\U00020576", // 𠕶
	0x20577: "\x0e\x03\U00020577", // 𠕷
	0x20578: "\x0e\x03\U00020578", // 𠕸
	0x20579: "\x0e\x04\U00020579", // 𠕹
	0x2057a: "\x0e\x04\U0002057a", // 𠕺
	0x2057b: "\x0e\x04\U0002057b", // 𠕻
	0x2057c: "\x0e\x04\U0002057c", // 𠕼
	0x2057d: "\x0e\x04\U0002057d", // 𠕽
	0x2057e: "\x0e\x04\U0002057e", // 𠕾
	0x2057f: "\x0e\x04\U0002057f", // 𠕿
	0x20580: "\x0e\x05\U00020580", // 𠖀
	0x20581: "\x0e\x05\U00020581", // 𠖁
	0x20582: "\x0e\x05\U00020582", // 𠖂
	0x20583: "\x0e\x05\U00020583", // 𠖃
	0x20584: "\x0e\x06\U00020584", // 𠖄
	0x20585: "\x0e\x06\U00020585", // 𠖅
	0x20586: "\x0e\x06\U00020586", // 𠖆
	0x20587: "\x0e\a\U00020587", // 𠖇
	0x20588: "\x0e\a\U00020588", // 𠖈
	0x20589: "\x0e\a\U00020589", // 𠖉
	0x2058a: "\x0e\a\U0002058a", // 𠖊
	0x2058b: "\x0e\a\U0002058b", // 𠖋
	0x2058c: "\x0e\b\U0002058c", // 𠖌
	0x2058d: "\x0e\b\U0002058d", // 𠖍
	0x2058e: "\x0e\b\U0002058e", // 𠖎
	0x2058f: "\x0e\b\U0002058f", // 𠖏
	0x20590: "\x0e\b\U00020590", // 𠖐
	0x20591: "\x0e\b\U00020591", // 𠖑
	0x20592: "\x0e\b\U00020592", // 𠖒
	0x20593: "\x0e\t\U00020593", // 𠖓
	0x20594: "\x0e\n\U00020594", // 𠖔
	0x20595: "\x0e\n\U00020595", // 𠖕
	0x20596: "\x0e\n\U00020596", // 𠖖
	0x20597: "\x0e\n\U00020597", // 𠖗
	0x20598: "\x0e\n\U00020598", // 𠖘
	0x20599: "\x0e\n\U00020599", // 𠖙
	0x2059a: "\x0e\v\U0002059a", // 𠖚
	0x2059b: "\x0e\v\U0002059b", // 𠖛
	0x2059c: "\x0e\f\U0002059c", // 𠖜
	0x2059d: "\x0e\f\U0002059d", // 𠖝
	0x2059e: "\x0e\f\U0002059e", // 𠖞
	0x2059f: "q\n\U0002059f", // 𠖟
	0x205a0: "\x0e\x0e\U000205a0", // 𠖠
	0x205a1: "\x0e\x0e\U000205a1", // 𠖡
	0x205a2: "\x0e\x0f\U000205a2", // 𠖢
	0x205a3: "\x0e\x10\U000205a3", // 𠖣
	0x205a4: "\x0e\x10\U000205a4", // 𠖤
	0x205a5: "\x0e\x10\U000205a5", // 𠖥
	0x205a6: "\x0e\x12\U000205a6", // 𠖦
	0x205a7: "\x0e\x12\U000205a7", // 𠖧
	0x205a8: "\x0e\x12\U000205a8", // 𠖨
	0x205a9: "\x0e\x13\U000205a9", // 𠖩
	0x205aa: "\x0e\x14\U000205aa", // 𠖪
	0x205ab: "\x0e\x15\U000205ab", // 𠖫
	0x205ac: "\x0f\x01\U000205ac", // 𠖬
	0x205ad: "\x0f\x02\U000205ad", // 𠖭
	0x205ae: "\x0f\x03\U000205ae", // 𠖮
	0x205af: "\x0f\x03\U000205af", // 𠖯
	0x205b0: "\x0f\x03\U000205b0", // 𠖰
	0x205b1: "\x0f\x04\U000205b1", // 𠖱
	0x205b2: "\x0f\x04\U000205b2", // 𠖲
	0x205b3: "\x0f\x04\U000205b3", // 𠖳
	0x205b4: "\x0f\x04\U000205b4", // 𠖴
	0x205b5: "\x0f\x04\U000205b5", // 𠖵
	0x205b6: "\x0f\x04\U000205b6", // 𠖶
	0x205b7: "\x0f\x05\U000205b7", // 𠖷
	0x205b8: "\x0f\x05\U000205b8", // 𠖸
	0x205b9: "\x0f\x05\U000205b9", // 𠖹
	0x205ba: "\x0f\x05\U000205ba", // 𠖺
	0x205bb: "\x0f\x05\U000205bb", // 𠖻
	0x205bc: "\x0f\x05\U000205bc", // 𠖼
	0x205bd: "\x0f\x05\U000205bd", // 𠖽
	0x205be: "\x0f\x05\U000205be", // 𠖾
	0x205bf: "\x0f\x05\U000205bf", // 𠖿
	0x205c0: "\x0f\x06\U000205c0", // 𠗀
	0x205c1: "\x0f\x05\U000205c1", // 𠗁
	0x205c2: "\x0f\x06\U000205c2", // 𠗂
	0x205c3: "\x0f\x06\U000205c3", // 𠗃
	0x205c4: "\x0f\x06\U000205c4", // 𠗄
	0x205c5: "\x0f\x06\U000205c5", // 𠗅
	0x205c6: "\x0f\x06\U000205c6", // 𠗆
	0x205c7: "\x0f\x06\U000205c7", // 𠗇
	0x205c8: "\x0f\a\U000205c8", // 𠗈
	0x205c9: "\x0f\a\U000205c9", // 𠗉
	0x205ca: "\x0f\a\U000205ca", // 𠗊
	0x205cb: "\x0f\a\U000205cb", // 𠗋
	0x205cc: "\x0f\a\U000205cc", // 𠗌
	0x205cd: "\x0f\a\U000205cd", // 𠗍
	0x205ce: "\x0f\a\U000205ce", // 𠗎
	0x205cf: "\x0f\a\U000205cf", // 𠗏
	0x205d0: "\x0f\a\U000205d0", // 𠗐
	0x205d1: "\x0f\a\U000205d1", // 𠗑
	0x205d2: "\x0f\a\U000205d2", // 𠗒
	0x205d3: "\x0f\a\U000205d3", // 𠗓
	0x205d4: "\x0f\a\U000205d4", // 𠗔
	0x205d5: "\x0f\a\U000205d5", // 𠗕
	0x205d6: "\x0f\a\U000205d6", // 𠗖
	0x205d7: "\x0f\a\U000205d7", // 𠗗
	0x205d8: "\x0f\b\U000205d8", // 𠗘
	0x205d9: "\x0f\b\U000205d9", // 𠗙
	0x205da: "\x0f\b\U000205da", // 𠗚
	0x205db: "\x0f\b\U000205db", // 𠗛
	0x205dc: "\x0f\b\U000205dc", // 𠗜
	0x205dd: "\x0f\b\U000205dd", // 𠗝
	0x205de: "\x0f\b\U000205de", // 𠗞
	0x205df: "\x0f\b\U000205df", // 𠗟
	0x205e0: "\x0f\b\U000205e0", // 𠗠
	0x205e1: "\x0f\b\U000205e1", // 𠗡
	0x205e2: "\x0f\b\U000205e2", // 𠗢
	0x205e3: "\x0f\b\U000205e3", // 𠗣
	0x205e4: "\x0f\b\U000205e4", // 𠗤
	0x205e5: "\x0f\t\U000205e5", // 𠗥
	0x205e6: "\x0f\t\U000205e6", // 𠗦
	0x205e7: "\x0f\t\U000205e7", // 𠗧
	0x205e8: "\x0f\t\U000205e8", // 𠗨
	0x205e9: "\x0f\t\U000205e9", // 𠗩
	0x205ea: "\x0f\t\U000205ea", // 𠗪
	0x205eb: "\x0f\t\U000205eb", // 𠗫
	0x205ec: "\x0f\t\U000205ec", // 𠗬
	0x205ed: "\x0f\t\U000205ed", // 𠗭
	0x205ee: "\x0f\t\U000205ee", // 𠗮
	0x205ef: "\x0f\t\U000205ef", // 𠗯
	0x205f0: "\x0f\t\U000205f0", // 𠗰
	0x205f1: "\x0f\n\U000205f1", // 𠗱
	0x205f2: "\x0f\n\U000205f2", // 𠗲
	0x205f3: "\x0f\n\U000205f3", // 𠗳
	0x205f4: "\x0f\n\U000205f4", // 𠗴
	0x205f5: "\x0f\n\U000205f5", // 𠗵
	0x205f6: "\x0f\n\U000205f6", // 𠗶
	0x205f7: "\x0f\n\U000205f7", // 𠗷
	0x205f8: "\x0f\n\U000205f8", // 𠗸
	0x205f9: "\x0f\n\U000205f9", // 𠗹
	0x205fa: "\x0f\v\U000205fa", // 𠗺
	0x205fb: "\x0f\v\U000205fb", // 𠗻
	0x205fc: "\x0f\v\U000205fc", // 𠗼
	0x205fd: "\x0f\v\U000205fd", // 𠗽
	0x205fe: "\x0f\v\U000205fe", // 𠗾
	0x205ff: "\x0f\v\U000205ff", // 𠗿
	0x20600: "\x0f\v\U00020600", // 𠘀
	0x20601: "\x0f\v\U00020601", // 𠘁
	0x20602: "\x0f\v\U00020602", // 𠘂
	0x20603: "\x0f\v\U00020603", // 𠘃
	0x20604: "\x0f\f\U00020604", // 𠘄
	0x20605: "\x0f\f\U00020605", // 𠘅
	0x20606: "\x0f\f\U00020606", // 𠘆
	0x20607: "\x0f\f\U00020607", // 𠘇
	0x20608: "\x0f\f\U00020608", // 𠘈
	0x20609: "\x0f\f\U00020609", // 𠘉
	0x2060a: "\x0f\r\U0002060a", // 𠘊
	0x2060b: "\x0f\r\U0002060b", // 𠘋
	0x2060c: "\x0f\r\U0002060c", // 𠘌
	0x2060d: "\x0f\r\U0002060d", // 𠘍
	0x2060e: "\x0f\r\U0002060e", // 𠘎
	0x2060f: "\x0f\r\U0002060f", // 𠘏
	0x20610: "\x0f\r\U00020610", // 𠘐
	0x20611: "\x0f\r\U00020611", // 𠘑
	0x20612: "\x0f\x0e\U00020612", // 𠘒
	0x20613: "\x0f\f\U00020613", // 𠘓
	0x20614: "\x0f\x0e\U00020614", // 𠘔
	0x20615: "\x0f\x0e\U00020615", // 𠘕
	0x20616: "\x0f\x0f\U00020616", // 𠘖
	0x20617: "\x0f\x0f\U00020617", // 𠘗
	0x20618: "\x0f\x0f\U00020618", // 𠘘
	0x20619: "\x0f\x0f\U00020619", // 𠘙
	0x2061a: "\x0f\x0f\U0002061a", // 𠘚
	0x2061b: "\x0f\x0f\U0002061b", // 𠘛
	0x2061c: "\x0f\x0f\U0002061c", // 𠘜
	0x2061d: "\x0f\x10\U0002061d", // 𠘝
	0x2061e: "\x0f\x10\U0002061e", // 𠘞
	0x2061f: "\x0f\x10\U0002061f", // 𠘟
	0x20620: "\x0f\x10\U00020620", // 𠘠
	0x20621: "\x0f\x10\U00020621", // 𠘡
	0x20622: "\x0f\x11\U00020622", // 𠘢
	0x20623: "\x0f\x11\U00020623", // 𠘣
	0x20624: "\x0f\x13\U00020624", // 𠘤
	0x20625: "\x0f\x14\U00020625", // 𠘥
	0x20626: "\x0f\x18\U00020626", // 𠘦
	0x20627: "\x10\x00\U00020627", // 𠘧
	0x20628: "\x10\x00\U00020628", // 𠘨
	0x20629: "\x10\x02\U00020629", // 𠘩
	0x2062a: "\x10\x02\U0002062a", // 𠘪
	0x2062b: "\x10\x02\U0002062b", // 𠘫
	0x2062c: "\x10\x02\U0002062c", // 𠘬
	0x2062d: "\x10\x02\U0002062d", // 𠘭
	0x2062e: "\x10\x02\U0002062e", // 𠘮
	0x2062f: "\x10\x02\U0002062f", // 𠘯
	0x20630: "\x10\x02\U00020630", // 𠘰
	0x20631: "\x10\x03\U00020631", // 𠘱
	0x20632: "\x10\x03\U00020632", // 𠘲
	0x20633: "\x10\x03\U00020633", // 𠘳
	0x20634: "\x10\x03\U00020634", // 𠘴
	0x20635: "\x10\x04\U00020635", // 𠘵
	0x20636: "\x10\x04\U00020636", // 𠘶
	0x20637: "\x10\x04\U00020637", // 𠘷
	0x20638: "\x10\x04\U00020638", // 𠘸
	0x20639: "\x10\x04\U00020639", // 𠘹
	0x2063a: "\x10\x04\U0002063a", // 𠘺
	0x2063b: "\x10\x04\U0002063b", // 𠘻
	0x2063c: "\x10\x05\U0002063c", // 𠘼
	0x2063d: "\x10\x05\U0002063d", // 𠘽
	0x2063e: "\x10\x05\U0002063e", // 𠘾
	0x2063f: "\x10\x05\U0002063f", // 𠘿
	0x20640: "\x10\x05\U00020640", // 𠙀
	0x20641: "\x10\x05\U00020641", // 𠙁
	0x20642: "\x10\x05\U00020642", // 𠙂
	0x20643: "\x10\x05\U00020643", // 𠙃
	0x20644: "\x10\x05\U00020644", // 𠙄
	0x20645: "\x10\x05\U00020645", // 𠙅
	0x20646: "\x10\x06\U00020646", // 𠙆
	0x20647: "\x10\x06\U00020647", // 𠙇
	0x20648: "\x10\x06\U00020648", // 𠙈
	0x20649: "\x10\x06\U00020649", // 𠙉
	0x2064a: "\x10\x06\U0002064a", // 𠙊
	0x2064b: "\x10\x06\U0002064b", // 𠙋
	0x2064c: "\x10\x06\U0002064c", // 𠙌
	0x2064d: "\x10\x06\U0002064d", // 𠙍
	0x2064e: "\x10\x06\U0002064e", // 𠙎
	0x2064f: "\x10\a\U0002064f", // 𠙏
	0x20650: "\x10\a\U00020650", // 𠙐
	0x20651: "\x10\a\U00020651", // 𠙑
	0x20652: "\x10\b\U00020652", // 𠙒
	0x20653: "\x10\b\U00020653", // 𠙓
	0x20654: "\x10\b\U00020654", // 𠙔
	0x20655: "\x10\b\U00020655", // 𠙕
	0x20656: "\x10\b\U00020656", // 𠙖
	0x20657: "/\a\U00020657", // 𠙗
	0x20658: "\x10\t\U00020658", // 𠙘
	0x20659: "\x10\t\U00020659", // 𠙙
	0x2065a: "\"\b\U0002065a", // 𠙚
	0x2065b: "\x10\t\U0002065b", // 𠙛
	0x2065c: "\x10\t\U0002065c", // 𠙜
	0x2065d: "\x10\t\U0002065d", // 𠙝
	0x2065e: "\x10\t\U0002065e", // 𠙞
	0x2065f: "\x10\n\U0002065f", // 𠙟
	0x20660: "\x10\n\U00020660", // 𠙠
	0x20661: "\x10\n\U00020661", // 𠙡
	0x20662: "\x10\n\U00020662", // 𠙢
	0x20663: "\x10\n\U00020663", // 𠙣
	0x20664: "\x10\v\U00020664", // 𠙤
	0x20665: "\x10\v\U00020665", // 𠙥
	0x20666: "\x10\v\U00020666", // 𠙦
	0x20667: "\x10\v\U00020667", // 𠙧
	0x20668: "\x10\f\U00020668", // 𠙨
	0x20669: "\x10\f\U00020669", // 𠙩
	0x2066a: "\x10\f\U0002066a", // 𠙪
	0x2066b: "\x10\r\U0002066b", // 𠙫
	0x2066c: "\xb6\x06\U0002066c", // 𠙬
	0x2066d: "\x10\x0e\U0002066d", // 𠙭
	0x2066e: "\x10\x0e\U0002066e", // 𠙮
	0x2066f: "\x10\x0e\U0002066f", // 𠙯
	0x20670: "\x10\x0e\U00020670", // 𠙰
	0x20671: "\x10\x0f\U00020671", // 𠙱
	0x20672: "\x10\x12\U00020672", // 𠙲
	0x20673: "\x10\x13\U00020673", // 𠙳
	0x20674: "\x11\x00\U00020674", // 𠙴
	0x20675: "\x11\x01\U00020675", // 𠙵
	0x20676: "\x11\x02\U00020676", // 𠙶
	0x20677: "\x11\x02\U00020677", // 𠙷
	0x20678: "\x11\x02\U00020678", // 𠙸
	0x20679: "\x11\x03\U00020679", // 𠙹
	0x2067a: "\x11\x03\U0002067a", // 𠙺
	0x2067b: "\x11\x03\U0002067b", // 𠙻
	0x2067c: "\x1e\x02\U0002067c", // 𠙼
	0x2067d: "\x11\x03\U0002067d", // 𠙽
	0x2067e: "\x11\x04\U0002067e", // 𠙾
	0x2067f: "\x11\x04\U0002067f", // 𠙿
	0x20680: "\x11\x04\U00020680", // 𠚀
	0x20681: "\x11\x04\U00020681", // 𠚁
	0x20682: "\x11\x04\U00020682", // 𠚂
	0x20683: "\x11\x04\U00020683", // 𠚃
	0x20684: "\x11\x04\U00020684", // 𠚄
	0x20685: "\x11\x04\U00020685", // 𠚅
	0x20686: "\x11\x05\U00020686", // 𠚆
	0x20687: "\x11\x05\U00020687", // 𠚇
	0x20688: "\x11\x05\U00020688", // 𠚈
	0x20689: "\x11\x05\U00020689", // 𠚉
	0x2068a: "\x11\x05\U0002068a", // 𠚊
	0x2068b: "\x11\x06\U0002068b", // 𠚋
	0x2068c: "\x11\x06\U0002068c", // 𠚌
	0x2068d: "\x11\x06\U0002068d", // 𠚍
	0x2068e: "\x11\a\U0002068e", // 𠚎
	0x2068f: "\x11\a\U0002068f", // 𠚏
	0x20690: "\x11\a\U00020690", // 𠚐
	0x20691: "\xb0\x00\U00020691", // 𠚑
	0x20692: "\x11\b\U00020692", // 𠚒
	0x20693: "\x11\b\U00020693", // 𠚓
	0x20694: "\x11\t\U00020694", // 𠚔
	0x20695: "\x11\t\U00020695", // 𠚕
	0x20696: "\x11\t\U00020696", // 𠚖
	0x20697: "\x11\t\U00020697", // 𠚗
	0x20698: "\x11\n\U00020698", // 𠚘
	0x20699: "\x11\f\U00020699", // 𠚙
	0x2069a: "\x11\f\U0002069a", // 𠚚
	0x2069b: " \f\U0002069b", // 𠚛
	0x2069c: "\x11\r\U0002069c", // 𠚜
	0x2069d: "\x11\x0e\U0002069d", // 𠚝
	0x2069e: "\x11\x0f\U0002069e", // 𠚞
	0x2069f: "\x11\x11\U0002069f", // 𠚟
	0x206a0: "\x11\x12\U000206a0", // 𠚠
	0x206a1: "\x11\x13\U000206a1", // 𠚡
	0x206a2: "\x11\x16\U000206a2", // 𠚢
	0x206a3: "\x12\x00\U000206a3", // 𠚣
	0x206a4: "\x12\x01\U000206a4", // 𠚤
	0x206a5: "\x12\x02\U000206a5", // 𠚥
	0x206a6: "\x12\x02\U000206a6", // 𠚦
	0x206a7: "\x12\x02\U000206a7", // 𠚧
	0x206a8: "\x12\x02\U000206a8", // 𠚨
	0x206a9: "\x12\x02\U000206a9", // 𠚩
	0x206aa: "\x12\x02\U000206aa", // 𠚪
	0x206ab: "\x12\x02\U000206ab", // 𠚫
	0x206ac: "\x12\x02\U000206ac", // 𠚬
	0x206ad: "\x12\x03\U000206ad", // 𠚭
	0x206ae: "\x12\x03\U000206ae", // 𠚮
	0x206af: "\x12\x03\U000206af", // 𠚯
	0x206b0: "\x12\x03\U000206b0", // 𠚰
	0x206b1: "\x12\x03\U000206b1", // 𠚱
	0x206b2: "\x12\x03\U000206b2", // 𠚲
	0x206b3: "\x12\x03\U000206b3", // 𠚳
	0x206b4: "\x12\x03\U000206b4", // 𠚴
	0x206b5: "\x12\x04\U000206b5", // 𠚵
	0x206b6: "\x12\x03\U000206b6", // 𠚶
	0x206b7: "\x12\x04\U000206b7", // 𠚷
	0x206b8: "\x12\x04\U000206b8", // 𠚸
	0x206b9: "\x12\x04\U000206b9", // 𠚹
	0x206ba: "\x12\x04\U000206ba", // 𠚺
	0x206bb: "\x12\x03\U000206bb", // 𠚻
	0x206bc: "\x12\x04\U000206bc", // 𠚼
	0x206bd: "\x12\x04\U000206bd", // 𠚽
	0x206be: "\x12\x04\U000206be", // 𠚾
	0x206bf: "\x12\x04\U000206bf", // 𠚿
	0x206c0: "\x12\x04\U000206c0", // 𠛀
	0x206c1: "\x12\x04\U000206c1", // 𠛁
	0x206c2: "\x12\x04\U000206c2", // 𠛂
	0x206c3: "\x12\x04\U000206c3", // 𠛃
	0x206c4: "\x12\x04\U000206c4", // 𠛄
	0x206c5: "\x12\x04\U000206c5", // 𠛅
	0x206c6: "\x12\x04\U000206c6", // 𠛆
	0x206c7: "\x12\x04\U000206c7", // 𠛇
	0x206c8: "\x12\x04\U000206c8", // 𠛈
	0x206c9: "\x12\x04\U000206c9", // 𠛉
	0x206ca: "\x12\x04\U000206ca", // 𠛊
	0x206cb: "\x12\x04\U000206cb", // 𠛋
	0x206cc: "\x12\x04\U000206cc", // 𠛌
	0x206cd: "\x12\x04\U000206cd", // 𠛍
	0x206ce: "\x12\x05\U000206ce", // 𠛎
	0x206cf: "\x12\x05\U000206cf", // 𠛏
	0x206d0: "\x12\x05\U000206d0", // 𠛐
	0x206d1: "\x12\x05\U000206d1", // 𠛑
	0x206d2: "\x12\x05\U000206d2", // 𠛒
	0x206d3: "\x12\x05\U000206d3", // 𠛓
	0x206d4: "\x12\x05\U000206d4", // 𠛔
	0x206d5: "\x12\x05\U000206d5", // 𠛕
	0x206d6: "\x12\x05\U000206d6", // 𠛖
	0x206d7: "\x12\x05\U000206d7", // 𠛗
	0x206d8: "\x12\x05\U000206d8", // 𠛘
	0x206d9: "\x12\x05\U000206d9", // 𠛙
	0x206da: "\x12\x05\U000206da", // 𠛚
	0x206db: "\x12\x05\U000206db", // 𠛛
	0x206dc: "\x12\x05\U000206dc", // 𠛜
	0x206dd: "\x12\x05\U000206dd", // 𠛝
	0x206de: "\x12\x05\U000206de", // 𠛞
	0x206df: "\x12\x05\U000206df", // 𠛟
	0x206e0: "\x12\x05\U000206e0", // 𠛠
	0x206e1: "\x12\x05\U000206e1", // 𠛡
	0x206e2: "\x12\x05\U000206e2", // 𠛢
	0x206e3: "\x12\x05\U000206e3", // 𠛣
	0x206e4: "\x12\x05\U000206e4", // 𠛤
	0x206e5: "\x12\x05\U000206e5", // 𠛥
	0x206e6: "\x12\x05\U000206e6", // 𠛦
	0x206e7: "\x12\x06\U000206e7", // 𠛧
	0x206e8: "\x12\x06\U000206e8", // 𠛨
	0x206e9: "\x12\x06\U000206e9", // 𠛩
	0x206ea: "\x12\x06\U000206ea", // 𠛪
	0x206eb: "\x12\x06\U000206eb", // 𠛫
	0x206ec: "\x12\x06\U000206ec", // 𠛬
	0x206ed: "\x12\x06\U000206ed", // 𠛭
	0x206ee: "\x12\x06\U000206ee", // 𠛮
	0x206ef: "\x12\x06\U000206ef", // 𠛯
	0x206f0: "\x12\x06\U000206f0", // 𠛰
	0x206f1: "\x12\x06\U000206f1", // 𠛱
	0x206f2: "\x12\x06\U000206f2", // 𠛲
	0x206f3: "\x12\x06\U000206f3", // 𠛳
	0x206f4: "\x12\x06\U000206f4", // 𠛴
	0x206f5: "\x12\x06\U000206f5", // 𠛵
	0x206f6: "\x12\x06\U000206f6", // 𠛶
	0x206f7: "\x12\x06\U000206f7", // 𠛷
	0x206f8: "\x12\x06\U000206f8", // 𠛸
	0x206f9: "\x12\x06\U000206f9", // 𠛹
	0x206fa: "\x12\x06\U000206fa", // 𠛺
	0x206fb: "\x12\x06\U000206fb", // 𠛻
	0x206fc: "\x12\x06\U000206fc", // 𠛼
	0x206fd: "\x12\x06\U000206fd", // 𠛽
	0x206fe: "\x12\x06\U000206fe", // 𠛾
	0x206ff: "\x12\x06\U000206ff", // 𠛿
	0x20700: "\x12\x06\U00020700", // 𠜀
	0x20701: "\x12\x06\U00020701", // 𠜁
	0x20702: "\x12\x06\U00020702", // 𠜂
	0x20703: "\x12\x06\U00020703", // 𠜃
	0x20704: "\x12\x06\U00020704", // 𠜄
	0x20705: "\x12\x06\U00020705", // 𠜅
	0x20706: "\x12\x06\U00020706", // 𠜆
	0x20707: "\x12\x06\U00020707", // 𠜇
	0x20708: "\x12\x06\U00020708", // 𠜈
	0x20709: "\x12\x06\U00020709", // 𠜉
	0x2070a: "\x12\x06\U0002070a", // 𠜊
	0x2070b: "\x12\x06\U0002070b", // 𠜋
	0x2070c: "\x12\x06\U0002070c", // 𠜌
	0x2070d: "\x12\x06\U0002070d", // 𠜍
	0x2070e: "\x12\x06\U0002070e", // 𠜎
	0x2070f: "\x12\x06\U0002070f", // 𠜏
	0x20710: "\x12\a\U00020710", // 𠜐
	0x20711: "\x12\a\U00020711", // 𠜑
	0x20712: "\x12\a\U00020712", // 𠜒
	0x20713: "\x12\a\U00020713", // 𠜓
	0x20714: "\x12\a\U00020714", // 𠜔
	0x20715: "\x12\a\U00020715", // 𠜕
	0x20716: "\x12\a\U00020716", // 𠜖
	0x20717: "\x12\a\U00020717", // 𠜗
	0x20718: "\x12\a\U00020718", // 𠜘
	0x20719: "\x12\a\U00020719", // 𠜙
	0x2071a: "\x12\a\U0002071a", // 𠜚
	0x2071b: "\x12\a\U0002071b", // 𠜛
	0x2071c: "\x12\a\U0002071c", // 𠜜
	0x2071d: "\x12\a\U0002071d", // 𠜝
	0x2071e: "\x12\a\U0002071e", // 𠜞
	0x2071f: "\x12\a\U0002071f", // 𠜟
	0x20720: "\x12\a\U00020720", // 𠜠
	0x20721: "\x12\a\U00020721", // 𠜡
	0x20722: "\x12\a\U00020722", // 𠜢
	0x20723: "\x12\a\U00020723", // 𠜣
	0x20724: "\x12\a\U00020724", // 𠜤
	0x20725: "\x12\a\U00020725", // 𠜥
	0x20726: "\x12\a\U00020726", // 𠜦
	0x20727: "\x12\a\U00020727", // 𠜧
	0x20728: "\x12\a\U00020728", // 𠜨
	0x20729: "\x12\a\U00020729", // 𠜩
	0x2072a: "\x12\a\U0002072a", // 𠜪
	0x2072b: "\x12\a\U0002072b", // 𠜫
	0x2072c: "\x12\a\U0002072c", // 𠜬
	0x2072d: "\x12\a\U0002072d", // 𠜭
	0x2072e: "\x12\a\U0002072e", // 𠜮
	0x2072f: "\x12\a\U0002072f", // 𠜯
	0x20730: "\x12\a\U00020730", // 𠜰
	0x20731: "\x12\b\U00020731", // 𠜱
	0x20732: "\x12\b\U00020732", // 𠜲
	0x20733: "\x12\b\U00020733", // 𠜳
	0x20734: "\x12\b\U00020734", // 𠜴
	0x20735: "\x12\b\U00020735", // 𠜵
	0x20736: "\x12\b\U00020736", // 𠜶
	0x20737: "\x12\b\U00020737", // 𠜷
	0x20738: "\x12\b\U00020738", // 𠜸
	0x20739: "\x12\b\U00020739", // 𠜹
	0x2073a: "\x12\b\U0002073a", // 𠜺
	0x2073b: "\x12\b\U0002073b", // 𠜻
	0x2073c: "\x12\b\U0002073c", // 𠜼
	0x2073d: "\x12\b\U0002073d", // 𠜽
	0x2073e: "\x12\b\U0002073e", // 𠜾
	0x2073f: "\x12\b\U0002073f", // 𠜿
	0x20740: "\x12\b\U00020740", // 𠝀
	0x20741: "\x12\b\U00020741", // 𠝁
	0x20742: "\x12\b\U00020742", // 𠝂
	0x20743: "\x12\b\U00020743", // 𠝃
	0x20744: "\x12\b\U00020744", // 𠝄
	0x20745: "\x12\b\U00020745", // 𠝅
	0x20746: "\x12\b\U00020746", // 𠝆
	0x20747: "\x12\b\U00020747", // 𠝇
	0x20748: "\x12\b\U00020748", // 𠝈
	0x20749: "\x12\b\U00020749", // 𠝉
	0x2074a: "\x12\b\U0002074a", // 𠝊
	0x2074b: "\x12\b\U0002074b", // 𠝋
	0x2074c: "\x12\b\U0002074c", // 𠝌
	0x2074d: "\x12\b\U0002074d", // 𠝍
	0x2074e: "\x12\b\U0002074e", // 𠝎
	0x2074f: "\x12\b\U0002074f", // 𠝏
	0x20750: "\x12\b\U00020750", // 𠝐
	0x20751: "\x12\b\U00020751", // 𠝑
	0x20752: "\x12\b\U00020752", // 𠝒
	0x20753: "\x12\b\U00020753", // 𠝓
	0x20754: "\x12\b\U00020754", // 𠝔
	0x20755: "\x12\b\U00020755", // 𠝕
	0x20756: "\x12\b\U00020756", // 𠝖
	0x20757: "\x12\b\U00020757", // 𠝗
	0x20758: "\x12\b\U00020758", // 𠝘
	0x20759: "\x12\b\U00020759", // 𠝙
	0x2075a: "\x12\b\U0002075a", // 𠝚
	0x2075b: "\x12\b\U0002075b", // 𠝛
	0x2075c: "\x12\b\U0002075c", // 𠝜
	0x2075d: "\x12\t\U0002075d", // 𠝝
	0x2075e: "\x12\t\U0002075e", // 𠝞
	0x2075f: "\x12\t\U0002075f", // 𠝟
	0x20760: "\x12\t\U00020760", // 𠝠
	0x20761: "\x12\t\U00020761", // 𠝡
	0x20762: "\x12\t\U00020762", // 𠝢
	0x20763: "\x12\t\U00020763", // 𠝣
	0x20764: "\x12\t\U00020764", // 𠝤
	0x20765: "\x12\t\U00020765", // 𠝥
	0x20766: "\x12\t\U00020766", // 𠝦
	0x20767: "\x12\t\U00020767", // 𠝧
	0x20768: "\x12\t\U00020768", // 𠝨
	0x20769: "\x12\t\U00020769", // 𠝩
	0x2076a: "\x12\t\U0002076a", // 𠝪
	0x2076b: "\x12\t\U0002076b", // 𠝫
	0x2076c: "\x12\t\U0002076c", // 𠝬
	0x2076d: "\x12\t\U0002076d", // 𠝭
	0x2076e: "\x12\t\U0002076e", // 𠝮
	0x2076f: "\x12\t\U0002076f", // 𠝯
	0x20770: "\x12\t\U00020770", // 𠝰
	0x20771: "\x12\t\U00020771", // 𠝱
	0x20772: "\x12\t\U00020772", // 𠝲
	0x20773: "\x12\t\U00020773", // 𠝳
	0x20774: "\x12\t\U00020774", // 𠝴
	0x20775: "\x12\t\U00020775", // 𠝵
	0x20776: "\x12\b\U00020776", // 𠝶
	0x20777: "\x12\t\U00020777", // 𠝷
	0x20778: "\x12\t\U00020778", // 𠝸
	0x20779: "\x12\t\U00020779", // 𠝹
	0x2077a: "\x12\t\U0002077a", // 𠝺
	0x2077b: "\x12\t\U0002077b", // 𠝻
	0x2077c: "\x12\t\U0002077c", // 𠝼
	0x2077d: "\x12\t\U0002077d", // 𠝽
	0x2077e: "\x12\t\U0002077e", // 𠝾
	0x2077f: "\x12\n\U0002077f", // 𠝿
	0x20780: "\x12\n\U00020780", // 𠞀
	0x20781: "\x12\n\U00020781", // 𠞁
	0x20782: "\x12\n\U00020782", // 𠞂
	0x20783: "\x12\n\U00020783", // 𠞃
	0x20784: "\x12\n\U00020784", // 𠞄
	0x20785: "\x12\n\U00020785", // 𠞅
	0x20786: "\x12\n\U00020786", // 𠞆
	0x20787: "\x12\n\U00020787", // 𠞇
	0x20788: "\x12\n\U00020788", // 𠞈
	0x20789: "\x12\n\U00020789", // 𠞉
	0x2078a: "\x12\n\U0002078a", // 𠞊
	0x2078b: "\x12\n\U0002078b", // 𠞋
	0x2078c: "\x12\n\U0002078c", // 𠞌
	0x2078d: "\x12\n\U0002078d", // 𠞍
	0x2078e: "\x12\n\U0002078e", // 𠞎
	0x2078f: "\x12\n\U0002078f", // 𠞏
	0x20790: "\x12\n\U00020790", // 𠞐
	0x20791: "\x12\n\U00020791", // 𠞑
	0x20792: "\x12\n\U00020792", // 𠞒
	0x20793: "\x12\n\U00020793", // 𠞓
	0x20794: "\x12\n\U00020794", // 𠞔
	0x20795: "\x12\n\U00020795", // 𠞕
	0x20796: "\x12\n\U00020796", // 𠞖
	0x20797: "\x12\n\U00020797", // 𠞗
	0x20798: "\x12\n\U00020798", // 𠞘
	0x20799: "\x12\n\U00020799", // 𠞙
	0x2079a: "\x12\n\U0002079a", // 𠞚
	0x2079b: "\x12\n\U0002079b", // 𠞛
	0x2079c: "s\a\U0002079c", // 𠞜
	0x2079d: "\x12\n\U0002079d", // 𠞝
	0x2079e: "\x12\n\U0002079e", // 𠞞
	0x2079f: "\x12\n\U0002079f", // 𠞟
	0x207a0: "\x12\n\U000207a0", // 𠞠
	0x207a1: "\x12\n\U000207a1", // 𠞡
	0x207a2: "\x12\n\U000207a2", // 𠞢
	0x207a3: "\x12\n\U000207a3", // 𠞣
	0x207a4: "\x12\n\U000207a4", // 𠞤
	0x207a5: "\x12\v\U000207a5", // 𠞥
	0x207a6: "\x12\v\U000207a6", // 𠞦
	0x207a7: "\x12\v\U000207a7", // 𠞧
	0x207a8: "\x12\v\U000207a8", // 𠞨
	0x207a9: "\x12\v\U000207a9", // 𠞩
	0x207aa: "\x12\v\U000207aa", // 𠞪
	0x207ab: "\x12\v\U000207ab", // 𠞫
	0x207ac: "\x12\v\U000207ac", // 𠞬
	0x207ad: "\x12\v\U000207ad", // 𠞭
	0x207ae: "\x12\v\U000207ae", // 𠞮
	0x207af: "\x12\v\U000207af", // 𠞯
	0x207b0: "\x12\v\U000207b0", // 𠞰
	0x207b1: "\x12\v\U000207b1", // 𠞱
	0x207b2: "\x12\v\U000207b2", // 𠞲
	0x207b3: "\x12\v\U000207b3", // 𠞳
	0x207b4: "\x12\v\U000207b4", // 𠞴
	0x207b5: "\x12\v\U000207b5", // 𠞵
	0x207b6: "\x12\v\U000207b6", // 𠞶
	0x207b7: "\x12\v\U000207b7", // 𠞷
	0x207b8: "\x12\v\U000207b8", // 𠞸
	0x207b9: "\x12\v\U000207b9", // 𠞹
	0x207ba: "\x12\v\U000207ba", // 𠞺
	0x207bb: "\x12\v\U000207bb", // 𠞻
	0x207bc: "\x12\v\U000207bc", // 𠞼
	0x207bd: "\x12\v\U000207bd", // 𠞽
	0x207be: "\x12\v\U000207be", // 𠞾
	0x207bf: "\x12\v\U000207bf", // 𠞿
	0x207c0: "\x12\v\U000207c0", // 𠟀
	0x207c1: "\x12\v\U000207c1", // 𠟁
	0x207c2: "\x12\f\U000207c2", // 𠟂
	0x207c3: "\x12\f\U000207c3", // 𠟃
	0x207c4: "\x12\f\U000207c4", // 𠟄
	0x207c5: "\x12\f\U000207c5", // 𠟅
	0x207c6: "\x12\f\U000207c6", // 𠟆
	0x207c7: "\x12\f\U000207c7", // 𠟇
	0x207c8: "\x12\f\U000207c8", // 𠟈
	0x207c9: "\x12\f\U000207c9", // 𠟉
	0x207ca: "\x12\f\U000207ca", // 𠟊
	0x207cb: "\x12\f\U000207cb", // 𠟋
	0x207cc: "\x12\f\U000207cc", // 𠟌
	0x207cd: "\x12\f\U000207cd", // 𠟍
	0x207ce: "\x12\f\U000207ce", // 𠟎
	0x207cf: "\x12\f\U000207cf", // 𠟏
	0x207d0: "\x12\f\U000207d0", // 𠟐
	0x207d1: "\x12\f\U000207d1", // 𠟑
	0x207d2: "\x12\f\U000207d2", // 𠟒
	0x207d3: "\x12\f\U000207d3", // 𠟓
	0x207d4: "\x12\f\U000207d4", // 𠟔
	0x207d5: "\x12\f\U000207d5", // 𠟕
	0x207d6: "\x12\f\U000207d6", // 𠟖
	0x207d7: "\x12\f\U000207d7", // 𠟗
	0x207d8: "\x12\f\U000207d8", // 𠟘
	0x207d9: "\x12\f\U000207d9", // 𠟙
	0x207da: "\x12\f\U000207da", // 𠟚
	0x207db: "\x12\f\U000207db", // 𠟛
	0x207dc: "\x12\f\U000207dc", // 𠟜
	0x207dd: "\x12\f\U000207dd", // 𠟝
	0x207de: "\x12\f\U000207de", // 𠟞
	0x207df: "\x12\f\U000207df", // 𠟟
	0x207e0: "\x12\r\U000207e0", // 𠟠
	0x207e1: "\x12\f\U000207e1", // 𠟡
	0x207e2: "\x12\f\U000207e2", // 𠟢
	0x207e3: "\x12\f\U000207e3", // 𠟣
	0x207e4: "\x12\f\U000207e4", // 𠟤
	0x207e5: "\x12\f\U000207e5", // 𠟥
	0x207e6: "\x12\r\U000207e6", // 𠟦
	0x207e7: "\x12\r\U000207e7", // 𠟧
	0x207e8: "\x12\r\U000207e8", // 𠟨
	0x207e9: "\x12\r\U000207e9", // 𠟩
	0x207ea: "\x12\r\U000207ea", // 𠟪
	0x207eb: "\x12\r\U000207eb", // 𠟫
	0x207ec: "\x12\r\U000207ec", // 𠟬
	0x207ed: "\x12\r\U000207ed", // 𠟭
	0x207ee: "\x12\r\U000207ee", // 𠟮
	0x207ef: "\x12\r\U000207ef", // 𠟯
	0x207f0: "\x12\r\U000207f0", // 𠟰
	0x207f1: "\x12\r\U000207f1", // 𠟱
	0x207f2: "\x12\r\U000207f2", // 𠟲
	0x207f3: "\x12\r\U000207f3", // 𠟳
	0x207f4: "\x12\r\U000207f4", // 𠟴
	0x207f5: "\x12\r\U000207f5", // 𠟵
	0x207f6: "\x12\r\U000207f6", // 𠟶
	0x207f7: "\x12\r\U000207f7", // 𠟷
	0x207f8: "\x12\r\U000207f8", // 𠟸
	0x207f9: "\x12\r\U000207f9", // 𠟹
	0x207fa: "\x12\x0e\U000207fa", // 𠟺
	0x207fb: "\x12\x0e\U000207fb", // 𠟻
	0x207fc: "\x12\x0e\U000207fc", // 𠟼
	0x207fd: "\x12\x0e\U000207fd", // 𠟽
	0x207fe: "\x12\x0e\U000207fe", // 𠟾
	0x207ff: "\x12\x0e\U000207ff", // 𠟿
	0x20800: "\x12\x0e\U00020800", // 𠠀
	0x20801: "\x12\x0e\U00020801", // 𠠁
	0x20802: "\x12\x0e\U00020802", // 𠠂
	0x20803: "\x12\x0e\U00020803", // 𠠃
	0x20804: "\x12\x0e\U00020804", // 𠠄
	0x20805: "\x12\x0e\U00020805", // 𠠅
	0x20806: "\x12\x0e\U00020806", // 𠠆
	0x20807: "\x12\x0e\U00020807", // 𠠇
	0x20808: "\x12\x0e\U00020808", // 𠠈
	0x20809: "\x12\x0e\U00020809", // 𠠉
	0x2080a: "\x12\x0e\U0002080a", // 𠠊
	0x2080b: "\x9a\t\U0002080b", // 𠠋
	0x2080c: "\x12\x0f\U0002080c", // 𠠌
	0x2080d: "\x12\x0f\U0002080d", // 𠠍
	0x2080e: "\x12\x0f\U0002080e", // 𠠎
	0x2080f: "\x12\x0f\U0002080f", // 𠠏
	0x20810: "\x12\x0f\U00020810", // 𠠐
	0x20811: "\x12\x0f\U00020811", // 𠠑
	0x20812: "\x12\x0f\U00020812", // 𠠒
	0x20813: "\x12\x0f\U00020813", // 𠠓
	0x20814: "\x12\x0f\U00020814", // 𠠔
	0x20815: "\x12\x0f\U00020815", // 𠠕
	0x20816: "\x12\x0f\U00020816", // 𠠖
	0x20817: "\x12\x0f\U00020817", // 𠠗
	0x20818: "\x12\x0f\U00020818", // 𠠘
	0x20819: "\x12\x0f\U00020819", // 𠠙
	0x2081a: "\x12\x0f\U0002081a", // 𠠚
	0x2081b: "\x12\x10\U0002081b", // 𠠛
	0x2081c: "\x12\x10\U0002081c", // 𠠜
	0x2081d: "\x12\x10\U0002081d", // 𠠝
	0x2081e: "\x12\x10\U0002081e", // 𠠞
	0x2081f: "\x12\x10\U0002081f", // 𠠟
	0x20820: "\x12\x10\U00020820", // 𠠠
	0x20821: "\x12\x11\U00020821", // 𠠡
	0x20822: "\x12\x11\U00020822", // 𠠢
	0x20823: "\x12\x11\U00020823", // 𠠣
	0x20824: "\x12\x12\U00020824", // 𠠤
	0x20825: "\x12\x13\U00020825", // 𠠥
	0x20826: "\x12\x12\U00020826", // 𠠦
	0x20827: "\x12\x12\U00020827", // 𠠧
	0x20828: "\x12\x12\U00020828", // 𠠨
	0x20829: "\x12\x12\U00020829", // 𠠩
	0x2082a: "\x12\x13\U0002082a", // 𠠪
	0x2082b: "\x12\x13\U0002082b", // 𠠫
	0x2082c: "\x12\x13\U0002082c", // 𠠬
	0x2082d: "\x12\x13\U0002082d", // 𠠭
	0x2082e: "\x12\x15\U0002082e", // 𠠮
	0x2082f: "\x12\x16\U0002082f", // 𠠯
	0x20830: "\x12\x18\U00020830", // 𠠰
	0x20831: "\x12\x18\U00020831", // 𠠱
	0x20832: "\x13\x01\U00020832", // 𠠲
	0x20833: "\x13\x02\U00020833", // 𠠳
	0x20834: "\x13\x02\U00020834", // 𠠴
	0x20835: "\x13\x02\U00020835", // 𠠵
	0x20836: "\x13\x03\U00020836", // 𠠶
	0x20837: "\x13\x03\U00020837", // 𠠷
	0x20838: "\x13\x03\U00020838", // 𠠸
	0x20839: "\x13\x04\U00020839", // 𠠹
	0x2083a: "\x13\x04\U0002083a", // 𠠺
	0x2083b: "\x13\x04\U0002083b", // 𠠻
	0x2083c: "\x13\x04\U0002083c", // 𠠼
	0x2083d: "\x13\x04\U0002083d", // 𠠽
	0x2083e: "\x13\x04\U0002083e", // 𠠾
	0x2083f: "\x13\x04\U0002083f", // 𠠿
	0x20840: "\x13\x04\U00020840", // 𠡀
	0x20841: "\x13\x04\U00020841", // 𠡁
	0x20842: "\x13\x05\U00020842", // 𠡂
	0x20843: "\x13\x05\U00020843", // 𠡃
	0x20844: "\x13\x05\U00020844", // 𠡄
	0x20845: "\x13\x05\U00020845", // 𠡅
	0x20846: "\x13\x05\U00020846", // 𠡆
	0x20847: "\x13\x05\U00020847", // 𠡇
	0x20848: "\x13\x05\U00020848", // 𠡈
	0x20849: "\x13\x05\U00020849", // 𠡉
	0x2084a: "\x13\x05\U0002084a", // 𠡊
	0x2084b: "\x13\x05\U0002084b", // 𠡋
	0x2084c: "\x13\x05\U0002084c", // 𠡌
	0x2084d: "\x13\x05\U0002084d", // 𠡍
	0x2084e: "\x13\x05\U0002084e", // 𠡎
	0x2084f: "\x13\x05\U0002084f", // 𠡏
	0x20850: "\x13\x05\U00020850", // 𠡐
	0x20851: "\x13\x06\U00020851", // 𠡑
	0x20852: "\x13\x06\U00020852", // 𠡒
	0x20853: "\x13\x06\U00020853", // 𠡓
	0x20854: "\x13\x06\U00020854", // 𠡔
	0x20855: "\x13\x06\U00020855", // 𠡕
	0x20856: "\x13\x06\U00020856", // 𠡖
	0x20857: "\x13\x06\U00020857", // 𠡗
	0x20858: "\x13\x06\U00020858", // 𠡘
	0x20859: "\x13\x06\U00020859", // 𠡙
	0x2085a: "\x13\x06\U0002085a", // 𠡚
	0x2085b: "\x13\x06\U0002085b", // 𠡛
	0x2085c: "\x13\x06\U0002085c", // 𠡜
	0x2085d: "\x13\x06\U0002085d", // 𠡝
	0x2085e: "\x13\a\U0002085e", // 𠡞
	0x2085f: "\x13\a\U0002085f", // 𠡟
	0x20860: "\x13\a\U00020860", // 𠡠
	0x20861: "\x13\a\U00020861", // 𠡡
	0x20862: "\x13\a\U00020862", // 𠡢
	0x20863: "\x13\a\U00020863", // 𠡣
	0x20864: "\x13\a\U00020864", // 𠡤
	0x20865: "\x13\a\U00020865", // 𠡥
	0x20866: "\x13\a\U00020866", // 𠡦
	0x20867: "\x13\a\U00020867", // 𠡧
	0x20868: "\x13\a\U00020868", // 𠡨
	0x20869: "\x13\a\U00020869", // 𠡩
	0x2086a: "\x13\a\U0002086a", // 𠡪
	0x2086b: "\x13\b\U0002086b", // 𠡫
	0x2086c: "\x13\b\U0002086c", // 𠡬
	0x2086d: "\x13\b\U0002086d", // 𠡭
	0x2086e: "\x13\b\U0002086e", // 𠡮
	0x2086f: "\x13\b\U0002086f", // 𠡯
	0x20870: "\x13\b\U00020870", // 𠡰
	0x20871: "\x13\b\U00020871", // 𠡱
	0x20872: "\x13\b\U00020872", // 𠡲
	0x20873: "\x13\b\U00020873", // 𠡳
	0x20874: "\x13\b\U00020874", // 𠡴
	0x20875: "\x13\b\U00020875", // 𠡵
	0x20876: "\x13\b\U00020876", // 𠡶
	0x20877: "\x13\b\U00020877", // 𠡷
	0x20878: "\x13\b\U00020878", // 𠡸
	0x20879: "\x13\b\U00020879", // 𠡹
	0x2087a: "\x13\b\U0002087a", // 𠡺
	0x2087b: "\x13\t\U0002087b", // 𠡻
	0x2087c: "\x13\t\U0002087c", // 𠡼
	0x2087d: "\x13\t\U0002087d", // 𠡽
	0x2087e: "\x13\t\U0002087e", // 𠡾
	0x2087f: "\x13\t\U0002087f", // 𠡿
	0x20880: "\x13\t\U00020880", // 𠢀
	0x20881: "\x13\t\U00020881", // 𠢁
	0x20882: "\x13\t\U00020882", // 𠢂
	0x20883: "\x13\t\U00020883", // 𠢃
	0x20884: "\x13\t\U00020884", // 𠢄
	0x20885: "\x13\n\U00020885", // 𠢅
	0x20886: "\x13\n\U00020886", // 𠢆
	0x20887: "\x13\n\U00020887", // 𠢇
	0x20888: "\x13\n\U00020888", // 𠢈
	0x20889: "\x13\n\U00020889", // 𠢉
	0x2088a: "\x13\n\U0002088a", // 𠢊
	0x2088b: "\x13\n\U0002088b", // 𠢋
	0x2088c: "\x13\n\U0002088c", // 𠢌
	0x2088d: "\x13\n\U0002088d", // 𠢍
	0x2088e: "\x13\n\U0002088e", // 𠢎
	0x2088f: "\x13\n\U0002088f", // 𠢏
	0x20890: "\x13\n\U00020890", // 𠢐
	0x20891: "\x13\n\U00020891", // 𠢑
	0x20892: "\x13\n\U00020892", // 𠢒
	0x20893: "\x13\v\U00020893", // 𠢓
	0x20894: "\x13\v\U00020894", // 𠢔
	0x20895: "\x13\v\U00020895", // 𠢕
	0x20896: "\x13\v\U00020896", // 𠢖
	0x20897: "\x13\v\U00020897", // 𠢗
	0x20898: "\x13\v\U00020898", // 𠢘
	0x20899: "\x13\v\U00020899", // 𠢙
	0x2089a: "\x13\v\U0002089a", // 𠢚
	0x2089b: "\x13\v\U0002089b", // 𠢛
	0x2089c: "\x13\v\U0002089c", // 𠢜
	0x2089d: "\x13\v\U0002089d", // 𠢝
	0x2089e: "\x13\v\U0002089e", // 𠢞
	0x2089f: "\x13\v\U0002089f", // 𠢟
	0x208a0: "\x13\f\U000208a0", // 𠢠
	0x208a1: "\x13\f\U000208a1", // 𠢡
	0x208a2: "\x13\f\U000208a2", // 𠢢
	0x208a3: "\x13\f\U000208a3", // 𠢣
	0x208a4: "\x13\f\U000208a4", // 𠢤
	0x208a5: "\x13\f\U000208a5", // 𠢥
	0x208a6: "\x13\f\U000208a6", // 𠢦
	0x208a7: "\x13\f\U000208a7", // 𠢧
	0x208a8: "\x13\f\U000208a8", // 𠢨
	0x208a9: "\x13\f\U000208a9", // 𠢩
	0x208aa: "\x13\f\U000208aa", // 𠢪
	0x208ab: "\x13\f\U000208ab", // 𠢫
	0x208ac: "\x13\f\U000208ac", // 𠢬
	0x208ad: "\x13\f\U000208ad", // 𠢭
	0x208ae: "\x13\f\U000208ae", // 𠢮
	0x208af: "\x13\f\U000208af", // 𠢯
	0x208b0: "\x13\r\U000208b0", // 𠢰
	0x208b1: "\x13\r\U000208b1", // 𠢱
	0x208b2: "\x13\r\U000208b2", // 𠢲
	0x208b3: "\x13\r\U000208b3", // 𠢳
	0x208b4: "\x13\r\U000208b4", // 𠢴
	0x208b5: "\x13\r\U000208b5", // 𠢵
	0x208b6: "\x13\x0e\U000208b6", // 𠢶
	0x208b7: "\x13\x0e\U000208b7", // 𠢷
	0x208b8: "\x13\x0e\U000208b8", // 𠢸
	0x208b9: "\x13\x0f\U000208b9", // 𠢹
	0x208ba: "\x13\x0f\U000208ba", // 𠢺
	0x208bb: "\x13\x0f\U000208bb", // 𠢻
	0x208bc: "\x13\x0f\U000208bc", // 𠢼
	0x208bd: "\x13\x0f\U000208bd", // 𠢽
	0x208be: "\x13\x0f\U000208be", // 𠢾
	0x208bf: "\x13\x0f\U000208bf", // 𠢿
	0x208c0: "\x13\x10\U000208c0", // 𠣀
	0x208c1: "\x13\x10\U000208c1", // 𠣁
	0x208c2: "\x13\x10\U000208c2", // 𠣂
	0x208c3: "\x13\x10\U000208c3", // 𠣃
	0x208c4: "\x13\x11\U000208c4", // 𠣄
	0x208c5: "\x13\x11\U000208c5", // 𠣅
	0x208c6: "\x13\x12\U000208c6", // 𠣆
	0x208c7: "\x13\x13\U000208c7", // 𠣇
	0x208c8: "\x13\x15\U000208c8", // 𠣈
	0x208c9: "\x13\x15\U000208c9", // 𠣉
	0x208ca: "\x13\x17\U000208ca", // 𠣊
	0x208cb: "\x13 \U000208cb", // 𠣋
	0x208cc: "\x14\x02\U000208cc", // 𠣌
	0x208cd: "\x14\x03\U000208cd", // 𠣍
	0x208ce: "\x14\x03\U000208ce", // 𠣎
	0x208cf: "\x14\x03\U000208cf", // 𠣏
	0x208d0: "\x14\x03\U000208d0", // 𠣐
	0x208d1: "\x14\x04\U000208d1", // 𠣑
	0x208d2: "\x14\x04\U000208d2", // 𠣒
	0x208d3: "\x14\x04\U000208d3", // 𠣓
	0x208d4: "\x14\x05\U000208d4", // 𠣔
	0x208d5: "\x14\x05\U000208d5", // 𠣕
	0x208d6: "\x14\x05\U000208d6", // 𠣖
	0x208d7: "\x14\x05\U000208d7", // 𠣗
	0x208d8: "\x14\x06\U000208d8", // 𠣘
	0x208d9: "\x14\x06\U000208d9", // 𠣙
	0x208da: "\x14\x06\U000208da", // 𠣚
	0x208db: "\x14\x06\U000208db", // 𠣛
	0x208dc: "\x14\x06\U000208dc", // 𠣜
	0x208dd: "\x14\x06\U000208dd", // 𠣝
	0x208de: "\x14\a\U000208de", // 𠣞
	0x208df: "\x14\a\U000208df", // 𠣟
	0x208e0: "\x14\a\U000208e0", // 𠣠
	0x208e1: "\x14\a\U000208e1", // 𠣡
	0x208e2: "\x14\a\U000208e2", // 𠣢
	0x208e3: "\x14\a\U000208e3", // 𠣣
	0x208e4: "\x14\b\U000208e4", // 𠣤
	0x208e5: "\x14\b\U000208e5", // 𠣥
	0x208e6: "\x14\b\U000208e6", // 𠣦
	0x208e7: "\x14\b\U000208e7", // 𠣧
	0x208e8: "\x14\b\U000208e8", // 𠣨
	0x208e9: "\x14\b\U000208e9", // 𠣩
	0x208ea: "\x14\b\U000208ea", // 𠣪
	0x208eb: "\x14\b\U000208eb", // 𠣫
	0x208ec: "\x14\b\U000208ec", // 𠣬
	0x208ed: "\x14\b\U000208ed", // 𠣭
	0x208ee: "\x14\t\U000208ee", // 𠣮
	0x208ef: "\x14\t\U000208ef", // 𠣯
	0x208f0: "\x14\t\U000208f0", // 𠣰
	0x208f1: "\x14\t\U000208f1", // 𠣱
	0x208f2: "\x14\t\U000208f2", // 𠣲
	0x208f3: "\x14\t\U000208f3", // 𠣳
	0x208f4: "\x14\t\U000208f4", // 𠣴
	0x208f5: "\x14\n\U000208f5", // 𠣵
	0x208f6: "\x14\n\U000208f6", // 𠣶
	0x208f7: "\x14\n\U000208f7", // 𠣷
	0x208f8: "\x14\v\U000208f8", // 𠣸
	0x208f9: "\x14\v\U000208f9", // 𠣹
	0x208fa: "\x14\v\U000208fa", // 𠣺
	0x208fb: "\x14\v\U000208fb", // 𠣻
	0x208fc: "\x14\v\U000208fc", // 𠣼
	0x208fd: "\x14\f\U000208fd", // 𠣽
	0x208fe: "\x14\f\U000208fe", // 𠣾
	0x208ff: "\x14\f\U000208ff", // 𠣿
	0x20900: "\x14\f\U00020900", // 𠤀
	0x20901: "\x14\f\U00020901", // 𠤁
	0x20902: "\x14\f\U00020902", // 𠤂
	0x20903: "\x14\r\U00020903", // 𠤃
	0x20904: "\x14\x0e\U00020904", // 𠤄
	0x20905: "\x14\x0e\U00020905", // 𠤅
	0x20906: "\x14\x0e\U00020906", // 𠤆
	0x20907: "\x14\x0e\U00020907", // 𠤇
	0x20908: "\x14\x0f\U00020908", // 𠤈
	0x20909: "\x14\x0f\U00020909", // 𠤉
	0x2090a: "\x14\x0f\U0002090a", // 𠤊
	0x2090b: "\x14\x12\U0002090b", // 𠤋
	0x2090c: "\x14\x12\U0002090c", // 𠤌
	0x2090d: "\x14\x12\U0002090d", // 𠤍
	0x2090e: "\x15\x00\U0002090e", // 𠤎
	0x2090f: "\x15\x02\U0002090f", // 𠤏
	0x20910: "\x15\x03\U00020910", // 𠤐
	0x20911: "\x15\x05\U00020911", // 𠤑
	0x20912: "\x15\x05\U00020912", // 𠤒
	0x20913: "\x15\x05\U00020913", // 𠤓
	0x20914: "\x15\x05\U00020914", // 𠤔
	0x20915: "\x15\x05\U00020915", // 𠤕
	0x20916: "\x15\x06\U00020916", // 𠤖
	0x20917: "\x15\a\U00020917", // 𠤗
	0x20918: "\x15\a\U00020918", // 𠤘
	0x20919: "\x15\a\U00020919", // 𠤙
	0x2091a: "\x15\a\U0002091a", // 𠤚
	0x2091b: "\x15\a\U0002091b", // 𠤛
	0x2091c: "\x15\a\U0002091c", // 𠤜
	0x2091d: "\x15\a\U0002091d", // 𠤝
	0x2091e: "\x15\b\U0002091e", // 𠤞
	0x2091f: "\x15\b\U0002091f", // 𠤟
	0x20920: "\x15\b\U00020920", // 𠤠
	0x20921: "\x15\b\U00020921", // 𠤡
	0x20922: "\x01\t\U00020922", // 𠤢
	0x20923: "\x15\n\U00020923", // 𠤣
	0x20924: "\x15\n\U00020924", // 𠤤
	0x20925: "\x15\v\U00020925", // 𠤥
	0x20926: "\x15\f\U00020926", // 𠤦
	0x20927: "\x15\f\U00020927", // 𠤧
	0x20928: "\x15\f\U00020928", // 𠤨
	0x20929: "\x15\x0f\U00020929", // 𠤩
	0x2092a: "\x15\x10\U0002092a", // 𠤪
	0x2092b: "\x86\r\U0002092b", // 𠤫
	0x2092c: "\x16\x00\U0002092c", // 𠤬
	0x2092d: "\x16\x02\U0002092d", // 𠤭
	0x2092e: "\x16\x04\U0002092e", // 𠤮
	0x2092f: "\x16\x04\U0002092f", // 𠤯
	0x20930: "\x16\x04\U00020930", // 𠤰
	0x20931: "\x16\x04\U00020931", // 𠤱
	0x20932: "\x17\x04\U00020932", // 𠤲
	0x20933: "\x16\x05\U00020933", // 𠤳
	0x20934: "\x16\x05\U00020934", // 𠤴
	0x20935: "\x16\x05\U00020935", // 𠤵
	0x20936: "\x16\x05\U00020936", // 𠤶
	0x20937: "\x16\x05\U00020937", // 𠤷
	0x20938: "\x16\x06\U00020938", // 𠤸
	0x20939: "\x16\x06\U00020939", // 𠤹
	0x2093a: "\x16\x06\U0002093a", // 𠤺
	0x2093b: "\x16\x06\U0002093b", // 𠤻
	0x2093c: "\x16\a\U0002093c", // 𠤼
	0x2093d: "\x16\a\U0002093d", // 𠤽
	0x2093e: "\x16\a\U0002093e", // 𠤾
	0x2093f: "\x16\a\U0002093f", // 𠤿
	0x20940: "\x16\a\U00020940", // 𠥀
	0x20941: "\x16\a\U00020941", // 𠥁
	0x20942: "\x16\a\U00020942", // 𠥂
	0x20943: "\x17\a\U00020943", // 𠥃
	0x20944: "\x16\a\U00020944", // 𠥄
	0x20945: "\x16\a\U00020945", // 𠥅
	0x20946: "\x16\a\U00020946", // 𠥆
	0x20947: "\x16\a\U00020947", // 𠥇
	0x20948: "\x16\a\U00020948", // 𠥈
	0x20949: "\x16\b\U00020949", // 𠥉
	0x2094a: "\x16\b\U0002094a", // 𠥊
	0x2094b: "\x16\b\U0002094b", // 𠥋
	0x2094c: "\x16\b\U0002094c", // 𠥌
	0x2094d: "\x16\b\U0002094d", // 𠥍
	0x2094e: "\x16\t\U0002094e", // 𠥎
	0x2094f: "\x16\t\U0002094f", // 𠥏
	0x20950: "\x16\n\U00020950", // 𠥐
	0x20951: "\x16\n\U00020951", // 𠥑
	0x20952: "\x16\n\U00020952", // 𠥒
	0x20953: "\x16\n\U00020953", // 𠥓
	0x20954: "\x16\n\U00020954", // 𠥔
	0x20955: "\x16\n\U00020955", // 𠥕
	0x20956: "\x16\v\U00020956", // 𠥖
	0x20957: "\x16\v\U00020957", // 𠥗
	0x20958: "\x16\v\U00020958", // 𠥘
	0x20959: "\x16\f\U00020959", // 𠥙
	0x2095a: "\x16\f\U0002095a", // 𠥚
	0x2095b: "\x16\f\U0002095b", // 𠥛
	0x2095c: "\x16\r\U0002095c", // 𠥜
	0x2095d: "\x16\r\U0002095d", // 𠥝
	0x2095e: "\x16\r\U0002095e", // 𠥞
	0x2095f: "\x16\r\U0002095f", // 𠥟
	0x20960: "\x16\r\U00020960", // 𠥠
	0x20961: "\x16\r\U00020961", // 𠥡
	0x20962: "\x16\x0e\U00020962", // 𠥢
	0x20963: "\x16\x0e\U00020963", // 𠥣
	0x20964: "\x16\x10\U00020964", // 𠥤
	0x20965: "\x16\x10\U00020965", // 𠥥
	0x20966: "\x16\x11\U00020966", // 𠥦
	0x20967: "\x16\x11\U00020967", // 𠥧
	0x20968: "\x16\x12\U00020968", // 𠥨
	0x20969: "\x16\x12\U00020969", // 𠥩
	0x2096a: "\x16\x14\U0002096a", // 𠥪
	0x2096b: "\x16\x18\U0002096b", // 𠥫
	0x2096c: "\x16\x1c\U0002096c", // 𠥬
	0x2096d: "\x17\x02\U0002096d", // 𠥭
	0x2096e: "\x17\x04\U0002096e", // 𠥮
	0x2096f: "\x17\x04\U0002096f", // 𠥯
	0x20970: "\x17\x05\U00020970", // 𠥰
	0x20971: "\x17\x05\U00020971", // 𠥱
	0x20972: "\x17\x05\U00020972", // 𠥲
	0x20973: "\x17\x06\U00020973", // 𠥳
	0x20974: "\x17\a\U00020974", // 𠥴
	0x20975: "\x17\a\U00020975", // 𠥵
	0x20976: "\x17\b\U00020976", // 𠥶
	0x20977: "\x17\f\U00020977", // 𠥷
	0x20978: "\x17\x12\U00020978", // 𠥸
	0x20979: "\x17\x14\U00020979", // 𠥹
	0x2097a: "\x17\x14\U0002097a", // 𠥺
	0x2097b: "\x18\x02\U0002097b", // 𠥻
	0x2097c: "\x18\x02\U0002097c", // 𠥼
	0x2097d: "\x18\x03\U0002097d", // 𠥽
	0x2097e: "\x18\x03\U0002097e", // 𠥾
	0x2097f: "\x18\x02\U0002097f", // 𠥿
	0x20980: "\x18\x03\U00020980", // 𠦀
	0x20981: "\x18\x03\U00020981", // 𠦁
	0x20982: "\x18\x04\U00020982", // 𠦂
	0x20983: "\x18\x04\U00020983", // 𠦃
	0x20984: "\x18\x04\U00020984", // 𠦄
	0x20985: "\x18\x04\U00020985", // 𠦅
	0x20986: "\x18\x04\U00020986", // 𠦆
	0x20987: "\x18\x04\U00020987", // 𠦇
	0x20988: "\x18\x04\U00020988", // 𠦈
	0x20989: "\x18\x04\U00020989", // 𠦉
	0x2098a: "\x18\x04\U0002098a", // 𠦊
	0x2098b: "\x18\x04\U0002098b", // 𠦋
	0x2098c: "\x18\x04\U0002098c", // 𠦌
	0x2098d: "\x18\x04\U0002098d", // 𠦍
	0x2098e: "\x18\x04\U0002098e", // 𠦎
	0x2098f: "\x18\x04\U0002098f", // 𠦏
	0x20990: "\x18\x04\U00020990", // 𠦐
	0x20991: "\x18\x05\U00020991", // 𠦑
	0x20992: "\x18\x05\U00020992", // 𠦒
	0x20993: "\x18\x05\U00020993", // 𠦓
	0x20994: "\x18\x05\U00020994", // 𠦔
	0x20995: "\x18\x05\U00020995", // 𠦕
	0x20996: "\x18\x05\U00020996", // 𠦖
	0x20997: "\x18\x05\U00020997", // 𠦗
	0x20998: "\x18\x06\U00020998", // 𠦘
	0x20999: "\x18\x06\U00020999", // 𠦙
	0x2099a: "\x18\x06\U0002099a", // 𠦚
	0x2099b: "\x18\x06\U0002099b", // 𠦛
	0x2099c: "\x18\x06\U0002099c", // 𠦜
	0x2099d: "\x18\x06\U0002099d", // 𠦝
	0x2099e: "\x18\x06\U0002099e", // 𠦞
	0x2099f: "\x18\x06\U0002099f", // 𠦟
	0x209a0: "\x18\x06\U000209a0", // 𠦠
	0x209a1: "\x18\x06\U000209a1", // 𠦡
	0x209a2: "\x18\x06\U000209a2", // 𠦢
	0x209a3: "\x18\b\U000209a3", // 𠦣
	0x209a4: "\x18\b\U000209a4", // 𠦤
	0x209a5: "\x18\b\U000209a5", // 𠦥
	0x209a6: "\x18\b\U000209a6", // 𠦦
	0x209a7: "\x18\b\U000209a7", // 𠦧
	0x209a8: "\x18\b\U000209a8", // 𠦨
	0x209a9: "\x18\b\U000209a9", // 𠦩
	0x209aa: "\x18\t\U000209aa", // 𠦪
	0x209ab: "\x18\t\U000209ab", // 𠦫
	0x209ac: "\x18\t\U000209ac", // 𠦬
	0x209ad: "\x18\t\U000209ad", // 𠦭
	0x209ae: "\x18\t\U000209ae", // 𠦮
	0x209af: "\x18\t\U000209af", // 𠦯
	0x209b0: "\x18\n\U000209b0", // 𠦰
	0x209b1: "\x18\n\U000209b1", // 𠦱
	0x209b2: "\x18\n\U000209b2", // 𠦲
	0x209b3: "\x18\n\U000209b3", // 𠦳
	0x209b4: "\x18\v\U000209b4", // 𠦴
	0x209b5: "\x18\v\U000209b5", // 𠦵
	0x209b6: "\x18\v\U000209b6", // 𠦶
	0x209b7: "\x18\v\U000209b7", // 𠦷
	0x209b8: "\x18\v\U000209b8", // 𠦸
	0x209b9: "\x18\v\U000209b9", // 𠦹
	0x209ba: "\x18\v\U000209ba", // 𠦺
	0x209bb: "\x18\v\U000209bb", // 𠦻
	0x209bc: "\x18\v\U000209bc", // 𠦼
	0x209bd: "\x18\f\U000209bd", // 𠦽
	0x209be: "\x18\f\U000209be", // 𠦾
	0x209bf: "\x18\f\U000209bf", // 𠦿
	0x209c0: "\x18\r\U000209c0", // 𠧀
	0x209c1: "\x18\r\U000209c1", // 𠧁
	0x209c2: "\x18\r\U000209c2", // 𠧂
	0x209c3: "\x18\r\U000209c3", // 𠧃
	0x209c4: "\x18\r\U000209c4", // 𠧄
	0x209c5: "\x18\x0f\U000209c5", // 𠧅
	0x209c6: "\x18\x0f\U000209c6", // 𠧆
	0x209c7: "\x18\x0f\U000209c7", // 𠧇
	0x209c8: "\x18\x0f\U000209c8", // 𠧈
	0x209c9: "\x18\x10\U000209c9", // 𠧉
	0x209ca: "\x18\x10\U000209ca", // 𠧊
	0x209cb: "\x18\x10\U000209cb", // 𠧋
	0x209cc: "\x18\x10\U000209cc", // 𠧌
	0x209cd: "\x18\x10\U000209cd", // 𠧍
	0x209ce: "\x18\x11\U000209ce", // 𠧎
	0x209cf: "\x18\x13\U000209cf", // 𠧏
	0x209d0: "\x18\x17\U000209d0", // 𠧐
	0x209d1: "\x18\x18\U000209d1", // 𠧑
	0x209d2: "\x19\x01\U000209d2", // 𠧒
	0x209d3: "\x19\x03\U000209d3", // 𠧓
	0x209d4: "\x19\x04\U000209d4", // 𠧔
	0x209d5: "\x19\x04\U000209d5", // 𠧕
	0x209d6: "\x19\x04\U000209d6", // 𠧖
	0x209d7: "\x19\x04\U000209d7", // 𠧗
	0x209d8: "\x19\x04\U000209d8", // 𠧘
	0x209d9: "\x19\x05\U000209d9", // 𠧙
	0x209da: "\x19\x05\U000209da", // 𠧚
	0x209db: "\x19\x05\U000209db", // 𠧛
	0x209dc: "\x19\x05\U000209dc", // 𠧜
	0x209dd: "\x05\x06\U000209dd", // 𠧝
	0x209de: "\x19\x06\U000209de", // 𠧞
	0x209df: "\x19\x06\U000209df", // 𠧟
	0x209e0: "\x19\x06\U000209e0", // 𠧠
	0x209e1: "\x19\x06\U000209e1", // 𠧡
	0x209e2: "\x19\x06\U000209e2", // 𠧢
	0x209e3: "\x19\x06\U000209e3", // 𠧣
	0x209e4: "\x19\x06\U000209e4", // 𠧤
	0x209e5: "\x19\x06\U000209e5", // 𠧥
	0x209e6: "\x19\x06\U000209e6", // 𠧦
	0x209e7: "\x19\x06\U000209e7", // 𠧧
	0x209e8: "\x19\x06\U000209e8", // 𠧨
	0x209e9: "\x19\a\U000209e9", // 𠧩
	0x209ea: "\x19\a\U000209ea", // 𠧪
	0x209eb: "\x19\a\U000209eb", // 𠧫
	0x209ec: "\x19\a\U000209ec", // 𠧬
	0x209ed: "\x19\a\U000209ed", // 𠧭
	0x209ee: "\x19\a\U000209ee", // 𠧮
	0x209ef: "\x19\a\U000209ef", // 𠧯
	0x209f0: "\x19\a\U000209f0", // 𠧰
	0x209f1: "\x19\a\U000209f1", // 𠧱
	0x209f2: "\x19\a\U000209f2", // 𠧲
	0x209f3: "\x19\b\U000209f3", // 𠧳
	0x209f4: "\x19\b\U000209f4", // 𠧴
	0x209f5: "\x19\b\U000209f5", // 𠧵
	0x209f6: "\x19\b\U000209f6", // 𠧶
	0x209f7: "\x19\b\U000209f7", // 𠧷
	0x209f8: "\xc5\x00\U000209f8", // 𠧸
	0x209f9: "\x19\b\U000209f9", // 𠧹
	0x209fa: "\x19\t\U000209fa", // 𠧺
	0x209fb: "\x19\t\U000209fb", // 𠧻
	0x209fc: "\x19\t\U000209fc", // 𠧼
	0x209fd: "\x19\t\U000209fd", // 𠧽
	0x209fe: "\x19\t\U000209fe", // 𠧾
	0x209ff: "\x19\t\U000209ff", // 𠧿
	0x20a00: "\x19\n\U00020a00", // 𠨀
	0x20a01: "\x19\n\U00020a01", // 𠨁
	0x20a02: "\x19\n\U00020a02", // 𠨂
	0x20a03: "$\t\U00020a03", // 𠨃
	0x20a04: "\x19\n\U00020a04", // 𠨄
	0x20a05: "\x19\v\U00020a05", // 𠨅
	0x20a06: "\x19\f\U00020a06", // 𠨆
	0x20a07: "\x19\f\U00020a07", // 𠨇
	0x20a08: "\x19\r\U00020a08", // 𠨈
	0x20a09: "\x19\r\U00020a09", // 𠨉
	0x20a0a: "\x19\r\U00020a0a", // 𠨊
	0x20a0b: "\x19\x19\U00020a0b", // 𠨋
	0x20a0c: "\x19\x1f\U00020a0c", // 𠨌
	0x20a0d: "\x1a\x02\U00020a0d", // 𠨍
	0x20a0e: "\x1a\x02\U00020a0e", // 𠨎
	0x20a0f: "\x1a\x02\U00020a0f", // 𠨏
	0x20a10: "\x1a\x02\U00020a10", // 𠨐
	0x20a11: "\x1a\x03\U00020a11", // 𠨑
	0x20a12: "\x1a\x04\U00020a12", // 𠨒
	0x20a13: "\x1a\x04\U00020a13", // 𠨓
	0x20a14: "\x1a\x04\U00020a14", // 𠨔
	0x20a15: "\x1a\x04\U00020a15", // 𠨕
	0x20a16: "\x1a\x04\U00020a16", // 𠨖
	0x20a17: "\x1a\x04\U00020a17", // 𠨗
	0x20a18: "\x1a\x05\U00020a18", // 𠨘
	0x20a19: "\x1a\a\U00020a19", // 𠨙
	0x20a1a: "\x1a\a\U00020a1a", // 𠨚
	0x20a1b: "\x1a\a\U00020a1b", // 𠨛
	0x20a1c: "\x1a\a\U00020a1c", // 𠨜
	0x20a1d: "\x1a\a\U00020a1d", // 𠨝
	0x20a1e: "\x1a\b\U00020a1e", // 𠨞
	0x20a1f: "\x1a\n\U00020a1f", // 𠨟
	0x20a20: "\x1a\n\U00020a20", // 𠨠
	0x20a21: "\x1a\n\U00020a21", // 𠨡
	0x20a22: "\x1a\v\U00020a22", // 𠨢
	0x20a23: "\x1a\v\U00020a23", // 𠨣
	0x20a24: "\x1a\v\U00020a24", // 𠨤
	0x20a25: "\x1a\f\U00020a25", // 𠨥
	0x20a26: "\x1a\x0f\U00020a26", // 𠨦
	0x20a27: "\x1a\x10\U00020a27", // 𠨧
	0x20a28: "\x1a\x10\U00020a28", // 𠨨
	0x20a29: "\x1a\x10\U00020a29", // 𠨩
	0x20a2a: "\x1a\x10\U00020a2a", // 𠨪
	0x20a2b: "\x1a\x18\U00020a2b", // 𠨫
	0x20a2c: "\x1b\x02\U00020a2c", // 𠨬
	0x20a2d: "\x1b\x03\U00020a2d", // 𠨭
	0x20a2e: "\x1b\x03\U00020a2e", // 𠨮
	0x20a2f: "\x1b\x03\U00020a2f", // 𠨯
	0x20a30: "\x1b\x03\U00020a30", // 𠨰
	0x20a31: "\x1b\x03\U00020a31", // 𠨱
	0x20a32: "\x1b\x03\U00020a32", // 𠨲
	0x20a33: "\x1b\x03\U00020a33", // 𠨳
	0x20a34: "\x1b\x04\U00020a34", // 𠨴
	0x20a35: "\x1b\x04\U00020a35", // 𠨵
	0x20a36: "\x1b\x04\U00020a36", // 𠨶
	0x20a37: "\x1b\x04\U00020a37", // 𠨷
	0x20a38: "\x1b\x04\U00020a38", // 𠨸
	0x20a39: "\x1b\x04\U00020a39", // 𠨹
	0x20a3a: "\x1b\x04\U00020a3a", // 𠨺
	0x20a3b: "\x1b\x04\U00020a3b", // 𠨻
	0x20a3c: "\x1b\x04\U00020a3c", // 𠨼
	0x20a3d: "\x1b\x04\U00020a3d", // 𠨽
	0x20a3e: "\x1b\x04\U00020a3e", // 𠨾
	0x20a3f: "\x1b\x04\U00020a3f", // 𠨿
	0x20a40: "\x1b\x05\U00020a40", // 𠩀
	0x20a41: "\x1b\x05\U00020a41", // 𠩁
	0x20a42: "\x1b\x05\U00020a42", // 𠩂
	0x20a43: "\x1b\x05\U00020a43", // 𠩃
	0x20a44: "\x1b\x05\U00020a44", // 𠩄
	0x20a45: "\x1b\x05\U00020a45", // 𠩅
	0x20a46: "\x1b\x05\U00020a46", // 𠩆
	0x20a47: "\x1b\x05\U00020a47", // 𠩇
	0x20a48: "\x1b\x05\U00020a48", // 𠩈
	0x20a49: "\x1b\x05\U00020a49", // 𠩉
	0x20a4a: "\x1b\x06\U00020a4a", // 𠩊
	0x20a4b: "\x1b\x06\U00020a4b", // 𠩋
	0x20a4c: "\x1b\x06\U00020a4c", // 𠩌
	0x20a4d: "\x1b\x06\U00020a4d", // 𠩍
	0x20a4e: "\x1b\x06\U00020a4e", // 𠩎
	0x20a4f: "\x1b\x06\U00020a4f", // 𠩏
	0x20a50: "\x1b\x06\U00020a50", // 𠩐
	0x20a51: "\x1b\x06\U00020a51", // 𠩑
	0x20a52: "\x1b\x06\U00020a52", // 𠩒
	0x20a53: "\x1b\x06\U00020a53", // 𠩓
	0x20a54: "\x1b\x06\U00020a54", // 𠩔
	0x20a55: "\x1b\x06\U00020a55", // 𠩕
	0x20a56: "\f\x06\U00020a56", // 𠩖
	0x20a57: "\x1b\a\U00020a57", // 𠩗
	0x20a58: "\x1b\a\U00020a58", // 𠩘
	0x20a59: "\x1b\a\U00020a59", // 𠩙
	0x20a5a: "\x1b\a\U00020a5a", // 𠩚
	0x20a5b: "\x1b\a\U00020a5b", // 𠩛
	0x20a5c: "\x1b\a\U00020a5c", // 𠩜
	0x20a5d: "\x1b\a\U00020a5d", // 𠩝
	0x20a5e: "\x1b\a\U00020a5e", // 𠩞
	0x20a5f: "\x1b\a\U00020a5f", // 𠩟
	0x20a60: "\x1b\a\U00020a60", // 𠩠
	0x20a61: "\x1b\a\U00020a61", // 𠩡
	0x20a62: "\x1b\a\U00020a62", // 𠩢
	0x20a63: "\x1b\a\U00020a63", // 𠩣
	0x20a64: "\x1b\a\U00020a64", // 𠩤
	0x20a65: "\x1b\a\U00020a65", // 𠩥
	0x20a66: "\x1b\a\U00020a66", // 𠩦
	0x20a67: "\x1b\b\U00020a67", // 𠩧
	0x20a68: "\x1b\b\U00020a68", // 𠩨
	0x20a69: "\x1b\b\U00020a69", // 𠩩
	0x20a6a: "\x1b\b\U00020a6a", // 𠩪
	0x20a6b: "\x1b\b\U00020a6b", // 𠩫
	0x20a6c: "\x1b\b\U00020a6c", // 𠩬
	0x20a6d: "\x1b\b\U00020a6d", // 𠩭
	0x20a6e: "\x1b\b\U00020a6e", // 𠩮
	0x20a6f: "\x1b\b\U00020a6f", // 𠩯
	0x20a70: "\x1b\b\U00020a70", // 𠩰
	0x20a71: "\x1b\b\U00020a71", // 𠩱
	0x20a72: "\x1b\b\U00020a72", // 𠩲
	0x20a73: "\x1b\b\U00020a73", // 𠩳
	0x20a74: "\x1b\b\U00020a74", // 𠩴
	0x20a75: "\x1b\b\U00020a75", // 𠩵
	0x20a76: "\x1b\b\U00020a76", // 𠩶
	0x20a77: "\x1b\b\U00020a77", // 𠩷
	0x20a78: "\x1b\t\U00020a78", // 𠩸
	0x20a79: "\x1b\t\U00020a79", // 𠩹
	0x20a7a: "\x1b\t\U00020a7a", // 𠩺
	0x20a7b: "\x1b\t\U00020a7b", // 𠩻
	0x20a7c: "\x1b\t\U00020a7c", // 𠩼
	0x20a7d: "\x1b\t\U00020a7d", // 𠩽
	0x20a7e: "\x1b\t\U00020a7e", // 𠩾
	0x20a7f: "\x1b\v\U00020a7f", // 𠩿
	0x20a80: "\x1b\t\U00020a80", // 𠪀
	0x20a81: "\x1b\t\U00020a81", // 𠪁
	0x20a82: "\x1b\t\U00020a82", // 𠪂
	0x20a83: "\x1b\t\U00020a83", // 𠪃
	0x20a84: "\x1b\t\U00020a84", // 𠪄
	0x20a85: "\x1b\t\U00020a85", // 𠪅
	0x20a86: "\x1b\t\U00020a86", // 𠪆
	0x20a87: "\x1b\n\U00020a87", // 𠪇
	0x20a88: "\x1b\n\U00020a88", // 𠪈
	0x20a89: "\x1b\n\U00020a89", // 𠪉
	0x20a8a: "\x1b\n\U00020a8a", // 𠪊
	0x20a8b: "\x1b\n\U00020a8b", // 𠪋
	0x20a8c: "\x1b\n\U00020a8c", // 𠪌
	0x20a8d: "\x1b\n\U00020a8d", // 𠪍
	0x20a8e: "\x1b\n\U00020a8e", // 𠪎
	0x20a8f: "\x1b\n\U00020a8f", // 𠪏
	0x20a90: "\x1b\n\U00020a90", // 𠪐
	0x20a91: "\x1b\v\U00020a91", // 𠪑
	0x20a92: "\x1b\v\U00020a92", // 𠪒
	0x20a93: "\x1b\v\U00020a93", // 𠪓
	0x20a94: "\x1b\v\U00020a94", // 𠪔
	0x20a95: "\x1b\v\U00020a95", // 𠪕
	0x20a96: "\x1b\v\U00020a96", // 𠪖
	0x20a97: "\x1b\v\U00020a97", // 𠪗
	0x20a98: "\x1b\v\U00020a98", // 𠪘
	0x20a99: "\x1b\f\U00020a99", // 𠪙
	0x20a9a: "\x1b\f\U00020a9a", // 𠪚
	0x20a9b: "\x1b\f\U00020a9b", // 𠪛
	0x20a9c: "\x1b\f\U00020a9c", // 𠪜
	0x20a9d: "\x1b\f\U00020a9d", // 𠪝
	0x20a9e: "\x1b\f\U00020a9e", // 𠪞
	0x20a9f: "\x1b\f\U00020a9f", // 𠪟
	0x20aa0: "\x1b\f\U00020aa0", // 𠪠
	0x20aa1: "\x1b\f\U00020aa1", // 𠪡
	0x20aa2: "\x1b\f\U00020aa2", // 𠪢
	0x20aa3: "\x1b\f\U00020aa3", // 𠪣
	0x20aa4: "\x1b\f\U00020aa4", // 𠪤
	0x20aa5: "\x1b\f\U00020aa5", // 𠪥
	0x20aa6: "\x1b\f\U00020aa6", // 𠪦
	0x20aa7: "\x1b\f\U00020aa7", // 𠪧
	0x20aa8: "\x1b\f\U00020aa8", // 𠪨
	0x20aa9: "\x1b\f\U00020aa9", // 𠪩
	0x20aaa: "\x1b\f\U00020aaa", // 𠪪
	0x20aab: "\x1b\f\U00020aab", // 𠪫
	0x20aac: "\x1b\f\U00020aac", // 𠪬
	0x20aad: "\x1b\r\U00020aad", // 𠪭
	0x20aae: "\x1b\r\U00020aae", // 𠪮
	0x20aaf: "\x1b\r\U00020aaf", // 𠪯
	0x20ab0: "\x1b\r\U00020ab0", // 𠪰
	0x20ab1: "\x1b\r\U00020ab1", // 𠪱
	0x20ab2: "\x1b\r\U00020ab2", // 𠪲
	0x20ab3: "\x1b\r\U00020ab3", // 𠪳
	0x20ab4: "\x1b\r\U00020ab4", // 𠪴
	0x20ab5: "\x1b\r\U00020ab5", // 𠪵
	0x20ab6: "\x1b\r\U00020ab6", // 𠪶
	0x20ab7: "\x1b\r\U00020ab7", // 𠪷
	0x20ab8: "\x1b\r\U00020ab8", // 𠪸
	0x20ab9: "b\n\U00020ab9", // 𠪹
	0x20aba: "\x1b\x0e\U00020aba", // 𠪺
	0x20abb: "\x1b\x0e\U00020abb", // 𠪻
	0x20abc: "\x1b\x0e\U00020abc", // 𠪼
	0x20abd: "\x1b\x0e\U00020abd", // 𠪽
	0x20abe: "\x1b\x0e\U00020abe", // 𠪾
	0x20abf: "\x1b\x0f\U00020abf", // 𠪿
	0x20ac0: "\x1b\x10\U00020ac0", // 𠫀
	0x20ac1: "\x1b\x10\U00020ac1", // 𠫁
	0x20ac2: "\x1b\x10\U00020ac2", // 𠫂
	0x20ac3: "\x1b\x10\U00020ac3", // 𠫃
	0x20ac4: "\x1b\x10\U00020ac4", // 𠫄
	0x20ac5: "\x1b\x10\U00020ac5", // 𠫅
	0x20ac6: "\x1b\x10\U00020ac6", // 𠫆
	0x20ac7: "\x1b\x12\U00020ac7", // 𠫇
	0x20ac8: "R\x10\U00020ac8", // 𠫈
	0x20ac9: "\x1b\x13\U00020ac9", // 𠫉
	0x20aca: "\x1b\x13\U00020aca", // 𠫊
	0x20acb: "\x1b\x14\U00020acb", // 𠫋
	0x20acc: "\x1b\x15\U00020acc", // 𠫌
	0x20acd: "\x1b\x15\U00020acd", // 𠫍
	0x20ace: "\x1b\x15\U00020ace", // 𠫎
	0x20acf: "\x1b\x16\U00020acf", // 𠫏
	0x20ad0: "\x1b\x1b\U00020ad0", // 𠫐
	0x20ad1: "\x1b\x1e\U00020ad1", // 𠫑
	0x20ad2: "\x1b\x1f\U00020ad2", // 𠫒
	0x20ad3: "\x1c\x01\U00020ad3", // 𠫓
	0x20ad4: "\x1c\x01\U00020ad4", // 𠫔
	0x20ad5: "\x1c\x01\U00020ad5", // 𠫕
	0x20ad6: "\x1c\x01\U00020ad6", // 𠫖
	0x20ad7: "\x1c\x02\U00020ad7", // 𠫗
	0x20ad8: "\x1c\x02\U00020ad8", // 𠫘
	0x20ad9: "\x1c\x03\U00020ad9", // 𠫙
	0x20ada: "\x1c\x03\U00020ada", // 𠫚
	0x20adb: "\x1c\x03\U00020adb", // 𠫛
	0x20adc: "\x1c\x03\U00020adc", // 𠫜
	0x20add: "\x1c\x03\U00020add", // 𠫝
	0x20ade: "\x1c\x04\U00020ade", // 𠫞
	0x20adf: "\x1c\x04\U00020adf", // 𠫟
	0x20ae0: "\x1c\x04\U00020ae0", // 𠫠
	0x20ae1: "\x1c\x04\U00020ae1", // 𠫡
	0x20ae2: "\x1c\x04\U00020ae2", // 𠫢
	0x20ae3: "\x1c\x04\U00020ae3", // 𠫣
	0x20ae4: "\x1c\x04\U00020ae4", // 𠫤
	0x20ae5: "\x1c\x04\U00020ae5", // 𠫥
	0x20ae6: "\x1c\x05\U00020ae6", // 𠫦
	0x20ae7: "\x1c\x05\U00020ae7", // 𠫧
	0x20ae8: "\x1c\x05\U00020ae8", // 𠫨
	0x20ae9: "\x1c\x06\U00020ae9", // 𠫩
	0x20aea: "\x1c\x06\U00020aea", // 𠫪
	0x20aeb: "\x1c\x06\U00020aeb", // 𠫫
	0x20aec: "\x1c\x06\U00020aec", // 𠫬
	0x20aed: "\x1c\x06\U00020aed", // 𠫭
	0x20aee: "\x10\x06\U00020aee", // 𠫮
	0x20aef: "\x1c\x06\U00020aef", // 𠫯
	0x20af0: "\x1c\a\U00020af0", // 𠫰
	0x20af1: "\x1c\a\U00020af1", // 𠫱
	0x20af2: "\x1c\a\U00020af2", // 𠫲
	0x20af3: "\x1d\a\U00020af3", // 𠫳
	0x20af4: "\x1c\a\U00020af4", // 𠫴
	0x20af5: "\x1c\a\U00020af5", // 𠫵
	0x20af6: "\x1c\a\U00020af6", // 𠫶
	0x20af7: "\x1c\a\U00020af7", // 𠫷
	0x20af8: "\x1c\a\U00020af8", // 𠫸
	0x20af9: "\x1c\b\U00020af9", // 𠫹
	0x20afa: "\x1c\b\U00020afa", // 𠫺
	0x20afb: "\x1c\b\U00020afb", // 𠫻
	0x20afc: "\x1c\b\U00020afc", // 𠫼
	0x20afd: "\x1c\t\U00020afd", // 𠫽
	0x20afe: "\x1c\t\U00020afe", // 𠫾
	0x20aff: "\x1c\n\U00020aff", // 𠫿
	0x20b00: "\x1c\n\U00020b00", // 𠬀
	0x20b01: "\x1c\n\U00020b01", // 𠬁
	0x20b02: "\x1c\n\U00020b02", // 𠬂
	0x20b03: "\x1c\n\U00020b03", // 𠬃
	0x20b04: "\x1c\n\U00020b04", // 𠬄
	0x20b05: "\x1c\n\U00020b05", // 𠬅
	0x20b06: "\x1c\v\U00020b06", // 𠬆
	0x20b07: "\x1c\v\U00020b07", // 𠬇
	0x20b08: "\x1c\v\U00020b08", // 𠬈
	0x20b09: "\x1c\v\U00020b09", // 𠬉
	0x20b0a: "\x1c\v\U00020b0a", // 𠬊
	0x20b0b: "\x1c\v\U00020b0b", // 𠬋
	0x20b0c: "\x1c\v\U00020b0c", // 𠬌
	0x20b0d: "\x1c\f\U00020b0d", // 𠬍
	0x20b0e: "\x1c\f\U00020b0e", // 𠬎
	0x20b0f: "\x1c\f\U00020b0f", // 𠬏
	0x20b10: "\x1c\f\U00020b10", // 𠬐
	0x20b11: "\x1c\r\U00020b11", // 𠬑
	0x20b12: "\x1c\r\U00020b12", // 𠬒
	0x20b13: "\x1c\x0e\U00020b13", // 𠬓
	0x20b14: "\x1c\x11\U00020b14", // 𠬔
	0x20b15: "\x1c\x0f\U00020b15", // 𠬕
	0x20b16: "\x1c\x0f\U00020b16", // 𠬖
	0x20b17: "\x1c\x0f\U00020b17", // 𠬗
	0x20b18: "\x1c\x11\U00020b18", // 𠬘
	0x20b19: "\x1c\x11\U00020b19", // 𠬙
	0x20b1a: "\x1d\x02\U00020b1a", // 𠬚
	0x20b1b: "\x1d\x02\U00020b1b", // 𠬛
	0x20b1c: "\x1d\x02\U00020b1c", // 𠬜
	0x20b1d: "\x1d\x02\U00020b1d", // 𠬝
	0x20b1e: "\x1d\x02\U00020b1e", // 𠬞
	0x20b1f: "\x1d\x02\U00020b1f", // 𠬟
	0x20b20: "\x1d\x02\U00020b20", // 𠬠
	0x20b21: "\x1d\x03\U00020b21", // 𠬡
	0x20b22: "\x1d\x03\U00020b22", // 𠬢
	0x20b23: "\x1d\x03\U00020b23", // 𠬣
	0x20b24: "\x1d\x03\U00020b24", // 𠬤
	0x20b25: "\x1d\x03\U00020b25", // 𠬥
	0x20b26: "\x1d\x03\U00020b26", // 𠬦
	0x20b27: "\x1d\x03\U00020b27", // 𠬧
	0x20b28: "\x1d\x03\U00020b28", // 𠬨
	0x20b29: "\x1d\x04\U00020b29", // 𠬩
	0x20b2a: "\x1d\x04\U00020b2a", // 𠬪
	0x20b2b: "\x1d\x04\U00020b2b", // 𠬫
	0x20b2c: "\x1d\x04\U00020b2c", // 𠬬
	0x20b2d: "\x1d\x04\U00020b2d", // 𠬭
	0x20b2e: "\x1d\x04\U00020b2e", // 𠬮
	0x20b2f: "\x1d\x04\U00020b2f", // 𠬯
	0x20b30: "\x1d\x04\U00020b30", // 𠬰
	0x20b31: "\x1d\x05\U00020b31", // 𠬱
	0x20b32: "\x1d\x05\U00020b32", // 𠬲
	0x20b33: "\x1d\x05\U00020b33", // 𠬳
	0x20b34: "\x1d\x05\U00020b34", // 𠬴
	0x20b35: "\x1d\x05\U00020b35", // 𠬵
	0x20b36: "\x1d\x05\U00020b36", // 𠬶
	0x20b37: "\x1d\x05\U00020b37", // 𠬷
	0x20b38: "\x1d\x05\U00020b38", // 𠬸
	0x20b39: "\x1d\x06\U00020b39", // 𠬹
	0x20b3a: "\x1d\x06\U00020b3a", // 𠬺
	0x20b3b: "\x1d\x06\U00020b3b", // 𠬻
	0x20b3c: "\x1d\x06\U00020b3c", // 𠬼
	0x20b3d: "\x1d\x06\U00020b3d", // 𠬽
	0x20b3e: "\x1d\x06\U00020b3e", // 𠬾
	0x20b3f: "\x1d\a\U00020b3f", // 𠬿
	0x20b40: "\x1d\a\U00020b40", // 𠭀
	0x20b41: "\x1d\a\U00020b41", // 𠭁
	0x20b42: "\x1d\a\U00020b42", // 𠭂
	0x20b43: "\x1d\a\U00020b43", // 𠭃
	0x20b44: "\x1d\a\U00020b44", // 𠭄
	0x20b45: "\x1d\a\U00020b45", // 𠭅
	0x20b46: "\x1d\a\U00020b46", // 𠭆
	0x20b47: "\x1d\a\U00020b47", // 𠭇
	0x20b48: "\x1d\a\U00020b48", // 𠭈
	0x20b49: "\x19\a\U00020b49", // 𠭉
	0x20b4a: "\x1d\b\U00020b4a", // 𠭊
	0x20b4b: "\x1d\b\U00020b4b", // 𠭋
	0x20b4c: "\x1d\b\U00020b4c", // 𠭌
	0x20b4d: "\x1d\b\U00020b4d", // 𠭍
	0x20b4e: "\x1d\b\U00020b4e", // 𠭎
	0x20b4f: "\x1d\b\U00020b4f", // 𠭏
	0x20b50: "\x1d\b\U00020b50", // 𠭐
	0x20b51: "\x1d\b\U00020b51", // 𠭑
	0x20b52: "\x1d\b\U00020b52", // 𠭒
	0x20b53: "\x1d\b\U00020b53", // 𠭓
	0x20b54: "\x1d\b\U00020b54", // 𠭔
	0x20b55: "\x1d\t\U00020b55", // 𠭕
	0x20b56: "\x1d\t\U00020b56", // 𠭖
	0x20b57: "\x1d\t\U00020b57", // 𠭗
	0x20b58: "\x1d\t\U00020b58", // 𠭘
	0x20b59: "\x1d\t\U00020b59", // 𠭙
	0x20b5a: "\x1d\t\U00020b5a", // 𠭚
	0x20b5b: "\x1d\t\U00020b5b", // 𠭛
	0x20b5c: "\x1d\t\U00020b5c", // 𠭜
	0x20b5d: "\x1d\t\U00020b5d", // 𠭝
	0x20b5e: "\x1d\t\U00020b5e", // 𠭞
	0x20b5f: "\x1d\t\U00020b5f", // 𠭟
	0x20b60: "\x1d\t\U00020b60", // 𠭠
	0x20b61: "\x1d\t\U00020b61", // 𠭡
	0x20b62: "\x1d\t\U00020b62", // 𠭢
	0x20b63: "\x1d\t\U00020b63", // 𠭣
	0x20b64: "\x1d\t\U00020b64", // 𠭤
	0x20b65: "\x1d\n\U00020b65", // 𠭥
	0x20b66: "\x1d\n\U00020b66", // 𠭦
	0x20b67: "\x1d\n\U00020b67", // 𠭧
	0x20b68: "\x1d\n\U00020b68", // 𠭨
	0x20b69: "\x1d\n\U00020b69", // 𠭩
	0x20b6a: "\x1d\n\U00020b6a", // 𠭪
	0x20b6b: "\x1d\n\U00020b6b", // 𠭫
	0x20b6c: "\x1d\n\U00020b6c", // 𠭬
	0x20b6d: "\x1d\n\U00020b6d", // 𠭭
	0x20b6e: "\x1d\n\U00020b6e", // 𠭮
	0x20b6f: "\x1d\v\U00020b6f", // 𠭯
	0x20b70: "\x1d\v\U00020b70", // 𠭰
	0x20b71: "\x1d\v\U00020b71", // 𠭱
	0x20b72: "\x1d\v\U00020b72", // 𠭲
	0x20b73: "\x1d\v\U00020b73", // 𠭳
	0x20b74: "\x1d\v\U00020b74", // 𠭴
	0x20b75: "\x1d\v\U00020b75", // 𠭵
	0x20b76: "#\n\U00020b76", // 𠭶
	0x20b77: "\x1d\v\U00020b77", // 𠭷
	0x20b78: "\x1d\v\U00020b78", // 𠭸
	0x20b79: "\x1d\v\U00020b79", // 𠭹
	0x20b7a: "\x1d\v\U00020b7a", // 𠭺
	0x20b7b: "\f\f\U00020b7b", // 𠭻
	0x20b7c: "\x1d\f\U00020b7c", // 𠭼
	0x20b7d: "\x1d\f\U00020b7d", // 𠭽
	0x20b7e: "\x1d\f\U00020b7e", // 𠭾
	0x20b7f: "\x1d\f\U00020b7f", // 𠭿
	0x20b80: "\x1d\f\U00020b80", // 𠮀
	0x20b81: "\x1d\f\U00020b81", // 𠮁
	0x20b82: "\x1d\f\U00020b82", // 𠮂
	0x20b83: "\x1d\r\U00020b83", // 𠮃
	0x20b84: "\x1d\r\U00020b84", // 𠮄
	0x20b85: "\x1d\r\U00020b85", // 𠮅
	0x20b86: "\x1d\r\U00020b86", // 𠮆
	0x20b87: "\x1d\x0e\U00020b87", // 𠮇
	0x20b88: "\x1d\x0e\U00020b88", // 𠮈
	0x20b89: "\x1d\x0e\U00020b89", // 𠮉
	0x20b8a: "\x1d\x0e\U00020b8a", // 𠮊
	0x20b8b: "\x1d\x0e\U00020b8b", // 𠮋
	0x20b8c: "\x1d\x0e\U00020b8c", // 𠮌
	0x20b8d: "\x1d\x0f\U00020b8d", // 𠮍
	0x20b8e: "\x1d\x0f\U00020b8e", // 𠮎
	0x20b8f: "\x1d\x0f\U00020b8f", // 𠮏
	0x20b90: "\x1d\x10\U00020b90", // 𠮐
	0x20b91: "\x1d\x11\U00020b91", // 𠮑
	0x20b92: "\x1d\x11\U00020b92", // 𠮒
	0x20b93: "\x1d\x13\U00020b93", // 𠮓
	0x20b94: "\x1d\x13\U00020b94", // 𠮔
	0x20b95: "\x1d\x14\U00020b95", // 𠮕
	0x20b96: "\x1d\x15\U00020b96", // 𠮖
	0x20b97: "\x1d\x16\U00020b97", // 𠮗
	0x20b98: "\x1d\x16\U00020b98", // 𠮘
	0x20b99: "\x1e\x01\U00020b99", // 𠮙
	0x20b9a: "\x1e\x01\U00020b9a", // 𠮚
	0x20b9b: "\x1e\x01\U00020b9b", // 𠮛
	0x20b9c: "\x1e\x01\U00020b9c", // 𠮜
	0x20b9d: "\x1e\x01\U00020b9d", // 𠮝
	0x20b9e: "\x1e\x01\U00020b9e", // 𠮞
	0x20b9f: "\x1e\x02\U00020b9f", // 𠮟
	0x20ba0: "\x1e\x02\U00020ba0", // 𠮠
	0x20ba1: "\x1e\x02\U00020ba1", // 𠮡
	0x20ba2: "\x1e\x02\U00020ba2", // 𠮢
	0x20ba3: "\x1e\x02\U00020ba3", // 𠮣
	0x20ba4: "\x1e\x02\U00020ba4", // 𠮤
	0x20ba5: "\x1e\x02\U00020ba5", // 𠮥
	0x20ba6: "\x1e\x02\U00020ba6", // 𠮦
	0x20ba7: "\x1e\x02\U00020ba7", // 𠮧
	0x20ba8: "\x1e\x02\U00020ba8", // 𠮨
	0x20ba9: "\x1e\x02\U00020ba9", // 𠮩
	0x20baa: "\x1e\x02\U00020baa", // 𠮪
	0x20bab: "\x1e\x03\U00020bab", // 𠮫
	0x20bac: "\x1e\x03\U00020bac", // 𠮬
	0x20bad: "\x1e\x03\U00020bad", // 𠮭
	0x20bae: "\x1e\x03\U00020bae", // 𠮮
	0x20baf: "\x1e\x03\U00020baf", // 𠮯
	0x20bb0: "\x1e\x03\U00020bb0", // 𠮰
	0x20bb1: "\x1e\x03\U00020bb1", // 𠮱
	0x20bb2: "\x1e\x03\U00020bb2", // 𠮲
	0x20bb3: "\x1e\x03\U00020bb3", // 𠮳
	0x20bb4: "\x1e\x03\U00020bb4", // 𠮴
	0x20bb5: "\x1e\x03\U00020bb5", // 𠮵
	0x20bb6: "\x1e\x03\U00020bb6", // 𠮶
	0x20bb7: "\x1e\x03\U00020bb7", // 𠮷
	0x20bb8: "\x1e\x03\U00020bb8", // 𠮸
	0x20bb9: "\x1e\x03\U00020bb9", // 𠮹
	0x20bba: "\x1e\x03\U00020bba", // 𠮺
	0x20bbb: "\x1e\x03\U00020bbb", // 𠮻
	0x20bbc: "\x1e\x03\U00020bbc", // 𠮼
	0x20bbd: "\x1e\x03\U00020bbd", // 𠮽
	0x20bbe: "\x1e\x03\U00020bbe", // 𠮾
	0x20bbf: "\x1e\x03\U00020bbf", // 𠮿
	0x20bc0: "\x1e\x03\U00020bc0", // 𠯀
	0x20bc1: "\x1e\x03\U00020bc1", // 𠯁
	0x20bc2: "\x1e\x03\U00020bc2", // 𠯂
	0x20bc3: "\x1e\x03\U00020bc3", // 𠯃
	0x20bc4: "\x1e\x03\U00020bc4", // 𠯄
	0x20bc5: "\x1e\x03\U00020bc5", // 𠯅
	0x20bc6: "\x1e\x03\U00020bc6", // 𠯆
	0x20bc7: "\x1e\x03\U00020bc7", // 𠯇
	0x20bc8: "\x1e\x03\U00020bc8", // 𠯈
	0x20bc9: "\x1e\x03\U00020bc9", // 𠯉
	0x20bca: "\x1e\x03\U00020bca", // 𠯊
	0x20bcb: "\x1e\x04\U00020bcb", // 𠯋
	0x20bcc: "\x1e\x04\U00020bcc", // 𠯌
	0x20bcd: "\x1e\x04\U00020bcd", // 𠯍
	0x20bce: "\x1e\x04\U00020bce", // 𠯎
	0x20bcf: "\x1e\x04\U00020bcf", // 𠯏
	0x20bd0: "\x1e\x04\U00020bd0", // 𠯐
	0x20bd1: "\x1e\x04\U00020bd1", // 𠯑
	0x20bd2: "\x1e\x04\U00020bd2", // 𠯒
	0x20bd3: "\x1e\x04\U00020bd3", // 𠯓
	0x20bd4: "\x1e\x04\U00020bd4", // 𠯔
	0x20bd5: "\x1e\x04\U00020bd5", // 𠯕
	0x20bd6: "\x1e\x04\U00020bd6", // 𠯖
	0x20bd7: "\x1e\x04\U00020bd7", // 𠯗
	0x20bd8: "\x1e\x04\U00020bd8", // 𠯘
	0x20bd9: "\x1e\x04\U00020bd9", // 𠯙
	0x20bda: "\x1e\x04\U00020bda", // 𠯚
	0x20bdb: "\x1e\x04\U00020bdb", // 𠯛
	0x20bdc: "\x1e\x04\U00020bdc", // 𠯜
	0x20bdd: "\x1e\x04\U00020bdd", // 𠯝
	0x20bde: "\x1e\x04\U00020bde", // 𠯞
	0x20bdf: "\x1e\x04\U00020bdf", // 𠯟
	0x20be0: "\x1e\x04\U00020be0", // 𠯠
	0x20be1: "\x1e\x04\U00020be1", // 𠯡
	0x20be2: "\x1e\x04\U00020be2", // 𠯢
	0x20be3: "\x1e\x04\U00020be3", // 𠯣
	0x20be4: "\x1e\x04\U00020be4", // 𠯤
	0x20be5: "\x1e\x04\U00020be5", // 𠯥
	0x20be6: "\x1e\x04\U00020be6", // 𠯦
	0x20be7: "\x1e\x04\U00020be7", // 𠯧
	0x20be8: "\x1e\x04\U00020be8", // 𠯨
	0x20be9: "\x1e\x04\U00020be9", // 𠯩
	0x20bea: "\x1e\x04\U00020bea", // 𠯪
	0x20beb: "\x1e\x04\U00020beb", // 𠯫
	0x20bec: "\x1e\x04\U00020bec", // 𠯬
	0x20bed: "\x1e\x04\U00020bed", // 𠯭
	0x20bee: "\x1e\x04\U00020bee", // 𠯮
	0x20bef: "\x1e\x04\U00020bef", // 𠯯
	0x20bf0: "\x1e\x04\U00020bf0", // 𠯰
	0x20bf1: "\x1e\x04\U00020bf1", // 𠯱
	0x20bf2: "\x1e\x04\U00020bf2", // 𠯲
	0x20bf3: "\x1e\x04\U00020bf3", // 𠯳
	0x20bf4: "\x1e\x04\U00020bf4", // 𠯴
	0x20bf5: "\x1e\x04\U00020bf5", // 𠯵
	0x20bf6: "\x1e\x04\U00020bf6", // 𠯶
	0x20bf7: "\x1e\x04\U00020bf7", // 𠯷
	0x20bf8: "\x1e\x04\U00020bf8", // 𠯸
	0x20bf9: "\x1e\x04\U00020bf9", // 𠯹
	0x20bfa: "\x1e\x04\U00020bfa", // 𠯺
	0x20bfb: "\x1e\x04\U00020bfb", // 𠯻
	0x20bfc: "\x1e\x04\U00020bfc", // 𠯼
	0x20bfd: "\x1e\x04\U00020bfd", // 𠯽
	0x20bfe: "\x1e\x04\U00020bfe", // 𠯾
	0x20bff: "\x1e\x04\U00020bff", // 𠯿
	0x20c00: "\x1e\x04\U00020c00", // 𠰀
	0x20c01: "\x1e\x04\U00020c01", // 𠰁
	0x20c02: "\x1e\x04\U00020c02", // 𠰂
	0x20c03: "\x1e\x04\U00020c03", // 𠰃
	0x20c04: "\x1e\x04\U00020c04", // 𠰄
	0x20c05: "\x1e\x04\U00020c05", // 𠰅
	0x20c06: "\x1e\x04\U00020c06", // 𠰆
	0x20c07: "\x1e\x04\U00020c07", // 𠰇
	0x20c08: "\x1e\x05\U00020c08", // 𠰈
	0x20c09: "\x1e\x05\U00020c09", // 𠰉
	0x20c0a: "\x1e\x05\U00020c0a", // 𠰊
	0x20c0b: "\x1e\x05\U00020c0b", // 𠰋
	0x20c0c: "\x1e\x05\U00020c0c", // 𠰌
	0x20c0d: "\x1e\x05\U00020c0d", // 𠰍
	0x20c0e: "\x1e\x05\U00020c0e", // 𠰎
	0x20c0f: "\x1e\x05\U00020c0f", // 𠰏
	0x20c10: "\x1e\x05\U00020c10", // 𠰐
	0x20c11: "\x1e\x05\U00020c11", // 𠰑
	0x20c12: "\x1e\x05\U00020c12", // 𠰒
	0x20c13: "\x1e\x05\U00020c13", // 𠰓
	0x20c14: "\x1e\x05\U00020c14", // 𠰔
	0x20c15: "\x1e\x05\U00020c15", // 𠰕
	0x20c16: "\x1e\x05\U00020c16", // 𠰖
	0x20c17: "\x1e\x05\U00020c17", // 𠰗
	0x20c18: "\x1e\x05\U00020c18", // 𠰘
	0x20c19: "\x1e\x05\U00020c19", // 𠰙
	0x20c1a: "\x1e\x05\U00020c1a", // 𠰚
	0x20c1b: "\x1e\x05\U00020c1b", // 𠰛
	0x20c1c: "\x1e\x05\U00020c1c", // 𠰜
	0x20c1d: "\x1e\x05\U00020c1d", // 𠰝
	0x20c1e: "\x1e\x05\U00020c1e", // 𠰞
	0x20c1f: "\x1e\x05\U00020c1f", // 𠰟
	0x20c20: "\x1e\x05\U00020c20", // 𠰠
	0x20c21: "\x1e\x05\U00020c21", // 𠰡
	0x20c22: "\x1e\x05\U00020c22", // 𠰢
	0x20c23: "\x1e\x05\U00020c23", // 𠰣
	0x20c24: "\x1e\x05\U00020c24", // 𠰤
	0x20c25: "\x1e\x05\U00020c25", // 𠰥
	0x20c26: "\x1e\x05\U00020c26", // 𠰦
	0x20c27: "\x1e\x05\U00020c27", // 𠰧
	0x20c28: "\x1e\x05\U00020c28", // 𠰨
	0x20c29: "\x1e\x05\U00020c29", // 𠰩
	0x20c2a: "\x1e\x05\U00020c2a", // 𠰪
	0x20c2b: "\x1e\x05\U00020c2b", // 𠰫
	0x20c2c: "\x1e\x05\U00020c2c", // 𠰬
	0x20c2d: "\x1e\x05\U00020c2d", // 𠰭
	0x20c2e: "\x1e\x05\U00020c2e", // 𠰮
	0x20c2f: "\x1e\x05\U00020c2f", // 𠰯
	0x20c30: "\x1e\x05\U00020c30", // 𠰰
	0x20c31: "\x1e\x05\U00020c31", // 𠰱
	0x20c32: "\x1e\x05\U00020c32", // 𠰲
	0x20c33: "\x1e\x05\U00020c33", // 𠰳
	0x20c34: "\x1e\x05\U00020c34", // 𠰴
	0x20c35: "\x1e\x05\U00020c35", // 𠰵
	0x20c36: "\x1e\x05\U00020c36", // 𠰶
	0x20c37: "\x1e\x05\U00020c37", // 𠰷
	0x20c38: "\x1e\x05\U00020c38", // 𠰸
	0x20c39: "\x1e\x05\U00020c39", // 𠰹
	0x20c3a: "\x1e\x05\U00020c3a", // 𠰺
	0x20c3b: "\x1e\x05\U00020c3b", // 𠰻
	0x20c3c: "\x1e\x05\U00020c3c", // 𠰼
	0x20c3d: "\x1e\x05\U00020c3d", // 𠰽
	0x20c3e: "\x1e\x05\U00020c3e", // 𠰾
	0x20c3f: "\x1e\x05\U00020c3f", // 𠰿
	0x20c40: "\x1e\x05\U00020c40", // 𠱀
	0x20c41: "\x1e\x05\U00020c41", // 𠱁
	0x20c42: "\x1e\x05\U00020c42", // 𠱂
	0x20c43: "\x1e\x05\U00020c43", // 𠱃
	0x20c44: "\x1e\x05\U00020c44", // 𠱄
	0x20c45: "\x1e\x05\U00020c45", // 𠱅
	0x20c46: "\x1e\x05\U00020c46", // 𠱆
	0x20c47: "\x1e\x05\U00020c47", // 𠱇
	0x20c48: "\x1e\x05\U00020c48", // 𠱈
	0x20c49: "\x1e\x05\U00020c49", // 𠱉
	0x20c4a: "\x1e\x05\U00020c4a", // 𠱊
	0x20c4b: "\x1e\x05\U00020c4b", // 𠱋
	0x20c4c: "\x1e\x05\U00020c4c", // 𠱌
	0x20c4d: "\x1e\x05\U00020c4d", // 𠱍
	0x20c4e: "\x1e\x05\U00020c4e", // 𠱎
	0x20c4f: "\x1e\x05\U00020c4f", // 𠱏
	0x20c50: "\x1e\x06\U00020c50", // 𠱐
	0x20c51: "\x1e\x06\U00020c51", // 𠱑
	0x20c52: "\x1e\x06\U00020c52", // 𠱒
	0x20c53: "\x1e\x06\U00020c53", // 𠱓
	0x20c54: "\x1e\x06\U00020c54", // 𠱔
	0x20c55: "\x1e\x06\U00020c55", // 𠱕
	0x20c56: "\x1e\x06\U00020c56", // 𠱖
	0x20c57: "\x1e\x06\U00020c57", // 𠱗
	0x20c58: "\x1e\x06\U00020c58", // 𠱘
	0x20c59: "\x1e\x06\U00020c59", // 𠱙
	0x20c5a: "\x1e\x06\U00020c5a", // 𠱚
	0x20c5b: "\x1e\x06\U00020c5b", // 𠱛
	0x20c5c: "\x1e\x06\U00020c5c", // 𠱜
	0x20c5d: "\x1e\x06\U00020c5d", // 𠱝
	0x20c5e: "\x1e\x06\U00020c5e", // 𠱞
	0x20c5f: "\x1e\x06\U00020c5f", // 𠱟
	0x20c60: "\x1e\x06\U00020c60", // 𠱠
	0x20c61: "\x1e\x06\U00020c61", // 𠱡
	0x20c62: "\x1e\x06\U00020c62", // 𠱢
	0x20c63: "\x1e\x06\U00020c63", // 𠱣
	0x20c64: "\x1e\x06\U00020c64", // 𠱤
	0x20c65: "\x1e\x06\U00020c65", // 𠱥
	0x20c66: "\x1e\x06\U00020c66", // 𠱦
	0x20c67: "\x1e\x06\U00020c67", // 𠱧
	0x20c68: "\x1e\x06\U00020c68", // 𠱨
	0x20c69: "\x1e\x06\U00020c69", // 𠱩
	0x20c6a: "\x1e\x06\U00020c6a", // 𠱪
	0x20c6b: "\x1e\x06\U00020c6b", // 𠱫
	0x20c6c: "\x1e\x06\U00020c6c", // 𠱬
	0x20c6d: "\x1e\x06\U00020c6d", // 𠱭
	0x20c6e: "\x1e\x06\U00020c6e", // 𠱮
	0x20c6f: "\x1e\x06\U00020c6f", // 𠱯
	0x20c70: "\x1e\x06\U00020c70", // 𠱰
	0x20c71: "\x1e\x06\U00020c71", // 𠱱
	0x20c72: "\x1e\x06\U00020c72", // 𠱲
	0x20c73: "\x1e\x06\U00020c73", // 𠱳
	0x20c74: "\x1e\x06\U00020c74", // 𠱴
	0x20c75: "\x1e\x06\U00020c75", // 𠱵
	0x20c76: "\x1e\x06\U00020c76", // 𠱶
	0x20c77: "\x1e\x06\U00020c77", // 𠱷
	0x20c78: "\x1e\x06\U00020c78", // 𠱸
	0x20c79: "\x1e\x06\U00020c79", // 𠱹
	0x20c7a: "\x1e\x06\U00020c7a", // 𠱺
	0x20c7b: "\x1e\x06\U00020c7b", // 𠱻
	0x20c7c: "\x1e\x06\U00020c7c", // 𠱼
	0x20c7d: "\x1e\x06\U00020c7d", // 𠱽
	0x20c7e: "\x1e\x06\U00020c7e", // 𠱾
	0x20c7f: "\x1e\x06\U00020c7f", // 𠱿
	0x20c80: "\x1e\x06\U00020c80", // 𠲀
	0x20c81: "\x1e\x06\U00020c81", // 𠲁
	0x20c82: "\x1e\x06\U00020c82", // 𠲂
	0x20c83: "\x1e\x06\U00020c83", // 𠲃
	0x20c84: "\x1e\x06\U00020c84", // 𠲄
	0x20c85: "\x1e\x06\U00020c85", // 𠲅
	0x20c86: "\x1e\x06\U00020c86", // 𠲆
	0x20c87: "\x1e\x06\U00020c87", // 𠲇
	0x20c88: "\x1e\x06\U00020c88", // 𠲈
	0x20c89: "\x1e\x06\U00020c89", // 𠲉
	0x20c8a: "\x1e\x06\U00020c8a", // 𠲊
	0x20c8b: "\x1e\x06\U00020c8b", // 𠲋
	0x20c8c: "\x1e\x06\U00020c8c", // 𠲌
	0x20c8d: "\x1e\x06\U00020c8d", // 𠲍
	0x20c8e: "\x1e\x06\U00020c8e", // 𠲎
	0x20c8f: "\x1e\x06\U00020c8f", // 𠲏
	0x20c90: "\x1e\x06\U00020c90", // 𠲐
	0x20c91: "\x1e\x06\U00020c91", // 𠲑
	0x20c92: "\x1e\x06\U00020c92", // 𠲒
	0x20c93: "\x1e\x06\U00020c93", // 𠲓
	0x20c94: "\x1e\x06\U00020c94", // 𠲔
	0x20c95: "\x1e\x06\U00020c95", // 𠲕
	0x20c96: "\x1e\x06\U00020c96", // 𠲖
	0x20c97: "\x1e\x06\U00020c97", // 𠲗
	0x20c98: "\x1e\x06\U00020c98", // 𠲘
	0x20c99: "\x1e\x06\U00020c99", // 𠲙
	0x20c9a: "\x1e\x06\U00020c9a", // 𠲚
	0x20c9b: "\x1e\x06\U00020c9b", // 𠲛
	0x20c9c: "\x1e\x06\U00020c9c", // 𠲜
	0x20c9d: "\x1e\x06\U00020c9d", // 𠲝
	0x20c9e: "\x1e\x06\U00020c9e", // 𠲞
	0x20c9f: "\x1e\x06\U00020c9f", // 𠲟
	0x20ca0: "\x1e\x06\U00020ca0", // 𠲠
	0x20ca1: "\x1e\x06\U00020ca1", // 𠲡
	0x20ca2: "\x1e\x06\U00020ca2", // 𠲢
	0x20ca3: "\x1e\x06\U00020ca3", // 𠲣
	0x20ca4: "\x1e\x06\U00020ca4", // 𠲤
	0x20ca5: "\x1e\x06\U00020ca5", // 𠲥
	0x20ca6: "\x1e\x06\U00020ca6", // 𠲦
	0x20ca7: "\x1e\x06\U00020ca7", // 𠲧
	0x20ca8: "\x1e\x06\U00020ca8", // 𠲨
	0x20ca9: "\x1e\x06\U00020ca9", // 𠲩
	0x20caa: "\x1e\x06\U00020caa", // 𠲪
	0x20cab: "\x1e\x06\U00020cab", // 𠲫
	0x20cac: "\x1e\a\U00020cac", // 𠲬
	0x20cad: "\x1e\a\U00020cad", // 𠲭
	0x20cae: "\x1e\a\U00020cae", // 𠲮
	0x20caf: "\x1e\a\U00020caf", // 𠲯
	0x20cb0: "\x1e\a\U00020cb0", // 𠲰
	0x20cb1: "\x1e\a\U00020cb1", // 𠲱
	0x20cb2: "\x1e\a\U00020cb2", // 𠲲
	0x20cb3: "\x1e\a\U00020cb3", // 𠲳
	0x20cb4: "\x1e\a\U00020cb4", // 𠲴
	0x20cb5: "\x1e\a\U00020cb5", // 𠲵
	0x20cb6: "\x1e\a\U00020cb6", // 𠲶
	0x20cb7: "\x1e\a\U00020cb7", // 𠲷
	0x20cb8: "\x1e\a\U00020cb8", // 𠲸
	0x20cb9: "\x1e\a\U00020cb9", // 𠲹
	0x20cba: "\x1e\a\U00020cba", // 𠲺
	0x20cbb: "\x1e\a\U00020cbb", // 𠲻
	0x20cbc: "\x1e\a\U00020cbc", // 𠲼
	0x20cbd: "\x1e\a\U00020cbd", // 𠲽
	0x20cbe: "\x1e\a\U00020cbe", // 𠲾
	0x20cbf: "\x1e\a\U00020cbf", // 𠲿
	0x20cc0: "\x1e\a\U00020cc0", // 𠳀
	0x20cc1: "\x1e\a\U00020cc1", // 𠳁
	0x20cc2: "\x1e\a\U00020cc2", // 𠳂
	0x20cc3: "\x1e\a\U00020cc3", // 𠳃
	0x20cc4: "\x1e\a\U00020cc4", // 𠳄
	0x20cc5: "\x1e\a\U00020cc5", // 𠳅
	0x20cc6: "\x1e\a\U00020cc6", // 𠳆
	0x20cc7: "\x1e\a\U00020cc7", // 𠳇
	0x20cc8: "\x1e\a\U00020cc8", // 𠳈
	0x20cc9: "\x1e\a\U00020cc9", // 𠳉
	0x20cca: "\x1e\a\U00020cca", // 𠳊
	0x20ccb: "\x1e\a\U00020ccb", // 𠳋
	0x20ccc: "\x1e\a\U00020ccc", // 𠳌
	0x20ccd: "\x1e\a\U00020ccd", // 𠳍
	0x20cce: "\x1e\a\U00020cce", // 𠳎
	0x20ccf: "\x1e\a\U00020ccf", // 𠳏
	0x20cd0: "\x1e\a\U00020cd0", // 𠳐
	0x20cd1: "\x1e\a\U00020cd1", // 𠳑
	0x20cd2: "\x1e\a\U00020cd2", // 𠳒
	0x20cd3: "\x1e\a\U00020cd3", // 𠳓
	0x20cd4: "\x1e\a\U00020cd4", // 𠳔
	0x20cd5: "\x1e\a\U00020cd5", // 𠳕
	0x20cd6: "\x1e\a\U00020cd6", // 𠳖
	0x20cd7: "\x1e\a\U00020cd7", // 𠳗
	0x20cd8: "\x1e\a\U00020cd8", // 𠳘
	0x20cd9: "\x1e\a\U00020cd9", // 𠳙
	0x20cda: "\x1e\a\U00020cda", // 𠳚
	0x20cdb: "\x1e\a\U00020cdb", // 𠳛
	0x20cdc: "\x1e\a\U00020cdc", // 𠳜
	0x20cdd: "\x1e\a\U00020cdd", // 𠳝
	0x20cde: "\x1e\a\U00020cde", // 𠳞
	0x20cdf: "\x1e\a\U00020cdf", // 𠳟
	0x20ce0: "\x1e\a\U00020ce0", // 𠳠
	0x20ce1: "\x1e\a\U00020ce1", // 𠳡
	0x20ce2: "\x1e\a\U00020ce2", // 𠳢
	0x20ce3: "\x1e\a\U00020ce3", // 𠳣
	0x20ce4: "\x1e\a\U00020ce4", // 𠳤
	0x20ce5: "\x1e\b\U00020ce5", // 𠳥
	0x20ce6: "\x1e\a\U00020ce6", // 𠳦
	0x20ce7: "\x1e\a\U00020ce7", // 𠳧
	0x20ce8: "\x1e\a\U00020ce8", // 𠳨
	0x20ce9: "\x1e\a\U00020ce9", // 𠳩
	0x20cea: "\x1e\a\U00020cea", // 𠳪
	0x20ceb: "e\x05\U00020ceb", // 𠳫
	0x20cec: "\x1e\a\U00020cec", // 𠳬
	0x20ced: "\x1e\a\U00020ced", // 𠳭
	0x20cee: "\x1e\a\U00020cee", // 𠳮
	0x20cef: "\x1e\a\U00020cef", // 𠳯
	0x20cf0: "\x1e\a\U00020cf0", // 𠳰
	0x20cf1: "\x1e\a\U00020cf1", // 𠳱
	0x20cf2: "\x1e\a\U00020cf2", // 𠳲
	0x20cf3: "\x1e\a\U00020cf3", // 𠳳
	0x20cf4: "\x1e\a\U00020cf4", // 𠳴
	0x20cf5: "\x1e\a\U00020cf5", // 𠳵
	0x20cf6: "\x1e\a\U00020cf6", // 𠳶
	0x20cf7: "\x1e\a\U00020cf7", // 𠳷
	0x20cf8: "\x1e\a\U00020cf8", // 𠳸
	0x20cf9: "\x1e\a\U00020cf9", // 𠳹
	0x20cfa: "\x1e\a\U00020cfa", // 𠳺
	0x20cfb: "\x1e\a\U00020cfb", // 𠳻
	0x20cfc: "\x1e\a\U00020cfc", // 𠳼
	0x20cfd: "\x1e\a\U00020cfd", // 𠳽
	0x20cfe: "\x1e\a\U00020cfe", // 𠳾
	0x20cff: "\x1e\a\U00020cff", // 𠳿
	0x20d00: "\x1e\a\U00020d00", // 𠴀
	0x20d01: "\x1e\a\U00020d01", // 𠴁
	0x20d02: "\x1e\a\U00020d02", // 𠴂
	0x20d03: "\x1e\a\U00020d03", // 𠴃
	0x20d04: "\x1e\a\U00020d04", // 𠴄
	0x20d05: "\x1e\a\U00020d05", // 𠴅
	0x20d06: "\x1e\a\U00020d06", // 𠴆
	0x20d07: "\x1e\a\U00020d07", // 𠴇
	0x20d08: "\x1e\a\U00020d08", // 𠴈
	0x20d09: "\x1e\a\U00020d09", // 𠴉
	0x20d0a: "\x1e\a\U00020d0a", // 𠴊
	0x20d0b: "\x1e\a\U00020d0b", // 𠴋
	0x20d0c: "\x1e\a\U00020d0c", // 𠴌
	0x20d0d: "\x1e\a\U00020d0d", // 𠴍
	0x20d0e: "\x1e\a\U00020d0e", // 𠴎
	0x20d0f: "\x1e\a\U00020d0f", // 𠴏
	0x20d10: "\x1e\a\U00020d10", // 𠴐
	0x20d11: "\x1e\a\U00020d11", // 𠴑
	0x20d12: "\x1e\a\U00020d12", // 𠴒
	0x20d13: "\x1e\a\U00020d13", // 𠴓
	0x20d14: "\x1e\a\U00020d14", // 𠴔
	0x20d15: "\x1e\a\U00020d15", // 𠴕
	0x20d16: "\x1e\a\U00020d16", // 𠴖
	0x20d17: "\x1e\a\U00020d17", // 𠴗
	0x20d18: "\x1e\a\U00020d18", // 𠴘
	0x20d19: "\x1e\a\U00020d19", // 𠴙
	0x20d1a: "\x1e\a\U00020d1a", // 𠴚
	0x20d1b: "\x1e\a\U00020d1b", // 𠴛
	0x20d1c: "\x1e\a\U00020d1c", // 𠴜
	0x20d1d: "\x1e\a\U00020d1d", // 𠴝
	0x20d1e: "\x1e\a\U00020d1e", // 𠴞
	0x20d1f: "\x1e\a\U00020d1f", // 𠴟
	0x20d20: "\x1e\a\U00020d20", // 𠴠
	0x20d21: "\x1e\a\U00020d21", // 𠴡
	0x20d22: "\x1e\a\U00020d22", // 𠴢
	0x20d23: "\x1e\a\U00020d23", // 𠴣
	0x20d24: "\x1e\a\U00020d24", // 𠴤
	0x20d25: "\x1e\a\U00020d25", // 𠴥
	0x20d26: "`\x06\U00020d26", // 𠴦
	0x20d27: "\x1e\b\U00020d27", // 𠴧
	0x20d28: "\x1e\b\U00020d28", // 𠴨
	0x20d29: "\x1e\b\U00020d29", // 𠴩
	0x20d2a: "\x1e\b\U00020d2a", // 𠴪
	0x20d2b: "\x1e\b\U00020d2b", // 𠴫
	0x20d2c: "\x1e\b\U00020d2c", // 𠴬
	0x20d2d: "\x1e\b\U00020d2d", // 𠴭
	0x20d2e: "\x1e\b\U00020d2e", // 𠴮
	0x20d2f: "\x1e\b\U00020d2f", // 𠴯
	0x20d30: "\x1e\b\U00020d30", // 𠴰
	0x20d31: "\x1e\b\U00020d31", // 𠴱
	0x20d32: "\x1e\b\U00020d32", // 𠴲
	0x20d33: "\x1e\b\U00020d33", // 𠴳
	0x20d34: "\x1e\b\U00020d34", // 𠴴
	0x20d35: "\x1e\b\U00020d35", // 𠴵
	0x20d36: "\x1e\b\U00020d36", // 𠴶
	0x20d37: "\x1e\b\U00020d37", // 𠴷
	0x20d38: "\x1e\b\U00020d38", // 𠴸
	0x20d39: "\x1e\b\U00020d39", // 𠴹
	0x20d3a: "\x1e\b\U00020d3a", // 𠴺
	0x20d3b: "\x1e\b\U00020d3b", // 𠴻
	0x20d3c: "\x1e\b\U00020d3c", // 𠴼
	0x20d3d: "\x1e\b\U00020d3d", // 𠴽
	0x20d3e: "\x1e\b\U00020d3e", // 𠴾
	0x20d3f: "\x1e\b\U00020d3f", // 𠴿
	0x20d40: "\x1e\b\U00020d40", // 𠵀
	0x20d41: "\x1e\b\U00020d41", // 𠵁
	0x20d42: "\x1e\b\U00020d42", // 𠵂
	0x20d43: "\x1e\b\U00020d43", // 𠵃
	0x20d44: "\x1e\b\U00020d44", // 𠵄
	0x20d45: "\x1e\b\U00020d45", // 𠵅
	0x20d46: "\x1e\b\U00020d46", // 𠵆
	0x20d47: "\x1e\b\U00020d47", // 𠵇
	0x20d48: "\x1e\b\U00020d48", // 𠵈
	0x20d49: "\x1e\b\U00020d49", // 𠵉
	0x20d4a: "\x1e\b\U00020d4a", // 𠵊
	0x20d4b: "\x1e\b\U00020d4b", // 𠵋
	0x20d4c: "\x1e\b\U00020d4c", // 𠵌
	0x20d4d: "\x1e\b\U00020d4d", // 𠵍
	0x20d4e: "\x1e\b\U00020d4e", // 𠵎
	0x20d4f: "\x1e\b\U00020d4f", // 𠵏
	0x20d50: "\x1e\b\U00020d50", // 𠵐
	0x20d51: "\x1e\b\U00020d51", // 𠵑
	0x20d52: "\x1e\b\U00020d52", // 𠵒
	0x20d53: "\x1e\b\U00020d53", // 𠵓
	0x20d54: "\x1e\b\U00020d54", // 𠵔
	0x20d55: "\x1e\b\U00020d55", // 𠵕
	0x20d56: "\x1e\b\U00020d56", // 𠵖
	0x20d57: "\x1e\b\U00020d57", // 𠵗
	0x20d58: "\x1e\b\U00020d58", // 𠵘
	0x20d59: "\x1e\b\U00020d59", // 𠵙
	0x20d5a: "\x1e\b\U00020d5a", // 𠵚
	0x20d5b: "\x1e\b\U00020d5b", // 𠵛
	0x20d5c: "\x1e\b\U00020d5c", // 𠵜
	0x20d5d: "\x1e\b\U00020d5d", // 𠵝
	0x20d5e: "\x1e\b\U00020d5e", // 𠵞
	0x20d5f: "\x1e\b\U00020d5f", // 𠵟
	0x20d60: "\x1e\b\U00020d60", // 𠵠
	0x20d61: "\x1e\b\U00020d61", // 𠵡
	0x20d62: "\x1e\b\U00020d62", // 𠵢
	0x20d63: "\x1e\b\U00020d63", // 𠵣
	0x20d64: "\x1e\b\U00020d64", // 𠵤
	0x20d65: "\x1e\b\U00020d65", // 𠵥
	0x20d66: "\x1e\b\U00020d66", // 𠵦
	0x20d67: "\x1e\b\U00020d67", // 𠵧
	0x20d68: "\x1e\b\U00020d68", // 𠵨
	0x20d69: "\x1e\b\U00020d69", // 𠵩
	0x20d6a: "\x1e\b\U00020d6a", // 𠵪
	0x20d6b: "\x1e\b\U00020d6b", // 𠵫
	0x20d6c: "\x1e\b\U00020d6c", // 𠵬
	0x20d6d: "\x1e\b\U00020d6d", // 𠵭
	0x20d6e: "\x1e\b\U00020d6e", // 𠵮
	0x20d6f: "\x1e\b\U00020d6f", // 𠵯
	0x20d70: "\x1e\b\U00020d70", // 𠵰
	0x20d71: "\x1e\b\U00020d71", // 𠵱
	0x20d72: "\x1e\b\U00020d72", // 𠵲
	0x20d73: "\x1e\b\U00020d73", // 𠵳
	0x20d74: "\x1e\b\U00020d74", // 𠵴
	0x20d75: "\x1e\b\U00020d75", // 𠵵
	0x20d76: "\x1e\b\U00020d76", // 𠵶
	0x20d77: "\x1e\b\U00020d77", // 𠵷
	0x20d78: "\x1e\b\U00020d78", // 𠵸
	0x20d79: "\x1e\b\U00020d79", // 𠵹
	0x20d7a: "\x1e\b\U00020d7a", // 𠵺
	0x20d7b: "\x1e\b\U00020d7b", // 𠵻
	0x20d7c: "\x1e\b\U00020d7c", // 𠵼
	0x20d7d: "\x1e\b\U00020d7d", // 𠵽
	0x20d7e: "\x1e\b\U00020d7e", // 𠵾
	0x20d7f: "\x1e\b\U00020d7f", // 𠵿
	0x20d80: "\x1e\b\U00020d80", // 𠶀
	0x20d81: "\x1e\b\U00020d81", // 𠶁
	0x20d82: "\x1e\b\U00020d82", // 𠶂
	0x20d83: "\x1e\b\U00020d83", // 𠶃
	0x20d84: "\x1e\b\U00020d84", // 𠶄
	0x20d85: "\x1e\b\U00020d85", // 𠶅
	0x20d86: "\x1e\b\U00020d86", // 𠶆
	0x20d87: "\x1e\b\U00020d87", // 𠶇
	0x20d88: "\x1e\b\U00020d88", // 𠶈
	0x20d89: "\x1e\b\U00020d89", // 𠶉
	0x20d8a: "\x1e\b\U00020d8a", // 𠶊
	0x20d8b: "\x1e\b\U00020d8b", // 𠶋
	0x20d8c: "\x1e\b\U00020d8c", // 𠶌
	0x20d8d: "\x1e\b\U00020d8d", // 𠶍
	0x20d8e: "\x1e\b\U00020d8e", // 𠶎
	0x20d8f: "\x1e\b\U00020d8f", // 𠶏
	0x20d90: "\x1e\b\U00020d90", // 𠶐
	0x20d91: "\x1e\b\U00020d91", // 𠶑
	0x20d92: "\x1e\b\U00020d92", // 𠶒
	0x20d93: "\x1e\b\U00020d93", // 𠶓
	0x20d94: "\x1e\b\U00020d94", // 𠶔
	0x20d95: "\x1e\b\U00020d95", // 𠶕
	0x20d96: "\x1e\b\U00020d96", // 𠶖
	0x20d97: "\x1e\b\U00020d97", // 𠶗
	0x20d98: "\x1e\b\U00020d98", // 𠶘
	0x20d99: "\x1e\b\U00020d99", // 𠶙
	0x20d9a: "\x1e\b\U00020d9a", // 𠶚
	0x20d9b: "\x1e\b\U00020d9b", // 𠶛
	0x20d9c: "\x1e\b\U00020d9c", // 𠶜
	0x20d9d: "\x1e\b\U00020d9d", // 𠶝
	0x20d9e: "\x1e\b\U00020d9e", // 𠶞
	0x20d9f: "\x1e\b\U00020d9f", // 𠶟
	0x20da0: "\x1e\b\U00020da0", // 𠶠
	0x20da1: "\x1e\b\U00020da1", // 𠶡
	0x20da2: "\x1e\b\U00020da2", // 𠶢
	0x20da3: "\x1e\b\U00020da3", // 𠶣
	0x20da4: "\x1e\b\U00020da4", // 𠶤
	0x20da5: "\x1e\b\U00020da5", // 𠶥
	0x20da6: "\x1e\b\U00020da6", // 𠶦
	0x20da7: "\x1e\b\U00020da7", // 𠶧
	0x20da8: "\x1e\b\U00020da8", // 𠶨
	0x20da9: "\x1e\b\U00020da9", // 𠶩
	0x20daa: "\x1e\b\U00020daa", // 𠶪
	0x20dab: "\x1e\b\U00020dab", // 𠶫
	0x20dac: "\x1e\b\U00020dac", // 𠶬
	0x20dad: "\x1e\b\U00020dad", // 𠶭
	0x20dae: "\x1e\b\U00020dae", // 𠶮
	0x20daf: "\x1e\b\U00020daf", // 𠶯
	0x20db0: "\x1e\b\U00020db0", // 𠶰
	0x20db1: "\x1e\b\U00020db1", // 𠶱
	0x20db2: "\x1e\b\U00020db2", // 𠶲
	0x20db3: "\x1e\b\U00020db3", // 𠶳
	0x20db4: "\x1e\b\U00020db4", // 𠶴
	0x20db5: "\x1e\b\U00020db5", // 𠶵
	0x20db6: "\x1e\b\U00020db6", // 𠶶
	0x20db7: "\x1e\t\U00020db7", // 𠶷
	0x20db8: "\x1e\t\U00020db8", // 𠶸
	0x20db9: "\x1e\t\U00020db9", // 𠶹
	0x20dba: "\x1e\t\U00020dba", // 𠶺
	0x20dbb: "\x1e\t\U00020dbb", // 𠶻
	0x20dbc: "\x1e\t\U00020dbc", // 𠶼
	0x20dbd: "\x1e\t\U00020dbd", // 𠶽
	0x20dbe: "\x1e\t\U00020dbe", // 𠶾
	0x20dbf: "\x1e\t\U00020dbf", // 𠶿
	0x20dc0: "\x1e\t\U00020dc0", // 𠷀
	0x20dc1: "\x1e\t\U00020dc1", // 𠷁
	0x20dc2: "\x1e\t\U00020dc2", // 𠷂
	0x20dc3: "\x1e\t\U00020dc3", // 𠷃
	0x20dc4: "\x1e\t\U00020dc4", // 𠷄
	0x20dc5: "\x1e\t\U00020dc5", // 𠷅
	0x20dc6: "\x1e\t\U00020dc6", // 𠷆
	0x20dc7: "\x1e\t\U00020dc7", // 𠷇
	0x20dc8: "\x1e\t\U00020dc8", // 𠷈
	0x20dc9: "\x1e\t\U00020dc9", // 𠷉
	0x20dca: "\x1e\t\U00020dca", // 𠷊
	0x20dcb: "\x1e\t\U00020dcb", // 𠷋
	0x20dcc: "\x1e\t\U00020dcc", // 𠷌
	0x20dcd: "\x1e\t\U00020dcd", // 𠷍
	0x20dce: "\x1e\t\U00020dce", // 𠷎
	0x20dcf: "\x1e\t\U00020dcf", // 𠷏
	0x20dd0: "\x1e\t\U00020dd0", // 𠷐
	0x20dd1: "\x1e\t\U00020dd1", // 𠷑
	0x20dd2: "\x1e\t\U00020dd2", // 𠷒
	0x20dd3: "\x1e\t\U00020dd3", // 𠷓
	0x20dd4: "\x1e\t\U00020dd4", // 𠷔
	0x20dd5: "\x1e\t\U00020dd5", // 𠷕
	0x20dd6: "\x1e\t\U00020dd6", // 𠷖
	0x20dd7: "\x1e\t\U00020dd7", // 𠷗
	0x20dd8: "\x1e\t\U00020dd8", // 𠷘
	0x20dd9: "\x1e\t\U00020dd9", // 𠷙
	0x20dda: "\x1e\t\U00020dda", // 𠷚
	0x20ddb: "\x1e\t\U00020ddb", // 𠷛
	0x20ddc: "\x1e\t\U00020ddc", // 𠷜
	0x20ddd: "\x1e\t\U00020ddd", // 𠷝
	0x20dde: "\x1e\t\U00020dde", // 𠷞
	0x20ddf: "\x1e\t\U00020ddf", // 𠷟
	0x20de0: "\x1e\t\U00020de0", // 𠷠
	0x20de1: "\x1e\t\U00020de1", // 𠷡
	0x20de2: "\x1e\n\U00020de2", // 𠷢
	0x20de3: "\x1e\t\U00020de3", // 𠷣
	0x20de4: "\x1e\t\U00020de4", // 𠷤
	0x20de5: "\x1e\t\U00020de5", // 𠷥
	0x20de6: "\x1e\t\U00020de6", // 𠷦
	0x20de7: "\x1e\t\U00020de7", // 𠷧
	0x20de8: "\x1e\t\U00020de8", // 𠷨
	0x20de9: "\x1e\t\U00020de9", // 𠷩
	0x20dea: "\x1e\t\U00020dea", // 𠷪
	0x20deb: "\x1e\t\U00020deb", // 𠷫
	0x20dec: "\x1e\t\U00020dec", // 𠷬
	0x20ded: "\x1e\t\U00020ded", // 𠷭
	0x20dee: "\x1e\t\U00020dee", // 𠷮
	0x20def: "\x1e\t\U00020def", // 𠷯
	0x20df0: "\x1e\t\U00020df0", // 𠷰
	0x20df1: "\x1e\t\U00020df1", // 𠷱
	0x20df2: "\x1e\t\U00020df2", // 𠷲
	0x20df3: "\x1e\t\U00020df3", // 𠷳
	0x20df4: "\x1e\t\U00020df4", // 𠷴
	0x20df5: "\x1e\t\U00020df5", // 𠷵
	0x20df6: "\x1e\t\U00020df6", // 𠷶
	0x20df7: "\x1e\t\U00020df7", // 𠷷
	0x20df8: "\x1e\t\U00020df8", // 𠷸
	0x20df9: "\x1e\t\U00020df9", // 𠷹
	0x20dfa: "\x1e\t\U00020dfa", // 𠷺
	0x20dfb: "\x1e\t\U00020dfb", // 𠷻
	0x20dfc: "\x1e\t\U00020dfc", // 𠷼
	0x20dfd: "\x1e\t\U00020dfd", // 𠷽
	0x20dfe: "\x1e\t\U00020dfe", // 𠷾
	0x20dff: "\x1e\t\U00020dff", // 𠷿
	0x20e00: "\x1e\t\U00020e00", // 𠸀
	0x20e01: "\x1e\t\U00020e01", // 𠸁
	0x20e02: "\x1e\t\U00020e02", // 𠸂
	0x20e03: "\x1e\t\U00020e03", // 𠸃
	0x20e04: "\x1e\t\U00020e04", // 𠸄
	0x20e05: "\x1e\t\U00020e05", // 𠸅
	0x20e06: "\x1e\t\U00020e06", // 𠸆
	0x20e07: "\x1e\t\U00020e07", // 𠸇
	0x20e08: "\x1e\t\U00020e08", // 𠸈
	0x20e09: "\x1e\t\U00020e09", // 𠸉
	0x20e0a: "\x1e\t\U00020e0a", // 𠸊
	0x20e0b: "\x1e\t\U00020e0b", // 𠸋
	0x20e0c: "\x1e\t\U00020e0c", // 𠸌
	0x20e0d: "\x1e\t\U00020e0d", // 𠸍
	0x20e0e: "\x1e\t\U00020e0e", // 𠸎
	0x20e0f: "\x1e\t\U00020e0f", // 𠸏
	0x20e10: "\x1e\t\U00020e10", // 𠸐
	0x20e11: "\x1e\t\U00020e11", // 𠸑
	0x20e12: "\x1e\t\U00020e12", // 𠸒
	0x20e13: "\x1e\t\U00020e13", // 𠸓
	0x20e14: "\x1e\t\U00020e14", // 𠸔
	0x20e15: "\x1e\t\U00020e15", // 𠸕
	0x20e16: "\x1e\t\U00020e16", // 𠸖
	0x20e17: "\x1e\t\U00020e17", // 𠸗
	0x20e18: "\x1e\t\U00020e18", // 𠸘
	0x20e19: "\x1e\t\U00020e19", // 𠸙
	0x20e1a: "\x1e\t\U00020e1a", // 𠸚
	0x20e1b: "\x1e\t\U00020e1b", // 𠸛
	0x20e1c: "\x1e\t\U00020e1c", // 𠸜
	0x20e1d: "\x1e\t\U00020e1d", // 𠸝
	0x20e1e: "\x1e\t\U00020e1e", // 𠸞
	0x20e1f: "\x1e\t\U00020e1f", // 𠸟
	0x20e20: "\x1e\t\U00020e20", // 𠸠
	0x20e21: "\x1e\t\U00020e21", // 𠸡
	0x20e22: "\x1e\t\U00020e22", // 𠸢
	0x20e23: "\x1e\t\U00020e23", // 𠸣
	0x20e24: "\x1e\t\U00020e24", // 𠸤
	0x20e25: "\x1e\t\U00020e25", // 𠸥
	0x20e26: "\x1e\t\U00020e26", // 𠸦
	0x20e27: "\x1e\t\U00020e27", // 𠸧
	0x20e28: "\x1e\t\U00020e28", // 𠸨
	0x20e29: "\x1e\t\U00020e29", // 𠸩
	0x20e2a: "\x1e\t\U00020e2a", // 𠸪
	0x20e2b: "\x1e\t\U00020e2b", // 𠸫
	0x20e2c: "\x1e\t\U00020e2c", // 𠸬
	0x20e2d: "\x1e\t\U00020e2d", // 𠸭
	0x20e2e: "\x1e\t\U00020e2e", // 𠸮
	0x20e2f: "\x1e\t\U00020e2f", // 𠸯
	0x20e30: "\x1e\t\U00020e30", // 𠸰
	0x20e31: "\x1e\t\U00020e31", // 𠸱
	0x20e32: "\x1e\t\U00020e32", // 𠸲
	0x20e33: "\x1e\t\U00020e33", // 𠸳
	0x20e34: "\x1e\t\U00020e34", // 𠸴
	0x20e35: "\x1e\t\U00020e35", // 𠸵
	0x20e36: "\x1e\n\U00020e36", // 𠸶
	0x20e37: "\x1e\n\U00020e37", // 𠸷
	0x20e38: "\x1e\n\U00020e38", // 𠸸
	0x20e39: "\x1e\n\U00020e39", // 𠸹
	0x20e3a: "\x1e\n\U00020e3a", // 𠸺
	0x20e3b: "\x1e\t\U00020e3b", // 𠸻
	0x20e3c: "\x1e\t\U00020e3c", // 𠸼
	0x20e3d: "\x1e\t\U00020e3d", // 𠸽
	0x20e3e: "\x1e\t\U00020e3e", // 𠸾
	0x20e3f: "\x1e\n\U00020e3f", // 𠸿
	0x20e40: "\x1e\n\U00020e40", // 𠹀
	0x20e41: "\x1e\n\U00020e41", // 𠹁
	0x20e42: "\x1e\n\U00020e42", // 𠹂
	0x20e43: "\x1e\n\U00020e43", // 𠹃
	0x20e44: "\x1e\n\U00020e44", // 𠹄
	0x20e45: "\x1e\n\U00020e45", // 𠹅
	0x20e46: "\x1e\n\U00020e46", // 𠹆
	0x20e47: "\x1e\n\U00020e47", // 𠹇
	0x20e48: "\x1e\n\U00020e48", // 𠹈
	0x20e49: "\x1e\n\U00020e49", // 𠹉
	0x20e4a: "\x1e\n\U00020e4a", // 𠹊
	0x20e4b: "\x1e\n\U00020e4b", // 𠹋
	0x20e4c: "\x1e\n\U00020e4c", // 𠹌
	0x20e4d: "\x1e\n\U00020e4d", // 𠹍
	0x20e4e: "\x1e\n\U00020e4e", // 𠹎
	0x20e4f: "\x1e\n\U00020e4f", // 𠹏
	0x20e50: "\x1e\n\U00020e50", // 𠹐
	0x20e51: "\x1e\n\U00020e51", // 𠹑
	0x20e52: "\x1e\n\U00020e52", // 𠹒
	0x20e53: "\x1e\n\U00020e53", // 𠹓
	0x20e54: "\x1e\n\U00020e54", // 𠹔
	0x20e55: "\x1e\n\U00020e55", // 𠹕
	0x20e56: "\x1e\n\U00020e56", // 𠹖
	0x20e57: "\x1e\n\U00020e57", // 𠹗
	0x20e58: "\x1e\n\U00020e58", // 𠹘
	0x20e59: "\x1e\n\U00020e59", // 𠹙
	0x20e5a: "\x1e\n\U00020e5a", // 𠹚
	0x20e5b: "\x1e\n\U00020e5b", // 𠹛
	0x20e5c: "\x1e\n\U00020e5c", // 𠹜
	0x20e5d: "\x1e\n\U00020e5d", // 𠹝
	0x20e5e: "\x1e\n\U00020e5e", // 𠹞
	0x20e5f: "\x1e\n\U00020e5f", // 𠹟
	0x20e60: "\x1e\n\U00020e60", // 𠹠
	0x20e61: "\x1e\n\U00020e61", // 𠹡
	0x20e62: "\x1e\n\U00020e62", // 𠹢
	0x20e63: "\x1e\n\U00020e63", // 𠹣
	0x20e64: "\x1e\n\U00020e64", // 𠹤
	0x20e65: "\x1e\n\U00020e65", // 𠹥
	0x20e66: "\x1e\n\U00020e66", // 𠹦
	0x20e67: "\x1e\n\U00020e67", // 𠹧
	0x20e68: "\x1e\n\U00020e68", // 𠹨
	0x20e69: "\x1e\n\U00020e69", // 𠹩
	0x20e6a: "\x1e\n\U00020e6a", // 𠹪
	0x20e6b: "\x1e\n\U00020e6b", // 𠹫
	0x20e6c: "\x1e\n\U00020e6c", // 𠹬
	0x20e6d: "\x1e\n\U00020e6d", // 𠹭
	0x20e6e: "\x1e\n\U00020e6e", // 𠹮
	0x20e6f: "\x1e\n\U00020e6f", // 𠹯
	0x20e70: "\x1e\f\U00020e70", // 𠹰
	0x20e71: "\x1e\f\U00020e71", // 𠹱
	0x20e72: "\x1e\f\U00020e72", // 𠹲
	0x20e73: "\x1e\n\U00020e73", // 𠹳
	0x20e74: "\x1e\n\U00020e74", // 𠹴
	0x20e75: "\x1e\n\U00020e75", // 𠹵
	0x20e76: "\x1e\n\U00020e76", // 𠹶
	0x20e77: "\x1e\n\U00020e77", // 𠹷
	0x20e78: "\x1e\n\U00020e78", // 𠹸
	0x20e79: "\x1e\n\U00020e79", // 𠹹
	0x20e7a: "\x1e\n\U00020e7a", // 𠹺
	0x20e7b: "\x1e\n\U00020e7b", // 𠹻
	0x20e7c: "\x1e\n\U00020e7c", // 𠹼
	0x20e7d: "\x1e\n\U00020e7d", // 𠹽
	0x20e7e: "\x1e\n\U00020e7e", // 𠹾
	0x20e7f: "\x1e\n\U00020e7f", // 𠹿
	0x20e80: "\x1e\n\U00020e80", // 𠺀
	0x20e81: "\x1e\n\U00020e81", // 𠺁
	0x20e82: "\x1e\n\U00020e82", // 𠺂
	0x20e83: "\x1e\n\U00020e83", // 𠺃
	0x20e84: "\x1e\n\U00020e84", // 𠺄
	0x20e85: "\x1e\n\U00020e85", // 𠺅
	0x20e86: "\x1e\n\U00020e86", // 𠺆
	0x20e87: "\x1e\n\U00020e87", // 𠺇
	0x20e88: "\x1e\n\U00020e88", // 𠺈
	0x20e89: "\x1e\n\U00020e89", // 𠺉
	0x20e8a: "\x1e\n\U00020e8a", // 𠺊
	0x20e8b: "\x1e\n\U00020e8b", // 𠺋
	0x20e8c: "\x1e\n\U00020e8c", // 𠺌
	0x20e8d: "\x1e\n\U00020e8d", // 𠺍
	0x20e8e: "\x1e\n\U00020e8e", // 𠺎
	0x20e8f: "\x1e\n\U00020e8f", // 𠺏
	0x20e90: "\x1e\n\U00020e90", // 𠺐
	0x20e91: "\x1e\n\U00020e91", // 𠺑
	0x20e92: "\x1e\n\U00020e92", // 𠺒
	0x20e93: "\x1e\n\U00020e93", // 𠺓
	0x20e94: "\x1e\n\U00020e94", // 𠺔
	0x20e95: "\x1e\n\U00020e95", // 𠺕
	0x20e96: "\x1e\n\U00020e96", // 𠺖
	0x20e97: "\x1e\n\U00020e97", // 𠺗
	0x20e98: "\x1e\n\U00020e98", // 𠺘
	0x20e99: "\x1e\n\U00020e99", // 𠺙
	0x20e9a: "\x1e\n\U00020e9a", // 𠺚
	0x20e9b: "\x1e\n\U00020e9b", // 𠺛
	0x20e9c: "\x1e\n\U00020e9c", // 𠺜
	0x20e9d: "\x1e\n\U00020e9d", // 𠺝
	0x20e9e: "\x1e\n\U00020e9e", // 𠺞
	0x20e9f: "\x1e\n\U00020e9f", // 𠺟
	0x20ea0: "\x1e\n\U00020ea0", // 𠺠
	0x20ea1: "\x1e\n\U00020ea1", // 𠺡
	0x20ea2: "\x1e\n\U00020ea2", // 𠺢
	0x20ea3: "\x1e\n\U00020ea3", // 𠺣
	0x20ea4: "\x1e\n\U00020ea4", // 𠺤
	0x20ea5: "\x1e\n\U00020ea5", // 𠺥
	0x20ea6: "\x1e\n\U00020ea6", // 𠺦
	0x20ea7: "\x1e\n\U00020ea7", // 𠺧
	0x20ea8: "\x1e\n\U00020ea8", // 𠺨
	0x20ea9: "\x1e\n\U00020ea9", // 𠺩
	0x20eaa: "\x1e\n\U00020eaa", // 𠺪
	0x20eab: "\x1e\n\U00020eab", // 𠺫
	0x20eac: "\x1e\n\U00020eac", // 𠺬
	0x20ead: "\x1e\n\U00020ead", // 𠺭
	0x20eae: "\x1e\n\U00020eae", // 𠺮
	0x20eaf: "\x1e\n\U00020eaf", // 𠺯
	0x20eb0: "\x1e\n\U00020eb0", // 𠺰
	0x20eb1: "\x1e\n\U00020eb1", // 𠺱
	0x20eb2: "\x1e\n\U00020eb2", // 𠺲
	0x20eb3: "\x1e\n\U00020eb3", // 𠺳
	0x20eb4: "\x1e\n\U00020eb4", // 𠺴
	0x20eb5: "\x1e\n\U00020eb5", // 𠺵
	0x20eb6: "\x1e\n\U00020eb6", // 𠺶
	0x20eb7: "\x1e\n\U00020eb7", // 𠺷
	0x20eb8: "\x1e\n\U00020eb8", // 𠺸
	0x20eb9: "\x1e\n\U00020eb9", // 𠺹
	0x20eba: "\x1e\n\U00020eba", // 𠺺
	0x20ebb: "\x1e\n\U00020ebb", // 𠺻
	0x20ebc: "\x1e\n\U00020ebc", // 𠺼
	0x20ebd: "\x1e\n\U00020ebd", // 𠺽
	0x20ebe: "\x1e\n\U00020ebe", // 𠺾
	0x20ebf: "\x1e\n\U00020ebf", // 𠺿
	0x20ec0: "\x1e\n\U00020ec0", // 𠻀
	0x20ec1: "\x1e\n\U00020ec1", // 𠻁
	0x20ec2: "\x1e\n\U00020ec2", // 𠻂
	0x20ec3: "\x1e\n\U00020ec3", // 𠻃
	0x20ec4: "\x1e\n\U00020ec4", // 𠻄
	0x20ec5: "\x1e\n\U00020ec5", // 𠻅
	0x20ec6: "\x1e\n\U00020ec6", // 𠻆
	0x20ec7: "\x1e\n\U00020ec7", // 𠻇
	0x20ec8: "\x1e\n\U00020ec8", // 𠻈
	0x20ec9: "\x1e\n\U00020ec9", // 𠻉
	0x20eca: "\x1e\n\U00020eca", // 𠻊
	0x20ecb: "\x1e\n\U00020ecb", // 𠻋
	0x20ecc: "\x1e\n\U00020ecc", // 𠻌
	0x20ecd: "\x1e\n\U00020ecd", // 𠻍
	0x20ece: "\x1e\n\U00020ece", // 𠻎
	0x20ecf: "\x1e\n\U00020ecf", // 𠻏
	0x20ed0: "\x1e\n\U00020ed0", // 𠻐
	0x20ed1: "\x1e\n\U00020ed1", // 𠻑
	0x20ed2: "\x1e\n\U00020ed2", // 𠻒
	0x20ed3: "\x1e\n\U00020ed3", // 𠻓
	0x20ed4: "\x1e\v\U00020ed4", // 𠻔
	0x20ed5: "\x1e\v\U00020ed5", // 𠻕
	0x20ed6: "\x1e\v\U00020ed6", // 𠻖
	0x20ed7: "\x1e\v\U00020ed7", // 𠻗
	0x20ed8: "\x1e\v\U00020ed8", // 𠻘
	0x20ed9: "\x1e\v\U00020ed9", // 𠻙
	0x20eda: "\x1e\v\U00020eda", // 𠻚
	0x20edb: "\x1e\v\U00020edb", // 𠻛
	0x20edc: "\x1e\v\U00020edc", // 𠻜
	0x20edd: "\x1e\v\U00020edd", // 𠻝
	0x20ede: "\x1e\v\U00020ede", // 𠻞
	0x20edf: "\x1e\v\U00020edf", // 𠻟
	0x20ee0: "\x1e\v\U00020ee0", // 𠻠
	0x20ee1: "\x1e\v\U00020ee1", // 𠻡
	0x20ee2: "\x1e\v\U00020ee2", // 𠻢
	0x20ee3: "\x1e\v\U00020ee3", // 𠻣
	0x20ee4: "\x1e\v\U00020ee4", // 𠻤
	0x20ee5: "\x1e\v\U00020ee5", // 𠻥
	0x20ee6: "\x1e\v\U00020ee6", // 𠻦
	0x20ee7: "\x1e\v\U00020ee7", // 𠻧
	0x20ee8: "\x1e\v\U00020ee8", // 𠻨
	0x20ee9: "\x1e\v\U00020ee9", // 𠻩
	0x20eea: "\x1e\v\U00020eea", // 𠻪
	0x20eeb: "\x1e\v\U00020eeb", // 𠻫
	0x20eec: "\x1e\v\U00020eec", // 𠻬
	0x20eed: "\x1e\v\U00020eed", // 𠻭
	0x20eee: "\x1e\v\U00020eee", // 𠻮
	0x20eef: "\x1e\v\U00020eef", // 𠻯
	0x20ef0: "\x1e\v\U00020ef0", // 𠻰
	0x20ef1: "\x1e\v\U00020ef1", // 𠻱
	0x20ef2: "\x1e\v\U00020ef2", // 𠻲
	0x20ef3: "\x1e\v\U00020ef3", // 𠻳
	0x20ef4: "\x1e\v\U00020ef4", // 𠻴
	0x20ef5: "\x1e\v\U00020ef5", // 𠻵
	0x20ef6: "\x1e\v\U00020ef6", // 𠻶
	0x20ef7: "\x1e\v\U00020ef7", // 𠻷
	0x20ef8: "\x1e\v\U00020ef8", // 𠻸
	0x20ef9: "\x1e\v\U00020ef9", // 𠻹
	0x20efa: "\x1e\v\U00020efa", // 𠻺
	0x20efb: "\x1e\v\U00020efb", // 𠻻
	0x20efc: "\x1e\v\U00020efc", // 𠻼
	0x20efd: "\x1e\v\U00020efd", // 𠻽
	0x20efe: "\x1e\v\U00020efe", // 𠻾
	0x20eff: "\x1e\v\U00020eff", // 𠻿
	0x20f00: "\x1e\v\U00020f00", // 𠼀
	0x20f01: "\x1e\v\U00020f01", // 𠼁
	0x20f02: "\x1e\v\U00020f02", // 𠼂
	0x20f03: "\x1e\v\U00020f03", // 𠼃
	0x20f04: "\x1e\v\U00020f04", // 𠼄
	0x20f05: "\x1e\v\U00020f05", // 𠼅
	0x20f06: "\x1e\v\U00020f06", // 𠼆
	0x20f07: "\x1e\v\U00020f07", // 𠼇
	0x20f08: "\x1e\v\U00020f08", // 𠼈
	0x20f09: "\x1e\v\U00020f09", // 𠼉
	0x20f0a: "\x1e\v\U00020f0a", // 𠼊
	0x20f0b: "\x1e\v\U00020f0b", // 𠼋
	0x20f0c: "\x1e\v\U00020f0c", // 𠼌
	0x20f0d: "\x1e\v\U00020f0d", // 𠼍
	0x20f0e: "\x1e\v\U00020f0e", // 𠼎
	0x20f0f: "\x1e\v\U00020f0f", // 𠼏
	0x20f10: "\x1e\v\U00020f10", // 𠼐
	0x20f11: "\x1e\v\U00020f11", // 𠼑
	0x20f12: "\x1e\v\U00020f12", // 𠼒
	0x20f13: "\x1e\v\U00020f13", // 𠼓
	0x20f14: "\x1e\v\U00020f14", // 𠼔
	0x20f15: "\x1e\v\U00020f15", // 𠼕
	0x20f16: "\x1e\v\U00020f16", // 𠼖
	0x20f17: "\x1e\v\U00020f17", // 𠼗
	0x20f18: "\x1e\v\U00020f18", // 𠼘
	0x20f19: "\x1e\v\U00020f19", // 𠼙
	0x20f1a: "\x1e\v\U00020f1a", // 𠼚
	0x20f1b: "\x1e\v\U00020f1b", // 𠼛
	0x20f1c: "\x1e\v\U00020f1c", // 𠼜
	0x20f1d: "\x1e\v\U00020f1d", // 𠼝
	0x20f1e: "\x1e\v\U00020f1e", // 𠼞
	0x20f1f: "\x1e\v\U00020f1f", // 𠼟
	0x20f20: "\x1e\v\U00020f20", // 𠼠
	0x20f21: "\x1e\v\U00020f21", // 𠼡
	0x20f22: "\x1e\v\U00020f22", // 𠼢
	0x20f23: "\x1e\v\U00020f23", // 𠼣
	0x20f24: "\x1e\v\U00020f24", // 𠼤
	0x20f25: "\x1e\v\U00020f25", // 𠼥
	0x20f26: "\x1e\v\U00020f26", // 𠼦
	0x20f27: "\x1e\v\U00020f27", // 𠼧
	0x20f28: "\x1e\v\U00020f28", // 𠼨
	0x20f29: "\x1e\v\U00020f29", // 𠼩
	0x20f2a: "\x1e\v\U00020f2a", // 𠼪
	0x20f2b: "\x1e\v\U00020f2b", // 𠼫
	0x20f2c: "\x1e\v\U00020f2c", // 𠼬
	0x20f2d: "\x1e\v\U00020f2d", // 𠼭
	0x20f2e: "\x1e\v\U00020f2e", // 𠼮
	0x20f2f: "\x1e\v\U00020f2f", // 𠼯
	0x20f30: "\x1e\v\U00020f30", // 𠼰
	0x20f31: "\x1e\v\U00020f31", // 𠼱
	0x20f32: "\x1e\v\U00020f32", // 𠼲
	0x20f33: "\x1e\v\U00020f33", // 𠼳
	0x20f34: "\x1e\v\U00020f34", // 𠼴
	0x20f35: "\x1e\v\U00020f35", // 𠼵
	0x20f36: "\x1e\v\U00020f36", // 𠼶
	0x20f37: "\x1e\v\U00020f37", // 𠼷
	0x20f38: "\x1e\v\U00020f38", // 𠼸
	0x20f39: "\x1e\v\U00020f39", // 𠼹
	0x20f3a: "\x1e\v\U00020f3a", // 𠼺
	0x20f3b: "\x1e\v\U00020f3b", // 𠼻
	0x20f3c: "\x1e\v\U00020f3c", // 𠼼
	0x20f3d: "\x1e\v\U00020f3d", // 𠼽
	0x20f3e: "\x1e\v\U00020f3e", // 𠼾
	0x20f3f: "\x1e\v\U00020f3f", // 𠼿
	0x20f40: "\x1e\v\U00020f40", // 𠽀
	0x20f41: "\x1e\v\U00020f41", // 𠽁
	0x20f42: "\x1e\v\U00020f42", // 𠽂
	0x20f43: "\x1e\v\U00020f43", // 𠽃
	0x20f44: "\x1e\v\U00020f44", // 𠽄
	0x20f45: "\x1e\v\U00020f45", // 𠽅
	0x20f46: "\x1e\v\U00020f46", // 𠽆
	0x20f47: "\x1e\v\U00020f47", // 𠽇
	0x20f48: "\x1e\v\U00020f48", // 𠽈
	0x20f49: "\x1e\v\U00020f49", // 𠽉
	0x20f4a: "\x1e\v\U00020f4a", // 𠽊
	0x20f4b: "\x1e\v\U00020f4b", // 𠽋
	0x20f4c: "\x1e\v\U00020f4c", // 𠽌
	0x20f4d: "\x1e\v\U00020f4d", // 𠽍
	0x20f4e: "\x1e\v\U00020f4e", // 𠽎
	0x20f4f: "\x1e\v\U00020f4f", // 𠽏
	0x20f50: "\x1e\v\U00020f50", // 𠽐
	0x20f51: "\x1e\v\U00020f51", // 𠽑
	0x20f52: "\x1e\v\U00020f52", // 𠽒
	0x20f53: "\x1e\v\U00020f53", // 𠽓
	0x20f54: "\x1e\v\U00020f54", // 𠽔
	0x20f55: "\x1e\v\U00020f55", // 𠽕
	0x20f56: "\x1e\v\U00020f56", // 𠽖
	0x20f57: "\x1e\v\U00020f57", // 𠽗
	0x20f58: "\x1e\v\U00020f58", // 𠽘
	0x20f59: "\x1e\v\U00020f59", // 𠽙
	0x20f5a: "\x1e\v\U00020f5a", // 𠽚
	0x20f5b: "\x1e\v\U00020f5b", // 𠽛
	0x20f5c: "\x1e\v\U00020f5c", // 𠽜
	0x20f5d: "\x1e\v\U00020f5d", // 𠽝
	0x20f5e: "\x1e\v\U00020f5e", // 𠽞
	0x20f5f: "\x1e\v\U00020f5f", // 𠽟
	0x20f60: "\x1e\v\U00020f60", // 𠽠
	0x20f61: "\x1e\f\U00020f61", // 𠽡
	0x20f62: "\x1e\f\U00020f62", // 𠽢
	0x20f63: "\x1e\f\U00020f63", // 𠽣
	0x20f64: "\x1e\f\U00020f64", // 𠽤
	0x20f65: "\x1e\f\U00020f65", // 𠽥
	0x20f66: "\x1e\f\U00020f66", // 𠽦
	0x20f67: "\x1e\f\U00020f67", // 𠽧
	0x20f68: "\x1e\f\U00020f68", // 𠽨
	0x20f69: "\x1e\f\U00020f69", // 𠽩
	0x20f6a: "\x1e\f\U00020f6a", // 𠽪
	0x20f6b: "\x1e\f\U00020f6b", // 𠽫
	0x20f6c: "\x1e\f\U00020f6c", // 𠽬
	0x20f6d: "\x1e\f\U00020f6d", // 𠽭
	0x20f6e: "\x1e\f\U00020f6e", // 𠽮
	0x20f6f: "\x1e\f\U00020f6f", // 𠽯
	0x20f70: "\x1e\f\U00020f70", // 𠽰
	0x20f71: "\x1e\f\U00020f71", // 𠽱
	0x20f72: "\x1e\f\U00020f72", // 𠽲
	0x20f73: "\x1e\f\U00020f73", // 𠽳
	0x20f74: "\x1e\f\U00020f74", // 𠽴
	0x20f75: "\x1e\f\U00020f75", // 𠽵
	0x20f76: "\x1e\f\U00020f76", // 𠽶
	0x20f77: "\x1e\f\U00020f77", // 𠽷
	0x20f78: "\x1e\f\U00020f78", // 𠽸
	0x20f79: "\x1e\f\U00020f79", // 𠽹
	0x20f7a: "\x1e\f\U00020f7a", // 𠽺
	0x20f7b: "\x1e\f\U00020f7b", // 𠽻
	0x20f7c: "\x1e\f\U00020f7c", // 𠽼
	0x20f7d: "\x1e\f\U00020f7d", // 𠽽
	0x20f7e: "\x1e\f\U00020f7e", // 𠽾
	0x20f7f: "\x1e\f\U00020f7f", // 𠽿
	0x20f80: "\x1e\f\U00020f80", // 𠾀
	0x20f81: "\x1e\f\U00020f81", // 𠾁
	0x20f82: "\x1e\f\U00020f82", // 𠾂
	0x20f83: "\x1e\f\U00020f83", // 𠾃
	0x20f84: "\x1e\f\U00020f84", // 𠾄
	0x20f85: "\x1e\f\U00020f85", // 𠾅
	0x20f86: "\x1e\f\U00020f86", // 𠾆
	0x20f87: "\x1e\f\U00020f87", // 𠾇
	0x20f88: "\x1e\f\U00020f88", // 𠾈
	0x20f89: "\x1e\f\U00020f89", // 𠾉
	0x20f8a: "\x1e\f\U00020f8a", // 𠾊
	0x20f8b: "\x1e\f\U00020f8b", // 𠾋
	0x20f8c: "\x1e\f\U00020f8c", // 𠾌
	0x20f8d: "\x1e\f\U00020f8d", // 𠾍
	0x20f8e: "\x1e\f\U00020f8e", // 𠾎
	0x20f8f: "\x1e\f\U00020f8f", // 𠾏
	0x20f90: "\x1e\f\U00020f90", // 𠾐
	0x20f91: "\x1e\f\U00020f91", // 𠾑
	0x20f92: "\x1e\f\U00020f92", // 𠾒
	0x20f93: "\x1e\f\U00020f93", // 𠾓
	0x20f94: "\x1e\f\U00020f94", // 𠾔
	0x20f95: "\x1e\f\U00020f95", // 𠾕
	0x20f96: "\x1e\f\U00020f96", // 𠾖
	0x20f97: "\x1e\f\U00020f97", // 𠾗
	0x20f98: "\x1e\f\U00020f98", // 𠾘
	0x20f99: "\x1e\f\U00020f99", // 𠾙
	0x20f9a: "\x1e\f\U00020f9a", // 𠾚
	0x20f9b: "\x1e\f\U00020f9b", // 𠾛
	0x20f9c: "\x1e\f\U00020f9c", // 𠾜
	0x20f9d: "\x1e\f\U00020f9d", // 𠾝
	0x20f9e: "\x1e\f\U00020f9e", // 𠾞
	0x20f9f: "\x1e\f\U00020f9f", // 𠾟
	0x20fa0: "\x1e\f\U00020fa0", // 𠾠
	0x20fa1: "\x1e\f\U00020fa1", // 𠾡
	0x20fa2: "\x1e\f\U00020fa2", // 𠾢
	0x20fa3: "\x1e\f\U00020fa3", // 𠾣
	0x20fa4: "\x1e\f\U00020fa4", // 𠾤
	0x20fa5: "\x1e\f\U00020fa5", // 𠾥
	0x20fa6: "\x1e\f\U00020fa6", // 𠾦
	0x20fa7: "r\n\U00020fa7", // 𠾧
	0x20fa8: "\x1e\f\U00020fa8", // 𠾨
	0x20fa9: "\x1e\f\U00020fa9", // 𠾩
	0x20faa: "\x1e\f\U00020faa", // 𠾪
	0x20fab: "\x1e\f\U00020fab", // 𠾫
	0x20fac: "\x1e\f\U00020fac", // 𠾬
	0x20fad: "\x1e\f\U00020fad", // 𠾭
	0x20fae: "\x1e\f\U00020fae", // 𠾮
	0x20faf: "\x1e\f\U00020faf", // 𠾯
	0x20fb0: "\x1e\f\U00020fb0", // 𠾰
	0x20fb1: "\x1e\f\U00020fb1", // 𠾱
	0x20fb2: "\x1e\f\U00020fb2", // 𠾲
	0x20fb3: "\x1e\f\U00020fb3", // 𠾳
	0x20fb4: "\x1e\f\U00020fb4", // 𠾴
	0x20fb5: "\x1e\f\U00020fb5", // 𠾵
	0x20fb6: "\x1e\f\U00020fb6", // 𠾶
	0x20fb7: "\x1e\f\U00020fb7", // 𠾷
	0x20fb8: "\x1e\f\U00020fb8", // 𠾸
	0x20fb9: "\x1e\f\U00020fb9", // 𠾹
	0x20fba: "\x1e\f\U00020fba", // 𠾺
	0x20fbb: "\x1e\f\U00020fbb", // 𠾻
	0x20fbc: "\x1e\f\U00020fbc", // 𠾼
	0x20fbd: "\x1e\f\U00020fbd", // 𠾽
	0x20fbe: "\x1e\f\U00020fbe", // 𠾾
	0x20fbf: "\x1e\f\U00020fbf", // 𠾿
	0x20fc0: "\x1e\f\U00020fc0", // 𠿀
	0x20fc1: "\x1e\f\U00020fc1", // 𠿁
	0x20fc2: "\x1e\f\U00020fc2", // 𠿂
	0x20fc3: "\x1e\f\U00020fc3", // 𠿃
	0x20fc4: "\x1e\f\U00020fc4", // 𠿄
	0x20fc5: "\x1e\f\U00020fc5", // 𠿅
	0x20fc6: "\x1e\f\U00020fc6", // 𠿆
	0x20fc7: "\x1e\r\U00020fc7", // 𠿇
	0x20fc8: "\x1e\r\U00020fc8", // 𠿈
	0x20fc9: "\x1e\r\U00020fc9", // 𠿉
	0x20fca: "\x1e\r\U00020fca", // 𠿊
	0x20fcb: "\x1e\r\U00020fcb", // 𠿋
	0x20fcc: "\x1e\r\U00020fcc", // 𠿌
	0x20fcd: "\x1e\r\U00020fcd", // 𠿍
	0x20fce: "\x1e\r\U00020fce", // 𠿎
	0x20fcf: "\x1e\r\U00020fcf", // 𠿏
	0x20fd0: "\x1e\r\U00020fd0", // 𠿐
	0x20fd1: "\x1e\r\U00020fd1", // 𠿑
	0x20fd2: "\x1e\r\U00020fd2", // 𠿒
	0x20fd3: "\x1e\r\U00020fd3", // 𠿓
	0x20fd4: "\x1e\r\U00020fd4", // 𠿔
	0x20fd5: "\x1e\r\U00020fd5", // 𠿕
	0x20fd6: "\x1e\r\U00020fd6", // 𠿖
	0x20fd7: "\x1e\r\U00020fd7", // 𠿗
	0x20fd8: "\x1e\r\U00020fd8", // 𠿘
	0x20fd9: "\x1e\r\U00020fd9", // 𠿙
	0x20fda: "\x1e\r\U00020fda", // 𠿚
	0x20fdb: "\x1e\r\U00020fdb", // 𠿛
	0x20fdc: "\x1e\r\U00020fdc", // 𠿜
	0x20fdd: "\x1e\r\U00020fdd", // 𠿝
	0x20fde: "\x1e\r\U00020fde", // 𠿞
	0x20fdf: "\x1e\r\U00020fdf", // 𠿟
	0x20fe0: "\x1e\r\U00020fe0", // 𠿠
	0x20fe1: "\x1e\r\U00020fe1", // 𠿡
	0x20fe2: "\x1e\r\U00020fe2", // 𠿢
	0x20fe3: "\x1e\r\U00020fe3", // 𠿣
	0x20fe4: "\x1e\r\U00020fe4", // 𠿤
	0x20fe5: "\x1e\r\U00020fe5", // 𠿥
	0x20fe6: "\x1e\r\U00020fe6", // 𠿦
	0x20fe7: "\x1e\r\U00020fe7", // 𠿧
	0x20fe8: "\x1e\r\U00020fe8", // 𠿨
	0x20fe9: "\x1e\r\U00020fe9", // 𠿩
	0x20fea: "\x1e\r\U00020fea", // 𠿪
	0x20feb: "\x1e\r\U00020feb", // 𠿫
	0x20fec: "\x1e\r\U00020fec", // 𠿬
	0x20fed: "\x1e\r\U00020fed", // 𠿭
	0x20fee: "\x1e\r\U00020fee", // 𠿮
	0x20fef: "\x1e\r\U00020fef", // 𠿯
	0x20ff0: "\x1e\r\U00020ff0", // 𠿰
	0x20ff1: "\x1e\r\U00020ff1", // 𠿱
	0x20ff2: "\x1e\r\U00020ff2", // 𠿲
	0x20ff3: "\x1e\r\U00020ff3", // 𠿳
	0x20ff4: "\x1e\r\U00020ff4", // 𠿴
	0x20ff5: "\x1e\r\U00020ff5", // 𠿵
	0x20ff6: "\x1e\r\U00020ff6", // 𠿶
	0x20ff7: "\x1e\r\U00020ff7", // 𠿷
	0x20ff8: "\x1e\r\U00020ff8", // 𠿸
	0x20ff9: "\x1e\r\U00020ff9", // 𠿹
	0x20ffa: "\x1e\r\U00020ffa", // 𠿺
	0x20ffb: "\x1e\r\U00020ffb", // 𠿻
	0x20ffc: "\x1e\r\U00020ffc", // 𠿼
	0x20ffd: "\x1e\r\U00020ffd", // 𠿽
	0x20ffe: "\x1e\r\U00020ffe", // 𠿾
	0x20fff: "\x1e\r\U00020fff", // 𠿿
	0x21000: "\x1e\r\U00021000", // 𡀀
	0x21001: "\x1e\r\U00021001", // 𡀁
	0x21002: "\x1e\r\U00021002", // 𡀂
	0x21003: "\x1e\r\U00021003", // 𡀃
	0x21004: "\x1e\r\U00021004", // 𡀄
	0x21005: "\x1e\r\U00021005", // 𡀅
	0x21006: "\x1e\r\U00021006", // 𡀆
	0x21007: "\x1e\r\U00021007", // 𡀇
	0x21008: "\x1e\r\U00021008", // 𡀈
	0x21009: "\x1e\r\U00021009", // 𡀉
	0x2100a: "\x1e\r\U0002100a", // 𡀊
	0x2100b: "\x1e\r\U0002100b", // 𡀋
	0x2100c: "\x1e\r\U0002100c", // 𡀌
	0x2100d: "\x1e\r\U0002100d", // 𡀍
	0x2100e: "\x1e\r\U0002100e", // 𡀎
	0x2100f: "\x1e\r\U0002100f", // 𡀏
	0x21010: "\x1e\r\U00021010", // 𡀐
	0x21011: "\x1e\r\U00021011", // 𡀑
	0x21012: "\x1e\r\U00021012", // 𡀒
	0x21013: "\x1e\r\U00021013", // 𡀓
	0x21014: "\x1e\f\U00021014", // 𡀔
	0x21015: "\x1e\r\U00021015", // 𡀕
	0x21016: "\x1e\r\U00021016", // 𡀖
	0x21017: "\x1e\r\U00021017", // 𡀗
	0x21018: "\x1e\r\U00021018", // 𡀘
	0x21019: "\x1e\r\U00021019", // 𡀙
	0x2101a: "\x1e\r\U0002101a", // 𡀚
	0x2101b: "\x1e\r\U0002101b", // 𡀛
	0x2101c: "\x1e\r\U0002101c", // 𡀜
	0x2101d: "\x1e\r\U0002101d", // 𡀝
	0x2101e: "\x1e\r\U0002101e", // 𡀞
	0x2101f: "\x1e\r\U0002101f", // 𡀟
	0x21020: "\x1e\r\U00021020", // 𡀠
	0x21021: "\x1e\r\U00021021", // 𡀡
	0x21022: "\x1e\r\U00021022", // 𡀢
	0x21023: "\x1e\r\U00021023", // 𡀣
	0x21024: "\x1e\r\U00021024", // 𡀤
	0x21025: "\x1e\r\U00021025", // 𡀥
	0x21026: "\x1e\f\U00021026", // 𡀦
	0x21027: "\x1e\r\U00021027", // 𡀧
	0x21028: "\x1e\r\U00021028", // 𡀨
	0x21029: "\x1e\r\U00021029", // 𡀩
	0x2102a: "\x1e\r\U0002102a", // 𡀪
	0x2102b: "\x1e\r\U0002102b", // 𡀫
	0x2102c: "\x1e\r\U0002102c", // 𡀬
	0x2102d: "\x1e\r\U0002102d", // 𡀭
	0x2102e: "\x1e\r\U0002102e", // 𡀮
	0x2102f: "\x1e\r\U0002102f", // 𡀯
	0x21030: "\x1e\r\U00021030", // 𡀰
	0x21031: "\x1e\r\U00021031", // 𡀱
	0x21032: "\x1e\r\U00021032", // 𡀲
	0x21033: "\x1e\r\U00021033", // 𡀳
	0x21034: "\x1e\r\U00021034", // 𡀴
	0x21035: "\x1e\r\U00021035", // 𡀵
	0x21036: "\x1e\r\U00021036", // 𡀶
	0x21037: "\x1e\r\U00021037", // 𡀷
	0x21038: "\x1e\r\U00021038", // 𡀸
	0x21039: "\x1e\r\U00021039", // 𡀹
	0x2103a: "\x1e\r\U0002103a", // 𡀺
	0x2103b: "\x1e\r\U0002103b", // 𡀻
	0x2103c: "\x1e\r\U0002103c", // 𡀼
	0x2103d: "\x1e\x0e\U0002103d", // 𡀽
	0x2103e: "\x1e\x0e\U0002103e", // 𡀾
	0x2103f: "\x1e\x0e\U0002103f", // 𡀿
	0x21040: "\x1e\x0e\U00021040", // 𡁀
	0x21041: "\x1e\x0e\U00021041", // 𡁁
	0x21042: "\x1e\x0e\U00021042", // 𡁂
	0x21043: "\x1e\x0e\U00021043", // 𡁃
	0x21044: "\x1e\x0e\U00021044", // 𡁄
	0x21045: "\x1e\x0e\U00021045", // 𡁅
	0x21046: "\x1e\x0e\U00021046", // 𡁆
	0x21047: "\x1e\x0e\U00021047", // 𡁇
	0x21048: "\x1e\x0e\U00021048", // 𡁈
	0x21049: "\x1e\x0e\U00021049", // 𡁉
	0x2104a: "\x1e\x0e\U0002104a", // 𡁊
	0x2104b: "\x1e\x0e\U0002104b", // 𡁋
	0x2104c: "\x1e\x0e\U0002104c", // 𡁌
	0x2104d: "\x1e\x0e\U0002104d", // 𡁍
	0x2104e: "\x1e\x0e\U0002104e", // 𡁎
	0x2104f: "\x1e\x0e\U0002104f", // 𡁏
	0x21050: "\x1e\x0e\U00021050", // 𡁐
	0x21051: "\x1e\x0e\U00021051", // 𡁑
	0x21052: "\x1e\x0e\U00021052", // 𡁒
	0x21053: "\x1e\x0e\U00021053", // 𡁓
	0x21054: "\x1e\x0e\U00021054", // 𡁔
	0x21055: "\x1e\x0e\U00021055", // 𡁕
	0x21056: "\x1e\x0e\U00021056", // 𡁖
	0x21057: "\x1e\x0e\U00021057", // 𡁗
	0x21058: "\x1e\x0e\U00021058", // 𡁘
	0x21059: "\x1e\x0e\U00021059", // 𡁙
	0x2105a: "\x1e\x0e\U0002105a", // 𡁚
	0x2105b: "\x1e\x0e\U0002105b", // 𡁛
	0x2105c: "\x1e\x0e\U0002105c", // 𡁜
	0x2105d: "\x1e\x0e\U0002105d", // 𡁝
	0x2105e: "\x1e\x0e\U0002105e", // 𡁞
	0x2105f: "\x1e\x0e\U0002105f", // 𡁟
	0x21060: "\x1e\x0e\U00021060", // 𡁠
	0x21061: "\x1e\x0e\U00021061", // 𡁡
	0x21062: "\x1e\x0e\U00021062", // 𡁢
	0x21063: "\x1e\x0e\U00021063", // 𡁣
	0x21064: "\x1e\x0e\U00021064", // 𡁤
	0x21065: "\x1e\x0e\U00021065", // 𡁥
	0x21066: "\x1e\x0e\U00021066", // 𡁦
	0x21067: "\x1e\x0e\U00021067", // 𡁧
	0x21068: "\x1e\x0e\U00021068", // 𡁨
	0x21069: "\x1e\x0e\U00021069", // 𡁩
	0x2106a: "\x1e\x0e\U0002106a", // 𡁪
	0x2106b: "\x1e\x0e\U0002106b", // 𡁫
	0x2106c: "\x1e\x0e\U0002106c", // 𡁬
	0x2106d: "\x1e\x0e\U0002106d", // 𡁭
	0x2106e: "\x1e\x0e\U0002106e", // 𡁮
	0x2106f: "\x1e\x0e\U0002106f", // 𡁯
	0x21070: "\x1e\x0e\U00021070", // 𡁰
	0x21071: "\x1e\x0e\U00021071", // 𡁱
	0x21072: "\x1e\x0e\U00021072", // 𡁲
	0x21073: "\x1e\x0e\U00021073", // 𡁳
	0x21074: "\x1e\x0e\U00021074", // 𡁴
	0x21075: "\x1e\x0e\U00021075", // 𡁵
	0x21076: "\x1e\x0e\U00021076", // 𡁶
	0x21077: "\x1e\x0e\U00021077", // 𡁷
	0x21078: "\x1e\x0e\U00021078", // 𡁸
	0x21079: "\x1e\x0e\U00021079", // 𡁹
	0x2107a: "\x1e\x0e\U0002107a", // 𡁺
	0x2107b: "\x1e\x0e\U0002107b", // 𡁻
	0x2107c: "\x1e\x0e\U0002107c", // 𡁼
	0x2107d: "\x1e\x0e\U0002107d", // 𡁽
	0x2107e: "\x1e\x0e\U0002107e", // 𡁾
	0x2107f: "\x1e\x0e\U0002107f", // 𡁿
	0x21080: "\x1e\x0e\U00021080", // 𡂀
	0x21081: "\x1e\x0e\U00021081", // 𡂁
	0x21082: "\x1e\x0e\U00021082", // 𡂂
	0x21083: "\x1e\x0e\U00021083", // 𡂃
	0x21084: "\x1e\x0e\U00021084", // 𡂄
	0x21085: "\x1e\x0e\U00021085", // 𡂅
	0x21086: "\x1e\x0e\U00021086", // 𡂆
	0x21087: "\x1e\x0e\U00021087", // 𡂇
	0x21088: "\x1e\x0e\U00021088", // 𡂈
	0x21089: "\x1e\x0e\U00021089", // 𡂉
	0x2108a: "\x1e\x0e\U0002108a", // 𡂊
	0x2108b: "\x1e\x0e\U0002108b", // 𡂋
	0x2108c: "\x1e\x0e\U0002108c", // 𡂌
	0x2108d: "\x1e\x0e\U0002108d", // 𡂍
	0x2108e: "\x1e\x0e\U0002108e", // 𡂎
	0x2108f: "\x1e\x0f\U0002108f", // 𡂏
	0x21090: "\x1e\x0f\U00021090", // 𡂐
	0x21091: "\x1e\x0f\U00021091", // 𡂑
	0x21092: "\x1e\x0f\U00021092", // 𡂒
	0x21093: "\x1e\x0f\U00021093", // 𡂓
	0x21094: "\x1e\x0f\U00021094", // 𡂔
	0x21095: "\x1e\x0f\U00021095", // 𡂕
	0x21096: "\x1e\x0f\U00021096", // 𡂖
	0x21097: "\x1e\x0f\U00021097", // 𡂗
	0x21098: "\x1e\x0f\U00021098", // 𡂘
	0x21099: "\x1e\x0f\U00021099", // 𡂙
	0x2109a: "\x1e\x0f\U0002109a", // 𡂚
	0x2109b: "\x1e\x0f\U0002109b", // 𡂛
	0x2109c: "\x1e\x0f\U0002109c", // 𡂜
	0x2109d: "\x1e\x0f\U0002109d", // 𡂝
	0x2109e: "\x1e\x0f\U0002109e", // 𡂞
	0x2109f: "\x1e\x0f\U0002109f", // 𡂟
	0x210a0: "\x1e\x0f\U000210a0", // 𡂠
	0x210a1: "\x1e\x0f\U000210a1", // 𡂡
	0x210a2: "\x1e\x0f\U000210a2", // 𡂢
	0x210a3: "\x1e\x0f\U000210a3", // 𡂣
	0x210a4: "\x1e\x0f\U000210a4", // 𡂤
	0x210a5: "\x1e\x0f\U000210a5", // 𡂥
	0x210a6: "\x1e\x0f\U000210a6", // 𡂦
	0x210a7: "\x1e\x0f\U000210a7", // 𡂧
	0x210a8: "\x1e\x0f\U000210a8", // 𡂨
	0x210a9: "\x1e\x0f\U000210a9", // 𡂩
	0x210aa: "\x1e\x0f\U000210aa", // 𡂪
	0x210ab: "\x1e\x0f\U000210ab", // 𡂫
	0x210ac: "\x1e\x0f\U000210ac", // 𡂬
	0x210ad: "\x1e\x0f\U000210ad", // 𡂭
	0x210ae: "\x1e\x0f\U000210ae", // 𡂮
	0x210af: "\x1e\x0f\U000210af", // 𡂯
	0x210b0: "\x1e\x0f\U000210b0", // 𡂰
	0x210b1: "\x1e\x0f\U000210b1", // 𡂱
	0x210b2: "\x1e\x0f\U000210b2", // 𡂲
	0x210b3: "\x1e\x0f\U000210b3", // 𡂳
	0x210b4: "\x1e\x0f\U000210b4", // 𡂴
	0x210b5: "\x1e\x0f\U000210b5", // 𡂵
	0x210b6: "\x1e\x0f\U000210b6", // 𡂶
	0x210b7: "\x1e\x0f\U000210b7", // 𡂷
	0x210b8: "\x1e\x0f\U000210b8", // 𡂸
	0x210b9: "\x1e\x0f\U000210b9", // 𡂹
	0x210ba: "\x1e\x0f\U000210ba", // 𡂺
	0x210bb: "\x1e\x0f\U000210bb", // 𡂻
	0x210bc: "\x1e\x0f\U000210bc", // 𡂼
	0x210bd: "\x1e\x0f\U000210bd", // 𡂽
	0x210be: "\x1e\x0f\U000210be", // 𡂾
	0x210bf: "\x1e\x0f\U000210bf", // 𡂿
	0x210c0: "\x1e\x0f\U000210c0", // 𡃀
	0x210c1: "\x1e\x0f\U000210c1", // 𡃁
	0x210c2: "\x1e\x0f\U000210c2", // 𡃂
	0x210c3: "\x1e\x0f\U000210c3", // 𡃃
	0x210c4: "\x1e\x0f\U000210c4", // 𡃄
	0x210c5: "\x1e\x0f\U000210c5", // 𡃅
	0x210c6: "\x1e\x0f\U000210c6", // 𡃆
	0x210c7: "\x1e\x0f\U000210c7", // 𡃇
	0x210c8: "\x1e\x0f\U000210c8", // 𡃈
	0x210c9: "\x1e\x0f\U000210c9", // 𡃉
	0x210ca: "\x1e\x0f\U000210ca", // 𡃊
	0x210cb: "\x1e\x0f\U000210cb", // 𡃋
	0x210cc: "\x1e\x0f\U000210cc", // 𡃌
	0x210cd: "\x1e\x0f\U000210cd", // 𡃍
	0x210ce: "\x1e\x0f\U000210ce", // 𡃎
	0x210cf: "\x1e\x0f\U000210cf", // 𡃏
	0x210d0: "\x1e\x0f\U000210d0", // 𡃐
	0x210d1: "\x1e\x0f\U000210d1", // 𡃑
	0x210d2: "\x1e\x0f\U000210d2", // 𡃒
	0x210d3: "\x1e\x0f\U000210d3", // 𡃓
	0x210d4: "\x1e\x0f\U000210d4", // 𡃔
	0x210d5: "\x1e\x0f\U000210d5", // 𡃕
	0x210d6: "\x1e\x0f\U000210d6", // 𡃖
	0x210d7: "\x1e\x0f\U000210d7", // 𡃗
	0x210d8: "\x1e\x0f\U000210d8", // 𡃘
	0x210d9: "\x1e\x0f\U000210d9", // 𡃙
	0x210da: "\x1e\x0f\U000210da", // 𡃚
	0x210db: "\x1e\x0f\U000210db", // 𡃛
	0x210dc: "\x1e\x0f\U000210dc", // 𡃜
	0x210dd: "\x1e\x0f\U000210dd", // 𡃝
	0x210de: "\x1e\x0f\U000210de", // 𡃞
	0x210df: "\x1e\x0f\U000210df", // 𡃟
	0x210e0: "\x1e\x10\U000210e0", // 𡃠
	0x210e1: "\x1e\x10\U000210e1", // 𡃡
	0x210e2: "\x1e\x10\U000210e2", // 𡃢
	0x210e3: "\x1e\x10\U000210e3", // 𡃣
	0x210e4: "\x1e\x10\U000210e4", // 𡃤
	0x210e5: "\x1e\x10\U000210e5", // 𡃥
	0x210e6: "\x1e\x10\U000210e6", // 𡃦
	0x210e7: "\x1e\x10\U000210e7", // 𡃧
	0x210e8: "\x1e\x10\U000210e8", // 𡃨
	0x210e9: "\x1e\x10\U000210e9", // 𡃩
	0x210ea: "\x1e\x10\U000210ea", // 𡃪
	0x210eb: "\x1e\x10\U000210eb", // 𡃫
	0x210ec: "\x1e\x10\U000210ec", // 𡃬
	0x210ed: "\x1e\x10\U000210ed", // 𡃭
	0x210ee: "\x1e\x10\U000210ee", // 𡃮
	0x210ef: "\x1e\x10\U000210ef", // 𡃯
	0x210f0: "\x1e\x0f\U000210f0", // 𡃰
	0x210f1: "\x1e\x10\U000210f1", // 𡃱
	0x210f2: "\x1e\x10\U000210f2", // 𡃲
	0x210f3: "\x1e\x10\U000210f3", // 𡃳
	0x210f4: "\x1e\x10\U000210f4", // 𡃴
	0x210f5: "\x1e\x10\U000210f5", // 𡃵
	0x210f6: "\x1e\x10\U000210f6", // 𡃶
	0x210f7: "\x1e\x10\U000210f7", // 𡃷
	0x210f8: "\x1e\x10\U000210f8", // 𡃸
	0x210f9: "\x1e\x10\U000210f9", // 𡃹
	0x210fa: "\x1e\x10\U000210fa", // 𡃺
	0x210fb: "\x1e\x10\U000210fb", // 𡃻
	0x210fc: "\x1e\x10\U000210fc", // 𡃼
	0x210fd: "\x1e\x10\U000210fd", // 𡃽
	0x210fe: "\x1e\x10\U000210fe", // 𡃾
	0x210ff: "\x1e\x10\U000210ff", // 𡃿
	0x21100: "\x1e\x10\U00021100", // 𡄀
	0x21101: "\x1e\x10\U00021101", // 𡄁
	0x21102: "\x1e\x10\U00021102", // 𡄂
	0x21103: "\x1e\x10\U00021103", // 𡄃
	0x21104: "\x1e\x10\U00021104", // 𡄄
	0x21105: "\x1e\x10\U00021105", // 𡄅
	0x21106: "\x1e\x10\U00021106", // 𡄆
	0x21107: "\x1e\x10\U00021107", // 𡄇
	0x21108: "\x1e\x10\U00021108", // 𡄈
	0x21109: "Y\x0f\U00021109", // 𡄉
	0x2110a: "\x1e\x10\U0002110a", // 𡄊
	0x2110b: "\x1e\x10\U0002110b", // 𡄋
	0x2110c: "\x1e\x10\U0002110c", // 𡄌
	0x2110d: "\x1e\x10\U0002110d", // 𡄍
	0x2110e: "\x1e\x10\U0002110e", // 𡄎
	0x2110f: "\x1e\x10\U0002110f", // 𡄏
	0x21110: "\x1e\x10\U00021110", // 𡄐
	0x21111: "\x1e\x11\U00021111", // 𡄑
	0x21112: "\x1e\x11\U00021112", // 𡄒
	0x21113: "\x1e\x11\U00021113", // 𡄓
	0x21114: "\x1e\x11\U00021114", // 𡄔
	0x21115: "\x1e\x11\U00021115", // 𡄕
	0x21116: "\x1e\x11\U00021116", // 𡄖
	0x21117: "\x1e\x11\U00021117", // 𡄗
	0x21118: "\x1e\x11\U00021118", // 𡄘
	0x21119: "\x1e\x11\U00021119", // 𡄙
	0x2111a: "\x1e\x11\U0002111a", // 𡄚
	0x2111b: "\x1e\x11\U0002111b", // 𡄛
	0x2111c: "\x1e\x11\U0002111c", // 𡄜
	0x2111d: "\x1e\x11\U0002111d", // 𡄝
	0x2111e: "\x1e\x11\U0002111e", // 𡄞
	0x2111f: "\x1e\x11\U0002111f", // 𡄟
	0x21120: "\x1e\x11\U00021120", // 𡄠
	0x21121: "\x1e\x11\U00021121", // 𡄡
	0x21122: "\x1e\x11\U00021122", // 𡄢
	0x21123: "\x1e\x11\U00021123", // 𡄣
	0x21124: "\x1e\x11\U00021124", // 𡄤
	0x21125: "\x1e\x11\U00021125", // 𡄥
	0x21126: "\x1e\x11\U00021126", // 𡄦
	0x21127: "\x1e\x11\U00021127", // 𡄧
	0x21128: "\x1e\x11\U00021128", // 𡄨
	0x21129: "\x1e\x11\U00021129", // 𡄩
	0x2112a: "\x1e\x11\U0002112a", // 𡄪
	0x2112b: "\x1e\x11\U0002112b", // 𡄫
	0x2112c: "\x1e\x11\U0002112c", // 𡄬
	0x2112d: "\x1e\x11\U0002112d", // 𡄭
	0x2112e: "\x1e\x11\U0002112e", // 𡄮
	0x2112f: "\x1e\x11\U0002112f", // 𡄯
	0x21130: "\x1e\x11\U00021130", // 𡄰
	0x21131: "\x1e\x12\U00021131", // 𡄱
	0x21132: "\x1e\x12\U00021132", // 𡄲
	0x21133: "\x1e\x12\U00021133", // 𡄳
	0x21134: "\x1e\x12\U00021134", // 𡄴
	0x21135: "\x1e\x12\U00021135", // 𡄵
	0x21136: "\x1e\x12\U00021136", // 𡄶
	0x21137: "\x1e\x12\U00021137", // 𡄷
	0x21138: "\x1e\x12\U00021138", // 𡄸
	0x21139: "\x1e\x12\U00021139", // 𡄹
	0x2113a: "\x1e\x12\U0002113a", // 𡄺
	0x2113b: "\x1e\x12\U0002113b", // 𡄻
	0x2113c: "\x1e\x12\U0002113c", // 𡄼
	0x2113d: "\x1e\x12\U0002113d", // 𡄽
	0x2113e: "\x1e\x12\U0002113e", // 𡄾
	0x2113f: "\x1e\x12\U0002113f", // 𡄿
	0x21140: "\x1e\x12\U00021140", // 𡅀
	0x21141: "\x1e\x12\U00021141", // 𡅁
	0x21142: "\x1e\x12\U00021142", // 𡅂
	0x21143: "\x1e\x12\U00021143", // 𡅃
	0x21144: "\x1e\x12\U00021144", // 𡅄
	0x21145: "\x1e\x12\U00021145", // 𡅅
	0x21146: "\x1e\x12\U00021146", // 𡅆
	0x21147: "\x1e\x12\U00021147", // 𡅇
	0x21148: "\x1e\x12\U00021148", // 𡅈
	0x21149: "\x1e\x12\U00021149", // 𡅉
	0x2114a: "\x1e\x12\U0002114a", // 𡅊
	0x2114b: "\x1e\x12\U0002114b", // 𡅋
	0x2114c: "\x1e\x12\U0002114c", // 𡅌
	0x2114d: "\x1e\x12\U0002114d", // 𡅍
	0x2114e: "\x1e\x12\U0002114e", // 𡅎
	0x2114f: "\x1e\x12\U0002114f", // 𡅏
	0x21150: "\x1e\x12\U00021150", // 𡅐
	0x21151: "\x1e\x12\U00021151", // 𡅑
	0x21152: "\x1e\x12\U00021152", // 𡅒
	0x21153: "\x1e\x12\U00021153", // 𡅓
	0x21154: "\x1e\x12\U00021154", // 𡅔
	0x21155: "!\x12\U00021155", // 𡅕
	0x21156: "{\x0f\U00021156", // 𡅖
	0x21157: "\x1e\x13\U00021157", // 𡅗
	0x21158: "\x1e\x13\U00021158", // 𡅘
	0x21159: "\x1e\x13\U00021159", // 𡅙
	0x2115a: "\x1e\x13\U0002115a", // 𡅚
	0x2115b: "\x1e\x13\U0002115b", // 𡅛
	0x2115c: "\x1e\x13\U0002115c", // 𡅜
	0x2115d: "\x1e\x13\U0002115d", // 𡅝
	0x2115e: "\x1e\x13\U0002115e", // 𡅞
	0x2115f: "\x1e\x13\U0002115f", // 𡅟
	0x21160: "\x1e\x13\U00021160", // 𡅠
	0x21161: "\x1e\x13\U00021161", // 𡅡
	0x21162: "\x1e\x13\U00021162", // 𡅢
	0x21163: "\x1e\x12\U00021163", // 𡅣
	0x21164: "\x1e\x13\U00021164", // 𡅤
	0x21165: "\x1e\x13\U00021165", // 𡅥
	0x21166: "\x1e\x13\U00021166", // 𡅦
	0x21167: "\x1e\x13\U00021167", // 𡅧
	0x21168: "\x1e\x13\U00021168", // 𡅨
	0x21169: "\x1e\x13\U00021169", // 𡅩
	0x2116a: "\x1e\x13\U0002116a", // 𡅪
	0x2116b: "\x1e\x13\U0002116b", // 𡅫
	0x2116c: "\x1e\x13\U0002116c", // 𡅬
	0x2116d: "\x1e\x13\U0002116d", // 𡅭
	0x2116e: "\x1e\x13\U0002116e", // 𡅮
	0x2116f: "\x1e\x13\U0002116f", // 𡅯
	0x21170: "\x1e\x14\U00021170", // 𡅰
	0x21171: "\x1e\x14\U00021171", // 𡅱
	0x21172: "\x1e\x14\U00021172", // 𡅲
	0x21173: "\x1e\x14\U00021173", // 𡅳
	0x21174: "\x1e\x14\U00021174", // 𡅴
	0x21175: "\x1e\x14\U00021175", // 𡅵
	0x21176: "\x1e\x14\U00021176", // 𡅶
	0x21177: "\x1e\x14\U00021177", // 𡅷
	0x21178: "\x1e\x14\U00021178", // 𡅸
	0x21179: "\x1e\x15\U00021179", // 𡅹
	0x2117a: "\x1e\x15\U0002117a", // 𡅺
	0x2117b: "\x1e\x15\U0002117b", // 𡅻
	0x2117c: "\x1e\x15\U0002117c", // 𡅼
	0x2117d: "\x1e\x15\U0002117d", // 𡅽
	0x2117e: "\x1e\x15\U0002117e", // 𡅾
	0x2117f: "\x1e\x15\U0002117f", // 𡅿
	0x21180: "\x1e\x15\U00021180", // 𡆀
	0x21181: "\x1e\x15\U00021181", // 𡆁
	0x21182: "\x1e\x15\U00021182", // 𡆂
	0x21183: "\x1e\x15\U00021183", // 𡆃
	0x21184: "\x1e\x15\U00021184", // 𡆄
	0x21185: "\x1e\x15\U00021185", // 𡆅
	0x21186: "\x1e\x16\U00021186", // 𡆆
	0x21187: "\x1e\x16\U00021187", // 𡆇
	0x21188: "\x1e\x16\U00021188", // 𡆈
	0x21189: "\x1e\x16\U00021189", // 𡆉
	0x2118a: "\x1e\x16\U0002118a", // 𡆊
	0x2118b: "\x1e\x16\U0002118b", // 𡆋
	0x2118c: "\x1e\x16\U0002118c", // 𡆌
	0x2118d: "\x1e\x16\U0002118d", // 𡆍
	0x2118e: "\x1e\x16\U0002118e", // 𡆎
	0x2118f: "\x1e\x17\U0002118f", // 𡆏
	0x21190: "\x1e\x17\U00021190", // 𡆐
	0x21191: "\x1e\x17\U00021191", // 𡆑
	0x21192: "\x1e\x17\U00021192", // 𡆒
	0x21193: "\x1e\x17\U00021193", // 𡆓
	0x21194: "\x1e\x17\U00021194", // 𡆔
	0x21195: "\x1e\x17\U00021195", // 𡆕
	0x21196: "\x1e\x17\U00021196", // 𡆖
	0x21197: "\x1e\x17\U00021197", // 𡆗
	0x21198: "\x1e\x17\U00021198", // 𡆘
	0x21199: "\x1e\x18\U00021199", // 𡆙
	0x2119a: "\x1e\x18\U0002119a", // 𡆚
	0x2119b: "\x1e\x19\U0002119b", // 𡆛
	0x2119c: "\x1e\x19\U0002119c", // 𡆜
	0x2119d: "\x1e\x19\U0002119d", // 𡆝
	0x2119e: "\x1e\x18\U0002119e", // 𡆞
	0x2119f: "\x1e\x1c\U0002119f", // 𡆟
	0x211a0: "\x1f\x01\U000211a0", // 𡆠
	0x211a1: "\x1f\x01\U000211a1", // 𡆡
	0x211a2: "\x1f\x01\U000211a2", // 𡆢
	0x211a3: "\x1f\x02\U000211a3", // 𡆣
	0x211a4: "\x1f\x02\U000211a4", // 𡆤
	0x211a5: "\x1f\x02\U000211a5", // 𡆥
	0x211a6: "\x1f\x02\U000211a6", // 𡆦
	0x211a7: "\x1f\x03\U000211a7", // 𡆧
	0x211a8: "\x1f\x03\U000211a8", // 𡆨
	0x211a9: "\x1f\x03\U000211a9", // 𡆩
	0x211aa: "\x1f\x03\U000211aa", // 𡆪
	0x211ab: "\x1f\x03\U000211ab", // 𡆫
	0x211ac: "\x1f\x03\U000211ac", // 𡆬
	0x211ad: "\x1f\x03\U000211ad", // 𡆭
	0x211ae: "\x1f\x03\U000211ae", // 𡆮
	0x211af: "\x1f\x03\U000211af", // 𡆯
	0x211b0: "\x1f\x03\U000211b0", // 𡆰
	0x211b1: "\x1f\x03\U000211b1", // 𡆱
	0x211b2: "\x1f\x03\U000211b2", // 𡆲
	0x211b3: "\x1f\x03\U000211b3", // 𡆳
	0x211b4: "\x1f\x04\U000211b4", // 𡆴
	0x211b5: "\x1f\x04\U000211b5", // 𡆵
	0x211b6: "\x1f\x04\U000211b6", // 𡆶
	0x211b7: "\x1f\x04\U000211b7", // 𡆷
	0x211b8: "\x1f\x04\U000211b8", // 𡆸
	0x211b9: "\x1f\x04\U000211b9", // 𡆹
	0x211ba: "\x1f\x04\U000211ba", // 𡆺
	0x211bb: "\x1f\x04\U000211bb", // 𡆻
	0x211bc: "\x1f\x04\U000211bc", // 𡆼
	0x211bd: "\x1f\x04\U000211bd", // 𡆽
	0x211be: "\x1f\x04\U000211be", // 𡆾
	0x211bf: "\x1f\x04\U000211bf", // 𡆿
	0x211c0: "\x1f\x04\U000211c0", // 𡇀
	0x211c1: "\x1f\x04\U000211c1", // 𡇁
	0x211c2: "\x1f\x04\U000211c2", // 𡇂
	0x211c3: "\x1f\x04\U000211c3", // 𡇃
	0x211c4: "\x1f\x04\U000211c4", // 𡇄
	0x211c5: "\x1f\x04\U000211c5", // 𡇅
	0x211c6: "\x1f\x04\U000211c6", // 𡇆
	0x211c7: "\x1f\x04\U000211c7", // 𡇇
	0x211c8: "\x1f\x05\U000211c8", // 𡇈
	0x211c9: "\x1f\x05\U000211c9", // 𡇉
	0x211ca: "\x1f\x05\U000211ca", // 𡇊
	0x211cb: "\x1f\x05\U000211cb", // 𡇋
	0x211cc: "\x1f\x05\U000211cc", // 𡇌
	0x211cd: "f\x03\U000211cd", // 𡇍
	0x211ce: "\x1f\x05\U000211ce", // 𡇎
	0x211cf: "\x1f\x05\U000211cf", // 𡇏
	0x211d0: "\x1f\x05\U000211d0", // 𡇐
	0x211d1: "\x1f\x05\U000211d1", // 𡇑
	0x211d2: "\x1f\x06\U000211d2", // 𡇒
	0x211d3: "\x1f\x06\U000211d3", // 𡇓
	0x211d4: "\x1f\x06\U000211d4", // 𡇔
	0x211d5: "\x1f\x06\U000211d5", // 𡇕
	0x211d6: "\x1f\x06\U000211d6", // 𡇖
	0x211d7: "\x1f\x06\U000211d7", // 𡇗
	0x211d8: "\x1f\x06\U000211d8", // 𡇘
	0x211d9: "\x1f\x06\U000211d9", // 𡇙
	0x211da: "\x1f\x06\U000211da", // 𡇚
	0x211db: "\x1f\x06\U000211db", // 𡇛
	0x211dc: "\x1f\x06\U000211dc", // 𡇜
	0x211dd: "\x1f\x06\U000211dd", // 𡇝
	0x211de: "\x1f\x06\U000211de", // 𡇞
	0x211df: "\x1f\x06\U000211df", // 𡇟
	0x211e0: "\x1f\a\U000211e0", // 𡇠
	0x211e1: "\x1f\a\U000211e1", // 𡇡
	0x211e2: "\x1f\a\U000211e2", // 𡇢
	0x211e3: "\x1f\a\U000211e3", // 𡇣
	0x211e4: "\x1f\a\U000211e4", // 𡇤
	0x211e5: "\x1f\a\U000211e5", // 𡇥
	0x211e6: "\x1f\a\U000211e6", // 𡇦
	0x211e7: "\x1f\a\U000211e7", // 𡇧
	0x211e8: "\x1f\a\U000211e8", // 𡇨
	0x211e9: "\x1f\a\U000211e9", // 𡇩
	0x211ea: "\x1f\a\U000211ea", // 𡇪
	0x211eb: "\x1f\a\U000211eb", // 𡇫
	0x211ec: "\x1f\a\U000211ec", // 𡇬
	0x211ed: "\x1f\a\U000211ed", // 𡇭
	0x211ee: "\x1f\a\U000211ee", // 𡇮
	0x211ef: "\x1f\a\U000211ef", // 𡇯
	0x211f0: "\x1f\b\U000211f0", // 𡇰
	0x211f1: "\x1f\b\U000211f1", // 𡇱
	0x211f2: "\x1f\b\U000211f2", // 𡇲
	0x211f3: "\x1f\b\U000211f3", // 𡇳
	0x211f4: "\x1f\b\U000211f4", // 𡇴
	0x211f5: "\x1f\b\U000211f5", // 𡇵
	0x211f6: "\x1f\b\U000211f6", // 𡇶
	0x211f7: "\x1f\b\U000211f7", // 𡇷
	0x211f8: "\x1f\b\U000211f8", // 𡇸
	0x211f9: "\x1f\b\U000211f9", // 𡇹
	0x211fa: "\x1f\b\U000211fa", // 𡇺
	0x211fb: "\x1f\b\U000211fb", // 𡇻
	0x211fc: "\x1f\t\U000211fc", // 𡇼
	0x211fd: "\x1f\t\U000211fd", // 𡇽
	0x211fe: "\x1f\t\U000211fe", // 𡇾
	0x211ff: "\x1f\t\U000211ff", // 𡇿
	0x21200: "\x1f\b\U00021200", // 𡈀
	0x21201: "\x1f\t\U00021201", // 𡈁
	0x21202: "\x1f\t\U00021202", // 𡈂
	0x21203: "\x1f\t\U00021203", // 𡈃
	0x21204: "\x1f\t\U00021204", // 𡈄
	0x21205: "\x1f\t\U00021205", // 𡈅
	0x21206: "\x1f\t\U00021206", // 𡈆
	0x21207: "\x1f\t\U00021207", // 𡈇
	0x21208: "\x1f\t\U00021208", // 𡈈
	0x21209: "\x1f\t\U00021209", // 𡈉
	0x2120a: "\x1f\n\U0002120a", // 𡈊
	0x2120b: "\x1f\n\U0002120b", // 𡈋
	0x2120c: "\x1f\n\U0002120c", // 𡈌
	0x2120d: "\x1f\n\U0002120d", // 𡈍
	0x2120e: "\x1f\n\U0002120e", // 𡈎
	0x2120f: "\x1f\n\U0002120f", // 𡈏
	0x21210: "\x1f\n\U00021210", // 𡈐
	0x21211: "\x1f\n\U00021211", // 𡈑
	0x21212: "\x1f\n\U00021212", // 𡈒
	0x21213: "\x1f\n\U00021213", // 𡈓
	0x21214: "\x1f\n\U00021214", // 𡈔
	0x21215: "\x1f\v\U00021215", // 𡈕
	0x21216: "\x1f\v\U00021216", // 𡈖
	0x21217: "\x1f\v\U00021217", // 𡈗
	0x21218: "\x1f\v\U00021218", // 𡈘
	0x21219: "\x1f\v\U00021219", // 𡈙
	0x2121a: "\x1f\v\U0002121a", // 𡈚
	0x2121b: "\x1f\v\U0002121b", // 𡈛
	0x2121c: "\x1f\v\U0002121c", // 𡈜
	0x2121d: "\x1f\v\U0002121d", // 𡈝
	0x2121e: "\x1f\v\U0002121e", // 𡈞
	0x2121f: "\x1f\v\U0002121f", // 𡈟
	0x21220: "\x1f\v\U00021220", // 𡈠
	0x21221: "\x1f\v\U00021221", // 𡈡
	0x21222: "\x1f\f\U00021222", // 𡈢
	0x21223: "\x1f\f\U00021223", // 𡈣
	0x21224: "\x1f\f\U00021224", // 𡈤
	0x21225: "\x1f\r\U00021225", // 𡈥
	0x21226: "\x1f\f\U00021226", // 𡈦
	0x21227: "\x1f\f\U00021227", // 𡈧
	0x21228: "\x1f\f\U00021228", // 𡈨
	0x21229: "\x1f\f\U00021229", // 𡈩
	0x2122a: "\x1f\r\U0002122a", // 𡈪
	0x2122b: "\x1f\r\U0002122b", // 𡈫
	0x2122c: "\x1f\r\U0002122c", // 𡈬
	0x2122d: "\x1f\x0e\U0002122d", // 𡈭
	0x2122e: "\x1f\x0e\U0002122e", // 𡈮
	0x2122f: "\x1f\x0e\U0002122f", // 𡈯
	0x21230: "\x1f\x0e\U00021230", // 𡈰
	0x21231: "\x1f\x0e\U00021231", // 𡈱
	0x21232: "\x1f\x0f\U00021232", // 𡈲
	0x21233: "\x1f\x10\U00021233", // 𡈳
	0x21234: "\x1f\x10\U00021234", // 𡈴
	0x21235: "\x1f\x11\U00021235", // 𡈵
	0x21236: "\x1f\x11\U00021236", // 𡈶
	0x21237: "\x1f\x11\U00021237", // 𡈷
	0x21238: "\x1f\x12\U00021238", // 𡈸
	0x21239: "\x1f\x12\U00021239", // 𡈹
	0x2123a: "\x1f\x12\U0002123a", // 𡈺
	0x2123b: "\x1f\x17\U0002123b", // 𡈻
	0x2123c: " \x01\U0002123c", // 𡈼
	0x2123d: " \x01\U0002123d", // 𡈽
	0x2123e: " \x01\U0002123e", // 𡈾
	0x2123f: " \x02\U0002123f", // 𡈿
	0x21240: " \x02\U00021240", // 𡉀
	0x21241: " \x02\U00021241", // 𡉁
	0x21242: " \x02\U00021242", // 𡉂
	0x21243: " \x02\U00021243", // 𡉃
	0x21244: " \x02\U00021244", // 𡉄
	0x21245: " \x02\U00021245", // 𡉅
	0x21246: " \x02\U00021246", // 𡉆
	0x21247: " \x02\U00021247", // 𡉇
	0x21248: " \x03\U00021248", // 𡉈
	0x21249: " \x03\U00021249", // 𡉉
	0x2124a: " \x03\U0002124a", // 𡉊
	0x2124b: " \x03\U0002124b", // 𡉋
	0x2124c: " \x03\U0002124c", // 𡉌
	0x2124d: " \x03\U0002124d", // 𡉍
	0x2124e: " \x03\U0002124e", // 𡉎
	0x2124f: " \x03\U0002124f", // 𡉏
	0x21250: " \x03\U00021250", // 𡉐
	0x21251: " \x03\U00021251", // 𡉑
	0x21252: " \x03\U00021252", // 𡉒
	0x21253: " \x03\U00021253", // 𡉓
	0x21254: " \x03\U00021254", // 𡉔
	0x21255: " \x03\U00021255", // 𡉕
	0x21256: " \x03\U00021256", // 𡉖
	0x21257: "'\x03\U00021257", // 𡉗
	0x21258: " \x04\U00021258", // 𡉘
	0x21259: " \x04\U00021259", // 𡉙
	0x2125a: " \x04\U0002125a", // 𡉚
	0x2125b: " \x04\U0002125b", // 𡉛
	0x2125c: " \x04\U0002125c", // 𡉜
	0x2125d: " \x04\U0002125d", // 𡉝
	0x2125e: " \x04\U0002125e", // 𡉞
	0x2125f: " \x04\U0002125f", // 𡉟
	0x21260: " \x04\U00021260", // 𡉠
	0x21261: " \x04\U00021261", // 𡉡
	0x21262: " \x04\U00021262", // 𡉢
	0x21263: " \x04\U00021263", // 𡉣
	0x21264: " \x04\U00021264", // 𡉤
	0x21265: " \x04\U00021265", // 𡉥
	0x21266: " \x04\U00021266", // 𡉦
	0x21267: " \x04\U00021267", // 𡉧
	0x21268: " \x04\U00021268", // 𡉨
	0x21269: " \x04\U00021269", // 𡉩
	0x2126a: " \x04\U0002126a", // 𡉪
	0x2126b: " \x04\U0002126b", // 𡉫
	0x2126c: " \x04\U0002126c", // 𡉬
	0x2126d: " \x04\U0002126d", // 𡉭
	0x2126e: " \x04\U0002126e", // 𡉮
	0x2126f: " \x04\U0002126f", // 𡉯
	0x21270: " \x04\U00021270", // 𡉰
	0x21271: " \x04\U00021271", // 𡉱
	0x21272: " \x04\U00021272", // 𡉲
	0x21273: " \x04\U00021273", // 𡉳
	0x21274: " \x04\U00021274", // 𡉴
	0x21275: " \x04\U00021275", // 𡉵
	0x21276: " \x04\U00021276", // 𡉶
	0x21277: " \x04\U00021277", // 𡉷
	0x21278: " \x04\U00021278", // 𡉸
	0x21279: " \x04\U00021279", // 𡉹
	0x2127a: " \x04\U0002127a", // 𡉺
	0x2127b: " \x04\U0002127b", // 𡉻
	0x2127c: " \x04\U0002127c", // 𡉼
	0x2127d: " \x04\U0002127d", // 𡉽
	0x2127e: " \x04\U0002127e", // 𡉾
	0x2127f: " \x04\U0002127f", // 𡉿
	0x21280: " \x04\U00021280", // 𡊀
	0x21281: " \x04\U00021281", // 𡊁
	0x21282: " \x04\U00021282", // 𡊂
	0x21283: " \x04\U00021283", // 𡊃
	0x21284: " \x05\U00021284", // 𡊄
	0x21285: " \x05\U00021285", // 𡊅
	0x21286: " \x05\U00021286", // 𡊆
	0x21287: " \x05\U00021287", // 𡊇
	0x21288: " \x05\U00021288", // 𡊈
	0x21289: " \x05\U00021289", // 𡊉
	0x2128a: " \x05\U0002128a", // 𡊊
	0x2128b: " \x05\U0002128b", // 𡊋
	0x2128c: " \x05\U0002128c", // 𡊌
	0x2128d: " \x05\U0002128d", // 𡊍
	0x2128e: " \x05\U0002128e", // 𡊎
	0x2128f: " \x05\U0002128f", // 𡊏
	0x21290: " \x05\U00021290", // 𡊐
	0x21291: " \x05\U00021291", // 𡊑
	0x21292: " \x05\U00021292", // 𡊒
	0x21293: " \x05\U00021293", // 𡊓
	0x21294: " \x05\U00021294", // 𡊔
	0x21295: " \x05\U00021295", // 𡊕
	0x21296: " \x05\U00021296", // 𡊖
	0x21297: " \x05\U00021297", // 𡊗
	0x21298: " \x05\U00021298", // 𡊘
	0x21299: " \x05\U00021299", // 𡊙
	0x2129a: " \x05\U0002129a", // 𡊚
	0x2129b: " \x05\U0002129b", // 𡊛
	0x2129c: " \x05\U0002129c", // 𡊜
	0x2129d: " \x05\U0002129d", // 𡊝
	0x2129e: " \x05\U0002129e", // 𡊞
	0x2129f: " \x05\U0002129f", // 𡊟
	0x212a0: " \x05\U000212a0", // 𡊠
	0x212a1: " \x05\U000212a1", // 𡊡
	0x212a2: " \x05\U000212a2", // 𡊢
	0x212a3: " \x05\U000212a3", // 𡊣
	0x212a4: " \x05\U000212a4", // 𡊤
	0x212a5: " \x05\U000212a5", // 𡊥
	0x212a6: " \x05\U000212a6", // 𡊦
	0x212a7: " \x05\U000212a7", // 𡊧
	0x212a8: " \x05\U000212a8", // 𡊨
	0x212a9: " \x05\U000212a9", // 𡊩
	0x212aa: " \x05\U000212aa", // 𡊪
	0x212ab: " \x05\U000212ab", // 𡊫
	0x212ac: " \x05\U000212ac", // 𡊬
	0x212ad: " \x05\U000212ad", // 𡊭
	0x212ae: " \x05\U000212ae", // 𡊮
	0x212af: " \x05\U000212af", // 𡊯
	0x212b0: " \x05\U000212b0", // 𡊰
	0x212b1: " \x05\U000212b1", // 𡊱
	0x212b2: " \x05\U000212b2", // 𡊲
	0x212b3: " \x05\U000212b3", // 𡊳
	0x212b4: " \x05\U000212b4", // 𡊴
	0x212b5: " \x05\U000212b5", // 𡊵
	0x212b6: " \x05\U000212b6", // 𡊶
	0x212b7: " \x06\U000212b7", // 𡊷
	0x212b8: " \x06\U000212b8", // 𡊸
	0x212b9: " \x06\U000212b9", // 𡊹
	0x212ba: " \x06\U000212ba", // 𡊺
	0x212bb: " \x06\U000212bb", // 𡊻
	0x212bc: " \x06\U000212bc", // 𡊼
	0x212bd: " \x06\U000212bd", // 𡊽
	0x212be: " \x06\U000212be", // 𡊾
	0x212bf: " \x06\U000212bf", // 𡊿
	0x212c0: " \x06\U000212c0", // 𡋀
	0x212c1: " \x06\U000212c1", // 𡋁
	0x212c2: " \x06\U000212c2", // 𡋂
	0x212c3: " \x06\U000212c3", // 𡋃
	0x212c4: " \x06\U000212c4", // 𡋄
	0x212c5: " \x06\U000212c5", // 𡋅
	0x212c6: " \x06\U000212c6", // 𡋆
	0x212c7: " \x06\U000212c7", // 𡋇
	0x212c8: " \x06\U000212c8", // 𡋈
	0x212c9: " \x06\U000212c9", // 𡋉
	0x212ca: " \x06\U000212ca", // 𡋊
	0x212cb: " \x06\U000212cb", // 𡋋
	0x212cc: " \x06\U000212cc", // 𡋌
	0x212cd: " \x06\U000212cd", // 𡋍
	0x212ce: " \x06\U000212ce", // 𡋎
	0x212cf: " \x06\U000212cf", // 𡋏
	0x212d0: " \x06\U000212d0", // 𡋐
	0x212d1: " \x06\U000212d1", // 𡋑
	0x212d2: " \x06\U000212d2", // 𡋒
	0x212d3: " \x06\U000212d3", // 𡋓
	0x212d4: " \x06\U000212d4", // 𡋔
	0x212d5: " \x06\U000212d5", // 𡋕
	0x212d6: " \x06\U000212d6", // 𡋖
	0x212d7: " \x06\U000212d7", // 𡋗
	0x212d8: " \x06\U000212d8", // 𡋘
	0x212d9: " \x06\U000212d9", // 𡋙
	0x212da: " \x06\U000212da", // 𡋚
	0x212db: " \x06\U000212db", // 𡋛
	0x212dc: "\x82\x05\U000212dc", // 𡋜
	0x212dd: " \x06\U000212dd", // 𡋝
	0x212de: " \x06\U000212de", // 𡋞
	0x212df: " \x06\U000212df", // 𡋟
	0x212e0: " \x06\U000212e0", // 𡋠
	0x212e1: " \x06\U000212e1", // 𡋡
	0x212e2: " \x06\U000212e2", // 𡋢
	0x212e3: " \x06\U000212e3", // 𡋣
	0x212e4: " \x06\U000212e4", // 𡋤
	0x212e5: " \x06\U000212e5", // 𡋥
	0x212e6: " \x06\U000212e6", // 𡋦
	0x212e7: " \x06\U000212e7", // 𡋧
	0x212e8: " \x06\U000212e8", // 𡋨
	0x212e9: " \x06\U000212e9", // 𡋩
	0x212ea: " \x06\U000212ea", // 𡋪
	0x212eb: " \x06\U000212eb", // 𡋫
	0x212ec: " \x06\U000212ec", // 𡋬
	0x212ed: " \a\U000212ed", // 𡋭
	0x212ee: " \a\U000212ee", // 𡋮
	0x212ef: " \a\U000212ef", // 𡋯
	0x212f0: " \a\U000212f0", // 𡋰
	0x212f1: " \a\U000212f1", // 𡋱
	0x212f2: " \a\U000212f2", // 𡋲
	0x212f3: " \a\U000212f3", // 𡋳
	0x212f4: " \a\U000212f4", // 𡋴
	0x212f5: " \a\U000212f5", // 𡋵
	0x212f6: " \a\U000212f6", // 𡋶
	0x212f7: " \a\U000212f7", // 𡋷
	0x212f8: " \a\U000212f8", // 𡋸
	0x212f9: " \a\U000212f9", // 𡋹
	0x212fa: " \a\U000212fa", // 𡋺
	0x212fb: " \a\U000212fb", // 𡋻
	0x212fc: " \a\U000212fc", // 𡋼
	0x212fd: " \a\U000212fd", // 𡋽
	0x212fe: " \a\U000212fe", // 𡋾
	0x212ff: " \a\U000212ff", // 𡋿
	0x21300: " \a\U00021300", // 𡌀
	0x21301: " \a\U00021301", // 𡌁
	0x21302: " \a\U000213