/*
  This is the file ttf.h of the CJK macro package ver. 4.1.3
  (20-Jun-1997).
*/


#ifndef __TTF_H
#define __TTF__H

/*
   The names of the structures and its members are according to Microsoft's
   TT font reference manual, so you can learn the meaning of variables by
   reading the reference.
*/

#include "basic.h"
#include "bitmap.h"
#include "error.h"


typedef struct {
  BYTE valid;
  FWord xMin, yMin, xMax, yMax;
  SHORT numberOfCompGlyphs;
  SHORT *endCtrOfGlyphs;
  USHORT *endPtsOfContours;
  /* current point, contour, and glyph number
    (used for computation of composite glyphs) */
  USHORT curPoint;
  USHORT curContour;
  USHORT curGlyph;
  USHORT instructionLength;
  BYTE *instruction;
  BYTE *flags;
  LONG *xCoordinates;
  LONG *yCoordinates;
} OUTLINE;

#define FLAG_ON_CURVE       1
#define FLAG_X_SHORT_VECTOR 2
#define FLAG_Y_SHORT_VECTOR 4
#define FLAG_REPEAT         8
#define FLAG_X_SAME         0x10
#define FLAG_Y_SAME         0x20

/* composite font flags */

#define FLAG_ARG_WORD       1
#define FLAG_XY_VALUES      2
#define FLAG_ROUND          4
#define FLAG_SCALE          8
#define FLAG_RESERVED       0x10
#define FLAG_MORE_COMP      0x20
#define FLAG_XY_SCALE       0x40
#define FLAG_2X2_SCALE      0x80
#define FLAG_INSTR          0x100
#define FLAG_METRICS        0x200

 
typedef struct {
  Fixed fontRevision;
  USHORT flags;
  USHORT unitsPerEm;
  FWord xMin, yMin, xMax, yMax;
  USHORT macStyle;
  USHORT lowestRecPPEM;
  SHORT fontDirectionHint;
  SHORT indexToLocFormat;
  SHORT glyphDataFormat;
} HEAD;

typedef struct {
  uFWord advanceWidth;
  FWord lsb;
} HorMetric;

typedef struct {
  FWord ascender;
  FWord descender;
  FWord lineGap;
  uFWord advanceWidthMax;
  FWord minLeftSideBearing;
  FWord minRightSideBearing;
  FWord xMaxExtent;
  SHORT caretSlopeRise;
  SHORT caretSlopeRun;
  SHORT metricDataFormat;
  USHORT numberOfHMetrics;
  HorMetric *longHorMetrics;
  FWord *leftSideBearing;
} HORIZON;

typedef struct {
  USHORT numglyphs;
  USHORT maxPoints;
  USHORT maxContours;
  USHORT maxCompositePoints;
  USHORT maxCompositeContours;
  USHORT maxZones;
  USHORT maxTwilightPoints;
  USHORT maxStorage;
  USHORT maxFunctionDefs;
  USHORT maxInstructionDefs;
  USHORT maxStackElements;
  USHORT maxSizeOfInstructions;
  USHORT maxComponentElements;
  USHORT maxComponentDepth;
} PROFILE;

typedef struct {
  BYTE glyphIdArray[256];
} CMAP0;

typedef struct {
  USHORT subHeaderKeys[256];
  USHORT *data, *glyphIdArray;
} CMAP2;

typedef struct {
  USHORT segCount;
  USHORT *endCount;
  USHORT *startCount;
  USHORT *idDelta;
  USHORT *idRangeOffset;
  USHORT *glyphIdArray;
} CMAP4;

typedef struct {
  USHORT format;
  USHORT PlatformID, EncodingID;
  union {
    CMAP0 *cmap0;
    CMAP2 *cmap2;
    CMAP4 *cmap4;
#if 0
    CMAP6 *cmap6;
#endif
  } map;
} CMAP;

typedef struct {
  Fixed version;
  char *name;
  int res, EM;
  FILE *fp;
  /* curmap is the active CMAP encoding */
  CMAP *cmap, *curmap;
  USHORT numberOfEncoding;
  ULONG glyfoff;
  OUTLINE *glyf;
  HEAD *head;
  HORIZON *horz;
  ULONG *indexToLocation;
  PROFILE *profile;
  USHORT *cvt;
  BYTE *fpgm, *prep;
  USHORT cvtlen, fpgmlen, preplen;
} TTF;


TTF *ttf_init(char *fontFileName);
void RENDER_Init(void);
void ttf_selectCmap(TTF *font, USHORT platID, USHORT encodID);
int ttf_getFontIndex(TTF *font, BYTE *cc);
int ttf_getFontOffset(TTF *font, BYTE *cc);
int ttf_getAdvanceWidth(TTF *font, USHORT index);
int ttf_getLsb(TTF *font, USHORT index);
BITMAP *ttf_renderChar(TTF *font, BYTE *cc, double point,
                        int x_resolution, int y_resolution);

#if 0
void ttf_renderCharPS(TTF *f, BYTE *cc, char *buf, int len);
#endif

#endif /* __TTF_H */


/* end of ttf.h */
