
#ifdef apollo
#define  MAXOPEN         45  /* limit on number of open PXL files */
#else !apollo
#define  MAXOPEN         12  /* limit on number of open PXL files */
#endif

#define  NPXLCHARS      256
#ifndef PK
#define  PXLID         1001
#else
#define  PKID         89
#define  PKXXX1	240
#define  PKXXX2	241
#define  PKXXX3 242
#define  PKXXX4 243
#define  PKYYY	244
#define  PKPOST	245
#define  PKNOOP 246
#define  PKPRE  247
#endif /* PK */

/* definitions for loading characters */

#define NOTLOADED 0
#define PERMANENT 1
#define TEMPORARY 2

/**********************************************************************/
/***********************  Font Data Structures  ***********************/
/**********************************************************************/

struct char_entry {		/* character entry */
   unsigned short width, height;/* width and height in pixels */
   short xOffset, yOffset;      /* x offset and y offset in pixels */
#ifdef PK
   char dyn_f;			/* dyn_f value */
   char turn_on;
#endif /* PK */
   struct {
       int isloaded;		/* 0 = not loaded,1 = permanent,2= temporary */
       union {
	   int fileOffset;
	   char *pixptr; } address;
       } where;
   int tfmw;			/* TFM width */
   short dx;			/* hor escapement in pixels */
   };

#ifdef BUILTIN
struct IncFile {		/* Include file description */
  struct IncFile *next;		/* next one */
  char loaded;
  char name[STRSIZE];		/* actual file name */
};
#endif

struct font_entry {  	/* font entry */
   int k, c, s, d, a, l;
   char area[STRSIZE];	/* FNT_DEF command parameters  */
   char n[STRSIZE];	/* FNT_DEF command parameters  */
   int font_space;	/* computed from FNT_DEF s parameter        */
   int font_mag;	/* computed from FNT_DEF s and d parameters */
   char psname[STRSIZE]; /* PostScript name of the font             */
   char name[STRSIZE];	/* full name of PXL file                    */
			/* or postscript code for builtin font      */
   FILE *font_file_id;  /* file identifier (NO_FILE if none)        */
#ifdef BUILTIN
   char builtin; 	/* is it a builtin font?                    */
#endif
   int magnification;	/* magnification read from PXL file         */
   int designsize;	/* design size read from PXL file           */
   struct char_entry ch[NPXLCHARS];/* character information         */
   struct font_entry *next;
   int ncdl;            /* # of different chars actually downloaded */
#ifdef STATS
   int nbpxl;           /* # of bytes of PXL data downloaded        */
   int ncts;            /* total # of characters typeset */
#endif
   };

int   hconv, vconv;		/* converts DVI units to pixels             */

FILE *pxlfp;			/* PXL file pointer                         */
char *PXLpath[MAX_PATHS];	/* PXL path names for search		    */
int   PXLpathlen;		/* nbr of PXL path names for search	    */
char *TFMpath[MAX_PATHS];	/* TFM path names for search		    */
int   TFMpathlen;		/* nbr of TFM path names for search	    */
