%!              for use by dvi2ps Version 2.00
% a start (Ha!) at a TeX mode for PostScript.
% The following defines procedures assumed and used by program "dvi2ps"
% and must be downloaded or sent as a header file for all TeX jobs.

% By:  Neal Holtz, Carleton University, Ottawa, Canada
%      <holtz@cascade.carleton.cdn>
%      <holtz%cascade.carleton.cdn@ubc.csnet>
%      June, 1985
%      Last Modified: Aug 25/85
% oystr 12-Feb-1986
%   Changed @dc macro to check for a badly formed bits in character
%   definitions.  Can get a <> bit map if a character is not actually
%   in the font file.  This is absolutely guaranteed to drive the
%   printer nuts - it will appear that you can no longer define a
%   new font, although the built-ins will still be there.

% To convert this file into a downloaded file instead of a header
% file, uncomment all of the lines beginning with %-%

%-%0000000 			% Server loop exit password
%-%serverdict begin exitserver
%-%  systemdict /statusdict known
%-%  {statusdict begin 9 0 3 setsccinteractive /waittimeout 300 def end}
%-% if

/TeXDict 200 dict def   % define a working dictionary
TeXDict begin           % start using it.

                        % units are in "dots" (300/inch)
/Resolution 300 def
/Inch  {Resolution mul} def  % converts inches to internal units

% the height and width of the page in pixels (possibly scaled if
% TexPagesPerPage <> 1, and !A5
/PageHeight { 11.75 Inch } def	% allow for a change in resolution later
/PageWidth { 8.25 Inch } def

/Mtrx 6 array def

%%%%%%%%%%%%%%%%%%%%% Page setup (user) options %%%%%%%%%%%%%%%%%%%%%%%%

% dvi2ps will output coordinates in the TeX system ([0,0] 1" down and in
% from top left, with y +ive downward).  The default PostScript system
% is [0,0] at bottom left, y +ive up.  The Many Matrix Machinations in
% the following code are an attempt to reconcile that. The intent is to
% specify the scaling as 1 and have only translations in the matrix to
% properly position the text.  Caution: the default device matrices are
% *not* the same in all PostScript devices; that should not matter in most
% of the code below (except for lanscape mode -- in that, rotations of
% -90 degrees resulted in the the rotation matrix [ e 1 ]
%                                                 [ 1 e ]
% where the "e"s were almost exactly but not quite unlike zeros.


%%%%%%%%%#### Additional Procedure Definitions ####%%%%%%%%%%%%%%%%%%%%%%%%%%

/numberOfRows		% the number of page rows on LaserWriter page
  {2 power 2 div truncate exp} def

/numberOfColumns 	% the number of page columns on LaserWriter page
  {2 power 2 div ceiling exp} def

/setscale
  {72 Resolution div dup xscale mul exch yscale mul neg scale} def
	% Sets the scaling to the appropriate ammount. Note
	% the negative y direction scaling factor to account for the 
	% discrepancy between TeX and PostScript co-ordinates

/A5 false def % A5 does not reduce page size, 
	      % but puts 2 A5 pages side-by-side

/A5pages {
  /A5 true def
  /PageHeight PageHeight 1.41421 div def
  /PageWidth PageWidth 1.41421 div def
  2 @TexPagesPerPage
} def

/@TexPagesPerPage 
  { 
    /power exch log 2 log div ceiling def	% numberofpages <= 2^power.
    /odd power cvi 2 mod 1 eq def		% boolean,  "power is odd".
    /rowCount numberOfRows def		% initialise loop count variables.
    /columnCount numberOfColumns def
    A5
	{ /xscale 1 def
	  /yscale 1 def }
	{ /xscale 1 rowCount div def		% 1/No. rows for x scaling
	  /yscale 1 columnCount div def }	% 1/No. columns for y scaling
    ifelse
  } def


%%%%%%%%%%%####---------------------------------####%%%%%%%%%%%%%%%%%%%%%%

/@setposition
  { 
    odd
      {
	Mtrx currentmatrix 0 0.0 put
	Mtrx 1 -1.0 put
	Mtrx 2 1.0 put
	Mtrx 3 0.0 put
	Mtrx setmatrix
	A5 not
	  { 1.41421 yscale mul 0.707101 xscale mul scale }
	if
	Resolution dup translate	% 1inch margins
	Mtrx currentmatrix pop
      }
      {
	initmatrix
	setscale
	Resolution PageHeight Resolution sub neg numberOfRows mul translate
		% move origin to top, 1inch from the corner
	Mtrx currentmatrix pop
      } ifelse
  } def

/@landscape
  { initmatrix
    72 Resolution div dup neg scale  % set scaling to 1.
%    -90 rotate                      % it would be nice to be able to do
    Mtrx currentmatrix 0 0.0 put     % this but instead we have to do
    Mtrx 1 -1.0 put                  % things like this because what should
				     % be zero terms aren't (and text comes
				     % out wobbly)
    Mtrx 2 1.0 put      % Fie!  This likely will not work on QMS printers
    Mtrx 3 0.0 put      % (nor on others where the device matrix is not
    Mtrx  setmatrix     %  like it is on the LaserWriter).
    Resolution dup translate  % move origin to top
    Mtrx currentmatrix pop
  } def

/@manualfeed
   { statusdict /manualfeed true put
   } def
        % n @copies -   set number of copies
/@copies
   { /#copies exch def
   } def
/@restore /restore load def
/restore
   {vmstatus pop
   dup @VMused lt{pop @VMused}if		% calculate virtual memory used
   exch pop exch @restore /@VMused exch def
   }def

/@FontMatrix [1 0 0 -1 0 0] def
/@FontBBox [0 0 1 1] def

%%%%%%%%%%%%%%%%%%%% Procedure Defintions %%%%%%%%%%%%%%%%%%%%%%%%%%

/@newfont       % id @newfont -         -- initialize a new font dictionary
  { /newname exch def
    newname 7 dict def          % allocate new font dictionary
    newname load begin
        /FontType 3 def
	/FontMatrix @FontMatrix def
	/FontBBox @FontBBox def
        /BitMaps 128 array def
        /BuildChar {CharBuilder} def
        /Encoding 256 array def
        0 1 255 {Encoding exch /.undef put} for
        end
    newname newname load definefont pop
  } def


% the following is the only character builder we need.  it looks up the
% char data in the BitMaps array, and paints the character if possible.
% char data  -- a bitmap descriptor -- is an array of length 6, of
%          which the various slots are:

/ch-image {ch-data 0 get} def   % the hex string image
/ch-width {ch-data 1 get} def   % the number of pixels across
/ch-height {ch-data 2 get} def  % the number of pixels tall
/ch-xoff  {ch-data 3 get} def   % number of pixels below origin
/ch-yoff  {ch-data 4 get} def   % number of pixels to left of origin
/ch-tfmw  {ch-data 5 get} def   % spacing to next character

/CharBuilder    % fontdict ch Charbuilder -     -- image one character
     {save 3 1 roll exch /BitMaps get exch get /ch-data exch def
      ch-data null ne
      {ch-tfmw 0 ch-xoff neg ch-yoff neg ch-width ch-xoff sub ch-height ch-yoff sub
            setcachedevice
        ch-width ch-height true [1 0  0 1  ch-xoff ch-yoff]
            {ch-image} imagemask
     }if
     restore
  } def


/@sf            % fontdict @sf -        -- make that the current font
  { dup
    % All smallcaps fonts must have the string SmallCaps in their name
    /FontName known
      { dup /FontName get tempstring cvs (SmallCaps) search
	  {/smallcaps true def pop pop pop}
	  {/smallcaps false def pop}
        ifelse
      }
      {/smallcaps false def} 
    ifelse
    setfont
  } def

                % in the following, the font-cacheing mechanism requires that
                % a name unique in the particular font be generated

/@dc            % char-data ch @dc -    -- define a new character bitmap in current font
  { /ch-code exch def
% ++oystr 12-Feb-86++
    dup 0 get
    length 2 lt
      {dup 4 get exch 5 get <00> 1 1 0 6 -2 roll 6 array astore}
      % replace <> with null
    if
% --oystr 12-Feb-86--
    /ch-data exch def
    currentfont /BitMaps get ch-code ch-data put
    currentfont /Encoding get ch-code
       dup (   ) cvs cvn   % generate a unique name simply from the character code
       put
  } def

/@pc		% char-data ch @pc -    -- print a character bitmap not downloaded
    {pop
    /ch-data exch def
    currentpoint translate
    ch-width ch-height true [1 0 0 -1 ch-xoff ch-yoff]
    {ch-image}imagemask
    }def

/@bop0           % n @bop0 -              -- begin the char def section of a new page
  { pop
  } def

/@bop1           % n @bop1 -              -- begin a brand new page
  { pop
    /SaveImage save def
  } def

/@eop           % - @eop -              -- end a page
{ 
  SaveImage restore
  columnCount 1 ne 
    {
      PageWidth 0 translate
      /columnCount columnCount 1 sub def	% and note new column
    }
    {
      rowCount 1 ne							
        {
          /columnCount numberOfColumns def	% reset the column count
          /rowCount rowCount 1 sub def		% note entry into a new row
	  PageWidth neg columnCount 1 sub mul PageHeight translate
  				% move far left and down one TeX page
	}
	{
	  showpage
	  /columnCount numberOfColumns def	% reset the column count
	  /rowCount numberOfRows def		% reset the row count
	  erasepage initgraphics 
	  Mtrx setmatrix
	} ifelse
    } ifelse
} def

/@start         % - @start -            -- start everything
  { @setposition                           % (there is not much to do)
    vmstatus pop /@VMused exch def pop
  } def

/printVMstats false def

/@pri
    {
    ( ) print
    (                                       ) cvs print
    }def

/@end           % - @end -              -- done the whole shebang
  {
    printVMstats {
      (VM used: ) print @VMused @pri
      (. Unused: ) print vmstatus @VMused sub @pri pop pop
      (\n) print flush
    } if
    columnCount numberOfColumns eq
    rowCount numberOfRows eq
      and not
        {showpage}
      if 
  end
  } def

/p              % x y p -               -- move to position
  { moveto
  } def

/r              % x r -                 -- move right
  { 0 rmoveto
  } def

/s              % string s -            -- show the string
  { smallcaps {SmallCapShow} {texshow} ifelse
  } def

/texshow
  { { pop pop currentpoint exch round exch moveto } exch kshow
      currentpoint exch round exch moveto
} def

/c              % ch c -                -- show the character (code given)
  { c-string exch 0 exch put
    c-string s
  } def

/c-string ( ) def

/ru             % dx dy ru -   -- set a rule (rectangle)
  { /dy exch neg def    % because dy is height up from bottom
    /dx exch def
    /x currentpoint /y exch def def   % remember current point
    newpath x y moveto
    dx 0 rlineto
    0 dy rlineto
    dx neg 0 rlineto
    closepath fill
    x y moveto
  } def

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%     the \special command junk
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   The structure of the PostScript produced by dvi2ps for \special is:
%         @beginspecial
%           - any number of @hsize, @hoffset, @hscale, etc., commands
%         @setspecial
%           - the users file of PostScript commands
%         @endspecial

% The @beginspecial command recognizes whether the Macintosh Laserprep
% has been loaded or not, and redfines some Mac commands if so.
%%% NOTE: This has been disabled as we don't use it !!
% The @setspecial handles the users shifting, scaling, clipping commands


% The following are user settable options from the \special command.

/@SpecialDefaults
  { /hs PageWidth def
    /vs PageHeight def
    /ho 0 def
    /vo 0 def
    /hsc 1 def
    /vsc 1 def
    /CLIP false def
  } def

%       d @hsize -      specify a horizontal clipping dimension
%                       these 2 are executed before the MacDraw initializations
/@hsize {/hs exch def /CLIP true def} def
/@vsize {/vs exch def /CLIP true def} def
%       d @hoffset -    specify a shift for the drwgs
/@hoffset {/ho exch def} def
/@voffset {/vo exch def} def
%       s @hscale -     set scale factor
/@hscale {/hsc exch def} def
/@vscale {/vsc exch def} def

/@setclipper
  { hsc vsc scale
    CLIP
      { newpath 0 0 moveto hs 0 rlineto 0 vs rlineto hs neg 0 rlineto
        closepath clip }
    if
  } def

% this will be invoked as the result of a \special command (for the
% inclusion of PostScript graphics).  The basic idea is to leave the
% coordinate system sensible (with the origin at the currentpoint), 
% and revert graphics to default.

/@beginspecial          % - @beginspecial -     -- enter special mode
  { gsave /SpecialSave save def
          % the following magic incantation establishes the current point as
          % the users origin, and sets up the correct scalings and rotations
    currentpoint transform initgraphics itransform translate
    % Now we're back at the same place.  What we need to do now is set
    % the scaling and rotation to correspond to the number of TeX pages on
    % the page.
    odd {
	 A5 not
	   { 0.707101 1.41421 yscale mul exch xscale mul scale } if
	 90 rotate
	}
	{
	 xscale yscale scale
	} ifelse
    @SpecialDefaults    % setup default offsets, scales, sizes
  /showpage {} def %%% Ignore showpage commands
  } def

/@setspecial    % to setup user specified offsets, scales, sizes (for clipping)
  {
    ho vo translate @setclipper
  } def

/@endspecial            % - @endspecial -       -- leave special mode
  { SpecialSave restore
    grestore
  } def

%%%% Additions by LA Carr to reencode Adobe fonts as TeX fonts (almost)
%%%% Based on routine in LaserWriter Cookbook
/TeXPSmakefont {	% defines a routine for generating PS fonts, fudged!
	/TeXsize exch def
	findfont 
	[ TeXsize 0 0 TeXsize neg 0 0 ] makefont
	} def

%Create a transformed font
% params: symbol for name of new font,
%	  symbol for name of original font,
%	  font transformation matrix
%	  proc to execute on font (the transformed font dict is on the
%		top of the stack when this proc is called)
/TransformFont {
  30 dict begin			% for temporary storage
    /Proc exch def		% the proc to exec
    /TransformMatrix exch def	% transform matrix
    /BaseName exch def		% existing font
    /NewName exch def		% new name

	% find old font, apply transfrom
    /BaseFontDict BaseName findfont TransformMatrix makefont def
	% make a dictionary for the new font
    /NewFont BaseFontDict maxlength dict def
	% copy entries into the new dictionary (see Cookbook for expln.)
    BaseFontDict
      { exch dup /FID ne
	  { dup /Encoding eq
	      { exch dup length array copy
	        NewFont 3 1 roll put }
	      { exch NewFont 3 1 roll put }
	    ifelse }
	  { pop pop }
	ifelse
      } forall
    NewFont /FontName NewName put

	% call procedure
    NewFont Proc
    	% store new font in fontdict
    NewName NewFont definefont
    pop
  end
} def

% Create an Oblique font
% params:	new name for font
%		old font
%		angle of obliqueness
/ObliqueFont {
  20 dict begin
    /Angle exch def
    [1 0 Angle sin Angle cos div 1 0 0]	% transform for obliqueness
    {pop}
    TransformFont
  end
} def

% Create a SmallCaps font...in fact just a copy of the font, and the
% name is used to indicate whether it should be treated differently
% params: new-name, old-name.  new-name should include the string
%	  'SmallCaps'.
/SmallCapsFont {
    [1 0 0 1 0 0] % identity transform
    {pop}	  % no-op
    TransformFont
} def

% Create a condensed font with different strokewidth
% params:	new font name
%		old font name
%		factor to condense by (e.g., 0.8)
%		factor to thicken lines by (e.g., 1.5)
/CondensedFont {
  20 dict begin
    /LineThickening exch def
    /WidthNarrowing exch def
    [WidthNarrowing 0 0 1 0 0] % transform matrix
    {dup 
     /StrokeWidth known {
       dup
       /StrokeWidth get LineThickening mul /StrokeWidth exch put
     } if}
    TransformFont
  end
} def

% Create a Reduced font
% params: new-name old-name scale
/ReducedFont {
  20 dict begin
    /reduction exch def
    [reduction 0 0 reduction 0 0]
    {pop}	  % no-op
    TransformFont
  end
} def

/Courier-Condensed /Courier 0.85 1.5 CondensedFont
/Symbol-Oblique /Symbol 15 ObliqueFont
/Times-Oblique /Times-Roman 15 ObliqueFont
/Times-BoldOblique /Times-Bold 15 ObliqueFont
/Times-ItalicUnslanted /Times-Italic -15.15 ObliqueFont
/Times-SmallCaps /Times-Roman SmallCapsFont
/Helvetica-Reduced /Helvetica 0.875 ReducedFont
/Helvetica-SmallCaps /Helvetica SmallCapsFont

%Create a Palatino-ItalicUnslanted font? You must be joking!
/makeLWPlusFonts {
  /Bookman-LightOblique /Bookman-Light 10 ObliqueFont
  /Bookman-LightSmallCaps /Bookman-Light SmallCapsFont
  /NewCenturySchlbk-Oblique /NewCenturySchlbk-Roman 10 ObliqueFont
  /NewCenturySchlbk-SmallCaps /NewCenturySchlbk-Roman SmallCapsFont
  /Palatino-SmallCaps /Palatino-Roman SmallCapsFont
  /Palatino-Oblique /Palatino-Roman 10 ObliqueFont
  /Palatino-BoldOblique /Palatino-Bold 10 ObliqueFont
} def

/SmallCapShow {
	% string smallcaps show
	/achar (A) def
	/xfac 0.8 def
	/yfac 0.8 def
	/xrec 1 xfac div def
	/yrec 1 yfac div def
	{ dup dup
	  8#141 ge exch 8#172 le and 
	    { 8#40 sub achar exch 0 exch put achar
	      xfac yfac scale texshow xrec yrec scale }
	    { achar exch 0 exch put achar texshow }
	  ifelse
	} forall
} def

/tempstring 100 string def	% used for string conversions
%%%% Additions by LA Carr to reencode Adobe fonts as TeX fonts (almost)
%%%% Based on routine in LaserWriter Cookbook

end                     % revert to previous dictionary

statusdict /waittimeout 300 put
