/*
 *	This header file contains the definitions for the TFM
 *	file.
 *
 *	Most of the stuff in the TFM file is used by TeX to figure
 *	out what the desired character (or sequence of characters)
 *	should be, based on the input sequence. Although not needed
 *	by DVIOUT, they are defined here for the sake of completeness.
 */

struct Header_Array {
	unsigned long TFM_Checksum;	/* the checksum word */
	fix_word Design_Size;		/* the font design size */
	char Font_Coding_Scheme[40];	/* the character coding scheme */
	char Font_Identifier[20];	/* the font family name */
	unsigned char Seven_Bit_Safe_Flag;
	unsigned char filler[2];
	unsigned char Face;		/* the font type face style */
#define ROMAN      0
#define ITALIC     1
#define MEDIUM     0
#define BOLD       2
#define LIGHT      4
#define REGULAR    0
#define CONDENSED  6
#define EXTENDED  12
	unsigned long Rest_of_Header[];
};

struct Char_Info_Word {
	unsigned char Width_Index;	/* Index into width array */
	unsigned Depth_Index : 4;	/* Index into depth array */
	unsigned Height_Index : 4;	/* Index into height array */
	unsigned Tag : 2;		/* Tag field */
#define NO_TAG   0			/* vanilla character */
#define LIG_TAG  1			/* has a ligature/kerning program */
#define LIST_TAG 2			/* has a successor in charlist */
#define EXT_TAG  3			/* is extensible */
	unsigned Italic_Index : 6;	/* Index into italic array */
	unsigned char Remainder;	/* Depends on Tag field */
};

struct Lig_Kern_Command {
	unsigned char Stop_Bit;		/* Stop if > 128 */
#define STOP_FLAG 0x80
	unsigned char Next_Char;	/* Next Character Code */
	unsigned char Op_Bit;		/* ligature or kern step */
#define KERN_FLAG 0x80
	unsigned char Remainder;	/* depends on op_bit */
};

struct Extensible_Recipe {
	unsigned char Ext_Top;		/* top piece in a recipe */
	unsigned char Ext_Mid;		/* middle piece in a recipe */
	unsigned char Ext_Bot;		/* bottom piece in a recipe */
	unsigned char Ext_Rep;		/* repeated piece(s) in a recipe */
};

struct TFM_Memory_File {
	unsigned short Smallest_Char_Code; /* 'bc' */
	unsigned short Largest_Char_Code; /* 'ec' */
	unsigned short Header_Size;
	unsigned short filler;
	struct Header_Array *Header;	/* Pointer to header info */
	struct Char_Info_Word *Char_Info; /* Pointer to character data */
	fix_word *Width;		/* Pointer to width table */
	fix_word *Height;		/* Pointer to height table */
	fix_word *Depth;		/* Pointer to depth table */
	fix_word *Italic;		/* Pointer to italic table */
	struct Lig_Kern_Command *Lig_Kern; /* Pointer to ligature/kerning table */
	fix_word *Kern;			/* Pointer to kern table */
	struct Extensible_Recipe *Exten;/* Pointer to character extensions */
	fix_word *Param_Array;		/* Pointer to parameter array */
#define SLANT          0		/* Italic slant amount */
#define SPACE          1		/* Normal spacing between words */
#define SPACE_STRETCH  2		/* Glue stretching between words */
#define SPACE_SHRINK   3		/* Glue shrinking between words */
#define X_HEIGHT       4		/* Size of one ex */
#define MATH_X_HEIGHT  4
#define QUAD           5		/* Size of one em */
#define MATH_QUAD      5
#define EXTRA_SPACE    6		/* Amount added at end of sentence */
#define NUM1           7
#define NUM2           8
#define NUM3           9
#define DENOM1        10
#define DENOM2        11
#define SUP1          12
#define SUP2          13
#define SUP3          14
#define SUB1          15
#define SUB2          16
#define SUP_DROP      17
#define SUB_DROP      18
#define DELIM1        19
#define DELIM2        20
#define AXIS_HEIGHT   21
	unsigned int Param_Array_Size;	/* Size of parameter array */
	unsigned long TFM_File_Data[];	/* The entire TFM file */
};
