/***************************************************************************
              ktsclosetex.cpp  -  methods of the problem dialog
                             -------------------
    begin                : Wed Oct 4 2000
    copyright            : (C) 2000 by Arnd Fischer
    email                : lxuser@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <kapp.h>
#include <klocale.h>
#include "ktsclosetex.h"

/** construct it! */
KTSCloseTeX::KTSCloseTeX(QWidget *parent, const QString &name) :
	QDialog(parent,name,false){

	// init dialog and connect the OK-Button
	initDialog();
	this->setCaption(i18n("Problem"));
	connect(buttonOK, SIGNAL(pressed()), this, SLOT(slotResponse()));
}

/** the destructor does noting at the moment */
KTSCloseTeX::~KTSCloseTeX(){
}

/** emit selected entry and close dialog */
void KTSCloseTeX::slotResponse(){

	// get selected entry
	QString test(comboTeXExit->currentText());

	// propagate selected entry and quit the dialog
	emit signalActionSelected(test);
	done(0);
}
