/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
    file_mg.c
    file manager
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "refs.h"
#include "str_fun.h"
#include "fl_ut.h"
#include "interf.h"
#include "initial.h"
#define MASKEN_LEN 10

 extern config_set one_config_set;
 extern char wrtxtbu[WRTXTBU_LEN+1];
 extern char rdbpfad[PFAD_LEN+1];
 extern char textpfad[PFAD_LEN+1];
 
 static int loeschen(void);
 static int confirm_deleting(char * dateiname);
 static int duplizieren(void);
 static int dateien_umbenennen(void);


#define DATEIAUSWAHL_MENU \
"[bbt] binary batch table (*.bbt)\n\
[tbt] text batch table/file (*.tbt)\n\
[txt] (*.txt), [doc] (*.doc), [bib] (*.bib), [asc] (*.asc), [tex] (*.tex)\n\
[arr] References archive file (*.arr), [fd] format definition (*.fd)\n\
[fde] format definition for editing, [log] (References) log file\n\
[ sr] search and replace script, [html] HTML web document\n\
[  q] quit"

/* [bbt] binary batch table (*.bbt) */
                 /* 1 */
/* [tbt] text batch table/file (*.tbt) */
                 /* 2 */
/* [txt] (*.txt), [doc] (*.doc), [bib] (*.bib), [asc] (*.asc), [tex] (*.tex) */
                 /* 3,4,5,6,7 */
/* [arr] References archive file (*.arr), [fd] format definition (*.fd) */
                 /* 8, 9 */
/* [fde] format definition for editing, [log] (References) log file */
                /* 10, 11 */
/* [ sr] search and rename script, [html] HTML web document*/
                /* 12, 13  */
/* [  q] quit */



int file_managermenu(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option;
 
  option = 0;
  strcpy(ein,"menu");
  while (option < 4)
  {
     wrtxt("\nMenu: file manager [d/r/2/q]\n");
     option = menu_wahl(ein,
       "[d] delete file\n"                                     /* 1 */
       "[r] rename file\n"                                     /* 2 */
       "[2] duplicate file\n"                                  /* 3 */
       "[q] quit"                                              /* 5 */
       );
     if (option==1)
     {
        loeschen();
        strcpy(ein,"menu");
     }
     if (option==2)
     {
        dateien_umbenennen();
        strcpy(ein,"menu");
     }
     if (option==3)
     {
        duplizieren();
        strcpy(ein,"menu");
     }

  }
  return 1;
}

static int loeschen(void)
{

  static char ein[INPUT_BU_LEN+1];
  int option;
  static char dateiname[PFAD_LEN + 1];
 
  option = 0;
  while (option < 14)
  {
     strcpy(ein,"menu");
     wrtxt("\nMenu: delete file, select filename extension [bbt/tbt/txt/ ... /q]\n");
     option = menu_wahl(ein,
       DATEIAUSWAHL_MENU);
     if (option == 1)
     {
        if (!datei_suchen_mit_pfad("*.bbt",
          rdbpfad,
          dateiname))
        {
           continue;
        }
        if (confirm_deleting(dateiname)==1)
        {
           if (remove(dateiname)==0)
           {
              sprintf(wrtxtbu,"\n(File `%s' successfully deleted)\n",
                dateiname);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"\nFile `%s' successfully deleted",
                dateiname);
              protokollieren(wrtxtbu);
           }
        }
     }
     if (option == 2)
     {
        if (!datei_suchen_mit_pfad("*.tbt",
          textpfad,
          dateiname))
        {
           continue;
        }
        if (confirm_deleting(dateiname)==1)
        {
           if (remove(dateiname)==0)
           {
              sprintf(wrtxtbu,"\n(File `%s' successfully deleted)\n",
                dateiname);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"\nFile `%s' successfully deleted",
                dateiname);
              protokollieren(wrtxtbu);
           }
        }
     }
     if (option == 3)
     {
        if (!datei_suchen_mit_pfad("*.txt",
          textpfad,
          dateiname))
        {
           continue;
        }
        if (confirm_deleting(dateiname)==1)
        {
           if (remove(dateiname)==0)
           {
              sprintf(wrtxtbu,"\n(File `%s' successfully deleted)\n",
                dateiname);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"\nFile `%s' successfully deleted",
                dateiname);
              protokollieren(wrtxtbu);
           }
        }
     }
     if (option == 4)
     {
        if (!datei_suchen_mit_pfad("*.doc",
          textpfad,
          dateiname))
        {
           continue;
        }
        if (confirm_deleting(dateiname)==1)
        {
           if (remove(dateiname)==0)
           {
              sprintf(wrtxtbu,"\n(File `%s' successfully deleted)\n",
                dateiname);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"\nFile `%s' successfully deleted",
                dateiname);
              protokollieren(wrtxtbu);
           }
        }
     }
     if (option == 5)
     {
        if (!datei_suchen_mit_pfad("*.bib",
          textpfad,
          dateiname))
        {
           continue;
        }
        if (confirm_deleting(dateiname)==1)
        {
           if (remove(dateiname)==0)
           {
              sprintf(wrtxtbu,"\n(File `%s' successfully deleted)\n",
                dateiname);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"\nFile `%s' successfully deleted",
                dateiname);
              protokollieren(wrtxtbu);
           }
        }
     }
     if (option == 6)
     {
        if (!datei_suchen_mit_pfad("*.asc",
          textpfad,
          dateiname))
        {
           continue;
        }
        if (confirm_deleting(dateiname)==1)
        {
           if (remove(dateiname)==0)
           {
              sprintf(wrtxtbu,"\n(File `%s' successfully deleted)\n",
                dateiname);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"\nFile `%s' successfully deleted",
                dateiname);
              protokollieren(wrtxtbu);
           }
        }
     }
     if (option == 7)
     {
        if (!datei_suchen_mit_pfad("*.tex",
          textpfad,
          dateiname))
        {
           continue;
        }
        if (confirm_deleting(dateiname)==1)
        {
           if (remove(dateiname)==0)
           {
              sprintf(wrtxtbu,"\n(File `%s' successfully deleted)\n",
                dateiname);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"\nFile `%s' successfully deleted",
                dateiname);
              protokollieren(wrtxtbu);
           }
        }
     }
     if (option == 8)
     {
        if (!datei_suchen_mit_pfad("*.arr",
          textpfad,
          dateiname))
        {
           continue;
        }
        if (confirm_deleting(dateiname)==1)
        {
           if (remove(dateiname)==0)
           {
              sprintf(wrtxtbu,"\n(File `%s' successfully deleted)\n",
                dateiname);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"\nFile `%s' successfully deleted",
                dateiname);
              protokollieren(wrtxtbu);
           }
        }
     }
     if (option == 9)
     {
        if (!datei_suchen_mit_pfad("*.fd",
          textpfad,
          dateiname))
        {
           continue;
        }
        if (confirm_deleting(dateiname)==1)
        {
           if (remove(dateiname)==0)
           {
              sprintf(wrtxtbu,"\n(File `%s' successfully deleted)\n",
                dateiname);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"\nFile `%s' successfully deleted",
                dateiname);
              protokollieren(wrtxtbu);
           }
        }
     }
     if (option == 10)
     {
        if (!datei_suchen_mit_pfad("*.fde",
          textpfad,
          dateiname))
        {
           continue;
        }
        if (confirm_deleting(dateiname)==1)
        {
           if (remove(dateiname)==0)
           {
              sprintf(wrtxtbu,"\n(File `%s' successfully deleted)\n",
                dateiname);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"\nFile `%s' successfully deleted",
                dateiname);
              protokollieren(wrtxtbu);
           }
        }
     } 
     if (option == 11)
     {
        if (!datei_suchen_mit_pfad("*.log",
          textpfad,
          dateiname))
        {
           continue;
        }
        if (confirm_deleting(dateiname)==1)
        {
           if (remove(dateiname)==0)
           {
              sprintf(wrtxtbu,"\n(File `%s' successfully deleted)\n",
                dateiname);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"\nFile `%s' successfully deleted",
                dateiname);
              protokollieren(wrtxtbu);
           }
        }
     }
     if (option == 12)
     {
        if (!datei_suchen_mit_pfad("*.sr",
          textpfad,
          dateiname))
        {
           continue;
        }
        if (confirm_deleting(dateiname)==1)
        {
           if (remove(dateiname)==0)
           {
              sprintf(wrtxtbu,"\n(File `%s' successfully deleted)\n",
                dateiname);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"\nFile `%s' successfully deleted",
                dateiname);
              protokollieren(wrtxtbu);
           }
        }
     } 
     if (option == 13)
     {
        if (!datei_suchen_mit_pfad("*.html",
          textpfad,
          dateiname))
        {
           continue;
        }
        if (confirm_deleting(dateiname)==1)
        {
           if (remove(dateiname)==0)
           {
              sprintf(wrtxtbu,"\n(File `%s' successfully deleted)\n",
                dateiname);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"\nFile `%s' successfully deleted",
                dateiname);
              protokollieren(wrtxtbu);
           }
        }
     } 
     
     /* if (option ...) */
  }
  return 1;
}

static int confirm_deleting(char * dateiname)
{
  static char ein[INPUT_BU_LEN+1];
  int option;
 
  option = 0;
  strcpy(ein,"menu");
  while (option < 3)
  {  
     sprintf(wrtxtbu,"\nFile `%s' selected\n",dateiname);
     wrtxt(wrtxtbu);
     wrtxt("\nMenu: confirm deleting file [y/n/q]\n");
     
     option = menu_wahl(ein,
       "[y] yes, delete file\n"
       "[n] no, do NOT delete file\n"
       "[q] quit"
       );
     if (option==1)
     {
       return 1;
     }
     if (option==2)
     {
       return 0;
     }
  }
  return 0;
}


static int duplizieren(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option;
  static char datei[PFAD_LEN + 1];
  static char dateiname_quell[PFAD_LEN + 1];
  static char dateiname_ziel[PFAD_LEN + 1];

  option = 0;
  while (option < 14)
  {
     strcpy(ein,"menu");
     wrtxt("\nMenu: duplicate file, select filename extension [bbt/tbt/txt/ ... /q]\n");
     option = menu_wahl(ein,
       DATEIAUSWAHL_MENU);

     if (option==1) /* bbt */
     {
        if (!datei_suchen_mit_pfad("*.bbt",
          rdbpfad,
          dateiname_quell))
        {
           continue;
        }
        if (!dateivornamen_holen(datei,"Please enter name for target file "
           "(extension will be appended)"))
        {
           continue;
        }
        strlimcpy(dateiname_ziel,rdbpfad,PFAD_LEN);
        strlimcat(dateiname_ziel,datei,PFAD_LEN);
        strlimcat(dateiname_ziel,".bbt",PFAD_LEN);
        if (isfile(dateiname_ziel))
        {
           sprintf(wrtxtbu,"\nFile `%s' already exists, duplicating aborted\n",
             dateiname_ziel);
           wrtxt(wrtxtbu);
        }else
        {
           kopieren(dateiname_quell,dateiname_ziel);
        }
     }
     if (option==2) /* tbt */
     {
        if (!datei_suchen_mit_pfad("*.tbt",
          textpfad,
          dateiname_quell))
        {
           continue;
        }
        if (!dateivornamen_holen(datei,"Please enter name for target file "
           "(extension will be appended)"))
        {
           continue;
        }
        strlimcpy(dateiname_ziel,textpfad,PFAD_LEN);
        strlimcat(dateiname_ziel,datei,PFAD_LEN);
        strlimcat(dateiname_ziel,".tbt",PFAD_LEN);
        if (isfile(dateiname_ziel))
        {
           sprintf(wrtxtbu,"\nFile `%s' already exists, duplicating aborted\n",
             dateiname_ziel);
           wrtxt(wrtxtbu);
        }else
        {
           kopieren(dateiname_quell,dateiname_ziel);
        }
     }
     if (option==3) /* txt */
     {
        if (!datei_suchen_mit_pfad("*.txt",
          textpfad,
          dateiname_quell))
        {
           continue;
        }
        if (!dateivornamen_holen(datei,"Please enter name for target file "
           "(extension will be appended)"))
        {
           continue;
        }
        strlimcpy(dateiname_ziel,textpfad,PFAD_LEN);
        strlimcat(dateiname_ziel,datei,PFAD_LEN);
        strlimcat(dateiname_ziel,".txt",PFAD_LEN);
        if (isfile(dateiname_ziel))
        {
           sprintf(wrtxtbu,"\nFile `%s' already exists, duplicating aborted\n",
             dateiname_ziel);
           wrtxt(wrtxtbu);
        }else
        {
           kopieren(dateiname_quell,dateiname_ziel);
        }
     }
     if (option==4) /* doc */
     {
        if (!datei_suchen_mit_pfad("*.doc",
          textpfad,
          dateiname_quell))
        {
           continue;
        }
        if (!dateivornamen_holen(datei,"Please enter name for target file "
           "(extension will be appended)"))
        {
           continue;
        }
        strlimcpy(dateiname_ziel,textpfad,PFAD_LEN);
        strlimcat(dateiname_ziel,datei,PFAD_LEN);
        strlimcat(dateiname_ziel,".doc",PFAD_LEN);
        if (isfile(dateiname_ziel))
        {
           sprintf(wrtxtbu,"\nFile `%s' already exists, duplicating aborted\n",
             dateiname_ziel);
           wrtxt(wrtxtbu);
        }else
        {
           kopieren(dateiname_quell,dateiname_ziel);
        }
     }
     if (option==5) /* bib */
     {
        if (!datei_suchen_mit_pfad("*.bib",
          textpfad,
          dateiname_quell))
        {
           continue;
        }
        if (!dateivornamen_holen(datei,"Please enter name for target file "
           "(extension will be appended)"))
        {
           continue;
        }
        strlimcpy(dateiname_ziel,textpfad,PFAD_LEN);
        strlimcat(dateiname_ziel,datei,PFAD_LEN);
        strlimcat(dateiname_ziel,".bib",PFAD_LEN);
        if (isfile(dateiname_ziel))
        {
           sprintf(wrtxtbu,"\nFile `%s' already exists, duplicating aborted\n",
             dateiname_ziel);
           wrtxt(wrtxtbu);
        }else
        {
           kopieren(dateiname_quell,dateiname_ziel);
        }
     }
     if (option==6) /* asc */
     {
        if (!datei_suchen_mit_pfad("*.asc",
          textpfad,
          dateiname_quell))
        {
           continue;
        }
        if (!dateivornamen_holen(datei,"Please enter name for target file "
           "(extension will be appended)"))
        {
           continue;
        }
        strlimcpy(dateiname_ziel,textpfad,PFAD_LEN);
        strlimcat(dateiname_ziel,datei,PFAD_LEN);
        strlimcat(dateiname_ziel,".asc",PFAD_LEN);
        if (isfile(dateiname_ziel))
        {
           sprintf(wrtxtbu,"\nFile `%s' already exists, duplicating aborted\n",
             dateiname_ziel);
           wrtxt(wrtxtbu);
        }else
        {
           kopieren(dateiname_quell,dateiname_ziel);
        }
     }
     if (option==7) /* tex */
     {
        if (!datei_suchen_mit_pfad("*.tex",
          textpfad,
          dateiname_quell))
        {
           continue;
        }
        if (!dateivornamen_holen(datei,"Please enter name for target file "
           "(extension will be appended)"))
        {
           continue;
        }
        strlimcpy(dateiname_ziel,textpfad,PFAD_LEN);
        strlimcat(dateiname_ziel,datei,PFAD_LEN);
        strlimcat(dateiname_ziel,".tex",PFAD_LEN);
        if (isfile(dateiname_ziel))
        {
           sprintf(wrtxtbu,"\nFile `%s' already exists, duplicating aborted\n",
             dateiname_ziel);
           wrtxt(wrtxtbu);
        }else
        {
           kopieren(dateiname_quell,dateiname_ziel);
        }
     }
     if (option==8) /* arr */
     {
        if (!datei_suchen_mit_pfad("*.arr",
          textpfad,
          dateiname_quell))
        {
           continue;
        }
        if (!dateivornamen_holen(datei,"Please enter name for target file "
           "(extension will be appended)"))
        {
           continue;
        }
        strlimcpy(dateiname_ziel,textpfad,PFAD_LEN);
        strlimcat(dateiname_ziel,datei,PFAD_LEN);
        strlimcat(dateiname_ziel,".arr",PFAD_LEN);
        if (isfile(dateiname_ziel))
        {
           sprintf(wrtxtbu,"\nFile `%s' already exists, duplicating aborted\n",
             dateiname_ziel);
           wrtxt(wrtxtbu);
        }else
        {
           kopieren(dateiname_quell,dateiname_ziel);
        }
     }
     if (option==9) /* fd  */
     {
        if (!datei_suchen_mit_pfad("*.fd",
          textpfad,
          dateiname_quell))
        {
           continue;
        }
        if (!dateivornamen_holen(datei,"Please enter name for target file "
           "(extension will be appended)"))
        {
           continue;
        }
        strlimcpy(dateiname_ziel,textpfad,PFAD_LEN);
        strlimcat(dateiname_ziel,datei,PFAD_LEN);
        strlimcat(dateiname_ziel,".fd",PFAD_LEN);
        if (isfile(dateiname_ziel))
        {
           sprintf(wrtxtbu,"\nFile `%s' already exists, duplicating aborted\n",
             dateiname_ziel);
           wrtxt(wrtxtbu);
        }else
        {
           kopieren(dateiname_quell,dateiname_ziel);
        }
     }
     if (option==10) /* fde */
     {
        if (!datei_suchen_mit_pfad("*.fde",
          textpfad,
          dateiname_quell))
        {
           continue;
        }
        if (!dateivornamen_holen(datei,"Please enter name for target file "
           "(extension will be appended)"))
        {
           continue;
        }
        strlimcpy(dateiname_ziel,textpfad,PFAD_LEN);
        strlimcat(dateiname_ziel,datei,PFAD_LEN);
        strlimcat(dateiname_ziel,".fde",PFAD_LEN);
        if (isfile(dateiname_ziel))
        {
           sprintf(wrtxtbu,"\nFile `%s' already exists, duplicating aborted\n",
             dateiname_ziel);
           wrtxt(wrtxtbu);
        }else
        {
           kopieren(dateiname_quell,dateiname_ziel);
        }
     }
     if (option==11) /* log */
     {
        if (!datei_suchen_mit_pfad("*.log",
          textpfad,
          dateiname_quell))
        {
           continue;
        }
        if (!dateivornamen_holen(datei,"Please enter name for target file "
           "(extension will be appended)"))
        {
           continue;
        }
        strlimcpy(dateiname_ziel,textpfad,PFAD_LEN);
        strlimcat(dateiname_ziel,datei,PFAD_LEN);
        strlimcat(dateiname_ziel,".log",PFAD_LEN);
        if (isfile(dateiname_ziel))
        {
           sprintf(wrtxtbu,"\nFile `%s' already exists, duplicating aborted\n",
             dateiname_ziel);
           wrtxt(wrtxtbu);
        }else
        {
           kopieren(dateiname_quell,dateiname_ziel);
        }
     }
     if (option==12) /* sr */
     {
        if (!datei_suchen_mit_pfad("*.sr",
          textpfad,
          dateiname_quell))
        {
           continue;
        }
        if (!dateivornamen_holen(datei,"Please enter name for target file "
           "(extension will be appended)"))
        {
           continue;
        }
        strlimcpy(dateiname_ziel,textpfad,PFAD_LEN);
        strlimcat(dateiname_ziel,datei,PFAD_LEN);
        strlimcat(dateiname_ziel,".sr",PFAD_LEN);
        if (isfile(dateiname_ziel))
        {
           sprintf(wrtxtbu,"\nFile `%s' already exists, duplicating aborted\n",
             dateiname_ziel);
           wrtxt(wrtxtbu);
        }else
        {
           kopieren(dateiname_quell,dateiname_ziel);
        }
     }
     if (option==13) /* html */
     {
        if (!datei_suchen_mit_pfad("*.html",
          textpfad,
          dateiname_quell))
        {
           continue;
        }
        if (!dateivornamen_holen(datei,"Please enter name for target file "
           "(extension will be appended)"))
        {
           continue;
        }
        strlimcpy(dateiname_ziel,textpfad,PFAD_LEN);
        strlimcat(dateiname_ziel,datei,PFAD_LEN);
        strlimcat(dateiname_ziel,".html",PFAD_LEN);
        if (isfile(dateiname_ziel))
        {
           sprintf(wrtxtbu,"\nFile `%s' already exists, duplicating aborted\n",
             dateiname_ziel);
           wrtxt(wrtxtbu);
        }else
        {
           kopieren(dateiname_quell,dateiname_ziel);
        }
     }

     /* if option... */
  }
  return 1;    
}


static int dateien_umbenennen(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option;
  static char datei[PFAD_LEN + 1];
  static char dateiname_quell[PFAD_LEN + 1];
  static char dateiname_ziel[PFAD_LEN + 1];
  static char arbeitspfad[PFAD_LEN +1];
  static char maske[MASKEN_LEN+1];
  static char dateinamenerweiterung[MASKEN_LEN+1];

  option = 0;
  while (option < 14)
  {
     strcpy(ein,"menu");
     wrtxt("\nMenu: rename file, select filename extension [bbt/tbt/txt/ ... /q]\n");
     option = menu_wahl(ein,
       DATEIAUSWAHL_MENU);

       /* define working directory */
       if (option==1)
       {
         strlimcpy(arbeitspfad,rdbpfad,PFAD_LEN);
       } else
       {
         strlimcpy(arbeitspfad,textpfad,PFAD_LEN);
       }
       strlimcpy(maske,"*.bbt",MASKEN_LEN);
       // strlimcpy(dateinamenerweiterung,".bbt",PFAD_LEN);
       
       /* select filename extension */
       if (option==2)
       {
         strlimcpy(maske,"*.tbt",MASKEN_LEN);
       }
       if (option==3)
       {
         strlimcpy(maske,"*.txt",MASKEN_LEN);
       }
       if (option==4)
       {
         strlimcpy(maske,"*.doc",MASKEN_LEN);
       }
       if (option==5)
       {
         strlimcpy(maske,"*.bib",MASKEN_LEN);
       }
       if (option==6)
       {
         strlimcpy(maske,"*.asc",MASKEN_LEN);
       }
       if (option==7)
       {
         strlimcpy(maske,"*.tex",MASKEN_LEN);
       }
       if (option==8)
       {
         strlimcpy(maske,"*.arr",MASKEN_LEN);
       }
       if (option==9)
       {
         strlimcpy(maske,"*.fd",MASKEN_LEN);
       }
       if (option==10)
       {
         strlimcpy(maske,"*.fde",MASKEN_LEN);
       }
       if (option==11)
       {
         strlimcpy(maske,"*.log",MASKEN_LEN);
       }
       if (option==12)
       {
         strlimcpy(maske,"*.sr",MASKEN_LEN);
       }
       if (option==13)
       {
         strlimcpy(maske,"*.html",MASKEN_LEN);
       }
       strlimcpy(dateinamenerweiterung,maske,MASKEN_LEN);
       ltrim(dateinamenerweiterung,'*');
       //  
       
       if (option < 14)
       {
         if (!datei_suchen_mit_pfad(maske,
           arbeitspfad,
           dateiname_quell))
         {
            continue;
         }
         if (!dateivornamen_holen(datei,"Please enter name for target file "
            "(extension will be appended)"))
         {
            continue;
         }
         strlimcpy(dateiname_ziel,arbeitspfad,PFAD_LEN);
         strlimcat(dateiname_ziel,datei,PFAD_LEN);
         strlimcat(dateiname_ziel,dateinamenerweiterung,PFAD_LEN);

         
         if (isfile(dateiname_ziel))
         {
            sprintf(wrtxtbu,"\nFile `%s' already exists, renaming aborted\n",
              dateiname_ziel);
            wrtxt(wrtxtbu);
         }else
         {
            if(rename(dateiname_quell,dateiname_ziel)==0)
            {
              sprintf(wrtxtbu,"\n(File `%s' renamed to `%s')\n",
                dateiname_quell,dateiname_ziel);
              wrtxt(wrtxtbu);
              sprintf(wrtxtbu,"File `%s'\n  renamed to `%s'",
                dateiname_quell,dateiname_ziel);
              protokollieren(wrtxtbu);

            }
         }
       }
     }

     /* if option... */
    
    return 1;
}

