/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
    rfd1_fun.c
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fd.h"
#include "refs.h"
#include "rfd_fun1.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "interf.h"
#include "rfd_txte.h"
#include "sortfd.h"
#include "initial.h"

 extern char wrtxtbu[WRTXTBU_LEN+1];

 extern char formdef_name[PFAD_LEN+1];
 char fd_text_name[PFAD_LEN+1];
 extern char tempt_name[PFAD_LEN+1]; /* for list of format definitions */
 
 extern char textpfad[PFAD_LEN+1];
 extern char rdbpfad[PFAD_LEN+1];

 /* static formdef_rec fd; */
 /* beginning with v4.1 only local formdef_rec variables */
 

 static int fd_in_textdatei(formdef_rec one_fd, char * dateiname, int editv, int quiet);
 static void rfd_rec_loeschen(void);

#define VZEILE_LEN 255
#define RFDZEILE_LEN 1024
#define ZAHLSTR_LEN 32

#define FD_TEMP_DAT "fd_temp.dat" 
 
#define RFD_TEXTIMPORT_ABB1 extract_subs(ex_rfdzeile,rfdzeile,vzpos,RFDZEILE_LEN); \
          if (strlen(ex_rfdzeile) <= 1) \
          { \
            continue; \
          } \
          vzpos=strlen(ex_rfdzeile)-1; \
          if (ex_rfdzeile[vzpos]=='\'') ex_rfdzeile[vzpos]='\0'


          
int rfdmenu(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option;
 
  // strcpy(ein,"menu");
  option = 0;
  while (option < 9)
  {
     strcpy(ein,"menu");
     wrtxt("\nMenu: bibliographic/macro format definitions [ef/if/mf/ex/ea/im/d/s/q]\n");
     option = menu_wahl(ein,
       "[ef] export format definition into form (.fde)\n"
       "[if] import format definition (.fde) into database\n"
       "[mf] make empty form (.fde) for format definition\n"
       "[ex] export single format definition from database into text file (.fd)\n"
       "[ea] export all format definitions from database into text file (.fd)\n"
       "[im] import format definition from file (.fd) into database\n"
       "[ d] delete format definition in database file\n"
       "[ s] sort format definitions\n"
       "[ q] quit"
       );
     if (option==1) /* [ef] */
     {
        char ein_ex[INPUT_BU_LEN+1];
        long dsnummer;
        dsnummer = fd_datensatz_auswaehlen();
        if (dsnummer > -1)
        {
          // printf("\n==%li\n",dsnummer);
          do
          {
            ein_zeile(ein_ex,"Please enter name for FDE-file "
              "(.fde will be appended)",INPUT_BU_LEN);
            if (strlen(ein_ex)==0)
            {
               wrtxt("\n(Export of format definition aborted)\n");
               break;
            }
            if (isvalidfilename(ein_ex)==1)
            {
               formdef_rec  fd_lokal; 
              
               strlimcpy(fd_text_name,textpfad,PFAD_LEN);
               strlimcat(fd_text_name,ein_ex,PFAD_LEN);
               strlimcat(fd_text_name,".fde",PFAD_LEN); /* output text file */
               //printf("\nDatei: %s",fd_text_name);
               datensatz_lesen(dsnummer,&fd_lokal);
               fd_in_textdatei(fd_lokal, fd_text_name, 1, 0);
               load_file_yn(fd_text_name);
                  
               break;
            }
            
          } while(1);
        }
     }
     if (option==2) /* [if] */
     {
        static char einconfirm[INPUT_BU_LEN+1];
        int taste;
        strcpy(ein,"menu");
        strcpy(einconfirm,"menu");
        wrtxt("\nMenu: Confirmation - import .fde file [y/n]\n");
        taste = menu_wahl(einconfirm,
          "[y] yes, do import fde-file\n"
          "[n] cancel, do not import fde-file"
          );
        if (taste==1)
        {
           if (datei_suchen_mit_pfad("*.fde",textpfad,fd_text_name)==1)
           {
              char ein_if[INPUT_BU_LEN+1];
              long dsnummer;
              int ifoption;
              strcpy(ein_if,"menu");
              wrtxt("\nMenu: append or overwrite existing format definition [a/o/q]\n");
              ifoption = menu_wahl(ein_if,
                "[a] append bibliographic format definition to database\n"
                "[o] overwrite existing bibliographic format definition\n"
                "[q] quit"
                );
              if (ifoption==1) /* append */
              {
                  textdatei_in_fd(formdef_name,fd_text_name,-1,1);
              }
              if (ifoption==2) /* replace existing fomat definition */
              {
                ein_zeile(ein_if,"Select format definition "
                  "to be replaced, proceed with [Enter]",INPUT_BU_LEN);
                dsnummer = fd_datensatz_auswaehlen();
                if (dsnummer < 0)
                {
                   wrtxt("\n(Modification of format definition aborted)\n");
                }
                else
                {
                  textdatei_in_fd(formdef_name,fd_text_name,dsnummer,1);
                }
              }
              if (ifoption==3) /* do nothing */
              {
                 wrtxt("\n(Modification of format definition aborted)\n");
              }
              
           }
        }
        // strcpy(ein,"menu");
     }
     if (option==3) /* [mf] */
     {
        char ein_mf[INPUT_BU_LEN+1];
        formdef_rec fd_lokal;

        do
        {
          ein_zeile(ein_mf,"Please enter name for FDE-file "
            "(.fde will be appended)",INPUT_BU_LEN);
          if (strlen(ein_mf)==0)
          {
             wrtxt("\n(Creating empty FDE-file aborted)\n");
             break;
          }
          if (isvalidfilename(ein_mf)==1)
          {
             strlimcpy(fd_text_name,textpfad,PFAD_LEN);
             strlimcat(fd_text_name,ein_mf,PFAD_LEN);
             strlimcat(fd_text_name,".fde",PFAD_LEN); /* output text file */
             //printf("\nDatei: %s",fd_text_name);
             // datensatz_lesen(dsnummer,&fd);
             /* Beim MingW-Compiler gab's hier Probleme (v4.2): */
             /* Eigentlich muesste das funktionieren Anfang */ 
             /*    memset(&fd_lokal,0,sizeof(fd_lokal)); */
             /* Eigentlich muesste das funktionieren Ende */ 
             /* Alternative zum Problem Anfang */
             datensatz_ini(&fd_lokal);
             /* Alternative zum Problem Ende */
             fd_in_textdatei(fd_lokal, fd_text_name, 1, 0);
             /* Das Problem existierte unter der MinGW Implementation des gcc */
             /* v3.2.4, es trat nicht mehr auf bei der MinGW Implementation */
             /* des gcc v3.4.2. Trotzdem bleibt die Aenderung an dieser Stelle */
             /* um ein Kompilieren mit frheren MinGW/gcc Versionen zu erlauben!*/

             /* The problem: when calling [menu-d mf] first after starting the
              * program, refs42.exe stopped. The problem appeared with
              * refs42 after enlarging the fd record. The program did not stop
              * if [menu-d mf] was called after [menu-d ef] */
              load_file_yn(fd_text_name);
             
             break;
          }
          
        } while(1);
     }
     
     if (option==4) /* [ex] */
     {
        char ein_ex[INPUT_BU_LEN+1];
        long dsnummer;
        dsnummer = fd_datensatz_auswaehlen();
        if (dsnummer > -1)
        {
          // printf("\n==%li\n",dsnummer);
          do
          {
            ein_zeile(ein_ex,"Please enter name for FD-file "
              "(.fd will be appended)",INPUT_BU_LEN);
            if (strlen(ein_ex)==0)
            {
               wrtxt("\n(Export of format definition aborted)\n");
               break;
            }
            if (isvalidfilename(ein_ex)==1)
            {
               formdef_rec  fd_lokal; 
               
               strlimcpy(fd_text_name,textpfad,PFAD_LEN);
               strlimcat(fd_text_name,ein_ex,PFAD_LEN);
               strlimcat(fd_text_name,".fd",PFAD_LEN); /* output text file */
               //printf("\nDatei: %s",fd_text_name);
               // datensatz_lesen(dsnummer,&fd);
               // fd_in_textdatei(fd, fd_text_name, 0, 0);
               datensatz_lesen(dsnummer,&fd_lokal);
               fd_in_textdatei(fd_lokal, fd_text_name, 0, 0);
               
               break;
            }
            
          } while(1);
        }
     }

     if (option==5) /* [ea] */
     {
        long anzahl_records, i;
        char ein_ex[INPUT_BU_LEN+1];
        
        anzahl_records = filesize(formdef_name)/sizeof(formdef_rec);
        anzahl_records--;
        do
        {
          
          ein_zeile(ein_ex,"Please enter name for FD-file "
            "(.fd will be appended)",INPUT_BU_LEN);
          if (strlen(ein_ex)==0)
          {
             wrtxt("\n(Export of format definition aborted)\n");
             break;
          }
          if (isvalidfilename(ein_ex)==1)
          {
             strlimcpy(fd_text_name,textpfad,PFAD_LEN);
             strlimcat(fd_text_name,ein_ex,PFAD_LEN);
             strlimcat(fd_text_name,".fd",PFAD_LEN); /* output text file */
             wrtxt("\n");
             for (i=0;i<=anzahl_records;i++)
             {
               formdef_rec  fd_lokal; 
               datensatz_lesen(i,&fd_lokal);
               fd_in_textdatei(fd_lokal, fd_text_name, 0, 1);
               sprintf(wrtxtbu,"[%li] ",i);
               wrtxt(wrtxtbu);
             }
             wrtxt("\n\n(Completed)\n"); 
             break;
          }
          
        } while(1);
      
     }
     if (option==6) /* [im] */
     {
        static char einconfirm[INPUT_BU_LEN+1];
        int taste;
        strcpy(ein,"menu");
        strcpy(einconfirm,"menu");
        wrtxt("\nMenu: Confirmation - import .fd file [y/n]\n");
        taste = menu_wahl(einconfirm,
          "[y] yes, do import fd-file\n"
          "[n] cancel, do not import fd-file"
          );
        if (taste==1)
        {
           if (datei_suchen_mit_pfad("*.fd",textpfad,fd_text_name)==1)
           {
              textdatei_in_fd(formdef_name,fd_text_name,-1,0);
           }
        }
        // strcpy(ein,"menu");
     }
     if (option==7) /* [d] */
     {
         rfd_rec_loeschen();
     }
     if (option==8) /* [s] */
     {
         char formdef_temp_name[PFAD_LEN +1];
         char ein_sort[INPUT_BU_LEN+1];
         int option_sort;

         strlimcpy(formdef_temp_name,rdbpfad,PFAD_LEN);
         strlimcat(formdef_temp_name,FD_TEMP_DAT,PFAD_LEN);
         strcpy(ein_sort,"menu");
         wrtxt("\nMenu: confirm sorting [y/n]\n");
         option_sort = menu_wahl(ein_sort,
           "[y] yes, sort format definitions\n"
           "[n] no, do not sort"
           );
         if (option_sort==1)
         {
          if (isfile(formdef_temp_name)) 
          {
             remove (formdef_temp_name);
          }
          wrtxt("\n");
          domergefd(formdef_name,formdef_temp_name);
          remove(formdef_name);
          rename(formdef_temp_name,formdef_name);
         }
     }
  }
  return 1;
}


/* 
 writes format definition from text-type format definition 
 file ('text_datei_name') into database file ('formdef_datei_name')
 at position 'dateiposition'. Special value -1: end of file 
 editv variant of 
 editv 0: archive format of format definition (extension .fd)
 editv 1: format definition to be edited (.fde)
 */
int textdatei_in_fd(char * formdef_datei_name, 
  char * text_datei_name, 
  long dateiposition,
  int editv)
{
   int i;
   long byte_zeiger;
   FILE * fptext;
   FILE * fpformdef;
   char * rfdzeile;
   char * ex_rfdzeile;
   char vzeile[VZEILE_LEN+1];
   formdef_rec fd;
   long nfd;
   int vzpos;
   int fd_isopen;
     /* format defintion is opened */
   int fd_completed;
     /* format defintion has been read and may be written into binary file */
   nfd = 0L;
     /* n of format definitions */
   memset(&fd,0,sizeof(fd));
     /* doch nicht importieren: */
   
   wrtxt("\n");

   if ((rfdzeile =  (char *) malloc((RFDZEILE_LEN + 1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nERROR: Cannot allocate memory for RFD input line\n");
       exit(1);
   }
   if ((ex_rfdzeile =  (char *) malloc((RFDZEILE_LEN + 1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nERROR: Cannot allocate memory for RFD buffer\n");
       exit(1);
   }

   if ((fptext=fopen(text_datei_name,"r"))==NULL)
   {
      sprintf(wrtxtbu,"\nProblem: unable to open file %s\n",text_datei_name);
      wrtxt(wrtxtbu);
      return 0;
   }

   if ((fpformdef=fopen(formdef_datei_name,"r+b"))==NULL)
   {
      sprintf(wrtxtbu,"\nProblem: unable to open file %s for writing\n",
            formdef_datei_name);
      wrtxt(wrtxtbu);
      fclose(fptext);
      return 0;
   }
   if (dateiposition==-1)
   {
     fseek(fpformdef,0L,SEEK_END);
   } 
   else
   {
     byte_zeiger = dateiposition * sizeof(fd);
     fseek(fpformdef,byte_zeiger,SEEK_SET);
   }
   fd_isopen=0;
   fd_completed=0;
   while (fgets(rfdzeile,RFDZEILE_LEN,fptext)!=NULL)
   {
     if (strlen(rfdzeile)>=RFDZEILE_LEN)
     {
        break;
     }
     rtrim(rfdzeile,'\n');
     if (locate_substring("BIBLIOGRAPHIC STYLE FORMAT DEFINITION -- REFERENCES",
                          rfdzeile)==0)
     {
        memset(&fd,0,sizeof(fd));
        fd_isopen=1;
        fd_completed=0;
     }
     if (locate_substring("END OF BIBLIOGRAPHIC STYLE FORMAT DEFINITION",
                          rfdzeile)==0)
     {
        fd_isopen=0;
        fd_completed=1;
     }
     if (fd_completed==1 && fd_isopen==0)
     {
        if (fwrite(&fd,sizeof(fd),1,fpformdef) < 1) schreibfehler();
        nfd++;
        memset(&fd,0,sizeof(fd));
        fd_completed=0;
     }

     if (fd_isopen==1)
     {
        if ( strlen (rfdzeile) < 5)
        {
          continue;
        }

        strcpy(vzeile,"format definition '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          sprintf(wrtxtbu,"[%li] ",nfd+1); 
          wrtxt(wrtxtbu);
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.formkennung,ex_rfdzeile,FORMKENNUNG_LEN);
          continue;
        }

        strcpy(vzeile,"description '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.formatbeschreibung,ex_rfdzeile,FORMATBESCHREIBUNG_LEN);
          continue;
        }

        strcpy(vzeile,"j1 string 1 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdj1_str1,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"j1 string 2 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdj1_str2,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"j1 string 3 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdj1_str3,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        /* begin new in v4.1 */
        strcpy(vzeile,"j2 string 1 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdj2_str1,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"j2 string 2 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdj2_str2,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"j2 string 3 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdj2_str3,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }
        /* end new in v4.1 */

        strcpy(vzeile,"b1 string 1 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb1_str1,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b1 string 2 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb1_str2,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b1 string 3 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb1_str3,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 string 1 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb2_str1,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 string 2 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb2_str2,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 string 3 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb2_str3,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 string 4 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb2_str4,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 string 5 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb2_str5,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        /* begin new in v4.1 */
        strcpy(vzeile,"b3 string 1 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb3_str1,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b3 string 2 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb3_str2,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b3 string 3 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb3_str3,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }
        /* end new in v4.1 */
        /* begin new for v4.1 */
        strcpy(vzeile,"m1 string 1 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdm1_str1,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"m1 string 2 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdm1_str2,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"m1 string 3 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdm1_str3,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }
        /* end new for v4.1 */
        /* begin new for v4.1 */
        strcpy(vzeile,"m2 string 1 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdm2_str1,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"m2 string 2 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdm2_str2,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"m2 string 3 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdm2_str3,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }
        /* end new for v4.1 */

        for (i=0;i<J1_AUT_N;i++)
        {
           sprintf(vzeile,"j1 authors %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.j1_aut[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<J1_TIT_N;i++)
        {
           sprintf(vzeile,"j1 title %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.j1_tit[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<J1_LOK_N;i++)
        {
           sprintf(vzeile,"j1 localization %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.j1_lok[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        /* begin new in v4.1 */
        for (i=0;i<J2_AUT_N;i++)
        {
           sprintf(vzeile,"j2 authors %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.j2_aut[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<J2_TIT_N;i++)
        {
           sprintf(vzeile,"j2 title %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.j2_tit[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<J2_LOK_N;i++)
        {
           sprintf(vzeile,"j2 localization %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.j2_lok[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }
        /* end new in v4.1 */

        for (i=0;i<B1_ED_N;i++)
        {
           sprintf(vzeile,"b1 editors %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b1_ed[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B1_TIT_N;i++)
        {
           sprintf(vzeile,"b1 book-title %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b1_tit[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B1_LOK_N;i++)
        {
           sprintf(vzeile,"b1 localization %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b1_lok[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B2_AUT_N;i++)
        {
           sprintf(vzeile,"b2 authors %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b2_aut[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B2_TIT_N;i++)
        {
           sprintf(vzeile,"b2 title %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b2_tit[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B2_ED_N;i++)
        {
           sprintf(vzeile,"b2 editors %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b2_ed[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B2_TITB_N;i++)
        {
           sprintf(vzeile,"b2 book-title %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b2_titb[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B2_LOK_N;i++)
        {
           sprintf(vzeile,"b2 localization %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b2_lok[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        /* begin new in v4.1 */
        for (i=0;i<B3_ED_N;i++)
        {
           sprintf(vzeile,"b3 editors %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b3_ed[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B3_TIT_N;i++)
        {
           sprintf(vzeile,"b3 book-title %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b3_tit[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B3_LOK_N;i++)
        {
           sprintf(vzeile,"b3 localization %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b3_lok[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }
        /* end new in v4.1 */
        /* begin new in v4.1 */
        for (i=0;i<M1_AUT_N;i++)
        {
           sprintf(vzeile,"m1 authors %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.m1_aut[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<M1_TIT_N;i++)
        {
           sprintf(vzeile,"m1 title %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.m1_tit[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<M1_LOK_N;i++)
        {
           sprintf(vzeile,"m1 localization %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.m1_lok[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }
        /* end new in v4.1 */
        /* begin new in v4.1 */
        for (i=0;i<M2_AUT_N;i++)
        {
           sprintf(vzeile,"m2 authors %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.m2_aut[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<M2_TIT_N;i++)
        {
           sprintf(vzeile,"m2 title %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.m2_tit[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<M2_LOK_N;i++)
        {
           sprintf(vzeile,"m2 localization %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.m2_lok[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }
        /* end new in v4.1 */

        strcpy(vzeile,"j1 authors string type '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauttyp_j1,ex_rfdzeile,AUTTYP_LEN);
          continue;
        }

        strcpy(vzeile,"b1 editors string type '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauttyp_b1,ex_rfdzeile,AUTTYP_LEN);
          continue;
        }

        strcpy(vzeile,"b2 authors string type '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauttyp_b2au,ex_rfdzeile,AUTTYP_LEN);
          continue;
        }

        strcpy(vzeile,"b2 editors string type '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauttyp_b2ed,ex_rfdzeile,AUTTYP_LEN);
          continue;
        }
        /* begin new in v4.1 */
        strcpy(vzeile,"m1 authors string type '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauttyp_m1,ex_rfdzeile,AUTTYP_LEN);
          continue;
        }
        /* end new in v4.1 */

        strcpy(vzeile,"j1 delimiter ^1 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwau_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter ^1 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwau_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^1 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwau_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^1 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwau_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"m1 delimiter ^1 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwau_m1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"j1 delimiter ^2 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwaulast_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter ^2 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwaulast_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^2 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwaulast_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^2 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwaulast_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"m1 delimiter ^2 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwaulast_m1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"j1 delimiter ^3 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdv_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter ^3 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdv_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^3 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdv_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^3 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdv_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"m1 delimiter ^3 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdv_m1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"j1 delimiter ^4 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauvornach_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter ^4 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauvornach_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^4 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauvornach_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^4 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauvornach_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"m1 delimiter ^4 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauvornach_m1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }


        strcpy(vzeile,"j1 delimiter ^5 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdaunachvor_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter ^5 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdaunachvor_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^5 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdaunachvor_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^5 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdaunachvor_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"m1 delimiter ^5 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdaunachvor_m1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }


        strcpy(vzeile,"j1 delimiter ^6 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdafterlastau_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter ^6 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdafterlastau_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^6 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdafterlastau_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^6 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdafterlastau_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"m1 delimiter ^6 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdafterlastau_m1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }



        strcpy(vzeile,"j1 delimiter more names in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdweitereau_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter more names in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdweitereau_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter more names in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdweitereau_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter more names in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdweitereau_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"m1 delimiter more names in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdweitereau_m1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"j1 n in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_n_j1,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b1 n in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_n_b1,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 n in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_n_b2au,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 n in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_n_b2ed,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"m1 n in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_n_m1,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }


        strcpy(vzeile,"j1 m in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_m_j1,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b1 m in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_m_b1,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 m in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_m_b2au,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 m in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_m_b2ed,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }
        
        strcpy(vzeile,"m1 m in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_m_m1,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

     }
   }


   free(rfdzeile);
   free(ex_rfdzeile);
   fclose(fpformdef);
   fclose(fptext);
   sprintf(wrtxtbu,"\n\n(%li format definition(s) imported)\n",nfd);
   wrtxt(wrtxtbu);
   sprintf(wrtxtbu,"%li format definition(s) imported",nfd);
   protokollieren(wrtxtbu);
   return 1;
}


/* 
 * 'fd_datensatz_auswaehlen' returns position of selected format definition,
 * special value -1 no format definition selected
 */
long fd_datensatz_auswaehlen(void)
{
   formdef_rec one_fd;
   FILE * fpformdef;
   FILE * fptext;
   long dateiposition, byte_zeiger;
   long i, anzahl_records;
   char zahlstring[ZAHLSTR_LEN+1];
   int ok, schleife_beenden, abbruch;

   dateiposition = -1;
   // Sonderfall: Dateigroesse 0
   if ((fpformdef=fopen(formdef_name,"rb"))==NULL)
   {
      sprintf(wrtxtbu,"\nProblem: unable to read file %s \n",
            formdef_name);
      wrtxt(wrtxtbu);
      return 0;
   }
   if ((fptext=fopen(tempt_name,"w"))==NULL)
   {
      sprintf(wrtxtbu,"\nProblem: unable to write into file %s \n",
            formdef_name);
      fclose(fpformdef);
      wrtxt(wrtxtbu);
      return 0;
   }
   fseek(fpformdef,0L,SEEK_END);
   byte_zeiger = ftell(fpformdef);
   anzahl_records = byte_zeiger/sizeof(one_fd);
   anzahl_records--;
   rewind(fpformdef);
   fprintf(fptext,"To select a format definition, please close this " 
     "list with [q]\n\n");
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&one_fd,sizeof(one_fd),1,fpformdef);
      fprintf(fptext,"Nr.: %li\n%s\n%s\n\n",
        i,
        one_fd.formkennung,
        one_fd.formatbeschreibung);
   }
   
   fclose(fpformdef);
   fclose(fptext);
   // vtxt(tempt_name,"List with bibliographic format definitions, ([f] first page)\n"
   //   "[q] close this list, enter selected number");
   vtxt(tempt_name,"View format definitions");
   
   schleife_beenden = 0;
   abbruch = 0;
   while(schleife_beenden==0)
   {
     ein_zeile(zahlstring,"Enter selected number, "
       "[quit] exit without selection",ZAHLSTR_LEN);
     if (strcmp(zahlstring,"quit")==0)
     {
        abbruch = 1;
        break;
     }
     string_in_long(zahlstring,&dateiposition,&ok);
     if (ok && (dateiposition >= -1) && (dateiposition <= anzahl_records))
     {
        schleife_beenden = 1;
     }
   }
   if (abbruch==1)
   {
       return -1;
   }
   return dateiposition;
}

int datensatz_lesen(long rec_zeiger, formdef_rec * one_fd)
{
   FILE * fpformdef;
   long byte_zeiger;
   /* Alternative zum Problem Anfang */
   formdef_rec lies_fd;
   /* Alternative zum Problem Ende */
   if ((fpformdef=fopen(formdef_name,"rb"))==0)
   {
     fprintf(stderr,"\nERROR: cannot read %s\n",formdef_name);
     exit(1);
   }
   byte_zeiger = rec_zeiger * sizeof(formdef_rec);

   fseek(fpformdef,byte_zeiger,SEEK_SET);
   /* Beim MingW-Compiler gab's hier Probleme (v4.1): */
   /* Eigentlich muesste das funktionieren Anfang */ 
   // fread(one_fd,sizeof(formdef_rec),1,fpformdef);
   /* Eigentlich muesste das funktionieren Ende */ 
   /* Alternative zum Problem Anfang */
   fread(&lies_fd,sizeof(formdef_rec),1,fpformdef);
   * one_fd = lies_fd;
   /* Alternative zum Problem Ende */

   fclose(fpformdef);
               // wrtxt("*** Vor Hier\n");
   return 1;
}

/* This function fixes a problem with earlier versions of the `MingW
   compiler', cf call to this function in `rfdmenu()' this function
   should later be removed
 */
int datensatz_ini(formdef_rec * one_fd)
{
   formdef_rec ini_fd;
   memset(&ini_fd,0,sizeof(formdef_rec));
   * one_fd = ini_fd;
   return 1; 
}



/*
 editv 0: archive format format definition
 editv 1: format definition to be edited
 quiet 1: no message (Format definition text file ... written)
 quiet 0: print message (Format definition text file ... written)
 */
static int fd_in_textdatei(formdef_rec one_fd, char * dateiname, int editv, int quiet)
{
   FILE * fptext;
   int i;
   char text_name[PFAD_LEN+1];

   //          wrtxt("*** Hier\n");
   strcpy(text_name,dateiname);
  
   if (editv==0) /* archive-version */
   {
     if ((fptext=fopen(text_name,"at"))==NULL)
     {
        fprintf(stderr,"\nERROR: cannot create %s\n",text_name);
        exit(1);
     }
   } else /* text editor version */
   {
     if ((fptext=fopen(text_name,"wt"))==NULL)
     {
        fprintf(stderr,"\nERROR: cannot create %s\n",text_name);
        exit(1);
     }
   }
   fprintf(fptext,"BIBLIOGRAPHIC STYLE FORMAT DEFINITION -- REFERENCES ");
   fprintf(fptext,"%s\n",REFS_VERSION);

   if (editv==0)
   {
     fprintf(fptext,"\nformat definition '%s'",one_fd.formkennung);
     fprintf(fptext,"\ndescription '%s'",one_fd.formatbeschreibung);

     fprintf(fptext,"\n");

     fprintf(fptext,"\nj1 string 1 '%s'",one_fd.fdj1_str1);
     fprintf(fptext,"\nj1 string 2 '%s'",one_fd.fdj1_str2);
     fprintf(fptext,"\nj1 string 3 '%s'",one_fd.fdj1_str3);
     fprintf(fptext,"\n");
     fprintf(fptext,"\nj2 string 1 '%s'",one_fd.fdj2_str1); /* new for v4.1*/
     fprintf(fptext,"\nj2 string 2 '%s'",one_fd.fdj2_str2); /* new for v4.1*/
     fprintf(fptext,"\nj2 string 3 '%s'",one_fd.fdj2_str3); /* new for v4.1*/
     fprintf(fptext,"\n");
     fprintf(fptext,"\nb1 string 1 '%s'",one_fd.fdb1_str1);
     fprintf(fptext,"\nb1 string 2 '%s'",one_fd.fdb1_str2);
     fprintf(fptext,"\nb1 string 3 '%s'",one_fd.fdb1_str3);
     fprintf(fptext,"\n");
     fprintf(fptext,"\nb2 string 1 '%s'",one_fd.fdb2_str1);
     fprintf(fptext,"\nb2 string 2 '%s'",one_fd.fdb2_str2);
     fprintf(fptext,"\nb2 string 3 '%s'",one_fd.fdb2_str3);
     fprintf(fptext,"\nb2 string 4 '%s'",one_fd.fdb2_str4);
     fprintf(fptext,"\nb2 string 5 '%s'",one_fd.fdb2_str5);
     fprintf(fptext,"\n");
     fprintf(fptext,"\nb3 string 1 '%s'",one_fd.fdb3_str1); /* new for v4.1*/
     fprintf(fptext,"\nb3 string 2 '%s'",one_fd.fdb3_str2); /* new for v4.1*/
     fprintf(fptext,"\nb3 string 3 '%s'",one_fd.fdb3_str3); /* new for v4.1*/
     fprintf(fptext,"\n");
     fprintf(fptext,"\nm1 string 1 '%s'",one_fd.fdm1_str1); /* new for v4.1*/
     fprintf(fptext,"\nm1 string 2 '%s'",one_fd.fdm1_str2); /* new for v4.1*/
     fprintf(fptext,"\nm1 string 3 '%s'",one_fd.fdm1_str3); /* new for v4.1*/
     fprintf(fptext,"\n");
     fprintf(fptext,"\nm2 string 1 '%s'",one_fd.fdm2_str1); /* new for v4.1*/
     fprintf(fptext,"\nm2 string 2 '%s'",one_fd.fdm2_str2); /* new for v4.1*/
     fprintf(fptext,"\nm2 string 3 '%s'",one_fd.fdm2_str3); /* new for v4.1*/
     fprintf(fptext,"\n");

     fprintf(fptext,"\n");
     for (i=0;i<J1_AUT_N;i++)
     {
       fprintf(fptext,"\nj1 authors %i '%s'",i,one_fd.j1_aut[i]);
     }
     for (i=0;i<J1_TIT_N;i++)
     {
       fprintf(fptext,"\nj1 title %i '%s'",i,one_fd.j1_tit[i]);
     }
     for (i=0;i<J1_LOK_N;i++)
     {
       fprintf(fptext,"\nj1 localization %i '%s'",i,one_fd.j1_lok[i]);
     }

     /* begin new for v4.1 */
     fprintf(fptext,"\n");
     for (i=0;i<J2_AUT_N;i++)
     {
       fprintf(fptext,"\nj2 authors %i '%s'",i,one_fd.j2_aut[i]);
     }
     for (i=0;i<J1_TIT_N;i++)
     {
       fprintf(fptext,"\nj2 title %i '%s'",i,one_fd.j2_tit[i]);
     }
     for (i=0;i<J2_LOK_N;i++)
     {
       fprintf(fptext,"\nj2 localization %i '%s'",i,one_fd.j2_lok[i]);
     }
     /* end new for v4.1 */

     fprintf(fptext,"\n");
     for (i=0;i<B1_ED_N;i++)
     {
       fprintf(fptext,"\nb1 editors %i '%s'",i,one_fd.b1_ed[i]);
     }
     for (i=0;i<B1_TIT_N;i++)
     {
       fprintf(fptext,"\nb1 book-title %i '%s'",i,one_fd.b1_tit[i]);
     }
     for (i=0;i<B1_LOK_N;i++)
     {
       fprintf(fptext,"\nb1 localization %i '%s'",i,one_fd.b1_lok[i]);
     }

     fprintf(fptext,"\n");
     for (i=0;i<B2_AUT_N;i++)
     {
       fprintf(fptext,"\nb2 authors %i '%s'",i,one_fd.b2_aut[i]);
     }
     for (i=0;i<B2_TIT_N;i++)
     {
       fprintf(fptext,"\nb2 title %i '%s'",i,one_fd.b2_tit[i]);
     }
     for (i=0;i<B2_ED_N;i++)
     {
       fprintf(fptext,"\nb2 editors %i '%s'",i,one_fd.b2_ed[i]);
     }
     for (i=0;i<B2_TITB_N;i++)
     {
       fprintf(fptext,"\nb2 book-title %i '%s'",i,one_fd.b2_titb[i]);
     }
     for (i=0;i<B2_LOK_N;i++)
     {
       fprintf(fptext,"\nb2 localization %i '%s'",i,one_fd.b2_lok[i]);
     }

     /* begin new for v4.1 */
     fprintf(fptext,"\n");
     for (i=0;i<B3_ED_N;i++)
     {
       fprintf(fptext,"\nb3 editors %i '%s'",i,one_fd.b3_ed[i]);
     }
     for (i=0;i<B1_TIT_N;i++)
     {
       fprintf(fptext,"\nb3 book-title %i '%s'",i,one_fd.b3_tit[i]);
     }
     for (i=0;i<B1_LOK_N;i++)
     {
       fprintf(fptext,"\nb3 localization %i '%s'",i,one_fd.b3_lok[i]);
     }
     /* end new for v4.1 */
     /* begin new in v4.1 */
     fprintf(fptext,"\n");
     for (i=0;i<M1_AUT_N;i++)
     {
       fprintf(fptext,"\nm1 authors %i '%s'",i,one_fd.m1_aut[i]);
     }
     for (i=0;i<M1_TIT_N;i++)
     {
       fprintf(fptext,"\nm1 title %i '%s'",i,one_fd.m1_tit[i]);
     }
     for (i=0;i<M1_LOK_N;i++)
     {
       fprintf(fptext,"\nm1 localization %i '%s'",i,one_fd.m1_lok[i]);
     }
     /* end new in v4.1 */
     /* begin new for v4.1 */
     fprintf(fptext,"\n");
     for (i=0;i<M2_AUT_N;i++)
     {
       fprintf(fptext,"\nm2 authors %i '%s'",i,one_fd.m2_aut[i]);
     }
     for (i=0;i<M2_TIT_N;i++)
     {
       fprintf(fptext,"\nm2 title %i '%s'",i,one_fd.m2_tit[i]);
     }
     for (i=0;i<M2_LOK_N;i++)
     {
       fprintf(fptext,"\nm2 localization %i '%s'",i,one_fd.m2_lok[i]);
     }
     /* end new for v4.1 */


     fprintf(fptext,"\n");
     fprintf(fptext,"\nj1 authors string type '%s'",one_fd.fdauttyp_j1);
     fprintf(fptext,"\nb1 editors string type '%s'",one_fd.fdauttyp_b1);
     fprintf(fptext,"\nb2 authors string type '%s'",one_fd.fdauttyp_b2au);
     fprintf(fptext,"\nb2 editors string type '%s'",one_fd.fdauttyp_b2ed);
     fprintf(fptext,"\nm1 authors string type '%s'",one_fd.fdauttyp_m1);  /* new for v4.1*/

     fprintf(fptext,"\n");
     fprintf(fptext,"\nj1 delimiter ^1 in authors string '%s'",one_fd.fdbetwau_j1);
     fprintf(fptext,"\nb1 delimiter ^1 in editors string '%s'",one_fd.fdbetwau_b1);
     fprintf(fptext,"\nb2 delimiter ^1 in authors string '%s'",one_fd.fdbetwau_b2au);
     fprintf(fptext,"\nb2 delimiter ^1 in editors string '%s'",one_fd.fdbetwau_b2ed);
     fprintf(fptext,"\nm1 delimiter ^1 in authors string '%s'",one_fd.fdbetwau_m1);  /* new for v4.1*/

     fprintf(fptext,"\n");
     fprintf(fptext,"\nj1 delimiter ^2 in authors string '%s'",one_fd.fdbetwaulast_j1);
     fprintf(fptext,"\nb1 delimiter ^2 in editors string '%s'",one_fd.fdbetwaulast_b1);
     fprintf(fptext,"\nb2 delimiter ^2 in authors string '%s'",one_fd.fdbetwaulast_b2au);
     fprintf(fptext,"\nb2 delimiter ^2 in editors string '%s'",one_fd.fdbetwaulast_b2ed);
     fprintf(fptext,"\nm1 delimiter ^2 in authors string '%s'",one_fd.fdbetwaulast_m1);  /* new for v4.1*/

     fprintf(fptext,"\n");
     fprintf(fptext,"\nj1 delimiter ^3 in authors string '%s'",one_fd.fdv_j1);
     fprintf(fptext,"\nb1 delimiter ^3 in editors string '%s'",one_fd.fdv_b1);
     fprintf(fptext,"\nb2 delimiter ^3 in authors string '%s'",one_fd.fdv_b2au);
     fprintf(fptext,"\nb2 delimiter ^3 in editors string '%s'",one_fd.fdv_b2ed);
     fprintf(fptext,"\nm1 delimiter ^3 in authors string '%s'",one_fd.fdv_m1);  /* new for v4.1*/

     fprintf(fptext,"\n");
     fprintf(fptext,"\nj1 delimiter ^4 in authors string '%s'",one_fd.fdauvornach_j1);
     fprintf(fptext,"\nb1 delimiter ^4 in editors string '%s'",one_fd.fdauvornach_b1);
     fprintf(fptext,"\nb2 delimiter ^4 in authors string '%s'",one_fd.fdauvornach_b2au);
     fprintf(fptext,"\nb2 delimiter ^4 in editors string '%s'",one_fd.fdauvornach_b2ed);
     fprintf(fptext,"\nm1 delimiter ^4 in authors string '%s'",one_fd.fdauvornach_m1);  /* new for v4.1*/

     fprintf(fptext,"\n");
     fprintf(fptext,"\nj1 delimiter ^5 in authors string '%s'",one_fd.fdaunachvor_j1);
     fprintf(fptext,"\nb1 delimiter ^5 in editors string '%s'",one_fd.fdaunachvor_b1);
     fprintf(fptext,"\nb2 delimiter ^5 in authors string '%s'",one_fd.fdaunachvor_b2au);
     fprintf(fptext,"\nb2 delimiter ^5 in editors string '%s'",one_fd.fdaunachvor_b2ed);
     fprintf(fptext,"\nm1 delimiter ^5 in authors string '%s'",one_fd.fdaunachvor_m1);  /* new for v4.1*/

     fprintf(fptext,"\n");
     fprintf(fptext,"\nj1 delimiter ^6 in authors string '%s'",one_fd.fdafterlastau_j1);
     fprintf(fptext,"\nb1 delimiter ^6 in editors string '%s'",one_fd.fdafterlastau_b1);
     fprintf(fptext,"\nb2 delimiter ^6 in authors string '%s'",one_fd.fdafterlastau_b2au);
     fprintf(fptext,"\nb2 delimiter ^6 in editors string '%s'",one_fd.fdafterlastau_b2ed);
     fprintf(fptext,"\nm1 delimiter ^6 in authors string '%s'",one_fd.fdafterlastau_m1);  /* new for v4.1*/

     fprintf(fptext,"\n");
     fprintf(fptext,"\nj1 delimiter more names in authors string '%s'",one_fd.fdweitereau_j1);
     fprintf(fptext,"\nb1 delimiter more names in editors string '%s'",one_fd.fdweitereau_b1);
     fprintf(fptext,"\nb2 delimiter more names in authors string '%s'",one_fd.fdweitereau_b2au);
     fprintf(fptext,"\nb2 delimiter more names in editors string '%s'",one_fd.fdweitereau_b2ed);
     fprintf(fptext,"\nm1 delimiter more names in authors string '%s'",one_fd.fdweitereau_m1);  /* new for v4.1*/

     fprintf(fptext,"\n");
     fprintf(fptext,"\nj1 n in authors string '%s'",one_fd.fdau_n_j1);
     fprintf(fptext,"\nb1 n in editors string '%s'",one_fd.fdau_n_b1);
     fprintf(fptext,"\nb2 n in authors string '%s'",one_fd.fdau_n_b2au);
     fprintf(fptext,"\nb2 n in editors string '%s'",one_fd.fdau_n_b2ed);
     fprintf(fptext,"\nm1 n in authors string '%s'",one_fd.fdau_n_m1);  /* new for v4.1*/

     fprintf(fptext,"\n");
     fprintf(fptext,"\nj1 m in authors string '%s'",one_fd.fdau_m_j1);
     fprintf(fptext,"\nb1 m in editors string '%s'",one_fd.fdau_m_b1);
     fprintf(fptext,"\nb2 m in authors string '%s'",one_fd.fdau_m_b2au);
     fprintf(fptext,"\nb2 m in editors string '%s'",one_fd.fdau_m_b2ed);
     fprintf(fptext,"\nm1 m in authors string '%s'",one_fd.fdau_m_m1);  /* new for v4.1*/
     fprintf(fptext,"\n\n");
   } else
   {
     fprintf(fptext,RFD_FORMAT_DEFINITION,FORMKENNUNG_LEN);
     fprintf(fptext,"\nformat definition '%s'",one_fd.formkennung);
     
     fprintf(fptext,RFD_DESCRIPTION,FORMATBESCHREIBUNG_LEN);
     fprintf(fptext,"\ndescription '%s'",one_fd.formatbeschreibung);

     fprintf(fptext,RFD_J1_STRINGS,TYP_STRING_LEN);
     fprintf(fptext,"\nj1 string 1 '%s'",one_fd.fdj1_str1);
     fprintf(fptext,"\nj1 string 2 '%s'",one_fd.fdj1_str2);
     fprintf(fptext,"\nj1 string 3 '%s'",one_fd.fdj1_str3);

     /* begin new for v4.1 */
     fprintf(fptext,RFD_J2_STRINGS,TYP_STRING_LEN);
     fprintf(fptext,"\nj2 string 1 '%s'",one_fd.fdj2_str1);
     fprintf(fptext,"\nj2 string 2 '%s'",one_fd.fdj2_str2);
     fprintf(fptext,"\nj2 string 3 '%s'",one_fd.fdj2_str3);
     /* end new for v4.1 */

     fprintf(fptext,RFD_B1_STRINGS,TYP_STRING_LEN);
     fprintf(fptext,"\nb1 string 1 '%s'",one_fd.fdb1_str1);
     fprintf(fptext,"\nb1 string 2 '%s'",one_fd.fdb1_str2);
     fprintf(fptext,"\nb1 string 3 '%s'",one_fd.fdb1_str3);

     fprintf(fptext,RFD_B2_STRINGS,TYP_STRING_LEN);
     fprintf(fptext,"\nb2 string 1 '%s'",one_fd.fdb2_str1);
     fprintf(fptext,"\nb2 string 2 '%s'",one_fd.fdb2_str2);
     fprintf(fptext,"\nb2 string 3 '%s'",one_fd.fdb2_str3);
     fprintf(fptext,"\nb2 string 4 '%s'",one_fd.fdb2_str4);
     fprintf(fptext,"\nb2 string 5 '%s'",one_fd.fdb2_str5);

     /* begin new for v4.1 */
     fprintf(fptext,RFD_B3_STRINGS,TYP_STRING_LEN);
     fprintf(fptext,"\nb3 string 1 '%s'",one_fd.fdb3_str1);
     fprintf(fptext,"\nb3 string 2 '%s'",one_fd.fdb3_str2);
     fprintf(fptext,"\nb3 string 3 '%s'",one_fd.fdb3_str3);
     /* end new for v4.1 */

     /* begin new for v4.1 */
     fprintf(fptext,RFD_M1_STRINGS,TYP_STRING_LEN);
     fprintf(fptext,"\nm1 string 1 '%s'",one_fd.fdm1_str1);
     fprintf(fptext,"\nm1 string 2 '%s'",one_fd.fdm1_str2);
     fprintf(fptext,"\nm1 string 3 '%s'",one_fd.fdm1_str3);
     /* end new for v4.1 */
     /* begin new for v4.1 */
     fprintf(fptext,RFD_M2_STRINGS,TYP_STRING_LEN);
     fprintf(fptext,"\nm2 string 1 '%s'",one_fd.fdm2_str1);
     fprintf(fptext,"\nm2 string 2 '%s'",one_fd.fdm2_str2);
     fprintf(fptext,"\nm2 string 3 '%s'",one_fd.fdm2_str3);
     /* end new for v4.1 */

     fprintf(fptext,RFD_J1_AUTHORS,FD_FELD_LEN);
     for (i=0;i<J1_AUT_N;i++)
     {
       fprintf(fptext,"\nj1 authors %i '%s'",i,one_fd.j1_aut[i]);
     }
     fprintf(fptext,RFD_J1_TITLE,FD_FELD_LEN);
     for (i=0;i<J1_TIT_N;i++)
     {
       fprintf(fptext,"\nj1 title %i '%s'",i,one_fd.j1_tit[i]);
     }
     fprintf(fptext,RFD_J1_LOK,FD_FELD_LEN);
     for (i=0;i<J1_LOK_N;i++)
     {
       fprintf(fptext,"\nj1 localization %i '%s'",i,one_fd.j1_lok[i]);
     }

     /* begin new for v4.1 */
     fprintf(fptext,RFD_J2_AUTHORS,FD_FELD_LEN);
     for (i=0;i<J2_AUT_N;i++)
     {
       fprintf(fptext,"\nj2 authors %i '%s'",i,one_fd.j2_aut[i]);
     }
     fprintf(fptext,RFD_J2_TITLE,FD_FELD_LEN);
     for (i=0;i<J2_TIT_N;i++)
     {
       fprintf(fptext,"\nj2 title %i '%s'",i,one_fd.j2_tit[i]);
     }
     fprintf(fptext,RFD_J2_LOK,FD_FELD_LEN);
     for (i=0;i<J2_LOK_N;i++)
     {
       fprintf(fptext,"\nj2 localization %i '%s'",i,one_fd.j2_lok[i]);
     }
     /* end new for v4.1 */

     fprintf(fptext,RFD_B1_EDITORS,FD_FELD_LEN);
     for (i=0;i<B1_ED_N;i++)
     {
       fprintf(fptext,"\nb1 editors %i '%s'",i,one_fd.b1_ed[i]);
     }
     fprintf(fptext,RFD_B1_TITLE,FD_FELD_LEN);
     for (i=0;i<B1_TIT_N;i++)
     {
       fprintf(fptext,"\nb1 book-title %i '%s'",i,one_fd.b1_tit[i]);
     }
     fprintf(fptext,RFD_B1_LOK,FD_FELD_LEN);
     for (i=0;i<B1_LOK_N;i++)
     {
       fprintf(fptext,"\nb1 localization %i '%s'",i,one_fd.b1_lok[i]);
     }
     
     fprintf(fptext,RFD_B2_AUTHORS,FD_FELD_LEN);
     for (i=0;i<B2_AUT_N;i++)
     {
       fprintf(fptext,"\nb2 authors %i '%s'",i,one_fd.b2_aut[i]);
     }
     fprintf(fptext,RFD_B2_TITLE,FD_FELD_LEN);
     for (i=0;i<B2_TIT_N;i++)
     {
       fprintf(fptext,"\nb2 title %i '%s'",i,one_fd.b2_tit[i]);
     }
     fprintf(fptext,RFD_B2_EDITORS,FD_FELD_LEN);
     for (i=0;i<B2_ED_N;i++)
     {
       fprintf(fptext,"\nb2 editors %i '%s'",i,one_fd.b2_ed[i]);
     }
     fprintf(fptext,RFD_B2_BOOK_TITLE,FD_FELD_LEN);
     for (i=0;i<B2_TITB_N;i++)
     {
       fprintf(fptext,"\nb2 book-title %i '%s'",i,one_fd.b2_titb[i]);
     }
     fprintf(fptext,RFD_B2_LOK,FD_FELD_LEN);
     for (i=0;i<B2_LOK_N;i++)
     {
       fprintf(fptext,"\nb2 localization %i '%s'",i,one_fd.b2_lok[i]);
     }

     /* begin new for v4.1 */
     fprintf(fptext,RFD_B3_EDITORS,FD_FELD_LEN);
     for (i=0;i<B3_ED_N;i++)
     {
       fprintf(fptext,"\nb3 editors %i '%s'",i,one_fd.b3_ed[i]);
     }
     fprintf(fptext,RFD_B3_TITLE,FD_FELD_LEN);
     for (i=0;i<B3_TIT_N;i++)
     {
       fprintf(fptext,"\nb3 book-title %i '%s'",i,one_fd.b3_tit[i]);
     }
     fprintf(fptext,RFD_B3_LOK,FD_FELD_LEN);
     for (i=0;i<B3_LOK_N;i++)
     {
       fprintf(fptext,"\nb3 localization %i '%s'",i,one_fd.b3_lok[i]);
     }
     /* end new for v4.1 */
     
     /* begin new for v4.1 */
     fprintf(fptext,RFD_M1_AUTHORS,FD_FELD_LEN);
     for (i=0;i<M1_AUT_N;i++)
     {
       fprintf(fptext,"\nm1 authors %i '%s'",i,one_fd.m1_aut[i]);
     }
     fprintf(fptext,RFD_M1_TITLE,FD_FELD_LEN);
     for (i=0;i<M1_TIT_N;i++)
     {
       fprintf(fptext,"\nm1 title %i '%s'",i,one_fd.m1_tit[i]);
     }
     fprintf(fptext,RFD_M1_LOK,FD_FELD_LEN);
     for (i=0;i<M1_LOK_N;i++)
     {
       fprintf(fptext,"\nm1 localization %i '%s'",i,one_fd.m1_lok[i]);
     }
     /* end new for v4.1 */
     /* begin new for v4.1 */
     fprintf(fptext,RFD_M2_AUTHORS,FD_FELD_LEN);
     for (i=0;i<M2_AUT_N;i++)
     {
       fprintf(fptext,"\nm2 authors %i '%s'",i,one_fd.m2_aut[i]);
     }
     fprintf(fptext,RFD_M2_TITLE,FD_FELD_LEN);
     for (i=0;i<M2_TIT_N;i++)
     {
       fprintf(fptext,"\nm2 title %i '%s'",i,one_fd.m2_tit[i]);
     }
     fprintf(fptext,RFD_M2_LOK,FD_FELD_LEN);
     for (i=0;i<M2_LOK_N;i++)
     {
       fprintf(fptext,"\nm2 localization %i '%s'",i,one_fd.m2_lok[i]);
     }
     /* end new for v4.1 */

     fprintf(fptext,RFD_FDAUTTYP,AUTTYP_LEN);
     fprintf(fptext,"\nj1 authors string type '%s'",one_fd.fdauttyp_j1);
     fprintf(fptext,"\nb1 editors string type '%s'",one_fd.fdauttyp_b1);
     fprintf(fptext,"\nb2 authors string type '%s'",one_fd.fdauttyp_b2au);
     fprintf(fptext,"\nb2 editors string type '%s'",one_fd.fdauttyp_b2ed);
     fprintf(fptext,"\nm1 authors string type '%s'",one_fd.fdauttyp_m1);  /* new for v4.1*/


     fprintf(fptext,RFD_FDBETWAU,FD_FELD_LEN);
     fprintf(fptext,"\nj1 delimiter ^1 in authors string '%s'",one_fd.fdbetwau_j1);
     fprintf(fptext,"\nb1 delimiter ^1 in editors string '%s'",one_fd.fdbetwau_b1);
     fprintf(fptext,"\nb2 delimiter ^1 in authors string '%s'",one_fd.fdbetwau_b2au);
     fprintf(fptext,"\nb2 delimiter ^1 in editors string '%s'",one_fd.fdbetwau_b2ed);
     fprintf(fptext,"\nm1 delimiter ^1 in authors string '%s'",one_fd.fdbetwau_m1);  /* new for v4.1*/

     fprintf(fptext,RFD_FDBETWAULAST,FD_FELD_LEN);
     fprintf(fptext,"\nj1 delimiter ^2 in authors string '%s'",one_fd.fdbetwaulast_j1);
     fprintf(fptext,"\nb1 delimiter ^2 in editors string '%s'",one_fd.fdbetwaulast_b1);
     fprintf(fptext,"\nb2 delimiter ^2 in authors string '%s'",one_fd.fdbetwaulast_b2au);
     fprintf(fptext,"\nb2 delimiter ^2 in editors string '%s'",one_fd.fdbetwaulast_b2ed);
     fprintf(fptext,"\nm1 delimiter ^2 in authors string '%s'",one_fd.fdbetwaulast_m1);  /* new for v4.1*/

     fprintf(fptext,RFD_FDV,FD_FELD_LEN);
     fprintf(fptext,"\nj1 delimiter ^3 in authors string '%s'",one_fd.fdv_j1);
     fprintf(fptext,"\nb1 delimiter ^3 in editors string '%s'",one_fd.fdv_b1);
     fprintf(fptext,"\nb2 delimiter ^3 in authors string '%s'",one_fd.fdv_b2au);
     fprintf(fptext,"\nb2 delimiter ^3 in editors string '%s'",one_fd.fdv_b2ed);
     fprintf(fptext,"\nm1 delimiter ^3 in authors string '%s'",one_fd.fdv_m1);  /* new for v4.1*/

     fprintf(fptext,RFD_FDAUVORNACH,FD_FELD_LEN);
     fprintf(fptext,"\nj1 delimiter ^4 in authors string '%s'",one_fd.fdauvornach_j1);
     fprintf(fptext,"\nb1 delimiter ^4 in editors string '%s'",one_fd.fdauvornach_b1);
     fprintf(fptext,"\nb2 delimiter ^4 in authors string '%s'",one_fd.fdauvornach_b2au);
     fprintf(fptext,"\nb2 delimiter ^4 in editors string '%s'",one_fd.fdauvornach_b2ed);
     fprintf(fptext,"\nm1 delimiter ^4 in authors string '%s'",one_fd.fdauvornach_m1);  /* new for v4.1*/

     fprintf(fptext,RFD_FDAUNACHVOR,FD_FELD_LEN);
     fprintf(fptext,"\nj1 delimiter ^5 in authors string '%s'",one_fd.fdaunachvor_j1);
     fprintf(fptext,"\nb1 delimiter ^5 in editors string '%s'",one_fd.fdaunachvor_b1);
     fprintf(fptext,"\nb2 delimiter ^5 in authors string '%s'",one_fd.fdaunachvor_b2au);
     fprintf(fptext,"\nb2 delimiter ^5 in editors string '%s'",one_fd.fdaunachvor_b2ed);
     fprintf(fptext,"\nm1 delimiter ^5 in authors string '%s'",one_fd.fdaunachvor_m1);  /* new for v4.1*/

     fprintf(fptext,RFD_FDAFTERLASTAU,FD_FELD_LEN);
     fprintf(fptext,"\nj1 delimiter ^6 in authors string '%s'",one_fd.fdafterlastau_j1);
     fprintf(fptext,"\nb1 delimiter ^6 in editors string '%s'",one_fd.fdafterlastau_b1);
     fprintf(fptext,"\nb2 delimiter ^6 in authors string '%s'",one_fd.fdafterlastau_b2au);
     fprintf(fptext,"\nb2 delimiter ^6 in editors string '%s'",one_fd.fdafterlastau_b2ed);
     fprintf(fptext,"\nm1 delimiter ^6 in authors string '%s'",one_fd.fdafterlastau_m1);  /* new for v4.1*/

     fprintf(fptext,RFD_FDWEITEREAU,FD_FELD_LEN);
     fprintf(fptext,"\nj1 delimiter more names in authors string '%s'",one_fd.fdweitereau_j1);
     fprintf(fptext,"\nb1 delimiter more names in editors string '%s'",one_fd.fdweitereau_b1);
     fprintf(fptext,"\nb2 delimiter more names in authors string '%s'",one_fd.fdweitereau_b2au);
     fprintf(fptext,"\nb2 delimiter more names in editors string '%s'",one_fd.fdweitereau_b2ed);
     fprintf(fptext,"\nm1 delimiter more names in authors string '%s'",one_fd.fdweitereau_m1);  /* new for v4.1*/

     fprintf(fptext,RFD_FDAU_N,ZIFFER_STRING_LEN);
     fprintf(fptext,"\nj1 n in authors string '%s'",one_fd.fdau_n_j1);
     fprintf(fptext,"\nb1 n in editors string '%s'",one_fd.fdau_n_b1);
     fprintf(fptext,"\nb2 n in authors string '%s'",one_fd.fdau_n_b2au);
     fprintf(fptext,"\nb2 n in editors string '%s'",one_fd.fdau_n_b2ed);
     fprintf(fptext,"\nm1 n in authors string '%s'",one_fd.fdau_n_m1);  /* new for v4.1*/

     fprintf(fptext,RFD_FDAU_M,ZIFFER_STRING_LEN);
     fprintf(fptext,"\nj1 m in authors string '%s'",one_fd.fdau_m_j1);
     fprintf(fptext,"\nb1 m in editors string '%s'",one_fd.fdau_m_b1);
     fprintf(fptext,"\nb2 m in authors string '%s'",one_fd.fdau_m_b2au);
     fprintf(fptext,"\nb2 m in editors string '%s'",one_fd.fdau_m_b2ed);
     fprintf(fptext,"\nm1 m in authors string '%s'",one_fd.fdau_m_m1);  /* new for v4.1*/
     fprintf(fptext,"\n\n");
   }
   fprintf(fptext,"END OF BIBLIOGRAPHIC STYLE FORMAT DEFINITION");
   fprintf(fptext,"\n\n");

   if (!quiet)
   {
     sprintf(wrtxtbu,"\n(Format definition text file `%s' written)\n",
              text_name);
     wrtxt(wrtxtbu);
     sprintf(wrtxtbu,"Format definition text file "
       "\n  `%s' written", text_name);
     protokollieren(wrtxtbu);
   }
   fclose(fptext);
   return 1;
}

static void rfd_rec_loeschen(void)
{
   FILE * fpformdef;
   FILE * fpformdeftemp;
   long del_rec, i, anzahl_records, byte_zeiger;
   char formdef_temp_name[PFAD_LEN +1];
   formdef_rec  fd_lokal; 
   /* formdef_name */
   
   strlimcpy(formdef_temp_name,rdbpfad,PFAD_LEN);
   strlimcat(formdef_temp_name,FD_TEMP_DAT,PFAD_LEN);
   del_rec = fd_datensatz_auswaehlen();
   if (del_rec == -1)
   {
      wrtxt("\n(No record deleted)\n");
      return;
   }
   if (!do_delete_yn())
   {
      wrtxt("\n(No record deleted)\n");
      return;
   }
   if (del_rec > -1)
   {
      if ((fpformdef=fopen(formdef_name,"rb"))==0)
      {
        fprintf(stderr,"\nERROR: cannot read %s\n",formdef_name);
        exit(1);
      }
      if ((fpformdeftemp=fopen(formdef_temp_name,"wb"))==NULL)
      {
        fprintf(stderr,"\nERROR: cannot create %s\n",formdef_temp_name);
        exit(1);
      }
      fseek(fpformdef,0L,SEEK_END);

      byte_zeiger = ftell(fpformdef);
      anzahl_records = byte_zeiger / sizeof(fd_lokal);
      anzahl_records--;
      memset(&fd_lokal,0,sizeof(fd_lokal));
      rewind(fpformdef);
      for (i=0;i<=anzahl_records;i++)
      {
         fread(&fd_lokal,sizeof(fd_lokal),1,fpformdef);
         if (i!=del_rec)
         {
             if (fwrite(&fd_lokal,sizeof(fd_lokal),1,fpformdeftemp) < 1) schreibfehler();
         }
      }
      fclose(fpformdeftemp);
      fclose(fpformdef);
      remove(formdef_name);
      rename(formdef_temp_name,formdef_name);
      sprintf(wrtxtbu,"\n(Record `%li' deleted)\n",del_rec);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"Format definition table: record %li deleted",
        del_rec);
      protokollieren(wrtxtbu);
   } else
   {
      wrtxt("\n(No record deleted)\n");
   }
}
