/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

#ifndef RFD_TEXTE_H
#define RFD_TEXTE_H

#define RFD_FORMAT_DEFINITION  "\n\
--\n\
-- short name (key) of format definition\n\
--\n\
-- width: %i\n\
--"


#define RFD_DESCRIPTION "\n\n\
--\n\
-- description of bibliographic format definition\n\
--\n\
-- width %i\n\
--"

#define RFD_J1_STRINGS "\n\n\
--\n\
-- major elements (lines) for document type `journal article' (j1):\n\
-- sequence of list of authors (%%au), title (%%ti), localization (%%lo)\n\
--\n\
-- width: %i\n\
--"

#define RFD_J2_STRINGS "\n\n\
--\n\
-- major elements (lines) for document type `journal article' with\n\
-- institutional author (j2): sequence of author (%%au), title (%%ti),\n\
-- localization (%%lo)\n\
--\n\
-- width: %i\n\
--"

#define RFD_B1_STRINGS "\n\n\
--\n\
-- major elements (lines) for document type `book' (b1):\n\
-- sequence of list of editors (%%ed), book-title (%%bo), localization (%%lo)\n\
--\n\
-- width: %i\n\
--"

#define RFD_B2_STRINGS "\n\n\
--\n\
-- major elements (lines) for document type `chapter/article in a book' (b2):\n\
-- sequence of list of authors (%%au), book-title (%%bo), title of article (%%ti)\n\
-- list of editors (%%ed), localization (%%lo)\n\
--\n\
-- width: %i\n\
--"

#define RFD_B3_STRINGS "\n\n\
--\n\
-- major elements (lines) for document type `book' with institutional\n\
-- editor (b3): sequence of editor (%%ed), book-title (%%bo),\n\
-- localization (%%lo)\n\
--\n\
-- width: %i\n\
--"

#define RFD_M1_STRINGS "\n\n\
--\n\
-- major elements (lines) for document type `miscellanea' (m1):\n\
-- sequence of list of authors (%%au), title (%%ti), localization (%%lo)\n\
--\n\
-- width: %i\n\
--"

#define RFD_M2_STRINGS "\n\n\
--\n\
-- major elements (lines) for document type `miscellanea' with institutional\n\
-- author (m2): sequence of list of authors (%%au), title (%%ti),\n\
-- localization (%%lo)\n\
--\n\
-- width: %i\n\
--"

#define RFD_J1_AUTHORS "\n\n\
--\n\
-- list of authors line (journal article)\n\
--\n\
-- width: %i\n\
--"


#define RFD_J1_TITLE "\n\n\
--\n\
-- title line (journal article)\n\
--\n\
-- width: %i\n\
--"


#define RFD_J1_LOK "\n\n\
--\n\
-- localization line (journal article)\n\
--\n\
-- width: %i\n\
--"

#define RFD_J2_AUTHORS "\n\n\
--\n\
-- author line (journal article with institutional author)\n\
--\n\
-- width: %i\n\
--"


#define RFD_J2_TITLE "\n\n\
--\n\
-- title line (journal article with institutional author)\n\
--\n\
-- width: %i\n\
--"


#define RFD_J2_LOK "\n\n\
--\n\
-- localization line (journal article with institutional author)\n\
--\n\
-- width: %i\n\
--"


#define RFD_B1_EDITORS "\n\n\
--\n\
-- list of editors line (book)\n\
--\n\
-- width: %i\n\
--"


#define RFD_B1_TITLE "\n\n\
--\n\
-- title line (book)\n\
--\n\
-- width: %i\n\
--"


#define RFD_B1_LOK "\n\n\
--\n\
-- localization line (book)\n\
--\n\
-- width: %i\n\
--"


#define RFD_B2_AUTHORS "\n\n\
--\n\
-- list of authors line (chapter/article in a book)\n\
--\n\
-- width: %i\n\
--"

#define RFD_B2_TITLE "\n\n\
--\n\
-- title line (chapter/article in a book)\n\
--\n\
-- width: %i\n\
--"


#define RFD_B2_EDITORS "\n\n\
--\n\
-- list of editors line (chapter/article in a book)\n\
--\n\
-- width: %i\n\
--"


#define RFD_B2_BOOK_TITLE "\n\n\
--\n\
-- book title line (chapter/article in a book)\n\
--\n\
-- width: %i\n\
--"


#define RFD_B2_LOK "\n\n\
--\n\
-- localization line (chapter/article in a book)\n\
--\n\
-- width: %i\n\
--"

#define RFD_B3_EDITORS "\n\n\
--\n\
-- editor line (book with institutional editor)\n\
--\n\
-- width: %i\n\
--"


#define RFD_B3_TITLE "\n\n\
--\n\
-- title line (book with institutional editor)\n\
--\n\
-- width: %i\n\
--"


#define RFD_B3_LOK "\n\n\
--\n\
-- localization line (book with institutional editor)\n\
--\n\
-- width: %i\n\
--"

#define RFD_M1_AUTHORS "\n\n\
--\n\
-- list of authors line (miscellanea)\n\
--\n\
-- width: %i\n\
--"


#define RFD_M1_TITLE "\n\n\
--\n\
-- title line (miscellanea)\n\
--\n\
-- width: %i\n\
--"


#define RFD_M1_LOK "\n\n\
--\n\
-- localization line (miscellanea)\n\
--\n\
-- width: %i\n\
--"


#define RFD_M2_AUTHORS "\n\n\
--\n\
-- list of authors line (miscellanea with institutional author)\n\
--\n\
-- width: %i\n\
--"


#define RFD_M2_TITLE "\n\n\
--\n\
-- title line (miscellanea with institutional author)\n\
--\n\
-- width: %i\n\
--"


#define RFD_M2_LOK "\n\n\
--\n\
-- localization line (miscellanea with institutional author)\n\
--\n\
-- width: %i\n\
--"


#define RFD_FDAUTTYP "\n\n\
--\n\
-- list of authors/editors lines (j1, b1, b2, m1)\n\
--\n\
-- sequence of first names and names type (0, 1, 2 or 3)\n\
--\n\
-- width: %i\n\
--"



#define RFD_FDBETWAU "\n\n\
--\n\
-- list of authors/editors lines (j1, b1, b2, m1)\n\
--\n\
-- delimiter (1) between authors'/editors' names\n\
--\n\
-- width: %i\n\
--"


#define RFD_FDBETWAULAST "\n\n\
--\n\
-- list of authors/editors lines (j1, b1, b2, m1)\n\
--\n\
-- delimiter (2) between last two authors'/editors' names\n\
--\n\
-- width: %i\n\
--"


#define RFD_FDV "\n\n\
--\n\
-- list of authors/editors lines (j1, b1, b2, m1)\n\
--\n\
-- delimiter (3) after first name\n\
--\n\
-- width: %i\n\
--"

#define RFD_FDAUVORNACH "\n\n\
--\n\
-- list of authors/editors lines (j1, b1, b2, m1)\n\
--\n\
-- delimiter (4) between first name (forename) and name\n\
--\n\
-- width: %i\n\
--"


#define RFD_FDAUNACHVOR "\n\n\
--\n\
-- list of authors/editors lines (j1, b1, b2, m1)\n\
--\n\
-- delimiter (5) between name and first name (forename)\n\
--\n\
-- width: %i\n\
--"


#define RFD_FDAFTERLASTAU "\n\n\
--\n\
-- list of authors/editors lines (j1, b1, b2, m1)\n\
--\n\
-- delimiter (6) after last name in list\n\
--\n\
-- width: %i\n\
--"


#define RFD_FDWEITEREAU "\n\n\
--\n\
-- list of authors/editors lines (j1, b1, b2, m1)\n\
--\n\
-- text indicating more authors/editors (e. g. `et al.')\n\
--\n\
-- width: %i\n\
--"


#define RFD_FDAU_N "\n\n\
--\n\
-- list of authors/editors lines (j1, b1, b2, m1)\n\
--\n\
-- maximal number of authors/editors printed (n: 1-999)\n\
--\n\
-- width: %i\n\
--"


#define RFD_FDAU_M "\n\n\
--\n\
-- list of authors/editors lines (j1, b1, b2, m1)\n\
--\n\
-- number of authors/editors printed (m: 1-999), if number of authors/editors\n\
-- is greater than n\n\
--\n\
-- width: %i\n\
--"

#endif
