@q Copyright 2012-2022, Alexander Shibakov@>
@q This file is part of SPLinT@>

@q SPLinT is free software: you can redistribute it and/or modify@>
@q it under the terms of the GNU General Public License as published by@>
@q the Free Software Foundation, either version 3 of the License, or@>
@q (at your option) any later version.@>

@q SPLinT is distributed in the hope that it will be useful,@>
@q but WITHOUT ANY WARRANTY; without even the implied warranty of@>
@q MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the@>
@q GNU General Public License for more details.@>

@q You should have received a copy of the GNU General Public License@>
@q along with SPLinT.  If not, see <http://www.gnu.org/licenses/>.@>

@**Philosophy.
This section should, perhaps, be more appropriately called {\it rant\/} but
{\it philosophy\/} sounds more academic. The design of any software involves
numerous choices, and \splint\ is no exception. Some of these choices
are explained in the appropriate places in the package files. This
section collects a few `big picture' viewpoints that did not fit elsewhere.

@*1 On typographic convention.
It must seem quite perplexing to some readers that a
manual focussing on {\it pretty-printing\/} shows such a
wanton disregard for good typographic style. Haphazard choice of
layouts to present programming constructs, random overabundance of
fonts on almost every page are just a few of the many typographic sins
and design guffaws so amply manifested in this opus. The author must
take full responsibility for the lack of taste in this
document and has only one argument in his defense: this is not
merely a book for a good night read but a piece of technical
documentation. 

In many ways, the goal of this document is somewhat different from that
of a well-written manual: to display the main features
prominently and in logical order. After all, this is a package that is
intended to help {\it write\/} such manuals so it must inevitably
present some use cases that exhibit a variety of typographic styles
achievable with \splint. Needless to say, {\it variety\/} and
{\it consistency\/} seldom go hand in hand and it is the consistency that
makes for a pretty page. One of the objectives has been to reveal a
number of quite technical programming constructs so one should keep in
mind that it is assumed that the reader will want to look up the input
files to see how some (however ugly and esoteric) typographic effects
have been achieved.

On the other hand, to quote a clich\'e, beauty is in the eyes of the
beholder so what makes a book readable (or even beautiful) may well
depend on the reader's background. As an example, letterspacing
as a typographic device is almost universally reviled in Western
typography (aside from a few niche uses such as setting titles). In
Russian, however (at least until recently), letterspacing has been
routinely used for emphasis (or, as a Russian would put it, 
e$\,$m$\,$p$\,$h$\,$a$\,$s$\,$i$\,$s) in lieu of, say, {\it italics}. Before
I hear any objections from typography purists, let me just say that
this technique fits in perfectly with the way emphasis works in the
Russian speech: the speaker slowly enunciates the sounds of each word
(incidentally, emphasizing {\it emphasis\/} this way is a perfect example of the
inevitable failure of any attempted letterspaced highlighting in most
English texts). Letterspaced sentences are easy to find on a page, and
they set a special reading rhythm, which is an added bonus in many
cases, although their presense openly violates
the `universally gray pages are a must' dogma.

One final remark concerns the abundance of footnotes in this manual. I confess,
there is almost no reason for it $\ldots$ except {\em I like footnotes\/}!
They help introduce the air of mystery and adventure to an otherwise boring
text. They are akin to the author wispering a secret in the reader's
ear\footnote{Breaking convention by making the pages even less uniform is an added bonus.}.

@*1 Why GPL.
Selecting the license for this project involves more than the
availability of the source code. \TeX, by its very nature is an
interpreted\footnote{There are some exceptions to this, in the form of
preloaded {\em formats}.} language, so it
is not a matter of hiding anything from the reader or a potential
programmer. The \Cee\ code is a different matter but the source is not
that complicated. Reducing the licensing issue to the ability of
someone else to see the source code is a great
oversimplification. Short of getting into too many details of the so-called
`open source licenses' (other than GPL) and arguing with their advocates, let me simply
express my lack of understanding of the arguments purporting that
BSD-style licenses introduce more freedom by allowing a software
vendor to incorporate the BSD-licensed software into their
products. What benefit does one derive from such `extension' of software
freedom? Perhaps the hope that the `open source' (for the lack of a
better term) will prompt the vendor to follow the accepted free (or
any other, for that matter!) software standards and make its software
more interoperable with the free alternatives? A well-known software
giant's {\it embrace, extend, extinguish\/} philosophy shows how na\"{\i}ve and
misplaced such hopes are.

I am not going to argue for the benefits of free software at length, either
(such benefits seem self-evident to me, although the readers should
feel free to disagree). Let me just point out that the software companies
enjoy quite a few freedoms that we, as software consumers elect to
afford them. Among such freedoms are the ability to renege on any
promises made to us and withdraw any guarantees that we might enjoy.
As a result of such `release of any responsibility', the claims of increased
reliability or better support for the commercial software sound a
bit hollow. Free software, of course, does not provide any
guarantees, either but `you get what you paid for'.

Another well spread industry tactic is user brainwashing and
changing the culture (usually for the worse) in order to promote new
`user-friendly' features of commercial software. Instead of taking
advantage of computers as cognitive machines we have come to view
them as advanced media players that we interact with through
artificial, unnatural interfaces. Meaningless terminology (`UX' for
`user experience'? What in the world is `user experience'?)
proliferates, and programmers are all too happy to deceive themselves with
their newly discovered business prowess.

One would hope that the somewhat higher standards of the `real'
manufacturers might percolate to the software world, however, the
reality is very different. Not only has life-cycle `engineering' 
got to the point where manufacturers can predict the life spans of
their products precisely, embedded software in those products has
become an enabling technology that makes this `life design' much
easier. 

In effect, by embedding software in their products, hardware
manufacturers not only piggy-back on software's perceived complexity,
and argue that such complex systems cannot be made reliable, they have
an added incentive to uphold this image. The software weighs nothing,
memory is cheap, consumers are easy to deceive, thus `software is
expensive' and `reliable software is prohibitively so'. Designing reliable
software is quite possible, though, just look at programmable
thermostats, simple cellphones and other `invisible' gadgets we
enjoy. The `software ideology' with its `IP' lingo is spreading like a
virus even through the world of real things. We now expect products to
break and are too quick to forgive sloppy (or worse, malicious)
engineering that goes into everyday things. We are also getting
used to the idea that it is the manufacturers that get to dictate
the terms of use for `their' products and that we are merely
borrowing `their' stuff.

The GPL was conceived as an antidote to this scourge. This license is a
remarkable piece of `legal engineering': a self-propagating contract 
with a clearly outlined set of goals. While by itself it does not
guarantee reliability or quality, it does inhibit the spread of the `IP' 
(which is sometimes sarcastically, though quite perceptively,
`deabbreviated' as {\sl I}maginary {\sl P}roperty) disease through
software.

The industry has adapted, of course. So called (non GPL) `open source
licenses', that are supposed to be an improvement on GPL,
are a sort of `immune reaction' to the free software
movement. Describing GPL as `viral', creating dismissive acronims such as FLOSS to
refer to the free software, and spreading outright misinformation about GPL
are just a few of the tactics employed by the software companies.
Convince and confuse enough apathetic users and the
protections granted by GPL are no longer visible.

@*1 Why not C{\tt ++} or OOP in general.
The choice of the language was mainly driven by \ae sthetic motives:
\Ceepp\ has a bloated and confusing standard, partially supported by
various compilers. It seems that there is no agreement on what
\Ceepp\ really is or how to use some of its constructs. This is all
in contrast to \Cee\ with its well defined and concise body of
specifications and rather well established stylistics. The existence
of `obfuscated \Cee' is not good evidence of deficiency and \Ceepp\
is definitely not immune to this malady.

Object oriented design has certainly taken on an aura of a religious
dictate, universally adhered to and forcefully promoted by its
followers. Unfortunately, the definition of what constitutes an
`object-oriented' approach is rather vague. A few informal concepts are
commonly tossed about to give the illusion of a well developed
abstraction (such as `polymorphism', `encapsulation', and so on) but
definitions vary in both length and content, depending on the source.

On the syntactic level, some features of object-oriented languages are
undoubtedly very practical (such as a |this| pointer in \Ceepp),
however, many of those features can be effectively emulated with some
clever uses of an appropriate preprocessor (there are a few
exceptions, of course, |this| being one of them). The rest of the
`object-oriented philosophy' is just that: a design philosophy. Before
that we had structured programming, now there are patterns, extreme,
agile, reactive, etc. They might all find their uses, however, there
are always numerous exceptions (sometimes even global variables and
|goto|'s have their place, as well).

A pedantic reader might point out a few object-oriented features even
in the \TeX\ portion of the package and then accuse the author of
being `inconsistent'. I am always interested in possible improvements
in style but I am unlikely to consider any changes based solely on the
adherence to any particular design fad.

In short, OOP was not shunned simply because a `non-OOP' language was
chosen, instead, whatever approach or style was deemed most effective
was used. The author's judgment has not always been perfect, of course,
and given a good reason, changes can be made, including the choice of
the language. `Make it object-oriented' is neither a good reason nor a
clearly defined one, however.

@*1 Why not $*$\TeX.
Simple. I rarely, if ever\footnote{In some cases, a publisher would only accept
a \LaTeX\ document, sadly. Better than most alternatives though.},
use it and have no idea of how packages, classes,
etc., are designed. I have heard it has impressive mechanisms for
dealing with various problems commonly encountered in \TeX. Sadly, my
knowledge of $*$\TeX\ machinery is almost nonexistent\footnote{I am well familiar
with the programming that went into \LaTeX, which is of highest quality. I do not
share the design philosophy though and try to use only the most standard features}.
This may change but right now I have tried to make the macros as generic as possible,
hopefully making $*$\TeX\ adaptation easy\footnote{Unfortunately some redesign would
be certainly necessary. Thus, \splint\ relies on the way plain \TeX\ allocates token
registers so if the corresponding scheme in \LaTeX\ is drastically different, this
portion of the macros would have to be rewritten.}.

The following quote from \cite[Ho] makes me feel particularly uneasy
about the current state of development of various \TeX\ variants:
``{\it Finally, to many current programmers\/ \.{WEB} source simply feels over-documented
and even more important is that the general impression is that of a finished book:
sometimes it seems like\/ \.{WEB} actively discourages development. This is
a subjective point, but nevertheless a quite important one.}''

{\it Discouraging development\/} seems like a good feature to
me. Otherwise we are one step away from encouraging writing poor
software with inadequate tools merely `to encourage development'.

The feeling of a \.{WEB} source being {\it over-documented\/} is most
certainly subjective, and, I am sure, not shared by all `current
programmers'. The advantage of using \.{WEB}-like tools, however, is
that it gives the programmer the ability to place vital
information where it does not distract the reader (`developer',
`maintainer', call it whatever you like) from the logical flow of the
code. 

Some of the complaints in \cite[Ho] are definitely justified (see
below for a few similar criticisms of \CWEB),
although it seems that a better approach would be to write an improved
tool similar to \.{WEB}, rather than give up all the flexibility such
a tool provides.

@*1 Why \eatone{CWEB}\CWEB.
\CWEB\ is not as polished as \TeX\ but it works and has a
number of impressive features. It is, regrettably, a `niche' tool and
a few existing extensions of \CWEB\ and software based on similar ideas
do not enjoy the popularity they deserve. Literate philosophy has been
largely neglected even though it seems to have a more logical
foundation than OOP. Under these circumstances, \CWEB\ seemed to be
the best available option.

@*2 Some \eatone{CWEB}\CWEB\ idiosynchrasies.
\CWEB\ was among the first tools for literate programming intended
for public use\footnote{The original \WEB\ was designed to support
DEK's \TeX\ and \MF\ projects and was inteded for \Pascal\ family
languages.}. By almost every measure it is a very successful design:
the program mostly does what is intended, was used in a number of
projects, and made a significant contribution to the practice of {\it
literate programming}@^literate programming@>. It also gave rise to a
multitude of similar software packages (see, for example,
\noweb@^noweb@>\ by N.~Ramsey, \cite[Ra]), which proves the vitality
of the approach taken by the authors of \CWEB.

While the value of \CWEB\ is not in dispute, it would be healthy to
outline a few deficiencies\footnote{Quirks would be a better term.}
that became apparent after intensive (ab)use of this software. Before
we proceed to list our criticisms, however, the author must make a
disclaimer that not only most of the complaints below stem from trying
to use \CWEB\ outside of its intended field of application but such
use has also been hampered by the author's likely lack of familiarity
with some ot \CWEB's features.

The first (non)complaint that must be mentioned here is \CWEB's narrow
focus on \Cee-styled languages. The `grammar' used to process the
input is hard coded in \CWEAVE, so any changes to it inevitably
involve rewriting portions of the code and rebuilding \CWEAVE. As
\Cee11 came to prominence, a few of its constructs have been left
behind by \CWEAVE. Among the most obvious of these are variadic macros
and compound literals. The former is only a problem in \CWEB's \.{@@d}
style definitions (which are of questionable utility to begin with)
while the lack of support for the latter may be somewhat amended by
the  use of \.{@@[}$\ldots$\.{@@]} and \.{@@;} constructs to
manipulate \CWEAVE's perception of a given {\em chunk\/} as either an
{\em exp\/} or a {\em stmt}. This last mechanism of syntactic markup
is spartan but remarkably effective, although the code thus annotated
tends to be hard to read in the editor (while resulting in just as
beautifully typeset pages, nonetheless).

Granted, \CWEB's stated goal was to bring the technique of literate
programming to \Cee, \Ceepp, and related languages so the criticism
above must be viewed in this context. Since \CWEAVE\ outputs \TeX, one
avenue for customizing its use to one's needs is modifying the macros
in \.{cwebmac.tex}. \splint\ took this route by rewriting a number of
macros, ranging from simple operator displays (replacing, say, `$=$' with
`|=|') to extensively customizing the indexing mechanism.

Unfortunately, this strategy could only take one thus far. The \TeX\
output produced by \CWEAVE\ does not always avail itself to this
approach readily. To begin with, while combining its `chunks' into
larger ones, \CWEAVE\ dives in and out of the math mode unpredictably,
so any macros trying to read their `environment' must be ready to operate both
inside and outside of the math mode and leave the proper mode behind when
they are done. The situation is not helped by the fact that both the
beginning and the end of the math mode in \TeX\ are marked by the same
character (\.{\$}, and it costs you, indeed) so `expandable' macros
are difficult to design.

Adding to these difficulties is \CWEAVE's facility to insert raw \TeX\
material in the middle of its input (the \.{@@t}$\ldots$\.{@@>}
construct). While rather flexible, by default it puts all such user
supplied \TeX\ fragments inside an \.{\\hbox} which brings with it all
the advantages, and, unfortunately, disadvantages of grouping,
inability to introduce line breaks within the fragment, etc. There is,
of course, an easy fix to most of these woes, outlined in \CWEB's
manual: one can simply type \.{@@t\}}$\,$\TeX\ stuff$\,$\.{\{@@>} which
inserts \.{\\hbox\{\}}$\,$\TeX\ stuff$\,$\.{\{\}} into \CWEAVE's output. The
cost of this hack (aside from looking and feeling rather ugly on the
editor screen, not to mention disrupting the editor's brace
accounting) is a superfluous \.{\\hbox\{\}} left behind {\em before\/}
the `\TeX\ stuff'. The programmer provided \TeX\ code is unable to
remove this box (at the macro level, i.e.~in \TeX's `mouth' using
D.~Knuth's terminology, one may still succeed with the \.{\\lastbox}
approach unless the \.{\\hbox} was inserted in the main vertical mode)
and it may result in an unwanted blank line, slow down
the typesetting, etc. Most of these side-effects are easily treatable
but it would still be nice if a true `\.{asm} style' insertion of raw
\TeX\ were possible\footnote{It must be said that in the majority of
cases such side-effects are indeed desirable, and save the programmer some
typing but it seems that the \.{@@t} facility was not well thought
out in its entirety.}.

Continuing with the theme of inserting \TeX\ material into \CWEAVE\ output,
another one of \CWEB's inflexibilities is the lack of means of inserting
\TeX\ {\em between\/} sections. While inserting pure text may be arranged by
putting a codeless section after the one with the code (appropriate macros 
can be written to suppress the generation of a reference to such a section), 
inserting command sequences that affect, say, the typesetting style
of the consequent sections is not so easy. The trick with a `fake' section below
will be quite visible in the final output which is almost always undesirable.
Using the \.{@@t} mechanism is also far from ideal.

In general, the lack of structure in \CWEAVE's generated \TeX\ seems
to hinder even seemingly legitimate uses of \.{cwebmac.tex}
macros. Even such a natural desire as to use a different type size for
the \Cee\ portions of the \CWEB\ input is unexpectedly tricky to
implement. Modifying the \.{\\B} macro results in rather wasteful
multiple reading of the tokens in the \Cee\ portion, not to mention
the absense of any guarantee that \.{\\B} can find the end of its
argument (the macros used by \splint\ look for the \.{\\par} inserted
by \CWEAVE\ whenever \.{\\B} is output but an unsuspecting programmer
may disrupt this mechanism by inserting h\.{\{}is, her\.{\}} own
\.{\\par} using the \.{@@t} facility with the aim to put a picture in
the middle of the code, for example.

The authors of \CWEB\ understood the importance of the
cross-referencing facilities provided by their program. There are
several control sequences dedicated to indexing alone (which itself
has been the subject of criticism aimed at \CWEB). The indexing
mechanism addresses a number of important needs, although it does not
seem to be as flexible as required in some instances. For example, most
book indices are split into sections according to the first letter of
the indexed word to make it easier to find the desired term in the
index (or to establish that it is not indexed). Doing so in \CWEB\
requires some macro acrobatics, to say the least.

Also absent is a facility to explicitly inhibit the indexing of a
specific word (in \CWEAVE's own source, the references for |pp| fill
up several lines in the index) or limit it to definitions only (as
\CWEAVE\ automatically does for single letter identifiers). This too, can be
fixed by writing new indexing macros.

Finally, the index is created at the point of \CWEAVE\ invocation,
before any pagination information becomes available. It is therefore
difficult to implement any page oriented referencing scheme. Instead,
the index and all the other cross referencing facilities are tied to
section numbers. In the vast majority of cases, this is a superior
scheme: sections tend to be short and the index creation is
fast. Sometimes, however, it is useful to provide the page information
to the index macros. Unfortunately, after the index creation is
completed, any connection between the words in the original document
and those in the index is lost.

The indexing macros in \splint\ that deal with \bison\ and \flex\ code
have the advantage of being able to use the page numbers so a better
indexing scheme is possible. The section numbering approach taken by
\splint\ approximately follows that of \noweb: the section reference
consists of two parts, where the first is the page number the section
starts on, and the the second is the index of the section within the
page. Within the page, sections are indexed by (sequences of) letters
of the aphabet (\.a$\ldots$\.z and, in the rarest of cases,
\.{aa}$\ldots$\.{zz} and so on). Numbering the sections themselves is
not terribly complicated. Where it gets interesting, is during the production
of the index entries based on this system. When the sections are short, just
referencing the section where the term appears works well. Sometimes,
however, a section is split between two or more pages, in which case
the indexing macros provide a compromise: whenever the term appears on
a page different from the one on which the corresponding section
starts, the index entry for that term uses the page number instead of
the section reference. The difference between the two is easy to see,
since the page number does not have any alphabetic characters in it.

This is not {\em exactly\/} how the references work in \noweb, since
\noweb\ ignores the \TeX\ portion of the section and only references
the code {\em chunks\/} but it is similar in spirit. Other
conveniences, also borrowed from \noweb, are the references in the
margins that allow the reader to jump from one chink to the next
whenever the code chunk is composed of several sections. All of these
changes are implemented with macros only, so, for example, the finer
section number${}/{}$page number scheme is not available for the index
entries produced by \CWEAVE\ itself. In the case of \CWEB\ generated
entries only the section numbers are used (which in most cases do provide
the correct page number as part of the reference, however).

To conclude this Festivus@^Festivus@>\footnote{Yes, I am old enough to know what
this means.} style airing of grievances, let me state once again that
\CWEB\ is a remarkable tool, and incredibly useful as it is, although
it does test one's ability to write sophisticated \TeX\ if subtle
effects are desired. Finally, when all else fails, one is free to
modify \CWEB\ itself or even write one's own literate programming tool.

@*1 Why not GitHub$^{\hbox{\sevenpoint\copyright}}$, Bitbucket$^{\hbox{\sevenpoint\copyright}}$, etc.
Git is fantastic software that is used extensively in the development
of \splint. The distribution archive is a Git repository. The use of
centralized services such as GitHub$^{\hbox{\sixpoint\copyright}}$\footnote{A recent aquisition of
GitHub$^{\hbox{\sixpoint\copyright}}$
by a company that not so long ago used expletives to refer to the free software
movement only strengthens my suspicions, although everyone is welcome to draw
their own conclusions.}, however, seems redundant. The
standard cycle, `clone-modify-create pull request' works the same even
when `clone' is replaced by `download'. Thus, no functionality is
lost. This might change if the popularity of the package unexpectedly
increases. 

On the other hand, GitHub$^{\hbox{\sixpoint\copyright}}$ and its cousins are commercial entities,
whose availability in the future is not guaranteed (nothing is
certain, of course, no matter what distribution method is
chosen). Keeping \splint\ as an archive of a Git repository seems like
an efficient way of being ready for an unexpected change.
