#!/usr/bin/perl

# Copyright 2012-2022, Alexander Shibakov
# This file is part of SPLinT
#
# SPLinT is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# SPLinT is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SPLinT.  If not, see <http://www.gnu.org/licenses/>.

use Getopt::Long;
use Pod::Usage;

my $man = 0;
my $help = 0;
my $alpha_list = 0;
my $alpha_length = 1;

#Getopt::Long::Configure ("bundling"); # to allow -abc to set a, b, and c

GetOptions ("help|?" => \$help, 
            man => \$man,
            "alpha-list" => \$alpha_list,
            "alpha-length=i" => \$alpha_length
    ) or pod2usage(2);

pod2usage(-exitval => 0, -verbose => 1) if $help;
pod2usage(-exitval => 0, -verbose => 2) if $man;

if ( $alpha_list ) {
    open FILE_OUT, ">$ARGV[0]" or die "Cannot open input file $ARGV[0]\n";
    
    $alphabet = "abcdefghijklomnopqrstuvwxyz";
    
    @alpha_chars = split //, $alphabet;

    foreach $letter ( @alpha_chars ) {
        $letter_array[0] = $letter;
        for ( $i = 1; $i < $alpha_length; $i++ ) {
            $letter_array[$i] = '!';
        }
        $string = join '', @letter_array;
        print FILE_OUT "\@!\@:".$string."\@>\n";
    }   
}

__END__

=head1 MISCCW

misccw.pl - Miscellaneous functions

=head1 SYNOPSIS

misccw.pl [options] [input_file] [output_file]


 Options:
   --help|-h|-?      brief help message
   --man|-m          full documentation
   --alpha-list      generate a list of alphabetic markers

=head1 OPTIONS

=over 8

=item B<--help>

Print a brief help message and exit.

=item B<--man>

Print the manual page and exit.

=item B<--alpha-list>

Output a list of markers of the form @:?????@> in <output_file>

=back

=head1 DESCRIPTION

B<misccw.pl> will possibly read the given <input_file>, and likely output 
something in the <output_file> depending on the options given.

=cut
