{$define PasOnly}
unit charactr;

interface
uses common,strings;


Function Ext_chr_str(char_set,char_code:Byte;var cq:TconvertedPass1):Pchar;
Procedure Table_Init(var lat:LatTable);

implementation



{$ifndef PasOnly}

{$L charactr.obj}

Function Ext_chr_str(char_set,char_code:Byte;var cq:TconvertedPass1):Pchar; external;
Procedure Table_Init(var lat:LatTable); external;{}




{$else}
Procedure Table_Init(var lat:LatTable);
var i:byte;
Begin
   for i:=$20 to $7F do
   	begin
   	lat[i][0]:=chr(i);
	lat[i][1]:=#0;
        end;

   if TexChars then exit;

   strcpy(lat[$23],'\#'#0);                       {#}
   strcpy(lat[$24],'\$'#0);                       {dollar}
   strcpy(lat[$25],'\%'#0);                       {%}
   strcpy(lat[$26],'\&'#0);                       {&}
   strcpy(lat[$3C],'$<$'#0);                      {<}
   strcpy(lat[$3E],'$>$'#0);                      {>}
   strcpy(lat[$5C],'$\tt\backslash$'#0);          {\}
   strcpy(lat[$5E],'\^{}'#0);                     {^}
   strcpy(lat[$5F],'\_'#0);                       {_}
   strcpy(lat[$7B],'\{'#0);                       {{}
   strcpy(lat[$7C],'$|$'#0);                      {|}
   strcpy(lat[$7D],'\}'#0);                       { }
   strcpy(lat[$7E],'\~{}'#0);			   {~}
   strcpy(lat[$7F],' '#0);                        {Don't exist}
End;



{This funxtion expands an extended WP character into LaTEX sequence}
Function Ext_chr_str(char_set,char_code:Byte;var cq:TconvertedPass1):Pchar;
Begin
Ext_chr_str:=' -?- ';

{If you have a different char subset, please write your remapping into
char set 1 here}
if WPcharset>1 then	{Translate other WP character sets (Brrr)}
	begin
        if WPcharset=2 then
          case char_set of
            1:begin
              case char_code of
                  15:char_code:=196;	{\accent23U}
                  29:char_code:=105;	{\v{d}
                  33:char_code:=104;	{\v{D}
                  34:char_code:=26;	{\'{A}
                  35:char_code:=182;	{\v{T}
                  36:char_code:=206;	{\v{Z}
                  37:char_code:=207;	{\v{z}
                  38:char_code:=98;	{\v{C}
                  39:char_code:=99;	{\v{c}
                  43:char_code:=107;	{\v{e}
                  45:char_code:=106;	{\v{E}
                  51:char_code:=147;	{\v{l}
                  53:char_code:=48;	{\'{I}
                  56:char_code:=158;	{\v{N}
                  57:char_code:=159;	{\v{n}
                  65:char_code:=58;	{\'{O}
                  67:char_code:=171;	{\v{r}
                  69:char_code:=197;	{\accent23{u}
                  73:char_code:=66;	{\'{U}
                  end;
              end;
           end;
        end;
{--------------End of remapping section--------------}

case char_set of
     0:if char_code<128 then		{ Normal_char  }
	      Ext_chr_str := addr(lat[char_code][1]);
     1:begin
       case char_code of                {Multinational 1}
	      0:ext_chr_str:='`';
	      2:ext_chr_str:='\~{}';
	      3:ext_chr_str:='\^{}';
	      4:ext_chr_str:='--';
	      5:ext_chr_str:='/';
	      6:ext_chr_str:='''';
	     23:ext_chr_str:='\ss ';
	     26:begin
		ext_chr_str:='\''{A}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:='';
		end;
	     27:begin
		ext_chr_str:='\''{a}';
		if (CodePage=852)or(CodePage=895) then ext_chr_str:=''
		end;
	     28:ext_chr_str:='\^{A}';
	     29:ext_chr_str:='\^{a}';
	     30:ext_chr_str:='\"{A}';
	     31:ext_chr_str:='\"{a}';
	     32:if cq.envir='T' then ext_chr_str:='\accent18A'
				else ext_chr_str:='\`{A}';
	     33:if cq.envir='T' then ext_chr_str:='\accent18a'
				else ext_chr_str:='\`{a}';
	     34:ext_chr_str:='\AA ';
	     35:ext_chr_str:='\aa ';
	     36:ext_chr_str:='\AE ';
	     37:ext_chr_str:='\ae ';
	     38:ext_chr_str:='\c{C}';
	     39:ext_chr_str:='\c{c}';
	     40:begin
		ext_chr_str:='\''{E}';
		if (CodePage=852)or(CodePage=895) then ext_chr_str:=''
		end;
	     41:begin
		ext_chr_str:='\''{e}';
		if (CodePage=852)or(CodePage=895) then ext_chr_str:=''
		end;
	     42:ext_chr_str:='\^{E}';
	     43:ext_chr_str:='\^{e}';
	     44:ext_chr_str:='\"{E}';
	     45:ext_chr_str:='\"{e}';
	     46:if cq.envir='T' then ext_chr_str:='\accent18E'
				else ext_chr_str:='\`{E}';
	     47:if cq.envir='T' then ext_chr_str:='\accent18e'
				else ext_chr_str:='\`{e}';
	     48:begin
		ext_chr_str:='\''{I}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	     49:begin
		ext_chr_str:='\''{\i}';
		if (CodePage=852)or(CodePage=895) then ext_chr_str:=''
		end;
	     50:ext_chr_str:='\^{I}';
	     51:ext_chr_str:='\^{\i}';
	     52:ext_chr_str:='\"{I}';
	     53:ext_chr_str:='\"{\i}';
	     54:if cq.envir='T' then ext_chr_str:='\accent18I'
				else ext_chr_str:='\`{I}';
	     55:if cq.envir='T' then ext_chr_str:='\accent18i'
				else ext_chr_str:='\`{\i}';
	     56:ext_chr_str:='\~{N}';
	     57:ext_chr_str:='\~{n}';
	     58:begin
		ext_chr_str:='\''{O}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:='';
		end;
	     59:begin
		ext_chr_str:='\''{o}';
		if (CodePage=852)or(CodePage=895) then ext_chr_str:=''
		end;
	     60:ext_chr_str:='\^{O}';
	     61:ext_chr_str:='\^{o}';
	     62:ext_chr_str:='\"{O}';
	     63:ext_chr_str:='\"{o}';
	     64:if cq.envir='T' then ext_chr_str:='\accent18O'
				else ext_chr_str:='\`{O}';
	     65:if cq.envir='T' then ext_chr_str:='\accent18o'
				else ext_chr_str:='\`{o}';
	     66:begin
		ext_chr_str:='\''{U}';
		if CodePage=895 then ext_chr_str:='';
		end;
	     67:begin
		ext_chr_str:='\''{u}';
		if CodePage=895 then ext_chr_str:='';
		end;
	     68:ext_chr_str:='\^{U}';
	     69:ext_chr_str:='\^{u}';
	     70:ext_chr_str:='\"{U}';
	     71:ext_chr_str:='\"{u}';
	     72:if cq.envir='T' then ext_chr_str:='\accent18U'
				else ext_chr_str:='\`{U}';
	     73:if cq.envir='T' then ext_chr_str:='\accent18u'
				else ext_chr_str:='\`{u}';
	     74:ext_chr_str:='\"{Y}';
	     75:ext_chr_str:='\"{y}';
	     76:ext_chr_str:='\~{A}';
	     77:ext_chr_str:='\~{a}';
	     82:ext_chr_str:='\~{O}';
	     83:ext_chr_str:='\~{o}';
	     84:begin
		ext_chr_str:='\''{Y}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	     85:begin
		ext_chr_str:='\''{y}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:='';
		end;
	     90:ext_chr_str:='\u{A}';
	     91:ext_chr_str:='\u{a}';
	     92:ext_chr_str:='\={A}';
	     93:ext_chr_str:='\={a}';
	     94:ext_chr_str:='\c{A}';
	     95:ext_chr_str:='\c{a}';
	     96:ext_chr_str:='\''{C}';
	     97:ext_chr_str:='\''{c}';
	     98:begin
		ext_chr_str:='\v{C}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:='';
		end;
	     99:begin
		ext_chr_str:='\v{c}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:='';
		end;
	    100:ext_chr_str:='\^{C}';
	    101:ext_chr_str:='\^{c}';
	    102:ext_chr_str:='\.{C}';
	    103:ext_chr_str:='\.{c}';
	    104:begin
		ext_chr_str:='\v{D}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:='';
		end;
	    105:begin
		ext_chr_str:='\v{d}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:='';
		end;
	    106:begin
		ext_chr_str:='\v{E}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:='';
		end;
	    107:begin
		ext_chr_str:='\v{e}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	    108:ext_chr_str:='\.{E}';
	    109:ext_chr_str:='\.{e}';
	    110:ext_chr_str:='\={E}';
	    111:ext_chr_str:='\={e}';
	    112:ext_chr_str:='\c{E}';
	    113:ext_chr_str:='\c{e}';
	    114:ext_chr_str:='\''{G}';
	    115:ext_chr_str:='\''{g}';
	    116:ext_chr_str:='\u{G}';
	    117:ext_chr_str:='\u{g}';
	    118:ext_chr_str:='\v{G}';
	    119:ext_chr_str:='\v{g}';
	    120:ext_chr_str:='\c{G}';
	    121:ext_chr_str:='\c{g}';
	    122:ext_chr_str:='\^{G}';
	    123:ext_chr_str:='\^{g}';
	    124:ext_chr_str:='\.{G}';
	    125:ext_chr_str:='\.{g}';
	    126:ext_chr_str:='\^{H}';
	    127:ext_chr_str:='\^{h}';
	    130:ext_chr_str:='\.{I}';
	    131:ext_chr_str:='\.{i}';
	    132:ext_chr_str:='\={I}';
	    133:ext_chr_str:='\={\i}';
	    134:ext_chr_str:='\c{I}';
	    135:ext_chr_str:='\c{i}';
	    136:ext_chr_str:='\~{I}';
	    137:ext_chr_str:='\~{\i}';
	    138:ext_chr_str:='IJ';
	    139:ext_chr_str:='ij';
	    140:ext_chr_str:='\^{J}';
	    141:ext_chr_str:='\^{\j}';
	    142:ext_chr_str:='\c{K}';
	    143:ext_chr_str:='\c{k}';
	    144:ext_chr_str:='\''{L}';
	    145:ext_chr_str:='\''{l}';
	    146:begin
		ext_chr_str:='\v{L}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	    147:begin
		ext_chr_str:='\v{l}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	    148:ext_chr_str:='\c{L}';
	    149:ext_chr_str:='\c{l}';
	    152:ext_chr_str:='\L ';
	    153:ext_chr_str:='\l ';
	    154:ext_chr_str:='\''{N}';
	    155:ext_chr_str:='\''{n}';
	    158:begin
		ext_chr_str:='\v{N}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	    159:begin
		ext_chr_str:='\v{n}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	    160:ext_chr_str:='\c{N}';
	    161:ext_chr_str:='\c{n}';
	    162:ext_chr_str:='\H{O}';
	    163:ext_chr_str:='\H{o}';
	    164:ext_chr_str:='\={O}';
	    165:ext_chr_str:='\={o}';
	    166:ext_chr_str:='\OE ';
	    167:ext_chr_str:='\oe ';
	    168:ext_chr_str:='\''{R}';
	    169:ext_chr_str:='\''{r}';
	    170:begin
		ext_chr_str:='\v{R}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	    171:begin
		ext_chr_str:='\v{r}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	    172:ext_chr_str:='\c{R}';
	    173:ext_chr_str:='\c{r}';
	    174:ext_chr_str:='\''{S}';
	    175:ext_chr_str:='\''{s}';
	    176:begin
		ext_chr_str:='\v{S}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:='';
		end;
	    177:begin
		ext_chr_str:='\v{s}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	    178:ext_chr_str:='\c{S}';
	    179:ext_chr_str:='\c{s}';
	    180:ext_chr_str:='\^{S}';
	    181:ext_chr_str:='\^{s}';
	    182:begin
		ext_chr_str:='\v{T}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	    183:begin
		ext_chr_str:='\v{t}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	    184:ext_chr_str:='\c{T}';
	    185:ext_chr_str:='\c{t}';
	    188:ext_chr_str:='\u{U}';
	    189:ext_chr_str:='\u{u}';
	    190:ext_chr_str:='\H{U}';
	    191:ext_chr_str:='\H{u}';
	    192:ext_chr_str:='\={U}';
	    193:ext_chr_str:='\={u}';
	    194:ext_chr_str:='\c{U}';
	    195:ext_chr_str:='\c{u}';
	    196:begin
		ext_chr_str:='\accent23U';
		if CodePage=895 then ext_chr_str:=''
		end;
	    197:begin
		ext_chr_str:='\accent23u';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	    198:ext_chr_str:='\~{U}';
	    199:ext_chr_str:='\~{u}';
	    200:ext_chr_str:='\^{W}';
	    201:ext_chr_str:='\^{w}';
	    202:ext_chr_str:='\^{Y}';
	    203:ext_chr_str:='\^{y}';
	    204:ext_chr_str:='\''{Z}';
	    205:ext_chr_str:='\''{z}';
	    206:begin
		ext_chr_str:='\v{Z}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	    207:begin
		ext_chr_str:='\v{z}';
		if CodePage=852 then ext_chr_str:='';
		if CodePage=895 then ext_chr_str:=''
		end;
	    208:ext_chr_str:='\.{Z}';
	    209:ext_chr_str:='\.{z}';
	    212:ext_chr_str:='\={D}';
	    213:ext_chr_str:='\={d}';
	    214:ext_chr_str:='\={L}';
	    215:ext_chr_str:='\={l}';
	    216:ext_chr_str:='\={N}';
	    217:ext_chr_str:='\={n}';
	    218:if cq.envir='T' then ext_chr_str:='\accent18R'
				else ext_chr_str:='\`{R}';
	    219:if cq.envir='T' then ext_chr_str:='\accent18r'
				else ext_chr_str:='\`{r}';
	    220:ext_chr_str:='\={S}';
	    221:ext_chr_str:='\={s}';
	    222:ext_chr_str:='\={T}';
	    223:ext_chr_str:='\={t}';
	    224:ext_chr_str:='\u{Y}';
	    225:ext_chr_str:='\u{y}';
	    226:if cq.envir='T' then ext_chr_str:='\accent18Y'
				else ext_chr_str:='\`{Y}';
	    227:if cq.envir='T' then ext_chr_str:='\accent18y'
				else ext_chr_str:='\`{y}';
	   end;

	end;

     2:begin				{Multinational 2}
       case char_code of
	      0:ext_chr_str:='\d{~}';
	      7:ext_chr_str:='\b{~}';
	  end;
       end;

     3:begin				{Box Drawing}
       case char_code of
	      3:ext_chr_str:='\rule[-0.4ex]{1.9ex}{1.9ex}';
	      4:ext_chr_str:='\rule[-0.4ex]{0.95ex}{1.9ex}\kern 0.95ex ';
	      5:ext_chr_str:='\rule[0.55ex]{1.9ex}{0.95ex}';
	      6:ext_chr_str:='\kern 0.95ex \rule[-0.4ex]{0.95ex}{1.9ex}';
	      7:ext_chr_str:='\rule[-0.4ex]{1.9ex}{0.95ex}';
              8:ext_chr_str:='\rule[0.54ex]{1.9ex}{0.21ex}';
              9:ext_chr_str:='\kern 0.94ex \rule[-0.4ex]{0.21ex}{1.9ex} \kern 0.94ex ';
	  end;
       end;

     4:begin				{Typografic Symbols}
       case char_code of
	      0:ext_chr_str:='$\bullet$';
	      1:ext_chr_str:='$\circ$';
	      5:ext_chr_str:='\P ';
	      6:ext_chr_str:='\S  ';
	      7:ext_chr_str:='!`';
	      8:ext_chr_str:='?`';
	      9:ext_chr_str:='$\ll$';
	     10:ext_chr_str:='$\gg$';
	     11:ext_chr_str:='\pounds ';
	     12:ext_chr_str:='\ ';
	     13:ext_chr_str:='\ ';
	     14:ext_chr_str:='{\it f}\/';
	     15:ext_chr_str:='\astrike ';
	     16:ext_chr_str:='\ostrike ';
	     17:ext_chr_str:='$\frac{1}{2}$';
	     18:ext_chr_str:='$\frac{1}{4}$';
	     19:ext_chr_str:='\ ';
	     20:ext_chr_str:='$^{2}$';
	     21:ext_chr_str:='$^{n}$';
	     22:ext_chr_str:='\circchar{R}';
	     23:ext_chr_str:='\copyright ';
	     25:ext_chr_str:='$\frac{3}{4}$';
	     26:ext_chr_str:='$^{3}$';
	     39:ext_chr_str:='\dag ';
	     40:ext_chr_str:='\ddag ';
	     41:ext_chr_str:='\trademark ';
	     42:ext_chr_str:='\servicemark ';
	     48:ext_chr_str:='$\Box$';
	     51:ext_chr_str:='ff';
	     52:ext_chr_str:='ffi';
	     53:ext_chr_str:='ffl';
	     54:ext_chr_str:='fi';
	     55:ext_chr_str:='fl';
	     56:ext_chr_str:='$\ldots$';
	     64:ext_chr_str:='$\frac{1}{3}$';
	     65:ext_chr_str:='$\frac{2}{3}$';
	     66:ext_chr_str:='$\frac{1}{8}$';
	     67:ext_chr_str:='$\frac{3}{8}$';
	     68:ext_chr_str:='$\frac{5}{8}$';
	     69:ext_chr_str:='$\frac{7}{8}$';
	     70:ext_chr_str:='\circchar{M}';
	     71:ext_chr_str:='\circchar{P}';
	     72:ext_chr_str:='\circchar{U}';
	     78:ext_chr_str:='$^{1}$';
	  end;
	end;

     5:begin				{Iconic Symbols}
       case char_code of
	     0:ext_chr_str:='$\heartsuit$';
	     1:ext_chr_str:='$\diamondsuit$';
             2:ext_chr_str:='$\clubsuit$';
	     3:ext_chr_str:='$\spadesuit$';
	    11:ext_chr_str:='\rule{1.9ex}{0.4ex}';
	    13:ext_chr_str:='!\kern-0.5em!';
	    14:ext_chr_str:='$\surd$';
	    16:ext_chr_str:='~';
	    24:ext_chr_str:='$\Box$';
	    27:ext_chr_str:='$\sharp$';
	    28:ext_chr_str:='$\flat$';
	    29:ext_chr_str:='$\natural$';
	   end;
       end;

     6:begin				{Math/Scientific}
       case char_code of
            0:ext_chr_str:='-';
	    1:ext_chr_str:='$\pm$';
	    2:ext_chr_str:='$\leq$';
	    3:ext_chr_str:='$\geq$';
	    4:ext_chr_str:='$\propto$';
	    5:ext_chr_str:='/';
	    7:ext_chr_str:='$\setminus$';
	    8:ext_chr_str:='$\div$';
	    9:ext_chr_str:='$\mid$';
	   10:ext_chr_str:='$\langle$';
	   11:ext_chr_str:='$\rangle$';
           12:ext_chr_str:='$\sim$';
	   13:ext_chr_str:='$\approx$';
	   14:ext_chr_str:='$\equiv$';
           15:ext_chr_str:='$\in$';
	   16:ext_chr_str:='$\cap$';
	   17:ext_chr_str:='$\parallel$';
	   18:ext_chr_str:='$\sum$';
	   19:ext_chr_str:='$\infty$';
	   20:ext_chr_str:='$\neg$';
           21:ext_chr_str:='$\rightarrow$';
           22:ext_chr_str:='$\leftarrow$';
           23:ext_chr_str:='$\uparrow$';
           24:ext_chr_str:='$\downarrow$';
           25:ext_chr_str:='$\leftrightarrow$';
           26:ext_chr_str:='$\updownarrow$';
	   31:ext_chr_str:='$\cdot$';
	   33:ext_chr_str:='$\circ$';
	   34:ext_chr_str:='$\bullet$';
	   35:ext_chr_str:='\AA ';
	   36:ext_chr_str:='\degrees ';
	   37:ext_chr_str:='$\mu$';
	   38:ext_chr_str:='\={~}';
	   39:ext_chr_str:='$\times$';
	   40:ext_chr_str:='$\int$';
	   41:ext_chr_str:='$\prod$';
	   42:ext_chr_str:='$\mp$';
	   43:ext_chr_str:='$\nabla$';
           44:ext_chr_str:='$\partial$';
           45:ext_chr_str:='$\prime$';
           46:ext_chr_str:='$\prime\prime$';  {-----}
           47:ext_chr_str:='$\vec{}$';
           48:ext_chr_str:='{\\cal e}';
           49:ext_chr_str:='$\ell$';
           50:ext_chr_str:='$\hbar$';
	   51:ext_chr_str:='$\Im$';
	   52:ext_chr_str:='$\Re$';
           53:ext_chr_str:='$\wp$';
           54:ext_chr_str:='$\leftrightarrow$';
           55:ext_chr_str:='$\leftrightarrow$';
           56:ext_chr_str:='$\Rightarrow$';
           57:ext_chr_str:='$\Leftarrow$';
           58:ext_chr_str:='$\Uparrow$';
           59:ext_chr_str:='$\Downarrow$';
           60:ext_chr_str:='$\Leftrightarrow$';
           61:ext_chr_str:='$\Updownarrow$';
           62:ext_chr_str:='$\nearrow$';
           63:ext_chr_str:='$\searrow$';
	   64:ext_chr_str:='$\nwarrow$';
	   65:ext_chr_str:='$\swarrow$';
           66:ext_chr_str:='$\cup$';
           67:ext_chr_str:='$\subset$';
           68:ext_chr_str:='$\supset$';
	   69:ext_chr_str:='$\subseteq$';
	   70:ext_chr_str:='$\supseteq$';
           71:ext_chr_str:='$\ni$';
           72:ext_chr_str:='$\emptyset$';
           73:ext_chr_str:='$\lceil$';
           74:ext_chr_str:='$\rceil$';
           75:ext_chr_str:='$\lfloor$';
           76:ext_chr_str:='$\rfloor$';
	   77:ext_chr_str:='$\ll$';
	   78:ext_chr_str:='$\gg$';
           79:ext_chr_str:='$\angle$';
           80:ext_chr_str:='$\otimes$';
	   81:ext_chr_str:='$\oplus$';
	   82:ext_chr_str:='$\ominus$';
           83:ext_chr_str:='$\oslash$';
           84:ext_chr_str:='$\odot$';
           85:ext_chr_str:='$\wedge$';
           86:ext_chr_str:='$\vee$';
           88:ext_chr_str:='$\top$';
	   89:ext_chr_str:='$\bot$';
	   90:ext_chr_str:='\t{~}';
           91:ext_chr_str:='$\vdash$';
           92:ext_chr_str:='$\dashv$';
           93:ext_chr_str:='$\Box$';
           94:ext_chr_str:='$\Box$';
	   95:ext_chr_str:='$\Diamond$';
           96:ext_chr_str:='$\diamondsuit$';
           97:ext_chr_str:='$[$';
           98:ext_chr_str:='$]$';
	   99:ext_chr_str:='$\neq$';
	  100:ext_chr_str:='$\not\equiv$';
          101:ext_chr_str:='\because ';		{------}
          102:ext_chr_str:='\therefore ';	{------}

	  104:ext_chr_str:='$\oint$';

          108:ext_chr_str:='$\wp$';
          109:ext_chr_str:='$\circ$';
          111:ext_chr_str:='$\diamond$';
	  112:ext_chr_str:='$\star$';
          113:ext_chr_str:='${''''}$';	  { {$'''$}
	  114:ext_chr_str:='$\coprod$';
          115:ext_chr_str:='$\sieq$';
	  116:ext_chr_str:='$\cong$';
	  117:ext_chr_str:='$\prec$';
	  118:ext_chr_str:='$\preceq$';
	  119:ext_chr_str:='$\succ$';
	  120:ext_chr_str:='$\succeq$';
	  121:ext_chr_str:='$\exists$';
	  122:ext_chr_str:='$\forall$';
          123:ext_chr_str:='$\ll$';
          124:ext_chr_str:='$\gg$';
	  125:ext_chr_str:='$\uplus$';
	  128:ext_chr_str:='$\sqcap$';
	  129:ext_chr_str:='$\sqcup$';
	  130:ext_chr_str:='$\sqsubset$';
	  131:ext_chr_str:='$\sqsubseteq$';
	  133:ext_chr_str:='$\sqsupset$';
	  134:ext_chr_str:='$\sqsupseteq$';
	  136:ext_chr_str:='$\bigtriangleup$';
	  137:ext_chr_str:='$\bigtriangledown$';
	  138:ext_chr_str:='$\triangleleft$';
	  139:ext_chr_str:='$\triangleright$';
	  140:ext_chr_str:='$\bowtie$';
          141:ext_chr_str:='$\smile$';
          142:ext_chr_str:='$\frown$';
	  143:ext_chr_str:='$\bigcirc$';
          144:ext_chr_str:='$\leadsto$';
          145:ext_chr_str:='$\hookleftarrow$';
          146:ext_chr_str:='$\hookrightarrow$';
          147:ext_chr_str:='$\mapsto$';
	  148:ext_chr_str:='$\leftharpoonup$';
	  149:ext_chr_str:='$\leftharpoondown$';
	  150:ext_chr_str:='$\rightharpoonup$';
	  151:ext_chr_str:='$\rightharpoondown$';
          152:ext_chr_str:='$\rightleftharpoons$';
          153:ext_chr_str:='$\rightleftharpoons$';
          154:ext_chr_str:='$\uparrow$';
          155:ext_chr_str:='$\uparrow$';
          156:ext_chr_str:='$\downarrow$';
          157:ext_chr_str:='$\downarrow$';
          164:ext_chr_str:='\circchar{O}';
	  165:ext_chr_str:='\circchar{*}';
	  166:ext_chr_str:='\circchar{-}';
	  167:ext_chr_str:='$\mho$';
          168:ext_chr_str:='$\angle$';
          169:ext_chr_str:='$\angle$';
	  170:ext_chr_str:='$\lhd$';
	  171:ext_chr_str:='$\rhd$';
          172:ext_chr_str:='$\triangle$';
          173:ext_chr_str:='$\bigtriangledown$';
	  174:ext_chr_str:='$\dot{+}$';
          179:ext_chr_str:='$\asymp$';
	  180:ext_chr_str:='$\models$';
          183:ext_chr_str:='$\wr$';
          184:ext_chr_str:='$\star$';
	  185:ext_chr_str:='$\not<$';
	  186:ext_chr_str:='$\not\leq$';
	  187:ext_chr_str:='$\not>$';
	  188:ext_chr_str:='$\not\geq$';
	  189:ext_chr_str:='$\not\sim$';
	  190:ext_chr_str:='$\not\simeq$';
	  191:ext_chr_str:='$\not\cong$';
	  192:ext_chr_str:='$\not\approx$';
	  193:ext_chr_str:='$\not\prec$';
	  194:ext_chr_str:='$\not\preceq$';
	  195:ext_chr_str:='$\not\succ$';
	  196:ext_chr_str:='$\not\succeq$';
	  197:ext_chr_str:='$\not\subset$';
	  198:ext_chr_str:='$\not\supset$';
	  199:ext_chr_str:='$\not\subseteq$';
	  200:ext_chr_str:='$\not\supseteq$';
	  201:ext_chr_str:='$\not\sqsubset$';
	  202:ext_chr_str:='$\not\sqsupset$';
	  203:ext_chr_str:='$\not\sqsubseteq$';
	  204:ext_chr_str:='$\not\sqsupseteq$';
	  205:ext_chr_str:='$\not\parallel$';
	  206:ext_chr_str:='$\not\mid$';
	  207:ext_chr_str:='$\not\asymp$';
	  208:ext_chr_str:='$\not\exists$';
	  209:ext_chr_str:='$\not\in$';
          212:ext_chr_str:='{\rm F}';
          213:ext_chr_str:='{\rm C}';
          214:ext_chr_str:='{\rm I}';
	  215:ext_chr_str:='{\rm N}';
          216:ext_chr_str:='{\rm R}';
          219:ext_chr_str:='$\ni$';
	  220:ext_chr_str:='$\cdots$';
	  221:ext_chr_str:='$\ldots$';
	  222:ext_chr_str:='$\vdots$';
	  223:ext_chr_str:='$\ddots$';
	  226:ext_chr_str:='+';
	  227:ext_chr_str:='-';
	  228:ext_chr_str:='=';
	  229:ext_chr_str:='*';
	  230:ext_chr_str:='/';
	  231:ext_chr_str:='/\kern-.5ex/';
	  232:ext_chr_str:='/\kern-0.5ex/\kern-0.5ex/';
	  233:ext_chr_str:='$\cal H$';
	  234:ext_chr_str:='$\cal P$';
	 end;
       end;

     7:begin				{Math/Scientific Extension}
       case char_code of
	     0:ext_chr_str:='~';
	     1:ext_chr_str:='~';
             4:ext_chr_str:='$\surd$';
	     6:ext_chr_str:='$\sum$';
             7:ext_chr_str:='$\prod$';
             8:ext_chr_str:='$\coprod$';
             9:ext_chr_str:='$\int$';
	    10:ext_chr_str:='$\oint$';
	    11:ext_chr_str:='$\bigl|$';
	    12:ext_chr_str:='$\Bigl|$';
	    13:ext_chr_str:='$\biggl|$';
	    14:ext_chr_str:='$\Biggl|$';
	    16:ext_chr_str:='$\bigl\|$';
	    17:ext_chr_str:='$\Bigl\|$';
	    18:ext_chr_str:='$\biggl\|$';
	    19:ext_chr_str:='$\Biggl\|$';
	    21:ext_chr_str:='$\bigl\{$';
	    22:ext_chr_str:='$\Bigl\{$';
            23:ext_chr_str:='$\biggl\{$';
            24:ext_chr_str:='$\Biggl\{$';
            29:ext_chr_str:='$\bigr\}$';
	    30:ext_chr_str:='$\Bigr\}$';
            31:ext_chr_str:='$\biggr\}$';
	    32:ext_chr_str:='$\Biggr\}$';
	    37:ext_chr_str:='$\bigl\lfloor$';
	    38:ext_chr_str:='$\Bigl\lfloor$';
	    39:ext_chr_str:='$\biggl\lfloor$';
	    40:ext_chr_str:='$\Biggl\lfloor$';
	    41:ext_chr_str:='$\lfloor$';
	    43:ext_chr_str:='$\bigr\rfloor$';
	    44:ext_chr_str:='$\Bigr\rfloor$';
	    45:ext_chr_str:='$\biggr\rfloor$';
	    46:ext_chr_str:='$\Biggr\rfloor$';
	    47:ext_chr_str:='$\rfloor$';
	    49:ext_chr_str:='$\bigl\lceil$';
	    50:ext_chr_str:='$\Bigl\lceil$';
	    51:ext_chr_str:='$\biggl\lceil$';
	    52:ext_chr_str:='$\Biggl\lceil$';
	    53:ext_chr_str:='$\lceil$';
	    55:ext_chr_str:='$\bigr\rceil$';
	    56:ext_chr_str:='$\Bigr\rceil$';
	    57:ext_chr_str:='$\biggr\rceil$';
	    58:ext_chr_str:='$\Biggr\rceil$';
	    59:ext_chr_str:='$\rceil$';
	    85:ext_chr_str:='$\rightarrow$';
            86:ext_chr_str:='$\leftarrow$';
            91:ext_chr_str:='$\Rightarrow$';
            92:ext_chr_str:='$\Leftarrow$';
            94:ext_chr_str:='$\uparrow$';
            95:ext_chr_str:='$\downarrow$';
            97:ext_chr_str:='$\Uparrow$';
            98:ext_chr_str:='$\Downarrow$';
            99:ext_chr_str:='$\|$';
           100:ext_chr_str:='$\bigl($';
           101:ext_chr_str:='$\Bigl($';
           102:ext_chr_str:='$\biggl($';
           103:ext_chr_str:='$\Biggl($';
	   107:ext_chr_str:='$\bigr)$';
           108:ext_chr_str:='$\Bigr)$';
           109:ext_chr_str:='$\biggr)$';
	   110:ext_chr_str:='$\Biggr)$';
	   114:ext_chr_str:='$\bigl[$';
	   115:ext_chr_str:='$\Bigl[$';
	   116:ext_chr_str:='$\biggl[$';
	   117:ext_chr_str:='$\Biggl[$';
	   121:ext_chr_str:='$\bigr]$';
	   122:ext_chr_str:='$\Bigr]$';
	   123:ext_chr_str:='$\biggr]$';
	   124:ext_chr_str:='$\Biggr]$';
	   128:ext_chr_str:='$\bigl\langle$';
	   129:ext_chr_str:='$\Bigl\langle$';
	   130:ext_chr_str:='$\biggl\langle$';
	   131:ext_chr_str:='$\Biggl\langle$';
	   132:ext_chr_str:='$\bigr\rangle$';
	   133:ext_chr_str:='$\Bigr\rangle$';
	   134:ext_chr_str:='$\biggr\rangle$';
	   135:ext_chr_str:='$\Biggr\rangle$';
	   136:ext_chr_str:='$\bigl/$';
	   137:ext_chr_str:='$\Bigl/$';
	   138:ext_chr_str:='$\biggl/$';
	   139:ext_chr_str:='$\Biggl/$';
	   140:ext_chr_str:='$\bigr\backslash$';
	   141:ext_chr_str:='$\Bigr\backslash$';
	   142:ext_chr_str:='$\biggr\backslash$';
	   143:ext_chr_str:='$\Biggr\backslash$';
	   144:ext_chr_str:='$\bigcup$';
           145:ext_chr_str:='$\bigcap$';
           146:ext_chr_str:='$\uplus$';
           147:ext_chr_str:='$\biguplus$';
           148:ext_chr_str:='$\sqcup$';
           149:ext_chr_str:='$\bigsqcup$';
           150:ext_chr_str:='$\wedge$';
           151:ext_chr_str:='$\bigwedge$';
           152:ext_chr_str:='$\vee$';
           153:ext_chr_str:='$\bigvee$';
           154:ext_chr_str:='$\otimes$';
           155:ext_chr_str:='$\bigotimes$';
           156:ext_chr_str:='$\oplus$';
           157:ext_chr_str:='$\bigoplus$';
           158:ext_chr_str:='$\odot$';
           159:ext_chr_str:='$\bigodot$';
	   180:ext_chr_str:='$\ominus$';
           181:ext_chr_str:='\bigominus ';	{-----}
           198:ext_chr_str:='$\rightharpoonup$';
           199:ext_chr_str:='$\rightharpoondown$';
           200:ext_chr_str:='$\leftharpoonup$';
           201:ext_chr_str:='$\leftharpoondown$';
           221:ext_chr_str:='$\sqcap$';
           222:ext_chr_str:='\bigsqcap ';       {------}
	  end;
       end;

     8:begin				{Greek}
       case char_code of
             0:ext_chr_str:='A';
	     1:ext_chr_str:='$\alpha$';
             2:ext_chr_str:='B';
             3:ext_chr_str:='$\beta$';
             4:ext_chr_str:='B';
	     6:ext_chr_str:='$\Gamma$';
             7:ext_chr_str:='$\gamma$';
             8:ext_chr_str:='$\Delta$';
	     9:ext_chr_str:='$\delta$';
            10:ext_chr_str:='E';
	    11:ext_chr_str:='$\epsilon$';
            12:ext_chr_str:='Z';
            13:ext_chr_str:='$\zeta$';
            14:ext_chr_str:='H';
	    15:ext_chr_str:='$\eta$';
	    16:ext_chr_str:='$\Theta$';
            17:ext_chr_str:='$\theta$';
            19:ext_chr_str:='$\iota$';
            20:ext_chr_str:='K';
            21:ext_chr_str:='$\kappa$';
            22:ext_chr_str:='$\Lambda$';
            23:ext_chr_str:='$\lambda$';
            24:ext_chr_str:='M';
	    25:ext_chr_str:='$\mu$';
            26:ext_chr_str:='N';
            27:ext_chr_str:='$\nu$';
            28:ext_chr_str:='$\Xi$';
            29:ext_chr_str:='$\xi$';
            30:ext_chr_str:='O';
	    31:ext_chr_str:='o';
            32:ext_chr_str:='$\Pi$';
	    33:ext_chr_str:='$\pi$';
            34:ext_chr_str:='P';
            35:ext_chr_str:='$\rho$';
	    36:ext_chr_str:='$\Sigma$';
	    37:ext_chr_str:='$\sigma$';
            38:ext_chr_str:='$\Sigma$';
            39:ext_chr_str:='$\varsigma$';
            40:ext_chr_str:='T';
	    41:ext_chr_str:='$\tau$';
            42:ext_chr_str:='$\Upsilon$';
            43:ext_chr_str:='$\upsilon$';
	    44:ext_chr_str:='$\Phi$';
            45:ext_chr_str:='$\phi$';
            46:ext_chr_str:='X';
            47:ext_chr_str:='$\chi$';
            48:ext_chr_str:='$\Psi$';
            49:ext_chr_str:='$\psi$';
	    50:ext_chr_str:='$\Omega$';
	    51:ext_chr_str:='$\omega$';
	    52:ext_chr_str:='$\acute\alpha$';
	    53:ext_chr_str:='$\acute\epsilon$';
	    54:ext_chr_str:='$\acute\eta$';
	    55:ext_chr_str:='$\acute\iota$';
	    56:ext_chr_str:='$\ddot\iota$';
	    57:ext_chr_str:='$\acute{o}$';
	    58:ext_chr_str:='$\acute\upsilon$';
	    59:ext_chr_str:='$\ddot\upsilon$';
	    60:ext_chr_str:='$\acute\omega$';
	    61:ext_chr_str:='$\varepsilon$';
	    62:ext_chr_str:='$\vartheta$';
	    64:ext_chr_str:='$\varpi$';
	    65:ext_chr_str:='$\varrho$';
	    97:ext_chr_str:='$\grave\alpha$';
	    98:ext_chr_str:='$\hat\alpha$';
	   123:ext_chr_str:='$\grave\eta$';
	   124:ext_chr_str:='$\hat\eta$';
	   143:ext_chr_str:='$\grave\iota$';
	   144:ext_chr_str:='$\hat\iota$';
	   155:ext_chr_str:='$\grave{o}$';
	   162:ext_chr_str:='$\grave\upsilon$';
	   163:ext_chr_str:='$\hat\upsilon$';
	   174:ext_chr_str:='$\grave\omega$';
	   175:ext_chr_str:='$\hat\omega$';
	   end;
       end;

    10:begin				{Cyrilic}
       Cyrilic:=True;
       case char_code of
	     0:ext_chr_str:='A';
             1:ext_chr_str:='a';
             2:ext_chr_str:='B';
             3:ext_chr_str:='b';
             4:ext_chr_str:='V';
             5:ext_chr_str:='v';
             6:ext_chr_str:='G';
             7:ext_chr_str:='g';
             8:ext_chr_str:='D';
             9:ext_chr_str:='d';
            10:ext_chr_str:='E';
            11:ext_chr_str:='e';
            12:ext_chr_str:='{\em \"{\bukvy E}}';
            13:ext_chr_str:='{\em \"{\bukvy e}}';
            14:ext_chr_str:='Zh';
            15:ext_chr_str:='zh';
            16:ext_chr_str:='Z';
            17:ext_chr_str:='z';
            18:ext_chr_str:='I';
            19:ext_chr_str:='i';
            20:ext_chr_str:='{\em \v{\bukvy I}}';
            21:ext_chr_str:='{\em \v{\bukvy i}}';
            22:ext_chr_str:='K';
            23:ext_chr_str:='k';
	    24:ext_chr_str:='L';
            25:ext_chr_str:='l';
	    26:ext_chr_str:='M';
            27:ext_chr_str:='m';
	    28:ext_chr_str:='N';
            29:ext_chr_str:='n';
	    30:ext_chr_str:='O';
            31:ext_chr_str:='o';
	    32:ext_chr_str:='P';
            33:ext_chr_str:='p';
            34:ext_chr_str:='R';
            35:ext_chr_str:='r';
	    36:ext_chr_str:='S';
            37:ext_chr_str:='s';
            38:ext_chr_str:='T';
            39:ext_chr_str:='t';
            40:ext_chr_str:='U';
            41:ext_chr_str:='u';
	    42:ext_chr_str:='F';
            43:ext_chr_str:='f';
            44:ext_chr_str:='H';
            45:ext_chr_str:='h';
            46:ext_chr_str:='C';
            47:ext_chr_str:='c';
            48:ext_chr_str:='Ch';
            49:ext_chr_str:='ch';
            50:ext_chr_str:='Sh';
            51:ext_chr_str:='sh';
            52:ext_chr_str:='W';
            53:ext_chr_str:='w';

            55:ext_chr_str:='{\char127}';
            56:ext_chr_str:='Y';
            57:ext_chr_str:='y';

            59:ext_chr_str:='{\char126}';
            60:ext_chr_str:='{\char3}';
            61:ext_chr_str:='{\char11}';
            62:ext_chr_str:='Yu';
            63:ext_chr_str:='yu';
            64:ext_chr_str:='Ya';
            65:ext_chr_str:='ya';

            68:ext_chr_str:='{\char6}';

            76:ext_chr_str:='{\em I\bukvy}';
            77:ext_chr_str:='{\em i\bukvy}';
            78:ext_chr_str:='{\em \"{I}\bukvy}';
            79:ext_chr_str:='{\em \"{i}\bukvy}';
            80:ext_chr_str:='J';
            81:ext_chr_str:='j';
            82:ext_chr_str:='{\char1}';
            83:ext_chr_str:='{\char9}';
            84:ext_chr_str:='{\char0}';
            85:ext_chr_str:='{\char8}';

            86:ext_chr_str:='{\char7}';

            92:ext_chr_str:='{\char2}';
            93:ext_chr_str:='{\char10}';
            end;
       end;
    end;


End;
{$endif}


end.