/*
** AREXX $VER: Start_TeX.rexxV1.42 (24.7.92)
**
** This AREXX script compiles the files given in argument, using an
** optional format argument. All in all, it handles as if you had called
** virtex directly (except if you want to pass virtex some options). As
** the server is called, any virtex error messages will go to the server
** window, not the CLI. A '?' formatname will interactively ask for the
** format to use.
**
** AUTHOR: J\"org H\"ohle, March 91
**         Revised: 21 April 1991
**
** BUGS: virtex doesn't like filenames with blanks (and ARexx parses them
**       hardly too), so avoid them in file, directory *and* device names.
**
**       does not like names relative to the local root, like ":foo/bar"
**
** FILES: ENV:TEXFORMAT     default format used
**        REXX:NameStruc
*/

Options Results

Signal On BREAK_C
Signal On BREAK_D

PORTNAME = 'Start_TeX'
SCRIPT   = 'TeX-server.rexx' /* no path required, message only */

/*
** Ask interactively for the format name
*/
If "" = GetClip("TEXQUERY") Then
  ASKFORMAT = 0
Else
  ASKFORMAT = 1

Parse Arg Format FULLNAME
If "?" = FORMAT Then Do
  ASKFORMAT = 1
  FORMAT    = ""
End; Else If '&' = Left(FORMAT,1) Then
  FORMAT = SubStr(FORMAT,2)
Else Do
  Parse Arg FULLNAME /* no format given */
  FORMAT = ""
End

FULLNAME = Strip(FULLNAME)

Parse Value NameStruc(FULLNAME) With IVOL IDIRS IBASE .

/*
** Supply a default extension
*/
If "" = SubStr(FULLNAME,1+IVOL+IDIRS+IBASE) Then
  FULLNAME = FULLNAME||".tex"

If 0 = IVOL Then Do
  DIREC = Pragma('d')
  If Right(DIREC,1) ~= '/' & Right(DIREC,1) ~= ':' Then
    DIREC = DIREC||'/'
  FULLNAME = DIREC||FULLNAME
  Drop DIREC
End
Drop IVOL IDIRS IBASE

If ~Exists(FULLNAME) Then Do
  Say 'Fehler, 'FULLNAME' nicht gefunden!'
  Exit 10
End

If Show('Port',PORTNAME) Then Do
  ENVFORMAT = MyGetEnv("TEXFORMAT")
  If "" = FORMAT Then Do
    FORMAT = ENVFORMAT
    If ASKFORMAT | "" = ENVFORMAT Then Do
      If "" = FORMAT Then
        FORMAT = 'plain'

      Options Prompt 'Welches Format soll benutzt werden (bisher 'FORMAT')? '
      Parse Pull NFORMAT .
      Options Prompt

      If "" ~= NFORMAT Then
        FORMAT = NFORMAT
    End /* ASKFORMAT */
  End   /* !FORMAT */

/*
** If the server is already busy with some compilation, this will
** wait till compilation finishes, thus may take a long time.
*/
  Say 'Starte TeX-Server mit dem Format 'FORMAT' und der Datei 'FULLNAME'.'
  If FORMAT ~= ENVFORMAT THen
    Call MySetEnv("TEXFORMAT",FORMAT)

  Address Value PORTNAME
  'compile' FORMAT FULLNAME
  Say 'TeX-Server wurde mit Datei 'FULLNAME' aufgerufen.'
End; Else Do
/*
** The TeX server must be started first
*/
  Say 'Fehler, der TeX-Server 'SCRIPT' luft nicht!'
  Exit 5
End

BREAK_C:
BREAK_D:
Exit

/*
** When will ARexx supply GetEnv/SetEnv ?
*/
MyGetEnv: Procedure
Parse Arg NAME

If Open(TEMPFILE,"ENV:"||NAME,'r') Then Do
  GIVES = Readln(TEMPFILE)
  Call Close TEMPFILE
End; Else
  GIVES = ""

Return GIVES

MySetEnv: Procedure
Parse Arg NAME,CONTENT

Address COMMAND "SetEnv" NAME CONTENT

Return
