#
#   Given a dvips file with bitmap fonts, add the appropriate font
#   encodings, bounding box, and scale.
#
use strict ;
my @names ;
my $loc = 0 ;
my $hdpi = 0 ;
my $hscale = 0 ;
my $rewritebb = 1 ;
my $scalefont = 1 ;
my $deduplicate = 0 ;
while (@ARGV && $ARGV[0] =~ /^-/) {
   my $arg = shift @ARGV ;
   if ($arg eq '--nofontbb') {
      $rewritebb = 0 ;
   } elsif ($arg eq '--noscale') {
      $scalefont = 0 ;
   } elsif ($arg eq '--deduplicate') {
      $deduplicate = 1 ;
   } else {
      die "Bad arg; should be one of --nofontbb or --noscale." ;
   }
}
sub emit {
   my $s = shift ;
   if ($loc + 1 + length($s) > 75) {
      print "\n" ;
      $loc = 0 ;
   }
#  if ($loc) {
#     print " " ;
#     $loc++ ;
#  }
   print $s ;
   $loc += length($s) ;
}
my $encnum = 0 ;
my %cache ;
my $cacheable ;
sub emitnames {
   my $cacheable = shift ;
   if ($deduplicate && defined($cache{$cacheable})) {
      # we use load to get the value and defer execution.
      print "/$cache{$cacheable} load\n" ;
   } else {
      my $key = "EN" . $encnum++ ;
      $cache{$cacheable} = $key ;
      print $cacheable ;
      emit("A/$key X ") ;
   }
}
sub resetcache {
   $encnum = 0 ;
   %cache = () ;
}
my %allenc = () ;
sub loadall {
   my @keys = () ;
   my @enc = () ;
   while (<DATA>) {
      if (/^([^ ]*):$/) {
         my $key = $1 ;
         if (@enc) {
            my $enc = join '', @enc ;
            $allenc{$_} = $enc for @keys ;
            @enc = () ;
            @keys = () ;
         }
         push @keys, $key ;
      } else {
         push @enc, $_ ;
      }
   }
   if (@enc) {
      my $enc = join '', @enc ;
      $allenc{$_} = $enc for @keys ;
   }
}
my @k = () ;
my $keep = 0 ;
my $fn = undef ;
my $lastcc = 0 ;
my $slop = 1 ;
my $llx ;
my $lly ;
my $urx ;
my $ury ;
my $end ;
my $str ;
my $minx ;
my $maxx ;
my $miny ;
my $maxy ;
my $at ;
sub scansizes {
   $str = join '', @k ;
   $at = -1 ;
   $llx = 0 ;
   $lly = 0 ;
   $urx = 0 ;
   $ury = 0 ;
   $end = length($str) ;
   while (1) {
      $at = index($str, ">", $at+1) ;
      last if $at < 0 ;
      my $endhex = $at - 1 ;
      $at++ ;
      my @numargs = () ;
      my $c ;
      while (1) {
         $at++ while $at < $end && substr($str, $at, 1) le ' ' ;
         last if $at >= $end ;
         $c = substr($str, $at, 1) ;
         if ($c eq '-' || ('0' le $c && $c le '9')) {
            my $num = '' ;
            while ($c eq '-' || ('0' le $c && $c le '9')) {
               $num .= $c ;
               $at++ ;
               $c = substr($str, $at, 1) ;
            }
            push @numargs, 0 + $num ;
         } else {
            last ;
         }
      }
      next if $c eq '<' && @numargs == 0 ;
      die "Fail saw $c" if $c ne 'D' && $c ne 'I' ;
      die "Bad args" if $c eq 'D' && @numargs != 1 && @numargs != 6 ;
      die "Bad args" if $c eq 'I' && @numargs != 0 && @numargs != 5 ;
      if ($c eq 'D') {
         $lastcc = $numargs[-1] ;
      } else {
         $lastcc++ ;
      }
      if (@numargs < 4) {
         # find the previous 10 hex digits
         my $digs = '' ;
         while ($endhex > 0 && length($digs) < 10) {
            $c = substr($str, $endhex, 1) ;
            if (('0' le $c && $c le '9') || ('A' le $c && $c le 'Z')) {
               $digs = $c . $digs ;
            } else {
               die "Bad char in hex string" if $c gt ' ' && $c ne '<' && $c ne '>' ;
            }
            $endhex-- ;
         }
         die "Did not find ten digs" if length($digs) != 10 ;
         my $i ;
         for ($i=0; $i<5; $i++) {
            splice(@numargs, $i, 0, hex(substr($digs, 2*$i, 2))) ;
         }
      }
      $numargs[2] = 128 - $numargs[2] ;
      $numargs[3] = $numargs[3] - 127 ;
      $minx = $numargs[2] ;
      $maxx = $numargs[0] + $numargs[2] ;
      $miny = $numargs[3] - $numargs[1] ;
      $maxy = $numargs[3] ;
      $minx -= $slop ;
      $miny -= $slop ;
      $maxx += $slop ;
      $maxy += $slop ;
      $llx = $minx if $minx < $llx ;
      $lly = $miny if $miny < $lly ;
      $urx = $maxx if $maxx > $urx ;
      $ury = $maxy if $maxy > $ury ;
   }
}
loadall() ;
my $bufptr = 0 ;
my @buf ;
my $landscape = 0 ;
my $insetup = 0 ;
while (<>) {
   push @buf, $_ ;
   $insetup = 1 if /^%%BeginSetup/ ;
   last if /^%%EndSetup/ ;
   $landscape = 1 if /\@landscape/ && $insetup ;
}
my $addview = 1 ;
my $fontsize ;
my $hsi ;
my $fid ;
my $viewori ;
while (1) {
   if ($bufptr < @buf) {
      $_ = $buf[$bufptr++] ;
   } else {
      $_ = <> ;
      last if !$_ ;
   }
   if (/TeXDict begin \d+ \d+ \d+ (\d+) /) {
      $hdpi = $1 ;
   }
   if (/^%DVIPSBeginSection/) {
      resetcache() ;
   }
   if (/^%EndDVIPSBitmapFont/) {
      $hscale = $hdpi * $fontsize / 72 ;
      $hsi = 1 / $hscale ;
      $hsi = 1 if !$scalefont ;
      my @cacheable = () ;
      if (open E, "dvips-$fn.enc") {
         print STDERR "Reading dvips-$fn.enc\n" ;
         my $safeunderbar = $_ ;
         while (<E>) {
            push @cacheable, $_ ;
         }
         close E ;
         $_ = $safeunderbar ;
         $cacheable = join '', @cacheable ;
         emitnames($cacheable) ;
      } elsif (defined($allenc{$fn})) {
         emitnames($allenc{$fn}) ;
      } else {
         warn "Cannot find encoding for $fn.enc" ;
         print "IEn\n" ;
      }
      scansizes() ;
      print "IEn S/IEn X FBB FMat/FMat[$hsi 0 0 -$hsi 0 0]N\n" ;
      print "/FBB[$llx $lly $urx $ury]N\n" if $rewritebb ;
      print for @k ;
      print "/$fid load 0 $fid currentfont $hscale scalefont put\n" if $scalefont ;
      print "/FMat X/FBB X/IEn X\n" ;
      $keep = 0 ;
   }
   if ($keep) {
      push @k, $_ ;
   } else {
      print ;
   }
   if (/^%%EndComments/ && $addview) {
      if ($landscape) {
         $viewori = "0 -1 1 0" ;
      } else {
         $viewori = "1 0 0 1" ;
      }
      print <<EOF ;
%%BeginDefaults
%%ViewingOrientation: $viewori
%%EndDefaults
EOF
      $addview = 0 ;
   }
   if (/^%DVIPSBitmapFont/) {
      @k = () ;
      $keep = 1 ;
      chomp ;
      my @f = split " ", $_ ;
      $fid = $f[1] ;
      $fn = $f[2] ;
      $fontsize = $f[3] ;
   }
}
__DATA__
mathu10:
[128{/.notdef}repeat/Abreve/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek
/Gbreve/Lacute/Lcaron/Lslash/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron
/Sacute/Scaron/Scedilla/Tcaron/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute
/Zcaron/Zdotaccent/IJ/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron
12{/.notdef}repeat/rcaron/sacute/scaron/scedilla/tcaron/tcedilla
/uhungarumlaut/uring/ydieresis/zacute/zcaron/zdotaccent/ij/exclamdown
/questiondown/sterling/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE
/Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex
/Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis/OE/Oslash
/Ugrave 6{/.notdef}repeat/agrave/aacute/acircumflex/atilde/adieresis/aring
/ae/ccedilla/egrave/eacute/ecircumflex/edieresis/igrave/iacute/icircumflex
/idieresis/eth/ntilde/ograve/oacute/ocircumflex/otilde/odieresis/oe/oslash
/ugrave 6{/.notdef}repeat]
gvibc10:
[70{/.notdef}repeat/F 8{/.notdef}repeat/O/P 3{/.notdef}repeat/T 3{/.notdef}
repeat/X 8{/.notdef}repeat/a/b/.notdef/d/e/f/g/h/i/.notdef/k/l/m/n/o/p/q/r/s
/t 3{/.notdef}repeat/x/y/z 133{/.notdef}repeat]
mathux10:
[67{/.notdef}repeat/C/.notdef/E/F/.notdef/H/I/.notdef/.notdef/L/M/N/O/P/Q/R
/S/T/U 42{/.notdef}repeat/Abreve/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek
/Gbreve/Lacute/Lcaron/Lslash/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron
/Sacute/Scaron/Scedilla/Tcaron/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute
6{/.notdef}repeat/abreve/aogonek/cacute/ccaron/dcaron/ecaron/eogonek/gbreve
/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut/racute/rcaron/sacute
/scaron/scedilla/tcaron/tcedilla/uhungarumlaut/uring/ydieresis/zacute 6{
/.notdef}repeat/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla
/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex/Idieresis/Eth
/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis/OE/Oslash/Ugrave 6{
/.notdef}repeat/agrave/aacute/acircumflex/atilde/adieresis/aring/ae/ccedilla
/egrave/eacute/ecircumflex/edieresis/igrave/iacute/icircumflex/idieresis/eth
/ntilde/ograve/oacute/ocircumflex/otilde/odieresis/oe/oslash/ugrave 6{
/.notdef}repeat]
givbc10:
[66{/.notdef}repeat/B 3{/.notdef}repeat/F 6{/.notdef}repeat/M/N/O/P/Q/R
/.notdef/T 3{/.notdef}repeat/X/Y 7{/.notdef}repeat/a/b/.notdef/d/e/f/g/h/i
/.notdef/k/l/m/n/o/p/.notdef/r/s/t 3{/.notdef}repeat/x/y/z 133{/.notdef}
repeat]
dingbat:
[66{/.notdef}repeat/Square-with-dots-border-design
/Square-with-dots-border-design/Check-mark/Left-flouron/Right-flouron
/Flipped-left-flouron--matches-F/Flipped-right-flouron--matches-E
/DLA-satelite-dish/Flowery-flouron/Right-flower
/Flipped-left-flower--matches-J/Flipped-right-flower--matches-K
/Hand-pointer-to-the-left/Anchor-for-TUG-dingbat-contest 3{/.notdef}repeat
/S-border-design 6{/.notdef}repeat/Z-border-design 6{/.notdef}repeat
/Overlapping-thick\thin-line-border-design---character-1
/Overlapping-thick\thin-line-border-design---character-2
/Overlapping-thick\thin-line-border-design---character-3
/Overlapping-thick\thin-line-border-design---character-4
/Overlapping-thick\thin-line-border-design---character-5
/Overlapping-thick\thin-line-border-design---character-6
/Overlapping-thick\thin-line-border-design---character-7
/Overlapping-thick\thin-line-border-design---character-8 151{/.notdef}repeat
]
logo10:
logo8:
logo9:
logobf10:
logod10:
logosl10:
logosl8:
logosl9:
[65{/.notdef}repeat/A 3{/.notdef}repeat/E/F 6{/.notdef}repeat/M/N/O/P
/.notdef/.notdef/S/T 171{/.notdef}repeat]
MnSymbolS-Bold10:
MnSymbolS-Bold12:
MnSymbolS-Bold5:
MnSymbolS-Bold6:
MnSymbolS-Bold7:
MnSymbolS-Bold8:
MnSymbolS-Bold9:
MnSymbolS10:
MnSymbolS12:
MnSymbolS5:
MnSymbolS6:
MnSymbolS7:
MnSymbolS8:
MnSymbolS9:
[65{/.notdef}repeat/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z 165{
/.notdef}repeat]
rsfs10:
rsfs5:
rsfs7:
[65{/.notdef}repeat/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z 36{
/.notdef}repeat/tie 128{/.notdef}repeat]
cmcinch:
[62{/.notdef}repeat/fill1062 33{/.notdef}repeat/afii10048/afii10017
/afii10018/afii10040/afii10021/afii10022/afii10038/afii10020/afii10039
/afii10026/afii10027/afii10028/afii10029/afii10030/afii10031/afii10032
/afii10033/afii10049/afii10034/afii10035/afii10036/afii10037/afii10024
/afii10019/afii10046/afii10045/afii10025/afii10042/afii10047/afii10043
/afii10041/afii10044 128{/.notdef}repeat]
dsrom10:
dsrom12:
dsrom8:
dsss10:
dsss12:
dsss8:
[49{/.notdef}repeat/one 15{/.notdef}repeat/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q
/R/S/T/U/V/W/X/Y/Z 6{/.notdef}repeat/a 6{/.notdef}repeat/h/.notdef/.notdef/k
148{/.notdef}repeat]
copsn10:
[49{/.notdef}repeat/one/two/three/four/five 4{/.notdef}repeat/colon 7{
/.notdef}repeat/B/C/D/E/F/G/.notdef/.notdef/J/K/L/M/N/.notdef/P/Q/R/S/T
/.notdef/V/.notdef/X 8{/.notdef}repeat/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s
/t/u/v/w/x/y/z 133{/.notdef}repeat]
cminch:
[48{/.notdef}repeat/zero/one/two/three/four/five/six/seven/eight/nine 7{
/.notdef}repeat/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z 165{
/.notdef}repeat]
csinch:
[48{/.notdef}repeat/zero/one/two/three/four/five/six/seven/eight/nine 7{
/.notdef}repeat/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z 78{
/.notdef}repeat/Scaron/.notdef/Tcaron/.notdef/.notdef/Zcaron 17{/.notdef}
repeat/Racute/Aacute 3{/.notdef}repeat/Lacute/.notdef/.notdef/Ccaron/Eacute
/.notdef/.notdef/Ecaron/Iacute/.notdef/Dcaron/.notdef/.notdef/Ncaron/Oacute 4
{/.notdef}repeat/Rcaron/.notdef/Uacute/.notdef/.notdef/Yacute 34{/.notdef}
repeat]
plinch:
[48{/.notdef}repeat/zero/one/two/three/four/five/six/seven/eight/nine 7{
/.notdef}repeat/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z 38{
/.notdef}repeat/Aogonek/Cacute 3{/.notdef}repeat/Eogonek 3{/.notdef}repeat
/Lslash/Nacute 5{/.notdef}repeat/Sacute 7{/.notdef}repeat/Zacute/.notdef
/Zdotaccent 55{/.notdef}repeat/Oacute 44{/.notdef}repeat]
beuron:
beuronc:
beuronx:
[43{/.notdef}repeat/plus/.notdef/hyphen/.notdef/slash 10{/.notdef}repeat
/colon 6{/.notdef}repeat/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z
6{/.notdef}repeat/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z 18{
/.notdef}repeat/Omega 114{/.notdef}repeat]
sarab10:
[39{/.notdef}repeat/quoteright 26{/.notdef}repeat/B/.notdef/D/.notdef
/.notdef/G/H/I/J 8{/.notdef}repeat/S/T 3{/.notdef}repeat/X/.notdef/Z 5{
/.notdef}repeat/quoteleft/a/b/.notdef/d/.notdef/f/g/h/.notdef/.notdef/k/l/m
/n/o/.notdef/q/r/s/t/.notdef/.notdef/w/x/y/z 133{/.notdef}repeat]
bcghsb:
bcghsm:
bcghwb:
bcghwm:
bcgvsb:
bcgvsm:
bcgvwb:
bcgvwm:
[33{/.notdef}repeat/exclam/quotedbl/numbersign/dollar/percent/ampersand
/quoteright/parenleft/parenright/asterisk/.notdef/comma/hyphen/period/slash
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon/less
/equal/greater/question/at/.notdef/.notdef/C/.notdef/E/.notdef/G 3{/.notdef}
repeat/K/L/M/N 3{/.notdef}repeat/R/S 4{/.notdef}repeat/X/.notdef/Z 5{
/.notdef}repeat/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/.notdef/p/q/r/s/t/u/v
/.notdef/x/y/z/.notdef/bar 3{/.notdef}repeat/Abreve/Aogonek/Cacute/Ccaron
/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash/Nacute/Ncaron/Eng
/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron/Tcedilla
/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdotaccent 3{/.notdef}repeat
/section/abreve/aogonek 9{/.notdef}repeat/nacute 15{/.notdef}repeat
/zdotaccent 12{/.notdef}repeat/Egrave/.notdef/Ecircumflex/.notdef/Igrave
/.notdef/Icircumflex/Idieresis/Eth/.notdef/Ograve/.notdef/Ocircumflex
/.notdef/Odieresis/OE/Oslash/.notdef/Uacute/.notdef/Udieresis/.notdef/Thorn
/SS/agrave/.notdef/acircumflex/.notdef/adieresis/.notdef/ae/ccedilla/egrave
/.notdef/ecircumflex/.notdef/igrave/.notdef/icircumflex/idieresis/eth
/.notdef/ograve/.notdef/ocircumflex/.notdef/odieresis/oe 7{/.notdef}repeat
/germandbls]
smfer10:
smfesl10:
smfett10:
smfpr10:
smfpsl10:
smfptt10:
smfr10:
smfsl10:
smftt10:
[32{/.notdef}repeat/space/.notdef/.notdef/numbersign/dollar 5{/.notdef}
repeat/asterisk 3{/.notdef}repeat/period/.notdef/0/1/2/3/4/5/6/7/8/9 7{
/.notdef}repeat/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z 6{
/.notdef}repeat/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z 3{
/.notdef}repeat/tilda/.notdef/Abreve/Aogonek/Cacute/Ccaron/Dcaron/Ecaron
/Eogonek/Gbreve/Lacute/Lcaron/Lslash/Nacute/Ncaron/.notdef/Ohungarumlaut
/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron/Tcedilla/Uhungarumlaut/Uring
/Ydieresis/Zacute/Zcaron/Zdotaccent/.notdef/Idotaccent/dcroat/.notdef/abreve
/aogonek/cacute/ccaron/dcaron/ecaron/eogonek/gbreve/lacute/lcaron/lslash
/nacute/ncaron/.notdef/ohungarumlaut/racute/rcaron/sacute/scaron/scedilla
/tcaron/tcedilla/uhungarumlaut/uring/ydieresis/zacute/zcaron/zdotaccent 4{
/.notdef}repeat/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/.notdef
/Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex
/Idieresis/.notdef/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis/.notdef
/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute/.notdef/.notdef/agrave
/aacute/acircumflex/atilde/adieresis/aring/.notdef/ccedilla/egrave/eacute
/ecircumflex/edieresis/igrave/iacute/icircumflex/idieresis/.notdef/ntilde
/ograve/oacute/ocircumflex/otilde/odieresis/.notdef/oslash/ugrave/uacute
/ucircumflex/udieresis/yacute/.notdef/.notdef]
fibb84:
[32{/.notdef}repeat/space/exclam/dieresis/dieresisacute/dieresisgrave
/percent/endash/quotesnglright/parenleft/parenright/asterisk/plus/comma
/hyphen/period/slash/zero/one/two/three/four/five/six/seven/eight/nine/colon
/colongreek/angleleft/equal/angleright/questiongreek/asperperispomene/Alpha
/Beta/Ksi/Delta/Epsilon/Phi/Gamma/Eta/Iota/cigmalunate/Kappa/Lambda/Mu/Nu
/Omicron/Pi/Theta/Rho/Sigma/Tau/Upsilon/Digamma/Omega/Chi/Psi/Zeta
/bracketleft/lenisperispomene/bracketright/lenisacute/lenisgrave
/quotesnglleft/alpha/beta/ksi/delta/epsilon/phi/gamma/eta/iota/sigmafinal
/kappa/lambda/mu/nu/omicron/pi/theta/rho/sigma/tau/upsilon/digamma/omega/chi
/psi/zeta/guillemetsleft/iotasubscript/guillemetsright/perispomene/emdash
/alphagrave/alphaasper/alphaenis/aspergrave/epsilonasperperispomene
/omicronperispomene/Koppa/asperacute/alphaacute/alphaasperacute
/alphalenisacute/alphaaspergrave/epsilonperispomene/omicronasperperispomene
/koppa/sampi/slphaperispomene/alphaasperperispomene/alphalenisperispomene
/alphalenisgrave/epsilonlenisperispomene/omicronlenisperispomene/Cigmalunate
/.notdef/etagrave/etaasper/etalenis/etaaspergrave/dotI/dotJdlmnpqu/dotbt
/dotchjz/etaacute/etaasperacute/etalenisacute/etalenisgrave/doti/dotGZ
/dotkos/dotCEVaw/etaperispomene/etaasperperispomene/etalenisperispomene
/quotedblleft/dote/dotH/dotBFLNPQSTW/quotedblright/omegagrave/omegaasper
/omegalenis/omegaaspergrave/dotDK/dotfy/dotgx/dotkoppa/omegaacute
/omegaasperacute/omegalenisacute/omegalenisgrave/dotAOQUXY/grave/acute/dotr
/omegaperispomene/omegaasperperispomene/omegalenisperispomene/asper/dotM
/breve/macron/lenis/iotagrave/iotaasper/iotalenis/iotaaspergrave
/upsilongrave/upsilonasper/upsilonlenis/upsilonaspergrave/iotaacute
/iotaasperacute/iotalenisacute/iotalenisgrave/upsilonacute/upsilonasperacute
/upsilonlenisacute/upsilonlenisgrave/iotaperispomene/iotaasperperispomene
/iotalenisperispomene/braceleft/upsilonperispomene/upsilonasperperispomene
/upsilonlenisperispomene/braceright/epsilongrave/epsilonasper/epsilonlenis
/epsilonlenisgrave/omicrongrave/omicronasper/omicronlenis/omicronaspergrave
/epsilonacute/epsilonasperacute/epsilonlenisacute/epsilonaspergrave
/omicronacute/omicronasperacute/omicronlenisacute/omicronlenisgrave
/iotadieresis/iotadieresisacute/iotadieresisgrave/bracketleftbt
/upsilondieresis/upsilondieresisacute/upsilondieresisgrave/bracketrightbt
/iotasubalpha/iotasubeta/iotasubomega/rhoaspe/rholenis/dagger/daggerdbl
/aspirate]
fibo84:
fibr84:
[32{/.notdef}repeat/space/exclam/dieresis/dieresisacute/dieresisgrave
/percent/endash/quotesnglright/parenleft/parenright/asterisk/plus/comma
/hyphen/period/slash/zero/one/two/three/four/five/six/seven/eight/nine/colon
/colongreek/angleleft/equal/angleright/questiongreek/asperperispomene/Alpha
/Beta/Ksi/Delta/Epsilon/Phi/Gamma/Eta/Iota/cigmalunate/Kappa/Lambda/Mu/Nu
/Omicron/Pi/Theta/Rho/Sigma/Tau/Upsilon/Digamma/Omega/Chi/Psi/Zeta
/bracketleft/lenisperispomene/bracketright/lenisacute/lenisgrave
/quotesnglleft/alpha/beta/ksi/delta/epsilon/phi/gamma/eta/iota/sigmafinal
/kappa/lambda/mu/nu/omicron/pi/theta/rho/sigma/tau/upsilon/digamma/omega/chi
/psi/zeta/guillemetsleft/iotasubscript/guillemetsright/perispomene/emdash
/alphagrave/alphaasper/alphalenis/aspergrave/epsilonasperperispomene
/omicronperispomene/Koppa/asperacute/alphaacute/alphaasperacute
/alphalenisacute/alphaaspergrave/epsilonperispomene/omicronasperperispomene
/koppa/sampi/alphaperispomene/alphaasperperispomene/alphalenisperispomene
/alphalenisgrave/epsilonlenisperispomene/omicronlenisperispomene/Cigmalunate
/.notdef/etagrave/etaasper/etalenis/etaaspergrave/dotI/dotJdlmnpqu/dotbt
/dotchjz/etaacute/etaasperacute/etalenisacute/etalenisgrave/doti/dotGZ
/dotkos/dotCEVaw/etaperispomene/etaasperperispomene/etalenisperispomene
/quotedblleft/dote/dotH/dotBFLNPRSTW/quotedblright/omegagrave/omegaasper
/omegalenis/omegaaspergrave/dotDK/dotfy/dotgx/dotkoppa/omegaacute
/omegaasperacute/omegalenisacute/omegalenisgrave/dotAOQUXY/grave/acute/dotr
/omegaperispomene/omegaasperperispomene/omegalenisperispomene/asper/dotM
/breve/macron/lenis/iotagrave/iotaasper/iotalenis/iotaaspergrave
/upsilongrave/upsilonasper/upsilonlenis/upsilonaspergrave/iotaacute
/iotaasperacute/iotalenisacute/iotalenisgrave/upsilonacute/upsilonasperacute
/upsilonlenisacute/upsilonlenisgrave/iotaperispomene/iotaasperperispomene
/iotalenisperispomene/braceleft/upsilonperispomene/upsilonasperperispomene
/upsilonlenisperispomene/braceright/epsilongrave/epsilonasper/epsilonlenis
/epsilonlenisgrave/omicrongrave/omicronasper/omicronlenis/omicronaspergrave
/epsilonacute/epsilonasperacute/epsilonlenisacute/epsilonaspergrave
/omicronacute/omicronasperacute/omicronlenisacute/omicronlenisgrave
/iotadieresis/iotadieresisgrave/iotadieresisacute/bracketleftbt
/upsilondieresis/upsilondieresisgrave/upsilondieresisacute/bracketrightbt
/iotasubalpha/iotasubeta/iotasubomega/rhoasper/rholenis/dagger/daggerdbl
/aspirate]
bthhsb:
bthhsm:
bthhwb:
bthhwm:
bthvsb:
bthvsm:
bthvwb:
bthvwm:
[32{/.notdef}repeat/space/exclam/quotedbl/numbersign/dollar/.notdef/.notdef
/quoteright/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon/less
/equal/greater/question/at 3{/.notdef}repeat/D/E/F/G/H/.notdef/.notdef/K/L/M
/N/.notdef/P/.notdef/.notdef/S/T 5{/.notdef}repeat/Z 5{/.notdef}repeat
/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/.notdef/r/s/t/u/v/w/.notdef/y/z
/.notdef/bar 3{/.notdef}repeat/Abreve/Aogonek/Cacute/Ccaron/Dcaron/Ecaron
/Eogonek/Gbreve/Lacute/Lcaron/Lslash/Nacute/Ncaron/Eng/Ohungarumlaut/Racute
/Rcaron/Sacute/Scaron/Scedilla/Tcaron/Tcedilla/Uhungarumlaut/Uring/Ydieresis
/Zacute/Zcaron/Zdotaccent/IJ/Idotaccent/dcroat/section/abreve/aogonek/cacute
/ccaron/dcaron/ecaron/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng
/ohungarumlaut/racute/rcaron/sacute/scaron/scedilla/tcaron/tcedilla
/uhungarumlaut/uring/ydieresis/zacute/zcaron/zdotaccent/ij/exclamdown
/questiondown/sterling 8{/.notdef}repeat/Egrave/Eacute/Ecircumflex/Edieresis
/Igrave/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex 3{
/.notdef}repeat/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis 3{/.notdef}repeat
/agrave/aacute/acircumflex/atilde/adieresis 3{/.notdef}repeat/egrave/eacute
/ecircumflex/edieresis/igrave 3{/.notdef}repeat/eth/ntilde/ograve/oacute
/ocircumflex 10{/.notdef}repeat/germandbls]
karta15:
[32{/.notdef}repeat/space/exclam/quotedbl/numbersign/dollar/percent
/ampersand/quotesingle/parenleft/parenright/asterisk/plus/comma/hyphen
/period/slash/zero/one/two/three/four/five/six/seven/eight/nine/colon
/semicolon/less/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q
/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash/bracketright/asciicircum/underscore
/grave/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar
/braceright/asciitilde 34{/.notdef}repeat/degree/cent/sterling/section
/bullet/paragraph/germandbls/registered/copyright/trademark/acute/dieresis
/notequal/AE/Oslash/infinity/plusminus/lessequal/greaterequal/yen/mu
/partialdiff/summation/product/pi/integral/ordfeminine/ordmasculine/Omega/ae
/oslash/questiondown/exclamdown/logicalnot/radical/florin/approxequal/Delta
/guillemotleft/guillemotright/ellipsis/nbspace/Agrave/Atilde/Otilde/OE/oe
/endash/emdash/quotedblleft/quotedblright/quoteleft/quoteright/divide
/lozenge/ydieresis/Ydieresis/fraction/currency/guilsinglleft/guilsinglright
/fi/fl/daggerdbl/periodcentered/quotesinglbase/quotedblbase/perthousand
/Acircumflex/Ecircumflex/Aacute/Edieresis/Egrave/Iacute/Icircumflex
/Idieresis/Igrave/Oacute/Ocircumflex/apple/Ograve/Uacute/Ucircumflex/Ugrave
/dotlessi/circumflex/tilde/macron/breve/dotaccent/ring/cedilla/hungarumlaut
/ogonek/.notdef]
cmccsc10:
cmccsc8:
cmccsc9:
[30{/.notdef}repeat/guillemotright 31{/.notdef}repeat/afii10023/.notdef
/afii10096/afii10065/afii10066/afii10088/afii10069/afii10070/afii10086
/afii10068/afii10087/afii10074/afii10075/afii10076/afii10077/afii10078
/afii10079/afii10080/afii10081/afii10097/afii10082/afii10083/afii10084
/afii10085/afii10072/afii10067/afii10094/afii10093/afii10073/afii10090
/afii10095/afii10091/afii10089/afii10092/afii10048/afii10017/afii10018
/afii10040/afii10021/afii10022/afii10038/afii10020/afii10039/afii10026
/afii10027/afii10028/afii10029/afii10030/afii10031/afii10032/afii10033
/afii10049/afii10034/afii10035/afii10036/afii10037/afii10024/afii10019
/afii10046/afii10045/afii10025/afii10042/afii10047/afii10043/afii10041
/afii10044 128{/.notdef}repeat]
cmcitt10:
cmcti10:
cmcti12:
cmcti7:
cmcti8:
cmcti9:
cmcu10:
[25{/.notdef}repeat/afii61352 3{/.notdef}repeat/guillemotleft/guillemotright
31{/.notdef}repeat/afii10023/.notdef/afii10096/afii10065/afii10066/afii10088
/afii10069/afii10070/afii10086/afii10068/afii10087/afii10074/afii10075
/afii10076/afii10077/afii10078/afii10079/afii10080/afii10081/afii10097
/afii10082/afii10083/afii10084/afii10085/afii10072/afii10067/afii10094
/afii10093/afii10073/afii10090/afii10095/afii10091/afii10089/afii10092
/afii10048/afii10017/afii10018/afii10040/afii10021/afii10022/afii10038
/afii10020/afii10039/afii10026/afii10027/afii10028/afii10029/afii10030
/afii10031/afii10032/afii10033/afii10049/afii10034/afii10035/afii10036
/afii10037/afii10024/afii10019/afii10046/afii10045/afii10025/afii10042
/afii10047/afii10043/afii10041/afii10044 128{/.notdef}repeat]
cmcb10:
cmcbx10:
cmcbx12:
cmcbx5:
cmcbx6:
cmcbx7:
cmcbx8:
cmcbx9:
cmcsl10:
cmcsl12:
cmcsl8:
cmcsl9:
cmcss10:
cmcss12:
cmcss17:
cmcss8:
cmcss9:
cmcssi10:
cmcssi12:
cmcssi17:
cmcssi8:
cmcssi9:
cmcssq8:
cmcssqi8:
cmctt10:
cmctt12:
cmctt8:
cmctt9:
cmcyr10:
cmcyr12:
cmcyr17:
cmcyr5:
cmcyr6:
cmcyr7:
cmcyr8:
cmcyr9:
[25{/.notdef}repeat/afii61352 3{/.notdef}repeat/guillemotleft/guillemotright
29{/.notdef}repeat/afii10071/.notdef/afii10023/.notdef/afii10096/afii10065
/afii10066/afii10088/afii10069/afii10070/afii10086/afii10068/afii10087
/afii10074/afii10075/afii10076/afii10077/afii10078/afii10079/afii10080
/afii10081/afii10097/afii10082/afii10083/afii10084/afii10085/afii10072
/afii10067/afii10094/afii10093/afii10073/afii10090/afii10095/afii10091
/afii10089/afii10092/afii10048/afii10017/afii10018/afii10040/afii10021
/afii10022/afii10038/afii10020/afii10039/afii10026/afii10027/afii10028
/afii10029/afii10030/afii10031/afii10032/afii10033/afii10049/afii10034
/afii10035/afii10036/afii10037/afii10024/afii10019/afii10046/afii10045
/afii10025/afii10042/afii10047/afii10043/afii10041/afii10044 128{/.notdef}
repeat]
fgerm10:
[19{/.notdef}repeat/guillemotleft/guillemotright/endash/emdash/.notdef
/.notdef/dotlessi 7{/.notdef}repeat/exclam/quotedbl 13{/.notdef}repeat/zero
/one/two/three/four 12{/.notdef}repeat/A/B/C/D 6{/.notdef}repeat/K/L/M/N/O/P
/Q/R/S/.notdef/U 13{/.notdef}repeat/c/.notdef/e/.notdef/.notdef/h/i 9{
/.notdef}repeat/s 140{/.notdef}repeat]
kmbx10:
kmr10:
kmss10:
[18{/.notdef}repeat/quotedblbase/guillemotleft/guillemotright/endash/emdash
/cwm/perthousand 7{/.notdef}repeat/space/exclam/quotedbl/numbersign/dollar
/percent/ampersand/quoteright/parenleft/parenright/asterisk/plus/comma
/hyphen/period/slash/zero/one/two/three/four/five/six/seven/eight/nine/colon
/semicolon/less/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q
/R/S/T/U/.notdef/W/X/Y/Z/bracketleft/backslash/bracketright/asciicircum
/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/.notdef/w/x
/y/z/braceleft/bar/braceright/asciitilde/sfthyphen 16{/.notdef}repeat/Rcaron
/.notdef/Scaron/Scedilla/Tcaron/Tcedilla/Uhungarumlaut 25{/.notdef}repeat
/rcaron/.notdef/scaron/scedilla/tcaron/tcedilla/uhungarumlaut 13{/.notdef}
repeat/Adieresis 6{/.notdef}repeat/Edieresis 3{/.notdef}repeat/Idieresis 6{
/.notdef}repeat/Odieresis 5{/.notdef}repeat/Udieresis 7{/.notdef}repeat
/adieresis 6{/.notdef}repeat/edieresis 3{/.notdef}repeat/idieresis 6{
/.notdef}repeat/odieresis/.notdef/.notdef/ugrave/uacute/ucircumflex
/udieresis 3{/.notdef}repeat]
fgeit10:
[17{/.notdef}repeat/quotedblright 52{/.notdef}repeat/F 31{/.notdef}repeat/f 9
{/.notdef}repeat/p 143{/.notdef}repeat]
esrelation10:
[17{/.notdef}repeat/quotedblright/quotedblbase/guillemotleft/guillemotright
/endash/emdash/cwm/perthousand 7{/.notdef}repeat/space/.notdef/.notdef
/numbersign/dollar/percent/ampersand/.notdef/parenleft/parenright/asterisk
213{/.notdef}repeat]
yswab:
[16{/.notdef}repeat/quotedblleft/quotedblright/quotedblbase/guillemotleft
/guillemotright/endash/emdash/cwm/perthousand/.notdef/dotlessj 6{/.notdef}
repeat/exclam/quotedbl/numbersign/.notdef/percent/.notdef/quoteright
/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two
/three/four/five/six/seven/eight/nine/colon/.notdef/less/equal/.notdef
/question/.notdef/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z
/bracketleft/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c/d
/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright
/asciitilde/.notdef/.notdef/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek
/.notdef/.notdef/Lcaron/Lslash/.notdef/.notdef/Eng/.notdef/.notdef/Rcaron
/Sacute 7{/.notdef}repeat/Zacute/Zcaron 3{/.notdef}repeat/dcroat/section 4{
/.notdef}repeat/dcaron/.notdef/.notdef/gbreve 88{/.notdef}repeat]
yfrak:
[16{/.notdef}repeat/quotedblleft/quotedblright/quotedblbase/guillemotleft
/guillemotright/endash/emdash/cwm/perthousand/.notdef/dotlessj 6{/.notdef}
repeat/exclam/quotedbl/numbersign/dollar/percent/ampersand/quoteright
/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two
/three/four/five/six/seven/eight/nine/colon/semicolon/less/equal/.notdef
/question/.notdef/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z
/bracketleft/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c/d
/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright
/asciitilde/.notdef/.notdef/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek
/.notdef/.notdef/Lcaron/Lslash/Nacute/.notdef/Eng/.notdef/.notdef/Rcaron
/Sacute 7{/.notdef}repeat/Zacute/Zcaron 3{/.notdef}repeat/dcroat/section 4{
/.notdef}repeat/dcaron 36{/.notdef}repeat/Eacute 54{/.notdef}repeat]
gmtr0500:
gmtr0600:
gmtr0700:
gmtr0800:
gmtr0900:
gmtr1000:
gmtr1095:
gmtr1200:
gmtr1440:
gmtr1728:
gmtr2074:
gmtr2488:
gmtr2986:
gmtr3583:
[13{/.notdef}repeat/uni03AB.alt/uni03B1.alt/.notdef/uni02CF/uni02CE/uni03DF
/uni03D9/uni0020032E/uni03D8 4{/.notdef}repeat/uni0259/uni03E1 5{/.notdef}
repeat/exclam 5{/.notdef}repeat/tonos/parenleft/parenright 16{/.notdef}
repeat/colon/anoteleia/uni1FFE/.notdef/uni1FBF/semicolon/.notdef/Alpha/Beta
/uni1FDD/uni0394/Epsilon/Phi/Gamma/Eta/Iota/Theta/Kappa 12{/.notdef}repeat
/Xi/Psi/Zeta/bracketleft/.notdef/bracketright/uni1FCE/.notdef/uni1FEF
/.notdef/beta/sigma1/delta/epsilon/phi/gamma/eta/iota/theta/kappa/lambda 6{
/.notdef}repeat/sigma 4{/.notdef}repeat/xi/psi/zeta 133{/.notdef}repeat]
cminb7:
[12{/.notdef}repeat/fi/fl 24{/.notdef}repeat/ampersand/quoteright 4{/.notdef
}repeat/comma/hyphen/period/.notdef/zero/one/two/three/four/five/six/seven
/eight/nine/colon/semicolon 3{/.notdef}repeat/question/.notdef/A/B/C/D/E/F/G
/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/.notdef/quotedblleft 3{/.notdef}
repeat/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/endash
/emdash 131{/.notdef}repeat]
cminb17:
[12{/.notdef}repeat/fi/fl 19{/.notdef}repeat/exclam/quotedblright 3{/.notdef
}repeat/ampersand/quoteright 4{/.notdef}repeat/comma/hyphen/period/.notdef
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon 3{
/.notdef}repeat/question/.notdef/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V
/W/X/Y/Z/.notdef/quotedblleft 4{/.notdef}repeat/a/b/c/d/e/f/g/h/i/j/k/l/m/n
/o/p/q/r/s/t/u/v/w/x/y/z/endash/emdash 131{/.notdef}repeat]
cmin10:
cmin17:
cmin7:
cminb10:
[12{/.notdef}repeat/fi/fl 19{/.notdef}repeat/exclam/quotedblright 3{/.notdef
}repeat/ampersand/quoteright 4{/.notdef}repeat/comma/hyphen/period/.notdef
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon 3{
/.notdef}repeat/question/.notdef/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V
/W/X/Y/Z/.notdef/quotedblleft 3{/.notdef}repeat/quoteleft/a/b/c/d/e/f/g/h/i
/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/endash/emdash 131{/.notdef}repeat]
xadf11:
xadf13:
xadf16:
xadf20:
xadf24:
xadf29:
[7{/.notdef}repeat/Upsilon/Phi/Psi 10{/.notdef}repeat/caron/breve 8{/.notdef
}repeat/OE/Oslash/.notdef/exclam/quotedblright 50{/.notdef}repeat/U/V 169{
/.notdef}repeat]
cmsmfIPiXi10:
cmsmfIPiXi12:
cmsmfIPiXi17:
cmsmfIPiXi8:
cmsmfIPiXi9:
cmsmfIPiXibx10:
cmsmfIPiXibx12:
cmsmfIPiXibx17:
cmsmfIPiXibx8:
cmsmfIPiXibx9:
cmsmfIPiXii10:
cmsmfIPiXii12:
cmsmfIPiXii17:
cmsmfIPiXii8:
cmsmfIPiXii9:
cmsmfIPiXixi10:
cmsmfIPiXixi12:
cmsmfIPiXixi17:
cmsmfIPiXixi8:
cmsmfIPiXixi9:
[4{/.notdef}repeat/Xi/Pi 67{/.notdef}repeat/I 182{/.notdef}repeat]
cmsmfIPiXibxcsc10:
cmsmfIPiXicsc10:
cmsmfIPiXicsc8:
cmsmfIPiXicsc9:
cmsmfIPiXicsci10:
cmsmfIPiXicsci8:
cmsmfIPiXicsci9:
cmsmfIPiXixicsc10:
[4{/.notdef}repeat/Xi/Pi 67{/.notdef}repeat/I 31{/.notdef}repeat/i 150{
/.notdef}repeat]
lasy10:
lasy5:
lasy6:
lasy7:
lasy8:
lasy9:
lasyb10:
[/.notdef/a1/a2/a3/a4 35{/.notdef}repeat/a40/a41/a42/a43 4{/.notdef}repeat
/a48/a49/a50/a51 6{/.notdef}repeat/a58/a59/a60/a61 194{/.notdef}repeat]
llasy8:
llasyb8:
[/.notdef/acute/circumflex/tilde/dieresis 35{/.notdef}repeat/parenleft
/parenright/asterisk/plus 4{/.notdef}repeat/zero/one/two/three 6{/.notdef}
repeat/colon/semicolon/less/equal 194{/.notdef}repeat]
assy:
assyrb10:
[/.notdef/acute/circumflex/tilde/dieresis/hungarumlaut/ring 5{/.notdef}
repeat/ogonek/quotesinglbase 3{/.notdef}repeat/quotedblright/quotedblbase
/guillemotleft/guillemotright/endash 4{/.notdef}repeat/dotlessj/ff 8{
/.notdef}repeat/dollar/.notdef/ampersand 3{/.notdef}repeat/asterisk/.notdef
/.notdef/hyphen 14{/.notdef}repeat/less/equal/greater/.notdef/at/A/B/.notdef
/D/E/.notdef/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z 6{/.notdef}repeat/a/b
/.notdef/d/e/.notdef/g/h/i/j/k/.notdef/m/n/o/p/q/r/s/t/u/v/.notdef/x/y/z
/.notdef/bar 131{/.notdef}repeat]
serto10:
sertob10:
[/.notdef/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve 3{
/.notdef}repeat/ogonek/quotesinglbase 3{/.notdef}repeat/quotedblright
/quotedblbase/guillemotleft/guillemotright/endash/.notdef/cwm/.notdef
/.notdef/dotlessj/ff 5{/.notdef}repeat/exclam/quotedbl/numbersign/dollar
/percent/ampersand 6{/.notdef}repeat/hyphen/period 11{/.notdef}repeat/colon 6
{/.notdef}repeat/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z 4{
/.notdef}repeat/underscore 9{/.notdef}repeat/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x
/y/z 6{/.notdef}repeat/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve
/Lacute/Lcaron/Lslash/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute
/Scaron/Scedilla/Tcaron/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron
/Zdotaccent/IJ/Idotaccent/dcroat/section/abreve 10{/.notdef}repeat/nacute
/ncaron/eng 82{/.notdef}repeat]
auncl10:
aunclb10:
[/.notdef/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve
/macron/.notdef/cedilla/ogonek/.notdef/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/grave/dotaccent/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/space/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o
/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/hyphen
/quotesinglbase/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/paragraph/Lacute
/Lcaron/Lslash/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron
/slong_t/Tcaron/r.half/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdot/IJ
/Idot/dcroat/section/slong/aogonek/cacute/ccaron/dcaron/ecaron/eogonek/e_t
/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut/racute/rcaron/sacute
/scaron/s_t/tcaron/c_t/uhungarumlaut/uring/ydieresis/zacute/zcaron/zdot/ij
/exclamdown/questiondown/sterling/Agrave/Aacute/Acircumflex/Atilde/Adieresis
/Aring/AE/Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute
/Icircumflex/Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis
/OE/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute/Thorn/Germandbls
/agrave/aacute/acircumflex/atilde/adieresis/aring/ae/ccedilla/egrave/eacute
/ecircumflex/edieresis/igrave/iacute/icircumflex/idieresis/eth/ntilde/ograve
/oacute/ocircumflex/otilde/odieresis/oe/oslash/ugrave/uacute/ucircumflex
/udieresis/yacute/thorn/germandbls]
esint10:
ssesint10:
ssesint7:
ssesint8:
ssesint9:
[/.notdef/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve
/macron/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase 4{/.notdef}repeat/cwm/perthousand
/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/space/exclam/quotedbl/numbersign/dollar
/percent/ampersand 217{/.notdef}repeat]
arssb10:
arssbs10:
arssr10:
arsssl10:
artmb10:
artmbi10:
artmbs10:
artmi10:
artmr10:
artmsl10:
[/.notdef/armabbrev/armnum/Armdza/Armghat/Armtche/Arme/Armat/Armto/Armzhe
/Armsha/Armcha/Armra/Armtsa/Armpyur/Armo/.notdef/armdram/armeternity/armdza
/armghat/armtche/arme/armat/armto/armzhe/armsha/armcha/armra/armtsa/armpyur
/armo/armew/armexclam/quotedblright/numbersign/dollar/percent/ampersand
/armapostrophe/armparenleft/armparenright/asterisk/plus/armcomma/armendash
/armdot/slash/zero/one/two/three/four/five/six/seven/eight/nine/armfullstop
/semicolon/armquotleft/equal/armquotright/armquestion/at/Armayb/Armben
/Armtso/Armda/Armyech/Armfe/Armgim/Armho/Armini/Armje/Armken/Armlyun/Armmen
/Armnu/Armvo/Armpe/Armke/Armre/Armse/Armtyun/Armvovyun/Armvev/Armvyun/Armkhe
/Armhi/Armza/bracketleft/quotedblleft/bracketright/braceleft/braceright
/armsep/armayb/armben/armtso/armda/armyech/armfe/armgim/armho/armini/armje
/armken/armlyun/armmen/armnu/armvo/armpe/armke/armre/armse/armtyun/armvovyun
/armvev/armvyun/armkhe/armhi/armza/armyentamna/armaccent/emdash/exclam
/question 128{/.notdef}repeat]
wasy10:
wasy5:
wasy6:
wasy7:
wasy8:
wasy9:
wasyb10:
[/APLup/lhd/unlhd/rhd/unrhd/therefore/recorder/phone/checked/pointer/bell
/eigthnote/quarternote/halfnote/fullnote/twonotes/LHD/RHD/lightning/ascnode
/descnode/invdiameter/logof/aries/invneg/female/male/currency/clock/varprop
/varangle/diameter/CIRCLE/rightturn/leftturn/Circle/leftmoon/rightmoon/earth
/mercury/leftarrowhead/rightarrowhead/uparrowhead/downarrowhead/smiley
/blacksmiley/sun/frownie/agemO/Bowtie/Box/Diamond/XBox/lozenge/kreuz/hexagon
/octagon/varhexagon/AC/leadsto/sqsubset/sqsupset/apprle/apprge/VHF/hexstar
/varhexstar/davidsstar/pentagon/pentastar/APLdown/LEFTCIRCLE/RIGHTCIRCLE
/Leftcircle/Rightcircle/UParrow/DOWNarrow 3{/.notdef}repeat/gluonelement
/gluonbelement/gluoneelement/.notdef/.notdef/inve/conjunction/opposition
/jupiter/saturn/uranus/neptun/pluto/taurus/gemini/cancer/virgo/libra/scorpio
/sagittarius/capricorn/aquarius/pisces/cent/permil/thorn/Thorn/dh/openo
/ataribox/APLuparrowbox/APLdownarrowbox/APLleftarrowbox/APLrightarrowbox
/varint/iint/iiint/varoint/oiint/dispvarint/dispiint/dispiiint/dispvaroint
/dispoiint/brokenvert/APLinput/APLbox/APLcomment 128{/.notdef}repeat]
bbold10:
bbold12:
bbold17:
bbold5:
bbold6:
bbold7:
bbold8:
bbold9:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/alpha/beta
/gamma/delta/epsilon/zeta/eta/theta/iota/kappa/lambda/mu/nu/xi/pi/rho/sigma
/tau/upsilon/phi/chi/psi/exclam/quotedblright/numbersign/dollar/percent
/ampersand/quoteright/parenleft/parenright/asterisk/plus/comma/hyphen/period
/slash/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon
/less/periodcentered/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R
/S/T/U/V/W/X/Y/Z/bracketleft/backslash/bracketright/langle/rangle/quoteleft
/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/endash/bar/emdash
/quotedbleright/omega 128{/.notdef}repeat]
ccmi10:
ccmic9:
cmbrmb10:
cmbrmi10:
cmbrmi8:
cmbrmi9:
cmmi10:
cmmi12:
cmmi5:
cmmi6:
cmmi7:
cmmi8:
cmmi9:
cmmib10:
cmmib5:
cmmib6:
cmmib7:
cmmib8:
cmmib9:
plmi10:
plmi12:
plmi5:
plmi6:
plmi7:
plmi8:
plmi9:
plmib10:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/alpha/beta
/gamma/delta/epsilon1/zeta/eta/theta/iota/kappa/lambda/mu/nu/xi/pi/rho/sigma
/tau/upsilon/phi/chi/psi/omega/epsilon/theta1/pi1/rho1/sigma1/phi1
/arrowlefttophalf/arrowleftbothalf/arrowrighttophalf/arrowrightbothalf
/arrowhookleft/arrowhookright/triangleright/triangleleft/zerooldstyle
/oneoldstyle/twooldstyle/threeoldstyle/fouroldstyle/fiveoldstyle/sixoldstyle
/sevenoldstyle/eightoldstyle/nineoldstyle/period/comma/less/slash/greater
/star/partialdiff/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/flat
/natural/sharp/slurbelow/slurabove/lscript/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q
/r/s/t/u/v/w/x/y/z/dotlessi/dotlessj/weierstrass/vector/tie 128{/.notdef}
repeat]
cscsc10:
csr5:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/arrowup
/arrowdown/quotesingle/exclamdown/questiondown/dotlessi/dotlessj/grave/acute
/caron/breve/macron/ring/cedilla/germandbls/ae/oe/oslash/AE/OE/Oslash
/polishlcross/exclam/quotedblright/numbersign/dollar/percent/ampersand
/quoteright/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon/less
/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y
/Z/bracketleft/quotedblleft/bracketright/circumflex/dotaccent/quoteleft/a/b
/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/endash/emdash/hungarumlaut
/tilde/dieresis 13{/.notdef}repeat/perthousand 10{/.notdef}repeat/Agrave 3{
/.notdef}repeat/althyphen/ogonek/guillemotleft/guillemotright 5{/.notdef}
repeat/Lcaron 3{/.notdef}repeat/Scaron/.notdef/Tcaron/.notdef/.notdef/Zcaron
6{/.notdef}repeat/lcaron/.notdef/.notdef/agrave/scaron/.notdef/tcaron
/.notdef/.notdef/zcaron/.notdef/Racute/Aacute/.notdef/.notdef/Adieresis
/Lacute/.notdef/.notdef/Ccaron/Eacute/.notdef/.notdef/Ecaron/Iacute/.notdef
/Dcaron/.notdef/.notdef/Ncaron/Oacute/Ocircumflex/.notdef/Odieresis/.notdef
/Rcaron/Uring/Uacute/.notdef/Udieresis/Yacute/.notdef/.notdef/racute/aacute
/.notdef/.notdef/adieresis/lacute/.notdef/.notdef/ccaron/eacute/.notdef
/.notdef/ecaron/iacute/.notdef/dcaron/.notdef/.notdef/ncaron/oacute
/ocircumflex/.notdef/odieresis/.notdef/rcaron/uring/uacute/.notdef/udieresis
/yacute/quotedblbase/csquotedblright]
cccsc10:
ccr5:
cmcsc10:
cmcsc8:
cmcsc9:
cmr5:
punk10:
punk12:
punk20:
punkbx20:
punkbxx20:
punksl20:
punkslx20:
punkz20:
ttmc10:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/arrowup
/arrowdown/quotesingle/exclamdown/questiondown/dotlessi/dotlessj/grave/acute
/caron/breve/macron/ring/cedilla/germandbls/ae/oe/oslash/AE/OE/Oslash
/suppress/exclam/quotedblright/numbersign/dollar/percent/ampersand
/quoteright/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon/less
/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y
/Z/bracketleft/quotedblleft/bracketright/circumflex/dotaccent/quoteleft/a/b
/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/endash/emdash/hungarumlaut
/tilde/dieresis 128{/.notdef}repeat]
plcsc10:
plr5:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/arrowup
/arrowdown/quotesingle/exclamdown/questiondown/dotlessi/dotlessj/grave/acute
/caron/breve/macron/ring/cedilla/germandbls/ae/oe/oslash/AE/OE/Oslash
/suppress/exclam/quotedblright/numbersign/dollar/percent/ampersand
/quoteright/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon/less
/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y
/Z/bracketleft/quotedblleft/bracketright/circumflex/dotaccent/quoteleft/a/b
/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/endash/emdash/hungarumlaut
/tilde/dieresis/.notdef/Aogonek/Cacute 3{/.notdef}repeat/Eogonek 3{/.notdef}
repeat/Lslash/Nacute 5{/.notdef}repeat/Sacute 7{/.notdef}repeat/Zacute
/.notdef/Zdotaccent 5{/.notdef}repeat/aogonek/cacute 3{/.notdef}repeat
/eogonek 3{/.notdef}repeat/lslash/nacute/.notdef/.notdef/guillemotleft
/guillemotright/.notdef/sacute 7{/.notdef}repeat/zacute/.notdef/zdotaccent 23
{/.notdef}repeat/Oacute 31{/.notdef}repeat/oacute 11{/.notdef}repeat
/quotedblbase]
cmntt10:
cmsltt10:
cmsltt9:
cmtcsc10:
cmtt10:
cmtt12:
cmtt8:
cmtt9:
cmttsq14:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/arrowup
/arrowdown/quotesingle/exclamdown/questiondown/dotlessi/dotlessj/grave/acute
/caron/breve/macron/ring/cedilla/germandbls/ae/oe/oslash/AE/OE/Oslash
/visiblespace/exclam/quotedbl/numbersign/dollar/percent/ampersand/quoteright
/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two
/three/four/five/six/seven/eight/nine/colon/semicolon/less/equal/greater
/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft
/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j
/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde
/dieresis 128{/.notdef}repeat]
cssltt10:
cstcsc10:
cstt10:
cstt12:
cstt8:
cstt9:
csvtt10:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/arrowup
/arrowdown/quotesingle/exclamdown/questiondown/dotlessi/dotlessj/grave/acute
/caron/breve/macron/ring/cedilla/germandbls/ae/oe/oslash/AE/OE/Oslash
/visiblespace/exclam/quotedbl/numbersign/dollar/percent/ampersand/quoteright
/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two
/three/four/five/six/seven/eight/nine/colon/semicolon/less/equal/greater
/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft
/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j
/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde
/dieresis 13{/.notdef}repeat/perthousand 10{/.notdef}repeat/Agrave 3{
/.notdef}repeat/althyphen/ogonek/guillemotleft/guillemotright 5{/.notdef}
repeat/Lcaron 3{/.notdef}repeat/Scaron/.notdef/Tcaron/.notdef/.notdef/Zcaron
6{/.notdef}repeat/lcaron/.notdef/.notdef/agrave/scaron/.notdef/tcaron
/.notdef/.notdef/zcaron/.notdef/Racute/Aacute/.notdef/.notdef/Adieresis
/Lacute/.notdef/.notdef/Ccaron/Eacute/.notdef/.notdef/Ecaron/Iacute/.notdef
/Dcaron/.notdef/.notdef/Ncaron/Oacute/Ocircumflex/.notdef/Odieresis/.notdef
/Rcaron/Uring/Uacute/.notdef/Udieresis/Yacute/.notdef/.notdef/racute/aacute
/.notdef/.notdef/adieresis/lacute/.notdef/.notdef/ccaron/eacute/.notdef
/.notdef/ecaron/iacute/.notdef/dcaron/.notdef/.notdef/ncaron/oacute
/ocircumflex/.notdef/odieresis/.notdef/rcaron/uring/uacute/.notdef/udieresis
/yacute/quotedblbase/csquotedblright]
plsltt10:
pltcsc10:
pltt10:
pltt12:
pltt8:
pltt9:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/arrowup
/arrowdown/quotesingle/exclamdown/questiondown/dotlessi/dotlessj/grave/acute
/caron/breve/macron/ring/cedilla/germandbls/ae/oe/oslash/AE/OE/Oslash
/visiblespace/exclam/quotedbl/numbersign/dollar/percent/ampersand/quoteright
/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two
/three/four/five/six/seven/eight/nine/colon/semicolon/less/equal/greater
/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft
/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j
/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde
/dieresis/.notdef/Aogonek/Cacute 3{/.notdef}repeat/Eogonek 3{/.notdef}repeat
/Lslash/Nacute 5{/.notdef}repeat/Sacute 7{/.notdef}repeat/Zacute/.notdef
/Zdotaccent 5{/.notdef}repeat/aogonek/cacute 3{/.notdef}repeat/eogonek 3{
/.notdef}repeat/lslash/nacute/.notdef/.notdef/guillemotleft/guillemotright
/.notdef/sacute 7{/.notdef}repeat/zacute/.notdef/zdotaccent 23{/.notdef}
repeat/Oacute 31{/.notdef}repeat/oacute 11{/.notdef}repeat/quotedblbase]
cmitt10:
cmitt12:
cmitt9:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/arrowup
/arrowdown/quotesingle/exclamdown/questiondown/dotlessi/dotlessj/grave/acute
/caron/breve/macron/ring/cedilla/germandbls/ae/oe/oslash/AE/OE/Oslash
/visiblespace/exclam/quotedbl/numbersign/sterling/percent/ampersand
/quoteright/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon/less
/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y
/Z/bracketleft/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c
/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright
/asciitilde/dieresis 128{/.notdef}repeat]
csitt10:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/arrowup
/arrowdown/quotesingle/exclamdown/questiondown/dotlessi/dotlessj/grave/acute
/caron/breve/macron/ring/cedilla/germandbls/ae/oe/oslash/AE/OE/Oslash
/visiblespace/exclam/quotedbl/numbersign/sterling/percent/ampersand
/quoteright/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon/less
/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y
/Z/bracketleft/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c
/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright
/asciitilde/dieresis 13{/.notdef}repeat/perthousand 10{/.notdef}repeat
/Agrave 3{/.notdef}repeat/althyphen/ogonek/guillemotleft/guillemotright 5{
/.notdef}repeat/Lcaron 3{/.notdef}repeat/Scaron/.notdef/Tcaron/.notdef
/.notdef/Zcaron 6{/.notdef}repeat/lcaron/.notdef/.notdef/agrave/scaron
/.notdef/tcaron/.notdef/.notdef/zcaron/.notdef/Racute/Aacute/.notdef/.notdef
/Adieresis/Lacute/.notdef/.notdef/Ccaron/Eacute/.notdef/.notdef/Ecaron
/Iacute/.notdef/Dcaron/.notdef/.notdef/Ncaron/Oacute/Ocircumflex/.notdef
/Odieresis/.notdef/Rcaron/Uring/Uacute/.notdef/Udieresis/Yacute/.notdef
/.notdef/racute/aacute/.notdef/.notdef/adieresis/lacute/.notdef/.notdef
/ccaron/eacute/.notdef/.notdef/ecaron/iacute/.notdef/dcaron/.notdef/.notdef
/ncaron/oacute/ocircumflex/.notdef/odieresis/.notdef/rcaron/uring/uacute
/.notdef/udieresis/yacute/quotedblbase/csquotedblright]
plitt10:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/arrowup
/arrowdown/quotesingle/exclamdown/questiondown/dotlessi/dotlessj/grave/acute
/caron/breve/macron/ring/cedilla/germandbls/ae/oe/oslash/AE/OE/Oslash
/visiblespace/exclam/quotedbl/numbersign/sterling/percent/ampersand
/quoteright/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon/less
/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y
/Z/bracketleft/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c
/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright
/asciitilde/dieresis/.notdef/Aogonek/Cacute 3{/.notdef}repeat/Eogonek 3{
/.notdef}repeat/Lslash/Nacute 5{/.notdef}repeat/Sacute 7{/.notdef}repeat
/Zacute/.notdef/Zdotaccent 5{/.notdef}repeat/aogonek/cacute 3{/.notdef}
repeat/eogonek 3{/.notdef}repeat/lslash/nacute/.notdef/.notdef/guillemotleft
/guillemotright/.notdef/sacute 7{/.notdef}repeat/zacute/.notdef/zdotaccent 23
{/.notdef}repeat/Oacute 31{/.notdef}repeat/oacute 11{/.notdef}repeat
/quotedblbase]
csb10:
csbx10:
csbx12:
csbx5:
csbx6:
csbx7:
csbx8:
csbx9:
csbxsl10:
csdunh10:
csff10:
csfib8:
csr10:
csr12:
csr17:
csr6:
csr7:
csr8:
csr9:
cssl10:
cssl12:
cssl8:
cssl9:
csss10:
csss12:
csss17:
csss8:
csss9:
csssbx10:
csssdc10:
csssi10:
csssi12:
csssi17:
csssi8:
csssi9:
csssq8:
csssqi8:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/ff/fi/fl/ffi
/ffl/dotlessi/dotlessj/grave/acute/caron/breve/macron/ring/cedilla
/germandbls/ae/oe/oslash/AE/OE/Oslash/polishlcross/exclam/quotedblright
/numbersign/dollar/percent/ampersand/quoteright/parenleft/parenright
/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four/five/six
/seven/eight/nine/colon/semicolon/exclamdown/equal/questiondown/question/at
/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft
/quotedblleft/bracketright/circumflex/dotaccent/quoteleft/a/b/c/d/e/f/g/h/i
/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/endash/emdash/hungarumlaut/tilde/dieresis
13{/.notdef}repeat/perthousand 10{/.notdef}repeat/Agrave 3{/.notdef}repeat
/althyphen/ogonek/guillemotleft/guillemotright 5{/.notdef}repeat/Lcaron 3{
/.notdef}repeat/Scaron/.notdef/Tcaron/.notdef/.notdef/Zcaron 6{/.notdef}
repeat/lcaron/.notdef/.notdef/agrave/scaron/.notdef/tcaron/.notdef/.notdef
/zcaron/.notdef/Racute/Aacute/.notdef/.notdef/Adieresis/Lacute/.notdef
/.notdef/Ccaron/Eacute/.notdef/.notdef/Ecaron/Iacute/.notdef/Dcaron/.notdef
/.notdef/Ncaron/Oacute/Ocircumflex/.notdef/Odieresis/.notdef/Rcaron/Uring
/Uacute/.notdef/Udieresis/Yacute/.notdef/.notdef/racute/aacute/.notdef
/.notdef/adieresis/lacute/.notdef/.notdef/ccaron/eacute/.notdef/.notdef
/ecaron/iacute/.notdef/dcaron/.notdef/.notdef/ncaron/oacute/ocircumflex
/.notdef/odieresis/.notdef/rcaron/uring/uacute/.notdef/udieresis/yacute
/quotedblbase/csquotedblright]
csbxti10:
csfi10:
csti10:
csti12:
csti7:
csti8:
csti9:
csu10:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/ff/fi/fl/ffi
/ffl/dotlessi/dotlessj/grave/acute/caron/breve/macron/ring/cedilla
/germandbls/ae/oe/oslash/AE/OE/Oslash/polishlcross/exclam/quotedblright
/numbersign/sterling/percent/ampersand/quoteright/parenleft/parenright
/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four/five/six
/seven/eight/nine/colon/semicolon/exclamdown/equal/questiondown/question/at
/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft
/quotedblleft/bracketright/circumflex/dotaccent/quoteleft/a/b/c/d/e/f/g/h/i
/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/endash/emdash/hungarumlaut/tilde/dieresis
13{/.notdef}repeat/perthousand 10{/.notdef}repeat/Agrave 3{/.notdef}repeat
/althyphen/ogonek/guillemotleft/guillemotright 5{/.notdef}repeat/Lcaron 3{
/.notdef}repeat/Scaron/.notdef/Tcaron/.notdef/.notdef/Zcaron 6{/.notdef}
repeat/lcaron/.notdef/.notdef/agrave/scaron/.notdef/tcaron/.notdef/.notdef
/zcaron/.notdef/Racute/Aacute/.notdef/.notdef/Adieresis/Lacute/.notdef
/.notdef/Ccaron/Eacute/.notdef/.notdef/Ecaron/Iacute/.notdef/Dcaron/.notdef
/.notdef/Ncaron/Oacute/Ocircumflex/.notdef/Odieresis/.notdef/Rcaron/Uring
/Uacute/.notdef/Udieresis/Yacute/.notdef/.notdef/racute/aacute/.notdef
/.notdef/adieresis/lacute/.notdef/.notdef/ccaron/eacute/.notdef/.notdef
/ecaron/iacute/.notdef/dcaron/.notdef/.notdef/ncaron/oacute/ocircumflex
/.notdef/odieresis/.notdef/rcaron/uring/uacute/.notdef/udieresis/yacute
/quotedblbase/csquotedblright]
ccn10:
ccr10:
ccr7:
ccr8:
ccr9:
ccsl10:
ccsl9:
ccslc9:
cmb10:
cmbr10:
cmbr17:
cmbr8:
cmbr9:
cmbrbx10:
cmbrsl10:
cmbrsl17:
cmbrsl8:
cmbrsl9:
cmbx10:
cmbx12:
cmbx5:
cmbx6:
cmbx7:
cmbx8:
cmbx9:
cmbxcd10:
cmbxsl10:
cmdunh10:
cmhFv:
cmr10:
cmr10mod:
cmr12:
cmr17:
cmr6:
cmr7:
cmr8:
cmr9:
cmsl10:
cmsl12:
cmsl6:
cmsl8:
cmsl9:
cmsltl10:
cmss10:
cmss12:
cmss17:
cmss8:
cmss9:
cmssbx10:
cmssbxcsc10:
cmssbxo10:
cmsscsc10:
cmsscsc8:
cmsscsc9:
cmsscsci10:
cmsscsci8:
cmsscsci9:
cmssdc10:
cmssi10:
cmssi12:
cmssi17:
cmssi8:
cmssi9:
cmsslu30:
cmssq8:
cmssqi8:
cmssu10:
cmssxicsc10:
cmtitl:
cmtl10:
cmvtt10:
f36:
geom10:
lcmss8:
lcmssb8:
lcmssi8:
pcmi10:
xbmc10:
xmas0:
xmas1:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/ff/fi/fl/ffi
/ffl/dotlessi/dotlessj/grave/acute/caron/breve/macron/ring/cedilla
/germandbls/ae/oe/oslash/AE/OE/Oslash/suppress/exclam/quotedblright
/numbersign/dollar/percent/ampersand/quoteright/parenleft/parenright
/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four/five/six
/seven/eight/nine/colon/semicolon/exclamdown/equal/questiondown/question/at
/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft
/quotedblleft/bracketright/circumflex/dotaccent/quoteleft/a/b/c/d/e/f/g/h/i
/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/endash/emdash/hungarumlaut/tilde/dieresis
128{/.notdef}repeat]
pccsc10:
pcr10:
pcr5:
pcr6:
pcr7:
pcr8:
pcr9:
pcsl10:
pcslc9:
pcti10:
plb10:
plbx10:
plbx12:
plbx5:
plbx6:
plbx7:
plbx8:
plbx9:
plbxsl10:
pldunh10:
plff10:
plfib8:
plr10:
plr12:
plr17:
plr6:
plr7:
plr8:
plr9:
plsl10:
plsl12:
plsl8:
plsl9:
plss10:
plss12:
plss17:
plss8:
plss9:
plssbi10:
plssbx10:
plssdc10:
plssi10:
plssi12:
plssi17:
plssi8:
plssi9:
plssq8:
plssqi8:
plvtt10:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/ff/fi/fl/ffi
/ffl/dotlessi/dotlessj/grave/acute/caron/breve/macron/ring/cedilla
/germandbls/ae/oe/oslash/AE/OE/Oslash/suppress/exclam/quotedblright
/numbersign/dollar/percent/ampersand/quoteright/parenleft/parenright
/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four/five/six
/seven/eight/nine/colon/semicolon/exclamdown/equal/questiondown/question/at
/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft
/quotedblleft/bracketright/circumflex/dotaccent/quoteleft/a/b/c/d/e/f/g/h/i
/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/endash/emdash/hungarumlaut/tilde/dieresis
/.notdef/Aogonek/Cacute 3{/.notdef}repeat/Eogonek 3{/.notdef}repeat/Lslash
/Nacute 5{/.notdef}repeat/Sacute 7{/.notdef}repeat/Zacute/.notdef/Zdotaccent
5{/.notdef}repeat/aogonek/cacute 3{/.notdef}repeat/eogonek 3{/.notdef}repeat
/lslash/nacute/.notdef/.notdef/guillemotleft/guillemotright/.notdef/sacute 7
{/.notdef}repeat/zacute/.notdef/zdotaccent 23{/.notdef}repeat/Oacute 31{
/.notdef}repeat/oacute 11{/.notdef}repeat/quotedblbase]
bible12:
ccti10:
cmbxti10:
cmbxti12:
cmbxti7:
cmff10:
cmfi10:
cmfib8:
cmti10:
cmti12:
cmti7:
cmti8:
cmti9:
cmu10:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/ff/fi/fl/ffi
/ffl/dotlessi/dotlessj/grave/acute/caron/breve/macron/ring/cedilla
/germandbls/ae/oe/oslash/AE/OE/Oslash/suppress/exclam/quotedblright
/numbersign/sterling/percent/ampersand/quoteright/parenleft/parenright
/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four/five/six
/seven/eight/nine/colon/semicolon/exclamdown/equal/questiondown/question/at
/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft
/quotedblleft/bracketright/circumflex/dotaccent/quoteleft/a/b/c/d/e/f/g/h/i
/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/endash/emdash/hungarumlaut/tilde/dieresis
128{/.notdef}repeat]
plbxti10:
plfi10:
plti10:
plti12:
plti7:
plti8:
plti9:
plu10:
[/Gamma/Delta/Theta/Lambda/Xi/Pi/Sigma/Upsilon/Phi/Psi/Omega/ff/fi/fl/ffi
/ffl/dotlessi/dotlessj/grave/acute/caron/breve/macron/ring/cedilla
/germandbls/ae/oe/oslash/AE/OE/Oslash/suppress/exclam/quotedblright
/numbersign/sterling/percent/ampersand/quoteright/parenleft/parenright
/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four/five/six
/seven/eight/nine/colon/semicolon/exclamdown/equal/questiondown/question/at
/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft
/quotedblleft/bracketright/circumflex/dotaccent/quoteleft/a/b/c/d/e/f/g/h/i
/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/endash/emdash/hungarumlaut/tilde/dieresis
/.notdef/Aogonek/Cacute 3{/.notdef}repeat/Eogonek 3{/.notdef}repeat/Lslash
/Nacute 5{/.notdef}repeat/Sacute 7{/.notdef}repeat/Zacute/.notdef/Zdotaccent
5{/.notdef}repeat/aogonek/cacute 3{/.notdef}repeat/eogonek 3{/.notdef}repeat
/lslash/nacute/.notdef/.notdef/guillemotleft/guillemotright/.notdef/sacute 7
{/.notdef}repeat/zacute/.notdef/zdotaccent 23{/.notdef}repeat/Oacute 31{
/.notdef}repeat/oacute 11{/.notdef}repeat/quotedblbase]
tbbx10:
tbmo10:
tbmo17:
tbmo8:
tbmo9:
tbmr10:
tbmr17:
tbmr8:
tbmr9:
tbso10:
tbso17:
tbso8:
tbso9:
tbsr10:
tbsr17:
tbsr8:
tbsr9:
tbtl10:
tbto10:
tcbi0500:
tcbi0600:
tcbi0700:
tcbi0800:
tcbi0900:
tcbi1000:
tcbi1095:
tcbi1200:
tcbi1440:
tcbi1728:
tcbi2074:
tcbi2488:
tcbi2986:
tcbi3583:
tcbl0500:
tcbl0600:
tcbl0700:
tcbl0800:
tcbl0900:
tcbl1000:
tcbl1095:
tcbl1200:
tcbl1440:
tcbl1728:
tcbl2074:
tcbl2488:
tcbl2986:
tcbl3583:
tcbx0500:
tcbx0600:
tcbx0700:
tcbx0800:
tcbx0900:
tcbx1000:
tcbx1095:
tcbx1200:
tcbx1440:
tcbx1728:
tcbx2074:
tcbx2488:
tcbx2986:
tcbx3583:
tcci0500:
tcci0600:
tcci0700:
tcci0800:
tcci0900:
tcci1000:
tcci1095:
tcci1200:
tcci1440:
tcci1728:
tcci2074:
tcci2488:
tcci2986:
tcci3583:
tcit0800:
tcit0900:
tcit1000:
tcit1095:
tcit1200:
tcit1440:
tcit1728:
tcit2074:
tcit2488:
tcit2986:
tcit3583:
tcrb0500:
tcrb0600:
tcrb0700:
tcrb0800:
tcrb0900:
tcrb1000:
tcrb1095:
tcrb1200:
tcrb1440:
tcrb1728:
tcrb2074:
tcrb2488:
tcrb2986:
tcrb3583:
tcrm0500:
tcrm0600:
tcrm0700:
tcrm0800:
tcrm0900:
tcrm1000:
tcrm1095:
tcrm1200:
tcrm1440:
tcrm1728:
tcrm2074:
tcrm2488:
tcrm2986:
tcrm3583:
tcsi0500:
tcsi0600:
tcsi0700:
tcsi0800:
tcsi0900:
tcsi1000:
tcsi1095:
tcsi1200:
tcsi1440:
tcsi1728:
tcsi2074:
tcsi2488:
tcsi2986:
tcsi3583:
tcsl0500:
tcsl0600:
tcsl0700:
tcsl0800:
tcsl0900:
tcsl1000:
tcsl1095:
tcsl1200:
tcsl1440:
tcsl1728:
tcsl2074:
tcsl2488:
tcsl2986:
tcsl3583:
tcso0500:
tcso0600:
tcso0700:
tcso0800:
tcso0900:
tcso1000:
tcso1095:
tcso1200:
tcso1440:
tcso1728:
tcso2074:
tcso2488:
tcso2986:
tcso3583:
tcss0500:
tcss0600:
tcss0700:
tcss0800:
tcss0900:
tcss1000:
tcss1095:
tcss1200:
tcss1440:
tcss1728:
tcss2074:
tcss2488:
tcss2986:
tcss3583:
tcssdc10:
tcst0800:
tcst0900:
tcst1000:
tcst1095:
tcst1200:
tcst1440:
tcst1728:
tcst2074:
tcst2488:
tcst2986:
tcst3583:
tcsx0500:
tcsx0600:
tcsx0700:
tcsx0800:
tcsx0900:
tcsx1000:
tcsx1095:
tcsx1200:
tcsx1440:
tcsx1728:
tcsx2074:
tcsx2488:
tcsx2986:
tcsx3583:
tcti0500:
tcti0600:
tcti0700:
tcti0800:
tcti0900:
tcti1000:
tcti1095:
tcti1200:
tcti1440:
tcti1728:
tcti2074:
tcti2488:
tcti2986:
tcti3583:
tctt0800:
tctt0900:
tctt1000:
tctt1095:
tctt1200:
tctt1440:
tctt1728:
tctt2074:
tctt2488:
tctt2986:
tctt3583:
tcui0500:
tcui0600:
tcui0700:
tcui0800:
tcui0900:
tcui1000:
tcui1095:
tcui1200:
tcui1440:
tcui1728:
tcui2074:
tcui2488:
tcui2986:
tcui3583:
tcvi0800:
tcvi0900:
tcvi1000:
tcvi1095:
tcvi1200:
tcvi1440:
tcvi1728:
tcvi2074:
tcvi2488:
tcvi2986:
tcvi3583:
tcvt0800:
tcvt0900:
tcvt1000:
tcvt1095:
tcvt1200:
tcvt1440:
tcvt1728:
tcvt2074:
tcvt2488:
tcvt2986:
tcvt3583:
torm10:
torm5:
torm6:
torm7:
torm8:
torm9:
tosl10:
tosl5:
tosl6:
tosl7:
tosl8:
tosl9:
toti10:
[/Grave/Acute/Circumflex/Tilde/Dieresis/Hungarumlaut/Ring/Caron/Breve/Macron
/Dotaccent/cedilla/ogonek/quotesinglbase.ts1 4{/.notdef}repeat
/quotedblbase.ts1/.notdef/.notdef/twelveudash/threequartersemdash
/afii61664.cap/arrowleft/arrowright/tieaccentlowercase/tieaccentcapital
/tieaccentlowercase.new/tieaccentcapital.new/.notdef/afii61664.asc/uni2422 3
{/.notdef}repeat/dollar/.notdef/.notdef/quotesingle/.notdef/.notdef
/asteriskmath/.notdef/comma/hyphendbl/period/fraction/zerooldstyle
/oneoldstyle/twooldstyle/threeoldstyle/fouroldstyle/fiveoldstyle/sixoldstyle
/sevenoldstyle/eightoldstyle/nineoldstyle/.notdef/.notdef/angleleft/minus
/angleright 14{/.notdef}repeat/uni2127/.notdef/circle 7{/.notdef}repeat
/Omega 3{/.notdef}repeat/uni301A/.notdef/uni301B/arrowup/arrowdown/grave.ts1
/.notdef/born/divorced/died 7{/.notdef}repeat/leaf/married/musicalnote 15{
/.notdef}repeat/tildelow/hyphendbl.alt/breve.ts1/caron.ts1/hungarumlaut.ts1
/dblgrave.ts1/dagger/daggerdbl/uni2016/perthousand/bullet/uni2103
/dollaroldstyle/centoldstyle/florin/colonmonetary/uni20A9/uni20A6/guarani
/peso/lira/recipe/uni203D/gnaborretni/dong/trademark/uni2031/paragraph.alt
/uni0E3F/afii61352/discount/estimated/openbullet/uni2120/uni2045/uni2046
/cent/sterling/currency/yen/brokenbar/section/dieresis.ts1/copyright
/ordfeminine/copyleft/logicalnot/uni2117/registered/macron.ts1/degree
/plusminus/twosuperior/threesuperior/acute.ts1/mu/paragraph/periodcentered
/uni203B/onesuperior/ordmasculine/radical/onequarter/onehalf/threequarters
/Euro 22{/.notdef}repeat/multiply 31{/.notdef}repeat/divide 9{/.notdef}
repeat]
yrcmex10:
[/NUL/Eth/eth/Lslash/lslash/Scaron/scaron/Yacute/yacute/HT/LF/Thorn/thorn/CR
/Zcaron/zcaron/DLE/DC1/DC2/DC3/DC4/onehalf/onequarter/onesuperior
/threequarters/threesuperior/twosuperior/brokenbar/minus/multiply/RS/US
/space/exclam/quotedbl/numbersign/dollar/percent/ampersand/quotesingle
/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two
/three/four/five/six/seven/eight/nine/colon/semicolon/less/equal/greater
/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft
/backslash/bracketright/asciicircum/underscore/grave/a/b/c/d/e/f/g/h/i/j/k/l
/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/DEL
/Adieresis/Aring/Ccedilla/Eacute/Ntilde/Odieresis/Udieresis/aacute/agrave
/acircumflex/adieresis/atilde/aring/ccedilla/eacute/egrave/ecircumflex
/edieresis/iacute/igrave/icircumflex/idieresis/ntilde/oacute/ograve
/ocircumflex/odieresis/otilde/uacute/ugrave/ucircumflex/udieresis/dagger
/degree/cent/sterling/section/bullet/paragraph/germandbls/registered
/copyright/trademark/acute/dieresis/notequal/AE/Oslash/infinity/plusminus
/lessequal/greaterequal/yen/mu/partialdiff/summation/product/pi/integral
/ordfeminine/ordmasculine/Omega/ae/oslash/questiondown/exclamdown/logicalnot
/radical/florin/approxequal/Delta/guillemotleft/guillemotright/ellipsis
/nbspace/Agrave/Atilde/Otilde/OE/oe/endash/emdash/quotedblleft/quotedblright
/quoteleft/quoteright/divide/lozenge/ydieresis/Ydieresis/fraction/currency
/guilsinglleft/guilsinglright/fi/fl/daggerdbl/periodcentered/quotesinglbase
/quotedblbase/perthousand/Acircumflex/Ecircumflex/Aacute/Edieresis/Egrave
/Iacute/Icircumflex/Idieresis/Igrave/Oacute/Ocircumflex/apple/Ograve/Uacute
/Ucircumflex/Ugrave/dotlessi/circumflex/tilde/macron/breve/dotaccent/ring
/cedilla/hungarumlaut/ogonek/caron]
wncyb10:
wncyb5:
wncyb6:
wncyb7:
wncyb8:
wncyb9:
wncyi10:
wncyi5:
wncyi6:
wncyi7:
wncyi8:
wncyi9:
wncyr10:
wncyr5:
wncyr6:
wncyr7:
wncyr8:
wncyr9:
wncysc10:
wncyss10:
wncyss8:
wncyss9:
[/Nj/Lj/Dzh/Ze/Iroman/Ye/Dj/Tsoft/nj/lj/dzh/ze/iroman/ye/dj/tsoft/Yu/Zhe
/Ishort/Yo/Izhitsa/Fita/Zelo/Ya/yu/zhe/ishort/yo/izhitsa/fita/zelo/ya
/dieresis/exclam/quotedblright/Yatz/breve1/percent/acute/quoteright
/parenleft/parenright/asterisk/yatz/comma/hyphen/period/slash/zero/one/two
/three/four/five/six/seven/eight/nine/colon/semicolon/guillemotleft/dotlessi
/guillemotright/question/breve/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W
/X/Y/Z/bracketleft/quotedblleft/bracketright/Soft/Hard/quoteleft/a/b/c/d/e/f
/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/endash/emdash/number/soft/hard 128{
/.notdef}repeat]
line10:
linew10:
[/a0/a1/a2/a3/a4/a5/.notdef/.notdef/a8/a9/a10/a11/a12/a13/a14/a15/a16/a17
/a18/a19/a20/a21/.notdef/a23/a24/a25/a26/a27/a28/a29/a30/.notdef/a32/a33/a34
/a35/.notdef/a37/.notdef/.notdef/a40/a41/a42/a43/a44/a45/.notdef/a47/.notdef
/a49/.notdef/a51/.notdef/.notdef/a54/a55/.notdef/a57/a58/.notdef/.notdef/a61
/a62/a63/a64/a65/a66/a67/a68/a69/.notdef/.notdef/a72/a73/a74/a75/a76/a77/a78
/a79/a80/a81/a82/a83/a84/a85/.notdef/a87/a88/a89/a90/.notdef/a92/a93/a94
/.notdef/a96/a97/a98/a99/.notdef/a101/.notdef/.notdef/a104/a105/a106/a107
/a108/.notdef/.notdef/a111/.notdef/a113/.notdef/a115 3{/.notdef}repeat/a119
/.notdef/a121/a122/.notdef/.notdef/a125/a126 129{/.notdef}repeat]
lcircle10:
lcirclew10:
[/a0/a1/a2/a3/a4/a5/a6/a7/a8/a9/a10/a11/a12/a13/a14/a15/a16/a17/a18/a19/a20
/a21/a22/a23/a24/a25/a26/a27/a28/a29/a30/a31/a32/a33/a34/a35/a36/a37/a38/a39
56{/.notdef}repeat/a96/a97/a98/a99/a100/a101/a102/a103/a104/a105/a106/a107
/a108/a109/a110/.notdef/a112/a113/a114/a115/a116/a117/a118/a119/a120/a121
/a122/a123/a124/a125/a126 129{/.notdef}repeat]
xydash10:
[/a0/a1/a2/a3/a4/a5/a6/a7/a8/a9/a10/a11/a12/a13/a14/a15/a16/a17/a18/a19/a20
/a21/a22/a23/a24/a25/a26/a27/a28/a29/a30/a31/a32/a33/a34/a35/a36/a37/a38/a39
/a40/a41/a42/a43/a44/a45/a46/a47/a48/a49/a50/a51/a52/a53/a54/a55/a56/a57/a58
/a59/a60/a61/a62/a63/a64/a65/a66/a67/a68/a69/a70/a71/a72/a73/a74/a75/a76/a77
/a78/a79/a80/a81/a82/a83/a84/a85/a86/a87/a88/a89/a90/a91/a92/a93/a94/a95/a96
/a97/a98/a99/a100/a101/a102/a103/a104/a105/a106/a107/a108/a109/a110/a111
/a112/a113/a114/a115/a116/a117/a118/a119/a120/a121/a122/a123/a124/a125/a126
/a127 128{/.notdef}repeat]
MnSymbolA-Bold10:
MnSymbolA-Bold12:
MnSymbolA-Bold5:
MnSymbolA-Bold6:
MnSymbolA-Bold7:
MnSymbolA-Bold8:
MnSymbolA-Bold9:
MnSymbolA10:
MnSymbolA12:
MnSymbolA5:
MnSymbolA6:
MnSymbolA7:
MnSymbolA8:
MnSymbolA9:
[/arrowright/arrowup/arrowleft/arrowdown/arrowupright/arrowupleft
/arrowdownleft/arrowdownright/arrowdblright/arrowdblup/arrowdblleft
/arrowdbldown/uni21D7/uni21D6/uni21D9/uni21D8/arrowboth/arrowupdn/uni2921
/uni2922/arrowdblboth/uni21D5/Neswarrow/Nwsearrow/uni21A0/uni219F/uni219E
/uni21A1/twoheadnearrow/twoheadnwarrow/twoheadswarrow/twoheadsearrow/uni21A3
/uparrowtail/uni21A2/downarrowtail/nearrowtail/nwarrowtail/swarrowtail
/searrowtail/uni21A6/uni21A5/uni21A4/uni21A7/nemapsto/nwmapsto/swmapsto
/semapsto/uni21AA/lhookuparrow/lhookleftarrow/lhookdownarrow/lhooknearrow
/uni2923/lhookswarrow/uni2925/rhookrightarrow/rhookuparrow/uni21A9
/rhookdownarrow/uni2924/rhooknwarrow/uni2926/rhooksearrow/harpoonrightbarbup
/uni21BF/uni21BD/uni21C2/neharpoonup/nwharpoonup/swharpoonup/seharpoonup
/uni21C1/uni21BE/harpoonleftbarbup/uni21C3/neharpoondown/nwharpoondown
/swharpoondown/seharpoondown/uni294B/updownharpoonleftright/neswharpoonnwse
/senwharpoonnesw/uni294A/updownharpoonrightleft/neswharpoonsenw
/nwseharpoonswne/uni21CC/uni296E/neswharpoons/senwharpoons/uni21CB/uni296F
/swneharpoons/nwseharpoons/arrowdashright/arrowdashup/arrowdashleft
/arrowdashdown/dashednearrow/dashednwarrow/dashedswarrow/dashedsearrow
/uni22B8/uni2AEF/uni27DC/uni2AF0/nespoon/nwspoon/swspoon/sespoon
/rightfilledspoon/upfilledspoon/leftfilledspoon/downfilledspoon
/nefilledspoon/nwfilledspoon/swfilledspoon/sefilledspoon/rightfootline
/upfootline/leftfootline/downfootline/nefootline/nwfootline/swfootline
/sefootline/rightfree/upfree/leftfree/uni2ADD/nefree/nwfree/swfree/sefree
/rightpitchfork/uni22D4/leftpitchfork/uni2ADB/nepitchfork/nwpitchfork
/swpitchfork/sepitchfork/uni21C9/uni21C8/uni21C7/uni21CA/nenearrows
/nwnwarrows/swswarrows/sesearrows/arrowrightoverleft/updownarrows/neswarrows
/nwsearrows/uni21C6/downuparrows/swnearrows/senwarrows/uni219D/uplsquigarrow
/leftlsquigarrow/downlsquigarrow/nelsquigarrow/nwlsquigarrow/swlsquigarrow
/selsquigarrow/rightrsquigarrow/uprsquigarrow/uni219C/downrsquigarrow
/nersquigarrow/nwrsquigarrow/swrsquigarrow/sersquigarrow/uni21AD
/squigarrowupdown/squigarrowrightleft/squigarrowdownup/squigarrownesw
/squigarrownwse/squigarrowswne/squigarrowsenw/uni21B7/lcurvearrowup
/lcurvearrowleft/uni2938/lcurvearrowne/lcurvearrownw/lcurvearrowsw
/lcurvearrowse/rcurvearrowright/rcurvearrowup/uni21B6/uni2939/rcurvearrowne
/rcurvearrownw/rcurvearrowsw/rcurvearrowse/curvearrowleftright
/curvearrowupdown/curvearrowrightleft/curvearrowdownup/curvearrownesw
/curvearrownwse/curvearrowswne/curvearrowsenw/leftrightline/divides/neswline
/nwseline/Leftrightline/parallel/Neswline/Nwseline/uni22A2/perpendicular
/uni22A3/uni22A4/nevdash/nwvdash/swvdash/sevdash/uni22A7/upmodels/leftmodels
/downmodels/nemodels/nwmodels/swmodels/semodels/uni22A9/uni234A/leftVdash
/uni2351/neVdash/nwVdash/swVdash/seVdash/uni22AB/upModels/leftModels
/downModels/neModels/nwModels/swModels/seModels/uni293F/uni21BA/uni27F2
/rcirclearrowdown/uni27F3/uni21BB/uni293E/lcirclearrowdown]
FdSymbolC-Bold:
FdSymbolC-Book:
FdSymbolC-Medium:
FdSymbolC-Regular:
MdSymbolC-Bold:
MdSymbolC-Light:
MdSymbolC-Regular:
MdSymbolC-Semibold:
[/arrowright/arrowup/arrowleft/arrowdown/uni2197/uni2196/uni2199/uni2198
/arrowdblright/arrowdblup/arrowdblleft/arrowdbldown/uni21D7/uni21D6/uni21D9
/uni21D8/arrowboth/arrowupdn/uni2921/uni2922/arrowdblboth/uni21D5/sym030
/sym031/uni21A0/uni219F/uni219E/uni21A1/sym033/sym032/sym035/sym034/uni21A3
/sym036/uni21A2/sym037/sym039/sym038/sym03B/sym03A/uni21A6/uni21A5/uni21A4
/uni21A7/uni2907/sym03C/uni2906/sym03D/uni21AA/sym03E/uni21A9.alt/sym03F.alt
/uni2924.alt/uni2923/uni2926.alt/uni2925/uni21AA.alt/sym03E.alt/uni21A9
/sym03F/uni2924/uni2923.alt/uni2926/uni2925.alt/uni21C0/uni21BF/uni21BD
/uni21C2/sym041/sym040/sym043/sym042/uni21C1/uni21BE/uni21BC/uni21C3/sym045
/sym044/sym047/sym046/uni294B/uni294D/sym049/sym048/uni294A/uni294C/sym04B
/sym04A/uni21CC/uni296E/sym04D/sym04C/uni21CB/uni296F/sym04F/sym04E/uni21E2
/uni21E1/uni21E0/uni21E3/sym051/sym050/sym053/sym052/uni22B8/uni2AEF/uni27DC
/uni2AF0/sym054/sym056/sym055/sym057/uni29DF/sym058/uni22B7/uni22B6/sym05A
/uni22D4/sym05B/sym059/uni21C9/uni21C8/uni21C7/uni21CA/sym05D/sym05C/sym05F
/sym05E/uni21C4/uni21C5/sym061/sym060/uni21C6/uni21F5/sym063/sym062/uni219D
/sym064.alt/uni219C.alt/sym065/uni219D.alt/sym064/uni219C/sym065.alt/uni21AD
/sym066.alt/uni21AD.alt/sym066/sym069/sym068/sym067/uni2938/sym06C/sym06B
/uni2936/uni2935/uni293B/sym06A/uni293A/uni2939/uni2934/sym06D/sym06E
/uni2937/sym06F/sym070/sym071/sym072/sym074/sym073/sym076/sym075/sym077
/sym078/sym079/uni21BA/uni27F2/sym07C/uni27F3/uni21BB/sym07A/sym07B/uni21DB
/uni290A/uni21DA/uni290B/uni27F6/uni27F5/uni27F9/uni27F8/uni27F7/uni27FA
/uni27FC/uni27FB/uni27FE/uni27FD/uni27FF/uni2B33/uni27DD/uni27DE/uni21B0
/uni21B1/uni21B2/uni21B3/uni21AC/uni21AB 18{/.notdef}repeat/uni22A2/uni22A5
/uni22A3/uni22A4/uni22A6/uni2AE0/uni2ADE/uni2ADF/uni22A8/uni2AEB/uni2AE4
/uni2AEA/uni22A7/sym07E/sym07D/sym07F/uni22A9/uni234A/uni2AE3/uni2351
/uni22A9.alt/uni2AE8/uni2AE3.alt/uni2AE7/uni22AB/sym080/uni2AE5/sym081
/uni22AA/sym082/uni2AE2/sym083]
MnSymbolE-Bold10:
MnSymbolE-Bold12:
MnSymbolE-Bold5:
MnSymbolE-Bold6:
MnSymbolE-Bold7:
MnSymbolE-Bold8:
MnSymbolE-Bold9:
MnSymbolE10:
MnSymbolE12:
MnSymbolE5:
MnSymbolE6:
MnSymbolE7:
MnSymbolE8:
MnSymbolE9:
[/bracketleft/bracketleft.alt1/bracketleft.alt2/bracketleft.alt3
/bracketleft.alt4/bracketright/bracketright.alt/bracketright.alt2
/bracketright.alt3/bracketright.alt4/uni230A/uni230A.alt1/uni230A.alt2
/uni230A.alt3/uni230A.alt4/uni230B/uni230B.alt1/uni230B.alt2/uni230B.alt3
/uni230B.alt4/uni2308/uni2308.alt1/uni2308.alt2/uni2308.alt3/uni2308.alt4
/uni2309/uni2309.alt1/uni2309.alt2/uni2309.alt3/uni2309.alt4/uni231C.alt1
/uni231C.alt2/uni231C.alt3/uni231C.alt4/uni231C.alt5/uni231D.alt1
/uni231D.alt2/uni231D.alt3/uni231D.alt4/uni231D.alt5/uni231E.alt1
/uni231E.alt2/uni231E.alt3/uni231E.alt4/uni231E.alt5/uni231F.alt1
/uni231F.alt2/uni231F.alt3/uni231F.alt4/uni231F.alt5/ullcorner
/ullcorner.alt1/ullcorner.alt2/ullcorner.alt3/ullcorner.alt4/ulrcorner
/ulrcorner.alt1/ulrcorner.alt2/ulrcorner.alt3/ulrcorner.alt4/uni23A1/uni23A4
/uni23A3/uni23A6/uni23A2/uni23A5/uni27E6/uni27E6.alt1/uni27E6.alt2
/uni27E6.alt3/uni27E6.alt4/uni27E7/uni27E7.alt1/uni27E7.alt2/uni27E7.alt3
/uni27E7.alt4/lsemtop/rsemtop/lsembot/rsembot/lsemmod/rsemmod/arrowvert
/divides.alt0/divides.alt1/divides.alt2/divides.alt3/divides.alt4/Arrowvert
/parallel.alt1/parallel.alt2/parallel.alt3/parallel.alt4/parallel.alt5/wavy
/Wavy/uni27E8/uni27E8.alt/uni27E8.alt2/uni27E8.alt3/uni27E8.alt4/uni27E9
/uni27E9.alt1/uni27E9.alt2/uni27E9.alt3/uni27E9.alt4/anglebar.left
/anglebar.left.alt1/anglebar.left.alt2/anglebar.left.alt3/anglebar.left.alt4
/anglebar.right/anglebar.right.alt1/anglebar.right.alt2/anglebar.right.alt3
/anglebar.right.alt4/uni27EA/uni27EA.alt1/uni27EA.alt2/uni27EA.alt3
/uni27EA.alt4/uni27EB/uni27EB.alt1/uni27EB.alt2/uni27EB.alt3/uni27EB.alt4
/slash.left/slash.left.alt1/slash.left.alt2/slash.left.alt3/slash.left.alt4
/slash.right/slash.right.alt1/slash.right.alt2/slash.right.alt3
/slash.right.alt4/parenleft/parenleft.alt1/parenleft.alt2/parenleft.alt3
/parenleft.alt4/parenright/parenright.alt1/parenright.alt2/parenright.alt3
/parenright.alt4/uni239B/uni239E/uni239D/uni23A0/uni239C/uni239F/braceleft
/braceleft.alt1/braceleft.alt2/braceleft.alt3/braceleft.alt4/braceright
/braceright.alt1/braceright.alt2/braceright.alt3/braceright.alt4/uni23A7
/uni23AB/uni23A9/uni23AD/uni23A8/uni23AC/uni23AA/ucurly/ucurly.alt1
/ucurly.alt2/ucurly.alt3/ucurly.alt4/dcurly/dcurly.alt1/dcurly.alt2
/dcurly.alt3/dcurly.alt4/ucurlyleft/dcurlyleft/ucurlyright/dcurlyright
/ucurlymid/dcurlymid/udcurlymod/radical/radical.alt1/radical.alt2
/radical.alt3/radical.alt4/roottop/rootbot/rootmod/circumflexcmb
/circumflexcmb.alt1/circumflexcmb.alt2/circumflexcmb.alt3/circumflexcmb.alt4
/tildecomb/tildecomb.alt1/tildecomb.alt2/tildecomb.alt3/tildecomb.alt4
/wideparen1/wideparen2/wideparen3/wideparen4/wideparen5/uni20D7/uni0335
/uni0337/uni0338/uparrow/downarrow/arrowmod/uparrowdbl/downarrowdbl
/arrowmoddbl 37{/.notdef}repeat]
xycirc10:
[/c0/c1/c2/c3/c4/c5/c6/c7/c8/c9/c10/c11/c12/c13/c14/c15/c16/c17/c18/c19/c20
/c21/c22/c23/c24/c25/c26/c27/c28/c29/c30/c31/c32/c33/c34/c35/c36/c37/c38/c39
/c40/c41/c42/c43/c44/c45/c46/c47/c48/c49/c50/c51/c52/c53/c54/c55/c56/c57/c58
/c59/c60/c61/c62/c63/c64/c65/c66/c67/c68/c69/c70/c71/c72/c73/c74/c75/c76/c77
/c78/c79/c80/c81/c82/c83/c84/c85/c86/c87/c88/c89/c90/c91/c92/c93/c94/c95/c96
/c97/c98/c99/c100/c101/c102/c103/c104/c105/c106/c107/c108/c109/c110/c111
/c112/c113/c114/c115/c116/c117/c118/c119/c120/c121/c122/c123/c124/c125/c126
/c127 128{/.notdef}repeat]
manfnt:
[/char00/char01/char02/char03/char04/char05/char06/char07/char08/char09
/char0a/char0b/char0c/char0d/char0e/char0f/char10/char11/char12/char13
/char14/char15/char16/char17/.notdef/char19/char1a/char1b/char1c/char1d
/char1e/char1f/char20/char21/char22/char23/char24/char25/char26/char27
/char28/char29/char2a/char2b/char2c/char2d/char2e/char2f/char30/char31
/char32/char33/char34/char35/char36/char37/char38/char39/char3a/char3b
/char3c/char3d/char3e/char3f/.notdef/char41/char42/char43/char44/char45
/char46/char47/char48/char49/char4a/char4b/char4c/char4d/char4e/char4f
/char50/char51/char52/char53/char54/char55/char56/char57/char58/char59
/char5a/char5b/char5c/char5d/char5e/char5f/char60/char61/char62/char63
/char64/char65/char66/char67/char68/char69/char6a/char6b/char6c/char6d
/char6e/char6f/char70/char71/char72/char73/char74/char75/char76/char77
/char78/char79 4{/.notdef}repeat/char7e/char7f 128{/.notdef}repeat]
xnsh14:
xnsh14bf:
[/char00/char01/char02/char03/char04/char05/char06/char07/char08/char09
/char0a/char0b/char0c/char0d/char0e/char0f/char10/char11/char12/char13
/char14/char15/char16/char17/char18/char19/char1a/char1b/char1c/char1d
/char1e/char1f/char20/char21/char22/char23/char24/char25/char26/char27
/char28/char29/char2a/char2b/char2c/char2d/char2e/char2f/char30/char31
/char32/char33/char34/char35/char36/char37/char38/char39/char3a/char3b
/char3c/char3d/char3e/char3f/char40/char41/char42/char43/char44/char45
/char46/char47/char48/char49/char4a/char4b/char4c/char4d/char4e/char4f
/char50/char51/char52/char53/char54/.notdef/char56/char57/char58/char59
/char5a/char5b/char5c/char5d/char5e/char5f 3{/.notdef}repeat/char63/char64
/char65/char66/char67/char68/char69/char6a/char6b/char6c/char6d/char6e
/char6f/char70/char71/char72/char73/char74/char75/char76/char77 8{/.notdef}
repeat/char80/char81/char82/char83/char84/char85/char86/char87 8{/.notdef}
repeat/char90/char91/char92/char93/char94/char95/char96/char97/char98/char99
/char9a/char9b/char9c/char9d/char9e/char9f/chara0/chara1/chara2/chara3
/chara4/chara5/chara6/chara7/chara8/chara9/charaa/charab/charac/charad
/charae/charaf/charb0/charb1/charb2/charb3/charb4/charb5/charb6/charb7
/charb8/charb9/charba/charbb/charbc/charbd/charbe/charbf/charc0/charc1
/charc2/charc3/charc4/charc5/charc6/charc7/charc8/charc9/charca/charcb
/charcc/charcd/charce/charcf/chard0/chard1/chard2/chard3/chard4/chard5
/chard6/chard7/chard8/chard9/.notdef/chardb/chardc/chardd/charde/chardf
/chare0/chare1/chare2/chare3/chare4/chare5/chare6/chare7/chare8/chare9
/charea/chareb/charec/chared/charee/charef/charf0/charf1/.notdef/.notdef
/charf4/charf5/charf6/charf7/charf8/charf9/charfa/charfb/charfc/charfd
/charfe/charff]
xyatip10:
xybsql10:
xybtip10:
xycmat10:
xycmat11:
xycmat12:
xycmbt10:
xycmbt11:
xycmbt12:
xyeuat10:
xyeuat11:
xyeuat12:
xyeubt10:
xyeubt11:
xyeubt12:
xyluat10:
xyluat11:
xyluat12:
xylubt10:
xylubt11:
xylubt12:
[/d0/d1/d2/d3/d4/d5/d6/d7/d8/d9/d10/d11/d12/d13/d14/d15/d16/d17/d18/d19/d20
/d21/d22/d23/d24/d25/d26/d27/d28/d29/d30/d31/d32/d33/d34/d35/d36/d37/d38/d39
/d40/d41/d42/d43/d44/d45/d46/d47/d48/d49/d50/d51/d52/d53/d54/d55/d56/d57/d58
/d59/d60/d61/d62/d63/d64/d65/d66/d67/d68/d69/d70/d71/d72/d73/d74/d75/d76/d77
/d78/d79/d80/d81/d82/d83/d84/d85/d86/d87/d88/d89/d90/d91/d92/d93/d94/d95/d96
/d97/d98/d99/d100/d101/d102/d103/d104/d105/d106/d107/d108/d109/d110/d111
/d112/d113/d114/d115/d116/d117/d118/d119/d120/d121/d122/d123/d124/d125/d126
/d127 128{/.notdef}repeat]
cmntex10:
cmtex10:
cmtex8:
cmtex9:
pltex10:
pltex8:
pltex9:
[/dotmath/arrowdown/alpha/beta/logicaland/logicalnot/element/pi/lambda/gamma
/delta/arrowup/plusminus/circleplus/infinity/partialdiff/propersubset
/propersuperset/intersection/union/universal/existential/circlemultiply
/arrowboth/arrowleft/arrowright/notequal/lozenge/lessequal/greaterequal
/equivalence/logicalor/space/exclam/quotedbl/numbersign/dollar/percent
/ampersand/quoteright/parenleft/parenright/asterisk/plus/comma/minus/period
/slash/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon
/less/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V
/W/X/Y/Z/bracketleft/backslash/bracketright/asciicircum/underscore/quoteleft
/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar
/braceright/asciitilde/integral 128{/.notdef}repeat]
MnSymbolC-Bold10:
MnSymbolC-Bold12:
MnSymbolC-Bold5:
MnSymbolC-Bold6:
MnSymbolC-Bold7:
MnSymbolC-Bold8:
MnSymbolC-Bold9:
MnSymbolC10:
MnSymbolC12:
MnSymbolC5:
MnSymbolC6:
MnSymbolC7:
MnSymbolC8:
MnSymbolC9:
[/dotmath/hdotdot/ratio/udotdot/ddotdot/uni22EF/ellipsisvertical/uni22F0
/uni22F1/righttherefore/therefore/lefttherefore/because/diamonddots
/proportion/fivedots/minus/divides.alt/divisionslash/uni2216/plus/multiply
/plusminus/minusplus/dotminus/dotmedvert/minusdot/medvertdot/divide/slashdiv
/vertdiv/backslashdiv/logicalnot/revlogicalnot/dtimes/uni22CA/utimes/uni22C9
/bowtie/uni29D6/rightY/upY/leftY/downY/logicaland/logicalor/wedgedot/veedot
/uni2A55/uni2A54/curlyand/curlyor/curlywedgedot/curlyveedot/doublecurlywedge
/doublecurlyvee/union/intersection/uni22D3/uni22D2/uni228D/uni2A40/uni228E
/capplus/uni2294/uni2293/uni2A4F/uni2A4E/sqcupdot/sqcapdot/sqcupplus
/sqcapplus/whiterightpointingsmalltriangle/whiteuppointingsmalltriangle
/whiteleftpointingsmalltriangle/whitedownpointingsmalltriangle/uni25B8
/blackuppointingsmalltriangle/uni25C2/uni25BE/whiterightpointingtriangle
/whiteuppointingtriangle/whiteleftpointingtriangle/whitedownpointingtriangle
/whiterightpointingtriangle.alt1/whiteuppointingtriangle.alt1
/whiteleftpointingtriangle.alt1/whitedownpointingtriangle.alt1/circle
/blackcircle/largecircle/largecircle.alt1/minuscircle/uni29B6/uni2298
/uni29B8/circleplus/circlemultiply/circleot/uni229A/otriangle/uni229B
/uni235F/uni2205/uni25FD/uni25FE/uni25FB/uni25FB.alt1/whitediamond
/blackdiamond/whitediamond.alt1/whitediamond.alt2/uni229F/boxvert/uni29C4
/uni29C5/uni229E/uni22A0/uni22A1/uni29C8/diamondminus/diamondvert
/diamondslash/diamondbackslash/diamondplus/diamondtimes/uni27D0
/diamonddiamond/whitestar/blackstar/whitestar.alt1/whitestar.alt2/pentagram
/largepentagram/uni22C6/asteriskmath/hbipropto/neswbipropto/vbipropto
/nwsebipropto/proportional/downpropto/rightpropto/uppropto/hcrossing
/neswcrossing/vcrossing/nwsecrossing/between/separated/bot/uni22BA/uni2240
/angle/uni2221/uni2222/minute/primereversed/product.small/uni2210.small
/checkmark/uni2607/diamondsuitwhite/heartsuitwhite/spade/club/universal
/existential/uni2204/gradient/infinity/integral.small/musicflatsign/uni266E
/musicsharpsign/aleph/uni2136/uni2137/uni2138/weierstrass/weierstrass.alt
/uni2A3C/uni2A3D/uni231E/uni231F/uni231C/uni231D/closedsucc/closedcurlywedge
/closedprec/closedcurlyvee/uni2AA7/upslice/uni2AA6/downslice/lozenge/uni29EB
/lozenge.alt1/uni29EB.alt1/lozenge.alt2/blackrightpointingtriangle
/blackuppointingtriangle/blackleftpointingtriangle/blackdownpointingtriangle
/uni220E/uni2600/uni2721/uni2721.alt/uni2720 11{/.notdef}repeat/closedequal
/equalclosed/equivclosed/uni2272/uni2273/uni2A85/uni2A86/uni2A95/uni2A96
/uni22DE/uni22DF/uni21DB/uni21DA/closedequal_uni0338/equalclosed_uni0338
/equivclosed_uni0338/uni2274/uni2275/uni2A89/uni2A8A/uni2A950338/uni2A960338
/uni22DE0338/uni22DF0338/uni21DB0338/uni21DA0338/uni21B1/uni21B0/uni21AC
/uni21AB/uni22CB/uni22CC/uni22AA/uni2224.short/parallel.short
/notparallel.short]
FdSymbolA-Bold:
FdSymbolA-Book:
FdSymbolA-Medium:
FdSymbolA-Regular:
[/dotmath/sym000/uni2236/sym001/sym002/uni22EF/uni22EE/uni22F0/uni22F1
/sym003/therefore/sym004/uni2235/uni2237/minus/uni2215/uni2216/plus/multiply
/uni2238/uni2A2A/divide/uni2A2B/uni2A2C/uni223A/plusminus/uni2213/uni2214
/uni2A25/uni2A30/uni2A31/uni22C7/logicalnot/revlogicalnot/uni2A3C/uni2A3D
/uni22CB/uni22CC/uni2A32/uni22CA/sym005/uni22C9/uni22C8/uni29D6/sym006
/sym007/sym008/sym009/logicaland/logicalor/uni27D1/uni27C7/uni2A55/uni2A56
/uni22CF/uni22CE/uni22BC/uni22BB/uni2A5E/uni2A63/union/intersection/uni22D3
/uni22D2/uni228D/uni2A40/uni228E/sym00A/uni2294/uni2293/uni2A4F/uni2A4E
/sym00B/sym00C/sym00D/sym00E/uni27D3/uni27D4/uni25B9/uni25B5/uni25C3/uni25BF
/uni25B8/uni25B4/uni25C2/uni25BE/uni25B7/uni25B3/uni25C1/uni25BD/uni25B6
/uni25B2/uni25C0/uni25BC/sym00F/sym010/openbullet/bullet/circle/uni25CF
/uni2296/uni29B6/uni2298/uni29B8/circleplus/circlemultiply/uni2299/uni229A
/uni229B/uni229D/uni229C/emptyset/uni29B0/uni25EF/uni2B24/uni25AB/uni25AA
/uni25A1/uni25A0/uni229F/uni25EB/uni29C4/uni29C5/uni229E/uni22A0/uni22A1
/uni29C8/uni2B1C/uni2B1B/uni22C4/uni2B29/uni25C7/uni25C6/sym011/sym012
/sym013/sym014/sym015/sym016/uni27D0/sym017/uni2B2B/uni2B2A/lozenge/uni29EB
/uni27E0/uni2B52/uni22C6/uni2B50/uni2B51/uni2606/uni2605/asteriskmath
/infinity/proportional/sym018/sym019/uni226C/uni22BA/uni2240/angle/uni29A3
/uni2221/uni299B/uni2222/uni29A1/uni29A0/sym01A/uni221F/uni22BE/uni299C
/uni299D/minute/uni2035/product.small/product.sf.small/uni2A3F/uni2A3F.sf
/integral.small/uni2713/uni21AF/uni2662/diamond/uni2661/heart/spade/club
/uni2720/uni2721/uni2314/universal/existential/uni2204/uni2132/uni2141
/uni2201/uni266D/uni266E/uni266F/aleph/uni2136/uni2137/uni2138/weierstrass 52
{/.notdef}repeat]
MdSymbolA-Bold:
MdSymbolA-Light:
MdSymbolA-Regular:
MdSymbolA-Semibold:
[/dotmath/sym000/uni2236/sym001/sym002/uni22EF/uni22EE/uni22F0/uni22F1
/sym003/therefore/sym004/uni2235/uni2237/minus/uni2215/uni2216/plus/multiply
/uni2238/uni2A2A/divide/uni2A2B/uni2A2C/uni223A/plusminus/uni2213/uni2214
/uni2A25/uni2A30/uni2A31/uni22C7/logicalnot/revlogicalnot/uni2A3C/uni2A3D
/uni22CB/uni22CC/uni2A32/uni22CA/sym005/uni22C9/uni22C8/uni29D6/sym006
/sym007/sym008/sym009/logicaland/logicalor/uni27D1/uni27C7/uni2A55/uni2A56
/uni22CF/uni22CE/uni22BC/uni22BB/uni2A5E/uni2A63/union/intersection/uni22D3
/uni22D2/uni228D/uni2A40/uni228E/sym00A/uni2294/uni2293/uni2A4F/uni2A4E
/sym00B/sym00C/sym00D/sym00E/uni27D3/uni27D4/uni25B9/uni25B5/uni25C3/uni25BF
/uni25B8/uni25B4/uni25C2/uni25BE/uni25B7/uni25B3/uni25C1/uni25BD/uni25B6
/uni25B2/uni25C0/uni25BC/sym00F/sym010/openbullet/bullet/circle/uni25CF
/uni2296/uni29B6/uni2298/uni29B8/circleplus/circlemultiply/uni2299/uni229A
/uni229B/uni229D/uni229C/emptyset/uni29B0/uni25EF/uni2B24/uni25AB/uni25AA
/uni25A1/uni25A0/uni229F/uni25EB/uni29C4/uni29C5/uni229E/uni22A0/uni22A1
/uni29C8/uni2B1C/uni2B1B/uni22C4/uni2B29/uni25C7/uni25C6/sym011/sym012
/sym013/sym014/sym015/sym016/uni27D0/sym017/uni2B2B/uni2B2A/lozenge/uni29EB
/uni27E0/uni2B52/uni22C6/uni2B50/uni2B51/uni2606/uni2605/asteriskmath
/infinity/proportional/sym018/sym019/uni226C/uni22BA/uni2240/angle/uni29A3
/uni2221/uni299B/uni2222/uni29A1/uni29A0/sym01A/uni221F/uni22BE/uni299C
/uni299D/minute/uni2035/product.small/uni2A3F/integral.small/uni2713/uni21AF
/uni2662/diamond/uni2661/heart/spade/club/uni2720/uni2721/uni2314/universal
/existential/uni2204/uni2132/uni2141/uni2201/uni266D/uni266E/uni266F/aleph
/uni2136/uni2137/uni2138/weierstrass/uni2207/sym01B/sym01C 51{/.notdef}
repeat]
etha10:
etha6:
etha7:
etha8:
ethab10:
ethab11:
ethab12:
ethab14:
ethab18:
ethab24:
ethab36:
ethab9:
ethas10:
ethasb10:
ethasb11:
ethasb12:
ethasb14:
ethasb18:
ethasb24:
ethasb36:
ethasb9:
ethatt10:
ethb10:
ethb6:
ethb7:
ethb8:
ethbb10:
ethbb11:
ethbb12:
ethbb14:
ethbb18:
ethbb24:
ethbb36:
ethbb9:
ethbs10:
ethbsb10:
ethbsb11:
ethbsb12:
ethbsb14:
ethbsb18:
ethbsb24:
ethbsb36:
ethbsb9:
ethbtt10:
[/dummya/dotaccent/fi/fl/fraction/hungarumlaut/Lslash/lslash/ogonek/ring
/dummyb/breve/minus/dummyc/Zcaron/zcaron/caron/dotlessi/dotlessj/ff/ffi/ffl
/notequal/infinity/lessequal/greaterequal/partialdiff/summation/product/pi
/grave/quotesingle/space/exclam/quotedbl/numbersign/dollar/percent/ampersand
/quoteright/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon/less
/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y
/Z/bracketleft/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c
/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright
/asciitilde/dummyd/Euro/integral/quotesinglbase/florin/quotedblbase/ellipsis
/dagger/daggerdbl/circumflex/perthousand/Scaron/guilsinglleft/OE/Omega
/radical/approxequal/dummye/dummyf/dummyg/quotedblleft/quotedblright/bullet
/endash/emdash/tilde/trademark/scaron/guilsinglright/oe/Delta/lozenge
/Ydieresis/dummyh/exclamdown/cent/sterling/currency/yen/brokenbar/section
/dieresis/copyright/ordfeminine/guillemotleft/logicalnot/oldhy/registered
/macron/degree/plusminus/twosuperior/threesuperior/acute/mu/paragraph
/periodcentered/cedilla/onesuperior/ordmasculine/guillemotright/onequarter
/onehalf/threequarters/questiondown/Agrave/Aacute/Acircumflex/Atilde
/Adieresis/Aring/AE/Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis/Igrave
/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde
/Odieresis/multiply/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute/Thorn
/germandbls/agrave/aacute/acircumflex/atilde/adieresis/aring/ae/ccedilla
/egrave/eacute/ecircumflex/edieresis/igrave/iacute/icircumflex/idieresis/eth
/ntilde/ograve/oacute/ocircumflex/otilde/odieresis/divide/oslash/ugrave
/uacute/ucircumflex/udieresis/yacute/thorn/ydieresis]
umranda:
[/enc-0/enc-1/enc-2/enc-3/enc-4/enc-5/enc-6/enc-7/enc-8/enc-9/enc-10/enc-11
/enc-12/enc-13/enc-14/enc-15/enc-16/enc-17/enc-18/enc-19/enc-20/enc-21
/enc-22/enc-23/enc-24/enc-25/enc-26/enc-27/enc-28/enc-29/enc-30/enc-31
/enc-32/enc-33/enc-34/enc-35/enc-36/enc-37/enc-38/enc-39/enc-40/enc-41
/enc-42/enc-43/enc-44/enc-45/enc-46/enc-47/enc-48/enc-49/enc-50/enc-51
/enc-52/enc-53/enc-54/enc-55/enc-56/enc-57/enc-58/enc-59/enc-60/enc-61
/enc-62/enc-63/enc-64/enc-65/enc-66/enc-67/enc-68/enc-69/enc-70/enc-71
/enc-72/enc-73/enc-74/enc-75/enc-76/enc-77/enc-78/enc-79/enc-80/enc-81
/enc-82/enc-83/enc-84/enc-85/enc-86/enc-87/enc-88/enc-89/enc-90/enc-91
/enc-92/enc-93/enc-94/enc-95/enc-96/enc-97/enc-98/enc-99/enc-100/enc-101 154
{/.notdef}repeat]
bbding10:
umrandb:
[/enc-0/enc-1/enc-2/enc-3/enc-4/enc-5/enc-6/enc-7/enc-8/enc-9/enc-10/enc-11
/enc-12/enc-13/enc-14/enc-15/enc-16/enc-17/enc-18/enc-19/enc-20/enc-21
/enc-22/enc-23/enc-24/enc-25/enc-26/enc-27/enc-28/enc-29/enc-30/enc-31
/enc-32/enc-33/enc-34/enc-35/enc-36/enc-37/enc-38/enc-39/enc-40/enc-41
/enc-42/enc-43/enc-44/enc-45/enc-46/enc-47/enc-48/enc-49/enc-50/enc-51
/enc-52/enc-53/enc-54/enc-55/enc-56/enc-57/enc-58/enc-59/enc-60/enc-61
/enc-62/enc-63/enc-64/enc-65/enc-66/enc-67/enc-68/enc-69/enc-70/enc-71
/enc-72/enc-73/enc-74/enc-75/enc-76/enc-77/enc-78/enc-79/enc-80/enc-81
/enc-82/enc-83/enc-84/enc-85/enc-86/enc-87/enc-88/enc-89/enc-90/enc-91
/enc-92/enc-93/enc-94/enc-95/enc-96/enc-97/enc-98/enc-99/enc-100/enc-101
/enc-102/enc-103/enc-104/enc-105/enc-106/enc-107/enc-108/enc-109/enc-110
/enc-111/enc-112/enc-113/enc-114/enc-115/enc-116/enc-117/enc-118/enc-119
/enc-120/enc-121/enc-122/enc-123 132{/.notdef}repeat]
grxn1200:
[/endash/uni0020032F/u10144/u10145/u10146/u10147/uni03DB/uni03DB.var/uni1FBE
/uni1FBC/uni1FCC/uni1FFC/uni0391.alt/uni03AB.alt/uni03B1.alt/uni03CB.alt
/uni02CF/uni02CE/uni03DF/uni03D9/uni0020032E/uni03D8/uni03DA.var/uni03E0
/Euro/perthousand/uni0259/uni03E1/quoteleft/quoteright/breve/macron/uni1FC1
/exclam/dieresis/dieresistonos/uni1FED/percent/periodcentered/tonos
/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two
/three/four/five/six/seven/eight/nine/colon/anoteleia/uni1FFE/equal/uni1FBF
/semicolon/uni1FDF/Alpha/Beta/uni1FDD/uni0394/Epsilon/Phi/Gamma/Eta/Iota
/Theta/Kappa/Lambda/Mu/Nu/Omicron/Pi/Chi/Rho/Sigma/Tau/Upsilon/uni1FDE
/uni03A9/Xi/Psi/Zeta/bracketleft/uni1FCF/bracketright/uni1FCE/uni1FCD
/uni1FEF/alpha/beta/sigma1/delta/epsilon/phi/gamma/eta/iota/theta/kappa
/lambda/uni03BC/nu/omicron/pi/chi/rho/sigma/tau/upsilon/.notdef/omega/xi/psi
/zeta/guillemotleft/uni037A/guillemotright/uni1FC0/emdash/uni1F70/uni1F01
/uni1F00/uni1F03/uni1FB2/uni1F81/uni1F80/uni1F83/alphatonos/uni1F05/uni1F04
/uni1F02/uni1FB4/uni1F85/uni1F84/uni1F82/uni1FB6/uni1F07/uni1F06/uni03DD
/uni1FB7/uni1F87/uni1F86/uni0020035D/uni1F74/uni1F21/uni1F20/.notdef/uni1FC2
/uni1F91/uni1F90/.notdef/etatonos/uni1F25/uni1F24/uni1F23/uni1FC4/uni1F95
/uni1F94/uni1F93/uni1FC6/uni1F27/uni1F26/uni1F22/uni1FC7/uni1F97/uni1F96
/uni1F92/uni1F7C/uni1F61/uni1F60/uni1F63/uni1FF2/uni1FA1/uni1FA0/uni1FA3
/omegatonos/uni1F65/uni1F64/uni1F62/uni1FF4/uni1FA5/uni1FA4/uni1FA2/uni1FF6
/uni1F67/uni1F66/uni03DC/uni1FF7/uni1FA7/uni1FA6/.notdef/uni1F76/uni1F31
/uni1F30/uni1F33/uni1F7A/uni1F51/uni1F50/uni1F53/iotatonos/uni1F35/uni1F34
/uni1F32/upsilontonos/uni1F55/uni1F54/uni1F52/uni1FD6/uni1F37/uni1F36
/Iotadieresis/uni1FE6/uni1F57/uni1F56/Upsilondieresis/uni1F72/uni1F11
/uni1F10/uni1F13/uni1F78/uni1F41/uni1F40/uni1F43/epsilontonos/uni1F15
/uni1F14/uni1F12/omicrontonos/uni1F45/uni1F44/uni1F42/iotadieresis/uni1FD2
/iotadieresistonos/uni1FD7/upsilondieresis/uni1FE2/upsilondieresistonos
/uni1FE7/uni1FB3/uni1FC3/uni1FF3/uni1FE5/uni1FE4/.notdef/uni0374/uni0375]
glic0700:
glic0800:
glic1000:
glic1200:
glic1382:
glic1659:
glic1991:
glic2389:
glic2866:
glic3440:
glic4128:
glii0700:
glii0800:
glii1000:
glii1200:
glii1382:
glii1659:
glii1991:
glii2389:
glii2866:
glii3440:
glii4128:
glin0700:
glin0800:
glin1000:
glin1200:
glin1382:
glin1659:
glin1991:
glin2389:
glin2866:
glin3440:
glin4128:
glio0700:
glio0800:
glio1000:
glio1200:
glio1382:
glio1659:
glio1991:
glio2389:
glio2866:
glio3440:
glio4128:
gliu0700:
gliu0800:
gliu1000:
gliu1200:
gliu1382:
gliu1659:
gliu1991:
gliu2389:
gliu2866:
gliu3440:
gliu4128:
gljc0700:
gljc0800:
gljc1000:
gljc1200:
gljc1382:
gljc1659:
gljc1991:
gljc2389:
gljc2866:
gljc3440:
gljc4128:
gljn0700:
gljn0800:
gljn1000:
gljn1200:
gljn1382:
gljn1659:
gljn1991:
gljn2389:
gljn2866:
gljn3440:
gljn4128:
gljo0700:
gljo0800:
gljo1000:
gljo1200:
gljo1382:
gljo1659:
gljo1991:
gljo2389:
gljo2866:
gljo3440:
gljo4128:
glmc0700:
glmc0800:
glmc1000:
glmc1200:
glmc1382:
glmc1659:
glmc1991:
glmc2389:
glmc2866:
glmc3440:
glmc4128:
glmi0700:
glmi0800:
glmi1000:
glmi1200:
glmi1382:
glmi1659:
glmi1991:
glmi2389:
glmi2866:
glmi3440:
glmi4128:
glmn0700:
glmn0800:
glmn1000:
glmn1200:
glmn1382:
glmn1659:
glmn1991:
glmn2389:
glmn2866:
glmn3440:
glmn4128:
glmo0700:
glmo0800:
glmo1000:
glmo1200:
glmo1382:
glmo1659:
glmo1991:
glmo2389:
glmo2866:
glmo3440:
glmo4128:
glmu0700:
glmu0800:
glmu1000:
glmu1200:
glmu1382:
glmu1659:
glmu1991:
glmu2389:
glmu2866:
glmu3440:
glmu4128:
gltc0700:
gltc0800:
gltc1000:
gltc1200:
gltc1382:
gltc1659:
gltc1991:
gltc2389:
gltc2866:
gltc3440:
gltc4128:
gltn0700:
gltn0800:
gltn1000:
gltn1200:
gltn1382:
gltn1659:
gltn1991:
gltn2389:
gltn2866:
gltn3440:
gltn4128:
glto0700:
glto0800:
glto1000:
glto1200:
glto1382:
glto1659:
glto1991:
glto2389:
glto2866:
glto3440:
glto4128:
glwc0700:
glwc0800:
glwc1000:
glwc1200:
glwc1382:
glwc1659:
glwc1991:
glwc2389:
glwc2866:
glwc3440:
glwc4128:
glwi0700:
glwi0800:
glwi1000:
glwi1200:
glwi1382:
glwi1659:
glwi1991:
glwi2389:
glwi2866:
glwi3440:
glwi4128:
glwn0700:
glwn0800:
glwn1000:
glwn1200:
glwn1382:
glwn1659:
glwn1991:
glwn2389:
glwn2866:
glwn3440:
glwn4128:
glwo0700:
glwo0800:
glwo1000:
glwo1200:
glwo1382:
glwo1659:
glwo1991:
glwo2389:
glwo2866:
glwo3440:
glwo4128:
glwu0700:
glwu0800:
glwu1000:
glwu1200:
glwu1382:
glwu1659:
glwu1991:
glwu2389:
glwu2866:
glwu3440:
glwu4128:
glxc0700:
glxc0800:
glxc1000:
glxc1200:
glxc1382:
glxc1659:
glxc1991:
glxc2389:
glxc2866:
glxc3440:
glxc4128:
glxi0700:
glxi0800:
glxi1000:
glxi1200:
glxi1382:
glxi1659:
glxi1991:
glxi2389:
glxi2866:
glxi3440:
glxi4128:
glxn0700:
glxn0800:
glxn1000:
glxn1200:
glxn1382:
glxn1659:
glxn1991:
glxn2389:
glxn2866:
glxn3440:
glxn4128:
glxo0700:
glxo0800:
glxo1000:
glxo1200:
glxo1382:
glxo1659:
glxo1991:
glxo2389:
glxo2866:
glxo3440:
glxo4128:
glxu0700:
glxu0800:
glxu1000:
glxu1200:
glxu1382:
glxu1659:
glxu1991:
glxu2389:
glxu2866:
glxu3440:
glxu4128:
gmmn0500:
gmmn0600:
gmmn0700:
gmmn0800:
gmmn0900:
gmmn1000:
gmmn1095:
gmmn1200:
gmmn1440:
gmmn1728:
gmmn2074:
gmmn2488:
gmmn2986:
gmmn3583:
gmmo0500:
gmmo0600:
gmmo0700:
gmmo0800:
gmmo0900:
gmmo1000:
gmmo1095:
gmmo1200:
gmmo1440:
gmmo1728:
gmmo2074:
gmmo2488:
gmmo2986:
gmmo3583:
gmxn0500:
gmxn0600:
gmxn0700:
gmxn0800:
gmxn0900:
gmxn1000:
gmxn1095:
gmxn1200:
gmxn1440:
gmxn1728:
gmxn2074:
gmxn2488:
gmxn2986:
gmxn3583:
gmxo0500:
gmxo0600:
gmxo0700:
gmxo0800:
gmxo0900:
gmxo1000:
gmxo1095:
gmxo1200:
gmxo1440:
gmxo1728:
gmxo2074:
gmxo2488:
gmxo2986:
gmxo3583:
gomc0500:
gomc0600:
gomc0700:
gomc0800:
gomc0900:
gomc1000:
gomc1095:
gomc1200:
gomc1440:
gomc1728:
gomc2074:
gomc2488:
gomc2986:
gomc3583:
gomi0500:
gomi0600:
gomi0700:
gomi0800:
gomi0900:
gomi1000:
gomi1095:
gomi1200:
gomi1440:
gomi1728:
gomi2074:
gomi2488:
gomi2986:
gomi3583:
gomn0500:
gomn0600:
gomn0700:
gomn0800:
gomn0900:
gomn1000:
gomn1095:
gomn1200:
gomn1440:
gomn1728:
gomn2074:
gomn2488:
gomn2986:
gomn3583:
gomo0500:
gomo0600:
gomo0700:
gomo0800:
gomo0900:
gomo1000:
gomo1095:
gomo1200:
gomo1440:
gomo1728:
gomo2074:
gomo2488:
gomo2986:
gomo3583:
gomu0500:
gomu0600:
gomu0700:
gomu0800:
gomu0900:
gomu1000:
gomu1095:
gomu1200:
gomu1440:
gomu1728:
gomu2074:
gomu2488:
gomu2986:
gomu3583:
goxc0500:
goxc0600:
goxc0700:
goxc0800:
goxc0900:
goxc1000:
goxc1095:
goxc1200:
goxc1440:
goxc1728:
goxc2074:
goxc2488:
goxc2986:
goxc3583:
goxi0500:
goxi0600:
goxi0700:
goxi0800:
goxi0900:
goxi1000:
goxi1095:
goxi1200:
goxi1440:
goxi1728:
goxi2074:
goxi2488:
goxi2986:
goxi3583:
goxn0500:
goxn0600:
goxn0700:
goxn0800:
goxn0900:
goxn1000:
goxn1095:
goxn1200:
goxn1440:
goxn1728:
goxn2074:
goxn2488:
goxn2986:
goxn3583:
goxo0500:
goxo0600:
goxo0700:
goxo0800:
goxo0900:
goxo1000:
goxo1095:
goxo1200:
goxo1440:
goxo1728:
goxo2074:
goxo2488:
goxo2986:
goxo3583:
goxu0500:
goxu0600:
goxu0700:
goxu0800:
goxu0900:
goxu1000:
goxu1095:
goxu1200:
goxu1440:
goxu1728:
goxu2074:
goxu2488:
goxu2986:
goxu3583:
grbl0500:
grbl0600:
grbl0700:
grbl0800:
grbl0900:
grbl1000:
grbl1095:
grbl1200:
grbl1440:
grbl1728:
grbl2074:
grbl2488:
grbl2986:
grbl3583:
grmc0500:
grmc0600:
grmc0700:
grmc0800:
grmc0900:
grmc1000:
grmc1095:
grmc1200:
grmc1440:
grmc1728:
grmc2074:
grmc2488:
grmc2986:
grmc3583:
grmi0500:
grmi0600:
grmi0700:
grmi0800:
grmi0900:
grmi1000:
grmi1095:
grmi1200:
grmi1440:
grmi1728:
grmi2074:
grmi2488:
grmi2986:
grmi3583:
grml0500:
grml0600:
grml0700:
grml0800:
grml0900:
grml1000:
grml1095:
grml1200:
grml1440:
grml1728:
grml2074:
grml2488:
grml2986:
grml3583:
grmn0500:
grmn0600:
grmn0700:
grmn0800:
grmn0900:
grmn1000:
grmn1095:
grmn1200:
grmn1440:
grmn1728:
grmn2074:
grmn2488:
grmn2986:
grmn3583:
grmo0500:
grmo0600:
grmo0700:
grmo0800:
grmo0900:
grmo1000:
grmo1095:
grmo1200:
grmo1440:
grmo1728:
grmo2074:
grmo2488:
grmo2986:
grmo3583:
grmu0500:
grmu0600:
grmu0700:
grmu0800:
grmu0900:
grmu1000:
grmu1095:
grmu1200:
grmu1440:
grmu1728:
grmu2074:
grmu2488:
grmu2986:
grmu3583:
grxc0500:
grxc0600:
grxc0700:
grxc0800:
grxc0900:
grxc1000:
grxc1095:
grxc1200:
grxc1440:
grxc1728:
grxc2074:
grxc2488:
grxc2986:
grxc3583:
grxi0500:
grxi0600:
grxi0700:
grxi0800:
grxi0900:
grxi1000:
grxi1095:
grxi1200:
grxi1440:
grxi1728:
grxi2074:
grxi2488:
grxi2986:
grxi3583:
grxl0500:
grxl0600:
grxl0700:
grxl0800:
grxl0900:
grxl1000:
grxl1095:
grxl1200:
grxl1440:
grxl1728:
grxl2074:
grxl2488:
grxl2986:
grxl3583:
grxn0500:
grxn0600:
grxn0700:
grxn0800:
grxn0900:
grxn1000:
grxn1095:
grxn1440:
grxn1728:
grxn2074:
grxn2488:
grxn2986:
grxn3583:
grxo0500:
grxo0600:
grxo0700:
grxo0800:
grxo0900:
grxo1000:
grxo1095:
grxo1200:
grxo1440:
grxo1728:
grxo2074:
grxo2488:
grxo2986:
grxo3583:
grxu0500:
grxu0600:
grxu0700:
grxu0800:
grxu0900:
grxu1000:
grxu1095:
grxu1200:
grxu1440:
grxu1728:
grxu2074:
grxu2488:
grxu2986:
grxu3583:
gsma0500:
gsma0600:
gsma0700:
gsma0800:
gsma0900:
gsma1000:
gsma1095:
gsma1200:
gsma1440:
gsma1728:
gsma2074:
gsma2488:
gsma2986:
gsma3583:
gsmc0500:
gsmc0600:
gsmc0700:
gsmc0800:
gsmc0900:
gsmc1000:
gsmc1095:
gsmc1200:
gsmc1440:
gsmc1728:
gsmc2074:
gsmc2488:
gsmc2986:
gsmc3583:
gsme0500:
gsme0600:
gsme0700:
gsme0800:
gsme0900:
gsme1000:
gsme1095:
gsme1200:
gsme1440:
gsme1728:
gsme2074:
gsme2488:
gsme2986:
gsme3583:
gsmi0500:
gsmi0600:
gsmi0700:
gsmi0800:
gsmi0900:
gsmi1000:
gsmi1095:
gsmi1200:
gsmi1440:
gsmi1728:
gsmi2074:
gsmi2488:
gsmi2986:
gsmi3583:
gsmn0500:
gsmn0600:
gsmn0700:
gsmn0800:
gsmn0900:
gsmn1000:
gsmn1095:
gsmn1200:
gsmn1440:
gsmn1728:
gsmn2074:
gsmn2488:
gsmn2986:
gsmn3583:
gsmo0500:
gsmo0600:
gsmo0700:
gsmo0800:
gsmo0900:
gsmo1000:
gsmo1095:
gsmo1200:
gsmo1440:
gsmo1728:
gsmo2074:
gsmo2488:
gsmo2986:
gsmo3583:
gsmu0500:
gsmu0600:
gsmu0700:
gsmu0800:
gsmu0900:
gsmu1000:
gsmu1095:
gsmu1200:
gsmu1440:
gsmu1728:
gsmu2074:
gsmu2488:
gsmu2986:
gsmu3583:
gsxa0500:
gsxa0600:
gsxa0700:
gsxa0800:
gsxa0900:
gsxa1000:
gsxa1095:
gsxa1200:
gsxa1440:
gsxa1728:
gsxa2074:
gsxa2488:
gsxa2986:
gsxa3583:
gsxc0500:
gsxc0600:
gsxc0700:
gsxc0800:
gsxc0900:
gsxc1000:
gsxc1095:
gsxc1200:
gsxc1440:
gsxc1728:
gsxc2074:
gsxc2488:
gsxc2986:
gsxc3583:
gsxe0500:
gsxe0600:
gsxe0700:
gsxe0800:
gsxe0900:
gsxe1000:
gsxe1095:
gsxe1200:
gsxe1440:
gsxe1728:
gsxe2074:
gsxe2488:
gsxe2986:
gsxe3583:
gsxi0500:
gsxi0600:
gsxi0700:
gsxi0800:
gsxi0900:
gsxi1000:
gsxi1095:
gsxi1200:
gsxi1440:
gsxi1728:
gsxi2074:
gsxi2488:
gsxi2986:
gsxi3583:
gsxn0500:
gsxn0600:
gsxn0700:
gsxn0800:
gsxn0900:
gsxn1000:
gsxn1095:
gsxn1200:
gsxn1440:
gsxn1728:
gsxn2074:
gsxn2488:
gsxn2986:
gsxn3583:
gsxo0500:
gsxo0600:
gsxo0700:
gsxo0800:
gsxo0900:
gsxo1000:
gsxo1095:
gsxo1200:
gsxo1440:
gsxo1728:
gsxo2074:
gsxo2488:
gsxo2986:
gsxo3583:
gsxu0500:
gsxu0600:
gsxu0700:
gsxu0800:
gsxu0900:
gsxu1000:
gsxu1095:
gsxu1200:
gsxu1440:
gsxu1728:
gsxu2074:
gsxu2488:
gsxu2986:
gsxu3583:
gttc0500:
gttc0600:
gttc0700:
gttc0800:
gttc0900:
gttc1000:
gttc1095:
gttc1200:
gttc1440:
gttc1728:
gttc2074:
gttc2488:
gttc2986:
gttc3583:
gtti0500:
gtti0600:
gtti0700:
gtti0800:
gtti0900:
gtti1000:
gtti1095:
gtti1200:
gtti1440:
gtti1728:
gtti2074:
gtti2488:
gtti2986:
gtti3583:
gttn0500:
gttn0600:
gttn0700:
gttn0800:
gttn0900:
gttn1000:
gttn1095:
gttn1200:
gttn1440:
gttn1728:
gttn2074:
gttn2488:
gttn2986:
gttn3583:
gtto0500:
gtto0600:
gtto0700:
gtto0800:
gtto0900:
gtto1000:
gtto1095:
gtto1200:
gtto1440:
gtto1728:
gtto2074:
gtto2488:
gtto2986:
gtto3583:
gttu0500:
gttu0600:
gttu0700:
gttu0800:
gttu0900:
gttu1000:
gttu1095:
gttu1200:
gttu1440:
gttu1728:
gttu2074:
gttu2488:
gttu2986:
gttu3583:
[/endash/uni0020032F/u10144/u10145/u10146/u10147/uni03DB/uni03DB.var/uni1FBE
/uni1FBC/uni1FCC/uni1FFC/uni0391.alt/uni03AB.alt/uni03B1.alt/uni03CB.alt
/uni02CF/uni02CE/uni03DF/uni03D9/uni0020032E/uni03D8/uni03DA.var/uni03E0
/Euro/perthousand/uni0259/uni03E1/quoteleft/quoteright/breve/macron/uni1FC1
/exclam/dieresis/dieresistonos/uni1FED/percent/periodcentered/tonos
/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two
/three/four/five/six/seven/eight/nine/colon/anoteleia/uni1FFE/equal/uni1FBF
/semicolon/uni1FDF/Alpha/Beta/uni1FDD/uni0394/Epsilon/Phi/Gamma/Eta/Iota
/Theta/Kappa/Lambda/Mu/Nu/Omicron/Pi/Chi/Rho/Sigma/Tau/Upsilon/uni1FDE
/uni03A9/Xi/Psi/Zeta/bracketleft/uni1FCF/bracketright/uni1FCE/uni1FCD
/uni1FEF/alpha/beta/sigma1/delta/epsilon/phi/gamma/eta/iota/theta/kappa
/lambda/uni03BC/nu/omicron/pi/chi/rho/sigma/tau/upsilon/internalchar2/omega
/xi/psi/zeta/guillemotleft/uni037A/guillemotright/uni1FC0/emdash/uni1F70
/uni1F01/uni1F00/uni1F03/uni1FB2/uni1F81/uni1F80/uni1F83/alphatonos/uni1F05
/uni1F04/uni1F02/uni1FB4/uni1F85/uni1F84/uni1F82/uni1FB6/uni1F07/uni1F06
/uni03DD/uni1FB7/uni1F87/uni1F86/uni0020035D/uni1F74/uni1F21/uni1F20/.notdef
/uni1FC2/uni1F91/uni1F90/internalchar1/etatonos/uni1F25/uni1F24/uni1F23
/uni1FC4/uni1F95/uni1F94/uni1F93/uni1FC6/uni1F27/uni1F26/uni1F22/uni1FC7
/uni1F97/uni1F96/uni1F92/uni1F7C/uni1F61/uni1F60/uni1F63/uni1FF2/uni1FA1
/uni1FA0/uni1FA3/omegatonos/uni1F65/uni1F64/uni1F62/uni1FF4/uni1FA5/uni1FA4
/uni1FA2/uni1FF6/uni1F67/uni1F66/uni03DC/uni1FF7/uni1FA7/uni1FA6/.notdef
/uni1F76/uni1F31/uni1F30/uni1F33/uni1F7A/uni1F51/uni1F50/uni1F53/iotatonos
/uni1F35/uni1F34/uni1F32/upsilontonos/uni1F55/uni1F54/uni1F52/uni1FD6
/uni1F37/uni1F36/Iotadieresis/uni1FE6/uni1F57/uni1F56/Upsilondieresis
/uni1F72/uni1F11/uni1F10/uni1F13/uni1F78/uni1F41/uni1F40/uni1F43
/epsilontonos/uni1F15/uni1F14/uni1F12/omicrontonos/uni1F45/uni1F44/uni1F42
/iotadieresis/uni1FD2/iotadieresistonos/uni1FD7/upsilondieresis/uni1FE2
/upsilondieresistonos/uni1FE7/uni1FB3/uni1FC3/uni1FF3/uni1FE5/uni1FE4
/.notdef/uni0374/uni0375]
MnSymbolD-Bold10:
MnSymbolD-Bold12:
MnSymbolD-Bold5:
MnSymbolD-Bold6:
MnSymbolD-Bold7:
MnSymbolD-Bold8:
MnSymbolD-Bold9:
MnSymbolD10:
MnSymbolD12:
MnSymbolD5:
MnSymbolD6:
MnSymbolD7:
MnSymbolD8:
MnSymbolD9:
[/equal/equivalence/similar/uni223D/approxequal/backapprox/uni224B
/backtriplesim/uni2243/uni22CD/uni2242/backeqsim/congruent/uni224C/uni224A
/backapproxeq/uni224F/eqbump/uni224E/uni2250/uni2A66/uni2251/uni2252/uni2253
/uni2323/uni2322/doublesmile/doublefrown/triplesmile/triplefrown/uni224D
/frownsmile/smileeq/frowneq/eqsmile/eqfrown/doublesmileeq/doublefrowneq
/smileeqfrown/frowneqsmile/smilefrowneq/frownsmileeq/sqsmile/sqfrown
/sqdoublesmile/sqdoublefrown/sqtriplesmile/sqtriplefrown/sqsmilefrown
/sqfrownsmile/sqsmileeq/sqfrowneq/sqeqsmile/sqeqfrown/sqdoublesmileeq
/sqdoublefrowneq/sqsmileeqfrown/sqfrowneqsmile/uni2256/uni2257/uni225C
/uni2259/element/suchthat/less/greater/lessequal/greaterequal/uni2A7D
/uni2A7E/uni2266/uni2267/uni2276/uni2277/uni22DA/uni22DB/uni2A8B/uni2A8C
/lesseqgtrslant/gtreqlessslant/uni226A/uni226B/uni22D8/uni22D9/uni22B2
/uni22B3/uni22B4/uni22B5/uni228F/uni2290/uni2291/uni2292/sqsubseteqq
/sqsupseteqq/Sqsubset/Sqsupset/propersubset/propersuperset/reflexsubset
/reflexsuperset/uni2AC5/uni2AC6/uni22D0/uni22D1/uni227A/uni227B/uni2AAF
/uni2AB0/uni227C/uni227D/uni227E/uni227F/uni2AB7/uni2AB8/uni22D6/uni22D7
/leqdot/geqdot/uni2A7F/uni2A80/notequal/uni2262/uni2241/uni223D0338/uni2249
/backapprox_uni0338/uni224B0338/backtriplesim_uni0338/uni2244/uni22CD0338
/uni22420338/backeqsim_uni0338/uni2247/uni224C0338/uni224A0338
/backapproxeq_uni0338/uni224F0338/eqbump_uni0338/uni224E0338/uni22500338
/uni2A660338/uni22510338/uni22520338/uni22530338/uni23230338/uni23220338
/doublesmile_uni0338/doublefrown_uni0338/triplesmile_uni0338
/triplefrown_uni0338/uni226D/frownsmile_uni0338/smileeq_uni0338
/frowneq_uni0338/eqsmile_uni0338/eqfrown_uni0338/doublesmileeq_uni0338
/doublefrowneq_uni0338/smileeqfrown_uni0338/frowneqsmile_uni0338
/smilefrowneq_uni0338/frownsmileeq_uni0338/sqsmile_uni0338/sqfrown_uni0338
/sqdoublesmile_uni0338/sqdoublefrown_uni0338/sqtriplesmile_uni0338
/sqtriplefrown_uni0338/sqsmilefrown_uni0338/sqfrownsmile_uni0338
/sqsmileeq_uni0338/sqfrowneq_uni0338/sqeqsmile_uni0338/sqeqfrown_uni0338
/sqdoublesmileeq_uni0338/sqdoublefrowneq_uni0338/sqsmileeqfrown_uni0338
/sqfrowneqsmile_uni0338/uni22560338/uni22570338/uni225C0338/uni22590338
/notelement/uni220C/uni226E/uni226F/uni2270/uni2271/uni2270.alt1
/uni2271.alt1/uni22660338/uni22670338/uni2278/uni2279/uni22DA0338
/uni22DB0338/uni2A8B0338/uni2A8C0338/lesseqgtrslant_uni0338
/gtreqlessslant_uni0338/uni226A0338/uni226B0338/uni22D80338/uni22D90338
/uni22EA/uni22EB/uni22EC/uni22ED/uni228F0338/uni22900338/uni22E2/uni22E3
/sqsubseteqq_uni0338/sqsupseteqq_uni0338/Sqsubset_uni0338/Sqsupset_uni0338
/notsubset/uni2285/uni2288/uni2289/uni2AC50338/uni2AC60338/uni22D00338
/uni22D10338/uni2280/uni2281/uni2AAF0338/uni2AB00338/uni22E0/uni22E1
/uni227E0338/uni227F0338/uni2AB70338/uni2AB80338/uni22D60338/uni22D70338
/leqdot_uni0338/geqdot_uni0338/uni2A7F0338/uni2A800338/uni2268/uni2269
/lessneqqgtr/gtrneqqless/uni22E4/uni22E5/sqsubsetneqq/sqsupsetneqq/uni228A
/uni228B/uni2ACB/uni2ACC/uni22E8/uni22E9/uni2AB9/uni2ABA]
FdSymbolB-Bold:
FdSymbolB-Book:
FdSymbolB-Medium:
FdSymbolB-Regular:
MdSymbolB-Bold:
MdSymbolB-Light:
MdSymbolB-Regular:
MdSymbolB-Semibold:
[/equal/uni2261/similar/uni223D/approxequal/uni224B/uni2243/uni22CD/uni2242
/congruent/uni224C/uni224A/uni224F/uni2AAE/uni224E/uni2250/uni2A66/uni2251
/uni2252/uni2253/uni2254/uni2255/uni2323/uni2322/uni224D/uni2050/sym020
/uni2258/uni2256/uni2257/uni2259/uni225A/uni225B/uni225C/element/uni220B
/less/greater/lessequal/greaterequal/uni2A7D/uni2A7E/uni2266/uni2267/uni2272
/uni2273/uni2A85/uni2A86/uni2276/uni2277/uni22DA/uni22DB/uni2A8B/uni2A8C
/uni22DA.alt/uni22DB.alt/uni226A/uni226B/uni22D8/uni22D9/uni22B2/uni22B3
/uni22B4/uni22B5/uni2AA6/uni2AA7/uni2AA8/uni2AA9/uni228F/uni2290/uni2291
/uni2292/sym021/sym022/sym023/sym024/propersubset/propersuperset
/reflexsubset/reflexsuperset/uni2AC5/uni2AC6/uni22D0/uni22D1/uni227A/uni227B
/uni2AAF/uni2AB0/uni227C/uni227D/uni2AB3/uni2AB4/uni227E/uni227F/uni2AB7
/uni2AB8/uni22D6/uni22D7/sym025/sym026/uni2A7F/uni2A80/uni2A95/uni2A96
/uni22DE/uni22DF/notequal/uni2262/uni2241/uni223D0338/uni2249/uni224B0338
/uni2244/uni22CD0338/uni22420338/uni2247/uni224C0338/uni224A0338/uni224F0338
/uni2AAE0338/uni224E0338/uni22500338/uni2A660338/uni22510338/uni22520338
/uni22530338/uni23230338/uni23220338/uni226D/uni20500338/sym020_uni0338
/uni22580338/uni22560338/uni22570338/uni22590338/uni225A0338/uni225B0338
/uni225C0338/notelement/uni220C/uni226E/uni226F/uni2270/uni2271/uni2A7D0338
/uni2A7E0338/uni22660338/uni22670338/uni2274/uni2275/uni2A850338/uni2A860338
/uni2278/uni2279/uni22DA0338/uni22DB0338/uni2A8B0338/uni2A8C0338
/uni22DA0338.alt/uni22DB0338.alt/uni226A0338/uni226B0338/uni22D80338
/uni22D90338/uni22EA/uni22EB/uni22EC/uni22ED/uni2AA60338/uni2AA70338
/uni2AA80338/uni2AA90338/uni228F0338/uni22900338/uni22E2/uni22E3
/sym021_uni0338/sym022_uni0338/sym023_uni0338/sym024_uni0338/notsubset
/uni2285/uni2288/uni2289/uni2AC50338/uni2AC60338/uni22D00338/uni22D10338
/uni2280/uni2281/uni2AAF0338/uni2AB00338/uni22E0/uni22E1/uni2AB30338
/uni2AB40338/uni227E0338/uni227F0338/uni2AB70338/uni2AB80338/uni22D60338
/uni22D70338/sym025_uni0338/sym026_uni0338/uni2A7F0338/uni2A800338
/uni2A950338/uni2A960338/uni22DE0338/uni22DF0338/uni2246/sym027/uni2A87
/uni2A88/uni2268/uni2269/uni22E6/uni22E7/uni2A89/uni2A8A/uni22E4/uni22E5
/sym028/sym029/uni228A/uni228B/uni2ACB/uni2ACC/uni2AB1/uni2AB2/uni2AB5
/uni2AB6/uni22E8/uni22E9/uni2AB9/uni2ABA 20{/.notdef}repeat]
feybl10:
feybo10:
feybr10:
feyml10:
feymo10:
feymr10:
[/grave 31{/.notdef}repeat/space 32{/.notdef}repeat/A/B/C 33{/.notdef}repeat
/e 154{/.notdef}repeat]
bicighb:
bicighm:
bicigvb:
bicigvm:
[/grave 31{/.notdef}repeat/space/exclam/quotedbl 4{/.notdef}repeat
/quoteright/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon/less
/equal/greater/question/at/A/B/C/.notdef/E/F/G/.notdef/I/.notdef/K/L/M/N/O/P
/Q/R/S/T/U/V/W/X/Y/Z 5{/.notdef}repeat/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n
/o/p/q/r/s/t/u/v/w/x/y/z/.notdef/bar 8{/.notdef}repeat/Ecaron/Eogonek/Gbreve
/Lacute/Lcaron/.notdef/Nacute/Ncaron/Eng/Ohungarumlaut 4{/.notdef}repeat
/Scedilla/Tcaron/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron
/.notdef/IJ 14{/.notdef}repeat/nacute 3{/.notdef}repeat/racute/rcaron 10{
/.notdef}repeat/zdotaccent 12{/.notdef}repeat/Egrave/.notdef/Ecircumflex
/.notdef/Igrave/.notdef/Icircumflex/Idieresis/Eth/.notdef/Ograve/.notdef
/Ocircumflex/.notdef/Odieresis/OE/Oslash/.notdef/Uacute/.notdef/Udieresis
/.notdef/Thorn/SS/agrave/.notdef/acircumflex/.notdef/adieresis/.notdef/ae
/ccedilla/egrave/.notdef/ecircumflex/.notdef/igrave/.notdef/icircumflex
/idieresis/eth/.notdef/ograve/.notdef/ocircumflex/.notdef/odieresis/oe 7{
/.notdef}repeat/germandbls]
mxsk:
[/grave/acute 62{/.notdef}repeat/at/A 62{/.notdef}repeat/Abreve/Aogonek 62{
/.notdef}repeat/Agrave/Aacute 62{/.notdef}repeat]
mathc10:
[/grave/acute/circumflex/tilde 12{/.notdef}repeat/quotedblleft/quotedblright
/quotedblbase/guillemotleft/guillemotright/endash/emdash/cwm/perthousand
/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/.notdef/exclam/quotedbl/numbersign
/.notdef/.notdef/ampersand/quoteright/parenleft/parenright/asterisk/plus
/comma/hyphen/period/slash/zero/one/two/three/four/five/six/seven/eight/nine
/colon/semicolon/less/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N
/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash/bracketright/asciicircum
/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z
/braceleft/bar/braceright/asciitilde/sfthyphen/.notdef/Aogonek/Cacute/Ccaron
/.notdef/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash/Nacute/Ncaron/Eng
/.notdef/Racute/Rcaron/Sacute/.notdef/Scedilla/.notdef/.notdef/Uhungarumlaut
10{/.notdef}repeat/aogonek/cacute/ccaron/.notdef/ecaron/.notdef/gbreve
/lacute/lcaron/.notdef/nacute/ncaron/.notdef/.notdef/racute/rcaron/sacute
/.notdef/.notdef/tcaron/tcedilla/uhungarumlaut/uring/.notdef/.notdef/zcaron
/.notdef/.notdef/exclamdown/.notdef/sterling/Agrave/Aacute/Acircumflex
/Atilde/Adieresis/Aring/AE/Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis
/Igrave/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex
/Otilde/Odieresis/OE/Oslash/Ugrave/Uacute 5{/.notdef}repeat/agrave/aacute
/acircumflex/atilde/adieresis/aring/ae/ccedilla/egrave/eacute/ecircumflex
/edieresis/igrave/iacute/icircumflex/idieresis/eth/ntilde/ograve/oacute
/ocircumflex/otilde/odieresis/oe/oslash/ugrave/uacute 5{/.notdef}repeat]
knitn_sc_in:
knitn_sc_out:
knitnl:
knitnn:
knitnp:
knitnr:
[/grave/acute/circumflex/tilde/dieresis/.notdef/.notdef/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/compwordmark/perthousandzero/dotlessi/dotlessj/ff/fi/fl/ffi/ffl
/.notdef/exclam/quotedbl/numbersign/.notdef/.notdef/ampersand/quoteright
/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two
/three/four/five/six/seven/eight/nine/colon/semicolon/less/equal/greater
/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft
/.notdef/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k
/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/.notdef
/Abreve/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron
/Lslash/Nacute/Ncaron/Eng/Odblacute/Racute/Rcaron/Sacute/Scaron/Scedilla
/Tcaron/Tcedilla/Udblacute/Uring 102{/.notdef}repeat/thorn/germandbls]
callig15:
[/grave/acute/circumflex/tilde/dieresis/.notdef/ring/.notdef/breve/.notdef
/dotaccent 3{/.notdef}repeat/guilsinglleft/guilsinglright/quotedblleft
/quotedblright/quotedblbase/guillemotleft/guillemotright/.notdef/emdash 5{
/.notdef}repeat/fi/fl 3{/.notdef}repeat/exclam/quotedbl/numbersign/dollar
/percent/ampersand/quoteright/parenleft/parenright/asterisk/.notdef/comma
/hyphen/period/slash/zero/one/two/three/four/five/six/seven/eight/nine/colon
/semicolon 3{/.notdef}repeat/question/.notdef/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O
/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/.notdef/bracketright/asciicircum
/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z
/braceleft/.notdef/braceright/asciitilde/sfthyphen 24{/.notdef}repeat
/Ydieresis 31{/.notdef}repeat/ydieresis 4{/.notdef}repeat/exclamdown
/questiondown/sterling/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE
/Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex
/Idieresis/.notdef/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis/OE
/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis 3{/.notdef}repeat/agrave/aacute
/acircumflex/atilde/adieresis/aring/ae/ccedilla/egrave/eacute/ecircumflex
/edieresis/igrave/iacute/icircumflex/idieresis/.notdef/ntilde/ograve/oacute
/ocircumflex/otilde/odieresis/oe/oslash/ugrave/uacute/ucircumflex/udieresis
/.notdef/.notdef/germandbls]
vnb10:
vnbx10:
vnbx12:
vnbx5:
vnbx6:
vnbx7:
vnbx8:
vnbx9:
vnbxsl10:
vnbxti10:
vncsc10:
vndunh10:
vnff10:
vnfi10:
vnfib8:
vnitt10:
vnr10:
vnr12:
vnr17:
vnr5:
vnr6:
vnr7:
vnr8:
vnr9:
vnsl10:
vnsl12:
vnsl8:
vnsl9:
vnsltt10:
vnss10:
vnss12:
vnss8:
vnss9:
vnssbx10:
vnssdc10:
vnssi10:
vnssi12:
vnssi8:
vnssi9:
vnssq8:
vnssqi8:
vntcsc10:
vnti10:
vnti12:
vnti7:
vnti8:
vnti9:
vntt10:
vntt12:
vntt8:
vntt9:
vnu10:
vnvtt10:
[/grave/acute/circumflex/tilde/dieresis/dotbelow/ring/caron/breve/macron
/dotaccent/cedilla/hookabove/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/.notdef/zeroinferior/dotlessi/uni1EF6/uni1EF7/uni1EF4/uni1EF5/Dcroat
/dcroat/uni2423/exclam/quotedbl/numbersign/dollar/percent/ampersand
/quoteright/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon/less
/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y
/Z/bracketleft/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c
/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright
/asciitilde/sfthyphen/Agrave/Aacute/Atilde/uni1EA2/uni1EA0/Acircumflex
/uni1EA6/uni1EA4/uni1EAA/uni1EA8/uni1EAC/Abreve/uni1EB0/uni1EAE/uni1EB4
/uni1EB2/uni1EB6/Egrave/Eacute/uni1EBC/uni1EBA/uni1EB8/Ecircumflex/uni1EC0
/uni1EBE/uni1EC4/uni1EC2/uni1EC6/Igrave/Iacute/Itilde/uni1EC8/agrave/aacute
/atilde/uni1EA3/uni1EA1/acircumflex/uni1EA7/uni1EA5/uni1EAB/uni1EA9/uni1EAD
/abreve/uni1EB1/uni1EAF/uni1EB5/uni1EB3/uni1EB7/egrave/eacute/uni1EBD
/uni1EBB/uni1EB9/ecircumflex/uni1EC1/uni1EBF/uni1EC5/uni1EC3/uni1EC7/igrave
/iacute/itilde/uni1EC9/uni1ECA/Ograve/Oacute/Otilde/uni1ECE/uni1ECC
/Ocircumflex/uni1ED2/uni1ED0/uni1ED6/uni1ED4/uni1ED8/Ohorn/uni1EDC/uni1EDA
/uni1EE0/uni1EDE/uni1EE2/Ugrave/Uacute/Utilde/uni1EE6/uni1EE4/Uhorn/uni1EEA
/uni1EE8/uni1EEE/uni1EEC/uni1EF0/Ygrave/Yacute/uni1EF8/uni1ECB/ograve/oacute
/otilde/uni1ECF/uni1ECD/ocircumflex/uni1ED3/uni1ED1/uni1ED7/uni1ED5/uni1ED9
/ohorn/uni1EDD/uni1EDB/uni1EE1/uni1EDF/uni1EE3/ugrave/uacute/utilde/uni1EE7
/uni1EE5/uhorn/uni1EEB/uni1EE9/uni1EEF/uni1EED/uni1EF1/ygrave/yacute/uni1EF9
]
vnss17:
vnssi17:
[/grave/acute/circumflex/tilde/dieresis/dotbelow/ring/caron/breve/macron
/dotaccent/cedilla/hookabove/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/zeroinferior/dotlessi/uni1EF6/uni1EF7/uni1EF4/uni1EF5/Dcroat
/dcroat/uni2423/exclam/quotedbl/numbersign/dollar/percent/ampersand
/quoteright/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon/less
/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y
/Z/bracketleft/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c
/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright
/asciitilde/sfthyphen/Agrave/Aacute/Atilde/uni1EA2/uni1EA0/Acircumflex
/uni1EA6/uni1EA4/uni1EAA/uni1EA8/uni1EAC/Abreve/uni1EB0/uni1EAE/uni1EB4
/uni1EB2/uni1EB6/Egrave/Eacute/uni1EBC/uni1EBA/uni1EB8/Ecircumflex/uni1EC0
/uni1EBE/uni1EC4/uni1EC2/uni1EC6/Igrave/Iacute/Itilde/uni1EC8/agrave/aacute
/atilde/uni1EA3/uni1EA1/acircumflex/uni1EA7/uni1EA5/uni1EAB/uni1EA9/uni1EAD
/abreve/uni1EB1/uni1EAF/uni1EB5/uni1EB3/uni1EB7/egrave/eacute/uni1EBD
/uni1EBB/uni1EB9/ecircumflex/uni1EC1/uni1EBF/uni1EC5/uni1EC3/uni1EC7/igrave
/iacute/itilde/uni1EC9/uni1ECA/Ograve/Oacute/Otilde/uni1ECE/uni1ECC
/Ocircumflex/uni1ED2/uni1ED0/uni1ED6/uni1ED4/uni1ED8/Ohorn/uni1EDC/uni1EDA
/uni1EE0/uni1EDE/uni1EE2/Ugrave/Uacute/Utilde/uni1EE6/uni1EE4/Uhorn/uni1EEA
/uni1EE8/uni1EEE/uni1EEC/uni1EF0/Ygrave/Yacute/uni1EF8/uni1ECB/ograve/oacute
/otilde/uni1ECF/uni1ECD/ocircumflex/uni1ED3/uni1ED1/uni1ED7/uni1ED5/uni1ED9
/ohorn/uni1EDD/uni1EDB/uni1EE1/uni1EDF/uni1EE3/ugrave/uacute/utilde/uni1EE7
/uni1EE5/uhorn/uni1EEB/uni1EE9/uni1EEF/uni1EED/uni1EF1/ygrave/yacute/uni1EF9
]
knitg_sc_in:
knitg_sc_out:
knitgg:
knitgn:
knitgp:
knitwg:
knitwn:
knitwp:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring 10{/.notdef}repeat
/quotedblright/quotedblbase/guillemotleft/guillemotright/endash/emdash
/compwordmark/perthousandzero/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/.notdef
/exclam/quotedbl/numbersign/.notdef/.notdef/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/.notdef
/bracketright/.notdef/.notdef/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r
/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/.notdef/Abreve/Aogonek
/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash/Nacute
/Ncaron/Eng/Odblacute/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron/Tcedilla
/Udblacute/Uring/Ydieresis/Zacute/Zcaron/Zdot/IJ/Idot/dmacron/section/abreve
/aogonek/cacute/ccaron/dcaron/ecaron/eogonek/gbreve/lacute/lcaron/lslash
/nacute/ncaron/eng/odblacute/racute/rcaron/sacute/scaron/scedilla/tcaron
/tcedilla/udblacute/uring/ydieresis/zacute/zcaron/zdot/ij/exclamdown
/questiondown/sterling/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE
/Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex
/Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis/OE/Oslash
/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute/Thorn/Germandbls/agrave/aacute
/acircumflex/atilde/adieresis/aring/ae/ccedilla/egrave/eacute/ecircumflex
/edieresis/igrave/iacute/icircumflex/idieresis/eth/ntilde/ograve/oacute
/ocircumflex/otilde/odieresis/oe/oslash/ugrave/uacute/ucircumflex/udieresis
/yacute/thorn/germandbls]
vect10:
vect5:
vect6:
vect7:
vect8:
vect9:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve 7{
/.notdef}repeat/quotedblleft/quotedblright/quotedblbase/guillemotleft
/guillemotright/endash/emdash/cwm/perthousand 7{/.notdef}repeat/space/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash 208{/.notdef}repeat]
hcaption:
hclassic:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
23{/.notdef}repeat/exclam 10{/.notdef}repeat/comma/hyphen/period 11{/.notdef
}repeat/colon 64{/.notdef}repeat/braceleft/bar 3{/.notdef}repeat/Abreve
/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash
/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron
/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron 101{/.notdef}repeat]
tipx10:
tipx12:
tipx17:
tipx8:
tipx9:
tipxb10:
tipxbs10:
tipxbx10:
tipxbx12:
tipxbx8:
tipxbx9:
tipxsb10:
tipxsi10:
tipxsl10:
tipxsl12:
tipxsl8:
tipxsl9:
tipxss10:
tipxss12:
tipxss17:
tipxss8:
tipxss9:
tipxts10:
tipxtt10:
tipxtt12:
tipxtt8:
tipxtt9:
xipx10:
xipxb10:
xipxbs10:
xipxsb10:
xipxsi10:
xipxsl10:
xipxss10:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent 21{/.notdef}repeat/visiblespace/exclam/quotedbl/numbersign/dollar
/percent/ampersand/quoteright/parenleft/parenright/asterisk/plus/comma
/hyphen/period/slash/zero/one/two/three/four/five/six/seven/eight/nine/colon
/semicolon/less/equal/greater/question/at/A/B/C/D/E/F/G/H/I 6{/.notdef}
repeat/P/Q/R/S/T/U/V 25{/.notdef}repeat/p/q/r/s/t/u/v/w/x/y/z/braceleft 132{
/.notdef}repeat]
xuc10:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/.notdef/ogonek/quotesinglbase/guilsinglleft/.notdef/quotedblleft
/quotedblright/quotedblbase/guillemotleft/guillemotright/endash/emdash/cwm
/perthousand/.notdef/dotlessj/.notdef/fi/fl/ffi/.notdef/.notdef/exclam 5{
/.notdef}repeat/quoteright/parenleft/parenright/.notdef/plus/comma/hyphen
/period/slash/zero/one/two/three/four/five/six/seven/eight/nine/colon
/semicolon/.notdef/equal/.notdef/question/.notdef/A/B/C/D/E/.notdef/G/H/I/J
/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/.notdef/Z/bracketleft/backslash/bracketright 3{
/.notdef}repeat/a/b/c/d/e/.notdef/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x
/.notdef/z/braceleft/bar 131{/.notdef}repeat]
ltclb8:
ltcli8:
ltclo8:
ltclq8:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase 4{/.notdef}repeat/quotedblbase
/.notdef/.notdef/endash/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl
/.notdef/ffl/space 3{/.notdef}repeat/dollar/.notdef/.notdef/quoteright
/.notdef/.notdef/asterisk/.notdef/comma/hyphen/period/slash/zero/one/two
/three/four/five/six/seven/eight/nine/.notdef/.notdef/less/equal/greater 14{
/.notdef}repeat/M/.notdef/O 7{/.notdef}repeat/W 3{/.notdef}repeat
/bracketleft/.notdef/bracketright/asciicircum/underscore/quoteleft/.notdef/b
/c/d 7{/.notdef}repeat/l/m/n 15{/.notdef}repeat/asciitilde/sfthyphen/Abreve
/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash
/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron
/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdotaccent/IJ
/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron/dcaron/ecaron
/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut/racute
/rcaron/sacute/scaron/scedilla/tcaron/tcedilla/uhungarumlaut/uring/ydieresis
/zacute/zcaron/zdotaccent/ij/exclamdown/questiondown/sterling 22{/.notdef}
repeat/Odieresis 31{/.notdef}repeat/odieresis 9{/.notdef}repeat]
mxedc10:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/.notdef/.notdef
/quotedblright 4{/.notdef}repeat/emdash 10{/.notdef}repeat/exclam 5{/.notdef
}repeat/quoteright/parenleft/parenright/.notdef/plus/comma/hyphen/period
/slash/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon
/.notdef/equal/.notdef/question 27{/.notdef}repeat/bracketleft/backslash
/bracketright/asciicircum/.notdef/.notdef/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q
/r/s/t/u/v/w/x/y/z/braceleft/bar/.notdef/.notdef/sfthyphen 128{/.notdef}
repeat]
mxed10:
mxedbf10:
mxedi10:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/.notdef/quotedblleft
/quotedblright 4{/.notdef}repeat/emdash 10{/.notdef}repeat/exclam 5{/.notdef
}repeat/quoteright/parenleft/parenright/.notdef/plus/comma/hyphen/period
/slash/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon
/.notdef/equal/.notdef/question 27{/.notdef}repeat/bracketleft/backslash
/bracketright/asciicircum/.notdef/.notdef/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q
/r/s/t/u/v/w/x/y/z/braceleft/bar/.notdef/.notdef/sfthyphen 128{/.notdef}
repeat]
mathastrotest10:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/.notdef/quotedblleft
/quotedblright/quotedblbase/guillemotleft/guillemotright/endash/emdash/cwm
/perthousand/.notdef/dotlessj/ff 4{/.notdef}repeat/visualspace/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/.notdef/zero/one/two/three
/four/five/six/seven/eight/.notdef/colon/semicolon 4{/.notdef}repeat/at/A/B
/C/D/E/F/G/H/I/J/K/L/M/N/.notdef/P/Q/R/S/T/U/V/W/X/.notdef/Z/bracketleft 4{
/.notdef}repeat/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/.notdef/p/q/r/s/t/u/v
/w/x/.notdef/z/braceleft 4{/.notdef}repeat/Abreve/Aogonek/Cacute/Ccaron
/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash/Nacute/Ncaron/Eng
/Ohungarumlaut/.notdef/Rcaron/Sacute/Scaron/Scedilla/Tcaron/Tcedilla
/Uhungarumlaut/Uring/Ydieresis/.notdef/Zcaron/Zdotaccent 4{/.notdef}repeat
/abreve/aogonek/cacute/ccaron/dcaron/ecaron/eogonek/gbreve/lacute/lcaron
/lslash/nacute/ncaron/eng/ohungarumlaut/.notdef/rcaron/sacute/scaron
/scedilla/tcaron/tcedilla/uhungarumlaut/uring/ydieresis/.notdef/zcaron
/zdotaccent 4{/.notdef}repeat/Agrave/Aacute/Acircumflex/Atilde/Adieresis
/Aring/AE/Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute
/Icircumflex/.notdef/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis
/OE/Oslash/.notdef/Uacute/Ucircumflex 4{/.notdef}repeat/agrave/aacute
/acircumflex/atilde/adieresis/aring/ae/ccedilla/egrave/eacute/ecircumflex
/edieresis/igrave/iacute/icircumflex/.notdef/eth/ntilde/ograve/oacute
/ocircumflex/otilde/odieresis/oe/oslash/.notdef/uacute/ucircumflex 4{
/.notdef}repeat]
cmllbx10:
cmllbx12:
cmllbx5:
cmllbx6:
cmllbx7:
cmllbx8:
cmllbx9:
cmllr10:
cmllr12:
cmllr17:
cmllr5:
cmllr6:
cmllr7:
cmllr8:
cmllr9:
cmllss10:
cmllss12:
cmllss17:
cmllss8:
cmllss9:
cmllssbx10:
eullbx10:
eullbx5:
eullbx6:
eullbx7:
eullbx8:
eullbx9:
eullr10:
eullr5:
eullr6:
eullr7:
eullr8:
eullr9:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase 237{/.notdef}repeat]
xgreg11:
xgreg13:
xgreg16:
xgreg20:
xgreg24:
xgreg29:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase 79{/.notdef}repeat/b 19{/.notdef}
repeat/v/w/x/y/z/.notdef/.notdef/braceright/asciitilde 129{/.notdef}repeat]
ebbx10:
ebmo10:
ebmo17:
ebmo8:
ebmo9:
ebmr10:
ebmr17:
ebmr8:
ebmr9:
ebso10:
ebso17:
ebso8:
ebso9:
ebsr10:
ebsr17:
ebsr8:
ebsr9:
ebtl10:
ebto10:
ecbi0500:
ecbi0600:
ecbi0700:
ecbi0800:
ecbi0900:
ecbi1000:
ecbi1095:
ecbi1200:
ecbi1440:
ecbi1728:
ecbi2074:
ecbi2488:
ecbi2986:
ecbi3583:
ecbl0500:
ecbl0600:
ecbl0700:
ecbl0800:
ecbl0900:
ecbl1000:
ecbl1095:
ecbl1200:
ecbl1440:
ecbl1728:
ecbl2074:
ecbl2488:
ecbl2986:
ecbl3583:
ecbx0500:
ecbx0600:
ecbx0700:
ecbx0800:
ecbx0900:
ecbx1000:
ecbx1095:
ecbx1200:
ecbx1440:
ecbx1728:
ecbx2074:
ecbx2488:
ecbx2986:
ecbx3583:
eccc0500:
eccc0600:
eccc0700:
eccc0800:
eccc0900:
eccc1000:
eccc1095:
eccc1200:
eccc1440:
eccc1728:
eccc2074:
eccc2488:
eccc2986:
eccc3583:
ecci0500:
ecci0600:
ecci0700:
ecci0800:
ecci0900:
ecci1000:
ecci1095:
ecci1200:
ecci1440:
ecci1728:
ecci2074:
ecci2488:
ecci2986:
ecci3583:
ecdh0500:
ecdh0600:
ecdh0700:
ecdh0800:
ecdh0900:
ecdh1000:
ecdh1095:
ecdh1200:
ecdh1440:
ecdh1728:
ecdh2074:
ecdh2488:
ecdh2986:
ecdh3583:
ecit0800:
ecit0900:
ecit1000:
ecit1095:
ecit1200:
ecit1440:
ecit1728:
ecit2074:
ecit2488:
ecit2986:
ecit3583:
eclb8:
ecli8:
eclo8:
eclq8:
ecltt8:
ecoc0500:
ecoc0600:
ecoc0700:
ecoc0800:
ecoc0900:
ecoc1000:
ecoc1095:
ecoc1200:
ecoc1440:
ecoc1728:
ecoc2074:
ecoc2488:
ecoc2986:
ecoc3583:
ecrb0500:
ecrb0600:
ecrb0700:
ecrb0800:
ecrb0900:
ecrb1000:
ecrb1095:
ecrb1200:
ecrb1440:
ecrb1728:
ecrb2074:
ecrb2488:
ecrb2986:
ecrb3583:
ecrm0500:
ecrm0600:
ecrm0700:
ecrm0800:
ecrm0900:
ecrm1000:
ecrm1095:
ecrm1200:
ecrm1440:
ecrm1728:
ecrm2074:
ecrm2488:
ecrm2986:
ecrm3583:
ecsc0500:
ecsc0600:
ecsc0700:
ecsc0800:
ecsc0900:
ecsc1000:
ecsc1095:
ecsc1200:
ecsc1440:
ecsc1728:
ecsc2074:
ecsc2488:
ecsc2986:
ecsc3583:
ecsi0500:
ecsi0600:
ecsi0700:
ecsi0800:
ecsi0900:
ecsi1000:
ecsi1095:
ecsi1200:
ecsi1440:
ecsi1728:
ecsi2074:
ecsi2488:
ecsi2986:
ecsi3583:
ecsl0500:
ecsl0600:
ecsl0700:
ecsl0800:
ecsl0900:
ecsl1000:
ecsl1095:
ecsl1200:
ecsl1440:
ecsl1728:
ecsl2074:
ecsl2488:
ecsl2986:
ecsl3583:
ecso0500:
ecso0600:
ecso0700:
ecso0800:
ecso0900:
ecso1000:
ecso1095:
ecso1200:
ecso1440:
ecso1728:
ecso2074:
ecso2488:
ecso2986:
ecso3583:
ecss0500:
ecss0600:
ecss0700:
ecss0800:
ecss0900:
ecss1000:
ecss1095:
ecss1200:
ecss1440:
ecss1728:
ecss2074:
ecss2488:
ecss2986:
ecss3583:
ecst0800:
ecst0900:
ecst1000:
ecst1095:
ecst1200:
ecst1440:
ecst1728:
ecst2074:
ecst2488:
ecst2986:
ecst3583:
ecsx0500:
ecsx0600:
ecsx0700:
ecsx0800:
ecsx0900:
ecsx1000:
ecsx1095:
ecsx1200:
ecsx1440:
ecsx1728:
ecsx2074:
ecsx2488:
ecsx2986:
ecsx3583:
ectc0800:
ectc0900:
ectc1000:
ectc1095:
ectc1200:
ectc1440:
ectc1728:
ectc2074:
ectc2488:
ectc2986:
ectc3583:
ecti0500:
ecti0600:
ecti0700:
ecti0800:
ecti0900:
ecti1000:
ecti1095:
ecti1200:
ecti1440:
ecti1728:
ecti2074:
ecti2488:
ecti2986:
ecti3583:
ectt0800:
ectt0900:
ectt1000:
ectt1095:
ectt1200:
ectt1440:
ectt1728:
ectt2074:
ectt2488:
ectt2986:
ectt3583:
ecui0500:
ecui0600:
ecui0700:
ecui0800:
ecui0900:
ecui1000:
ecui1095:
ecui1200:
ecui1440:
ecui1728:
ecui2074:
ecui2488:
ecui2986:
ecui3583:
ecvi0800:
ecvi0900:
ecvi1000:
ecvi1095:
ecvi1200:
ecvi1440:
ecvi1728:
ecvi2074:
ecvi2488:
ecvi2986:
ecvi3583:
ecvt0800:
ecvt0900:
ecvt1000:
ecvt1095:
ecvt1200:
ecvt1440:
ecvt1728:
ecvt2074:
ecvt2488:
ecvt2986:
ecvt3583:
ecxc0500:
ecxc0600:
ecxc0700:
ecxc0800:
ecxc0900:
ecxc1000:
ecxc1095:
ecxc1200:
ecxc1440:
ecxc1728:
ecxc2074:
ecxc2488:
ecxc2986:
ecxc3583:
eocc10:
eorm10:
eorm5:
eorm6:
eorm7:
eorm8:
eorm9:
eosl10:
eosl5:
eosl6:
eosl7:
eosl8:
eosl9:
eoti10:
ieclb8:
iecli8:
ieclo8:
ieclq8:
iecltt8:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/afii61664/perthousandzero/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/uni2423
/exclam/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o
/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/hyphen.alt/Abreve
/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash
/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron
/Tcommaaccent/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdotaccent/IJ
/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron/dcaron/ecaron
/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut/racute
/rcaron/sacute/scaron/scedilla/tcaron/tcommaaccent/uhungarumlaut/uring
/ydieresis/zacute/zcaron/zdotaccent/ij/exclamdown/questiondown/sterling
/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla/Egrave/Eacute
/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve
/Oacute/Ocircumflex/Otilde/Odieresis/OE/Oslash/Ugrave/Uacute/Ucircumflex
/Udieresis/Yacute/Thorn/SS/agrave/aacute/acircumflex/atilde/adieresis/aring
/ae/ccedilla/egrave/eacute/ecircumflex/edieresis/igrave/iacute/icircumflex
/idieresis/eth/ntilde/ograve/oacute/ocircumflex/otilde/odieresis/oe/oslash
/ugrave/uacute/ucircumflex/udieresis/yacute/thorn/germandbls]
mathb10:
mathb12:
mathb5:
mathb6:
mathb7:
mathb8:
mathb9:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/.notdef/.notdef
/visualspace/exclam/quotedbl/numbersign/dollar/percent/ampersand/quoteright
/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two
/three/four/five/six/seven/eight/nine/colon/semicolon/less/equal/greater
/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/.notdef/T/.notdef/V/W/X/Y/Z
/bracketleft/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c/d
/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright
/asciitilde/sfthyphen/Abreve/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek
/Gbreve/Lacute/Lcaron/Lslash/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron
/Sacute/Scaron/Scedilla/Tcaron/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute
/Zcaron/Zdotaccent/IJ/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron
/dcaron/ecaron/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng
/ohungarumlaut/racute/rcaron/sacute/scaron/scedilla/tcaron/tcedilla
/uhungarumlaut/uring/ydieresis/zacute/zcaron/zdotaccent/ij/exclamdown
/questiondown/sterling/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE
/Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex
/Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis/OE/Oslash
/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute/Thorn/SS/agrave/aacute
/acircumflex/atilde/adieresis/aring/.notdef/.notdef/egrave/eacute
/ecircumflex/edieresis/igrave/iacute/icircumflex/idieresis/eth/ntilde/ograve
/oacute/ocircumflex/otilde/odieresis/oe/oslash/ugrave/uacute/.notdef
/udieresis/yacute/thorn/germandbls]
frcbx10:
frcbx14:
frcbx6:
frcc10:
frcc14:
frcc6:
frcf10:
frcf14:
frcf6:
frcr10:
frcr14:
frcr6:
frcsl10:
frcsl14:
frcsl6:
frcslbx10:
frcslbx14:
frcslbx6:
frcslc10:
frcslc14:
frcslc6:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/.notdef/exclam
/quotedbl 3{/.notdef}repeat/ampersand/quoteright/parenleft/parenright
/.notdef/.notdef/comma/hyphen/period/slash/zero/one/two/three/four/five/six
/seven/eight/nine/colon/semicolon/less/.notdef/greater/question/.notdef/A/B
/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/.notdef/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p
/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/.notdef/Abreve
/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash
/Nacute/Ncaron/.notdef/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla
/Tcaron/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdotaccent
/.notdef/Idotaccent/.notdef/.notdef/abreve/aogonek/cacute/ccaron/dcaron
/ecaron/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/.notdef
/ohungarumlaut/racute/rcaron/sacute/scaron/scedilla/tcaron/tcedilla
/uhungarumlaut/uring/ydieresis/zacute/zcaron/zdotaccent/.notdef/exclamdown
/questiondown/.notdef/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring
/.notdef/Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute
/Icircumflex/Idieresis/.notdef/Ntilde/Ograve/Oacute/Ocircumflex/Otilde
/Odieresis/.notdef/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute/.notdef
/.notdef/agrave/aacute/acircumflex/atilde/adieresis/aring/.notdef/ccedilla
/egrave/eacute/ecircumflex/edieresis/igrave/iacute/icircumflex/idieresis
/.notdef/ntilde/ograve/oacute/ocircumflex/otilde/odieresis/oe/oslash/ugrave
/uacute/ucircumflex/udieresis/yacute/.notdef/.notdef]
ygoth:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/.notdef/exclam
/quotedbl/numbersign/dollar/.notdef/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question
/.notdef/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft
/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j
/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar 131{/.notdef}repeat]
ssmsbm10:
ssmsbm5:
ssmsbm6:
ssmsbm7:
ssmsbm8:
ssmsbm9:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/space/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/.notdef/quoteleft/a 4{/.notdef}repeat/f/g/h/i/j/k
/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/sfthyphen
128{/.notdef}repeat]
xslhz20:
xslhz20d:
xtie20:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/space/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c 28{/.notdef}repeat
/Abreve/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron
/Lslash/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla
/Tcaron/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdotaccent/IJ
/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron/dcaron/ecaron
/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut/racute
/rcaron/sacute/scaron/scedilla/tcaron/tcedilla/uhungarumlaut/uring/ydieresis
/zacute/zcaron/zdotaccent/ij/exclamdown/questiondown/sterling/Agrave/Aacute
/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla/Egrave/Eacute/Ecircumflex
/Edieresis/Igrave/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve/Oacute
/Ocircumflex/Otilde/Odieresis/OE/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis
/Yacute/Thorn/SS/agrave/aacute/acircumflex/atilde 28{/.notdef}repeat]
xslz20:
xslz20d:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/space/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k 148{
/.notdef}repeat]
musix24:
musix29:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/space/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o
/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/.notdef/Abreve
/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash
/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron
/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdotaccent/IJ
/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron/dcaron/ecaron
/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut/racute
/rcaron/sacute/scaron/scedilla/tcaron/tcedilla/uhungarumlaut/uring/ydieresis
/zacute/zcaron/zdotaccent 4{/.notdef}repeat/Agrave/Aacute/Acircumflex/Atilde
/Adieresis/Aring/AE/Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis/Igrave
/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde
/Odieresis/OE/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute/Thorn/SS
/agrave/aacute/acircumflex/atilde/adieresis/aring/ae/ccedilla/egrave/eacute
/ecircumflex/edieresis/igrave/iacute/icircumflex/idieresis/eth/ntilde/ograve
/oacute/ocircumflex/otilde/odieresis/oe/oslash/ugrave/uacute/ucircumflex 4{
/.notdef}repeat]
cmssex10:
cmssex7:
cmssex8:
cmssex9:
cmssmi10:
cmssmi5:
cmssmi6:
cmssmi7:
cmssmi8:
cmssmi9:
cmssmib10:
cmssmib5:
cmssmib6:
cmssmib7:
cmssmib8:
cmssmib9:
lcmbsy8:
lcmex8:
lcmmi8:
lcmmib8:
lcmsy8:
llcmss8:
llcmssb8:
llcmssi8:
llcmsso8:
ssmsam10:
ssmsam5:
ssmsam6:
ssmsam7:
ssmsam8:
ssmsam9:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/space/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o
/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/sfthyphen 128{
/.notdef}repeat]
ocrb10:
ocrb5:
ocrb6:
ocrb7:
ocrb8:
ocrb9:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/space/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o
/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/sfthyphen/Abreve
/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron 118{
/.notdef}repeat]
musix11:
musix13:
musix16:
musix20:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/space/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o
/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/sfthyphen/Abreve
/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash
/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron
/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdotaccent/IJ
/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron/dcaron/ecaron
/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut/racute
/rcaron/sacute/scaron/scedilla/tcaron/tcedilla/uhungarumlaut/uring/ydieresis
/zacute/zcaron/zdotaccent 4{/.notdef}repeat/Agrave/Aacute/Acircumflex/Atilde
/Adieresis/Aring/AE/Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis/Igrave
/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde
/Odieresis/OE/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute/Thorn/SS
/agrave/aacute/acircumflex/atilde/adieresis/aring/ae/ccedilla/egrave/eacute
/ecircumflex/edieresis/igrave/iacute/icircumflex/idieresis/eth/ntilde/ograve
/oacute/ocircumflex/otilde/odieresis/oe/oslash/ugrave/uacute/ucircumflex 4{
/.notdef}repeat]
musixsps:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/space/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o
/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/sfthyphen/Abreve
/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash
/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron
/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdotaccent/IJ
/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron/dcaron/ecaron
/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut/racute
/rcaron/sacute/scaron/scedilla/tcaron/tcedilla/uhungarumlaut/uring/ydieresis
/zacute/zcaron/zdotaccent/ij/exclamdown/questiondown/sterling/Agrave/Aacute
/Acircumflex/Atilde 60{/.notdef}repeat]
bxghsb:
bxghsm:
bxghwb:
bxghwm:
bxgvsb:
bxgvsm:
bxgvwb:
bxgvwm:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/space/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o
/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/sfthyphen/Abreve
/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash
/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron
/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdotaccent/IJ
/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron/dcaron/ecaron
/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut/racute
/rcaron/sacute/scaron/scedilla/tcaron/tcedilla/uhungarumlaut/uring/ydieresis
/zacute/zcaron/zdotaccent/ij/exclamdown/questiondown/sterling/Agrave/Aacute
/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla/Egrave/Eacute/Ecircumflex
/Edieresis/Igrave/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve/Oacute
/Ocircumflex/Otilde/Odieresis/OE/Oslash/Ugrave/Uacute/Ucircumflex 35{
/.notdef}repeat/germandbls]
musixspx:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/space/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o
/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/sfthyphen/Abreve
/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash
/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron
/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdotaccent/IJ
/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron/dcaron/ecaron
/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut/racute
/rcaron/sacute/scaron/scedilla/tcaron/tcedilla/uhungarumlaut/uring/ydieresis
/zacute/zcaron/zdotaccent/ij/exclamdown/questiondown/sterling/Agrave/Aacute
/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla/Egrave/Eacute/Ecircumflex
/Edieresis/Igrave/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve/Oacute
/Ocircumflex/Otilde/Odieresis/OE/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis
/Yacute/Thorn/SS/agrave/aacute/acircumflex/atilde/adieresis/aring/ae
/ccedilla/egrave/eacute/ecircumflex/edieresis/igrave/iacute/icircumflex
/idieresis/eth/ntilde/ograve/oacute 12{/.notdef}repeat]
eczi0500:
eczi0600:
eczi0700:
eczi0800:
eczi0900:
eczi1000:
eczi1095:
eczi1200:
eczi1440:
eczi1728:
eczi2074:
eczi2488:
eczi2986:
eczi3583:
eczo0500:
eczo0600:
eczo0700:
eczo0800:
eczo0900:
eczo1000:
eczo1095:
eczo1200:
eczo1440:
eczo1728:
eczo2074:
eczo2488:
eczo2986:
eczo3583:
eczx0500:
eczx0600:
eczx0700:
eczx0800:
eczx0900:
eczx1000:
eczx1095:
eczx1200:
eczx1440:
eczx1728:
eczx2074:
eczx2488:
eczx2986:
eczx3583:
eczz0500:
eczz0600:
eczz0700:
eczz0800:
eczz0900:
eczz1000:
eczz1095:
eczz1200:
eczz1440:
eczz1728:
eczz2074:
eczz2488:
eczz2986:
eczz3583:
leclb8:
lecli8:
leclo8:
leclq8:
tipa10:
tipa12:
tipa17:
tipa8:
tipa9:
tipab10:
tipabs10:
tipabx10:
tipabx12:
tipabx8:
tipabx9:
tipasb10:
tipasi10:
tipasl10:
tipasl12:
tipasl8:
tipasl9:
tipass10:
tipass12:
tipass17:
tipass8:
tipass9:
tipats10:
tipatt10:
tipatt12:
tipatt8:
tipatt9:
xipa10:
xipab10:
xipabs10:
xipasb10:
xipasi10:
xipasl10:
xipass10:
xsld11:
xsld11d:
xsld13:
xsld13d:
xsld16:
xsld16d:
xsld20:
xsld20d:
xsld24:
xsld24d:
xsld29:
xsld29d:
xsldd20:
xsldu20:
xslhd11:
xslhd11d:
xslhd13:
xslhd13d:
xslhd16:
xslhd16d:
xslhd20:
xslhd20d:
xslhd24:
xslhd24d:
xslhd29:
xslhd29d:
xslhu11:
xslhu11d:
xslhu13:
xslhu13d:
xslhu16:
xslhu16d:
xslhu20:
xslhu20d:
xslhu24:
xslhu24d:
xslhu29:
xslhu29d:
xslu11:
xslu11d:
xslu13:
xslu13d:
xslu16:
xslu16d:
xslu20:
xslu20d:
xslu24:
xslu24d:
xslu29:
xslu29d:
xslud20:
xslup20:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/space/exclam
/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o
/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/sfthyphen/Abreve
/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash
/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron
/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdotaccent/IJ
/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron/dcaron/ecaron
/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut/racute
/rcaron/sacute/scaron/scedilla/tcaron/tcedilla/uhungarumlaut/uring/ydieresis
/zacute/zcaron/zdotaccent/ij/exclamdown/questiondown/sterling/Agrave/Aacute
/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla/Egrave/Eacute/Ecircumflex
/Edieresis/Igrave/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve/Oacute
/Ocircumflex/Otilde/Odieresis/OE/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis
/Yacute/Thorn/SS/agrave/aacute/acircumflex/atilde/adieresis/aring/ae
/ccedilla/egrave/eacute/ecircumflex/edieresis/igrave/iacute/icircumflex
/idieresis/eth/ntilde/ograve/oacute/ocircumflex/otilde/odieresis/oe/oslash
/ugrave/uacute/ucircumflex/udieresis/yacute/thorn/germandbls]
matha10:
matha12:
matha5:
matha6:
matha7:
matha8:
matha9:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/visualspace
/exclam/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o
/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/sfthyphen/Abreve
/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash
/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron
/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdotaccent/IJ
/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron/dcaron/ecaron
/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut/racute
/rcaron/sacute/scaron/scedilla/tcaron/tcedilla/uhungarumlaut/uring/ydieresis
/zacute/zcaron/zdotaccent/ij/exclamdown/questiondown/sterling/Agrave/Aacute
/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla/Egrave/Eacute/Ecircumflex
/Edieresis/Igrave/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve/Oacute
/Ocircumflex/Otilde/Odieresis/OE/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis
/Yacute/Thorn/SS/agrave/aacute/acircumflex/atilde/adieresis/aring/ae
/ccedilla/egrave/eacute/ecircumflex/edieresis 4{/.notdef}repeat/eth/ntilde
/ograve/oacute/ocircumflex/otilde/odieresis/oe/oslash/ugrave/uacute
/ucircumflex 4{/.notdef}repeat]
mathx10:
mathx12:
mathx5:
mathx6:
mathx7:
mathx8:
mathx9:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/cwm/perthousand/dotlessi/dotlessj/ff/fi/fl/ffi/ffl/visualspace
/exclam/quotedbl/numbersign/dollar/percent/ampersand/quoteright/parenleft
/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four
/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A
/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash
/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o
/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/sfthyphen/Abreve
/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute/Lcaron/Lslash
/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron/Scedilla/Tcaron
/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron/Zdotaccent/IJ
/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron/dcaron/ecaron
/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut/racute
/rcaron/sacute/scaron/scedilla/tcaron/tcedilla/uhungarumlaut/uring/ydieresis
/zacute/zcaron/zdotaccent/ij/exclamdown/questiondown/sterling/Agrave/Aacute
/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla/Egrave/Eacute/Ecircumflex
/Edieresis/Igrave/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve/Oacute
/Ocircumflex/Otilde/Odieresis/OE/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis
/Yacute/Thorn/SS/agrave/aacute/acircumflex/atilde/adieresis/aring/ae
/ccedilla/egrave/eacute/ecircumflex/edieresis/igrave/iacute/icircumflex
/idieresis/eth/ntilde/ograve/oacute/ocircumflex/otilde/odieresis/oe/oslash
/ugrave/uacute/ucircumflex/udieresis/yacute/thorn/germandbls]
ffmb10:
ffmb8:
ffmb9:
ffmbc40:
ffmbco40:
ffmbo10:
ffmbo8:
ffmbo9:
ffmbw10:
ffmbwo10:
ffmc10:
ffmco10:
ffmh10:
ffmh8:
ffmh9:
ffmho10:
ffmho8:
ffmho9:
ffmhw10:
ffmhwo10:
ffml10:
ffmlc10:
ffmlco10:
ffmlo10:
ffmlq10:
ffmlqo10:
ffmlw10:
ffmlwo10:
ffmo10:
ffmo8:
ffmo9:
ffmr10:
ffmr8:
ffmr9:
ffmw10:
ffmwo10:
[/grave/acute/circumflex/tilde/dieresis/hungarumlaut/ring/caron/breve/macron
/dotaccent/cedilla/ogonek/quotesinglbase/guilsinglleft/guilsinglright
/quotedblleft/quotedblright/quotedblbase/guillemotleft/guillemotright/endash
/emdash/zerowidthspace/uniE000/dotlessi/dotlessj/ff/fi/fl/ffi/ffl
/visiblespace/exclam/quotedbl/numbersign/dollar/percent/ampersand/quoteright
/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two
/three/four/five/six/seven/eight/nine/colon/semicolon/less/equal/greater
/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft
/backslash/bracketright/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j
/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde
/hyphentwo/Abreve/Aogonek/Cacute/Ccaron/Dcaron/Ecaron/Eogonek/Gbreve/Lacute
/Lcaron/Lslash/Nacute/Ncaron/Eng/Ohungarumlaut/Racute/Rcaron/Sacute/Scaron
/Scedilla/Tcaron/Tcedilla/Uhungarumlaut/Uring/Ydieresis/Zacute/Zcaron
/Zdotaccent/IJ/Idotaccent/dcroat/section/abreve/aogonek/cacute/ccaron/dcaron
/ecaron/eogonek/gbreve/lacute/lcaron/lslash/nacute/ncaron/eng/ohungarumlaut
/racute/rcaron/sacute/scaron/scedilla/tcaron/tcedilla/uhungarumlaut/uring
/ydieresis/zacute/zcaron/zdotaccent/ij/exclamdown/questiondown/sterling
/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla/Egrave/Eacute
/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve
/Oacute/Ocircumflex/Otilde/Odieresis/OE/Oslash/Ugrave/Uacute/Ucircumflex
/Udieresis/Yacute/Thorn/uni1E9E/agrave/aacute/acircumflex/atilde/adieresis
/aring/ae/ccedilla/egrave/eacute/ecircumflex/edieresis/igrave/iacute
/icircumflex/idieresis/eth/ntilde/ograve/oacute/ocircumflex/otilde/odieresis
/oe/oslash/ugrave/uacute/ucircumflex/udieresis/yacute/thorn/germandbls]
cmbrbs10:
cmbrbs8:
cmbrbs9:
lmsbm8:
msbm10:
msbm5:
msbm6:
msbm7:
msbm8:
msbm9:
[/lessornotequal/greaterornotequal/notlessequal/notgreaterequal/notless
/notgreater/notprecedes/notfollows/lessornotdbleql/greaterornotdbleql
/notlessorslnteql/notgreaterorslnteql/lessnotequal/greaternotequal
/notprecedesoreql/notfollowsoreql/precedeornoteqvlnt/followornoteqvlnt
/lessornotsimilar/greaterornotsimilar/notlessdblequal/notgreaterdblequal
/precedenotslnteql/follownotslnteql/precedenotdbleqv/follownotdbleqv
/lessnotdblequal/greaternotdblequal/notsimilar/notapproxequal/upslope
/downslope/notsubsetoreql/notsupersetoreql/notsubsetordbleql
/notsupersetordbleql/subsetornotdbleql/supersetornotdbleql/subsetornoteql
/supersetornoteql/subsetnoteql/supersetnoteql/notsubseteql/notsuperseteql
/notparallel/notbar/notshortbar/notshortparallel/notturnstile/notforces
/notsatisfies/notforcesextra/nottriangeqlright/nottriangeqlleft
/nottriangleleft/nottriangleright/notarrowleft/notarrowright/notdblarrowleft
/notdblarrowright/notdblarrowboth/notarrowboth/dividemultiply/emptyset
/notexistential/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/hatwide
/hatwider/tildewide/tildewider/.notdef/Finv/Gmir 4{/.notdef}repeat/Omegainv
/eth/equalorsimilar/beth/gimel/daleth/lessdot/greaterdot/multicloseleft
/multicloseright/barshort/parallelshort/integerdivide/similar/approxequal
/approxorequal/followsorequal/precedesorequal/archleftdown/archrightdown
/Digamma/kappa/k/planckover2pi/planckover2pi1/epsiloninv 128{/.notdef}repeat
]
cmbrsy10:
cmbrsy8:
cmbrsy9:
cmbsy10:
cmbsy5:
cmbsy6:
cmbsy7:
cmbsy8:
cmbsy9:
cmssbsy10:
cmssbsy5:
cmssbsy6:
cmssbsy7:
cmssbsy8:
cmssbsy9:
cmsssy10:
cmsssy5:
cmsssy6:
cmsssy7:
cmsssy8:
cmsssy9:
cmsy10:
cmsy5:
cmsy6:
cmsy7:
cmsy8:
cmsy9:
cmsytt10:
euxm10:
euxm7:
[/minus/periodcentered/multiply/asteriskmath/divide/diamondmath/plusminus
/minusplus/circleplus/circleminus/circlemultiply/circledivide/circledot
/circlecopyrt/openbullet/bullet/equivasymptotic/equivalence/reflexsubset
/reflexsuperset/lessequal/greaterequal/precedesequal/followsequal/similar
/approxequal/propersubset/propersuperset/lessmuch/greatermuch/precedes
/follows/arrowleft/arrowright/arrowup/arrowdown/arrowboth/arrownortheast
/arrowsoutheast/similarequal/arrowdblleft/arrowdblright/arrowdblup
/arrowdbldown/arrowdblboth/arrownorthwest/arrowsouthwest/proportional/prime
/infinity/element/owner/triangle/triangleinv/negationslash/mapsto/universal
/existential/logicalnot/emptyset/Rfractur/Ifractur/latticetop/perpendicular
/aleph/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/union
/intersection/unionmulti/logicaland/logicalor/turnstileleft/turnstileright
/floorleft/floorright/ceilingleft/ceilingright/braceleft/braceright
/angbracketleft/angbracketright/bar/bardbl/arrowbothv/arrowdblbothv
/backslash/wreathproduct/radical/coproduct/nabla/integral/unionsq
/intersectionsq/subsetsqequal/supersetsqequal/section/dagger/daggerdbl
/paragraph/club/diamond/heart/spade 128{/.notdef}repeat]
plbsy10:
plsy10:
plsy5:
plsy6:
plsy7:
plsy8:
plsy9:
[/minus/periodcentered/multiply/asteriskmath/divide/diamondmath/plusminus
/minusplus/circleplus/circleminus/circlemultiply/circledivide/circledot
/circlecopyrt/openbullet/bullet/equivasymptotic/equivalence/reflexsubset
/reflexsuperset/lessequal/greaterequal/precedesequal/followsequal/similar
/approxequal/propersubset/propersuperset/lessmuch/greatermuch/precedes
/follows/arrowleft/arrowright/arrowup/arrowdown/arrowboth/arrownortheast
/arrowsoutheast/similarequal/arrowdblleft/arrowdblright/arrowdblup
/arrowdbldown/arrowdblboth/arrownorthwest/arrowsouthwest/proportional/prime
/infinity/element/owner/triangle/triangleinv/negationslash/mapsto/universal
/existential/logicalnot/emptyset/Rfractur/Ifractur/latticetop/perpendicular
/aleph/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/union
/intersection/unionmulti/logicaland/logicalor/turnstileleft/turnstileright
/floorleft/floorright/ceilingleft/ceilingright/braceleft/braceright
/angbracketleft/angbracketright/bar/bardbl/arrowbothv/arrowdblbothv
/backslash/wreathproduct/radical/coproduct/nabla/integral/unionsq
/intersectionsq/subsetsqequal/supersetsqequal/section/dagger/daggerdbl
/paragraph/club/diamond/heart/spade 44{/.notdef}repeat/xlessequal
/xgreaterequal 82{/.notdef}repeat]
FdSymbolF-Bold:
FdSymbolF-Book:
FdSymbolF-Medium:
FdSymbolF-Regular:
MdSymbolF-Bold:
MdSymbolF-Light:
MdSymbolF-Regular:
MdSymbolF-Semibold:
[/parenleft/parenleft.big1/parenleft.big2/parenleft.big3/parenleft.big4
/parenleft.big5/parenright/parenright.big1/parenright.big2/parenright.big3
/parenright.big4/parenright.big5/uni239B/uni239E/uni239D/uni23A0/uni239C
/uni239F/bracketleft/bracketleft.big1/bracketleft.big2/bracketleft.big3
/bracketleft.big4/bracketleft.big5/bracketright/bracketright.big1
/bracketright.big2/bracketright.big3/bracketright.big4/bracketright.big5
/uni230A/uni230A.big1/uni230A.big2/uni230A.big3/uni230A.big4/uni230A.big5
/uni230B/uni230B.big1/uni230B.big2/uni230B.big3/uni230B.big4/uni230B.big5
/uni2308/uni2308.big1/uni2308.big2/uni2308.big3/uni2308.big4/uni2308.big5
/uni2309/uni2309.big1/uni2309.big2/uni2309.big3/uni2309.big4/uni2309.big5
/uni231C/uni231C.big1/uni231C.big2/uni231C.big3/uni231C.big4/uni231C.big5
/uni231D/uni231D.big1/uni231D.big2/uni231D.big3/uni231D.big4/uni231D.big5
/uni231E/uni231E.big1/uni231E.big2/uni231E.big3/uni231E.big4/uni231E.big5
/uni231F/uni231F.big1/uni231F.big2/uni231F.big3/uni231F.big4/uni231F.big5
/sym0A0/sym0A0.big1/sym0A0.big2/sym0A0.big3/sym0A0.big4/sym0A0.big5/sym0A1
/sym0A1.big1/sym0A1.big2/sym0A1.big3/sym0A1.big4/sym0A1.big5/uni23A1/uni23A4
/uni23A3/uni23A6/uni23A2/uni23A5/uni27E6/uni27E6.big1/uni27E6.big2
/uni27E6.big3/uni27E6.big4/uni27E6.big5/uni27E7/uni27E7.big1/uni27E7.big2
/uni27E7.big3/uni27E7.big4/uni27E7.big5/sym0A2/sym0A5/sym0A4/sym0A7/sym0A3
/sym0A6/braceleft/braceleft.big1/braceleft.big2/braceleft.big3
/braceleft.big4/braceleft.big5/braceright/braceright.big1/braceright.big2
/braceright.big3/braceright.big4/braceright.big5/uni23A7/uni23AB/uni23A9
/uni23AD/uni23A8/uni23AC/uni23AA/uni27E8/uni27E8.big1/uni27E8.big2
/uni27E8.big3/uni27E8.big4/uni27E8.big5/uni27E9/uni27E9.big1/uni27E9.big2
/uni27E9.big3/uni27E9.big4/uni27E9.big5/uni27EA/uni27EA.big1/uni27EA.big2
/uni27EA.big3/uni27EA.big4/uni27EA.big5/uni27EB/uni27EB.big1/uni27EB.big2
/uni27EB.big3/uni27EB.big4/uni27EB.big5/uni2991/uni2991.big1/uni2991.big2
/uni2991.big3/uni2991.big4/uni2991.big5/uni2992/uni2992.big1/uni2992.big2
/uni2992.big3/uni2992.big4/uni2992.big5/slash/slash.big1/slash.big2
/slash.big3/slash.big4/slash.big5/backslash/backslash.big1/backslash.big2
/backslash.big3/backslash.big4/backslash.big5/uni2223.short/uni2223
/uni2223.big1/uni2224.short/uni2224/uni2224.big1/sym0A8/uni2225.short
/uni2225/uni2225.big1/uni2226.short/uni2226/uni2226.big1/sym0A9/uni2980
/uni2980.big1/sym0AA/arrowup.short/arrowdown.short/sym0AB/arrowdblup.short
/arrowdbldown.short/sym0AC/sym0AD/sym0AF/sym0AE/sym0B0/sym0B2/sym0B3/sym0B1
/radical.tex/radical.tex.big1/radical.tex.big2/radical.tex.big3
/radical.tex.big4/radical.tex.big5/radical.tex.top/uni23B7.tex/radical.ex
/radical/radical.big1/radical.big2/radical.big3/radical.big4/radical.big5
/radical.top/uni23B7 28{/.notdef}repeat]
cmex10:
cmex7:
cmex8:
cmex9:
cmexb10:
plex10:
[/parenleftbig/parenrightbig/bracketleftbig/bracketrightbig/floorleftbig
/floorrightbig/ceilingleftbig/ceilingrightbig/braceleftbig/bracerightbig
/angbracketleftbig/angbracketrightbig/vextendsingle/vextenddouble/slashbig
/backslashbig/parenleftBig/parenrightBig/parenleftbigg/parenrightbigg
/bracketleftbigg/bracketrightbigg/floorleftbigg/floorrightbigg
/ceilingleftbigg/ceilingrightbigg/braceleftbigg/bracerightbigg
/angbracketleftbigg/angbracketrightbigg/slashbigg/backslashbigg
/parenleftBigg/parenrightBigg/bracketleftBigg/bracketrightBigg/floorleftBigg
/floorrightBigg/ceilingleftBigg/ceilingrightBigg/braceleftBigg
/bracerightBigg/angbracketleftBigg/angbracketrightBigg/slashBigg
/backslashBigg/slashBig/backslashBig/parenlefttp/parenrighttp/bracketlefttp
/bracketrighttp/bracketleftbt/bracketrightbt/bracketleftex/bracketrightex
/bracelefttp/bracerighttp/braceleftbt/bracerightbt/braceleftmid
/bracerightmid/braceex/arrowvertex/parenleftbt/parenrightbt/parenleftex
/parenrightex/angbracketleftBig/angbracketrightBig/unionsqtext
/unionsqdisplay/contintegraltext/contintegraldisplay/circledottext
/circledotdisplay/circleplustext/circleplusdisplay/circlemultiplytext
/circlemultiplydisplay/summationtext/producttext/integraltext/uniontext
/intersectiontext/unionmultitext/logicalandtext/logicalortext
/summationdisplay/productdisplay/integraldisplay/uniondisplay
/intersectiondisplay/unionmultidisplay/logicalanddisplay/logicalordisplay
/coproducttext/coproductdisplay/hatwide/hatwider/hatwidest/tildewide
/tildewider/tildewidest/bracketleftBig/bracketrightBig/floorleftBig
/floorrightBig/ceilingleftBig/ceilingrightBig/braceleftBig/bracerightBig
/radicalbig/radicalBig/radicalbigg/radicalBigg/radicalbt/radicalvertex
/radicaltp/arrowvertexdbl/arrowtp/arrowbt/bracehtipdownleft
/bracehtipdownright/bracehtipupleft/bracehtipupright/arrowdbltp/arrowdblbt
128{/.notdef}repeat]
MnSymbolF-Bold10:
MnSymbolF-Bold12:
MnSymbolF-Bold5:
MnSymbolF-Bold6:
MnSymbolF-Bold7:
MnSymbolF-Bold8:
MnSymbolF-Bold9:
MnSymbolF10:
MnSymbolF12:
MnSymbolF5:
MnSymbolF6:
MnSymbolF7:
MnSymbolF8:
MnSymbolF9:
[/plus.big/plus.big.disp/uni2A09/uni2A09.disp/uni22C0/uni22C0.disp/uni22C1
/uni22C1.disp/wedgedot.big/wedgedot.big.disp/veedot.big/veedot.big.disp
/uni2A55.big/uni2A55.big.disp/uni2A54.big/uni2A54.big.disp/curlyand.big
/curlyand.big.disp/curlyor.big/curlyor.big.disp/curlywedgedot.big
/curlywedgedot.big.disp/curlyveedot.big/curlyveedot.big.disp
/doublecurlywedge.big/doublecurlywedge.big.disp/doublecurlyvee.big
/doublecurlyvee.big.disp/uni22C2/uni22C2.disp/uni22C3/uni22C3.disp
/uni2A40.big/uni2A40.big.disp/uni228D.big/uni228D.big.disp/capplus.big
/capplus.big.disp/uni228E.big/uni228E.big.disp/uni2293.big/uni2293.big.disp
/uni2294.big/uni2294.big.disp/sqcapdot.big/sqcapdot.big.disp/sqcupdot.big
/sqcupdot.big.disp/sqcapplus.big/sqcapplus.big.disp/sqcupplus.big
/sqcupplus.big.disp/uni25EF.big/uni25EF.big.disp/uni2296.big
/uni2296.big.disp/uni29B6.big/uni29B6.big.disp/uni2298.big/uni2298.big.disp
/uni29B8.big/uni29B8.big.disp/uni2295.big/uni2295.big.disp/uni2297.big
/uni2297.big.disp/uni2299.big/uni2299.big.disp/uni229A.big/uni229A.big.disp
/otriangle.big/otriangle.big.disp/uni229B.big/uni229B.big.disp/uni235F.big
/uni235F.big.disp/product/product.disp/uni2210/uni2210.disp/summation
/summation.disp/integral/integral.disp/uni222C/uni222C.disp/uni222D
/uni222D.disp/uni2A0C/uni2A0C.disp/uni222B2026222B/uni222B2026222B.disp
/uni2A19/uni2A19.disp/uni2A1A/uni2A1A.disp/uni2A0F/uni2A0F.disp/uni222E
/uni222E.disp/uni222F/uni222F.disp/uni2233/uni2233.disp/uni2232.alt1
/uni2232.disp.alt1/uni2233.alt1/uni2233.disp.alt1/uni2232/uni2232.disp
/uni2A0B/uni2A0B.disp/uni222B2026222B.part/uni222B2026222B.part.disp
/uni2A19.part/uni2A19.part.disp/uni2A1A.part/uni2A1A.part.disp/uni2A0F.part
/uni2A0F.part.disp/uni222E.part/uni222E.part.disp/uni222F.part
/uni222F.part.disp/uni2233.part/uni2233.part.disp/uni2232.part.alt1
/uni2232.part.disp.alt1/uni2233.part.alt1/uni2233.part.disp.alt1
/uni2232.part/uni2232.part.disp/uni2A0B.part/uni2A0B.part.disp/uni2201
/uni2201.disp 120{/.notdef}repeat]
stmary10:
stmary5:
stmary6:
stmary7:
stmary8:
stmary9:
[/shortleftarrow/shortrightarrow/shortuparrow/shortdownarrow/Yup/Ydown/Yleft
/Yright/varcurlyvee/varcurlywedge/minuso/baro/sslash/bbslash/moo/varotimes
/varoast/varobar/varodot/varoslash/varobslash/varocircle/varoplus/varominus
/boxast/boxbar/boxdot/boxslash/boxbslash/boxcircle/boxbox/boxempty/lightning
/merge/vartimes/fatsemi/ssearrow/curlywedgeuparrow/sswarrow
/curlywedgedownarrow/fatslash/fatbslash/lbag/rbag/varbigcirc
/leftrightarroweq/curlyveedownarrow/curlyveeuparrow/nnwarrow/nnearrow
/leftslice/rightslice/varolessthan/varogreaterthan/varovee/varowedge
/talloblong/interleave/obar/obslash/olessthan/ogreaterthan/ovee/owedge
/oblong/inplus/niplus/nplus/subsetplus/supsetplus/subsetpluseq/supsetpluseq
/Lbag/Rbag/llbracket/rrbracket/llparenthesis/rrparenthesis/binampersand
/bindnasrepma/trianglelefteqslant/trianglerighteqslant/ntrianglelefteqslant
/ntrianglerighteqslant/llfloor/rrfloor/llceil/rrceil/arrownot/Arrownot
/Mapstochar/mapsfromchar/Mapsfromchar/leftrightarrowtriangle
/leftarrowtriangle/rightarrowtriangle/bigtriangledown/bigtriangleup
/bigcurlyvee/bigcurlywedge/bigsqcap/bigbox/bigparallel/biginterleave
/hugetriangledown/hugetriangleup/hugecurlyvee/hugecurlywedge/hugesqcap
/hugebox/hugeparallel/hugeinterleave/hugenplus/largellbracket/Largellbracket
/LARGEllbracket/hugellbracket/Hugellbrackettop/Hugellbracketbot
/Hugellbracketex/Hugenplus/largerrbracket/Largerrbracket/LARGErrbracket
/hugerrbracket/Hugerrbrackettop/Hugerrbracketbot/Hugerrbracketex 128{
/.notdef}repeat]
skt10:
skt8:
skt9:
sktb10:
sktbs10:
sktf10:
sktfs10:
skts10:
[/skt000/skt001/skt002/skt003/skt004/skt005/skt006/skt007/skt008/skt009
/skt010/skt011/skt012/skt013/skt014/skt015/skt016/skt017/skt018/skt019
/skt020/skt021/skt022/skt023/skt024/skt025/skt026/skt027/skt028/skt029
/skt030/skt031/skt032/skt033/skt034/skt035/skt036/skt037/skt038/skt039
/skt040/skt041/skt042/skt043/skt044/skt045/skt046/skt047/skt048/skt049
/skt050/skt051/skt052/skt053/skt054/skt055/skt056/skt057/skt058/skt059
/skt060/skt061/skt062/skt063/skt064/skt065/skt066/skt067/skt068/skt069
/skt070/skt071/skt072/skt073/skt074/skt075/skt076/skt077/skt078/skt079
/skt080/skt081/skt082/skt083/skt084/skt085/skt086/skt087/skt088/skt089
/skt090/skt091/skt092/skt093/skt094/skt095/skt096/skt097/skt098/skt099
/skt100/skt101/skt102/skt103/skt104/skt105/skt106/skt107/skt108/skt109
/skt110/skt111/skt112/skt113/skt114/skt115/skt116/skt117/skt118/skt119
/skt120/skt121/skt122/skt123/skt124/skt125/skt126/skt127/skt128/skt129
/skt130/skt131/skt132/skt133/skt134/skt135/skt136/skt137/skt138/skt139
/skt140/skt141/skt142/skt143/skt144/skt145/skt146/skt147/skt148/skt149
/skt150/skt151/skt152/skt153/skt154/skt155/skt156/skt157/skt158/skt159
/skt160/skt161/skt162/skt163/skt164/skt165/skt166/skt167/skt168/skt169
/skt170/skt171/skt172/skt173/skt174/skt175/skt176/skt177/skt178/skt179
/skt180/skt181/skt182/skt183/skt184/skt185/skt186/skt187/skt188/skt189
/skt190/skt191/skt192/skt193/skt194/skt195/skt196/skt197/skt198/skt199
/skt200/skt201/skt202/skt203/skt204/skt205/skt206/skt207/skt208/skt209
/skt210/skt211/skt212/skt213/skt214/skt215/skt216/skt217/skt218/skt219
/skt220/skt221/skt222/skt223/skt224/skt225/skt226/skt227/skt228/skt229
/skt230/skt231/skt232/skt233/skt234/skt235/skt236/skt237/skt238/skt239
/skt240/skt241/skt242/skt243/skt244/skt245/skt246/skt247/skt248/skt249
/skt250/skt251/skt252/skt253/skt254/skt255]
cmbras10:
cmbras8:
cmbras9:
lmsam8:
msam10:
msam5:
msam6:
msam7:
msam8:
msam9:
[/squaredot/squareplus/squaremultiply/square/squaresolid/squaresmallsolid
/diamond/diamondsolid/clockwise/anticlockwise/harpoonleftright
/harpoonrightleft/squareminus/forces/forcesbar/satisfies/dblarrowheadright
/dblarrowheadleft/dblarrowleft/dblarrowright/dblarrowup/dblarrowdwn
/harpoonupright/harpoondownright/harpoonupleft/harpoondownleft
/arrowtailright/arrowtailleft/arrowparrleftright/arrowparrrightleft
/shiftleft/shiftright/squiggleright/squiggleleftright/curlyleft/curlyright
/circleequal/followsorequal/greaterorsimilar/greaterorapproxeql/multimap
/therefore/because/equalsdots/defines/precedesorequal/lessorsimilar
/lessorapproxeql/equalorless/equalorgreater/equalorprecedes/equalorfollows
/precedesorcurly/lessdblequal/lessorequalslant/lessorgreater/primereverse
/axisshort/equaldotrightleft/equaldotleftright/followsorcurly
/greaterdblequal/greaterorequalslant/greaterorless/squareimage
/squareoriginal/triangleright/triangleleft/trianglerightequal
/triangleleftequal/star/between/triangledownsld/trianglerightsld
/triangleleftsld/arrowaxisright/arrowaxisleft/triangle/trianglesolid
/triangleinv/ringinequal/lessequalgreater/greaterlessequal/lessdbleqlgreater
/greaterdbleqlless/Yen/arrowtripleright/arrowtripleleft/check/orunderscore
/nand/perpcorrespond/angle/measuredangle/sphericalangle/proportional/smile
/frown/subsetdbl/supersetdbl/uniondbl/intersectiondbl/uprise/downfall
/multiopenleft/multiopenright/subsetdblequal/supersetdblequal/difference
/geomequivalent/muchless/muchgreater/rightanglenw/rightanglene/circleR
/circleS/fork/dotplus/revsimilar/revasymptequal/rightanglesw/rightanglese
/maltesecross/complement/intercal/circlering/circleasterisk/circleminus 128{
/.notdef}repeat]
FdSymbolE-Bold:
FdSymbolE-Book:
FdSymbolE-Medium:
FdSymbolE-Regular:
[/sym090/sym090.disp/uni2A09/uni2A09.disp/uni22C0/uni22C0.disp/uni22C1
/uni22C1.disp/sym091/sym091.disp/sym092/sym092.disp/uni2A07/uni2A07.disp
/uni2A08/uni2A08.disp/sym093/sym093.disp/sym094/sym094.disp/uni22C2
/uni22C2.disp/uni22C3/uni22C3.disp/sym095/sym095.disp/uni2A03/uni2A03.disp
/sym096/sym096.disp/uni2A04/uni2A04.disp/uni2A05/uni2A05.disp/uni2A06
/uni2A06.disp/sym097/sym097.disp/sym098/sym098.disp/sym099/sym099.disp
/sym09A/sym09A.disp/uni2A01/uni2A01.disp/uni2A02/uni2A02.disp/uni2A00
/uni2A00.disp/sym09B/sym09B.disp/product/product.disp/product.sf
/product.sf.disp/uni2210/uni2210.disp/uni2210.sf/uni2210.sf.disp/summation
/summation.disp/summation.sf/summation.sf.disp/uni2A0A/uni2A0A.disp
/uni2A0A.sf/uni2A0A.sf.disp/integral/integral.disp/uni222C/uni222C.disp
/uni222D/uni222D.disp/uni2A0C/uni2A0C.disp/uni222B22EF222B
/uni222B22EF222B.disp/uni2231/uni2231.disp/uni2A11/uni2A11.disp/uni2A0D
/uni2A0D.disp/uni2A0E/uni2A0E.disp/uni2A0F/uni2A0F.disp/uni222E/uni222E.disp
/uni222F/uni222F.disp/uni2230/uni2230.disp/uni2233/uni2233.disp/uni2232.alt
/uni2232.alt.disp/uni2233.alt/uni2233.alt.disp/uni2232/uni2232.disp/uni2A0B
/uni2A0B.disp/uni2A0B.sf/uni2A0B.sf.disp 8{/.notdef}repeat/uni0302
/uni0302.big1/uni0302.big2/uni0302.big3/uni0302.big4/uni0302.big5/uni0303
/uni0303.big1/uni0303.big2/uni0303.big3/uni0303.big4/uni0303.big5/uni0311
/uni0311.big1/uni0311.big2/uni0311.big3/uni0311.big4/uni0311.big5/uni20D7
/uni0335/uni0337/uni0338 120{/.notdef}repeat]
MdSymbolE-Bold:
MdSymbolE-Light:
MdSymbolE-Regular:
MdSymbolE-Semibold:
[/sym090/sym090.disp/uni2A09/uni2A09.disp/uni22C0/uni22C0.disp/uni22C1
/uni22C1.disp/sym091/sym091.disp/sym092/sym092.disp/uni2A07/uni2A07.disp
/uni2A08/uni2A08.disp/sym093/sym093.disp/sym094/sym094.disp/uni22C2
/uni22C2.disp/uni22C3/uni22C3.disp/sym095/sym095.disp/uni2A03/uni2A03.disp
/sym096/sym096.disp/uni2A04/uni2A04.disp/uni2A05/uni2A05.disp/uni2A06
/uni2A06.disp/sym097/sym097.disp/sym098/sym098.disp/sym099/sym099.disp
/sym09A/sym09A.disp/uni2A01/uni2A01.disp/uni2A02/uni2A02.disp/uni2A00
/uni2A00.disp/sym09B/sym09B.disp/product/product.disp/uni2210/uni2210.disp
/summation/summation.disp/uni2A0A/uni2A0A.disp/integral/integral.disp
/uni222C/uni222C.disp/uni222D/uni222D.disp/uni2A0C/uni2A0C.disp
/uni222B22EF222B/uni222B22EF222B.disp/uni2231/uni2231.disp/uni2A11
/uni2A11.disp/uni2A0D/uni2A0D.disp/uni2A0E/uni2A0E.disp/uni2A0F/uni2A0F.disp
/uni222E/uni222E.disp/uni222F/uni222F.disp/uni2230/uni2230.disp/uni2233
/uni2233.disp/uni2232.alt/uni2232.alt.disp/uni2233.alt/uni2233.alt.disp
/uni2232/uni2232.disp/uni2A0B/uni2A0B.disp/sym09C/sym09C.disp/sym09D
/sym09D.disp 14{/.notdef}repeat/uni0302/uni0302.big1/uni0302.big2
/uni0302.big3/uni0302.big4/uni0302.big5/uni0303/uni0303.big1/uni0303.big2
/uni0303.big3/uni0303.big4/uni0303.big5/uni0311/uni0311.big1/uni0311.big2
/uni0311.big3/uni0311.big4/uni0311.big5/uni20D7/uni0335/uni0337/uni0338 120{
/.notdef}repeat]
dvnb10:
dvnb8:
dvnb9:
dvnbb10:
dvnbb8:
dvnbb9:
dvnbbi10:
dvnbbi8:
dvnbbi9:
dvnbi10:
dvnbi8:
dvnbi9:
dvnc10:
dvnc8:
dvnc9:
dvncb10:
dvncb8:
dvncb9:
dvncbi10:
dvncbi8:
dvncbi9:
dvnci10:
dvnci8:
dvnci9:
dvng10:
dvng8:
dvng9:
dvngb10:
dvngb8:
dvngb9:
dvngbi10:
dvngbi8:
dvngbi9:
dvngi10:
dvngi8:
dvngi9:
dvnn10:
dvnn8:
dvnn9:
dvnnb10:
dvnnb8:
dvnnb9:
dvnnbi10:
dvnnbi8:
dvnnbi9:
dvnni10:
dvnni8:
dvnni9:
dvpb10:
dvpb8:
dvpb9:
dvpc10:
dvpc8:
dvpc9:
dvpn10:
dvpn8:
dvpn9:
dvpnn10:
dvpnn8:
dvpnn9:
[/umatra/uumatra/rimatra/ematra/candra/halfya/halfna/halfkhha/halffa/halfssa
/halfqa/ghha/khha/repha/riimatra/lla/halflla/rii/iianusvara/rephaanusvara
/nukta/ellipsisdot/halfnya/halfnna/ll/lii/nya/rr/halfghha/rmarathi/halfza
/limatra/candrabindu/ruu/ksa/halfksa/halfjha/halfpha/halfva/fa/halfta/za/qa
/openya/visarga/halfsa/danda/tr/zero/one/two/three/four/five/six/seven/eight
/nine/om/dbldanda/halfbha/halfpa/halfja/halfka/halfdha/aamatra/bha/cha/dha
/imatra/iimatra/gha/halfkha/ii/jha/kha/halftha/halfma/halfba/aumatra/pha
/halfca/nga/halfla/tha/uu/tta/ttha/dda/ddha/nna/halfsha/anusvara/halfgha
/virama/avagraha/halfga/a/ba/ca/da/e/sha/ga/ha/i/ja/ka/la/ma/na/omatra/pa
/ssa/ra/sa/ta./u/va/rra/rrha/ya/ru/aimatra/liimatra/rstroke/subr1
/abbreviation/sr/t_t/_t_t/ph_r/fr/jr/zr/kr/d_dh/d_bh/d_gh/d_g/d_d/d_y/d_bh_y
/d_dh_y/d_d_y/d_n/d_v/d_b/d_m/d_v_y/sh_c/sh_n/sh_v/sh_r/sh_l/nn_nn/h_m/h_y
/h_l/h_v/h_r/h_n/h_nn/ss_tt/ss_tth/l_l/v_n/b_n/v_v/b_b/ss_tt_r_y/ss_tt_v
/ng_k/ng_k_t/ng_k_t_y/ng_k_y/ng_ks/ng_ks_v/ng_kh/dd_g/dd_gh/ng_n/dd_gh_r
/dd_y/dd_g_y/ng_gh_y/ng_kh_y./dd_m/ng_ng/ng_g/ng_g_y/ng_gh/ng_gh_r/ng_m/ng_y
/k_k/k_t/k_t_y/k_t_v/k_n/k_y/k_m/k_l/k_v/k_v_y/gh_n/c_c/c_ny/ch_y/ny_c/ny_j
/tt_tt/tt_y/tth_y/tt_k/t_n/p_t/p_n/p_l/b_v/s_n/m_l/bh_n/m_n/n_n/tt_tth/j_ny
/h_rr/ddh_y/dd_dd/k_n_y/k_r_y/_gh_n/_g_r/_j_ny/_ny_c/_tr/d_g_r/d_gh_r/d_r_y
/dh_n/_dh_n/_dh_r/_p_t/_sh_c/_sh_r/_sh_v/ss_tt_y/d_d_v/d_dh_v/s_r/dd_r_y
/k_t_r_y/subr2/p_r/hyphen]
MnSymbolB-Bold10:
MnSymbolB-Bold12:
MnSymbolB-Bold5:
MnSymbolB-Bold6:
MnSymbolB-Bold7:
MnSymbolB-Bold8:
MnSymbolB-Bold9:
MnSymbolB10:
MnSymbolB12:
MnSymbolB5:
MnSymbolB6:
MnSymbolB7:
MnSymbolB8:
MnSymbolB9:
[/uni219B/uni21910338/uni219A/uni21930338/uni21970338/uni21960338
/uni21990338/uni21980338/arrowrightdblstroke/uni21D10338/uni21CD/uni21D30338
/uni21D70338/uni21D60338/uni21D90338/uni21D80338/uni21AE/uni21950338
/uni29210338/uni29220338/uni21CE/uni21D50338/Neswarrow_uni0338
/Nwsearrow_uni0338/uni21A00338/uni219F0338/uni219E0338/uni21A10338
/twoheadnearrow_uni0338/twoheadnwarrow_uni0338/twoheadswarrow_uni0338
/twoheadsearrow_uni0338/uni21A30338/uparrowtail_uni0338/uni21A20338
/downarrowtail_uni0338/nearrowtail_uni0338/nwarrowtail_uni0338
/swarrowtail_uni0338/searrowtail_uni0338/uni21A60338/uni21A50338/uni21A40338
/uni21A70338/nemapsto_uni0338/nwmapsto_uni0338/swmapsto_uni0338
/semapsto_uni0338/uni21AA0338/lhookuparrow_uni0338/lhookleftarrow_uni0338
/lhookdownarrow_uni0338/lhooknearrow_uni0338/uni29230338
/lhookswarrow_uni0338/uni29250338/rhookrightarrow_uni0338
/rhookuparrow_uni0338/uni21A90338/rhookdownarrow_uni0338/uni29240338
/rhooknwarrow_uni0338/uni29260338/rhooksearrow_uni0338/uni21C00338
/uni21BF0338/uni21BD0338/uni21C20338/neharpoonup_uni0338/nwharpoonup_uni0338
/swharpoonup_uni0338/seharpoonup_uni0338/uni21C10338/uni21BE0338/uni21BC0338
/uni21C30338/neharpoondown_uni0338/nwharpoondown_uni0338
/swharpoondown_uni0338/seharpoondown_uni0338/uni294B0338
/updownharpoonleftright_uni0338/neswharpoonnwse_uni0338
/senwharpoonnesw_uni0338/uni294A0338/updownharpoonrightleft_uni0338
/neswharpoonsenw_uni0338/nwseharpoonswne_uni0338/uni21CC0338/uni296E0338
/neswharpoons_uni0338/senwharpoons_uni0338/uni21CB0338/uni296F0338
/swneharpoons_uni0338/nwseharpoons_uni0338/uni21E20338/uni21E10338
/uni21E00338/uni21E30338/dashednearrow_uni0338/dashednwarrow_uni0338
/dashedswarrow_uni0338/dashedsearrow_uni0338/uni22B80338/uni2AEF0338
/uni27DC0338/uni2AF00338/nespoon_uni0338/nwspoon_uni0338/swspoon_uni0338
/sespoon_uni0338/rightfilledspoon_uni0338/upfilledspoon_uni0338
/leftfilledspoon_uni0338/downfilledspoon_uni0338/nefilledspoon_uni0338
/nwfilledspoon_uni0338/swfilledspoon_uni0338/sefilledspoon_uni0338
/rightfootline_uni0338/upfootline_uni0338/leftfootline_uni0338
/downfootline_uni0338/nefootline_uni0338/nwfootline_uni0338
/swfootline_uni0338/sefootline_uni0338/rightfree_uni0338/upfree_uni0338
/leftfree_uni0338/uni2ADC/nefree_uni0338/nwfree_uni0338/swfree_uni0338
/sefree_uni0338/rightpitchfork_uni0338/uni22D40338/leftpitchfork_uni0338
/uni2ADB0338/nepitchfork_uni0338/nwpitchfork_uni0338/swpitchfork_uni0338
/sepitchfork_uni0338/uni21C90338/uni21C80338/uni21C70338/uni21CA0338
/nenearrows_uni0338/nwnwarrows_uni0338/swswarrows_uni0338/sesearrows_uni0338
/uni21C40338/updownarrows_uni0338/neswarrows_uni0338/nwsearrows_uni0338
/uni21C60338/downuparrows_uni0338/swnearrows_uni0338/senwarrows_uni0338
/uni219D0338/uplsquigarrow_uni0338/leftlsquigarrow_uni0338
/downlsquigarrow_uni0338/nelsquigarrow_uni0338/nwlsquigarrow_uni0338
/swlsquigarrow_uni0338/selsquigarrow_uni0338/rightrsquigarrow_uni0338
/uprsquigarrow_uni0338/uni219C0338/downrsquigarrow_uni0338
/nersquigarrow_uni0338/nwrsquigarrow_uni0338/swrsquigarrow_uni0338
/sersquigarrow_uni0338/squigarrowleftright_uni0338/squigarrowupdown_uni0338
/squigarrowrightleft_uni0338/squigarrowdownup_uni0338/squigarrownesw_uni0338
/squigarrownwse_uni0338/squigarrowswne_uni0338/squigarrowsenw_uni0338
/uni21B70338/lcurvearrowup_uni0338/lcurvearrowleft_uni0338/uni29380338
/lcurvearrowne_uni0338/lcurvearrownw_uni0338/lcurvearrowsw_uni0338
/lcurvearrowse_uni0338/rcurvearrowright_uni0338/rcurvearrowup_uni0338
/uni21B60338/uni29390338/rcurvearrowne_uni0338/rcurvearrownw_uni0338
/rcurvearrowsw_uni0338/rcurvearrowse_uni0338/curvearrowleftright_uni0338
/curvearrowupdown_uni0338/curvearrowrightleft_uni0338
/curvearrowdownup_uni0338/curvearrownesw_uni0338/curvearrownwse_uni0338
/curvearrowswne_uni0338/curvearrowsenw_uni0338/leftrightline_uni0338/uni2224
/neswline_uni0338/nwseline_uni0338/Leftrightline_uni0338/notparallel
/Neswline_uni0338/Nwseline_uni0338/uni22AC/perpendicular_uni0338/uni22A30338
/uni22A40338/nevdash_uni0338/nwvdash_uni0338/swvdash_uni0338/sevdash_uni0338
/uni22AD/upmodels_uni0338/leftmodels_uni0338/downmodels_uni0338
/nemodels_uni0338/nwmodels_uni0338/swmodels_uni0338/semodels_uni0338/uni22AE
/uni234A0338/leftVdash_uni0338/uni23510338/neVdash_uni0338/nwVdash_uni0338
/swVdash_uni0338/seVdash_uni0338/uni22AF/upModels_uni0338/leftModels_uni0338
/downModels_uni0338/neModels_uni0338/nwModels_uni0338/swModels_uni0338
/seModels_uni0338/uni293F0338/uni21BA0338/uni27F20338
/rcirclearrowdown_uni0338/uni27F30338/uni21BB0338/uni293E0338
/lcirclearrowdown_uni0338]
FdSymbolD-Bold:
FdSymbolD-Book:
FdSymbolD-Medium:
FdSymbolD-Regular:
MdSymbolD-Bold:
MdSymbolD-Light:
MdSymbolD-Regular:
MdSymbolD-Semibold:
[/uni219B/uni21910338/uni219A/uni21930338/uni21970338/uni21960338
/uni21990338/uni21980338/uni21CF/uni21D10338/uni21CD/uni21D30338/uni21D70338
/uni21D60338/uni21D90338/uni21D80338/uni21AE/uni21950338/uni29210338
/uni29220338/uni21CE/uni21D50338/sym030_uni0338/sym031_uni0338/uni21A00338
/uni219F0338/uni219E0338/uni21A10338/sym033_uni0338/sym032_uni0338
/sym035_uni0338/sym034_uni0338/uni21A30338/sym036_uni0338/uni21A20338
/sym037_uni0338/sym039_uni0338/sym038_uni0338/sym03B_uni0338/sym03A_uni0338
/uni21A60338/uni21A50338/uni21A40338/uni21A70338/uni29070338/sym03C_uni0338
/uni29060338/sym03D_uni0338/uni21AA0338/sym03E_uni0338/uni21A90338.alt
/sym03F_uni0338.alt/uni29240338.alt/uni29230338/uni29260338.alt/uni29250338
/uni21AA0338.alt/sym03E_uni0338.alt/uni21A90338/sym03F_uni0338/uni29240338
/uni29230338.alt/uni29260338/uni29250338.alt/uni21C00338/uni21BF0338
/uni21BD0338/uni21C20338/sym041_uni0338/sym040_uni0338/sym043_uni0338
/sym042_uni0338/uni21C10338/uni21BE0338/uni21BC0338/uni21C30338
/sym045_uni0338/sym044_uni0338/sym047_uni0338/sym046_uni0338/uni294B0338
/uni294D0338/sym049_uni0338/sym048_uni0338/uni294A0338/uni294C0338
/sym04B_uni0338/sym04A_uni0338/uni21CC0338/uni296E0338/sym04D_uni0338
/sym04C_uni0338/uni21CB0338/uni296F0338/sym04F_uni0338/sym04E_uni0338
/uni21E20338/uni21E10338/uni21E00338/uni21E30338/sym051_uni0338
/sym050_uni0338/sym053_uni0338/sym052_uni0338/uni22B80338/uni2AEF0338
/uni27DC0338/uni2AF00338/sym054_uni0338/sym056_uni0338/sym055_uni0338
/sym057_uni0338/uni29DF0338/sym058_uni0338/uni22B70338/uni22B60338
/sym05A_uni0338/uni22D40338/sym05B_uni0338/sym059_uni0338/uni21C90338
/uni21C80338/uni21C70338/uni21CA0338/sym05D_uni0338/sym05C_uni0338
/sym05F_uni0338/sym05E_uni0338/uni21C40338/uni21C50338/sym061_uni0338
/sym060_uni0338/uni21C60338/uni21F50338/sym063_uni0338/sym062_uni0338
/uni219D0338/sym064_uni0338.alt/uni219C0338.alt/sym065_uni0338
/uni219D0338.alt/sym064_uni0338/uni219C0338/sym065_uni0338.alt/uni21AD0338
/sym066_uni0338.alt/uni21AD0338.alt/sym066_uni0338/sym069_uni0338
/sym068_uni0338/sym067_uni0338/uni29380338/sym06C_uni0338/sym06B_uni0338
/uni29360338/uni29350338/uni293B0338/sym06A_uni0338/uni293A0338/uni29390338
/uni29340338/sym06D_uni0338/sym06E_uni0338/uni29370338/sym06F_uni0338
/sym070_uni0338/sym071_uni0338/sym072_uni0338/sym074_uni0338/sym073_uni0338
/sym076_uni0338/sym075_uni0338/sym077_uni0338/sym078_uni0338/sym079_uni0338
/uni21BA0338/uni27F20338/sym07C_uni0338/uni27F30338/uni21BB0338
/sym07A_uni0338/sym07B_uni0338/uni21DB0338/uni290A0338/uni21DA0338
/uni290B0338/uni27F60338/uni27F50338/uni27F90338/uni27F80338/uni27F70338
/uni27FA0338/uni27FC0338/uni27FB0338/uni27FE0338/uni27FD0338/uni27FF0338
/uni2B330338/uni27DD0338/uni27DE0338 24{/.notdef}repeat/uni22AC/uni22A50338
/uni22A30338/uni22A40338/uni22A60338/uni2AE00338/uni2ADE0338/uni2ADF0338
/uni22AD/uni2AEB0338/uni2AE40338/uni2AEA0338/uni22A70338/sym07E_uni0338
/sym07D_uni0338/sym07F_uni0338/uni22AE/uni234A0338/uni2AE30338/uni23510338
/uni22AE.alt/uni2AE80338/uni2AE30338.alt/uni2AE70338/uni22AF/sym080_uni0338
/uni2AE50338/sym081_uni0338/uni22AA0338/sym082_uni0338/uni2AE20338
/sym083_uni0338]
ar10:
ar12:
ar6:
ar7:
ar8:
ar9:
arb10:
arb12:
arb5:
arb6:
arb7:
arb8:
arb9:
arrow:
arssbi10:
arssi10:
artti10:
bguq10t04:
bguq10t05:
bguq10t06:
bguq10t07:
bguq10t08:
bguq10t09:
bguq10t10:
bguq10t11:
bguq10t12:
pigpen:
recycle:
xppff10:
StandardEncoding
