
alpha::feature Alpha 7.3a6 {} {
    switch -- $tcl_platform(platform) {
	"macintosh" {
	    set "flagPrefs(Platform Specific)" ""
	    set "varPrefs(Platform Specific)" ""
	    set multiColumnMenusEveryNItems 2000
	    # If your platform doesn't handle scrolling menus, then your menus need
	    # to be multi-column.  Set this variable to the number of items per column.
	    newPref var multiColumnMenusEveryNItems
	    # To remove the menu bar from each separate text window, and use only a
	    # global menu bar, and speed up opening of new windows (Tk is particularly 
	    # slow with respect to 'cloning' menus, which it has to
	    # do if you want a separate menu bar in each editing window), click this box.||
	    # To place a menu bar in each editing window, and probably make the opening of
	    # new windows rather slow, click this box.
	    newPref flag useGlobalMenuBarOnly
	}
	"windows" {
	    lappend "flagPrefs(Platform Specific)" "useGlobalMenuBarOnly"
	    lappend "varPrefs(Platform Specific)" "multiColumnMenusEveryNItems" \
	      "nonInteractiveApps"
	    lappend allVars catSig
	    set catSig ""
	    set multiColumnMenusEveryNItems [expr {$screenHeight/18}]
	    set nonInteractiveApps [list "viewDVI" "viewPS"]
	    set useGlobalMenuBarOnly 1
	    # If your platform doesn't handle scrolling menus, then your menus need
	    # to be multi-column.  Set this variable to the number of items per column.
	    newPref var multiColumnMenusEveryNItems
	    # Alpha tries to capture stdout/stderr when it spawns off processes.  For
	    # some processes this isn't really useful, and it's best if Alpha just sets
	    # the thing running and then ignores it.  Set this variable to a list of
	    # those items in the helpers dialog which Alpha should ignore in this way
	    newPref var nonInteractiveApps
	    # To remove the menu bar from each separate text window, and use only a
	    # global menu bar, and speed up opening of new windows (Tk is particularly 
	    # slow with respect to 'cloning' menus, which it has to
	    # do if you want a separate menu bar in each editing window), click this box.||
	    # To place a menu bar in each editing window, and probably make the opening of
	    # new windows rather slow, click this box.
	    newPref flag useGlobalMenuBarOnly
	}
	"unix" -
	default {
	    lappend "flagPrefs(Platform Specific)" "useGlobalMenuBarOnly"
	    lappend "varPrefs(Platform Specific)" "multiColumnMenusEveryNItems" \
	      "nonInteractiveApps"
	    lappend allVars catSig
	    set catSig ""
	    set multiColumnMenusEveryNItems [expr {$screenHeight/18}]
	    set nonInteractiveApps [list "viewDVI" "viewPS"]
	    set useGlobalMenuBarOnly 1
	    # If your platform doesn't handle scrolling menus, then your menus need
	    # to be multi-column.  Set this variable to the number of items per column.
	    newPref var multiColumnMenusEveryNItems
	    # Alpha tries to capture stdout/stderr when it spawns off processes.  For
	    # some processes this isn't really useful, and it's best if Alpha just sets
	    # the thing running and then ignores it.  Set this variable to a list of
	    # those items in the helpers dialog which Alpha should ignore in this way
	    newPref var nonInteractiveApps
	    # To remove the menu bar from each separate text window, and use only a
	    # global menu bar, and speed up opening of new windows (Tk is particularly 
	    # slow with respect to 'cloning' menus, which it has to
	    # do if you want a separate menu bar in each editing window), click this box.||
	    # To place a menu bar in each editing window, and probably make the opening of
	    # new windows rather slow, click this box.
	    newPref flag useGlobalMenuBarOnly
	}
    }
    # To use built-in Tcl code to access remote Ftp sites, click
    # this box.|| To use external helper applications to access
    # remote Ftp sites, click this box.
    newPref flag useTclServiceForFtp 1
    lappend flagPrefs(WWW) useTclServiceForFtp
    lappend varPrefs(International) "localisation"

    # To use complete path names as the titles of windows, click
    # this box.||To use just the file name for window titles,
    # click this box.
    newPref flag showFullPathsInWindowTitles 0
    lappend flagPrefs(Window) showFullPathsInWindowTitles
    
    # Alpha contains the infrastructure for localisation (i.e. translation)
    # of most menu items, dialogs, alerts etc. to any language.  This is 
    # accomplished through the use of the 'msgcat' package, part of Tcl 8.1.
    # If a .msg file for your language exists, you can select it here.
    newPref earlyvar localisation c
    
    msgcat::mclocale $localisation
    rename ::msgcat::mcunknown ::msgcat::_mcunknown
    proc ::msgcat::mcunknown {locale string} {
	switch -- $locale {
	    "en_uk" {
		regsub -all {ization} $string {isation} string
		regsub -all {(C|c)olor} $string {\1olour} string
		return $string
	    }
	    default {
		return [uplevel [list ::msgcat::_mcunknown $locale $string]]
	    }
	}
    }
    
} {}









