# (nowrap)

namespace eval mode {}
namespace eval win {}
namespace eval menu {}

#  Declare Alpha packages  #

proc alpha::feature {name version modes {initialise ""} {activate ""} {deactivate ""} args} {
    global alpha::rebuilding
    if {!${alpha::rebuilding}} {return}
    global index::feature rebuild_cmd_count
    if {[string trim "$initialise$activate$deactivate"] == ""} {
	set index::feature($name) [list $version $modes -1]
    } else {
	set index::feature($name) [list $version $modes 0 $initialise $activate $deactivate]
    }
    
    if {[llength $args]} {
	eval alpha::package [lindex $args 0] $name $version [lrange $args 1 end]
	return
    }
    if {[info exists rebuild_cmd_count] && [incr rebuild_cmd_count -1] == 0} {
	return -code 11
    }
}

proc alpha::flag {name version modes args} {
    uplevel 1 alpha::feature [list $name $version $modes \
      "set $name 0" "set $name 1" "set $name 0"] $args
}

proc alpha::menu {name version modes {value ""} {initialise ""} {activate ""} {deactivate ""} args} {
    global alpha::rebuilding
    if {!${alpha::rebuilding}} {return}
    if {[string index $modes 0] == ""} {
	# it's in the old format
	set tmp $modes
	set modes $value
	if {$modes == "in_menu"} { set modes "global" }
	set value $tmp
	# perhaps there's a better way of collapsing these arguments
	if {[llength $args]} {
	    set args [concat [list $activate $deactivate] $args]
	} else {
	    if {$deactivate != ""} {
		lappend activate $deactivate
		set args $activate
	    } else {
		set args $activate
	    }
	}	
	set activate "$name"
	set deactivate ""
    }
    global index::feature rebuild_cmd_count
    if {[info exists index::feature($name)]} {
	eval lappend modes [lindex [set index::feature($name)] 1]
    }
    set index::feature($name) [list $version $modes 1 \
      "ensureset $name $value\n$initialise" \
      "$activate\ninsertMenu \$$name" \
      "$deactivate\nremoveMenu \$$name"]
	
    if {[llength $args]} {
	eval alpha::package [lindex $args 0] $name $version [lrange $args 1 end]
	return
    }
    if {[info exists rebuild_cmd_count] && [incr rebuild_cmd_count -1] == 0} {
	return -code 11
    }		
}

proc alpha::extension {name version {script ""} args} {
    uplevel 1 [list alpha::feature $name $version "global-only" "" $script ""] $args
}

proc alpha::mode {name version dummyProc {ext ""} {menus ""} {script ""} args} {
    global alpha::rebuilding alpha::requirements
    if {!${alpha::rebuilding}} {return}
    namespace eval ::$name {}
    global index::mode rebuild_cmd_count index::oldmode
    set index::mode($name) [list $version $dummyProc [join $ext " "] $menus $script]
    if {[info exists index::oldmode($name)]} {
	if {[set omenus [lindex [set index::oldmode($name)] 3]] != $menus} {
	    global alpha::noMenusYet mode::features modifiedArrayElements
	    foreach m $menus {
		# Store all version number requirements
		if {[lindex $m 2] != ""} {
		    lappend alpha::requirements [list $name $m]
		}
		set mm [lindex $m 0]
		if {([lsearch -exact $omenus $mm] == -1) \
		  && ([lsearch -glob $omenus "$mm *"] == -1)} {
		    # it's new
		    package::addRelevantMode $mm $name
		    if {[lindex $m 1] == 0} {continue}
		    if {[info exists alpha::noMenusYet]} {
			# we added a feature 
			hook::register startupHook "lunion mode::features($name) $mm"
		    } else {
			lunion mode::features($name) $mm
			lappend modifiedArrayElements [list $name mode::features]
		    }
		}
		  
	    }
	    foreach om $omenus {
		set omm [lindex $om 0]
		if {([lsearch -exact $menus $omm] == -1) \
		  && ([lsearch -glob $menus "$omm *"] == -1)} {
		    # it has been removed from the default list
		    package::removeRelevantMode $omm $name
		    set mode::features($name) [lremove $mode::features($name) $omm]
		    lappend modifiedArrayElements [list $name mode::features]
		}
	    }
	}
    }
    if {[llength $args]} {
	eval alpha::package [lindex $args 0] $name $version [lrange $args 1 end]
	return
    }
    if {[info exists rebuild_cmd_count] && [incr rebuild_cmd_count -1] == 0} {
	return -code 11
    }		
}

## 
 # -------------------------------------------------------------------------
 # 
 # "addMode" -- you probably won't call this proc yourself
 # 
 # -------------------------------------------------------------------------
 ##
proc addMode {m dummy suffs _features} {
    global mode::features filepats dummyProc index::feature
    namespace eval ::$m {}
    if {[string length $dummy]} {set dummyProc($m) $dummy}
    ensureset mode::features($m) $_features
    foreach f $_features {
	package::addRelevantMode $f $m
    }
    ensureset filepats($m) $suffs
}

proc addMenu {name {val ""} {modes ""}} {
    global menus index::feature
    lunion menus $name
    if {$val != ""} {
	global $name
	if {![info exists $name]} { set $name $val }
    }
    if {[info exists index::feature($name)]} {
	eval lappend modes [lindex [set index::feature($name)] 1]
    }
    set index::feature($name) \
      [list [list "mode" [lindex $modes 0]] $modes 1 "" "$name ; insertMenu \$$name" "removeMenu \$$name"]
}


#  Procs Alpha calls directly  #
proc getModeValuesAlpha {} {
    global showInvisibles
	
    getWinInfo blah
    lappend m "Mac" [expr {$blah(platform) == "mac"}]
    lappend m "UNIX" [expr {$blah(platform) == "unix"}]
    lappend m "IBM" [expr {$blah(platform) == "ibm"}] {(-} 0
    lappend m "MPW" [expr {$blah(state) == "mpw"}]
    lappend m "Think" [expr {$blah(state) == "think"}]
    lappend m "None" [expr {$blah(state) == "none"}] {(-} 0
    lappend m "Read Only" $blah(read-only)
    lappend m "Show Invisibles" $showInvisibles {(-} 0
    lappend m "Tab Size" 0
    return $m
}


proc setModeVarAlpha {var} {
    global mode allFlags modeVars
    global ${mode}modeVars
    
    set var [string tolower $var]
    switch -- $var {
        "unix"      -
        "mac"       -
        "ibm"       { setWinInfo platform $var ; setWinInfo dirty 1 }
        "mpw"       -
        "think"     -
        "none"      { setWinInfo state $var }
        "tab size"  {
            getWinInfo arr
            if {![catch {prompt "New tab size?" $arr(tabsize)} res]} {
                setWinInfo tabsize $res
            }
        }
        "read only" { 
            getWinInfo b
            setWinInfo read-only [expr {-1 * ($b(read-only) - 1)}]}
        "show invisibles" { 
        	global showInvisibles
        	set showInvisibles [expr {1 - $showInvisibles}]
        }
    }
    return
}

## 
 # -------------------------------------------------------------------------
 # 
 # "modes" --
 # 
 #  Called to get the list of modes for the modes popup
 # -------------------------------------------------------------------------
 ##
proc modes {args} { 
    global mode::features
    return [lsort -ignore [array names mode::features]]
}

# Called from alpha in response to the mode popup.
proc newMode {mode} {
    if {[package::helpOrDescribe $mode]} { return }
    global win::Modes
    changeMode $mode
    if {[catch {win::Current} name]} return
    set win::Modes($name) $mode
    refresh
}

#  Mode specific items  #

proc mode::menuProc {menu item} {
    if {![llength [winNames]]} {
        alertnote "No window!"
        return
    }
    switch -- $item {
        "preferences"       dialog::modifyModeFlags
        "loadPrefsFile"     mode::sourcePrefsFile
        "describeMode"  	mode::describe
        "changeMode"        	mode::changeDialog
	default {
	    mode::$item
	}		
    }
}

## 
 # -------------------------------------------------------------------------
 #	 
 # "win::setMode"	--
 #	
 #	Copes with endings like	'.orig'
 #	or the backup ending '~' or ' copy', and checks a smart-mode line
 #	like emacs, and handles a few Alpha-specific windows (trace dumps).
 #
 # -------------------------------------------------------------------------
 ##
proc win::setMode name {
    global win::Modes
    set win::Modes($name) [file::whichModeForWin $name]
}


## 
 # -------------------------------------------------------------------------
 # 
 # "win::addToMenu" --
 # 
 #  Adds a window name to the window menu.  This new version adds a 
 #  binding, to work-around a bug in Alpha, so that using cmd-0-9
 #  works if the window name contains square brackets.  The problem
 #  is that the 'addMenuItem' line creates a binding of the form
 #  'menu::winProc 263 namewith[square]brackets' which when evaluated
 #  causes an error.  We force a separate binding to
 #  'menu::winProc 263 {namewith[square]brackets}' which does work.
 # -------------------------------------------------------------------------
 ##
proc win::addToMenu {name} {
    global winNameToNum winMenu winNumToName
    if {[info tclversion] < 8.0} {
	set name [subst $name]
    }
    
    for {set i 0} {$i<100} {incr i} {
	if {![info exists winNumToName($i)]} {
	    regsub { <[0-9]+>$} $name {} nm
	    if {[file exists $nm]} {
		set nm [file tail $name]
	    } else {
		set nm $name
	    }
	    if {$i < 10} {
		addMenuItem -m -l "/$i" $winMenu "$nm"
		if {[info tclversion] < 8.0} {
		    Bind '$i' <c> [list menu::winProc $winMenu $nm]
		}
	    } else {
		addMenuItem -m -l "" $winMenu "$nm"
	    }
	    set winNumToName($i) $name
	    set winNameToNum($name) $i
	    return
	}
    }
}

proc win::removeFromMenu {name} {
    global winNameToNum winNumToName winMenu
    if {[info tclversion] < 8.0} {
	set name [subst $name]
    }
    set num $winNameToNum($name)
    unset winNumToName($num)
    unset winNameToNum($name)
    regsub { <[0-9]+>$} $name {} nm
    if {[file exists $nm]} {
	set nm [file tail $name]
    } else {
	# in case it was a file but the file was actually moved!
	global file::separator tcl_platform
	if {[regexp "\[^${file::separator}\]+\$" $name nm]} {
	    if {![catch {deleteMenuItem -m $winMenu $nm}]} { return } 
	}
	if {$tcl_platform(platform) == "windows"} {
	    if {[regexp "\[^\\\\\]+\$" $name nm]} {
		if {![catch {deleteMenuItem -m $winMenu $nm}]} { return } 
	    }
	}
	set nm $name
    }
    # to handle alpha problem with rebuilding the menu
    if {[catch {deleteMenuItem -m $winMenu $nm}]} { deleteMenuItem $winMenu $nm }
}

proc mode::changeDialog {} {
    global mode mode::features

    set nmode [listpick -p "Mode:" -L $mode \
      [lsort -ignore [array names mode::features]]]
    newMode $nmode
}

proc mode::describe {} {
    global mode ModeSuffixes mode::features
    global ${mode}modeVars
    
    set text "\r\tMODE $mode\r\r"
    if {![catch {package::describe $mode 1} res]} {
	append text $res "\r\r"
    }

    set tmp ""
    catch {set tmp [package::helpFile $mode 1]}
    append text "$tmp\r\r"

    set suffs ""
    set first 1
    foreach suf $ModeSuffixes {
        if {([llength $suf] == 3) && ([lindex $suf 1] == "winMode") \
	  && ([lindex $suf 2] == $mode)} {
	    if {$first} {
		append suffs $last
		set first 0
	    } else {
                append suffs ", $last"
            }
        }
        set last $suf
    }
    append text "Mode filepats: " $suffs "\r\r"
    
    set first 1
    append text "Mode menus and features: "
    if {[info exists mode::features($mode)]} {
        foreach m [set mode::features($mode)] {
            if {$first} {
                set first 0
                append text $m
            } else {
                append text ", " $m
            }
        }
     }
    append text "\r\r"
    append text [mode::describeVars $mode]
	
    set etext "\rMode-independent bindings:\r"
    append text "\rMode-specific bindings:\r"
    foreach b [split [bindingList] "\r"] {
	set lst [lindex [split $b  " "] end]
        if {$lst == $mode} {
            append text "\t$b\r"
        }
    }
    append text "\rTo list mode-independent bindings, select\
      'List Global/All Bindings'\rfrom the Config menu.\r"
    new -n "* <$mode> MODE *" -m Tcl -text $text -shell 1 -read-only 1
}

proc mode::describeVars {pkg {pkgpref ""}} {
    cache::readContents index::prefshelp
    if {$pkgpref == ""} {set pkgpref $pkg}
    global ${pkgpref}modeVars
    append text "Package-specific variables:\r"
    if {[array exists ${pkgpref}modeVars]} {
	foreach v [lsort [array names ${pkgpref}modeVars]] {
	    set val [set ${pkgpref}modeVars($v)]
	    global flag::type
	    set description ""
	    if {[info exists prefshelp(${pkg},$v)]} {
		set description [dialog::helpdescription $prefshelp(${pkg},$v)]
	    } elseif {[info exists prefshelp(${pkgpref},$v)]} {
		set description [dialog::helpdescription $prefshelp(${pkgpref},$v)]
	    } elseif {[info exists prefshelp($v)]} {
		set description [dialog::helpdescription $prefshelp($v)]
	    }
	    
	    if {$description != ""} {
		regsub -all "\[\r\n\]" [breakIntoLines $description] "&  \# " description
		append text "  # " $description "\r"
	    }
	    if {[info exists flag::type($v)] \
	      && [regexp {binding$} [set flag::type($v)]]} {
		set val [dialog::specialView_binding $val]
	    }
	    append text [format "  %-20s: \"%s\"\r" $v $val]
	}
    }
    
    return $text
}

# Now calls the new proc dialog::pickMenus
proc mode::menusAndFeatures {} {
    global mode mode::features modifiedArrayElements global::features

    set newFeatures [dialog::pickMenusAndFeatures $mode]
    set offon [package::onOrOff $newFeatures $mode]
    
    set mode::features($mode) $newFeatures
    lappend modifiedArrayElements [list $mode mode::features]
    # deactivate removed items
    foreach m [lindex $offon 0] {
	package::deactivate $m
    }
    foreach m [lindex $offon 1] {
	package::activate $m
    }
}

if {[info tclversion] < 8.0} {
proc mode::proc {name args} {
    global mode
    if {[info commands ${mode}::$name] != ""} {
	eval ${mode}::$name $args
    } else {
	eval ::$name $args
    }
}
proc mode::getProc {name} {
    global mode
    if {[info commands ${mode}::$name] != ""} {
	return ${mode}::$name
    } else {
	return ""
    }
}
proc mode::getVar {var} {
    uplevel \#0 "
    if \[info exists \${mode}::$var\] { 
	return \[set \${mode}::$var\]
    } else {
	return \[set $var\]
    } \
      "
}

} else {
    proc mode::proc {name args} {
	global ::mode
	namespace eval ::$mode "$name $args"
    }
    proc mode::getProc {name} {
	global ::mode
	namespace eval ::$mode "namespace which $name"
    }
    proc mode::getVar {var} {
	uplevel \#0 "
	if \[info exists ::\${mode}::$var\] { 
	    return \[set ::\${mode}::$var\]
	} else {
	    return \[set ::$var\]
	} \
	  "
    }
}

# Suffixes used to determine mode for new windows.
proc mode::updateSuffixes {} {
    global ModeSuffixes mode::features filepats

    set ModeSuffixes { default { set winMode Text } }
    foreach m [lsort -ignore [array names mode::features]] {
    	if {[info exists filepats($m)]} {
	    lappend ModeSuffixes $filepats($m) "set winMode $m"
    	}
    }
}

proc synchroniseModeVar {var args} {
    global mode $var
    if {[llength $args] > 0} {
	set $var [lindex $args 0]
    }
    global ${mode}ModeVars modifiedArrayElements
    lappend modifiedArrayElements [list $var ${mode}modeVars]
    set ${mode}modeVars($var) [set $var]
}

#  Miscellaneous  #

proc alpha::tryToLoad {msg args} {
    message "${msg}"
    set i -1
    set ok 1
    while 1 {
	set do [lindex $args [incr i]]
	set say [lindex $args [incr i]]
	if {$say == ""} {
	    set say "Loading $do"
	}
	if {$do == ""} {
	    if {$ok} {
		message "${msg}Complete."
	    } else {
		alertnote "${msg}Failed."
	    }
	    return $ok
	}
	message "${say}"
	if {[catch $do]} {
	    alertnote "$say failed!"
	}
	
    }
}

#  Read in all the packages  #

proc alpha::getBasicModes {} {
    global PSwords
    addMode PS {} {*.ps *.eps *.epsf} {}
    newPref v prefixString {% } PS
    set PSKeyWords {
	def begin end dict load exec if ifelse for repeat loop exit 
	stop stopped countexecstack execstack quit start gsave 
	grestore grestoreall initgraphics newpath erasepage fill 
	eofill stroke image imagemask showpage copypage
    }
    if {[info exists PSwords]} {set PSKeyWords [concat $PSKeyWords $PSwords]}
    regModeKeywords -e {%} -m {/}  -c red -k blue PS $PSKeyWords -i "\}" -i "\{" -i "\[" -i "\]" -I green
    
    addMode Inst "" [list "*Install" "*INSTALL"] {installMenu}
    addMenu installMenu "Install"
    hook::register openHook install::openHook Inst
    
    addMode Text {} {default} {}
    newPref v leftFillColumn {0} Text
    newPref v suffixString { <--} Text
    newPref v prefixString {> } Text
    newPref v fillColumn {75} Text
    newPref f wordWrap {1} Text
    newPref v wordBreak {\w+} Text
    newPref v wordBreakPreface {(\W)} Text
    newPref v wrapBreak {[\w_]+} Text
    newPref v wrapBreakPreface {([^\w_])} Text
    newPref f autoMark 0 Text
    newPref flag quietlyClearMarks 0 Text
    namespace eval Text {}
    proc Text::DblClick {args} {
	eval Tcl::DblClick $args
    }
}

proc alpha::findAllPlugins {} {
    alpha::findAllModes
    global skipPrefs
    if {!$skipPrefs} {
	alpha::findAllExtensions
    }
}

proc alpha::findAllModes {} {
    alpha::getBasicModes
    rename alpha::getBasicModes {}
    cache::readContents index::mode
    foreach f [array names index::mode] {
	eval addMode $f [lrange [set index::mode($f)] 1 3]
	if {[set script [lindex [set index::mode($f)] 4]] != ""} {
	    if {[catch {uplevel #0 $script} err]} {
		lappend problems "$f"
	    }
	}
    }
    if {[info exists problems]} {
	alertnote "Problems loading modes: $problems"
    }
    mode::updateSuffixes
}




