/* brk.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

void * __brk(void *newbrk)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    void * retv;

    if (newbrk == p->heap_brk)
        retv = p->heap_brk;
    else {

        EnterCriticalSection(&(p->CritSectHeap));

        if (newbrk > p->heap_brk)
            retv = _rsxnt_grow_heap(p, (int)newbrk - (int)p->heap_brk);
        else
            retv = _rsxnt_shrink_heap(p, (int)p->heap_brk - (int)newbrk);

        LeaveCriticalSection(&(p->CritSectHeap));
    }
    if (retv)
    {
      return (void *) 0;
    }
    else
    {
#ifdef EMX_SYS_LIB
      errno = ENOMEM;
#endif
      return (void *) -1;
    }
}

