@echo off
rem	This is a sample batch file to run metafont, convert the GF file to
rem	the PK format and store the PK font in the appropriate directory. It
rem	is meant to be called by dviwin and that's the reason for the absence
rem	of any parameter checking. It also assumes that metafont and gftopk
rem	are operating properly. This sample file attempts to cover as many
rem	devices as possible; you will probably get better and faster results
rem	if you write a smaller and more specialized batch file.
rem
rem	The plain base is a prerequisite: make sure that you generate it by
rem	running inimf on plain.mf, then input the file modes.mf (version 2.1
rem	or later; you can get it from the directory /tex-archive/fonts/modes
rem	at the CTAN hosts: ftp.shsu.edu, ftp.dante.de and ftp.tex.ac.uk; some
rem	modes will not work properly with earlier versions of the modes.mf
rem	file) and finally dump the format file. If you don't know what I am
rem	talking about, please read the documentation that comes with the
rem	metafont program, as well as the Metafont book.
rem
rem	You WILL need to modify the routine to place the PK files in the
rem	proper directory; the current method uses the environment variable
rem	DVIFONTS which is assumed to contain the base directory for the PK
rem	fonts. Any square-pixel fonts are assumed to be stored in the
rem	directories  $(DVIFONTS)\X  where X is the resolution of the font.
rem	Non-square-pixel fonts are assumed to stored in the directories
rem	$(DVIFONTS)\XxY where X is the horizontal resolution and Y is the
rem	vertical resolution.
rem
rem	It is trivial to modify the name of metafont and the base directory;
rem	just select the proper values for the first two statements after
rem	these comments. If you use another directory structure, you need
rem	to modify the next two statements.
rem
rem	You may also need to do more modifications if you have other devices;
rem	this batch file generates fonts for the screen, 300dpi laser and
rem	inkjet printers, 600dpi laserjets, as well as 9-pin and 24-pin dot
rem	matrix printers. If you want to use another device, you will have to
rem	understand the code below and modify it accordingly (maybe you will
rem	want to rewrite the code in a compiled language to improve the speed,
rem	the error handling and avoid all the ugly gotos). If you want to use
rem	a 9-pin dot matrix printer at 120x144dpi or 240x144dpi, or an HP
rem	Deskjet 520 at 600x300dpi, append the following lines to the file
rem	modes.mf and regenerate the plain base.
rem
rem	mode_def epsmed =		% Epson-FX at 240x144dpi
rem		mode_param (pixels_per_inch, 240);
rem		mode_param (aspect_ratio, 144 / pixels_per_inch);
rem		EpsonMXFX_;
rem	enddef;
rem
rem	mode_def epsmedl =		% Lanscape version of epsmed
rem		epsmed_;
rem		landscape;
rem	enddef;
rem
rem	mode_def epswlo =		% Epson-FX at 120x144dpi
rem		mode_param (pixels_per_inch, 120);
rem		mode_param (aspect_ratio, 144 / pixels_per_inch);
rem		EpsonMXFX_;
rem	enddef;
rem
rem	mode_def epswlol =		% Landscape version of epswlo
rem		epswlo_;
rem		landscape;
rem	enddef;
rem
rem	mode_def DJFiveTwenty =		% HP Deskjet at 600x300dpi
rem		mode_param (pixels_per_inch,600);
rem		mode_param (aspect_ratio, 300 / pixels_per_inch);
rem		deskjet_;
rem	enddef;
rem
rem	mode_def DJFiveTwentyl =	% Landscape version of DJFiveTwenty
rem		DJFiveTwenty_;
rem		landscape;
rem	enddef;
rem
rem	If metafont does not recognize any other modes, it will generate
rem	its standard proofing fonts which are HUGE and inappropriate for
rem	your device. In that case, get the file modes.mf from CTAN and
rem	generate the plain base again using the command:
rem		inimf plain;input modes;dump
rem	Then you need to copy plain.bas to the appropriate directory. You
rem	may need to replace "inimf" by "mf -i" for some Metafont versions.
rem
rem	Here are the parameters passed by dviwin:
rem		%1:	fontname	(truncated to 8 chars)
rem		%2:	magstep
rem		%3:	xres		(hor. resolution of font)
rem		%4:	yres	        (vert. resolution of font)
rem		%5:	xbase		(base hor. resolution)
rem		%6:	ybase		(base vert. resolution)
rem		%7:	drive		(of current dvi file)
rem		%8:	path		(of current dvi file)
rem		%9:	gf extension	(truncated to 3 chars)
rem
rem	In most cases, you will only need to modify the next four statements:
set MF=mf
set PK_BASE=%DVIFONTS%
set PK_DIR=%PK_BASE%\%3x%4
if %5==%6 set PK_DIR=%PK_BASE%\%3

rem	If the font already exists, don't do anything
if exist %PK_DIR%\%1.pk goto GETOUT

rem	If you want to switch to the directory of the current dvi file,
rem	uncomment the next two statements. This is useful if you prefer
rem	to keep some mf sources in the dvi file directory instead of the
rem	MFINPUTS directory.
rem %7:
rem cd %8

rem	Initialize device and magstep to empty
set PK_DEV=
set PK_MAG=

rem	Devices with non-square pixels; we support the following modes:
rem	epsdrft (9-pin 120x72dpi), epswlo (9-pin 120x144dpi), epsmed
rem	(9-pin 240x144dpi), epson (9-pin 240x216dpi), lqmed (24-pin
rem	360x180dpi) and DJFiveTwenty (600x300dpi), as well as their
rem	landscape versions.

if %5==%6 goto SQUARE_PIXELS
set PK_MAG=%2
if %6==300	set PK_DEV=DJFiveTwenty
if %6==72	set PK_DEV=epsdrft
if %6==216	set PK_DEV=epson
if %6==180	set PK_DEV=lqmed
if %6==144	goto FX_LOMED
if %5==300	set PK_DEV=DJFiveTwentyl
if %5==72	set PK_DEV=epsdrftl
if %5==216	set PK_DEV=epsonl
if %5==180	set PK_DEV=lqmedl
if %5==144	goto LAND_FX_LOMED
goto DO_IT
:FX_LOMED
if %5==120	set PK_DEV=epswlo
if %5==240	set PK_DEV=epsmed
goto DO_IT
:LAND_FX_LOMED
if %6==120	set PK_DEV=epswlol
if %6==240	set PK_DEV=epsmedl
goto DO_IT


rem	Devices with square pixels. The current code supports the resolutions
rem	used by the Beebe drivers for the screen, 300dpi and 400dpi laser
rem	and inkjet printers, 600dpi laserjets, 24-pin printers at 180x180
rem	and 360x360dpi.

:SQUARE_PIXELS
if %5==180	set PK_DEV=lqlores
if %5==360	set PK_DEV=lqhires
if %5==300	set PK_DEV=hplaser
if %5==400	set PK_DEV=nexthi
if %5==600	set PK_DEV=ljfour
if +%PK_DEV%==+ goto OTHER_SQ
set PK_MAG=%2
goto DO_IT
:OTHER_SQ
if %3==58	set PK_MAG=-9
if %3==64	set PK_MAG=-8.5
if %3==70	set PK_MAG=-8
if %3==76	set PK_MAG=-7.5
if %3==84	set PK_MAG=-7
if %3==92	set PK_MAG=-6.5
if %3==100	set PK_MAG=-6
if %3==110	set PK_MAG=-5.5
if %3==121	set PK_MAG=-5
if %3==132	set PK_MAG=-4.5
if %3==145	set PK_MAG=-4
if %3==158	set PK_MAG=-3.5
if %3==174	set PK_MAG=-3
if %3==190	set PK_MAG=-2.5
if %3==208	set PK_MAG=-2
if %3==228	set PK_MAG=-1.5
if %3==250	set PK_MAG=-1
if %3==274	set PK_MAG=-0.5
if %3==300	set PK_MAG=0
if %3==329	set PK_MAG=0.5
if %3==360	set PK_MAG=1
if %3==394	set PK_MAG=1.5
if %3==432	set PK_MAG=2
if %3==473	set PK_MAG=2.5
if %3==518	set PK_MAG=3
if %3==568	set PK_MAG=3.5
if %3==622	set PK_MAG=4
if %3==681	set PK_MAG=4.5
if %3==746	set PK_MAG=5
if %3==818	set PK_MAG=5.5
if %3==896	set PK_MAG=6
if %3==981	set PK_MAG=6.5
if %3==1075	set PK_MAG=7
if %3==1178	set PK_MAG=7.5
if %3==1290	set PK_MAG=8
if NOT +%PK_MAG%==+ set PK_DEV=hplaser

:DO_IT
if +%PK_DEV%==+	goto UNKNOWN
echo on
%MF% \scrollmode;mode:=%PK_DEV%;mag:=magstep(%PK_MAG%);input %1
@echo off
if errorlevel 1 goto ERROR_EXIT

rem	Find out if the directories already exist to avoid
rem	any warning messages
if not exist %PK_BASE%\nul md %PK_BASE%
if not exist %PK_DIR%\nul  md %PK_DIR%

rem	This stupid trick is necessary because some versions of Metafont
rem	use an extension of NNNgf (where NNN is the hor. resolution) and
rem	truncate it to 3 chars. while other versions use just NNN which
rem	they also truncate to 3 chars.
set GF_EXT=%3
if exist %1.%9 set GF_EXT=%9

gftopk %1.%GF_EXT%  %PK_DIR%\%1.pk
del %1.%GF_EXT%
del %1.log

rem	If you want to copy the TFM file to an appropriate directory,
rem	here is the place to do it.
del %1.tfm
goto GETOUT

:UNKNOWN
echo I don't know the metafont mode for this device. Please
echo add this information to the file %0

:ERROR_EXIT
rem	The next line creates a small file in the TEMP directory. This
rem	signals the error to the "genall.bat" file, so it doesn't call
rem	dviwin again when running under NT.
echo ERROR > %TEMP%\error$_$
pause

:GETOUT
