//========================================================================
//
// annot_stamp_departmental.h
//
// Copyright (C) 2021 Mahmoud Ahmed Khalil <mahmoudkhalil11@gmail.com>
// Copyright (C) 2021 Albert Astals Cid <aacid@kde.org>
//
// Mechanically extracted from an SVG created for Okular by Eugene Trounev eugene.trounev@gmail.com
//
// Licensed under GPLv2 or later
//
//========================================================================

#ifndef ANNOT_STAMP_DEPARTMENTAL_H
#define ANNOT_STAMP_DEPARTMENTAL_H

#include "Dict.h"
#include "Object.h"
#include "PDFDoc.h"

static const double ANNOT_STAMP_DEPARTMENTAL_WIDTH = 170.508179;
static const double ANNOT_STAMP_DEPARTMENTAL_HEIGHT = 26.484743;

static const char *ANNOT_STAMP_DEPARTMENTAL = "1 0 0 -1 0 26.484741 cm\n"
                                              "q\n"
                                              "1 1 1 rg /a0 gs\n"
                                              "3.406 2.129 m 167.117 2.129 l 167.816 2.129 168.387 2.828 168.387 3.398\n"
                                              " c 168.387 23.09 l 168.387 23.789 167.82 24.359 167.117 24.359 c 3.406 24.359\n"
                                              " l 2.707 24.359 2.137 23.66 2.137 23.09 c 2.137 3.398 l 2.137 2.699 2.703\n"
                                              " 2.129 3.406 2.129 c h\n"
                                              "3.406 2.129 m f\n"
                                              "0 0.298039 0.431373 rg /a1 gs\n"
                                              "28.543 13.016 m 28.543 14.297 28.352 15.426 27.965 16.402 c 27.578 17.371\n"
                                              " 27.051 18.184 26.379 18.84 c 25.707 19.496 24.914 19.992 23.996 20.324 \n"
                                              "c 23.086 20.66 22.102 20.828 21.047 20.828 c 14.82 20.828 l 14.82 5.434 \n"
                                              "l 20.395 5.434 l 21.59 5.434 22.684 5.582 23.684 5.883 c 24.68 6.18 25.543\n"
                                              " 6.641 26.262 7.258 c 26.984 7.879 27.543 8.664 27.945 9.617 c 28.348 10.57\n"
                                              " 28.547 11.703 28.547 13.016 c 25.301 13.016 m 25.301 12.121 25.176 11.352\n"
                                              " 24.93 10.711 c 24.688 10.07 24.352 9.547 23.914 9.137 c 23.477 8.723 22.953\n"
                                              " 8.414 22.34 8.219 c 21.734 8.023 21.066 7.922 20.328 7.922 c 18.043 7.926\n"
                                              " l 18.043 18.34 l 20.773 18.34 l 21.422 18.34 22.02 18.227 22.566 18 c 23.121\n"
                                              " 17.773 23.598 17.438 23.996 16.996 c 24.402 16.543 24.723 15.988 24.945\n"
                                              " 15.324 c 25.18 14.66 25.297 13.895 25.297 13.02 c 35.895 21.051 m 35.043\n"
                                              " 21.051 34.273 20.926 33.59 20.68 c 32.914 20.426 32.332 20.043 31.852 19.531\n"
                                              " c 31.371 19.016 31.004 18.371 30.746 17.598 c 30.492 16.816 30.363 15.906\n"
                                              " 30.363 14.867 c 30.363 13.738 30.512 12.789 30.812 12.016 c 31.117 11.242\n"
                                              " 31.527 10.621 32.035 10.148 c 32.551 9.668 33.145 9.32 33.816 9.109 c 34.488\n"
                                              " 8.898 35.191 8.793 35.938 8.793 c 36.871 8.793 37.664 8.957 38.32 9.285\n"
                                              " c 38.984 9.605 39.527 10.059 39.949 10.641 c 40.371 11.223 40.68 11.922\n"
                                              " 40.879 12.738 c 41.074 13.547 41.176 14.441 41.176 15.426 c 41.176 15.512\n"
                                              " l 33.594 15.508 l 33.594 16.004 33.637 16.465 33.727 16.895 c 33.812 17.316\n"
                                              " 33.957 17.684 34.152 18 c 34.348 18.305 34.605 18.551 34.918 18.73 c 35.23\n"
                                              " 18.906 35.609 18.992 36.055 18.992 c 36.594 18.992 37.035 18.879 37.375\n"
                                              " 18.652 c 37.719 18.418 37.961 18.062 38.105 17.582 c 41 17.832 l 40.867\n"
                                              " 18.168 40.684 18.523 40.441 18.902 c 40.207 19.281 39.895 19.629 39.5 19.953\n"
                                              " c 39.105 20.266 38.613 20.527 38.023 20.738 c 37.441 20.941 36.73 21.043\n"
                                              " 35.895 21.043 c 35.895 10.719 m 35.582 10.719 35.285 10.773 35.008 10.883\n"
                                              " c 34.738 10.984 34.5 11.152 34.297 11.387 c 34.102 11.613 33.941 11.906\n"
                                              " 33.816 12.273 c 33.691 12.637 33.625 13.074 33.609 13.586 c 38.199 13.586\n"
                                              " l 38.141 12.633 37.91 11.918 37.512 11.445 c 37.109 10.965 36.57 10.723\n"
                                              " 35.895 10.723 c 54.699 14.863 m 54.699 15.758 54.609 16.586 54.426 17.344\n"
                                              " c 54.25 18.102 53.977 18.754 53.605 19.301 c 53.234 19.848 52.762 20.277\n"
                                              " 52.184 20.59 c 51.617 20.895 50.941 21.047 50.164 21.047 c 49.812 21.047\n"
                                              " 49.465 21.012 49.113 20.938 c 48.77 20.863 48.441 20.75 48.129 20.586 c\n"
                                              " 47.816 20.418 47.523 20.203 47.254 19.941 c 46.992 19.672 46.766 19.34 \n"
                                              "46.578 18.945 c 46.512 18.945 l 46.52 18.98 46.527 19.074 46.535 19.219 \n"
                                              "c 46.543 19.363 46.551 19.535 46.559 19.73 c 46.566 19.918 46.57 20.125 \n"
                                              "46.57 20.344 c 46.578 20.555 46.582 20.75 46.582 20.934 c 46.582 25.469 \n"
                                              "l 43.512 25.473 l 43.512 11.727 l 43.512 11.121 43.5 10.582 43.48 10.109\n"
                                              " c 43.465 9.637 43.449 9.27 43.426 9.004 c 46.41 9.004 l 46.426 9.055 46.438\n"
                                              " 9.152 46.453 9.301 c 46.477 9.445 46.488 9.613 46.496 9.805 c 46.512 9.992\n"
                                              " 46.523 10.191 46.527 10.395 c 46.535 10.598 46.539 10.777 46.539 10.93 \n"
                                              "c 46.582 10.93 l 46.953 10.148 47.465 9.594 48.113 9.258 c 48.762 8.922 \n"
                                              "49.512 8.754 50.363 8.754 c 51.113 8.754 51.762 8.906 52.309 9.211 c 52.855\n"
                                              " 9.516 53.305 9.938 53.652 10.477 c 54.008 11.016 54.273 11.66 54.438 12.41\n"
                                              " c 54.613 13.152 54.699 13.969 54.699 14.859 c 51.496 14.859 m 51.496 13.512\n"
                                              " 51.293 12.516 50.883 11.867 c 50.477 11.211 49.867 10.883 49.059 10.883\n"
                                              " c 48.754 10.883 48.445 10.949 48.141 11.078 c 47.844 11.203 47.574 11.422\n"
                                              " 47.332 11.734 c 47.098 12.039 46.906 12.457 46.754 12.98 c 46.609 13.496\n"
                                              " 46.535 14.152 46.535 14.949 c 46.535 15.723 46.609 16.367 46.754 16.883\n"
                                              " c 46.898 17.395 47.09 17.801 47.32 18.105 c 47.562 18.41 47.832 18.629 \n"
                                              "48.129 18.762 c 48.426 18.887 48.73 18.949 49.035 18.949 c 49.43 18.949 \n"
                                              "49.777 18.871 50.086 18.719 c 50.391 18.559 50.648 18.316 50.852 17.988 \n"
                                              "c 51.062 17.652 51.223 17.227 51.332 16.711 c 51.441 16.195 51.496 15.578\n"
                                              " 51.496 14.863 c 59.922 21.047 m 59.355 21.047 58.844 20.969 58.391 20.816\n"
                                              " c 57.945 20.656 57.566 20.426 57.254 20.129 c 56.941 19.824 56.699 19.449\n"
                                              " 56.531 19.004 c 56.363 18.559 56.281 18.055 56.281 17.484 c 56.281 16.785\n"
                                              " 56.402 16.199 56.641 15.727 c 56.887 15.246 57.223 14.859 57.645 14.566\n"
                                              " c 58.066 14.27 58.562 14.055 59.129 13.922 c 59.695 13.785 60.301 13.711\n"
                                              " 60.941 13.703 c 63.488 13.66 l 63.488 13.059 l 63.488 12.629 63.449 12.273\n"
                                              " 63.367 11.988 c 63.293 11.695 63.184 11.461 63.039 11.277 c 62.895 11.094\n"
                                              " 62.711 10.969 62.492 10.895 c 62.281 10.812 62.035 10.773 61.762 10.773\n"
                                              " c 61.508 10.773 61.277 10.801 61.074 10.852 c 60.879 10.902 60.707 10.992\n"
                                              " 60.562 11.125 c 60.418 11.25 60.297 11.422 60.203 11.637 c 60.117 11.848\n"
                                              " 60.055 12.117 60.016 12.445 c 56.824 12.297 l 56.91 11.781 57.07 11.309\n"
                                              " 57.305 10.887 c 57.539 10.457 57.859 10.086 58.266 9.773 c 58.68 9.461 \n"
                                              "59.188 9.219 59.785 9.051 c 60.391 8.875 61.098 8.789 61.906 8.789 c 62.641\n"
                                              " 8.789 63.297 8.879 63.875 9.062 c 64.449 9.246 64.938 9.52 65.34 9.883 \n"
                                              "c 65.742 10.238 66.047 10.68 66.258 11.203 c 66.469 11.727 66.574 12.336\n"
                                              " 66.574 13.027 c 66.574 17.332 l 66.574 17.609 66.586 17.855 66.605 18.074\n"
                                              " c 66.633 18.293 66.684 18.477 66.746 18.633 c 66.82 18.777 66.918 18.891\n"
                                              " 67.043 18.973 c 67.176 19.047 67.34 19.082 67.547 19.082 c 67.781 19.082\n"
                                              " 68.004 19.059 68.223 19.016 c 68.223 20.676 l 68.039 20.719 67.875 20.758\n"
                                              " 67.73 20.797 c 67.586 20.832 67.438 20.863 67.293 20.883 c 67.148 20.906\n"
                                              " 66.992 20.922 66.824 20.938 c 66.664 20.953 66.473 20.961 66.258 20.961\n"
                                              " c 65.484 20.961 64.914 20.773 64.543 20.395 c 64.18 20.016 63.961 19.457\n"
                                              " 63.887 18.723 c 63.82 18.723 l 63.414 19.457 62.887 20.031 62.246 20.438\n"
                                              " c 61.613 20.844 60.84 21.051 59.93 21.051 c 63.504 15.359 m 61.93 15.383\n"
                                              " l 61.602 15.398 61.289 15.426 60.988 15.469 c 60.695 15.504 60.438 15.59\n"
                                              " 60.211 15.719 c 59.992 15.844 59.816 16.023 59.688 16.266 c 59.555 16.508\n"
                                              " 59.492 16.832 59.492 17.25 c 59.492 17.812 59.621 18.23 59.875 18.508 c\n"
                                              " 60.137 18.777 60.484 18.91 60.914 18.91 c 61.309 18.91 61.664 18.828 61.984\n"
                                              " 18.66 c 62.305 18.492 62.574 18.273 62.793 18.004 c 63.02 17.727 63.195\n"
                                              " 17.41 63.316 17.055 c 63.441 16.699 63.504 16.332 63.504 15.961 c 63.504\n"
                                              " 15.359 l 69.656 20.832 m 69.652 11.781 l 69.652 11.527 69.648 11.258 69.641\n"
                                              " 10.973 c 69.641 10.688 69.633 10.418 69.617 10.164 c 69.609 9.902 69.602\n"
                                              " 9.668 69.594 9.465 c 69.586 9.254 69.574 9.102 69.562 9.008 c 72.492 9.008\n"
                                              " l 72.508 9.094 72.52 9.25 72.535 9.465 c 72.551 9.676 72.562 9.91 72.578\n"
                                              " 10.164 c 72.594 10.418 72.605 10.676 72.609 10.93 c 72.625 11.176 72.633\n"
                                              " 11.379 72.633 11.531 c 72.676 11.531 l 72.828 11.102 72.98 10.719 73.133\n"
                                              " 10.383 c 73.285 10.039 73.465 9.754 73.668 9.52 c 73.879 9.277 74.129 9.098\n"
                                              " 74.422 8.973 c 74.715 8.84 75.074 8.777 75.504 8.777 c 75.688 8.777 75.863\n"
                                              " 8.797 76.039 8.832 c 76.223 8.859 76.359 8.898 76.453 8.941 c 76.453 11.508\n"
                                              " l 76.258 11.465 76.055 11.426 75.852 11.398 c 75.656 11.363 75.418 11.344\n"
                                              " 75.141 11.344 c 74.375 11.344 73.777 11.652 73.348 12.273 c 72.926 12.895\n"
                                              " 72.715 13.809 72.715 15.027 c 72.715 20.828 l 69.645 20.828 l 81.367 21.023\n"
                                              " m 80.465 21.023 79.77 20.781 79.281 20.293 c 78.793 19.797 78.551 19.051\n"
                                              " 78.551 18.055 c 78.551 11.082 l 77.055 11.082 l 77.055 9.008 l 78.703 9.008\n"
                                              " l 79.664 6.23 l 81.586 6.23 l 81.586 9.008 l 83.824 9.008 l 83.824 11.082\n"
                                              " l 81.586 11.082 l 81.594 17.223 l 81.594 17.797 81.703 18.223 81.922 18.5\n"
                                              " c 82.141 18.77 82.48 18.902 82.938 18.902 c 83.125 18.902 83.297 18.887\n"
                                              " 83.449 18.859 c 83.602 18.832 83.773 18.793 83.961 18.75 c 83.961 20.652\n"
                                              " l 83.582 20.777 83.18 20.867 82.758 20.926 c 82.336 20.992 81.871 21.023\n"
                                              " 81.371 21.023 c 92.777 20.828 m 92.777 14.195 l 92.777 13.738 92.746 13.316\n"
                                              " 92.68 12.938 c 92.621 12.551 92.52 12.223 92.375 11.953 c 92.238 11.676\n"
                                              " 92.051 11.461 91.816 11.309 c 91.59 11.156 91.312 11.078 90.984 11.078 \n"
                                              "c 90.672 11.078 90.387 11.16 90.133 11.328 c 89.879 11.488 89.656 11.723\n"
                                              " 89.465 12.027 c 89.281 12.324 89.141 12.688 89.039 13.109 c 88.938 13.523\n"
                                              " 88.887 13.984 88.887 14.484 c 88.887 20.82 l 85.816 20.82 l 85.824 11.652\n"
                                              " l 85.824 11.398 85.82 11.137 85.812 10.867 c 85.812 10.598 85.805 10.344\n"
                                              " 85.789 10.102 c 85.781 9.855 85.773 9.637 85.766 9.445 c 85.758 9.25 85.746\n"
                                              " 9.102 85.734 9.008 c 88.664 9.008 l 88.68 9.094 88.691 9.238 88.707 9.434\n"
                                              " c 88.723 9.621 88.734 9.836 88.75 10.066 c 88.766 10.301 88.777 10.531 \n"
                                              "88.781 10.766 c 88.797 11 88.805 11.195 88.805 11.355 c 88.848 11.355 l \n"
                                              "89.227 10.453 89.695 9.797 90.258 9.387 c 90.824 8.98 91.504 8.773 92.289\n"
                                              " 8.773 c 93.191 8.773 93.918 8.996 94.465 9.441 c 95.02 9.879 95.391 10.516\n"
                                              " 95.578 11.355 c 95.645 11.355 l 95.855 10.867 96.082 10.461 96.32 10.133\n"
                                              " c 96.566 9.805 96.836 9.543 97.129 9.348 c 97.426 9.145 97.75 8.996 98.09\n"
                                              " 8.91 c 98.441 8.824 98.816 8.777 99.227 8.777 c 99.875 8.777 100.422 8.895\n"
                                              " 100.867 9.129 c 101.32 9.363 101.684 9.684 101.961 10.09 c 102.246 10.496\n"
                                              " 102.449 10.98 102.574 11.531 c 102.707 12.086 102.77 12.684 102.77 13.324\n"
                                              " c 102.77 20.832 l 99.723 20.832 l 99.723 14.199 l 99.723 13.742 99.691 \n"
                                              "13.32 99.625 12.941 c 99.566 12.555 99.465 12.227 99.32 11.957 c 99.184 \n"
                                              "11.68 98.996 11.465 98.762 11.312 c 98.535 11.16 98.258 11.082 97.93 11.082\n"
                                              " c 97.625 11.082 97.344 11.164 97.09 11.324 c 96.844 11.477 96.625 11.699\n"
                                              " 96.434 11.992 c 96.25 12.277 96.109 12.617 96.008 13.02 c 95.906 13.422\n"
                                              " 95.848 13.863 95.832 14.352 c 95.832 20.832 l 92.785 20.832 l 110.551 21.051\n"
                                              " m 109.699 21.051 108.93 20.926 108.246 20.68 c 107.57 20.426 106.988 20.043\n"
                                              " 106.508 19.531 c 106.027 19.016 105.66 18.371 105.402 17.598 c 105.148 \n"
                                              "16.816 105.02 15.906 105.02 14.867 c 105.02 13.738 105.168 12.789 105.469\n"
                                              " 12.016 c 105.773 11.242 106.184 10.621 106.691 10.148 c 107.207 9.668 107.801\n"
                                              " 9.32 108.473 9.109 c 109.145 8.898 109.848 8.793 110.594 8.793 c 111.527\n"
                                              " 8.793 112.32 8.957 112.977 9.285 c 113.641 9.605 114.184 10.059 114.605\n"
                                              " 10.641 c 115.027 11.223 115.336 11.922 115.535 12.738 c 115.73 13.547 115.832\n"
                                              " 14.441 115.832 15.426 c 115.832 15.512 l 108.25 15.512 l 108.25 16.008 \n"
                                              "108.293 16.469 108.383 16.898 c 108.469 17.32 108.613 17.688 108.809 18.004\n"
                                              " c 109.004 18.309 109.262 18.555 109.574 18.734 c 109.887 18.91 110.266 \n"
                                              "18.996 110.711 18.996 c 111.25 18.996 111.691 18.883 112.031 18.656 c 112.375\n"
                                              " 18.422 112.617 18.066 112.762 17.586 c 115.656 17.836 l 115.523 18.172 \n"
                                              "115.34 18.527 115.098 18.906 c 114.863 19.285 114.551 19.633 114.156 19.957\n"
                                              " c 113.762 20.27 113.27 20.531 112.68 20.742 c 112.098 20.945 111.387 21.047\n"
                                              " 110.551 21.047 c 110.551 10.723 m 110.238 10.723 109.941 10.777 109.664\n"
                                              " 10.887 c 109.395 10.988 109.156 11.156 108.953 11.391 c 108.758 11.617 \n"
                                              "108.598 11.91 108.473 12.277 c 108.348 12.641 108.281 13.078 108.266 13.59\n"
                                              " c 112.855 13.59 l 112.797 12.637 112.566 11.922 112.168 11.449 c 111.766\n"
                                              " 10.969 111.227 10.727 110.551 10.727 c 125.828 20.832 m 125.828 14.199 \n"
                                              "l 125.828 13.742 125.793 13.32 125.719 12.941 c 125.645 12.555 125.527 12.227\n"
                                              " 125.359 11.957 c 125.191 11.68 124.973 11.465 124.703 11.312 c 124.434 \n"
                                              "11.16 124.105 11.082 123.719 11.082 c 123.348 11.082 123.008 11.164 122.703\n"
                                              " 11.332 c 122.406 11.492 122.145 11.727 121.926 12.031 c 121.707 12.328 \n"
                                              "121.535 12.691 121.414 13.113 c 121.297 13.527 121.238 13.988 121.238 14.488\n"
                                              " c 121.238 20.824 l 118.168 20.824 l 118.168 11.652 l 118.168 11.398 118.164\n"
                                              " 11.137 118.156 10.867 c 118.156 10.598 118.148 10.344 118.133 10.102 c \n"
                                              "118.125 9.855 118.117 9.637 118.109 9.445 c 118.102 9.25 118.09 9.102 118.078\n"
                                              " 9.008 c 121.008 9.008 l 121.023 9.094 121.035 9.238 121.051 9.434 c 121.066\n"
                                              " 9.621 121.078 9.836 121.094 10.066 c 121.109 10.301 121.121 10.531 121.125\n"
                                              " 10.766 c 121.141 11 121.148 11.195 121.148 11.355 c 121.191 11.355 l 121.605\n"
                                              " 10.453 122.129 9.797 122.754 9.387 c 123.379 8.98 124.129 8.773 124.992\n"
                                              " 8.773 c 125.707 8.773 126.309 8.891 126.797 9.125 c 127.293 9.359 127.691\n"
                                              " 9.68 128 10.086 c 128.312 10.492 128.539 10.977 128.676 11.527 c 128.812\n"
                                              " 12.082 128.883 12.68 128.883 13.32 c 128.883 20.828 l 125.824 20.828 l \n"
                                              "134.871 21.023 m 133.969 21.023 133.273 20.781 132.785 20.293 c 132.297 \n"
                                              "19.797 132.055 19.051 132.055 18.055 c 132.055 11.082 l 130.559 11.082 l\n"
                                              " 130.559 9.008 l 132.207 9.008 l 133.168 6.23 l 135.09 6.23 l 135.09 9.008\n"
                                              " l 137.328 9.008 l 137.328 11.082 l 135.094 11.082 l 135.094 17.223 l 135.094\n"
                                              " 17.797 135.203 18.223 135.422 18.5 c 135.641 18.77 135.98 18.902 136.438\n"
                                              " 18.902 c 136.625 18.902 136.797 18.887 136.949 18.859 c 137.102 18.832 \n"
                                              "137.273 18.793 137.461 18.75 c 137.461 20.652 l 137.082 20.777 136.68 20.867\n"
                                              " 136.258 20.926 c 135.836 20.992 135.371 21.023 134.871 21.023 c 142.051\n"
                                              " 21.047 m 141.484 21.047 140.973 20.969 140.52 20.816 c 140.074 20.656 139.695\n"
                                              " 20.426 139.383 20.129 c 139.07 19.824 138.828 19.449 138.66 19.004 c 138.492\n"
                                              " 18.559 138.41 18.055 138.41 17.484 c 138.41 16.785 138.531 16.199 138.77\n"
                                              " 15.727 c 139.016 15.246 139.352 14.859 139.773 14.566 c 140.195 14.27 140.691\n"
                                              " 14.055 141.258 13.922 c 141.824 13.785 142.43 13.711 143.07 13.703 c 145.617\n"
                                              " 13.66 l 145.617 13.059 l 145.617 12.629 145.578 12.273 145.496 11.988 c\n"
                                              " 145.422 11.695 145.312 11.461 145.168 11.277 c 145.023 11.094 144.84 10.969\n"
                                              " 144.621 10.895 c 144.41 10.812 144.164 10.773 143.891 10.773 c 143.637 \n"
                                              "10.773 143.406 10.801 143.203 10.852 c 143.008 10.902 142.836 10.992 142.691\n"
                                              " 11.125 c 142.547 11.25 142.426 11.422 142.332 11.637 c 142.246 11.848 142.184\n"
                                              " 12.117 142.145 12.445 c 138.941 12.293 l 139.027 11.777 139.188 11.305 \n"
                                              "139.422 10.883 c 139.656 10.453 139.977 10.082 140.383 9.77 c 140.797 9.457\n"
                                              " 141.305 9.215 141.902 9.047 c 142.508 8.871 143.215 8.785 144.023 8.785\n"
                                              " c 144.758 8.785 145.414 8.875 145.992 9.059 c 146.566 9.242 147.055 9.516\n"
                                              " 147.457 9.879 c 147.859 10.234 148.164 10.676 148.375 11.199 c 148.586 \n"
                                              "11.723 148.691 12.332 148.691 13.023 c 148.691 17.328 l 148.691 17.605 148.703\n"
                                              " 17.852 148.723 18.07 c 148.75 18.289 148.801 18.473 148.863 18.629 c 148.938\n"
                                              " 18.773 149.035 18.887 149.16 18.969 c 149.293 19.043 149.457 19.078 149.664\n"
                                              " 19.078 c 149.898 19.078 150.121 19.055 150.34 19.012 c 150.34 20.672 l \n"
                                              "150.156 20.715 149.992 20.754 149.848 20.793 c 149.703 20.828 149.555 20.859\n"
                                              " 149.41 20.879 c 149.266 20.902 149.109 20.918 148.941 20.934 c 148.781 \n"
                                              "20.949 148.59 20.957 148.375 20.957 c 147.602 20.957 147.031 20.77 146.66\n"
                                              " 20.391 c 146.297 20.012 146.078 19.453 146.004 18.719 c 145.938 18.719 \n"
                                              "l 145.531 19.453 145.004 20.027 144.363 20.434 c 143.73 20.84 142.957 21.047\n"
                                              " 142.047 21.047 c 145.621 15.355 m 144.047 15.379 l 143.719 15.395 143.406\n"
                                              " 15.422 143.105 15.465 c 142.812 15.5 142.555 15.586 142.328 15.715 c 142.109\n"
                                              " 15.84 141.934 16.02 141.805 16.262 c 141.672 16.504 141.609 16.828 141.609\n"
                                              " 17.246 c 141.609 17.809 141.738 18.227 141.992 18.504 c 142.254 18.773 \n"
                                              "142.602 18.906 143.031 18.906 c 143.426 18.906 143.781 18.824 144.102 18.656\n"
                                              " c 144.422 18.488 144.691 18.27 144.91 18 c 145.137 17.723 145.312 17.406\n"
                                              " 145.434 17.051 c 145.559 16.695 145.621 16.328 145.621 15.957 c 145.621\n"
                                              " 15.355 l 151.773 20.828 m 151.777 4.613 l 154.848 4.613 l 154.848 20.828\n"
                                              " l 151.777 20.828 l f\n"
                                              "1 1 1 RG 0.531496 w\n"
                                              "0 J\n"
                                              "0 j\n"
                                              "[] 0.0 d\n"
                                              "4 M q 1 0 0 1 0 0 cm\n"
                                              "28.543 13.016 m 28.543 14.297 28.352 15.426 27.965 16.402 c 27.578 17.371\n"
                                              " 27.051 18.184 26.379 18.84 c 25.707 19.496 24.914 19.992 23.996 20.324 \n"
                                              "c 23.086 20.66 22.102 20.828 21.047 20.828 c 14.82 20.828 l 14.82 5.434 \n"
                                              "l 20.395 5.434 l 21.59 5.434 22.684 5.582 23.684 5.883 c 24.68 6.18 25.543\n"
                                              " 6.641 26.262 7.258 c 26.984 7.879 27.543 8.664 27.945 9.617 c 28.348 10.57\n"
                                              " 28.547 11.703 28.547 13.016 c 25.301 13.016 m 25.301 12.121 25.176 11.352\n"
                                              " 24.93 10.711 c 24.688 10.07 24.352 9.547 23.914 9.137 c 23.477 8.723 22.953\n"
                                              " 8.414 22.34 8.219 c 21.734 8.023 21.066 7.922 20.328 7.922 c 18.043 7.926\n"
                                              " l 18.043 18.34 l 20.773 18.34 l 21.422 18.34 22.02 18.227 22.566 18 c 23.121\n"
                                              " 17.773 23.598 17.438 23.996 16.996 c 24.402 16.543 24.723 15.988 24.945\n"
                                              " 15.324 c 25.18 14.66 25.297 13.895 25.297 13.02 c 35.895 21.051 m 35.043\n"
                                              " 21.051 34.273 20.926 33.59 20.68 c 32.914 20.426 32.332 20.043 31.852 19.531\n"
                                              " c 31.371 19.016 31.004 18.371 30.746 17.598 c 30.492 16.816 30.363 15.906\n"
                                              " 30.363 14.867 c 30.363 13.738 30.512 12.789 30.812 12.016 c 31.117 11.242\n"
                                              " 31.527 10.621 32.035 10.148 c 32.551 9.668 33.145 9.32 33.816 9.109 c 34.488\n"
                                              " 8.898 35.191 8.793 35.938 8.793 c 36.871 8.793 37.664 8.957 38.32 9.285\n"
                                              " c 38.984 9.605 39.527 10.059 39.949 10.641 c 40.371 11.223 40.68 11.922\n"
                                              " 40.879 12.738 c 41.074 13.547 41.176 14.441 41.176 15.426 c 41.176 15.512\n"
                                              " l 33.594 15.508 l 33.594 16.004 33.637 16.465 33.727 16.895 c 33.812 17.316\n"
                                              " 33.957 17.684 34.152 18 c 34.348 18.305 34.605 18.551 34.918 18.73 c 35.23\n"
                                              " 18.906 35.609 18.992 36.055 18.992 c 36.594 18.992 37.035 18.879 37.375\n"
                                              " 18.652 c 37.719 18.418 37.961 18.062 38.105 17.582 c 41 17.832 l 40.867\n"
                                              " 18.168 40.684 18.523 40.441 18.902 c 40.207 19.281 39.895 19.629 39.5 19.953\n"
                                              " c 39.105 20.266 38.613 20.527 38.023 20.738 c 37.441 20.941 36.73 21.043\n"
                                              " 35.895 21.043 c 35.895 10.719 m 35.582 10.719 35.285 10.773 35.008 10.883\n"
                                              " c 34.738 10.984 34.5 11.152 34.297 11.387 c 34.102 11.613 33.941 11.906\n"
                                              " 33.816 12.273 c 33.691 12.637 33.625 13.074 33.609 13.586 c 38.199 13.586\n"
                                              " l 38.141 12.633 37.91 11.918 37.512 11.445 c 37.109 10.965 36.57 10.723\n"
                                              " 35.895 10.723 c 54.699 14.863 m 54.699 15.758 54.609 16.586 54.426 17.344\n"
                                              " c 54.25 18.102 53.977 18.754 53.605 19.301 c 53.234 19.848 52.762 20.277\n"
                                              " 52.184 20.59 c 51.617 20.895 50.941 21.047 50.164 21.047 c 49.812 21.047\n"
                                              " 49.465 21.012 49.113 20.938 c 48.77 20.863 48.441 20.75 48.129 20.586 c\n"
                                              " 47.816 20.418 47.523 20.203 47.254 19.941 c 46.992 19.672 46.766 19.34 \n"
                                              "46.578 18.945 c 46.512 18.945 l 46.52 18.98 46.527 19.074 46.535 19.219 \n"
                                              "c 46.543 19.363 46.551 19.535 46.559 19.73 c 46.566 19.918 46.57 20.125 \n"
                                              "46.57 20.344 c 46.578 20.555 46.582 20.75 46.582 20.934 c 46.582 25.469 \n"
                                              "l 43.512 25.473 l 43.512 11.727 l 43.512 11.121 43.5 10.582 43.48 10.109\n"
                                              " c 43.465 9.637 43.449 9.27 43.426 9.004 c 46.41 9.004 l 46.426 9.055 46.438\n"
                                              " 9.152 46.453 9.301 c 46.477 9.445 46.488 9.613 46.496 9.805 c 46.512 9.992\n"
                                              " 46.523 10.191 46.527 10.395 c 46.535 10.598 46.539 10.777 46.539 10.93 \n"
                                              "c 46.582 10.93 l 46.953 10.148 47.465 9.594 48.113 9.258 c 48.762 8.922 \n"
                                              "49.512 8.754 50.363 8.754 c 51.113 8.754 51.762 8.906 52.309 9.211 c 52.855\n"
                                              " 9.516 53.305 9.938 53.652 10.477 c 54.008 11.016 54.273 11.66 54.438 12.41\n"
                                              " c 54.613 13.152 54.699 13.969 54.699 14.859 c 51.496 14.859 m 51.496 13.512\n"
                                              " 51.293 12.516 50.883 11.867 c 50.477 11.211 49.867 10.883 49.059 10.883\n"
                                              " c 48.754 10.883 48.445 10.949 48.141 11.078 c 47.844 11.203 47.574 11.422\n"
                                              " 47.332 11.734 c 47.098 12.039 46.906 12.457 46.754 12.98 c 46.609 13.496\n"
                                              " 46.535 14.152 46.535 14.949 c 46.535 15.723 46.609 16.367 46.754 16.883\n"
                                              " c 46.898 17.395 47.09 17.801 47.32 18.105 c 47.562 18.41 47.832 18.629 \n"
                                              "48.129 18.762 c 48.426 18.887 48.73 18.949 49.035 18.949 c 49.43 18.949 \n"
                                              "49.777 18.871 50.086 18.719 c 50.391 18.559 50.648 18.316 50.852 17.988 \n"
                                              "c 51.062 17.652 51.223 17.227 51.332 16.711 c 51.441 16.195 51.496 15.578\n"
                                              " 51.496 14.863 c 59.922 21.047 m 59.355 21.047 58.844 20.969 58.391 20.816\n"
                                              " c 57.945 20.656 57.566 20.426 57.254 20.129 c 56.941 19.824 56.699 19.449\n"
                                              " 56.531 19.004 c 56.363 18.559 56.281 18.055 56.281 17.484 c 56.281 16.785\n"
                                              " 56.402 16.199 56.641 15.727 c 56.887 15.246 57.223 14.859 57.645 14.566\n"
                                              " c 58.066 14.27 58.562 14.055 59.129 13.922 c 59.695 13.785 60.301 13.711\n"
                                              " 60.941 13.703 c 63.488 13.66 l 63.488 13.059 l 63.488 12.629 63.449 12.273\n"
                                              " 63.367 11.988 c 63.293 11.695 63.184 11.461 63.039 11.277 c 62.895 11.094\n"
                                              " 62.711 10.969 62.492 10.895 c 62.281 10.812 62.035 10.773 61.762 10.773\n"
                                              " c 61.508 10.773 61.277 10.801 61.074 10.852 c 60.879 10.902 60.707 10.992\n"
                                              " 60.562 11.125 c 60.418 11.25 60.297 11.422 60.203 11.637 c 60.117 11.848\n"
                                              " 60.055 12.117 60.016 12.445 c 56.824 12.297 l 56.91 11.781 57.07 11.309\n"
                                              " 57.305 10.887 c 57.539 10.457 57.859 10.086 58.266 9.773 c 58.68 9.461 \n"
                                              "59.188 9.219 59.785 9.051 c 60.391 8.875 61.098 8.789 61.906 8.789 c 62.641\n"
                                              " 8.789 63.297 8.879 63.875 9.062 c 64.449 9.246 64.938 9.52 65.34 9.883 \n"
                                              "c 65.742 10.238 66.047 10.68 66.258 11.203 c 66.469 11.727 66.574 12.336\n"
                                              " 66.574 13.027 c 66.574 17.332 l 66.574 17.609 66.586 17.855 66.605 18.074\n"
                                              " c 66.633 18.293 66.684 18.477 66.746 18.633 c 66.82 18.777 66.918 18.891\n"
                                              " 67.043 18.973 c 67.176 19.047 67.34 19.082 67.547 19.082 c 67.781 19.082\n"
                                              " 68.004 19.059 68.223 19.016 c 68.223 20.676 l 68.039 20.719 67.875 20.758\n"
                                              " 67.73 20.797 c 67.586 20.832 67.438 20.863 67.293 20.883 c 67.148 20.906\n"
                                              " 66.992 20.922 66.824 20.938 c 66.664 20.953 66.473 20.961 66.258 20.961\n"
                                              " c 65.484 20.961 64.914 20.773 64.543 20.395 c 64.18 20.016 63.961 19.457\n"
                                              " 63.887 18.723 c 63.82 18.723 l 63.414 19.457 62.887 20.031 62.246 20.438\n"
                                              " c 61.613 20.844 60.84 21.051 59.93 21.051 c 63.504 15.359 m 61.93 15.383\n"
                                              " l 61.602 15.398 61.289 15.426 60.988 15.469 c 60.695 15.504 60.438 15.59\n"
                                              " 60.211 15.719 c 59.992 15.844 59.816 16.023 59.688 16.266 c 59.555 16.508\n"
                                              " 59.492 16.832 59.492 17.25 c 59.492 17.812 59.621 18.23 59.875 18.508 c\n"
                                              " 60.137 18.777 60.484 18.91 60.914 18.91 c 61.309 18.91 61.664 18.828 61.984\n"
                                              " 18.66 c 62.305 18.492 62.574 18.273 62.793 18.004 c 63.02 17.727 63.195\n"
                                              " 17.41 63.316 17.055 c 63.441 16.699 63.504 16.332 63.504 15.961 c 63.504\n"
                                              " 15.359 l 69.656 20.832 m 69.652 11.781 l 69.652 11.527 69.648 11.258 69.641\n"
                                              " 10.973 c 69.641 10.688 69.633 10.418 69.617 10.164 c 69.609 9.902 69.602\n"
                                              " 9.668 69.594 9.465 c 69.586 9.254 69.574 9.102 69.562 9.008 c 72.492 9.008\n"
                                              " l 72.508 9.094 72.52 9.25 72.535 9.465 c 72.551 9.676 72.562 9.91 72.578\n"
                                              " 10.164 c 72.594 10.418 72.605 10.676 72.609 10.93 c 72.625 11.176 72.633\n"
                                              " 11.379 72.633 11.531 c 72.676 11.531 l 72.828 11.102 72.98 10.719 73.133\n"
                                              " 10.383 c 73.285 10.039 73.465 9.754 73.668 9.52 c 73.879 9.277 74.129 9.098\n"
                                              " 74.422 8.973 c 74.715 8.84 75.074 8.777 75.504 8.777 c 75.688 8.777 75.863\n"
                                              " 8.797 76.039 8.832 c 76.223 8.859 76.359 8.898 76.453 8.941 c 76.453 11.508\n"
                                              " l 76.258 11.465 76.055 11.426 75.852 11.398 c 75.656 11.363 75.418 11.344\n"
                                              " 75.141 11.344 c 74.375 11.344 73.777 11.652 73.348 12.273 c 72.926 12.895\n"
                                              " 72.715 13.809 72.715 15.027 c 72.715 20.828 l 69.645 20.828 l 81.367 21.023\n"
                                              " m 80.465 21.023 79.77 20.781 79.281 20.293 c 78.793 19.797 78.551 19.051\n"
                                              " 78.551 18.055 c 78.551 11.082 l 77.055 11.082 l 77.055 9.008 l 78.703 9.008\n"
                                              " l 79.664 6.23 l 81.586 6.23 l 81.586 9.008 l 83.824 9.008 l 83.824 11.082\n"
                                              " l 81.586 11.082 l 81.594 17.223 l 81.594 17.797 81.703 18.223 81.922 18.5\n"
                                              " c 82.141 18.77 82.48 18.902 82.938 18.902 c 83.125 18.902 83.297 18.887\n"
                                              " 83.449 18.859 c 83.602 18.832 83.773 18.793 83.961 18.75 c 83.961 20.652\n"
                                              " l 83.582 20.777 83.18 20.867 82.758 20.926 c 82.336 20.992 81.871 21.023\n"
                                              " 81.371 21.023 c 92.777 20.828 m 92.777 14.195 l 92.777 13.738 92.746 13.316\n"
                                              " 92.68 12.938 c 92.621 12.551 92.52 12.223 92.375 11.953 c 92.238 11.676\n"
                                              " 92.051 11.461 91.816 11.309 c 91.59 11.156 91.312 11.078 90.984 11.078 \n"
                                              "c 90.672 11.078 90.387 11.16 90.133 11.328 c 89.879 11.488 89.656 11.723\n"
                                              " 89.465 12.027 c 89.281 12.324 89.141 12.688 89.039 13.109 c 88.938 13.523\n"
                                              " 88.887 13.984 88.887 14.484 c 88.887 20.82 l 85.816 20.82 l 85.824 11.652\n"
                                              " l 85.824 11.398 85.82 11.137 85.812 10.867 c 85.812 10.598 85.805 10.344\n"
                                              " 85.789 10.102 c 85.781 9.855 85.773 9.637 85.766 9.445 c 85.758 9.25 85.746\n"
                                              " 9.102 85.734 9.008 c 88.664 9.008 l 88.68 9.094 88.691 9.238 88.707 9.434\n"
                                              " c 88.723 9.621 88.734 9.836 88.75 10.066 c 88.766 10.301 88.777 10.531 \n"
                                              "88.781 10.766 c 88.797 11 88.805 11.195 88.805 11.355 c 88.848 11.355 l \n"
                                              "89.227 10.453 89.695 9.797 90.258 9.387 c 90.824 8.98 91.504 8.773 92.289\n"
                                              " 8.773 c 93.191 8.773 93.918 8.996 94.465 9.441 c 95.02 9.879 95.391 10.516\n"
                                              " 95.578 11.355 c 95.645 11.355 l 95.855 10.867 96.082 10.461 96.32 10.133\n"
                                              " c 96.566 9.805 96.836 9.543 97.129 9.348 c 97.426 9.145 97.75 8.996 98.09\n"
                                              " 8.91 c 98.441 8.824 98.816 8.777 99.227 8.777 c 99.875 8.777 100.422 8.895\n"
                                              " 100.867 9.129 c 101.32 9.363 101.684 9.684 101.961 10.09 c 102.246 10.496\n"
                                              " 102.449 10.98 102.574 11.531 c 102.707 12.086 102.77 12.684 102.77 13.324\n"
                                              " c 102.77 20.832 l 99.723 20.832 l 99.723 14.199 l 99.723 13.742 99.691 \n"
                                              "13.32 99.625 12.941 c 99.566 12.555 99.465 12.227 99.32 11.957 c 99.184 \n"
                                              "11.68 98.996 11.465 98.762 11.312 c 98.535 11.16 98.258 11.082 97.93 11.082\n"
                                              " c 97.625 11.082 97.344 11.164 97.09 11.324 c 96.844 11.477 96.625 11.699\n"
                                              " 96.434 11.992 c 96.25 12.277 96.109 12.617 96.008 13.02 c 95.906 13.422\n"
                                              " 95.848 13.863 95.832 14.352 c 95.832 20.832 l 92.785 20.832 l 110.551 21.051\n"
                                              " m 109.699 21.051 108.93 20.926 108.246 20.68 c 107.57 20.426 106.988 20.043\n"
                                              " 106.508 19.531 c 106.027 19.016 105.66 18.371 105.402 17.598 c 105.148 \n"
                                              "16.816 105.02 15.906 105.02 14.867 c 105.02 13.738 105.168 12.789 105.469\n"
                                              " 12.016 c 105.773 11.242 106.184 10.621 106.691 10.148 c 107.207 9.668 107.801\n"
                                              " 9.32 108.473 9.109 c 109.145 8.898 109.848 8.793 110.594 8.793 c 111.527\n"
                                              " 8.793 112.32 8.957 112.977 9.285 c 113.641 9.605 114.184 10.059 114.605\n"
                                              " 10.641 c 115.027 11.223 115.336 11.922 115.535 12.738 c 115.73 13.547 115.832\n"
                                              " 14.441 115.832 15.426 c 115.832 15.512 l 108.25 15.512 l 108.25 16.008 \n"
                                              "108.293 16.469 108.383 16.898 c 108.469 17.32 108.613 17.688 108.809 18.004\n"
                                              " c 109.004 18.309 109.262 18.555 109.574 18.734 c 109.887 18.91 110.266 \n"
                                              "18.996 110.711 18.996 c 111.25 18.996 111.691 18.883 112.031 18.656 c 112.375\n"
                                              " 18.422 112.617 18.066 112.762 17.586 c 115.656 17.836 l 115.523 18.172 \n"
                                              "115.34 18.527 115.098 18.906 c 114.863 19.285 114.551 19.633 114.156 19.957\n"
                                              " c 113.762 20.27 113.27 20.531 112.68 20.742 c 112.098 20.945 111.387 21.047\n"
                                              " 110.551 21.047 c 110.551 10.723 m 110.238 10.723 109.941 10.777 109.664\n"
                                              " 10.887 c 109.395 10.988 109.156 11.156 108.953 11.391 c 108.758 11.617 \n"
                                              "108.598 11.91 108.473 12.277 c 108.348 12.641 108.281 13.078 108.266 13.59\n"
                                              " c 112.855 13.59 l 112.797 12.637 112.566 11.922 112.168 11.449 c 111.766\n"
                                              " 10.969 111.227 10.727 110.551 10.727 c 125.828 20.832 m 125.828 14.199 \n"
                                              "l 125.828 13.742 125.793 13.32 125.719 12.941 c 125.645 12.555 125.527 12.227\n"
                                              " 125.359 11.957 c 125.191 11.68 124.973 11.465 124.703 11.312 c 124.434 \n"
                                              "11.16 124.105 11.082 123.719 11.082 c 123.348 11.082 123.008 11.164 122.703\n"
                                              " 11.332 c 122.406 11.492 122.145 11.727 121.926 12.031 c 121.707 12.328 \n"
                                              "121.535 12.691 121.414 13.113 c 121.297 13.527 121.238 13.988 121.238 14.488\n"
                                              " c 121.238 20.824 l 118.168 20.824 l 118.168 11.652 l 118.168 11.398 118.164\n"
                                              " 11.137 118.156 10.867 c 118.156 10.598 118.148 10.344 118.133 10.102 c \n"
                                              "118.125 9.855 118.117 9.637 118.109 9.445 c 118.102 9.25 118.09 9.102 118.078\n"
                                              " 9.008 c 121.008 9.008 l 121.023 9.094 121.035 9.238 121.051 9.434 c 121.066\n"
                                              " 9.621 121.078 9.836 121.094 10.066 c 121.109 10.301 121.121 10.531 121.125\n"
                                              " 10.766 c 121.141 11 121.148 11.195 121.148 11.355 c 121.191 11.355 l 121.605\n"
                                              " 10.453 122.129 9.797 122.754 9.387 c 123.379 8.98 124.129 8.773 124.992\n"
                                              " 8.773 c 125.707 8.773 126.309 8.891 126.797 9.125 c 127.293 9.359 127.691\n"
                                              " 9.68 128 10.086 c 128.312 10.492 128.539 10.977 128.676 11.527 c 128.812\n"
                                              " 12.082 128.883 12.68 128.883 13.32 c 128.883 20.828 l 125.824 20.828 l \n"
                                              "134.871 21.023 m 133.969 21.023 133.273 20.781 132.785 20.293 c 132.297 \n"
                                              "19.797 132.055 19.051 132.055 18.055 c 132.055 11.082 l 130.559 11.082 l\n"
                                              " 130.559 9.008 l 132.207 9.008 l 133.168 6.23 l 135.09 6.23 l 135.09 9.008\n"
                                              " l 137.328 9.008 l 137.328 11.082 l 135.094 11.082 l 135.094 17.223 l 135.094\n"
                                              " 17.797 135.203 18.223 135.422 18.5 c 135.641 18.77 135.98 18.902 136.438\n"
                                              " 18.902 c 136.625 18.902 136.797 18.887 136.949 18.859 c 137.102 18.832 \n"
                                              "137.273 18.793 137.461 18.75 c 137.461 20.652 l 137.082 20.777 136.68 20.867\n"
                                              " 136.258 20.926 c 135.836 20.992 135.371 21.023 134.871 21.023 c 142.051\n"
                                              " 21.047 m 141.484 21.047 140.973 20.969 140.52 20.816 c 140.074 20.656 139.695\n"
                                              " 20.426 139.383 20.129 c 139.07 19.824 138.828 19.449 138.66 19.004 c 138.492\n"
                                              " 18.559 138.41 18.055 138.41 17.484 c 138.41 16.785 138.531 16.199 138.77\n"
                                              " 15.727 c 139.016 15.246 139.352 14.859 139.773 14.566 c 140.195 14.27 140.691\n"
                                              " 14.055 141.258 13.922 c 141.824 13.785 142.43 13.711 143.07 13.703 c 145.617\n"
                                              " 13.66 l 145.617 13.059 l 145.617 12.629 145.578 12.273 145.496 11.988 c\n"
                                              " 145.422 11.695 145.312 11.461 145.168 11.277 c 145.023 11.094 144.84 10.969\n"
                                              " 144.621 10.895 c 144.41 10.812 144.164 10.773 143.891 10.773 c 143.637 \n"
                                              "10.773 143.406 10.801 143.203 10.852 c 143.008 10.902 142.836 10.992 142.691\n"
                                              " 11.125 c 142.547 11.25 142.426 11.422 142.332 11.637 c 142.246 11.848 142.184\n"
                                              " 12.117 142.145 12.445 c 138.941 12.293 l 139.027 11.777 139.188 11.305 \n"
                                              "139.422 10.883 c 139.656 10.453 139.977 10.082 140.383 9.77 c 140.797 9.457\n"
                                              " 141.305 9.215 141.902 9.047 c 142.508 8.871 143.215 8.785 144.023 8.785\n"
                                              " c 144.758 8.785 145.414 8.875 145.992 9.059 c 146.566 9.242 147.055 9.516\n"
                                              " 147.457 9.879 c 147.859 10.234 148.164 10.676 148.375 11.199 c 148.586 \n"
                                              "11.723 148.691 12.332 148.691 13.023 c 148.691 17.328 l 148.691 17.605 148.703\n"
                                              " 17.852 148.723 18.07 c 148.75 18.289 148.801 18.473 148.863 18.629 c 148.938\n"
                                              " 18.773 149.035 18.887 149.16 18.969 c 149.293 19.043 149.457 19.078 149.664\n"
                                              " 19.078 c 149.898 19.078 150.121 19.055 150.34 19.012 c 150.34 20.672 l \n"
                                              "150.156 20.715 149.992 20.754 149.848 20.793 c 149.703 20.828 149.555 20.859\n"
                                              " 149.41 20.879 c 149.266 20.902 149.109 20.918 148.941 20.934 c 148.781 \n"
                                              "20.949 148.59 20.957 148.375 20.957 c 147.602 20.957 147.031 20.77 146.66\n"
                                              " 20.391 c 146.297 20.012 146.078 19.453 146.004 18.719 c 145.938 18.719 \n"
                                              "l 145.531 19.453 145.004 20.027 144.363 20.434 c 143.73 20.84 142.957 21.047\n"
                                              " 142.047 21.047 c 145.621 15.355 m 144.047 15.379 l 143.719 15.395 143.406\n"
                                              " 15.422 143.105 15.465 c 142.812 15.5 142.555 15.586 142.328 15.715 c 142.109\n"
                                              " 15.84 141.934 16.02 141.805 16.262 c 141.672 16.504 141.609 16.828 141.609\n"
                                              " 17.246 c 141.609 17.809 141.738 18.227 141.992 18.504 c 142.254 18.773 \n"
                                              "142.602 18.906 143.031 18.906 c 143.426 18.906 143.781 18.824 144.102 18.656\n"
                                              " c 144.422 18.488 144.691 18.27 144.91 18 c 145.137 17.723 145.312 17.406\n"
                                              " 145.434 17.051 c 145.559 16.695 145.621 16.328 145.621 15.957 c 145.621\n"
                                              " 15.355 l 151.773 20.828 m 151.777 4.613 l 154.848 4.613 l 154.848 20.828\n"
                                              " l 151.777 20.828 l S Q\n"
                                              "Q q\n"
                                              "0 0.298039 0.431373 rg /a1 gs\n"
                                              "1 1 1 RG 0.797243 w\n"
                                              "1 J\n"
                                              "1 j\n"
                                              "[] 0.0 d\n"
                                              "4 M q 1 0 0 1 0 0 cm\n"
                                              "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                              "24.715 1.77 26.086 3.398 26.086 c 167.109 26.086 l 168.738 26.086 170.109\n"
                                              " 24.715 170.109 23.086 c 170.109 3.398 l 170.109 1.77 168.738 0.398 167.109\n"
                                              " 0.398 c h\n"
                                              "3.867 3.844 m 166.664 3.844 l 166.664 22.617 l 3.867 22.617 l h\n"
                                              "3.867 3.844 m B Q\n"
                                              "Q\n";

static Dict *getDepartmentalStampExtGStateDict(PDFDoc *doc)
{
    Dict *a0Dict = new Dict(doc->getXRef());
    a0Dict->add("CA", Object(0.588235));
    a0Dict->add("ca", Object(0.588235));

    Dict *a1Dict = new Dict(doc->getXRef());
    a1Dict->add("CA", Object(1));
    a1Dict->add("ca", Object(1));

    Dict *extGStateDict = new Dict(doc->getXRef());
    extGStateDict->add("a0", Object(a0Dict));
    extGStateDict->add("a1", Object(a1Dict));

    return extGStateDict;
}

#endif
