/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.

File:   testout_T_enumeration.lex
Date:   25 July 2014
Author: Dave Bone
Purpose: 
  Supplies emitted enumeration file name and namespace. The lr1 compiler/compiler
  generates the "enum" type for the 4 classes of terminals:
	1) lr1 constants
	2) raw characters
	3) errors
	4) terminals
 Note:	
	The enumerated type is emitted which is referenced in the other
	emitted grammars via the "#include" directive having a symbol ordering:
	0 <= Lr1_K < raw chars < error terminals < Terminals < grammar's Rules
    The subrules of a grammar's rule are locally enumerated within the grammar
    starting from 1.
    
	This order is per emitted grammar. That is to say, each parallel grammar has
	its own generated lr1 table using the enumerated terminal class symbols with
	its enumerated rules starting 1 after the high bound of the enumerated terminal
	 classes.
	After the parameters, a { k-body } can follow. This k-body 
	is used for global definitions of contants:
	{
	  constant-defs
	       C++ syntax directed code for constant definitions
	  ***
	}

*/
T-enumeration
(file-name	testout_T_enumeration
,name-space	NS_testout_T_enum) {
}
