/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli.utils;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraAPI;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.configuration.ExecutionMode;
import org.islandoftex.arara.api.files.ProjectFile;
import org.islandoftex.arara.api.rules.DirectiveConditional;
import org.islandoftex.arara.api.rules.DirectiveConditionalType;
import org.islandoftex.arara.cli.utils.DisplayUtils;
import org.islandoftex.arara.cli.utils.StringExtensionsKt;
import org.islandoftex.arara.core.configuration.ConfigurationUtils;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.Environment;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.islandoftex.arara.core.session.Session;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u0018\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u0018\u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u0015\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(J\b\u0010)\u001a\u00020 H\u0002J\u000e\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004J\u0006\u0010,\u001a\u00020\u0004J\u0010\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\fH\u0002J\u0014\u0010/\u001a\u00020 2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000401J\u000e\u00102\u001a\u00020 2\u0006\u00103\u001a\u000204J\u0016\u00105\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004J\u000e\u00106\u001a\u00020 2\u0006\u0010.\u001a\u00020\fJ\u000e\u00107\u001a\u00020 2\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020<J\u0006\u0010=\u001a\u00020 J\u000e\u0010>\u001a\u00020 2\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u00020 2\u0006\u0010B\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u000e\u0010\u001e\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/islandoftex/arara/cli/utils/DisplayUtils;", "", "()V", "applicationPath", "", "getApplicationPath", "()Ljava/lang/String;", "configurationFileName", "getConfigurationFileName", "setConfigurationFileName", "(Ljava/lang/String;)V", "displayException", "", "displayLine", "displayResult", "displayRolling", "isDryRunMode", "()Z", "isVerboseMode", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "longestMatch", "", "getLongestMatch", "()I", "longestMatch$delegate", "Lkotlin/Lazy;", "outputWidth", "getOutputWidth", "shortenedLongestMatch", "buildDryRunEntry", "", "name", "task", "buildLongEntry", "buildShortEntry", "byteSizeToString", "size", "", "byteSizeToString$cli", "displayDetailsLine", "displayOutputSeparator", "message", "displaySeparator", "getResult", "value", "printAuthors", "authors", "", "printConditional", "conditional", "Lorg/islandoftex/arara/api/rules/DirectiveConditional;", "printEntry", "printEntryResult", "printException", "exception", "Lorg/islandoftex/arara/api/AraraException;", "printFileInformation", "projectFile", "Lorg/islandoftex/arara/api/files/ProjectFile;", "printLogo", "printTime", "seconds", "", "printWrapped", "text", "cli"})
public final class DisplayUtils {
    private static final Logger logger;
    @NotNull
    private static String configurationFileName;
    private static final Lazy longestMatch$delegate;
    private static final int shortenedLongestMatch = 10;
    private static boolean displayLine;
    private static boolean displayResult;
    private static boolean displayRolling;
    private static boolean displayException;
    @NotNull
    public static final DisplayUtils INSTANCE;

    @NotNull
    public final String getConfigurationFileName() {
        return configurationFileName;
    }

    public final void setConfigurationFileName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        configurationFileName = string;
    }

    private final int getLongestMatch() {
        Lazy lazy = longestMatch$delegate;
        DisplayUtils displayUtils = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    private final boolean isDryRunMode() {
        return LinearExecutor.INSTANCE.getExecutionOptions().getExecutionMode() == ExecutionMode.DRY_RUN;
    }

    private final boolean isVerboseMode() {
        return LinearExecutor.INSTANCE.getExecutionOptions().getVerbose();
    }

    private final String getApplicationPath() {
        String string;
        try {
            string = ((Object)ConfigurationUtils.getApplicationPath()).toString();
        }
        catch (AraraException ae) {
            string = "[unknown application path]";
        }
        return string;
    }

    private final int getOutputWidth() {
        return Session.getUserInterfaceOptions().getTerminalOutputWidth();
    }

    private final void buildShortEntry(String name, String task) {
        int result2 = this.getLongestMatch() >= this.getOutputWidth() ? 10 : this.getLongestMatch();
        int space = this.getOutputWidth() - result2 - 1;
        String line = StringExtensionsKt.abbreviate$default('(' + name + ") " + task + ' ', space - "... ".length(), null, 2, null);
        String string = StringsKt.padEnd(line, space, '.') + " ";
        boolean bl = false;
        System.out.print((Object)string);
    }

    public final void printEntryResult(boolean value) {
        displayLine = false;
        displayResult = true;
        logger.info(LanguageController.getMessages().getLOG_INFO_TASK_RESULT() + " " + this.getResult(value));
        if (!this.isDryRunMode()) {
            String string = !this.isVerboseMode() ? StringsKt.padStart$default(this.getResult(value), this.getLongestMatch(), '\u0000', 2, null) : "\n" + StringsKt.padStart(" " + this.getResult(value), this.getOutputWidth(), '-');
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    public final void printEntry(@NotNull String name, @NotNull String task) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(task, "task");
        String string = LanguageController.getMessages().getLOG_INFO_INTERPRET_TASK();
        Object[] objectArray = new Object[]{task, name};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "java.lang.String.format(this, *args)");
        logger.info(string2);
        displayLine = true;
        displayResult = false;
        if (!this.isDryRunMode()) {
            if (!this.isVerboseMode()) {
                this.buildShortEntry(name, task);
            } else {
                this.buildLongEntry(name, task);
            }
        } else {
            this.buildDryRunEntry(name, task);
        }
    }

    private final void buildLongEntry(String name, String task) {
        if (displayRolling) {
            boolean bl = false;
            System.out.println();
        } else {
            displayRolling = true;
        }
        String string = this.displaySeparator();
        boolean bl = false;
        System.out.println((Object)string);
        string = StringExtensionsKt.abbreviate$default('(' + name + ") " + task, this.getOutputWidth(), null, 2, null);
        bl = false;
        System.out.println((Object)string);
        string = this.displaySeparator();
        bl = false;
        System.out.println((Object)string);
    }

    private final void buildDryRunEntry(String name, String task) {
        if (displayRolling) {
            boolean bl = false;
            System.out.println();
        } else {
            displayRolling = true;
        }
        String string = StringExtensionsKt.abbreviate$default("[DR] (" + name + ") " + task, this.getOutputWidth(), null, 2, null);
        boolean bl = false;
        System.out.println((Object)string);
        string = this.displaySeparator();
        bl = false;
        System.out.println((Object)string);
    }

    public final void printException(@NotNull AraraException exception) {
        String string;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter(exception, "exception");
        displayException = true;
        if (displayResult) {
            bl2 = false;
            System.out.println();
        }
        if (displayLine && !this.isDryRunMode()) {
            String string2 = !this.isVerboseMode() ? StringsKt.padStart$default(LanguageController.getMessages().getINFO_LABEL_ON_ERROR(), this.getLongestMatch(), '\u0000', 2, null) : StringsKt.padStart(" " + LanguageController.getMessages().getINFO_LABEL_ON_ERROR(), this.getOutputWidth(), '-');
            bl = false;
            System.out.println((Object)string2);
            bl2 = false;
            System.out.println();
        }
        if ((string = exception.hasException() ? exception.getMessage() + " " + LanguageController.getMessages().getINFO_DISPLAY_EXCEPTION_MORE_DETAILS() : exception.getMessage()) == null) {
            string = "EXCEPTION PROVIDES NO MESSAGE";
        }
        String text2 = string;
        logger.error(text2);
        this.printWrapped(text2);
        if (exception.hasException()) {
            bl = false;
            System.out.println();
            this.displayDetailsLine();
            Exception exception2 = exception.getException();
            Intrinsics.checkNotNull(exception2);
            String string3 = exception2.getMessage();
            Intrinsics.checkNotNull(string3);
            String details = string3;
            logger.error(details);
            this.printWrapped(details);
        }
    }

    private final String getResult(boolean value) {
        return value ? LanguageController.getMessages().getINFO_LABEL_ON_SUCCESS() : LanguageController.getMessages().getINFO_LABEL_ON_FAILURE();
    }

    public final void printWrapped(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        String string = StringExtensionsKt.wrap(text2, this.getOutputWidth());
        boolean bl = false;
        System.out.println((Object)string);
    }

    public final void printAuthors(@NotNull List<String> authors) {
        Intrinsics.checkNotNullParameter(authors, "authors");
        String line = authors.size() == 1 ? LanguageController.getMessages().getINFO_LABEL_AUTHOR() : LanguageController.getMessages().getINFO_LABEL_AUTHORS();
        String text2 = authors.isEmpty() ? LanguageController.getMessages().getINFO_LABEL_NO_AUTHORS() : CollectionsKt.joinToString$default(authors, ", ", null, null, 0, null, printAuthors.text.1.INSTANCE, 30, null);
        this.printWrapped(line + ' ' + text2);
    }

    public final void printConditional(@NotNull DirectiveConditional conditional) {
        Intrinsics.checkNotNullParameter(conditional, "conditional");
        if (conditional.getType() != DirectiveConditionalType.NONE) {
            this.printWrapped(LanguageController.getMessages().getINFO_LABEL_CONDITIONAL() + " (" + (Object)((Object)conditional.getType()) + ") " + conditional.getCondition());
        }
    }

    @NotNull
    public final String byteSizeToString$cli(long size) {
        String string;
        double conversionFactor = 1000.0;
        if ((double)size < conversionFactor) {
            string = size + " B";
        } else {
            double d = size;
            boolean bl = false;
            int n = 0;
            n = (int)(Math.log(d) / Math.log(conversionFactor));
            boolean bl2 = false;
            bl = false;
            int exp = n;
            boolean bl3 = false;
            String string2 = "%.1f %sB";
            Locale locale = Session.getUserInterfaceOptions().getLocale();
            Object[] objectArray = new Object[2];
            double d2 = conversionFactor;
            double d3 = exp;
            boolean bl4 = false;
            objectArray[0] = (double)size / Math.pow(d2, d3);
            objectArray[1] = Character.valueOf("kMGTPE".charAt(exp - 1));
            Object[] objectArray2 = objectArray;
            boolean bl5 = false;
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray2, objectArray2.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(locale, this, *args)");
        }
        return string;
    }

    public final void printFileInformation(@NotNull ProjectFile projectFile) {
        Intrinsics.checkNotNullParameter(projectFile, "projectFile");
        File file2 = projectFile.getPath().toFile();
        String string = LanguageController.getMessages().getINFO_DISPLAY_FILE_INFORMATION();
        Object[] objectArray = new Object[3];
        File file3 = file2;
        Intrinsics.checkNotNullExpressionValue(file3, "file");
        objectArray[0] = file3.getName();
        objectArray[1] = this.byteSizeToString$cli(file2.length());
        objectArray[2] = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(file2.lastModified());
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue(string2, "java.lang.String.format(this, *args)");
        String line = string2;
        string = LanguageController.getMessages().getLOG_INFO_WELCOME_MESSAGE();
        objectArray2 = new Object[]{AraraAPI.INSTANCE.getVersion()};
        bl = false;
        String string3 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(this, *args)");
        logger.info(string3);
        logger.info(this.displaySeparator());
        logger.debug("::: arara @ " + this.getApplicationPath());
        string = "::: Java %s, %s";
        objectArray2 = new Object[]{Environment.getSystemProperty("java.version", "[unknown version]"), Environment.getSystemProperty("java.vendor", "[unknown vendor]")};
        bl = false;
        String string4 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue(string4, "java.lang.String.format(this, *args)");
        logger.debug(string4);
        string = "::: %s";
        objectArray2 = new Object[]{Environment.getSystemProperty("java.home", "[unknown location]")};
        bl = false;
        String string5 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue(string5, "java.lang.String.format(this, *args)");
        logger.debug(string5);
        string = "::: %s, %s, %s";
        objectArray2 = new Object[]{Environment.getSystemProperty("os.name", "[unknown OS name]"), Environment.getSystemProperty("os.arch", "[unknown OS arch]"), Environment.getSystemProperty("os.version", "[unknown OS version]")};
        bl = false;
        String string6 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue(string6, "java.lang.String.format(this, *args)");
        logger.debug(string6);
        string = "::: user.home @ %s";
        objectArray2 = new Object[]{Environment.getSystemProperty("user.home", "[unknown user's home directory]")};
        bl = false;
        String string7 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue(string7, "java.lang.String.format(this, *args)");
        logger.debug(string7);
        string = "::: CF @ %s";
        objectArray2 = new Object[]{configurationFileName};
        bl = false;
        String string8 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue(string8, "java.lang.String.format(this, *args)");
        logger.debug(string8);
        logger.debug(this.displaySeparator());
        logger.info(line);
        this.printWrapped(line);
        boolean bl2 = false;
        System.out.println();
    }

    public final void printTime(double seconds) {
        if (displayLine || displayException) {
            boolean bl = false;
            System.out.println();
        }
        String string = LanguageController.getMessages().getINFO_DISPLAY_EXECUTION_TIME();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = "%1.2f";
        Locale locale = Session.getUserInterfaceOptions().getLocale();
        Object[] objectArray3 = new Object[]{seconds};
        boolean bl = false;
        String string2 = String.format(locale, (String)objectArray2, Arrays.copyOf(objectArray3, objectArray3.length));
        Intrinsics.checkNotNullExpressionValue(string2, "java.lang.String.format(locale, this, *args)");
        objectArray[0] = string2;
        objectArray2 = objectArray;
        boolean bl2 = false;
        String string3 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(this, *args)");
        String text2 = string3;
        logger.info(text2);
        this.printWrapped(text2);
    }

    public final void printLogo() {
        String string = "  __ _ _ __ __ _ _ __ __ _\n / _` | '__/ _` | '__/ _` |\n| (_| | | | (_| | | | (_| |\n \\__,_|_|  \\__,_|_|  \\__,_|";
        boolean bl = false;
        System.out.println((Object)string);
        boolean bl2 = false;
        System.out.println();
    }

    private final void displayDetailsLine() {
        String string = StringsKt.padEnd(StringExtensionsKt.abbreviate$default(LanguageController.getMessages().getINFO_LABEL_ON_DETAILS() + " ", this.getOutputWidth(), null, 2, null), this.getOutputWidth(), '-');
        boolean bl = false;
        System.out.println((Object)string);
    }

    @NotNull
    public final String displayOutputSeparator(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        return StringExtensionsKt.center(' ' + message + ' ', this.getOutputWidth(), '-');
    }

    @NotNull
    public final String displaySeparator() {
        return StringsKt.repeat("-", this.getOutputWidth());
    }

    private DisplayUtils() {
    }

    static {
        DisplayUtils displayUtils;
        INSTANCE = displayUtils = new DisplayUtils();
        logger = LoggerFactory.getLogger(DisplayUtils.class);
        configurationFileName = "[none]";
        longestMatch$delegate = LazyKt.lazy(longestMatch.2.INSTANCE);
        displayLine = true;
    }
}

