/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.session;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.files.Project;
import org.islandoftex.arara.api.files.ProjectFile;
import org.islandoftex.arara.api.rules.Directive;
import org.islandoftex.arara.api.session.Executor;
import org.islandoftex.arara.core.configuration.ExecutionOptions;
import org.islandoftex.arara.core.dependencies.ProjectGraph;
import org.islandoftex.arara.core.files.ProjectFileKt;
import org.islandoftex.arara.core.session.ExecutionReport;
import org.islandoftex.arara.core.session.ExecutorHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001cH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bH\u0000\u00a2\u0006\u0002\b!R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lorg/islandoftex/arara/core/session/LinearExecutor;", "Lorg/islandoftex/arara/api/session/Executor;", "()V", "<set-?>", "Lorg/islandoftex/arara/api/files/ProjectFile;", "currentFile", "getCurrentFile", "()Lorg/islandoftex/arara/api/files/ProjectFile;", "Lorg/islandoftex/arara/api/files/Project;", "currentProject", "getCurrentProject", "()Lorg/islandoftex/arara/api/files/Project;", "value", "Lorg/islandoftex/arara/api/configuration/ExecutionOptions;", "executionOptions", "getExecutionOptions", "()Lorg/islandoftex/arara/api/configuration/ExecutionOptions;", "setExecutionOptions", "(Lorg/islandoftex/arara/api/configuration/ExecutionOptions;)V", "hooks", "Lorg/islandoftex/arara/core/session/ExecutorHooks;", "getHooks", "()Lorg/islandoftex/arara/core/session/ExecutorHooks;", "setHooks", "(Lorg/islandoftex/arara/core/session/ExecutorHooks;)V", "execute", "Lorg/islandoftex/arara/api/session/ExecutionReport;", "projects", "", "file", "executeProject", "", "project", "executeProject$core", "core"})
public final class LinearExecutor
implements Executor {
    @NotNull
    public static final LinearExecutor INSTANCE = new LinearExecutor();
    @NotNull
    private static ExecutorHooks hooks = new ExecutorHooks(null, null, null, null, null, null, null, 127, null);
    @Nullable
    private static Project currentProject;
    @Nullable
    private static ProjectFile currentFile;
    @NotNull
    private static org.islandoftex.arara.api.configuration.ExecutionOptions executionOptions;

    private LinearExecutor() {
    }

    @NotNull
    public final ExecutorHooks getHooks() {
        return hooks;
    }

    public final void setHooks(@NotNull ExecutorHooks executorHooks) {
        Intrinsics.checkNotNullParameter(executorHooks, "<set-?>");
        hooks = executorHooks;
    }

    @Nullable
    public final Project getCurrentProject() {
        return currentProject;
    }

    @Nullable
    public final ProjectFile getCurrentFile() {
        return currentFile;
    }

    @Override
    @NotNull
    public org.islandoftex.arara.api.configuration.ExecutionOptions getExecutionOptions() {
        return executionOptions;
    }

    @Override
    public void setExecutionOptions(@NotNull org.islandoftex.arara.api.configuration.ExecutionOptions value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (currentFile != null) {
            ProjectFile projectFile = currentFile;
            throw new AraraException("Cannot change execution options while executing the file " + (projectFile == null ? null : projectFile.getPath()) + '.');
        }
        if (value.getParallelExecution()) {
            throw new AraraException("This executor does not support parallel execution.");
        }
        executionOptions = value;
    }

    @Override
    @NotNull
    public org.islandoftex.arara.api.session.ExecutionReport execute(@NotNull List<? extends Project> projects) {
        ProjectGraph projectGraph;
        Intrinsics.checkNotNullParameter(projects, "projects");
        ProjectGraph $this$execute_u24lambda_u2d0 = projectGraph = new ProjectGraph();
        boolean bl = false;
        $this$execute_u24lambda_u2d0.addAll((Iterable<? extends Project>)projects);
        List projectsInOrder = projectGraph.kahn();
        hooks.getExecuteBeforeExecution().invoke();
        TimeMark executionStarted = TimeSource.Monotonic.INSTANCE.markNow();
        int exitCode = 0;
        for (Project project : projectsInOrder) {
            exitCode = this.executeProject$core(project);
            if (!this.getExecutionOptions().getHaltOnErrors() || exitCode == 0) continue;
        }
        TimeMark executionEnded = TimeSource.Monotonic.INSTANCE.markNow();
        ExecutionReport executionReport = new ExecutionReport(executionStarted, executionEnded, exitCode);
        hooks.getExecuteAfterExecution().invoke(executionReport);
        return executionReport;
    }

    public final int executeProject$core(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        int exitCode = 0;
        currentProject = project;
        hooks.getExecuteBeforeProject().invoke(project);
        for (ProjectFile file2 : ProjectFileKt.getByPriority((Iterable<? extends ProjectFile>)project.getFiles())) {
            hooks.getExecuteBeforeFile().invoke(file2);
            org.islandoftex.arara.api.session.ExecutionReport executionReport = this.execute(file2);
            exitCode = executionReport.getExitCode();
            if (this.getExecutionOptions().getHaltOnErrors() && exitCode != 0) {
                return exitCode;
            }
            hooks.getExecuteAfterFile().invoke(executionReport);
        }
        hooks.getExecuteAfterProject().invoke(project);
        currentProject = null;
        return exitCode;
    }

    @Override
    @NotNull
    public org.islandoftex.arara.api.session.ExecutionReport execute(@NotNull ProjectFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        currentFile = file2;
        TimeMark executionStarted = TimeSource.Monotonic.INSTANCE.markNow();
        List<Directive> directives = hooks.getProcessDirectives().invoke(file2, file2.fetchDirectives(this.getExecutionOptions().getParseOnlyHeader()));
        int exitCode = 0;
        for (Directive directive : directives) {
            exitCode = directive.execute();
            if (!this.getExecutionOptions().getHaltOnErrors() || exitCode == 0) continue;
        }
        currentFile = null;
        return new ExecutionReport(executionStarted, TimeSource.Monotonic.INSTANCE.markNow(), exitCode);
    }

    static {
        executionOptions = new ExecutionOptions(0, 0L, false, false, null, false, null, null, null, false, 1023, null);
    }
}

