/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0011H\u0014J\u001c\u0010\u0012\u001a\u00020\u00132\n\u0010\u000f\u001a\u00060\u0010R\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\nH\u0016J\u0014\u0010\u0018\u001a\u00020\f2\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0011H\u0016R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/intellij/markdown/parser/markerblocks/impl/SetextHeaderMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;)V", "contentMarker", "Lorg/intellij/markdown/parser/ProductionHolder$Marker;", "nodeType", "Lorg/intellij/markdown/IElementType;", "allowsSubBlocks", "", "calcNextInterestingOffset", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "isInterestingOffset", "markdown"})
public final class SetextHeaderMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    private final ProductionHolder productionHolder;
    @NotNull
    private final ProductionHolder.Marker contentMarker;
    @NotNull
    private IElementType nodeType;

    public SetextHeaderMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder) {
        Intrinsics.checkNotNullParameter(myConstraints, "myConstraints");
        Intrinsics.checkNotNullParameter(productionHolder, "productionHolder");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.contentMarker = this.productionHolder.mark();
        this.nodeType = MarkdownElementTypes.SETEXT_1;
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        return pos.getOffsetInCurrentLine() == -1;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return this.nodeType;
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        LookaheadText.Position position;
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(currentConstraints, "currentConstraints");
        if (pos.getOffsetInCurrentLine() != -1) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        Integer n = pos.charsToNonWhitespace();
        if (n == null) {
            return new MarkerBlock.ProcessingResult(MarkerBlock.ClosingAction.DROP, MarkerBlock.ClosingAction.DROP, MarkerBlock.EventAction.PROPAGATE);
        }
        int startSpaces = n;
        LookaheadText.Position setextMarkerStart = pos.nextPosition(startSpaces);
        LookaheadText.Position position2 = setextMarkerStart;
        if (position2 == null ? false : position2.getChar() == '-') {
            this.nodeType = MarkdownElementTypes.SETEXT_2;
        }
        Integer n2 = (position = setextMarkerStart) == null ? null : Integer.valueOf(position.getOffset());
        int setextMarkerStartOffset = n2 == null ? pos.getOffset() : n2.intValue();
        IElementType markerNodeType = Intrinsics.areEqual(this.nodeType, MarkdownElementTypes.SETEXT_2) ? MarkdownTokenTypes.SETEXT_2 : MarkdownTokenTypes.SETEXT_1;
        this.contentMarker.done(MarkdownTokenTypes.SETEXT_CONTENT);
        this.productionHolder.addProduction((Collection<SequentialParser.Node>)CollectionsKt.listOf(new SequentialParser.Node(new IntRange(setextMarkerStartOffset, pos.getNextLineOrEofOffset()), markerNodeType)));
        this.scheduleProcessingResult(pos.getNextLineOrEofOffset(), MarkerBlock.ProcessingResult.Companion.getDEFAULT());
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }
}

