---
title: Odia
---

# Odia

**Translation approach - transliteration and diacritics in Odia**

New agreement for Odia Translation guide:

1. Avoid the use of diacritics when transliteration is required in Oriya - diacritics can be easily understood by Oriya well-versed users, but plain transliteration (without diacritics) is more common and preferred.

Follow the General Guidelines for Country/region names:

1. Use the most neutral grammatical form for the country/region that is natural for these two usages above. If there is no single form that can accomplish that, favor the usage within UI menus.
2. Use the capitalization that would be appropriate in the middle of a sentence; the \<contextTransforms> data can specify the capitalization for other contexts. For more information, see Capitalization.
3. Each of the names must be unique.
4. Don't use commas and don't invert the name (eg use "South Korea", not "Korean, South").
5. Don't use the characters "(" and ")", since they will be confusing in complex language names. If you have to use brackets, use square ones: [ and ].

**Helpful examples**

1. Generally speaking, the use of diacritics when transliterating ie. geographic names (especially for lesser known countries such as Gabon or Man of Isles) should be acceptable / preferred for well-versed users.
	1. That said and given the fact that diacritics change pronunciation in Oriya (for example, ଲଣ୍ଡନ୍ will be pronounced as London but ଲଣ୍ଡନ will be pronounced as Londonaw), a transliteration approach with regular adoption of diacritics could potentially trigger confusion among not-well-versed users.
	2. With these considerations in mind and with the goal of achieving consistency across categories and companies, Google linguists are open to the introduction of a general translation guideline in favor of transliteration without adoption of diacritics

