/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#include "soundserver.h"

// Implementation
Arts::SampleStorageEntry_base *Arts::SampleStorageEntry_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::SampleStorageEntry_base *castedObject = (Arts::SampleStorageEntry_base *)skel->_cast(Arts::SampleStorageEntry_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::SampleStorageEntry_base *Arts::SampleStorageEntry_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::SampleStorageEntry_base::_fromReference(r,true);
	return 0;
}

Arts::SampleStorageEntry_base *Arts::SampleStorageEntry_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::SampleStorageEntry_base *castedObject = (Arts::SampleStorageEntry_base *)object._base()->_cast(Arts::SampleStorageEntry_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::SampleStorageEntry_base *Arts::SampleStorageEntry_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::SampleStorageEntry_base *result;
	result = (Arts::SampleStorageEntry_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::SampleStorageEntry");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::SampleStorageEntry_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::SampleStorageEntry")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::SampleStorageEntry_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::SampleStorageEntry_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::SampleStorageEntry_base::_cast(unsigned long iid)
{
	if(iid == Arts::SampleStorageEntry_base::_IID) return (Arts::SampleStorageEntry_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::SampleStorageEntry_stub::SampleStorageEntry_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::SampleStorageEntry_stub::SampleStorageEntry_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void Arts::SampleStorageEntry_stub::write(const std::vector<Arts::mcopbyte>& data)
{
	long methodID = _lookupMethodFast("method:0000000677726974650000000005766f6964000000000200000001000000062a62797465000000000564617461000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeByteSeq(data);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::SampleStorageEntry_stub::finish()
{
	long methodID = _lookupMethodFast("method:0000000766696e6973680000000005766f696400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::SampleStorageEntry_stub::name()
{
	long methodID = _lookupMethodFast("method:0000000a5f6765745f6e616d650000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occurred
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

std::string Arts::SampleStorageEntry_stub::filename()
{
	long methodID = _lookupMethodFast("method:0000000e5f6765745f66696c656e616d650000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occurred
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

bool Arts::SampleStorageEntry_stub::completed()
{
	long methodID = _lookupMethodFast("method:0000000f5f6765745f636f6d706c657465640000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

std::string Arts::SampleStorageEntry_skel::_interfaceName()
{
	return "Arts::SampleStorageEntry";
}

bool Arts::SampleStorageEntry_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::SampleStorageEntry") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::SampleStorageEntry_skel::_interfaceNameSkel()
{
	return "Arts::SampleStorageEntry";
}

// write
static void _dispatch_Arts_SampleStorageEntry_00(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	std::vector<Arts::mcopbyte> data;
	request->readByteSeq(data);
	((Arts::SampleStorageEntry_skel *)object)->write(data);
}

// finish
static void _dispatch_Arts_SampleStorageEntry_01(void *object, Arts::Buffer *, Arts::Buffer *)
{
	((Arts::SampleStorageEntry_skel *)object)->finish();
}

// _get_name
static void _dispatch_Arts_SampleStorageEntry_02(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((Arts::SampleStorageEntry_skel *)object)->name());
}

// _get_filename
static void _dispatch_Arts_SampleStorageEntry_03(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((Arts::SampleStorageEntry_skel *)object)->filename());
}

// _get_completed
static void _dispatch_Arts_SampleStorageEntry_04(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::SampleStorageEntry_skel *)object)->completed());
}

void Arts::SampleStorageEntry_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000677726974650000000005766f6964000000000200000001"
        "000000062a62797465000000000564617461000000000000000000000000076669"
        "6e6973680000000005766f6964000000000200000000000000000000000a5f6765"
        "745f6e616d650000000007737472696e6700000000020000000000000000000000"
        "0e5f6765745f66696c656e616d650000000007737472696e670000000002000000"
        "00000000000000000f5f6765745f636f6d706c657465640000000008626f6f6c65"
        "616e00000000020000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_SampleStorageEntry_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SampleStorageEntry_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SampleStorageEntry_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SampleStorageEntry_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SampleStorageEntry_04,this,Arts::MethodDef(m));
}

Arts::SampleStorageEntry_skel::SampleStorageEntry_skel()
{
}

Arts::Object_base* Arts::SampleStorageEntry::_Creator() {
	return Arts::SampleStorageEntry_base::_create();
}

unsigned long Arts::SampleStorageEntry_base::_IID = Arts::MCOPUtils::makeIID("Arts::SampleStorageEntry");

Arts::SampleStorage_base *Arts::SampleStorage_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::SampleStorage_base *castedObject = (Arts::SampleStorage_base *)skel->_cast(Arts::SampleStorage_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::SampleStorage_base *Arts::SampleStorage_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::SampleStorage_base::_fromReference(r,true);
	return 0;
}

Arts::SampleStorage_base *Arts::SampleStorage_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::SampleStorage_base *castedObject = (Arts::SampleStorage_base *)object._base()->_cast(Arts::SampleStorage_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::SampleStorage_base *Arts::SampleStorage_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::SampleStorage_base *result;
	result = (Arts::SampleStorage_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::SampleStorage");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::SampleStorage_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::SampleStorage")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::SampleStorage_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::SampleStorage_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::SampleStorage_base::_cast(unsigned long iid)
{
	if(iid == Arts::SampleStorage_base::_IID) return (Arts::SampleStorage_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::SampleStorage_stub::SampleStorage_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::SampleStorage_stub::SampleStorage_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void Arts::SampleStorage_stub::constructor(const std::string& directory, bool clearOnInit)
{
	long methodID = _lookupMethodFast("method:0000000c636f6e7374727563746f720000000005766f696400000000020000000200000007737472696e67000000000a6469726563746f7279000000000000000008626f6f6c65616e000000000c636c6561724f6e496e6974000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(directory);
	request->writeBool(clearOnInit);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

Arts::SampleStorageEntry Arts::SampleStorage_stub::createEntry(const std::string& name)
{
	long methodID = _lookupMethodFast("method:0000000c637265617465456e7472790000000019417274733a3a53616d706c6553746f72616765456e74727900000000020000000100000007737472696e6700000000056e616d65000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(name);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::SampleStorageEntry::null();
	Arts::SampleStorageEntry_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::SampleStorageEntry::_from_base(returnCode);
}

void Arts::SampleStorage_stub::addEntry(Arts::SampleStorageEntry entry)
{
	long methodID = _lookupMethodFast("method:00000009616464456e7472790000000005766f696400000000020000000100000019417274733a3a53616d706c6553746f72616765456e7472790000000006656e747279000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,entry._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::SampleStorage_stub::removeEntry(Arts::SampleStorageEntry entry)
{
	long methodID = _lookupMethodFast("method:0000000c72656d6f7665456e7472790000000005766f696400000000020000000100000019417274733a3a53616d706c6553746f72616765456e7472790000000006656e747279000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,entry._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

Arts::SampleStorageEntry Arts::SampleStorage_stub::findEntry(const std::string& name)
{
	long methodID = _lookupMethodFast("method:0000000a66696e64456e7472790000000019417274733a3a53616d706c6553746f72616765456e74727900000000020000000100000007737472696e6700000000056e616d65000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(name);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::SampleStorageEntry::null();
	Arts::SampleStorageEntry_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::SampleStorageEntry::_from_base(returnCode);
}

std::string Arts::SampleStorage_skel::_interfaceName()
{
	return "Arts::SampleStorage";
}

bool Arts::SampleStorage_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::SampleStorage") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::SampleStorage_skel::_interfaceNameSkel()
{
	return "Arts::SampleStorage";
}

// constructor
static void _dispatch_Arts_SampleStorage_00(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	std::string directory;
	request->readString(directory);
	bool clearOnInit = request->readBool();
	((Arts::SampleStorage_skel *)object)->constructor(directory,clearOnInit);
}

// createEntry
static void _dispatch_Arts_SampleStorage_01(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	std::string name;
	request->readString(name);
	Arts::SampleStorageEntry returnCode = ((Arts::SampleStorage_skel *)object)->createEntry(name);
	Arts::writeObject(*result,returnCode._base());
}

// addEntry
static void _dispatch_Arts_SampleStorage_02(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::SampleStorageEntry_base* _temp_entry;
	Arts::readObject(*request,_temp_entry);
	Arts::SampleStorageEntry entry = Arts::SampleStorageEntry::_from_base(_temp_entry);
	((Arts::SampleStorage_skel *)object)->addEntry(entry);
}

// removeEntry
static void _dispatch_Arts_SampleStorage_03(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::SampleStorageEntry_base* _temp_entry;
	Arts::readObject(*request,_temp_entry);
	Arts::SampleStorageEntry entry = Arts::SampleStorageEntry::_from_base(_temp_entry);
	((Arts::SampleStorage_skel *)object)->removeEntry(entry);
}

// findEntry
static void _dispatch_Arts_SampleStorage_04(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	std::string name;
	request->readString(name);
	Arts::SampleStorageEntry returnCode = ((Arts::SampleStorage_skel *)object)->findEntry(name);
	Arts::writeObject(*result,returnCode._base());
}

void Arts::SampleStorage_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000c636f6e7374727563746f720000000005766f6964000000"
        "00020000000200000007737472696e67000000000a6469726563746f7279000000"
        "000000000008626f6f6c65616e000000000c636c6561724f6e496e697400000000"
        "00000000000000000c637265617465456e7472790000000019417274733a3a5361"
        "6d706c6553746f72616765456e7472790000000002000000010000000773747269"
        "6e6700000000056e616d6500000000000000000000000009616464456e74727900"
        "00000005766f696400000000020000000100000019417274733a3a53616d706c65"
        "53746f72616765456e7472790000000006656e7472790000000000000000000000"
        "000c72656d6f7665456e7472790000000005766f69640000000002000000010000"
        "0019417274733a3a53616d706c6553746f72616765456e7472790000000006656e"
        "7472790000000000000000000000000a66696e64456e7472790000000019417274"
        "733a3a53616d706c6553746f72616765456e747279000000000200000001000000"
        "07737472696e6700000000056e616d65000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_SampleStorage_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SampleStorage_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SampleStorage_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SampleStorage_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SampleStorage_04,this,Arts::MethodDef(m));
}

Arts::SampleStorage_skel::SampleStorage_skel()
{
}

Arts::Object_base* Arts::SampleStorage::_Creator() {
	return Arts::SampleStorage_base::_create();
}

unsigned long Arts::SampleStorage_base::_IID = Arts::MCOPUtils::makeIID("Arts::SampleStorage");

Arts::ByteSoundProducer_base *Arts::ByteSoundProducer_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::ByteSoundProducer_base *castedObject = (Arts::ByteSoundProducer_base *)skel->_cast(Arts::ByteSoundProducer_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::ByteSoundProducer_base *Arts::ByteSoundProducer_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::ByteSoundProducer_base::_fromReference(r,true);
	return 0;
}

Arts::ByteSoundProducer_base *Arts::ByteSoundProducer_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::ByteSoundProducer_base *castedObject = (Arts::ByteSoundProducer_base *)object._base()->_cast(Arts::ByteSoundProducer_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::ByteSoundProducer_base *Arts::ByteSoundProducer_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::ByteSoundProducer_base *result;
	result = (Arts::ByteSoundProducer_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::ByteSoundProducer");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::ByteSoundProducer_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::ByteSoundProducer")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::ByteSoundProducer_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::ByteSoundProducer_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	ret.push_back("outdata");
	return ret;
}

void *Arts::ByteSoundProducer_base::_cast(unsigned long iid)
{
	if(iid == Arts::ByteSoundProducer_base::_IID) return (Arts::ByteSoundProducer_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::ByteSoundProducer_stub::ByteSoundProducer_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::ByteSoundProducer_stub::ByteSoundProducer_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

long Arts::ByteSoundProducer_stub::samplingRate()
{
	long methodID = _lookupMethodFast("method:000000125f6765745f73616d706c696e675261746500000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

long Arts::ByteSoundProducer_stub::channels()
{
	long methodID = _lookupMethodFast("method:0000000e5f6765745f6368616e6e656c7300000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

long Arts::ByteSoundProducer_stub::bits()
{
	long methodID = _lookupMethodFast("method:0000000a5f6765745f6269747300000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

std::string Arts::ByteSoundProducer_skel::_interfaceName()
{
	return "Arts::ByteSoundProducer";
}

bool Arts::ByteSoundProducer_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::ByteSoundProducer") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::ByteSoundProducer_skel::_interfaceNameSkel()
{
	return "Arts::ByteSoundProducer";
}

// _get_samplingRate
static void _dispatch_Arts_ByteSoundProducer_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::ByteSoundProducer_skel *)object)->samplingRate());
}

// _get_channels
static void _dispatch_Arts_ByteSoundProducer_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::ByteSoundProducer_skel *)object)->channels());
}

// _get_bits
static void _dispatch_Arts_ByteSoundProducer_02(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::ByteSoundProducer_skel *)object)->bits());
}

void Arts::ByteSoundProducer_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:000000125f6765745f73616d706c696e675261746500000000056c"
        "6f6e67000000000200000000000000000000000e5f6765745f6368616e6e656c73"
        "00000000056c6f6e67000000000200000000000000000000000a5f6765745f6269"
        "747300000000056c6f6e6700000000020000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_ByteSoundProducer_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_ByteSoundProducer_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_ByteSoundProducer_02,this,Arts::MethodDef(m));
	Arts::SynthModule_skel::_buildMethodTable();
}

Arts::ByteSoundProducer_skel::ByteSoundProducer_skel()
{
	_initStream("outdata",&outdata,42);
}

void Arts::ByteSoundProducer_skel::notify(const Arts::Notification &notification)
{
	if(outdata.notifyID() == notification.ID)
		request_outdata((Arts::DataPacket<Arts::mcopbyte> *)notification.data);
}

void Arts::ByteSoundProducer_skel::request_outdata(Arts::DataPacket<Arts::mcopbyte> *)
{
	assert(false); // this default is for modules who don't want requesting
}

Arts::Object_base* Arts::ByteSoundProducer::_Creator() {
	return Arts::ByteSoundProducer_base::_create();
}

unsigned long Arts::ByteSoundProducer_base::_IID = Arts::MCOPUtils::makeIID("Arts::ByteSoundProducer");

Arts::ByteSoundProducerV2_base *Arts::ByteSoundProducerV2_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::ByteSoundProducerV2_base *castedObject = (Arts::ByteSoundProducerV2_base *)skel->_cast(Arts::ByteSoundProducerV2_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::ByteSoundProducerV2_base *Arts::ByteSoundProducerV2_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::ByteSoundProducerV2_base::_fromReference(r,true);
	return 0;
}

Arts::ByteSoundProducerV2_base *Arts::ByteSoundProducerV2_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::ByteSoundProducerV2_base *castedObject = (Arts::ByteSoundProducerV2_base *)object._base()->_cast(Arts::ByteSoundProducerV2_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::ByteSoundProducerV2_base *Arts::ByteSoundProducerV2_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::ByteSoundProducerV2_base *result;
	result = (Arts::ByteSoundProducerV2_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::ByteSoundProducerV2");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::ByteSoundProducerV2_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::ByteSoundProducerV2")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::ByteSoundProducerV2_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::ByteSoundProducerV2_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	ret.push_back("outdata");
	return ret;
}

void *Arts::ByteSoundProducerV2_base::_cast(unsigned long iid)
{
	if(iid == Arts::ByteSoundProducerV2_base::_IID) return (Arts::ByteSoundProducerV2_base *)this;
	if(iid == Arts::ByteSoundProducer_base::_IID) return (Arts::ByteSoundProducer_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::ByteSoundProducerV2_stub::ByteSoundProducerV2_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::ByteSoundProducerV2_stub::ByteSoundProducerV2_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

std::string Arts::ByteSoundProducerV2_stub::title()
{
	long methodID = _lookupMethodFast("method:0000000b5f6765745f7469746c650000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occurred
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

std::string Arts::ByteSoundProducerV2_skel::_interfaceName()
{
	return "Arts::ByteSoundProducerV2";
}

bool Arts::ByteSoundProducerV2_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::ByteSoundProducerV2") return true;
	if (interfacename == "Arts::ByteSoundProducer") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::ByteSoundProducerV2_skel::_interfaceNameSkel()
{
	return "Arts::ByteSoundProducerV2";
}

// _get_title
static void _dispatch_Arts_ByteSoundProducerV2_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((Arts::ByteSoundProducerV2_skel *)object)->title());
}

void Arts::ByteSoundProducerV2_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000b5f6765745f7469746c650000000007737472696e670000"
        "0000020000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_ByteSoundProducerV2_00,this,Arts::MethodDef(m));
	Arts::ByteSoundProducer_skel::_buildMethodTable();
}

Arts::ByteSoundProducerV2_skel::ByteSoundProducerV2_skel()
{
}

Arts::Object_base* Arts::ByteSoundProducerV2::_Creator() {
	return Arts::ByteSoundProducerV2_base::_create();
}

unsigned long Arts::ByteSoundProducerV2_base::_IID = Arts::MCOPUtils::makeIID("Arts::ByteSoundProducerV2");

Arts::ByteSoundReceiver_base *Arts::ByteSoundReceiver_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::ByteSoundReceiver_base *castedObject = (Arts::ByteSoundReceiver_base *)skel->_cast(Arts::ByteSoundReceiver_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::ByteSoundReceiver_base *Arts::ByteSoundReceiver_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::ByteSoundReceiver_base::_fromReference(r,true);
	return 0;
}

Arts::ByteSoundReceiver_base *Arts::ByteSoundReceiver_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::ByteSoundReceiver_base *castedObject = (Arts::ByteSoundReceiver_base *)object._base()->_cast(Arts::ByteSoundReceiver_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::ByteSoundReceiver_base *Arts::ByteSoundReceiver_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::ByteSoundReceiver_base *result;
	result = (Arts::ByteSoundReceiver_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::ByteSoundReceiver");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::ByteSoundReceiver_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::ByteSoundReceiver")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::ByteSoundReceiver_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	ret.push_back("indata");
	return ret;
}
std::vector<std::string> Arts::ByteSoundReceiver_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::ByteSoundReceiver_base::_cast(unsigned long iid)
{
	if(iid == Arts::ByteSoundReceiver_base::_IID) return (Arts::ByteSoundReceiver_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::ByteSoundReceiver_stub::ByteSoundReceiver_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::ByteSoundReceiver_stub::ByteSoundReceiver_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

long Arts::ByteSoundReceiver_stub::samplingRate()
{
	long methodID = _lookupMethodFast("method:000000125f6765745f73616d706c696e675261746500000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

long Arts::ByteSoundReceiver_stub::channels()
{
	long methodID = _lookupMethodFast("method:0000000e5f6765745f6368616e6e656c7300000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

long Arts::ByteSoundReceiver_stub::bits()
{
	long methodID = _lookupMethodFast("method:0000000a5f6765745f6269747300000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

std::string Arts::ByteSoundReceiver_stub::title()
{
	long methodID = _lookupMethodFast("method:0000000b5f6765745f7469746c650000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occurred
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

std::string Arts::ByteSoundReceiver_skel::_interfaceName()
{
	return "Arts::ByteSoundReceiver";
}

bool Arts::ByteSoundReceiver_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::ByteSoundReceiver") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::ByteSoundReceiver_skel::_interfaceNameSkel()
{
	return "Arts::ByteSoundReceiver";
}

// _get_samplingRate
static void _dispatch_Arts_ByteSoundReceiver_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::ByteSoundReceiver_skel *)object)->samplingRate());
}

// _get_channels
static void _dispatch_Arts_ByteSoundReceiver_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::ByteSoundReceiver_skel *)object)->channels());
}

// _get_bits
static void _dispatch_Arts_ByteSoundReceiver_02(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::ByteSoundReceiver_skel *)object)->bits());
}

// _get_title
static void _dispatch_Arts_ByteSoundReceiver_03(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((Arts::ByteSoundReceiver_skel *)object)->title());
}

void Arts::ByteSoundReceiver_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:000000125f6765745f73616d706c696e675261746500000000056c"
        "6f6e67000000000200000000000000000000000e5f6765745f6368616e6e656c73"
        "00000000056c6f6e67000000000200000000000000000000000a5f6765745f6269"
        "747300000000056c6f6e67000000000200000000000000000000000b5f6765745f"
        "7469746c650000000007737472696e6700000000020000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_ByteSoundReceiver_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_ByteSoundReceiver_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_ByteSoundReceiver_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_ByteSoundReceiver_03,this,Arts::MethodDef(m));
	Arts::SynthModule_skel::_buildMethodTable();
}

Arts::ByteSoundReceiver_skel::ByteSoundReceiver_skel()
{
	_initStream("indata",&indata,41);
}

void Arts::ByteSoundReceiver_skel::notify(const Arts::Notification &notification)
{
	if(indata.notifyID() == notification.ID)
		process_indata((Arts::DataPacket<Arts::mcopbyte> *)notification.data);
}

Arts::Object_base* Arts::ByteSoundReceiver::_Creator() {
	return Arts::ByteSoundReceiver_base::_create();
}

unsigned long Arts::ByteSoundReceiver_base::_IID = Arts::MCOPUtils::makeIID("Arts::ByteSoundReceiver");

Arts::SimpleSoundServer_base *Arts::SimpleSoundServer_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::SimpleSoundServer_base *castedObject = (Arts::SimpleSoundServer_base *)skel->_cast(Arts::SimpleSoundServer_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::SimpleSoundServer_base *Arts::SimpleSoundServer_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::SimpleSoundServer_base::_fromReference(r,true);
	return 0;
}

Arts::SimpleSoundServer_base *Arts::SimpleSoundServer_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::SimpleSoundServer_base *castedObject = (Arts::SimpleSoundServer_base *)object._base()->_cast(Arts::SimpleSoundServer_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::SimpleSoundServer_base *Arts::SimpleSoundServer_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::SimpleSoundServer_base *result;
	result = (Arts::SimpleSoundServer_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::SimpleSoundServer");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::SimpleSoundServer_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::SimpleSoundServer")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::SimpleSoundServer_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::SimpleSoundServer_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::SimpleSoundServer_base::_cast(unsigned long iid)
{
	if(iid == Arts::SimpleSoundServer_base::_IID) return (Arts::SimpleSoundServer_base *)this;
	if(iid == Arts::PlayObjectFactory_base::_IID) return (Arts::PlayObjectFactory_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::SimpleSoundServer_stub::SimpleSoundServer_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::SimpleSoundServer_stub::SimpleSoundServer_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

long Arts::SimpleSoundServer_stub::play(const std::string& filename)
{
	long methodID = _lookupMethodFast("method:00000005706c617900000000056c6f6e6700000000020000000100000007737472696e67000000000966696c656e616d65000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(filename);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

void Arts::SimpleSoundServer_stub::attach(Arts::ByteSoundProducer producer)
{
	long methodID = _lookupMethodFast("method:000000076174746163680000000005766f696400000000020000000100000018417274733a3a42797465536f756e6450726f6475636572000000000970726f6475636572000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,producer._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::SimpleSoundServer_stub::detach(Arts::ByteSoundProducer producer)
{
	long methodID = _lookupMethodFast("method:000000076465746163680000000005766f696400000000020000000100000018417274733a3a42797465536f756e6450726f6475636572000000000970726f6475636572000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,producer._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::SimpleSoundServer_stub::attachRecorder(Arts::ByteSoundReceiver receiver)
{
	long methodID = _lookupMethodFast("method:0000000f6174746163685265636f726465720000000005766f696400000000020000000100000018417274733a3a42797465536f756e64526563656976657200000000097265636569766572000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,receiver._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::SimpleSoundServer_stub::detachRecorder(Arts::ByteSoundReceiver receiver)
{
	long methodID = _lookupMethodFast("method:0000000f6465746163685265636f726465720000000005766f696400000000020000000100000018417274733a3a42797465536f756e64526563656976657200000000097265636569766572000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	Arts::writeObject(*request,receiver._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

Arts::Object Arts::SimpleSoundServer_stub::createObject(const std::string& name)
{
	long methodID = _lookupMethodFast("method:0000000d6372656174654f626a65637400000000076f626a65637400000000020000000100000007737472696e6700000000056e616d65000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(name);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::Object::null();
	Arts::Object_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::Object::_from_base(returnCode);
}

Arts::StereoEffectStack Arts::SimpleSoundServer_stub::outstack()
{
	long methodID = _lookupMethodFast("method:0000000e5f6765745f6f7574737461636b0000000018417274733a3a53746572656f456666656374537461636b00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::StereoEffectStack::null();
	Arts::StereoEffectStack_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::StereoEffectStack::_from_base(returnCode);
}

float Arts::SimpleSoundServer_stub::minStreamBufferTime()
{
	long methodID = _lookupMethodFast("method:000000195f6765745f6d696e53747265616d42756666657254696d650000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

float Arts::SimpleSoundServer_stub::serverBufferTime()
{
	long methodID = _lookupMethodFast("method:000000165f6765745f73657276657242756666657254696d650000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

std::string Arts::SimpleSoundServer_skel::_interfaceName()
{
	return "Arts::SimpleSoundServer";
}

bool Arts::SimpleSoundServer_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::SimpleSoundServer") return true;
	if (interfacename == "Arts::PlayObjectFactory") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::SimpleSoundServer_skel::_interfaceNameSkel()
{
	return "Arts::SimpleSoundServer";
}

// play
static void _dispatch_Arts_SimpleSoundServer_00(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	std::string filename;
	request->readString(filename);
	result->writeLong(((Arts::SimpleSoundServer_skel *)object)->play(filename));
}

// attach
static void _dispatch_Arts_SimpleSoundServer_01(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::ByteSoundProducer_base* _temp_producer;
	Arts::readObject(*request,_temp_producer);
	Arts::ByteSoundProducer producer = Arts::ByteSoundProducer::_from_base(_temp_producer);
	((Arts::SimpleSoundServer_skel *)object)->attach(producer);
}

// detach
static void _dispatch_Arts_SimpleSoundServer_02(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::ByteSoundProducer_base* _temp_producer;
	Arts::readObject(*request,_temp_producer);
	Arts::ByteSoundProducer producer = Arts::ByteSoundProducer::_from_base(_temp_producer);
	((Arts::SimpleSoundServer_skel *)object)->detach(producer);
}

// attachRecorder
static void _dispatch_Arts_SimpleSoundServer_03(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::ByteSoundReceiver_base* _temp_receiver;
	Arts::readObject(*request,_temp_receiver);
	Arts::ByteSoundReceiver receiver = Arts::ByteSoundReceiver::_from_base(_temp_receiver);
	((Arts::SimpleSoundServer_skel *)object)->attachRecorder(receiver);
}

// detachRecorder
static void _dispatch_Arts_SimpleSoundServer_04(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	Arts::ByteSoundReceiver_base* _temp_receiver;
	Arts::readObject(*request,_temp_receiver);
	Arts::ByteSoundReceiver receiver = Arts::ByteSoundReceiver::_from_base(_temp_receiver);
	((Arts::SimpleSoundServer_skel *)object)->detachRecorder(receiver);
}

// createObject
static void _dispatch_Arts_SimpleSoundServer_05(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	std::string name;
	request->readString(name);
	Arts::Object returnCode = ((Arts::SimpleSoundServer_skel *)object)->createObject(name);
	Arts::writeObject(*result,returnCode._base());
}

// _get_outstack
static void _dispatch_Arts_SimpleSoundServer_06(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::StereoEffectStack returnCode = ((Arts::SimpleSoundServer_skel *)object)->outstack();
	Arts::writeObject(*result,returnCode._base());
}

// _get_minStreamBufferTime
static void _dispatch_Arts_SimpleSoundServer_07(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::SimpleSoundServer_skel *)object)->minStreamBufferTime());
}

// _get_serverBufferTime
static void _dispatch_Arts_SimpleSoundServer_08(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::SimpleSoundServer_skel *)object)->serverBufferTime());
}

void Arts::SimpleSoundServer_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:00000005706c617900000000056c6f6e6700000000020000000100"
        "000007737472696e67000000000966696c656e616d650000000000000000000000"
        "00076174746163680000000005766f696400000000020000000100000018417274"
        "733a3a42797465536f756e6450726f6475636572000000000970726f6475636572"
        "000000000000000000000000076465746163680000000005766f69640000000002"
        "0000000100000018417274733a3a42797465536f756e6450726f64756365720000"
        "00000970726f64756365720000000000000000000000000f617474616368526563"
        "6f726465720000000005766f696400000000020000000100000018417274733a3a"
        "42797465536f756e64526563656976657200000000097265636569766572000000"
        "0000000000000000000f6465746163685265636f726465720000000005766f6964"
        "00000000020000000100000018417274733a3a42797465536f756e645265636569"
        "766572000000000972656365697665720000000000000000000000000d63726561"
        "74654f626a65637400000000076f626a6563740000000002000000010000000773"
        "7472696e6700000000056e616d650000000000000000000000000e5f6765745f6f"
        "7574737461636b0000000018417274733a3a53746572656f456666656374537461"
        "636b00000000020000000000000000000000195f6765745f6d696e53747265616d"
        "42756666657254696d650000000006666c6f617400000000020000000000000000"
        "000000165f6765745f73657276657242756666657254696d650000000006666c6f"
        "617400000000020000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_SimpleSoundServer_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleSoundServer_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleSoundServer_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleSoundServer_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleSoundServer_04,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleSoundServer_05,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleSoundServer_06,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleSoundServer_07,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleSoundServer_08,this,Arts::MethodDef(m));
	Arts::PlayObjectFactory_skel::_buildMethodTable();
}

Arts::SimpleSoundServer_skel::SimpleSoundServer_skel()
{
}

Arts::Object_base* Arts::SimpleSoundServer::_Creator() {
	return Arts::SimpleSoundServer_base::_create();
}

unsigned long Arts::SimpleSoundServer_base::_IID = Arts::MCOPUtils::makeIID("Arts::SimpleSoundServer");

Arts::SoundServer_base *Arts::SoundServer_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::SoundServer_base *castedObject = (Arts::SoundServer_base *)skel->_cast(Arts::SoundServer_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::SoundServer_base *Arts::SoundServer_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::SoundServer_base::_fromReference(r,true);
	return 0;
}

Arts::SoundServer_base *Arts::SoundServer_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::SoundServer_base *castedObject = (Arts::SoundServer_base *)object._base()->_cast(Arts::SoundServer_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::SoundServer_base *Arts::SoundServer_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::SoundServer_base *result;
	result = (Arts::SoundServer_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::SoundServer");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::SoundServer_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::SoundServer")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::SoundServer_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::SoundServer_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::SoundServer_base::_cast(unsigned long iid)
{
	if(iid == Arts::SoundServer_base::_IID) return (Arts::SoundServer_base *)this;
	if(iid == Arts::SimpleSoundServer_base::_IID) return (Arts::SimpleSoundServer_base *)this;
	if(iid == Arts::PlayObjectFactory_base::_IID) return (Arts::PlayObjectFactory_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::SoundServer_stub::SoundServer_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::SoundServer_stub::SoundServer_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

bool Arts::SoundServer_stub::suspend()
{
	long methodID = _lookupMethodFast("method:0000000873757370656e640000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

bool Arts::SoundServer_stub::suspended()
{
	long methodID = _lookupMethodFast("method:0000000a73757370656e6465640000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

bool Arts::SoundServer_stub::terminate()
{
	long methodID = _lookupMethodFast("method:0000000a7465726d696e6174650000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

Arts::RealtimeStatus Arts::SoundServer_stub::realtimeStatus()
{
	long methodID = _lookupMethodFast("method:000000145f6765745f7265616c74696d655374617475730000000015417274733a3a5265616c74696d6553746174757300000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return (Arts::RealtimeStatus)0; // error occurred
	Arts::RealtimeStatus returnCode = (Arts::RealtimeStatus)result->readLong();
	delete result;
	return returnCode;
}

long Arts::SoundServer_stub::secondsUntilSuspend()
{
	long methodID = _lookupMethodFast("method:000000195f6765745f7365636f6e6473556e74696c53757370656e6400000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

std::string Arts::SoundServer_skel::_interfaceName()
{
	return "Arts::SoundServer";
}

bool Arts::SoundServer_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::SoundServer") return true;
	if (interfacename == "Arts::SimpleSoundServer") return true;
	if (interfacename == "Arts::PlayObjectFactory") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::SoundServer_skel::_interfaceNameSkel()
{
	return "Arts::SoundServer";
}

// suspend
static void _dispatch_Arts_SoundServer_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::SoundServer_skel *)object)->suspend());
}

// suspended
static void _dispatch_Arts_SoundServer_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::SoundServer_skel *)object)->suspended());
}

// terminate
static void _dispatch_Arts_SoundServer_02(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::SoundServer_skel *)object)->terminate());
}

// _get_realtimeStatus
static void _dispatch_Arts_SoundServer_03(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::SoundServer_skel *)object)->realtimeStatus());
}

// _get_secondsUntilSuspend
static void _dispatch_Arts_SoundServer_04(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::SoundServer_skel *)object)->secondsUntilSuspend());
}

void Arts::SoundServer_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000873757370656e640000000008626f6f6c65616e00000000"
        "0200000000000000000000000a73757370656e6465640000000008626f6f6c6561"
        "6e000000000200000000000000000000000a7465726d696e617465000000000862"
        "6f6f6c65616e00000000020000000000000000000000145f6765745f7265616c74"
        "696d655374617475730000000015417274733a3a5265616c74696d655374617475"
        "7300000000020000000000000000000000195f6765745f7365636f6e6473556e74"
        "696c53757370656e6400000000056c6f6e6700000000020000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_SoundServer_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServer_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServer_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServer_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServer_04,this,Arts::MethodDef(m));
	Arts::SimpleSoundServer_skel::_buildMethodTable();
}

Arts::SoundServer_skel::SoundServer_skel()
{
}

Arts::Object_base* Arts::SoundServer::_Creator() {
	return Arts::SoundServer_base::_create();
}

unsigned long Arts::SoundServer_base::_IID = Arts::MCOPUtils::makeIID("Arts::SoundServer");

Arts::SoundServerV2_base *Arts::SoundServerV2_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::SoundServerV2_base *castedObject = (Arts::SoundServerV2_base *)skel->_cast(Arts::SoundServerV2_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::SoundServerV2_base *Arts::SoundServerV2_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::SoundServerV2_base::_fromReference(r,true);
	return 0;
}

Arts::SoundServerV2_base *Arts::SoundServerV2_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::SoundServerV2_base *castedObject = (Arts::SoundServerV2_base *)object._base()->_cast(Arts::SoundServerV2_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::SoundServerV2_base *Arts::SoundServerV2_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::SoundServerV2_base *result;
	result = (Arts::SoundServerV2_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::SoundServerV2");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::SoundServerV2_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::SoundServerV2")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::SoundServerV2_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::SoundServerV2_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::SoundServerV2_base::_cast(unsigned long iid)
{
	if(iid == Arts::SoundServerV2_base::_IID) return (Arts::SoundServerV2_base *)this;
	if(iid == Arts::SoundServer_base::_IID) return (Arts::SoundServer_base *)this;
	if(iid == Arts::SimpleSoundServer_base::_IID) return (Arts::SimpleSoundServer_base *)this;
	if(iid == Arts::PlayObjectFactory_base::_IID) return (Arts::PlayObjectFactory_base *)this;
	if(iid == Arts::PlayObjectFactoryV2_base::_IID) return (Arts::PlayObjectFactoryV2_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::SoundServerV2_stub::SoundServerV2_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::SoundServerV2_stub::SoundServerV2_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void Arts::SoundServerV2_stub::checkNewObjects()
{
	long methodID = _lookupMethodFast("method:00000010636865636b4e65774f626a656374730000000005766f696400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

long Arts::SoundServerV2_stub::autoSuspendSeconds()
{
	long methodID = _lookupMethodFast("method:000000185f6765745f6175746f53757370656e645365636f6e647300000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

void Arts::SoundServerV2_stub::autoSuspendSeconds(long newValue)
{
	long methodID = _lookupMethodFast("method:000000185f7365745f6175746f53757370656e645365636f6e64730000000005766f6964000000000200000001000000056c6f6e6700000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

long Arts::SoundServerV2_stub::bufferSizeMultiplier()
{
	long methodID = _lookupMethodFast("method:0000001a5f6765745f62756666657253697a654d756c7469706c69657200000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

void Arts::SoundServerV2_stub::bufferSizeMultiplier(long newValue)
{
	long methodID = _lookupMethodFast("method:0000001a5f7365745f62756666657253697a654d756c7469706c6965720000000005766f6964000000000200000001000000056c6f6e6700000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

float Arts::SoundServerV2_stub::cpuUsage()
{
	long methodID = _lookupMethodFast("method:0000000e5f6765745f63707555736167650000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

std::string Arts::SoundServerV2_stub::audioMethod()
{
	long methodID = _lookupMethodFast("method:000000115f6765745f617564696f4d6574686f640000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occurred
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

long Arts::SoundServerV2_stub::samplingRate()
{
	long methodID = _lookupMethodFast("method:000000125f6765745f73616d706c696e675261746500000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

long Arts::SoundServerV2_stub::channels()
{
	long methodID = _lookupMethodFast("method:0000000e5f6765745f6368616e6e656c7300000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

long Arts::SoundServerV2_stub::bits()
{
	long methodID = _lookupMethodFast("method:0000000a5f6765745f6269747300000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

bool Arts::SoundServerV2_stub::fullDuplex()
{
	long methodID = _lookupMethodFast("method:000000105f6765745f66756c6c4475706c65780000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

std::string Arts::SoundServerV2_stub::audioDevice()
{
	long methodID = _lookupMethodFast("method:000000115f6765745f617564696f4465766963650000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occurred
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

long Arts::SoundServerV2_stub::fragments()
{
	long methodID = _lookupMethodFast("method:0000000f5f6765745f667261676d656e747300000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

long Arts::SoundServerV2_stub::fragmentSize()
{
	long methodID = _lookupMethodFast("method:000000125f6765745f667261676d656e7453697a6500000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

std::string Arts::SoundServerV2_stub::version()
{
	long methodID = _lookupMethodFast("method:0000000d5f6765745f76657273696f6e0000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occurred
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

Arts::StereoVolumeControl Arts::SoundServerV2_stub::outVolume()
{
	long methodID = _lookupMethodFast("method:0000000f5f6765745f6f7574566f6c756d65000000001a417274733a3a53746572656f566f6c756d65436f6e74726f6c00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::StereoVolumeControl::null();
	Arts::StereoVolumeControl_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::StereoVolumeControl::_from_base(returnCode);
}

Arts::SampleStorage Arts::SoundServerV2_stub::sampleStorage()
{
	long methodID = _lookupMethodFast("method:000000135f6765745f73616d706c6553746f726167650000000014417274733a3a53616d706c6553746f7261676500000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::SampleStorage::null();
	Arts::SampleStorage_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::SampleStorage::_from_base(returnCode);
}

std::string Arts::SoundServerV2_skel::_interfaceName()
{
	return "Arts::SoundServerV2";
}

bool Arts::SoundServerV2_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::SoundServerV2") return true;
	if (interfacename == "Arts::SoundServer") return true;
	if (interfacename == "Arts::SimpleSoundServer") return true;
	if (interfacename == "Arts::PlayObjectFactory") return true;
	if (interfacename == "Arts::PlayObjectFactoryV2") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::SoundServerV2_skel::_interfaceNameSkel()
{
	return "Arts::SoundServerV2";
}

// checkNewObjects
static void _dispatch_Arts_SoundServerV2_00(void *object, Arts::Buffer *, Arts::Buffer *)
{
	((Arts::SoundServerV2_skel *)object)->checkNewObjects();
}

// _get_autoSuspendSeconds
static void _dispatch_Arts_SoundServerV2_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::SoundServerV2_skel *)object)->autoSuspendSeconds());
}

// _set_autoSuspendSeconds
static void _dispatch_Arts_SoundServerV2_02(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long newValue = request->readLong();
	((Arts::SoundServerV2_skel *)object)->autoSuspendSeconds(newValue);
}

// _get_bufferSizeMultiplier
static void _dispatch_Arts_SoundServerV2_03(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::SoundServerV2_skel *)object)->bufferSizeMultiplier());
}

// _set_bufferSizeMultiplier
static void _dispatch_Arts_SoundServerV2_04(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long newValue = request->readLong();
	((Arts::SoundServerV2_skel *)object)->bufferSizeMultiplier(newValue);
}

// _get_cpuUsage
static void _dispatch_Arts_SoundServerV2_05(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::SoundServerV2_skel *)object)->cpuUsage());
}

// _get_audioMethod
static void _dispatch_Arts_SoundServerV2_06(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((Arts::SoundServerV2_skel *)object)->audioMethod());
}

// _get_samplingRate
static void _dispatch_Arts_SoundServerV2_07(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::SoundServerV2_skel *)object)->samplingRate());
}

// _get_channels
static void _dispatch_Arts_SoundServerV2_08(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::SoundServerV2_skel *)object)->channels());
}

// _get_bits
static void _dispatch_Arts_SoundServerV2_09(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::SoundServerV2_skel *)object)->bits());
}

// _get_fullDuplex
static void _dispatch_Arts_SoundServerV2_10(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::SoundServerV2_skel *)object)->fullDuplex());
}

// _get_audioDevice
static void _dispatch_Arts_SoundServerV2_11(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((Arts::SoundServerV2_skel *)object)->audioDevice());
}

// _get_fragments
static void _dispatch_Arts_SoundServerV2_12(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::SoundServerV2_skel *)object)->fragments());
}

// _get_fragmentSize
static void _dispatch_Arts_SoundServerV2_13(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::SoundServerV2_skel *)object)->fragmentSize());
}

// _get_version
static void _dispatch_Arts_SoundServerV2_14(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((Arts::SoundServerV2_skel *)object)->version());
}

// _get_outVolume
static void _dispatch_Arts_SoundServerV2_15(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::StereoVolumeControl returnCode = ((Arts::SoundServerV2_skel *)object)->outVolume();
	Arts::writeObject(*result,returnCode._base());
}

// _get_sampleStorage
static void _dispatch_Arts_SoundServerV2_16(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::SampleStorage returnCode = ((Arts::SoundServerV2_skel *)object)->sampleStorage();
	Arts::writeObject(*result,returnCode._base());
}

void Arts::SoundServerV2_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:00000010636865636b4e65774f626a656374730000000005766f69"
        "6400000000020000000000000000000000185f6765745f6175746f53757370656e"
        "645365636f6e647300000000056c6f6e6700000000020000000000000000000000"
        "185f7365745f6175746f53757370656e645365636f6e64730000000005766f6964"
        "000000000200000001000000056c6f6e6700000000096e657756616c7565000000"
        "0000000000000000001a5f6765745f62756666657253697a654d756c7469706c69"
        "657200000000056c6f6e67000000000200000000000000000000001a5f7365745f"
        "62756666657253697a654d756c7469706c6965720000000005766f696400000000"
        "0200000001000000056c6f6e6700000000096e657756616c756500000000000000"
        "00000000000e5f6765745f63707555736167650000000006666c6f617400000000"
        "020000000000000000000000115f6765745f617564696f4d6574686f6400000000"
        "07737472696e6700000000020000000000000000000000125f6765745f73616d70"
        "6c696e675261746500000000056c6f6e6700000000020000000000000000000000"
        "0e5f6765745f6368616e6e656c7300000000056c6f6e6700000000020000000000"
        "0000000000000a5f6765745f6269747300000000056c6f6e670000000002000000"
        "0000000000000000105f6765745f66756c6c4475706c65780000000008626f6f6c"
        "65616e00000000020000000000000000000000115f6765745f617564696f446576"
        "6963650000000007737472696e67000000000200000000000000000000000f5f67"
        "65745f667261676d656e747300000000056c6f6e67000000000200000000000000"
        "00000000125f6765745f667261676d656e7453697a6500000000056c6f6e670000"
        "00000200000000000000000000000d5f6765745f76657273696f6e000000000773"
        "7472696e67000000000200000000000000000000000f5f6765745f6f7574566f6c"
        "756d65000000001a417274733a3a53746572656f566f6c756d65436f6e74726f6c"
        "00000000020000000000000000000000135f6765745f73616d706c6553746f7261"
        "67650000000014417274733a3a53616d706c6553746f7261676500000000020000"
        "000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_SoundServerV2_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_04,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_05,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_06,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_07,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_08,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_09,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_10,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_11,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_12,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_13,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_14,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_15,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerV2_16,this,Arts::MethodDef(m));
	Arts::SoundServer_skel::_buildMethodTable();
	Arts::PlayObjectFactoryV2_skel::_buildMethodTable();
}

Arts::SoundServerV2_skel::SoundServerV2_skel()
{
}

Arts::Object_base* Arts::SoundServerV2::_Creator() {
	return Arts::SoundServerV2_base::_create();
}

unsigned long Arts::SoundServerV2_base::_IID = Arts::MCOPUtils::makeIID("Arts::SoundServerV2");

Arts::WavPlayObject_base *Arts::WavPlayObject_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::WavPlayObject_base *castedObject = (Arts::WavPlayObject_base *)skel->_cast(Arts::WavPlayObject_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::WavPlayObject_base *Arts::WavPlayObject_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::WavPlayObject_base::_fromReference(r,true);
	return 0;
}

Arts::WavPlayObject_base *Arts::WavPlayObject_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::WavPlayObject_base *castedObject = (Arts::WavPlayObject_base *)object._base()->_cast(Arts::WavPlayObject_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::WavPlayObject_base *Arts::WavPlayObject_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::WavPlayObject_base *result;
	result = (Arts::WavPlayObject_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::WavPlayObject");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::WavPlayObject_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::WavPlayObject")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::WavPlayObject_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::WavPlayObject_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::WavPlayObject_base::_cast(unsigned long iid)
{
	if(iid == Arts::WavPlayObject_base::_IID) return (Arts::WavPlayObject_base *)this;
	if(iid == Arts::PlayObject_base::_IID) return (Arts::PlayObject_base *)this;
	if(iid == Arts::PlayObject_private_base::_IID) return (Arts::PlayObject_private_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::WavPlayObject_stub::WavPlayObject_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::WavPlayObject_stub::WavPlayObject_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

std::string Arts::WavPlayObject_skel::_interfaceName()
{
	return "Arts::WavPlayObject";
}

bool Arts::WavPlayObject_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::WavPlayObject") return true;
	if (interfacename == "Arts::PlayObject") return true;
	if (interfacename == "Arts::PlayObject_private") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::WavPlayObject_skel::_interfaceNameSkel()
{
	return "Arts::WavPlayObject";
}

void Arts::WavPlayObject_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:",
		"MethodTable"
	);
	Arts::PlayObject_skel::_buildMethodTable();
	Arts::SynthModule_skel::_buildMethodTable();
}

Arts::WavPlayObject_skel::WavPlayObject_skel()
{
	_initStream("left",&left,10);
	_initStream("right",&right,10);
}

Arts::Object_base* Arts::WavPlayObject::_Creator() {
	return Arts::WavPlayObject_base::_create();
}

unsigned long Arts::WavPlayObject_base::_IID = Arts::MCOPUtils::makeIID("Arts::WavPlayObject");

Arts::GSLPlayObject_base *Arts::GSLPlayObject_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::GSLPlayObject_base *castedObject = (Arts::GSLPlayObject_base *)skel->_cast(Arts::GSLPlayObject_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::GSLPlayObject_base *Arts::GSLPlayObject_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::GSLPlayObject_base::_fromReference(r,true);
	return 0;
}

Arts::GSLPlayObject_base *Arts::GSLPlayObject_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::GSLPlayObject_base *castedObject = (Arts::GSLPlayObject_base *)object._base()->_cast(Arts::GSLPlayObject_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::GSLPlayObject_base *Arts::GSLPlayObject_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::GSLPlayObject_base *result;
	result = (Arts::GSLPlayObject_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::GSLPlayObject");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::GSLPlayObject_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::GSLPlayObject")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::GSLPlayObject_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::GSLPlayObject_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::GSLPlayObject_base::_cast(unsigned long iid)
{
	if(iid == Arts::GSLPlayObject_base::_IID) return (Arts::GSLPlayObject_base *)this;
	if(iid == Arts::PlayObject_base::_IID) return (Arts::PlayObject_base *)this;
	if(iid == Arts::PlayObject_private_base::_IID) return (Arts::PlayObject_private_base *)this;
	if(iid == Arts::PitchablePlayObject_base::_IID) return (Arts::PitchablePlayObject_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::GSLPlayObject_stub::GSLPlayObject_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::GSLPlayObject_stub::GSLPlayObject_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

bool Arts::GSLPlayObject_stub::done()
{
	long methodID = _lookupMethodFast("method:0000000a5f6765745f646f6e650000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occurred
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

void Arts::GSLPlayObject_stub::done(bool newValue)
{
	long methodID = _lookupMethodFast("method:0000000a5f7365745f646f6e650000000005766f696400000000020000000100000008626f6f6c65616e00000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeBool(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::GSLPlayObject_skel::_interfaceName()
{
	return "Arts::GSLPlayObject";
}

bool Arts::GSLPlayObject_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::GSLPlayObject") return true;
	if (interfacename == "Arts::PlayObject") return true;
	if (interfacename == "Arts::PlayObject_private") return true;
	if (interfacename == "Arts::PitchablePlayObject") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::GSLPlayObject_skel::_interfaceNameSkel()
{
	return "Arts::GSLPlayObject";
}

// _get_done
static void _dispatch_Arts_GSLPlayObject_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((Arts::GSLPlayObject_skel *)object)->done());
}

// _set_done
static void _dispatch_Arts_GSLPlayObject_01(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	bool newValue = request->readBool();
	((Arts::GSLPlayObject_skel *)object)->done(newValue);
}

void Arts::GSLPlayObject_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000a5f6765745f646f6e650000000008626f6f6c65616e0000"
        "00000200000000000000000000000a5f7365745f646f6e650000000005766f6964"
        "00000000020000000100000008626f6f6c65616e00000000096e657756616c7565"
        "000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_GSLPlayObject_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_GSLPlayObject_01,this,Arts::MethodDef(m));
	Arts::PlayObject_skel::_buildMethodTable();
	Arts::PitchablePlayObject_skel::_buildMethodTable();
	Arts::SynthModule_skel::_buildMethodTable();
}

Arts::GSLPlayObject_skel::GSLPlayObject_skel()
{
	_initStream("left",&left,10);
	_initStream("right",&right,10);
}

Arts::Object_base* Arts::GSLPlayObject::_Creator() {
	return Arts::GSLPlayObject_base::_create();
}

unsigned long Arts::GSLPlayObject_base::_IID = Arts::MCOPUtils::makeIID("Arts::GSLPlayObject");

Arts::SoundServerStartup_base *Arts::SoundServerStartup_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::SoundServerStartup_base *castedObject = (Arts::SoundServerStartup_base *)skel->_cast(Arts::SoundServerStartup_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::SoundServerStartup_base *Arts::SoundServerStartup_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::SoundServerStartup_base::_fromReference(r,true);
	return 0;
}

Arts::SoundServerStartup_base *Arts::SoundServerStartup_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::SoundServerStartup_base *castedObject = (Arts::SoundServerStartup_base *)object._base()->_cast(Arts::SoundServerStartup_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::SoundServerStartup_base *Arts::SoundServerStartup_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::SoundServerStartup_base *result;
	result = (Arts::SoundServerStartup_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::SoundServerStartup");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::SoundServerStartup_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::SoundServerStartup")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::SoundServerStartup_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::SoundServerStartup_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::SoundServerStartup_base::_cast(unsigned long iid)
{
	if(iid == Arts::SoundServerStartup_base::_IID) return (Arts::SoundServerStartup_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::SoundServerStartup_stub::SoundServerStartup_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::SoundServerStartup_stub::SoundServerStartup_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void Arts::SoundServerStartup_stub::lock()
{
	long methodID = _lookupMethodFast("method:000000056c6f636b0000000005766f696400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void Arts::SoundServerStartup_stub::unlock()
{
	long methodID = _lookupMethodFast("method:00000007756e6c6f636b0000000005766f696400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::SoundServerStartup_skel::_interfaceName()
{
	return "Arts::SoundServerStartup";
}

bool Arts::SoundServerStartup_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::SoundServerStartup") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::SoundServerStartup_skel::_interfaceNameSkel()
{
	return "Arts::SoundServerStartup";
}

// lock
static void _dispatch_Arts_SoundServerStartup_00(void *object, Arts::Buffer *, Arts::Buffer *)
{
	((Arts::SoundServerStartup_skel *)object)->lock();
}

// unlock
static void _dispatch_Arts_SoundServerStartup_01(void *object, Arts::Buffer *, Arts::Buffer *)
{
	((Arts::SoundServerStartup_skel *)object)->unlock();
}

void Arts::SoundServerStartup_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:000000056c6f636b0000000005766f696400000000020000000000"
        "00000000000007756e6c6f636b0000000005766f69640000000002000000000000"
        "0000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_SoundServerStartup_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SoundServerStartup_01,this,Arts::MethodDef(m));
}

Arts::SoundServerStartup_skel::SoundServerStartup_skel()
{
}

Arts::Object_base* Arts::SoundServerStartup::_Creator() {
	return Arts::SoundServerStartup_base::_create();
}

unsigned long Arts::SoundServerStartup_base::_IID = Arts::MCOPUtils::makeIID("Arts::SoundServerStartup");

static Arts::IDLFileReg IDLFileReg_soundserver("soundserver",
    "IDLFile:00000001000000000100000015417274733a3a5265616c74696d6553746174"
    "757300000000040000000b72745265616c74696d650000000000000000000000000c72"
    "744e6f537570706f72740000000001000000000000000c72744e6f5772617070657200"
    "00000002000000000000000d72744e6f5265616c74696d650000000003000000000000"
    "0000000000000000000b00000019417274733a3a53616d706c6553746f72616765456e"
    "7472790000000000000000020000000677726974650000000005766f69640000000002"
    "00000001000000062a6279746500000000056461746100000000000000000000000007"
    "66696e6973680000000005766f69640000000002000000000000000000000003000000"
    "056e616d650000000007737472696e670000000012000000000000000966696c656e61"
    "6d650000000007737472696e670000000012000000000000000a636f6d706c65746564"
    "0000000008626f6f6c65616e0000000012000000000000000000000000000000144172"
    "74733a3a53616d706c6553746f726167650000000000000000050000000c636f6e7374"
    "727563746f720000000005766f696400000000020000000200000007737472696e6700"
    "0000000a6469726563746f7279000000000000000008626f6f6c65616e000000000c63"
    "6c6561724f6e496e69740000000000000000000000000c637265617465456e74727900"
    "00000019417274733a3a53616d706c6553746f72616765456e74727900000000020000"
    "000100000007737472696e6700000000056e616d650000000000000000000000000961"
    "6464456e7472790000000005766f696400000000020000000100000019417274733a3a"
    "53616d706c6553746f72616765456e7472790000000006656e74727900000000000000"
    "00000000000c72656d6f7665456e7472790000000005766f6964000000000200000001"
    "00000019417274733a3a53616d706c6553746f72616765456e7472790000000006656e"
    "7472790000000000000000000000000a66696e64456e7472790000000019417274733a"
    "3a53616d706c6553746f72616765456e74727900000000020000000100000007737472"
    "696e6700000000056e616d650000000000000000000000000000000000000000000000"
    "0018417274733a3a42797465536f756e6450726f647563657200000000010000001241"
    "7274733a3a53796e74684d6f64756c650000000000000000040000000d73616d706c69"
    "6e675261746500000000056c6f6e67000000001200000000000000096368616e6e656c"
    "7300000000056c6f6e67000000001200000000000000056269747300000000056c6f6e"
    "67000000001200000000000000086f757464617461000000000562797465000000002a"
    "0000000000000000000000000000001a417274733a3a42797465536f756e6450726f64"
    "756365725632000000000100000018417274733a3a42797465536f756e6450726f6475"
    "636572000000000000000001000000067469746c650000000007737472696e67000000"
    "001200000000000000000000000000000018417274733a3a42797465536f756e645265"
    "636569766572000000000100000012417274733a3a53796e74684d6f64756c65000000"
    "0000000000050000000d73616d706c696e675261746500000000056c6f6e6700000000"
    "1200000000000000096368616e6e656c7300000000056c6f6e67000000001200000000"
    "000000056269747300000000056c6f6e67000000001200000000000000067469746c65"
    "0000000007737472696e6700000000120000000000000007696e646174610000000005"
    "62797465000000002900000000000000000000000000000018417274733a3a53696d70"
    "6c65536f756e64536572766572000000000100000018417274733a3a506c61794f626a"
    "656374466163746f7279000000000600000005706c617900000000056c6f6e67000000"
    "00020000000100000007737472696e67000000000966696c656e616d65000000000000"
    "000000000000076174746163680000000005766f696400000000020000000100000018"
    "417274733a3a42797465536f756e6450726f6475636572000000000970726f64756365"
    "72000000000000000000000000076465746163680000000005766f6964000000000200"
    "00000100000018417274733a3a42797465536f756e6450726f64756365720000000009"
    "70726f64756365720000000000000000000000000f6174746163685265636f72646572"
    "0000000005766f696400000000020000000100000018417274733a3a42797465536f75"
    "6e64526563656976657200000000097265636569766572000000000000000000000000"
    "0f6465746163685265636f726465720000000005766f69640000000002000000010000"
    "0018417274733a3a42797465536f756e64526563656976657200000000097265636569"
    "7665720000000000000000000000000d6372656174654f626a65637400000000076f62"
    "6a65637400000000020000000100000007737472696e6700000000056e616d65000000"
    "00000000000000000003000000096f7574737461636b0000000018417274733a3a5374"
    "6572656f456666656374537461636b000000001200000000000000146d696e53747265"
    "616d42756666657254696d650000000006666c6f617400000000120000000000000011"
    "73657276657242756666657254696d650000000006666c6f6174000000001200000000"
    "000000000000000000000012417274733a3a536f756e64536572766572000000000100"
    "000018417274733a3a53696d706c65536f756e64536572766572000000000300000008"
    "73757370656e640000000008626f6f6c65616e00000000020000000000000000000000"
    "0a73757370656e6465640000000008626f6f6c65616e00000000020000000000000000"
    "0000000a7465726d696e6174650000000008626f6f6c65616e00000000020000000000"
    "000000000000020000000f7265616c74696d655374617475730000000015417274733a"
    "3a5265616c74696d65537461747573000000001200000000000000147365636f6e6473"
    "556e74696c53757370656e6400000000056c6f6e670000000012000000000000000000"
    "00000000000014417274733a3a536f756e645365727665725632000000000200000012"
    "417274733a3a536f756e64536572766572000000001a417274733a3a506c61794f626a"
    "656374466163746f72795632000000000100000010636865636b4e65774f626a656374"
    "730000000005766f6964000000000200000000000000000000000e000000136175746f"
    "53757370656e645365636f6e647300000000056c6f6e67000000001300000000000000"
    "1562756666657253697a654d756c7469706c69657200000000056c6f6e670000000013"
    "000000000000000963707555736167650000000006666c6f6174000000001200000000"
    "0000000c617564696f4d6574686f640000000007737472696e67000000001200000000"
    "0000000d73616d706c696e675261746500000000056c6f6e6700000000120000000000"
    "0000096368616e6e656c7300000000056c6f6e67000000001200000000000000056269"
    "747300000000056c6f6e670000000012000000000000000b66756c6c4475706c657800"
    "00000008626f6f6c65616e0000000012000000000000000c617564696f446576696365"
    "0000000007737472696e670000000012000000000000000a667261676d656e74730000"
    "0000056c6f6e670000000012000000000000000d667261676d656e7453697a65000000"
    "00056c6f6e670000000012000000000000000876657273696f6e000000000773747269"
    "6e670000000012000000000000000a6f7574566f6c756d65000000001a417274733a3a"
    "53746572656f566f6c756d65436f6e74726f6c0000000012000000000000000e73616d"
    "706c6553746f726167650000000014417274733a3a53616d706c6553746f7261676500"
    "0000001200000000000000000000000000000014417274733a3a576176506c61794f62"
    "6a656374000000000200000011417274733a3a506c61794f626a656374000000001241"
    "7274733a3a53796e74684d6f64756c65000000000000000002000000056c6566740000"
    "000006666c6f6174000000000a000000000000000672696768740000000006666c6f61"
    "74000000000a00000000000000000000000000000014417274733a3a47534c506c6179"
    "4f626a656374000000000300000011417274733a3a506c61794f626a65637400000000"
    "1a417274733a3a506974636861626c65506c61794f626a656374000000001241727473"
    "3a3a53796e74684d6f64756c6500000000000000000300000005646f6e650000000008"
    "626f6f6c65616e000000001300000000000000056c6566740000000006666c6f617400"
    "0000000a000000000000000672696768740000000006666c6f6174000000000a000000"
    "00000000000000000000000019417274733a3a536f756e645365727665725374617274"
    "7570000000000000000002000000056c6f636b0000000005766f696400000000020000"
    "00000000000000000007756e6c6f636b0000000005766f696400000000020000000000"
    "00000000000000000000000000000000000000"
);
