; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin | FileCheck %s

define zeroext i1 @f1(ptr %x) {
; CHECK-LABEL: f1:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    movzbl (%rdi), %eax
; CHECK-NEXT:    retq

entry:
  %0 = load i8, ptr %x, align 1, !range !0, !noundef !{}
  %tobool = trunc i8 %0 to i1
  ret i1 %tobool
}

define zeroext i1 @f2(ptr %x) {
; CHECK-LABEL: f2:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    movzbl (%rdi), %eax
; CHECK-NEXT:    retq

entry:
  %0 = load i8, ptr %x, align 1, !range !0, !noundef !{}
  %tobool = icmp ne i8 %0, 0
  ret i1 %tobool
}

!0 = !{i8 0, i8 2}


; check that we don't build a "trunc" from i1 to i1, which would assert.
define zeroext i1 @f3(i1 %x) {
; CHECK-LABEL: f3:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    andb $1, %al
; CHECK-NEXT:    ## kill: def $al killed $al killed $eax
; CHECK-NEXT:    retq

entry:
  %tobool = icmp ne i1 %x, 0
  ret i1 %tobool
}

; check that we don't build a trunc when other bits are needed
define zeroext i1 @f4(i32 %x) {
; CHECK-LABEL: f4:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    movzwl %di, %eax
; CHECK-NEXT:    shrl $15, %eax
; CHECK-NEXT:    ## kill: def $al killed $al killed $eax
; CHECK-NEXT:    retq

entry:
  %y = and i32 %x, 32768
  %z = icmp ne i32 %y, 0
  ret i1 %z
}
