; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=arm64-eabi -aarch64-neon-syntax=apple -mcpu=cyclone | FileCheck %s

define double @foo(<2 x double> %a) nounwind {
; CHECK-LABEL: foo:
; CHECK:       // %bb.0:
; CHECK-NEXT:    faddp.2d d0, v0
; CHECK-NEXT:    ret
  %lane0.i = extractelement <2 x double> %a, i32 0
  %lane1.i = extractelement <2 x double> %a, i32 1
  %vpaddd.i = fadd double %lane0.i, %lane1.i
  ret double %vpaddd.i
}

define i64 @foo0(<2 x i64> %a) nounwind {
; CHECK-LABEL: foo0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    addp.2d d0, v0
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
  %lane0.i = extractelement <2 x i64> %a, i32 0
  %lane1.i = extractelement <2 x i64> %a, i32 1
  %vpaddd.i = add i64 %lane0.i, %lane1.i
  ret i64 %vpaddd.i
}

define float @foo1(<2 x float> %a) nounwind {
; CHECK-LABEL: foo1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    faddp.2s s0, v0
; CHECK-NEXT:    ret
  %lane0.i = extractelement <2 x float> %a, i32 0
  %lane1.i = extractelement <2 x float> %a, i32 1
  %vpaddd.i = fadd float %lane0.i, %lane1.i
  ret float %vpaddd.i
}


define <2 x i64> @addp_v2i64(<2 x i64> %a) {
; CHECK-LABEL: addp_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ext.16b v1, v0, v0, #8
; CHECK-NEXT:    add.2d v0, v1, v0
; CHECK-NEXT:    ret
entry:
  %s = shufflevector <2 x i64> %a, <2 x i64> poison, <2 x i32> <i32 1, i32 0>
  %b = add <2 x i64> %s, %a
  ret <2 x i64> %b
}

define <4 x i64> @addp_v4i64(<4 x i64> %a) {
; CHECK-LABEL: addp_v4i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    addp.2d v1, v0, v1
; CHECK-NEXT:    dup.2d v0, v1[0]
; CHECK-NEXT:    dup.2d v1, v1[1]
; CHECK-NEXT:    ret
entry:
  %s = shufflevector <4 x i64> %a, <4 x i64> poison, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %b = add <4 x i64> %s, %a
  ret <4 x i64> %b
}

define <4 x i32> @addp_v4i32(<4 x i32> %a) {
; CHECK-LABEL: addp_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    rev64.4s v1, v0
; CHECK-NEXT:    add.4s v0, v1, v0
; CHECK-NEXT:    ret
entry:
  %s = shufflevector <4 x i32> %a, <4 x i32> poison, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %b = add <4 x i32> %s, %a
  ret <4 x i32> %b
}

define <8 x i32> @addp_v8i32(<8 x i32> %a) {
; CHECK-LABEL: addp_v8i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    addp.4s v1, v0, v1
; CHECK-NEXT:    zip1.4s v0, v1, v1
; CHECK-NEXT:    zip2.4s v1, v1, v1
; CHECK-NEXT:    ret
entry:
  %s = shufflevector <8 x i32> %a, <8 x i32> poison, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  %b = add <8 x i32> %s, %a
  ret <8 x i32> %b
}

define <16 x i32> @addp_v16i32(<16 x i32> %a) {
; CHECK-LABEL: addp_v16i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    addp.4s v1, v0, v1
; CHECK-NEXT:    zip1.4s v0, v1, v1
; CHECK-NEXT:    zip2.4s v1, v1, v1
; CHECK-NEXT:    addp.4s v3, v2, v3
; CHECK-NEXT:    zip1.4s v2, v3, v3
; CHECK-NEXT:    zip2.4s v3, v3, v3
; CHECK-NEXT:    ret
entry:
  %s = shufflevector <16 x i32> %a, <16 x i32> poison, <16 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6, i32 9, i32 8, i32 11, i32 10, i32 13, i32 12, i32 15, i32 14>
  %b = add <16 x i32> %s, %a
  ret <16 x i32> %b
}

define <8 x i16> @addp_v8i16(<8 x i16> %a) {
; CHECK-LABEL: addp_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    rev32.8h v1, v0
; CHECK-NEXT:    add.8h v0, v1, v0
; CHECK-NEXT:    ret
entry:
  %s = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  %b = add <8 x i16> %s, %a
  ret <8 x i16> %b
}

define <16 x i16> @addp_v16i16(<16 x i16> %a) {
; CHECK-LABEL: addp_v16i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    addp.8h v1, v0, v1
; CHECK-NEXT:    zip1.8h v0, v1, v1
; CHECK-NEXT:    zip2.8h v1, v1, v1
; CHECK-NEXT:    ret
entry:
  %s = shufflevector <16 x i16> %a, <16 x i16> poison, <16 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6, i32 9, i32 8, i32 11, i32 10, i32 13, i32 12, i32 15, i32 14>
  %b = add <16 x i16> %s, %a
  ret <16 x i16> %b
}

define <16 x i8> @addp_v16i8(<16 x i8> %a) {
; CHECK-LABEL: addp_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    rev16.16b v1, v0
; CHECK-NEXT:    add.16b v0, v1, v0
; CHECK-NEXT:    ret
entry:
  %s = shufflevector <16 x i8> %a, <16 x i8> poison, <16 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6, i32 9, i32 8, i32 11, i32 10, i32 13, i32 12, i32 15, i32 14>
  %b = add <16 x i8> %s, %a
  ret <16 x i8> %b
}

define <32 x i8> @addp_v32i8(<32 x i8> %a) {
; CHECK-LABEL: addp_v32i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    addp.16b v1, v0, v1
; CHECK-NEXT:    zip1.16b v0, v1, v1
; CHECK-NEXT:    zip2.16b v1, v1, v1
; CHECK-NEXT:    ret
entry:
  %s = shufflevector <32 x i8> %a, <32 x i8> poison, <32 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6, i32 9, i32 8, i32 11, i32 10, i32 13, i32 12, i32 15, i32 14, i32 17, i32 16, i32 19, i32 18, i32 21, i32 20, i32 23, i32 22, i32 25, i32 24, i32 27, i32 26, i32 29, i32 28, i32 31, i32 30>
  %b = add <32 x i8> %s, %a
  ret <32 x i8> %b
}
