; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64-windows-msvc -mattr=+sve < %s | FileCheck %s
; RUN: llc -mtriple=aarch64-windows-msvc -mattr=+sve -filetype=obj < %s -o /dev/null

declare void @g()
define i32 @f(<vscale x 2 x i64> %x) {
; CHECK-LABEL: f:
; CHECK:       .seh_proc f
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    addvl sp, sp, #-18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    str p4, [sp] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    str p5, [sp, #1, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    str p6, [sp, #2, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    str p7, [sp, #3, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    str p8, [sp, #4, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    str p9, [sp, #5, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    str p10, [sp, #6, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    str p11, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    str p12, [sp, #8, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    str p13, [sp, #9, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    str p14, [sp, #10, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    str p15, [sp, #11, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    str z8, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    str z9, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    str z10, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    str z11, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    str z12, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    str z13, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    str z14, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    str z16, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    str z17, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    str z18, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    str z19, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    str z20, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    str z21, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    str z22, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    str z23, [sp, #17, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    str x28, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x28, 16
; CHECK-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg x30, 8
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    bl g
; CHECK-NEXT:    mov w0, #3 // =0x3
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x30, 8
; CHECK-NEXT:    ldr x28, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x28, 0
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    ldr z8, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    ldr z9, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    ldr z10, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    ldr z11, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    ldr z12, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    ldr z13, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    ldr z14, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    ldr z16, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    ldr z17, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    ldr z18, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    ldr z19, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    ldr z20, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    ldr z21, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    ldr z22, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    ldr z23, [sp, #17, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    ldr p4, [sp] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    ldr p5, [sp, #1, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    ldr p6, [sp, #2, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    ldr p7, [sp, #3, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    ldr p8, [sp, #4, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    ldr p9, [sp, #5, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    ldr p10, [sp, #6, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    ldr p11, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    ldr p12, [sp, #8, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    ldr p13, [sp, #9, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    ldr p14, [sp, #10, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    ldr p15, [sp, #11, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    addvl sp, sp, #18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
  call void @g()
  ret i32 3
}

declare void @g2(ptr,ptr)
define void @f2(i64 %n, <vscale x 2 x i64> %x) {
; CHECK-LABEL: f2:
; CHECK:       .seh_proc f2
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    addvl sp, sp, #-18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    str p4, [sp] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    str p5, [sp, #1, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    str p6, [sp, #2, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    str p7, [sp, #3, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    str p8, [sp, #4, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    str p9, [sp, #5, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    str p10, [sp, #6, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    str p11, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    str p12, [sp, #8, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    str p13, [sp, #9, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    str p14, [sp, #10, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    str p15, [sp, #11, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    str z8, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    str z9, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    str z10, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    str z11, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    str z12, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    str z13, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    str z14, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    str z16, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    str z17, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    str z18, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    str z19, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    str z20, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    str z21, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    str z22, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    str z23, [sp, #17, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    str x19, [sp, #-32]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x19, 32
; CHECK-NEXT:    str x28, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg x28, 8
; CHECK-NEXT:    stp x29, x30, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_fplr 16
; CHECK-NEXT:    add x29, sp, #16
; CHECK-NEXT:    .seh_add_fp 16
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    sub sp, sp, #32
; CHECK-NEXT:    lsl x8, x0, #3
; CHECK-NEXT:    mov x19, sp
; CHECK-NEXT:    add x8, x8, #15
; CHECK-NEXT:    lsr x15, x8, #4
; CHECK-NEXT:    bl __chkstk
; CHECK-NEXT:    sub x1, sp, x15, lsl #4
; CHECK-NEXT:    mov sp, x1
; CHECK-NEXT:    add x0, x19, #0
; CHECK-NEXT:    bl g2
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    sub sp, x29, #16
; CHECK-NEXT:    .seh_add_fp 16
; CHECK-NEXT:    ldp x29, x30, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_fplr 16
; CHECK-NEXT:    ldr x28, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x28, 8
; CHECK-NEXT:    ldr x19, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x19, 0
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    .seh_stackalloc 32
; CHECK-NEXT:    ldr z8, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    ldr z9, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    ldr z10, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    ldr z11, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    ldr z12, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    ldr z13, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    ldr z14, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    ldr z16, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    ldr z17, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    ldr z18, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    ldr z19, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    ldr z20, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    ldr z21, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    ldr z22, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    ldr z23, [sp, #17, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    ldr p4, [sp] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    ldr p5, [sp, #1, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    ldr p6, [sp, #2, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    ldr p7, [sp, #3, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    ldr p8, [sp, #4, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    ldr p9, [sp, #5, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    ldr p10, [sp, #6, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    ldr p11, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    ldr p12, [sp, #8, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    ldr p13, [sp, #9, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    ldr p14, [sp, #10, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    ldr p15, [sp, #11, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    addvl sp, sp, #18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
  %p1 = alloca [4 x i64]
  %p2 = alloca i64, i64 %n
  call void @g2(ptr %p1, ptr %p2)
  ret void
}

declare void @g3(ptr,ptr)
define void @f3(i64 %n, <vscale x 2 x i64> %x) {
; CHECK-LABEL: f3:
; CHECK:       .seh_proc f3
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    addvl sp, sp, #-18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    str p4, [sp] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    str p5, [sp, #1, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    str p6, [sp, #2, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    str p7, [sp, #3, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    str p8, [sp, #4, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    str p9, [sp, #5, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    str p10, [sp, #6, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    str p11, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    str p12, [sp, #8, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    str p13, [sp, #9, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    str p14, [sp, #10, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    str p15, [sp, #11, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    str z8, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    str z9, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    str z10, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    str z11, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    str z12, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    str z13, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    str z14, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    str z16, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    str z17, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    str z18, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    str z19, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    str z20, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    str z21, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    str z22, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    str z23, [sp, #17, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    str x28, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x28, 16
; CHECK-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg x30, 8
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    add x0, sp, #8
; CHECK-NEXT:    mov x1, sp
; CHECK-NEXT:    bl g3
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x30, 8
; CHECK-NEXT:    ldr x28, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x28, 0
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    ldr z8, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    ldr z9, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    ldr z10, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    ldr z11, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    ldr z12, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    ldr z13, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    ldr z14, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    ldr z16, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    ldr z17, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    ldr z18, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    ldr z19, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    ldr z20, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    ldr z21, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    ldr z22, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    ldr z23, [sp, #17, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    ldr p4, [sp] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    ldr p5, [sp, #1, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    ldr p6, [sp, #2, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    ldr p7, [sp, #3, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    ldr p8, [sp, #4, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    ldr p9, [sp, #5, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    ldr p10, [sp, #6, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    ldr p11, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    ldr p12, [sp, #8, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    ldr p13, [sp, #9, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    ldr p14, [sp, #10, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    ldr p15, [sp, #11, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    addvl sp, sp, #18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
  %p1 = alloca i64
  %p2 = alloca i64
  call void @g3(ptr %p1, ptr %p2)
  ret void
}

declare void @g4(ptr,ptr)
define void @f4(i64 %n, <vscale x 2 x i64> %x) {
; CHECK-LABEL: f4:
; CHECK:       .seh_proc f4
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    addvl sp, sp, #-18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    str p4, [sp] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    str p5, [sp, #1, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    str p6, [sp, #2, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    str p7, [sp, #3, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    str p8, [sp, #4, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    str p9, [sp, #5, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    str p10, [sp, #6, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    str p11, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    str p12, [sp, #8, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    str p13, [sp, #9, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    str p14, [sp, #10, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    str p15, [sp, #11, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    str z8, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    str z9, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    str z10, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    str z11, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    str z12, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    str z13, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    str z14, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    str z16, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    str z17, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    str z18, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    str z19, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    str z20, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    str z21, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    str z22, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    str z23, [sp, #17, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    str x28, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x28, 16
; CHECK-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg x30, 8
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    add x1, sp, #16
; CHECK-NEXT:    bl g4
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x30, 8
; CHECK-NEXT:    ldr x28, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x28, 0
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    ldr z8, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    ldr z9, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    ldr z10, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    ldr z11, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    ldr z12, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    ldr z13, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    ldr z14, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    ldr z16, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    ldr z17, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    ldr z18, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    ldr z19, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    ldr z20, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    ldr z21, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    ldr z22, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    ldr z23, [sp, #17, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    ldr p4, [sp] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    ldr p5, [sp, #1, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    ldr p6, [sp, #2, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    ldr p7, [sp, #3, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    ldr p8, [sp, #4, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    ldr p9, [sp, #5, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    ldr p10, [sp, #6, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    ldr p11, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    ldr p12, [sp, #8, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    ldr p13, [sp, #9, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    ldr p14, [sp, #10, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    ldr p15, [sp, #11, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    addvl sp, sp, #18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
  %p1 = alloca [2 x i64]
  %p2 = alloca <vscale x 2 x i64>
  call void @g4(ptr %p1, ptr %p2)
  ret void
}

declare void @g5(ptr,ptr,ptr)
define void @f5(i64 %n, <vscale x 2 x i64> %x) {
; CHECK-LABEL: f5:
; CHECK:       .seh_proc f5
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    addvl sp, sp, #-18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    str p4, [sp] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    str p5, [sp, #1, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    str p6, [sp, #2, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    str p7, [sp, #3, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    str p8, [sp, #4, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    str p9, [sp, #5, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    str p10, [sp, #6, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    str p11, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    str p12, [sp, #8, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    str p13, [sp, #9, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    str p14, [sp, #10, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    str p15, [sp, #11, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    str z8, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    str z9, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    str z10, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    str z11, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    str z12, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    str z13, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    str z14, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    str z16, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    str z17, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    str z18, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    str z19, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    str z20, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    str z21, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    str z22, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    str z23, [sp, #17, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    str x19, [sp, #-32]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x19, 32
; CHECK-NEXT:    str x28, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg x28, 8
; CHECK-NEXT:    stp x29, x30, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_fplr 16
; CHECK-NEXT:    add x29, sp, #16
; CHECK-NEXT:    .seh_add_fp 16
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    lsl x8, x0, #3
; CHECK-NEXT:    mov x19, sp
; CHECK-NEXT:    add x8, x8, #15
; CHECK-NEXT:    lsr x15, x8, #4
; CHECK-NEXT:    bl __chkstk
; CHECK-NEXT:    sub x2, sp, x15, lsl #4
; CHECK-NEXT:    mov sp, x2
; CHECK-NEXT:    sub x1, x29, #16
; CHECK-NEXT:    add x0, x19, #0
; CHECK-NEXT:    addvl x1, x1, #-1
; CHECK-NEXT:    bl g5
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    sub sp, x29, #16
; CHECK-NEXT:    .seh_add_fp 16
; CHECK-NEXT:    ldp x29, x30, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_fplr 16
; CHECK-NEXT:    ldr x28, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x28, 8
; CHECK-NEXT:    ldr x19, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x19, 0
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    .seh_stackalloc 32
; CHECK-NEXT:    ldr z8, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    ldr z9, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    ldr z10, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    ldr z11, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    ldr z12, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    ldr z13, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    ldr z14, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    ldr z16, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    ldr z17, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    ldr z18, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    ldr z19, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    ldr z20, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    ldr z21, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    ldr z22, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    ldr z23, [sp, #17, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    ldr p4, [sp] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    ldr p5, [sp, #1, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    ldr p6, [sp, #2, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    ldr p7, [sp, #3, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    ldr p8, [sp, #4, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    ldr p9, [sp, #5, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    ldr p10, [sp, #6, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    ldr p11, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    ldr p12, [sp, #8, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    ldr p13, [sp, #9, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    ldr p14, [sp, #10, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    ldr p15, [sp, #11, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    addvl sp, sp, #18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
  %p1 = alloca [8 x i64]
  %p2 = alloca <vscale x 2 x i64>
  %p3 = alloca i64, i64 %n
  call void @g5(ptr %p1, ptr %p2, ptr %p3)
  ret void
}

declare dso_local i32 @__CxxFrameHandler3(...)
declare void @g6(ptr, i64)
declare void @cleanup()
define void @f6(<vscale x 2 x i64> %x, [8 x i64] %pad, i64 %n9) personality ptr @__CxxFrameHandler3 {
; CHECK-LABEL: f6:
; CHECK:       .Lfunc_begin0:
; CHECK-NEXT:  .seh_proc f6
; CHECK-NEXT:    .seh_handler __CxxFrameHandler3, @unwind, @except
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    addvl sp, sp, #-18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    str p4, [sp] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    str p5, [sp, #1, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    str p6, [sp, #2, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    str p7, [sp, #3, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    str p8, [sp, #4, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    str p9, [sp, #5, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    str p10, [sp, #6, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    str p11, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    str p12, [sp, #8, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    str p13, [sp, #9, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    str p14, [sp, #10, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    str p15, [sp, #11, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    str z8, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    str z9, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    str z10, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    str z11, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    str z12, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    str z13, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    str z14, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    str z16, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    str z17, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    str z18, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    str z19, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    str z20, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    str z21, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    str z22, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    str z23, [sp, #17, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    str x19, [sp, #-32]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x19, 32
; CHECK-NEXT:    str x28, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg x28, 8
; CHECK-NEXT:    stp x29, x30, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_fplr 16
; CHECK-NEXT:    add x29, sp, #16
; CHECK-NEXT:    .seh_add_fp 16
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    mov x0, #-2 // =0xfffffffffffffffe
; CHECK-NEXT:    addvl x8, x29, #18
; CHECK-NEXT:    mov x19, sp
; CHECK-NEXT:    stur x0, [x8, #16]
; CHECK-NEXT:    addvl x8, x29, #18
; CHECK-NEXT:    ldr x1, [x8, #32]
; CHECK-NEXT:  .Ltmp0:
; CHECK-NEXT:    add x0, x19, #0
; CHECK-NEXT:    bl g6
; CHECK-NEXT:  .Ltmp1:
; CHECK-NEXT:  // %bb.1: // %invoke.cont
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    .seh_stackalloc 64
; CHECK-NEXT:    ldp x29, x30, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_fplr 16
; CHECK-NEXT:    ldr x28, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x28, 8
; CHECK-NEXT:    ldr x19, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x19, 0
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    .seh_stackalloc 32
; CHECK-NEXT:    ldr z8, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    ldr z9, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    ldr z10, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    ldr z11, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    ldr z12, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    ldr z13, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    ldr z14, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    ldr z16, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    ldr z17, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    ldr z18, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    ldr z19, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    ldr z20, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    ldr z21, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    ldr z22, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    ldr z23, [sp, #17, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    ldr p4, [sp] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    ldr p5, [sp, #1, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    ldr p6, [sp, #2, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    ldr p7, [sp, #3, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    ldr p8, [sp, #4, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    ldr p9, [sp, #5, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    ldr p10, [sp, #6, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    ldr p11, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    ldr p12, [sp, #8, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    ldr p13, [sp, #9, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    ldr p14, [sp, #10, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    ldr p15, [sp, #11, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    addvl sp, sp, #18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_handlerdata
; CHECK-NEXT:    .word $cppxdata$f6@IMGREL
; CHECK-NEXT:    .text
; CHECK-NEXT:    .seh_endproc
; CHECK-NEXT:    .def "?dtor$2@?0?f6@4HA";
; CHECK-NEXT:    .scl 3;
; CHECK-NEXT:    .type 32;
; CHECK-NEXT:    .endef
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  "?dtor$2@?0?f6@4HA":
; CHECK-NEXT:  .seh_proc "?dtor$2@?0?f6@4HA"
; CHECK-NEXT:  .LBB5_2: // %ehcleanup
; CHECK-NEXT:    addvl sp, sp, #-18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    str p4, [sp] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    str p5, [sp, #1, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    str p6, [sp, #2, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    str p7, [sp, #3, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    str p8, [sp, #4, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    str p9, [sp, #5, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    str p10, [sp, #6, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    str p11, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    str p12, [sp, #8, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    str p13, [sp, #9, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    str p14, [sp, #10, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    str p15, [sp, #11, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    str z8, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    str z9, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    str z10, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    str z11, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    str z12, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    str z13, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    str z14, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    str z16, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    str z17, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    str z18, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    str z19, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    str z20, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    str z21, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    str z22, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    str z23, [sp, #17, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    str x19, [sp, #-32]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x19, 32
; CHECK-NEXT:    str x28, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg x28, 8
; CHECK-NEXT:    stp x29, x30, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_fplr 16
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    bl cleanup
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    ldp x29, x30, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_fplr 16
; CHECK-NEXT:    ldr x28, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x28, 8
; CHECK-NEXT:    ldr x19, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x19, 0
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    .seh_stackalloc 32
; CHECK-NEXT:    ldr z8, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    ldr z9, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    ldr z10, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    ldr z11, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    ldr z12, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    ldr z13, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    ldr z14, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    ldr z16, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    ldr z17, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    ldr z18, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    ldr z19, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    ldr z20, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    ldr z21, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    ldr z22, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    ldr z23, [sp, #17, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    ldr p4, [sp] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    ldr p5, [sp, #1, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    ldr p6, [sp, #2, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    ldr p7, [sp, #3, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    ldr p8, [sp, #4, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    ldr p9, [sp, #5, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    ldr p10, [sp, #6, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    ldr p11, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    ldr p12, [sp, #8, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    ldr p13, [sp, #9, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    ldr p14, [sp, #10, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    ldr p15, [sp, #11, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    addvl sp, sp, #18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
  %p1 = alloca [8 x i64]
  invoke void @g6(ptr %p1, i64 %n9) to label %invoke.cont unwind label %ehcleanup

invoke.cont:
  ret void

ehcleanup:                                        ; preds = %entry
  %c = cleanuppad within none []
  call void @cleanup() [ "funclet"(token %c) ]
  cleanupret from %c unwind to caller
}

declare void @g7(ptr)
define void @f7(i64 %n) {
; CHECK-LABEL: f7:
; CHECK:       .seh_proc f7
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    str x28, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x28, 16
; CHECK-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg x30, 8
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    bl g7
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x30, 8
; CHECK-NEXT:    ldr x28, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg_x x28, 16
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
  %p = alloca <vscale x 2 x i64>
  call void @g7(ptr %p)
  ret void
}

define void @f8(<vscale x 2 x i64> %v) {
; CHECK-LABEL: f8:
; CHECK:       .seh_proc f8
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    str z8, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x30, 16
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    //APP
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    ldr x30, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x30, 0
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    ldr z8, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
  call void asm "", "~{d8}"()
  ret void
}

define void @f9(<vscale x 2 x i64> %v, ...) {
; CHECK-LABEL: f9:
; CHECK:       .seh_proc f9
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    .seh_stackalloc 64
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    str z8, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x30, 16
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    addvl x8, sp, #1
; CHECK-NEXT:    add x9, sp, #8
; CHECK-NEXT:    str x2, [x8, #32]
; CHECK-NEXT:    addvl x8, sp, #1
; CHECK-NEXT:    str x0, [x8, #16]
; CHECK-NEXT:    addvl x8, sp, #1
; CHECK-NEXT:    str x1, [x8, #24]
; CHECK-NEXT:    addvl x8, sp, #1
; CHECK-NEXT:    str x3, [x8, #40]
; CHECK-NEXT:    addvl x8, sp, #1
; CHECK-NEXT:    str x4, [x8, #48]
; CHECK-NEXT:    addvl x8, sp, #1
; CHECK-NEXT:    str x5, [x8, #56]
; CHECK-NEXT:    addvl x8, sp, #1
; CHECK-NEXT:    str x6, [x8, #64]
; CHECK-NEXT:    addvl x8, sp, #1
; CHECK-NEXT:    str x7, [x8, #72]
; CHECK-NEXT:    add x8, sp, #16
; CHECK-NEXT:    addvl x8, x8, #1
; CHECK-NEXT:    str x8, [sp, #8]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    ldr x30, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x30, 0
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    ldr z8, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    .seh_stackalloc 64
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    .seh_stackalloc 64
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
  %va_list = alloca ptr
  call void @llvm.va_start.p0(ptr %va_list)
  call void asm "", "r,~{d8},~{memory}"(ptr %va_list)
  ret void
}

declare void @g10(ptr,ptr)
define void @f10(i64 %n, <vscale x 2 x i64> %x) "frame-pointer"="all" {
; CHECK-LABEL: f10:
; CHECK:       .seh_proc f10
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    addvl sp, sp, #-18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    str p4, [sp] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    str p5, [sp, #1, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    str p6, [sp, #2, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    str p7, [sp, #3, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    str p8, [sp, #4, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    str p9, [sp, #5, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    str p10, [sp, #6, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    str p11, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    str p12, [sp, #8, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    str p13, [sp, #9, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    str p14, [sp, #10, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    str p15, [sp, #11, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    str z8, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    str z9, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    str z10, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    str z11, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    str z12, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    str z13, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    str z14, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    str z16, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    str z17, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    str z18, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    str z19, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    str z20, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    str z21, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    str z22, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    str z23, [sp, #17, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    str x28, [sp, #-32]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x28, 32
; CHECK-NEXT:    stp x29, x30, [sp, #8] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_fplr 8
; CHECK-NEXT:    add x29, sp, #8
; CHECK-NEXT:    .seh_add_fp 8
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    sub x1, x29, #8
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    addvl x1, x1, #-1
; CHECK-NEXT:    bl g10
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    ldp x29, x30, [sp, #8] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_fplr 8
; CHECK-NEXT:    ldr x28, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x28, 0
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    .seh_stackalloc 32
; CHECK-NEXT:    ldr z8, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 2
; CHECK-NEXT:    ldr z9, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z9, 3
; CHECK-NEXT:    ldr z10, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z10, 4
; CHECK-NEXT:    ldr z11, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z11, 5
; CHECK-NEXT:    ldr z12, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z12, 6
; CHECK-NEXT:    ldr z13, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z13, 7
; CHECK-NEXT:    ldr z14, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z14, 8
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z15, 9
; CHECK-NEXT:    ldr z16, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z16, 10
; CHECK-NEXT:    ldr z17, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z17, 11
; CHECK-NEXT:    ldr z18, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z18, 12
; CHECK-NEXT:    ldr z19, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z19, 13
; CHECK-NEXT:    ldr z20, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z20, 14
; CHECK-NEXT:    ldr z21, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z21, 15
; CHECK-NEXT:    ldr z22, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z22, 16
; CHECK-NEXT:    ldr z23, [sp, #17, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z23, 17
; CHECK-NEXT:    ldr p4, [sp] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p4, 0
; CHECK-NEXT:    ldr p5, [sp, #1, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p5, 1
; CHECK-NEXT:    ldr p6, [sp, #2, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p6, 2
; CHECK-NEXT:    ldr p7, [sp, #3, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p7, 3
; CHECK-NEXT:    ldr p8, [sp, #4, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p8, 4
; CHECK-NEXT:    ldr p9, [sp, #5, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p9, 5
; CHECK-NEXT:    ldr p10, [sp, #6, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p10, 6
; CHECK-NEXT:    ldr p11, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p11, 7
; CHECK-NEXT:    ldr p12, [sp, #8, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p12, 8
; CHECK-NEXT:    ldr p13, [sp, #9, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p13, 9
; CHECK-NEXT:    ldr p14, [sp, #10, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p14, 10
; CHECK-NEXT:    ldr p15, [sp, #11, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    .seh_save_preg p15, 11
; CHECK-NEXT:    addvl sp, sp, #18
; CHECK-NEXT:    .seh_allocz 18
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
  %p1 = alloca [2 x i64]
  %p2 = alloca <vscale x 2 x i64>
  call void @g10(ptr %p1, ptr %p2)
  ret void
}

; Check handling of alloca allocated into CSR space, no frame pointer.
define i32 @f11(double %d, <vscale x 4 x i32> %vs) "aarch64_pstate_sm_compatible" {
; CHECK-LABEL: f11:
; CHECK:       .seh_proc f11
; CHECK-NEXT:  // %bb.0: // %entry
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    str z8, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x30, 16
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    //APP
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    str d0, [sp, #8]
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    ldr x30, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x30, 0
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    ldr z8, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
entry:
  %a = alloca double
  tail call void asm sideeffect "", "~{d8}"() #1
  store double %d, ptr %a
  ret i32 0
}

define i32 @f12(double %d, <vscale x 4 x i32> %vs) "aarch64_pstate_sm_compatible" {
; CHECK-LABEL: f12:
; CHECK:       .seh_proc f12
; CHECK-NEXT:  // %bb.0: // %entry
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    str z8, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x30, 16
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    addvl x8, sp, #1
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    //APP
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    str d0, [x8, #8]
; CHECK-NEXT:    str d0, [sp]
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    ldr x30, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x30, 0
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    ldr z8, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
entry:
  %a = alloca double
  %b = alloca <vscale x 16 x i8>
  tail call void asm sideeffect "", "~{d8}"() #1
  store double %d, ptr %a
  store double %d, ptr %b
  ret i32 0
}

; Check handling of alloca allocated into CSR space, with frame pointer.
define i32 @f13(double %d, <vscale x 4 x i32> %vs) "frame-pointer"="all" {
; CHECK-LABEL: f13:
; CHECK:       .seh_proc f13
; CHECK-NEXT:  // %bb.0: // %entry
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    str z8, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    str x28, [sp, #-32]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x28, 32
; CHECK-NEXT:    stp x29, x30, [sp, #8] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_fplr 8
; CHECK-NEXT:    add x29, sp, #8
; CHECK-NEXT:    .seh_add_fp 8
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    //APP
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    str d0, [x29, #16]
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    ldp x29, x30, [sp, #8] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_fplr 8
; CHECK-NEXT:    ldr x28, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x28, 0
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    .seh_stackalloc 32
; CHECK-NEXT:    ldr z8, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
entry:
  %a = alloca double
  tail call void asm sideeffect "", "~{d8},~{x28}"() #1
  store double %d, ptr %a
  ret i32 0
}

define i32 @f14(double %d, <vscale x 4 x i32> %vs) "frame-pointer"="all" {
; CHECK-LABEL: f14:
; CHECK:       .seh_proc f14
; CHECK-NEXT:  // %bb.0: // %entry
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    str z8, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    str x28, [sp, #-32]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x28, 32
; CHECK-NEXT:    stp x29, x30, [sp, #8] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_fplr 8
; CHECK-NEXT:    add x29, sp, #8
; CHECK-NEXT:    .seh_add_fp 8
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    addvl x8, x29, #-1
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    //APP
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    str d0, [x29, #16]
; CHECK-NEXT:    stur d0, [x8, #-8]
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    ldp x29, x30, [sp, #8] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_fplr 8
; CHECK-NEXT:    ldr x28, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x28, 0
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    .seh_stackalloc 32
; CHECK-NEXT:    ldr z8, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
entry:
  %a = alloca double
  %b = alloca <vscale x 16 x i8>
  tail call void asm sideeffect "", "~{d8},~{x28}"() #1
  store double %d, ptr %a
  store double %d, ptr %b
  ret i32 0
}

define tailcc void @f15(double %d, <vscale x 4 x i32> %vs, [9 x i64], i32 %i) {
; CHECK-LABEL: f15:
; CHECK:       .seh_proc f15
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    str z8, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    str x28, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x28, 16
; CHECK-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg x30, 8
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    addvl x8, sp, #2
; CHECK-NEXT:    //APP
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    stp d0, d0, [sp, #8]
; CHECK-NEXT:    ldr w8, [x8, #104]
; CHECK-NEXT:    str w8, [sp, #8]
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x30, 8
; CHECK-NEXT:    ldr x28, [sp] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x28, 0
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .seh_stackalloc 16
; CHECK-NEXT:    ldr z8, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_zreg z8, 0
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    .seh_allocz 1
; CHECK-NEXT:    add sp, sp, #80
; CHECK-NEXT:    .seh_stackalloc 80
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
  %a = alloca double
  %b = alloca <vscale x 16 x i8>
  tail call void asm sideeffect "", "~{d8},~{x28}"() #1
  store double %d, ptr %a
  store double %d, ptr %b
  store i32 %i, ptr %a
  ret void
}
