; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals
; Test basic type sanitizer instrumentation.
;
; RUN: opt -passes='tysan' -S %s | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

;.
; CHECK: @llvm.used = appending global [1 x ptr] [ptr @tysan.module_ctor], section "llvm.metadata"
; CHECK: @llvm.global_ctors = appending global [1 x { i32, ptr, ptr }] [{ i32, ptr, ptr } { i32 0, ptr @tysan.module_ctor, ptr null }]
; CHECK: @__tysan_shadow_memory_address = external global i64
; CHECK: @__tysan_app_memory_mask = external global i64
;.
define void @test_alloca_only() sanitize_type {
; CHECK-LABEL: @test_alloca_only(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[APP_MEM_MASK:%.*]] = load i64, ptr @__tysan_app_memory_mask, align 8
; CHECK-NEXT:    [[SHADOW_BASE:%.*]] = load i64, ptr @__tysan_shadow_memory_address, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[TMP0:%.*]] = ptrtoint ptr [[TMP1]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = and i64 [[TMP0]], [[APP_MEM_MASK]]
; CHECK-NEXT:    [[TMP2:%.*]] = shl i64 [[TMP5]], 3
; CHECK-NEXT:    [[TMP3:%.*]] = add i64 [[TMP2]], [[SHADOW_BASE]]
; CHECK-NEXT:    [[TMP4:%.*]] = inttoptr i64 [[TMP3]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP4]], i8 0, i64 32, i1 false)
; CHECK-NEXT:    call void @foo(ptr [[TMP1]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32
  call void @foo(ptr %a)
  ret void
}

declare void @foo(ptr)


!0 = !{!"Simple C++ TBAA"}
!1 = !{!"omnipotent char", !0, i64 0}
!2 = !{!"int", !1, i64 0}
!3 = !{!2, !2, i64 0}
!4 = !{!"_ZTS1x", !2, i64 0, !2, i64 4}
!5 = !{!"_ZTS1v", !2, i64 8, !2, i64 12, !4, i64 16}
!6 = !{!5, !2, i64 12}
;.
; CHECK: attributes #[[ATTR0:[0-9]+]] = { sanitize_type }
; CHECK: attributes #[[ATTR1:[0-9]+]] = { nounwind }
; CHECK: attributes #[[ATTR2:[0-9]+]] = { nocallback nofree nounwind willreturn memory(argmem: write) }
;.
