/* DeltaUpdater.c generated by valac 0.34.6, the Vala compiler
 * generated from DeltaUpdater.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbTweet.h"


#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;
typedef struct _DeltaUpdaterPrivate DeltaUpdaterPrivate;

#define TYPE_WEAK_REF (weak_ref_get_type ())
#define WEAK_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WEAK_REF, WeakRef))
#define WEAK_REF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WEAK_REF, WeakRefClass))
#define IS_WEAK_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WEAK_REF))
#define IS_WEAK_REF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WEAK_REF))
#define WEAK_REF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WEAK_REF, WeakRefClass))

typedef struct _WeakRef WeakRef;
typedef struct _WeakRefClass WeakRefClass;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _DeltaUpdater {
	GObject parent_instance;
	DeltaUpdaterPrivate * priv;
};

struct _DeltaUpdaterClass {
	GObjectClass parent_class;
};

struct _DeltaUpdaterPrivate {
	GPtrArray* minutely;
	GPtrArray* hourly;
	guint minutely_id;
	guint hourly_id;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	CbTweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};


static gpointer delta_updater_parent_class = NULL;

GType delta_updater_get_type (void) G_GNUC_CONST;
GType weak_ref_get_type (void) G_GNUC_CONST;
#define DELTA_UPDATER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DELTA_UPDATER, DeltaUpdaterPrivate))
enum  {
	DELTA_UPDATER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
DeltaUpdater* delta_updater_new (void);
DeltaUpdater* delta_updater_construct (GType object_type);
static gboolean __lambda11_ (DeltaUpdater* self);
GType itwitter_item_get_type (void) G_GNUC_CONST;
ITwitterItem* weak_ref_get (WeakRef* self);
gint itwitter_item_update_time_delta (ITwitterItem* self, GDateTime* now);
static gboolean ___lambda11__gsource_func (gpointer self);
static gboolean __lambda12_ (DeltaUpdater* self);
static gboolean ___lambda12__gsource_func (gpointer self);
void delta_updater_add (DeltaUpdater* self, ITwitterItem* entry);
gint64 itwitter_item_get_sort_factor (ITwitterItem* self);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
WeakRef* weak_ref_new (ITwitterItem* obj);
WeakRef* weak_ref_construct (GType object_type, ITwitterItem* obj);
static void delta_updater_finalize (GObject* obj);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean __lambda11_ (DeltaUpdater* self) {
	gboolean result = FALSE;
	{
		gint i = 0;
		gint size = 0;
		GPtrArray* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		i = 0;
		_tmp0_ = self->priv->minutely;
		_tmp1_ = g_ptr_array_get_length (_tmp0_);
		_tmp2_ = _tmp1_;
		size = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				WeakRef* item_ref = NULL;
				GPtrArray* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gconstpointer _tmp9_ = NULL;
				WeakRef* _tmp10_ = NULL;
				ITwitterItem* item = NULL;
				WeakRef* _tmp11_ = NULL;
				ITwitterItem* _tmp12_ = NULL;
				ITwitterItem* _tmp13_ = NULL;
				gint seconds = 0;
				ITwitterItem* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->minutely;
				_tmp8_ = i;
				_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
				_tmp10_ = _g_object_ref0 ((WeakRef*) _tmp9_);
				item_ref = _tmp10_;
				_tmp11_ = item_ref;
				_tmp12_ = weak_ref_get (_tmp11_);
				item = _tmp12_;
				_tmp13_ = item;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, TYPE_ITWITTER_ITEM)) {
					GPtrArray* _tmp14_ = NULL;
					WeakRef* _tmp15_ = NULL;
					gint _tmp16_ = 0;
					_tmp14_ = self->priv->minutely;
					_tmp15_ = item_ref;
					g_ptr_array_remove (_tmp14_, _tmp15_);
					_tmp16_ = size;
					size = _tmp16_ - 1;
					_g_object_unref0 (item);
					_g_object_unref0 (item_ref);
					continue;
				}
				_tmp17_ = item;
				_tmp18_ = itwitter_item_update_time_delta (_tmp17_, NULL);
				seconds = _tmp18_;
				_tmp19_ = seconds;
				if (_tmp19_ >= 3600) {
					GPtrArray* _tmp20_ = NULL;
					WeakRef* _tmp21_ = NULL;
					GPtrArray* _tmp22_ = NULL;
					WeakRef* _tmp23_ = NULL;
					WeakRef* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					_tmp20_ = self->priv->minutely;
					_tmp21_ = item_ref;
					g_ptr_array_remove (_tmp20_, _tmp21_);
					_tmp22_ = self->priv->hourly;
					_tmp23_ = item_ref;
					_tmp24_ = _g_object_ref0 (_tmp23_);
					g_ptr_array_add (_tmp22_, _tmp24_);
					_tmp25_ = size;
					size = _tmp25_ - 1;
				}
				_g_object_unref0 (item);
				_g_object_unref0 (item_ref);
			}
		}
	}
	result = G_SOURCE_CONTINUE;
	return result;
}


static gboolean ___lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda11_ ((DeltaUpdater*) self);
	return result;
}


static gboolean __lambda12_ (DeltaUpdater* self) {
	gboolean result = FALSE;
	{
		gint i = 0;
		gint size = 0;
		GPtrArray* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		i = 0;
		_tmp0_ = self->priv->hourly;
		_tmp1_ = g_ptr_array_get_length (_tmp0_);
		_tmp2_ = _tmp1_;
		size = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				WeakRef* item_ref = NULL;
				GPtrArray* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gconstpointer _tmp9_ = NULL;
				WeakRef* _tmp10_ = NULL;
				ITwitterItem* item = NULL;
				WeakRef* _tmp11_ = NULL;
				ITwitterItem* _tmp12_ = NULL;
				ITwitterItem* _tmp13_ = NULL;
				ITwitterItem* _tmp17_ = NULL;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->hourly;
				_tmp8_ = i;
				_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
				_tmp10_ = _g_object_ref0 ((WeakRef*) _tmp9_);
				item_ref = _tmp10_;
				_tmp11_ = item_ref;
				_tmp12_ = weak_ref_get (_tmp11_);
				item = _tmp12_;
				_tmp13_ = item;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, TYPE_ITWITTER_ITEM)) {
					GPtrArray* _tmp14_ = NULL;
					WeakRef* _tmp15_ = NULL;
					gint _tmp16_ = 0;
					_tmp14_ = self->priv->hourly;
					_tmp15_ = item_ref;
					g_ptr_array_remove (_tmp14_, _tmp15_);
					_tmp16_ = size;
					size = _tmp16_ - 1;
					_g_object_unref0 (item);
					_g_object_unref0 (item_ref);
					continue;
				}
				_tmp17_ = item;
				itwitter_item_update_time_delta (_tmp17_, NULL);
				_g_object_unref0 (item);
				_g_object_unref0 (item_ref);
			}
		}
	}
	result = G_SOURCE_CONTINUE;
	return result;
}


static gboolean ___lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda12_ ((DeltaUpdater*) self);
	return result;
}


DeltaUpdater* delta_updater_construct (GType object_type) {
	DeltaUpdater * self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	self = (DeltaUpdater*) g_object_new (object_type, NULL);
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (60 * 1000), ___lambda11__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->minutely_id = _tmp0_;
	_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((60 * 60) * 1000), ___lambda12__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->hourly_id = _tmp1_;
	return self;
}


DeltaUpdater* delta_updater_new (void) {
	return delta_updater_construct (TYPE_DELTA_UPDATER);
}


void delta_updater_add (DeltaUpdater* self, ITwitterItem* entry) {
	GDateTime* now = NULL;
	GDateTime* _tmp0_ = NULL;
	gint64 sort_factor = 0LL;
	ITwitterItem* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	ITwitterItem* _tmp4_ = NULL;
	GTimeSpan diff = 0LL;
	GDateTime* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	GDateTime* _tmp13_ = NULL;
	GDateTime* _tmp14_ = NULL;
	GTimeSpan _tmp15_ = 0LL;
	GTimeSpan _tmp16_ = 0LL;
	gint seconds = 0;
	GTimeSpan _tmp17_ = 0LL;
	WeakRef* r = NULL;
	ITwitterItem* _tmp18_ = NULL;
	WeakRef* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	g_return_if_fail (IS_DELTA_UPDATER (self));
	g_return_if_fail (IS_ITWITTER_ITEM (entry));
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = entry;
	_tmp2_ = itwitter_item_get_sort_factor (_tmp1_);
	_tmp3_ = _tmp2_;
	sort_factor = _tmp3_;
	_tmp4_ = entry;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_TWEET_LIST_ENTRY)) {
		TweetListEntry* e = NULL;
		ITwitterItem* _tmp5_ = NULL;
		TweetListEntry* _tmp6_ = NULL;
		TweetListEntry* _tmp7_ = NULL;
		CbTweet* _tmp8_ = NULL;
		CbMiniTweet _tmp9_ = {0};
		gint64 _tmp10_ = 0LL;
		_tmp5_ = entry;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_TWEET_LIST_ENTRY, TweetListEntry));
		e = _tmp6_;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->tweet;
		_tmp9_ = _tmp8_->source_tweet;
		_tmp10_ = _tmp9_.created_at;
		sort_factor = _tmp10_;
		_g_object_unref0 (e);
	}
	_tmp11_ = now;
	_tmp12_ = sort_factor;
	_tmp13_ = g_date_time_new_from_unix_local (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_date_time_difference (_tmp11_, _tmp14_);
	_tmp16_ = _tmp15_;
	_g_date_time_unref0 (_tmp14_);
	diff = _tmp16_;
	_tmp17_ = diff;
	seconds = (gint) ((_tmp17_ / 1000.0) / 1000.0);
	_tmp18_ = entry;
	_tmp19_ = weak_ref_new (_tmp18_);
	r = _tmp19_;
	_tmp20_ = seconds;
	if (_tmp20_ < 3600) {
		GPtrArray* _tmp21_ = NULL;
		WeakRef* _tmp22_ = NULL;
		WeakRef* _tmp23_ = NULL;
		_tmp21_ = self->priv->minutely;
		_tmp22_ = r;
		_tmp23_ = _g_object_ref0 (_tmp22_);
		g_ptr_array_add (_tmp21_, _tmp23_);
	} else {
		gint _tmp24_ = 0;
		_tmp24_ = seconds;
		if (_tmp24_ < ((60 * 60) * 24)) {
			GPtrArray* _tmp25_ = NULL;
			WeakRef* _tmp26_ = NULL;
			WeakRef* _tmp27_ = NULL;
			_tmp25_ = self->priv->hourly;
			_tmp26_ = r;
			_tmp27_ = _g_object_ref0 (_tmp26_);
			g_ptr_array_add (_tmp25_, _tmp27_);
		}
	}
	_g_object_unref0 (r);
	_g_date_time_unref0 (now);
}


static void delta_updater_class_init (DeltaUpdaterClass * klass) {
	delta_updater_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DeltaUpdaterPrivate));
	G_OBJECT_CLASS (klass)->finalize = delta_updater_finalize;
}


static void delta_updater_instance_init (DeltaUpdater * self) {
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	self->priv = DELTA_UPDATER_GET_PRIVATE (self);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->priv->minutely = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->priv->hourly = _tmp1_;
}


static void delta_updater_finalize (GObject* obj) {
	DeltaUpdater * self;
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DELTA_UPDATER, DeltaUpdater);
	_tmp0_ = self->priv->minutely_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->minutely_id;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = self->priv->hourly_id;
	if (_tmp2_ != ((guint) 0)) {
		guint _tmp3_ = 0U;
		_tmp3_ = self->priv->hourly_id;
		g_source_remove (_tmp3_);
	}
	_g_ptr_array_unref0 (self->priv->minutely);
	_g_ptr_array_unref0 (self->priv->hourly);
	G_OBJECT_CLASS (delta_updater_parent_class)->finalize (obj);
}


GType delta_updater_get_type (void) {
	static volatile gsize delta_updater_type_id__volatile = 0;
	if (g_once_init_enter (&delta_updater_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DeltaUpdaterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) delta_updater_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DeltaUpdater), 0, (GInstanceInitFunc) delta_updater_instance_init, NULL };
		GType delta_updater_type_id;
		delta_updater_type_id = g_type_register_static (G_TYPE_OBJECT, "DeltaUpdater", &g_define_type_info, 0);
		g_once_init_leave (&delta_updater_type_id__volatile, delta_updater_type_id);
	}
	return delta_updater_type_id__volatile;
}



