/* DefaultTimeline.c generated by valac 0.36.4, the Vala compiler
 * generated from DefaultTimeline.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include "CbTwitterItem.h"
#include "CbTweet.h"
#include "CbDeltaUpdater.h"
#include "CbTweetModel.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <gio/gio.h>
#include "rest/rest-proxy-call.h"
#include "rest/rest-proxy.h"
#include <json-glib/json-glib.h>
#include "CbUtils.h"
#include <glib/gi18n-lib.h>
#include <cairo.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;
typedef struct _DefaultTimelinePrivate DefaultTimelinePrivate;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block15Data Block15Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _DefaultTimelineLoadNewestInternalData DefaultTimelineLoadNewestInternalData;
typedef struct _DefaultTimelineLoadOlderInternalData DefaultTimelineLoadOlderInternalData;
typedef struct _Block16Data Block16Data;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _DefaultTimeline {
	ScrollWidget parent_instance;
	DefaultTimelinePrivate * priv;
	gboolean initialized;
	MainWindow* main_window;
	TweetListBox* tweet_list;
	Account* account;
	BadgeRadioButton* radio_button;
	guint tweet_remove_timeout;
	gboolean loading;
	GtkWidget* last_focus_widget;
};

struct _DefaultTimelineClass {
	ScrollWidgetClass parent_class;
	void (*on_join) (DefaultTimeline* self, gint page_id, CbBundle* args);
	void (*on_leave) (DefaultTimeline* self);
	gchar* (*get_title) (DefaultTimeline* self);
	void (*create_radio_button) (DefaultTimeline* self, GtkRadioButton* group);
	const gchar* (*get_function) (DefaultTimeline* self);
};

struct _DefaultTimelinePrivate {
	gint _id;
	gint _unread_count;
	gdouble last_value;
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	CbTweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	CbDeltaUpdater* delta_updater;
	Account* account;
	CbTweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block15Data {
	int _ref_count_;
	DefaultTimeline* self;
	RestProxyCall* call;
};

struct _DefaultTimelineLoadNewestInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DefaultTimeline* self;
	gint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	RestProxyCall* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	RestProxyCall* _tmp11_;
	RestProxyCall* _tmp12_;
	RestProxyCall* _tmp13_;
	RestProxyCall* _tmp14_;
	TweetListBox* _tmp15_;
	CbTweetModel* _tmp16_;
	gint64 _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	JsonNode* root_node;
	JsonNode* _tmp20_;
	RestProxyCall* _tmp21_;
	JsonNode* _tmp22_;
	JsonNode* _tmp23_;
	GError* e;
	GError* _tmp24_;
	const gchar* _tmp25_;
	TweetListBox* _tmp26_;
	GError* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	JsonArray* root;
	JsonNode* _tmp31_;
	JsonArray* _tmp32_;
	JsonArray* _tmp33_;
	JsonArray* _tmp34_;
	guint _tmp35_;
	TweetListBox* _tmp36_;
	JsonArray* _tmp37_;
	TweetListBox* _tmp38_;
	Account* _tmp39_;
	GError * _inner_error_;
};

struct _DefaultTimelineLoadOlderInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DefaultTimeline* self;
	gint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	RestProxyCall* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	RestProxyCall* _tmp11_;
	RestProxyCall* _tmp12_;
	RestProxyCall* _tmp13_;
	TweetListBox* _tmp14_;
	CbTweetModel* _tmp15_;
	gint64 _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	JsonNode* root_node;
	JsonNode* _tmp19_;
	RestProxyCall* _tmp20_;
	JsonNode* _tmp21_;
	JsonNode* _tmp22_;
	GError* e;
	GError* _tmp23_;
	const gchar* _tmp24_;
	JsonArray* root;
	JsonNode* _tmp25_;
	JsonArray* _tmp26_;
	JsonArray* _tmp27_;
	JsonArray* _tmp28_;
	guint _tmp29_;
	TweetListBox* _tmp30_;
	JsonArray* _tmp31_;
	TweetListBox* _tmp32_;
	Account* _tmp33_;
	GError * _inner_error_;
};

struct _Block16Data {
	int _ref_count_;
	DefaultTimeline* self;
	gdouble value;
};


static gpointer default_timeline_parent_class = NULL;
extern gboolean STRESSTEST;
static IPageIface * default_timeline_ipage_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType badge_radio_button_get_type (void) G_GNUC_CONST;
#define DEFAULT_TIMELINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DEFAULT_TIMELINE, DefaultTimelinePrivate))
enum  {
	DEFAULT_TIMELINE_DUMMY_PROPERTY,
	DEFAULT_TIMELINE_ID,
	DEFAULT_TIMELINE_UNREAD_COUNT,
	DEFAULT_TIMELINE_WINDOW,
	DEFAULT_TIMELINE_FUNCTION
};
TweetListBox* tweet_list_box_new (void);
TweetListBox* tweet_list_box_construct (GType object_type);
#define DEFAULT_TIMELINE_REST 25
DefaultTimeline* default_timeline_construct (GType object_type, gint id);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
void default_timeline_handle_scrolled_to_start (DefaultTimeline* self);
static void _default_timeline_handle_scrolled_to_start_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self);
static void __lambda23_ (DefaultTimeline* self);
void default_timeline_load_older (DefaultTimeline* self);
static void ___lambda23__scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self);
static void __lambda25_ (DefaultTimeline* self);
void default_timeline_mark_seen_on_scroll (DefaultTimeline* self, gdouble value);
static void ___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda27_ (DefaultTimeline* self, GtkListBoxRow* row);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
#define TWEET_INFO_PAGE_KEY_MODE 0
#define TWEET_INFO_PAGE_BY_INSTANCE 1
#define TWEET_INFO_PAGE_KEY_TWEET 1
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda27__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void __lambda158_ (DefaultTimeline* self);
void default_timeline_load_newest (DefaultTimeline* self);
static void ___lambda158__tweet_list_box_retry_button_clicked (TweetListBox* _sender, gpointer self);
void default_timeline_on_join (DefaultTimeline* self, gint page_id, CbBundle* args);
static void default_timeline_real_on_join (DefaultTimeline* self, gint page_id, CbBundle* args);
gboolean settings_auto_scroll_on_new_tweets (void);
void default_timeline_mark_seen (DefaultTimeline* self, gint64 id);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void default_timeline_stream_resumed_cb (DefaultTimeline* self);
static void _default_timeline_stream_resumed_cb_cb_user_stream_resumed (CbUserStream* _sender, gpointer self);
void default_timeline_on_leave (DefaultTimeline* self);
static void default_timeline_real_on_leave (DefaultTimeline* self);
TweetListEntry* tweet_list_box_get_action_entry (TweetListBox* self);
gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self);
void tweet_list_entry_toggle_mode (TweetListEntry* self);
static gboolean default_timeline_real_handles_double_open (IPage* base);
static void default_timeline_real_double_open (IPage* base);
void scroll_widget_scroll_up_next (ScrollWidget* self, gboolean animate, gboolean force_start);
void default_timeline_load_newest_internal (DefaultTimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void default_timeline_load_newest_internal_finish (DefaultTimeline* self, GAsyncResult* _res_);
static void __lambda159_ (DefaultTimeline* self);
static void ___lambda159__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
#define BOTTOM 2
void default_timeline_load_older_internal (DefaultTimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void default_timeline_load_older_internal_finish (DefaultTimeline* self, GAsyncResult* _res_);
static void __lambda24_ (DefaultTimeline* self);
static void ___lambda24__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gchar* default_timeline_get_title (DefaultTimeline* self);
static gchar* default_timeline_real_get_title (DefaultTimeline* self);
static void default_timeline_real_destroy (GtkWidget* base);
void default_timeline_create_radio_button (DefaultTimeline* self, GtkRadioButton* group);
static void default_timeline_real_create_radio_button (DefaultTimeline* self, GtkRadioButton* group);
static GtkRadioButton* default_timeline_real_get_radio_button (IPage* base);
static gboolean ___lambda22_ (DefaultTimeline* self);
gboolean scroll_widget_get_scrolled_up (ScrollWidget* self);
static gboolean ____lambda22__gsource_func (gpointer self);
void default_timeline_delete_tweet (DefaultTimeline* self, gint64 tweet_id);
gint default_timeline_get_unread_count (DefaultTimeline* self);
void default_timeline_set_unread_count (DefaultTimeline* self, gint value);
void default_timeline_toggle_favorite (DefaultTimeline* self, gint64 id, gboolean mode);
CbTweetState default_timeline_get_rt_flags (DefaultTimeline* self, CbTweet* t);
gboolean account_follows_id (Account* self, gint64 user_id);
gboolean default_timeline_scroll_up (DefaultTimeline* self, CbTweet* t);
gint main_window_get_cur_page_id (MainWindow* self);
gint ipage_get_id (IPage* self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
const gchar* default_timeline_get_function (DefaultTimeline* self);
static void __lambda160_ (Block15Data* _data15_, GObject* o, GAsyncResult* res);
static void ___lambda160__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void default_timeline_load_newest_internal_data_free (gpointer _data);
static gboolean default_timeline_load_newest_internal_co (DefaultTimelineLoadNewestInternalData* _data_);
static void default_timeline_load_newest_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
void tweet_list_box_set_error (TweetListBox* self, const gchar* err_msg);
void tweet_list_box_set_empty (TweetListBox* self);
void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, Account* account);
static void default_timeline_load_older_internal_data_free (gpointer _data);
static gboolean default_timeline_load_older_internal_co (DefaultTimelineLoadOlderInternalData* _data_);
static void default_timeline_load_older_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void __lambda26_ (Block16Data* _data16_, GtkWidget* w);
static void ___lambda26__gtk_callback (GtkWidget* widget, gpointer self);
void default_timeline_rerun_filters (DefaultTimeline* self);
gboolean account_filter_matches (Account* self, CbTweet* t);
void badge_radio_button_set_show_badge (BadgeRadioButton* self, gboolean value);
static void default_timeline_finalize (GObject * obj);
static void _vala_default_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_default_timeline_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _default_timeline_handle_scrolled_to_start_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self) {
	default_timeline_handle_scrolled_to_start ((DefaultTimeline*) self);
}


static void __lambda23_ (DefaultTimeline* self) {
	gboolean _tmp0_;
	_tmp0_ = self->loading;
	if (!_tmp0_) {
		default_timeline_load_older (self);
	}
}


static void ___lambda23__scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self) {
	__lambda23_ ((DefaultTimeline*) self);
}


static void __lambda25_ (DefaultTimeline* self) {
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	_tmp0_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	default_timeline_mark_seen_on_scroll (self, _tmp3_);
}


static void ___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda25_ ((DefaultTimeline*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda27_ (DefaultTimeline* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp9_;
	GtkWidget* _tmp10_;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_TWEET_LIST_ENTRY)) {
		CbBundle* bundle = NULL;
		CbBundle* _tmp1_;
		CbBundle* _tmp2_;
		CbBundle* _tmp3_;
		GtkListBoxRow* _tmp4_;
		CbTweet* _tmp5_;
		MainWindow* _tmp6_;
		MainWidget* _tmp7_;
		CbBundle* _tmp8_;
		_tmp1_ = cb_bundle_new ();
		bundle = _tmp1_;
		_tmp2_ = bundle;
		cb_bundle_put_int (_tmp2_, TWEET_INFO_PAGE_KEY_MODE, TWEET_INFO_PAGE_BY_INSTANCE);
		_tmp3_ = bundle;
		_tmp4_ = row;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
		cb_bundle_put_object (_tmp3_, TWEET_INFO_PAGE_KEY_TWEET, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_OBJECT, GObject));
		_tmp6_ = self->main_window;
		_tmp7_ = _tmp6_->main_widget;
		_tmp8_ = bundle;
		main_widget_switch_page (_tmp7_, (gint) PAGE_TWEET_INFO, _tmp8_);
		_g_object_unref0 (bundle);
	}
	_tmp9_ = row;
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->last_focus_widget);
	self->last_focus_widget = _tmp10_;
}


static void ___lambda27__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda27_ ((DefaultTimeline*) self, row);
}


static void __lambda158_ (DefaultTimeline* self) {
	TweetListBox* _tmp0_;
	CbTweetModel* _tmp1_;
	_tmp0_ = self->tweet_list;
	_tmp1_ = _tmp0_->model;
	cb_tweet_model_clear (_tmp1_);
	default_timeline_load_newest (self);
}


static void ___lambda158__tweet_list_box_retry_button_clicked (TweetListBox* _sender, gpointer self) {
	__lambda158_ ((DefaultTimeline*) self);
}


DefaultTimeline* default_timeline_construct (GType object_type, gint id) {
	DefaultTimeline * self = NULL;
	gint _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	TweetListBox* _tmp3_;
	TweetListBox* _tmp4_;
	TweetListBox* _tmp5_;
	self = (DefaultTimeline*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow), "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), "scrolled-to-start", (GCallback) _default_timeline_handle_scrolled_to_start_scroll_widget_scrolled_to_start, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), "scrolled-to-end", (GCallback) ___lambda23__scroll_widget_scrolled_to_end, self, 0);
	_tmp1_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp2_ = _tmp1_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject), "notify::value", (GCallback) ___lambda25__g_object_notify, self, 0);
	_tmp3_ = self->tweet_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	_tmp4_ = self->tweet_list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda27__gtk_list_box_row_activated, self, 0);
	_tmp5_ = self->tweet_list;
	g_signal_connect_object (_tmp5_, "retry-button-clicked", (GCallback) ___lambda158__tweet_list_box_retry_button_clicked, self, 0);
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
	return self;
}


static void _default_timeline_stream_resumed_cb_cb_user_stream_resumed (CbUserStream* _sender, gpointer self) {
	default_timeline_stream_resumed_cb ((DefaultTimeline*) self);
}


static void default_timeline_real_on_join (DefaultTimeline* self, gint page_id, CbBundle* args) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp5_;
	GtkWidget* _tmp6_;
	GtkAdjustment* _tmp12_;
	gdouble _tmp13_;
	g_return_if_fail ((args == NULL) || CB_IS_BUNDLE (args));
	_tmp0_ = STRESSTEST;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->initialized;
	if (!_tmp1_) {
		gboolean _tmp2_;
		Account* _tmp3_;
		CbUserStream* _tmp4_;
		default_timeline_load_newest (self);
		_tmp2_ = settings_auto_scroll_on_new_tweets ();
		if (!_tmp2_) {
			default_timeline_mark_seen (self, (gint64) -1);
		}
		_tmp3_ = self->account;
		_tmp4_ = _tmp3_->user_stream;
		g_signal_connect_object (_tmp4_, "resumed", (GCallback) _default_timeline_stream_resumed_cb_cb_user_stream_resumed, self, 0);
		self->initialized = TRUE;
	}
	_tmp5_ = settings_auto_scroll_on_new_tweets ();
	if (_tmp5_) {
		default_timeline_mark_seen (self, (gint64) -1);
	}
	_tmp6_ = self->last_focus_widget;
	if (_tmp6_ != NULL) {
		GtkWidget* _tmp7_;
		GtkContainer* _tmp8_;
		GtkContainer* _tmp9_;
		TweetListBox* _tmp10_;
		_tmp7_ = self->last_focus_widget;
		_tmp8_ = gtk_widget_get_parent (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->tweet_list;
		if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_container_get_type (), GtkContainer)) {
			GtkWidget* _tmp11_;
			_tmp11_ = self->last_focus_widget;
			gtk_widget_grab_focus (_tmp11_);
		} else {
			_g_object_unref0 (self->last_focus_widget);
			self->last_focus_widget = NULL;
		}
	}
	_tmp12_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp13_ = self->priv->last_value;
	gtk_adjustment_set_value (_tmp12_, _tmp13_);
}


void default_timeline_on_join (DefaultTimeline* self, gint page_id, CbBundle* args) {
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	DEFAULT_TIMELINE_GET_CLASS (self)->on_join (self, page_id, args);
}


static void default_timeline_real_on_leave (DefaultTimeline* self) {
	MainWindow* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	gboolean _tmp3_ = FALSE;
	TweetListBox* _tmp4_;
	TweetListEntry* _tmp5_;
	TweetListEntry* _tmp6_;
	GtkAdjustment* _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	_tmp0_ = self->main_window;
	_tmp1_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow));
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->last_focus_widget);
	self->last_focus_widget = _tmp2_;
	_tmp4_ = self->tweet_list;
	_tmp5_ = tweet_list_box_get_action_entry (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		TweetListBox* _tmp7_;
		TweetListEntry* _tmp8_;
		TweetListEntry* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp7_ = self->tweet_list;
		_tmp8_ = tweet_list_box_get_action_entry (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = tweet_list_entry_get_shows_actions (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp3_ = _tmp11_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		TweetListBox* _tmp12_;
		TweetListEntry* _tmp13_;
		TweetListEntry* _tmp14_;
		_tmp12_ = self->tweet_list;
		_tmp13_ = tweet_list_box_get_action_entry (_tmp12_);
		_tmp14_ = _tmp13_;
		tweet_list_entry_toggle_mode (_tmp14_);
	}
	_tmp15_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp16_ = gtk_adjustment_get_value (_tmp15_);
	_tmp17_ = _tmp16_;
	self->priv->last_value = _tmp17_;
}


void default_timeline_on_leave (DefaultTimeline* self) {
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	DEFAULT_TIMELINE_GET_CLASS (self)->on_leave (self);
}


static gboolean default_timeline_real_handles_double_open (IPage* base) {
	DefaultTimeline * self;
	gboolean result = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	result = TRUE;
	return result;
}


static void default_timeline_real_double_open (IPage* base) {
	DefaultTimeline * self;
	gboolean _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = self->loading;
	if (!_tmp0_) {
		TweetListBox* _tmp1_;
		GtkListBoxRow* _tmp2_;
		scroll_widget_scroll_up_next (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), TRUE, TRUE);
		_tmp1_ = self->tweet_list;
		_tmp2_ = gtk_list_box_get_row_at_index (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_box_get_type (), GtkListBox), 0);
		gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
	}
}


static void __lambda159_ (DefaultTimeline* self) {
	self->loading = FALSE;
}


static void ___lambda159__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda159_ ((DefaultTimeline*) self);
	g_object_unref (self);
}


void default_timeline_load_newest (DefaultTimeline* self) {
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	self->loading = TRUE;
	default_timeline_load_newest_internal (self, ___lambda159__gasync_ready_callback, g_object_ref (self));
}


static void __lambda24_ (DefaultTimeline* self) {
	self->loading = FALSE;
}


static void ___lambda24__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda24_ ((DefaultTimeline*) self);
	g_object_unref (self);
}


void default_timeline_load_older (DefaultTimeline* self) {
	gboolean _tmp0_;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_tmp0_ = self->initialized;
	if (!_tmp0_) {
		return;
	}
	scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), BOTTOM);
	self->loading = TRUE;
	default_timeline_load_older_internal (self, ___lambda24__gasync_ready_callback, g_object_ref (self));
}


static gchar* default_timeline_real_get_title (DefaultTimeline* self) {
	g_critical ("Type `%s' does not implement abstract method `default_timeline_get_title'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* default_timeline_get_title (DefaultTimeline* self) {
	g_return_val_if_fail (IS_DEFAULT_TIMELINE (self), NULL);
	return DEFAULT_TIMELINE_GET_CLASS (self)->get_title (self);
}


static void default_timeline_real_destroy (GtkWidget* base) {
	DefaultTimeline * self;
	guint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = self->tweet_remove_timeout;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->tweet_remove_timeout;
		g_source_remove (_tmp1_);
		self->tweet_remove_timeout = (guint) 0;
	}
	GTK_WIDGET_CLASS (default_timeline_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), gtk_widget_get_type (), GtkWidget));
}


static void default_timeline_real_create_radio_button (DefaultTimeline* self, GtkRadioButton* group) {
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


void default_timeline_create_radio_button (DefaultTimeline* self, GtkRadioButton* group) {
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	DEFAULT_TIMELINE_GET_CLASS (self)->create_radio_button (self, group);
}


static GtkRadioButton* default_timeline_real_get_radio_button (IPage* base) {
	DefaultTimeline * self;
	GtkRadioButton* result = NULL;
	BadgeRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = self->radio_button;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton));
	result = _tmp1_;
	return result;
}


/**
   * Handle the case of the user scrolling to the start of the list,
   * i.e. remove all the items except a few ones after a timeout.
   */
static gboolean ___lambda22_ (DefaultTimeline* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	TweetListBox* _tmp2_;
	CbTweetModel* _tmp3_;
	guint _tmp4_;
	_tmp0_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		self->tweet_remove_timeout = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	_tmp2_ = self->tweet_list;
	_tmp3_ = _tmp2_->model;
	_tmp4_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_list_model_get_type (), GListModel));
	if (_tmp4_ > ((guint) DEFAULT_TIMELINE_REST)) {
		TweetListBox* _tmp5_;
		CbTweetModel* _tmp6_;
		TweetListBox* _tmp7_;
		CbTweetModel* _tmp8_;
		guint _tmp9_;
		_tmp5_ = self->tweet_list;
		_tmp6_ = _tmp5_->model;
		_tmp7_ = self->tweet_list;
		_tmp8_ = _tmp7_->model;
		_tmp9_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_list_model_get_type (), GListModel));
		cb_tweet_model_remove_last_n_visible (_tmp6_, _tmp9_ - DEFAULT_TIMELINE_REST);
	}
	self->tweet_remove_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ____lambda22__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda22_ ((DefaultTimeline*) self);
	return result;
}


void default_timeline_handle_scrolled_to_start (DefaultTimeline* self) {
	guint _tmp0_;
	TweetListBox* _tmp1_;
	CbTweetModel* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_tmp0_ = self->tweet_remove_timeout;
	if (_tmp0_ != ((guint) 0)) {
		return;
	}
	_tmp1_ = self->tweet_list;
	_tmp2_ = _tmp1_->model;
	_tmp3_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_list_model_get_type (), GListModel));
	if (_tmp3_ > ((guint) DEFAULT_TIMELINE_REST)) {
		guint _tmp4_;
		_tmp4_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda22__gsource_func, g_object_ref (self), g_object_unref);
		self->tweet_remove_timeout = _tmp4_;
	} else {
		guint _tmp5_;
		_tmp5_ = self->tweet_remove_timeout;
		if (_tmp5_ != ((guint) 0)) {
			guint _tmp6_;
			_tmp6_ = self->tweet_remove_timeout;
			g_source_remove (_tmp6_);
			self->tweet_remove_timeout = (guint) 0;
		}
	}
}


void default_timeline_delete_tweet (DefaultTimeline* self, gint64 tweet_id) {
	gboolean was_seen = FALSE;
	gboolean removed = FALSE;
	TweetListBox* _tmp0_;
	CbTweetModel* _tmp1_;
	gint64 _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_tmp0_ = self->tweet_list;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = tweet_id;
	_tmp4_ = cb_tweet_model_delete_id (_tmp1_, _tmp2_, &_tmp3_);
	was_seen = _tmp3_;
	removed = _tmp4_;
	_tmp6_ = removed;
	if (_tmp6_) {
		gboolean _tmp7_;
		_tmp7_ = was_seen;
		_tmp5_ = !_tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gint _tmp8_;
		gint _tmp9_;
		_tmp8_ = default_timeline_get_unread_count (self);
		_tmp9_ = _tmp8_;
		default_timeline_set_unread_count (self, _tmp9_ - 1);
	}
}


void default_timeline_toggle_favorite (DefaultTimeline* self, gint64 id, gboolean mode) {
	CbTweet* t = NULL;
	TweetListBox* _tmp0_;
	CbTweetModel* _tmp1_;
	gint64 _tmp2_;
	CbTweet* _tmp3_;
	CbTweet* _tmp4_;
	CbTweet* _tmp5_;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_tmp0_ = self->tweet_list;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = id;
	_tmp3_ = cb_tweet_model_get_for_id (_tmp1_, _tmp2_, 0);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	t = _tmp4_;
	_tmp5_ = t;
	if (_tmp5_ != NULL) {
		gboolean _tmp6_;
		_tmp6_ = mode;
		if (_tmp6_) {
			TweetListBox* _tmp7_;
			CbTweetModel* _tmp8_;
			CbTweet* _tmp9_;
			_tmp7_ = self->tweet_list;
			_tmp8_ = _tmp7_->model;
			_tmp9_ = t;
			cb_tweet_model_set_tweet_flag (_tmp8_, _tmp9_, CB_TWEET_STATE_FAVORITED);
		} else {
			TweetListBox* _tmp10_;
			CbTweetModel* _tmp11_;
			CbTweet* _tmp12_;
			_tmp10_ = self->tweet_list;
			_tmp11_ = _tmp10_->model;
			_tmp12_ = t;
			cb_tweet_model_unset_tweet_flag (_tmp11_, _tmp12_, CB_TWEET_STATE_FAVORITED);
		}
	}
	_g_object_unref0 (t);
}


/**
   * So, we don't want to display a retweet in the following situations:
   *   1) If the original tweet was a tweet by the authenticated user
   *   2) In any case, if the user follows the author of the tweet
   *      (not the author of the retweet!), we already get the source
   *      tweet by other means, so don't display it again.
   *   3) It's a retweet from the authenticating user itself
   *   4) If the tweet was retweeted by a user that is on the list of
   *      users the authenticating user disabled RTs for.
   *   5) If the retweet is already in the timeline. There's no other
   *      way of checking the case where 2 independend users retweet
   *      the same tweet.
   */
CbTweetState default_timeline_get_rt_flags (DefaultTimeline* self, CbTweet* t) {
	CbTweetState result = 0;
	guint flags = 0U;
	CbTweet* _tmp0_;
	gint64 _tmp1_;
	Account* _tmp2_;
	gint64 _tmp3_;
	Account* _tmp5_;
	CbTweet* _tmp6_;
	gint64 _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp10_ = FALSE;
	CbTweet* _tmp11_;
	CbMiniTweet* _tmp12_;
	Account* _tmp20_;
	gint64* _tmp21_;
	gint _tmp21__length1;
	CbTweet* _tmp28_;
	CbMiniTweet* _tmp29_;
	guint _tmp47_;
	g_return_val_if_fail (IS_DEFAULT_TIMELINE (self), 0);
	g_return_val_if_fail (CB_IS_TWEET (t), 0);
	flags = (guint) 0;
	_tmp0_ = t;
	_tmp1_ = cb_tweet_get_user_id (_tmp0_);
	_tmp2_ = self->account;
	_tmp3_ = _tmp2_->id;
	if (_tmp1_ == _tmp3_) {
		guint _tmp4_;
		_tmp4_ = flags;
		flags = _tmp4_ | CB_TWEET_STATE_HIDDEN_FORCE;
	}
	_tmp5_ = self->account;
	_tmp6_ = t;
	_tmp7_ = cb_tweet_get_user_id (_tmp6_);
	_tmp8_ = account_follows_id (_tmp5_, _tmp7_);
	if (_tmp8_) {
		guint _tmp9_;
		_tmp9_ = flags;
		flags = _tmp9_ | CB_TWEET_STATE_HIDDEN_RT_BY_FOLLOWEE;
	}
	_tmp11_ = t;
	_tmp12_ = _tmp11_->retweeted_tweet;
	if (_tmp12_ != NULL) {
		CbTweet* _tmp13_;
		CbMiniTweet* _tmp14_;
		CbUserIdentity _tmp15_;
		gint64 _tmp16_;
		Account* _tmp17_;
		gint64 _tmp18_;
		_tmp13_ = t;
		_tmp14_ = _tmp13_->retweeted_tweet;
		_tmp15_ = (*_tmp14_).author;
		_tmp16_ = _tmp15_.id;
		_tmp17_ = self->account;
		_tmp18_ = _tmp17_->id;
		_tmp10_ = _tmp16_ == _tmp18_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		guint _tmp19_;
		_tmp19_ = flags;
		flags = _tmp19_ | CB_TWEET_STATE_HIDDEN_FORCE;
	}
	_tmp20_ = self->account;
	_tmp21_ = _tmp20_->disabled_rts;
	_tmp21__length1 = _tmp20_->disabled_rts_length1;
	{
		gint64* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp21_;
		id_collection_length1 = _tmp21__length1;
		for (id_it = 0; id_it < _tmp21__length1; id_it = id_it + 1) {
			gint64 id = 0LL;
			id = id_collection[id_it];
			{
				gint64 _tmp22_;
				CbTweet* _tmp23_;
				CbMiniTweet _tmp24_;
				CbUserIdentity _tmp25_;
				gint64 _tmp26_;
				_tmp22_ = id;
				_tmp23_ = t;
				_tmp24_ = _tmp23_->source_tweet;
				_tmp25_ = _tmp24_.author;
				_tmp26_ = _tmp25_.id;
				if (_tmp22_ == _tmp26_) {
					guint _tmp27_;
					_tmp27_ = flags;
					flags = _tmp27_ | CB_TWEET_STATE_HIDDEN_RTS_DISABLED;
					break;
				}
			}
		}
	}
	_tmp28_ = t;
	_tmp29_ = _tmp28_->retweeted_tweet;
	if (_tmp29_ != NULL) {
		TweetListBox* _tmp30_;
		GList* _tmp31_;
		_tmp30_ = self->tweet_list;
		_tmp31_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_container_get_type (), GtkContainer));
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp31_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* _tmp32_;
				GtkWidget* w = NULL;
				_tmp32_ = _g_object_ref0 ((GtkWidget*) w_it->data);
				w = _tmp32_;
				{
					GtkWidget* _tmp33_;
					_tmp33_ = w;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, TYPE_TWEET_LIST_ENTRY)) {
						CbTweet* tt = NULL;
						GtkWidget* _tmp34_;
						CbTweet* _tmp35_;
						CbTweet* _tmp36_;
						gboolean _tmp37_ = FALSE;
						CbTweet* _tmp38_;
						CbMiniTweet* _tmp39_;
						_tmp34_ = w;
						_tmp35_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
						_tmp36_ = _g_object_ref0 (_tmp35_);
						tt = _tmp36_;
						_tmp38_ = tt;
						_tmp39_ = _tmp38_->retweeted_tweet;
						if (_tmp39_ != NULL) {
							CbTweet* _tmp40_;
							CbMiniTweet* _tmp41_;
							gint64 _tmp42_;
							CbTweet* _tmp43_;
							CbMiniTweet* _tmp44_;
							gint64 _tmp45_;
							_tmp40_ = tt;
							_tmp41_ = _tmp40_->retweeted_tweet;
							_tmp42_ = (*_tmp41_).id;
							_tmp43_ = t;
							_tmp44_ = _tmp43_->retweeted_tweet;
							_tmp45_ = (*_tmp44_).id;
							_tmp37_ = _tmp42_ == _tmp45_;
						} else {
							_tmp37_ = FALSE;
						}
						if (_tmp37_) {
							guint _tmp46_;
							_tmp46_ = flags;
							flags = _tmp46_ | CB_TWEET_STATE_HIDDEN_FORCE;
							_g_object_unref0 (tt);
							_g_object_unref0 (w);
							break;
						}
						_g_object_unref0 (tt);
					}
					_g_object_unref0 (w);
				}
			}
			_g_list_free0 (w_collection);
		}
	}
	_tmp47_ = flags;
	result = (CbTweetState) _tmp47_;
	return result;
}


void default_timeline_mark_seen (DefaultTimeline* self, gint64 id) {
	TweetListBox* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_tmp0_ = self->tweet_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp1_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* w = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				GtkWidget* _tmp4_;
				TweetListEntry* tle = NULL;
				GtkWidget* _tmp6_;
				TweetListEntry* _tmp7_;
				gboolean _tmp8_ = FALSE;
				TweetListEntry* _tmp9_;
				CbTweet* _tmp10_;
				gint64 _tmp11_;
				gint64 _tmp12_;
				_tmp4_ = w;
				if (_tmp4_ == NULL) {
					_tmp3_ = TRUE;
				} else {
					GtkWidget* _tmp5_;
					_tmp5_ = w;
					_tmp3_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_TWEET_LIST_ENTRY);
				}
				if (_tmp3_) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp6_ = w;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_TWEET_LIST_ENTRY, TweetListEntry));
				tle = _tmp7_;
				_tmp9_ = tle;
				_tmp10_ = _tmp9_->tweet;
				_tmp11_ = _tmp10_->id;
				_tmp12_ = id;
				if (_tmp11_ == _tmp12_) {
					_tmp8_ = TRUE;
				} else {
					gint64 _tmp13_;
					_tmp13_ = id;
					_tmp8_ = _tmp13_ == ((gint64) -1);
				}
				if (_tmp8_) {
					TweetListEntry* _tmp14_;
					CbTweet* _tmp15_;
					gboolean _tmp16_;
					TweetListEntry* _tmp19_;
					CbTweet* _tmp20_;
					gint64 _tmp21_;
					_tmp14_ = tle;
					_tmp15_ = _tmp14_->tweet;
					_tmp16_ = cb_tweet_get_seen (_tmp15_);
					if (!_tmp16_) {
						gint _tmp17_;
						gint _tmp18_;
						_tmp17_ = default_timeline_get_unread_count (self);
						_tmp18_ = _tmp17_;
						default_timeline_set_unread_count (self, _tmp18_ - 1);
					}
					_tmp19_ = tle;
					_tmp20_ = _tmp19_->tweet;
					cb_tweet_set_seen (_tmp20_, TRUE);
					_tmp21_ = id;
					if (_tmp21_ != ((gint64) -1)) {
						_g_object_unref0 (tle);
						_g_object_unref0 (w);
						break;
					}
				}
				_g_object_unref0 (tle);
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
}


gboolean default_timeline_scroll_up (DefaultTimeline* self, CbTweet* t) {
	gboolean result = FALSE;
	gboolean auto_scroll = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (IS_DEFAULT_TIMELINE (self), FALSE);
	g_return_val_if_fail (CB_IS_TWEET (t), FALSE);
	_tmp0_ = settings_auto_scroll_on_new_tweets ();
	auto_scroll = _tmp0_;
	_tmp2_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		CbTweet* _tmp5_;
		gint64 _tmp6_;
		Account* _tmp7_;
		gint64 _tmp8_;
		_tmp5_ = t;
		_tmp6_ = cb_tweet_get_user_id (_tmp5_);
		_tmp7_ = self->account;
		_tmp8_ = _tmp7_->id;
		if (_tmp6_ == _tmp8_) {
			_tmp4_ = TRUE;
		} else {
			gboolean _tmp9_;
			_tmp9_ = auto_scroll;
			_tmp4_ = _tmp9_;
		}
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		MainWindow* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp10_ = self->main_window;
		_tmp11_ = main_window_get_cur_page_id (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp14_ = _tmp13_;
		scroll_widget_scroll_up_next (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), TRUE, _tmp12_ != _tmp14_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (void * _userdata_) {
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		DefaultTimeline* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->call);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void __lambda160_ (Block15Data* _data15_, GObject* o, GAsyncResult* res) {
	DefaultTimeline* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp6_;
	JsonArray* root_arr = NULL;
	JsonParser* _tmp14_;
	JsonNode* _tmp15_;
	JsonArray* _tmp16_;
	JsonArray* _tmp17_;
	JsonArray* _tmp18_;
	guint _tmp19_;
	GError * _inner_error_ = NULL;
	self = _data15_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data15_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		TweetListBox* _tmp2_;
		CbTweetModel* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = self->tweet_list;
		_tmp3_ = _tmp2_->model;
		cb_tweet_model_clear (_tmp3_);
		default_timeline_load_newest (self);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("DefaultTimeline.vala:320: %s", _tmp5_);
		_g_error_free0 (e);
		return;
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = json_parser_new ();
	parser = _tmp6_;
	{
		JsonParser* _tmp7_;
		RestProxyCall* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = parser;
		_tmp8_ = _data15_->call;
		_tmp9_ = rest_proxy_call_get_payload (_tmp8_);
		json_parser_load_from_data (_tmp7_, _tmp9_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		TweetListBox* _tmp10_;
		CbTweetModel* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = self->tweet_list;
		_tmp11_ = _tmp10_->model;
		cb_tweet_model_clear (_tmp11_);
		default_timeline_set_unread_count (self, 0);
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("DefaultTimeline.vala:330: %s", _tmp13_);
		default_timeline_load_newest (self);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return;
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = parser;
	_tmp15_ = json_parser_get_root (_tmp14_);
	_tmp16_ = json_node_get_array (_tmp15_);
	_tmp17_ = _json_array_ref0 (_tmp16_);
	root_arr = _tmp17_;
	_tmp18_ = root_arr;
	_tmp19_ = json_array_get_length (_tmp18_);
	if (_tmp19_ > ((guint) 0)) {
		TweetListBox* _tmp20_;
		CbTweetModel* _tmp21_;
		_tmp20_ = self->tweet_list;
		_tmp21_ = _tmp20_->model;
		cb_tweet_model_clear (_tmp21_);
		default_timeline_set_unread_count (self, 0);
		default_timeline_load_newest (self);
	}
	_json_array_unref0 (root_arr);
	_g_object_unref0 (parser);
}


static void ___lambda160__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda160_ (self, source_object, res);
	block15_data_unref (self);
}


static void default_timeline_stream_resumed_cb (DefaultTimeline* self) {
	Block15Data* _data15_;
	TweetListBox* _tmp0_;
	CbTweetModel* _tmp1_;
	guint _tmp2_;
	Account* _tmp3_;
	OAuthProxy* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	RestProxyCall* _tmp9_;
	RestProxyCall* _tmp10_;
	RestProxyCall* _tmp11_;
	TweetListBox* _tmp12_;
	CbTweetModel* _tmp13_;
	gint64 _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	RestProxyCall* _tmp17_;
	RestProxyCall* _tmp18_;
	RestProxyCall* _tmp19_;
	RestProxyCall* _tmp20_;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = self->tweet_list;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_list_model_get_type (), GListModel));
	if (_tmp2_ == ((guint) 0)) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		return;
	}
	_tmp3_ = self->account;
	_tmp4_ = _tmp3_->proxy;
	_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, rest_proxy_get_type (), RestProxy));
	_data15_->call = _tmp5_;
	_tmp6_ = _data15_->call;
	_tmp7_ = default_timeline_get_function (self);
	_tmp8_ = _tmp7_;
	rest_proxy_call_set_function (_tmp6_, _tmp8_);
	_tmp9_ = _data15_->call;
	rest_proxy_call_set_method (_tmp9_, "GET");
	_tmp10_ = _data15_->call;
	rest_proxy_call_add_param (_tmp10_, "count", "1");
	_tmp11_ = _data15_->call;
	_tmp12_ = self->tweet_list;
	_tmp13_ = _tmp12_->model;
	_tmp14_ = _tmp13_->max_id;
	_tmp15_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp14_ + 1);
	_tmp16_ = _tmp15_;
	rest_proxy_call_add_param (_tmp11_, "since_id", _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = _data15_->call;
	rest_proxy_call_add_param (_tmp17_, "trim_user", "true");
	_tmp18_ = _data15_->call;
	rest_proxy_call_add_param (_tmp18_, "contributor_details", "false");
	_tmp19_ = _data15_->call;
	rest_proxy_call_add_param (_tmp19_, "include_entities", "false");
	_tmp20_ = _data15_->call;
	rest_proxy_call_invoke_async (_tmp20_, NULL, ___lambda160__gasync_ready_callback, block15_data_ref (_data15_));
	block15_data_unref (_data15_);
	_data15_ = NULL;
}


static void default_timeline_load_newest_internal_data_free (gpointer _data) {
	DefaultTimelineLoadNewestInternalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DefaultTimelineLoadNewestInternalData, _data_);
}


void default_timeline_load_newest_internal (DefaultTimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DefaultTimelineLoadNewestInternalData* _data_;
	DefaultTimeline* _tmp0_;
	_data_ = g_slice_new0 (DefaultTimelineLoadNewestInternalData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, default_timeline_load_newest_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	default_timeline_load_newest_internal_co (_data_);
}


void default_timeline_load_newest_internal_finish (DefaultTimeline* self, GAsyncResult* _res_) {
	DefaultTimelineLoadNewestInternalData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * Default implementation for loading the newest tweets
   * from the given function of the twitter api.
   */
static void default_timeline_load_newest_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DefaultTimelineLoadNewestInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	default_timeline_load_newest_internal_co (_data_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gboolean default_timeline_load_newest_internal_co (DefaultTimelineLoadNewestInternalData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->requested_tweet_count = 28;
	_data_->_tmp0_ = _data_->self->account;
	_data_->_tmp1_ = _data_->_tmp0_->proxy;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->call;
	_data_->_tmp4_ = default_timeline_get_function (_data_->self);
	_data_->_tmp5_ = _data_->_tmp4_;
	rest_proxy_call_set_function (_data_->_tmp3_, _data_->_tmp5_);
	_data_->_tmp6_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp6_, "GET");
	_data_->_tmp7_ = _data_->call;
	_data_->_tmp8_ = _data_->requested_tweet_count;
	_data_->_tmp9_ = g_strdup_printf ("%i", _data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	rest_proxy_call_add_param (_data_->_tmp7_, "count", _data_->_tmp10_);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp11_, "contributor_details", "true");
	_data_->_tmp12_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp12_, "include_my_retweet", "true");
	_data_->_tmp13_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp13_, "tweet_mode", "extended");
	_data_->_tmp14_ = _data_->call;
	_data_->_tmp15_ = _data_->self->tweet_list;
	_data_->_tmp16_ = _data_->_tmp15_->model;
	_data_->_tmp17_ = _data_->_tmp16_->min_id;
	_data_->_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp17_ - 1);
	_data_->_tmp19_ = _data_->_tmp18_;
	rest_proxy_call_add_param (_data_->_tmp14_, "max_id", _data_->_tmp19_);
	_g_free0 (_data_->_tmp19_);
	_data_->root_node = NULL;
	{
		_data_->_tmp21_ = _data_->call;
		_data_->_state_ = 1;
		cb_utils_load_threaded_async (_data_->_tmp21_, NULL, default_timeline_load_newest_internal_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp22_ = cb_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp20_ = _data_->_tmp22_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
		_data_->_tmp23_ = _data_->_tmp20_;
		_data_->_tmp20_ = NULL;
		__vala_JsonNode_free0 (_data_->root_node);
		_data_->root_node = _data_->_tmp23_;
		__vala_JsonNode_free0 (_data_->_tmp20_);
	}
	goto __finally12;
	__catch12_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp24_ = _data_->e;
		_data_->_tmp25_ = _data_->_tmp24_->message;
		g_message ("DefaultTimeline.vala:365: %s", _data_->_tmp25_);
		_data_->_tmp26_ = _data_->self->tweet_list;
		_data_->_tmp27_ = _data_->e;
		_data_->_tmp28_ = _data_->_tmp27_->message;
		_data_->_tmp29_ = g_strdup_printf ("%s\n%s", _ ("Could not load tweets"), _data_->_tmp28_);
		_data_->_tmp30_ = _data_->_tmp29_;
		tweet_list_box_set_error (_data_->_tmp26_, _data_->_tmp30_);
		_g_free0 (_data_->_tmp30_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally12:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp31_ = _data_->root_node;
	_data_->_tmp32_ = json_node_get_array (_data_->_tmp31_);
	_data_->_tmp33_ = _json_array_ref0 (_data_->_tmp32_);
	_data_->root = _data_->_tmp33_;
	_data_->_tmp34_ = _data_->root;
	_data_->_tmp35_ = json_array_get_length (_data_->_tmp34_);
	if (_data_->_tmp35_ == ((guint) 0)) {
		_data_->_tmp36_ = _data_->self->tweet_list;
		tweet_list_box_set_empty (_data_->_tmp36_);
		_json_array_unref0 (_data_->root);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp37_ = _data_->root;
	_data_->_tmp38_ = _data_->self->tweet_list;
	_data_->_tmp39_ = _data_->self->account;
	tweet_utils_work_array (_data_->_tmp37_, _data_->_tmp38_, _data_->_tmp39_);
	_json_array_unref0 (_data_->root);
	__vala_JsonNode_free0 (_data_->root_node);
	_g_object_unref0 (_data_->call);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void default_timeline_load_older_internal_data_free (gpointer _data) {
	DefaultTimelineLoadOlderInternalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DefaultTimelineLoadOlderInternalData, _data_);
}


void default_timeline_load_older_internal (DefaultTimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DefaultTimelineLoadOlderInternalData* _data_;
	DefaultTimeline* _tmp0_;
	_data_ = g_slice_new0 (DefaultTimelineLoadOlderInternalData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, default_timeline_load_older_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	default_timeline_load_older_internal_co (_data_);
}


void default_timeline_load_older_internal_finish (DefaultTimeline* self, GAsyncResult* _res_) {
	DefaultTimelineLoadOlderInternalData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * Default implementation to load older tweets.
   *
   */
static void default_timeline_load_older_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DefaultTimelineLoadOlderInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	default_timeline_load_older_internal_co (_data_);
}


static gboolean default_timeline_load_older_internal_co (DefaultTimelineLoadOlderInternalData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->requested_tweet_count = 28;
	_data_->_tmp0_ = _data_->self->account;
	_data_->_tmp1_ = _data_->_tmp0_->proxy;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->call;
	_data_->_tmp4_ = default_timeline_get_function (_data_->self);
	_data_->_tmp5_ = _data_->_tmp4_;
	rest_proxy_call_set_function (_data_->_tmp3_, _data_->_tmp5_);
	_data_->_tmp6_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp6_, "GET");
	_data_->_tmp7_ = _data_->call;
	_data_->_tmp8_ = _data_->requested_tweet_count;
	_data_->_tmp9_ = g_strdup_printf ("%i", _data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	rest_proxy_call_add_param (_data_->_tmp7_, "count", _data_->_tmp10_);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp11_, "include_my_retweet", "true");
	_data_->_tmp12_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp12_, "tweet_mode", "extended");
	_data_->_tmp13_ = _data_->call;
	_data_->_tmp14_ = _data_->self->tweet_list;
	_data_->_tmp15_ = _data_->_tmp14_->model;
	_data_->_tmp16_ = _data_->_tmp15_->min_id;
	_data_->_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp16_ - 1);
	_data_->_tmp18_ = _data_->_tmp17_;
	rest_proxy_call_add_param (_data_->_tmp13_, "max_id", _data_->_tmp18_);
	_g_free0 (_data_->_tmp18_);
	_data_->root_node = NULL;
	{
		_data_->_tmp20_ = _data_->call;
		_data_->_state_ = 1;
		cb_utils_load_threaded_async (_data_->_tmp20_, NULL, default_timeline_load_older_internal_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp21_ = cb_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp19_ = _data_->_tmp21_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch13_g_error;
		}
		_data_->_tmp22_ = _data_->_tmp19_;
		_data_->_tmp19_ = NULL;
		__vala_JsonNode_free0 (_data_->root_node);
		_data_->root_node = _data_->_tmp22_;
		__vala_JsonNode_free0 (_data_->_tmp19_);
	}
	goto __finally13;
	__catch13_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp23_ = _data_->e;
		_data_->_tmp24_ = _data_->_tmp23_->message;
		g_warning ("DefaultTimeline.vala:399: %s", _data_->_tmp24_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally13:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp25_ = _data_->root_node;
	_data_->_tmp26_ = json_node_get_array (_data_->_tmp25_);
	_data_->_tmp27_ = _json_array_ref0 (_data_->_tmp26_);
	_data_->root = _data_->_tmp27_;
	_data_->_tmp28_ = _data_->root;
	_data_->_tmp29_ = json_array_get_length (_data_->_tmp28_);
	if (_data_->_tmp29_ == ((guint) 0)) {
		_data_->_tmp30_ = _data_->self->tweet_list;
		tweet_list_box_set_empty (_data_->_tmp30_);
		_json_array_unref0 (_data_->root);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp31_ = _data_->root;
	_data_->_tmp32_ = _data_->self->tweet_list;
	_data_->_tmp33_ = _data_->self->account;
	tweet_utils_work_array (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp33_);
	_json_array_unref0 (_data_->root);
	__vala_JsonNode_free0 (_data_->root_node);
	_g_object_unref0 (_data_->call);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Mark the TweetListEntries the user has already seen.
   *
   * @param value The scrolling value as from Gtk.Adjustment
   */
static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		DefaultTimeline* self;
		self = _data16_->self;
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}


static void __lambda26_ (Block16Data* _data16_, GtkWidget* w) {
	DefaultTimeline* self;
	GtkWidget* _tmp0_;
	TweetListEntry* tle = NULL;
	GtkWidget* _tmp1_;
	TweetListEntry* _tmp2_;
	TweetListEntry* _tmp3_;
	CbTweet* _tmp4_;
	gboolean _tmp5_;
	GtkAllocation alloc = {0};
	TweetListEntry* _tmp6_;
	GtkAllocation _tmp7_ = {0};
	GtkAllocation _tmp8_;
	gint _tmp9_;
	GtkAllocation _tmp10_;
	gint _tmp11_;
	gdouble _tmp12_;
	self = _data16_->self;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_TWEET_LIST_ENTRY)) {
		return;
	}
	_tmp1_ = w;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_LIST_ENTRY, TweetListEntry));
	tle = _tmp2_;
	_tmp3_ = tle;
	_tmp4_ = _tmp3_->tweet;
	_tmp5_ = cb_tweet_get_seen (_tmp4_);
	if (_tmp5_) {
		_g_object_unref0 (tle);
		return;
	}
	_tmp6_ = tle;
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), &_tmp7_);
	alloc = _tmp7_;
	_tmp8_ = alloc;
	_tmp9_ = _tmp8_.y;
	_tmp10_ = alloc;
	_tmp11_ = _tmp10_.height;
	_tmp12_ = _data16_->value;
	if ((_tmp9_ + (_tmp11_ / 2.0)) >= _tmp12_) {
		TweetListEntry* _tmp13_;
		CbTweet* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp13_ = tle;
		_tmp14_ = _tmp13_->tweet;
		cb_tweet_set_seen (_tmp14_, TRUE);
		_tmp15_ = default_timeline_get_unread_count (self);
		_tmp16_ = _tmp15_;
		default_timeline_set_unread_count (self, _tmp16_ - 1);
	}
	_g_object_unref0 (tle);
}


static void ___lambda26__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda26_ (self, widget);
}


void default_timeline_mark_seen_on_scroll (DefaultTimeline* self, gdouble value) {
	Block16Data* _data16_;
	gdouble _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	TweetListBox* _tmp3_;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = value;
	_data16_->value = _tmp0_;
	_tmp1_ = default_timeline_get_unread_count (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		block16_data_unref (_data16_);
		_data16_ = NULL;
		return;
	}
	_tmp3_ = self->tweet_list;
	GTK_CONTAINER_GET_CLASS (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer))->forall (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer), FALSE, ___lambda26__gtk_callback, _data16_);
	block16_data_unref (_data16_);
	_data16_ = NULL;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


void default_timeline_rerun_filters (DefaultTimeline* self) {
	CbTweetModel* tm = NULL;
	TweetListBox* _tmp0_;
	CbTweetModel* _tmp1_;
	CbTweetModel* _tmp2_;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_tmp0_ = self->tweet_list;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	tm = _tmp2_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				guint _tmp5_;
				CbTweetModel* _tmp6_;
				guint _tmp7_;
				CbTweet* tweet = NULL;
				CbTweetModel* _tmp8_;
				guint _tmp9_;
				GObject* _tmp10_;
				Account* _tmp11_;
				CbTweet* _tmp12_;
				gboolean _tmp13_;
				if (!_tmp3_) {
					guint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = tm;
				_tmp7_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_list_model_get_type (), GListModel));
				if (!(_tmp5_ < _tmp7_)) {
					break;
				}
				_tmp8_ = tm;
				_tmp9_ = i;
				_tmp10_ = g_list_model_get_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_list_model_get_type (), GListModel), _tmp9_);
				tweet = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, CB_TYPE_TWEET, CbTweet);
				_tmp11_ = self->account;
				_tmp12_ = tweet;
				_tmp13_ = account_filter_matches (_tmp11_, _tmp12_);
				if (_tmp13_) {
					CbTweetModel* _tmp14_;
					CbTweet* _tmp15_;
					gboolean _tmp16_;
					CbTweet* _tmp18_;
					gboolean _tmp19_;
					_tmp14_ = tm;
					_tmp15_ = tweet;
					_tmp16_ = cb_tweet_model_set_tweet_flag (_tmp14_, _tmp15_, CB_TWEET_STATE_HIDDEN_FILTERED);
					if (_tmp16_) {
						guint _tmp17_;
						_tmp17_ = i;
						i = _tmp17_ - 1;
					}
					_tmp18_ = tweet;
					_tmp19_ = cb_tweet_get_seen (_tmp18_);
					if (!_tmp19_) {
						gint _tmp20_;
						gint _tmp21_;
						CbTweet* _tmp22_;
						_tmp20_ = default_timeline_get_unread_count (self);
						_tmp21_ = _tmp20_;
						default_timeline_set_unread_count (self, _tmp21_ - 1);
						_tmp22_ = tweet;
						cb_tweet_set_seen (_tmp22_, TRUE);
					}
				} else {
					CbTweetModel* _tmp23_;
					CbTweet* _tmp24_;
					gboolean _tmp25_;
					_tmp23_ = tm;
					_tmp24_ = tweet;
					_tmp25_ = cb_tweet_model_unset_tweet_flag (_tmp23_, _tmp24_, CB_TWEET_STATE_HIDDEN_FILTERED);
					if (_tmp25_) {
						guint _tmp26_;
						_tmp26_ = i;
						i = _tmp26_ - 1;
					}
				}
				_g_object_unref0 (tweet);
			}
		}
	}
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				guint _tmp29_;
				CbTweetModel* _tmp30_;
				GPtrArray* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				CbTweet* tweet = NULL;
				CbTweetModel* _tmp34_;
				GPtrArray* _tmp35_;
				guint _tmp36_;
				gconstpointer _tmp37_;
				CbTweet* _tmp38_;
				CbTweet* _tmp39_;
				gboolean _tmp40_;
				if (!_tmp27_) {
					guint _tmp28_;
					_tmp28_ = i;
					i = _tmp28_ + 1;
				}
				_tmp27_ = FALSE;
				_tmp29_ = i;
				_tmp30_ = tm;
				_tmp31_ = _tmp30_->hidden_tweets;
				_tmp32_ = g_ptr_array_get_length (_tmp31_);
				_tmp33_ = _tmp32_;
				if (!(_tmp29_ < ((guint) _tmp33_))) {
					break;
				}
				_tmp34_ = tm;
				_tmp35_ = _tmp34_->hidden_tweets;
				_tmp36_ = i;
				_tmp37_ = g_ptr_array_index (_tmp35_, _tmp36_);
				_tmp38_ = _g_object_ref0 ((CbTweet*) _tmp37_);
				tweet = _tmp38_;
				_tmp39_ = tweet;
				_tmp40_ = cb_tweet_is_flag_set (_tmp39_, (guint) CB_TWEET_STATE_HIDDEN_FILTERED);
				if (_tmp40_) {
					Account* _tmp41_;
					CbTweet* _tmp42_;
					gboolean _tmp43_;
					_tmp41_ = self->account;
					_tmp42_ = tweet;
					_tmp43_ = account_filter_matches (_tmp41_, _tmp42_);
					if (!_tmp43_) {
						CbTweetModel* _tmp44_;
						CbTweet* _tmp45_;
						guint _tmp46_;
						_tmp44_ = tm;
						_tmp45_ = tweet;
						cb_tweet_model_unset_tweet_flag (_tmp44_, _tmp45_, CB_TWEET_STATE_HIDDEN_FILTERED);
						_tmp46_ = i;
						i = _tmp46_ - 1;
					}
				}
				_g_object_unref0 (tweet);
			}
		}
	}
	_g_object_unref0 (tm);
}


static gint default_timeline_real_get_id (IPage* base) {
	gint result;
	DefaultTimeline* self;
	gint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void default_timeline_real_set_id (IPage* base, gint value) {
	DefaultTimeline* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	if (default_timeline_real_get_id (base) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_id = _tmp0_;
		g_object_notify ((GObject *) self, "id");
	}
}


gint default_timeline_get_unread_count (DefaultTimeline* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (IS_DEFAULT_TIMELINE (self), 0);
	_tmp0_ = self->priv->_unread_count;
	result = _tmp0_;
	return result;
}


void default_timeline_set_unread_count (DefaultTimeline* self, gint value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	BadgeRadioButton* _tmp9_;
	gint _tmp10_;
	g_return_if_fail (IS_DEFAULT_TIMELINE (self));
	_tmp0_ = default_timeline_get_title (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_unread_count;
	_tmp3_ = value;
	g_debug ("DefaultTimeline.vala:25: Unread count for %s from %d to %d", _tmp1_, _tmp2_, _tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = value;
	_tmp5_ = MAX (_tmp4_, 0);
	self->priv->_unread_count = _tmp5_;
	_tmp6_ = default_timeline_get_title (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = value;
	g_debug ("DefaultTimeline.vala:27: New unread count for %s: %d", _tmp7_, _tmp8_);
	_g_free0 (_tmp7_);
	_tmp9_ = self->radio_button;
	_tmp10_ = self->priv->_unread_count;
	badge_radio_button_set_show_badge (_tmp9_, _tmp10_ > 0);
	g_object_notify ((GObject *) self, "unread-count");
}


static void default_timeline_real_set_window (IPage* base, MainWindow* value) {
	DefaultTimeline* self;
	MainWindow* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp0_ = value;
	self->main_window = _tmp0_;
	g_object_notify ((GObject *) self, "window");
}


const gchar* default_timeline_get_function (DefaultTimeline* self) {
	g_return_val_if_fail (IS_DEFAULT_TIMELINE (self), NULL);
	return DEFAULT_TIMELINE_GET_CLASS (self)->get_function (self);
}


static void default_timeline_class_init (DefaultTimelineClass * klass) {
	default_timeline_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DefaultTimelinePrivate));
	((DefaultTimelineClass *) klass)->on_join = (void (*) (DefaultTimeline *, gint, CbBundle*)) default_timeline_real_on_join;
	((DefaultTimelineClass *) klass)->on_leave = (void (*) (DefaultTimeline *)) default_timeline_real_on_leave;
	((DefaultTimelineClass *) klass)->get_title = (gchar* (*) (DefaultTimeline *)) default_timeline_real_get_title;
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget *)) default_timeline_real_destroy;
	((DefaultTimelineClass *) klass)->create_radio_button = (void (*) (DefaultTimeline *, GtkRadioButton*)) default_timeline_real_create_radio_button;
	G_OBJECT_CLASS (klass)->get_property = _vala_default_timeline_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_default_timeline_set_property;
	G_OBJECT_CLASS (klass)->finalize = default_timeline_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_TIMELINE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_TIMELINE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_TIMELINE_WINDOW, g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_TIMELINE_FUNCTION, g_param_spec_string ("function", "function", "function", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void default_timeline_ipage_interface_init (IPageIface * iface) {
	default_timeline_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*) (IPage *, gint, CbBundle*)) default_timeline_on_join;
	iface->on_leave = (void (*) (IPage *)) default_timeline_on_leave;
	iface->handles_double_open = (gboolean (*) (IPage *)) default_timeline_real_handles_double_open;
	iface->double_open = (void (*) (IPage *)) default_timeline_real_double_open;
	iface->get_title = (gchar* (*) (IPage *)) default_timeline_get_title;
	iface->create_radio_button = (void (*) (IPage *, GtkRadioButton*)) default_timeline_create_radio_button;
	iface->get_radio_button = (GtkRadioButton* (*) (IPage *)) default_timeline_real_get_radio_button;
	iface->get_id = default_timeline_real_get_id;
	iface->set_id = default_timeline_real_set_id;
	iface->set_window = default_timeline_real_set_window;
}


static void default_timeline_instance_init (DefaultTimeline * self) {
	TweetListBox* _tmp0_;
	self->priv = DEFAULT_TIMELINE_GET_PRIVATE (self);
	self->initialized = FALSE;
	self->priv->_unread_count = 0;
	_tmp0_ = tweet_list_box_new ();
	g_object_ref_sink (_tmp0_);
	self->tweet_list = _tmp0_;
	self->tweet_remove_timeout = (guint) 0;
	self->loading = FALSE;
	self->last_focus_widget = NULL;
	self->priv->last_value = 0.0;
}


static void default_timeline_finalize (GObject * obj) {
	DefaultTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_g_object_unref0 (self->tweet_list);
	_g_object_unref0 (self->radio_button);
	_g_object_unref0 (self->last_focus_widget);
	G_OBJECT_CLASS (default_timeline_parent_class)->finalize (obj);
}


GType default_timeline_get_type (void) {
	static volatile gsize default_timeline_type_id__volatile = 0;
	if (g_once_init_enter (&default_timeline_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DefaultTimelineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) default_timeline_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DefaultTimeline), 0, (GInstanceInitFunc) default_timeline_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) default_timeline_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType default_timeline_type_id;
		default_timeline_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "DefaultTimeline", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (default_timeline_type_id, TYPE_IPAGE, &ipage_info);
		g_once_init_leave (&default_timeline_type_id__volatile, default_timeline_type_id);
	}
	return default_timeline_type_id__volatile;
}


static void _vala_default_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DefaultTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	switch (property_id) {
		case DEFAULT_TIMELINE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case DEFAULT_TIMELINE_UNREAD_COUNT:
		g_value_set_int (value, default_timeline_get_unread_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_default_timeline_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DefaultTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	switch (property_id) {
		case DEFAULT_TIMELINE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case DEFAULT_TIMELINE_UNREAD_COUNT:
		default_timeline_set_unread_count (self, g_value_get_int (value));
		break;
		case DEFAULT_TIMELINE_WINDOW:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



