/* BackendFile.c generated by valac 0.30.2, the Vala compiler
 * generated from BackendFile.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_TOOL_JOB_TYPE_MODE (deja_dup_tool_job_mode_get_type ())

#define DEJA_DUP_TYPE_BACKEND_FILE (deja_dup_backend_file_get_type ())
#define DEJA_DUP_BACKEND_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFile))
#define DEJA_DUP_BACKEND_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFileClass))
#define DEJA_DUP_IS_BACKEND_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_FILE))
#define DEJA_DUP_IS_BACKEND_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_FILE))
#define DEJA_DUP_BACKEND_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFileClass))

typedef struct _DejaDupBackendFile DejaDupBackendFile;
typedef struct _DejaDupBackendFileClass DejaDupBackendFileClass;
typedef struct _DejaDupBackendFilePrivate DejaDupBackendFilePrivate;

#define DEJA_DUP_TYPE_FILTERED_SETTINGS (deja_dup_filtered_settings_get_type ())
#define DEJA_DUP_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettings))
#define DEJA_DUP_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))
#define DEJA_DUP_IS_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_IS_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_FILTERED_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))

typedef struct _DejaDupFilteredSettings DejaDupFilteredSettings;
typedef struct _DejaDupFilteredSettingsClass DejaDupFilteredSettingsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DEJA_DUP_TYPE_NETWORK (deja_dup_network_get_type ())
#define DEJA_DUP_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetwork))
#define DEJA_DUP_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))
#define DEJA_DUP_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))

typedef struct _DejaDupNetwork DejaDupNetwork;
typedef struct _DejaDupNetworkClass DejaDupNetworkClass;
typedef struct _DejaDupBackendFileIsReadyData DejaDupBackendFileIsReadyData;
typedef struct _DejaDupBackendFileCheckForVolumeInfoData DejaDupBackendFileCheckForVolumeInfoData;
typedef struct _DejaDupBackendFileSetVolumeInfoData DejaDupBackendFileSetVolumeInfoData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _DejaDupBackendFileGetEnvpData DejaDupBackendFileGetEnvpData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _DejaDupBackendFileDelayData DejaDupBackendFileDelayData;
typedef struct _DejaDupBackendFileMountFileData DejaDupBackendFileMountFileData;
typedef struct _Block2Data Block2Data;
typedef struct _DejaDupBackendFileMountRemoteData DejaDupBackendFileMountRemoteData;
typedef struct _DejaDupBackendFileMountVolumeData DejaDupBackendFileMountVolumeData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _DejaDupBackendFileWaitForVolumeData DejaDupBackendFileWaitForVolumeData;
typedef struct _DejaDupBackendFileGetSpaceData DejaDupBackendFileGetSpaceData;

typedef enum  {
	DEJA_DUP_TOOL_JOB_MODE_INVALID,
	DEJA_DUP_TOOL_JOB_MODE_BACKUP,
	DEJA_DUP_TOOL_JOB_MODE_RESTORE,
	DEJA_DUP_TOOL_JOB_MODE_STATUS,
	DEJA_DUP_TOOL_JOB_MODE_LIST,
	DEJA_DUP_TOOL_JOB_MODE_HISTORY
} DejaDupToolJobMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	gboolean (*is_native) (DejaDupBackend* self);
	GIcon* (*get_icon) (DejaDupBackend* self);
	gchar* (*get_location) (DejaDupBackend* self, gboolean* as_root);
	gchar* (*get_location_pretty) (DejaDupBackend* self);
	void (*is_ready) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*is_ready_finish) (DejaDupBackend* self, GAsyncResult* _res_, gchar** when);
	void (*get_envp) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_envp_finish) (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
	void (*get_space) (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint64 (*get_space_finish) (DejaDupBackend* self, GAsyncResult* _res_);
	gboolean (*space_can_be_infinite) (DejaDupBackend* self);
	void (*add_argv) (DejaDupBackend* self, DejaDupToolJobMode mode, GList** argv);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendFile {
	DejaDupBackend parent_instance;
	DejaDupBackendFilePrivate * priv;
};

struct _DejaDupBackendFileClass {
	DejaDupBackendClass parent_class;
};

struct _DejaDupBackendFileIsReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	gchar* when;
	gboolean result;
	GFile* file;
	GFile* _tmp0_;
	GFile* _tmp1_;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp2_;
	gchar* uuid;
	DejaDupFilteredSettings* _tmp3_;
	gchar* _tmp4_;
	GVolume* vol;
	const gchar* _tmp5_;
	GVolume* _tmp6_;
	GVolume* _tmp7_;
	gchar* name;
	DejaDupFilteredSettings* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GFile* _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	DejaDupNetwork* _tmp17_;
	DejaDupNetwork* _tmp18_;
	GFile* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
};

struct _DejaDupBackendFileCheckForVolumeInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* file;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	DejaDupFilteredSettings* _tmp3_;
	GFile* _tmp4_;
	gboolean _tmp5_;
	GMount* mount;
	GMount* _tmp6_;
	GFile* _tmp7_;
	GMount* _tmp8_;
	GMount* _tmp9_;
	GError* e;
	GMount* _tmp10_;
	DejaDupFilteredSettings* _tmp11_;
	GVolume* volume;
	GMount* _tmp12_;
	GVolume* _tmp13_;
	GVolume* _tmp14_;
	gchar* relpath;
	GFile* _tmp15_;
	GMount* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	GVolume* _tmp23_;
	const gchar* _tmp24_;
	GError * _inner_error_;
};

struct _DejaDupBackendFileSetVolumeInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GVolume* volume;
	gchar* relpath;
	gchar* uuid;
	GVolume* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp5_;
	DejaDupFilteredSettings* _tmp6_;
	DejaDupFilteredSettings* _tmp7_;
	DejaDupFilteredSettings* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	DejaDupFilteredSettings* _tmp11_;
	const gchar* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GVolume* _tmp15_;
	DejaDupFilteredSettings* _tmp16_;
};

struct _DejaDupBackendFileGetEnvpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	GError* e;
	GList* _tmp0_;
	GError* _tmp1_;
	const gchar* _tmp2_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	DejaDupBackendFile* self;
	GMainLoop* loop;
	gpointer _async_data_;
};

struct _DejaDupBackendFileDelayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	guint secs;
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	guint _tmp1_;
};

struct _DejaDupBackendFileMountFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	gboolean success;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp0_;
	gchar* type;
	DejaDupFilteredSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	GFile* file;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GFile* _tmp11_;
	gboolean _tmp12_;
	GError* err;
	GError* _tmp13_;
	gboolean _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	gboolean _tmp17_;
	GFile* gfile;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GError* err2;
	gboolean _tmp21_;
	GList* _tmp22_;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	DejaDupBackendFile* self;
	GMainLoop* loop;
};

struct _DejaDupBackendFileMountRemoteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	GFile* file;
	gboolean result;
	DejaDupNetwork* _tmp0_;
	DejaDupNetwork* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	Block2Data* _data2_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GMainLoop* _tmp7_;
	gulong sigid;
	DejaDupNetwork* _tmp8_;
	DejaDupNetwork* _tmp9_;
	gulong _tmp10_;
	gulong _tmp11_;
	GMainLoop* _tmp12_;
	DejaDupNetwork* _tmp13_;
	DejaDupNetwork* _tmp14_;
	gulong _tmp15_;
	GMount* mount;
	GFile* _tmp16_;
	GMount* _tmp17_;
	GMount* _tmp18_;
	GError* e;
	gboolean _tmp19_;
	GFile* _tmp20_;
	GMountOperation* _tmp21_;
	GMountOperation* _tmp22_;
	gboolean _tmp23_;
	GError * _inner_error_;
};

struct _DejaDupBackendFileMountVolumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	gboolean result;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp0_;
	gchar* uuid;
	DejaDupFilteredSettings* _tmp1_;
	gchar* _tmp2_;
	GVolume* vol;
	const gchar* _tmp3_;
	GVolume* _tmp4_;
	GMount* mount;
	GVolume* _tmp5_;
	GMount* _tmp6_;
	GMount* _tmp7_;
	GVolume* _tmp8_;
	gboolean rv;
	GVolume* _tmp9_;
	GMountOperation* _tmp10_;
	GMountOperation* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GVolume* _tmp14_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	DejaDupBackendFile* self;
	GMainLoop* loop;
};

struct _DejaDupBackendFileWaitForVolumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	gchar* uuid;
	GVolume* result;
	GVolume* vol;
	const gchar* _tmp0_;
	GVolume* _tmp1_;
	GVolume* _tmp2_;
	Block3Data* _data3_;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp3_;
	gchar* name;
	DejaDupFilteredSettings* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GMainLoop* _tmp11_;
	GVolumeMonitor* mon;
	GVolumeMonitor* _tmp12_;
	GVolumeMonitor* _tmp13_;
	gulong sigid;
	GVolumeMonitor* _tmp14_;
	gulong _tmp15_;
	GMainLoop* _tmp16_;
	GVolumeMonitor* _tmp17_;
	gulong _tmp18_;
	GVolume* _tmp19_;
	const gchar* _tmp20_;
	GVolume* _tmp21_;
	GVolume* _tmp22_;
	GError * _inner_error_;
};

struct _DejaDupBackendFileGetSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	gboolean free;
	guint64 result;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gchar* attr;
	gchar* _tmp2_;
	GFile* file;
	GFile* _tmp3_;
	GFileInfo* info;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	GFileInfo* _tmp6_;
	GFileInfo* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	guint64 _tmp10_;
	guint64 space;
	GFileInfo* _tmp11_;
	const gchar* _tmp12_;
	guint64 _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	const gchar* _tmp18_;
	gchar* free_str;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** free_list;
	const gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint free_list_length1;
	gint _free_list_size_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	const gchar* _tmp25_;
	guint64 _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gchar* _tmp31_;
	gchar* _tmp32_;
	guint64 _tmp33_;
	guint64 _tmp34_;
	guint64 _tmp35_;
	GError* e;
	GError* _tmp36_;
	const gchar* _tmp37_;
	guint64 _tmp38_;
	GError * _inner_error_;
};


static gpointer deja_dup_backend_file_parent_class = NULL;
extern guint64 deja_dup_backend_INFINITE_SPACE;

#define DEJA_DUP_FILE_ROOT "File"
#define DEJA_DUP_FILE_TYPE_KEY "type"
#define DEJA_DUP_FILE_PATH_KEY "path"
#define DEJA_DUP_FILE_RELPATH_KEY "relpath"
#define DEJA_DUP_FILE_UUID_KEY "uuid"
#define DEJA_DUP_FILE_NAME_KEY "name"
#define DEJA_DUP_FILE_SHORT_NAME_KEY "short-name"
#define DEJA_DUP_FILE_ICON_KEY "icon"
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_tool_job_mode_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_file_get_type (void) G_GNUC_CONST;
enum  {
	DEJA_DUP_BACKEND_FILE_DUMMY_PROPERTY
};
static DejaDupBackend* deja_dup_backend_file_real_clone (DejaDupBackend* base);
DejaDupBackendFile* deja_dup_backend_file_new (void);
DejaDupBackendFile* deja_dup_backend_file_construct (GType object_type);
static GFile* deja_dup_backend_file_get_file_from_settings (void);
GType deja_dup_filtered_settings_get_type (void) G_GNUC_CONST;
DejaDupFilteredSettings* deja_dup_get_settings (const gchar* subdir);
GVolume* deja_dup_backend_file_find_volume_by_uuid (const gchar* uuid);
static gchar* deja_dup_backend_file_real_get_location (DejaDupBackend* base, gboolean* as_root);
static gchar* deja_dup_backend_file_real_get_location_pretty (DejaDupBackend* base);
gchar* deja_dup_get_file_desc (GFile* file);
static gboolean deja_dup_backend_file_real_is_native (DejaDupBackend* base);
static void deja_dup_backend_file_real_is_ready_data_free (gpointer _data);
static void deja_dup_backend_file_real_is_ready (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_file_real_is_ready_co (DejaDupBackendFileIsReadyData* _data_);
GType deja_dup_network_get_type (void) G_GNUC_CONST;
DejaDupNetwork* deja_dup_network_get (void);
void deja_dup_network_can_reach (DejaDupNetwork* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean deja_dup_network_can_reach_finish (DejaDupNetwork* self, GAsyncResult* _res_);
static void deja_dup_backend_file_is_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GIcon* deja_dup_backend_file_real_get_icon (DejaDupBackend* base);
static void deja_dup_backend_file_real_add_argv (DejaDupBackend* base, DejaDupToolJobMode mode, GList** argv);
static void deja_dup_backend_file_check_for_volume_info_data_free (gpointer _data);
void deja_dup_backend_file_check_for_volume_info (GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_backend_file_check_for_volume_info_finish (GAsyncResult* _res_, GError** error);
static gboolean deja_dup_backend_file_check_for_volume_info_co (DejaDupBackendFileCheckForVolumeInfoData* _data_);
void deja_dup_filtered_settings_set_string (DejaDupFilteredSettings* self, const gchar* k, const gchar* v);
static void deja_dup_backend_file_check_for_volume_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void deja_dup_backend_file_set_volume_info (GVolume* volume, const gchar* relpath, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_backend_file_set_volume_info_finish (GAsyncResult* _res_);
static void deja_dup_backend_file_set_volume_info_data_free (gpointer _data);
static gboolean deja_dup_backend_file_set_volume_info_co (DejaDupBackendFileSetVolumeInfoData* _data_);
void deja_dup_filtered_settings_set_value (DejaDupFilteredSettings* self, const gchar* k, GVariant* v);
static void deja_dup_backend_file_update_volume_info (GVolume* volume);
void deja_dup_filtered_settings_apply (DejaDupFilteredSettings* self);
static void deja_dup_backend_file_real_get_envp_data_free (gpointer _data);
static void deja_dup_backend_file_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_file_real_get_envp_co (DejaDupBackendFileGetEnvpData* _data_);
static void deja_dup_backend_file_mount_file (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_backend_file_mount_file_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error);
static void deja_dup_backend_file_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static gboolean deja_dup_backend_file_is_being_mounted_error (DejaDupBackendFile* self, GError* e);
static void deja_dup_backend_file_delay_data_free (gpointer _data);
static void deja_dup_backend_file_delay (DejaDupBackendFile* self, guint secs, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_backend_file_delay_finish (DejaDupBackendFile* self, GAsyncResult* _res_);
static gboolean deja_dup_backend_file_delay_co (DejaDupBackendFileDelayData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda7_ (Block1Data* _data1_);
static gboolean ___lambda7__gsource_func (gpointer self);
static void deja_dup_backend_file_mount_file_data_free (gpointer _data);
static gboolean deja_dup_backend_file_mount_file_co (DejaDupBackendFileMountFileData* _data_);
static void deja_dup_backend_file_mount_volume (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_file_mount_volume_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error);
static void deja_dup_backend_file_mount_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_backend_file_mount_remote (DejaDupBackendFile* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_file_mount_remote_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error);
static void deja_dup_backend_file_mount_remote_data_free (gpointer _data);
static gboolean deja_dup_backend_file_mount_remote_co (DejaDupBackendFileMountRemoteData* _data_);
gboolean deja_dup_network_get_connected (DejaDupNetwork* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda6_ (Block2Data* _data2_);
static void ____lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void deja_dup_backend_file_mount_remote_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GMountOperation* deja_dup_backend_get_mount_op (DejaDupBackend* self);
static void deja_dup_backend_file_mount_volume_data_free (gpointer _data);
static gboolean deja_dup_backend_file_mount_volume_co (DejaDupBackendFileMountVolumeData* _data_);
static void deja_dup_backend_file_wait_for_volume (DejaDupBackendFile* self, const gchar* uuid, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GVolume* deja_dup_backend_file_wait_for_volume_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error);
static void deja_dup_backend_file_mount_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void deja_dup_backend_file_wait_for_volume_data_free (gpointer _data);
static gboolean deja_dup_backend_file_wait_for_volume_co (DejaDupBackendFileWaitForVolumeData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda5_ (Block3Data* _data3_, GVolumeMonitor* m, GVolume* v);
static void ____lambda5__g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void deja_dup_backend_file_wait_for_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_backend_file_real_get_space_data_free (gpointer _data);
static void deja_dup_backend_file_real_get_space (DejaDupBackend* base, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_file_real_get_space_co (DejaDupBackendFileGetSpaceData* _data_);
static void deja_dup_backend_file_get_space_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean deja_dup_in_testing_mode (void);
static gboolean deja_dup_backend_file_real_space_can_be_infinite (DejaDupBackend* base);
DejaDupBackend* deja_dup_backend_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static DejaDupBackend* deja_dup_backend_file_real_clone (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	DejaDupBackend* result = NULL;
	DejaDupBackendFile* _tmp0_ = NULL;
	self = (DejaDupBackendFile*) base;
	_tmp0_ = deja_dup_backend_file_new ();
	result = (DejaDupBackend*) _tmp0_;
	return result;
}


static GFile* deja_dup_backend_file_get_file_from_settings (void) {
	GFile* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* type = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_FILE_TYPE_KEY);
	type = _tmp2_;
	_tmp3_ = type;
	if (g_strcmp0 (_tmp3_, "volume") == 0) {
		GVariant* path_val = NULL;
		DejaDupFilteredSettings* _tmp4_ = NULL;
		GVariant* _tmp5_ = NULL;
		gchar* path = NULL;
		GVariant* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* uuid = NULL;
		DejaDupFilteredSettings* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GVolume* vol = NULL;
		const gchar* _tmp11_ = NULL;
		GVolume* _tmp12_ = NULL;
		GVolume* _tmp13_ = NULL;
		GMount* mount = NULL;
		GVolume* _tmp14_ = NULL;
		GMount* _tmp15_ = NULL;
		GMount* _tmp16_ = NULL;
		GFile* root = NULL;
		GMount* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp4_ = settings;
		_tmp5_ = g_settings_get_value ((GSettings*) _tmp4_, DEJA_DUP_FILE_RELPATH_KEY);
		path_val = _tmp5_;
		_tmp6_ = path_val;
		_tmp7_ = g_variant_get_bytestring (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		path = _tmp8_;
		_tmp9_ = settings;
		_tmp10_ = g_settings_get_string ((GSettings*) _tmp9_, DEJA_DUP_FILE_UUID_KEY);
		uuid = _tmp10_;
		_tmp11_ = uuid;
		_tmp12_ = deja_dup_backend_file_find_volume_by_uuid (_tmp11_);
		vol = _tmp12_;
		_tmp13_ = vol;
		if (_tmp13_ == NULL) {
			result = NULL;
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_free0 (path);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return result;
		}
		_tmp14_ = vol;
		_tmp15_ = g_volume_get_mount (_tmp14_);
		mount = _tmp15_;
		_tmp16_ = mount;
		if (_tmp16_ == NULL) {
			result = NULL;
			_g_object_unref0 (mount);
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_free0 (path);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return result;
		}
		_tmp17_ = mount;
		_tmp18_ = g_mount_get_root (_tmp17_);
		root = _tmp18_;
		_tmp19_ = path;
		if (_tmp19_ != NULL) {
			GFile* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			GFile* _tmp22_ = NULL;
			_tmp20_ = root;
			_tmp21_ = path;
			_tmp22_ = g_file_get_child (_tmp20_, _tmp21_);
			result = _tmp22_;
			_g_object_unref0 (root);
			_g_object_unref0 (mount);
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_free0 (path);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return result;
		} else {
			result = root;
			_g_object_unref0 (mount);
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_free0 (path);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return result;
		}
		_g_object_unref0 (root);
		_g_object_unref0 (mount);
		_g_object_unref0 (vol);
		_g_free0 (uuid);
		_g_free0 (path);
		_g_variant_unref0 (path_val);
	} else {
		gchar* path = NULL;
		DejaDupFilteredSettings* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		GFile* _tmp26_ = NULL;
		_tmp23_ = settings;
		_tmp24_ = g_settings_get_string ((GSettings*) _tmp23_, DEJA_DUP_FILE_PATH_KEY);
		path = _tmp24_;
		_tmp25_ = path;
		_tmp26_ = g_file_parse_name (_tmp25_);
		result = _tmp26_;
		_g_free0 (path);
		_g_free0 (type);
		_g_object_unref0 (settings);
		return result;
	}
	_g_free0 (type);
	_g_object_unref0 (settings);
}


static gchar* deja_dup_backend_file_real_get_location (DejaDupBackend* base, gboolean* as_root) {
	DejaDupBackendFile * self;
	gchar* result = NULL;
	GFile* file = NULL;
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	self = (DejaDupBackendFile*) base;
	_tmp0_ = deja_dup_backend_file_get_file_from_settings ();
	file = _tmp0_;
	_tmp2_ = *as_root;
	if (_tmp2_) {
		GFile* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = file;
		_tmp4_ = g_file_is_native (_tmp3_);
		_tmp1_ = !_tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		*as_root = FALSE;
	}
	_tmp5_ = file;
	_tmp6_ = g_file_get_uri (_tmp5_);
	result = _tmp6_;
	_g_object_unref0 (file);
	return result;
}


static gchar* deja_dup_backend_file_real_get_location_pretty (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	gchar* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* type = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_FILE_TYPE_KEY);
	type = _tmp2_;
	_tmp3_ = type;
	if (g_strcmp0 (_tmp3_, "volume") == 0) {
		GVariant* path_val = NULL;
		DejaDupFilteredSettings* _tmp4_ = NULL;
		GVariant* _tmp5_ = NULL;
		gchar* path = NULL;
		gchar* _tmp6_ = NULL;
		gchar* name = NULL;
		DejaDupFilteredSettings* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp4_ = settings;
		_tmp5_ = g_settings_get_value ((GSettings*) _tmp4_, DEJA_DUP_FILE_RELPATH_KEY);
		path_val = _tmp5_;
		_tmp6_ = g_strdup ("");
		path = _tmp6_;
		{
			gchar* _tmp7_ = NULL;
			GVariant* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			_tmp8_ = path_val;
			_tmp9_ = g_variant_get_bytestring (_tmp8_);
			_tmp10_ = g_filename_to_utf8 (_tmp9_, (gssize) -1, NULL, NULL, &_inner_error_);
			_tmp7_ = _tmp10_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp11_ = _tmp7_;
			_tmp7_ = NULL;
			_g_free0 (path);
			path = _tmp11_;
			_g_free0 (_tmp7_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			g_warning ("BackendFile.vala:127: %s\n", _tmp13_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (path);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp14_ = settings;
		_tmp15_ = g_settings_get_string ((GSettings*) _tmp14_, DEJA_DUP_FILE_SHORT_NAME_KEY);
		name = _tmp15_;
		_tmp16_ = path;
		if (g_strcmp0 (_tmp16_, "") == 0) {
			result = name;
			_g_free0 (path);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return result;
		} else {
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			_tmp17_ = _ ("%1$s on %2$s");
			_tmp18_ = path;
			_tmp19_ = name;
			_tmp20_ = g_strdup_printf (_tmp17_, _tmp18_, _tmp19_);
			result = _tmp20_;
			_g_free0 (name);
			_g_free0 (path);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return result;
		}
		_g_free0 (name);
		_g_free0 (path);
		_g_variant_unref0 (path_val);
	} else {
		GFile* file = NULL;
		GFile* _tmp21_ = NULL;
		GFile* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		_tmp21_ = deja_dup_backend_file_get_file_from_settings ();
		file = _tmp21_;
		_tmp22_ = file;
		_tmp23_ = deja_dup_get_file_desc (_tmp22_);
		result = _tmp23_;
		_g_object_unref0 (file);
		_g_free0 (type);
		_g_object_unref0 (settings);
		return result;
	}
	_g_free0 (type);
	_g_object_unref0 (settings);
}


static gboolean deja_dup_backend_file_real_is_native (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	gboolean result = FALSE;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* type = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GFile* file = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	self = (DejaDupBackendFile*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_FILE_TYPE_KEY);
	type = _tmp2_;
	_tmp3_ = type;
	if (g_strcmp0 (_tmp3_, "volume") == 0) {
		result = TRUE;
		_g_free0 (type);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp4_ = deja_dup_backend_file_get_file_from_settings ();
	file = _tmp4_;
	_tmp5_ = file;
	if (_tmp5_ != NULL) {
		GFile* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = file;
		_tmp7_ = g_file_is_native (_tmp6_);
		result = _tmp7_;
		_g_object_unref0 (file);
		_g_free0 (type);
		_g_object_unref0 (settings);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (file);
	_g_free0 (type);
	_g_object_unref0 (settings);
	return result;
}


static void deja_dup_backend_file_real_is_ready_data_free (gpointer _data) {
	DejaDupBackendFileIsReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFileIsReadyData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_backend_file_real_is_ready (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFile * self;
	DejaDupBackendFileIsReadyData* _data_;
	DejaDupBackendFile* _tmp0_ = NULL;
	self = (DejaDupBackendFile*) base;
	_data_ = g_slice_new0 (DejaDupBackendFileIsReadyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_real_is_ready);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_real_is_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_file_real_is_ready_co (_data_);
}


static gboolean deja_dup_backend_file_real_is_ready_finish (DejaDupBackend* base, GAsyncResult* _res_, gchar** when) {
	gboolean result;
	DejaDupBackendFileIsReadyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (when) {
		*when = _data_->when;
	} else {
		_g_free0 (_data_->when);
	}
	_data_->when = NULL;
	result = _data_->result;
	return result;
}


static void deja_dup_backend_file_is_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileIsReadyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_real_is_ready_co (_data_);
}


static gboolean deja_dup_backend_file_real_is_ready_co (DejaDupBackendFileIsReadyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_g_free0 (_data_->when);
	_data_->when = NULL;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = deja_dup_backend_file_get_file_from_settings ();
	_data_->file = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->file;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
		_data_->settings = _data_->_tmp2_;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->settings;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = g_settings_get_string ((GSettings*) _data_->_tmp3_, DEJA_DUP_FILE_UUID_KEY);
		_data_->uuid = _data_->_tmp4_;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->uuid;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = deja_dup_backend_file_find_volume_by_uuid (_data_->_tmp5_);
		_data_->vol = _data_->_tmp6_;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->vol;
		if (_data_->_tmp7_ != NULL) {
			_data_->result = TRUE;
			_g_object_unref0 (_data_->vol);
			_g_free0 (_data_->uuid);
			_g_object_unref0 (_data_->settings);
			_g_object_unref0 (_data_->file);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->settings;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = g_settings_get_string ((GSettings*) _data_->_tmp8_, DEJA_DUP_FILE_SHORT_NAME_KEY);
			_data_->name = _data_->_tmp9_;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = _ ("Backup will begin when %s becomes connected.");
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->name;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = g_strdup_printf (_data_->_tmp10_, _data_->_tmp11_);
			_g_free0 (_data_->when);
			_data_->when = _data_->_tmp12_;
			_data_->result = FALSE;
			_g_free0 (_data_->name);
			_g_object_unref0 (_data_->vol);
			_g_free0 (_data_->uuid);
			_g_object_unref0 (_data_->settings);
			_g_object_unref0 (_data_->file);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->vol);
		_g_free0 (_data_->uuid);
		_g_object_unref0 (_data_->settings);
	} else {
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->file;
		_data_->_tmp14_ = FALSE;
		_data_->_tmp14_ = g_file_is_native (_data_->_tmp13_);
		if (_data_->_tmp14_) {
			_data_->result = TRUE;
			_g_object_unref0 (_data_->file);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _ ("Backup will begin when a network connection becomes available.");
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
			_g_free0 (_data_->when);
			_data_->when = _data_->_tmp16_;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = deja_dup_network_get ();
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->file;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = g_file_get_uri (_data_->_tmp19_);
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->_tmp20_;
			_data_->_state_ = 1;
			deja_dup_network_can_reach (_data_->_tmp18_, _data_->_tmp21_, deja_dup_backend_file_is_ready_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp22_ = FALSE;
			_data_->_tmp22_ = deja_dup_network_can_reach_finish (_data_->_tmp18_, _data_->_res_);
			_data_->_tmp23_ = FALSE;
			_data_->_tmp23_ = _data_->_tmp22_;
			_g_free0 (_data_->_tmp21_);
			_g_object_unref0 (_data_->_tmp18_);
			_data_->result = _data_->_tmp23_;
			_g_object_unref0 (_data_->file);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->file);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static GIcon* deja_dup_backend_file_real_get_icon (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	GIcon* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* type = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* icon_name = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_FILE_TYPE_KEY);
	type = _tmp2_;
	_tmp3_ = g_strdup ("folder-remote");
	icon_name = _tmp3_;
	_tmp4_ = type;
	if (g_strcmp0 (_tmp4_, "volume") == 0) {
		DejaDupFilteredSettings* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = settings;
		_tmp6_ = g_settings_get_string ((GSettings*) _tmp5_, DEJA_DUP_FILE_ICON_KEY);
		_g_free0 (icon_name);
		icon_name = _tmp6_;
	} else {
		GFile* file = NULL;
		GFile* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		_tmp7_ = deja_dup_backend_file_get_file_from_settings ();
		file = _tmp7_;
		_tmp8_ = file;
		if (_tmp8_ != NULL) {
			{
				GFileInfo* info = NULL;
				GFile* _tmp9_ = NULL;
				GFileInfo* _tmp10_ = NULL;
				GFileInfo* _tmp11_ = NULL;
				GIcon* _tmp12_ = NULL;
				GIcon* _tmp13_ = NULL;
				_tmp9_ = file;
				_tmp10_ = g_file_query_info (_tmp9_, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
				info = _tmp10_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch2_g_error;
				}
				_tmp11_ = info;
				_tmp12_ = g_file_info_get_icon (_tmp11_);
				_tmp13_ = _g_object_ref0 (_tmp12_);
				result = _tmp13_;
				_g_object_unref0 (info);
				_g_object_unref0 (file);
				_g_free0 (icon_name);
				_g_free0 (type);
				_g_object_unref0 (settings);
				return result;
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				GFile* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp14_ = file;
				_tmp15_ = g_file_is_native (_tmp14_);
				if (_tmp15_) {
					gchar* _tmp16_ = NULL;
					_tmp16_ = g_strdup ("folder");
					_g_free0 (icon_name);
					icon_name = _tmp16_;
				}
				_g_error_free0 (e);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (icon_name);
				_g_free0 (type);
				_g_object_unref0 (settings);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_g_object_unref0 (file);
	}
	{
		GIcon* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		GIcon* _tmp19_ = NULL;
		GIcon* _tmp20_ = NULL;
		_tmp18_ = icon_name;
		_tmp19_ = g_icon_new_for_string (_tmp18_, &_inner_error_);
		_tmp17_ = _tmp19_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp20_ = _tmp17_;
		_tmp17_ = NULL;
		result = _tmp20_;
		_g_object_unref0 (_tmp17_);
		_g_free0 (icon_name);
		_g_free0 (type);
		_g_object_unref0 (settings);
		return result;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("BackendFile.vala:205: %s\n", _tmp22_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (icon_name);
		_g_free0 (type);
		_g_object_unref0 (settings);
		return result;
	}
	__finally3:
	_g_free0 (icon_name);
	_g_free0 (type);
	_g_object_unref0 (settings);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void deja_dup_backend_file_real_add_argv (DejaDupBackend* base, DejaDupToolJobMode mode, GList** argv) {
	DejaDupBackendFile * self;
	DejaDupToolJobMode _tmp0_ = 0;
	DejaDupToolJobMode _tmp10_ = 0;
	self = (DejaDupBackendFile*) base;
	_tmp0_ = mode;
	if (_tmp0_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
		GFile* file = NULL;
		GFile* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		GFile* _tmp3_ = NULL;
		_tmp1_ = deja_dup_backend_file_get_file_from_settings ();
		file = _tmp1_;
		_tmp3_ = file;
		if (_tmp3_ != NULL) {
			GFile* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			_tmp4_ = file;
			_tmp5_ = g_file_is_native (_tmp4_);
			_tmp2_ = _tmp5_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GFile* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			_tmp6_ = file;
			_tmp7_ = g_file_get_path (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup_printf ("--exclude=%s", _tmp8_);
			*argv = g_list_prepend (*argv, _tmp9_);
			_g_free0 (_tmp8_);
		}
		_g_object_unref0 (file);
	}
	_tmp10_ = mode;
	if (_tmp10_ == DEJA_DUP_TOOL_JOB_MODE_INVALID) {
		gchar* _tmp11_ = NULL;
		_tmp11_ = g_strdup ("--gio");
		*argv = g_list_prepend (*argv, _tmp11_);
	}
}


static void deja_dup_backend_file_check_for_volume_info_data_free (gpointer _data) {
	DejaDupBackendFileCheckForVolumeInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	g_slice_free (DejaDupBackendFileCheckForVolumeInfoData, _data_);
}


void deja_dup_backend_file_check_for_volume_info (GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileCheckForVolumeInfoData* _data_;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	_data_ = g_slice_new0 (DejaDupBackendFileCheckForVolumeInfoData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, deja_dup_backend_file_check_for_volume_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_check_for_volume_info_data_free);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	deja_dup_backend_file_check_for_volume_info_co (_data_);
}


void deja_dup_backend_file_check_for_volume_info_finish (GAsyncResult* _res_, GError** error) {
	DejaDupBackendFileCheckForVolumeInfoData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_file_check_for_volume_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileCheckForVolumeInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_check_for_volume_info_co (_data_);
}


static gboolean deja_dup_backend_file_check_for_volume_info_co (DejaDupBackendFileCheckForVolumeInfoData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	_data_->settings = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->file;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = g_file_is_native (_data_->_tmp1_);
	if (!_data_->_tmp2_) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->settings;
		deja_dup_filtered_settings_set_string (_data_->_tmp3_, DEJA_DUP_FILE_TYPE_KEY, "normal");
		_g_object_unref0 (_data_->settings);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->file;
	_data_->_tmp5_ = FALSE;
	_data_->_tmp5_ = g_file_query_exists (_data_->_tmp4_, NULL);
	if (!_data_->_tmp5_) {
		_g_object_unref0 (_data_->settings);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->mount = NULL;
	{
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->file;
		_data_->_state_ = 1;
		g_file_find_enclosing_mount_async (_data_->_tmp7_, G_PRIORITY_DEFAULT, NULL, deja_dup_backend_file_check_for_volume_info_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = g_file_find_enclosing_mount_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp6_ = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp6_;
		_data_->_tmp6_ = NULL;
		_g_object_unref0 (_data_->mount);
		_data_->mount = _data_->_tmp9_;
		_g_object_unref0 (_data_->_tmp6_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->e);
	}
	__finally4:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->mount);
		_g_object_unref0 (_data_->settings);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->mount;
	if (_data_->_tmp10_ == NULL) {
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->settings;
		deja_dup_filtered_settings_set_string (_data_->_tmp11_, DEJA_DUP_FILE_TYPE_KEY, "normal");
		_g_object_unref0 (_data_->mount);
		_g_object_unref0 (_data_->settings);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->mount;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = g_mount_get_volume (_data_->_tmp12_);
	_data_->volume = _data_->_tmp13_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->volume;
	if (_data_->_tmp14_ == NULL) {
		_g_object_unref0 (_data_->volume);
		_g_object_unref0 (_data_->mount);
		_g_object_unref0 (_data_->settings);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->relpath = NULL;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->file;
	if (_data_->_tmp15_ != NULL) {
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->mount;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_mount_get_root (_data_->_tmp16_);
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->file;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = g_file_get_relative_path (_data_->_tmp18_, _data_->_tmp19_);
		_g_free0 (_data_->relpath);
		_data_->relpath = _data_->_tmp20_;
		_g_object_unref0 (_data_->_tmp18_);
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->relpath;
		if (_data_->_tmp21_ == NULL) {
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = g_strdup ("");
			_g_free0 (_data_->relpath);
			_data_->relpath = _data_->_tmp22_;
		}
	}
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->volume;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->relpath;
	_data_->_state_ = 2;
	deja_dup_backend_file_set_volume_info (_data_->_tmp23_, _data_->_tmp24_, deja_dup_backend_file_check_for_volume_info_ready, _data_);
	return FALSE;
	_state_2:
	deja_dup_backend_file_set_volume_info_finish (_data_->_res_);
	_g_free0 (_data_->relpath);
	_g_object_unref0 (_data_->volume);
	_g_object_unref0 (_data_->mount);
	_g_object_unref0 (_data_->settings);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void deja_dup_backend_file_set_volume_info_data_free (gpointer _data) {
	DejaDupBackendFileSetVolumeInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->volume);
	_g_free0 (_data_->relpath);
	g_slice_free (DejaDupBackendFileSetVolumeInfoData, _data_);
}


void deja_dup_backend_file_set_volume_info (GVolume* volume, const gchar* relpath, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileSetVolumeInfoData* _data_;
	GVolume* _tmp0_ = NULL;
	GVolume* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_data_ = g_slice_new0 (DejaDupBackendFileSetVolumeInfoData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, deja_dup_backend_file_set_volume_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_set_volume_info_data_free);
	_tmp0_ = volume;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->volume);
	_data_->volume = _tmp1_;
	_tmp2_ = relpath;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data_->relpath);
	_data_->relpath = _tmp3_;
	deja_dup_backend_file_set_volume_info_co (_data_);
}


void deja_dup_backend_file_set_volume_info_finish (GAsyncResult* _res_) {
	DejaDupBackendFileSetVolumeInfoData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean deja_dup_backend_file_set_volume_info_co (DejaDupBackendFileSetVolumeInfoData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->volume;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_volume_get_identifier (_data_->_tmp0_, G_VOLUME_IDENTIFIER_KIND_UUID);
	_data_->uuid = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->uuid;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->uuid;
		_data_->_tmp2_ = g_strcmp0 (_data_->_tmp4_, "") == 0;
	}
	if (_data_->_tmp2_) {
		_g_free0 (_data_->uuid);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	_data_->settings = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->settings;
	g_settings_delay ((GSettings*) _data_->_tmp6_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->settings;
	deja_dup_filtered_settings_set_string (_data_->_tmp7_, DEJA_DUP_FILE_TYPE_KEY, "volume");
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->settings;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->uuid;
	deja_dup_filtered_settings_set_string (_data_->_tmp8_, DEJA_DUP_FILE_UUID_KEY, _data_->_tmp9_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->relpath;
	if (_data_->_tmp10_ != NULL) {
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->settings;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->relpath;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_variant_new_bytestring (_data_->_tmp12_);
		g_variant_ref_sink (_data_->_tmp13_);
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp13_;
		deja_dup_filtered_settings_set_value (_data_->_tmp11_, DEJA_DUP_FILE_RELPATH_KEY, _data_->_tmp14_);
		_g_variant_unref0 (_data_->_tmp14_);
	}
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->volume;
	deja_dup_backend_file_update_volume_info (_data_->_tmp15_);
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->settings;
	deja_dup_filtered_settings_apply (_data_->_tmp16_);
	_g_object_unref0 (_data_->settings);
	_g_free0 (_data_->uuid);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void deja_dup_backend_file_update_volume_info (GVolume* volume) {
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* name = NULL;
	GVolume* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gchar* short_name = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GDrive* drive = NULL;
	GVolume* _tmp8_ = NULL;
	GDrive* _tmp9_ = NULL;
	GDrive* _tmp10_ = NULL;
	GIcon* icon = NULL;
	GVolume* _tmp19_ = NULL;
	GIcon* _tmp20_ = NULL;
	gchar* icon_str = NULL;
	GIcon* _tmp21_ = NULL;
	DejaDupFilteredSettings* _tmp24_ = NULL;
	DejaDupFilteredSettings* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	DejaDupFilteredSettings* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	DejaDupFilteredSettings* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	DejaDupFilteredSettings* _tmp31_ = NULL;
	g_return_if_fail (volume != NULL);
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	settings = _tmp0_;
	_tmp1_ = volume;
	_tmp2_ = g_volume_get_name (_tmp1_);
	name = _tmp2_;
	_tmp4_ = name;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = name;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	}
	if (_tmp3_) {
		_g_free0 (name);
		_g_object_unref0 (settings);
		return;
	}
	_tmp6_ = name;
	_tmp7_ = g_strdup (_tmp6_);
	short_name = _tmp7_;
	_tmp8_ = volume;
	_tmp9_ = g_volume_get_drive (_tmp8_);
	drive = _tmp9_;
	_tmp10_ = drive;
	if (_tmp10_ != NULL) {
		gchar* drive_name = NULL;
		GDrive* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_ = NULL;
		_tmp11_ = drive;
		_tmp12_ = g_drive_get_name (_tmp11_);
		drive_name = _tmp12_;
		_tmp14_ = drive_name;
		if (_tmp14_ != NULL) {
			const gchar* _tmp15_ = NULL;
			_tmp15_ = drive_name;
			_tmp13_ = g_strcmp0 (_tmp15_, "") != 0;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			_tmp16_ = drive_name;
			_tmp17_ = name;
			_tmp18_ = g_strdup_printf ("%s: %s", _tmp16_, _tmp17_);
			_g_free0 (name);
			name = _tmp18_;
		}
		_g_free0 (drive_name);
	}
	_tmp19_ = volume;
	_tmp20_ = g_volume_get_icon (_tmp19_);
	icon = _tmp20_;
	icon_str = NULL;
	_tmp21_ = icon;
	if (_tmp21_ != NULL) {
		GIcon* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		_tmp22_ = icon;
		_tmp23_ = g_icon_to_string (_tmp22_);
		_g_free0 (icon_str);
		icon_str = _tmp23_;
	}
	_tmp24_ = settings;
	g_settings_delay ((GSettings*) _tmp24_);
	_tmp25_ = settings;
	_tmp26_ = name;
	deja_dup_filtered_settings_set_string (_tmp25_, DEJA_DUP_FILE_NAME_KEY, _tmp26_);
	_tmp27_ = settings;
	_tmp28_ = short_name;
	deja_dup_filtered_settings_set_string (_tmp27_, DEJA_DUP_FILE_SHORT_NAME_KEY, _tmp28_);
	_tmp29_ = settings;
	_tmp30_ = icon_str;
	deja_dup_filtered_settings_set_string (_tmp29_, DEJA_DUP_FILE_ICON_KEY, _tmp30_);
	_tmp31_ = settings;
	deja_dup_filtered_settings_apply (_tmp31_);
	_g_free0 (icon_str);
	_g_object_unref0 (icon);
	_g_object_unref0 (drive);
	_g_free0 (short_name);
	_g_free0 (name);
	_g_object_unref0 (settings);
}


static void deja_dup_backend_file_real_get_envp_data_free (gpointer _data) {
	DejaDupBackendFileGetEnvpData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFileGetEnvpData, _data_);
}


static void deja_dup_backend_file_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFile * self;
	DejaDupBackendFileGetEnvpData* _data_;
	DejaDupBackendFile* _tmp0_ = NULL;
	self = (DejaDupBackendFile*) base;
	_data_ = g_slice_new0 (DejaDupBackendFileGetEnvpData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_real_get_envp);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_real_get_envp_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_file_real_get_envp_co (_data_);
}


static void deja_dup_backend_file_real_get_envp_finish (DejaDupBackend* base, GAsyncResult* _res_, GError** error) {
	DejaDupBackendFileGetEnvpData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_file_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileGetEnvpData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_real_get_envp_co (_data_);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static gboolean deja_dup_backend_file_real_get_envp_co (DejaDupBackendFileGetEnvpData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_object_ref ((GObject*) _data_->self);
	{
		_data_->_state_ = 1;
		deja_dup_backend_file_mount_file (_data_->self, deja_dup_backend_file_get_envp_ready, _data_);
		return FALSE;
		_state_1:
		deja_dup_backend_file_mount_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = NULL;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->e;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->_tmp1_->message;
		g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "envp-ready", FALSE, _data_->_tmp0_, _data_->_tmp2_);
		__g_list_free__g_free0_0 (_data_->_tmp0_);
		_g_error_free0 (_data_->e);
	}
	__finally5:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_object_unref ((GObject*) _data_->self);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean deja_dup_backend_file_is_being_mounted_error (DejaDupBackendFile* self, GError* e) {
	gboolean result = FALSE;
	GError* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = _tmp0_->message;
	_tmp2_ = g_str_has_prefix (_tmp1_, "DBus error org.gtk.Private.RemoteVolumeMonitor.Failed:");
	result = _tmp2_;
	return result;
}


static void deja_dup_backend_file_delay_data_free (gpointer _data) {
	DejaDupBackendFileDelayData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFileDelayData, _data_);
}


static void deja_dup_backend_file_delay (DejaDupBackendFile* self, guint secs, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileDelayData* _data_;
	DejaDupBackendFile* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	_data_ = g_slice_new0 (DejaDupBackendFileDelayData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_delay);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_delay_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = secs;
	_data_->secs = _tmp1_;
	deja_dup_backend_file_delay_co (_data_);
}


static void deja_dup_backend_file_delay_finish (DejaDupBackendFile* self, GAsyncResult* _res_) {
	DejaDupBackendFileDelayData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		DejaDupBackendFile* self;
		self = _data1_->self;
		_g_main_loop_unref0 (_data1_->loop);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda7_ (Block1Data* _data1_) {
	DejaDupBackendFile* self;
	gboolean result = FALSE;
	self = _data1_->self;
	g_main_loop_quit (_data1_->loop);
	result = FALSE;
	return result;
}


static gboolean ___lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda7_ (self);
	return result;
}


static gboolean deja_dup_backend_file_delay_co (DejaDupBackendFileDelayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data_->_data1_->loop = _data_->_tmp0_;
	_data_->_tmp1_ = 0U;
	_data_->_tmp1_ = _data_->secs;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _data_->_tmp1_, ___lambda7__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
	g_main_loop_run (_data_->_data1_->loop);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void deja_dup_backend_file_mount_file_data_free (gpointer _data) {
	DejaDupBackendFileMountFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFileMountFileData, _data_);
}


static void deja_dup_backend_file_mount_file (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileMountFileData* _data_;
	DejaDupBackendFile* _tmp0_ = NULL;
	_data_ = g_slice_new0 (DejaDupBackendFileMountFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_mount_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_mount_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_file_mount_file_co (_data_);
}


static void deja_dup_backend_file_mount_file_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error) {
	DejaDupBackendFileMountFileData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_file_mount_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileMountFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_mount_file_co (_data_);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean deja_dup_backend_file_mount_file_co (DejaDupBackendFileMountFileData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->success = TRUE;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	_data_->settings = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->settings;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_settings_get_string ((GSettings*) _data_->_tmp1_, DEJA_DUP_FILE_TYPE_KEY);
	_data_->type = _data_->_tmp2_;
	{
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->type;
		if (g_strcmp0 (_data_->_tmp3_, "volume") == 0) {
			_data_->_state_ = 1;
			deja_dup_backend_file_mount_volume (_data_->self, deja_dup_backend_file_mount_file_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp5_ = FALSE;
			_data_->_tmp5_ = deja_dup_backend_file_mount_volume_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp4_ = _data_->_tmp5_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_FAILED)) {
					goto __catch6_g_io_error_failed;
				}
				goto __finally6;
			}
			_data_->success = _data_->_tmp4_;
		} else {
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = _data_->type;
			if (g_strcmp0 (_data_->_tmp6_, "normal") == 0) {
				_data_->_tmp7_ = NULL;
				_data_->_tmp7_ = deja_dup_backend_file_get_file_from_settings ();
				_data_->file = _data_->_tmp7_;
				_data_->_tmp8_ = NULL;
				_data_->_tmp8_ = _data_->file;
				_data_->_tmp9_ = FALSE;
				_data_->_tmp9_ = g_file_is_native (_data_->_tmp8_);
				if (!_data_->_tmp9_) {
					_data_->_tmp11_ = NULL;
					_data_->_tmp11_ = _data_->file;
					_data_->_state_ = 2;
					deja_dup_backend_file_mount_remote (_data_->self, _data_->_tmp11_, deja_dup_backend_file_mount_file_ready, _data_);
					return FALSE;
					_state_2:
					_data_->_tmp12_ = FALSE;
					_data_->_tmp12_ = deja_dup_backend_file_mount_remote_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
					_data_->_tmp10_ = _data_->_tmp12_;
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						_g_object_unref0 (_data_->file);
						if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_FAILED)) {
							goto __catch6_g_io_error_failed;
						}
						goto __finally6;
					}
					_data_->success = _data_->_tmp10_;
				}
				_g_object_unref0 (_data_->file);
			}
		}
	}
	goto __finally6;
	__catch6_g_io_error_failed:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->err;
		_data_->_tmp14_ = FALSE;
		_data_->_tmp14_ = deja_dup_backend_file_is_being_mounted_error (_data_->self, _data_->_tmp13_);
		if (_data_->_tmp14_) {
			_data_->_state_ = 3;
			deja_dup_backend_file_delay (_data_->self, (guint) 1, deja_dup_backend_file_mount_file_ready, _data_);
			return FALSE;
			_state_3:
			deja_dup_backend_file_delay_finish (_data_->self, _data_->_res_);
			_data_->_state_ = 4;
			deja_dup_backend_file_mount_file (_data_->self, deja_dup_backend_file_mount_file_ready, _data_);
			return FALSE;
			_state_4:
			deja_dup_backend_file_mount_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_error_free0 (_data_->err);
				goto __finally6;
			}
			_g_error_free0 (_data_->err);
			_g_free0 (_data_->type);
			_g_object_unref0 (_data_->settings);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->err;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
			_data_->_inner_error_ = _data_->_tmp16_;
			_g_error_free0 (_data_->err);
			goto __finally6;
		}
		_g_error_free0 (_data_->err);
	}
	__finally6:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->type);
		_g_object_unref0 (_data_->settings);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = FALSE;
	_data_->_tmp17_ = _data_->success;
	if (_data_->_tmp17_) {
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = deja_dup_backend_file_get_file_from_settings ();
		_data_->gfile = _data_->_tmp18_;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->gfile;
		_data_->_state_ = 5;
		deja_dup_backend_file_check_for_volume_info (_data_->_tmp19_, deja_dup_backend_file_mount_file_ready, _data_);
		return FALSE;
		_state_5:
		deja_dup_backend_file_check_for_volume_info_finish (_data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->gfile);
			_g_free0 (_data_->type);
			_g_object_unref0 (_data_->settings);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->gfile;
			g_file_make_directory_with_parents (_data_->_tmp20_, NULL, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
					goto __catch7_g_io_error_exists;
				}
				goto __finally7;
			}
		}
		goto __finally7;
		__catch7_g_io_error_exists:
		{
			_data_->err2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_error_free0 (_data_->err2);
		}
		__finally7:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->gfile);
			_g_free0 (_data_->type);
			_g_object_unref0 (_data_->settings);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->gfile);
	}
	_data_->_tmp21_ = FALSE;
	_data_->_tmp21_ = _data_->success;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = NULL;
	g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "envp-ready", _data_->_tmp21_, _data_->_tmp22_, NULL);
	__g_list_free__g_free0_0 (_data_->_tmp22_);
	_g_free0 (_data_->type);
	_g_object_unref0 (_data_->settings);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void deja_dup_backend_file_mount_remote_data_free (gpointer _data) {
	DejaDupBackendFileMountRemoteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFileMountRemoteData, _data_);
}


static void deja_dup_backend_file_mount_remote (DejaDupBackendFile* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileMountRemoteData* _data_;
	DejaDupBackendFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	_data_ = g_slice_new0 (DejaDupBackendFileMountRemoteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_mount_remote);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_mount_remote_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	deja_dup_backend_file_mount_remote_co (_data_);
}


static gboolean deja_dup_backend_file_mount_remote_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	DejaDupBackendFileMountRemoteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		DejaDupBackendFile* self;
		self = _data2_->self;
		_g_main_loop_unref0 (_data2_->loop);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void ___lambda6_ (Block2Data* _data2_) {
	DejaDupBackendFile* self;
	DejaDupNetwork* _tmp0_ = NULL;
	DejaDupNetwork* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	self = _data2_->self;
	_tmp0_ = deja_dup_network_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_network_get_connected (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		GMainLoop* _tmp5_ = NULL;
		_tmp5_ = _data2_->loop;
		g_main_loop_quit (_tmp5_);
	}
}


static void ____lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda6_ (self);
}


static void deja_dup_backend_file_mount_remote_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileMountRemoteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_mount_remote_co (_data_);
}


static gboolean deja_dup_backend_file_mount_remote_co (DejaDupBackendFileMountRemoteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = deja_dup_network_get ();
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = deja_dup_network_get_connected (_data_->_tmp1_);
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = FALSE;
	_data_->_tmp4_ = !_data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp1_);
	if (_data_->_tmp4_) {
		_data_->_data2_ = g_slice_new0 (Block2Data);
		_data_->_data2_->_ref_count_ = 1;
		_data_->_data2_->self = g_object_ref (_data_->self);
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _ ("Backup location not available");
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _ ("Waiting for a network connection…");
		g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "pause-op", _data_->_tmp5_, _data_->_tmp6_);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_main_loop_new (NULL, FALSE);
		_data_->_data2_->loop = _data_->_tmp7_;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = deja_dup_network_get ();
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = 0UL;
		_data_->_tmp10_ = g_signal_connect_data ((GObject*) _data_->_tmp9_, "notify::connected", (GCallback) ____lambda6__g_object_notify, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
		_data_->_tmp11_ = 0UL;
		_data_->_tmp11_ = _data_->_tmp10_;
		_g_object_unref0 (_data_->_tmp9_);
		_data_->sigid = _data_->_tmp11_;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_data2_->loop;
		g_main_loop_run (_data_->_tmp12_);
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = deja_dup_network_get ();
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = 0UL;
		_data_->_tmp15_ = _data_->sigid;
		g_signal_handler_disconnect ((GObject*) _data_->_tmp14_, _data_->_tmp15_);
		_g_object_unref0 (_data_->_tmp14_);
		g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "pause-op", NULL, NULL);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
	}
	{
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->file;
		_data_->_state_ = 1;
		g_file_find_enclosing_mount_async (_data_->_tmp16_, G_PRIORITY_DEFAULT, NULL, deja_dup_backend_file_mount_remote_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_file_find_enclosing_mount_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error_);
		_data_->mount = _data_->_tmp17_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->mount;
		if (_data_->_tmp18_ != NULL) {
			_data_->result = TRUE;
			_g_object_unref0 (_data_->mount);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->mount);
	}
	goto __finally8;
	__catch8_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->e);
	}
	__finally8:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->file;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) _data_->self);
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_state_ = 2;
	g_file_mount_enclosing_volume (_data_->_tmp20_, G_MOUNT_MOUNT_NONE, _data_->_tmp22_, NULL, deja_dup_backend_file_mount_remote_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp23_ = FALSE;
	_data_->_tmp23_ = g_file_mount_enclosing_volume_finish (_data_->_tmp20_, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp19_ = _data_->_tmp23_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_tmp19_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void deja_dup_backend_file_mount_volume_data_free (gpointer _data) {
	DejaDupBackendFileMountVolumeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFileMountVolumeData, _data_);
}


static void deja_dup_backend_file_mount_volume (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileMountVolumeData* _data_;
	DejaDupBackendFile* _tmp0_ = NULL;
	_data_ = g_slice_new0 (DejaDupBackendFileMountVolumeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_mount_volume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_mount_volume_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_file_mount_volume_co (_data_);
}


static gboolean deja_dup_backend_file_mount_volume_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	DejaDupBackendFileMountVolumeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void deja_dup_backend_file_mount_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileMountVolumeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_mount_volume_co (_data_);
}


static gboolean deja_dup_backend_file_mount_volume_co (DejaDupBackendFileMountVolumeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	_data_->settings = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->settings;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_settings_get_string ((GSettings*) _data_->_tmp1_, DEJA_DUP_FILE_UUID_KEY);
	_data_->uuid = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->uuid;
	_data_->_state_ = 1;
	deja_dup_backend_file_wait_for_volume (_data_->self, _data_->_tmp3_, deja_dup_backend_file_mount_volume_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = deja_dup_backend_file_wait_for_volume_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->vol = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->uuid);
		_g_object_unref0 (_data_->settings);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->vol;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_volume_get_mount (_data_->_tmp5_);
	_data_->mount = _data_->_tmp6_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->mount;
	if (_data_->_tmp7_ != NULL) {
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->vol;
		deja_dup_backend_file_update_volume_info (_data_->_tmp8_);
		_data_->result = TRUE;
		_g_object_unref0 (_data_->mount);
		_g_object_unref0 (_data_->vol);
		_g_free0 (_data_->uuid);
		_g_object_unref0 (_data_->settings);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->vol;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) _data_->self);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_state_ = 2;
	g_volume_mount (_data_->_tmp9_, G_MOUNT_MOUNT_NONE, _data_->_tmp11_, NULL, deja_dup_backend_file_mount_volume_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp12_ = FALSE;
	_data_->_tmp12_ = g_volume_mount_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
	_data_->rv = _data_->_tmp12_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->mount);
		_g_object_unref0 (_data_->vol);
		_g_free0 (_data_->uuid);
		_g_object_unref0 (_data_->settings);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = FALSE;
	_data_->_tmp13_ = _data_->rv;
	if (_data_->_tmp13_) {
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->vol;
		deja_dup_backend_file_update_volume_info (_data_->_tmp14_);
	}
	_data_->result = _data_->rv;
	_g_object_unref0 (_data_->mount);
	_g_object_unref0 (_data_->vol);
	_g_free0 (_data_->uuid);
	_g_object_unref0 (_data_->settings);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->mount);
	_g_object_unref0 (_data_->vol);
	_g_free0 (_data_->uuid);
	_g_object_unref0 (_data_->settings);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GVolume* deja_dup_backend_file_find_volume_by_uuid (const gchar* uuid) {
	GVolume* result = NULL;
	GVolumeMonitor* mon = NULL;
	GVolumeMonitor* _tmp0_ = NULL;
	GVolumeMonitor* _tmp1_ = NULL;
	GList* vols = NULL;
	GVolumeMonitor* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = g_volume_monitor_get ();
	mon = _tmp0_;
	_tmp1_ = mon;
	g_object_ref ((GObject*) _tmp1_);
	_tmp2_ = mon;
	_tmp3_ = g_volume_monitor_get_volumes (_tmp2_);
	vols = _tmp3_;
	_tmp4_ = vols;
	{
		GList* v_collection = NULL;
		GList* v_it = NULL;
		v_collection = _tmp4_;
		for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
			GVolume* _tmp5_ = NULL;
			GVolume* v = NULL;
			_tmp5_ = _g_object_ref0 ((GVolume*) v_it->data);
			v = _tmp5_;
			{
				GVolume* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				_tmp6_ = v;
				_tmp7_ = g_volume_get_identifier (_tmp6_, G_VOLUME_IDENTIFIER_KIND_UUID);
				_tmp8_ = _tmp7_;
				_tmp9_ = uuid;
				_tmp10_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
				_g_free0 (_tmp8_);
				if (_tmp10_) {
					result = v;
					__g_list_free__g_object_unref0_0 (vols);
					_g_object_unref0 (mon);
					return result;
				}
				_g_object_unref0 (v);
			}
		}
	}
	result = NULL;
	__g_list_free__g_object_unref0_0 (vols);
	_g_object_unref0 (mon);
	return result;
}


static void deja_dup_backend_file_wait_for_volume_data_free (gpointer _data) {
	DejaDupBackendFileWaitForVolumeData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uuid);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFileWaitForVolumeData, _data_);
}


static void deja_dup_backend_file_wait_for_volume (DejaDupBackendFile* self, const gchar* uuid, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileWaitForVolumeData* _data_;
	DejaDupBackendFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (DejaDupBackendFileWaitForVolumeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_wait_for_volume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_wait_for_volume_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uuid;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->uuid);
	_data_->uuid = _tmp2_;
	deja_dup_backend_file_wait_for_volume_co (_data_);
}


static GVolume* deja_dup_backend_file_wait_for_volume_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error) {
	GVolume* result;
	DejaDupBackendFileWaitForVolumeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		DejaDupBackendFile* self;
		self = _data3_->self;
		_g_main_loop_unref0 (_data3_->loop);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void ___lambda5_ (Block3Data* _data3_, GVolumeMonitor* m, GVolume* v) {
	DejaDupBackendFile* self;
	GMainLoop* _tmp0_ = NULL;
	self = _data3_->self;
	g_return_if_fail (m != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = _data3_->loop;
	g_main_loop_quit (_tmp0_);
}


static void ____lambda5__g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	___lambda5_ (self, _sender, volume);
}


static void deja_dup_backend_file_wait_for_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileWaitForVolumeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_wait_for_volume_co (_data_);
}


static gboolean deja_dup_backend_file_wait_for_volume_co (DejaDupBackendFileWaitForVolumeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->uuid;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = deja_dup_backend_file_find_volume_by_uuid (_data_->_tmp0_);
	_data_->vol = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->vol;
	if (_data_->_tmp2_ == NULL) {
		_data_->_data3_ = g_slice_new0 (Block3Data);
		_data_->_data3_->_ref_count_ = 1;
		_data_->_data3_->self = g_object_ref (_data_->self);
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
		_data_->settings = _data_->_tmp3_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->settings;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_settings_get_string ((GSettings*) _data_->_tmp4_, DEJA_DUP_FILE_NAME_KEY);
		_data_->name = _data_->_tmp5_;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _ ("Backup location not available");
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _ ("Waiting for ‘%s’ to become connected…");
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->name;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_strdup_printf (_data_->_tmp7_, _data_->_tmp8_);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_tmp9_;
		g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "pause-op", _data_->_tmp6_, _data_->_tmp10_);
		_g_free0 (_data_->_tmp10_);
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = g_main_loop_new (NULL, FALSE);
		_data_->_data3_->loop = _data_->_tmp11_;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_volume_monitor_get ();
		_data_->mon = _data_->_tmp12_;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->mon;
		g_object_ref ((GObject*) _data_->_tmp13_);
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->mon;
		_data_->_tmp15_ = 0UL;
		_data_->_tmp15_ = g_signal_connect_data (_data_->_tmp14_, "volume-added", (GCallback) ____lambda5__g_volume_monitor_volume_added, block3_data_ref (_data_->_data3_), (GClosureNotify) block3_data_unref, 0);
		_data_->sigid = _data_->_tmp15_;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->_data3_->loop;
		g_main_loop_run (_data_->_tmp16_);
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->mon;
		_data_->_tmp18_ = 0UL;
		_data_->_tmp18_ = _data_->sigid;
		g_signal_handler_disconnect ((GObject*) _data_->_tmp17_, _data_->_tmp18_);
		g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "pause-op", NULL, NULL);
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->uuid;
		_data_->_state_ = 1;
		deja_dup_backend_file_wait_for_volume (_data_->self, _data_->_tmp20_, deja_dup_backend_file_wait_for_volume_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = deja_dup_backend_file_wait_for_volume_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp19_ = _data_->_tmp21_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->mon);
			_g_free0 (_data_->name);
			_g_object_unref0 (_data_->settings);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			_g_object_unref0 (_data_->vol);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->_tmp19_;
		_data_->_tmp19_ = NULL;
		_data_->result = _data_->_tmp22_;
		_g_object_unref0 (_data_->_tmp19_);
		_g_object_unref0 (_data_->mon);
		_g_free0 (_data_->name);
		_g_object_unref0 (_data_->settings);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		_g_object_unref0 (_data_->vol);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->vol;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->vol);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void deja_dup_backend_file_real_get_space_data_free (gpointer _data) {
	DejaDupBackendFileGetSpaceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFileGetSpaceData, _data_);
}


static void deja_dup_backend_file_real_get_space (DejaDupBackend* base, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFile * self;
	DejaDupBackendFileGetSpaceData* _data_;
	DejaDupBackendFile* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (DejaDupBackendFile*) base;
	_data_ = g_slice_new0 (DejaDupBackendFileGetSpaceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_real_get_space);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_real_get_space_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = free;
	_data_->free = _tmp1_;
	deja_dup_backend_file_real_get_space_co (_data_);
}


static guint64 deja_dup_backend_file_real_get_space_finish (DejaDupBackend* base, GAsyncResult* _res_) {
	guint64 result;
	DejaDupBackendFileGetSpaceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void deja_dup_backend_file_get_space_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileGetSpaceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_real_get_space_co (_data_);
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_ = NULL;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static gboolean deja_dup_backend_file_real_get_space_co (DejaDupBackendFileGetSpaceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->free;
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = G_FILE_ATTRIBUTE_FILESYSTEM_FREE;
	} else {
		_data_->_tmp0_ = G_FILE_ATTRIBUTE_FILESYSTEM_SIZE;
	}
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_strdup (_data_->_tmp0_);
	_data_->attr = _data_->_tmp2_;
	{
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = deja_dup_backend_file_get_file_from_settings ();
		_data_->file = _data_->_tmp3_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->file;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->attr;
		_data_->_state_ = 1;
		g_file_query_filesystem_info_async (_data_->_tmp4_, _data_->_tmp5_, G_PRIORITY_DEFAULT, NULL, deja_dup_backend_file_get_space_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = g_file_query_filesystem_info_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
		_data_->info = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->file);
			goto __catch9_g_error;
		}
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->info;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->attr;
		_data_->_tmp9_ = FALSE;
		_data_->_tmp9_ = g_file_info_has_attribute (_data_->_tmp7_, _data_->_tmp8_);
		if (!_data_->_tmp9_) {
			_data_->_tmp10_ = 0ULL;
			_data_->_tmp10_ = deja_dup_backend_INFINITE_SPACE;
			_data_->result = _data_->_tmp10_;
			_g_object_unref0 (_data_->info);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->attr);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->info;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->attr;
		_data_->_tmp13_ = 0ULL;
		_data_->_tmp13_ = g_file_info_get_attribute_uint64 (_data_->_tmp11_, _data_->_tmp12_);
		_data_->space = _data_->_tmp13_;
		_data_->_tmp16_ = FALSE;
		_data_->_tmp16_ = deja_dup_in_testing_mode ();
		if (_data_->_tmp16_) {
			_data_->_tmp17_ = FALSE;
			_data_->_tmp17_ = _data_->free;
			_data_->_tmp15_ = _data_->_tmp17_;
		} else {
			_data_->_tmp15_ = FALSE;
		}
		if (_data_->_tmp15_) {
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = g_getenv ("DEJA_DUP_TEST_SPACE_FREE");
			_data_->_tmp14_ = _data_->_tmp18_ != NULL;
		} else {
			_data_->_tmp14_ = FALSE;
		}
		if (_data_->_tmp14_) {
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = g_getenv ("DEJA_DUP_TEST_SPACE_FREE");
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = g_strdup (_data_->_tmp19_);
			_data_->free_str = _data_->_tmp20_;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->free_str;
			_data_->_tmp22_ = NULL;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->_tmp22_ = g_strsplit (_data_->_tmp21_, ";", 0);
			_data_->free_list_length1 = 0;
			_data_->_free_list_size_ = 0;
			_data_->free_list = _data_->_tmp23_;
			_data_->free_list_length1 = _vala_array_length (_data_->_tmp22_);
			_data_->_free_list_size_ = _data_->free_list_length1;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24__length1 = 0;
			_data_->_tmp24_ = _data_->free_list;
			_data_->_tmp24__length1 = _data_->free_list_length1;
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->_tmp24_[0];
			_data_->_tmp26_ = 0ULL;
			_data_->_tmp26_ = uint64_parse (_data_->_tmp25_);
			_data_->space = _data_->_tmp26_;
			_data_->_tmp27_ = NULL;
			_data_->_tmp27__length1 = 0;
			_data_->_tmp27_ = _data_->free_list;
			_data_->_tmp27__length1 = _data_->free_list_length1;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = _data_->_tmp27_[1];
			if (_data_->_tmp28_ != NULL) {
				_data_->_tmp29_ = NULL;
				_data_->_tmp29__length1 = 0;
				_data_->_tmp29_ = _data_->free_list;
				_data_->_tmp29__length1 = _data_->free_list_length1;
				_data_->_tmp30_ = NULL;
				_data_->_tmp30__length1 = 0;
				_data_->_tmp30_ = _data_->free_list;
				_data_->_tmp30__length1 = _data_->free_list_length1;
				_data_->_tmp31_ = NULL;
				_data_->_tmp31_ = _vala_g_strjoinv (";", _data_->_tmp29_ + 1, _data_->_tmp30__length1 - 1);
				_data_->_tmp32_ = NULL;
				_data_->_tmp32_ = _data_->_tmp31_;
				g_setenv ("DEJA_DUP_TEST_SPACE_FREE", _data_->_tmp32_, TRUE);
				_g_free0 (_data_->_tmp32_);
			}
			_data_->free_list = (_vala_array_free (_data_->free_list, _data_->free_list_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_data_->free_str);
		}
		_data_->_tmp33_ = 0ULL;
		_data_->_tmp33_ = _data_->space;
		_data_->_tmp34_ = 0ULL;
		_data_->_tmp34_ = deja_dup_backend_INFINITE_SPACE;
		if (_data_->_tmp33_ == _data_->_tmp34_) {
			_data_->_tmp35_ = 0ULL;
			_data_->_tmp35_ = _data_->space;
			_data_->result = _data_->_tmp35_ - 1;
			_g_object_unref0 (_data_->info);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->attr);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->result = _data_->space;
			_g_object_unref0 (_data_->info);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->attr);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->file);
	}
	goto __finally9;
	__catch9_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _data_->e;
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = _data_->_tmp36_->message;
		g_warning ("BackendFile.vala:487: %s\n", _data_->_tmp37_);
		_data_->_tmp38_ = 0ULL;
		_data_->_tmp38_ = deja_dup_backend_INFINITE_SPACE;
		_data_->result = _data_->_tmp38_;
		_g_error_free0 (_data_->e);
		_g_free0 (_data_->attr);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally9:
	_g_free0 (_data_->attr);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
	g_clear_error (&_data_->_inner_error_);
	return FALSE;
	_g_free0 (_data_->attr);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean deja_dup_backend_file_real_space_can_be_infinite (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	gboolean result = FALSE;
	self = (DejaDupBackendFile*) base;
	result = FALSE;
	return result;
}


DejaDupBackendFile* deja_dup_backend_file_construct (GType object_type) {
	DejaDupBackendFile * self = NULL;
	self = (DejaDupBackendFile*) deja_dup_backend_construct (object_type);
	return self;
}


DejaDupBackendFile* deja_dup_backend_file_new (void) {
	return deja_dup_backend_file_construct (DEJA_DUP_TYPE_BACKEND_FILE);
}


static void deja_dup_backend_file_class_init (DejaDupBackendFileClass * klass) {
	deja_dup_backend_file_parent_class = g_type_class_peek_parent (klass);
	((DejaDupBackendClass *) klass)->clone = deja_dup_backend_file_real_clone;
	((DejaDupBackendClass *) klass)->get_location = deja_dup_backend_file_real_get_location;
	((DejaDupBackendClass *) klass)->get_location_pretty = deja_dup_backend_file_real_get_location_pretty;
	((DejaDupBackendClass *) klass)->is_native = deja_dup_backend_file_real_is_native;
	((DejaDupBackendClass *) klass)->is_ready = deja_dup_backend_file_real_is_ready;
	((DejaDupBackendClass *) klass)->is_ready_finish = deja_dup_backend_file_real_is_ready_finish;
	((DejaDupBackendClass *) klass)->get_icon = deja_dup_backend_file_real_get_icon;
	((DejaDupBackendClass *) klass)->add_argv = deja_dup_backend_file_real_add_argv;
	((DejaDupBackendClass *) klass)->get_envp = deja_dup_backend_file_real_get_envp;
	((DejaDupBackendClass *) klass)->get_envp_finish = deja_dup_backend_file_real_get_envp_finish;
	((DejaDupBackendClass *) klass)->get_space = deja_dup_backend_file_real_get_space;
	((DejaDupBackendClass *) klass)->get_space_finish = deja_dup_backend_file_real_get_space_finish;
	((DejaDupBackendClass *) klass)->space_can_be_infinite = deja_dup_backend_file_real_space_can_be_infinite;
}


static void deja_dup_backend_file_instance_init (DejaDupBackendFile * self) {
}


GType deja_dup_backend_file_get_type (void) {
	static volatile gsize deja_dup_backend_file_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_backend_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendFile), 0, (GInstanceInitFunc) deja_dup_backend_file_instance_init, NULL };
		GType deja_dup_backend_file_type_id;
		deja_dup_backend_file_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendFile", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_backend_file_type_id__volatile, deja_dup_backend_file_type_id);
	}
	return deja_dup_backend_file_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



