/*
    Copyright (C) 2011 Sebastian Pancratz

    This file is part of FLINT.

    FLINT is free software: you can redistribute it and/or modify it under
    the terms of the GNU Lesser General Public License (LGPL) as published
    by the Free Software Foundation; either version 2.1 of the License, or
    (at your option) any later version.  See <https://www.gnu.org/licenses/>.
*/

#include "fmpz_mat.h"
#include "padic_mat.h"

void padic_mat_one(padic_mat_t A)
{
    if (padic_mat_prec(A) > 0)
    {
        fmpz_mat_one(padic_mat(A));
        A->val = 0;
    }
    else
    {
        fmpz_mat_zero(padic_mat(A));
        A->val = 0;
    }
}

