// Copyright (C) 2020-2024 Free Software Foundation, Inc.

// This file is part of GCC.

// GCC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3, or (at your option) any later
// version.

// GCC is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.

// You should have received a copy of the GNU General Public License
// along with GCC; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

#include "rust-system.h"

namespace Rust {

const uint32_t NUM_ALPHABETIC_RANGES = 1141;
const uint32_t NUM_NUMERIC_CODEPOINTS = 1831;

const std::map<uint32_t, std::vector<uint32_t>> DECOMPOSITION_MAP = {
  // clang-format off
  {0x00c0, {0x0041, 0x0300, }},
  {0x00c1, {0x0041, 0x0301, }},
  {0x00c2, {0x0041, 0x0302, }},
  {0x00c3, {0x0041, 0x0303, }},
  {0x00c4, {0x0041, 0x0308, }},
  {0x00c5, {0x0041, 0x030a, }},
  {0x00c7, {0x0043, 0x0327, }},
  {0x00c8, {0x0045, 0x0300, }},
  {0x00c9, {0x0045, 0x0301, }},
  {0x00ca, {0x0045, 0x0302, }},
  {0x00cb, {0x0045, 0x0308, }},
  {0x00cc, {0x0049, 0x0300, }},
  {0x00cd, {0x0049, 0x0301, }},
  {0x00ce, {0x0049, 0x0302, }},
  {0x00cf, {0x0049, 0x0308, }},
  {0x00d1, {0x004e, 0x0303, }},
  {0x00d2, {0x004f, 0x0300, }},
  {0x00d3, {0x004f, 0x0301, }},
  {0x00d4, {0x004f, 0x0302, }},
  {0x00d5, {0x004f, 0x0303, }},
  {0x00d6, {0x004f, 0x0308, }},
  {0x00d9, {0x0055, 0x0300, }},
  {0x00da, {0x0055, 0x0301, }},
  {0x00db, {0x0055, 0x0302, }},
  {0x00dc, {0x0055, 0x0308, }},
  {0x00dd, {0x0059, 0x0301, }},
  {0x00e0, {0x0061, 0x0300, }},
  {0x00e1, {0x0061, 0x0301, }},
  {0x00e2, {0x0061, 0x0302, }},
  {0x00e3, {0x0061, 0x0303, }},
  {0x00e4, {0x0061, 0x0308, }},
  {0x00e5, {0x0061, 0x030a, }},
  {0x00e7, {0x0063, 0x0327, }},
  {0x00e8, {0x0065, 0x0300, }},
  {0x00e9, {0x0065, 0x0301, }},
  {0x00ea, {0x0065, 0x0302, }},
  {0x00eb, {0x0065, 0x0308, }},
  {0x00ec, {0x0069, 0x0300, }},
  {0x00ed, {0x0069, 0x0301, }},
  {0x00ee, {0x0069, 0x0302, }},
  {0x00ef, {0x0069, 0x0308, }},
  {0x00f1, {0x006e, 0x0303, }},
  {0x00f2, {0x006f, 0x0300, }},
  {0x00f3, {0x006f, 0x0301, }},
  {0x00f4, {0x006f, 0x0302, }},
  {0x00f5, {0x006f, 0x0303, }},
  {0x00f6, {0x006f, 0x0308, }},
  {0x00f9, {0x0075, 0x0300, }},
  {0x00fa, {0x0075, 0x0301, }},
  {0x00fb, {0x0075, 0x0302, }},
  {0x00fc, {0x0075, 0x0308, }},
  {0x00fd, {0x0079, 0x0301, }},
  {0x00ff, {0x0079, 0x0308, }},
  {0x0100, {0x0041, 0x0304, }},
  {0x0101, {0x0061, 0x0304, }},
  {0x0102, {0x0041, 0x0306, }},
  {0x0103, {0x0061, 0x0306, }},
  {0x0104, {0x0041, 0x0328, }},
  {0x0105, {0x0061, 0x0328, }},
  {0x0106, {0x0043, 0x0301, }},
  {0x0107, {0x0063, 0x0301, }},
  {0x0108, {0x0043, 0x0302, }},
  {0x0109, {0x0063, 0x0302, }},
  {0x010a, {0x0043, 0x0307, }},
  {0x010b, {0x0063, 0x0307, }},
  {0x010c, {0x0043, 0x030c, }},
  {0x010d, {0x0063, 0x030c, }},
  {0x010e, {0x0044, 0x030c, }},
  {0x010f, {0x0064, 0x030c, }},
  {0x0112, {0x0045, 0x0304, }},
  {0x0113, {0x0065, 0x0304, }},
  {0x0114, {0x0045, 0x0306, }},
  {0x0115, {0x0065, 0x0306, }},
  {0x0116, {0x0045, 0x0307, }},
  {0x0117, {0x0065, 0x0307, }},
  {0x0118, {0x0045, 0x0328, }},
  {0x0119, {0x0065, 0x0328, }},
  {0x011a, {0x0045, 0x030c, }},
  {0x011b, {0x0065, 0x030c, }},
  {0x011c, {0x0047, 0x0302, }},
  {0x011d, {0x0067, 0x0302, }},
  {0x011e, {0x0047, 0x0306, }},
  {0x011f, {0x0067, 0x0306, }},
  {0x0120, {0x0047, 0x0307, }},
  {0x0121, {0x0067, 0x0307, }},
  {0x0122, {0x0047, 0x0327, }},
  {0x0123, {0x0067, 0x0327, }},
  {0x0124, {0x0048, 0x0302, }},
  {0x0125, {0x0068, 0x0302, }},
  {0x0128, {0x0049, 0x0303, }},
  {0x0129, {0x0069, 0x0303, }},
  {0x012a, {0x0049, 0x0304, }},
  {0x012b, {0x0069, 0x0304, }},
  {0x012c, {0x0049, 0x0306, }},
  {0x012d, {0x0069, 0x0306, }},
  {0x012e, {0x0049, 0x0328, }},
  {0x012f, {0x0069, 0x0328, }},
  {0x0130, {0x0049, 0x0307, }},
  {0x0134, {0x004a, 0x0302, }},
  {0x0135, {0x006a, 0x0302, }},
  {0x0136, {0x004b, 0x0327, }},
  {0x0137, {0x006b, 0x0327, }},
  {0x0139, {0x004c, 0x0301, }},
  {0x013a, {0x006c, 0x0301, }},
  {0x013b, {0x004c, 0x0327, }},
  {0x013c, {0x006c, 0x0327, }},
  {0x013d, {0x004c, 0x030c, }},
  {0x013e, {0x006c, 0x030c, }},
  {0x0143, {0x004e, 0x0301, }},
  {0x0144, {0x006e, 0x0301, }},
  {0x0145, {0x004e, 0x0327, }},
  {0x0146, {0x006e, 0x0327, }},
  {0x0147, {0x004e, 0x030c, }},
  {0x0148, {0x006e, 0x030c, }},
  {0x014c, {0x004f, 0x0304, }},
  {0x014d, {0x006f, 0x0304, }},
  {0x014e, {0x004f, 0x0306, }},
  {0x014f, {0x006f, 0x0306, }},
  {0x0150, {0x004f, 0x030b, }},
  {0x0151, {0x006f, 0x030b, }},
  {0x0154, {0x0052, 0x0301, }},
  {0x0155, {0x0072, 0x0301, }},
  {0x0156, {0x0052, 0x0327, }},
  {0x0157, {0x0072, 0x0327, }},
  {0x0158, {0x0052, 0x030c, }},
  {0x0159, {0x0072, 0x030c, }},
  {0x015a, {0x0053, 0x0301, }},
  {0x015b, {0x0073, 0x0301, }},
  {0x015c, {0x0053, 0x0302, }},
  {0x015d, {0x0073, 0x0302, }},
  {0x015e, {0x0053, 0x0327, }},
  {0x015f, {0x0073, 0x0327, }},
  {0x0160, {0x0053, 0x030c, }},
  {0x0161, {0x0073, 0x030c, }},
  {0x0162, {0x0054, 0x0327, }},
  {0x0163, {0x0074, 0x0327, }},
  {0x0164, {0x0054, 0x030c, }},
  {0x0165, {0x0074, 0x030c, }},
  {0x0168, {0x0055, 0x0303, }},
  {0x0169, {0x0075, 0x0303, }},
  {0x016a, {0x0055, 0x0304, }},
  {0x016b, {0x0075, 0x0304, }},
  {0x016c, {0x0055, 0x0306, }},
  {0x016d, {0x0075, 0x0306, }},
  {0x016e, {0x0055, 0x030a, }},
  {0x016f, {0x0075, 0x030a, }},
  {0x0170, {0x0055, 0x030b, }},
  {0x0171, {0x0075, 0x030b, }},
  {0x0172, {0x0055, 0x0328, }},
  {0x0173, {0x0075, 0x0328, }},
  {0x0174, {0x0057, 0x0302, }},
  {0x0175, {0x0077, 0x0302, }},
  {0x0176, {0x0059, 0x0302, }},
  {0x0177, {0x0079, 0x0302, }},
  {0x0178, {0x0059, 0x0308, }},
  {0x0179, {0x005a, 0x0301, }},
  {0x017a, {0x007a, 0x0301, }},
  {0x017b, {0x005a, 0x0307, }},
  {0x017c, {0x007a, 0x0307, }},
  {0x017d, {0x005a, 0x030c, }},
  {0x017e, {0x007a, 0x030c, }},
  {0x01a0, {0x004f, 0x031b, }},
  {0x01a1, {0x006f, 0x031b, }},
  {0x01af, {0x0055, 0x031b, }},
  {0x01b0, {0x0075, 0x031b, }},
  {0x01cd, {0x0041, 0x030c, }},
  {0x01ce, {0x0061, 0x030c, }},
  {0x01cf, {0x0049, 0x030c, }},
  {0x01d0, {0x0069, 0x030c, }},
  {0x01d1, {0x004f, 0x030c, }},
  {0x01d2, {0x006f, 0x030c, }},
  {0x01d3, {0x0055, 0x030c, }},
  {0x01d4, {0x0075, 0x030c, }},
  {0x01d5, {0x00dc, 0x0304, }},
  {0x01d6, {0x00fc, 0x0304, }},
  {0x01d7, {0x00dc, 0x0301, }},
  {0x01d8, {0x00fc, 0x0301, }},
  {0x01d9, {0x00dc, 0x030c, }},
  {0x01da, {0x00fc, 0x030c, }},
  {0x01db, {0x00dc, 0x0300, }},
  {0x01dc, {0x00fc, 0x0300, }},
  {0x01de, {0x00c4, 0x0304, }},
  {0x01df, {0x00e4, 0x0304, }},
  {0x01e0, {0x0226, 0x0304, }},
  {0x01e1, {0x0227, 0x0304, }},
  {0x01e2, {0x00c6, 0x0304, }},
  {0x01e3, {0x00e6, 0x0304, }},
  {0x01e6, {0x0047, 0x030c, }},
  {0x01e7, {0x0067, 0x030c, }},
  {0x01e8, {0x004b, 0x030c, }},
  {0x01e9, {0x006b, 0x030c, }},
  {0x01ea, {0x004f, 0x0328, }},
  {0x01eb, {0x006f, 0x0328, }},
  {0x01ec, {0x01ea, 0x0304, }},
  {0x01ed, {0x01eb, 0x0304, }},
  {0x01ee, {0x01b7, 0x030c, }},
  {0x01ef, {0x0292, 0x030c, }},
  {0x01f0, {0x006a, 0x030c, }},
  {0x01f4, {0x0047, 0x0301, }},
  {0x01f5, {0x0067, 0x0301, }},
  {0x01f8, {0x004e, 0x0300, }},
  {0x01f9, {0x006e, 0x0300, }},
  {0x01fa, {0x00c5, 0x0301, }},
  {0x01fb, {0x00e5, 0x0301, }},
  {0x01fc, {0x00c6, 0x0301, }},
  {0x01fd, {0x00e6, 0x0301, }},
  {0x01fe, {0x00d8, 0x0301, }},
  {0x01ff, {0x00f8, 0x0301, }},
  {0x0200, {0x0041, 0x030f, }},
  {0x0201, {0x0061, 0x030f, }},
  {0x0202, {0x0041, 0x0311, }},
  {0x0203, {0x0061, 0x0311, }},
  {0x0204, {0x0045, 0x030f, }},
  {0x0205, {0x0065, 0x030f, }},
  {0x0206, {0x0045, 0x0311, }},
  {0x0207, {0x0065, 0x0311, }},
  {0x0208, {0x0049, 0x030f, }},
  {0x0209, {0x0069, 0x030f, }},
  {0x020a, {0x0049, 0x0311, }},
  {0x020b, {0x0069, 0x0311, }},
  {0x020c, {0x004f, 0x030f, }},
  {0x020d, {0x006f, 0x030f, }},
  {0x020e, {0x004f, 0x0311, }},
  {0x020f, {0x006f, 0x0311, }},
  {0x0210, {0x0052, 0x030f, }},
  {0x0211, {0x0072, 0x030f, }},
  {0x0212, {0x0052, 0x0311, }},
  {0x0213, {0x0072, 0x0311, }},
  {0x0214, {0x0055, 0x030f, }},
  {0x0215, {0x0075, 0x030f, }},
  {0x0216, {0x0055, 0x0311, }},
  {0x0217, {0x0075, 0x0311, }},
  {0x0218, {0x0053, 0x0326, }},
  {0x0219, {0x0073, 0x0326, }},
  {0x021a, {0x0054, 0x0326, }},
  {0x021b, {0x0074, 0x0326, }},
  {0x021e, {0x0048, 0x030c, }},
  {0x021f, {0x0068, 0x030c, }},
  {0x0226, {0x0041, 0x0307, }},
  {0x0227, {0x0061, 0x0307, }},
  {0x0228, {0x0045, 0x0327, }},
  {0x0229, {0x0065, 0x0327, }},
  {0x022a, {0x00d6, 0x0304, }},
  {0x022b, {0x00f6, 0x0304, }},
  {0x022c, {0x00d5, 0x0304, }},
  {0x022d, {0x00f5, 0x0304, }},
  {0x022e, {0x004f, 0x0307, }},
  {0x022f, {0x006f, 0x0307, }},
  {0x0230, {0x022e, 0x0304, }},
  {0x0231, {0x022f, 0x0304, }},
  {0x0232, {0x0059, 0x0304, }},
  {0x0233, {0x0079, 0x0304, }},
  {0x0340, {0x0300, }},
  {0x0341, {0x0301, }},
  {0x0343, {0x0313, }},
  {0x0344, {0x0308, 0x0301, }},
  {0x0374, {0x02b9, }},
  {0x037e, {0x003b, }},
  {0x0385, {0x00a8, 0x0301, }},
  {0x0386, {0x0391, 0x0301, }},
  {0x0387, {0x00b7, }},
  {0x0388, {0x0395, 0x0301, }},
  {0x0389, {0x0397, 0x0301, }},
  {0x038a, {0x0399, 0x0301, }},
  {0x038c, {0x039f, 0x0301, }},
  {0x038e, {0x03a5, 0x0301, }},
  {0x038f, {0x03a9, 0x0301, }},
  {0x0390, {0x03ca, 0x0301, }},
  {0x03aa, {0x0399, 0x0308, }},
  {0x03ab, {0x03a5, 0x0308, }},
  {0x03ac, {0x03b1, 0x0301, }},
  {0x03ad, {0x03b5, 0x0301, }},
  {0x03ae, {0x03b7, 0x0301, }},
  {0x03af, {0x03b9, 0x0301, }},
  {0x03b0, {0x03cb, 0x0301, }},
  {0x03ca, {0x03b9, 0x0308, }},
  {0x03cb, {0x03c5, 0x0308, }},
  {0x03cc, {0x03bf, 0x0301, }},
  {0x03cd, {0x03c5, 0x0301, }},
  {0x03ce, {0x03c9, 0x0301, }},
  {0x03d3, {0x03d2, 0x0301, }},
  {0x03d4, {0x03d2, 0x0308, }},
  {0x0400, {0x0415, 0x0300, }},
  {0x0401, {0x0415, 0x0308, }},
  {0x0403, {0x0413, 0x0301, }},
  {0x0407, {0x0406, 0x0308, }},
  {0x040c, {0x041a, 0x0301, }},
  {0x040d, {0x0418, 0x0300, }},
  {0x040e, {0x0423, 0x0306, }},
  {0x0419, {0x0418, 0x0306, }},
  {0x0439, {0x0438, 0x0306, }},
  {0x0450, {0x0435, 0x0300, }},
  {0x0451, {0x0435, 0x0308, }},
  {0x0453, {0x0433, 0x0301, }},
  {0x0457, {0x0456, 0x0308, }},
  {0x045c, {0x043a, 0x0301, }},
  {0x045d, {0x0438, 0x0300, }},
  {0x045e, {0x0443, 0x0306, }},
  {0x0476, {0x0474, 0x030f, }},
  {0x0477, {0x0475, 0x030f, }},
  {0x04c1, {0x0416, 0x0306, }},
  {0x04c2, {0x0436, 0x0306, }},
  {0x04d0, {0x0410, 0x0306, }},
  {0x04d1, {0x0430, 0x0306, }},
  {0x04d2, {0x0410, 0x0308, }},
  {0x04d3, {0x0430, 0x0308, }},
  {0x04d6, {0x0415, 0x0306, }},
  {0x04d7, {0x0435, 0x0306, }},
  {0x04da, {0x04d8, 0x0308, }},
  {0x04db, {0x04d9, 0x0308, }},
  {0x04dc, {0x0416, 0x0308, }},
  {0x04dd, {0x0436, 0x0308, }},
  {0x04de, {0x0417, 0x0308, }},
  {0x04df, {0x0437, 0x0308, }},
  {0x04e2, {0x0418, 0x0304, }},
  {0x04e3, {0x0438, 0x0304, }},
  {0x04e4, {0x0418, 0x0308, }},
  {0x04e5, {0x0438, 0x0308, }},
  {0x04e6, {0x041e, 0x0308, }},
  {0x04e7, {0x043e, 0x0308, }},
  {0x04ea, {0x04e8, 0x0308, }},
  {0x04eb, {0x04e9, 0x0308, }},
  {0x04ec, {0x042d, 0x0308, }},
  {0x04ed, {0x044d, 0x0308, }},
  {0x04ee, {0x0423, 0x0304, }},
  {0x04ef, {0x0443, 0x0304, }},
  {0x04f0, {0x0423, 0x0308, }},
  {0x04f1, {0x0443, 0x0308, }},
  {0x04f2, {0x0423, 0x030b, }},
  {0x04f3, {0x0443, 0x030b, }},
  {0x04f4, {0x0427, 0x0308, }},
  {0x04f5, {0x0447, 0x0308, }},
  {0x04f8, {0x042b, 0x0308, }},
  {0x04f9, {0x044b, 0x0308, }},
  {0x0622, {0x0627, 0x0653, }},
  {0x0623, {0x0627, 0x0654, }},
  {0x0624, {0x0648, 0x0654, }},
  {0x0625, {0x0627, 0x0655, }},
  {0x0626, {0x064a, 0x0654, }},
  {0x06c0, {0x06d5, 0x0654, }},
  {0x06c2, {0x06c1, 0x0654, }},
  {0x06d3, {0x06d2, 0x0654, }},
  {0x0929, {0x0928, 0x093c, }},
  {0x0931, {0x0930, 0x093c, }},
  {0x0934, {0x0933, 0x093c, }},
  {0x0958, {0x0915, 0x093c, }},
  {0x0959, {0x0916, 0x093c, }},
  {0x095a, {0x0917, 0x093c, }},
  {0x095b, {0x091c, 0x093c, }},
  {0x095c, {0x0921, 0x093c, }},
  {0x095d, {0x0922, 0x093c, }},
  {0x095e, {0x092b, 0x093c, }},
  {0x095f, {0x092f, 0x093c, }},
  {0x09cb, {0x09c7, 0x09be, }},
  {0x09cc, {0x09c7, 0x09d7, }},
  {0x09dc, {0x09a1, 0x09bc, }},
  {0x09dd, {0x09a2, 0x09bc, }},
  {0x09df, {0x09af, 0x09bc, }},
  {0x0a33, {0x0a32, 0x0a3c, }},
  {0x0a36, {0x0a38, 0x0a3c, }},
  {0x0a59, {0x0a16, 0x0a3c, }},
  {0x0a5a, {0x0a17, 0x0a3c, }},
  {0x0a5b, {0x0a1c, 0x0a3c, }},
  {0x0a5e, {0x0a2b, 0x0a3c, }},
  {0x0b48, {0x0b47, 0x0b56, }},
  {0x0b4b, {0x0b47, 0x0b3e, }},
  {0x0b4c, {0x0b47, 0x0b57, }},
  {0x0b5c, {0x0b21, 0x0b3c, }},
  {0x0b5d, {0x0b22, 0x0b3c, }},
  {0x0b94, {0x0b92, 0x0bd7, }},
  {0x0bca, {0x0bc6, 0x0bbe, }},
  {0x0bcb, {0x0bc7, 0x0bbe, }},
  {0x0bcc, {0x0bc6, 0x0bd7, }},
  {0x0c48, {0x0c46, 0x0c56, }},
  {0x0cc0, {0x0cbf, 0x0cd5, }},
  {0x0cc7, {0x0cc6, 0x0cd5, }},
  {0x0cc8, {0x0cc6, 0x0cd6, }},
  {0x0cca, {0x0cc6, 0x0cc2, }},
  {0x0ccb, {0x0cca, 0x0cd5, }},
  {0x0d4a, {0x0d46, 0x0d3e, }},
  {0x0d4b, {0x0d47, 0x0d3e, }},
  {0x0d4c, {0x0d46, 0x0d57, }},
  {0x0dda, {0x0dd9, 0x0dca, }},
  {0x0ddc, {0x0dd9, 0x0dcf, }},
  {0x0ddd, {0x0ddc, 0x0dca, }},
  {0x0dde, {0x0dd9, 0x0ddf, }},
  {0x0f43, {0x0f42, 0x0fb7, }},
  {0x0f4d, {0x0f4c, 0x0fb7, }},
  {0x0f52, {0x0f51, 0x0fb7, }},
  {0x0f57, {0x0f56, 0x0fb7, }},
  {0x0f5c, {0x0f5b, 0x0fb7, }},
  {0x0f69, {0x0f40, 0x0fb5, }},
  {0x0f73, {0x0f71, 0x0f72, }},
  {0x0f75, {0x0f71, 0x0f74, }},
  {0x0f76, {0x0fb2, 0x0f80, }},
  {0x0f78, {0x0fb3, 0x0f80, }},
  {0x0f81, {0x0f71, 0x0f80, }},
  {0x0f93, {0x0f92, 0x0fb7, }},
  {0x0f9d, {0x0f9c, 0x0fb7, }},
  {0x0fa2, {0x0fa1, 0x0fb7, }},
  {0x0fa7, {0x0fa6, 0x0fb7, }},
  {0x0fac, {0x0fab, 0x0fb7, }},
  {0x0fb9, {0x0f90, 0x0fb5, }},
  {0x1026, {0x1025, 0x102e, }},
  {0x1b06, {0x1b05, 0x1b35, }},
  {0x1b08, {0x1b07, 0x1b35, }},
  {0x1b0a, {0x1b09, 0x1b35, }},
  {0x1b0c, {0x1b0b, 0x1b35, }},
  {0x1b0e, {0x1b0d, 0x1b35, }},
  {0x1b12, {0x1b11, 0x1b35, }},
  {0x1b3b, {0x1b3a, 0x1b35, }},
  {0x1b3d, {0x1b3c, 0x1b35, }},
  {0x1b40, {0x1b3e, 0x1b35, }},
  {0x1b41, {0x1b3f, 0x1b35, }},
  {0x1b43, {0x1b42, 0x1b35, }},
  {0x1e00, {0x0041, 0x0325, }},
  {0x1e01, {0x0061, 0x0325, }},
  {0x1e02, {0x0042, 0x0307, }},
  {0x1e03, {0x0062, 0x0307, }},
  {0x1e04, {0x0042, 0x0323, }},
  {0x1e05, {0x0062, 0x0323, }},
  {0x1e06, {0x0042, 0x0331, }},
  {0x1e07, {0x0062, 0x0331, }},
  {0x1e08, {0x00c7, 0x0301, }},
  {0x1e09, {0x00e7, 0x0301, }},
  {0x1e0a, {0x0044, 0x0307, }},
  {0x1e0b, {0x0064, 0x0307, }},
  {0x1e0c, {0x0044, 0x0323, }},
  {0x1e0d, {0x0064, 0x0323, }},
  {0x1e0e, {0x0044, 0x0331, }},
  {0x1e0f, {0x0064, 0x0331, }},
  {0x1e10, {0x0044, 0x0327, }},
  {0x1e11, {0x0064, 0x0327, }},
  {0x1e12, {0x0044, 0x032d, }},
  {0x1e13, {0x0064, 0x032d, }},
  {0x1e14, {0x0112, 0x0300, }},
  {0x1e15, {0x0113, 0x0300, }},
  {0x1e16, {0x0112, 0x0301, }},
  {0x1e17, {0x0113, 0x0301, }},
  {0x1e18, {0x0045, 0x032d, }},
  {0x1e19, {0x0065, 0x032d, }},
  {0x1e1a, {0x0045, 0x0330, }},
  {0x1e1b, {0x0065, 0x0330, }},
  {0x1e1c, {0x0228, 0x0306, }},
  {0x1e1d, {0x0229, 0x0306, }},
  {0x1e1e, {0x0046, 0x0307, }},
  {0x1e1f, {0x0066, 0x0307, }},
  {0x1e20, {0x0047, 0x0304, }},
  {0x1e21, {0x0067, 0x0304, }},
  {0x1e22, {0x0048, 0x0307, }},
  {0x1e23, {0x0068, 0x0307, }},
  {0x1e24, {0x0048, 0x0323, }},
  {0x1e25, {0x0068, 0x0323, }},
  {0x1e26, {0x0048, 0x0308, }},
  {0x1e27, {0x0068, 0x0308, }},
  {0x1e28, {0x0048, 0x0327, }},
  {0x1e29, {0x0068, 0x0327, }},
  {0x1e2a, {0x0048, 0x032e, }},
  {0x1e2b, {0x0068, 0x032e, }},
  {0x1e2c, {0x0049, 0x0330, }},
  {0x1e2d, {0x0069, 0x0330, }},
  {0x1e2e, {0x00cf, 0x0301, }},
  {0x1e2f, {0x00ef, 0x0301, }},
  {0x1e30, {0x004b, 0x0301, }},
  {0x1e31, {0x006b, 0x0301, }},
  {0x1e32, {0x004b, 0x0323, }},
  {0x1e33, {0x006b, 0x0323, }},
  {0x1e34, {0x004b, 0x0331, }},
  {0x1e35, {0x006b, 0x0331, }},
  {0x1e36, {0x004c, 0x0323, }},
  {0x1e37, {0x006c, 0x0323, }},
  {0x1e38, {0x1e36, 0x0304, }},
  {0x1e39, {0x1e37, 0x0304, }},
  {0x1e3a, {0x004c, 0x0331, }},
  {0x1e3b, {0x006c, 0x0331, }},
  {0x1e3c, {0x004c, 0x032d, }},
  {0x1e3d, {0x006c, 0x032d, }},
  {0x1e3e, {0x004d, 0x0301, }},
  {0x1e3f, {0x006d, 0x0301, }},
  {0x1e40, {0x004d, 0x0307, }},
  {0x1e41, {0x006d, 0x0307, }},
  {0x1e42, {0x004d, 0x0323, }},
  {0x1e43, {0x006d, 0x0323, }},
  {0x1e44, {0x004e, 0x0307, }},
  {0x1e45, {0x006e, 0x0307, }},
  {0x1e46, {0x004e, 0x0323, }},
  {0x1e47, {0x006e, 0x0323, }},
  {0x1e48, {0x004e, 0x0331, }},
  {0x1e49, {0x006e, 0x0331, }},
  {0x1e4a, {0x004e, 0x032d, }},
  {0x1e4b, {0x006e, 0x032d, }},
  {0x1e4c, {0x00d5, 0x0301, }},
  {0x1e4d, {0x00f5, 0x0301, }},
  {0x1e4e, {0x00d5, 0x0308, }},
  {0x1e4f, {0x00f5, 0x0308, }},
  {0x1e50, {0x014c, 0x0300, }},
  {0x1e51, {0x014d, 0x0300, }},
  {0x1e52, {0x014c, 0x0301, }},
  {0x1e53, {0x014d, 0x0301, }},
  {0x1e54, {0x0050, 0x0301, }},
  {0x1e55, {0x0070, 0x0301, }},
  {0x1e56, {0x0050, 0x0307, }},
  {0x1e57, {0x0070, 0x0307, }},
  {0x1e58, {0x0052, 0x0307, }},
  {0x1e59, {0x0072, 0x0307, }},
  {0x1e5a, {0x0052, 0x0323, }},
  {0x1e5b, {0x0072, 0x0323, }},
  {0x1e5c, {0x1e5a, 0x0304, }},
  {0x1e5d, {0x1e5b, 0x0304, }},
  {0x1e5e, {0x0052, 0x0331, }},
  {0x1e5f, {0x0072, 0x0331, }},
  {0x1e60, {0x0053, 0x0307, }},
  {0x1e61, {0x0073, 0x0307, }},
  {0x1e62, {0x0053, 0x0323, }},
  {0x1e63, {0x0073, 0x0323, }},
  {0x1e64, {0x015a, 0x0307, }},
  {0x1e65, {0x015b, 0x0307, }},
  {0x1e66, {0x0160, 0x0307, }},
  {0x1e67, {0x0161, 0x0307, }},
  {0x1e68, {0x1e62, 0x0307, }},
  {0x1e69, {0x1e63, 0x0307, }},
  {0x1e6a, {0x0054, 0x0307, }},
  {0x1e6b, {0x0074, 0x0307, }},
  {0x1e6c, {0x0054, 0x0323, }},
  {0x1e6d, {0x0074, 0x0323, }},
  {0x1e6e, {0x0054, 0x0331, }},
  {0x1e6f, {0x0074, 0x0331, }},
  {0x1e70, {0x0054, 0x032d, }},
  {0x1e71, {0x0074, 0x032d, }},
  {0x1e72, {0x0055, 0x0324, }},
  {0x1e73, {0x0075, 0x0324, }},
  {0x1e74, {0x0055, 0x0330, }},
  {0x1e75, {0x0075, 0x0330, }},
  {0x1e76, {0x0055, 0x032d, }},
  {0x1e77, {0x0075, 0x032d, }},
  {0x1e78, {0x0168, 0x0301, }},
  {0x1e79, {0x0169, 0x0301, }},
  {0x1e7a, {0x016a, 0x0308, }},
  {0x1e7b, {0x016b, 0x0308, }},
  {0x1e7c, {0x0056, 0x0303, }},
  {0x1e7d, {0x0076, 0x0303, }},
  {0x1e7e, {0x0056, 0x0323, }},
  {0x1e7f, {0x0076, 0x0323, }},
  {0x1e80, {0x0057, 0x0300, }},
  {0x1e81, {0x0077, 0x0300, }},
  {0x1e82, {0x0057, 0x0301, }},
  {0x1e83, {0x0077, 0x0301, }},
  {0x1e84, {0x0057, 0x0308, }},
  {0x1e85, {0x0077, 0x0308, }},
  {0x1e86, {0x0057, 0x0307, }},
  {0x1e87, {0x0077, 0x0307, }},
  {0x1e88, {0x0057, 0x0323, }},
  {0x1e89, {0x0077, 0x0323, }},
  {0x1e8a, {0x0058, 0x0307, }},
  {0x1e8b, {0x0078, 0x0307, }},
  {0x1e8c, {0x0058, 0x0308, }},
  {0x1e8d, {0x0078, 0x0308, }},
  {0x1e8e, {0x0059, 0x0307, }},
  {0x1e8f, {0x0079, 0x0307, }},
  {0x1e90, {0x005a, 0x0302, }},
  {0x1e91, {0x007a, 0x0302, }},
  {0x1e92, {0x005a, 0x0323, }},
  {0x1e93, {0x007a, 0x0323, }},
  {0x1e94, {0x005a, 0x0331, }},
  {0x1e95, {0x007a, 0x0331, }},
  {0x1e96, {0x0068, 0x0331, }},
  {0x1e97, {0x0074, 0x0308, }},
  {0x1e98, {0x0077, 0x030a, }},
  {0x1e99, {0x0079, 0x030a, }},
  {0x1e9b, {0x017f, 0x0307, }},
  {0x1ea0, {0x0041, 0x0323, }},
  {0x1ea1, {0x0061, 0x0323, }},
  {0x1ea2, {0x0041, 0x0309, }},
  {0x1ea3, {0x0061, 0x0309, }},
  {0x1ea4, {0x00c2, 0x0301, }},
  {0x1ea5, {0x00e2, 0x0301, }},
  {0x1ea6, {0x00c2, 0x0300, }},
  {0x1ea7, {0x00e2, 0x0300, }},
  {0x1ea8, {0x00c2, 0x0309, }},
  {0x1ea9, {0x00e2, 0x0309, }},
  {0x1eaa, {0x00c2, 0x0303, }},
  {0x1eab, {0x00e2, 0x0303, }},
  {0x1eac, {0x1ea0, 0x0302, }},
  {0x1ead, {0x1ea1, 0x0302, }},
  {0x1eae, {0x0102, 0x0301, }},
  {0x1eaf, {0x0103, 0x0301, }},
  {0x1eb0, {0x0102, 0x0300, }},
  {0x1eb1, {0x0103, 0x0300, }},
  {0x1eb2, {0x0102, 0x0309, }},
  {0x1eb3, {0x0103, 0x0309, }},
  {0x1eb4, {0x0102, 0x0303, }},
  {0x1eb5, {0x0103, 0x0303, }},
  {0x1eb6, {0x1ea0, 0x0306, }},
  {0x1eb7, {0x1ea1, 0x0306, }},
  {0x1eb8, {0x0045, 0x0323, }},
  {0x1eb9, {0x0065, 0x0323, }},
  {0x1eba, {0x0045, 0x0309, }},
  {0x1ebb, {0x0065, 0x0309, }},
  {0x1ebc, {0x0045, 0x0303, }},
  {0x1ebd, {0x0065, 0x0303, }},
  {0x1ebe, {0x00ca, 0x0301, }},
  {0x1ebf, {0x00ea, 0x0301, }},
  {0x1ec0, {0x00ca, 0x0300, }},
  {0x1ec1, {0x00ea, 0x0300, }},
  {0x1ec2, {0x00ca, 0x0309, }},
  {0x1ec3, {0x00ea, 0x0309, }},
  {0x1ec4, {0x00ca, 0x0303, }},
  {0x1ec5, {0x00ea, 0x0303, }},
  {0x1ec6, {0x1eb8, 0x0302, }},
  {0x1ec7, {0x1eb9, 0x0302, }},
  {0x1ec8, {0x0049, 0x0309, }},
  {0x1ec9, {0x0069, 0x0309, }},
  {0x1eca, {0x0049, 0x0323, }},
  {0x1ecb, {0x0069, 0x0323, }},
  {0x1ecc, {0x004f, 0x0323, }},
  {0x1ecd, {0x006f, 0x0323, }},
  {0x1ece, {0x004f, 0x0309, }},
  {0x1ecf, {0x006f, 0x0309, }},
  {0x1ed0, {0x00d4, 0x0301, }},
  {0x1ed1, {0x00f4, 0x0301, }},
  {0x1ed2, {0x00d4, 0x0300, }},
  {0x1ed3, {0x00f4, 0x0300, }},
  {0x1ed4, {0x00d4, 0x0309, }},
  {0x1ed5, {0x00f4, 0x0309, }},
  {0x1ed6, {0x00d4, 0x0303, }},
  {0x1ed7, {0x00f4, 0x0303, }},
  {0x1ed8, {0x1ecc, 0x0302, }},
  {0x1ed9, {0x1ecd, 0x0302, }},
  {0x1eda, {0x01a0, 0x0301, }},
  {0x1edb, {0x01a1, 0x0301, }},
  {0x1edc, {0x01a0, 0x0300, }},
  {0x1edd, {0x01a1, 0x0300, }},
  {0x1ede, {0x01a0, 0x0309, }},
  {0x1edf, {0x01a1, 0x0309, }},
  {0x1ee0, {0x01a0, 0x0303, }},
  {0x1ee1, {0x01a1, 0x0303, }},
  {0x1ee2, {0x01a0, 0x0323, }},
  {0x1ee3, {0x01a1, 0x0323, }},
  {0x1ee4, {0x0055, 0x0323, }},
  {0x1ee5, {0x0075, 0x0323, }},
  {0x1ee6, {0x0055, 0x0309, }},
  {0x1ee7, {0x0075, 0x0309, }},
  {0x1ee8, {0x01af, 0x0301, }},
  {0x1ee9, {0x01b0, 0x0301, }},
  {0x1eea, {0x01af, 0x0300, }},
  {0x1eeb, {0x01b0, 0x0300, }},
  {0x1eec, {0x01af, 0x0309, }},
  {0x1eed, {0x01b0, 0x0309, }},
  {0x1eee, {0x01af, 0x0303, }},
  {0x1eef, {0x01b0, 0x0303, }},
  {0x1ef0, {0x01af, 0x0323, }},
  {0x1ef1, {0x01b0, 0x0323, }},
  {0x1ef2, {0x0059, 0x0300, }},
  {0x1ef3, {0x0079, 0x0300, }},
  {0x1ef4, {0x0059, 0x0323, }},
  {0x1ef5, {0x0079, 0x0323, }},
  {0x1ef6, {0x0059, 0x0309, }},
  {0x1ef7, {0x0079, 0x0309, }},
  {0x1ef8, {0x0059, 0x0303, }},
  {0x1ef9, {0x0079, 0x0303, }},
  {0x1f00, {0x03b1, 0x0313, }},
  {0x1f01, {0x03b1, 0x0314, }},
  {0x1f02, {0x1f00, 0x0300, }},
  {0x1f03, {0x1f01, 0x0300, }},
  {0x1f04, {0x1f00, 0x0301, }},
  {0x1f05, {0x1f01, 0x0301, }},
  {0x1f06, {0x1f00, 0x0342, }},
  {0x1f07, {0x1f01, 0x0342, }},
  {0x1f08, {0x0391, 0x0313, }},
  {0x1f09, {0x0391, 0x0314, }},
  {0x1f0a, {0x1f08, 0x0300, }},
  {0x1f0b, {0x1f09, 0x0300, }},
  {0x1f0c, {0x1f08, 0x0301, }},
  {0x1f0d, {0x1f09, 0x0301, }},
  {0x1f0e, {0x1f08, 0x0342, }},
  {0x1f0f, {0x1f09, 0x0342, }},
  {0x1f10, {0x03b5, 0x0313, }},
  {0x1f11, {0x03b5, 0x0314, }},
  {0x1f12, {0x1f10, 0x0300, }},
  {0x1f13, {0x1f11, 0x0300, }},
  {0x1f14, {0x1f10, 0x0301, }},
  {0x1f15, {0x1f11, 0x0301, }},
  {0x1f18, {0x0395, 0x0313, }},
  {0x1f19, {0x0395, 0x0314, }},
  {0x1f1a, {0x1f18, 0x0300, }},
  {0x1f1b, {0x1f19, 0x0300, }},
  {0x1f1c, {0x1f18, 0x0301, }},
  {0x1f1d, {0x1f19, 0x0301, }},
  {0x1f20, {0x03b7, 0x0313, }},
  {0x1f21, {0x03b7, 0x0314, }},
  {0x1f22, {0x1f20, 0x0300, }},
  {0x1f23, {0x1f21, 0x0300, }},
  {0x1f24, {0x1f20, 0x0301, }},
  {0x1f25, {0x1f21, 0x0301, }},
  {0x1f26, {0x1f20, 0x0342, }},
  {0x1f27, {0x1f21, 0x0342, }},
  {0x1f28, {0x0397, 0x0313, }},
  {0x1f29, {0x0397, 0x0314, }},
  {0x1f2a, {0x1f28, 0x0300, }},
  {0x1f2b, {0x1f29, 0x0300, }},
  {0x1f2c, {0x1f28, 0x0301, }},
  {0x1f2d, {0x1f29, 0x0301, }},
  {0x1f2e, {0x1f28, 0x0342, }},
  {0x1f2f, {0x1f29, 0x0342, }},
  {0x1f30, {0x03b9, 0x0313, }},
  {0x1f31, {0x03b9, 0x0314, }},
  {0x1f32, {0x1f30, 0x0300, }},
  {0x1f33, {0x1f31, 0x0300, }},
  {0x1f34, {0x1f30, 0x0301, }},
  {0x1f35, {0x1f31, 0x0301, }},
  {0x1f36, {0x1f30, 0x0342, }},
  {0x1f37, {0x1f31, 0x0342, }},
  {0x1f38, {0x0399, 0x0313, }},
  {0x1f39, {0x0399, 0x0314, }},
  {0x1f3a, {0x1f38, 0x0300, }},
  {0x1f3b, {0x1f39, 0x0300, }},
  {0x1f3c, {0x1f38, 0x0301, }},
  {0x1f3d, {0x1f39, 0x0301, }},
  {0x1f3e, {0x1f38, 0x0342, }},
  {0x1f3f, {0x1f39, 0x0342, }},
  {0x1f40, {0x03bf, 0x0313, }},
  {0x1f41, {0x03bf, 0x0314, }},
  {0x1f42, {0x1f40, 0x0300, }},
  {0x1f43, {0x1f41, 0x0300, }},
  {0x1f44, {0x1f40, 0x0301, }},
  {0x1f45, {0x1f41, 0x0301, }},
  {0x1f48, {0x039f, 0x0313, }},
  {0x1f49, {0x039f, 0x0314, }},
  {0x1f4a, {0x1f48, 0x0300, }},
  {0x1f4b, {0x1f49, 0x0300, }},
  {0x1f4c, {0x1f48, 0x0301, }},
  {0x1f4d, {0x1f49, 0x0301, }},
  {0x1f50, {0x03c5, 0x0313, }},
  {0x1f51, {0x03c5, 0x0314, }},
  {0x1f52, {0x1f50, 0x0300, }},
  {0x1f53, {0x1f51, 0x0300, }},
  {0x1f54, {0x1f50, 0x0301, }},
  {0x1f55, {0x1f51, 0x0301, }},
  {0x1f56, {0x1f50, 0x0342, }},
  {0x1f57, {0x1f51, 0x0342, }},
  {0x1f59, {0x03a5, 0x0314, }},
  {0x1f5b, {0x1f59, 0x0300, }},
  {0x1f5d, {0x1f59, 0x0301, }},
  {0x1f5f, {0x1f59, 0x0342, }},
  {0x1f60, {0x03c9, 0x0313, }},
  {0x1f61, {0x03c9, 0x0314, }},
  {0x1f62, {0x1f60, 0x0300, }},
  {0x1f63, {0x1f61, 0x0300, }},
  {0x1f64, {0x1f60, 0x0301, }},
  {0x1f65, {0x1f61, 0x0301, }},
  {0x1f66, {0x1f60, 0x0342, }},
  {0x1f67, {0x1f61, 0x0342, }},
  {0x1f68, {0x03a9, 0x0313, }},
  {0x1f69, {0x03a9, 0x0314, }},
  {0x1f6a, {0x1f68, 0x0300, }},
  {0x1f6b, {0x1f69, 0x0300, }},
  {0x1f6c, {0x1f68, 0x0301, }},
  {0x1f6d, {0x1f69, 0x0301, }},
  {0x1f6e, {0x1f68, 0x0342, }},
  {0x1f6f, {0x1f69, 0x0342, }},
  {0x1f70, {0x03b1, 0x0300, }},
  {0x1f71, {0x03ac, }},
  {0x1f72, {0x03b5, 0x0300, }},
  {0x1f73, {0x03ad, }},
  {0x1f74, {0x03b7, 0x0300, }},
  {0x1f75, {0x03ae, }},
  {0x1f76, {0x03b9, 0x0300, }},
  {0x1f77, {0x03af, }},
  {0x1f78, {0x03bf, 0x0300, }},
  {0x1f79, {0x03cc, }},
  {0x1f7a, {0x03c5, 0x0300, }},
  {0x1f7b, {0x03cd, }},
  {0x1f7c, {0x03c9, 0x0300, }},
  {0x1f7d, {0x03ce, }},
  {0x1f80, {0x1f00, 0x0345, }},
  {0x1f81, {0x1f01, 0x0345, }},
  {0x1f82, {0x1f02, 0x0345, }},
  {0x1f83, {0x1f03, 0x0345, }},
  {0x1f84, {0x1f04, 0x0345, }},
  {0x1f85, {0x1f05, 0x0345, }},
  {0x1f86, {0x1f06, 0x0345, }},
  {0x1f87, {0x1f07, 0x0345, }},
  {0x1f88, {0x1f08, 0x0345, }},
  {0x1f89, {0x1f09, 0x0345, }},
  {0x1f8a, {0x1f0a, 0x0345, }},
  {0x1f8b, {0x1f0b, 0x0345, }},
  {0x1f8c, {0x1f0c, 0x0345, }},
  {0x1f8d, {0x1f0d, 0x0345, }},
  {0x1f8e, {0x1f0e, 0x0345, }},
  {0x1f8f, {0x1f0f, 0x0345, }},
  {0x1f90, {0x1f20, 0x0345, }},
  {0x1f91, {0x1f21, 0x0345, }},
  {0x1f92, {0x1f22, 0x0345, }},
  {0x1f93, {0x1f23, 0x0345, }},
  {0x1f94, {0x1f24, 0x0345, }},
  {0x1f95, {0x1f25, 0x0345, }},
  {0x1f96, {0x1f26, 0x0345, }},
  {0x1f97, {0x1f27, 0x0345, }},
  {0x1f98, {0x1f28, 0x0345, }},
  {0x1f99, {0x1f29, 0x0345, }},
  {0x1f9a, {0x1f2a, 0x0345, }},
  {0x1f9b, {0x1f2b, 0x0345, }},
  {0x1f9c, {0x1f2c, 0x0345, }},
  {0x1f9d, {0x1f2d, 0x0345, }},
  {0x1f9e, {0x1f2e, 0x0345, }},
  {0x1f9f, {0x1f2f, 0x0345, }},
  {0x1fa0, {0x1f60, 0x0345, }},
  {0x1fa1, {0x1f61, 0x0345, }},
  {0x1fa2, {0x1f62, 0x0345, }},
  {0x1fa3, {0x1f63, 0x0345, }},
  {0x1fa4, {0x1f64, 0x0345, }},
  {0x1fa5, {0x1f65, 0x0345, }},
  {0x1fa6, {0x1f66, 0x0345, }},
  {0x1fa7, {0x1f67, 0x0345, }},
  {0x1fa8, {0x1f68, 0x0345, }},
  {0x1fa9, {0x1f69, 0x0345, }},
  {0x1faa, {0x1f6a, 0x0345, }},
  {0x1fab, {0x1f6b, 0x0345, }},
  {0x1fac, {0x1f6c, 0x0345, }},
  {0x1fad, {0x1f6d, 0x0345, }},
  {0x1fae, {0x1f6e, 0x0345, }},
  {0x1faf, {0x1f6f, 0x0345, }},
  {0x1fb0, {0x03b1, 0x0306, }},
  {0x1fb1, {0x03b1, 0x0304, }},
  {0x1fb2, {0x1f70, 0x0345, }},
  {0x1fb3, {0x03b1, 0x0345, }},
  {0x1fb4, {0x03ac, 0x0345, }},
  {0x1fb6, {0x03b1, 0x0342, }},
  {0x1fb7, {0x1fb6, 0x0345, }},
  {0x1fb8, {0x0391, 0x0306, }},
  {0x1fb9, {0x0391, 0x0304, }},
  {0x1fba, {0x0391, 0x0300, }},
  {0x1fbb, {0x0386, }},
  {0x1fbc, {0x0391, 0x0345, }},
  {0x1fbe, {0x03b9, }},
  {0x1fc1, {0x00a8, 0x0342, }},
  {0x1fc2, {0x1f74, 0x0345, }},
  {0x1fc3, {0x03b7, 0x0345, }},
  {0x1fc4, {0x03ae, 0x0345, }},
  {0x1fc6, {0x03b7, 0x0342, }},
  {0x1fc7, {0x1fc6, 0x0345, }},
  {0x1fc8, {0x0395, 0x0300, }},
  {0x1fc9, {0x0388, }},
  {0x1fca, {0x0397, 0x0300, }},
  {0x1fcb, {0x0389, }},
  {0x1fcc, {0x0397, 0x0345, }},
  {0x1fcd, {0x1fbf, 0x0300, }},
  {0x1fce, {0x1fbf, 0x0301, }},
  {0x1fcf, {0x1fbf, 0x0342, }},
  {0x1fd0, {0x03b9, 0x0306, }},
  {0x1fd1, {0x03b9, 0x0304, }},
  {0x1fd2, {0x03ca, 0x0300, }},
  {0x1fd3, {0x0390, }},
  {0x1fd6, {0x03b9, 0x0342, }},
  {0x1fd7, {0x03ca, 0x0342, }},
  {0x1fd8, {0x0399, 0x0306, }},
  {0x1fd9, {0x0399, 0x0304, }},
  {0x1fda, {0x0399, 0x0300, }},
  {0x1fdb, {0x038a, }},
  {0x1fdd, {0x1ffe, 0x0300, }},
  {0x1fde, {0x1ffe, 0x0301, }},
  {0x1fdf, {0x1ffe, 0x0342, }},
  {0x1fe0, {0x03c5, 0x0306, }},
  {0x1fe1, {0x03c5, 0x0304, }},
  {0x1fe2, {0x03cb, 0x0300, }},
  {0x1fe3, {0x03b0, }},
  {0x1fe4, {0x03c1, 0x0313, }},
  {0x1fe5, {0x03c1, 0x0314, }},
  {0x1fe6, {0x03c5, 0x0342, }},
  {0x1fe7, {0x03cb, 0x0342, }},
  {0x1fe8, {0x03a5, 0x0306, }},
  {0x1fe9, {0x03a5, 0x0304, }},
  {0x1fea, {0x03a5, 0x0300, }},
  {0x1feb, {0x038e, }},
  {0x1fec, {0x03a1, 0x0314, }},
  {0x1fed, {0x00a8, 0x0300, }},
  {0x1fee, {0x0385, }},
  {0x1fef, {0x0060, }},
  {0x1ff2, {0x1f7c, 0x0345, }},
  {0x1ff3, {0x03c9, 0x0345, }},
  {0x1ff4, {0x03ce, 0x0345, }},
  {0x1ff6, {0x03c9, 0x0342, }},
  {0x1ff7, {0x1ff6, 0x0345, }},
  {0x1ff8, {0x039f, 0x0300, }},
  {0x1ff9, {0x038c, }},
  {0x1ffa, {0x03a9, 0x0300, }},
  {0x1ffb, {0x038f, }},
  {0x1ffc, {0x03a9, 0x0345, }},
  {0x1ffd, {0x00b4, }},
  {0x2000, {0x2002, }},
  {0x2001, {0x2003, }},
  {0x2126, {0x03a9, }},
  {0x212a, {0x004b, }},
  {0x212b, {0x00c5, }},
  {0x219a, {0x2190, 0x0338, }},
  {0x219b, {0x2192, 0x0338, }},
  {0x21ae, {0x2194, 0x0338, }},
  {0x21cd, {0x21d0, 0x0338, }},
  {0x21ce, {0x21d4, 0x0338, }},
  {0x21cf, {0x21d2, 0x0338, }},
  {0x2204, {0x2203, 0x0338, }},
  {0x2209, {0x2208, 0x0338, }},
  {0x220c, {0x220b, 0x0338, }},
  {0x2224, {0x2223, 0x0338, }},
  {0x2226, {0x2225, 0x0338, }},
  {0x2241, {0x223c, 0x0338, }},
  {0x2244, {0x2243, 0x0338, }},
  {0x2247, {0x2245, 0x0338, }},
  {0x2249, {0x2248, 0x0338, }},
  {0x2260, {0x003d, 0x0338, }},
  {0x2262, {0x2261, 0x0338, }},
  {0x226d, {0x224d, 0x0338, }},
  {0x226e, {0x003c, 0x0338, }},
  {0x226f, {0x003e, 0x0338, }},
  {0x2270, {0x2264, 0x0338, }},
  {0x2271, {0x2265, 0x0338, }},
  {0x2274, {0x2272, 0x0338, }},
  {0x2275, {0x2273, 0x0338, }},
  {0x2278, {0x2276, 0x0338, }},
  {0x2279, {0x2277, 0x0338, }},
  {0x2280, {0x227a, 0x0338, }},
  {0x2281, {0x227b, 0x0338, }},
  {0x2284, {0x2282, 0x0338, }},
  {0x2285, {0x2283, 0x0338, }},
  {0x2288, {0x2286, 0x0338, }},
  {0x2289, {0x2287, 0x0338, }},
  {0x22ac, {0x22a2, 0x0338, }},
  {0x22ad, {0x22a8, 0x0338, }},
  {0x22ae, {0x22a9, 0x0338, }},
  {0x22af, {0x22ab, 0x0338, }},
  {0x22e0, {0x227c, 0x0338, }},
  {0x22e1, {0x227d, 0x0338, }},
  {0x22e2, {0x2291, 0x0338, }},
  {0x22e3, {0x2292, 0x0338, }},
  {0x22ea, {0x22b2, 0x0338, }},
  {0x22eb, {0x22b3, 0x0338, }},
  {0x22ec, {0x22b4, 0x0338, }},
  {0x22ed, {0x22b5, 0x0338, }},
  {0x2329, {0x3008, }},
  {0x232a, {0x3009, }},
  {0x2adc, {0x2add, 0x0338, }},
  {0x304c, {0x304b, 0x3099, }},
  {0x304e, {0x304d, 0x3099, }},
  {0x3050, {0x304f, 0x3099, }},
  {0x3052, {0x3051, 0x3099, }},
  {0x3054, {0x3053, 0x3099, }},
  {0x3056, {0x3055, 0x3099, }},
  {0x3058, {0x3057, 0x3099, }},
  {0x305a, {0x3059, 0x3099, }},
  {0x305c, {0x305b, 0x3099, }},
  {0x305e, {0x305d, 0x3099, }},
  {0x3060, {0x305f, 0x3099, }},
  {0x3062, {0x3061, 0x3099, }},
  {0x3065, {0x3064, 0x3099, }},
  {0x3067, {0x3066, 0x3099, }},
  {0x3069, {0x3068, 0x3099, }},
  {0x3070, {0x306f, 0x3099, }},
  {0x3071, {0x306f, 0x309a, }},
  {0x3073, {0x3072, 0x3099, }},
  {0x3074, {0x3072, 0x309a, }},
  {0x3076, {0x3075, 0x3099, }},
  {0x3077, {0x3075, 0x309a, }},
  {0x3079, {0x3078, 0x3099, }},
  {0x307a, {0x3078, 0x309a, }},
  {0x307c, {0x307b, 0x3099, }},
  {0x307d, {0x307b, 0x309a, }},
  {0x3094, {0x3046, 0x3099, }},
  {0x309e, {0x309d, 0x3099, }},
  {0x30ac, {0x30ab, 0x3099, }},
  {0x30ae, {0x30ad, 0x3099, }},
  {0x30b0, {0x30af, 0x3099, }},
  {0x30b2, {0x30b1, 0x3099, }},
  {0x30b4, {0x30b3, 0x3099, }},
  {0x30b6, {0x30b5, 0x3099, }},
  {0x30b8, {0x30b7, 0x3099, }},
  {0x30ba, {0x30b9, 0x3099, }},
  {0x30bc, {0x30bb, 0x3099, }},
  {0x30be, {0x30bd, 0x3099, }},
  {0x30c0, {0x30bf, 0x3099, }},
  {0x30c2, {0x30c1, 0x3099, }},
  {0x30c5, {0x30c4, 0x3099, }},
  {0x30c7, {0x30c6, 0x3099, }},
  {0x30c9, {0x30c8, 0x3099, }},
  {0x30d0, {0x30cf, 0x3099, }},
  {0x30d1, {0x30cf, 0x309a, }},
  {0x30d3, {0x30d2, 0x3099, }},
  {0x30d4, {0x30d2, 0x309a, }},
  {0x30d6, {0x30d5, 0x3099, }},
  {0x30d7, {0x30d5, 0x309a, }},
  {0x30d9, {0x30d8, 0x3099, }},
  {0x30da, {0x30d8, 0x309a, }},
  {0x30dc, {0x30db, 0x3099, }},
  {0x30dd, {0x30db, 0x309a, }},
  {0x30f4, {0x30a6, 0x3099, }},
  {0x30f7, {0x30ef, 0x3099, }},
  {0x30f8, {0x30f0, 0x3099, }},
  {0x30f9, {0x30f1, 0x3099, }},
  {0x30fa, {0x30f2, 0x3099, }},
  {0x30fe, {0x30fd, 0x3099, }},
  {0xf900, {0x8c48, }},
  {0xf901, {0x66f4, }},
  {0xf902, {0x8eca, }},
  {0xf903, {0x8cc8, }},
  {0xf904, {0x6ed1, }},
  {0xf905, {0x4e32, }},
  {0xf906, {0x53e5, }},
  {0xf907, {0x9f9c, }},
  {0xf908, {0x9f9c, }},
  {0xf909, {0x5951, }},
  {0xf90a, {0x91d1, }},
  {0xf90b, {0x5587, }},
  {0xf90c, {0x5948, }},
  {0xf90d, {0x61f6, }},
  {0xf90e, {0x7669, }},
  {0xf90f, {0x7f85, }},
  {0xf910, {0x863f, }},
  {0xf911, {0x87ba, }},
  {0xf912, {0x88f8, }},
  {0xf913, {0x908f, }},
  {0xf914, {0x6a02, }},
  {0xf915, {0x6d1b, }},
  {0xf916, {0x70d9, }},
  {0xf917, {0x73de, }},
  {0xf918, {0x843d, }},
  {0xf919, {0x916a, }},
  {0xf91a, {0x99f1, }},
  {0xf91b, {0x4e82, }},
  {0xf91c, {0x5375, }},
  {0xf91d, {0x6b04, }},
  {0xf91e, {0x721b, }},
  {0xf91f, {0x862d, }},
  {0xf920, {0x9e1e, }},
  {0xf921, {0x5d50, }},
  {0xf922, {0x6feb, }},
  {0xf923, {0x85cd, }},
  {0xf924, {0x8964, }},
  {0xf925, {0x62c9, }},
  {0xf926, {0x81d8, }},
  {0xf927, {0x881f, }},
  {0xf928, {0x5eca, }},
  {0xf929, {0x6717, }},
  {0xf92a, {0x6d6a, }},
  {0xf92b, {0x72fc, }},
  {0xf92c, {0x90ce, }},
  {0xf92d, {0x4f86, }},
  {0xf92e, {0x51b7, }},
  {0xf92f, {0x52de, }},
  {0xf930, {0x64c4, }},
  {0xf931, {0x6ad3, }},
  {0xf932, {0x7210, }},
  {0xf933, {0x76e7, }},
  {0xf934, {0x8001, }},
  {0xf935, {0x8606, }},
  {0xf936, {0x865c, }},
  {0xf937, {0x8def, }},
  {0xf938, {0x9732, }},
  {0xf939, {0x9b6f, }},
  {0xf93a, {0x9dfa, }},
  {0xf93b, {0x788c, }},
  {0xf93c, {0x797f, }},
  {0xf93d, {0x7da0, }},
  {0xf93e, {0x83c9, }},
  {0xf93f, {0x9304, }},
  {0xf940, {0x9e7f, }},
  {0xf941, {0x8ad6, }},
  {0xf942, {0x58df, }},
  {0xf943, {0x5f04, }},
  {0xf944, {0x7c60, }},
  {0xf945, {0x807e, }},
  {0xf946, {0x7262, }},
  {0xf947, {0x78ca, }},
  {0xf948, {0x8cc2, }},
  {0xf949, {0x96f7, }},
  {0xf94a, {0x58d8, }},
  {0xf94b, {0x5c62, }},
  {0xf94c, {0x6a13, }},
  {0xf94d, {0x6dda, }},
  {0xf94e, {0x6f0f, }},
  {0xf94f, {0x7d2f, }},
  {0xf950, {0x7e37, }},
  {0xf951, {0x964b, }},
  {0xf952, {0x52d2, }},
  {0xf953, {0x808b, }},
  {0xf954, {0x51dc, }},
  {0xf955, {0x51cc, }},
  {0xf956, {0x7a1c, }},
  {0xf957, {0x7dbe, }},
  {0xf958, {0x83f1, }},
  {0xf959, {0x9675, }},
  {0xf95a, {0x8b80, }},
  {0xf95b, {0x62cf, }},
  {0xf95c, {0x6a02, }},
  {0xf95d, {0x8afe, }},
  {0xf95e, {0x4e39, }},
  {0xf95f, {0x5be7, }},
  {0xf960, {0x6012, }},
  {0xf961, {0x7387, }},
  {0xf962, {0x7570, }},
  {0xf963, {0x5317, }},
  {0xf964, {0x78fb, }},
  {0xf965, {0x4fbf, }},
  {0xf966, {0x5fa9, }},
  {0xf967, {0x4e0d, }},
  {0xf968, {0x6ccc, }},
  {0xf969, {0x6578, }},
  {0xf96a, {0x7d22, }},
  {0xf96b, {0x53c3, }},
  {0xf96c, {0x585e, }},
  {0xf96d, {0x7701, }},
  {0xf96e, {0x8449, }},
  {0xf96f, {0x8aaa, }},
  {0xf970, {0x6bba, }},
  {0xf971, {0x8fb0, }},
  {0xf972, {0x6c88, }},
  {0xf973, {0x62fe, }},
  {0xf974, {0x82e5, }},
  {0xf975, {0x63a0, }},
  {0xf976, {0x7565, }},
  {0xf977, {0x4eae, }},
  {0xf978, {0x5169, }},
  {0xf979, {0x51c9, }},
  {0xf97a, {0x6881, }},
  {0xf97b, {0x7ce7, }},
  {0xf97c, {0x826f, }},
  {0xf97d, {0x8ad2, }},
  {0xf97e, {0x91cf, }},
  {0xf97f, {0x52f5, }},
  {0xf980, {0x5442, }},
  {0xf981, {0x5973, }},
  {0xf982, {0x5eec, }},
  {0xf983, {0x65c5, }},
  {0xf984, {0x6ffe, }},
  {0xf985, {0x792a, }},
  {0xf986, {0x95ad, }},
  {0xf987, {0x9a6a, }},
  {0xf988, {0x9e97, }},
  {0xf989, {0x9ece, }},
  {0xf98a, {0x529b, }},
  {0xf98b, {0x66c6, }},
  {0xf98c, {0x6b77, }},
  {0xf98d, {0x8f62, }},
  {0xf98e, {0x5e74, }},
  {0xf98f, {0x6190, }},
  {0xf990, {0x6200, }},
  {0xf991, {0x649a, }},
  {0xf992, {0x6f23, }},
  {0xf993, {0x7149, }},
  {0xf994, {0x7489, }},
  {0xf995, {0x79ca, }},
  {0xf996, {0x7df4, }},
  {0xf997, {0x806f, }},
  {0xf998, {0x8f26, }},
  {0xf999, {0x84ee, }},
  {0xf99a, {0x9023, }},
  {0xf99b, {0x934a, }},
  {0xf99c, {0x5217, }},
  {0xf99d, {0x52a3, }},
  {0xf99e, {0x54bd, }},
  {0xf99f, {0x70c8, }},
  {0xf9a0, {0x88c2, }},
  {0xf9a1, {0x8aaa, }},
  {0xf9a2, {0x5ec9, }},
  {0xf9a3, {0x5ff5, }},
  {0xf9a4, {0x637b, }},
  {0xf9a5, {0x6bae, }},
  {0xf9a6, {0x7c3e, }},
  {0xf9a7, {0x7375, }},
  {0xf9a8, {0x4ee4, }},
  {0xf9a9, {0x56f9, }},
  {0xf9aa, {0x5be7, }},
  {0xf9ab, {0x5dba, }},
  {0xf9ac, {0x601c, }},
  {0xf9ad, {0x73b2, }},
  {0xf9ae, {0x7469, }},
  {0xf9af, {0x7f9a, }},
  {0xf9b0, {0x8046, }},
  {0xf9b1, {0x9234, }},
  {0xf9b2, {0x96f6, }},
  {0xf9b3, {0x9748, }},
  {0xf9b4, {0x9818, }},
  {0xf9b5, {0x4f8b, }},
  {0xf9b6, {0x79ae, }},
  {0xf9b7, {0x91b4, }},
  {0xf9b8, {0x96b8, }},
  {0xf9b9, {0x60e1, }},
  {0xf9ba, {0x4e86, }},
  {0xf9bb, {0x50da, }},
  {0xf9bc, {0x5bee, }},
  {0xf9bd, {0x5c3f, }},
  {0xf9be, {0x6599, }},
  {0xf9bf, {0x6a02, }},
  {0xf9c0, {0x71ce, }},
  {0xf9c1, {0x7642, }},
  {0xf9c2, {0x84fc, }},
  {0xf9c3, {0x907c, }},
  {0xf9c4, {0x9f8d, }},
  {0xf9c5, {0x6688, }},
  {0xf9c6, {0x962e, }},
  {0xf9c7, {0x5289, }},
  {0xf9c8, {0x677b, }},
  {0xf9c9, {0x67f3, }},
  {0xf9ca, {0x6d41, }},
  {0xf9cb, {0x6e9c, }},
  {0xf9cc, {0x7409, }},
  {0xf9cd, {0x7559, }},
  {0xf9ce, {0x786b, }},
  {0xf9cf, {0x7d10, }},
  {0xf9d0, {0x985e, }},
  {0xf9d1, {0x516d, }},
  {0xf9d2, {0x622e, }},
  {0xf9d3, {0x9678, }},
  {0xf9d4, {0x502b, }},
  {0xf9d5, {0x5d19, }},
  {0xf9d6, {0x6dea, }},
  {0xf9d7, {0x8f2a, }},
  {0xf9d8, {0x5f8b, }},
  {0xf9d9, {0x6144, }},
  {0xf9da, {0x6817, }},
  {0xf9db, {0x7387, }},
  {0xf9dc, {0x9686, }},
  {0xf9dd, {0x5229, }},
  {0xf9de, {0x540f, }},
  {0xf9df, {0x5c65, }},
  {0xf9e0, {0x6613, }},
  {0xf9e1, {0x674e, }},
  {0xf9e2, {0x68a8, }},
  {0xf9e3, {0x6ce5, }},
  {0xf9e4, {0x7406, }},
  {0xf9e5, {0x75e2, }},
  {0xf9e6, {0x7f79, }},
  {0xf9e7, {0x88cf, }},
  {0xf9e8, {0x88e1, }},
  {0xf9e9, {0x91cc, }},
  {0xf9ea, {0x96e2, }},
  {0xf9eb, {0x533f, }},
  {0xf9ec, {0x6eba, }},
  {0xf9ed, {0x541d, }},
  {0xf9ee, {0x71d0, }},
  {0xf9ef, {0x7498, }},
  {0xf9f0, {0x85fa, }},
  {0xf9f1, {0x96a3, }},
  {0xf9f2, {0x9c57, }},
  {0xf9f3, {0x9e9f, }},
  {0xf9f4, {0x6797, }},
  {0xf9f5, {0x6dcb, }},
  {0xf9f6, {0x81e8, }},
  {0xf9f7, {0x7acb, }},
  {0xf9f8, {0x7b20, }},
  {0xf9f9, {0x7c92, }},
  {0xf9fa, {0x72c0, }},
  {0xf9fb, {0x7099, }},
  {0xf9fc, {0x8b58, }},
  {0xf9fd, {0x4ec0, }},
  {0xf9fe, {0x8336, }},
  {0xf9ff, {0x523a, }},
  {0xfa00, {0x5207, }},
  {0xfa01, {0x5ea6, }},
  {0xfa02, {0x62d3, }},
  {0xfa03, {0x7cd6, }},
  {0xfa04, {0x5b85, }},
  {0xfa05, {0x6d1e, }},
  {0xfa06, {0x66b4, }},
  {0xfa07, {0x8f3b, }},
  {0xfa08, {0x884c, }},
  {0xfa09, {0x964d, }},
  {0xfa0a, {0x898b, }},
  {0xfa0b, {0x5ed3, }},
  {0xfa0c, {0x5140, }},
  {0xfa0d, {0x55c0, }},
  {0xfa10, {0x585a, }},
  {0xfa12, {0x6674, }},
  {0xfa15, {0x51de, }},
  {0xfa16, {0x732a, }},
  {0xfa17, {0x76ca, }},
  {0xfa18, {0x793c, }},
  {0xfa19, {0x795e, }},
  {0xfa1a, {0x7965, }},
  {0xfa1b, {0x798f, }},
  {0xfa1c, {0x9756, }},
  {0xfa1d, {0x7cbe, }},
  {0xfa1e, {0x7fbd, }},
  {0xfa20, {0x8612, }},
  {0xfa22, {0x8af8, }},
  {0xfa25, {0x9038, }},
  {0xfa26, {0x90fd, }},
  {0xfa2a, {0x98ef, }},
  {0xfa2b, {0x98fc, }},
  {0xfa2c, {0x9928, }},
  {0xfa2d, {0x9db4, }},
  {0xfa2e, {0x90de, }},
  {0xfa2f, {0x96b7, }},
  {0xfa30, {0x4fae, }},
  {0xfa31, {0x50e7, }},
  {0xfa32, {0x514d, }},
  {0xfa33, {0x52c9, }},
  {0xfa34, {0x52e4, }},
  {0xfa35, {0x5351, }},
  {0xfa36, {0x559d, }},
  {0xfa37, {0x5606, }},
  {0xfa38, {0x5668, }},
  {0xfa39, {0x5840, }},
  {0xfa3a, {0x58a8, }},
  {0xfa3b, {0x5c64, }},
  {0xfa3c, {0x5c6e, }},
  {0xfa3d, {0x6094, }},
  {0xfa3e, {0x6168, }},
  {0xfa3f, {0x618e, }},
  {0xfa40, {0x61f2, }},
  {0xfa41, {0x654f, }},
  {0xfa42, {0x65e2, }},
  {0xfa43, {0x6691, }},
  {0xfa44, {0x6885, }},
  {0xfa45, {0x6d77, }},
  {0xfa46, {0x6e1a, }},
  {0xfa47, {0x6f22, }},
  {0xfa48, {0x716e, }},
  {0xfa49, {0x722b, }},
  {0xfa4a, {0x7422, }},
  {0xfa4b, {0x7891, }},
  {0xfa4c, {0x793e, }},
  {0xfa4d, {0x7949, }},
  {0xfa4e, {0x7948, }},
  {0xfa4f, {0x7950, }},
  {0xfa50, {0x7956, }},
  {0xfa51, {0x795d, }},
  {0xfa52, {0x798d, }},
  {0xfa53, {0x798e, }},
  {0xfa54, {0x7a40, }},
  {0xfa55, {0x7a81, }},
  {0xfa56, {0x7bc0, }},
  {0xfa57, {0x7df4, }},
  {0xfa58, {0x7e09, }},
  {0xfa59, {0x7e41, }},
  {0xfa5a, {0x7f72, }},
  {0xfa5b, {0x8005, }},
  {0xfa5c, {0x81ed, }},
  {0xfa5d, {0x8279, }},
  {0xfa5e, {0x8279, }},
  {0xfa5f, {0x8457, }},
  {0xfa60, {0x8910, }},
  {0xfa61, {0x8996, }},
  {0xfa62, {0x8b01, }},
  {0xfa63, {0x8b39, }},
  {0xfa64, {0x8cd3, }},
  {0xfa65, {0x8d08, }},
  {0xfa66, {0x8fb6, }},
  {0xfa67, {0x9038, }},
  {0xfa68, {0x96e3, }},
  {0xfa69, {0x97ff, }},
  {0xfa6a, {0x983b, }},
  {0xfa6b, {0x6075, }},
  {0xfa6c, {0x242ee, }},
  {0xfa6d, {0x8218, }},
  {0xfa70, {0x4e26, }},
  {0xfa71, {0x51b5, }},
  {0xfa72, {0x5168, }},
  {0xfa73, {0x4f80, }},
  {0xfa74, {0x5145, }},
  {0xfa75, {0x5180, }},
  {0xfa76, {0x52c7, }},
  {0xfa77, {0x52fa, }},
  {0xfa78, {0x559d, }},
  {0xfa79, {0x5555, }},
  {0xfa7a, {0x5599, }},
  {0xfa7b, {0x55e2, }},
  {0xfa7c, {0x585a, }},
  {0xfa7d, {0x58b3, }},
  {0xfa7e, {0x5944, }},
  {0xfa7f, {0x5954, }},
  {0xfa80, {0x5a62, }},
  {0xfa81, {0x5b28, }},
  {0xfa82, {0x5ed2, }},
  {0xfa83, {0x5ed9, }},
  {0xfa84, {0x5f69, }},
  {0xfa85, {0x5fad, }},
  {0xfa86, {0x60d8, }},
  {0xfa87, {0x614e, }},
  {0xfa88, {0x6108, }},
  {0xfa89, {0x618e, }},
  {0xfa8a, {0x6160, }},
  {0xfa8b, {0x61f2, }},
  {0xfa8c, {0x6234, }},
  {0xfa8d, {0x63c4, }},
  {0xfa8e, {0x641c, }},
  {0xfa8f, {0x6452, }},
  {0xfa90, {0x6556, }},
  {0xfa91, {0x6674, }},
  {0xfa92, {0x6717, }},
  {0xfa93, {0x671b, }},
  {0xfa94, {0x6756, }},
  {0xfa95, {0x6b79, }},
  {0xfa96, {0x6bba, }},
  {0xfa97, {0x6d41, }},
  {0xfa98, {0x6edb, }},
  {0xfa99, {0x6ecb, }},
  {0xfa9a, {0x6f22, }},
  {0xfa9b, {0x701e, }},
  {0xfa9c, {0x716e, }},
  {0xfa9d, {0x77a7, }},
  {0xfa9e, {0x7235, }},
  {0xfa9f, {0x72af, }},
  {0xfaa0, {0x732a, }},
  {0xfaa1, {0x7471, }},
  {0xfaa2, {0x7506, }},
  {0xfaa3, {0x753b, }},
  {0xfaa4, {0x761d, }},
  {0xfaa5, {0x761f, }},
  {0xfaa6, {0x76ca, }},
  {0xfaa7, {0x76db, }},
  {0xfaa8, {0x76f4, }},
  {0xfaa9, {0x774a, }},
  {0xfaaa, {0x7740, }},
  {0xfaab, {0x78cc, }},
  {0xfaac, {0x7ab1, }},
  {0xfaad, {0x7bc0, }},
  {0xfaae, {0x7c7b, }},
  {0xfaaf, {0x7d5b, }},
  {0xfab0, {0x7df4, }},
  {0xfab1, {0x7f3e, }},
  {0xfab2, {0x8005, }},
  {0xfab3, {0x8352, }},
  {0xfab4, {0x83ef, }},
  {0xfab5, {0x8779, }},
  {0xfab6, {0x8941, }},
  {0xfab7, {0x8986, }},
  {0xfab8, {0x8996, }},
  {0xfab9, {0x8abf, }},
  {0xfaba, {0x8af8, }},
  {0xfabb, {0x8acb, }},
  {0xfabc, {0x8b01, }},
  {0xfabd, {0x8afe, }},
  {0xfabe, {0x8aed, }},
  {0xfabf, {0x8b39, }},
  {0xfac0, {0x8b8a, }},
  {0xfac1, {0x8d08, }},
  {0xfac2, {0x8f38, }},
  {0xfac3, {0x9072, }},
  {0xfac4, {0x9199, }},
  {0xfac5, {0x9276, }},
  {0xfac6, {0x967c, }},
  {0xfac7, {0x96e3, }},
  {0xfac8, {0x9756, }},
  {0xfac9, {0x97db, }},
  {0xfaca, {0x97ff, }},
  {0xfacb, {0x980b, }},
  {0xfacc, {0x983b, }},
  {0xfacd, {0x9b12, }},
  {0xface, {0x9f9c, }},
  {0xfacf, {0x2284a, }},
  {0xfad0, {0x22844, }},
  {0xfad1, {0x233d5, }},
  {0xfad2, {0x3b9d, }},
  {0xfad3, {0x4018, }},
  {0xfad4, {0x4039, }},
  {0xfad5, {0x25249, }},
  {0xfad6, {0x25cd0, }},
  {0xfad7, {0x27ed3, }},
  {0xfad8, {0x9f43, }},
  {0xfad9, {0x9f8e, }},
  {0xfb1d, {0x05d9, 0x05b4, }},
  {0xfb1f, {0x05f2, 0x05b7, }},
  {0xfb2a, {0x05e9, 0x05c1, }},
  {0xfb2b, {0x05e9, 0x05c2, }},
  {0xfb2c, {0xfb49, 0x05c1, }},
  {0xfb2d, {0xfb49, 0x05c2, }},
  {0xfb2e, {0x05d0, 0x05b7, }},
  {0xfb2f, {0x05d0, 0x05b8, }},
  {0xfb30, {0x05d0, 0x05bc, }},
  {0xfb31, {0x05d1, 0x05bc, }},
  {0xfb32, {0x05d2, 0x05bc, }},
  {0xfb33, {0x05d3, 0x05bc, }},
  {0xfb34, {0x05d4, 0x05bc, }},
  {0xfb35, {0x05d5, 0x05bc, }},
  {0xfb36, {0x05d6, 0x05bc, }},
  {0xfb38, {0x05d8, 0x05bc, }},
  {0xfb39, {0x05d9, 0x05bc, }},
  {0xfb3a, {0x05da, 0x05bc, }},
  {0xfb3b, {0x05db, 0x05bc, }},
  {0xfb3c, {0x05dc, 0x05bc, }},
  {0xfb3e, {0x05de, 0x05bc, }},
  {0xfb40, {0x05e0, 0x05bc, }},
  {0xfb41, {0x05e1, 0x05bc, }},
  {0xfb43, {0x05e3, 0x05bc, }},
  {0xfb44, {0x05e4, 0x05bc, }},
  {0xfb46, {0x05e6, 0x05bc, }},
  {0xfb47, {0x05e7, 0x05bc, }},
  {0xfb48, {0x05e8, 0x05bc, }},
  {0xfb49, {0x05e9, 0x05bc, }},
  {0xfb4a, {0x05ea, 0x05bc, }},
  {0xfb4b, {0x05d5, 0x05b9, }},
  {0xfb4c, {0x05d1, 0x05bf, }},
  {0xfb4d, {0x05db, 0x05bf, }},
  {0xfb4e, {0x05e4, 0x05bf, }},
  {0x1109a, {0x11099, 0x110ba, }},
  {0x1109c, {0x1109b, 0x110ba, }},
  {0x110ab, {0x110a5, 0x110ba, }},
  {0x1112e, {0x11131, 0x11127, }},
  {0x1112f, {0x11132, 0x11127, }},
  {0x1134b, {0x11347, 0x1133e, }},
  {0x1134c, {0x11347, 0x11357, }},
  {0x114bb, {0x114b9, 0x114ba, }},
  {0x114bc, {0x114b9, 0x114b0, }},
  {0x114be, {0x114b9, 0x114bd, }},
  {0x115ba, {0x115b8, 0x115af, }},
  {0x115bb, {0x115b9, 0x115af, }},
  {0x11938, {0x11935, 0x11930, }},
  {0x1d15e, {0x1d157, 0x1d165, }},
  {0x1d15f, {0x1d158, 0x1d165, }},
  {0x1d160, {0x1d15f, 0x1d16e, }},
  {0x1d161, {0x1d15f, 0x1d16f, }},
  {0x1d162, {0x1d15f, 0x1d170, }},
  {0x1d163, {0x1d15f, 0x1d171, }},
  {0x1d164, {0x1d15f, 0x1d172, }},
  {0x1d1bb, {0x1d1b9, 0x1d165, }},
  {0x1d1bc, {0x1d1ba, 0x1d165, }},
  {0x1d1bd, {0x1d1bb, 0x1d16e, }},
  {0x1d1be, {0x1d1bc, 0x1d16e, }},
  {0x1d1bf, {0x1d1bb, 0x1d16f, }},
  {0x1d1c0, {0x1d1bc, 0x1d16f, }},
  {0x2f800, {0x4e3d, }},
  {0x2f801, {0x4e38, }},
  {0x2f802, {0x4e41, }},
  {0x2f803, {0x20122, }},
  {0x2f804, {0x4f60, }},
  {0x2f805, {0x4fae, }},
  {0x2f806, {0x4fbb, }},
  {0x2f807, {0x5002, }},
  {0x2f808, {0x507a, }},
  {0x2f809, {0x5099, }},
  {0x2f80a, {0x50e7, }},
  {0x2f80b, {0x50cf, }},
  {0x2f80c, {0x349e, }},
  {0x2f80d, {0x2063a, }},
  {0x2f80e, {0x514d, }},
  {0x2f80f, {0x5154, }},
  {0x2f810, {0x5164, }},
  {0x2f811, {0x5177, }},
  {0x2f812, {0x2051c, }},
  {0x2f813, {0x34b9, }},
  {0x2f814, {0x5167, }},
  {0x2f815, {0x518d, }},
  {0x2f816, {0x2054b, }},
  {0x2f817, {0x5197, }},
  {0x2f818, {0x51a4, }},
  {0x2f819, {0x4ecc, }},
  {0x2f81a, {0x51ac, }},
  {0x2f81b, {0x51b5, }},
  {0x2f81c, {0x291df, }},
  {0x2f81d, {0x51f5, }},
  {0x2f81e, {0x5203, }},
  {0x2f81f, {0x34df, }},
  {0x2f820, {0x523b, }},
  {0x2f821, {0x5246, }},
  {0x2f822, {0x5272, }},
  {0x2f823, {0x5277, }},
  {0x2f824, {0x3515, }},
  {0x2f825, {0x52c7, }},
  {0x2f826, {0x52c9, }},
  {0x2f827, {0x52e4, }},
  {0x2f828, {0x52fa, }},
  {0x2f829, {0x5305, }},
  {0x2f82a, {0x5306, }},
  {0x2f82b, {0x5317, }},
  {0x2f82c, {0x5349, }},
  {0x2f82d, {0x5351, }},
  {0x2f82e, {0x535a, }},
  {0x2f82f, {0x5373, }},
  {0x2f830, {0x537d, }},
  {0x2f831, {0x537f, }},
  {0x2f832, {0x537f, }},
  {0x2f833, {0x537f, }},
  {0x2f834, {0x20a2c, }},
  {0x2f835, {0x7070, }},
  {0x2f836, {0x53ca, }},
  {0x2f837, {0x53df, }},
  {0x2f838, {0x20b63, }},
  {0x2f839, {0x53eb, }},
  {0x2f83a, {0x53f1, }},
  {0x2f83b, {0x5406, }},
  {0x2f83c, {0x549e, }},
  {0x2f83d, {0x5438, }},
  {0x2f83e, {0x5448, }},
  {0x2f83f, {0x5468, }},
  {0x2f840, {0x54a2, }},
  {0x2f841, {0x54f6, }},
  {0x2f842, {0x5510, }},
  {0x2f843, {0x5553, }},
  {0x2f844, {0x5563, }},
  {0x2f845, {0x5584, }},
  {0x2f846, {0x5584, }},
  {0x2f847, {0x5599, }},
  {0x2f848, {0x55ab, }},
  {0x2f849, {0x55b3, }},
  {0x2f84a, {0x55c2, }},
  {0x2f84b, {0x5716, }},
  {0x2f84c, {0x5606, }},
  {0x2f84d, {0x5717, }},
  {0x2f84e, {0x5651, }},
  {0x2f84f, {0x5674, }},
  {0x2f850, {0x5207, }},
  {0x2f851, {0x58ee, }},
  {0x2f852, {0x57ce, }},
  {0x2f853, {0x57f4, }},
  {0x2f854, {0x580d, }},
  {0x2f855, {0x578b, }},
  {0x2f856, {0x5832, }},
  {0x2f857, {0x5831, }},
  {0x2f858, {0x58ac, }},
  {0x2f859, {0x214e4, }},
  {0x2f85a, {0x58f2, }},
  {0x2f85b, {0x58f7, }},
  {0x2f85c, {0x5906, }},
  {0x2f85d, {0x591a, }},
  {0x2f85e, {0x5922, }},
  {0x2f85f, {0x5962, }},
  {0x2f860, {0x216a8, }},
  {0x2f861, {0x216ea, }},
  {0x2f862, {0x59ec, }},
  {0x2f863, {0x5a1b, }},
  {0x2f864, {0x5a27, }},
  {0x2f865, {0x59d8, }},
  {0x2f866, {0x5a66, }},
  {0x2f867, {0x36ee, }},
  {0x2f868, {0x36fc, }},
  {0x2f869, {0x5b08, }},
  {0x2f86a, {0x5b3e, }},
  {0x2f86b, {0x5b3e, }},
  {0x2f86c, {0x219c8, }},
  {0x2f86d, {0x5bc3, }},
  {0x2f86e, {0x5bd8, }},
  {0x2f86f, {0x5be7, }},
  {0x2f870, {0x5bf3, }},
  {0x2f871, {0x21b18, }},
  {0x2f872, {0x5bff, }},
  {0x2f873, {0x5c06, }},
  {0x2f874, {0x5f53, }},
  {0x2f875, {0x5c22, }},
  {0x2f876, {0x3781, }},
  {0x2f877, {0x5c60, }},
  {0x2f878, {0x5c6e, }},
  {0x2f879, {0x5cc0, }},
  {0x2f87a, {0x5c8d, }},
  {0x2f87b, {0x21de4, }},
  {0x2f87c, {0x5d43, }},
  {0x2f87d, {0x21de6, }},
  {0x2f87e, {0x5d6e, }},
  {0x2f87f, {0x5d6b, }},
  {0x2f880, {0x5d7c, }},
  {0x2f881, {0x5de1, }},
  {0x2f882, {0x5de2, }},
  {0x2f883, {0x382f, }},
  {0x2f884, {0x5dfd, }},
  {0x2f885, {0x5e28, }},
  {0x2f886, {0x5e3d, }},
  {0x2f887, {0x5e69, }},
  {0x2f888, {0x3862, }},
  {0x2f889, {0x22183, }},
  {0x2f88a, {0x387c, }},
  {0x2f88b, {0x5eb0, }},
  {0x2f88c, {0x5eb3, }},
  {0x2f88d, {0x5eb6, }},
  {0x2f88e, {0x5eca, }},
  {0x2f88f, {0x2a392, }},
  {0x2f890, {0x5efe, }},
  {0x2f891, {0x22331, }},
  {0x2f892, {0x22331, }},
  {0x2f893, {0x8201, }},
  {0x2f894, {0x5f22, }},
  {0x2f895, {0x5f22, }},
  {0x2f896, {0x38c7, }},
  {0x2f897, {0x232b8, }},
  {0x2f898, {0x261da, }},
  {0x2f899, {0x5f62, }},
  {0x2f89a, {0x5f6b, }},
  {0x2f89b, {0x38e3, }},
  {0x2f89c, {0x5f9a, }},
  {0x2f89d, {0x5fcd, }},
  {0x2f89e, {0x5fd7, }},
  {0x2f89f, {0x5ff9, }},
  {0x2f8a0, {0x6081, }},
  {0x2f8a1, {0x393a, }},
  {0x2f8a2, {0x391c, }},
  {0x2f8a3, {0x6094, }},
  {0x2f8a4, {0x226d4, }},
  {0x2f8a5, {0x60c7, }},
  {0x2f8a6, {0x6148, }},
  {0x2f8a7, {0x614c, }},
  {0x2f8a8, {0x614e, }},
  {0x2f8a9, {0x614c, }},
  {0x2f8aa, {0x617a, }},
  {0x2f8ab, {0x618e, }},
  {0x2f8ac, {0x61b2, }},
  {0x2f8ad, {0x61a4, }},
  {0x2f8ae, {0x61af, }},
  {0x2f8af, {0x61de, }},
  {0x2f8b0, {0x61f2, }},
  {0x2f8b1, {0x61f6, }},
  {0x2f8b2, {0x6210, }},
  {0x2f8b3, {0x621b, }},
  {0x2f8b4, {0x625d, }},
  {0x2f8b5, {0x62b1, }},
  {0x2f8b6, {0x62d4, }},
  {0x2f8b7, {0x6350, }},
  {0x2f8b8, {0x22b0c, }},
  {0x2f8b9, {0x633d, }},
  {0x2f8ba, {0x62fc, }},
  {0x2f8bb, {0x6368, }},
  {0x2f8bc, {0x6383, }},
  {0x2f8bd, {0x63e4, }},
  {0x2f8be, {0x22bf1, }},
  {0x2f8bf, {0x6422, }},
  {0x2f8c0, {0x63c5, }},
  {0x2f8c1, {0x63a9, }},
  {0x2f8c2, {0x3a2e, }},
  {0x2f8c3, {0x6469, }},
  {0x2f8c4, {0x647e, }},
  {0x2f8c5, {0x649d, }},
  {0x2f8c6, {0x6477, }},
  {0x2f8c7, {0x3a6c, }},
  {0x2f8c8, {0x654f, }},
  {0x2f8c9, {0x656c, }},
  {0x2f8ca, {0x2300a, }},
  {0x2f8cb, {0x65e3, }},
  {0x2f8cc, {0x66f8, }},
  {0x2f8cd, {0x6649, }},
  {0x2f8ce, {0x3b19, }},
  {0x2f8cf, {0x6691, }},
  {0x2f8d0, {0x3b08, }},
  {0x2f8d1, {0x3ae4, }},
  {0x2f8d2, {0x5192, }},
  {0x2f8d3, {0x5195, }},
  {0x2f8d4, {0x6700, }},
  {0x2f8d5, {0x669c, }},
  {0x2f8d6, {0x80ad, }},
  {0x2f8d7, {0x43d9, }},
  {0x2f8d8, {0x6717, }},
  {0x2f8d9, {0x671b, }},
  {0x2f8da, {0x6721, }},
  {0x2f8db, {0x675e, }},
  {0x2f8dc, {0x6753, }},
  {0x2f8dd, {0x233c3, }},
  {0x2f8de, {0x3b49, }},
  {0x2f8df, {0x67fa, }},
  {0x2f8e0, {0x6785, }},
  {0x2f8e1, {0x6852, }},
  {0x2f8e2, {0x6885, }},
  {0x2f8e3, {0x2346d, }},
  {0x2f8e4, {0x688e, }},
  {0x2f8e5, {0x681f, }},
  {0x2f8e6, {0x6914, }},
  {0x2f8e7, {0x3b9d, }},
  {0x2f8e8, {0x6942, }},
  {0x2f8e9, {0x69a3, }},
  {0x2f8ea, {0x69ea, }},
  {0x2f8eb, {0x6aa8, }},
  {0x2f8ec, {0x236a3, }},
  {0x2f8ed, {0x6adb, }},
  {0x2f8ee, {0x3c18, }},
  {0x2f8ef, {0x6b21, }},
  {0x2f8f0, {0x238a7, }},
  {0x2f8f1, {0x6b54, }},
  {0x2f8f2, {0x3c4e, }},
  {0x2f8f3, {0x6b72, }},
  {0x2f8f4, {0x6b9f, }},
  {0x2f8f5, {0x6bba, }},
  {0x2f8f6, {0x6bbb, }},
  {0x2f8f7, {0x23a8d, }},
  {0x2f8f8, {0x21d0b, }},
  {0x2f8f9, {0x23afa, }},
  {0x2f8fa, {0x6c4e, }},
  {0x2f8fb, {0x23cbc, }},
  {0x2f8fc, {0x6cbf, }},
  {0x2f8fd, {0x6ccd, }},
  {0x2f8fe, {0x6c67, }},
  {0x2f8ff, {0x6d16, }},
  {0x2f900, {0x6d3e, }},
  {0x2f901, {0x6d77, }},
  {0x2f902, {0x6d41, }},
  {0x2f903, {0x6d69, }},
  {0x2f904, {0x6d78, }},
  {0x2f905, {0x6d85, }},
  {0x2f906, {0x23d1e, }},
  {0x2f907, {0x6d34, }},
  {0x2f908, {0x6e2f, }},
  {0x2f909, {0x6e6e, }},
  {0x2f90a, {0x3d33, }},
  {0x2f90b, {0x6ecb, }},
  {0x2f90c, {0x6ec7, }},
  {0x2f90d, {0x23ed1, }},
  {0x2f90e, {0x6df9, }},
  {0x2f90f, {0x6f6e, }},
  {0x2f910, {0x23f5e, }},
  {0x2f911, {0x23f8e, }},
  {0x2f912, {0x6fc6, }},
  {0x2f913, {0x7039, }},
  {0x2f914, {0x701e, }},
  {0x2f915, {0x701b, }},
  {0x2f916, {0x3d96, }},
  {0x2f917, {0x704a, }},
  {0x2f918, {0x707d, }},
  {0x2f919, {0x7077, }},
  {0x2f91a, {0x70ad, }},
  {0x2f91b, {0x20525, }},
  {0x2f91c, {0x7145, }},
  {0x2f91d, {0x24263, }},
  {0x2f91e, {0x719c, }},
  {0x2f91f, {0x243ab, }},
  {0x2f920, {0x7228, }},
  {0x2f921, {0x7235, }},
  {0x2f922, {0x7250, }},
  {0x2f923, {0x24608, }},
  {0x2f924, {0x7280, }},
  {0x2f925, {0x7295, }},
  {0x2f926, {0x24735, }},
  {0x2f927, {0x24814, }},
  {0x2f928, {0x737a, }},
  {0x2f929, {0x738b, }},
  {0x2f92a, {0x3eac, }},
  {0x2f92b, {0x73a5, }},
  {0x2f92c, {0x3eb8, }},
  {0x2f92d, {0x3eb8, }},
  {0x2f92e, {0x7447, }},
  {0x2f92f, {0x745c, }},
  {0x2f930, {0x7471, }},
  {0x2f931, {0x7485, }},
  {0x2f932, {0x74ca, }},
  {0x2f933, {0x3f1b, }},
  {0x2f934, {0x7524, }},
  {0x2f935, {0x24c36, }},
  {0x2f936, {0x753e, }},
  {0x2f937, {0x24c92, }},
  {0x2f938, {0x7570, }},
  {0x2f939, {0x2219f, }},
  {0x2f93a, {0x7610, }},
  {0x2f93b, {0x24fa1, }},
  {0x2f93c, {0x24fb8, }},
  {0x2f93d, {0x25044, }},
  {0x2f93e, {0x3ffc, }},
  {0x2f93f, {0x4008, }},
  {0x2f940, {0x76f4, }},
  {0x2f941, {0x250f3, }},
  {0x2f942, {0x250f2, }},
  {0x2f943, {0x25119, }},
  {0x2f944, {0x25133, }},
  {0x2f945, {0x771e, }},
  {0x2f946, {0x771f, }},
  {0x2f947, {0x771f, }},
  {0x2f948, {0x774a, }},
  {0x2f949, {0x4039, }},
  {0x2f94a, {0x778b, }},
  {0x2f94b, {0x4046, }},
  {0x2f94c, {0x4096, }},
  {0x2f94d, {0x2541d, }},
  {0x2f94e, {0x784e, }},
  {0x2f94f, {0x788c, }},
  {0x2f950, {0x78cc, }},
  {0x2f951, {0x40e3, }},
  {0x2f952, {0x25626, }},
  {0x2f953, {0x7956, }},
  {0x2f954, {0x2569a, }},
  {0x2f955, {0x256c5, }},
  {0x2f956, {0x798f, }},
  {0x2f957, {0x79eb, }},
  {0x2f958, {0x412f, }},
  {0x2f959, {0x7a40, }},
  {0x2f95a, {0x7a4a, }},
  {0x2f95b, {0x7a4f, }},
  {0x2f95c, {0x2597c, }},
  {0x2f95d, {0x25aa7, }},
  {0x2f95e, {0x25aa7, }},
  {0x2f95f, {0x7aee, }},
  {0x2f960, {0x4202, }},
  {0x2f961, {0x25bab, }},
  {0x2f962, {0x7bc6, }},
  {0x2f963, {0x7bc9, }},
  {0x2f964, {0x4227, }},
  {0x2f965, {0x25c80, }},
  {0x2f966, {0x7cd2, }},
  {0x2f967, {0x42a0, }},
  {0x2f968, {0x7ce8, }},
  {0x2f969, {0x7ce3, }},
  {0x2f96a, {0x7d00, }},
  {0x2f96b, {0x25f86, }},
  {0x2f96c, {0x7d63, }},
  {0x2f96d, {0x4301, }},
  {0x2f96e, {0x7dc7, }},
  {0x2f96f, {0x7e02, }},
  {0x2f970, {0x7e45, }},
  {0x2f971, {0x4334, }},
  {0x2f972, {0x26228, }},
  {0x2f973, {0x26247, }},
  {0x2f974, {0x4359, }},
  {0x2f975, {0x262d9, }},
  {0x2f976, {0x7f7a, }},
  {0x2f977, {0x2633e, }},
  {0x2f978, {0x7f95, }},
  {0x2f979, {0x7ffa, }},
  {0x2f97a, {0x8005, }},
  {0x2f97b, {0x264da, }},
  {0x2f97c, {0x26523, }},
  {0x2f97d, {0x8060, }},
  {0x2f97e, {0x265a8, }},
  {0x2f97f, {0x8070, }},
  {0x2f980, {0x2335f, }},
  {0x2f981, {0x43d5, }},
  {0x2f982, {0x80b2, }},
  {0x2f983, {0x8103, }},
  {0x2f984, {0x440b, }},
  {0x2f985, {0x813e, }},
  {0x2f986, {0x5ab5, }},
  {0x2f987, {0x267a7, }},
  {0x2f988, {0x267b5, }},
  {0x2f989, {0x23393, }},
  {0x2f98a, {0x2339c, }},
  {0x2f98b, {0x8201, }},
  {0x2f98c, {0x8204, }},
  {0x2f98d, {0x8f9e, }},
  {0x2f98e, {0x446b, }},
  {0x2f98f, {0x8291, }},
  {0x2f990, {0x828b, }},
  {0x2f991, {0x829d, }},
  {0x2f992, {0x52b3, }},
  {0x2f993, {0x82b1, }},
  {0x2f994, {0x82b3, }},
  {0x2f995, {0x82bd, }},
  {0x2f996, {0x82e6, }},
  {0x2f997, {0x26b3c, }},
  {0x2f998, {0x82e5, }},
  {0x2f999, {0x831d, }},
  {0x2f99a, {0x8363, }},
  {0x2f99b, {0x83ad, }},
  {0x2f99c, {0x8323, }},
  {0x2f99d, {0x83bd, }},
  {0x2f99e, {0x83e7, }},
  {0x2f99f, {0x8457, }},
  {0x2f9a0, {0x8353, }},
  {0x2f9a1, {0x83ca, }},
  {0x2f9a2, {0x83cc, }},
  {0x2f9a3, {0x83dc, }},
  {0x2f9a4, {0x26c36, }},
  {0x2f9a5, {0x26d6b, }},
  {0x2f9a6, {0x26cd5, }},
  {0x2f9a7, {0x452b, }},
  {0x2f9a8, {0x84f1, }},
  {0x2f9a9, {0x84f3, }},
  {0x2f9aa, {0x8516, }},
  {0x2f9ab, {0x273ca, }},
  {0x2f9ac, {0x8564, }},
  {0x2f9ad, {0x26f2c, }},
  {0x2f9ae, {0x455d, }},
  {0x2f9af, {0x4561, }},
  {0x2f9b0, {0x26fb1, }},
  {0x2f9b1, {0x270d2, }},
  {0x2f9b2, {0x456b, }},
  {0x2f9b3, {0x8650, }},
  {0x2f9b4, {0x865c, }},
  {0x2f9b5, {0x8667, }},
  {0x2f9b6, {0x8669, }},
  {0x2f9b7, {0x86a9, }},
  {0x2f9b8, {0x8688, }},
  {0x2f9b9, {0x870e, }},
  {0x2f9ba, {0x86e2, }},
  {0x2f9bb, {0x8779, }},
  {0x2f9bc, {0x8728, }},
  {0x2f9bd, {0x876b, }},
  {0x2f9be, {0x8786, }},
  {0x2f9bf, {0x45d7, }},
  {0x2f9c0, {0x87e1, }},
  {0x2f9c1, {0x8801, }},
  {0x2f9c2, {0x45f9, }},
  {0x2f9c3, {0x8860, }},
  {0x2f9c4, {0x8863, }},
  {0x2f9c5, {0x27667, }},
  {0x2f9c6, {0x88d7, }},
  {0x2f9c7, {0x88de, }},
  {0x2f9c8, {0x4635, }},
  {0x2f9c9, {0x88fa, }},
  {0x2f9ca, {0x34bb, }},
  {0x2f9cb, {0x278ae, }},
  {0x2f9cc, {0x27966, }},
  {0x2f9cd, {0x46be, }},
  {0x2f9ce, {0x46c7, }},
  {0x2f9cf, {0x8aa0, }},
  {0x2f9d0, {0x8aed, }},
  {0x2f9d1, {0x8b8a, }},
  {0x2f9d2, {0x8c55, }},
  {0x2f9d3, {0x27ca8, }},
  {0x2f9d4, {0x8cab, }},
  {0x2f9d5, {0x8cc1, }},
  {0x2f9d6, {0x8d1b, }},
  {0x2f9d7, {0x8d77, }},
  {0x2f9d8, {0x27f2f, }},
  {0x2f9d9, {0x20804, }},
  {0x2f9da, {0x8dcb, }},
  {0x2f9db, {0x8dbc, }},
  {0x2f9dc, {0x8df0, }},
  {0x2f9dd, {0x208de, }},
  {0x2f9de, {0x8ed4, }},
  {0x2f9df, {0x8f38, }},
  {0x2f9e0, {0x285d2, }},
  {0x2f9e1, {0x285ed, }},
  {0x2f9e2, {0x9094, }},
  {0x2f9e3, {0x90f1, }},
  {0x2f9e4, {0x9111, }},
  {0x2f9e5, {0x2872e, }},
  {0x2f9e6, {0x911b, }},
  {0x2f9e7, {0x9238, }},
  {0x2f9e8, {0x92d7, }},
  {0x2f9e9, {0x92d8, }},
  {0x2f9ea, {0x927c, }},
  {0x2f9eb, {0x93f9, }},
  {0x2f9ec, {0x9415, }},
  {0x2f9ed, {0x28bfa, }},
  {0x2f9ee, {0x958b, }},
  {0x2f9ef, {0x4995, }},
  {0x2f9f0, {0x95b7, }},
  {0x2f9f1, {0x28d77, }},
  {0x2f9f2, {0x49e6, }},
  {0x2f9f3, {0x96c3, }},
  {0x2f9f4, {0x5db2, }},
  {0x2f9f5, {0x9723, }},
  {0x2f9f6, {0x29145, }},
  {0x2f9f7, {0x2921a, }},
  {0x2f9f8, {0x4a6e, }},
  {0x2f9f9, {0x4a76, }},
  {0x2f9fa, {0x97e0, }},
  {0x2f9fb, {0x2940a, }},
  {0x2f9fc, {0x4ab2, }},
  {0x2f9fd, {0x29496, }},
  {0x2f9fe, {0x980b, }},
  {0x2f9ff, {0x980b, }},
  {0x2fa00, {0x9829, }},
  {0x2fa01, {0x295b6, }},
  {0x2fa02, {0x98e2, }},
  {0x2fa03, {0x4b33, }},
  {0x2fa04, {0x9929, }},
  {0x2fa05, {0x99a7, }},
  {0x2fa06, {0x99c2, }},
  {0x2fa07, {0x99fe, }},
  {0x2fa08, {0x4bce, }},
  {0x2fa09, {0x29b30, }},
  {0x2fa0a, {0x9b12, }},
  {0x2fa0b, {0x9c40, }},
  {0x2fa0c, {0x9cfd, }},
  {0x2fa0d, {0x4cce, }},
  {0x2fa0e, {0x4ced, }},
  {0x2fa0f, {0x9d67, }},
  {0x2fa10, {0x2a0ce, }},
  {0x2fa11, {0x4cf8, }},
  {0x2fa12, {0x2a105, }},
  {0x2fa13, {0x2a20e, }},
  {0x2fa14, {0x2a291, }},
  {0x2fa15, {0x9ebb, }},
  {0x2fa16, {0x4d56, }},
  {0x2fa17, {0x9ef9, }},
  {0x2fa18, {0x9efe, }},
  {0x2fa19, {0x9f05, }},
  {0x2fa1a, {0x9f0f, }},
  {0x2fa1b, {0x9f16, }},
  {0x2fa1c, {0x9f3b, }},
  {0x2fa1d, {0x2a600, }},
  // clang-format on
};

const std::map<std::pair<uint32_t, uint32_t>, uint32_t> RECOMPOSITION_MAP = {{
  // clang-format off
  {{0x0041, 0x0300}, 0x00c0},
  {{0x0041, 0x0301}, 0x00c1},
  {{0x0041, 0x0302}, 0x00c2},
  {{0x0041, 0x0303}, 0x00c3},
  {{0x0041, 0x0308}, 0x00c4},
  {{0x0041, 0x030a}, 0x00c5},
  {{0x0043, 0x0327}, 0x00c7},
  {{0x0045, 0x0300}, 0x00c8},
  {{0x0045, 0x0301}, 0x00c9},
  {{0x0045, 0x0302}, 0x00ca},
  {{0x0045, 0x0308}, 0x00cb},
  {{0x0049, 0x0300}, 0x00cc},
  {{0x0049, 0x0301}, 0x00cd},
  {{0x0049, 0x0302}, 0x00ce},
  {{0x0049, 0x0308}, 0x00cf},
  {{0x004e, 0x0303}, 0x00d1},
  {{0x004f, 0x0300}, 0x00d2},
  {{0x004f, 0x0301}, 0x00d3},
  {{0x004f, 0x0302}, 0x00d4},
  {{0x004f, 0x0303}, 0x00d5},
  {{0x004f, 0x0308}, 0x00d6},
  {{0x0055, 0x0300}, 0x00d9},
  {{0x0055, 0x0301}, 0x00da},
  {{0x0055, 0x0302}, 0x00db},
  {{0x0055, 0x0308}, 0x00dc},
  {{0x0059, 0x0301}, 0x00dd},
  {{0x0061, 0x0300}, 0x00e0},
  {{0x0061, 0x0301}, 0x00e1},
  {{0x0061, 0x0302}, 0x00e2},
  {{0x0061, 0x0303}, 0x00e3},
  {{0x0061, 0x0308}, 0x00e4},
  {{0x0061, 0x030a}, 0x00e5},
  {{0x0063, 0x0327}, 0x00e7},
  {{0x0065, 0x0300}, 0x00e8},
  {{0x0065, 0x0301}, 0x00e9},
  {{0x0065, 0x0302}, 0x00ea},
  {{0x0065, 0x0308}, 0x00eb},
  {{0x0069, 0x0300}, 0x00ec},
  {{0x0069, 0x0301}, 0x00ed},
  {{0x0069, 0x0302}, 0x00ee},
  {{0x0069, 0x0308}, 0x00ef},
  {{0x006e, 0x0303}, 0x00f1},
  {{0x006f, 0x0300}, 0x00f2},
  {{0x006f, 0x0301}, 0x00f3},
  {{0x006f, 0x0302}, 0x00f4},
  {{0x006f, 0x0303}, 0x00f5},
  {{0x006f, 0x0308}, 0x00f6},
  {{0x0075, 0x0300}, 0x00f9},
  {{0x0075, 0x0301}, 0x00fa},
  {{0x0075, 0x0302}, 0x00fb},
  {{0x0075, 0x0308}, 0x00fc},
  {{0x0079, 0x0301}, 0x00fd},
  {{0x0079, 0x0308}, 0x00ff},
  {{0x0041, 0x0304}, 0x0100},
  {{0x0061, 0x0304}, 0x0101},
  {{0x0041, 0x0306}, 0x0102},
  {{0x0061, 0x0306}, 0x0103},
  {{0x0041, 0x0328}, 0x0104},
  {{0x0061, 0x0328}, 0x0105},
  {{0x0043, 0x0301}, 0x0106},
  {{0x0063, 0x0301}, 0x0107},
  {{0x0043, 0x0302}, 0x0108},
  {{0x0063, 0x0302}, 0x0109},
  {{0x0043, 0x0307}, 0x010a},
  {{0x0063, 0x0307}, 0x010b},
  {{0x0043, 0x030c}, 0x010c},
  {{0x0063, 0x030c}, 0x010d},
  {{0x0044, 0x030c}, 0x010e},
  {{0x0064, 0x030c}, 0x010f},
  {{0x0045, 0x0304}, 0x0112},
  {{0x0065, 0x0304}, 0x0113},
  {{0x0045, 0x0306}, 0x0114},
  {{0x0065, 0x0306}, 0x0115},
  {{0x0045, 0x0307}, 0x0116},
  {{0x0065, 0x0307}, 0x0117},
  {{0x0045, 0x0328}, 0x0118},
  {{0x0065, 0x0328}, 0x0119},
  {{0x0045, 0x030c}, 0x011a},
  {{0x0065, 0x030c}, 0x011b},
  {{0x0047, 0x0302}, 0x011c},
  {{0x0067, 0x0302}, 0x011d},
  {{0x0047, 0x0306}, 0x011e},
  {{0x0067, 0x0306}, 0x011f},
  {{0x0047, 0x0307}, 0x0120},
  {{0x0067, 0x0307}, 0x0121},
  {{0x0047, 0x0327}, 0x0122},
  {{0x0067, 0x0327}, 0x0123},
  {{0x0048, 0x0302}, 0x0124},
  {{0x0068, 0x0302}, 0x0125},
  {{0x0049, 0x0303}, 0x0128},
  {{0x0069, 0x0303}, 0x0129},
  {{0x0049, 0x0304}, 0x012a},
  {{0x0069, 0x0304}, 0x012b},
  {{0x0049, 0x0306}, 0x012c},
  {{0x0069, 0x0306}, 0x012d},
  {{0x0049, 0x0328}, 0x012e},
  {{0x0069, 0x0328}, 0x012f},
  {{0x0049, 0x0307}, 0x0130},
  {{0x004a, 0x0302}, 0x0134},
  {{0x006a, 0x0302}, 0x0135},
  {{0x004b, 0x0327}, 0x0136},
  {{0x006b, 0x0327}, 0x0137},
  {{0x004c, 0x0301}, 0x0139},
  {{0x006c, 0x0301}, 0x013a},
  {{0x004c, 0x0327}, 0x013b},
  {{0x006c, 0x0327}, 0x013c},
  {{0x004c, 0x030c}, 0x013d},
  {{0x006c, 0x030c}, 0x013e},
  {{0x004e, 0x0301}, 0x0143},
  {{0x006e, 0x0301}, 0x0144},
  {{0x004e, 0x0327}, 0x0145},
  {{0x006e, 0x0327}, 0x0146},
  {{0x004e, 0x030c}, 0x0147},
  {{0x006e, 0x030c}, 0x0148},
  {{0x004f, 0x0304}, 0x014c},
  {{0x006f, 0x0304}, 0x014d},
  {{0x004f, 0x0306}, 0x014e},
  {{0x006f, 0x0306}, 0x014f},
  {{0x004f, 0x030b}, 0x0150},
  {{0x006f, 0x030b}, 0x0151},
  {{0x0052, 0x0301}, 0x0154},
  {{0x0072, 0x0301}, 0x0155},
  {{0x0052, 0x0327}, 0x0156},
  {{0x0072, 0x0327}, 0x0157},
  {{0x0052, 0x030c}, 0x0158},
  {{0x0072, 0x030c}, 0x0159},
  {{0x0053, 0x0301}, 0x015a},
  {{0x0073, 0x0301}, 0x015b},
  {{0x0053, 0x0302}, 0x015c},
  {{0x0073, 0x0302}, 0x015d},
  {{0x0053, 0x0327}, 0x015e},
  {{0x0073, 0x0327}, 0x015f},
  {{0x0053, 0x030c}, 0x0160},
  {{0x0073, 0x030c}, 0x0161},
  {{0x0054, 0x0327}, 0x0162},
  {{0x0074, 0x0327}, 0x0163},
  {{0x0054, 0x030c}, 0x0164},
  {{0x0074, 0x030c}, 0x0165},
  {{0x0055, 0x0303}, 0x0168},
  {{0x0075, 0x0303}, 0x0169},
  {{0x0055, 0x0304}, 0x016a},
  {{0x0075, 0x0304}, 0x016b},
  {{0x0055, 0x0306}, 0x016c},
  {{0x0075, 0x0306}, 0x016d},
  {{0x0055, 0x030a}, 0x016e},
  {{0x0075, 0x030a}, 0x016f},
  {{0x0055, 0x030b}, 0x0170},
  {{0x0075, 0x030b}, 0x0171},
  {{0x0055, 0x0328}, 0x0172},
  {{0x0075, 0x0328}, 0x0173},
  {{0x0057, 0x0302}, 0x0174},
  {{0x0077, 0x0302}, 0x0175},
  {{0x0059, 0x0302}, 0x0176},
  {{0x0079, 0x0302}, 0x0177},
  {{0x0059, 0x0308}, 0x0178},
  {{0x005a, 0x0301}, 0x0179},
  {{0x007a, 0x0301}, 0x017a},
  {{0x005a, 0x0307}, 0x017b},
  {{0x007a, 0x0307}, 0x017c},
  {{0x005a, 0x030c}, 0x017d},
  {{0x007a, 0x030c}, 0x017e},
  {{0x004f, 0x031b}, 0x01a0},
  {{0x006f, 0x031b}, 0x01a1},
  {{0x0055, 0x031b}, 0x01af},
  {{0x0075, 0x031b}, 0x01b0},
  {{0x0041, 0x030c}, 0x01cd},
  {{0x0061, 0x030c}, 0x01ce},
  {{0x0049, 0x030c}, 0x01cf},
  {{0x0069, 0x030c}, 0x01d0},
  {{0x004f, 0x030c}, 0x01d1},
  {{0x006f, 0x030c}, 0x01d2},
  {{0x0055, 0x030c}, 0x01d3},
  {{0x0075, 0x030c}, 0x01d4},
  {{0x00dc, 0x0304}, 0x01d5},
  {{0x00fc, 0x0304}, 0x01d6},
  {{0x00dc, 0x0301}, 0x01d7},
  {{0x00fc, 0x0301}, 0x01d8},
  {{0x00dc, 0x030c}, 0x01d9},
  {{0x00fc, 0x030c}, 0x01da},
  {{0x00dc, 0x0300}, 0x01db},
  {{0x00fc, 0x0300}, 0x01dc},
  {{0x00c4, 0x0304}, 0x01de},
  {{0x00e4, 0x0304}, 0x01df},
  {{0x0226, 0x0304}, 0x01e0},
  {{0x0227, 0x0304}, 0x01e1},
  {{0x00c6, 0x0304}, 0x01e2},
  {{0x00e6, 0x0304}, 0x01e3},
  {{0x0047, 0x030c}, 0x01e6},
  {{0x0067, 0x030c}, 0x01e7},
  {{0x004b, 0x030c}, 0x01e8},
  {{0x006b, 0x030c}, 0x01e9},
  {{0x004f, 0x0328}, 0x01ea},
  {{0x006f, 0x0328}, 0x01eb},
  {{0x01ea, 0x0304}, 0x01ec},
  {{0x01eb, 0x0304}, 0x01ed},
  {{0x01b7, 0x030c}, 0x01ee},
  {{0x0292, 0x030c}, 0x01ef},
  {{0x006a, 0x030c}, 0x01f0},
  {{0x0047, 0x0301}, 0x01f4},
  {{0x0067, 0x0301}, 0x01f5},
  {{0x004e, 0x0300}, 0x01f8},
  {{0x006e, 0x0300}, 0x01f9},
  {{0x00c5, 0x0301}, 0x01fa},
  {{0x00e5, 0x0301}, 0x01fb},
  {{0x00c6, 0x0301}, 0x01fc},
  {{0x00e6, 0x0301}, 0x01fd},
  {{0x00d8, 0x0301}, 0x01fe},
  {{0x00f8, 0x0301}, 0x01ff},
  {{0x0041, 0x030f}, 0x0200},
  {{0x0061, 0x030f}, 0x0201},
  {{0x0041, 0x0311}, 0x0202},
  {{0x0061, 0x0311}, 0x0203},
  {{0x0045, 0x030f}, 0x0204},
  {{0x0065, 0x030f}, 0x0205},
  {{0x0045, 0x0311}, 0x0206},
  {{0x0065, 0x0311}, 0x0207},
  {{0x0049, 0x030f}, 0x0208},
  {{0x0069, 0x030f}, 0x0209},
  {{0x0049, 0x0311}, 0x020a},
  {{0x0069, 0x0311}, 0x020b},
  {{0x004f, 0x030f}, 0x020c},
  {{0x006f, 0x030f}, 0x020d},
  {{0x004f, 0x0311}, 0x020e},
  {{0x006f, 0x0311}, 0x020f},
  {{0x0052, 0x030f}, 0x0210},
  {{0x0072, 0x030f}, 0x0211},
  {{0x0052, 0x0311}, 0x0212},
  {{0x0072, 0x0311}, 0x0213},
  {{0x0055, 0x030f}, 0x0214},
  {{0x0075, 0x030f}, 0x0215},
  {{0x0055, 0x0311}, 0x0216},
  {{0x0075, 0x0311}, 0x0217},
  {{0x0053, 0x0326}, 0x0218},
  {{0x0073, 0x0326}, 0x0219},
  {{0x0054, 0x0326}, 0x021a},
  {{0x0074, 0x0326}, 0x021b},
  {{0x0048, 0x030c}, 0x021e},
  {{0x0068, 0x030c}, 0x021f},
  {{0x0041, 0x0307}, 0x0226},
  {{0x0061, 0x0307}, 0x0227},
  {{0x0045, 0x0327}, 0x0228},
  {{0x0065, 0x0327}, 0x0229},
  {{0x00d6, 0x0304}, 0x022a},
  {{0x00f6, 0x0304}, 0x022b},
  {{0x00d5, 0x0304}, 0x022c},
  {{0x00f5, 0x0304}, 0x022d},
  {{0x004f, 0x0307}, 0x022e},
  {{0x006f, 0x0307}, 0x022f},
  {{0x022e, 0x0304}, 0x0230},
  {{0x022f, 0x0304}, 0x0231},
  {{0x0059, 0x0304}, 0x0232},
  {{0x0079, 0x0304}, 0x0233},
  {{0x00a8, 0x0301}, 0x0385},
  {{0x0391, 0x0301}, 0x0386},
  {{0x0395, 0x0301}, 0x0388},
  {{0x0397, 0x0301}, 0x0389},
  {{0x0399, 0x0301}, 0x038a},
  {{0x039f, 0x0301}, 0x038c},
  {{0x03a5, 0x0301}, 0x038e},
  {{0x03a9, 0x0301}, 0x038f},
  {{0x03ca, 0x0301}, 0x0390},
  {{0x0399, 0x0308}, 0x03aa},
  {{0x03a5, 0x0308}, 0x03ab},
  {{0x03b1, 0x0301}, 0x03ac},
  {{0x03b5, 0x0301}, 0x03ad},
  {{0x03b7, 0x0301}, 0x03ae},
  {{0x03b9, 0x0301}, 0x03af},
  {{0x03cb, 0x0301}, 0x03b0},
  {{0x03b9, 0x0308}, 0x03ca},
  {{0x03c5, 0x0308}, 0x03cb},
  {{0x03bf, 0x0301}, 0x03cc},
  {{0x03c5, 0x0301}, 0x03cd},
  {{0x03c9, 0x0301}, 0x03ce},
  {{0x03d2, 0x0301}, 0x03d3},
  {{0x03d2, 0x0308}, 0x03d4},
  {{0x0415, 0x0300}, 0x0400},
  {{0x0415, 0x0308}, 0x0401},
  {{0x0413, 0x0301}, 0x0403},
  {{0x0406, 0x0308}, 0x0407},
  {{0x041a, 0x0301}, 0x040c},
  {{0x0418, 0x0300}, 0x040d},
  {{0x0423, 0x0306}, 0x040e},
  {{0x0418, 0x0306}, 0x0419},
  {{0x0438, 0x0306}, 0x0439},
  {{0x0435, 0x0300}, 0x0450},
  {{0x0435, 0x0308}, 0x0451},
  {{0x0433, 0x0301}, 0x0453},
  {{0x0456, 0x0308}, 0x0457},
  {{0x043a, 0x0301}, 0x045c},
  {{0x0438, 0x0300}, 0x045d},
  {{0x0443, 0x0306}, 0x045e},
  {{0x0474, 0x030f}, 0x0476},
  {{0x0475, 0x030f}, 0x0477},
  {{0x0416, 0x0306}, 0x04c1},
  {{0x0436, 0x0306}, 0x04c2},
  {{0x0410, 0x0306}, 0x04d0},
  {{0x0430, 0x0306}, 0x04d1},
  {{0x0410, 0x0308}, 0x04d2},
  {{0x0430, 0x0308}, 0x04d3},
  {{0x0415, 0x0306}, 0x04d6},
  {{0x0435, 0x0306}, 0x04d7},
  {{0x04d8, 0x0308}, 0x04da},
  {{0x04d9, 0x0308}, 0x04db},
  {{0x0416, 0x0308}, 0x04dc},
  {{0x0436, 0x0308}, 0x04dd},
  {{0x0417, 0x0308}, 0x04de},
  {{0x0437, 0x0308}, 0x04df},
  {{0x0418, 0x0304}, 0x04e2},
  {{0x0438, 0x0304}, 0x04e3},
  {{0x0418, 0x0308}, 0x04e4},
  {{0x0438, 0x0308}, 0x04e5},
  {{0x041e, 0x0308}, 0x04e6},
  {{0x043e, 0x0308}, 0x04e7},
  {{0x04e8, 0x0308}, 0x04ea},
  {{0x04e9, 0x0308}, 0x04eb},
  {{0x042d, 0x0308}, 0x04ec},
  {{0x044d, 0x0308}, 0x04ed},
  {{0x0423, 0x0304}, 0x04ee},
  {{0x0443, 0x0304}, 0x04ef},
  {{0x0423, 0x0308}, 0x04f0},
  {{0x0443, 0x0308}, 0x04f1},
  {{0x0423, 0x030b}, 0x04f2},
  {{0x0443, 0x030b}, 0x04f3},
  {{0x0427, 0x0308}, 0x04f4},
  {{0x0447, 0x0308}, 0x04f5},
  {{0x042b, 0x0308}, 0x04f8},
  {{0x044b, 0x0308}, 0x04f9},
  {{0x0627, 0x0653}, 0x0622},
  {{0x0627, 0x0654}, 0x0623},
  {{0x0648, 0x0654}, 0x0624},
  {{0x0627, 0x0655}, 0x0625},
  {{0x064a, 0x0654}, 0x0626},
  {{0x06d5, 0x0654}, 0x06c0},
  {{0x06c1, 0x0654}, 0x06c2},
  {{0x06d2, 0x0654}, 0x06d3},
  {{0x0928, 0x093c}, 0x0929},
  {{0x0930, 0x093c}, 0x0931},
  {{0x0933, 0x093c}, 0x0934},
  {{0x09c7, 0x09be}, 0x09cb},
  {{0x09c7, 0x09d7}, 0x09cc},
  {{0x0b47, 0x0b56}, 0x0b48},
  {{0x0b47, 0x0b3e}, 0x0b4b},
  {{0x0b47, 0x0b57}, 0x0b4c},
  {{0x0b92, 0x0bd7}, 0x0b94},
  {{0x0bc6, 0x0bbe}, 0x0bca},
  {{0x0bc7, 0x0bbe}, 0x0bcb},
  {{0x0bc6, 0x0bd7}, 0x0bcc},
  {{0x0c46, 0x0c56}, 0x0c48},
  {{0x0cbf, 0x0cd5}, 0x0cc0},
  {{0x0cc6, 0x0cd5}, 0x0cc7},
  {{0x0cc6, 0x0cd6}, 0x0cc8},
  {{0x0cc6, 0x0cc2}, 0x0cca},
  {{0x0cca, 0x0cd5}, 0x0ccb},
  {{0x0d46, 0x0d3e}, 0x0d4a},
  {{0x0d47, 0x0d3e}, 0x0d4b},
  {{0x0d46, 0x0d57}, 0x0d4c},
  {{0x0dd9, 0x0dca}, 0x0dda},
  {{0x0dd9, 0x0dcf}, 0x0ddc},
  {{0x0ddc, 0x0dca}, 0x0ddd},
  {{0x0dd9, 0x0ddf}, 0x0dde},
  {{0x1025, 0x102e}, 0x1026},
  {{0x1b05, 0x1b35}, 0x1b06},
  {{0x1b07, 0x1b35}, 0x1b08},
  {{0x1b09, 0x1b35}, 0x1b0a},
  {{0x1b0b, 0x1b35}, 0x1b0c},
  {{0x1b0d, 0x1b35}, 0x1b0e},
  {{0x1b11, 0x1b35}, 0x1b12},
  {{0x1b3a, 0x1b35}, 0x1b3b},
  {{0x1b3c, 0x1b35}, 0x1b3d},
  {{0x1b3e, 0x1b35}, 0x1b40},
  {{0x1b3f, 0x1b35}, 0x1b41},
  {{0x1b42, 0x1b35}, 0x1b43},
  {{0x0041, 0x0325}, 0x1e00},
  {{0x0061, 0x0325}, 0x1e01},
  {{0x0042, 0x0307}, 0x1e02},
  {{0x0062, 0x0307}, 0x1e03},
  {{0x0042, 0x0323}, 0x1e04},
  {{0x0062, 0x0323}, 0x1e05},
  {{0x0042, 0x0331}, 0x1e06},
  {{0x0062, 0x0331}, 0x1e07},
  {{0x00c7, 0x0301}, 0x1e08},
  {{0x00e7, 0x0301}, 0x1e09},
  {{0x0044, 0x0307}, 0x1e0a},
  {{0x0064, 0x0307}, 0x1e0b},
  {{0x0044, 0x0323}, 0x1e0c},
  {{0x0064, 0x0323}, 0x1e0d},
  {{0x0044, 0x0331}, 0x1e0e},
  {{0x0064, 0x0331}, 0x1e0f},
  {{0x0044, 0x0327}, 0x1e10},
  {{0x0064, 0x0327}, 0x1e11},
  {{0x0044, 0x032d}, 0x1e12},
  {{0x0064, 0x032d}, 0x1e13},
  {{0x0112, 0x0300}, 0x1e14},
  {{0x0113, 0x0300}, 0x1e15},
  {{0x0112, 0x0301}, 0x1e16},
  {{0x0113, 0x0301}, 0x1e17},
  {{0x0045, 0x032d}, 0x1e18},
  {{0x0065, 0x032d}, 0x1e19},
  {{0x0045, 0x0330}, 0x1e1a},
  {{0x0065, 0x0330}, 0x1e1b},
  {{0x0228, 0x0306}, 0x1e1c},
  {{0x0229, 0x0306}, 0x1e1d},
  {{0x0046, 0x0307}, 0x1e1e},
  {{0x0066, 0x0307}, 0x1e1f},
  {{0x0047, 0x0304}, 0x1e20},
  {{0x0067, 0x0304}, 0x1e21},
  {{0x0048, 0x0307}, 0x1e22},
  {{0x0068, 0x0307}, 0x1e23},
  {{0x0048, 0x0323}, 0x1e24},
  {{0x0068, 0x0323}, 0x1e25},
  {{0x0048, 0x0308}, 0x1e26},
  {{0x0068, 0x0308}, 0x1e27},
  {{0x0048, 0x0327}, 0x1e28},
  {{0x0068, 0x0327}, 0x1e29},
  {{0x0048, 0x032e}, 0x1e2a},
  {{0x0068, 0x032e}, 0x1e2b},
  {{0x0049, 0x0330}, 0x1e2c},
  {{0x0069, 0x0330}, 0x1e2d},
  {{0x00cf, 0x0301}, 0x1e2e},
  {{0x00ef, 0x0301}, 0x1e2f},
  {{0x004b, 0x0301}, 0x1e30},
  {{0x006b, 0x0301}, 0x1e31},
  {{0x004b, 0x0323}, 0x1e32},
  {{0x006b, 0x0323}, 0x1e33},
  {{0x004b, 0x0331}, 0x1e34},
  {{0x006b, 0x0331}, 0x1e35},
  {{0x004c, 0x0323}, 0x1e36},
  {{0x006c, 0x0323}, 0x1e37},
  {{0x1e36, 0x0304}, 0x1e38},
  {{0x1e37, 0x0304}, 0x1e39},
  {{0x004c, 0x0331}, 0x1e3a},
  {{0x006c, 0x0331}, 0x1e3b},
  {{0x004c, 0x032d}, 0x1e3c},
  {{0x006c, 0x032d}, 0x1e3d},
  {{0x004d, 0x0301}, 0x1e3e},
  {{0x006d, 0x0301}, 0x1e3f},
  {{0x004d, 0x0307}, 0x1e40},
  {{0x006d, 0x0307}, 0x1e41},
  {{0x004d, 0x0323}, 0x1e42},
  {{0x006d, 0x0323}, 0x1e43},
  {{0x004e, 0x0307}, 0x1e44},
  {{0x006e, 0x0307}, 0x1e45},
  {{0x004e, 0x0323}, 0x1e46},
  {{0x006e, 0x0323}, 0x1e47},
  {{0x004e, 0x0331}, 0x1e48},
  {{0x006e, 0x0331}, 0x1e49},
  {{0x004e, 0x032d}, 0x1e4a},
  {{0x006e, 0x032d}, 0x1e4b},
  {{0x00d5, 0x0301}, 0x1e4c},
  {{0x00f5, 0x0301}, 0x1e4d},
  {{0x00d5, 0x0308}, 0x1e4e},
  {{0x00f5, 0x0308}, 0x1e4f},
  {{0x014c, 0x0300}, 0x1e50},
  {{0x014d, 0x0300}, 0x1e51},
  {{0x014c, 0x0301}, 0x1e52},
  {{0x014d, 0x0301}, 0x1e53},
  {{0x0050, 0x0301}, 0x1e54},
  {{0x0070, 0x0301}, 0x1e55},
  {{0x0050, 0x0307}, 0x1e56},
  {{0x0070, 0x0307}, 0x1e57},
  {{0x0052, 0x0307}, 0x1e58},
  {{0x0072, 0x0307}, 0x1e59},
  {{0x0052, 0x0323}, 0x1e5a},
  {{0x0072, 0x0323}, 0x1e5b},
  {{0x1e5a, 0x0304}, 0x1e5c},
  {{0x1e5b, 0x0304}, 0x1e5d},
  {{0x0052, 0x0331}, 0x1e5e},
  {{0x0072, 0x0331}, 0x1e5f},
  {{0x0053, 0x0307}, 0x1e60},
  {{0x0073, 0x0307}, 0x1e61},
  {{0x0053, 0x0323}, 0x1e62},
  {{0x0073, 0x0323}, 0x1e63},
  {{0x015a, 0x0307}, 0x1e64},
  {{0x015b, 0x0307}, 0x1e65},
  {{0x0160, 0x0307}, 0x1e66},
  {{0x0161, 0x0307}, 0x1e67},
  {{0x1e62, 0x0307}, 0x1e68},
  {{0x1e63, 0x0307}, 0x1e69},
  {{0x0054, 0x0307}, 0x1e6a},
  {{0x0074, 0x0307}, 0x1e6b},
  {{0x0054, 0x0323}, 0x1e6c},
  {{0x0074, 0x0323}, 0x1e6d},
  {{0x0054, 0x0331}, 0x1e6e},
  {{0x0074, 0x0331}, 0x1e6f},
  {{0x0054, 0x032d}, 0x1e70},
  {{0x0074, 0x032d}, 0x1e71},
  {{0x0055, 0x0324}, 0x1e72},
  {{0x0075, 0x0324}, 0x1e73},
  {{0x0055, 0x0330}, 0x1e74},
  {{0x0075, 0x0330}, 0x1e75},
  {{0x0055, 0x032d}, 0x1e76},
  {{0x0075, 0x032d}, 0x1e77},
  {{0x0168, 0x0301}, 0x1e78},
  {{0x0169, 0x0301}, 0x1e79},
  {{0x016a, 0x0308}, 0x1e7a},
  {{0x016b, 0x0308}, 0x1e7b},
  {{0x0056, 0x0303}, 0x1e7c},
  {{0x0076, 0x0303}, 0x1e7d},
  {{0x0056, 0x0323}, 0x1e7e},
  {{0x0076, 0x0323}, 0x1e7f},
  {{0x0057, 0x0300}, 0x1e80},
  {{0x0077, 0x0300}, 0x1e81},
  {{0x0057, 0x0301}, 0x1e82},
  {{0x0077, 0x0301}, 0x1e83},
  {{0x0057, 0x0308}, 0x1e84},
  {{0x0077, 0x0308}, 0x1e85},
  {{0x0057, 0x0307}, 0x1e86},
  {{0x0077, 0x0307}, 0x1e87},
  {{0x0057, 0x0323}, 0x1e88},
  {{0x0077, 0x0323}, 0x1e89},
  {{0x0058, 0x0307}, 0x1e8a},
  {{0x0078, 0x0307}, 0x1e8b},
  {{0x0058, 0x0308}, 0x1e8c},
  {{0x0078, 0x0308}, 0x1e8d},
  {{0x0059, 0x0307}, 0x1e8e},
  {{0x0079, 0x0307}, 0x1e8f},
  {{0x005a, 0x0302}, 0x1e90},
  {{0x007a, 0x0302}, 0x1e91},
  {{0x005a, 0x0323}, 0x1e92},
  {{0x007a, 0x0323}, 0x1e93},
  {{0x005a, 0x0331}, 0x1e94},
  {{0x007a, 0x0331}, 0x1e95},
  {{0x0068, 0x0331}, 0x1e96},
  {{0x0074, 0x0308}, 0x1e97},
  {{0x0077, 0x030a}, 0x1e98},
  {{0x0079, 0x030a}, 0x1e99},
  {{0x017f, 0x0307}, 0x1e9b},
  {{0x0041, 0x0323}, 0x1ea0},
  {{0x0061, 0x0323}, 0x1ea1},
  {{0x0041, 0x0309}, 0x1ea2},
  {{0x0061, 0x0309}, 0x1ea3},
  {{0x00c2, 0x0301}, 0x1ea4},
  {{0x00e2, 0x0301}, 0x1ea5},
  {{0x00c2, 0x0300}, 0x1ea6},
  {{0x00e2, 0x0300}, 0x1ea7},
  {{0x00c2, 0x0309}, 0x1ea8},
  {{0x00e2, 0x0309}, 0x1ea9},
  {{0x00c2, 0x0303}, 0x1eaa},
  {{0x00e2, 0x0303}, 0x1eab},
  {{0x1ea0, 0x0302}, 0x1eac},
  {{0x1ea1, 0x0302}, 0x1ead},
  {{0x0102, 0x0301}, 0x1eae},
  {{0x0103, 0x0301}, 0x1eaf},
  {{0x0102, 0x0300}, 0x1eb0},
  {{0x0103, 0x0300}, 0x1eb1},
  {{0x0102, 0x0309}, 0x1eb2},
  {{0x0103, 0x0309}, 0x1eb3},
  {{0x0102, 0x0303}, 0x1eb4},
  {{0x0103, 0x0303}, 0x1eb5},
  {{0x1ea0, 0x0306}, 0x1eb6},
  {{0x1ea1, 0x0306}, 0x1eb7},
  {{0x0045, 0x0323}, 0x1eb8},
  {{0x0065, 0x0323}, 0x1eb9},
  {{0x0045, 0x0309}, 0x1eba},
  {{0x0065, 0x0309}, 0x1ebb},
  {{0x0045, 0x0303}, 0x1ebc},
  {{0x0065, 0x0303}, 0x1ebd},
  {{0x00ca, 0x0301}, 0x1ebe},
  {{0x00ea, 0x0301}, 0x1ebf},
  {{0x00ca, 0x0300}, 0x1ec0},
  {{0x00ea, 0x0300}, 0x1ec1},
  {{0x00ca, 0x0309}, 0x1ec2},
  {{0x00ea, 0x0309}, 0x1ec3},
  {{0x00ca, 0x0303}, 0x1ec4},
  {{0x00ea, 0x0303}, 0x1ec5},
  {{0x1eb8, 0x0302}, 0x1ec6},
  {{0x1eb9, 0x0302}, 0x1ec7},
  {{0x0049, 0x0309}, 0x1ec8},
  {{0x0069, 0x0309}, 0x1ec9},
  {{0x0049, 0x0323}, 0x1eca},
  {{0x0069, 0x0323}, 0x1ecb},
  {{0x004f, 0x0323}, 0x1ecc},
  {{0x006f, 0x0323}, 0x1ecd},
  {{0x004f, 0x0309}, 0x1ece},
  {{0x006f, 0x0309}, 0x1ecf},
  {{0x00d4, 0x0301}, 0x1ed0},
  {{0x00f4, 0x0301}, 0x1ed1},
  {{0x00d4, 0x0300}, 0x1ed2},
  {{0x00f4, 0x0300}, 0x1ed3},
  {{0x00d4, 0x0309}, 0x1ed4},
  {{0x00f4, 0x0309}, 0x1ed5},
  {{0x00d4, 0x0303}, 0x1ed6},
  {{0x00f4, 0x0303}, 0x1ed7},
  {{0x1ecc, 0x0302}, 0x1ed8},
  {{0x1ecd, 0x0302}, 0x1ed9},
  {{0x01a0, 0x0301}, 0x1eda},
  {{0x01a1, 0x0301}, 0x1edb},
  {{0x01a0, 0x0300}, 0x1edc},
  {{0x01a1, 0x0300}, 0x1edd},
  {{0x01a0, 0x0309}, 0x1ede},
  {{0x01a1, 0x0309}, 0x1edf},
  {{0x01a0, 0x0303}, 0x1ee0},
  {{0x01a1, 0x0303}, 0x1ee1},
  {{0x01a0, 0x0323}, 0x1ee2},
  {{0x01a1, 0x0323}, 0x1ee3},
  {{0x0055, 0x0323}, 0x1ee4},
  {{0x0075, 0x0323}, 0x1ee5},
  {{0x0055, 0x0309}, 0x1ee6},
  {{0x0075, 0x0309}, 0x1ee7},
  {{0x01af, 0x0301}, 0x1ee8},
  {{0x01b0, 0x0301}, 0x1ee9},
  {{0x01af, 0x0300}, 0x1eea},
  {{0x01b0, 0x0300}, 0x1eeb},
  {{0x01af, 0x0309}, 0x1eec},
  {{0x01b0, 0x0309}, 0x1eed},
  {{0x01af, 0x0303}, 0x1eee},
  {{0x01b0, 0x0303}, 0x1eef},
  {{0x01af, 0x0323}, 0x1ef0},
  {{0x01b0, 0x0323}, 0x1ef1},
  {{0x0059, 0x0300}, 0x1ef2},
  {{0x0079, 0x0300}, 0x1ef3},
  {{0x0059, 0x0323}, 0x1ef4},
  {{0x0079, 0x0323}, 0x1ef5},
  {{0x0059, 0x0309}, 0x1ef6},
  {{0x0079, 0x0309}, 0x1ef7},
  {{0x0059, 0x0303}, 0x1ef8},
  {{0x0079, 0x0303}, 0x1ef9},
  {{0x03b1, 0x0313}, 0x1f00},
  {{0x03b1, 0x0314}, 0x1f01},
  {{0x1f00, 0x0300}, 0x1f02},
  {{0x1f01, 0x0300}, 0x1f03},
  {{0x1f00, 0x0301}, 0x1f04},
  {{0x1f01, 0x0301}, 0x1f05},
  {{0x1f00, 0x0342}, 0x1f06},
  {{0x1f01, 0x0342}, 0x1f07},
  {{0x0391, 0x0313}, 0x1f08},
  {{0x0391, 0x0314}, 0x1f09},
  {{0x1f08, 0x0300}, 0x1f0a},
  {{0x1f09, 0x0300}, 0x1f0b},
  {{0x1f08, 0x0301}, 0x1f0c},
  {{0x1f09, 0x0301}, 0x1f0d},
  {{0x1f08, 0x0342}, 0x1f0e},
  {{0x1f09, 0x0342}, 0x1f0f},
  {{0x03b5, 0x0313}, 0x1f10},
  {{0x03b5, 0x0314}, 0x1f11},
  {{0x1f10, 0x0300}, 0x1f12},
  {{0x1f11, 0x0300}, 0x1f13},
  {{0x1f10, 0x0301}, 0x1f14},
  {{0x1f11, 0x0301}, 0x1f15},
  {{0x0395, 0x0313}, 0x1f18},
  {{0x0395, 0x0314}, 0x1f19},
  {{0x1f18, 0x0300}, 0x1f1a},
  {{0x1f19, 0x0300}, 0x1f1b},
  {{0x1f18, 0x0301}, 0x1f1c},
  {{0x1f19, 0x0301}, 0x1f1d},
  {{0x03b7, 0x0313}, 0x1f20},
  {{0x03b7, 0x0314}, 0x1f21},
  {{0x1f20, 0x0300}, 0x1f22},
  {{0x1f21, 0x0300}, 0x1f23},
  {{0x1f20, 0x0301}, 0x1f24},
  {{0x1f21, 0x0301}, 0x1f25},
  {{0x1f20, 0x0342}, 0x1f26},
  {{0x1f21, 0x0342}, 0x1f27},
  {{0x0397, 0x0313}, 0x1f28},
  {{0x0397, 0x0314}, 0x1f29},
  {{0x1f28, 0x0300}, 0x1f2a},
  {{0x1f29, 0x0300}, 0x1f2b},
  {{0x1f28, 0x0301}, 0x1f2c},
  {{0x1f29, 0x0301}, 0x1f2d},
  {{0x1f28, 0x0342}, 0x1f2e},
  {{0x1f29, 0x0342}, 0x1f2f},
  {{0x03b9, 0x0313}, 0x1f30},
  {{0x03b9, 0x0314}, 0x1f31},
  {{0x1f30, 0x0300}, 0x1f32},
  {{0x1f31, 0x0300}, 0x1f33},
  {{0x1f30, 0x0301}, 0x1f34},
  {{0x1f31, 0x0301}, 0x1f35},
  {{0x1f30, 0x0342}, 0x1f36},
  {{0x1f31, 0x0342}, 0x1f37},
  {{0x0399, 0x0313}, 0x1f38},
  {{0x0399, 0x0314}, 0x1f39},
  {{0x1f38, 0x0300}, 0x1f3a},
  {{0x1f39, 0x0300}, 0x1f3b},
  {{0x1f38, 0x0301}, 0x1f3c},
  {{0x1f39, 0x0301}, 0x1f3d},
  {{0x1f38, 0x0342}, 0x1f3e},
  {{0x1f39, 0x0342}, 0x1f3f},
  {{0x03bf, 0x0313}, 0x1f40},
  {{0x03bf, 0x0314}, 0x1f41},
  {{0x1f40, 0x0300}, 0x1f42},
  {{0x1f41, 0x0300}, 0x1f43},
  {{0x1f40, 0x0301}, 0x1f44},
  {{0x1f41, 0x0301}, 0x1f45},
  {{0x039f, 0x0313}, 0x1f48},
  {{0x039f, 0x0314}, 0x1f49},
  {{0x1f48, 0x0300}, 0x1f4a},
  {{0x1f49, 0x0300}, 0x1f4b},
  {{0x1f48, 0x0301}, 0x1f4c},
  {{0x1f49, 0x0301}, 0x1f4d},
  {{0x03c5, 0x0313}, 0x1f50},
  {{0x03c5, 0x0314}, 0x1f51},
  {{0x1f50, 0x0300}, 0x1f52},
  {{0x1f51, 0x0300}, 0x1f53},
  {{0x1f50, 0x0301}, 0x1f54},
  {{0x1f51, 0x0301}, 0x1f55},
  {{0x1f50, 0x0342}, 0x1f56},
  {{0x1f51, 0x0342}, 0x1f57},
  {{0x03a5, 0x0314}, 0x1f59},
  {{0x1f59, 0x0300}, 0x1f5b},
  {{0x1f59, 0x0301}, 0x1f5d},
  {{0x1f59, 0x0342}, 0x1f5f},
  {{0x03c9, 0x0313}, 0x1f60},
  {{0x03c9, 0x0314}, 0x1f61},
  {{0x1f60, 0x0300}, 0x1f62},
  {{0x1f61, 0x0300}, 0x1f63},
  {{0x1f60, 0x0301}, 0x1f64},
  {{0x1f61, 0x0301}, 0x1f65},
  {{0x1f60, 0x0342}, 0x1f66},
  {{0x1f61, 0x0342}, 0x1f67},
  {{0x03a9, 0x0313}, 0x1f68},
  {{0x03a9, 0x0314}, 0x1f69},
  {{0x1f68, 0x0300}, 0x1f6a},
  {{0x1f69, 0x0300}, 0x1f6b},
  {{0x1f68, 0x0301}, 0x1f6c},
  {{0x1f69, 0x0301}, 0x1f6d},
  {{0x1f68, 0x0342}, 0x1f6e},
  {{0x1f69, 0x0342}, 0x1f6f},
  {{0x03b1, 0x0300}, 0x1f70},
  {{0x03b5, 0x0300}, 0x1f72},
  {{0x03b7, 0x0300}, 0x1f74},
  {{0x03b9, 0x0300}, 0x1f76},
  {{0x03bf, 0x0300}, 0x1f78},
  {{0x03c5, 0x0300}, 0x1f7a},
  {{0x03c9, 0x0300}, 0x1f7c},
  {{0x1f00, 0x0345}, 0x1f80},
  {{0x1f01, 0x0345}, 0x1f81},
  {{0x1f02, 0x0345}, 0x1f82},
  {{0x1f03, 0x0345}, 0x1f83},
  {{0x1f04, 0x0345}, 0x1f84},
  {{0x1f05, 0x0345}, 0x1f85},
  {{0x1f06, 0x0345}, 0x1f86},
  {{0x1f07, 0x0345}, 0x1f87},
  {{0x1f08, 0x0345}, 0x1f88},
  {{0x1f09, 0x0345}, 0x1f89},
  {{0x1f0a, 0x0345}, 0x1f8a},
  {{0x1f0b, 0x0345}, 0x1f8b},
  {{0x1f0c, 0x0345}, 0x1f8c},
  {{0x1f0d, 0x0345}, 0x1f8d},
  {{0x1f0e, 0x0345}, 0x1f8e},
  {{0x1f0f, 0x0345}, 0x1f8f},
  {{0x1f20, 0x0345}, 0x1f90},
  {{0x1f21, 0x0345}, 0x1f91},
  {{0x1f22, 0x0345}, 0x1f92},
  {{0x1f23, 0x0345}, 0x1f93},
  {{0x1f24, 0x0345}, 0x1f94},
  {{0x1f25, 0x0345}, 0x1f95},
  {{0x1f26, 0x0345}, 0x1f96},
  {{0x1f27, 0x0345}, 0x1f97},
  {{0x1f28, 0x0345}, 0x1f98},
  {{0x1f29, 0x0345}, 0x1f99},
  {{0x1f2a, 0x0345}, 0x1f9a},
  {{0x1f2b, 0x0345}, 0x1f9b},
  {{0x1f2c, 0x0345}, 0x1f9c},
  {{0x1f2d, 0x0345}, 0x1f9d},
  {{0x1f2e, 0x0345}, 0x1f9e},
  {{0x1f2f, 0x0345}, 0x1f9f},
  {{0x1f60, 0x0345}, 0x1fa0},
  {{0x1f61, 0x0345}, 0x1fa1},
  {{0x1f62, 0x0345}, 0x1fa2},
  {{0x1f63, 0x0345}, 0x1fa3},
  {{0x1f64, 0x0345}, 0x1fa4},
  {{0x1f65, 0x0345}, 0x1fa5},
  {{0x1f66, 0x0345}, 0x1fa6},
  {{0x1f67, 0x0345}, 0x1fa7},
  {{0x1f68, 0x0345}, 0x1fa8},
  {{0x1f69, 0x0345}, 0x1fa9},
  {{0x1f6a, 0x0345}, 0x1faa},
  {{0x1f6b, 0x0345}, 0x1fab},
  {{0x1f6c, 0x0345}, 0x1fac},
  {{0x1f6d, 0x0345}, 0x1fad},
  {{0x1f6e, 0x0345}, 0x1fae},
  {{0x1f6f, 0x0345}, 0x1faf},
  {{0x03b1, 0x0306}, 0x1fb0},
  {{0x03b1, 0x0304}, 0x1fb1},
  {{0x1f70, 0x0345}, 0x1fb2},
  {{0x03b1, 0x0345}, 0x1fb3},
  {{0x03ac, 0x0345}, 0x1fb4},
  {{0x03b1, 0x0342}, 0x1fb6},
  {{0x1fb6, 0x0345}, 0x1fb7},
  {{0x0391, 0x0306}, 0x1fb8},
  {{0x0391, 0x0304}, 0x1fb9},
  {{0x0391, 0x0300}, 0x1fba},
  {{0x0391, 0x0345}, 0x1fbc},
  {{0x00a8, 0x0342}, 0x1fc1},
  {{0x1f74, 0x0345}, 0x1fc2},
  {{0x03b7, 0x0345}, 0x1fc3},
  {{0x03ae, 0x0345}, 0x1fc4},
  {{0x03b7, 0x0342}, 0x1fc6},
  {{0x1fc6, 0x0345}, 0x1fc7},
  {{0x0395, 0x0300}, 0x1fc8},
  {{0x0397, 0x0300}, 0x1fca},
  {{0x0397, 0x0345}, 0x1fcc},
  {{0x1fbf, 0x0300}, 0x1fcd},
  {{0x1fbf, 0x0301}, 0x1fce},
  {{0x1fbf, 0x0342}, 0x1fcf},
  {{0x03b9, 0x0306}, 0x1fd0},
  {{0x03b9, 0x0304}, 0x1fd1},
  {{0x03ca, 0x0300}, 0x1fd2},
  {{0x03b9, 0x0342}, 0x1fd6},
  {{0x03ca, 0x0342}, 0x1fd7},
  {{0x0399, 0x0306}, 0x1fd8},
  {{0x0399, 0x0304}, 0x1fd9},
  {{0x0399, 0x0300}, 0x1fda},
  {{0x1ffe, 0x0300}, 0x1fdd},
  {{0x1ffe, 0x0301}, 0x1fde},
  {{0x1ffe, 0x0342}, 0x1fdf},
  {{0x03c5, 0x0306}, 0x1fe0},
  {{0x03c5, 0x0304}, 0x1fe1},
  {{0x03cb, 0x0300}, 0x1fe2},
  {{0x03c1, 0x0313}, 0x1fe4},
  {{0x03c1, 0x0314}, 0x1fe5},
  {{0x03c5, 0x0342}, 0x1fe6},
  {{0x03cb, 0x0342}, 0x1fe7},
  {{0x03a5, 0x0306}, 0x1fe8},
  {{0x03a5, 0x0304}, 0x1fe9},
  {{0x03a5, 0x0300}, 0x1fea},
  {{0x03a1, 0x0314}, 0x1fec},
  {{0x00a8, 0x0300}, 0x1fed},
  {{0x1f7c, 0x0345}, 0x1ff2},
  {{0x03c9, 0x0345}, 0x1ff3},
  {{0x03ce, 0x0345}, 0x1ff4},
  {{0x03c9, 0x0342}, 0x1ff6},
  {{0x1ff6, 0x0345}, 0x1ff7},
  {{0x039f, 0x0300}, 0x1ff8},
  {{0x03a9, 0x0300}, 0x1ffa},
  {{0x03a9, 0x0345}, 0x1ffc},
  {{0x2190, 0x0338}, 0x219a},
  {{0x2192, 0x0338}, 0x219b},
  {{0x2194, 0x0338}, 0x21ae},
  {{0x21d0, 0x0338}, 0x21cd},
  {{0x21d4, 0x0338}, 0x21ce},
  {{0x21d2, 0x0338}, 0x21cf},
  {{0x2203, 0x0338}, 0x2204},
  {{0x2208, 0x0338}, 0x2209},
  {{0x220b, 0x0338}, 0x220c},
  {{0x2223, 0x0338}, 0x2224},
  {{0x2225, 0x0338}, 0x2226},
  {{0x223c, 0x0338}, 0x2241},
  {{0x2243, 0x0338}, 0x2244},
  {{0x2245, 0x0338}, 0x2247},
  {{0x2248, 0x0338}, 0x2249},
  {{0x003d, 0x0338}, 0x2260},
  {{0x2261, 0x0338}, 0x2262},
  {{0x224d, 0x0338}, 0x226d},
  {{0x003c, 0x0338}, 0x226e},
  {{0x003e, 0x0338}, 0x226f},
  {{0x2264, 0x0338}, 0x2270},
  {{0x2265, 0x0338}, 0x2271},
  {{0x2272, 0x0338}, 0x2274},
  {{0x2273, 0x0338}, 0x2275},
  {{0x2276, 0x0338}, 0x2278},
  {{0x2277, 0x0338}, 0x2279},
  {{0x227a, 0x0338}, 0x2280},
  {{0x227b, 0x0338}, 0x2281},
  {{0x2282, 0x0338}, 0x2284},
  {{0x2283, 0x0338}, 0x2285},
  {{0x2286, 0x0338}, 0x2288},
  {{0x2287, 0x0338}, 0x2289},
  {{0x22a2, 0x0338}, 0x22ac},
  {{0x22a8, 0x0338}, 0x22ad},
  {{0x22a9, 0x0338}, 0x22ae},
  {{0x22ab, 0x0338}, 0x22af},
  {{0x227c, 0x0338}, 0x22e0},
  {{0x227d, 0x0338}, 0x22e1},
  {{0x2291, 0x0338}, 0x22e2},
  {{0x2292, 0x0338}, 0x22e3},
  {{0x22b2, 0x0338}, 0x22ea},
  {{0x22b3, 0x0338}, 0x22eb},
  {{0x22b4, 0x0338}, 0x22ec},
  {{0x22b5, 0x0338}, 0x22ed},
  {{0x304b, 0x3099}, 0x304c},
  {{0x304d, 0x3099}, 0x304e},
  {{0x304f, 0x3099}, 0x3050},
  {{0x3051, 0x3099}, 0x3052},
  {{0x3053, 0x3099}, 0x3054},
  {{0x3055, 0x3099}, 0x3056},
  {{0x3057, 0x3099}, 0x3058},
  {{0x3059, 0x3099}, 0x305a},
  {{0x305b, 0x3099}, 0x305c},
  {{0x305d, 0x3099}, 0x305e},
  {{0x305f, 0x3099}, 0x3060},
  {{0x3061, 0x3099}, 0x3062},
  {{0x3064, 0x3099}, 0x3065},
  {{0x3066, 0x3099}, 0x3067},
  {{0x3068, 0x3099}, 0x3069},
  {{0x306f, 0x3099}, 0x3070},
  {{0x306f, 0x309a}, 0x3071},
  {{0x3072, 0x3099}, 0x3073},
  {{0x3072, 0x309a}, 0x3074},
  {{0x3075, 0x3099}, 0x3076},
  {{0x3075, 0x309a}, 0x3077},
  {{0x3078, 0x3099}, 0x3079},
  {{0x3078, 0x309a}, 0x307a},
  {{0x307b, 0x3099}, 0x307c},
  {{0x307b, 0x309a}, 0x307d},
  {{0x3046, 0x3099}, 0x3094},
  {{0x309d, 0x3099}, 0x309e},
  {{0x30ab, 0x3099}, 0x30ac},
  {{0x30ad, 0x3099}, 0x30ae},
  {{0x30af, 0x3099}, 0x30b0},
  {{0x30b1, 0x3099}, 0x30b2},
  {{0x30b3, 0x3099}, 0x30b4},
  {{0x30b5, 0x3099}, 0x30b6},
  {{0x30b7, 0x3099}, 0x30b8},
  {{0x30b9, 0x3099}, 0x30ba},
  {{0x30bb, 0x3099}, 0x30bc},
  {{0x30bd, 0x3099}, 0x30be},
  {{0x30bf, 0x3099}, 0x30c0},
  {{0x30c1, 0x3099}, 0x30c2},
  {{0x30c4, 0x3099}, 0x30c5},
  {{0x30c6, 0x3099}, 0x30c7},
  {{0x30c8, 0x3099}, 0x30c9},
  {{0x30cf, 0x3099}, 0x30d0},
  {{0x30cf, 0x309a}, 0x30d1},
  {{0x30d2, 0x3099}, 0x30d3},
  {{0x30d2, 0x309a}, 0x30d4},
  {{0x30d5, 0x3099}, 0x30d6},
  {{0x30d5, 0x309a}, 0x30d7},
  {{0x30d8, 0x3099}, 0x30d9},
  {{0x30d8, 0x309a}, 0x30da},
  {{0x30db, 0x3099}, 0x30dc},
  {{0x30db, 0x309a}, 0x30dd},
  {{0x30a6, 0x3099}, 0x30f4},
  {{0x30ef, 0x3099}, 0x30f7},
  {{0x30f0, 0x3099}, 0x30f8},
  {{0x30f1, 0x3099}, 0x30f9},
  {{0x30f2, 0x3099}, 0x30fa},
  {{0x30fd, 0x3099}, 0x30fe},
  {{0x11099, 0x110ba}, 0x1109a},
  {{0x1109b, 0x110ba}, 0x1109c},
  {{0x110a5, 0x110ba}, 0x110ab},
  {{0x11131, 0x11127}, 0x1112e},
  {{0x11132, 0x11127}, 0x1112f},
  {{0x11347, 0x1133e}, 0x1134b},
  {{0x11347, 0x11357}, 0x1134c},
  {{0x114b9, 0x114ba}, 0x114bb},
  {{0x114b9, 0x114b0}, 0x114bc},
  {{0x114b9, 0x114bd}, 0x114be},
  {{0x115b8, 0x115af}, 0x115ba},
  {{0x115b9, 0x115af}, 0x115bb},
  {{0x11935, 0x11930}, 0x11938},
  // clang-format on
}};

const std::map<uint32_t, int32_t> CCC_TABLE = {
  // clang-format off
  {0x0300, 230},
  {0x0301, 230},
  {0x0302, 230},
  {0x0303, 230},
  {0x0304, 230},
  {0x0305, 230},
  {0x0306, 230},
  {0x0307, 230},
  {0x0308, 230},
  {0x0309, 230},
  {0x030a, 230},
  {0x030b, 230},
  {0x030c, 230},
  {0x030d, 230},
  {0x030e, 230},
  {0x030f, 230},
  {0x0310, 230},
  {0x0311, 230},
  {0x0312, 230},
  {0x0313, 230},
  {0x0314, 230},
  {0x0315, 232},
  {0x0316, 220},
  {0x0317, 220},
  {0x0318, 220},
  {0x0319, 220},
  {0x031a, 232},
  {0x031b, 216},
  {0x031c, 220},
  {0x031d, 220},
  {0x031e, 220},
  {0x031f, 220},
  {0x0320, 220},
  {0x0321, 202},
  {0x0322, 202},
  {0x0323, 220},
  {0x0324, 220},
  {0x0325, 220},
  {0x0326, 220},
  {0x0327, 202},
  {0x0328, 202},
  {0x0329, 220},
  {0x032a, 220},
  {0x032b, 220},
  {0x032c, 220},
  {0x032d, 220},
  {0x032e, 220},
  {0x032f, 220},
  {0x0330, 220},
  {0x0331, 220},
  {0x0332, 220},
  {0x0333, 220},
  {0x0334, 1},
  {0x0335, 1},
  {0x0336, 1},
  {0x0337, 1},
  {0x0338, 1},
  {0x0339, 220},
  {0x033a, 220},
  {0x033b, 220},
  {0x033c, 220},
  {0x033d, 230},
  {0x033e, 230},
  {0x033f, 230},
  {0x0340, 230},
  {0x0341, 230},
  {0x0342, 230},
  {0x0343, 230},
  {0x0344, 230},
  {0x0345, 240},
  {0x0346, 230},
  {0x0347, 220},
  {0x0348, 220},
  {0x0349, 220},
  {0x034a, 230},
  {0x034b, 230},
  {0x034c, 230},
  {0x034d, 220},
  {0x034e, 220},
  {0x0350, 230},
  {0x0351, 230},
  {0x0352, 230},
  {0x0353, 220},
  {0x0354, 220},
  {0x0355, 220},
  {0x0356, 220},
  {0x0357, 230},
  {0x0358, 232},
  {0x0359, 220},
  {0x035a, 220},
  {0x035b, 230},
  {0x035c, 233},
  {0x035d, 234},
  {0x035e, 234},
  {0x035f, 233},
  {0x0360, 234},
  {0x0361, 234},
  {0x0362, 233},
  {0x0363, 230},
  {0x0364, 230},
  {0x0365, 230},
  {0x0366, 230},
  {0x0367, 230},
  {0x0368, 230},
  {0x0369, 230},
  {0x036a, 230},
  {0x036b, 230},
  {0x036c, 230},
  {0x036d, 230},
  {0x036e, 230},
  {0x036f, 230},
  {0x0483, 230},
  {0x0484, 230},
  {0x0485, 230},
  {0x0486, 230},
  {0x0487, 230},
  {0x0591, 220},
  {0x0592, 230},
  {0x0593, 230},
  {0x0594, 230},
  {0x0595, 230},
  {0x0596, 220},
  {0x0597, 230},
  {0x0598, 230},
  {0x0599, 230},
  {0x059a, 222},
  {0x059b, 220},
  {0x059c, 230},
  {0x059d, 230},
  {0x059e, 230},
  {0x059f, 230},
  {0x05a0, 230},
  {0x05a1, 230},
  {0x05a2, 220},
  {0x05a3, 220},
  {0x05a4, 220},
  {0x05a5, 220},
  {0x05a6, 220},
  {0x05a7, 220},
  {0x05a8, 230},
  {0x05a9, 230},
  {0x05aa, 220},
  {0x05ab, 230},
  {0x05ac, 230},
  {0x05ad, 222},
  {0x05ae, 228},
  {0x05af, 230},
  {0x05b0, 10},
  {0x05b1, 11},
  {0x05b2, 12},
  {0x05b3, 13},
  {0x05b4, 14},
  {0x05b5, 15},
  {0x05b6, 16},
  {0x05b7, 17},
  {0x05b8, 18},
  {0x05b9, 19},
  {0x05ba, 19},
  {0x05bb, 20},
  {0x05bc, 21},
  {0x05bd, 22},
  {0x05bf, 23},
  {0x05c1, 24},
  {0x05c2, 25},
  {0x05c4, 230},
  {0x05c5, 220},
  {0x05c7, 18},
  {0x0610, 230},
  {0x0611, 230},
  {0x0612, 230},
  {0x0613, 230},
  {0x0614, 230},
  {0x0615, 230},
  {0x0616, 230},
  {0x0617, 230},
  {0x0618, 30},
  {0x0619, 31},
  {0x061a, 32},
  {0x064b, 27},
  {0x064c, 28},
  {0x064d, 29},
  {0x064e, 30},
  {0x064f, 31},
  {0x0650, 32},
  {0x0651, 33},
  {0x0652, 34},
  {0x0653, 230},
  {0x0654, 230},
  {0x0655, 220},
  {0x0656, 220},
  {0x0657, 230},
  {0x0658, 230},
  {0x0659, 230},
  {0x065a, 230},
  {0x065b, 230},
  {0x065c, 220},
  {0x065d, 230},
  {0x065e, 230},
  {0x065f, 220},
  {0x0670, 35},
  {0x06d6, 230},
  {0x06d7, 230},
  {0x06d8, 230},
  {0x06d9, 230},
  {0x06da, 230},
  {0x06db, 230},
  {0x06dc, 230},
  {0x06df, 230},
  {0x06e0, 230},
  {0x06e1, 230},
  {0x06e2, 230},
  {0x06e3, 220},
  {0x06e4, 230},
  {0x06e7, 230},
  {0x06e8, 230},
  {0x06ea, 220},
  {0x06eb, 230},
  {0x06ec, 230},
  {0x06ed, 220},
  {0x0711, 36},
  {0x0730, 230},
  {0x0731, 220},
  {0x0732, 230},
  {0x0733, 230},
  {0x0734, 220},
  {0x0735, 230},
  {0x0736, 230},
  {0x0737, 220},
  {0x0738, 220},
  {0x0739, 220},
  {0x073a, 230},
  {0x073b, 220},
  {0x073c, 220},
  {0x073d, 230},
  {0x073e, 220},
  {0x073f, 230},
  {0x0740, 230},
  {0x0741, 230},
  {0x0742, 220},
  {0x0743, 230},
  {0x0744, 220},
  {0x0745, 230},
  {0x0746, 220},
  {0x0747, 230},
  {0x0748, 220},
  {0x0749, 230},
  {0x074a, 230},
  {0x07eb, 230},
  {0x07ec, 230},
  {0x07ed, 230},
  {0x07ee, 230},
  {0x07ef, 230},
  {0x07f0, 230},
  {0x07f1, 230},
  {0x07f2, 220},
  {0x07f3, 230},
  {0x07fd, 220},
  {0x0816, 230},
  {0x0817, 230},
  {0x0818, 230},
  {0x0819, 230},
  {0x081b, 230},
  {0x081c, 230},
  {0x081d, 230},
  {0x081e, 230},
  {0x081f, 230},
  {0x0820, 230},
  {0x0821, 230},
  {0x0822, 230},
  {0x0823, 230},
  {0x0825, 230},
  {0x0826, 230},
  {0x0827, 230},
  {0x0829, 230},
  {0x082a, 230},
  {0x082b, 230},
  {0x082c, 230},
  {0x082d, 230},
  {0x0859, 220},
  {0x085a, 220},
  {0x085b, 220},
  {0x0898, 230},
  {0x0899, 220},
  {0x089a, 220},
  {0x089b, 220},
  {0x089c, 230},
  {0x089d, 230},
  {0x089e, 230},
  {0x089f, 230},
  {0x08ca, 230},
  {0x08cb, 230},
  {0x08cc, 230},
  {0x08cd, 230},
  {0x08ce, 230},
  {0x08cf, 220},
  {0x08d0, 220},
  {0x08d1, 220},
  {0x08d2, 220},
  {0x08d3, 220},
  {0x08d4, 230},
  {0x08d5, 230},
  {0x08d6, 230},
  {0x08d7, 230},
  {0x08d8, 230},
  {0x08d9, 230},
  {0x08da, 230},
  {0x08db, 230},
  {0x08dc, 230},
  {0x08dd, 230},
  {0x08de, 230},
  {0x08df, 230},
  {0x08e0, 230},
  {0x08e1, 230},
  {0x08e3, 220},
  {0x08e4, 230},
  {0x08e5, 230},
  {0x08e6, 220},
  {0x08e7, 230},
  {0x08e8, 230},
  {0x08e9, 220},
  {0x08ea, 230},
  {0x08eb, 230},
  {0x08ec, 230},
  {0x08ed, 220},
  {0x08ee, 220},
  {0x08ef, 220},
  {0x08f0, 27},
  {0x08f1, 28},
  {0x08f2, 29},
  {0x08f3, 230},
  {0x08f4, 230},
  {0x08f5, 230},
  {0x08f6, 220},
  {0x08f7, 230},
  {0x08f8, 230},
  {0x08f9, 220},
  {0x08fa, 220},
  {0x08fb, 230},
  {0x08fc, 230},
  {0x08fd, 230},
  {0x08fe, 230},
  {0x08ff, 230},
  {0x093c, 7},
  {0x094d, 9},
  {0x0951, 230},
  {0x0952, 220},
  {0x0953, 230},
  {0x0954, 230},
  {0x09bc, 7},
  {0x09cd, 9},
  {0x09fe, 230},
  {0x0a3c, 7},
  {0x0a4d, 9},
  {0x0abc, 7},
  {0x0acd, 9},
  {0x0b3c, 7},
  {0x0b4d, 9},
  {0x0bcd, 9},
  {0x0c3c, 7},
  {0x0c4d, 9},
  {0x0c55, 84},
  {0x0c56, 91},
  {0x0cbc, 7},
  {0x0ccd, 9},
  {0x0d3b, 9},
  {0x0d3c, 9},
  {0x0d4d, 9},
  {0x0dca, 9},
  {0x0e38, 103},
  {0x0e39, 103},
  {0x0e3a, 9},
  {0x0e48, 107},
  {0x0e49, 107},
  {0x0e4a, 107},
  {0x0e4b, 107},
  {0x0eb8, 118},
  {0x0eb9, 118},
  {0x0eba, 9},
  {0x0ec8, 122},
  {0x0ec9, 122},
  {0x0eca, 122},
  {0x0ecb, 122},
  {0x0f18, 220},
  {0x0f19, 220},
  {0x0f35, 220},
  {0x0f37, 220},
  {0x0f39, 216},
  {0x0f71, 129},
  {0x0f72, 130},
  {0x0f74, 132},
  {0x0f7a, 130},
  {0x0f7b, 130},
  {0x0f7c, 130},
  {0x0f7d, 130},
  {0x0f80, 130},
  {0x0f82, 230},
  {0x0f83, 230},
  {0x0f84, 9},
  {0x0f86, 230},
  {0x0f87, 230},
  {0x0fc6, 220},
  {0x1037, 7},
  {0x1039, 9},
  {0x103a, 9},
  {0x108d, 220},
  {0x135d, 230},
  {0x135e, 230},
  {0x135f, 230},
  {0x1714, 9},
  {0x1715, 9},
  {0x1734, 9},
  {0x17d2, 9},
  {0x17dd, 230},
  {0x18a9, 228},
  {0x1939, 222},
  {0x193a, 230},
  {0x193b, 220},
  {0x1a17, 230},
  {0x1a18, 220},
  {0x1a60, 9},
  {0x1a75, 230},
  {0x1a76, 230},
  {0x1a77, 230},
  {0x1a78, 230},
  {0x1a79, 230},
  {0x1a7a, 230},
  {0x1a7b, 230},
  {0x1a7c, 230},
  {0x1a7f, 220},
  {0x1ab0, 230},
  {0x1ab1, 230},
  {0x1ab2, 230},
  {0x1ab3, 230},
  {0x1ab4, 230},
  {0x1ab5, 220},
  {0x1ab6, 220},
  {0x1ab7, 220},
  {0x1ab8, 220},
  {0x1ab9, 220},
  {0x1aba, 220},
  {0x1abb, 230},
  {0x1abc, 230},
  {0x1abd, 220},
  {0x1abf, 220},
  {0x1ac0, 220},
  {0x1ac1, 230},
  {0x1ac2, 230},
  {0x1ac3, 220},
  {0x1ac4, 220},
  {0x1ac5, 230},
  {0x1ac6, 230},
  {0x1ac7, 230},
  {0x1ac8, 230},
  {0x1ac9, 230},
  {0x1aca, 220},
  {0x1acb, 230},
  {0x1acc, 230},
  {0x1acd, 230},
  {0x1ace, 230},
  {0x1b34, 7},
  {0x1b44, 9},
  {0x1b6b, 230},
  {0x1b6c, 220},
  {0x1b6d, 230},
  {0x1b6e, 230},
  {0x1b6f, 230},
  {0x1b70, 230},
  {0x1b71, 230},
  {0x1b72, 230},
  {0x1b73, 230},
  {0x1baa, 9},
  {0x1bab, 9},
  {0x1be6, 7},
  {0x1bf2, 9},
  {0x1bf3, 9},
  {0x1c37, 7},
  {0x1cd0, 230},
  {0x1cd1, 230},
  {0x1cd2, 230},
  {0x1cd4, 1},
  {0x1cd5, 220},
  {0x1cd6, 220},
  {0x1cd7, 220},
  {0x1cd8, 220},
  {0x1cd9, 220},
  {0x1cda, 230},
  {0x1cdb, 230},
  {0x1cdc, 220},
  {0x1cdd, 220},
  {0x1cde, 220},
  {0x1cdf, 220},
  {0x1ce0, 230},
  {0x1ce2, 1},
  {0x1ce3, 1},
  {0x1ce4, 1},
  {0x1ce5, 1},
  {0x1ce6, 1},
  {0x1ce7, 1},
  {0x1ce8, 1},
  {0x1ced, 220},
  {0x1cf4, 230},
  {0x1cf8, 230},
  {0x1cf9, 230},
  {0x1dc0, 230},
  {0x1dc1, 230},
  {0x1dc2, 220},
  {0x1dc3, 230},
  {0x1dc4, 230},
  {0x1dc5, 230},
  {0x1dc6, 230},
  {0x1dc7, 230},
  {0x1dc8, 230},
  {0x1dc9, 230},
  {0x1dca, 220},
  {0x1dcb, 230},
  {0x1dcc, 230},
  {0x1dcd, 234},
  {0x1dce, 214},
  {0x1dcf, 220},
  {0x1dd0, 202},
  {0x1dd1, 230},
  {0x1dd2, 230},
  {0x1dd3, 230},
  {0x1dd4, 230},
  {0x1dd5, 230},
  {0x1dd6, 230},
  {0x1dd7, 230},
  {0x1dd8, 230},
  {0x1dd9, 230},
  {0x1dda, 230},
  {0x1ddb, 230},
  {0x1ddc, 230},
  {0x1ddd, 230},
  {0x1dde, 230},
  {0x1ddf, 230},
  {0x1de0, 230},
  {0x1de1, 230},
  {0x1de2, 230},
  {0x1de3, 230},
  {0x1de4, 230},
  {0x1de5, 230},
  {0x1de6, 230},
  {0x1de7, 230},
  {0x1de8, 230},
  {0x1de9, 230},
  {0x1dea, 230},
  {0x1deb, 230},
  {0x1dec, 230},
  {0x1ded, 230},
  {0x1dee, 230},
  {0x1def, 230},
  {0x1df0, 230},
  {0x1df1, 230},
  {0x1df2, 230},
  {0x1df3, 230},
  {0x1df4, 230},
  {0x1df5, 230},
  {0x1df6, 232},
  {0x1df7, 228},
  {0x1df8, 228},
  {0x1df9, 220},
  {0x1dfa, 218},
  {0x1dfb, 230},
  {0x1dfc, 233},
  {0x1dfd, 220},
  {0x1dfe, 230},
  {0x1dff, 220},
  {0x20d0, 230},
  {0x20d1, 230},
  {0x20d2, 1},
  {0x20d3, 1},
  {0x20d4, 230},
  {0x20d5, 230},
  {0x20d6, 230},
  {0x20d7, 230},
  {0x20d8, 1},
  {0x20d9, 1},
  {0x20da, 1},
  {0x20db, 230},
  {0x20dc, 230},
  {0x20e1, 230},
  {0x20e5, 1},
  {0x20e6, 1},
  {0x20e7, 230},
  {0x20e8, 220},
  {0x20e9, 230},
  {0x20ea, 1},
  {0x20eb, 1},
  {0x20ec, 220},
  {0x20ed, 220},
  {0x20ee, 220},
  {0x20ef, 220},
  {0x20f0, 230},
  {0x2cef, 230},
  {0x2cf0, 230},
  {0x2cf1, 230},
  {0x2d7f, 9},
  {0x2de0, 230},
  {0x2de1, 230},
  {0x2de2, 230},
  {0x2de3, 230},
  {0x2de4, 230},
  {0x2de5, 230},
  {0x2de6, 230},
  {0x2de7, 230},
  {0x2de8, 230},
  {0x2de9, 230},
  {0x2dea, 230},
  {0x2deb, 230},
  {0x2dec, 230},
  {0x2ded, 230},
  {0x2dee, 230},
  {0x2def, 230},
  {0x2df0, 230},
  {0x2df1, 230},
  {0x2df2, 230},
  {0x2df3, 230},
  {0x2df4, 230},
  {0x2df5, 230},
  {0x2df6, 230},
  {0x2df7, 230},
  {0x2df8, 230},
  {0x2df9, 230},
  {0x2dfa, 230},
  {0x2dfb, 230},
  {0x2dfc, 230},
  {0x2dfd, 230},
  {0x2dfe, 230},
  {0x2dff, 230},
  {0x302a, 218},
  {0x302b, 228},
  {0x302c, 232},
  {0x302d, 222},
  {0x302e, 224},
  {0x302f, 224},
  {0x3099, 8},
  {0x309a, 8},
  {0xa66f, 230},
  {0xa674, 230},
  {0xa675, 230},
  {0xa676, 230},
  {0xa677, 230},
  {0xa678, 230},
  {0xa679, 230},
  {0xa67a, 230},
  {0xa67b, 230},
  {0xa67c, 230},
  {0xa67d, 230},
  {0xa69e, 230},
  {0xa69f, 230},
  {0xa6f0, 230},
  {0xa6f1, 230},
  {0xa806, 9},
  {0xa82c, 9},
  {0xa8c4, 9},
  {0xa8e0, 230},
  {0xa8e1, 230},
  {0xa8e2, 230},
  {0xa8e3, 230},
  {0xa8e4, 230},
  {0xa8e5, 230},
  {0xa8e6, 230},
  {0xa8e7, 230},
  {0xa8e8, 230},
  {0xa8e9, 230},
  {0xa8ea, 230},
  {0xa8eb, 230},
  {0xa8ec, 230},
  {0xa8ed, 230},
  {0xa8ee, 230},
  {0xa8ef, 230},
  {0xa8f0, 230},
  {0xa8f1, 230},
  {0xa92b, 220},
  {0xa92c, 220},
  {0xa92d, 220},
  {0xa953, 9},
  {0xa9b3, 7},
  {0xa9c0, 9},
  {0xaab0, 230},
  {0xaab2, 230},
  {0xaab3, 230},
  {0xaab4, 220},
  {0xaab7, 230},
  {0xaab8, 230},
  {0xaabe, 230},
  {0xaabf, 230},
  {0xaac1, 230},
  {0xaaf6, 9},
  {0xabed, 9},
  {0xfb1e, 26},
  {0xfe20, 230},
  {0xfe21, 230},
  {0xfe22, 230},
  {0xfe23, 230},
  {0xfe24, 230},
  {0xfe25, 230},
  {0xfe26, 230},
  {0xfe27, 220},
  {0xfe28, 220},
  {0xfe29, 220},
  {0xfe2a, 220},
  {0xfe2b, 220},
  {0xfe2c, 220},
  {0xfe2d, 220},
  {0xfe2e, 230},
  {0xfe2f, 230},
  {0x101fd, 220},
  {0x102e0, 220},
  {0x10376, 230},
  {0x10377, 230},
  {0x10378, 230},
  {0x10379, 230},
  {0x1037a, 230},
  {0x10a0d, 220},
  {0x10a0f, 230},
  {0x10a38, 230},
  {0x10a39, 1},
  {0x10a3a, 220},
  {0x10a3f, 9},
  {0x10ae5, 230},
  {0x10ae6, 220},
  {0x10d24, 230},
  {0x10d25, 230},
  {0x10d26, 230},
  {0x10d27, 230},
  {0x10eab, 230},
  {0x10eac, 230},
  {0x10efd, 220},
  {0x10efe, 220},
  {0x10eff, 220},
  {0x10f46, 220},
  {0x10f47, 220},
  {0x10f48, 230},
  {0x10f49, 230},
  {0x10f4a, 230},
  {0x10f4b, 220},
  {0x10f4c, 230},
  {0x10f4d, 220},
  {0x10f4e, 220},
  {0x10f4f, 220},
  {0x10f50, 220},
  {0x10f82, 230},
  {0x10f83, 220},
  {0x10f84, 230},
  {0x10f85, 220},
  {0x11046, 9},
  {0x11070, 9},
  {0x1107f, 9},
  {0x110b9, 9},
  {0x110ba, 7},
  {0x11100, 230},
  {0x11101, 230},
  {0x11102, 230},
  {0x11133, 9},
  {0x11134, 9},
  {0x11173, 7},
  {0x111c0, 9},
  {0x111ca, 7},
  {0x11235, 9},
  {0x11236, 7},
  {0x112e9, 7},
  {0x112ea, 9},
  {0x1133b, 7},
  {0x1133c, 7},
  {0x1134d, 9},
  {0x11366, 230},
  {0x11367, 230},
  {0x11368, 230},
  {0x11369, 230},
  {0x1136a, 230},
  {0x1136b, 230},
  {0x1136c, 230},
  {0x11370, 230},
  {0x11371, 230},
  {0x11372, 230},
  {0x11373, 230},
  {0x11374, 230},
  {0x11442, 9},
  {0x11446, 7},
  {0x1145e, 230},
  {0x114c2, 9},
  {0x114c3, 7},
  {0x115bf, 9},
  {0x115c0, 7},
  {0x1163f, 9},
  {0x116b6, 9},
  {0x116b7, 7},
  {0x1172b, 9},
  {0x11839, 9},
  {0x1183a, 7},
  {0x1193d, 9},
  {0x1193e, 9},
  {0x11943, 7},
  {0x119e0, 9},
  {0x11a34, 9},
  {0x11a47, 9},
  {0x11a99, 9},
  {0x11c3f, 9},
  {0x11d42, 7},
  {0x11d44, 9},
  {0x11d45, 9},
  {0x11d97, 9},
  {0x11f41, 9},
  {0x11f42, 9},
  {0x16af0, 1},
  {0x16af1, 1},
  {0x16af2, 1},
  {0x16af3, 1},
  {0x16af4, 1},
  {0x16b30, 230},
  {0x16b31, 230},
  {0x16b32, 230},
  {0x16b33, 230},
  {0x16b34, 230},
  {0x16b35, 230},
  {0x16b36, 230},
  {0x16ff0, 6},
  {0x16ff1, 6},
  {0x1bc9e, 1},
  {0x1d165, 216},
  {0x1d166, 216},
  {0x1d167, 1},
  {0x1d168, 1},
  {0x1d169, 1},
  {0x1d16d, 226},
  {0x1d16e, 216},
  {0x1d16f, 216},
  {0x1d170, 216},
  {0x1d171, 216},
  {0x1d172, 216},
  {0x1d17b, 220},
  {0x1d17c, 220},
  {0x1d17d, 220},
  {0x1d17e, 220},
  {0x1d17f, 220},
  {0x1d180, 220},
  {0x1d181, 220},
  {0x1d182, 220},
  {0x1d185, 230},
  {0x1d186, 230},
  {0x1d187, 230},
  {0x1d188, 230},
  {0x1d189, 230},
  {0x1d18a, 220},
  {0x1d18b, 220},
  {0x1d1aa, 230},
  {0x1d1ab, 230},
  {0x1d1ac, 230},
  {0x1d1ad, 230},
  {0x1d242, 230},
  {0x1d243, 230},
  {0x1d244, 230},
  {0x1e000, 230},
  {0x1e001, 230},
  {0x1e002, 230},
  {0x1e003, 230},
  {0x1e004, 230},
  {0x1e005, 230},
  {0x1e006, 230},
  {0x1e008, 230},
  {0x1e009, 230},
  {0x1e00a, 230},
  {0x1e00b, 230},
  {0x1e00c, 230},
  {0x1e00d, 230},
  {0x1e00e, 230},
  {0x1e00f, 230},
  {0x1e010, 230},
  {0x1e011, 230},
  {0x1e012, 230},
  {0x1e013, 230},
  {0x1e014, 230},
  {0x1e015, 230},
  {0x1e016, 230},
  {0x1e017, 230},
  {0x1e018, 230},
  {0x1e01b, 230},
  {0x1e01c, 230},
  {0x1e01d, 230},
  {0x1e01e, 230},
  {0x1e01f, 230},
  {0x1e020, 230},
  {0x1e021, 230},
  {0x1e023, 230},
  {0x1e024, 230},
  {0x1e026, 230},
  {0x1e027, 230},
  {0x1e028, 230},
  {0x1e029, 230},
  {0x1e02a, 230},
  {0x1e08f, 230},
  {0x1e130, 230},
  {0x1e131, 230},
  {0x1e132, 230},
  {0x1e133, 230},
  {0x1e134, 230},
  {0x1e135, 230},
  {0x1e136, 230},
  {0x1e2ae, 230},
  {0x1e2ec, 230},
  {0x1e2ed, 230},
  {0x1e2ee, 230},
  {0x1e2ef, 230},
  {0x1e4ec, 232},
  {0x1e4ed, 232},
  {0x1e4ee, 220},
  {0x1e4ef, 230},
  {0x1e8d0, 220},
  {0x1e8d1, 220},
  {0x1e8d2, 220},
  {0x1e8d3, 220},
  {0x1e8d4, 220},
  {0x1e8d5, 220},
  {0x1e8d6, 220},
  {0x1e944, 230},
  {0x1e945, 230},
  {0x1e946, 230},
  {0x1e947, 230},
  {0x1e948, 230},
  {0x1e949, 230},
  {0x1e94a, 7},
  // clang-format on
};

const std::array<std::pair<uint32_t, uint32_t>, NUM_ALPHABETIC_RANGES>
  ALPHABETIC_RANGES = {{
    // clang-format off
  {0x0041, 0x005b},
  {0x0061, 0x007b},
  {0x00aa, 0x00ab},
  {0x00b5, 0x00b6},
  {0x00ba, 0x00bb},
  {0x00c0, 0x00d7},
  {0x00d8, 0x00f7},
  {0x00f8, 0x01bb},
  {0x01bb, 0x01bc},
  {0x01bc, 0x01c0},
  {0x01c0, 0x01c4},
  {0x01c4, 0x0294},
  {0x0294, 0x0295},
  {0x0295, 0x02b0},
  {0x02b0, 0x02c2},
  {0x02c6, 0x02d2},
  {0x02e0, 0x02e5},
  {0x02ec, 0x02ed},
  {0x02ee, 0x02ef},
  {0x0345, 0x0346},
  {0x0370, 0x0374},
  {0x0374, 0x0375},
  {0x0376, 0x0378},
  {0x037a, 0x037b},
  {0x037b, 0x037e},
  {0x037f, 0x0380},
  {0x0386, 0x0387},
  {0x0388, 0x038b},
  {0x038c, 0x038d},
  {0x038e, 0x03a2},
  {0x03a3, 0x03f6},
  {0x03f7, 0x0482},
  {0x048a, 0x0530},
  {0x0531, 0x0557},
  {0x0559, 0x055a},
  {0x0560, 0x0589},
  {0x05b0, 0x05be},
  {0x05bf, 0x05c0},
  {0x05c1, 0x05c3},
  {0x05c4, 0x05c6},
  {0x05c7, 0x05c8},
  {0x05d0, 0x05eb},
  {0x05ef, 0x05f3},
  {0x0610, 0x061b},
  {0x0620, 0x0640},
  {0x0640, 0x0641},
  {0x0641, 0x064b},
  {0x064b, 0x0658},
  {0x0659, 0x0660},
  {0x066e, 0x0670},
  {0x0670, 0x0671},
  {0x0671, 0x06d4},
  {0x06d5, 0x06d6},
  {0x06d6, 0x06dd},
  {0x06e1, 0x06e5},
  {0x06e5, 0x06e7},
  {0x06e7, 0x06e9},
  {0x06ed, 0x06ee},
  {0x06ee, 0x06f0},
  {0x06fa, 0x06fd},
  {0x06ff, 0x0700},
  {0x0710, 0x0711},
  {0x0711, 0x0712},
  {0x0712, 0x0730},
  {0x0730, 0x0740},
  {0x074d, 0x07a6},
  {0x07a6, 0x07b1},
  {0x07b1, 0x07b2},
  {0x07ca, 0x07eb},
  {0x07f4, 0x07f6},
  {0x07fa, 0x07fb},
  {0x0800, 0x0816},
  {0x0816, 0x0818},
  {0x081a, 0x081b},
  {0x081b, 0x0824},
  {0x0824, 0x0825},
  {0x0825, 0x0828},
  {0x0828, 0x0829},
  {0x0829, 0x082d},
  {0x0840, 0x0859},
  {0x0860, 0x086b},
  {0x0870, 0x0888},
  {0x0889, 0x088f},
  {0x08a0, 0x08c9},
  {0x08c9, 0x08ca},
  {0x08d4, 0x08e0},
  {0x08e3, 0x08ea},
  {0x08f0, 0x0903},
  {0x0903, 0x0904},
  {0x0904, 0x093a},
  {0x093a, 0x093b},
  {0x093b, 0x093c},
  {0x093d, 0x093e},
  {0x093e, 0x0941},
  {0x0941, 0x0949},
  {0x0949, 0x094d},
  {0x094e, 0x0950},
  {0x0950, 0x0951},
  {0x0955, 0x0958},
  {0x0958, 0x0962},
  {0x0962, 0x0964},
  {0x0971, 0x0972},
  {0x0972, 0x0981},
  {0x0981, 0x0982},
  {0x0982, 0x0984},
  {0x0985, 0x098d},
  {0x098f, 0x0991},
  {0x0993, 0x09a9},
  {0x09aa, 0x09b1},
  {0x09b2, 0x09b3},
  {0x09b6, 0x09ba},
  {0x09bd, 0x09be},
  {0x09be, 0x09c1},
  {0x09c1, 0x09c5},
  {0x09c7, 0x09c9},
  {0x09cb, 0x09cd},
  {0x09ce, 0x09cf},
  {0x09d7, 0x09d8},
  {0x09dc, 0x09de},
  {0x09df, 0x09e2},
  {0x09e2, 0x09e4},
  {0x09f0, 0x09f2},
  {0x09fc, 0x09fd},
  {0x0a01, 0x0a03},
  {0x0a03, 0x0a04},
  {0x0a05, 0x0a0b},
  {0x0a0f, 0x0a11},
  {0x0a13, 0x0a29},
  {0x0a2a, 0x0a31},
  {0x0a32, 0x0a34},
  {0x0a35, 0x0a37},
  {0x0a38, 0x0a3a},
  {0x0a3e, 0x0a41},
  {0x0a41, 0x0a43},
  {0x0a47, 0x0a49},
  {0x0a4b, 0x0a4d},
  {0x0a51, 0x0a52},
  {0x0a59, 0x0a5d},
  {0x0a5e, 0x0a5f},
  {0x0a70, 0x0a72},
  {0x0a72, 0x0a75},
  {0x0a75, 0x0a76},
  {0x0a81, 0x0a83},
  {0x0a83, 0x0a84},
  {0x0a85, 0x0a8e},
  {0x0a8f, 0x0a92},
  {0x0a93, 0x0aa9},
  {0x0aaa, 0x0ab1},
  {0x0ab2, 0x0ab4},
  {0x0ab5, 0x0aba},
  {0x0abd, 0x0abe},
  {0x0abe, 0x0ac1},
  {0x0ac1, 0x0ac6},
  {0x0ac7, 0x0ac9},
  {0x0ac9, 0x0aca},
  {0x0acb, 0x0acd},
  {0x0ad0, 0x0ad1},
  {0x0ae0, 0x0ae2},
  {0x0ae2, 0x0ae4},
  {0x0af9, 0x0afa},
  {0x0afa, 0x0afd},
  {0x0b01, 0x0b02},
  {0x0b02, 0x0b04},
  {0x0b05, 0x0b0d},
  {0x0b0f, 0x0b11},
  {0x0b13, 0x0b29},
  {0x0b2a, 0x0b31},
  {0x0b32, 0x0b34},
  {0x0b35, 0x0b3a},
  {0x0b3d, 0x0b3e},
  {0x0b3e, 0x0b3f},
  {0x0b3f, 0x0b40},
  {0x0b40, 0x0b41},
  {0x0b41, 0x0b45},
  {0x0b47, 0x0b49},
  {0x0b4b, 0x0b4d},
  {0x0b56, 0x0b57},
  {0x0b57, 0x0b58},
  {0x0b5c, 0x0b5e},
  {0x0b5f, 0x0b62},
  {0x0b62, 0x0b64},
  {0x0b71, 0x0b72},
  {0x0b82, 0x0b83},
  {0x0b83, 0x0b84},
  {0x0b85, 0x0b8b},
  {0x0b8e, 0x0b91},
  {0x0b92, 0x0b96},
  {0x0b99, 0x0b9b},
  {0x0b9c, 0x0b9d},
  {0x0b9e, 0x0ba0},
  {0x0ba3, 0x0ba5},
  {0x0ba8, 0x0bab},
  {0x0bae, 0x0bba},
  {0x0bbe, 0x0bc0},
  {0x0bc0, 0x0bc1},
  {0x0bc1, 0x0bc3},
  {0x0bc6, 0x0bc9},
  {0x0bca, 0x0bcd},
  {0x0bd0, 0x0bd1},
  {0x0bd7, 0x0bd8},
  {0x0c00, 0x0c01},
  {0x0c01, 0x0c04},
  {0x0c04, 0x0c05},
  {0x0c05, 0x0c0d},
  {0x0c0e, 0x0c11},
  {0x0c12, 0x0c29},
  {0x0c2a, 0x0c3a},
  {0x0c3d, 0x0c3e},
  {0x0c3e, 0x0c41},
  {0x0c41, 0x0c45},
  {0x0c46, 0x0c49},
  {0x0c4a, 0x0c4d},
  {0x0c55, 0x0c57},
  {0x0c58, 0x0c5b},
  {0x0c5d, 0x0c5e},
  {0x0c60, 0x0c62},
  {0x0c62, 0x0c64},
  {0x0c80, 0x0c81},
  {0x0c81, 0x0c82},
  {0x0c82, 0x0c84},
  {0x0c85, 0x0c8d},
  {0x0c8e, 0x0c91},
  {0x0c92, 0x0ca9},
  {0x0caa, 0x0cb4},
  {0x0cb5, 0x0cba},
  {0x0cbd, 0x0cbe},
  {0x0cbe, 0x0cbf},
  {0x0cbf, 0x0cc0},
  {0x0cc0, 0x0cc5},
  {0x0cc6, 0x0cc7},
  {0x0cc7, 0x0cc9},
  {0x0cca, 0x0ccc},
  {0x0ccc, 0x0ccd},
  {0x0cd5, 0x0cd7},
  {0x0cdd, 0x0cdf},
  {0x0ce0, 0x0ce2},
  {0x0ce2, 0x0ce4},
  {0x0cf1, 0x0cf3},
  {0x0cf3, 0x0cf4},
  {0x0d00, 0x0d02},
  {0x0d02, 0x0d04},
  {0x0d04, 0x0d0d},
  {0x0d0e, 0x0d11},
  {0x0d12, 0x0d3b},
  {0x0d3d, 0x0d3e},
  {0x0d3e, 0x0d41},
  {0x0d41, 0x0d45},
  {0x0d46, 0x0d49},
  {0x0d4a, 0x0d4d},
  {0x0d4e, 0x0d4f},
  {0x0d54, 0x0d57},
  {0x0d57, 0x0d58},
  {0x0d5f, 0x0d62},
  {0x0d62, 0x0d64},
  {0x0d7a, 0x0d80},
  {0x0d81, 0x0d82},
  {0x0d82, 0x0d84},
  {0x0d85, 0x0d97},
  {0x0d9a, 0x0db2},
  {0x0db3, 0x0dbc},
  {0x0dbd, 0x0dbe},
  {0x0dc0, 0x0dc7},
  {0x0dcf, 0x0dd2},
  {0x0dd2, 0x0dd5},
  {0x0dd6, 0x0dd7},
  {0x0dd8, 0x0de0},
  {0x0df2, 0x0df4},
  {0x0e01, 0x0e31},
  {0x0e31, 0x0e32},
  {0x0e32, 0x0e34},
  {0x0e34, 0x0e3b},
  {0x0e40, 0x0e46},
  {0x0e46, 0x0e47},
  {0x0e4d, 0x0e4e},
  {0x0e81, 0x0e83},
  {0x0e84, 0x0e85},
  {0x0e86, 0x0e8b},
  {0x0e8c, 0x0ea4},
  {0x0ea5, 0x0ea6},
  {0x0ea7, 0x0eb1},
  {0x0eb1, 0x0eb2},
  {0x0eb2, 0x0eb4},
  {0x0eb4, 0x0eba},
  {0x0ebb, 0x0ebd},
  {0x0ebd, 0x0ebe},
  {0x0ec0, 0x0ec5},
  {0x0ec6, 0x0ec7},
  {0x0ecd, 0x0ece},
  {0x0edc, 0x0ee0},
  {0x0f00, 0x0f01},
  {0x0f40, 0x0f48},
  {0x0f49, 0x0f6d},
  {0x0f71, 0x0f7f},
  {0x0f7f, 0x0f80},
  {0x0f80, 0x0f84},
  {0x0f88, 0x0f8d},
  {0x0f8d, 0x0f98},
  {0x0f99, 0x0fbd},
  {0x1000, 0x102b},
  {0x102b, 0x102d},
  {0x102d, 0x1031},
  {0x1031, 0x1032},
  {0x1032, 0x1037},
  {0x1038, 0x1039},
  {0x103b, 0x103d},
  {0x103d, 0x103f},
  {0x103f, 0x1040},
  {0x1050, 0x1056},
  {0x1056, 0x1058},
  {0x1058, 0x105a},
  {0x105a, 0x105e},
  {0x105e, 0x1061},
  {0x1061, 0x1062},
  {0x1062, 0x1065},
  {0x1065, 0x1067},
  {0x1067, 0x106e},
  {0x106e, 0x1071},
  {0x1071, 0x1075},
  {0x1075, 0x1082},
  {0x1082, 0x1083},
  {0x1083, 0x1085},
  {0x1085, 0x1087},
  {0x1087, 0x108d},
  {0x108d, 0x108e},
  {0x108e, 0x108f},
  {0x108f, 0x1090},
  {0x109a, 0x109d},
  {0x109d, 0x109e},
  {0x10a0, 0x10c6},
  {0x10c7, 0x10c8},
  {0x10cd, 0x10ce},
  {0x10d0, 0x10fb},
  {0x10fc, 0x10fd},
  {0x10fd, 0x1100},
  {0x1100, 0x1249},
  {0x124a, 0x124e},
  {0x1250, 0x1257},
  {0x1258, 0x1259},
  {0x125a, 0x125e},
  {0x1260, 0x1289},
  {0x128a, 0x128e},
  {0x1290, 0x12b1},
  {0x12b2, 0x12b6},
  {0x12b8, 0x12bf},
  {0x12c0, 0x12c1},
  {0x12c2, 0x12c6},
  {0x12c8, 0x12d7},
  {0x12d8, 0x1311},
  {0x1312, 0x1316},
  {0x1318, 0x135b},
  {0x1380, 0x1390},
  {0x13a0, 0x13f6},
  {0x13f8, 0x13fe},
  {0x1401, 0x166d},
  {0x166f, 0x1680},
  {0x1681, 0x169b},
  {0x16a0, 0x16eb},
  {0x16ee, 0x16f1},
  {0x16f1, 0x16f9},
  {0x1700, 0x1712},
  {0x1712, 0x1714},
  {0x171f, 0x1732},
  {0x1732, 0x1734},
  {0x1740, 0x1752},
  {0x1752, 0x1754},
  {0x1760, 0x176d},
  {0x176e, 0x1771},
  {0x1772, 0x1774},
  {0x1780, 0x17b4},
  {0x17b6, 0x17b7},
  {0x17b7, 0x17be},
  {0x17be, 0x17c6},
  {0x17c6, 0x17c7},
  {0x17c7, 0x17c9},
  {0x17d7, 0x17d8},
  {0x17dc, 0x17dd},
  {0x1820, 0x1843},
  {0x1843, 0x1844},
  {0x1844, 0x1879},
  {0x1880, 0x1885},
  {0x1885, 0x1887},
  {0x1887, 0x18a9},
  {0x18a9, 0x18aa},
  {0x18aa, 0x18ab},
  {0x18b0, 0x18f6},
  {0x1900, 0x191f},
  {0x1920, 0x1923},
  {0x1923, 0x1927},
  {0x1927, 0x1929},
  {0x1929, 0x192c},
  {0x1930, 0x1932},
  {0x1932, 0x1933},
  {0x1933, 0x1939},
  {0x1950, 0x196e},
  {0x1970, 0x1975},
  {0x1980, 0x19ac},
  {0x19b0, 0x19ca},
  {0x1a00, 0x1a17},
  {0x1a17, 0x1a19},
  {0x1a19, 0x1a1b},
  {0x1a1b, 0x1a1c},
  {0x1a20, 0x1a55},
  {0x1a55, 0x1a56},
  {0x1a56, 0x1a57},
  {0x1a57, 0x1a58},
  {0x1a58, 0x1a5f},
  {0x1a61, 0x1a62},
  {0x1a62, 0x1a63},
  {0x1a63, 0x1a65},
  {0x1a65, 0x1a6d},
  {0x1a6d, 0x1a73},
  {0x1a73, 0x1a75},
  {0x1aa7, 0x1aa8},
  {0x1abf, 0x1ac1},
  {0x1acc, 0x1acf},
  {0x1b00, 0x1b04},
  {0x1b04, 0x1b05},
  {0x1b05, 0x1b34},
  {0x1b35, 0x1b36},
  {0x1b36, 0x1b3b},
  {0x1b3b, 0x1b3c},
  {0x1b3c, 0x1b3d},
  {0x1b3d, 0x1b42},
  {0x1b42, 0x1b43},
  {0x1b43, 0x1b44},
  {0x1b45, 0x1b4d},
  {0x1b80, 0x1b82},
  {0x1b82, 0x1b83},
  {0x1b83, 0x1ba1},
  {0x1ba1, 0x1ba2},
  {0x1ba2, 0x1ba6},
  {0x1ba6, 0x1ba8},
  {0x1ba8, 0x1baa},
  {0x1bac, 0x1bae},
  {0x1bae, 0x1bb0},
  {0x1bba, 0x1be6},
  {0x1be7, 0x1be8},
  {0x1be8, 0x1bea},
  {0x1bea, 0x1bed},
  {0x1bed, 0x1bee},
  {0x1bee, 0x1bef},
  {0x1bef, 0x1bf2},
  {0x1c00, 0x1c24},
  {0x1c24, 0x1c2c},
  {0x1c2c, 0x1c34},
  {0x1c34, 0x1c36},
  {0x1c36, 0x1c37},
  {0x1c4d, 0x1c50},
  {0x1c5a, 0x1c78},
  {0x1c78, 0x1c7e},
  {0x1c80, 0x1c89},
  {0x1c90, 0x1cbb},
  {0x1cbd, 0x1cc0},
  {0x1ce9, 0x1ced},
  {0x1cee, 0x1cf4},
  {0x1cf5, 0x1cf7},
  {0x1cfa, 0x1cfb},
  {0x1d00, 0x1d2c},
  {0x1d2c, 0x1d6b},
  {0x1d6b, 0x1d78},
  {0x1d78, 0x1d79},
  {0x1d79, 0x1d9b},
  {0x1d9b, 0x1dc0},
  {0x1de7, 0x1df5},
  {0x1e00, 0x1f16},
  {0x1f18, 0x1f1e},
  {0x1f20, 0x1f46},
  {0x1f48, 0x1f4e},
  {0x1f50, 0x1f58},
  {0x1f59, 0x1f5a},
  {0x1f5b, 0x1f5c},
  {0x1f5d, 0x1f5e},
  {0x1f5f, 0x1f7e},
  {0x1f80, 0x1fb5},
  {0x1fb6, 0x1fbd},
  {0x1fbe, 0x1fbf},
  {0x1fc2, 0x1fc5},
  {0x1fc6, 0x1fcd},
  {0x1fd0, 0x1fd4},
  {0x1fd6, 0x1fdc},
  {0x1fe0, 0x1fed},
  {0x1ff2, 0x1ff5},
  {0x1ff6, 0x1ffd},
  {0x2071, 0x2072},
  {0x207f, 0x2080},
  {0x2090, 0x209d},
  {0x2102, 0x2103},
  {0x2107, 0x2108},
  {0x210a, 0x2114},
  {0x2115, 0x2116},
  {0x2119, 0x211e},
  {0x2124, 0x2125},
  {0x2126, 0x2127},
  {0x2128, 0x2129},
  {0x212a, 0x212e},
  {0x212f, 0x2135},
  {0x2135, 0x2139},
  {0x2139, 0x213a},
  {0x213c, 0x2140},
  {0x2145, 0x214a},
  {0x214e, 0x214f},
  {0x2160, 0x2183},
  {0x2183, 0x2185},
  {0x2185, 0x2189},
  {0x24b6, 0x24ea},
  {0x2c00, 0x2c7c},
  {0x2c7c, 0x2c7e},
  {0x2c7e, 0x2ce5},
  {0x2ceb, 0x2cef},
  {0x2cf2, 0x2cf4},
  {0x2d00, 0x2d26},
  {0x2d27, 0x2d28},
  {0x2d2d, 0x2d2e},
  {0x2d30, 0x2d68},
  {0x2d6f, 0x2d70},
  {0x2d80, 0x2d97},
  {0x2da0, 0x2da7},
  {0x2da8, 0x2daf},
  {0x2db0, 0x2db7},
  {0x2db8, 0x2dbf},
  {0x2dc0, 0x2dc7},
  {0x2dc8, 0x2dcf},
  {0x2dd0, 0x2dd7},
  {0x2dd8, 0x2ddf},
  {0x2de0, 0x2e00},
  {0x2e2f, 0x2e30},
  {0x3005, 0x3006},
  {0x3006, 0x3007},
  {0x3007, 0x3008},
  {0x3021, 0x302a},
  {0x3031, 0x3036},
  {0x3038, 0x303b},
  {0x303b, 0x303c},
  {0x303c, 0x303d},
  {0x3041, 0x3097},
  {0x309d, 0x309f},
  {0x309f, 0x30a0},
  {0x30a1, 0x30fb},
  {0x30fc, 0x30ff},
  {0x30ff, 0x3100},
  {0x3105, 0x3130},
  {0x3131, 0x318f},
  {0x31a0, 0x31c0},
  {0x31f0, 0x3200},
  {0x3400, 0x4dc0},
  {0x4e00, 0xa015},
  {0xa015, 0xa016},
  {0xa016, 0xa48d},
  {0xa4d0, 0xa4f8},
  {0xa4f8, 0xa4fe},
  {0xa500, 0xa60c},
  {0xa60c, 0xa60d},
  {0xa610, 0xa620},
  {0xa62a, 0xa62c},
  {0xa640, 0xa66e},
  {0xa66e, 0xa66f},
  {0xa674, 0xa67c},
  {0xa67f, 0xa680},
  {0xa680, 0xa69c},
  {0xa69c, 0xa69e},
  {0xa69e, 0xa6a0},
  {0xa6a0, 0xa6e6},
  {0xa6e6, 0xa6f0},
  {0xa717, 0xa720},
  {0xa722, 0xa770},
  {0xa770, 0xa771},
  {0xa771, 0xa788},
  {0xa788, 0xa789},
  {0xa78b, 0xa78f},
  {0xa78f, 0xa790},
  {0xa790, 0xa7cb},
  {0xa7d0, 0xa7d2},
  {0xa7d3, 0xa7d4},
  {0xa7d5, 0xa7da},
  {0xa7f2, 0xa7f5},
  {0xa7f5, 0xa7f7},
  {0xa7f7, 0xa7f8},
  {0xa7f8, 0xa7fa},
  {0xa7fa, 0xa7fb},
  {0xa7fb, 0xa802},
  {0xa802, 0xa803},
  {0xa803, 0xa806},
  {0xa807, 0xa80b},
  {0xa80b, 0xa80c},
  {0xa80c, 0xa823},
  {0xa823, 0xa825},
  {0xa825, 0xa827},
  {0xa827, 0xa828},
  {0xa840, 0xa874},
  {0xa880, 0xa882},
  {0xa882, 0xa8b4},
  {0xa8b4, 0xa8c4},
  {0xa8c5, 0xa8c6},
  {0xa8f2, 0xa8f8},
  {0xa8fb, 0xa8fc},
  {0xa8fd, 0xa8ff},
  {0xa8ff, 0xa900},
  {0xa90a, 0xa926},
  {0xa926, 0xa92b},
  {0xa930, 0xa947},
  {0xa947, 0xa952},
  {0xa952, 0xa953},
  {0xa960, 0xa97d},
  {0xa980, 0xa983},
  {0xa983, 0xa984},
  {0xa984, 0xa9b3},
  {0xa9b4, 0xa9b6},
  {0xa9b6, 0xa9ba},
  {0xa9ba, 0xa9bc},
  {0xa9bc, 0xa9be},
  {0xa9be, 0xa9c0},
  {0xa9cf, 0xa9d0},
  {0xa9e0, 0xa9e5},
  {0xa9e5, 0xa9e6},
  {0xa9e6, 0xa9e7},
  {0xa9e7, 0xa9f0},
  {0xa9fa, 0xa9ff},
  {0xaa00, 0xaa29},
  {0xaa29, 0xaa2f},
  {0xaa2f, 0xaa31},
  {0xaa31, 0xaa33},
  {0xaa33, 0xaa35},
  {0xaa35, 0xaa37},
  {0xaa40, 0xaa43},
  {0xaa43, 0xaa44},
  {0xaa44, 0xaa4c},
  {0xaa4c, 0xaa4d},
  {0xaa4d, 0xaa4e},
  {0xaa60, 0xaa70},
  {0xaa70, 0xaa71},
  {0xaa71, 0xaa77},
  {0xaa7a, 0xaa7b},
  {0xaa7b, 0xaa7c},
  {0xaa7c, 0xaa7d},
  {0xaa7d, 0xaa7e},
  {0xaa7e, 0xaab0},
  {0xaab0, 0xaab1},
  {0xaab1, 0xaab2},
  {0xaab2, 0xaab5},
  {0xaab5, 0xaab7},
  {0xaab7, 0xaab9},
  {0xaab9, 0xaabe},
  {0xaabe, 0xaabf},
  {0xaac0, 0xaac1},
  {0xaac2, 0xaac3},
  {0xaadb, 0xaadd},
  {0xaadd, 0xaade},
  {0xaae0, 0xaaeb},
  {0xaaeb, 0xaaec},
  {0xaaec, 0xaaee},
  {0xaaee, 0xaaf0},
  {0xaaf2, 0xaaf3},
  {0xaaf3, 0xaaf5},
  {0xaaf5, 0xaaf6},
  {0xab01, 0xab07},
  {0xab09, 0xab0f},
  {0xab11, 0xab17},
  {0xab20, 0xab27},
  {0xab28, 0xab2f},
  {0xab30, 0xab5b},
  {0xab5c, 0xab60},
  {0xab60, 0xab69},
  {0xab69, 0xab6a},
  {0xab70, 0xabc0},
  {0xabc0, 0xabe3},
  {0xabe3, 0xabe5},
  {0xabe5, 0xabe6},
  {0xabe6, 0xabe8},
  {0xabe8, 0xabe9},
  {0xabe9, 0xabeb},
  {0xac00, 0xd7a4},
  {0xd7b0, 0xd7c7},
  {0xd7cb, 0xd7fc},
  {0xf900, 0xfa6e},
  {0xfa70, 0xfada},
  {0xfb00, 0xfb07},
  {0xfb13, 0xfb18},
  {0xfb1d, 0xfb1e},
  {0xfb1e, 0xfb1f},
  {0xfb1f, 0xfb29},
  {0xfb2a, 0xfb37},
  {0xfb38, 0xfb3d},
  {0xfb3e, 0xfb3f},
  {0xfb40, 0xfb42},
  {0xfb43, 0xfb45},
  {0xfb46, 0xfbb2},
  {0xfbd3, 0xfd3e},
  {0xfd50, 0xfd90},
  {0xfd92, 0xfdc8},
  {0xfdf0, 0xfdfc},
  {0xfe70, 0xfe75},
  {0xfe76, 0xfefd},
  {0xff21, 0xff3b},
  {0xff41, 0xff5b},
  {0xff66, 0xff70},
  {0xff70, 0xff71},
  {0xff71, 0xff9e},
  {0xff9e, 0xffa0},
  {0xffa0, 0xffbf},
  {0xffc2, 0xffc8},
  {0xffca, 0xffd0},
  {0xffd2, 0xffd8},
  {0xffda, 0xffdd},
  {0x10000, 0x1000c},
  {0x1000d, 0x10027},
  {0x10028, 0x1003b},
  {0x1003c, 0x1003e},
  {0x1003f, 0x1004e},
  {0x10050, 0x1005e},
  {0x10080, 0x100fb},
  {0x10140, 0x10175},
  {0x10280, 0x1029d},
  {0x102a0, 0x102d1},
  {0x10300, 0x10320},
  {0x1032d, 0x10341},
  {0x10341, 0x10342},
  {0x10342, 0x1034a},
  {0x1034a, 0x1034b},
  {0x10350, 0x10376},
  {0x10376, 0x1037b},
  {0x10380, 0x1039e},
  {0x103a0, 0x103c4},
  {0x103c8, 0x103d0},
  {0x103d1, 0x103d6},
  {0x10400, 0x10450},
  {0x10450, 0x1049e},
  {0x104b0, 0x104d4},
  {0x104d8, 0x104fc},
  {0x10500, 0x10528},
  {0x10530, 0x10564},
  {0x10570, 0x1057b},
  {0x1057c, 0x1058b},
  {0x1058c, 0x10593},
  {0x10594, 0x10596},
  {0x10597, 0x105a2},
  {0x105a3, 0x105b2},
  {0x105b3, 0x105ba},
  {0x105bb, 0x105bd},
  {0x10600, 0x10737},
  {0x10740, 0x10756},
  {0x10760, 0x10768},
  {0x10780, 0x10786},
  {0x10787, 0x107b1},
  {0x107b2, 0x107bb},
  {0x10800, 0x10806},
  {0x10808, 0x10809},
  {0x1080a, 0x10836},
  {0x10837, 0x10839},
  {0x1083c, 0x1083d},
  {0x1083f, 0x10856},
  {0x10860, 0x10877},
  {0x10880, 0x1089f},
  {0x108e0, 0x108f3},
  {0x108f4, 0x108f6},
  {0x10900, 0x10916},
  {0x10920, 0x1093a},
  {0x10980, 0x109b8},
  {0x109be, 0x109c0},
  {0x10a00, 0x10a01},
  {0x10a01, 0x10a04},
  {0x10a05, 0x10a07},
  {0x10a0c, 0x10a10},
  {0x10a10, 0x10a14},
  {0x10a15, 0x10a18},
  {0x10a19, 0x10a36},
  {0x10a60, 0x10a7d},
  {0x10a80, 0x10a9d},
  {0x10ac0, 0x10ac8},
  {0x10ac9, 0x10ae5},
  {0x10b00, 0x10b36},
  {0x10b40, 0x10b56},
  {0x10b60, 0x10b73},
  {0x10b80, 0x10b92},
  {0x10c00, 0x10c49},
  {0x10c80, 0x10cb3},
  {0x10cc0, 0x10cf3},
  {0x10d00, 0x10d24},
  {0x10d24, 0x10d28},
  {0x10e80, 0x10eaa},
  {0x10eab, 0x10ead},
  {0x10eb0, 0x10eb2},
  {0x10f00, 0x10f1d},
  {0x10f27, 0x10f28},
  {0x10f30, 0x10f46},
  {0x10f70, 0x10f82},
  {0x10fb0, 0x10fc5},
  {0x10fe0, 0x10ff7},
  {0x11000, 0x11001},
  {0x11001, 0x11002},
  {0x11002, 0x11003},
  {0x11003, 0x11038},
  {0x11038, 0x11046},
  {0x11071, 0x11073},
  {0x11073, 0x11075},
  {0x11075, 0x11076},
  {0x11080, 0x11082},
  {0x11082, 0x11083},
  {0x11083, 0x110b0},
  {0x110b0, 0x110b3},
  {0x110b3, 0x110b7},
  {0x110b7, 0x110b9},
  {0x110c2, 0x110c3},
  {0x110d0, 0x110e9},
  {0x11100, 0x11103},
  {0x11103, 0x11127},
  {0x11127, 0x1112c},
  {0x1112c, 0x1112d},
  {0x1112d, 0x11133},
  {0x11144, 0x11145},
  {0x11145, 0x11147},
  {0x11147, 0x11148},
  {0x11150, 0x11173},
  {0x11176, 0x11177},
  {0x11180, 0x11182},
  {0x11182, 0x11183},
  {0x11183, 0x111b3},
  {0x111b3, 0x111b6},
  {0x111b6, 0x111bf},
  {0x111bf, 0x111c0},
  {0x111c1, 0x111c5},
  {0x111ce, 0x111cf},
  {0x111cf, 0x111d0},
  {0x111da, 0x111db},
  {0x111dc, 0x111dd},
  {0x11200, 0x11212},
  {0x11213, 0x1122c},
  {0x1122c, 0x1122f},
  {0x1122f, 0x11232},
  {0x11232, 0x11234},
  {0x11234, 0x11235},
  {0x11237, 0x11238},
  {0x1123e, 0x1123f},
  {0x1123f, 0x11241},
  {0x11241, 0x11242},
  {0x11280, 0x11287},
  {0x11288, 0x11289},
  {0x1128a, 0x1128e},
  {0x1128f, 0x1129e},
  {0x1129f, 0x112a9},
  {0x112b0, 0x112df},
  {0x112df, 0x112e0},
  {0x112e0, 0x112e3},
  {0x112e3, 0x112e9},
  {0x11300, 0x11302},
  {0x11302, 0x11304},
  {0x11305, 0x1130d},
  {0x1130f, 0x11311},
  {0x11313, 0x11329},
  {0x1132a, 0x11331},
  {0x11332, 0x11334},
  {0x11335, 0x1133a},
  {0x1133d, 0x1133e},
  {0x1133e, 0x11340},
  {0x11340, 0x11341},
  {0x11341, 0x11345},
  {0x11347, 0x11349},
  {0x1134b, 0x1134d},
  {0x11350, 0x11351},
  {0x11357, 0x11358},
  {0x1135d, 0x11362},
  {0x11362, 0x11364},
  {0x11400, 0x11435},
  {0x11435, 0x11438},
  {0x11438, 0x11440},
  {0x11440, 0x11442},
  {0x11443, 0x11445},
  {0x11445, 0x11446},
  {0x11447, 0x1144b},
  {0x1145f, 0x11462},
  {0x11480, 0x114b0},
  {0x114b0, 0x114b3},
  {0x114b3, 0x114b9},
  {0x114b9, 0x114ba},
  {0x114ba, 0x114bb},
  {0x114bb, 0x114bf},
  {0x114bf, 0x114c1},
  {0x114c1, 0x114c2},
  {0x114c4, 0x114c6},
  {0x114c7, 0x114c8},
  {0x11580, 0x115af},
  {0x115af, 0x115b2},
  {0x115b2, 0x115b6},
  {0x115b8, 0x115bc},
  {0x115bc, 0x115be},
  {0x115be, 0x115bf},
  {0x115d8, 0x115dc},
  {0x115dc, 0x115de},
  {0x11600, 0x11630},
  {0x11630, 0x11633},
  {0x11633, 0x1163b},
  {0x1163b, 0x1163d},
  {0x1163d, 0x1163e},
  {0x1163e, 0x1163f},
  {0x11640, 0x11641},
  {0x11644, 0x11645},
  {0x11680, 0x116ab},
  {0x116ab, 0x116ac},
  {0x116ac, 0x116ad},
  {0x116ad, 0x116ae},
  {0x116ae, 0x116b0},
  {0x116b0, 0x116b6},
  {0x116b8, 0x116b9},
  {0x11700, 0x1171b},
  {0x1171d, 0x11720},
  {0x11720, 0x11722},
  {0x11722, 0x11726},
  {0x11726, 0x11727},
  {0x11727, 0x1172b},
  {0x11740, 0x11747},
  {0x11800, 0x1182c},
  {0x1182c, 0x1182f},
  {0x1182f, 0x11838},
  {0x11838, 0x11839},
  {0x118a0, 0x118e0},
  {0x118ff, 0x11907},
  {0x11909, 0x1190a},
  {0x1190c, 0x11914},
  {0x11915, 0x11917},
  {0x11918, 0x11930},
  {0x11930, 0x11936},
  {0x11937, 0x11939},
  {0x1193b, 0x1193d},
  {0x1193f, 0x11940},
  {0x11940, 0x11941},
  {0x11941, 0x11942},
  {0x11942, 0x11943},
  {0x119a0, 0x119a8},
  {0x119aa, 0x119d1},
  {0x119d1, 0x119d4},
  {0x119d4, 0x119d8},
  {0x119da, 0x119dc},
  {0x119dc, 0x119e0},
  {0x119e1, 0x119e2},
  {0x119e3, 0x119e4},
  {0x119e4, 0x119e5},
  {0x11a00, 0x11a01},
  {0x11a01, 0x11a0b},
  {0x11a0b, 0x11a33},
  {0x11a35, 0x11a39},
  {0x11a39, 0x11a3a},
  {0x11a3a, 0x11a3b},
  {0x11a3b, 0x11a3f},
  {0x11a50, 0x11a51},
  {0x11a51, 0x11a57},
  {0x11a57, 0x11a59},
  {0x11a59, 0x11a5c},
  {0x11a5c, 0x11a8a},
  {0x11a8a, 0x11a97},
  {0x11a97, 0x11a98},
  {0x11a9d, 0x11a9e},
  {0x11ab0, 0x11af9},
  {0x11c00, 0x11c09},
  {0x11c0a, 0x11c2f},
  {0x11c2f, 0x11c30},
  {0x11c30, 0x11c37},
  {0x11c38, 0x11c3e},
  {0x11c3e, 0x11c3f},
  {0x11c40, 0x11c41},
  {0x11c72, 0x11c90},
  {0x11c92, 0x11ca8},
  {0x11ca9, 0x11caa},
  {0x11caa, 0x11cb1},
  {0x11cb1, 0x11cb2},
  {0x11cb2, 0x11cb4},
  {0x11cb4, 0x11cb5},
  {0x11cb5, 0x11cb7},
  {0x11d00, 0x11d07},
  {0x11d08, 0x11d0a},
  {0x11d0b, 0x11d31},
  {0x11d31, 0x11d37},
  {0x11d3a, 0x11d3b},
  {0x11d3c, 0x11d3e},
  {0x11d3f, 0x11d42},
  {0x11d43, 0x11d44},
  {0x11d46, 0x11d47},
  {0x11d47, 0x11d48},
  {0x11d60, 0x11d66},
  {0x11d67, 0x11d69},
  {0x11d6a, 0x11d8a},
  {0x11d8a, 0x11d8f},
  {0x11d90, 0x11d92},
  {0x11d93, 0x11d95},
  {0x11d95, 0x11d96},
  {0x11d96, 0x11d97},
  {0x11d98, 0x11d99},
  {0x11ee0, 0x11ef3},
  {0x11ef3, 0x11ef5},
  {0x11ef5, 0x11ef7},
  {0x11f00, 0x11f02},
  {0x11f02, 0x11f03},
  {0x11f03, 0x11f04},
  {0x11f04, 0x11f11},
  {0x11f12, 0x11f34},
  {0x11f34, 0x11f36},
  {0x11f36, 0x11f3b},
  {0x11f3e, 0x11f40},
  {0x11f40, 0x11f41},
  {0x11fb0, 0x11fb1},
  {0x12000, 0x1239a},
  {0x12400, 0x1246f},
  {0x12480, 0x12544},
  {0x12f90, 0x12ff1},
  {0x13000, 0x13430},
  {0x13441, 0x13447},
  {0x14400, 0x14647},
  {0x16800, 0x16a39},
  {0x16a40, 0x16a5f},
  {0x16a70, 0x16abf},
  {0x16ad0, 0x16aee},
  {0x16b00, 0x16b30},
  {0x16b40, 0x16b44},
  {0x16b63, 0x16b78},
  {0x16b7d, 0x16b90},
  {0x16e40, 0x16e80},
  {0x16f00, 0x16f4b},
  {0x16f4f, 0x16f50},
  {0x16f50, 0x16f51},
  {0x16f51, 0x16f88},
  {0x16f8f, 0x16f93},
  {0x16f93, 0x16fa0},
  {0x16fe0, 0x16fe2},
  {0x16fe3, 0x16fe4},
  {0x16ff0, 0x16ff2},
  {0x17000, 0x187f8},
  {0x18800, 0x18cd6},
  {0x18d00, 0x18d09},
  {0x1aff0, 0x1aff4},
  {0x1aff5, 0x1affc},
  {0x1affd, 0x1afff},
  {0x1b000, 0x1b123},
  {0x1b132, 0x1b133},
  {0x1b150, 0x1b153},
  {0x1b155, 0x1b156},
  {0x1b164, 0x1b168},
  {0x1b170, 0x1b2fc},
  {0x1bc00, 0x1bc6b},
  {0x1bc70, 0x1bc7d},
  {0x1bc80, 0x1bc89},
  {0x1bc90, 0x1bc9a},
  {0x1bc9e, 0x1bc9f},
  {0x1d400, 0x1d455},
  {0x1d456, 0x1d49d},
  {0x1d49e, 0x1d4a0},
  {0x1d4a2, 0x1d4a3},
  {0x1d4a5, 0x1d4a7},
  {0x1d4a9, 0x1d4ad},
  {0x1d4ae, 0x1d4ba},
  {0x1d4bb, 0x1d4bc},
  {0x1d4bd, 0x1d4c4},
  {0x1d4c5, 0x1d506},
  {0x1d507, 0x1d50b},
  {0x1d50d, 0x1d515},
  {0x1d516, 0x1d51d},
  {0x1d51e, 0x1d53a},
  {0x1d53b, 0x1d53f},
  {0x1d540, 0x1d545},
  {0x1d546, 0x1d547},
  {0x1d54a, 0x1d551},
  {0x1d552, 0x1d6a6},
  {0x1d6a8, 0x1d6c1},
  {0x1d6c2, 0x1d6db},
  {0x1d6dc, 0x1d6fb},
  {0x1d6fc, 0x1d715},
  {0x1d716, 0x1d735},
  {0x1d736, 0x1d74f},
  {0x1d750, 0x1d76f},
  {0x1d770, 0x1d789},
  {0x1d78a, 0x1d7a9},
  {0x1d7aa, 0x1d7c3},
  {0x1d7c4, 0x1d7cc},
  {0x1df00, 0x1df0a},
  {0x1df0a, 0x1df0b},
  {0x1df0b, 0x1df1f},
  {0x1df25, 0x1df2b},
  {0x1e000, 0x1e007},
  {0x1e008, 0x1e019},
  {0x1e01b, 0x1e022},
  {0x1e023, 0x1e025},
  {0x1e026, 0x1e02b},
  {0x1e030, 0x1e06e},
  {0x1e08f, 0x1e090},
  {0x1e100, 0x1e12d},
  {0x1e137, 0x1e13e},
  {0x1e14e, 0x1e14f},
  {0x1e290, 0x1e2ae},
  {0x1e2c0, 0x1e2ec},
  {0x1e4d0, 0x1e4eb},
  {0x1e4eb, 0x1e4ec},
  {0x1e7e0, 0x1e7e7},
  {0x1e7e8, 0x1e7ec},
  {0x1e7ed, 0x1e7ef},
  {0x1e7f0, 0x1e7ff},
  {0x1e800, 0x1e8c5},
  {0x1e900, 0x1e944},
  {0x1e947, 0x1e948},
  {0x1e94b, 0x1e94c},
  {0x1ee00, 0x1ee04},
  {0x1ee05, 0x1ee20},
  {0x1ee21, 0x1ee23},
  {0x1ee24, 0x1ee25},
  {0x1ee27, 0x1ee28},
  {0x1ee29, 0x1ee33},
  {0x1ee34, 0x1ee38},
  {0x1ee39, 0x1ee3a},
  {0x1ee3b, 0x1ee3c},
  {0x1ee42, 0x1ee43},
  {0x1ee47, 0x1ee48},
  {0x1ee49, 0x1ee4a},
  {0x1ee4b, 0x1ee4c},
  {0x1ee4d, 0x1ee50},
  {0x1ee51, 0x1ee53},
  {0x1ee54, 0x1ee55},
  {0x1ee57, 0x1ee58},
  {0x1ee59, 0x1ee5a},
  {0x1ee5b, 0x1ee5c},
  {0x1ee5d, 0x1ee5e},
  {0x1ee5f, 0x1ee60},
  {0x1ee61, 0x1ee63},
  {0x1ee64, 0x1ee65},
  {0x1ee67, 0x1ee6b},
  {0x1ee6c, 0x1ee73},
  {0x1ee74, 0x1ee78},
  {0x1ee79, 0x1ee7d},
  {0x1ee7e, 0x1ee7f},
  {0x1ee80, 0x1ee8a},
  {0x1ee8b, 0x1ee9c},
  {0x1eea1, 0x1eea4},
  {0x1eea5, 0x1eeaa},
  {0x1eeab, 0x1eebc},
  {0x1f130, 0x1f14a},
  {0x1f150, 0x1f16a},
  {0x1f170, 0x1f18a},
  {0x20000, 0x2a6e0},
  {0x2a700, 0x2b73a},
  {0x2b740, 0x2b81e},
  {0x2b820, 0x2cea2},
  {0x2ceb0, 0x2ebe1},
  {0x2ebf0, 0x2ee5e},
  {0x2f800, 0x2fa1e},
  {0x30000, 0x3134b},
  {0x31350, 0x323b0},
    // clang-format on
  }};

const std::array<uint32_t, NUM_NUMERIC_CODEPOINTS> NUMERIC_CODEPOINTS = {{
  // clang-format off
  0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x00b2, 0x00b3, 0x00b9, 0x00bc, 0x00bd, 0x00be,
  0x0660, 0x0661, 0x0662, 0x0663, 0x0664, 0x0665, 0x0666, 0x0667, 0x0668, 0x0669, 0x06f0, 0x06f1, 0x06f2, 0x06f3, 0x06f4, 0x06f5,
  0x06f6, 0x06f7, 0x06f8, 0x06f9, 0x07c0, 0x07c1, 0x07c2, 0x07c3, 0x07c4, 0x07c5, 0x07c6, 0x07c7, 0x07c8, 0x07c9, 0x0966, 0x0967,
  0x0968, 0x0969, 0x096a, 0x096b, 0x096c, 0x096d, 0x096e, 0x096f, 0x09e6, 0x09e7, 0x09e8, 0x09e9, 0x09ea, 0x09eb, 0x09ec, 0x09ed,
  0x09ee, 0x09ef, 0x09f4, 0x09f5, 0x09f6, 0x09f7, 0x09f8, 0x09f9, 0x0a66, 0x0a67, 0x0a68, 0x0a69, 0x0a6a, 0x0a6b, 0x0a6c, 0x0a6d,
  0x0a6e, 0x0a6f, 0x0ae6, 0x0ae7, 0x0ae8, 0x0ae9, 0x0aea, 0x0aeb, 0x0aec, 0x0aed, 0x0aee, 0x0aef, 0x0b66, 0x0b67, 0x0b68, 0x0b69,
  0x0b6a, 0x0b6b, 0x0b6c, 0x0b6d, 0x0b6e, 0x0b6f, 0x0b72, 0x0b73, 0x0b74, 0x0b75, 0x0b76, 0x0b77, 0x0be6, 0x0be7, 0x0be8, 0x0be9,
  0x0bea, 0x0beb, 0x0bec, 0x0bed, 0x0bee, 0x0bef, 0x0bf0, 0x0bf1, 0x0bf2, 0x0c66, 0x0c67, 0x0c68, 0x0c69, 0x0c6a, 0x0c6b, 0x0c6c,
  0x0c6d, 0x0c6e, 0x0c6f, 0x0c78, 0x0c79, 0x0c7a, 0x0c7b, 0x0c7c, 0x0c7d, 0x0c7e, 0x0ce6, 0x0ce7, 0x0ce8, 0x0ce9, 0x0cea, 0x0ceb,
  0x0cec, 0x0ced, 0x0cee, 0x0cef, 0x0d58, 0x0d59, 0x0d5a, 0x0d5b, 0x0d5c, 0x0d5d, 0x0d5e, 0x0d66, 0x0d67, 0x0d68, 0x0d69, 0x0d6a,
  0x0d6b, 0x0d6c, 0x0d6d, 0x0d6e, 0x0d6f, 0x0d70, 0x0d71, 0x0d72, 0x0d73, 0x0d74, 0x0d75, 0x0d76, 0x0d77, 0x0d78, 0x0de6, 0x0de7,
  0x0de8, 0x0de9, 0x0dea, 0x0deb, 0x0dec, 0x0ded, 0x0dee, 0x0def, 0x0e50, 0x0e51, 0x0e52, 0x0e53, 0x0e54, 0x0e55, 0x0e56, 0x0e57,
  0x0e58, 0x0e59, 0x0ed0, 0x0ed1, 0x0ed2, 0x0ed3, 0x0ed4, 0x0ed5, 0x0ed6, 0x0ed7, 0x0ed8, 0x0ed9, 0x0f20, 0x0f21, 0x0f22, 0x0f23,
  0x0f24, 0x0f25, 0x0f26, 0x0f27, 0x0f28, 0x0f29, 0x0f2a, 0x0f2b, 0x0f2c, 0x0f2d, 0x0f2e, 0x0f2f, 0x0f30, 0x0f31, 0x0f32, 0x0f33,
  0x1040, 0x1041, 0x1042, 0x1043, 0x1044, 0x1045, 0x1046, 0x1047, 0x1048, 0x1049, 0x1090, 0x1091, 0x1092, 0x1093, 0x1094, 0x1095,
  0x1096, 0x1097, 0x1098, 0x1099, 0x1369, 0x136a, 0x136b, 0x136c, 0x136d, 0x136e, 0x136f, 0x1370, 0x1371, 0x1372, 0x1373, 0x1374,
  0x1375, 0x1376, 0x1377, 0x1378, 0x1379, 0x137a, 0x137b, 0x137c, 0x16ee, 0x16ef, 0x16f0, 0x17e0, 0x17e1, 0x17e2, 0x17e3, 0x17e4,
  0x17e5, 0x17e6, 0x17e7, 0x17e8, 0x17e9, 0x17f0, 0x17f1, 0x17f2, 0x17f3, 0x17f4, 0x17f5, 0x17f6, 0x17f7, 0x17f8, 0x17f9, 0x1810,
  0x1811, 0x1812, 0x1813, 0x1814, 0x1815, 0x1816, 0x1817, 0x1818, 0x1819, 0x1946, 0x1947, 0x1948, 0x1949, 0x194a, 0x194b, 0x194c,
  0x194d, 0x194e, 0x194f, 0x19d0, 0x19d1, 0x19d2, 0x19d3, 0x19d4, 0x19d5, 0x19d6, 0x19d7, 0x19d8, 0x19d9, 0x19da, 0x1a80, 0x1a81,
  0x1a82, 0x1a83, 0x1a84, 0x1a85, 0x1a86, 0x1a87, 0x1a88, 0x1a89, 0x1a90, 0x1a91, 0x1a92, 0x1a93, 0x1a94, 0x1a95, 0x1a96, 0x1a97,
  0x1a98, 0x1a99, 0x1b50, 0x1b51, 0x1b52, 0x1b53, 0x1b54, 0x1b55, 0x1b56, 0x1b57, 0x1b58, 0x1b59, 0x1bb0, 0x1bb1, 0x1bb2, 0x1bb3,
  0x1bb4, 0x1bb5, 0x1bb6, 0x1bb7, 0x1bb8, 0x1bb9, 0x1c40, 0x1c41, 0x1c42, 0x1c43, 0x1c44, 0x1c45, 0x1c46, 0x1c47, 0x1c48, 0x1c49,
  0x1c50, 0x1c51, 0x1c52, 0x1c53, 0x1c54, 0x1c55, 0x1c56, 0x1c57, 0x1c58, 0x1c59, 0x2070, 0x2074, 0x2075, 0x2076, 0x2077, 0x2078,
  0x2079, 0x2080, 0x2081, 0x2082, 0x2083, 0x2084, 0x2085, 0x2086, 0x2087, 0x2088, 0x2089, 0x2150, 0x2151, 0x2152, 0x2153, 0x2154,
  0x2155, 0x2156, 0x2157, 0x2158, 0x2159, 0x215a, 0x215b, 0x215c, 0x215d, 0x215e, 0x215f, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164,
  0x2165, 0x2166, 0x2167, 0x2168, 0x2169, 0x216a, 0x216b, 0x216c, 0x216d, 0x216e, 0x216f, 0x2170, 0x2171, 0x2172, 0x2173, 0x2174,
  0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0x217a, 0x217b, 0x217c, 0x217d, 0x217e, 0x217f, 0x2180, 0x2181, 0x2182, 0x2185, 0x2186,
  0x2187, 0x2188, 0x2189, 0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467, 0x2468, 0x2469, 0x246a, 0x246b, 0x246c,
  0x246d, 0x246e, 0x246f, 0x2470, 0x2471, 0x2472, 0x2473, 0x2474, 0x2475, 0x2476, 0x2477, 0x2478, 0x2479, 0x247a, 0x247b, 0x247c,
  0x247d, 0x247e, 0x247f, 0x2480, 0x2481, 0x2482, 0x2483, 0x2484, 0x2485, 0x2486, 0x2487, 0x2488, 0x2489, 0x248a, 0x248b, 0x248c,
  0x248d, 0x248e, 0x248f, 0x2490, 0x2491, 0x2492, 0x2493, 0x2494, 0x2495, 0x2496, 0x2497, 0x2498, 0x2499, 0x249a, 0x249b, 0x24ea,
  0x24eb, 0x24ec, 0x24ed, 0x24ee, 0x24ef, 0x24f0, 0x24f1, 0x24f2, 0x24f3, 0x24f4, 0x24f5, 0x24f6, 0x24f7, 0x24f8, 0x24f9, 0x24fa,
  0x24fb, 0x24fc, 0x24fd, 0x24fe, 0x24ff, 0x2776, 0x2777, 0x2778, 0x2779, 0x277a, 0x277b, 0x277c, 0x277d, 0x277e, 0x277f, 0x2780,
  0x2781, 0x2782, 0x2783, 0x2784, 0x2785, 0x2786, 0x2787, 0x2788, 0x2789, 0x278a, 0x278b, 0x278c, 0x278d, 0x278e, 0x278f, 0x2790,
  0x2791, 0x2792, 0x2793, 0x2cfd, 0x3007, 0x3021, 0x3022, 0x3023, 0x3024, 0x3025, 0x3026, 0x3027, 0x3028, 0x3029, 0x3038, 0x3039,
  0x303a, 0x3192, 0x3193, 0x3194, 0x3195, 0x3220, 0x3221, 0x3222, 0x3223, 0x3224, 0x3225, 0x3226, 0x3227, 0x3228, 0x3229, 0x3248,
  0x3249, 0x324a, 0x324b, 0x324c, 0x324d, 0x324e, 0x324f, 0x3251, 0x3252, 0x3253, 0x3254, 0x3255, 0x3256, 0x3257, 0x3258, 0x3259,
  0x325a, 0x325b, 0x325c, 0x325d, 0x325e, 0x325f, 0x3280, 0x3281, 0x3282, 0x3283, 0x3284, 0x3285, 0x3286, 0x3287, 0x3288, 0x3289,
  0x32b1, 0x32b2, 0x32b3, 0x32b4, 0x32b5, 0x32b6, 0x32b7, 0x32b8, 0x32b9, 0x32ba, 0x32bb, 0x32bc, 0x32bd, 0x32be, 0x32bf, 0xa620,
  0xa621, 0xa622, 0xa623, 0xa624, 0xa625, 0xa626, 0xa627, 0xa628, 0xa629, 0xa6e6, 0xa6e7, 0xa6e8, 0xa6e9, 0xa6ea, 0xa6eb, 0xa6ec,
  0xa6ed, 0xa6ee, 0xa6ef, 0xa830, 0xa831, 0xa832, 0xa833, 0xa834, 0xa835, 0xa8d0, 0xa8d1, 0xa8d2, 0xa8d3, 0xa8d4, 0xa8d5, 0xa8d6,
  0xa8d7, 0xa8d8, 0xa8d9, 0xa900, 0xa901, 0xa902, 0xa903, 0xa904, 0xa905, 0xa906, 0xa907, 0xa908, 0xa909, 0xa9d0, 0xa9d1, 0xa9d2,
  0xa9d3, 0xa9d4, 0xa9d5, 0xa9d6, 0xa9d7, 0xa9d8, 0xa9d9, 0xa9f0, 0xa9f1, 0xa9f2, 0xa9f3, 0xa9f4, 0xa9f5, 0xa9f6, 0xa9f7, 0xa9f8,
  0xa9f9, 0xaa50, 0xaa51, 0xaa52, 0xaa53, 0xaa54, 0xaa55, 0xaa56, 0xaa57, 0xaa58, 0xaa59, 0xabf0, 0xabf1, 0xabf2, 0xabf3, 0xabf4,
  0xabf5, 0xabf6, 0xabf7, 0xabf8, 0xabf9, 0xff10, 0xff11, 0xff12, 0xff13, 0xff14, 0xff15, 0xff16, 0xff17, 0xff18, 0xff19, 0x10107,
  0x10108, 0x10109, 0x1010a, 0x1010b, 0x1010c, 0x1010d, 0x1010e, 0x1010f, 0x10110, 0x10111, 0x10112, 0x10113, 0x10114, 0x10115, 0x10116, 0x10117,
  0x10118, 0x10119, 0x1011a, 0x1011b, 0x1011c, 0x1011d, 0x1011e, 0x1011f, 0x10120, 0x10121, 0x10122, 0x10123, 0x10124, 0x10125, 0x10126, 0x10127,
  0x10128, 0x10129, 0x1012a, 0x1012b, 0x1012c, 0x1012d, 0x1012e, 0x1012f, 0x10130, 0x10131, 0x10132, 0x10133, 0x10140, 0x10141, 0x10142, 0x10143,
  0x10144, 0x10145, 0x10146, 0x10147, 0x10148, 0x10149, 0x1014a, 0x1014b, 0x1014c, 0x1014d, 0x1014e, 0x1014f, 0x10150, 0x10151, 0x10152, 0x10153,
  0x10154, 0x10155, 0x10156, 0x10157, 0x10158, 0x10159, 0x1015a, 0x1015b, 0x1015c, 0x1015d, 0x1015e, 0x1015f, 0x10160, 0x10161, 0x10162, 0x10163,
  0x10164, 0x10165, 0x10166, 0x10167, 0x10168, 0x10169, 0x1016a, 0x1016b, 0x1016c, 0x1016d, 0x1016e, 0x1016f, 0x10170, 0x10171, 0x10172, 0x10173,
  0x10174, 0x10175, 0x10176, 0x10177, 0x10178, 0x1018a, 0x1018b, 0x102e1, 0x102e2, 0x102e3, 0x102e4, 0x102e5, 0x102e6, 0x102e7, 0x102e8, 0x102e9,
  0x102ea, 0x102eb, 0x102ec, 0x102ed, 0x102ee, 0x102ef, 0x102f0, 0x102f1, 0x102f2, 0x102f3, 0x102f4, 0x102f5, 0x102f6, 0x102f7, 0x102f8, 0x102f9,
  0x102fa, 0x102fb, 0x10320, 0x10321, 0x10322, 0x10323, 0x10341, 0x1034a, 0x103d1, 0x103d2, 0x103d3, 0x103d4, 0x103d5, 0x104a0, 0x104a1, 0x104a2,
  0x104a3, 0x104a4, 0x104a5, 0x104a6, 0x104a7, 0x104a8, 0x104a9, 0x10858, 0x10859, 0x1085a, 0x1085b, 0x1085c, 0x1085d, 0x1085e, 0x1085f, 0x10879,
  0x1087a, 0x1087b, 0x1087c, 0x1087d, 0x1087e, 0x1087f, 0x108a7, 0x108a8, 0x108a9, 0x108aa, 0x108ab, 0x108ac, 0x108ad, 0x108ae, 0x108af, 0x108fb,
  0x108fc, 0x108fd, 0x108fe, 0x108ff, 0x10916, 0x10917, 0x10918, 0x10919, 0x1091a, 0x1091b, 0x109bc, 0x109bd, 0x109c0, 0x109c1, 0x109c2, 0x109c3,
  0x109c4, 0x109c5, 0x109c6, 0x109c7, 0x109c8, 0x109c9, 0x109ca, 0x109cb, 0x109cc, 0x109cd, 0x109ce, 0x109cf, 0x109d2, 0x109d3, 0x109d4, 0x109d5,
  0x109d6, 0x109d7, 0x109d8, 0x109d9, 0x109da, 0x109db, 0x109dc, 0x109dd, 0x109de, 0x109df, 0x109e0, 0x109e1, 0x109e2, 0x109e3, 0x109e4, 0x109e5,
  0x109e6, 0x109e7, 0x109e8, 0x109e9, 0x109ea, 0x109eb, 0x109ec, 0x109ed, 0x109ee, 0x109ef, 0x109f0, 0x109f1, 0x109f2, 0x109f3, 0x109f4, 0x109f5,
  0x109f6, 0x109f7, 0x109f8, 0x109f9, 0x109fa, 0x109fb, 0x109fc, 0x109fd, 0x109fe, 0x109ff, 0x10a40, 0x10a41, 0x10a42, 0x10a43, 0x10a44, 0x10a45,
  0x10a46, 0x10a47, 0x10a48, 0x10a7d, 0x10a7e, 0x10a9d, 0x10a9e, 0x10a9f, 0x10aeb, 0x10aec, 0x10aed, 0x10aee, 0x10aef, 0x10b58, 0x10b59, 0x10b5a,
  0x10b5b, 0x10b5c, 0x10b5d, 0x10b5e, 0x10b5f, 0x10b78, 0x10b79, 0x10b7a, 0x10b7b, 0x10b7c, 0x10b7d, 0x10b7e, 0x10b7f, 0x10ba9, 0x10baa, 0x10bab,
  0x10bac, 0x10bad, 0x10bae, 0x10baf, 0x10cfa, 0x10cfb, 0x10cfc, 0x10cfd, 0x10cfe, 0x10cff, 0x10d30, 0x10d31, 0x10d32, 0x10d33, 0x10d34, 0x10d35,
  0x10d36, 0x10d37, 0x10d38, 0x10d39, 0x10e60, 0x10e61, 0x10e62, 0x10e63, 0x10e64, 0x10e65, 0x10e66, 0x10e67, 0x10e68, 0x10e69, 0x10e6a, 0x10e6b,
  0x10e6c, 0x10e6d, 0x10e6e, 0x10e6f, 0x10e70, 0x10e71, 0x10e72, 0x10e73, 0x10e74, 0x10e75, 0x10e76, 0x10e77, 0x10e78, 0x10e79, 0x10e7a, 0x10e7b,
  0x10e7c, 0x10e7d, 0x10e7e, 0x10f1d, 0x10f1e, 0x10f1f, 0x10f20, 0x10f21, 0x10f22, 0x10f23, 0x10f24, 0x10f25, 0x10f26, 0x10f51, 0x10f52, 0x10f53,
  0x10f54, 0x10fc5, 0x10fc6, 0x10fc7, 0x10fc8, 0x10fc9, 0x10fca, 0x10fcb, 0x11052, 0x11053, 0x11054, 0x11055, 0x11056, 0x11057, 0x11058, 0x11059,
  0x1105a, 0x1105b, 0x1105c, 0x1105d, 0x1105e, 0x1105f, 0x11060, 0x11061, 0x11062, 0x11063, 0x11064, 0x11065, 0x11066, 0x11067, 0x11068, 0x11069,
  0x1106a, 0x1106b, 0x1106c, 0x1106d, 0x1106e, 0x1106f, 0x110f0, 0x110f1, 0x110f2, 0x110f3, 0x110f4, 0x110f5, 0x110f6, 0x110f7, 0x110f8, 0x110f9,
  0x11136, 0x11137, 0x11138, 0x11139, 0x1113a, 0x1113b, 0x1113c, 0x1113d, 0x1113e, 0x1113f, 0x111d0, 0x111d1, 0x111d2, 0x111d3, 0x111d4, 0x111d5,
  0x111d6, 0x111d7, 0x111d8, 0x111d9, 0x111e1, 0x111e2, 0x111e3, 0x111e4, 0x111e5, 0x111e6, 0x111e7, 0x111e8, 0x111e9, 0x111ea, 0x111eb, 0x111ec,
  0x111ed, 0x111ee, 0x111ef, 0x111f0, 0x111f1, 0x111f2, 0x111f3, 0x111f4, 0x112f0, 0x112f1, 0x112f2, 0x112f3, 0x112f4, 0x112f5, 0x112f6, 0x112f7,
  0x112f8, 0x112f9, 0x11450, 0x11451, 0x11452, 0x11453, 0x11454, 0x11455, 0x11456, 0x11457, 0x11458, 0x11459, 0x114d0, 0x114d1, 0x114d2, 0x114d3,
  0x114d4, 0x114d5, 0x114d6, 0x114d7, 0x114d8, 0x114d9, 0x11650, 0x11651, 0x11652, 0x11653, 0x11654, 0x11655, 0x11656, 0x11657, 0x11658, 0x11659,
  0x116c0, 0x116c1, 0x116c2, 0x116c3, 0x116c4, 0x116c5, 0x116c6, 0x116c7, 0x116c8, 0x116c9, 0x11730, 0x11731, 0x11732, 0x11733, 0x11734, 0x11735,
  0x11736, 0x11737, 0x11738, 0x11739, 0x1173a, 0x1173b, 0x118e0, 0x118e1, 0x118e2, 0x118e3, 0x118e4, 0x118e5, 0x118e6, 0x118e7, 0x118e8, 0x118e9,
  0x118ea, 0x118eb, 0x118ec, 0x118ed, 0x118ee, 0x118ef, 0x118f0, 0x118f1, 0x118f2, 0x11950, 0x11951, 0x11952, 0x11953, 0x11954, 0x11955, 0x11956,
  0x11957, 0x11958, 0x11959, 0x11c50, 0x11c51, 0x11c52, 0x11c53, 0x11c54, 0x11c55, 0x11c56, 0x11c57, 0x11c58, 0x11c59, 0x11c5a, 0x11c5b, 0x11c5c,
  0x11c5d, 0x11c5e, 0x11c5f, 0x11c60, 0x11c61, 0x11c62, 0x11c63, 0x11c64, 0x11c65, 0x11c66, 0x11c67, 0x11c68, 0x11c69, 0x11c6a, 0x11c6b, 0x11c6c,
  0x11d50, 0x11d51, 0x11d52, 0x11d53, 0x11d54, 0x11d55, 0x11d56, 0x11d57, 0x11d58, 0x11d59, 0x11da0, 0x11da1, 0x11da2, 0x11da3, 0x11da4, 0x11da5,
  0x11da6, 0x11da7, 0x11da8, 0x11da9, 0x11f50, 0x11f51, 0x11f52, 0x11f53, 0x11f54, 0x11f55, 0x11f56, 0x11f57, 0x11f58, 0x11f59, 0x11fc0, 0x11fc1,
  0x11fc2, 0x11fc3, 0x11fc4, 0x11fc5, 0x11fc6, 0x11fc7, 0x11fc8, 0x11fc9, 0x11fca, 0x11fcb, 0x11fcc, 0x11fcd, 0x11fce, 0x11fcf, 0x11fd0, 0x11fd1,
  0x11fd2, 0x11fd3, 0x11fd4, 0x12400, 0x12401, 0x12402, 0x12403, 0x12404, 0x12405, 0x12406, 0x12407, 0x12408, 0x12409, 0x1240a, 0x1240b, 0x1240c,
  0x1240d, 0x1240e, 0x1240f, 0x12410, 0x12411, 0x12412, 0x12413, 0x12414, 0x12415, 0x12416, 0x12417, 0x12418, 0x12419, 0x1241a, 0x1241b, 0x1241c,
  0x1241d, 0x1241e, 0x1241f, 0x12420, 0x12421, 0x12422, 0x12423, 0x12424, 0x12425, 0x12426, 0x12427, 0x12428, 0x12429, 0x1242a, 0x1242b, 0x1242c,
  0x1242d, 0x1242e, 0x1242f, 0x12430, 0x12431, 0x12432, 0x12433, 0x12434, 0x12435, 0x12436, 0x12437, 0x12438, 0x12439, 0x1243a, 0x1243b, 0x1243c,
  0x1243d, 0x1243e, 0x1243f, 0x12440, 0x12441, 0x12442, 0x12443, 0x12444, 0x12445, 0x12446, 0x12447, 0x12448, 0x12449, 0x1244a, 0x1244b, 0x1244c,
  0x1244d, 0x1244e, 0x1244f, 0x12450, 0x12451, 0x12452, 0x12453, 0x12454, 0x12455, 0x12456, 0x12457, 0x12458, 0x12459, 0x1245a, 0x1245b, 0x1245c,
  0x1245d, 0x1245e, 0x1245f, 0x12460, 0x12461, 0x12462, 0x12463, 0x12464, 0x12465, 0x12466, 0x12467, 0x12468, 0x12469, 0x1246a, 0x1246b, 0x1246c,
  0x1246d, 0x1246e, 0x16a60, 0x16a61, 0x16a62, 0x16a63, 0x16a64, 0x16a65, 0x16a66, 0x16a67, 0x16a68, 0x16a69, 0x16ac0, 0x16ac1, 0x16ac2, 0x16ac3,
  0x16ac4, 0x16ac5, 0x16ac6, 0x16ac7, 0x16ac8, 0x16ac9, 0x16b50, 0x16b51, 0x16b52, 0x16b53, 0x16b54, 0x16b55, 0x16b56, 0x16b57, 0x16b58, 0x16b59,
  0x16b5b, 0x16b5c, 0x16b5d, 0x16b5e, 0x16b5f, 0x16b60, 0x16b61, 0x16e80, 0x16e81, 0x16e82, 0x16e83, 0x16e84, 0x16e85, 0x16e86, 0x16e87, 0x16e88,
  0x16e89, 0x16e8a, 0x16e8b, 0x16e8c, 0x16e8d, 0x16e8e, 0x16e8f, 0x16e90, 0x16e91, 0x16e92, 0x16e93, 0x16e94, 0x16e95, 0x16e96, 0x1d2c0, 0x1d2c1,
  0x1d2c2, 0x1d2c3, 0x1d2c4, 0x1d2c5, 0x1d2c6, 0x1d2c7, 0x1d2c8, 0x1d2c9, 0x1d2ca, 0x1d2cb, 0x1d2cc, 0x1d2cd, 0x1d2ce, 0x1d2cf, 0x1d2d0, 0x1d2d1,
  0x1d2d2, 0x1d2d3, 0x1d2e0, 0x1d2e1, 0x1d2e2, 0x1d2e3, 0x1d2e4, 0x1d2e5, 0x1d2e6, 0x1d2e7, 0x1d2e8, 0x1d2e9, 0x1d2ea, 0x1d2eb, 0x1d2ec, 0x1d2ed,
  0x1d2ee, 0x1d2ef, 0x1d2f0, 0x1d2f1, 0x1d2f2, 0x1d2f3, 0x1d360, 0x1d361, 0x1d362, 0x1d363, 0x1d364, 0x1d365, 0x1d366, 0x1d367, 0x1d368, 0x1d369,
  0x1d36a, 0x1d36b, 0x1d36c, 0x1d36d, 0x1d36e, 0x1d36f, 0x1d370, 0x1d371, 0x1d372, 0x1d373, 0x1d374, 0x1d375, 0x1d376, 0x1d377, 0x1d378, 0x1d7ce,
  0x1d7cf, 0x1d7d0, 0x1d7d1, 0x1d7d2, 0x1d7d3, 0x1d7d4, 0x1d7d5, 0x1d7d6, 0x1d7d7, 0x1d7d8, 0x1d7d9, 0x1d7da, 0x1d7db, 0x1d7dc, 0x1d7dd, 0x1d7de,
  0x1d7df, 0x1d7e0, 0x1d7e1, 0x1d7e2, 0x1d7e3, 0x1d7e4, 0x1d7e5, 0x1d7e6, 0x1d7e7, 0x1d7e8, 0x1d7e9, 0x1d7ea, 0x1d7eb, 0x1d7ec, 0x1d7ed, 0x1d7ee,
  0x1d7ef, 0x1d7f0, 0x1d7f1, 0x1d7f2, 0x1d7f3, 0x1d7f4, 0x1d7f5, 0x1d7f6, 0x1d7f7, 0x1d7f8, 0x1d7f9, 0x1d7fa, 0x1d7fb, 0x1d7fc, 0x1d7fd, 0x1d7fe,
  0x1d7ff, 0x1e140, 0x1e141, 0x1e142, 0x1e143, 0x1e144, 0x1e145, 0x1e146, 0x1e147, 0x1e148, 0x1e149, 0x1e2f0, 0x1e2f1, 0x1e2f2, 0x1e2f3, 0x1e2f4,
  0x1e2f5, 0x1e2f6, 0x1e2f7, 0x1e2f8, 0x1e2f9, 0x1e4f0, 0x1e4f1, 0x1e4f2, 0x1e4f3, 0x1e4f4, 0x1e4f5, 0x1e4f6, 0x1e4f7, 0x1e4f8, 0x1e4f9, 0x1e8c7,
  0x1e8c8, 0x1e8c9, 0x1e8ca, 0x1e8cb, 0x1e8cc, 0x1e8cd, 0x1e8ce, 0x1e8cf, 0x1e950, 0x1e951, 0x1e952, 0x1e953, 0x1e954, 0x1e955, 0x1e956, 0x1e957,
  0x1e958, 0x1e959, 0x1ec71, 0x1ec72, 0x1ec73, 0x1ec74, 0x1ec75, 0x1ec76, 0x1ec77, 0x1ec78, 0x1ec79, 0x1ec7a, 0x1ec7b, 0x1ec7c, 0x1ec7d, 0x1ec7e,
  0x1ec7f, 0x1ec80, 0x1ec81, 0x1ec82, 0x1ec83, 0x1ec84, 0x1ec85, 0x1ec86, 0x1ec87, 0x1ec88, 0x1ec89, 0x1ec8a, 0x1ec8b, 0x1ec8c, 0x1ec8d, 0x1ec8e,
  0x1ec8f, 0x1ec90, 0x1ec91, 0x1ec92, 0x1ec93, 0x1ec94, 0x1ec95, 0x1ec96, 0x1ec97, 0x1ec98, 0x1ec99, 0x1ec9a, 0x1ec9b, 0x1ec9c, 0x1ec9d, 0x1ec9e,
  0x1ec9f, 0x1eca0, 0x1eca1, 0x1eca2, 0x1eca3, 0x1eca4, 0x1eca5, 0x1eca6, 0x1eca7, 0x1eca8, 0x1eca9, 0x1ecaa, 0x1ecab, 0x1ecad, 0x1ecae, 0x1ecaf,
  0x1ecb1, 0x1ecb2, 0x1ecb3, 0x1ecb4, 0x1ed01, 0x1ed02, 0x1ed03, 0x1ed04, 0x1ed05, 0x1ed06, 0x1ed07, 0x1ed08, 0x1ed09, 0x1ed0a, 0x1ed0b, 0x1ed0c,
  0x1ed0d, 0x1ed0e, 0x1ed0f, 0x1ed10, 0x1ed11, 0x1ed12, 0x1ed13, 0x1ed14, 0x1ed15, 0x1ed16, 0x1ed17, 0x1ed18, 0x1ed19, 0x1ed1a, 0x1ed1b, 0x1ed1c,
  0x1ed1d, 0x1ed1e, 0x1ed1f, 0x1ed20, 0x1ed21, 0x1ed22, 0x1ed23, 0x1ed24, 0x1ed25, 0x1ed26, 0x1ed27, 0x1ed28, 0x1ed29, 0x1ed2a, 0x1ed2b, 0x1ed2c,
  0x1ed2d, 0x1ed2f, 0x1ed30, 0x1ed31, 0x1ed32, 0x1ed33, 0x1ed34, 0x1ed35, 0x1ed36, 0x1ed37, 0x1ed38, 0x1ed39, 0x1ed3a, 0x1ed3b, 0x1ed3c, 0x1ed3d,
  0x1f100, 0x1f101, 0x1f102, 0x1f103, 0x1f104, 0x1f105, 0x1f106, 0x1f107, 0x1f108, 0x1f109, 0x1f10a, 0x1f10b, 0x1f10c, 0x1fbf0, 0x1fbf1, 0x1fbf2,
  0x1fbf3, 0x1fbf4, 0x1fbf5, 0x1fbf6, 0x1fbf7, 0x1fbf8, 0x1fbf9,
  // clang-format on
}};

const std::array<std::pair<uint32_t, uint32_t>, 74> NFC_QC_NO_RANGES = {{
  // clang-format off
  {0x0340, 0x0342},
  {0x0343, 0x0345},
  {0x0374, 0x0375},
  {0x037e, 0x037f},
  {0x0387, 0x0388},
  {0x0958, 0x0960},
  {0x09dc, 0x09de},
  {0x09df, 0x09e0},
  {0x0a33, 0x0a34},
  {0x0a36, 0x0a37},
  {0x0a59, 0x0a5c},
  {0x0a5e, 0x0a5f},
  {0x0b5c, 0x0b5e},
  {0x0f43, 0x0f44},
  {0x0f4d, 0x0f4e},
  {0x0f52, 0x0f53},
  {0x0f57, 0x0f58},
  {0x0f5c, 0x0f5d},
  {0x0f69, 0x0f6a},
  {0x0f73, 0x0f74},
  {0x0f75, 0x0f77},
  {0x0f78, 0x0f79},
  {0x0f81, 0x0f82},
  {0x0f93, 0x0f94},
  {0x0f9d, 0x0f9e},
  {0x0fa2, 0x0fa3},
  {0x0fa7, 0x0fa8},
  {0x0fac, 0x0fad},
  {0x0fb9, 0x0fba},
  {0x1f71, 0x1f72},
  {0x1f73, 0x1f74},
  {0x1f75, 0x1f76},
  {0x1f77, 0x1f78},
  {0x1f79, 0x1f7a},
  {0x1f7b, 0x1f7c},
  {0x1f7d, 0x1f7e},
  {0x1fbb, 0x1fbc},
  {0x1fbe, 0x1fbf},
  {0x1fc9, 0x1fca},
  {0x1fcb, 0x1fcc},
  {0x1fd3, 0x1fd4},
  {0x1fdb, 0x1fdc},
  {0x1fe3, 0x1fe4},
  {0x1feb, 0x1fec},
  {0x1fee, 0x1ff0},
  {0x1ff9, 0x1ffa},
  {0x1ffb, 0x1ffc},
  {0x1ffd, 0x1ffe},
  {0x2000, 0x2002},
  {0x2126, 0x2127},
  {0x212a, 0x212c},
  {0x2329, 0x232a},
  {0x232a, 0x232b},
  {0x2adc, 0x2add},
  {0xf900, 0xfa0e},
  {0xfa10, 0xfa11},
  {0xfa12, 0xfa13},
  {0xfa15, 0xfa1f},
  {0xfa20, 0xfa21},
  {0xfa22, 0xfa23},
  {0xfa25, 0xfa27},
  {0xfa2a, 0xfa6e},
  {0xfa70, 0xfada},
  {0xfb1d, 0xfb1e},
  {0xfb1f, 0xfb20},
  {0xfb2a, 0xfb37},
  {0xfb38, 0xfb3d},
  {0xfb3e, 0xfb3f},
  {0xfb40, 0xfb42},
  {0xfb43, 0xfb45},
  {0xfb46, 0xfb4f},
  {0x1d15e, 0x1d165},
  {0x1d1bb, 0x1d1c1},
  {0x2f800, 0x2fa1e},
  // clang-format on
}};
const std::array<std::pair<uint32_t, uint32_t>, 43> NFC_QC_MAYBE_RANGES = {{
  // clang-format off
  {0x0300, 0x0305},
  {0x0306, 0x030d},
  {0x030f, 0x0310},
  {0x0311, 0x0312},
  {0x0313, 0x0315},
  {0x031b, 0x031c},
  {0x0323, 0x0329},
  {0x032d, 0x032f},
  {0x0330, 0x0332},
  {0x0338, 0x0339},
  {0x0342, 0x0343},
  {0x0345, 0x0346},
  {0x0653, 0x0656},
  {0x093c, 0x093d},
  {0x09be, 0x09bf},
  {0x09d7, 0x09d8},
  {0x0b3e, 0x0b3f},
  {0x0b56, 0x0b57},
  {0x0b57, 0x0b58},
  {0x0bbe, 0x0bbf},
  {0x0bd7, 0x0bd8},
  {0x0c56, 0x0c57},
  {0x0cc2, 0x0cc3},
  {0x0cd5, 0x0cd7},
  {0x0d3e, 0x0d3f},
  {0x0d57, 0x0d58},
  {0x0dca, 0x0dcb},
  {0x0dcf, 0x0dd0},
  {0x0ddf, 0x0de0},
  {0x102e, 0x102f},
  {0x1161, 0x1176},
  {0x11a8, 0x11c3},
  {0x1b35, 0x1b36},
  {0x3099, 0x309b},
  {0x110ba, 0x110bb},
  {0x11127, 0x11128},
  {0x1133e, 0x1133f},
  {0x11357, 0x11358},
  {0x114b0, 0x114b1},
  {0x114ba, 0x114bb},
  {0x114bd, 0x114be},
  {0x115af, 0x115b0},
  {0x11930, 0x11931},
  // clang-format on
}};

} // namespace Rust
