/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (p11tool-args.h)
 *
 *  It has been AutoGen-ed
 *  From the definitions    /usr/src/ports/gnutls/gnutls-3.5.18-1.x86_64/src/gnutls-3.5.18/src/p11tool-args.def
 *  and the template file   options
 *
 * Generated from AutoOpts 41:1:16 templates.
 *
 *  AutoOpts is a copyrighted work.  This header file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the p11tool author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The p11tool program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 2000-2018 Free Software Foundation, and others, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  p11tool is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  p11tool is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the p11tool program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_P11TOOL_ARGS_H_GUARD
#define AUTOOPTS_P11TOOL_ARGS_H_GUARD 1
#include "config.h"
#include <autoopts/options.h>

/**
 *  Ensure that the library used for compiling this generated header is at
 *  least as new as the version current when the header template was released
 *  (not counting patch version increments).  Also ensure that the oldest
 *  tolerable version is at least as old as what was current when the header
 *  template was released.
 */
#define AO_TEMPLATE_VERSION 167937
#if (AO_TEMPLATE_VERSION < OPTIONS_MINIMUM_VERSION) \
 || (AO_TEMPLATE_VERSION > OPTIONS_STRUCT_VERSION)
# error option template version mismatches autoopts/options.h header
  Choke Me.
#endif

/**
 *  Enumeration of each option type for p11tool
 */
typedef enum {
    INDEX_OPT_LIST_TOKENS                   =  1,
    INDEX_OPT_LIST_TOKEN_URLS               =  2,
    INDEX_OPT_LIST_MECHANISMS               =  3,
    INDEX_OPT_INITIALIZE                    =  4,
    INDEX_OPT_INITIALIZE_PIN                =  5,
    INDEX_OPT_INITIALIZE_SO_PIN             =  6,
    INDEX_OPT_SET_PIN                       =  7,
    INDEX_OPT_SET_SO_PIN                    =  8,
    INDEX_OPT_LIST_ALL                      = 10,
    INDEX_OPT_LIST_ALL_CERTS                = 11,
    INDEX_OPT_LIST_CERTS                    = 12,
    INDEX_OPT_LIST_ALL_PRIVKEYS             = 13,
    INDEX_OPT_LIST_PRIVKEYS                 = 14,
    INDEX_OPT_LIST_KEYS                     = 15,
    INDEX_OPT_LIST_ALL_TRUSTED              = 16,
    INDEX_OPT_EXPORT                        = 17,
    INDEX_OPT_EXPORT_STAPLED                = 18,
    INDEX_OPT_EXPORT_CHAIN                  = 19,
    INDEX_OPT_EXPORT_PUBKEY                 = 20,
    INDEX_OPT_INFO                          = 21,
    INDEX_OPT_TRUSTED                       = 22,
    INDEX_OPT_DISTRUSTED                    = 23,
    INDEX_OPT_GENERATE_RSA                  = 25,
    INDEX_OPT_GENERATE_DSA                  = 26,
    INDEX_OPT_GENERATE_ECC                  = 27,
    INDEX_OPT_BITS                          = 28,
    INDEX_OPT_CURVE                         = 29,
    INDEX_OPT_SEC_PARAM                     = 30,
    INDEX_OPT_SET_ID                        = 32,
    INDEX_OPT_SET_LABEL                     = 33,
    INDEX_OPT_WRITE                         = 34,
    INDEX_OPT_DELETE                        = 35,
    INDEX_OPT_LABEL                         = 36,
    INDEX_OPT_ID                            = 37,
    INDEX_OPT_MARK_WRAP                     = 38,
    INDEX_OPT_MARK_TRUSTED                  = 39,
    INDEX_OPT_MARK_DISTRUSTED               = 40,
    INDEX_OPT_MARK_DECRYPT                  = 41,
    INDEX_OPT_MARK_SIGN                     = 42,
    INDEX_OPT_MARK_CA                       = 43,
    INDEX_OPT_MARK_PRIVATE                  = 44,
    INDEX_OPT_CA                            = 45,
    INDEX_OPT_PRIVATE                       = 46,
    INDEX_OPT_SECRET_KEY                    = 47,
    INDEX_OPT_LOAD_PRIVKEY                  = 48,
    INDEX_OPT_LOAD_PUBKEY                   = 49,
    INDEX_OPT_LOAD_CERTIFICATE              = 50,
    INDEX_OPT_DEBUG                         = 52,
    INDEX_OPT_OUTFILE                       = 53,
    INDEX_OPT_LOGIN                         = 54,
    INDEX_OPT_SO_LOGIN                      = 55,
    INDEX_OPT_ADMIN_LOGIN                   = 56,
    INDEX_OPT_TEST_SIGN                     = 57,
    INDEX_OPT_GENERATE_RANDOM               = 58,
    INDEX_OPT_PKCS8                         = 59,
    INDEX_OPT_INDER                         = 60,
    INDEX_OPT_INRAW                         = 61,
    INDEX_OPT_OUTDER                        = 62,
    INDEX_OPT_OUTRAW                        = 63,
    INDEX_OPT_PROVIDER                      = 64,
    INDEX_OPT_DETAILED_URL                  = 65,
    INDEX_OPT_ONLY_URLS                     = 66,
    INDEX_OPT_BATCH                         = 67,
    INDEX_OPT_VERSION                       = 68,
    INDEX_OPT_HELP                          = 69,
    INDEX_OPT_MORE_HELP                     = 70
} teOptIndex;
/** count of all options for p11tool */
#define OPTION_CT    71
/** p11tool version */
#define P11TOOL_VERSION       "3.5.18"
/** Full p11tool version text */
#define P11TOOL_FULL_VERSION  "p11tool 3.5.18"

/**
 *  Interface defines for all options.  Replace "n" with the UPPER_CASED
 *  option name (as in the teOptIndex enumeration above).
 *  e.g. HAVE_OPT(TOKEN_RELATED_OPTIONS)
 */
#define         DESC(n) (p11toolOptions.pOptDesc[INDEX_OPT_## n])
/** 'true' if an option has been specified in any way */
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
/** The string argument to an option. The argument type must be \"string\". */
#define      OPT_ARG(n) (DESC(n).optArg.argString)
/** Mask the option state revealing how an option was specified.
 *  It will be one and only one of \a OPTST_SET, \a OPTST_PRESET,
 * \a OPTST_DEFINED, \a OPTST_RESET or zero.
 */
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
/** Count of option's occurrances *on the command line*. */
#define    COUNT_OPT(n) (DESC(n).optOccCt)
/** mask of \a OPTST_SET and \a OPTST_DEFINED. */
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
/** 'true' if \a HAVE_OPT would yield 'false'. */
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
/** 'true' if OPTST_DISABLED bit not set. */
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
/** number of stacked option arguments.
 *  Valid only for stacked option arguments. */
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
/** stacked argument vector.
 *  Valid only for stacked option arguments. */
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
/** Reset an option. */
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT_MASK;   \
                if ((DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Enumeration of p11tool exit codes
 */
typedef enum {
    P11TOOL_EXIT_SUCCESS         = 0,
    P11TOOL_EXIT_FAILURE         = 1,
    P11TOOL_EXIT_USAGE_ERROR     = 64,
    P11TOOL_EXIT_LIBOPTS_FAILURE = 70
}   p11tool_exit_code_t;
/**
 *  Interface defines for specific options.
 * @{
 */
#define VALUE_OPT_LIST_TOKENS    0x1001
#define VALUE_OPT_LIST_TOKEN_URLS 0x1002
#define VALUE_OPT_LIST_MECHANISMS 0x1003
#define VALUE_OPT_INITIALIZE     0x1004
#define VALUE_OPT_INITIALIZE_PIN 0x1005
#define VALUE_OPT_INITIALIZE_SO_PIN 0x1006
#define VALUE_OPT_SET_PIN        0x1007
#define VALUE_OPT_SET_SO_PIN     0x1008
#define VALUE_OPT_LIST_ALL       0x1009
#define VALUE_OPT_LIST_ALL_CERTS 0x100A
#define VALUE_OPT_LIST_CERTS     0x100B
#define VALUE_OPT_LIST_ALL_PRIVKEYS 0x100C
#define VALUE_OPT_LIST_PRIVKEYS  0x100D
#define VALUE_OPT_LIST_KEYS      0x100E
#define VALUE_OPT_LIST_ALL_TRUSTED 0x100F
#define VALUE_OPT_EXPORT         0x1010
#define VALUE_OPT_EXPORT_STAPLED 0x1011
#define VALUE_OPT_EXPORT_CHAIN   0x1012
#define VALUE_OPT_EXPORT_PUBKEY  0x1013
#define VALUE_OPT_INFO           0x1014
#define VALUE_OPT_TRUSTED        0x1015
#define VALUE_OPT_DISTRUSTED     0x1016
#define VALUE_OPT_GENERATE_RSA   0x1017
#define VALUE_OPT_GENERATE_DSA   0x1018
#define VALUE_OPT_GENERATE_ECC   0x1019
#define VALUE_OPT_BITS           0x101A

#define OPT_VALUE_BITS           (DESC(BITS).optArg.argInt)
#define VALUE_OPT_CURVE          0x101B
#define VALUE_OPT_SEC_PARAM      0x101C
#define VALUE_OPT_SET_ID         0x101D
#define VALUE_OPT_SET_LABEL      0x101E
#define VALUE_OPT_WRITE          0x101F
#define VALUE_OPT_DELETE         0x1020
#define VALUE_OPT_LABEL          0x1021
#define VALUE_OPT_ID             0x1022
#define VALUE_OPT_MARK_WRAP      0x1023
#define VALUE_OPT_MARK_TRUSTED   0x1024
#define VALUE_OPT_MARK_DISTRUSTED 0x1025
#define VALUE_OPT_MARK_DECRYPT   0x1026
#define VALUE_OPT_MARK_SIGN      0x1027
#define VALUE_OPT_MARK_CA        0x1028
#define VALUE_OPT_MARK_PRIVATE   0x1029
#define VALUE_OPT_CA             0x102A
#define VALUE_OPT_PRIVATE        0x102B
#define VALUE_OPT_SECRET_KEY     0x102C
#define VALUE_OPT_LOAD_PRIVKEY   0x102D
#define VALUE_OPT_LOAD_PUBKEY    0x102E
#define VALUE_OPT_LOAD_CERTIFICATE 0x102F
#define VALUE_OPT_DEBUG          'd'

#define OPT_VALUE_DEBUG          (DESC(DEBUG).optArg.argInt)
#define VALUE_OPT_OUTFILE        0x1030
#define VALUE_OPT_LOGIN          0x1031
#define VALUE_OPT_SO_LOGIN       0x1032
#define VALUE_OPT_ADMIN_LOGIN    0x1033
#define VALUE_OPT_TEST_SIGN      0x1034
#define VALUE_OPT_GENERATE_RANDOM 0x1035

#define OPT_VALUE_GENERATE_RANDOM (DESC(GENERATE_RANDOM).optArg.argInt)
#define VALUE_OPT_PKCS8          '8'
#define VALUE_OPT_INDER          0x1036
#define VALUE_OPT_INRAW          0x1037
#define VALUE_OPT_OUTDER         0x1038
#define VALUE_OPT_OUTRAW         0x1039
#define VALUE_OPT_PROVIDER       0x103A
#define VALUE_OPT_DETAILED_URL   0x103B
#define VALUE_OPT_ONLY_URLS      0x103C
#define VALUE_OPT_BATCH          0x103D
/** option flag (value) for help-value option */
#define VALUE_OPT_HELP          'h'
/** option flag (value) for more-help-value option */
#define VALUE_OPT_MORE_HELP     '!'
/** option flag (value) for version-value option */
#define VALUE_OPT_VERSION       'v'
/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS(p11toolOptions.fOptSet &= ~OPTPROC_ERRSTOP)
#define ERRSTOP_OPTERR  STMTS(p11toolOptions.fOptSet |= OPTPROC_ERRSTOP)
#define RESTART_OPT(n)  STMTS( \
                p11toolOptions.curOptIdx = (n); \
                p11toolOptions.pzCurOpt  = NULL )
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*p11toolOptions.pUsageProc)(&p11toolOptions, c)

#ifdef  __cplusplus
extern "C" {
#endif
/*
 *  global exported definitions
 */
#include <gettext.h>


/* * * * * *
 *
 *  Declare the p11tool option descriptor.
 */
extern tOptions p11toolOptions;

#if defined(ENABLE_NLS)
# ifndef _
#   include <stdio.h>
#   ifndef HAVE_GETTEXT
      extern char * gettext(char const *);
#   else
#     include <libintl.h>
#   endif

# ifndef ATTRIBUTE_FORMAT_ARG
#   define ATTRIBUTE_FORMAT_ARG(_a)
# endif

static inline char* aoGetsText(char const* pz) ATTRIBUTE_FORMAT_ARG(1);
static inline char* aoGetsText(char const* pz) {
    if (pz == NULL) return NULL;
    return (char*)gettext(pz);
}
#   define _(s)  aoGetsText(s)
# endif /* _() */

# define OPT_NO_XLAT_CFG_NAMES  STMTS(p11toolOptions.fOptSet |= \
                                    OPTPROC_NXLAT_OPT_CFG;)
# define OPT_NO_XLAT_OPT_NAMES  STMTS(p11toolOptions.fOptSet |= \
                                    OPTPROC_NXLAT_OPT|OPTPROC_NXLAT_OPT_CFG;)

# define OPT_XLAT_CFG_NAMES     STMTS(p11toolOptions.fOptSet &= \
                                  ~(OPTPROC_NXLAT_OPT|OPTPROC_NXLAT_OPT_CFG);)
# define OPT_XLAT_OPT_NAMES     STMTS(p11toolOptions.fOptSet &= \
                                  ~OPTPROC_NXLAT_OPT;)

#else   /* ENABLE_NLS */
# define OPT_NO_XLAT_CFG_NAMES
# define OPT_NO_XLAT_OPT_NAMES

# define OPT_XLAT_CFG_NAMES
# define OPT_XLAT_OPT_NAMES

# ifndef _
#   define _(_s)  _s
# endif
#endif  /* ENABLE_NLS */

#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_P11TOOL_ARGS_H_GUARD */

/* p11tool-args.h ends here */
