.TH sfz2pat 1 "11 Oct 2004" \" -*-nroff-*-
.SH NAME
sz2pat \- convert sample files into extended GUS patches
.P
.SH SYNOPSIS
.B sfz2pat
filename.sfz
.P
.SH DESCRIPTION
This documents both the conversion program \fIsfz2pat\fR
and the \fBsfz\fR loader of the \fIgt\fR midi player.
.P
The name of one or more .wav files containing samples and various
parameters describing the desired patch structure and how to play
the patch are given in a text file with the extension \fB.sfz\fR.  Run
the \fIsfz2pat\fR utility on \fIfilename\fB.sfz\fR, and, if all
goes well, the result will be a GUS patch file named \fIfilename\fB.pat\fR.
.P
The same \fB.sfz\fR file can be loaded and played directly by
\fIgt\fR.  Just put the name of the file into timidity.cfg
or a file it sources, as you would the name of a GUS \fB.pat\fR
file.  Some features of \fBsfz\fR patches
can only be used when the patch is loaded directly, because
they don't fit into the GUS format.
.P
The format of \fB.sfz\fR files is described in
\fIhttp://www.rgcaudio.com/sfzformat.htm\fR.
See also \fIhttp://www.drealm.org.uk/sfz/plj-sfz.html\fR
a more lucid, less authoritative, account (from PL Jones).
An \fB.sfz\fR patch file is a text file describing
a single instrument, as implemented here.
(Though a whole set of drums can be characterized in
a single \fB.sfz\fR file for RGC Audio's player program,
this implementation requires a separate patch file for
each drum.)
.P
Typically, an instrument will have a number of different
samples, and which sample sounds when a note on that instrument
is played will depend on various circumstances -- the
pitch of the note, how loud it is, and so on.  A sample
thought of in relation to whether it sounds when a
note is played is referred to as a \fBlayer\fR in the
RGC documentation, but I usually call it a sample.
Each individual sample (layer) of an instrument is
described in a \fBregion\fR of the \fB.sfz\fR patch
file (see the \fI<region>\fR opcode below).
.P
Only a very tiny, little, miniscule part of \fBSFZ\fR
is currently interpreted.  \fBSFZ\fR opcodes in the \fB.sfz\fR file that are
not yet implemented are ignored.  Those that are interpreted
may or may not work exactly as specified in the RGC Audio
documentation (or as described here).
.P
The \fB.pat\fR files that are created are GUS extended patch files,
so they can have velocity layers and can be in stereo.
If the source \fB.wav\fR file is in stereo, the extended GUS
patch derived from it will also be in stereo.  In addition
to \fB.wav\fR files, you can also use \fB.aiff\fR and \fB.ogg\fR files for
samples.  24-bit \fB.wav\fR files are ok, but for GUS patches,
they are down-converted to 16 bits, so the extra resolution
is lost.  When loading patches directly, all 24 bits are
used.
.SH OPCODES
Here are the opcodes currently intepreted.
.TP
.B <group>
Beginning of global opcodes that apply thoughout following
regions, until the next \fB<group>\fR or end of file.
.TP
.B <region>
Beginning of local opcodes that apply only until the next
\fB<region>\fR, or \fB<group>\fR or end of file.
.TP
.BI sample= filename
Gives path of a file containing sample data.
.TP
.BI key= k
Note to play. \fIk\fR is a number 0-127 or an IPN note name
(letter A-G, optional # or b, then octave from -1 to 9),
and likewise below for all values referred to as \fIk\fR.
.TP
.BI hikey= k
Highest key of range.
Default is 60.
.TP
.BI lokey= k
Lowest key of range.
Default is 60.
.TP
.BI pitch_keycenter= k
Middle key of range.
Default is 60.
.TP
.BI hivel= v
Highest velocity of range. \fIv\fR is a number 0-127.
Default is 127.
.TP
.BI lovel= v
Highest velocity of range. \fIv\fR is a number 0-127.
Default is 0.
.TP
.BI offset= n
Where patch starts in sample file, in samples from
the beginning of the file.
Default is 0.
.TP
.BI end= n
Where patch ends in sample file, in samples.
Default is the end of the file.
.TP
.BI loop_start= n
Where the loop start point of patch is in sample
file, in samples.
Default is the \fBoffset\fR of the sample.
.TP
.BI loop_end= n
Where the loop end point of patch is in sample
file, in samples.
Default is the \fBend\fR of the sample.
.TP
.B loop_mode=loop_sustain
Makes the sample loop while note is held.
Default is no loop.
.TP
.BI volume= f
How loud to play the sample, in decibels.
Default is 0 decibel change to what is found
in the sample file.
.TP
.BI amp_random= f
The sample is amplified by a randomly selected
amount from 0 to \fIf\fR, given in decibels.
(This has no effect when creating \fB.pat\fR files.)
.TP
.BI ampeg_release= f
Release time for the volume envelope, in seconds.
.TP
.BI group= n
Defines the group the sample belongs to.
.TP
.BI off_by= n
The sample will stop playing when a note from
group \fIn\fR is started.
.TP
.B trigger=first
The sample will be played only if no other note in
the same group (and on the same channel) is
playing.
(This has no effect when creating \fB.pat\fR files.)
.TP
.B trigger=legato
The sample will be played only if another note in
the same group (and on the same channel) is
playing.
(This has no effect when creating \fB.pat\fR files.)
.TP
.BI hirand= f
The sample plays only when a randomly selected
number between 0 and 1 is less than \fIf\fR.
(This has no effect when creating \fB.pat\fR files.)
.TP
.BI lorand= f
The sample plays only when a randomly selected
number between 0 and 1 is greater or equal to \fIf\fR.
(This has no effect when creating \fB.pat\fR files.)
.TP
.BI sw_hikey= k
Highest key in switch range.
.TP
.BI sw_lokey= k
Lowest key in switch range.
.TP
.BI sw_down= k
The sample will play only if note \fIk\fR is playing
(on the same channel), provided it falls within
the switch range.
(This has no effect when creating \fB.pat\fR files.)
.TP
.BI sw_up= k
The sample will not play if note \fIk\fR is playing
(on the same channel), provided it falls within
the switch range.
(This has no effect when creating \fB.pat\fR files.)
.SH BUGS
Probably, there are lots of bugs.  This is an experiment.
.SH AUTHOR
Greg Lee <greg@ling.lll.hawaii.edu>
