#!/usr/bin/perl -w
# This library is free software: you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library.  If not, see
# <http://www.gnu.org/licenses/>.



# choice {cpp,h}
my $arg = $ARGV[0];
if(!defined($arg)) {
    print STDERR "No argument. Pass either cpp or h. Aborted\n";
    exit 1;
}
else {
    shift;
}
if($arg eq "-cpp") {
    print "/* autogenerated do not edit */\n";
    print "#include \"testsuitetags.h\"\n";
    print "const xml::tag_map_definition_t  testsuitetags[] = { \n";
    
    my $enumvalue = 1;
    while(<>) {
	chomp($_);
	print "{ \"$_\" , XML_" . $_ . " },\n";
	$enumvalue++;
    }
    print "{ 0, 0 }\n";
    print "};\n";
}
elsif($arg eq "-h") {
    
    print "/* autogenerated do not edit */\n";
    print "#ifndef __TESTSUITE_TAGS_H__\n";
    print "#define __TESTSUITE_TAGS_H__\n";
    print "#include \"xmlhandler.h\"\n";
    print "extern const xml::tag_map_definition_t  testsuitetags[];\n";
    print "enum {\n";
    
    my $enumvalue = 1;
    
    while(<>) {
	chomp($_);
	print "XML_" . $_ ." = $enumvalue,\n";
	$enumvalue++;
    }

    print "_XML_LASTTOKEN\n";
    print "};\n";
    print "#endif\n";
}
else {
    print "pass either cpp or h. Aborted\n";
    exit 1;
}
