/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* librvngabw
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2014 osnola
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef _DOCUMENTELEMENT_HXX_
#define _DOCUMENTELEMENT_HXX_

#include <vector>
#include <librevenge/librevenge.h>
#include <librvngabw/librvngabw.hxx>

#include "FilterInternal.hxx"

namespace librvngabw
{
class DocumentElement
{
public:
	virtual ~DocumentElement() {}
	virtual void write(ABWDocumentHandler *pHandler) const = 0;
	virtual void print() const {}
	virtual DocumentElement *duplicate() const = 0;
};

class TagElement : public DocumentElement
{
public:
	virtual ~TagElement() {}
	explicit TagElement(const librevenge::RVNGString &szTagName) : m_tagName(szTagName) {}
	const librevenge::RVNGString &getTagName() const
	{
		return m_tagName;
	}
	virtual void print() const;

private:
	librevenge::RVNGString m_tagName;
};

class TagOpenElement : public TagElement
{
public:
	explicit TagOpenElement(const librevenge::RVNGString &szTagName) : TagElement(szTagName), m_attributeList() {}
	TagOpenElement(const librevenge::RVNGString &szTagName, const librevenge::RVNGPropertyList &attrib) : TagElement(szTagName), m_attributeList(attrib) {}
	virtual ~TagOpenElement() {}
	void addAttribute(const librevenge::RVNGString &szAttributeName,
	                  const librevenge::RVNGString &sAttributeValue, bool forceString=true);
	void addAttribute(const librevenge::RVNGString &szAttributeName, int value);
	virtual void write(ABWDocumentHandler *pHandler) const;
	virtual void print() const;
	virtual DocumentElement *duplicate() const
	{
		return new TagOpenElement(*this);
	}
private:
	librevenge::RVNGPropertyList m_attributeList;
};

class TagCloseElement : public TagElement
{
public:
	explicit TagCloseElement(const librevenge::RVNGString &szTagName) : TagElement(szTagName) {}
	virtual ~TagCloseElement() {}
	virtual void write(ABWDocumentHandler *pHandler) const;
	virtual DocumentElement *duplicate() const
	{
		return new TagCloseElement(*this);
	}
};

class CharDataElement : public DocumentElement
{
public:
	explicit CharDataElement(const librevenge::RVNGString &sData) : DocumentElement(), m_data(sData) {}
	virtual ~CharDataElement() {}
	virtual void write(ABWDocumentHandler *pHandler) const;
	virtual DocumentElement *duplicate() const
	{
		return new CharDataElement(*this);
	}
private:
	librevenge::RVNGString m_data;
};

class TextElement : public DocumentElement
{
public:
	explicit TextElement(const librevenge::RVNGString &sTextBuf) : DocumentElement(), m_textBuffer(sTextBuf) {}
	virtual ~TextElement() {}
	virtual void write(ABWDocumentHandler *pHandler) const;
	virtual DocumentElement *duplicate() const
	{
		return new TextElement(*this);
	}

private:
	librevenge::RVNGString m_textBuffer;
};

//! small class used to store a list of shared_ptr DocumentElement
class DocumentElementVector
{
public:
	//! constructor
	DocumentElementVector() : m_elementList() {}
	//! destructor
	~DocumentElementVector();

	//! delete all document element
	void clear()
	{
		resize(0);
	}
	//! returns true if the list is empty
	bool empty() const
	{
		return m_elementList.empty();
	}
	//! returns the vector size
	size_t size() const
	{
		return m_elementList.size();
	}
	//! returns the vector size
	void resize(size_t newSize);
	//! push_back
	void push_back(shared_ptr<DocumentElement> elt);
	//! push_back (given a pointer)
	void push_back(DocumentElement *elt);
	//! append data at the end of res and clear the current vector
	void appendTo(DocumentElementVector &res);
	//! operator[]
	shared_ptr<DocumentElement> operator[](size_t index) const
	{
		return m_elementList[index];
	}
	//! operator[]
	shared_ptr<DocumentElement> &operator[](size_t index)
	{
		return m_elementList[index];
	}

	//! iterator
	std::vector<shared_ptr<DocumentElement> >::const_iterator begin() const
	{
		return m_elementList.begin();
	}
	std::vector<shared_ptr<DocumentElement> >::const_iterator end() const
	{
		return m_elementList.end();
	}

private:
	DocumentElementVector(const DocumentElementVector &orig);
	DocumentElementVector &operator=(const DocumentElementVector &orig);
protected:
	//! the list of elements
	std::vector<shared_ptr<DocumentElement> > m_elementList;
};

}
#endif

/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
