/* This file is automatically generated by Lemon from input grammar
** source file "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y".
*/
/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
/************ Begin %include sections from the grammar ************************/
#line 5 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"

#ifndef NDEBUG
#define NDEBUG
#endif
#include "first.h"
#include "base.h"
#include "configfile.h"
#include "buffer.h"
#include "array.h"
#include "http_header.h" /* http_header_hkey_get() */
#include "request.h" /* http_request_host_normalize() */

#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/*(missing declarations in generated configparser.c)*/
static void configparserInit(void *yypRawParser);
static void configparserFinalize(void *p);
/*(missing declarations in generated configparser.c; defined but not used)*/
static inline int configparserFallback(int iToken)
  __attribute_unused__;
#ifndef NDEBUG
static inline void configparserTrace(FILE *TraceFILE, char *zTracePrompt)
  __attribute_unused__;
#endif

__attribute_pure__
static data_config * configparser_get_data_config(const array *a, const char *k, const size_t klen) {
  return (data_config *)array_get_data_unset(a, k, klen);
}

__attribute_noinline__
static void configparser_push_data_config_list(data_config_list *v, data_config *dc) {
    if (v->size == v->used) {
        ck_realloc_u32((void **)&v->data, v->size, 4, sizeof(*v->data));
        v->size += 4;
    }
    v->data[v->used++] = dc;
}

static void configparser_push(config_t *ctx, data_config *dc, int isnew) {
  if (isnew) {
    dc->context_ndx = ctx->all_configs->used;
    force_assert(dc->context_ndx > ctx->current->context_ndx);
    array_insert_unique(ctx->all_configs, (data_unset *)dc);
    dc->parent = ctx->current;
    configparser_push_data_config_list(&dc->parent->children, dc);
  }
  if (ctx->configs_stack.used > 0 && ctx->current->context_ndx == 0) {
    fprintf(stderr, "Cannot use conditionals inside a global { ... } block\n");
    exit(-1);
  }
  configparser_push_data_config_list(&ctx->configs_stack, ctx->current);
  ctx->current = dc;
}

static data_config *configparser_pop(config_t *ctx) {
  data_config *old = ctx->current;
  ctx->current = ctx->configs_stack.used > 0
               ? ctx->configs_stack.data[--ctx->configs_stack.used]
               : NULL;
  force_assert(old && ctx->current);
  return old;
}

/* return a copied variable */
static data_unset *configparser_get_variable(config_t *ctx, const buffer *key) {
  const data_unset *du;
  data_config *dc;
  for (dc = ctx->current; dc; dc = dc->parent) {
    if (NULL != (du = array_get_element_klen(dc->value, BUF_PTR_LEN(key)))) {
      data_unset *du_copy = du->fn->copy(du);
      buffer_clear(&du_copy->key);
      return du_copy;
    }
  }
  return NULL;
}

/* op1 is to be eat/return by this function if success, op1->key is not cared
   op2 is left untouch, unreferenced
 */
static data_unset *configparser_merge_data(data_unset *op1, const data_unset *op2) {
  /* type mismatch */
  if (op1->type != op2->type) {
    if (op1->type == TYPE_STRING && op2->type == TYPE_INTEGER) {
      data_string *ds = (data_string *)op1;
      buffer_append_int(&ds->value, ((data_integer*)op2)->value);
      return op1;
    } else if (op1->type == TYPE_INTEGER && op2->type == TYPE_STRING) {
      data_string *ds = array_data_string_init();
      buffer_append_int(&ds->value, ((data_integer*)op1)->value);
      buffer_append_string_buffer(&ds->value, &((data_string*)op2)->value);
      op1->fn->free(op1);
      return (data_unset *)ds;
    } else {
      fprintf(stderr, "data type mismatch, cannot merge\n");
      op1->fn->free(op1);
      return NULL;
    }
  }

  switch (op1->type) {
    case TYPE_STRING:
      buffer_append_string_buffer(&((data_string *)op1)->value, &((data_string *)op2)->value);
      break;
    case TYPE_INTEGER:
      ((data_integer *)op1)->value += ((data_integer *)op2)->value;
      break;
    case TYPE_ARRAY: {
      array *dst = &((data_array *)op1)->value;
      array *src = &((data_array *)op2)->value;
      const data_unset *du, *ddu;
      size_t i;

      for (i = 0; i < src->used; i ++) {
        du = (data_unset *)src->data[i];
        if (du) {
          if (buffer_is_unset(&du->key)
              || !(ddu = array_get_element_klen(dst, BUF_PTR_LEN(&du->key)))){
            array_insert_unique(dst, du->fn->copy(du));
          } else {
            fprintf(stderr, "Duplicate array-key '%s'\n", du->key.ptr);
            if (ddu->type == du->type) {
              /*(ignore if new key/value pair matches existing key/value)*/
              if (du->type == TYPE_STRING
                  && buffer_is_equal(&((data_string *)du)->value,
                                     &((data_string *)ddu)->value))
                  continue;
              if (du->type == TYPE_INTEGER
                  && ((data_integer*)du)->value == ((data_integer*)ddu)->value)
                  continue;
            }
            op1->fn->free(op1);
            return NULL;
          }
        }
      }
      break;
    }
    default:
      ck_assert_failed(__FILE__, __LINE__, "unexpected enum value");
      break;
  }
  return op1;
}

__attribute_pure__
static comp_key_t
configparser_comp_key_id(const buffer * const obj_tag, const buffer * const comp_tag)
{
  /* $REQUEST_HEADER["..."] */
  /* $SERVER["socket"] */
  /* $HTTP["..."] */
  if (buffer_eq_slen(obj_tag, CONST_STR_LEN("REQUEST_HEADER")))
    return COMP_HTTP_REQUEST_HEADER;
  else if (buffer_eq_slen(obj_tag, CONST_STR_LEN("SERVER")))
    return (buffer_eq_slen(comp_tag, CONST_STR_LEN("socket")))
      ? COMP_SERVER_SOCKET
      : COMP_UNSET;
  else if (buffer_eq_slen(obj_tag, CONST_STR_LEN("HTTP"))) {
    static const struct {
      comp_key_t comp;
      uint32_t len;
      const char *comp_tag;
    } comps[] = {
      { COMP_HTTP_URL,            CONST_LEN_STR("url"           ) },
      { COMP_HTTP_HOST,           CONST_LEN_STR("host"          ) },
      { COMP_HTTP_REQUEST_HEADER, CONST_LEN_STR("referer"       ) },
      { COMP_HTTP_USER_AGENT,     CONST_LEN_STR("useragent"     ) },
      { COMP_HTTP_REQUEST_HEADER, CONST_LEN_STR("user-agent"    ) },
      { COMP_HTTP_LANGUAGE,       CONST_LEN_STR("language"      ) },
      { COMP_HTTP_REQUEST_HEADER, CONST_LEN_STR("cookie"        ) },
      { COMP_HTTP_REMOTE_IP,      CONST_LEN_STR("remoteip"      ) },
      { COMP_HTTP_REMOTE_IP,      CONST_LEN_STR("remote-ip"     ) },
      { COMP_HTTP_QUERY_STRING,   CONST_LEN_STR("querystring"   ) },
      { COMP_HTTP_QUERY_STRING,   CONST_LEN_STR("query-string"  ) },
      { COMP_HTTP_REQUEST_METHOD, CONST_LEN_STR("request-method") },
      { COMP_HTTP_SCHEME,         CONST_LEN_STR("scheme"        ) }
    };

    for (uint32_t i = 0; i < sizeof(comps)/sizeof(comps[0]); ++i) {
      if (buffer_eq_slen(comp_tag, comps[i].comp_tag, comps[i].len))
        return comps[i].comp;
    }
  }
  return COMP_UNSET;
}

static config_cond_t
configparser_simplify_regex(buffer * const b)
{
    /* translate simple regex anchored with ^ and/or $ to simpler match types
     * (note: skips if regex contains any '\\', even if some could be removed,
     *  though we special-case "\.ext"; skips if other '.' found in str)
     * (currently assumes CONFIG_COND_MATCH input, not CONFIG_COND_NOMATCH) */
    uint32_t len = buffer_clen(b);
    config_cond_t cond = CONFIG_COND_MATCH;
    int off = 0;
    if (len && b->ptr[len-1] == '$') {
        cond = CONFIG_COND_SUFFIX;
        if (b->ptr[0] == '\\' && b->ptr[1] == '.')
            off = 2;
        else if (b->ptr[0] == '^') {
            off = 1;
            cond = CONFIG_COND_EQ;
        }
        --len;
    }
    else if (b->ptr[0] == '^') {
        off = 1;
        cond = CONFIG_COND_PREFIX;
    }
    else
        return CONFIG_COND_MATCH;

    static const char regex_chars[] = "\\^$.|?*+()[]{}";
    if (strcspn(b->ptr+off, regex_chars) != len - off)
        return CONFIG_COND_MATCH;
    if (off) { /*(remove only first char if (off == 2) to keep '.' in "\.")*/
        memmove(b->ptr, b->ptr+1, len-1);
        --len;
    }
    buffer_truncate(b, len);
    return cond;
}

static void
configparser_parse_condition(config_t * const ctx, const buffer * const obj_tag, const buffer * const comp_tag, config_cond_t cond, buffer * const rvalue)
{
    const comp_key_t comp = configparser_comp_key_id(obj_tag, comp_tag);
    if (cond == CONFIG_COND_MATCH && comp != COMP_SERVER_SOCKET)
        cond = configparser_simplify_regex(rvalue);

    const char *op = NULL;
    switch(cond) {
    case CONFIG_COND_NE:      op = "!="; break;
    case CONFIG_COND_EQ:      op = "=="; break;
    case CONFIG_COND_NOMATCH: op = "!~"; break;
    case CONFIG_COND_MATCH:   op = "=~"; break;
    case CONFIG_COND_PREFIX:  op = "=^"; break;
    case CONFIG_COND_SUFFIX:  op = "=$"; break;
    default:
      ck_assert_failed(__FILE__, __LINE__, "unexpected enum value");
    }

    const uint32_t comp_offset = buffer_clen(&ctx->current->key)+3;
    buffer * const tb = ctx->srv->tmp_buf;
    buffer_clear(tb);
    struct const_iovec iov[] = {
      { BUF_PTR_LEN(&ctx->current->key) }
     ,{ CONST_STR_LEN(" / ") }   /* comp_offset */
     ,{ CONST_STR_LEN("$") }
     ,{ BUF_PTR_LEN(obj_tag) } /*(HTTP, REQUEST_HEADER, SERVER)*/
     ,{ CONST_STR_LEN("[\"") }
     ,{ BUF_PTR_LEN(comp_tag) }
     ,{ CONST_STR_LEN("\"] ") }
     ,{ op, 2 }
     ,{ CONST_STR_LEN(" \"") }
     ,{ BUF_PTR_LEN(rvalue) }
     ,{ CONST_STR_LEN("\"") }
    };
    buffer_append_iovec(tb, iov, sizeof(iov)/sizeof(*iov));

    data_config *dc;
    if (NULL != (dc = configparser_get_data_config(ctx->all_configs,
                                                   BUF_PTR_LEN(tb)))) {
      configparser_push(ctx, dc, 0);
    }
    else {
      dc = data_config_init();
      dc->cond = cond;
      dc->comp = comp;

      buffer_copy_buffer(&dc->key, tb);
      buffer_copy_buffer(&dc->comp_tag, comp_tag);
      dc->comp_key = dc->key.ptr + comp_offset;

      if (COMP_UNSET == dc->comp) {
          fprintf(stderr, "error comp_key %s\n", dc->comp_key);
          ctx->ok = 0;
      }
      else if (COMP_HTTP_LANGUAGE == dc->comp) {
        dc->comp = COMP_HTTP_REQUEST_HEADER;
        buffer_copy_string_len(&dc->comp_tag, CONST_STR_LEN("Accept-Language"));
      }
      else if (COMP_HTTP_USER_AGENT == dc->comp) {
        dc->comp = COMP_HTTP_REQUEST_HEADER;
        buffer_copy_string_len(&dc->comp_tag, CONST_STR_LEN("User-Agent"));
      }
      else if (COMP_HTTP_REMOTE_IP == dc->comp
               && (dc->cond == CONFIG_COND_EQ     ||
                   dc->cond == CONFIG_COND_NE     ||
                   dc->cond == CONFIG_COND_PREFIX ||
                   dc->cond == CONFIG_COND_SUFFIX)) {
        if (!config_remoteip_normalize(rvalue, tb)) {
          fprintf(stderr, "invalid IP addr: %s\n", rvalue->ptr);
          ctx->ok = 0;
        }
      }
      else if (COMP_SERVER_SOCKET == dc->comp) {
        /*(redundant with parsing in network.c; not actually required here)*/
        if (rvalue->ptr[0] != ':' /*(network.c special-cases ":" and "[]")*/
            && !(rvalue->ptr[0] == '[' && rvalue->ptr[1] == ']')
            && !(rvalue->ptr[0] == '/' || rvalue->ptr[0] == '\\')) { /*(UDS)*/
          if (http_request_host_normalize(rvalue, 0)) {
            fprintf(stderr, "invalid IP addr: %s\n", rvalue->ptr);
            ctx->ok = 0;
          }
        }
      }
      else if (COMP_HTTP_HOST == dc->comp) {
        if (dc->cond == CONFIG_COND_EQ     ||
            dc->cond == CONFIG_COND_NE     ||
            dc->cond == CONFIG_COND_PREFIX ||
            dc->cond == CONFIG_COND_SUFFIX) {
          if (http_request_host_normalize(rvalue, 0)) {
            fprintf(stderr, "invalid IP addr: %s\n", rvalue->ptr);
            ctx->ok = 0;
          }
        }
      }

      if (COMP_HTTP_REQUEST_HEADER == dc->comp) {
        dc->ext = http_header_hkey_get(BUF_PTR_LEN(&dc->comp_tag));
      }

      buffer_move(&dc->string, rvalue);

      if (ctx->ok)
        configparser_push(ctx, dc, 1);
      else
        dc->fn->free((data_unset*) dc);
    }
}

static void
configparser_parse_else_condition(config_t * const ctx)
{
    data_config * const dc = data_config_init();
    dc->cond = CONFIG_COND_ELSE;
    buffer_append_str2(&dc->key, BUF_PTR_LEN(&ctx->current->key),
                                 CONST_STR_LEN(" / "
                                               "else_tmp_token"));
    configparser_push(ctx, dc, 1);
}

#line 381 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols.
***************** Begin token definitions *************************************/
#ifndef TK_EOL
#define TK_EOL                             1
#define TK_ASSIGN                          2
#define TK_FORCE_ASSIGN                    3
#define TK_APPEND                          4
#define TK_LKEY                            5
#define TK_PLUS                            6
#define TK_STRING                          7
#define TK_INTEGER                         8
#define TK_LPARAN                          9
#define TK_RPARAN                         10
#define TK_COMMA                          11
#define TK_ARRAY_ASSIGN                   12
#define TK_GLOBAL                         13
#define TK_LCURLY                         14
#define TK_RCURLY                         15
#define TK_ELSE                           16
#define TK_DOLLAR                         17
#define TK_SRVVARNAME                     18
#define TK_LBRACKET                       19
#define TK_RBRACKET                       20
#define TK_EQ                             21
#define TK_MATCH                          22
#define TK_NE                             23
#define TK_NOMATCH                        24
#define TK_PREFIX                         25
#define TK_SUFFIX                         26
#define TK_INCLUDE                        27
#define TK_INCLUDE_SHELL                  28
#endif
/**************** End token definitions ***************************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    configparserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is configparserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    configparserARG_SDECL     A static variable declaration for the %extra_argument
**    configparserARG_PDECL     A parameter declaration for the %extra_argument
**    configparserARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    configparserARG_STORE     Code to store %extra_argument into yypParser
**    configparserARG_FETCH     Code to extract %extra_argument from yypParser
**    configparserCTX_*         As configparserARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 51
#define YYACTIONTYPE unsigned char
#define configparserTOKENTYPE buffer *
typedef union {
  int yyinit;
  configparserTOKENTYPE yy0;
  data_config * yy20;
  data_unset * yy35;
  config_cond_t yy59;
  array * yy66;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define configparserARG_SDECL config_t *ctx;
#define configparserARG_PDECL ,config_t *ctx
#define configparserARG_PARAM ,ctx
#define configparserARG_FETCH config_t *ctx=yypParser->ctx;
#define configparserARG_STORE yypParser->ctx=ctx;
#define configparserCTX_SDECL
#define configparserCTX_PDECL
#define configparserCTX_PARAM
#define configparserCTX_FETCH
#define configparserCTX_STORE
#define YYNSTATE             40
#define YYNRULE              46
#define YYNRULE_WITH_ACTION  36
#define YYNTOKEN             29
#define YY_MAX_SHIFT         39
#define YY_MIN_SHIFTREDUCE   72
#define YY_MAX_SHIFTREDUCE   117
#define YY_ERROR_ACTION      118
#define YY_ACCEPT_ACTION     119
#define YY_NO_ACTION         120
#define YY_MIN_REDUCE        121
#define YY_MAX_REDUCE        166
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (150)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   158,  158,  158,   18,  158,  158,   16,  115,  126,  143,
 /*    10 */    10,   76,  154,   22,  131,  128,   39,   31,   37,   90,
 /*    20 */    30,   96,   38,   30,   76,  115,   80,   81,    5,   76,
 /*    30 */    19,  115,    1,    8,    7,   76,    9,   90,    2,   91,
 /*    40 */     3,   30,   16,   90,   15,   95,   17,   30,  157,  115,
 /*    50 */    29,    8,    7,   76,   14,   12,   11,    8,    7,   84,
 /*    60 */     6,   90,   13,  165,   76,   30,   80,   81,    5,   83,
 /*    70 */    20,   21,  127,   24,  136,    8,    7,   23,  131,  128,
 /*    80 */    35,  127,   24,  134,  119,    4,  120,  131,  128,   35,
 /*    90 */   120,  120,  120,  120,   99,  100,  101,  102,  103,  104,
 /*   100 */   120,  120,  127,   28,  120,  127,   28,  120,  131,  128,
 /*   110 */   156,  131,  128,  155,  127,   28,  120,  127,   26,  120,
 /*   120 */   131,  128,   27,  131,  128,  127,   32,  127,   33,  120,
 /*   130 */   120,  131,  128,  131,  128,  127,   34,  127,   36,  141,
 /*   140 */   142,  131,  128,  131,  128,  120,  120,  120,   37,   25,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    31,   32,   33,   34,   35,   36,    6,    1,   37,   40,
 /*    10 */    46,    5,   12,   44,   43,   44,    1,   48,   49,   13,
 /*    20 */    17,   15,   47,   17,    5,    1,    7,    8,    9,    5,
 /*    30 */    14,    1,   30,   27,   28,    5,   19,   13,   30,   15,
 /*    40 */    30,   17,    6,   13,   16,   15,   20,   17,    0,    1,
 /*    50 */    18,   27,   28,    5,    2,    3,    4,   27,   28,   10,
 /*    60 */    11,   13,   12,   16,    5,   17,    7,    8,    9,   10,
 /*    70 */    14,   14,   37,   38,   39,   27,   28,   42,   43,   44,
 /*    80 */    45,   37,   38,   39,   29,   30,   51,   43,   44,   45,
 /*    90 */    51,   51,   51,   51,   21,   22,   23,   24,   25,   26,
 /*   100 */    51,   51,   37,   38,   51,   37,   38,   51,   43,   44,
 /*   110 */    45,   43,   44,   45,   37,   38,   51,   37,   38,   51,
 /*   120 */    43,   44,   45,   43,   44,   37,   38,   37,   38,   51,
 /*   130 */    51,   43,   44,   43,   44,   37,   38,   37,   38,   40,
 /*   140 */    41,   43,   44,   43,   44,   51,   51,   51,   49,   50,
 /*   150 */    29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
 /*   160 */    29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
 /*   170 */    29,   29,   29,   29,   29,   29,   29,   29,   29,
};
#define YY_SHIFT_COUNT    (39)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (73)
static const unsigned char yy_shift_ofst[] = {
 /*     0 */   150,    6,   24,   30,   48,   59,   19,   19,   19,   19,
 /*    10 */    19,   19,   19,   19,   19,    3,   19,   73,   15,  150,
 /*    20 */   150,  150,   52,   49,    0,   16,   36,   26,   36,   17,
 /*    30 */    32,   56,   36,   36,   36,   50,   36,   57,   28,   47,
};
#define YY_REDUCE_COUNT (21)
#define YY_REDUCE_MIN   (-36)
#define YY_REDUCE_MAX   (100)
static const signed char yy_reduce_ofst[] = {
 /*     0 */    55,  -31,  -31,  -31,  -31,   35,   44,   65,   68,   77,
 /*    10 */    80,   88,   90,   98,  100,   99,  -29,  -36,  -25,    2,
 /*    20 */     8,   10,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   159,  118,  118,  118,  118,  118,  135,  118,  118,  118,
 /*    10 */   118,  118,  118,  118,  118,  147,  118,  118,  166,  159,
 /*    20 */   159,  159,  118,  118,  137,  118,  146,  118,  154,  118,
 /*    30 */   118,  118,  124,  123,  138,  118,  122,  118,  118,  121,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.
** If a construct like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  configparserARG_SDECL                /* A place to hold %extra_argument */
  configparserCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#include <assert.h>
#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void configparserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  /*    0 */ "$",
  /*    1 */ "EOL",
  /*    2 */ "ASSIGN",
  /*    3 */ "FORCE_ASSIGN",
  /*    4 */ "APPEND",
  /*    5 */ "LKEY",
  /*    6 */ "PLUS",
  /*    7 */ "STRING",
  /*    8 */ "INTEGER",
  /*    9 */ "LPARAN",
  /*   10 */ "RPARAN",
  /*   11 */ "COMMA",
  /*   12 */ "ARRAY_ASSIGN",
  /*   13 */ "GLOBAL",
  /*   14 */ "LCURLY",
  /*   15 */ "RCURLY",
  /*   16 */ "ELSE",
  /*   17 */ "DOLLAR",
  /*   18 */ "SRVVARNAME",
  /*   19 */ "LBRACKET",
  /*   20 */ "RBRACKET",
  /*   21 */ "EQ",
  /*   22 */ "MATCH",
  /*   23 */ "NE",
  /*   24 */ "NOMATCH",
  /*   25 */ "PREFIX",
  /*   26 */ "SUFFIX",
  /*   27 */ "INCLUDE",
  /*   28 */ "INCLUDE_SHELL",
  /*   29 */ "input",
  /*   30 */ "metalines",
  /*   31 */ "metaline",
  /*   32 */ "varline",
  /*   33 */ "global",
  /*   34 */ "condlines",
  /*   35 */ "include",
  /*   36 */ "include_shell",
  /*   37 */ "value",
  /*   38 */ "expression",
  /*   39 */ "aelement",
  /*   40 */ "condline",
  /*   41 */ "cond_else",
  /*   42 */ "aelements",
  /*   43 */ "array",
  /*   44 */ "key",
  /*   45 */ "stringop",
  /*   46 */ "cond",
  /*   47 */ "eols",
  /*   48 */ "globalstart",
  /*   49 */ "context",
  /*   50 */ "context_else",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "metaline ::= condlines EOL",
 /*   1 */ "varline ::= key ASSIGN expression",
 /*   2 */ "varline ::= key FORCE_ASSIGN expression",
 /*   3 */ "varline ::= key APPEND expression",
 /*   4 */ "key ::= LKEY",
 /*   5 */ "expression ::= expression PLUS value",
 /*   6 */ "expression ::= value",
 /*   7 */ "value ::= key",
 /*   8 */ "value ::= STRING",
 /*   9 */ "value ::= INTEGER",
 /*  10 */ "value ::= array",
 /*  11 */ "array ::= LPARAN RPARAN",
 /*  12 */ "array ::= LPARAN aelements RPARAN",
 /*  13 */ "aelements ::= aelements COMMA aelement",
 /*  14 */ "aelements ::= aelements COMMA",
 /*  15 */ "aelements ::= aelement",
 /*  16 */ "aelement ::= expression",
 /*  17 */ "aelement ::= stringop ARRAY_ASSIGN expression",
 /*  18 */ "globalstart ::= GLOBAL",
 /*  19 */ "global ::= globalstart LCURLY metalines RCURLY",
 /*  20 */ "condlines ::= condlines eols ELSE condline",
 /*  21 */ "condlines ::= condlines eols ELSE cond_else",
 /*  22 */ "condlines ::= condline",
 /*  23 */ "condline ::= context LCURLY metalines RCURLY",
 /*  24 */ "cond_else ::= context_else LCURLY metalines RCURLY",
 /*  25 */ "context ::= DOLLAR SRVVARNAME LBRACKET stringop RBRACKET cond expression",
 /*  26 */ "context_else ::=",
 /*  27 */ "cond ::= EQ",
 /*  28 */ "cond ::= MATCH",
 /*  29 */ "cond ::= NE",
 /*  30 */ "cond ::= NOMATCH",
 /*  31 */ "cond ::= PREFIX",
 /*  32 */ "cond ::= SUFFIX",
 /*  33 */ "stringop ::= expression",
 /*  34 */ "include ::= INCLUDE stringop",
 /*  35 */ "include_shell ::= INCLUDE_SHELL stringop",
 /*  36 */ "input ::= metalines",
 /*  37 */ "metalines ::= metalines metaline",
 /*  38 */ "metalines ::=",
 /*  39 */ "metaline ::= varline",
 /*  40 */ "metaline ::= global",
 /*  41 */ "metaline ::= include",
 /*  42 */ "metaline ::= include_shell",
 /*  43 */ "metaline ::= EOL",
 /*  44 */ "eols ::= EOL",
 /*  45 */ "eols ::=",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0;
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to configparserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void configparserInit(void *yypRawParser configparserCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  configparserCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef configparser_ENGINEALWAYSONSTACK
/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to configparser and configparserFree.
*/
void *configparserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) configparserCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    configparserCTX_STORE
    configparserInit(yypParser configparserCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* configparser_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  configparserARG_FETCH
  configparserCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* TERMINAL Destructor */
    case 1: /* EOL */
    case 2: /* ASSIGN */
    case 3: /* FORCE_ASSIGN */
    case 4: /* APPEND */
    case 5: /* LKEY */
    case 6: /* PLUS */
    case 7: /* STRING */
    case 8: /* INTEGER */
    case 9: /* LPARAN */
    case 10: /* RPARAN */
    case 11: /* COMMA */
    case 12: /* ARRAY_ASSIGN */
    case 13: /* GLOBAL */
    case 14: /* LCURLY */
    case 15: /* RCURLY */
    case 16: /* ELSE */
    case 17: /* DOLLAR */
    case 18: /* SRVVARNAME */
    case 19: /* LBRACKET */
    case 20: /* RBRACKET */
    case 21: /* EQ */
    case 22: /* MATCH */
    case 23: /* NE */
    case 24: /* NOMATCH */
    case 25: /* PREFIX */
    case 26: /* SUFFIX */
    case 27: /* INCLUDE */
    case 28: /* INCLUDE_SHELL */
{
#line 393 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
 buffer_free((yypminor->yy0)); UNUSED(ctx); 
#line 1002 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
      break;
    case 37: /* value */
    case 38: /* expression */
    case 39: /* aelement */
{
#line 384 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
 if ((yypminor->yy35)) (yypminor->yy35)->fn->free((yypminor->yy35)); 
#line 1011 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
      break;
    case 42: /* aelements */
    case 43: /* array */
{
#line 387 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
 array_free((yypminor->yy66)); 
#line 1019 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
      break;
    case 44: /* key */
    case 45: /* stringop */
{
#line 389 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
 buffer_free((yypminor->yy0)); 
#line 1027 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void configparserFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef configparser_ENGINEALWAYSONSTACK
/*
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void configparserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  configparserFinalize(p);
  (*freeProc)(p);
}
#endif /* configparser_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int configparserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int configparserCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<(int)(sizeof(yy_action)/sizeof(yy_action[0])) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   configparserARG_FETCH
   configparserCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   configparserARG_STORE /* Suppress warning about unused %extra_argument var */
   configparserCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  configparserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
    31,  /* (0) metaline ::= condlines EOL */
    32,  /* (1) varline ::= key ASSIGN expression */
    32,  /* (2) varline ::= key FORCE_ASSIGN expression */
    32,  /* (3) varline ::= key APPEND expression */
    44,  /* (4) key ::= LKEY */
    38,  /* (5) expression ::= expression PLUS value */
    38,  /* (6) expression ::= value */
    37,  /* (7) value ::= key */
    37,  /* (8) value ::= STRING */
    37,  /* (9) value ::= INTEGER */
    37,  /* (10) value ::= array */
    43,  /* (11) array ::= LPARAN RPARAN */
    43,  /* (12) array ::= LPARAN aelements RPARAN */
    42,  /* (13) aelements ::= aelements COMMA aelement */
    42,  /* (14) aelements ::= aelements COMMA */
    42,  /* (15) aelements ::= aelement */
    39,  /* (16) aelement ::= expression */
    39,  /* (17) aelement ::= stringop ARRAY_ASSIGN expression */
    48,  /* (18) globalstart ::= GLOBAL */
    33,  /* (19) global ::= globalstart LCURLY metalines RCURLY */
    34,  /* (20) condlines ::= condlines eols ELSE condline */
    34,  /* (21) condlines ::= condlines eols ELSE cond_else */
    34,  /* (22) condlines ::= condline */
    40,  /* (23) condline ::= context LCURLY metalines RCURLY */
    41,  /* (24) cond_else ::= context_else LCURLY metalines RCURLY */
    49,  /* (25) context ::= DOLLAR SRVVARNAME LBRACKET stringop RBRACKET cond expression */
    50,  /* (26) context_else ::= */
    46,  /* (27) cond ::= EQ */
    46,  /* (28) cond ::= MATCH */
    46,  /* (29) cond ::= NE */
    46,  /* (30) cond ::= NOMATCH */
    46,  /* (31) cond ::= PREFIX */
    46,  /* (32) cond ::= SUFFIX */
    45,  /* (33) stringop ::= expression */
    35,  /* (34) include ::= INCLUDE stringop */
    36,  /* (35) include_shell ::= INCLUDE_SHELL stringop */
    29,  /* (36) input ::= metalines */
    30,  /* (37) metalines ::= metalines metaline */
    30,  /* (38) metalines ::= */
    31,  /* (39) metaline ::= varline */
    31,  /* (40) metaline ::= global */
    31,  /* (41) metaline ::= include */
    31,  /* (42) metaline ::= include_shell */
    31,  /* (43) metaline ::= EOL */
    47,  /* (44) eols ::= EOL */
    47,  /* (45) eols ::= */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -2,  /* (0) metaline ::= condlines EOL */
   -3,  /* (1) varline ::= key ASSIGN expression */
   -3,  /* (2) varline ::= key FORCE_ASSIGN expression */
   -3,  /* (3) varline ::= key APPEND expression */
   -1,  /* (4) key ::= LKEY */
   -3,  /* (5) expression ::= expression PLUS value */
   -1,  /* (6) expression ::= value */
   -1,  /* (7) value ::= key */
   -1,  /* (8) value ::= STRING */
   -1,  /* (9) value ::= INTEGER */
   -1,  /* (10) value ::= array */
   -2,  /* (11) array ::= LPARAN RPARAN */
   -3,  /* (12) array ::= LPARAN aelements RPARAN */
   -3,  /* (13) aelements ::= aelements COMMA aelement */
   -2,  /* (14) aelements ::= aelements COMMA */
   -1,  /* (15) aelements ::= aelement */
   -1,  /* (16) aelement ::= expression */
   -3,  /* (17) aelement ::= stringop ARRAY_ASSIGN expression */
   -1,  /* (18) globalstart ::= GLOBAL */
   -4,  /* (19) global ::= globalstart LCURLY metalines RCURLY */
   -4,  /* (20) condlines ::= condlines eols ELSE condline */
   -4,  /* (21) condlines ::= condlines eols ELSE cond_else */
   -1,  /* (22) condlines ::= condline */
   -4,  /* (23) condline ::= context LCURLY metalines RCURLY */
   -4,  /* (24) cond_else ::= context_else LCURLY metalines RCURLY */
   -7,  /* (25) context ::= DOLLAR SRVVARNAME LBRACKET stringop RBRACKET cond expression */
    0,  /* (26) context_else ::= */
   -1,  /* (27) cond ::= EQ */
   -1,  /* (28) cond ::= MATCH */
   -1,  /* (29) cond ::= NE */
   -1,  /* (30) cond ::= NOMATCH */
   -1,  /* (31) cond ::= PREFIX */
   -1,  /* (32) cond ::= SUFFIX */
   -1,  /* (33) stringop ::= expression */
   -2,  /* (34) include ::= INCLUDE stringop */
   -2,  /* (35) include_shell ::= INCLUDE_SHELL stringop */
   -1,  /* (36) input ::= metalines */
   -2,  /* (37) metalines ::= metalines metaline */
    0,  /* (38) metalines ::= */
   -1,  /* (39) metaline ::= varline */
   -1,  /* (40) metaline ::= global */
   -1,  /* (41) metaline ::= include */
   -1,  /* (42) metaline ::= include_shell */
   -1,  /* (43) metaline ::= EOL */
   -1,  /* (44) eols ::= EOL */
    0,  /* (45) eols ::= */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  configparserTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  configparserCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  configparserARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* metaline ::= condlines EOL */
#line 366 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{ yymsp[-1].minor.yy20 = NULL; }
#line 1457 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,1,&yymsp[0].minor);
        break;
      case 1: /* varline ::= key ASSIGN expression */
#line 395 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  if (ctx->ok) {
    buffer_copy_buffer(&yymsp[0].minor.yy35->key, yymsp[-2].minor.yy0);
    if (strncmp(yymsp[-2].minor.yy0->ptr, "env.", sizeof("env.") - 1) == 0) {
      fprintf(stderr, "Setting env variable is not supported in conditional %d %s: %s\n",
          ctx->current->context_ndx,
          ctx->current->key.ptr, yymsp[-2].minor.yy0->ptr);
      ctx->ok = 0;
    } else if (NULL == array_get_element_klen(ctx->current->value, BUF_PTR_LEN(&yymsp[0].minor.yy35->key))) {
      array_insert_unique(ctx->current->value, yymsp[0].minor.yy35);
      yymsp[0].minor.yy35 = NULL;
    } else {
      fprintf(stderr, "Duplicate config variable in conditional %d %s: %s\n",
              ctx->current->context_ndx,
              ctx->current->key.ptr, yymsp[0].minor.yy35->key.ptr);
      ctx->ok = 0;
    }
  }
  buffer_free(yymsp[-2].minor.yy0);
  yymsp[-2].minor.yy0 = NULL;
  if (yymsp[0].minor.yy35) yymsp[0].minor.yy35->fn->free(yymsp[0].minor.yy35);
  yymsp[0].minor.yy35 = NULL;
}
#line 1485 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,2,&yymsp[-1].minor);
        break;
      case 2: /* varline ::= key FORCE_ASSIGN expression */
#line 419 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  if (ctx->ok) {
    if (strncmp(yymsp[-2].minor.yy0->ptr, "env.", sizeof("env.") - 1) == 0) {
      fprintf(stderr, "Setting env variable is not supported in conditional %d %s: %s\n",
              ctx->current->context_ndx,
              ctx->current->key.ptr, yymsp[-2].minor.yy0->ptr);
      ctx->ok = 0;
    } else {
      buffer_copy_buffer(&yymsp[0].minor.yy35->key, yymsp[-2].minor.yy0);
      array_replace(ctx->current->value, yymsp[0].minor.yy35);
      yymsp[0].minor.yy35 = NULL;
    }
  }
  buffer_free(yymsp[-2].minor.yy0);
  yymsp[-2].minor.yy0 = NULL;
  if (yymsp[0].minor.yy35) yymsp[0].minor.yy35->fn->free(yymsp[0].minor.yy35);
  yymsp[0].minor.yy35 = NULL;
}
#line 1508 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,3,&yymsp[-1].minor);
        break;
      case 3: /* varline ::= key APPEND expression */
#line 438 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  if (ctx->ok) {
    array *vars = ctx->current->value;
    data_unset *du;

    if (strncmp(yymsp[-2].minor.yy0->ptr, "env.", sizeof("env.") - 1) == 0) {
      fprintf(stderr, "Appending env variable is not supported in conditional %d %s: %s\n",
          ctx->current->context_ndx,
          ctx->current->key.ptr, yymsp[-2].minor.yy0->ptr);
      ctx->ok = 0;
    } else if (NULL != (du = array_extract_element_klen(vars, BUF_PTR_LEN(yymsp[-2].minor.yy0))) || NULL != (du = configparser_get_variable(ctx, yymsp[-2].minor.yy0))) {
      du = configparser_merge_data(du, yymsp[0].minor.yy35);
      if (NULL == du) {
        ctx->ok = 0;
      }
      else {
        buffer_copy_buffer(&du->key, yymsp[-2].minor.yy0);
        array_insert_unique(ctx->current->value, du);
      }
    } else {
      buffer_copy_buffer(&yymsp[0].minor.yy35->key, yymsp[-2].minor.yy0);
      array_insert_unique(ctx->current->value, yymsp[0].minor.yy35);
      yymsp[0].minor.yy35 = NULL;
    }
  }
  buffer_free(yymsp[-2].minor.yy0);
  yymsp[-2].minor.yy0 = NULL;
  if (yymsp[0].minor.yy35) yymsp[0].minor.yy35->fn->free(yymsp[0].minor.yy35);
  yymsp[0].minor.yy35 = NULL;
}
#line 1543 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,4,&yymsp[-1].minor);
        break;
      case 4: /* key ::= LKEY */
#line 469 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  if (strchr(yymsp[0].minor.yy0->ptr, '.') == NULL) {
    buffer_copy_string((yylhsminor.yy0 = buffer_init()), "var.");
    buffer_append_string_buffer(yylhsminor.yy0, yymsp[0].minor.yy0);
  } else {
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    yymsp[0].minor.yy0 = NULL;
  }
  buffer_free(yymsp[0].minor.yy0);
  yymsp[0].minor.yy0 = NULL;
}
#line 1559 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 5: /* expression ::= expression PLUS value */
#line 481 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yylhsminor.yy35 = NULL;
  if (ctx->ok) {
    yylhsminor.yy35 = configparser_merge_data(yymsp[-2].minor.yy35, yymsp[0].minor.yy35);
    yymsp[-2].minor.yy35 = NULL;
    if (NULL == yylhsminor.yy35) {
      ctx->ok = 0;
    }
  }
  if (yymsp[-2].minor.yy35) yymsp[-2].minor.yy35->fn->free(yymsp[-2].minor.yy35);
  yymsp[-2].minor.yy35 = NULL;
  if (yymsp[0].minor.yy35) yymsp[0].minor.yy35->fn->free(yymsp[0].minor.yy35);
  yymsp[0].minor.yy35 = NULL;
}
#line 1578 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,6,&yymsp[-1].minor);
  yymsp[-2].minor.yy35 = yylhsminor.yy35;
        break;
      case 6: /* expression ::= value */
      case 16: /* aelement ::= expression */ yytestcase(yyruleno==16);
#line 496 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yylhsminor.yy35 = yymsp[0].minor.yy35;
  yymsp[0].minor.yy35 = NULL;
}
#line 1589 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yymsp[0].minor.yy35 = yylhsminor.yy35;
        break;
      case 7: /* value ::= key */
#line 501 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yylhsminor.yy35 = NULL;
  if (ctx->ok) {
    if (strncmp(yymsp[0].minor.yy0->ptr, "env.", sizeof("env.") - 1) == 0) {
      char *env;

      if (NULL != (env = getenv(yymsp[0].minor.yy0->ptr + 4))) {
        data_string *ds;
        ds = array_data_string_init();
        buffer_append_string(&ds->value, env);
        yylhsminor.yy35 = (data_unset *)ds;
      }
      else {
        fprintf(stderr, "Undefined env variable: %s\n", yymsp[0].minor.yy0->ptr + 4);
        ctx->ok = 0;
      }
    } else if (NULL == (yylhsminor.yy35 = configparser_get_variable(ctx, yymsp[0].minor.yy0))) {
      fprintf(stderr, "Undefined config variable: %s\n", yymsp[0].minor.yy0->ptr);
      ctx->ok = 0;
    }
  }
  buffer_free(yymsp[0].minor.yy0);
  yymsp[0].minor.yy0 = NULL;
}
#line 1618 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yymsp[0].minor.yy35 = yylhsminor.yy35;
        break;
      case 8: /* value ::= STRING */
#line 526 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yylhsminor.yy35 = (data_unset *)array_data_string_init();
  /* assumes array_data_string_init() result does not need swap, buffer_free()*/
  memcpy(&((data_string *)yylhsminor.yy35)->value, yymsp[0].minor.yy0, sizeof(*yymsp[0].minor.yy0));
  free(yymsp[0].minor.yy0);
  yymsp[0].minor.yy0 = NULL;
}
#line 1630 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yymsp[0].minor.yy35 = yylhsminor.yy35;
        break;
      case 9: /* value ::= INTEGER */
#line 534 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  char *endptr;
  yylhsminor.yy35 = (data_unset *)array_data_integer_init();
  errno = 0;
  ((data_integer *)(yylhsminor.yy35))->value = strtol(yymsp[0].minor.yy0->ptr, &endptr, 10);
  /* skip trailing whitespace */
  if (endptr != yymsp[0].minor.yy0->ptr) while (isspace(*(unsigned char *)endptr)) endptr++;
  if (0 != errno || *endptr != '\0') {
    fprintf(stderr, "error parsing number: '%s'\n", yymsp[0].minor.yy0->ptr);
    ctx->ok = 0;
  }
  buffer_free(yymsp[0].minor.yy0);
  yymsp[0].minor.yy0 = NULL;
}
#line 1649 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yymsp[0].minor.yy35 = yylhsminor.yy35;
        break;
      case 10: /* value ::= array */
#line 548 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yylhsminor.yy35 = (data_unset *)array_data_array_init();
  /* assumes array_data_array_init() result does not need swap, array_free() */
  memcpy(&((data_array *)(yylhsminor.yy35))->value, yymsp[0].minor.yy66, sizeof(*yymsp[0].minor.yy66));
  free(yymsp[0].minor.yy66);
  yymsp[0].minor.yy66 = NULL;
}
#line 1661 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yymsp[0].minor.yy35 = yylhsminor.yy35;
        break;
      case 11: /* array ::= LPARAN RPARAN */
{  yy_destructor(yypParser,9,&yymsp[-1].minor);
#line 555 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yymsp[-1].minor.yy66 = array_init(8);
}
#line 1670 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,10,&yymsp[0].minor);
}
        break;
      case 12: /* array ::= LPARAN aelements RPARAN */
{  yy_destructor(yypParser,9,&yymsp[-2].minor);
#line 558 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yymsp[-2].minor.yy66 = yymsp[-1].minor.yy66;
  yymsp[-1].minor.yy66 = NULL;
}
#line 1681 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,10,&yymsp[0].minor);
}
        break;
      case 13: /* aelements ::= aelements COMMA aelement */
#line 563 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yylhsminor.yy66 = NULL;
  if (ctx->ok) {
    if (buffer_is_unset(&yymsp[0].minor.yy35->key) ||
        NULL == array_get_element_klen(yymsp[-2].minor.yy66, BUF_PTR_LEN(&yymsp[0].minor.yy35->key))) {
      array_insert_unique(yymsp[-2].minor.yy66, yymsp[0].minor.yy35);
      yymsp[0].minor.yy35 = NULL;
    } else {
      fprintf(stderr, "Error: duplicate array-key: %s. Please get rid of the duplicate entry.\n",
              yymsp[0].minor.yy35->key.ptr);
      ctx->ok = 0;
    }

    yylhsminor.yy66 = yymsp[-2].minor.yy66;
    yymsp[-2].minor.yy66 = NULL;
  }
  array_free(yymsp[-2].minor.yy66);
  yymsp[-2].minor.yy66 = NULL;
  if (yymsp[0].minor.yy35) yymsp[0].minor.yy35->fn->free(yymsp[0].minor.yy35);
  yymsp[0].minor.yy35 = NULL;
}
#line 1708 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,11,&yymsp[-1].minor);
  yymsp[-2].minor.yy66 = yylhsminor.yy66;
        break;
      case 14: /* aelements ::= aelements COMMA */
#line 585 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yylhsminor.yy66 = yymsp[-1].minor.yy66;
  yymsp[-1].minor.yy66 = NULL;
}
#line 1718 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,11,&yymsp[0].minor);
  yymsp[-1].minor.yy66 = yylhsminor.yy66;
        break;
      case 15: /* aelements ::= aelement */
#line 590 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yylhsminor.yy66 = NULL;
  if (ctx->ok) {
    yylhsminor.yy66 = array_init(4);
    array_insert_unique(yylhsminor.yy66, yymsp[0].minor.yy35);
    yymsp[0].minor.yy35 = NULL;
  }
  if (yymsp[0].minor.yy35) yymsp[0].minor.yy35->fn->free(yymsp[0].minor.yy35);
  yymsp[0].minor.yy35 = NULL;
}
#line 1734 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yymsp[0].minor.yy66 = yylhsminor.yy66;
        break;
      case 17: /* aelement ::= stringop ARRAY_ASSIGN expression */
#line 605 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yylhsminor.yy35 = NULL;
  if (ctx->ok) {
    buffer_copy_buffer(&yymsp[0].minor.yy35->key, yymsp[-2].minor.yy0);

    yylhsminor.yy35 = yymsp[0].minor.yy35;
    yymsp[0].minor.yy35 = NULL;
  }
  if (yymsp[0].minor.yy35) yymsp[0].minor.yy35->fn->free(yymsp[0].minor.yy35);
  yymsp[0].minor.yy35 = NULL;
  buffer_free(yymsp[-2].minor.yy0);
  yymsp[-2].minor.yy0 = NULL;
}
#line 1752 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,12,&yymsp[-1].minor);
  yymsp[-2].minor.yy35 = yylhsminor.yy35;
        break;
      case 18: /* globalstart ::= GLOBAL */
{  yy_destructor(yypParser,13,&yymsp[0].minor);
#line 622 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  data_config *dc;
  dc = configparser_get_data_config(ctx->srv->config_context, CONST_STR_LEN("global"));
  configparser_push(ctx, dc, 0);
}
#line 1764 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
        break;
      case 19: /* global ::= globalstart LCURLY metalines RCURLY */
#line 628 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  configparser_pop(ctx);
}
#line 1772 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,14,&yymsp[-2].minor);
  yy_destructor(yypParser,15,&yymsp[0].minor);
        break;
      case 20: /* condlines ::= condlines eols ELSE condline */
#line 632 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yylhsminor.yy20 = NULL;
  if (ctx->ok) {
    if (yymsp[-3].minor.yy20->context_ndx >= yymsp[0].minor.yy20->context_ndx) {
      fprintf(stderr, "unreachable else condition\n");
      ctx->ok = 0;
    }
    if (yymsp[-3].minor.yy20->cond == CONFIG_COND_ELSE) {
      fprintf(stderr, "unreachable condition following else catch-all\n");
      ctx->ok = 0;
    }
    yymsp[0].minor.yy20->prev = yymsp[-3].minor.yy20;
    yymsp[-3].minor.yy20->next = yymsp[0].minor.yy20;
    yylhsminor.yy20 = yymsp[0].minor.yy20;
  }
  yymsp[-3].minor.yy20 = NULL;
  yymsp[0].minor.yy20 = NULL;
}
#line 1796 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,16,&yymsp[-1].minor);
  yymsp[-3].minor.yy20 = yylhsminor.yy20;
        break;
      case 21: /* condlines ::= condlines eols ELSE cond_else */
#line 651 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yylhsminor.yy20 = NULL;
  if (ctx->ok) {
    if (yymsp[-3].minor.yy20->context_ndx >= yymsp[0].minor.yy20->context_ndx) {
      fprintf(stderr, "unreachable else condition\n");
      ctx->ok = 0;
    }
    if (yymsp[-3].minor.yy20->cond == CONFIG_COND_ELSE) {
      fprintf(stderr, "unreachable condition following else catch-all\n");
      ctx->ok = 0;
    }
  }
  if (ctx->ok) {
    data_config *dc;
    dc = (data_config *)array_extract_element_klen(ctx->all_configs, BUF_PTR_LEN(&yymsp[0].minor.yy20->key));
    if (yymsp[0].minor.yy20 != dc) ctx->ok = 0; /*(should not happen)*/
  }
  if (ctx->ok) {
    buffer_copy_buffer(&yymsp[0].minor.yy20->key, &yymsp[-3].minor.yy20->key);
    yymsp[0].minor.yy20->comp_key = yymsp[0].minor.yy20->key.ptr + (yymsp[-3].minor.yy20->comp_key - yymsp[-3].minor.yy20->key.ptr);
    yymsp[0].minor.yy20->comp = yymsp[-3].minor.yy20->comp;
    /*buffer_copy_buffer(&yymsp[0].minor.yy20->string, &yymsp[-3].minor.yy20->string);*/
    /* -2 for "==" and minus 3 for spaces and quotes around string (in key) */
    size_t pos;
    pos = buffer_clen(&yymsp[0].minor.yy20->key) - buffer_clen(&yymsp[-3].minor.yy20->string) - 5;
    switch(yymsp[-3].minor.yy20->cond) {
    case CONFIG_COND_NE:
      yymsp[0].minor.yy20->key.ptr[pos] = '='; /* opposite cond */
      /*buffer_copy_string_len(yymsp[0].minor.yy20->op, CONST_STR_LEN("=="));*/
      break;
    case CONFIG_COND_EQ:
      yymsp[0].minor.yy20->key.ptr[pos] = '!'; /* opposite cond */
      /*buffer_copy_string_len(yymsp[0].minor.yy20->op, CONST_STR_LEN("!="));*/
      break;
    case CONFIG_COND_NOMATCH:
      yymsp[0].minor.yy20->key.ptr[pos] = '='; /* opposite cond */
      /*buffer_copy_string_len(yymsp[0].minor.yy20->op, CONST_STR_LEN("=~"));*/
      break;
    case CONFIG_COND_MATCH:
      yymsp[0].minor.yy20->key.ptr[pos] = '!'; /* opposite cond */
      /*buffer_copy_string_len(yymsp[0].minor.yy20->op, CONST_STR_LEN("!~"));*/
      break;
    case CONFIG_COND_PREFIX:
      yymsp[0].minor.yy20->key.ptr[pos] = '!'; /* opposite cond */
      /*buffer_copy_string_len(yymsp[0].minor.yy20->op, CONST_STR_LEN("!^"));*/
      break;
    case CONFIG_COND_SUFFIX:
      yymsp[0].minor.yy20->key.ptr[pos] = '!'; /* opposite cond */
      /*buffer_copy_string_len(yymsp[0].minor.yy20->op, CONST_STR_LEN("!$"));*/
      break;
    default: /* should not happen; CONFIG_COND_ELSE checked further above */
      ck_assert_failed(__FILE__, __LINE__, "unexpected enum value");
    }

    data_config *dc;
    if (NULL == (dc = configparser_get_data_config(ctx->all_configs, BUF_PTR_LEN(&yymsp[0].minor.yy20->key)))) {
      /* re-insert into ctx->all_configs with new yymsp[0].minor.yy20->key */
      array_insert_unique(ctx->all_configs, (data_unset *)yymsp[0].minor.yy20);
      yymsp[0].minor.yy20->prev = yymsp[-3].minor.yy20;
      yymsp[-3].minor.yy20->next = yymsp[0].minor.yy20;
    } else {
      fprintf(stderr, "unreachable else condition\n");
      ctx->ok = 0;
      yymsp[0].minor.yy20->fn->free((data_unset *)yymsp[0].minor.yy20);
      yymsp[0].minor.yy20 = dc;
    }

    yylhsminor.yy20 = yymsp[0].minor.yy20;
  }
  yymsp[-3].minor.yy20 = NULL;
  yymsp[0].minor.yy20 = NULL;
}
#line 1874 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,16,&yymsp[-1].minor);
  yymsp[-3].minor.yy20 = yylhsminor.yy20;
        break;
      case 22: /* condlines ::= condline */
#line 724 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yylhsminor.yy20 = yymsp[0].minor.yy20;
  yymsp[0].minor.yy20 = NULL;
}
#line 1884 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yymsp[0].minor.yy20 = yylhsminor.yy20;
        break;
      case 23: /* condline ::= context LCURLY metalines RCURLY */
      case 24: /* cond_else ::= context_else LCURLY metalines RCURLY */ yytestcase(yyruleno==24);
#line 729 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yymsp[-3].minor.yy20 = NULL;
  if (ctx->ok) {
    yymsp[-3].minor.yy20 = configparser_pop(ctx);
  }
}
#line 1896 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,14,&yymsp[-2].minor);
  yy_destructor(yypParser,15,&yymsp[0].minor);
        break;
      case 25: /* context ::= DOLLAR SRVVARNAME LBRACKET stringop RBRACKET cond expression */
{  yy_destructor(yypParser,17,&yymsp[-6].minor);
#line 743 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{

  if (ctx->ok && yymsp[0].minor.yy35->type != TYPE_STRING) {
    fprintf(stderr, "rvalue must be string\n");
    ctx->ok = 0;
  }

  if (ctx->ok) {
    configparser_parse_condition(ctx, yymsp[-5].minor.yy0, yymsp[-3].minor.yy0, yymsp[-1].minor.yy59, &((data_string *)yymsp[0].minor.yy35)->value);
  }

  buffer_free(yymsp[-5].minor.yy0);
  yymsp[-5].minor.yy0 = NULL;
  buffer_free(yymsp[-3].minor.yy0);
  yymsp[-3].minor.yy0 = NULL;
  if (yymsp[0].minor.yy35) yymsp[0].minor.yy35->fn->free(yymsp[0].minor.yy35);
  yymsp[0].minor.yy35 = NULL;
}
#line 1921 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yy_destructor(yypParser,19,&yymsp[-4].minor);
  yy_destructor(yypParser,20,&yymsp[-2].minor);
}
        break;
      case 26: /* context_else ::= */
#line 762 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  if (ctx->ok) {
    configparser_parse_else_condition(ctx);
  }
}
#line 1933 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
        break;
      case 27: /* cond ::= EQ */
{  yy_destructor(yypParser,21,&yymsp[0].minor);
#line 768 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yymsp[0].minor.yy59 = CONFIG_COND_EQ;
}
#line 1941 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
        break;
      case 28: /* cond ::= MATCH */
{  yy_destructor(yypParser,22,&yymsp[0].minor);
#line 771 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yymsp[0].minor.yy59 = CONFIG_COND_MATCH;
}
#line 1950 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
        break;
      case 29: /* cond ::= NE */
{  yy_destructor(yypParser,23,&yymsp[0].minor);
#line 774 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yymsp[0].minor.yy59 = CONFIG_COND_NE;
}
#line 1959 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
        break;
      case 30: /* cond ::= NOMATCH */
{  yy_destructor(yypParser,24,&yymsp[0].minor);
#line 777 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yymsp[0].minor.yy59 = CONFIG_COND_NOMATCH;
}
#line 1968 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
        break;
      case 31: /* cond ::= PREFIX */
{  yy_destructor(yypParser,25,&yymsp[0].minor);
#line 780 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yymsp[0].minor.yy59 = CONFIG_COND_PREFIX;
}
#line 1977 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
        break;
      case 32: /* cond ::= SUFFIX */
{  yy_destructor(yypParser,26,&yymsp[0].minor);
#line 783 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yymsp[0].minor.yy59 = CONFIG_COND_SUFFIX;
}
#line 1986 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
        break;
      case 33: /* stringop ::= expression */
#line 787 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  yylhsminor.yy0 = NULL;
  if (ctx->ok) {
    if (yymsp[0].minor.yy35->type == TYPE_STRING) {
      buffer_copy_buffer((yylhsminor.yy0 = buffer_init()), &((data_string*)yymsp[0].minor.yy35)->value);
    } else if (yymsp[0].minor.yy35->type == TYPE_INTEGER) {
      yylhsminor.yy0 = buffer_init();
      buffer_append_int(yylhsminor.yy0, ((data_integer *)yymsp[0].minor.yy35)->value);
    } else {
      fprintf(stderr, "operand must be string\n");
      ctx->ok = 0;
    }
  }
  if (yymsp[0].minor.yy35) yymsp[0].minor.yy35->fn->free(yymsp[0].minor.yy35);
  yymsp[0].minor.yy35 = NULL;
}
#line 2007 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 34: /* include ::= INCLUDE stringop */
{  yy_destructor(yypParser,27,&yymsp[-1].minor);
#line 804 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  if (ctx->ok) {
    if (0 != config_parse_file(ctx->srv, ctx, yymsp[0].minor.yy0->ptr)) {
      ctx->ok = 0;
    }
  }
  buffer_free(yymsp[0].minor.yy0);
  yymsp[0].minor.yy0 = NULL;
}
#line 2022 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
        break;
      case 35: /* include_shell ::= INCLUDE_SHELL stringop */
{  yy_destructor(yypParser,28,&yymsp[-1].minor);
#line 814 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
  if (ctx->ok) {
    if (0 != config_parse_cmd(ctx->srv, ctx, yymsp[0].minor.yy0->ptr)) {
      ctx->ok = 0;
    }
  }
  buffer_free(yymsp[0].minor.yy0);
  yymsp[0].minor.yy0 = NULL;
}
#line 2037 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
        break;
      case 43: /* metaline ::= EOL */
      case 44: /* eols ::= EOL */ yytestcase(yyruleno==44);
{  yy_destructor(yypParser,1,&yymsp[0].minor);
#line 369 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"
{
}
#line 2046 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
}
        break;
      default:
      /* (36) input ::= metalines */ yytestcase(yyruleno==36);
      /* (37) metalines ::= metalines metaline */ yytestcase(yyruleno==37);
      /* (38) metalines ::= */ yytestcase(yyruleno==38);
      /* (39) metaline ::= varline (OPTIMIZED OUT) */ assert(yyruleno!=39);
      /* (40) metaline ::= global (OPTIMIZED OUT) */ assert(yyruleno!=40);
      /* (41) metaline ::= include (OPTIMIZED OUT) */ assert(yyruleno!=41);
      /* (42) metaline ::= include_shell (OPTIMIZED OUT) */ assert(yyruleno!=42);
      /* (45) eols ::= */ yytestcase(yyruleno==45);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  configparserARG_FETCH
  configparserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
#line 357 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.y"

  ctx->ok = 0;
#line 2102 "/home/gps/src/gstrauss/cygport/cygport-lighttpd/lighttpd-1.4.76-1.x86_64/src/lighttpd-1.4.76/src/configparser.c"
/************ End %parse_failure code *****************************************/
  configparserARG_STORE /* Suppress warning about unused %extra_argument variable */
  configparserCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  configparserTOKENTYPE yyminor         /* The minor type of the error token */
){
  (void)yymajor;
  (void)yyminor;
  configparserARG_FETCH
  configparserCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
/************ End %syntax_error code ******************************************/
  configparserARG_STORE /* Suppress warning about unused %extra_argument variable */
  configparserCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  configparserARG_FETCH
  configparserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  configparserARG_STORE /* Suppress warning about unused %extra_argument variable */
  configparserCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "configparserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void configparser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  configparserTOKENTYPE yyminor       /* The value for the token */
  configparserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  configparserCTX_FETCH
  configparserARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  while(1){ /* Exit by "break" */
    assert( yypParser->yytos>=yypParser->yystack );
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      unsigned int yyruleno = yyact - YY_MIN_REDUCE; /* Reduce by this rule */
#ifndef NDEBUG
      assert( yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) );
      if( yyTraceFILE ){
        int yysize = yyRuleInfoNRhs[yyruleno];
        if( yysize ){
          fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
            yyTracePrompt,
            yyruleno, yyRuleName[yyruleno],
            yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
            yypParser->yytos[yysize].stateno);
        }else{
          fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
            yyTracePrompt, yyruleno, yyRuleName[yyruleno],
            yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
        }
      }
#endif /* NDEBUG */

      /* Check that the stack is large enough to grow by a single entry
      ** if the RHS of the rule is empty.  This ensures that there is room
      ** enough on the stack to push the LHS value */
      if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
        if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
          yypParser->yyhwm++;
          assert( yypParser->yyhwm ==
                  (int)(yypParser->yytos - yypParser->yystack));
        }
#endif
#if YYSTACKDEPTH>0
        if( yypParser->yytos>=yypParser->yystackEnd ){
          yyStackOverflow(yypParser);
          break;
        }
#else
        if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
          if( yyGrowStack(yypParser) ){
            yyStackOverflow(yypParser);
            break;
          }
        }
#endif
      }
      yyact = yy_reduce(yypParser,yyruleno,yymajor,yyminor configparserCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos > yypParser->yystack ){
          yyact = yy_find_reduce_action(yypParser->yytos->stateno,
                                        YYERRORSYMBOL);
          if( yyact<=YY_MAX_SHIFTREDUCE ) break;
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos <= yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int configparserFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
