; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=riscv32 < %s | FileCheck -check-prefixes=CHECK,RV32I %s
; RUN: llc -global-isel -mtriple=riscv64 < %s | FileCheck -check-prefix=RV64I %s

declare i32 @external_many_args(i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) nounwind

define i32 @test_call_external_many_args(i32 %a) nounwind {
; CHECK-LABEL: test_call_external_many_args:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    sw a0, 0(sp)
; CHECK-NEXT:    sw a0, 4(sp)
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    mv a3, a0
; CHECK-NEXT:    mv a4, a0
; CHECK-NEXT:    mv a5, a0
; CHECK-NEXT:    mv a6, a0
; CHECK-NEXT:    mv a7, a0
; CHECK-NEXT:    call external_many_args
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
;
; RV64I-LABEL: test_call_external_many_args:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    sd a0, 0(sp)
; RV64I-NEXT:    sd a0, 8(sp)
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a2, a0
; RV64I-NEXT:    mv a3, a0
; RV64I-NEXT:    mv a4, a0
; RV64I-NEXT:    mv a5, a0
; RV64I-NEXT:    mv a6, a0
; RV64I-NEXT:    mv a7, a0
; RV64I-NEXT:    call external_many_args
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
  %1 = call i32 @external_many_args(i32 %a, i32 %a, i32 %a, i32 %a, i32 %a,
                                    i32 %a, i32 %a, i32 %a, i32 %a, i32 %a)
  ret i32 %a
}

define fastcc void @fastcc_call_nonfastcc(){
; CHECK-LABEL: fastcc_call_nonfastcc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -4
; CHECK-NEXT:    li t0, 9
; CHECK-NEXT:    li t1, 10
; CHECK-NEXT:    li a0, 1
; CHECK-NEXT:    li a1, 2
; CHECK-NEXT:    li a2, 3
; CHECK-NEXT:    li a3, 4
; CHECK-NEXT:    li a4, 5
; CHECK-NEXT:    li a5, 6
; CHECK-NEXT:    li a6, 7
; CHECK-NEXT:    li a7, 8
; CHECK-NEXT:    sw t0, 0(sp)
; CHECK-NEXT:    sw t1, 4(sp)
; CHECK-NEXT:    call external_many_args
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    .cfi_restore ra
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
;
; RV64I-LABEL: fastcc_call_nonfastcc:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    .cfi_def_cfa_offset 32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    li t0, 9
; RV64I-NEXT:    li t1, 10
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    li a1, 2
; RV64I-NEXT:    li a2, 3
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    li a5, 6
; RV64I-NEXT:    li a6, 7
; RV64I-NEXT:    li a7, 8
; RV64I-NEXT:    sd t0, 0(sp)
; RV64I-NEXT:    sd t1, 8(sp)
; RV64I-NEXT:    call external_many_args
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
  call void @external_many_args(i32 1, i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10)
  ret void
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV32I: {{.*}}
