; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -verify-machineinstrs -mtriple=aarch64-none-linux-gnu < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=arm64-apple-macosx -mcpu=apple-m1 < %s | FileCheck %s --check-prefix=APPLE

define float @float_0mov() {
; CHECK-LABEL: float_0mov:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov s0, #1.00000000
; CHECK-NEXT:    ret
;
; APPLE-LABEL: float_0mov:
; APPLE:       ; %bb.0:
; APPLE-NEXT:    fmov s0, #1.00000000
; APPLE-NEXT:    ret
  ret float 1.0
}

define float @float_1mov() {
; CHECK-LABEL: float_1mov:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2143289344 // =0x7fc00000
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    ret
;
; APPLE-LABEL: float_1mov:
; APPLE:       ; %bb.0:
; APPLE-NEXT:    mov w8, #2143289344 ; =0x7fc00000
; APPLE-NEXT:    fmov s0, w8
; APPLE-NEXT:    ret
  ret float 0x7FF8000000000000
}

define float @float_2mov() {
; CHECK-LABEL: float_2mov:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #34952 // =0x8888
; CHECK-NEXT:    movk w8, #32704, lsl #16
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    ret
;
; APPLE-LABEL: float_2mov:
; APPLE:       ; %bb.0:
; APPLE-NEXT:    mov w8, #34952 ; =0x8888
; APPLE-NEXT:    movk w8, #32704, lsl #16
; APPLE-NEXT:    fmov s0, w8
; APPLE-NEXT:    ret
  ret float 0x7FF8111100000000
}

define double @double_0mov() {
; CHECK-LABEL: double_0mov:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov d0, #1.00000000
; CHECK-NEXT:    ret
;
; APPLE-LABEL: double_0mov:
; APPLE:       ; %bb.0:
; APPLE-NEXT:    fmov d0, #1.00000000
; APPLE-NEXT:    ret
  ret double 1.0
}

define double @double_1mov() {
; CHECK-LABEL: double_1mov:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #4096 // =0x1000
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    ret
;
; APPLE-LABEL: double_1mov:
; APPLE:       ; %bb.0:
; APPLE-NEXT:    mov x8, #4096 ; =0x1000
; APPLE-NEXT:    fmov d0, x8
; APPLE-NEXT:    ret
  ret double 0x1000
}

define double @double_2mov() {
; CHECK-LABEL: double_2mov:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #4096 // =0x1000
; CHECK-NEXT:    movk x8, #8192, lsl #16
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    ret
;
; APPLE-LABEL: double_2mov:
; APPLE:       ; %bb.0:
; APPLE-NEXT:    mov x8, #4096 ; =0x1000
; APPLE-NEXT:    movk x8, #8192, lsl #16
; APPLE-NEXT:    fmov d0, x8
; APPLE-NEXT:    ret
  ret double 0x20001000
}

define double @double_3mov() {
; CHECK-LABEL: double_3mov:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI6_0
; CHECK-NEXT:    ldr d0, [x8, :lo12:.LCPI6_0]
; CHECK-NEXT:    ret
;
; APPLE-LABEL: double_3mov:
; APPLE:       ; %bb.0:
; APPLE-NEXT:    mov x8, #4096 ; =0x1000
; APPLE-NEXT:    movk x8, #8192, lsl #16
; APPLE-NEXT:    movk x8, #12288, lsl #32
; APPLE-NEXT:    fmov d0, x8
; APPLE-NEXT:    ret
  ret double 0x300020001000
}

define double @double_4mov() {
; CHECK-LABEL: double_4mov:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI7_0
; CHECK-NEXT:    ldr d0, [x8, :lo12:.LCPI7_0]
; CHECK-NEXT:    ret
;
; APPLE-LABEL: double_4mov:
; APPLE:       ; %bb.0:
; APPLE-NEXT:    mov x8, #4096 ; =0x1000
; APPLE-NEXT:    movk x8, #8192, lsl #16
; APPLE-NEXT:    movk x8, #12288, lsl #32
; APPLE-NEXT:    movk x8, #16384, lsl #48
; APPLE-NEXT:    fmov d0, x8
; APPLE-NEXT:    ret
  ret double 0x4000300020001000
}
