; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=AVX512

define i32 @reduce_f64(i32 %arg) {
; SSE2-LABEL: 'reduce_f64'
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V1 = call double @llvm.vector.reduce.fmax.v1f64(<1 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:7 Lat:7 SizeLat:7 for: %V2 = call double @llvm.vector.reduce.fmax.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:13 Lat:13 SizeLat:13 for: %V4 = call double @llvm.vector.reduce.fmax.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:25 Lat:25 SizeLat:25 for: %V8 = call double @llvm.vector.reduce.fmax.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:33 CodeSize:49 Lat:49 SizeLat:49 for: %V16 = call double @llvm.vector.reduce.fmax.v16f64(<16 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'reduce_f64'
; SSE41-NEXT:  Cost Model: Found costs of 0 for: %V1 = call double @llvm.vector.reduce.fmax.v1f64(<1 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:7 Lat:7 SizeLat:7 for: %V2 = call double @llvm.vector.reduce.fmax.v2f64(<2 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:13 Lat:13 SizeLat:13 for: %V4 = call double @llvm.vector.reduce.fmax.v4f64(<4 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:25 Lat:25 SizeLat:25 for: %V8 = call double @llvm.vector.reduce.fmax.v8f64(<8 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:33 CodeSize:49 Lat:49 SizeLat:49 for: %V16 = call double @llvm.vector.reduce.fmax.v16f64(<16 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'reduce_f64'
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V1 = call double @llvm.vector.reduce.fmax.v1f64(<1 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:5 SizeLat:6 for: %V2 = call double @llvm.vector.reduce.fmax.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:9 SizeLat:11 for: %V4 = call double @llvm.vector.reduce.fmax.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:17 Lat:17 SizeLat:21 for: %V8 = call double @llvm.vector.reduce.fmax.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:33 CodeSize:33 Lat:33 SizeLat:41 for: %V16 = call double @llvm.vector.reduce.fmax.v16f64(<16 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'reduce_f64'
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V1 = call double @llvm.vector.reduce.fmax.v1f64(<1 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:7 SizeLat:6 for: %V2 = call double @llvm.vector.reduce.fmax.v2f64(<2 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:14 SizeLat:12 for: %V4 = call double @llvm.vector.reduce.fmax.v4f64(<4 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:11 Lat:21 SizeLat:22 for: %V8 = call double @llvm.vector.reduce.fmax.v8f64(<8 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:17 Lat:35 SizeLat:42 for: %V16 = call double @llvm.vector.reduce.fmax.v16f64(<16 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'reduce_f64'
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V1 = call double @llvm.vector.reduce.fmax.v1f64(<1 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:8 SizeLat:6 for: %V2 = call double @llvm.vector.reduce.fmax.v2f64(<2 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:16 SizeLat:12 for: %V4 = call double @llvm.vector.reduce.fmax.v4f64(<4 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:11 Lat:23 SizeLat:18 for: %V8 = call double @llvm.vector.reduce.fmax.v8f64(<8 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:17 Lat:37 SizeLat:30 for: %V16 = call double @llvm.vector.reduce.fmax.v16f64(<16 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'reduce_f64'
; AVX512-NEXT:  Cost Model: Found costs of 0 for: %V1 = call double @llvm.vector.reduce.fmax.v1f64(<1 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %V2 = call double @llvm.vector.reduce.fmax.v2f64(<2 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:6 SizeLat:8 for: %V4 = call double @llvm.vector.reduce.fmax.v4f64(<4 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:12 Lat:9 SizeLat:12 for: %V8 = call double @llvm.vector.reduce.fmax.v8f64(<8 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:15 Lat:12 SizeLat:15 for: %V16 = call double @llvm.vector.reduce.fmax.v16f64(<16 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %V1  = call double @llvm.vector.reduce.fmax.v1f64(<1 x double> undef)
  %V2  = call double @llvm.vector.reduce.fmax.v2f64(<2 x double> undef)
  %V4  = call double @llvm.vector.reduce.fmax.v4f64(<4 x double> undef)
  %V8  = call double @llvm.vector.reduce.fmax.v8f64(<8 x double> undef)
  %V16 = call double @llvm.vector.reduce.fmax.v16f64(<16 x double> undef)
  ret i32 undef
}

define i32 @reduce_f32(i32 %arg) {
; SSE2-LABEL: 'reduce_f32'
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V1 = call float @llvm.vector.reduce.fmax.v1f32(<1 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:7 Lat:7 SizeLat:7 for: %V2 = call float @llvm.vector.reduce.fmax.v2f32(<2 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:14 Lat:14 SizeLat:14 for: %V4 = call float @llvm.vector.reduce.fmax.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:20 Lat:20 SizeLat:20 for: %V8 = call float @llvm.vector.reduce.fmax.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:32 Lat:32 SizeLat:32 for: %V16 = call float @llvm.vector.reduce.fmax.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:38 CodeSize:56 Lat:56 SizeLat:56 for: %V32 = call float @llvm.vector.reduce.fmax.v32f32(<32 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'reduce_f32'
; SSE41-NEXT:  Cost Model: Found costs of 0 for: %V1 = call float @llvm.vector.reduce.fmax.v1f32(<1 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:7 Lat:7 SizeLat:7 for: %V2 = call float @llvm.vector.reduce.fmax.v2f32(<2 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:14 Lat:14 SizeLat:14 for: %V4 = call float @llvm.vector.reduce.fmax.v4f32(<4 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:20 Lat:20 SizeLat:20 for: %V8 = call float @llvm.vector.reduce.fmax.v8f32(<8 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:32 Lat:32 SizeLat:32 for: %V16 = call float @llvm.vector.reduce.fmax.v16f32(<16 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:38 CodeSize:56 Lat:56 SizeLat:56 for: %V32 = call float @llvm.vector.reduce.fmax.v32f32(<32 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'reduce_f32'
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V1 = call float @llvm.vector.reduce.fmax.v1f32(<1 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:5 SizeLat:6 for: %V2 = call float @llvm.vector.reduce.fmax.v2f32(<2 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:10 SizeLat:12 for: %V4 = call float @llvm.vector.reduce.fmax.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:14 SizeLat:17 for: %V8 = call float @llvm.vector.reduce.fmax.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:22 Lat:22 SizeLat:27 for: %V16 = call float @llvm.vector.reduce.fmax.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:38 CodeSize:38 Lat:38 SizeLat:47 for: %V32 = call float @llvm.vector.reduce.fmax.v32f32(<32 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'reduce_f32'
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V1 = call float @llvm.vector.reduce.fmax.v1f32(<1 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:7 SizeLat:6 for: %V2 = call float @llvm.vector.reduce.fmax.v2f32(<2 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:14 SizeLat:12 for: %V4 = call float @llvm.vector.reduce.fmax.v4f32(<4 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:21 SizeLat:18 for: %V8 = call float @llvm.vector.reduce.fmax.v8f32(<8 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:15 Lat:28 SizeLat:28 for: %V16 = call float @llvm.vector.reduce.fmax.v16f32(<16 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:21 Lat:42 SizeLat:48 for: %V32 = call float @llvm.vector.reduce.fmax.v32f32(<32 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'reduce_f32'
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V1 = call float @llvm.vector.reduce.fmax.v1f32(<1 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:8 SizeLat:6 for: %V2 = call float @llvm.vector.reduce.fmax.v2f32(<2 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:16 SizeLat:12 for: %V4 = call float @llvm.vector.reduce.fmax.v4f32(<4 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:12 Lat:24 SizeLat:18 for: %V8 = call float @llvm.vector.reduce.fmax.v8f32(<8 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:15 Lat:31 SizeLat:24 for: %V16 = call float @llvm.vector.reduce.fmax.v16f32(<16 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:21 Lat:45 SizeLat:36 for: %V32 = call float @llvm.vector.reduce.fmax.v32f32(<32 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'reduce_f32'
; AVX512-NEXT:  Cost Model: Found costs of 0 for: %V1 = call float @llvm.vector.reduce.fmax.v1f32(<1 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %V2 = call float @llvm.vector.reduce.fmax.v2f32(<2 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:8 SizeLat:8 for: %V4 = call float @llvm.vector.reduce.fmax.v4f32(<4 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:12 Lat:10 SizeLat:12 for: %V8 = call float @llvm.vector.reduce.fmax.v8f32(<8 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:16 Lat:13 SizeLat:16 for: %V16 = call float @llvm.vector.reduce.fmax.v16f32(<16 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:19 Lat:17 SizeLat:19 for: %V32 = call float @llvm.vector.reduce.fmax.v32f32(<32 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %V1  = call float @llvm.vector.reduce.fmax.v1f32(<1 x float> undef)
  %V2  = call float @llvm.vector.reduce.fmax.v2f32(<2 x float> undef)
  %V4  = call float @llvm.vector.reduce.fmax.v4f32(<4 x float> undef)
  %V8  = call float @llvm.vector.reduce.fmax.v8f32(<8 x float> undef)
  %V16 = call float @llvm.vector.reduce.fmax.v16f32(<16 x float> undef)
  %V32 = call float @llvm.vector.reduce.fmax.v32f32(<32 x float> undef)
  ret i32 undef
}

; Fast Reductions

define i32 @reduce_f64_fast(i32 %arg) {
; SSE-LABEL: 'reduce_f64_fast'
; SSE-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast double @llvm.vector.reduce.fmax.v1f64(<1 x double> undef)
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V2 = call fast double @llvm.vector.reduce.fmax.v2f64(<2 x double> undef)
; SSE-NEXT:  Cost Model: Found costs of 3 for: %V4 = call fast double @llvm.vector.reduce.fmax.v4f64(<4 x double> undef)
; SSE-NEXT:  Cost Model: Found costs of 5 for: %V8 = call fast double @llvm.vector.reduce.fmax.v8f64(<8 x double> undef)
; SSE-NEXT:  Cost Model: Found costs of 9 for: %V16 = call fast double @llvm.vector.reduce.fmax.v16f64(<16 x double> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'reduce_f64_fast'
; AVX-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast double @llvm.vector.reduce.fmax.v1f64(<1 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %V2 = call fast double @llvm.vector.reduce.fmax.v2f64(<2 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of 4 for: %V4 = call fast double @llvm.vector.reduce.fmax.v4f64(<4 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of 5 for: %V8 = call fast double @llvm.vector.reduce.fmax.v8f64(<8 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of 7 for: %V16 = call fast double @llvm.vector.reduce.fmax.v16f64(<16 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'reduce_f64_fast'
; AVX512-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast double @llvm.vector.reduce.fmax.v1f64(<1 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V2 = call fast double @llvm.vector.reduce.fmax.v2f64(<2 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:6 SizeLat:4 for: %V4 = call fast double @llvm.vector.reduce.fmax.v4f64(<4 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:8 SizeLat:6 for: %V8 = call fast double @llvm.vector.reduce.fmax.v8f64(<8 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:9 SizeLat:7 for: %V16 = call fast double @llvm.vector.reduce.fmax.v16f64(<16 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %V1  = call fast double @llvm.vector.reduce.fmax.v1f64(<1 x double> undef)
  %V2  = call fast double @llvm.vector.reduce.fmax.v2f64(<2 x double> undef)
  %V4  = call fast double @llvm.vector.reduce.fmax.v4f64(<4 x double> undef)
  %V8  = call fast double @llvm.vector.reduce.fmax.v8f64(<8 x double> undef)
  %V16 = call fast double @llvm.vector.reduce.fmax.v16f64(<16 x double> undef)
  ret i32 undef
}

define i32 @reduce_f32_fast(i32 %arg) {
; SSE-LABEL: 'reduce_f32_fast'
; SSE-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast float @llvm.vector.reduce.fmax.v1f32(<1 x float> undef)
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V2 = call fast float @llvm.vector.reduce.fmax.v2f32(<2 x float> undef)
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V4 = call fast float @llvm.vector.reduce.fmax.v4f32(<4 x float> undef)
; SSE-NEXT:  Cost Model: Found costs of 5 for: %V8 = call fast float @llvm.vector.reduce.fmax.v8f32(<8 x float> undef)
; SSE-NEXT:  Cost Model: Found costs of 7 for: %V16 = call fast float @llvm.vector.reduce.fmax.v16f32(<16 x float> undef)
; SSE-NEXT:  Cost Model: Found costs of 11 for: %V32 = call fast float @llvm.vector.reduce.fmax.v32f32(<32 x float> undef)
; SSE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'reduce_f32_fast'
; AVX-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast float @llvm.vector.reduce.fmax.v1f32(<1 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %V2 = call fast float @llvm.vector.reduce.fmax.v2f32(<2 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 4 for: %V4 = call fast float @llvm.vector.reduce.fmax.v4f32(<4 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 6 for: %V8 = call fast float @llvm.vector.reduce.fmax.v8f32(<8 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 7 for: %V16 = call fast float @llvm.vector.reduce.fmax.v16f32(<16 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 9 for: %V32 = call fast float @llvm.vector.reduce.fmax.v32f32(<32 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'reduce_f32_fast'
; AVX512-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast float @llvm.vector.reduce.fmax.v1f32(<1 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V2 = call fast float @llvm.vector.reduce.fmax.v2f32(<2 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V4 = call fast float @llvm.vector.reduce.fmax.v4f32(<4 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:10 SizeLat:6 for: %V8 = call fast float @llvm.vector.reduce.fmax.v8f32(<8 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:12 SizeLat:8 for: %V16 = call fast float @llvm.vector.reduce.fmax.v16f32(<16 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:13 SizeLat:9 for: %V32 = call fast float @llvm.vector.reduce.fmax.v32f32(<32 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %V1  = call fast float @llvm.vector.reduce.fmax.v1f32(<1 x float> undef)
  %V2  = call fast float @llvm.vector.reduce.fmax.v2f32(<2 x float> undef)
  %V4  = call fast float @llvm.vector.reduce.fmax.v4f32(<4 x float> undef)
  %V8  = call fast float @llvm.vector.reduce.fmax.v8f32(<8 x float> undef)
  %V16 = call fast float @llvm.vector.reduce.fmax.v16f32(<16 x float> undef)
  %V32 = call fast float @llvm.vector.reduce.fmax.v32f32(<32 x float> undef)
  ret i32 undef
}

declare double @llvm.vector.reduce.fmax.v1f64(<1 x double>)
declare double @llvm.vector.reduce.fmax.v2f64(<2 x double>)
declare double @llvm.vector.reduce.fmax.v4f64(<4 x double>)
declare double @llvm.vector.reduce.fmax.v8f64(<8 x double>)
declare double @llvm.vector.reduce.fmax.v16f64(<16 x double>)

declare float @llvm.vector.reduce.fmax.v1f32(<1 x float>)
declare float @llvm.vector.reduce.fmax.v2f32(<2 x float>)
declare float @llvm.vector.reduce.fmax.v4f32(<4 x float>)
declare float @llvm.vector.reduce.fmax.v8f32(<8 x float>)
declare float @llvm.vector.reduce.fmax.v16f32(<16 x float>)
declare float @llvm.vector.reduce.fmax.v32f32(<32 x float>)
