; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64 -o - %s | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel -global-isel-abort=2 -o - %s 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-GI

; CHECK-GI:       warning: Instruction selection used fallback path for test_umul_i128
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_smul_i128

define i128 @test_uadd_i128(i128 noundef %x, i128 noundef %y) {
; CHECK-SD-LABEL: test_uadd_i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    adds x0, x0, x2
; CHECK-SD-NEXT:    adcs x1, x1, x3
; CHECK-SD-NEXT:    b.lo .LBB0_2
; CHECK-SD-NEXT:  // %bb.1: // %if.then
; CHECK-SD-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    bl error
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    sxtw x0, w0
; CHECK-SD-NEXT:    asr x1, x0, #63
; CHECK-SD-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-SD-NEXT:  .LBB0_2: // %cleanup
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_uadd_i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    adds x0, x0, x2
; CHECK-GI-NEXT:    adcs x1, x1, x3
; CHECK-GI-NEXT:    b.lo .LBB0_2
; CHECK-GI-NEXT:  // %bb.1: // %if.then
; CHECK-GI-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    bl error
; CHECK-GI-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-GI-NEXT:    asr w1, w0, #31
; CHECK-GI-NEXT:    bfi x0, x1, #32, #32
; CHECK-GI-NEXT:    bfi x1, x1, #32, #32
; CHECK-GI-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-GI-NEXT:  .LBB0_2: // %cleanup
; CHECK-GI-NEXT:    ret
entry:
  %0 = tail call { i128, i1 } @llvm.uadd.with.overflow.i128(i128 %x, i128 %y)
  %1 = extractvalue { i128, i1 } %0, 1
  br i1 %1, label %if.then, label %if.end

if.then:
  %call = tail call i32 @error()
  %conv1 = sext i32 %call to i128
  br label %cleanup

if.end:
  %2 = extractvalue { i128, i1 } %0, 0
  br label %cleanup

cleanup:
  %retval.0 = phi i128 [ %conv1, %if.then ], [ %2, %if.end ]
  ret i128 %retval.0
}

define i128 @test_sadd_i128(i128 noundef %x, i128 noundef %y) {
; CHECK-SD-LABEL: test_sadd_i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    adds x0, x0, x2
; CHECK-SD-NEXT:    adcs x1, x1, x3
; CHECK-SD-NEXT:    b.vc .LBB1_2
; CHECK-SD-NEXT:  // %bb.1: // %if.then
; CHECK-SD-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    bl error
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    sxtw x0, w0
; CHECK-SD-NEXT:    asr x1, x0, #63
; CHECK-SD-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-SD-NEXT:  .LBB1_2: // %cleanup
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_sadd_i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    adds x0, x0, x2
; CHECK-GI-NEXT:    adcs x1, x1, x3
; CHECK-GI-NEXT:    b.vc .LBB1_2
; CHECK-GI-NEXT:  // %bb.1: // %if.then
; CHECK-GI-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    bl error
; CHECK-GI-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-GI-NEXT:    asr w1, w0, #31
; CHECK-GI-NEXT:    bfi x0, x1, #32, #32
; CHECK-GI-NEXT:    bfi x1, x1, #32, #32
; CHECK-GI-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-GI-NEXT:  .LBB1_2: // %cleanup
; CHECK-GI-NEXT:    ret
entry:
  %0 = tail call { i128, i1 } @llvm.sadd.with.overflow.i128(i128 %x, i128 %y)
  %1 = extractvalue { i128, i1 } %0, 1
  br i1 %1, label %if.then, label %if.end

if.then:
  %call = tail call i32 @error()
  %conv1 = sext i32 %call to i128
  br label %cleanup

if.end:
  %2 = extractvalue { i128, i1 } %0, 0
  br label %cleanup

cleanup:
  %retval.0 = phi i128 [ %conv1, %if.then ], [ %2, %if.end ]
  ret i128 %retval.0
}

define i128 @test_usub_i128(i128 noundef %x, i128 noundef %y) {
; CHECK-SD-LABEL: test_usub_i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    subs x0, x0, x2
; CHECK-SD-NEXT:    sbcs x1, x1, x3
; CHECK-SD-NEXT:    b.hs .LBB2_2
; CHECK-SD-NEXT:  // %bb.1: // %if.then
; CHECK-SD-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    bl error
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    sxtw x0, w0
; CHECK-SD-NEXT:    asr x1, x0, #63
; CHECK-SD-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-SD-NEXT:  .LBB2_2: // %cleanup
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_usub_i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    subs x0, x0, x2
; CHECK-GI-NEXT:    sbcs x1, x1, x3
; CHECK-GI-NEXT:    b.hs .LBB2_2
; CHECK-GI-NEXT:  // %bb.1: // %if.then
; CHECK-GI-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    bl error
; CHECK-GI-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-GI-NEXT:    asr w1, w0, #31
; CHECK-GI-NEXT:    bfi x0, x1, #32, #32
; CHECK-GI-NEXT:    bfi x1, x1, #32, #32
; CHECK-GI-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-GI-NEXT:  .LBB2_2: // %cleanup
; CHECK-GI-NEXT:    ret
entry:
  %0 = tail call { i128, i1 } @llvm.usub.with.overflow.i128(i128 %x, i128 %y)
  %1 = extractvalue { i128, i1 } %0, 1
  br i1 %1, label %if.then, label %if.end

if.then:
  %call = tail call i32 @error()
  %conv1 = sext i32 %call to i128
  br label %cleanup

if.end:
  %2 = extractvalue { i128, i1 } %0, 0
  br label %cleanup

cleanup:
  %retval.0 = phi i128 [ %conv1, %if.then ], [ %2, %if.end ]
  ret i128 %retval.0
}

define i128 @test_ssub_i128(i128 noundef %x, i128 noundef %y) {
; CHECK-SD-LABEL: test_ssub_i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    subs x0, x0, x2
; CHECK-SD-NEXT:    sbcs x1, x1, x3
; CHECK-SD-NEXT:    b.vc .LBB3_2
; CHECK-SD-NEXT:  // %bb.1: // %if.then
; CHECK-SD-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    bl error
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    sxtw x0, w0
; CHECK-SD-NEXT:    asr x1, x0, #63
; CHECK-SD-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-SD-NEXT:  .LBB3_2: // %cleanup
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_ssub_i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    subs x0, x0, x2
; CHECK-GI-NEXT:    sbcs x1, x1, x3
; CHECK-GI-NEXT:    b.vc .LBB3_2
; CHECK-GI-NEXT:  // %bb.1: // %if.then
; CHECK-GI-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    bl error
; CHECK-GI-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-GI-NEXT:    asr w1, w0, #31
; CHECK-GI-NEXT:    bfi x0, x1, #32, #32
; CHECK-GI-NEXT:    bfi x1, x1, #32, #32
; CHECK-GI-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-GI-NEXT:  .LBB3_2: // %cleanup
; CHECK-GI-NEXT:    ret
entry:
  %0 = tail call { i128, i1 } @llvm.ssub.with.overflow.i128(i128 %x, i128 %y)
  %1 = extractvalue { i128, i1 } %0, 1
  br i1 %1, label %if.then, label %if.end

if.then:
  %call = tail call i32 @error()
  %conv1 = sext i32 %call to i128
  br label %cleanup

if.end:
  %2 = extractvalue { i128, i1 } %0, 0
  br label %cleanup

cleanup:
  %retval.0 = phi i128 [ %conv1, %if.then ], [ %2, %if.end ]
  ret i128 %retval.0
}

define i128 @test_umul_i128(i128 noundef %x, i128 noundef %y) {
; CHECK-LABEL: test_umul_i128:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul x9, x3, x0
; CHECK-NEXT:    cmp x1, #0
; CHECK-NEXT:    ccmp x3, #0, #4, ne
; CHECK-NEXT:    umulh x8, x1, x2
; CHECK-NEXT:    umulh x10, x3, x0
; CHECK-NEXT:    madd x9, x1, x2, x9
; CHECK-NEXT:    ccmp xzr, x8, #0, eq
; CHECK-NEXT:    umulh x11, x0, x2
; CHECK-NEXT:    ccmp xzr, x10, #0, eq
; CHECK-NEXT:    cset w8, ne
; CHECK-NEXT:    adds x1, x11, x9
; CHECK-NEXT:    csinc w8, w8, wzr, lo
; CHECK-NEXT:    cmp w8, #1
; CHECK-NEXT:    b.ne .LBB4_2
; CHECK-NEXT:  // %bb.1: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl error
; CHECK-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-NEXT:    sxtw x0, w0
; CHECK-NEXT:    asr x1, x0, #63
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB4_2: // %if.end
; CHECK-NEXT:    mul x0, x0, x2
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i128, i1 } @llvm.umul.with.overflow.i128(i128 %x, i128 %y)
  %1 = extractvalue { i128, i1 } %0, 1
  br i1 %1, label %if.then, label %if.end

if.then:
  %call = tail call i32 @error()
  %conv1 = sext i32 %call to i128
  br label %cleanup

if.end:
  %2 = extractvalue { i128, i1 } %0, 0
  br label %cleanup

cleanup:
  %retval.0 = phi i128 [ %conv1, %if.then ], [ %2, %if.end ]
  ret i128 %retval.0
}

define i128 @test_smul_i128(i128 noundef %x, i128 noundef %y) {
; CHECK-LABEL: test_smul_i128:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    asr x10, x1, #63
; CHECK-NEXT:    umulh x11, x0, x2
; CHECK-NEXT:    asr x14, x3, #63
; CHECK-NEXT:    mov x8, x1
; CHECK-NEXT:    mul x12, x1, x2
; CHECK-NEXT:    umulh x9, x1, x2
; CHECK-NEXT:    mul x10, x10, x2
; CHECK-NEXT:    adds x11, x12, x11
; CHECK-NEXT:    mul x15, x0, x3
; CHECK-NEXT:    umulh x13, x0, x3
; CHECK-NEXT:    adc x9, x9, x10
; CHECK-NEXT:    mul x14, x0, x14
; CHECK-NEXT:    mul x16, x1, x3
; CHECK-NEXT:    adds x1, x15, x11
; CHECK-NEXT:    asr x11, x9, #63
; CHECK-NEXT:    smulh x8, x8, x3
; CHECK-NEXT:    adc x10, x13, x14
; CHECK-NEXT:    asr x12, x10, #63
; CHECK-NEXT:    adds x9, x9, x10
; CHECK-NEXT:    adc x10, x11, x12
; CHECK-NEXT:    adds x9, x16, x9
; CHECK-NEXT:    asr x11, x1, #63
; CHECK-NEXT:    adc x8, x8, x10
; CHECK-NEXT:    eor x8, x8, x11
; CHECK-NEXT:    eor x9, x9, x11
; CHECK-NEXT:    orr x8, x9, x8
; CHECK-NEXT:    cbz x8, .LBB5_2
; CHECK-NEXT:  // %bb.1: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl error
; CHECK-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-NEXT:    sxtw x0, w0
; CHECK-NEXT:    asr x1, x0, #63
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB5_2: // %if.end
; CHECK-NEXT:    mul x0, x0, x2
; CHECK-NEXT:    ret
entry:
  %0 = tail call { i128, i1 } @llvm.smul.with.overflow.i128(i128 %x, i128 %y)
  %1 = extractvalue { i128, i1 } %0, 1
  br i1 %1, label %if.then, label %if.end

if.then:
  %call = tail call i32 @error()
  %conv1 = sext i32 %call to i128
  br label %cleanup

if.end:
  %2 = extractvalue { i128, i1 } %0, 0
  br label %cleanup

cleanup:
  %retval.0 = phi i128 [ %conv1, %if.then ], [ %2, %if.end ]
  ret i128 %retval.0
}

declare i32 @error()
