/* msiextract.c generated by valac 0.44.9, the Vala compiler
 * generated from msiextract.vala, do not modify */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <libmsi.h>
#include <libgcab.h>
#include <stdio.h>
#include <config.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Block1Data {
	int _ref_count_;
	GHashTable* cab_to_name;
};

extern gboolean version;
gboolean version = FALSE;
extern gboolean list_only;
gboolean list_only = FALSE;
extern gchar** files;
gchar** files = NULL;
extern gchar* directory;
gchar* directory = NULL;

gchar* get_long_name (const gchar* str);
gchar* lookup_cab (const gchar* dir,
                   const gchar* cab,
                   GError** error);
void extract_cab (LibmsiDatabase* db,
                  const gchar* cab,
                  GHashTable* cab_to_name,
                  GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block1Data* _data1_,
                     GCabFile* current);
static gboolean ___lambda4__gcab_file_callback (GCabFile* file,
                                         gpointer self);
gchar* get_directory_name (LibmsiRecord* rec,
                           GError** error);
void extract (const gchar* filename,
              GError** error);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
gint _vala_main (gchar** args,
                 gint args_length1);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[5] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &version, N_ ("Display version number"), NULL}, {"directory", 'C', 0, G_OPTION_ARG_FILENAME, &directory, N_ ("Extract to directory"), NULL}, {"list", 'l', 0, G_OPTION_ARG_NONE, &list_only, N_ ("List files only"), NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &files, NULL, N_ ("MSI_FILE...")}, {NULL}};

gchar*
get_long_name (const gchar* str)
{
	gchar** names = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp6_;
	gchar* result = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (str, "|", 2);
	names = _tmp1_;
	names_length1 = _vala_array_length (_tmp0_);
	_names_size_ = names_length1;
	_tmp2_ = names;
	_tmp2__length1 = names_length1;
	if (_tmp2__length1 == 2) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = names;
		_tmp3__length1 = names_length1;
		_tmp4_ = _tmp3_[1];
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp6_ = g_strdup (str);
	result = _tmp6_;
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

gchar*
lookup_cab (const gchar* dir,
            const gchar* cab,
            GError** error)
{
	GFile* path = NULL;
	GFile* _tmp0_;
	GFileEnumerator* children = NULL;
	GFile* _tmp1_;
	GFileEnumerator* _tmp2_;
	gchar* CAB = NULL;
	gchar* _tmp3_;
	GFileInfo* info = NULL;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (dir != NULL, NULL);
	g_return_val_if_fail (cab != NULL, NULL);
	_tmp0_ = g_file_new_for_path (dir);
	path = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = g_file_enumerate_children (_tmp1_, "standard::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	children = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (path);
		return NULL;
	}
	_tmp3_ = g_utf8_strup (cab, (gssize) -1);
	CAB = _tmp3_;
	info = NULL;
	while (TRUE) {
		GFileInfo* _tmp4_ = NULL;
		GFileEnumerator* _tmp5_;
		GFileInfo* _tmp6_;
		GFileInfo* _tmp7_;
		GFileInfo* _tmp8_;
		GFileInfo* _tmp9_;
		GFileInfo* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp15_;
		_tmp5_ = children;
		_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			_g_free0 (CAB);
			_g_object_unref0 (children);
			_g_object_unref0 (path);
			return NULL;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (info);
		info = _tmp7_;
		_tmp8_ = info;
		if (!(_tmp8_ != NULL)) {
			_g_object_unref0 (_tmp4_);
			break;
		}
		_tmp9_ = info;
		if (g_file_info_get_file_type (_tmp9_) == G_FILE_TYPE_DIRECTORY) {
			_g_object_unref0 (_tmp4_);
			continue;
		}
		_tmp10_ = info;
		_tmp11_ = g_file_info_get_name (_tmp10_);
		_tmp12_ = g_utf8_strup (_tmp11_, (gssize) -1);
		_tmp13_ = _tmp12_;
		_tmp14_ = CAB;
		_tmp15_ = g_strcmp0 (_tmp13_, _tmp14_) == 0;
		_g_free0 (_tmp13_);
		if (_tmp15_) {
			GFile* _tmp16_;
			GFileInfo* _tmp17_;
			const gchar* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp16_ = path;
			_tmp17_ = info;
			_tmp18_ = g_file_info_get_name (_tmp17_);
			_tmp19_ = g_file_get_child (_tmp16_, _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_file_get_path (_tmp20_);
			_tmp22_ = _tmp21_;
			_g_object_unref0 (_tmp20_);
			result = _tmp22_;
			_g_object_unref0 (_tmp4_);
			_g_object_unref0 (info);
			_g_free0 (CAB);
			_g_object_unref0 (children);
			_g_object_unref0 (path);
			return result;
		}
		_g_object_unref0 (_tmp4_);
	}
	_tmp23_ = path;
	_tmp24_ = g_file_get_child (_tmp23_, cab);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_file_get_path (_tmp25_);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (_tmp25_);
	result = _tmp27_;
	_g_object_unref0 (info);
	_g_free0 (CAB);
	_g_object_unref0 (children);
	_g_object_unref0 (path);
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_hash_table_unref0 (_data1_->cab_to_name);
		g_slice_free (Block1Data, _data1_);
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
__lambda4_ (Block1Data* _data1_,
            GCabFile* current)
{
	gchar* extname = NULL;
	const gchar* _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp7_;
	FILE* _tmp8_;
	const gchar* _tmp9_;
	gboolean result = FALSE;
	g_return_val_if_fail (current != NULL, FALSE);
	_tmp0_ = gcab_file_get_name (current);
	_tmp1_ = g_hash_table_lookup (_data1_->cab_to_name, _tmp0_);
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	extname = _tmp2_;
	_tmp3_ = extname;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = gcab_file_get_name (current);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (extname);
		extname = _tmp5_;
		_tmp6_ = extname;
		g_warning ("msiextract.vala:73: couldn't lookup MSI name, fallback on cab name %s", _tmp6_);
	}
	_tmp7_ = extname;
	gcab_file_set_extract_name (current, _tmp7_);
	_tmp8_ = stdout;
	_tmp9_ = extname;
	fprintf (_tmp8_, "%s\n", _tmp9_);
	result = TRUE;
	_g_free0 (extname);
	return result;
}

static gboolean
___lambda4__gcab_file_callback (GCabFile* file,
                                gpointer self)
{
	gboolean result;
	result = __lambda4_ (self, file);
	return result;
}

void
extract_cab (LibmsiDatabase* db,
             const gchar* cab,
             GHashTable* cab_to_name,
             GError** error)
{
	Block1Data* _data1_;
	GHashTable* _tmp0_;
	GCabCabinet* cabinet = NULL;
	GCabCabinet* _tmp1_;
	GFile* path = NULL;
	const gchar* _tmp44_;
	GFile* _tmp45_;
	GCabCabinet* _tmp46_;
	GFile* _tmp47_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (db != NULL);
	g_return_if_fail (cab != NULL);
	g_return_if_fail (cab_to_name != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = _g_hash_table_ref0 (cab_to_name);
	_g_hash_table_unref0 (_data1_->cab_to_name);
	_data1_->cab_to_name = _tmp0_;
	_tmp1_ = gcab_cabinet_new ();
	cabinet = _tmp1_;
	if (g_str_has_prefix (cab, "#")) {
		gchar* name = NULL;
		gchar* _tmp2_;
		LibmsiQuery* query = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		LibmsiQuery* _tmp6_;
		LibmsiQuery* _tmp7_;
		LibmsiQuery* _tmp8_;
		LibmsiRecord* rec = NULL;
		LibmsiQuery* _tmp9_;
		LibmsiRecord* _tmp10_;
		GCabCabinet* _tmp11_;
		LibmsiRecord* _tmp12_;
		GInputStream* _tmp13_;
		GInputStream* _tmp14_;
		_tmp2_ = string_substring (cab, (glong) 1, (glong) -1);
		name = _tmp2_;
		_tmp3_ = name;
		_tmp4_ = g_strdup_printf ("SELECT `Data` FROM `_Streams` WHERE `Name` = '%s'", _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = libmsi_query_new (db, _tmp5_, &_inner_error0_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		query = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (name);
			_g_object_unref0 (cabinet);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return;
		}
		_tmp8_ = query;
		libmsi_query_execute (_tmp8_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (query);
			_g_free0 (name);
			_g_object_unref0 (cabinet);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return;
		}
		_tmp9_ = query;
		_tmp10_ = libmsi_query_fetch (_tmp9_, &_inner_error0_);
		rec = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (query);
			_g_free0 (name);
			_g_object_unref0 (cabinet);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return;
		}
		_tmp11_ = cabinet;
		_tmp12_ = rec;
		_tmp13_ = libmsi_record_get_stream (_tmp12_, (guint) 1);
		_tmp14_ = _tmp13_;
		gcab_cabinet_load (_tmp11_, _tmp14_, NULL, &_inner_error0_);
		_g_object_unref0 (_tmp14_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (rec);
			_g_object_unref0 (query);
			_g_free0 (name);
			_g_object_unref0 (cabinet);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return;
		}
		_g_object_unref0 (rec);
		_g_object_unref0 (query);
		_g_free0 (name);
	} else {
		GFile* dbpath = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
		gchar* _tmp22_ = NULL;
		GFile* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		g_object_get (db, "path", &_tmp15_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = g_file_new_for_path (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_file_get_parent (_tmp19_);
		_tmp21_ = _tmp20_;
		_g_object_unref0 (_tmp19_);
		_g_free0 (_tmp17_);
		dbpath = _tmp21_;
		_tmp23_ = dbpath;
		_tmp24_ = g_file_get_path (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = lookup_cab (_tmp25_, cab, &_inner_error0_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_tmp22_ = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (dbpath);
			_g_object_unref0 (cabinet);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return;
		}
		cab = _tmp22_;
		{
			GFileInputStream* _tmp28_ = NULL;
			GFile* _tmp29_;
			GFile* _tmp30_;
			GFileInputStream* _tmp31_;
			GFileInputStream* _tmp32_;
			GCabCabinet* _tmp33_;
			_tmp29_ = g_file_new_for_path (cab);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_file_read (_tmp30_, NULL, &_inner_error0_);
			_tmp32_ = _tmp31_;
			_g_object_unref0 (_tmp30_);
			_tmp28_ = _tmp32_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp33_ = cabinet;
			gcab_cabinet_load (_tmp33_, (GInputStream*) _tmp28_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp28_);
				goto __catch0_g_error;
			}
			_g_object_unref0 (_tmp28_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp34_;
			GError* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			GError* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			GError* _tmp42_;
			GError* _tmp43_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp34_ = err;
			_tmp35_ = err;
			_tmp36_ = g_strconcat (cab, ": ", NULL);
			_tmp37_ = _tmp36_;
			_tmp38_ = err;
			_tmp39_ = _tmp38_->message;
			_tmp40_ = g_strconcat (_tmp37_, _tmp39_, NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_error_new (_tmp34_->domain, _tmp35_->code, "%s", _tmp41_);
			_tmp43_ = _tmp42_;
			_g_free0 (_tmp41_);
			_g_free0 (_tmp37_);
			_inner_error0_ = _tmp43_;
			_g_error_free0 (err);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp22_);
			_g_object_unref0 (dbpath);
			_g_object_unref0 (cabinet);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return;
		}
		_g_free0 (_tmp22_);
		_g_object_unref0 (dbpath);
	}
	_tmp44_ = directory;
	_tmp45_ = g_file_new_for_path (_tmp44_);
	path = _tmp45_;
	_tmp46_ = cabinet;
	_tmp47_ = path;
	gcab_cabinet_extract_simple (_tmp46_, _tmp47_, ___lambda4__gcab_file_callback, _data1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (path);
		_g_object_unref0 (cabinet);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_g_object_unref0 (path);
	_g_object_unref0 (cabinet);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

gchar*
get_directory_name (LibmsiRecord* rec,
                    GError** error)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gchar* result = NULL;
	g_return_val_if_fail (rec != NULL, NULL);
	_tmp0_ = libmsi_record_get_string (rec, (guint) 3);
	_tmp1_ = _tmp0_;
	_tmp2_ = get_long_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	name = _tmp3_;
	_tmp4_ = libmsi_record_get_string (rec, (guint) 1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, "ProgramFilesFolder") == 0;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("Program Files");
		result = _tmp7_;
		_g_free0 (name);
		return result;
	} else {
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_;
		_tmp9_ = name;
		if (g_strcmp0 (_tmp9_, ".") == 0) {
			_tmp8_ = TRUE;
		} else {
			const gchar* _tmp10_;
			_tmp10_ = name;
			_tmp8_ = g_strcmp0 (_tmp10_, "SourceDir") == 0;
		}
		if (_tmp8_) {
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("");
			result = _tmp11_;
			_g_free0 (name);
			return result;
		}
	}
	result = name;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
extract (const gchar* filename,
         GError** error)
{
	LibmsiRecord* rec = NULL;
	LibmsiDatabase* db = NULL;
	LibmsiDatabase* _tmp0_;
	GHashTable* directories = NULL;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	LibmsiQuery* query = NULL;
	LibmsiDatabase* _tmp4_;
	LibmsiQuery* _tmp5_;
	LibmsiQuery* _tmp6_;
	GHashTable* components_dir = NULL;
	GHashFunc _tmp17_;
	GEqualFunc _tmp18_;
	GHashTable* _tmp19_;
	LibmsiQuery* _tmp20_ = NULL;
	LibmsiDatabase* _tmp21_;
	LibmsiQuery* _tmp22_;
	LibmsiQuery* _tmp23_;
	LibmsiQuery* _tmp24_;
	GHashTable* cab_to_name = NULL;
	GHashFunc _tmp59_;
	GEqualFunc _tmp60_;
	GHashTable* _tmp61_;
	LibmsiQuery* _tmp62_ = NULL;
	LibmsiDatabase* _tmp63_;
	LibmsiQuery* _tmp64_;
	LibmsiQuery* _tmp65_;
	LibmsiQuery* _tmp66_;
	LibmsiQuery* _tmp94_ = NULL;
	LibmsiDatabase* _tmp95_;
	LibmsiQuery* _tmp96_;
	LibmsiQuery* _tmp97_;
	LibmsiQuery* _tmp98_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (filename != NULL);
	_tmp0_ = libmsi_database_new (filename, (guint) LIBMSI_DB_FLAGS_READONLY, NULL, &_inner_error0_);
	db = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (rec);
		return;
	}
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	directories = _tmp3_;
	_tmp4_ = db;
	_tmp5_ = libmsi_query_new (_tmp4_, "SELECT * FROM `Directory`", &_inner_error0_);
	query = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	_tmp6_ = query;
	libmsi_query_execute (_tmp6_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	while (TRUE) {
		LibmsiRecord* _tmp7_ = NULL;
		LibmsiQuery* _tmp8_;
		LibmsiRecord* _tmp9_;
		LibmsiRecord* _tmp10_;
		LibmsiRecord* _tmp11_;
		GHashTable* _tmp12_;
		LibmsiRecord* _tmp13_;
		gchar* _tmp14_;
		LibmsiRecord* _tmp15_;
		LibmsiRecord* _tmp16_;
		_tmp8_ = query;
		_tmp9_ = libmsi_query_fetch (_tmp8_, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (query);
			_g_hash_table_unref0 (directories);
			_g_object_unref0 (db);
			_g_object_unref0 (rec);
			return;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (rec);
		rec = _tmp10_;
		_tmp11_ = rec;
		if (!(_tmp11_ != NULL)) {
			_g_object_unref0 (_tmp7_);
			break;
		}
		_tmp12_ = directories;
		_tmp13_ = rec;
		_tmp14_ = libmsi_record_get_string (_tmp13_, (guint) 1);
		_tmp15_ = rec;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		g_hash_table_insert (_tmp12_, _tmp14_, _tmp16_);
		_g_object_unref0 (_tmp7_);
	}
	_tmp17_ = g_str_hash;
	_tmp18_ = g_str_equal;
	_tmp19_ = g_hash_table_new_full (_tmp17_, _tmp18_, _g_free0_, _g_free0_);
	components_dir = _tmp19_;
	_tmp21_ = db;
	_tmp22_ = libmsi_query_new (_tmp21_, "SELECT * FROM `Component`", &_inner_error0_);
	_tmp20_ = _tmp22_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_hash_table_unref0 (components_dir);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	_tmp23_ = _tmp20_;
	_tmp20_ = NULL;
	_g_object_unref0 (query);
	query = _tmp23_;
	_tmp24_ = query;
	libmsi_query_execute (_tmp24_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp20_);
		_g_hash_table_unref0 (components_dir);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	while (TRUE) {
		LibmsiRecord* _tmp25_ = NULL;
		LibmsiQuery* _tmp26_;
		LibmsiRecord* _tmp27_;
		LibmsiRecord* _tmp28_;
		LibmsiRecord* _tmp29_;
		gchar* dir_id = NULL;
		LibmsiRecord* _tmp30_;
		gchar* _tmp31_;
		LibmsiRecord* dir_rec = NULL;
		GHashTable* _tmp32_;
		const gchar* _tmp33_;
		gconstpointer _tmp34_;
		LibmsiRecord* _tmp35_;
		gchar* dir = NULL;
		LibmsiRecord* _tmp36_;
		gchar* _tmp37_;
		GHashTable* _tmp54_;
		LibmsiRecord* _tmp55_;
		gchar* _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp26_ = query;
		_tmp27_ = libmsi_query_fetch (_tmp26_, &_inner_error0_);
		_tmp25_ = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp20_);
			_g_hash_table_unref0 (components_dir);
			_g_object_unref0 (query);
			_g_hash_table_unref0 (directories);
			_g_object_unref0 (db);
			_g_object_unref0 (rec);
			return;
		}
		_tmp28_ = _tmp25_;
		_tmp25_ = NULL;
		_g_object_unref0 (rec);
		rec = _tmp28_;
		_tmp29_ = rec;
		if (!(_tmp29_ != NULL)) {
			_g_object_unref0 (_tmp25_);
			break;
		}
		_tmp30_ = rec;
		_tmp31_ = libmsi_record_get_string (_tmp30_, (guint) 3);
		dir_id = _tmp31_;
		_tmp32_ = directories;
		_tmp33_ = dir_id;
		_tmp34_ = g_hash_table_lookup (_tmp32_, _tmp33_);
		_tmp35_ = _g_object_ref0 ((LibmsiRecord*) _tmp34_);
		dir_rec = _tmp35_;
		_tmp36_ = dir_rec;
		_tmp37_ = get_directory_name (_tmp36_, &_inner_error0_);
		dir = _tmp37_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (dir_rec);
			_g_free0 (dir_id);
			_g_object_unref0 (_tmp25_);
			_g_object_unref0 (_tmp20_);
			_g_hash_table_unref0 (components_dir);
			_g_object_unref0 (query);
			_g_hash_table_unref0 (directories);
			_g_object_unref0 (db);
			_g_object_unref0 (rec);
			return;
		}
		while (TRUE) {
			gchar* parent = NULL;
			LibmsiRecord* _tmp38_;
			gchar* _tmp39_;
			GHashTable* _tmp40_;
			const gchar* _tmp41_;
			gconstpointer _tmp42_;
			LibmsiRecord* _tmp43_;
			LibmsiRecord* _tmp44_;
			gchar* _tmp45_ = NULL;
			LibmsiRecord* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			gchar* _tmp53_;
			_tmp38_ = dir_rec;
			_tmp39_ = libmsi_record_get_string (_tmp38_, (guint) 2);
			parent = _tmp39_;
			_tmp40_ = directories;
			_tmp41_ = parent;
			_tmp42_ = g_hash_table_lookup (_tmp40_, _tmp41_);
			_tmp43_ = _g_object_ref0 ((LibmsiRecord*) _tmp42_);
			_g_object_unref0 (dir_rec);
			dir_rec = _tmp43_;
			_tmp44_ = dir_rec;
			if (_tmp44_ == NULL) {
				_g_free0 (parent);
				break;
			}
			_tmp46_ = dir_rec;
			_tmp47_ = get_directory_name (_tmp46_, &_inner_error0_);
			_tmp45_ = _tmp47_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (parent);
				_g_free0 (dir);
				_g_object_unref0 (dir_rec);
				_g_free0 (dir_id);
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (_tmp20_);
				_g_hash_table_unref0 (components_dir);
				_g_object_unref0 (query);
				_g_hash_table_unref0 (directories);
				_g_object_unref0 (db);
				_g_object_unref0 (rec);
				return;
			}
			_tmp48_ = _tmp45_;
			_tmp45_ = NULL;
			_g_free0 (parent);
			parent = _tmp48_;
			_tmp49_ = parent;
			if (_tmp49_ == NULL) {
				_g_free0 (_tmp45_);
				_g_free0 (parent);
				break;
			}
			_tmp50_ = parent;
			if (g_strcmp0 (_tmp50_, "") == 0) {
				_g_free0 (_tmp45_);
				_g_free0 (parent);
				continue;
			}
			_tmp51_ = parent;
			_tmp52_ = dir;
			_tmp53_ = g_build_filename (_tmp51_, _tmp52_, NULL);
			_g_free0 (dir);
			dir = _tmp53_;
			_g_free0 (_tmp45_);
			_g_free0 (parent);
		}
		_tmp54_ = components_dir;
		_tmp55_ = rec;
		_tmp56_ = libmsi_record_get_string (_tmp55_, (guint) 1);
		_tmp57_ = dir;
		_tmp58_ = g_strdup (_tmp57_);
		g_hash_table_insert (_tmp54_, _tmp56_, _tmp58_);
		_g_free0 (dir);
		_g_object_unref0 (dir_rec);
		_g_free0 (dir_id);
		_g_object_unref0 (_tmp25_);
	}
	_tmp59_ = g_str_hash;
	_tmp60_ = g_str_equal;
	_tmp61_ = g_hash_table_new_full (_tmp59_, _tmp60_, _g_free0_, _g_free0_);
	cab_to_name = _tmp61_;
	_tmp63_ = db;
	_tmp64_ = libmsi_query_new (_tmp63_, "SELECT * FROM `File`", &_inner_error0_);
	_tmp62_ = _tmp64_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_hash_table_unref0 (cab_to_name);
		_g_object_unref0 (_tmp20_);
		_g_hash_table_unref0 (components_dir);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	_tmp65_ = _tmp62_;
	_tmp62_ = NULL;
	_g_object_unref0 (query);
	query = _tmp65_;
	_tmp66_ = query;
	libmsi_query_execute (_tmp66_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp62_);
		_g_hash_table_unref0 (cab_to_name);
		_g_object_unref0 (_tmp20_);
		_g_hash_table_unref0 (components_dir);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	while (TRUE) {
		LibmsiRecord* _tmp67_ = NULL;
		LibmsiQuery* _tmp68_;
		LibmsiRecord* _tmp69_;
		LibmsiRecord* _tmp70_;
		LibmsiRecord* _tmp71_;
		gchar* dir = NULL;
		GHashTable* _tmp72_;
		LibmsiRecord* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gconstpointer _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* file = NULL;
		const gchar* _tmp79_;
		LibmsiRecord* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		GHashTable* _tmp89_;
		LibmsiRecord* _tmp90_;
		gchar* _tmp91_;
		const gchar* _tmp92_;
		gchar* _tmp93_;
		_tmp68_ = query;
		_tmp69_ = libmsi_query_fetch (_tmp68_, &_inner_error0_);
		_tmp67_ = _tmp69_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp62_);
			_g_hash_table_unref0 (cab_to_name);
			_g_object_unref0 (_tmp20_);
			_g_hash_table_unref0 (components_dir);
			_g_object_unref0 (query);
			_g_hash_table_unref0 (directories);
			_g_object_unref0 (db);
			_g_object_unref0 (rec);
			return;
		}
		_tmp70_ = _tmp67_;
		_tmp67_ = NULL;
		_g_object_unref0 (rec);
		rec = _tmp70_;
		_tmp71_ = rec;
		if (!(_tmp71_ != NULL)) {
			_g_object_unref0 (_tmp67_);
			break;
		}
		_tmp72_ = components_dir;
		_tmp73_ = rec;
		_tmp74_ = libmsi_record_get_string (_tmp73_, (guint) 2);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_hash_table_lookup (_tmp72_, _tmp75_);
		_tmp77_ = g_strdup ((const gchar*) _tmp76_);
		_tmp78_ = _tmp77_;
		_g_free0 (_tmp75_);
		dir = _tmp78_;
		_tmp79_ = dir;
		_tmp80_ = rec;
		_tmp81_ = libmsi_record_get_string (_tmp80_, (guint) 3);
		_tmp82_ = _tmp81_;
		_tmp83_ = get_long_name (_tmp82_);
		_tmp84_ = _tmp83_;
		_tmp85_ = g_build_filename (_tmp79_, _tmp84_, NULL);
		_tmp86_ = _tmp85_;
		_g_free0 (_tmp84_);
		_g_free0 (_tmp82_);
		file = _tmp86_;
		if (list_only) {
			FILE* _tmp87_;
			const gchar* _tmp88_;
			_tmp87_ = stdout;
			_tmp88_ = file;
			fprintf (_tmp87_, "%s\n", _tmp88_);
		}
		_tmp89_ = cab_to_name;
		_tmp90_ = rec;
		_tmp91_ = libmsi_record_get_string (_tmp90_, (guint) 1);
		_tmp92_ = file;
		_tmp93_ = g_strdup (_tmp92_);
		g_hash_table_insert (_tmp89_, _tmp91_, _tmp93_);
		_g_free0 (file);
		_g_free0 (dir);
		_g_object_unref0 (_tmp67_);
	}
	if (list_only) {
		exit (0);
	}
	_tmp95_ = db;
	_tmp96_ = libmsi_query_new (_tmp95_, "SELECT * FROM `Media`", &_inner_error0_);
	_tmp94_ = _tmp96_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp62_);
		_g_hash_table_unref0 (cab_to_name);
		_g_object_unref0 (_tmp20_);
		_g_hash_table_unref0 (components_dir);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	_tmp97_ = _tmp94_;
	_tmp94_ = NULL;
	_g_object_unref0 (query);
	query = _tmp97_;
	_tmp98_ = query;
	libmsi_query_execute (_tmp98_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp94_);
		_g_object_unref0 (_tmp62_);
		_g_hash_table_unref0 (cab_to_name);
		_g_object_unref0 (_tmp20_);
		_g_hash_table_unref0 (components_dir);
		_g_object_unref0 (query);
		_g_hash_table_unref0 (directories);
		_g_object_unref0 (db);
		_g_object_unref0 (rec);
		return;
	}
	while (TRUE) {
		LibmsiRecord* _tmp99_ = NULL;
		LibmsiQuery* _tmp100_;
		LibmsiRecord* _tmp101_;
		LibmsiRecord* _tmp102_;
		LibmsiRecord* _tmp103_;
		gchar* cab = NULL;
		LibmsiRecord* _tmp104_;
		gchar* _tmp105_;
		const gchar* _tmp106_;
		LibmsiDatabase* _tmp107_;
		const gchar* _tmp108_;
		GHashTable* _tmp109_;
		_tmp100_ = query;
		_tmp101_ = libmsi_query_fetch (_tmp100_, &_inner_error0_);
		_tmp99_ = _tmp101_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp94_);
			_g_object_unref0 (_tmp62_);
			_g_hash_table_unref0 (cab_to_name);
			_g_object_unref0 (_tmp20_);
			_g_hash_table_unref0 (components_dir);
			_g_object_unref0 (query);
			_g_hash_table_unref0 (directories);
			_g_object_unref0 (db);
			_g_object_unref0 (rec);
			return;
		}
		_tmp102_ = _tmp99_;
		_tmp99_ = NULL;
		_g_object_unref0 (rec);
		rec = _tmp102_;
		_tmp103_ = rec;
		if (!(_tmp103_ != NULL)) {
			_g_object_unref0 (_tmp99_);
			break;
		}
		_tmp104_ = rec;
		_tmp105_ = libmsi_record_get_string (_tmp104_, (guint) 4);
		cab = _tmp105_;
		_tmp106_ = cab;
		if (g_strcmp0 (_tmp106_, "") == 0) {
			_g_free0 (cab);
			_g_object_unref0 (_tmp99_);
			continue;
		}
		_tmp107_ = db;
		_tmp108_ = cab;
		_tmp109_ = cab_to_name;
		extract_cab (_tmp107_, _tmp108_, _tmp109_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (cab);
			_g_object_unref0 (_tmp99_);
			_g_object_unref0 (_tmp94_);
			_g_object_unref0 (_tmp62_);
			_g_hash_table_unref0 (cab_to_name);
			_g_object_unref0 (_tmp20_);
			_g_hash_table_unref0 (components_dir);
			_g_object_unref0 (query);
			_g_hash_table_unref0 (directories);
			_g_object_unref0 (db);
			_g_object_unref0 (rec);
			return;
		}
		_g_free0 (cab);
		_g_object_unref0 (_tmp99_);
	}
	_g_object_unref0 (_tmp94_);
	_g_object_unref0 (_tmp62_);
	_g_hash_table_unref0 (cab_to_name);
	_g_object_unref0 (_tmp20_);
	_g_hash_table_unref0 (components_dir);
	_g_object_unref0 (query);
	_g_hash_table_unref0 (directories);
	_g_object_unref0 (db);
	_g_object_unref0 (rec);
}

gint
_vala_main (gchar** args,
            gint args_length1)
{
	gchar* parameter_string = NULL;
	gchar* _tmp0_;
	GOptionContext* opt_context = NULL;
	const gchar* _tmp1_;
	GOptionContext* _tmp2_;
	GOptionContext* _tmp3_;
	GOptionContext* _tmp4_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp17_;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name ("msiextract");
	_tmp0_ = g_strdup (_ ("- a msi files extracting tool"));
	parameter_string = _tmp0_;
	_tmp1_ = parameter_string;
	_tmp2_ = g_option_context_new (_tmp1_);
	opt_context = _tmp2_;
	_tmp3_ = opt_context;
	g_option_context_set_help_enabled (_tmp3_, TRUE);
	_tmp4_ = opt_context;
	g_option_context_add_main_entries (_tmp4_, options, NULL);
	{
		GOptionContext* _tmp5_;
		_tmp5_ = opt_context;
		g_option_context_parse (_tmp5_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp6_ = -1;
			if (g_error_matches (_inner_error0_, G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE)) {
				goto __catch1_g_option_error_bad_value;
			}
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch1_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			_g_free0 (parameter_string);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	goto __finally1;
	__catch1_g_option_error_bad_value:
	{
		GError* err = NULL;
		FILE* _tmp7_;
		GOptionContext* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = stdout;
		_tmp8_ = opt_context;
		_tmp9_ = g_option_context_get_help (_tmp8_, TRUE, NULL);
		_tmp10_ = _tmp9_;
		fprintf (_tmp7_, "%s", _tmp10_);
		_g_free0 (_tmp10_);
		exit (1);
		_g_error_free0 (err);
	}
	goto __finally1;
	__catch1_g_option_error:
	{
		GError* _error_ = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = _error_;
		_tmp12_ = _tmp11_->message;
		g_warning ("msiextract.vala:171: %s", _tmp12_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp13_ = -1;
		_g_option_context_free0 (opt_context);
		_g_free0 (parameter_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp13_;
	}
	if (version) {
		FILE* _tmp14_;
		_tmp14_ = stdout;
		fprintf (_tmp14_, "%s\n", PACKAGE_VERSION);
		exit (0);
	}
	_tmp15_ = files;
	_tmp15__length1 = _vala_array_length (files);
	if (_tmp15__length1 < 1) {
		FILE* _tmp16_;
		_tmp16_ = stderr;
		fprintf (_tmp16_, "%s", _ ("Please specify input files.\n"));
		exit (1);
	}
	_tmp17_ = directory;
	if (_tmp17_ == NULL) {
		gchar* _tmp18_;
		_tmp18_ = g_get_current_dir ();
		_g_free0 (directory);
		directory = _tmp18_;
	}
	{
		gchar** _tmp19_;
		gint _tmp19__length1;
		_tmp19_ = files;
		_tmp19__length1 = _vala_array_length (files);
		{
			gchar** file_collection = NULL;
			gint file_collection_length1 = 0;
			gint _file_collection_size_ = 0;
			gint file_it = 0;
			file_collection = _tmp19_;
			file_collection_length1 = _tmp19__length1;
			for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
				gchar* _tmp20_;
				gchar* file = NULL;
				_tmp20_ = g_strdup (file_collection[file_it]);
				file = _tmp20_;
				{
					const gchar* _tmp21_;
					_tmp21_ = file;
					extract (_tmp21_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (file);
						goto __catch2_g_error;
					}
					_g_free0 (file);
				}
			}
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		FILE* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = stderr;
		_tmp23_ = _error_;
		_tmp24_ = _tmp23_->message;
		fprintf (_tmp22_, "%s\n", _tmp24_);
		exit (1);
		_g_error_free0 (_error_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp25_ = -1;
		_g_option_context_free0 (opt_context);
		_g_free0 (parameter_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp25_;
	}
	result = 0;
	_g_option_context_free0 (opt_context);
	_g_free0 (parameter_string);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

